/*
 * Enum_DM1_DM2.h
 *
 *  Created on: 9 juli 2021
 *      Author: Daniel Mårtensson
 */

#ifndef SAE_J1939_ENUMS_SAE_J1939_ENUM_DM1_DM2_H_
#define SAE_J1939_ENUMS_SAE_J1939_ENUM_DM1_DM2_H_

/* Notice that the DM2 error messages is previously activated DM1 error messages */
typedef enum {
	/* FMI codes */
	FMI_ABOVE_NORMAL_MOST_SEVERE = 0x0U,
	FMI_BELOW_NORMAL_MOST_SEVERE = 0x1U,
	FMI_DATA_ERRATIC = 0x2U,
	FMI_VOLTAGE_ABOVE_NORMAL = 0x3U,
	FMI_VOLTAGE_BELOW_NORMAL = 0x4U,
	FMI_CURRENT_BELOW_NORMAL = 0x5U,
	FMI_CURRENT_ABOVE_NORMAL = 0x6U,
	FMI_MECHANICAL_SYSTEM_NOT_RESPONDING = 0x7U,
	FMI_ABNORMAL_FREQUENCY = 0x8U,
	FMI_ABNORMAL_UPDATE_RATE = 0x9U,
	FMI_ABNORMAL_RATE_OF_CHANGE = 0xAU,
	FMI_ROOT_CAUSE_NOT_KNOWN = 0xBU,
	FMI_BAD_INTELLIGENT_DEVICE = 0xCU,
	FMI_OUT_OF_CALIBRATION = 0xDU,
	FMI_SPECIAL_INSTRUCTIONS = 0xEU,
	FMI_ABOVE_NORMAL_LEAST_SEVERE = 0xFU,
	FMI_ABOVE_NORMAL_MODERATELY_SEVERE = 0x10U,
	FMI_BELOW_NORMAL_LEAST_SEVERE = 0x11U,
	FMI_BELOW_NORMAL_MODERATELY_SEVERE = 0x12U,
	FMI_RECEIVED_NETWORK_DATA_IN_ERROR = 0x13U,
	FMI_DATA_DRIFTED_HIGH = 0x14U,
	FMI_DATA_DRIFTED_LOW = 0x15U,
	FMI_NOT_AVAILABLE = 0x1FU,
	/* SPN codes */
	SPN_ENGINE_FUEL_FILTER_SUCTION_SIDE_DIFFERENTIAL_PRESSURE_1 = 0x10U,
	SPN_ENGINE_EXTENDED_RANGE_FUEL_PRESSURE = 0x12U,
	SPN_ENGINE_EXTENDED_RANGE_ENGINE_OIL_PRESSURE = 0x13U,
	SPN_ENGINE_EXTENDED_RANGE_ENGINE_COOLANT_PRESSURE = 0x14U,
	SPN_ENGINE_ECU_TEMPERATURE_1 = 0x15U,
	SPN_ENGINE_EXTENDED_CRANKCASE_BLOWBY_PRESSURE_1 = 0x16U,
	SPN_GENERATOR_OIL_PRESSURE = 0x17U,
	SPN_GENERATOR_COOLANT_TEMPERATURE = 0x18U,
	SPN_EGR_1_VALVE_POSITION = 0x1BU,
	SPN_ACCELERATOR_PEDAL_POSITION_3 = 0x1CU,
	SPN_ACCELERATOR_PEDAL_POSITION_2 = 0x1DU,
	SPN_ENGINE_CRANKCASE_BLOWBY_PRESSURE = 0x1EU,
	SPN_TRANSMISSION_RANGE_POSITION = 0x1FU,
	SPN_TRANSMISSION_SPLITTER_POSITION = 0x20U,
	SPN_CLUTCH_CYLINDER_POSITION = 0x21U,
	SPN_CLUTCH_PLATES = 0x24U,
	SPN_TRANSMISSION_AIR_TANK_PRESSURE = 0x25U,
	SPN_SECOND_FUEL_LEVEL = 0x26U,
	SPN_TIRE_PRESSURE_CHECK_INTERVAL = 0x27U,
	SPN_PNEUMATIC_SUPPLY_PRESSURE = 0x2EU,
	SPN_EXTENDED_RANGE_BAROMETRIC_PRESSURE = 0x30U,
	SPN_ENGINE_THROTTLE_POSITION = 0x33U,
	SPN_ENGINE_INTERCOOLER_TEMPERATURE = 0x34U,
	SPN_TRANSMISSION_SYNCHRONIZER_CLUTCH_VALUE = 0x35U,
	SPN_TRANSMISSION_SYNCHRONIZER_BRAKE_VALUE = 0x36U,
	SPN_TRANSMISSION_SHIFT_FINGER_GEAR_POSITION = 0x3BU,
	SPN_TRANSMISSION_SHIFT_FINGER_RAIL_POSITION = 0x3CU,
	SPN_TRANSMISSION_2_OIL_TEMPERATURE = 0x40U,
	SPN_TWO_SPEED_AXLE_SWITCH = 0x45U,
	SPN_PARKING_BRAKE_SWITCH = 0x46U,
	SPN_ENGINE_BLOWER_BYPASS_VALVE_POSITION = 0x48U,
	SPN_AUXILIARY_PUMP_PRESSURE = 0x49U,
	SPN_MAXIMUM_VEHICLE_SPEED_LIMIT = 0x4AU,
	SPN_STEERING_AXLE_TEMPERATURE = 0x4BU,
	SPN_AXLE_LIFT_AIR_PRESSURE = 0x4CU,
	SPN_FORWARD_REAR_DRIVE_AXLE_TEMPERATURE = 0x4DU,
	SPN_REAR_REAR_DRIVE_AXLE_TEMPERATURE = 0x4EU,
	SPN_ROAD_SURFACE_TEMPERATURE = 0x4FU,
	SPN_WASHER_FLUID_LEVEL = 0x50U,
	SPN_ENGINE_PARTICULATE_TRAP_INLET_PRESSURE = 0x51U,
	SPN_ENGINE_AIR_START_PRESSURE = 0x52U,
	SPN_WHEELBASED_VEHICLE_SPEED = 0x54U,
	SPN_CRUISE_CONTROL_SET_SPEED = 0x56U,
	SPN_CRUISE_CONTROL_HIGH_SET_LIMIT_SPEED = 0x57U,
	SPN_CRUISE_CONTROL_LOW_SET_LIMIT_SPEED = 0x58U,
	SPN_POWER_TAKEOFF_OIL_TEMPERATURE = 0x5AU,
	SPN_ACCELERATOR_PEDAL_POSITION_1 = 0x5BU,
	SPN_ENGINE_PERCENT_LOAD_AT_CURRENT_SPEED = 0x5CU,
	SPN_ENGINE_NET_BRAKE_TORQUE = 0x5DU,
	SPN_ENGINE_FUEL_DELIVERY_PRESSURE_1 = 0x5EU,
	SPN_ENGINE_FUEL_FILTER_DIFFERENTIAL_PRESSURE = 0x5FU,
	SPN_FUEL_LEVEL = 0x60U,
	SPN_WATER_IN_FUEL_INDICATOR = 0x61U,
	SPN_ENGINE_OIL_LEVEL = 0x62U,
	SPN_ENGINE_OIL_FILTER_DIFFERENTIAL_PRESSURE = 0x63U,
	SPN_ENGINE_OIL_PRESSURE = 0x64U,
	SPN_ENGINE_CRANKCASE_PRESSURE = 0x65U,
	SPN_ENGINE_INTAKE_MANIFOLD_1_PRESSURE = 0x66U,
	SPN_ENGINE_TURBOCHARGER_1_SPEED = 0x67U,
	SPN_ENGINE_TURBOCHARGER_LUBE_OIL_PRESSURE_1 = 0x68U,
	SPN_ENGINE_INTAKE_MANIFOLD_1_TEMPERATURE = 0x69U,
	SPN_ENGINE_AIR_INLET_PRESSURE = 0x6AU,
	SPN_ENGINE_AIR_FILTER_1_DIFFERENTIAL_PRESSURE = 0x6BU,
	SPN_BAROMETRIC_PRESSURE = 0x6CU,
	SPN_ENGINE_COOLANT_PRESSURE = 0x6DU,
	SPN_ENGINE_COOLANT_TEMPERATURE_1 = 0x6EU,
	SPN_ENGINE_COOLANT_LEVEL = 0x6FU,
	SPN_ENGINE_COOLANT_FILTER_DIFFERENTIAL_PRESSURE = 0x70U,
	SPN_ENGINE_GOVERNOR_DROOP = 0x71U,
	SPN_NET_BATTERY_CURRENT_1 = 0x72U,
	SPN_ALTERNATOR_CURRENT_1 = 0x73U,
	SPN_BRAKE_APPLICATION_PRESSURE = 0x74U,
	SPN_BRAKE_PRIMARY_PRESSURE = 0x75U,
	SPN_BRAKE_SECONDARY_PRESSURE = 0x76U,
	SPN_HYDRAULIC_RETARDER_PRESSURE = 0x77U,
	SPN_HYDRAULIC_RETARDER_OIL_TEMPERATURE = 0x78U,
	SPN_ENGINE_RETARDER_PERCENT = 0x7AU,
	SPN_CLUTCH_PRESSURE = 0x7BU,
	SPN_TRANSMISSION_OIL_LEVEL = 0x7CU,
	SPN_TRANSMISSION_FILTER_DIFFERENTIAL_PRESSURE = 0x7EU,
	SPN_TRANSMISSION_OIL_PRESSURE = 0x7FU,
	SPN_ENGINE_INJECTOR_METERING_RAIL_2_PRESSURE_1 = 0x81U,
	SPN_ENGINE_POWER_SPECIFIC_FUEL_ECONOMY = 0x82U,
	SPN_ENGINE_EXHAUST_BACK_PRESSURE = 0x83U,
	SPN_ENGINE_INLET_AIR_MASS_FLOW_RATE = 0x84U,
	SPN_ENGINE_AVERAGE_FUEL_RATE = 0x85U,
	SPN_ENGINE_FUEL_DELIVERY_PRESSURE_2 = 0x87U,
	SPN_AUXILIARY_VACUUM_PRESSURE_READING = 0x88U,
	SPN_AUXILIARY_GAGE_PRESSURE_READING_1 = 0x89U,
	SPN_AUXILIARY_ABSOLUTE_PRESSURE_READING = 0x8AU,
	SPN_TRAILER_TAG_OR_PUSH_CHANNEL_TIRE_PRESSURE_TARGET = 0x8DU,
	SPN_DRIVE_CHANNEL_TIRE_PRESSURE_TARGET = 0x8EU,
	SPN_STEER_CHANNEL_TIRE_PRESSURE_TARGET = 0x8FU,
	SPN_TRAILER_TAG_OR_PUSH_CHANNEL_TIRE_PRESSURE = 0x90U,
	SPN_DRIVE_CHANNEL_TIRE_PRESSURE = 0x91U,
	SPN_STEER_CHANNEL_TIRE_PRESSURE = 0x92U,
	SPN_ENGINE_AVERAGE_FUEL_ECONOMY_1 = 0x93U,
	SPN_ENGINE_INSTANTANEOUS_FUEL_ECONOMY_1 = 0x94U,
	SPN_ENGINE_MASS_FLOW_RATE = 0x95U,
	SPN_NUMBER_OF_ECU_RESETS = 0x98U,
	SPN_ENGINE_HIGH_RESOLUTION_CRANKCASE_PRESSURE = 0x99U,
	SPN_ENGINE_INJECTOR_TIMING_RAIL_1_PRESSURE = 0x9CU,
	SPN_ENGINE_INJECTOR_METERING_RAIL_1_PRESSURE = 0x9DU,
	SPN_KEYSWITCH_BATTERY_POTENTIAL = 0x9EU,
	SPN_ENGINE_GAS_SUPPLY_PRESSURE = 0x9FU,
	SPN_MAIN_SHAFT_SPEED = 0xA0U,
	SPN_TRANSMISSION_INPUT_SHAFT_SPEED = 0xA1U,
	SPN_TRANSMISSION_REQUESTED_RANGE = 0xA2U,
	SPN_TRANSMISSION_CURRENT_RANGE = 0xA3U,
	SPN_ENGINE_INJECTION_CONTROL_PRESSURE = 0xA4U,
	SPN_COMPASS_BEARING = 0xA5U,
	SPN_ENGINE_RATED_POWER = 0xA6U,
	SPN_CHARGING_SYSTEM_POTENTIAL = 0xA7U,
	SPN_BATTERY_POTENTIAL__POWER_INPUT_1 = 0xA8U,
	SPN_CARGO_AMBIENT_TEMPERATURE = 0xA9U,
	SPN_CAB_INTERIOR_TEMPERATURE = 0xAAU,
	SPN_AMBIENT_AIR_TEMPERATURE = 0xABU,
	SPN_ENGINE_AIR_INLET_TEMPERATURE = 0xACU,
	SPN_ENGINE_EXHAUST_GAS_TEMPERATURE = 0xADU,
	SPN_ENGINE_FUEL_TEMPERATURE_1 = 0xAEU,
	SPN_ENGINE_OIL_TEMPERATURE_1 = 0xAFU,
	SPN_ENGINE_TURBOCHARGER_OIL_TEMPERATURE = 0xB0U,
	SPN_TRANSMISSION_OIL_TEMPERATURE = 0xB1U,
	SPN_FRONT_AXLE_WEIGHT = 0xB2U,
	SPN_REAR_AXLE_WEIGHT = 0xB3U,
	SPN_TRAILER_WEIGHT = 0xB4U,
	SPN_CARGO_WEIGHT = 0xB5U,
	SPN_ENGINE_TRIP_FUEL = 0xB6U,
	SPN_ENGINE_FUEL_RATE = 0xB7U,
	SPN_ENGINE_INSTANTANEOUS_FUEL_ECONOMY_2 = 0xB8U,
	SPN_ENGINE_AVERAGE_FUEL_ECONOMY_2 = 0xB9U,
	SPN_POWER_TAKEOFF_SPEED = 0xBAU,
	SPN_POWER_TAKEOFF_SET_SPEED = 0xBBU,
	SPN_ENGINE_SPEED_AT_IDLE_POINT_1 = 0xBCU,
	SPN_ENGINE_RATED_SPEED = 0xBDU,
	SPN_ENGINE_SPEED = 0xBEU,
	SPN_TRANSMISSION_OUTPUT_SHAFT_SPEED = 0xBFU,
	SPN_SPEED_SENSOR_CALIBRATION = 0xE4U,
	SPN_TOTAL_FUEL_USED_GASEOUS = 0xE5U,
	SPN_TOTAL_IDLE_FUEL_USED_GASEOUS = 0xE6U,
	SPN_TRIP_FUEL_GASEOUS = 0xE7U,
	SPN_DGPS_DIFFERENTIAL_CORRECTION = 0xE8U,
	SPN_UNIT_NUMBER = 0xE9U,
	SPN_SOFTWARE_IDENTIFICATION = 0xEAU,
	SPN_ENGINE_TOTAL_IDLE_HOURS = 0xEBU,
	SPN_ENGINE_TOTAL_IDLE_FUEL_USED = 0xECU,
	SPN_VEHICLE_IDENTIFICATION_NUMBER = 0xEDU,
	SPN_VELOCITY_VECTOR = 0xEEU,
	SPN_TIRE_PRESSURE = 0xF1U,
	SPN_TIRE_TEMPERATURE = 0xF2U,
	SPN_TRIP_DISTANCE = 0xF4U,
	SPN_TOTAL_VEHICLE_DISTANCE = 0xF5U,
	SPN_TOTAL_VEHICLE_HOURS = 0xF6U,
	SPN_ENGINE_TOTAL_HOURS_OF_OPERATION = 0xF7U,
	SPN_TOTAL_POWER_TAKEOFF_HOURS = 0xF8U,
	SPN_ENGINE_TOTAL_REVOLUTIONS = 0xF9U,
	SPN_ENGINE_TOTAL_FUEL_USED = 0xFAU,
	SPN_TIME = 0xFBU,
	SPN_DATE = 0xFCU,
	SPN_COLD_RESTART_OF_SPECIFIC_COMPONENT = 0x101U,
	SPN_WARM_RESTART_OF_SPECIFIC_COMPONENT = 0x102U,
	SPN_ACKNOWLEDGEMENT_OF_WARM_OR_COLD_RESTART = 0x103U,
	SPN_RELATIVE_HUMIDITY = 0x162U,
	SPN_ENGINE_OIL_LIFE = 0x163U,
	SPN_FARE_COLLECTION_UNIT_STATUS = 0x17AU,
	SPN_ARTICULATION_ANGLE_1 = 0x17CU,
	SPN_VEHICLE_ACCELERATION = 0x17FU,
	SPN_ENGINE_EXHAUST_GAS_RECIRCULATION_DIFFERENTIAL_PRESSURE = 0x19BU,
	SPN_ENGINE_EXHAUST_GAS_RECIRCULATION_TEMPERATURE = 0x19CU,
	SPN_ENGINE_STARTER_SOLENOID_VOLTAGE = 0x1AEU,
	SPN_AUXILIARY_TEMPERATURE_1 = 0x1B9U,
	SPN_AUXILIARY_TEMPERATURE_2 = 0x1BAU,
	SPN_AUXILIARY_GAGE_PRESSURE_READING_2 = 0x1BBU,
	SPN_BATTERY_POTENTIAL__POWER_INPUT_2 = 0x1BCU,
	SPN_ENGINE_CYLINDER_HEAD_TEMPERATURE_BANK_B = 0x1BDU,
	SPN_ENGINE_CYLINDER_HEAD_TEMPERATURE_BANK_A = 0x1BEU,
	SPN_PASSENGER_COUNTER = 0x1BFU,
	SPN_SIGNAGE_MESSAGE = 0x1F5U,
	SPN_FARE_COLLECTION_UNIT_POINT_OF_SALE = 0x1F6U,
	SPN_FARE_COLLECTION_UNIT_SERVICE_DETAIL = 0x1F7U,
	SPN_ANNUNCIATOR_VOICE_MESSAGE = 0x1F8U,
	SPN_VEHICLE_CONTROL_HEAD_KEYBOARD_MESSAGE = 0x1F9U,
	SPN_VEHICLE_CONTROL_HEAD_DISPLAY_MESSAGE = 0x1FAU,
	SPN_DRIVER_IDENTIFICATION = 0x1FBU,
	SPN_TRANSIT_ROUTE_IDENTIFICATION = 0x1FCU,
	SPN_MILEPOST_IDENTIFICATION = 0x1FDU,
	SPN_DRIVERS_DEMAND_ENGINE_PERCENT_TORQUE = 0x200U,
	SPN_ACTUAL_ENGINE_PERCENT_TORQUE = 0x201U,
	SPN_NOMINAL_FRICTION_PERCENT_TORQUE = 0x202U,
	SPN_ENGINES_DESIRED_OPERATING_SPEED = 0x203U,
	SPN_GROUNDBASED_VEHICLE_SPEED = 0x204U,
	SPN_NAVIGATIONBASED_VEHICLE_SPEED = 0x205U,
	SPN_ENGINE_REQUESTED_TORQUETORQUE_LIMIT = 0x206U,
	SPN_ENGINES_DESIRED_OPERATING_SPEED_ASYMMETRY_ADJUSTMENT = 0x207U,
	SPN_ACTUAL_RETARDER_PERCENT_TORQUE = 0x208U,
	SPN_BRAKE_PEDAL_POSITION = 0x209U,
	SPN_PERCENT_CLUTCH_SLIP = 0x20AU,
	SPN_TRANSMISSION_CURRENT_GEAR = 0x20BU,
	SPN_TRANSMISSION_SELECTED_GEAR = 0x20CU,
	SPN_TRANSMISSION_REQUESTED_GEAR = 0x20DU,
	SPN_TRANSMISSION_ACTUAL_GEAR_RATIO = 0x20EU,
	SPN_CRUISE_CONTROL_STATES = 0x20FU,
	SPN_ENGINE_SPEED_AT_POINT_2 = 0x210U,
	SPN_ENGINE_SPEED_AT_POINT_3 = 0x211U,
	SPN_ENGINE_SPEED_AT_POINT_4 = 0x212U,
	SPN_ENGINE_SPEED_AT_POINT_5 = 0x213U,
	SPN_ENGINE_SPEED_AT_HIGH_IDLE_POINT_6 = 0x214U,
	SPN_ENGINE_MAXIMUM_MOMENTARY_OVERRIDE_SPEED_POINT_7 = 0x215U,
	SPN_ENGINE_MAXIMUM_MOMENTARY_OVERRIDE_TIME_LIMIT = 0x216U,
	SPN_ENGINE_REQUESTED_SPEED_CONTROL_RANGE_LOWER_LIMIT = 0x217U,
	SPN_ENGINE_REQUESTED_SPEED_CONTROL_RANGE_UPPER_LIMIT = 0x218U,
	SPN_ENGINE_REQUESTED_TORQUE_CONTROL_RANGE_LOWER_LIMIT = 0x219U,
	SPN_ENGINE_REQUESTED_TORQUE_CONTROL_RANGE_UPPER_LIMIT = 0x21AU,
	SPN_ENGINE_PERCENT_TORQUE_AT_IDLE_POINT_1 = 0x21BU,
	SPN_ENGINE_PERCENT_TORQUE_AT_POINT_2 = 0x21CU,
	SPN_ENGINE_PERCENT_TORQUE_AT_POINT_3 = 0x21DU,
	SPN_ENGINE_PERCENT_TORQUE_AT_POINT_4 = 0x21EU,
	SPN_ENGINE_PERCENT_TORQUE_AT_POINT_5 = 0x21FU,
	SPN_ENGINE_REFERENCE_TORQUE = 0x220U,
	SPN_ENGINE_GAIN_KP_OF_THE_ENDSPEED_GOVERNOR = 0x221U,
	SPN_RETARDER_SPEED_AT_IDLE_POINT_1 = 0x222U,
	SPN_RETARDER_SPEED_AT_PEAK_TORQUE_POINT_5 = 0x223U,
	SPN_MAXIMUM_RETARDER_SPEED_POINT_2 = 0x224U,
	SPN_RETARDER_SPEED_AT_POINT_3 = 0x225U,
	SPN_RETARDER_SPEED_AT_POINT_4 = 0x226U,
	SPN_PERCENT_TORQUE_AT_IDLE_POINT_1 = 0x227U,
	SPN_PERCENT_TORQUE_AT_MAXIMUM_SPEED_POINT_2 = 0x228U,
	SPN_PERCENT_TORQUE_AT_POINT_3 = 0x229U,
	SPN_PERCENT_TORQUE_AT_POINT_4 = 0x22AU,
	SPN_PERCENT_TORQUE_AT_PEAK_TORQUE_POINT_5 = 0x22BU,
	SPN_REFERENCE_RETARDER_TORQUE = 0x22CU,
	SPN_RETARDER_CONTROL_METHOD = 0x22DU,
	SPN_ACCELERATOR_PEDAL_1_LOW_IDLE_SWITCH = 0x22EU,
	SPN_ACCELERATOR_PEDAL_KICKDOWN_SWITCH = 0x22FU,
	SPN_TRANSMISSION_DRIVELINE_ENGAGED = 0x230U,
	SPN_TCSASR_ENGINE_CONTROL_ACTIVE = 0x231U,
	SPN_TCSASR_BRAKE_CONTROL_ACTIVE = 0x232U,
	SPN_ANTILOCK_BRAKING_ABS_ACTIVE = 0x233U,
	SPN_DIFFERENTIAL_LOCK_STATE_CENTRAL = 0x234U,
	SPN_DIFFERENTIAL_LOCK_STATE_CENTRAL_FRONT = 0x235U,
	SPN_DIFFERENTIAL_LOCK_STATE_CENTRAL_REAR = 0x236U,
	SPN_DIFFERENTIAL_LOCK_STATE_FRONT_AXLE_1 = 0x237U,
	SPN_DIFFERENTIAL_LOCK_STATE_FRONT_AXLE_2 = 0x238U,
	SPN_DIFFERENTIAL_LOCK_STATE_REAR_AXLE_1 = 0x239U,
	SPN_DIFFERENTIAL_LOCK_STATE_REAR_AXLE_2 = 0x23AU,
	SPN_RETARDER_ENABLE_BRAKE_ASSIST_SWITCH = 0x23BU,
	SPN_RETARDER_ENABLE_SHIFT_ASSIST_SWITCH = 0x23CU,
	SPN_TORQUE_CONVERTER_LOCKUP_ENGAGED = 0x23DU,
	SPN_TRANSMISSION_SHIFT_IN_PROCESS = 0x23EU,
	SPN_ABS_OFFROAD_SWITCH = 0x23FU,
	SPN_ASR_OFFROAD_SWITCH = 0x240U,
	SPN_ASR_HILL_HOLDER_SWITCH = 0x241U,
	SPN_DRIVE_AXLE_TEMPERATURE = 0x242U,
	SPN_DRIVE_AXLE_LIFT_AIR_PRESSURE = 0x243U,
	SPN_ALTITUDE = 0x244U,
	SPN_TRANSMISSION_GEAR_RATIO = 0x245U,
	SPN_AXLE_WEIGHT = 0x246U,
	SPN_PITCH = 0x247U,
	SPN_LATITUDE = 0x248U,
	SPN_LONGITUDE = 0x249U,
	SPN_MAKE = 0x24AU,
	SPN_MODEL = 0x24BU,
	SPN_SERIAL_NUMBER = 0x24CU,
	SPN_ALTERNATOR_SPEED = 0x24DU,
	SPN_ENGINE_IDLE_SHUTDOWN_TIMER_STATE = 0x24EU,
	SPN_ENGINE_IDLE_SHUTDOWN_TIMER_FUNCTION = 0x24FU,
	SPN_ENGINE_IDLE_SHUTDOWN_TIMER_OVERRIDE = 0x250U,
	SPN_ENGINE_IDLE_SHUTDOWN_HAS_SHUTDOWN_ENGINE = 0x251U,
	SPN_ENGINE_IDLE_SHUTDOWN_DRIVER_ALERT_MODE = 0x252U,
	SPN_CRUISE_CONTROL_ACTIVE = 0x253U,
	SPN_CRUISE_CONTROL_ENABLE_SWITCH = 0x254U,
	SPN_BRAKE_SWITCH = 0x255U,
	SPN_CLUTCH_SWITCH = 0x256U,
	SPN_CRUISE_CONTROL_SET_SWITCH = 0x257U,
	SPN_CRUISE_CONTROL_COAST_DECELERATE_SWITCH = 0x258U,
	SPN_CRUISE_CONTROL_RESUME_SWITCH = 0x259U,
	SPN_CRUISE_CONTROL_ACCELERATE_SWITCH = 0x25AU,
	SPN_BRAKE_PEDAL_SWITCH_2 = 0x25BU,
	SPN_TRANSMISSION_NEUTRAL_SWITCH = 0x25CU,
	SPN_REFRIGERANT_HIGH_PRESSURE_SWITCH = 0x25DU,
	SPN_ENGINE_MOMENTARY_OVERSPEED_ENABLE = 0x25EU,
	SPN_PROGRESSIVE_SHIFT_DISABLE = 0x25FU,
	SPN_J1587_PREVIOUSLY_SAE_J1708 = 0x260U,
	SPN_CONTROLLER_2 = 0x261U,
	SPN_POWER_CONNECT_DEVICE = 0x262U,
	SPN_SYSTEM_DIAGNOSTIC_CODE_1 = 0x263U,
	SPN_SYSTEM_DIAGNOSTIC_CODE_2 = 0x264U,
	SPN_SYSTEM_DIAGNOSTIC_CODE_3 = 0x265U,
	SPN_SYSTEM_DIAGNOSTIC_CODE_4 = 0x266U,
	SPN_SYSTEM_DIAGNOSTIC_CODE_5 = 0x267U,
	SPN_AUXILIARY_ANALOG_INPUT_1 = 0x268U,
	SPN_PARKING_BRAKE_ON_ACTUATOR = 0x269U,
	SPN_PARKING_BRAKE_OFF_ACTUATOR = 0x26AU,
	SPN_PARKING_BRAKE_ACTUATOR = 0x26BU,
	SPN_5_VOLTS_DC_SUPPLY = 0x26CU,
	SPN_ANTENNA_ELECTRONICS = 0x26DU,
	SPN_J1922 = 0x26EU,
	SPN_RED_STOP_LAMP = 0x26FU,
	SPN_AMBER_WARNING_LAMP = 0x270U,
	SPN_PROPRIETARY_DATA_LINK = 0x271U,
	SPN_ENGINE_START_ENABLE_DEVICE_1 = 0x272U,
	SPN_POWER_SUPPLY = 0x273U,
	SPN_PROGRAM_MEMORY = 0x274U,
	SPN_CONTROLLER_1 = 0x275U,
	SPN_CALIBRATION_MEMORY = 0x276U,
	SPN_CALIBRATION_MODULE = 0x277U,
	SPN_ENGINE_FUEL_SHUTOFF_VALVE_1 = 0x278U,
	SPN_ENGINE_FUEL_ACTUATOR_1_CONTROL_COMMAND = 0x279U,
	SPN_ENGINE_THROTTLE_BYPASS_VALVE = 0x27AU,
	SPN_ENGINE_TIMING_ACTUATOR_1 = 0x27BU,
	SPN_ENGINE_POSITION_SENSOR = 0x27CU,
	SPN_ENGINE_TIMING_SENSOR = 0x27DU,
	SPN_ENGINE_FUEL_RACK_ACTUATOR = 0x27EU,
	SPN_J1939_NETWORK_1 = 0x27FU,
	SPN_ENGINE_EXTERNAL_PROTECTION_INPUT = 0x280U,
	SPN_ENGINE_TURBOCHARGER_VARIABLE_GEOMETRY_ACTUATOR_1 = 0x281U,
	SPN_ENGINE_TURBOCHARGER_VARIABLE_GEOMETRY_ACTUATOR_2 = 0x282U,
	SPN_ENGINE_EXTERNAL_FUEL_COMMAND_INPUT = 0x283U,
	SPN_ENGINE_EXTERNAL_SPEED_COMMAND_INPUT = 0x284U,
	SPN_ENGINE_TACHOMETER_SIGNAL_OUTPUT = 0x285U,
	SPN_ENGINE_TURBOCHARGER_1_WASTEGATE_DRIVE_1 = 0x286U,
	SPN_ENGINE_FAN_CLUTCH_OUTPUT_DEVICE_DRIVER = 0x287U,
	SPN_ENGINE_EXHAUST_BACK_PRESSURE_SENSOR = 0x288U,
	SPN_ENGINE_EXHAUST_BACK_PRESSURE_REGULATOR_CONTROL_COMMAND = 0x289U,
	SPN_ELECTRONIC_DRIVE_UNIT_POWER_RELAY = 0x28AU,
	SPN_ENGINE_INJECTOR_CYLINDER_01 = 0x28BU,
	SPN_ENGINE_INJECTOR_CYLINDER_02 = 0x28CU,
	SPN_ENGINE_INJECTOR_CYLINDER_03 = 0x28DU,
	SPN_ENGINE_INJECTOR_CYLINDER_04 = 0x28EU,
	SPN_ENGINE_INJECTOR_CYLINDER_05 = 0x28FU,
	SPN_ENGINE_INJECTOR_CYLINDER_06 = 0x290U,
	SPN_ENGINE_INJECTOR_CYLINDER_07 = 0x291U,
	SPN_ENGINE_INJECTOR_CYLINDER_08 = 0x292U,
	SPN_ENGINE_INJECTOR_CYLINDER_09 = 0x293U,
	SPN_ENGINE_INJECTOR_CYLINDER_10 = 0x294U,
	SPN_ENGINE_INJECTOR_CYLINDER_11 = 0x295U,
	SPN_ENGINE_INJECTOR_CYLINDER_12 = 0x296U,
	SPN_ENGINE_INJECTOR_CYLINDER_13 = 0x297U,
	SPN_ENGINE_INJECTOR_CYLINDER_14 = 0x298U,
	SPN_ENGINE_INJECTOR_CYLINDER_15 = 0x299U,
	SPN_ENGINE_INJECTOR_CYLINDER_16 = 0x29AU,
	SPN_ENGINE_INJECTOR_CYLINDER_17 = 0x29BU,
	SPN_ENGINE_INJECTOR_CYLINDER_18 = 0x29CU,
	SPN_ENGINE_INJECTOR_CYLINDER_19 = 0x29DU,
	SPN_ENGINE_INJECTOR_CYLINDER_20 = 0x29EU,
	SPN_ENGINE_INJECTOR_CYLINDER_21 = 0x29FU,
	SPN_ENGINE_INJECTOR_CYLINDER_22 = 0x2A0U,
	SPN_ENGINE_INJECTOR_CYLINDER_23 = 0x2A1U,
	SPN_ENGINE_INJECTOR_CYLINDER_24 = 0x2A2U,
	SPN_ENGINE_GLOW_PLUG_LAMP = 0x2A3U,
	SPN_ENGINE_GLOW_PLUG_RELAY = 0x2A4U,
	SPN_ENGINE_STARTER_MOTOR_RELAY = 0x2A5U,
	SPN_ECU_8_VOLTS_DC_SUPPLY = 0x2A6U,
	SPN_ENGINE_INJECTION_CONTROL_PRESSURE_REGULATOR = 0x2A7U,
	SPN_ENGINE_VALVE_VARIABLE_SWIRL_SYSTEM = 0x2A8U,
	SPN_TRANSMISSION_GEAR_SHIFT_INHIBIT_REQUEST = 0x2A9U,
	SPN_TORQUE_CONVERTER_LOCKUP_DISABLE_REQUEST = 0x2AAU,
	SPN_DISENGAGE_DRIVELINE_REQUEST = 0x2ABU,
	SPN_REQUESTED_PERCENT_CLUTCH_SLIP = 0x2ACU,
	SPN_DISENGAGE_DIFFERENTIAL_LOCK_REQUEST_FRONT_AXLE_1 = 0x2ADU,
	SPN_DISENGAGE_DIFFERENTIAL_LOCK_REQUEST_FRONT_AXLE_2 = 0x2AEU,
	SPN_DISENGAGE_DIFFERENTIAL_LOCK_REQUEST_REAR_AXLE_1 = 0x2AFU,
	SPN_DISENGAGE_DIFFERENTIAL_LOCK_REQUEST_REAR_AXLE_2 = 0x2B0U,
	SPN_DISENGAGE_DIFFERENTIAL_LOCK_REQUEST_CENTRAL = 0x2B1U,
	SPN_DISENGAGE_DIFFERENTIAL_LOCK_REQUEST_CENTRAL_FRONT = 0x2B2U,
	SPN_DISENGAGE_DIFFERENTIAL_LOCK_REQUEST_CENTRAL_REAR = 0x2B3U,
	SPN_ABS_OFFROAD_SWITCH_REQUEST = 0x2B4U,
	SPN_ASR_OFFROAD_SWITCH_REQUEST = 0x2B5U,
	SPN_ASR_HILL_HOLDER_SWITCH_REQUEST = 0x2B6U,
	SPN_ENGINE_OVERRIDE_CONTROL_MODE = 0x2B7U,
	SPN_ENGINE_REQUESTED_SPEED_CONTROL_CONDITIONS = 0x2B8U,
	SPN_AUXILIARY_PWM_DRIVER_1 = 0x2B9U,
	SPN_AUXILIARY_PWM_DRIVER_2 = 0x2BAU,
	SPN_AUXILIARY_PWM_DRIVER_3 = 0x2BBU,
	SPN_AUXILIARY_PWM_DRIVER_4 = 0x2BCU,
	SPN_AUXILIARY_IO_01 = 0x2BDU,
	SPN_AUXILIARY_IO_02 = 0x2BEU,
	SPN_AUXILIARY_IO_03 = 0x2BFU,
	SPN_AUXILIARY_IO_04 = 0x2C0U,
	SPN_AUXILIARY_IO_05 = 0x2C1U,
	SPN_AUXILIARY_IO_06 = 0x2C2U,
	SPN_AUXILIARY_IO_07 = 0x2C3U,
	SPN_AUXILIARY_IO_08 = 0x2C4U,
	SPN_AUXILIARY_IO_09 = 0x2C5U,
	SPN_AUXILIARY_IO_10 = 0x2C6U,
	SPN_AUXILIARY_IO_11 = 0x2C7U,
	SPN_AUXILIARY_IO_12 = 0x2C8U,
	SPN_AUXILIARY_IO_13 = 0x2C9U,
	SPN_AUXILIARY_IO_14 = 0x2CAU,
	SPN_AUXILIARY_IO_15 = 0x2CBU,
	SPN_AUXILIARY_IO_16 = 0x2CCU,
	SPN_AUTOSHIFT_HIGH_GEAR_ACTUATOR = 0x2CDU,
	SPN_AUTOSHIFT_LOW_GEAR_ACTUATOR = 0x2CEU,
	SPN_AUTOSHIFT_NEUTRAL_ACTUATOR = 0x2CFU,
	SPN_AUTOSHIFT_COMMON_LOW_SIDE = 0x2D0U,
	SPN_PRESTROKE_SENSOR = 0x2D1U,
	SPN_PRESTROKE_ACTUATOR = 0x2D2U,
	SPN_ENGINE_SPEED_SENSOR_2 = 0x2D3U,
	SPN_ENGINE_OXYGEN_SENSOR_HEATED = 0x2D4U,
	SPN_ENGINE_IGNITION_CONTROL_MODE_SIGNAL = 0x2D5U,
	SPN_ENGINE_IGNITION_CONTROL_TIMING_SIGNAL = 0x2D6U,
	SPN_ENGINE_TURBOCHARGER_SECONDARY_INLET_PRESSURE = 0x2D7U,
	SPN_ENGINE_AFTER_COOLEROIL_COOLER_COOLANT_TEMPERATURE = 0x2D8U,
	SPN_ENGINE_INLET_AIR_HEATER_DRIVER_1 = 0x2D9U,
	SPN_ENGINE_INLET_AIR_HEATER_DRIVER_2 = 0x2DAU,
	SPN_ENGINE_KNOCK_SENSOR = 0x2DBU,
	SPN_ENGINE_GAS_METERING_VALVE = 0x2DCU,
	SPN_ENGINE_RACK_POSITION_SENSOR = 0x2DDU,
	SPN_TRANSMISSION_RANGE_CLUTCH_C1_SOLENOID = 0x2DEU,
	SPN_TRANSMISSION_RANGE_CLUTCH_C2_SOLENOID = 0x2DFU,
	SPN_TRANSMISSION_RANGE_CLUTCH_C3_SOLENOID = 0x2E0U,
	SPN_TRANSMISSION_RANGE_CLUTCH_C4_SOLENOID = 0x2E1U,
	SPN_TRANSMISSION_RANGE_CLUTCH_C5_SOLENOID = 0x2E2U,
	SPN_TRANSMISSION_RANGE_CLUTCH_C6_SOLENOID = 0x2E3U,
	SPN_TRANSMISSION_LOCKUP_CLUTCH_ACTUATOR = 0x2E4U,
	SPN_TRANSMISSION_FORWARD_SOLENOID_VALVE = 0x2E5U,
	SPN_TRANSMISSION_LOW_SIGNAL_SOLENOID_VALVE = 0x2E6U,
	SPN_RETARDER_ENABLE_SOLENOID_VALVE = 0x2E7U,
	SPN_RETARDER_MODULATION_SOLENOID_VALVE = 0x2E8U,
	SPN_RETARDER_RESPONSE_SOLENOID_VALVE = 0x2E9U,
	SPN_DIFFERENTIAL_LOCK_SOLENOID_VALVE_1 = 0x2EAU,
	SPN_ENGINETRANSMISSION_MATCH = 0x2EBU,
	SPN_TRANSMISSION_OUTPUT_RETARDER = 0x2ECU,
	SPN_TRANSMISSION_NEUTRAL_START_OUTPUT = 0x2EDU,
	SPN_TRANSMISSION_TURBINE_SPEED_SENSOR = 0x2EEU,
	SPN_TRANSMISSION_PRIMARY_SHIFT_SELECTOR = 0x2EFU,
	SPN_TRANSMISSION_SECONDARY_SHIFT_SELECTOR = 0x2F0U,
	SPN_TRANSMISSION_SPECIAL_FUNCTION_INPUTS = 0x2F1U,
	SPN_TRANSMISSION_RANGE_C1_CLUTCH_PRESSURE_INDICATOR = 0x2F2U,
	SPN_TRANSMISSION_RANGE_C2_CLUTCH_PRESSURE_INDICATOR = 0x2F3U,
	SPN_TRANSMISSION_RANGE_C3_CLUTCH_PRESSURE_INDICATOR = 0x2F4U,
	SPN_TRANSMISSION_RANGE_C4_CLUTCH_PRESSURE_INDICATOR = 0x2F5U,
	SPN_TRANSMISSION_RANGE_C5_CLUTCH_PRESSURE_INDICATOR = 0x2F6U,
	SPN_TRANSMISSION_RANGE_C6_CLUTCH_PRESSURE_INDICATOR = 0x2F7U,
	SPN_TRANSMISSION_LOCKUP_CLUTCH_PRESSURE_INDICATOR_1 = 0x2F8U,
	SPN_TRANSMISSION_FORWARD_RANGE_PRESSURE_INDICATOR = 0x2F9U,
	SPN_TRANSMISSION_NEUTRAL_RANGE_PRESSURE_INDICATOR = 0x2FAU,
	SPN_TRANSMISSION_REVERSE_RANGE_PRESSURE_INDICATOR = 0x2FBU,
	SPN_RETARDER_RESPONSE_SYSTEM_PRESSURE_INDICATOR = 0x2FCU,
	SPN_DIFFERENTIAL_LOCK_CLUTCH_PRESSURE_INDICATOR = 0x2FDU,
	SPN_TRANSMISSION_MULTIPLE_PRESSURE_INDICATORS = 0x2FEU,
	SPN_TRANSMISSION_REVERSE_DIRECTION_SWITCH = 0x2FFU,
	SPN_TRANSMISSION_RANGE_HIGH_ACTUATOR = 0x300U,
	SPN_TRANSMISSION_RANGE_LOW_ACTUATOR = 0x301U,
	SPN_TRANSMISSION_SPLITTER_DIRECT_ACTUATOR = 0x302U,
	SPN_TRANSMISSION_SPLITTER_INDIRECT_ACTUATOR = 0x303U,
	SPN_TRANSMISSION_SHIFT_FINGER_RAIL_ACTUATOR_1 = 0x304U,
	SPN_TRANSMISSION_SHIFT_FINGER_GEAR_ACTUATOR_1 = 0x305U,
	SPN_TRANSMISSION_UPSHIFT_REQUEST_SWITCH = 0x306U,
	SPN_TRANSMISSION_DOWNSHIFT_REQUEST_SWITCH = 0x307U,
	SPN_TORQUE_CONVERTER_INTERRUPT_ACTUATOR = 0x308U,
	SPN_TORQUE_CONVERTER_LOCKUP_ACTUATOR = 0x309U,
	SPN_TRANSMISSION_HIGH_RANGE_SENSE_SWITCH = 0x30AU,
	SPN_TRANSMISSION_LOW_RANGE_SENSE_SWITCH = 0x30BU,
	SPN_TRANSMISSION_SHIFT_FINGER_NEUTRAL_INDICATOR = 0x30CU,
	SPN_TRANSMISSION_SHIFT_FINGER_ENGAGEMENT_INDICATOR = 0x30DU,
	SPN_TRANSMISSION_SHIFT_FINGER_CENTER_RAIL_INDICATOR = 0x30EU,
	SPN_TRANSMISSION_SHIFT_FINGER_RAIL_ACTUATOR_2 = 0x30FU,
	SPN_TRANSMISSION_SHIFT_FINGER_GEAR_ACTUATOR_2 = 0x310U,
	SPN_TRANSMISSION_HYDRAULIC_SYSTEM = 0x311U,
	SPN_TRANSMISSION_DEFUEL_ACTUATOR = 0x312U,
	SPN_TRANSMISSION_INERTIA_BRAKE_ACTUATOR = 0x313U,
	SPN_TRANSMISSION_CLUTCH_ACTUATOR = 0x314U,
	SPN_WHEEL_SENSOR_ABS_AXLE_1_LEFT = 0x315U,
	SPN_WHEEL_SENSOR_ABS_AXLE_1_RIGHT = 0x316U,
	SPN_WHEEL_SENSOR_ABS_AXLE_2_LEFT = 0x317U,
	SPN_WHEEL_SENSOR_ABS_AXLE_2_RIGHT = 0x318U,
	SPN_WHEEL_SENSOR_ABS_AXLE_3_LEFT = 0x319U,
	SPN_WHEEL_SENSOR_ABS_AXLE_3_RIGHT = 0x31AU,
	SPN_PRESSURE_MODULATION_VALVE_ABS_AXLE_1_LEFT = 0x31BU,
	SPN_PRESSURE_MODULATION_VALVE_ABS_AXLE_1_RIGHT = 0x31CU,
	SPN_PRESSURE_MODULATION_VALVE_ABS_AXLE_2_LEFT = 0x31DU,
	SPN_PRESSURE_MODULATION_VALVE_ABS_AXLE_2_RIGHT = 0x31EU,
	SPN_PRESSURE_MODULATION_VALVE_ABS_AXLE_3_LEFT = 0x31FU,
	SPN_PRESSURE_MODULATION_VALVE_ABS_AXLE_3_RIGHT = 0x320U,
	SPN_RETARDER_CONTROL_RELAY = 0x321U,
	SPN_RELAY_DIAGONAL_1 = 0x322U,
	SPN_RELAY_DIAGONAL_2 = 0x323U,
	SPN_MODE_SWITCH_ABS = 0x324U,
	SPN_MODE_SWITCH_ASR = 0x325U,
	SPN_DIF_1_ASR_VALVE = 0x326U,
	SPN_DIF_2_ASR_VALVE = 0x327U,
	SPN_PNEUMATIC_ENGINE_CONTROL = 0x328U,
	SPN_ELECTRONIC_ENGINE_CONTROL = 0x329U,
	SPN_SPEED_SIGNAL_INPUT = 0x32AU,
	SPN_WARNING_LIGHT_BULB = 0x32BU,
	SPN_ASR_LIGHT_BULB = 0x32CU,
	SPN_WHEEL_SENSOR_ABS_AXLE_1_AVERAGE = 0x32DU,
	SPN_WHEEL_SENSOR_ABS_AXLE_2_AVERAGE = 0x32EU,
	SPN_WHEEL_SENSOR_ABS_AXLE_3_AVERAGE = 0x32FU,
	SPN_PRESSURE_MODULATOR_DRIVE_AXLE_RELAY_VALVE = 0x330U,
	SPN_PRESSURE_TRANSDUCER_DRIVE_AXLE_RELAY_VALVE = 0x331U,
	SPN_MASTER_CONTROL_RELAY = 0x332U,
	SPN_TRAILER_BRAKE_SLACK_OUT_OF_ADJUSTMENT_FORWARD_AXLE_LEFT = 0x333U,
	SPN_TRAILER_BRAKE_SLACK_OUT_OF_ADJUSTMENT_FORWARD_AXLE_RIGHT = 0x334U,
	SPN_TRAILER_BRAKE_SLACK_OUT_OF_ADJUSTMENT_REAR_AXLE_LEFT = 0x335U,
	SPN_TRAILER_BRAKE_SLACK_OUT_OF_ADJUSTMENT_REAR_AXLE_RIGHT = 0x336U,
	SPN_TRACTOR_BRAKE_SLACK_OUT_OF_ADJUSTMENT_AXLE_1_LEFT = 0x337U,
	SPN_TRACTOR_BRAKE_SLACK_OUT_OF_ADJUSTMENT_AXLE_1_RIGHT = 0x338U,
	SPN_TRACTOR_BRAKE_SLACK_OUT_OF_ADJUSTMENT_AXLE_2_LEFT = 0x339U,
	SPN_TRACTOR_BRAKE_SLACK_OUT_OF_ADJUSTMENT_AXLE_2_RIGHT = 0x33AU,
	SPN_TRACTOR_BRAKE_SLACK_OUT_OF_ADJUSTMENT_AXLE_3_LEFT = 0x33BU,
	SPN_TRACTOR_BRAKE_SLACK_OUT_OF_ADJUSTMENT_AXLE_3_RIGHT = 0x33CU,
	SPN_LEFT_FUEL_LEVEL_SENSOR = 0x33DU,
	SPN_RIGHT_FUEL_LEVEL_SENSOR = 0x33EU,
	SPN_ENGINE_FUEL_FEED_RATE_SENSOR = 0x33FU,
	SPN_ENGINE_FUEL_RETURN_RATE_SENSOR = 0x340U,
	SPN_FUEL_RACK_POSITION_SENSOR = 0x341U,
	SPN_FUEL_RACK_ACTUATOR = 0x342U,
	SPN_OIL_LEVEL_INDICATOR_OUTPUT = 0x343U,
	SPN_TACHOMETER_DRIVE_OUTPUT = 0x344U,
	SPN_SPEEDOMETER_DRIVE_OUTPUT = 0x345U,
	SPN_PWM_INPUT = 0x346U,
	SPN_DEAD_RECKONING_UNIT = 0x347U,
	SPN_LORAN_RECEIVER = 0x348U,
	SPN_GLOBAL_POSITIONING_SYSTEM = 0x349U,
	SPN_INTEGRATED_NAVIGATION_UNIT = 0x34AU,
	SPN_OPERATOR_CONTROL_PANEL = 0x34BU,
	SPN_PNEUMATIC_CONTROL_UNIT = 0x34CU,
	SPN_PCU_STEER_SOLENOID = 0x34DU,
	SPN_PCU_DRIVE_SOLENOID = 0x34EU,
	SPN_PCU_TRAILER_TAG_OR_PUSH_SOLENOID = 0x34FU,
	SPN_PCU_SUPPLY_SOLENOID = 0x350U,
	SPN_PCU_CONTROL_SOLENOID = 0x351U,
	SPN_PCU_DEFLATE_SOLENOID = 0x352U,
	SPN_PNEUMATIC_STEER_CHANNEL = 0x353U,
	SPN_PNEUMATIC_DRIVE_CHANNEL = 0x354U,
	SPN_PNEUMATIC_TRAILER_TAG_OR_PUSH_CHANNEL = 0x355U,
	SPN_HEATER_CIRCUIT_01 = 0x356U,
	SPN_HEATER_CIRCUIT_02 = 0x357U,
	SPN_HEATER_CIRCUIT_03 = 0x358U,
	SPN_HEATER_CIRCUIT_04 = 0x359U,
	SPN_HEATER_CIRCUIT_05 = 0x35AU,
	SPN_HEATER_CIRCUIT_06 = 0x35BU,
	SPN_HEATER_CIRCUIT_07 = 0x35CU,
	SPN_HEATER_CIRCUIT_08 = 0x35DU,
	SPN_HEATER_CIRCUIT_09 = 0x35EU,
	SPN_HEATER_CIRCUIT_10 = 0x35FU,
	SPN_HEATER_CIRCUIT_11 = 0x360U,
	SPN_HEATER_CIRCUIT_12 = 0x361U,
	SPN_HEATER_CIRCUIT_13 = 0x362U,
	SPN_HEATER_CIRCUIT_14 = 0x363U,
	SPN_HEATER_CIRCUIT_15 = 0x364U,
	SPN_HEATER_CIRCUIT_16 = 0x365U,
	SPN_HEATER_REGENERATION_SYSTEM = 0x366U,
	SPN_REFRIGERANT_CHARGE = 0x367U,
	SPN_REFRIGERANT_MOISTURE_LEVEL = 0x368U,
	SPN_NONCONDENSABLE_GAS_IN_REFRIGERANT = 0x369U,
	SPN_REFRIGERANT_FLOW_CONTROL_SOLENOID = 0x36AU,
	SPN_REFRIGERANT_LOW_PRESSURE_SWITCH = 0x36BU,
	SPN_COMPRESSOR_CLUTCH_CIRCUIT = 0x36CU,
	SPN_EVAPORATOR_THERMOSTAT_CIRCUIT = 0x36DU,
	SPN_CLEARANCE_SIDE_MARKER_IDENTIFICATION_LAMP_CIRCUIT = 0x36EU,
	SPN_LEFT_TURN_LAMP_CIRCUIT = 0x36FU,
	SPN_STOP_LAMP_CIRCUIT = 0x370U,
	SPN_RIGHT_TURN_LAMP_CIRCUIT = 0x371U,
	SPN_TAIL_LAMPLICENSE_PLATE_LAMP_CIRCUIT = 0x372U,
	SPN_AUXILIARY_LAMP_CIRCUIT = 0x373U,
	SPN_TRACTOR_MOUNTED_REAR_AXLE_SLIDER_CONTROL_UNIT = 0x374U,
	SPN_TRAILER_MOUNTED_REAR_AXLE_SLIDER_CONTROL_UNIT = 0x375U,
	SPN_HEADWAY_CONTROLLER_FORWARD_ANTENNA = 0x376U,
	SPN_HEADWAY_CONTROLLER_BRAKE_INPUT_MONITOR = 0x377U,
	SPN_HEADWAY_CONTROLLER_SPEAKER_MONITOR = 0x378U,
	SPN_HEADWAY_CONTROLLER_STEERING_SENSOR_MONITOR = 0x379U,
	SPN_HEADWAY_CONTROLLER_SPEEDOMETER_MONITOR = 0x37AU,
	SPN_HEADWAY_CONTROLLER_RIGHT_TURN_SIGNAL_MONITOR = 0x37BU,
	SPN_HEADWAY_CONTROLLER_LEFT_TURN_SIGNAL_MONITOR = 0x37CU,
	SPN_HEADWAY_CONTROLLER_CONTROL_DISPLAY_UNIT = 0x37DU,
	SPN_HEADWAY_CONTROLLER_RIGHT_SIDE_SENSOR = 0x37EU,
	SPN_HEADWAY_CONTROLLER_LEFT_SIDE_SENSOR = 0x37FU,
	SPN_HEADWAY_CONTROLLER_REAR_SENSOR = 0x380U,
	SPN_OVERRIDE_CONTROL_MODE_PRIORITY = 0x381U,
	SPN_ENGINE_REQUESTED_SPEEDSPEED_LIMIT = 0x382U,
	SPN_ENGINE_TORQUE_MODE = 0x383U,
	SPN_RETARDER_TORQUE_MODE = 0x384U,
	SPN_RETARDER_TYPE = 0x385U,
	SPN_RETARDER_LOCATION = 0x386U,
	SPN_TRANSMISSION_FORWARD_DIRECTION_SWITCH = 0x387U,
	SPN_FRONT_AXLE_SPEED = 0x388U,
	SPN_RELATIVE_SPEED__FRONT_AXLE_LEFT_WHEEL = 0x389U,
	SPN_RELATIVE_SPEED__FRONT_AXLE_RIGHT_WHEEL = 0x38AU,
	SPN_RELATIVE_SPEED__REAR_AXLE_1_LEFT_WHEEL = 0x38BU,
	SPN_RELATIVE_SPEED__REAR_AXLE_1_RIGHT_WHEEL = 0x38CU,
	SPN_RELATIVE_SPEED__REAR_AXLE_2_LEFT_WHEEL = 0x38DU,
	SPN_RELATIVE_SPEED__REAR_AXLE_2_RIGHT_WHEEL = 0x38EU,
	SPN_SERVICE_COMPONENT_IDENTIFICATION_1 = 0x38FU,
	SPN_SERVICE_COMPONENT_IDENTIFICATION_2 = 0x390U,
	SPN_SERVICE_COMPONENT_IDENTIFICATION_3 = 0x391U,
	SPN_SERVICE_DISTANCE = 0x392U,
	SPN_SERVICE_DELAYCALENDAR_TIME_BASED = 0x393U,
	SPN_SERVICE_DELAYOPERATIONAL_TIME_BASED = 0x394U,
	SPN_HIGH_RESOLUTION_TOTAL_VEHICLE_DISTANCE = 0x395U,
	SPN_HIGH_RESOLUTION_TRIP_DISTANCE = 0x396U,
	SPN_AMBIENT_LIGHT_SENSOR = 0x397U,
	SPN_AUDIBLE_ALARM = 0x398U,
	SPN_GREEN_LAMP = 0x399U,
	SPN_RIDE_HEIGHT_RELAY = 0x39AU,
	SPN_PWM_OUTPUT = 0x39BU,
	SPN_AUXILIARY_OUTPUT_1 = 0x39CU,
	SPN_AUXILIARY_OUTPUT_2 = 0x39DU,
	SPN_AUXILIARY_OUTPUT_3 = 0x39EU,
	SPN_LOCATION = 0x39FU,
	SPN_AXLE_LOCATION_1 = 0x3A0U,
	SPN_TIRE_LOCATION_1 = 0x3A1U,
	SPN_DRIVE_AXLE_LOCATION = 0x3A2U,
	SPN_ENGINE_FUEL_SUPPLY_PUMP_ACTUATOR = 0x3A3U,
	SPN_BRAKE_SYSTEM_HOLD_MODULATOR_VALVE_SOLENOID_AXLE_1_LEFT = 0x3A4U,
	SPN_BRAKE_SYSTEM_HOLD_MODULATOR_VALVE_SOLENOID_AXLE_1_RIGHT = 0x3A5U,
	SPN_BRAKE_SYSTEM_HOLD_MODULATOR_VALVE_SOLENOID_AXLE_2_LEFT = 0x3A6U,
	SPN_BRAKE_SYSTEM_HOLD_MODULATOR_VALVE_SOLENOID_AXLE_2_RIGHT = 0x3A7U,
	SPN_BRAKE_SYSTEM_HOLD_MODULATOR_VALVE_SOLENOID_AXLE_3_LEFT = 0x3A8U,
	SPN_BRAKE_SYSTEM_HOLD_MODULATOR_VALVE_SOLENOID_AXLE_3_RIGHT = 0x3A9U,
	SPN_BRAKE_SYSTEM_DUMP_MODULATOR_VALVE_SOLENOID_AXLE_1_LEFT = 0x3AAU,
	SPN_BRAKE_SYSTEM_DUMP_MODULATOR_VALVE_SOLENOID_AXLE_1_RIGHT = 0x3ABU,
	SPN_BRAKE_SYSTEM_DUMP_MODULATOR_VALVE_SOLENOID_AXLE_2_LEFT = 0x3ACU,
	SPN_BRAKE_SYSTEM_DUMP_MODULATOR_VALVE_SOLENOID_AXLE_2_RIGHT = 0x3ADU,
	SPN_BRAKE_SYSTEM_DUMP_MODULATOR_VALVE_SOLENOID_AXLE_3_LEFT = 0x3AEU,
	SPN_BRAKE_SYSTEM_DUMP_MODULATOR_VALVE_SOLENOID_AXLE_3_RIGHT = 0x3AFU,
	SPN_DRIVER_AIR_BAG_IGNITOR_LOOP = 0x3B0U,
	SPN_PASSENGER_AIR_BAG_IGNITOR_LOOP = 0x3B1U,
	SPN_LEFT_BELT_TENSIONER_IGNITOR_LOOP = 0x3B2U,
	SPN_RIGHT_BELT_TENSIONER_IGNITOR_LOOP = 0x3B3U,
	SPN_SAFETY_RESTRAINT_SYSTEM_LAMP = 0x3B4U,
	SPN_AUTOMOTIVE_SEAT_OCCUPANCY_SENSOR_PASSENGER_SIDE = 0x3B5U,
	SPN_SIDE_COLLISION_DETECTOR_LEFT = 0x3B6U,
	SPN_SIDE_BAG_IGNITOR_LOOP_1_LEFT = 0x3B7U,
	SPN_SIDE_BAG_IGNITOR_LOOP_2_LEFT = 0x3B8U,
	SPN_SIDE_COLLISION_DETECTOR_RIGHT = 0x3B9U,
	SPN_SIDE_BAG_IGNITOR_LOOP_1_RIGHT = 0x3BAU,
	SPN_SIDE_BAG_IGNITOR_LOOP_2_RIGHT = 0x3BBU,
	SPN_ROLLOVER_SENSOR = 0x3BCU,
	SPN_NUMBER_OF_FORWARD_GEAR_RATIOS = 0x3BDU,
	SPN_NUMBER_OF_REVERSE_GEAR_RATIOS = 0x3BEU,
	SPN_SECONDS = 0x3BFU,
	SPN_MINUTES = 0x3C0U,
	SPN_HOURS = 0x3C1U,
	SPN_DAY = 0x3C2U,
	SPN_MONTH = 0x3C3U,
	SPN_YEAR = 0x3C4U,
	SPN_NUMBER_OF_SOFTWARE_IDENTIFICATION_FIELDS = 0x3C5U,
	SPN_ENGINE_TEST_MODE_SWITCH = 0x3C6U,
	SPN_ENGINE_IDLE_DECREMENT_SWITCH = 0x3C7U,
	SPN_ENGINE_IDLE_INCREMENT_SWITCH = 0x3C8U,
	SPN_REMOTE_ACCELERATOR_ENABLE_SWITCH = 0x3C9U,
	SPN_ENGINE_AUXILIARY_ENGINE_SHUTDOWN_SWITCH = 0x3CAU,
	SPN_ENGINE_DERATE_SWITCH = 0x3CBU,
	SPN_ACCELERATOR_INTERLOCK_SWITCH = 0x3CCU,
	SPN_ENGINE_RETARDER_SELECTION = 0x3CDU,
	SPN_REMOTE_ACCELERATOR_PEDAL_POSITION = 0x3CEU,
	SPN_ESTIMATED_PERCENT_FAN_SPEED = 0x3CFU,
	SPN_PTO_STATE = 0x3D0U,
	SPN_FAN_DRIVE_STATE = 0x3D1U,
	SPN_ENGINE_REMOTE_PTO_VARIABLE_SPEED_CONTROL_SWITCH = 0x3D2U,
	SPN_ENGINE_REMOTE_PTO_PREPROGRAMMED_SPEED_CONTROL_SWITCH = 0x3D3U,
	SPN_ENGINE_PTO_ENABLE_SWITCH = 0x3D4U,
	SPN_ENGINE_PTO_ACCELERATE_SWITCH = 0x3D5U,
	SPN_ENGINE_PTO_RESUME_SWITCH = 0x3D6U,
	SPN_ENGINE_PTO_COASTDECELERATE_SWITCH = 0x3D7U,
	SPN_ENGINE_PTO_SET_SWITCH = 0x3D8U,
	SPN_AC_HIGH_PRESSURE_FAN_SWITCH = 0x3D9U,
	SPN_REQUESTED_PERCENT_FAN_SPEED = 0x3DAU,
	SPN_PROTECT_LAMP = 0x3DBU,
	SPN_TRIP_GROUP_1 = 0x3DCU,
	SPN_TRIP_GROUP_2_PROPRIETARY = 0x3DDU,
	SPN_TOTAL_COMPRESSION_BRAKE_DISTANCE = 0x3DEU,
	SPN_TRIP_COMPRESSION_BRAKE_DISTANCE = 0x3DFU,
	SPN_TRIP_SERVICE_BRAKE_DISTANCE = 0x3E0U,
	SPN_TRIP_SERVICE_BRAKE_APPLICATIONS = 0x3E1U,
	SPN_TRIP_FAN_ON_TIME = 0x3E2U,
	SPN_TRIP_FAN_ON_TIME_DUE_TO_THE_ENGINE_SYSTEM = 0x3E3U,
	SPN_TRIP_FAN_ON_TIME_DUE_TO_A_MANUAL_SWITCH = 0x3E4U,
	SPN_TRIP_FAN_ON_TIME_DUE_TO_THE_AC_SYSTEM = 0x3E5U,
	SPN_TRIP_DISTANCE_ON_VSL = 0x3E6U,
	SPN_TRIP_GEAR_DOWN_DISTANCE = 0x3E7U,
	SPN_TRIP_DISTANCE_IN_TOP_GEAR = 0x3E8U,
	SPN_TRIP_DRIVE_FUEL_USED_1 = 0x3E9U,
	SPN_TRIP_PTO_MOVING_FUEL_USED_1 = 0x3EAU,
	SPN_TRIP_PTO_NONMOVING_FUEL_USED_1 = 0x3EBU,
	SPN_TRIP_VEHICLE_IDLE_FUEL_USED_1 = 0x3ECU,
	SPN_TRIP_CRUISE_FUEL_USED_1 = 0x3EDU,
	SPN_TRIP_DRIVE_FUEL_ECONOMY_1 = 0x3EEU,
	SPN_TRIP_DRIVE_FUEL_USED_2 = 0x3EFU,
	SPN_TRIP_PTO_MOVING_FUEL_USED_2 = 0x3F0U,
	SPN_TRIP_PTO_NONMOVING_FUEL_USED_2 = 0x3F1U,
	SPN_TRIP_VEHICLE_IDLE_FUEL_USED_2 = 0x3F2U,
	SPN_TRIP_CRUISE_FUEL_USED_2 = 0x3F3U,
	SPN_TRIP_DRIVE_FUEL_ECONOMY_2 = 0x3F4U,
	SPN_TRIP_MAXIMUM_ENGINE_SPEED = 0x3F5U,
	SPN_TRIP_AVERAGE_ENGINE_SPEED = 0x3F6U,
	SPN_TRIP_DRIVE_AVERAGE_LOAD_FACTOR = 0x3F7U,
	SPN_TOTAL_DRIVE_AVERAGE_LOAD_FACTOR = 0x3F8U,
	SPN_TOTAL_ENGINE_CRUISE_TIME = 0x3F9U,
	SPN_TRIP_MAXIMUM_VEHICLE_SPEED = 0x3FAU,
	SPN_TRIP_CRUISE_DISTANCE = 0x3FBU,
	SPN_TRIP_NUMBER_OF_HOT_SHUTDOWNS = 0x3FCU,
	SPN_TRIP_NUMBER_OF_IDLE_SHUTDOWNS = 0x3FDU,
	SPN_TRIP_NUMBER_OF_IDLE_SHUTDOWN_OVERRIDES = 0x3FEU,
	SPN_TRIP_SUDDEN_DECELERATIONS = 0x3FFU,
	SPN_TRIP_TIME_IN_VSL = 0x400U,
	SPN_TRIP_TIME_IN_TOP_GEAR = 0x401U,
	SPN_TRIP_TIME_IN_GEAR_DOWN = 0x402U,
	SPN_TRIP_TIME_IN_DERATE_BY_ENGINE = 0x403U,
	SPN_TOTAL_ENGINE_PTO_FUEL_USED_1 = 0x404U,
	SPN_TRIP_AVERAGE_FUEL_RATE_1 = 0x405U,
	SPN_TOTAL_ENGINE_PTO_FUEL_USED_2 = 0x406U,
	SPN_TRIP_AVERAGE_FUEL_RATE_2 = 0x407U,
	SPN_TOTAL_ECU_DISTANCE = 0x408U,
	SPN_TOTAL_ECU_RUN_TIME = 0x409U,
	SPN_TRIP_CRUISE_TIME = 0x40AU,
	SPN_TRIP_PTO_TIME = 0x40BU,
	SPN_TRIP_ENGINE_RUNNING_TIME = 0x40CU,
	SPN_TRIP_IDLE_TIME = 0x40DU,
	SPN_TRIP_AIR_COMPRESSOR_ON_TIME = 0x40EU,
	SPN_TRIP_FUEL = 0x40FU,
	SPN_TOTAL_FUEL_USED = 0x410U,
	SPN_START_SIGNAL_INDICATOR = 0x411U,
	SPN_ELECTRONIC_TRACTORTRAILER_INTERFACE = 0x412U,
	SPN_INTERNAL_SENSOR_VOLTAGE_SUPPLY = 0x413U,
	SPN_HYDRAULIC_PUMP_MOTOR = 0x414U,
	SPN_BRAKE_LIGHT_SWITCH_1 = 0x415U,
	SPN_BRAKE_LIGHT_SWITCH_2 = 0x416U,
	SPN_ELECTRONIC_PRESSURE_CONTROL_AXLE_1 = 0x417U,
	SPN_PNEUMATIC_BACKUP_PRESSURE_CONTROL_AXLE_1 = 0x418U,
	SPN_BRAKE_PRESSURE_SENSING_AXLE_1 = 0x419U,
	SPN_ELECTRONIC_PRESSURE_CONTROL_AXLE_2 = 0x41AU,
	SPN_PNEUMATIC_BACKUP_PRESSURE_CONTROL_AXLE_2 = 0x41BU,
	SPN_BRAKE_PRESSURE_SENSING_AXLE_2 = 0x41CU,
	SPN_ELECTRONIC_PRESSURE_CONTROL_AXLE_3 = 0x41DU,
	SPN_PNEUMATIC_BACKUP_PRESSURE_CONTROL_AXLE_3 = 0x41EU,
	SPN_BRAKE_PRESSURE_SENSING_AXLE_3 = 0x41FU,
	SPN_ELECTRONIC_PRESSURE_CONTROL_TRAILER_CONTROL = 0x420U,
	SPN_PNEUMATIC_BACKUP_PRESSURE_CONTROL_TRAILER_CONTROL = 0x421U,
	SPN_BRAKE_PRESSURE_SENSING_TRAILER_CONTROL = 0x422U,
	SPN_AXLE_LOAD_SENSOR = 0x423U,
	SPN_LINING_WEAR_SENSOR_AXLE_1_LEFT = 0x424U,
	SPN_LINING_WEAR_SENSOR_AXLE_1_RIGHT = 0x425U,
	SPN_LINING_WEAR_SENSOR_AXLE_2_LEFT = 0x426U,
	SPN_LINING_WEAR_SENSOR_AXLE_2_RIGHT = 0x427U,
	SPN_LINING_WEAR_SENSOR_AXLE_3_LEFT = 0x428U,
	SPN_LINING_WEAR_SENSOR_AXLE_3_RIGHT = 0x429U,
	SPN_BRAKE_SIGNAL_TRANSMITTER = 0x42AU,
	SPN_BRAKE_SIGNAL_SENSOR_1 = 0x42BU,
	SPN_BRAKE_SIGNAL_SENSOR_2 = 0x42CU,
	SPN_TIRE_DIMENSION_SUPERVISION = 0x42DU,
	SPN_VEHICLE_DECELERATION_CONTROL = 0x42EU,
	SPN_COOLING_FAN_DRIVE_OUTPUT = 0x42FU,
	SPN_ENGINE_COMPRESSION_BRAKE_OUTPUT_1 = 0x430U,
	SPN_ENGINE_COMPRESSION_BRAKE_OUTPUT_2 = 0x431U,
	SPN_ENGINE_EXHAUST_BRAKE_OUTPUT = 0x432U,
	SPN_ENGINE_ELECTRIC_LIFT_PUMP_FOR_ENGINE_FUEL_SUPPLY = 0x433U,
	SPN_ENGINE_FUEL_INJECTION_PUMP_FUEL_CONTROL_VALVE = 0x434U,
	SPN_ENGINE_FUEL_INJECTION_PUMP_CONTROLLER = 0x435U,
	SPN_ENGINE_FUEL_INJECTION_PUMP_SPEEDPOSITION_SENSOR = 0x436U,
	SPN_SENSOR_SUPPLY_VOLTAGE_1 = 0x437U,
	SPN_SENSOR_SUPPLY_VOLTAGE_2 = 0x438U,
	SPN_ENGINE_WAIT_TO_START_LAMP = 0x439U,
	SPN_ENGINE_COOLANT_LOAD_INCREASE = 0x43AU,
	SPN_AUXILIARY_IO_CHANNEL_1 = 0x43BU,
	SPN_AUXILIARY_IO_CHANNEL_2 = 0x43CU,
	SPN_INTENDED_RETARDER_PERCENT_TORQUE = 0x43DU,
	SPN_PARKING_ANDOR_TRAILER_AIR_PRESSURE = 0x43EU,
	SPN_SERVICE_BRAKE_AIR_PRESSURE_CIRCUIT_1 = 0x43FU,
	SPN_SERVICE_BRAKE_AIR_PRESSURE_CIRCUIT_2 = 0x440U,
	SPN_AUXILIARY_EQUIPMENT_SUPPLY_PRESSURE = 0x441U,
	SPN_AIR_SUSPENSION_SUPPLY_PRESSURE = 0x442U,
	SPN_BRAKE_APPLICATION_PRESSURE_HIGH_RANGE_FRONT_AXLE_LEFT_WHEEL = 0x443U,
	SPN_BRAKE_APPLICATION_PRESSURE_HIGH_RANGE_FRONT_AXLE_RIGHT_WHEEL = 0x444U,
	SPN_BRAKE_APPLICATION_PRESSURE_HIGH_RANGE_REAR_AXLE_1_LEFT_WHEEL = 0x445U,
	SPN_BRAKE_APPLICATION_PRESSURE_HIGH_RANGE_REAR_AXLE_1_RIGHT_WHEEL = 0x446U,
	SPN_BRAKE_APPLICATION_PRESSURE_HIGH_RANGE_REAR_AXLE_2_LEFT_WHEEL = 0x447U,
	SPN_BRAKE_APPLICATION_PRESSURE_HIGH_RANGE_REAR_AXLE_2_RIGHT_WHEEL = 0x448U,
	SPN_BRAKE_APPLICATION_PRESSURE_HIGH_RANGE_REAR_AXLE_3_LEFT_WHEEL = 0x449U,
	SPN_BRAKE_APPLICATION_PRESSURE_HIGH_RANGE_REAR_AXLE_3_RIGHT_WHEEL = 0x44AU,
	SPN_BRAKE_LINING_REMAINING_FRONT_AXLE_LEFT_WHEEL = 0x44BU,
	SPN_BRAKE_LINING_REMAINING_FRONT_AXLE_RIGHT_WHEEL = 0x44CU,
	SPN_BRAKE_LINING_REMAINING_REAR_AXLE_1_LEFT_WHEEL = 0x44DU,
	SPN_BRAKE_LINING_REMAINING_REAR_AXLE_1_RIGHT_WHEEL = 0x44EU,
	SPN_BRAKE_LINING_REMAINING_REAR_AXLE_2_LEFT_WHEEL = 0x44FU,
	SPN_BRAKE_LINING_REMAINING_REAR_AXLE_2_RIGHT_WHEEL = 0x450U,
	SPN_BRAKE_LINING_REMAINING_REAR_AXLE_3_LEFT_WHEEL = 0x451U,
	SPN_BRAKE_LINING_REMAINING_REAR_AXLE_3_RIGHT_WHEEL = 0x452U,
	SPN_ENGINE_PROTECTION_SYSTEM_TIMER_STATE = 0x453U,
	SPN_ENGINE_PROTECTION_SYSTEM_TIMER_OVERRIDE = 0x454U,
	SPN_ENGINE_PROTECTION_SYSTEM_APPROACHING_SHUTDOWN = 0x455U,
	SPN_ENGINE_PROTECTION_SYSTEM_HAS_SHUTDOWN_ENGINE = 0x456U,
	SPN_ENGINE_PROTECTION_SYSTEM_CONFIGURATION = 0x457U,
	SPN_ENGINE_COMPRESSION_BRAKE_OUTPUT_3 = 0x458U,
	SPN_RECOMMENDED_GEAR = 0x459U,
	SPN_LOWEST_POSSIBLE_GEAR = 0x45AU,
	SPN_HIGHEST_POSSIBLE_GEAR = 0x45BU,
	SPN_ENGINE_GASEOUS_FUEL_CORRECTION_FACTOR = 0x45CU,
	SPN_ENGINE_DESIRED_RATED_EXHAUST_OXYGEN = 0x45DU,
	SPN_ENGINE_DESIRED_EXHAUST_OXYGEN = 0x45EU,
	SPN_ENGINE_ACTUAL_EXHAUST_OXYGEN = 0x45FU,
	SPN_ARTICULATION_ANGLE_2 = 0x460U,
	SPN_EBS_BRAKE_SWITCH = 0x461U,
	SPN_ENGINE_ALTERNATOR_BEARING_1_TEMPERATURE = 0x462U,
	SPN_ENGINE_ALTERNATOR_BEARING_2_TEMPERATURE = 0x463U,
	SPN_ENGINE_ALTERNATOR_WINDING_1_TEMPERATURE = 0x464U,
	SPN_ENGINE_ALTERNATOR_WINDING_2_TEMPERATURE = 0x465U,
	SPN_ENGINE_ALTERNATOR_WINDING_3_TEMPERATURE = 0x466U,
	SPN_ENGINE_TURBOCHARGER_1_BOOST_PRESSURE = 0x467U,
	SPN_ENGINE_TURBOCHARGER_2_BOOST_PRESSURE = 0x468U,
	SPN_ENGINE_TURBOCHARGER_3_BOOST_PRESSURE = 0x469U,
	SPN_ENGINE_TURBOCHARGER_4_BOOST_PRESSURE = 0x46AU,
	SPN_ENGINE_INTAKE_MANIFOLD_2_TEMPERATURE = 0x46BU,
	SPN_ENGINE_INTAKE_MANIFOLD_3_TEMPERATURE = 0x46CU,
	SPN_ENGINE_INTAKE_MANIFOLD_4_TEMPERATURE = 0x46DU,
	SPN_ENGINE_INTERCOOLER_THERMOSTAT_OPENING = 0x46EU,
	SPN_ENGINE_OIL_TEMPERATURE_2 = 0x46FU,
	SPN_ENGINE_ECU_TEMPERATURE_2 = 0x470U,
	SPN_ENGINE_EXHAUST_GAS_PORT_1_TEMPERATURE = 0x471U,
	SPN_ENGINE_EXHAUST_GAS_PORT_2_TEMPERATURE = 0x472U,
	SPN_ENGINE_EXHAUST_GAS_PORT_3_TEMPERATURE = 0x473U,
	SPN_ENGINE_EXHAUST_GAS_PORT_4_TEMPERATURE = 0x474U,
	SPN_ENGINE_EXHAUST_GAS_PORT_5_TEMPERATURE = 0x475U,
	SPN_ENGINE_EXHAUST_GAS_PORT_6_TEMPERATURE = 0x476U,
	SPN_ENGINE_EXHAUST_GAS_PORT_7_TEMPERATURE = 0x477U,
	SPN_ENGINE_EXHAUST_GAS_PORT_8_TEMPERATURE = 0x478U,
	SPN_ENGINE_EXHAUST_GAS_PORT_9_TEMPERATURE = 0x479U,
	SPN_ENGINE_EXHAUST_GAS_PORT_10_TEMPERATURE = 0x47AU,
	SPN_ENGINE_EXHAUST_GAS_PORT_11_TEMPERATURE = 0x47BU,
	SPN_ENGINE_EXHAUST_GAS_PORT_12_TEMPERATURE = 0x47CU,
	SPN_ENGINE_EXHAUST_GAS_PORT_13_TEMPERATURE = 0x47DU,
	SPN_ENGINE_EXHAUST_GAS_PORT_14_TEMPERATURE = 0x47EU,
	SPN_ENGINE_EXHAUST_GAS_PORT_15_TEMPERATURE = 0x47FU,
	SPN_ENGINE_EXHAUST_GAS_PORT_16_TEMPERATURE = 0x480U,
	SPN_ENGINE_EXHAUST_GAS_PORT_17_TEMPERATURE = 0x481U,
	SPN_ENGINE_EXHAUST_GAS_PORT_18_TEMPERATURE = 0x482U,
	SPN_ENGINE_EXHAUST_GAS_PORT_19_TEMPERATURE = 0x483U,
	SPN_ENGINE_EXHAUST_GAS_PORT_20_TEMPERATURE = 0x484U,
	SPN_ENGINE_MAIN_BEARING_1_TEMPERATURE = 0x485U,
	SPN_ENGINE_MAIN_BEARING_2_TEMPERATURE = 0x486U,
	SPN_ENGINE_MAIN_BEARING_3_TEMPERATURE = 0x487U,
	SPN_ENGINE_MAIN_BEARING_4_TEMPERATURE = 0x488U,
	SPN_ENGINE_MAIN_BEARING_5_TEMPERATURE = 0x489U,
	SPN_ENGINE_MAIN_BEARING_6_TEMPERATURE = 0x48AU,
	SPN_ENGINE_MAIN_BEARING_7_TEMPERATURE = 0x48BU,
	SPN_ENGINE_MAIN_BEARING_8_TEMPERATURE = 0x48CU,
	SPN_ENGINE_MAIN_BEARING_9_TEMPERATURE = 0x48DU,
	SPN_ENGINE_MAIN_BEARING_10_TEMPERATURE = 0x48EU,
	SPN_ENGINE_MAIN_BEARING_11_TEMPERATURE = 0x48FU,
	SPN_ENGINE_TURBOCHARGER_LUBE_OIL_PRESSURE_2 = 0x490U,
	SPN_ENGINE_TURBOCHARGER_2_SPEED = 0x491U,
	SPN_ENGINE_TURBOCHARGER_3_SPEED = 0x492U,
	SPN_ENGINE_TURBOCHARGER_4_SPEED = 0x493U,
	SPN_ENGINE_TURBOCHARGER_1_COMPRESSOR_INLET_TEMPERATURE = 0x494U,
	SPN_ENGINE_TURBOCHARGER_2_COMPRESSOR_INLET_TEMPERATURE = 0x495U,
	SPN_ENGINE_TURBOCHARGER_3_COMPRESSOR_INLET_TEMPERATURE = 0x496U,
	SPN_ENGINE_TURBOCHARGER_4_COMPRESSOR_INLET_TEMPERATURE = 0x497U,
	SPN_ENGINE_TURBOCHARGER_1_COMPRESSOR_INLET_PRESSURE = 0x498U,
	SPN_ENGINE_TURBOCHARGER_2_COMPRESSOR_INLET_PRESSURE = 0x499U,
	SPN_ENGINE_TURBOCHARGER_3_COMPRESSOR_INLET_PRESSURE = 0x49AU,
	SPN_ENGINE_TURBOCHARGER_4_COMPRESSOR_INLET_PRESSURE = 0x49BU,
	SPN_ENGINE_TURBOCHARGER_1_TURBINE_INLET_TEMPERATURE = 0x49CU,
	SPN_ENGINE_TURBOCHARGER_2_TURBINE_INLET_TEMPERATURE = 0x49DU,
	SPN_ENGINE_TURBOCHARGER_3_TURBINE_INLET_TEMPERATURE = 0x49EU,
	SPN_ENGINE_TURBOCHARGER_4_TURBINE_INLET_TEMPERATURE = 0x49FU,
	SPN_ENGINE_TURBOCHARGER_1_TURBINE_OUTLET_TEMPERATURE = 0x4A0U,
	SPN_ENGINE_TURBOCHARGER_2_TURBINE_OUTLET_TEMPERATURE = 0x4A1U,
	SPN_ENGINE_TURBOCHARGER_3_TURBINE_OUTLET_TEMPERATURE = 0x4A2U,
	SPN_ENGINE_TURBOCHARGER_4_TURBINE_OUTLET_TEMPERATURE = 0x4A3U,
	SPN_ENGINE_TURBOCHARGER_1_WASTEGATE_DRIVE_2 = 0x4A4U,
	SPN_ENGINE_TURBOCHARGER_2_WASTEGATE_DRIVE = 0x4A5U,
	SPN_ENGINE_TURBOCHARGER_3_WASTEGATE_DRIVE = 0x4A6U,
	SPN_ENGINE_TURBOCHARGER_4_WASTEGATE_DRIVE = 0x4A7U,
	SPN_ENGINE_TURBOCHARGER_WASTEGATE_ACTUATOR_CONTROL_AIR_PRESSURE = 0x4A8U,
	SPN_ENGINE_OPERATION_TIME_SINCE_REBUILD = 0x4A9U,
	SPN_ANTITHEFT_ENCRYPTION_SEED_PRESENT_INDICATOR = 0x4AAU,
	SPN_ANTITHEFT_PASSWORD_VALID_INDICATOR = 0x4ABU,
	SPN_ANTITHEFT_COMPONENT_STATUS_STATES = 0x4ACU,
	SPN_ANTITHEFT_MODIFY_PASSWORD_STATES = 0x4ADU,
	SPN_ANTITHEFT_RANDOM_NUMBER = 0x4AEU,
	SPN_ANTITHEFT_ENCRYPTION_INDICATOR_STATES = 0x4AFU,
	SPN_ANTITHEFT_DESIRED_EXIT_MODE_STATES = 0x4B0U,
	SPN_ANTITHEFT_COMMAND_STATES = 0x4B1U,
	SPN_ANTITHEFT_PASSWORD_REPRESENTATION = 0x4B2U,
	SPN_ENGINE_AUXILIARY_COOLANT_PRESSURE = 0x4B3U,
	SPN_ELECTRICAL_LOAD = 0x4B4U,
	SPN_SAFETY_WIRE_STATUS = 0x4B5U,
	SPN_ENGINE_ECU_TEMPERATURE_3 = 0x4B7U,
	SPN_ENGINE_PREFILTER_OIL_PRESSURE = 0x4B8U,
	SPN_ENGINE_EXHAUST_GAS_PRESSURE = 0x4B9U,
	SPN_ENGINE_FUEL_RACK_POSITION = 0x4BAU,
	SPN_ENGINE_BUILD_HOURS_RESET = 0x4BBU,
	SPN_ENGINE_AUXILIARY_COOLANT_TEMPERATURE = 0x4BCU,
	SPN_MALFUNCTION_INDICATOR_LAMP = 0x4BDU,
	SPN_SUSPECT_PARAMETER_NUMBER = 0x4BEU,
	SPN_FAILURE_MODE_IDENTIFIER = 0x4BFU,
	SPN_OCCURRENCE_COUNT = 0x4C0U,
	SPN_FREEZE_FRAME_LENGTH = 0x4C1U,
	SPN_ACTIVE_TROUBLE_CODES = 0x4C2U,
	SPN_PREVIOUSLY_ACTIVE_TROUBLE_CODES = 0x4C3U,
	SPN_OBD_COMPLIANCE = 0x4C4U,
	SPN_CONTINUOUSLY_MONITORED_SYSTEMS_SUPPORTSTATUS = 0x4C5U,
	SPN_NONCONTINUOUSLY_MONITORED_SYSTEMS_SUPPORT = 0x4C6U,
	SPN_NONCONTINUOUSLY_MONITORED_SYSTEMS_STATUS = 0x4C7U,
	SPN_TEST_IDENTIFIER = 0x4C8U,
	SPN_TEST_TYPECOMPONENT_IDENTIFIER = 0x4C9U,
	SPN_TEST_VALUE = 0x4CAU,
	SPN_TEST_LIMIT_MAXIMUM = 0x4CBU,
	SPN_TEST_LIMIT_MINIMUM = 0x4CCU,
	SPN_TEST_IDENTIFIERS_SUPPORTED = 0x4CDU,
	SPN_CURRENT_DATA_LINK = 0x4CEU,
	SPN_J1939_NETWORK_2 = 0x4CFU,
	SPN_ISO_9141 = 0x4D0U,
	SPN_J1850 = 0x4D1U,
	SPN_OTHER_MANUFACTURER_SPECIFIED_PORT = 0x4D2U,
	SPN_J1939_NETWORK_3 = 0x4D3U,
	SPN_HOLD_SIGNAL = 0x4D4U,
	SPN_ENGINE_SHUTDOWN_OVERRIDE_SWITCH = 0x4D5U,
	SPN_TRACTION_CONTROL_OVERRIDE_SWITCH = 0x4D6U,
	SPN_ENGINE_FUEL_LEAKAGE_1 = 0x4D7U,
	SPN_ENGINE_FUEL_LEAKAGE_2 = 0x4D8U,
	SPN_ENGINE_GAS_MASS_FLOW_RATE_1 = 0x4D9U,
	SPN_INSTANTANEOUS_ESTIMATED_BRAKE_POWER = 0x4DAU,
	SPN_ABS_FULLY_OPERATIONAL = 0x4DBU,
	SPN_ENGINE_FUEL_ACTUATOR_2_CONTROL_COMMAND = 0x4DCU,
	SPN_ENGINE_TIMING_ACTUATOR_2 = 0x4DDU,
	SPN_NUMBER_OF_ENGINE_TORQUE_HISTORY_RECORDS = 0x4DEU,
	SPN_ENGINE_POWER = 0x4DFU,
	SPN_ENGINE_PEAK_TORQUE_1 = 0x4E0U,
	SPN_ENGINE_PEAK_TORQUE_2 = 0x4E1U,
	SPN_CALIBRATION_RECORD_START_MONTH = 0x4E2U,
	SPN_CALIBRATION_RECORD_START_DAY = 0x4E3U,
	SPN_CALIBRATION_RECORD_START_YEAR = 0x4E4U,
	SPN_CALIBRATION_RECORD_DURATION_TIME = 0x4E5U,
	SPN_TORQUE_LIMITING_FEATURE_STATUS = 0x4E6U,
	SPN_TRANSMISSION_GEAR_RATIO_1 = 0x4E7U,
	SPN_ENGINE_TORQUE_LIMIT_1_TRANSMISSION = 0x4E8U,
	SPN_TRANSMISSION_GEAR_RATIO_2 = 0x4E9U,
	SPN_ENGINE_TORQUE_LIMIT_2_TRANSMISSION = 0x4EAU,
	SPN_TRANSMISSION_GEAR_RATIO_3 = 0x4EBU,
	SPN_ENGINE_TORQUE_LIMIT_3_TRANSMISSION = 0x4ECU,
	SPN_ENGINE_TORQUE_LIMIT_4_TRANSMISSION = 0x4EDU,
	SPN_ENGINE_TORQUE_LIMIT_5_SWITCH = 0x4EEU,
	SPN_ENGINE_TORQUE_LIMIT_6_AXLE_INPUT = 0x4EFU,
	SPN_ENGINE_EXTENDED_CRANKCASE_BLOWBY_PRESSURE_2 = 0x4F0U,
	SPN_ENGINE_OIL_BURN_VALVE = 0x4F1U,
	SPN_ENGINE_OIL_REPLACEMENT_VALVE = 0x4F2U,
	SPN_IDLE_SHUTDOWN_VEHICLE_ACCESSORIES_RELAY_DRIVER_CIRCUIT = 0x4F3U,
	SPN_ENGINE_IGNITION_COIL_1 = 0x4F4U,
	SPN_ENGINE_IGNITION_COIL_2 = 0x4F5U,
	SPN_ENGINE_IGNITION_COIL_3 = 0x4F6U,
	SPN_ENGINE_IGNITION_COIL_4 = 0x4F7U,
	SPN_ENGINE_IGNITION_COIL_5 = 0x4F8U,
	SPN_ENGINE_IGNITION_COIL_6 = 0x4F9U,
	SPN_ENGINE_IGNITION_COIL_7 = 0x4FAU,
	SPN_ENGINE_IGNITION_COIL_8 = 0x4FBU,
	SPN_ENGINE_IGNITION_COIL_9 = 0x4FCU,
	SPN_ENGINE_IGNITION_COIL_10 = 0x4FDU,
	SPN_ENGINE_IGNITION_COIL_11 = 0x4FEU,
	SPN_ENGINE_IGNITION_COIL_12 = 0x4FFU,
	SPN_ENGINE_IGNITION_COIL_13 = 0x500U,
	SPN_ENGINE_IGNITION_COIL_14 = 0x501U,
	SPN_ENGINE_IGNITION_COIL_15 = 0x502U,
	SPN_ENGINE_IGNITION_COIL_16 = 0x503U,
	SPN_ENGINE_IGNITION_COIL_17 = 0x504U,
	SPN_ENGINE_IGNITION_COIL_18 = 0x505U,
	SPN_ENGINE_IGNITION_COIL_19 = 0x506U,
	SPN_ENGINE_IGNITION_COIL_20 = 0x507U,
	SPN_ENGINE_IGNITION_COIL_21 = 0x508U,
	SPN_ENGINE_IGNITION_COIL_22 = 0x509U,
	SPN_ENGINE_IGNITION_COIL_23 = 0x50AU,
	SPN_ENGINE_IGNITION_COIL_24 = 0x50BU,
	SPN_ENGINE_IGNITION_CONTROL_MODULE_1 = 0x50CU,
	SPN_ENGINE_IGNITION_CONTROL_MODULE_2 = 0x50DU,
	SPN_ENGINE_SPARK_PLUG_1 = 0x50EU,
	SPN_ENGINE_SPARK_PLUG_2 = 0x50FU,
	SPN_ENGINE_SPARK_PLUG_3 = 0x510U,
	SPN_ENGINE_SPARK_PLUG_4 = 0x511U,
	SPN_ENGINE_SPARK_PLUG_5 = 0x512U,
	SPN_ENGINE_SPARK_PLUG_6 = 0x513U,
	SPN_ENGINE_SPARK_PLUG_7 = 0x514U,
	SPN_ENGINE_SPARK_PLUG_8 = 0x515U,
	SPN_ENGINE_SPARK_PLUG_9 = 0x516U,
	SPN_ENGINE_SPARK_PLUG_10 = 0x517U,
	SPN_ENGINE_SPARK_PLUG_11 = 0x518U,
	SPN_ENGINE_SPARK_PLUG_12 = 0x519U,
	SPN_ENGINE_SPARK_PLUG_13 = 0x51AU,
	SPN_ENGINE_SPARK_PLUG_14 = 0x51BU,
	SPN_ENGINE_SPARK_PLUG_15 = 0x51CU,
	SPN_ENGINE_SPARK_PLUG_16 = 0x51DU,
	SPN_ENGINE_SPARK_PLUG_17 = 0x51EU,
	SPN_ENGINE_SPARK_PLUG_18 = 0x51FU,
	SPN_ENGINE_SPARK_PLUG_19 = 0x520U,
	SPN_ENGINE_SPARK_PLUG_20 = 0x521U,
	SPN_ENGINE_SPARK_PLUG_21 = 0x522U,
	SPN_ENGINE_SPARK_PLUG_22 = 0x523U,
	SPN_ENGINE_SPARK_PLUG_23 = 0x524U,
	SPN_ENGINE_SPARK_PLUG_24 = 0x525U,
	SPN_ENGINE_EXHAUST_TEMPERATURE_BANK_IMBALANCE = 0x526U,
	SPN_ENGINE_INTAKE_MANIFOLD_PRESSURE_BANK_IMBALANCE = 0x527U,
	SPN_ENGINE_EXTERNAL_SHUTDOWN_AIR_SUPPLY_PRESSURE = 0x528U,
	SPN_ENGINE_STARTER_SOLENOID_LOCKOUT_RELAY_DRIVER_CIRCUIT = 0x529U,
	SPN_ENGINE_MISFIRE_FOR_MULTIPLE_CYLINDERS = 0x52AU,
	SPN_ENGINE_MISFIRE_CYLINDER_1 = 0x52BU,
	SPN_ENGINE_MISFIRE_CYLINDER_2 = 0x52CU,
	SPN_ENGINE_MISFIRE_CYLINDER_3 = 0x52DU,
	SPN_ENGINE_MISFIRE_CYLINDER_4 = 0x52EU,
	SPN_ENGINE_MISFIRE_CYLINDER_5 = 0x52FU,
	SPN_ENGINE_MISFIRE_CYLINDER_6 = 0x530U,
	SPN_ENGINE_MISFIRE_CYLINDER_7 = 0x531U,
	SPN_ENGINE_MISFIRE_CYLINDER_8 = 0x532U,
	SPN_ENGINE_MISFIRE_CYLINDER_9 = 0x533U,
	SPN_ENGINE_MISFIRE_CYLINDER_10 = 0x534U,
	SPN_ENGINE_MISFIRE_CYLINDER_11 = 0x535U,
	SPN_ENGINE_MISFIRE_CYLINDER_12 = 0x536U,
	SPN_ENGINE_MISFIRE_CYLINDER_13 = 0x537U,
	SPN_ENGINE_MISFIRE_CYLINDER_14 = 0x538U,
	SPN_ENGINE_MISFIRE_CYLINDER_15 = 0x539U,
	SPN_ENGINE_MISFIRE_CYLINDER_16 = 0x53AU,
	SPN_ENGINE_MISFIRE_CYLINDER_17 = 0x53BU,
	SPN_ENGINE_MISFIRE_CYLINDER_18 = 0x53CU,
	SPN_ENGINE_MISFIRE_CYLINDER_19 = 0x53DU,
	SPN_ENGINE_MISFIRE_CYLINDER_20 = 0x53EU,
	SPN_ENGINE_MISFIRE_CYLINDER_21 = 0x53FU,
	SPN_ENGINE_MISFIRE_CYLINDER_22 = 0x540U,
	SPN_ENGINE_MISFIRE_CYLINDER_23 = 0x541U,
	SPN_ENGINE_MISFIRE_CYLINDER_24 = 0x542U,
	SPN_ENGINE_FUEL_PUMP_PRESSURIZING_ASSEMBLY_1 = 0x543U,
	SPN_ENGINE_FUEL_PUMP_PRESSURIZING_ASSEMBLY_2 = 0x544U,
	SPN_ENGINE_INJECTOR_METERING_RAIL_2_PRESSURE_2 = 0x545U,
	SPN_TIME_SINCE_LAST_SERVICE = 0x546U,
	SPN_AIR_COMPRESSOR_STATUS = 0x547U,
	SPN_ENGINE_CYLINDER_1_KNOCK_LEVEL = 0x548U,
	SPN_ENGINE_CYLINDER_2_KNOCK_LEVEL = 0x549U,
	SPN_ENGINE_CYLINDER_3_KNOCK_LEVEL = 0x54AU,
	SPN_ENGINE_CYLINDER_4_KNOCK_LEVEL = 0x54BU,
	SPN_ENGINE_CYLINDER_5_KNOCK_LEVEL = 0x54CU,
	SPN_ENGINE_CYLINDER_6_KNOCK_LEVEL = 0x54DU,
	SPN_ENGINE_CYLINDER_7_KNOCK_LEVEL = 0x54EU,
	SPN_ENGINE_CYLINDER_8_KNOCK_LEVEL = 0x54FU,
	SPN_ENGINE_CYLINDER_9_KNOCK_LEVEL = 0x550U,
	SPN_ENGINE_CYLINDER_10_KNOCK_LEVEL = 0x551U,
	SPN_ENGINE_CYLINDER_11_KNOCK_LEVEL = 0x552U,
	SPN_ENGINE_CYLINDER_12_KNOCK_LEVEL = 0x553U,
	SPN_ENGINE_CYLINDER_13_KNOCK_LEVEL = 0x554U,
	SPN_ENGINE_CYLINDER_14_KNOCK_LEVEL = 0x555U,
	SPN_ENGINE_CYLINDER_15_KNOCK_LEVEL = 0x556U,
	SPN_ENGINE_CYLINDER_16_KNOCK_LEVEL = 0x557U,
	SPN_ENGINE_CYLINDER_17_KNOCK_LEVEL = 0x558U,
	SPN_ENGINE_CYLINDER_18_KNOCK_LEVEL = 0x559U,
	SPN_ENGINE_CYLINDER_19_KNOCK_LEVEL = 0x55AU,
	SPN_ENGINE_CYLINDER_20_KNOCK_LEVEL = 0x55BU,
	SPN_ENGINE_CYLINDER_21_KNOCK_LEVEL = 0x55CU,
	SPN_ENGINE_CYLINDER_22_KNOCK_LEVEL = 0x55DU,
	SPN_ENGINE_CYLINDER_23_KNOCK_LEVEL = 0x55EU,
	SPN_ENGINE_CYLINDER_24_KNOCK_LEVEL = 0x55FU,
	SPN_BATTERY_2_POTENTIAL_VOLTAGE = 0x560U,
	SPN_ENGINE_SYNCHRONIZATION_SWITCH = 0x561U,
	SPN_ENGINE_OIL_CHANGE_INTERVAL = 0x562U,
	SPN_SERVICE_COMPONENT_IDENTIFICATION_4 = 0x563U,
	SPN_ENGINE_OIL_LEVEL_REMOTE_RESERVOIR = 0x564U,
	SPN_ENGINE_FUEL_SUPPLY_PUMP_INLET_PRESSURE = 0x565U,
	SPN_ENGINE_FUEL_FILTER_SUCTION_SIDE_DIFFERENTIAL_PRESSURE_2 = 0x566U,
	SPN_ENGINE_WAS_SHUT_DOWN_HOT = 0x567U,
	SPN_ENGINE_HAS_BEEN_SHUT_DOWN_FROM_DATA_LINK_INFORMATION = 0x568U,
	SPN_AUXILIARY_TEMPERATURE_3 = 0x569U,
	SPN_AUXILIARY_TEMPERATURE_4 = 0x56AU,
	SPN_AUXILIARY_PRESSURE_1 = 0x56BU,
	SPN_AUXILIARY_PRESSURE_2 = 0x56CU,
	SPN_ENGINE_FUEL_SPECIFIC_GRAVITY = 0x56DU,
	SPN_ENGINE_FUEL_VALVE_1_INLET_ABSOLUTE_PRESSURE = 0x56EU,
	SPN_ENGINE_FUEL_VALVE_DIFFERENTIAL_PRESSURE = 0x56FU,
	SPN_ENGINE_AIR_TO_FUEL_DIFFERENTIAL_PRESSURE = 0x570U,
	SPN_ENGINE_CYLINDER_1_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x571U,
	SPN_ENGINE_CYLINDER_2_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x572U,
	SPN_ENGINE_CYLINDER_3_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x573U,
	SPN_ENGINE_CYLINDER_4_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x574U,
	SPN_ENGINE_CYLINDER_5_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x575U,
	SPN_ENGINE_CYLINDER_6_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x576U,
	SPN_ENGINE_CYLINDER_7_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x577U,
	SPN_ENGINE_CYLINDER_8_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x578U,
	SPN_ENGINE_CYLINDER_9_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x579U,
	SPN_ENGINE_CYLINDER_10_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x57AU,
	SPN_ENGINE_CYLINDER_11_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x57BU,
	SPN_ENGINE_CYLINDER_12_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x57CU,
	SPN_ENGINE_CYLINDER_13_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x57DU,
	SPN_ENGINE_CYLINDER_14_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x57EU,
	SPN_ENGINE_CYLINDER_15_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x57FU,
	SPN_ENGINE_CYLINDER_16_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x580U,
	SPN_ENGINE_CYLINDER_17_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x581U,
	SPN_ENGINE_CYLINDER_18_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x582U,
	SPN_ENGINE_CYLINDER_19_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x583U,
	SPN_ENGINE_CYLINDER_20_IGNITION_TRANSFORMER_SECONDARY_OUTPUT = 0x584U,
	SPN_ENGINE_CYLINDER_1_IGNITION_TIMING = 0x585U,
	SPN_ENGINE_CYLINDER_2_IGNITION_TIMING = 0x586U,
	SPN_ENGINE_CYLINDER_3_IGNITION_TIMING = 0x587U,
	SPN_ENGINE_CYLINDER_4_IGNITION_TIMING = 0x588U,
	SPN_ENGINE_CYLINDER_5_IGNITION_TIMING = 0x589U,
	SPN_ENGINE_CYLINDER_6_IGNITION_TIMING = 0x58AU,
	SPN_ENGINE_CYLINDER_7_IGNITION_TIMING = 0x58BU,
	SPN_ENGINE_CYLINDER_8_IGNITION_TIMING = 0x58CU,
	SPN_ENGINE_CYLINDER_9_IGNITION_TIMING = 0x58DU,
	SPN_ENGINE_CYLINDER_10_IGNITION_TIMING = 0x58EU,
	SPN_ENGINE_CYLINDER_11_IGNITION_TIMING = 0x58FU,
	SPN_ENGINE_CYLINDER_12_IGNITION_TIMING = 0x590U,
	SPN_ENGINE_CYLINDER_13_IGNITION_TIMING = 0x591U,
	SPN_ENGINE_CYLINDER_14_IGNITION_TIMING = 0x592U,
	SPN_ENGINE_CYLINDER_15_IGNITION_TIMING = 0x593U,
	SPN_ENGINE_CYLINDER_16_IGNITION_TIMING = 0x594U,
	SPN_ENGINE_CYLINDER_17_IGNITION_TIMING = 0x595U,
	SPN_ENGINE_CYLINDER_18_IGNITION_TIMING = 0x596U,
	SPN_ENGINE_CYLINDER_19_IGNITION_TIMING = 0x597U,
	SPN_ENGINE_CYLINDER_20_IGNITION_TIMING = 0x598U,
	SPN_ENGINE_DESIRED_IGNITION_TIMING_1 = 0x599U,
	SPN_ENGINE_DESIRED_IGNITION_TIMING_2 = 0x59AU,
	SPN_ENGINE_DESIRED_IGNITION_TIMING_3 = 0x59BU,
	SPN_ENGINE_ACTUAL_IGNITION_TIMING = 0x59CU,
	SPN_ROAD_SPEED_LIMIT_STATUS = 0x59DU,
	SPN_ABSEBS_AMBER_WARNING_SIGNAL = 0x59EU,
	SPN_EBS_RED_WARNING_SIGNAL = 0x59FU,
	SPN_ENGINE_FUEL_FLOW_RATE_1 = 0x5A0U,
	SPN_ENGINE_FUEL_FLOW_RATE_2 = 0x5A1U,
	SPN_ENGINE_FUEL_VALVE_1_POSITION = 0x5A2U,
	SPN_ENGINE_FUEL_VALVE_2_POSITION = 0x5A3U,
	SPN_ENGINE_CYLINDER_1_COMBUSTION_TIME = 0x5A4U,
	SPN_ENGINE_CYLINDER_2_COMBUSTION_TIME = 0x5A5U,
	SPN_ENGINE_CYLINDER_3_COMBUSTION_TIME = 0x5A6U,
	SPN_ENGINE_CYLINDER_4_COMBUSTION_TIME = 0x5A7U,
	SPN_ENGINE_CYLINDER_5_COMBUSTION_TIME = 0x5A8U,
	SPN_ENGINE_CYLINDER_6_COMBUSTION_TIME = 0x5A9U,
	SPN_ENGINE_CYLINDER_7_COMBUSTION_TIME = 0x5AAU,
	SPN_ENGINE_CYLINDER_8_COMBUSTION_TIME = 0x5ABU,
	SPN_ENGINE_CYLINDER_9_COMBUSTION_TIME = 0x5ACU,
	SPN_ENGINE_CYLINDER_10_COMBUSTION_TIME = 0x5ADU,
	SPN_ENGINE_CYLINDER_11_COMBUSTION_TIME = 0x5AEU,
	SPN_ENGINE_CYLINDER_12_COMBUSTION_TIME = 0x5AFU,
	SPN_ENGINE_CYLINDER_13_COMBUSTION_TIME = 0x5B0U,
	SPN_ENGINE_CYLINDER_14_COMBUSTION_TIME = 0x5B1U,
	SPN_ENGINE_CYLINDER_15_COMBUSTION_TIME = 0x5B2U,
	SPN_ENGINE_CYLINDER_16_COMBUSTION_TIME = 0x5B3U,
	SPN_ENGINE_CYLINDER_17_COMBUSTION_TIME = 0x5B4U,
	SPN_ENGINE_CYLINDER_18_COMBUSTION_TIME = 0x5B5U,
	SPN_ENGINE_CYLINDER_19_COMBUSTION_TIME = 0x5B6U,
	SPN_ENGINE_CYLINDER_20_COMBUSTION_TIME = 0x5B7U,
	SPN_ENGINE_DESIRED_COMBUSTION_TIME = 0x5B8U,
	SPN_ENGINE_AVERAGE_COMBUSTION_TIME = 0x5B9U,
	SPN_STEER_CHANNEL_MODE = 0x5BAU,
	SPN_TRAILERTAG_CHANNEL_MODE = 0x5BBU,
	SPN_DRIVE_CHANNEL_MODE = 0x5BCU,
	SPN_PCU_DRIVE_SOLENOID_STATUS = 0x5BDU,
	SPN_PCU_STEER_SOLENOID_STATUS = 0x5BEU,
	SPN_TIRE_PRESSURE_SUPPLY_SWITCH_STATUS = 0x5BFU,
	SPN_PCU_DEFLATE_SOLENOID_STATUS = 0x5C0U,
	SPN_PCU_CONTROL_SOLENOID_STATUS = 0x5C1U,
	SPN_PCU_SUPPLY_SOLENOID_STATUS = 0x5C2U,
	SPN_PCU_TRAILER_TAG_OR_PUSH_SOLENOID_STATUS = 0x5C3U,
	SPN_ENGINE_OIL_SPECIFIC_RESISTANCE = 0x5C4U,
	SPN_ENGINE_OIL_KINEMATIC_VISCOSITY = 0x5C5U,
	SPN_ENGINE_OIL_RELATIVE_DIELECTRICITY = 0x5C6U,
	SPN_SECURITY_ENTITY_TYPE = 0x5C7U,
	SPN_SOURCE_ADDRESS_OF_CONTROLLING_DEVICE_FOR_RETARDER_CONTROL = 0x5C8U,
	SPN_SOURCE_ADDRESS_OF_CONTROLLING_DEVICE_FOR_BRAKE_CONTROL = 0x5C9U,
	SPN_SOURCE_ADDRESS_OF_CONTROLLING_DEVICE_FOR_TRANSMISSION_CONTROL = 0x5CAU,
	SPN_SOURCE_ADDRESS_OF_CONTROLLING_DEVICE_FOR_ENGINE_CONTROL = 0x5CBU,
	SPN_OTHER_ECUS_HAVE_REPORTED_FAULT_CODES_AFFECTING_OPERATION = 0x5CCU,
	SPN_ECM_MAIN_RELAY = 0x5CDU,
	SPN_CONCAVE_POSITION = 0x5CEU,
	SPN_ILLUMINATION_BRIGHTNESS_PERCENT = 0x5CFU,
	SPN_THRESHER_SPEED = 0x5D0U,
	SPN_CLEANING_FAN_SPEED = 0x5D1U,
	SPN_HEADER_BACKSHAFT_SPEED = 0x5D2U,
	SPN_INSTRUMENT_PANEL_1_BACKLIGHTING_DRIVER = 0x5D3U,
	SPN_INSTRUMENT_PANEL_2_BACKLIGHTING_DRIVER = 0x5D4U,
	SPN_TAILINGS_SYSTEM = 0x5D5U,
	SPN_TAILINGS_SENSOR_1 = 0x5D6U,
	SPN_TAILINGS_SENSOR_2 = 0x5D7U,
	SPN_TAILINGS_ELEVATOR_PADDLES = 0x5D8U,
	SPN_UNLOADING_AUGER_DRIVE = 0x5D9U,
	SPN_HEADER_DRIVE = 0x5DAU,
	SPN_SEPARATOR_DRIVE = 0x5DBU,
	SPN_TACHOMETER_MODULE_SWITCH_MATRIX = 0x5DCU,
	SPN_GRAIN_LOSS_MODULE_SWITCH_MATRIX = 0x5DDU,
	SPN_AUTOMATIC_HEADER_CONTROL_SWITCH_MATRIX = 0x5DEU,
	SPN_ARM_REST_SWITCH_MATRIX = 0x5DFU,
	SPN_OPERATOR_SEAT_SWITCH = 0x5E0U,
	SPN_AUTOMATIC_HEADER_SENSITIVITY_ADJUSTMENT = 0x5E1U,
	SPN_AUTOMATIC_HEADER_RATE_ADJUSTMENT_INPUT = 0x5E2U,
	SPN_DISCHARGE_BEATER_SPEED_DISABLE_ADJUSTMENT = 0x5E3U,
	SPN_HYDRAULIC_RESERVOIR_TEMPERATURE = 0x5E4U,
	SPN_THRESHER_SEPARATOR_HYDRAULIC_DRIVE_1_TEMPERATURE = 0x5E5U,
	SPN_CHOPPER_VANE_ADJUSTMENT = 0x5E6U,
	SPN_RIGHT_SIDE_CLEANING_SHOE_RELATIVE_GRAIN_LOSS = 0x5E7U,
	SPN_LEFT_SIDE_CLEANING_SHOE_RELATIVE_GRAIN_LOSS = 0x5E8U,
	SPN_RIGHT_SIDE_SEPARATOR_RELATIVE_GRAIN_LOSS = 0x5E9U,
	SPN_LEFT_SIDE_SEPARATOR_RELATIVE_GRAIN_LOSS = 0x5EAU,
	SPN_HEADER_HEIGHT_SYSTEM = 0x5EBU,
	SPN_HEADER = 0x5ECU,
	SPN_HEADER_LIFT_CYLINDER_PRESSURE = 0x5EDU,
	SPN_HEADER_SENSOR_IDENTIFICATION = 0x5EEU,
	SPN_HEADER_RAISE_VALVE_DRIVE = 0x5EFU,
	SPN_HEADER_LOWER_VALVE_DRIVE = 0x5F0U,
	SPN_HEADER_TILT_LEFT_VALVE_DRIVE = 0x5F1U,
	SPN_HEADER_TILT_RIGHT_VALVE_DRIVE = 0x5F2U,
	SPN_HEADER_LIFT_CYLINDER_PRESSURE_DIVERTED_VALVE_DRIVE = 0x5F3U,
	SPN_REEL_POSITION_FORWARD_ACTUATOR = 0x5F4U,
	SPN_REEL_POSITION_AFT_ACTUATOR = 0x5F5U,
	SPN_REEL_POSITION_RAISE_ACTUATOR = 0x5F6U,
	SPN_REEL_POSITION_LOWER_ACTUATOR = 0x5F7U,
	SPN_HEADER_DROP_RATE_CONTROL_VALVE_DRIVE = 0x5F8U,
	SPN_HEADER_LIFT_CYLINDER_ACCUMULATOR_SHUTOFF_VALVE_DRIVE = 0x5F9U,
	SPN_UNLOADING_AUGER_FLOW_BYPASS_VALVE_DRIVE = 0x5FAU,
	SPN_REEL_DRIVE_MOTOR_SPEED_INCREASE_VALVE_DRIVE = 0x5FBU,
	SPN_REEL_DRIVE_MOTOR_SPEED_DECREASE_VALVE_DRIVE = 0x5FCU,
	SPN_FEEDERHOUSE_ANGLE = 0x5FDU,
	SPN_HEADER_LEFTMOST_HEIGHT = 0x5FEU,
	SPN_HEADER_RIGHTMOST_HEIGHT = 0x5FFU,
	SPN_HEADER_CENTER_HEIGHT = 0x600U,
	SPN_REEL_FOREAFT_POSITION = 0x601U,
	SPN_REEL_UPDOWN_POSITION = 0x602U,
	SPN_HEADER_LATERAL_TILT_ANGLE = 0x603U,
	SPN_REEL_SPEED_ACTUATOR_POSITION = 0x604U,
	SPN_REEL_SPEED = 0x605U,
	SPN_ECU_POWER_SUPPLY_VOLTAGE_2 = 0x606U,
	SPN_ECU_POWER_SUPPLY_VOLTAGE_3 = 0x607U,
	SPN_HYDRO_HANDLE_MATRIX_SWITCH = 0x608U,
	SPN_NOT_USED_RESERVED_1 = 0x609U,
	SPN_HVAC_COOLANT_VALVE_POSITION_SENSOR = 0x60AU,
	SPN_AC_EVAPORATOR_TEMPERATURE = 0x60BU,
	SPN_HVAC_DUCT_TEMPERATURE = 0x60CU,
	SPN_HVAC_WATER_VALVE_DRIVE = 0x60DU,
	SPN_NOT_USED_RESERVED_2 = 0x60EU,
	SPN_AC_PRESSURIZER_DRIVE_CIRCUIT = 0x60FU,
	SPN_OPERATOR_INPUT_DEVICE_FOR_CAB_CLIMATE_CONTROL = 0x610U,
	SPN_HVAC_BLOWER_MOTOR_SPEED_ADJUSTMENT = 0x611U,
	SPN_CLEAN_GRAIN_ELEVATOR_SPEED = 0x612U,
	SPN_MOISTURE_SENSOR_CELL_FREQUENCY = 0x613U,
	SPN_DATALOG_MEMORY_CARD = 0x614U,
	SPN_NOT_USED_RESERVED_3 = 0x615U,
	SPN_PROGRAMMING_ERROR_DEVICE_REFUSED_TO_ENTER_PROGRAMMING_MODE = 0x616U,
	SPN_PROGRAMMING_ERROR_DEVICE_TIMED_OUT_WHILE_ENTERING_THE_PROGRAMMING_MODE = 0x617U,
	SPN_PROGRAMMING_ERROR_DEVICE_TIMED_OUT_WHILE_ERASING = 0x618U,
	SPN_PROGRAMMING_ERROR_DEVICE_TIMED_OUT_WHILE_PROGRAMMING = 0x619U,
	SPN_PROGRAMMING_ERROR_DEVICE_DID_NOT_ACCEPT_PROGRAM_LINE = 0x61AU,
	SPN_INCOMPATIBLE_MONITORCONTROLLER = 0x61BU,
	SPN_CCD_DATA_LINK = 0x61CU,
	SPN_ARMREST_STATUS = 0x61DU,
	SPN_ARMREST_ROTARY_INPUTS = 0x61EU,
	SPN_HEADER_HEIGHT_CONTROL_MODE_SELECTOR_SWITCHES = 0x61FU,
	SPN_ENGINE_TORQUE_CURVE_SELECTION = 0x620U,
	SPN_ENGINE_PROTECTION_TORQUE_DERATE = 0x621U,
	SPN_IMPLEMENT_DISCONNECTED = 0x622U,
	SPN_DISPLAY_CONFLICT = 0x623U,
	SPN_DISPLAY_OVERLOAD = 0x624U,
	SPN_LED_DISPLAY_DATA_1 = 0x625U,
	SPN_LASER_STRIKE_VERTICAL_DEVIATION = 0x626U,
	SPN_MODIFY_SET_POINT = 0x627U,
	SPN_MAST_POSITION = 0x628U,
	SPN_BLADE_DURATION_AND_DIRECTION = 0x629U,
	SPN_BLADE_CONTROL_MODE = 0x62AU,
	SPN_LASER_TRACER_TARGET_DEVIATION = 0x62BU,
	SPN_LASER_TRACER_VERTICAL_DISTANCE = 0x62CU,
	SPN_LASER_TRACER_HORIZONTAL_DEVIATION = 0x62DU,
	SPN_LED_DISPLAY_DATA_2 = 0x62EU,
	SPN_LASER_TRACER_INFORMATION = 0x62FU,
	SPN_SERVICE_COMPONENT_IDENTIFICATION = 0x630U,
	SPN_POWERED_VEHICLE_WEIGHT = 0x631U,
	SPN_SPEED_OF_FORWARD_VEHICLE = 0x632U,
	SPN_DISTANCE_TO_FORWARD_VEHICLE = 0x633U,
	SPN_ADAPTIVE_CRUISE_CONTROL_SET_SPEED = 0x634U,
	SPN_ADAPTIVE_CRUISE_CONTROL_SET_DISTANCE_MODE = 0x635U,
	SPN_ADAPTIVE_CRUISE_CONTROL_MODE = 0x636U,
	SPN_ROAD_CURVATURE = 0x637U,
	SPN_FRONT_AXLE_LEFT_WHEEL_SPEED = 0x638U,
	SPN_FRONT_AXLE_RIGHT_WHEEL_SPEED = 0x639U,
	SPN_REAR_AXLE_LEFT_WHEEL_SPEED = 0x63AU,
	SPN_REAR_AXLE_RIGHT_WHEEL_SPEED = 0x63BU,
	SPN_SECURITY_ENTITY_LENGTH = 0x63CU,
	SPN_DATA_SECURITY_PARAMETER = 0x63DU,
	SPN_PGN_OF_MESSAGE_TO_BE_AUTHENTICATED = 0x63EU,
	SPN_SEED = 0x63FU,
	SPN_AUTHENTICATION_MESSAGE_DATA_PARAMETER = 0x640U,
	SPN_LOCAL_MINUTE_OFFSET = 0x641U,
	SPN_LOCAL_HOUR_OFFSET = 0x642U,
	SPN_ADJUST_SECONDS = 0x643U,
	SPN_ADJUST_MINUTES = 0x644U,
	SPN_ADJUST_HOURS = 0x645U,
	SPN_ADJUST_MONTH = 0x646U,
	SPN_ADJUST_DAY = 0x647U,
	SPN_ADJUST_YEAR = 0x648U,
	SPN_ADJUST_LOCAL_MINUTE_OFFSET = 0x649U,
	SPN_ADJUST_LOCAL_HOUR_OFFSET = 0x64AU,
	SPN_DRIVE_RECOGNIZE = 0x64BU,
	SPN_DRIVER_1_WORKING_STATE = 0x64CU,
	SPN_DRIVER_2_WORKING_STATE = 0x64DU,
	SPN_OVERSPEED = 0x64EU,
	SPN_DRIVER_CARD_DRIVER_1 = 0x64FU,
	SPN_DRIVER_CARD_DRIVER_2 = 0x650U,
	SPN_DRIVER_1_TIME_RELATED_STATES = 0x651U,
	SPN_DRIVER_2_TIME_RELATED_STATES = 0x652U,
	SPN_DIRECTION_INDICATOR = 0x653U,
	SPN_TACHOGRAPH_PERFORMANCE = 0x654U,
	SPN_HANDLING_INFORMATION = 0x655U,
	SPN_SYSTEM_EVENT = 0x656U,
	SPN_TACHOGRAPH_OUTPUT_SHAFT_SPEED = 0x657U,
	SPN_TACHOGRAPH_VEHICLE_SPEED = 0x658U,
	SPN_DRIVER_1_IDENTIFICATION = 0x659U,
	SPN_DRIVER_2_IDENTIFICATION = 0x65AU,
	SPN_RESERVED_FOR_CERTIFICATION_AGENCY_ID = 0x65BU,
	SPN_RESERVED_FOR_CERTIFICATION_SEEDKEY_LENGTH = 0x65CU,
	SPN_RESERVED_FOR_CERTIFICATION_SIGNATURE = 0x65DU,
	SPN_RESERVED_FOR_CERTIFICATION_PUBLIC_KEY = 0x65EU,
	SPN_RESERVED_FOR_CERTIFICATION_VEHICLE_IDENTIFICATION_NUMBER = 0x65FU,
	SPN_ENGINE_TORQUE_LIMIT_FEATURE = 0x660U,
	SPN_CRUISE_CONTROL_PAUSE_SWITCH = 0x661U,
	SPN_CALIBRATION_VERIFICATION_NUMBER = 0x662U,
	SPN_CALIBRATION_IDENTIFICATION = 0x663U,
	SPN_ENGINE_INTAKE_MANIFOLD_1_AIR_TEMPERATURE = 0x664U,
	SPN_ENGINE_COOLANT_TEMPERATURE_2 = 0x665U,
	SPN_HYDRAULIC_TEMPERATURE = 0x666U,
	SPN_FAN_SPEED = 0x667U,
	SPN_LENGTHNUMBER_REQUESTED = 0x668U,
	SPN_POINTER_TYPE = 0x669U,
	SPN_COMMAND = 0x66AU,
	SPN_POINTER_EXTENSION = 0x66BU,
	SPN_POINTER = 0x66CU,
	SPN_KEYUSER_LEVEL = 0x66DU,
	SPN_STATUS = 0x66EU,
	SPN_EDCP_EXTENSION = 0x66FU,
	SPN_ERROR_INDICATOREDC_PARAMETER_1 = 0x670U,
	SPN_LENGTHNUMBER_ALLOWED = 0x671U,
	SPN_NUMBER_OF_OCCURRENCES_OF_RAW_BINARY_DATA = 0x672U,
	SPN_RAW_BINARY_DATA = 0x673U,
	SPN_BOOT_LOAD_DATA = 0x674U,
	SPN_VEHICLE_LIMITING_SPEED_GOVERNOR_ENABLE_SWITCH = 0x675U,
	SPN_VEHICLE_LIMITING_SPEED_GOVERNOR_INCREMENT_SWITCH = 0x676U,
	SPN_VEHICLE_LIMITING_SPEED_GOVERNOR_DECREMENT_SWITCH = 0x677U,
	SPN_ENGINE_AUTOMATIC_START_ENABLE_SWITCH = 0x678U,
	SPN_ENGINE_INJECTOR_NEEDLE_LIFT_SENSOR_1 = 0x679U,
	SPN_ENGINE_INJECTOR_NEEDLE_LIFT_SENSOR_2 = 0x67AU,
	SPN_ENGINE_COOLANT_SYSTEM_THERMOSTAT = 0x67BU,
	SPN_ENGINE_AUTOMATIC_START_ALARM = 0x67CU,
	SPN_ENGINE_AUTOMATIC_START_LAMP = 0x67DU,
	SPN_CAB_INTERIOR_TEMPERATURE_THERMOSTAT = 0x67EU,
	SPN_ENGINE_AUTOMATIC_START_SAFETY_INTERLOCK_CIRCUIT = 0x67FU,
	SPN_ENGINE_AUTOMATIC_START_FAILED = 0x680U,
	SPN_ENGINE_TURBOCHARGER_OIL_LEVEL_SWITCH = 0x681U,
	SPN_AUTOMATIC_GEAR_SHIFTING_ENABLE_SWITCH = 0x682U,
	SPN_RETARDER_REQUESTING_BRAKE_LIGHT = 0x683U,
	SPN_J1939_NETWORK_4 = 0x684U,
	SPN_J1939_NETWORK_5 = 0x685U,
	SPN_J1939_NETWORK_6 = 0x686U,
	SPN_J1939_NETWORK_7 = 0x687U,
	SPN_J1939_NETWORK_8 = 0x688U,
	SPN_J1939_NETWORK_9 = 0x689U,
	SPN_J1939_NETWORK_10 = 0x68AU,
	SPN_ENGINE_STARTER_MODE = 0x68BU,
	SPN_AUXILIARY_HEATER_WATER_PUMP_STATUS = 0x68CU,
	SPN_AUXILIARY_HEATER_MODE = 0x68DU,
	SPN_CAB_VENTILATION = 0x68EU,
	SPN_ENGINE_HEATING_ZONE = 0x68FU,
	SPN_CAB_HEATING_ZONE = 0x690U,
	SPN_BATTERY_MAIN_SWITCH_HOLD_STATE = 0x691U,
	SPN_BATTERY_MAIN_SWITCH_HOLD_REQUEST = 0x692U,
	SPN_AUXILIARY_HEATER_MODE_REQUEST = 0x693U,
	SPN_AUXILIARY_HEATER_COOLANT_PUMP_REQUEST = 0x694U,
	SPN_REQUEST_ENGINE_ZONE_HEATING = 0x695U,
	SPN_REQUEST_CAB_ZONE_HEATING = 0x696U,
	SPN_AUXILIARY_HEATER_OUTPUT_COOLANT_TEMPERATURE = 0x697U,
	SPN_AUXILIARY_HEATER_INPUT_AIR_TEMPERATURE = 0x698U,
	SPN_AUXILIARY_HEATER_OUTPUT_POWER_PERCENT = 0x699U,
	SPN_AUXILIARY_HEATER_MAXIMUM_OUTPUT_POWER = 0x69AU,
	SPN_CAB_INTERIOR_TEMPERATURE_COMMAND = 0x69BU,
	SPN_ENGINE_DESIRED_ABSOLUTE_INTAKE_MANIFOLD_PRESSURE = 0x69CU,
	SPN_ENGINE_TURBOCHARGER_WASTEGATE_VALVE_POSITION = 0x69DU,
	SPN_ENGINE_GAS_MASS_FLOW_SENSOR_FUELING_CORRECTION = 0x69EU,
	SPN_ENGINE_EXHAUST_GAS_OXYGEN_SENSOR_FUELING_CORRECTION = 0x69FU,
	SPN_ENGINE_EXHAUST_GAS_OXYGEN_SENSOR_CLOSED_LOOP_OPERATION = 0x6A0U,
	SPN_CTI_WHEEL_END_ELECTRICAL_FAULT = 0x6A1U,
	SPN_CTI_TIRE_STATUS = 0x6A2U,
	SPN_CTI_WHEEL_SENSOR_STATUS = 0x6A3U,
	SPN_LANE_DEPARTURE_IMMINENT_LEFT_SIDE = 0x6A4U,
	SPN_LANE_DEPARTURE_IMMINENT_RIGHT_SIDE = 0x6A5U,
	SPN_LANE_DEPARTURE_INDICATION_ENABLE_STATUS = 0x6A6U,
	SPN_LANE_TRACKING_SPEAKER_RIGHT_SIDE = 0x6A7U,
	SPN_LANE_TRACKING_SPEAKER = 0x6A8U,
	SPN_FORWARD_VIEW_IMAGER_SYSTEM = 0x6A9U,
	SPN_SPN_CONVERSION_METHOD = 0x6AAU,
	SPN_TRANSMISSION_CONTROLLER_POWER_RELAY = 0x6ADU,
	SPN_LANE_TRACKING_STATUS_LEFT_SIDE = 0x6AEU,
	SPN_LANE_TRACKING_STATUS_RIGHT_SIDE = 0x6AFU,
	SPN_ENGINE_EXTENDED_RANGE_REQUESTED_SPEED_CONTROL_RANGE_UPPER_LIMIT = 0x6B0U,
	SPN_HYDRAULIC_OIL_FILTER_RESTRICTION_SWITCH = 0x6B1U,
	SPN_OPERATOR_SEAT_DIRECTION_SWITCH = 0x6B2U,
	SPN_DRIVERS_DEMAND_RETARDER_PERCENT_TORQUE = 0x6B3U,
	SPN_RETARDER_SELECTION_NONENGINE = 0x6B4U,
	SPN_ACTUAL_MAXIMUM_AVAILABLE_RETARDER_PERCENT_TORQUE = 0x6B5U,
	SPN_DAMPER_STIFFNESS_REQUEST_FRONT_AXLE = 0x6B6U,
	SPN_DAMPER_STIFFNESS_REQUEST_REAR_AXLE = 0x6B7U,
	SPN_DAMPER_STIFFNESS_REQUEST_LIFT__TAG_AXLE = 0x6B8U,
	SPN_RELATIVE_LEVEL_FRONT_AXLE_LEFT = 0x6B9U,
	SPN_RELATIVE_LEVEL_FRONT_AXLE_RIGHT = 0x6BAU,
	SPN_RELATIVE_LEVEL_REAR_AXLE_RIGHT = 0x6BBU,
	SPN_RELATIVE_LEVEL_REAR_AXLE_LEFT = 0x6BCU,
	SPN_BELLOW_PRESSURE_FRONT_AXLE_LEFT = 0x6BDU,
	SPN_BELLOW_PRESSURE_FRONT_AXLE_RIGHT = 0x6BEU,
	SPN_BELLOW_PRESSURE_REAR_AXLE_LEFT = 0x6BFU,
	SPN_BELLOW_PRESSURE_REAR_AXLE_RIGHT = 0x6C0U,
	SPN_DAMPER_STIFFNESS_FRONT_AXLE = 0x6C1U,
	SPN_DAMPER_STIFFNESS_REAR_AXLE = 0x6C2U,
	SPN_DAMPER_STIFFNESS_LIFT__TAG_AXLE = 0x6C3U,
	SPN_LEVEL_PRESET_FRONT_AXLE_LEFT = 0x6C4U,
	SPN_NOMINAL_LEVEL_REAR_AXLE = 0x6C5U,
	SPN_NOMINAL_LEVEL_FRONT_AXLE = 0x6C6U,
	SPN_LEVEL_PRESET_REAR_AXLE_RIGHT = 0x6C7U,
	SPN_ABOVE_NOMINAL_LEVEL_REAR_AXLE = 0x6C8U,
	SPN_ABOVE_NOMINAL_LEVEL_FRONT_AXLE = 0x6C9U,
	SPN_BELOW_NOMINAL_LEVEL_FRONT_AXLE = 0x6CAU,
	SPN_LIFTING_CONTROL_MODE_FRONT_AXLE = 0x6CBU,
	SPN_LOWERING_CONTROL_MODE_FRONT_AXLE = 0x6CCU,
	SPN_LEVEL_CONTROL_MODE = 0x6CDU,
	SPN_KNEELING_INFORMATION = 0x6CEU,
	SPN_LIFT_AXLE_1_POSITION = 0x6CFU,
	SPN_DOOR_RELEASE = 0x6D0U,
	SPN_VEHICLE_MOTION_INHIBIT = 0x6D1U,
	SPN_SECURITY_DEVICE = 0x6D2U,
	SPN_KNEELING_CONTROL_MODE_REQUEST = 0x6D3U,
	SPN_KNEELING_REQUEST_RIGHT_SIDE = 0x6D4U,
	SPN_KNEELING_REQUEST_LEFT_SIDE = 0x6D5U,
	SPN_NOMINAL_LEVEL_REQUEST_REAR_AXLE = 0x6D6U,
	SPN_NOMINAL_LEVEL_REQUEST_FRONT_AXLE = 0x6D7U,
	SPN_LIFT_AXLE_1_POSITION_COMMAND = 0x6D8U,
	SPN_LEVEL_CONTROL_MODE_REQUEST = 0x6D9U,
	SPN_BELOW_NOMINAL_LEVEL_REAR_AXLE = 0x6DAU,
	SPN_LOWERING_CONTROL_MODE_REAR_AXLE = 0x6DBU,
	SPN_LIFTING_CONTROL_MODE_REAR_AXLE = 0x6DCU,
	SPN_LEVEL_PRESET_FRONT_AXLE_RIGHT = 0x6DDU,
	SPN_LEVEL_PRESET_REAR_AXLE_LEFT = 0x6DEU,
	SPN_BLADE_HEIGHT_SET_POINT_HIGH_RESOLUTION = 0x6DFU,
	SPN_GROSS_COMBINATION_VEHICLE_WEIGHT = 0x6E0U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_LEVEL = 0x6E1U,
	SPN_HYDRAULIC_PRESSURE = 0x6E2U,
	SPN_ENGINE_HYDRAULIC_PRESSURE_GOVERNOR_MODE_INDICATOR = 0x6E3U,
	SPN_ENGINE_HYDRAULIC_PRESSURE_GOVERNOR_SWITCH = 0x6E4U,
	SPN_ENGINE_REQUESTED_FUEL_VALVE_1_POSITION = 0x6E5U,
	SPN_ENGINE_REQUESTED_FUEL_VALVE_2_POSITION = 0x6E6U,
	SPN_SPECIFIC_HEAT_RATIO = 0x6E7U,
	SPN_ENGINE_LOW_LIMIT_THRESHOLD_FOR_MAXIMUM_RPM_FROM_ENGINE = 0x6E8U,
	SPN_ENGINE_HIGH_LIMIT_THRESHOLD_FOR_MINIMUM_CONTINUOUS_ENGINE_RPM = 0x6E9U,
	SPN_ENGINE_LOW_LIMIT_THRESHOLD_FOR_MAXIMUM_TORQUE_FROM_ENGINE = 0x6EAU,
	SPN_ENGINE_HIGH_LIMIT_THRESHOLD_FOR_MINIMUM_CONTINUOUS_TORQUE_FROM_ENGINE = 0x6EBU,
	SPN_ENGINE_MAXIMUM_CONTINUOUS_RPM = 0x6ECU,
	SPN_ENGINE_MINIMUM_CONTINUOUS_RPM = 0x6EDU,
	SPN_ENGINE_MAXIMUM_CONTINUOUS_TORQUE = 0x6EEU,
	SPN_ENGINE_MINIMUM_CONTINUOUS_TORQUE = 0x6EFU,
	SPN_LOW_LIMIT_THRESHOLD_FOR_MAXIMUM_RPM_FROM_RETARDER = 0x6F0U,
	SPN_HIGH_LIMIT_THRESHOLD_FOR_MINIMUM_CONTINUOUS_RPM_FROM_RETARDER = 0x6F1U,
	SPN_LOW_LIMIT_THRESHOLD_FOR_MAXIMUM_TORQUE_FROM_RETARDER = 0x6F2U,
	SPN_HIGH_LIMIT_THRESHOLD_FOR_MINIMUM_CONTINUOUS_TORQUE_FROM_RETARDER = 0x6F3U,
	SPN_MAXIMUM_CONTINUOUS_RETARDER_SPEED = 0x6F4U,
	SPN_MINIMUM_CONTINUOUS_RETARDER_SPEED = 0x6F5U,
	SPN_MAXIMUM_CONTINUOUS_RETARDER_TORQUE = 0x6F6U,
	SPN_MINIMUM_CONTINUOUS_RETARDER_TORQUE = 0x6F7U,
	SPN_ENGINE_SPEED_LIMIT_REQUEST_MINIMUM_CONTINUOUS = 0x6F8U,
	SPN_ENGINE_SPEED_LIMIT_REQUEST_MAXIMUM_CONTINUOUS = 0x6F9U,
	SPN_ENGINE_TORQUE_LIMIT_REQUEST_MINIMUM_CONTINUOUS = 0x6FAU,
	SPN_ENGINE_TORQUE_LIMIT_REQUEST_MAXIMUM_CONTINUOUS = 0x6FBU,
	SPN_MINIMUM_CONTINUOUS_RETARDER_SPEED_LIMIT_REQUEST = 0x6FCU,
	SPN_MAXIMUM_CONTINUOUS_RETARDER_SPEED_LIMIT_REQUEST = 0x6FDU,
	SPN_MINIMUM_CONTINUOUS_RETARDER_TORQUE_LIMIT_REQUEST = 0x6FEU,
	SPN_MAXIMUM_CONTINUOUS_RETARDER_TORQUE_LIMIT_REQUEST = 0x6FFU,
	SPN_TRACTORMOUNTED_TRAILER_ABS_WARNING_SIGNAL = 0x700U,
	SPN_ATCASR_INFORMATION_SIGNAL = 0x701U,
	SPN_ENGINE_MOMENT_OF_INERTIA = 0x702U,
	SPN_ALTERNATOR_CURRENT_2 = 0x703U,
	SPN_ACC_DISTANCE_ALERT_SIGNAL = 0x704U,
	SPN_ACC_SYSTEM_SHUTOFF_WARNING = 0x705U,
	SPN_ACC_TARGET_DETECTED = 0x706U,
	SPN_REQUESTED_ACC_DISTANCE_MODE = 0x707U,
	SPN_BATTERY_1_TEMPERATURE = 0x708U,
	SPN_BATTERY_2_TEMPERATURE = 0x709U,
	SPN_ENGINE_INTAKE_MANIFOLD_5_TEMPERATURE = 0x70AU,
	SPN_ENGINE_INTAKE_MANIFOLD_6_TEMPERATURE = 0x70BU,
	SPN_ENGINE_START_ENABLE_DEVICE_2 = 0x70CU,
	SPN_LED_DISPLAY_MODE_CONTROL = 0x70DU,
	SPN_LED_DISPLAY_DEADBAND_CONTROL = 0x70EU,
	SPN_STEERING_WHEEL_ANGLE = 0x70FU,
	SPN_YAW_RATE = 0x710U,
	SPN_LATERAL_ACCELERATION = 0x711U,
	SPN_LONGITUDINAL_ACCELERATION = 0x712U,
	SPN_STEERING_WHEEL_TURN_COUNTER = 0x713U,
	SPN_STEERING_WHEEL_ANGLE_SENSOR_TYPE = 0x714U,
	SPN_VDC_INFORMATION_SIGNAL = 0x715U,
	SPN_VDC_FULLY_OPERATIONAL = 0x716U,
	SPN_VDC_BRAKE_LIGHT_REQUEST = 0x717U,
	SPN_ROP_ENGINE_CONTROL_ACTIVE = 0x718U,
	SPN_YC_ENGINE_CONTROL_ACTIVE = 0x719U,
	SPN_ROP_BRAKE_CONTROL_ACTIVE = 0x71AU,
	SPN_YC_BRAKE_CONTROL_ACTIVE = 0x71BU,
	SPN_RAMP__WHEEL_CHAIR_LIFT_POSITION = 0x71CU,
	SPN_POSITION_OF_DOORS = 0x71DU,
	SPN_LIFT_AXLE_2_POSITION = 0x71EU,
	SPN_REAR_AXLE_IN_BUMPER_RANGE = 0x71FU,
	SPN_FRONT_AXLE_IN_BUMPER_RANGE = 0x720U,
	SPN_SUSPENSION_REMOTE_CONTROL_2 = 0x721U,
	SPN_SUSPENSION_REMOTE_CONTROL_1 = 0x722U,
	SPN_SUSPENSION_CONTROL_REFUSAL_INFORMATION = 0x723U,
	SPN_LIFT_AXLE_2_POSITION_COMMAND = 0x724U,
	SPN_KNEELING_COMMAND_REAR_AXLE = 0x725U,
	SPN_KNEELING_COMMAND_FRONT_AXLE = 0x726U,
	SPN_ELECTRONIC_SHOCK_ABSORBER_CONTROL_MODE_LIFTTAG_AXLE = 0x727U,
	SPN_ELECTRONIC_SHOCK_ABSORBER_CONTROL_MODE_REAR_AXLE = 0x728U,
	SPN_ELECTRONIC_SHOCK_ABSORBER_CONTROL_MODE_FRONT_AXLE = 0x729U,
	SPN_ENGINE_TOTAL_AVERAGE_FUEL_RATE = 0x72AU,
	SPN_ENGINE_TOTAL_AVERAGE_FUEL_ECONOMY = 0x72BU,
	SPN_TRAILER_ABS_STATUS = 0x72CU,
	SPN_CONVOY_DRIVING_LAMP_SELECT = 0x72DU,
	SPN_CONVOY_LAMP_SELECT = 0x72EU,
	SPN_FRONT_BLACK_OUT_MARKER_LAMP_SELECT = 0x72FU,
	SPN_REAR_BLACK_OUT_MARKER_SELECT = 0x730U,
	SPN_BLACK_OUT_BRAKESTOP_LAMP_SELECT = 0x731U,
	SPN_BLACK_OUT_WORK_LAMP_SELECT = 0x732U,
	SPN_NIGHT_VISION_ILLUMINATOR_SELECT = 0x733U,
	SPN_OPERATORS_BLACK_OUT_INTENSITY_SELECTION = 0x734U,
	SPN_TRANSMISSION_TORQUE_LIMIT = 0x735U,
	SPN_ENGINE_DEFAULT_TORQUE_LIMIT = 0x736U,
	SPN_TRANSMISSION_REQUESTED_RANGE_DISPLAY_FLASH_STATE = 0x739U,
	SPN_TRANSMISSION_REQUESTED_RANGE_DISPLAY_BLANK_STATE = 0x73AU,
	SPN_TRANSMISSION_SHIFT_INHIBIT_INDICATOR = 0x73BU,
	SPN_TRANSMISSION_MODE_1 = 0x73CU,
	SPN_TRANSMISSION_MODE_2 = 0x73DU,
	SPN_TRANSMISSION_MODE_3 = 0x73EU,
	SPN_TRANSMISSION_MODE_4 = 0x73FU,
	SPN_SEAT_BELT_SWITCH = 0x740U,
	SPN_WINCH_OIL_PRESSURE_SWITCH = 0x741U,
	SPN_INTERMITTENT_WIPER_CONTROL = 0x742U,
	SPN_GROUND_BASED_IMPLEMENT_SPEED = 0x743U,
	SPN_GROUND_BASED_IMPLEMENT_DISTANCE = 0x744U,
	SPN_GROUND_BASED_DIRECTION = 0x745U,
	SPN_WHEEL_BASED_SPEED = 0x746U,
	SPN_WHEEL_BASED_DISTANCE = 0x747U,
	SPN_WHEEL_BASED_DIRECTION = 0x748U,
	SPN_KEY_SWITCH_NOT_OFF = 0x749U,
	SPN_MAXIMUM_TIME_OF_TRACTOR_POWER = 0x74AU,
	SPN_MAINTAIN_ECU_POWER = 0x74BU,
	SPN_MAINTAIN_ACTUATOR_POWER = 0x74CU,
	SPN_IMPLEMENT_TRANSPORT_STATE = 0x74DU,
	SPN_IMPLEMENT_PARK_STATE = 0x74EU,
	SPN_IMPLEMENT_WORK_STATE = 0x74FU,
	SPN_FRONT_HITCH_POSITION = 0x750U,
	SPN_REAR_HITCH_POSITION = 0x751U,
	SPN_FRONT_HITCH_POSITION_COMMAND = 0x752U,
	SPN_REAR_HITCH_POSITION_COMMAND = 0x753U,
	SPN_FRONT_HITCH_INWORK_INDICATION = 0x754U,
	SPN_REAR_HITCH_INWORK_INDICATION = 0x755U,
	SPN_FRONT_DRAFT = 0x756U,
	SPN_REAR_DRAFT = 0x757U,
	SPN_FRONT_NOMINAL_LOWER_LINK_FORCE = 0x758U,
	SPN_REAR_NOMINAL_LOWER_LINK_FORCE = 0x759U,
	SPN_FRONT_PTO_OUTPUT_SHAFT_SPEED = 0x75AU,
	SPN_REAR_PTO_OUTPUT_SHAFT_SPEED = 0x75BU,
	SPN_FRONT_PTO_OUTPUT_SHAFT_SPEED_SET_POINT = 0x75CU,
	SPN_REAR_PTO_OUTPUT_SHAFT_SPEED_SET_POINT = 0x75DU,
	SPN_FRONT_PTO_OUTPUT_SHAFT_SPEED_SET_POINT_COMMAND = 0x75EU,
	SPN_REAR_PTO_OUTPUT_SHAFT_SPEED_SET_POINT_COMMAND_1 = 0x75FU,
	SPN_FRONT_POWER_TAKEOFF_ENGAGEMENT = 0x760U,
	SPN_FRONT_POWER_TAKEOFF_MODE = 0x761U,
	SPN_REAR_POWER_TAKEOFF_MODE = 0x762U,
	SPN_FRONT_POWER_TAKEOFF_ECONOMY_MODE = 0x763U,
	SPN_REAR_POWER_TAKEOFF_ECONOMY_MODE = 0x764U,
	SPN_FRONT_POWER_TAKEOFF_ENGAGEMENT_COMMAND = 0x765U,
	SPN_REAR_POWER_TAKEOFF_ENGAGEMENT_COMMAND = 0x766U,
	SPN_FRONT_POWER_TAKEOFF_MODE_COMMAND = 0x767U,
	SPN_REAR_POWER_TAKEOFF_MODE_COMMAND = 0x768U,
	SPN_FRONT_POWER_TAKEOFF_ECONOMY_MODE_COMMAND = 0x769U,
	SPN_REAR_POWER_TAKEOFF_ECONOMY_MODE_COMMAND = 0x76AU,
	SPN_AUX_VALVE_0_EXTEND_PORT_MEASURED_FLOW = 0x76BU,
	SPN_AUX_VALVE_0_RETRACT_PORT_MEASURED_FLOW = 0x76CU,
	SPN_AUX_VALVE_0_EXTEND_PORT_ESTIMATED_FLOW = 0x76DU,
	SPN_AUX_VALVE_0_RETRACT_PORT_ESTIMATED_FLOW = 0x76EU,
	SPN_AUX_VALVE_0_STATE = 0x76FU,
	SPN_AUX_VALVE_0_EXTEND_PORT_PRESSURE = 0x770U,
	SPN_AUX_VALVE_0_RETRACT_PORT_PRESSURE = 0x771U,
	SPN_AUX_VALVE_0_RETURN_PORT_PRESSURE = 0x772U,
	SPN_AUX_VALVE_0_PORT_FLOW_COMMAND = 0x773U,
	SPN_AUX_VALVE_0_STATE_COMMAND = 0x774U,
	SPN_AUX_VALVE_0_FAIL_SAFE_MODE_COMMAND = 0x775U,
	SPN_AUX_VALVE_0_FAIL_SAFE_MODE = 0x776U,
	SPN_AUX_VALVE_1_EXTEND_PORT_MEASURED_FLOW = 0x777U,
	SPN_AUX_VALVE_1_RETRACT_PORT_MEASURED_FLOW = 0x778U,
	SPN_AUX_VALVE_1_EXTEND_PORT_ESTIMATED_FLOW = 0x779U,
	SPN_AUX_VALVE_1_RETRACT_PORT_ESTIMATED_FLOW = 0x77AU,
	SPN_AUX_VALVE_1_STATE = 0x77BU,
	SPN_AUX_VALVE_1_EXTEND_PORT_PRESSURE = 0x77CU,
	SPN_AUX_VALVE_1_RETRACT_PORT_PRESSURE = 0x77DU,
	SPN_AUX_VALVE_1_RETURN_PORT_PRESSURE = 0x77EU,
	SPN_AUX_VALVE_1_PORT_FLOW_COMMAND = 0x77FU,
	SPN_AUX_VALVE_1_STATE_COMMAND = 0x780U,
	SPN_AUX_VALVE_1_FAIL_SAFE_MODE_COMMAND = 0x781U,
	SPN_AUX_VALVE_1_FAIL_SAFE_MODE = 0x782U,
	SPN_AUX_VALVE_2_EXTEND_PORT_MEASURED_FLOW = 0x783U,
	SPN_AUX_VALVE_2_RETRACT_PORT_MEASURED_FLOW = 0x784U,
	SPN_AUX_VALVE_2_EXTEND_PORT_ESTIMATED_FLOW = 0x785U,
	SPN_AUX_VALVE_2_RETRACT_PORT_ESTIMATED_FLOW = 0x786U,
	SPN_AUX_VALVE_2_STATE = 0x787U,
	SPN_AUX_VALVE_2_EXTEND_PORT_PRESSURE = 0x788U,
	SPN_AUX_VALVE_2_RETRACT_PORT_PRESSURE = 0x789U,
	SPN_AUX_VALVE_2_RETURN_PORT_PRESSURE = 0x78AU,
	SPN_AUX_VALVE_2_PORT_FLOW_COMMAND = 0x78BU,
	SPN_AUX_VALVE_2_STATE_COMMAND = 0x78CU,
	SPN_AUX_VALVE_2_FAIL_SAFE_MODE_COMMAND = 0x78DU,
	SPN_AUX_VALVE_2_FAIL_SAFE_MODE = 0x78EU,
	SPN_AUX_VALVE_3_EXTEND_PORT_MEASURED_FLOW = 0x78FU,
	SPN_AUX_VALVE_3_RETRACT_PORT_MEASURED_FLOW = 0x790U,
	SPN_AUX_VALVE_3_EXTEND_PORT_ESTIMATED_FLOW = 0x791U,
	SPN_AUX_VALVE_3_RETRACT_PORT_ESTIMATED_FLOW = 0x792U,
	SPN_AUX_VALVE_3_STATE = 0x793U,
	SPN_AUX_VALVE_3_EXTEND_PORT_PRESSURE = 0x794U,
	SPN_AUX_VALVE_3_RETRACT_PORT_PRESSURE_1 = 0x795U,
	SPN_AUX_VALVE_3_RETURN_PORT_PRESSURE = 0x796U,
	SPN_AUX_VALVE_3_PORT_FLOW_COMMAND = 0x797U,
	SPN_AUX_VALVE_3_STATE_COMMAND = 0x798U,
	SPN_AUX_VALVE_3_FAIL_SAFE_MODE_COMMAND = 0x799U,
	SPN_AUX_VALVE_3_FAIL_SAFE_MODE = 0x79AU,
	SPN_AUX_VALVE_4_EXTEND_PORT_MEASURED_FLOW = 0x79BU,
	SPN_AUX_VALVE_4_RETRACT_PORT_MEASURED_FLOW = 0x79CU,
	SPN_AUX_VALVE_4_EXTEND_PORT_ESTIMATED_FLOW = 0x79DU,
	SPN_AUX_VALVE_4_RETRACT_PORT_ESTIMATED_FLOW = 0x79EU,
	SPN_AUX_VALVE_4_STATE = 0x79FU,
	SPN_AUX_VALVE_4_EXTEND_PORT_PRESSURE = 0x7A0U,
	SPN_AUX_VALVE_4_RETRACT_PORT_PRESSURE = 0x7A1U,
	SPN_AUX_VALVE_4_RETURN_PORT_PRESSURE = 0x7A2U,
	SPN_AUX_VALVE_4_PORT_FLOW_COMMAND = 0x7A3U,
	SPN_AUX_VALVE_4_STATE_COMMAND = 0x7A4U,
	SPN_AUX_VALVE_4_FAIL_SAFE_MODE_COMMAND = 0x7A5U,
	SPN_AUX_VALVE_4_FAIL_SAFE_MODE = 0x7A6U,
	SPN_AUX_VALVE_5_EXTEND_PORT_MEASURED_FLOW = 0x7A7U,
	SPN_AUX_VALVE_5_RETRACT_PORT_MEASURED_FLOW = 0x7A8U,
	SPN_AUX_VALVE_5_EXTEND_PORT_ESTIMATED_FLOW = 0x7A9U,
	SPN_AUX_VALVE_5_RETRACT_PORT_ESTIMATED_FLOW = 0x7AAU,
	SPN_AUX_VALVE_5_STATE = 0x7ABU,
	SPN_AUX_VALVE_5_EXTEND_PORT_PRESSURE = 0x7ACU,
	SPN_AUX_VALVE_5_RETRACT_PORT_PRESSURE = 0x7ADU,
	SPN_AUX_VALVE_5_RETURN_PORT_PRESSURE = 0x7AEU,
	SPN_AUX_VALVE_5_PORT_FLOW_COMMAND = 0x7AFU,
	SPN_AUX_VALVE_5_STATE_COMMAND = 0x7B0U,
	SPN_AUX_VALVE_5_FAIL_SAFE_MODE_COMMAND = 0x7B1U,
	SPN_AUX_VALVE_5_FAIL_SAFE_MODE = 0x7B2U,
	SPN_AUX_VALVE_6_EXTEND_PORT_MEASURED_FLOW = 0x7B3U,
	SPN_AUX_VALVE_6_RETRACT_PORT_MEASURED_FLOW = 0x7B4U,
	SPN_AUX_VALVE_6_EXTEND_PORT_ESTIMATED_FLOW = 0x7B5U,
	SPN_AUX_VALVE_6_RETRACT_PORT_ESTIMATED_FLOW = 0x7B6U,
	SPN_AUX_VALVE_6_STATE = 0x7B7U,
	SPN_AUX_VALVE_6_EXTEND_PORT_PRESSURE = 0x7B8U,
	SPN_AUX_VALVE_6_RETRACT_PORT_PRESSURE = 0x7B9U,
	SPN_AUX_VALVE_6_RETURN_PORT_PRESSURE = 0x7BAU,
	SPN_AUX_VALVE_6_PORT_FLOW_COMMAND = 0x7BBU,
	SPN_AUX_VALVE_6_STATE_COMMAND = 0x7BCU,
	SPN_AUX_VALVE_6_FAIL_SAFE_MODE_COMMAND = 0x7BDU,
	SPN_AUX_VALVE_6_FAIL_SAFE_MODE = 0x7BEU,
	SPN_AUX_VALVE_7_EXTEND_PORT_MEASURED_FLOW = 0x7BFU,
	SPN_AUX_VALVE_7_RETRACT_PORT_MEASURED_FLOW = 0x7C0U,
	SPN_AUX_VALVE_7_EXTEND_PORT_ESTIMATED_FLOW = 0x7C1U,
	SPN_AUX_VALVE_7_RETRACT_PORT_ESTIMATED_FLOW = 0x7C2U,
	SPN_AUX_VALVE_7_STATE = 0x7C3U,
	SPN_AUX_VALVE_7_EXTEND_PORT_PRESSURE = 0x7C4U,
	SPN_AUX_VALVE_7_RETRACT_PORT_PRESSURE = 0x7C5U,
	SPN_AUX_VALVE_7_RETURN_PORT_PRESSURE = 0x7C6U,
	SPN_AUX_VALVE_7_PORT_FLOW_COMMAND = 0x7C7U,
	SPN_AUX_VALVE_7_STATE_COMMAND = 0x7C8U,
	SPN_AUX_VALVE_7_FAIL_SAFE_MODE_COMMAND = 0x7C9U,
	SPN_AUX_VALVE_7_FAIL_SAFE_MODE = 0x7CAU,
	SPN_AUX_VALVE_8_EXTEND_PORT_MEASURED_FLOW = 0x7CBU,
	SPN_AUX_VALVE_8_RETRACT_PORT_MEASURED_FLOW = 0x7CCU,
	SPN_AUX_VALVE_8_EXTEND_PORT_ESTIMATED_FLOW = 0x7CDU,
	SPN_AUX_VALVE_8_RETRACT_PORT_ESTIMATED_FLOW = 0x7CEU,
	SPN_AUX_VALVE_8_STATE = 0x7CFU,
	SPN_SOURCE_ADDRESS_0 = 0x7D0U,
	SPN_SOURCE_ADDRESS_1 = 0x7D1U,
	SPN_SOURCE_ADDRESS_2 = 0x7D2U,
	SPN_SOURCE_ADDRESS_3 = 0x7D3U,
	SPN_SOURCE_ADDRESS_4 = 0x7D4U,
	SPN_SOURCE_ADDRESS_5 = 0x7D5U,
	SPN_SOURCE_ADDRESS_6 = 0x7D6U,
	SPN_SOURCE_ADDRESS_7 = 0x7D7U,
	SPN_SOURCE_ADDRESS_8 = 0x7D8U,
	SPN_SOURCE_ADDRESS_9 = 0x7D9U,
	SPN_SOURCE_ADDRESS_10 = 0x7DAU,
	SPN_SOURCE_ADDRESS_11 = 0x7DBU,
	SPN_SOURCE_ADDRESS_12 = 0x7DCU,
	SPN_SOURCE_ADDRESS_13 = 0x7DDU,
	SPN_SOURCE_ADDRESS_14 = 0x7DEU,
	SPN_SOURCE_ADDRESS_15 = 0x7DFU,
	SPN_SOURCE_ADDRESS_16 = 0x7E0U,
	SPN_SOURCE_ADDRESS_17 = 0x7E1U,
	SPN_SOURCE_ADDRESS_18 = 0x7E2U,
	SPN_SOURCE_ADDRESS_19 = 0x7E3U,
	SPN_SOURCE_ADDRESS_20 = 0x7E4U,
	SPN_SOURCE_ADDRESS_21 = 0x7E5U,
	SPN_SOURCE_ADDRESS_22 = 0x7E6U,
	SPN_SOURCE_ADDRESS_23 = 0x7E7U,
	SPN_SOURCE_ADDRESS_24 = 0x7E8U,
	SPN_SOURCE_ADDRESS_25 = 0x7E9U,
	SPN_SOURCE_ADDRESS_26 = 0x7EAU,
	SPN_SOURCE_ADDRESS_27 = 0x7EBU,
	SPN_SOURCE_ADDRESS_28 = 0x7ECU,
	SPN_SOURCE_ADDRESS_29 = 0x7EDU,
	SPN_SOURCE_ADDRESS_30 = 0x7EEU,
	SPN_SOURCE_ADDRESS_31 = 0x7EFU,
	SPN_SOURCE_ADDRESS_32 = 0x7F0U,
	SPN_SOURCE_ADDRESS_33 = 0x7F1U,
	SPN_SOURCE_ADDRESS_34 = 0x7F2U,
	SPN_SOURCE_ADDRESS_35 = 0x7F3U,
	SPN_SOURCE_ADDRESS_36 = 0x7F4U,
	SPN_SOURCE_ADDRESS_37 = 0x7F5U,
	SPN_SOURCE_ADDRESS_38 = 0x7F6U,
	SPN_SOURCE_ADDRESS_39 = 0x7F7U,
	SPN_SOURCE_ADDRESS_40 = 0x7F8U,
	SPN_SOURCE_ADDRESS_41 = 0x7F9U,
	SPN_SOURCE_ADDRESS_42 = 0x7FAU,
	SPN_SOURCE_ADDRESS_43 = 0x7FBU,
	SPN_SOURCE_ADDRESS_44 = 0x7FCU,
	SPN_SOURCE_ADDRESS_45 = 0x7FDU,
	SPN_SOURCE_ADDRESS_46 = 0x7FEU,
	SPN_SOURCE_ADDRESS_47 = 0x7FFU,
	SPN_SOURCE_ADDRESS_48 = 0x800U,
	SPN_SOURCE_ADDRESS_49 = 0x801U,
	SPN_SOURCE_ADDRESS_50 = 0x802U,
	SPN_SOURCE_ADDRESS_51 = 0x803U,
	SPN_SOURCE_ADDRESS_52 = 0x804U,
	SPN_SOURCE_ADDRESS_53 = 0x805U,
	SPN_SOURCE_ADDRESS_54 = 0x806U,
	SPN_SOURCE_ADDRESS_55 = 0x807U,
	SPN_SOURCE_ADDRESS_56 = 0x808U,
	SPN_SOURCE_ADDRESS_57 = 0x809U,
	SPN_SOURCE_ADDRESS_58 = 0x80AU,
	SPN_SOURCE_ADDRESS_59 = 0x80BU,
	SPN_SOURCE_ADDRESS_60 = 0x80CU,
	SPN_SOURCE_ADDRESS_61 = 0x80DU,
	SPN_SOURCE_ADDRESS_62 = 0x80EU,
	SPN_SOURCE_ADDRESS_63 = 0x80FU,
	SPN_SOURCE_ADDRESS_64 = 0x810U,
	SPN_SOURCE_ADDRESS_65 = 0x811U,
	SPN_SOURCE_ADDRESS_66 = 0x812U,
	SPN_SOURCE_ADDRESS_67 = 0x813U,
	SPN_SOURCE_ADDRESS_68 = 0x814U,
	SPN_SOURCE_ADDRESS_69 = 0x815U,
	SPN_SOURCE_ADDRESS_70 = 0x816U,
	SPN_SOURCE_ADDRESS_71 = 0x817U,
	SPN_SOURCE_ADDRESS_72 = 0x818U,
	SPN_SOURCE_ADDRESS_73 = 0x819U,
	SPN_SOURCE_ADDRESS_74 = 0x81AU,
	SPN_SOURCE_ADDRESS_75 = 0x81BU,
	SPN_SOURCE_ADDRESS_76 = 0x81CU,
	SPN_SOURCE_ADDRESS_77 = 0x81DU,
	SPN_SOURCE_ADDRESS_78 = 0x81EU,
	SPN_SOURCE_ADDRESS_79 = 0x81FU,
	SPN_SOURCE_ADDRESS_80 = 0x820U,
	SPN_SOURCE_ADDRESS_81 = 0x821U,
	SPN_SOURCE_ADDRESS_82 = 0x822U,
	SPN_SOURCE_ADDRESS_83 = 0x823U,
	SPN_SOURCE_ADDRESS_84 = 0x824U,
	SPN_SOURCE_ADDRESS_85 = 0x825U,
	SPN_SOURCE_ADDRESS_86 = 0x826U,
	SPN_SOURCE_ADDRESS_87 = 0x827U,
	SPN_SOURCE_ADDRESS_88 = 0x828U,
	SPN_SOURCE_ADDRESS_89 = 0x829U,
	SPN_SOURCE_ADDRESS_90 = 0x82AU,
	SPN_SOURCE_ADDRESS_91 = 0x82BU,
	SPN_SOURCE_ADDRESS_92 = 0x82CU,
	SPN_SOURCE_ADDRESS_93 = 0x82DU,
	SPN_SOURCE_ADDRESS_94 = 0x82EU,
	SPN_SOURCE_ADDRESS_95 = 0x82FU,
	SPN_SOURCE_ADDRESS_96 = 0x830U,
	SPN_SOURCE_ADDRESS_97 = 0x831U,
	SPN_SOURCE_ADDRESS_98 = 0x832U,
	SPN_SOURCE_ADDRESS_99 = 0x833U,
	SPN_SOURCE_ADDRESS_100 = 0x834U,
	SPN_SOURCE_ADDRESS_101 = 0x835U,
	SPN_SOURCE_ADDRESS_102 = 0x836U,
	SPN_SOURCE_ADDRESS_103 = 0x837U,
	SPN_SOURCE_ADDRESS_104 = 0x838U,
	SPN_SOURCE_ADDRESS_105 = 0x839U,
	SPN_SOURCE_ADDRESS_106 = 0x83AU,
	SPN_SOURCE_ADDRESS_107 = 0x83BU,
	SPN_SOURCE_ADDRESS_108 = 0x83CU,
	SPN_SOURCE_ADDRESS_109 = 0x83DU,
	SPN_SOURCE_ADDRESS_110 = 0x83EU,
	SPN_SOURCE_ADDRESS_111 = 0x83FU,
	SPN_SOURCE_ADDRESS_112 = 0x840U,
	SPN_SOURCE_ADDRESS_113 = 0x841U,
	SPN_SOURCE_ADDRESS_114 = 0x842U,
	SPN_SOURCE_ADDRESS_115 = 0x843U,
	SPN_SOURCE_ADDRESS_116 = 0x844U,
	SPN_SOURCE_ADDRESS_117 = 0x845U,
	SPN_SOURCE_ADDRESS_118 = 0x846U,
	SPN_SOURCE_ADDRESS_119 = 0x847U,
	SPN_SOURCE_ADDRESS_120 = 0x848U,
	SPN_SOURCE_ADDRESS_121 = 0x849U,
	SPN_SOURCE_ADDRESS_122 = 0x84AU,
	SPN_SOURCE_ADDRESS_123 = 0x84BU,
	SPN_SOURCE_ADDRESS_124 = 0x84CU,
	SPN_SOURCE_ADDRESS_125 = 0x84DU,
	SPN_SOURCE_ADDRESS_126 = 0x84EU,
	SPN_SOURCE_ADDRESS_127 = 0x84FU,
	SPN_SOURCE_ADDRESS_128 = 0x850U,
	SPN_SOURCE_ADDRESS_129 = 0x851U,
	SPN_SOURCE_ADDRESS_130 = 0x852U,
	SPN_SOURCE_ADDRESS_131 = 0x853U,
	SPN_SOURCE_ADDRESS_132 = 0x854U,
	SPN_SOURCE_ADDRESS_133 = 0x855U,
	SPN_SOURCE_ADDRESS_134 = 0x856U,
	SPN_SOURCE_ADDRESS_135 = 0x857U,
	SPN_SOURCE_ADDRESS_136 = 0x858U,
	SPN_SOURCE_ADDRESS_137 = 0x859U,
	SPN_SOURCE_ADDRESS_138 = 0x85AU,
	SPN_SOURCE_ADDRESS_139 = 0x85BU,
	SPN_SOURCE_ADDRESS_140 = 0x85CU,
	SPN_SOURCE_ADDRESS_141 = 0x85DU,
	SPN_SOURCE_ADDRESS_142 = 0x85EU,
	SPN_SOURCE_ADDRESS_143 = 0x85FU,
	SPN_SOURCE_ADDRESS_144 = 0x860U,
	SPN_SOURCE_ADDRESS_145 = 0x861U,
	SPN_SOURCE_ADDRESS_146 = 0x862U,
	SPN_SOURCE_ADDRESS_147 = 0x863U,
	SPN_SOURCE_ADDRESS_148 = 0x864U,
	SPN_SOURCE_ADDRESS_149 = 0x865U,
	SPN_SOURCE_ADDRESS_150 = 0x866U,
	SPN_SOURCE_ADDRESS_151 = 0x867U,
	SPN_SOURCE_ADDRESS_152 = 0x868U,
	SPN_SOURCE_ADDRESS_153 = 0x869U,
	SPN_SOURCE_ADDRESS_154 = 0x86AU,
	SPN_SOURCE_ADDRESS_155 = 0x86BU,
	SPN_SOURCE_ADDRESS_156 = 0x86CU,
	SPN_SOURCE_ADDRESS_157 = 0x86DU,
	SPN_SOURCE_ADDRESS_158 = 0x86EU,
	SPN_SOURCE_ADDRESS_159 = 0x86FU,
	SPN_SOURCE_ADDRESS_160 = 0x870U,
	SPN_SOURCE_ADDRESS_161 = 0x871U,
	SPN_SOURCE_ADDRESS_162 = 0x872U,
	SPN_SOURCE_ADDRESS_163 = 0x873U,
	SPN_SOURCE_ADDRESS_164 = 0x874U,
	SPN_SOURCE_ADDRESS_165 = 0x875U,
	SPN_SOURCE_ADDRESS_166 = 0x876U,
	SPN_SOURCE_ADDRESS_167 = 0x877U,
	SPN_SOURCE_ADDRESS_168 = 0x878U,
	SPN_SOURCE_ADDRESS_169 = 0x879U,
	SPN_SOURCE_ADDRESS_170 = 0x87AU,
	SPN_SOURCE_ADDRESS_171 = 0x87BU,
	SPN_SOURCE_ADDRESS_172 = 0x87CU,
	SPN_SOURCE_ADDRESS_173 = 0x87DU,
	SPN_SOURCE_ADDRESS_174 = 0x87EU,
	SPN_SOURCE_ADDRESS_175 = 0x87FU,
	SPN_SOURCE_ADDRESS_176 = 0x880U,
	SPN_SOURCE_ADDRESS_177 = 0x881U,
	SPN_SOURCE_ADDRESS_178 = 0x882U,
	SPN_SOURCE_ADDRESS_179 = 0x883U,
	SPN_SOURCE_ADDRESS_180 = 0x884U,
	SPN_SOURCE_ADDRESS_181 = 0x885U,
	SPN_SOURCE_ADDRESS_182 = 0x886U,
	SPN_SOURCE_ADDRESS_183 = 0x887U,
	SPN_SOURCE_ADDRESS_184 = 0x888U,
	SPN_SOURCE_ADDRESS_185 = 0x889U,
	SPN_SOURCE_ADDRESS_186 = 0x88AU,
	SPN_SOURCE_ADDRESS_187 = 0x88BU,
	SPN_SOURCE_ADDRESS_188 = 0x88CU,
	SPN_SOURCE_ADDRESS_189 = 0x88DU,
	SPN_SOURCE_ADDRESS_190 = 0x88EU,
	SPN_SOURCE_ADDRESS_191 = 0x88FU,
	SPN_SOURCE_ADDRESS_192 = 0x890U,
	SPN_SOURCE_ADDRESS_193 = 0x891U,
	SPN_SOURCE_ADDRESS_194 = 0x892U,
	SPN_SOURCE_ADDRESS_195 = 0x893U,
	SPN_SOURCE_ADDRESS_196 = 0x894U,
	SPN_SOURCE_ADDRESS_197 = 0x895U,
	SPN_SOURCE_ADDRESS_198 = 0x896U,
	SPN_SOURCE_ADDRESS_199 = 0x897U,
	SPN_SOURCE_ADDRESS_200 = 0x898U,
	SPN_SOURCE_ADDRESS_201 = 0x899U,
	SPN_SOURCE_ADDRESS_202 = 0x89AU,
	SPN_SOURCE_ADDRESS_203 = 0x89BU,
	SPN_SOURCE_ADDRESS_204 = 0x89CU,
	SPN_SOURCE_ADDRESS_205 = 0x89DU,
	SPN_SOURCE_ADDRESS_206 = 0x89EU,
	SPN_SOURCE_ADDRESS_207 = 0x89FU,
	SPN_SOURCE_ADDRESS_208 = 0x8A0U,
	SPN_SOURCE_ADDRESS_209 = 0x8A1U,
	SPN_SOURCE_ADDRESS_210 = 0x8A2U,
	SPN_SOURCE_ADDRESS_211 = 0x8A3U,
	SPN_SOURCE_ADDRESS_212 = 0x8A4U,
	SPN_SOURCE_ADDRESS_213 = 0x8A5U,
	SPN_SOURCE_ADDRESS_214 = 0x8A6U,
	SPN_SOURCE_ADDRESS_215 = 0x8A7U,
	SPN_SOURCE_ADDRESS_216 = 0x8A8U,
	SPN_SOURCE_ADDRESS_217 = 0x8A9U,
	SPN_SOURCE_ADDRESS_218 = 0x8AAU,
	SPN_SOURCE_ADDRESS_219 = 0x8ABU,
	SPN_SOURCE_ADDRESS_220 = 0x8ACU,
	SPN_SOURCE_ADDRESS_221 = 0x8ADU,
	SPN_SOURCE_ADDRESS_222 = 0x8AEU,
	SPN_SOURCE_ADDRESS_223 = 0x8AFU,
	SPN_SOURCE_ADDRESS_224 = 0x8B0U,
	SPN_SOURCE_ADDRESS_225 = 0x8B1U,
	SPN_SOURCE_ADDRESS_226 = 0x8B2U,
	SPN_SOURCE_ADDRESS_227 = 0x8B3U,
	SPN_SOURCE_ADDRESS_228 = 0x8B4U,
	SPN_SOURCE_ADDRESS_229 = 0x8B5U,
	SPN_SOURCE_ADDRESS_230 = 0x8B6U,
	SPN_SOURCE_ADDRESS_231 = 0x8B7U,
	SPN_SOURCE_ADDRESS_232 = 0x8B8U,
	SPN_SOURCE_ADDRESS_233 = 0x8B9U,
	SPN_SOURCE_ADDRESS_234 = 0x8BAU,
	SPN_SOURCE_ADDRESS_235 = 0x8BBU,
	SPN_SOURCE_ADDRESS_236 = 0x8BCU,
	SPN_SOURCE_ADDRESS_237 = 0x8BDU,
	SPN_SOURCE_ADDRESS_238 = 0x8BEU,
	SPN_SOURCE_ADDRESS_239 = 0x8BFU,
	SPN_SOURCE_ADDRESS_240 = 0x8C0U,
	SPN_SOURCE_ADDRESS_241 = 0x8C1U,
	SPN_SOURCE_ADDRESS_242 = 0x8C2U,
	SPN_SOURCE_ADDRESS_243 = 0x8C3U,
	SPN_SOURCE_ADDRESS_244 = 0x8C4U,
	SPN_SOURCE_ADDRESS_245 = 0x8C5U,
	SPN_SOURCE_ADDRESS_246 = 0x8C6U,
	SPN_SOURCE_ADDRESS_247 = 0x8C7U,
	SPN_SOURCE_ADDRESS_248 = 0x8C8U,
	SPN_SOURCE_ADDRESS_249 = 0x8C9U,
	SPN_SOURCE_ADDRESS_250 = 0x8CAU,
	SPN_SOURCE_ADDRESS_251 = 0x8CBU,
	SPN_SOURCE_ADDRESS_252 = 0x8CCU,
	SPN_SOURCE_ADDRESS_253 = 0x8CDU,
	SPN_SOURCE_ADDRESS_254 = 0x8CEU,
	SPN_SOURCE_ADDRESS_255 = 0x8CFU,
	SPN_AUX_VALVE_8_EXTEND_PORT_PRESSURE = 0x8D0U,
	SPN_AUX_VALVE_8_RETRACT_PORT_PRESSURE = 0x8D1U,
	SPN_AUX_VALVE_8_RETURN_PORT_PRESSURE = 0x8D2U,
	SPN_AUX_VALVE_8_PORT_FLOW_COMMAND = 0x8D3U,
	SPN_AUX_VALVE_8_STATE_COMMAND = 0x8D4U,
	SPN_AUX_VALVE_8_FAIL_SAFE_MODE_COMMAND = 0x8D5U,
	SPN_AUX_VALVE_8_FAIL_SAFE_MODE = 0x8D6U,
	SPN_AUX_VALVE_9_EXTEND_PORT_MEASURED_FLOW = 0x8D7U,
	SPN_AUX_VALVE_9_RETRACT_PORT_MEASURED_FLOW = 0x8D8U,
	SPN_AUX_VALVE_9_EXTEND_PORT_ESTIMATED_FLOW = 0x8D9U,
	SPN_AUX_VALVE_9_RETRACT_PORT_ESTIMATED_FLOW = 0x8DAU,
	SPN_AUX_VALVE_9_STATE = 0x8DBU,
	SPN_AUX_VALVE_9_EXTEND_PORT_PRESSURE = 0x8DCU,
	SPN_AUX_VALVE_9_RETRACT_PORT_PRESSURE = 0x8DDU,
	SPN_AUX_VALVE_9_RETURN_PORT_PRESSURE = 0x8DEU,
	SPN_AUX_VALVE_9_PORT_FLOW_COMMAND = 0x8DFU,
	SPN_AUX_VALVE_9_STATE_COMMAND = 0x8E0U,
	SPN_AUX_VALVE_9_FAIL_SAFE_MODE_COMMAND = 0x8E1U,
	SPN_AUX_VALVE_9_FAIL_SAFE_MODE = 0x8E2U,
	SPN_AUX_VALVE_10_EXTEND_PORT_MEASURED_FLOW = 0x8E3U,
	SPN_AUX_VALVE_10_RETRACT_PORT_MEASURED_FLOW = 0x8E4U,
	SPN_AUX_VALVE_10_EXTEND_PORT_ESTIMATED_FLOW = 0x8E5U,
	SPN_AUX_VALVE_10_RETRACT_PORT_ESTIMATED_FLOW = 0x8E6U,
	SPN_AUX_VALVE_10_STATE = 0x8E7U,
	SPN_AUX_VALVE_10_EXTEND_PORT_PRESSURE = 0x8E8U,
	SPN_AUX_VALVE_10_RETRACT_PORT_PRESSURE = 0x8E9U,
	SPN_AUX_VALVE_10_RETURN_PORT_PRESSURE = 0x8EAU,
	SPN_AUX_VALVE_10_PORT_FLOW_COMMAND = 0x8EBU,
	SPN_AUX_VALVE_10_STATE_COMMAND = 0x8ECU,
	SPN_AUX_VALVE_10_FAIL_SAFE_MODE_COMMAND = 0x8EDU,
	SPN_AUX_VALVE_10_FAIL_SAFE_MODE = 0x8EEU,
	SPN_AUX_VALVE_11_EXTEND_PORT_MEASURED_FLOW = 0x8EFU,
	SPN_AUX_VALVE_11_RETRACT_PORT_MEASURED_FLOW = 0x8F0U,
	SPN_AUX_VALVE_11_EXTEND_PORT_ESTIMATED_FLOW = 0x8F1U,
	SPN_AUX_VALVE_11_RETRACT_PORT_ESTIMATED_FLOW = 0x8F2U,
	SPN_AUX_VALVE_11_STATE = 0x8F3U,
	SPN_AUX_VALVE_11_EXTEND_PORT_PRESSURE = 0x8F4U,
	SPN_AUX_VALVE_11_RETRACT_PORT_PRESSURE = 0x8F5U,
	SPN_AUX_VALVE_11_RETURN_PORT_PRESSURE = 0x8F6U,
	SPN_AUX_VALVE_11_PORT_FLOW_COMMAND = 0x8F7U,
	SPN_AUX_VALVE_11_STATE_COMMAND = 0x8F8U,
	SPN_AUX_VALVE_11_FAIL_SAFE_MODE_COMMAND = 0x8F9U,
	SPN_AUX_VALVE_11_FAIL_SAFE_MODE = 0x8FAU,
	SPN_AUX_VALVE_12_EXTEND_PORT_MEASURED_FLOW = 0x8FBU,
	SPN_AUX_VALVE_12_RETRACT_PORT_MEASURED_FLOW = 0x8FCU,
	SPN_AUX_VALVE_12_EXTEND_PORT_ESTIMATED_FLOW = 0x8FDU,
	SPN_AUX_VALVE_12_RETRACT_PORT_ESTIMATED_FLOW = 0x8FEU,
	SPN_AUX_VALVE_12_STATE = 0x8FFU,
	SPN_AUX_VALVE_12_EXTEND_PORT_PRESSURE = 0x900U,
	SPN_AUX_VALVE_12_RETRACT_PORT_PRESSURE = 0x901U,
	SPN_AUX_VALVE_12_RETURN_PORT_PRESSURE = 0x902U,
	SPN_AUX_VALVE_12_PORT_FLOW_COMMAND = 0x903U,
	SPN_AUX_VALVE_12_STATE_COMMAND = 0x904U,
	SPN_AUX_VALVE_12_FAIL_SAFE_MODE_COMMAND = 0x905U,
	SPN_AUX_VALVE_12_FAIL_SAFE_MODE = 0x906U,
	SPN_AUX_VALVE_13_EXTEND_PORT_MEASURED_FLOW = 0x907U,
	SPN_AUX_VALVE_13_RETRACT_PORT_MEASURED_FLOW = 0x908U,
	SPN_AUX_VALVE_13_EXTEND_PORT_ESTIMATED_FLOW = 0x909U,
	SPN_AUX_VALVE_13_RETRACT_PORT_ESTIMATED_FLOW = 0x90AU,
	SPN_AUX_VALVE_13_STATE = 0x90BU,
	SPN_AUX_VALVE_13_EXTEND_PORT_PRESSURE = 0x90CU,
	SPN_AUX_VALVE_13_RETRACT_PORT_PRESSURE = 0x90DU,
	SPN_AUX_VALVE_13_RETURN_PORT_PRESSURE = 0x90EU,
	SPN_AUX_VALVE_13_PORT_FLOW_COMMAND = 0x90FU,
	SPN_AUX_VALVE_13_STATE_COMMAND = 0x910U,
	SPN_AUX_VALVE_13_FAIL_SAFE_MODE_COMMAND = 0x911U,
	SPN_AUX_VALVE_13_FAIL_SAFE_MODE = 0x912U,
	SPN_AUX_VALVE_14_EXTEND_PORT_MEASURED_FLOW = 0x913U,
	SPN_AUX_VALVE_14_RETRACT_PORT_MEASURED_FLOW = 0x914U,
	SPN_AUX_VALVE_14_EXTEND_PORT_ESTIMATED_FLOW = 0x915U,
	SPN_AUX_VALVE_14_RETRACT_PORT_ESTIMATED_FLOW = 0x916U,
	SPN_AUX_VALVE_14_STATE = 0x917U,
	SPN_AUX_VALVE_14_EXTEND_PORT_PRESSURE = 0x918U,
	SPN_AUX_VALVE_14_RETRACT_PORT_PRESSURE = 0x919U,
	SPN_AUX_VALVE_14_RETURN_PORT_PRESSURE = 0x91AU,
	SPN_AUX_VALVE_14_PORT_FLOW_COMMAND = 0x91BU,
	SPN_AUX_VALVE_14_STATE_COMMAND = 0x91CU,
	SPN_AUX_VALVE_14_FAIL_SAFE_MODE_COMMAND = 0x91DU,
	SPN_AUX_VALVE_14_FAIL_SAFE_MODE = 0x91EU,
	SPN_AUX_VALVE_15_EXTEND_PORT_MEASURED_FLOW = 0x91FU,
	SPN_AUX_VALVE_15_RETRACT_PORT_MEASURED_FLOW = 0x920U,
	SPN_AUX_VALVE_15_EXTEND_PORT_ESTIMATED_FLOW = 0x921U,
	SPN_AUX_VALVE_15_RETRACT_PORT_ESTIMATED_FLOW = 0x922U,
	SPN_AUX_VALVE_15_STATE = 0x923U,
	SPN_AUX_VALVE_15_EXTEND_PORT_PRESSURE = 0x924U,
	SPN_AUX_VALVE_15_RETRACT_PORT_PRESSURE = 0x925U,
	SPN_AUX_VALVE_15_RETURN_PORT_PRESSURE = 0x926U,
	SPN_AUX_VALVE_15_PORT_FLOW_COMMAND = 0x927U,
	SPN_AUX_VALVE_15_STATE_COMMAND = 0x928U,
	SPN_AUX_VALVE_15_FAIL_SAFE_MODE_COMMAND = 0x929U,
	SPN_AUX_VALVE_15_FAIL_SAFE_MODE = 0x92AU,
	SPN_HIGH_BEAM_HEAD_LIGHT_COMMAND = 0x92BU,
	SPN_HIGH_BEAM_HEAD_LIGHT_DATA = 0x92CU,
	SPN_LOW_BEAM_HEAD_LIGHT_COMMAND = 0x92DU,
	SPN_LOW_BEAM_HEAD_LIGHT_DATA = 0x92EU,
	SPN_ALTERNATE_BEAM_HEAD_LIGHT_COMMAND = 0x92FU,
	SPN_ALTERNATE_BEAM_HEAD_LIGHT_DATA = 0x930U,
	SPN_TRACTOR_FRONT_LOW_MOUNTED_WORK_LIGHTS_COMMAND = 0x931U,
	SPN_TRACTOR_FRONT_LOW_MOUNTED_WORK_LIGHTS = 0x932U,
	SPN_TRACTOR_FRONT_HIGH_MOUNTED_WORK_LIGHTS_COMMAND = 0x933U,
	SPN_TRACTOR_FRONT_HIGH_MOUNTED_WORK_LIGHTS = 0x934U,
	SPN_TRACTOR_UNDERSIDE_MOUNTED_WORK_LIGHTS_COMMAND = 0x935U,
	SPN_TRACTOR_UNDERSIDE_MOUNTED_WORK_LIGHTS = 0x936U,
	SPN_TRACTOR_REAR_LOW_MOUNTED_WORK_LIGHTS_COMMAND = 0x937U,
	SPN_TRACTOR_REAR_LOW_MOUNTED_WORK_LIGHTS = 0x938U,
	SPN_TRACTOR_REAR_HIGH_MOUNTED_WORK_LIGHTS_COMMAND = 0x939U,
	SPN_TRACTOR_REAR_HIGH_MOUNTED_WORK_LIGHTS = 0x93AU,
	SPN_TRACTOR_SIDE_LOW_MOUNTED_WORK_LIGHTS_COMMAND = 0x93BU,
	SPN_TRACTOR_SIDE_LOW_MOUNTED_WORK_LIGHTS = 0x93CU,
	SPN_TRACTOR_SIDE_HIGH_MOUNTED_WORK_LIGHTS_COMMAND = 0x93DU,
	SPN_TRACTOR_SIDE_HIGH_MOUNTED_WORK_LIGHTS = 0x93EU,
	SPN_LEFT_TURN_SIGNAL_LIGHTS_COMMAND = 0x93FU,
	SPN_LEFT_TURN_SIGNAL_LIGHTS = 0x940U,
	SPN_RIGHT_TURN_SIGNAL_LIGHTS_COMMAND = 0x941U,
	SPN_RIGHT_TURN_SIGNAL_LIGHTS = 0x942U,
	SPN_LEFT_STOP_LIGHT_COMMAND = 0x943U,
	SPN_LEFT_STOP_LIGHT = 0x944U,
	SPN_RIGHT_STOP_LIGHT_COMMAND = 0x945U,
	SPN_RIGHT_STOP_LIGHT = 0x946U,
	SPN_CENTER_STOP_LIGHT_COMMAND = 0x947U,
	SPN_CENTER_STOP_LIGHT = 0x948U,
	SPN_TRACTOR_MARKER_LIGHT_COMMAND = 0x949U,
	SPN_TRACTOR_MARKER_LIGHT = 0x94AU,
	SPN_IMPLEMENT_MARKER_LIGHT_COMMAND = 0x94BU,
	SPN_IMPLEMENT_MARKER_LIGHT = 0x94CU,
	SPN_TRACTOR_CLEARANCE_LIGHT_COMMAND = 0x94DU,
	SPN_TRACTOR_CLEARANCE_LIGHT = 0x94EU,
	SPN_IMPLEMENT_CLEARANCE_LIGHT_COMMAND = 0x94FU,
	SPN_IMPLEMENT_CLEARANCE_LIGHT = 0x950U,
	SPN_ROTATING_BEACON_LIGHT_COMMAND = 0x951U,
	SPN_ROTATING_BEACON_LIGHT = 0x952U,
	SPN_TRACTOR_FRONT_FOG_LIGHTS_COMMAND = 0x953U,
	SPN_TRACTOR_FRONT_FOG_LIGHTS = 0x954U,
	SPN_REAR_FOG_LIGHT_COMMAND = 0x955U,
	SPN_REAR_FOG_LIGHTS = 0x956U,
	SPN_BACK_UP_LIGHT_AND_ALARM_HORN_COMMAND = 0x957U,
	SPN_BACK_UP_LIGHT_AND_ALARM_HORN = 0x958U,
	SPN_LIGHTING_DATA_REQUEST_COMMAND = 0x959U,
	SPN_IMPLEMENT_REAR_WORK_LIGHT = 0x95AU,
	SPN_IMPLEMENT_OEM_OPTION_1_LIGHT_COMMAND = 0x95BU,
	SPN_IMPLEMENT_OEM_OPTION_1_LIGHT = 0x95CU,
	SPN_IMPLEMENT_OEM_OPTION_2_LIGHT_COMMAND = 0x95DU,
	SPN_IMPLEMENT_OEM_OPTION_2_LIGHT = 0x95EU,
	SPN_IMPLEMENT_LEFT_FORWARD_WORK_LIGHT_COMMAND = 0x95FU,
	SPN_IMPLEMENT_LEFT_FORWARD_WORK_LIGHT = 0x960U,
	SPN_IMPLEMENT_RIGHT_FORWARD_WORK_LIGHT_COMMAND = 0x961U,
	SPN_IMPLEMENT_RIGHT_FORWARD_WORK_LIGHT = 0x962U,
	SPN_RUNNING_LIGHT_COMMAND = 0x963U,
	SPN_RUNNING_LIGHT = 0x964U,
	SPN_IMPLEMENT_REAR_WORK_LIGHT_COMMAND = 0x965U,
	SPN_IMPLEMENT_RIGHT_FACING_WORK_LIGHT_COMMAND = 0x966U,
	SPN_IMPLEMENT_RIGHT_FACING_WORK_LIGHT = 0x967U,
	SPN_REAR_POWER_TAKEOFF_ENGAGEMENT = 0x968U,
	SPN_NUMBER_OF_MEMBERS_IN_WORKING_SET_1 = 0x969U,
	SPN_LANGUAGE_CODE_COMMAND = 0x96AU,
	SPN_DECIMAL_SYMBOL_COMMAND = 0x96BU,
	SPN_DATE_COMMAND = 0x96CU,
	SPN_TIME_COMMAND = 0x96DU,
	SPN_DISTANCE_UNIT_COMMAND = 0x96EU,
	SPN_AREA_UNIT_COMMAND = 0x96FU,
	SPN_VOLUME_UNIT_COMMAND = 0x970U,
	SPN_MASS_UNIT_COMMAND_1 = 0x971U,
	SPN_REPETITION_RATE_PARAMETER_1 = 0x972U,
	SPN_DATA_FORMATERROR_CONDITION_1 = 0x973U,
	SPN_PROCESS_DATA_TYPE_1 = 0x974U,
	SPN_PROCESS_DATA_MODIFIER_1 = 0x975U,
	SPN_COUNT_NUMBER = 0x976U,
	SPN_GROUP_NUMBER = 0x977U,
	SPN_ELEMENT_NUMBER = 0x978U,
	SPN_IMPLEMENT_TYPE_1 = 0x979U,
	SPN_IMPLEMENT_POSITION_1 = 0x97AU,
	SPN_DATA_DICTIONARY_ROW_1 = 0x97BU,
	SPN_DATA_DICTIONARY_COLUMN_1 = 0x97CU,
	SPN_PROCESS_VARIABLE_VALUE = 0x97DU,
	SPN_ENGINE_COOLANT_LEVEL_MAIN_RADIATOR = 0x97EU,
	SPN_ENGINE_OIL_RAIL_HIGH_PRESSURE_LEAKAGE = 0x97FU,
	SPN_ENGINE_DEMAND_PERCENT_TORQUE = 0x980U,
	SPN_ENGINE_EXHAUST_EXHAUST_GAS_TEMPERATURE_RIGHT_MANIFOLD = 0x981U,
	SPN_ENGINE_EXHAUST_EXHAUST_GAS_TEMPERATURE_LEFT_MANIFOLD = 0x982U,
	SPN_SEAWATER_PUMP_OUTLET_PRESSURE = 0x983U,
	SPN_GENERATOR_AVERAGE_AC_FREQUENCY = 0x984U,
	SPN_GENERATOR_PHASE_A_AC_FREQUENCY = 0x985U,
	SPN_GENERATOR_PHASE_B_AC_FREQUENCY = 0x986U,
	SPN_GENERATOR_PHASE_C_AC_FREQUENCY = 0x987U,
	SPN_GENERATOR_AVERAGE_LINELINE_AC_RMS_VOLTAGE = 0x988U,
	SPN_GENERATOR_PHASE_AB_LINELINE_AC_RMS_VOLTAGE = 0x989U,
	SPN_GENERATOR_PHASE_BC_LINELINE_AC_RMS_VOLTAGE = 0x98AU,
	SPN_GENERATOR_PHASE_CA_LINELINE_AC_RMS_VOLTAGE = 0x98BU,
	SPN_GENERATOR_AVERAGE_LINENEUTRAL_AC_RMS_VOLTAGE = 0x98CU,
	SPN_GENERATOR_PHASE_A_LINENEUTRAL_AC_RMS_VOLTAGE = 0x98DU,
	SPN_GENERATOR_PHASE_B_LINENEUTRAL_AC_RMS_VOLTAGE = 0x98EU,
	SPN_GENERATOR_PHASE_C_LINENEUTRAL_AC_RMS_VOLTAGE = 0x98FU,
	SPN_GENERATOR_AVERAGE_AC_RMS_CURRENT = 0x990U,
	SPN_GENERATOR_PHASE_A_AC_RMS_CURRENT = 0x991U,
	SPN_GENERATOR_PHASE_B_AC_RMS_CURRENT = 0x992U,
	SPN_GENERATOR_PHASE_C_AC_RMS_CURRENT = 0x993U,
	SPN_GENERATOR_TOTAL_REAL_POWER = 0x994U,
	SPN_GENERATOR_PHASE_A_REAL_POWER = 0x995U,
	SPN_GENERATOR_PHASE_B_REAL_POWER = 0x996U,
	SPN_GENERATOR_PHASE_C_REAL_POWER = 0x997U,
	SPN_GENERATOR_TOTAL_REACTIVE_POWER = 0x998U,
	SPN_GENERATOR_PHASE_A_REACTIVE_POWER = 0x999U,
	SPN_GENERATOR_PHASE_B_REACTIVE_POWER = 0x99AU,
	SPN_GENERATOR_PHASE_C_REACTIVE_POWER = 0x99BU,
	SPN_GENERATOR_TOTAL_APPARENT_POWER = 0x99CU,
	SPN_GENERATOR_PHASE_A_APPARENT_POWER = 0x99DU,
	SPN_GENERATOR_PHASE_B_APPARENT_POWER = 0x99EU,
	SPN_GENERATOR_PHASE_C_APPARENT_POWER = 0x99FU,
	SPN_GENERATOR_OVERALL_POWER_FACTOR = 0x9A0U,
	SPN_GENERATOR_PHASE_A_POWER_FACTOR = 0x9A1U,
	SPN_GENERATOR_PHASE_B_POWER_FACTOR = 0x9A2U,
	SPN_GENERATOR_PHASE_C_POWER_FACTOR = 0x9A3U,
	SPN_GENERATOR_TOTAL_KW_HOURS_EXPORT = 0x9A4U,
	SPN_GENERATOR_TOTAL_KW_HOURS_IMPORT = 0x9A5U,
	SPN_UTILITY_AVERAGE_AC_FREQUENCY = 0x9A6U,
	SPN_UTILITY_PHASE_A_AC_FREQUENCY = 0x9A7U,
	SPN_UTILITY_PHASE_B_AC_FREQUENCY = 0x9A8U,
	SPN_UTILITY_PHASE_C_AC_FREQUENCY = 0x9A9U,
	SPN_UTILITY_AVERAGE_LINELINE_AC_RMS_VOLTAGE = 0x9AAU,
	SPN_UTILITY_PHASE_AB_LINELINE_AC_RMS_VOLTAGE = 0x9ABU,
	SPN_UTILITY_PHASE_BC_LINELINE_AC_RMS_VOLTAGE = 0x9ACU,
	SPN_UTILITY_PHASE_CA_LINELINE_AC_RMS_VOLTAGE = 0x9ADU,
	SPN_UTILITY_AVERAGE_LINENEUTRAL_AC_RMS_VOLTAGE = 0x9AEU,
	SPN_UTILITY_PHASE_A_LINENEUTRAL_AC_RMS_VOLTAGE = 0x9AFU,
	SPN_UTILITY_PHASE_B_LINENEUTRAL_AC_RMS_VOLTAGE = 0x9B0U,
	SPN_UTILITY_PHASE_C_LINENEUTRAL_AC_RMS_VOLTAGE = 0x9B1U,
	SPN_UTILITY_AVERAGE_AC_RMS_CURRENT = 0x9B2U,
	SPN_UTILITY_PHASE_A_AC_RMS_CURRENT = 0x9B3U,
	SPN_UTILITY_PHASE_B_AC_RMS_CURRENT = 0x9B4U,
	SPN_UTILITY_PHASE_C_AC_RMS_CURRENT = 0x9B5U,
	SPN_UTILITY_TOTAL_REAL_POWER = 0x9B6U,
	SPN_UTILITY_PHASE_A_REAL_POWER = 0x9B7U,
	SPN_UTILITY_PHASE_B_REAL_POWER = 0x9B8U,
	SPN_UTILITY_PHASE_C_REAL_POWER = 0x9B9U,
	SPN_UTILITY_TOTAL_REACTIVE_POWER = 0x9BAU,
	SPN_UTILITY_PHASE_A_REACTIVE_POWER = 0x9BBU,
	SPN_UTILITY_PHASE_B_REACTIVE_POWER = 0x9BCU,
	SPN_UTILITY_PHASE_C_REACTIVE_POWER = 0x9BDU,
	SPN_UTILITY_TOTAL_APPARENT_POWER = 0x9BEU,
	SPN_UTILITY_PHASE_A_APPARENT_POWER = 0x9BFU,
	SPN_UTILITY_PHASE_B_APPARENT_POWER = 0x9C0U,
	SPN_UTILITY_PHASE_C_APPARENT_POWER = 0x9C1U,
	SPN_UTILITY_OVERALL_POWER_FACTOR = 0x9C2U,
	SPN_UTILITY_PHASE_A_POWER_FACTOR = 0x9C3U,
	SPN_UTILITY_PHASE_B_POWER_FACTOR = 0x9C4U,
	SPN_UTILITY_PHASE_C_POWER_FACTOR = 0x9C5U,
	SPN_UTILITY_TOTAL_KW_HOURS_EXPORT = 0x9C6U,
	SPN_UTILITY_TOTAL_KW_HOURS_IMPORT = 0x9C7U,
	SPN_BUS_1_AVERAGE_AC_FREQUENCY = 0x9C8U,
	SPN_BUS_1_PHASE_A_AC_FREQUENCY = 0x9C9U,
	SPN_BUS_1_PHASE_B_AC_FREQUENCY = 0x9CAU,
	SPN_BUS_1_PHASE_C_AC_FREQUENCY = 0x9CBU,
	SPN_BUS_1_AVERAGE_LINELINE_AC_RMS_VOLTAGE = 0x9CCU,
	SPN_BUS_1_PHASE_AB_LINELINE_AC_RMS_VOLTAGE = 0x9CDU,
	SPN_BUS_1_PHASE_BC_LINELINE_AC_RMS_VOLTAGE = 0x9CEU,
	SPN_BUS_1_PHASE_CA_LINELINE_AC_RMS_VOLTAGE = 0x9CFU,
	SPN_BUS_1_AVERAGE_LINENEUTRAL_AC_RMS_VOLTAGE = 0x9D0U,
	SPN_BUS_1_PHASE_A_LINENEUTRAL_AC_RMS_VOLTAGE = 0x9D1U,
	SPN_BUS_1_PHASE_B_LINENEUTRAL_AC_RMS_VOLTAGE = 0x9D2U,
	SPN_BUS_1_PHASE_C_LINENEUTRAL_AC_RMS_VOLTAGE = 0x9D3U,
	SPN_BUS_1GENERATOR_AC_PHASE_DIFFERENCE = 0x9D4U,
	SPN_BUS_1UTILITY_AC_PHASE_DIFFERENCE = 0x9D5U,
	SPN_GENERATOR_OVERALL_POWER_FACTOR_LAGGING = 0x9D6U,
	SPN_GENERATOR_PHASE_A_POWER_FACTOR_LAGGING = 0x9D7U,
	SPN_GENERATOR_PHASE_B_POWER_FACTOR_LAGGING = 0x9D8U,
	SPN_GENERATOR_PHASE_C_POWER_FACTOR_LAGGING = 0x9D9U,
	SPN_UTILITY_OVERALL_POWER_FACTOR_LAGGING = 0x9DAU,
	SPN_UTILITY_PHASE_A_POWER_FACTOR_LAGGING = 0x9DBU,
	SPN_UTILITY_PHASE_B_POWER_FACTOR_LAGGING = 0x9DCU,
	SPN_UTILITY_PHASE_C_POWER_FACTOR_LAGGING = 0x9DDU,
	SPN_BUS_1GENERATOR_PHASE_MATCH = 0x9DEU,
	SPN_BUS_1GENERATOR_VOLTAGE_MATCH = 0x9DFU,
	SPN_BUS_1GENERATOR_FREQUENCY_MATCH = 0x9E0U,
	SPN_BUS_1GENERATOR_IN_SYNC = 0x9E1U,
	SPN_BUS_1GENERATOR_DEAD_BUS = 0x9E2U,
	SPN_BUS_1UTILITY_PHASE_MATCH = 0x9E3U,
	SPN_BUS_1UTILITY_VOLTAGE_MATCH = 0x9E4U,
	SPN_BUS_1UTILITY_FREQUENCY_MATCH = 0x9E5U,
	SPN_BUS_1UTILITY_IN_SYNC = 0x9E6U,
	SPN_BUS_1UTILITY_DEAD_BUS = 0x9E7U,
	SPN_TRANSMISSION_MODE_1_INDICATOR = 0x9E8U,
	SPN_TRANSMISSION_MODE_2_INDICATOR = 0x9E9U,
	SPN_TRANSMISSION_MODE_3_INDICATOR = 0x9EAU,
	SPN_TRANSMISSION_MODE_4_INDICATOR = 0x9EBU,
	SPN_PARAMETER_GROUP_NUMBER_0 = 0x9ECU,
	SPN_CONTROL_BYTE_1 = 0x9EDU,
	SPN_GROUP_FUNCTION_VALUE_1 = 0x9EEU,
	SPN_PARAMETER_GROUP_NUMBER_1 = 0x9EFU,
	SPN_GROUP_FUNCTION_VALUE_2 = 0x9F0U,
	SPN_PARAMETER_GROUP_NUMBER_2 = 0x9F1U,
	SPN_GROUP_FUNCTION_VALUE_3 = 0x9F2U,
	SPN_PARAMETER_GROUP_NUMBER_3 = 0x9F3U,
	SPN_GROUP_FUNCTION_VALUE_4 = 0x9F4U,
	SPN_PARAMETER_GROUP_NUMBER_4 = 0x9F5U,
	SPN_MANUFACTURER_SPECIFIC_INFORMATION_1 = 0x9F6U,
	SPN_MANUFACTURER_DEFINED_USAGE_PROPB_PDU2_1 = 0x9F7U,
	SPN_PARAMETER_GROUP_NUMBER_OF_REQUESTED_INFORMATION = 0x9F8U,
	SPN_LENGTH_OF_DATA_FOR_THE_REPORTED_PGN = 0x9F9U,
	SPN_SHORT_NAME_OF_ACTUAL_REPORTING_DEVICE = 0x9FAU,
	SPN_TRANSFER_DATA = 0x9FBU,
	SPN_CONTROL_BYTE_2 = 0x9FCU,
	SPN_TOTAL_MESSAGE_SIZE_TP_CM_RTS_1 = 0x9FDU,
	SPN_TOTAL_NUMBER_OF_PACKETS_1 = 0x9FEU,
	SPN_MAXIMUM_NUMBER_OF_PACKETS = 0x9FFU,
	SPN_PARAMETER_GROUP_NUMBER_OF_THE_PACKETED_MESSAGE_1 = 0xA00U,
	SPN_NUMBER_OF_PACKETS_THAT_CAN_BE_SENT = 0xA01U,
	SPN_NEXT_PACKET_NUMBER_TO_BE_SENT = 0xA02U,
	SPN_PARAMETER_GROUP_NUMBER_OF_THE_PACKETED_MESSAGE_2 = 0xA03U,
	SPN_TOTAL_MESSAGE_SIZE_1 = 0xA04U,
	SPN_TOTAL_NUMBER_OF_PACKETS_2 = 0xA05U,
	SPN_PARAMETER_GROUP_NUMBER_OF_THE_PACKETED_MESSAGE_3 = 0xA06U,
	SPN_TOTAL_MESSAGE_SIZE_2 = 0xA07U,
	SPN_TOTAL_NUMBER_OF_PACKETS_3 = 0xA08U,
	SPN_PARAMETER_GROUP_NUMBER_OF_THE_PACKETED_MESSAGE_4 = 0xA09U,
	SPN_CONNECTION_ABORT_REASON = 0xA0AU,
	SPN_PARAMETER_GROUP_NUMBER_OF_PACKETED_MESSAGE = 0xA0BU,
	SPN_SEQUENCE_NUMBER = 0xA0CU,
	SPN_PACKETIZED_DATA = 0xA0DU,
	SPN_PARAMETER_GROUP_NUMBER_5 = 0xA0EU,
	SPN_USE_TRANSFER_MODE = 0xA0FU,
	SPN_LASER_RECEIVER_TYPE = 0xA10U,
	SPN_DISPLAY_DEADBANDS = 0xA11U,
	SPN_LED_PATTERN_CONTROL = 0xA12U,
	SPN_NET_BATTERY_CURRENT_2 = 0xA13U,
	SPN_HYDRAULIC_BRAKE_PRESSURE_CIRCUIT_1 = 0xA14U,
	SPN_HYDRAULIC_BRAKE_PRESSURE_CIRCUIT_2 = 0xA15U,
	SPN_HYDRAULIC_BRAKE_PRESSURE_SUPPLY_STATE_CIRCUIT_1 = 0xA16U,
	SPN_HYDRAULIC_BRAKE_PRESSURE_SUPPLY_STATE_CIRCUIT_2 = 0xA17U,
	SPN_HYDRAULIC_BRAKE_PRESSURE_WARNING_STATE_CIRCUIT_1 = 0xA18U,
	SPN_HYDRAULIC_BRAKE_PRESSURE_WARNING_STATE_CIRCUIT_2 = 0xA19U,
	SPN_TIRE_AIR_LEAKAGE_RATE = 0xA1AU,
	SPN_TIRE_PRESSURE_THRESHOLD_DETECTION = 0xA1BU,
	SPN_MAXIMUM_VEHICLE_SPEED_LIMIT_1 = 0xA1CU,
	SPN_MAXIMUM_VEHICLE_SPEED_LIMIT_2 = 0xA1DU,
	SPN_MAXIMUM_VEHICLE_SPEED_LIMIT_3 = 0xA1EU,
	SPN_MAXIMUM_VEHICLE_SPEED_LIMIT_4 = 0xA1FU,
	SPN_MAXIMUM_VEHICLE_SPEED_LIMIT_5 = 0xA20U,
	SPN_MAXIMUM_VEHICLE_SPEED_LIMIT_6 = 0xA21U,
	SPN_MAXIMUM_VEHICLE_SPEED_LIMIT_7 = 0xA22U,
	SPN_APPLIED_VEHICLE_SPEED_LIMIT = 0xA23U,
	SPN_SELECTED_MAXIMUM_VEHICLE_SPEED_LIMIT = 0xA24U,
	SPN_IMPLEMENT_LEFT_FACING_WORK_LIGHT_COMMAND = 0xA25U,
	SPN_IMPLEMENT_LEFT_FACING_WORK_LIGHT = 0xA26U,
	SPN_FIRE_APPARATUS_PUMP_ENGAGEMENT = 0xA27U,
	SPN_PAYLOAD_PERCENTAGE = 0xA28U,
	SPN_TRAVEL_VELOCITY_CONTROL_POSITION = 0xA29U,
	SPN_HYDRAULIC_OIL_LEVEL = 0xA2AU,
	SPN_PNEUMATIC_SUPPLY_PRESSURE_REQUEST = 0xA2BU,
	SPN_PARKING_ANDOR_TRAILER_AIR_PRESSURE_REQUEST = 0xA2CU,
	SPN_SERVICE_BRAKE_AIR_PRESSURE_REQUEST_CIRCUIT_1 = 0xA2DU,
	SPN_SERVICE_BRAKE_AIR_PRESSURE_REQUEST_CIRCUIT_2 = 0xA2EU,
	SPN_AUXILIARY_EQUIPMENT_SUPPLY_PRESSURE_REQUEST = 0xA2FU,
	SPN_AIR_SUSPENSION_SUPPLY_PRESSURE_REQUEST = 0xA30U,
	SPN_CAB_AC_REFRIGERANT_COMPRESSOR_OUTLET_PRESSURE = 0xA31U,
	SPN_SOLAR_INTENSITY_PERCENT = 0xA32U,
	SPN_SOLAR_SENSOR_MAXIMUM = 0xA33U,
	SPN_FRONT_WHEEL_DRIVE_ACTUATOR_STATUS = 0xA34U,
	SPN_DRIVE_AXLE_LUBE_PRESSURE = 0xA35U,
	SPN_STEERING_AXLE_LUBE_PRESSURE = 0xA36U,
	SPN_ENGINE_THROTTLE_SYNCHRONIZATION_MODE_STATUS = 0xA37U,
	SPN_TROLLING_MODE_STATUS = 0xA38U,
	SPN_SLOW_VESSEL_MODE_STATUS = 0xA39U,
	SPN_SUSPEND_SIGNAL = 0xA3AU,
	SPN_SUSPEND_DURATION = 0xA3BU,
	SPN_BRAKE_LINING_DISPLAY = 0xA3CU,
	SPN_PNEUMATIC_BRAKE_PRESSURE_LIMITATION_VALVE_FRONT_AXLE = 0xA3DU,
	SPN_HILLHOLDER_SYSTEM = 0xA3EU,
	SPN_ACCELERATOR_PEDAL_1_CHANNEL_2 = 0xA3FU,
	SPN_ACCELERATOR_PEDAL_1_CHANNEL_3 = 0xA40U,
	SPN_ACCELERATOR_PEDAL_2_CHANNEL_2 = 0xA41U,
	SPN_ACCELERATOR_PEDAL_2_CHANNEL_3 = 0xA42U,
	SPN_ENGINE_GASEOUS_FUEL_SHUTOFF_VALVE_HIGH_PRESSURE = 0xA43U,
	SPN_ENGINE_GASEOUS_FUEL_SHUTOFF_VALVE_LOW_PRESSURE = 0xA44U,
	SPN_ENGINE_TURBOCHARGER_1_COMPRESSOR_OUTLET_TEMPERATURE = 0xA45U,
	SPN_ENGINE_CHARGE_AIR_COOLER_OUTLET_TEMPERATURE = 0xA46U,
	SPN_ENGINE_CHARGE_AIR_COOLER_OUTLET_PRESSURE = 0xA47U,
	SPN_ENGINE_CHARGE_AIR_COOLER_BYPASS = 0xA48U,
	SPN_ENGINE_VARIABLE_GEOMETRY_TURBOCHARGER_VGT_1_NOZZLE_POSITION = 0xA49U,
	SPN_POWER_RELAY = 0xA4AU,
	SPN_NEUTRAL_ONLY_POWER_RELAY = 0xA4BU,
	SPN_WINDSHIELD_WIPER_MOTOR_ONOFF = 0xA4CU,
	SPN_WINDSHIELD_WIPER_MOTOR_SPEED = 0xA4DU,
	SPN_DIFFERENTIAL_LOCK_CONTROL_VALVE_2 = 0xA4EU,
	SPN_CAB_DOOR_LOCK_CONTROL = 0xA4FU,
	SPN_CAB_DOOR_UNLOCK_CONTROL = 0xA50U,
	SPN_HORN = 0xA51U,
	SPN_MIRROR_HEATER = 0xA52U,
	SPN_BATTERY_MONITOR_LOAD_1 = 0xA53U,
	SPN_BATTERY_MONITOR_LOAD_2 = 0xA54U,
	SPN_ECU_WAKE_UP_CONTROL = 0xA55U,
	SPN_AUXILIARY_OUTPUT_4 = 0xA56U,
	SPN_AUXILIARY_OUTPUT_5 = 0xA57U,
	SPN_MAINTENANCE_LAMP = 0xA58U,
	SPN_LOW_AIR_PRESSURE = 0xA59U,
	SPN_FAN_OVERRIDE_INDICATOR = 0xA5AU,
	SPN_INTERIOR_LAMPS = 0xA5BU,
	SPN_SWITCH_DIAGNOSTIC_ENABLE = 0xA5CU,
	SPN_HEADLAMP_LOW_BEAM_LEFT_1 = 0xA5DU,
	SPN_HEADLAMP_LOW_BEAM_LEFT_2 = 0xA5EU,
	SPN_HEADLAMP_LOW_BEAM_RIGHT_1 = 0xA5FU,
	SPN_HEADLAMP_LOW_BEAM_RIGHT_2 = 0xA60U,
	SPN_ENGINE_AUXILIARY_COOLING_SYSTEM = 0xA61U,
	SPN_ENGINE_INLET_AIR_PRECLEANER = 0xA62U,
	SPN_ENGINE_EXHAUST_GAS_RECIRCULATION_EGR_MASS_FLOW_RATE = 0xA63U,
	SPN_JOYSTICK_1_XAXIS_POSITION = 0xA64U,
	SPN_JOYSTICK_1_YAXIS_POSITION = 0xA65U,
	SPN_JOYSTICK_1_GRIP_XAXIS_POSITION = 0xA66U,
	SPN_JOYSTICK_1_GRIP_YAXIS_POSITION = 0xA67U,
	SPN_JOYSTICK_1_THETAAXIS_POSITION = 0xA68U,
	SPN_JOYSTICK_1_XAXIS_LEVER_RIGHT_POSITIVE_POSITION_STATUS = 0xA69U,
	SPN_JOYSTICK_1_YAXIS_LEVER_FORWARD_POSITIVE_POSITION_STATUS = 0xA6AU,
	SPN_JOYSTICK_1_GRIP_XAXIS_LEVER_RIGHT_POSITIVE_POSITION_STATUS = 0xA6BU,
	SPN_JOYSTICK_1_GRIP_YAXIS_LEVER_FORWARD_POSITIVE_POSITION_STATUS = 0xA6CU,
	SPN_JOYSTICK_1_THETAAXIS_CLOCKWISE_POSITIVE_POSITION_STATUS = 0xA6DU,
	SPN_JOYSTICK_1_XAXIS_LEVER_LEFT_NEGATIVE_POSITION_STATUS = 0xA6EU,
	SPN_JOYSTICK_1_YAXIS_LEVER_BACK_NEGATIVE_POSITION_STATUS = 0xA6FU,
	SPN_JOYSTICK_1_GRIP_XAXIS_LEVER_LEFT_NEGATIVE_POSITION_STATUS = 0xA70U,
	SPN_JOYSTICK_1_GRIP_YAXIS_LEVER_BACK_NEGATIVE_POSITION_STATUS = 0xA71U,
	SPN_JOYSTICK_1_THETAAXIS_COUNTERCLOCKWISE_NEGATIVE_POSITION_STATUS = 0xA72U,
	SPN_JOYSTICK_1_XAXIS_NEUTRAL_POSITION_STATUS = 0xA73U,
	SPN_JOYSTICK_1_YAXIS_NEUTRAL_POSITION_STATUS = 0xA74U,
	SPN_JOYSTICK_1_GRIP_XAXIS_NEUTRAL_POSITION_STATUS = 0xA75U,
	SPN_JOYSTICK_1_GRIP_YAXIS_NEUTRAL_POSITION_STATUS = 0xA76U,
	SPN_JOYSTICK_1_THETAAXIS_NEUTRAL_POSITION_STATUS = 0xA77U,
	SPN_JOYSTICK_1_XAXIS_DETENT_POSITION_STATUS = 0xA78U,
	SPN_JOYSTICK_1_YAXIS_DETENT_POSITION_STATUS = 0xA79U,
	SPN_JOYSTICK_1_GRIP_XAXIS_DETENT_POSITION_STATUS = 0xA7AU,
	SPN_JOYSTICK_1_GRIP_YAXIS_DETENT_POSITION_STATUS = 0xA7BU,
	SPN_JOYSTICK_1_THETAAXIS_DETENT_POSITION_STATUS = 0xA7CU,
	SPN_JOYSTICK_1_BUTTON_1_PRESSED_STATUS = 0xA7DU,
	SPN_JOYSTICK_1_BUTTON_2_PRESSED_STATUS = 0xA7EU,
	SPN_JOYSTICK_1_BUTTON_4_PRESSED_STATUS = 0xA80U,
	SPN_JOYSTICK_1_BUTTON_5_PRESSED_STATUS = 0xA81U,
	SPN_JOYSTICK_1_BUTTON_6_PRESSED_STATUS = 0xA82U,
	SPN_JOYSTICK_1_BUTTON_7_PRESSED_STATUS = 0xA83U,
	SPN_JOYSTICK_1_BUTTON_8_PRESSED_STATUS = 0xA84U,
	SPN_JOYSTICK_1_BUTTON_9_PRESSED_STATUS = 0xA85U,
	SPN_JOYSTICK_1_BUTTON_10_PRESSED_STATUS = 0xA86U,
	SPN_JOYSTICK_1_BUTTON_11_PRESSED_STATUS = 0xA87U,
	SPN_JOYSTICK_1_BUTTON_12_PRESSED_STATUS = 0xA88U,
	SPN_JOYSTICK_2_XAXIS_POSITION = 0xA89U,
	SPN_JOYSTICK_2_YAXIS_POSITION = 0xA8AU,
	SPN_JOYSTICK_2_GRIP_XAXIS_POSITION = 0xA8BU,
	SPN_JOYSTICK_2_GRIP_YAXIS_POSITION = 0xA8CU,
	SPN_JOYSTICK_2_THETAAXIS_POSITION = 0xA8DU,
	SPN_JOYSTICK_2_XAXIS_LEVER_RIGHT_POSITIVE_POSITION_STATUS = 0xA8EU,
	SPN_JOYSTICK_2_YAXIS_LEVER_FORWARD_POSITIVE_POSITION_STATUS = 0xA8FU,
	SPN_JOYSTICK_2_GRIP_XAXIS_LEVER_RIGHT_POSITIVE_POSITION_STATUS = 0xA90U,
	SPN_JOYSTICK_2_GRIP_YAXIS_LEVER_FORWARD_POSITIVE_POSITION_STATUS = 0xA91U,
	SPN_JOYSTICK_2_THETAAXIS_CLOCKWISE_POSITIVE_POSITION_STATUS = 0xA92U,
	SPN_JOYSTICK_2_XAXIS_LEVER_LEFT_NEGATIVE_POSITION_STATUS = 0xA93U,
	SPN_JOYSTICK_2_YAXIS_LEVER_BACK_NEGATIVE_POSITION_STATUS = 0xA94U,
	SPN_JOYSTICK_2_GRIP_XAXIS_LEVER_LEFT_NEGATIVE_POSITION_STATUS = 0xA95U,
	SPN_JOYSTICK_2_GRIP_YAXIS_LEVER_BACK_NEGATIVE_POSITION_STATUS = 0xA96U,
	SPN_JOYSTICK_2_THETAAXIS_COUNTERCLOCKWISE_NEGATIVE_POSITION_STATUS = 0xA97U,
	SPN_JOYSTICK_2_XAXIS_NEUTRAL_POSITION_STATUS = 0xA98U,
	SPN_JOYSTICK_2_YAXIS_NEUTRAL_POSITION_STATUS = 0xA99U,
	SPN_JOYSTICK_2_GRIP_XAXIS_NEUTRAL_POSITION_STATUS = 0xA9AU,
	SPN_JOYSTICK_2_GRIP_YAXIS_NEUTRAL_POSITION_STATUS = 0xA9BU,
	SPN_JOYSTICK_2_THETAAXIS_NEUTRAL_POSITION_STATUS = 0xA9CU,
	SPN_JOYSTICK_2_XAXIS_DETENT_POSITION_STATUS = 0xA9DU,
	SPN_JOYSTICK_2_YAXIS_DETENT_POSITION_STATUS = 0xA9EU,
	SPN_JOYSTICK_2_GRIP_XAXIS_DETENT_POSITION_STATUS = 0xA9FU,
	SPN_JOYSTICK_2_GRIP_YAXIS_DETENT_POSITION_STATUS = 0xAA0U,
	SPN_JOYSTICK_2_THETAAXIS_DETENT_POSITION_STATUS = 0xAA1U,
	SPN_JOYSTICK_2_BUTTON_1_PRESSED_STATUS = 0xAA2U,
	SPN_JOYSTICK_2_BUTTON_2_PRESSED_STATUS = 0xAA3U,
	SPN_JOYSTICK_2_BUTTON_3_PRESSED_STATUS = 0xAA4U,
	SPN_JOYSTICK_2_BUTTON_4_PRESSED_STATUS = 0xAA5U,
	SPN_JOYSTICK_2_BUTTON_5_PRESSED_STATUS = 0xAA6U,
	SPN_JOYSTICK_2_BUTTON_6_PRESSED_STATUS = 0xAA7U,
	SPN_JOYSTICK_2_BUTTON_7_PRESSED_STATUS = 0xAA8U,
	SPN_JOYSTICK_2_BUTTON_8_PRESSED_STATUS = 0xAA9U,
	SPN_JOYSTICK_2_BUTTON_9_PRESSED_STATUS = 0xAAAU,
	SPN_JOYSTICK_2_BUTTON_10_PRESSED_STATUS = 0xAABU,
	SPN_JOYSTICK_2_BUTTON_11_PRESSED_STATUS = 0xAACU,
	SPN_JOYSTICK_2_BUTTON_12_PRESSED_STATUS = 0xAADU,
	SPN_JOYSTICK_3_XAXIS_POSITION = 0xAAEU,
	SPN_JOYSTICK_3_YAXIS_POSITION = 0xAAFU,
	SPN_JOYSTICK_3_GRIP_XAXIS_POSITION = 0xAB0U,
	SPN_JOYSTICK_3_GRIP_YAXIS_POSITION = 0xAB1U,
	SPN_JOYSTICK_3_THETAAXIS_POSITION = 0xAB2U,
	SPN_JOYSTICK_3_XAXIS_LEVER_RIGHT_POSITIVE_POSITION_STATUS = 0xAB3U,
	SPN_JOYSTICK_3_YAXIS_LEVER_FORWARD_POSITIVE_POSITION_STATUS = 0xAB4U,
	SPN_JOYSTICK_3_GRIP_XAXIS_LEVER_RIGHT_POSITIVE_POSITION_STATUS = 0xAB5U,
	SPN_JOYSTICK_3_GRIP_YAXIS_LEVER_FORWARD_POSITIVE_POSITION_STATUS = 0xAB6U,
	SPN_JOYSTICK_3_THETAAXIS_CLOCKWISE_POSITIVE_POSITION_STATUS = 0xAB7U,
	SPN_JOYSTICK_3_XAXIS_LEVER_LEFT_NEGATIVE_POSITION_STATUS = 0xAB8U,
	SPN_JOYSTICK_3_YAXIS_LEVER_BACK_NEGATIVE_POSITION_STATUS = 0xAB9U,
	SPN_JOYSTICK_3_GRIP_XAXIS_LEVER_LEFT_NEGATIVE_POSITION_STATUS = 0xABAU,
	SPN_JOYSTICK_3_GRIP_YAXIS_LEVER_BACK_NEGATIVE_POSITION_STATUS = 0xABBU,
	SPN_JOYSTICK_3_THETAAXIS_COUNTERCLOCKWISE_NEGATIVE_POSITION_STATUS = 0xABCU,
	SPN_JOYSTICK_3_XAXIS_NEUTRAL_POSITION_STATUS = 0xABDU,
	SPN_JOYSTICK_3_YAXIS_NEUTRAL_POSITION_STATUS = 0xABEU,
	SPN_JOYSTICK_3_GRIP_XAXIS_NEUTRAL_POSITION_STATUS = 0xABFU,
	SPN_JOYSTICK_3_GRIP_YAXIS_NEUTRAL_POSITION_STATUS = 0xAC0U,
	SPN_JOYSTICK_3_THETAAXIS_NEUTRAL_POSITION_STATUS = 0xAC1U,
	SPN_JOYSTICK_3_XAXIS_DETENT_POSITION_STATUS = 0xAC2U,
	SPN_JOYSTICK_3_YAXIS_DETENT_POSITION_STATUS = 0xAC3U,
	SPN_JOYSTICK_3_GRIP_XAXIS_DETENT_POSITION_STATUS = 0xAC4U,
	SPN_JOYSTICK_3_GRIP_YAXIS_DETENT_POSITION_STATUS = 0xAC5U,
	SPN_JOYSTICK_3_THETAAXIS_DETENT_POSITION_STATUS = 0xAC6U,
	SPN_JOYSTICK_3_BUTTON_1_PRESSED_STATUS = 0xAC7U,
	SPN_JOYSTICK_3_BUTTON_2_PRESSED_STATUS = 0xAC8U,
	SPN_JOYSTICK_3_BUTTON_3_PRESSED_STATUS = 0xAC9U,
	SPN_JOYSTICK_3_BUTTON_4_PRESSED_STATUS = 0xACAU,
	SPN_JOYSTICK_3_BUTTON_5_PRESSED_STATUS = 0xACBU,
	SPN_JOYSTICK_3_BUTTON_6_PRESSED_STATUS = 0xACCU,
	SPN_JOYSTICK_3_BUTTON_7_PRESSED_STATUS = 0xACDU,
	SPN_JOYSTICK_3_BUTTON_8_PRESSED_STATUS = 0xACEU,
	SPN_JOYSTICK_3_BUTTON_9_PRESSED_STATUS = 0xACFU,
	SPN_JOYSTICK_3_BUTTON_10_PRESSED_STATUS = 0xAD0U,
	SPN_JOYSTICK_3_BUTTON_11_PRESSED_STATUS = 0xAD1U,
	SPN_JOYSTICK_3_BUTTON_12_PRESSED_STATUS = 0xAD2U,
	SPN_RESERVED_FOR_ASSIGNMENT_1 = 0xAD3U,
	SPN_RESERVED_FOR_ASSIGNMENT_2 = 0xAD4U,
	SPN_RESERVED_FOR_ASSIGNMENT_3 = 0xAD5U,
	SPN_RESERVED_FOR_ASSIGNMENT_4 = 0xAD6U,
	SPN_RESERVED_FOR_ASSIGNMENT_5 = 0xAD7U,
	SPN_RESERVED_FOR_ASSIGNMENT_6 = 0xAD8U,
	SPN_RESERVED_FOR_ASSIGNMENT_7 = 0xAD9U,
	SPN_RESERVED_FOR_ASSIGNMENT_8 = 0xADAU,
	SPN_RESERVED_FOR_ASSIGNMENT_9 = 0xADBU,
	SPN_RESERVED_FOR_ASSIGNMENT_10 = 0xADCU,
	SPN_RESERVED_FOR_ASSIGNMENT_11 = 0xADDU,
	SPN_RESERVED_FOR_ASSIGNMENT_12 = 0xADEU,
	SPN_RESERVED_FOR_ASSIGNMENT_13 = 0xADFU,
	SPN_RESERVED_FOR_ASSIGNMENT_14 = 0xAE0U,
	SPN_RESERVED_FOR_ASSIGNMENT_15 = 0xAE1U,
	SPN_RESERVED_FOR_ASSIGNMENT_16 = 0xAE2U,
	SPN_RESERVED_FOR_ASSIGNMENT_17 = 0xAE3U,
	SPN_RESERVED_FOR_ASSIGNMENT_18 = 0xAE4U,
	SPN_ENGINE_TURBOCHARGER_1_CALCULATED_TURBINE_INLET_TEMPERATURE = 0xAE5U,
	SPN_ENGINE_TURBOCHARGER_1_CALCULATED_TURBINE_OUTLET_TEMPERATURE = 0xAE6U,
	SPN_ENGINE_EXHAUST_GAS_RECIRCULATION_EGR_VALVE_CONTROL = 0xAE7U,
	SPN_ENGINE_VARIABLE_GEOMETRY_TURBOCHARGER_VGT_AIR_CONTROL_SHUTOFF_VALVE = 0xAE8U,
	SPN_LASER_STRIKE_DATA_LATENCY = 0xAE9U,
	SPN_ABSOLUTE_LASER_STRIKE_POSITION = 0xAEAU,
	SPN_ENGINE_VARIABLE_GEOMETRY_TURBOCHARGER_VGT_1_ACTUATOR_POSITION = 0xAEBU,
	SPN_TRANSFER_CASE_SELECTOR_SWITCH = 0xAECU,
	SPN_ENGINE_INJECTOR_GROUP_1 = 0xAEDU,
	SPN_ENGINE_INJECTOR_GROUP_2 = 0xAEEU,
	SPN_ENGINE_TURBOCHARGER_2_COMPRESSOR_OUTLET_TEMPERATURE = 0xAEFU,
	SPN_ENGINE_TURBOCHARGER_3_COMPRESSOR_OUTLET_TEMPERATURE = 0xAF0U,
	SPN_ENGINE_TURBOCHARGER_4_COMPRESSOR_OUTLET_TEMPERATURE = 0xAF1U,
	SPN_DATA_MEMORY_USAGE = 0xAF2U,
	SPN_KEEPALIVE_BATTERY_CONSUMPTION = 0xAF3U,
	SPN_FMSSTANDARD_DIAGNOSTICS_SUPPORTED = 0xAF4U,
	SPN_FMSSTANDARD_REQUESTS_SUPPORTED = 0xAF5U,
	SPN_FMSSTANDARD_SWVERSION_SUPPORTED = 0xAF6U,
	SPN_ENGINE_FUEL_SHUTOFF_VALVE_2 = 0xAF7U,
	SPN_KEYPAD = 0xAF8U,
	SPN_ENGINE_AIR_FILTER_2_DIFFERENTIAL_PRESSURE = 0xAF9U,
	SPN_ENGINE_AIR_FILTER_3_DIFFERENTIAL_PRESSURE = 0xAFAU,
	SPN_ENGINE_AIR_FILTER_4_DIFFERENTIAL_PRESSURE = 0xAFBU,
	SPN_ENGINE_OVERSPEED_TEST = 0xAFCU,
	SPN_ENGINE_AIR_SHUTOFF_COMMAND_STATUS = 0xAFDU,
	SPN_ENGINE_ALARM_OUTPUT_COMMAND_STATUS = 0xAFEU,
	SPN_ENGINE_ALARM_ACKNOWLEDGE = 0xAFFU,
	SPN_SIMULTANEOUS_UPSHIFT_AND_DOWNSHIFT = 0xB00U,
	SPN_OPERATOR_USING_CLUTCH_PEDAL_DURING_NON_RECOVERABLE_CLUTCH_FAULT = 0xB01U,
	SPN_OPERATORS_REAR_PTO_SWITCH_ON_WITH_OPERATOR_NOT_PRESENT = 0xB02U,
	SPN_PARK_INTERLOCK_ERROR = 0xB03U,
	SPN_OPERATOR_NOT_PRESENT_DURING_REVERSER_COMMAND = 0xB04U,
	SPN_REVERSER_LEVER_NEUTRAL_AND_POWER_SIGNALS_CONFLICT = 0xB05U,
	SPN_REVERSER_LEVER_NEITHER_FORWARD_OR_REVERSE = 0xB06U,
	SPN_REVERSER_LEVER_SIMULTANEOUS_FORWARD_AND_REVERSE = 0xB07U,
	SPN_REVERSER_LEVER_MOTION_INTERLOCK_CONFLICT = 0xB08U,
	SPN_REVERSER_LEVER = 0xB09U,
	SPN_REVERSER_LEVER_MULTIPLE_SWITCH_CONFLICTS = 0xB0AU,
	SPN_POWER_UP_WITHOUT_NEUTRAL = 0xB0BU,
	SPN_REVERSER_LEVER_IN_POWER_ZERODIRECTION_TRANSITION_TOO_LONG = 0xB0CU,
	SPN_REVERSER_LEVER_IN_NEUTRALPARK_TRANSITION_TOO_LONG = 0xB0DU,
	SPN_REVERSING_RATIO_RATIONALITY_FAULT = 0xB0EU,
	SPN_NO_CARRIER_SPEED_AT_STARTUP = 0xB0FU,
	SPN_OPERATOR_NOT_IN_OPERATING_STATION = 0xB10U,
	SPN_MOTION_WITH_PARK_BRAKE_ENGAGED = 0xB11U,
	SPN_NO_HYDROSTATIC_UNIT_SPEED_AT_STARTUP = 0xB12U,
	SPN_NEUTRAL_TO_GEAR_COMMAND_CONFLICT = 0xB13U,
	SPN_BATTERY_1_POTENTIAL_2_VOLTAGE_SWITCHED = 0xB14U,
	SPN_IDENTITY_NUMBER = 0xB15U,
	SPN_MANUFACTURER_CODE = 0xB16U,
	SPN_FUNCTION_INSTANCE = 0xB17U,
	SPN_ECU_INSTANCE = 0xB18U,
	SPN_FUNCTION = 0xB19U,
	SPN_VEHICLE_SYSTEM = 0xB1AU,
	SPN_VEHICLE_SYSTEM_INSTANCE = 0xB1BU,
	SPN_ARBITRARY_ADDRESS_CAPABLE = 0xB1CU,
	SPN_NAME_OF_WORKING_SET_MEMBER = 0xB1DU,
	SPN_INDUSTRY_GROUP = 0xB1EU,
	SPN_ADDRESS_ASSIGNMENT = 0xB1FU,
	SPN_NAME_OF_CONTROLLER_APPLICATION = 0xB20U,
	SPN_NAME_OF_COMMANDED_ADDRESS_TARGET = 0xB21U,
	SPN_COMMUNICATIONS_ANTENNA = 0xB22U,
	SPN_COMMUNICATIONS_SERVICE_PERSONAL_IDENTIFICATION_NUMBER = 0xB23U,
	SPN_COMMUNICATIONS_SERVICE_SUBSCRIBER_IDENTIFICATION_MODULE = 0xB24U,
	SPN_COMMUNICATIONS_CONNECTION = 0xB25U,
	SPN_COMMUNICATIONS_CARRIER = 0xB26U,
	SPN_COMMUNICATIONS_BIT_ERROR_RATE = 0xB27U,
	SPN_COMMUNICATIONS_DATA_UPLOAD = 0xB28U,
	SPN_COMMUNICATIONS_DATA_DOWNLOAD = 0xB29U,
	SPN_MACHINE_DATA_CONFIGURATION_1 = 0xB2AU,
	SPN_MACHINE_DATA_CONFIGURATION_2 = 0xB2BU,
	SPN_MACHINE_DATA_CONFIGURATION_3 = 0xB2CU,
	SPN_MACHINE_DATA_CONFIGURATION_4 = 0xB2DU,
	SPN_MACHINE_DATA_CONFIGURATION_5 = 0xB2EU,
	SPN_FRONT_OPERATOR_WIPER_SWITCH = 0xB2FU,
	SPN_FRONT_NONOPERATOR_WIPER_SWITCH = 0xB30U,
	SPN_REAR_WIPER_SWITCH = 0xB31U,
	SPN_FRONT_OPERATOR_WASHER_SWITCH = 0xB32U,
	SPN_FRONT_NONOPERATOR_WASHER_SWITCH = 0xB33U,
	SPN_REAR_WASHER_FUNCTION = 0xB34U,
	SPN_FRONT_OPERATOR_WIPER_DELAY_CONTROL = 0xB35U,
	SPN_FRONT_NONOPERATOR_WIPER_DELAY_CONTROL = 0xB36U,
	SPN_REAR_WIPER_DELAY_CONTROL = 0xB37U,
	SPN_MAIN_LIGHT_SWITCH = 0xB38U,
	SPN_WORK_LIGHT_SWITCH = 0xB39U,
	SPN_HIGHLOW_BEAM_SWITCH = 0xB3AU,
	SPN_HAZARD_LIGHT_SWITCH = 0xB3BU,
	SPN_TURN_SIGNAL_SWITCH = 0xB3CU,
	SPN_OPERATORS_DESIRED_DELAYED_LAMP_OFF_TIME = 0xB3DU,
	SPN_OPERATORS_DESIRED_BACKLIGHT = 0xB3EU,
	SPN_ENGINE_ALTERNATE_DROOP_ACCELERATOR_2_SELECT = 0xB3FU,
	SPN_ENGINE_OPERATOR_PRIMARY_INTERMEDIATE_SPEED_SELECT = 0xB40U,
	SPN_ENGINE_ALTERNATE_DROOP_ACCELERATOR_1_SELECT = 0xB41U,
	SPN_ENGINE_ALTERNATE_RATING_SELECT = 0xB42U,
	SPN_ENGINE_ALTERNATE_LOW_IDLE_SWITCH = 0xB43U,
	SPN_ENGINE_AUXILIARY_GOVERNOR_SWITCH = 0xB44U,
	SPN_ENGINE_ALTERNATE_DROOP_AUXILIARY_INPUT_SELECT = 0xB45U,
	SPN_ENGINE_ALTERNATE_DROOP_REMOTE_ACCELERATOR_SELECT = 0xB46U,
	SPN_TOTAL_COUNT_OF_CONFIGURATION_CHANGES_MADE = 0xB47U,
	SPN_ENGINE_ALTERNATE_RATING_SELECT_STATE = 0xB48U,
	SPN_ENGINE_ALTERNATE_DROOP_ACCELERATOR_1_SELECT_STATE = 0xB49U,
	SPN_ENGINE_MULTIUNIT_SYNC_STATE = 0xB4AU,
	SPN_ENGINE_ALTERNATE_LOW_IDLE_SELECT_STATE = 0xB4BU,
	SPN_ENGINE_OPERATOR_PRIMARY_INTERMEDIATE_SPEED_SELECT_STATE = 0xB4CU,
	SPN_ENGINE_ALTERNATE_DROOP_ACCELERATOR_2_SELECT_STATE = 0xB4DU,
	SPN_ENGINE_ALTERNATE_DROOP_REMOTE_ACCELERATOR_SELECT_STATE = 0xB4EU,
	SPN_ENGINE_ALTERNATE_DROOP_AUXILIARY_INPUT_SELECT_STATE = 0xB4FU,
	SPN_ENGINE_AUXILIARY_GOVERNOR_STATE = 0xB50U,
	SPN_OPERATOR_PTO_MEMORY_SELECT_SWITCH = 0xB51U,
	SPN_ENGINE_START_ENABLE_DEVICE_2_CONFIGURATION = 0xB52U,
	SPN_ENGINE_START_ENABLE_DEVICE_1_CONFIGURATION = 0xB53U,
	SPN_TRANSMISSION_ENGINE_CRANK_ENABLE = 0xB54U,
	SPN_ECU_PART_NUMBER = 0xB55U,
	SPN_ECU_SERIAL_NUMBER = 0xB56U,
	SPN_ECU_LOCATION = 0xB57U,
	SPN_ECU_TYPE = 0xB58U,
	SPN_TRANSMISSION_RANGE_CLUTCH_C7_SOLENOID = 0xB59U,
	SPN_TRANSMISSION_RANGE_CLUTCH_C8_SOLENOID = 0xB5AU,
	SPN_TRANSMISSION_AXLE_DISCONNECT_CLUTCH_VALVE_ACTUATOR = 0xB5BU,
	SPN_TRANSMISSION_BOOST_PRESSURE_VALVE_ACTUATOR = 0xB5CU,
	SPN_TORQUE_CONVERTER_MODULATING_CLUTCH_VALVE_ACTUATOR = 0xB5DU,
	SPN_TRANSMISSION_PTO_CLUTCH_VALVE_ACTUATOR = 0xB5EU,
	SPN_HALT_BRAKE_SWITCH = 0xB5FU,
	SPN_HILL_HOLDER_MODE = 0xB60U,
	SPN_HALT_BRAKE_MODE = 0xB61U,
	SPN_XBR_EBI_MODE = 0xB62U,
	SPN_XBR_PRIORITY = 0xB63U,
	SPN_XBR_CONTROL_MODE = 0xB64U,
	SPN_XBR_SYSTEM_STATE = 0xB65U,
	SPN_XBR_ACTIVE_CONTROL_MODE = 0xB66U,
	SPN_FOUNDATION_BRAKE_USE = 0xB67U,
	SPN_EXTERNAL_ACCELERATION_DEMAND = 0xB68U,
	SPN_XBR_ACCELERATION_LIMIT = 0xB69U,
	SPN_STEERABLE_LIFT_AXLE_LOWERING_INHIBIT = 0xB6AU,
	SPN_STATUS_OF_STEERING_AXLE = 0xB6BU,
	SPN_STEERING_TYPE = 0xB6CU,
	SPN_TYPE_OF_STEERING_FORCES = 0xB6DU,
	SPN_TYPE_OF_STEERING_TRANSMISSION = 0xB6EU,
	SPN_ACTUAL_INNER_WHEEL_STEERING_ANGLE = 0xB6FU,
	SPN_AXLE_LOCATION_2 = 0xB70U,
	SPN_HYDRAULIC_BRAKE_SYSTEM_AUDIBLE_WARNING_COMMAND = 0xB72U,
	SPN_HYDRAULIC_BRAKE_FLUID_LEVEL_SWITCH = 0xB73U,
	SPN_VALVE_STATE = 0xB74U,
	SPN_VALVE_STATE_COMMAND = 0xB75U,
	SPN_VALVE_FAIL_SAFE_MODE = 0xB76U,
	SPN_VALVE_FAIL_SAFE_MODE_COMMAND = 0xB77U,
	SPN_GENERAL_PURPOSE_VALVE_NUMBER = 0xB78U,
	SPN_EXTEND_PORT_MEASURED_FLOW = 0xB79U,
	SPN_RETRACT_PORT_MEASURED_FLOW = 0xB7AU,
	SPN_EXTEND_PORT_ESTIMATED_FLOW = 0xB7BU,
	SPN_RETRACT_PORT_ESTIMATED_FLOW = 0xB7CU,
	SPN_EXTEND_PORT_PRESSURE = 0xB7DU,
	SPN_RETRACT_PORT_PRESSURE = 0xB7EU,
	SPN_RETURN_PORT_PRESSURE = 0xB7FU,
	SPN_PORT_FLOW_COMMAND = 0xB80U,
	SPN_ACTIVE_SHIFT_CONSOLE_INDICATOR = 0xB81U,
	SPN_ENGINE_MIXER_INLET_RELATIVE_HUMIDITY = 0xB82U,
	SPN_ENGINE_FUEL_RACK_POSITION_2 = 0xB83U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATION_SYSTEM_OIL_PRESSURE = 0xB84U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATION_SYSTEM_OIL_PRESSURE_CONTROL_VALVE = 0xB85U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_1 = 0xB86U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_2 = 0xB87U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_3 = 0xB88U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_4 = 0xB89U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_5 = 0xB8AU,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_6 = 0xB8BU,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_7 = 0xB8CU,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_8 = 0xB8DU,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_9 = 0xB8EU,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_10 = 0xB8FU,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_11 = 0xB90U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_12 = 0xB91U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_13 = 0xB92U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_14 = 0xB93U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_15 = 0xB94U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_16 = 0xB95U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_17 = 0xB96U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_18 = 0xB97U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_19 = 0xB98U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATOR_20 = 0xB99U,
	SPN_ACCELERATOR_PEDAL_2_LOW_IDLE_SWITCH = 0xB9AU,
	SPN_ACCELERATOR_PEDAL_3_LOW_IDLE_SWITCH = 0xB9BU,
	SPN_ACCELERATOR_PEDAL_POSITION_1_OUTPUT_2 = 0xB9CU,
	SPN_ACCELERATOR_PEDAL_POSITION_1_OUTPUT_3 = 0xB9DU,
	SPN_ACCELERATOR_PEDAL_POSITION_2_OUTPUT_2 = 0xB9EU,
	SPN_ACCELERATOR_PEDAL_POSITION_2_OUTPUT_3 = 0xB9FU,
	SPN_ACCELERATOR_PEDAL_POSITION_3_OUTPUT_2 = 0xBA0U,
	SPN_ACCELERATOR_PEDAL_POSITION_3_OUTPUT_3 = 0xBA1U,
	SPN_ESTIMATED_ENGINE_PARASITIC_LOSSES_PERCENT_TORQUE = 0xBA2U,
	SPN_VEHICLE_ACCELERATION_RATE_LIMIT_STATUS = 0xBA3U,
	SPN_ENGINE_FUEL_VALVE_1_OUTLET_ABSOLUTE_PRESSURE = 0xBA4U,
	SPN_ENGINE_COOLANT_LOOP_2_PRESSURE = 0xBA5U,
	SPN_ENGINE_COOLANT_LOOP_2_TEMPERATURE = 0xBA6U,
	SPN_CLUTCH_LIFE_REMAINING = 0xBA7U,
	SPN_AUTOMATIC_TRACTION_HELP = 0xBA8U,
	SPN_TRANSMISSION_SHIFT_SELECTOR_DISPLAY_MODE_SWITCH = 0xBA9U,
	SPN_ENGINE_INTAKE_VALVE_ACTUATION_SYSTEM_OIL_TEMPERATURE = 0xBAAU,
	SPN_ENGINE_WILL_NOT_START_PRELUBE_SYSTEM_ISSUE = 0xBABU,
	SPN_ENGINE_COOLANT_DIVERTER_VALVE = 0xBACU,
	SPN_COMBINE_SEPARATOR_SPEED = 0xBADU,
	SPN_RESERVED_BY_SAE = 0xBAEU,
	SPN_TAILINGS_VOLUME = 0xBAFU,
	SPN_MOVE_REEL_FORWARD = 0xBB0U,
	SPN_MOVE_REEL_AFT = 0xBB1U,
	SPN_REEL_RAISE = 0xBB2U,
	SPN_REEL_LOWER = 0xBB3U,
	SPN_HEADER_RAISE_SLOW = 0xBB4U,
	SPN_HEADER_LOWER_SLOW = 0xBB5U,
	SPN_HEADER_RAISE_FAST = 0xBB6U,
	SPN_HEADER_LOWER_FAST = 0xBB7U,
	SPN_TILT_HEADER_LEFT = 0xBB8U,
	SPN_TILT_HEADER_RIGHT = 0xBB9U,
	SPN_HEADER_FOLD = 0xBBAU,
	SPN_HEADER_UNFOLD = 0xBBBU,
	SPN_DRAPER_SPEED_INCREMENT = 0xBBCU,
	SPN_DRAPER_SPEED_DECREMENT = 0xBBDU,
	SPN_REEL_SPEED_INCREMENT = 0xBBEU,
	SPN_REEL_SPEED_DECREMENT = 0xBBFU,
	SPN_THRESHING_CLEARANCE_INCREMENT = 0xBC0U,
	SPN_THRESHING_CLEARANCE_DECREMENT = 0xBC1U,
	SPN_THRESHING_SPEED_INCREMENT = 0xBC2U,
	SPN_THRESHING_SPEED_DECREMENT = 0xBC3U,
	SPN_PRODUCT_FAN_SPEED_INCREMENT = 0xBC4U,
	SPN_PRODUCT_FAN_SPEED_DECREMENT = 0xBC5U,
	SPN_IMPLEMENT_FOLD_DOWN = 0xBC7U,
	SPN_IMPLEMENT_FOLD_UP = 0xBC8U,
	SPN_RH_HEADER_RAISE = 0xBC9U,
	SPN_LH_HEADER_RAISE = 0xBCAU,
	SPN_PRODUCT_FAN_ENGAGE_MODE = 0xBCBU,
	SPN_AUGERS_ENGAGE_MODE = 0xBCCU,
	SPN_PRODUCT_BASKET_FILL_STATE = 0xBCDU,
	SPN_AUGERS_ENABLE_MODE = 0xBCEU,
	SPN_HEADER_HEIGHT_CONTROL_MODE = 0xBCFU,
	SPN_HEADER_REMOTE_TETHER_CONTROL_MODE = 0xBD0U,
	SPN_LUBRICATION_CONTROL_MODE = 0xBD1U,
	SPN_TRANSMISSION_OIL_LEVEL_MEASUREMENT_STATUS = 0xBD2U,
	SPN_TRANSMISSION_OIL_LEVEL_HIGH__LOW = 0xBD3U,
	SPN_TRANSMISSION_OIL_LEVEL_COUNTDOWN_TIMER = 0xBD4U,
	SPN_ENGINE_START_INHIBITED_PRELUBE_SYSTEM_ISSUE = 0xBD5U,
	SPN_TRANSMISSION_TORQUE_CONVERTER_RATIO = 0xBD6U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_TEMPERATURE = 0xBD7U,
	SPN_RIGHT_BRAKE_PEDAL_POSITION = 0xBD8U,
	SPN_LEFT_BRAKE_PEDAL_POSITION = 0xBD9U,
	SPN_DM22_CONTROL_BYTE_INDIVIDUAL_DTC_CLEARRESET_CONTROL_BYTE = 0xBDAU,
	SPN_DM22_NEGATIVE_ACKNOWLEDGE_INDICATOR_FOR_INDIVIDUAL_DTC_CLEAR = 0xBDBU,
	SPN_DM22_DTC_SPN_CLEAR = 0xBDCU,
	SPN_DM22_DTC_FMI_TO_CLEAR = 0xBDDU,
	SPN_FLASH_MALFUNCTION_INDICATOR_LAMP = 0xBDEU,
	SPN_FLASH_RED_STOP_LAMP = 0xBDFU,
	SPN_FLASH_AMBER_WARNING_LAMP = 0xBE0U,
	SPN_FLASH_PROTECT_LAMP = 0xBE1U,
	SPN_REQUESTED_WHEEL_SPEED = 0xBE2U,
	SPN_TYPE_OF_PASSENGER_COUNT = 0xBE3U,
	SPN_SILENT_ALARM_STATUS = 0xBE4U,
	SPN_VEHICLE_USE_STATUS = 0xBE5U,
	SPN_TRANSIT_RUN_STATUS = 0xBE6U,
	SPN_PATRON_COUNT = 0xBE7U,
	SPN_IGNITION_CYCLE_COUNTER = 0xBE8U,
	SPN_OBD_MONITORING_CONDITIONS_ENCOUNTERED_COUNTS = 0xBE9U,
	SPN_CATALYST_1_SYSTEM_MONITOR = 0xBEAU,
	SPN_CATALYST_2_SYSTEM_MONITOR = 0xBEBU,
	SPN_ENGINE_MISFIRE_MONITOR = 0xBECU,
	SPN_ENGINE_EVAPORATIVE_SYSTEM_MONITOR = 0xBEDU,
	SPN_ENGINE_SECONDARY_AIR_SYSTEM_MONITOR = 0xBEEU,
	SPN_ENGINE_FUEL_SYSTEM_MONITOR = 0xBEFU,
	SPN_ENGINE_OXYGEN_SENSOR_1_MONITOR = 0xBF0U,
	SPN_ENGINE_OXYGEN_SENSOR_2_MONITOR = 0xBF1U,
	SPN_ENGINE_EXHAUST_GAS_RECIRCULATION_EGR_SYSTEM_MONITOR = 0xBF2U,
	SPN_ENGINE_POSITIVE_CRANKCASE_VENTILATION_SYSTEM_MONITOR = 0xBF3U,
	SPN_ENGINE_COOLING_SYSTEM_MONITOR = 0xBF4U,
	SPN_ENGINE_COLD_START_EMISSION_REDUCTION_STRATEGY_SYSTEM_MONITOR = 0xBF5U,
	SPN_AIR_CONDITIONING_SYSTEM_COMPONENT_MONITOR = 0xBF6U,
	SPN_DIRECT_OZONE_REDUCTION_MONITOR = 0xBF7U,
	SPN_PARTICULATE_MATTER_TRAP_MONITOR = 0xBF8U,
	SPN_COMPREHENSIVE_COMPONENT_MONITOR = 0xBF9U,
	SPN_SPN_OF_APPLICABLE_SYSTEM_MONITOR = 0xBFAU,
	SPN_APPLICABLE_SYSTEM_MONITOR_NUMERATOR = 0xBFBU,
	SPN_APPLICABLE_SYSTEM_MONITOR_DENOMINATOR = 0xBFCU,
	SPN_DISTANCE_TRAVELED_WHILE_MIL_IS_ACTIVATED = 0xBFDU,
	SPN_NUMBER_OF_BYTES_IN_THE_MILEPOST_IDENTIFICATION = 0xBFEU,
	SPN_NUMBER_OF_BYTES_IN_THE_TRANSIT_ASSIGNED_ROUTE_IDENTITY = 0xBFFU,
	SPN_NUMBER_OF_BYTES_IN_THE_TRANSIT_ASSIGNED_RUN_IDENTITY = 0xC00U,
	SPN_NUMBER_OF_BYTES_IN_THE_TRANSIT_ASSIGNED_BLOCK_IDENTITY = 0xC01U,
	SPN_TRANSIT_ASSIGNED_ROUTE_IDENTITY = 0xC02U,
	SPN_TRANSIT_ASSIGNED_RUN_IDENTITY = 0xC03U,
	SPN_TRANSIT_ASSIGNED_BLOCK_IDENTITY = 0xC04U,
	SPN_AGENCY = 0xC06U,
	SPN_INTERSECTION_PREEMPTION_REQUESTRESPONSE = 0xC07U,
	SPN_TRANSIT_ROUTE_ID_USAGE = 0xC08U,
	SPN_RANGE_CODE_ENABLE = 0xC09U,
	SPN_STROBE_ACTIVATION_CONTROL_STATUS = 0xC0AU,
	SPN_TRANSIT_DOOR_ENABLE = 0xC0BU,
	SPN_PRIORITY_OF_RESPONSE_SENT_BY_EMITTER = 0xC0CU,
	SPN_VEHICLE_ID = 0xC0DU,
	SPN_TRANSMISSION_READY_FOR_BRAKE_RELEASE = 0xC0EU,
	SPN_AUXILIARY_LEVEL = 0xC0FU,
	SPN_HEADER_HEIGHT_VERTICAL_RATE_CONTROL = 0xC10U,
	SPN_HEADER_HEIGHT_SENSITIVITY_CONTROL = 0xC11U,
	SPN_HEADER_HEIGHT_SETPOINT_CHANGE = 0xC12U,
	SPN_HEADER_HEIGHT_SETPOINT_CHANGE_SEQUENCE_NUMBER = 0xC13U,
	SPN_HEADER_PLATFORM_HEIGHT = 0xC14U,
	SPN_HEADER_PLATFORM_HEIGHT_MAXIMUM = 0xC15U,
	SPN_RESERVED_AVAILABLE_TO_ASSIGN_1 = 0xC16U,
	SPN_RESERVED_AVAILABLE_TO_ASSIGN_2 = 0xC17U,
	SPN_HEADER_FLOAT_PRESSURE = 0xC18U,
	SPN_HEADER_FLOAT_PRESSURE_MAXIMUM = 0xC19U,
	SPN_HEADER_POSITION_PERCENT = 0xC1AU,
	SPN_HEADER_POSITION_PERCENT_MAXIMUM = 0xC1BU,
	SPN_RESERVED_AVAILABLE_TO_ASSIGN_3 = 0xC1CU,
	SPN_RESERVED_AVAILABLE_TO_ASSIGN_4 = 0xC1DU,
	SPN_UNLOADING_AUGER_SWING_OUT = 0xC1EU,
	SPN_UNLOADING_AUGER_SWING_IN = 0xC1FU,
	SPN_UNLOADING_AUGER_SWING_OUTAUTO_ = 0xC20U,
	SPN_UNLOADING_AUGER_SWING_INAUTO = 0xC21U,
	SPN_SIDE_HILL_LEFT_TILT = 0xC22U,
	SPN_SIDE_HILL_RIGHT_TILT = 0xC23U,
	SPN_SPREADER_SPEED_INCREMENT = 0xC24U,
	SPN_SPREADER_SPEED_DECREMENT = 0xC25U,
	SPN_PRECLEANER_OPEN = 0xC26U,
	SPN_PRECLEANER_CLOSE = 0xC27U,
	SPN_OPEN_CHAFFER = 0xC28U,
	SPN_CLOSE_CHAFFER = 0xC29U,
	SPN_OPEN_SIEVE = 0xC2AU,
	SPN_CLOSE_SIEVE = 0xC2BU,
	SPN_MOVE_CHOPPER_VANE_LEFT = 0xC2CU,
	SPN_MOVE_CHOPPER_VANE_RIGHT = 0xC2DU,
	SPN_QUICK_STOP_SWITCH = 0xC2EU,
	SPN_UNLOADING_AUGER_ENGAGEDISENGAGE = 0xC2FU,
	SPN_UNLOADING_AUGER_FOLD = 0xC30U,
	SPN_UNLOADING_AUGER_UNFOLD = 0xC31U,
	SPN_MAX_ALLOWABLE_CLEANING_SHOE_TRAVEL = 0xC32U,
	SPN_RIGHT_HAND_HEADER_HEIGHT_SETPOINT = 0xC33U,
	SPN_LEFT_HAND_HEADER_HEIGHT_SETPOINT = 0xC34U,
	SPN_LEFT_HAND_HEADER_HEIGHT = 0xC35U,
	SPN_RIGHT_HAND_HEADER_HEIGHT = 0xC36U,
	SPN_HEADER_CONTROL_RESPONSE_RATE_SETPOINT = 0xC37U,
	SPN_HEADER_CONTROL_RESPONSE_RATE_MAXIMUM_SETPOINT = 0xC38U,
	SPN_HEADER_CONTROL_RESPONSE_RATE_MINIMUM_SETPOINT = 0xC39U,
	SPN_PRODUCT_SYSTEM_TANK_WATER_LEVEL = 0xC3AU,
	SPN_PRODUCT_FAN_SPEED = 0xC3BU,
	SPN_PRODUCT_SYSTEM_MANIFOLD_PRESSURE = 0xC3CU,
	SPN_PRODUCT_SYSTEM_PUMP_DISCHARGE_PRESSURE = 0xC3DU,
	SPN_PRODUCT_FAN_HOURS = 0xC3EU,
	SPN_RIGHT_HAND_HEADER_HEIGHT_MAX_SETPOINT = 0xC3FU,
	SPN_RIGHT_HAND_HEADER_HEIGHT_MIN_SETPOINT = 0xC40U,
	SPN_LEFT_HAND_HEADER_HEIGHT_MIN_SETPOINT = 0xC41U,
	SPN_LEFT_HAND_HEADER_HEIGHT_MAX_SETPOINT = 0xC42U,
	SPN_RIGHT_HAND_HEADER_UNIT_SPEED = 0xC43U,
	SPN_LEFT_HAND_HEADER_UNIT_SPEED = 0xC44U,
	SPN_GPS_DIFFERENTIAL_CORRECTIONS_LICENSE = 0xC45U,
	SPN_METHOD_GNSS = 0xC46U,
	SPN_DIFFERENTIAL_SOURCE = 0xC47U,
	SPN_DIFFERENTIAL_SOURCE_SECONDARY = 0xC48U,
	SPN_DGNSS_FIX = 0xC49U,
	SPN_PGN_OF_MESSAGE_BEING_CONFIGURED = 0xC4AU,
	SPN_PARAMETER_BEING_INCLUDED = 0xC4BU,
	SPN_POSITION_OF_CONFIGURED_PARAMETER = 0xC4CU,
	SPN_MESSAGE_WILL_BE_USED_PROPRIETARILY = 0xC4DU,
	SPN_MESSAGE_WILL_USE_TRANSPORT_PROTOCOL = 0xC4EU,
	SPN_FIRST_PARAMETER_ONLY_BEING_IDENTIFIED = 0xC4FU,
	SPN_NUMBER_OF_PARAMETERS_INCLUDED = 0xC50U,
	SPN_STARTING_BIT_FOR_THIS_PARAMETER = 0xC51U,
	SPN_PARAMETER_TO_BE_LOCATED = 0xC52U,
	SPN_PARAMETER_LOCATE_COMMAND = 0xC53U,
	SPN_BLADE_CONTROL_MODE_SWITCH = 0xC54U,
	SPN_DESIRED_GRADE_OFFSET_SWITCH = 0xC55U,
	SPN_BLADE_AUTO_MODE_COMMAND = 0xC56U,
	SPN_TRIP_NUMBER = 0xC57U,
	SPN_ASSIGNED_ROUTE = 0xC58U,
	SPN_PATTERN_NUMBER = 0xC59U,
	SPN_ASSIGNED_RUN = 0xC5AU,
	SPN_ASSIGNED_BLOCK = 0xC5BU,
	SPN_DRIVERS_FAREBOX_SECURITY_CODE = 0xC5CU,
	SPN_FARE_VALIDITY = 0xC5DU,
	SPN_PASS_CATEGORY = 0xC5EU,
	SPN_INITIAL_FARE_AGENCY = 0xC5FU,
	SPN_TRANSFER_SOLD = 0xC60U,
	SPN_ROUTE_NUMBER = 0xC61U,
	SPN_TRANSACTION_TYPE = 0xC62U,
	SPN_PASSENGER_TYPE = 0xC63U,
	SPN_TYPE_OF_SERVICE = 0xC64U,
	SPN_TRANSFER_TYPE = 0xC65U,
	SPN_TRIP_DIRECTION = 0xC66U,
	SPN_FARE_PRESETS = 0xC67U,
	SPN_TYPE_OF_FARE = 0xC68U,
	SPN_PAYMENT_DETAILS = 0xC69U,
	SPN_FAREBOX_SERVICE_STATUS = 0xC6AU,
	SPN_FAREBOX_EMERGENCY_STATUS = 0xC6BU,
	SPN_TRIP_STATUS = 0xC6CU,
	SPN_FAREBOX_ALARM_IDENTIFIER = 0xC6DU,
	SPN_TRANSMISSION_RETARDER_ENABLE_SOLENOID_VALVE = 0xC6EU,
	SPN_TRANSMISSION_RETARDER_MODULATION_SOLENOID_VALVE = 0xC6FU,
	SPN_TRANSMISSION_LOCKUP_CLUTCH_PRESSURE_INDICATOR_2 = 0xC70U,
	SPN_TRANSMISSION_DIFFERENTIAL_LOCK_SOLENOID_VALVE = 0xC71U,
	SPN_TRANSMISSION_DIFFERENTIAL_LOCK_CLUTCH_PRESSURE_INDICATOR = 0xC72U,
	SPN_TRANSMISSION_SHIFT_CONSOLE_DATA_LINK = 0xC73U,
	SPN_XBR_MESSAGE_CHECKSUM = 0xC74U,
	SPN_XBR_MESSAGE_COUNTER = 0xC75U,
	SPN_TIRE_LOCATION_2 = 0xC76U,
	SPN_REFERENCE_TIRE_PRESSURE = 0xC77U,
	SPN_TIRE_LOCATION_3 = 0xC78U,
	SPN_REFERENCE_TIRE_PRESSURE_SETTING = 0xC79U,
	SPN_CONTROL_BYTE_3 = 0xC7AU,
	SPN_NUMBER_OF_PORTS = 0xC7BU,
	SPN_UPTIME_SINCE_LAST_POWERON_RESET = 0xC7CU,
	SPN_AVERAGE_MESSAGES_FILTERED_PER_SECOND = 0xC7DU,
	SPN_AVERAGE_MESSAGES_FORWARDED_PER_SECOND = 0xC7EU,
	SPN_AVERAGE_MESSAGES_RECEIVED_PER_SECOND = 0xC7FU,
	SPN_NUMBER_OF_MESSAGES_WITH_EXCESSIVE_TRANSIT_DELAY_TIME = 0xC80U,
	SPN_NUMBER_OF_MESSAGES_LOST_DUE_TO_BUFFER_OVERFLOW = 0xC81U,
	SPN_AVERAGE_TRANSIT_DELAY_TIME = 0xC82U,
	SPN_MAXIMUM_TRANSIT_DELAY_TIME = 0xC83U,
	SPN_MAXIMUM_MESSAGES_FILTERED_PER_SECOND = 0xC84U,
	SPN_MAXIMUM_MESSAGES_FORWARDED_PER_SECOND = 0xC85U,
	SPN_MAXIMUM_MESSAGES_RECEIVED_PER_SECOND = 0xC86U,
	SPN_NUMBER_OF_FILTER_DATABASE_ENTRIES = 0xC87U,
	SPN_MAXIMUM_FILTER_DATABASE_SIZE = 0xC88U,
	SPN_BUFFER_SIZE = 0xC89U,
	SPN_PARAMETER_NUMBER_ = 0xC8AU,
	SPN_SA_LIST = 0xC8BU,
	SPN_PGN_LIST = 0xC8CU,
	SPN_FILTER_MODE = 0xC8DU,
	SPN_PORT_PAIR = 0xC8EU,
	SPN_PROHIBIT_AIR_SUSPENSION_CONTROL = 0xC8FU,
	SPN_AFTERTREATMENT_1_INTAKE_NOX = 0xC90U,
	SPN_AFTERTREATMENT_1_INTAKE_O2 = 0xC91U,
	SPN_AFTERTREATMENT_1_INTAKE_GAS_SENSOR_POWER_IN_RANGE = 0xC92U,
	SPN_AFTERTREATMENT_1_INTAKE_GAS_SENSOR_AT_TEMPERATURE = 0xC93U,
	SPN_AFTERTREATMENT_1_INTAKE_NOX_READING_STABLE = 0xC94U,
	SPN_AFTERTREATMENT_1_INTAKE_WIDERANGE_O2_READING_STABLE = 0xC95U,
	SPN_AFTERTREATMENT_1_INTAKE_GAS_SENSOR_HEATER = 0xC96U,
	SPN_AFTERTREATMENT_1_INTAKE_GAS_SENSOR_HEATER_CONTROL = 0xC97U,
	SPN_AFTERTREATMENT_1_INTAKE_NOX_SENSOR = 0xC98U,
	SPN_AFTERTREATMENT_1_INTAKE_OXYGEN_SENSOR = 0xC99U,
	SPN_AFTERTREATMENT_1_OUTLET_NOX = 0xC9AU,
	SPN_AFTERTREATMENT_1_OUTLET_O2 = 0xC9BU,
	SPN_AFTERTREATMENT_1_OUTLET_GAS_SENSOR_POWER_IN_RANGE = 0xC9CU,
	SPN_AFTERTREATMENT_1_OUTLET_GAS_SENSOR_AT_TEMPERATURE = 0xC9DU,
	SPN_AFTERTREATMENT_1_OUTLET_NOX_READING_STABLE = 0xC9EU,
	SPN_AFTERTREATMENT_1_OUTLET_WIDERANGE_O2_READING_STABLE = 0xC9FU,
	SPN_AFTERTREATMENT_1_OUTLET_GAS_SENSOR_HEATER = 0xCA0U,
	SPN_AFTERTREATMENT_1_OUTLET_GAS_SENSOR_HEATER_CONTROL = 0xCA1U,
	SPN_AFTERTREATMENT_1_OUTLET_NOX_SENSOR = 0xCA2U,
	SPN_AFTERTREATMENT_1_OUTLET_OXYGEN_SENSOR = 0xCA3U,
	SPN_EXHAUST_GAS_MASS = 0xCA4U,
	SPN_AFTERTREATMENT_INTAKE_DEW_POINT_MESSAGE_1 = 0xCA5U,
	SPN_AFTERTREATMENT_EXHAUST_DEW_POINT_MESSAGE_1 = 0xCA6U,
	SPN_AFTERTREATMENT_INTAKE_DEW_POINT_MESSAGE_2 = 0xCA7U,
	SPN_AFTERTREATMENT_EXHAUST_DEW_POINT_MESSAGE_2 = 0xCA8U,
	SPN_EXHAUST_GAS_TEMPERATURE_1 = 0xCA9U,
	SPN_AFTERTREATMENT_1_DPF_INTAKE_GAS_TEMPERATURE = 0xCAAU,
	SPN_EXHAUST_GAS_TEMPERATURE_2 = 0xCADU,
	SPN_AFTERTREATMENT_1_DPF_OUTLET_GAS_TEMPERATURE = 0xCAEU,
	SPN_EXHAUST_GAS_TEMPERATURE_3 = 0xCB1U,
	SPN_PARTICULATE_TRAP_INTERMEDIATE_GAS_TEMPERATURE_1 = 0xCB2U,
	SPN_AFTERTREATMENT_1_DPF_TRAP_DIFFERENTIAL_PRESSURE = 0xCB3U,
	SPN_AFTERTREATMENT_2_INTAKE_NOX = 0xCB7U,
	SPN_AFTERTREATMENT_2_INTAKE_O2 = 0xCB8U,
	SPN_AFTERTREATMENT_2_INTAKE_GAS_SENSOR_POWER_IN_RANGE = 0xCB9U,
	SPN_AFTERTREATMENT_2_INTAKE_GAS_SENSOR_AT_TEMPERATURE = 0xCBAU,
	SPN_AFTERTREATMENT_2_INTAKE_NOX_READING_STABLE = 0xCBBU,
	SPN_AFTERTREATMENT_2_INTAKE_WIDERANGE_O2_READING_STABLE = 0xCBCU,
	SPN_AFTERTREATMENT_2_INTAKE_GAS_SENSOR_HEATER_CONTROL = 0xCBEU,
	SPN_AFTERTREATMENT_2_OUTLET_NOX = 0xCC1U,
	SPN_AFTERTREATMENT_2_OUTLET_O2 = 0xCC2U,
	SPN_AFTERTREATMENT_2_OUTLET_GAS_SENSOR_POWER_IN_RANGE = 0xCC3U,
	SPN_AFTERTREATMENT_2_OUTLET_GAS_SENSOR_AT_TEMPERATURE = 0xCC4U,
	SPN_AFTERTREATMENT_2_OUTLET_NOX_READING_STABLE = 0xCC5U,
	SPN_AFTERTREATMENT_2_OUTLET_WIDERANGE_O2_READING_STABLE = 0xCC6U,
	SPN_AFTERTREATMENT_2_OUTLET_GAS_SENSOR_HEATER_CONTROL = 0xCC8U,
	SPN_AFTERTREATMENT_2_EXHAUST_GAS_TEMPERATURE_1 = 0xCCBU,
	SPN_PARTICULATE_TRAP_INTAKE_GAS_TEMPERATURE_BANK_2 = 0xCCCU,
	SPN_EXHAUST_GAS_TEMPERATURE_4 = 0xCCFU,
	SPN_PARTICULATE_TRAP_OUTLET_GAS_TEMPERATURE_BANK_2 = 0xCD0U,
	SPN_EXHAUST_GAS_TEMPERATURE_5 = 0xCD3U,
	SPN_PARTICULATE_TRAP_INTERMEDIATE_GAS_TEMPERATURE_2 = 0xCD4U,
	SPN_PARTICULATE_TRAP_DIFFERENTIAL_PRESSURE_BANK_2 = 0xCD5U,
	SPN_TRANSMISSION_REQUESTED_GEAR_FEEDBACK = 0xCD9U,
	SPN_ADDRESS_ACKNOWLEDGED = 0xCDAU,
	SPN_ADDRESS_NEGATIVE_ACKNOWLEDGEMENT = 0xCDBU,
	SPN_ADDRESS_ACCESS_DENIED = 0xCDCU,
	SPN_ADDRESS_BUSY = 0xCDDU,
	SPN_DISTANCE_SINCE_DIAGNOSTIC_TROUBLE_CODES_CLEARED = 0xCDEU,
	SPN_MINUTES_RUN_BY_ENGINE_WHILE_MIL_ACTIVATED = 0xCDFU,
	SPN_TIME_SINCE_DIAGNOSTIC_TROUBLE_CODES_CLEARED = 0xCE0U,
	SPN_SPN_SUPPORTED = 0xCE1U,
	SPN_SPN_SUPPORT_TYPE = 0xCE2U,
	SPN_SPN_DATA_LENGTH = 0xCE3U,
	SPN_EXPANDED_FREEZE_FRAME_LENGTH = 0xCE4U,
	SPN_TIME_SINCE_ENGINE_START = 0xCE5U,
	SPN_NUMBER_OF_WARMUPS_SINCE_DTCS_CLEARED = 0xCE6U,
	SPN_CONTINUOUSLY_MONITORED_SYSTEMS_ENABLEDCOMPLETED_STATUS = 0xCE7U,
	SPN_NONCONTINUOUSLY_MONITORED_SYSTEMS_ENABLED_STATUS = 0xCE8U,
	SPN_NONCONTINUOUSLY_MONITORED_SYSTEMS_COMPLETE_STATUS = 0xCE9U,
	SPN_VARIABLE_VALVE_TIMING_ANDOR_CONTROL = 0xCEAU,
	SPN_FIFTH_WHEEL_ERROR_STATUS = 0xCEBU,
	SPN_FIFTH_WHEEL_VERTICAL_FORCE = 0xCECU,
	SPN_FIFTH_WHEEL_DRAWBAR_FORCE = 0xCEDU,
	SPN_FIFTH_WHEEL_ROLL_MOMENT = 0xCEEU,
	SPN_FIFTH_WHEEL_SLIDER_POSITION = 0xCEFU,
	SPN_FIFTH_WHEEL_LOCK_READY_TO_COUPLE_INDICATOR = 0xCF0U,
	SPN_FIFTH_WHEEL_LOCK_COUPLE_STATUS_INDICATOR = 0xCF1U,
	SPN_FIFTH_WHEEL_RELEASE_CONTROL = 0xCF2U,
	SPN_FIFTH_WHEEL_RELEASE_CONTROL_SECURITY_LOCKOUT = 0xCF3U,
	SPN_FIFTH_WHEEL_SLIDER_LOCK_INDICATOR = 0xCF4U,
	SPN_FIFTH_WHEEL_ROLL_WARNING_INDICATOR = 0xCF5U,
	SPN_PITCH_ANGLE = 0xCF6U,
	SPN_ROLL_ANGLE = 0xCF7U,
	SPN_PITCH_RATE = 0xCFAU,
	SPN_PITCH_ANGLE_FIGURE_OF_MERIT = 0xCFBU,
	SPN_ROLL_ANGLE_FIGURE_OF_MERIT = 0xCFCU,
	SPN_PITCH_RATE_FIGURE_OF_MERIT = 0xCFDU,
	SPN_PITCH_AND_ROLL_COMPENSATED = 0xCFEU,
	SPN_ROLL_AND_PITCH_MEASUREMENT_LATENCY = 0xCFFU,
	SPN_MANUFACTURER_SPECIFIC_INFORMATION_2 = 0xD00U,
	SPN_MESSAGE_SELECTION_CONTROL = 0xD01U,
	SPN_PGN_OF_CONFIGURABLE_MESSAGE_DESIRED = 0xD02U,
	SPN_BLADE_ROTATION_ANGLE = 0xD03U,
	SPN_BLADE_ROTATION_ANGLE_FIGURE_OF_MERIT = 0xD04U,
	SPN_FEEDERHOUSE_HEIGHT = 0xD05U,
	SPN_LEFT_BLADE_CONTROL_MODE_OPERATOR_CONTROL = 0xD06U,
	SPN_RIGHT_BLADE_CONTROL_MODE_OPERATOR_CONTROL = 0xD07U,
	SPN_LEFT_DESIRED_BLADE_OFFSET_OPERATOR_CONTROL = 0xD08U,
	SPN_RIGHT_DESIRED_BLADE_OFFSET_OPERATOR_CONTROL = 0xD09U,
	SPN_SIDESHIFT_BLADE_CONTROL_MODE_OPERATOR_CONTROL = 0xD0AU,
	SPN_SIDESHIFT_DESIRED_BLADE_OFFSET_OPERATOR_CONTROL = 0xD0BU,
	SPN_ENGINE_CHARGE_AIR_COOLER_1_INLET_PRESSURE = 0xD0CU,
	SPN_ENGINE_CHARGE_AIR_COOLER_2_INLET_PRESSURE = 0xD0DU,
	SPN_ENGINE_COOLANT_PUMP_DIFFERENTIAL_PRESSURE = 0xD0EU,
	SPN_ENGINE_CENTRIFUGAL_OIL_FILTER_SPEED = 0xD0FU,
	SPN_SUPPORT_VARIABLE_RATE_TSC1_MESSAGE = 0xD10U,
	SPN_SUPPORT_TSC1_CONTROL_PURPOSE_GROUP_1_OF_4 = 0xD11U,
	SPN_SUPPORT_TSC1_CONTROL_PURPOSE_GROUP_2_OF_4 = 0xD12U,
	SPN_SUPPORT_TSC1_CONTROL_PURPOSE_GROUP_3_OF_4 = 0xD13U,
	SPN_SUPPORT_TSC1_CONTROL_PURPOSE_GROUP_4_OF_4 = 0xD14U,
	SPN_TSC1_TRANSMISSION_RATE = 0xD15U,
	SPN_TSC1_CONTROL_PURPOSE = 0xD16U,
	SPN_ENGINE_EXHAUST_PRESSURE_REGULATOR_VENT_VALVE_CONTROL = 0xD17U,
	SPN_ENGINE_EXHAUST_PRESSURE_REGULATOR_VENT_VALVE_POSITION = 0xD18U,
	SPN_ALTERNATOR_1_STATUS = 0xD19U,
	SPN_ALTERNATOR_2_STATUS = 0xD1AU,
	SPN_ALTERNATOR_3_STATUS = 0xD1BU,
	SPN_ALTERNATOR_4_STATUS = 0xD1CU,
	SPN_ACTUAL_MAXIMUM_AVAILABLE_ENGINE_PERCENT_TORQUE = 0xD1DU,
	SPN_ENGINE_EXHAUST_GAS_RECIRCULATION_INLET_PRESSURE = 0xD1EU,
	SPN_TRANSMISSION_OIL_FILTER_RESTRICTION_SWITCH = 0xD1FU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_CONTROLLER = 0xD20U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_UNIT = 0xD21U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_UNIT_INPUT_LINES = 0xD22U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_HEATER = 0xD23U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_QUALITY = 0xD24U,
	SPN_RELATIVE_BLADE_HEIGHT = 0xD25U,
	SPN_RELATIVE_BLADE_HEIGHT_AND_BLADE_ROTATION_ANGLE_MEASUREMENT_LATENCY = 0xD26U,
	SPN_RELATIVE_BLADE_HEIGHT_FIGURE_OF_MERIT = 0xD27U,
	SPN_NETWORK_TRANSCEIVER_STATUS_1 = 0xD28U,
	SPN_NETWORK_SERVICE_STATUS_1 = 0xD29U,
	SPN_NETWORK_ANTENNA_STATUS_1 = 0xD2AU,
	SPN_NETWORK_SIGNAL_STRENGTH_1 = 0xD2BU,
	SPN_WIRELESS_COMMUNICATION_NETWORK_TYPE_1 = 0xD2CU,
	SPN_GENERATOR_EXCITATION_RIPPLE_CURRENT = 0xD2EU,
	SPN_VOLTAGE_REGULATOR_LOAD_COMPENSATION_MODE = 0xD2FU,
	SPN_VOLTAGE_REGULATOR_VARPOWER_FACTOR_OPERATING_MODE = 0xD30U,
	SPN_VOLTAGE_REGULATOR_UNDERFREQUENCY_COMPENSATION_ENABLED = 0xD31U,
	SPN_VOLTAGE_REGULATOR_SOFT_START_STATE = 0xD32U,
	SPN_VOLTAGE_REGULATOR_ENABLED = 0xD33U,
	SPN_GENERATOR_EXCITATION_FIELD_VOLTAGE = 0xD34U,
	SPN_GENERATOR_EXCITATION_FIELD_CURRENT = 0xD35U,
	SPN_GENERATOR_OUTPUT_VOLTAGE_BIAS_PERCENTAGE = 0xD36U,
	SPN_REQUESTED_GENERATOR_TOTAL_AC_REACTIVE_POWER = 0xD37U,
	SPN_REQUESTED_GENERATOR_OVERALL_POWER_FACTOR = 0xD38U,
	SPN_REQUESTED_GENERATOR_OVERALL_POWER_FACTOR_LAGGING = 0xD39U,
	SPN_REQUESTED_GENERATOR_AVERAGE_LINELINE_AC_RMS_VOLTAGE = 0xD3AU,
	SPN_ENGINE_CYLINDER_1_COMBUSTION_STATUS = 0xD3BU,
	SPN_ENGINE_CYLINDER_2_COMBUSTION_STATUS = 0xD3CU,
	SPN_ENGINE_CYLINDER_3_COMBUSTION_STATUS = 0xD3DU,
	SPN_ENGINE_CYLINDER_4_COMBUSTION_STATUS = 0xD3EU,
	SPN_ENGINE_CYLINDER_5_COMBUSTION_STATUS = 0xD3FU,
	SPN_ENGINE_CYLINDER_6_COMBUSTION_STATUS = 0xD40U,
	SPN_ENGINE_CYLINDER_7_COMBUSTION_STATUS = 0xD41U,
	SPN_ENGINE_CYLINDER_8_COMBUSTION_STATUS = 0xD42U,
	SPN_ENGINE_CYLINDER_9_COMBUSTION_STATUS = 0xD43U,
	SPN_ENGINE_CYLINDER_10_COMBUSTION_STATUS = 0xD44U,
	SPN_ENGINE_CYLINDER_11_COMBUSTION_STATUS = 0xD45U,
	SPN_ENGINE_CYLINDER_12_COMBUSTION_STATUS = 0xD46U,
	SPN_ENGINE_CYLINDER_13_COMBUSTION_STATUS = 0xD47U,
	SPN_ENGINE_CYLINDER_14_COMBUSTION_STATUS = 0xD48U,
	SPN_ENGINE_CYLINDER_15_COMBUSTION_STATUS = 0xD49U,
	SPN_ENGINE_CYLINDER_16_COMBUSTION_STATUS = 0xD4AU,
	SPN_ENGINE_CYLINDER_1_7_COMBUSTION_STATUS = 0xD4BU,
	SPN_ENGINE_CYLINDER_18_COMBUSTION_STATUS = 0xD4CU,
	SPN_ENGINE_CYLINDER_19_COMBUSTION_STATUS = 0xD4DU,
	SPN_ENGINE_CYLINDER_20_COMBUSTION_STATUS = 0xD4EU,
	SPN_ENGINE_CYLINDER_21_COMBUSTION_STATUS = 0xD4FU,
	SPN_ENGINE_CYLINDER_22_COMBUSTION_STATUS = 0xD50U,
	SPN_ENGINE_CYLINDER_23_COMBUSTION_STATUS = 0xD51U,
	SPN_ENGINE_CYLINDER_24_COMBUSTION_STATUS = 0xD52U,
	SPN_STATUS_2_OF_DOORS = 0xD53U,
	SPN_LOCK_STATUS_OF_DOOR_1 = 0xD54U,
	SPN_OPEN_STATUS_OF_DOOR_1 = 0xD55U,
	SPN_ENABLE_STATUS_OF_DOOR_1 = 0xD56U,
	SPN_LOCK_STATUS_OF_DOOR_2 = 0xD57U,
	SPN_OPEN_STATUS_OF_DOOR_2 = 0xD58U,
	SPN_ENABLE_STATUS_OF_DOOR_2 = 0xD59U,
	SPN_LOCK_STATUS_OF_DOOR_3 = 0xD5AU,
	SPN_OPEN_STATUS_OF_DOOR_3 = 0xD5BU,
	SPN_ENABLE_STATUS_OF_DOOR_3 = 0xD5CU,
	SPN_LOCK_STATUS_OF_DOOR_4 = 0xD5DU,
	SPN_OPEN_STATUS_OF_DOOR_4 = 0xD5EU,
	SPN_ENABLE_STATUS_OF_DOOR_4 = 0xD5FU,
	SPN_LOCK_STATUS_OF_DOOR_5 = 0xD60U,
	SPN_OPEN_STATUS_OF_DOOR_5 = 0xD61U,
	SPN_ENABLE_STATUS_OF_DOOR_5 = 0xD62U,
	SPN_LOCK_STATUS_OF_DOOR_6 = 0xD63U,
	SPN_OPEN_STATUS_OF_DOOR_6 = 0xD64U,
	SPN_ENABLE_STATUS_OF_DOOR_6 = 0xD65U,
	SPN_LOCK_STATUS_OF_DOOR_7 = 0xD66U,
	SPN_OPEN_STATUS_OF_DOOR_7 = 0xD67U,
	SPN_ENABLE_STATUS_OF_DOOR_7 = 0xD68U,
	SPN_LOCK_STATUS_OF_DOOR_8 = 0xD69U,
	SPN_OPEN_STATUS_OF_DOOR_8 = 0xD6AU,
	SPN_ENABLE_STATUS_OF_DOOR_8 = 0xD6BU,
	SPN_LOCK_STATUS_OF_DOOR_9 = 0xD6CU,
	SPN_OPEN_STATUS_OF_DOOR_9 = 0xD6DU,
	SPN_ENABLE_STATUS_OF_DOOR_9 = 0xD6EU,
	SPN_LOCK_STATUS_OF_DOOR_10 = 0xD6FU,
	SPN_OPEN_STATUS_OF_DOOR_10 = 0xD70U,
	SPN_ENABLE_STATUS_OF_DOOR_10 = 0xD71U,
	SPN_NETWORK_TRANSCEIVER_STATUS_2 = 0xD72U,
	SPN_NETWORK_SERVICE_STATUS_2 = 0xD73U,
	SPN_NETWORK_ANTENNA_STATUS_2 = 0xD74U,
	SPN_NETWORK_SIGNAL_STRENGTH_2 = 0xD75U,
	SPN_WIRELESS_COMMUNICATION_NETWORK_TYPE_2 = 0xD76U,
	SPN_REMOTE_PTO_PREPROGRAMMED_SPEED_CONTROL_SWITCH_2 = 0xD77U,
	SPN_AUXILIARY_INPUT_IGNORE_SWITCH = 0xD78U,
	SPN_ENGINE_MULTIPLE_CYLINDER_SPARK_VOLTAGE = 0xD7BU,
	SPN_ENABLE_SWITCH_TRANSMISSION_INPUT_SHAFT_PTO_1 = 0xD7CU,
	SPN_ENABLE_SWITCH_TRANSMISSION_INPUT_SHAFT_PTO_2 = 0xD7DU,
	SPN_ENABLE_SWITCH_TRANSMISSION_OUTPUT_SHAFT_PTO = 0xD7EU,
	SPN_ENABLE_SWITCH_TRANSFER_CASE_OUTPUT_SHAFT_PTO = 0xD7FU,
	SPN_ENGAGEMENT_CONSENT_TRANSMISSION_INPUT_SHAFT_PTO_1 = 0xD80U,
	SPN_ENGAGEMENT_CONSENT_TRANSMISSION_INPUT_SHAFT_PTO_2 = 0xD81U,
	SPN_ENGAGEMENT_CONSENT_TRANSMISSION_OUTPUT_SHAFT_PTO = 0xD82U,
	SPN_ENGAGEMENT_CONSENT_TRANSFER_CASE_OUTPUT_SHAFT_PTO = 0xD83U,
	SPN_ENGAGEMENT_STATUS_TRANSMISSION_INPUT_SHAFT_PTO_1 = 0xD84U,
	SPN_ENGAGEMENT_STATUS_TRANSMISSION_INPUT_SHAFT_PTO_2 = 0xD85U,
	SPN_ENGAGEMENT_STATUS_TRANSMISSION_OUTPUT_SHAFT_PTO = 0xD86U,
	SPN_ENGAGEMENT_STATUS_TRANSFER_CASE_OUTPUT_SHAFT_PTO = 0xD87U,
	SPN_ENGINE_THROTTLE_ACTUATOR_1_CONTROL_COMMAND = 0xD88U,
	SPN_ENGINE_THROTTLE_ACTUATOR_2_CONTROL_COMMAND = 0xD89U,
	SPN_ENGINE_FUEL_VALVE_2_INLET_ABSOLUTE_PRESSURE = 0xD8AU,
	SPN_ENGINE_GAS_MASS_FLOW_RATE_2 = 0xD8BU,
	SPN_ENGINE_FUEL_TEMPERATURE_2 = 0xD8CU,
	SPN_ENGINE_FUEL_VALVE_2_OUTLET_ABSOLUTE_PRESSURE = 0xD8DU,
	SPN_ENGINE_TURBOCHARGER_COMPRESSOR_CONTROL = 0xD8EU,
	SPN_AFTERTREATMENT_1_FUEL_PRESSURE_CONTROL_ACTUATOR = 0xD8FU,
	SPN_AFTERTREATMENT_1_AIR_PRESSURE_CONTROL_ACTUATOR = 0xD90U,
	SPN_AFTERTREATMENT_1_FAILED_TO_IGNITE = 0xD91U,
	SPN_AFTERTREATMENT_1_LOSS_OF_COMBUSTION = 0xD92U,
	SPN_AFTERTREATMENT_2_FUEL_PRESSURE_CONTROL_ACTUATOR = 0xD93U,
	SPN_AFTERTREATMENT_2_AIR_PRESSURE_CONTROL_ACTUATOR = 0xD94U,
	SPN_AFTERTREATMENT_2_FAILED_TO_IGNITE = 0xD95U,
	SPN_AFTERTREATMENT_2_LOSS_OF_IGNITION = 0xD96U,
	SPN_AFTERTREATMENT_1_FUEL_PRESSURE_CONTROL = 0xD97U,
	SPN_AFTERTREATMENT_1_FUEL_PRESSURE_1 = 0xD98U,
	SPN_AFTERTREATMENT_1_FUEL_RATE = 0xD99U,
	SPN_AFTERTREATMENT_1_FUEL_ENABLE_ACTUATOR = 0xD9AU,
	SPN_AFTERTREATMENT_1_REGENERATION_STATUS = 0xD9BU,
	SPN_AFTERTREATMENT_1_IGNITION = 0xD9CU,
	SPN_AFTERTREATMENT_1_SUPPLY_AIR_PRESSURE = 0xD9DU,
	SPN_AFTERTREATMENT_1_PURGE_AIR_PRESSURE = 0xD9EU,
	SPN_AFTERTREATMENT_1_AIR_PRESSURE_CONTROL = 0xD9FU,
	SPN_AFTERTREATMENT_1_AIR_PRESSURE_ACTUATOR_POSITION = 0xDA0U,
	SPN_AFTERTREATMENT_1_AIR_ENABLE_ACTUATOR = 0xDA1U,
	SPN_AFTERTREATMENT_1_PURGE_AIR_ACTUATOR = 0xDA2U,
	SPN_AFTERTREATMENT_1_ATOMIZATION_AIR_ACTUATOR = 0xDA3U,
	SPN_AFTERTREATMENT_1_AIR_SYSTEM_RELAY = 0xDA4U,
	SPN_AFTERTREATMENT_2_FUEL_PRESSURE_CONTROL = 0xDA5U,
	SPN_AFTERTREATMENT_2_FUEL_PRESSURE = 0xDA6U,
	SPN_AFTERTREATMENT_2_FUEL_RATE = 0xDA7U,
	SPN_AFTERTREATMENT_2_FUEL_ENABLE_ACTUATOR = 0xDA8U,
	SPN_AFTERTREATMENT_2_REGENERATION_STATUS = 0xDA9U,
	SPN_AFTERTREATMENT_2_IGNITION = 0xDAAU,
	SPN_AFTERTREATMENT_2_SUPPLY_AIR_PRESSURE = 0xDABU,
	SPN_AFTERTREATMENT_2_PURGE_AIR_PRESSURE = 0xDACU,
	SPN_AFTERTREATMENT_2_AIR_PRESSURE_CONTROL = 0xDADU,
	SPN_AFTERTREATMENT_2_AIR_PRESSURE_ACTUATOR_POSITION = 0xDAEU,
	SPN_AFTERTREATMENT_2_AIR_ENABLE_ACTUATOR = 0xDAFU,
	SPN_AFTERTREATMENT_2_PURGE_AIR_ACTUATOR = 0xDB0U,
	SPN_AFTERTREATMENT_2_ATOMIZATION_AIR_ACTUATOR = 0xDB1U,
	SPN_AFTERTREATMENT_2_AIR_SYSTEM_RELAY = 0xDB2U,
	SPN_TECU_ECU_PWR_RELAY = 0xDB3U,
	SPN_TECU_PWR_RELAY = 0xDB4U,
	SPN_SENSOR_SUPPLY_VOLTAGE_3 = 0xDB5U,
	SPN_SENSOR_SUPPLY_VOLTAGE_4 = 0xDB6U,
	SPN_SENSOR_SUPPLY_VOLTAGE_5 = 0xDB7U,
	SPN_SENSOR_SUPPLY_VOLTAGE_6 = 0xDB8U,
	SPN_SENSOR_SUPPLY_VOLTAGE_7 = 0xDB9U,
	SPN_SENSOR_SUPPLY_VOLTAGE_8 = 0xDBAU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TEMPERATURE_2 = 0xDBBU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_CONCENTRATION = 0xDBCU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_LEVEL_2 = 0xDBDU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_CONDUCTIVITY = 0xDBEU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TEMPERATURE_2_PRELIMINARY_FMI = 0xDBFU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_PROPERTIES_PRELIMINARY_FMI = 0xDC0U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_PROPERTY = 0xDC1U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_LEVEL_PRELIMINARY = 0xDC2U,
	SPN_AFTERTREATMENT_1_TOTAL_FUEL_USED = 0xDC2U,
	SPN_AFTERTREATMENT_1_TOTAL_REGENERATION_TIME = 0xDC3U,
	SPN_AFTERTREATMENT_1_TOTAL_DISABLED_TIME = 0xDC4U,
	SPN_AFTERTREATMENT_1_TOTAL_NUMBER_OF_ACTIVE_REGENERATIONS = 0xDC5U,
	SPN_AFTERTREATMENT_2_TOTAL_FUEL_USED = 0xDC6U,
	SPN_AFTERTREATMENT_2_TOTAL_REGENERATION_TIME = 0xDC7U,
	SPN_AFTERTREATMENT_2_TOTAL_DISABLED_TIME = 0xDC8U,
	SPN_AFTERTREATMENT_2_TOTAL_NUMBER_OF_ACTIVE_REGENERATIONS = 0xDC9U,
	SPN_AFTERTREATMENT_1_REGENERATION_MANUALLY_DISABLED = 0xDCAU,
	SPN_AFTERTREATMENT_2_REGENERATION_MANUALLY_DISABLED = 0xDCBU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_LEVEL_PRELIMINARY_FMI = 0xDCCU,
	SPN_REQUESTED_ENGINE_CONTROL_MODE = 0xDD6U,
	SPN_ENGINE_OPERATING_STATE = 0xDD7U,
	SPN_TIME_REMAINING_IN_ENGINE_OPERATING_STATE = 0xDD8U,
	SPN_GENERATOR_CIRCUIT_BREAKER_STATUS = 0xDD9U,
	SPN_UTILITY_CIRCUIT_BREAKER_STATUS = 0xDDAU,
	SPN_AUTOMATIC_TRANSFER_SWITCH_STATUS = 0xDDBU,
	SPN_ENGINE_OIL_FILTER_OUTLET_PRESSURE = 0xDDDU,
	SPN_ENGINE_OIL_PRIMING_PUMP_SWITCH = 0xDDEU,
	SPN_ENGINE_OIL_PRIMING_STATE = 0xDDFU,
	SPN_ENGINE_VENTILATION_STATUS = 0xDE2U,
	SPN_AFTERTREATMENT_FUEL_INJECTOR_1 = 0xDE4U,
	SPN_ENGINE_INTAKE_MANIFOLD_1_ABSOLUTE_PRESSURE_1 = 0xDEBU,
	SPN_GENERATOR_CONTROL_NOT_IN_AUTOMATIC_START_STATE = 0xDEFU,
	SPN_GENERATOR_NOT_READY_TO_AUTOMATICALLY_PARALLEL_STATE = 0xDF0U,
	SPN_EARTH_FAULT = 0xDF1U,
	SPN_EARTH_LEAKAGE = 0xDF2U,
	SPN_GENERATOR_BREAKER_FAILURE_TO_OPEN = 0xDF3U,
	SPN_GENERATOR_BREAKER_FAILURE_TO_CLOSE = 0xDF4U,
	SPN_UTILITY_BREAKER_FAILURE_TO_OPEN = 0xDF5U,
	SPN_UTILITY_BREAKER_FAILURE_TO_CLOSE = 0xDF6U,
	SPN_UTILITY_TO_GENERATOR_TRANSFER_FAILURE = 0xDF7U,
	SPN_GENERATOR_TO_UTILITY_TRANSFER_FAILURE = 0xDF8U,
	SPN_LOSS_OF_UTILITY = 0xDF9U,
	SPN_GENERATOR_TO_BUS_SYNCHRONIZATION_FAILURE = 0xDFAU,
	SPN_GENERATORBUS_PHASE_SEQUENCE_MISMATCH_WARNING = 0xDFBU,
	SPN_GENERATOR_SOFT_UNLOAD_FAILURE = 0xDFCU,
	SPN_SCADA_DATA_LINK = 0xDFDU,
	SPN_ETHER_HOLD_RELAY = 0xE03U,
	SPN_ETHER_START_RELAY = 0xE04U,
	SPN_PRELUBE_RELAY = 0xE05U,
	SPN_ENGINE_EMERGENCY_SHUTDOWN_INDICATION = 0xE17U,
	SPN_DPF_1_INTAKE_PRESSURE = 0xE19U,
	SPN_ENGINE_INJECTOR_CYLINDER_1_ACTUATOR_2 = 0xE4BU,
	SPN_ENGINE_INJECTOR_CYLINDER_2_ACTUATOR_2 = 0xE4CU,
	SPN_ENGINE_INJECTOR_CYLINDER_3_ACTUATOR_2 = 0xE4DU,
	SPN_ENGINE_INJECTOR_CYLINDER_4_ACTUATOR_2 = 0xE4EU,
	SPN_ENGINE_INJECTOR_CYLINDER_5_ACTUATOR_2 = 0xE4FU,
	SPN_ENGINE_INJECTOR_CYLINDER_6_ACTUATOR_2 = 0xE50U,
	SPN_ENGINE_INJECTOR_CYLINDER_7_ACTUATOR_2 = 0xE51U,
	SPN_ENGINE_INJECTOR_CYLINDER_8_ACTUATOR_2 = 0xE52U,
	SPN_ENGINE_AIR_SHUTOFF_STATUS = 0xE53U,
	SPN_ENGINE_INTERCOOLER_COOLANT_LEVEL = 0xE54U,
	SPN_ENGINE_ROTATION_DIRECTION = 0xE55U,
	SPN_MAXIMUM_CRANK_ATTEMPTS_PER_START_ATTEMPT = 0xE56U,
	SPN_CRANK_ATTEMPT_COUNT_ON_PRESENT_START_ATTEMPT = 0xE57U,
	SPN_ENGINE_TURBOCHARGER_COMPRESSOR_BYPASS_ACTUATOR_POSITION = 0xE5BU,
	SPN_ENGINE_AFTERCOOLER_COOLANT_LEVEL = 0xE5CU,
	SPN_GENERATOR_UNAVAILABLE_TO_STARTRUN = 0xE5DU,
	SPN_PARTICULATE_TRAP_REGENERATION_INHIBIT_SWITCH = 0xE6FU,
	SPN_PARTICULATE_TRAP_REGENERATION_FORCE_SWITCH = 0xE70U,
	SPN_PARTICULATE_TRAP_LAMP_COMMAND = 0xE71U,
	SPN_EXHAUST_SYSTEM_HIGH_TEMPERATURE_LAMP_COMMAND = 0xE72U,
	SPN_DPF_ACTIVE_REGENERATION_STATUS = 0xE74U,
	SPN_DPF_STATUS = 0xE75U,
	SPN_PARTICULATE_TRAP_ACTIVE_REGENERATION_INHIBITED_STATUS = 0xE76U,
	SPN_DPF_ACTIVE_REGENERATION_INHIBITED_DUE_TO_INHIBIT_SWITCH = 0xE77U,
	SPN_DPF_ACTIVE_REGENERATION_INHIBITED_DUE_TO_ACCELERATOR_PEDAL_OFF_IDLE = 0xE7BU,
	SPN_DPF_ACTIVE_REGENERATION_INHIBITED_DUE_TO_OUT_OF_NEUTRAL = 0xE7CU,
	SPN_DPF_ACTIVE_REGENERATION_INHIBITED_DUE_TO_PARKING_BRAKE_NOT_SET = 0xE7EU,
	SPN_PARTICULATE_TRAP_ACTIVE_REGENERATION_INHIBITED_DUE_TO_LOW_EXHAUST_GAS_TEMPERATURE = 0xE7FU,
	SPN_DPF_ACTIVE_REGENERATION_INHIBITED_DUE_TO_SYSTEM_FAULT_ACTIVE = 0xE80U,
	SPN_DPF_ACTIVE_REGENERATION_INHIBITED_DUE_TO_SYSTEM_TIMEOUT = 0xE81U,
	SPN_PARTICULATE_TRAP_ACTIVE_REGENERATION_INHIBITED_DUE_TO_TEMPORARY_SYSTEM_LOCKOUT = 0xE82U,
	SPN_PARTICULATE_TRAP_ACTIVE_REGENERATION_INHIBITED_DUE_TO_PERMANENT_SYSTEM_LOCKOUT = 0xE83U,
	SPN_DPF_ACTIVE_REGENERATION_INHIBITED_DUE_TO_ENGINE_NOT_WARMED_UP = 0xE84U,
	SPN_PARTICULATE_TRAP_1_SOOT_LOAD_PERCENT = 0xE87U,
	SPN_PARTICULATE_TRAP_1_ASH_LOAD_PERCENT = 0xE88U,
	SPN_DPF_1_TIME_SINCE_LAST_ACTIVE_REGENERATION = 0xE89U,
	SPN_PARTICULATE_TRAP_2_ASH_LOAD_PERCENT = 0xE8BU,
	SPN_DPF_1_CONDITIONS_NOT_MET_FOR_ACTIVE_REGENERATION = 0xEA6U,
	SPN_INLET_MANIFOLD_CHARGE_COMBUSTION = 0xEC7U,
	SPN_TRACTOR_BRAKE_STROKE_AXLE_1_LEFT = 0xEC9U,
	SPN_TRACTOR_BRAKE_STROKE_AXLE_1_RIGHT = 0xECAU,
	SPN_TRACTOR_BRAKE_STROKE_AXLE_2_LEFT = 0xECBU,
	SPN_TRACTOR_BRAKE_STROKE_AXLE_2_RIGHT = 0xECCU,
	SPN_TRACTOR_BRAKE_STROKE_AXLE_3_LEFT = 0xECDU,
	SPN_TRACTOR_BRAKE_STROKE_AXLE_3_RIGHT = 0xECEU,
	SPN_TRACTOR_BRAKE_STROKE_AXLE_4_LEFT = 0xECFU,
	SPN_TRACTOR_BRAKE_STROKE_AXLE_4_RIGHT = 0xED0U,
	SPN_TRACTOR_BRAKE_STROKE_AXLE_5_LEFT = 0xED1U,
	SPN_TRACTOR_BRAKE_STROKE_AXLE_5_RIGHT = 0xED2U,
	SPN_TRAILER_BRAKE_STROKE_AXLE_1_LEFT = 0xED3U,
	SPN_TRAILER_BRAKE_STROKE_AXLE_1_RIGHT = 0xED4U,
	SPN_TRAILER_BRAKE_STROKE_AXLE_2_LEFT = 0xED5U,
	SPN_TRAILER_BRAKE_STROKE_AXLE_2_RIGHT = 0xED6U,
	SPN_TRAILER_BRAKE_STROKE_AXLE_3_LEFT = 0xED7U,
	SPN_TRAILER_BRAKE_STROKE_AXLE_3_RIGHT = 0xED8U,
	SPN_TRAILER_BRAKE_STROKE_AXLE_4_LEFT = 0xED9U,
	SPN_TRAILER_BRAKE_STROKE_AXLE_4_RIGHT = 0xEDAU,
	SPN_TRAILER_BRAKE_STROKE_AXLE_5_LEFT = 0xEDBU,
	SPN_TRAILER_BRAKE_STROKE_AXLE_5_RIGHT = 0xEDCU,
	SPN_TRACTOR_BRAKE_STROKE_ALERT_MONITOR = 0xEDDU,
	SPN_TRAILER_BRAKE_STROKE_ALERT_MONITOR = 0xEDEU,
	SPN_PARK_BRAKE_RELEASE_INHIBIT_REQUEST = 0xEDFU,
	SPN_PARK_BRAKE_RELEASE_INHIBIT_STATUS = 0xEE0U,
	SPN_TRANSMISSION_OIL_LEVEL_REQUEST = 0xEE1U,
	SPN_RETRACT_STATUS_OF_RAMP_1 = 0xEE2U,
	SPN_ENABLE_STATUS_OF_RAMP_1 = 0xEE3U,
	SPN_MOVEMENT_STATUS_OF_RAMP_1 = 0xEE4U,
	SPN_RETRACT_STATUS_OF_RAMP_2 = 0xEE5U,
	SPN_ENABLE_STATUS_OF_RAMP_2 = 0xEE6U,
	SPN_MOVEMENT_STATUS_OF_RAMP_2 = 0xEE7U,
	SPN_RETRACT_STATUS_OF_RAMP_3 = 0xEE8U,
	SPN_ENABLE_STATUS_OF_RAMP_3 = 0xEE9U,
	SPN_MOVEMENT_STATUS_OF_RAMP_3 = 0xEEAU,
	SPN_FRONT_AXLE_GROUP_ENGAGEMENT_STATUS = 0xEEBU,
	SPN_REAR_AXLE_GROUP_ENGAGEMENT_STATUS = 0xEECU,
	SPN_ENGINE_EXHAUST_GAS_RECIRCULATION_EGR_VALVE_2_CONTROL = 0xEEDU,
	SPN_ENGINE_EXHAUST_GAS_RECIRCULATION_VALVE_2_POSITION = 0xEEEU,
	SPN_TRANSMISSION_TORQUE_CONVERTER_OIL_OUTLET_TEMPERATURE = 0xEEFU,
	SPN_TRANSMISSION_GEAR_LATCH_ACTUATOR = 0xEF0U,
	SPN_TRANSMISSION_OUTPUT_SPEED_2 = 0xEF1U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_AVERAGE_CONSUMPTION = 0xEF2U,
	SPN_AFTERTREATMENT_1_SCR_COMMANDED_DIESEL_EXHAUST_FLUID_CONSUMPTION = 0xEF4U,
	SPN_EPS_SUPPLYING_LOAD = 0xEF5U,
	SPN_AFTERTREATMENT_1_SECONDARY_AIR_DIFFERENTIAL_PRESSURE = 0xEF6U,
	SPN_AFTERTREATMENT_1_SECONDARY_AIR_TEMPERATURE = 0xEF7U,
	SPN_AFTERTREATMENT_1_SECONDARY_AIR_MASS_FLOW = 0xEF8U,
	SPN_AFTERTREATMENT_2_SECONDARY_AIR_DIFFERENTIAL_PRESSURE = 0xEF9U,
	SPN_AFTERTREATMENT_2_SECONDARY_AIR_TEMPERATURE = 0xEFAU,
	SPN_AFTERTREATMENT_2_SECONDARY_AIR_MASS_FLOW = 0xEFBU,
	SPN_AFTERTREATMENT_1_SECONDARY_AIR_PRESSURE = 0xEFDU,
	SPN_AFTERTREATMENT_2_SECONDARY_AIR_PRESSURE = 0xEFEU,
	SPN_BRAKE_TEMPERATURE_WARNING = 0xEFFU,
	SPN_AUXILIARY_IO_17 = 0xF00U,
	SPN_AUXILIARY_IO_18 = 0xF01U,
	SPN_AUXILIARY_IO_19 = 0xF02U,
	SPN_AUXILIARY_IO_20 = 0xF03U,
	SPN_AUXILIARY_IO_21 = 0xF04U,
	SPN_AUXILIARY_IO_22 = 0xF05U,
	SPN_AUXILIARY_IO_23 = 0xF06U,
	SPN_AUXILIARY_IO_24 = 0xF07U,
	SPN_AUXILIARY_IO_25 = 0xF08U,
	SPN_AUXILIARY_IO_26 = 0xF09U,
	SPN_AUXILIARY_IO_27 = 0xF0AU,
	SPN_AUXILIARY_IO_28 = 0xF0BU,
	SPN_AUXILIARY_IO_29 = 0xF0CU,
	SPN_AUXILIARY_IO_30 = 0xF0DU,
	SPN_AUXILIARY_IO_31 = 0xF0EU,
	SPN_AUXILIARY_IO_32 = 0xF0FU,
	SPN_AUXILIARY_IO_33 = 0xF10U,
	SPN_AUXILIARY_IO_34 = 0xF11U,
	SPN_AUXILIARY_IO_35 = 0xF12U,
	SPN_AUXILIARY_IO_36 = 0xF13U,
	SPN_AUXILIARY_IO_37 = 0xF14U,
	SPN_AUXILIARY_IO_38 = 0xF15U,
	SPN_AUXILIARY_IO_39 = 0xF16U,
	SPN_AUXILIARY_IO_40 = 0xF17U,
	SPN_AUXILIARY_IO_41 = 0xF18U,
	SPN_AUXILIARY_IO_42 = 0xF19U,
	SPN_AUXILIARY_IO_43 = 0xF1AU,
	SPN_AUXILIARY_IO_44 = 0xF1BU,
	SPN_AUXILIARY_IO_45 = 0xF1CU,
	SPN_AUXILIARY_IO_46 = 0xF1DU,
	SPN_AUXILIARY_IO_47 = 0xF1EU,
	SPN_AUXILIARY_IO_48 = 0xF1FU,
	SPN_AUXILIARY_IO_49 = 0xF20U,
	SPN_AUXILIARY_IO_50 = 0xF21U,
	SPN_AUXILIARY_IO_51 = 0xF22U,
	SPN_AUXILIARY_IO_52 = 0xF23U,
	SPN_AUXILIARY_IO_53 = 0xF24U,
	SPN_AUXILIARY_IO_54 = 0xF25U,
	SPN_AUXILIARY_IO_55 = 0xF26U,
	SPN_AUXILIARY_IO_56 = 0xF27U,
	SPN_AUXILIARY_IO_57 = 0xF28U,
	SPN_AUXILIARY_IO_58 = 0xF29U,
	SPN_AUXILIARY_IO_59 = 0xF2AU,
	SPN_AUXILIARY_IO_60 = 0xF2BU,
	SPN_AUXILIARY_IO_61 = 0xF2CU,
	SPN_AUXILIARY_IO_62 = 0xF2DU,
	SPN_AUXILIARY_IO_63 = 0xF2EU,
	SPN_AUXILIARY_IO_64 = 0xF2FU,
	SPN_AUXILIARY_IO_65 = 0xF30U,
	SPN_AUXILIARY_IO_66 = 0xF31U,
	SPN_AUXILIARY_IO_67 = 0xF32U,
	SPN_AUXILIARY_IO_68 = 0xF33U,
	SPN_AUXILIARY_IO_69 = 0xF34U,
	SPN_AUXILIARY_IO_70 = 0xF35U,
	SPN_AUXILIARY_IO_71 = 0xF36U,
	SPN_AUXILIARY_IO_72 = 0xF37U,
	SPN_AUXILIARY_IO_73 = 0xF38U,
	SPN_AUXILIARY_IO_74 = 0xF39U,
	SPN_AUXILIARY_IO_75 = 0xF3AU,
	SPN_AUXILIARY_IO_76 = 0xF3BU,
	SPN_AUXILIARY_IO_77 = 0xF3CU,
	SPN_AUXILIARY_IO_78 = 0xF3DU,
	SPN_AUXILIARY_IO_79 = 0xF3EU,
	SPN_AUXILIARY_IO_80 = 0xF3FU,
	SPN_AUXILIARY_IO_81 = 0xF40U,
	SPN_AUXILIARY_IO_82 = 0xF41U,
	SPN_AUXILIARY_IO_83 = 0xF42U,
	SPN_AUXILIARY_IO_84 = 0xF43U,
	SPN_AUXILIARY_IO_85 = 0xF44U,
	SPN_AUXILIARY_IO_86 = 0xF45U,
	SPN_AUXILIARY_IO_87 = 0xF46U,
	SPN_AUXILIARY_IO_88 = 0xF47U,
	SPN_AUXILIARY_IO_89 = 0xF48U,
	SPN_AUXILIARY_IO_90 = 0xF49U,
	SPN_AUXILIARY_IO_91 = 0xF4AU,
	SPN_AUXILIARY_IO_92 = 0xF4BU,
	SPN_AUXILIARY_IO_93 = 0xF4CU,
	SPN_AUXILIARY_IO_94 = 0xF4DU,
	SPN_AUXILIARY_IO_95 = 0xF4EU,
	SPN_AUXILIARY_IO_96 = 0xF4FU,
	SPN_AUXILIARY_IO_97 = 0xF50U,
	SPN_AUXILIARY_IO_98 = 0xF51U,
	SPN_AUXILIARY_IO_99 = 0xF52U,
	SPN_AUXILIARY_IO_100 = 0xF53U,
	SPN_AUXILIARY_IO_101 = 0xF54U,
	SPN_AUXILIARY_IO_102 = 0xF55U,
	SPN_AUXILIARY_IO_103 = 0xF56U,
	SPN_AUXILIARY_IO_104 = 0xF57U,
	SPN_AUXILIARY_IO_105 = 0xF58U,
	SPN_AUXILIARY_IO_106 = 0xF59U,
	SPN_AUXILIARY_IO_107 = 0xF5AU,
	SPN_AUXILIARY_IO_108 = 0xF5BU,
	SPN_AUXILIARY_IO_109 = 0xF5CU,
	SPN_AUXILIARY_IO_110 = 0xF5DU,
	SPN_AUXILIARY_IO_111 = 0xF5EU,
	SPN_AUXILIARY_IO_112 = 0xF5FU,
	SPN_AFTERTREATMENT_DIESEL_PARTICULATE_FILTER_SYSTEM = 0xF60U,
	SPN_ENGINE_EXHAUST_BRAKE_ENABLE_SWITCH = 0xFA0U,
	SPN_TRANSFER_CASE_FRONT_DRIVELINE_ACTUATOR = 0xFCBU,
	SPN_TRANSFER_CASE_HIGH_RANGE_ACTUATOR = 0xFCCU,
	SPN_TRANSFER_CASE_LOW_RANGE_ACTUATOR = 0xFCDU,
	SPN_TRANSFER_CASE_NEUTRAL_ACTUATOR = 0xFCEU,
	SPN_TRANSFER_CASE_OUTPUT_SHAFT_PTO_ACTUATOR = 0xFCFU,
	SPN_TRANSFER_CASE_REAR_DRIVELINE_ACTUATOR = 0xFD1U,
	SPN_AFTERTREATMENT_1_FUEL_PRESSURE_2 = 0xFEDU,
	SPN_FUEL_PUMP_PRIMER_CONTROL = 0xFF2U,
	SPN_ENGINE_EXHAUST_GAS_TEMPERATURE_AVERAGE = 0x1037U,
	SPN_ENGINE_EXHAUST_GAS_TEMPERATURE_AVERAGE_BANK_2 = 0x1038U,
	SPN_ENGINE_EXHAUST_GAS_TEMPERATURE_AVERAGE_BANK_1 = 0x1039U,
	SPN_AUXILIARY_IO_CHANNEL_4 = 0x103DU,
	SPN_AUXILIARY_IO_CHANNEL_3 = 0x103EU,
	SPN_ENGINE_COOLANT_PUMP_OUTLET_TEMPERATURE = 0x1061U,
	SPN_ENGINE_COOLANT_THERMOSTAT_OPENING = 0x1062U,
	SPN_ENGINE_COOLANT_THERMOSTAT_MODE = 0x1063U,
	SPN_DESIRED_ENGINE_COOLANT_ENGINE_PUMP_OUTLET_TEMPERATURE = 0x1064U,
	SPN_DESIRED_ENGINE_COOLANT_THERMOSTAT_OPENING = 0x1065U,
	SPN_AFTERCOOLER_COOLANT_THERMOSTAT_MODE = 0x1066U,
	SPN_DESIRED_AFTERCOOLER_COOLANT_INLET_TEMPERATURE = 0x1067U,
	SPN_DESIRED_AFTERCOOLER_COOLANT_THERMOSTAT_OPENING = 0x1068U,
	SPN_ENGINE_SPEED_SENSOR_1 = 0x1069U,
	SPN_ENGINE_SPEED_SENSOR_3 = 0x106AU,
	SPN_ENGINE_SPEED_SENSOR_1_TIMING_PATTERN_STATUS = 0x106BU,
	SPN_ENGINE_SPEED_SENSOR_2_TIMING_PATTERN_STATUS = 0x106CU,
	SPN_ENGINE_SPEED_SENSOR_3_TIMING_PATTERN_STATUS = 0x106DU,
	SPN_ENGINE_CRANK_WITHOUT_PRELUBE = 0x1071U,
	SPN_ENGINE_PRELUBE_DRIVE = 0x1072U,
	SPN_HYDRAULIC_FAN_MOTOR_PRESSURE = 0x1073U,
	SPN_FAN_DRIVE_BYPASS_COMMAND_STATUS = 0x1074U,
	SPN_ENGINE_CRANK_WITHOUT_FUEL_INJECTION = 0x1075U,
	SPN_ENGINE_FAN_REVERSE_ACTUATOR = 0x1076U,
	SPN_GROUNDLEVEL_SHUTDOWN_ACTIVATED = 0x1077U,
	SPN_TRANSMISSION_REVERSE_SOLENOID_VALVE = 0x1078U,
	SPN_TRANSMISSION_SHIFT_MODULATION_SOLENOID_VALVE = 0x1079U,
	SPN_TRANSMISSION_SHIFT_RAIL_1_POSITION = 0x107AU,
	SPN_TRANSMISSION_SHIFT_RAIL_2_POSITION = 0x107BU,
	SPN_TRANSMISSION_SHIFT_RAIL_3_POSITION = 0x107CU,
	SPN_HIGH_SPEED_DIRECTIONAL_SHIFT = 0x107DU,
	SPN_ENGINE_EXHAUST_GAS_OXYGEN_SENSOR_CLOSED_LOOP_OPERATION_BANK_1 = 0x1090U,
	SPN_ENGINE_EXHAUST_GAS_OXYGEN_SENSOR_CLOSED_LOOP_OPERATION_BANK_2 = 0x1091U,
	SPN_ENGINE_RUN_RELAY = 0x1094U,
	SPN_FUEL_ENERGY_CONTENT = 0x1095U,
	SPN_CRANKING_VOLTAGE = 0x10A0U,
	SPN_AFTERTREATMENT_1_TRANSFORMER_SECONDARY_OUTPUT = 0x10A9U,
	SPN_AFTERTREATMENT_1_THREE_WAY_CATALYTIC_CONVERTER_INTAKE_GAS_TEMPERATURE = 0x10C1U,
	SPN_AFTERTREATMENT_1_THREE_WAY_CATALYTIC_CONVERTER_OUTLET_GAS_TEMPERATURE = 0x10C2U,
	SPN_AFTERTREATMENT_1_THREE_WAY_CATALYTIC_CONVERTER_DIFFERENTIAL_PRESSURE = 0x10C3U,
	SPN_AFTERTREATMENT_1_FUEL_INJECTOR_1_HEATER_CONTROL = 0x10CDU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_ACTUAL_DOSING_QUANTITY = 0x10EBU,
	SPN_AFTERTREATMENT_1_SCR_SYSTEM_STATE = 0x10ECU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_ACTUAL_QUANTITY_OF_INTEGRATOR = 0x10EDU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSER_ABSOLUTE_PRESSURE = 0x10EEU,
	SPN_AFTERTREATMENT_1_SCR_DOSING_AIR_ASSIST_ABSOLUTE_PRESSURE = 0x10EFU,
	SPN_AFTERTREATMENT_1_SCR_DOSING_AIR_ASSIST_VALVE = 0x10F0U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_TEMPERATURE = 0x10F1U,
	SPN_AFTERTREATMENT_1_SCR_DOSING_VALVE_EXHAUST_TEMPERATURE_REDUCTION_REQUEST = 0x10F2U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_1_STATE = 0x10F4U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_1_PRELIMINARY_FMI = 0x10F5U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_2_STATE = 0x10F6U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_2_PRELIMINARY_FMI = 0x10F7U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_3_STATE = 0x10F8U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_3_PRELIMINARY_FMI = 0x10F9U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_4_STATE = 0x10FAU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_4_PRELIMINARY_FMI = 0x10FBU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_REQUESTED_QUANTITY = 0x10FCU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_REQUESTED_QUANTITY_OF_INTEGRATOR = 0x10FEU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSER_FAULT_SUPPRESSION_REQUEST = 0x1100U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSER_HEATING_MODE_REQUEST = 0x1101U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_1 = 0x1102U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_2 = 0x1103U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_3 = 0x1104U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_4 = 0x1105U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_1_TEMPERATURE_PRELIMINARY_FMI = 0x110DU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_1_HEATER_PRELIMINARY_FMI = 0x110EU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_2_LEVEL = 0x110FU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_2_TEMPERATURE = 0x1110U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_2_LEVEL_2 = 0x1111U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_2_LEVEL_PRELIMINARY_FMI = 0x1112U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_2_TEMPERATURE_PRELMINARY_FMI = 0x1113U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_2_HEATER = 0x1114U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_2_HEATER_PRELMINARY_FMI = 0x1115U,
	SPN_AFTERTREATMENT_1_SCR_CATALYST_EXHAUST_GAS_DIFFERENTIAL_PRESSURE = 0x1106U,
	SPN_AFTERTREATMENT_1_SCR_CATALYST_INTAKE_GAS_TEMPERATURE = 0x1108U,
	SPN_AFTERTREATMENT_1_SCR_CATALYST_OUTLET_GAS_TEMPERATURE = 0x110BU,
	SPN_AFTERTREATMENT_1_SCR_CATALYST_CONVERSION_EFFICIENCY = 0x110CU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_PUMP_MOTOR_SPEED = 0x1116U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_PUMP_DRIVE_PERCENTAGE = 0x1117U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_RETURN_VALVE = 0x1118U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_ACTUAL_DOSING_QUANTITY = 0x1120U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_ACTUAL_QUANTITY_OF_INTEGRATOR = 0x1122U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSING_ABSOLUTE_PRESSURE = 0x1123U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSING_TEMPERATURE = 0x1126U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_1_STATE = 0x1129U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_1_PRELIMINARY_FMI = 0x112AU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_2_STATE = 0x112BU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_2_PRELIMINARY_FMI = 0x112CU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_3_STATE = 0x112DU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_3_PRELIMINARY_FMI = 0x112EU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_4_STATE = 0x112FU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_4_PRELIMINARY_FMI = 0x1130U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSING_REQUESTED_QUANTITY = 0x1131U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_REQUESTED_QUANTITY_OF_INTEGRATOR = 0x1133U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSER_FAULT_SUPPRESSION_REQUEST = 0x1135U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSER_HEATING_MODE_REQUEST = 0x1136U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_1 = 0x1137U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_2 = 0x1138U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_3 = 0x1139U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_4 = 0x113AU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_AVERAGE_CONSUMPTION = 0x1141U,
	SPN_AFTERTREATMENT_2_SCR_COMMANDED_DIESEL_EXHAUST_FLUID_CONSUMPTION = 0x1142U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TEMPERATURE_2 = 0x1144U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_CONCENTRATION = 0x1145U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_CONDUCTIVITY = 0x1146U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TEMPERATURE_2_PRELIMINARY_FMI = 0x1147U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_PROPERTIES_PRELIMINARY_FMI = 0x1148U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TYPE = 0x1149U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_LEVEL = 0x114AU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_TEMPERATURE = 0x114BU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_LEVEL_2 = 0x114CU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_LEVEL_PRELIMINARY_FMI = 0x114DU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_1_TEMPERATURE_PRELIMINARY_FMI = 0x114EU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_HEATER = 0x114FU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_1_HEATER_PRELIMINARY_FMI = 0x1150U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_2_LEVEL = 0x1151U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_2_TEMPERATURE = 0x1152U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_2_LEVEL_2 = 0x1153U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_2_LEVEL_PRELIMINARY_FMI = 0x1154U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_2_TEMPERATURE_PRELMINARY_FMI = 0x1155U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_2_HEATER = 0x1156U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_2_HEATER_PRELMINARY_FMI = 0x1157U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_PUMP_MOTOR_SPEED = 0x1158U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_PUMP_DRIVE_PERCENTAGE = 0x1159U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_RETURN_VALVE = 0x115AU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_CONTROLLER = 0x1162U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSING_UNIT = 0x1163U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSING_UNIT_INPUT_LINES = 0x1164U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_QUALITY = 0x1165U,
	SPN_AFTERTREATMENT_1_DIESEL_OXIDATION_CATALYST_INTAKE_GAS_TEMPERATURE = 0x129DU,
	SPN_AFTERTREATMENT_1_DIESEL_OXIDATION_CATALYST_OUTLET_GAS_TEMPERATURE = 0x129EU,
	SPN_AFTERTREATMENT_1_DIESEL_OXIDATION_CATALYST_DIFFERENTIAL_PRESSURE = 0x129FU,
	SPN_AFTERTREATMENT_1_THREE_WAY_CATALYST_DIFFERENTIAL_GAS_TEMPERATURE = 0x12ABU,
	SPN_DPF_1_SOOT_MASS = 0x12ADU,
	SPN_DPF_1_MEAN_SOOT_SIGNAL = 0x12AFU,
	SPN_DPF_1_SOOT_SENSOR = 0x12B1U,
	SPN_AFTERTREATMENT_1_SCR_CATALYST_SYSTEM = 0x12B8U,
	SPN_ENGINE_INTAKE_MANIFOLD_1_ABSOLUTE_PRESSURE_2 = 0x12D1U,
	SPN_MAGNET_BOOST_TIME = 0x1386U,
	SPN_MAGNET_RATED_POWER = 0x1387U,
	SPN_GENERATOR_OVERHEAT_STATUS = 0x1388U,
	SPN_GENSET_SYSTEM_OUTPUT_VOLTAGE_RANGE_STATUS = 0x1389U,
	SPN_REVERSE_CURRENT_RANGE_SETTING = 0x138AU,
	SPN_GRAPPLEMAGNET_SELECTION_SWITCH = 0x138BU,
	SPN_GENSET_SOFTSTART_ACTIVE = 0x138CU,
	SPN_GENSET_ENABLE_ACTIVE = 0x138DU,
	SPN_VOLTAGE_MONITOR_ACTIVE = 0x138EU,
	SPN_GENERATOR_DUTY_CYCLE_EXCEEDED_STATUS = 0x138FU,
	SPN_MAGNET_FORWARD_CURRENT = 0x1390U,
	SPN_MAGNET_REVERSE_CURRENT = 0x1391U,
	SPN_MATERIAL_LIFT_SWITCH = 0x1392U,
	SPN_MATERIAL_DROP_SWITCH = 0x1393U,
	SPN_GENERATOR_CURRENT_BOOST_ACTIVE_STATUS = 0x1394U,
	SPN_MATERIAL_LIFT_ACTIVE_STATUS = 0x1395U,
	SPN_MATERIAL_DROP_ACTIVE = 0x1396U,
	SPN_EGR_OUTLET_PRESSURE = 0x139BU,
	SPN_ENGINE_OIL_VISCOSITY = 0x13BFU,
	SPN_CAB_NOISE_CONTROL_STATE = 0x13C1U,
	SPN_CAB_NOISE_CONTROL_STATUS = 0x13C3U,
	SPN_CAB_NOISE_CONTROL_TUNING_STATUS = 0x13C4U,
	SPN_NOISE_CONTROLLER = 0x13C5U,
	SPN_NOISE_CONTROL_MICROPHONE_1 = 0x13C6U,
	SPN_NOISE_CONTROL_MICROPHONE_2 = 0x13C7U,
	SPN_NOISE_CONTROL_MICROPHONE_3 = 0x13C8U,
	SPN_NOISE_CONTROL_MICROPHONE_4 = 0x13C9U,
	SPN_NOISE_CONTROL_MICROPHONE_5 = 0x13CAU,
	SPN_NOISE_CONTROL_MICROPHONE_6 = 0x13CBU,
	SPN_NOISE_CONTROL_OUTPUT_1 = 0x13CCU,
	SPN_NOISE_CONTROL_OUTPUT_2 = 0x13CDU,
	SPN_NOISE_CONTROL_OUTPUT_3 = 0x13CEU,
	SPN_NOISE_CONTROL_OUTPUT_4 = 0x13CFU,
	SPN_NOISE_CONTROL_OUTPUT_5 = 0x13D0U,
	SPN_NOISE_CONTROL_OUTPUT_6 = 0x13D1U,
	SPN_NOISE_CONTROL_FEED_FORWARD_SENSOR_1 = 0x13D2U,
	SPN_NOISE_CONTROL_FEED_FORWARD_SENSOR_2 = 0x13D3U,
	SPN_ENGINE_PROTECT_LAMP_COMMAND = 0x13D5U,
	SPN_ENGINE_OIL_PRESSURE_LOW_LAMP_DATA = 0x13EBU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_HEATER_COMMAND = 0x1411U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_HEATER_COMMAND = 0x1412U,
	SPN_AFTERTREATMENT_SCR_OPERATOR_INDUCEMENT_SEVERITY = 0x147EU,
	SPN_UNEXPECTED_ENGINE_SHUTDOWN = 0x1498U,
	SPN_CRANK_TERMINATE_RELAY = 0x1499U,
	SPN_ENGINE_EXHAUST_MANIFOLD_BANK_1_FLOW_BALANCE_VALVE_ACTUATOR_CONTROL = 0x149CU,
	SPN_ENGINE_FUEL_INJECTION_QUANTITY_ERROR_FOR_MULTIPLE_CYLINDERS = 0x14EDU,
	SPN_ENGINE_DESIRED_TURBOCHARGER_WASTEGATE_ACTUATOR_1_POSITION = 0x14FAU,
	SPN_ENGINE_DESIRED_THROTTLE_VALVE_1_POSITION = 0x14FEU,
	SPN_ENGINE_THROTTLE_VALVE_1_TEMPERATURE_STATUS = 0x1500U,
	SPN_ENGINE_FUEL_VALVE_1_TEMPERATURE_STATUS = 0x1505U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_UNIT_LOSS_OF_PRIME = 0x1510U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_VALVE_1 = 0x1512U,
	SPN_PTO_SHUTDOWN_HAS_SHUTDOWN_ENGINE = 0x151CU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_2_HEATER_COMMAND = 0x1526U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_2_HEATER_COMMAND = 0x1527U,
	SPN_FUEL_FILTER_SUCTION_SIDE_INTAKE_PRESSURE = 0x1529U,
	SPN_ENGINE_FUEL_ACTUATOR_1 = 0x152AU,
	SPN_ENGINE_THROTTLE_ACTUATOR_1 = 0x152BU,
	SPN_ENGINE_TURBOCHARGER_COMPRESSOR_BYPASS_ACTUATOR_1 = 0x152CU,
	SPN_ENGINE_TURBOCHARGER_WASTEGATE_ACTUATOR_1 = 0x152DU,
	SPN_ENGINE_INTAKE_MANIFOLD_2_ABSOLUTE_PRESSURE = 0x152EU,
	SPN_AFTERTREATMENT_1_FUEL_PUMP_RELAY_CONTROL = 0x152FU,
	SPN_AFTERTREATMENT_1_FUEL_FLOW_DIVERTER_VALVE_CONTROL = 0x1530U,
	SPN_AFTERTREATMENT_1_FUEL_PRESSURE_2_ACTUATOR_CONTROL = 0x1531U,
	SPN_EGR_1_INTAKE_PRESSURE_ABSOLUTE = 0x1536U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_FILL_VALVE_COMMAND = 0x153AU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_PUMP_STATE = 0x153BU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_TANK_DRAIN_VALVE_COMMAND = 0x153CU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_FILL_VALVE_COMMAND = 0x153DU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_PUMP_STATE = 0x153EU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_TANK_DRAIN_VALVE_COMMAND = 0x153FU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_UNIT_LOSS_OF_PRIME_OBSOLETE = 0x1566U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_CONTROLLER_TEMPERATURE = 0x1568U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_PUMP_ORIFICE_FLOW = 0x156DU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_5_STATE = 0x1570U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_5_PRELIMINARY_FMI = 0x1571U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_5 = 0x1572U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_LINE_HEATER_RELAY = 0x1573U,
	SPN_AFTERTREATMENT_1_DPF_SOOT_MEAN_CALIBRATION_OFFSET = 0x1577U,
	SPN_INTAKE_VALVE_ACTUATION_SYSTEM_OIL_PRESSURE_SOLENOID_STATUS = 0x157BU,
	SPN_HYDROCARBON_HC_DOSER_STATUS = 0x1582U,
	SPN_SUPPLEMENTAL_FAN_DIRECTION_STATUS = 0x15B5U,
	SPN_SUPPLEMENTAL_FAN_CONTROLLER_TEMPERATURE_STATUS = 0x15B7U,
	SPN_SUPPLEMENTAL_FAN_SPEED = 0x15BAU,
	SPN_DPF_1_SOOT_SENSOR_ECU_INTERNAL_TEMPERATURE = 0x15C1U,
	SPN_HIGH_PRESSURE_COMMON_RAIL_FUEL_PRESSURE_RELIEF_VALVE = 0x15C3U,
	SPN_AFTERTREATMENT_1_IDENTIFICATION = 0x15C8U,
	SPN_AFTERTREATMENT_2_IDENTIFICATION = 0x15C9U,
	SPN_ENGINE_FUEL_DELIVERY_ABSOLUTE_PRESSURE = 0x15CAU,
	SPN_ENGINE_FILTERED_FUEL_DELIVERY_PRESSURE = 0x15CBU,
	SPN_ENGINE_FILTERED_FUEL_DELIVERY_ABSOLUTE_PRESSURE = 0x15CCU,
	SPN_ENGINE_FUEL_FILTER_DEGRADATION = 0x15D0U,
	SPN_ENGINE_INJECTOR_METERING_RAIL_1_CRANKING_PRESSURE = 0x15D1U,
	SPN_ENGINE_INTAKE_MANIFOLD_TEMPERATURES_INCONSISTENT = 0x15D3U,
	SPN_AFTERTREATMENT_1_SECONDARY_AIR_ABSOLUTE_PRESSURE = 0x15D5U,
	SPN_AFTERTREATMENT_1_DPF_AIR_CONTROL_MODULE = 0x15D7U,
	SPN_ENGINE_EXHAUST_BACK_PRESSURE_REGULATOR_POSITION = 0x15F9U,
	SPN_DPF_ACTIVE_REGENERATION_INHIBITED_DUE_TO_LOW_EXHAUST_GAS_PRESSURE = 0x15FDU,
	SPN_ENGINE_THROTTLE_VALVE_DIFFERENTIAL_PRESSURE = 0x15FFU,
	SPN_ENGINE_EXHAUST_GAS_PORT_1_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1636U,
	SPN_ENGINE_EXHAUST_GAS_PORT_2_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1637U,
	SPN_ENGINE_EXHAUST_GAS_PORT_3_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1638U,
	SPN_ENGINE_EXHAUST_GAS_PORT_4_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1639U,
	SPN_ENGINE_EXHAUST_GAS_PORT__5_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x163AU,
	SPN_ENGINE_EXHAUST_GAS_PORT_6_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x163BU,
	SPN_ENGINE_EXHAUST_GAS_PORT_7_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x163CU,
	SPN_ENGINE_EXHAUST_GAS_PORT__8_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x163DU,
	SPN_ENGINE_EXHAUST_GAS_PORT__9_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x163EU,
	SPN_ENGINE_EXHAUST_GAS_PORT_10_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x163FU,
	SPN_ENGINE_EXHAUST_GAS_PORT_11_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1640U,
	SPN_ENGINE_EXHAUST_GAS_PORT_12_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1641U,
	SPN_ENGINE_EXHAUST_GAS_PORT_13_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1642U,
	SPN_ENGINE_EXHAUST_GAS_PORT_14_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1643U,
	SPN_ENGINE_EXHAUST_GAS_PORT_15_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1644U,
	SPN_ENGINE_EXHAUST_GAS_PORT_16_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1645U,
	SPN_ENGINE_EXHAUST_GAS_PORT_17_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1646U,
	SPN_ENGINE_EXHAUST_GAS_PORT_18_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1647U,
	SPN_ENGINE_EXHAUST_GAS_PORT_19_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1648U,
	SPN_ENGINE_EXHAUST_GAS_PORT_20_DIFFERENCE_FROM_AVERAGE_TEMPERATURE = 0x1649U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_PUMP_HEATER = 0x164AU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_PUMP_HEATER_COMMAND = 0x164BU,
	SPN_ENGINE_COOLANT_PRESSURE_2 = 0x164CU,
	SPN_EMISSION_CONTROL_SYSTEM_OPERATOR_INDUCEMENT_SEVERITY = 0x16C2U,
	SPN_FUEL_TYPE = 0x16CDU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_UNIT_HEATER = 0x1671U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_UNIT_HEATER_RELAY = 0x1672U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSING_UNIT_LOSS_OF_PRIME = 0x1674U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_UNIT_HEATER_TEMPERATURE = 0x16A6U,
	SPN_DIESEL_EXHAUST_FLUID_CONSUMPTION_MALFUNCTION = 0x16CFU,
	SPN_DIESEL_EXHAUST_FLUID_DOSING_MALFUNCTION = 0x16D0U,
	SPN_DIESEL_EXHAUST_FLUID_QUALITY_MALFUNCTION = 0x16D1U,
	SPN_ENGINE_OIL_TEMPERATURE_3 = 0x1725U,
	SPN_AFTERTREATMENT_1_TOTAL_DIESEL_EXHAUST_FLUID_USED = 0x174BU,
	SPN_AFTERTREATMENT_2_TOTAL_DIESEL_EXHAUST_FLUID_USED = 0x174CU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_CONTROL_MODULE_RELAY_CONTROL = 0x174DU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_CONTROL_MODULE_POWER_SUPPLY = 0x174EU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_CONTROL_MODULE_RELAY_CONTROL = 0x174FU,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_CONTROL_MODULE_POWER_SUPPLY = 0x1750U,
	SPN_ENGINE_EXHAUST_MANIFOLD_BANK_2_TEMPERATURE_2 = 0x1751U,
	SPN_ENGINE_EXHAUST_MANIFOLD_BANK_1_TEMPERATURE_2 = 0x1752U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSING_UNIT_HEATER = 0x1753U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSER_ABSOLUTE_PRESSURE = 0x1754U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_LINE_HEATER_RELAY = 0x1755U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSING_VALVE_1 = 0x1756U,
	SPN_AFTERTREATMENT_1_DPF_TIME_TO_NEXT_ACTIVE_REGENERATION = 0x175AU,
	SPN_ENGINE_CYLINDER_1_PRESSURE = 0x1811U,
	SPN_ENGINE_CYLINDER_2_PRESSURE = 0x1812U,
	SPN_ENGINE_CYLINDER_3_PRESSURE = 0x1813U,
	SPN_ENGINE_CYLINDER_4_PRESSURE = 0x1814U,
	SPN_ENGINE_CYLINDER_5_PRESSURE = 0x1815U,
	SPN_ENGINE_CYLINDER_6_PRESSURE = 0x1816U,
	SPN_ENGINE_CYLINDER_7_PRESSURE = 0x1817U,
	SPN_ENGINE_CYLINDER_8_PRESSURE = 0x1818U,
	SPN_ENGINE_CYLINDER_9_PRESSURE = 0x1819U,
	SPN_ENGINE_CYLINDER_10_PRESSURE = 0x181AU,
	SPN_ENGINE_CYLINDER_11_PRESSURE = 0x181BU,
	SPN_ENGINE_CYLINDER_12_PRESSURE = 0x181CU,
	SPN_ENGINE_CYLINDER_13_PRESSURE = 0x181DU,
	SPN_ENGINE_CYLINDER_14_PRESSURE = 0x181EU,
	SPN_ENGINE_CYLINDER_15_PRESSURE = 0x181FU,
	SPN_ENGINE_CYLINDER_16_PRESSURE = 0x1820U,
	SPN_ENGINE_CYLINDER_17_PRESSURE = 0x1821U,
	SPN_ENGINE_CYLINDER_18_PRESSURE = 0x1822U,
	SPN_ENGINE_CYLINDER_19_PRESSURE = 0x1823U,
	SPN_ENGINE_CYLINDER_20_PRESSURE = 0x1824U,
	SPN_ENGINE_CYLINDER_1_GASEOUS_FUEL_VALVE = 0x1825U,
	SPN_ENGINE_CYLINDER_2_GASEOUS_FUEL_VALVE = 0x1826U,
	SPN_ENGINE_CYLINDER_3_GASEOUS_FUEL_VALVE = 0x1827U,
	SPN_ENGINE_CYLINDER_4_GASEOUS_FUEL_VALVE = 0x1828U,
	SPN_ENGINE_CYLINDER_5_GASEOUS_FUEL_VALVE = 0x1829U,
	SPN_ENGINE_CYLINDER_6_GASEOUS_FUEL_VALVE = 0x182AU,
	SPN_ENGINE_CYLINDER_7_GASEOUS_FUEL_VALVE = 0x182BU,
	SPN_ENGINE_CYLINDER_8_GASEOUS_FUEL_VALVE = 0x182CU,
	SPN_ENGINE_CYLINDER_9_GASEOUS_FUEL_VALVE = 0x182DU,
	SPN_ENGINE_CYLINDER_10_GASEOUS_FUEL_VALVE = 0x182EU,
	SPN_ENGINE_CYLINDER_11_GASEOUS_FUEL_VALVE = 0x182FU,
	SPN_ENGINE_CYLINDER_12_GASEOUS_FUEL_VALVE = 0x1830U,
	SPN_ENGINE_CYLINDER_13_GASEOUS_FUEL_VALVE = 0x1831U,
	SPN_ENGINE_CYLINDER_14_GASEOUS_FUEL_VALVE = 0x1832U,
	SPN_ENGINE_CYLINDER_15_GASEOUS_FUEL_VALVE = 0x1833U,
	SPN_ENGINE_CYLINDER_16_GASEOUS_FUEL_VALVE = 0x1834U,
	SPN_ENGINE_CYLINDER_17_GASEOUS_FUEL_VALVE = 0x1835U,
	SPN_ENGINE_CYLINDER_18_GASEOUS_FUEL_VALVE = 0x1836U,
	SPN_ENGINE_CYLINDER_19_GASEOUS_FUEL_VALVE = 0x1837U,
	SPN_ENGINE_CYLINDER_20_GASEOUS_FUEL_VALVE = 0x1838U,
	SPN_ENGINE_TURBOCHARGER_COMPRESSOR_BLOWOFF_ACTUATOR_1_COMMAND = 0x1839U,
	SPN_ENGINE_CONTROL_MODULE_1_READY_FOR_USE_LAMP_COMMAND = 0x183DU,
	SPN_ENGINE_CONTROL_MODULE_2_READY_FOR_USE_LAMP_COMMAND = 0x183EU,
	SPN_ENGINE_CONTROL_MODULE_3_READY_FOR_USE_LAMP_COMMAND = 0x183FU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_CONTROL_MODULE_POWER_SUPPLY_2 = 0x18A5U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_CONTROL_MODULE_POWER_SUPPLY_2 = 0x18A6U,
	SPN_REQUESTED_FUEL_TYPE = 0x18ADU,
	SPN_ENGINE_TOTAL_HOURS_OF_GASEOUS_FUEL_OPERATION = 0x18AFU,
	SPN_ENGINE_TOTAL_HOURS_OF_DIESEL_FUEL_OPERATION = 0x18B0U,
	SPN_ENGINE_EXTENDED_RANGE_OIL_FILTER_DIFFERENTIAL_PRESSURE = 0x18B1U,
	SPN_AFTERTREATMENT_1_SCR_DESULFATION_TOO_FREQUENT = 0x18B2U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_VALVE_2 = 0x18B4U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSING_VALVE_2 = 0x18B5U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_VALVE_1_HEATER = 0x18B6U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_VALVE_2_HEATER = 0x18B7U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSING_VALVE_1_HEATER = 0x18B8U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSING_VALVE_2_HEATER = 0x18B9U,
	SPN_ENGINE_TIMING_ACTUATOR_1_REQUESTED_POSITION = 0x18BEU,
	SPN_ENGINE_TIMING_ACTUATOR_2_REQUESTED_POSITION = 0x18BFU,
	SPN_ENGINE_TIMING_ACTUATOR_1_POSITION_COMMAND = 0x18C0U,
	SPN_ENGINE_TIMING_ACTUATOR_2_POSITION_COMMAND = 0x18C1U,
	SPN_ENGINE_GAS_FUEL_PERCENTAGE_COMMAND = 0x18F2U,
	SPN_ENGINE_CYLINDER_GAS_MASS_FLOW_RATE_COMMAND = 0x18F3U,
	SPN_ENGINE_CYLINDER_DIESEL_MASS_FLOW_RATE_COMMAND = 0x18F4U,
	SPN_ENGINE_CYLINDER_TORQUE = 0x18F5U,
	SPN_ENGINE_CYLINDER_PRESSURE_MONITOR_1_PRELIMINARY_FMI = 0x18F6U,
	SPN_ENGINE_CYLINDER_PRESSURE_MONITOR_2_PRELIMINARY_FMI = 0x18F7U,
	SPN_ENGINE_CYLINDER_1_KNOCK_LEVEL_1 = 0x18FEU,
	SPN_ENGINE_CYLINDER_1_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x18FFU,
	SPN_ENGINE_CYLINDER_2_KNOCK_LEVEL_2 = 0x1902U,
	SPN_ENGINE_CYLINDER_2_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x1903U,
	SPN_ENGINE_CYLINDER_3_KNOCK_LEVEL_3 = 0x1906U,
	SPN_ENGINE_CYLINDER_3_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x1907U,
	SPN_ENGINE_CYLINDER_4_KNOCK_LEVEL_4 = 0x190AU,
	SPN_ENGINE_CYLINDER_4_KNOCK_LEVEL_5 = 0x190AU,
	SPN_ENGINE_CYLINDER_5_KNOCK_LEVEL_6 = 0x190EU,
	SPN_ENGINE_CYLINDER_5_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x190EU,
	SPN_ENGINE_CYLINDER_6_KNOCK_LEVEL_7 = 0x1912U,
	SPN_ENGINE_CYLINDER_6_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x1913U,
	SPN_ENGINE_CYLINDER_7_KNOCK_LEVEL_8 = 0x1916U,
	SPN_ENGINE_CYLINDER_7_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x1917U,
	SPN_ENGINE_CYLINDER_8_KNOCK_LEVEL_9 = 0x191AU,
	SPN_ENGINE_CYLINDER_8_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x191BU,
	SPN_ENGINE_CYLINDER_9_KNOCK_LEVEL_10 = 0x191EU,
	SPN_ENGINE_CYLINDER_9_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x191FU,
	SPN_ENGINE_CYLINDER_10_KNOCK_LEVEL_11 = 0x1922U,
	SPN_ENGINE_CYLINDER_10_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x1923U,
	SPN_ENGINE_CYLINDER_11_KNOCK_LEVEL_12 = 0x1926U,
	SPN_ENGINE_CYLINDER_11_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x1927U,
	SPN_ENGINE_CYLINDER_12_KNOCK_LEVEL_13 = 0x192AU,
	SPN_ENGINE_CYLINDER_12_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x192BU,
	SPN_ENGINE_CYLINDER_13_KNOCK_LEVEL_14 = 0x192EU,
	SPN_ENGINE_CYLINDER_13_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x192FU,
	SPN_ENGINE_CYLINDER_14_KNOCK_LEVEL_15 = 0x1932U,
	SPN_ENGINE_CYLINDER_14_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x1933U,
	SPN_ENGINE_CYLINDER_15_KNOCK_LEVEL_16 = 0x1936U,
	SPN_ENGINE_CYLINDER_15_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x1937U,
	SPN_ENGINE_CYLINDER_16_KNOCK_LEVEL_17 = 0x193AU,
	SPN_ENGINE_CYLINDER_16_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x193BU,
	SPN_ENGINE_CYLINDER_17_KNOCK_LEVEL_18 = 0x193EU,
	SPN_ENGINE_CYLINDER_17_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x193FU,
	SPN_ENGINE_CYLINDER_18_KNOCK_LEVEL_19 = 0x1942U,
	SPN_ENGINE_CYLINDER_18_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x1943U,
	SPN_ENGINE_CYLINDER_19_KNOCK_LEVEL_20 = 0x1946U,
	SPN_ENGINE_CYLINDER_19_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x1947U,
	SPN_ENGINE_CYLINDER_20_KNOCK_LEVEL_21 = 0x194AU,
	SPN_ENGINE_CYLINDER_20_PRESSURE_SENSOR_PRELIMINARY_FMI = 0x194BU,
	SPN_AFTERTREATMENT_DIESEL_EXHAUST_FLUID_DOSER_COOLDOWN_INTERRUPT_COUNT = 0x194CU,
	SPN_AFTERTREATMENT_DIESEL_EXHAUST_FLUID_DOSER_PURGE_INTERRUPT_COUNT = 0x194DU,
	SPN_AFTERTREATMENT_DIESEL_EXHAUST_FLUID_DOSER_COOLDOWN_COMPLETE_THIS_CYCLE = 0x194EU,
	SPN_AFTERTREATMENT_DIESEL_EXHAUST_FLUID_DOSER_COOLDOWN_COMPLETE_LAST_CYCLE = 0x194FU,
	SPN_AFTERTREATMENT_DIESEL_EXHAUST_FLUID_DOSER_PURGE_COMPLETE_THIS_CYCLE = 0x1950U,
	SPN_AFTERTREATMENT_DIESEL_EXHAUST_FLUID_DOSER_PURGE_COMPLETE_LAST_CYCLE = 0x1951U,
	SPN_ENGINE_CYLINDER_PRESSURE_MONITOR_1 = 0x19A4U,
	SPN_ENGINE_CYLINDER_PRESSURE_MONITOR_2 = 0x19A5U,
	SPN_ENGINE_MAIN_CHAMBER_FUEL_ABSOLUTE_PRESSURE = 0x19ABU,
	SPN_ENGINE_MAIN_CHAMBER_FUEL_DESIRED_ABSOLUTE_PRESSURE = 0x19ACU,
	SPN_ENGINE_PRECHAMBER_FUEL_ABSOLUTE_PRESSURE = 0x19ADU,
	SPN_ENGINE_PRECHAMBER_FUEL_DESIRED_ABSOLUTE_PRESSURE = 0x19AEU,
	SPN_ENGINE_MAIN_CHAMBER_AIR_FUEL_RATIO = 0x19AFU,
	SPN_ENGINE_MAIN_CHAMBER_DESIRED_AIR_FUEL_RATIO = 0x19B0U,
	SPN_ENGINE_PRECHAMBER_AIR_FUEL_RATIO = 0x19B1U,
	SPN_ENGINE_PRECHAMBER_DESIRED_AIR_FUEL_RATIO = 0x19B2U,
	SPN_ENGINE_EXHAUST_NOX = 0x19B3U,
	SPN_ENGINE_EXHAUST_DESIRED_NOX = 0x19B4U,
	SPN_AFTERTREATMENT_1_HYDROCARBON_DOSER_2 = 0x19B5U,
	SPN_OPERATOR_SHUTDOWN_WITH_HIGH_EXHAUST_TEMPERATURE = 0x19BCU,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_DOSING_REQUESTED_QUANTITY_HIGH_RANGE = 0x19C1U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_DOSING_REQUESTED_QUANTITY_HIGH_RANGE = 0x19C2U,
	SPN_AFTERTREATMENT_1_DIESEL_EXHAUST_FLUID_ACTUAL_DOSING_QUANTITY_HIGH_RANGE = 0x19C3U,
	SPN_AFTERTREATMENT_2_DIESEL_EXHAUST_FLUID_ACTUAL_DOSING_QUANTITY_HIGH_RANGE = 0x19C4U,
	SPN_CGI_MASS_FLOW = 0x7F000U,
	SPN_CGI_GAS_TEMPERATURE = 0x7F001U,
	SPN_CGI_CONTROL_VALVE = 0x7F002U,
	SPN_CGI_DIFFERENTIAL_PRESSURE = 0x7F004U,
	SPN_CGI_ABSOLUTE_PRESSURE = 0x7F005U,
	SPN_OPEN_STAGE = 0x7F040U,
	SPN_ENGINE_INJECTOR_CYLINDER_1_AND_CYLINDER_4 = 0x7FD03U,
	SPN_ENGINE_INJECTOR_CYLINDER_2_AND_CYLINDER_3 = 0x7FD04U,
	SPN_ENGINE_INJECTOR_CHARGE_CAPACITOR_SUPPLY_VOLTAGE = 0x7FD05U,
	SPN_ECU_CPU = 0x7FD07U,
	SPN_ENGINE_INJECTOR_CHARGE_VOLTAGE = 0x7FD0FU,
	SPN_EGR_RESPONSE = 0x7FD10U,
	SPN_EGR_MOTOR_TEMPERATURE_SENSOR = 0x7FD11U,
	SPN_ENGINE_INJECTOR_CODE = 0x7FD12U,
	SPN_FUEL_PUMP_PRESSURE_1 = 0x7FD13U,
	SPN_FUEL_PUMP_PRESSURE_2 = 0x7FD14U,
	SPN_EGR_LIFT_SENSOR = 0x7FD15U,
	SPN_ACCELERATOR_PEDAL_POSITION_SENSOR = 0x7FD17U,
	SPN_ENGINE_START_AID = 0x7FD18U,
	SPN_CAN_DATA_LINK_1 = 0x7FD1BU,
	SPN_CAN_DATA_LINK_2 = 0x7FD1CU,
	SPN_EGR_POSITION_SENSOR = 0x7FD34U,
	SPN_EGR_ACTUATOR_COIL_LOW_SIDE_DRIVER = 0x7FD36U,
	SPN_EGR_ACTUATOR = 0x7FD37U,
	SPN_EGR_ACTUATOR_TEMPERATURE = 0x7FD38U,
	SPN_EGR_ACTUATOR_TEMPERATURE_SENSOR = 0x7FD39U,
	SPN_EGR_ACTUATOR_DATA_LINK = 0x7FD3AU,
	SPN_INTAKE_THROTTLE = 0x7FD3CU,
	SPN_INTAKE_THROTTLE_LIFT_SENSOR = 0x7FD3EU,
	SPN_ENGINE_COOLANT_TEMPERATURE_DURING_STATIONARY_REGENERATION = 0x7FD45U,
	SPN_STATIONARY_REGENERATION_DURATION = 0x7FD46U,
	SPN_CAN_DATA_LINK_3 = 0x7FD47U,
	SPN_CAN_DATA_LINK_4 = 0x7FD47U,
	SPN_CAN_DATA_LINK_5 = 0x7FD47U,
	SPN_CAN_DATA_LINK_6 = 0x7FD48U,
	SPN_CAN_DATA_LINK_7 = 0x7FD49U,
	SPN_CAN_DATA_LINK_8 = 0x7FD4AU,
	SPN_CAN_DATA_LINK_9 = 0x7FD4BU,
	SPN_CAN_DATA_LINK_10 = 0x7FD4CU,
	SPN_CAN_DATA_LINK_11 = 0x7FD4EU,
	SPN_ALL_EXHAUST_GAS_TEMPERATURE_SENSORS_FAILURE = 0x7FD4FU,
	SPN_FUEL_PUMP_CALIBRATION_NOT_COMPLETED = 0x7FD50U,
	SPN_EXHAUST_GAS_TEMPERATURE_6 = 0x7FD51U,
	SPN_AFTERTREATMENT_REGENERATION_FREQUENCY = 0x7FD52U,
	SPN_ENGINE_COOLANT_TEMPERATURE_3 = 0x7FD53U,
	SPN_CAN_DATA_LINK = 0x7FD54U,
	SPN_EEPROM_CHECKSUM = 0x7FDB4U
}ENUM_CODES;

#endif /* SAE_J1939_ENUMS_SAE_J1939_ENUM_DM1_DM2_H_ */
