/*
 * Enum_DM14_DM15.h
 *
 *  Created on: 8 juli 2021
 *      Author: Daniel Mårtensson
 */

#ifndef SAE_J1939_ENUMS_SAE_J1939_ENUM_DM14_DM15_H_
#define SAE_J1939_ENUMS_SAE_J1939_ENUM_DM14_DM15_H_

/* DM14 and DM15 enums */
typedef enum {
	/* Status */
	STATUS_DM15_PROCEED = 0x0U,
	STATUS_DM15_BUSY = 0x1U,
	STATUS_DM15_OPERATION_COMPLETED = 0x4U,
	STATUS_DM15_OPERATION_FAILED = 0x5U,
	/* EDCP extesion */
	EDCP_EXTENSION_ALL_EDC_PARAMETER_BEEN_SENT = 0x0U,
	EDCP_EXTENSION_CONCATENATE_FOLLOWING_DATA_HIGHER_ORDER = 0x2U,
	EDCP_EXTENSION_CONCATENATE_FOLLOWING_DATA_LOWER_ORDER = 0x3U,
	EDCP_EXTENSION_DATA_IN_EDC_PARAMETER_IS_ERROR_INDICATOR = 0x4U,
	EDCP_EXTENSION_DATA_IN_EDC_PARAMETER_IS_ERROR_INDICATOR_SEED_IS_TIME_TO_COMPLETE = 0x7U,
	EDCP_EXTENSION_NOT_USED = 0xFFU,
	/* EDC parameter */
	EDC_PARAMETER_PROCESSING_ERASE_REQUEST = 0x10U,
	EDC_PARAMETER_PROCESSING_READ_REQUEST = 0x11U,
	EDC_PARAMETER_PROCESSING_WRITE_REQUEST = 0x12U,
	EDC_PARAMETER_PROCESSING_STATUS_REQUEST = 0x13U,
	EDC_PARAMETER_PROCESSING_BOOT_LOAD_REQUEST = 0x16U,
	EDC_PARAMETER_NOT_VERIFY_RAM_WRITE = 0x21U,
	EDC_PARAMETER_NOT_VERIFY_FLASH_WRITE = 0x22U,
	EDC_PARAMETER_NOT_VERIFY_EEPROM_WRITE = 0x23U,
	EDC_PARAMETER_INVALID_KEY = 0x1003U,
	/* Seed */
	SEED_NO_MORE_KEYS_NEED_FOR_THE_PROCESS = 0x0U,
	SEED_USE_LONG_KEY = 0x1U,
	SEED_NO_KEY_USED = 0xFFFFU
} ENUM_DM15_CODES;

typedef enum {
	/* Command */
	COMMAND_DM14_READ = 0x1U,
	COMMAND_DM14_WRITE = 0x2U,
	COMMAND_DM14_OPERATION_COMPLETED = 0x4U,
	COMMAND_DM14_OPERATION_FAILED = 0x5U,
	COMMAND_DM14_BOOT_LOAD = 0x6U,
	/* Pointer type */
	POINTER_TYPE_JOIN_POINTER_WITH_POINTER_EXTENSION = 0x0U,
	POINTER_TYPE_POINTER_EXTENSION_IS_A_COMMAND = 0x1U,
	/* Pointer extension */
	POINTER_EXTENSION_DM14_FLASH_ACCESS = 0x0U,
	POINTER_EXTENSION_DM14_EEPROM_ACCESS = 0x1U,
	POINTER_EXTENSION_DM14_VARIABLE_ACCESS = 0x2U,
	USER_KEY_LEVEL_DM14_NO_KEY_AVAILABLE = 0xFFFFU
}ENUM_DM14_CODES;

#endif /* SAE_J1939_ENUMS_SAE_J1939_ENUM_DM14_DM15_H_ */
