# Contributing Guidelines

Thank you for considering contributing to Simple Browser! We welcome contributions from everyone. By participating in this project, you agree to abide by the following guidelines.

## How to Contribute

1. Fork the repository and create your branch from `main`.
2. Make your changes, ensuring to add comments where necessary.
3. Ensure your code follows the existing coding style, if any.
4. Submit a pull request. Be sure to fill out the provided template.

## Code Review Process

All pull requests will be manually reviewed by the maintainers. We aim to provide feedback within a reasonable time frame. Automated review processes are coming soon.

## Communication

We use the GitHub Discussions tab for communication among contributors. Feel free to ask questions or discuss major changes there.

## Decision Making

Major decisions regarding the project are made by the project maintainers. If you have suggestions or concerns, please feel free to raise them in the Discussions tab.

## Areas Needing Attention

We welcome contributions across all areas of the project. Whether it's bug fixes, feature additions, or documentation improvements, all contributions are appreciated.

## Pull Request and Issue Templates

Please use the provided templates when submitting pull requests and opening issues. This helps ensure that necessary information is included and streamlines the review process.

## Code Licensing

All contributions are made under the MIT License unless otherwise specified.

## Testing Contributions

There are currently no specific guidelines for testing contributions. However, we encourage contributors to thoroughly test their changes before submitting pull requests.

## Recognition and Credits

Contributors will be credited in the Simple Browser app's credits menu and in the `CREDITS.md` file located in the root of the repository.

## Confidentiality

There are no sensitive or confidential aspects of the project that contributors need to be aware of.

## Cultural and Behavioral Expectations

We do not have any specific cultural or behavioral expectations for contributors. We value diversity and inclusion in our community.
