package org.dmk.solr.spelling;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import org.apache.solr.spelling.QueryConverter;
import org.apache.solr.spelling.Token;

public class MultiWordSpellingQueryConverter extends QueryConverter {
	/**
     * Converts the original query string to a collection of Lucene Tokens.
     * 
     * @param original the original query string
     * @return a Collection of Lucene Tokens
     */
    public Collection<Token> convert( String original ) {
        if ( original == null ) {
            return Collections.emptyList();
        }
        final Token token = new Token(original, 0, original.length());
        return Arrays.asList( token );
    }
}
