<?php
/***************************************************************
*  Copyright notice
*
*  (c) 2011 DMK E-Business GmbH
*  All rights reserved
*
*  This script is part of the TYPO3 project. The TYPO3 project is
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/

/**
 * @author Hannes Bochmann <hannes.bochmann@dmk-ebusiness.de>
 * @author Michael Wagner <michael.wagner@dmk-ebusiness.de>
 * @license http://www.gnu.org/licenses/lgpl.html
 *          GNU Lesser General Public License, version 3 or later
 */
class Apache_Solr_ServiceTest extends tx_mksearch_tests_Testcase
{
    /**
     * @group unit
     */
    public function testCommitCallsSendRawPostWithWaitFlushParameterIfNotSolr4()
    {
        $service = $this->getMockBuilder('Apache_Solr_Service')
            ->onlyMethods(['_sendRawPost'])
            ->getMock();
        $service->setCompatibilityLayer(new Apache_Solr_Compatibility_Solr3CompatibilityLayer());

        $expectedUrl = 'http://localhost:8180/solr/update?wt=json';
        $expectedRawPostWithWaitFlushParameter =
            '<commit expungeDeletes="false" waitFlush="true" waitSearcher="true" />';
        $expectedTimeout = 3600;

        $service->expects($this->once())
            ->method('_sendRawPost')
            ->with($expectedUrl, $expectedRawPostWithWaitFlushParameter, $expectedTimeout);

        $service->commit();
    }

    /**
     * @group unit
     */
    public function testCommitCallsSendRawPostWithoutWaitFlushParameterIfSolr4()
    {
        $service = $this->getMockBuilder('Apache_Solr_Service')
            ->onlyMethods(['_sendRawPost'])
            ->getMock();
        $service->setCompatibilityLayer(new Apache_Solr_Compatibility_Solr4CompatibilityLayer());

        $expectedUrl = 'http://localhost:8180/solr/update?wt=json';
        $expectedRawPostWithWaitFlushParameter =
            '<commit expungeDeletes="false" softCommit="false" waitSearcher="true" />';
        $expectedTimeout = 3600;

        $service->expects($this->once())
            ->method('_sendRawPost')
            ->with($expectedUrl, $expectedRawPostWithWaitFlushParameter, $expectedTimeout);

        $service->commit();
    }

    /**
     * @group unit
     */
    public function testOptimizeCallsSendRawPostWithWaitFlushParameterIfNotSolr4()
    {
        $service = $this->getMockBuilder('Apache_Solr_Service')
            ->onlyMethods(['_sendRawPost'])
            ->getMock();
        $service->setCompatibilityLayer(new Apache_Solr_Compatibility_Solr3CompatibilityLayer());

        $expectedUrl = 'http://localhost:8180/solr/update?wt=json';
        $expectedRawPostWithWaitFlushParameter =
            '<optimize waitFlush="true" waitSearcher="true" />';
        $expectedTimeout = 3600;

        $service->expects($this->once())
            ->method('_sendRawPost')
            ->with($expectedUrl, $expectedRawPostWithWaitFlushParameter, $expectedTimeout);

        $service->optimize();
    }

    /**
     * @group unit
     */
    public function testOptimizeCallsSendRawPostWithoutWaitFlushParameterIfSolr4()
    {
        $service = $this->getMockBuilder('Apache_Solr_Service')
            ->onlyMethods(['_sendRawPost'])
            ->getMock();
        $service->setCompatibilityLayer(new Apache_Solr_Compatibility_Solr4CompatibilityLayer());

        $expectedUrl = 'http://localhost:8180/solr/update?wt=json';
        $expectedRawPostWithWaitFlushParameter =
            '<optimize waitSearcher="true" />';
        $expectedTimeout = 3600;

        $service->expects($this->once())
            ->method('_sendRawPost')
            ->with($expectedUrl, $expectedRawPostWithWaitFlushParameter, $expectedTimeout);

        $service->optimize();
    }
}
