import React from 'react';
import ContextMenu from './context-menu'

let dialog
if(typeof WEB === 'undefined')
	dialog = require('@electron/remote').dialog

export default (props) => {
	return (
		<ContextMenu rightAlign={true} onClick={(e) => {
			e.preventDefault();
			e.stopPropagation();
		}} menu={[
			{name: __('Download'), click: () => {
				window.torrentSocket.emit('download', {torrent: props.torrent, savePath: null}, (added) => {
					if(props.onAdded)
						props.onAdded(added)
				})
			}, 
			className: 'downloadFullButton',
			icon: <svg style={{
				fill: 'black'
			}} viewBox="0 0 56 56">
				<g>
					<path d="M35.586,41.586L31,46.172V28c0-1.104-0.896-2-2-2s-2,0.896-2,2v18.172l-4.586-4.586c-0.781-0.781-2.047-0.781-2.828,0
                                    s-0.781,2.047,0,2.828l7.999,7.999c0.093,0.094,0.196,0.177,0.307,0.251c0.047,0.032,0.099,0.053,0.148,0.081
                                    c0.065,0.036,0.127,0.075,0.196,0.103c0.065,0.027,0.133,0.042,0.2,0.062c0.058,0.017,0.113,0.04,0.173,0.051
                                    C28.738,52.986,28.869,53,29,53s0.262-0.014,0.392-0.04c0.06-0.012,0.115-0.034,0.173-0.051c0.067-0.02,0.135-0.035,0.2-0.062
                                    c0.069-0.028,0.131-0.067,0.196-0.103c0.05-0.027,0.101-0.049,0.148-0.081c0.11-0.074,0.213-0.157,0.307-0.251l7.999-7.999
                                    c0.781-0.781,0.781-2.047,0-2.828S36.367,40.805,35.586,41.586z"/>
					<path d="M47.835,18.986c-0.137-0.019-2.457-0.335-4.684,0.002C43.1,18.996,43.049,19,42.999,19c-0.486,0-0.912-0.354-0.987-0.85
                                    c-0.083-0.546,0.292-1.056,0.838-1.139c1.531-0.233,3.062-0.196,4.083-0.124C46.262,9.135,39.83,3,32.085,3
                                    C27.388,3,22.667,5.379,19.8,9.129C21.754,10.781,23,13.246,23,16c0,0.553-0.447,1-1,1s-1-0.447-1-1
                                    c0-2.462-1.281-4.627-3.209-5.876c-0.227-0.147-0.462-0.277-0.702-0.396c-0.069-0.034-0.139-0.069-0.21-0.101
                                    c-0.272-0.124-0.55-0.234-0.835-0.321c-0.035-0.01-0.071-0.017-0.106-0.027c-0.259-0.075-0.522-0.132-0.789-0.177
                                    c-0.078-0.013-0.155-0.025-0.233-0.036C14.614,9.027,14.309,9,14,9c-3.859,0-7,3.141-7,7c0,0.082,0.006,0.163,0.012,0.244
                                    l0.012,0.21l-0.009,0.16C7.008,16.744,7,16.873,7,17v0.63l-0.567,0.271C2.705,19.688,0,24,0,28.154C0,34.135,4.865,39,10.845,39H25
                                    V28c0-2.209,1.791-4,4-4s4,1.791,4,4v11h2.353c0.059,0,0.116-0.005,0.174-0.009l0.198-0.011l0.271,0.011
                                    C36.053,38.995,36.11,39,36.169,39h9.803C51.501,39,56,34.501,56,28.972C56,24.161,52.49,19.872,47.835,18.986z"/>
				</g>
			</svg>
			},
			{name: __('Download to') + '...', click: async () => {
				if(dialog)
				{
					// Path using in testing
					let testPath = window.downloadFolderTest;
					if(testPath && testPath.length > 0) 
						testPath = [testPath];
					else
						testPath = null
					
					// Main path
					let path;

					if (!testPath)
					{
						path = (await dialog.showOpenDialog({
							properties: ['openDirectory']
						})).filePaths;
						if(!path || path.length < 1)
							return
					}
					else
					{
						path = testPath;
					}
					window.torrentSocket.emit('download', {torrent: props.torrent, savePath: path[0]}, (added) => {
						if(props.onAdded)
							props.onAdded(added)
					})  
				}
			},
			className: 'downloadDirectoryButton',
			icon: <svg viewBox="0 0 60 60">
				<g>
					<path d="M54.168,0H5.832C4.271,0,3,1.271,3,2.832v54.336C3,58.729,4.271,60,5.832,60h48.336C55.729,60,57,58.729,57,57.168V2.832
                                           C57,1.271,55.729,0,54.168,0z M5.832,2h48.336C54.627,2,55,2.373,55,2.832V29H5V2.832C5,2.373,5.373,2,5.832,2z M54.168,58H5.832
                                           C5.373,58,5,57.627,5,57.168V31h50v26.168C55,57.627,54.627,58,54.168,58z"/>
					<path d="M24.505,18h10.99C37.428,18,39,16.428,39,14.495V13c0-0.553-0.447-1-1-1s-1,0.447-1,1v1.495C37,15.325,36.325,16,35.495,16
                                           h-10.99C23.675,16,23,15.325,23,14.495V13c0-0.553-0.447-1-1-1s-1,0.447-1,1v1.495C21,16.428,22.572,18,24.505,18z"/>
					<path d="M38,41c-0.553,0-1,0.447-1,1v1.495C37,44.325,36.325,45,35.495,45h-10.99C23.675,45,23,44.325,23,43.495V42
                                           c0-0.553-0.447-1-1-1s-1,0.447-1,1v1.495C21,45.428,22.572,47,24.505,47h10.99C37.428,47,39,45.428,39,43.495V42
                                           C39,41.447,38.553,41,38,41z"/>
				</g>
			</svg>
                                   
			}
		]}>
			{props.children}
		</ContextMenu>
	)
}