const path = require("path");
const nodeExternals = require("webpack-node-externals");

module.exports = env => {
  if(env && env.test)
    env = 'test'
  else if(env && env.production)
    env = 'production'
  return {
    mode: env == 'test' ? 'production' : (env || 'development'),
    target: "node",
    node: {
      __dirname: false,
      __filename: false
    },
    externals: [nodeExternals()],
    resolve: {
      alias: {
        env: path.resolve(__dirname, `../config/env_${env}.json`)
      }
    },
    devtool: "source-map",
    module: {
      rules: [
        {
          test: /\.js$/,
          exclude: /node_modules/,
          use: ["babel-loader"]
        },
        {
          test: /\.css$/,
          use: ["style-loader", "css-loader"]
        },
        {
          test: /\.(?:ico|gif|png|jpg|jpeg|webp)$/,
          use: ['url-loader']
        }
      ]
    },
    plugins: [
    ]
  };
};
