# REST API

Formally, REST API stands for Representational State Transfer - Application Programming Interface. A REST API is a server that serves data to clients using endpoints provided by the programmer. The data could be served in the form of HTML, JSON, CSV, etc. but the concept remains the same. Every data driven service is implemented on top of this, and hence, huge firms including Facebook, Netflix, Youtube, Uber and others, use RESTful APIs for delivering their services.

### How to create a REST API
A REST API can be created using several technologies:
- Javascript: NodeJS
- Python: Django / Flask
- Java: Spring Boot
- C++: .NET
- PHP: Laveral
- Ruby: Ruby on rails

and several others. The point is, whatever language you know, you can build a RESTful API out of it.

In this repository (this directory of the repository to be exact), we will be creating a RESTful API in Javascript using NodeJS. NodeJS is beginner friendly and scalable, and is widely used in the industry.

### Pre-requisites
* [NodeJS](https://nodejs.org/en/download) should be installed.
* A friendly IDE, preferably [VS Code](https://code.visualstudio.com/download).
* A very basic understanding of Javascript.

### Installation
Follow the steps below to install the app locally: 
* Fork [this](https://github.com/DCRUSTODC/basic-development-projects) repository to create an instant copy of the code.
* Alternatively, you can download the source and set it up with Github Desktop.
* Open the `REST-JS` folder in IDE of your choice.
* Open the terminal and run: `npm install`
* Run `node app.js` in the terminal to start the server on the given port.
* Start reading the programs starting from `app.js` file and follow the commands thereafter.

### Documentation
A basic setup has been initialized in the repository beforehand, check out the [Introduction to Node.js](https://nodejs.dev/en/learn/) page for a quick overview of the technology behind. You can improve it by opening pull requests to the repository.

### Contributing
The main purpose of this repository is to evolve the culture of open source development in our community, making the participants comfortable with technologies like Git and Github, so that students could start their journey into open source as well as learning a new technology at the same time. We are grateful to the community for continuous improvements and collaboration.

You can always ask your doubts in the community group.

### Good First Issues
To help you get your feet wet and get you familiar with our contribution process, we have a list of [good first issues](https://github.com/DCRUSTODC/basic-development-projects/labels/good%20first%20issue) that contain bugs with a relatively limited scope. This is a great place to get started <3.
