# -*- coding: utf-8 -*-
"""movieRe.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1ILWLzUVoP5yuHwsI5Z6P2S_RSCfMfQWj
"""

import numpy as np
import pandas as pd

movies = pd.read_csv('tmdb_5000_movies.csv')
credits = pd.read_csv('tmdb_5000_credits.csv')

movies.head()

credits.head()

movies.shape

credits.shape

movies = movies.merge(credits,on='title')

movies.head(1)

movies = movies[['id','title','overview','genres','keywords','cast','crew']]

movies.head()

movies.isnull().sum()

movies.dropna(inplace = True)

movies.duplicated().sum()

movies.iloc[0].genres

import ast
def convert(obj):
  l=[]
  for i in ast.literal_eval(obj):
    l.append(i['name'])
  return l



convert('[{"id": 28, "name": "Action"}, {"id": 12, "name": "Adventure"}, {"id": 14, "name": "Fantasy"}, {"id": 878, "name": "Science Fiction"}]')

movies['genres']=movies['genres'].apply(convert)

movies.head()

movies['keywords']=movies['keywords'].apply(convert)

movies.head()

movies['cast'][0]

def convert3(obj):
  l=[]
  counter = 0
  for i in ast.literal_eval(obj):
    if counter!=3:
      l.append(i['name'])
      counter+=1
    else:
      break
  return l

movies['cast']=movies['cast'].apply(convert3)

movies.head()

movies['crew'][0]

def fetch_director(obj):
  l=[]
  for i in ast.literal_eval(obj):
    if i['job']=='Director':
      l.append(i['name'])
      break
  return l

movies['crew']=movies['crew'].apply(fetch_director)

movies.head()

movies['overview']=movies['overview'].apply(lambda x:x.split())

movies.head()

movies['genres']=movies['genres'].apply(lambda x:[i.replace(" ","") for i in x])
movies['keywords']=movies['keywords'].apply(lambda x:[i.replace(" ","") for i in x])
movies['cast']=movies['cast'].apply(lambda x:[i.replace(" ","") for i in x])
movies['crew']=movies['crew'].apply(lambda x:[i.replace(" ","") for i in x])

movies.head()

movies['tags']= movies['overview'] + movies['genres'] + movies['cast']+ movies['crew']+movies['keywords']

movies.head()

new_df = movies[['id','title','tags']]

import nltk

!pip install nltk

from nltk.stem.porter import PorterStemmer
ps = PorterStemmer()

def stem(text):
  y =[]
  for i in text.split():
    y.append(ps.stem(i))

  return " ".join(y)

new_df.head()

new_df['tags']= new_df['tags'].apply(lambda x:" ".join(x))

new_df['tags']=new_df['tags'].apply(stem)

new_df.head()

new_df['tags'][0]

new_df['tags']= new_df['tags'].apply(lambda x:x.lower())

"""TEXT VECTORISATION"""

from sklearn.feature_extraction.text import CountVectorizer
cv = CountVectorizer(max_features=5000,stop_words='english')

vectors = cv.fit_transform(new_df['tags']).toarray()

cv.fit_transform(new_df['tags']).toarray().shape

vectors[0]

"""Stemming"""

from sklearn.metrics.pairwise import cosine_similarity

"""cosine similarity"""

similarity=cosine_similarity(vectors)

def recommend(movie):
    movie_index = new_df[new_df['title'] == movie].index[0]
    distances = similarity[movie_index]
    movies_list=sorted(list(enumerate(distances)),reverse=True,key = lambda x: x[1])[1:6]
    for i in movies_list:
      print(new_df.iloc[i[0]].title)



recommend('Gandhi')

import pickle

pickle.dump(new_df.to_dict(),open('moviesdict.pkl','wb'))

pickle.dump(similarity,open('similarity.pkl','wb'))