# Assemblyline contributing guide

This guide covers the basics of how to contribute to the Assemblyline project.

Python code should follow the PEP8 guidelines defined here: [PEP8 Guidelines](https://www.python.org/dev/peps/pep-0008/).

## Tell us want you want to build/fix
Before you start coding anything you should connect with the Assemblyline community via the [Assemblyline Discord server](https://discord.gg/GUAy9wErNu) and/or the [central Assemblyline GitHub project](https://github.com/CybercentreCanada/assemblyline/issues) to make sure no one else is working on the same thing and that whatever you are going to build still fits with the vision of the system.

## Git workflow

- Clone the repo to your own account
- Checkout and pull the latest commits from the master branch
- Make a branch
- Work in any way you like and make sure your changes actually work
- When you're satisfied with your changes, create a pull requests to the main assemblyline repo

#### Transfer your service repo
If you've worked on a new service that you want to be included in the default service selection you'll have to transfer the repo into our control.

#### You are not allowed to merge:

Even if you try to merge in your pull request, you will be denied. Only a few people in our team are allowed to merge code into our repositories.

We check for new pull requests every day and will merge them in once they have been approved by someone in our team.
