# Awesome Open AI Sora

Sora is an AI model introduced by OpenAI that can create realistic and imaginative scenes from text instructions. Sora can instantaneously generate sophisticated 60-second-long videos featuring highly detailed scenes, complex camera motion, and multiple characters with vibrant emotions. The tool is not yet publicly available.

Note: as Open AI Sora is still in its early stages, the awesome list will be updated regularly to include new resources.

## Table of Contents

- [GitHub projects](#github-projects)
- [Articles and Blogs](#articles-and-blogs)
- [Online Courses](#online-courses)
- [Books](#books)
- [Research Papers](#research-papers)
- [Videos](#videos)
- [Tools and Software](#tools-and-software)
- [Conferences and Events](#conferences-and-events)
- [Podcasts](#podcasts)

## GitHub projects

* [Open-Sora-Plan](https://github.com/PKU-YuanGroup/Open-Sora-Plan) 🌟🌟🌟🌟🌟: This project aims to reproduce Sora (Open AI T2V model), with a hope for contribution from the open-source community.
* [open-ai-sora](https://github.com/zanekwok/open-ai-sora) 🌟🌟🌟: Sora is an AI model introduced by OPENAI capable of generating vivid and imaginative scenes based on textual commands. Find its applications in virtual reality and film production. :star::star:
* [Awesome-OpenAI-Sora-Videos](https://github.com/vincent-hub/Awesome-OpenAI-Sora-Videos)🌟🌟: A collection of the latest and most exciting videos generated by OpenAI's Sora. Check out the official Sora AI chat portal to learn more. :star::star:
* [SwiftSora](https://github.com/jasonwang178/SwiftSora) 🌟: A full-stack video generator built with Nuxt, Vue 3, and Tailwind CSS, centered around the OpenAI Sora API. Get started with this leading open-source project. :star::star:
* [sora-open-ai](https://github.com/dimondevceo/sora-open-ai) 🌟: Explore the potential of Sora, an AI model introduced by OpenAI known for generating vivid and imaginative scenes based on textual commands. :star:
- [Kling-AI-WebUI](https://github.com/ai-aigc-studio/Kling-AI-Webui) : Kling AI is another revolutionary text-to-video model similar to Sora. Kling AI WebUI is an open-source project that integrates the Kling AI Video Generation Model.

## Articles and Blogs

- [Sora OpenAI: The AI Model That Generates Mind-Blowing Videos](https://medium.com/@iamsaro1996/sora-openai-the-ai-model-that-generates-mind-blowing-videos-from-text-8f2ceda8d900) 🎥: An article discussing Sora, OpenAI's AI model that generates impressive videos from text instructions. It covers the various genres and themes it can handle, such as fantasy, sci-fi, horror, and more.
- [How OpenAI's Sora is Changing the Game: An Insight into Its Core Technologies](https://towardsdatascience.com/how-openais-sora-is-changing-the-game-an-insight-into-its-core-technologies-bd1ad17170df): This article provides an insight into OpenAI's Sora, a project that amazed the world with its ChatGPT announcement in 2022. It explores Sora's core technologies and highlights its state-of-the-art capabilities.
- [How to use OpenAI Sora?](https://medium.com/@ecommerce_plan/how-to-use-openai-sora-41218d9d6142) ✏️: A tutorial on how to utilize OpenAI's latest project, Sora. It explains how to generate mind-blowing videos based on simple text prompts using this powerful text-to-video model.
- [OpenAI SORA: The Next Frontier in AI Innovation](https://medium.com/@mvbnsrinivas/openai-sora-the-next-frontier-in-ai-innovation-55abf9afcfed) 🌌: An article delving into the essence of OpenAI SORA and exploring its capabilities and applications. It emphasizes Sora's potential for broader and more impactful use of AI technology.
- [How Sora (actually) works](https://medium.com/@mikeyoung_97230/how-sora-actually-works-23da050ef3f2) 📺🧠: This article from OpenAI introduces Sora, a large-scale video generation model with new capabilities for simulating basic human actions. It aims to dispel disinformation about this influential video model.
- [OpenAI Launches AI Text-to-Video Generator Sora](https://www.infoq.com/news/2024/02/openai-sora-video-generator/) 🚀 : InfoQ covers the launch of Sora, OpenAI's generative AI model that creates videos from textual prompts. It highlights Sora's ability to create photorealistic videos up to 60 seconds long, leveraging its understanding of the real world.
- [OpenAI Red Teaming Network](https://openai.com/blog/red-teaming-network): OpenAI invites domain experts interested in improving the safety of their models to join the Red Teaming Network effort.
- [SORA from OpenAI transcends conventional limits](https://medium.com/@adeshbhatt/sora-from-openai-transcends-conventional-limits-b4c7bd175dbc): OpenAI introduces 'Sora,' an AI tool capable of generating lifelike 60-second videos solely from textual instructions.
- [OpenAI Sora | Medium](https://medium.com/@christianray.drapete/openai-sora-understanding-access-and-potential-costs-e6bca85e24be): Explore the potential and access costs of OpenAI's Sora, a tool that allows vibrant, hyper-realistic videos to be generated simply by describing them with words.
- [Disrupting malicious uses of AI by state-affiliated threat actors](https://openai.com/blog/disrupting-malicious-uses-of-ai-by-state-affiliated-threat-actors): OpenAI terminates accounts associated with state-affiliated threat actors seeking to exploit their models for malicious cybersecurity tasks.
- [SORA: Unbelievably New Text To Video AI Model By OpenAI](https://medium.com/@furkangozukara/sora-unbelieve-new-text-to-video-ai-model-by-openai-37-demo-videos-still-cant-believe-real-a669b101efb7): Learn about Sora, OpenAI's latest AI model that can create realistic and imaginative scenes from text instructions. Includes a link to demo videos.
- [Sora: A Review on Background, Technology, Limitations, and Future Directions](https://arxiv.org/abs/2402.17177): A comprehensive review of OpenAI's text-to-video generative AI model, Sora. This paper covers its background, related technologies, applications, challenges, and future prospects.
- [OpenAI and Elon Musk](https://openai.com/blog/openai-elon-musk): OpenAI's dedication to fulfilling its mission, including its connection to Elon Musk.

## Online Courses

- [Top Artificial Intelligence (AI) Courses Online - Updated [July 2024]](https://www.udemy.com/topic/artificial-intelligence/) : Learn AI with an artificial intelligence course from experienced instructors on Udemy, and enhance your computer science skills to further your career.
- [AI-Videos: Be a Filmmaker with Artificial Intelligence | Udemy](https://www.udemy.com/course/ai-videos-create-recordings-with-artificial-intelligence/) : Create video recordings with various Artificial Intelligence tools such as SORA by OpenAI, Heygen, RunwayML, and more for social media.

## Books

- [Sora OpenAI Complete Manual for Making Video With ChatGPT](https://www.amazon.com/OpenAI-Complete-Manual-Making-ChatGPT/dp/B0CW2KRZYK): A comprehensive guide on using Sora OpenAI to create videos with ChatGPT, including 100 advanced prompts ready to use.
- [SORA OPENAI: Unveiling the AI Storyteller of Tomorrow: All You Need to Know (AI, TECH, INNOVATION UPDATES Book 4)](https://www.amazon.com/SORA-OPENAI-Unveiling-Storyteller-INNOVATION-ebook/dp/B0CVV15T5S): This book provides a comprehensive understanding of Sora, the AI model introduced by OpenAI, and explores its potential in storytelling.
- [Sora OpenAI & ChatGPT: Master Video Creation with 100 Ready-to-Use Prompts](https://www.amazon.com/Sora-OpenAI-ChatGPT-Ready-Use-ebook/dp/B0CW99MRLQ): Learn how to leverage Sora and ChatGPT to master video creation with a wide range of ready-to-use prompts.
- [SORA UNVEILED: NAVIGATING THE AI STORYTELLING FRONTIER: Demystifying the Future of Creativity with OpenAI's Text-to-Video Marvel and All You Need to Know](https://www.amazon.com/SORA-UNVEILED-STORYTELLING-Text-Video-ebook/dp/B0CW1N9T2H): Dive into the AI storytelling frontier and demystify the future of creativity with OpenAI's text-to-video marvel, Sora.
- [Video Gen AI: A Comprehensive Guide to Video Generation with Artificial Intelligence (AI Explorer Series)](https://www.amazon.com/Video-Gen-Comprehensive-Generation-Intelligence-ebook/dp/B0CW1DWT49): Discover the foundations of video generation using artificial intelligence and explore the exciting possibilities it offers.
- [What's New in AI: Multimodal AI with Purvanshi Mehta](https://www.oreilly.com/live-events/whats-new-in-ai-multimodal-ai-with-purvanshi-mehta/0642572003472/): This book explores the field of multimodal AI, including specialized models like OpenAI's upcoming Sora, which generates videos from text instructions.

## Research Papers

- [Sora: A Review on Background, Technology, Limitations, and Applications](https://arxiv.org/abs/2402.17177) : This paper provides a comprehensive review of Sora, a text-to-video generative AI model released by OpenAI. It explores the model's background, related technologies, applications, challenges, and future directions of text-to-video AI models.
- [Generate Impressive Videos with Text Instructions: A Review of OpenAI Sora, Stable Diffusion, and Comparable Models](https://www.researchgate.net/publication/378310049_Generate_Impressive_Videos_with_Text_Instructions_A_Review_of_OpenAI_Sora_Stable_Diffusion_Lumiere_and_Comparable_Models) : This paper evaluates prominent models such as OpenAI Sora, Stable Diffusion, and Lumiere for their efficacy and architectural intricacies in generating videos from textual input.
- [Toward Solipsism: The Emergence of Sora and Other Video Generation AIs in Audiovisual Creation](https://www.researchgate.net/publication/378260362_Toward_Solipsism_The_Emergence_of_Sora_and_Other_Video_Generation_AIs_in_Audiovisual_Creation) : Examining the era of artificial intelligence, this paper discusses the creation of powerful tools like Sora that have fascinating implications in audiovisual creation.
- [Sora OpenAI's Prelude: Social Media Perspectives on Sora OpenAI](https://arxiv.org/abs/2403.14665) : This study investigates the public's perception of Sora OpenAI, a pioneering Gen-AI video generation tool, through social media discussions. It explores envisioned applications as well as concerns related to Sora's integration, while also highlighting positive shifts in content creation and addressing potential challenges.
- [An Overview of OpenAI's Sora and Its Potential for Physics Engine-Free Games and Virtual Reality](https://www.researchgate.net/publication/378776248_An_Overview_of_OpenAI's_Sora_and_Its_Potential_for_Physics_Engine_Free_Games_and_Virtual_Reality) : This paper provides an overview of Sora, OpenAI's text-to-video model, highlighting its exceptional understanding of the physical world and its potential for generating content in physics engine-free games and virtual reality.
- [Concerns with OpenAI's Sora in Medicine](https://pubmed.ncbi.nlm.nih.gov/38558354/) : This paper explores the concerns surrounding the use of OpenAI's Sora in medicine, specifically related to artificial video generation and its impact on patient education.
- [OpenAI's Sora in ophthalmology: revolutionary generative AI in eye health](https://www.researchgate.net/publication/380277277_OpenAI's_Sora_in_ophthalmology_revolutionary_generative_AI_in_eye_health): This paper highlights the potential of OpenAI's Sora in transforming ophthalmology with its revolutionary generative AI capabilities for eye health.
- [Sora is Incredible and Scary": Emerging Governance Challenges of Text-to-Video Generative AI Models](https://www.researchgate.net/publication/379809763_Sora_is_Incredible_and_Scary_Emerging_Governance_Challenges_of_Text-to-Video_Generative_AI_Models): This paper discusses the emerging governance challenges posed by text-to-video generative AI models like Sora OpenAI and their potential to disrupt various industries.
- [Mora: Enabling Generalist Video Generation via A Multi-Agent](https://arxiv.org/html/2403.13248v1): Focusing on the text-to-video generative model introduced by OpenAI, Sora, this paper delves into its distinguishing features and its ability to convert text into sophisticated video scenes.

## Videos

- [Introducing Sora — OpenAI's text-to-video model - YouTube](https://www.youtube.com/watch?v=HK6y8DAPN_0) 🎥\
Feb 16, 2024 - Introducing Sora, our text-to-video model. Sora can create videos of up to 60 seconds featuring highly detailed scenes, complex camera motion, and multiple characters with vibrant emotions.
- [Open AI's New SORA Could Eliminate An Entire Industry Of Jobs - YouTube](https://www.youtube.com/watch?v=pIPIK77lZ_o) 🎥\
5 days ago - Let's take a closer look at how SORA and other ChatGPT-related technologies threaten the average person and what you can do about it.
- [6 Ways to Make Money With OpenAI SORA (when it comes out) - YouTube](https://www.youtube.com/watch?v=3-SpV8wpv4w) 💰🎥\
6 days ago - OpenAI SORA: the insane new AI Video Generation model. The release of SORA comes with huge new opportunities to make money with AI and start an...
- [OpenAI Sora to Apple Vision Pro Spatial Video to 3D Hologram - YouTube](https://www.youtube.com/watch?v=qQv6ysfLEjw) 🎥\
Feb 16, 2024 - Experience the mind-blowing world of AI-generated spatial video with OpenAI Sora on Apple Vision Pro! You'll feel like you're flying through...
- [How does OpenAI's Sora work? - YouTube](https://www.youtube.com/watch?v=fG3IE9dkyKY) 🎥\
Feb 18, 2024 - OpenAI presents Sora, a text-to-video model for generating high-quality video from text prompts. In this video, we explain a high-level...
- [What Marques Thinks About OpenAI's Sora - YouTube](https://www.youtube.com/watch?v=TXeuGDGXeuk) 🎥\
8 days ago - In this clip, everyone weighs in on OpenAI's new AI video generation tool Sora.
- [OpenAI unveils text-to-video tool Sora - YouTube](https://www.youtube.com/watch?v=SkCz4LqzNF4) 🎥\
Feb 15, 2024 - OpenAI unveiled a new tool called Sora that turns text into video. NBC News' Brian Cheung explains the impact this new technology could...
- [OpenAI's Sora: How to Spot AI-Generated Videos | WSJ - YouTube](https://www.youtube.com/watch?v=XllmgXBQUwA) 🎥\
Feb 23, 2024 - OpenAI just revealed Sora – an AI video generator that creates hyper-realistic scenes and animated worlds in moments.
- [OpenAI shocks the world yet again… Sora first look - YouTube](https://www.youtube.com/watch?v=tWP6z0hvw1M) 🎥\
Feb 16, 2024 - OpenAI just announced Sora, a state-of-the-art video generation AI model. Let's find out how Sora works and predict the ways it will change...
- [Ai Videos - Artist Reacts (OpenAI Sora) - YouTube](https://www.youtube.com/watch?v=mk4ZDUl3idw) 🎥\
Feb 16, 2024 - Source Dune Lore Clip (audio did not go through :( so here is the link!) hhttps://youtu.be/R0krUthYxF4?si=wUIroTmoCMN04vWY&t=237 OpenAI...
- [What a day in AI! (Sora, Gemini 1.5, V-JEPA, and lots of news ...](https://www.youtube.com/watch?v=2TlIZktYCf4) - A video discussing the role of modeling video sequences in achieving AGI and grounding AI models into reality.
- [Episode 4: Let's Talk About OpenAi's Sora Model - YouTube](https://www.youtube.com/watch?v=0qQVpaSTDBQ) - The Treehouse Show Podcast's episode focused on OpenAI's Sora model, which can create realistic and imaginative scenes from text instructions.
- [OpenAI Sora can Generate video for you - YouTube](https://www.youtube.com/shorts/BpC1jfGmnUU) - A short video showcasing OpenAI's Sora model's capability to generate videos.
- [Postdoc Workshop | Leadership Presence - YouTube](https://www.youtube.com/watch?v=eu0kPcqO1Qs) - A video discussing research at Baylor University and the transformative impact of OpenAI's Sora model on AI video production.
- [The REAL Preservation Sprint 12 demo - YouTube](https://m.youtube.com/watch?v=GulbCtwAiLY) - A demonstration video showcasing the innovative features of OpenAI's Sora model and its impact on AI video production.
- [ChatGPT-maker unveils scary AI text-to-video tool 'Sora' - video ...](https://www.dailymotion.com/video/x8ss4xm) - A video highlighting OpenAI's new AI text-to-video model, Sora, and addressing both the excitement and concerns surrounding its capabilities.
- [Meet the Moment with Logitech and Microsoft - YouTube](https://www.youtube.com/watch?v=aaWtufQYlRo) - A video showcasing the collaboration between Logitech and Microsoft and the significant impact of OpenAI's Sora model on AI video production.
- [LiteBox3D Desktop tutorial: Visualization modes - YouTube](https://www.youtube.com/watch?v=RWt2t_pbn-g) - An introduction to OpenAI's Sora model, a text-to-video model that instantly creates videos.

## Tools and Software

- [Sora: AI model that can create realistic and imaginative video](https://alternativeto.net/software/sora-1/about/) 💡: Sora is an OpenAI's text-to-video model capable of generating high-quality videos up to a minute long based on user prompts, maintaining visual quality and adherence to instructions.
- [SoraHub - Product Information, Latest Updates, and Reviews 2024](http://www.producthunt.com/products/sorahub) 💻: SoraHub is a platform that showcases the newest Sora-generated videos and prompts, providing a convenient way to explore cutting-edge AI creativity.
- [LTX Studio vs. Sora Comparison](https://sourceforge.net/software/compare/LTX-Studio-vs-Sora-OpenAI/) 🔍: This comparison chart allows you to evaluate and compare the features, pricing, and reviews of LTX Studio and Sora side-by-side to make an informed choice.
- [Premiere Pro to integrate generative AI capabilities through Firefly, OpenAI's Sora & more](https://alternativeto.net/news/2024/4/premiere-pro-to-integrate-generative-ai-capabilities-through-firefly-openai-s-sora-and-more/): Adobe Premiere Pro, a video editing software, plans to incorporate generative AI capabilities using Firefly and OpenAI's Sora.
- [Sorahub - Sora AI prompt sharing - Product Information, Latest](https://www.producthunt.com/products/sorahub-sora-ai-prompt-sharing): Sorahub is a website for OpenAI Sora prompt sharing and guides.

## Conferences and Events

- [AI Meetup (March): AI, GenAI, LLMs and ML](https://www.meetup.com/aittg-toronto/events/299299434/): Tech Talk: Sora, World Model, Generative AI, & Policy Optimization. Discussing the potential emergence of a world model from OpenAI Sora. RSVP [here](https://www.aicamp.ai/event/eventdetails/W2024030714).
- [Exploring OpenAI: A 6-Week Learning Series](https://www.eventbrite.com/e/exploring-openai-a-6-week-learning-series-tickets-845565407897?aff=erellivmlt): Join Jess Brock for a comprehensive 6-week learning series on OpenAI. Gain insights into various aspects of OpenAI technologies.
- [AI Movies and Films in Tokyo](https://www.meetup.com/tokyo-ai-movies-and-films/): Join Tokyo's first international community for creative enthusiasts and movie lovers. Explore the exciting potential of AI in the film industry.
- [Toronto AI/ML/Data Developers Group](https://www.meetup.com/aittg-toronto/): Join a community of AI enthusiasts in Toronto to learn and practice AI technologies, including Generative AI, LLMs, and Machine Learning.
- [AI Frontiers Forum | Meetup](https://www.meetup.com/aifrontiers/): We are a professional organization for AI practitioners in the Silicon Valley. We aim to bring together data scientists, engineers, and business people working in AI and big data area. We host seminars, interactive group meetings, and mentoring sessions. We provide an exchange platform for big data.
- [AI LA | Meetup](https://www.meetup.com/ai-la-meetup/): AI LA is a community of today's most curious minds focused on tomorrow’s most challenging problems. We explore the impacts artificial intelligence, machine learning, and other emerging technologies will have on humanity. We acknowledge that AI is influenced by both art and science, and that human concerns outweigh technological ones.
- [Innovations in AI | Meetup](https://www.meetup.com/innovations-in-ai/): Join us to talk about the latest innovations in AI! Our monthly meetups dive into cutting-edge technologies like Dalle-3, autonomous agents, GPT-5, and the E-acc movement. This isn't a networking event – we don't carry nametags or business cards. Just fun ideas, curiosity, and enthusiasm. We're here to learn and play with AI.

## Podcasts

- [Daily Artificial Intelligence News and Discussions: OpenAI's Stunning New Video Model SORA Shocks the AI World](https://podcasts.apple.com/ca/podcast/openais-stunning-new-video-model-sora-shocks-the-ai-world/id1680633614?i=1000645598170) - This podcast discusses the groundbreaking release of OpenAI's Sora, a video model that has amazed the AI community.
- [All-In with Chamath, Jason, Sacks & Friedberg: E166: Mind-blowing AI Video: OpenAI launches Sora + Is Biden too old? Tucker/Putin interview & more](https://podcasts.apple.com/us/podcast/e166-mind-blowing-ai-video-openai-launches-sora-is/id1502871393?i=1000645644386) - This episode covers the mind-blowing demonstrations of Sora by OpenAI and discusses other relevant AI topics like politics.
- [Marketing Against The Grain: OpenAI’s Sora Vs Google’s Gemini 1.5 Pro: Who Wins?](https://podcasts.apple.com/ph/podcast/openais-sora-vs-googles-gemini-1-5-pro-who-wins/id1616700934?i=1000645956893) - This podcast explores the competition between OpenAI's Sora and Google's Gemini 1.5, discussing their potential impacts on the AI industry.
- [AI Chat: ChatGPT & AI News, Artificial Intelligence, OpenAI, Machine Learning](https://podcasts.apple.com/us/podcast/ai-chat-chatgpt-ai-news-artificial-intelligence-openai/id1669990482) - This podcast delves into the world of ChatGPT, AI news, and OpenAI's Sora, exploring their significance in our daily lives.
- [Pure TokyoScope: 80: Sora OpenAI Takes Aim at Japan!](https://podcasts.apple.com/us/podcast/80-sora-openai-takes-aim-at-japan/id1625536360?i=1000646627163) - This episode focuses on OpenAI's Sora and its impact on Japan, analyzing the implications of this AI model.
- [AI Chat: ChatGPT & AI News, Artificial Intelligence, OpenAI, Machine Learning - [VIDEO] OpenAI Announces AI Video Generator Called Sora](https://podcasts.apple.com/sg/podcast/video-openai-announces-ai-video-generator-called-sora/id1669990482?i=1000645505637) - In this episode, the intricacies of OpenAI's Sora, a state-of-the-art AI video generator, are discussed, and its potential to reshape the media landscape is explored.
- [TechMagic with Cathy Hackl: Spatial Computing Headset Wars | OpenAI’s Sora & Reddit’s AI news](https://podcasts.apple.com/gb/podcast/spatial-computing-headset-wars-openais-sora-reddits/id1586989316?i=1000646269007) - This episode covers the battle between spatial computing headsets and talks about OpenAI's Sora along with Reddit's AI news, providing a glimpse into the future of amusement parks.
- [The AI Breakdown: Daily Artificial Intelligence News and Discussions](https://podcasts.apple.com/lk/podcast/the-ai-breakdown-daily-artificial-intelligence-news/id1680633614) - A daily news analysis show that covers various aspects of artificial intelligence, including the creative explosion driven by new technologies like OpenAI's Sora.
- [The Town with Matthew Belloni: Will AI Video Replace Hollywood?](https://podcasts.apple.com/us/podcast/will-ai-video-replace-hollywood/id1612131897?i=1000647378808) : Matt is joined by Ben Thompson, the founder of Stratechery, to discuss Open AI's new text-to-video model Sora and the ensuing Hollywood freakout.
- [AI Chat: ChatGPT & AI News, Artificial Intelligence, OpenAI, Machine Learning](https://open.spotify.com/show/0FMz3FsApINUKszziRKDKa) : AI Chat is a podcast that explores the world of ChatGPT and its impact on our daily lives. With discussions and interviews with leading experts, they delve into the latest advancements in language models and machine learning.
- [This Old Marketing: OpenAI, Google, Billy Joel and More AI Craziness](https://podcasts.apple.com/gb/podcast/openai-google-billy-joel-and-more-ai-craziness/id760760485?i=1000646542682) : This podcast discusses the recent developments in artificial intelligence, including OpenAI's launch of Sora, the text-to-video tool.
- [Latent Space: The AI Engineer Podcast — Practitioners talking LLMs](https://podcasts.apple.com/us/podcast/latent-space-the-ai-engineer-podcast-practitioners/id1674008350) : This podcast covers the top research trends in the field of AI, including OpenAI Sora, Google Gemini, and Groq Math.
- [E166: Mind-blowing AI Video: OpenAI launches Sora + Is Biden too](https://open.spotify.com/episode/3hSnWfuMS4TMsd1p7BTYyi) : This episode discusses various topics, including OpenAI's launch of Sora and the implications of Biden's cognitive decline.
- [Everyday AI Podcast – An AI and ChatGPT Podcast](https://podcasts.apple.com/be/podcast/everyday-ai-podcast-an-ai-and-chatgpt-podcast/id1683401861) : This podcast discusses various topics related to AI, including the dispersion of AI jobs across the U.S. and the Elon Musk vs. OpenAI lawsuit.

---

This initial version of the Awesome List was generated with the help of the [Awesome List Generator](https://github.com/alialsaeedi19/GPT-Awesome-List-Maker). It's an open-source Python package that uses the power of GPT models to automatically curate and generate starting points for resource lists related to a specific topic. 
