<?php

return [
    'home' => 'Home',
    'cgu' => 'CGU',
    'cgv' => 'CGV',
    'nolink' => 'No link or redirect',
    'general' => 'General',
    'package' => 'Package',
    'packages' => 'Packages',
    'games' => 'Games',
    'themes' => 'Themes',
    'alt' => [
        'logo' => 'Logo CMW',
    ],
    'source_code' => 'Source code',
    'header' => [
        'notification' => 'Notifications',
        'cms_ver' => 'CMS : Version',
        'cms_update' => 'A CMS update is available!',
        'update_to' => 'Please update to %version%',
        'package' => 'Package',
        'theme' => 'Theme',
        'all_is_fine' => "Everything's good",
        'is_up' => 'Your site is fully up to date',
    ],
    'condition' => [
        'title' => 'Terms and conditions',
        'cgv' => 'General condition of sale (CGV)',
        'cgu' => 'General conditions of use (CGU)',
        'activecgv' => 'Enable this terms',
        'activecgu' => 'Enable this terms',
        'content' => 'Content :',
        'updateby' => 'Updated by %author%',
        'on' => 'on %date%',
    ],
    'dashboard' => [
        'title' => 'Dashboard',
        'desc' => 'Welcome to your administration panel!',
        'total_member' => 'Total Members',
        'best_views' => 'Record of Visits',
        'numbers_views' => 'Visits',
        'daily_visits' => 'Daily visits',
        'monthly_visits' => 'Monthly Visits',
        'total_visits' => 'Total Visits',
        'welcome' => 'Welcome',
        'site_info' => 'Site Information',
        'name' => 'Name : %name%',
        'description' => 'Description : %description%',
        'edit' => 'Modify this information',
        'visits' => 'Visits',
        'registers' => 'Registers',
        'days' => 'Days',
        'weeks' => 'Weeks',
        'months' => 'Months',
        'alpha' => 'Please note that CraftMyWebsite2 is currently in alpha phase and is not yet complete. <br>Its use in a production environment is strongly discouraged. Key features may be missing or may not work as expected. <br><b>During this phase, complete system reinstalls may be required.</b> <br>We appreciate your understanding and patience while we work on CraftMyWebsite.',
        'updateWarning' => '<strong>Attention :</strong>The current version of your CMS is not the latest available. It is strongly recommended to <a class="link" href="updates/cms">update your CMS</a> to benefit from the latest security fixes as well as new features added.',
    ],
    'menus' => [
        'title' => 'Menus',
        'desc' => 'Edit main site menu',
        'delete_title' => 'Remove : %menu%',
        'delete_message' => 'This deletion is final.',
        'send_to' => 'Send to : %url%',
        'add_sub_menu' => 'Add sub menu to %menu%',
        'add' => [
            'sub_menu' => 'Add sub menu in',
            'name' => 'Name of the menu',
            'name_hint' => 'Votes',
            'targetBlank' => 'Open link in new tab',
            'choice' => 'Type of link',
            'package' => 'Package',
            'package_select' => 'Select the package',
            'custom' => 'Custom',
            'custom_hint' => 'https://store.monsite.fr',
            'allowedGroups' => 'Allow some groups to access this menu',
            'group_select' => 'Select roles',
            'toaster' => [
                'success' => 'Menu added with success',
            ],
        ],
        'edit' => [
            'name' => 'Edit menu',
        ],
    ],
    'editor' => [
        'title' => 'Configuration Editor',
        'desc' => "Personnaliser l'éditeur de pages",
        'style' => 'Style du syntax highlighter',
        'preview' => 'Vous pouvez prévisualiser le rendu des styles <a href="https://highlightjs.org/static/demo/" target="_blank">ici</a>',
    ],
    'config' => [
        'head' => 'Site Settings',
        'title' => 'Configuration',
        'desc' => 'Configure your CMW website !',
        'favicon' => 'Edit your favicon',
        'favicon_tips' => 'CraftMyWebsite allow only <a href="https://www.icoconverter.com" target="_blank">.ico</a> for better performances.',
        'alert_img' => 'Do CTRL + F5 display for your new icon',
        "alert_img_no_ico" => "Your image must be in .ico format",
        'dateFormat' => 'Date formatting',
        'dateFormatTooltip' => 'You can customise the way you display the dates',
        'custom' => '-- Customize-moi --',
    ],
    'Lang' => [
        'title' => 'Languages',
        'desc' => 'Configure the languages of your CMW website !',
        'change' => 'Change the website locale',
    ],
    'website' => [
        'name' => 'Website name',
        'description' => 'Website description',
    ],
    'minecraft' => [
        'ip' => 'IP Address of your server',
        'register' => 'Allow only Minecraft PREMIUM accounts to register on you website',
    ],
    'database' => [
        'error' => 'Database error: ',
    ],
    'toaster' => [
        'success' => 'Success',
        'warning' => 'Warning',
        'error' => 'Error',
        'internalError' => 'Internal error',
        'config' => [
            'success' => 'Configuration edit with success !',
        ],
        'mail' => [
            'test' => 'Mail send to %mail%',
        ],
        'Theme' => [
            'regenerate' => 'Theme configuration regenerate',
            'installed' => '%theme% just installed and activated.',
            'reset' => 'Theme configuration reset',
            'updateBeforeInstall' => 'Please update CMS before installing this theme!',
            'updateBeforeUpdate' => 'Please update the CMS before updating your themes!',
            'unableUpdate' => 'Unable to install this theme! : ',
            'unableDeleteFolder' => 'Unable to remove folder : ',
        ],
        'package' => [
            'updateBeforeInstall' => 'Please update CMS before installing this package!',
            'updateBeforeUpdate' => 'Please update the CMS before updating your packages!',
        ],
        'db' => [
            'config' => [
                'success' => 'Good configuration',
                'error' => 'Configuration error',
                'alreadyInstalled' => 'Data base already installed !',
            ],
            'missing_inputs' => 'Please fill all inputs !',
        ],
        'security' => [
            'healthReport' => [
                'copied' => 'Content copied !',
                'delete' => 'Health Reports removed',
            ],
        ],
    ],
    'datatables' => [
        'list' => [
            'processing' => 'Treatment in progress...',
            'search' => 'Search&nbsp;: ',
            'lenghtmenu' => 'Showing _MENU_ entries',
            'setlimit' => 'Showing _START_ to _END_ of _TOTAL_ entries',
            'info' => 'Showing _START_ to _END_ of _TOTAL_ entries',
            'info_vanilla' => 'Affichage des &eacute;lements {start} &agrave; {end} sur {rows} &eacute;l&eacute;ments',
            'info_empty' => 'Showing 0 to 0 of 0 entries',
            'info_filtered' => '(Filtered of _MAX_ entries)',
            'info_postfix' => '',
            'loadingrecords' => 'Loading in progress...',
            'zerorecords' => 'No data available in the table',
            'emptytable' => 'No data available in the table',
            'first' => 'First',
            'previous' => 'Previous',
            'next' => 'Next',
            'last' => 'Last',
            'sort' => [
                'ascending' => ': activate to sort the column in ascending order',
                'descending' => ': activate to sort the column in descending order',
            ],
        ],
    ],
    'theme' => [
        'myThemes' => 'My themes',
        'market' => 'Market',
        'details' => 'Details',
        'install' => 'Install',
        'notVerified' => 'Not verified by CMW.',
        'active' => 'Active theme',
        'configure' => 'Configure',
        'reset' => 'Reset',
        'reinstall' => 'Reinstall',
        'description' => 'Description : ',
        'update' => 'An update is available !',
        'descriptionManualInstall' => 'This theme is installed manually, it is not registered with CraftMyWebsite.<br>Use this theme knowingly.<br>If you develop this theme to then publish it on the Market of CraftMyWebsite this message is not important.',
        'descriptionIsSampler' => 'Sampler is the default theme provided with CraftMyWebsite.',
        'author' => 'Author : ',
        'demo' => 'Demo',
        'activate' => 'Enable',
        'downloads' => 'Downloads : ',
        'themeVersion' => 'Version of the theme : ',
        "localThemeVersion" => "Installed version theme : ",
        'CMWVersion' => 'Recommended CMW version : ',
        'close' => 'Close',
        'appearance' => 'Appearance of ',
        'verification' => 'Verification',
        'verificationText' => 'Warning, this will reset all default settings of your theme, are you sure you want to continue ?',
        'config' => [
            'title' => 'Manage',
            'description' => 'Manage the themes of your website',
            'select' => 'Select your Theme',
            'list' => [
                'title' => 'Our officials themes',
                'info' => 'You can download all this themes on our marketplace',
                'name' => 'Name',
                'version' => 'Version',
                'cmw_version' => 'Version CMW',
                'downloads' => 'Downloads',
                'download' => 'Download',
            ],
            'regen_config' => 'Re-generate Theme config',
        ],
        'manage' => [
            'title' => 'Manage your Theme <b>%Theme%</b>',
            'description' => 'Manage your Theme to have a Theme that suits you ! ',
            'theme_need_update' => 'You are using <b>%version%</b> version, please update to <b>%target%</b> !',
        ],
        'toasters' => [
            'update' => [
                'success' => 'Theme %theme% update with success',
            ],
        ],
    ],
    'Package' => [
        'title' => 'Packages',
        'my_packages' => 'My packages',
        'delete' => 'Delete',
        'install' => 'Install',
        'update' => 'Update',
        'demo' => 'Demo',
        'close' => 'Close',
        'removeTitle' => 'Do you want to delete %package% ?',
        'removeText' => 'Removal of this package is permanent.<br>Do you want to continue ?',
        'description' => 'Description: ',
        'descriptionNotAvailable' => 'This package is installed manually, it is not registered with CraftMyWebsite.<br>Use this package wisely.<br>If you develop this package and then publish it on CraftMyWebsite Market, disregard this message.',
        'details' => 'Details',
        'author' => 'Author: ',
        'downloads' => 'Downloads: ',
        'version' => 'Package version: ',
        'versionCMW' => 'Recommended CMW version: ',
        "localPackageVersion" => "Installed package version : ",
        'notVerified' => 'Not verified by CMW.',
        'updateAvailable' => 'An update is available !',
        'desc' => 'Manage your packages',
        'myPackages' => 'My Packages',
        'market' => 'Market',
        'toasters' => [
            'install' => [
                'success' => 'Package %package% install with success !',
            ],
            'delete' => [
                'success' => 'Package %package% delete with success',
                'error' => 'Unable to delete package %package%',
            ],
            'update' => [
                'success' => 'Package %package% update with success !',
            ],
        ],
        'versionDistant' => 'Last version',
    ],
    'mail' => [
        'config' => [
            'title' => 'Manage your mails',
            'description' => 'Manage your mails settings',
            'enableSMTP' => 'Enable SMTP',
            'senderMail' => 'Email sender',
            'replyMail' => 'Email reply',
            'serverSMTP' => 'SMTP address',
            'userSMTP' => 'SMTP user',
            'passwordSMTP' => 'Password',
            'portSMTP' => 'Port SMTP',
            'protocol' => 'Sending protocol',
            'footer' => 'Mails footer',
            'formatting' => 'Formatting',
            'name' => 'Display name :',
            'placeholder' => 'Name of your site',
            'test' => [
                'btn' => 'Try your configuration',
                'title' => 'Try now your configuration',
                'warning' => 'Remember to save your configuration before starting the test !',
                'description' => 'You can test your configuration by sending an email to your email address.',
                'receiverMail' => 'Recipient address',
                'receiverMailPlaceholder' => 'Enter your mail',
            ],
        ],
    ],
    'downloads' => [
        'errors' => [
            'internalError' => 'Internal error with resource %name% - %version%',
        ],
    ],
    'updates' => [
        'title' => 'Update your website',
        'description' => 'Update your CraftMyWebsite website',
        'pageTitle' => 'CMS updates',
        'updateButton' => 'Update',
        'warningUpdate' => 'Attention ! You are not using the latest version of the CMS, please update it now.',
        'updateTo' => 'Please update to',
        'isUp' => 'Your CMS is up to date!',
        'availableFrom' => 'Available from:',
        'lastNote' => 'Release note:',
        'previousVersion' => 'Previous versions',
        'publishAt' => 'Published on',
        'errors' => [
            'download' => 'Unable to download the latest CMS version.',
            'nullFileUpdate' => "This version doesn't contain any update file.",
            'prepareArchive' => 'Unable to prepare archive for update the CMS.',
            'deletedFiles' => 'Unable to delete old files.',
            'deleteFile' => 'Unable to delete file %file%',
            'sqlUpdate' => 'Unable to update your database.',
        ],
        'success' => 'Website update with success',
    ],
    'security' => [
        'title' => 'Security',
        'description' => 'Manage your website security',
        'no_captcha' => 'No captcha',
        'free_key' => 'Get your keys here for free :',
        'captcha' => [
            'title' => 'Manage your captcha',
            'type' => 'Captcha type',
            'invalid' => 'Invalid captcha'
        ],
        'healthReport' => [
            'title' => 'Health Report',
            'subtitle' => 'What is that ?',
            'content' => '<p>Our health report allows our support team to help you by sending as many
                    (non-sensitive) information about your site.</p>

                <p>
                    <b>Remember to delete your health reports once the support is over!
                        Otherwise, you expose your site to vulnerability.</b>
                </p>

                <p>
                    <i>It is <b>imperative</b> to send your Health Reports only to <b>the CraftMyWebsite team</b> if you are asked to do it.</i>
                </p>',
        ],
    ],
    'maintenance' => [
        'title' => 'Maintenance',
        'description' => 'Manage your website maintenance',
        'main_label' => 'Maintenance mode',
        'settings' => [
            'info' => 'Informations',
            'noEnd' => 'Specify an end date',
            'activated' => 'Enabled',
            'deactivated' => 'Disabled',
            'title' => 'Settings',
            'targetDateTitle' => 'Target date',
            'useMyCode' => 'Use my code',
            'loginRegister' => [
                'title' => 'Login / Registers',
                'type' => [
                    0 => 'All disabled',
                    1 => 'Enable logins / registers',
                    2 => 'Only enable logins',
                ],
            ],
            'maintenanceTitle' => [
                'label' => 'Title',
                'placeholder' => 'We are coming soon !',
            ],
            'maintenanceDescription' => [
                'label' => 'Description',
                'placeholder' => 'We are making some changes !',
            ],
            'toaster' => [
                'enabled' => 'Maintenance enabled',
                'disabled' => 'Maintenance disabled',
                'error' => 'Unable to update maintenance settings',
            ],
        ],
    ],
    'footer' => [
        'left' => '© 2014 - ' . date('Y') . ' CraftMyWebsite. All rights reserved.',
        'right' => "Thank you for using <a target='_blank' href='https://craftmywebsite.fr/'>CraftMyWebsite</a>.",
        'used' => 'You are using the version ',
        'upgrade' => 'Please update to ',
    ],
    'btn' => [
        'save' => 'Save',
        'delete' => 'Delete',
        'mass_delete' => 'Mass deletion',
        'delete_forever' => 'Delete forever',
        'close' => 'Close',
        'send' => 'Send',
        'add' => 'Add',
        'edit' => 'Edit',
        'action' => 'Action',
        'confirm' => 'Confirm',
        'next' => 'Next',
        'try' => 'Try',
        'continue' => 'Continue',
        'generate' => 'Generate',
        'enable' => 'Enable',
        'enabled' => 'Enabled',
        'disable' => 'Disable',
        'disabled' => 'Disabled',
        'saving' => 'Saving ...',
    ],
    'months' => [
        'list' => '["January","February","March","April","May","June","July","August","September","October","November","December"]',
        1 => 'January',
        2 => 'February',
        3 => 'March',
        4 => 'April',
        5 => 'May',
        6 => 'June',
        7 => 'July',
        8 => 'August',
        9 => 'September',
        10 => 'October',
        11 => 'November',
        12 => 'December',
    ],
    'week' => 'Week ',
    'errors' => [
        'requests' => [
            'required' => 'Missing input %key%',
            'empty' => 'Input %key% empty',
            'slug' => 'Invalide slug %key%',
            'minLength' => 'Input %key% need to have more than %min% characters',
            'maxLength' => 'Input %key% need to have max %max% characters',
            'betweenLength' => 'Input %key% need to have between %min% and %max% characters',
            'dateTime' => 'Input %key% need to be a validate format (%format%)',
            'getValue' => 'Missing value %key%',
            'type' => 'Invalide type for %key%',
        ],
        'editConfiguration' => 'Unable to edit configuration %config%',
        'upload' => [
            'image' => 'An error occur when uploading image.',
        ],
    ],
    'permissions' => [
        'dashboard' => 'Access to the administration panel',
        'settings' => [
            'title' => 'Settings',
            'website' => 'Site Settings',
            'maintenance' => 'Maintenance',
            'maintenance_bypass' => 'Bypass access',
            'mails' => 'SMTP and emails',
            'conditions' => 'General conditions',
            'security' => 'Security',
            'security_healthReport' => 'Generate a report',
        ],
        'notification' => [
            'notification' => 'View notifications',
            'read' => 'Marked as read',
            'settings' => 'Settings',
        ],
        'menu' => 'Menus',
        'update' => 'CORE Updates',
        'themes' => [
            'title' => 'Themes',
            'edit' => 'Edit active',
            'manage' => 'Manage facilities',
            'market' => 'Install from the market',
        ],
        'packages' => [
            'title' => 'Packages',
            'manage' => 'Manage facilities',
            'market' => 'Install from the market',
        ],
    ],
    'menu' => [
        'setting' => [
            'main' => 'Settings',
            'settings' => 'Site Settings',
            'maintenance' => 'Maintenance mode',
            'mail' => 'SMTP and mails',
            'cg' => 'General conditions',
            'security' => 'Security',
        ],
        'update' => 'CMW Updates',
        'updateMe' => 'CMW Updates <i style="color:#da3434;" class="ml-1 fa-solid fa-circle-exclamation"></i>',
        'themes' => [
            'main' => 'Themes',
            'edit' => 'Edit ',
            'installed' => 'Installed Themes',
            'market' => 'Browse the Market',
            'toasters' => [
                'update' => [
                    'success' => 'Theme %theme% update with success',
                ],
            ],
        ],
        'package' => [
            'main' => 'Packages',
            'installed' => 'Installed packages',
            'market' => 'Browse the Market',
        ],
        'user' => [
            'main' => 'Users',
            'settings' => 'Settings',
            'manage' => 'Manage',
            'roles' => 'Roles',
        ],
    ],
    'imageManager' => [
        'converter' => [
            'saving' => 'Error saving image.',
            'target' => 'Invalid target format. Original kept!',
            'conversion' => 'Conversion format not supported, Original kept!',
            'converting' => 'Error converting image. Original kept!',
        ],
        'error' => [
            'fileDefinition' => 'This extension is not supported!',
            'folderDontExist' => 'Target folder not found',
            'emptyFile' => 'No image sent!',
            'tooLarge' => 'Image too big!',
            'notAllowed' => 'Document type not allowed!',
            'move' => 'Unable to move image.',
            'download' => 'Unable to download image.',
            'createFolder' => 'Unable to create target folder, permission problem on Public/Uploads',
        ],
    ],
    'imageDropper' => [
        'fileDrop' => 'Drag & Drop your images here',
        'fileSize' => 'max allowed!',
        'fileFormat' => 'Format not allowed.',
    ],
    'themeNotFoundException' => [
        'title' => 'Error - Theme Not Found',
        'message1' => 'cannot be your active theme because we cannot find it!',
        'message2' => 'Please check that the theme is installed correctly or that its name is correct!',
        'path' => 'Path: ',
        'use_sampler' => 'Would you like to activate the <b>Sampler</b> theme?',
        'button' => 'Activate Sampler',
        'user' => [
            'title' => 'Configuration Issue!',
            'message1' => 'Please contact the site administrator.',
            'error' => '<b>Error:</b> Invalid theme name!',
        ],
    ],

];
