const icons = [
    'fa-solid fa-address-book',
    'fa-solid fa-address-card',
    'fa-solid fa-align-center',
    'fa-solid fa-align-justify',
    'fa-solid fa-align-left',
    'fa-solid fa-align-right',
    'fa-solid fa-anchor',
    'fa-solid fa-angle-double-down',
    'fa-solid fa-angle-double-left',
    'fa-solid fa-angle-double-right',
    'fa-solid fa-angle-double-up',
    'fa-solid fa-angle-down',
    'fa-solid fa-angle-left',
    'fa-solid fa-angle-right',
    'fa-solid fa-angle-up',
    'fa-solid fa-archive',
    'fa-solid fa-arrow-circle-down',
    'fa-solid fa-arrow-circle-left',
    'fa-solid fa-arrow-circle-right',
    'fa-solid fa-arrow-circle-up',
    'fa-solid fa-arrow-down',
    'fa-solid fa-arrow-left',
    'fa-solid fa-arrow-right',
    'fa-solid fa-arrow-up',
    'fa-solid fa-arrows-alt',
    'fa-solid fa-arrows-alt-h',
    'fa-solid fa-arrows-alt-v',
    'fa-solid fa-assistive-listening-systems',
    'fa-solid fa-asterisk',
    'fa-solid fa-at',
    'fa-solid fa-backward',
    'fa-solid fa-balance-scale',
    'fa-solid fa-ban',
    'fa-solid fa-barcode',
    'fa-solid fa-bars',
    'fa-solid fa-bath',
    'fa-solid fa-battery-empty',
    'fa-solid fa-battery-full',
    'fa-solid fa-battery-half',
    'fa-solid fa-battery-quarter',
    'fa-solid fa-battery-three-quarters',
    'fa-solid fa-bed',
    'fa-solid fa-beer',
    'fa-solid fa-bell',
    'fa-solid fa-bell-slash',
    'fa-solid fa-bicycle',
    'fa-solid fa-binoculars',
    'fa-solid fa-birthday-cake',
    'fa-solid fa-blind',
    'fa-solid fa-bold',
    'fa-solid fa-bolt',
    'fa-solid fa-bomb',
    'fa-solid fa-book',
    'fa-solid fa-bookmark',
    'fa-solid fa-braille',
    'fa-solid fa-briefcase',
    'fa-solid fa-bug',
    'fa-solid fa-building',
    'fa-solid fa-bullhorn',
    'fa-solid fa-bullseye',
    'fa-solid fa-bus',
    'fa-solid fa-calculator',
    'fa-solid fa-calendar',
    'fa-solid fa-calendar-alt',
    'fa-solid fa-calendar-check',
    'fa-solid fa-calendar-minus',
    'fa-solid fa-calendar-plus',
    'fa-solid fa-calendar-times',
    'fa-solid fa-camera',
    'fa-solid fa-camera-retro',
    'fa-solid fa-car',
    'fa-solid fa-caret-down',
    'fa-solid fa-caret-left',
    'fa-solid fa-caret-right',
    'fa-solid fa-caret-square-down',
    'fa-solid fa-caret-square-left',
    'fa-solid fa-caret-square-right',
    'fa-solid fa-caret-square-up',
    'fa-solid fa-caret-up',
    'fa-solid fa-cart-arrow-down',
    'fa-solid fa-cart-plus',
    'fa-solid fa-chalkboard',
    'fa-solid fa-chalkboard-teacher',
    'fa-solid fa-chart-area',
    'fa-solid fa-chart-bar',
    'fa-solid fa-chart-line',
    'fa-solid fa-chart-pie',
    'fa-solid fa-check',
    'fa-solid fa-check-circle',
    'fa-solid fa-check-square',
    'fa-solid fa-chess',
    'fa-solid fa-chess-bishop',
    'fa-solid fa-chess-board',
    'fa-solid fa-chess-king',
    'fa-solid fa-chess-knight',
    'fa-solid fa-chess-pawn',
    'fa-solid fa-chess-queen',
    'fa-solid fa-chess-rook',
    'fa-solid fa-chevron-circle-down',
    'fa-solid fa-chevron-circle-left',
    'fa-solid fa-chevron-circle-right',
    'fa-solid fa-chevron-circle-up',
    'fa-solid fa-chevron-down',
    'fa-solid fa-chevron-left',
    'fa-solid fa-chevron-right',
    'fa-solid fa-chevron-up',
    'fa-solid fa-child',
    'fa-solid fa-church',
    'fa-solid fa-circle',
    'fa-solid fa-circle-notch',
    'fa-solid fa-clipboard',
    'fa-solid fa-clipboard-check',
    'fa-solid fa-clipboard-list',
    'fa-solid fa-clock',
    'fa-solid fa-clone',
    'fa-solid fa-closed-captioning',
    'fa-solid fa-cloud',
    'fa-solid fa-cloud-download-alt',
    'fa-solid fa-cloud-upload-alt',
    'fa-solid fa-code',
    'fa-solid fa-code-branch',
    'fa-solid fa-coffee',
    'fa-solid fa-cog',
    'fa-solid fa-cogs',
    'fa-solid fa-columns',
    'fa-solid fa-comment',
    'fa-solid fa-comment-alt',
    'fa-solid fa-comment-dots',
    'fa-solid fa-comment-slash',
    'fa-solid fa-comments',
    'fa-solid fa-compass',
    'fa-solid fa-compress',
    'fa-solid fa-copy',
    'fa-solid fa-copyright',
    'fa-solid fa-couch',
    'fa-solid fa-credit-card',
    'fa-solid fa-crop',
    'fa-solid fa-crosshairs',
    'fa-solid fa-cube',
    'fa-solid fa-cubes',
    'fa-solid fa-cut',
    'fa-solid fa-database',
    'fa-solid fa-deaf',
    'fa-solid fa-desktop',
    'fa-solid fa-diagnoses',
    'fa-solid fa-dna',
    'fa-solid fa-dollar-sign',
    'fa-solid fa-dolly',
    'fa-solid fa-dolly-flatbed',
    'fa-solid fa-donate',
    'fa-solid fa-dot-circle',
    'fa-solid fa-dove',
    'fa-solid fa-download',
    'fa-solid fa-dumbbell',
    'fa-solid fa-edit',
    'fa-solid fa-eject',
    'fa-solid fa-ellipsis-h',
    'fa-solid fa-ellipsis-v',
    'fa-solid fa-envelope',
    'fa-solid fa-envelope-open',
    'fa-solid fa-envelope-square',
    'fa-solid fa-eraser',
    'fa-solid fa-euro-sign',
    'fa-solid fa-exchange-alt',
    'fa-solid fa-exclamation',
    'fa-solid fa-exclamation-circle',
    'fa-solid fa-exclamation-triangle',
    'fa-solid fa-expand',
    'fa-solid fa-expand-arrows-alt',
    'fa-solid fa-external-link-alt',
    'fa-solid fa-external-link-square-alt',
    'fa-solid fa-eye',
    'fa-solid fa-eye-dropper',
    'fa-solid fa-eye-slash',
    'fa-solid fa-fast-backward',
    'fa-solid fa-fast-forward',
    'fa-solid fa-fax',
    'fa-solid fa-female',
    'fa-solid fa-fighter-jet',
    'fa-solid fa-file',
    'fa-solid fa-file-alt',
    'fa-solid fa-file-archive',
    'fa-solid fa-file-audio',
    'fa-solid fa-file-code',
    'fa-solid fa-file-excel',
    'fa-solid fa-file-image',
    'fa-solid fa-file-medical',
    'fa-solid fa-file-medical-alt',
    'fa-solid fa-file-pdf',
    'fa-solid fa-file-powerpoint',
    'fa-solid fa-file-video',
    'fa-solid fa-file-word',
    'fa-solid fa-film',
    'fa-solid fa-filter',
    'fa-solid fa-fire',
    'fa-solid fa-fire-extinguisher',
    'fa-solid fa-first-aid',
    'fa-solid fa-flag',
    'fa-solid fa-flag-checkered',
    'fa-solid fa-flask',
    'fa-solid fa-folder',
    'fa-solid fa-folder-open',
    'fa-solid fa-font',
    'fa-solid fa-football-ball',
    'fa-solid fa-forward',
    'fa-solid fa-frog',
    'fa-solid fa-frown',
    'fa-solid fa-futbol',
    'fa-solid fa-gamepad',
    'fa-solid fa-gavel',
    'fa-solid fa-gem',
    'fa-solid fa-genderless',
    'fa-solid fa-gift',
    'fa-solid fa-glass-martini',
    'fa-solid fa-globe',
    'fa-solid fa-golf-ball',
    'fa-solid fa-graduation-cap',
    'fa-solid fa-h-square',
    'fa-solid fa-hashtag',
    'fa-solid fa-hdd',
    'fa-solid fa-heading',
    'fa-solid fa-headphones',
    'fa-solid fa-heart',
    'fa-solid fa-heartbeat',
    'fa-solid fa-history',
    'fa-solid fa-hockey-puck',
    'fa-solid fa-home',
    'fa-solid fa-hospital',
    'fa-solid fa-hospital-alt',
    'fa-solid fa-hospital-symbol',
    'fa-solid fa-hourglass',
    'fa-solid fa-hourglass-end',
    'fa-solid fa-hourglass-half',
    'fa-solid fa-hourglass-start',
    'fa-solid fa-i-cursor',
    'fa-solid fa-id-badge',
    'fa-solid fa-id-card',
    'fa-solid fa-id-card-alt',
    'fa-solid fa-image',
    'fa-solid fa-images',
    'fa-solid fa-inbox',
    'fa-solid fa-indent',
    'fa-solid fa-industry',
    'fa-solid fa-infinity',
    'fa-solid fa-info',
    'fa-solid fa-info-circle',
    'fa-solid fa-italic',
    'fa-solid fa-key',
    'fa-solid fa-keyboard',
    'fa-solid fa-language',
    'fa-solid fa-laptop',
    'fa-solid fa-leaf',
    'fa-solid fa-lemon',
    'fa-solid fa-level-down-alt',
    'fa-solid fa-level-up-alt',
    'fa-solid fa-life-ring',
    'fa-solid fa-lightbulb',
    'fa-solid fa-link',
    'fa-solid fa-lira-sign',
    'fa-solid fa-list',
    'fa-solid fa-list-alt',
    'fa-solid fa-list-ol',
    'fa-solid fa-list-ul',
    'fa-solid fa-location-arrow',
    'fa-solid fa-lock',
    'fa-solid fa-lock-open',
    'fa-solid fa-long-arrow-alt-down',
    'fa-solid fa-long-arrow-alt-left',
    'fa-solid fa-long-arrow-alt-right',
    'fa-solid fa-long-arrow-alt-up',
    'fa-solid fa-low-vision',
    'fa-solid fa-magic',
    'fa-solid fa-magnet',
    'fa-solid fa-male',
    'fa-solid fa-map',
    'fa-solid fa-map-marker',
    'fa-solid fa-map-marker-alt',
    'fa-solid fa-map-pin',
    'fa-solid fa-map-signs',
    'fa-solid fa-mars',
    'fa-solid fa-mars-double',
    'fa-solid fa-mars-stroke',
    'fa-solid fa-mars-stroke-h',
    'fa-solid fa-mars-stroke-v',
    'fa-solid fa-medkit',
    'fa-solid fa-meh',
    'fa-solid fa-mercury',
    'fa-solid fa-microchip',
    'fa-solid fa-microphone',
    'fa-solid fa-microphone-alt',
    'fa-solid fa-microphone-alt-slash',
    'fa-solid fa-microphone-slash',
    'fa-solid fa-minus',
    'fa-solid fa-minus-circle',
    'fa-solid fa-minus-square',
    'fa-solid fa-mobile',
    'fa-solid fa-mobile-alt',
    'fa-solid fa-money-bill',
    'fa-solid fa-money-bill-alt',
    'fa-solid fa-moon',
    'fa-solid fa-motorcycle',
    'fa-solid fa-mouse-pointer',
    'fa-solid fa-music',
    'fa-solid fa-neuter',
    'fa-solid fa-newspaper',
    'fa-solid fa-notes-medical',
    'fa-solid fa-object-group',
    'fa-solid fa-object-ungroup',
    'fa-solid fa-outdent',
    'fa-solid fa-paint-brush',
    'fa-solid fa-pallet',
    'fa-solid fa-paper-plane',
    'fa-solid fa-paperclip',
    'fa-solid fa-parachute-box',
    'fa-solid fa-paragraph',
    'fa-solid fa-paste',
    'fa-solid fa-pause',
    'fa-solid fa-pause-circle',
    'fa-solid fa-paw',
    'fa-solid fa-pen-square',
    'fa-solid fa-pencil-alt',
    'fa-solid fa-people-carry',
    'fa-solid fa-percent',
    'fa-solid fa-percentage',
    'fa-solid fa-phone',
    'fa-solid fa-phone-slash',
    'fa-solid fa-phone-square',
    'fa-solid fa-phone-volume',
    'fa-solid fa-piggy-bank',
    'fa-solid fa-pills',
    'fa-solid fa-plane',
    'fa-solid fa-play',
    'fa-solid fa-play-circle',
    'fa-solid fa-plug',
    'fa-solid fa-plus',
    'fa-solid fa-plus-circle',
    'fa-solid fa-plus-square',
    'fa-solid fa-podcast',
    'fa-solid fa-poo',
    'fa-solid fa-portrait',
    'fa-solid fa-pound-sign',
    'fa-solid fa-power-off',
    'fa-solid fa-prescription-bottle',
    'fa-solid fa-prescription-bottle-alt',
    'fa-solid fa-print',
    'fa-solid fa-procedures',
    'fa-solid fa-puzzle-piece',
    'fa-solid fa-qrcode',
    'fa-solid fa-question',
    'fa-solid fa-question-circle',
    'fa-solid fa-quidditch',
    'fa-solid fa-quote-left',
    'fa-solid fa-quote-right',
    'fa-solid fa-random',
    'fa-solid fa-recycle',
    'fa-solid fa-redo',
    'fa-solid fa-redo-alt',
    'fa-solid fa-registered',
    'fa-solid fa-reply',
    'fa-solid fa-reply-all',
    'fa-solid fa-retweet',
    'fa-solid fa-ribbon',
    'fa-solid fa-road',
    'fa-solid fa-robot',
    'fa-solid fa-rocket',
    'fa-solid fa-rss',
    'fa-solid fa-rss-square',
    'fa-solid fa-ruble-sign',
    'fa-solid fa-ruler',
    'fa-solid fa-ruler-combined',
    'fa-solid fa-ruler-horizontal',
    'fa-solid fa-ruler-vertical',
    'fa-solid fa-rupee-sign',
    'fa-solid fa-save',
    'fa-solid fa-school',
    'fa-solid fa-screwdriver',
    'fa-solid fa-search',
    'fa-solid fa-search-dollar',
    'fa-solid fa-search-location',
    'fa-solid fa-search-minus',
    'fa-solid fa-search-plus',
    'fa-solid fa-seedling',
    'fa-solid fa-server',
    'fa-solid fa-share',
    'fa-solid fa-share-alt',
    'fa-solid fa-share-alt-square',
    'fa-solid fa-share-square',
    'fa-solid fa-shekel-sign',
    'fa-solid fa-shield-alt',
    'fa-solid fa-ship',
    'fa-solid fa-shipping-fast',
    'fa-solid fa-shoe-prints',
    'fa-solid fa-shopping-bag',
    'fa-solid fa-shopping-basket',
    'fa-solid fa-shopping-cart',
    'fa-solid fa-shower',
    'fa-solid fa-sign',
    'fa-solid fa-sign-in-alt',
    'fa-solid fa-sign-language',
    'fa-solid fa-sign-out-alt',
    'fa-solid fa-signal',
    'fa-solid fa-sitemap',
    'fa-solid fa-skull',
    'fa-solid fa-sliders-h',
    'fa-solid fa-smile',
    'fa-solid fa-smoking',
    'fa-solid fa-snowflake',
    'fa-solid fa-sort',
    'fa-solid fa-sort-alpha-down',
    'fa-solid fa-sort-alpha-up',
    'fa-solid fa-sort-amount-down',
    'fa-solid fa-sort-amount-up',
    'fa-solid fa-sort-down',
    'fa-solid fa-sort-numeric-down',
    'fa-solid fa-sort-numeric-up',
    'fa-solid fa-sort-up',
    'fa-solid fa-space-shuttle',
    'fa-solid fa-spinner',
    'fa-solid fa-square',
    'fa-solid fa-square-full',
    'fa-solid fa-star',
    'fa-solid fa-star-half',
    'fa-solid fa-step-backward',
    'fa-solid fa-step-forward',
    'fa-solid fa-stethoscope',
    'fa-solid fa-sticky-note',
    'fa-solid fa-stop',
    'fa-solid fa-stop-circle',
    'fa-solid fa-stopwatch',
    'fa-solid fa-store',
    'fa-solid fa-store-alt',
    'fa-solid fa-stream',
    'fa-solid fa-street-view',
    'fa-solid fa-strikethrough',
    'fa-solid fa-stroopwafel',
    'fa-solid fa-subscript',
    'fa-solid fa-subway',
    'fa-solid fa-suitcase',
    'fa-solid fa-sun',
    'fa-solid fa-superscript',
    'fa-solid fa-sync',
    'fa-solid fa-sync-alt',
    'fa-solid fa-syringe',
    'fa-solid fa-table',
    'fa-solid fa-table-tennis',
    'fa-solid fa-tablet',
    'fa-solid fa-tablet-alt',
    'fa-solid fa-tablets',
    'fa-solid fa-tachometer-alt',
    'fa-solid fa-tag',
    'fa-solid fa-tags',
    'fa-solid fa-tape',
    'fa-solid fa-tasks',
    'fa-solid fa-taxi',
    'fa-solid fa-terminal',
    'fa-solid fa-text-height',
    'fa-solid fa-text-width',
    'fa-solid fa-th',
    'fa-solid fa-th-large',
    'fa-solid fa-th-list',
    'fa-solid fa-thermometer',
    'fa-solid fa-thermometer-empty',
    'fa-solid fa-thermometer-full',
    'fa-solid fa-thermometer-half',
    'fa-solid fa-thermometer-quarter',
    'fa-solid fa-thermometer-three-quarters',
    'fa-solid fa-thumbs-down',
    'fa-solid fa-thumbs-up',
    'fa-solid fa-thumbtack',
    'fa-solid fa-ticket-alt',
    'fa-solid fa-times',
    'fa-solid fa-times-circle',
    'fa-solid fa-tint',
    'fa-solid fa-toggle-off',
    'fa-solid fa-toggle-on',
    'fa-solid fa-trademark',
    'fa-solid fa-train',
    'fa-solid fa-transgender',
    'fa-solid fa-transgender-alt',
    'fa-solid fa-trash',
    'fa-solid fa-trash-alt',
    'fa-solid fa-tree',
    'fa-solid fa-trophy',
    'fa-solid fa-truck',
    'fa-solid fa-truck-loading',
    'fa-solid fa-truck-moving',
    'fa-solid fa-tty',
    'fa-solid fa-tv',
    'fa-solid fa-umbrella',
    'fa-solid fa-underline',
    'fa-solid fa-undo',
    'fa-solid fa-undo-alt',
    'fa-solid fa-universal-access',
    'fa-solid fa-university',
    'fa-solid fa-unlink',
    'fa-solid fa-unlock',
    'fa-solid fa-unlock-alt',
    'fa-solid fa-upload',
    'fa-solid fa-user',
    'fa-solid fa-user-circle',
    'fa-solid fa-user-md',
    'fa-solid fa-user-plus',
    'fa-solid fa-user-secret',
    'fa-solid fa-user-times',
    'fa-solid fa-users',
    'fa-solid fa-utensil-spoon',
    'fa-solid fa-utensils',
    'fa-solid fa-venus',
    'fa-solid fa-venus-double',
    'fa-solid fa-venus-mars',
    'fa-solid fa-vial',
    'fa-solid fa-vials',
    'fa-solid fa-video',
    'fa-solid fa-video-slash',
    'fa-solid fa-volleyball-ball',
    'fa-solid fa-volume-down',
    'fa-solid fa-volume-off',
    'fa-solid fa-volume-up',
    'fa-solid fa-warehouse',
    'fa-solid fa-weight',
    'fa-solid fa-weight-hanging',
    'fa-solid fa-wheelchair',
    'fa-solid fa-wifi',
    'fa-solid fa-window-close',
    'fa-solid fa-window-maximize',
    'fa-solid fa-window-minimize',
    'fa-solid fa-window-restore',
    'fa-solid fa-wine-glass',
    'fa-solid fa-won-sign',
    'fa-solid fa-wrench',
    'fa-solid fa-x-ray',
    'fa-solid fa-yen-sign',
    'fa-brands fa-500px',
    'fa-brands fa-accessible-icon',
    'fa-brands fa-accusoft',
    'fa-brands fa-acquisitions-incorporated',
    'fa-brands fa-adn',
    'fa-brands fa-adobe',
    'fa-brands fa-adversal',
    'fa-brands fa-affiliatetheme',
    'fa-brands fa-airbnb',
    'fa-brands fa-algolia',
    'fa-brands fa-alipay',
    'fa-brands fa-amazon',
    'fa-brands fa-amazon-pay',
    'fa-brands fa-amilia',
    'fa-brands fa-android',
    'fa-brands fa-angellist',
    'fa-brands fa-angrycreative',
    'fa-brands fa-angular',
    'fa-brands fa-app-store',
    'fa-brands fa-app-store-ios',
    'fa-brands fa-apper',
    'fa-brands fa-apple',
    'fa-brands fa-apple-pay',
    'fa-brands fa-artstation',
    'fa-brands fa-asymmetrik',
    'fa-brands fa-atlassian',
    'fa-brands fa-audible',
    'fa-brands fa-autoprefixer',
    'fa-brands fa-avianex',
    'fa-brands fa-aviato',
    'fa-brands fa-aws',
    'fa-brands fa-bandcamp',
    'fa-brands fa-battle-net',
    'fa-brands fa-behance',
    'fa-brands fa-behance-square',
    'fa-brands fa-bimobject',
    'fa-brands fa-bitbucket',
    'fa-brands fa-bitcoin',
    'fa-brands fa-bity',
    'fa-brands fa-black-tie',
    'fa-brands fa-blackberry',
    'fa-brands fa-blogger',
    'fa-brands fa-blogger-b',
    'fa-brands fa-bluetooth',
    'fa-brands fa-bluetooth-b',
    'fa-brands fa-bootstrap',
    'fa-brands fa-btc',
    'fa-brands fa-buffer',
    'fa-brands fa-buromobelexperte',
    'fa-brands fa-buy-n-large',
    'fa-brands fa-buysellads',
    'fa-brands fa-canadian-maple-leaf',
    'fa-brands fa-cc-amazon-pay',
    'fa-brands fa-cc-amex',
    'fa-brands fa-cc-apple-pay',
    'fa-brands fa-cc-diners-club',
    'fa-brands fa-cc-discover',
    'fa-brands fa-cc-jcb',
    'fa-brands fa-cc-mastercard',
    'fa-brands fa-cc-paypal',
    'fa-brands fa-cc-stripe',
    'fa-brands fa-cc-visa',
    'fa-brands fa-centercode',
    'fa-brands fa-centos',
    'fa-brands fa-chrome',
    'fa-brands fa-chromecast',
    'fa-brands fa-cloudscale',
    'fa-brands fa-cloudsmith',
    'fa-brands fa-cloudversify',
    'fa-brands fa-codepen',
    'fa-brands fa-codiepie',
    'fa-brands fa-confluence',
    'fa-brands fa-connectdevelop',
    'fa-brands fa-contao',
    'fa-brands fa-cotton-bureau',
    'fa-brands fa-cpanel',
    'fa-brands fa-creative-commons',
    'fa-brands fa-creative-commons-by',
    'fa-brands fa-creative-commons-nc',
    'fa-brands fa-creative-commons-nc-eu',
    'fa-brands fa-creative-commons-nc-jp',
    'fa-brands fa-creative-commons-nd',
    'fa-brands fa-creative-commons-pd',
    'fa-brands fa-creative-commons-pd-alt',
    'fa-brands fa-creative-commons-remix',
    'fa-brands fa-creative-commons-sa',
    'fa-brands fa-creative-commons-sampling',
    'fa-brands fa-creative-commons-sampling-plus',
    'fa-brands fa-creative-commons-share',
    'fa-brands fa-creative-commons-zero',
    'fa-brands fa-critical-role',
    'fa-brands fa-css3',
    'fa-brands fa-css3-alt',
    'fa-brands fa-cuttlefish',
    'fa-brands fa-d-and-d',
    'fa-brands fa-d-and-d-beyond',
    'fa-brands fa-dashcube',
    'fa-brands fa-delicious',
    'fa-brands fa-deploydog',
    'fa-brands fa-deskpro',
    'fa-brands fa-dev',
    'fa-brands fa-deviantart',
    'fa-brands fa-dhl',
    'fa-brands fa-diaspora',
    'fa-brands fa-digg',
    'fa-brands fa-digital-ocean',
    'fa-brands fa-discord',
    'fa-brands fa-discourse',
    'fa-brands fa-dochub',
    'fa-brands fa-docker',
    'fa-brands fa-draft2digital',
    'fa-brands fa-dribbble',
    'fa-brands fa-dribbble-square',
    'fa-brands fa-dropbox',
    'fa-brands fa-drupal',
    'fa-brands fa-dyalog',
    'fa-brands fa-earlybirds',
    'fa-brands fa-ebay',
    'fa-brands fa-edge',
    'fa-brands fa-edge-legacy',
    'fa-brands fa-elementor',
    'fa-brands fa-ello',
    'fa-brands fa-ember',
    'fa-brands fa-empire',
    'fa-brands fa-envira',
    'fa-brands fa-erlang',
    'fa-brands fa-ethereum',
    'fa-brands fa-etsy',
    'fa-brands fa-evernote',
    'fa-brands fa-expeditedssl',
    'fa-brands fa-facebook',
    'fa-brands fa-facebook-f',
    'fa-brands fa-facebook-messenger',
    'fa-brands fa-facebook-square',
    'fa-brands fa-fantasy-flight-games',
    'fa-brands fa-fedex',
    'fa-brands fa-fedora',
    'fa-brands fa-figma',
    'fa-brands fa-firefox',
    'fa-brands fa-firefox-browser',
    'fa-brands fa-first-order',
    'fa-brands fa-first-order-alt',
    'fa-brands fa-firstdraft',
    'fa-brands fa-flickr',
    'fa-brands fa-flipboard',
    'fa-brands fa-fly',
    'fa-brands fa-font-awesome',
    'fa-brands fa-font-awesome-alt',
    'fa-brands fa-font-awesome-flag',
    'fa-brands fa-fonticons',
    'fa-brands fa-fonticons-fi',
    'fa-brands fa-fort-awesome',
    'fa-brands fa-fort-awesome-alt',
    'fa-brands fa-forumbee',
    'fa-brands fa-foursquare',
    'fa-brands fa-free-code-camp',
    'fa-brands fa-freebsd',
    'fa-brands fa-fulcrum',
    'fa-brands fa-galactic-republic',
    'fa-brands fa-galactic-senate',
    'fa-brands fa-get-pocket',
    'fa-brands fa-gg',
    'fa-brands fa-gg-circle',
    'fa-brands fa-git',
    'fa-brands fa-git-alt',
    'fa-brands fa-git-square',
    'fa-brands fa-github',
    'fa-brands fa-github-alt',
    'fa-brands fa-github-square',
    'fa-brands fa-gitkraken',
    'fa-brands fa-gitlab',
    'fa-brands fa-gitter',
    'fa-brands fa-glide',
    'fa-brands fa-glide-g',
    'fa-brands fa-gofore',
    'fa-brands fa-goodreads',
    'fa-brands fa-goodreads-g',
    'fa-brands fa-google',
    'fa-brands fa-google-drive',
    'fa-brands fa-google-play',
    'fa-brands fa-google-plus',
    'fa-brands fa-google-plus-g',
    'fa-brands fa-google-plus-square',
    'fa-brands fa-google-wallet',
    'fa-brands fa-gratipay',
    'fa-brands fa-grav',
    'fa-brands fa-gripfire',
    'fa-brands fa-grunt',
    'fa-brands fa-guilded',
    'fa-brands fa-gulp',
    'fa-brands fa-hacker-news',
    'fa-brands fa-hacker-news-square',
    'fa-brands fa-hackerrank',
    'fa-brands fa-hips',
    'fa-brands fa-hire-a-helper',
    'fa-brands fa-hive',
    'fa-brands fa-hooli',
    'fa-brands fa-hornbill',
    'fa-brands fa-hotjar',
    'fa-brands fa-houzz',
    'fa-brands fa-html5',
    'fa-brands fa-hubspot',
    'fa-brands fa-ideal',
    'fa-brands fa-imdb',
    'fa-brands fa-innosoft',
    'fa-brands fa-instagram',
    'fa-brands fa-instalod',
    'fa-brands fa-intercom',
    'fa-brands fa-internet-explorer',
    'fa-brands fa-invision',
    'fa-brands fa-ioxhost',
    'fa-brands fa-itch-io',
    'fa-brands fa-itunes',
    'fa-brands fa-itunes-note',
    'fa-brands fa-java',
    'fa-brands fa-jedi-order',
    'fa-brands fa-jenkins',
    'fa-brands fa-jira',
    'fa-brands fa-joget',
    'fa-brands fa-joomla',
    'fa-brands fa-js',
    'fa-brands fa-js-square',
    'fa-brands fa-jsfiddle',
    'fa-brands fa-kaggle',
    'fa-brands fa-keybase',
    'fa-brands fa-keycdn',
    'fa-brands fa-kickstarter',
    'fa-brands fa-kickstarter-k',
    'fa-brands fa-korvue',
    'fa-brands fa-laravel',
    'fa-brands fa-lastfm',
    'fa-brands fa-lastfm-square',
    'fa-brands fa-leanpub',
    'fa-brands fa-less',
    'fa-brands fa-line',
    'fa-brands fa-linkedin',
    'fa-brands fa-linkedin-in',
    'fa-brands fa-linode',
    'fa-brands fa-linux',
    'fa-brands fa-lyft',
    'fa-brands fa-magento',
    'fa-brands fa-mailchimp',
    'fa-brands fa-mandalorian',
    'fa-brands fa-markdown',
    'fa-brands fa-mastodon',
    'fa-brands fa-maxcdn',
    'fa-brands fa-mdb',
    'fa-brands fa-medapps',
    'fa-brands fa-medium',
    'fa-brands fa-medium-m',
    'fa-brands fa-medrt',
    'fa-brands fa-meetup',
    'fa-brands fa-megaport',
    'fa-brands fa-mendeley',
    'fa-brands fa-microblog',
    'fa-brands fa-microsoft',
    'fa-brands fa-mix',
    'fa-brands fa-mixcloud',
    'fa-brands fa-mixer',
    'fa-brands fa-mizuni',
    'fa-brands fa-modx',
    'fa-brands fa-monero',
    'fa-brands fa-napster',
    'fa-brands fa-neos',
    'fa-brands fa-nimblr',
    'fa-brands fa-node',
    'fa-brands fa-node-js',
    'fa-brands fa-npm',
    'fa-brands fa-ns8',
    'fa-brands fa-nutritionix',
    'fa-brands fa-octopus-deploy',
    'fa-brands fa-odnoklassniki',
    'fa-brands fa-odnoklassniki-square',
    'fa-brands fa-old-republic',
    'fa-brands fa-opencart',
    'fa-brands fa-openid',
    'fa-brands fa-opera',
    'fa-brands fa-optin-monster',
    'fa-brands fa-orcid',
    'fa-brands fa-osi',
    'fa-brands fa-page4',
    'fa-brands fa-pagelines',
    'fa-brands fa-palfed',
    'fa-brands fa-patreon',
    'fa-brands fa-paypal',
    'fa-brands fa-penny-arcade',
    'fa-brands fa-periscope',
    'fa-brands fa-phabricator',
    'fa-brands fa-phoenix-framework',
    'fa-brands fa-phoenix-squadron',
    'fa-brands fa-php',
    'fa-brands fa-pied-piper',
    'fa-brands fa-pied-piper-alt',
    'fa-brands fa-pied-piper-hat',
    'fa-brands fa-pied-piper-pp',
    'fa-brands fa-pinterest',
    'fa-brands fa-pinterest-p',
    'fa-brands fa-pinterest-square',
    'fa-brands fa-playstation',
    'fa-brands fa-product-hunt',
    'fa-brands fa-pushed',
    'fa-brands fa-python',
    'fa-brands fa-qq',
    'fa-brands fa-quinscape',
    'fa-brands fa-quora',
    'fa-brands fa-r-project',
    'fa-brands fa-raspberry-pi',
    'fa-brands fa-ravelry',
    'fa-brands fa-react',
    'fa-brands fa-reacteurope',
    'fa-brands fa-readme',
    'fa-brands fa-rebel',
    'fa-brands fa-red-river',
    'fa-brands fa-reddit',
    'fa-brands fa-reddit-alien',
    'fa-brands fa-reddit-square',
    'fa-brands fa-redhat',
    'fa-brands fa-renren',
    'fa-brands fa-replyd',
    'fa-brands fa-researchgate',
    'fa-brands fa-resolving',
    'fa-brands fa-rev',
    'fa-brands fa-rocketchat',
    'fa-brands fa-rockrms',
    'fa-brands fa-rust',
    'fa-brands fa-safari',
    'fa-brands fa-salesforce',
    'fa-brands fa-sass',
    'fa-brands fa-schlix',
    'fa-brands fa-scribd',
    'fa-brands fa-searchengin',
    'fa-brands fa-sellcast',
    'fa-brands fa-sellsy',
    'fa-brands fa-servicestack',
    'fa-brands fa-shirtsinbulk',
    'fa-brands fa-shopify',
    'fa-brands fa-shopware',
    'fa-brands fa-simplybuilt',
    'fa-brands fa-sistrix',
    'fa-brands fa-sith',
    'fa-brands fa-sketch',
    'fa-brands fa-skyatlas',
    'fa-brands fa-skype',
    'fa-brands fa-slack',
    'fa-brands fa-slack-hash',
    'fa-brands fa-slideshare',
    'fa-brands fa-snapchat',
    'fa-brands fa-snapchat-ghost',
    'fa-brands fa-snapchat-square',
    'fa-brands fa-soundcloud',
    'fa-brands fa-sourcetree',
    'fa-brands fa-speakap',
    'fa-brands fa-speaker-deck',
    'fa-brands fa-spotify',
    'fa-brands fa-square-font-awesome',
    'fa-brands fa-square-font-awesome-stroke',
    'fa-brands fa-squarespace',
    'fa-brands fa-stack-exchange',
    'fa-brands fa-stack-overflow',
    'fa-brands fa-stackpath',
    'fa-brands fa-staylinked',
    'fa-brands fa-steam',
    'fa-brands fa-steam-square',
    'fa-brands fa-steam-symbol',
    'fa-brands fa-sticker-mule',
    'fa-brands fa-strava',
    'fa-brands fa-stripe',
    'fa-brands fa-stripe-s',
    'fa-brands fa-studiovinari',
    'fa-brands fa-stumbleupon',
    'fa-brands fa-stumbleupon-circle',
    'fa-brands fa-superpowers',
    'fa-brands fa-supple',
    'fa-brands fa-suse',
    'fa-brands fa-swift',
    'fa-brands fa-symfony',
    'fa-brands fa-teamspeak',
    'fa-brands fa-telegram',
    'fa-brands fa-telegram-plane',
    'fa-brands fa-tencent-weibo',
    'fa-brands fa-the-red-yeti',
    'fa-brands fa-themeco',
    'fa-brands fa-themeisle',
    'fa-brands fa-think-peaks',
    'fa-brands fa-tiktok',
    'fa-brands fa-trade-federation',
    'fa-brands fa-trello',
    'fa-brands fa-tripadvisor',
    'fa-brands fa-tumblr',
    'fa-brands fa-tumblr-square',
    'fa-brands fa-twitch',
    'fa-brands fa-twitter',
    'fa-brands fa-twitter-square',
    'fa-brands fa-typo3',
    'fa-brands fa-uber',
    'fa-brands fa-ubuntu',
    'fa-brands fa-uikit',
    'fa-brands fa-umbraco',
    'fa-brands fa-uniregistry',
    'fa-brands fa-unity',
    'fa-brands fa-unsplash',
    'fa-brands fa-untappd',
    'fa-brands fa-ups',
    'fa-brands fa-usb',
    'fa-brands fa-usps',
    'fa-brands fa-ussunnah',
    'fa-brands fa-vaadin',
    'fa-brands fa-viacoin',
    'fa-brands fa-viadeo',
    'fa-brands fa-viadeo-square',
    'fa-brands fa-viber',
    'fa-brands fa-vimeo',
    'fa-brands fa-vimeo-square',
    'fa-brands fa-vimeo-v',
    'fa-brands fa-vine',
    'fa-brands fa-vk',
    'fa-brands fa-vnv',
    'fa-brands fa-vuejs',
    'fa-brands fa-watchman-monitoring',
    'fa-brands fa-waze',
    'fa-brands fa-weebly',
    'fa-brands fa-weibo',
    'fa-brands fa-weixin',
    'fa-brands fa-whatsapp',
    'fa-brands fa-whatsapp-square',
    'fa-brands fa-whmcs',
    'fa-brands fa-wikipedia-w',
    'fa-brands fa-windows',
    'fa-brands fa-wix',
    'fa-brands fa-wizards-of-the-coast',
    'fa-brands fa-wodu',
    'fa-brands fa-wolf-pack-battalion',
    'fa-brands fa-wordpress',
    'fa-brands fa-wordpress-simple',
    'fa-brands fa-wpbeginner',
    'fa-brands fa-wpexplorer',
    'fa-brands fa-wpforms',
    'fa-brands fa-wpressr',
    'fa-brands fa-xbox',
    'fa-brands fa-xing',
    'fa-brands fa-xing-square',
    'fa-brands fa-y-combinator',
    'fa-brands fa-yahoo',
    'fa-brands fa-yammer',
    'fa-brands fa-yandex',
    'fa-brands fa-yandex-international',
    'fa-brands fa-yarn',
    'fa-brands fa-yelp',
    'fa-brands fa-yoast',
    'fa-brands fa-youtube',
    'fa-brands fa-youtube-square',
    'fa-brands fa-zhihu',
    'fa-regular fa-address-book',
    'fa-regular fa-address-card',
    'fa-regular fa-angry',
    'fa-regular fa-arrow-alt-circle-down',
    'fa-regular fa-arrow-alt-circle-left',
    'fa-regular fa-arrow-alt-circle-right',
    'fa-regular fa-arrow-alt-circle-up',
    'fa-regular fa-bell',
    'fa-regular fa-bell-slash',
    'fa-regular fa-bookmark',
    'fa-regular fa-building',
    'fa-regular fa-calendar',
    'fa-regular fa-calendar-alt',
    'fa-regular fa-calendar-check',
    'fa-regular fa-calendar-minus',
    'fa-regular fa-calendar-plus',
    'fa-regular fa-calendar-times',
    'fa-regular fa-caret-square-down',
    'fa-regular fa-caret-square-left',
    'fa-regular fa-caret-square-right',
    'fa-regular fa-caret-square-up',
    'fa-regular fa-chart-bar',
    'fa-regular fa-check-circle',
    'fa-regular fa-check-square',
    'fa-regular fa-circle',
    'fa-regular fa-clipboard',
    'fa-regular fa-clock',
    'fa-regular fa-clone',
    'fa-regular fa-closed-captioning',
    'fa-regular fa-comment',
    'fa-regular fa-comment-alt',
    'fa-regular fa-comment-dots',
    'fa-regular fa-comments',
    'fa-regular fa-compass',
    'fa-regular fa-copy',
    'fa-regular fa-copyright',
    'fa-regular fa-credit-card',
    'fa-regular fa-dizzy',
    'fa-regular fa-dot-circle',
    'fa-regular fa-edit',
    'fa-regular fa-envelope',
    'fa-regular fa-envelope-open',
    'fa-regular fa-eye-slash',
    'fa-regular fa-file',
    'fa-regular fa-file-alt',
    'fa-regular fa-file-archive',
    'fa-regular fa-file-audio',
    'fa-regular fa-file-code',
    'fa-regular fa-file-excel',
    'fa-regular fa-file-image',
    'fa-regular fa-file-pdf',
    'fa-regular fa-file-powerpoint',
    'fa-regular fa-file-video',
    'fa-regular fa-file-word',
    'fa-regular fa-flag',
    'fa-regular fa-flushed',
    'fa-regular fa-folder',
    'fa-regular fa-folder-open',
    'fa-regular fa-frown',
    'fa-regular fa-frown-open',
    'fa-regular fa-futbol',
    'fa-regular fa-gem',
    'fa-regular fa-grimace',
    'fa-regular fa-grin',
    'fa-regular fa-grin-alt',
    'fa-regular fa-grin-beam',
    'fa-regular fa-grin-beam-sweat',
    'fa-regular fa-grin-hearts',
    'fa-regular fa-grin-squint',
    'fa-regular fa-grin-squint-tears',
    'fa-regular fa-grin-stars',
    'fa-regular fa-grin-tears',
    'fa-regular fa-grin-tongue',
    'fa-regular fa-grin-tongue-squint',
    'fa-regular fa-grin-tongue-wink',
    'fa-regular fa-grin-wink',
    'fa-regular fa-hand-lizard',
    'fa-regular fa-hand-paper',
    'fa-regular fa-hand-peace',
    'fa-regular fa-hand-point-down',
    'fa-regular fa-hand-point-left',
    'fa-regular fa-hand-point-right',
    'fa-regular fa-hand-point-up',
    'fa-regular fa-hand-pointer',
    'fa-regular fa-hand-rock',
    'fa-regular fa-hand-scissors',
    'fa-regular fa-hand-spock',
    'fa-regular fa-handshake',
    'fa-regular fa-hdd',
    'fa-regular fa-heart',
    'fa-regular fa-hospital',
    'fa-regular fa-hourglass',
    'fa-regular fa-id-badge',
    'fa-regular fa-id-card',
    'fa-regular fa-image',
    'fa-regular fa-images',
    'fa-regular fa-keyboard',
    'fa-regular fa-kiss',
    'fa-regular fa-kiss-beam',
    'fa-regular fa-kiss-wink-heart',
    'fa-regular fa-laugh',
    'fa-regular fa-laugh-beam',
    'fa-regular fa-laugh-squint',
    'fa-regular fa-laugh-wink',
    'fa-regular fa-lemon',
    'fa-regular fa-life-ring',
    'fa-regular fa-lightbulb',
    'fa-regular fa-list-alt',
    'fa-regular fa-map',
    'fa-regular fa-meh',
    'fa-regular fa-meh-blank',
    'fa-regular fa-meh-rolling-eyes',
    'fa-regular fa-minus-square',
    'fa-regular fa-money-bill-alt',
    'fa-regular fa-moon',
    'fa-regular fa-newspaper',
    'fa-regular fa-object-group',
    'fa-regular fa-object-ungroup',
    'fa-regular fa-paper-plane',
    'fa-regular fa-pause-circle',
    'fa-regular fa-play-circle',
    'fa-regular fa-plus-square',
    'fa-regular fa-question-circle',
    'fa-regular fa-registered',
    'fa-regular fa-sad-cry',
    'fa-regular fa-sad-tear',
    'fa-regular fa-save',
    'fa-regular fa-share-square',
    'fa-regular fa-smile',
    'fa-regular fa-smile-beam',
    'fa-regular fa-smile-wink',
    'fa-regular fa-snowflake',
    'fa-regular fa-square',
    'fa-regular fa-star',
    'fa-regular fa-star-half',
    'fa-regular fa-sticky-note',
    'fa-regular fa-stop-circle',
    'fa-regular fa-sun',
    'fa-regular fa-surprise',
    'fa-regular fa-thumbs-down',
    'fa-regular fa-thumbs-up',
    'fa-regular fa-times-circle',
    'fa-regular fa-tired',
    'fa-regular fa-trash-alt',
    'fa-regular fa-user',
    'fa-regular fa-user-circle',
    'fa-regular fa-window-close',
    'fa-regular fa-window-maximize',
    'fa-regular fa-window-minimize',
    'fa-regular fa-window-restore',
];


document.addEventListener('DOMContentLoaded', function() {
    const iconPickers = document.querySelectorAll('.icon-picker');

    iconPickers.forEach(iconPickerContainer => {
        const id = iconPickerContainer.getAttribute('data-id');
        const name = iconPickerContainer.getAttribute('data-name');
        const placeholder = iconPickerContainer.getAttribute('data-placeholder');
        const labelText = iconPickerContainer.getAttribute('data-label');
        let value = iconPickerContainer.getAttribute('data-value');

        // Appliquez une icône par défaut
        // Appliquez une icône par défaut si data-value est vide
        const defaultIcon = 'fa-solid fa-dot-circle';
        if (!value) {
            value = '';
        }

        // Créer les éléments HTML dynamiquement
        const label = document.createElement('label');
        label.setAttribute('for', id);
        label.textContent = labelText;

        const inputGroup = document.createElement('div');
        inputGroup.className = 'input-group';

        const selectedIcon = document.createElement('i');
        selectedIcon.className = `selected-icon ${value || defaultIcon}`;

        const input = document.createElement('input');
        input.type = 'text';
        input.id = id;
        input.name = name;
        input.className = 'icon-picker-input';
        input.placeholder = placeholder;
        input.value = value;
        input.autocomplete = 'off';

        const iconListContainer = document.createElement('div');
        iconListContainer.className = 'icon-list';

        inputGroup.appendChild(selectedIcon);
        inputGroup.appendChild(input);
        iconPickerContainer.appendChild(label);
        iconPickerContainer.appendChild(inputGroup);
        iconPickerContainer.appendChild(iconListContainer);

        // Fonction pour afficher la liste filtrée d'icônes
        function filterIcons(query) {
            iconListContainer.innerHTML = '';
            if (icons.includes(query)) {
                icons.forEach(icon => {
                    const iconElement = document.createElement('i');
                    iconElement.className = `${icon}`;
                    iconListContainer.appendChild(iconElement);
                });
            } else {
                const filteredIcons = icons.filter(icon => icon.includes(query));
                filteredIcons.forEach(icon => {
                    const iconElement = document.createElement('i');
                    iconElement.className = `${icon}`;
                    iconListContainer.appendChild(iconElement);
                });
            }
        }

        // Affichez la liste d'icônes lors du clic sur l'input
        input.addEventListener('click', function() {
            filterIcons(input.value);
            iconListContainer.style.display = 'block';
            input.select(); // Sélectionne tout le texte dans l'input
        });

        // Filtrer les icônes en fonction de la saisie de l'utilisateur
        input.addEventListener('input', function() {
            filterIcons(input.value);
        });

        // Ajoutez un gestionnaire de clics sur chaque icône
        iconListContainer.addEventListener('click', function(e) {
            if (e.target.tagName === 'I') {
                const selectedIconClass = e.target.className;
                input.value = selectedIconClass;
                selectedIcon.className = selectedIconClass;
                iconListContainer.style.display = 'none';
            }
        });

        // Masquez la liste d'icônes si on clique en dehors
        document.addEventListener('click', function(e) {
            if (!input.contains(e.target) && !iconListContainer.contains(e.target)) {
                iconListContainer.style.display = 'none';
            }
        });

        // Vérifiez si une valeur est déjà présente dans l'input lors de l'initialisation
        const initialIconValue = input.value.trim();
        if (icons.includes(initialIconValue)) {
            selectedIcon.className = initialIconValue;
        } else if (initialIconValue) {
            selectedIcon.className = initialIconValue;
        } else {
            selectedIcon.className = defaultIcon;
        }
    });
});