# 恶意软件分析大合集 [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)


这个列表记录着那些令人称赞的恶意软件分析工具和资源。受到 [awesome-python](https://github.com/vinta/awesome-python) 和 [awesome-php](https://github.com/ziadoz/awesome-php) 的启迪。

- [恶意软件集合](#恶意软件集合)
    - [匿名代理](#匿名代理)
    - [蜜罐](#蜜罐)
    - [恶意软件样本库](#恶意软件样本库)
- [开源威胁情报](#开源威胁情报)
    - [工具](#工具)
    - [其他资源](#其他资源)
- [检测与分类](#检测与分类)
- [在线扫描与沙盒](#在线扫描与沙盒)
- [域名分析](#域名分析)
- [浏览器恶意软件](#浏览器恶意软件)
- [文档和 Shellcode](#文档和-Shellcode)
- [文件提取](#文件提取)
- [去混淆](#去混淆)
- [调试与逆向工程](#调试与逆向工程)
- [网络](#网络)
- [内存取证](#内存取证)
- [Windows 神器](#Windows-神器)
- [存储和工作流](#存储和工作流)
- [杂项](#杂项)
- [资源](#资源)
    - [书籍](#书籍)
    - [其它](#其它)
- [相关 Awesome 清单](#相关-Awesome-清单)
- [贡献者](#做出贡献)
- [致谢](#致谢)

---

## 恶意软件集合

### 匿名代理

*对于分析人员的 Web 流量匿名方案*

* [Anonymouse.org](http://anonymouse.org/) - 一个免费、基于 Web 的匿名代理
* [OpenVPN](https://openvpn.net/) - VPN 软件和托管解决方案
* [Privoxy](http://www.privoxy.org/) - 一个带有隐私保护功能的开源代理服务器
* [Tor](https://www.torproject.org/) - 洋葱路由器，为了在浏览网页时不留下客户端 IP 地址

### 蜜罐

*捕获和收集你自己的样本*

* [Conpot](https://github.com/mushorg/conpot) - ICS/SCADA 蜜罐
* [Cowrie](https://github.com/micheloosterhof/cowrie) - 基于 Kippo 的 SSH 蜜罐
* [DemoHunter](https://github.com/RevengeComing/DemonHunter) - 低交互分布式蜜罐
* [Dionaea](http://dionaea.carnivore.it/) - 用来捕获恶意软件的蜜罐
* [Glastopf](http://glastopf.org/) - Web 应用蜜罐
* [Honeyd](http://honeyd.org/) - 创建一个虚拟蜜罐
* [HoneyDrive](https://bruteforce.gr/honeydrive/) - 蜜罐包的 Linux 发行版
* [Honeytrap](https://github.com/honeytrap/honeytrap) - 运行、监控、管理蜜罐的开源系统
* [MHN](https://github.com/pwnlandia/mhn) - MHN 是管理蜜罐的集中式服务器，可以快速部署蜜罐收集数据，并提供统一的 Web 界面
* [Mnemosyne](https://github.com/johnnykv/mnemosyne) - 受 Dinoaea 支持的蜜罐数据标准化
* [Thug](https://github.com/buffer/thug) - 用来调查恶意网站的低交互蜜罐

### 恶意软件样本库

*收集用于分析的恶意软件样本*

* [Clean MX](http://support.clean-mx.com/clean-mx/viruses.php) - 恶意软件和恶意域名的实时数据库
* [Contagio](http://contagiodump.blogspot.com/) - 近期的恶意软件样本和分析的收集
* [Exploit Database](https://www.exploit-db.com/) - Exploit 和 shellcode 样本
* [Infosec - CERT-PA](https://infosec.cert-pa.it/analyze/submission.html) - 恶意软件样本收集与分析
* [InQuest Labs](https://labs.inquest.net) - 恶意 Microsoft 文档语料库
* [Javascript Mallware Collection](https://github.com/HynekPetrak/javascript-malware-collection) - 收集了将近四万个 JavaScript 恶意样本
* [Malpedia](https://malpedia.caad.fkie.fraunhofer.de/) - 为调查恶意软件提供快速可识别、可操作的上下文资源
* [Malshare](https://malshare.com) - 在恶意网站上得到的大量恶意样本库
* [Ragpicker](https://github.com/robbyFux/Ragpicker) - 基于 malware crawler 的一个插件
* [theZoo](https://github.com/ytisf/theZoo) - 分析人员的实时恶意样本库
* [Tracker h3x](http://tracker.h3x.eu/) - Agregator 的恶意软件跟踪和下载地址
* [vduddu malware repo](https://github.com/vduddu/Malware) - 多种恶意软件文件与源码收集
* [VirusBay](https://beta.virusbay.io/) - 基于社区的恶意软件仓库
* [ViruSign](http://www.virussign.com/) - 除 ClamAV 外的反病毒程序检出的恶意软件数据库
* [VirusShare](http://virusshare.com/) - 恶意软件库
* [VX Vault](http://vxvault.net/) - 恶意软件样本的主动收集
* [Zeltser's Sources](https://zeltser.com/malware-sample-sources/) - 由 Lenny Zeltser 整理的恶意软件样本源列表
* [Zeus Source Code](https://github.com/Visgean/Zeus) - 2011 年 Zeus 源码泄露

## 开源威胁情报

### 工具

*收集、分析 IOC 信息*

* [AbuseHelper](https://github.com/abusesa/abusehelper) - 用于接收和重新分发威胁情报的开源框架
* [AlienVault Open Threat Exchange](https://otx.alienvault.com/) - 威胁情报的共享与合作
* [Combine](https://github.com/mlsecproject/combine) - 从公开的信息源中得到威胁情报信息
* [Fileintel](https://github.com/keithjjones/fileintel) - 文件情报
* [Hostintel](https://github.com/keithjjones/hostintel) - 主机情报
* [IntelMQ](https://www.enisa.europa.eu/activities/cert/support/incident-handling-automation) - CERT 使用消息队列来处理应急数据的工具
* [IOC Editor](https://www.mandiant.com/resources/download/ioc-editor/) - Mandiant 出品的一个免费的 XML IOC 文件编辑器
* [iocextract](https://github.com/InQuest/python-iocextract) - 高级 IOC 提取工具，Python 库与命令行工具
* [ioc_writer](https://github.com/mandiant/ioc_writer) - 开发的用于 OpenIOC 对象的 Python 库
* [MalPipe](https://github.com/silascutler/MalPipe) - 恶意软件/IOC 提取和处理引擎，收集丰富的数据
* [Massive Octo Spice](https://github.com/csirtgadgets/massive-octo-spice) - 由 [CSIRT Gadgets Foundation](http://csirtgadgets.org/collective-intelligence-framework)发起，之前叫做 CIF (Collective Intelligence Framework)，从各种信息源聚合 IOC 信息
* [MISP](https://github.com/MISP/MISP) - 由 [The MISP Project](http://www.misp-project.org/) 发起的恶意软件信息共享平台
* [Pulsedive](https://pulsedive.com) - 社区驱动的免费威胁情报平台，在开源资源中收集 IOC
* [PyIOCe](https://github.com/pidydx/PyIOCe) - 一个 Python OpenIOC 编辑器
* [RiskIQ](https://community.riskiq.com/) - 研究、链接、标注和分享 IP 与 域名
* [threataggregator](https://github.com/jpsenior/threataggregator) - 聚合来自多个信息源的安全威胁，包括 [other resources](#other-resources) 列表中的一些
* [ThreatConnect](https://threatconnect.com/free/) - TC Open 用于查看、共享开源数据，将会得到社区的支持与验证
* [ThreatCrowd](https://www.threatcrowd.org/) - 带有图形可视化的威胁搜索引擎
* [ThreatTracker](https://github.com/michael-yip/ThreatTracker) - 一个 Python 脚本，用于根据 Google 自定义搜索引擎检索的 IOC 监视、生成警报
* [TIQ-test](https://github.com/mlsecproject/tiq-test) - 威胁情报源的数据可视化和统计分析

### 其他资源

*威胁情报和 IOC 资源*

* [Autoshun](http://autoshun.org/) ([list](http://autoshun.org/)) - Snort 插件和黑名单
* [Bambenek Consulting Feeds](http://osint.bambenekconsulting.com/feeds/) - 基于恶意 DGA 算法的 OSINT 订阅
* [Fidelis Barncat](https://www.fidelissecurity.com/resources/fidelis-barncat) - 可扩展的恶意软件配置数据库（必须有请求权限）
* [CI Army](http://www.ciarmy.com/) ([list](http://www.ciarmy.com/list/ci-badguys.txt)) - 网络安全黑名单
* [Critical Stack- Free Intel Market](https://intel.CriticalStack.com) - 免费的英特尔去重聚合项目，有超过 90 种订阅以及超过一百二十万个威胁情报信息
* [Cybercrime tracker](http://cybercrime-tracker.net/) - 多个僵尸网络的活动跟踪
* [FireEye IOCs](https://github.com/fireeye/iocs) - 由 FireEye 共享的 IOC 信息
* [FireHOL IP Lists](https://iplists.firehol.org/) - 针对攻击、恶意软件的更改历史、国家地图和保留政策的 350+ IP 的跟踪
* [HoneyDB](https://riskdiscovery.com/honeydb) - 社区驱动的蜜罐传感器数据收集与聚合
* [hpfeeds](https://github.com/rep/hpfeeds) - 蜜罐订阅协议
* [CERT-PA 列表](https://infosec.cert-pa.it/analyze/statistics.html) ([IP](https://infosec.cert-pa.it/analyze/listip.txt) - [域名](https://infosec.cert-pa.it/analyze/listdomains.txt) - [URL](https://infosec.cert-pa.it/analyze/listurls.txt)) - 黑名单服务
* [InQuest REPdb](https://labs.inquest.net/repdb) - 聚合来自各种开源信誉来源的 IOC 指标
* [InQuest IOCdb](https://labs.inquest.net/iocdb) - 聚合来自博客、Github 仓库与 Twitter 的 IOC 指标
* [Internet Storm Center (DShield)](https://isc.sans.edu/) - 日志和可搜索的事件数据库，并且带有 Web [API](https://dshield.org/api/)([非官方 Python 库](https://github.com/rshipp/python-dshield)).
* [malc0de](http://malc0de.com/database/) - 搜索事件数据库
* [Malware Domain List](http://www.malwaredomainlist.com/) - 搜索和分享恶意软件 URL
* [Metadefender Threat Intelligence Feed](https://www.opswat.com/developers/threat-intelligence-feed) -
  在 MetaDefender Cloud 中查询文件哈希值
* [OpenIOC](http://openioc.org/) - 威胁情报共享框架
* [Ransomware overview](https://docs.google.com/spreadsheets/d/1TWS238xacAto-fLKh1n5uTsdijWdCEsGIM0Y0Hvmc5g/pubhtml) - 勒索软件的概述列表
* [STIX - Structured Threat Information eXpression](http://stix.mitre.org/) - 通过标准化的语言来表示、共享网络威胁信息
  [MITRE](http://mitre.org) 相关:
  - [CAPEC - 常见攻击模式枚举与分类](http://capec.mitre.org/)
  - [CybOX - 网络观测 eXpression](http://cybox.mitre.org/)
  - [MAEC - 恶意软件特征枚举与界定](http://maec.mitre.org/)
  - [TAXII - 可信的指标信息自动化交换](http://taxii.mitre.org/)
* [SystemLookup](https://www.systemlookup.com/) - SystemLookup 可以提供合法的或PUP的组件信息
* [ThreatMiner](https://www.threatminer.org/) - 威胁情报数据挖掘接口
* [threatRECON](https://threatrecon.co/) - 搜索指标，每月最多一千次
* [ThreatShare](https://threatshare.io/) - C2 面板跟踪
* [Yara rules](https://github.com/Yara-Rules/rules) - Yara 规则集
* [YETI](https://github.com/yeti-platform/yeti) - Yeti 是一个旨在组织数据中的可观察性、IOC 指标、TTP 和威胁情报
* [ZeuS Tracker](https://zeustracker.abuse.ch/blocklist.php) - ZeuS 黑名单

## 检测与分类

*反病毒和其他恶意软件识别工具*

* [AnalyzePE](https://github.com/hiddenillusion/AnalyzePE) - Windows PE 文件的分析器
* [Assemblyline](https://cybercentrecanada.github.io/assemblyline4_docs/) - 大规模分布式文件分析框架
* [BinaryAlert](https://github.com/airbnb/binaryalert) - 开源、无服务 AWS 管道，用于对上传的文件使用 YARA 进行扫描和报警
* [capa](https://github.com/fireeye/capa) - 检测可执行文件的攻击能力
* [chkrootkit](http://www.chkrootkit.org/) - 本地 Linux rootkit 检测
* [ClamAV](http://www.clamav.net/) - 开源反病毒引擎
* [Detect It Easy(DiE)](https://github.com/horsicq/Detect-It-Easy) - 用于确定文件类型的程序
* [Exeinfo PE](http://exeinfo.pe.hu/) - 加壳、压缩检测工具，带有脱壳信息
* [ExifTool](https://sno.phy.queensu.ca/~phil/exiftool/) - 读、写、编辑文件的元数据
* [File Scanning Framework](http://www.sno.phy.queensu.ca/%7Ephil/exiftool/) - 模块化的递归文件扫描解决方案
* [Generic File Parser](https://github.com/uppusaikiran/generic-parser) - 单个库解析工具，用来提取元数据、进行静态分析与检测文件内的宏
* [hashdeep](https://github.com/jessek/hashdeep) - 用各种算法计算哈希值
* [HashCheck](https://github.com/gurnec/HashCheck) - 可使用各种算法计算哈希值的 Windows shell 扩展
* [Loki](https://github.com/Neo23x0/Loki) - 基于主机的 IOC 扫描器
* [Malfunction](https://github.com/Dynetics/Malfunction) - 在功能层面对恶意软件进行分类和比较
* [Manalyze](https://github.com/JusticeRage/Manalyze) - PE 文件的静态分析工具
* [MASTIFF](https://github.com/KoreLogicSecurity/mastiff) - 静态分析框架
* [MultiScanner](https://github.com/MITRECND/multiscanner) - 模块化文件扫描/分析框架
* [Nauz File Detector(NFD)](https://github.com/horsicq/Nauz-File-Detector) - 跨平台（Windows、Linux、MacOS）的链接器/编译器检测
* [nsrllookup](https://github.com/rjhansen/nsrllookup) - 查询 NIST's National Software Reference Library 数据库中哈希的工具
* [packerid](http://handlers.sans.org/jclausing/packerid.py) - 跨平台的 PEiD 的替代品
* [PE-bear](https://hshrzd.wordpress.com/pe-bear/) - PE 文件的逆向工具
* [PEframe](https://github.com/guelfoweb/peframe) - PEframe 可以对 PE 文件与 Office 文档文件进行静态分析
* [PEV](http://pev.sourceforge.net/) - 为正确分析可疑的二进制文件提供功能丰富工具的 PE 文件多平台分析工具集
* [PortEx](https://github.com/katjahahn/PortEx) - 聚焦于与 PE 文件相关恶意软件分析的 Java 库
* [Quark-Engine](https://github.com/quark-engine/quark-engine) - 能够对抗混淆的 Android 恶意软件评估系统
* [Rootkit Hunter](http://rkhunter.sourceforge.net/) - 检测 Linux 的 rootkits
* [ssdeep](https://ssdeep-project.github.io/ssdeep/) - 计算模糊哈希值
* [totalhash.py](https://gist.github.com/malc0de/10270150) - 一个简单搜索[TotalHash.com](http://totalhash.com/) 数据库的 Python 脚本
* [TrID](http://mark0.net/soft-trid-e.html) - 文件识别
* [YARA](https://plusvic.github.io/yara/) - 分析师利用的模式识别工具
* [Yara rules generator](https://github.com/Neo23x0/yarGen) - 基于恶意样本生成 yara 规则，也包含避免误报的字符串数据库
* [Yara Finder](https://github.com/uppusaikiran/yara-finder) - 使用不同 yara 规则匹配文件的简单工具，以期找到可疑指标

## 在线扫描与沙盒

*基于 Web 的多反病毒引擎扫描器和恶意软件自动分析的沙盒*

* [anlyz.io](https://sandbox.anlyz.io/) - 在线沙盒
* [any.run](https://app.any.run/) - 在线交互式沙盒
* [AndroTotal](https://andrototal.org/) - 利用多个移动反病毒软件进行免费在线分析 App
* [AVCaesar](https://avcaesar.malware.lu/) - Malware.lu 在线扫描器和恶意软件集合
* [BoomBox](https://github.com/nbeede/BoomBox) - 使用 Packer 与 Vagrant 自动部署的 Cuckoo 沙盒
* [Cryptam](http://www.cryptam.com/) - 分析可疑的 Office 文档
* [Cuckoo Sandbox](http://cuckoosandbox.org/) - 开源、自主的沙盒和自动分析系统
* [cuckoo-modified](https://github.com/brad-accuvant/cuckoo-modified) - GPL 许可证的 Cuckoo 沙盒的修改版，由于法律原因作者没有将其分支合并
* [cuckoo-modified-api](https://github.com/brad-accuvant/cuckoo-modified) - 用于控制 cuckoo-modified 沙盒的 Python API
* [DeepViz](https://www.deepviz.com/) - 通过机器学习分类来分析的多格式文件分析器
* [detux](https://github.com/detuxsandbox/detux/) - 一个用于对 Linux 恶意软件流量分析与 IOC 信息捕获的沙盒
* [DRAKVUF](https://github.com/tklengyel/drakvuf) - 动态恶意软件分析系统
* [firmware.re](http://firmware.re/) - 解包、扫描、分析绝大多数固件包
* [HaboMalHunter](https://github.com/Tencent/HaboMalHunter) - Linux平台上的自动化恶意代码分析工具.
* [Hybrid Analysis](https://www.hybrid-analysis.com/) - 由 VxSandbox 支持的在线恶意软件分析工具
* [Intezer](https://analyze.intezer.com) - 通过识别代码重用与代码相似度来检测、分析归类恶意软件
* [IRMA](http://irma.quarkslab.com/) - 异步、可定制的可疑文件分析平台
* [Joe Sandbox](https://www.joesecurity.org/) - 深度恶意软件分析
* [Jotti](https://virusscan.jotti.org/en) - 免费在线多反病毒引擎扫描器
* [Limon](https://github.com/monnappa22/Limon) - 分析 Linux 恶意软件的沙盒
* [Malheur](https://github.com/rieck/malheur) - 恶意行为的自动化沙盒分析
* [malice.io](https://github.com/maliceio/malice) - 大规模弹性恶意软件分析框架
* [malsub](https://github.com/diogo-fernan/malsub) - 提供在线恶意软件与 URL 分析服务的 Python RESTful API 框架
* [Malware config](https://malwareconfig.com/) - 从常见的恶意软件提取、解码和在线配置
* [MalwareAnalyser.io](https://malwareanalyser.io/) - 基于异常的在线恶意软件静态检测，采用启发式检测引擎，通过数据挖掘与机器学习赋能
* [Malwr](https://malwr.com/) - 免费的在线 Cuckoo 沙盒分析实例
* [MASTIFF Online](https://mastiff-online.korelogic.com/) - 在线恶意软件静态分析
* [MetaDefender Cloud](https://metadefender.opswat.com/) - 扫描文件、哈希或恶意软件的 IP 地址
* [NetworkTotal](https://www.networktotal.com/index.html) - 一个分析 pcap 文件的服务，使用配置了 EmergingThreats Pro 的Suricata 快速检测病毒、蠕虫、木马和各种恶意软件
* [Noriben](https://github.com/Rurik/Noriben) - 使用 Sysinternals Procmon 收集恶意软件在沙盒环境下的进程信息
* [PacketTotal](https://packettotal.com/) - 分析 .pcap 文件、可视化网络流量的在线引擎
* [PDF Examiner](http://www.pdfexaminer.com/) - 收集可疑的 PDF 文件
* [ProcDot](http://www.procdot.com/) - 一个可视化恶意软件分析工具集
* [Recomposer](https://github.com/secretsquirrel/recomposer) - 安全上传二进制程序到沙盒网站的辅助脚本
* [sandboxapi](https://github.com/InQuest/python-sandboxapi) - 整合多个开源、商业恶意软件沙盒的 Python 库
* [SEE](https://github.com/F-Secure/see) - 在安全环境中构建测试自动化的框架
* [SEKOIA Dropper Analysis](https://malware.sekoia.fr/) - 在线 dropper 分析，支持 Js、VBScript, Microsoft Office, PDF
* [VirusTotal](https://www.virustotal.com/) - 免费的在线恶意软件样本和 URL 分析
* [Visualize_Logs](https://github.com/keithjjones/visualize_logs) - 用于日志的开源可视化库和命令行工具（Cuckoo、Procmon 等）
* [Zeltser's List](https://zeltser.com/automated-malware-analysis/) - Lenny Zeltser 创建的免费自动沙盒服务

## 域名分析

*检查域名和 IP 地址*

* [AbuseIPDB](https://www.abuseipdb.com/) - AbuseIPDB 是一个旨在帮助防御攻击蔓延、垃圾邮件传播与互联网滥用活动的项目
* [badips.com](https://www.badips.com/) - 基于 IP 黑名单服务的社区
* [boomerang](https://github.com/EmersonElectricCo/boomerang) - 旨在安全地捕获网络资源而设计的工具
* [Cymon](https://cymon.io/) - 威胁情报跟踪、具有 IP、域名、哈希值搜索功能
* [Desenmascara.me](http://desenmascara.me) - 一键点击即可得到尽可能多的检索元数据以评估一个网站的信誉度
* [Dig](http://networking.ringofsaturn.com/) - 免费的在线 dig 以及其他网络工具
* [dnstwist](https://github.com/elceef/dnstwist) - 用于检测钓鱼网站和公司间谍活动的域名排名网站
* [IPinfo](https://github.com/hiddenillusion/IPinfo) - 通过搜索在线资源收集关于 IP 或 域名的信息
* [Machinae](https://github.com/hurricanelabs/machinae) - 类似 Automator 的 OSINT 工具，用于收集有关 URL、IP 或哈希的信息
* [mailchecker](https://github.com/FGRibreau/mailchecker) - 跨语言临时邮件检测库
* [MaltegoVT](https://github.com/michael-yip/MaltegoVT) - 让 Maltego 使用 VirusTotal API，允许搜索域名、IP 地址、文件哈希、报告
* [Multi rbl](http://multirbl.valli.org/) - 多个 DNS 黑名单，反向查找超过 300 个 RBL
* [NormShield Services](https://services.normshield.com/) - 用于检测潜在的钓鱼域名、黑名单中的 IP 地址与非法账户
* [PhishStats](https://phishstats.info/) - 搜索IP、域名和网站标题的钓鱼统计信息
* [Spyse](https://spyse.com/) - 子域名、whois、相关域名、DNS、主机自治域、证书信息
* [SecurityTrails](https://securitytrails.com/) - 历史与当前WHOIS、DNS数据，相似域名、证书信息以及其他与域名和 IP 相关的数据
* [SpamCop](https://www.spamcop.net/bl.shtml) - 垃圾邮件 IP 黑名单IP
* [SpamHaus](http://www.spamhaus.org/lookup/) - 基于域名和 IP 的黑名单
* [Sucuri SiteCheck](https://sitecheck.sucuri.net/) - 免费的网站恶意软件与安全扫描器
* [Talos Intelligence](https://talosintelligence.com/) - 搜索 IP、域名或网络的所有者
* [TekDefense Automator](http://www.tekdefense.com/automater/) - 收集关于 URL、IP 和哈希值的 OSINT 工具
* [URLhaus](https://urlhaus.abuse.ch/) - 由abuse.ch所支撑的项目，旨在提供用于分发恶意软件的URL列表
* [URLQuery](http://urlquery.net/) - 免费的 URL 扫描器
* [urlscan.io](https://urlscan.io/) - 免费 URL 扫描器与域名信息
* [Whois](http://whois.domaintools.com/) - DomainTools 家免费的 whois 搜索
* [Zeltser's List](https://zeltser.com/lookup-malicious-websites/) - 由 Lenny Zeltser 整理的免费在线恶意软件工具集
* [ZScalar Zulu](https://zulu.zscaler.com/#) - Zulu URL 风险分析

## 浏览器恶意软件

*分析恶意 URL，也可以参考 [domain analysis](#domain-analysis) 和 [documents and shellcode](#documents-and-shellcode) 部分*

* [Firebug](https://getfirebug.com/) - Firefox Web 开发扩展
* [Java Decompiler](http://jd.benow.ca/) - 反编译并检查 Java 的应用
* [Java IDX Parser](https://github.com/Rurik/Java_IDX_Parser/) - 解析 Java IDX 缓存文件
* [JSDetox](http://www.relentless-coding.com/projects/jsdetox/) - JavaScript 恶意软件分析工具
* [jsunpack-n](https://github.com/urule99/jsunpack-n) - 一个 javascript 解压软件，可以模拟浏览器功能
* [Krakatau](https://github.com/Storyyeller/Krakatau) - Java 的反编译器、汇编器与反汇编器
* [Malzilla](http://malzilla.sourceforge.net/) - 分析恶意 Web 页面
* [RABCDAsm](https://github.com/CyberShadow/RABCDAsm) - 一个健壮的 ActionScript 字节码反汇编
* [SWF Investigator](https://labs.adobe.com/technologies/swfinvestigator/) - SWF 应用程序的静态、动态分析
* [swftools](http://www.swftools.org/) - PDF 转换成 SWF 的工具
* [xxxswf](http://hooked-on-mnemonics.blogspot.com/2011/12/xxxswfpy.html) - 分析 Flash 文件的 Python 脚本

## 文档和 Shellcode

*在 PDF、Office 文档中分析恶意 JS 和 Shellcode，也可参考[browser malware](#browser-malware) 部分*

* [AnalyzePDF](https://github.com/hiddenillusion/AnalyzePDF) - 分析 PDF 并尝试判断其是否是恶意文件的工具
* [box-js](https://github.com/CapacitorSet/box-js) - 用于研究 JavaScript 恶意软件的工具，支持 JScript/WScript 和 ActiveX 仿真功能
* [diStorm](http://www.ragestorm.net/distorm/) - 分析恶意 Shellcode 的反汇编器
* [JS Beautifier](http://jsbeautifier.org/) - JavaScript 脱壳和去混淆
* [libemu](http://libemu.carnivore.it/) - x86 shellcode 仿真的库和工具
* [malpdfobj](https://github.com/9b/malpdfobj) - 解构恶意 PDF 为 JSON 表示
* [OfficeMalScanner](http://www.reconstructer.org/code.html) - 扫描 MS Office 文档中的恶意跟踪
* [olevba](http://www.decalage.info/python/olevba) - 解析 OLE 和 OpenXML 文档，并提取有用信息的脚本
* [Origami PDF](https://code.google.com/p/origami-pdf/) - 一个分析恶意 PDF 的工具
* [PDF Tools](http://blog.didierstevens.com/programs/pdf-tools/) - Didier Stevens 开发的许多关于 PDF 的工具
* [PDF X-Ray Lite](https://github.com/9b/pdfxray_lite) - PDF 分析工具，PDF X-RAY 的无后端版本
* [peepdf](http://eternal-todo.com/tools/peepdf-pdf-analysis-tool) - 用来探索可能是恶意的 PDF 的 Python 工具
* [QuickSand](https://www.quicksand.io/) - QuickSand 是一个紧凑的 C 框架，用于分析可疑的恶意软件文档，以识别不同编码流中的漏洞，并定位和提取嵌入的可执行文件
* [Spidermonkey](https://developer.mozilla.org/en-US/docs/Mozilla/Projects/SpiderMonkey) - Mozilla 的 JavaScript 引擎，用来调试可疑 JS 代码

## 文件提取

*从硬盘和内存镜像中提取文件*

* [bulk_extractor](https://github.com/simsong/bulk_extractor) - 快速文件提取工具
* [EVTXtract](https://github.com/williballenthin/EVTXtract) - 从原始二进制数据提取 Windows 事件日志文件
* [Foremost](http://foremost.sourceforge.net/) - 由 US Air Force 设计的文件提取工具
* [hachoir3](https://github.com/vstinner/hachoir3) - 处理二进制程序的 Python 库的集合
* [Scalpel](https://github.com/sleuthkit/scalpel) - 另一个数据提取工具
* [SFlock](https://github.com/jbremer/sflock) - 嵌套提取/解压文档（Cuckoo 沙盒使用）

## 去混淆

*破解异或或其它代码混淆方法*

* [Balbuzard](https://bitbucket.org/decalage/balbuzard/wiki/Home) - 去除混淆(XOR、ROL等)的恶意软件分析工具
* [de4dot](https://github.com/0xd4d/de4dot) - .NET 去混淆与脱壳
* [ex_pe_xor](http://hooked-on-mnemonics.blogspot.com/2014/04/expexorpy.html) 和 [iheartxor](http://hooked-on-mnemonics.blogspot.com/p/iheartxor.html) - Alexander Hanel 开发的用于去除单字节异或编码的文件的两个工具
* [FLOSS](https://github.com/fireeye/flare-floss) - FireEye 实验室的混淆字符串求解工具，使用高级静态分析技术来自动去除恶意软件二进制文件中的字符串
* [NoMoreXOR](https://github.com/hiddenillusion/NoMoreXOR) - 通过频率分析来猜测一个 256 字节的异或密钥
* [PackerAttacker](https://github.com/BromiumLabs/PackerAttacker) - Windows 恶意软件的通用隐藏代码提取程序
* [un{i}packer](https://github.com/unipacker/unipacker) - 基于模拟器的自动、平台无关的 Windows 程序脱壳器
* [unpacker](https://github.com/malwaremusings/unpacker/) - 基于 WinAppDbg 的自动 Windows 恶意软件脱壳器
* [unxor](https://github.com/tomchop/unxor/) - 通过已知明文攻击来猜测一个异或密钥
* [VirtualDeobfuscator](https://github.com/jnraber/VirtualDeobfuscator) - 虚拟逆向分析工具
* [XORBruteForcer](http://eternal-todo.com/var/scripts/xorbruteforcer) - 爆破单字节异或密钥的 Python 脚本
* [XORSearch 和 XORStrings](http://blog.didierstevens.com/programs/xorsearch/) - Didier Stevens 开发的用于寻找异或混淆后数据的两个工具
* [xortool](https://github.com/hellman/xortool) - 猜测异或密钥和密钥的长度

## 调试和逆向工程

*反编译器、调试器和其他静态、动态分析工具*

* [angr](https://github.com/angr/angr) - UCSB 的安全实验室开发的跨平台二进制分析框架
* [bamfdetect](https://github.com/bwall/bamfdetect) - 识别和提取奇迹人和其他恶意软件的信息
* [BAP](https://github.com/BinaryAnalysisPlatform/bap) - CMU 的安全实验室开发的跨平台开源二进制分析框架
* [BARF](https://github.com/programa-stic/barf-project) - 跨平台、开源二进制分析逆向框架
* [binnavi](https://github.com/google/binnavi) - 基于图形可视化的二进制分析 IDE
* [Binary ninja](https://binary.ninja/) - 可替换 IDA 的逆向工程平台
* [Binwalk](http://binwalk.org/) - 固件分析工具
* [BluePill](https://github.com/season-lab/bluepill) - 用于执行和调试逃避型恶意软件和受保护的可执行文件的框架
* [Capstone](https://github.com/aquynh/capstone) - 二进制分析反汇编框架，支持多种架构和许多语言
* [codebro](https://github.com/hugsy/codebro) - 使用 clang 提供基础代码分析的 Web 端代码浏览器
* [Cutter](https://github.com/radareorg/cutter) - Radare2 的 GUI
* [DECAF (Dynamic Executable Code Analysis Framework)](https://github.com/sycurelab/DECAF)
  - 基于 QEMU 的二进制分析平台，DroidScope 是 DECAF 的扩展
* [dnSpy](https://github.com/0xd4d/dnSpy) - .NET 编辑器、编译器、调试器
* [dotPeek](https://www.jetbrains.com/decompiler/) - 免费 .NET 反编译与汇编浏览器
* [Evan's Debugger (EDB)](http://codef00.com/projects#debugger) - Qt GUI 程序的模块化调试器
* [Fibratus](https://github.com/rabbitstack/fibratus) - 探索、跟踪 Windows 内核的工具
* [FPort](http://www.mcafee.com/us/downloads/free-tools/fport.aspx#) - 实时查看系统中打开的 TCP/IP 和 UDP 端口，并映射到应用程序
* [GDB](http://www.sourceware.org/gdb/) - GNU 调试器
* [GEF](https://github.com/hugsy/gef) - 针对开发人员和逆向工程师的 GDB 增强版
* [hackers-grep](https://github.com/codypierce/hackers-grep) - 用来搜索 PE 程序中的导入表、导出表、字符串、调试符号
* [Hopper](https://www.hopperapp.com/) - macOS 和 Linux 反汇编器
* [IDA Pro](https://www.hex-rays.com/products/ida/index.shtml) - Windows 反汇编和调试器，有免费评估版
* [IDR](https://github.com/crypto2011/IDR) - Interactive Delphi Reconstructor 是用于 Delphi 可执行程序与动态库的反编译器
* [Immunity Debugger](http://debugger.immunityinc.com/) - 带有 Python API 的恶意软件调试器
* [ILSpy](http://ilspy.net/) - ILSpy 开源的 .NET 汇编浏览器与反编译器
* [Kaitai Struct](http://kaitai.io/) - 用于文件格式/网络协议/数据结构的逆向工程，用于 C++, C#, Java, JavaScript, Perl, PHP, Python, Ruby 的代码生成
* [LIEF](https://lief.quarkslab.com/) - LIEF 提供了一个跨平台的解析、修改、抽象 ELF、PE、MachO 格式的库
* [ltrace](http://ltrace.org/) - Linux 可执行文件的动态分析
* [mac-a-mal](https://github.com/phdphuc/mac-a-mal) - 用于恶意软件搜索的自动化框架
* [objdump](https://en.wikipedia.org/wiki/Objdump) - GNU 工具集的一部分，面向 Linux 二进制程序的静态分析
* [OllyDbg](http://www.ollydbg.de/) - Windows 可执行程序汇编级调试器
* [PANDA](https://github.com/moyix/panda) - 动态分析平台
* [PEDA](https://github.com/longld/peda) - 基于 GDB 的 Pythton Exploit 开发辅助工具，增强显示及增强的命令
* [pestudio](https://winitor.com/) - Windows 可执行程序的静态分析
* [Pharos](https://github.com/cmu-sei/pharos) - 二进制文件自动静态分析的二进制分析框架
* [plasma](https://github.com/joelpx/plasma) - 面向 x86/ARM/MIPS 的交互式反汇编器
* [PPEE (puppy)](https://www.mzrst.com/) - 专业的 PE 文件资源管理器
* [Process Explorer](https://technet.microsoft.com/en-us/sysinternals/processexplorer.aspx) - 高级 Windows 任务管理器
* [Process Hacker](http://processhacker.sourceforge.net/) - 监控系统资源的工具
* [Process Monitor](https://docs.microsoft.com/sysinternals/downloads/procmon) - Windows 下高级程序监控工具
* [PSTools](https://docs.microsoft.com/sysinternals/downloads/pstools) - 可以帮助管理员实时管理系统的 Windows 命令行工具
* [Pyew](https://github.com/joxeankoret/pyew) - 恶意软件分析的 Python 工具
* [PyREBox](https://github.com/Cisco-Talos/pyrebox) - 思科 Talos 团队出品的 Python 脚本化逆向工程沙盒
* [QKD](https://github.com/ispras/qemu/releases/) - 嵌入 WinDbg 实现隐形调试的 QEMU
* [Radare2](http://www.radare.org/r/) - 带有调试器支持的逆向工程框架
* [RegShot](https://sourceforge.net/projects/regshot/) - 利用快照实现注册表比较
* [RetDec](https://retdec.com/) - 可重定向的机器码反编译器，同时有[在线反编译服务](https://retdec.com/decompilation/)和 [API](https://retdec.com/api/)
* [ROPMEMU](https://github.com/vrtadmin/ROPMEMU) - 分析、解析、反编译复杂的代码重用攻击的框架
* [SMRT](https://github.com/pidydx/SMRT) - Sublime 3 中辅助恶意软件分析的插件
* [strace](http://sourceforge.net/projects/strace/) - Linux 可执行文件的动态分析
* [StringSifter](https://github.com/fireeye/stringsifter) - 基于恶意相关性进行自动字符串排序的机器学习工具
* [Triton](http://triton.quarkslab.com/) - 一个动态二进制分析框架
* [Udis86](https://github.com/vmt/udis86) - x86 和 x86_64 的反汇编库和工具
* [Vivisect](https://github.com/vivisect/vivisect) - 恶意软件分析的 Python 工具
* [WinDbg](https://developer.microsoft.com/en-us/windows/hardware/download-windbg) - 用于 Windows 操作系统的多用途调试器，可以调试用户态应用程序、设备驱动程序与内核转储
* [X64dbg](https://github.com/x64dbg/) - Windows 的一个开源 x64/x32 调试器

## 网络

*分析网络交互*

* [Bro](https://www.bro.org) - 支持惊人规模的文件和网络协议的协议分析工具
* [BroYara](https://github.com/hempnall/broyara) - 基于 Bro 的 Yara 规则集
* [CapTipper](https://github.com/omriher/CapTipper) -  恶意 HTTP 流量管理器
* [chopshop](https://github.com/MITRECND/chopshop) - 协议分析和解码框架
* [CloudShark](https://www.cloudshark.org) - 基于 Web 的数据包分析与恶意流量检测工具
* [FakeNet-NG](https://github.com/fireeye/flare-fakenet-ng) - 下一代动态网络分析工具
* [Fiddler](http://www.telerik.com/fiddler) - 专为 Web 调试开发的 Web 代理
* [Hale](https://github.com/pjlantz/Hale) - 僵尸网络 C&C 监视器
* [Haka](http://www.haka-security.org/) - 一个安全导向的开源语言，用于在实时流量捕获时描述协议、应用安全策略
* [HTTPReplay](https://github.com/jbremer/httpreplay) - 解析 PCAP 文件的库，包括使用 TLS 主密钥（用于 Cuckoo）的 TLS 流
* [INetSim](http://www.inetsim.org/) -  网络服务模拟。建设一个恶意软件分析实验室十分有用
* [Laika BOSS](https://github.com/lmco/laikaboss) - Laika BOSS 是一种以文件为中心的恶意软件分析和入侵检测系统
* [Malcom](https://github.com/tomchop/malcom) - 恶意软件通信分析仪
* [Maltrail](https://github.com/stamparm/maltrail) - 一个恶意流量检测系统，利用公开的黑名单来检测恶意和可疑的通信流量，带有一个报告和分析界面
* [mitmproxy](https://mitmproxy.org/) - 拦截网络流量通信
* [Moloch](https://github.com/aol/moloch) - IPv4 流量捕获，带有索引和数据库系统
* [NetworkMiner](http://www.netresec.com/?page=NetworkMiner) - 有免费版本的网络取证分析工具
* [ngrep](https://github.com/jpr5/ngrep) - 像 grep 一样收集网络流量
* [PcapViz](https://github.com/mateuszk87/PcapViz) - 网络拓扑与流量可视化
* [Python ICAP Yara](https://github.com/RamadhanAmizudin/python-icap-yara) - 带有 YARA 扫描器的 ICAP 服务器，用于 URL 或内容
* [Squidmagic](https://github.com/ch3k1/squidmagic) - 用于分析基于 Web 的网络流量，使用 Squid 代理服务器和 Spamhaus 检测 C&C 服务器和恶意网站
* [Tcpdump](http://www.tcpdump.org/) - 收集网络流
* [tcpick](http://tcpick.sourceforge.net/) - 从网络流量中重构 TCP 流
* [tcpxtract](http://tcpxtract.sourceforge.net/) - 从网络流量中提取文件
* [Wireshark](https://www.wireshark.org/) - 网络流量分析工具

## 内存取证

*在内存映像或正在运行的系统中分析恶意软件的工具*

* [BlackLight](https://www.blackbagtech.com/blacklight.html) - 支持 hiberfil、pagefile 与原始内存分析的 Windows / MacOS 取证客户端
* [DAMM](https://github.com/504ensicsLabs/DAMM) - 基于 Volatility 的内存中恶意软件的差异分析
* [evolve](https://github.com/JamesHabben/evolve) - 用于 Volatility Memory 取证框架的 Web 界面
* [FindAES](http://jessekornblum.livejournal.com/269749.html) - 在内存中寻找 AES 加密密钥
* [inVtero.net](https://github.com/ShaneK2/inVtero.net) - .NET 开发的高速内存分析框架，支持所有 Windows x64 平台，包括代码完整性和写入支持
* [Muninn](https://github.com/ytisf/muninn) - 一个使用 Volatility 的自动化分析脚本，可以生成一份可读报告
* [Rekall](http://www.rekall-forensic.com/) - 内存分析框架，2013 年 Volatility 的分支版本
* [TotalRecall](https://github.com/sketchymoose/TotalRecall) - 基于 Volatility 自动执行多恶意样本分析任务的脚本
* [VolDiff](https://github.com/aim4r/VolDiff) - 在恶意软件执行前后，在内存映像中运行 Volatility 并生成对比报告
* [Volatility](https://github.com/volatilityfoundation/volatility) - 先进的内存取证框架
* [VolUtility](https://github.com/kevthehermit/VolUtility) - Volatility 内存分析框架的 Web 接口
* [WDBGARK](https://github.com/swwwolf/wdbgark) - WindDBG 反 Rootkit 扩展
* [WinDbg](https://msdn.microsoft.com/en-us/windows/hardware/hh852365) - Windows 系统的实时内存检查和内核调试工具

## Windows 神器

* [AChoir](https://github.com/OMENScan/AChoir) - 一个用来收集 Windows 实时事件响应脚本集
* [python-evt](https://github.com/williballenthin/python-evt) - 用来解析 Windows 事件日志的 Python 库
* [python-registry](http://www.williballenthin.com/registry/) - 用于解析注册表文件的 Python 库
* [RegRipper](https://regripper.wordpress.com/) ([GitHub](https://github.com/keydet89/RegRipper2.8)) - 基于插件集的工具

## 存储和工作流

* [Aleph](https://github.com/trendmicro/aleph) - 开源恶意软件分析管道系统
* [CRITs](https://crits.github.io/) - 关于威胁、恶意软件的合作研究
* [FAME](https://certsocietegenerale.github.io/fame/) - 恶意软件分析框架，可以使用自定义模块进行扩展管道，并将它们链接起来并彼此交互以执行端到端分析
* [Malwarehouse](https://github.com/sroberts/malwarehouse) - 存储、标注与搜索恶意软件
* [Polichombr](https://github.com/ANSSI-FR/polichombr) - 一个恶意软件分析平台，旨在帮助分析师逆向恶意软件。
* [stoQ](http://stoq.punchcyber.com/) - 分布式内容分析框架，具有广泛的插件支持
* [Viper](http://viper.li/) - 分析人员的二进制管理和分析框架

## 杂项

* [al-khaser](https://github.com/LordNoteworthy/al-khaser) - 一个旨在突出反恶意软件系统的 PoC 恶意软件
* [CryptoKnight](https://github.com/AbertayMachineLearningGroup/CryptoKnight) - 自动化加密算法逆向工程与分类框架
* [DC3-MWCP](https://github.com/Defense-Cyber-Crime-Center/DC3-MWCP) - 反网络犯罪中心的恶意软件配置解析框架
* [FLARE VM](https://github.com/fireeye/flare-vm) - 用于恶意软件分析、基于 Windows 定制的安全发行版
* [MalSploitBase](https://github.com/misterch0c/malSploitBase) - 包含恶意软件利用的漏洞的数据库
* [Malware Museum](https://archive.org/details/malwaremuseum) - 收集 20 世纪八九十年代流行的恶意软件
* [Malware Organiser](https://github.com/uppusaikiran/malware-organiser) - 将大型恶意/良性文件组织到有组织的结构的工具
* [Pafish](https://github.com/a0rtega/pafish) - Paranoid Fish，与恶意软件家族的行为一致，采用多种技术来检测沙盒和分析环境的演示工具
* [REMnux](https://remnux.org/) - 面向恶意软件逆向工程师和分析人员的 Linux 发行版和 Docker 镜像
* [Santoku Linux](https://santoku-linux.com/) - 移动取证的 Linux 发行版

# 资源

## 书籍

*基础恶意软件分析阅读书单*

* [Learning Malware Analysis](https://www.packtpub.com/networking-and-servers/learning-malware-analysis) - Learning Malware Analysis: 探索 Windows 恶意软件分析领域的概念、工具与技术
* [Malware Analyst's Cookbook and DVD](https://amzn.com/dp/0470613033) - 打击恶意代码的工具和技术
* [Mastering Malware Analysis](https://www.packtpub.com/networking-and-servers/mastering-malware-analysis) - Mastering Malware Analysis: 对抗恶意软件、APT、网络犯罪与 IoT 攻击的完整指南
* [Mastering Reverse Engineering](https://www.packtpub.com/networking-and-servers/mastering-reverse-engineering) - Mastering Reverse Engineering: 逆向工程技巧
* [Practical Malware Analysis](https://amzn.com/dp/1593272901) - 剖析恶意软件的手边书
* [Practical Reverse Engineering](https://www.amzn.com/dp/1118787315/) -
  Intermediate Reverse Engineering.
* [Real Digital Forensics](https://www.amzn.com/dp/0321240693) - 计算机安全与应急响应
* [Rootkits and Bootkits](https://www.amazon.com/dp/1593277164) - Rootkits and Bootkits: 逆向现代恶意软件与下一代威胁
* [The Art of Memory Forensics](https://amzn.com/dp/1118825098) - 在 Windows、Linux 和 Mac 系统的内存中检测恶意软件和威胁
* [The IDA Pro Book](https://amzn.com/dp/1593272898) - 世界上最流行的反汇编器的非官方指南
* [The Rootkit Arsenal](https://amzn.com/dp/144962636X) - 系统黑暗角落的潜行者：The Rootkit Arsenal

## 其它

* [APT Notes](https://github.com/kbandla/APTnotes) - 一个收集 APT 相关文献的合辑
* [Ember](https://github.com/endgameinc/ember) - Endgame 恶意软件研究基准数据库，用于创建机器学习模型，模型基于静态分析的结果来进行评分
* [File Formats posters](https://github.com/corkami/pics) - 常用文件格式的可视化（包括 PE 与 ELF）
* [Honeynet Project](http://honeynet.org/) - 蜜罐工具、论文和其他资源
* [Kernel Mode](http://www.kernelmode.info/forum/) - 一个致力于恶意软件分析和内核开发的活跃社区
* [Malicious Software](https://zeltser.com/malicious-software/) - Lenny Zeltser 的恶意软件博客和资源
* [Malware Analysis Search](https://cse.google.com/cse/home?cx=011750002002865445766%3Apc60zx1rliu) - [Corey Harrell](journeyintoir.blogspot.com/) 自定义的用于恶意软件分析的 Google 搜索
* [Malware Analysis Tutorials](http://fumalwareanalysis.blogspot.nl/p/malware-analysis-tutorials-reverse.html) - 由 Xiang Fu 博士提供的恶意软件分析教程，是一个学习恶意软件分析的重要资源
* [Malware analysis, threat intelligence and reverse engineering](https://www.slideshare.net/bartblaze/malware-analysis-threat-intelligence-and-reverse-engineering) - 不需要先验知识的恶意软件分析、威胁情报和逆向工程概念介绍
* [Malware Persistence](https://github.com/Karneades/malware-persistence) - 专注于恶意软件持久化的仓库，包括检测、响应与日志收集等
* [Malware Samples and Traffic](http://malware-traffic-analysis.net/) - 此博客重点介绍与恶意软件感染相关的网络流量
* [Malware Search+++](https://addons.mozilla.org/fr/firefox/addon/malware-search-plusplusplus/) - 搜索常用恶意软件数据库的 Firefox 浏览器插件
* [Practical Malware Analysis Starter Kit](https://bluesoul.me/practical-malware-analysis-starter-kit/) - 此软件包包含 Practical Malware Analysis 书中引用的大多数软件
* [RPISEC Malware Analysis](https://github.com/RPISEC/Malware) - 2015 年秋季 Rensselaer Polytechnic Institute 的恶意软件分析课程中使用的课程材料
* [WindowsIR: Malware](http://windowsir.blogspot.com/p/malware.html) - Harlan Carvey 的恶意软件页面
* [Windows Registry specification](https://github.com/msuhanov/regf/blob/master/Windows%20registry%20file%20format%20specification.md) - Windows 注册表文件格式规范
* [/r/csirt_tools](https://www.reddit.com/r/csirt_tools/) - CSIRT 工具和资源的子版块，讲[恶意软件分析](https://www.reddit.com/r/csirt_tools/search?q=flair%3A%22Malware%20analysis%22&sort=new&restrict_sr=on)的天才
* [/r/Malware](https://www.reddit.com/r/Malware) - 恶意软件的子版块
* [/r/ReverseEngineering](https://www.reddit.com/r/ReverseEngineering) - 逆向工程子版块，不仅限于恶意软件

# 相关 Awesome 清单

* [Android Security](https://github.com/ashishb/android-security-awesome)
* [AppSec](https://github.com/paragonie/awesome-appsec)
* [CTFs](https://github.com/apsdehal/awesome-ctf)
* [Forensics](https://github.com/Cugu/awesome-forensics)
* ["Hacking"](https://github.com/carpedm20/awesome-hacking)
* [Honeypots](https://github.com/paralax/awesome-honeypots)
* [Industrial Control System Security](https://github.com/hslatman/awesome-industrial-control-system-security)
* [Incident-Response](https://github.com/meirwah/awesome-incident-response)
* [Infosec](https://github.com/onlurking/awesome-infosec)
* [PCAP Tools](https://github.com/caesar0301/awesome-pcaptools)
* [Pentesting](https://github.com/enaqx/awesome-pentest)
* [Security](https://github.com/sbilly/awesome-security)
* [Threat Intelligence](https://github.com/hslatman/awesome-threat-intelligence)
* [YARA](https://github.com/InQuest/awesome-yara)

# [做出贡献](CONTRIBUTING.md)

欢迎提出问题或者 Pull requests！请在提交 Pull request 之前阅读 [CONTRIBUTING](CONTRIBUTING.md)。

# 致谢

这个列表需要感谢如下一些人:

* Lenny Zeltser 和 REMnux 的其他开发者贡献了这个列表中很多工具
* Michail Hale Ligh、Steven Adair、Blake Hartstein 和 Mather Richard 著有 *Malware Analyst's Cookbook*，这本书为这个列表的创建提供了很大的灵感
* 每一个提交 Pull request 以及提出建议的人

十分感谢!
