# Awesome Malware Analysis [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

A curated list of awesome malware analysis tools and resources. Inspired by
<b><code>228799⭐</code></b> <b><code>&nbsp;25051🍴</code></b> [awesome-python](https://github.com/vinta/awesome-python)) and
<b><code>&nbsp;31122⭐</code></b> <b><code>&nbsp;&nbsp;5081🍴</code></b> [awesome-php](https://github.com/ziadoz/awesome-php)).

[![Drop ICE](drop.png)](https://twitter.com/githubbers/status/1182017616740663296)

- [Malware Collection](#malware-collection)
    - [Anonymizers](#anonymizers)
    - [Honeypots](#honeypots)
    - [Malware Corpora](#malware-corpora)
- [Open Source Threat Intelligence](#open-source-threat-intelligence)
    - [Tools](#tools)
    - [Other Resources](#other-resources)
- [Detection and Classification](#detection-and-classification)
- [Online Scanners and Sandboxes](#online-scanners-and-sandboxes)
- [Domain Analysis](#domain-analysis)
- [Browser Malware](#browser-malware)
- [Documents and Shellcode](#documents-and-shellcode)
- [File Carving](#file-carving)
- [Deobfuscation](#deobfuscation)
- [Debugging and Reverse Engineering](#debugging-and-reverse-engineering)
- [Network](#network)
- [Memory Forensics](#memory-forensics)
- [Windows Artifacts](#windows-artifacts)
- [Storage and Workflow](#storage-and-workflow)
- [Miscellaneous](#miscellaneous)
- [Resources](#resources)
    - [Books](#books)
    - [Other](#other)
- [Related Awesome Lists](#related-awesome-lists)
- [Contributing](#contributing)
- [Thanks](#thanks)

View Chinese translation: [恶意软件分析大合集.md](恶意软件分析大合集.md).

---

## Malware Collection

### Anonymizers

*Web traffic anonymizers for analysts.*

* [Anonymouse.org](http://anonymouse.org/) - A free, web based anonymizer.
* 🌎 [OpenVPN](openvpn.net/) - VPN software and hosting solutions.
* [Privoxy](http://www.privoxy.org/) - An open source proxy server with some
  privacy features.
* 🌎 [Tor](www.torproject.org/) - The Onion Router, for browsing the web
  without leaving traces of the client IP.

### Honeypots

*Trap and collect your own samples.*

* <b><code>&nbsp;&nbsp;1261⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;417🍴</code></b> [Conpot](https://github.com/mushorg/conpot)) - ICS/SCADA honeypot.
* <b><code>&nbsp;&nbsp;5274⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;903🍴</code></b> [Cowrie](https://github.com/micheloosterhof/cowrie)) - SSH honeypot, based
  on Kippo.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;12🍴</code></b> [DemoHunter](https://github.com/RevengeComing/DemonHunter)) - Low interaction Distributed Honeypots.
* <b><code>&nbsp;&nbsp;&nbsp;718⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;184🍴</code></b> [Dionaea](https://github.com/DinoTools/dionaea)) - Honeypot designed to trap malware.
* <b><code>&nbsp;&nbsp;&nbsp;565⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;168🍴</code></b> [Glastopf](https://github.com/mushorg/glastopf)) - Web application honeypot.
* [Honeyd](http://www.honeyd.org/) - Create a virtual honeynet.
* 🌎 [HoneyDrive](bruteforce.gr/honeydrive/) - Honeypot bundle Linux distro.
* <b><code>&nbsp;&nbsp;1230⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;174🍴</code></b> [Honeytrap](https://github.com/honeytrap/honeytrap)) - Opensource system for running, monitoring and managing honeypots.
* <b><code>&nbsp;&nbsp;2440⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;631🍴</code></b> [MHN](https://github.com/pwnlandia/mhn)) - MHN is a centralized server for management and data collection of honeypots. MHN allows you to deploy sensors quickly and to collect data immediately, viewable from a neat web interface.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;46⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;39🍴</code></b> [Mnemosyne](https://github.com/johnnykv/mnemosyne)) - A normalizer for
  honeypot data; supports Dionaea.
* <b><code>&nbsp;&nbsp;&nbsp;998⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;203🍴</code></b> [Thug](https://github.com/buffer/thug)) - Low interaction honeyclient, for
  investigating malicious websites.


### Malware Corpora

*Malware samples collected for analysis.*

* [Clean MX](http://support.clean-mx.com/clean-mx/viruses.php) - Realtime
  database of malware and malicious domains.
* [Contagio](http://contagiodump.blogspot.com/) - A collection of recent
  malware samples and analyses.
* 🌎 [Exploit Database](www.exploit-db.com/) - Exploit and shellcode
  samples.
* 🌎 [Infosec - CERT-PA](infosec.cert-pa.it/analyze/submission.html) - Malware samples collection and analysis.
* 🌎 [InQuest Labs](labs.inquest.net) - Evergrowing searchable corpus of malicious Microsoft documents.
* <b><code>&nbsp;&nbsp;&nbsp;686⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;239🍴</code></b> [Javascript Mallware Collection](https://github.com/HynekPetrak/javascript-malware-collection)) - Collection of almost 40.000 javascript malware samples
* 🌎 [Malpedia](malpedia.caad.fkie.fraunhofer.de/) - A resource providing
  rapid identification and actionable context for malware investigations.
* 🌎 [Malshare](malshare.com) - Large repository of malware actively
  scrapped from malicious sites.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;94⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25🍴</code></b> [Ragpicker](https://github.com/robbyFux/Ragpicker)) - Plugin based malware
  crawler with pre-analysis and reporting functionalities
* <b><code>&nbsp;11445⭐</code></b> <b><code>&nbsp;&nbsp;2533🍴</code></b> [theZoo](https://github.com/ytisf/theZoo)) - Live malware samples for
  analysts.
* [Tracker h3x](http://tracker.h3x.eu/) - Agregator for malware corpus tracker
  and malicious download sites.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [vduddu malware repo](https://github.com/vduddu/Malware)) - Collection of
  various malware files and source code.
* 🌎 [VirusBay](beta.virusbay.io/) - Community-Based malware repository and social network.
* [ViruSign](http://www.virussign.com/) - Malware database that detected by
  many anti malware programs except ClamAV.
* 🌎 [VirusShare](virusshare.com/) - Malware repository, registration
  required.
* [VX Vault](http://vxvault.net) - Active collection of malware samples.
* 🌎 [Zeltser's Sources](zeltser.com/malware-sample-sources/) - A list
  of malware sample sources put together by Lenny Zeltser.
* <b><code>&nbsp;&nbsp;1426⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;697🍴</code></b> [Zeus Source Code](https://github.com/Visgean/Zeus)) - Source for the Zeus
  trojan leaked in 2011.
* [VX Underground](http://vx-underground.org/) - Massive and growing collection of free malware samples.

## Open Source Threat Intelligence

### Tools

*Harvest and analyze IOCs.*

* <b><code>&nbsp;&nbsp;&nbsp;122⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;18🍴</code></b> [AbuseHelper](https://github.com/abusesa/abusehelper)) - An open-source
  framework for receiving and redistributing abuse feeds and threat intel.
* 🌎 [AlienVault Open Threat Exchange](otx.alienvault.com/) - Share and
  collaborate in developing Threat Intelligence.
* <b><code>&nbsp;&nbsp;&nbsp;657⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;171🍴</code></b> [Combine](https://github.com/mlsecproject/combine)) - Tool to gather Threat
  Intelligence indicators from publicly available sources.
* <b><code>&nbsp;&nbsp;&nbsp;119⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25🍴</code></b> [Fileintel](https://github.com/keithjjones/fileintel)) - Pull intelligence per file hash.
* <b><code>&nbsp;&nbsp;&nbsp;265⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;51🍴</code></b> [Hostintel](https://github.com/keithjjones/hostintel)) - Pull intelligence per host.
* 🌎 [IntelMQ](www.enisa.europa.eu/topics/csirt-cert-services/community-projects/incident-handling-automation) -
  A tool for CERTs for processing incident data using a message queue.
* 🌎 [IOC Editor](www.fireeye.com/services/freeware/ioc-editor.html) -
  A free editor for XML IOC files.
* <b><code>&nbsp;&nbsp;&nbsp;513⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;91🍴</code></b> [iocextract](https://github.com/InQuest/python-iocextract)) - Advanced Indicator
  of Compromise (IOC) extractor, Python library and command-line tool.
* <b><code>&nbsp;&nbsp;&nbsp;201⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [ioc_writer](https://github.com/mandiant/ioc_writer)) - Python library for
  working with OpenIOC objects, from Mandiant.
* <b><code>&nbsp;&nbsp;&nbsp;104⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;24🍴</code></b> [MalPipe](https://github.com/silascutler/MalPipe)) - Malware/IOC ingestion and
  processing engine, that enriches collected data.
* <b><code>&nbsp;&nbsp;&nbsp;228⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;60🍴</code></b> [Massive Octo Spice](https://github.com/csirtgadgets/massive-octo-spice)) -
  Previously known as CIF (Collective Intelligence Framework). Aggregates IOCs
  from various lists. Curated by the
  [CSIRT Gadgets Foundation](http://csirtgadgets.org/collective-intelligence-framework).
* <b><code>&nbsp;&nbsp;5452⭐</code></b> <b><code>&nbsp;&nbsp;1416🍴</code></b> [MISP](https://github.com/MISP/MISP)) - Malware Information Sharing
  Platform curated by [The MISP Project](http://www.misp-project.org/).
* 🌎 [Pulsedive](pulsedive.com) - Free, community-driven threat intelligence platform collecting IOCs from open-source feeds.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;18⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;7🍴</code></b> [PyIOCe](https://github.com/pidydx/PyIOCe)) - A Python OpenIOC editor.
* 🌎 [RiskIQ](community.riskiq.com/) - Research, connect, tag and
  share IPs and domains. (Was PassiveTotal.)
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;80⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;27🍴</code></b> [threataggregator](https://github.com/jpsenior/threataggregator)) -
  Aggregates security threats from a number of sources, including some of
  those listed below in [other resources](#other-resources).
* 🌎 [ThreatConnect](threatconnect.com/free/) - TC Open allows you to see and
  share open source threat data, with support and validation from our free community.
* 🌎 [ThreatCrowd](www.threatcrowd.org/) - A search engine for threats,
  with graphical visualization.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [ThreatIngestor](https://github.com/InQuest/ThreatIngestor/)) - Build
  automated threat intel pipelines sourcing from Twitter, RSS, GitHub, and
  more.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;66⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13🍴</code></b> [ThreatTracker](https://github.com/michael-yip/ThreatTracker)) - A Python
  script to monitor and generate alerts based on IOCs indexed by a set of
  Google Custom Search Engines.
* <b><code>&nbsp;&nbsp;&nbsp;173⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;43🍴</code></b> [TIQ-test](https://github.com/mlsecproject/tiq-test)) - Data visualization
  and statistical analysis of Threat Intelligence feeds.

### Other Resources

*Threat intelligence and IOC resources.*

* 🌎 [Autoshun](www.autoshun.org/)  🌎 [list](www.autoshun.org/files/shunlist.csv)) -
  Snort plugin and blocklist.
* [Bambenek Consulting Feeds](http://osint.bambenekconsulting.com/feeds/) -
  OSINT feeds based on malicious DGA algorithms.
* 🌎 [Fidelis Barncat](www.fidelissecurity.com/resources/fidelis-barncat) -
  Extensive malware config database (must request access).
* [CI Army](http://cinsscore.com/) ([list](http://cinsscore.com/list/ci-badguys.txt)) -
  Network security blocklists.
* 🌎 [Critical Stack- Free Intel Market](intel.criticalstack.com) - Free
  intel aggregator with deduplication featuring 90+ feeds and over 1.2M indicators.
* [Cybercrime tracker](http://cybercrime-tracker.net/) - Multiple botnet active tracker.
* <b><code>&nbsp;&nbsp;&nbsp;465⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;117🍴</code></b> [FireEye IOCs](https://github.com/fireeye/iocs)) - Indicators of Compromise
  shared publicly by FireEye.
* 🌎 [FireHOL IP Lists](iplists.firehol.org/) - Analytics for 350+ IP lists
  with a focus on attacks, malware and abuse. Evolution, Changes History,
  Country Maps, Age of IPs listed, Retention Policy, Overlaps.
* 🌎 [HoneyDB](riskdiscovery.com/honeydb) - Community driven honeypot sensor data collection and aggregation.
* <b><code>&nbsp;&nbsp;&nbsp;213⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;110🍴</code></b> [hpfeeds](https://github.com/rep/hpfeeds)) - Honeypot feed protocol.
* 🌎 [Infosec - CERT-PA lists](infosec.cert-pa.it/analyze/statistics.html)  🌎 [IPs](infosec.cert-pa.it/analyze/listip.txt) - 🌎 [Domains](infosec.cert-pa.it/analyze/listdomains.txt) - 🌎 [URLs](infosec.cert-pa.it/analyze/listurls.txt)) - Blocklist service.
* 🌎 [InQuest REPdb](labs.inquest.net/repdb) - Continuous aggregation of IOCs from a variety of open reputation sources.
* 🌎 [InQuest IOCdb](labs.inquest.net/iocdb) - Continuous aggregation of IOCs from a variety of blogs, Github repos, and Twitter.
* 🌎 [Internet Storm Center (DShield)](isc.sans.edu/) - Diary and
  searchable incident database, with a web 🌎 [API](dshield.org/api/).
  (<b><code>&nbsp;&nbsp;&nbsp;&nbsp;29⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13🍴</code></b> [unofficial Python library](https://github.com/rshipp/python-dshield))).
* [malc0de](http://malc0de.com/database/) - Searchable incident database.
* [Malware Domain List](http://www.malwaredomainlist.com/) - Search and share
  malicious URLs.
* 🌎 [MetaDefender Threat Intelligence Feed](www.opswat.com/developers/threat-intelligence-feed) -
  List of the most looked up file hashes from MetaDefender Cloud.
* 🌎 [OpenIOC](www.fireeye.com/services/freeware.html) - Framework for sharing threat intelligence.
* 🌎 [Proofpoint Threat Intelligence](www.proofpoint.com/us/products/et-intelligence) -
  Rulesets and more. (Formerly Emerging Threats.)
* 🌎 [Ransomware overview](docs.google.com/spreadsheets/d/1TWS238xacAto-fLKh1n5uTsdijWdCEsGIM0Y0Hvmc5g/pubhtml) -
  A list of ransomware overview with details, detection and prevention.
* [STIX - Structured Threat Information eXpression](http://stixproject.github.io) -
  Standardized language to represent and share cyber threat information.
  Related efforts from 🌎 [MITRE](www.mitre.org/):
  - [CAPEC - Common Attack Pattern Enumeration and Classification](http://capec.mitre.org/)
  - [CybOX - Cyber Observables eXpression](http://cyboxproject.github.io)
  - [MAEC - Malware Attribute Enumeration and Characterization](http://maec.mitre.org/)
  - [TAXII - Trusted Automated eXchange of Indicator Information](http://taxiiproject.github.io)
* 🌎 [SystemLookup](www.systemlookup.com/) - SystemLookup hosts a collection of lists that provide information on
  the components of legitimate and potentially unwanted programs.
* 🌎 [ThreatMiner](www.threatminer.org/) - Data mining portal for threat
  intelligence, with search.
* 🌎 [threatRECON](threatrecon.co/) - Search for indicators, up to 1000
  free per month.
* 🌎 [ThreatShare](threatshare.io/) - C2 panel tracker
* <b><code>&nbsp;&nbsp;4225⭐</code></b> <b><code>&nbsp;&nbsp;1009🍴</code></b> [Yara rules](https://github.com/Yara-Rules/rules)) - Yara rules repository.
* <b><code>&nbsp;&nbsp;1770⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;294🍴</code></b> [YETI](https://github.com/yeti-platform/yeti)) - Yeti is a platform meant to organize observables, indicators of compromise, TTPs, and knowledge on threats in a single, unified repository.
* 🌎 [ZeuS Tracker](zeustracker.abuse.ch/blocklist.php) - ZeuS
  blocklists.

## Detection and Classification

*Antivirus and other malware identification tools*

* <b><code>&nbsp;&nbsp;&nbsp;204⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;35🍴</code></b> [AnalyzePE](https://github.com/hiddenillusion/AnalyzePE)) - Wrapper for a
  variety of tools for reporting on Windows PE files.
* 🌎 [Assemblyline](cybercentrecanada.github.io/assemblyline4_docs/) - A scalable file triage and malware analysis system integrating the cyber security community's best tools..
* <b><code>&nbsp;&nbsp;1417⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;186🍴</code></b> [BinaryAlert](https://github.com/airbnb/binaryalert)) - An open source, serverless
  AWS pipeline that scans and alerts on uploaded files based on a set of
  YARA rules.
* <b><code>&nbsp;&nbsp;4976⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;567🍴</code></b> [capa](https://github.com/fireeye/capa)) - Detects capabilities in executable files.
* [chkrootkit](http://www.chkrootkit.org/) - Local Linux rootkit detection.
* [ClamAV](http://www.clamav.net/) - Open source antivirus engine.
* <b><code>&nbsp;&nbsp;7847⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;738🍴</code></b> [Detect It Easy(DiE)](https://github.com/horsicq/Detect-It-Easy)) - A program for
  determining types of files.
* [Exeinfo PE](http://exeinfo.pe.hu/) - Packer, compressor detector, unpack
  info, internal exe tools.
* 🌎 [ExifTool](sno.phy.queensu.ca/~phil/exiftool/) - Read, write and
  edit file metadata.
* <b><code>&nbsp;&nbsp;&nbsp;290⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;49🍴</code></b> [File Scanning Framework](https://github.com/EmersonElectricCo/fsf)) -
  Modular, recursive file scanning solution.
* <b><code>&nbsp;&nbsp;1573⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;192🍴</code></b> [fn2yara](https://github.com/cmu-sei/pharos)) - FN2Yara is a tool to generate
  Yara signatures for matching functions (code) in an executable program.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [Generic File Parser](https://github.com/uppusaikiran/generic-parser)) - A Single Library Parser to extract meta information,static analysis and detect macros within the files.
* <b><code>&nbsp;&nbsp;&nbsp;718⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;132🍴</code></b> [hashdeep](https://github.com/jessek/hashdeep)) - Compute digest hashes with
  a variety of algorithms.
* <b><code>&nbsp;&nbsp;1779⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;195🍴</code></b> [HashCheck](https://github.com/gurnec/HashCheck)) - Windows shell extension
  to compute hashes with a variety of algorithms.
* <b><code>&nbsp;&nbsp;3430⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;585🍴</code></b> [Loki](https://github.com/Neo23x0/Loki)) - Host based scanner for IOCs.
* <b><code>&nbsp;&nbsp;&nbsp;192⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;35🍴</code></b> [Malfunction](https://github.com/Dynetics/Malfunction)) - Catalog and
  compare malware at a function level.
* <b><code>&nbsp;&nbsp;1026⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;161🍴</code></b> [Manalyze](https://github.com/JusticeRage/Manalyze)) - Static analyzer for PE
executables.
* <b><code>&nbsp;&nbsp;&nbsp;176⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;40🍴</code></b> [MASTIFF](https://github.com/KoreLogicSecurity/mastiff)) - Static analysis
  framework.
* <b><code>&nbsp;&nbsp;&nbsp;618⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;125🍴</code></b> [MultiScanner](https://github.com/mitre/multiscanner)) - Modular file
  scanning/analysis framework
* <b><code>&nbsp;&nbsp;&nbsp;533⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;80🍴</code></b> [Nauz File Detector(NFD)](https://github.com/horsicq/Nauz-File-Detector)) - Linker/Compiler/Tool detector  for Windows, Linux and MacOS.
* <b><code>&nbsp;&nbsp;&nbsp;112⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;10🍴</code></b> [nsrllookup](https://github.com/rjhansen/nsrllookup)) - A tool for looking
  up hashes in NIST's National Software Reference Library database.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;42⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;9🍴</code></b> [packerid](https://github.com/sooshie/packerid)) - A cross-platform
  Python alternative to PEiD.
* 🌎 [PE-bear](hshrzd.wordpress.com/pe-bear/) - Reversing tool for PE
  files.
* <b><code>&nbsp;&nbsp;&nbsp;612⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;139🍴</code></b> [PEframe](https://github.com/guelfoweb/peframe)) - PEframe is an open source tool to perform static analysis on Portable Executable malware and malicious MS Office documents.
* [PEV](http://pev.sourceforge.net/) - A multiplatform toolkit to work with PE
  files, providing feature-rich tools for proper analysis of suspicious binaries.
* <b><code>&nbsp;&nbsp;&nbsp;499⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;95🍴</code></b> [PortEx](https://github.com/katjahahn/PortEx)) - Java library to analyse PE files with a special focus on malware analysis and PE malformation robustness.
* <b><code>&nbsp;&nbsp;1346⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;170🍴</code></b> [Quark-Engine](https://github.com/quark-engine/quark-engine)) - An Obfuscation-Neglect Android Malware Scoring System
* [Rootkit Hunter](http://rkhunter.sourceforge.net/) - Detect Linux rootkits.
* 🌎 [ssdeep](ssdeep-project.github.io/ssdeep/) - Compute fuzzy hashes.
* 🌎 [totalhash.py](gist.github.com/gleblanc1783/3c8e6b379fa9d646d401b96ab5c7877f) -
  Python script for easy searching of the 🌎 [TotalHash.cymru.com](totalhash.cymru.com/)
  database.
* [TrID](http://mark0.net/soft-trid-e.html) - File identifier.
* 🌎 [YARA](plusvic.github.io/yara/) - Pattern matching tool for
  analysts.
* <b><code>&nbsp;&nbsp;1578⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;282🍴</code></b> [Yara rules generator](https://github.com/Neo23x0/yarGen)) - Generate
  yara rules based on a set of malware samples. Also contains a good
  strings DB to avoid false positives.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [Yara Finder](https://github.com/uppusaikiran/yara-finder)) - A simple tool to yara match the file against various yara rules to find the indicators of suspicion.


## Online Scanners and Sandboxes

*Web-based multi-AV scanners, and malware sandboxes for automated analysis.*

* 🌎 [anlyz.io](sandbox.anlyz.io/) - Online sandbox.
* 🌎 [any.run](app.any.run/) - Online interactive sandbox.
* 🌎 [AndroTotal](andrototal.org/) - Free online analysis of APKs
  against multiple mobile antivirus apps.
* <b><code>&nbsp;&nbsp;&nbsp;237⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;38🍴</code></b> [BoomBox](https://github.com/nbeede/BoomBox)) - Automatic deployment of Cuckoo
  Sandbox malware lab using Packer and Vagrant.
* [Cryptam](http://www.cryptam.com/) - Analyze suspicious office documents.
* 🌎 [Cuckoo Sandbox](cuckoosandbox.org/) - Open source, self hosted
  sandbox and automated analysis system.
* <b><code>&nbsp;&nbsp;&nbsp;271⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;100🍴</code></b> [cuckoo-modified](https://github.com/brad-accuvant/cuckoo-modified)) - Modified
  version of Cuckoo Sandbox released under the GPL. Not merged upstream due to
  legal concerns by the author.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;22⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;7🍴</code></b> [cuckoo-modified-api](https://github.com/keithjjones/cuckoo-modified-api)) - A
  Python API used to control a cuckoo-modified sandbox.
* 🌎 [DeepViz](www.deepviz.com/) - Multi-format file analyzer with
  machine-learning classification.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [detux](https://github.com/detuxsandbox/detux/)) - A sandbox developed to do
  traffic analysis of Linux malwares and capturing IOCs.
* <b><code>&nbsp;&nbsp;1076⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;255🍴</code></b> [DRAKVUF](https://github.com/tklengyel/drakvuf)) - Dynamic malware analysis
  system.
* 🌎 [filescan.io](www.filescan.io/) - Static malware analysis, VBA/Powershell/VBS/JS Emulation  
* [firmware.re](http://firmware.re/) - Unpacks, scans and analyzes almost any
  firmware package.
* <b><code>&nbsp;&nbsp;&nbsp;734⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;220🍴</code></b> [HaboMalHunter](https://github.com/Tencent/HaboMalHunter)) - An Automated Malware
  Analysis Tool for Linux ELF Files.
* 🌎 [Hybrid Analysis](www.hybrid-analysis.com/) - Online malware
  analysis tool, powered by VxSandbox.
* 🌎 [Intezer](analyze.intezer.com) - Detect, analyze, and categorize malware by
  identifying code reuse and code similarities.
* [IRMA](http://irma.quarkslab.com/) - An asynchronous and customizable
  analysis platform for suspicious files.
* 🌎 [Joe Sandbox](www.joesecurity.org) - Deep malware analysis with Joe Sandbox.
* 🌎 [Jotti](virusscan.jotti.org/en) - Free online multi-AV scanner.
* <b><code>&nbsp;&nbsp;&nbsp;390⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;115🍴</code></b> [Limon](https://github.com/monnappa22/Limon)) - Sandbox for Analyzing Linux Malware.
* <b><code>&nbsp;&nbsp;&nbsp;369⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;101🍴</code></b> [Malheur](https://github.com/rieck/malheur)) - Automatic sandboxed analysis
  of malware behavior.
* <b><code>&nbsp;&nbsp;1658⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;270🍴</code></b> [malice.io](https://github.com/maliceio/malice)) - Massively scalable malware analysis framework.
* <b><code>&nbsp;&nbsp;&nbsp;368⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;80🍴</code></b> [malsub](https://github.com/diogo-fernan/malsub)) - A Python RESTful API framework for
  online malware and URL analysis services.
* 🌎 [Malware config](malwareconfig.com/) - Extract, decode and display online
  the configuration settings from common malwares.
* 🌎 [MalwareAnalyser.io](malwareanalyser.io/) - Online malware anomaly-based static analyser with heuristic detection engine powered by data mining and machine learning.
* 🌎 [Malwr](malwr.com/) - Free analysis with an online Cuckoo Sandbox
  instance.
* 🌎 [MetaDefender Cloud](metadefender.opswat.com/ ) - Scan a file, hash, IP, URL or
  domain address for malware for free.
* 🌎 [NetworkTotal](www.networktotal.com/index.html) - A service that analyzes
  pcap files and facilitates the quick detection of viruses, worms, trojans, and all
  kinds of malware using Suricata configured with EmergingThreats Pro.
* <b><code>&nbsp;&nbsp;1134⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;222🍴</code></b> [Noriben](https://github.com/Rurik/Noriben)) - Uses Sysinternals Procmon to
  collect information about malware in a sandboxed environment.
* 🌎 [PacketTotal](packettotal.com/) - PacketTotal is an online engine for analyzing .pcap files, and visualizing the network traffic within.
* [PDF Examiner](http://www.pdfexaminer.com/) - Analyse suspicious PDF files.
* [ProcDot](http://www.procdot.com) - A graphical malware analysis tool kit.
* <b><code>&nbsp;&nbsp;&nbsp;130⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;39🍴</code></b> [Recomposer](https://github.com/secretsquirrel/recomposer)) - A helper
  script for safely uploading binaries to sandbox sites.
* <b><code>&nbsp;&nbsp;&nbsp;138⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;40🍴</code></b> [sandboxapi](https://github.com/InQuest/python-sandboxapi)) - Python library for
  building integrations with several open source and commercial malware sandboxes.
* <b><code>&nbsp;&nbsp;&nbsp;817⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;104🍴</code></b> [SEE](https://github.com/F-Secure/see)) - Sandboxed Execution Environment (SEE)
  is a framework for building test automation in secured Environments.
* 🌎 [SEKOIA Dropper Analysis](malware.sekoia.fr/) - Online dropper analysis (Js, VBScript, Microsoft Office, PDF).
* 🌎 [VirusTotal](www.virustotal.com/) - Free online analysis of malware
  samples and URLs
* <b><code>&nbsp;&nbsp;&nbsp;139⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;30🍴</code></b> [Visualize_Logs](https://github.com/keithjjones/visualize_logs)) - Open source
  visualization library and command line tools for logs.  (Cuckoo, Procmon, more
  to come...)
* 🌎 [Zeltser's List](zeltser.com/automated-malware-analysis/) - Free
  automated sandboxes and services, compiled by Lenny Zeltser.

## Domain Analysis

*Inspect domains and IP addresses.*

* 🌎 [AbuseIPDB](www.abuseipdb.com/) - AbuseIPDB is a project dedicated
  to helping combat the spread of hackers, spammers, and abusive activity on the internet.
* 🌎 [badips.com](www.badips.com/) - Community based IP blacklist service.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;38⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6🍴</code></b> [boomerang](https://github.com/EmersonElectricCo/boomerang)) - A tool designed
  for consistent and safe capture of off network web resources.
* 🌎 [Cymon](cymon.io/) - Threat intelligence tracker, with IP/domain/hash
  search.
* [Desenmascara.me](http://desenmascara.me) - One click tool to retrieve as
  much metadata as possible for a website and to assess its good standing.
* 🌎 [Dig](networking.ringofsaturn.com/) - Free online dig and other
  network tools.
* <b><code>&nbsp;&nbsp;4958⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;777🍴</code></b> [dnstwist](https://github.com/elceef/dnstwist)) - Domain name permutation
  engine for detecting typo squatting, phishing and corporate espionage.
* <b><code>&nbsp;&nbsp;&nbsp;100⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;24🍴</code></b> [IPinfo](https://github.com/hiddenillusion/IPinfo)) - Gather information
  about an IP or domain by searching online resources.
* <b><code>&nbsp;&nbsp;&nbsp;505⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;101🍴</code></b> [Machinae](https://github.com/hurricanelabs/machinae)) - OSINT tool for
  gathering information about URLs, IPs, or hashes. Similar to Automator.
* <b><code>&nbsp;&nbsp;1655⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;258🍴</code></b> [mailchecker](https://github.com/FGRibreau/mailchecker)) - Cross-language
  temporary email detection library.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;80⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;22🍴</code></b> [MaltegoVT](https://github.com/michael-yip/MaltegoVT)) - Maltego transform
  for the VirusTotal API. Allows domain/IP research, and searching for file
  hashes and scan reports.
* [Multi rbl](http://multirbl.valli.org/) - Multiple DNS blacklist and forward
  confirmed reverse DNS lookup over more than 300 RBLs.
* 🌎 [NormShield Services](services.normshield.com/) - Free API Services
  for detecting possible phishing domains, blacklisted ip addresses and breached
  accounts.
* 🌎 [PhishStats](phishstats.info/) - Phishing Statistics with search for
  IP, domain and website title
* 🌎 [Spyse](spyse.com/) - subdomains, whois, realted domains, DNS, hosts AS, SSL/TLS info,
* 🌎 [SecurityTrails](securitytrails.com/) - Historical and current WHOIS,
  historical and current DNS records, similar domains, certificate information
  and other domain and IP related API and tools.
* 🌎 [SpamCop](www.spamcop.net/bl.shtml) - IP based spam block list.
* 🌎 [SpamHaus](www.spamhaus.org/lookup/) - Block list based on
  domains and IPs.
* 🌎 [Sucuri SiteCheck](sitecheck.sucuri.net/) - Free Website Malware
  and Security Scanner.
* 🌎 [Talos Intelligence](talosintelligence.com/) - Search for IP, domain
  or network owner. (Previously SenderBase.)
* [TekDefense Automater](http://www.tekdefense.com/automater/) - OSINT tool
  for gathering information about URLs, IPs, or hashes.
* 🌎 [URLhaus](urlhaus.abuse.ch/) - A project from abuse.ch with the goal
  of sharing malicious URLs that are being used for malware distribution.
* [URLQuery](http://urlquery.net/) - Free URL Scanner.
* 🌎 [urlscan.io](urlscan.io/) - Free URL Scanner & domain information.
* 🌎 [Whois](whois.domaintools.com/) - DomainTools free online whois
  search.
* 🌎 [Zeltser's List](zeltser.com/lookup-malicious-websites/) - Free
  online tools for researching malicious websites, compiled by Lenny Zeltser.
* 🌎 [ZScalar Zulu](zulu.zscaler.com/#) - Zulu URL Risk Analyzer.

## Browser Malware

*Analyze malicious URLs. See also the [domain analysis](#domain-analysis) and
[documents and shellcode](#documents-and-shellcode) sections.*

* <b><code>&nbsp;14761⭐</code></b> <b><code>&nbsp;&nbsp;1156🍴</code></b> [Bytecode Viewer](https://github.com/Konloch/bytecode-viewer)) - Combines
  multiple Java bytecode viewers and decompilers into one tool, including
  APK/DEX support.
* 🌎 [Firebug](getfirebug.com/) - Firefox extension for web development.
* [Java Decompiler](http://jd.benow.ca/) - Decompile and inspect Java apps.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Java IDX Parser](https://github.com/Rurik/Java_IDX_Parser/)) - Parses Java
  IDX cache files.
* [JSDetox](http://www.relentless-coding.com/projects/jsdetox/) - JavaScript
  malware analysis tool.
* <b><code>&nbsp;&nbsp;&nbsp;163⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;65🍴</code></b> [jsunpack-n](https://github.com/urule99/jsunpack-n)) - A javascript
  unpacker that emulates browser functionality.
* <b><code>&nbsp;&nbsp;2006⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;223🍴</code></b> [Krakatau](https://github.com/Storyyeller/Krakatau)) - Java decompiler,
  assembler, and disassembler.
* [Malzilla](http://malzilla.sourceforge.net/) - Analyze malicious web pages.
* <b><code>&nbsp;&nbsp;&nbsp;432⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;92🍴</code></b> [RABCDAsm](https://github.com/CyberShadow/RABCDAsm)) - A "Robust
  ActionScript Bytecode Disassembler."
* 🌎 [SWF Investigator](labs.adobe.com/technologies/swfinvestigator/) -
  Static and dynamic analysis of SWF applications.
* [swftools](http://www.swftools.org/) - Tools for working with Adobe Flash
  files.
* [xxxswf](http://hooked-on-mnemonics.blogspot.com/2011/12/xxxswfpy.html) - A
  Python script for analyzing Flash files.

## Documents and Shellcode

*Analyze malicious JS and shellcode from PDFs and Office documents. See also
the [browser malware](#browser-malware) section.*

* <b><code>&nbsp;&nbsp;&nbsp;178⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;41🍴</code></b> [AnalyzePDF](https://github.com/hiddenillusion/AnalyzePDF)) - A tool for
  analyzing PDFs and attempting to determine whether they are malicious.
* <b><code>&nbsp;&nbsp;&nbsp;623⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;86🍴</code></b> [box-js](https://github.com/CapacitorSet/box-js)) - A tool for studying JavaScript
  malware, featuring JScript/WScript support and ActiveX emulation.
* [diStorm](http://www.ragestorm.net/distorm/) - Disassembler for analyzing
  malicious shellcode.
* 🌎 [InQuest Deep File Inspection](labs.inquest.net/dfi) - Upload common malware lures for Deep File Inspection and heuristical analysis.
* [JS Beautifier](http://jsbeautifier.org/) - JavaScript unpacking and deobfuscation.
* [libemu](http://libemu.carnivore.it/) - Library and tools for x86 shellcode
  emulation.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;53⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;16🍴</code></b> [malpdfobj](https://github.com/9b/malpdfobj)) - Deconstruct malicious PDFs
  into a JSON representation.
* [OfficeMalScanner](http://www.reconstructer.org/code.html) - Scan for
  malicious traces in MS Office documents.
* [olevba](http://www.decalage.info/python/olevba) - A script for parsing OLE
  and OpenXML documents and extracting useful information.
* 🌎 [Origami PDF](code.google.com/archive/p/origami-pdf) - A tool for
  analyzing malicious PDFs, and more.
* 🌎 [PDF Tools](blog.didierstevens.com/programs/pdf-tools/) - pdfid,
  pdf-parser, and more from Didier Stevens.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;35⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;9🍴</code></b> [PDF X-Ray Lite](https://github.com/9b/pdfxray_lite)) - A PDF analysis tool,
  the backend-free version of PDF X-RAY.
* [peepdf](http://eternal-todo.com/tools/peepdf-pdf-analysis-tool) - Python
  tool for exploring possibly malicious PDFs.
* 🌎 [QuickSand](www.quicksand.io/) - QuickSand is a compact C framework
  to analyze suspected malware documents to identify exploits in streams of different
  encodings and to locate and extract embedded executables.
* 🌎 [Spidermonkey](developer.mozilla.org/en-US/docs/Mozilla/Projects/SpiderMonkey) -
  Mozilla's JavaScript engine, for debugging malicious JS.

## File Carving

*For extracting files from inside disk and memory images.*

* <b><code>&nbsp;&nbsp;1134⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;192🍴</code></b> [bulk_extractor](https://github.com/simsong/bulk_extractor)) - Fast file
  carving tool.
* <b><code>&nbsp;&nbsp;&nbsp;193⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;22🍴</code></b> [EVTXtract](https://github.com/williballenthin/EVTXtract)) - Carve Windows
  Event Log files from raw binary data.
* [Foremost](http://foremost.sourceforge.net/) - File carving tool designed
  by the US Air Force.
* <b><code>&nbsp;&nbsp;&nbsp;624⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;69🍴</code></b> [hachoir3](https://github.com/vstinner/hachoir3)) - Hachoir is a Python library
  to view and edit a binary stream field by field.
* <b><code>&nbsp;&nbsp;&nbsp;629⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;100🍴</code></b> [Scalpel](https://github.com/sleuthkit/scalpel)) - Another data carving
  tool.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;82⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;48🍴</code></b> [SFlock](https://github.com/jbremer/sflock)) - Nested archive
  extraction/unpacking (used in Cuckoo Sandbox).

## Deobfuscation

*Reverse XOR and other code obfuscation methods.*

* 🌎 [Balbuzard](bitbucket.org/decalage/balbuzard/wiki/Home) - A malware
  analysis tool for reversing obfuscation (XOR, ROL, etc) and more.
* <b><code>&nbsp;&nbsp;7012⭐</code></b> <b><code>&nbsp;&nbsp;2692🍴</code></b> [de4dot](https://github.com/0xd4d/de4dot)) - .NET deobfuscator and
  unpacker.
* [ex_pe_xor](http://hooked-on-mnemonics.blogspot.com/2014/04/expexorpy.html)
  & [iheartxor](http://hooked-on-mnemonics.blogspot.com/p/iheartxor.html) -
  Two tools from Alexander Hanel for working with single-byte XOR encoded
  files.
* <b><code>&nbsp;&nbsp;3355⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;456🍴</code></b> [FLOSS](https://github.com/fireeye/flare-floss)) - The FireEye Labs Obfuscated
  String Solver uses advanced static analysis techniques to automatically
  deobfuscate strings from malware binaries.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;86⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;18🍴</code></b> [NoMoreXOR](https://github.com/hiddenillusion/NoMoreXOR)) - Guess a 256 byte
  XOR key using frequency analysis.
* <b><code>&nbsp;&nbsp;&nbsp;270⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;72🍴</code></b> [PackerAttacker](https://github.com/BromiumLabs/PackerAttacker)) - A generic
  hidden code extractor for Windows malware.
* <b><code>&nbsp;&nbsp;3057⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;627🍴</code></b> [PyInstaller Extractor](https://github.com/extremecoders-re/pyinstxtractor)) -
  A Python script to extract the contents of a PyInstaller generated Windows
  executable file. The contents of the pyz file (usually pyc files) present
  inside the executable are also extracted and automatically fixed so that a
  Python bytecode decompiler will recognize it.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [uncompyle6](https://github.com/rocky/python-uncompyle6/)) - A cross-version
  Python bytecode decompiler.  Translates Python bytecode back into equivalent
  Python source code.
* <b><code>&nbsp;&nbsp;&nbsp;671⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;83🍴</code></b> [un{i}packer](https://github.com/unipacker/unipacker)) - Automatic and
  platform-independent unpacker for Windows binaries based on emulation.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [unpacker](https://github.com/malwaremusings/unpacker/)) - Automated malware
  unpacker for Windows malware based on WinAppDbg.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [unxor](https://github.com/tomchop/unxor/)) - Guess XOR keys using
  known-plaintext attacks.
* <b><code>&nbsp;&nbsp;&nbsp;133⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;24🍴</code></b> [VirtualDeobfuscator](https://github.com/jnraber/VirtualDeobfuscator)) -
  Reverse engineering tool for virtualization wrappers.
* [XORBruteForcer](http://eternal-todo.com/var/scripts/xorbruteforcer) -
  A Python script for brute forcing single-byte XOR keys.
* 🌎 [XORSearch & XORStrings](blog.didierstevens.com/programs/xorsearch/) -
  A couple programs from Didier Stevens for finding XORed data.
* <b><code>&nbsp;&nbsp;1406⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;173🍴</code></b> [xortool](https://github.com/hellman/xortool)) - Guess XOR key length, as
  well as the key itself.

## Debugging and Reverse Engineering

*Disassemblers, debuggers, and other static and dynamic analysis tools.*

* <b><code>&nbsp;&nbsp;7660⭐</code></b> <b><code>&nbsp;&nbsp;1088🍴</code></b> [angr](https://github.com/angr/angr)) - Platform-agnostic binary analysis
  framework developed at UCSB's Seclab.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [bamfdetect](https://github.com/bwall/bamfdetect)) - Identifies and extracts
  information from bots and other malware.
* <b><code>&nbsp;&nbsp;2081⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;274🍴</code></b> [BAP](https://github.com/BinaryAnalysisPlatform/bap)) - Multiplatform and
  open source (MIT) binary analysis framework developed at CMU's Cylab.
* <b><code>&nbsp;&nbsp;1413⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;168🍴</code></b> [BARF](https://github.com/programa-stic/barf-project)) - Multiplatform, open
  source Binary Analysis and Reverse engineering Framework.
* <b><code>&nbsp;&nbsp;2878⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;453🍴</code></b> [binnavi](https://github.com/google/binnavi)) - Binary analysis IDE for
  reverse engineering based on graph visualization.
* 🌎 [Binary ninja](binary.ninja/) - A reversing engineering platform
  that is an alternative to IDA.
* <b><code>&nbsp;11676⭐</code></b> <b><code>&nbsp;&nbsp;1584🍴</code></b> [Binwalk](https://github.com/devttys0/binwalk)) - Firmware analysis tool.
* <b><code>&nbsp;&nbsp;&nbsp;123⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;22🍴</code></b> [BluePill](https://github.com/season-lab/bluepill)) - Framework for executing and debugging evasive malware and protected executables.
* <b><code>&nbsp;&nbsp;7696⭐</code></b> <b><code>&nbsp;&nbsp;1562🍴</code></b> [Capstone](https://github.com/aquynh/capstone)) - Disassembly framework for
  binary analysis and reversing, with support for many architectures and
  bindings in several languages.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;44⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6🍴</code></b> [codebro](https://github.com/hugsy/codebro)) - Web based code browser using
  clang to provide basic code analysis.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Cutter](https://github.com/radareorg/cutter)) - GUI for Radare2.
* <b><code>&nbsp;&nbsp;&nbsp;808⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;168🍴</code></b> [DECAF (Dynamic Executable Code Analysis Framework)](https://github.com/sycurelab/DECAF))
  - A binary analysis platform based   on QEMU. DroidScope is now an extension to DECAF.
* <b><code>&nbsp;26857⭐</code></b> <b><code>&nbsp;&nbsp;5153🍴</code></b> [dnSpy](https://github.com/0xd4d/dnSpy)) - .NET assembly editor, decompiler
  and debugger.
* 🌎 [dotPeek](www.jetbrains.com/decompiler/) - Free .NET Decompiler and
  Assembly Browser.
* [Evan's Debugger (EDB)](http://codef00.com/projects#debugger) - A
  modular debugger with a Qt GUI.
* <b><code>&nbsp;&nbsp;2259⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;194🍴</code></b> [Fibratus](https://github.com/rabbitstack/fibratus)) - Tool for exploration
  and tracing of the Windows kernel.
* 🌎 [FPort](www.mcafee.com/us/downloads/free-tools/fport.aspx) - Reports
  open TCP/IP and UDP ports in a live system and maps them to the owning application.
* [GDB](http://www.sourceware.org/gdb/) - The GNU debugger.
* <b><code>&nbsp;&nbsp;7111⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;743🍴</code></b> [GEF](https://github.com/hugsy/gef)) - GDB Enhanced Features, for exploiters
  and reverse engineers.
* <b><code>&nbsp;52683⭐</code></b> <b><code>&nbsp;&nbsp;5956🍴</code></b> [Ghidra](https://github.com/NationalSecurityAgency/ghidra)) - A software reverse engineering (SRE) framework created and       maintained by the National Security Agency Research Directorate.
* <b><code>&nbsp;&nbsp;&nbsp;170⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;19🍴</code></b> [hackers-grep](https://github.com/codypierce/hackers-grep)) - A utility to
  search for strings in PE executables including imports, exports, and debug
  symbols.
* 🌎 [Hopper](www.hopperapp.com/) - The macOS and Linux Disassembler.
* 🌎 [IDA Pro](www.hex-rays.com/products/ida/index.shtml) - Windows
  disassembler and debugger, with a free evaluation version.
* <b><code>&nbsp;&nbsp;&nbsp;982⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;226🍴</code></b> [IDR](https://github.com/crypto2011/IDR)) - Interactive Delphi Reconstructor
  is a decompiler of Delphi executable files and dynamic libraries.
* [Immunity Debugger](http://debugger.immunityinc.com/) - Debugger for
  malware analysis and more, with a Python API.
* [ILSpy](http://ilspy.net/) - ILSpy is the open-source .NET assembly browser and decompiler.
* [Kaitai Struct](http://kaitai.io/) - DSL for file formats / network protocols /
  data structures reverse engineering and dissection, with code generation
  for C++, C#, Java, JavaScript, Perl, PHP, Python, Ruby.
* 🌎 [LIEF](lief.quarkslab.com/) - LIEF provides a cross-platform library
  to parse, modify and abstract ELF, PE and MachO formats.
* [ltrace](http://ltrace.org/) - Dynamic analysis for Linux executables.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;85⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;24🍴</code></b> [mac-a-mal](https://github.com/phdphuc/mac-a-mal)) - An automated framework
  for mac malware hunting.
* 🌎 [objdump](en.wikipedia.org/wiki/Objdump) - Part of GNU binutils,
  for static analysis of Linux binaries.
* [OllyDbg](http://www.ollydbg.de/) - An assembly-level debugger for Windows
  executables.
* 🌎 [OllyDumpEx](low-priority.appspot.com/ollydumpex/) - Dump memory
  from (unpacked) malware Windows process and store raw or rebuild PE file.
  This is a plugin for OllyDbg, Immunity Debugger, IDA Pro, WinDbg, and x64dbg.
* <b><code>&nbsp;&nbsp;&nbsp;105⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;42🍴</code></b> [PANDA](https://github.com/moyix/panda)) - Platform for Architecture-Neutral
  Dynamic Analysis.
* <b><code>&nbsp;&nbsp;5918⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;809🍴</code></b> [PEDA](https://github.com/longld/peda)) - Python Exploit Development
  Assistance for GDB, an enhanced display with added commands.
* 🌎 [pestudio](winitor.com/) - Perform static analysis of Windows
  executables.
* <b><code>&nbsp;&nbsp;1573⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;192🍴</code></b> [Pharos](https://github.com/cmu-sei/pharos)) - The Pharos binary analysis framework
  can be used to perform automated static analysis of binaries.
* <b><code>&nbsp;&nbsp;3049⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;276🍴</code></b> [plasma](https://github.com/plasma-disassembler/plasma)) - Interactive
  disassembler for x86/ARM/MIPS.
* 🌎 [PPEE (puppy)](www.mzrst.com/) - A Professional PE file Explorer for
  reversers, malware researchers and those who want to statically inspect PE
  files in more detail.
* 🌎 [Process Explorer](docs.microsoft.com/en-us/sysinternals/downloads/process-explorer) -
  Advanced task manager for Windows.
* [Process Hacker](http://processhacker.sourceforge.net/) - Tool that monitors
  system resources.
* 🌎 [Process Monitor](docs.microsoft.com/en-us/sysinternals/downloads/procmon) -
  Advanced monitoring tool for Windows programs.
* 🌎 [PSTools](docs.microsoft.com/en-us/sysinternals/downloads/pstools) - Windows
  command-line tools that help manage and investigate live systems.
* <b><code>&nbsp;&nbsp;&nbsp;386⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;95🍴</code></b> [Pyew](https://github.com/joxeankoret/pyew)) - Python tool for malware
  analysis.
* <b><code>&nbsp;&nbsp;1657⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;247🍴</code></b> [PyREBox](https://github.com/Cisco-Talos/pyrebox)) - Python scriptable reverse
  engineering sandbox by the Talos team at Cisco.
* 🌎 [Qiling Framework](www.qiling.io/) - Cross platform emulation and sanboxing
  framework with instruments for binary analysis.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [QKD](https://github.com/ispras/qemu/releases/)) - QEMU with embedded WinDbg
  server for stealth debugging.
* [Radare2](http://www.radare.org/r/) - Reverse engineering framework, with
  debugger support.
* 🌎 [RegShot](sourceforge.net/projects/regshot/) - Registry compare utility
  that compares snapshots.
* 🌎 [RetDec](retdec.com/) - Retargetable machine-code decompiler with an
  🌎 [online decompilation service](retdec.com/decompilation/) and
  🌎 [API](retdec.com/api/) that you can use in your tools.
* <b><code>&nbsp;&nbsp;&nbsp;285⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;42🍴</code></b> [ROPMEMU](https://github.com/Cisco-Talos/ROPMEMU)) - A framework to analyze, dissect
  and decompile complex code-reuse attacks.
* <b><code>&nbsp;&nbsp;1128⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;232🍴</code></b> [Scylla Imports Reconstructor](https://github.com/NtQuery/Scylla)) - Find and fix
  the IAT of an unpacked / dumped PE32 malware.
* <b><code>&nbsp;&nbsp;3530⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;441🍴</code></b> [ScyllaHide](https://github.com/x64dbg/ScyllaHide)) - An Anti-Anti-Debug library
  and plugin for OllyDbg, x64dbg, IDA Pro, and TitanEngine.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;66⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;15🍴</code></b> [SMRT](https://github.com/pidydx/SMRT)) - Sublime Malware Research Tool, a
  plugin for Sublime 3 to aid with malware analyis.
* 🌎 [strace](sourceforge.net/projects/strace/) - Dynamic analysis for
  Linux executables.
* <b><code>&nbsp;&nbsp;&nbsp;688⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;125🍴</code></b> [StringSifter](https://github.com/fireeye/stringsifter)) - A machine learning tool
  that automatically ranks strings based on their relevance for malware analysis.
* 🌎 [Triton](triton.quarkslab.com/) - A dynamic binary analysis (DBA) framework.
* <b><code>&nbsp;&nbsp;1029⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;298🍴</code></b> [Udis86](https://github.com/vmt/udis86)) - Disassembler library and tool
  for x86 and x86_64.
* <b><code>&nbsp;&nbsp;&nbsp;945⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;187🍴</code></b> [Vivisect](https://github.com/vivisect/vivisect)) - Python tool for
  malware analysis.
* 🌎 [WinDbg](developer.microsoft.com/en-us/windows/hardware/download-windbg) - multipurpose debugger for the Microsoft Windows computer operating system, used to debug user mode applications, device drivers, and the kernel-mode memory dumps.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [X64dbg](https://github.com/x64dbg/)) - An open-source x64/x32 debugger for windows.

## Network

*Analyze network interactions.*

* 🌎 [Bro](www.bro.org) - Protocol analyzer that operates at incredible
  scale; both file and network protocols.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;33⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;5🍴</code></b> [BroYara](https://github.com/hempnall/broyara)) - Use Yara rules from Bro.
* <b><code>&nbsp;&nbsp;&nbsp;714⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;159🍴</code></b> [CapTipper](https://github.com/omriher/CapTipper)) -  Malicious HTTP traffic
  explorer.
* <b><code>&nbsp;&nbsp;&nbsp;489⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;112🍴</code></b> [chopshop](https://github.com/MITRECND/chopshop)) - Protocol analysis and
  decoding framework.
* 🌎 [CloudShark](www.cloudshark.org) - Web-based tool for packet analysis
  and malware traffic detection.
* <b><code>&nbsp;&nbsp;1830⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;364🍴</code></b> [FakeNet-NG](https://github.com/fireeye/flare-fakenet-ng)) - Next generation
  dynamic network analysis tool.
* 🌎 [Fiddler](www.telerik.com/fiddler) - Intercepting web proxy designed
  for "web debugging."
* <b><code>&nbsp;&nbsp;&nbsp;188⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;62🍴</code></b> [Hale](https://github.com/pjlantz/Hale)) - Botnet C&C monitor.
* [Haka](http://www.haka-security.org/) - An open source security oriented
  language for describing protocols and applying security policies on (live)
  captured traffic.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;95⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;35🍴</code></b> [HTTPReplay](https://github.com/jbremer/httpreplay)) - Library for parsing
  and reading out PCAP files, including TLS streams using TLS Master Secrets
  (used in Cuckoo Sandbox).
* [INetSim](http://www.inetsim.org/) - Network service emulation, useful when
  building a malware lab.
* <b><code>&nbsp;&nbsp;&nbsp;743⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;156🍴</code></b> [Laika BOSS](https://github.com/lmco/laikaboss)) - Laika BOSS is a file-centric
  malware analysis and intrusion detection system.
* <b><code>&nbsp;&nbsp;&nbsp;371⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;60🍴</code></b> [Malcolm](https://github.com/idaholab/Malcolm)) - Malcolm is a powerful, easily
  deployable network traffic analysis tool suite for full packet capture artifacts
  (PCAP files) and Zeek logs.
* <b><code>&nbsp;&nbsp;1160⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;216🍴</code></b> [Malcom](https://github.com/tomchop/malcom)) - Malware Communications
  Analyzer.
* <b><code>&nbsp;&nbsp;6662⭐</code></b> <b><code>&nbsp;&nbsp;1105🍴</code></b> [Maltrail](https://github.com/stamparm/maltrail)) - A malicious traffic
  detection system, utilizing publicly available (black)lists containing
  malicious and/or generally suspicious trails and featuring an reporting
  and analysis interface.
* 🌎 [mitmproxy](mitmproxy.org/) - Intercept network traffic on the fly.
* <b><code>&nbsp;&nbsp;6445⭐</code></b> <b><code>&nbsp;&nbsp;1045🍴</code></b> [Moloch](https://github.com/aol/moloch)) - IPv4 traffic capturing, indexing
  and database system.
* [NetworkMiner](http://www.netresec.com/?page=NetworkMiner) - Network
  forensic analysis tool, with a free version.
* <b><code>&nbsp;&nbsp;&nbsp;909⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;102🍴</code></b> [ngrep](https://github.com/jpr5/ngrep)) - Search through network traffic
  like grep.
* <b><code>&nbsp;&nbsp;&nbsp;345⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [PcapViz](https://github.com/mateuszk87/PcapViz)) - Network topology and
  traffic visualizer.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;58⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13🍴</code></b> [Python ICAP Yara](https://github.com/RamadhanAmizudin/python-icap-yara)) - An
  ICAP Server with yara scanner for URL or content.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;78⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;27🍴</code></b> [Squidmagic](https://github.com/ch3k1/squidmagic)) - squidmagic is a tool
  designed to analyze a web-based network traffic to detect central command
  and control (C&C) servers and malicious sites, using Squid proxy server and
  Spamhaus.
* [Tcpdump](http://www.tcpdump.org/) - Collect network traffic.
* [tcpick](http://tcpick.sourceforge.net/) - Trach and reassemble TCP streams
  from network traffic.
* [tcpxtract](http://tcpxtract.sourceforge.net/) - Extract files from network
  traffic.
* 🌎 [Wireshark](www.wireshark.org/) - The network traffic analysis
  tool.

## Memory Forensics

*Tools for dissecting malware in memory images or running systems.*

* 🌎 [BlackLight](www.blackbagtech.com/blacklight.html) - Windows/MacOS
  forensics client supporting hiberfil, pagefile, raw memory analysis.
* <b><code>&nbsp;&nbsp;&nbsp;211⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;48🍴</code></b> [DAMM](https://github.com/504ensicsLabs/DAMM)) - Differential Analysis of
  Malware in Memory, built on Volatility.
* <b><code>&nbsp;&nbsp;&nbsp;260⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;42🍴</code></b> [evolve](https://github.com/JamesHabben/evolve)) - Web interface for the
  Volatility Memory Forensics Framework.
* 🌎 [FindAES](sourceforge.net/projects/findaes/) - Find AES
  encryption keys in memory.
* <b><code>&nbsp;&nbsp;&nbsp;281⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;57🍴</code></b> [inVtero.net](https://github.com/ShaneK2/inVtero.net)) - High speed memory
  analysis framework developed in .NET supports all Windows x64, includes
  code integrity and write support.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;52⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;9🍴</code></b> [Muninn](https://github.com/ytisf/muninn)) - A script to automate portions
  of analysis using Volatility, and create a readable report.
  <b><code>&nbsp;&nbsp;&nbsp;226⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;19🍴</code></b> [Orochi](https://github.com/LDO-CERT/orochi)) - Orochi is an open source framework for 
  collaborative forensic memory dump analysis. 
* [Rekall](http://www.rekall-forensic.com/) - Memory analysis framework,
  forked from Volatility in 2013.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;49⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;9🍴</code></b> [TotalRecall](https://github.com/sketchymoose/TotalRecall)) - Script based
  on Volatility for automating various malware analysis tasks.
* <b><code>&nbsp;&nbsp;&nbsp;194⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;50🍴</code></b> [VolDiff](https://github.com/aim4r/VolDiff)) - Run Volatility on memory
  images before and after malware execution, and report changes.
* <b><code>&nbsp;&nbsp;7433⭐</code></b> <b><code>&nbsp;&nbsp;1296🍴</code></b> [Volatility](https://github.com/volatilityfoundation/volatility)) - Advanced
  memory forensics framework.
* <b><code>&nbsp;&nbsp;&nbsp;381⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;82🍴</code></b> [VolUtility](https://github.com/kevthehermit/VolUtility)) - Web Interface for
  Volatility Memory Analysis framework.
* <b><code>&nbsp;&nbsp;&nbsp;621⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;179🍴</code></b> [WDBGARK](https://github.com/swwwolf/wdbgark)) -
  WinDBG Anti-RootKit Extension.
* 🌎 [WinDbg](developer.microsoft.com/en-us/windows/hardware/windows-driver-kit) -
  Live memory inspection and kernel debugging for Windows systems.

## Windows Artifacts

* <b><code>&nbsp;&nbsp;&nbsp;184⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;29🍴</code></b> [AChoir](https://github.com/OMENScan/AChoir)) - A live incident response
  script for gathering Windows artifacts.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;49⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;11🍴</code></b> [python-evt](https://github.com/williballenthin/python-evt)) - Python
  library for parsing Windows Event Logs.
* [python-registry](http://www.williballenthin.com/registry/) - Python
  library for parsing registry files.
* [RegRipper](http://brettshavers.cc/index.php/brettsblog/tags/tag/regripper/)
  (<b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [GitHub](https://github.com/keydet89/RegRipper2.8))) -
  Plugin-based registry analysis tool.

## Storage and Workflow

* <b><code>&nbsp;&nbsp;&nbsp;158⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;53🍴</code></b> [Aleph](https://github.com/merces/aleph)) - Open Source Malware Analysis
  Pipeline System.
* 🌎 [CRITs](crits.github.io/) - Collaborative Research Into Threats, a
  malware and threat repository.
* 🌎 [FAME](certsocietegenerale.github.io/fame/) - A malware analysis
  framework featuring a pipeline that can be extended with custom modules,
  which can be chained and interact with each other to perform end-to-end
  analysis.
* <b><code>&nbsp;&nbsp;&nbsp;134⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;43🍴</code></b> [Malwarehouse](https://github.com/sroberts/malwarehouse)) - Store, tag, and
  search malware.
* <b><code>&nbsp;&nbsp;&nbsp;376⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;60🍴</code></b> [Polichombr](https://github.com/ANSSI-FR/polichombr)) - A malware analysis
  platform designed to help analysts to reverse malwares collaboratively.
* [stoQ](http://stoq.punchcyber.com) - Distributed content analysis
  framework with extensive plugin support, from input to output, and everything
  in between.
* [Viper](http://viper.li/) - A binary management and analysis framework for
  analysts and researchers.

## Miscellaneous

* <b><code>&nbsp;&nbsp;6004⭐</code></b> <b><code>&nbsp;&nbsp;1178🍴</code></b> [al-khaser](https://github.com/LordNoteworthy/al-khaser)) - A PoC malware
  with good intentions that aimes to stress anti-malware systems.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;39⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;12🍴</code></b> [CryptoKnight](https://github.com/AbertayMachineLearningGroup/CryptoKnight)) - Automated cryptographic algorithm reverse engineering and classification framework.
* <b><code>&nbsp;&nbsp;&nbsp;306⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;59🍴</code></b> [DC3-MWCP](https://github.com/Defense-Cyber-Crime-Center/DC3-MWCP)) -
  The Defense Cyber Crime Center's Malware Configuration Parser framework.
* <b><code>&nbsp;&nbsp;6732⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;931🍴</code></b> [FLARE VM](https://github.com/fireeye/flare-vm)) - A fully customizable,
  Windows-based, security distribution for malware analysis.
* <b><code>&nbsp;&nbsp;&nbsp;538⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;198🍴</code></b> [MalSploitBase](https://github.com/misterch0c/malSploitBase)) - A database
  containing exploits used by malware.
* 🌎 [Malware Museum](archive.org/details/malwaremuseum) - Collection of
  malware programs that were distributed in the 1980s and 1990s.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [Malware Organiser](https://github.com/uppusaikiran/malware-organiser)) - A simple tool to organise large malicious/benign files into a organised Structure.
* <b><code>&nbsp;&nbsp;3466⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;467🍴</code></b> [Pafish](https://github.com/a0rtega/pafish)) - Paranoid Fish, a demonstration
  tool that employs several techniques to detect sandboxes and analysis
  environments in the same way as malware families do.
* 🌎 [REMnux](remnux.org/) - Linux distribution and docker images for
  malware reverse engineering and analysis.
* 🌎 [Tsurugi Linux](tsurugi-linux.org/) - Linux distribution designed to support your DFIR investigations, malware analysis and OSINT (Open Source INTelligence) activities.
* 🌎 [Santoku Linux](santoku-linux.com/) - Linux distribution for mobile
  forensics, malware analysis, and security.

# Resources

## Books

*Essential malware analysis reading material.*

* 🌎 [Learning Malware Analysis](www.packtpub.com/networking-and-servers/learning-malware-analysis) - Learning Malware Analysis: Explore the concepts, tools, and techniques to analuze and investigate Windows malware
* 🌎 [Malware Analyst's Cookbook and DVD](amzn.com/dp/0470613033) -
  Tools and Techniques for Fighting Malicious Code.
* 🌎 [Mastering Malware Analysis](www.packtpub.com/networking-and-servers/mastering-malware-analysis) - Mastering Malware Analysis: The complete malware analyst's guide to combating malicious software, APT, cybercime, and IoT attacks
* 🌎 [Mastering Reverse Engineering](www.packtpub.com/networking-and-servers/mastering-reverse-engineering) - Mastering Reverse Engineering: Re-engineer your ethical hacking skills
* 🌎 [Practical Malware Analysis](amzn.com/dp/1593272901) - The Hands-On
  Guide to Dissecting Malicious Software.
* 🌎 [Practical Reverse Engineering](www.amzn.com/dp/1118787315/) -
  Intermediate Reverse Engineering.
* 🌎 [Real Digital Forensics](www.amzn.com/dp/0321240693) - Computer
  Security and Incident Response.
* 🌎 [Rootkits and Bootkits](www.amazon.com/dp/1593277164) - Rootkits and Bootkits: Reversing Modern Malware and Next Generation Threats
* 🌎 [The Art of Memory Forensics](amzn.com/dp/1118825098) - Detecting
  Malware and Threats in Windows, Linux, and Mac Memory.
* 🌎 [The IDA Pro Book](amzn.com/dp/1593272898) - The Unofficial Guide
  to the World's Most Popular Disassembler.
* 🌎 [The Rootkit Arsenal](amzn.com/dp/144962636X) - The Rootkit Arsenal:
  Escape and Evasion in the Dark Corners of the System

## Other

* <b><code>&nbsp;&nbsp;1668⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;282🍴</code></b> [APT Notes](https://github.com/aptnotes/data)) - A collection of papers
  and notes related to Advanced Persistent Threats.
* <b><code>&nbsp;&nbsp;&nbsp;965⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;282🍴</code></b> [Ember](https://github.com/endgameinc/ember)) - Endgame Malware BEnchmark for Research,
  a repository that makes it easy to (re)create a machine learning model that can be used
  to predict a score for a PE file based on static analysis.
* <b><code>&nbsp;10602⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;743🍴</code></b> [File Formats posters](https://github.com/corkami/pics)) - Nice visualization
  of commonly used file format (including PE & ELF).
* [Honeynet Project](http://honeynet.org/) - Honeypot tools, papers, and
  other resources.
* [Kernel Mode](http://www.kernelmode.info/forum/) - An active community
  devoted to malware analysis and kernel development.
* 🌎 [Malicious Software](zeltser.com/malicious-software/) - Malware
  blog and resources by Lenny Zeltser.
* 🌎 [Malware Analysis Search](cse.google.com/cse/home?cx=011750002002865445766%3Apc60zx1rliu) -
  Custom Google search engine from [Corey Harrell](journeyintoir.blogspot.com/).
* [Malware Analysis Tutorials](http://fumalwareanalysis.blogspot.nl/p/malware-analysis-tutorials-reverse.html) -
  The Malware Analysis Tutorials by Dr. Xiang Fu, a great resource for learning
  practical malware analysis.
* 🌎 [Malware Analysis, Threat Intelligence and Reverse Engineering](www.slideshare.net/bartblaze/malware-analysis-threat-intelligence-and-reverse-engineering) -
  Presentation introducing the concepts of malware analysis, threat intelligence
  and reverse engineering. Experience or prior knowledge is not required. Labs
  link in description.
* <b><code>&nbsp;&nbsp;&nbsp;165⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;15🍴</code></b> [Malware Persistence](https://github.com/Karneades/malware-persistence)) - Collection
  of various information focused on malware persistence: detection (techniques),
  response, pitfalls and the log collection (tools).
* [Malware Samples and Traffic](http://malware-traffic-analysis.net/) - This
  blog focuses on network traffic related to malware infections.
* 🌎 [Malware Search+++](addons.mozilla.org/fr/firefox/addon/malware-search-plusplusplus/) Firefox extension allows
  you to easily search some of the most popular malware databases
* 🌎 [Practical Malware Analysis Starter Kit](bluesoul.me/practical-malware-analysis-starter-kit/) -
  This package contains most of the software referenced in the Practical Malware
  Analysis book.
* <b><code>&nbsp;&nbsp;3785⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;790🍴</code></b> [RPISEC Malware Analysis](https://github.com/RPISEC/Malware)) - These are the
  course materials used in the Malware Analysis course at at Rensselaer Polytechnic
  Institute during Fall 2015.
* [WindowsIR: Malware](http://windowsir.blogspot.com/p/malware.html) - Harlan
  Carvey's page on Malware.
* <b><code>&nbsp;&nbsp;&nbsp;332⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;73🍴</code></b> [Windows Registry specification](https://github.com/msuhanov/regf/blob/master/Windows%20registry%20file%20format%20specification.md)) -
  Windows registry file format specification.
* 🌎 [/r/csirt_tools](www.reddit.com/r/csirt_tools/) - Subreddit for CSIRT
  tools and resources, with a
  🌎 [malware analysis](www.reddit.com/r/csirt_tools/search?q=flair%3A%22Malware%20analysis%22&sort=new&restrict_sr=on) flair.
* 🌎 [/r/Malware](www.reddit.com/r/Malware) - The malware subreddit.
* 🌎 [/r/ReverseEngineering](www.reddit.com/r/ReverseEngineering) -
  Reverse engineering subreddit, not limited to just malware.



# Related Awesome Lists

* <b><code>&nbsp;&nbsp;8297⭐</code></b> <b><code>&nbsp;&nbsp;1454🍴</code></b> [Android Security](https://github.com/ashishb/android-security-awesome))
* <b><code>&nbsp;&nbsp;6390⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;741🍴</code></b> [AppSec](https://github.com/paragonie/awesome-appsec))
* <b><code>&nbsp;&nbsp;9950⭐</code></b> <b><code>&nbsp;&nbsp;1497🍴</code></b> [CTFs](https://github.com/apsdehal/awesome-ctf))
* <b><code>&nbsp;&nbsp;1234⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;107🍴</code></b> [Executable Packing](https://github.com/dhondta/awesome-executable-packing))
* <b><code>&nbsp;&nbsp;4041⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;632🍴</code></b> [Forensics](https://github.com/Cugu/awesome-forensics))
* <b><code>&nbsp;13374⭐</code></b> <b><code>&nbsp;&nbsp;1554🍴</code></b> ["Hacking"](https://github.com/carpedm20/awesome-hacking))
* <b><code>&nbsp;&nbsp;8763⭐</code></b> <b><code>&nbsp;&nbsp;1267🍴</code></b> [Honeypots](https://github.com/paralax/awesome-honeypots))
* <b><code>&nbsp;&nbsp;1658⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;438🍴</code></b> [Industrial Control System Security](https://github.com/hslatman/awesome-industrial-control-system-security))
* <b><code>&nbsp;&nbsp;7752⭐</code></b> <b><code>&nbsp;&nbsp;1537🍴</code></b> [Incident-Response](https://github.com/meirwah/awesome-incident-response))
* <b><code>&nbsp;&nbsp;5229⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;739🍴</code></b> [Infosec](https://github.com/onlurking/awesome-infosec))
* <b><code>&nbsp;&nbsp;3149⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;466🍴</code></b> [PCAP Tools](https://github.com/caesar0301/awesome-pcaptools))
* <b><code>&nbsp;22176⭐</code></b> <b><code>&nbsp;&nbsp;4491🍴</code></b> [Pentesting](https://github.com/enaqx/awesome-pentest))
* <b><code>&nbsp;12594⭐</code></b> <b><code>&nbsp;&nbsp;1938🍴</code></b> [Security](https://github.com/sbilly/awesome-security))
* <b><code>&nbsp;&nbsp;8256⭐</code></b> <b><code>&nbsp;&nbsp;1501🍴</code></b> [Threat Intelligence](https://github.com/hslatman/awesome-threat-intelligence))
* <b><code>&nbsp;&nbsp;3613⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;495🍴</code></b> [YARA](https://github.com/InQuest/awesome-yara))

# [Contributing](CONTRIBUTING.md)

Pull requests and issues with suggestions are welcome! Please read the
[CONTRIBUTING](CONTRIBUTING.md) guidelines before submitting a PR.

# Thanks

This list was made possible by:

* Lenny Zeltser and other contributors for developing REMnux, where I
  found many of the tools in this list;
* Michail Hale Ligh, Steven Adair, Blake Hartstein, and Mather Richard for
  writing the *Malware Analyst's Cookbook*, which was a big inspiration for
  creating the list;
* And everyone else who has sent pull requests or suggested links to add here!

Thanks!

## Source
<b><code>&nbsp;12105⭐</code></b> <b><code>&nbsp;&nbsp;2584🍴</code></b> [rshipp/awesome-malware-analysis](https://github.com/rshipp/awesome-malware-analysis))