# Awesome .NET Core [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

Inspired by <b><code>337544⭐</code></b> <b><code>&nbsp;28036🍴</code></b> [awesome](https://github.com/sindresorhus/awesome)), <b><code>&nbsp;19499⭐</code></b> <b><code>&nbsp;&nbsp;2680🍴</code></b> [awesome-dotnet](https://github.com/quozd/awesome-dotnet)),  <b><code>&nbsp;58885⭐</code></b> <b><code>&nbsp;&nbsp;5854🍴</code></b> [awesome-nodejs](https://github.com/sindresorhus/awesome-nodejs)), <b><code>&nbsp;42760⭐</code></b> <b><code>&nbsp;&nbsp;5084🍴</code></b> [frontend-dev-bookmarks](https://github.com/dypsilon/frontend-dev-bookmarks)).

Contributions are always welcome! Please take a look at the [contribution guidelines](https://github.com/correia-jpv/fucking-awesome-dotnet-core/blob/master/contributing.md) pages first. We accept proprietary and commercial software too.

Thanks to all [contributors](https://github.com/correia-jpv/fucking-awesome-dotnet-core/graphs/contributors), you're awesome and wouldn't be possible without you! The goal is to build a categorized community-driven collection of very well-known resources.

Check out my 🌎 [blog](medium.com/@thangchung) or say hi on 🌎 [Twitter](twitter.com/thangchung)!

## Contents

* [General](#general)
* [Frameworks, Libraries and Tools](#frameworks-libraries-and-tools)
  * [API](#api)
  * [Application Frameworks](#application-frameworks)
  * [Application Templates](#application-templates)
  * [Authentication and Authorization](#authentication-and-authorization)
  * [Blockchain](#blockchain)
  * [Bot](#bot)
  * [Build Automation](#build-automation)
  * [Bundling and Minification](#bundling-and-minification)
  * [Caching](#caching)
  * [CMS](#cms)
  * [Code Analysis and Metrics](#code-analysis-and-metrics)  
  * [Compression](#compression)
  * [Compilers, Transpilers and Languages](#compilers-transpilers-and-languages)
  * [Cryptography](#cryptography)
  * [Database](#database)
  * [Database Drivers](#database-drivers)
  * [Database Tools and Utilities](#database-tools-and-utilities)
  * [Date and Time](#date-and-time)
  * [Distributed Computing](#distributed-computing)
  * [E-Commerce and Payments](#e-commerce-and-payments)
  * [Exceptions](#exceptions)
  * [Functional Programming](#functional-programming)
  * [Graphics](#graphics)
  * [GUI](#gui)
  * [IDE](#ide)
  * [Internationalization](#internationalization)
  * [IOC](#ioc)
  * [Logging](#logging)
  * [Machine Learning and Data Science](#machine-learning-and-data-science)
  * [Mail](#mail)
  * [Mathematics](#mathematics)
  * [Media](#media)
  * [Networking](#networking)
  * [Misc](#misc)
  * [Office](#office)
  * [ORM](#orm)
  * [Profiling](#profiling)
  * [Queue and Messaging](#queue-and-messaging)
  * [Query Builders](#query-builders)
  * [Scheduler and Job](#scheduler-and-job)
  * [SDKs](#sdks)
  * [Security](#security)
  * [Searching](#searching)
  * [Serialization](#serialization)
  * [Template Engine](#template-engine)
  * [Testing](#testing)
  * [Tools](#tools)
  * [Web Framework](#web-framework)
  * [Web Socket](#web-socket)
  * [Windows Service](#windows-service)
  * [Workflow](#workflow)
* [Roadmaps](#roadmaps)
* [Starter Kits](#starter-kits)
* [Sample Projects](#sample-projects)
* [Articles](#articles)
* [Books](#books)
* [Videos](#videos)
* [Podcasts](#podcasts)
* [Community](#community)

## General

* 🌎 [ASP.NET Core Documentation](docs.asp.net/en/latest/) - The official ASP.NET Core documentation site.
* 🌎 [.NET Core Documentation](docs.microsoft.com/en-us/dotnet/articles/welcome) - Home of the technical documentation for .NET Core, C#, F# and Visual Basic, including basic concepts, getting started instructions, tutorials and samples.
* 🌎 [.NET Core SDK](www.microsoft.com/net/core) - .NET Core SDK is a general purpose development platform maintained by Microsoft and the .NET community on <b><code>&nbsp;21048⭐</code></b> <b><code>&nbsp;&nbsp;4902🍴</code></b> [GitHub](https://github.com/dotnet/core)).
* <b><code>&nbsp;17651⭐</code></b> <b><code>&nbsp;&nbsp;4923🍴</code></b> [.NET Platform Standard](https://github.com/dotnet/corefx/blob/1719a3fe2a5c81b67a4909787da4a02fb0d0d419/Documentation/architecture/net-platform-standard.md)) - The differrent between the old version and the new version of .NET.
* 🌎 [Introducing .NET Standard 2.0](blogs.msdn.microsoft.com/dotnet/2016/09/26/introducing-net-standard) - The description of what will be going on for .NET Standard 2.0 and the roadmap for some missing parts of the current .NET Standard.
* <b><code>&nbsp;&nbsp;7234⭐</code></b> <b><code>&nbsp;&nbsp;1114🍴</code></b> [Clean Code .NET/.NET Core](https://github.com/thangchung/clean-code-dotnet)) - Clean Code concepts adapted for .NET / .NET Core.

## Frameworks, Libraries and Tools

### API

* <b><code>&nbsp;&nbsp;4638⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;741🍴</code></b> [autorest](https://github.com/Azure/autorest)) - Swagger (OpenAPI) Specification code generator featuring C# and Razor templates. Supports C#, Java, Node.js, TypeScript, Python and Ruby. `4.5.x or above`
* <b><code>&nbsp;&nbsp;3079⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;707🍴</code></b> [aspnet-api-versioning](https://github.com/Microsoft/aspnet-api-versioning)) - set of libraries which add service API versioning to ASP.NET Web API, OData with ASP.NET Web API, and ASP.NET Core.
* <b><code>&nbsp;&nbsp;3122⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;447🍴</code></b> [AspNetCoreRateLimit](https://github.com/stefanprodan/AspNetCoreRateLimit)) - ASP.NET Core rate limiting middleware.
* <b><code>&nbsp;&nbsp;&nbsp;167⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;28🍴</code></b> [CondenserDotNet](https://github.com/Drawaes/CondenserDotNet)) - API Condenser / Reverse Proxy using Kestrel and Consul, Including light weight consul library.
* <b><code>&nbsp;&nbsp;4234⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;390🍴</code></b> [Flurl](https://github.com/tmenier/Flurl)) - Fluent URL builder and testable HTTP for .NET 🌎 [https://flurl.dev](flurl.dev).
* GraphQL
  * <b><code>&nbsp;&nbsp;&nbsp;290⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;50🍴</code></b> [Dapper.GraphQL](https://github.com/landmarkhw/Dapper.GraphQL)) - A library designed to integrate the Dapper and graphql-dotnet projects with ease-of-use in mind and performance as the primary concern.
  * <b><code>&nbsp;&nbsp;&nbsp;183⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;31🍴</code></b> [graphql-aspnetcore](https://github.com/JuergenGutsch/graphql-aspnetcore)) - ASP.NET Core MiddleWare to create a GraphQL end-point.
  * <b><code>&nbsp;&nbsp;&nbsp;233⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;63🍴</code></b> [graphql-convention](https://github.com/graphql-dotnet/conventions)) - This library is a complementary layer on top that allows you to automatically wrap your .NET classes into GraphQL schema definitions using existing property getters and methods as field resolvers
  * <b><code>&nbsp;&nbsp;&nbsp;142⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;27🍴</code></b> [graphiql-dotnet](https://github.com/JosephWoodward/graphiql-dotnet)) - GraphiQL middleware for ASP.NET Core.
  * <b><code>&nbsp;&nbsp;&nbsp;100⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;11🍴</code></b> [graphql-dotnetcore](https://github.com/mkmarek/graphql-dotnetcore)) - GraphQL for .NET Core based on <b><code>&nbsp;20107⭐</code></b> <b><code>&nbsp;&nbsp;2029🍴</code></b> [https://github.com/graphql/graphql-js](https://github.com/graphql/graphql-js)).
  * <b><code>&nbsp;&nbsp;5885⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;928🍴</code></b> [graphql-dotnet](https://github.com/graphql-dotnet/graphql-dotnet)) - GraphQL for .NET.
  * <b><code>&nbsp;&nbsp;&nbsp;582⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;164🍴</code></b> [graphql-dotnet-server](https://github.com/graphql-dotnet/server)) - GraphQL for .NET - Subscription Transport WebSockets.
  * <b><code>&nbsp;&nbsp;5283⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;747🍴</code></b> [Hot Chocolate](https://github.com/ChilliCream/hotchocolate)) - GraphQL server for .Net Core and .NET Framework.
  * <b><code>&nbsp;&nbsp;&nbsp;399⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;73🍴</code></b> [FSharp.Data.GraphQL](https://github.com/fsprojects/FSharp.Data.GraphQL)) - FSharp implementation of Facebook GraphQL query language 🌎 [https://fsprojects.github.io/FSharp.Data.GraphQL](fsprojects.github.io/FSharp.Data.GraphQL).
  * <b><code>&nbsp;&nbsp;&nbsp;218⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;43🍴</code></b> [parser](https://github.com/graphql-dotnet/parser)) - A lexer and parser for GraphQL in .NET.
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;62⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4🍴</code></b> [tanka-graphql](https://github.com/pekkah/tanka-graphql)) - GraphQL execution and server libraries supporting SignalR, Apollo, schema manipulation and other features familiar from Apollo and graphql-js
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;81⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;29🍴</code></b> [halcyon](https://github.com/visualeyes/halcyon)) - HAL implementation for ASP.NET.
* <b><code>&nbsp;&nbsp;&nbsp;686⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;159🍴</code></b> [JSON API .NET Core](https://github.com/Research-Institute/json-api-dotnet-core)) - Framework for building json:api compliant APIs with the goal of eliminating RESTful boilerplate.
* <b><code>&nbsp;&nbsp;&nbsp;181⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;32🍴</code></b> [LightNode](https://github.com/neuecc/LightNode)) - Micro RPC/REST Framework built on OWIN [http://neuecc.github.io/LightNode](http://neuecc.github.io/LightNode).
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;43⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;7🍴</code></b> [NetCoreStack.Proxy](https://github.com/NetCoreStack/Proxy)) - The type-safe, distributed REST library for .NET Standard 2.0 (NetCoreStack Flying Proxy)
* <b><code>&nbsp;&nbsp;6837⭐</code></b> <b><code>&nbsp;&nbsp;1299🍴</code></b> [NSwag](https://github.com/RSuter/NSwag)) - The Swagger/OpenAPI toolchain for .NET, Web API and TypeScript. [http://NSwag.org](http://NSwag.org).
* <b><code>&nbsp;&nbsp;&nbsp;854⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;473🍴</code></b> [OData](https://github.com/OData/WebApi/tree/feature/netcore)) - The Open Data Protocol (OData) enables the creation of HTTP-based data services, which allow resources identified using Uniform Resource Identifiers (URIs) and defined in an abstract data model, to be published and edited by Web clients using simple HTTP messages.
* <b><code>&nbsp;22191⭐</code></b> <b><code>&nbsp;&nbsp;6632🍴</code></b> [OpenAPI Generator](https://github.com/OpenAPITools/openapi-generator)) - OpenAPI Generator allows generation of API client libraries (e.g. C#, TypeScript, etc), server stubs (ASP.NET Core, NancyFx, etc), documentation and configuration automatically given an OpenAPI Spec (v2, v3).
* <b><code>&nbsp;&nbsp;8688⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;746🍴</code></b> [refit](https://github.com/paulcbetts/refit)) - The automatic type-safe REST library for Xamarin and .NET.
* <b><code>&nbsp;&nbsp;&nbsp;366⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;44🍴</code></b> [RestClient.Net](https://github.com/MelbourneDeveloper/RestClient.Net)) - Cross Platform REST Client for all C# platforms
* <b><code>&nbsp;&nbsp;1087⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;109🍴</code></b> [RestEase](https://github.com/canton7/RestEase)) - Easy-to-use typesafe REST API client library, which is simple and customisable.
* <b><code>&nbsp;&nbsp;&nbsp;111⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;11🍴</code></b> [RestLess](https://github.com/letsar/RestLess)) - The automatic type-safe-reflectionless REST API client library for .Net Standard.
* <b><code>&nbsp;&nbsp;&nbsp;474⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;136🍴</code></b> [Restier](https://github.com/OData/RESTier)) - RESTier is a RESTful API development framework for building standardized, OData V4 based RESTful services on .NET platform.
* <b><code>&nbsp;&nbsp;9639⭐</code></b> <b><code>&nbsp;&nbsp;2336🍴</code></b> [Restsharp](https://github.com/restsharp/RestSharp)) - Simple REST and HTTP API Client for .NET
* <b><code>&nbsp;&nbsp;5276⭐</code></b> <b><code>&nbsp;&nbsp;1321🍴</code></b> [Swashbuckle](https://github.com/domaindrivendev/Swashbuckle.AspNetCore)) - Seamlessly adds a swagger to WebApi projects.
  * <b><code>&nbsp;&nbsp;&nbsp;381⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [MicroElements.Swashbuckle.FluentValidation](https://github.com/micro-elements/MicroElements.Swashbuckle.FluentValidation)) - Adds FluentValidation rules to swagger.
  * <b><code>&nbsp;&nbsp;&nbsp;433⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;81🍴</code></b> [Swashbuckle.AspNetCore.Filters](https://github.com/mattfrear/Swashbuckle.AspNetCore.Filters)) - A bunch of useful filters for Swashbuckle.AspNetCore.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;27⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8🍴</code></b> [WebAnchor](https://github.com/mattiasnordqvist/Web-Anchor)) - Web Anchor provides type-safe, testable and flexible, runtime-generated access to web resources.
* <b><code>&nbsp;&nbsp;&nbsp;461⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;116🍴</code></b> [WebAPIContrib for ASP.NET CORE](https://github.com/WebApiContrib/WebAPIContrib.Core)) - Community Contributions for ASP.NET Core.

### Application Frameworks
* <b><code>&nbsp;11847⭐</code></b> <b><code>&nbsp;&nbsp;3800🍴</code></b> [ASP.NET Boilerplate](https://github.com/aspnetboilerplate/aspnetboilerplate)) - ASP.NET Boilerplate is a general purpose application framework especially designed for new modern web applications. It uses already familiar tools and implements best practices around them to provide you a SOLID development experience.
* <b><code>&nbsp;13040⭐</code></b> <b><code>&nbsp;&nbsp;3467🍴</code></b> [Abp vNext](https://github.com/abpframework/abp)) - Abp vNext is the next generation of the open source <b><code>&nbsp;11847⭐</code></b> <b><code>&nbsp;&nbsp;3800🍴</code></b> [ASP.NET Boilerplate](https://github.com/aspnetboilerplate/aspnetboilerplate)) framework. It's a complete architecture and strong infrastructure to create modern web applications!
Follows best practices and conventions to provide you a SOLID development experience.
* <b><code>&nbsp;&nbsp;3540⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;357🍴</code></b> [AsyncEx](https://github.com/StephenCleary/AsyncEx)) - A helper library for async/await.
* <b><code>&nbsp;&nbsp;&nbsp;489⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;93🍴</code></b> [Aeron.NET](https://github.com/AdaptiveConsulting/Aeron.NET)) - Efficient reliable UDP unicast, UDP multicast, and IPC message transport - .NET port of Aeron.
* <b><code>&nbsp;&nbsp;4738⭐</code></b> <b><code>&nbsp;&nbsp;1039🍴</code></b> [akka.net](https://github.com/akkadotnet/akka.net)) - Toolkit and runtime for building highly concurrent, distributed, and fault tolerant event-driven applications on .NET & Mono.
* <b><code>&nbsp;&nbsp;&nbsp;437⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;59🍴</code></b> [Aggregates.NET](https://github.com/volak/Aggregates.NET)) - Aggregates.NET is a framework to help developers integrate the excellent NServiceBus and EventStore libraries together.
* <b><code>&nbsp;35674⭐</code></b> <b><code>&nbsp;10118🍴</code></b> [ASP.NET MVC](https://github.com/dotnet/aspnetcore/tree/master/src/Mvc)) - Model view controller framework for building dynamic web sites with clean separation of concerns, including the merged MVC, Web API, and Web Pages w/ Razor.
* <b><code>&nbsp;&nbsp;&nbsp;275⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;30🍴</code></b> [Butterfly Server .NET](https://github.com/firesharkstudios/butterfly-server-dotnet)) - Allows building real-time web apps and native apps with minimal effort. Define a Web API and Subscription API that automatically synchronizes datasets across connected clients.
* <b><code>&nbsp;&nbsp;6730⭐</code></b> <b><code>&nbsp;&nbsp;1291🍴</code></b> [CAP](https://github.com/dotnetcore/CAP)) - An EventBus with local persistent message functionality for system integration in SOA or Microservice architecture.
* <b><code>&nbsp;&nbsp;2176⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;178🍴</code></b> [Carter](https://github.com/CarterCommunity/Carter)) - Carter is a library that allows Nancy-esque routing for use with ASP.Net Core.
* <b><code>&nbsp;&nbsp;2977⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;278🍴</code></b> [Chromely](https://github.com/mattkol/Chromely)) - Lightweight Alternative to Electron.NET, Electron for .NET/.NET Core.
* <b><code>&nbsp;&nbsp;&nbsp;805⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;135🍴</code></b> [Cinchoo ETL](https://github.com/Cinchoo/ChoETL)) - ETL Framework for .NET (Parser / Writer for CSV, Flat, Xml, JSON, Key-Value formatted files).
* <b><code>&nbsp;&nbsp;1100⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;266🍴</code></b> [CQRSlite](https://github.com/gautema/CQRSlite)) - Lightweight framework for helping writing CQRS and Eventsourcing applications in C#.
* <b><code>&nbsp;&nbsp;&nbsp;140⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;45🍴</code></b> [dataaccess_aspnetcore](https://github.com/digipolisantwerp/dataaccess_aspnetcore)) - The DataAccess Toolbox contains the base classes for data access in ASP.NET Core with Entity Framework Core 1.0 using the unit-of-work and repository pattern.
* <b><code>&nbsp;&nbsp;&nbsp;318⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;75🍴</code></b> [DNTFrameworkCore](https://github.com/rabbal/DNTFrameworkCore)) - Lightweight and Extensible Infrastructure for Building High Quality Web Applications Based on ASP.NET Core.
* <b><code>&nbsp;&nbsp;1618⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;230🍴</code></b> [DotNetCorePlugins](https://github.com/natemcmaster/DotNetCorePlugins)) - .NET Core library for loading assemblies as a plugin.
* <b><code>&nbsp;&nbsp;4007⭐</code></b> <b><code>&nbsp;&nbsp;1037🍴</code></b> [DotnetSpider](https://github.com/dotnetcore/DotnetSpider)) - DotnetSpider, a .NET Standard web crawling library similar to WebMagic and Scrapy. It is a lightweight ,efficient and fast high-level web crawling & scraping framework for .NET.
* <b><code>&nbsp;&nbsp;4108⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;981🍴</code></b> [DotNetty](https://github.com/Azure/DotNetty)) - Port of netty, event-driven asynchronous network application framework.
* <b><code>&nbsp;&nbsp;&nbsp;754⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;97🍴</code></b> [dotvvm](https://github.com/riganti/dotvvm)) - Open source MVVM framework for Web Apps.
* <b><code>&nbsp;&nbsp;7339⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;727🍴</code></b> [ElectronNET](https://github.com/ElectronNET/Electron.NET)) - Build cross platform desktop apps with ASP.NET NET Core.
* <b><code>&nbsp;&nbsp;1479⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;178🍴</code></b> [EmbedIO](https://github.com/unosquare/embedio)) - A tiny, cross-platform, module based web server for .NET Framework and .NET Core.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;11⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;31🍴</code></b> [Ether.Network](https://github.com/aloisdg/Ether.Network)) - Ether.Network is an open source networking library that allow developers to create simple, fast and scalable socket server or client applications over the TCP/IP protocol.
* <b><code>&nbsp;&nbsp;2394⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;445🍴</code></b> [EventFlow](https://github.com/eventflow/EventFlow)) - Async/await first CQRS+ES and DDD framework for .NET.
* <b><code>&nbsp;&nbsp;4020⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;973🍴</code></b> [ExcelDataReader](https://github.com/ExcelDataReader/ExcelDataReader)) - Lightweight and fast library written in C# for reading Microsoft Excel files.
* [ExtCore](https://github.com/ExtCore) - Free, open source and cross-platform framework for creating modular and extendable web applications based on ASP.NET Core 1.0.
* <b><code>&nbsp;&nbsp;1347⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;269🍴</code></b> [Finbuckle.MultiTenant](https://github.com/Finbuckle/Finbuckle.MultiTenant)) - Finbuckle.MultiTenant is a .NET Standard library for multitenant support designed for ASP.NET 2.0+. It provides functionality for tenant resolution, per-tenant app configuration, and per-tenant data isolation.
* <b><code>&nbsp;&nbsp;8457⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;793🍴</code></b> [fission](https://github.com/fission/fission)) - Fast Serverless Functions for Kubernetes.
* <b><code>&nbsp;42122⭐</code></b> <b><code>&nbsp;10599🍴</code></b> [grpc](https://github.com/grpc/grpc/tree/master/src/csharp)) - Remote Procedure Calls (RPCs) provide a useful abstraction for building distributed applications and services. The libraries in this repository provide a concrete implementation of the gRPC protocol, layered over HTTP/2. These libraries enable communication between clients and servers using any combination of the supported languages.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;12⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;44🍴</code></b> [Halibut](https://github.com/OctopusDeploy/Halibut)) - A secure communication stack for .NET using JSON-RPC over SSL.
* <b><code>&nbsp;&nbsp;3910⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;433🍴</code></b> [MagicOnion](https://github.com/neuecc/MagicOnion)) - gRPC based HTTP/2 RPC Streaming Framework for .NET, .NET Core and Unity.
* <b><code>&nbsp;&nbsp;7073⭐</code></b> <b><code>&nbsp;&nbsp;1636🍴</code></b> [MassTransit](https://github.com/MassTransit/MassTransit)) - Distributed Application Framework for .NET. 
* <b><code>&nbsp;&nbsp;1540⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;230🍴</code></b> [microdot](https://github.com/gigya/microdot)) - An open source .NET microservices framework.
* <b><code>&nbsp;&nbsp;3706⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;415🍴</code></b> [MoreLINQ](https://github.com/morelinq/MoreLINQ)) - Extensions to LINQ to Objects.
* <b><code>&nbsp;&nbsp;7149⭐</code></b> <b><code>&nbsp;&nbsp;1462🍴</code></b> [Nancy](https://github.com/NancyFx/Nancy)) - Lightweight, low-ceremony, framework for building HTTP based services on .NET and Mono.
* <b><code>&nbsp;&nbsp;5454⭐</code></b> <b><code>&nbsp;&nbsp;1155🍴</code></b> [opencvsharp](https://github.com/shimat/opencvsharp)) - .NET Framework wrapper for OpenCV.
* <b><code>&nbsp;10165⭐</code></b> <b><code>&nbsp;&nbsp;2040🍴</code></b> [orleans](https://github.com/dotnet/orleans)) - Framework that provides a straight-forward approach to building distributed high-scale computing applications, without the need to learn and apply complex concurrency or other scaling patterns.
* <b><code>&nbsp;&nbsp;6387⭐</code></b> <b><code>&nbsp;&nbsp;1643🍴</code></b> [Prism](https://github.com/PrismLibrary/Prism)) - Prism is a framework for building loosely coupled, maintainable, and testable XAML applications in WPF, Windows 10 UWP, and Xamarin Forms.
* <b><code>&nbsp;&nbsp;1744⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;288🍴</code></b> [protoactor-dotnet](https://github.com/AsynkronIT/protoactor-dotnet)) - Ultra fast distributed actors for Golang and C# [http://proto.actor](http://proto.actor).
* <b><code>&nbsp;&nbsp;&nbsp;569⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;40🍴</code></b> [resin](https://github.com/kreeben/resin)) - 16-bit wide vector space search engine with HTTP API and pluggable read/write pipelines.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;52⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;9🍴</code></b> [RService.io](https://github.com/Stoom/RService.IO)) - ASP.Net Core RESTful microservice framework that focusing on speed and ease of use.
* <b><code>&nbsp;&nbsp;5415⭐</code></b> <b><code>&nbsp;&nbsp;1628🍴</code></b> [ServiceStack](https://github.com/ServiceStack/ServiceStack)) - Thoughtfully architected, obscenely fast, thoroughly enjoyable web services for all 🌎 [https://servicestack.net](servicestack.net).
* [Steeltoe OSS](https://github.com/SteelToeOSS) - .NET toolkit for common microservice patterns.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;75⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8🍴</code></b> [Strathweb.TypedRouting.AspNetCore](https://github.com/filipw/Strathweb.TypedRouting.AspNetCore)) - A library enabling strongly typed routing in ASP.NET Core MVC projects.
* <b><code>&nbsp;&nbsp;3243⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;922🍴</code></b> [surging](https://github.com/dotnetcore/surging)) - Surging is a micro-service engine that provides a lightweight, high-performance, modular RPC request pipeline. The service engine supports http, TCP, WS, Mqtt, UDP, and DNS protocols. It uses ZooKeeper and Consul as a registry,  Hash Algorithms, random, polling, pressure minimum priority as a load balancing algorithm, built-in service governance to ensure reliable RPC communication.
* <b><code>&nbsp;&nbsp;&nbsp;101⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8🍴</code></b> [Xer.Cqrs](https://github.com/jeyjeyemem/Xer.Cqrs)) - A simple library for creating applications based on the CQRS pattern with support for attribute routing and hosted handlers. Developed in C# targeting .NET Standard 1.0.
* <b><code>&nbsp;&nbsp;&nbsp;910⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;216🍴</code></b> [X.PagedList](https://github.com/dncuug/X.PagedList)) - Library for easily paging through any IEnumerable/IQueryable in ASP.NET/ASP.NET Core.

### Application Templates
* <b><code>&nbsp;&nbsp;3414⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;493🍴</code></b> [.NET Boxed](https://github.com/Dotnet-Boxed/Templates)) - Project templates with batteries included, providing the minimum amount of code required to get you going. Includes ASP.NET Core API and GraphQL Templates.
* <b><code>&nbsp;&nbsp;&nbsp;633⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;183🍴</code></b> [aspnet-core-react-template](https://github.com/bradymholt/aspnet-core-react-template)) - ASP.NET Core 2.0 / React SPA Template App.
* <b><code>&nbsp;&nbsp;1480⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;464🍴</code></b> [AspNetCoreSpa](https://github.com/asadsahi/AspNetCoreSpa)) - Asp.Net Core 2+ & Angular 6 SPA with Angular CLI full featured application.
* <b><code>&nbsp;&nbsp;1074⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;173🍴</code></b> [ASP.NET-MVC-Template](https://github.com/NikolayIT/ASP.NET-MVC-Template)) - A ready-to-use templates for ASP.NET MVC 5 and ASP.NET Core with repositories, services, models mapping and DI and StyleCop warnings fixed.
* <b><code>&nbsp;&nbsp;&nbsp;250⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;66🍴</code></b> [AddFeatureFolders](https://github.com/OdeToCode/AddFeatureFolders)) - Enable feature folders for MVC controllers and views in ASP.NET Core.
* <b><code>&nbsp;&nbsp;&nbsp;487⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;128🍴</code></b> [Angular Visual Studio Webpack Starter](https://github.com/damienbod/AngularWebpackVisualStudio)) - Template for Webpack, Visual Studio, ASP.NET Core and Angular. Both the client and the server side of the application are implemented inside one ASP.NET Core project which makes it easier to deploy.
* <b><code>&nbsp;16538⭐</code></b> <b><code>&nbsp;&nbsp;2852🍴</code></b> [CleanArchitecture](https://github.com/ardalis/CleanArchitecture)) - A starting point for Clean Architecture with ASP.NET Core. Clean Architecture is just the latest in a series of names for the same loosely-coupled, dependency-inverted architecture. You will also find it named hexagonal, ports-and-adapters, or onion architecture.
* <b><code>&nbsp;17197⭐</code></b> <b><code>&nbsp;&nbsp;3680🍴</code></b> [CleanArchitecture (SPA)](https://github.com/JasonGT/CleanArchitecture)) - Solution template for creating a Single Page App (SPA) with Angular 8 and ASP.NET Core 3 following the principles of Clean Architecture
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;34⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8🍴</code></b> [DNTFrameworkCoreTemplate](https://github.com/rabbal/DNTFrameworkCoreTemplate)) - Boilerplate project templates based on <b><code>&nbsp;&nbsp;&nbsp;318⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;75🍴</code></b> [DNTFrameworkCore](https://github.com/rabbal/DNTFrameworkCore))
* <b><code>&nbsp;&nbsp;&nbsp;248⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;34🍴</code></b> [dotnet new caju](https://github.com/ivanpaulovich/dotnet-new-caju)) - dotnet new templates with awesome architecture styles! Increases productivity to design layered applications based on Hexagonal, Clean or Event Sourcing architectures styles. It supports multiple data access frameworks (MongoDB, EntityFramework, Dapper or Kafka) and it is completely testable.
* <b><code>&nbsp;&nbsp;&nbsp;225⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;55🍴</code></b> [EISK](https://github.com/EISK/eisk.webapi)) - Provides developer resources with simple use cases to build scalable applications on top of .NET Core with 🌎 [architectural best practices](docs.microsoft.com/en-us/dotnet/standard/modern-web-apps-azure-architecture/common-web-application-architectures) (DDD, onion architecture etc)
* <b><code>&nbsp;&nbsp;3038⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;520🍴</code></b> [JavaScriptServices](https://github.com/aspnet/JavaScriptServices)) - Microsoft ASP.NET Core JavaScript Services.
* <b><code>&nbsp;&nbsp;2543⭐</code></b> <b><code>&nbsp;&nbsp;1904🍴</code></b> [kendo-ui-core](https://github.com/telerik/kendo-ui-core)) - An HTML5, jQuery-based widget library for building modern web apps. [http://www.telerik.com/kendo-ui](http://www.telerik.com/kendo-ui).
* <b><code>&nbsp;&nbsp;1273⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;600🍴</code></b> [QuickApp](https://github.com/emonney/QuickApp)) - ASP.NET Core / Angular4 startup project template with complete login, user and role management.
* <b><code>&nbsp;&nbsp;2609⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;802🍴</code></b> [Serenity](https://github.com/volkanceylan/Serenity)) - Serenity is an ASP.NET MVC / TypeScript application platform designed to simplify and shorten development of data-centric business applications with a service based architecture.
* <b><code>&nbsp;&nbsp;&nbsp;212⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;36🍴</code></b> [Toucan](https://github.com/mrellipse/toucan)) - Boilerplate for building single page apps. Server is multi-project .Net Core solution designed around SOLID principles. Client is TypeScript 2, Vuejs 2, Vuex 2.

### Authentication and Authorization
* <b><code>&nbsp;&nbsp;&nbsp;560⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;149🍴</code></b> [AspNet.Security.OpenIdConnect.Server](https://github.com/aspnet-contrib/AspNet.Security.OpenIdConnect.Server)) - OpenID Connect/OAuth2 server framework for OWIN/Katana and ASP.NET Core.
* <b><code>&nbsp;&nbsp;&nbsp;329⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;164🍴</code></b> [Auth0](https://github.com/auth0/auth0.net)) - Hosted, enterprise-grade platform for modern identity.
* <b><code>&nbsp;&nbsp;1180⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;111🍴</code></b> [Casbin.NET](https://github.com/casbin-net/Casbin.NET)) - Authorization library that supports access control models like ACL, RBAC, ABAC in C#
* <b><code>&nbsp;&nbsp;1962⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;866🍴</code></b> [Identity](https://github.com/aspnet/Identity)) - ASP.NET Core Identity is the membership system for building ASP.NET Core web applications, including membership, login, and user data.
* <b><code>&nbsp;&nbsp;9233⭐</code></b> <b><code>&nbsp;&nbsp;4026🍴</code></b> [IdentityServer](https://github.com/IdentityServer/IdentityServer4)) - IdentityServer for ASP.NET Core 1.0 & 2.0
  * <b><code>&nbsp;&nbsp;&nbsp;242⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;164🍴</code></b> [IdentityServer4.EntityFramework](https://github.com/IdentityServer/IdentityServer4.EntityFramework)) - EntityFramework persistence layer
  * <b><code>&nbsp;&nbsp;&nbsp;111⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;59🍴</code></b> [IdentityServer4.MongoDB](https://github.com/diogodamiani/IdentityServer4.MongoDB)) - MongoDB persistence layer
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;41⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13🍴</code></b> [IdentityServer4.EntityFrameworkCore](https://github.com/2020IP/TwentyTwenty.IdentityServer4.EntityFrameworkCore)) - Entity Framework Core persistence layer
  * <b><code>&nbsp;&nbsp;&nbsp;696⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;230🍴</code></b> [IdentityServer4.Templates](https://github.com/IdentityServer/IdentityServer4.Templates)) - dotnet cli templates for IdentityServer4.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;89⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;54🍴</code></b> [Okta](https://github.com/okta/okta-aspnet)) - Hosted, enterprise-grade platform for modern identity.
* <b><code>&nbsp;&nbsp;4484⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;528🍴</code></b> [openiddict](https://github.com/openiddict/openiddict-core)) - Easy-to-use OpenID Connect server for ASP.NET Core.
  * <b><code>&nbsp;&nbsp;&nbsp;224⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;29🍴</code></b> [oidc-debugger](https://github.com/nbarbettini/oidc-debugger)) - OAuth 2.0 and OpenID Connect debugging tool.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;55⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13🍴</code></b> [stormpath-sdk](https://github.com/stormpath/stormpath-sdk-dotnet)) - Build <b><code>&nbsp;&nbsp;&nbsp;&nbsp;18⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2🍴</code></b> [simple, secure web applications](https://github.com/stormpath/stormpath-aspnetcore)) with Stormpath and ASP.NET Core. 
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;55⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13🍴</code></b> [stormpath-sdk](https://github.com/stormpath/stormpath-sdk-dotnet)) - Build <b><code>&nbsp;&nbsp;&nbsp;&nbsp;18⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2🍴</code></b> [simple, secure web applications](https://github.com/stormpath/stormpath-aspnetcore)) with Stormpath and ASP.NET Core.(Deprecated: It will longer get updated as of March 2017 after joining OKTA) 
* <b><code>&nbsp;&nbsp;&nbsp;294⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;35🍴</code></b> [stuntman](https://github.com/ritterim/stuntman)) - Library for impersonating users during development leveraging ASP.NET Identity.

### Blockchain
* <b><code>&nbsp;&nbsp;6473⭐</code></b> <b><code>&nbsp;&nbsp;1668🍴</code></b> [BTCPayServer](https://github.com/btcpayserver/btcpayserver)) - A cross platform, self-hosted server compatible with Bitpay API.
* <b><code>&nbsp;&nbsp;&nbsp;142⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;23🍴</code></b> [Meadow](https://github.com/MeadowSuite/Meadow)) - An integrated Ethereum implementation and tool suite focused on Solidity testing and development.
* <b><code>&nbsp;&nbsp;1893⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;850🍴</code></b> [NBitcoin](https://github.com/MetacoSA/NBitcoin)) - Comprehensive Bitcoin library for the .NET framework.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;83⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;20🍴</code></b> [NBlockchain](https://github.com/danielgerlag/NBlockchain)) - .NET standard library for building blockchain enabled applications
* <b><code>&nbsp;&nbsp;&nbsp;324⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;213🍴</code></b> [NBXplorer](https://github.com/dgarage/NBXplorer)) - A Bitcoin and Altcoin lightweight block explorer.
* <b><code>&nbsp;&nbsp;3472⭐</code></b> <b><code>&nbsp;&nbsp;1032🍴</code></b> [NEO](https://github.com/neo-project/neo)) - Open Network For Smart Economy.
* [Nethereum](https://github.com/Nethereum) - Bringing the love of Ethereum to .NET.
* <b><code>&nbsp;&nbsp;1290⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;451🍴</code></b> [Nethermind](https://github.com/NethermindEth/nethermind)) - .NET Core Ethereum client
* <b><code>&nbsp;&nbsp;&nbsp;789⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;312🍴</code></b> [StratisBitcoinFullNode](https://github.com/stratisproject/StratisBitcoinFullNode)) - Simple and affordable end-to-end solutions for development, testing and deployment of native C# blockchain applications on the .Net framework.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;44⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;12🍴</code></b> [Trezor.Net](https://github.com/MelbourneDeveloper/Trezor.Net)) - Cross platform C# library for talking to the Trezor Hardwarewallet
* <b><code>&nbsp;&nbsp;2208⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;504🍴</code></b> [WalletWasabi](https://github.com/zkSNACKs/WalletWasabi)) - Privacy focused, ZeroLink compliant Bitcoin wallet.

### Bot
* <b><code>&nbsp;&nbsp;2259⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;468🍴</code></b> [BotSharp](https://github.com/SciSharp/BotSharp)) - The Open Source AI Chatbot Platform Builder in 100% C# Running in .NET Core with Machine Learning algorithm.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [NadekoBot](https://github.com/Kwoth/NadekoBot)) - Open source, general-purpose Discord chat bot written in C#.
* <b><code>&nbsp;&nbsp;3262⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;696🍴</code></b> [Telegram.Bot](https://github.com/TelegramBots/Telegram.Bot)) - C# Telegram Bot API library.
* <b><code>&nbsp;&nbsp;&nbsp;105⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;20🍴</code></b> [Funogram](https://github.com/Dolfik1/Funogram)) - F# Telegram Bot Api library.

### Build Automation
* <b><code>&nbsp;&nbsp;3929⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;732🍴</code></b> [cake-build](https://github.com/cake-build/cake)) - Cross platform build automation system.
* 🌎 [CatLight](catlight.io) - Status notifier for developers that monitors builds and tasks in the project. Built using .Net Core and Electron.
* <b><code>&nbsp;&nbsp;1312⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;128🍴</code></b> [Colorful.Console](https://github.com/tomakita/Colorful.Console)) - Style your C# console output!
* <b><code>&nbsp;&nbsp;4525⭐</code></b> <b><code>&nbsp;&nbsp;1935🍴</code></b> [dotnet-docker](https://github.com/dotnet/dotnet-docker)) - The base Docker images for working with .NET Core and the .NET Core Tools.
* <b><code>&nbsp;&nbsp;&nbsp;176⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8🍴</code></b> [Dockerize.NET](https://github.com/brthor/Dockerize.NET)) - .NET Cli Tool to package your .NET Core Application into a docker image: 'dotnet dockerize'
* <b><code>&nbsp;&nbsp;&nbsp;909⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;103🍴</code></b> [FlubuCore](https://github.com/dotnetcore/FlubuCore)) - A cross platform build and deployment automation system for building projects and executing deployment scripts using C# code.
* <b><code>&nbsp;&nbsp;&nbsp;568⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;71🍴</code></b> [GitInfo](https://github.com/kzu/GitInfo)) - Git and SemVer Info from MSBuild, C# and VB.
* <b><code>&nbsp;&nbsp;1405⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;171🍴</code></b> [GitVersioning](https://github.com/AArnott/Nerdbank.GitVersioning)) - Stamp your assemblies and NuGet packages with a version from a single, simple version.txt file and include git commit IDs for non-official builds.
* <b><code>&nbsp;&nbsp;&nbsp;483⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;42🍴</code></b> [go-dotnet](https://github.com/matiasinsaurralde/go-dotnet)) - Go wrapper for the .NET Core Runtime.
* <b><code>&nbsp;&nbsp;&nbsp;305⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;78🍴</code></b> [Image2Docker](https://github.com/docker/communitytools-image2docker-win)) - PowerShell module which ports existing Windows application workloads to Docker.
* <b><code>&nbsp;&nbsp;&nbsp;123⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;18🍴</code></b> [LocalAppVeyor](https://github.com/joaope/LocalAppVeyor)) - Run your AppVeyor builds, locally.
* <b><code>&nbsp;&nbsp;5257⭐</code></b> <b><code>&nbsp;&nbsp;1357🍴</code></b> [msbuild](https://github.com/Microsoft/msbuild)) - The Microsoft Build Engine is a platform for building applications.
* <b><code>&nbsp;&nbsp;3116⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;374🍴</code></b> [Nuke](https://github.com/nuke-build/nuke)) - Cross-platform build automation system.
* <b><code>&nbsp;&nbsp;4517⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;825🍴</code></b> [Opserver](https://github.com/opserver/Opserver)) - Stack Exchange's Monitoring System.
* <b><code>&nbsp;&nbsp;1731⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;869🍴</code></b> [vsts-agent](https://github.com/Microsoft/vsts-agent/blob/master/README.md)) - Visual Studio Team Services Build and Release Agent.

### Bundling and Minification
* <b><code>&nbsp;&nbsp;&nbsp;616⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;173🍴</code></b> [BundlerMinifier](https://github.com/madskristensen/BundlerMinifier)) - Visual Studio extension that let's you configure bundling and minification of JS, CSS and HTML files.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;75⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13🍴</code></b> [JavaScriptViewEngine](https://github.com/pauldotknopf/JavaScriptViewEngine)) - ASP.NET MVC ViewEngine for rendering markup in a JavaScript environment. Ideal for React and Angular server-side rendering.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Smidge](https://github.com/Shazwazza/Smidge/)) - Lightweight runtime CSS/JavaScript file minification, combination, compression & management library for ASP.NET Core.
* <b><code>&nbsp;&nbsp;&nbsp;459⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;48🍴</code></b> [Web Markup Minifier](https://github.com/Taritsyn/WebMarkupMin)) - .NET library that contains a set of markup minifiers. The objective of this project is to improve the performance of web applications by reducing the size of HTML, XHTML and XML code.

### Caching
* <b><code>&nbsp;&nbsp;2349⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;456🍴</code></b> [CacheManager](https://github.com/MichaCo/CacheManager)) - Open source caching abstraction layer for .NET written in C#. It supports various cache providers and implements many advanced features. [http://cachemanager.michaco.net](http://cachemanager.michaco.net)
* <b><code>&nbsp;&nbsp;1976⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;328🍴</code></b> [EasyCaching](https://github.com/dotnetcore/EasyCaching)) - Open source caching library that contains basic usages and some advanced usages of caching which can help us to handle caching more easier.
* <b><code>&nbsp;&nbsp;6333⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;569🍴</code></b> [Faster](https://github.com/Microsoft/FASTER/tree/master/cs)) - Fast key-value store from Microsoft Research.
* <b><code>&nbsp;&nbsp;1992⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;244🍴</code></b> [Foundatio](https://github.com/exceptionless/Foundatio)) - Pluggable foundation blocks for building distributed apps.
* <b><code>&nbsp;&nbsp;&nbsp;480⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;217🍴</code></b> [Microsoft Caching](https://github.com/aspnet/Caching)) - Libraries for in-memory caching and distributed caching.
* <b><code>&nbsp;&nbsp;5930⭐</code></b> <b><code>&nbsp;&nbsp;1511🍴</code></b> [Stack Exchange Redis](https://github.com/StackExchange/StackExchange.Redis)) - High performance general purpose redis client for .NET languages (C# etc).

### CMS
* <b><code>&nbsp;&nbsp;&nbsp;420⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;135🍴</code></b> [Awesome-CMS-Core](https://github.com/SaiGonSoftware/Awesome-CMS-Core)) - Awesome CMS Core is an open source CMS built using ASP.Net Core & ReactJS with module separation concern in mind and provide lastest trend of technology
* <b><code>&nbsp;&nbsp;1286⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;519🍴</code></b> [Blogifier.Core](https://github.com/blogifierdotnet/Blogifier.Core)) - ASP.NET applications to provide common blogging functionality.
* <b><code>&nbsp;&nbsp;&nbsp;839⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;146🍴</code></b> [Cofoundry](https://github.com/cofoundry-cms/cofoundry)) - Open source .NET Core CMS and modular application framework. Code-first, unobtrusive and extensible.
* <b><code>&nbsp;&nbsp;&nbsp;417⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;158🍴</code></b> [CoreWiki](https://github.com/csharpfritz/CoreWiki)) - Simple ASP.NET Core wiki that we are working on during live coding streams.
* <b><code>&nbsp;&nbsp;&nbsp;472⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;196🍴</code></b> [dasblog-core](https://github.com/poppastring/dasblog-core)) - The original DasBlog reimagined with ASP.NET Core
* <b><code>&nbsp;&nbsp;&nbsp;190⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;28🍴</code></b> [Lynicon](https://github.com/jamesej/lyniconanc)) - O/S ASP.Net Core/.Net Core CMS with paid for modules: JSON content, works with variety of data stores, c# content types
* <b><code>&nbsp;&nbsp;1478⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;499🍴</code></b> [Miniblog](https://github.com/madskristensen/Miniblog.Core)) - An ASP.NET Core blogging engine.
* <b><code>&nbsp;&nbsp;&nbsp;827⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;206🍴</code></b> [Mixcore CMS](https://github.com/mixcore/mix.core)) - Open Source CMS powered by DotNet Core. Mixcore CMS is a scalable, open platform for web content management and digital experiences. Mixcore CMS provides deep capabilities and endless flexibility on the web.
* <b><code>&nbsp;&nbsp;&nbsp;167⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;77🍴</code></b> [NetCoreCMS](https://github.com/OnnoRokomSoftware/NetCoreCMS)) - An Open source ASP.NET Core 2.0 CMS. It currently supports MySQL and planned to implement MSSQL, SQLite and PostgreSQL. Also it is a modular CMS supports theme, skin, custom layout, widgets, multiple language (En, BN).
* <b><code>&nbsp;&nbsp;7487⭐</code></b> <b><code>&nbsp;&nbsp;2419🍴</code></b> [Orchard Core CMS](https://github.com/OrchardCMS/OrchardCore)) - Open Source Content Management System built with ASP.NET Core on top of a Modular and Extensible Application Framework.
* <b><code>&nbsp;&nbsp;2038⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;562🍴</code></b> [Piranha CMS](https://github.com/piranhacms/piranha.core)) - A Lightweight & Unobtrusive Open Source CMS for ASP.NET Core and Entity Framework Core.
* [Platformus](https://github.com/Platformus) - Free, open source and cross-platform CMS based on ASP.NET Core 1.0 and ExtCore framework.
* <b><code>&nbsp;&nbsp;&nbsp;334⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;63🍴</code></b> [SimpleContent](https://github.com/joeaudette/cloudscribe.SimpleContent)) - Simple, yet flexible content and blog engine for ASP.NET Core that can work with or without a database.
* <b><code>&nbsp;&nbsp;2285⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;458🍴</code></b> [Squidex](https://github.com/Squidex/squidex)) - Headless CMS, based on MongoDB, CQRS and Event Sourcing.
* <b><code>&nbsp;&nbsp;&nbsp;134⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;59🍴</code></b> [Swastika I/O Core CMS](https://github.com/Swastika-IO/Swastika-IO-Core)) - Open source ASP.NET Core 2.x CMS. It currently supports MS SQL and planned to implement MSSQL, SQLite in the near future. It has many built-in features out of the box like multilanguage support, theme, template...
* <b><code>&nbsp;&nbsp;4582⭐</code></b> <b><code>&nbsp;&nbsp;2717🍴</code></b> [Umbraco](https://github.com/umbraco/umbraco-cms)) - An extensible and friendly Open source ASP.NET Core CMS
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;10⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2🍴</code></b> [Weapsy](https://github.com/Weapsy/Weapsy)) - Open source ASP.NET Core CMS based on DDD and CQRS. It supports MSSQL, MySQL, SQLite and PostgreSQL out of the box.
* <b><code>&nbsp;&nbsp;&nbsp;141⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;29🍴</code></b> [Wyam](https://github.com/Wyamio/Wyam)) - Modular static content and static site generator.
* <b><code>&nbsp;&nbsp;2816⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;865🍴</code></b> [ZKEACMS](https://github.com/SeriaWei/ZKEACMS.Core)) - Visual design, build site onlie by drag and drop.

### Code Analysis and Metrics
* <b><code>&nbsp;13428⭐</code></b> <b><code>&nbsp;&nbsp;1359🍴</code></b> [awesome-static-analysis](https://github.com/mre/awesome-static-analysis)) - Curated list of static analysis tools, linters and code quality checkers for various programming languages.
* Code Analysis
  * <b><code>&nbsp;&nbsp;1236⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;244🍴</code></b> [CodeFormatter](https://github.com/dotnet/codeformatter)) - Tool that uses Roslyn to automatically rewrite the source to follow netfx coding styles. 🌎 [Nuget Package](www.nuget.org/packages/Dotnet.CodeFormatter.BuildTask.Fork) 
  * <b><code>&nbsp;&nbsp;&nbsp;920⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;115🍴</code></b> [DevSkim](https://github.com/Microsoft/DevSkim)) - A set of IDE plugins and rules that provide security "linting" capabilities.
  * <b><code>&nbsp;&nbsp;&nbsp;637⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;118🍴</code></b> [RefactoringEssentials](https://github.com/icsharpcode/RefactoringEssentials)) - Refactoring Essentials for Visual Studio.
  * <b><code>&nbsp;&nbsp;1597⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;468🍴</code></b> [roslyn-analyzers](https://github.com/dotnet/roslyn-analyzers)) - .NET Compiler Platform ("Roslyn") Analyzers.
  * <b><code>&nbsp;&nbsp;2674⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;509🍴</code></b> [StyleCopAnalyzers](https://github.com/DotNetAnalyzers/StyleCopAnalyzers)) - StyleCop rules using the .NET Compiler Platform.
* Metrics
  * <b><code>&nbsp;&nbsp;2222⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;288🍴</code></b> [AppMetrics](https://github.com/alhardy/AppMetrics)) - App Metrics is an open-source and cross-platform .NET library used to record and report metrics within an application and reports it's health.
  * <b><code>&nbsp;&nbsp;2323⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;323🍴</code></b> [Audit.NET](https://github.com/thepirat000/Audit.NET)) - Small framework to audit .NET object changes.
  * <b><code>&nbsp;10658⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;977🍴</code></b> [BenchmarkDotNet](https://github.com/dotnet/BenchmarkDotNet)) - Powerful .NET library for benchmarking.
  * <b><code>&nbsp;&nbsp;3000⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;386🍴</code></b> [coverlet](https://github.com/tonerdo/coverlet)) - Cross platform code coverage library for .NET Core.
  * <b><code>&nbsp;&nbsp;1992⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;244🍴</code></b> [Foundatio](https://github.com/exceptionless/Foundatio#metrics)) - A common interface with in memory, redis, StatsD, and Metrics.NET implementations.
  * <b><code>&nbsp;&nbsp;&nbsp;210⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;37🍴</code></b> [MiniCover](https://github.com/lucaslorentz/minicover)) - Minimalist Code Coverage Tool for .NET Core.
  * <b><code>&nbsp;&nbsp;&nbsp;534⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;47🍴</code></b> [NBench](https://github.com/petabridge/NBench)) - Performance benchmarking and testing framework for .NET applications.
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;9🍴</code></b> [Nexogen.Libraries.Metrics](https://github.com/nexogen-international/Nexogen.Libraries.Metrics)) - Library for collecting application metrics in .NET and exporting them to Prometheus.
  * <b><code>&nbsp;&nbsp;1313⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;248🍴</code></b> [OpenCover](https://github.com/OpenCover/opencover)) - Code coverage tool for .NET 2 and above (WINDOWS OS only), support for 32 and 64 processes with both branch and sequence points.
  * <b><code>&nbsp;&nbsp;&nbsp;238⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [PerformanceMonitor](https://github.com/dotnet-architecture/PerformanceMonitor)) - .NET Core Application Performance Monitor.
  * <b><code>&nbsp;&nbsp;1967⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;301🍴</code></b> [prometheus-net](https://github.com/prometheus-net/prometheus-net)) - .NET Client for 🌎 [https://prometheus.io](prometheus.io).
  * <b><code>&nbsp;&nbsp;&nbsp;129⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;21🍴</code></b> [Prometheus.Client](https://github.com/PrometheusClientNet/Prometheus.Client)) - .NET Client for 🌎 [Prometheus](prometheus.io).
  	* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;15⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;5🍴</code></b> [Prometheus.Client.MetricPusher](https://github.com/PrometheusClientNet/Prometheus.Client.MetricPusher)) -  Push metrics to a PushGateaway for the Prometheus.Client.
  	* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6🍴</code></b> [Prometheus.Client.AspNetCore](https://github.com/PrometheusClientNet/Prometheus.Client.AspNetCore)) -  Middleware for the Prometheus.Client.
  	* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;14⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;10🍴</code></b> [Prometheus.Client.MetricServer](https://github.com/PrometheusClientNet/Prometheus.Client.MetricServer)) -  MetricServer for the Prometheus.Client.
  	* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;10⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6🍴</code></b> [Prometheus.Client.HttpRequestDurations](https://github.com/PrometheusClientNet/Prometheus.Client.HttpRequestDurations)) -  Metrics logging of request durations for the Prometheus.Client.

### Compression
* <b><code>&nbsp;&nbsp;&nbsp;701⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;81🍴</code></b> [lz4net](https://github.com/MiloszKrajewski/K4os.Compression.LZ4)) - Ultra fast compression algorithm for all .NET platforms.
* <b><code>&nbsp;&nbsp;2298⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;484🍴</code></b> [sharpcompress](https://github.com/adamhathcock/sharpcompress)) - Fully managed C# library to deal with many compression types and formats.

### Compilers, Transpilers and Languages
* <b><code>&nbsp;&nbsp;2928⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;301🍴</code></b> [Fable](https://github.com/fable-compiler/Fable)) - F# to JavaScript Compiler.
* <b><code>&nbsp;&nbsp;&nbsp;532⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;46🍴</code></b> [fparsec](https://github.com/stephan-tolksdorf/fparsec)) - A parser combinatory library for F# and C#.
* <b><code>&nbsp;&nbsp;&nbsp;404⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;36🍴</code></b> [IL2C](https://github.com/kekyo/IL2C)) - A translator for ECMA-335 CIL/MSIL to C language.
* <b><code>&nbsp;&nbsp;&nbsp;369⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;24🍴</code></b> [Mond](https://github.com/Rohansi/Mond)) - A dynamically typed scripting language written in C# with a REPL, debugger, and simple embedding API.
* <b><code>&nbsp;&nbsp;2381⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;203🍴</code></b> [peachpie](https://github.com/peachpiecompiler/peachpie)) - Open-source PHP compiler to .NET.
* <b><code>&nbsp;&nbsp;&nbsp;931⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;71🍴</code></b> [Pidgin](https://github.com/benjamin-hodgson/Pidgin)) - A lightweight, fast and flexible parsing library for C#, developed at Stack Overflow.
* <b><code>&nbsp;19150⭐</code></b> <b><code>&nbsp;&nbsp;4050🍴</code></b> [roslyn](https://github.com/dotnet/roslyn)) - The .NET Compiler Platform ("Roslyn") provides open-source C# and Visual Basic compilers with rich code analysis APIs.
* <b><code>&nbsp;&nbsp;2374⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;215🍴</code></b> [Sprache](https://github.com/sprache/Sprache)) - Tiny C# Monadic Parser Framework.

### Cryptography
* <b><code>&nbsp;&nbsp;&nbsp;848⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;101🍴</code></b> [BCrypt.Net](https://github.com/BcryptNet/bcrypt.net)) - Bringing updates to the original bcrypt package.
* <b><code>&nbsp;&nbsp;&nbsp;216⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;28🍴</code></b> [BCrypt.NET-Core](https://github.com/neoKushan/BCrypt.Net-Core)) - .NET Core port of BCrypt.NET used to store passwords securely.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;91⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;22🍴</code></b> [BouncyCastle PCL](https://github.com/onovotny/BouncyCastle-PCL)) - The Bouncy Castle Crypto package is a C# implementation of cryptographic algorithms and protocols.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;48⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;15🍴</code></b> [multiformats](https://github.com/multiformats/cs-multihash)) - A general purpose hashing library, but a library to encode/decode Multihashes which is a "container" describing what hash algorithm the digest is calculated with.
* <b><code>&nbsp;&nbsp;&nbsp;400⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;55🍴</code></b> [nsec](https://github.com/ektrah/nsec)) - NSec is a new cryptographic library for .NET Core based on libsodium.
* [SecurityDriven.Inferno](github.com/sdrapkin/SecurityDriven.Inferno) - Hig level crypto library used .Net primitives, has been professionally audited.

### Database
* <b><code>&nbsp;&nbsp;&nbsp;533⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;58🍴</code></b> [DBreeze](https://github.com/hhblaze/DBreeze)) - C# .NET MONO NOSQL (key value store embedded) ACID multi-paradigm database management system.
* <b><code>&nbsp;&nbsp;&nbsp;445⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;65🍴</code></b> [JsonFlatFileDataStore](https://github.com/ttu/json-flatfile-datastore)) - Simple JSON flat file data store with support for typed and dynamic data.
* <b><code>&nbsp;&nbsp;8681⭐</code></b> <b><code>&nbsp;&nbsp;1257🍴</code></b> [LiteDB](https://github.com/mbdavid/LiteDB)) - .NET NoSQL Document Store in a single data file - [http://www.litedb.org](http://www.litedb.org).
* <b><code>&nbsp;&nbsp;&nbsp;182⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25🍴</code></b> [NoDb](https://github.com/joeaudette/NoDb)) - "no database" file system storage for .NET Core/ASP.NET Core because not every project needs a database.
* <b><code>&nbsp;&nbsp;2888⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;460🍴</code></b> [marten](https://github.com/JasperFx/marten)) - Postgresql as a Document Database and Event Store for .NET Applications [http://jasperfx.github.io/marten](http://jasperfx.github.io/marten).
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;71⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;12🍴</code></b> [StringDB](https://github.com/SirJosh3917/StringDB)) - StringDB is a modular, key/value pair archival DB designed to consume *tiny* amounts of ram & produce *tiny* databases.
* <b><code>&nbsp;&nbsp;1229⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;198🍴</code></b> [yessql](https://github.com/sebastienros/yessql)) - .NET document database working on any RDBMS.

### Database Drivers
* <b><code>&nbsp;&nbsp;&nbsp;640⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;233🍴</code></b> [cassandra-csharp-driver](https://github.com/datastax/csharp-driver)) - DataStax C# Driver for Apache Cassandra.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;96⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;870🍴</code></b> [confluent-kafka-dotnet](https://github.com/confluentinc/confluent-kafka-dotnet)) - Confluent's Apache Kafka .NET client.
* <b><code>&nbsp;&nbsp;&nbsp;439⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;126🍴</code></b> [couchbase-lite-net](https://github.com/couchbase/couchbase-lite-net)) - A lightweight, document-oriented (NoSQL), syncable database engine for .NET.
* <b><code>&nbsp;&nbsp;3156⭐</code></b> <b><code>&nbsp;&nbsp;1259🍴</code></b> [MongoDB.Driver](https://github.com/mongodb/mongo-csharp-driver)) - .NET Driver for MongoDB.
* <b><code>&nbsp;&nbsp;&nbsp;549⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;70🍴</code></b> [MongoDB.Entities](https://github.com/dj-nitehawk/MongoDB.Entities)) - A data access library for MongoDB with an elegant api, LINQ support and built-in entity relationship management
* MySQL
  * <b><code>&nbsp;&nbsp;&nbsp;295⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;193🍴</code></b> [mysql-connector-net](https://github.com/mysql/mysql-connector-net/tree/8.0)) - Connector/Net is a fully-managed ADO.NET driver for MySQL.
  * <b><code>&nbsp;&nbsp;1403⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;334🍴</code></b> [MySqlConnector](https://github.com/mysql-net/MySqlConnector)) - Async MySQL Connector for .NET and .NET Core.
* Neo4j
  * <b><code>&nbsp;&nbsp;&nbsp;231⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;70🍴</code></b> [neo4j-dotnet-driver](https://github.com/neo4j/neo4j-dotnet-driver)) - Neo4j Bolt driver for .NET.
  * <b><code>&nbsp;&nbsp;&nbsp;429⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;147🍴</code></b> [Neo4jClient](https://github.com/Readify/Neo4jClient)) - .NET client binding for Neo4j.
* <b><code>&nbsp;&nbsp;3353⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;825🍴</code></b> [npgsql](https://github.com/npgsql/npgsql)) - .NET data provider for PostgreSQL. It allows any program developed for .NET framework to access a PostgreSQL database server. It is implemented in 100% C# code. PostgreSQL versions since 9.1 are officially supported, others may work. [http://www.npgsql.org](http://www.npgsql.org)
* <b><code>&nbsp;&nbsp;&nbsp;296⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2🍴</code></b> [ravendb](https://github.com/ayende/ravendb/tree/v4.0)) - Linq enabled document database for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;384⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;134🍴</code></b> [RethinkDb.Driver](https://github.com/bchavez/RethinkDb.Driver)) - C#/.NET RethinkDB driver with 100% ReQL API coverage.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;48⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;16🍴</code></b> [progaudi.tarantool](https://github.com/progaudi/progaudi.tarantool)) - .NET client for Tarantool NoSql database.

### Database Tools and Utilities
* <b><code>&nbsp;&nbsp;2367⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;535🍴</code></b> [DbUp](https://github.com/DbUp/DbUp)) - .NET library that helps you to deploy changes to SQL Server databases. It tracks which SQL scripts have been run already, and runs the change scripts that are needed to get your database up to date.
* <b><code>&nbsp;&nbsp;&nbsp;853⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;112🍴</code></b> [Evolve](https://github.com/lecaillon/Evolve)) - Simple database migration tool that uses plain SQL scripts. Inspired by Flyway.
* <b><code>&nbsp;&nbsp;2216⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;300🍴</code></b> [EFCorePowerTools](https://github.com/ErikEJ/EFCorePowerTools)) - Entity Framework Core Power Tools - reverse engineering, migrations and model visualization for EF Core.
* <b><code>&nbsp;&nbsp;3282⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;659🍴</code></b> [fluentmigrator](https://github.com/fluentmigrator/fluentmigrator)) - Migration framework for .NET much like Ruby on Rails Migrations.
* <b><code>&nbsp;&nbsp;&nbsp;657⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;178🍴</code></b> [monitor-table-change-with-sqltabledependency](https://github.com/christiandelbianco/monitor-table-change-with-sqltabledependency)) - Get SQL Server notification on record table change.
* 🌎 [NReco.PivotData](www.nuget.org/packages/NReco.PivotData) - In-memory data cube with OLAP operations and PivotTable data model.
* <b><code>&nbsp;&nbsp;&nbsp;921⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;245🍴</code></b> [roundhouse](https://github.com/chucknorris/roundhouse)) - Database Migration Utility for .NET using sql files and versioning based on source control.
* <b><code>&nbsp;&nbsp;&nbsp;404⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;39🍴</code></b> [SapphireDb](https://github.com/SapphireDb/SapphireDb)) - Server implementation of SapphireDb, a framework for easy development of applications with realtime data synchronization and a self hosted alternative to firebase realtime database/firestore for asp.net core and ef core. Check out the documentation for more details: 🌎 [Documentation](sapphire-db.com)
* <b><code>&nbsp;&nbsp;&nbsp;657⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;169🍴</code></b> [SharpRepository](https://github.com/SharpRepository/SharpRepository)) - SharpRepository is a generic repository written in C# which includes support for various relational, document and object databases including Entity Framework, RavenDB, MongoDb and Db4o. SharpRepository includes Xml and InMemory repository implementations as well.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;76⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13🍴</code></b> [TrackableEntities.Core](https://github.com/TrackableEntities/TrackableEntities.Core)) - Change-tracking across service boundaries with .NET Core.
* <b><code>&nbsp;&nbsp;&nbsp;175⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [Mongo.Migration](https://github.com/SRoddis/Mongo.Migration)) - Mongo.Migration is designed for the [MongoDB C# Driver]( https://github.com/mongodb/mongo-csharp-driver) to migrate your documents easily and on-the-fly. No more downtime for schema-migrations. Just write small and simple migrations. [Link]( https://github.com/SRoddis/Mongo.Migration)
* <b><code>&nbsp;&nbsp;&nbsp;331⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;56🍴</code></b> [EntityFrameworkCore.DataEncryption](https://github.com/Eastrall/EntityFrameworkCore.DataEncryption)) - A plugin for Microsoft.EntityFrameworkCore to add support of encrypted fields using built-in or custom encryption providers.

### Date and Time
* <b><code>&nbsp;&nbsp;&nbsp;239⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;27🍴</code></b> [Exceptionless.DateTimeExtensions](https://github.com/exceptionless/Exceptionless.DateTimeExtensions)) - DateTimeRange, Business Day and various DateTime, DateTimeOffset, TimeSpan extension methods.
* <b><code>&nbsp;&nbsp;&nbsp;690⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [FluentDateTime](https://github.com/FluentDateTime/FluentDateTime)) - Allows you to write cleaner DateTime expressions and operation. Partially inspired by Ruby DateTime Extensions.
* <b><code>&nbsp;&nbsp;2811⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;336🍴</code></b> [nodatime](https://github.com/nodatime/nodatime)) - Better date and time API for .NET [http://nodatime.org](http://nodatime.org).

### Distributed Computing
* <b><code>&nbsp;&nbsp;4129⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;803🍴</code></b> [AspNetCore.Diagnostics.HealthChecks](https://github.com/xabaril/AspNetCore.Diagnostics.HealthChecks)) - Enterprise HealthChecks for ASP.NET Core Diagnostics Package
  - <b><code>&nbsp;&nbsp;&nbsp;604⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;56🍴</code></b> [BeatPulse](https://github.com/Xabaril/BeatPulse)) - Enable load balancers to montior the status of deployed Web applications
* <b><code>&nbsp;&nbsp;1992⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;244🍴</code></b> [Foundatio](https://github.com/exceptionless/Foundatio)) - Pluggable foundation blocks for building distributed apps
* <b><code>&nbsp;&nbsp;&nbsp;417⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;55🍴</code></b> [jasper](https://github.com/JasperFx/jasper)) - Next generation application development framework for .NET
* <b><code>&nbsp;&nbsp;&nbsp;196⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;30🍴</code></b> [Rafty](https://github.com/ThreeMammals/Rafty)) - RAFT consensus in .NET Core
* <b><code>&nbsp;&nbsp;&nbsp;333⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;45🍴</code></b> [Obvs](https://github.com/christopherread/Obvs)) - An observable microservice bus .NET library that wraps the underlying transport in simple Rx based interfaces
* <b><code>&nbsp;&nbsp;8422⭐</code></b> <b><code>&nbsp;&nbsp;1646🍴</code></b> [Ocelot](https://github.com/ThreeMammals/Ocelot)) - API Gateway created using .NET Core
* <b><code>&nbsp;&nbsp;&nbsp;516⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;73🍴</code></b> [OpenTracing](https://github.com/opentracing/opentracing-csharp)) - Vendor-neutral APIs and instrumentation for distributed tracing
* <b><code>&nbsp;13487⭐</code></b> <b><code>&nbsp;&nbsp;1232🍴</code></b> [Polly](https://github.com/App-vNext/Polly)) - .NET 3.5 / 4.0 / 4.5 / PCL library that allows developers to express transient exception and fault handling policies such as Retry, Retry Forever, Wait and Retry or Circuit Breaker in a fluent manner
* <b><code>&nbsp;&nbsp;1117⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;134🍴</code></b> [ProxyKit](https://github.com/damianh/ProxyKit)) - Toolkit to create code-first HTTP reverse proxies on ASP.NET Core

### E-Commerce and Payments
* <b><code>&nbsp;&nbsp;9368⭐</code></b> <b><code>&nbsp;&nbsp;5358🍴</code></b> [nopCommerce](https://github.com/nopSolutions/nopCommerce)) - Free open-source ecommerce shopping cart (ASP.NET MVC / ASP.NET Core MVC ) with a vast community and a market place full of new features, themes and plugins.
* <b><code>&nbsp;&nbsp;1890⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;764🍴</code></b> [GrandNode](https://github.com/grandnode/grandnode)) - Multi-platform, free, open source ecommerce shopping cart based on ASP.NET Core 2.1 and MongoDB derived from <b><code>&nbsp;&nbsp;9368⭐</code></b> <b><code>&nbsp;&nbsp;5358🍴</code></b> [nopCommerce](https://github.com/nopSolutions/nopCommerce)).
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [PayPal](https://github.com/paypal/PayPal-NET-SDK)) - .NET SDK for PayPal's RESTful APIs.
* <b><code>&nbsp;&nbsp;4231⭐</code></b> <b><code>&nbsp;&nbsp;1595🍴</code></b> [SimplCommerce](https://github.com/simplcommerce/SimplCommerce)) - Super simple ecommerce system built on .NET Core.
* <b><code>&nbsp;&nbsp;&nbsp;194⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;67🍴</code></b> [Stripe](https://github.com/ServiceStack/Stripe)) - Typed .NET clients for stripe.com REST APIs.


### Exceptions
* <b><code>&nbsp;&nbsp;2787⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;121🍴</code></b> [Demystifier](https://github.com/benaadams/Ben.Demystifier)) - High performance understanding for stack traces (Make error logs more productive).
* <b><code>&nbsp;&nbsp;&nbsp;559⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;142🍴</code></b> [Exceptionless](https://github.com/exceptionless/Exceptionless.Net)) - Exceptionless .NET Client
* <b><code>&nbsp;&nbsp;&nbsp;269⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;32🍴</code></b> [GlobalExceptionHandlerDotNet](https://github.com/JosephWoodward/GlobalExceptionHandlerDotNet)) - GlobalExceptionHandlerDotNet allows you to configure exception handling as a convention with your ASP.NET Core application pipeline as opposed to explicitly handling them within each controller action.
* <b><code>&nbsp;&nbsp;&nbsp;612⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;208🍴</code></b> [Sentry](https://github.com/getsentry/sentry-dotnet)) - .NET SDK for Sentry, an Open-source error tracking that helps developers monitor and fix crashes in real time.

### Functional Programming
* <b><code>&nbsp;&nbsp;2478⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;306🍴</code></b> [CSharpFunctionalExtensions](https://github.com/vkhorikov/CSharpFunctionalExtensions)) - Functional Extensions for C#.
* <b><code>&nbsp;&nbsp;1750⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;181🍴</code></b> [DynamicData](https://github.com/RolandPheasant/DynamicData)) - Reactive collections based on Rx.NET.
* <b><code>&nbsp;&nbsp;&nbsp;116⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;17🍴</code></b> [echo-process](https://github.com/louthy/echo-process)) - Actor library for C# with additional modules that support persistence to Redis, as well as JS integration.
* <b><code>&nbsp;&nbsp;1169⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;156🍴</code></b> [FsCheck](https://github.com/fscheck/FsCheck)) - Random Testing for .NET.
* <b><code>&nbsp;&nbsp;2136⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;266🍴</code></b> [Giraffe](https://github.com/dustinmoris/Giraffe)) - A native functional ASP.NET Core web framework for F# developers.
* <b><code>&nbsp;&nbsp;6556⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;423🍴</code></b> [language-ext](https://github.com/louthy/language-ext)) - C# functional language extensions and 'Erlang like' concurrency system.
* <b><code>&nbsp;&nbsp;&nbsp;589⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;183🍴</code></b> [LaYumba.Functional](https://github.com/la-yumba/functional-csharp-code)) - Utility library for programming functionally in C#.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;66⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;14🍴</code></b> [NetMQ.ReactiveExtensions](https://github.com/NetMQ/NetMQ.ReactiveExtensions)) - Effortlessly send messages anywhere on the network using Reactive Extensions (RX). Transport protocol is ZeroMQ.
* <b><code>&nbsp;&nbsp;&nbsp;906⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;74🍴</code></b> [Optional](https://github.com/nlkl/Optional)) - A robust option type for C#.
* <b><code>&nbsp;&nbsp;&nbsp;198⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;28🍴</code></b> [reactive-streams-dotnet](https://github.com/reactive-streams/reactive-streams-dotnet)) - [Reactive Streams](http://www.reactive-streams.org/) for .NET.
* <b><code>&nbsp;&nbsp;8140⭐</code></b> <b><code>&nbsp;&nbsp;1121🍴</code></b> [ReactiveUI](https://github.com/reactiveui/ReactiveUI)) - A MVVM framework that integrates with the Reactive Extensions for .NET to create elegant, testable User Interfaces that run on any mobile or desktop platform.
* <b><code>&nbsp;&nbsp;6750⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;753🍴</code></b> [Rx.NET](https://github.com/Reactive-Extensions/Rx.NET)) - The [Reactive Extensions](http://reactivex.io) for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;157⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;20🍴</code></b> [Qactive](https://github.com/RxDave/Qactive)) - Reactive queryable observable framework. `4.x.x or above`
* <b><code>&nbsp;&nbsp;&nbsp;851⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;140🍴</code></b> [sodium](https://github.com/SodiumFRP/sodium/tree/master/)) - Functional Reactive Programming (FRP) Library. `4.x.x or above`

### Graphics
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;50⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8🍴</code></b> [GLFWDotNet](https://github.com/smack0007/GLFWDotNet)) - .NET bindings for GLFW.
* <b><code>&nbsp;&nbsp;2497⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;501🍴</code></b> [ImageProcessor](https://github.com/JimBobSquarePants/ImageProcessor)) - A fluent wrapper around System.Drawing for the processing of image files [http://imageprocessor.org](http://imageprocessor.org). `4.5.x or above`
* <b><code>&nbsp;&nbsp;7496⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;853🍴</code></b> [ImageSharp](https://github.com/SixLabors/ImageSharp)) - Cross-platform library for processing of image files written in C#.
* <b><code>&nbsp;&nbsp;1536⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;267🍴</code></b> [LibVLCSharp](https://github.com/videolan/libvlcsharp)): .NET/Mono bindings for libvlc, the multimedia framework powering the VLC applications made by VideoLAN.
* <b><code>&nbsp;&nbsp;3503⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;416🍴</code></b> [Magick.NET](https://github.com/dlemstra/Magick.NET)) - The .NET library for ImageMagick.
* <b><code>&nbsp;&nbsp;&nbsp;614⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;51🍴</code></b> [MagicScaler](https://github.com/saucecontrol/PhotoSauce)) - MagicScaler high-performance, high-quality image processing pipeline for .NET
* <b><code>&nbsp;&nbsp;4681⭐</code></b> <b><code>&nbsp;&nbsp;1108🍴</code></b> [QRCoder](https://github.com/codebude/QRCoder)) - A pure C# Open Source QR Code implementation.
* <b><code>&nbsp;&nbsp;&nbsp;169⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;30🍴</code></b> [SharpBgfx](https://github.com/MikePopoloski/SharpBgfx)) - C# bindings for the bgfx graphics library.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;84⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;5🍴</code></b> [Structure.Sketching](https://github.com/JaCraig/Structure.Sketching)) - Image processing library for use in .NET applications that supports .NET Core.
* <b><code>&nbsp;&nbsp;2501⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;273🍴</code></b> [veldrid](https://github.com/mellinoe/veldrid)) - A low-level, hardware-accelerated 3D graphics library for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [ZXing.Net](https://github.com/micjahn/ZXing.Net/)) - .Net port of the original java-based barcode reader and generator library zxing.

### GUI
* <b><code>&nbsp;&nbsp;1755⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;148🍴</code></b> [AdonisUI](https://github.com/benruehl/adonis-ui)) - Lightweight UI toolkit for WPF applications offering classic but enhanced windows visuals.
* <b><code>&nbsp;26287⭐</code></b> <b><code>&nbsp;&nbsp;2271🍴</code></b> [Avalonia](https://github.com/AvaloniaUI/Avalonia)) - A multi-platform .NET UI framework (formerly known as Perspex).
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [AvaloniaEdit](https://github.com/AvaloniaUI/AvaloniaEdit/)) - The Avalonia-based text editor component forked from <b><code>&nbsp;&nbsp;1874⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;470🍴</code></b> [AvalonEdit](https://github.com/icsharpcode/AvalonEdit))
 <b><code>&nbsp;&nbsp;1116⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;102🍴</code></b> [HandyControls](https://github.com/ghost1372/HandyControls)) - Contains some simple and commonly used WPF controls.
* <b><code>&nbsp;&nbsp;&nbsp;154⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;9🍴</code></b> [Lara](https://github.com/integrativesoft/lara)) - Lara Web Engine is a library for developing Web user interfaces in C#
* <b><code>&nbsp;&nbsp;1455⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;137🍴</code></b> [ShellProgressBar](https://github.com/Mpdreamz/shellprogressbar)) - library to create progress bars in console programs
* <b><code>&nbsp;&nbsp;1381⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;108🍴</code></b> [Qml.Net](https://github.com/pauldotknopf/Qml.Net)) - A cross-platform Qml/.NET integration for Mono/.NET/.NET Core.
* <b><code>&nbsp;&nbsp;&nbsp;827⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;101🍴</code></b> [WinApi](https://github.com/prasannavl/WinApi)) - A simple, direct, ultra-thin CLR library for high-performance Win32 Native Interop with automation, windowing, DirectX, OpenGL and Skia helpers.

### IDE
* <b><code>&nbsp;&nbsp;2845⭐</code></b> <b><code>&nbsp;&nbsp;1022🍴</code></b> [Mono](https://github.com/mono/monodevelop)) - MonoDevelop enables developers to quickly write desktop and web applications on Linux, Windows and Mac OS X. It also makes it easy for developers to port .NET applications created with Visual Studio to Linux and Mac OS X maintaining a single code base for all platforms.
* 🌎 [rider](www.jetbrains.com/rider/) - Cross-platform C# IDE based on the IntelliJ platform and ReSharper.
* [Omnisharp](http://www.omnisharp.net/) - Family of Open Source projects, each with one goal: To enable a great .NET experience in YOUR editor of choice.
* <b><code>&nbsp;&nbsp;2091⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;776🍴</code></b> [SharpDevelop](https://github.com/icsharpcode/SharpDevelop)) - SharpDevelop is a free Integrated Development Environment (IDE) for C#, VB.NET, Boo, IronPython, IronRuby and F# projects on Microsoft's .NET platform. It is written (almost) entirely in C#, and comes with features you would expect in an IDE plus a few more.
* <b><code>165335⭐</code></b> <b><code>&nbsp;29676🍴</code></b> [Visual Studio Code](https://github.com/Microsoft/vscode)) - New type of tool that combines the simplicity of a code editor with what developers need for their core edit-build-debug cycle. Code provides comprehensive editing and debugging support, an extensibility model, and lightweight integration with existing tools.
* 🌎 [Visual Studio Community](www.visualstudio.com/en-us/products/visual-studio-community-vs.aspx) - Free editor for individual developers, open source projects, academic research, education, and small professional teams.

### Internationalization
* <b><code>&nbsp;&nbsp;&nbsp;157⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;65🍴</code></b> [Localization](https://github.com/aspnet/Localization)) - Localization abstractions and implementations for ASP.NET Core applications.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;86⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13🍴</code></b> [NetCoreStack.Localization](https://github.com/NetCoreStack/Localization)) - Database Resource Localization for .NET Core with Entity Framework and In Memory Cache
* <b><code>&nbsp;&nbsp;&nbsp;545⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;135🍴</code></b> [Westwind.Globalization](https://github.com/RickStrahl/Westwind.Globalization)) - Database driven resource localization for .NET applications.

### IOC
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;97⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;17🍴</code></b> [AutoDI](https://github.com/Keboo/AutoDI)) - Super-fast compile-time dependency injection using IL weaving.
* <b><code>&nbsp;&nbsp;4519⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;838🍴</code></b> [Autofac](https://github.com/autofac/Autofac)) - Addictive .NET IoC container.
* <b><code>&nbsp;&nbsp;1519⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;457🍴</code></b> [Castle.Windsor](https://github.com/castleproject/Windsor)) Castle Windsor is a best of breed, mature Inversion of Control container available for .NET.
* <b><code>&nbsp;&nbsp;1031⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;123🍴</code></b> [DryIoc](https://github.com/dadhi/DryIoc)) - Fast, small, full-featured IoC Container for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;336⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;33🍴</code></b> [Grace](https://github.com/ipjohnson/Grace)) - Grace is a feature rich Dependency Injection Container designed with ease of use and performance in mind.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [Inyector](https://github.com/davidrevoledo/Inyector)) - Dependency Injection Automation for AspNetCore
* <b><code>&nbsp;&nbsp;&nbsp;576⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;120🍴</code></b> [Lamar](https://github.com/JasperFx/lamar)) - Fast Inversion of Control Tool and Sundry Items of Roslyn Chicanery.
* <b><code>&nbsp;&nbsp;&nbsp;626⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;120🍴</code></b> [LightInject](https://github.com/seesharper/LightInject)) - Ultra lightweight IoC container.
* <b><code>&nbsp;&nbsp;1220⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;152🍴</code></b> [SimpleInjector](https://github.com/simpleinjector/SimpleInjector)) - Easy, flexible, and fast Dependency Injection library that promotes best practice to steer developers towards the pit of success.
* <b><code>&nbsp;&nbsp;&nbsp;142⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;10🍴</code></b> [Stashbox](https://github.com/z4kn4fein/stashbox)) - A lightweight, portable dependency injection framework for .NET based solutions.
* <b><code>&nbsp;&nbsp;1665⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;352🍴</code></b> [Unity](https://github.com/unitycontainer/unity)) - A lightweight, extensible dependency injection container.

### Logging
* <b><code>&nbsp;&nbsp;&nbsp;649⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;205🍴</code></b> [common-logging](https://github.com/net-commons/common-logging)) - Portable logging abstraction for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;5🍴</code></b> [dnxcore-logging-logstash](https://github.com/jvandevelde/dnxcore-logging-logstash)) - Logstash logging extension for .NET Core applications with UDP and Redis transports.
* <b><code>&nbsp;&nbsp;&nbsp;309⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;96🍴</code></b> [ElmahCore](https://github.com/ElmahCore/ElmahCore)) - Error logging library that includes features like error filtering and the ability to view the error log from a web page.
* <b><code>&nbsp;&nbsp;&nbsp;559⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;142🍴</code></b> [Exceptionless](https://github.com/exceptionless/Exceptionless.Net)) - Exceptionless .NET Client
* <b><code>&nbsp;&nbsp;1992⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;244🍴</code></b> [Foundatio](https://github.com/exceptionless/Foundatio#logging)) - A fluent logging api that can be used to log messages throughout your application.
* <b><code>&nbsp;&nbsp;&nbsp;151⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;22🍴</code></b> [Karambolo.Extensions.Logging.File](https://github.com/adams85/filelogger)) - A lightweight library which implements file logging for the built-in .NET Core logging framework (Microsoft.Extensions.Logging).
* <b><code>&nbsp;&nbsp;&nbsp;931⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;153🍴</code></b> [LibLog](https://github.com/damianh/LibLog)) - Single file for you to either copy/paste or install via nuget, into your library/ framework/ application to provide a logging abstraction.
* <b><code>&nbsp;&nbsp;&nbsp;860⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;330🍴</code></b> [log4net](https://github.com/apache/logging-log4net)) - log4net is a port of the excellent Apache log4j™ framework to the Microsoft® .NET runtime.
* <b><code>&nbsp;&nbsp;6331⭐</code></b> <b><code>&nbsp;&nbsp;1372🍴</code></b> [NLog](https://github.com/NLog/NLog)) - Advanced .NET, Silverlight and Xamarin Logging with support for structured and non structured logging.
  * <b><code>&nbsp;&nbsp;&nbsp;319⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;165🍴</code></b> [NLog for ASP.NET and ASP.NET Core](https://github.com/NLog/NLog.Web)) - NLog integration for ASP.NET & ASP.NET Core 1-3
  * <b><code>&nbsp;&nbsp;&nbsp;394⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;151🍴</code></b> [NLog.Extensions.Logging](https://github.com/NLog/NLog.Extensions.Logging)) - NLog Provider for Microsoft.Extensions.Logging for .NET Standard libraries and .NET Core applications
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;44⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;26🍴</code></b> [NLog.Windows.Forms](https://github.com/NLog/NLog.Windows.Forms)) - NLog targets specific for Windows.Forms
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8🍴</code></b> [NLog.MailKit](https://github.com/NLog/NLog.MailKit)) - Alternative Mail target using the using MailKit library
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [Q42.Logging.ApplicationInsights](https://github.com/Q42/Q42.Logging.ApplicationInsights)) - Log appender for the build in ASP.NET Core logging to send all logs to Application Insights.
* <b><code>&nbsp;&nbsp;7330⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;797🍴</code></b> [serilog](https://github.com/serilog/serilog)) - Simple .NET logging with fully-structured events.
  * <b><code>&nbsp;&nbsp;1327⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;209🍴</code></b> [serilog-aspnetcore](https://github.com/serilog/serilog-aspnetcore)) - Serilog integration for ASP.NET Core 2+.
  * <b><code>&nbsp;&nbsp;&nbsp;516⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;52🍴</code></b> [Serilog.Exceptions](https://github.com/RehanSaeed/Serilog.Exceptions)) - Serilog.Exceptions is an add-on to 🌎 [Serilog](serilog.net/) to log exception details and custom properties that are not output in Exception.ToString().
  * <b><code>&nbsp;&nbsp;&nbsp;461⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;129🍴</code></b> [Serilog.Settings.Configuration](https://github.com/serilog/serilog-settings-configuration)) - A Serilog configuration provider that reads from Microsoft.Extensions.Configuration.
* 🌎 [SEQ](getseq.net) - Seq collects data over HTTP, while your applications use the best available structured logging APIs for your platform.

### Machine Learning and Data Science
* <b><code>&nbsp;&nbsp;4502⭐</code></b> <b><code>&nbsp;&nbsp;1988🍴</code></b> [Accord](https://github.com/accord-net/framework)) - Machine learning, computer vision, statistics and general scientific computing for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;752⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;76🍴</code></b> [Catalyst](https://github.com/curiosity-ai/catalyst)) Cross-platform Natural Language Processing (NLP) library inspired by spaCy, with pre-trained models, out-of-the box support for training word and document embeddings, and flexible entity recognition models. Part of the 🌎 [SciSharp Stack](scisharp.github.io/SciSharp/)
* <b><code>&nbsp;&nbsp;9073⭐</code></b> <b><code>&nbsp;&nbsp;1889🍴</code></b> [ML.NET](https://github.com/dotnet/machinelearning)) - Cross-platform open-source machine learning framework which makes machine learning accessible to .NET developers [http://dot.net/ml](http://dot.net/ml).
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Spreads](https://github.com/Spreads/Spreads/)) - Series and Panels for Real-time and Exploratory Analysis of Data Streams.
* <b><code>&nbsp;&nbsp;3144⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;574🍴</code></b> [TensorFlowSharp](https://github.com/migueldeicaza/TensorFlowSharp)) - TensorFlow API for .NET languages.
* <b><code>&nbsp;23476⭐</code></b> <b><code>&nbsp;&nbsp;1252🍴</code></b> [WaveFunctionCollapse](https://github.com/mxgmn/WaveFunctionCollapse)) - itmap & tilemap generation from a single example with the help of ideas from quantum mechanics.
* <b><code>&nbsp;&nbsp;&nbsp;380⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;83🍴</code></b> [SiaNet](https://github.com/SciSharp/SiaNet)) - A C# deep learning library, human friendly, CUDA/OpenCL supported, well structured, easy to extend 

### Mail
* <b><code>&nbsp;&nbsp;3059⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;438🍴</code></b> [FluentEmail](https://github.com/lukencode/FluentEmail)) - All in one email sender for .NET and .NET Core
* <b><code>&nbsp;&nbsp;&nbsp;159⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13🍴</code></b> [MailBody](https://github.com/doxakis/MailBody)) - Create transactional email with a fluent interface (.NET).
* <b><code>&nbsp;&nbsp;6256⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;828🍴</code></b> [MailKit](https://github.com/jstedfast/MailKit)) - Cross-platform .NET library for IMAP, POP3, and SMTP.
* <b><code>&nbsp;&nbsp;&nbsp;110⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;32🍴</code></b> [MailMergeLib](https://github.com/axuno/MailMergeLib)) - SMTP mail client library which provides comfortable mail merge capabilities for text, inline images and attachments, as well as good throughput and fault tolerance for sending mail messages.
* <b><code>&nbsp;&nbsp;1851⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;375🍴</code></b> [MimeKit](https://github.com/jstedfast/MimeKit)) - Cross-platform .NET MIME creation and parser library with support for S/MIME, PGP, DKIM, TNEF and Unix mbox spools.
* <b><code>&nbsp;&nbsp;&nbsp;125⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;38🍴</code></b> [netDumbster](https://github.com/cmendible/netDumbster)) - a .Net Fake SMTP Server used for testing. Clone of the popular Dumbster.
* <b><code>&nbsp;&nbsp;2979⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;272🍴</code></b> [Papercut](https://github.com/ChangemakerStudios/Papercut)) - Simple Desktop SMTP Server
* <b><code>&nbsp;&nbsp;&nbsp;656⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;118🍴</code></b> [PreMailer.Net](https://github.com/milkshakesoftware/PreMailer.Net)) - C# library that moves your stylesheets to inline style attributes, for maximum compatibility with E-mail clients.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;15⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1🍴</code></b> [SendGrid Client](https://github.com/0xdeafcafe/sendgrid-dotnet)) - C# library for the SendGrid v3 mail endpoint.
* <b><code>&nbsp;&nbsp;&nbsp;723⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;166🍴</code></b> [SmtpServer](https://github.com/cosullivan/SmtpServer)) - Library to create your own SMTP server.
* <b><code>&nbsp;&nbsp;&nbsp;187⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;38🍴</code></b> [StrongGrid](https://github.com/Jericho/StrongGrid)) - Client for SendGrid's v3 API. Not only allows you to send emails, but also allows you to bulk import contacts, manage lists and segments, create custom fields for your lists, etc. Also includes a parser for SendGrid Webhooks.

### Mathematics
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;93⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;11🍴</code></b> [AutoDiff](https://github.com/alexshtf/autodiff)) - A library that provides fast, accurate and automatic differentiation (computes derivative / gradient) of mathematical functions.
* <b><code>&nbsp;&nbsp;&nbsp;181⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;28🍴</code></b> [UnitConversion](https://github.com/Stratajet/UnitConversion)) - Expansible Unit Conversion Library for .NET Core and .NET Framework.
* <b><code>&nbsp;&nbsp;2681⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;381🍴</code></b> [UnitsNet](https://github.com/angularsen/UnitsNet)) - Units.NET gives you all the common units of measurement and the conversions between them.

### Media
* <b><code>&nbsp;&nbsp;&nbsp;953⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;170🍴</code></b> [MetadataExtractor](https://github.com/drewnoakes/metadata-extractor-dotnet)) - Extracts metadata from media (images, video, audio) with a simple to use API.

### Misc
* <b><code>&nbsp;&nbsp;&nbsp;496⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;30🍴</code></b> [AdvanceDLSupport](https://github.com/Firwood-Software/AdvanceDLSupport)) - Library to improve P/Invoke-ing native code. Interact with native objects as if they were first class objects.
* <b><code>&nbsp;&nbsp;5198⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;563🍴</code></b> [AngleSharp](https://github.com/AngleSharp/AngleSharp)) - The ultimate angle brackets parser library. It parses HTML5, MathML, SVG and CSS to construct a DOM based on the official W3C specification. Comparable to beautifulsoup4 of python.
* <b><code>&nbsp;&nbsp;&nbsp;460⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;27🍴</code></b> [AgileMapper](https://github.com/agileobjects/AgileMapper)) - AgileMapper is a zero-configuration, highly-configurable object-object mapper with viewable execution plans.
* <b><code>&nbsp;&nbsp;&nbsp;162⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;26🍴</code></b> [AspNetCore Extension Library](https://github.com/sgjsakura/AspNetCore)) - ASP.NET Core Extension Library.
* <b><code>&nbsp;&nbsp;9966⭐</code></b> <b><code>&nbsp;&nbsp;1748🍴</code></b> [AutoMapper](https://github.com/AutoMapper/AutoMapper)) - Convention-based object-object mapper in .NET.
* <b><code>&nbsp;&nbsp;2632⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;684🍴</code></b> [Baget](https://github.com/loic-sharma/BaGet)) - A lightweight NuGet server.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Bleak](https://github.com/Akaion/Bleak)) - A Windows native DLL injection library.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Bullseye](https://github.com/adamralph/bullseye/)) - A .NET package for describing and running targets and their dependencies.
* <b><code>&nbsp;&nbsp;2224⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;470🍴</code></b> [Castle.Core](https://github.com/castleproject/Core)) - Castle Core, including Castle DynamicProxy, Logging Services and DictionaryAdapter [http://www.castleproject.org](http://www.castleproject.org).
* <b><code>&nbsp;&nbsp;&nbsp;186⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;42🍴</code></b> [Chessie](https://github.com/fsprojects/Chessie)) - Railway-oriented programming for .NET [http://fsprojects.github.io/Chessie](http://fsprojects.github.io/Chessie).
* <b><code>&nbsp;&nbsp;4457⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;273🍴</code></b> [CliWrap](https://github.com/Tyrrrz/CliWrap)) - Wrapper for command line interfaces.
* <b><code>&nbsp;&nbsp;&nbsp;583⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;29🍴</code></b> [commanddotnet](https://github.com/bilal-fazlani/commanddotnet)) - Model your command line application interface in a class.
* <b><code>&nbsp;&nbsp;1005⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;146🍴</code></b> [CommonMark.NET](https://github.com/Knagis/CommonMark.NET)) - The implementation of CommonMark specification in C# for converting Markdown documents to HTML.
* <b><code>&nbsp;&nbsp;&nbsp;332⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;37🍴</code></b> [ConsoleTableExt](https://github.com/minhhungit/ConsoleTableExt)) - Fluent library to create table for .NET console application.
* <b><code>&nbsp;&nbsp;&nbsp;367⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;59🍴</code></b> [CoordinateSharp](https://github.com/Tronald/CoordinateSharp)) - A library that can quickly format and convert geographic coordinates as well as provide location based sun and moon information (sunset, sunrise, moon illumination, etc...). 
* <b><code>&nbsp;&nbsp;&nbsp;304⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;136🍴</code></b> [datatables](https://github.com/ALMMa/datatables.aspnet/tree/dev)) - Microsoft ASP.NET server-side support and helpers for jQuery DataTables.
* <b><code>&nbsp;&nbsp;1100⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;422🍴</code></b> [DinkToPdf](https://github.com/rdvojmoc/DinkToPdf)) - C# .NET Core wrapper for wkhtmltopdf library that uses Webkit engine to convert HTML pages to PDF.
* <b><code>&nbsp;&nbsp;&nbsp;454⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;50🍴</code></b> [dotnet-env](https://github.com/tonerdo/dotnet-env)) - A .NET library to load environment variables from .env files.
* <b><code>&nbsp;&nbsp;&nbsp;364⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;27🍴</code></b> [DotNet.Glob](https://github.com/dazinator/DotNet.Glob)) - A fast globbing library for .NET / .NETStandard applications. Outperforms Regex.
* <b><code>&nbsp;&nbsp;1382⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;128🍴</code></b> [Dotnet outdated](https://github.com/dotnet-outdated/dotnet-outdated)) - A .NET Core global tool to display and update outdated NuGet packages in a project
* <b><code>&nbsp;&nbsp;2771⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;171🍴</code></b> [Dotnet Script](https://github.com/filipw/dotnet-script)) - Run C# scripts from the .NET CLI.
* <b><code>&nbsp;&nbsp;&nbsp;808⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;65🍴</code></b> [Dotnet Serve](https://github.com/natemcmaster/dotnet-serve)) - Simple command-line HTTP server for .NET Core CLI.
* <b><code>&nbsp;&nbsp;1365⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;206🍴</code></b> [Downloader](https://github.com/bezzad/Downloader)) - Downloader is a modern, fluent, asynchronous, testable and portable library for .NET. This is a multipart downloader with asynchronous progress events.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;39⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4🍴</code></b> [Eighty](https://github.com/benjamin-hodgson/Eighty)) - A simple HTML generation library
* <b><code>&nbsp;&nbsp;1750⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;106🍴</code></b> [Enums.NET](https://github.com/TylerBrinkley/Enums.NET)) - Enums.NET is a high-performance type-safe .NET enum utility library
* <b><code>&nbsp;&nbsp;1197⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;82🍴</code></b> [FastExpressionCompiler](https://github.com/dadhi/FastExpressionCompiler)) - Fast ExpressionTree compiler to delegate.
* <b><code>&nbsp;&nbsp;1342⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;97🍴</code></b> [FluentDocker](https://github.com/mariotoffia/FluentDocker)) - Commands, Services and Fluent API for docker, docker-compose & docker-machine, for win/mac/linux and native docker.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [FluentFTP](https://github.com/robinrodricks/FluentFTP/)) - FTP and FTPS client, with extensive FTP commands, SSL/TLS connections, hashing/checksums and more.
* <b><code>&nbsp;&nbsp;4382⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;465🍴</code></b> [Fody](https://github.com/Fody/Fody)) - Extensible tool for weaving .net assemblies
* <b><code>&nbsp;&nbsp;&nbsp;179⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;30🍴</code></b> [HdrHistogram.NET](https://github.com/HdrHistogram/HdrHistogram.NET)) - High Dynamic Range (HDR) Histogram.
* <b><code>&nbsp;&nbsp;&nbsp;362⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;27🍴</code></b> [httpclient-interception](https://github.com/justeat/httpclient-interception)) - .NET Standard library for intercepting server-side HTTP dependencies.
* <b><code>&nbsp;&nbsp;8715⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;963🍴</code></b> [Humanizer](https://github.com/Humanizr/Humanizer)) - Humanizer meets all your .NET needs for manipulating and displaying strings, enums, dates, times, timespans, numbers and quantities.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;46⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;7🍴</code></b> [Humidifier](https://github.com/jakejscott/Humidifier)) - Write and maintain AWS Cloudformation templates using C#.
* <b><code>&nbsp;&nbsp;&nbsp;658⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;67🍴</code></b> [impromptu-interface](https://github.com/ekonbenefits/impromptu-interface)) - Static interface to dynamic implementation (duck casting). Uses the DLR combined with Reflect.Emit.
* <b><code>&nbsp;&nbsp;&nbsp;226⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;37🍴</code></b> [JqueryDataTablesServerSide](https://github.com/fingers10/JqueryDataTablesServerSide)) - ASP.NET Core Server Side Processing library for Jquery DataTables with Multiple Column Filtering, Sorting and Pagination at database level with Excel Export and TagHelper support.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;85⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;12🍴</code></b> [LibSass Host](https://github.com/Taritsyn/LibSassHost)) - .NET wrapper around the [libSass](http://sass-lang.com/libsass) library with the ability to support a virtual file system.
* <b><code>&nbsp;&nbsp;4466⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;459🍴</code></b> [markdig](https://github.com/lunet-io/markdig)) - Fast, powerfull, CommonMark compliant, extensible Markdown processor for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;431⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;23🍴</code></b> [NetCoreBeauty](https://github.com/nulastudio/NetCoreBeauty)) - Simple library to move a .NET Core app runtime components and dependencies into a sub-directory and make it beauty.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;50⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [NFlags](https://github.com/bartoszgolek/NFlags)) - Simple library to made parsing CLI arguments easy. Library also allow to print usage help "out of box".
* <b><code>&nbsp;&nbsp;&nbsp;310⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;54🍴</code></b> [NReco.LambdaParser](https://github.com/nreco/lambdaparser)) - Parses string expressions (formulas, methods calls, conditions) to LINQ expression tree that can be compiled to lambda and evaluated.
* <b><code>&nbsp;&nbsp;&nbsp;157⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;29🍴</code></b> [NuGet Trends](https://github.com/NuGetTrends/nuget-trends)) - Website with statistics of NuGet packages download count.
* 🌎 [NYoutubeDL](gitlab.com/BrianAllred/NYoutubeDL) - A simple youtube-dl library for C#/.NET.
* <b><code>&nbsp;&nbsp;1101⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;165🍴</code></b> [Otp.NET](https://github.com/kspearrin/Otp.NET)) - An implementation TOTP RFC 6238 and HOTP RFC 4226 in C#.
* <b><code>&nbsp;&nbsp;1082⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;74🍴</code></b> [pose](https://github.com/tonerdo/pose)) - Replace any .NET method (including static and non-virtual) with a delegate
* <b><code>&nbsp;&nbsp;3448⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;454🍴</code></b> [PuppeteerSharp](https://github.com/kblok/puppeteer-sharp)) - Puppeteer Sharp is a .NET port of the official Node.JS Puppeteer API.
* <b><code>&nbsp;&nbsp;&nbsp;810⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;77🍴</code></b> [readline](https://github.com/tsolarin/readline)) - Pure C# GNU-Readline like library for .NET/.NET Core.
* <b><code>&nbsp;&nbsp;&nbsp;336⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;48🍴</code></b> [ReflectionMagic](https://github.com/ReflectionMagic/ReflectionMagic)) - Framework to drastically simplify your private reflection code using C# dynamic
* <b><code>&nbsp;&nbsp;&nbsp;516⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;58🍴</code></b> [Relinq](https://github.com/re-motion/Relinq)) - With re-linq, it's now easier than ever to create full-featured LINQ providers.
* <b><code>&nbsp;&nbsp;&nbsp;335⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;26🍴</code></b> [Remote.Linq](https://github.com/6bee/Remote.Linq)) - Remote Linq is a small and easy to use - yet very powerful - library to translate LINQ expression trees to strongly typed, serializable expression trees and vice versa.
* <b><code>&nbsp;&nbsp;&nbsp;292⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;67🍴</code></b> [ReverseMarkdown](https://github.com/mysticmind/reversemarkdown-net)) - Html to Markdown converter library.
* <b><code>&nbsp;&nbsp;&nbsp;365⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;84🍴</code></b> [PdfReport.Core](https://github.com/VahidN/PdfReport.Core)) - PdfReport.Core is a code first reporting engine, which is built on top of the iTextSharp.LGPLv2.Core and EPPlus.Core libraries.
* <b><code>&nbsp;&nbsp;1468⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;95🍴</code></b> [Scientist](https://github.com/github/Scientist.net)) - .NET library for carefully refactoring critical paths. It's a port of GitHub's Ruby Scientist library.
* <b><code>&nbsp;&nbsp;3692⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;240🍴</code></b> [Scrutor](https://github.com/khellang/Scrutor)) - Assembly scanning extensions for Microsoft.Extensions.DependencyInjection.
* <b><code>&nbsp;&nbsp;&nbsp;107⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;7🍴</code></b> [Sheller](https://github.com/twitchax/Sheller)) - A .NET library that makes shelling out commands super easy and fluent.
* <b><code>&nbsp;&nbsp;1112⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;105🍴</code></b> [SmartFormat.NET](https://github.com/scottrippey/SmartFormat.NET)) - An extensible replacement for string.Format.
* Stocks
  * <b><code>&nbsp;&nbsp;&nbsp;546⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;185🍴</code></b> [Trady](https://github.com/lppkarl/Trady)) - Handy library for computing technical indicators, and it targets to be an automated trading system that provides stock data feeding, indicator computing, strategy building and automatic trading.
* <b><code>&nbsp;&nbsp;1581⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;228🍴</code></b> [System.Linq.Dynamic.Core](https://github.com/StefH/System.Linq.Dynamic.Core)) - The .NET Standard (.NET Core) version from the System Linq Dynamic functionality.
* Validation
  * <b><code>&nbsp;&nbsp;9158⭐</code></b> <b><code>&nbsp;&nbsp;1205🍴</code></b> [FluentValidation](https://github.com/JeremySkinner/FluentValidation)) - Small validation library for .NET that uses a fluent interface and lambda expressions for building validation rules.
  * <b><code>&nbsp;&nbsp;&nbsp;272⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;36🍴</code></b> [FormHelper](https://github.com/SinanBozkus/FormHelper)) - Form & Validation Helper for ASP.NET Core. Form Helper helps you to create ajax forms and validations without writing any javascript code. (Compatible with Fluent Validation).
  * <b><code>&nbsp;&nbsp;&nbsp;711⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;55🍴</code></b> [Guard](https://github.com/safakgur/guard)) - A high-performance, extensible argument validation library.
  * <b><code>&nbsp;&nbsp;&nbsp;322⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;26🍴</code></b> [Valit](https://github.com/valit-stack/Valit)) - A dead simple validation for .NET Core. No more if-statements all around your code. Write nice and clean fluent validators instead!
* <b><code>&nbsp;&nbsp;1819⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;197🍴</code></b> [Vanara](https://github.com/dahall/Vanara)) - A set of .NET libraries for Windows implementing PInvoke calls to many native Windows APIs with supporting wrappers.
* [warden-stack](https://github.com/warden-stack) - "health checks" for your applications, resources and infrastructure. Keep your Warden on the watch.
* <b><code>&nbsp;&nbsp;&nbsp;339⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [WebEssentials.AspNetCore.ServiceWorker](https://github.com/madskristensen/WebEssentials.AspNetCore.ServiceWorker)) - ASP.NET Core Progressive Web Apps.
* <b><code>&nbsp;&nbsp;&nbsp;715⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;129🍴</code></b> [Xabe.FFmpeg](https://github.com/tomaszzmuda/Xabe.FFmpeg)) - .NET Standard wrapper for FFmpeg. It allows to process media without know how FFmpeg works, and can be used to pass customized arguments to FFmpeg from C# application.
* <b><code>&nbsp;&nbsp;2996⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;500🍴</code></b> [YoutubeExplode](https://github.com/Tyrrrz/YoutubeExplode)) - Ultimate library for extracting metadata and downloading Youtube videos and playlists.

### Networking
* <b><code>&nbsp;&nbsp;&nbsp;531⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;82🍴</code></b> [AspNetCore.Proxy](https://github.com/twitchax/AspNetCore.Proxy)) - ASP.NET Core Proxies made easy.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;68⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;20🍴</code></b> [CurlThin](https://github.com/stil/CurlThin)) - Lightweight cURL binding library for C# with support for multiple simultaneous transfers through curl_multi interface.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;40⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6🍴</code></b> [NETStandard.HttpListener](https://github.com/StefH/NETStandard.HttpListener)) - HttpListener for .NET Core (NETStandard).
* <b><code>&nbsp;&nbsp;&nbsp;477⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;77🍴</code></b> [Networker](https://github.com/MarkioE/Networker)) - A simple to use TCP and UDP networking library for .NET, designed to be flexible, scalable and FAST.
* <b><code>&nbsp;&nbsp;1368⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;271🍴</code></b> [SharpPcap](https://github.com/chmorgan/sharppcap)) - Fully managed, cross platform (Windows, Mac, Linux) .NET library for capturing packets from live and file based devices.

### Office
* <b><code>&nbsp;&nbsp;1837⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;280🍴</code></b> [EPPlus](https://github.com/EPPlusSoftware/EPPlus)) - Create advanced Excel spreadsheets using .NET.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;83⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13🍴</code></b> [npoi](https://github.com/tonyqus/npoi)) - .NET library that can read/write Office formats without Microsoft Office installed. No COM+, no interop.
* <b><code>&nbsp;&nbsp;4069⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;548🍴</code></b> [Open-XML-SDK](https://github.com/OfficeDev/Open-XML-SDK)) - The Open XML SDK provides tools for working with Office Word, Excel, and PowerPoint documents.

### Operating System
* <b><code>&nbsp;&nbsp;2952⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;553🍴</code></b> [CosmosOS](https://github.com/CosmosOS/Cosmos)) - Cosmos is an operating system "construction kit". Build your own OS using managed languages such as C#, VB.NET, and more!

### ORM
* <b><code>&nbsp;&nbsp;1524⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;455🍴</code></b> [Chloe](https://github.com/shuxinqin/Chloe)) - A lightweight and high-performance Object/Relational Mapping(ORM) library for .NET.
* <b><code>&nbsp;13834⭐</code></b> <b><code>&nbsp;&nbsp;3194🍴</code></b> [Entity Framework Core](https://github.com/aspnet/EntityFramework)) - Familiar developer experience to previous versions of EF, including LINQ, POCO, and Code First support.
  * <b><code>&nbsp;&nbsp;3699⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;595🍴</code></b> [EFCore.BulkExtensions](https://github.com/borisdj/EFCore.BulkExtensions)) - EntityFrameworkCore Bulk Batch Extensions for Insert Update Delete Read (CRUD) ops
  * 🌎 [EFCore.Visualizer](marketplace.visualstudio.com/items?itemName=GiorgiDalakishvili.EFCoreVisualizer) - View Entity Framework Core query plan directly in Visual Studio.
  * <b><code>&nbsp;&nbsp;2277⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;317🍴</code></b> [EntityFramework-Plus](https://github.com/zzzprojects/EntityFramework-Plus)) - Entity Framework Utilities | Bulk Operations | Batch Delete | Batch Update | Query Cache | Query Filter | Query Future | Query Include | Audit.
  * <b><code>&nbsp;&nbsp;1535⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;75🍴</code></b> [EntityFramework.Exceptions](https://github.com/Giorgi/EntityFramework.Exceptions)) - Use typed Exceptions for EntityFrameworkCore when your SQL query violates database constraints in SqlServer, MySql, or PostgreSQL.
  * <b><code>&nbsp;&nbsp;&nbsp;374⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;46🍴</code></b> [EntityFramework.Triggers](https://github.com/NickStrupat/EntityFramework.Triggers)) - Trigger events for EF.
  * <b><code>&nbsp;&nbsp;&nbsp;132⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;10🍴</code></b> [EntityFramework.Rx](https://github.com/NickStrupat/EntityFramework.Rx)) - Reactive **hot** observables of your EF operations.
  * <b><code>&nbsp;&nbsp;1587⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;228🍴</code></b> [Npgsql.EntityFrameworkCore.PostgreSQL](https://github.com/npgsql/Npgsql.EntityFrameworkCore.PostgreSQL)) - Entity Framework Core provider for PostgreSQL.
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;44⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8🍴</code></b> [EntityFramework.PrimaryKey](https://github.com/NickStrupat/EntityFramework.PrimaryKey)) - Easily get the primary key of any entity (including composite keys).
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;33⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3🍴</code></b> [EntityFramework.TypedOriginalValues](https://github.com/NickStrupat/EntityFramework.TypedOriginalValues)) - Get a proxy object of the original values of your entity (typed access to Property("...").OriginalValue).
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;42⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1🍴</code></b> [EntityFramework.VersionedProperties](https://github.com/NickStrupat/EntityFramework.VersionedProperties)) - Classes which auto-magically keep an audit history of the changes to the specified property.
  * <b><code>&nbsp;&nbsp;&nbsp;161⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;27🍴</code></b> [EntityFrameworkCore.SqlServer.SimpleBulks](https://github.com/phongnguyend/EntityFrameworkCore.SqlServer.SimpleBulks)) - Simple library that can help to sync a large number of records in-memory into the database. Lambda Expression is supported.
  * <b><code>&nbsp;&nbsp;1650⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;165🍴</code></b> [LINQKit](https://github.com/scottksmith95/LINQKit)) - A free set of extensions for LINQ to SQL and Entity Framework power users.
  * <b><code>&nbsp;&nbsp;2735⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;386🍴</code></b> [Pomelo.EntityFrameworkCore.MySql](https://github.com/PomeloFoundation/Pomelo.EntityFrameworkCore.MySql)) - Entity Framework Core provider for MySql built on top of mysql-net/MySqlConnector.
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;40⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4🍴</code></b> [spectre.query](https://github.com/spectresystems/spectre.query)) - A simple query language for Entity Framework Core.
* <b><code>&nbsp;17627⭐</code></b> <b><code>&nbsp;&nbsp;3679🍴</code></b> [Dapper](https://github.com/StackExchange/Dapper)) - Simple object mapper for .NET.
  * <b><code>&nbsp;&nbsp;&nbsp;430⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;88🍴</code></b> [Dapper-FluentMap](https://github.com/henkmollema/Dapper-FluentMap)) - Provides a simple API to fluently map POCO properties to database columns when using Dapper.
  * <b><code>&nbsp;&nbsp;&nbsp;640⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;101🍴</code></b> [Dommel](https://github.com/henkmollema/Dommel)) - Simple CRUD operations for Dapper.
  * <b><code>&nbsp;&nbsp;&nbsp;669⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;204🍴</code></b> [MicroOrm.Dapper.Repositories](https://github.com/phnx47/MicroOrm.Dapper.Repositories)) - CRUD for Dapper.
* <b><code>&nbsp;&nbsp;4135⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;860🍴</code></b> [FreeSql](https://github.com/2881099/FreeSql)) - a convenient ORM in dotnet,supports Mysql, Postgresql, SqlServer, Oracle and Sqlite.
* 🌎 [Limebean](nick-lucas.github.io/LimeBean/) - Hybrid-ORM, designed to be simple to use and not totally hide SQL, while having all the nice things you expect from an ORM. Inspired by RedBeanPHP.
* 🌎 [LINQ to DB (linq2db)](linq2db.github.io/) - The fastest LINQ database access library offering a simple, lightweight, fast, and type-safe layer between your POCO objects and your database for more than 10 database engines with full SQL support.
* <b><code>&nbsp;&nbsp;2131⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;933🍴</code></b> [nhibernate-core](https://github.com/nhibernate/nhibernate-core)) - NHibernate Object Relational Mapper.
* <b><code>&nbsp;&nbsp;1581⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;327🍴</code></b> [NEventStore](https://github.com/NEventStore/NEventStore)) - Persistence library used to abstract different storage implementations when using event sourcing as storage mechanism. This library is developed with a specific focus on DDD/CQRS applications.
* <b><code>&nbsp;&nbsp;&nbsp;850⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;302🍴</code></b> [NPoco](https://github.com/schotime/NPoco)) - Simple microORM that maps the results of a query onto a POCO object. Project based on Schotime's branch of PetaPoco.
* <b><code>&nbsp;&nbsp;&nbsp;184⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;39🍴</code></b> [NReco.Data](https://github.com/nreco/data)) - Lightweight provider-independent DAL for SQL commands generation, CRUD operations and simple POCO mapping.
* <b><code>&nbsp;&nbsp;2074⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;600🍴</code></b> [PetaPoco](https://github.com/CollaboratingPlatypus/PetaPoco)) - A tiny ORM-ish thing for your POCO's.
* <b><code>&nbsp;&nbsp;3142⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;503🍴</code></b> [querybuilder](https://github.com/sqlkata/querybuilder)) - SqlKata Query Builder is a powerful Sql Query Builder written in C#.
* <b><code>&nbsp;&nbsp;1727⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;126🍴</code></b> [RepoDb](https://github.com/mikependon/RepoDb)) - A hybrid ORM library for .NET.
* <b><code>&nbsp;&nbsp;1526⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;635🍴</code></b> [ServiceStack.OrmLite](https://github.com/ServiceStack/ServiceStack.OrmLite)) - Light, simple and fast convention-based POCO ORM.
* <b><code>&nbsp;&nbsp;&nbsp;229⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;50🍴</code></b> [SqlFu](https://github.com/sapiens/SqlFu)) - Fast and versatile Micro-ORM.
* <b><code>&nbsp;&nbsp;1104⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;222🍴</code></b> [SmartSql](https://github.com/Ahoo-Wang/SmartSql)) - SmartSql = MyBatis + Cache(Memory | Redis) + ZooKeeper + R/W Splitting +Dynamic Repository ....
* <b><code>&nbsp;&nbsp;&nbsp;467⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;125🍴</code></b> [SQLStreamStore](https://github.com/SQLStreamStore/SQLStreamStore)) - Stream Store library targeting SQL based implementations for .NET.

### Profiling
* <b><code>&nbsp;&nbsp;&nbsp;185⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;42🍴</code></b> [Glimpse](https://github.com/Glimpse/Glimpse.Prototype)) - Lightweight, open-source, real-time diagnostics and insights profiler for .NET. `Unstable version`
* <b><code>&nbsp;&nbsp;2928⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;603🍴</code></b> [MiniProfiler](https://github.com/MiniProfiler/dotnet)) - A simple but effective mini-profiler for ASP.NET websites.

### Query Builders
* <b><code>&nbsp;&nbsp;3142⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;503🍴</code></b> [SqlKata](https://github.com/sqlkata/querybuilder)) - Elegant Sql Query Builder, that supports complex queries, joins, sub queries, nested where conditions, vendor engine targets and more

### Queue and Messaging
* 🌎 [emitter](emitter.io/) - Free open source real-time messaging service that connects all devices. This publish-subscribe messaging API is built for speed and security.
* <b><code>&nbsp;&nbsp;2910⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;747🍴</code></b> [EasyNetQ](https://github.com/EasyNetQ/EasyNetQ)) - An easy to use .NET API for RabbitMQ.
* <b><code>&nbsp;&nbsp;5337⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;647🍴</code></b> [EventStore](https://github.com/EventStore/EventStore)) - The open-source, functional database with Complex Event Processing in JavaScript.
* <b><code>&nbsp;&nbsp;1992⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;244🍴</code></b> [Foundatio](https://github.com/exceptionless/Foundatio#queues)) - A common interface with in memory, redis and azure implementations.
* <b><code>&nbsp;11244⭐</code></b> <b><code>&nbsp;&nbsp;1183🍴</code></b> [MediatR](https://github.com/jbogard/MediatR)) - Simple, unambitious mediator implementation in .NET.
 * <b><code>&nbsp;&nbsp;&nbsp;326⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;90🍴</code></b> [MediatR.Extensions.Microsoft.DependencyInjection](https://github.com/jbogard/MediatR.Extensions.Microsoft.DependencyInjection)) - MediatR extensions for Microsoft.Extensions.DependencyInjection.
* <b><code>&nbsp;&nbsp;&nbsp;373⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;48🍴</code></b> [Mediator.Net](https://github.com/mayuanyang/Mediator.Net)) - A simple mediator for .Net for sending command, publishing event and request response with pipelines supported.
* <b><code>&nbsp;&nbsp;&nbsp;213⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;26🍴</code></b> [MicroBus](https://github.com/Lavinski/Enexure.MicroBus)) - Simple in process mediator for .NET.
* <b><code>&nbsp;&nbsp;4519⭐</code></b> <b><code>&nbsp;&nbsp;1077🍴</code></b> [MQTTnet](https://github.com/chkr1011/MQTTnet)) - MQTTnet is a high performance .NET library for MQTT based communication.
* <b><code>&nbsp;&nbsp;2975⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;747🍴</code></b> [netmq](https://github.com/zeromq/netmq)) - 100% native C# implementation of ZeroMQ for .NET.
* <b><code>&nbsp;&nbsp;2103⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;647🍴</code></b> [NServiceBus](https://github.com/particular/nservicebus)) - NServiceBus is part of the 🌎 [Particular Service Platform](particular.net/service-platform), which contains tools to build, monitor, and debug distributed systems.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;115🍴</code></b> [OpenCQRS](https://github.com/OpenCQRS/OpenCQRS)) - .NET Core library for DDD, CQRS and Event Sourcing with Azure Service Bus integration. Supported database providers for the Command and the Event stores are: DocumentDB, MongoDB, SQL Server, MySQL, PostgreSQL and SQLite.
* <b><code>&nbsp;&nbsp;2103⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;591🍴</code></b> [rabbitmq-dotnet-client](https://github.com/rabbitmq/rabbitmq-dotnet-client)) - RabbitMQ .NET client 🌎 [https://www.rabbitmq.com](www.rabbitmq.com).
* <b><code>&nbsp;&nbsp;&nbsp;747⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;144🍴</code></b> [RawRabbit](https://github.com/pardahlman/RawRabbit)) - Modern .NET framework for communication over RabbitMq.
* <b><code>&nbsp;&nbsp;2339⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;364🍴</code></b> [Rebus](https://github.com/rebus-org/Rebus)) - Simple and lean service bus implementation for .NET.
* [Restbus](http://restbus.org) - Messaging library for RabbitMq.
* <b><code>&nbsp;&nbsp;&nbsp;261⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;39🍴</code></b> [Silverback](https://github.com/BEagle1984/silverback)) - Framework to build event-driven applications (support for Kafka, RabbitMQ, MQTT).
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;62⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;7🍴</code></b> [Tossit](https://github.com/turgayozgur/tossit)) - Simple, easy to use library for distributed job/worker logic. Distributed messages handled by built in RabbitMQ implementation.

### Reporting
* <b><code>&nbsp;&nbsp;2741⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;606🍴</code></b> [FastReport](https://github.com/FastReports/FastReport)) - The open source report generator for .NET Core 2.x/.Net Framework 4.x. FastReport can be used in MVC, Web API applications.

### Scheduler and Job
* <b><code>&nbsp;&nbsp;&nbsp;182⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;18🍴</code></b> [Chroniton.NetCore](https://github.com/leosperry/Chroniton)) - Lightweight robust library for running tasks(jobs) on schedules.
* <b><code>&nbsp;&nbsp;3931⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;259🍴</code></b> [Coravel](https://github.com/jamesmh/coravel)) - .Net Core meets Laravel: Scheduling, Queuing, etc.
* <b><code>&nbsp;&nbsp;2684⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;408🍴</code></b> [FluentScheduler](https://github.com/fluentscheduler/FluentScheduler)) - Automated job scheduler with fluent interface.
* <b><code>&nbsp;&nbsp;&nbsp;544⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;45🍴</code></b> [Gofer.NET](https://github.com/brthor/Gofer.NET)) - Easy C# API for Distributed Background Tasks/Jobs for .NET Core. Inspired by celery for python.
* <b><code>&nbsp;&nbsp;9470⭐</code></b> <b><code>&nbsp;&nbsp;1707🍴</code></b> [HangfireIO](https://github.com/HangfireIO/Hangfire)) - Easy way to perform fire-and-forget, delayed and recurring tasks inside ASP.NET apps [http://hangfire.io](http://hangfire.io).
* <b><code>&nbsp;&nbsp;&nbsp;241⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;29🍴</code></b> [LiquidState](https://github.com/prasannavl/LiquidState)) - Efficient asynchronous and synchronous state machines for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;919⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;139🍴</code></b> [NCrontab](https://github.com/atifaziz/NCrontab)) - Crontab for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [quartznet](https://github.com/quartznet/quartznet/)) - Quartz Enterprise Scheduler .NET [http://www.quartz-scheduler.net](http://www.quartz-scheduler.net).
* <b><code>&nbsp;&nbsp;5646⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;769🍴</code></b> [stateless](https://github.com/dotnet-state-machine/stateless)) - Simple library for creating state machines in C# code.

### SDKs
* <b><code>&nbsp;&nbsp;2078⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;863🍴</code></b> [AWS SDK](https://github.com/aws/aws-sdk-net)) - The Amazon Web Services (AWS) .NET Core SDK components. Each AWS service has its own NuGet package.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;86⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;55🍴</code></b> [azure-event-hubs-dotnet](https://github.com/azure/azure-event-hubs-dotnet)) - .NET Standard client library for Azure Event Hubs.
* Blockchain clients
  * <b><code>&nbsp;&nbsp;&nbsp;141⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;62🍴</code></b> [Bittrex.Net](https://github.com/JKorf/Bittrex.Net)) - C# .Net wrapper for the Bittrex web API including all features easily accessible and usable.
  * <b><code>&nbsp;&nbsp;1056⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;433🍴</code></b> [Binance.Net](https://github.com/JKorf/Binance.Net)) - .Net API wrapper for the Binance web API.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;9⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3🍴</code></b> [CakeMail.RestClient](https://github.com/Jericho/CakeMail.RestClient)) - Client for CakeMail's API. Allows you to send transactional emails, bulk emails, manage lists and contacts, etc.
* <b><code>&nbsp;&nbsp;&nbsp;692⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;192🍴</code></b> [consuldotnet](https://github.com/PlayFab/consuldotnet/tree/develop)) - .NET API for Consul.
* <b><code>&nbsp;&nbsp;&nbsp;647⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;151🍴</code></b> [csharp-nats](https://github.com/nats-io/csharp-nats)) - C# .NET client for the NATS messaging system.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;54⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;14🍴</code></b> [DarkSkyCore](https://github.com/amweiss/dark-sky-core)) - A .NET Standard wrapper for the 🌎 [Dark Sky API](darksky.net/dev/docs).
* <b><code>&nbsp;&nbsp;2275⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;380🍴</code></b> [Docker.DotNet](https://github.com/Microsoft/Docker.DotNet)) - .NET (C#) Client Library for Docker API.
* <b><code>&nbsp;&nbsp;&nbsp;369⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;132🍴</code></b> [firebase-admin-dotnet](https://github.com/firebase/firebase-admin-dotnet)) - Firebase Admin .NET SDK
* <b><code>&nbsp;&nbsp;&nbsp;947⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;370🍴</code></b> [google-cloud-dotnet](https://github.com/GoogleCloudPlatform/google-cloud-dotnet)) - Google Cloud Client Libraries for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;121⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;43🍴</code></b> [Manatee.Trello](https://github.com/gregsdennis/Manatee.Trello)) - A fully object-oriented .Net wrapper for Trello's RESTful API written in C#.
* <b><code>&nbsp;&nbsp;&nbsp;460⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;70🍴</code></b> [Microphone](https://github.com/rogeralsing/Microphone)) - Lightweight framework to run self hosting REST services using Web Api or NancyFx ontop of a Consul or ETCD cluster.
* <b><code>&nbsp;&nbsp;2711⭐</code></b> <b><code>&nbsp;&nbsp;1074🍴</code></b> [octokit.net](https://github.com/octokit/octokit.net)) - GitHub API client library for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;17⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2🍴</code></b> [PreStorm](https://github.com/jshirota/PreStorm)) - Parallel REST Client for ArcGIS Server.
* <b><code>&nbsp;&nbsp;1093⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;587🍴</code></b> [SendGrid-csharp](https://github.com/sendgrid/sendgrid-csharp)) - C# client library for using the full SendGrid API.
* <b><code>&nbsp;&nbsp;&nbsp;110⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;67🍴</code></b> [statsd-csharp-client](https://github.com/Pereingo/statsd-csharp-client)) - .NET Standard compatible C# client to interface with Etsy's excellent <b><code>&nbsp;17713⭐</code></b> <b><code>&nbsp;&nbsp;1955🍴</code></b> [statsd](https://github.com/etsy/statsd)) server.
* <b><code>&nbsp;&nbsp;1007⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;218🍴</code></b> [tweetinvi](https://github.com/linvi/tweetinvi)) - Intuitive .NET C# library to access the Twitter REST and STREAM API.

### Security
* <b><code>&nbsp;&nbsp;&nbsp;267⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;43🍴</code></b> [aspnetcore-security-headers](https://github.com/juunas11/aspnetcore-security-headers)) - Middleware for adding security headers to an ASP.NET Core application.
* <b><code>&nbsp;&nbsp;1573⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;202🍴</code></b> [HtmlSanitizer](https://github.com/mganss/HtmlSanitizer)) - Cleans HTML to avoid XSS attacks.
* <b><code>&nbsp;&nbsp;&nbsp;950⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;185🍴</code></b> [jose-jwt](https://github.com/dvsekhvalnov/jose-jwt)) - Library for processing JOSE objects (JWT, JWA, JWS and related).
* <b><code>&nbsp;&nbsp;2145⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;464🍴</code></b> [Jwt.Net](https://github.com/jwt-dotnet/jwt)) - Jwt.Net, a JWT (JSON Web Token) implementation for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;194⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;30🍴</code></b> [JWT Simple Server](https://github.com/Xabaril/JWTSimpleServer)) - A lightweight, dynamic jwt server for ASP.NET Core.
* <b><code>&nbsp;&nbsp;&nbsp;544⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;75🍴</code></b> [NWebsec](https://github.com/NWebsec/NWebsec)) - Security libraries for ASP.NET [http://www.nwebsec.com](http://www.nwebsec.com).
* <b><code>&nbsp;&nbsp;&nbsp;134⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;37🍴</code></b> [reCAPTCHA](https://github.com/PaulMiami/reCAPTCHA)) - reCAPTCHA 2.0 for ASP.NET Core.
* <b><code>&nbsp;&nbsp;&nbsp;208⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;38🍴</code></b> [roslyn-security-guard](https://github.com/dotnet-security-guard/roslyn-security-guard)) - Roslyn analyzers that aim to help security audit on .NET applications.
* <b><code>&nbsp;&nbsp;&nbsp;282⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;36🍴</code></b> [OwaspHeaders](https://github.com/GaProgMan/OwaspHeaders.Core)) - .NET Core middleware for injecting the Owasp recommended HTTP Headers for increased security.
* <b><code>&nbsp;&nbsp;1271⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;599🍴</code></b> [Security](https://github.com/aspnet/Security)) - Middleware for security and authorization of web apps.
* <b><code>&nbsp;&nbsp;&nbsp;705⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;73🍴</code></b> [SecurityHeaders](https://github.com/andrewlock/NetEscapades.AspNetCore.SecurityHeaders)) - Small package to allow adding security headers to ASP.NET Core websites.

### Searching
* <b><code>&nbsp;&nbsp;&nbsp;122⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [Algolia.Search](https://github.com/algolia/algoliasearch-client-csharp)) - Repository for the official Algolia .NET client.
* <b><code>&nbsp;&nbsp;&nbsp;218⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;22🍴</code></b> [AutoComplete](https://github.com/omerfarukz/autocomplete)) - Persistent, simple, powerful and portable autocomplete library.
* <b><code>&nbsp;&nbsp;3590⭐</code></b> <b><code>&nbsp;&nbsp;1149🍴</code></b> [Elasticsearch.Net & NEST](https://github.com/elastic/elasticsearch-net)) - Repository for both NEST and Elasticsearch.NET, the two official elasticsearch .NET clients.
* <b><code>&nbsp;&nbsp;&nbsp;176⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;49🍴</code></b> [ElasticsearchCRUD](https://github.com/damienbod/ElasticsearchCRUD)) - Elasticsearch .NET API.
* <b><code>&nbsp;&nbsp;&nbsp;332⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;52🍴</code></b> [SearchExtensions](https://github.com/ninjanye/SearchExtensions)) - Advanced search capabilities for IQueryable interfaces, such as Entity Framework queries.
* <b><code>&nbsp;&nbsp;&nbsp;130⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;21🍴</code></b> [SimMetrics.Net](https://github.com/StefH/SimMetrics.Net)) - A Similarity Metric Library, e.g. from edit distance's (Levenshtein, Gotoh, Jaro etc) to other metrics, (e.g Soundex, Chapman)
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;66⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;21🍴</code></b> [SolrExpress](https://github.com/solr-express/solr-express)) - Simple and lightweight query .NET library for Solr, in a controlled, buildable and fail fast way.

### Serialization
* <b><code>&nbsp;&nbsp;&nbsp;293⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;62🍴</code></b> [BinarySerializer](https://github.com/jefffhaynes/BinarySerializer)) - Serialization for custom packet and protocol formats, supports bit-twiddling.
* <b><code>&nbsp;&nbsp;2615⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;324🍴</code></b> [bond](https://github.com/Microsoft/bond)) - Cross-platform framework for working with schematized data. It supports cross-language de/serialization and powerful generic mechanisms for efficiently manipulating data. Bond is broadly used at Microsoft in high scale services.
* <b><code>&nbsp;&nbsp;&nbsp;292⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;35🍴</code></b> [Channels](https://github.com/davidfowl/Channels)) - Push based .NET Streams.
* <b><code>&nbsp;&nbsp;4809⭐</code></b> <b><code>&nbsp;&nbsp;1070🍴</code></b> [CsvHelper](https://github.com/JoshClose/CsvHelper)) - Library to help reading and writing CSV files.
* <b><code>&nbsp;&nbsp;&nbsp;455⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;172🍴</code></b> [Edi.Net](https://github.com/indice-co/EDI.Net)) - EDI Serializer/Deserializer. Supports EDIFact, X12 and TRADACOMS format.
* <b><code>&nbsp;&nbsp;&nbsp;336⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;47🍴</code></b> [ExtendedXmlSerializer](https://github.com/wojtpl2/ExtendedXmlSerializer)) - Extended Xml Serializer for .NET.
* <b><code>&nbsp;&nbsp;2147⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;253🍴</code></b> [Jil](https://github.com/kevin-montrose/Jil)) - Fast .NET JSON (De)Serializer, Built On Sigil.
* MessagePack 
  * <b><code>&nbsp;&nbsp;&nbsp;835⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;175🍴</code></b> [msgpack-cli](https://github.com/msgpack/msgpack-cli)) - MessagePack implementation for Common Language Infrastructure / [msgpack.org](http://msgpack.org).
  * <b><code>&nbsp;&nbsp;5867⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;702🍴</code></b> [MessagePack-CSharp](https://github.com/neuecc/MessagePack-CSharp)) - Extremely Fast MessagePack Serializer for C#(.NET, .NET Core, Unity, Xamarin).
* <b><code>&nbsp;10860⭐</code></b> <b><code>&nbsp;&nbsp;3269🍴</code></b> [Newtonsoft.Json](https://github.com/JamesNK/Newtonsoft.Json)) - Popular high-performance JSON framework for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [protobuf-net](https://github.com/mgravell/protobuf-net/)) - Protocol Buffers library for idiomatic .NET.
* <b><code>&nbsp;&nbsp;&nbsp;647⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;80🍴</code></b> [Schema.NET](https://github.com/RehanSaeed/Schema.NET)) - Schema.org objects turned into strongly typed C# POCO classes for use in .NET. All classes can be serialized into JSON/JSON-LD and XML, typically used to represent structured data in the head section of html page.
* <b><code>&nbsp;&nbsp;1220⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;630🍴</code></b> [ServiceStack.Text](https://github.com/ServiceStack/ServiceStack.Text)) - JSON, JSV and CSV Text Serializers.
* <b><code>&nbsp;&nbsp;&nbsp;377⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;77🍴</code></b> [TinyCsvParser](https://github.com/bytefish/TinyCsvParser)) - Easy to use, easy to extend and high-performance library for CSV parsing with .NET.
* <b><code>&nbsp;&nbsp;&nbsp;375⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;63🍴</code></b> [Wire](https://github.com/rogeralsing/Wire)) - Binary serializer for POCO objects.
* <b><code>&nbsp;&nbsp;2590⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;492🍴</code></b> [YamlDotNet](https://github.com/aaubry/YamlDotNet)) - .NET
* <b><code>&nbsp;&nbsp;2394⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;248🍴</code></b> [ZeroFormatter](https://github.com/neuecc/ZeroFormatter)) - Fast binary (de)serializer for .NET.
* <b><code>&nbsp;&nbsp;2363⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;267🍴</code></b> [Utf8Json](https://github.com/neuecc/Utf8Json)) - Definitely Fastest and Zero Allocation JSON Serializer for C#(NET, .NET Core, Unity, Xamarin).
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [YAXLib](https://github.com/sinairv/YAXLib)) - XML Serialization Library for the .NET Framework and .NET Core. Extremely flexible and powerful.

### Template Engine
* <b><code>&nbsp;&nbsp;1060⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;295🍴</code></b> [dotliquid](https://github.com/dotliquid/dotliquid)) - .NET Port of Tobias Lütke's Liquid template language.
* <b><code>&nbsp;&nbsp;1452⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;179🍴</code></b> [fluid](https://github.com/sebastienros/fluid)) - Open-source .NET template engine that is as close as possible to the Liquid template language.
* <b><code>&nbsp;&nbsp;&nbsp;158⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;39🍴</code></b> [Portable.Xaml](https://github.com/cwensley/Portable.Xaml)) - Portable .NET library for reading/writing xaml files.
* <b><code>&nbsp;&nbsp;&nbsp;882⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;225🍴</code></b> [Razor](https://github.com/aspnet/Razor)) - Parser and code generator for CSHTML files used in view pages for MVC web apps.
* <b><code>&nbsp;&nbsp;1536⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;259🍴</code></b> [RazorLight](https://github.com/toddams/RazorLight)) - Template engine based on Microsoft's Razor parsing engine for .NET Core.
* <b><code>&nbsp;&nbsp;3240⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;361🍴</code></b> [Scriban](https://github.com/lunet-io/scriban)) - A fast, powerful, safe and lightweight text templating language and engine for .NET.

### Testing
* <b><code>&nbsp;&nbsp;&nbsp;491⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;82🍴</code></b> [Atata](https://github.com/atata-framework/atata)) - Web UI test automation full-featured framework based on Selenium WebDriver. 🌎 [https://atata.io](atata.io)
* <b><code>&nbsp;&nbsp;8919⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;508🍴</code></b> [Bogus](https://github.com/bchavez/Bogus)) - Simple and sane fake data generator for C#. Based on and ported from the famed faker.js.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;18⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1🍴</code></b> [CoreBDD](https://github.com/stevenknox/CoreBDD)) - BDD framework for xUnit.net
* <b><code>&nbsp;&nbsp;1713⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;183🍴</code></b> [FakeItEasy](https://github.com/FakeItEasy/FakeItEasy)) - The easy mocking library for .NET.
* <b><code>&nbsp;&nbsp;3812⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;554🍴</code></b> [FluentAssertions](https://github.com/fluentassertions/fluentassertions)) - Set of .NET extension methods that allow you to more naturally specify the expected outcome of a TDD or BDD-style test.
* <b><code>&nbsp;&nbsp;&nbsp;832⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;100🍴</code></b> [GenFu](https://github.com/MisterJames/GenFu)) - Library you can use to generate realistic test data.
* <b><code>&nbsp;&nbsp;&nbsp;355⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;43🍴</code></b> [LightBDD](https://github.com/LightBDD/LightBDD)) - BDD framework allowing to create easy to read and maintain tests.
* <b><code>&nbsp;&nbsp;1638⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;88🍴</code></b> [mockhttp](https://github.com/richardszalay/mockhttp)) - Testing layer for Microsoft's HttpClient library.
* <b><code>&nbsp;&nbsp;5984⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;804🍴</code></b> [moq.netcore](https://github.com/Moq/moq4)) - Most popular and friendly mocking framework for .NET.
* <b><code>&nbsp;&nbsp;&nbsp;887⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;178🍴</code></b> [MSpec](https://github.com/machine/machine.specifications)) - Popular testing framework for writing BDD-style tests.
* <b><code>&nbsp;&nbsp;1725⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;177🍴</code></b> [MyTested.AspNetCore.Mvc](https://github.com/ivaylokenov/MyTested.AspNetCore.Mvc)) - Fluent testing
  framework for ASP.NET Core MVC.
* <b><code>&nbsp;&nbsp;1347⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;210🍴</code></b> [Netling](https://github.com/hallatore/Netling)) - Load tester client for easy web testing.
* <b><code>&nbsp;&nbsp;&nbsp;260⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;57🍴</code></b> [NSpec](https://github.com/nspec/NSpec)) - Battle hardened testing framework for C# that's heavily inspired by Mocha and RSpec.
* <b><code>&nbsp;&nbsp;2703⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;265🍴</code></b> [NSubstitute](https://github.com/nsubstitute/NSubstitute)) - A friendly substitute for .NET mocking frameworks.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;67⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25🍴</code></b> [nunit](https://github.com/nunit/dotnet-test-nunit)) - NUnit test runner for .NET Core.
* <b><code>&nbsp;&nbsp;2053⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;380🍴</code></b> [shouldly](https://github.com/shouldly/shouldly)) - Should testing for .NET - the way Asserting *Should* be! [http://shouldly.readthedocs.org/en/latest](http://shouldly.readthedocs.org/en/latest)
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [SpecFlow](https://github.com/techtalk/SpecFlow)) - Pragmatic BDD solution for .NET. It uses the Gherkin specification language and integrates to Visual Studio.
* <b><code>&nbsp;&nbsp;&nbsp;268⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;53🍴</code></b> [Storyteller](https://github.com/storyteller/Storyteller)) - Executable Specifications for .NET [http://storyteller.github.io](http://storyteller.github.io).
* 🌎 [Stubbery](markvincze.github.io/Stubbery/) - A simple library for creating and running Api stubs in .NET.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;41⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;5🍴</code></b> [Testavior](https://github.com/geeklearningio/Testavior)) - Testavior is a lightweight solution to help you develop Behavior Tests for ASP.NET Core.
* <b><code>&nbsp;&nbsp;&nbsp;421⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;84🍴</code></b> [TestStack.BDDfy](https://github.com/TestStack/TestStack.BDDfy)) - The simplest BDD framework EVER!
* <b><code>&nbsp;&nbsp;&nbsp;381⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;46🍴</code></b> [xBehave.net](https://github.com/xbehave/xbehave.net)) - An xUnit.net extension for describing your tests using natural language. [http://xbehave.github.io](http://xbehave.github.io)
* <b><code>&nbsp;&nbsp;4256⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;787🍴</code></b> [xUnit.net](https://github.com/xunit/xunit)) - A free, open source, community-focused unit testing tool for the .NET Framework.

### Tools
* <b><code>&nbsp;&nbsp;1514⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [CliFx](https://github.com/Tyrrrz/CliFx)) - Declarative framework for building command line interfaces.
* <b><code>&nbsp;&nbsp;2220⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;259🍴</code></b> [CommandLineUtils](https://github.com/natemcmaster/CommandLineUtils)) - Command line parsing and utilities for .NET Core and .NET Framework.
* <b><code>&nbsp;&nbsp;4098⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;868🍴</code></b> [docfx](https://github.com/dotnet/docfx)) - Tools for building and publishing API documentation for .NET projects [http://dotnet.github.io/docfx](http://dotnet.github.io/docfx)
* 🌎 [dotnetfiddle](dotnetfiddle.net) - .NET sandbox for developers to quickly try out code and share code snippets.
* <b><code>&nbsp;&nbsp;1501⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;207🍴</code></b> [dotnet-tools](https://github.com/natemcmaster/dotnet-tools)) - A list of tool extensions for .NET Core Command Line (dotnet CLI).
  * <b><code>&nbsp;&nbsp;&nbsp;458⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;83🍴</code></b> [LibMan CLI](https://github.com/aspnet/LibraryManager)) - Client-side content manager for web apps.
* <b><code>&nbsp;&nbsp;&nbsp;137⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6🍴</code></b> [EntryPoint](https://github.com/Nick-Lucas/EntryPoint)) - Composable CLI (Command Line) Argument Parser for .Net Core & .Net Framework 4.5+.
* <b><code>&nbsp;&nbsp;&nbsp;390⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;84🍴</code></b> [Fake JSON Server](https://github.com/ttu/dotnet-fake-json-server)) - Fake REST API for prototyping or as a CRUD Back End. No need to define types, uses dynamic typing. Data is stored to a single JSON file. Has authentication, WebSocket notifications, async long running operations, random generation for errors/delays and experimental GraphQL support.
* <b><code>&nbsp;&nbsp;8324⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;629🍴</code></b> [gitignore.io](https://github.com/joeblau/gitignore.io)) - Create useful .gitignore files for your project 🌎 [https://www.gitignore.io](www.gitignore.io).
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;71⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;20🍴</code></b> [ICanHasDotnetCore](https://github.com/OctopusDeploy/ICanHasDotnetCore)) - Scans uploaded packages.config files or GitHub repository and determines whether the nuget packages target .NET Standard.
* [json2csharp](http://json2csharp.com) - Generate C# classes from JSON.
* <b><code>&nbsp;&nbsp;5314⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;820🍴</code></b> [letsencrypt-win-simple](https://github.com/Lone-Coder/letsencrypt-win-simple)) - A Simple ACME Client for Windows.
* <b><code>&nbsp;&nbsp;&nbsp;756⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;35🍴</code></b> [Linq_Faster](https://github.com/jackmott/LinqFaster)) - Linq-like extension functions for Arrays, Span<T>, and List<T> that are faster and allocate less.
 
* <b><code>&nbsp;&nbsp;8989⭐</code></b> <b><code>&nbsp;&nbsp;1421🍴</code></b> [mRemoteNG](https://github.com/mRemoteNG/mRemoteNG)) - The next generation of mRemote, open source, tabbed, multi-protocol, remote connections manager
* <b><code>&nbsp;&nbsp;1414⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;539🍴</code></b> [NJsonSchema](https://github.com/RSuter/NJsonSchema)) - NJsonSchema is a .NET library to read, generate and validate JSON Schema draft v4+ schemas.
* <b><code>&nbsp;&nbsp;&nbsp;542⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;125🍴</code></b> [NuKeeper](https://github.com/NuKeeperDotNet/NuKeeper)) - Automagically update nuget packages in .NET projects.
* <b><code>&nbsp;&nbsp;2408⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;442🍴</code></b> [NuGetPackageExplorer](https://github.com/NuGetPackageExplorer/NuGetPackageExplorer)) - Create, update and deploy Nuget Packages with a GUI.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;21⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [NugetVisualizer](https://github.com/sepharg/NugetVisualizer)) - Visualize all of the nuget packages and their corresponding versions for a set of given git repositories or folders.
* <b><code>&nbsp;&nbsp;5289⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;277🍴</code></b> [OctoLinker](https://github.com/OctoLinker/browser-extension)) - Navigate through `projects.json` files efficiently with the OctoLinker browser extension for GitHub.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;45⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1🍴</code></b> [posh-dotnet](https://github.com/bergmeister/posh-dotnet)) - `PowerShell` tab completion for the <b><code>&nbsp;&nbsp;3487⭐</code></b> <b><code>&nbsp;&nbsp;1070🍴</code></b> [dotnet CLI](https://github.com/dotnet/cli)).
* <b><code>&nbsp;&nbsp;&nbsp;650⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25🍴</code></b> [Rin](https://github.com/mayuki/Rin)) - Request/response Inspector middleware for ASP.NET Core. like Glimpse.
* <b><code>&nbsp;21439⭐</code></b> <b><code>&nbsp;&nbsp;1418🍴</code></b> [scoop](https://github.com/lukesampson/scoop)) - A command-line installer for Windows.
* <b><code>&nbsp;&nbsp;&nbsp;309⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;29🍴</code></b> [SerilogAnalyzer](https://github.com/Suchiman/SerilogAnalyzer)) - Roslyn-based analysis for code using the Serilog logging library. Checks for common mistakes and usage problems.
* <b><code>&nbsp;&nbsp;3744⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;977🍴</code></b> [SharpZipLib](https://github.com/icsharpcode/SharpZipLib)) - #ziplib is a Zip, GZip, Tar and BZip2 library written entirely in C# for the .NET platform.
* <b><code>&nbsp;30100⭐</code></b> <b><code>&nbsp;&nbsp;3220🍴</code></b> [ShareX](https://github.com/ShareX/ShareX)) - Free and open source program that lets you capture or record any area of your screen and share it with a single press of a key. It also allows uploading images, text or other types of files to over 80 supported destinations you can choose from. 🌎 [https://getsharex.com](getsharex.com)
* <b><code>&nbsp;&nbsp;2750⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;202🍴</code></b> [SharpLab](https://github.com/ashmind/SharpLab)) - .NET code playground that shows intermediate steps and results of code compilation. 🌎 [https://sharplab.io](sharplab.io)
* <b><code>&nbsp;&nbsp;&nbsp;572⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;164🍴</code></b> [SmartCode](https://github.com/Ahoo-Wang/SmartCode)) – SmartCode= IDataSource -> IBuildTask -> IOutput => Build Everything!!! (Including [Code generator])
* <b><code>&nbsp;&nbsp;1262⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;123🍴</code></b> [sourcelink](https://github.com/dotnet/sourcelink)) - SourceLink is a language- and source-control agnostic system for providing first-class source debugging experiences for binaries.
* <b><code>&nbsp;&nbsp;3441⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;385🍴</code></b> [System.CommandLine](https://github.com/dotnet/command-line-api)) - System.CommandLine, a set of libraries for command line parsing, invocation, and rendering of terminal output.
* <b><code>&nbsp;&nbsp;&nbsp;244⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13🍴</code></b> [Typin](https://github.com/adambajguz/Typin)) - Simple to use declarative framework for interactive CLI applications and command line tools (direct mode) that has its roots in CliFx.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;5⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [X.Web.Sitemap](https://github.com/dncuug/X.Web.Sitemap)) – Simple sitemap generator for .NET and .NET Core
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;26⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3🍴</code></b> [X.Web.RSS](https://github.com/dncuug/X.Web.RSS)) – Simple RSS Feed generator for .NET and .NET Core

### Web Framework
* WebAssembly
  * <b><code>&nbsp;&nbsp;1695⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;122🍴</code></b> [Blazor](https://github.com/SteveSanderson/Blazor)) - UI framework running .NET in the browser via WebAssembly.
    * <b><code>&nbsp;&nbsp;8879⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;984🍴</code></b> [Awesome Blazor](https://github.com/AdrienTorris/awesome-blazor)) - Collection of awesome resources (samples, components, articles, videos and others) about Blazor.
    * <b><code>&nbsp;&nbsp;&nbsp;482⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;48🍴</code></b> [Blazor Redux](https://github.com/torhovland/blazor-redux)) - Connecting a Redux state store with Blazor.
  * <b><code>&nbsp;&nbsp;1622⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;160🍴</code></b> [Ooui](https://github.com/praeclarum/Ooui)) - Small cross-platform UI library that brings the simplicity of native UI development to the web.
* <b><code>&nbsp;&nbsp;2299⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;932🍴</code></b> [ReactJS.NET](https://github.com/reactjs/React.NET)) - .NET library for JSX compilation and server-side rendering of React components.
* <b><code>&nbsp;&nbsp;&nbsp;714⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;88🍴</code></b> [redux.NET](https://github.com/GuillaumeSalles/redux.NET)) - Predictable state container for .NET apps. Inspired by <b><code>&nbsp;60937⭐</code></b> <b><code>&nbsp;15259🍴</code></b> [https://github.com/reactjs/redux](https://github.com/reactjs/redux)).

### Web Socket
* <b><code>&nbsp;&nbsp;2314⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;586🍴</code></b> [Fleck](https://github.com/statianzo/Fleck)) - Fleck is a WebSocket server implementation in C#. Fleck requires no inheritance, container, or additional references.
* <b><code>&nbsp;&nbsp;2383⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;445🍴</code></b> [SignalR Server](https://github.com/aspnet/signalr)) - Real-time web functionality for web apps, including server-side push.
* <b><code>&nbsp;&nbsp;3961⭐</code></b> <b><code>&nbsp;&nbsp;1147🍴</code></b> [SuperSocket](https://github.com/kerryjiang/SuperSocket)) - Light weight, cross platform and extensible socket server application framework.
* <b><code>&nbsp;&nbsp;&nbsp;384⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;84🍴</code></b> [WampSharp](https://github.com/Code-Sharp/WampSharp)) - C# implementation of [The Web Application Messaging Protocol](http://wamp-proto.org/) - Protocol that provides messaging patterns of Remote Procedure Calls and Publish/Subscribe over WebSockets.
* <b><code>&nbsp;&nbsp;&nbsp;452⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;183🍴</code></b> [websocket-manager](https://github.com/radu-matei/websocket-manager)) - Real-Time library for ASP .NET Core.

### Windows Service
* <b><code>&nbsp;&nbsp;&nbsp;452⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;57🍴</code></b> [dotnet-win32-service](https://github.com/dasMulli/dotnet-win32-service)) - Set up and run as Windows Service directly from .NET Core.
* <b><code>&nbsp;&nbsp;3585⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;692🍴</code></b> [Topshelf](https://github.com/Topshelf/Topshelf)) - Easy service hosting framework for building Windows services using .NET.

### Workflow
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [CoreWF](https://github.com/dmetzgar/corewf/)) - Port of Windows Workflow Foundation (WF) to .NET Core.
* <b><code>&nbsp;&nbsp;5419⭐</code></b> <b><code>&nbsp;&nbsp;1204🍴</code></b> [workflow-core](https://github.com/danielgerlag/workflow-core)) - Lightweight workflow engine for .NET Standard.
* <b><code>&nbsp;&nbsp;&nbsp;911⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;251🍴</code></b> [WorkflowEngine.NET](https://github.com/optimajet/WorkflowEngine.NET)) - Component that adds workflow in your application.
* <b><code>&nbsp;&nbsp;&nbsp;599⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;165🍴</code></b> [Wexflow](https://github.com/aelassas/Wexflow)) - A high performance, extensible, modular and cross-platform workflow engine.

## Roadmaps
* <b><code>&nbsp;18741⭐</code></b> <b><code>&nbsp;&nbsp;2499🍴</code></b> [ASP.NET Core Developer Roadmap](https://github.com/MoienTajik/AspNetCore-Developer-Roadmap)) - Roadmap to becoming an ASP.NET Core developer in 2019.

## Starter Kits
* [Arch](https://github.com/Arch) - The collection of .NET Core libraries that are created by software architects who embrace all the new stuff in .NET Core.
  * <b><code>&nbsp;&nbsp;&nbsp;785⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;110🍴</code></b> [AutoHistory](https://github.com/Arch/AutoHistory)) - A plugin for Microsoft.EntityFrameworkCore to support automatically recording data changes history.
* <b><code>&nbsp;&nbsp;1462⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;434🍴</code></b> [AspNetCore-Angular2-Universal](https://github.com/MarkPieszak/aspnetcore-angular2-universal)) - Cross-platform - w/ server-side rendering for SEO, Bootstrap, i18n internationalization (ngx-translate), Webpack, TypeScript, unit testing w/ Karma, WebAPI REST setup, SignalR, Swagger docs, and more!
* <b><code>&nbsp;&nbsp;1161⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;203🍴</code></b> [ASP.NET Core Starter Kit](https://github.com/kriasoft/aspnet-starter-kit)) - Opinionated boilerplate for web development based on .NET Core, Kestrel, GraphQL on the backend and Babel, Webpack, React and Redux on the frontend. This boilerplate comes in both C# and F# flavors.
* <b><code>&nbsp;&nbsp;3038⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;520🍴</code></b> [aspnetcore-spa generator](https://github.com/aspnet/JavaScriptServices)) - Yeoman generator to build a brand-new ASP.NET Core single page application that uses Angular 2 / React / React With Redux / Knockout / Aurelia on the client.
* <b><code>&nbsp;&nbsp;1215⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;266🍴</code></b> [ASP.Net Core Vue Starter](https://github.com/MarkPieszak/aspnetcore-Vue-starter)) - Asp.NETCore 2.0 Vue 2 (ES6) SPA Starter kit, contains routing, Vuex, and more!.
* <b><code>&nbsp;15868⭐</code></b> <b><code>&nbsp;&nbsp;1326🍴</code></b> [bitwarden-core](https://github.com/bitwarden/core)) - The core infrastructure backend (API, database, etc) 🌎 [https://bitwarden.com](bitwarden.com).
* <b><code>&nbsp;&nbsp;1183⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;164🍴</code></b> [dotNetify](https://github.com/dsuryd/dotNetify)) - Simple, lightweight, yet powerful way to build real-time HTML5/C# .NET web apps.
* <b><code>&nbsp;&nbsp;&nbsp;875⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;168🍴</code></b> [generator-aspnet](https://github.com/OmniSharp/generator-aspnet)) - yo generator for ASP.NET Core.
* <b><code>&nbsp;&nbsp;&nbsp;356⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;87🍴</code></b> [Nucleus](https://github.com/alirizaadiyahsi/Nucleus)) - Vue startup application template that uses ASP.NET Core API layered architecture at the back-end and JWT based authentication
* <b><code>&nbsp;&nbsp;&nbsp;287⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;51🍴</code></b> [react-aspnet-boilerplate](https://github.com/pauldotknopf/react-aspnet-boilerplate)) - Starting point for building isomorphic React applications with ASP.NET Core 1, leveraging existing techniques.
* <b><code>&nbsp;&nbsp;1106⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;317🍴</code></b> [saaskit](https://github.com/saaskit/saaskit)) - Developer toolkit for building SaaS applications.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;52⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;14🍴</code></b> [serverlessDotNetStarter](https://github.com/pharindoko/serverlessDotNetStarter)) starter kit for development and deployment of lambda functions in the AWS cloud based on serverless framework.

## Sample Projects
* Microservices & Service Mesh
  * <b><code>&nbsp;&nbsp;1243⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;266🍴</code></b> [clean-architecture-dotnet](https://github.com/thangchung/clean-architecture-dotnet)) - Apply Minimal Clean Architecture with DDD-lite, CQRS-lite, and just enough Cloud-native patterns on eCommerce sample business domain
  * <b><code>&nbsp;&nbsp;2479⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;583🍴</code></b> [coolstore-microservices ](https://github.com/vietnam-devs/coolstore-microservices)) - A Kubernetes-based polyglot microservices application with Istio service mesh
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;42⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4🍴</code></b> [distributed-playground](https://github.com/jvandevelde/distributed-playground)) - Distributed service playground with Vagrant, Consul, Docker & ASP.NET Core.
  * [DNC-DShop](https://github.com/devmentors) - Distributed .NET Core project and free course. (DDD, CQRS, RabbitMQ, MongoDB, Redis, Monitoring, Logging, CI, CD)
  * <b><code>&nbsp;&nbsp;1906⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;681🍴</code></b> [dotnetcore-microservices-poc](https://github.com/asc-lab/dotnetcore-microservices-poc)) -  simplified insurance sales system made in a microservices architecture using .NET Core (EF Core, MediatR, Marten, Eureka, Ocelot, RabbitMQ, Polly, ElasticSearch, Dapper) with blog post series.
  * <b><code>&nbsp;&nbsp;6628⭐</code></b> <b><code>&nbsp;&nbsp;2023🍴</code></b> [eShop](https://github.com/dotnet/eShop)) - A reference .NET application implementing an eCommerce site.
  * <b><code>&nbsp;&nbsp;&nbsp;138⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;24🍴</code></b> [InMemoryCQRSReplication](https://github.com/Aaronontheweb/InMemoryCQRSReplication)) - Akka.NET Reference Architecture - CQRS + Sharding + In-Memory Replication
  * <b><code>&nbsp;&nbsp;&nbsp;178⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;50🍴</code></b> [magazine-website](https://github.com/thangchung/magazine-website)) - Magazine website (using .NET Core, ASP.NET Core, EF Core) with DDD, CQRS, microservices, asynchronous programming applied.
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;89⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;54🍴</code></b> [microservices-in-dotnetcore](https://github.com/horsdal/microservices-in-dotnet-book-second-edition)) - The code sample from the second edition of 🌎 [Microservices in .NET Core](www.manning.com/books/microservices-in-net-core-second-edition).
  * <b><code>&nbsp;&nbsp;2148⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;555🍴</code></b> [Practical.CleanArchitecture](https://github.com/phongnguyend/Practical.CleanArchitecture)) - Full-stack .Net 8 Clean Architecture (Microservices, Modular Monolith, Monolith), Blazor, Angular 18, React 18, Vue 3, BFF with YARP, Domain-Driven Design, CQRS, SOLID, Asp.Net Core Identity Custom Storage, OpenID Connect, Entity Framework Core, OpenTelemetry, SignalR, Hosted Services, Health Checks, Rate Limiting, Cloud Services (Azure, AWS, GCP).
  * <b><code>&nbsp;&nbsp;&nbsp;300⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;63🍴</code></b> [practical-dapr](https://github.com/thangchung/practical-dapr)) - Full-stack .NET microservices build on Dapr and Tye.
  * <b><code>&nbsp;&nbsp;1840⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;575🍴</code></b> [ReactiveTraderCloud](https://github.com/AdaptiveConsulting/ReactiveTraderCloud)) - Real-time trading platform demo showcasing reactive programming principles applied across the full application stack.   
* Monoliths
  * <b><code>&nbsp;&nbsp;&nbsp;507⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;352🍴</code></b> [AlbumViewerVNext](https://github.com/RickStrahl/AlbumViewerVNext)) - West Wind Album Viewer ASP.NET 5 Sample.
  * <b><code>&nbsp;&nbsp;&nbsp;893⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;631🍴</code></b> [allReady](https://github.com/HTBox/allReady)) - Open-source solution focused on increasing awareness, efficiency and impact of preparedness campaigns as they are delivered by humanitarian and disaster response organizations in local communities. [http://www.htbox.org/projects/allready](http://www.htbox.org/projects/allready)
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;37⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6🍴</code></b> [AspNet5GeoElasticsearch](https://github.com/damienbod/AspNet5GeoElasticsearch)) - ASP.NET Core MVC Geo Elasticsearch Swashbuckle Swagger.
  * <b><code>&nbsp;&nbsp;&nbsp;294⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;62🍴</code></b> [aspnet-servicediscovery-patterns](https://github.com/cecilphillip/aspnet-servicediscovery-patterns)) - Samples of implementing Service Discovery patterns with ASP.NET Core.
  * <b><code>&nbsp;&nbsp;1175⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;245🍴</code></b> [AspNetAuthorizationWorkshop](https://github.com/blowdart/AspNetAuthorizationWorkshop)) - A workshop for moving through the various new pieces in ASP.NET Core Authorization
  * 🌎 [BikeSharing360 Suite of Apps from Microsoft](blogs.msdn.microsoft.com/visualstudio/2016/12/14/connectdemos-2016-bikesharing360-on-github/) Presented December Connect 2016 Conference, a compreshsive set of interworking apps for both enterprise users and the consumers (bike riders): <b><code>&nbsp;&nbsp;&nbsp;440⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;240🍴</code></b> [Mobile Apps](https://github.com/Microsoft/BikeSharing360_MobileApps)), <b><code>&nbsp;&nbsp;&nbsp;&nbsp;91⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;51🍴</code></b> [Backend Services](https://github.com/Microsoft/BikeSharing360_BackendServices)), <b><code>&nbsp;&nbsp;&nbsp;110⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;66🍴</code></b> [Websites](https://github.com/Microsoft/BikeSharing360_Websites)), <b><code>&nbsp;&nbsp;&nbsp;&nbsp;26⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;29🍴</code></b> [Single Container Apps](https://github.com/Microsoft/BikeSharing360_SingleContainer)), <b><code>&nbsp;&nbsp;&nbsp;&nbsp;33⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;30🍴</code></b> [Multi Container Apps](https://github.com/Microsoft/BikeSharing360_MultiContainer)), <b><code>&nbsp;&nbsp;&nbsp;&nbsp;38⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25🍴</code></b> [Cognitive Services Kiosk App](https://github.com/Microsoft/BikeSharing360_CognitiveServicesKioskApp)),
 <b><code>&nbsp;&nbsp;&nbsp;&nbsp;30⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;23🍴</code></b> [Azure Bot App](https://github.com/Microsoft/BikeSharing360_BotApps)).
  * <b><code>&nbsp;&nbsp;4033⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;695🍴</code></b> [Clean Architecture Manga](https://github.com/ivanpaulovich/clean-architecture-manga)) - Clean Architecture sample with .NET Core 3.0 and C# 8. Use cases as central organising structure, completely testable, decoupled from frameworks.
  * <b><code>&nbsp;&nbsp;1332⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;282🍴</code></b> [cloudscribe](https://github.com/cloudscribe/cloudscribe)) - ASP.NET Core Multi-tenant web application foundation.
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;74⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;35🍴</code></b> [CoreCodeCamp](https://github.com/shawnwildermuth/CoreCodeCamp)) - An Open Source Website for running small, local development events.
  * <b><code>&nbsp;&nbsp;&nbsp;238⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;87🍴</code></b> [DotNetClub](https://github.com/scheshan/DotNetClub)) - Tiny club written in ASP.NET Core.
  * <b><code>&nbsp;10243⭐</code></b> <b><code>&nbsp;&nbsp;5583🍴</code></b> [eShopOnWeb](https://github.com/dotnet-architecture/eShopOnWeb)) - A layered application architecture with monolithic deployment model.
  * <b><code>&nbsp;&nbsp;&nbsp;557⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;278🍴</code></b> [Entropy](https://github.com/aspnet/Entropy)) - Chaotic experimental playground for new features and ideas - check here for small and simple samples for individual features.
  * <b><code>&nbsp;&nbsp;6446⭐</code></b> <b><code>&nbsp;&nbsp;1610🍴</code></b> [EquinoxProject](https://github.com/EduardoPires/EquinoxProject)) - Full ASP.NET Core 2.0 application with DDD, CQRS and Event Sourcing.
  * <b><code>&nbsp;&nbsp;&nbsp;133⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25🍴</code></b> [GenVue](https://github.com/herbat73/GenVue)) - a hostable, web application that lets confidential users upload and share private files build on Vue.js, Vuetifyjs and NetCore WebAPI stack
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;64⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25🍴</code></b> [guidance-identity-management-for-multitenant-apps](https://github.com/Azure-Samples/guidance-identity-management-for-multitenant-apps)) - How to manage user identities in a multitenant app on Microsoft Azure, using Azure Active Directory for authentication.
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;83⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;12🍴</code></b> [JustA.ML](https://github.com/mustakimali/JustA.ML)) - A web application that lets you share files/URL/text between your devices written in ASP.NET Core 2.0. Open source, live at 🌎 [https://justa.ml](justa.ml)
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;28⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6🍴</code></b> [MegaMine](https://github.com/Nootus/MegaMine)) - Open source mining solution that helps miners in extracting Gold, Quartz, Granite etc. This solution is built using ASP.NET Core and AngularJS utilizing multiple light weight components in a Microservices way.
  * <b><code>&nbsp;35674⭐</code></b> <b><code>&nbsp;10118🍴</code></b> [MusicStore](https://github.com/dotnet/aspnetcore/tree/master/src/MusicStore)) - Sample MusicStore application that uses MVC and Entity Framework.
  * <b><code>&nbsp;&nbsp;&nbsp;155⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;53🍴</code></b> [NLayerAppV3](https://github.com/cesarcastrocuba/nlayerappv3)) - NLayerAppV3 N-Layered Architecture with .NET Core Preview 2.
  * <b><code>&nbsp;&nbsp;5007⭐</code></b> <b><code>&nbsp;&nbsp;1586🍴</code></b> [NorthwindTraders](https://github.com/JasonGT/NorthwindTraders)) - Northwind Traders is a sample application built using ASP.NET Core and Entity Framework Core.
  * <b><code>&nbsp;&nbsp;&nbsp;387⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;133🍴</code></b> [Orchard Core - Modular and Multi-tenant applications](https://github.com/OrchardCMS/OrchardCore.Samples)) - Use Orchard Core Framework to create Modular and Multi-tenant applications.
  * <b><code>&nbsp;&nbsp;&nbsp;349⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;163🍴</code></b> [PhotoGallery](https://github.com/chsakell/aspnet5-angular2-typescript)) - Cross-platform Single Page Applications with ASP.NET Core, Angular 2 & TypeScript [http://wp.me/p3mRWu-11L](http://wp.me/p3mRWu-11L).
  * <b><code>&nbsp;&nbsp;&nbsp;&nbsp;45⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;16🍴</code></b> [PokeR](https://github.com/halomademeapc/pokeR)) - Realtime scrum poker using SignalR and Angular in ASP.NET Core's SPA hosting.  Includes Docker support. 🌎 [Demo](planning.halomademeapc.com)
  * <b><code>&nbsp;&nbsp;9561⭐</code></b> <b><code>&nbsp;&nbsp;1283🍴</code></b> [Practical ASP.NET Core](https://github.com/dodyg/practical-aspnetcore)) - A daily updated micro samples of ASP.NET Core features and facilities.
  * <b><code>&nbsp;&nbsp;2148⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;555🍴</code></b> [Practical.CleanArchitecture](https://github.com/phongnguyend/Practical.CleanArchitecture)) - Full-stack .Net 8 Clean Architecture (Microservices, Modular Monolith, Monolith), Blazor, Angular 18, React 18, Vue 3, BFF with YARP, Domain-Driven Design, CQRS, SOLID, Asp.Net Core Identity Custom Storage, OpenID Connect, Entity Framework Core, OpenTelemetry, SignalR, Hosted Services, Health Checks, Rate Limiting, Cloud Services (Azure, AWS, GCP).
  * <b><code>&nbsp;&nbsp;2909⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;649🍴</code></b> [Sample .NET Core CQRS REST API](https://github.com/kgrzybek/sample-dotnet-core-cqrs-api)) - .NET Core REST API CQRS implementation with raw SQL and DDD using Clean Architecture.
  * <b><code>&nbsp;&nbsp;&nbsp;621⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;98🍴</code></b> [StarWars](https://github.com/JacekKosciesza/StarWars)) - GraphQL 'Star Wars' example using GraphQL for .NET, ASP.NET Core, Entity Framework Core.
 
## Articles
* Basic knowledge
  * 🌎 [Microsoft architectural overview of comprehensive BikeSharing360 suite of demo apps with related videos](blogs.msdn.microsoft.com/visualstudio/2016/12/14/connectdemos-2016-bikesharing360-on-github/)
  * 🌎 [Porting a .NET Framework library to .NET Core](www.codeproject.com/Articles/1190475/Porting-a-NET-Framework-library-to-NET-Core)
  * [The 68 things the CLR does before executing a single line of your code](http://mattwarren.org/2017/02/07/The-68-things-the-CLR-does-before-executing-a-single-line-of-your-code/)
  * The comparison between .NET Core and Nodejs at 🌎 [here](manuel-rauber.com/2016/03/07/node-js-asp-net-core-1-0-a-usage-comparison/), 🌎 [here](gist.github.com/ilyaigpetrov/f6df3e6f825ae1b5c7e2) and <b><code>&nbsp;&nbsp;&nbsp;&nbsp;46⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;28🍴</code></b> [here](https://github.com/thinktecture/nodejs-aspnetcore-webapi))
  * [Understanding ASP.NET Core Initialization](http://developer.telerik.com/featured/understanding-asp-net-core-initialization/)
  * 🌎 [Why you should join .NET Core and ASP.NET Core train](codingblast.com/why-you-should-join-asp-net-core/)
* Cloud Development
  * 🌎 [Configuring the AWS SDK in .NET Core](aws.amazon.com/blogs/developer/configuring-aws-sdk-with-net-core/)
  * 🌎 [Serverless Architecture using C# and AWS Amazon Gateway Api/Lambda](www.codeproject.com/Articles/1178781/Serverless-Architecture-using-Csharp-and-AWS-Amazo)
  * 🌎 [Using C# and .NET Core in Amazon Web Services (AWS) Lambda](aws.amazon.com/blogs/compute/announcing-c-sharp-support-for-aws-lambda/)
* Configuration and deployment
  * 🌎 [.NET project structure](gist.github.com/davidfowl/ed7564297c61fe9ab814)
  * [Adding Travis CI builds to a .NET Core app](http://andrewlock.net/adding-travis-ci-to-a-net-core-app/)
  * [ASP.NET Core 1.0 - Configure ApplicationInsights](http://social.technet.microsoft.com/wiki/contents/articles/35918.asp-net-core-1-0-configure-applicationinsights.aspx)
  * [haproxy, nginx, Angular 2, ASP.NET Core, Redis and Docker](http://tattoocoder.azurewebsites.net/legion-of-heroes-haproxy-nginx-angular2-aspnetcore-redis-docker/)
  * [Project.json to MSBuild conversion guide](http://www.natemcmaster.com/blog/2017/01/19/project-json-to-csproj/)
  * 🌎 [Publishing a .NET project with Appveyor and NuGet](few-lines-of-code.blogspot.com/2016/03/publishing-net-project-with-appveyor.html)
  * [The New Configuration Model in ASP.NET Core](http://developer.telerik.com/featured/new-configuration-model-asp-net-core/)
* Entity Framework Core
  * 🌎 [.NET Core Data Access](blogs.msdn.microsoft.com/dotnet/2016/11/09/net-core-data-access/)
  * <b><code>&nbsp;&nbsp;&nbsp;114⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;45🍴</code></b> [A very good example about EF Core](https://github.com/rowanmiller/Demo-EFCore))
  * [Connect to Postgres with EF Core](http://en.otomatikmuhendis.com/2017/05/05/connect-to-postgres-with-ef-core/)
* Miraculous
  * [Getting started with Orchard Core as a NuGet package](http://www.ideliverable.com/blog/getting-started-with-orchard-core-as-a-nuget-package)
  * 🌎 [How to export HTML to PDF in ASP.NET Core](code.msdn.microsoft.com/How-to-export-HTML-to-PDF-c5afd0ce)
  * [Vue.js server side rendering with ASP.NET Core](http://mgyongyosi.com/2016/Vuejs-server-side-rendering-with-aspnet-core/)
* Security
  * [.NET Continuous Delivery Microservices](http://stackshare.io/tomstaijen/net-continuous-delivery-microservices)
  * 🌎 [ASP.NET Core 2.0 Authentication and Authorization System Demystified](digitalmccullough.com/posts/aspnetcore-auth-system-demystified.html)
  * <b><code>&nbsp;&nbsp;1175⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;245🍴</code></b> [A walk-through for an ASP.NET Authorization Lab](https://github.com/blowdart/AspNetAuthorizationWorkshop))
  * 🌎 [Authentication in ASP.NET Core](stormpath.com/blog/authentication-asp-net-core)
* Testing
  * [Selenium with .NET Core](http://www.dotnetcatch.com/2016/11/23/selenium-with-net-core/)
- 🌎 [InfoQ .NET articles](www.infoq.com/dotnet) -  Collection of best .NET articles on InfoQ site

## Books
* 🌎 [.NET Core in Action](manning.com/books/dotnet-core-in-action)
* 🌎 [ASP.NET Core Application Development: Building an application in four sprints (Developer Reference)](www.amazon.com/ASP-NET-Core-Application-Development-application/dp/1509304061)
* 🌎 [ASP.NET Core in Action](www.manning.com/books/asp-net-core-in-action)
* 🌎 [ASP.NET Core 1.0 High Performance](www.amazon.com/ASP-NET-Core-1-0-High-Performance/dp/1785881892)
* 🌎 [Building Microservices with ASP.NET Core: Develop, Test, and Deploy Cross-Platform Services in the Cloud](www.amazon.com/Building-Microservices-ASP-NET-Core-Cross-Platform/dp/1491961732)
* 🌎 [C# 6 and .NET Core 1.0: Modern Cross-Platform Development](www.amazon.com/NET-Core-1-0-Cross-Platform-Development/dp/1785285696)
* 🌎 [C# in Depth 4](www.amazon.com/C-Depth-Jon-Skeet/dp/1617294535)
* 🌎 [Dependency Injection in .NET Core, 2nd edition](www.manning.com/books/dependency-injection-in-dot-net-second-edition)
* 🌎 [Essencial C# 7.0](www.amazon.com/Essential-7-0-Addison-Wesley-Microsoft-Technology/dp/1509303588)
* 🌎 [Exploring .NET Core with Microservices, ASP.NET Core, and Entity Framework Core - free eBook sampler](www.manning.com/books/exploring-dot-net-core)
* 🌎 [Microservices in .NET Core: with C#, the Nancy framework, and OWIN middleware](www.amazon.com/Microservices-NET-Core-framework-middleware/dp/1617293377)
* 🌎 [Professional C# 6 and .NET Core 1.0](www.amazon.com/Professional-NET-Core-Christian-Nagel/dp/111909660X)
* 🌎 [The little ASP.NET Core](www.recaffeinate.co/book)


## Videos
* 🌎 [Channel9](channel9.msdn.com) - MSDN
* 🌎 [Channel9](www.youtube.com/channel/UCsMica-v34Irf9KVTh6xx-g) - YouTube
* 🌎 [Microsoft Learning Center](dotnet.microsoft.com/learn/aspnet)
 * 🌎 [ASP.NET Monsters](channel9.msdn.com/Series/aspnetmonsters)
* 🌎 [Visual Studio](www.youtube.com/user/VisualStudio/channels)

## Podcasts
* 🌎 [.NET Rocks](www.dotnetrocks.com)
* [Merge Conflict](http://www.mergeconflict.fm/)
* [The sound of .NET](http://thesoundof.net/?q=.NET+Core)

## Community
* [.NET Foundation](http://forums.dotnetfoundation.org)
* 🌎 [.NET Blog](devblogs.microsoft.com/dotnet/)
* 🌎 [/r/CoolGithubProjects](www.reddit.com/r/coolgithubprojects)
* 🌎 [ASP.NET](forums.asp.net)
* 🌎 [Channel9](channel9.msdn.com)
* 🌎 [Awesome .NET open source & community resources](discoverdot.net)
* [Slack](http://tattoocoder.com/aspnet-slack-sign-up)
* 🌎 [BuiltWithDot.Net](builtwithdot.net)
* Stack Overflow
  *  🌎 [.NET Core](stackoverflow.com/questions/tagged/.net-core)
  *  🌎 [CoreCLR](stackoverflow.com/questions/tagged/coreclr)
  *  🌎 [ASP.NET Core](stackoverflow.com/questions/tagged/asp.net-core)
  *  🌎 [ASP.NET Core MVC](stackoverflow.com/questions/tagged/asp.net-core-mvc)
  *  🌎 [ASP.NET Core 1.0](stackoverflow.com/questions/tagged/asp.net-core-1.0)
  *  🌎 [Entity Framework Core](stackoverflow.com/questions/tagged/entity-framework-core)
* [Trending .NET repositories on GitHub today](https://github.com/trending?l=csharp)

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [thangchung](http://weblogs.asp.net/thangchung) has waived all copyright and related or neighboring rights to this work.


## Source
<b><code>&nbsp;20067⭐</code></b> <b><code>&nbsp;&nbsp;2899🍴</code></b> [thangchung/awesome-dotnet-core](https://github.com/thangchung/awesome-dotnet-core))