# How to Contribute

Thank you for considering helping out!

We love to see contributions to the project and have tried to make it
easy to do so. If you would like to contribute code to this project
you can do so through GitHub by forking the repository and sending a
pull request.

## Pull Requests
-------------

* should be from a forked project with an appropriate branch name
* should be narrowly focused with no more than 3 or 4 logical commits
* when possible, address no more than one issue
* should be reviewable in the GitHub code review tool
* should be linked to any issues it relates to (ie issue number after
(#) in commit messages or pull request message)

Expect a thorough review process for any pull requests that add functionality
or change the behavior of the application. We encourage you to sketch your
approach in writing on a relevant issue (or creating such an issue if needed)
before starting to code, in order to save time and frustration all around. 

## Commit messages
---------------

Please follow the advice of the
[Phonegap team](https://github.com/phonegap/phonegap/wiki/Git-Commit-Message-Format)
when crafting commit messages. The advice basically comes down to:

* First line should be maximum 50 characters long
* It should summarise the change and use imperative present tense
* The rest of the commit message should come after a blank line
* We encourage you to use Markdown syntax in the rest of the commit
message
* Preferably keep to an 72 character limit on lines in the rest of the
message.

If a commit is related to a particular issue, put the issue number
after a hash (#) somewhere in the detail. You can put the issue number
in the first line summary, but only if you can also fit in a useful
summary of what was changed in the commit.

## Contributor License Agreement

Before Comcast merges your code into the project you must sign the [Comcast Contributor License Agreement (CLA)](https://gist.github.com/ComcastOSS/a7b8933dd8e368535378cda25c92d19a).

If you haven't previously signed a Comcast CLA, you'll automatically be asked to when you open a pull request. Alternatively, we can e-mail you a PDF that you can sign and scan back to us. Please send us an e-mail or create a new GitHub issue to request a PDF version of the CLA.


