// @ts-check
/// <reference path="./ApiHook.d.ts"/>
/// <reference path="./const.js" />
/// <reference path="./API.d.ts"/>

'use strict';

var WSAStartup = new ApiHook();
/*
int WSAStartup(
  WORD      wVersionRequired,
  LPWSADATA lpWSAData
);
*/
WSAStartup.OnCallBack = function (Emu, API, ret) {

	Emu.pop(); // pop return address ..

	var wVersionRequired = Emu.isx64 ? Emu.ReadReg(REG_RCX) : Emu.pop();
	var lpWSAData		 = Emu.isx64 ? Emu.ReadReg(REG_EDX) : Emu.pop();

	print('WSAStartup(0x{0},0x{1})'.format(
		wVersionRequired.toString(16),
		lpWSAData.toString(16)
	));


	var version = [0x02 ,0x02 ,0x02 ,0x02 ,0x57 ,0x69 ,0x6E ,0x53 ,0x6F ,0x63 ,0x6B ,0x20 ,0x32 ,0x2E ,0x30 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x52 ,0x75 ,0x6E ,0x6E ,0x69 ,0x6E ,0x67 ,0x00]

	Emu.WriteMem(lpWSAData,version);

	Emu.SetReg(Emu.isx64 ? REG_RAX : REG_EAX, 0); // just for now :P .
	Emu.SetReg(Emu.isx64 ? REG_RIP : REG_EIP, ret);
	return true; // we handled the Stack and other things :D .
};

WSAStartup.install('ws2_32.dll', 'WSAStartup');


/*
###################################################################################################
###################################################################################################
*/

var gethostbyname = new ApiHook();
/*
hostent gethostbyname(
	LPSTR lphostname
);
*/
gethostbyname.OnCallBack = function (Emu, API, ret) {

	Emu.pop(); // pop return address ..

	var lphostname = Emu.isx64 ? Emu.ReadReg(REG_RCX) : Emu.pop();
	var Host = Emu.ReadStringA(lphostname);

	print("gethostbyname('{0}')".format(
		Host
	));
	var addr = (0x40000000 + 0x72000);

/*
00000000 hostent         struc ; (sizeof=0x10, align=0x4)
00000000 h_name          dd ?   ; offset
00000004 h_aliases       dd ?   ; offset
00000008 h_addrtype      dw ?
0000000A h_length        dw ?
0000000C h_addr_list     dd ?   ; offset
00000010 hostent         ends
*/
	
	Emu.WriteDword(addr   , lphostname); // Pointer to h_name
	Emu.WriteDword(addr+4 , addr+16);    // Pointer to h_aliases
	Emu.WriteWord (addr+8 , 2); 		 // h_addrtype
	Emu.WriteWord (addr+10, 4); 		 // h_length
	Emu.WriteDword(addr+12, addr+20);    // h_addr_list
	Emu.WriteDword(addr+20, addr+28);
	Emu.WriteDword(addr+28, 0x100007F);


	Emu.SetReg(Emu.isx64 ? REG_RAX : REG_EAX, addr); // just for now :P .
	Emu.SetReg(Emu.isx64 ? REG_RIP : REG_EIP, ret);
	return true; // we handled the Stack and other things :D .
};

gethostbyname.install('ws2_32.dll', 'gethostbyname');
/*
###################################################################################################
###################################################################################################
*/

var htons = new ApiHook();
/*
u_short htons(
  u_short hostshort
);
*/
htons.OnCallBack = function (Emu, API, ret) {

	// just let the lib handle converting the value . 

	var hostshort = Emu.isx64 ? Emu.ReadReg(REG_RCX) : Emu.ReadDword(Emu.ReadReg(REG_ESP) + (4 * 1));

	info("htons(0x{0})".format(
		hostshort.toString(16)
	));

	return true; 
};
htons.OnExit = function (Emu,API) {

	warn("htons = (0x{0})".format(
		Emu.ReadReg(REG_EAX).toString(16)
	));
}
htons.install('ws2_32.dll', 'htons');

/*
###################################################################################################
###################################################################################################
*/


