# Unsafe expect

### What it does

Checks for usage of `.expect()`

### Why is this bad?

`.expect()` might panic if the result value is an error or `None`.

### Example

```rust
// example code where a warning is issued
fn main() {
    let result = result_fn().expect("error");
}
fn result_fn() -> Result<u8, Error> {
    Err(Error::new(ErrorKind::Other, "error"))
}
```

Use instead:

```rust
// example code that does not raise a warning
fn main() {
   let result = if let Ok(result) = result_fn() {
      result
  }
}
fn result_fn() -> Result<u8, Error> {
    Err(Error::new(ErrorKind::Other, "error"))
}
```

### Implementation

The detector's implementation can be found at [this link](https://github.com/CoinFabrik/scout-soroban/tree/main/detectors/unsafe-expect).
