#ifndef GENCODECS_H
#define GENCODECS_H

/* Allow symbols usage without GENCODECS_ prefix */
#ifndef GENCODECS_USE_PREFIX
#   define PP_INCLUDE GENCODECS_PP_INCLUDE
#   define PP_DEFINE GENCODECS_PP_DEFINE
#   define PP GENCODECS_PP

#   define COND_WRITE GENCODECS_COND_WRITE
#   define COND_END GENCODECS_COND_END

#   define PUB_STRUCT GENCODECS_PUB_STRUCT
#   define STRUCT GENCODECS_STRUCT
#   define FIELD_CUSTOM GENCODECS_FIELD_CUSTOM
#   define FIELD_PRINTF GENCODECS_FIELD_PRINTF
#   define FIELD GENCODECS_FIELD
#   define FIELD_STRUCT_PTR GENCODECS_FIELD_STRUCT_PTR
#   define FIELD_PTR GENCODECS_FIELD_PTR
#   define FIELD_ENUM GENCODECS_FIELD_ENUM
#   define STRUCT_END GENCODECS_STRUCT_END

#   define PUB_LIST GENCODECS_PUB_LIST
#   define LIST GENCODECS_LIST
#   define LISTTYPE GENCODECS_LISTTYPE
#   define LISTTYPE_STRUCT GENCODECS_LISTTYPE_STRUCT
#   define LISTTYPE_PTR GENCODECS_LISTTYPE_PTR
#   define LIST_END GENCODECS_LIST_END

#   define ENUM GENCODECS_ENUM
#   define ENUM_END GENCODECS_ENUM_END
#   define ENUMERATOR GENCODECS_ENUMERATOR
#   define ENUMERATOR_LAST GENCODECS_ENUMERATOR_LAST
#   define ENUMERATOR_END GENCODECS_ENUMERATOR_END
#endif /* GENCODECS_USE_PREFIX */

#ifndef GENCODECS_HEADER
#   ifdef GENCODECS_DATA
GENCODECS_PP_INCLUDE(<stdio.h>)
GENCODECS_PP_INCLUDE(<stdlib.h>)
GENCODECS_PP_INCLUDE(<string.h>)
#       ifdef GENCODECS_INIT
GENCODECS_PP_INCLUDE("carray.h")
#       endif
#       if defined(GENCODECS_JSON_DECODER) && defined(GENCODECS_FORWARD)
static char *
_gc_strndup(const char *src, size_t len)
{
    char *dest = malloc(len + 1);
    memcpy(dest, src, len);
    dest[len] = '\0';
    return dest;
}
#       endif /* GENCODECS_JSON_DECODER && GENCODECS_FORWARD */
#   endif /* GENCODECS_DATA */
#else
GENCODECS_PP_INCLUDE(<stddef.h>)
GENCODECS_PP_INCLUDE(<stdbool.h>)
#       ifdef GENCODECS_JSON_DECODER
GENCODECS_PP_DEFINE(JSMN_STRICT)
GENCODECS_PP_DEFINE(JSMN_HEADER)
GENCODECS_PP_INCLUDE("jsmn.h")
GENCODECS_PP_INCLUDE("jsmn-find.h")
#       endif
#       ifdef GENCODECS_JSON_ENCODER
GENCODECS_PP_DEFINE(JSONB_HEADER)
GENCODECS_PP_INCLUDE("json-build.h")
#       endif
#endif /* GENCODECS_HEADER */

#define GENCODECS_PP(_description)
#define GENCODECS_PP_DEFINE(_description)

#endif /* GENCODECS_H */
