<a name="readme-top"></a>

<div align="center">
  <br/>

  <h1><b>Drum_Machine</b></h1>

</div>

# 📗 Table of Contents

- [📗 Table of Contents](#-table-of-contents)
- [📖 Drum\_Machine](#-drum_machine)
  - [🛠 Built With ](#-built-with-)
    - [Tech Stack ](#tech-stack-)
    - [Key Features ](#key-features-)
  - [🚀 Live Demo ](#-live-demo-)
  - [💻 Getting Started ](#-getting-started-)
    - [Project Structure](#project-structure)
    - [Setup](#setup)
    - [Install](#install)
    - [Usage](#usage)
    - [Run tests](#run-tests)
  - [👥 Authors ](#-authors-)
  - [🔭 Future Features ](#-future-features-)
  - [🤝 Contributing ](#-contributing-)
  - [⭐️ Show your support ](#️-show-your-support-)
  - [🙏 Acknowledgments ](#-acknowledgments-)
  - [📝 License ](#-license-)

# 📖 Drum_Machine<a name="about-project"></a>

>The Drum Machine App is an interactive application that simulates a drum machine. Designed with an intuitive and friendly user interface, this application allows users to play different percussion sounds through on-screen keys or through their computer keyboard.
## 🛠 Built With <a name="built-with"></a>

### Tech Stack <a name="tech-stack"></a>

<details>
  <summary>React-redux</summary>
    <ul>
      <li>This project use <a href="https://react-redux.js.org/">React</a></li>
    </ul>
</details>

<details>
  <summary>HTML</summary>
  <ul>
    <li>This project use <a href="https://github.com/microverseinc/curriculum-html-css/blob/main/html5.md">HTML.</a></li>
  </ul>
</details>

<details>
  <summary>CSS</summary>
  <ul>
    <li>The <a href="https://github.com/microverseinc/curriculum-html-css/blob/main/html5.md">CSS</a> is used to provide the design in the whole page.</li>
  </ul>
</details>

<details>
  <summary>Linters</summary>
  <ul>
    <li>The <a href="https://github.com/microverseinc/linters-config">Linters</a> are tools that help us to check and solve the errors in the code</li>
    This project count with two linters: 
    <ul>
      <li>CSS</li>
      <li>JavaScript</li>
    </ul>
  </ul>
</details>


### Key Features <a name="key-features"></a>

- **SPA**
- **CRA**
- **Styles**
- **Toolkit**
- **React-Redux**
- **Deployment**

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## 🚀 Live Demo <a name="live-demo"></a>

> You can see a Demo [here](https://drum-machine-jwl9.onrender.com).

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## 💻 Getting Started <a name="getting-started"></a>

> To get a local copy up and running, follow these steps.
> This project requires Node.js and npm installed on your machine.

> -Node.js
> -npm

> -Clone this repository to your local machine using:

>  git clone https://github.com/ClaudiaRojasSoto/Drum_Machine.git

> -Navigate to the project folder:

> cd math_magicians

> -Install the project dependencies:

> npm install

> To start the development server, run the following command:

> npm start

### Project Structure

> The project follows the following folder and file structure:

- `/src`: Contains the source files of the application.
- `/src/index.js`: Main entry point of the JavaScript application.
- `/src/App.js`: Top-level component of the application where components are rendered.
- `/src/components`: Directory for React components.
- `/src/components/Display.js`: Component for the Display
- `/src/components/DrumMachine.js`: Folder for the DrumMachine.
- `/src/components/DrumPad.js`: Folder for the Drumpad.
- `/src/redux`: Directory for Redux management.
- `/src/redux/store.js`: Redux store configuration.
- `/src/redux/actions`: Folder for Redux actions.
- `/src/redux/DrumMachineActions`: Folder for DrumMachine actions management.
- `/src/redux/reducers`: Folder for Redux reducers.
- `/src/redux/reducers/DrumMachineReducer.js`: Reducer for DrumMachine reducer management.
- `/public`: Contains the public files and assets of the application.
- `/public/index.html`: Base HTML file of the application.
- `/build`: Contains the generated production files.

### Setup

> Clone this repository to your desired folder: https://github.com/ClaudiaRojasSoto/Drum_Machine.git

### Install

> Install this project with: install Stylelint and ESLint

### Usage

> To run the project, execute the following command: just need a web Browser

### Run tests

> To run tests, run the following command: npm start
> you just need a simple web browser to run this project for a test

## 👥 Authors <a name="authors"></a>

👤 **Claudia Rojas**

-   GitHub: [@githubhandle](https://github.com/ClaudiaRojasSoto)
-   LinkedIn: [LinkedIn](inkedin.com/in/claudia-rojas-soto)
-   AngelList: [AngelList](https://wellfound.com/u/claudia-rojas-2)


<p align="right">(<a href="#readme-top">back to top</a>)</p>

## 🔭 Future Features <a name="future-features"></a>

-   **User keys - login**

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## 🤝 Contributing <a name="contributing"></a>

> Contributions, issues, and feature requests are welcome!

> Feel free to check the [issues page](https://github.com/ClaudiaRojasSoto/Drum_Machine/issues).

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## ⭐️ Show your support <a name="support"></a>

> If you like this project show support by following this account

<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- ACKNOWLEDGEMENTS -->

## 🙏 Acknowledgments <a name="acknowledgements"></a>

> -   Microverse for providing the opportunity to learn Git and GitHub in a collaborative environment.

> -   GitHub Docs for providing a wealth of information on Git and GitHub.

<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- LICENSE -->

## 📝 License <a name="license"></a>

> This project is [MIT](MIT.md).

<p align="right">(<a href="#readme-top">back to top</a>)</p>
