## 1. 参数：

### 1.1 转写参数：

#### 1.1.1参数：

- `audio`: 输入文件的路径(或类似文件的对象)，或音频波形。

- `language`: 音频中的语言。应该是一个语言代码，如“en”或“fr”。如果未设置，则在音频的前30秒内检测语言。

- `task`: 要执行的任务(转录或翻译)。

- `beam_size`: 用于解码的beam大小。

- `best_of`: 采样时使用非零温度的候选数。

- `patience`: Beam搜索耐心因子。

- `length_penalty`: 指数长度惩罚常数。

- `temperature`: 采样的温度。它可以是温度元组，如果根据“`compression_ratio_threshold`”或“`log_prob_threshold`”失败，则会依次使用。

- `compression_ratio_threshold`: 如果gzip压缩比高于此值，则视为失败。

- `log_prob_threshold`: 如果对采样标记的平均对数概率低于此值，则视为失败。

- `no_speech_threshold`: 如果无话音概率高于此值，并且对采样标记的平均对数概率低于“`log_prob_threshold`”，则将该段视为静音。

- `condition_on_previous_text`: 如果为 `True`，则将模型的前一个输出作为下一个窗口的提示提供;禁用可能会导致文本在窗口之间不一致，但模型不太容易陷入失败循环，比如重复循环或时间戳失去同步。

- `initial_prompt`: 为第一个窗口提供的可选文本字符串或词元id可迭代项。

- `prefix`: 为第一个窗口提供的可选文本前缀。

- `suppress_blank`: 在采样开始时抑制空白输出。

- `suppress_tokens`: 要抑制的标记ID列表。 -1 将抑制配置文件 `config.json`中定义的默认符号集。

- `without_timestamps`: 仅对文本标记进行采样。

- `max_initial_timestamp`: 初始时间戳不能晚于此时间。

- `word_timestamps`: 使用交叉注意力模式和动态时间规整提取单词级时间戳，并在每个段的每个单词中包含时间戳。

- `prepend_punctuations`: 如果 `word_timestamps`为 `True`，则将这些标点符号与下一个单词合并。

- `append_punctuations`: 如果 `word_timestamps`为 `True`，则将这些标点符号与前一个单词合并。

- `vad_filter`: 启用语音活动检测(VAD)以过滤掉没有语音的音频部分。 此步骤使用 `Silero VAD` 模型 https://github.com/snakers4/silero-vad。

- `vad_parameters`: `Silero VAD` 参数的字典或 `VadOptions` 类(请参阅类“*Vad Options*”中的可用参数和默认值)。

- `max_new_tokens`: 每个区块生成的新令牌的最大数量。如果未设置，最大值将通过默认的 `max_size` 设置。

- `chunk_length`: 音频段的长度。如果不是 `None`，它将覆盖 `FeatureExtractor `的默认`chunk_size`。 

- `clip_timestamps`: 逗号分隔的要处理的剪辑的时间戳列表（以秒为单位）`开始,结束,开始,结束......`。最后一个结束时间戳默认为文件的结束。如果使用 `clip_timestamps`，将忽略 `VAD` 设置。

- `hallucination_silence_threshold`: 当 `word_timestamps `为 `True` 时，当检测到可能的幻觉时，跳过长于此阈值（以秒为单位）的静默期。

- `hotwords`: 为模型提供的热词/提示短语。如果 `prefix` 不是 `None`，则无效。  

- `language_detection_threshold`: 如果语言标记的最大概率高于此值，则会检测为该语言。

- `language_detection_segments`: 语言检测需要考虑的分段数量。

    

#### 1.1.2 方法返回值:

- 一个元组，包含:

    - \- 转录段的生成器
    - \- `TranscriptionInfo` 的一个实例

### 1.2 VAD 参数

#### 1.2.1 VAD 选项

- `threshold`: 语音阈值。`Silero VAD` 为每个音频块输出语音概率，概率高于此值的认为是语音。最好对每个数据集单独调整此参数，但“懒散”的0.5对大多数数据集来说都非常好。
- `min_speech_duration_ms`: 短于 `min_speech_duration_ms` 的最终语音块会被抛弃。
- `max_speech_duration_s`: 语音块的最大持续时间(秒)。比 `max_speech_duration_s` 更长的块将在最后一个持续时间超过 $100ms$ 的静音时间戳拆分(如果有的话)，以防止过度切割。否则，它们将在 `max_speech_duration_s` 之前强制拆分。
- `min_silence_duration_ms`: 在每个语音块结束时等待 `min_silence_duration_ms` 再拆分它。
- `window_size_samples`: `window_size_samples` 大小的音频块被馈送到 `Silero VAD` 模型。警告！`Silero VAD` 模型使用$16000$ 采样率训练得到 $512$，$1024$，$1536$ 样本。其他值可能会影响模型性能!
- `speech_pad_ms`: 最终的语音块每边都由 `speech_pad_ms` 填充。

### 1.3 模型参数

#### 1.3.1 参数

- `model_size_or_path`: 使用的模型大小(*tiny*， *tiny.en*， *base*， *base.en*， *small*， *small.en*， *medium*， *medium.en*， *large-v1* 或 *large-v2*)，转换后的模型目录路径，或来自 *Hugging Face Hub* 的 `CTranslate2` 转换的 `Whisper` 模型 ID。当配置了大小或模型 ID 时，转换后的模型将从 *Hugging Face Hub* 下载。
- `device`: 转写设备 (`"cpu"`， `"cuda"`， `"auto"`)。
- `device_index`: 要使用的设备ID。也可以通过传递ID列表(例如[0，1，2，3])在多 `GPU` 上加载模型。在这种情况下，当从多个 `Python` 线程调用 `transcribe()` 时，可以并行运行多个转录(参见 `num_workers`)。
- `compute_type`: 计算类型。请参阅https://opennmt.net/CTranslate2/quantization.html。
- `cpu_threads`: 在 `CPU`上运行时使用的线程数(默认为4)。非零值会覆盖 `OMP_NUM_THREADS` 环境变量。
- `num_workers`: 当从多个 `Python`线程调用 `transcribe()`时，具有多个工作线程可以在运行模型时实现真正的并行性(对 `self.model.generate()` 的并发调用将并行运行)。这可以以增加内存使用为代价提高整体吞吐量。
- `download_root`: 模型应该保存的目录。如果未设置，则模型将保存在标准 *Hugging Face* 缓存目录中。
- `local_files_only`: 如果为 `True`，避免下载文件，并在本地缓存的文件存在时返回其路径。

