<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class AdminPermissionsTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {


        \DB::table('admin_permissions')->delete();

        \DB::table('admin_permissions')->insert(array(
            0 =>
                array(
                    'id' => 5,
                    'name' => '设置菜单',
                    'slug' => 'menu',
                    'http_method' => '',
                    'http_path' => 'menu*',
                    'order' => 241,
                    'parent_id' => 76,
                    'created_at' => '2020-09-18 09:45:49',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            1 =>
                array(
                    'id' => 7,
                    'name' => '设备清单按钮',
                    'slug' => 'device.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 22,
                    'parent_id' => 94,
                    'created_at' => '2020-11-19 08:57:47',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            2 =>
                array(
                    'id' => 8,
                    'name' => '设备清单删除',
                    'slug' => 'device.record.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 25,
                    'parent_id' => 7,
                    'created_at' => '2020-11-19 08:58:10',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            3 =>
                array(
                    'id' => 9,
                    'name' => '设备清单归属',
                    'slug' => 'device.record.track.create_update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 28,
                    'parent_id' => 7,
                    'created_at' => '2020-11-19 08:58:23',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            4 =>
                array(
                    'id' => 10,
                    'name' => '设备归属解除归属',
                    'slug' => 'device.track.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 46,
                    'parent_id' => 107,
                    'created_at' => '2020-11-19 08:59:02',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            5 =>
                array(
                    'id' => 13,
                    'name' => '设备清单故障',
                    'slug' => 'device.maintenance.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 29,
                    'parent_id' => 7,
                    'created_at' => '2020-11-19 09:23:03',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            6 =>
                array(
                    'id' => 14,
                    'name' => '设备',
                    'slug' => 'device',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 18,
                    'parent_id' => 0,
                    'created_at' => '2020-11-19 09:55:45',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            7 =>
                array(
                    'id' => 15,
                    'name' => '软件',
                    'slug' => 'software',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 83,
                    'parent_id' => 0,
                    'created_at' => '2020-11-19 09:59:31',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            8 =>
                array(
                    'id' => 16,
                    'name' => '配件',
                    'slug' => 'part',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 52,
                    'parent_id' => 0,
                    'created_at' => '2020-11-19 09:59:57',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            9 =>
                array(
                    'id' => 17,
                    'name' => '组织',
                    'slug' => 'organization',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 170,
                    'parent_id' => 0,
                    'created_at' => '2020-11-19 10:00:31',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            10 =>
                array(
                    'id' => 18,
                    'name' => '服务',
                    'slug' => 'service',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 142,
                    'parent_id' => 0,
                    'created_at' => '2020-11-19 10:00:55',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            11 =>
                array(
                    'id' => 20,
                    'name' => '物资故障',
                    'slug' => 'maintenance',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 12,
                    'parent_id' => 0,
                    'created_at' => '2020-11-19 10:01:59',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            12 =>
                array(
                    'id' => 21,
                    'name' => '厂商',
                    'slug' => 'vendor',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 211,
                    'parent_id' => 0,
                    'created_at' => '2020-11-19 10:03:42',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            13 =>
                array(
                    'id' => 24,
                    'name' => '软件清单按钮',
                    'slug' => 'software.record.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 87,
                    'parent_id' => 139,
                    'created_at' => '2020-11-19 10:06:25',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            14 =>
                array(
                    'id' => 25,
                    'name' => '软件清单删除',
                    'slug' => 'software.record.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 90,
                    'parent_id' => 24,
                    'created_at' => '2020-11-19 10:09:16',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            15 =>
                array(
                    'id' => 26,
                    'name' => '软件清单归属',
                    'slug' => 'software.record.track.create_update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 92,
                    'parent_id' => 24,
                    'created_at' => '2020-11-19 10:09:40',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            16 =>
                array(
                    'id' => 27,
                    'name' => '软件清单解除归属',
                    'slug' => 'software.record.track.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 93,
                    'parent_id' => 24,
                    'created_at' => '2020-11-19 10:10:02',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            17 =>
                array(
                    'id' => 28,
                    'name' => '软件清单导出履历',
                    'slug' => 'software.record.history.export',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 94,
                    'parent_id' => 24,
                    'created_at' => '2020-11-19 10:10:28',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            18 =>
                array(
                    'id' => 29,
                    'name' => '软件清单管理归属',
                    'slug' => 'software.record.track.list',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 95,
                    'parent_id' => 24,
                    'created_at' => '2020-11-19 10:11:19',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            19 =>
                array(
                    'id' => 30,
                    'name' => '配件清单按钮',
                    'slug' => 'part.record.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 56,
                    'parent_id' => 114,
                    'created_at' => '2020-11-19 10:14:24',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            20 =>
                array(
                    'id' => 31,
                    'name' => '配件清单删除',
                    'slug' => 'part.record.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 59,
                    'parent_id' => 30,
                    'created_at' => '2020-11-19 10:15:02',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            21 =>
                array(
                    'id' => 32,
                    'name' => '配件清单归属',
                    'slug' => 'part.record.track.create_update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 61,
                    'parent_id' => 30,
                    'created_at' => '2020-11-19 10:15:12',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            22 =>
                array(
                    'id' => 34,
                    'name' => '配件清单故障',
                    'slug' => 'part.maintenance.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 62,
                    'parent_id' => 30,
                    'created_at' => '2020-11-19 10:15:44',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            23 =>
                array(
                    'id' => 35,
                    'name' => '配件归属解除归属',
                    'slug' => 'part.track.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 77,
                    'parent_id' => 133,
                    'created_at' => '2020-11-19 10:16:04',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            24 =>
                array(
                    'id' => 37,
                    'name' => '用户删除',
                    'slug' => 'user.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 177,
                    'parent_id' => 210,
                    'created_at' => '2020-11-19 10:18:57',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            25 =>
                array(
                    'id' => 38,
                    'name' => '服务清单按钮',
                    'slug' => 'service.record.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 146,
                    'parent_id' => 188,
                    'created_at' => '2020-11-19 10:19:54',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            26 =>
                array(
                    'id' => 39,
                    'name' => '服务清单删除',
                    'slug' => 'service.record.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 149,
                    'parent_id' => 38,
                    'created_at' => '2020-11-19 10:20:16',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            27 =>
                array(
                    'id' => 40,
                    'name' => '服务清单归属',
                    'slug' => 'service.record.track.create_update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 150,
                    'parent_id' => 38,
                    'created_at' => '2020-11-19 10:20:26',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            28 =>
                array(
                    'id' => 41,
                    'name' => '服务清单故障',
                    'slug' => 'service.record.issue.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 151,
                    'parent_id' => 38,
                    'created_at' => '2020-11-19 10:21:32',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            29 =>
                array(
                    'id' => 42,
                    'name' => '服务归属解除归属',
                    'slug' => 'service.track.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 163,
                    'parent_id' => 200,
                    'created_at' => '2020-11-19 10:21:56',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            30 =>
                array(
                    'id' => 43,
                    'name' => '服务异常修复',
                    'slug' => 'service.issue.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 158,
                    'parent_id' => 196,
                    'created_at' => '2020-11-19 10:22:25',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            31 =>
                array(
                    'id' => 47,
                    'name' => '物资故障按钮',
                    'slug' => 'maintenance.record.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 15,
                    'parent_id' => 20,
                    'created_at' => '2020-11-19 10:31:18',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            32 =>
                array(
                    'id' => 48,
                    'name' => '物资故障修复',
                    'slug' => 'maintenance.record.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 16,
                    'parent_id' => 47,
                    'created_at' => '2020-11-19 10:31:43',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            33 =>
                array(
                    'id' => 51,
                    'name' => '设备清单只读',
                    'slug' => 'device.record.read',
                    'http_method' => 'GET',
                    'http_path' => 'device/records*',
                    'order' => 20,
                    'parent_id' => 94,
                    'created_at' => '2020-11-19 13:18:12',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            34 =>
                array(
                    'id' => 52,
                    'name' => '设备清单写入',
                    'slug' => 'device.record.write',
                    'http_method' => '',
                    'http_path' => 'device/records*',
                    'order' => 21,
                    'parent_id' => 94,
                    'created_at' => '2020-11-19 13:21:28',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            35 =>
                array(
                    'id' => 63,
                    'name' => '物资故障只读',
                    'slug' => 'maintenance.record.read',
                    'http_method' => 'GET',
                    'http_path' => 'maintenance/records*',
                    'order' => 13,
                    'parent_id' => 20,
                    'created_at' => '2020-11-19 14:01:46',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            36 =>
                array(
                    'id' => 64,
                    'name' => '物资故障写入',
                    'slug' => 'maintenance.record.write',
                    'http_method' => '',
                    'http_path' => 'maintenance/records*',
                    'order' => 14,
                    'parent_id' => 20,
                    'created_at' => '2020-11-19 14:02:10',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            37 =>
                array(
                    'id' => 65,
                    'name' => '厂商只读',
                    'slug' => 'vendor.record.read',
                    'http_method' => 'GET',
                    'http_path' => 'vendor/records*',
                    'order' => 212,
                    'parent_id' => 21,
                    'created_at' => '2020-11-19 14:03:07',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            38 =>
                array(
                    'id' => 66,
                    'name' => '厂商写入',
                    'slug' => 'vendor.record.write',
                    'http_method' => '',
                    'http_path' => 'vendor/records*',
                    'order' => 213,
                    'parent_id' => 21,
                    'created_at' => '2020-11-19 14:03:24',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            39 =>
                array(
                    'id' => 73,
                    'name' => '折旧规则',
                    'slug' => 'depreciation',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 231,
                    'parent_id' => 0,
                    'created_at' => '2020-12-19 01:16:23',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            40 =>
                array(
                    'id' => 74,
                    'name' => '折旧规则只读',
                    'slug' => 'depreciation.rule.read',
                    'http_method' => 'GET',
                    'http_path' => 'depreciation/rules*',
                    'order' => 232,
                    'parent_id' => 73,
                    'created_at' => '2020-12-19 01:17:19',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            41 =>
                array(
                    'id' => 75,
                    'name' => '折旧规则写入',
                    'slug' => 'depreciation.rule.write',
                    'http_method' => '',
                    'http_path' => 'depreciation/rules*',
                    'order' => 233,
                    'parent_id' => 73,
                    'created_at' => '2020-12-19 01:18:30',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            42 =>
                array(
                    'id' => 76,
                    'name' => '设置',
                    'slug' => 'configuration',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 239,
                    'parent_id' => 0,
                    'created_at' => '2020-12-19 01:18:30',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            43 =>
                array(
                    'id' => 77,
                    'name' => '设置LDAP',
                    'slug' => 'configuration.ldap',
                    'http_method' => '',
                    'http_path' => 'ldap*',
                    'order' => 242,
                    'parent_id' => 76,
                    'created_at' => '2020-12-19 01:18:30',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            44 =>
                array(
                    'id' => 78,
                    'name' => '设置版本信息',
                    'slug' => 'configuration.version',
                    'http_method' => '',
                    'http_path' => 'version*,action/upgrade*',
                    'order' => 243,
                    'parent_id' => 76,
                    'created_at' => '2020-12-19 01:18:30',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            45 =>
                array(
                    'id' => 79,
                    'name' => '设备清单批量删除',
                    'slug' => 'device.record.batch.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 26,
                    'parent_id' => 7,
                    'created_at' => '2020-12-28 16:24:23',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            46 =>
                array(
                    'id' => 80,
                    'name' => '软件清单批量删除',
                    'slug' => 'software.record.batch.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 91,
                    'parent_id' => 24,
                    'created_at' => '2020-12-28 16:24:50',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            47 =>
                array(
                    'id' => 81,
                    'name' => '配件清单批量删除',
                    'slug' => 'part.record.batch.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 60,
                    'parent_id' => 30,
                    'created_at' => '2020-12-28 16:25:06',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            48 =>
                array(
                    'id' => 82,
                    'name' => '用户批量删除',
                    'slug' => 'user.batch.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 178,
                    'parent_id' => 210,
                    'created_at' => '2020-12-29 23:51:57',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            49 =>
                array(
                    'id' => 83,
                    'name' => '待办',
                    'slug' => 'todo',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 3,
                    'parent_id' => 0,
                    'created_at' => '2021-02-12 11:23:17',
                    'updated_at' => '2021-03-10 18:39:02',
                ),
            50 =>
                array(
                    'id' => 84,
                    'name' => '待办只读',
                    'slug' => 'todo.record.read',
                    'http_method' => 'GET',
                    'http_path' => 'todo/records*',
                    'order' => 4,
                    'parent_id' => 83,
                    'created_at' => '2021-02-12 11:24:21',
                    'updated_at' => '2021-03-10 18:40:24',
                ),
            51 =>
                array(
                    'id' => 85,
                    'name' => '待办写入',
                    'slug' => 'todo.record.write',
                    'http_method' => '',
                    'http_path' => 'todo/records*',
                    'order' => 5,
                    'parent_id' => 83,
                    'created_at' => '2021-02-12 11:26:20',
                    'updated_at' => '2021-03-10 18:40:39',
                ),
            52 =>
                array(
                    'id' => 86,
                    'name' => '待办创建',
                    'slug' => 'todo.record.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 7,
                    'parent_id' => 88,
                    'created_at' => '2021-02-12 11:27:24',
                    'updated_at' => '2021-03-10 18:41:56',
                ),
            53 =>
                array(
                    'id' => 87,
                    'name' => '待办处理',
                    'slug' => 'todo.record.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 8,
                    'parent_id' => 88,
                    'created_at' => '2021-02-12 11:33:19',
                    'updated_at' => '2021-03-10 18:42:01',
                ),
            54 =>
                array(
                    'id' => 88,
                    'name' => '待办按钮',
                    'slug' => 'todo.record.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 6,
                    'parent_id' => 83,
                    'created_at' => '2021-02-12 11:34:57',
                    'updated_at' => '2021-03-10 18:41:49',
                ),
            55 =>
                array(
                    'id' => 89,
                    'name' => '首页',
                    'slug' => 'home',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 1,
                    'parent_id' => 0,
                    'created_at' => '2021-02-12 11:37:16',
                    'updated_at' => '2021-03-10 18:39:02',
                ),
            56 =>
                array(
                    'id' => 90,
                    'name' => '管理仪表盘',
                    'slug' => 'home.dashboard',
                    'http_method' => '',
                    'http_path' => 'dashboard*',
                    'order' => 2,
                    'parent_id' => 89,
                    'created_at' => '2021-02-12 11:38:03',
                    'updated_at' => '2022-03-10 13:29:17',
                ),
            57 =>
                array(
                    'id' => 91,
                    'name' => '设备归属归还',
                    'slug' => 'device.track.update_delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 45,
                    'parent_id' => 107,
                    'created_at' => '2021-02-20 11:17:21',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            58 =>
                array(
                    'id' => 92,
                    'name' => '设备清单导入',
                    'slug' => 'device.record.import',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 30,
                    'parent_id' => 7,
                    'created_at' => '2021-03-07 14:52:26',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            59 =>
                array(
                    'id' => 93,
                    'name' => '设备分类导入',
                    'slug' => 'device.category.import',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 40,
                    'parent_id' => 100,
                    'created_at' => '2021-03-07 14:59:12',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            60 =>
                array(
                    'id' => 94,
                    'name' => '设备清单',
                    'slug' => 'device.record',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 19,
                    'parent_id' => 14,
                    'created_at' => '2021-03-07 15:00:37',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            61 =>
                array(
                    'id' => 95,
                    'name' => '设备分类',
                    'slug' => 'device.category',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 33,
                    'parent_id' => 14,
                    'created_at' => '2021-03-07 15:00:58',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            62 =>
                array(
                    'id' => 96,
                    'name' => '设备清单创建',
                    'slug' => 'device.record.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 23,
                    'parent_id' => 7,
                    'created_at' => '2021-03-07 15:28:49',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            63 =>
                array(
                    'id' => 97,
                    'name' => '设备清单履历导出',
                    'slug' => 'device.record.history.export',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 32,
                    'parent_id' => 7,
                    'created_at' => '2021-03-07 15:29:11',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            64 =>
                array(
                    'id' => 98,
                    'name' => '设备分类只读',
                    'slug' => 'device.category.read',
                    'http_method' => 'GET',
                    'http_path' => 'device/categories*',
                    'order' => 34,
                    'parent_id' => 95,
                    'created_at' => '2021-03-07 15:33:58',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            65 =>
                array(
                    'id' => 99,
                    'name' => '设备分类写入',
                    'slug' => 'device.category.write',
                    'http_method' => '',
                    'http_path' => 'device/categories*',
                    'order' => 35,
                    'parent_id' => 95,
                    'created_at' => '2021-03-07 15:34:32',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            66 =>
                array(
                    'id' => 100,
                    'name' => '设备分类按钮',
                    'slug' => 'device.category.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 36,
                    'parent_id' => 95,
                    'created_at' => '2021-03-07 15:35:07',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            67 =>
                array(
                    'id' => 101,
                    'name' => '设备清单编辑',
                    'slug' => 'device.record.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 24,
                    'parent_id' => 7,
                    'created_at' => '2021-03-07 15:45:58',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            68 =>
                array(
                    'id' => 102,
                    'name' => '设备分类创建',
                    'slug' => 'device.category.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 37,
                    'parent_id' => 100,
                    'created_at' => '2021-03-07 15:54:36',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            69 =>
                array(
                    'id' => 103,
                    'name' => '设备分类编辑',
                    'slug' => 'device.category.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 38,
                    'parent_id' => 100,
                    'created_at' => '2021-03-07 15:54:52',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            70 =>
                array(
                    'id' => 104,
                    'name' => '设备分类删除',
                    'slug' => 'device.category.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 39,
                    'parent_id' => 100,
                    'created_at' => '2021-03-07 15:55:05',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            71 =>
                array(
                    'id' => 105,
                    'name' => '设备归属',
                    'slug' => 'device.track',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 41,
                    'parent_id' => 14,
                    'created_at' => '2021-03-07 15:55:50',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            72 =>
                array(
                    'id' => 106,
                    'name' => '设备归属只读',
                    'slug' => 'device.track.read',
                    'http_method' => 'GET',
                    'http_path' => 'device/tracks*',
                    'order' => 42,
                    'parent_id' => 105,
                    'created_at' => '2021-03-07 16:01:41',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            73 =>
                array(
                    'id' => 107,
                    'name' => '设备归属按钮',
                    'slug' => 'device.track.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 44,
                    'parent_id' => 105,
                    'created_at' => '2021-03-07 16:01:59',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            74 =>
                array(
                    'id' => 108,
                    'name' => '设备归属写入',
                    'slug' => 'device.track.write',
                    'http_method' => '',
                    'http_path' => 'device/tracks*',
                    'order' => 43,
                    'parent_id' => 105,
                    'created_at' => '2021-03-07 16:02:59',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            75 =>
                array(
                    'id' => 109,
                    'name' => '设备字段',
                    'slug' => 'device.column',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 47,
                    'parent_id' => 14,
                    'created_at' => '2021-03-07 16:48:25',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            76 =>
                array(
                    'id' => 110,
                    'name' => '设备字段只读',
                    'slug' => 'device.column.read',
                    'http_method' => 'GET',
                    'http_path' => 'device/columns*',
                    'order' => 48,
                    'parent_id' => 109,
                    'created_at' => '2021-03-07 16:48:54',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            77 =>
                array(
                    'id' => 111,
                    'name' => '设备字段按钮',
                    'slug' => 'device.column.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 49,
                    'parent_id' => 109,
                    'created_at' => '2021-03-07 16:49:15',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            78 =>
                array(
                    'id' => 112,
                    'name' => '设备字段创建',
                    'slug' => 'device.column.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 50,
                    'parent_id' => 111,
                    'created_at' => '2021-03-07 16:49:29',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            79 =>
                array(
                    'id' => 113,
                    'name' => '设备字段删除',
                    'slug' => 'device.column.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 51,
                    'parent_id' => 111,
                    'created_at' => '2021-03-07 16:49:43',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            80 =>
                array(
                    'id' => 114,
                    'name' => '配件清单',
                    'slug' => 'part.record',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 53,
                    'parent_id' => 16,
                    'created_at' => '2021-03-07 17:08:11',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            81 =>
                array(
                    'id' => 115,
                    'name' => '配件清单只读',
                    'slug' => 'part.record.read',
                    'http_method' => 'GET',
                    'http_path' => 'part/records*',
                    'order' => 54,
                    'parent_id' => 114,
                    'created_at' => '2021-03-07 17:08:35',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            82 =>
                array(
                    'id' => 116,
                    'name' => '配件清单写入',
                    'slug' => 'part.record.write',
                    'http_method' => '',
                    'http_path' => 'part/records*',
                    'order' => 55,
                    'parent_id' => 114,
                    'created_at' => '2021-03-07 17:08:57',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            83 =>
                array(
                    'id' => 117,
                    'name' => '配件清单创建',
                    'slug' => 'part.record.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 57,
                    'parent_id' => 30,
                    'created_at' => '2021-03-07 17:11:54',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            84 =>
                array(
                    'id' => 118,
                    'name' => '配件清单编辑',
                    'slug' => 'part.record.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 58,
                    'parent_id' => 30,
                    'created_at' => '2021-03-07 17:12:08',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            85 =>
                array(
                    'id' => 119,
                    'name' => '配件清单导入',
                    'slug' => 'part.record.import',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 63,
                    'parent_id' => 30,
                    'created_at' => '2021-03-08 08:31:41',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            86 =>
                array(
                    'id' => 120,
                    'name' => '配件清单导出',
                    'slug' => 'part.record.export',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 64,
                    'parent_id' => 30,
                    'created_at' => '2021-03-08 08:31:58',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            87 =>
                array(
                    'id' => 121,
                    'name' => '设备清单导出',
                    'slug' => 'device.record.export',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 31,
                    'parent_id' => 7,
                    'created_at' => '2021-03-08 08:32:49',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            88 =>
                array(
                    'id' => 122,
                    'name' => '配件分类',
                    'slug' => 'part.category',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 65,
                    'parent_id' => 16,
                    'created_at' => '2021-03-08 08:48:45',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            89 =>
                array(
                    'id' => 123,
                    'name' => '配件分类只读',
                    'slug' => 'part.category.read',
                    'http_method' => 'GET',
                    'http_path' => 'part/categories*',
                    'order' => 66,
                    'parent_id' => 122,
                    'created_at' => '2021-03-08 08:53:16',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            90 =>
                array(
                    'id' => 124,
                    'name' => '配件分类写入',
                    'slug' => 'part.category.write',
                    'http_method' => '',
                    'http_path' => 'part/categories*',
                    'order' => 67,
                    'parent_id' => 122,
                    'created_at' => '2021-03-08 08:53:36',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            91 =>
                array(
                    'id' => 125,
                    'name' => '配件分类按钮',
                    'slug' => 'part.category.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 68,
                    'parent_id' => 122,
                    'created_at' => '2021-03-08 08:53:52',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            92 =>
                array(
                    'id' => 126,
                    'name' => '配件分类创建',
                    'slug' => 'part.category.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 69,
                    'parent_id' => 125,
                    'created_at' => '2021-03-08 08:54:11',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            93 =>
                array(
                    'id' => 127,
                    'name' => '配件分类编辑',
                    'slug' => 'part.category.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 70,
                    'parent_id' => 125,
                    'created_at' => '2021-03-08 08:54:24',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            94 =>
                array(
                    'id' => 128,
                    'name' => '配件分类删除',
                    'slug' => 'part.category.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 71,
                    'parent_id' => 125,
                    'created_at' => '2021-03-08 08:54:43',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            95 =>
                array(
                    'id' => 129,
                    'name' => '配件分类导入',
                    'slug' => 'part.category.import',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 72,
                    'parent_id' => 125,
                    'created_at' => '2021-03-08 08:55:00',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            96 =>
                array(
                    'id' => 130,
                    'name' => '配件归属',
                    'slug' => 'part.track',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 73,
                    'parent_id' => 16,
                    'created_at' => '2021-03-08 09:00:58',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            97 =>
                array(
                    'id' => 131,
                    'name' => '配件归属只读',
                    'slug' => 'part.track.read',
                    'http_method' => 'GET',
                    'http_path' => 'part/tracks*',
                    'order' => 74,
                    'parent_id' => 130,
                    'created_at' => '2021-03-08 09:01:17',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            98 =>
                array(
                    'id' => 132,
                    'name' => '配件归属写入',
                    'slug' => 'part.track.write',
                    'http_method' => '',
                    'http_path' => 'part/tracks*',
                    'order' => 75,
                    'parent_id' => 130,
                    'created_at' => '2021-03-08 09:01:37',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            99 =>
                array(
                    'id' => 133,
                    'name' => '配件归属按钮',
                    'slug' => 'part.track.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 76,
                    'parent_id' => 130,
                    'created_at' => '2021-03-08 09:05:06',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            100 =>
                array(
                    'id' => 134,
                    'name' => '配件字段',
                    'slug' => 'part.column',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 78,
                    'parent_id' => 16,
                    'created_at' => '2021-03-08 09:05:41',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            101 =>
                array(
                    'id' => 135,
                    'name' => '配件字段只读',
                    'slug' => 'part.column.read',
                    'http_method' => 'GET',
                    'http_path' => 'part/columns*',
                    'order' => 79,
                    'parent_id' => 134,
                    'created_at' => '2021-03-08 09:05:59',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            102 =>
                array(
                    'id' => 136,
                    'name' => '配件字段按钮',
                    'slug' => 'part.column.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 80,
                    'parent_id' => 134,
                    'created_at' => '2021-03-08 09:06:20',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            103 =>
                array(
                    'id' => 137,
                    'name' => '配件字段创建',
                    'slug' => 'part.column.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 81,
                    'parent_id' => 136,
                    'created_at' => '2021-03-08 09:06:34',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            104 =>
                array(
                    'id' => 138,
                    'name' => '配件字段删除',
                    'slug' => 'part.column.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 82,
                    'parent_id' => 136,
                    'created_at' => '2021-03-08 09:06:50',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            105 =>
                array(
                    'id' => 139,
                    'name' => '软件清单',
                    'slug' => 'software.record',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 84,
                    'parent_id' => 15,
                    'created_at' => '2021-03-08 09:30:15',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            106 =>
                array(
                    'id' => 140,
                    'name' => '软件清单写入',
                    'slug' => 'software.record.write',
                    'http_method' => '',
                    'http_path' => 'software/records*',
                    'order' => 86,
                    'parent_id' => 139,
                    'created_at' => '2021-03-08 09:30:38',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            107 =>
                array(
                    'id' => 141,
                    'name' => '软件清单只读',
                    'slug' => 'software.record.read',
                    'http_method' => 'GET',
                    'http_path' => 'software/records*',
                    'order' => 85,
                    'parent_id' => 139,
                    'created_at' => '2021-03-08 09:31:22',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            108 =>
                array(
                    'id' => 142,
                    'name' => '软件清单创建',
                    'slug' => 'software.record.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 88,
                    'parent_id' => 24,
                    'created_at' => '2021-03-08 09:32:32',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            109 =>
                array(
                    'id' => 143,
                    'name' => '软件清单编辑',
                    'slug' => 'software.record.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 89,
                    'parent_id' => 24,
                    'created_at' => '2021-03-08 09:32:47',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            110 =>
                array(
                    'id' => 144,
                    'name' => '软件分类',
                    'slug' => 'software.category',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 96,
                    'parent_id' => 15,
                    'created_at' => '2021-03-08 09:51:29',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            111 =>
                array(
                    'id' => 145,
                    'name' => '软件分类只读',
                    'slug' => 'software.category.read',
                    'http_method' => 'GET',
                    'http_path' => 'software/categories*',
                    'order' => 97,
                    'parent_id' => 144,
                    'created_at' => '2021-03-08 09:51:55',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            112 =>
                array(
                    'id' => 146,
                    'name' => '软件分类写入',
                    'slug' => 'software.category.write',
                    'http_method' => '',
                    'http_path' => 'software/categories*',
                    'order' => 98,
                    'parent_id' => 144,
                    'created_at' => '2021-03-08 09:52:15',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            113 =>
                array(
                    'id' => 147,
                    'name' => '软件分类按钮',
                    'slug' => 'software.category.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 99,
                    'parent_id' => 144,
                    'created_at' => '2021-03-08 09:52:35',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            114 =>
                array(
                    'id' => 148,
                    'name' => '软件分类创建',
                    'slug' => 'software.category.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 100,
                    'parent_id' => 147,
                    'created_at' => '2021-03-08 09:52:53',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            115 =>
                array(
                    'id' => 149,
                    'name' => '软件分类编辑',
                    'slug' => 'software.category.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 101,
                    'parent_id' => 147,
                    'created_at' => '2021-03-08 09:53:09',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            116 =>
                array(
                    'id' => 150,
                    'name' => '软件分类删除',
                    'slug' => 'software.category.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 102,
                    'parent_id' => 147,
                    'created_at' => '2021-03-08 09:53:28',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            117 =>
                array(
                    'id' => 151,
                    'name' => '软件分类导入',
                    'slug' => 'software.category.import',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 103,
                    'parent_id' => 147,
                    'created_at' => '2021-03-08 09:53:42',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            118 =>
                array(
                    'id' => 152,
                    'name' => '软件归属',
                    'slug' => 'software.track',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 104,
                    'parent_id' => 15,
                    'created_at' => '2021-03-08 09:59:43',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            119 =>
                array(
                    'id' => 153,
                    'name' => '软件归属只读',
                    'slug' => 'software.track.read',
                    'http_method' => 'GET',
                    'http_path' => 'software/tracks*',
                    'order' => 105,
                    'parent_id' => 152,
                    'created_at' => '2021-03-08 10:00:01',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            120 =>
                array(
                    'id' => 154,
                    'name' => '软件归属写入',
                    'slug' => 'software.track.write',
                    'http_method' => '',
                    'http_path' => 'software/tracks*',
                    'order' => 106,
                    'parent_id' => 152,
                    'created_at' => '2021-03-08 10:00:21',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            121 =>
                array(
                    'id' => 155,
                    'name' => '软件归属按钮',
                    'slug' => 'software.track.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 107,
                    'parent_id' => 152,
                    'created_at' => '2021-03-08 10:00:35',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            122 =>
                array(
                    'id' => 156,
                    'name' => '软件归属解除归属',
                    'slug' => 'software.track.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 108,
                    'parent_id' => 155,
                    'created_at' => '2021-03-08 10:00:54',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            123 =>
                array(
                    'id' => 157,
                    'name' => '软件字段',
                    'slug' => 'software.column',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 109,
                    'parent_id' => 15,
                    'created_at' => '2021-03-08 10:06:02',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            124 =>
                array(
                    'id' => 158,
                    'name' => '软件字段只读',
                    'slug' => 'software.column.read',
                    'http_method' => 'GET',
                    'http_path' => 'software/columns*',
                    'order' => 110,
                    'parent_id' => 157,
                    'created_at' => '2021-03-08 10:06:26',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            125 =>
                array(
                    'id' => 159,
                    'name' => '软件字段写入',
                    'slug' => 'software.column.write',
                    'http_method' => '',
                    'http_path' => 'software/columns*',
                    'order' => 111,
                    'parent_id' => 157,
                    'created_at' => '2021-03-08 10:06:47',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            126 =>
                array(
                    'id' => 160,
                    'name' => '软件字段按钮',
                    'slug' => 'software.column.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 112,
                    'parent_id' => 157,
                    'created_at' => '2021-03-08 10:07:08',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            127 =>
                array(
                    'id' => 161,
                    'name' => '软件字段创建',
                    'slug' => 'software.column.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 113,
                    'parent_id' => 160,
                    'created_at' => '2021-03-08 10:07:26',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            128 =>
                array(
                    'id' => 162,
                    'name' => '软件字段删除',
                    'slug' => 'software.column.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 114,
                    'parent_id' => 160,
                    'created_at' => '2021-03-08 10:07:40',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            129 =>
                array(
                    'id' => 163,
                    'name' => '耗材',
                    'slug' => 'consumable',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 115,
                    'parent_id' => 0,
                    'created_at' => '2021-03-08 10:35:03',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            130 =>
                array(
                    'id' => 164,
                    'name' => '耗材清单',
                    'slug' => 'consumable.record',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 116,
                    'parent_id' => 163,
                    'created_at' => '2021-03-08 10:35:19',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            131 =>
                array(
                    'id' => 165,
                    'name' => '耗材清单只读',
                    'slug' => 'consumable.record.read',
                    'http_method' => 'GET',
                    'http_path' => 'consumable/records*',
                    'order' => 117,
                    'parent_id' => 164,
                    'created_at' => '2021-03-08 10:35:37',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            132 =>
                array(
                    'id' => 166,
                    'name' => '耗材清单写入',
                    'slug' => 'consumable.record.write',
                    'http_method' => '',
                    'http_path' => 'consumable/records*',
                    'order' => 118,
                    'parent_id' => 164,
                    'created_at' => '2021-03-08 10:35:54',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            133 =>
                array(
                    'id' => 167,
                    'name' => '耗材清单按钮',
                    'slug' => 'consumable.record.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 119,
                    'parent_id' => 164,
                    'created_at' => '2021-03-08 10:36:11',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            134 =>
                array(
                    'id' => 168,
                    'name' => '耗材清单创建',
                    'slug' => 'consumable.record.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 120,
                    'parent_id' => 167,
                    'created_at' => '2021-03-08 10:36:27',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            135 =>
                array(
                    'id' => 169,
                    'name' => '耗材清单编辑',
                    'slug' => 'consumable.record.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 121,
                    'parent_id' => 167,
                    'created_at' => '2021-03-08 10:36:46',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            136 =>
                array(
                    'id' => 170,
                    'name' => '耗材清单删除',
                    'slug' => 'consumable.record.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 122,
                    'parent_id' => 167,
                    'created_at' => '2021-03-08 10:37:01',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            137 =>
                array(
                    'id' => 171,
                    'name' => '耗材清单入库',
                    'slug' => 'consumable.record.in',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 123,
                    'parent_id' => 167,
                    'created_at' => '2021-03-08 10:37:18',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            138 =>
                array(
                    'id' => 172,
                    'name' => '耗材清单领用',
                    'slug' => 'consumable.record.out',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 124,
                    'parent_id' => 167,
                    'created_at' => '2021-03-08 10:37:40',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            139 =>
                array(
                    'id' => 173,
                    'name' => '耗材清单导出',
                    'slug' => 'consumable.record.export',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 125,
                    'parent_id' => 167,
                    'created_at' => '2021-03-08 10:38:54',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            140 =>
                array(
                    'id' => 174,
                    'name' => '耗材分类',
                    'slug' => 'consumable.category',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 128,
                    'parent_id' => 163,
                    'created_at' => '2021-03-10 08:25:58',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            141 =>
                array(
                    'id' => 175,
                    'name' => '耗材分类只读',
                    'slug' => 'consumable.category.read',
                    'http_method' => 'GET',
                    'http_path' => 'consumable/categories*',
                    'order' => 129,
                    'parent_id' => 174,
                    'created_at' => '2021-03-10 09:33:49',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            142 =>
                array(
                    'id' => 176,
                    'name' => '耗材分类写入',
                    'slug' => 'consumable.category.write',
                    'http_method' => '',
                    'http_path' => 'consumable/categories*',
                    'order' => 130,
                    'parent_id' => 174,
                    'created_at' => '2021-03-10 09:39:11',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            143 =>
                array(
                    'id' => 177,
                    'name' => '耗材分类按钮',
                    'slug' => 'consumable.category.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 131,
                    'parent_id' => 174,
                    'created_at' => '2021-03-10 09:40:37',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            144 =>
                array(
                    'id' => 178,
                    'name' => '耗材分类创建',
                    'slug' => 'consumable.category.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 132,
                    'parent_id' => 177,
                    'created_at' => '2021-03-10 09:43:45',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            145 =>
                array(
                    'id' => 179,
                    'name' => '耗材分类编辑',
                    'slug' => 'consumable.category.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 133,
                    'parent_id' => 177,
                    'created_at' => '2021-03-10 09:44:12',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            146 =>
                array(
                    'id' => 180,
                    'name' => '耗材分类删除',
                    'slug' => 'consumable.category.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 134,
                    'parent_id' => 177,
                    'created_at' => '2021-03-10 09:44:29',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            147 =>
                array(
                    'id' => 181,
                    'name' => '耗材分类导入',
                    'slug' => 'consumable.category.import',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 135,
                    'parent_id' => 177,
                    'created_at' => '2021-03-10 09:44:52',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            148 =>
                array(
                    'id' => 182,
                    'name' => '耗材字段',
                    'slug' => 'consumable.column',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 136,
                    'parent_id' => 163,
                    'created_at' => '2021-03-10 11:39:10',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            149 =>
                array(
                    'id' => 183,
                    'name' => '耗材字段只读',
                    'slug' => 'consumable.column.read',
                    'http_method' => 'GET',
                    'http_path' => 'consumable/columns*',
                    'order' => 137,
                    'parent_id' => 182,
                    'created_at' => '2021-03-10 14:25:27',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            150 =>
                array(
                    'id' => 184,
                    'name' => '耗材字段写入',
                    'slug' => 'consumable.column.write',
                    'http_method' => '',
                    'http_path' => 'consumable/columns*',
                    'order' => 138,
                    'parent_id' => 182,
                    'created_at' => '2021-03-10 14:25:58',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            151 =>
                array(
                    'id' => 185,
                    'name' => '耗材字段按钮',
                    'slug' => 'consumable.column.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 139,
                    'parent_id' => 182,
                    'created_at' => '2021-03-10 14:26:28',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            152 =>
                array(
                    'id' => 186,
                    'name' => '耗材字段创建',
                    'slug' => 'consumable.column.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 140,
                    'parent_id' => 185,
                    'created_at' => '2021-03-10 14:26:48',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            153 =>
                array(
                    'id' => 187,
                    'name' => '耗材字段删除',
                    'slug' => 'consumable.column.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 141,
                    'parent_id' => 185,
                    'created_at' => '2021-03-10 14:27:11',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            154 =>
                array(
                    'id' => 188,
                    'name' => '服务清单',
                    'slug' => 'service.record',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 143,
                    'parent_id' => 18,
                    'created_at' => '2021-03-10 16:05:01',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            155 =>
                array(
                    'id' => 189,
                    'name' => '服务清单只读',
                    'slug' => 'service.record.read',
                    'http_method' => 'GET',
                    'http_path' => 'service/records*',
                    'order' => 144,
                    'parent_id' => 188,
                    'created_at' => '2021-03-10 16:05:21',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            156 =>
                array(
                    'id' => 190,
                    'name' => '服务清单写入',
                    'slug' => 'service.record.write',
                    'http_method' => '',
                    'http_path' => 'service/records*',
                    'order' => 145,
                    'parent_id' => 188,
                    'created_at' => '2021-03-10 16:05:41',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            157 =>
                array(
                    'id' => 191,
                    'name' => '服务清单创建',
                    'slug' => 'service.record.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 147,
                    'parent_id' => 38,
                    'created_at' => '2021-03-10 16:07:23',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            158 =>
                array(
                    'id' => 192,
                    'name' => '服务清单编辑',
                    'slug' => 'service.record.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 148,
                    'parent_id' => 38,
                    'created_at' => '2021-03-10 16:07:38',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            159 =>
                array(
                    'id' => 193,
                    'name' => '服务异常',
                    'slug' => 'service.issue',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 154,
                    'parent_id' => 18,
                    'created_at' => '2021-03-10 16:37:38',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            160 =>
                array(
                    'id' => 194,
                    'name' => '服务异常只读',
                    'slug' => 'service.issue.read',
                    'http_method' => 'GET',
                    'http_path' => 'service/issues*',
                    'order' => 155,
                    'parent_id' => 193,
                    'created_at' => '2021-03-10 16:37:59',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            161 =>
                array(
                    'id' => 195,
                    'name' => '服务异常写入',
                    'slug' => 'service.issue.write',
                    'http_method' => '',
                    'http_path' => 'service/issues*',
                    'order' => 156,
                    'parent_id' => 193,
                    'created_at' => '2021-03-10 16:38:15',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            162 =>
                array(
                    'id' => 196,
                    'name' => '服务异常按钮',
                    'slug' => 'service.issue.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 157,
                    'parent_id' => 193,
                    'created_at' => '2021-03-10 16:38:31',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            163 =>
                array(
                    'id' => 197,
                    'name' => '服务归属',
                    'slug' => 'service.track',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 159,
                    'parent_id' => 18,
                    'created_at' => '2021-03-10 16:41:08',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            164 =>
                array(
                    'id' => 198,
                    'name' => '服务归属只读',
                    'slug' => 'service.track.read',
                    'http_method' => 'GET',
                    'http_path' => 'service/tracks*',
                    'order' => 160,
                    'parent_id' => 197,
                    'created_at' => '2021-03-10 16:41:37',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            165 =>
                array(
                    'id' => 199,
                    'name' => '服务归属写入',
                    'slug' => 'service.track.write',
                    'http_method' => '',
                    'http_path' => 'service/tracks*',
                    'order' => 161,
                    'parent_id' => 197,
                    'created_at' => '2021-03-10 16:42:00',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            166 =>
                array(
                    'id' => 200,
                    'name' => '服务归属按钮',
                    'slug' => 'service.track.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 162,
                    'parent_id' => 197,
                    'created_at' => '2021-03-10 16:42:12',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            167 =>
                array(
                    'id' => 201,
                    'name' => '服务字段',
                    'slug' => 'service.column',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 164,
                    'parent_id' => 18,
                    'created_at' => '2021-03-10 16:43:57',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            168 =>
                array(
                    'id' => 202,
                    'name' => '服务字段只读',
                    'slug' => 'service.column.read',
                    'http_method' => 'GET',
                    'http_path' => 'service/columns*',
                    'order' => 165,
                    'parent_id' => 201,
                    'created_at' => '2021-03-10 16:44:13',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            169 =>
                array(
                    'id' => 203,
                    'name' => '服务字段写入',
                    'slug' => 'service.column.write',
                    'http_method' => '',
                    'http_path' => 'service/columns*',
                    'order' => 166,
                    'parent_id' => 201,
                    'created_at' => '2021-03-10 16:44:34',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            170 =>
                array(
                    'id' => 204,
                    'name' => '服务字段按钮',
                    'slug' => 'service.column.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 167,
                    'parent_id' => 201,
                    'created_at' => '2021-03-10 16:44:50',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            171 =>
                array(
                    'id' => 205,
                    'name' => '服务字段创建',
                    'slug' => 'service.column.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 168,
                    'parent_id' => 204,
                    'created_at' => '2021-03-10 16:45:07',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            172 =>
                array(
                    'id' => 206,
                    'name' => '服务字段删除',
                    'slug' => 'service.column.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 169,
                    'parent_id' => 204,
                    'created_at' => '2021-03-10 16:45:26',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            173 =>
                array(
                    'id' => 207,
                    'name' => '用户',
                    'slug' => 'user',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 171,
                    'parent_id' => 17,
                    'created_at' => '2021-03-10 16:58:00',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            174 =>
                array(
                    'id' => 208,
                    'name' => '用户只读',
                    'slug' => 'user.read',
                    'http_method' => 'GET',
                    'http_path' => 'organization/users*',
                    'order' => 172,
                    'parent_id' => 207,
                    'created_at' => '2021-03-10 16:58:15',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            175 =>
                array(
                    'id' => 209,
                    'name' => '用户写入',
                    'slug' => 'user.write',
                    'http_method' => '',
                    'http_path' => 'organization/users*',
                    'order' => 173,
                    'parent_id' => 207,
                    'created_at' => '2021-03-10 16:58:32',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            176 =>
                array(
                    'id' => 210,
                    'name' => '用户按钮',
                    'slug' => 'user.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 174,
                    'parent_id' => 207,
                    'created_at' => '2021-03-10 16:58:51',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            177 =>
                array(
                    'id' => 211,
                    'name' => '用户创建',
                    'slug' => 'user.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 175,
                    'parent_id' => 210,
                    'created_at' => '2021-03-10 16:59:36',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            178 =>
                array(
                    'id' => 212,
                    'name' => '用户编辑',
                    'slug' => 'user.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 176,
                    'parent_id' => 210,
                    'created_at' => '2021-03-10 16:59:47',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            179 =>
                array(
                    'id' => 213,
                    'name' => '用户导入',
                    'slug' => 'user.import',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 179,
                    'parent_id' => 210,
                    'created_at' => '2021-03-10 16:59:54',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            180 =>
                array(
                    'id' => 214,
                    'name' => '部门',
                    'slug' => 'department',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 180,
                    'parent_id' => 17,
                    'created_at' => '2021-03-10 17:00:16',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            181 =>
                array(
                    'id' => 215,
                    'name' => '部门只读',
                    'slug' => 'department.read',
                    'http_method' => 'GET',
                    'http_path' => 'organization/departments*',
                    'order' => 181,
                    'parent_id' => 214,
                    'created_at' => '2021-03-10 17:00:34',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            182 =>
                array(
                    'id' => 216,
                    'name' => '部门写入',
                    'slug' => 'department.write',
                    'http_method' => '',
                    'http_path' => 'organization/departments*',
                    'order' => 182,
                    'parent_id' => 214,
                    'created_at' => '2021-03-10 17:00:48',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            183 =>
                array(
                    'id' => 217,
                    'name' => '部门按钮',
                    'slug' => 'department.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 183,
                    'parent_id' => 214,
                    'created_at' => '2021-03-10 17:01:00',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            184 =>
                array(
                    'id' => 218,
                    'name' => '部门创建',
                    'slug' => 'department.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 184,
                    'parent_id' => 217,
                    'created_at' => '2021-03-10 17:06:59',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            185 =>
                array(
                    'id' => 219,
                    'name' => '部门编辑',
                    'slug' => 'department.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 185,
                    'parent_id' => 217,
                    'created_at' => '2021-03-10 17:07:10',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            186 =>
                array(
                    'id' => 220,
                    'name' => '部门删除',
                    'slug' => 'department.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 186,
                    'parent_id' => 217,
                    'created_at' => '2021-03-10 17:07:22',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            187 =>
                array(
                    'id' => 221,
                    'name' => '部门导入',
                    'slug' => 'department.import',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 187,
                    'parent_id' => 217,
                    'created_at' => '2021-03-10 17:07:32',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            188 =>
                array(
                    'id' => 222,
                    'name' => '角色',
                    'slug' => 'role',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 188,
                    'parent_id' => 17,
                    'created_at' => '2021-03-10 17:08:06',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            189 =>
                array(
                    'id' => 223,
                    'name' => '角色只读',
                    'slug' => 'role.read',
                    'http_method' => 'GET',
                    'http_path' => 'organization/roles*',
                    'order' => 189,
                    'parent_id' => 222,
                    'created_at' => '2021-03-10 17:08:22',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            190 =>
                array(
                    'id' => 224,
                    'name' => '角色写入',
                    'slug' => 'role.write',
                    'http_method' => '',
                    'http_path' => 'organization/roles*',
                    'order' => 190,
                    'parent_id' => 222,
                    'created_at' => '2021-03-10 17:08:35',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            191 =>
                array(
                    'id' => 225,
                    'name' => '角色按钮',
                    'slug' => 'role.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 191,
                    'parent_id' => 222,
                    'created_at' => '2021-03-10 17:08:46',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            192 =>
                array(
                    'id' => 226,
                    'name' => '角色创建',
                    'slug' => 'role.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 192,
                    'parent_id' => 225,
                    'created_at' => '2021-03-10 17:15:01',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            193 =>
                array(
                    'id' => 227,
                    'name' => '角色编辑',
                    'slug' => 'role.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 193,
                    'parent_id' => 225,
                    'created_at' => '2021-03-10 17:15:10',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            194 =>
                array(
                    'id' => 228,
                    'name' => '角色删除',
                    'slug' => 'role.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 194,
                    'parent_id' => 225,
                    'created_at' => '2021-03-10 17:15:22',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            195 =>
                array(
                    'id' => 229,
                    'name' => '权限',
                    'slug' => 'permission',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 195,
                    'parent_id' => 17,
                    'created_at' => '2021-03-10 18:25:55',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            196 =>
                array(
                    'id' => 230,
                    'name' => '权限只读',
                    'slug' => 'permission.read',
                    'http_method' => 'GET',
                    'http_path' => 'organization/permissions*',
                    'order' => 196,
                    'parent_id' => 229,
                    'created_at' => '2021-03-10 18:26:26',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            197 =>
                array(
                    'id' => 231,
                    'name' => '权限写入',
                    'slug' => 'permission.write',
                    'http_method' => '',
                    'http_path' => 'organization/permissions*',
                    'order' => 197,
                    'parent_id' => 229,
                    'created_at' => '2021-03-10 18:26:52',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            198 =>
                array(
                    'id' => 232,
                    'name' => '权限按钮',
                    'slug' => 'permission.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 198,
                    'parent_id' => 229,
                    'created_at' => '2021-03-10 18:27:09',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            199 =>
                array(
                    'id' => 233,
                    'name' => '权限创建',
                    'slug' => 'permission.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 199,
                    'parent_id' => 232,
                    'created_at' => '2021-03-10 18:37:57',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            200 =>
                array(
                    'id' => 234,
                    'name' => '权限编辑',
                    'slug' => 'permission.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 200,
                    'parent_id' => 232,
                    'created_at' => '2021-03-10 18:38:09',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            201 =>
                array(
                    'id' => 235,
                    'name' => '权限删除',
                    'slug' => 'permission.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 201,
                    'parent_id' => 232,
                    'created_at' => '2021-03-10 18:38:20',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            202 =>
                array(
                    'id' => 236,
                    'name' => '待办删除',
                    'slug' => 'todo.record.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 9,
                    'parent_id' => 88,
                    'created_at' => '2021-03-10 18:42:37',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            203 =>
                array(
                    'id' => 237,
                    'name' => '待办批量删除',
                    'slug' => 'todo.record.batch.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 10,
                    'parent_id' => 88,
                    'created_at' => '2021-03-10 18:53:15',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            204 =>
                array(
                    'id' => 238,
                    'name' => '待办导出',
                    'slug' => 'todo.record.export',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 11,
                    'parent_id' => 88,
                    'created_at' => '2021-03-10 18:53:28',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            205 =>
                array(
                    'id' => 239,
                    'name' => '物资故障导出',
                    'slug' => 'maintenance.record.export',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 17,
                    'parent_id' => 47,
                    'created_at' => '2021-03-10 18:55:57',
                    'updated_at' => '2021-03-10 19:00:54',
                ),
            206 =>
                array(
                    'id' => 240,
                    'name' => '厂商按钮',
                    'slug' => 'vendor.record.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 214,
                    'parent_id' => 21,
                    'created_at' => '2021-03-10 19:02:05',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            207 =>
                array(
                    'id' => 241,
                    'name' => '厂商创建',
                    'slug' => 'vendor.record.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 215,
                    'parent_id' => 240,
                    'created_at' => '2021-03-10 19:02:19',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            208 =>
                array(
                    'id' => 242,
                    'name' => '厂商编辑',
                    'slug' => 'vendor.record.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 216,
                    'parent_id' => 240,
                    'created_at' => '2021-03-10 19:02:35',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            209 =>
                array(
                    'id' => 243,
                    'name' => '厂商删除',
                    'slug' => 'vendor.record.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 217,
                    'parent_id' => 240,
                    'created_at' => '2021-03-10 19:02:49',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            210 =>
                array(
                    'id' => 244,
                    'name' => '厂商导入',
                    'slug' => 'vendor.record.import',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 218,
                    'parent_id' => 240,
                    'created_at' => '2021-03-10 19:03:06',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            211 =>
                array(
                    'id' => 245,
                    'name' => '厂商导出',
                    'slug' => 'vendor.record.export',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 219,
                    'parent_id' => 240,
                    'created_at' => '2021-03-10 19:03:16',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            212 =>
                array(
                    'id' => 246,
                    'name' => '厂商批量删除',
                    'slug' => 'vendor.record.batch.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 220,
                    'parent_id' => 240,
                    'created_at' => '2021-03-10 19:03:31',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            213 =>
                array(
                    'id' => 254,
                    'name' => '折旧规则按钮',
                    'slug' => 'depreciation.rule.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 234,
                    'parent_id' => 73,
                    'created_at' => '2021-03-10 19:08:56',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            214 =>
                array(
                    'id' => 255,
                    'name' => '折旧规则创建',
                    'slug' => 'depreciation.rule.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 235,
                    'parent_id' => 254,
                    'created_at' => '2021-03-10 19:09:08',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            215 =>
                array(
                    'id' => 256,
                    'name' => '折旧规则编辑',
                    'slug' => 'depreciation.rule.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 236,
                    'parent_id' => 254,
                    'created_at' => '2021-03-10 19:09:22',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            216 =>
                array(
                    'id' => 257,
                    'name' => '折旧规则删除',
                    'slug' => 'depreciation.rule.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 237,
                    'parent_id' => 254,
                    'created_at' => '2021-03-10 19:09:35',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            217 =>
                array(
                    'id' => 258,
                    'name' => '折旧规则批量删除',
                    'slug' => 'depreciation.rule.batch.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 238,
                    'parent_id' => 254,
                    'created_at' => '2021-03-10 19:09:53',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            218 =>
                array(
                    'id' => 259,
                    'name' => '设置站点',
                    'slug' => 'configuration.dcat-plus',
                    'http_method' => '',
                    'http_path' => 'dcat-plus/site*,dcat-plus/ui*,dcat-plus/field*',
                    'order' => 240,
                    'parent_id' => 76,
                    'created_at' => '2021-03-10 19:24:40',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            219 =>
                array(
                    'id' => 260,
                    'name' => '设备清单批量强制删除',
                    'slug' => 'device.record.batch.force.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 27,
                    'parent_id' => 7,
                    'created_at' => '2021-04-23 10:06:11',
                    'updated_at' => '2021-04-23 10:06:21',
                ),
            220 =>
                array(
                    'id' => 261,
                    'name' => '耗材清单批量删除',
                    'slug' => 'consumable.record.batch.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 126,
                    'parent_id' => 167,
                    'created_at' => '2021-04-23 10:09:11',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            221 =>
                array(
                    'id' => 262,
                    'name' => '耗材清单批量强制删除',
                    'slug' => 'consumable.record.batch.force.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 127,
                    'parent_id' => 167,
                    'created_at' => '2021-04-23 10:09:30',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            222 =>
                array(
                    'id' => 263,
                    'name' => '服务清单批量删除',
                    'slug' => 'service.record.batch.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 152,
                    'parent_id' => 38,
                    'created_at' => '2021-04-23 10:14:07',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            223 =>
                array(
                    'id' => 264,
                    'name' => '服务清单批量强制删除',
                    'slug' => 'service.record.batch.force.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 153,
                    'parent_id' => 38,
                    'created_at' => '2021-04-23 10:14:28',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            224 =>
                array(
                    'id' => 265,
                    'name' => '盘点',
                    'slug' => 'check',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 202,
                    'parent_id' => 0,
                    'created_at' => '2021-05-08 14:32:41',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            225 =>
                array(
                    'id' => 266,
                    'name' => '盘点任务',
                    'slug' => 'check.record',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 203,
                    'parent_id' => 265,
                    'created_at' => '2021-05-08 14:33:16',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            226 =>
                array(
                    'id' => 267,
                    'name' => '盘点任务只读',
                    'slug' => 'check.record.read',
                    'http_method' => 'GET',
                    'http_path' => 'check/records*',
                    'order' => 204,
                    'parent_id' => 266,
                    'created_at' => '2021-05-08 14:33:47',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            227 =>
                array(
                    'id' => 268,
                    'name' => '盘点任务写入',
                    'slug' => 'check.record.write',
                    'http_method' => '',
                    'http_path' => 'check/records*',
                    'order' => 205,
                    'parent_id' => 266,
                    'created_at' => '2021-05-08 14:34:12',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            228 =>
                array(
                    'id' => 269,
                    'name' => '盘点任务按钮',
                    'slug' => 'check.record.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 206,
                    'parent_id' => 266,
                    'created_at' => '2021-05-08 14:34:32',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            229 =>
                array(
                    'id' => 270,
                    'name' => '盘点任务创建',
                    'slug' => 'check.record.create',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 207,
                    'parent_id' => 269,
                    'created_at' => '2021-05-08 14:40:20',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            230 =>
                array(
                    'id' => 271,
                    'name' => '盘点任务完成',
                    'slug' => 'check.record.update.yes',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 208,
                    'parent_id' => 269,
                    'created_at' => '2021-05-08 14:40:43',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            231 =>
                array(
                    'id' => 272,
                    'name' => '盘点任务取消',
                    'slug' => 'check.record.update.no',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 209,
                    'parent_id' => 269,
                    'created_at' => '2021-05-08 14:40:59',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            232 =>
                array(
                    'id' => 273,
                    'name' => '盘点任务导出',
                    'slug' => 'check.record.export',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 210,
                    'parent_id' => 269,
                    'created_at' => '2021-05-08 14:41:17',
                    'updated_at' => '2021-05-08 14:41:45',
                ),
            233 =>
                array(
                    'id' => 274,
                    'name' => '盘点明细',
                    'slug' => 'check.track',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 244,
                    'parent_id' => 0,
                    'created_at' => '2021-05-08 14:42:16',
                    'updated_at' => '2021-05-08 14:42:16',
                ),
            234 =>
                array(
                    'id' => 275,
                    'name' => '盘点明细只读',
                    'slug' => 'check.track.read',
                    'http_method' => 'GET',
                    'http_path' => 'check/tracks*',
                    'order' => 245,
                    'parent_id' => 274,
                    'created_at' => '2021-05-08 14:42:39',
                    'updated_at' => '2021-05-08 14:42:39',
                ),
            235 =>
                array(
                    'id' => 276,
                    'name' => '盘点明细写入',
                    'slug' => 'check.track.write',
                    'http_method' => '',
                    'http_path' => 'check/tracks*',
                    'order' => 246,
                    'parent_id' => 274,
                    'created_at' => '2021-05-08 14:43:02',
                    'updated_at' => '2021-05-08 14:43:02',
                ),
            236 =>
                array(
                    'id' => 277,
                    'name' => '盘点明细按钮',
                    'slug' => 'check.track.action',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 247,
                    'parent_id' => 274,
                    'created_at' => '2021-05-08 14:43:18',
                    'updated_at' => '2021-05-08 14:43:18',
                ),
            237 =>
                array(
                    'id' => 278,
                    'name' => '盘点明细更新',
                    'slug' => 'check.track.update',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 248,
                    'parent_id' => 277,
                    'created_at' => '2021-05-08 14:43:56',
                    'updated_at' => '2021-05-08 14:43:56',
                ),
            238 =>
                array(
                    'id' => 279,
                    'name' => '通知已读',
                    'slug' => 'notification.read',
                    'http_method' => 'GET',
                    'http_path' => 'notifications/read_all,notifications/read/*',
                    'order' => 249,
                    'parent_id' => 89,
                    'created_at' => '2021-05-19 14:28:15',
                    'updated_at' => '2021-05-19 14:28:15',
                ),
            239 =>
                array(
                    'id' => 280,
                    'name' => '设备字段恢复默认排序',
                    'slug' => 'device.column.sort.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 250,
                    'parent_id' => 111,
                    'created_at' => '2021-05-28 16:26:58',
                    'updated_at' => '2021-05-28 16:26:58',
                ),
            240 =>
                array(
                    'id' => 281,
                    'name' => '软件字段恢复默认排序',
                    'slug' => 'software.column.sort.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 251,
                    'parent_id' => 160,
                    'created_at' => '2021-05-28 16:27:14',
                    'updated_at' => '2021-05-28 16:27:14',
                ),
            241 =>
                array(
                    'id' => 282,
                    'name' => '配件字段恢复默认排序',
                    'slug' => 'part.column.sort.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 252,
                    'parent_id' => 136,
                    'created_at' => '2021-05-28 16:27:31',
                    'updated_at' => '2021-05-28 16:27:31',
                ),
            242 =>
                array(
                    'id' => 283,
                    'name' => '耗材字段恢复默认排序',
                    'slug' => 'consumable.column.sort.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 253,
                    'parent_id' => 185,
                    'created_at' => '2021-05-28 16:27:54',
                    'updated_at' => '2021-05-28 16:27:54',
                ),
            243 =>
                array(
                    'id' => 284,
                    'name' => '服务字段恢复默认排序',
                    'slug' => 'service.column.sort.delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 254,
                    'parent_id' => 204,
                    'created_at' => '2021-05-28 16:28:31',
                    'updated_at' => '2021-05-28 16:28:31',
                ),
            244 =>
                array(
                    'id' => 285,
                    'name' => '设备打印标签',
                    'slug' => 'device.print.tag',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 255,
                    'parent_id' => 7,
                    'created_at' => '2021-11-22 16:56:39',
                    'updated_at' => '2021-11-22 16:56:39',
                ),
            245 =>
                array(
                    'id' => 286,
                    'name' => '设备打印清单',
                    'slug' => 'device.print.list',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 256,
                    'parent_id' => 7,
                    'created_at' => '2021-11-22 16:56:52',
                    'updated_at' => '2021-11-22 16:56:52',
                ),
            246 =>
                array(
                    'id' => 287,
                    'name' => '设备清单报废',
                    'slug' => 'device.record.discard',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 257,
                    'parent_id' => 7,
                    'created_at' => '2022-07-18 10:01:08',
                    'updated_at' => '2022-07-18 10:01:55',
                ),
            247 =>
                array(
                    'id' => 288,
                    'name' => '设备清单报废取消',
                    'slug' => 'device.record.cancel_discard',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 258,
                    'parent_id' => 7,
                    'created_at' => '2022-07-18 10:01:38',
                    'updated_at' => '2022-07-18 10:02:00',
                ),
            248 =>
                array(
                    'id' => 289,
                    'name' => '设备清单删除取消',
                    'slug' => 'device.record.cancel_delete',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 259,
                    'parent_id' => 7,
                    'created_at' => '2022-07-18 10:02:30',
                    'updated_at' => '2022-07-18 10:02:30',
                ),
        ));


    }
}
