﻿// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.
// https://raw.githubusercontent.com/aspnet/Hosting/rel/1.1.2/src/Microsoft.AspNetCore.TestHost/TestServer.cs


using Microsoft.AspNetCore.Hosting.Server;

namespace Papercut.Service.Web.Hosting.InProcess;

public class HttpServer : IServer
{
    private readonly IWebHost _hostInstance;
    private bool _disposed;

    public HttpServer(IWebHostBuilder builder)
    {
        var host = builder.UseServer(this).Build();
        host.Start();
        _hostInstance = host;
    }

    public Uri BaseAddress { get; set; } = new Uri("http://localhost/");

    public IWebHost Host
    {
        get
        {
            return _hostInstance;
        }
    }


    IFeatureCollection IServer.Features { get; }

    //public HttpMessageHandler CreateHandler()
    //{
    //    var pathBase = BaseAddress == null ? PathString.Empty : PathString.FromUriComponent(BaseAddress);
    //    return new ClientHandler(pathBase, _application);
    //}

    //public HttpClient CreateClient()
    //{
    //    return new HttpClient(CreateHandler()) { BaseAddress = BaseAddress };
    //}

    public void Dispose()
    {
        if (!_disposed)
        {
            _disposed = true;
            _hostInstance.Dispose();
        }
    }

    Task IServer.StartAsync<TContext>(IHttpApplication<TContext> application, CancellationToken cancellationToken)
    {
        //_application = new ApplicationWrapper<Context>((IHttpApplication<Context>)application, () =>
        //{
        //    if (_disposed)
        //    {
        //        throw new ObjectDisposedException(GetType().FullName);
        //    }
        //});
        return Task.FromResult(0);
    }

        
    Task IServer.StopAsync(CancellationToken cancellationToken)
    {
        return Task.FromResult(0);
    }
        
    private class ApplicationWrapper<TContext> : IHttpApplication<TContext>
    {
        private readonly IHttpApplication<TContext> _application;
        private readonly Action _preProcessRequestAsync;

        public ApplicationWrapper(IHttpApplication<TContext> application, Action preProcessRequestAsync)
        {
            _application = application;
            _preProcessRequestAsync = preProcessRequestAsync;
        }

        public TContext CreateContext(IFeatureCollection contextFeatures)
        {
            return _application.CreateContext(contextFeatures);
        }

        public void DisposeContext(TContext context, Exception exception)
        {
            _application.DisposeContext(context, exception);
        }

        public Task ProcessRequestAsync(TContext context)
        {
            _preProcessRequestAsync();
            return _application.ProcessRequestAsync(context);
        }
    }
}