﻿// Papercut
// 
// Copyright © 2008 - 2012 Ken Robertson
// Copyright © 2013 - 2024 Jaben Cargman
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


using System.Collections.ObjectModel;

namespace Papercut.Service.Infrastructure.Paths;

public class ServerPathTemplateProviderService : IPathTemplatesProvider
{
    public ServerPathTemplateProviderService(SmtpServerOptions smtpServerOptions)
    {
        var messagePaths = smtpServerOptions.MessagePath.Split(';')
            .Select(s => s.Trim())
            .Where(s => !string.IsNullOrWhiteSpace(s));

        this.MessagePathTemplates = new ObservableCollection<string>(messagePaths);

        var loggingPaths = smtpServerOptions.LoggingPath.Split(';')
            .Select(s => s.Trim())
            .Where(s => !string.IsNullOrWhiteSpace(s));

        this.LoggingPathTemplates = new ObservableCollection<string>(loggingPaths);
    }

    public ObservableCollection<string> MessagePathTemplates { get; }

    public ObservableCollection<string> LoggingPathTemplates { get; }

    #region Begin Static Container Registrations

    static void Register(ContainerBuilder builder)
    {
        builder.RegisterType<ServerPathTemplateProviderService>().AsImplementedInterfaces().AsSelf()
            .InstancePerLifetimeScope();
    }

    #endregion
}