---
title: CSS units Cheat Sheet
type: cheatsheet
tags: [css,layout,cheatsheet]
author: chalarangelo
cover: measuring
excerpt: Learn everything you need to know about CSS units with this handy cheatsheet.
dateModified: 2021-06-12T19:30:41+03:00
---

- `px`: Absolute pixel value
- `rem`: Relative to the `font-size` of the root element
- `em`: Relative to the `font-size` of the element
- `%`: Relative to the parent element
- `vw`: Relative to the viewport's width, `1vw` = `1%` * viewport width
- `vh`: Relative to the viewport's height, `1vh` = `1%` * viewport height
- `vmin`: Relative to the viewport's smaller dimension, `1vmin` = min(`1vh`, `1vw`)
- `vmax`: Relative to the viewport's larger dimension, `vmax` = max(`1vh`, `1vw`)
- `ch`: Relative to the width of the glyph "0" of the element's font
- `in`: Inches `1in` = `2.54cm` = `96px`
- `pc`: Picas `1pc` = `1in` / `6` = `16px`
- `pt`: Points `1pt` = `1in` / `72` = `1.333px` (approximately)
- `cm`: Centimeters `1cm` = `96px` / `2.54` = `37.8px` (approximately)
- `mm`: Millimeters `1mm` = `1cm` / `10` = `3.78px` (approximately)
