---
title: The benefits of writing
type: story
tags: [career,webdev,programming,jobs]
author: chalarangelo
cover: laptop-view
excerpt: Writing about a topic can often sound boring or worthless. But there are significant benefits to doing it from time to time.
dateModified: 2022-11-05T14:00:07+03:00
---

I was recently tasked with writing a design document at work. What first seemed like a tiresome chore I had to endure turned out to be both enlightening and beneficial both to me and my team. This isn't just a case of making the best of a bad situation, but rather a case of rediscovering the reason behind why writing down your thoughts isn't an exercise in futility. Instead of boring you with a long-winded story about the task, I'll just present the takeaways and hopefully do some storytelling in the process. So why should you write then?

### You learn more about the topic at hand

Presenting a topic requires meticulous **research** in order for you to be able to write down the most interesting and relevant findings. This process will uncover any **gaps in your knowledge** of said topic, gaps your research will in turn have to cover. I've seen this numerous times in the past while doing research both for this website as well as tasks at work and it always holds true. If nothing else, you will gain a **deeper understanding** of whatever it is you are presenting, which will be useful sometime in the future. In the case of my task, I understood more about the business logic, how premature optimizations got in the way of stability and why it was so hard to consistently reach the desired state, as I discovered a hidden layer of complexity I didn't know about before.

### You discover the root of the problem

Most of the time we assume to know the problem well enough to try and solve it. A lot of the time, I've found out, I know a lot less than I originally thought about the domain, the problem and, more importantly, the root cause of it. Again, **presenting the problem to a reader** will put you through the process of having to **explain it** and boil it down to the key details. This more often than not results in a concise description of whatever is at the **root of the problem**. Working on my design document, I figured out that the root of the problem was essentially a set of bad assumptions that kept piling up and had some mismatches between the backend and frontend code.

### You understand past decisions

This one applies to problems you aren't the first one to tackle, but might still be relevant in other situations. As you go you will come across whatever **implementation details** you didn't know about. If you take a closer look, you'll figure out how those came to be in the first place and **why those decisions were made** in the past. Understanding the reasons behind past decisions is crucial in figuring out if the original set of needs, restrictions and assumptions is still valid and how to amend them if necessary. As I was already knee-deep in this task, I realized that the decisions we made almost one year prior were valid at the time, decisions I didn't fully understand back then. A couple of them, however, didn't seem to stand the test of time as business needs changed and we'd have to update them accordingly.

### You come up with more varied solutions

Understanding past decisions, covering the gaps in your knowledge and boiling down the problem to a concise description you should already be a lot more informed about the topic you are researching than before. Hopefully at this stage, you will have an itch to try **a different solution** from the one you originally envisioned or you'll have come up with a solution where there was none. More varied solutions are always better because you can **compare tradeoffs** and get a better understanding of what's best. In my case, I ended up considering a solution I had mostly dismissed originally. And it was that solution which made the most sense to me in the end, even though it was more radical than the one I was planning to propose originally.

As a closing thought, try writing even if nobody is going to read it. Write it for you. It will help you understand, explain, reason about and tackle the task all at once. It's not a waste of time, it's a powerful tool you could leverage from time to time.
