---
title: 7 essential Chrome extensions for web developers
shortTitle: Essential Chrome extensions
type: story
tags: [devtools,webdev]
author: chalarangelo
cover: computer-screens
excerpt: Google Chrome's developer tools are nothing short of amazing. Here are 7 must-have extensions you can add to increase your productivity even further.
unlisted: true
dateModified: 2021-06-12T19:30:41+03:00
---

Google Chrome's developer tools are nothing short of amazing, but there are a few missing tools that can increase your productivity even further. Here are my personal favorite extensions that I use everyday:

### CSS Peeper
[CSS Peeper](https://chrome.google.com/webstore/detail/css-peeper/mbnbehikldjhnfehhnaidhjhoofhpehk?hl=en) is an all-in-one tool for CSS inspection that allows you to quickly peek at the styles, fonts, color palettes and assets of any website you want.

### React Developer Tools
[React Developer Tools](https://chrome.google.com/webstore/detail/react-developer-tools/fmkadmapgofadopljbjfkapdkoienihi?hl=en) is the de facto extension when working with React, providing all the necessary inspection tools for your React applications.

### LastPass

[LastPass](https://chrome.google.com/webstore/detail/lastpass-free-password-ma/hdokiejnpimakedhajhdlcegeplioahd?hl=en) keeps your accounts and API keys secure, by providing a free password manager complete with password generation and password-protected notes.

### uBlock Origin

[uBlock Origin](https://chrome.google.com/webstore/detail/ublock-origin/cjpalhdlnbpafiamejdnhcphjbkeiagm?hl=en) is a simple yet effective ad blocker extension that you can just install and forget about, as it keeps your browsing experience ad-free.

### VisBug

[VisBug](https://chrome.google.com/webstore/detail/visbug/cdockenadnadldjbbgcallicgledbeoc?hl=en) allows you to tweak website designs on the fly, using very intuitive controls and tools, without having to delve into any code at all.

### JSON Viewer

[JSON Viewer](https://chrome.google.com/webstore/detail/json-viewer/gbmdgpbipfallnflgajpaliibnhdgobh?hl=en) provides some much needed syntax highlighting and style customization to JSON responses, which are nowadays very commonplace in most web APIs.

### EditThisCookie

[EditThisCookie](https://chrome.google.com/webstore/detail/editthiscookie/fngmhnnpilhplaeedifhccceomclgfbg?hl=en) is a powerful cookie manager extension, that allows you to add, delete, edit and even export and import cookies quickly and efficiently.
