---
title: 4 SEO tips for developers
shortTitle: SEO tips
type: story
tags: [seo,webdev]
author: chalarangelo
cover: sunrise-over-city
excerpt: SEO is a very relevant topics that most developers are inexperienced in. Here are 4 actionable SEO tips you can implement today.
dateModified: 2021-06-12T19:30:41+03:00
---

SEO is becoming increasingly relevant as the internet keeps growing. While most web developers usually have little experience with SEO, it is not particularly difficult to handle some of the basics. Here are my top SEO tips for web developers:

###  Craft user-friendly URLs and map the appropriately

First and foremost, start at the very beginning, which is your **URL slugs**. For URL slugs the rule is that you want them to be human-readable, with words separated by dashes and with no random letters or digits added. Secondly, it's a good idea to make sure that parts of your URLs match to a **logical structure** in your website (e.g. `/blog/posts/awesome-list-of-seo-tips`). Finally, take the time to build a sitemap and redirect any broken or old URLs to new ones. This will help reduce 404 pages.

### Use structured data to help Google understand your pages

**Structured data** is what Google uses to power its **featured snippets**, those little cards that appear at the top of certain searches. It's a good idea to set up structured data for your pages, which will help you rank higher in search results and possibly even land a featured snippet every once in a while. Just make sure to find the appropriate structured data type and include it in your page and you should be good to go.
### Set up Google Analytics and Google Search Console

This is hardly a new tip, but I think it deserves a spot on the list, as both of these tools are extremely important. **Google Analytics** allows you to track user behavior and gather data that can help you identify problems and opportunities, while **Google Search Console** is helpful for figuring out what users are searching for before landing on your website.

### Keep an eye on your markup, performance and accessibility

Last but not least, something that is probably already on your list, is **optimizing your code**. This includes everything from writing semantic markup and keeping requests to a minimum to optimizing for all device types, making your website accessible and ensuring fast load times. Keep in mind that websites have many moving parts that evolve and change over time, so it's a good idea to audit your website often with a tool like Lighthouse.
