import type { Metadata } from "next";
import { Inter as FontSans } from "next/font/google";

import "./globals.css";

import Link from "next/link";

import { HomeIcon } from "lucide-react";

import { AiCopilotButton } from "@/components/molecules/ai-copilot/AiCopilotButton";

import { cn } from "@/lib/utils";

import RootLayoutClient from "./layout-client";

const fontSans = FontSans({
  subsets: ["latin"],
  variable: "--font-sans",
});

export const metadata: Metadata = {
  title: "Create Next App",
  description: "Generated by create next app",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body
        className={cn(
          "min-h-screen overflow-x-hidden bg-background font-sans antialiased",
          "[&>main]:min-h-[calc(100vh_-_theme(spacing.16))]",
          fontSans.variable
        )}
      >
        <RootLayoutClient>{children}</RootLayoutClient>
      </body>
    </html>
  );
}
