![Literal AI](/img/logoliteralai.png)

# Literal AI Cookbooks and Guides

Welcome to the Literal AI Cookbooks and Guides repository! This repository is dedicated to providing users with comprehensive cookbooks and guides designed to help you understand and implement AI solutions effectively.

Literal AI is an end-to-end observability, evaluation and monitoring platform for building & improving production-grade LLM applications.

For more information, find the full documentation [here](https://docs.getliteral.ai/). Cookbooks from this repo and more [guides are presented in the docs](https://docs.getliteral.ai/guides) with explanations.

## Cookbooks

### Python

| Name                                                                                               | Category                           | Description                                                                                                              |
| -------------------------------------------------------------------------------------------------- | ---------------------------------- | ------------------------------------------------------------------------------------------------------------------------ |
| [Context Utilization with Ragas](/python/context-utilization-ragas/)                               | Evaluation                         | Build a RAG application and evaluate it with RAGAS based on context utilization.                                         |
| [Evaluate User Satisfaction - Customer Support Conversations](/python/evaluate-user-satisfaction/) | Evaluation                         | Retrieve your Customer Support Conversations from Literal AI and evaluate user satisfaction on this conversational data. |
| [LlamaIndex Integration](/python/llamaindex-integration/)                                          | Observability                      | Build a Q&A application with LLamaIndex and monitor it with Literal AI.                                                  |
| [Evaluate Agent Runs with Tools](/python/evaluate-agent-runs/)                                     | Observability (Tools) & Evaluation | Build a simple agent which can use two tools. Monitor and evaluate the tool usage.                                       |
| [A/B Testing Client-Side](/python/ab-testing-client-side/)                                         | Evaluation                         | Build two prompts, randomly assign to new conversations and A/B test on a metric.                                        |
| [Create a Dataset](/python/create-a-dataset/)                                                      | Evaluation                         | Create a Literal AI Dataset from the SDK                                                                                 |
| [Distributed Tracing](/python/distributed-tracing/)                                                | Observability                      | Trace a distributed (TS and Py) service                                                                                  |
| [Monitor a Conversational AI agent](/python/monitor-conversational-ai-agent/)                      | Observability                      | Monitor a Conversational AI agent, built in FastAPI                                                                      |
| [Monitor a Multimodal chatbot](/python/multimodal-conversational-ai/)                              | Observability                      | Monitor a multimodal Conversational AI agent, built with OpenAI                                                          |
| [LangGraph example](/python/langgraph-example/)                                                    | Observability                      | Example with LangGraph : a graph flow with tool use                                                                      |

### TypeScript

| Name                                                                                                                      | Category      | Description                                                                                                |
| ------------------------------------------------------------------------------------------------------------------------- | ------------- | ---------------------------------------------------------------------------------------------------------- |
| [Financial Dashboard with AI Copilot](/typescript/financial-dashboard/)                                                   | Observability | Create an interactive financial dashboard with AI-powered assistance and Generative UI                     |
| [Prompt Iteration with Promptfoo](/typescript/prompt-iteration-promptfoo/)                                                | Evaluation    | Run a simple chat application and evaluate its results with two different prompt templates with Promptfoo. |
| [Image Generation with Dall-E & Literal AI Attachment](/typescript/dall-e-image-generation)                               | Observablity  | Use OpenAI Dall-E to Generate an image with a prompt and then send it to Literal AI.                       |
| [Chatbot using Next.js, OpenAI and Literal AI](/typescript/nextjs-openai/)                                                | Observablity  | Create a personalized and monitored chatbot with OpenAI, Next.js and Literal AI.                           |
| [Chatbot using Vercel ai SDK and Literal AI](/typescript/vercel-ai-sdk/)                                                  | Observablity  | Create a personalized and monitored chatbot with Vercel ai SDK and Literal AI.                             |
| [Simple RAG using LanceDB, OpenAI and Literal AI](/typescript/lancedb-rag)                                                | Observability | Create Simple RAG on Youtube Transcripts stored using LanceDB                                              |
| [Speech-to-Emoji: Next.js app to summarize audio with OpenAI Whisper, GPT-4o and Literal AI](/typescript/speech-to-emoji) | Observability | Create a simple web app that transcribes and summarizes audio using OpenAI Whisper, GPT-4o and Literal AI. |
| [Interactive map with a copilot chat bot](/typescript/leaflet-interactive-map/)                                           | Observability | A world map with a chat bot that is context aware and react to the user position on the map                |
| [LangChain and LangGraph examples](/typescript/langchain-langgraph/)                                                      | Observability | Three examples with LangChain/LangGraph : a basic RAG, a graph flow with tool use, and a multi-agent flow  |
