---
blogpost: true
title: KinCodeCon 2018
date: 2018-11-21 14:30
slug: kincodecon2018
tags: kincodecon, steering-committee
description: KinCodeCon 2018 and NumFOCUS SDG
type: text
author: Kyle Niemeyer
---

# KinCodeCon 2018

Thanks to the support of [NumFOCUS](https://numfocus.org) via a
[small development grant](https://numfocus.org/blog/fall-2018-open-source-development-grants),
the [Cantera Steering Committee](current-steering-committee) met in
person on MIT's campus in Cambridge, MA, at the 3rd Annual KinCodeCon on November 16–18, 2018.

The Steering Committee (SC) met virtually in 2016 and 2017 to discuss issues and plan for the future,
and while we tried to include some live code sprinting, the virtual nature of the meetings made
this challenging. It was also challenging to block off more than a few hours at a time when
at our respective homes/institutions. This in-person meeting provided the opportunity to accomplish
a number of our goals regarding governance of the Cantera project and improving the Cantera code.

On Friday, the SC discussed planning a roadmap for the future development of the
Cantera code and community. The SC discussed promotion opportunities to increase the user-base and
developer-base of Cantera, including

* Scientific Computing and Python conferences such as the SciPy Conference and PyCon
* Domain-specific conferences such as AIChE, AIAA, ASME, ACS, and other society conferences
* Outreach to other departments/universities to encourage people to adopt Cantera in their courses and research
* Google Summer of Code (GSoC) participation

Specifically regarding the GSoC participation, the SC elected to participate in GSoC 2019 and will
begin soliciting proposals from students before the start of 2019. Cantera will participate under
the NumFOCUS umbrella to save on administrative overhead.

After lunch, the SC discussed affiliated packages in the Cantera ecosystem. These packages
tend to use Cantera in some way, although they are mostly not officially maintained by the
Cantera developers. We have added an [](/affiliated) page that
lists the current packages the SC is aware of. The list will be "crowd-sourced" with input from the
Users' Group on Google.

On Saturday, the SC discussed the governance of the Cantera project. We identified the [Astropy](http://www.astropy.org)
project as an "aspirational peer" project because of their role in the astronomy community. We
also identified their governance procedures as robust and relatively transparent, something we
would like to strive towards.

The SC then voted to establish a list of topics that they should vote on. These topics include

* Modifications of the governance procedures
* Adding/removing steering committee members
* Spending project funds
* Adding/removing people with commit rights to GitHub repositories
* Adding/removing moderators of the User’s Group
* Adding/removing people to private communication channels
* Adding/removing people with rights to post as Cantera on social media
* Establishing sub-committees and roles
* Adding/removing members from the Scientific Advisory Board

Votes will require 2/3 majority of the SC to vote "Yes" to pass. Members can be added to or
removed from the SC after a nomination by an existing SC member and a 2/3 majority vote.
All votes will be recorded in a Google Doc.

The current membership of the SC is

* Steven DeCaluwe (2018–)
* C. Franklin Goldsmith (2018–)
* Kyle Niemeyer (2018–)
* Raymond Speth (2018–)
* Bryan Weber (2018–)
* Richard West (2018–)

If you are interested in becoming a member of the SC or for more information, please contact us
[by email](mailto:steering@cantera.org) or reach out to one of the members individually.

Finally, the SC established two sub-groups within the Cantera organization. These are the
people who have commit access to the Cantera organization repositories

* Raymond Speth
* Bryan Weber
* Steven DeCaluwe

and the moderators of the Cantera Google Users' Group

* Raymond Speth
* Bryan Weber
* Steven DeCaluwe
* Nicholas Curtis

If you are interested in more information about these sub-groups or in joining them, please
contact us [by email](mailto:steering@cantera.org) or reach out to one of the members
individually.

Cantera is now officially part of NumFOCUS. NumFOCUS is a 501(c)3 nonprofit dedicated to supporting
the open source scientific computing community. If you are interested in learning more about
NumFOCUS, please visit their website at [NumFOCUS](https://numfocus.org), or our website at <https://cantera.org/community.html#donations>.
