---
date: 2020-06-01 16:20
tags: GSoC 2020
author: Paul Blum
---

# GSoC 2020 - Developing a 0-D Steady-State Combustion Solver for Cantera

## Introduction

Hello, world! My name is Paul Blum ([@paulblum](https://github.com/paulblum)), and I'm an undergraduate student at the University of Connecticut studying Mechanical Engineering and Computer Science & Engineering. I was introduced to Cantera by [@bryanwweber](https://github.com/bryanwweber), one of my professors at UConn, as an undergraduate research project that might allow me to jointly apply concepts from both of my fields of study. Since then, I’ve completed some small projects for the Cantera software and its website ([Cantera/cantera #709](https://github.com/Cantera/cantera/pull/709), [Cantera/cantera-website #95](https://github.com/Cantera/cantera-website/pull/95), [Cantera/cantera-website #98](https://github.com/Cantera/cantera-website/pull/98)).

Cantera has presented me with the opportunity to challenge myself, learn an incredible amount, and develop my skills as a scientist and an engineer. With this perception, I am excited to announce that I will be developing code for Cantera full-time this summer as part of Google Summer of Code 2020.

## Project Details

Over the next few months, I'll be working to create a fast and efficient 0-D steady-state combustion solver to integrate as a new feature into Cantera. Solvers for this type of idealized combustion are typically used in applications like studying stabilization and extinction in high velocity combustion, investigating the formation of poisonous nitrogen oxides during burning, determining the values of global reaction parameters in analytical models, and approximating more complex systems like gas-turbine combustors.

Throughout the summer I'll be posting updates on development progress to the [Cantera blog](https://cantera.org/blog/index.html) and the [Cantera enhancements repository](https://github.com/Cantera/enhancements/issues/31), so be sure to stay tuned! In the meantime, you can read more about this project via the official GSoC [project description](https://summerofcode.withgoogle.com/projects/#4550970131873792), or my more detailed [project proposal](https://drive.google.com/file/d/1vaOjydm6wWKgF2M4J3iFwNZNKHX5laBY/view?usp=sharing).

If you're interested in learning more about this project, or have any questions or suggestions regarding its development, feel free to email me at <paul_d_blum@yahoo.com>.

Looking forward to a great summer!
