# Cantera Governance

This document outlines the policies and procedures that manage the Cantera community.

## Code of Conduct

All online and in-person interactions and communications related to Cantera are governed
by the [Cantera Code of Conduct](https://github.com/Cantera/cantera/blob/main/CODE_OF_CONDUCT.md).
This code of conduct sets expectations for the community to ensure that users and
contributors are able to participate in a respectful and welcoming environment.

## Teams & Roles

Steering Committee
: This is the governing body of Cantera, making decisions regarding the structure,
  operations, and long-term direction of the project. Each member has one vote for
  important project decisions.

Committers
: Members of the committers team have commit/push access to the Cantera source code,
  and can merge pull requests.

Cantera Users' Group moderators
: Members of the moderators team moderate the Users' Group, and have power to
  enable/disable posting of community members at their discretion.

(current-steering-committee)=
## Current Steering Committee

The role of the steering committee is to ensure the long-term health of the Cantera
project. This includes overseeing the development of the Cantera code and community in a
way that most benefits the entire community of users and contributors. The steering
committee can be contacted at [steering@cantera.org](mailto:steering@cantera.org). The
current steering committee (in alphabetical order) is:

- Steven DeCaluwe (2018–)
- Connie Gao (2019-)
- C. Franklin Goldsmith (2018–)
- Kyle Niemeyer (2018–)
- Raymond Speth (2018–)
- Bryan Weber (2018–)
- Richard West (2018–)

The Steering Committee should have at least five members. Members serve in two-year
cycles (starting in November 2018), with the ability to reaffirm their membership at the
end of each cycle without a committee vote or leave the committee at their discretion.
Members can also choose to leave the committee at any time.

## Voting

The Steering Committee will vote on the following topics, with passing contingent on a
2/3 majority. All members should vote, but abstentions are permitted.

- Modifications of the governance procedures
- Adding/removing steering committee members
- Spending project funds
- Adding/removing people with commit rights to GitHub repositories
- Adding/removing moderators of the User’s Group
- Adding/removing people to private communication channels
- Adding/removing people with rights to post as Cantera on social media
- Establishing sub-committees and roles
- Adding/removing members from the Scientific Advisory Board

The Steering Committee will maintain a Google Doc that records all votes (but not
discussion). Access to the Google Doc will be limited to members of the Steering
Committee.

## Acknowledgements

This document was inspired by the
[conda-forge governance guidelines](https://conda-forge.org/docs/orga/governance.html).
