---
html_theme.sidebar_secondary.remove: true
---

# In Memoriam: Dave Goodwin

::::{grid} 1 2 2 2

:::{grid-item}
:child-align: center

*"Keep on working to make this world a better place. It is important to get your
thoughts away from your problems and focused on those who are less fortunate than you
are."*

*"We can't control the hand of cards we are dealt, but we sure can determine how we
play them."*

:::

:::{grid-item}
```{figure} _static/images/dave-goodwin.jpg
:align: center
:alt: Dave Goodwin
:scale: 50

Prof. David Goodwin,\
Original Developer of Cantera\
*1957–2012*
```
:::


::::
Dave Goodwin, the original developer of Cantera, passed away in 2012. We would like to
provide this page for his friends and colleagues to salute his efforts at developing an
open-source constitutive modeling package. Caltech also wrote a
[lengthy article about Dave's life and work](http://www.caltech.edu/news/caltech-mourns-passing-david-g-goodwin-37485).
Please submit your thoughts and remembrances about Dave for inclusion on this page.


{attribution="Harry Moffat"}
> I know that the development of Cantera was a real passion for Dave, an advocacy for
> which went way beyond just his normal professional life. I think that whole community
> owes Dave a debt of gratitude in getting Cantera off of the ground and that the debt is
> best paid by continuing to develop Cantera along the principles that he so fervently
> espoused.
>
> Dave started off by with an extensive overhaul of the Chemkin suite of programs for
> gas-phase thermochemistry and kinetics. Chemkin had originally been developed at Sandia
> National Laboratories in the 1970s and had quickly gone into worldwide use. Dave became
> interested in overhauling Chemkin for two primary reasons. The first reason was that,
> mostly because of its success, Chemkin became a for-profit product whose distribution
> rights was licensed out during the nineties. Dave was very passionate about the
> open-source movement and about the necessity of keeping software for academic use as
> being in the public domain. Dave chose Cantera's licensing approach, Berkeley license,
> with this in mind.
>
> The second reason was that Dave saw the need to upgrade the modeling software to an
> object-oriented structure, which could then be extended easily to new constitutive
> models and situations. Dave had a strong passion for making sure his software kept up
> with the times, and advocated for the current multi-interface structure that Cantera
> currently has. Along the way he developed a new formalism for calculating the collision
> integrals used in the evaluation of transport parameters from dilute ideal gases theory.
>
> I first became aware of Dave's contributions through his groundbreaking work on diamond
> CVD. I remember reading his papers on the subject and marveling at how understanding the
> detailed kinetics of surface processes could directly lead to a real understanding of
> the performance of diamond growth reactors. That work probably was done with Cantera,
> and probably helped to direct the structure and content of Dave's original formulation
> of Cantera.

{attribution="smjaffe11, Dec 6, 2012"}
> A couple Christmas seasons before Dave died, we were visiting in his home. One side of
> his body was paralyzed by a glioma, the other side gripped by Parkinson's. I asked
> Dave if he was bitter about his infirmity. He simply said, “I’ve got no time for
> anger.” The next Christmas I was thinking about Dave's paintings. Many hung in his
> living room, and there was one I remembered in his grad school office that Richard
> Diebenkorn would have been proud to sign. Dave's home is a few minutes from the
> Norton-Simon art museum. Impromptu Dave, Frances, and I threw the wheel chair in the
> trunk, and went. A big storm had just felled a large tree in the sculpture garden.
> Frances' manner impressed me. Perhaps ancient wisdom or medical training enabled her
> to at once care for Dave and treat him as an independent equal. Dave and Frances
> brought equanimity to life’s rewards and responsibilities. Much thanks. You are in our
> hearts.

{attribution="jasonkholt, Dec 13, 2012"}
> Dave was my co-advisor during my PhD work at Caltech from 1997-2002, and I benefitted
> greatly from my weekly meetings with him. His work on developing Cantera was an
> integral part of the modeling component to my thesis on polycrystalline silicon CVD,
> but more broadly his effort to democratize this information has proven to be hugely
> valuable to a number of communities. While I no longer work in this space since
> leaving Caltech, I sincerely hope that other researchers for whom this package is
> valuable continue to make contributions and refinements. Dave will be greatly missed
> and my thoughts are with his family.
