# Affiliated Packages

While Cantera provides some standalone models and applications, numerous external
packages exist that provide more specialized functionality and rely on Cantera. Here we
provide a non-exhaustive, alphabetical, list of these packages; if you would like us to
include your package, please [submit a pull request](https://github.com/cantera/cantera-website/pulls),
[file an issue](https://github.com/cantera/cantera-website/issues/new), or
post on the [Google Users' Group](https://groups.google.com/g/cantera-users).

::::{grid} 1 2 2 2

:::{grid-item-card} Arrhenius.jl
Differential combustion modeling software in Julia.

[Repository](https://github.com/DENG-MIT/Arrhenius.jl)

Maintainer(s): Weiqi Ji
:::

:::{grid-item-card}  ASALI
Graphical user interface for calculating properties using Cantera.

[Repository](https://github.com/srebughini/ASALI)

Maintainer(s): Stefano Rebughini
:::

:::{grid-item-card} BIOVIA Materials Studio
Commercial modeling and simulation software for materials science and chemistry.

[Website](https://www.3ds.com/products/biovia/materials-studio)
:::

:::{grid-item-card} CollectionOfMechanisms
A hub for combustion reaction mechanisms including converted Cantera XML and YAML based
mechanisms.

[Repository](https://github.com/jiweiqi/CollectionOfMechanisms)

Maintainer(s): Weiqi Ji, Jeff Santner
:::

:::{grid-item-card} ChemCheck
A tool to help Cantera users to detect chemical and syntax errors in kinetic models

[Repository](https://github.com/comocheng/ChemCheck)

Maintainer(s): Chao Xu, Richard West
:::

:::{grid-item-card} ctwrap
A light-weight Python wrapper facilitating batch simulations.

[Website](https://microcombustion.github.io/ctwrap/)

[Repository](https://github.com/microcombustion/ctwrap)

Maintainer(s): Ingmar Schoegl
:::

:::{grid-item-card} Ember
A quasi-one-dimensional, unsteady reacting flow solver that can simulate a number of
fundamental flame configurations: premixed laminar flames, opposed-flow strained flames
(premixed or diffusion), axisymmetric (tubular) flames with positive or negative
curvature, and steady 2D flames in a prescribed velocity field.

[Repository](https://github.com/speth/ember)

Maintainer(s): [Ray Speth](https://github.com/speth)
:::

:::{grid-item-card} Frhodo
A GUI-based application for simulating experimental data and optimizing chemical
kinetics mechanisms.

[Repository](https://github.com/Argonne-National-Laboratory/Frhodo)

Maintainer(s): Travis Sikes, Robert Tranter
:::

:::{grid-item-card} gas-properties
A python GUI for calculating properties of gases, equilibrium states, and isentropic
compression. Similar to unsupported GasEQ software.

[Repository](https://github.com/jsantner/gas-properties)

Maintainer(s): Jeff Santner
:::

:::{grid-item-card} PoKiTT
A library for Portable Kinetics, Thermodynamics, and Transport calculations.

[Repository](https://gitlab.multiscale.utah.edu/common/PoKiTT)

Maintainer(s): James Sutherland
:::

:::{grid-item-card} pyJac
Generates C and CUDA source code for analytically calculating the Jacobian matrix for a
chemical kinetic model, along with species and reaction rates.

[Website](http://slackha.github.io/pyJac/)

[Repository](https://github.com/SLACKHA/pyJac)

Maintainer(s): Nick Curtis, Kyle Niemeyer
:::

:::{grid-item-card} pyMARS
Python-based (chemical kinetic) Model Automatic Reduction Software (pyMARS) implements
multiple techniques for reducing the size and complexity of detailed chemical kinetic
models.

[Repository](https://github.com/Niemeyer-Research-Group/pyMARS)

Maintainer(s): Phillip Mestas, Kyle Niemeyer
:::

:::{grid-item-card} reactorch
A Differentiable Reacting Flow Simulation Package in PyTorch.

[Repository](https://github.com/DENG-MIT/reactorch)

Maintainer(s): Weiqi Ji
:::

:::{grid-item-card} RGFROSH
A Python real and ideal gas frozen shock solver.

[Website](https://VasuLab.github.io/RGFROSH)

[Repository](https://github.com/VasuLab/RGFROSH)

Maintainer(s): Cory Kinney
:::

:::{grid-item-card} RMG
Reaction Mechanism Generator, a tool for automatically generating chemical reaction
mechanisms for modeling reaction systems including pyrolysis, combustion, atmospheric
science, and more.

[Website](https://rmg.mit.edu)

[Repository](https://github.com/ReactionMechanismGenerator/RMG-Py)

Maintainer(s): William Green, Richard West
:::

:::{grid-item-card} SDToolbox
The Shock & Detonation Toolbox enables the solution of standard problems for gas-phase
explosions using realistic thermochemistry and detailed chemical kinetics.

[Website](http://shepherd.caltech.edu/EDL/PublicResources/sdt/)

Maintainer(s): Joseph E. Shepherd
:::

::::
