# Cryptonite Contributors' Guide

Contributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**. But it is
also important to follow the best practices so that there is no confusion.

## Some Resources

For beginners, who are starting out with their first contributions, it might seem a bit tricky to work with **GitHub**, especially if you have no previous knowledge of ***Git***.

So, here are a couple of resources to help you refresh / get started:

1. [Git Cheatsheet](https://education.github.com/git-cheat-sheet-education.pdf)
2. [GitHub Learning Lab](https://lab.github.com/githubtraining/introduction-to-github)

## Programming Language

Cryptonite relies on Python as its core language. So, inorder to make contributions, you are expected to know the basics of Python. [Here](https://www.youtube.com/playlist?list=PLbsliZj8JocIez5TvsbMaVKgF-sxoal0C) is a great playlist to start with.

## Non Technincal? No Problemo

For those contributing towards documentation, knowing **Markdown** will be of great help.

Here are some resources for you to get started:

1. [Markdown Guide](https://www.markdownguide.org/basic-syntax/)
2. [Markdown Lab](https://www.markdowntutorial.com/)

## GitHub Workflow

You are free to choose your style of workflow as far as you are not making a PR from the main branch of your fork. This is not recommended and would create some problems while syncing your fork with the upstream repository.

For beginners, here's what you'd have to do:

1. Fork the Project
2. Clone your fork to your local machine via `git clone https://github.com/YOUR USERNAME/artificial-intelligence.git`
3. Create a branch in your local machine: `git checkout -b <branchname>`
4. Make changes/commits to this branch
5. Push changes to your fork: `git push origin <branchname>`
6. Open a PR from your fork to Cryptonite main branch

## Commit Ettiquette

We love our commits to look similar and homogeneous. We recently started following ***conventionalcommits*** guidelines to craft our commit messages. You too can follow this guide at <https://www.conventionalcommits.org/>
