### Chinese Characters Lists ###

########################
## Simplified Chinese ##
########################

# HSK（probably new, since 2010), (compiled from HSK vocabulary [both single characters and words])
hanziSHSK1=set('爱北话买钱热分听叫商能杯米飞菜本语坐期吃不后没朋做医很看你岁怎出脑狗见对东上少中的面多五椅雨开好她店钟字亮前苹女衣太个现小昨起八喝六果桌哪觉回西猫妈喂大读校天子写们汉喜视些十在系那姐影老有候电月年九服二明下七国气打院点先说什京块习欢关友么想同来高冷兴机人租书水星家三是请今认我睡时吗午茶爸生一漂去他儿车里了样名号住谢呢都几会这谁识学四再工客师饭和作')
hanziSHSK2=set('笑真羊贵为您泳体牛零可进步远弟卖间每找孩鸡左绍事件然道离汽问考息第助错正过馆跑动踢早已给旁所忙日病跳瓜慢纸但着班报笔奶试思舞往务火课夫歌还红百穿晴吧色始累哥告玩宜它床也诉等球懂让要意路边蛋别乐经情洗以送公到妻男篮右场次宾得啡完药运近司站眼房白唱便鱼长身颜非游员表新因望手休比雪两旅希铅黑足教备最阴共条常千虽室睛咖题肉门走从快就票丈准晚外帮妹知姓介')
hanziSHSK3=set('饱城哭物根口瓶元环片主风束练跟响史居惯育历特料变相鞋心向自胖极春复空爬夏重南糕被静香急帽啤阳骑图注锻除境害李马干清假蓝平信单易盘需只越简舒世黄总顾加朵阿当伞张山半季乎搬园嘴腿护换赛净接万选力鼻渴用突音发级或该辆难久而法参灯择瘦银楼于鸟迎闻饿业牙理婚像蕉查己文词较鲜聪安段扫怕邻铁筷炼又冬满奇目碗须附化头典把努愿爷办船故担轻梯短甜疼秋数树板迟定楚旧句界答行姨熊借照容遇如周刮裤斤绿且种脚画讲地者坏决河裙求草提终趣末成放层冒才酒耳市矮皮必记更方拿留烧算角衫带直据包差般刚邮冰啊叔戏健康感声节衬街箱绩花礼卡议应双超忘刷位其澡实怪脸结网调刻饮聊检解')
hanziSHSK4=set('划专亚倒普永咳鸭象忆按反疑紧深袋麻众傅膊幽济拒幸确赚否示厕养戴联续巾帅扰绝猜硕申论技此圾导闹肥章辛植验够购染骄童漫支怜部美则处海厉连恼术士悔细察排即误性勺材聚弹之油克禁售指案袜止羞堵乓微乒富纪航态利慕功消尽艺温规勇围输概扮符嗽户命减占获寄拜虑内暑膏谈允降虎距匙谅寒资激死呼肚估彩励台译效盒竞趟速牌棵失散泉林律原辣默粗醒讨江各缺具祝熟遍付梦言亲松抬偶柿值迷整剩址咸首负母伙使改顺码优及敲封洲翻证陪厨叶断计汁详丽郊研尊况傲弄笨传云精洋广凉戚巧究格躺烤篇管怀敢许扔困密钥盐惜举批入增惊苦悉保底愉弃沙葡款泼合逛全随肯鼓座列歉厅压掉尝基饼脱局低龄诚萄羽汗暖质脾挂式肤拾础活推标争至耐供汤剧存印页挺奖任刀份镜险餐停谊俩将貌棒适引危货收费扬签际恐评父穷针卫倍建稍抽却交懒邀羡序赢受味浪破免光毛严并塑擦播呀杂著糖败授脏展登仔福拉琴暂互另度吸何甚流释秒饺科持胳判乘阅无例矿桥修既孙钢烟价污填坚队职责厌预区籍秀志仅社毕景取转积线酸尤奋约赶族与通丰乱演由咱金伤竟尔聘丢折烦桶警落森程省垃继贺仍量抱民键窗招切厚橡博骗观')
hanziSHSK5=set('龙返玉吨控删秩呆闭谨委幅庭浇撕革尘震描豆吻蝴纲兄未匆诊托待守匀范碍惭慎挤夜威趋宠谓采食坦盖斗嚏均鼠洒似代荣念歪糟器齿捡英岛营置喊财项充咨窄创弱洞蔬彼逃阶胡嫁筑催柜组挥哈迅顿临夹孕殊躲愁核粘夸嘉婆录显询阻域宣屋欣淘尾惠补届朗赔墙迫召抄皂烈矩靠税跃棋恨装恳武灵滩享娱眠犹枪蛇绕布刺农粮射称施抖频歇肌毒疯延偷沉赏测防熬繁扩配宽姿堆余宿吹巨固氛亏宁壁致悠尚雄糊佛宴帘碰依硬润妨群综扇椒势兔耽梨宝恋紫挑币晒织匹避古遵某毯吓恢设甲形傍盾薄恭型挡眉藏劳锁册伸狮甩疲谦彻欧虚酱妙唯艳血曾烂青池投振顶掌土骨泛桃胁府劣透忽军华毫良略木卧骤逐驾诗霉蜂屈睁纯圈炮兑拥治培盆达纷伟贝拦娘踩缩佩猴贸叙渐握兵抢套裹退悲燥豪髦限咬寓荐幕虫拼蝶嗓胸姑版钓暗承裁维闪朝逻汇编颗拍吐脖飘属肠脆艰勤偿追档炒涂痒轮勿吵夕益团订秘辞搜义石魅王率执慌乡冠摔醉璃替柔领冲制泪括俊操俱搞启滚库屉绪骂贴炭糙凌弯县敬漠挣载麦寻尺灾丝桔疗析神览映逗梳岸舍雷孝贡蹲悄媒寞讽漏献丑舅战鞭遗赞升柴翅胆衡淡塘拐销救姥敏素胃伴扶辑狂旬鬼摩劝炸滴绳构索厂架德倡含插臭递唉摘派仿腰旦灰煮豫沟模湿壶慰摇馒叉强辈燃醋奈晕废傻虹嫩统陌卷乖砍巴浅违庆寿杀厘状幻捐碎瞎厢席闲浏阵娶凭措剪昆乙善陆妇践苗珍雾拳喷拆集途摄击初促潮猾令迹姻痛政嗯乏饰披圆煤狡智恶征述腐哎戒斜训屿归怨肩押欠摆村绸猪权背辩纳劲肃驶憾矛幼涨膀移辅股产隔缓软锅抓厦滑胶裔撞贷立独亿链齐瞧摸源寂胜忍触盼品玻浓烫俗敌蜜铃竹造罚访企类损闯账私趁愧慧冻兼络稳官哲')
hanziSHSK6=set('谋撒颠牵庸眯祥嫉扒疫衰框肴盟魔灌予钝抵杰唤揭搭灶膛郎挎纤赠央颈腾毁汰摧垫奏筹蒸皱暴亡驰垄扎踊撑墓柱勾氓恰谎攻铺堂兜舱岩梁呈黎贪蹋拢挽侄刊贩溅叭烛赴拖痪惩铸冤眶尴膨剂债丘稚械筒腥橙讶敞督诞捷昂昌蔽酬屑惧谤筋讳昔惑啥荤夺俐劈耸恒欲蹈诸滔遮滥岳竭辉牧署泊唐胎辙萌凹丙坝簸抑焰野氏症巩嗅泡惰呕朴溜尬贼拟嗦诽叠悟川薪侵舶滤患疏混凝丁斯锲额迈旨茎疆窜潇枚翼拣惹伦拙愤芒抛譬炎咙盲嵌奢稀卑循棉畜秃掏慨渣贯暧捆诺旋淀屏墨骚圣泻庇陈露蚂朽婪乳坡勉挨赤啰惦纠喇锐哗蚀帆胞烘焦乞忧捍伶祸异顽讥役掷融怠壤渡蓄盛逢晋履剖扯晤舌卓挠溶轰塌诧湖拔宏扭疾浑蕾勘仗馋贤宅覆苍砸伏辫窝颤罪炉愈沾蒂钉哄颖钻晃喘衷僵横液瞄虐仪吉崖袍笼壳拽舰辱盗宇躬曲菌亦跨遣墟宪畔濒喉镶萎腹爽撇咋痹俭阱稿唾陵哨膜拓哇梢艘苏纺衍丛凶粹舟倦杖斑岔澄捞旷喻鞠瞩撤澈饥罕瘾嫌粒稻胀隘臂辟瀑罐霞吟坑粥毅串帝侠端幢侣惮箭涉珠芽洪酗溪伐墅搁若栽纽迄添坛诬仰诫绒赖瞪躁庄泌饲妆狱廊奠峰恕诈侦缝奥捏昼遥肺奴郑纹啦庞卸佣浊脉讯谣谜兽赋赌揉攀瘩旺霍唇拧凡漆遭岗陶驻谐稼侈恩昧蔓悬熄饪陋徘轨耻疙兢侨砖御湾叛枝赁韧颇睬惨宰辐攒蠢隆削董寸捉赂皆怒畴丸径蹬陷剥凑田熨吼犯曝嗨抚鄙逝奔嘿崭耍盯搅呻贫抗沿辽翔栏耕旗君辨尸沐隶洁蜡牲扣倘仙雕艇掘灭惫缉探鸦嘛秤牺弥鸣桑猛佳儒缠藐罢吞柬鸽乌肖沸瞻筐辖婴忌磕荒伍阔犬贿椭掩滋癌辰殿孔岂罩爆钩肪忠伺垂崩诱锈斩酿氧愣歧肿逼涩隧袭瞒剔睦隙枕碌凸捣怖哑甘雹睹瓦锦堡殴沃蔚酝跌吊茫裕饶协宗弊波堪缴竖坟党叹谱沫洽琢脂蓬缚茂鉴纬挚猎浮残擅郁镇谍紊雀劫拄愚峭泄臣割莫谷寝蔼耀炫淆巡纵跪弦券栋耗溉淹殖捎媳宫隐崇榜阂嫂绎狼觅绣悦钦牢恍株峻驱腔搀杠蕴啬杜仇捕嘲裂慈帖堕煎渺狭妥塞钞祖咀衔沮丧抒蹦绑雇淋诵枯滞桨葬喧廓讼援塔瞬沼拘腻汹廉捧妒闷晶奉掐挪谴窍揍舔蛮碳沛彰窃抹侮嘱悼熏泣帜啸埋斟憋储翘霸灿旱肆惋哼趴迸唆搂拌蒙苟涮誓涌馅涕缀姆枉挖渔烁棍磁妄哆虏锤搓溃津倔仁晾磅磋涛凄嚼泽吩疤尖颂偏逆掰泰障眨斥狈遏魄筛叼盈娃巢炊州谬袱截逊叨坠踪庙啃荡丐徙寺巷倾唠瘤拨伪兆叮绅瓣椎魂监逮缔贬孤浴衅驳馈徒雅誉畅审副踏俯勃肢策嚷辜甭煌屡瘸穴摊皇铭颁阐撼裳泥敷篷粉噪峡挫禽聋潜擎痕棕绘晰瓷渠扁扛井宙缘侃咽刹搏伯歹扑蚁雌番侥惕俘碑携舆吝晨霜宵侧港咐晓辕迁锋亭哺稠哀鲁暄烹吁钙铜膝仓蔑酷沧袖昏壮僻磨畏慷陡哦呵掀欺渗剑酌堤刑徊娇榨瘫嘈帐浸掠狠怯涵杆滨殃屁')
hanziSHSK=hanziSHSK1|hanziSHSK2|hanziSHSK3|hanziSHSK4|hanziSHSK5|hanziSHSK6

# HSK, the following seem incorrect, not sure whether they are old HSK (pre 2010)
hanziSHSK1old=set("的一是在了有人不国中大年上这个我和日时会出来他家生们对期月多能本学现说作电前下开天北京分高都工子小面机同车关名里好没明看点起星些三很去商今么样那东想西水影话视你果老二院女她认打做先少回系四气十服再儿住什书米师五见客热买医爱太校昨站觉候飞钱字岁友请识火听兴习语脑六店午写喜读馆欢怎吃杯钟八呢租块谁吗叫亮哪朋妈坐汉饭衣雨九冷七姐谢菜零爸睡喝茶猫桌狗漂椅喂苹")
hanziSHSK2old=set("为到以公行就新经也场第可过自得报进动还司最所外但长员次体等着已间因比手表两意务正房问门球题教路告件运给常每乐身别张让走色真它息非足始马考准完共游望票步备快病号孩便百诉介白红试边远旅助男离找思夫晚希眼室汽卖早药班绍歌送黑左右千您答帮舞笑错课唱雪吧纸休牛哥穿贵姓迎跑玩洗船跳妻鱼宜忙慢肉弟床旁篮圆奶妹羊斤阴丈泳鸡懂睛蛋颜踢瓜晴啡咖")
hanziSHSK3old=set("市地要发者业成后于方用而法理事记主实定其文心目力当通位道如种重加然情化特提平网万据安只信赛世应相使向总物己数解该界周接近城调几办把结演感又选闻决示节空头口放求直单风南才变查或育议带难参较片环山条级易需举音李清注越居低包且容图花根历响段必声园超盘护照终除极普境楼满干半复阳算双银刚阿讲板突轻史虽练春检层健河戏拿黄角担短街奇愿香康择害乎画换须差季酒简遇久跟辆般急云婚顾绩绿典背刻笔束夏树邮附旧鲜冰怕借静脚礼箱草趣牙坏净句灯努词脸冬蓝宾末敢秋楚耳镜惯烧忘冒舒怪爷搬祝迟熊鸟扫啊梯腿鞋邻糖哭刷厨炼骑帽葡萄疼聪甜爬鼻渴啤胖饱锻刮碗叔裤朵瘦糕衫汁伞衬澡饿矮姨裙铅筷蕉")
hanziSHSK4old=set("将部之全元美从内资民此利合品金价区入被展并度由保性制代海交台管活无费计及受科量至联证收格基式社术达规技专处程知各任原际组持剧首广尔消续观标导集指济连案拉造反取增整传克流改质士户具亚何许份供众售像光推深购获约况论研争则支确功象精即仅引失往奖职限责律林却纪优预警随究险速值亲神划列另艺志积效言评江降修排料负访底断景彩卡亿按死命故否严态验尽破村留仍织富航谈批范够围省洲继伤判适申播假切止农竞例绝察福养群停招母印油食压减货紧括密父免材激细互软签温甚悉味博疑著族座弹桥吸松血沙丽币缺丰码毕永章授坚微毛危竟困苦皮恐逐映洋虑顺秀肯惊败折杂础讨染顿幸润熟输既乘童序怀扩浪散梦钢概扬误释禁宽针尤污距渐掉森遍龄乱墙键齐脱翻估窗漫掌握赢烟醒鼓勇挂厚植戴暖叶聘硬符累虎奋篇弃诚暂饮抽麻默励暗汗塑替址拒巧挺撞偶琴抱尊闹骗辛聊邀忆烦刀寄译贺忽允详嘴尝肥寒泪袋耐扰傅剩垃圾赚阅扮页弄瓶肤惜呀汤填酸陪貌帅猜仔丢湿孤羽稍堵穷盒俩凉粗硕暑咱幽谊猪厉擦饼敲桶抬傲盐慕歉悔乒逛辣猴恼窄扔躺棵拾骄愉肚泼吵戚巾匙厌乓钥怜燥羡羞懒谅膏咸笨饺咳柿袜嗽")
hanziSHSK5old=set("与产股队建政更设华投线立强企版战军统局王布权团项装德形青英领营委势采销型创显转未均类府卫款牌称施率义协治存配巴构曾置击模益维器防升龙致摄念源庭宣官初承落财策讯拍素某厂属石令届训依古武胜占状待测余套录充土派独铁筑执登临控朝税幅犯威宝露革培轮域良冲移劳托损罪席似屋迷救县庆退善巨融补追贸尚毒编征夜付核透杀略询宁纷厅汇田烈塔疗裁涨呼冠稳幕倒兵操木藏靠挥惠析述拥违含雷射寻哈架私订餐陆赶频乡贷震秘荣抢抗伟偿孙智守顶野享封胡妇饰促赔挑综召炸斗遗库延俱坦贝措岛玉盖途启档灵雄避甲弱痛阵趋览罚抓迅咨献迹载枪驶旦册沉驾麦贴摩纯侵伙谓触滑聚固恶娱骨倍伴残宇棋搞劲殊缩拆丁敏圈逃誉凭疾毫亏摆虚刺繁嘉乏缓辑阻舍跃闭佛丝偷赞返豪欣怖灾凡祖炒赏泉狂捐燃缘迫锁液隔恢岸沟珍彻泛诊皇衡紫卷横递池闲淡洞尾振恋宗矿诗郊账籍摇腐盾悲废辞煤俗敬柜灭宿敌虹秒艰浓佩描豆忍寿帝氛璃娘慧玻践绪寓幼挡吨仿绕薄妙碍俊唯链碰勤铜姻矛堆柔尘披脏壁挤拜灰辩摸慎贡胁彼悄拳胆劣辅插荐漏姑喊犹欠粮匹喷涂奈卧疲闪伸胶竹锅肃滚辈艳摘挣炮尖戒疯扶碎牵旬苗鼠兄寺怒慰憾呆颗腰吹幻魅谨愤冻庙糊厘秩倡锐烂尺肩桃宠胸厕飘乙遵姿哲磁漠弯雾朴夕脆雇盼眠骂棒闯匆劝夹恨浅屈丑鬼吐铃纲肌蛇陌狼躲吓棉厢蔬粒滩盆眉剪悠鸭斜夸蜂柴胃摔绳拦嫁寂醉咬臭慌妨滴拐膀豫烤肺罐砍逻宴洒叉炭叙嫩抄傻催趁谜歇趟蜜浏骤愁粘晒吻矩梨蝶糟踩宙佣裔捡晕酱傍霉舌毯嘱姥寞歪睁畏裹瞧撕帘甩愧抖翅煮鞭谦烫绸耽乖钓兔脖浇蜡髦逗嗓鸽壶蹲匀恳橡椒删枕讽梳烛痒舅膊蝴娶醋瞎胳嚷丙勺煎狡皂咐唉屉猾馒桔惭嚏阶")
hanziSHSK6old=set("斯奥欧州党络监券陈央纳审额副波港媒索曲佳跌诺苏湖董探爆吉异盟攻峰晓予坛庄亡镇宅患障堂刑遭涉刊暴鲁夺盛湾伦晨债泰归杰姆端津若川宫泽潮莫隆蒙雅锋潜仪塞厦瓦援督郑截旗侧梁宏储辉朗抵伯偏迁恩驻筹焦症鉴奔洁隐洪嫌唐锦岗井稿杜沿搜圣珠昌拨赴谋盗混乌伍荡栏黎径仓扣捕兼袭署呈欲谷盈跨奏兑纽倾贫扎榜坡滋凌屏毁捷陷淀桑蒂踪颁缴壮揭徒拟诸轨赠纠廉胞撑忠搭铺押祥番剂涛颇磨讼摊孔崇枚渡拼仁忧恰拓腾浮猛狱悬劫疫薪渠畅贯岩虫辽晶拔墨侦昆胎沃迈毅甘拖巡恒泥陶撤添赖踏雕亦粉泡裂峡炎霍携诞耗挖轰魔寸郎酷肖旋抛颖驱纵蓄艇氏伪炉愈墓逢惨疆砖鸣逼淘堡绘循钻菌贩霸遥丧氧涌娃臣婆癌诱惑掘婴尸械覆吊耀叹驰舰庞旺柱伏阔箭栋扭凶奉堪绑盲贪晰埋牢衰漆履抑滨涵翼役杆逊孕吁悦荒侠郁煌昂兆汰怨猎窃稀酬蹈串裕殖凝缝挫脉壳攀旨峻扑碑勃抚欺膜贿仙御乳伐帐割霞撒赁屡狮祸瓷诈挪衷舱犬舟浴罢痕疏泄赌舆拘妆歧魂辐掩陵腹晋牲窝亭牧廊斑脂艘捧啦岳帆卓弊搏弥茂垄粹匪坑逮泊仰刹赤闷妥洽噪砸纹渔铭垂捞庸框葬惩掀纤笼宪辰辟滞滥枝皆肿纺赋睹慨谱爽牺塌昏擅巩丛绎辨悟贤翔罕腔墅袖饲酿臂沫尴尬惧迄斥狠齿顽垫慈胀掏颈哨剥辖仇淋捉削坝盯凑辱曝忌扇罩挽誓谐筒钦叛骚喻灿衔灌吞逝遮敞瘾沸哀歹渗缠侨挨苍勾巷晃筋兽荧遣驳绒碧旱殿躁冤惹贬溜浑嘛塘宰谎钞株腻抹孝昔茫瘤肢仗蒸瞩碳肆耕奠溪卸狭碌螺勘贼幢崩浸稻膨叠壤彰晤棍脾谍惕堤馈绣蕴崭诵擎栽蓬弦颠呵畜谴竭钉娇缔扒讶凸沧枯扯霜沾帜喘钩丘捆蔽溃澄铸肪琢兜熬膝哑虐蚀杠丸摧侣媳阐搁愚锈辜谣瞒芒耍蔓穴遏蹦芦蛮篷竖剖宵魄磅奢酝瘫攒讳哄磋勉俐焰唇滤啥僵衍隙淹俘搅耻剔殴悼昼喉崖聋溶嵌岂赂卑饥倦扛咽灶颂斩奴泌萌恭坟拢喇皱愣濒掠俭惫嫂陋畔馅徊捏稚叭烹觅柬熏飙雌辙屁韧嘲屑跪泻袍镶禽隶筛隧趴挠啸烁沛橙滔畴颤吟芽棕渣锤扁诫挚纬掷氓叮咋僻汹瞪妄饶氢旷缀痪枉俯捣叨昧凹澈恍袱蠢椎抒耸窜陡踊瞻吼瀑帖翘哇侮墟睦憋粥嘿呕沐缚嚼猖葫凄疤腥勿鞠朽沮哎拌妒磕熄捍廓怠烘肴堕兢紊哦甭侈乞秃哺筐怯绅拽苟嗅庇屿伺饪敷拧渺譬哼舶惦桨溅簸慷谬眶涮沼秤恕拙掐躬拣眯劈蹬搀搓揉搂嫉唠晾诧眨哟殃辫惋浊酌涕唾梢淆啃虏衅杖徙岔蔑腮伶痹鄙溉疙雹嘈诬谤峭掰咀丐嗦诽暧吝婪睬酗裳膛隘捎蔼哆稠榨挎茎惰迸惮狈躇馋椭踌讥舔嗨熨斟咙暄叼嗯呻唆阂拄啬瘸吩蹋锲揍啰")
hanziSHSKold=hanziSHSK1old|hanziSHSK2old|hanziSHSK3old|hanziSHSK4old|hanziSHSK5old|hanziSHSK6old

# HSK Vocabulary words
# TODO: check whether the following is old or new HSK vocabulary
hanziSHSK_vocabulary=[
    ['爱','八','爸爸','杯子','北京','本','不','不客气','菜','茶','吃','出租车','打电话','大','的','点','电脑','电视','电影','东西','都','读','对不起','多','多少','儿子','二','饭店','飞机','分钟','高兴','个','工作','狗','汉语','好','号','喝','和','很','后面','回','会','几','家','叫','今天','九','开','看','看见','块','来','老师','了','冷','里','六','妈妈','吗','买','猫','没关系','没有','米饭','名字','明天','哪','哪儿','那','呢','能','你','年','女儿','朋友','漂亮','苹果','七','前面','钱','请','去','热','人','认识','三','商店','上','上午','少','谁','什么','十','时候','是','书','水','水果','睡觉','说','四','岁','他','她','太','天气','听','同学','喂','我','我们','五','喜欢','下','下午','下雨','先生','现在','想','小','小姐','些','写','谢谢','星期','学生','学习','学校','一','一点儿','衣服','医生','医院','椅子','有','月','再见','在','怎么','怎么样','这','中国','中午','住','桌子','字','昨天','坐','做'],
    ['吧','白','百','帮助','报纸','比','别','宾馆','长','唱歌','出','穿','次','从','错','打篮球','大家','到','得','等','弟弟','第一','懂','对','对','房间','非常','服务员','高','告诉','哥哥','给','公共汽车','公司','贵','过','还','孩子','好吃','黑','红','火车站','机场','鸡蛋','件','教室','姐姐','介绍','进','近','就','觉得','咖啡','开始','考试','可能','可以','课','快','快乐','累','离','两','零','路','旅游','卖','慢','忙','每','妹妹','门','面条','男','您','牛奶','女','旁边','跑步','便宜','票','妻子','起床','千','铅笔','晴','去年','让','日','上班','身体','生病','生日','时间','事情','手表','手机','说话','送','虽然……但是……','它','踢足球','题','跳舞','外','完','玩','晚上','往','为什么','问','问题','西瓜','希望','洗','小时','笑','新','姓','休息','雪','颜色','眼睛','羊肉','药','要','也','一起','一下','已经','意思','因为……所以……','阴','游泳','右边','鱼','远','运动','再','早上','丈夫','找','着','真','正在','知道','准备','走','最','左边'],
    ['阿姨','啊','矮','爱好','安静','把','班','搬','办法','办公室','半','帮忙','包','饱','北方','被','鼻子','比较','比赛','笔记本','必须','变化','别人','冰箱','不但……而且……','菜单','参加','草','层','差','超市','衬衫','成绩','城市','迟到','除了','船','春','词典','聪明','打扫','打算','带','担心','蛋糕','当然','地','灯','地方','地铁','地图','电梯','电子邮件','东','冬','动物','短','段','锻炼','多么','饿','耳朵','发','发烧','发现','方便','放','放心','分','附近','复习','干净','感冒','感兴趣','刚才','个子','根据','跟','更','公斤','公园','故事','刮风','关','关系','关心','关于','国家','过','过去','还是','害怕','黑板','后来','护照','花','花','画','坏','欢迎','还','环境','换','黄河','回答','会议','或者','几乎','机会','极','记得','季节','检查','简单','见面','健康','讲','教','角','脚','接','街道','节目','节日','结婚','结束','解决','借','经常','经过','经理','久','旧','句子','决定','可爱','渴','刻','客人','空调','口','哭','裤子','筷子','蓝','老','离开','礼物','历史','脸','练习','辆','聊天','了解','邻居','留学','楼','绿','马','马上','满意','帽子','米','面包','明白','拿','奶奶','南','难','难过','年级','年轻','鸟','努力','爬山','盘子','胖','皮鞋','啤酒','瓶子','其实','其他','奇怪','骑','起飞','起来','清楚','请假','秋','裙子','然后','热情','认为','认真','容易','如果','伞','上网','生气','声音','世界','试','瘦','叔叔','舒服','树','数学','刷牙','双','水平','司机','太阳','特别','疼','提高','体育','甜','条','同事','同意','头发','突然','图书馆','腿','完成','碗','万','忘记','为','为了','位','文化','西','习惯','洗手间','洗澡','夏','先','相信','香蕉','向','像','小心','校长','新闻','新鲜','信用卡','行李箱','熊猫','需要','选择','要求','爷爷','一般','一边','一定','一共','一会儿','一样','一直','以前','音乐','银行','饮料','应该','影响','用','游戏','有名','又','遇到','元','愿意','月亮','越','站','张','长','着急','照顾','照片','照相机','只','只','只有……才……','中间','中文','终于','种','重要','周末','主要','注意','自己','自行车','总是','嘴','最后','最近','作业'],
    ['爱情','安排','安全','按时','按照','百分之','棒','包子','保护','保证','报名','抱','抱歉','倍','本来','笨','比如','毕业','遍','标准','表格','表示','表演','表扬','饼干','并且','博士','不得不','不管','不过','不仅','部分','擦','猜','材料','参观','餐厅','厕所','差不多','长城','长江','尝','场','超过','成功','成为','诚实','乘坐','吃惊','重新','抽烟','出差','出发','出生','出现','厨房','传真','窗户','词语','从来','粗心','存','错误','答案','打扮','打扰','打印','打招呼','打折','打针','大概','大使馆','大约','大夫','戴','当','当时','刀','导游','到处','到底','倒','道歉','得意','得','登机牌','等','低','底','地点','地球','地址','调查','掉','丢','动作','堵车','肚子','短信','对话','对面','对于','儿童','而','发生','发展','法律','翻译','烦恼','反对','方法','方面','方向','房东','放弃','放暑假','放松','份','丰富','否则','符合','父亲','付款','负责','复印','复杂','富','改变','干杯','赶','敢','感动','感觉','感情','感谢','干','刚','高速公路','胳膊','各','工资','公里','功夫','共同','购物','够','估计','鼓励','故意','顾客','挂','关键','观众','管理','光','广播','广告','逛','规定','国籍','国际','果汁','过程','海洋','害羞','寒假','汗','航班','好处','好像','号码','合格','合适','盒子','后悔','厚','互联网','互相','护士','怀疑','回忆','活动','活泼','火','获得','积极','积累','基础','激动','及时','即使','计划','记者','技术','既然','继续','寄','加班','加油站','家具','假','价格','坚持','减肥','减少','建议','将来','奖金','降低','降落','交','交流','交通','郊区','骄傲','饺子','教授','教育','接受','接着','节','节约','结果','解释','尽管','紧张','进行','禁止','京剧','经济','经历','经验','精彩','景色','警察','竞争','竟然','镜子','究竟','举','举办','举行','拒绝','距离','聚会','开玩笑','开心','看法','考虑','烤鸭','科学','棵','咳嗽','可怜','可是','可惜','客厅','肯定','空','空气','恐怕','苦','矿泉水','困','困难','垃圾桶','拉','辣','来不及','来得及','来自','懒','浪费','浪漫','老虎','冷静','礼拜天','礼貌','理发','理解','理想','力气','厉害','例如','俩','连','联系','凉快','零钱','另外','留','流利','流行','旅行','律师','乱','麻烦','马虎','满','毛','毛巾','美丽','梦','迷路','密码','免费','秒','民族','母亲','目的','耐心','难道','难受','内','内容','能力','年龄','弄','暖和','偶尔','排队','排列','判断','陪','批评','皮肤','脾气','篇','骗','乒乓球','平时','破','葡萄','普遍','普通话','其次','其中','气候','千万','签证','敲','桥','巧克力','亲戚','轻','轻松','情况','穷','区别','取','全部','缺点','缺少','却','确实','然而','热闹','任何','任务','扔','仍然','日记','入口','散步','森林','沙发','伤心','商量','稍微','勺子','社会','申请','深','甚至','生活','生命','生意','省','剩','失败','失望','师傅','十分','实际','实在','使','使用','世纪','是否','适合','适应','收','收入','收拾','首都','首先','受不了','受到','售货员','输','熟悉','数量','数字','帅','顺便','顺利','顺序','说明','硕士','死','速度','塑料袋','酸','随便','随着','孙子','所有','台','抬','态度','谈','弹钢琴','汤','糖','躺','趟','讨论','讨厌','特点','提','提供','提前','提醒','填空','条件','停','挺','通过','通知','同情','同时','推','推迟','脱','袜子','完全','网球','网站','往往','危险','卫生间','味道','温度','文章','污染','无','无聊','无论','误会','西红柿','吸引','咸','现金','羡慕','相反','相同','香','详细','响','橡皮','消息','小吃','小伙子','小说','笑话','效果','心情','辛苦','信封','信息','信心','兴奋','行','醒','幸福','性别','性格','修理','许多','学期','压力','呀','牙膏','亚洲','严格','严重','研究','盐','眼镜','演出','演员','阳光','养成','样子','邀请','要是','钥匙','也许','叶子','页','一切','以','以为','艺术','意见','因此','引起','印象','赢','应聘','永远','勇敢','优点','优秀','幽默','尤其','由','由于','邮局','友好','友谊','有趣','于是','愉快','与','羽毛球','语法','语言','预习','原来','原谅','原因','约会','阅读','云','允许','杂志','咱们','暂时','脏','责任','增加','占线','招聘','照','真正','整理','正常','正好','正确','正式','证明','之','支持','知识','直接','值得','职业','植物','只好','只要','指','至少','质量','重','重点','重视','周围','主意','祝贺','著名','专门','专业','转','赚','准确','准时','仔细','自然','自信','总结','租','最好','尊重','左右','作家','作用','作者','座','座位'],
    ['哎','唉','爱护','爱惜','爱心','安慰','安装','岸','暗','熬夜','把握','摆','办理','傍晚','包裹','包含','包括','薄','宝贝','宝贵','保持','保存','保留','保险','报到','报道','报告','报社','抱怨','背','悲观','背景','被子','本科','本领','本质','比例','彼此','必然','必要','毕竟','避免','编辑','鞭炮','便','辩论','标点','标志','表达','表面','表明','表情','表现','冰激凌','病毒','玻璃','播放','脖子','博物馆','补充','不安','不得了','不断','不见得','不耐烦','不然','不如','不要紧','不足','布','步骤','部门','财产','采访','采取','彩虹','踩','参考','参与','惭愧','操场','操心','册','测验','曾经','叉子','差距','插','拆','产品','产生','长途','常识','抄','超级','朝','潮湿','吵','吵架','炒','车库','车厢','彻底','沉默','趁','称','称呼','称赞','成分','成果','成就','成立','成人','成熟','成语','成长','诚恳','承担','承认','承受','程度','程序','吃亏','池塘','迟早','持续','尺子','翅膀','冲','充电器','充分','充满','重复','宠物','抽屉','抽象','丑','臭','出版','出口','出色','出示','出席','初级','除非','除夕','处理','传播','传染','传说','传统','窗帘','闯','创造','吹','词汇','辞职','此外','次要','刺激','匆忙','从此','从而','从前','从事','粗糙','促进','促使','醋','催','存在','措施','答应','达到','打工','打交道','打喷嚏','打听','大方','大厦','大象','大型','呆','代表','代替','贷款','待遇','担任','单纯','单调','单独','单位','单元','耽误','胆小鬼','淡','当地','当心','挡','导演','导致','岛屿','倒霉','到达','道德','道理','登记','等待','等于','滴','的确','敌人','地道','地理','地区','地毯','地位','地震','递','点心','电池','电台','钓','顶','动画片','冻','洞','豆腐','逗','独立','独特','度过','断','堆','对比','对待','对方','对手','对象','兑换','吨','蹲','顿','多亏','多余','朵','躲藏','恶劣','耳环','发表','发愁','发达','发抖','发挥','发明','发票','发言','罚款','法院','翻','繁荣','反而','反复','反应','反映','反正','范围','方','方案','方式','妨碍','仿佛','非','肥皂','废话','分别','分布','分配','分手','分析','纷纷','奋斗','风格','风景','风俗','风险','疯狂','讽刺','否定','否认','扶','服装','幅','辅导','妇女','复制','改革','改进','改善','改正','盖','概括','概念','干脆','干燥','赶紧','赶快','感激','感受','感想','干活儿','钢铁','高档','高级','搞','告别','格外','隔壁','个别','个人','个性','各自','根','根本','工厂','工程师','工具','工人','工业','公布','公开','公平','公寓','公元','公主','功能','恭喜','贡献','沟通','构成','姑姑','姑娘','古代','古典','股票','骨头','鼓舞','鼓掌','固定','挂号','乖','拐弯','怪不得','关闭','观察','观点','观念','官','管子','冠军','光滑','光临','光明','光盘','广场','广大','广泛','归纳','规矩','规律','规模','规则','柜台','滚','锅','国庆节','国王','果然','果实','过分','过敏','过期','哈','海关','海鲜','喊','行业','豪华','好客','好奇','合法','合理','合同','合影','合作','何必','何况','和平','核心','恨','猴子','后背','后果','呼吸','忽然','忽视','胡说','胡同','壶','蝴蝶','糊涂','花生','划','华裔','滑','化学','话题','怀念','怀孕','缓解','幻想','慌张','黄金','灰','灰尘','灰心','挥','恢复','汇率','婚礼','婚姻','活跃','火柴','伙伴','或许','机器','肌肉','基本','激烈','及格','极其','急忙','急诊','集合','集体','集中','计算','记录','记忆','纪录','纪律','纪念','系领带','寂寞','夹子','家庭','家务','家乡','嘉宾','甲','假如','假设','假装','价值','驾驶','嫁','坚决','坚强','肩膀','艰巨','艰苦','兼职','捡','剪刀','简历','简直','建立','建设','建筑','健身','键盘','讲究','讲座','酱油','交换','交际','交往','浇','胶水','角度','狡猾','教材','教练','教训','阶段','结实','接触','接待','接近','节省','结构','结合','结论','结账','戒','戒指','届','借口','金属','尽快','尽量','紧急','谨慎','尽力','进步','进口','近代','经典','经商','经营','精力','精神','酒吧','救','救护车','舅舅','居然','桔子','巨大','具备','具体','俱乐部','据说','捐','决赛','决心','角色','绝对','军事','均匀','卡车','开发','开放','开幕式','开水','砍','看不起','看望','靠','颗','可见','可靠','可怕','克','克服','刻苦','客观','课程','空间','空闲','控制','口味','夸','夸张','会计','宽','昆虫','扩大','辣椒','拦','烂','朗读','劳动','劳驾','老百姓','老板','老婆','老实','老鼠','姥姥','乐观','雷','类型','冷淡','厘米','离婚','梨','理论','理由','力量','立即','立刻','利润','利息','利益','利用','连忙','连续','联合','恋爱','良好','粮食','亮','了不起','列车','临时','灵活','铃','零件','零食','领导','领域','浏览','流传','流泪','龙','漏','陆地','陆续','录取','录音','轮流','论文','逻辑','落后','骂','麦克风','馒头','满足','毛病','矛盾','冒险','贸易','眉毛','媒体','煤炭','美术','魅力','梦想','秘密','秘书','密切','蜜蜂','面对','面积','面临','苗条','描写','敏感','名牌','名片','名胜古迹','明确','明显','明星','命令','命运','摸','模仿','模糊','模特','摩托车','陌生','某','木头','目标','目录','目前','哪怕','难怪','难免','脑袋','内部','内科','嫩','能干','能源','嗯','年代','年纪','念','宁可','牛仔裤','农村','农民','农业','浓','女士','欧洲','偶然','拍','派','盼望','培训','培养','赔偿','佩服','配合','盆','碰','批','批准','披','疲劳','匹','片','片面','飘','拼音','频道','平','平安','平常','平等','平方','平衡','平静','平均','评价','凭','迫切','破产','破坏','期待','期间','其余','奇迹','企业','启发','气氛','汽油','谦虚','签','前途','浅','欠','枪','强调','强烈','墙','抢','悄悄','瞧','巧妙','切','亲爱','亲切','亲自','勤奋','青','青春','青少年','轻视','轻易','清淡','情景','情绪','请求','庆祝','球迷','趋势','取消','娶','去世','圈','权力','权利','全面','劝','缺乏','确定','确认','群','燃烧','绕','热爱','热烈','热心','人才','人口','人类','人民币','人生','人事','人物','人员','忍不住','日常','日程','日历','日期','日用品','日子','如何','如今','软','软件','弱','洒','嗓子','色彩','杀','沙漠','沙滩','傻','晒','删除','闪电','扇子','善良','善于','伤害','商品','商务','商业','上当','蛇','舍不得','设备','设计','设施','射击','摄影','伸','身材','身份','深刻','神话','神秘','升','生产','生动','生长','声调','绳子','省略','胜利','失眠','失去','失业','诗','狮子','湿润','石头','时差','时代','时刻','时髦','时期','时尚','实话','实践','实习','实现','实验','实用','食物','使劲儿','始终','士兵','市场','似的','事实','事物','事先','试卷','收获','收据','手工','手术','手套','手续','手指','首','寿命','受伤','书架','梳子','舒适','输入','蔬菜','熟练','属于','鼠标','数','数据','数码','摔倒','甩','双方','税','说不定','说服','丝绸','丝毫','私人','思考','思想','撕','似乎','搜索','宿舍','随身','随时','随手','碎','损失','缩短','所','锁','台阶','太极拳','太太','谈判','坦率','烫','逃','逃避','桃','淘气','讨价还价','套','特色','特殊','特征','疼爱','提倡','提纲','提问','题目','体会','体贴','体现','体验','天空','天真','调皮','调整','挑战','通常','统一','痛苦','痛快','偷','投入','投资','透明','突出','土地','土豆','吐','兔子','团','推辞','推广','推荐','退','退步','退休','歪','外公','外交','完美','完善','完整','玩具','万一','王子','网络','往返','危害','威胁','微笑','违反','围巾','围绕','唯一','维修','伟大','尾巴','委屈','未必','未来','位于','位置','胃','胃口','温暖','温柔','文件','文具','文明','文学','文字','闻','吻','稳定','问候','卧室','握手','屋子','无奈','无数','无所谓','武术','勿','物理','物质','雾','吸取','吸收','戏剧','系','系统','细节','瞎','下载','吓','夏令营','鲜艳','显得','显然','显示','县','现代','现实','现象','限制','相处','相当','相对','相关','相似','香肠','享受','想念','想象','项','项链','项目','象棋','象征','消费','消化','消极','消失','销售','小麦','小气','孝顺','效率','歇','斜','写作','血','心理','心脏','欣赏','信号','信任','行动','行人','行为','形成','形容','形式','形势','形象','形状','幸亏','幸运','性质','兄弟','胸','休闲','修改','虚心','叙述','宣布','宣传','学历','学术','学问','寻找','询问','训练','迅速','押金','牙齿','延长','严肃','演讲','宴会','阳台','痒','样式','腰','摇','咬','要不','业务','业余','夜','一辈子','一旦','一律','一再','一致','依然','移动','移民','遗憾','疑问','乙','以及','以来','亿','义务','议论','意外','意义','因而','因素','银','印刷','英俊','英雄','迎接','营养','营业','影子','应付','应用','硬','硬件','拥抱','拥挤','勇气','用功','用途','优惠','优美','优势','悠久','犹豫','油炸','游览','有利','幼儿园','娱乐','与其','语气','玉米','预报','预订','预防','元旦','员工','原料','原则','圆','愿望','乐器','晕','运气','运输','运用','灾害','再三','在乎','在于','赞成','赞美','糟糕','造成','则','责备','摘','窄','粘贴','展开','展览','占','战争','长辈','涨','掌握','账户','招待','着火','着凉','召开','照常','哲学','针对','珍惜','真实','诊断','阵','振动','争论','争取','征求','睁','整个','整齐','整体','正','证件','证据','政府','政治','挣','支','支票','执照','直','指导','指挥','至今','至于','志愿者','制定','制度','制造','制作','治疗','秩序','智慧','中介','中心','中旬','种类','重大','重量','周到','猪','竹子','逐步','逐渐','主持','主动','主观','主人','主任','主题','主席','主张','煮','注册','祝福','抓','抓紧','专家','专心','转变','转告','装','装饰','装修','状况','状态','撞','追','追求','咨询','姿势','资格','资金','资料','资源','紫','自从','自动','自豪','自觉','自私','自由','自愿','字母','字幕','综合','总裁','总共','总理','总算','总统','总之','阻止','组','组成','组合','组织','最初','醉','尊敬','遵守','作品','作为','作文'],
    ['挨','癌症','爱不释手','爱戴','暧昧','安宁','安详','安置','按摩','案件','案例','暗示','昂贵','凹凸','熬','奥秘','巴不得','巴结','扒','疤','拔苗助长','把关','把手','罢工','霸道','掰','摆脱','败坏','拜访','拜年','拜托','颁布','颁发','斑','版本','半途而废','扮演','伴侣','伴随','绑架','榜样','磅','包庇','包袱','包围','包装','饱和','饱经沧桑','保管','保密','保姆','保守','保卫','保养','保障','保重','报仇','报酬','报答','报复','报警','报销','抱负','暴力','暴露','曝光','爆发','爆炸','卑鄙','悲哀','悲惨','北极','贝壳','备份','备忘录','背叛','背诵','被动','被告','奔波','奔驰','本能','本钱','本人','本身','本事','笨拙','崩溃','甭','迸发','蹦','逼迫','鼻涕','比方','比喻','比重','鄙视','闭塞','弊病','弊端','臂','边疆','边界','边境','边缘','编织','鞭策','贬低','贬义','扁','变故','变迁','变质','便利','便条','便于','遍布','辨认','辩护','辩解','辩证','辫子','标本','标记','标题','表决','表态','表彰','憋','别墅','别致','别扭','濒临','冰雹','丙','并非','并列','拨','波浪','波涛','剥削','播种','伯母','博大精深','博览会','搏斗','薄弱','补偿','补救','补贴','捕捉','哺乳','不得已','不妨','不敢当','不顾','不禁','不堪','不可思议','不愧','不料','不免','不时','不惜','不相上下','不像话','不屑一顾','不言而喻','不由得','不择手段','不止','布告','布局','布置','步伐','部署','部位','才干','财富','财务','财政','裁缝','裁判','裁员','采购','采集','采纳','彩票','参谋','参照','残疾','残酷','残留','残忍','灿烂','仓促','仓库','苍白','舱','操劳','操练','操纵','操作','嘈杂','草案','草率','侧面','测量','策划','策略','层出不穷','层次','差别','插座','查获','岔','刹那','诧异','柴油','搀','馋','缠绕','产业','阐述','颤抖','昌盛','尝试','偿还','场合','场面','场所','敞开','畅通','畅销','倡导','倡议','钞票','超越','巢穴','朝代','嘲笑','潮流','撤退','撤销','沉淀','沉闷','沉思','沉重','沉着','陈旧','陈列','陈述','衬托','称心如意','称号','成本','成交','成天','成效','成心','成员','呈现','诚挚','承办','承包','承诺','城堡','乘','盛','惩罚','澄清','橙','秤','吃苦','吃力','迟钝','迟缓','迟疑','持久','赤道','赤字','冲动','冲击','冲突','充当','充沛','充实','充足','重叠','崇拜','崇高','崇敬','稠密','筹备','丑恶','出路','出卖','出身','出神','出息','初步','除','处分','处境','处置','储备','储存','储蓄','触犯','川流不息','穿越','传达','传单','传授','船舶','喘气','串','床单','创立','创新','创业','创作','吹牛','吹捧','炊烟','垂直','锤','纯粹','纯洁','慈善','慈祥','磁带','雌雄','次品','次序','伺候','刺','从容','丛','凑合','粗鲁','窜','摧残','脆弱','搓','磋商','挫折','搭','搭档','搭配','达成','答辩','答复','打包','打官司','打击','打架','打量','打猎','打仗','大不了','大臣','大伙儿','大肆','大体','大意','大致','歹徒','代价','代理','带领','怠慢','逮捕','担保','胆怯','诞辰','诞生','淡季','淡水','蛋白质','当场','当初','当代','当面','当前','当事人','当务之急','当选','党','档案','档次','导弹','导航','导向','捣乱','倒闭','盗窃','稻谷','得不偿失','得力','得天独厚','得罪','灯笼','登陆','登录','蹬','等候','等级','瞪','堤坝','敌视','抵达','抵抗','抵制','地步','地势','地质','递增','颠簸','颠倒','典礼','典型','点缀','电源','垫','惦记','奠定','叼','雕刻','雕塑','吊','调动','跌','丁','叮嘱','盯','定期','定义','丢人','丢三落四','东道主','东张西望','董事长','动荡','动机','动静','动力','动脉','动身','动手','动态','动员','冻结','栋','兜','陡峭','斗争','督促','毒品','独裁','堵塞','赌博','杜绝','端','端午节','端正','短促','断定','断绝','堆积','队伍','对策','对称','对付','对抗','对立','对联','对应','对照','兑现','顿时','多元化','哆嗦','堕落','额外','恶心','恶化','遏制','恩怨','而已','二氧化碳','发布','发财','发呆','发动','发觉','发射','发誓','发行','发炎','发扬','发育','法人','番','凡是','繁华','繁忙','繁体字','繁殖','反驳','反常','反感','反抗','反馈','反面','反射','反思','反问','反之','泛滥','范畴','贩卖','方位','方言','方圆','方针','防守','防御','防止','防治','访问','纺织','放大','放射','飞禽走兽','飞翔','飞跃','非法','肥沃','诽谤','肺','废除','废寝忘食','废墟','沸腾','分辨','分寸','分红','分解','分裂','分泌','分明','分歧','分散','吩咐','坟墓','粉末','粉色','粉碎','分量','愤怒','丰满','丰盛','丰收','风暴','风度','风光','风气','风趣','风土人情','风味','封闭','封建','封锁','锋利','逢','奉献','否决','夫妇','夫人','敷衍','服从','服气','俘虏','符号','幅度','辐射','福利','福气','抚摸','抚养','俯视','辅助','腐败','腐烂','腐蚀','腐朽','负担','附和','附件','附属','复活','复兴','副','赋予','富裕','腹泻','覆盖','改良','钙','盖章','干旱','干扰','干涉','干预','尴尬','感慨','感染','干劲','纲领','岗位','港口','港湾','杠杆','高超','高潮','高峰','高明','高尚','高涨','稿件','告辞','告诫','疙瘩','鸽子','搁','割','歌颂','革命','格局','格式','隔阂','隔离','个体','各抒己见','根深蒂固','根源','跟前','跟随','跟踪','更新','更正','耕地','工艺品','公安局','公道','公告','公关','公民','公然','公认','公式','公务','公正','公证','功劳','功效','攻击','攻克','供不应求','供给','宫殿','恭敬','巩固','共和国','共计','共鸣','勾结','钩子','构思','孤独','孤立','姑且','辜负','古董','古怪','股东','股份','骨干','鼓动','固然','固体','固有','固执','故乡','故障','顾虑','顾问','雇佣','拐杖','关怀','关照','观光','官方','管辖','贯彻','惯例','灌溉','罐','光彩','光辉','光芒','光荣','广阔','归根到底','归还','规范','规格','规划','规章','轨道','贵族','跪','棍棒','国防','国务院','果断','过度','过渡','过奖','过滤','过失','过问','过瘾','过于','嗨','海拔','海滨','含糊','含义','寒暄','罕见','捍卫','行列','航空','航天','航行','毫米','毫无','豪迈','号召','耗费','呵','合并','合成','合伙','合算','和蔼','和解','和睦','和气','和谐','嘿','痕迹','狠心','恨不得','横','哼','轰动','烘','宏观','宏伟','洪水','哄','喉咙','吼','后代','后顾之忧','后勤','候选','呼唤','呼啸','呼吁','忽略','胡乱','胡须','湖泊','花瓣','花蕾','华丽','华侨','化肥','化石','化验','化妆','划分','画蛇添足','话筒','欢乐','还原','环节','缓和','患者','荒凉','荒谬','荒唐','皇帝','皇后','黄昏','恍然大悟','晃','挥霍','辉煌','回报','回避','回顾','回收','悔恨','毁灭','汇报','会晤','贿赂','昏迷','荤','浑身','混合','混乱','混淆','混浊','活该','活力','火箭','火焰','火药','货币','讥笑','饥饿','机动','机构','机灵','机密','机械','机遇','机智','基地','基金','基因','激发','激励','激情','及早','吉祥','级别','极端','极限','即便','即将','急功近利','急剧','急切','急于求成','急躁','疾病','集团','嫉妒','籍贯','给予','计较','记性','记载','纪要','技巧','忌讳','季度','季军','迹象','继承','寄托','寂静','加工','加剧','夹杂','佳肴','家常','家伙','家属','家喻户晓','尖端','尖锐','坚定','坚固','坚韧','坚实','坚硬','艰难','监督','监视','监狱','煎','拣','检讨','检验','剪彩','简化','简陋','简体字','简要','见多识广','见解','见闻','见义勇为','间谍','间隔','间接','剑','健全','舰艇','践踏','溅','鉴别','鉴定','鉴于','将近','将就','将军','僵硬','奖励','奖赏','桨','降临','交叉','交代','交涉','交易','娇气','焦点','焦急','角落','侥幸','搅拌','缴纳','较量','教养','阶层','皆','接连','揭露','节制','节奏','杰出','结晶','结局','结算','截止','截至','竭尽全力','解除','解放','解雇','解剖','解散','解体','戒备','界限','借鉴','借助','金融','津津有味','紧迫','锦上添花','进而','进攻','进化','进展','近来','晋升','浸泡','茎','经费','经纬','惊动','惊奇','惊讶','兢兢业业','精打细算','精华','精简','精密','精确','精通','精心','精益求精','精致','井','颈椎','警告','警惕','竞赛','竞选','敬礼','敬业','境界','镜头','纠纷','纠正','酒精','救济','就近','就业','就职','拘留','拘束','居民','居住','鞠躬','局部','局面','局势','局限','咀嚼','沮丧','举动','举世瞩目','举足轻重','剧本','剧烈','据悉','聚精会神','卷','决策','觉悟','觉醒','绝望','倔强','军队','君子','卡通','开采','开除','开阔','开朗','开明','开辟','开拓','开展','开支','刊登','刊物','勘探','侃侃而谈','砍伐','看待','慷慨','扛','抗议','考察','考古','考核','考验','靠拢','科目','磕','可观','可口','可恶','可行','渴望','克制','刻不容缓','客户','课题','恳切','啃','坑','空洞','空前绝后','空想','空虚','孔','恐怖','恐吓','恐惧','空白','空隙','口气','口腔','口头','口音','扣','枯萎','枯燥','哭泣','苦尽甘来','苦涩','挎','跨','快活','宽敞','宽容','款待','款式','筐','旷课','况且','矿产','框架','亏待','亏损','捆绑','扩充','扩散','扩张','喇叭','蜡烛','啦','来历','来源','栏目','懒惰','狼狈','狼吞虎咽','捞','牢固','牢骚','唠叨','乐趣','乐意','雷达','类似','冷酷','冷落','冷却','愣','黎明','礼节','礼尚往来','里程碑','理睬','理所当然','理直气壮','理智','力求','力所能及','力争','历代','历来','立场','立方','立交桥','立体','立足','利害','例外','粒','连年','连锁','连同','联欢','联络','联盟','联想','廉洁','良心','谅解','晾','辽阔','列举','临床','淋','吝啬','伶俐','灵感','灵魂','灵敏','凌晨','零星','领会','领事馆','领土','领悟','领先','领袖','溜','留恋','留念','留神','流浪','流露','流氓','流通','聋哑','隆重','垄断','笼罩','搂','炉灶','屡次','履行','掠夺','轮船','轮廓','轮胎','论坛','论证','啰唆','络绎不绝','落成','落实','麻痹','麻木','麻醉','码头','蚂蚁','嘛','埋伏','埋没','埋葬','迈','脉搏','埋怨','蔓延','漫长','漫画','慢性','忙碌','盲目','茫茫','茫然','茂盛','冒充','冒犯','枚','媒介','美观','美满','美妙','萌芽','猛烈','眯','弥补','弥漫','迷惑','迷人','迷信','谜语','密度','密封','棉花','免得','免疫','勉励','勉强','面貌','面子','描绘','瞄准','渺小','藐视','灭亡','蔑视','民间','民主','敏捷','敏锐','名次','名额','名副其实','名誉','明明','明智','命名','摸索','模范','模式','模型','膜','摩擦','磨合','魔鬼','魔术','抹杀','莫名其妙','墨水儿','默默','谋求','模样','母语','目睹','目光','沐浴','拿手','纳闷儿','耐用','南辕北辙','难得','难堪','难能可贵','恼火','内涵','内幕','内在','能量','拟定','逆行','年度','捏','凝固','凝聚','凝视','拧','宁肯','宁愿','扭转','纽扣儿','农历','浓厚','奴隶','虐待','挪','哦','殴打','呕吐','偶像','趴','排斥','排除','排放','排练','徘徊','派别','派遣','攀登','盘旋','判决','畔','庞大','抛弃','泡沫','培育','配备','配偶','配套','盆地','烹饪','捧','批发','批判','劈','皮革','疲惫','疲倦','屁股','譬如','偏差','偏见','偏僻','偏偏','片断','片刻','漂浮','飘扬','撇','拼搏','拼命','贫乏','贫困','频繁','频率','品尝','品德','品质','品种','平凡','平面','平坦','平行','平庸','平原','评估','评论','屏幕','屏障','坡','泼','颇','迫不及待','迫害','破例','魄力','扑','铺','朴实','朴素','普及','瀑布','凄凉','期望','期限','欺负','欺骗','齐全','齐心协力','奇妙','歧视','旗袍','旗帜','乞丐','岂有此理','企图','启程','启蒙','启示','启事','起草','起初','起伏','起哄','起码','起源','气概','气功','气魄','气色','气势','气味','气象','气压','气质','迄今为止','器材','器官','掐','洽谈','恰当','恰到好处','恰巧','千方百计','迁就','迁徙','牵','牵扯','牵制','谦逊','签署','前景','前提','潜力','潜水','潜移默化','谴责','强制','抢劫','抢救','强迫','桥梁','窍门','翘','切实','锲而不舍','钦佩','侵犯','侵略','亲密','亲热','勤俭','勤劳','倾听','倾向','倾斜','清澈','清晨','清除','清洁','清理','清晰','清醒','清真','情报','情节','情理','情形','晴朗','请柬','请教','请示','请帖','丘陵','区分','区域','曲折','驱逐','屈服','渠道','曲子','取缔','趣味','圈套','权衡','权威','全局','全力以赴','拳头','犬','缺口','缺席','缺陷','瘸','确保','确立','确切','确信','群众','染','嚷','让步','饶恕','扰乱','惹祸','热泪盈眶','热门','人道','人格','人工','人家','人间','人士','人为','人性','人质','仁慈','忍耐','忍受','认定','认可','任命','任性','任意','任重道远','仍旧','日新月异','日益','荣幸','荣誉','容貌','容纳','容器','容忍','溶解','融化','融洽','柔和','揉','儒家','若干','弱点','撒谎','散文','散布','散发','丧失','骚扰','嫂子','刹车','啥','筛选','山脉','闪烁','擅长','擅自','伤脑筋','商标','上级','上进','上任','上瘾','上游','尚且','捎','梢','哨','奢侈','舌头','设立','设想','设置','社区','涉及','摄氏度','申报','呻吟','绅士','深奥','深沉','深情厚谊','神经','神奇','神气','神圣','神态','神仙','审查','审理','审美','审判','渗透','慎重','生存','生机','生理','生疏','生态','生物','生肖','生效','生锈','生育','声明','声势','声誉','牲畜','省会','胜负','盛产','盛开','盛情','盛行','尸体','失事','失误','失踪','师范','施加','施展','十足','石油','时常','时而','时光','时机','时事','识别','实惠','实力','实施','实事求是','实行','实质','拾','使命','示范','示威','示意','世代','势必','势力','事故','事迹','事件','事态','事务','事项','事业','试图','试验','视力','视频','视线','视野','是非','适宜','逝世','释放','收藏','收缩','收益','收音机','手法','手势','手艺','守护','首饰','首要','受罪','授予','书法','书籍','书记','书面','舒畅','疏忽','疏远','束','束缚','树立','竖','数额','耍','衰老','衰退','率领','涮火锅','双胞胎','爽快','水利','水龙头','水泥','瞬间','司法','司令','私自','思念','思索','思维','斯文','死亡','四肢','寺庙','饲养','肆无忌惮','耸','艘','苏醒','俗话','诉讼','素食','素质','塑造','算数','随即','随意','岁月','隧道','损坏','索取','索性','塌','踏实','塔','台风','太空','泰斗','贪婪','贪污','摊','瘫痪','弹性','坦白','叹气','探测','探索','探讨','探望','倘若','掏','滔滔不绝','陶瓷','陶醉','淘汰','讨好','特长','特定','特意','提拔','提炼','提示','提议','题材','体裁','体积','体谅','体面','体系','天才','天赋','天伦之乐','天然气','天生','天堂','天文','田径','田野','舔','挑剔','条款','条理','条约','调和','调剂','调节','调解','调料','挑拨','挑衅','跳跃','亭子','停泊','停顿','停滞','挺拔','通货膨胀','通缉','通俗','通讯','通用','同胞','同志','铜','童话','统筹兼顾','统计','统统','统治','投机','投票','投诉','投降','投掷','透露','秃','突破','图案','徒弟','途径','涂抹','土壤','团结','团体','团圆','推测','推翻','推理','推论','推销','吞吞吐吐','托运','拖延','脱离','妥当','妥善','妥协','椭圆','唾弃','挖掘','哇','娃娃','瓦解','歪曲','外表','外行','外界','外向','丸','完备','完毕','玩弄','玩意儿','顽固','顽强','挽回','挽救','惋惜','万分','往常','往事','妄想','危机','威风','威力','威望','威信','微不足道','微观','为难','为期','违背','唯独','维持','维护','维生素','伪造','委托','委员','卫星','未免','畏惧','喂','蔚蓝','慰问','温带','温和','文凭','文物','文献','文雅','文艺','问世','窝','乌黑','污蔑','诬陷','无比','无偿','无耻','无动于衷','无非','无辜','无精打采','无赖','无理取闹','无能为力','无穷无尽','无微不至','无忧无虑','无知','武器','武侠','武装','侮辱','舞蹈','务必','物美价廉','物业','物资','误差','误解','夕阳','昔日','牺牲','溪','熄灭','膝盖','习俗','袭击','媳妇','喜闻乐见','喜悦','系列','细胞','细菌','细致','峡谷','狭隘','狭窄','霞','下属','先进','先前','纤维','掀起','鲜明','闲话','贤惠','弦','衔接','嫌','嫌疑','显著','现场','现成','现状','线索','宪法','陷害','陷阱','陷入','馅儿','乡镇','相差','相等','相辅相成','相应','镶嵌','响亮','响应','想方设法','向导','向来','向往','巷','相声','削','消除','消毒','消防','消耗','消灭','销毁','潇洒','小心翼翼','肖像','效益','协会','协商','协调','协议','协助','携带','泄露','泄气','屑','谢绝','心得','心甘情愿','心灵','心态','心疼','心血','心眼儿','辛勤','欣慰','欣欣向荣','新陈代谢','新郎','新娘','新颖','薪水','信赖','信念','信仰','信誉','兴隆','兴旺','腥','刑事','行政','形态','兴高采烈','兴致勃勃','性感','性命','性能','凶恶','凶手','汹涌','胸怀','胸膛','雄厚','雄伟','修复','修建','修养','羞耻','绣','嗅觉','须知','虚假','虚荣','虚伪','需求','许可','序言','畜牧','酗酒','宣誓','宣扬','喧哗','悬挂','悬念','悬殊','悬崖峭壁','旋律','旋转','选拔','选举','选手','炫耀','削弱','学说','学位','雪上加霜','血压','熏陶','寻觅','巡逻','循环','循序渐进','压迫','压岁钱','压缩','压抑','压榨','压制','鸦雀无声','亚军','烟花爆竹','淹没','延期','延伸','延续','严寒','严禁','严峻','严厉','严密','言论','岩石','炎热','沿海','掩盖','掩护','掩饰','眼光','眼色','眼神','演变','演习','演绎','演奏','厌恶','验收','验证','氧气','样品','谣言','摇摆','摇滚','遥控','遥远','要点','要命','要素','耀眼','野蛮','野心','液体','一度','一帆风顺','一贯','一举两得','一流','一目了然','一如既往','一丝不苟','一向','衣裳','依旧','依据','依靠','依赖','依托','仪器','仪式','遗产','遗传','遗留','遗失','疑惑','以便','以免','以往','以至','以致','亦','异常','意料','意识','意图','意味着','意向','意志','毅力','毅然','翼','阴谋','音响','引导','引擎','引用','饮食','隐蔽','隐患','隐瞒','隐私','隐约','英明','英勇','婴儿','迎面','盈利','应酬','应邀','拥护','拥有','庸俗','永恒','勇于','涌现','踊跃','用户','优胜劣汰','优先','优异','优越','忧郁','犹如','油腻','油漆','有条不紊','幼稚','诱惑','渔民','愚蠢','愚昧','舆论','与日俱增','宇宙','羽绒服','玉','预料','预期','预算','预先','预言','预兆','欲望','寓言','愈','冤枉','元首','元素','元宵节','园林','原告','原理','原始','原先','圆满','缘故','源泉','约束','乐谱','岳母','孕育','运算','运行','酝酿','蕴藏','熨','杂技','杂交','砸','咋','灾难','栽培','宰','再接再厉','在意','攒','暂且','赞叹','赞助','遭受','遭殃','遭遇','糟蹋','造型','噪音','责怪','贼','增添','赠送','扎','扎实','渣','眨','诈骗','摘要','债券','沾光','瞻仰','斩钉截铁','展示','展望','展现','崭新','占据','占领','战斗','战略','战术','战役','章程','帐篷','障碍','招标','招收','朝气蓬勃','着迷','沼泽','照样','照耀','折腾','遮挡','折','折磨','侦探','珍贵','珍稀','珍珠','真理','真相','真挚','斟酌','枕头','阵地','阵容','振奋','振兴','震撼','震惊','镇定','镇静','正月','争端','争夺','争气','争先恐后','争议','征服','征收','挣扎','蒸发','整顿','正当','正负','正规','正经','正气','正义','正宗','证实','证书','郑重','政策','政权','症状','之际','支撑','支出','支流','支配','支援','支柱','枝','知觉','知足常乐','脂肪','执行','执着','直播','直径','侄子','值班','职能','职位','职务','殖民地','指标','指定','指甲','指令','指南针','指示','指望','指责','志气','制裁','制服','制约','制止','治安','治理','致辞','致力','致使','智力','智能','智商','滞留','中断','中立','中央','忠诚','忠实','终点','终究','终身','终止','衷心','肿瘤','种子','种族','众所周知','种植','重心','舟','州','周边','周密','周年','周期','周折','周转','粥','昼夜','皱纹','株','诸位','逐年','主办','主导','主管','主流','主权','主义','拄','嘱咐','助理','助手','住宅','注射','注视','注释','注重','驻扎','著作','铸造','拽','专长','专程','专利','专题','砖','转达','转让','转移','转折','传记','庄稼','庄严','庄重','装备','装卸','壮观','壮丽','壮烈','幢','追悼','追究','坠','准则','卓越','着手','着想','着重','姿态','资本','资产','资深','资助','滋润','滋味','子弹','自卑','自发','自力更生','自满','自主','宗教','宗旨','棕色','踪迹','总而言之','总和','纵横','走廊','走漏','走私','揍','租赁','足以','阻碍','阻拦','阻挠','祖父','祖国','祖先','钻研','钻石','嘴唇','罪犯','尊严','遵循','琢磨','作弊','作废','作风','作息','座右铭','做主']
]

# Pinyin
# https://de.wikipedia.org/wiki/Pinyin
pinyin=set("·ÀÁÈÉÊÌÍÒÓÙÚàáèéêìíòóùúĀāĒēĖėĚěĪīİıŃńŇňŌōŪūǍǎǏǐǑǒǓǔǕǖǗǘǙǚǛǜǸǹȦȧȮȯˇˉˊˋ̀́̂̄̇̈̌ḾḿṀṁṄṅẾếỀề")

# 《现代汉语通用字表》(7000字)
# https://www.zdic.net/zd/zb/ty/
hanziSTongYong=set("一一乛乙一二十丁厂七丨卜丿八人入乂儿九匕几乛刁了乃刀力又乜一三干亍于亏士土工才下寸丈大兀与万弋丨上小口山巾丿千乞川亿彳个么久勺丸夕凡及丶广亡门丫义之乛尸已巳弓己卫孑子孓也女飞刃习叉马乡幺一丰王井开亓夫天元无韦云专丐扎廿艺木五支厅卅不仄太犬区历友歹尤匹厄车巨牙屯戈比互切瓦丨止少曰日中贝内水冈见丿手午牛毛气壬升夭长仁仃什片仆仉化仇币仂仍仅斤爪反兮刈介父爻从仑今凶分乏公仓月氏勿风欠丹匀乌勾殳凤丶卞六文亢方闩火为斗忆计订户讣认讥冗心乛尹尺夬引丑爿巴孔队办以允邓予劝双书毋幻一玉刊末未示击邗戋打巧正扑卉扒邛功扔去甘世艾艽古节艿本术札可叵匝丙左厉丕石右布夯龙戊平灭轧东匜劢丨卡北占凸卢业旧帅归目旦且叮叶甲申号电田由卟叭只央史叱叽兄叼叩叫叻叨另叹冉皿凹囚四丿生失矢氕乍禾仨仕丘付仗代仙仟仡仫伋们仪白仔他仞斥卮瓜乎丛令用甩印氐乐尔句匆犰册卯犯外处冬鸟务刍包饥丶主市庀邝立冯邙玄闪兰半汀汁汇头汈汉忉宁穴宄它讦讧讨写让礼讪讫训必议讯记永乛司尻尼民弗弘阢出阡辽奶奴尕加召皮边孕发圣对弁台矛纠驭母幼丝一匡耒邦玎玑式迂刑邢戎动圩圬圭扛寺吉扣扦圪考托圳老圾巩执扩圹扪扫圯圮地扬场耳芋芏共芊芍芨芄芒亚芝芎芑芗朽朴机权过亘臣吏再协西压厌厍戌在百有存而页匠夸夺夼灰达戍尥列死成夹夷轨邪尧划迈毕至丨此乩贞师尘尖劣光当吁早吐吓旯曳虫曲团同吕吊吃因吸吗吆屿屹岌帆岁回岂屺则刚网肉凼囝囡丿钆钇年朱缶氘氖牝先丢廷舌竹迁乔迄伟传乒乓休伍伎伏伛优臼伢伐仳延佤仲仵件任伤伥价伦份伧华仰伉仿伙伪伫自伊血向囟似后行甪舟全会杀合兆企汆氽众爷伞创刖肌肋朵杂夙危旬旭旮旨负犴刎犷匈犸舛各名多凫争邬色饧丶冱壮冲妆冰庄庆亦刘齐交次衣产决亥邡充妄闭问闯羊并关米灯州汗污江汕汔汲汐汛汜池汝汤汊忖忏忙兴宇守宅字安讲讳讴军讵讶祁讷许讹论讼农讽设访诀乛聿寻那艮厾迅尽导异弛阱阮孙阵阳收阪阶阴防丞奸如妁妇妃好她妈戏羽观牟欢买纡红纣驮纤纥驯纨约级纩纪驰纫巡一寿玕弄玙麦玖玚玛形进戒吞远违韧运扶抚坛抟技坏抔抠坜扰扼拒找批扯址走抄汞坝贡攻赤圻折抓扳坂抡扮抢扺孝坎坍均坞抑抛投抃坟坑抗坊抖护壳志扭块抉声把报拟抒却劫毐芙芫芜苇邯芸芾芰苈苊苣芽芷芮苋芼苌花芹芥苁芩芬苍芪芴芡芟苄芳严苎芦芯劳克芭苏苡杆杜杠材村杖杌杏杉巫杓极杧杞李杨杈求忑孛甫匣更束吾豆两邴酉丽医辰励邳否还矶奁豕尬歼来忒连欤轩轪轫迓丨邶忐芈步卤卣邺坚肖旰旱盯呈时吴呋助县里呓呆吱吠呔呕园呖呃旷围呀吨旸吡町足虬邮男困吵串呙呐呗员听吟吩呛吻吹呜吭吣吲吼邑吧囤别吮岍帏岐岖岈岗岘帐岑岚兕财囵囫丿钉针钊钋钌迕氙氚牡告我乱利秃秀私岙每佞兵邱估体何佐伾佑攸但伸佃佚作伯伶佣低你佝佟住位伴佗身皂伺佛伽囱近彻役彷返佘余希佥坐谷孚妥豸含邻坌岔肝肟肛肚肘肠邸龟甸奂免劬狂犹狈狄角删狃狁鸠条彤卵灸岛邹刨饨迎饩饪饫饬饭饮系丶言冻状亩况亨庑床庋库庇疔疖疗吝应冷这庐序辛肓弃冶忘闰闱闲闳间闵闶闷羌判兑灶灿灼炀弟沣汪沅沄沐沛沔汰沤沥沌沘沏沚沙汩汨汭汽沃沂沦汹汾泛沧沨沟没汴汶沆沩沪沈沉沁泐怃忮怀怄忧忡忤忾怅忻忪怆忭忱快忸完宋宏牢究穷灾良证诂诃启评补初社祀祃诅识诈诉罕诊诋诌词诎诏诐译诒乛君灵即层屁屃尿尾迟局改张忌际陆阿孜陇陈阽阻阼附坠陀陂陉妍妩妓妪妣妙妊妖妗姊妨妫妒妞姒妤努邵劭忍刭劲甬邰矣鸡纬纭驱纯纰纱纲纳纴纵驳纶纷纸纹纺纻驴纽纾一奉玩玮环玡武青责现玫玠玢玥表玦甙盂忝规匦抹卦邽坩坷坯拓垅拢拔抨坪拣拤拈坫垆坦担坤押抻抽拐拃拖拊者拍顶坼拆拎拥抵坻拘势抱拄垃拉拦幸拌拧坨坭抿拂拙招坡披拨择拚抬拇坳拗耵其耶取茉苷苦苯昔苛苤若茂茏苹苫苴苜苗英苒苘茌苻苓茚苟茆茑苑苞范茓茔茕直苠茀茁茄苕茎苔茅枉林枝杯枢枥柜枇杪杳枘枧杵枚枨析板枞松枪枫构杭枋杰述枕杻杷杼丧或画卧事刺枣雨卖矸郁矻矾矽矿砀码厕奈刳奔奇奄奋态瓯欧殴垄殁郏妻轰顷转轭斩轮软到郅鸢丨非叔歧肯齿些卓虎虏肾贤尚盱旺具昊昙果味杲昃昆国哎咕昌呵咂畅呸昕明易咙昀昂旻昉炅咔畀虮迪典固忠咀呷呻黾咒咋咐呱呼呤咚鸣咆咛咏呢咄呶咖呦咝岵岢岸岩帖罗岿岬岫帜帙帕岭岣峁刿峂迥岷剀凯帔峄沓败账贩贬购贮囹图罔丿钍钎钏钐钓钒钔钕钗邾制知迭氛迮垂牦牧物乖刮秆和季委竺秉迤佳侍佶岳佬佴供使侑佰侉例侠臾侥版侄岱侦侣侗侃侧侏凭侨侩佻佾佩货侈侪佼依佯侬帛卑的迫阜侔质欣郈征徂往爬彼径所舍金刽郐刹命肴郄斧怂爸采籴觅受乳贪念贫忿瓮戗肼肤朊肺肢肽肱肫肿肭胀朋肷股肮肪肥服胁周剁昏迩郇鱼兔狉狙狎狐忽狝狗狍狞狒咎备炙枭饯饰饱饲饳饴丶冽变京享冼庞店夜庙府底庖疟疠疝疙疚疡剂卒郊兖庚废净妾盲放於刻劾育氓闸闹郑券卷单炜炬炖炒炝炊炕炎炉炔沫浅法泔泄沽沭河泷沾泸沮泪油泱泅泗泊泠泜泺泃沿泖泡注泣泫泮泞沱泻泌泳泥泯沸泓沼波泼泽泾治怔怯怙怵怖怦怛怏性怍怕怜怩怫怊怿怪怡学宝宗定宕宠宜审宙官空帘穸穹宛实宓诓诔试郎诖诗诘戾肩房诙戽诚郓衬衫衩祆祎祉视祈诛诜话诞诟诠诡询诣诤该详诧诨诩乛建肃隶录帚屉居届刷鸤屈弧弥弦承孟陋戕陌孤孢陕亟降函陔限卺妹姑姐妲妯姓姗妮始帑弩孥驽姆虱迦迢驾叁参迨艰线绀绁绂练驵组绅细驶织驷驸驹终绉驺驻绊驼绋绌绍驿绎经骀贯甾一砉耔契贰奏春帮珏珐珂珑玷玳珀顸珍玲珊珉珈玻毒型韨拭挂封持拮拷拱垭挝垣项垮挎垯挞城挟挠垤政赴赵赳贲垱挡拽垌哉垲挺括挢埏郝垍垧垢拴拾挑垛指垫挣挤垓垟拼垞挖按挥挦挪垠拯拶某甚荆茸革茜茬荐荙巷荚荑贳荛荜茈带草茧茼莒茵茴茱莛荞茯荏荇荃荟茶荀茗荠茭茨荒垩茳茫荡荣荤荥荦荧荨茛故荩胡荪荫茹荔南荬荭药柰标栈柑枯栉柯柄柘栊柩枰栋栌相查柙枵柚枳柞柏柝栀柃柢栎枸栅柳柱柿栏柈柠柁枷柽树勃剌郚剅要酊郦柬咸威歪甭研砖厘砗厚砑砘砒砌砂泵砚斫砭砜砍面耐耍奎耷牵鸥虺残殂殃殇殄殆轱轲轳轴轵轶轷轸轹轺轻鸦虿皆毖丨韭背战觇点虐临览竖尜省削尝哐昧眄眍盹是郢眇眊盼眨昽眈哇咭哄哑显冒映禺哂星昨咴曷昴咧昱昵咦哓昭哔畎畏毗趴呲胄胃贵畋畈界虹虾虼虻蚁思蚂盅咣虽品咽骂哕剐郧勋咻哗囿咱咿响哌哙哈哚咯哆咬咳咩咪咤哝哪哏哞哟峙炭峡峣罘帧罚峒峤峋峥峧帡贱贴贶贻骨幽丿钘钙钚钛钝钞钟钡钠钢钣钤钥钦钧钨钩钪钫钬钭钮钯卸缸拜看矩矧毡氡氟氢牯怎郜牲选适秕秒香种秭秋科重复竽竿笈笃俦段俨俅便俩俪叟垡贷牮顺修俏俣俚保俜促俄俐侮俭俗俘信皇泉皈鬼侵禹侯追俑俟俊盾逅待徊徇徉衍律很须舢舣叙俞弇郗剑逃俎卻爰郛食瓴盆胚胧胨胩胪胆胛胂胜胙胍胗胝朐胞胖脉胫胎鸨匍勉狨狭狮独狯狰狡飐飑狩狱狠狲訇訄逄昝贸怨急饵饶蚀饷饸饹饺饻胤饼丶峦弯孪娈将奖哀亭亮庤度弈奕迹庭庥疬疣疥疭疮疯疫疢疤庠咨姿亲竑音彦飒帝施闺闻闼闽闾闿阀阁阂差养美羑姜迸叛送类籼迷籽娄前酋首逆兹总炳炻炼炟炽炯炸烀烁炮炷炫烂烃剃洼洁洱洪洹洒洧洌浃柒浇泚浈浉浊洞洇洄测洙洗活洑涎洎洫派浍洽洮染洵洚洺洛浏济洨浐洋洴洣洲浑浒浓津浔浕洳恸恃恒恹恢恍恫恺恻恬恤恰恂恪恼恽恨举觉宣宦宥宬室宫宪突穿窀窃客诫冠诬语扁扃袆衲衽袄衿袂祛祜祓祖神祝祚诮祗祢祠误诰诱诲诳鸩说昶诵乛郡垦退既屋昼咫屏屎弭费陡逊牁眉胥孩陛陟陧陨除险院娃姞姥娅姨娆姻姝娇姚姽姣姘姹娜怒架贺盈怼羿勇炱怠癸蚤柔矜垒绑绒结绔骁绕骄骅绗绘给绚彖绛络骆绝绞骇统骈一耕耘耖耗耙艳挈恝泰秦珥珙顼珰珠珽珩珧珣珞琤班珲敖素匿蚕顽盏匪恚捞栽捕埔埂捂振载赶起盐捎捍埕捏埘埋捉捆捐埚埙损袁挹捌都哲逝耆耄捡挫捋埒换挽贽挚热恐捣垸壶捃捅盍埃挨耻耿耽聂莰茝荸莆恭莽莱莲莳莫莴莪莉莠莓荷莜莅荼莶莩荽获莸荻莘晋恶莎莞莹莨莺真莙鸪莼框梆桂桔栲栳郴桓栖桡桎桢桄档桐桤株梃栝桥桕桦桁栓桧桃桅栒格桩校核样栟桉根栩逑索逋彧哥速鬲豇逗栗贾酐酎酌配酏逦翅辱唇厝孬夏砝砹砸砺砰砧砷砟砼砥砾砣础破硁恧原套剞逐砻烈殊殉顾轼轾轿辀辁辂较鸫顿趸毙致丨剕龀柴桌鸬虔虑监紧逍党眬唛逞晒晟眩眠晓眙唝哧哳哮唠鸭晃哺哽唔晔晌晁剔晏晖晕鸮趵趿畛蚌蚨蚜蚍蚋蚬畔蚝蚧蚣蚊蚪蚓哨唢哩圃哭圄哦唣唏恩盎唑鸯唤唁哼唧啊唉唆帱崂崃罡罢罟峭峨峪峰圆觊峻贼贿赂赃赅赆丿钰钱钲钳钴钵钷钹钺钻钼钽钾钿铀铁铂铃铄铅铆铈铉铊铋铌铍铎眚缺氩氤氦氧氨毪特牺造乘敌舐秣秫秤租秧积盉秩称秘透笄笕笔笑笊笫笏笋笆俸倩债俵倻借偌值倚俺倾倒俳俶倬倏倘俱倡候赁恁倭倪俾倜隼隽倞俯倍倦倓倌倥臬健臭射皋躬息郫倨倔衄颀徒徕徐殷舰舨舱般航舫瓞途拿釜耸爹舀爱豺豹奚鬯衾鸰颁颂翁胯胰胱胴胭脍脎脆脂胸胳脏脐胶脑胲胼朕脒胺脓鸱玺鱽鸲逛狴狸狷猁狳猃狺逖狼卿狻逢桀鸵留袅眢鸳皱饽饿馀馁丶凌凇凄栾挛恋桨浆衰勍衷高亳郭席准座脊症疳疴病疽疸疾痄斋疹痈疼疱疰痃痂疲痉效离衮紊唐凋颃瓷资恣凉站剖竞部旁旆旄旅旃畜阃阄阅阆羞羔恙瓶桊拳敉粉料粑益兼朔郸烤烘烜烦烧烛烟烨烩烙烊剡郯烬递涛浙涝浡浦涑浯酒涞涟涉娑消涅涠浞涓涢涡浥涔浩海浜涂浠浴浮涣浼涤流润涧涕浣浪浸涨烫涩涌涘浚悖悚悟悭悄悍悝悃悒悔悯悦悌悢悛害宽宸家宵宴宾窍窅窄容窈剜宰案请朗诸诹诺读扅诼冢扇诽袜袪袒袖袗袍袢被袯祯祧祥课冥诿谀谁谂调冤谄谅谆谇谈谊乛剥恳展剧屑屐屙弱陵陬勐奘疍牂蚩祟陲陴陶陷陪烝姬娠娱娌娉娟娲恕娥娩娴娣娘娓婀砮哿畚通能难逡预桑剟绠骊绡骋绢绣验绤绥绦骍继绨骎骏邕鸶一彗耜焘舂琎球琏琐理琇麸琉琅捧掭堵揶措描埴域捺掎埼掩埯捷捯排焉掉掳掴埸堌捶赦赧推堆捭埠晢掀逵授捻埝堋教堍掏掐掬鸷掠掂掖培掊接堉掷掸控捩掮探悫埭埽据掘掺掇掼职聃基聆勘聊聍娶菁菝著菱萁菥菘堇勒黄萘萋勩菲菽菖萌萜萝菌萎萸萑菂菜棻菔菟萄萏菊萃菩菼菏萍菹菠菪菅菀萤营萦乾萧菰菡萨菇械梽彬梵梦婪梗梧梾梢梏梅觋检桴桷梓梳棁梯桫棂桶梭救啬郾匮曹敕副豉票鄄酝酞酗酚厢厣戚戛硎硅硭硒硕硖硗硐硚硇硌鸸瓠匏奢盔爽厩聋龚袭殒殓殍盛赉匾雩雪辄辅辆堑丨龁颅虚彪雀堂常眶眭唪眦啧匙晡晤晨眺眵睁眯眼眸悬野圊啪啦喏喵啉勖曼晦晞晗晚冕啄啭啡畦趼趺距趾啃跃啮跄略蚶蛄蛎蛆蚰蚺蛊圉蚱蚯蛉蛀蛇蛏蚴唬累鄂唱患啰唾唯啤啥啁啕唿啐唼唷啴啖啵啶啷唳啸啜帻崖崎崦崭逻帼崮崔帷崟崤崩崞崇崆崛赇赈婴赊圈丿铐铑铒铕铗铘铙铚铛铜铝铞铟铠铡铢铣铤铥铧铨铩铪铫铭铬铮铯铰铱铲铳铴铵银铷矫氪牾甜鸹秸梨犁稆秽移秾逶笺筇笨笸笼笪笛笙笮符笱笠笥第笳笤笾笞敏偾做鸺偃偕袋悠偿偶偈偎偲傀偷您偬售停偻偏躯皑兜皎假衅鸻徘徙徜得衔舸舻舳盘舴舶船鸼舷舵斜龛盒鸽瓻敛悉欲彩领翎脚脖脯豚脶脸脞脬脱脘脲脧匐鱾象够逸猜猪猎猫猗凰猖猡猊猞猄猝斛觖猕猛馗祭馃馄馅馆丶凑减鸾毫孰烹庶庹麻庵庼庾庳痔痍疵痊痒痕廊康庸鹿盗章竟翊商旌族旎旋望袤率阇阈阉阊阋阌阍阎阏阐着羚羝羟盖眷粝粘粗粕粒断剪兽焐焊烯焓焕烽焖烷烺焌清渍添渚鸿淇淋淅淞渎涯淹涿渠渐淑淖挲淌淏混淠涸渑淮淦淆渊淫淝渔淘淳液淬涪淤淡淙淀涫深渌涮涵婆梁渗淄情惬悻惜惭悱悼惝惧惕惘悸惟惆惚惊惇惦悴惮惋惨惯寇寅寄寂逭宿窒窑窕密谋谌谍谎谏扈皲谐谑裆袱袼裈裉祷祸祲谒谓谔谕谖谗谙谚谛谜谝敝乛逮逯敢尉屠艴弹隋堕郿随蛋隅隈粜隍隗隆隐婧婊婞婳婕娼婢婚婵婶婉胬袈颇颈翌恿欸绩绪绫骐续骑绮绯绰骒绲绳骓维绵绶绷绸绹绺绻综绽绾绿骖缀缁巢一耠琫琵琴琶琪瑛琳琦琢琥琨靓琼斑琰琮琯琬琛琚辇替鼋揳揍款堪堞搽塔搭塃揸堰揠堙揩越趄趁趋超揽提堤揖博揾颉揭喜彭揣塄揿插揪搜煮堠耋揄援搀蛰蛩絷塆裁揞搁搓搂搅揎壹握摒揆搔揉掾葜聒斯期欺联葑葚葫靰靸散葳惹蒇葬蒈募葺葛蒉葸萼蓇萩董葆葩葡敬葱蒋葶蒂蒌葓蒎落萱葖韩戟朝葭辜葵棒楮棱棋椰植森棼焚椟椅椒棹棵棍椤棰椎棉椑鹀赍棚椋椁棬棕棺榔楗棣椐椭鹁惠惑逼覃粟棘酣酤酢酥酡酦鹂觌厨厦硬硝硪硷确硫雁厥殖裂雄殚殛颊雳雯辊辋椠暂辌辍辎雅翘丨辈斐悲紫凿黹辉敞棠牚赏掌晴睐暑最晰量睑睇鼎睃喷戢喋嗒喃喳晶喇遇喊喱喹遏晷晾景喈畴践跖跋跌跗跞跚跑跎跏跛跆遗蛙蛱蛲蛭蛳蛐蛔蛛蜓蛞蜒蛤蛴蛟蛘蛑畯喁喝鹃喂喟斝喘啾嗖喤喉喻喑啼嗟喽嗞喧喀喔喙嵌嵘嵖幅崴遄詈帽嵎崽嵚嵬嵛翙嵯嵝嵫幄嵋赋赌赎赐赑赔黑丿铸铹铺铻铼铽链铿销锁锃锄锂锅锆锇锈锉锊锋锌锎锏锐锑锒锓锔锕甥掣掰短智矬氰毳毯氮毽氯犊犄犋鹄犍鹅颋剩嵇稍程稀黍稃税稂筐等筘筑策筚筛筜筒筅筏筵筌答筋筝傣傲傅傈舄牍牌傥堡集焦傍傧储遑皓皖粤奥傩遁街惩御徨循舾艇舒畲弑逾颌翕釉番释鹆禽舜貂腈腊腌腓腆腴脾腋腑腙腚腔腕腱腒鱿鲀鲁鲂鲃颍猢猹猩猥猬猾猴飓觞觚猸猱惫飧然馇馈馉馊馋丶亵装蛮脔就敦裒廋斌痣痨痦痘痞痢痤痪痫痧痛鄌赓竦童瓿竣啻颏鹇阑阒阔阕善翔羡普粪粞尊奠遒道遂孳曾焯焜焰焙焱鹈湛港渫滞湖湘渣渤湮湎湝湨湜渺湿温渴渭溃湍溅滑湃湫溲湟溆渝湲湾渡游溠溇湔滋湉渲溉渥湄滁愤慌惰愠惺愦愕惴愣愀愎惶愧愉愔慨喾割寒富寓窜窝窖窗窘寐谟扉遍棨雇扊裢裎裣裕裤裥裙祾祺祼谠禅禄幂谡谢谣谤谥谦谧乛塈遐犀属屡孱弼强粥巽疏隔骘隙隘媒媪絮嫂媛婷媚婿巯毵翚登皴婺骛缂缃缄缅彘缆缇缈缉缌缎缏缑缒缓缔缕骗编缗骙骚缘飨一耢瑟瑚鹉瑁瑞瑰瑀瑜瑗瑄瑕遨骜瑙遘韫魂髡肆摄摸填搏塥塬鄢趔趑摅塌摁鼓摆赪携塮蜇搋搬摇搞搪塘搒搐搛搠摈彀毂搌搦摊搡聘蓁戡斟蒜蓍鄞勤靴靳靶鹊蓐蓝墓幕蓦鹋蒽蓓蓖蓊蒯蓟蓬蓑蒿蒺蓠蒟蒡蓄蒹蒴蒲蒗蓉蒙蓂蓥颐蒸献蓣楔椿楠禁楂楚楝楷榄想楫榀楞楸椴槐槌楯榆榇榈槎楼榉楦概楣楹椽裘赖剽甄酮酰酯酪酩酬蜃感碛碍碘碓碑硼碉碎碚碰碇碗碌碜鹌尴雷零雾雹辏辐辑辒输丨督频龃龄龅龆觜訾粲虞鉴睛睹睦瞄睚嗪睫韪嗷嗉睡睨睢雎睥睬嘟嗜嗑嗫嗬嗔鄙嗦嗝愚戥嗄暖盟煦歇暗暅暄暇照遢暌畸跬跨跶跷跸跐跣跹跳跺跪路跻跤跟遣蛸蜈蜎蜗蛾蜊蜍蜉蜂蜣蜕畹蛹嗣嗯嗅嗥嗲嗳嗡嗌嗍嗨嗤嗵嗓署置罨罪罩蜀幌嵊嵩嵴骰丿锖锗错锘锚锛锜锝锞锟锡锢锣锤锥锦锧锨锪锫锩锬锭键锯锰锱矮雉氲犏辞歃稞稚稗稔稠颓愁筹筠筢筮筻筲筼筱签简筷毁舅鼠牒煲催傻像躲鹎魁敫僇衙微徭愆艄觎毹愈遥貊貅貉颔腻腠腩腰腼腽腥腮腭腹腺腧鹏塍媵腾腿詹鲅鲆鲇鲈鲉鲊稣鲋鲌鲍鲏鲐肄猿颖鹐飔飕觥触解遛煞雏馌馍馏馐丶酱鹑禀亶廒瘃痱痹痼廓痴痿瘐瘁瘅痰瘆廉鄘麂裔靖新鄣歆韵意旒雍阖阗阘阙羧豢誊粳粮数煎猷塑慈煤煳煜煨煅煌煊煸煺滟溱溘滠满漭漠滢滇溥溧溽源滤滥裟溻溷溦滗滫溴滏滔溪滃溜滦漓滚溏滂溢溯滨溶滓溟滘溺滍粱滩滪愫慑慎慥慊誉鲎塞骞寞窥窦窠窣窟寝谨裱褂褚裸裼裨裾裰禊福谩谪谫谬乛群殿辟障媾嫫媳媲嫒嫉嫌嫁嫔媸叠缙缜缚缛辔缝骝缟缠缡缢缣缤骟剿一耥璈静碧瑶璃瑭瑢獒赘熬觏慝嫠韬髦墈墙摽墟撇墁撂摞嘉摧撄赫截翥踅誓銎摭墉境摘墒摔榖撖摺綦聚蔫蔷靺靼鞅靽鞁靿蔌蔽慕暮摹蔓蔑甍蔸蓰蔹蔡蔗蔟蔺戬蕖蔻蓿蔼斡熙蔚鹕兢嘏蓼榛榧模槚槛榻榫槜榭槔榴槁榜槟榨榕槠榷榍歌遭僰酵酽酾酲酷酶酴酹酿酸厮碶碡碟碴碱碣碳碲磋磁碹碥愿劂臧豨殡需霆霁辕辖辗丨蜚裴翡雌龇龈睿裳颗夥瞅瞍睽墅嘞嘈嗽嘌嘁嘎暧暝踌踉跽踊蜻蜞蜡蜥蜮蜾蝈蜴蝇蜘蜱蜩蜷蝉蜿螂蜢嘘嘡鹗嘣嘤嘚嘛嘀嗾嘧罴罱幔嶂幛赙罂赚骷骶鹘丿锲锴锶锷锸锹锻锽锾锵锿镀镁镂镃镄镅舞犒舔稳熏箐箦箧箍箸箨箕箬算箅箩箪箔管箜箢箫箓毓舆僖儆僳僚僭僬劁僦僮僧鼻魄魅魃魆睾艋鄱貌膜膊膈膀膑鲑鲔鲙鲚鲛鲜鲟疑獐獍飗觫雒孵夤馑馒丶銮裹敲豪膏塾遮麽廙腐瘩瘌瘗瘟瘦瘊瘥瘘瘙廖辣彰竭韶端旗旖膂阚鄯鲞精粼粹粽糁歉槊鹚弊熄熘熔煽熥潢潆潇漤漆漕漱漂滹漫漯漶潋潴漪漉漳滴漩漾演澉漏潍慢慷慵寨赛搴寡窬窨窭察蜜寤寥谭肇綮谮褡褙褐褓褛褊褪禚谯谰谱谲乛暨屣鹛隧嫣嫱嫩嫖嫦嫚嫘嫜嫡嫪鼐翟翠熊凳瞀鹜骠缥缦缧骡缨骢缩缪缫一慧耦耧瑾璜璀璎璁璋璇璆奭撵髯髫撷撕撒撅撩趣趟撑撮撬赭播墦擒撸鋆墩撞撤撙增撺墀撰聩聪觐鞋鞑蕙鞒鞍蕈蕨蕤蕞蕺瞢蕉劐蕃蕲蕰蕊赜蔬蕴鼒槿横樯槽槭樗樘樱樊橡槲樟橄敷鹝豌飘醋醌醇醉醅靥魇餍磕磊磔磙磅碾磉殣慭震霄霉霈辘丨龉龊觑瞌瞒题暴瞎瞑嘻嘭噎嘶噶嘲颙暹嘹影踔踝踢踏踟踬踩踮踣踯踪踺踞蝽蝶蝾蝴蝻蝠蝰蝎蝌蝮螋蝗蝓蝣蝼蝤蝙噗嘬颚嘿噍噢噙噜噌嘱噀噔颛幞幡嶓幢嶙嶝墨骺骼骸丿镊镆镇镈镉镋镌镍镎镏镐镑镒镓镔靠稽稷稻黎稿稼箱箴篑篁篌篓箭篇篆僵牖儇儋躺僻德徵艘磐虢鹞鹟膝膘膛滕鲠鲡鲢鲣鲥鲤鲦鲧鲩鲪鲫鲬橥獗獠觯鹠馓馔丶熟摩麾褒廛瘛瘼瘪瘢瘤瘠瘫齑鹡凛颜毅羯羰糊糇遴糌糍糈糅翦遵鹣憋熜熵熠潜澍澎澌潵潮潸潭潦鲨潲鋈潟澳潘潼澈澜潽潺澄潏懂憬憔懊憧憎寮窳额谳翩褥褴褫禤谴鹤谵乛憨熨慰劈履屦嬉勰戮蝥豫缬缭缮缯骣畿一耩耨耪璞璟靛璠璘聱螯髻髭髹擀撼擂操熹甏擐擅擞磬鄹颞蕻鞘燕黇颟薤蕾薯薨薛薇檠擎薪薏蕹薮薄颠翰噩薜薅樾橱橛橇樵檎橹橦樽樨橙橘橼墼整橐融翮瓢醛醐醍醒醚醑觱磺磲赝飙殪霖霏霓霍霎錾辙辚臻丨冀餐遽氅瞟瞠瞰嚄嚆噤暾曈蹀蹅踶踹踵踽嘴踱蹄蹉蹁蹂螨蟒蟆螈螅螭螗螃螠螟噱器噪噬噫噻噼幪罹圜鹦赠默黔丿镖镗镘镚镛镜镝镞镠氇氆赞憩穑穆穄篝篚篥篮篡簉篦篪篷篙篱盥儒劓翱魉魈邀徼衡歙盦膨膪膳螣膦膙雕鲭鲮鲯鲰鲱鲲鲳鲴鲵鲷鲸鲺鲹鲻獴獭獬邂丶憝亸鹧磨廨赟癀瘭瘰廪瘿瘵瘴癃瘾瘸瘳斓麇麈凝辨辩嬴壅羲糙糗糖糕瞥甑燎燠燔燃燧燊燏濑濒濉潞澧澡澴激澹澥澶濂澼憷懒憾懈黉褰寰窸窿褶禧乛壁避嬖犟隰嬗鹨翯颡缰缱缲缳缴一璨璩璐璪戴螫擤壕擦觳罄擢藉薹鞡鞠藏薷薰藐藓藁檬檑檄檐檩檀懋醢翳繄礁礅磷磴鹩霜霞丨龋龌豳壑黻瞭瞧瞬瞳瞵瞩瞪嚏曙嚅蹑蹒蹋蹈蹊蹓蹐蟥螬螵疃螳螺蟋蟑蟀嚎嚓羁罽罾嶷赡黜黝髁髀丿镡镢镣镤镥镦镧镨镩镪镫罅穗黏魏簧簌篾簃篼簏簇簖簋繁鼢黛儡鹪鼾皤魍徽艚龠爵繇貘邈貔臌朦臊膻臁臆臃鲼鲽鲾鳀鳁鳂鳃鳄鳅鳆鳇鳈鳉鳊獯螽丶燮鹫襄糜縻膺癍癌麋辫赢糟糠馘燥懑濡濮濞濠濯懦豁蹇謇邃襕襁乛臀檗甓臂擘孺隳嬷翼蟊鹬鍪骤一鏊鳌鬹鬈鬃瞽藕鞯鞨鞭鞫鞧鞣藜藠藤藩鹲檫檵覆醪蹙礞礓礌燹餮丨蹩瞿瞻曛颢曜躇蹦鹭蹢蹜蟛蟪蟠蟮嚚嚣鹮黠黟髅髂丿镬镭镯镰镱馥簠簟簪簦鼫鼬鼩雠艟翻臑鳍鳎鳏鳐鳑鹱丶鹰癞癔癜癖糨冁瀑瀍瀌鎏懵襟乛璧戳彝邋一鬏攉攒鞲鞴藿蘧孽蘅警蘑藻麓攀醭醮醯礤酃霪霭丨黼鳖曝嚯蹰蹶蹽蹼蹯蹴蹾蹲蹭蹿蹬蠖蠓蠋蟾蠊巅黢髋髌丿镲籀簸籁簿鳘齁魑艨鼗鳓鳔鳕鳗鳙鳚蟹丶颤靡癣麒鏖瓣蠃羸羹爆瀚瀣瀛襦谶乛襞疆骥缵一瓒鬓壤攘馨蘩蘖蘘醵醴霰颥丨酆耀矍曦躁躅蠕鼍嚼嚷巍巉黩黥丿镳镴黧籍纂鼯犨臜鳜鳝鳞鳟獾丶魔糯灌瀹瀵乛譬孀骧一耰蠢瓘鼙醺礴礳霸露霹丨颦曩躏黯髓丿鼱鳡鳢丶癫麝赣夔爝灏禳乛鐾羼蠡一耲耱懿韂蘸鹳糵蘼囊霾丨氍饕躔躐髑丿镵镶穰鳤丶瓤饔乛鬻一鬟趱攫攥颧丨躜丿罐鼹鼷丶癯麟蠲一矗蠹醾丨躞丿衢鑫丶灞襻一纛鬣攮丨囔丿馕丶戆丨蠼丿爨丿齉")

# 现代汉语常用字表》常用字(2500字)
# https://www.zdic.net/zd/zb/cc1/
hanziSChangYong=set("一丁七万丈三上下不与丑专且世丘丙业丛东丝丢两严丧个中丰串临丸丹为主丽举乃久么义之乌乎乏乐乒乓乔乖乘乙九乞也习乡书买乱乳了予争事二于亏云互五井亚些亡交亦产亩享京亭亮亲人亿什仁仅仆仇今介仍从仓仔他仗付仙代令以仪们仰件价任份仿企伍伏伐休众优伙会伞伟传伤伪伯估伴伶伸似但位低住体何余佛作你佣佩佳使侄例侍供依侦侧侨侮侵便促俊俗俘保信俩俭修俯俱倍倒倘候倚借倡倦债值倾假偏做停健偶偷偿傅傍储催傲傻像僚僵僻儿允元兄充兆先光克免兔党入全八公六兰共关兴兵其具典养兼兽内冈册再冒写军农冠冤冬冰冲决况冶冷冻净准凉减凑凝几凡凤凭凯凳凶出击刀刃分切刊刑划列刘则刚创初删判利别刮到制刷券刺刻剂剃削前剑剖剥剧剩剪副割劈力劝办功加务劣动助努劫励劲劳势勇勉勒勤勺勾勿匀包匆化北匙匠匪匹区医十千升午半华协单卖南博卜占卡卧卫印危即却卵卷卸厂厅历厉压厌厕厘厚原厦厨去县参又叉及友双反发叔取受变叙叛叠口古句另叨只叫召叮可台史右叶号司叹叼吃各合吉吊同名后吐向吓吗君吞否吧吨吩含听启吴吵吸吹吼呀呆呈告员呜呢周味呼命和咏咐咬咱咳咸咽哀品哄哈响哑哗哥哨哪哭哲唇唉唐唤售唯唱啄商啊啦喂善喇喉喊喘喜喝喷嗓嗽嘉嘱嘴器嚷嚼囊四回因团园困围固国图圆圈土圣在地场圾址均坊坏坐坑块坚坛坝坟坡坦垂垃垄型垒垦垫垮埋城域培基堂堆堡堤堪堵塌塑塔塘塞填境墓墙增墨壁壤士壮声壳壶处备复夏夕外多夜够大天太夫央失头夸夹夺奇奉奋奏奔奖套奥女奴奶奸她好如妄妇妈妖妙妥妨妹妻始姐姑姓委姜姥姨姻姿威娃娇娘娱婆婚婶嫁嫂嫌嫩子孔孕字存孙孝孟季孤学孩宁它宅宇守安宋完宏宗官宙定宜宝实审客宣室宪宫宰害宴宵家容宽宾宿寄密寇富寒察寨寸对寺寻导寿封射将尊小少尖尘尚尝尤就尸尺尼尽尾尿局层居屈届屋屑展属屠屡屯山屿岁岂岔岗岛岩岭岸峡峰崇崖崭川州巡工左巧巨巩差己已巴巷巾币市布帅帆师希帐帖帘帜帝带席帮常帽幅幕干平年并幸幻幼广庄庆床序库应底店庙府废度座庭康庸廉廊延建开异弃弄弊式弓引弟张弦弯弱弹强归当录形彩影役彻彼往征径待很律徐徒得御循微德心必忆忌忍志忘忙忠忧快念忽怀态怎怒怕怖怜思怠急性怨怪总恋恐恒恢恨恩恭息恰恳恶恼悄悉悔悟悠患悦您悬悲悼情惊惑惕惜惠惧惨惩惭惯惰想惹愁愈愉意愚感愤愧愿慈慌慎慕慢慧慨慰懂懒戏成我戒或战戚截戴户房所扁扇手才扎扑扒打扔托扛扣执扩扫扬扭扮扯扰扶批找承技抄把抓投抖抗折抚抛抢护报披抬抱抵抹押抽担拆拉拌拍拐拒拔拖拘招拜拢拣拥拦拨择括拳拴拼拾拿持挂指按挎挑挖挠挡挣挤挥挨挪振挺挽捆捉捎捏捐捕捞损捡换捧据捷掀授掉掌掏排掘掠探接控推掩揉描提插握揪揭援搁搂搅搏搜搞搬搭携摄摆摇摊摔摘摧摩摸撇撑撒撕撞撤播操擦攀支收改攻放政故效敌敏救教敞敢散敬数敲整文斑斗料斜斤斥斧斩断斯新方施旁旅旋族旗无既日旦旧旨早旬旱时旷旺昂昆昌明昏易星映春昨是昼显晃晋晌晒晓晕晚晨普景晴晶智暂暑暖暗暮暴曲更曾替最月有朋服朗望朝期木未末本术朱朴朵机朽杀杂权杆李杏材村杜束杠条来杨杯杰松板极构析枕林果枝枣枪枯架柄柏某染柔柜查柱柳柴柿标栋栏树栗校株样核根格栽桂桃框案桌桐桑档桥桨桶梁梅梢梦梨梯械梳检棉棋棍棒棕棚森棵椅植椒楚楼概榆榜榨榴槐槽模横樱橘橡欠次欢欣欧欲欺款歇歉歌止正此步武歪死歼殃殊残殖段殿毁毅母每毒比毕毙毛毫毯氏民气氧水永汁求汇汉汗江池污汤汪汽沃沈沉沙沟没沫河沸油治沾沿泄泉泊法泛泡波泥注泪泰泳泻泼泽洁洋洒洗洞津洪洲活洽派流浅浆浇浊测济浑浓浙浩浪浮浴海浸涂消涉涌涛涝润涨液淋淘淡深混淹添清渐渔渗渠渡渣温港渴游湖湾湿溉源溜溪滋滑滔滚满滤滥滨滩滴漂漆漏演漠漫潜潮澡激灌火灭灯灰灵灶灾灿炉炊炎炒炕炭炮炸点炼烂烈烘烛烟烤烦烧烫热焦焰然煌煎煤照煮熄熊熔熟燃燕燥爆爪爬爱父爷爸爹爽片版牌牙牛牢牧物牲牵特牺犁犬犯状犹狂狐狗狠狡独狭狮狱狸狼猎猛猜猪猫献猴猾率玉王玩环现玻珍珠班球理琴瑞璃瓜瓣瓦瓶甘甚甜生用甩田由甲申电男画畅界畏留畜略番疆疏疑疗疤疫疮疯疲疼疾病症痒痕痛痰瘦登白百皂的皆皇皮皱盆盈益盏盐监盒盖盗盘盛盟目盯盲直相盼盾省眉看真眠眨眯眼着睁睛睡督睬瞎瞒瞧矛知矩短矮石矿码砌砍研砖破础硬确碌碍碎碑碗碧碰磁磨示礼社祖祝神祥票祸禁福离禽禾秀私秃秆秋种科秒秘租秤秧秩积称移稀程稍税稠稳稻稼稿穗穴究穷空穿突窃窄窑窗窜窝立竖站竞竟章童竭端竹竿笋笑笔笛符笨第笼等筋筐筑筒答策筛筝筹签简算管箩箭箱篇篮籍米类粉粒粗粘粥粪粮粱精糊糕糖糟糠系素索紧紫累絮繁纠红纤约级纪纯纱纲纳纵纷纸纹纺纽线练组细织终绍经绑绒结绕绘给络绝绞统绢绣继绩绪续绳维绵绸绿缎缓编缘缝缠缩缴缸缺罐网罗罚罢罩罪置羊美羞羡群羽翁翅翠翻翼耀老考者而耍耐耕耗耳耻耽聋职联聚聪肃肆肉肌肚肝肠股肢肤肥肩肯育肺肾肿胀胁胃胆背胖胜胞胡胳胶胸能脂脆脉脊脏脑脖脚脱脸脾腊腐腔腥腰腹腾腿膀膊膏膛膜膝膨臂臣自臭至致舅舌舍舒舞舟航般舰舱船艇艘良艰色艳艺节芒芝芦芬花芳芹芽苍苏苗若苦英苹茂范茄茅茎茧茫茶草荐荒荡荣药荷莫莲获菊菌菜菠萄萌萍萝营落著葛葡董葬葱葵蒙蒜蒸蓄蓝蓬蔑蔬蔽蕉薄薪薯藏虎虏虑虚虫虹虽虾蚀蚁蚂蚊蚕蛇蛋蛙蛛蛮蛾蜂蜓蜘蜜蜡蜻蝇蝴蝶融螺蠢血行衔街衡衣补表衫衬衰袄袋袍袖袜被袭裁裂装裕裙裤裳裹西要覆见观规视览觉角解触言誉誓警计订认讨让训议讯记讲许论讽设访证评识诉诊词译试诗诚话诞询该详语误诱说诵请诸读课谁调谅谈谊谋谎谜谢谣谦谨谱谷豆象豪貌贝贞负贡财责贤败货质贩贪贫购贯贱贴贵贷贸费贺贼贿资赌赏赔赖赚赛赞赠赢赤走赴赵赶起趁超越趋趟趣足趴跃跌跑距跟跨跪路跳践踏踢踩踪蹄蹈蹦蹲躁身躬躲躺车轧轨转轮软轰轻载轿较辅辆辈辉输辛辜辞辟辣辨辩辫辰辱边辽达迁迅过迈迎运近返还这进远违连迟迫述迷迹追退送适逃逆选透逐递途逗通逝速造逢逮逼遇遍道遗遣遥遭遮遵避邀那邪邮邻郊郎郑部都鄙配酒酬酱酷酸酿醉醋醒采释里重野量金鉴针钉钓钞钟钢钥钩钱钳钻铁铃铅铜铲银铸铺链销锁锄锅锈锋锐错锡锣锤锦键锯锹锻镇镜镰长门闪闭问闯闲间闷闸闹闻阀阁阅阔队防阳阴阵阶阻阿附际陆陈降限陕陡院除险陪陵陶陷隆随隐隔隙障隶难雀雁雄雅集雕雨雪零雷雹雾需震霉霜霞露霸青静非靠面革鞋鞠鞭音韵页顶顷项顺须顽顾顿颂预领颈颗题颜额颠颤风飘飞食餐饥饭饮饰饱饲饶饺饼饿馅馆馋馒首香马驰驱驳驴驶驻驼驾骂骄骆验骑骗骡骤骨高鬼魂魄魔鱼鲁鲜鸟鸡鸣鸦鸭鸽鹅鹊鹰鹿麦麻黄黎黑默鼓鼠鼻齐齿龄龙龟")

#########################
## Traditional Chinese ##
#########################

# 教育部國語辭典公眾授權網: 《重編國語辭典修訂本》資料下載（版本編號：2015_20200331）
# https://language.moe.gov.tw/001/Upload/Files/site_content/M0001/respub/dict_reviseddict_download.html
hanziT=set("㒓㓦㕒㛂㟏㥏㬊㲪㲯㵝㶁㺔䉶䍡䍦䍪䒷䥈䫄䰀䰐䰰一丁丂七万丈三上下丌不丏丐丑且丕世丘丙丞丟丢並丨丩个丫中丮丰丱串丳丶丸丹主丿乂乃久么义之乍乎乏乒乓乖乘乙乜九乞也乣乩乳乾亂亅了予争事二亍于云互亓五井亘亙些亞亟亠亡亢交亥亦亨享京亭亮亳亶亹人什仁仂仃仄仆仇仉今介仍从仔仕他仗付仙仚仝仞仟仡代令以仨仰仲仳仵件价任份仿伀企伃伈伉伊伋伍伎伏伐休伕优伙伯估伴伶伸伺似伽伾佁佃但佇佈佉佊佌位低住佐佑佒体佔何佗佘余佚佛作佝佞佟你佣佤佧佩佪佬佯佰佳佴併佶佷佸佹佺佻佼佽佾使侁侂侃侄來侇侈侉侊例侍侏侐侑侔侖侗侘侚供侜依侞侮侯侲侵侶侷侹侻便俁係促俄俅俇俊俍俎俏俐俑俔俗俘俚俛俜保俞俟俠信修俯俱俳俴俵俶俸俺俾倀倅倆倈倉個倌倍倏倐們倒倓倔倕倖倗倘候倚倛倜倝倞借倠倡倢倣倥倦倧倨倩倪倫倬倭倮倳倸值倽偁偃假偈偉偊偋偌偍偎偏偓偕偘做停偝偟偠偢健偩偪偬偭偯偰偲側偵偶偷偺偽傀傃傅傉傌傍傎傑傒傔傕傖傘備傚傜傞傢傣催傭傯傱傲傳傴債傷傺傻傾僂僃僄僅僆僇僈僉僊僎像僑僓僔僕僖僗僚僛僝僣僤僥僦僧僨僩僪僬僭僮僰僱僵僶價僻僽僾僿儀儁儂儃億儆儇儈儉儋儌儍儐儒儓儔儕儗儘儚儜儞償儡儤儥儦儩優儭儱儲儳儴儵儷儸儹儺儻儼儿兀允元兄充兆兇先光克兌免兑兒兔兕兗党兜兢入內全兩八公六兮共兵其具典兼冀冂冄冉冊再冏冑冒冓冔冕冖冗冘冞冠冢冣冤冥冪冫冬冰冱冲况冶冷冼冽准凇凉凊凋凌凍凑凔凘凜凝凟几凡凥凭凰凱凳凵凶凸凹出函刀刁刃刄分切刈刉刊刋刌刎刑划刓刖列刜初删判別刨利刪别刮到刱刲刳刵制刷券刺刻刾剁剃剄則剉削剋剌前剎剒剔剕剖剗剚剛剜剝剞剟剡剨剩剪剫剭剮副割剳剴創剷剸剺剽剿劀劁劂劃劄劇劈劉劊劌劍劐劑劓劖劘劙力功加劣劦助努劫劬劭効劻劼劾勁勃勅勇勉勌勍勑勒勔動勖勗勘務勛勝勞募勠勢勣勤勦勩勰勱勳勵勷勸勹勺勻勾勿匀匄包匆匈匊匋匍匏匐匕化北匙匚匜匝匟匠匡匣匪匭匯匱匳匴匵匶匸匹匼匽匾匿區十卂千卅升午卉半卌卍卑卒卓協南博卜卝卞占卡卣卦卩卬卮卯印危卲即卵卷卸卹卺卻卼卿厂厄厊厎厏厓厔厖厘厚厜厝厞原厠厤厥厪厭厮厲厴厶厹去参參又叉及友反叒叔叕取受叚叛叟叡叢口古句另叨叩只叫召叭叮可台叱史右叵叶司叼吁吃各吆合吉吊吋同名后吏吐向吒吔君吝吞吟吠吡否吧吩吪含听吭吮吰吱吳吴吵吶吷吸吹吻吼吽吾呀呂呃呆呈告呌呎呑呔呝呢呤呥呦周呪呫呰呱呲味呴呵呶呷呸呺呻呼命呾呿咀咂咄咆咇咈咋和咍咎咏咐咒咕咖咚咡咢咥咦咧咨咩咪咫咬咭咮咯咱咳咵咷咸咺咻咼咽咾咿哀品哂哃哄哅哆哇哈哉哎哏哖員哤哥哦哧哨哩哪哫哭哮哰哱哲哳哷哺哼哽哿唁唄唅唆唇唈唉唏唐唑唓唔唕唗唚唣唦唧唪唫唬售唯唱唲唳唵唶唷唸唼唾啀啁啃啄啅商啊啍啎問啐啑啓啕啖啗啚啜啞啟啡啢啣啤啥啦啪啵啶啷啻啼啽啾喀喁喂喃善喆喇喈喉喊喋喌喍喎喏喑喒喓喔喘喙喚喜喝喟喢喣喤喦喧喨喪喫喬喭單喱喲喳喵喻嗀嗁嗃嗄嗅嗆嗇嗈嗉嗊嗋嗌嗍嗎嗏嗐嗑嗒嗓嗔嗖嗙嗚嗛嗜嗝嗞嗟嗡嗢嗣嗤嗥嗦嗨嗩嗯嗲嗶嗷嗹嗻嗼嗽嗾嗿嘀嘁嘆嘈嘉嘌嘍嘎嘏嘐嘑嘒嘓嘔嘕嘖嘗嘚嘛嘟嘧嘩嘬嘮嘯嘰嘲嘴嘵嘶嘷嘸嘹嘻嘽嘿噀噁噂噆噇噉噌噍噎噏噓噔噗噘噙噚噞噠噢噣噤噥噦器噩噪噫噬噭噯噰噱噲噴噶噸噹嚀嚃嚄嚅嚆嚇嚌嚎嚏嚐嚓嚕嚗嚘嚙嚚嚜嚥嚦嚧嚨嚫嚬嚭嚮嚱嚲嚳嚴嚵嚶嚷嚼嚾囀囁囂囃囅囈囉囊囋囌囑囔囗囚四囝回囟因囡囤囧囪囫囮困囷囹固囿圂圃圄圇圈圉圊國圌圍園圓圖團圛圜圞土圠在圩圬圭圮圯地圳圻圾址坁坂坄坆均坊坌坍坎坏坐坑坡坤坦坨坩坪坫坯坰坱坳坵坶坷坻坼垂垃型垌垍垓垔垕垗垚垛垝垞垠垡垢垣垤垮垸垺埂埃埆埋埌城埏埒埔埕埛埜埝域埠埤埧埭埳埴埵埶執埸培基埻埼埽堀堁堂堃堄堅堆堇堉堊堋堍堐堙堝堞堠堡堤堥堦堧堩堪堮堯堰報堲場堵堶堽塈塊塋塌塍塏塑塒塓塔塕塗塘塙塚塞塢塨填塭塵塹塺塼塽塾塿墀墁境墅墆墉墊墐墓墘墜墝增墟墠墡墣墦墨墩墮墯墱墳墻墼墾壁壄壅壇壈壎壑壓壕壘壙壚壜壝壞壟壠壢壤壩士壬壯壴壹壺壻壼壽夂夃夊复夏夔夕外夙多夜夠夢夤夥大夨天太夫夬夭央夯失夲夷夸夾奄奅奇奈奉奎奏奐契奓奔奕套奘奚奠奡奢奧奩奪奫奬奭奮奰女奴奶奸她奼好妁如妃妄妊妍妎妐妒妓妖妗妙妝妞妠妢妣妤妥妨妬妮妯妲妳妸妹妺妻妾姁姆姊始姌姍姏姐姑姒姓委姘姙姚姜姝姞姣姤姥姦姨姪姬姮姱姹姺姻姽姿娀威娃娉娌娑娓娖娘娙娛娜娟娠娣娥娩娭娶娸娼婀婁婆婉婊婐婑婓婕婗婚婞婠婢婥婦婧婪婬婭婷婺婼婿媍媐媒媔媕媖媚媛媞媟媠媢媥媦媧媬媮媯媱媲媳媵媸媺媻媼媽媾媿嫁嫂嫄嫇嫈嫉嫋嫌嫏嫕嫖嫗嫘嫚嫛嫜嫟嫠嫡嫣嫥嫦嫩嫪嫫嫭嫮嫳嫵嫶嫺嫻嫽嫿嬃嬈嬉嬋嬌嬖嬗嬙嬛嬝嬡嬤嬥嬪嬬嬭嬯嬰嬲嬴嬸嬽嬾嬿孀孃孅孌子孑孓孔孕孖字存孚孛孜孝孟孢季孤孥孩孫孬孰孱孳孴孵學孺孼孽孿宀宁宂它宄宅宇守安宋完宎宏宓宕宗官宙定宛宜客宣室宥宦宧宬宮宰害宴宵家宸容宿寀寁寂寃寄寅密寇富寎寐寒寓寔寖寘寞察寡寢寤寥實寧寨審寫寬寮寯寰寱寵寶寸寺尀封尃射將專尉尊尋尌對導小少尖尚尟尠尢尤尥尨尩尪尬尰就尷尸尹尺尻尼尽尾尿局屁屄居屆屈屋屌屍屎屏屐屑展屘屙屜屝屠屢屣層履屧屨屩屬屭屮屯山屴屵屹屺屼岈岋岌岏岐岑岒岔岝岡岢岣岧岩岪岫岬岮岱岳岵岷岸岹峉峋峌峒峙峚峝峨峩峪峭峯峰峱峴島峻峽峿崁崆崇崍崎崐崑崒崓崔崖崗崙崚崛崞崟崡崢崤崦崧崩崮崱崴崽崿嵁嵂嵇嵊嵋嵌嵎嵐嵒嵞嵩嵫嵬嵯嵲嵷嵸嵽嵾嶀嶁嶂嶄嶇嶊嶍嶒嶓嶔嶕嶗嶙嶝嶞嶟嶠嶡嶢嶧嶪嶮嶰嶴嶷嶸嶺嶼嶽嶾巃巇巉巋巍巑巒巔巖巘巛巜川州巡巢工左巧巨巫差己已巳巴巵巷巹巽巾巿帀市布帆帊希帑帔帕帖帗帘帙帚帛帝帟帡帢帣帤帥帨帩師席帳帴帶帷常帽幀幃幄幅幈幋幌幎幐幔幕幗幘幙幛幝幞幟幠幡幢幣幦幨幩幪幫幬幭幮幰干平年幵并幷幸幹幺幻幼幽幾广庀庂庄庇庉床庋庌序底庖店庚府庠庢庣庤庥度座庪庫庬庭庮庳庵庶康庸庹庾廁廂廄廈廉廊廋廌廎廑廒廓廔廕廖廙廚廛廜廝廞廟廠廡廢廣廥廦廧廨廩廬廱廳廴廵延廷廸建廻廾廿弁弃弄弅弆弇弈弊弋式弒弓弔引弗弘弛弝弟弢弣弤弦弧弨弩弭弮弰弱張弶強弸强弼彀彃彄彆彈彉彊彋彌彍彎彏彐彔彖彗彘彙彛彝彠彡形彤彥彧彩彪彫彬彭彯彰影彳彴彷彸役彼彿往征徂徃待徇很徉徊律後徐徑徒得徘徙徛徜從徠御徥徨復循徬徭微徯徵德徹徼徽心必忉忌忍忐忑忒忕忖志忘忙忝忞忠忡忣忤忨忪快忭忮忱忲忳念忷忸忺忻忼忽忿怀怊怍怎怏怐怒怓怔怕怖怗怙怚怛怜思怠怡怢急怦性怨怩怪怫怬怭怮怯怱怲怳怵怹恁恂恃恆恇恉恌恍恐恑恒恓恔恕恙恚恝恟恠恢恣恤恥恧恨恩恪恫恬恭息恰恲恿悁悃悄悅悇悉悌悍悒悔悕悖悗悚悛悝悟悠悢患您悰悱悲悴悵悶悷悸悻悼悽悾惄情惆惇惋惌惎惏惑惓惔惕惘惙惚惛惜惝惟惠惡惢惦惪惰惱惲想惴惵惶惸惹惺惻惼惽惾愀愁愆愈愉愊愍愎意愐愒愓愔愕愖愙愚愛愜愞感愠愡愣愧愨愫愬愮愯愴愷愻愾愿慁慄慅慆慇慈慉慊態慌慍慎慓慕慘慙慚慝慞慟慠慢慣慥慧慨慫慬慮慰慱慲慳慴慵慶慷慺慼慾憀憁憂憃憇憊憋憍憎憐憑憒憔憖憙憚憛憝憟憤憧憨憩憪憫憬憮憯憱憲憶憸憹憺憾懁懂懃懅懆懇懈應懊懋懌懍懘懞懟懠懣懤懥懦懨懪懫懭懮懰懲懵懶懷懸懹懺懻懼懽懾懿戀戁戃戄戇戈戉戊戌戍戎成我戒戔戕或戚戛戞戟戡戢戣戤戥戧戩截戭戮戰戲戳戴戶戹戽戾房所扁扂扃扅扆扇扈扉扊手才扎扐扑扒打扔托扛扞扠扢扣扤扦扭扮扯扱扳扶批扺扼找承技抃抄抆抇抉把抌抏抑抒抓抔投抖抗折抛抝抨披抬抱抴抵抶抹抻押抽抿拂拄担拆拇拈拉拊拋拌拍拎拏拐拑拒拓拔拖拗拘拙拚招拜拫括拭拮拯拱拲拳拴拶拷拼拽拾拿持挂挃指挈按挋挌挐挑挓挖挨挪挫挬振挱挲挴挶挹挺挼挽挾捂捃捄捅捆捉捊捋捌捍捎捏捐捔捕捘捧捨捩捫捭据捯捱捲捵捶捷捺捻捽掀掁掂掃掄掆掇授掉掊掌掎掏掐排掔掖掗掘掙掛掞掠採探掣掤接控推掩措掫掬掭掮掯掰掱掾掿揀揃揄揅揆揉揊揍揎描提揑插揔揕揖揚換揜揝揞揟揠握揢揣揥揩揪揫揭揮揱揲揳援揵揶揹搆搉搊搋搌損搎搏搐搓搔搕搖搗搘搛搜搞搠搡搢搤搥搦搧搨搪搫搬搭搯搰搳搴搵搶搷搽搾搿摀摁摃摋摎摐摑摒摓摔摘摛摜摝摟摠摣摦摧摩摭摯摰摲摳摴摵摶摸摹摺摻摽撂撅撆撇撈撋撏撐撒撓撕撖撙撚撜撝撞撟撢撣撤撥撦撧撩撫撬播撮撰撲撳撻撼撽撾撿擀擁擂擄擅擇擉擊擋操擎擐擒擔擗擘據擠擢擣擤擦擧擨擩擫擬擭擯擰擱擲擴擷擺擻擾擿攀攂攄攆攉攏攔攕攖攘攙攛攜攝攞攟攠攢攣攤攥攦攧攩攪攫攬攭攮支攲攴攵收攷攸改攻放政敁故效敉敎敏救敓敔敕敖敗敘教敜敝敞敢散敦敧敪敫敬敲敳整敵敶敷數敹敺敻斀斁斂斃斄斅文斌斐斑斒斕斖斗料斚斛斜斝斟斠斡斤斥斧斨斫斬斮斯新斲斵斶斷斸方於施斾斿旁旂旃旄旅旆旊旋旌旍旎族旐旒旓旖旗旛旝旞旟无旡既旤日旦旨早旬旭旮旯旰旱旴旺旻旼昀昂昃昄昆昇昉昊昌明昏昒易昔昕昜昝昞星映昡春昧昨昫昬昭是昱昳昴昵昶昺晁時晃晅晉晌晏晒晙晚晛晜晝晞晟晡晢晤晦晧晨晬普景晰晳晴晶晷智晻晼晾暄暇暈暉暋暌暍暎暐暑暖暗暘暝暠暡暢暨暫暮暱暴暵暹暾曀曄曅曆曇曈曉曌曏曖曙曚曛曜曝曠曡曦曨曩曬曭曰曲曳更曶曷書曹曼曾替最會朅月有朋服朏朒朓朔朕朗朘望朝朞期朣朦朧木未末本札朮朱朳朴朵朶朹机朻朽朾朿杅杆杇杈杉杌李杏材村杓杕杖杗杘杙杜杞束杠杪杬杭杯杰東杲杳杴杵杶杷杻杼松板构枇枉枊枋枌枏析枑枒枓枕林枘枚果枝枟枯枰枲枳枴枵架枷枸枹枻柁柄柅柈柎柏某柑柒染柔柘柙柚柜柝柞柟柢柣查柧柩柬柮柯柰柱柲柳柴柵柶柷柿栒栓栔栖栗栘栙栝栟校栢栩株栭栱栲栳栴栵核根栻格栽桀桁桂桃桄桅框案桉桋桌桎桐桑桓桔桚桫桮桯桲桴桵桶桷桹桼桿梁梃梅梆梏梐梒梓梔梗梜條梟梠梡梢梣梧梨梩梭梮梯械梱梲梳梵棃棄棉棊棋棍棐棑棒棓棕棖棗棘棚棜棟棠棣棧棨棫棬森棰棱棲棵棶棷棸棹棺棻棼棽椀椄椅椇椈椌植椎椏椐椑椒椓椔椗椪椰椳椶椷椸椹椽椿楂楄楅楈楊楎楓楔楖楗楙楚楛楝楞楠楢楣楥楦楨楩楪楫楬業楮楯楰楱極楶楷楸楹概榆榑榔榕榖榘榛榜榣榤榦榧榨榫榭榮榰榱榴榶榷榻榼榾榿槀槁槃槅槊構槌槍槎槐槓槔槖槤槥槧槨槩槬槭槮槱槲槳槻槼槽槿樀樁樂樅樊樑樓樔樕樗標樛樝樞樟樠模樣樨樲樴樵樸樹樺樽樾樿橄橇橈橋橐橑橕橘橙橚橛橜機橠橡橢橤橦橧橪橫橿檀檁檃檄檇檉檍檎檐檑檔檕檖檗檛檜檝檞檟檠檢檣檥檬檮檯檳檸檻檽檿櫂櫃櫆櫈櫉櫋櫌櫓櫚櫛櫜櫝櫞櫟櫥櫧櫨櫪櫫櫬櫰櫱櫳櫸櫺櫻櫼欂欃欄權欏欐欑欒欖欙欛欝欞欠次欣欥欨欬欭欲欵欶欷欸欹欺欻欽款欿歂歃歆歇歈歉歊歋歌歍歎歐歑歔歕歗歘歙歛歜歟歠歡止正此步武歧歪歭歲歷歸歹歺死歾歿殀殂殃殄殆殈殉殊殍殑殖殗殘殙殛殜殞殟殠殢殣殤殥殪殫殭殮殯殰殲殳段殷殹殺殼殽殿毀毄毅毆毈毉毋毌母每毐毒毓比毖毗毘毚毛毡毣毧毨毫毬毯毰毲毳毷毸毹毽毾毿氀氁氂氃氄氅氆氈氉氊氋氌氍氏氐民氓气氕氖氘氙氚氛氟氠氡氣氤氥氦氧氨氪氫氬氮氯氰氳水永氾氿汀汁求汃汆汊汋汍汎汏汐汒汔汕汗汙汛汜汝汞江池污汧汪汭汯汰汲汴汶汸汹決汽汾沁沂沃沄沅沆沇沈沉沋沌沍沏沐沒沓沔沕沖沘沙沚沛没沫沬沭沮沱河沴沷沸油治沼沽沾沿況泂泄泅泆泉泊泌泐泓泔法泖泗泙泚泛泜泝泠泡波泣泥注泪泫泬泭泮泯泰泱泲泳泵洄洊洋洌洎洏洑洒洗洙洚洛洞洟津洧洨洩洪洫洭洮洱洲洳洴洵洶洸洹洺活洼洽派洿流浙浚浜浞浠浡浣浥浦浩浪浬浮浯浴海浸浹浼涂涅涇消涉涊涌涎涑涒涓涔涕涖涗涘涪涫涮涯液涳涴涵涷涸涼涾涿淂淄淅淆淇淈淋淌淑淒淖淘淙淚淜淝淞淟淠淡淢淤淥淦淨淩淪淫淬淮淯淰深淳淴淵淶混淹淺添淼渃清渙渚減渜渝渟渠渡渢渣渤渥渦渨温渫測渭港渰渲渳渴游渹渺渼渾湀湃湄湅湉湊湍湎湑湓湔湖湘湛湜湝湞湟湠湢湣湧湨湩湫湮湯湱湲湳湼溈溉溏源溔準溘溚溜溝溞溟溠溢溥溦溧溪溫溯溰溱溲溴溶溷溺溼溽滀滁滂滃滄滅滇滈滉滋滌滎滏滑滓滔滕滙滫滬滮滯滲滴滵滷滸滹滺滻滾滿漁漂漅漆漈漉漊漏漓演漕漘漙漚漠漢漣漦漩漪漫漬漭漯漰漱漲漳漵漶漷漸漻漼漾漿潀潁潎潏潑潔潘潚潛潝潞潟潠潢潤潦潬潭潮潯潰潲潸潺潼潾澀澁澂澄澆澇澈澉澌澍澎澐澒澓澔澗澟澠澡澣澤澥澦澧澨澩澭澮澱澳澴澶澹澼激濁濂濃濆濇濈濊濌濔濕濘濛濜濞濟濠濡濤濩濫濬濮濯濰濱濺濼濾濿瀁瀄瀅瀆瀇瀉瀋瀌瀍瀏瀑瀕瀘瀚瀛瀝瀟瀠瀡瀣瀦瀧瀨瀯瀰瀲瀳瀵瀸瀹瀺瀼瀾瀿灂灃灄灉灊灋灌灑灕灖灘灛灝灞灣灤灧灨灩火灰灶灸灺灼災灾炅炊炎炒炔炕炘炙炤炫炬炭炮炯炰炱炳炷炸為烈烊烋烏烕烖烘烙烜烝烟烤烯烱烴烷烹烺烽焄焉焊焌焐焗焙焚焜焞焠無焦焮焯焰焱然焿煁煅煆煇煉煌煎煏煒煖煙煜煞煠煢煣煤煥煦照煨煩煬煮煲煻煽熄熅熇熊熏熒熔熗熙熛熟熠熨熬熯熰熱熲熳熸熹熺熾燀燁燂燃燄燈燉燊燋燎燐燒燔燕燖燙燜營燠燡燥燦燧燬燭燮燴燹燻燼燾燿爁爂爆爇爊爍爐爓爚爛爝爟爢爣爨爪爬爭爰爵父爸爹爺爻爽爾爿牀牁牂牄牆片版牉牋牌牏牒牓牕牖牘牙牚牛牝牟牠牡牢牣牧物牬牮牯牲牴牷牸特牻牼牽牾牿犀犁犄犅犆犇犉犍犎犒犕犖犗犘犛犢犦犧犨犫犬犮犯犰犴犵犺犼犽犿狀狁狂狃狄狉狋狌狎狐狒狖狗狙狟狠狡狧狨狩狫狳狴狶狷狸狹狺狻狼狽猀猁猇猊猋猍猒猓猖猗猘猙猛猜猝猞猢猥猧猨猩猪猫猬猰猱猲猳猴猵猶猷猺猻猼猾猿獃獄獅獉獌獍獎獏獐獑獒獕獗獝獠獡獨獪獫獬獮獯獰獲獵獶獷獸獺獻獼獾玀玁玃玄玅率玈玉王玍玎玓玕玖玗玟玠玢玤玥玦玨玩玫玭玲玳玷玻玼珀珂珅珈珉珊珌珍珏珐珓珙珞珠珣珥珧珩珪班珮珵珽現琀球琅理琇琉琊琍琖琚琛琢琤琥琦琨琪琫琬琭琮琯琰琱琲琳琴琵琶琺琼琿瑀瑁瑄瑇瑉瑊瑋瑑瑒瑕瑗瑙瑚瑛瑜瑞瑟瑢瑣瑤瑩瑪瑭瑯瑰瑱瑲瑳瑽瑾瑿璀璁璃璅璆璇璈璉璊璋璐璘璚璜璞璟璠璣璦璧璨璩璪璫環璱璲璵璺璽璿瓀瓅瓊瓌瓏瓓瓔瓖瓘瓚瓛瓜瓝瓞瓟瓠瓢瓣瓤瓦瓬瓮瓴瓶瓷瓻瓽瓾瓿甁甃甄甆甋甌甍甎甏甑甒甓甔甕甖甗甘甚甜生甡產甥甦用甩甪甫甬甭甯田由甲申男甸甹町甽甾甿畀畇畋界畎畏畔留畚畛畜畝畟畢畤略畦畧番畫畬畮畯異當畷畸畹畺畽畿疁疃疆疇疊疋疎疏疐疑疒疔疙疚疝疢疣疤疥疧疫疰疱疲疳疴疵疸疹疻疼疽疾疿痀痁痂痃痄病痆症痊痌痍痎痏痒痔痕痗痘痙痛痝痞痠痡痢痣痤痦痧痯痰痱痲痳痴痶痹痺痻痼痾痿瘀瘁瘂瘃瘇瘈瘉瘊瘋瘌瘍瘏瘐瘓瘕瘖瘘瘙瘛瘝瘞瘟瘠瘡瘢瘣瘤瘥瘦瘧瘨瘩瘭瘯瘰瘱瘲瘳瘴瘵瘸瘺瘻瘼療癃癆癇癈癉癌癒癔癖癘癙癜癟癠癡癢癤癥癩癬癭癮癯癰癱癲癶癸癹登發白百皀皁皂皃的皆皇皈皋皎皐皓皕皖皙皚皜皞皤皥皦皪皫皭皮皯皰皴皷皸皺皻皽皿盂盃盅盆盈盉益盌盍盎盒盔盛盜盝盞盟盡監盤盥盦盧盩盪盬盭目盯盱盲盳直相盹盻盼盾省眄眇眈眉眊看眎眕眙眚眛眝真眠眡眢眥眦眨眩眭眯眲眴眵眶眷眸眹眺眼眽眾睃睄睅睆睇睊睋睍睎睏睒睗睚睛睜睞睟睠睡睢督睥睦睨睩睪睫睬睮睹睺睽睾睿瞀瞂瞄瞅瞇瞋瞌瞍瞎瞏瞑瞖瞘瞚瞞瞟瞠瞢瞤瞥瞧瞪瞫瞬瞭瞰瞳瞵瞶瞷瞻瞼瞽瞿矁矇矉矊矍矎矐矓矔矕矗矘矚矛矜矞矢矣知矦矧矩矬短矮矯矰矱矲石矸矻矼矽砂砆砈砉砌砍砐砑砒研砝砟砠砢砣砥砦砧砫砭砮砰砲破砵砷砸硃硅硇硉硌硎硒硜硝硠硤硥硨硪硫硬硭确硯硶硼碁碆碇碉碌碎碏碑碓碔碕碗碘碚碞碟碡碣碥碧碩碪碫碭碯碰碱碲碳碴確碻碼碾磁磅磈磉磊磋磌磎磏磐磑磔磕磚磞磠磣磧磨磪磬磯磲磴磶磷磺磻磼磽磾礁礄礉礌礎礓礙礛礞礤礦礧礨礩礪礫礬礮礱礴示礽社礿祀祁祂祅祆祇祈祉祊祏祐祓祔祕祖祗祚祛祜祝神祟祠祡祥祧票祫祭祲祺祼祿禀禁禊禋禍禎福禓禔禕禖禘禚禛禜禡禦禧禨禩禪禫禬禮禰禱禳禴禷禸禹禺禼禽禾禿秀私秆秈秉秊秋种秎秏科秒秔秕秖秘租秠秣秤秦秧秩秫秬秭秸移稀稂稃稅稈稉稊程稌稍稑稔稗稘稙稚稛稜稞稟稠稨稬稭種稰稱稷稹稻稼稽稾稿穀穄穅穆穈穉穊穋穌積穎穗穛穜穟穠穡穢穧穩穫穮穰穴究穸穹空穽穾穿窀突窄窅窆窈窊窋窌窐窒窔窕窖窗窘窞窟窠窣窨窩窪窬窮窯窱窳窵窶窸窺窻窾窿竁竄竅竇竈竊立竑竘站竚竝竟章竢竣童竦竪竫竭端竱競竷竹竺竽竿笄笅笆笈笊笋笏笐笑笔笘笙笛笞笠笢笤笥符笨笫第笭笮笯笱笲笳笴笵笸筅筆筇筈等筊筋筌筍筏筐筑筒答策筠筢筤筥筦筧筩筭筮筯筰筱筲筳筴筵筷箄箅箇箋箍箎箏箐箑箒箔箕算箘箙箜箝箠管箬箭箯箱箴箸箾節篁範篆篇築篋篌篔篘篙篚篛篝篠篡篣篤篥篦篨篩篪篰篱篲篳篷篸篹篻篼篽篾篿簀簃簆簇簉簋簌簍簎簏簑簙簜簞簟簠簡簣簦簧簨簪簫簬簭簰簳簷簸簹簺簽簾簿籀籃籉籊籋籌籍籐籑籓籔籖籙籛籜籝籟籠籣籤籥籧籩籪籬籮籯籰籲米籸籹籺籽粃粄粉粑粒粔粕粗粘粞粟粢粥粧粱粲粳粵粹粺粻粼粽精粿糅糈糉糊糌糍糒糕糖糗糙糜糝糞糟糠糢糧糨糪糬糯糰糱糲糴糶糸系糾紀紂紃約紅紆紇紈紉紊紋納紐紑紒紓純紕紖紗紘紙級紛紜紝紞紟素紡索紩紫紬紮累細紱紲紳紵紸紹紺紼紽紾紿絀絁終絃組絅絆絇絍絎絏結絓絕絖絚絛絜絝絞絡絢絣給絨絪絮絰統絲絳絹絺絻絿綀綁綃綅綆綈綉綌綍綎綏綑經綖綜綝綞綟綠綢綣綦綪綫綬維綮綯綰綱網綴綵綷綸綹綺綻綼綽綾綿緄緅緆緇緉緊緋緌緍緎緒緗緘緙線緜緝緞締緡緣緤緥緦緧編緩緪緫緬緯緱緲練緶緹緺緻縁縈縉縊縋縏縐縑縓縕縗縛縝縞縟縠縢縣縧縩縪縫縭縮縰縱縲縳縴縵縶縷縸縹縻總績縿繁繃繄繅繆繇繈繐繑繒織繕繖繘繙繚繜繞繟繠繡繢繣繦繨繩繪繫繭繮繯繰繳繴繵繶繸繹繻繼繽繾纀纁纂纆纇纈纊纋續纍纏纑纓纔纕纖纘纚纛纜缶缸缹缺缽缾缿罃罄罅罇罈罋罌罍罎罏罐网罔罕罘罛罜罝罞罟罠罡罣罥罦罨罩罪罫罬罭置罰罱署罳罵罶罷罹罺罻罽罾罿羅羆羇羈羉羊羋羌美羑羓羔羕羖羚羜羝羞羢羣群羥羧羨義羭羯羰羱羲羳羴羵羶羸羹羼羽羿翀翁翂翃翅翊翌翎習翔翕翛翜翟翠翡翢翣翥翦翨翩翫翬翮翯翰翱翲翳翶翹翻翼翽翾翿耀老考耄者耆耇耈耉耋而耍耎耏耐耑耒耔耕耖耗耘耙耜耞耡耤耦耨耬耰耳耵耶耷耼耽耾耿聃聆聊聐聒聖聘聚聝聞聯聰聱聲聳聵聶職聹聽聾聿肄肅肆肇肉肊肋肌肎肏肐肓肕肖肘肚肛肜肝股肢肥肩肪肫肬肭肮肯肱育肴肵肸肹肺肽胂胃胄胇胈胉胊背胎胏胑胔胕胖胗胙胚胛胜胝胞胠胡胣胤胥胦胭胯胰胱胳胴胵胸胹胺胼能胾脀脂脃脅脆脇脈脉脊脔脖脗脘脛脝脞脟脡脢脣脤脧脩脫脬脭脯脰脹脺脾腆腊腋腌腍腎腐腑腒腓腔腕腛腜腠腡腤腥腦腧腩腫腭腮腯腰腱腳腴腶腷腸腹腺腼腿膀膂膃膆膇膈膊膋膍膏膗膘膚膛膜膝膞膠膣膦膨膩膪膬膮膰膱膳膴膵膷膹膺膻膽膾膿臀臁臂臃臄臅臆臉臊臌臍臏臐臑臕臗臘臚臛臝臞臟臠臢臣臤臥臧臨自臬臭臯臲至致臷臺臻臼臾臿舀舁舂舄舅與興舉舊舌舍舐舒舔舕舖舚舛舜舝舞舟舠舡舢舨航舫般舯舲舳舴舵舶舷舸船舺艄艅艇艉艋艎艏艑艓艖艘艙艛艟艤艦艨艫艭艮良艱色艴艵艷艸艽艾芃芄芅芊芋芍芎芏芐芑芒芔芘芙芚芝芟芡芣芥芧芨芩芪芫芬芭芮芯芰花芳芴芵芷芸芹芺芻芼芽芾苄苑苒苓苔苕苖苗苙苛苜苞苟苡苢苣若苦苧苫苯英苲苳苴苶苷苹苺苻苾茁茂范茄茅茆茇茈茉茌茍茖茗茙茛茜茝茨茩茪茫茬茭茯茱茲茳茴茵茶茷茸茹茺茻茼荀荂荃荄荅荇荈草荊荍荎荏荐荑荒荓荔荳荴荵荷荸荻荼荽莁莂莆莉莊莎莏莒莓莔莕莖莘莙莛莝莞莠莢莧莨莩莪莫莽莿菀菁菂菅菆菇菉菊菌菑菓菔菖菘菙菜菝菞菟菠菡菢菩菫華菰菱菲菴菶菸菹菻菼菽萁萃萄萆萇萊萋萌萍萎萏萐萑萩萬萭萯萰萱萲萴萵萷萸萹萼落葄葅葆葉葍葑葒葖著葚葛葞葟葡董葦葧葩葫葬葭葯葰葳葴葵葶葷葸葹葺葽蒂蒍蒐蒒蒔蒕蒗蒘蒙蒜蒞蒟蒡蒢蒨蒩蒪蒭蒯蒱蒲蒴蒸蒹蒺蒻蒼蒿蓀蓁蓂蓄蓆蓉蓊蓋蓌蓍蓎蓏蓐蓑蓓蓖蓧蓩蓫蓬蓮蓯蓰蓱蓲蓳蓴蓷蓺蓼蓽蓿蔀蔂蔇蔈蔉蔊蔌蔎蔏蔑蔓蔔蔗蔘蔚蔞蔟蔠蔡蔣蔤蔥蔦蔧蔪蔫蔬蔭蔯蔱蔴蔻蔽蕀蕁蕃蕅蕆蕈蕉蕊蕎蕑蕓蕕蕖蕘蕙蕝蕞蕡蕢蕣蕤蕨蕩蕪蕭蕮蕸蕹蕺蕻蕾薀薁薄薅薆薇薈薊薌薏薐薑薔薖薙薛薜薝薞薟薠薢薤薦薨薩薪薯薰薱薴薶薷薹薺薿藂藃藇藉藋藍藎藏藐藑藕藙藚藜藝藟藣藤藥藨藩藪藫藭藳藴藶藷藸藹藺藻藾藿蘀蘁蘂蘄蘅蘆蘇蘉蘊蘋蘑蘗蘘蘙蘚蘞蘠蘡蘢蘦蘧蘩蘪蘭蘮蘸蘹蘺蘼蘾蘿虀虆虍虎虐虒虓虔處虖虗虙虛虜虞號虡虢虣虤虧虩虫虬虯虱虵虷虹虺虻虼蚇蚊蚋蚌蚍蚑蚓蚕蚜蚡蚢蚣蚤蚧蚨蚩蚪蚯蚰蚱蚳蚴蚵蚶蚷蚸蚹蚺蚻蚿蛀蛁蛂蛄蛆蛇蛉蛋蛐蛑蛓蛔蛖蛗蛙蛛蛜蛞蛟蛢蛣蛤蛩蛬蛭蛸蛹蛺蛻蛼蛾蜀蜂蜃蜄蜆蜇蜈蜉蜊蜋蜌蜍蜎蜑蜒蜓蜘蜙蜚蜜蜞蜡蜢蜣蜤蜥蜨蜩蜮蜯蜰蜱蜲蜴蜷蜹蜺蜻蜼蜾蜿蝀蝂蝃蝌蝍蝎蝐蝒蝓蝔蝕蝖蝗蝘蝙蝚蝛蝜蝟蝠蝡蝣蝤蝥蝦蝨蝮蝯蝱蝲蝳蝴蝶蝸蝹蝻螂螃螄螅螇螈螋螌融螓螖螗螘螞螟螠螢螣螫螬螭螯螰螲螳螵螹螺螻螼螽螾螿蟀蟄蟅蟆蟇蟈蟊蟋蟑蟒蟙蟛蟟蟠蟢蟣蟥蟪蟫蟬蟭蟮蟯蟲蟳蟶蟷蟹蟺蟻蟾蟿蠁蠃蠅蠆蠉蠊蠋蠍蠏蠐蠑蠓蠔蠕蠖蠙蠛蠜蠟蠠蠡蠢蠣蠧蠨蠭蠯蠰蠱蠲蠵蠶蠷蠹蠻蠼血衁衃衄衈衊衋行衍衎衒術衕街衙衚衛衝衞衠衡衢衣表衩衪衫衮衯衰衱衲衷衹衺衽衾衿袀袁袂袄袈袋袍袎袑袒袖袗袙袛袜袞袟袠袡袢袤袧袨袪被袱袴袷袺袼袽袾袿裀裁裂裉裊裋裌裎裏裒裓裔裕裖裘裙裛補裝裟裡裧裨裩裯裰裱裲裳裴裶裸裹裻裼製裾褂複褊褋褌褎褐褒褓褔褕褖褘褙褚褟褡褢褥褦褧褪褫褭褯褰褱褲褳褵褶褷褸褻褼褽褾襀襁襂襃襄襆襉襌襍襏襒襓襖襗襘襚襛襜襝襞襟襠襡襢襣襤襦襪襫襬襭襮襯襲襳襴襵襶襻襼襾西要覂覃覆覈覊見規覓覕視覘覛覜覡覥覦覩親覬覯覰覲覶覷覺覼覽覿觀角觓觔觕觖觚觜觝觡解觤觥觩觫觭觰觱觳觴觵觶觷觸觿言訂訃訄訇計訊訌討訏訐訑訒訓訕訖託記訛訝訞訟訢訣訥訧訩訪訬設訰許訴訶訹診註証訾訿詀詁詄詅詆詈詎詐詒詔評詖詗詘詙詛詞詠詡詢詣試詧詩詫詬詭詮詰話該詳詵詶詹詻詼詿誂誃誄誅誆誇誋誌認誏誑誒誓誕誖誘誙誚語誠誡誣誤誥誦誨說誰課誶誹誻誼誾調諂諄諆談諉請諍諏諑諒諓諔諕論諗諛諜諝諞諟諠諡諢諤諦諧諫諭諮諰諱諳諴諵諶諷諸諺諼諾謀謁謂謄謅謇謈謊謋謌謎謏謐謔謖謗謙謚講謝謞謟謠謣謥謦謨謫謬謯謰謳謵謷謹謻謼謾譁譆譇證譊譌譎譏譔譕譖識譙譚譜譟譣警譨譫譬譯議譴護譸譽譾讀讁讅讆讇變讋讌讎讐讒讓讔讕讖讘讙讚讜讞讟谷谹谽谿豁豆豇豈豉豊豋豌豎豐豔豕豗豚豜豝象豢豨豪豫豬豭豳豵豶豷豸豹豺豻貂貅貆貉貊貌貍貏貐貒貓貔貕貗貘貙貛貝貞負財貢貣貤貧貨販貪貫責貯貰貲貳貴貶買貸貺費貼貽貾貿賀賁賂賃賄賅資賈賊賑賒賓賕賙賚賛賜賝賞賠賡賢賣賤賦賨質賫賬賭賮賴賵賷賸賺賻購賽賾贄贅贇贈贊贍贏贐贓贔贕贖贗贛贜赤赦赧赨赩赫赬赭赮赯走赳赴赶起赸趁趄超越趑趓趔趕趙趟趠趡趣趦趨趫趬趮趯趲足趴趵趷趹趺趼趾趿跂跅跆跇跋跌跎跏跐跑跓跕跖跗跚跛距跟跡跢跣跤跦跧跨跩跪跫跬跮路跱跲跳跴跺跼跽跿踁踂踅踆踈踉踊踏踐踔踕踖踘踝踞踟踠踡踢踣踤踥踦踧踩踪踫踮踰踱踳踴踵踶踸踹踽蹀蹁蹂蹄蹅蹇蹈蹉蹊蹋蹌蹍蹎蹏蹐蹓蹔蹕蹙蹚蹜蹝蹞蹟蹠蹡蹢蹣蹤蹦蹧蹩蹪蹬蹭蹮蹯蹲蹳蹴蹶蹺蹻蹼躁躂躃躄躅躆躇躈躉躊躋躍躐躑躒躓躔躕躗躚躞躟躠躡躣躥躦躧躩躪身躬躭躲躶躺軀軃車軋軌軍軏軑軒軔軘軛軜軟軥軨軫軬軯軱軷軸軹軺軻軼軾軿輀輂較輅輇輈載輊輐輒輓輔輕輖輗輘輙輚輛輜輝輞輟輠輣輥輦輩輪輬輭輮輯輲輳輴輶輷輸輹輻輾輿轀轂轄轅轆轇轉轍轎轏轐轑轒轓轔轕轖轗轘轙轚轜轝轟轠轡轢轣轤辛辜辞辟辠辡辣辦辨辭辮辯辰辱農辴辵边迂迄迅迆迋迍迎近迒迓返迕迢迤迥迦迨迪迫迭迮述迴迷迸迹迺迻追迿退送适逃逄逅逆逈逋逌逍透逐逑递途逕逖逗這通逛逝逞速造逡逢連逤逩逭逮逯週進逴逵逶逸逼逾逿遁遂遄遇遊運遍過遏遐遑遒道達違遘遙遛遜遝遞遟遠遡遢遣遨適遬遭遮遯遰遲遳遴遵遶遷選遹遺遻遼遽避邀邁邂邃還邅邇邈邊邋邏邐邑邕邗邘邙邛邠邡邢那邥邦邧邨邪邯邰邱邲邳邴邵邶邸邽邾邿郁郃郄郅郇郈郊郎郔郕郗郘郙郚郛郜郝郟郠郡郢郣郤部郪郫郭郯郰郲郳郴郵郼都郾郿鄀鄂鄄鄆鄇鄉鄍鄎鄏鄐鄑鄒鄔鄖鄗鄘鄙鄚鄜鄞鄠鄡鄢鄣鄤鄦鄧鄩鄪鄫鄬鄭鄮鄯鄰鄱鄲鄳鄴鄶鄸鄹鄺鄾酁酃酅酆酇酈酉酊酋酌配酎酏酐酒酖酗酘酚酟酠酡酢酣酤酥酧酩酪酬酮酯酲酳酴酵酶酷酸酹酺醁醃醅醆醇醉醊醋醍醐醑醒醓醚醛醜醞醟醡醢醣醥醨醪醫醬醭醮醯醰醱醲醳醴醵醹醺醻醼醽醾釀釁釂釃釅釆采釉釋里重野量釐金釓釔釕釗釘釙釜針釢釣釤釦釧釩釭釱釵釷釹釾釿鈀鈁鈃鈆鈇鈉鈍鈎鈐鈑鈒鈔鈕鈚鈜鈞鈣鈥鈦鈧鈮鈰鈳鈴鈷鈸鈹鈺鈽鈾鈿鉀鉅鉈鉉鉋鉍鉏鉑鉒鉕鉗鉚鉛鉞鉠鉢鉤鉥鉦鉧鉬鉭鉲鉳鉶鉷鉸鉺鉻鉼鉿銀銃銅銍銎銑銓銕銖銗銘銚銛銜銠銣銥銦銧銨銩銪銫銬銱銲銳銶銷銹銻銼鋁鋂鋃鋅鋇鋈鋋鋌鋏鋐鋒鋙鋝鋟鋣鋤鋦鋧鋨鋩鋪鋮鋯鋰鋱鋸鋹鋼錁錄錆錏錐錒錕錘錙錚錛錞錟錠錡錢錣錦錧錨錩錫錮錯錳錶錸錼鍅鍆鍇鍉鍊鍋鍌鍍鍑鍔鍖鍘鍚鍛鍠鍤鍥鍩鍪鍫鍬鍭鍮鍰鍳鍵鍶鍺鍼鍾鎂鎊鎏鎔鎖鎗鎘鎚鎛鎝鎞鎡鎢鎦鎧鎩鎪鎬鎮鎰鎳鎴鎵鎷鏁鏃鏇鏈鏊鏌鏍鏐鏑鏖鏗鏘鏙鏚鏜鏝鏞鏟鏡鏢鏤鏦鏨鏮鏵鏷鏹鏽鐃鐇鐋鐍鐎鐏鐐鐒鐓鐔鐕鐘鐙鐠鐧鐨鐫鐭鐮鐲鐳鐵鐶鐸鐺鐻鐿鑀鑄鑊鑌鑑鑒鑔鑕鑞鑠鑢鑣鑤鑥鑪鑫鑭鑮鑯鑰鑱鑲鑵鑷鑹鑼鑽鑾鑿钁钂長镼門閂閃閆閈閉開閌閎閏閑閒間閔閘閙閛閞閟閡閣閤閥閦閧閨閩閫閬閭閱閶閹閻閼閽閾閿闃闆闇闈闉闊闋闌闍闐闑闒闓闔闕闖闚關闞闟闠闡闢闤闥阜阞阡阢阤阨阪阫阬阮阯阰阱防阸阺阻阼阽阿陀陂附陊陋陌降陏限陔陘陛陜陝陞陟陡院陣除陪陬陰陲陳陴陵陶陷陸陻陼陽陾隃隄隅隆隈隉隊隋隍階隔隕隗隘隙際障隟隣隤隥隧隨隩險隮隰隱隳隴隶隸隹隻隼雀雁雄雅集雇雈雉雊雋雌雍雎雒雔雕雖雘雙雛雜雝雞離難雥雨雩雪雯雰雱雲零雷雹雺電需霂霄霅霆震霈霉霍霎霏霑霓霖霙霜霝霞霢霣霤霧霪霰露霸霹霽霾霿靁靂靄靆靈靉青靖静靚靛靜非靠靡面靦靧靨革靪靭靮靳靴靶靷靸靺靼靾靿鞀鞃鞄鞅鞈鞉鞋鞍鞏鞓鞔鞗鞘鞙鞚鞜鞞鞠鞣鞥鞦鞨鞪鞫鞬鞭鞮鞲鞴鞵鞶鞸鞹鞻鞼鞾鞿韀韁韂韃韄韅韆韈韉韋韌韍韎韐韓韔韗韘韙韜韝韞韟韠韡韣韤韭韰音韶韻韽響頁頂頃頄項順頇須頊頌頍頎頏預頑頒頓頖頗領頜頝頞頟頠頡頤頦頩頫頭頮頯頰頲頳頴頵頷頸頹頻顄顆顇顋題額顎顏顑顒顓顗願顙顛顜類顠顢顣顥顦顧顫顬顯顰顱顳顴風颩颭颮颯颱颲颳颶颸颺颻颼颿飀飁飂飄飆飇飈飉飋飛飜食飡飢飣飥飧飩飪飫飭飯飰飱飲飴飶飼飽飾飿餁餂餃餅餈餉養餌餐餑餒餓餔餕餖餗餘餚餛餜餞餟餠餡餤餦餧館餩餪餫餬餭餮餱餲餳餴餵餶餹餺餼餽餾餿饁饃饅饆饈饉饊饋饌饍饎饐饑饒饔饕饗饘饙饛饜饝饞饟饠饡首馗馘香馝馞馡馥馨馬馭馮馯馱馲馳馴馵馹駁駃駉駊駍駏駐駑駒駓駔駕駘駙駛駜駝駞駟駢駪駬駭駮駰駱駴駵駷駸駹駺駻駼駾駿騀騁騂騃騄騅騉騊騋騌騍騎騏騑騕騖騙騜騞騠騣騤騧騫騬騭騮騰騲騵騶騷騸騺騾驀驁驂驃驄驅驈驉驊驌驍驎驏驒驔驕驖驗驘驚驛驟驢驤驥驦驩驪骨骫骭骯骰骲骳骴骶骷骸骹骻骼骾骿髀髁髂髆髊髏髐髑髒髓體髕髖高髟髠髡髢髣髦髧髩髫髭髮髯髲髳髴髶髹髻髼髽髾髿鬀鬃鬄鬅鬆鬇鬈鬉鬋鬌鬍鬐鬑鬒鬖鬘鬙鬚鬟鬡鬢鬣鬥鬧鬨鬩鬫鬭鬮鬯鬱鬲鬴鬵鬷鬺鬻鬼鬾魁魂魃魄魅魆魈魊魋魍魎魏魑魔魘魚魟魠魦魨魬魭魯魴魶魷鮀鮅鮆鮋鮎鮐鮑鮒鮓鮚鮞鮟鮠鮡鮦鮨鮪鮫鮭鮮鮸鮻鮿鯀鯁鯇鯈鯉鯊鯓鯔鯖鯗鯛鯜鯠鯡鯢鯤鯧鯨鯪鯫鯰鯶鯷鯽鯿鰂鰈鰉鰌鰍鰐鰒鰓鰕鰜鰣鰥鰩鰫鰭鰮鰱鰲鰴鰵鰷鰹鰻鰼鰾鰿鱄鱆鱇鱈鱉鱍鱒鱓鱔鱖鱗鱘鱞鱟鱠鱣鱧鱨鱭鱮鱷鱸鱺鱻鳥鳦鳧鳩鳪鳬鳲鳳鳴鳶鳷鳽鴂鴃鴆鴇鴈鴉鴐鴒鴕鴗鴘鴛鴝鴞鴟鴣鴥鴦鴨鴰鴳鴴鴷鴻鴽鴾鴿鵀鵁鵂鵃鵊鵋鵌鵑鵒鵓鵔鵕鵚鵜鵝鵞鵟鵠鵡鵧鵩鵪鵬鵮鵯鵰鵲鵶鵷鵻鶂鶄鶆鶉鶊鶋鶒鶖鶗鶘鶚鶝鶡鶢鶤鶩鶪鶬鶯鶱鶴鶵鶹鶺鶻鶼鶿鷁鷂鷃鷅鷇鷈鷊鷑鷓鷕鷖鷗鷘鷙鷚鷞鷟鷥鷦鷧鷩鷫鷯鷲鷳鷴鷸鷹鷺鷽鷾鷿鸂鸃鸇鸊鸎鸏鸐鸑鸒鸔鸕鸚鸛鸜鸝鸞鹵鹹鹺鹼鹽鹿麀麁麂麃麄麅麇麈麋麌麐麑麒麓麕麗麛麝麞麟麤麥麨麩麮麯麰麴麵麻麼麽麾黁黂黃黄黈黌黍黎黏黐黑黓黔黕默黚黛黜黝點黟黠黤黥黦黧黨黭黮黯黰黲黳黴黶黷黹黻黼黽黿鼂鼃鼄鼅鼆鼇鼈鼉鼎鼏鼐鼒鼓鼕鼖鼗鼙鼚鼛鼠鼢鼥鼩鼫鼬鼮鼯鼱鼲鼴鼵鼷鼹鼻鼽鼾齁齆齇齉齊齋齌齍齎齏齒齔齕齖齗齘齙齚齜齞齟齠齡齣齦齧齪齬齭齮齯齰齱齲齵齶齷齹齺齾龍龐龑龔龕龜龠龢龤")

# Zhuyin/Bopomofo
# https://en.wikipedia.org/wiki/Bopomofo
zhuyin=set("ㄅㄆㄇㄈㄉㄊㄋㄌㄍㄎㄏㄐㄑㄒㄓㄔㄕㄖㄗㄘㄙㄚㄛㄜㄝㄞㄟㄠㄡㄢㄣㄤㄥㄦㄧㄨㄩㄪㄫㄬㄭㄮㄯㆠㆡㆢㆣㆤㆥㆦㆧㆨㆩㆪㆫㆬㆭㆮㆯㆰㆱㆲㆳㆴㆵㆶㆷㆸㆹㆺㆻㆼㆽㆾㆿˉˊˇˋ˙̄́̌̀·")

##############
## Japanese ##
##############

## TODO: sort by Shinjitai and Kyūjitai
# tōyō kanji (1946-1981, shinjitai [simplified])
# https://en.wikipedia.org/wiki/T%C5%8Dy%C5%8D_kanji#List_of_the_1,850_t%C5%8Dy%C5%8D_kanji
kanjiToyo1946=set("一丁七丈三上下不且世丘丙中丸丹主久乏乗乙九乳乾乱了事二互五井亜亡交享京人仁今介仕他付代令以仰仲件任企伏伐休伯伴伸伺似但位低住佐何仏作佳使来例侍供依侮侯侵便係促俊俗保信修俳俵併倉個倍倒候借倣値倫仮偉偏停健側偶傍傑備催伝債傷傾働像僚偽僧価儀億倹儒償優元兄充兆先光克免児入内全両八公六共兵具典兼冊再冒冗冠冬冷准凍凝凡凶出刀刃分切刈刊刑列初判別利到制刷券刺刻則削前剖剛剰副割創劇剤剣力功加劣助努効劾勅勇勉動勘務勝労募勢勤勲励勧勺匁包化北匠匹匿区十千升午半卑卒卓協南博占印危却卵巻卸即厘厚原去参又及友反叔取受口古句叫召可史右司各合吉同名后吏吐向君吟否含呈呉吸吹告周味呼命和咲哀品員哲唆唐唯唱商問啓善喚喜喪喫単嗣嘆器噴嚇厳嘱囚四回因困固圏国囲園円図団土在地坂均坊坑坪垂型埋城域執培基堂堅堤堪報場塊塑塔塗境墓墜増墨堕墳墾壁壇圧塁壊士壮壱寿夏夕外多夜夢大天太夫央失奇奉奏契奔奥奪奨奮女奴好如妃妊妙妥妨妹妻姉始姓委姫姻姿威娘娯娠婆婚婦婿媒嫁嫡嬢子孔字存孝季孤孫学宅宇守安完宗官宙定宜客宣室宮宰害宴家容宿寂寄密富寒察寡寝実寧審写寛寮宝寸寺封射将専尉尊尋対導小少就尺尼尾尿局居届屈屋展層履属山岐岩岸峠峰島峡崇崩岳川州巡巣工左巧巨差己市布帆希帝帥師席帳帯常帽幅幕幣干平年幸幹幻幼幽幾床序底店府度座庫庭庶康庸廉廊廃広庁延廷建弊式弓弔引弟弦弧弱張強弾形彩彫彰影役彼往征待律後徐径徒得従御復循微徴徳徹心必忌忍志忘忙忠快念怒怖思怠急性怪恒恐恥恨恩恭息悦悔悟患悲悼情惑惜恵悪惰悩想愁愉意愚愛感慎慈態慌慕惨慢慣慨慮慰慶憂憎憤憩憲憶憾懇応懲懐懸恋成我戒戦戯戸房所扇手才打扱扶批承技抄抑投抗折抱抵押抽払拍拒拓抜拘拙招拝括拷拾持指振捕捨掃授掌排掘掛採探接控推措描提揚換握掲揮援損揺捜搬携搾摘摩撤撮撲擁択撃操担拠擦挙擬拡摂支収改攻放政故叙教敏救敗敢散敬敵敷数整文斗料斜斤斥新断方施旅旋族旗既日旨早旬昇明易昔星映春昨昭是時晩昼普景晴晶暇暑暖暗暫暮暴暦曇暁曜曲更書替最会月有服朕朗望朝期木未末本札朱机朽材村束杯東松板析林枚果枝枯架柄某染柔査柱柳校株核根格栽桃案桑梅条械棄棋棒森棺植業極栄構概楽楼標枢模様樹橋機横検桜欄権次欲欺款歌欧歓止正歩武歳歴帰死殉殊殖残段殺殿殴母毎毒比毛氏民気水氷永求汗汚江池決汽沈没沖河沸油治沼沿況泉泊泌法波泣注泰泳洋洗津活派流浦浪浮浴海浸消渉液涼淑涙淡浄深混清浅添減渡測港渇湖湯源準温溶滅滋滑滞滴満漁漂漆漏演漢漫漸潔潜潤潮渋澄沢激濁濃湿済濫浜滝瀬湾火灰災炊炎炭烈無焦然煮煙照煩熟熱燃燈焼営燥爆炉争為爵父片版牛牧物牲特犠犬犯状狂狩狭猛猶獄独獲猟獣献玄率玉王珍珠班現球理琴環璽甘生産用田由甲申男町界畑畔留畜畝略番画異当畳疎疑疫疲疾病症痘痛痢痴療癖登発白百的皆皇皮皿盆益盛盗盟尽監盤目盲直相盾省看真眠眼着睡督瞬矛矢知短石砂砲破研硝硫硬碁砕碑確磁礁礎示社祈祉秘祖祝神祥票祭禁禍福禅礼秀私秋科秒租秩移税程稚種称稲稿穀積穂穏穫穴究空突窒窓窮窯窃立並章童端競竹笑笛符第筆等筋筒答策箇算管箱節範築篤簡簿籍米粉粒粗粘粧粋精糖糧系糾紀約紅紋納純紙級紛素紡索紫累細紳紹紺終組結絶絞絡給統糸絹経緑維綱網綿緊緒線締縁編緩緯練縛県縫縮縦総績繁織繕絵繭繰継続繊欠罪置罰署罷羊美群義羽翁翌習翼老考者耐耕耗耳聖聞声職聴粛肉肖肝肥肩肪肯育肺胃背胎胞胴胸能脂脅脈脚脱脹腐腕脳腰腸腹膚膜膨胆臓臣臨自臭至致台与興旧舌舎舗舞舟航般舶船艇艦良色芋芝花芳芽苗若苦英茂茶草荒荷荘茎菊菌菓菜華万落葉著葬蒸蓄薄薦薪薫蔵芸薬藩虐処虚虜虞号蚊融虫蚕蛮血衆行術街衝衛衡衣表衰衷袋被裁裂裏裕補装裸製複襲西要覆見規視親覚覧観角解触言訂計討訓託記訟訪設許訴診詐詔評詞詠試詩詰話該詳誇誌認誓誕誘語誠誤説課調談請論諭諮諸諾謀謁謄謙講謝謡謹証識譜警訳議護誉読変譲谷豆豊豚象豪予貝貞負財貢貧貨販貫責貯弐貴買貸費貿賀賃賄資賊賓賜賞賠賢売賦質頼購贈賛赤赦走赴起超越趣足距跡路跳踊踏践躍身車軌軍軒軟軸較載軽輝輩輪輸轄転辛弁辞辱農込迅迎近返迫迭述迷追退送逃逆透逐途通速造連逮週進逸遂遇遊運遍過道達違逓遠遣適遭遅遵遷選遺避還辺邦邪邸郊郎郡部郭郵都郷配酒酢酬酪酵酷酸酔醜医醸釈里重野量金針鈍鈴鉛銀銃銅銑銘鋭鋼録錘錠銭錯錬鍛鎖鎮鏡鐘鉄鋳鑑鉱長門閉開閑間閣閥閲関防阻附降限陛院陣除陪陰陳陵陶陥陸陽隆隊階隔際障隣随険隠隷隻雄雅集雇雌双雑離難雨雪雲零雷電需震霜霧露霊青静非面革音韻響頂項順預頒領頭題額顔願類顧顕風飛翻食飢飲飯飼飽飾養餓余館首香馬駐騎騰騒駆験驚駅骨髄体高髪闘鬼魂魅魔魚鮮鯨鳥鳴鶏塩麗麦麺麻黄黒黙点党鼓鼻斎歯齢")

# The Jouyou Kanji
kanjiJoyo1981=(kanjiToyo1946-set('燈'))|set('灯')|set("猿凹渦靴稼拐涯垣殻潟喝褐缶頑挟矯襟隅渓蛍嫌洪溝昆崎皿桟傘肢遮蛇酌汁塾尚宵縄壌唇甚据杉斉逝仙栓挿曹槽藻駄濯棚挑眺釣塚漬亭偵泥搭棟洞凸屯把覇漠肌鉢披扉猫頻瓶雰塀泡俸褒朴僕堀磨抹岬妄厄癒悠羅竜戻枠")
kanjiJoyo2010=(kanjiJoyo1981-set("勺銑脹錘匁"))|set("媛怨鬱唄淫咽茨彙椅萎畏嵐宛顎曖挨韓鎌葛骸蓋崖諧潰瓦牙苛俺臆岡旺艶稽憬詣熊窟串惧錦僅巾嗅臼畿亀伎玩挫沙痕頃駒傲乞喉梗虎股舷鍵拳桁隙呪腫嫉𠮟叱鹿餌摯恣斬拶刹柵埼塞采戚脊醒凄裾須腎芯尻拭憧蹴羞袖汰遜捉踪痩曽爽遡狙膳箋詮腺煎羨鶴爪椎捗嘲貼酎緻綻旦誰戴堆唾鍋謎梨奈那丼貪頓栃瞳藤賭妬塡填溺諦阜訃肘膝眉斑阪汎氾箸剝剥罵捻虹匂喩闇弥冶麺冥蜜枕昧勃頰頬貌蜂蔑璧餅蔽脇麓籠弄呂瑠瞭侶慄璃藍辣拉沃瘍妖湧柿哺楷睦釜錮賂毀勾")

# http://nihongo.monash.edu/jouyoukanji.html
kanjiGrade1=set("一九七二人入八力十下三千上口土夕大女子小山川五天中六円手文日月木水火犬王正出本右四左玉生田白目石立百年休先名字早気竹糸耳虫村男町花見貝赤足車学林空金雨青草音校森")
kanjiGrade2=set("刀万丸才工弓内午少元今公分切友太引心戸方止毛父牛半市北古台兄冬外広母用矢交会合同回寺地多光当毎池米羽考肉自色行西来何作体弟図声売形汽社角言谷走近里麦画東京夜直国姉妹岩店明歩知長門昼前南点室後春星海活思科秋茶計風食首夏弱原家帰時紙書記通馬高強教理細組船週野雪魚鳥黄黒場晴答絵買朝道番間雲園数新楽話遠電鳴歌算語読聞線親頭曜顔")
kanjiGrade3=set("丁予化区反央平申世由氷主仕他代写号去打皮皿礼両曲向州全次安守式死列羊有血住助医君坂局役投対決究豆身返表事育使命味幸始実定岸所放昔板泳注波油受物具委和者取服苦重乗係品客県屋炭度待急指持拾昭相柱洋畑界発研神秒級美負送追面島勉倍真員宮庫庭旅根酒消流病息荷起速配院悪商動宿帳族深球祭第笛終習転進都部問章寒暑植温湖港湯登短童等筆着期勝葉落軽運遊開階陽集悲飲歯業感想暗漢福詩路農鉄意様緑練銀駅鼻横箱談調橋整薬館題")
kanjiGrade4=set("士不夫欠氏民史必失包末未以付令加司功札辺印争仲伝共兆各好成灯老衣求束兵位低児冷別努労告囲完改希折材利臣良芸初果刷卒念例典周協参固官底府径松毒泣治法牧的季英芽単省変信便軍勇型建昨栄浅胃祝紀約要飛候借倉孫案害帯席徒挙梅残殺浴特笑粉料差脈航訓連郡巣健側停副唱堂康得救械清望産菜票貨敗陸博喜順街散景最量満焼然無給結覚象貯費達隊飯働塩戦極照愛節続置腸辞試歴察旗漁種管説関静億器賞標熱養課輪選機積録観類験願鏡競議")
kanjiGrade5=set("久仏支比可旧永句圧弁布刊犯示再仮件任因団在舌似余判均志条災応序快技状防武承価舎券制効妻居往性招易枝河版肥述非保厚故政査独祖則逆退迷限師個修俵益能容恩格桜留破素耕財造率貧基婦寄常張術情採授接断液混現略眼務移経規許設責険備営報富属復提検減測税程絶統証評賀貸貿過勢幹準損禁罪義群墓夢解豊資鉱預飼像境増徳慣態構演精総綿製複適酸銭銅際雑領導敵暴潔確編賛質興衛燃築輸績講謝織職額識護")
kanjiGrade6=set("亡寸己干仁尺片冊収処幼庁穴危后灰吸存宇宅机至否我系卵忘孝困批私乱垂乳供並刻呼宗宙宝届延忠拡担拝枚沿若看城奏姿宣専巻律映染段洗派皇泉砂紅背肺革蚕値俳党展座従株将班秘純納胸朗討射針降除陛骨域密捨推探済異盛視窓翌脳著訪訳欲郷郵閉頂就善尊割創勤裁揮敬晩棒痛筋策衆装補詞貴裏傷暖源聖盟絹署腹蒸幕誠賃疑層模穀磁暮誤誌認閣障劇権潮熟蔵諸誕論遺奮憲操樹激糖縦鋼厳優縮覧簡臨難臓警")
kanjiSecondarySchool=set("乙了又与及丈刃凡勺互弔井升丹乏匁屯介冗凶刈匹厄双孔幻斗斤且丙甲凸丘斥仙凹召巨占囚奴尼巧払汁玄甘矛込弐朱吏劣充妄企仰伐伏刑旬旨匠叫吐吉如妃尽帆忙扱朽朴汚汗江壮缶肌舟芋芝巡迅亜更寿励含佐伺伸但伯伴呉克却吟吹呈壱坑坊妊妨妙肖尿尾岐攻忌床廷忍戒戻抗抄択把抜扶抑杉沖沢沈没妥狂秀肝即芳辛迎邦岳奉享盲依佳侍侮併免刺劾卓叔坪奇奔姓宜尚屈岬弦征彼怪怖肩房押拐拒拠拘拙拓抽抵拍披抱抹昆昇枢析杯枠欧肯殴況沼泥泊泌沸泡炎炊炉邪祈祉突肢肪到茎苗茂迭迫邸阻附斉甚帥衷幽為盾卑哀亭帝侯俊侵促俗盆冠削勅貞卸厘怠叙咲垣契姻孤封峡峠弧悔恒恨怒威括挟拷挑施是冒架枯柄柳皆洪浄津洞牲狭狩珍某疫柔砕窃糾耐胎胆胞臭荒荘虐訂赴軌逃郊郎香剛衰畝恋倹倒倣俸倫翁兼准凍剣剖脅匿栽索桑唆哲埋娯娠姫娘宴宰宵峰貢唐徐悦恐恭恵悟悩扇振捜挿捕敏核桟栓桃殊殉浦浸泰浜浮涙浪烈畜珠畔疾症疲眠砲祥称租秩粋紛紡紋耗恥脂朕胴致般既華蚊被託軒辱唇逝逐逓途透酌陥陣隻飢鬼剤竜粛尉彫偽偶偵偏剰勘乾喝啓唯執培堀婚婆寂崎崇崩庶庸彩患惨惜悼悠掛掘掲控据措掃排描斜旋曹殻貫涯渇渓渋淑渉淡添涼猫猛猟瓶累盗眺窒符粗粘粒紺紹紳脚脱豚舶菓菊菌虚蛍蛇袋訟販赦軟逸逮郭酔釈釣陰陳陶陪隆陵麻斎喪奥蛮偉傘傍普喚喫圏堪堅堕塚堤塔塀媒婿掌項幅帽幾廃廊弾尋御循慌惰愉惑雇扉握援換搭揚揺敢暁晶替棺棋棚棟款欺殖渦滋湿渡湾煮猶琴畳塁疎痘痢硬硝硫筒粧絞紫絡脹腕葬募裕裂詠詐詔診訴越超距軸遇遂遅遍酢鈍閑隅随焦雄雰殿棄傾傑債催僧慈勧載嗣嘆塊塑塗奨嫁嫌寛寝廉微慨愚愁慎携搾摂搬暇楼歳滑溝滞滝漠滅溶煙煩雅猿献痴睡督碁禍禅稚継腰艇蓄虞虜褐裸触該詰誇詳誉賊賄跡践跳較違遣酬酪鉛鉢鈴隔雷零靴頑頒飾飽鼓豪僕僚暦塾奪嫡寡寧腐彰徴憎慢摘概雌漆漸漬滴漂漫漏獄碑稲端箇維綱緒網罰膜慕誓誘踊遮遭酵酷銃銑銘閥隠需駆駄髪魂錬緯韻影鋭謁閲縁憶穏稼餓壊懐嚇獲穫潟轄憾歓環監緩艦還鑑輝騎儀戯擬犠窮矯響驚凝緊襟謹繰勲薫慶憩鶏鯨撃懸謙賢顕顧稿衡購墾懇鎖錯撮擦暫諮賜璽爵趣儒襲醜獣瞬潤遵償礁衝鐘壌嬢譲醸錠嘱審薪震錘髄澄瀬請籍潜繊薦遷鮮繕礎槽燥藻霜騒贈濯濁諾鍛壇鋳駐懲聴鎮墜締徹撤謄踏騰闘篤曇縄濃覇輩賠薄爆縛繁藩範盤罷避賓頻敷膚譜賦舞覆噴墳憤幣弊壁癖舗穂簿縫褒膨謀墨撲翻摩磨魔繭魅霧黙躍癒諭憂融慰窯謡翼羅頼欄濫履離慮寮療糧隣隷霊麗齢擁露")
kanjiSchool=kanjiGrade1|kanjiGrade2|kanjiGrade3|kanjiGrade4|kanjiGrade5|kanjiGrade6|kanjiSecondarySchool
kanji2008addition=set("藤誰俺岡頃奈阪韓弥那鹿斬虎狙脇熊尻旦闇籠呂亀頬膝鶴匂沙須椅股眉挨拶鎌凄謎稽曾喉拭貌塞蹴鍵膳袖潰駒剥鍋湧葛梨貼拉枕顎苛蓋裾腫爪嵐鬱妖藍捉宛崖叱瓦拳乞呪汰勃昧唾艶痕諦餅瞳唄隙淫錦箸戚蒙妬蔑嗅蜜戴痩怨醒詣窟巾蜂骸弄嫉罵璧阜埼伎曖餌爽詮芯綻肘麓憧頓牙咽嘲臆挫溺侶丼瘍僅諜柵腎梗瑠羨酎畿畏瞭踪栃蔽茨慄傲虹捻臼喩萎腺桁玩冶羞惧舷貪采堆煎斑冥遜旺麺璃串填箋脊緻辣摯汎憚哨氾諧媛彙恣聘沃憬捗訃")
kanjiNames=set("娃阿挨逢葵茜渥旭葦芦梓斡宛絢綾鮎或粟庵按闇鞍杏伊夷惟椅畏謂亥郁磯溢茨鰯允胤蔭烏迂卯鵜窺丑碓臼唄姥厩瓜閏噂云叡曳瑛榎堰奄燕艶苑薗於甥旺襖岡荻臆桶牡俺伽嘉珂禾茄蝦嘩迦霞俄峨牙臥駕廻恢魁晦芥蟹凱崖蓋鎧浬馨柿笠樫梶恰葛叶椛樺鞄兜蒲釜鎌鴨茅萱粥瓦侃柑竿莞韓巌玩雁伎嬉毅畿稀徽亀祇誼掬鞠桔橘砧杵汲灸笈鋸亨匡卿喬蕎饗尭桐僅巾錦欣欽禽芹衿玖矩駈駒喰寓串櫛釧屑窟沓窪熊隈栗鍬袈祁圭慧桂稽詣戟隙桁訣倦喧拳捲牽硯鍵絃舷諺乎糊袴胡虎跨伍吾梧檎瑚醐鯉倖勾宏巷庚弘昂晃杭梗浩紘腔膏閤鴻劫壕轟忽惚此頃昏些叉嵯沙瑳裟坐哉塞采犀砦冴阪堺榊肴埼鷺朔柵窄笹拶薩皐錆晒撒燦珊纂讃仔孜斯獅爾而蒔汐鹿竺雫悉篠偲柴縞紗灼錫惹洲蒐蹴輯峻竣舜駿楯淳醇曙渚恕哨嘗庄捷昌梢樟湘菖蕉裳鞘丞杖穣埴拭燭晋榛秦芯壬腎訊諏須厨逗翠錐瑞嵩雛菅頗雀裾摺凄棲栖醒戚蹟碩尖撰煎穿羨詮閃膳噌曾曽楚疏蘇遡叢爽宋惣槍漕綜聡蒼捉袖其揃遜汰舵楕陀堆戴苔黛鯛醍鷹瀧啄托琢茸凧只辰巽竪辿樽誰坦旦歎湛耽檀弛智馳筑註酎猪喋寵帖暢牒蝶椎槌槻佃柘辻蔦綴椿紬爪鶴悌挺梯汀禎諦蹄鄭釘鼎擢填纏貼顛兎堵杜砥套宕嶋燈董藤憧撞瞳萄栃鳶寅酉惇敦沌遁頓奈那凪薙謎灘捺鍋楢馴楠汝匂賑虹廿濡禰祢捻乃之埜巴播杷琶芭盃煤這秤萩柏箔曝莫函箸肇筈幡畠鳩塙隼斑汎挽磐蕃庇斐緋樋枇毘琵眉柊疋彦菱肘畢桧媛紐彪瓢豹廟彬瀕冨斧芙阜撫葡蕪楓葺蕗淵吻焚蔽頁碧瞥篇娩鞭圃甫輔戊菩峯捧朋萌蓬蜂鋒鳳鵬貌卜睦勃殆幌昧哩槙枕柾鱒亦俣沫迄麿蔓巳箕蜜湊蓑稔牟椋冥姪孟蒙儲勿餅尤籾貰也冶耶弥靖佑宥柚湧祐邑輿傭妖楊耀蓉遥淀螺洛嵐藍蘭李梨璃裡掠劉溜琉龍侶亮凌梁瞭稜諒遼淋琳鱗麟瑠伶嶺怜玲憐漣煉簾蓮呂魯櫓狼麓禄肋倭脇鷲亙亘詫藁蕨椀碗乘亞佛侑來俐傳僞價儉兒凉凛凰刹剩劍勁勳卷單嚴圈國圓團壞壘壯壽奎奧奬孃實寢將專峽崚巖已帶廣廳彈彌彗從徠恆惡惠惺愼應懷戰戲拔拜拂搜搖攝收敍昊昴晏晄晝晨晟暉曉曖檜栞條梛椰榮樂樣橙檢櫂櫻盜毬氣洸洵淨滉漱滯澁澪濕煌燒燎燿爭爲狹默獸珈珀琥瑶疊皓盡眞眸碎祕祿禪禮稟稻穗穰笙粹絆綺綸縣縱纖羚翔飜聽脩臟與苺茉莊莉菫萠萬蕾藏藝藥衞裝覽詢諄謠讓賣赳轉迪逞醉釀釉鎭鑄陷險雜靜頌顯颯騷驍驗髮鷄麒黎齊堯槇遙凜熙")
kanjiOthers=set("挨垢憧宛或椅伊炒嘘嬉噂餌於岡俺嘩鍵崖賭籠霞嘗鞄釜噛瓦稀稽蹴喧梢忽此頃沙匙拶爽叱腫繍醤尻芯腎隙凄裾咳咀蘇袖其剃揃汰叩只溜誰旦蛋馳蝶呟壷爪吊頓丼那奈謎撫鍋匂賑睨濡覗喉呪狙這箸筈貼髭膝肘瞳紐藤蓋吠頬殆惚蒔撒枕股眉勿尤貰闇茹嵐呂脇湧僅碗阿葵茜旭梓虻粟庵鞍杏磯鰯允蔭烏迂鵜窺丑臼唄姥瓜閏云堰怨燕艶苑荻伽苛俄牙柿笠恰葛叶樺兜鎌鴨茅粥姦竿韓玩癌雁毅畿亀祇橘僑匡卿桐錦倶狗駒寓串櫛窪熊隈栗桂詣拳捲姑狐虎跨鯉杭紘腔壕濠麹痕些叉塞采砦冴榊笹纂讃斬獅鹿悉柴錫惹讐竣曙渚哨娼昌杖埴拭須瑞雛雀摺棲醒戚羨腺閃膳惣掻槍綜舵楕堆戴黛鯛鷹凧辰巽鱈樽綻酎猪喋暢諜銚掴佃辻蔦綴椿潰鶴挺轍纏澱兎堵妬寅酉沌灘捺楠虹葱撚巴罵牌萩柏曝鳩隼斑汎庇斐媛淵僻")

# other list here
# https://kanjicards.org/kanji-lists.html

# Katakana
# https://en.wikipedia.org/wiki/Katakana
kana_katakana=set("アイウエオカキクケコガギグゲゴサシスセソザジズゼゾタチツテトダヂヅデドナニヌネノハヒフヘホバビブベボパピプペポマミムメモヤユヨラリルレロワヲッヽ゛゜")

# Hiragana
# https://en.wikipedia.org/wiki/Hiragana
kana_hiragana=set("あいうえおかきくけこがぎぐげごさしすせそざじずぜぞたちつてとだぢづでどなにぬねのはひふへほばびぶべぼぱぴぷぺぽまみむめもやゆよらりるれろわゐゑをんっゝ゛゜")

kanaAll=kana_hiragana|kana_katakana

# TODO: add Cantonese
#   usefull links:
#       - https://www.ogcio.gov.hk/en/our_work/business/tech_promotion/ccli/archive/archive_mapping_table_2008.htm
#       - http://humanum.arts.cuhk.edu.hk/Lexis/lexi-can/
#       - https://glyphwiki.org/wiki/Group:Big5-GCCS%e5%a4%96%e5%ad%97
#       - https://en.wikipedia.org/wiki/Hong_Kong_Supplementary_Character_Set