{******************************************************************************}
{                                                                              }
{ Windows User API interface Unit for Object Pascal                            }
{                                                                              }
{ Portions created by Microsoft are Copyright (C) 1995-2001 Microsoft          }
{ Corporation. All Rights Reserved.                                            }
{                                                                              }
{ The original file is: winuser.h, released June 2000. The original Pascal     }
{ code is: WinUser.pas, released December 2000. The initial developer of the   }
{ Pascal code is Marcel van Brakel (brakelm att chello dott nl).               }
{                                                                              }
{ Portions created by Marcel van Brakel are Copyright (C) 1999-2001            }
{ Marcel van Brakel. All Rights Reserved.                                      }
{                                                                              }
{ Obtained through: Joint Endeavour of Delphi Innovators (Project JEDI)        }
{                                                                              }
{ You may retrieve the latest version of this file at the Project JEDI         }
{ APILIB home page, located at http://jedi-apilib.sourceforge.net              }
{                                                                              }
{ The contents of this file are used with permission, subject to the Mozilla   }
{ Public License Version 1.1 (the "License"); you may not use this file except }
{ in compliance with the License. You may obtain a copy of the License at      }
{ http://www.mozilla.org/MPL/MPL-1.1.html                                      }
{                                                                              }
{ Software distributed under the License is distributed on an "AS IS" basis,   }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for }
{ the specific language governing rights and limitations under the License.    }
{                                                                              }
{ Alternatively, the contents of this file may be used under the terms of the  }
{ GNU Lesser General Public License (the  "LGPL License"), in which case the   }
{ provisions of the LGPL License are applicable instead of those above.        }
{ If you wish to allow use of your version of this file only under the terms   }
{ of the LGPL License and not to allow others to use your version of this file }
{ under the MPL, indicate your decision by deleting  the provisions above and  }
{ replace  them with the notice and other provisions required by the LGPL      }
{ License.  If you do not delete the provisions above, a recipient may use     }
{ your version of this file under either the MPL or the LGPL License.          }
{                                                                              }
{ For more information about the LGPL: http://www.gnu.org/copyleft/lesser.html }
{                                                                              }
{******************************************************************************}

// $Id: JwaWinUser.pas,v 1.16 2005/09/06 16:36:51 marquardt Exp $

{$IFNDEF JWA_INCLUDEMODE}

unit JwaWinUser;

{$WEAKPACKAGEUNIT}

{$I jediapilib.inc}

interface

uses
  JwaWinBase, JwaWinGDI, JwaWinNT, JwaWinType;

{$ENDIF !JWA_INCLUDEMODE}

{$IFDEF JWA_INTERFACESECTION}

{$HPPEMIT ''}
{$HPPEMIT '#include "WinUser.h"'}
{$HPPEMIT ''}

const
  UINT_MAX = UINT($FFFFFFFF); // from limits.h TODO
  {$EXTERNALSYM UINT_MAX}

type
  HDWP = HANDLE;
  {$EXTERNALSYM HDWP}

  MENUTEMPLATEA = Pointer;
  {$EXTERNALSYM MENUTEMPLATEA}
  MENUTEMPLATEW = Pointer;
  {$EXTERNALSYM MENUTEMPLATEW}

  {$IFDEF UNICODE}
  MENUTEMPLATE = MENUTEMPLATEW;
  {$EXTERNALSYM MENUTEMPLATE}
  {$ELSE}
  MENUTEMPLATE = MENUTEMPLATEA;
  {$EXTERNALSYM MENUTEMPLATE}
  {$ENDIF UNICODE}

  LPMENUTEMPLATEA = PVOID;
  {$EXTERNALSYM LPMENUTEMPLATEA}
  LPMENUTEMPLATEW = PVOID;
  {$EXTERNALSYM LPMENUTEMPLATEW}
  {$IFDEF UNICODE}
  LPMENUTEMPLATE = LPMENUTEMPLATEW;
  {$EXTERNALSYM LPMENUTEMPLATE}
  {$ELSE}
  LPMENUTEMPLATE = LPMENUTEMPLATEA;
  {$EXTERNALSYM LPMENUTEMPLATE}
  {$ENDIF UNICODE}

  WNDPROC = function(hWnd: HWND; uMsg: UINT; lParam: WPARAM; wParam: LPARAM): LRESULT; stdcall;
  {$EXTERNALSYM WNDPROC}

  DLGPROC = function(hwndDlg: HWND; wMsg: UINT; wParam: WPARAM; lParam: LPARAM): INT_PTR; stdcall;
  {$EXTERNALSYM DLGPROC}
  TIMERPROC = procedure(hwnd: HWND; uMsg: UINT; idEvent: UINT_PTR; dwTime: DWORD); stdcall;
  {$EXTERNALSYM TIMERPROC}
  GRAYSTRINGPROC = function(hdc: HDC; lpData: LPARAM; cchData: Integer): BOOL; stdcall;
  {$EXTERNALSYM GRAYSTRINGPROC}
  WNDENUMPROC = function(hwnd: HWND; lParam: LPARAM): BOOL; stdcall;
  {$EXTERNALSYM WNDENUMPROC}
  HOOKPROC = function(nCode: Integer; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
  {$EXTERNALSYM HOOKPROC}
  SENDASYNCPROC = procedure(hwnd: HWND; uMsg: UINT; dwData: ULONG_PTR; lResult: LRESULT); stdcall;
  {$EXTERNALSYM SENDASYNCPROC}

  PROPENUMPROCA = function(hwnd: HWND; lpszString: LPCSTR; hData: HANDLE): BOOL; stdcall;
  {$EXTERNALSYM PROPENUMPROCA}
  PROPENUMPROCW = function(hwnd: HWND; lpszString: LPCWSTR; hData: HANDLE): BOOL; stdcall;
  {$EXTERNALSYM PROPENUMPROCW}

  PROPENUMPROCEXA = function(hwnd: HWND; lpszString: LPSTR; hData: HANDLE; dwData: ULONG_PTR): BOOL; stdcall;
  {$EXTERNALSYM PROPENUMPROCEXA}
  PROPENUMPROCEXW = function(hwnd: HWND; lpszString: LPWSTR; hData: HANDLE; dwData: ULONG_PTR): BOOL; stdcall;
  {$EXTERNALSYM PROPENUMPROCEXW}

  EDITWORDBREAKPROCA = function(lpch: LPSTR; ichCurrent: Integer; cch, code: Integer): Integer; stdcall;
  {$EXTERNALSYM EDITWORDBREAKPROCA}
  EDITWORDBREAKPROCW = function(lpch: LPWSTR; ichCurrent: Integer; cch, code: Integer): Integer; stdcall;
  {$EXTERNALSYM EDITWORDBREAKPROCW}

  DRAWSTATEPROC = function(hdc: HDC; lData: LPARAM; wData: WPARAM; cx, cy: Integer): BOOL; stdcall;
  {$EXTERNALSYM DRAWSTATEPROC}

  {$IFDEF UNICODE}
  PROPENUMPROC = PROPENUMPROCW;
  {$EXTERNALSYM PROPENUMPROC}
  PROPENUMPROCEX = PROPENUMPROCEXW;
  {$EXTERNALSYM PROPENUMPROCEX}
  EDITWORDBREAKPROC = EDITWORDBREAKPROCW;
  {$EXTERNALSYM EDITWORDBREAKPROC}
  {$ELSE}
  PROPENUMPROC = PROPENUMPROCA;
  {$EXTERNALSYM PROPENUMPROC}
  PROPENUMPROCEX = PROPENUMPROCEXA;
  {$EXTERNALSYM PROPENUMPROCEX}
  EDITWORDBREAKPROC = EDITWORDBREAKPROCA;
  {$EXTERNALSYM EDITWORDBREAKPROC}
  {$ENDIF UNICODE}

  NAMEENUMPROCA = function(lpstr: LPSTR; lParam: LPARAM): BOOL; stdcall;
  {$EXTERNALSYM NAMEENUMPROCA}
  NAMEENUMPROCW = function(lpstr: LPWSTR; lParam: LPARAM): BOOL; stdcall;
  {$EXTERNALSYM NAMEENUMPROCW}

  WINSTAENUMPROCA = NAMEENUMPROCA;
  {$EXTERNALSYM WINSTAENUMPROCA}
  DESKTOPENUMPROCA = NAMEENUMPROCA;
  {$EXTERNALSYM DESKTOPENUMPROCA}
  WINSTAENUMPROCW = NAMEENUMPROCW;
  {$EXTERNALSYM WINSTAENUMPROCW}
  DESKTOPENUMPROCW = NAMEENUMPROCW;
  {$EXTERNALSYM DESKTOPENUMPROCW}

  {$IFDEF UNICODE}
  WINSTAENUMPROC = WINSTAENUMPROCW;
  {$EXTERNALSYM WINSTAENUMPROC}
  DESKTOPENUMPROC = DESKTOPENUMPROCW;
  {$EXTERNALSYM DESKTOPENUMPROC}
  {$ELSE}
  WINSTAENUMPROC = WINSTAENUMPROCA;
  {$EXTERNALSYM WINSTAENUMPROC}
  DESKTOPENUMPROC = DESKTOPENUMPROCA;
  {$EXTERNALSYM DESKTOPENUMPROC}
  {$ENDIF UNICODE}

function IS_INTRESOURCE(wInteger: WORD): BOOL;
{$EXTERNALSYM IS_INTRESOURCE}

type
  MAKEINTRESOURCEA = LPSTR;
  {$EXTERNALSYM MAKEINTRESOURCEA}
  MAKEINTRESOURCEW = LPWSTR;
  {$EXTERNALSYM MAKEINTRESOURCEW}
  {$IFDEF UNICODE}
  MAKEINTRESOURCE = MAKEINTRESOURCEW;
  {$EXTERNALSYM MAKEINTRESOURCE}
  {$ELSE}
  MAKEINTRESOURCE = MAKEINTRESOURCEA;
  {$EXTERNALSYM MAKEINTRESOURCE}
  {$ENDIF UNICODE}

//
// Predefined Resource Types
//

const
  RT_CURSOR       = MAKEINTRESOURCE(1);
  {$EXTERNALSYM RT_CURSOR}
  RT_BITMAP       = MAKEINTRESOURCE(2);
  {$EXTERNALSYM RT_BITMAP}
  RT_ICON         = MAKEINTRESOURCE(3);
  {$EXTERNALSYM RT_ICON}
  RT_MENU         = MAKEINTRESOURCE(4);
  {$EXTERNALSYM RT_MENU}
  RT_DIALOG       = MAKEINTRESOURCE(5);
  {$EXTERNALSYM RT_DIALOG}
  RT_STRING       = MAKEINTRESOURCE(6);
  {$EXTERNALSYM RT_STRING}
  RT_FONTDIR      = MAKEINTRESOURCE(7);
  {$EXTERNALSYM RT_FONTDIR}
  RT_FONT         = MAKEINTRESOURCE(8);
  {$EXTERNALSYM RT_FONT}
  RT_ACCELERATOR  = MAKEINTRESOURCE(9);
  {$EXTERNALSYM RT_ACCELERATOR}
  RT_RCDATA       = MAKEINTRESOURCE(10);
  {$EXTERNALSYM RT_RCDATA}
  RT_MESSAGETABLE = MAKEINTRESOURCE(11);
  {$EXTERNALSYM RT_MESSAGETABLE}

  DIFFERENCE = 11;
  {$EXTERNALSYM DIFFERENCE}

  RT_GROUP_CURSOR = MAKEINTRESOURCE(ULONG_PTR(RT_CURSOR) + DIFFERENCE);
  {$EXTERNALSYM RT_GROUP_CURSOR}
  RT_GROUP_ICON = MAKEINTRESOURCE(ULONG_PTR(RT_ICON) + DIFFERENCE);
  {$EXTERNALSYM RT_GROUP_ICON}
  RT_VERSION    = MAKEINTRESOURCE(16);
  {$EXTERNALSYM RT_VERSION}
  RT_DLGINCLUDE = MAKEINTRESOURCE(17);
  {$EXTERNALSYM RT_DLGINCLUDE}
  RT_PLUGPLAY   = MAKEINTRESOURCE(19);
  {$EXTERNALSYM RT_PLUGPLAY}
  RT_VXD        = MAKEINTRESOURCE(20);
  {$EXTERNALSYM RT_VXD}
  RT_ANICURSOR  = MAKEINTRESOURCE(21);
  {$EXTERNALSYM RT_ANICURSOR}
  RT_ANIICON    = MAKEINTRESOURCE(22);
  {$EXTERNALSYM RT_ANIICON}
  RT_HTML       = MAKEINTRESOURCE(23);
  {$EXTERNALSYM RT_HTML}
  RT_MANIFEST   = MAKEINTRESOURCE(24);
  CREATEPROCESS_MANIFEST_RESOURCE_ID = MAKEINTRESOURCE(1);
  {$EXTERNALSYM CREATEPROCESS_MANIFEST_RESOURCE_ID}
  ISOLATIONAWARE_MANIFEST_RESOURCE_ID = MAKEINTRESOURCE(2);
  {$EXTERNALSYM ISOLATIONAWARE_MANIFEST_RESOURCE_ID}
  ISOLATIONAWARE_NOSTATICIMPORT_MANIFEST_RESOURCE_ID = MAKEINTRESOURCE(3);
  {$EXTERNALSYM ISOLATIONAWARE_NOSTATICIMPORT_MANIFEST_RESOURCE_ID}
  MINIMUM_RESERVED_MANIFEST_RESOURCE_ID = MAKEINTRESOURCE(1{inclusive});
  {$EXTERNALSYM MINIMUM_RESERVED_MANIFEST_RESOURCE_ID}
  MAXIMUM_RESERVED_MANIFEST_RESOURCE_ID = MAKEINTRESOURCE(16{inclusive});
  {$EXTERNALSYM MAXIMUM_RESERVED_MANIFEST_RESOURCE_ID}

type
  va_list = PChar;
  {$EXTERNALSYM va_list}

function wvsprintfA(Output: LPSTR; Format: LPCSTR; arglist: va_list): Integer; stdcall;
{$EXTERNALSYM wvsprintfA}
function wvsprintfW(Output: LPWSTR; Format: LPCWSTR; arglist: va_list): Integer; stdcall;
{$EXTERNALSYM wvsprintfW}
function wvsprintf(Output: LPTSTR; Format: LPCTSTR; arglist: va_list): Integer; stdcall;
{$EXTERNALSYM wvsprintf}

function wsprintfA(Output: LPSTR; Format: LPCSTR): Integer; stdcall;
{$EXTERNALSYM wsprintfA}
function wsprintfW(Output: LPWSTR; Format: LPCWSTR): Integer; stdcall;
{$EXTERNALSYM wsprintfW}
function wsprintf(Output: LPTSTR; Format: LPCTSTR): Integer; stdcall;
{$EXTERNALSYM wsprintf}

//
// SPI_SETDESKWALLPAPER defined constants
//

const
  SETWALLPAPER_DEFAULT = LPWSTR(-1);
  {$EXTERNALSYM SETWALLPAPER_DEFAULT}

//
// Scroll Bar Constants
//

  SB_HORZ = 0;
  {$EXTERNALSYM SB_HORZ}
  SB_VERT = 1;
  {$EXTERNALSYM SB_VERT}
  SB_CTL  = 2;
  {$EXTERNALSYM SB_CTL}
  SB_BOTH = 3;
  {$EXTERNALSYM SB_BOTH}

//
// Scroll Bar Commands
//

  SB_LINEUP        = 0;
  {$EXTERNALSYM SB_LINEUP}
  SB_LINELEFT      = 0;
  {$EXTERNALSYM SB_LINELEFT}
  SB_LINEDOWN      = 1;
  {$EXTERNALSYM SB_LINEDOWN}
  SB_LINERIGHT     = 1;
  {$EXTERNALSYM SB_LINERIGHT}
  SB_PAGEUP        = 2;
  {$EXTERNALSYM SB_PAGEUP}
  SB_PAGELEFT      = 2;
  {$EXTERNALSYM SB_PAGELEFT}
  SB_PAGEDOWN      = 3;
  {$EXTERNALSYM SB_PAGEDOWN}
  SB_PAGERIGHT     = 3;
  {$EXTERNALSYM SB_PAGERIGHT}
  SB_THUMBPOSITION = 4;
  {$EXTERNALSYM SB_THUMBPOSITION}
  SB_THUMBTRACK    = 5;
  {$EXTERNALSYM SB_THUMBTRACK}
  SB_TOP           = 6;
  {$EXTERNALSYM SB_TOP}
  SB_LEFT          = 6;
  {$EXTERNALSYM SB_LEFT}
  SB_BOTTOM        = 7;
  {$EXTERNALSYM SB_BOTTOM}
  SB_RIGHT         = 7;
  {$EXTERNALSYM SB_RIGHT}
  SB_ENDSCROLL     = 8;
  {$EXTERNALSYM SB_ENDSCROLL}

//
// ShowWindow() Commands
//

  SW_HIDE            = 0;
  {$EXTERNALSYM SW_HIDE}
  SW_SHOWNORMAL      = 1;
  {$EXTERNALSYM SW_SHOWNORMAL}
  SW_NORMAL          = 1;
  {$EXTERNALSYM SW_NORMAL}
  SW_SHOWMINIMIZED   = 2;
  {$EXTERNALSYM SW_SHOWMINIMIZED}
  SW_SHOWMAXIMIZED   = 3;
  {$EXTERNALSYM SW_SHOWMAXIMIZED}
  SW_MAXIMIZE        = 3;
  {$EXTERNALSYM SW_MAXIMIZE}
  SW_SHOWNOACTIVATE  = 4;
  {$EXTERNALSYM SW_SHOWNOACTIVATE}
  SW_SHOW            = 5;
  {$EXTERNALSYM SW_SHOW}
  SW_MINIMIZE        = 6;
  {$EXTERNALSYM SW_MINIMIZE}
  SW_SHOWMINNOACTIVE = 7;
  {$EXTERNALSYM SW_SHOWMINNOACTIVE}
  SW_SHOWNA          = 8;
  {$EXTERNALSYM SW_SHOWNA}
  SW_RESTORE         = 9;
  {$EXTERNALSYM SW_RESTORE}
  SW_SHOWDEFAULT     = 10;
  {$EXTERNALSYM SW_SHOWDEFAULT}
  SW_FORCEMINIMIZE   = 11;
  {$EXTERNALSYM SW_FORCEMINIMIZE}
  SW_MAX             = 11;
  {$EXTERNALSYM SW_MAX}

//
// Old ShowWindow() Commands
//

  HIDE_WINDOW         = 0;
  {$EXTERNALSYM HIDE_WINDOW}
  SHOW_OPENWINDOW     = 1;
  {$EXTERNALSYM SHOW_OPENWINDOW}
  SHOW_ICONWINDOW     = 2;
  {$EXTERNALSYM SHOW_ICONWINDOW}
  SHOW_FULLSCREEN     = 3;
  {$EXTERNALSYM SHOW_FULLSCREEN}
  SHOW_OPENNOACTIVATE = 4;
  {$EXTERNALSYM SHOW_OPENNOACTIVATE}

//
// Identifiers for the WM_SHOWWINDOW message
//

  SW_PARENTCLOSING = 1;
  {$EXTERNALSYM SW_PARENTCLOSING}
  SW_OTHERZOOM     = 2;
  {$EXTERNALSYM SW_OTHERZOOM}
  SW_PARENTOPENING = 3;
  {$EXTERNALSYM SW_PARENTOPENING}
  SW_OTHERUNZOOM   = 4;
  {$EXTERNALSYM SW_OTHERUNZOOM}

//
// AnimateWindow() Commands
//

  AW_HOR_POSITIVE = $00000001;
  {$EXTERNALSYM AW_HOR_POSITIVE}
  AW_HOR_NEGATIVE = $00000002;
  {$EXTERNALSYM AW_HOR_NEGATIVE}
  AW_VER_POSITIVE = $00000004;
  {$EXTERNALSYM AW_VER_POSITIVE}
  AW_VER_NEGATIVE = $00000008;
  {$EXTERNALSYM AW_VER_NEGATIVE}
  AW_CENTER       = $00000010;
  {$EXTERNALSYM AW_CENTER}
  AW_HIDE         = $00010000;
  {$EXTERNALSYM AW_HIDE}
  AW_ACTIVATE     = $00020000;
  {$EXTERNALSYM AW_ACTIVATE}
  AW_SLIDE        = $00040000;
  {$EXTERNALSYM AW_SLIDE}
  AW_BLEND        = $00080000;
  {$EXTERNALSYM AW_BLEND}

//
// WM_KEYUP/DOWN/CHAR HIWORD(lParam) flags
//

  KF_EXTENDED = $0100;
  {$EXTERNALSYM KF_EXTENDED}
  KF_DLGMODE  = $0800;
  {$EXTERNALSYM KF_DLGMODE}
  KF_MENUMODE = $1000;
  {$EXTERNALSYM KF_MENUMODE}
  KF_ALTDOWN  = $2000;
  {$EXTERNALSYM KF_ALTDOWN}
  KF_REPEAT   = $4000;
  {$EXTERNALSYM KF_REPEAT}
  KF_UP       = $8000;
  {$EXTERNALSYM KF_UP}

//
// Virtual Keys, Standard Set
//

  VK_LBUTTON = $01;
  {$EXTERNALSYM VK_LBUTTON}
  VK_RBUTTON = $02;
  {$EXTERNALSYM VK_RBUTTON}
  VK_CANCEL  = $03;
  {$EXTERNALSYM VK_CANCEL}
  VK_MBUTTON = $04; // NOT contiguous with L & RBUTTON
  {$EXTERNALSYM VK_MBUTTON}

  {$IFDEF WIN98ME_UP}
  VK_XBUTTON1 = $05; // NOT contiguous with L & RBUTTON
  {$EXTERNALSYM VK_XBUTTON1}
  VK_XBUTTON2 = $06; // NOT contiguous with L & RBUTTON
  {$EXTERNALSYM VK_XBUTTON2}
  {$ENDIF WIN98ME_UP}

//
// 0x07 : unassigned
//

  VK_BACK = $08;
  {$EXTERNALSYM VK_BACK}
  VK_TAB  = $09;
  {$EXTERNALSYM VK_TAB}

//
// 0x0A - 0x0B : reserved
//

  VK_CLEAR  = $0C;
  {$EXTERNALSYM VK_CLEAR}
  VK_RETURN = $0D;
  {$EXTERNALSYM VK_RETURN}

  VK_SHIFT   = $10;
  {$EXTERNALSYM VK_SHIFT}
  VK_CONTROL = $11;
  {$EXTERNALSYM VK_CONTROL}
  VK_MENU    = $12;
  {$EXTERNALSYM VK_MENU}
  VK_PAUSE   = $13;
  {$EXTERNALSYM VK_PAUSE}
  VK_CAPITAL = $14;
  {$EXTERNALSYM VK_CAPITAL}

  VK_KANA    = $15;
  {$EXTERNALSYM VK_KANA}
  VK_HANGEUL = $15; // old name - should be here for compatibility
  {$EXTERNALSYM VK_HANGEUL}
  VK_HANGUL  = $15;
  {$EXTERNALSYM VK_HANGUL}
  VK_JUNJA   = $17;
  {$EXTERNALSYM VK_JUNJA}
  VK_FINAL   = $18;
  {$EXTERNALSYM VK_FINAL}
  VK_HANJA   = $19;
  {$EXTERNALSYM VK_HANJA}
  VK_KANJI   = $19;
  {$EXTERNALSYM VK_KANJI}

  VK_ESCAPE = $1B;
  {$EXTERNALSYM VK_ESCAPE}

  VK_CONVERT    = $1C;
  {$EXTERNALSYM VK_CONVERT}
  VK_NONCONVERT = $1D;
  {$EXTERNALSYM VK_NONCONVERT}
  VK_ACCEPT     = $1E;
  {$EXTERNALSYM VK_ACCEPT}
  VK_MODECHANGE = $1F;
  {$EXTERNALSYM VK_MODECHANGE}

  VK_SPACE    = $20;
  {$EXTERNALSYM VK_SPACE}
  VK_PRIOR    = $21;
  {$EXTERNALSYM VK_PRIOR}
  VK_NEXT     = $22;
  {$EXTERNALSYM VK_NEXT}
  VK_END      = $23;
  {$EXTERNALSYM VK_END}
  VK_HOME     = $24;
  {$EXTERNALSYM VK_HOME}
  VK_LEFT     = $25;
  {$EXTERNALSYM VK_LEFT}
  VK_UP       = $26;
  {$EXTERNALSYM VK_UP}
  VK_RIGHT    = $27;
  {$EXTERNALSYM VK_RIGHT}
  VK_DOWN     = $28;
  {$EXTERNALSYM VK_DOWN}
  VK_SELECT   = $29;
  {$EXTERNALSYM VK_SELECT}
  VK_PRINT    = $2A;
  {$EXTERNALSYM VK_PRINT}
  VK_EXECUTE  = $2B;
  {$EXTERNALSYM VK_EXECUTE}
  VK_SNAPSHOT = $2C;
  {$EXTERNALSYM VK_SNAPSHOT}
  VK_INSERT   = $2D;
  {$EXTERNALSYM VK_INSERT}
  VK_DELETE   = $2E;
  {$EXTERNALSYM VK_DELETE}
  VK_HELP     = $2F;
  {$EXTERNALSYM VK_HELP}

//
// VK_0 - VK_9 are the same as ASCII '0' - '9' (0x30 - 0x39)
// 0x40 : unassigned
// VK_A - VK_Z are the same as ASCII 'A' - 'Z' (0x41 - 0x5A)
//

  VK_LWIN = $5B;
  {$EXTERNALSYM VK_LWIN}
  VK_RWIN = $5C;
  {$EXTERNALSYM VK_RWIN}
  VK_APPS = $5D;
  {$EXTERNALSYM VK_APPS}

//
// 0x5E : reserved
//

  VK_SLEEP = $5F;
  {$EXTERNALSYM VK_SLEEP}

  VK_NUMPAD0   = $60;
  {$EXTERNALSYM VK_NUMPAD0}
  VK_NUMPAD1   = $61;
  {$EXTERNALSYM VK_NUMPAD1}
  VK_NUMPAD2   = $62;
  {$EXTERNALSYM VK_NUMPAD2}
  VK_NUMPAD3   = $63;
  {$EXTERNALSYM VK_NUMPAD3}
  VK_NUMPAD4   = $64;
  {$EXTERNALSYM VK_NUMPAD4}
  VK_NUMPAD5   = $65;
  {$EXTERNALSYM VK_NUMPAD5}
  VK_NUMPAD6   = $66;
  {$EXTERNALSYM VK_NUMPAD6}
  VK_NUMPAD7   = $67;
  {$EXTERNALSYM VK_NUMPAD7}
  VK_NUMPAD8   = $68;
  {$EXTERNALSYM VK_NUMPAD8}
  VK_NUMPAD9   = $69;
  {$EXTERNALSYM VK_NUMPAD9}
  VK_MULTIPLY  = $6A;
  {$EXTERNALSYM VK_MULTIPLY}
  VK_ADD       = $6B;
  {$EXTERNALSYM VK_ADD}
  VK_SEPARATOR = $6C;
  {$EXTERNALSYM VK_SEPARATOR}
  VK_SUBTRACT  = $6D;
  {$EXTERNALSYM VK_SUBTRACT}
  VK_DECIMAL   = $6E;
  {$EXTERNALSYM VK_DECIMAL}
  VK_DIVIDE    = $6F;
  {$EXTERNALSYM VK_DIVIDE}
  VK_F1        = $70;
  {$EXTERNALSYM VK_F1}
  VK_F2        = $71;
  {$EXTERNALSYM VK_F2}
  VK_F3        = $72;
  {$EXTERNALSYM VK_F3}
  VK_F4        = $73;
  {$EXTERNALSYM VK_F4}
  VK_F5        = $74;
  {$EXTERNALSYM VK_F5}
  VK_F6        = $75;
  {$EXTERNALSYM VK_F6}
  VK_F7        = $76;
  {$EXTERNALSYM VK_F7}
  VK_F8        = $77;
  {$EXTERNALSYM VK_F8}
  VK_F9        = $78;
  {$EXTERNALSYM VK_F9}
  VK_F10       = $79;
  {$EXTERNALSYM VK_F10}
  VK_F11       = $7A;
  {$EXTERNALSYM VK_F11}
  VK_F12       = $7B;
  {$EXTERNALSYM VK_F12}
  VK_F13       = $7C;
  {$EXTERNALSYM VK_F13}
  VK_F14       = $7D;
  {$EXTERNALSYM VK_F14}
  VK_F15       = $7E;
  {$EXTERNALSYM VK_F15}
  VK_F16       = $7F;
  {$EXTERNALSYM VK_F16}
  VK_F17       = $80;
  {$EXTERNALSYM VK_F17}
  VK_F18       = $81;
  {$EXTERNALSYM VK_F18}
  VK_F19       = $82;
  {$EXTERNALSYM VK_F19}
  VK_F20       = $83;
  {$EXTERNALSYM VK_F20}
  VK_F21       = $84;
  {$EXTERNALSYM VK_F21}
  VK_F22       = $85;
  {$EXTERNALSYM VK_F22}
  VK_F23       = $86;
  {$EXTERNALSYM VK_F23}
  VK_F24       = $87;
  {$EXTERNALSYM VK_F24}

//
// 0x88 - 0x8F : unassigned
//

  VK_NUMLOCK = $90;
  {$EXTERNALSYM VK_NUMLOCK}
  VK_SCROLL  = $91;
  {$EXTERNALSYM VK_SCROLL}

//
// NEC PC-9800 kbd definitions
//

  VK_OEM_NEC_EQUAL = $92; // '=' key on numpad
  {$EXTERNALSYM VK_OEM_NEC_EQUAL}

//
// Fujitsu/OASYS kbd definitions
//

  VK_OEM_FJ_JISHO   = $92; // 'Dictionary' key
  {$EXTERNALSYM VK_OEM_FJ_JISHO}
  VK_OEM_FJ_MASSHOU = $93; // 'Unregister word' key
  {$EXTERNALSYM VK_OEM_FJ_MASSHOU}
  VK_OEM_FJ_TOUROKU = $94; // 'Register word' key
  {$EXTERNALSYM VK_OEM_FJ_TOUROKU}
  VK_OEM_FJ_LOYA    = $95; // 'Left OYAYUBI' key
  {$EXTERNALSYM VK_OEM_FJ_LOYA}
  VK_OEM_FJ_ROYA    = $96; // 'Right OYAYUBI' key
  {$EXTERNALSYM VK_OEM_FJ_ROYA}

//
// 0x97 - 0x9F : unassigned
//

//
// VK_L* & VK_R* - left and right Alt, Ctrl and Shift virtual keys.
// Used only as parameters to GetAsyncKeyState() and GetKeyState().
// No other API or message will distinguish left and right keys in this way.
//

  VK_LSHIFT   = $A0;
  {$EXTERNALSYM VK_LSHIFT}
  VK_RSHIFT   = $A1;
  {$EXTERNALSYM VK_RSHIFT}
  VK_LCONTROL = $A2;
  {$EXTERNALSYM VK_LCONTROL}
  VK_RCONTROL = $A3;
  {$EXTERNALSYM VK_RCONTROL}
  VK_LMENU    = $A4;
  {$EXTERNALSYM VK_LMENU}
  VK_RMENU    = $A5;
  {$EXTERNALSYM VK_RMENU}

  {$IFDEF WIN98ME_UP}

  VK_BROWSER_BACK      = $A6;
  {$EXTERNALSYM VK_BROWSER_BACK}
  VK_BROWSER_FORWARD   = $A7;
  {$EXTERNALSYM VK_BROWSER_FORWARD}
  VK_BROWSER_REFRESH   = $A8;
  {$EXTERNALSYM VK_BROWSER_REFRESH}
  VK_BROWSER_STOP      = $A9;
  {$EXTERNALSYM VK_BROWSER_STOP}
  VK_BROWSER_SEARCH    = $AA;
  {$EXTERNALSYM VK_BROWSER_SEARCH}
  VK_BROWSER_FAVORITES = $AB;
  {$EXTERNALSYM VK_BROWSER_FAVORITES}
  VK_BROWSER_HOME      = $AC;
  {$EXTERNALSYM VK_BROWSER_HOME}

  VK_VOLUME_MUTE         = $AD;
  {$EXTERNALSYM VK_VOLUME_MUTE}
  VK_VOLUME_DOWN         = $AE;
  {$EXTERNALSYM VK_VOLUME_DOWN}
  VK_VOLUME_UP           = $AF;
  {$EXTERNALSYM VK_VOLUME_UP}
  VK_MEDIA_NEXT_TRACK    = $B0;
  {$EXTERNALSYM VK_MEDIA_NEXT_TRACK}
  VK_MEDIA_PREV_TRACK    = $B1;
  {$EXTERNALSYM VK_MEDIA_PREV_TRACK}
  VK_MEDIA_STOP          = $B2;
  {$EXTERNALSYM VK_MEDIA_STOP}
  VK_MEDIA_PLAY_PAUSE    = $B3;
  {$EXTERNALSYM VK_MEDIA_PLAY_PAUSE}
  VK_LAUNCH_MAIL         = $B4;
  {$EXTERNALSYM VK_LAUNCH_MAIL}
  VK_LAUNCH_MEDIA_SELECT = $B5;
  {$EXTERNALSYM VK_LAUNCH_MEDIA_SELECT}
  VK_LAUNCH_APP1         = $B6;
  {$EXTERNALSYM VK_LAUNCH_APP1}
  VK_LAUNCH_APP2         = $B7;
  {$EXTERNALSYM VK_LAUNCH_APP2}

  {$ENDIF WIN98ME_UP}

//
// 0xB8 - 0xB9 : reserved
//

  VK_OEM_1      = $BA; // ';:' for US
  {$EXTERNALSYM VK_OEM_1}
  VK_OEM_PLUS   = $BB; // '+' any country
  {$EXTERNALSYM VK_OEM_PLUS}
  VK_OEM_COMMA  = $BC; // ',' any country
  {$EXTERNALSYM VK_OEM_COMMA}
  VK_OEM_MINUS  = $BD; // '-' any country
  {$EXTERNALSYM VK_OEM_MINUS}
  VK_OEM_PERIOD = $BE; // '.' any country
  {$EXTERNALSYM VK_OEM_PERIOD}
  VK_OEM_2      = $BF; // '/?' for US
  {$EXTERNALSYM VK_OEM_2}
  VK_OEM_3      = $C0; // '`~' for US
  {$EXTERNALSYM VK_OEM_3}

//
// 0xC1 - 0xD7 : reserved
//

//
// 0xD8 - 0xDA : unassigned
//

  VK_OEM_4 = $DB; // '[{' for US
  {$EXTERNALSYM VK_OEM_4}
  VK_OEM_5 = $DC; // '\|' for US
  {$EXTERNALSYM VK_OEM_5}
  VK_OEM_6 = $DD; // ']}' for US
  {$EXTERNALSYM VK_OEM_6}
  VK_OEM_7 = $DE; // ''"' for US
  {$EXTERNALSYM VK_OEM_7}
  VK_OEM_8 = $DF;
  {$EXTERNALSYM VK_OEM_8}

//
// 0xE0 : reserved
//

//
// Various extended or enhanced keyboards
//

  VK_OEM_AX   = $E1; // 'AX' key on Japanese AX kbd
  {$EXTERNALSYM VK_OEM_AX}
  VK_OEM_102  = $E2; // "<>" or "\|" on RT 102-key kbd.
  {$EXTERNALSYM VK_OEM_102}
  VK_ICO_HELP = $E3; // Help key on ICO
  {$EXTERNALSYM VK_ICO_HELP}
  VK_ICO_00   = $E4; // 00 key on ICO
  {$EXTERNALSYM VK_ICO_00}

  VK_PROCESSKEY = $E5;
  {$EXTERNALSYM VK_PROCESSKEY}

  VK_ICO_CLEAR = $E6;
  {$EXTERNALSYM VK_ICO_CLEAR}

  {$IFDEF WIN98ME_UP}
  VK_PACKET = $E7;
  {$EXTERNALSYM VK_PACKET}
  {$ENDIF WIN98ME_UP}

//
// 0xE8 : unassigned
//

//
// Nokia/Ericsson definitions
//

  VK_OEM_RESET   = $E9;
  {$EXTERNALSYM VK_OEM_RESET}
  VK_OEM_JUMP    = $EA;
  {$EXTERNALSYM VK_OEM_JUMP}
  VK_OEM_PA1     = $EB;
  {$EXTERNALSYM VK_OEM_PA1}
  VK_OEM_PA2     = $EC;
  {$EXTERNALSYM VK_OEM_PA2}
  VK_OEM_PA3     = $ED;
  {$EXTERNALSYM VK_OEM_PA3}
  VK_OEM_WSCTRL  = $EE;
  {$EXTERNALSYM VK_OEM_WSCTRL}
  VK_OEM_CUSEL   = $EF;
  {$EXTERNALSYM VK_OEM_CUSEL}
  VK_OEM_ATTN    = $F0;
  {$EXTERNALSYM VK_OEM_ATTN}
  VK_OEM_FINISH  = $F1;
  {$EXTERNALSYM VK_OEM_FINISH}
  VK_OEM_COPY    = $F2;
  {$EXTERNALSYM VK_OEM_COPY}
  VK_OEM_AUTO    = $F3;
  {$EXTERNALSYM VK_OEM_AUTO}
  VK_OEM_ENLW    = $F4;
  {$EXTERNALSYM VK_OEM_ENLW}
  VK_OEM_BACKTAB = $F5;
  {$EXTERNALSYM VK_OEM_BACKTAB}

  VK_ATTN      = $F6;
  {$EXTERNALSYM VK_ATTN}
  VK_CRSEL     = $F7;
  {$EXTERNALSYM VK_CRSEL}
  VK_EXSEL     = $F8;
  {$EXTERNALSYM VK_EXSEL}
  VK_EREOF     = $F9;
  {$EXTERNALSYM VK_EREOF}
  VK_PLAY      = $FA;
  {$EXTERNALSYM VK_PLAY}
  VK_ZOOM      = $FB;
  {$EXTERNALSYM VK_ZOOM}
  VK_NONAME    = $FC;
  {$EXTERNALSYM VK_NONAME}
  VK_PA1       = $FD;
  {$EXTERNALSYM VK_PA1}
  VK_OEM_CLEAR = $FE;
  {$EXTERNALSYM VK_OEM_CLEAR}

//
// 0xFF : reserved
//

//
// SetWindowsHook() codes
//

  WH_MIN             = DWORD(-1);
  {$EXTERNALSYM WH_MIN}
  WH_MSGFILTER       = DWORD(-1);
  {$EXTERNALSYM WH_MSGFILTER}
  WH_JOURNALRECORD   = 0;
  {$EXTERNALSYM WH_JOURNALRECORD}
  WH_JOURNALPLAYBACK = 1;
  {$EXTERNALSYM WH_JOURNALPLAYBACK}
  WH_KEYBOARD        = 2;
  {$EXTERNALSYM WH_KEYBOARD}
  WH_GETMESSAGE      = 3;
  {$EXTERNALSYM WH_GETMESSAGE}
  WH_CALLWNDPROC     = 4;
  {$EXTERNALSYM WH_CALLWNDPROC}
  WH_CBT             = 5;
  {$EXTERNALSYM WH_CBT}
  WH_SYSMSGFILTER    = 6;
  {$EXTERNALSYM WH_SYSMSGFILTER}
  WH_MOUSE           = 7;
  {$EXTERNALSYM WH_MOUSE}
  WH_HARDWARE        = 8;
  {$EXTERNALSYM WH_HARDWARE}
  WH_DEBUG           = 9;
  {$EXTERNALSYM WH_DEBUG}
  WH_SHELL           = 10;
  {$EXTERNALSYM WH_SHELL}
  WH_FOREGROUNDIDLE  = 11;
  {$EXTERNALSYM WH_FOREGROUNDIDLE}
  WH_CALLWNDPROCRET  = 12;
  {$EXTERNALSYM WH_CALLWNDPROCRET}

  {$IFDEF WINNT4_UP}
  WH_KEYBOARD_LL = 13;
  {$EXTERNALSYM WH_KEYBOARD_LL}
  WH_MOUSE_LL    = 14;
  {$EXTERNALSYM WH_MOUSE_LL}
  {$ENDIF WINNT4_UP}

  {$IFDEF WINNT4_UP}
  WH_MAX = 14;
  {$EXTERNALSYM WH_MAX}
  {$ELSE}
  WH_MAX = 12;
  {$EXTERNALSYM WH_MAX}
  {$ENDIF WINNT4_UP}

  WH_MINHOOK = WH_MIN;
  {$EXTERNALSYM WH_MINHOOK}
  WH_MAXHOOK = WH_MAX;
  {$EXTERNALSYM WH_MAXHOOK}

//
// Hook Codes
//

  HC_ACTION      = 0;
  {$EXTERNALSYM HC_ACTION}
  HC_GETNEXT     = 1;
  {$EXTERNALSYM HC_GETNEXT}
  HC_SKIP        = 2;
  {$EXTERNALSYM HC_SKIP}
  HC_NOREMOVE    = 3;
  {$EXTERNALSYM HC_NOREMOVE}
  HC_NOREM       = HC_NOREMOVE;
  {$EXTERNALSYM HC_NOREM}
  HC_SYSMODALON  = 4;
  {$EXTERNALSYM HC_SYSMODALON}
  HC_SYSMODALOFF = 5;
  {$EXTERNALSYM HC_SYSMODALOFF}

//
// CBT Hook Codes
//

  HCBT_MOVESIZE     = 0;
  {$EXTERNALSYM HCBT_MOVESIZE}
  HCBT_MINMAX       = 1;
  {$EXTERNALSYM HCBT_MINMAX}
  HCBT_QS           = 2;
  {$EXTERNALSYM HCBT_QS}
  HCBT_CREATEWND    = 3;
  {$EXTERNALSYM HCBT_CREATEWND}
  HCBT_DESTROYWND   = 4;
  {$EXTERNALSYM HCBT_DESTROYWND}
  HCBT_ACTIVATE     = 5;
  {$EXTERNALSYM HCBT_ACTIVATE}
  HCBT_CLICKSKIPPED = 6;
  {$EXTERNALSYM HCBT_CLICKSKIPPED}
  HCBT_KEYSKIPPED   = 7;
  {$EXTERNALSYM HCBT_KEYSKIPPED}
  HCBT_SYSCOMMAND   = 8;
  {$EXTERNALSYM HCBT_SYSCOMMAND}
  HCBT_SETFOCUS     = 9;
  {$EXTERNALSYM HCBT_SETFOCUS}

//
// HCBT_ACTIVATE structure pointed to by lParam
//

type
  LPCBTACTIVATESTRUCT = ^CBTACTIVATESTRUCT;
  {$EXTERNALSYM LPCBTACTIVATESTRUCT}
  tagCBTACTIVATESTRUCT = record
    fMouse: BOOL;
    hWndActive: HWND;
  end;
  {$EXTERNALSYM tagCBTACTIVATESTRUCT}
  CBTACTIVATESTRUCT = tagCBTACTIVATESTRUCT;
  {$EXTERNALSYM CBTACTIVATESTRUCT}
  TCbtActivateStruct = CBTACTIVATESTRUCT;
  PCbtActivateStruct = LPCBTACTIVATESTRUCT;

{$IFDEF WINXP_UP}

//
// WTSSESSION_NOTIFICATION struct pointed by lParam, for WM_WTSSESSION_CHANGE
//

  tagWTSSESSION_NOTIFICATION = record
    cbSize: DWORD;
    dwSessionId: DWORD;
  end;
  {$EXTERNALSYM tagWTSSESSION_NOTIFICATION}
  WTSSESSION_NOTIFICATION = tagWTSSESSION_NOTIFICATION;
  {$EXTERNALSYM WTSSESSION_NOTIFICATION}
  PWTSSESSION_NOTIFICATION = ^WTSSESSION_NOTIFICATION;
  {$EXTERNALSYM PWTSSESSION_NOTIFICATION}
  TWtsSessionNotification = WTSSESSION_NOTIFICATION;
  PWtsSessionNotification = PWTSSESSION_NOTIFICATION;

//
// codes passed in WPARAM for WM_WTSSESSION_CHANGE
//

const
  WTS_CONSOLE_CONNECT     = $1;
  {$EXTERNALSYM WTS_CONSOLE_CONNECT}
  WTS_CONSOLE_DISCONNECT  = $2;
  {$EXTERNALSYM WTS_CONSOLE_DISCONNECT}
  WTS_REMOTE_CONNECT      = $3;
  {$EXTERNALSYM WTS_REMOTE_CONNECT}
  WTS_REMOTE_DISCONNECT   = $4;
  {$EXTERNALSYM WTS_REMOTE_DISCONNECT}
  WTS_SESSION_LOGON       = $5;
  {$EXTERNALSYM WTS_SESSION_LOGON}
  WTS_SESSION_LOGOFF      = $6;
  {$EXTERNALSYM WTS_SESSION_LOGOFF}
  WTS_SESSION_LOCK        = $7;
  {$EXTERNALSYM WTS_SESSION_LOCK}
  WTS_SESSION_UNLOCK      = $8;
  {$EXTERNALSYM WTS_SESSION_UNLOCK}
  WTS_SESSION_REMOTE_CONTROL = $9;
  {$EXTERNALSYM WTS_SESSION_REMOTE_CONTROL}

{$ENDIF WINXP_UP}

//
// WH_MSGFILTER Filter Proc Codes
//

const
  MSGF_DIALOGBOX  = 0;
  {$EXTERNALSYM MSGF_DIALOGBOX}
  MSGF_MESSAGEBOX = 1;
  {$EXTERNALSYM MSGF_MESSAGEBOX}
  MSGF_MENU       = 2;
  {$EXTERNALSYM MSGF_MENU}
  MSGF_SCROLLBAR  = 5;
  {$EXTERNALSYM MSGF_SCROLLBAR}
  MSGF_NEXTWINDOW = 6;
  {$EXTERNALSYM MSGF_NEXTWINDOW}
  MSGF_MAX        = 8; // unused
  {$EXTERNALSYM MSGF_MAX}
  MSGF_USER       = 4096;
  {$EXTERNALSYM MSGF_USER}

//
// Shell support
//

  HSHELL_WINDOWCREATED       = 1;
  {$EXTERNALSYM HSHELL_WINDOWCREATED}
  HSHELL_WINDOWDESTROYED     = 2;
  {$EXTERNALSYM HSHELL_WINDOWDESTROYED}
  HSHELL_ACTIVATESHELLWINDOW = 3;
  {$EXTERNALSYM HSHELL_ACTIVATESHELLWINDOW}

  HSHELL_WINDOWACTIVATED = 4;
  {$EXTERNALSYM HSHELL_WINDOWACTIVATED}
  HSHELL_GETMINRECT      = 5;
  {$EXTERNALSYM HSHELL_GETMINRECT}
  HSHELL_REDRAW          = 6;
  {$EXTERNALSYM HSHELL_REDRAW}
  HSHELL_TASKMAN         = 7;
  {$EXTERNALSYM HSHELL_TASKMAN}
  HSHELL_LANGUAGE        = 8;
  {$EXTERNALSYM HSHELL_LANGUAGE}
  HSHELL_SYSMENU            = 9;
  {$EXTERNALSYM HSHELL_SYSMENU}
  HSHELL_ENDTASK            = 10;
  {$EXTERNALSYM HSHELL_ENDTASK}
  {$IFDEF WIN2000_UP}
  HSHELL_ACCESSIBILITYSTATE = 11;
  {$EXTERNALSYM HSHELL_ACCESSIBILITYSTATE}
  HSHELL_APPCOMMAND      = 12;
  {$EXTERNALSYM HSHELL_APPCOMMAND}
  {$ENDIF WIN2000_UP}

  {$IFDEF WINXP_UP}
  HSHELL_WINDOWREPLACED  = 13;
  {$EXTERNALSYM HSHELL_WINDOWREPLACED}
  {$ENDIF WINXP_UP}
  HSHELL_WINDOWREPLACING = 14;
  {$EXTERNALSYM HSHELL_WINDOWREPLACING}

  HSHELL_HIGHBIT          = $8000;
  {$EXTERNALSYM HSHELL_HIGHBIT}
  HSHELL_FLASH            = HSHELL_REDRAW or HSHELL_HIGHBIT;
  {$EXTERNALSYM HSHELL_FLASH}
  HSHELL_RUDEAPPACTIVATED = HSHELL_WINDOWACTIVATED or HSHELL_HIGHBIT;
  {$EXTERNALSYM HSHELL_RUDEAPPACTIVATED}

{$IFDEF WIN2000_UP}

// wparam for HSHELL_ACCESSIBILITYSTATE//

  ACCESS_STICKYKEYS = $0001;
  {$EXTERNALSYM ACCESS_STICKYKEYS}
  ACCESS_FILTERKEYS = $0002;
  {$EXTERNALSYM ACCESS_FILTERKEYS}
  ACCESS_MOUSEKEYS  = $0003;
  {$EXTERNALSYM ACCESS_MOUSEKEYS}

// cmd for HSHELL_APPCOMMAND and WM_APPCOMMAND//

  APPCOMMAND_BROWSER_BACKWARD    = 1;
  {$EXTERNALSYM APPCOMMAND_BROWSER_BACKWARD}
  APPCOMMAND_BROWSER_FORWARD     = 2;
  {$EXTERNALSYM APPCOMMAND_BROWSER_FORWARD}
  APPCOMMAND_BROWSER_REFRESH     = 3;
  {$EXTERNALSYM APPCOMMAND_BROWSER_REFRESH}
  APPCOMMAND_BROWSER_STOP        = 4;
  {$EXTERNALSYM APPCOMMAND_BROWSER_STOP}
  APPCOMMAND_BROWSER_SEARCH      = 5;
  {$EXTERNALSYM APPCOMMAND_BROWSER_SEARCH}
  APPCOMMAND_BROWSER_FAVORITES   = 6;
  {$EXTERNALSYM APPCOMMAND_BROWSER_FAVORITES}
  APPCOMMAND_BROWSER_HOME        = 7;
  {$EXTERNALSYM APPCOMMAND_BROWSER_HOME}
  APPCOMMAND_VOLUME_MUTE         = 8;
  {$EXTERNALSYM APPCOMMAND_VOLUME_MUTE}
  APPCOMMAND_VOLUME_DOWN         = 9;
  {$EXTERNALSYM APPCOMMAND_VOLUME_DOWN}
  APPCOMMAND_VOLUME_UP           = 10;
  {$EXTERNALSYM APPCOMMAND_VOLUME_UP}
  APPCOMMAND_MEDIA_NEXTTRACK     = 11;
  {$EXTERNALSYM APPCOMMAND_MEDIA_NEXTTRACK}
  APPCOMMAND_MEDIA_PREVIOUSTRACK = 12;
  {$EXTERNALSYM APPCOMMAND_MEDIA_PREVIOUSTRACK}
  APPCOMMAND_MEDIA_STOP          = 13;
  {$EXTERNALSYM APPCOMMAND_MEDIA_STOP}
  APPCOMMAND_MEDIA_PLAY_PAUSE    = 14;
  {$EXTERNALSYM APPCOMMAND_MEDIA_PLAY_PAUSE}
  APPCOMMAND_LAUNCH_MAIL         = 15;
  {$EXTERNALSYM APPCOMMAND_LAUNCH_MAIL}
  APPCOMMAND_LAUNCH_MEDIA_SELECT = 16;
  {$EXTERNALSYM APPCOMMAND_LAUNCH_MEDIA_SELECT}
  APPCOMMAND_LAUNCH_APP1         = 17;
  {$EXTERNALSYM APPCOMMAND_LAUNCH_APP1}
  APPCOMMAND_LAUNCH_APP2         = 18;
  {$EXTERNALSYM APPCOMMAND_LAUNCH_APP2}
  APPCOMMAND_BASS_DOWN           = 19;
  {$EXTERNALSYM APPCOMMAND_BASS_DOWN}
  APPCOMMAND_BASS_BOOST          = 20;
  {$EXTERNALSYM APPCOMMAND_BASS_BOOST}
  APPCOMMAND_BASS_UP             = 21;
  {$EXTERNALSYM APPCOMMAND_BASS_UP}
  APPCOMMAND_TREBLE_DOWN         = 22;
  {$EXTERNALSYM APPCOMMAND_TREBLE_DOWN}
  APPCOMMAND_TREBLE_UP           = 23;
  {$EXTERNALSYM APPCOMMAND_TREBLE_UP}
  {$IFDEF WINXP_UP}
  APPCOMMAND_MICROPHONE_VOLUME_MUTE = 24;
  {$EXTERNALSYM APPCOMMAND_MICROPHONE_VOLUME_MUTE}
  APPCOMMAND_MICROPHONE_VOLUME_DOWN = 25;
  {$EXTERNALSYM APPCOMMAND_MICROPHONE_VOLUME_DOWN}
  APPCOMMAND_MICROPHONE_VOLUME_UP   = 26;
  {$EXTERNALSYM APPCOMMAND_MICROPHONE_VOLUME_UP}
  APPCOMMAND_HELP                   = 27;
  {$EXTERNALSYM APPCOMMAND_HELP}
  APPCOMMAND_FIND                   = 28;
  {$EXTERNALSYM APPCOMMAND_FIND}
  APPCOMMAND_NEW                    = 29;
  {$EXTERNALSYM APPCOMMAND_NEW}
  APPCOMMAND_OPEN                   = 30;
  {$EXTERNALSYM APPCOMMAND_OPEN}
  APPCOMMAND_CLOSE                  = 31;
  {$EXTERNALSYM APPCOMMAND_CLOSE}
  APPCOMMAND_SAVE                   = 32;
  {$EXTERNALSYM APPCOMMAND_SAVE}
  APPCOMMAND_PRINT                  = 33;
  {$EXTERNALSYM APPCOMMAND_PRINT}
  APPCOMMAND_UNDO                   = 34;
  {$EXTERNALSYM APPCOMMAND_UNDO}
  APPCOMMAND_REDO                   = 35;
  {$EXTERNALSYM APPCOMMAND_REDO}
  APPCOMMAND_COPY                   = 36;
  {$EXTERNALSYM APPCOMMAND_COPY}
  APPCOMMAND_CUT                    = 37;
  {$EXTERNALSYM APPCOMMAND_CUT}
  APPCOMMAND_PASTE                  = 38;
  {$EXTERNALSYM APPCOMMAND_PASTE}
  APPCOMMAND_REPLY_TO_MAIL          = 39;
  {$EXTERNALSYM APPCOMMAND_REPLY_TO_MAIL}
  APPCOMMAND_FORWARD_MAIL           = 40;
  {$EXTERNALSYM APPCOMMAND_FORWARD_MAIL}
  APPCOMMAND_SEND_MAIL              = 41;
  {$EXTERNALSYM APPCOMMAND_SEND_MAIL}
  APPCOMMAND_SPELL_CHECK            = 42;
  {$EXTERNALSYM APPCOMMAND_SPELL_CHECK}
  APPCOMMAND_DICTATE_OR_COMMAND_CONTROL_TOGGLE = 43;
  {$EXTERNALSYM APPCOMMAND_DICTATE_OR_COMMAND_CONTROL_TOGGLE}
  APPCOMMAND_MIC_ON_OFF_TOGGLE      = 44;
  {$EXTERNALSYM APPCOMMAND_MIC_ON_OFF_TOGGLE}
  APPCOMMAND_CORRECTION_LIST        = 45;
  {$EXTERNALSYM APPCOMMAND_CORRECTION_LIST}
  {$ENDIF WINXP_UP}
  APPCOMMAND_MEDIA_PLAY             = 46;
  {$EXTERNALSYM APPCOMMAND_MEDIA_PLAY}
  APPCOMMAND_MEDIA_PAUSE            = 47;
  {$EXTERNALSYM APPCOMMAND_MEDIA_PAUSE}
  APPCOMMAND_MEDIA_RECORD           = 48;
  {$EXTERNALSYM APPCOMMAND_MEDIA_RECORD}
  APPCOMMAND_MEDIA_FAST_FORWARD     = 49;
  {$EXTERNALSYM APPCOMMAND_MEDIA_FAST_FORWARD}
  APPCOMMAND_MEDIA_REWIND           = 50;
  {$EXTERNALSYM APPCOMMAND_MEDIA_REWIND}
  APPCOMMAND_MEDIA_CHANNEL_UP       = 51;
  {$EXTERNALSYM APPCOMMAND_MEDIA_CHANNEL_UP}
  APPCOMMAND_MEDIA_CHANNEL_DOWN     = 52;
  {$EXTERNALSYM APPCOMMAND_MEDIA_CHANNEL_DOWN}

  FAPPCOMMAND_MOUSE = $8000;
  {$EXTERNALSYM FAPPCOMMAND_MOUSE}
  FAPPCOMMAND_KEY   = 0;
  {$EXTERNALSYM FAPPCOMMAND_KEY}
  FAPPCOMMAND_OEM   = $1000;
  {$EXTERNALSYM FAPPCOMMAND_OEM}
  FAPPCOMMAND_MASK  = $F000;
  {$EXTERNALSYM FAPPCOMMAND_MASK}

function GET_APPCOMMAND_LPARAM(lParam: LPARAM): WORD;
{$EXTERNALSYM GET_APPCOMMAND_LPARAM}

function GET_DEVICE_LPARAM(lParam: LPARAM): WORD;
{$EXTERNALSYM GET_DEVICE_LPARAM}

function GET_MOUSEORKEY_LPARAM(lParam: LPARAM): WORD;
{$EXTERNALSYM GET_MOUSEORKEY_LPARAM}

function GET_FLAGS_LPARAM(lParam: LPARAM): Integer;
{$EXTERNALSYM GET_FLAGS_LPARAM}

function GET_KEYSTATE_LPARAM(lParam: LPARAM): Integer;
{$EXTERNALSYM GET_KEYSTATE_LPARAM}

{$ENDIF WIN2000_UP}

type
  SHELLHOOKINFO = record
    hwnd: HWND;
    rc: RECT;
  end;
  {$EXTERNALSYM SHELLHOOKINFO}
  LPSHELLHOOKINFO = ^SHELLHOOKINFO;
  {$EXTERNALSYM LPSHELLHOOKINFO}
  TShellHookInfo = SHELLHOOKINFO;
  PShellHookInfo = LPSHELLHOOKINFO;

//
// Message Structure used in Journaling
//

type
  LPEVENTMSG = ^EVENTMSG;
  {$EXTERNALSYM LPEVENTMSG}
  tagEVENTMSG = record
    message_: UINT;
    paramL: UINT;
    paramH: UINT;
    time: DWORD;
    hwnd: HWND;
  end;
  {$EXTERNALSYM tagEVENTMSG}
  EVENTMSG = tagEVENTMSG;
  {$EXTERNALSYM EVENTMSG}
  LPEVENTMSGMSG = ^EVENTMSG;
  {$EXTERNALSYM LPEVENTMSGMSG}
  PEVENTMSGMSG = ^EVENTMSG;
  {$EXTERNALSYM PEVENTMSGMSG}
  NPEVENTMSG = ^EVENTMSG;
  {$EXTERNALSYM NPEVENTMSG}
  NPEVENTMSGMSG = ^EVENTMSG;
  {$EXTERNALSYM NPEVENTMSGMSG}
  TEventMsg = EVENTMSG;
  PEventMsg = LPEVENTMSG;

//
// Message structure used by WH_CALLWNDPROC
//

  LPCWPSTRUCT = ^CWPSTRUCT;
  {$EXTERNALSYM LPCWPSTRUCT}
  tagCWPSTRUCT = record
    lParam: LPARAM;
    wParam: WPARAM;
    message: UINT;
    hwnd: HWND;
  end;
  {$EXTERNALSYM tagCWPSTRUCT}
  CWPSTRUCT = tagCWPSTRUCT;
  {$EXTERNALSYM CWPSTRUCT}
  NPCWPSTRUCT = ^CWPSTRUCT;
  {$EXTERNALSYM NPCWPSTRUCT}
  TCwpStruct = CWPSTRUCT;
  PCwpStruct = LPCWPSTRUCT;

//
// Message structure used by WH_CALLWNDPROCRET
//

  LPCWPRETSTRUCT = ^CWPRETSTRUCT;
  {$EXTERNALSYM LPCWPRETSTRUCT}
  tagCWPRETSTRUCT = record
    lResult: LRESULT;
    lParam: LPARAM;
    wParam: WPARAM;
    message: UINT;
    hwnd: HWND;
  end;
  {$EXTERNALSYM tagCWPRETSTRUCT}
  CWPRETSTRUCT = tagCWPRETSTRUCT;
  {$EXTERNALSYM CWPRETSTRUCT}
  NPCWPRETSTRUCT = ^CWPRETSTRUCT;
  {$EXTERNALSYM NPCWPRETSTRUCT}
  TCwpRetStruct = CWPRETSTRUCT;
  PCwpRetStruct = LPCWPRETSTRUCT;

//
// Low level hook flags
//

const
  LLKHF_EXTENDED = KF_EXTENDED shr 8;
  {$EXTERNALSYM LLKHF_EXTENDED}
  LLKHF_INJECTED = $00000010;
  {$EXTERNALSYM LLKHF_INJECTED}
  LLKHF_ALTDOWN  = KF_ALTDOWN shr 8;
  {$EXTERNALSYM LLKHF_ALTDOWN}
  LLKHF_UP       = KF_UP shr 8;
  {$EXTERNALSYM LLKHF_UP}

  LLMHF_INJECTED = $00000001;
  {$EXTERNALSYM LLMHF_INJECTED}

//
// Structure used by WH_KEYBOARD_LL
//

type
  LPKBDLLHOOKSTRUCT = ^KBDLLHOOKSTRUCT;
  {$EXTERNALSYM LPKBDLLHOOKSTRUCT}
  tagKBDLLHOOKSTRUCT = record
    vkCode: DWORD;
    scanCode: DWORD;
    flags: DWORD;
    time: DWORD;
    dwExtraInfo: ULONG_PTR;
  end;
  {$EXTERNALSYM tagKBDLLHOOKSTRUCT}
  KBDLLHOOKSTRUCT = tagKBDLLHOOKSTRUCT;
  {$EXTERNALSYM KBDLLHOOKSTRUCT}
  TKbDllHookStruct = KBDLLHOOKSTRUCT;
  PKbDllHookStruct = LPKBDLLHOOKSTRUCT;

//
// Structure used by WH_MOUSE_LL
//

  LPMSLLHOOKSTRUCT = ^MSLLHOOKSTRUCT;
  {$EXTERNALSYM LPMSLLHOOKSTRUCT}
  tagMSLLHOOKSTRUCT = record
    pt: POINT;
    mouseData: DWORD;
    flags: DWORD;
    time: DWORD;
    dwExtraInfo: ULONG_PTR;
  end;
  {$EXTERNALSYM tagMSLLHOOKSTRUCT}
  MSLLHOOKSTRUCT = tagMSLLHOOKSTRUCT;
  {$EXTERNALSYM MSLLHOOKSTRUCT}
  TMsllHookStruct = MSLLHOOKSTRUCT;
  PMsllHookStruct = LPMSLLHOOKSTRUCT;

//
// Structure used by WH_DEBUG
//

  LPDEBUGHOOKINFO = ^DEBUGHOOKINFO;
  {$EXTERNALSYM LPDEBUGHOOKINFO}
  tagDEBUGHOOKINFO = record
    idThread: DWORD;
    idThreadInstaller: DWORD;
    lParam: LPARAM;
    wParam: WPARAM;
    code: Integer;
  end;
  {$EXTERNALSYM tagDEBUGHOOKINFO}
  DEBUGHOOKINFO = tagDEBUGHOOKINFO;
  {$EXTERNALSYM DEBUGHOOKINFO}
  NPDEBUGHOOKINFO = ^DEBUGHOOKINFO;
  {$EXTERNALSYM NPDEBUGHOOKINFO}
  TDebugHookInfo = DEBUGHOOKINFO;
  PDebugHookInfo = LPDEBUGHOOKINFO;

//
// Structure used by WH_MOUSE
//

  LPMOUSEHOOKSTRUCT = ^MOUSEHOOKSTRUCT;
  {$EXTERNALSYM LPMOUSEHOOKSTRUCT}
  tagMOUSEHOOKSTRUCT = record
    pt: POINT;
    hwnd: HWND;
    wHitTestCode: UINT;
    dwExtraInfo: ULONG_PTR;
  end;
  {$EXTERNALSYM tagMOUSEHOOKSTRUCT}
  MOUSEHOOKSTRUCT = tagMOUSEHOOKSTRUCT;
  {$EXTERNALSYM MOUSEHOOKSTRUCT}
  TMouseHookStruct = MOUSEHOOKSTRUCT;
  PMouseHookStruct = LPMOUSEHOOKSTRUCT;

  LPMOUSEHOOKSTRUCTEX = ^MOUSEHOOKSTRUCTEX;
  {$EXTERNALSYM LPMOUSEHOOKSTRUCTEX}
  tagMOUSEHOOKSTRUCTEX = record
    mhs: MOUSEHOOKSTRUCT;
    mouseData: DWORD;
  end;
  {$EXTERNALSYM tagMOUSEHOOKSTRUCTEX}
  MOUSEHOOKSTRUCTEX = tagMOUSEHOOKSTRUCTEX;
  {$EXTERNALSYM MOUSEHOOKSTRUCTEX}
  TMouseHookStructEx = MOUSEHOOKSTRUCTEX;
  PMouseHookStructEx = LPMOUSEHOOKSTRUCTEX;

//
// Structure used by WH_HARDWARE
//

  LPHARDWAREHOOKSTRUCT = ^HARDWAREHOOKSTRUCT;
  {$EXTERNALSYM LPHARDWAREHOOKSTRUCT}
  tagHARDWAREHOOKSTRUCT = record
    hwnd: HWND;
    message: UINT;
    wParam: WPARAM;
    lParam: LPARAM;
  end;
  {$EXTERNALSYM tagHARDWAREHOOKSTRUCT}
  HARDWAREHOOKSTRUCT = tagHARDWAREHOOKSTRUCT;
  {$EXTERNALSYM HARDWAREHOOKSTRUCT}
  THardwareHookStruct = HARDWAREHOOKSTRUCT;
  PHardwareHookStruct = LPHARDWAREHOOKSTRUCT;

//
// Keyboard Layout API
//

const
  HKL_PREV = 0;
  {$EXTERNALSYM HKL_PREV}
  HKL_NEXT = 1;
  {$EXTERNALSYM HKL_NEXT}

  KLF_ACTIVATE      = $00000001;
  {$EXTERNALSYM KLF_ACTIVATE}
  KLF_SUBSTITUTE_OK = $00000002;
  {$EXTERNALSYM KLF_SUBSTITUTE_OK}
  KLF_REORDER       = $00000008;
  {$EXTERNALSYM KLF_REORDER}
  KLF_REPLACELANG   = $00000010;
  {$EXTERNALSYM KLF_REPLACELANG}
  KLF_NOTELLSHELL   = $00000080;
  {$EXTERNALSYM KLF_NOTELLSHELL}
  KLF_SETFORPROCESS = $00000100;
  {$EXTERNALSYM KLF_SETFORPROCESS}
  KLF_SHIFTLOCK     = $00010000;
  {$EXTERNALSYM KLF_SHIFTLOCK}
  KLF_RESET         = $40000000;
  {$EXTERNALSYM KLF_RESET}

//
// Bits in wParam of WM_INPUTLANGCHANGEREQUEST message
//

  INPUTLANGCHANGE_SYSCHARSET = $0001;
  {$EXTERNALSYM INPUTLANGCHANGE_SYSCHARSET}
  INPUTLANGCHANGE_FORWARD    = $0002;
  {$EXTERNALSYM INPUTLANGCHANGE_FORWARD}
  INPUTLANGCHANGE_BACKWARD   = $0004;
  {$EXTERNALSYM INPUTLANGCHANGE_BACKWARD}

//
// Size of KeyboardLayoutName (number of characters), including nul terminator
//

  KL_NAMELENGTH = 9;
  {$EXTERNALSYM KL_NAMELENGTH}

function LoadKeyboardLayoutA(pwszKLID: LPCSTR; Flags: UINT): HKL; stdcall;
{$EXTERNALSYM LoadKeyboardLayoutA}
function LoadKeyboardLayoutW(pwszKLID: LPCWSTR; Flags: UINT): HKL; stdcall;
{$EXTERNALSYM LoadKeyboardLayoutW}
function LoadKeyboardLayout(pwszKLID: LPCTSTR; Flags: UINT): HKL; stdcall;
{$EXTERNALSYM LoadKeyboardLayout}

function ActivateKeyboardLayout(hkl: HKL; Flags: UINT): HKL; stdcall;
{$EXTERNALSYM ActivateKeyboardLayout}

function ToUnicodeEx(wVirtKey, wScanCode: UINT; lpKeyState: PBYTE;
  pwszBuff: LPWSTR; cchBuff: Integer; wFlags: UINT; dwhkl: HKL): Integer; stdcall;
{$EXTERNALSYM ToUnicodeEx}

function UnloadKeyboardLayout(hkl: HKL): BOOL; stdcall;
{$EXTERNALSYM UnloadKeyboardLayout}

function GetKeyboardLayoutNameA(pwszKLID: LPSTR): BOOL; stdcall;
{$EXTERNALSYM GetKeyboardLayoutNameA}
function GetKeyboardLayoutNameW(pwszKLID: LPWSTR): BOOL; stdcall;
{$EXTERNALSYM GetKeyboardLayoutNameW}
function GetKeyboardLayoutName(pwszKLID: LPTSTR): BOOL; stdcall;
{$EXTERNALSYM GetKeyboardLayoutName}

function GetKeyboardLayoutList(nBuff: Integer; lpList: PHKL): Integer; stdcall;
{$EXTERNALSYM GetKeyboardLayoutList}

function GetKeyboardLayout(idThread: DWORD): HKL; stdcall;
{$EXTERNALSYM GetKeyboardLayout}

type
  LPMOUSEMOVEPOINT = ^MOUSEMOVEPOINT;
  {$EXTERNALSYM LPMOUSEMOVEPOINT}
  tagMOUSEMOVEPOINT = record
    x: Integer;
    y: Integer;
    time: DWORD;
    dwExtraInfo: ULONG_PTR;
  end;
  {$EXTERNALSYM tagMOUSEMOVEPOINT}
  MOUSEMOVEPOINT = tagMOUSEMOVEPOINT;
  {$EXTERNALSYM MOUSEMOVEPOINT}
  TMouseMovePoint = MOUSEMOVEPOINT;
  PMouseMovePoint = LPMOUSEMOVEPOINT;

//
// Values for resolution parameter of GetMouseMovePointsEx
//

const
  GMMP_USE_DISPLAY_POINTS         = 1;
  {$EXTERNALSYM GMMP_USE_DISPLAY_POINTS}
  GMMP_USE_HIGH_RESOLUTION_POINTS = 2;
  {$EXTERNALSYM GMMP_USE_HIGH_RESOLUTION_POINTS}

function GetMouseMovePointsEx(cbSize: UINT; lppt, lpptBuf: LPMOUSEMOVEPOINT;
  nBufPoints: Integer; resolution: DWORD): Integer; stdcall;
{$EXTERNALSYM GetMouseMovePointsEx}

//
// Desktop-specific access flags
//

const
  DESKTOP_READOBJECTS     = $0001;
  {$EXTERNALSYM DESKTOP_READOBJECTS}
  DESKTOP_CREATEWINDOW    = $0002;
  {$EXTERNALSYM DESKTOP_CREATEWINDOW}
  DESKTOP_CREATEMENU      = $0004;
  {$EXTERNALSYM DESKTOP_CREATEMENU}
  DESKTOP_HOOKCONTROL     = $0008;
  {$EXTERNALSYM DESKTOP_HOOKCONTROL}
  DESKTOP_JOURNALRECORD   = $0010;
  {$EXTERNALSYM DESKTOP_JOURNALRECORD}
  DESKTOP_JOURNALPLAYBACK = $0020;
  {$EXTERNALSYM DESKTOP_JOURNALPLAYBACK}
  DESKTOP_ENUMERATE       = $0040;
  {$EXTERNALSYM DESKTOP_ENUMERATE}
  DESKTOP_WRITEOBJECTS    = $0080;
  {$EXTERNALSYM DESKTOP_WRITEOBJECTS}
  DESKTOP_SWITCHDESKTOP   = $0100;
  {$EXTERNALSYM DESKTOP_SWITCHDESKTOP}

//
// Desktop-specific control flags
//

  DF_ALLOWOTHERACCOUNTHOOK = $0001;
  {$EXTERNALSYM DF_ALLOWOTHERACCOUNTHOOK}

function CreateDesktopA(lpszDesktop, lpszDevice: LPCSTR; pDevmode: LPDEVMODEA;
  dwFlags: DWORD; dwDesiredAccess: ACCESS_MASK; lpsa: LPSECURITY_ATTRIBUTES): HDESK; stdcall;
{$EXTERNALSYM CreateDesktopA}
function CreateDesktopW(lpszDesktop, lpszDevice: LPCWSTR; pDevmode: LPDEVMODEW;
  dwFlags: DWORD; dwDesiredAccess: ACCESS_MASK; lpsa: LPSECURITY_ATTRIBUTES): HDESK; stdcall;
{$EXTERNALSYM CreateDesktopW}
function CreateDesktop(lpszDesktop, lpszDevice: LPCTSTR; pDevmode: LPDEVMODE;
  dwFlags: DWORD; dwDesiredAccess: ACCESS_MASK; lpsa: LPSECURITY_ATTRIBUTES): HDESK; stdcall;
{$EXTERNALSYM CreateDesktop}

function OpenDesktopA(lpszDesktop: LPCSTR; dwFlags: DWORD; fInherit: BOOL;
  dwDesiredAccess: ACCESS_MASK): HDESK; stdcall;
{$EXTERNALSYM OpenDesktopA}
function OpenDesktopW(lpszDesktop: LPCWSTR; dwFlags: DWORD; fInherit: BOOL;
  dwDesiredAccess: ACCESS_MASK): HDESK; stdcall;
{$EXTERNALSYM OpenDesktopW}
function OpenDesktop(lpszDesktop: LPCTSTR; dwFlags: DWORD; fInherit: BOOL;
  dwDesiredAccess: ACCESS_MASK): HDESK; stdcall;
{$EXTERNALSYM OpenDesktop}

function OpenInputDesktop(dwFlags: DWORD; fInherit: BOOL;
  dwDesiredAccess: ACCESS_MASK): HDESK; stdcall;
{$EXTERNALSYM OpenInputDesktop}

function EnumDesktopsA(hwinsta: HWINSTA; lpEnumFunc: DESKTOPENUMPROCA;
  lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumDesktopsA}
function EnumDesktopsW(hwinsta: HWINSTA; lpEnumFunc: DESKTOPENUMPROCW;
  lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumDesktopsW}
function EnumDesktops(hwinsta: HWINSTA; lpEnumFunc: DESKTOPENUMPROC;
  lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumDesktops}

function EnumDesktopWindows(hDesktop: HDESK; lpfn: WNDENUMPROC; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumDesktopWindows}

function SwitchDesktop(hDesktop: HDESK): BOOL; stdcall;
{$EXTERNALSYM SwitchDesktop}

function SetThreadDesktop(hDesktop: HDESK): BOOL; stdcall;
{$EXTERNALSYM SetThreadDesktop}

function CloseDesktop(hDesktop: HDESK): BOOL; stdcall;
{$EXTERNALSYM CloseDesktop}

function GetThreadDesktop(dwThreadId: DWORD): HDESK; stdcall;
{$EXTERNALSYM GetThreadDesktop}

//
// Windowstation-specific access flags
//

const
  WINSTA_ENUMDESKTOPS      = $0001;
  {$EXTERNALSYM WINSTA_ENUMDESKTOPS}
  WINSTA_READATTRIBUTES    = $0002;
  {$EXTERNALSYM WINSTA_READATTRIBUTES}
  WINSTA_ACCESSCLIPBOARD   = $0004;
  {$EXTERNALSYM WINSTA_ACCESSCLIPBOARD}
  WINSTA_CREATEDESKTOP     = $0008;
  {$EXTERNALSYM WINSTA_CREATEDESKTOP}
  WINSTA_WRITEATTRIBUTES   = $0010;
  {$EXTERNALSYM WINSTA_WRITEATTRIBUTES}
  WINSTA_ACCESSGLOBALATOMS = $0020;
  {$EXTERNALSYM WINSTA_ACCESSGLOBALATOMS}
  WINSTA_EXITWINDOWS       = $0040;
  {$EXTERNALSYM WINSTA_EXITWINDOWS}
  WINSTA_ENUMERATE         = $0100;
  {$EXTERNALSYM WINSTA_ENUMERATE}
  WINSTA_READSCREEN        = $0200;
  {$EXTERNALSYM WINSTA_READSCREEN}

  WINSTA_ALL_ACCESS        = (WINSTA_ENUMDESKTOPS or WINSTA_READATTRIBUTES or WINSTA_ACCESSCLIPBOARD or
                              WINSTA_CREATEDESKTOP or WINSTA_WRITEATTRIBUTES or WINSTA_ACCESSGLOBALATOMS or
                              WINSTA_EXITWINDOWS or WINSTA_ENUMERATE or WINSTA_READSCREEN);
  {$EXTERNALSYM WINSTA_ALL_ACCESS}

//
// Windowstation creation flags.
//

  CWF_CREATE_ONLY          = $0001;
  {$EXTERNALSYM CWF_CREATE_ONLY}

//
// Windowstation-specific attribute flags
//

  WSF_VISIBLE = $0001;
  {$EXTERNALSYM WSF_VISIBLE}

function CreateWindowStationA(lpwinsta: LPCSTR; dwFlags: DWORD;
  dwDesiredAccess: ACCESS_MASK; lpsa: LPSECURITY_ATTRIBUTES): HWINSTA; stdcall;
{$EXTERNALSYM CreateWindowStationA}
function CreateWindowStationW(lpwinsta: LPCWSTR; dwFlags: DWORD;
  dwDesiredAccess: ACCESS_MASK; lpsa: LPSECURITY_ATTRIBUTES): HWINSTA; stdcall;
{$EXTERNALSYM CreateWindowStationW}
function CreateWindowStation(lpwinsta: LPCTSTR; dwFlags: DWORD;
  dwDesiredAccess: ACCESS_MASK; lpsa: LPSECURITY_ATTRIBUTES): HWINSTA; stdcall;
{$EXTERNALSYM CreateWindowStation}

function OpenWindowStationA(lpszWinSta: LPCSTR; fInherit: BOOL;
  dwDesiredAccess: ACCESS_MASK): HWINSTA; stdcall;
{$EXTERNALSYM OpenWindowStationA}
function OpenWindowStationW(lpszWinSta: LPCWSTR; fInherit: BOOL;
  dwDesiredAccess: ACCESS_MASK): HWINSTA; stdcall;
{$EXTERNALSYM OpenWindowStationW}
function OpenWindowStation(lpszWinSta: LPCTSTR; fInherit: BOOL;
  dwDesiredAccess: ACCESS_MASK): HWINSTA; stdcall;
{$EXTERNALSYM OpenWindowStation}

function EnumWindowStationsA(lpEnumFunc: WINSTAENUMPROCA; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumWindowStationsA}
function EnumWindowStationsW(lpEnumFunc: WINSTAENUMPROCW; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumWindowStationsW}
function EnumWindowStations(lpEnumFunc: WINSTAENUMPROC; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumWindowStations}

function CloseWindowStation(hWinSta: HWINSTA): BOOL; stdcall;
{$EXTERNALSYM CloseWindowStation}

function SetProcessWindowStation(hWinSta: HWINSTA): BOOL; stdcall;
{$EXTERNALSYM SetProcessWindowStation}

function GetProcessWindowStation: HWINSTA; stdcall;
{$EXTERNALSYM GetProcessWindowStation}

function SetUserObjectSecurity(hObj: HANDLE; var pSIRequested: SECURITY_INFORMATION;
  pSID: PSECURITY_DESCRIPTOR): BOOL; stdcall;
{$EXTERNALSYM SetUserObjectSecurity}

function GetUserObjectSecurity(hObj: HANDLE; var pSIRequested: SECURITY_INFORMATION;
  pSID: PSECURITY_DESCRIPTOR; nLength: DWORD; var lpnLengthNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetUserObjectSecurity}

const
  UOI_FLAGS    = 1;
  {$EXTERNALSYM UOI_FLAGS}
  UOI_NAME     = 2;
  {$EXTERNALSYM UOI_NAME}
  UOI_TYPE     = 3;
  {$EXTERNALSYM UOI_TYPE}
  UOI_USER_SID = 4;
  {$EXTERNALSYM UOI_USER_SID}

type
  PUSEROBJECTFLAGS = ^USEROBJECTFLAGS;
  tagUSEROBJECTFLAGS = record
    fInherit: BOOL;
    fReserved: BOOL;
    dwFlags: DWORD;
  end;
  {$EXTERNALSYM tagUSEROBJECTFLAGS}
  USEROBJECTFLAGS = tagUSEROBJECTFLAGS;
  {$EXTERNALSYM USEROBJECTFLAGS}
  TUserObjectFlags = USEROBJECTFLAGS;

function GetUserObjectInformationA(hObj: HANDLE; nIndex: Integer; pvInfo: PVOID;
  nLength: DWORD; var lpnLengthNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetUserObjectInformationA}
function GetUserObjectInformationW(hObj: HANDLE; nIndex: Integer; pvInfo: PVOID;
  nLength: DWORD; var lpnLengthNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetUserObjectInformationW}
function GetUserObjectInformation(hObj: HANDLE; nIndex: Integer; pvInfo: PVOID;
  nLength: DWORD; var lpnLengthNeeded: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetUserObjectInformation}

function SetUserObjectInformationA(hObj: HANDLE; nIndex: Integer; pvInfo: PVOID;
  nLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetUserObjectInformationA}
function SetUserObjectInformationW(hObj: HANDLE; nIndex: Integer; pvInfo: PVOID;
  nLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetUserObjectInformationW}
function SetUserObjectInformation(hObj: HANDLE; nIndex: Integer; pvInfo: PVOID;
  nLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetUserObjectInformation}

type
  LPWNDCLASSEXA = ^WNDCLASSEXA;
  {$EXTERNALSYM LPWNDCLASSEXA}
  tagWNDCLASSEXA = record
    cbSize: UINT;
    // Win 3.x
    style: UINT;
    lpfnWndProc: WNDPROC;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    lpszMenuName: LPCSTR;
    lpszClassName: LPCSTR;
    // Win 4.0
    hIconSm: HICON;
  end;
  {$EXTERNALSYM tagWNDCLASSEXA}
  WNDCLASSEXA = tagWNDCLASSEXA;
  {$EXTERNALSYM WNDCLASSEXA}
  NPWNDCLASSEXA = ^WNDCLASSEXA;
  {$EXTERNALSYM NPWNDCLASSEXA}
  TWndClassExA = WNDCLASSEXA;
  PWndClassExA = LPWNDCLASSEXA;

  LPWNDCLASSEXW = ^WNDCLASSEXW;
  {$EXTERNALSYM LPWNDCLASSEXW}
  tagWNDCLASSEXW = record
    cbSize: UINT;
    // Win 3.x
    style: UINT;
    lpfnWndProc: WNDPROC;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    lpszMenuName: LPCWSTR;
    lpszClassName: LPCWSTR;
    // Win 4.0
    hIconSm: HICON;
  end;
  {$EXTERNALSYM tagWNDCLASSEXW}
  WNDCLASSEXW = tagWNDCLASSEXW;
  {$EXTERNALSYM WNDCLASSEXW}
  NPWNDCLASSEXW = ^WNDCLASSEXW;
  {$EXTERNALSYM NPWNDCLASSEXW}
  TWndClassExW = WNDCLASSEXW;
  PWndClassExW = LPWNDCLASSEXW;

  {$IFDEF UNICODE}
  WNDCLASSEX = WNDCLASSEXW;
  {$EXTERNALSYM WNDCLASSEX}
  NPWNDCLASSEX = NPWNDCLASSEXW;
  {$EXTERNALSYM NPWNDCLASSEX}
  LPWNDCLASSEX = LPWNDCLASSEXW;
  {$EXTERNALSYM LPWNDCLASSEX}
  TWndClassEx = TWndClassExW;
  PWndClassEx = PWndClassExW;
  {$ELSE}
  WNDCLASSEX = WNDCLASSEXA;
  {$EXTERNALSYM WNDCLASSEX}
  NPWNDCLASSEX = NPWNDCLASSEXA;
  {$EXTERNALSYM NPWNDCLASSEX}
  LPWNDCLASSEX = LPWNDCLASSEXA;
  {$EXTERNALSYM LPWNDCLASSEX}
  TWndClassEx = TWndClassExA;
  PWndClassEx = PWndClassExA;
  {$ENDIF UNICODE}

  LPWNDCLASSA = ^WNDCLASSA;
  {$EXTERNALSYM LPWNDCLASSA}
  tagWNDCLASSA = record
    style: UINT;
    lpfnWndProc: WNDPROC;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    lpszMenuName: LPCSTR;
    lpszClassName: LPCSTR;
  end;
  {$EXTERNALSYM tagWNDCLASSA}
  WNDCLASSA = tagWNDCLASSA;
  {$EXTERNALSYM WNDCLASSA}
  NPWNDCLASSA = ^WNDCLASSA;
  {$EXTERNALSYM NPWNDCLASSA}
  TWndClassA = WNDCLASSA;
  PWndClassA = LPWNDCLASSA;

  LPWNDCLASSW = ^WNDCLASSW;
  {$EXTERNALSYM LPWNDCLASSW}
  tagWNDCLASSW = record
    style: UINT;
    lpfnWndProc: WNDPROC;
    cbClsExtra: Integer;
    cbWndExtra: Integer;
    hInstance: HINST;
    hIcon: HICON;
    hCursor: HCURSOR;
    hbrBackground: HBRUSH;
    lpszMenuName: LPCWSTR;
    lpszClassName: LPCWSTR;
  end;
  {$EXTERNALSYM tagWNDCLASSW}
  WNDCLASSW = tagWNDCLASSW;
  {$EXTERNALSYM WNDCLASSW}
  NPWNDCLASSW = ^WNDCLASSW;
  {$EXTERNALSYM NPWNDCLASSW}
  TWndClassW = WNDCLASSW;
  PWndClassW = LPWNDCLASSW;

  {$IFDEF UNICODE}
  WNDCLASS = WNDCLASSW;
  {$EXTERNALSYM WNDCLASS}
  NPWNDCLASS = NPWNDCLASSW;
  {$EXTERNALSYM NPWNDCLASS}
  LPWNDCLASS = LPWNDCLASSW;
  {$EXTERNALSYM LPWNDCLASS}
  TWndClass = TWndClassW;
  PWndClass = PWndClassW;
  {$ELSE}
  WNDCLASS = WNDCLASSA;
  {$EXTERNALSYM WNDCLASS}
  NPWNDCLASS = NPWNDCLASSA;
  {$EXTERNALSYM NPWNDCLASS}
  LPWNDCLASS = LPWNDCLASSA;
  {$EXTERNALSYM LPWNDCLASS}
  TWndClass = TWndClassA;
  PWndClass = PWndClassA;
  {$ENDIF UNICODE}

function IsHungAppWindow(hwnd: HWND): BOOL; stdcall;
{$EXTERNALSYM IsHungAppWindow}

procedure DisableProcessWindowsGhosting; stdcall;
{$EXTERNALSYM DisableProcessWindowsGhosting}

//
// Message structure
//

type
  LPMSG = ^MSG;
  {$EXTERNALSYM LPMSG}
  tagMSG = record
    hwnd: HWND;
    message: UINT;
    wParam: WPARAM;
    lParam: LPARAM;
    time: DWORD;
    pt: POINT;
  end;
  {$EXTERNALSYM tagMSG}
  MSG = tagMSG;
  {$EXTERNALSYM MSG}
  NPMSG = ^MSG;
  {$EXTERNALSYM NPMSG}
  TMsg = MSG;
  PMsg = LPMSG;

function MAKEWPARAM(wLow, wHigh: WORD): WPARAM;
{$EXTERNALSYM MAKEWPARAM}

function MAKELPARAM(wLow, wHigh: WORD): LPARAM;
{$EXTERNALSYM MAKELPARAM}

function MAKELRESULT(wLow, wHigh: WORD): LRESULT;
{$EXTERNALSYM MAKELRESULT}

//
// Window field offsets for GetWindowLong()
//

const
  GWL_WNDPROC    = -4;
  {$EXTERNALSYM GWL_WNDPROC}
  GWL_HINSTANCE  = -6;
  {$EXTERNALSYM GWL_HINSTANCE}
  GWL_HWNDPARENT = -8;
  {$EXTERNALSYM GWL_HWNDPARENT}
  GWL_STYLE      = -16;
  {$EXTERNALSYM GWL_STYLE}
  GWL_EXSTYLE    = -20;
  {$EXTERNALSYM GWL_EXSTYLE}
  GWL_USERDATA   = -21;
  {$EXTERNALSYM GWL_USERDATA}
  GWL_ID         = -12;
  {$EXTERNALSYM GWL_ID}

  GWLP_WNDPROC    = -4;
  {$EXTERNALSYM GWLP_WNDPROC}
  GWLP_HINSTANCE  = -6;
  {$EXTERNALSYM GWLP_HINSTANCE}
  GWLP_HWNDPARENT = -8;
  {$EXTERNALSYM GWLP_HWNDPARENT}
  GWLP_USERDATA   = -21;
  {$EXTERNALSYM GWLP_USERDATA}
  GWLP_ID         = -12;
  {$EXTERNALSYM GWLP_ID}

//
// Class field offsets for GetClassLong()
//

  GCL_MENUNAME      = DWORD(-8);
  {$EXTERNALSYM GCL_MENUNAME}
  GCL_HBRBACKGROUND = DWORD(-10);
  {$EXTERNALSYM GCL_HBRBACKGROUND}
  GCL_HCURSOR       = DWORD(-12);
  {$EXTERNALSYM GCL_HCURSOR}
  GCL_HICON         = DWORD(-14);
  {$EXTERNALSYM GCL_HICON}
  GCL_HMODULE       = DWORD(-16);
  {$EXTERNALSYM GCL_HMODULE}
  GCL_CBWNDEXTRA    = DWORD(-18);
  {$EXTERNALSYM GCL_CBWNDEXTRA}
  GCL_CBCLSEXTRA    = DWORD(-20);
  {$EXTERNALSYM GCL_CBCLSEXTRA}
  GCL_WNDPROC       = DWORD(-24);
  {$EXTERNALSYM GCL_WNDPROC}
  GCL_STYLE         = DWORD(-26);
  {$EXTERNALSYM GCL_STYLE}
  GCW_ATOM          = DWORD(-32);
  {$EXTERNALSYM GCW_ATOM}

  GCL_HICONSM = DWORD(-34);
  {$EXTERNALSYM GCL_HICONSM}

  GCLP_MENUNAME      = DWORD(-8);
  {$EXTERNALSYM GCLP_MENUNAME}
  GCLP_HBRBACKGROUND = DWORD(-10);
  {$EXTERNALSYM GCLP_HBRBACKGROUND}
  GCLP_HCURSOR       = DWORD(-12);
  {$EXTERNALSYM GCLP_HCURSOR}
  GCLP_HICON         = DWORD(-14);
  {$EXTERNALSYM GCLP_HICON}
  GCLP_HMODULE       = DWORD(-16);
  {$EXTERNALSYM GCLP_HMODULE}
  GCLP_WNDPROC       = DWORD(-24);
  {$EXTERNALSYM GCLP_WNDPROC}
  GCLP_HICONSM       = DWORD(-34);
  {$EXTERNALSYM GCLP_HICONSM}

//
// Window Messages
//

  WM_NULL    = $0000;
  {$EXTERNALSYM WM_NULL}
  WM_CREATE  = $0001;
  {$EXTERNALSYM WM_CREATE}
  WM_DESTROY = $0002;
  {$EXTERNALSYM WM_DESTROY}
  WM_MOVE    = $0003;
  {$EXTERNALSYM WM_MOVE}
  WM_SIZE    = $0005;
  {$EXTERNALSYM WM_SIZE}

  WM_ACTIVATE = $0006;
  {$EXTERNALSYM WM_ACTIVATE}

//
// WM_ACTIVATE state values
//

  WA_INACTIVE    = 0;
  {$EXTERNALSYM WA_INACTIVE}
  WA_ACTIVE      = 1;
  {$EXTERNALSYM WA_ACTIVE}
  WA_CLICKACTIVE = 2;
  {$EXTERNALSYM WA_CLICKACTIVE}

  WM_SETFOCUS        = $0007;
  {$EXTERNALSYM WM_SETFOCUS}
  WM_KILLFOCUS       = $0008;
  {$EXTERNALSYM WM_KILLFOCUS}
  WM_ENABLE          = $000A;
  {$EXTERNALSYM WM_ENABLE}
  WM_SETREDRAW       = $000B;
  {$EXTERNALSYM WM_SETREDRAW}
  WM_SETTEXT         = $000C;
  {$EXTERNALSYM WM_SETTEXT}
  WM_GETTEXT         = $000D;
  {$EXTERNALSYM WM_GETTEXT}
  WM_GETTEXTLENGTH   = $000E;
  {$EXTERNALSYM WM_GETTEXTLENGTH}
  WM_PAINT           = $000F;
  {$EXTERNALSYM WM_PAINT}
  WM_CLOSE           = $0010;
  {$EXTERNALSYM WM_CLOSE}
  WM_QUERYENDSESSION = $0011;
  {$EXTERNALSYM WM_QUERYENDSESSION}
  WM_QUERYOPEN       = $0013;
  {$EXTERNALSYM WM_QUERYOPEN}
  WM_ENDSESSION      = $0016;
  {$EXTERNALSYM WM_ENDSESSION}
  WM_QUIT            = $0012;
  {$EXTERNALSYM WM_QUIT}
  WM_ERASEBKGND      = $0014;
  {$EXTERNALSYM WM_ERASEBKGND}
  WM_SYSCOLORCHANGE  = $0015;
  {$EXTERNALSYM WM_SYSCOLORCHANGE}
  WM_SHOWWINDOW      = $0018;
  {$EXTERNALSYM WM_SHOWWINDOW}
  WM_WININICHANGE    = $001A;
  {$EXTERNALSYM WM_WININICHANGE}
  WM_SETTINGCHANGE   = WM_WININICHANGE;
  {$EXTERNALSYM WM_SETTINGCHANGE}

  WM_DEVMODECHANGE = $001B;
  {$EXTERNALSYM WM_DEVMODECHANGE}
  WM_ACTIVATEAPP   = $001C;
  {$EXTERNALSYM WM_ACTIVATEAPP}
  WM_FONTCHANGE    = $001D;
  {$EXTERNALSYM WM_FONTCHANGE}
  WM_TIMECHANGE    = $001E;
  {$EXTERNALSYM WM_TIMECHANGE}
  WM_CANCELMODE    = $001F;
  {$EXTERNALSYM WM_CANCELMODE}
  WM_SETCURSOR     = $0020;
  {$EXTERNALSYM WM_SETCURSOR}
  WM_MOUSEACTIVATE = $0021;
  {$EXTERNALSYM WM_MOUSEACTIVATE}
  WM_CHILDACTIVATE = $0022;
  {$EXTERNALSYM WM_CHILDACTIVATE}
  WM_QUEUESYNC     = $0023;
  {$EXTERNALSYM WM_QUEUESYNC}

  WM_GETMINMAXINFO = $0024;
  {$EXTERNALSYM WM_GETMINMAXINFO}

//
// Struct pointed to by WM_GETMINMAXINFO lParam
//

type
  LPMINMAXINFO = ^MINMAXINFO;
  {$EXTERNALSYM LPMINMAXINFO}
  tagMINMAXINFO = record
    ptReserved: POINT;
    ptMaxSize: POINT;
    ptMaxPosition: POINT;
    ptMinTrackSize: POINT;
    ptMaxTrackSize: POINT;
  end;
  {$EXTERNALSYM tagMINMAXINFO}
  MINMAXINFO = tagMINMAXINFO;
  {$EXTERNALSYM MINMAXINFO}
  TMinMaxInfo = MINMAXINFO;
  PMinMaxInfo = LPMINMAXINFO;

const
  WM_PAINTICON         = $0026;
  {$EXTERNALSYM WM_PAINTICON}
  WM_ICONERASEBKGND    = $0027;
  {$EXTERNALSYM WM_ICONERASEBKGND}
  WM_NEXTDLGCTL        = $0028;
  {$EXTERNALSYM WM_NEXTDLGCTL}
  WM_SPOOLERSTATUS     = $002A;
  {$EXTERNALSYM WM_SPOOLERSTATUS}
  WM_DRAWITEM          = $002B;
  {$EXTERNALSYM WM_DRAWITEM}
  WM_MEASUREITEM       = $002C;
  {$EXTERNALSYM WM_MEASUREITEM}
  WM_DELETEITEM        = $002D;
  {$EXTERNALSYM WM_DELETEITEM}
  WM_VKEYTOITEM        = $002E;
  {$EXTERNALSYM WM_VKEYTOITEM}
  WM_CHARTOITEM        = $002F;
  {$EXTERNALSYM WM_CHARTOITEM}
  WM_SETFONT           = $0030;
  {$EXTERNALSYM WM_SETFONT}
  WM_GETFONT           = $0031;
  {$EXTERNALSYM WM_GETFONT}
  WM_SETHOTKEY         = $0032;
  {$EXTERNALSYM WM_SETHOTKEY}
  WM_GETHOTKEY         = $0033;
  {$EXTERNALSYM WM_GETHOTKEY}
  WM_QUERYDRAGICON     = $0037;
  {$EXTERNALSYM WM_QUERYDRAGICON}
  WM_COMPAREITEM       = $0039;
  {$EXTERNALSYM WM_COMPAREITEM}
  WM_GETOBJECT         = $003D;
  {$EXTERNALSYM WM_GETOBJECT}
  WM_COMPACTING        = $0041;
  {$EXTERNALSYM WM_COMPACTING}
  WM_COMMNOTIFY        = $0044; // no longer suported
  {$EXTERNALSYM WM_COMMNOTIFY}
  WM_WINDOWPOSCHANGING = $0046;
  {$EXTERNALSYM WM_WINDOWPOSCHANGING}
  WM_WINDOWPOSCHANGED  = $0047;
  {$EXTERNALSYM WM_WINDOWPOSCHANGED}

  WM_POWER = $0048;
  {$EXTERNALSYM WM_POWER}

//
// wParam for WM_POWER window message and DRV_POWER driver notification
//

  PWR_OK             = 1;
  {$EXTERNALSYM PWR_OK}
  PWR_FAIL           = DWORD(-1);
  {$EXTERNALSYM PWR_FAIL}
  PWR_SUSPENDREQUEST = 1;
  {$EXTERNALSYM PWR_SUSPENDREQUEST}
  PWR_SUSPENDRESUME  = 2;
  {$EXTERNALSYM PWR_SUSPENDRESUME}
  PWR_CRITICALRESUME = 3;
  {$EXTERNALSYM PWR_CRITICALRESUME}

  WM_COPYDATA      = $004A;
  {$EXTERNALSYM WM_COPYDATA}
  WM_CANCELJOURNAL = $004B;
  {$EXTERNALSYM WM_CANCELJOURNAL}

//
// lParam of WM_COPYDATA message points to...
//

type
  PCOPYDATASTRUCT = ^COPYDATASTRUCT;
  tagCOPYDATASTRUCT = record
    dwData: ULONG_PTR;
    cbData: DWORD;
    lpData: PVOID;
  end;
  {$EXTERNALSYM tagCOPYDATASTRUCT}
  COPYDATASTRUCT = tagCOPYDATASTRUCT;
  {$EXTERNALSYM COPYDATASTRUCT}
  TCopyDataStruct = COPYDATASTRUCT;

  LPMDINEXTMENU = ^MDINEXTMENU;
  {$EXTERNALSYM LPMDINEXTMENU}
  tagMDINEXTMENU = record
    hmenuIn: HMENU;
    hmenuNext: HMENU;
    hwndNext: HWND;
  end;
  {$EXTERNALSYM tagMDINEXTMENU}
  MDINEXTMENU = tagMDINEXTMENU;
  {$EXTERNALSYM MDINEXTMENU}
  TMdiNextMenu = MDINEXTMENU;
  PMdiNextMenu = LPMDINEXTMENU;

const
  WM_NOTIFY                 = $004E;
  {$EXTERNALSYM WM_NOTIFY}
  WM_INPUTLANGCHANGEREQUEST = $0050;
  {$EXTERNALSYM WM_INPUTLANGCHANGEREQUEST}
  WM_INPUTLANGCHANGE        = $0051;
  {$EXTERNALSYM WM_INPUTLANGCHANGE}
  WM_TCARD                  = $0052;
  {$EXTERNALSYM WM_TCARD}
  WM_HELP                   = $0053;
  {$EXTERNALSYM WM_HELP}
  WM_USERCHANGED            = $0054;
  {$EXTERNALSYM WM_USERCHANGED}
  WM_NOTIFYFORMAT           = $0055;
  {$EXTERNALSYM WM_NOTIFYFORMAT}

  NFR_ANSI    = 1;
  {$EXTERNALSYM NFR_ANSI}
  NFR_UNICODE = 2;
  {$EXTERNALSYM NFR_UNICODE}
  NF_QUERY    = 3;
  {$EXTERNALSYM NF_QUERY}
  NF_REQUERY  = 4;
  {$EXTERNALSYM NF_REQUERY}

  WM_CONTEXTMENU   = $007B;
  {$EXTERNALSYM WM_CONTEXTMENU}
  WM_STYLECHANGING = $007C;
  {$EXTERNALSYM WM_STYLECHANGING}
  WM_STYLECHANGED  = $007D;
  {$EXTERNALSYM WM_STYLECHANGED}
  WM_DISPLAYCHANGE = $007E;
  {$EXTERNALSYM WM_DISPLAYCHANGE}
  WM_GETICON       = $007F;
  {$EXTERNALSYM WM_GETICON}
  WM_SETICON       = $0080;
  {$EXTERNALSYM WM_SETICON}

  WM_NCCREATE        = $0081;
  {$EXTERNALSYM WM_NCCREATE}
  WM_NCDESTROY       = $0082;
  {$EXTERNALSYM WM_NCDESTROY}
  WM_NCCALCSIZE      = $0083;
  {$EXTERNALSYM WM_NCCALCSIZE}
  WM_NCHITTEST       = $0084;
  {$EXTERNALSYM WM_NCHITTEST}
  WM_NCPAINT         = $0085;
  {$EXTERNALSYM WM_NCPAINT}
  WM_NCACTIVATE      = $0086;
  {$EXTERNALSYM WM_NCACTIVATE}
  WM_GETDLGCODE      = $0087;
  {$EXTERNALSYM WM_GETDLGCODE}
  WM_SYNCPAINT       = $0088;
  {$EXTERNALSYM WM_SYNCPAINT}
  WM_NCMOUSEMOVE     = $00A0;
  {$EXTERNALSYM WM_NCMOUSEMOVE}
  WM_NCLBUTTONDOWN   = $00A1;
  {$EXTERNALSYM WM_NCLBUTTONDOWN}
  WM_NCLBUTTONUP     = $00A2;
  {$EXTERNALSYM WM_NCLBUTTONUP}
  WM_NCLBUTTONDBLCLK = $00A3;
  {$EXTERNALSYM WM_NCLBUTTONDBLCLK}
  WM_NCRBUTTONDOWN   = $00A4;
  {$EXTERNALSYM WM_NCRBUTTONDOWN}
  WM_NCRBUTTONUP     = $00A5;
  {$EXTERNALSYM WM_NCRBUTTONUP}
  WM_NCRBUTTONDBLCLK = $00A6;
  {$EXTERNALSYM WM_NCRBUTTONDBLCLK}
  WM_NCMBUTTONDOWN   = $00A7;
  {$EXTERNALSYM WM_NCMBUTTONDOWN}
  WM_NCMBUTTONUP     = $00A8;
  {$EXTERNALSYM WM_NCMBUTTONUP}
  WM_NCMBUTTONDBLCLK = $00A9;
  {$EXTERNALSYM WM_NCMBUTTONDBLCLK}

  WM_NCXBUTTONDOWN   = $00AB;
  {$EXTERNALSYM WM_NCXBUTTONDOWN}
  WM_NCXBUTTONUP     = $00AC;
  {$EXTERNALSYM WM_NCXBUTTONUP}
  WM_NCXBUTTONDBLCLK = $00AD;
  {$EXTERNALSYM WM_NCXBUTTONDBLCLK}

  WM_INPUT           = $00FF;
  {$EXTERNALSYM WM_INPUT}

  WM_KEYFIRST    = $0100;
  {$EXTERNALSYM WM_KEYFIRST}
  WM_KEYDOWN     = $0100;
  {$EXTERNALSYM WM_KEYDOWN}
  WM_KEYUP       = $0101;
  {$EXTERNALSYM WM_KEYUP}
  WM_CHAR        = $0102;
  {$EXTERNALSYM WM_CHAR}
  WM_DEADCHAR    = $0103;
  {$EXTERNALSYM WM_DEADCHAR}
  WM_SYSKEYDOWN  = $0104;
  {$EXTERNALSYM WM_SYSKEYDOWN}
  WM_SYSKEYUP    = $0105;
  {$EXTERNALSYM WM_SYSKEYUP}
  WM_SYSCHAR     = $0106;
  {$EXTERNALSYM WM_SYSCHAR}
  WM_SYSDEADCHAR = $0107;
  {$EXTERNALSYM WM_SYSDEADCHAR}
  {$IFDEF WINXP_UP}
  WM_UNICHAR     = $0109;
  {$EXTERNALSYM WM_UNICHAR}
  WM_KEYLAST     = $0109;
  {$EXTERNALSYM WM_KEYLAST}
  UNICODE_NOCHAR = $FFFF;
  {$EXTERNALSYM UNICODE_NOCHAR}
  {$ELSE}
  WM_KEYLAST     = $0108;
  {$EXTERNALSYM WM_KEYLAST}
  {$ENDIF WINXP_UP}

  WM_IME_STARTCOMPOSITION = $010D;
  {$EXTERNALSYM WM_IME_STARTCOMPOSITION}
  WM_IME_ENDCOMPOSITION   = $010E;
  {$EXTERNALSYM WM_IME_ENDCOMPOSITION}
  WM_IME_COMPOSITION      = $010F;
  {$EXTERNALSYM WM_IME_COMPOSITION}
  WM_IME_KEYLAST          = $010F;
  {$EXTERNALSYM WM_IME_KEYLAST}

  WM_INITDIALOG      = $0110;
  {$EXTERNALSYM WM_INITDIALOG}
  WM_COMMAND         = $0111;
  {$EXTERNALSYM WM_COMMAND}
  WM_SYSCOMMAND      = $0112;
  {$EXTERNALSYM WM_SYSCOMMAND}
  WM_TIMER           = $0113;
  {$EXTERNALSYM WM_TIMER}
  WM_HSCROLL         = $0114;
  {$EXTERNALSYM WM_HSCROLL}
  WM_VSCROLL         = $0115;
  {$EXTERNALSYM WM_VSCROLL}
  WM_INITMENU        = $0116;
  {$EXTERNALSYM WM_INITMENU}
  WM_INITMENUPOPUP   = $0117;
  {$EXTERNALSYM WM_INITMENUPOPUP}
  WM_MENUSELECT      = $011F;
  {$EXTERNALSYM WM_MENUSELECT}
  WM_MENUCHAR        = $0120;
  {$EXTERNALSYM WM_MENUCHAR}
  WM_ENTERIDLE       = $0121;
  {$EXTERNALSYM WM_ENTERIDLE}
  WM_MENURBUTTONUP   = $0122;
  {$EXTERNALSYM WM_MENURBUTTONUP}
  WM_MENUDRAG        = $0123;
  {$EXTERNALSYM WM_MENUDRAG}
  WM_MENUGETOBJECT   = $0124;
  {$EXTERNALSYM WM_MENUGETOBJECT}
  WM_UNINITMENUPOPUP = $0125;
  {$EXTERNALSYM WM_UNINITMENUPOPUP}
  WM_MENUCOMMAND     = $0126;
  {$EXTERNALSYM WM_MENUCOMMAND}

  WM_CHANGEUISTATE = $0127;
  {$EXTERNALSYM WM_CHANGEUISTATE}
  WM_UPDATEUISTATE = $0128;
  {$EXTERNALSYM WM_UPDATEUISTATE}
  WM_QUERYUISTATE  = $0129;
  {$EXTERNALSYM WM_QUERYUISTATE}

//
// LOWORD(wParam) values in WM_*UISTATE*
//

  UIS_SET        = 1;
  {$EXTERNALSYM UIS_SET}
  UIS_CLEAR      = 2;
  {$EXTERNALSYM UIS_CLEAR}
  UIS_INITIALIZE = 3;
  {$EXTERNALSYM UIS_INITIALIZE}

//
// HIWORD(wParam) values in WM_*UISTATE*
//

  UISF_HIDEFOCUS = $1;
  {$EXTERNALSYM UISF_HIDEFOCUS}
  UISF_HIDEACCEL = $2;
  {$EXTERNALSYM UISF_HIDEACCEL}
  UISF_ACTIVE    = $4;
  {$EXTERNALSYM UISF_ACTIVE}

  WM_CTLCOLORMSGBOX    = $0132;
  {$EXTERNALSYM WM_CTLCOLORMSGBOX}
  WM_CTLCOLOREDIT      = $0133;
  {$EXTERNALSYM WM_CTLCOLOREDIT}
  WM_CTLCOLORLISTBOX   = $0134;
  {$EXTERNALSYM WM_CTLCOLORLISTBOX}
  WM_CTLCOLORBTN       = $0135;
  {$EXTERNALSYM WM_CTLCOLORBTN}
  WM_CTLCOLORDLG       = $0136;
  {$EXTERNALSYM WM_CTLCOLORDLG}
  WM_CTLCOLORSCROLLBAR = $0137;
  {$EXTERNALSYM WM_CTLCOLORSCROLLBAR}
  WM_CTLCOLORSTATIC    = $0138;
  {$EXTERNALSYM WM_CTLCOLORSTATIC}
  MN_GETHMENU          = $01E1;
  {$EXTERNALSYM MN_GETHMENU}

  WM_MOUSEFIRST    = $0200;
  {$EXTERNALSYM WM_MOUSEFIRST}
  WM_MOUSEMOVE     = $0200;
  {$EXTERNALSYM WM_MOUSEMOVE}
  WM_LBUTTONDOWN   = $0201;
  {$EXTERNALSYM WM_LBUTTONDOWN}
  WM_LBUTTONUP     = $0202;
  {$EXTERNALSYM WM_LBUTTONUP}
  WM_LBUTTONDBLCLK = $0203;
  {$EXTERNALSYM WM_LBUTTONDBLCLK}
  WM_RBUTTONDOWN   = $0204;
  {$EXTERNALSYM WM_RBUTTONDOWN}
  WM_RBUTTONUP     = $0205;
  {$EXTERNALSYM WM_RBUTTONUP}
  WM_RBUTTONDBLCLK = $0206;
  {$EXTERNALSYM WM_RBUTTONDBLCLK}
  WM_MBUTTONDOWN   = $0207;
  {$EXTERNALSYM WM_MBUTTONDOWN}
  WM_MBUTTONUP     = $0208;
  {$EXTERNALSYM WM_MBUTTONUP}
  WM_MBUTTONDBLCLK = $0209;
  {$EXTERNALSYM WM_MBUTTONDBLCLK}
  WM_MOUSEWHEEL    = $020A;
  {$EXTERNALSYM WM_MOUSEWHEEL}
  WM_XBUTTONDOWN   = $020B;
  {$EXTERNALSYM WM_XBUTTONDOWN}
  WM_XBUTTONUP     = $020C;
  {$EXTERNALSYM WM_XBUTTONUP}
  WM_XBUTTONDBLCLK = $020D;
  {$EXTERNALSYM WM_XBUTTONDBLCLK}

  {$IFDEF WIN2000_UP}
  WM_MOUSELAST = $020D;
  {$EXTERNALSYM WM_MOUSELAST}
  {$ELSE}
  {$IFDEF WINNT4}
  WM_MOUSELAST = $020A;
  {$EXTERNALSYM WM_MOUSELAST}
  {$ELSE}
  {$IFDEF WIN95_UP}
  WM_MOUSELAST = $020A;
  {$EXTERNALSYM WM_MOUSELAST}
  {$ELSE}
  WM_MOUSELAST = $0209;
  {$EXTERNALSYM WM_MOUSELAST}
  {$ENDIF WIN95_UP}
  {$ENDIF WINNT4}
  {$ENDIF WIN2000_UP}

// Value for rolling one detent//

  WHEEL_DELTA                    = 120;
  {$EXTERNALSYM WHEEL_DELTA}

function GET_WHEEL_DELTA_WPARAM(wParam: WPARAM): SHORT;
{$EXTERNALSYM GET_WHEEL_DELTA_WPARAM(wParam)}

// Setting to scroll one page for SPI_GET/SETWHEELSCROLLLINES//

const
  WHEEL_PAGESCROLL = UINT_MAX;
  {$EXTERNALSYM WHEEL_PAGESCROLL}

function GET_KEYSTATE_WPARAM(wParam: WPARAM): Integer;
{$EXTERNALSYM GET_KEYSTATE_WPARAM}
function GET_NCHITTEST_WPARAM(wParam: WPARAM): Shortint;
{$EXTERNALSYM GET_NCHITTEST_WPARAM}
function GET_XBUTTON_WPARAM(wParam: WPARAM): Integer;
{$EXTERNALSYM GET_XBUTTON_WPARAM}

// XButton values are WORD flags//

const
  XBUTTON1 = $0001;
  {$EXTERNALSYM XBUTTON1}
  XBUTTON2 = $0002;
  {$EXTERNALSYM XBUTTON2}

// Were there to be an XBUTTON3, it's value would be 0x0004//

  WM_PARENTNOTIFY  = $0210;
  {$EXTERNALSYM WM_PARENTNOTIFY}
  WM_ENTERMENULOOP = $0211;
  {$EXTERNALSYM WM_ENTERMENULOOP}
  WM_EXITMENULOOP  = $0212;
  {$EXTERNALSYM WM_EXITMENULOOP}

  WM_NEXTMENU       = $0213;
  {$EXTERNALSYM WM_NEXTMENU}
  WM_SIZING         = $0214;
  {$EXTERNALSYM WM_SIZING}
  WM_CAPTURECHANGED = $0215;
  {$EXTERNALSYM WM_CAPTURECHANGED}
  WM_MOVING         = $0216;
  {$EXTERNALSYM WM_MOVING}

  WM_POWERBROADCAST = $0218;
  {$EXTERNALSYM WM_POWERBROADCAST}

  PBT_APMQUERYSUSPEND = $0000;
  {$EXTERNALSYM PBT_APMQUERYSUSPEND}
  PBT_APMQUERYSTANDBY = $0001;
  {$EXTERNALSYM PBT_APMQUERYSTANDBY}

  PBT_APMQUERYSUSPENDFAILED = $0002;
  {$EXTERNALSYM PBT_APMQUERYSUSPENDFAILED}
  PBT_APMQUERYSTANDBYFAILED = $0003;
  {$EXTERNALSYM PBT_APMQUERYSTANDBYFAILED}

  PBT_APMSUSPEND = $0004;
  {$EXTERNALSYM PBT_APMSUSPEND}
  PBT_APMSTANDBY = $0005;
  {$EXTERNALSYM PBT_APMSTANDBY}

  PBT_APMRESUMECRITICAL = $0006;
  {$EXTERNALSYM PBT_APMRESUMECRITICAL}
  PBT_APMRESUMESUSPEND  = $0007;
  {$EXTERNALSYM PBT_APMRESUMESUSPEND}
  PBT_APMRESUMESTANDBY  = $0008;
  {$EXTERNALSYM PBT_APMRESUMESTANDBY}

  PBTF_APMRESUMEFROMFAILURE = $00000001;
  {$EXTERNALSYM PBTF_APMRESUMEFROMFAILURE}

  PBT_APMBATTERYLOW        = $0009;
  {$EXTERNALSYM PBT_APMBATTERYLOW}
  PBT_APMPOWERSTATUSCHANGE = $000A;
  {$EXTERNALSYM PBT_APMPOWERSTATUSCHANGE}

  PBT_APMOEMEVENT = $000B;
  {$EXTERNALSYM PBT_APMOEMEVENT}
  PBT_APMRESUMEAUTOMATIC = $0012;
  {$EXTERNALSYM PBT_APMRESUMEAUTOMATIC}

  WM_DEVICECHANGE = $0219;
  {$EXTERNALSYM WM_DEVICECHANGE}

  WM_MDICREATE      = $0220;
  {$EXTERNALSYM WM_MDICREATE}
  WM_MDIDESTROY     = $0221;
  {$EXTERNALSYM WM_MDIDESTROY}
  WM_MDIACTIVATE    = $0222;
  {$EXTERNALSYM WM_MDIACTIVATE}
  WM_MDIRESTORE     = $0223;
  {$EXTERNALSYM WM_MDIRESTORE}
  WM_MDINEXT        = $0224;
  {$EXTERNALSYM WM_MDINEXT}
  WM_MDIMAXIMIZE    = $0225;
  {$EXTERNALSYM WM_MDIMAXIMIZE}
  WM_MDITILE        = $0226;
  {$EXTERNALSYM WM_MDITILE}
  WM_MDICASCADE     = $0227;
  {$EXTERNALSYM WM_MDICASCADE}
  WM_MDIICONARRANGE = $0228;
  {$EXTERNALSYM WM_MDIICONARRANGE}
  WM_MDIGETACTIVE   = $0229;
  {$EXTERNALSYM WM_MDIGETACTIVE}

  WM_MDISETMENU     = $0230;
  {$EXTERNALSYM WM_MDISETMENU}
  WM_ENTERSIZEMOVE  = $0231;
  {$EXTERNALSYM WM_ENTERSIZEMOVE}
  WM_EXITSIZEMOVE   = $0232;
  {$EXTERNALSYM WM_EXITSIZEMOVE}
  WM_DROPFILES      = $0233;
  {$EXTERNALSYM WM_DROPFILES}
  WM_MDIREFRESHMENU = $0234;
  {$EXTERNALSYM WM_MDIREFRESHMENU}

  WM_IME_SETCONTEXT      = $0281;
  {$EXTERNALSYM WM_IME_SETCONTEXT}
  WM_IME_NOTIFY          = $0282;
  {$EXTERNALSYM WM_IME_NOTIFY}
  WM_IME_CONTROL         = $0283;
  {$EXTERNALSYM WM_IME_CONTROL}
  WM_IME_COMPOSITIONFULL = $0284;
  {$EXTERNALSYM WM_IME_COMPOSITIONFULL}
  WM_IME_SELECT          = $0285;
  {$EXTERNALSYM WM_IME_SELECT}
  WM_IME_CHAR            = $0286;
  {$EXTERNALSYM WM_IME_CHAR}
  WM_IME_REQUEST         = $0288;
  {$EXTERNALSYM WM_IME_REQUEST}
  WM_IME_KEYDOWN         = $0290;
  {$EXTERNALSYM WM_IME_KEYDOWN}
  WM_IME_KEYUP           = $0291;
  {$EXTERNALSYM WM_IME_KEYUP}

  WM_MOUSEHOVER   = $02A1;
  {$EXTERNALSYM WM_MOUSEHOVER}
  WM_MOUSELEAVE   = $02A3;
  {$EXTERNALSYM WM_MOUSELEAVE}
  WM_NCMOUSEHOVER = $02A0;
  {$EXTERNALSYM WM_NCMOUSEHOVER}
  WM_NCMOUSELEAVE = $02A2;
  {$EXTERNALSYM WM_NCMOUSELEAVE}

  WM_WTSSESSION_CHANGE = $02B1;
  {$EXTERNALSYM WM_WTSSESSION_CHANGE}

  WM_TABLET_FIRST      = $02c0;
  {$EXTERNALSYM WM_TABLET_FIRST}
  WM_TABLET_LAST       = $02df;
  {$EXTERNALSYM WM_TABLET_LAST}

  WM_CUT               = $0300;
  {$EXTERNALSYM WM_CUT}
  WM_COPY              = $0301;
  {$EXTERNALSYM WM_COPY}
  WM_PASTE             = $0302;
  {$EXTERNALSYM WM_PASTE}
  WM_CLEAR             = $0303;
  {$EXTERNALSYM WM_CLEAR}
  WM_UNDO              = $0304;
  {$EXTERNALSYM WM_UNDO}
  WM_RENDERFORMAT      = $0305;
  {$EXTERNALSYM WM_RENDERFORMAT}
  WM_RENDERALLFORMATS  = $0306;
  {$EXTERNALSYM WM_RENDERALLFORMATS}
  WM_DESTROYCLIPBOARD  = $0307;
  {$EXTERNALSYM WM_DESTROYCLIPBOARD}
  WM_DRAWCLIPBOARD     = $0308;
  {$EXTERNALSYM WM_DRAWCLIPBOARD}
  WM_PAINTCLIPBOARD    = $0309;
  {$EXTERNALSYM WM_PAINTCLIPBOARD}
  WM_VSCROLLCLIPBOARD  = $030A;
  {$EXTERNALSYM WM_VSCROLLCLIPBOARD}
  WM_SIZECLIPBOARD     = $030B;
  {$EXTERNALSYM WM_SIZECLIPBOARD}
  WM_ASKCBFORMATNAME   = $030C;
  {$EXTERNALSYM WM_ASKCBFORMATNAME}
  WM_CHANGECBCHAIN     = $030D;
  {$EXTERNALSYM WM_CHANGECBCHAIN}
  WM_HSCROLLCLIPBOARD  = $030E;
  {$EXTERNALSYM WM_HSCROLLCLIPBOARD}
  WM_QUERYNEWPALETTE   = $030F;
  {$EXTERNALSYM WM_QUERYNEWPALETTE}
  WM_PALETTEISCHANGING = $0310;
  {$EXTERNALSYM WM_PALETTEISCHANGING}
  WM_PALETTECHANGED    = $0311;
  {$EXTERNALSYM WM_PALETTECHANGED}
  WM_HOTKEY            = $0312;
  {$EXTERNALSYM WM_HOTKEY}

  WM_PRINT       = $0317;
  {$EXTERNALSYM WM_PRINT}
  WM_PRINTCLIENT = $0318;
  {$EXTERNALSYM WM_PRINTCLIENT}

  WM_APPCOMMAND = $0319;
  {$EXTERNALSYM WM_APPCOMMAND}

  WM_THEMECHANGED  = $031A;
  {$EXTERNALSYM WM_THEMECHANGED}

  WM_HANDHELDFIRST = $0358;
  {$EXTERNALSYM WM_HANDHELDFIRST}
  WM_HANDHELDLAST  = $035F;
  {$EXTERNALSYM WM_HANDHELDLAST}

  WM_AFXFIRST = $0360;
  {$EXTERNALSYM WM_AFXFIRST}
  WM_AFXLAST  = $037F;
  {$EXTERNALSYM WM_AFXLAST}

  WM_PENWINFIRST = $0380;
  {$EXTERNALSYM WM_PENWINFIRST}
  WM_PENWINLAST  = $038F;
  {$EXTERNALSYM WM_PENWINLAST}

  WM_APP = $8000;
  {$EXTERNALSYM WM_APP}

//
// NOTE: All Message Numbers below 0x0400 are RESERVED.
//
// Private Window Messages Start Here:
//

  WM_USER = $0400;
  {$EXTERNALSYM WM_USER}

//  wParam for WM_SIZING message

  WMSZ_LEFT        = 1;
  {$EXTERNALSYM WMSZ_LEFT}
  WMSZ_RIGHT       = 2;
  {$EXTERNALSYM WMSZ_RIGHT}
  WMSZ_TOP         = 3;
  {$EXTERNALSYM WMSZ_TOP}
  WMSZ_TOPLEFT     = 4;
  {$EXTERNALSYM WMSZ_TOPLEFT}
  WMSZ_TOPRIGHT    = 5;
  {$EXTERNALSYM WMSZ_TOPRIGHT}
  WMSZ_BOTTOM      = 6;
  {$EXTERNALSYM WMSZ_BOTTOM}
  WMSZ_BOTTOMLEFT  = 7;
  {$EXTERNALSYM WMSZ_BOTTOMLEFT}
  WMSZ_BOTTOMRIGHT = 8;
  {$EXTERNALSYM WMSZ_BOTTOMRIGHT}

//
// WM_NCHITTEST and MOUSEHOOKSTRUCT Mouse Position Codes
//

  HTERROR       = DWORD(-2);
  {$EXTERNALSYM HTERROR}
  HTTRANSPARENT = DWORD(-1);
  {$EXTERNALSYM HTTRANSPARENT}
  HTNOWHERE     = 0;
  {$EXTERNALSYM HTNOWHERE}
  HTCLIENT      = 1;
  {$EXTERNALSYM HTCLIENT}
  HTCAPTION     = 2;
  {$EXTERNALSYM HTCAPTION}
  HTSYSMENU     = 3;
  {$EXTERNALSYM HTSYSMENU}
  HTGROWBOX     = 4;
  {$EXTERNALSYM HTGROWBOX}
  HTSIZE        = HTGROWBOX;
  {$EXTERNALSYM HTSIZE}
  HTMENU        = 5;
  {$EXTERNALSYM HTMENU}
  HTHSCROLL     = 6;
  {$EXTERNALSYM HTHSCROLL}
  HTVSCROLL     = 7;
  {$EXTERNALSYM HTVSCROLL}
  HTMINBUTTON   = 8;
  {$EXTERNALSYM HTMINBUTTON}
  HTMAXBUTTON   = 9;
  {$EXTERNALSYM HTMAXBUTTON}
  HTLEFT        = 10;
  {$EXTERNALSYM HTLEFT}
  HTRIGHT       = 11;
  {$EXTERNALSYM HTRIGHT}
  HTTOP         = 12;
  {$EXTERNALSYM HTTOP}
  HTTOPLEFT     = 13;
  {$EXTERNALSYM HTTOPLEFT}
  HTTOPRIGHT    = 14;
  {$EXTERNALSYM HTTOPRIGHT}
  HTBOTTOM      = 15;
  {$EXTERNALSYM HTBOTTOM}
  HTBOTTOMLEFT  = 16;
  {$EXTERNALSYM HTBOTTOMLEFT}
  HTBOTTOMRIGHT = 17;
  {$EXTERNALSYM HTBOTTOMRIGHT}
  HTBORDER      = 18;
  {$EXTERNALSYM HTBORDER}
  HTREDUCE      = HTMINBUTTON;
  {$EXTERNALSYM HTREDUCE}
  HTZOOM        = HTMAXBUTTON;
  {$EXTERNALSYM HTZOOM}
  HTSIZEFIRST   = HTLEFT;
  {$EXTERNALSYM HTSIZEFIRST}
  HTSIZELAST    = HTBOTTOMRIGHT;
  {$EXTERNALSYM HTSIZELAST}
  HTOBJECT      = 19;
  {$EXTERNALSYM HTOBJECT}
  HTCLOSE       = 20;
  {$EXTERNALSYM HTCLOSE}
  HTHELP        = 21;
  {$EXTERNALSYM HTHELP}

//
// SendMessageTimeout values
//

  SMTO_NORMAL             = $0000;
  {$EXTERNALSYM SMTO_NORMAL}
  SMTO_BLOCK              = $0001;
  {$EXTERNALSYM SMTO_BLOCK}
  SMTO_ABORTIFHUNG        = $0002;
  {$EXTERNALSYM SMTO_ABORTIFHUNG}
  SMTO_NOTIMEOUTIFNOTHUNG = $0008;
  {$EXTERNALSYM SMTO_NOTIMEOUTIFNOTHUNG}

//
// WM_MOUSEACTIVATE Return Codes
//

  MA_ACTIVATE         = 1;
  {$EXTERNALSYM MA_ACTIVATE}
  MA_ACTIVATEANDEAT   = 2;
  {$EXTERNALSYM MA_ACTIVATEANDEAT}
  MA_NOACTIVATE       = 3;
  {$EXTERNALSYM MA_NOACTIVATE}
  MA_NOACTIVATEANDEAT = 4;
  {$EXTERNALSYM MA_NOACTIVATEANDEAT}

//
// WM_SETICON / WM_GETICON Type Codes
//

  ICON_SMALL  = 0;
  {$EXTERNALSYM ICON_SMALL}
  ICON_BIG    = 1;
  {$EXTERNALSYM ICON_BIG}
  ICON_SMALL2 = 2;
  {$EXTERNALSYM ICON_SMALL2}

function RegisterWindowMessageA(lpString: LPCSTR): UINT; stdcall;
{$EXTERNALSYM RegisterWindowMessageA}
function RegisterWindowMessageW(lpString: LPCWSTR): UINT; stdcall;
{$EXTERNALSYM RegisterWindowMessageW}
function RegisterWindowMessage(lpString: LPCTSTR): UINT; stdcall;
{$EXTERNALSYM RegisterWindowMessage}

//
// WM_SIZE message wParam values
//

const
  SIZE_RESTORED  = 0;
  {$EXTERNALSYM SIZE_RESTORED}
  SIZE_MINIMIZED = 1;
  {$EXTERNALSYM SIZE_MINIMIZED}
  SIZE_MAXIMIZED = 2;
  {$EXTERNALSYM SIZE_MAXIMIZED}
  SIZE_MAXSHOW   = 3;
  {$EXTERNALSYM SIZE_MAXSHOW}
  SIZE_MAXHIDE   = 4;
  {$EXTERNALSYM SIZE_MAXHIDE}

//
// Obsolete constant names
//

  SIZENORMAL     = SIZE_RESTORED;
  {$EXTERNALSYM SIZENORMAL}
  SIZEICONIC     = SIZE_MINIMIZED;
  {$EXTERNALSYM SIZEICONIC}
  SIZEFULLSCREEN = SIZE_MAXIMIZED;
  {$EXTERNALSYM SIZEFULLSCREEN}
  SIZEZOOMSHOW   = SIZE_MAXSHOW;
  {$EXTERNALSYM SIZEZOOMSHOW}
  SIZEZOOMHIDE   = SIZE_MAXHIDE;
  {$EXTERNALSYM SIZEZOOMHIDE}

//
// WM_WINDOWPOSCHANGING/CHANGED struct pointed to by lParam
//

type
  LPWINDOWPOS = ^WINDOWPOS;
  {$EXTERNALSYM LPWINDOWPOS}
  tagWINDOWPOS = record
    hwnd: HWND;
    hwndInsertAfter: HWND;
    x: Integer;
    y: Integer;
    cx: Integer;
    cy: Integer;
    flags: UINT;
  end;
  {$EXTERNALSYM tagWINDOWPOS}
  WINDOWPOS = tagWINDOWPOS;
  {$EXTERNALSYM WINDOWPOS}
  TWindowPos = WINDOWPOS;
  PWindowPos = LPWINDOWPOS;

//
// WM_NCCALCSIZE parameter structure
//

  LPNCCALCSIZE_PARAMS = ^NCCALCSIZE_PARAMS;
  {$EXTERNALSYM LPNCCALCSIZE_PARAMS}
  NCCALCSIZE_PARAMS = record
    rgrc: array [0..2] of RECT;
    lppos: PWINDOWPOS;
  end;
  {$EXTERNALSYM NCCALCSIZE_PARAMS}
  TNcCalcSizeParams = NCCALCSIZE_PARAMS;
  PNcCalcSizeParams = LPNCCALCSIZE_PARAMS;

//
// WM_NCCALCSIZE "window valid rect" return values
//

const
  WVR_ALIGNTOP    = $0010;
  {$EXTERNALSYM WVR_ALIGNTOP}
  WVR_ALIGNLEFT   = $0020;
  {$EXTERNALSYM WVR_ALIGNLEFT}
  WVR_ALIGNBOTTOM = $0040;
  {$EXTERNALSYM WVR_ALIGNBOTTOM}
  WVR_ALIGNRIGHT  = $0080;
  {$EXTERNALSYM WVR_ALIGNRIGHT}
  WVR_HREDRAW     = $0100;
  {$EXTERNALSYM WVR_HREDRAW}
  WVR_VREDRAW     = $0200;
  {$EXTERNALSYM WVR_VREDRAW}
  WVR_REDRAW      = WVR_HREDRAW or WVR_VREDRAW;
  {$EXTERNALSYM WVR_REDRAW}
  WVR_VALIDRECTS  = $0400;
  {$EXTERNALSYM WVR_VALIDRECTS}

//
// Key State Masks for Mouse Messages
//

  MK_LBUTTON  = $0001;
  {$EXTERNALSYM MK_LBUTTON}
  MK_RBUTTON  = $0002;
  {$EXTERNALSYM MK_RBUTTON}
  MK_SHIFT    = $0004;
  {$EXTERNALSYM MK_SHIFT}
  MK_CONTROL  = $0008;
  {$EXTERNALSYM MK_CONTROL}
  MK_MBUTTON  = $0010;
  {$EXTERNALSYM MK_MBUTTON}
  MK_XBUTTON1 = $0020;
  {$EXTERNALSYM MK_XBUTTON1}
  MK_XBUTTON2 = $0040;
  {$EXTERNALSYM MK_XBUTTON2}

  TME_HOVER     = $00000001;
  {$EXTERNALSYM TME_HOVER}
  TME_LEAVE     = $00000002;
  {$EXTERNALSYM TME_LEAVE}
  TME_NONCLIENT = $00000010;
  {$EXTERNALSYM TME_NONCLIENT}
  TME_QUERY     = $40000000;
  {$EXTERNALSYM TME_QUERY}
  TME_CANCEL    = $80000000;
  {$EXTERNALSYM TME_CANCEL}

  HOVER_DEFAULT = $FFFFFFFF;
  {$EXTERNALSYM HOVER_DEFAULT}

type
  LPTRACKMOUSEEVENT = ^_TRACKMOUSEEVENT;
  {$EXTERNALSYM LPTRACKMOUSEEVENT}
  _TRACKMOUSEEVENT = record
    cbSize: DWORD;
    dwFlags: DWORD;
    hwndTrack: HWND;
    dwHoverTime: DWORD;
  end;
  //TRACKMOUSEEVENT = _TRACKMOUSEEVENT;
  //{$EXTERNALSYM TRACKMOUSEEVENT}
  TTrackMouseEvent = _TRACKMOUSEEVENT;
  PTrackMouseEvent = LPTRACKMOUSEEVENT;

function TrackMouseEvent(var lpEventTrack: TTrackMouseEvent): BOOL; stdcall;
{$EXTERNALSYM TrackMouseEvent}

//
// Window Styles
//

const
  WS_OVERLAPPED   = $00000000;
  {$EXTERNALSYM WS_OVERLAPPED}
  WS_POPUP        = $80000000;
  {$EXTERNALSYM WS_POPUP}
  WS_CHILD        = $40000000;
  {$EXTERNALSYM WS_CHILD}
  WS_MINIMIZE     = $20000000;
  {$EXTERNALSYM WS_MINIMIZE}
  WS_VISIBLE      = $10000000;
  {$EXTERNALSYM WS_VISIBLE}
  WS_DISABLED     = $08000000;
  {$EXTERNALSYM WS_DISABLED}
  WS_CLIPSIBLINGS = $04000000;
  {$EXTERNALSYM WS_CLIPSIBLINGS}
  WS_CLIPCHILDREN = $02000000;
  {$EXTERNALSYM WS_CLIPCHILDREN}
  WS_MAXIMIZE     = $01000000;
  {$EXTERNALSYM WS_MAXIMIZE}
  WS_CAPTION      = $00C00000; // WS_BORDER | WS_DLGFRAME
  {$EXTERNALSYM WS_CAPTION}
  WS_BORDER       = $00800000;
  {$EXTERNALSYM WS_BORDER}
  WS_DLGFRAME     = $00400000;
  {$EXTERNALSYM WS_DLGFRAME}
  WS_VSCROLL      = $00200000;
  {$EXTERNALSYM WS_VSCROLL}
  WS_HSCROLL      = $00100000;
  {$EXTERNALSYM WS_HSCROLL}
  WS_SYSMENU      = $00080000;
  {$EXTERNALSYM WS_SYSMENU}
  WS_THICKFRAME   = $00040000;
  {$EXTERNALSYM WS_THICKFRAME}
  WS_GROUP        = $00020000;
  {$EXTERNALSYM WS_GROUP}
  WS_TABSTOP      = $00010000;
  {$EXTERNALSYM WS_TABSTOP}

  WS_MINIMIZEBOX = $00020000;
  {$EXTERNALSYM WS_MINIMIZEBOX}
  WS_MAXIMIZEBOX = $00010000;
  {$EXTERNALSYM WS_MAXIMIZEBOX}

  WS_TILED       = WS_OVERLAPPED;
  {$EXTERNALSYM WS_TILED}
  WS_ICONIC      = WS_MINIMIZE;
  {$EXTERNALSYM WS_ICONIC}
  WS_SIZEBOX     = WS_THICKFRAME;
  {$EXTERNALSYM WS_SIZEBOX}

//
// Common Window Styles
//

  WS_OVERLAPPEDWINDOW = (WS_OVERLAPPED or WS_CAPTION or WS_SYSMENU or
                         WS_THICKFRAME or WS_MINIMIZEBOX or WS_MAXIMIZEBOX);
  {$EXTERNALSYM WS_OVERLAPPEDWINDOW}

  WS_POPUPWINDOW = WS_POPUP or WS_BORDER or WS_SYSMENU;
  {$EXTERNALSYM WS_POPUPWINDOW}

  WS_CHILDWINDOW = WS_CHILD;
  {$EXTERNALSYM WS_CHILDWINDOW}

  WS_TILEDWINDOW = WS_OVERLAPPEDWINDOW;
  {$EXTERNALSYM WS_TILEDWINDOW}

//
// Extended Window Styles
//

  WS_EX_DLGMODALFRAME  = $00000001;
  {$EXTERNALSYM WS_EX_DLGMODALFRAME}
  WS_EX_NOPARENTNOTIFY = $00000004;
  {$EXTERNALSYM WS_EX_NOPARENTNOTIFY}
  WS_EX_TOPMOST        = $00000008;
  {$EXTERNALSYM WS_EX_TOPMOST}
  WS_EX_ACCEPTFILES    = $00000010;
  {$EXTERNALSYM WS_EX_ACCEPTFILES}
  WS_EX_TRANSPARENT    = $00000020;
  {$EXTERNALSYM WS_EX_TRANSPARENT}
  WS_EX_MDICHILD       = $00000040;
  {$EXTERNALSYM WS_EX_MDICHILD}
  WS_EX_TOOLWINDOW     = $00000080;
  {$EXTERNALSYM WS_EX_TOOLWINDOW}
  WS_EX_WINDOWEDGE     = $00000100;
  {$EXTERNALSYM WS_EX_WINDOWEDGE}
  WS_EX_CLIENTEDGE     = $00000200;
  {$EXTERNALSYM WS_EX_CLIENTEDGE}
  WS_EX_CONTEXTHELP    = $00000400;
  {$EXTERNALSYM WS_EX_CONTEXTHELP}

  WS_EX_RIGHT          = $00001000;
  {$EXTERNALSYM WS_EX_RIGHT}
  WS_EX_LEFT           = $00000000;
  {$EXTERNALSYM WS_EX_LEFT}
  WS_EX_RTLREADING     = $00002000;
  {$EXTERNALSYM WS_EX_RTLREADING}
  WS_EX_LTRREADING     = $00000000;
  {$EXTERNALSYM WS_EX_LTRREADING}
  WS_EX_LEFTSCROLLBAR  = $00004000;
  {$EXTERNALSYM WS_EX_LEFTSCROLLBAR}
  WS_EX_RIGHTSCROLLBAR = $00000000;
  {$EXTERNALSYM WS_EX_RIGHTSCROLLBAR}
  WS_EX_CONTROLPARENT  = $00010000;
  {$EXTERNALSYM WS_EX_CONTROLPARENT}
  WS_EX_STATICEDGE     = $00020000;
  {$EXTERNALSYM WS_EX_STATICEDGE}
  WS_EX_APPWINDOW      = $00040000;
  {$EXTERNALSYM WS_EX_APPWINDOW}

  WS_EX_OVERLAPPEDWINDOW = WS_EX_WINDOWEDGE or WS_EX_CLIENTEDGE;
  {$EXTERNALSYM WS_EX_OVERLAPPEDWINDOW}
  WS_EX_PALETTEWINDOW    = WS_EX_WINDOWEDGE or WS_EX_TOOLWINDOW or WS_EX_TOPMOST;
  {$EXTERNALSYM WS_EX_PALETTEWINDOW}

  WS_EX_LAYERED = $00080000;
  {$EXTERNALSYM WS_EX_LAYERED}

  WS_EX_NOINHERITLAYOUT = $00100000; // Disable inheritence of mirroring by children
  {$EXTERNALSYM WS_EX_NOINHERITLAYOUT}
  WS_EX_LAYOUTRTL       = $00400000; // Right to left mirroring
  {$EXTERNALSYM WS_EX_LAYOUTRTL}

  WS_EX_COMPOSITED = $02000000;
  {$EXTERNALSYM WS_EX_COMPOSITED}
  WS_EX_NOACTIVATE = $08000000;
  {$EXTERNALSYM WS_EX_NOACTIVATE}

//
// Class styles
//

  CS_VREDRAW         = $0001;
  {$EXTERNALSYM CS_VREDRAW}
  CS_HREDRAW         = $0002;
  {$EXTERNALSYM CS_HREDRAW}
  CS_DBLCLKS         = $0008;
  {$EXTERNALSYM CS_DBLCLKS}
  CS_OWNDC           = $0020;
  {$EXTERNALSYM CS_OWNDC}
  CS_CLASSDC         = $0040;
  {$EXTERNALSYM CS_CLASSDC}
  CS_PARENTDC        = $0080;
  {$EXTERNALSYM CS_PARENTDC}
  CS_NOCLOSE         = $0200;
  {$EXTERNALSYM CS_NOCLOSE}
  CS_SAVEBITS        = $0800;
  {$EXTERNALSYM CS_SAVEBITS}
  CS_BYTEALIGNCLIENT = $1000;
  {$EXTERNALSYM CS_BYTEALIGNCLIENT}
  CS_BYTEALIGNWINDOW = $2000;
  {$EXTERNALSYM CS_BYTEALIGNWINDOW}
  CS_GLOBALCLASS     = $4000;
  {$EXTERNALSYM CS_GLOBALCLASS}

  CS_IME = $00010000;
  {$EXTERNALSYM CS_IME}
  CS_DROPSHADOW = $00020000;
  {$EXTERNALSYM CS_DROPSHADOW}

// WM_PRINT flags//

  PRF_CHECKVISIBLE = $00000001;
  {$EXTERNALSYM PRF_CHECKVISIBLE}
  PRF_NONCLIENT    = $00000002;
  {$EXTERNALSYM PRF_NONCLIENT}
  PRF_CLIENT       = $00000004;
  {$EXTERNALSYM PRF_CLIENT}
  PRF_ERASEBKGND   = $00000008;
  {$EXTERNALSYM PRF_ERASEBKGND}
  PRF_CHILDREN     = $00000010;
  {$EXTERNALSYM PRF_CHILDREN}
  PRF_OWNED        = $00000020;
  {$EXTERNALSYM PRF_OWNED}

// 3D border styles//

  BDR_RAISEDOUTER = $0001;
  {$EXTERNALSYM BDR_RAISEDOUTER}
  BDR_SUNKENOUTER = $0002;
  {$EXTERNALSYM BDR_SUNKENOUTER}
  BDR_RAISEDINNER = $0004;
  {$EXTERNALSYM BDR_RAISEDINNER}
  BDR_SUNKENINNER = $0008;
  {$EXTERNALSYM BDR_SUNKENINNER}

  BDR_OUTER  = BDR_RAISEDOUTER or BDR_SUNKENOUTER;
  {$EXTERNALSYM BDR_OUTER}
  BDR_INNER  = BDR_RAISEDINNER or BDR_SUNKENINNER;
  {$EXTERNALSYM BDR_INNER}
  BDR_RAISED = BDR_RAISEDOUTER or BDR_RAISEDINNER;
  {$EXTERNALSYM BDR_RAISED}
  BDR_SUNKEN = BDR_SUNKENOUTER or BDR_SUNKENINNER;
  {$EXTERNALSYM BDR_SUNKEN}

  EDGE_RAISED = BDR_RAISEDOUTER or BDR_RAISEDINNER;
  {$EXTERNALSYM EDGE_RAISED}
  EDGE_SUNKEN = BDR_SUNKENOUTER or BDR_SUNKENINNER;
  {$EXTERNALSYM EDGE_SUNKEN}
  EDGE_ETCHED = BDR_SUNKENOUTER or BDR_RAISEDINNER;
  {$EXTERNALSYM EDGE_ETCHED}
  EDGE_BUMP   = BDR_RAISEDOUTER or BDR_SUNKENINNER;
  {$EXTERNALSYM EDGE_BUMP}

// Border flags//

  BF_LEFT   = $0001;
  {$EXTERNALSYM BF_LEFT}
  BF_TOP    = $0002;
  {$EXTERNALSYM BF_TOP}
  BF_RIGHT  = $0004;
  {$EXTERNALSYM BF_RIGHT}
  BF_BOTTOM = $0008;
  {$EXTERNALSYM BF_BOTTOM}

  BF_TOPLEFT     = BF_TOP or BF_LEFT;
  {$EXTERNALSYM BF_TOPLEFT}
  BF_TOPRIGHT    = BF_TOP or BF_RIGHT;
  {$EXTERNALSYM BF_TOPRIGHT}
  BF_BOTTOMLEFT  = BF_BOTTOM or BF_LEFT;
  {$EXTERNALSYM BF_BOTTOMLEFT}
  BF_BOTTOMRIGHT = BF_BOTTOM or BF_RIGHT;
  {$EXTERNALSYM BF_BOTTOMRIGHT}
  BF_RECT        = BF_LEFT or BF_TOP or BF_RIGHT or BF_BOTTOM;
  {$EXTERNALSYM BF_RECT}

  BF_DIAGONAL = $0010;
  {$EXTERNALSYM BF_DIAGONAL}

// For diagonal lines, the BF_RECT flags specify the end point of the
// vector bounded by the rectangle parameter.

  BF_DIAGONAL_ENDTOPRIGHT    = BF_DIAGONAL or BF_TOP or BF_RIGHT;
  {$EXTERNALSYM BF_DIAGONAL_ENDTOPRIGHT}
  BF_DIAGONAL_ENDTOPLEFT     = BF_DIAGONAL or BF_TOP or BF_LEFT;
  {$EXTERNALSYM BF_DIAGONAL_ENDTOPLEFT}
  BF_DIAGONAL_ENDBOTTOMLEFT  = BF_DIAGONAL or BF_BOTTOM or BF_LEFT;
  {$EXTERNALSYM BF_DIAGONAL_ENDBOTTOMLEFT}
  BF_DIAGONAL_ENDBOTTOMRIGHT = BF_DIAGONAL or BF_BOTTOM or BF_RIGHT;
  {$EXTERNALSYM BF_DIAGONAL_ENDBOTTOMRIGHT}

  BF_MIDDLE = $0800; // Fill in the middle
  {$EXTERNALSYM BF_MIDDLE}
  BF_SOFT   = $1000; // For softer buttons
  {$EXTERNALSYM BF_SOFT}
  BF_ADJUST = $2000; // Calculate the space left over
  {$EXTERNALSYM BF_ADJUST}
  BF_FLAT   = $4000; // For flat rather than 3D borders
  {$EXTERNALSYM BF_FLAT}
  BF_MONO   = $8000; // For monochrome borders
  {$EXTERNALSYM BF_MONO}

function DrawEdge(hdc: HDC; var qrc: RECT; edge, grfFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM DrawEdge}

// flags for DrawFrameControl//

const
  DFC_CAPTION   = 1;
  {$EXTERNALSYM DFC_CAPTION}
  DFC_MENU      = 2;
  {$EXTERNALSYM DFC_MENU}
  DFC_SCROLL    = 3;
  {$EXTERNALSYM DFC_SCROLL}
  DFC_BUTTON    = 4;
  {$EXTERNALSYM DFC_BUTTON}
  DFC_POPUPMENU = 5;
  {$EXTERNALSYM DFC_POPUPMENU}

  DFCS_CAPTIONCLOSE   = $0000;
  {$EXTERNALSYM DFCS_CAPTIONCLOSE}
  DFCS_CAPTIONMIN     = $0001;
  {$EXTERNALSYM DFCS_CAPTIONMIN}
  DFCS_CAPTIONMAX     = $0002;
  {$EXTERNALSYM DFCS_CAPTIONMAX}
  DFCS_CAPTIONRESTORE = $0003;
  {$EXTERNALSYM DFCS_CAPTIONRESTORE}
  DFCS_CAPTIONHELP    = $0004;
  {$EXTERNALSYM DFCS_CAPTIONHELP}

  DFCS_MENUARROW           = $0000;
  {$EXTERNALSYM DFCS_MENUARROW}
  DFCS_MENUCHECK           = $0001;
  {$EXTERNALSYM DFCS_MENUCHECK}
  DFCS_MENUBULLET          = $0002;
  {$EXTERNALSYM DFCS_MENUBULLET}
  DFCS_MENUARROWRIGHT      = $0004;
  {$EXTERNALSYM DFCS_MENUARROWRIGHT}
  DFCS_SCROLLUP            = $0000;
  {$EXTERNALSYM DFCS_SCROLLUP}
  DFCS_SCROLLDOWN          = $0001;
  {$EXTERNALSYM DFCS_SCROLLDOWN}
  DFCS_SCROLLLEFT          = $0002;
  {$EXTERNALSYM DFCS_SCROLLLEFT}
  DFCS_SCROLLRIGHT         = $0003;
  {$EXTERNALSYM DFCS_SCROLLRIGHT}
  DFCS_SCROLLCOMBOBOX      = $0005;
  {$EXTERNALSYM DFCS_SCROLLCOMBOBOX}
  DFCS_SCROLLSIZEGRIP      = $0008;
  {$EXTERNALSYM DFCS_SCROLLSIZEGRIP}
  DFCS_SCROLLSIZEGRIPRIGHT = $0010;
  {$EXTERNALSYM DFCS_SCROLLSIZEGRIPRIGHT}

  DFCS_BUTTONCHECK      = $0000;
  {$EXTERNALSYM DFCS_BUTTONCHECK}
  DFCS_BUTTONRADIOIMAGE = $0001;
  {$EXTERNALSYM DFCS_BUTTONRADIOIMAGE}
  DFCS_BUTTONRADIOMASK  = $0002;
  {$EXTERNALSYM DFCS_BUTTONRADIOMASK}
  DFCS_BUTTONRADIO      = $0004;
  {$EXTERNALSYM DFCS_BUTTONRADIO}
  DFCS_BUTTON3STATE     = $0008;
  {$EXTERNALSYM DFCS_BUTTON3STATE}
  DFCS_BUTTONPUSH       = $0010;
  {$EXTERNALSYM DFCS_BUTTONPUSH}

  DFCS_INACTIVE = $0100;
  {$EXTERNALSYM DFCS_INACTIVE}
  DFCS_PUSHED   = $0200;
  {$EXTERNALSYM DFCS_PUSHED}
  DFCS_CHECKED  = $0400;
  {$EXTERNALSYM DFCS_CHECKED}

  DFCS_TRANSPARENT = $0800;
  {$EXTERNALSYM DFCS_TRANSPARENT}
  DFCS_HOT         = $1000;
  {$EXTERNALSYM DFCS_HOT}

  DFCS_ADJUSTRECT = $2000;
  {$EXTERNALSYM DFCS_ADJUSTRECT}
  DFCS_FLAT       = $4000;
  {$EXTERNALSYM DFCS_FLAT}
  DFCS_MONO       = $8000;
  {$EXTERNALSYM DFCS_MONO}

function DrawFrameControl(hdc: HDC; const lprc: RECT; uType, uState: UINT): BOOL; stdcall;
{$EXTERNALSYM DrawFrameControl}

// flags for DrawCaption//

const
  DC_ACTIVE   = $0001;
  {$EXTERNALSYM DC_ACTIVE}
  DC_SMALLCAP = $0002;
  {$EXTERNALSYM DC_SMALLCAP}
  DC_ICON     = $0004;
  {$EXTERNALSYM DC_ICON}
  DC_TEXT     = $0008;
  {$EXTERNALSYM DC_TEXT}
  DC_INBUTTON = $0010;
  {$EXTERNALSYM DC_INBUTTON}
  DC_GRADIENT = $0020;
  {$EXTERNALSYM DC_GRADIENT}
  DC_BUTTONS  = $1000;
  {$EXTERNALSYM DC_BUTTONS}

function DrawCaption(hwnd: HWND; hdc: HDC; const lprc: RECT; uFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM DrawCaption}

const
  IDANI_OPEN = 1;
  {$EXTERNALSYM IDANI_OPEN}
  IDANI_CAPTION = 3;
  {$EXTERNALSYM IDANI_CAPTION}

function DrawAnimatedRects(hwnd: HWND; idAni: Integer; const lprcFrom, lprcTo: RECT): BOOL; stdcall;
{$EXTERNALSYM DrawAnimatedRects}

//
// Predefined Clipboard Formats
//

const
  CF_TEXT         = 1;
  {$EXTERNALSYM CF_TEXT}
  CF_BITMAP       = 2;
  {$EXTERNALSYM CF_BITMAP}
  CF_METAFILEPICT = 3;
  {$EXTERNALSYM CF_METAFILEPICT}
  CF_SYLK         = 4;
  {$EXTERNALSYM CF_SYLK}
  CF_DIF          = 5;
  {$EXTERNALSYM CF_DIF}
  CF_TIFF         = 6;
  {$EXTERNALSYM CF_TIFF}
  CF_OEMTEXT      = 7;
  {$EXTERNALSYM CF_OEMTEXT}
  CF_DIB          = 8;
  {$EXTERNALSYM CF_DIB}
  CF_PALETTE      = 9;
  {$EXTERNALSYM CF_PALETTE}
  CF_PENDATA      = 10;
  {$EXTERNALSYM CF_PENDATA}
  CF_RIFF         = 11;
  {$EXTERNALSYM CF_RIFF}
  CF_WAVE         = 12;
  {$EXTERNALSYM CF_WAVE}
  CF_UNICODETEXT  = 13;
  {$EXTERNALSYM CF_UNICODETEXT}
  CF_ENHMETAFILE  = 14;
  {$EXTERNALSYM CF_ENHMETAFILE}
  CF_HDROP        = 15;
  {$EXTERNALSYM CF_HDROP}
  CF_LOCALE       = 16;
  {$EXTERNALSYM CF_LOCALE}
  CF_DIBV5        = 17;
  {$EXTERNALSYM CF_DIBV5}

  {$IFDEF WIN98ME_UP}
  CF_MAX = 18;
  {$EXTERNALSYM CF_MAX}
  {$ELSE}
  CF_MAX = 17;
  {$EXTERNALSYM CF_MAX}
  {$ENDIF WIN98ME_UP}

  CF_OWNERDISPLAY    = $0080;
  {$EXTERNALSYM CF_OWNERDISPLAY}
  CF_DSPTEXT         = $0081;
  {$EXTERNALSYM CF_DSPTEXT}
  CF_DSPBITMAP       = $0082;
  {$EXTERNALSYM CF_DSPBITMAP}
  CF_DSPMETAFILEPICT = $0083;
  {$EXTERNALSYM CF_DSPMETAFILEPICT}
  CF_DSPENHMETAFILE  = $008E;
  {$EXTERNALSYM CF_DSPENHMETAFILE}

//
// "Private" formats don't get GlobalFree()'d
//

  CF_PRIVATEFIRST = $0200;
  {$EXTERNALSYM CF_PRIVATEFIRST}
  CF_PRIVATELAST  = $02FF;
  {$EXTERNALSYM CF_PRIVATELAST}

//
// "GDIOBJ" formats do get DeleteObject()'d
//

  CF_GDIOBJFIRST = $0300;
  {$EXTERNALSYM CF_GDIOBJFIRST}
  CF_GDIOBJLAST  = $03FF;
  {$EXTERNALSYM CF_GDIOBJLAST}

//
// Defines for the fVirt field of the Accelerator table structure.
//

  FVIRTKEY  = TRUE; // Assumed to be == TRUE
  {$EXTERNALSYM FVIRTKEY}
  FNOINVERT = $02;
  {$EXTERNALSYM FNOINVERT}
  FSHIFT    = $04;
  {$EXTERNALSYM FSHIFT}
  FCONTROL  = $08;
  {$EXTERNALSYM FCONTROL}
  FALT      = $10;
  {$EXTERNALSYM FALT}

type
  LPACCEL = ^ACCEL;
  {$EXTERNALSYM LPACCEL}
  tagACCEL = record
    fVirt: BYTE; // Also called the flags field//
    key: WORD;
    cmd: WORD;
  end;
  {$EXTERNALSYM tagACCEL}
  ACCEL = tagACCEL;
  {$EXTERNALSYM ACCEL}
  TAccel = ACCEL;
  PAccel = LPACCEL;

  LPPAINTSTRUCT = ^PAINTSTRUCT;
  {$EXTERNALSYM LPPAINTSTRUCT}
  tagPAINTSTRUCT = record
    hdc: HDC;
    fErase: BOOL;
    rcPaint: RECT;
    fRestore: BOOL;
    fIncUpdate: BOOL;
    rgbReserved: array [0..31] of BYTE;
  end;
  {$EXTERNALSYM tagPAINTSTRUCT}
  PAINTSTRUCT = tagPAINTSTRUCT;
  {$EXTERNALSYM PAINTSTRUCT}
  NPPAINTSTRUCT = ^PAINTSTRUCT;
  {$EXTERNALSYM NPPAINTSTRUCT}
  TPaintStruct = PAINTSTRUCT;
  PPaintStruct = LPPAINTSTRUCT;

  LPCREATESTRUCTA = ^CREATESTRUCTA;
  {$EXTERNALSYM LPCREATESTRUCTA}
  tagCREATESTRUCTA = record
    lpCreateParams: LPVOID;
    hInstance: HINST;
    hMenu: HMENU;
    hwndParent: HWND;
    cy: Integer;
    cx: Integer;
    y: Integer;
    x: Integer;
    style: LONG;
    lpszName: LPCSTR;
    lpszClass: LPCSTR;
    dwExStyle: DWORD;
  end;
  {$EXTERNALSYM tagCREATESTRUCTA}
  CREATESTRUCTA = tagCREATESTRUCTA;
  {$EXTERNALSYM CREATESTRUCTA}
  TCreateStructA = CREATESTRUCTA;
  PCreateStructA = LPCREATESTRUCTA;

  LPCREATESTRUCTW = ^CREATESTRUCTW;
  {$EXTERNALSYM LPCREATESTRUCTW}
  tagCREATESTRUCTW = record
    lpCreateParams: LPVOID;
    hInstance: HINST;
    hMenu: HMENU;
    hwndParent: HWND;
    cy: Integer;
    cx: Integer;
    y: Integer;
    x: Integer;
    style: LONG;
    lpszName: LPCWSTR;
    lpszClass: LPCWSTR;
    dwExStyle: DWORD;
  end;
  {$EXTERNALSYM tagCREATESTRUCTW}
  CREATESTRUCTW = tagCREATESTRUCTW;
  {$EXTERNALSYM CREATESTRUCTW}
  TCreateStructW = CREATESTRUCTW;
  PCreateStructW = LPCREATESTRUCTW;

  {$IFDEF UNICODE}
  CREATESTRUCT = CREATESTRUCTW;
  {$EXTERNALSYM CREATESTRUCT}
  LPCREATESTRUCT = LPCREATESTRUCTW;
  {$EXTERNALSYM LPCREATESTRUCT}
  TCreateStruct = TCreateStructW;
  PCreateStruct = PCreateStructW;
  {$ELSE}
  CREATESTRUCT = CREATESTRUCTA;
  {$EXTERNALSYM CREATESTRUCT}
  LPCREATESTRUCT = LPCREATESTRUCTA;
  {$EXTERNALSYM LPCREATESTRUCT}
  TCreateStruct = TCreateStructA;
  PCreateStruct = PCreateStructA;
  {$ENDIF UNICODE}

//
// HCBT_CREATEWND parameters pointed to by lParam
//

type
  LPCBT_CREATEWNDA = ^CBT_CREATEWNDA;
  {$EXTERNALSYM LPCBT_CREATEWNDA}
  tagCBT_CREATEWNDA = record
    lpcs: LPCREATESTRUCTA;
    hwndInsertAfter: HWND;
  end;
  {$EXTERNALSYM tagCBT_CREATEWNDA}
  CBT_CREATEWNDA = tagCBT_CREATEWNDA;
  {$EXTERNALSYM CBT_CREATEWNDA}
  TCbtCreateWndA = CBT_CREATEWNDA;
  PCbtCreateWndA = LPCBT_CREATEWNDA;

//
// HCBT_CREATEWND parameters pointed to by lParam
//

  LPCBT_CREATEWNDW = ^CBT_CREATEWNDW;
  {$EXTERNALSYM LPCBT_CREATEWNDW}
  tagCBT_CREATEWNDW = record
    lpcs: LPCREATESTRUCTW;
    hwndInsertAfter: HWND;
  end;
  {$EXTERNALSYM tagCBT_CREATEWNDW}
  CBT_CREATEWNDW = tagCBT_CREATEWNDW;
  {$EXTERNALSYM CBT_CREATEWNDW}
  TCbtCreateWndW = CBT_CREATEWNDW;
  PCbtCreateWndW = LPCBT_CREATEWNDW;

  {$IFDEF UNICODE}
  CBT_CREATEWND = CBT_CREATEWNDW;
  {$EXTERNALSYM CBT_CREATEWND}
  LPCBT_CREATEWND = LPCBT_CREATEWNDW;
  {$EXTERNALSYM LPCBT_CREATEWND}
  {$ELSE}
  CBT_CREATEWND = CBT_CREATEWNDA;
  {$EXTERNALSYM CBT_CREATEWND}
  LPCBT_CREATEWND = LPCBT_CREATEWNDA;
  {$EXTERNALSYM LPCBT_CREATEWND}
  {$ENDIF UNICODE}

  LPWINDOWPLACEMENT = ^WINDOWPLACEMENT;
  {$EXTERNALSYM LPWINDOWPLACEMENT}
  tagWINDOWPLACEMENT = record
    length: UINT;
    flags: UINT;
    showCmd: UINT;
    ptMinPosition: POINT;
    ptMaxPosition: POINT;
    rcNormalPosition: RECT;
  end;
  {$EXTERNALSYM tagWINDOWPLACEMENT}
  WINDOWPLACEMENT = tagWINDOWPLACEMENT;
  {$EXTERNALSYM WINDOWPLACEMENT}
  TWindowPlacement = WINDOWPLACEMENT;
  PWindowPlacement = LPWINDOWPLACEMENT;

const
  WPF_SETMINPOSITION       = $0001;
  {$EXTERNALSYM WPF_SETMINPOSITION}
  WPF_RESTORETOMAXIMIZED   = $0002;
  {$EXTERNALSYM WPF_RESTORETOMAXIMIZED}
  WPF_ASYNCWINDOWPLACEMENT = $0004;
  {$EXTERNALSYM WPF_ASYNCWINDOWPLACEMENT}

type
  LPNMHDR = ^NMHDR;
  {$EXTERNALSYM LPNMHDR}
  tagNMHDR = record
    hwndFrom: HWND;
    idFrom: UINT_PTR;
    code: UINT; // NM_ code
  end;
  {$EXTERNALSYM tagNMHDR}
  NMHDR = tagNMHDR;
  {$EXTERNALSYM NMHDR}
  TNmHdr = NMHDR;
  PNmHdr = LPNMHDR;

  LPSTYLESTRUCT = ^STYLESTRUCT;
  {$EXTERNALSYM LPSTYLESTRUCT}
  tagSTYLESTRUCT = record
    styleOld: DWORD;
    styleNew: DWORD;
  end;
  {$EXTERNALSYM tagSTYLESTRUCT}
  STYLESTRUCT = tagSTYLESTRUCT;
  {$EXTERNALSYM STYLESTRUCT}
  TStyleStruct = STYLESTRUCT;
  PStyleStruct = LPSTYLESTRUCT;

//
// Owner draw control types
//

const
  ODT_MENU     = 1;
  {$EXTERNALSYM ODT_MENU}
  ODT_LISTBOX  = 2;
  {$EXTERNALSYM ODT_LISTBOX}
  ODT_COMBOBOX = 3;
  {$EXTERNALSYM ODT_COMBOBOX}
  ODT_BUTTON   = 4;
  {$EXTERNALSYM ODT_BUTTON}
  ODT_STATIC   = 5;
  {$EXTERNALSYM ODT_STATIC}

//
// Owner draw actions
//

  ODA_DRAWENTIRE = $0001;
  {$EXTERNALSYM ODA_DRAWENTIRE}
  ODA_SELECT     = $0002;
  {$EXTERNALSYM ODA_SELECT}
  ODA_FOCUS      = $0004;
  {$EXTERNALSYM ODA_FOCUS}

//
// Owner draw state
//

  ODS_SELECTED     = $0001;
  {$EXTERNALSYM ODS_SELECTED}
  ODS_GRAYED       = $0002;
  {$EXTERNALSYM ODS_GRAYED}
  ODS_DISABLED     = $0004;
  {$EXTERNALSYM ODS_DISABLED}
  ODS_CHECKED      = $0008;
  {$EXTERNALSYM ODS_CHECKED}
  ODS_FOCUS        = $0010;
  {$EXTERNALSYM ODS_FOCUS}
  ODS_DEFAULT      = $0020;
  {$EXTERNALSYM ODS_DEFAULT}
  ODS_COMBOBOXEDIT = $1000;
  {$EXTERNALSYM ODS_COMBOBOXEDIT}
  ODS_HOTLIGHT     = $0040;
  {$EXTERNALSYM ODS_HOTLIGHT}
  ODS_INACTIVE     = $0080;
  {$EXTERNALSYM ODS_INACTIVE}
  ODS_NOACCEL      = $0100;
  {$EXTERNALSYM ODS_NOACCEL}
  ODS_NOFOCUSRECT  = $0200;
  {$EXTERNALSYM ODS_NOFOCUSRECT}

//
// MEASUREITEMSTRUCT for ownerdraw
//

type
  LPMEASUREITEMSTRUCT = ^MEASUREITEMSTRUCT;
  {$EXTERNALSYM LPMEASUREITEMSTRUCT}
  tagMEASUREITEMSTRUCT = record
    CtlType: UINT;
    CtlID: UINT;
    itemID: UINT;
    itemWidth: UINT;
    itemHeight: UINT;
    itemData: ULONG_PTR;
  end;
  {$EXTERNALSYM tagMEASUREITEMSTRUCT}
  MEASUREITEMSTRUCT = tagMEASUREITEMSTRUCT;
  {$EXTERNALSYM MEASUREITEMSTRUCT}
  TMeasureItemStruct = MEASUREITEMSTRUCT;
  PMeasureItemStruct = LPMEASUREITEMSTRUCT;

//
// DRAWITEMSTRUCT for ownerdraw
//

  LPDRAWITEMSTRUCT = ^DRAWITEMSTRUCT;
  {$EXTERNALSYM LPDRAWITEMSTRUCT}
  tagDRAWITEMSTRUCT = record
    CtlType: UINT;
    CtlID: UINT;
    itemID: UINT;
    itemAction: UINT;
    itemState: UINT;
    hwndItem: HWND;
    hDC: HDC;
    rcItem: RECT;
    itemData: ULONG_PTR;
  end;
  {$EXTERNALSYM tagDRAWITEMSTRUCT}
  DRAWITEMSTRUCT = tagDRAWITEMSTRUCT;
  {$EXTERNALSYM DRAWITEMSTRUCT}
  TDrawItemStruct = DRAWITEMSTRUCT;
  PDrawItemStruct = LPDRAWITEMSTRUCT;

//
// DELETEITEMSTRUCT for ownerdraw
//

  LPDELETEITEMSTRUCT = ^DELETEITEMSTRUCT;
  {$EXTERNALSYM LPDELETEITEMSTRUCT}
  tagDELETEITEMSTRUCT = record
    CtlType: UINT;
    CtlID: UINT;
    itemID: UINT;
    hwndItem: HWND;
    itemData: ULONG_PTR;
  end;
  {$EXTERNALSYM tagDELETEITEMSTRUCT}
  DELETEITEMSTRUCT = tagDELETEITEMSTRUCT;
  {$EXTERNALSYM DELETEITEMSTRUCT}
  TDeleteItemStruct = DELETEITEMSTRUCT;
  PDeleteItemStruct = LPDELETEITEMSTRUCT;

//
// COMPAREITEMSTUCT for ownerdraw sorting
//

  LPCOMPAREITEMSTRUCT = ^COMPAREITEMSTRUCT;
  {$EXTERNALSYM LPCOMPAREITEMSTRUCT}
  tagCOMPAREITEMSTRUCT = record
    CtlType: UINT;
    CtlID: UINT;
    hwndItem: HWND;
    itemID1: UINT;
    itemData1: ULONG_PTR;
    itemID2: UINT;
    itemData2: ULONG_PTR;
    dwLocaleId: DWORD;
  end;
  {$EXTERNALSYM tagCOMPAREITEMSTRUCT}
  COMPAREITEMSTRUCT = tagCOMPAREITEMSTRUCT;
  {$EXTERNALSYM COMPAREITEMSTRUCT}
  TCompareItemStruct = COMPAREITEMSTRUCT;
  PCompareItemStruct = LPCOMPAREITEMSTRUCT;

//
// Message Function Templates
//

function GetMessageA(lpMsg: LPMSG; hWnd: HWND; wMsgFilterMin, wMsgFilterMax: UINT): BOOL; stdcall;
{$EXTERNALSYM GetMessageA}
function GetMessageW(lpMsg: LPMSG; hWnd: HWND; wMsgFilterMin, wMsgFilterMax: UINT): BOOL; stdcall;
{$EXTERNALSYM GetMessageW}
function GetMessage(lpMsg: LPMSG; hWnd: HWND; wMsgFilterMin, wMsgFilterMax: UINT): BOOL; stdcall;
{$EXTERNALSYM GetMessage}

function TranslateMessage(lpMsg: LPMSG): BOOL; stdcall;
{$EXTERNALSYM TranslateMessage}

function DispatchMessageA(lpMsg: LPMSG): LRESULT; stdcall;
{$EXTERNALSYM DispatchMessageA}
function DispatchMessageW(lpMsg: LPMSG): LRESULT; stdcall;
{$EXTERNALSYM DispatchMessageW}
function DispatchMessage(lpMsg: LPMSG): LRESULT; stdcall;
{$EXTERNALSYM DispatchMessage}

function SetMessageQueue(cMessagesMax: Integer): BOOL; stdcall;
{$EXTERNALSYM SetMessageQueue}

function PeekMessageA(var lpMsg: MSG; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax, wRemoveMsg: UINT): BOOL; stdcall;
{$EXTERNALSYM PeekMessageA}
function PeekMessageW(var lpMsg: MSG; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax, wRemoveMsg: UINT): BOOL; stdcall;
{$EXTERNALSYM PeekMessageW}
function PeekMessage(var lpMsg: MSG; hWnd: HWND;
  wMsgFilterMin, wMsgFilterMax, wRemoveMsg: UINT): BOOL; stdcall;
{$EXTERNALSYM PeekMessage}

//
// Queue status flags for GetQueueStatus() and MsgWaitForMultipleObjects()
//

const
  QS_KEY            = $0001;
  {$EXTERNALSYM QS_KEY}
  QS_MOUSEMOVE      = $0002;
  {$EXTERNALSYM QS_MOUSEMOVE}
  QS_MOUSEBUTTON    = $0004;
  {$EXTERNALSYM QS_MOUSEBUTTON}
  QS_POSTMESSAGE    = $0008;
  {$EXTERNALSYM QS_POSTMESSAGE}
  QS_TIMER          = $0010;
  {$EXTERNALSYM QS_TIMER}
  QS_PAINT          = $0020;
  {$EXTERNALSYM QS_PAINT}
  QS_SENDMESSAGE    = $0040;
  {$EXTERNALSYM QS_SENDMESSAGE}
  QS_HOTKEY         = $0080;
  {$EXTERNALSYM QS_HOTKEY}
  QS_ALLPOSTMESSAGE = $0100;
  {$EXTERNALSYM QS_ALLPOSTMESSAGE}
  QS_RAWINPUT       = $0400;
  {$EXTERNALSYM QS_RAWINPUT}

  QS_MOUSE = QS_MOUSEMOVE or QS_MOUSEBUTTON;
  {$EXTERNALSYM QS_MOUSE}

  QS_INPUT = QS_MOUSE or QS_KEY {$IFDEF WINXP_UP} or QS_RAWINPUT {$ENDIF};
  {$EXTERNALSYM QS_INPUT}

  QS_ALLEVENTS = QS_INPUT or QS_POSTMESSAGE or QS_TIMER or QS_PAINT or QS_HOTKEY;
  {$EXTERNALSYM QS_ALLEVENTS}

  QS_ALLINPUT = (QS_INPUT or QS_POSTMESSAGE or QS_TIMER or QS_PAINT or
    QS_HOTKEY or QS_SENDMESSAGE);
  {$EXTERNALSYM QS_ALLINPUT}

//
// PeekMessage() Options
//

const
  PM_NOREMOVE       = $0000;
  {$EXTERNALSYM PM_NOREMOVE}
  PM_REMOVE         = $0001;
  {$EXTERNALSYM PM_REMOVE}
  PM_NOYIELD        = $0002;
  {$EXTERNALSYM PM_NOYIELD}
  PM_QS_INPUT       = QS_INPUT shl 16;
  {$EXTERNALSYM PM_QS_INPUT}
  PM_QS_POSTMESSAGE = (QS_POSTMESSAGE or QS_HOTKEY or QS_TIMER) shl 16;
  {$EXTERNALSYM PM_QS_POSTMESSAGE}
  PM_QS_PAINT       = QS_PAINT shl 16;
  {$EXTERNALSYM PM_QS_PAINT}
  PM_QS_SENDMESSAGE = QS_SENDMESSAGE shl 16;
  {$EXTERNALSYM PM_QS_SENDMESSAGE}

function RegisterHotKey(hWnd: HWND; id: Integer; fsModifiers, vk: UINT): BOOL; stdcall;
{$EXTERNALSYM RegisterHotKey}

function UnregisterHotKey(hWnd: HWND; id: Integer): BOOL; stdcall;
{$EXTERNALSYM UnregisterHotKey}

const
  MOD_ALT     = $0001;
  {$EXTERNALSYM MOD_ALT}
  MOD_CONTROL = $0002;
  {$EXTERNALSYM MOD_CONTROL}
  MOD_SHIFT   = $0004;
  {$EXTERNALSYM MOD_SHIFT}
  MOD_WIN     = $0008;
  {$EXTERNALSYM MOD_WIN}

  IDHOT_SNAPWINDOW  = DWORD(-1); // SHIFT-PRINTSCRN
  {$EXTERNALSYM IDHOT_SNAPWINDOW}
  IDHOT_SNAPDESKTOP = DWORD(-2); // PRINTSCRN
  {$EXTERNALSYM IDHOT_SNAPDESKTOP}

const
  ENDSESSION_LOGOFF = DWORD($80000000);
  {$EXTERNALSYM ENDSESSION_LOGOFF}

  EWX_LOGOFF      = 0;
  {$EXTERNALSYM EWX_LOGOFF}
  EWX_SHUTDOWN    = $00000001;
  {$EXTERNALSYM EWX_SHUTDOWN}
  EWX_REBOOT      = $00000002;
  {$EXTERNALSYM EWX_REBOOT}
  EWX_FORCE       = $00000004;
  {$EXTERNALSYM EWX_FORCE}
  EWX_POWEROFF    = $00000008;
  {$EXTERNALSYM EWX_POWEROFF}
  EWX_FORCEIFHUNG = $00000010;
  {$EXTERNALSYM EWX_FORCEIFHUNG}

function ExitWindows(dwReserved: DWORD; uREserved: UINT): BOOL;
{$EXTERNALSYM ExitWindows}

function ExitWindowsEx(uFlags: UINT; dwReserved: DWORD): BOOL; stdcall;
{$EXTERNALSYM ExitWindowsEx}

function SwapMouseButton(fSwap: BOOL): BOOL; stdcall;
{$EXTERNALSYM SwapMouseButton}

function GetMessagePos: DWORD; stdcall;
{$EXTERNALSYM GetMessagePos}

function GetMessageTime: LONG; stdcall;
{$EXTERNALSYM GetMessageTime}

function GetMessageExtraInfo: LPARAM; stdcall;
{$EXTERNALSYM GetMessageExtraInfo}

function SetMessageExtraInfo(lParam: LPARAM): LPARAM; stdcall;
{$EXTERNALSYM SetMessageExtraInfo}

function SendMessageA(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM SendMessageA}
function SendMessageW(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM SendMessageW}
function SendMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM SendMessage}

function SendMessageTimeoutA(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM;
  fuFlags, uTimeout: UINT; var lpdwResult: DWORD_PTR): LRESULT; stdcall;
{$EXTERNALSYM SendMessageTimeoutA}
function SendMessageTimeoutW(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM;
  fuFlags, uTimeout: UINT; var lpdwResult: DWORD_PTR): LRESULT; stdcall;
{$EXTERNALSYM SendMessageTimeoutW}
function SendMessageTimeout(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM;
  fuFlags, uTimeout: UINT; var lpdwResult: DWORD_PTR): LRESULT; stdcall;
{$EXTERNALSYM SendMessageTimeout}

function SendNotifyMessageA(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM SendNotifyMessageA}
function SendNotifyMessageW(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM SendNotifyMessageW}
function SendNotifyMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM SendNotifyMessage}

function SendMessageCallbackA(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM;
  lpResultCallBack: SENDASYNCPROC; dwData: ULONG_PTR): BOOL; stdcall;
{$EXTERNALSYM SendMessageCallbackA}
function SendMessageCallbackW(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM;
  lpResultCallBack: SENDASYNCPROC; dwData: ULONG_PTR): BOOL; stdcall;
{$EXTERNALSYM SendMessageCallbackW}
function SendMessageCallback(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM;
  lpResultCallBack: SENDASYNCPROC; dwData: ULONG_PTR): BOOL; stdcall;
{$EXTERNALSYM SendMessageCallback}

type
  BSMINFO = record
    cbSize: UINT;
    hdesk: HDESK;
    hwnd: HWND;
    luid: LUID;
  end;
  {$EXTERNALSYM BSMINFO}
  PBSMINFO = ^BSMINFO;
  TBsmInfo = BSMINFO;

function BroadcastSystemMessageExA(dwFlags: DWORD; lpwRecipients: LPDWORD; uiMessage: UINT;
  wParam: WPARAM; lParam: LPARAM; pBSMInfo: PBSMINFO): Longint; stdcall;
{$EXTERNALSYM BroadcastSystemMessageExA}
function BroadcastSystemMessageExW(dwFlags: DWORD; lpwRecipients: LPDWORD; uiMessage: UINT;
  wParam: WPARAM; lParam: LPARAM; pBSMInfo: PBSMINFO): Longint; stdcall;
{$EXTERNALSYM BroadcastSystemMessageExW}
function BroadcastSystemMessageEx(dwFlags: DWORD; lpwRecipients: LPDWORD; uiMessage: UINT;
  wParam: WPARAM; lParam: LPARAM; pBSMInfo: PBSMINFO): Longint; stdcall;
{$EXTERNALSYM BroadcastSystemMessageEx}

function BroadcastSystemMessageA(dwFlags: DWORD; lpdwRecipients: LPDWORD;
  uiMessage: UINT; wParam: WPARAM; lParam: LPARAM): Longint; stdcall;
{$EXTERNALSYM BroadcastSystemMessageA}
function BroadcastSystemMessageW(dwFlags: DWORD; lpdwRecipients: LPDWORD;
  uiMessage: UINT; wParam: WPARAM; lParam: LPARAM): Longint; stdcall;
{$EXTERNALSYM BroadcastSystemMessageW}
function BroadcastSystemMessage(dwFlags: DWORD; lpdwRecipients: LPDWORD;
  uiMessage: UINT; wParam: WPARAM; lParam: LPARAM): Longint; stdcall;
{$EXTERNALSYM BroadcastSystemMessage}

//Broadcast Special Message Recipient list

const
  BSM_ALLCOMPONENTS      = $00000000;
  {$EXTERNALSYM BSM_ALLCOMPONENTS}
  BSM_VXDS               = $00000001;
  {$EXTERNALSYM BSM_VXDS}
  BSM_NETDRIVER          = $00000002;
  {$EXTERNALSYM BSM_NETDRIVER}
  BSM_INSTALLABLEDRIVERS = $00000004;
  {$EXTERNALSYM BSM_INSTALLABLEDRIVERS}
  BSM_APPLICATIONS       = $00000008;
  {$EXTERNALSYM BSM_APPLICATIONS}
  BSM_ALLDESKTOPS        = $00000010;
  {$EXTERNALSYM BSM_ALLDESKTOPS}

//Broadcast Special Message Flags

  BSF_QUERY              = $00000001;
  {$EXTERNALSYM BSF_QUERY}
  BSF_IGNORECURRENTTASK  = $00000002;
  {$EXTERNALSYM BSF_IGNORECURRENTTASK}
  BSF_FLUSHDISK          = $00000004;
  {$EXTERNALSYM BSF_FLUSHDISK}
  BSF_NOHANG             = $00000008;
  {$EXTERNALSYM BSF_NOHANG}
  BSF_POSTMESSAGE        = $00000010;
  {$EXTERNALSYM BSF_POSTMESSAGE}
  BSF_FORCEIFHUNG        = $00000020;
  {$EXTERNALSYM BSF_FORCEIFHUNG}
  BSF_NOTIMEOUTIFNOTHUNG = $00000040;
  {$EXTERNALSYM BSF_NOTIMEOUTIFNOTHUNG}
  BSF_ALLOWSFW           = $00000080;
  {$EXTERNALSYM BSF_ALLOWSFW}
  BSF_SENDNOTIFYMESSAGE  = $00000100;
  {$EXTERNALSYM BSF_SENDNOTIFYMESSAGE}

  BSF_RETURNHDESK        = $00000200;
  {$EXTERNALSYM BSF_RETURNHDESK}
  BSF_LUID               = $00000400;
  {$EXTERNALSYM BSF_LUID}

  BROADCAST_QUERY_DENY = $424D5144; // Return this value to deny a query.
  {$EXTERNALSYM BROADCAST_QUERY_DENY}

// RegisterDeviceNotification

type
  HDEVNOTIFY = PVOID;
  {$EXTERNALSYM HDEVNOTIFY}
  PHDEVNOTIFY = ^HDEVNOTIFY;
  {$EXTERNALSYM PHDEVNOTIFY}

const
  DEVICE_NOTIFY_WINDOW_HANDLE  = $00000000;
  {$EXTERNALSYM DEVICE_NOTIFY_WINDOW_HANDLE}
  DEVICE_NOTIFY_SERVICE_HANDLE = $00000001;
  {$EXTERNALSYM DEVICE_NOTIFY_SERVICE_HANDLE}
  DEVICE_NOTIFY_ALL_INTERFACE_CLASSES = $00000004;
  {$EXTERNALSYM DEVICE_NOTIFY_ALL_INTERFACE_CLASSES}

function RegisterDeviceNotificationA(hRecipient: HANDLE; NotificationFilter: LPVOID;
  Flags: DWORD): HDEVNOTIFY; stdcall;
{$EXTERNALSYM RegisterDeviceNotificationA}
function RegisterDeviceNotificationW(hRecipient: HANDLE; NotificationFilter: LPVOID;
  Flags: DWORD): HDEVNOTIFY; stdcall;
{$EXTERNALSYM RegisterDeviceNotificationW}
function RegisterDeviceNotification(hRecipient: HANDLE; NotificationFilter: LPVOID;
  Flags: DWORD): HDEVNOTIFY; stdcall;
{$EXTERNALSYM RegisterDeviceNotification}

function UnregisterDeviceNotification(Handle: HDEVNOTIFY): BOOL; stdcall;
{$EXTERNALSYM UnregisterDeviceNotification}

function PostMessageA(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM PostMessageA}
function PostMessageW(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM PostMessageW}
function PostMessage(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM PostMessage}

function PostThreadMessageA(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM PostThreadMessageA}
function PostThreadMessageW(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM PostThreadMessageW}
function PostThreadMessage(idThread: DWORD; Msg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM PostThreadMessage}

function PostAppMessageA(idThread: DWORD; wMsg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
{$EXTERNALSYM PostAppMessageA}
function PostAppMessageW(idThread: DWORD; wMsg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
{$EXTERNALSYM PostAppMessageW}
function PostAppMessage(idThread: DWORD; wMsg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
{$EXTERNALSYM PostAppMessage}

//
// Special HWND value for use with PostMessage() and SendMessage()
//

const
  HWND_BROADCAST = HWND($ffff);
  {$EXTERNALSYM HWND_BROADCAST}

  HWND_MESSAGE = HWND(-3);
  {$EXTERNALSYM HWND_MESSAGE}

function AttachThreadInput(idAttach, idAttachTo: DWORD; fAttach: BOOL): BOOL; stdcall;
{$EXTERNALSYM AttachThreadInput}

function ReplyMessage(lResult: LRESULT): BOOL; stdcall;
{$EXTERNALSYM ReplyMessage}

function WaitMessage: BOOL; stdcall;
{$EXTERNALSYM WaitMessage}

function WaitForInputIdle(hProcess: HANDLE; dwMilliseconds: DWORD): DWORD; stdcall;
{$EXTERNALSYM WaitForInputIdle}

function DefWindowProcA(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefWindowProcA}
function DefWindowProcW(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefWindowProcW}
function DefWindowProc(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefWindowProc}

procedure PostQuitMessage(nExitCode: Integer); stdcall;
{$EXTERNALSYM PostQuitMessage}

function CallWindowProcA(lpPrevWndFunc: WNDPROC; hWnd: HWND; Msg: UINT;
  wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM CallWindowProcA}
function CallWindowProcW(lpPrevWndFunc: WNDPROC; hWnd: HWND; Msg: UINT;
  wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM CallWindowProcW}
function CallWindowProc(lpPrevWndFunc: WNDPROC; hWnd: HWND; Msg: UINT;
  wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM CallWindowProc}

function InSendMessage: BOOL; stdcall;
{$EXTERNALSYM InSendMessage}

function InSendMessageEx(lpReserved: LPVOID): DWORD; stdcall;
{$EXTERNALSYM InSendMessageEx}

//
// InSendMessageEx return value
//

const
  ISMEX_NOSEND   = $00000000;
  {$EXTERNALSYM ISMEX_NOSEND}
  ISMEX_SEND     = $00000001;
  {$EXTERNALSYM ISMEX_SEND}
  ISMEX_NOTIFY   = $00000002;
  {$EXTERNALSYM ISMEX_NOTIFY}
  ISMEX_CALLBACK = $00000004;
  {$EXTERNALSYM ISMEX_CALLBACK}
  ISMEX_REPLIED  = $00000008;
  {$EXTERNALSYM ISMEX_REPLIED}

function GetDoubleClickTime: UINT; stdcall;
{$EXTERNALSYM GetDoubleClickTime}

function SetDoubleClickTime(uInterval: UINT): BOOL; stdcall;
{$EXTERNALSYM SetDoubleClickTime}

function RegisterClassA(const lpWndClass: WNDCLASSA): ATOM; stdcall;
{$EXTERNALSYM RegisterClassA}
function RegisterClassW(const lpWndClass: WNDCLASSW): ATOM; stdcall;
{$EXTERNALSYM RegisterClassW}
function RegisterClass(const lpWndClass: WNDCLASS): ATOM; stdcall;
{$EXTERNALSYM RegisterClass}

function UnregisterClassA(lpClassName: LPCSTR; hInstance: HINST): BOOL; stdcall;
{$EXTERNALSYM UnregisterClassA}
function UnregisterClassW(lpClassName: LPCWSTR; hInstance: HINST): BOOL; stdcall;
{$EXTERNALSYM UnregisterClassW}
function UnregisterClass(lpClassName: LPCTSTR; hInstance: HINST): BOOL; stdcall;
{$EXTERNALSYM UnregisterClass}

function GetClassInfoA(hInstance: HINST; lpClassName: LPCSTR;
  var lpWndClass: WNDCLASSA): BOOL; stdcall;
{$EXTERNALSYM GetClassInfoA}
function GetClassInfoW(hInstance: HINST; lpClassName: LPCWSTR;
  var lpWndClass: WNDCLASSW): BOOL; stdcall;
{$EXTERNALSYM GetClassInfoW}
function GetClassInfo(hInstance: HINST; lpClassName: LPCTSTR;
  var lpWndClass: WNDCLASS): BOOL; stdcall;
{$EXTERNALSYM GetClassInfo}

function RegisterClassExA(const lpwcx: WNDCLASSEXA): ATOM; stdcall;
{$EXTERNALSYM RegisterClassExA}
function RegisterClassExW(const lpwcx: WNDCLASSEXW): ATOM; stdcall;
{$EXTERNALSYM RegisterClassExW}
function RegisterClassEx(const lpwcx: WNDCLASSEX): ATOM; stdcall;
{$EXTERNALSYM RegisterClassEx}

function GetClassInfoExA(hinst: HINST; lpszClass: LPCSTR; var lpwcx: WNDCLASSEXA): BOOL; stdcall;
{$EXTERNALSYM GetClassInfoExA}
function GetClassInfoExW(hinst: HINST; lpszClass: LPCWSTR; var lpwcx: WNDCLASSEXW): BOOL; stdcall;
{$EXTERNALSYM GetClassInfoExW}
function GetClassInfoEx(hinst: HINST; lpszClass: LPCTSTR; var lpwcx: WNDCLASSEX): BOOL; stdcall;
{$EXTERNALSYM GetClassInfoEx}

const
  CW_USEDEFAULT = Integer($80000000);
  {$EXTERNALSYM CW_USEDEFAULT}

//
// Special value for CreateWindow, et al.
//

const
  HWND_DESKTOP = HWND(0);
  {$EXTERNALSYM HWND_DESKTOP}

type
  PREGISTERCLASSNAMEW = function(p: LPCWSTR): LongBool; stdcall;
  {$EXTERNALSYM PREGISTERCLASSNAMEW}

function CreateWindowExA(dwExStyle: DWORD; lpClassName, lpWindowName: LPCSTR;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer; hWndParent: HWND;
  hMenu: HMENU; hInstance: HINST; lpParam: LPVOID): HWND; stdcall;
{$EXTERNALSYM CreateWindowExA}
function CreateWindowExW(dwExStyle: DWORD; lpClassName, lpWindowName: LPCWSTR;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer; hWndParent: HWND;
  hMenu: HMENU; hInstance: HINST; lpParam: LPVOID): HWND; stdcall;
{$EXTERNALSYM CreateWindowExW}
function CreateWindowEx(dwExStyle: DWORD; lpClassName, lpWindowName: LPCTSTR;
  dwStyle: DWORD; X, Y, nWidth, nHeight: Integer; hWndParent: HWND;
  hMenu: HMENU; hInstance: HINST; lpParam: LPVOID): HWND; stdcall;
{$EXTERNALSYM CreateWindowEx}

function CreateWindowA(lpClassName, lpWindowName: LPCSTR; dwStyle: DWORD;
  x, y, nWidth, nHeight: Integer; hWndParent: HWND; hMenu: HMENU;
  hInstance: HINST; lpParam: LPVOID): HWND;
{$EXTERNALSYM CreateWindowA}
function CreateWindowW(lpClassName, lpWindowName: LPCWSTR; dwStyle: DWORD;
  x, y, nWidth, nHeight: Integer; hWndParent: HWND; hMenu: HMENU;
  hInstance: HINST; lpParam: LPVOID): HWND;
{$EXTERNALSYM CreateWindowW}
function CreateWindow(lpClassName, lpWindowName: LPCTSTR; dwStyle: DWORD;
  x, y, nWidth, nHeight: Integer; hWndParent: HWND; hMenu: HMENU;
  hInstance: HINST; lpParam: LPVOID): HWND;
{$EXTERNALSYM CreateWindow}

function IsWindow(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM IsWindow}

function IsMenu(hMenu: HMENU): BOOL; stdcall;
{$EXTERNALSYM IsMenu}

function IsChild(hWndParent, hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM IsChild}

function DestroyWindow(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM DestroyWindow}

function ShowWindow(hWnd: HWND; nCmdShow: Integer): BOOL; stdcall;
{$EXTERNALSYM ShowWindow}

function AnimateWindow(hWnd: HWND; dwTime, dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM AnimateWindow}

function UpdateLayeredWindow(hWnd: HWND; hdcDst: HDC; pptDst: LPPOINT;
  psize: LPSIZE; hdcSrc: HDC; pptSrc: LPPOINT; crKey: COLORREF;
  pblend: LPBLENDFUNCTION; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM UpdateLayeredWindow}

function GetLayeredWindowAttributes(hwnd: HWND; pcrKey: LPCOLORREF; pbAlpha: LPBYTE;
  pdwFlags: LPWORD): BOOL; stdcall;
{$EXTERNALSYM GetLayeredWindowAttributes}

const
  PW_CLIENTONLY = $00000001;
  {$EXTERNALSYM PW_CLIENTONLY}

function PrintWindow(hwnd: HWND; hdcBlt: HDC; nFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM PrintWindow}

function SetLayeredWindowAttributes(hwnd: HWND; crKey: COLORREF; bAlpha: BYTE;
  dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetLayeredWindowAttributes}

const
  LWA_COLORKEY = $00000001;
  {$EXTERNALSYM LWA_COLORKEY}
  LWA_ALPHA    = $00000002;
  {$EXTERNALSYM LWA_ALPHA}

  ULW_COLORKEY = $00000001;
  {$EXTERNALSYM ULW_COLORKEY}
  ULW_ALPHA    = $00000002;
  {$EXTERNALSYM ULW_ALPHA}
  ULW_OPAQUE   = $00000004;
  {$EXTERNALSYM ULW_OPAQUE}

function ShowWindowAsync(hWnd: HWND; nCmdShow: Integer): BOOL; stdcall;
{$EXTERNALSYM ShowWindowAsync}

function FlashWindow(hWnd: HWND; bInvert: BOOL): BOOL; stdcall;
{$EXTERNALSYM FlashWindow}

type
  PFLASH_INFO = ^FLASH_INFO;
  {$EXTERNALSYM PFLASH_INFO}
  FLASH_INFO = record
    cbSize: UINT;
    hwnd: HWND;
    dwFlags: DWORD;
    uCount: UINT;
    dwTimeout: DWORD;
  end;
  {$EXTERNALSYM FLASH_INFO}
  TFlashInfo = FLASH_INFO;
  PFlashInfo = PFLASH_INFO;

function FlashWindowEx(var pfwi: FLASH_INFO): BOOL; stdcall;
{$EXTERNALSYM FlashWindowEx}

const
  FLASHW_STOP      = 0;
  {$EXTERNALSYM FLASHW_STOP}
  FLASHW_CAPTION   = $00000001;
  {$EXTERNALSYM FLASHW_CAPTION}
  FLASHW_TRAY      = $00000002;
  {$EXTERNALSYM FLASHW_TRAY}
  FLASHW_ALL       = FLASHW_CAPTION or FLASHW_TRAY;
  {$EXTERNALSYM FLASHW_ALL}
  FLASHW_TIMER     = $00000004;
  {$EXTERNALSYM FLASHW_TIMER}
  FLASHW_TIMERNOFG = $0000000C;
  {$EXTERNALSYM FLASHW_TIMERNOFG}

function ShowOwnedPopups(hWnd: HWND; fShow: BOOL): BOOL; stdcall;
{$EXTERNALSYM ShowOwnedPopups}

function OpenIcon(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM OpenIcon}

function CloseWindow(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM CloseWindow}

function MoveWindow(hWnd: HWND; X, Y, nWidth, nHeight: Integer; bRepaint: BOOL): BOOL; stdcall;
{$EXTERNALSYM MoveWindow}

function SetWindowPos(hWnd, hWndInsertAfter: HWND; X, Y, cx, cy: Integer;
  uFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM SetWindowPos}

function GetWindowPlacement(hWnd: HWND; var lpwndpl: WINDOWPLACEMENT): BOOL; stdcall;
{$EXTERNALSYM GetWindowPlacement}

function SetWindowPlacement(hWnd: HWND; const lpwndpl: WINDOWPLACEMENT): BOOL; stdcall;
{$EXTERNALSYM SetWindowPlacement}

function BeginDeferWindowPos(nNumWindows: Integer): HDWP; stdcall;
{$EXTERNALSYM BeginDeferWindowPos}

function DeferWindowPos(hWinPosInfo: HDWP; hWnd, hWndInsertAfter: HWND;
  x, y, cx, cy: Integer; uFlags: UINT): HDWP; stdcall;
{$EXTERNALSYM DeferWindowPos}

function EndDeferWindowPos(hWinPosInfo: HDWP): BOOL; stdcall;
{$EXTERNALSYM EndDeferWindowPos}

function IsWindowVisible(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM IsWindowVisible}

function IsIconic(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM IsIconic}

function AnyPopup: BOOL; stdcall;
{$EXTERNALSYM AnyPopup}

function BringWindowToTop(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM BringWindowToTop}

function IsZoomed(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM IsZoomed}

//
// SetWindowPos Flags
//

const
  SWP_NOSIZE         = $0001;
  {$EXTERNALSYM SWP_NOSIZE}
  SWP_NOMOVE         = $0002;
  {$EXTERNALSYM SWP_NOMOVE}
  SWP_NOZORDER       = $0004;
  {$EXTERNALSYM SWP_NOZORDER}
  SWP_NOREDRAW       = $0008;
  {$EXTERNALSYM SWP_NOREDRAW}
  SWP_NOACTIVATE     = $0010;
  {$EXTERNALSYM SWP_NOACTIVATE}
  SWP_FRAMECHANGED   = $0020; // The frame changed: send WM_NCCALCSIZE
  {$EXTERNALSYM SWP_FRAMECHANGED}
  SWP_SHOWWINDOW     = $0040;
  {$EXTERNALSYM SWP_SHOWWINDOW}
  SWP_HIDEWINDOW     = $0080;
  {$EXTERNALSYM SWP_HIDEWINDOW}
  SWP_NOCOPYBITS     = $0100;
  {$EXTERNALSYM SWP_NOCOPYBITS}
  SWP_NOOWNERZORDER  = $0200; // Don't do owner Z ordering
  {$EXTERNALSYM SWP_NOOWNERZORDER}
  SWP_NOSENDCHANGING = $0400; // Don't send WM_WINDOWPOSCHANGING
  {$EXTERNALSYM SWP_NOSENDCHANGING}

  SWP_DRAWFRAME    = SWP_FRAMECHANGED;
  {$EXTERNALSYM SWP_DRAWFRAME}
  SWP_NOREPOSITION = SWP_NOOWNERZORDER;
  {$EXTERNALSYM SWP_NOREPOSITION}

  SWP_DEFERERASE     = $2000;
  {$EXTERNALSYM SWP_DEFERERASE}
  SWP_ASYNCWINDOWPOS = $4000;
  {$EXTERNALSYM SWP_ASYNCWINDOWPOS}

  HWND_TOP       = HWND(0);
  {$EXTERNALSYM HWND_TOP}
  HWND_BOTTOM    = HWND(1);
  {$EXTERNALSYM HWND_BOTTOM}
  HWND_TOPMOST   = HWND(-1);
  {$EXTERNALSYM HWND_TOPMOST}
  HWND_NOTOPMOST = HWND(-2);
  {$EXTERNALSYM HWND_NOTOPMOST}

//
// WARNING:
// The following structures must NOT be DWORD padded because they are
// followed by strings, etc that do not have to be DWORD aligned.
//

// #include <pshpack2.h>

//
// original NT 32 bit dialog template:
//

type
  DLGTEMPLATE = packed record
    style: DWORD;
    dwExtendedStyle: DWORD;
    cdit: WORD;
    x: short;
    y: short;
    cx: short;
    cy: short;
  end;
  {$EXTERNALSYM DLGTEMPLATE}
  TDlgTemplate = DLGTEMPLATE;

  LPDLGTEMPLATEA = ^DLGTEMPLATE;
  {$EXTERNALSYM LPDLGTEMPLATEA}
  LPDLGTEMPLATEW = ^DLGTEMPLATE;
  {$EXTERNALSYM LPDLGTEMPLATEW}

  LPCDLGTEMPLATEA = ^DLGTEMPLATE;
  {$EXTERNALSYM LPCDLGTEMPLATEA}
  LPCDLGTEMPLATEW = ^DLGTEMPLATE;
  {$EXTERNALSYM LPCDLGTEMPLATEW}

  {$IFDEF UNICODE}
  LPDLGTEMPLATE = LPDLGTEMPLATEW;
  {$EXTERNALSYM LPDLGTEMPLATE}
  LPCDLGTEMPLATE = LPCDLGTEMPLATEW;
  {$EXTERNALSYM LPCDLGTEMPLATE}
  {$ELSE}
  LPDLGTEMPLATE = LPDLGTEMPLATEA;
  {$EXTERNALSYM LPDLGTEMPLATE}
  LPCDLGTEMPLATE = LPCDLGTEMPLATEA;
  {$EXTERNALSYM LPCDLGTEMPLATE}
  {$ENDIF UNICODE}

//
// 32 bit Dialog item template.
//

  DLGITEMTEMPLATE = packed record
    style: DWORD;
    dwExtendedStyle: DWORD;
    x: short;
    y: short;
    cx: short;
    cy: short;
    id: WORD;
  end;
  {$EXTERNALSYM DLGITEMTEMPLATE}
  TDlgItemTemplate = DLGITEMTEMPLATE;

  PDLGITEMTEMPLATEA = ^DLGITEMTEMPLATE;
  {$EXTERNALSYM PDLGITEMTEMPLATE}
  PDLGITEMTEMPLATEW = ^DLGITEMTEMPLATE;
  {$EXTERNALSYM PDLGITEMTEMPLATE}

  LPDLGITEMTEMPLATEA = ^DLGITEMTEMPLATE;
  {$EXTERNALSYM LPDLGITEMTEMPLATE}
  LPDLGITEMTEMPLATEW = ^DLGITEMTEMPLATE;
  {$EXTERNALSYM LPDLGITEMTEMPLATE}

  {$IFDEF UNICODE}
  PDLGITEMTEMPLATE = PDLGITEMTEMPLATEW;
  {$EXTERNALSYM PDLGITEMTEMPLATE}
  LPDLGITEMTEMPLATE = PDLGITEMTEMPLATEW;
  {$EXTERNALSYM LPDLGITEMTEMPLATE}
  {$ELSE}
  PDLGITEMTEMPLATE = PDLGITEMTEMPLATEA;
  {$EXTERNALSYM PDLGITEMTEMPLATE}
  LPDLGITEMTEMPLATE = PDLGITEMTEMPLATEA;
  {$EXTERNALSYM LPDLGITEMTEMPLATE}
  {$ENDIF UNICODE}

// #include <poppack.h> // Resume normal packing//

function CreateDialogParamA(hInstance: HINST; lpTemplateName: LPCSTR;
  hWndParent: HWND; lpDialogFunc: DLGPROC; dwInitParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateDialogParamA}
function CreateDialogParamW(hInstance: HINST; lpTemplateName: LPCWSTR;
  hWndParent: HWND; lpDialogFunc: DLGPROC; dwInitParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateDialogParamW}
function CreateDialogParam(hInstance: HINST; lpTemplateName: LPCTSTR;
  hWndParent: HWND; lpDialogFunc: DLGPROC; dwInitParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateDialogParam}

function CreateDialogIndirectParamA(hInstance: HINST; const lpTemplate: DLGTEMPLATE;
  hWndParent: HWND; lpDialogFunc: DLGPROC; dwInitParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateDialogIndirectParamA}
function CreateDialogIndirectParamW(hInstance: HINST; const lpTemplate: DLGTEMPLATE;
  hWndParent: HWND; lpDialogFunc: DLGPROC; dwInitParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateDialogIndirectParamW}
function CreateDialogIndirectParam(hInstance: HINST; const lpTemplate: DLGTEMPLATE;
  hWndParent: HWND; lpDialogFunc: DLGPROC; dwInitParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateDialogIndirectParam}

function CreateDialogA(hInstance: HINST; lpName: LPCSTR; hWndParent: HWND;
  lpDialogFunc: DLGPROC): HWND;
{$EXTERNALSYM CreateDialogA}
function CreateDialogW(hInstance: HINST; lpName: LPCWSTR; hWndParent: HWND;
  lpDialogFunc: DLGPROC): HWND;
{$EXTERNALSYM CreateDialogW}
function CreateDialog(hInstance: HINST; lpName: LPCTSTR; hWndParent: HWND;
  lpDialogFunc: DLGPROC): HWND;
{$EXTERNALSYM CreateDialog}

function CreateDialogIndirectA(hInstance: HINST; const lpTemplate: DLGTEMPLATE;
  hWndParent: HWND; lpDialogFunc: DLGPROC): HWND;
{$EXTERNALSYM CreateDialogIndirectA}
function CreateDialogIndirectW(hInstance: HINST; const lpTemplate: DLGTEMPLATE;
  hWndParent: HWND; lpDialogFunc: DLGPROC): HWND;
{$EXTERNALSYM CreateDialogIndirectW}
function CreateDialogIndirect(hInstance: HINST; const lpTemplate: DLGTEMPLATE;
  hWndParent: HWND; lpDialogFunc: DLGPROC): HWND;
{$EXTERNALSYM CreateDialogIndirect}

function DialogBoxParamA(hInstance: HINST; lpTemplateName: LPCSTR;
  hWndParent: HWND; lpDialogFunc: DLGPROC; dwInitParam: LPARAM): INT_PTR; stdcall;
{$EXTERNALSYM DialogBoxParamA}
function DialogBoxParamW(hInstance: HINST; lpTemplateName: LPCWSTR;
  hWndParent: HWND; lpDialogFunc: DLGPROC; dwInitParam: LPARAM): INT_PTR; stdcall;
{$EXTERNALSYM DialogBoxParamW}
function DialogBoxParam(hInstance: HINST; lpTemplateName: LPCTSTR;
  hWndParent: HWND; lpDialogFunc: DLGPROC; dwInitParam: LPARAM): INT_PTR; stdcall;
{$EXTERNALSYM DialogBoxParam}

function DialogBoxIndirectParamA(hInstance: HINST;
  const hDialogTemplate: DLGTEMPLATE; hWndParent: HWND; lpDialogFunc: DLGPROC;
  dwInitParam: LPARAM): INT_PTR; stdcall;
{$EXTERNALSYM DialogBoxIndirectParamA}
function DialogBoxIndirectParamW(hInstance: HINST;
  const hDialogTemplate: DLGTEMPLATE; hWndParent: HWND; lpDialogFunc: DLGPROC;
  dwInitParam: LPARAM): INT_PTR; stdcall;
{$EXTERNALSYM DialogBoxIndirectParamW}
function DialogBoxIndirectParam(hInstance: HINST;
  const hDialogTemplate: DLGTEMPLATE; hWndParent: HWND; lpDialogFunc: DLGPROC;
  dwInitParam: LPARAM): INT_PTR; stdcall;
{$EXTERNALSYM DialogBoxIndirectParam}

function DialogBoxA(hInstance: HINST; lpTemplate: LPCSTR; hWndParent: HWND;
  lpDialogFunc: DLGPROC): INT_PTR;
{$EXTERNALSYM DialogBoxA}
function DialogBoxW(hInstance: HINST; lpTemplate: LPCWSTR; hWndParent: HWND;
  lpDialogFunc: DLGPROC): INT_PTR;
{$EXTERNALSYM DialogBoxW}
function DialogBox(hInstance: HINST; lpTemplate: LPCTSTR; hWndParent: HWND;
  lpDialogFunc: DLGPROC): INT_PTR;
{$EXTERNALSYM DialogBox}

function DialogBoxIndirectA(hInstance: HINST; const lpTemplate: DLGTEMPLATE;
  hWndParent: HWND; lpDialogFunc: DLGPROC): INT_PTR;
{$EXTERNALSYM DialogBoxIndirectA}
function DialogBoxIndirectW(hInstance: HINST; const lpTemplate: DLGTEMPLATE;
  hWndParent: HWND; lpDialogFunc: DLGPROC): INT_PTR;
{$EXTERNALSYM DialogBoxIndirectW}
function DialogBoxIndirect(hInstance: HINST; const lpTemplate: DLGTEMPLATE;
  hWndParent: HWND; lpDialogFunc: DLGPROC): INT_PTR;
{$EXTERNALSYM DialogBoxIndirect}

function EndDialog(hDlg: HWND; nResult: INT_PTR): BOOL; stdcall;
{$EXTERNALSYM EndDialog}

function GetDlgItem(hDlg: HWND; nIDDlgItem: Integer): HWND; stdcall;
{$EXTERNALSYM GetDlgItem}

function SetDlgItemInt(hDlg: HWND; nIDDlgItem: Integer; uValue: UINT; bSigned: BOOL): BOOL; stdcall;
{$EXTERNALSYM SetDlgItemInt}

function GetDlgItemInt(hDlg: HWND; nIDDlgItem: Integer; lpTranslated: LPBOOL;
  bSigned: BOOL): UINT; stdcall;
{$EXTERNALSYM GetDlgItemInt}

function SetDlgItemTextA(hDlg: HWND; nIDDlgItem: Integer; lpString: LPCSTR): BOOL; stdcall;
{$EXTERNALSYM SetDlgItemTextA}
function SetDlgItemTextW(hDlg: HWND; nIDDlgItem: Integer; lpString: LPCWSTR): BOOL; stdcall;
{$EXTERNALSYM SetDlgItemTextW}
function SetDlgItemText(hDlg: HWND; nIDDlgItem: Integer; lpString: LPCTSTR): BOOL; stdcall;
{$EXTERNALSYM SetDlgItemText}

function GetDlgItemTextA(hDlg: HWND; nIDDlgItem: Integer; lpString: LPSTR;
  nMaxCount: Integer): UINT; stdcall;
{$EXTERNALSYM GetDlgItemTextA}
function GetDlgItemTextW(hDlg: HWND; nIDDlgItem: Integer; lpString: LPWSTR;
  nMaxCount: Integer): UINT; stdcall;
{$EXTERNALSYM GetDlgItemTextW}
function GetDlgItemText(hDlg: HWND; nIDDlgItem: Integer; lpString: LPTSTR;
  nMaxCount: Integer): UINT; stdcall;
{$EXTERNALSYM GetDlgItemText}

function CheckDlgButton(hDlg: HWND; nIDButton: Integer; uCheck: UINT): BOOL; stdcall;
{$EXTERNALSYM CheckDlgButton}

function CheckRadioButton(hDlg: HWND; nIDFirstButton, nIDLastButton: Integer;
  nIDCheckButton: Integer): BOOL; stdcall;
{$EXTERNALSYM CheckRadioButton}

function IsDlgButtonChecked(hDlg: HWND; nIDButton: Integer): UINT; stdcall;
{$EXTERNALSYM IsDlgButtonChecked}

function SendDlgItemMessageA(hDlg: HWND; nIDDlgItem: Integer; Msg: UINT;
  wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM SendDlgItemMessageA}
function SendDlgItemMessageW(hDlg: HWND; nIDDlgItem: Integer; Msg: UINT;
  wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM SendDlgItemMessageW}
function SendDlgItemMessage(hDlg: HWND; nIDDlgItem: Integer; Msg: UINT;
  wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM SendDlgItemMessage}

function GetNextDlgGroupItem(hDlg: HWND; hCtl: HWND; bPrevious: BOOL): HWND; stdcall;
{$EXTERNALSYM GetNextDlgGroupItem}

function GetNextDlgTabItem(hDlg: HWND; hCtl: HWND; bPrevious: BOOL): HWND; stdcall;
{$EXTERNALSYM GetNextDlgTabItem}

function GetDlgCtrlID(hWnd: HWND): Integer; stdcall;
{$EXTERNALSYM GetDlgCtrlID}

function GetDialogBaseUnits: Longint; stdcall;
{$EXTERNALSYM GetDialogBaseUnits(VOID v)}

function DefDlgProcA(hDlg: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefDlgProcA}
function DefDlgProcW(hDlg: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefDlgProcW}
function DefDlgProc(hDlg: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefDlgProc}

//
// Window extra byted needed for private dialog classes.
//

const
  DLGWINDOWEXTRA = 30;
  {$EXTERNALSYM DLGWINDOWEXTRA}

function CallMsgFilterA(lpMsg: LPMSG; nCode: Integer): BOOL; stdcall;
{$EXTERNALSYM CallMsgFilterA}
function CallMsgFilterW(lpMsg: LPMSG; nCode: Integer): BOOL; stdcall;
{$EXTERNALSYM CallMsgFilterW}
function CallMsgFilter(lpMsg: LPMSG; nCode: Integer): BOOL; stdcall;
{$EXTERNALSYM CallMsgFilter}

//
// Clipboard Manager Functions
//

function OpenClipboard(hWndNewOwner: HWND): BOOL; stdcall;
{$EXTERNALSYM OpenClipboard}

function CloseClipboard: BOOL; stdcall;
{$EXTERNALSYM CloseClipboard}

function GetClipboardSequenceNumber: DWORD; stdcall;
{$EXTERNALSYM GetClipboardSequenceNumber}

function GetClipboardOwner: HWND; stdcall;
{$EXTERNALSYM GetClipboardOwner}

function SetClipboardViewer(hWndNewViewer: HWND): HWND; stdcall;
{$EXTERNALSYM SetClipboardViewer}

function GetClipboardViewer: HWND; stdcall;
{$EXTERNALSYM GetClipboardViewer}

function ChangeClipboardChain(hWndRemove, hWndNewNext: HWND): BOOL; stdcall;
{$EXTERNALSYM ChangeClipboardChain}

function SetClipboardData(uFormat: UINT; hMem: HANDLE): HANDLE; stdcall;
{$EXTERNALSYM SetClipboardData}

function GetClipboardData(uFormat: UINT): HANDLE; stdcall;
{$EXTERNALSYM GetClipboardData}

function RegisterClipboardFormatA(lpszFormat: LPCSTR): UINT; stdcall;
{$EXTERNALSYM RegisterClipboardFormatA}
function RegisterClipboardFormatW(lpszFormat: LPCWSTR): UINT; stdcall;
{$EXTERNALSYM RegisterClipboardFormatW}
function RegisterClipboardFormat(lpszFormat: LPCTSTR): UINT; stdcall;
{$EXTERNALSYM RegisterClipboardFormat}

function CountClipboardFormats: Integer; stdcall;
{$EXTERNALSYM CountClipboardFormats}

function EnumClipboardFormats(format: UINT): UINT; stdcall;
{$EXTERNALSYM EnumClipboardFormats}

function GetClipboardFormatNameA(format: UINT; lpszFormatName: LPSTR;
  cchMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetClipboardFormatNameA}
function GetClipboardFormatNameW(format: UINT; lpszFormatName: LPWSTR;
  cchMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetClipboardFormatNameW}
function GetClipboardFormatName(format: UINT; lpszFormatName: LPTSTR;
  cchMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetClipboardFormatName}

function EmptyClipboard: BOOL; stdcall;
{$EXTERNALSYM EmptyClipboard}

function IsClipboardFormatAvailable(format: UINT): BOOL; stdcall;
{$EXTERNALSYM IsClipboardFormatAvailable}

function GetPriorityClipboardFormat(paFormatPriorityList: PUINT; cFormats: Integer): Integer; stdcall;
{$EXTERNALSYM GetPriorityClipboardFormat}

function GetOpenClipboardWindow: HWND; stdcall;
{$EXTERNALSYM GetOpenClipboardWindow}

//
// Character Translation Routines
//

function CharToOemA(lpszSrc: LPCSTR; lpszDst: LPSTR): BOOL; stdcall;
{$EXTERNALSYM CharToOemA}
function CharToOemW(lpszSrc: LPCWSTR; lpszDst: LPSTR): BOOL; stdcall;
{$EXTERNALSYM CharToOemW}
function CharToOem(lpszSrc: LPCTSTR; lpszDst: LPSTR): BOOL; stdcall;
{$EXTERNALSYM CharToOem}

function OemToCharA(lpszSrc: LPCSTR; lpszDst: LPSTR): BOOL; stdcall;
{$EXTERNALSYM OemToCharA}
function OemToCharW(lpszSrc: LPCSTR; lpszDst: LPWSTR): BOOL; stdcall;
{$EXTERNALSYM OemToCharW}
function OemToChar(lpszSrc: LPCSTR; lpszDst: LPTSTR): BOOL; stdcall;
{$EXTERNALSYM OemToChar}

function CharToOemBuffA(lpszSrc: LPCSTR; lpszDst: LPSTR; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM CharToOemBuffA}
function CharToOemBuffW(lpszSrc: LPCWSTR; lpszDst: LPSTR; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM CharToOemBuffW}
function CharToOemBuff(lpszSrc: LPCTSTR; lpszDst: LPSTR; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM CharToOemBuff}

function OemToCharBuffA(lpszSrc: LPCSTR; lpszDst: LPSTR; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM OemToCharBuffA}
function OemToCharBuffW(lpszSrc: LPCSTR; lpszDst: LPWSTR; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM OemToCharBuffW}
function OemToCharBuff(lpszSrc: LPCSTR; lpszDst: LPTSTR; cchDstLength: DWORD): BOOL; stdcall;
{$EXTERNALSYM OemToCharBuff}

function CharUpperA(lpsz: LPSTR): LPSTR; stdcall;
{$EXTERNALSYM CharUpperA}
function CharUpperW(lpsz: LPWSTR): LPWSTR; stdcall;
{$EXTERNALSYM CharUpperW}
function CharUpper(lpsz: LPTSTR): LPTSTR; stdcall;
{$EXTERNALSYM CharUpper}

function CharUpperBuffA(lpsz: LPSTR; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM CharUpperBuffA}
function CharUpperBuffW(lpsz: LPWSTR; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM CharUpperBuffW}
function CharUpperBuff(lpsz: LPTSTR; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM CharUpperBuff}

function CharLowerA(lpsz: LPSTR): LPSTR; stdcall;
{$EXTERNALSYM CharLowerA}
function CharLowerW(lpsz: LPWSTR): LPWSTR; stdcall;
{$EXTERNALSYM CharLowerW}
function CharLower(lpsz: LPTSTR): LPTSTR; stdcall;
{$EXTERNALSYM CharLower}

function CharLowerBuffA(lpsz: LPSTR; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM CharLowerBuffA}
function CharLowerBuffW(lpsz: LPWSTR; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM CharLowerBuffW}
function CharLowerBuff(lpsz: LPTSTR; cchLength: DWORD): DWORD; stdcall;
{$EXTERNALSYM CharLowerBuff}

function CharNextA(lpsz: LPCSTR): LPSTR; stdcall;
{$EXTERNALSYM CharNextA}
function CharNextW(lpsz: LPCWSTR): LPWSTR; stdcall;
{$EXTERNALSYM CharNextW}
function CharNext(lpsz: LPCTSTR): LPTSTR; stdcall;
{$EXTERNALSYM CharNext}

function CharPrevA(lpszStart: LPCSTR; lpszCurrent: LPCSTR): LPSTR; stdcall;
{$EXTERNALSYM CharPrevA}
function CharPrevW(lpszStart: LPCWSTR; lpszCurrent: LPCWSTR): LPWSTR; stdcall;
{$EXTERNALSYM CharPrevW}
function CharPrev(lpszStart: LPCTSTR; lpszCurrent: LPCTSTR): LPTSTR; stdcall;
{$EXTERNALSYM CharPrev}

function CharNextExA(CodePage: WORD; lpCurrentChar: LPCSTR; dwFlags: DWORD): LPSTR; stdcall;
{$EXTERNALSYM CharNextExA}

function CharPrevExA(CodePage: WORD; lpStart, lpCurrentChar: LPCSTR; dwFlags: DWORD): LPSTR; stdcall;
{$EXTERNALSYM CharPrevExA}

//
// Compatibility defines for character translation routines
//

function AnsiToOem(lpszSrc: LPCSTR; lpszDst: LPSTR): BOOL;
{$EXTERNALSYM AnsiToOem}

function OemToAnsi(lpszSrc: LPCSTR; lpszDst: LPSTR): BOOL;
{$EXTERNALSYM OemToAnsi}

function AnsiToOemBuff(lpszSrc: LPCSTR; lpszDst: LPSTR; cchDstLength: DWORD): BOOL;
{$EXTERNALSYM AnsiToOemBuff}

function OemToAnsiBuff(lpszSrc: LPCSTR; lpszDst: LPSTR; cchDstLength: DWORD): BOOL;
{$EXTERNALSYM OemToAnsiBuff}

function AnsiUpper(lpsz: LPSTR): LPSTR;
{$EXTERNALSYM AnsiUpper}

function AnsiUpperBuff(lpsz: LPSTR; cchLength: DWORD): DWORD;
{$EXTERNALSYM AnsiUpperBuff}

function AnsiLower(lpsz: LPSTR): LPSTR;
{$EXTERNALSYM AnsiLower}

function AnsiLowerBuff(lpsz: LPSTR; cchLength: DWORD): DWORD;
{$EXTERNALSYM AnsiLowerBuff}

function AnsiNext(lpsz: LPCSTR): LPSTR;
{$EXTERNALSYM AnsiNext}

function AnsiPrev(lpszStart: LPCSTR; lpszCurrent: LPCSTR): LPSTR;
{$EXTERNALSYM AnsiPrev}

//
// Language dependent Routines
//

function IsCharAlphaA(ch: CHAR): BOOL; stdcall;
{$EXTERNALSYM IsCharAlphaA}
function IsCharAlphaW(ch: WCHAR): BOOL; stdcall;
{$EXTERNALSYM IsCharAlphaW}
function IsCharAlpha(ch: TCHAR): BOOL; stdcall;
{$EXTERNALSYM IsCharAlpha}

function IsCharAlphaNumericA(ch: CHAR): BOOL; stdcall;
{$EXTERNALSYM IsCharAlphaNumericA}
function IsCharAlphaNumericW(ch: WCHAR): BOOL; stdcall;
{$EXTERNALSYM IsCharAlphaNumericW}
function IsCharAlphaNumeric(ch: TCHAR): BOOL; stdcall;
{$EXTERNALSYM IsCharAlphaNumeric}

function IsCharUpperA(ch: CHAR): BOOL; stdcall;
{$EXTERNALSYM IsCharUpperA}
function IsCharUpperW(ch: WCHAR): BOOL; stdcall;
{$EXTERNALSYM IsCharUpperW}
function IsCharUpper(ch: TCHAR): BOOL; stdcall;
{$EXTERNALSYM IsCharUpper}

function IsCharLowerA(ch: CHAR): BOOL; stdcall;
{$EXTERNALSYM IsCharLowerA}
function IsCharLowerW(ch: WCHAR): BOOL; stdcall;
{$EXTERNALSYM IsCharLowerW}
function IsCharLower(ch: TCHAR): BOOL; stdcall;
{$EXTERNALSYM IsCharLower}

function SetFocus(hWnd: HWND): HWND; stdcall;
{$EXTERNALSYM SetFocus}

function GetActiveWindow: HWND; stdcall;
{$EXTERNALSYM GetActiveWindow}

function GetFocus: HWND; stdcall;
{$EXTERNALSYM GetFocus}

function GetKBCodePage: UINT; stdcall;
{$EXTERNALSYM GetKBCodePage}

function GetKeyState(nVirtKey: Integer): SHORT; stdcall;
{$EXTERNALSYM GetKeyState}

function GetAsyncKeyState(vKey: Integer): SHORT; stdcall;
{$EXTERNALSYM GetAsyncKeyState}

function GetKeyboardState(lpKeyState: LPBYTE): BOOL; stdcall;
{$EXTERNALSYM GetKeyboardState}

function SetKeyboardState(lpKeyState: LPBYTE): BOOL; stdcall;
{$EXTERNALSYM SetKeyboardState}

function GetKeyNameTextA(lParam: LONG; lpString: LPSTR; nSize: Integer): Integer; stdcall;
{$EXTERNALSYM GetKeyNameTextA}
function GetKeyNameTextW(lParam: LONG; lpString: LPWSTR; nSize: Integer): Integer; stdcall;
{$EXTERNALSYM GetKeyNameTextW}
function GetKeyNameText(lParam: LONG; lpString: LPTSTR; nSize: Integer): Integer; stdcall;
{$EXTERNALSYM GetKeyNameText}

function GetKeyboardType(nTypeFlag: Integer): Integer; stdcall;
{$EXTERNALSYM GetKeyboardType}

function ToAscii(uVirtKey, uScanCode: UINT; lpKeyState: PBYTE; lpChar: LPWORD;
  uFlags: UINT): Integer; stdcall;
{$EXTERNALSYM ToAscii}

function ToAsciiEx(uVirtKey, uScanCode: UINT; lpKeyState: PBYTE; lpChar: LPWORD;
  uFlags: UINT; dwhkl: HKL): Integer; stdcall;
{$EXTERNALSYM ToAsciiEx}

function ToUnicode(wVirtKey, wScanCode: UINT; lpKeyState: PBYTE; pwszBuff: LPWSTR;
  cchBuff: Integer; wFlags: UINT): Integer; stdcall;
{$EXTERNALSYM ToUnicode}

function OemKeyScan(wOemChar: WORD): DWORD; stdcall;
{$EXTERNALSYM OemKeyScan}

function VkKeyScanA(ch: CHAR): SHORT; stdcall;
{$EXTERNALSYM VkKeyScanA}
function VkKeyScanW(ch: WCHAR): SHORT; stdcall;
{$EXTERNALSYM VkKeyScanW}
function VkKeyScan(ch: TCHAR): SHORT; stdcall;
{$EXTERNALSYM VkKeyScan}

function VkKeyScanExA(ch: CHAR; dwhkl: HKL): SHORT; stdcall;
{$EXTERNALSYM VkKeyScanExA}
function VkKeyScanExW(ch: WCHAR; dwhkl: HKL): SHORT; stdcall;
{$EXTERNALSYM VkKeyScanExW}
function VkKeyScanEx(ch: TCHAR; dwhkl: HKL): SHORT; stdcall;
{$EXTERNALSYM VkKeyScanEx}

const
  KEYEVENTF_EXTENDEDKEY = $0001;
  {$EXTERNALSYM KEYEVENTF_EXTENDEDKEY}
  KEYEVENTF_KEYUP       = $0002;
  {$EXTERNALSYM KEYEVENTF_KEYUP}

  KEYEVENTF_UNICODE  = $0004;
  {$EXTERNALSYM KEYEVENTF_UNICODE}
  KEYEVENTF_SCANCODE = $0008;
  {$EXTERNALSYM KEYEVENTF_SCANCODE}

procedure keybd_event(bVk, bScan: BYTE; dwFlags: DWORD; dwExtraInfo: ULONG_PTR); stdcall;
{$EXTERNALSYM keybd_event}

const
  MOUSEEVENTF_MOVE        = $0001; // mouse move
  {$EXTERNALSYM MOUSEEVENTF_MOVE}
  MOUSEEVENTF_LEFTDOWN    = $0002; // left button down
  {$EXTERNALSYM MOUSEEVENTF_LEFTDOWN}
  MOUSEEVENTF_LEFTUP      = $0004; // left button up
  {$EXTERNALSYM MOUSEEVENTF_LEFTUP}
  MOUSEEVENTF_RIGHTDOWN   = $0008; // right button down
  {$EXTERNALSYM MOUSEEVENTF_RIGHTDOWN}
  MOUSEEVENTF_RIGHTUP     = $0010; // right button up
  {$EXTERNALSYM MOUSEEVENTF_RIGHTUP}
  MOUSEEVENTF_MIDDLEDOWN  = $0020; // middle button down
  {$EXTERNALSYM MOUSEEVENTF_MIDDLEDOWN}
  MOUSEEVENTF_MIDDLEUP    = $0040; // middle button up
  {$EXTERNALSYM MOUSEEVENTF_MIDDLEUP}
  MOUSEEVENTF_XDOWN       = $0080; // x button down
  {$EXTERNALSYM MOUSEEVENTF_XDOWN}
  MOUSEEVENTF_XUP         = $0100; // x button down
  {$EXTERNALSYM MOUSEEVENTF_XUP}
  MOUSEEVENTF_WHEEL       = $0800; // wheel button rolled
  {$EXTERNALSYM MOUSEEVENTF_WHEEL}
  MOUSEEVENTF_VIRTUALDESK = $4000; // map to entire virtual desktop
  {$EXTERNALSYM MOUSEEVENTF_VIRTUALDESK}
  MOUSEEVENTF_ABSOLUTE    = $8000; // absolute move
  {$EXTERNALSYM MOUSEEVENTF_ABSOLUTE}

procedure mouse_event(dwFlags, dx, dy, dwData: DWORD; dwExtraInfo: ULONG_PTR); stdcall;
{$EXTERNALSYM mouse_event}

type
  LPMOUSEINPUT = ^MOUSEINPUT;
  {$EXTERNALSYM LPMOUSEINPUT}
  tagMOUSEINPUT = record
    dx: LONG;
    dy: LONG;
    mouseData: DWORD;
    dwFlags: DWORD;
    time: DWORD;
    dwExtraInfo: ULONG_PTR;
  end;
  {$EXTERNALSYM MOUSEINPUT}
  MOUSEINPUT = tagMOUSEINPUT;
  {$EXTERNALSYM MOUSEINPUT}
  TMouseInput = MOUSEINPUT;
  PMouseInput = LPMOUSEINPUT;

  LPKEYBDINPUT = ^KEYBDINPUT;
  {$EXTERNALSYM LPKEYBDINPUT}
  tagKEYBDINPUT = record
    wVk: WORD;
    wScan: WORD;
    dwFlags: DWORD;
    time: DWORD;
    dwExtraInfo: ULONG_PTR;
  end;
  {$EXTERNALSYM tagKEYBDINPUT}
  KEYBDINPUT = tagKEYBDINPUT;
  {$EXTERNALSYM KEYBDINPUT}
  TKeybdinput = KEYBDINPUT;
  PKeybdInput = LPKEYBDINPUT;

  LPHARDWAREINPUT = ^HARDWAREINPUT;
  {$EXTERNALSYM LPHARDWAREINPUT}
  tagHARDWAREINPUT = record
    uMsg: DWORD;
    wParamL: WORD;
    wParamH: WORD;
  end;
  {$EXTERNALSYM tagHARDWAREINPUT}
  HARDWAREINPUT = tagHARDWAREINPUT;
  {$EXTERNALSYM HARDWAREINPUT}
  THardwareInput = HARDWAREINPUT;
  PHardwareInput = LPHARDWAREINPUT;

const
  INPUT_MOUSE    = 0;
  {$EXTERNALSYM INPUT_MOUSE}
  INPUT_KEYBOARD = 1;
  {$EXTERNALSYM INPUT_KEYBOARD}
  INPUT_HARDWARE = 2;
  {$EXTERNALSYM INPUT_HARDWARE}

type
  LPINPUT = ^INPUT;
  {$EXTERNALSYM LPINPUT}
  tagINPUT = record
    type_: DWORD;
    case Integer of
      0: (mi: MOUSEINPUT);
      1: (ki: KEYBDINPUT);
      2: (hi: HARDWAREINPUT);
  end;
  {$EXTERNALSYM tagINPUT}
  INPUT = tagINPUT;
  {$EXTERNALSYM INPUT}
  TInput = INPUT;
  PInput = LPINPUT;

function SendInput(cInputs: UINT; pInputs: LPINPUT; cbSize: Integer): UINT; stdcall;
{$EXTERNALSYM SendInput}

type
  PLASTINPUTINFO = ^LASTINPUTINFO;
  tagLASTINPUTINFO = record
    cbSize: UINT;
    dwTime: DWORD;
  end;
  {$EXTERNALSYM tagLASTINPUTINFO}
  LASTINPUTINFO = tagLASTINPUTINFO;
  {$EXTERNALSYM LASTINPUTINFO}
  TLastInputInfo = LASTINPUTINFO;

function GetLastInputInfo(var plii: LASTINPUTINFO): BOOL; stdcall;
{$EXTERNALSYM GetLastInputInfo}

function MapVirtualKeyA(uCode, uMapType: UINT): UINT; stdcall;
{$EXTERNALSYM MapVirtualKeyA}
function MapVirtualKeyW(uCode, uMapType: UINT): UINT; stdcall;
{$EXTERNALSYM MapVirtualKeyW}
function MapVirtualKey(uCode, uMapType: UINT): UINT; stdcall;
{$EXTERNALSYM MapVirtualKey}

function MapVirtualKeyExA(uCode, uMapType: UINT; dwhkl: HKL): UINT; stdcall;
{$EXTERNALSYM MapVirtualKeyExA}
function MapVirtualKeyExW(uCode, uMapType: UINT; dwhkl: HKL): UINT; stdcall;
{$EXTERNALSYM MapVirtualKeyExW}
function MapVirtualKeyEx(uCode, uMapType: UINT; dwhkl: HKL): UINT; stdcall;
{$EXTERNALSYM MapVirtualKeyEx}

function GetInputState: BOOL; stdcall;
{$EXTERNALSYM GetInputState}

function GetQueueStatus(flags: UINT): DWORD; stdcall;
{$EXTERNALSYM GetQueueStatus}

function GetCapture: HWND; stdcall;
{$EXTERNALSYM GetCapture}

function SetCapture(hWnd: HWND): HWND; stdcall;
{$EXTERNALSYM SetCapture}

function ReleaseCapture: BOOL; stdcall;
{$EXTERNALSYM ReleaseCapture}

function MsgWaitForMultipleObjects(nCount: DWORD; pHandles: PHANDLE;
  fWaitAll: BOOL; dwMilliseconds: DWORD; dwWakeMask: DWORD): DWORD; stdcall;
{$EXTERNALSYM MsgWaitForMultipleObjects}

function MsgWaitForMultipleObjectsEx(nCount: DWORD; pHandles: PHANDLE;
  dwMilliseconds: DWORD; dwWakeMask: DWORD; dwFlags: DWORD): DWORD; stdcall;
{$EXTERNALSYM MsgWaitForMultipleObjectsEx}

const
  MWMO_WAITALL        = $0001;
  {$EXTERNALSYM MWMO_WAITALL}
  MWMO_ALERTABLE      = $0002;
  {$EXTERNALSYM MWMO_ALERTABLE}
  MWMO_INPUTAVAILABLE = $0004;
  {$EXTERNALSYM MWMO_INPUTAVAILABLE}

//
// Windows Functions
//

function SetTimer(hWnd: HWND; nIDEvent: UINT_PTR; uElapse: UINT;
  lpTimerFunc: TIMERPROC): UINT_PTR; stdcall;
{$EXTERNALSYM SetTimer}

function KillTimer(hWnd: HWND; uIDEvent: UINT_PTR): BOOL; stdcall;
{$EXTERNALSYM KillTimer}

function IsWindowUnicode(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM IsWindowUnicode}

function EnableWindow(hWnd: HWND; bEnable: BOOL): BOOL; stdcall;
{$EXTERNALSYM EnableWindow}

function IsWindowEnabled(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM IsWindowEnabled}

function LoadAcceleratorsA(hInstance: HINST; lpTableName: LPCSTR): HACCEL; stdcall;
{$EXTERNALSYM LoadAcceleratorsA}
function LoadAcceleratorsW(hInstance: HINST; lpTableName: LPCWSTR): HACCEL; stdcall;
{$EXTERNALSYM LoadAcceleratorsW}
function LoadAccelerators(hInstance: HINST; lpTableName: LPCTSTR): HACCEL; stdcall;
{$EXTERNALSYM LoadAccelerators}

function CreateAcceleratorTableA(lpaccl: LPACCEL; cEntries: Integer): HACCEL; stdcall;
{$EXTERNALSYM CreateAcceleratorTableA}
function CreateAcceleratorTableW(lpaccl: LPACCEL; cEntries: Integer): HACCEL; stdcall;
{$EXTERNALSYM CreateAcceleratorTableW}
function CreateAcceleratorTable(lpaccl: LPACCEL; cEntries: Integer): HACCEL; stdcall;
{$EXTERNALSYM CreateAcceleratorTable}

function DestroyAcceleratorTable(hAccel: HACCEL): BOOL; stdcall;
{$EXTERNALSYM DestroyAcceleratorTable}

function CopyAcceleratorTableA(hAccelSrc: HACCEL; lpAccelDst: LPACCEL;
  cAccelEntries: Integer): Integer; stdcall;
{$EXTERNALSYM CopyAcceleratorTableA}
function CopyAcceleratorTableW(hAccelSrc: HACCEL; lpAccelDst: LPACCEL;
  cAccelEntries: Integer): Integer; stdcall;
{$EXTERNALSYM CopyAcceleratorTableW}
function CopyAcceleratorTable(hAccelSrc: HACCEL; lpAccelDst: LPACCEL;
  cAccelEntries: Integer): Integer; stdcall;
{$EXTERNALSYM CopyAcceleratorTable}

function TranslateAcceleratorA(hWnd: HWND; hAccTable: HACCEL; lpMsg: LPMSG): Integer; stdcall;
{$EXTERNALSYM TranslateAcceleratorA}
function TranslateAcceleratorW(hWnd: HWND; hAccTable: HACCEL; lpMsg: LPMSG): Integer; stdcall;
{$EXTERNALSYM TranslateAcceleratorW}
function TranslateAccelerator(hWnd: HWND; hAccTable: HACCEL; lpMsg: LPMSG): Integer; stdcall;
{$EXTERNALSYM TranslateAccelerator}

//
// GetSystemMetrics() codes
//

const
  SM_CXSCREEN          = 0;
  {$EXTERNALSYM SM_CXSCREEN}
  SM_CYSCREEN          = 1;
  {$EXTERNALSYM SM_CYSCREEN}
  SM_CXVSCROLL         = 2;
  {$EXTERNALSYM SM_CXVSCROLL}
  SM_CYHSCROLL         = 3;
  {$EXTERNALSYM SM_CYHSCROLL}
  SM_CYCAPTION         = 4;
  {$EXTERNALSYM SM_CYCAPTION}
  SM_CXBORDER          = 5;
  {$EXTERNALSYM SM_CXBORDER}
  SM_CYBORDER          = 6;
  {$EXTERNALSYM SM_CYBORDER}
  SM_CXDLGFRAME        = 7;
  {$EXTERNALSYM SM_CXDLGFRAME}
  SM_CYDLGFRAME        = 8;
  {$EXTERNALSYM SM_CYDLGFRAME}
  SM_CYVTHUMB          = 9;
  {$EXTERNALSYM SM_CYVTHUMB}
  SM_CXHTHUMB          = 10;
  {$EXTERNALSYM SM_CXHTHUMB}
  SM_CXICON            = 11;
  {$EXTERNALSYM SM_CXICON}
  SM_CYICON            = 12;
  {$EXTERNALSYM SM_CYICON}
  SM_CXCURSOR          = 13;
  {$EXTERNALSYM SM_CXCURSOR}
  SM_CYCURSOR          = 14;
  {$EXTERNALSYM SM_CYCURSOR}
  SM_CYMENU            = 15;
  {$EXTERNALSYM SM_CYMENU}
  SM_CXFULLSCREEN      = 16;
  {$EXTERNALSYM SM_CXFULLSCREEN}
  SM_CYFULLSCREEN      = 17;
  {$EXTERNALSYM SM_CYFULLSCREEN}
  SM_CYKANJIWINDOW     = 18;
  {$EXTERNALSYM SM_CYKANJIWINDOW}
  SM_MOUSEPRESENT      = 19;
  {$EXTERNALSYM SM_MOUSEPRESENT}
  SM_CYVSCROLL         = 20;
  {$EXTERNALSYM SM_CYVSCROLL}
  SM_CXHSCROLL         = 21;
  {$EXTERNALSYM SM_CXHSCROLL}
  SM_DEBUG             = 22;
  {$EXTERNALSYM SM_DEBUG}
  SM_SWAPBUTTON        = 23;
  {$EXTERNALSYM SM_SWAPBUTTON}
  SM_RESERVED1         = 24;
  {$EXTERNALSYM SM_RESERVED1}
  SM_RESERVED2         = 25;
  {$EXTERNALSYM SM_RESERVED2}
  SM_RESERVED3         = 26;
  {$EXTERNALSYM SM_RESERVED3}
  SM_RESERVED4         = 27;
  {$EXTERNALSYM SM_RESERVED4}
  SM_CXMIN             = 28;
  {$EXTERNALSYM SM_CXMIN}
  SM_CYMIN             = 29;
  {$EXTERNALSYM SM_CYMIN}
  SM_CXSIZE            = 30;
  {$EXTERNALSYM SM_CXSIZE}
  SM_CYSIZE            = 31;
  {$EXTERNALSYM SM_CYSIZE}
  SM_CXFRAME           = 32;
  {$EXTERNALSYM SM_CXFRAME}
  SM_CYFRAME           = 33;
  {$EXTERNALSYM SM_CYFRAME}
  SM_CXMINTRACK        = 34;
  {$EXTERNALSYM SM_CXMINTRACK}
  SM_CYMINTRACK        = 35;
  {$EXTERNALSYM SM_CYMINTRACK}
  SM_CXDOUBLECLK       = 36;
  {$EXTERNALSYM SM_CXDOUBLECLK}
  SM_CYDOUBLECLK       = 37;
  {$EXTERNALSYM SM_CYDOUBLECLK}
  SM_CXICONSPACING     = 38;
  {$EXTERNALSYM SM_CXICONSPACING}
  SM_CYICONSPACING     = 39;
  {$EXTERNALSYM SM_CYICONSPACING}
  SM_MENUDROPALIGNMENT = 40;
  {$EXTERNALSYM SM_MENUDROPALIGNMENT}
  SM_PENWINDOWS        = 41;
  {$EXTERNALSYM SM_PENWINDOWS}
  SM_DBCSENABLED       = 42;
  {$EXTERNALSYM SM_DBCSENABLED}
  SM_CMOUSEBUTTONS     = 43;
  {$EXTERNALSYM SM_CMOUSEBUTTONS}

  SM_CXFIXEDFRAME = SM_CXDLGFRAME; // ;win40 name change
  {$EXTERNALSYM SM_CXFIXEDFRAME}
  SM_CYFIXEDFRAME = SM_CYDLGFRAME; // ;win40 name change
  {$EXTERNALSYM SM_CYFIXEDFRAME}
  SM_CXSIZEFRAME  = SM_CXFRAME; // ;win40 name change
  {$EXTERNALSYM SM_CXSIZEFRAME}
  SM_CYSIZEFRAME  = SM_CYFRAME; // ;win40 name change
  {$EXTERNALSYM SM_CYSIZEFRAME}

  SM_SECURE       = 44;
  {$EXTERNALSYM SM_SECURE}
  SM_CXEDGE       = 45;
  {$EXTERNALSYM SM_CXEDGE}
  SM_CYEDGE       = 46;
  {$EXTERNALSYM SM_CYEDGE}
  SM_CXMINSPACING = 47;
  {$EXTERNALSYM SM_CXMINSPACING}
  SM_CYMINSPACING = 48;
  {$EXTERNALSYM SM_CYMINSPACING}
  SM_CXSMICON     = 49;
  {$EXTERNALSYM SM_CXSMICON}
  SM_CYSMICON     = 50;
  {$EXTERNALSYM SM_CYSMICON}
  SM_CYSMCAPTION  = 51;
  {$EXTERNALSYM SM_CYSMCAPTION}
  SM_CXSMSIZE     = 52;
  {$EXTERNALSYM SM_CXSMSIZE}
  SM_CYSMSIZE     = 53;
  {$EXTERNALSYM SM_CYSMSIZE}
  SM_CXMENUSIZE   = 54;
  {$EXTERNALSYM SM_CXMENUSIZE}
  SM_CYMENUSIZE   = 55;
  {$EXTERNALSYM SM_CYMENUSIZE}
  SM_ARRANGE      = 56;
  {$EXTERNALSYM SM_ARRANGE}
  SM_CXMINIMIZED  = 57;
  {$EXTERNALSYM SM_CXMINIMIZED}
  SM_CYMINIMIZED  = 58;
  {$EXTERNALSYM SM_CYMINIMIZED}
  SM_CXMAXTRACK   = 59;
  {$EXTERNALSYM SM_CXMAXTRACK}
  SM_CYMAXTRACK   = 60;
  {$EXTERNALSYM SM_CYMAXTRACK}
  SM_CXMAXIMIZED  = 61;
  {$EXTERNALSYM SM_CXMAXIMIZED}
  SM_CYMAXIMIZED  = 62;
  {$EXTERNALSYM SM_CYMAXIMIZED}
  SM_NETWORK      = 63;
  {$EXTERNALSYM SM_NETWORK}
  SM_CLEANBOOT    = 67;
  {$EXTERNALSYM SM_CLEANBOOT}
  SM_CXDRAG       = 68;
  {$EXTERNALSYM SM_CXDRAG}
  SM_CYDRAG       = 69;
  {$EXTERNALSYM SM_CYDRAG}
  SM_SHOWSOUNDS = 70;
  {$EXTERNALSYM SM_SHOWSOUNDS}
  SM_CXMENUCHECK    = 71; // Use instead of GetMenuCheckMarkDimensions()!
  {$EXTERNALSYM SM_CXMENUCHECK}
  SM_CYMENUCHECK    = 72;
  {$EXTERNALSYM SM_CYMENUCHECK}
  SM_SLOWMACHINE    = 73;
  {$EXTERNALSYM SM_SLOWMACHINE}
  SM_MIDEASTENABLED = 74;
  {$EXTERNALSYM SM_MIDEASTENABLED}

  SM_MOUSEWHEELPRESENT = 75;
  {$EXTERNALSYM SM_MOUSEWHEELPRESENT}
  SM_XVIRTUALSCREEN    = 76;
  {$EXTERNALSYM SM_XVIRTUALSCREEN}
  SM_YVIRTUALSCREEN    = 77;
  {$EXTERNALSYM SM_YVIRTUALSCREEN}
  SM_CXVIRTUALSCREEN   = 78;
  {$EXTERNALSYM SM_CXVIRTUALSCREEN}
  SM_CYVIRTUALSCREEN   = 79;
  {$EXTERNALSYM SM_CYVIRTUALSCREEN}
  SM_CMONITORS         = 80;
  {$EXTERNALSYM SM_CMONITORS}
  SM_SAMEDISPLAYFORMAT = 81;
  {$EXTERNALSYM SM_SAMEDISPLAYFORMAT}
  SM_IMMENABLED        = 82;
  {$EXTERNALSYM SM_IMMENABLED}
  SM_CXFOCUSBORDER     = 83;
  {$EXTERNALSYM SM_CXFOCUSBORDER}
  SM_CYFOCUSBORDER     = 84;
  {$EXTERNALSYM SM_CYFOCUSBORDER}

//#if(_WIN32_WINNT >= 0x0501)

  SM_TABLETPC          = 86;
  {$EXTERNALSYM SM_TABLETPC}
  SM_MEDIACENTER       = 87;
  {$EXTERNALSYM SM_MEDIACENTER}

//#endif /* _WIN32_WINNT >= 0x0501 */

const
  {$IFNDEF WIN98ME_UP}
  SM_CMETRICS          = 76;
  {$ELSE}
  {$IFDEF WIN98ME}
  SM_CMETRICS          = 83;
  {$ELSE}
  SM_CMETRICS          = 88;
  {$ENDIF WIN98ME}
  {$ENDIF !WIN98ME_UP}
  {$EXTERNALSYM SM_CMETRICS}

  SM_REMOTESESSION = $1000;
  {$EXTERNALSYM SM_REMOTESESSION}
  SM_SHUTTINGDOWN  = $2000;
  {$EXTERNALSYM SM_SHUTTINGDOWN}
//#if(WINVER >= 0x0501)
  SM_REMOTECONTROL = $2001;
  {$EXTERNALSYM SM_REMOTECONTROL}
//#endif /* WINVER >= 0x0501 */

function GetSystemMetrics(nIndex: Integer): Integer; stdcall;
{$EXTERNALSYM GetSystemMetrics}

function LoadMenuA(hInstance: HINST; lpMenuName: LPCSTR): HMENU; stdcall;
{$EXTERNALSYM LoadMenuA}
function LoadMenuW(hInstance: HINST; lpMenuName: LPCWSTR): HMENU; stdcall;
{$EXTERNALSYM LoadMenuW}
function LoadMenu(hInstance: HINST; lpMenuName: LPCTSTR): HMENU; stdcall;
{$EXTERNALSYM LoadMenu}

function LoadMenuIndirectA(lpMenuTemplate: LPMENUTEMPLATEA): HMENU; stdcall;
{$EXTERNALSYM LoadMenuIndirectA}
function LoadMenuIndirectW(lpMenuTemplate: LPMENUTEMPLATEW): HMENU; stdcall;
{$EXTERNALSYM LoadMenuIndirectW}
function LoadMenuIndirect(lpMenuTemplate: LPMENUTEMPLATE): HMENU; stdcall;
{$EXTERNALSYM LoadMenuIndirect}

function GetMenu(hWnd: HWND): HMENU; stdcall;
{$EXTERNALSYM GetMenu}

function SetMenu(hWnd: HWND; hMenu: HMENU): BOOL; stdcall;
{$EXTERNALSYM SetMenu}

function ChangeMenuA(hMenu: HMENU; cmd: UINT; lpszNewItem: LPCSTR;
  cmdInsert: UINT; flags: UINT): BOOL; stdcall;
{$EXTERNALSYM ChangeMenuA}
function ChangeMenuW(hMenu: HMENU; cmd: UINT; lpszNewItem: LPCWSTR;
  cmdInsert: UINT; flags: UINT): BOOL; stdcall;
{$EXTERNALSYM ChangeMenuW}
function ChangeMenu(hMenu: HMENU; cmd: UINT; lpszNewItem: LPCTSTR;
  cmdInsert: UINT; flags: UINT): BOOL; stdcall;
{$EXTERNALSYM ChangeMenu}

function HiliteMenuItem(hWnd: HWND; hMenu: HMENU; uIDHiliteItem: UINT; uHilite: UINT): BOOL; stdcall;
{$EXTERNALSYM HiliteMenuItem}

function GetMenuStringA(hMenu: HMENU; uIDItem: UINT; lpString: LPSTR;
  nMaxCount: Integer; uFlag: UINT): Integer; stdcall;
{$EXTERNALSYM GetMenuStringA}
function GetMenuStringW(hMenu: HMENU; uIDItem: UINT; lpString: LPWSTR;
  nMaxCount: Integer; uFlag: UINT): Integer; stdcall;
{$EXTERNALSYM GetMenuStringW}
function GetMenuString(hMenu: HMENU; uIDItem: UINT; lpString: LPTSTR;
  nMaxCount: Integer; uFlag: UINT): Integer; stdcall;
{$EXTERNALSYM GetMenuString}

function GetMenuState(hMenu: HMENU; uId, uFlags: UINT): UINT; stdcall;
{$EXTERNALSYM GetMenuState}

function DrawMenuBar(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM DrawMenuBar}

const
  PMB_ACTIVE = $00000001;
  {$EXTERNALSYM PMB_ACTIVE}
  
function GetSystemMenu(hWnd: HWND; bRevert: BOOL): HMENU; stdcall;
{$EXTERNALSYM GetSystemMenu}

function CreateMenu: HMENU; stdcall;
{$EXTERNALSYM CreateMenu}

function CreatePopupMenu: HMENU; stdcall;
{$EXTERNALSYM CreatePopupMenu}

function DestroyMenu(hMenu: HMENU): BOOL; stdcall;
{$EXTERNALSYM DestroyMenu}

function CheckMenuItem(hMenu: HMENU; uIDCheckItem, uCheck: UINT): DWORD; stdcall;
{$EXTERNALSYM CheckMenuItem}

function EnableMenuItem(hMenu: HMENU; uIDEnableItem, uEnable: UINT): BOOL; stdcall;
{$EXTERNALSYM EnableMenuItem}

function GetSubMenu(hMenu: HMENU; nPos: Integer): HMENU; stdcall;
{$EXTERNALSYM GetSubMenu}

function GetMenuItemID(hMenu: HMENU; nPos: Integer): UINT; stdcall;
{$EXTERNALSYM GetMenuItemID}

function GetMenuItemCount(hMenu: HMENU): Integer; stdcall;
{$EXTERNALSYM GetMenuItemCount}

function InsertMenuA(hMenu: HMENU; uPosition, uFlags: UINT; uIDNewItem: UINT_PTR;
  lpNewItem: LPCSTR): BOOL; stdcall;
{$EXTERNALSYM InsertMenuA}
function InsertMenuW(hMenu: HMENU; uPosition, uFlags: UINT; uIDNewItem: UINT_PTR;
  lpNewItem: LPCWSTR): BOOL; stdcall;
{$EXTERNALSYM InsertMenuW}
function InsertMenu(hMenu: HMENU; uPosition, uFlags: UINT; uIDNewItem: UINT_PTR;
  lpNewItem: LPCTSTR): BOOL; stdcall;
{$EXTERNALSYM InsertMenu}

function AppendMenuA(hMenu: HMENU; uFlags: UINT; uIDNewItem: UINT_PTR;
  lpNewItem: LPCSTR): BOOL; stdcall;
{$EXTERNALSYM AppendMenuA}
function AppendMenuW(hMenu: HMENU; uFlags: UINT; uIDNewItem: UINT_PTR;
  lpNewItem: LPCWSTR): BOOL; stdcall;
{$EXTERNALSYM AppendMenuW}
function AppendMenu(hMenu: HMENU; uFlags: UINT; uIDNewItem: UINT_PTR;
  lpNewItem: LPCTSTR): BOOL; stdcall;
{$EXTERNALSYM AppendMenu}

function ModifyMenuA(hMnu: HMENU; uPosition: UINT; uFlags: UINT;
  uIDNewItem: UINT_PTR; lpNewItem: LPCSTR): BOOL; stdcall;
{$EXTERNALSYM ModifyMenuA}
function ModifyMenuW(hMnu: HMENU; uPosition: UINT; uFlags: UINT;
  uIDNewItem: UINT_PTR; lpNewItem: LPCWSTR): BOOL; stdcall;
{$EXTERNALSYM ModifyMenuW}
function ModifyMenu(hMnu: HMENU; uPosition: UINT; uFlags: UINT;
  uIDNewItem: UINT_PTR; lpNewItem: LPCTSTR): BOOL; stdcall;
{$EXTERNALSYM ModifyMenu}

function RemoveMenu(hMenu: HMENU; uPosition: UINT; uFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM RemoveMenu}

function DeleteMenu(hMenu: HMENU; uPosition: UINT; uFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM DeleteMenu}

function SetMenuItemBitmaps(hMenu: HMENU; uPosition: UINT; uFlags: UINT;
  hBitmapUnchecked: HBITMAP; hBitmapChecked: HBITMAP): BOOL; stdcall;
{$EXTERNALSYM SetMenuItemBitmaps}

function GetMenuCheckMarkDimensions: LONG; stdcall;
{$EXTERNALSYM GetMenuCheckMarkDimensions}

function TrackPopupMenu(hMenu: HMENU; uFlags: UINT; x: Integer; y: Integer;
  nReserved: Integer; hWnd: HWND; prcRect: LPRECT): BOOL; stdcall;
{$EXTERNALSYM TrackPopupMenu}

// return codes for WM_MENUCHAR//

const
  MNC_IGNORE  = 0;
  {$EXTERNALSYM MNC_IGNORE}
  MNC_CLOSE   = 1;
  {$EXTERNALSYM MNC_CLOSE}
  MNC_EXECUTE = 2;
  {$EXTERNALSYM MNC_EXECUTE}
  MNC_SELECT  = 3;
  {$EXTERNALSYM MNC_SELECT}

type
  LPTPMPARAMS = ^TPMPARAMS;
  {$EXTERNALSYM LPTPMPARAMS}
  tagTPMPARAMS = record
    cbSize: UINT;    // Size of structure
    rcExclude: RECT; // Screen coordinates of rectangle to exclude when positioning
  end;
  {$EXTERNALSYM tagTPMPARAMS}
  TPMPARAMS = tagTPMPARAMS;
  {$EXTERNALSYM TPMPARAMS}
  TTPMParams = TPMPARAMS;
  PTPMParams = LPTPMPARAMS;

function TrackPopupMenuEx(hmenu: HMENU; fuflags: UINT; x, y: Integer;
  hwnd: HWND; lptpm: LPTPMPARAMS): BOOL; stdcall;
{$EXTERNALSYM TrackPopupMenuEx}

const
  MNS_NOCHECK     = $80000000;
  {$EXTERNALSYM MNS_NOCHECK}
  MNS_MODELESS    = $40000000;
  {$EXTERNALSYM MNS_MODELESS}
  MNS_DRAGDROP    = $20000000;
  {$EXTERNALSYM MNS_DRAGDROP}
  MNS_AUTODISMISS = $10000000;
  {$EXTERNALSYM MNS_AUTODISMISS}
  MNS_NOTIFYBYPOS = $08000000;
  {$EXTERNALSYM MNS_NOTIFYBYPOS}
  MNS_CHECKORBMP  = $04000000;
  {$EXTERNALSYM MNS_CHECKORBMP}

  MIM_MAXHEIGHT       = $00000001;
  {$EXTERNALSYM MIM_MAXHEIGHT}
  MIM_BACKGROUND      = $00000002;
  {$EXTERNALSYM MIM_BACKGROUND}
  MIM_HELPID          = $00000004;
  {$EXTERNALSYM MIM_HELPID}
  MIM_MENUDATA        = $00000008;
  {$EXTERNALSYM MIM_MENUDATA}
  MIM_STYLE           = $00000010;
  {$EXTERNALSYM MIM_STYLE}
  MIM_APPLYTOSUBMENUS = $80000000;
  {$EXTERNALSYM MIM_APPLYTOSUBMENUS}

type
  LPMENUINFO = ^MENUINFO;
  {$EXTERNALSYM LPMENUINFO}
  tagMENUINFO = record
    cbSize: DWORD;
    fMask: DWORD;
    dwStyle: DWORD;
    cyMax: UINT;
    hbrBack: HBRUSH;
    dwContextHelpID: DWORD;
    dwMenuData: ULONG_PTR;
  end;
  {$EXTERNALSYM tagMENUINFO}
  MENUINFO = tagMENUINFO;
  {$EXTERNALSYM MENUINFO}
  TMenuinfo = MENUINFO;
  PMenuinfo = LPMENUINFO;

  LPCMENUINFO = ^MENUINFO;
  {$EXTERNALSYM LPCMENUINFO}

function GetMenuInfo(hmenu: HMENU; var lpcmi: MENUINFO): BOOL; stdcall;
{$EXTERNALSYM GetMenuInfo}

function SetMenuInfo(hemnu: HMENU; const lpcmi: MENUINFO): BOOL; stdcall;
{$EXTERNALSYM SetMenuInfo}

function EndMenu: BOOL; stdcall;
{$EXTERNALSYM EndMenu}

//
// WM_MENUDRAG return values.
//

const
  MND_CONTINUE = 0;
  {$EXTERNALSYM MND_CONTINUE}
  MND_ENDMENU  = 1;
  {$EXTERNALSYM MND_ENDMENU}

type
  PMENUGETOBJECTINFO = ^MENUGETOBJECTINFO;
  tagMENUGETOBJECTINFO = record
    dwFlags: DWORD;
    uPos: UINT;
    hmenu: HMENU;
    riid: PVOID;
    pvObj: PVOID;
  end;
  {$EXTERNALSYM tagMENUGETOBJECTINFO}
  MENUGETOBJECTINFO = tagMENUGETOBJECTINFO;
  {$EXTERNALSYM MENUGETOBJECTINFO}
  TMenuGetObjectInfo = MENUGETOBJECTINFO;

//
// MENUGETOBJECTINFO dwFlags values
//

const
  MNGOF_TOPGAP    = $00000001;
  {$EXTERNALSYM MNGOF_TOPGAP}
  MNGOF_BOTTOMGAP = $00000002;
  {$EXTERNALSYM MNGOF_BOTTOMGAP}

//
// WM_MENUGETOBJECT return values
//

  MNGO_NOINTERFACE = $00000000;
  {$EXTERNALSYM MNGO_NOINTERFACE}
  MNGO_NOERROR     = $00000001;
  {$EXTERNALSYM MNGO_NOERROR}

  MIIM_STATE      = $00000001;
  {$EXTERNALSYM MIIM_STATE}
  MIIM_ID         = $00000002;
  {$EXTERNALSYM MIIM_ID}
  MIIM_SUBMENU    = $00000004;
  {$EXTERNALSYM MIIM_SUBMENU}
  MIIM_CHECKMARKS = $00000008;
  {$EXTERNALSYM MIIM_CHECKMARKS}
  MIIM_TYPE       = $00000010;
  {$EXTERNALSYM MIIM_TYPE}
  MIIM_DATA       = $00000020;
  {$EXTERNALSYM MIIM_DATA}

  MIIM_STRING = $00000040;
  {$EXTERNALSYM MIIM_STRING}
  MIIM_BITMAP = $00000080;
  {$EXTERNALSYM MIIM_BITMAP}
  MIIM_FTYPE  = $00000100;
  {$EXTERNALSYM MIIM_FTYPE}

  HBMMENU_CALLBACK        = HBITMAP(-1);
  {$EXTERNALSYM HBMMENU_CALLBACK}
  HBMMENU_SYSTEM          = HBITMAP(1);
  {$EXTERNALSYM HBMMENU_SYSTEM}
  HBMMENU_MBAR_RESTORE    = HBITMAP(2);
  {$EXTERNALSYM HBMMENU_MBAR_RESTORE}
  HBMMENU_MBAR_MINIMIZE   = HBITMAP(3);
  {$EXTERNALSYM HBMMENU_MBAR_MINIMIZE}
  HBMMENU_MBAR_CLOSE      = HBITMAP(5);
  {$EXTERNALSYM HBMMENU_MBAR_CLOSE}
  HBMMENU_MBAR_CLOSE_D    = HBITMAP(6);
  {$EXTERNALSYM HBMMENU_MBAR_CLOSE_D}
  HBMMENU_MBAR_MINIMIZE_D = HBITMAP(7);
  {$EXTERNALSYM HBMMENU_MBAR_MINIMIZE_D}
  HBMMENU_POPUP_CLOSE     = HBITMAP(8);
  {$EXTERNALSYM HBMMENU_POPUP_CLOSE}
  HBMMENU_POPUP_RESTORE   = HBITMAP(9);
  {$EXTERNALSYM HBMMENU_POPUP_RESTORE}
  HBMMENU_POPUP_MAXIMIZE  = HBITMAP(10);
  {$EXTERNALSYM HBMMENU_POPUP_MAXIMIZE}
  HBMMENU_POPUP_MINIMIZE  = HBITMAP(11);
  {$EXTERNALSYM HBMMENU_POPUP_MINIMIZE}

type
  LPMENUITEMINFOA = ^MENUITEMINFOA;
  {$EXTERNALSYM LPMENUITEMINFOA}
  tagMENUITEMINFOA = record
    cbSize: UINT;
    fMask: UINT;
    fType: UINT;            // used if MIIM_TYPE (4.0) or MIIM_FTYPE (>4.0)
    fState: UINT;           // used if MIIM_STATE
    wID: UINT;              // used if MIIM_ID
    hSubMenu: HMENU;        // used if MIIM_SUBMENU
    hbmpChecked: HBITMAP;   // used if MIIM_CHECKMARKS
    hbmpUnchecked: HBITMAP; // used if MIIM_CHECKMARKS
    dwItemData: ULONG_PTR;  // used if MIIM_DATA
    dwTypeData: LPSTR;      // used if MIIM_TYPE (4.0) or MIIM_STRING (>4.0)
    cch: UINT;              // used if MIIM_TYPE (4.0) or MIIM_STRING (>4.0)
    {$IFDEF WIN98ME_UP}
    hbmpItem: HBITMAP;      // used if MIIM_BITMAP
    {$ENDIF WIN98ME_UP}
  end;
  {$EXTERNALSYM tagMENUITEMINFOA}
  MENUITEMINFOA = tagMENUITEMINFOA;
  {$EXTERNALSYM MENUITEMINFOA}
  TMenuItemInfoA = MENUITEMINFOA;
  PMenuItemInfoA = LPMENUITEMINFOA;

  LPMENUITEMINFOW = ^MENUITEMINFOW;
  {$EXTERNALSYM LPMENUITEMINFOW}
  tagMENUITEMINFOW = record
    cbSize: UINT;
    fMask: UINT;
    fType: UINT;            // used if MIIM_TYPE (4.0) or MIIM_FTYPE (>4.0)
    fState: UINT;           // used if MIIM_STATE
    wID: UINT;              // used if MIIM_ID
    hSubMenu: HMENU;        // used if MIIM_SUBMENU
    hbmpChecked: HBITMAP;   // used if MIIM_CHECKMARKS
    hbmpUnchecked: HBITMAP; // used if MIIM_CHECKMARKS
    dwItemData: ULONG_PTR;  // used if MIIM_DATA
    dwTypeData: LPWSTR;     // used if MIIM_TYPE (4.0) or MIIM_STRING (>4.0)
    cch: UINT;              // used if MIIM_TYPE (4.0) or MIIM_STRING (>4.0)
    {$IFDEF WIN98ME_UP}
    hbmpItem: HBITMAP;      // used if MIIM_BITMAP
    {$ENDIF WIN98ME_UP}
  end;
  {$EXTERNALSYM tagMENUITEMINFOW}
  MENUITEMINFOW = tagMENUITEMINFOW;
  {$EXTERNALSYM MENUITEMINFOW}
  TMenuItemInfoW = MENUITEMINFOW;
  PMenuItemInfoW = LPMENUITEMINFOW;

  LPCMENUITEMINFOA = ^MENUITEMINFOA;
  {$EXTERNALSYM LPCMENUITEMINFOA}
  LPCMENUITEMINFOW = ^MENUITEMINFOW;
  {$EXTERNALSYM LPCMENUITEMINFOW}

  {$IFDEF UNICODE}
  MENUITEMINFO = MENUITEMINFOW;
  {$EXTERNALSYM MENUITEMINFO}
  LPMENUITEMINFO = LPMENUITEMINFOW;
  {$EXTERNALSYM LPMENUITEMINFO}
  TMenuItemInfo = TMenuItemInfoW;
  PMenuItemInfo = PMenuItemInfoW;
  LPCMENUITEMINFO = LPCMENUITEMINFOW;
  {$EXTERNALSYM LPCMENUITEMINFO}
  {$ELSE}
  MENUITEMINFO = MENUITEMINFOA;
  {$EXTERNALSYM MENUITEMINFO}
  LPMENUITEMINFO = LPMENUITEMINFOA;
  {$EXTERNALSYM LPMENUITEMINFO}
  TMenuItemInfo = TMenuItemInfoA;
  PMenuItemInfo = PMenuItemInfoA;
  LPCMENUITEMINFO = LPCMENUITEMINFOA;
  {$EXTERNALSYM LPCMENUITEMINFO}
  {$ENDIF UNICODE}

function InsertMenuItemA(hMenu: HMENU; uItem: UINT; fByPosition: BOOL;
  const lpmii: MENUITEMINFOA): BOOL; stdcall;
{$EXTERNALSYM InsertMenuItemA}
function InsertMenuItemW(hMenu: HMENU; uItem: UINT; fByPosition: BOOL;
  const lpmii: MENUITEMINFOW): BOOL; stdcall;
{$EXTERNALSYM InsertMenuItemW}
function InsertMenuItem(hMenu: HMENU; uItem: UINT; fByPosition: BOOL;
  const lpmii: MENUITEMINFO): BOOL; stdcall;
{$EXTERNALSYM InsertMenuItem}

function GetMenuItemInfoA(hMenu: HMENU; uItem: UINT; fByPosition: BOOL;
  var lpmii: MENUITEMINFOA): BOOL; stdcall;
{$EXTERNALSYM GetMenuItemInfoA}
function GetMenuItemInfoW(hMenu: HMENU; uItem: UINT; fByPosition: BOOL;
  var lpmii: MENUITEMINFOW): BOOL; stdcall;
{$EXTERNALSYM GetMenuItemInfoW}
function GetMenuItemInfo(hMenu: HMENU; uItem: UINT; fByPosition: BOOL;
  var lpmii: MENUITEMINFO): BOOL; stdcall;
{$EXTERNALSYM GetMenuItemInfo}

function SetMenuItemInfoA(hMenu: HMENU; uItem: UINT; fByPosition: BOOL;
  const lpmii: MENUITEMINFOA): BOOL; stdcall;
{$EXTERNALSYM SetMenuItemInfoA}
function SetMenuItemInfoW(hMenu: HMENU; uItem: UINT; fByPosition: BOOL;
  const lpmii: MENUITEMINFOW): BOOL; stdcall;
{$EXTERNALSYM SetMenuItemInfoW}
function SetMenuItemInfo(hMenu: HMENU; uItem: UINT; fByPosition: BOOL;
  const lpmii: MENUITEMINFO): BOOL; stdcall;
{$EXTERNALSYM SetMenuItemInfo}

const
  GMDI_USEDISABLED  = $0001;
  {$EXTERNALSYM GMDI_USEDISABLED}
  GMDI_GOINTOPOPUPS = $0002;
  {$EXTERNALSYM GMDI_GOINTOPOPUPS}

function GetMenuDefaultItem(hMenu: HMENU; fByPos, gmdiFlags: UINT): UINT; stdcall;
{$EXTERNALSYM GetMenuDefaultItem}

function SetMenuDefaultItem(hMenu: HMENU; uItem, fByPos: UINT): BOOL; stdcall;
{$EXTERNALSYM SetMenuDefaultItem}

function GetMenuItemRect(hWnd: HWND; hMenu: HMENU; uItem: UINT; var lprcItem: RECT): BOOL; stdcall;
{$EXTERNALSYM GetMenuItemRect}

function MenuItemFromPoint(hWnd: HWND; hMenu: HMENU; ptScreen: POINT): Integer; stdcall;
{$EXTERNALSYM MenuItemFromPoint}

//
// Flags for TrackPopupMenu
//

const
  TPM_LEFTBUTTON   = $0000;
  {$EXTERNALSYM TPM_LEFTBUTTON}
  TPM_RIGHTBUTTON  = $0002;
  {$EXTERNALSYM TPM_RIGHTBUTTON}
  TPM_LEFTALIGN    = $0000;
  {$EXTERNALSYM TPM_LEFTALIGN}
  TPM_CENTERALIGN  = $0004;
  {$EXTERNALSYM TPM_CENTERALIGN}
  TPM_RIGHTALIGN   = $0008;
  {$EXTERNALSYM TPM_RIGHTALIGN}
  TPM_TOPALIGN     = $0000;
  {$EXTERNALSYM TPM_TOPALIGN}
  TPM_VCENTERALIGN = $0010;
  {$EXTERNALSYM TPM_VCENTERALIGN}
  TPM_BOTTOMALIGN  = $0020;
  {$EXTERNALSYM TPM_BOTTOMALIGN}

  TPM_HORIZONTAL      = $0000; // Horz alignment matters more
  {$EXTERNALSYM TPM_HORIZONTAL}
  TPM_VERTICAL        = $0040; // Vert alignment matters more
  {$EXTERNALSYM TPM_VERTICAL}
  TPM_NONOTIFY        = $0080; // Don't send any notification msgs
  {$EXTERNALSYM TPM_NONOTIFY}
  TPM_RETURNCMD       = $0100;
  {$EXTERNALSYM TPM_RETURNCMD}
  TPM_RECURSE         = $0001;
  {$EXTERNALSYM TPM_RECURSE}
  TPM_HORPOSANIMATION = $0400;
  {$EXTERNALSYM TPM_HORPOSANIMATION}
  TPM_HORNEGANIMATION = $0800;
  {$EXTERNALSYM TPM_HORNEGANIMATION}
  TPM_VERPOSANIMATION = $1000;
  {$EXTERNALSYM TPM_VERPOSANIMATION}
  TPM_VERNEGANIMATION = $2000;
  {$EXTERNALSYM TPM_VERNEGANIMATION}
  TPM_NOANIMATION     = $4000;
  {$EXTERNALSYM TPM_NOANIMATION}
  TPM_LAYOUTRTL       = $8000;
  {$EXTERNALSYM TPM_LAYOUTRTL}
  
//
// Drag-and-drop support
// Obsolete - use OLE instead
//

type
  LPDROPSTRUCT = ^DROPSTRUCT;
  {$EXTERNALSYM LPDROPSTRUCT}
  tagDROPSTRUCT = record
    hwndSource: HWND;
    hwndSink: HWND;
    wFmt: DWORD;
    dwData: ULONG_PTR;
    ptDrop: POINT;
    dwControlData: DWORD;
  end;
  {$EXTERNALSYM tagDROPSTRUCT}
  DROPSTRUCT = tagDROPSTRUCT;
  {$EXTERNALSYM DROPSTRUCT}
  TDropStruct = DROPSTRUCT;
  PDropStruct = LPDROPSTRUCT;

const
  DOF_EXECUTABLE = $8001; // wFmt flags
  {$EXTERNALSYM DOF_EXECUTABLE}
  DOF_DOCUMENT   = $8002;
  {$EXTERNALSYM DOF_DOCUMENT}
  DOF_DIRECTORY  = $8003;
  {$EXTERNALSYM DOF_DIRECTORY}
  DOF_MULTIPLE   = $8004;
  {$EXTERNALSYM DOF_MULTIPLE}
  DOF_PROGMAN    = $0001;
  {$EXTERNALSYM DOF_PROGMAN}
  DOF_SHELLDATA  = $0002;
  {$EXTERNALSYM DOF_SHELLDATA}

  DO_DROPFILE  = $454C4946;
  {$EXTERNALSYM DO_DROPFILE}
  DO_PRINTFILE = $544E5250;
  {$EXTERNALSYM DO_PRINTFILE}

function DragObject(hwnd1, hwnd2: HWND; i: UINT; u: ULONG_PTR; hcursor: HCURSOR): DWORD; stdcall;
{$EXTERNALSYM DragObject}

function DragDetect(hwnd: HWND; pt: POINT): BOOL; stdcall;
{$EXTERNALSYM DragDetect}

function DrawIcon(hDC: HDC; X, Y: Integer; hIcon: HICON): BOOL; stdcall;
{$EXTERNALSYM DrawIcon}

//
// DrawText() Format Flags
//

const
  DT_TOP             = $00000000;
  {$EXTERNALSYM DT_TOP}
  DT_LEFT            = $00000000;
  {$EXTERNALSYM DT_LEFT}
  DT_CENTER          = $00000001;
  {$EXTERNALSYM DT_CENTER}
  DT_RIGHT           = $00000002;
  {$EXTERNALSYM DT_RIGHT}
  DT_VCENTER         = $00000004;
  {$EXTERNALSYM DT_VCENTER}
  DT_BOTTOM          = $00000008;
  {$EXTERNALSYM DT_BOTTOM}
  DT_WORDBREAK       = $00000010;
  {$EXTERNALSYM DT_WORDBREAK}
  DT_SINGLELINE      = $00000020;
  {$EXTERNALSYM DT_SINGLELINE}
  DT_EXPANDTABS      = $00000040;
  {$EXTERNALSYM DT_EXPANDTABS}
  DT_TABSTOP         = $00000080;
  {$EXTERNALSYM DT_TABSTOP}
  DT_NOCLIP          = $00000100;
  {$EXTERNALSYM DT_NOCLIP}
  DT_EXTERNALLEADING = $00000200;
  {$EXTERNALSYM DT_EXTERNALLEADING}
  DT_CALCRECT        = $00000400;
  {$EXTERNALSYM DT_CALCRECT}
  DT_NOPREFIX        = $00000800;
  {$EXTERNALSYM DT_NOPREFIX}
  DT_INTERNAL        = $00001000;
  {$EXTERNALSYM DT_INTERNAL}

  DT_EDITCONTROL          = $00002000;
  {$EXTERNALSYM DT_EDITCONTROL}
  DT_PATH_ELLIPSIS        = $00004000;
  {$EXTERNALSYM DT_PATH_ELLIPSIS}
  DT_END_ELLIPSIS         = $00008000;
  {$EXTERNALSYM DT_END_ELLIPSIS}
  DT_MODIFYSTRING         = $00010000;
  {$EXTERNALSYM DT_MODIFYSTRING}
  DT_RTLREADING           = $00020000;
  {$EXTERNALSYM DT_RTLREADING}
  DT_WORD_ELLIPSIS        = $00040000;
  {$EXTERNALSYM DT_WORD_ELLIPSIS}
  DT_NOFULLWIDTHCHARBREAK = $00080000;
  {$EXTERNALSYM DT_NOFULLWIDTHCHARBREAK}
  DT_HIDEPREFIX           = $00100000;
  {$EXTERNALSYM DT_HIDEPREFIX}
  DT_PREFIXONLY           = $00200000;
  {$EXTERNALSYM DT_PREFIXONLY}

type
  LPDRAWTEXTPARAMS = ^DRAWTEXTPARAMS;
  {$EXTERNALSYM LPDRAWTEXTPARAMS}
  tagDRAWTEXTPARAMS = record
    cbSize: UINT;
    iTabLength: Integer;
    iLeftMargin: Integer;
    iRightMargin: Integer;
    uiLengthDrawn: UINT;
  end;
  {$EXTERNALSYM tagDRAWTEXTPARAMS}
  DRAWTEXTPARAMS = tagDRAWTEXTPARAMS;
  {$EXTERNALSYM DRAWTEXTPARAMS}
  TDrawTextParams = DRAWTEXTPARAMS;
  PDrawTextParams = LPDRAWTEXTPARAMS;

function DrawTextA(hDC: HDC; lpString: LPCSTR; nCount: Integer;
  var lpRect: RECT; uFormat: UINT): Integer; stdcall;
{$EXTERNALSYM DrawTextA}
function DrawTextW(hDC: HDC; lpString: LPCWSTR; nCount: Integer;
  var lpRect: RECT; uFormat: UINT): Integer; stdcall;
{$EXTERNALSYM DrawTextW}
function DrawText(hDC: HDC; lpString: LPCTSTR; nCount: Integer;
  var lpRect: RECT; uFormat: UINT): Integer; stdcall;
{$EXTERNALSYM DrawText}

function DrawTextExA(hDc: HDC; lpchText: LPSTR; cchText: Integer;
  var lprc: RECT; dwDTFormat: UINT; lpDTParams: LPDRAWTEXTPARAMS): Integer; stdcall;
{$EXTERNALSYM DrawTextExA}
function DrawTextExW(hDc: HDC; lpchText: LPWSTR; cchText: Integer;
  var lprc: RECT; dwDTFormat: UINT; lpDTParams: LPDRAWTEXTPARAMS): Integer; stdcall;
{$EXTERNALSYM DrawTextExW}
function DrawTextEx(hDc: HDC; lpchText: LPTSTR; cchText: Integer;
  var lprc: RECT; dwDTFormat: UINT; lpDTParams: LPDRAWTEXTPARAMS): Integer; stdcall;
{$EXTERNALSYM DrawTextEx}

function GrayStringA(hDC: HDC; hBrush: HBRUSH; lpOutputFunc: GRAYSTRINGPROC;
  lpData: LPARAM; nCount, X, Y, nWidth, nHeight: Integer): BOOL; stdcall;
{$EXTERNALSYM GrayStringA}
function GrayStringW(hDC: HDC; hBrush: HBRUSH; lpOutputFunc: GRAYSTRINGPROC;
  lpData: LPARAM; nCount, X, Y, nWidth, nHeight: Integer): BOOL; stdcall;
{$EXTERNALSYM GrayStringW}
function GrayString(hDC: HDC; hBrush: HBRUSH; lpOutputFunc: GRAYSTRINGPROC;
  lpData: LPARAM; nCount, X, Y, nWidth, nHeight: Integer): BOOL; stdcall;
{$EXTERNALSYM GrayString}

// Monolithic state-drawing routine//
// Image type//

const
  DST_COMPLEX    = $0000;
  {$EXTERNALSYM DST_COMPLEX}
  DST_TEXT       = $0001;
  {$EXTERNALSYM DST_TEXT}
  DST_PREFIXTEXT = $0002;
  {$EXTERNALSYM DST_PREFIXTEXT}
  DST_ICON       = $0003;
  {$EXTERNALSYM DST_ICON}
  DST_BITMAP     = $0004;
  {$EXTERNALSYM DST_BITMAP}

// State type//

  DSS_NORMAL     = $0000;
  {$EXTERNALSYM DSS_NORMAL}
  DSS_UNION      = $0010; // Gray string appearance
  {$EXTERNALSYM DSS_UNION}
  DSS_DISABLED   = $0020;
  {$EXTERNALSYM DSS_DISABLED}
  DSS_MONO       = $0080;
  {$EXTERNALSYM DSS_MONO}
  DSS_HIDEPREFIX = $0200;
  {$EXTERNALSYM DSS_HIDEPREFIX}
  DSS_PREFIXONLY = $0400;
  {$EXTERNALSYM DSS_PREFIXONLY}
  DSS_RIGHT      = $8000;
  {$EXTERNALSYM DSS_RIGHT}

function DrawStateA(hdc: HDC; hbr: HBRUSH; lputputFunc: DRAWSTATEPROC;
  lData: LPARAM; wData: WPARAM; x, y, cx, cy: Integer; fuFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM DrawStateA}
function DrawStateW(hdc: HDC; hbr: HBRUSH; lputputFunc: DRAWSTATEPROC;
  lData: LPARAM; wData: WPARAM; x, y, cx, cy: Integer; fuFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM DrawStateW}
function DrawState(hdc: HDC; hbr: HBRUSH; lputputFunc: DRAWSTATEPROC;
  lData: LPARAM; wData: WPARAM; x, y, cx, cy: Integer; fuFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM DrawState}

function TabbedTextOutA(hDC: HDC; X, Y: Integer; lpString: LPCSTR; nCount,
  nTabPositions: Integer; lpnTabStopPositions: LPINT; nTabOrigin: Integer): LONG; stdcall;
{$EXTERNALSYM TabbedTextOutA}
function TabbedTextOutW(hDC: HDC; X, Y: Integer; lpString: LPCWSTR; nCount,
  nTabPositions: Integer; lpnTabStopPositions: LPINT; nTabOrigin: Integer): LONG; stdcall;
{$EXTERNALSYM TabbedTextOutW}
function TabbedTextOut(hDC: HDC; X, Y: Integer; lpString: LPCTSTR; nCount,
  nTabPositions: Integer; lpnTabStopPositions: LPINT; nTabOrigin: Integer): LONG; stdcall;
{$EXTERNALSYM TabbedTextOut}

function GetTabbedTextExtentA(hDC: HDC; lpString: LPCSTR; nCount,
  nTabPositions: Integer; lpnTabStopPositions: LPINT): DWORD; stdcall;
{$EXTERNALSYM GetTabbedTextExtentA}
function GetTabbedTextExtentW(hDC: HDC; lpString: LPCWSTR; nCount,
  nTabPositions: Integer; lpnTabStopPositions: LPINT): DWORD; stdcall;
{$EXTERNALSYM GetTabbedTextExtentW}
function GetTabbedTextExtent(hDC: HDC; lpString: LPCTSTR; nCount,
  nTabPositions: Integer; lpnTabStopPositions: LPINT): DWORD; stdcall;
{$EXTERNALSYM GetTabbedTextExtent}

function UpdateWindow(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM UpdateWindow}

function SetActiveWindow(hWnd: HWND): HWND; stdcall;
{$EXTERNALSYM SetActiveWindow}

function GetForegroundWindow: HWND; stdcall;
{$EXTERNALSYM GetForegroundWindow}

function PaintDesktop(hdc: HDC): BOOL; stdcall;
{$EXTERNALSYM PaintDesktop}

procedure SwitchToThisWindow(hwnd: HWND; fUnknown: BOOL); stdcall;
{$EXTERNALSYM SwitchToThisWindow}

function SetForegroundWindow(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM SetForegroundWindow}

function AllowSetForegroundWindow(dwProcessId: DWORD): BOOL; stdcall;
{$EXTERNALSYM AllowSetForegroundWindow}

const
  ASFW_ANY = DWORD(-1);
  {$EXTERNALSYM ASFW_ANY}

function LockSetForegroundWindow(uLockCode: UINT): BOOL; stdcall;
{$EXTERNALSYM LockSetForegroundWindow}

const
  LSFW_LOCK   = 1;
  {$EXTERNALSYM LSFW_LOCK}
  LSFW_UNLOCK = 2;
  {$EXTERNALSYM LSFW_UNLOCK}

function WindowFromDC(hDC: HDC): HWND; stdcall;
{$EXTERNALSYM WindowFromDC}

function GetDC(hWnd: HWND): HDC; stdcall;
{$EXTERNALSYM GetDC}

function GetDCEx(hWnd: HWND; hrgnClip: HRGN; flags: DWORD): HDC; stdcall;
{$EXTERNALSYM GetDCEx}

//
// GetDCEx() flags
//

const
  DCX_WINDOW           = $00000001;
  {$EXTERNALSYM DCX_WINDOW}
  DCX_CACHE            = $00000002;
  {$EXTERNALSYM DCX_CACHE}
  DCX_NORESETATTRS     = $00000004;
  {$EXTERNALSYM DCX_NORESETATTRS}
  DCX_CLIPCHILDREN     = $00000008;
  {$EXTERNALSYM DCX_CLIPCHILDREN}
  DCX_CLIPSIBLINGS     = $00000010;
  {$EXTERNALSYM DCX_CLIPSIBLINGS}
  DCX_PARENTCLIP       = $00000020;
  {$EXTERNALSYM DCX_PARENTCLIP}
  DCX_EXCLUDERGN       = $00000040;
  {$EXTERNALSYM DCX_EXCLUDERGN}
  DCX_INTERSECTRGN     = $00000080;
  {$EXTERNALSYM DCX_INTERSECTRGN}
  DCX_EXCLUDEUPDATE    = $00000100;
  {$EXTERNALSYM DCX_EXCLUDEUPDATE}
  DCX_INTERSECTUPDATE  = $00000200;
  {$EXTERNALSYM DCX_INTERSECTUPDATE}
  DCX_LOCKWINDOWUPDATE = $00000400;
  {$EXTERNALSYM DCX_LOCKWINDOWUPDATE}

  DCX_VALIDATE = $00200000;
  {$EXTERNALSYM DCX_VALIDATE}

function GetWindowDC(hWnd: HWND): HDC; stdcall;
{$EXTERNALSYM GetWindowDC}

function ReleaseDC(hWnd: HWND; hDC: HDC): Integer; stdcall;
{$EXTERNALSYM ReleaseDC}

function BeginPaint(hWnd: HWND; var lpPaint: PAINTSTRUCT): HDC; stdcall;
{$EXTERNALSYM BeginPaint}

function EndPaint(hWnd: HWND; const lpPaint: PAINTSTRUCT): BOOL; stdcall;
{$EXTERNALSYM EndPaint}

function GetUpdateRect(hWnd: HWND; var lpRect: RECT; bErase: BOOL): BOOL; stdcall;
{$EXTERNALSYM GetUpdateRect}

function GetUpdateRgn(hWnd: HWND; hRgn: HRGN; bErase: BOOL): Integer; stdcall;
{$EXTERNALSYM GetUpdateRgn}

function SetWindowRgn(hWnd: HWND; hRgn: HRGN; bRedraw: BOOL): Integer; stdcall;
{$EXTERNALSYM SetWindowRgn}

function GetWindowRgn(hWnd: HWND; hRgn: HRGN): Integer; stdcall;
{$EXTERNALSYM GetWindowRgn}

function GetWindowRgnBox(hWnd: HWND; var lprc: RECT): Integer; stdcall;
{$EXTERNALSYM GetWindowRgnBox}

function ExcludeUpdateRgn(hDC: HDC; hWnd: HWND): Integer; stdcall;
{$EXTERNALSYM ExcludeUpdateRgn}

function InvalidateRect(hWnd: HWND; lpRect: LPRECT; bErase: BOOL): BOOL; stdcall;
{$EXTERNALSYM InvalidateRect}

function ValidateRect(hWnd: HWND; lpRect: LPRECT): BOOL; stdcall;
{$EXTERNALSYM ValidateRect}

function InvalidateRgn(hWnd: HWND; hRgn: HRGN; bErase: BOOL): BOOL; stdcall;
{$EXTERNALSYM InvalidateRgn}

function ValidateRgn(hWnd: HWND; hRgn: HRGN): BOOL; stdcall;
{$EXTERNALSYM ValidateRgn}

function RedrawWindow(hWnd: HWND; lprcUpdate: LPRECT; hrgnUpdate: HRGN; flags: UINT): BOOL; stdcall;
{$EXTERNALSYM RedrawWindow}

//
// RedrawWindow() flags
//

const
  RDW_INVALIDATE    = $0001;
  {$EXTERNALSYM RDW_INVALIDATE}
  RDW_INTERNALPAINT = $0002;
  {$EXTERNALSYM RDW_INTERNALPAINT}
  RDW_ERASE         = $0004;
  {$EXTERNALSYM RDW_ERASE}

  RDW_VALIDATE        = $0008;
  {$EXTERNALSYM RDW_VALIDATE}
  RDW_NOINTERNALPAINT = $0010;
  {$EXTERNALSYM RDW_NOINTERNALPAINT}
  RDW_NOERASE         = $0020;
  {$EXTERNALSYM RDW_NOERASE}

  RDW_NOCHILDREN  = $0040;
  {$EXTERNALSYM RDW_NOCHILDREN}
  RDW_ALLCHILDREN = $0080;
  {$EXTERNALSYM RDW_ALLCHILDREN}

  RDW_UPDATENOW = $0100;
  {$EXTERNALSYM RDW_UPDATENOW}
  RDW_ERASENOW  = $0200;
  {$EXTERNALSYM RDW_ERASENOW}

  RDW_FRAME   = $0400;
  {$EXTERNALSYM RDW_FRAME}
  RDW_NOFRAME = $0800;
  {$EXTERNALSYM RDW_NOFRAME}

//
// LockWindowUpdate API
//

function LockWindowUpdate(hWndLock: HWND): BOOL; stdcall;
{$EXTERNALSYM LockWindowUpdate}

function ScrollWindow(hWnd: HWND; XAmount, YAmount: Integer; lpRect, lpClipRect: LPRECT): BOOL; stdcall;
{$EXTERNALSYM ScrollWindow}

function ScrollDC(hDC: HDC; dx, dy: Integer; lprcScroll, lprcClip: LPRECT;
  hrgnUpdate: HRGN; lprcUpdate: LPRECT): BOOL; stdcall;
{$EXTERNALSYM ScrollDC}

function ScrollWindowEx(hWnd: HWND; dx, dy: Integer; prcScroll, prcClip: LPRECT;
  hrgnUpdate: HRGN; prcUpdate: LPRECT; flags: UINT): Integer; stdcall;
{$EXTERNALSYM ScrollWindowEx}

const
  SW_SCROLLCHILDREN = $0001; // Scroll children within *lprcScroll.
  {$EXTERNALSYM SW_SCROLLCHILDREN}
  SW_INVALIDATE     = $0002; // Invalidate after scrolling
  {$EXTERNALSYM SW_INVALIDATE}
  SW_ERASE          = $0004; // If SW_INVALIDATE, don't send WM_ERASEBACKGROUND
  {$EXTERNALSYM SW_ERASE}
  SW_SMOOTHSCROLL   = $0010; // Use smooth scrolling
  {$EXTERNALSYM SW_SMOOTHSCROLL}

function SetScrollPos(hWnd: HWND; nBar, nPos: Integer; bRedraw: BOOL): Integer; stdcall;
{$EXTERNALSYM SetScrollPos}

function GetScrollPos(hWnd: HWND; nBar: Integer): Integer; stdcall;
{$EXTERNALSYM GetScrollPos}

function SetScrollRange(hWnd: HWND; nBar, nMinPos, nMaxPos: Integer; bRedraw: BOOL): BOOL; stdcall;
{$EXTERNALSYM SetScrollRange}

function GetScrollRange(hWnd: HWND; nBar: Integer; var lpMinPos, lpMaxPos: Integer): BOOL; stdcall;
{$EXTERNALSYM GetScrollRange}

function ShowScrollBar(hWnd: HWND; wBar: Integer; bShow: BOOL): BOOL; stdcall;
{$EXTERNALSYM ShowScrollBar}

function EnableScrollBar(hWnd: HWND; wSBflags, wArrows: UINT): BOOL; stdcall;
{$EXTERNALSYM EnableScrollBar}

//
// EnableScrollBar() flags
//

const
  ESB_ENABLE_BOTH  = $0000;
  {$EXTERNALSYM ESB_ENABLE_BOTH}
  ESB_DISABLE_BOTH = $0003;
  {$EXTERNALSYM ESB_DISABLE_BOTH}

  ESB_DISABLE_LEFT  = $0001;
  {$EXTERNALSYM ESB_DISABLE_LEFT}
  ESB_DISABLE_RIGHT = $0002;
  {$EXTERNALSYM ESB_DISABLE_RIGHT}

  ESB_DISABLE_UP   = $0001;
  {$EXTERNALSYM ESB_DISABLE_UP}
  ESB_DISABLE_DOWN = $0002;
  {$EXTERNALSYM ESB_DISABLE_DOWN}

  ESB_DISABLE_LTUP = ESB_DISABLE_LEFT;
  {$EXTERNALSYM ESB_DISABLE_LTUP}
  ESB_DISABLE_RTDN = ESB_DISABLE_RIGHT;
  {$EXTERNALSYM ESB_DISABLE_RTDN}

function SetPropA(hWnd: HWND; lpString: LPCSTR; hData: HANDLE): BOOL; stdcall;
{$EXTERNALSYM SetPropA}
function SetPropW(hWnd: HWND; lpString: LPCWSTR; hData: HANDLE): BOOL; stdcall;
{$EXTERNALSYM SetPropW}
function SetProp(hWnd: HWND; lpString: LPCTSTR; hData: HANDLE): BOOL; stdcall;
{$EXTERNALSYM SetProp}

function GetPropA(hWnd: HWND; lpString: LPCSTR): HANDLE; stdcall;
{$EXTERNALSYM GetPropA}
function GetPropW(hWnd: HWND; lpString: LPCWSTR): HANDLE; stdcall;
{$EXTERNALSYM GetPropW}
function GetProp(hWnd: HWND; lpString: LPCTSTR): HANDLE; stdcall;
{$EXTERNALSYM GetProp}

function RemovePropA(hWnd: HWND; lpString: LPCSTR): HANDLE; stdcall;
{$EXTERNALSYM RemovePropA}
function RemovePropW(hWnd: HWND; lpString: LPCWSTR): HANDLE; stdcall;
{$EXTERNALSYM RemovePropW}
function RemoveProp(hWnd: HWND; lpString: LPCTSTR): HANDLE; stdcall;
{$EXTERNALSYM RemoveProp}

function EnumPropsExA(hWnd: HWND; lpEnumFunc: PROPENUMPROCEXA; lParam: LPARAM): Integer; stdcall;
{$EXTERNALSYM EnumPropsExA}
function EnumPropsExW(hWnd: HWND; lpEnumFunc: PROPENUMPROCEXW; lParam: LPARAM): Integer; stdcall;
{$EXTERNALSYM EnumPropsExW}
function EnumPropsEx(hWnd: HWND; lpEnumFunc: PROPENUMPROCEX; lParam: LPARAM): Integer; stdcall;
{$EXTERNALSYM EnumPropsEx}

function EnumPropsA(hWnd: HWND; lpEnumFunc: PROPENUMPROCA): Integer; stdcall;
{$EXTERNALSYM EnumPropsA}
function EnumPropsW(hWnd: HWND; lpEnumFunc: PROPENUMPROCW): Integer; stdcall;
{$EXTERNALSYM EnumPropsW}
function EnumProps(hWnd: HWND; lpEnumFunc: PROPENUMPROC): Integer; stdcall;
{$EXTERNALSYM EnumProps}

function SetWindowTextA(hWnd: HWND; lpString: LPCSTR): BOOL; stdcall;
{$EXTERNALSYM SetWindowTextA}
function SetWindowTextW(hWnd: HWND; lpString: LPCWSTR): BOOL; stdcall;
{$EXTERNALSYM SetWindowTextW}
function SetWindowText(hWnd: HWND; lpString: LPCTSTR): BOOL; stdcall;
{$EXTERNALSYM SetWindowText}

function GetWindowTextA(hWnd: HWND; lpString: LPSTR; nMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetWindowTextA}
function GetWindowTextW(hWnd: HWND; lpString: LPWSTR; nMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetWindowTextW}
function GetWindowText(hWnd: HWND; lpString: LPTSTR; nMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetWindowText}

function GetWindowTextLengthA(hWnd: HWND): Integer; stdcall;
{$EXTERNALSYM GetWindowTextLengthA}
function GetWindowTextLengthW(hWnd: HWND): Integer; stdcall;
{$EXTERNALSYM GetWindowTextLengthW}
function GetWindowTextLength(hWnd: HWND): Integer; stdcall;
{$EXTERNALSYM GetWindowTextLength}

function GetClientRect(hWnd: HWND; var lpRect: RECT): BOOL; stdcall;
{$EXTERNALSYM GetClientRect}

function GetWindowRect(hWnd: HWND; var lpRect: RECT): BOOL; stdcall;
{$EXTERNALSYM GetWindowRect}

function AdjustWindowRect(var lpRect: RECT; dwStyle: DWORD; bMenu: BOOL): BOOL; stdcall;
{$EXTERNALSYM AdjustWindowRect}

function AdjustWindowRectEx(var lpRect: RECT; dwStyle: DWORD;
  bMenu: BOOL; dwExStyle: DWORD): BOOL; stdcall;
{$EXTERNALSYM AdjustWindowRectEx}

const
  HELPINFO_WINDOW   = $0001;
  {$EXTERNALSYM HELPINFO_WINDOW}
  HELPINFO_MENUITEM = $0002;
  {$EXTERNALSYM HELPINFO_MENUITEM}

type
  LPHELPINFO = ^HELPINFO;
  {$EXTERNALSYM LPHELPINFO}
  tagHELPINFO = record      // Structure pointed to by lParam of WM_HELP//
    cbSize: UINT;           // Size in bytes of this struct //
    iContextType: Integer;  // Either HELPINFO_WINDOW or HELPINFO_MENUITEM//
    iCtrlId: Integer;       // Control Id or a Menu item Id.//
    hItemHandle: HANDLE;    // hWnd of control or hMenu.    //
    dwContextId: DWORD_PTR; // Context Id associated with this item//
    MousePos: POINT;        // Mouse Position in screen co-ordinates//
  end;
  {$EXTERNALSYM tagHELPINFO}
  HELPINFO = tagHELPINFO;
  {$EXTERNALSYM HELPINFO}
  THelpInfo = HELPINFO;
  PHelpInfo = LPHELPINFO;

function SetWindowContextHelpId(hwnd: HWND; dwContextHelpId: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetWindowContextHelpId}

function GetWindowContextHelpId(hwnd: HWND): DWORD; stdcall;
{$EXTERNALSYM GetWindowContextHelpId}

function SetMenuContextHelpId(hmenu: HMENU; dwContextHelpId: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetMenuContextHelpId}

function GetMenuContextHelpId(hmenu: HMENU): DWORD; stdcall;
{$EXTERNALSYM GetMenuContextHelpId}

//
// MessageBox() Flags
//

const
  MB_OK                = $00000000;
  {$EXTERNALSYM MB_OK}
  MB_OKCANCEL          = $00000001;
  {$EXTERNALSYM MB_OKCANCEL}
  MB_ABORTRETRYIGNORE  = $00000002;
  {$EXTERNALSYM MB_ABORTRETRYIGNORE}
  MB_YESNOCANCEL       = $00000003;
  {$EXTERNALSYM MB_YESNOCANCEL}
  MB_YESNO             = $00000004;
  {$EXTERNALSYM MB_YESNO}
  MB_RETRYCANCEL       = $00000005;
  {$EXTERNALSYM MB_RETRYCANCEL}
  MB_CANCELTRYCONTINUE = $00000006;
  {$EXTERNALSYM MB_CANCELTRYCONTINUE}

  MB_ICONHAND        = $00000010;
  {$EXTERNALSYM MB_ICONHAND}
  MB_ICONQUESTION    = $00000020;
  {$EXTERNALSYM MB_ICONQUESTION}
  MB_ICONEXCLAMATION = $00000030;
  {$EXTERNALSYM MB_ICONEXCLAMATION}
  MB_ICONASTERISK    = $00000040;
  {$EXTERNALSYM MB_ICONASTERISK}

  MB_USERICON    = $00000080;
  {$EXTERNALSYM MB_USERICON}
  MB_ICONWARNING = MB_ICONEXCLAMATION;
  {$EXTERNALSYM MB_ICONWARNING}
  MB_ICONERROR   = MB_ICONHAND;
  {$EXTERNALSYM MB_ICONERROR}

  MB_ICONINFORMATION = MB_ICONASTERISK;
  {$EXTERNALSYM MB_ICONINFORMATION}
  MB_ICONSTOP        = MB_ICONHAND;
  {$EXTERNALSYM MB_ICONSTOP}

  MB_DEFBUTTON1 = $00000000;
  {$EXTERNALSYM MB_DEFBUTTON1}
  MB_DEFBUTTON2 = $00000100;
  {$EXTERNALSYM MB_DEFBUTTON2}
  MB_DEFBUTTON3 = $00000200;
  {$EXTERNALSYM MB_DEFBUTTON3}
  MB_DEFBUTTON4 = $00000300;
  {$EXTERNALSYM MB_DEFBUTTON4}

  MB_APPLMODAL   = $00000000;
  {$EXTERNALSYM MB_APPLMODAL}
  MB_SYSTEMMODAL = $00001000;
  {$EXTERNALSYM MB_SYSTEMMODAL}
  MB_TASKMODAL   = $00002000;
  {$EXTERNALSYM MB_TASKMODAL}
  MB_HELP        = $00004000; // Help Button
  {$EXTERNALSYM MB_HELP}

  MB_NOFOCUS              = $00008000;
  {$EXTERNALSYM MB_NOFOCUS}
  MB_SETFOREGROUND        = $00010000;
  {$EXTERNALSYM MB_SETFOREGROUND}
  MB_DEFAULT_DESKTOP_ONLY = $00020000;
  {$EXTERNALSYM MB_DEFAULT_DESKTOP_ONLY}

  MB_TOPMOST    = $00040000;
  {$EXTERNALSYM MB_TOPMOST}
  MB_RIGHT      = $00080000;
  {$EXTERNALSYM MB_RIGHT}
  MB_RTLREADING = $00100000;
  {$EXTERNALSYM MB_RTLREADING}

const
  {$IFDEF WINNT4_UP}
  MB_SERVICE_NOTIFICATION = $00200000;
  {$EXTERNALSYM MB_SERVICE_NOTIFICATION}
  {$ELSE}
  MB_SERVICE_NOTIFICATION = $00040000;
  {$EXTERNALSYM MB_SERVICE_NOTIFICATION}
  {$ENDIF WINNT4_UP}

  MB_TYPEMASK = $0000000F;
  {$EXTERNALSYM MB_TYPEMASK}
  MB_ICONMASK = $000000F0;
  {$EXTERNALSYM MB_ICONMASK}
  MB_DEFMASK  = $00000F00;
  {$EXTERNALSYM MB_DEFMASK}
  MB_MODEMASK = $00003000;
  {$EXTERNALSYM MB_MODEMASK}
  MB_MISCMASK = $0000C000;
  {$EXTERNALSYM MB_MISCMASK}

function MessageBoxA(hWnd: HWND; lpText, lpCaption: LPCSTR; uType: UINT): Integer; stdcall;
{$EXTERNALSYM MessageBoxA}
function MessageBoxW(hWnd: HWND; lpText, lpCaption: LPCWSTR; uType: UINT): Integer; stdcall;
{$EXTERNALSYM MessageBoxW}
function MessageBox(hWnd: HWND; lpText, lpCaption: LPCTSTR; uType: UINT): Integer; stdcall;
{$EXTERNALSYM MessageBox}

function MessageBoxExA(hWnd: HWND; lpText, lpCaption: LPCSTR; uType: UINT;
  wLanguageId: WORD): Integer; stdcall;
{$EXTERNALSYM MessageBoxExA}
function MessageBoxExW(hWnd: HWND; lpText, lpCaption: LPCWSTR; uType: UINT;
  wLanguageId: WORD): Integer; stdcall;
{$EXTERNALSYM MessageBoxExW}
function MessageBoxEx(hWnd: HWND; lpText, lpCaption: LPCTSTR; uType: UINT;
  wLanguageId: WORD): Integer; stdcall;
{$EXTERNALSYM MessageBoxEx}

type
  MSGBOXCALLBACK = procedure(var lpHelpInfo: HELPINFO); stdcall;
  {$EXTERNALSYM MSGBOXCALLBACK}
  TMsgBoxCallback = MSGBOXCALLBACK;

  LPMSGBOXPARAMSA = ^MSGBOXPARAMSA;
  {$EXTERNALSYM LPMSGBOXPARAMSA}
  tagMSGBOXPARAMSA = record
    cbSize: UINT;
    hwndOwner: HWND;
    hInstance: HINST;
    lpszText: LPCSTR;
    lpszCaption: LPCSTR;
    dwStyle: DWORD;
    lpszIcon: LPCSTR;
    dwContextHelpId: DWORD_PTR;
    lpfnMsgBoxCallback: MSGBOXCALLBACK;
    dwLanguageId: DWORD;
  end;
  {$EXTERNALSYM tagMSGBOXPARAMSA}
  MSGBOXPARAMSA = tagMSGBOXPARAMSA;
  {$EXTERNALSYM MSGBOXPARAMSA}
  TMsgBoxParamsA = MSGBOXPARAMSA;
  PMsgBoxParamsA = LPMSGBOXPARAMSA;

  LPMSGBOXPARAMSW = ^MSGBOXPARAMSW;
  {$EXTERNALSYM LPMSGBOXPARAMSW}
  tagMSGBOXPARAMSW = record
    cbSize: UINT;
    hwndOwner: HWND;
    hInstance: HINST;
    lpszText: LPCWSTR;
    lpszCaption: LPCWSTR;
    dwStyle: DWORD;
    lpszIcon: LPCWSTR;
    dwContextHelpId: DWORD_PTR;
    lpfnMsgBoxCallback: MSGBOXCALLBACK;
    dwLanguageId: DWORD;
  end;
  {$EXTERNALSYM tagMSGBOXPARAMSW}
  MSGBOXPARAMSW = tagMSGBOXPARAMSW;
  {$EXTERNALSYM MSGBOXPARAMSW}
  TMsgBoxParamsW = MSGBOXPARAMSW;
  PMsgBoxParamsW = LPMSGBOXPARAMSW;

  {$IFDEF UNICODE}
  MSGBOXPARAMS = MSGBOXPARAMSW;
  {$EXTERNALSYM MSGBOXPARAMS}
  LPMSGBOXPARAMS = LPMSGBOXPARAMSW;
  {$EXTERNALSYM LPMSGBOXPARAMS}
  TMsgBoxParams = TMsgBoxParamsW;
  PMsgBoxParams = PMsgBoxParamsW;
  {$ELSE}
  MSGBOXPARAMS = MSGBOXPARAMSA;
  {$EXTERNALSYM MSGBOXPARAMS}
  LPMSGBOXPARAMS = LPMSGBOXPARAMSA;
  {$EXTERNALSYM LPMSGBOXPARAMS}
  TMsgBoxParams = TMsgBoxParamsA;
  PMsgBoxParams = PMsgBoxParamsA;
  {$ENDIF UNICODE}

function MessageBoxIndirectA(const lpMsgBoxParams: MSGBOXPARAMSA): Integer; stdcall;
{$EXTERNALSYM MessageBoxIndirectA}
function MessageBoxIndirectW(const lpMsgBoxParams: MSGBOXPARAMSW): Integer; stdcall;
{$EXTERNALSYM MessageBoxIndirectW}
function MessageBoxIndirect(const lpMsgBoxParams: MSGBOXPARAMS): Integer; stdcall;
{$EXTERNALSYM MessageBoxIndirect}

function MessageBeep(uType: UINT): BOOL; stdcall;
{$EXTERNALSYM MessageBeep}

function ShowCursor(bShow: BOOL): Integer; stdcall;
{$EXTERNALSYM ShowCursor}

function SetCursorPos(X, Y: Integer): BOOL; stdcall;
{$EXTERNALSYM SetCursorPos}

function SetCursor(hCursor: HCURSOR): HCURSOR; stdcall;
{$EXTERNALSYM SetCursor}

function GetCursorPos(var lpPoint: POINT): BOOL; stdcall;
{$EXTERNALSYM GetCursorPos}

function ClipCursor(lpRect: LPRECT): BOOL; stdcall;
{$EXTERNALSYM ClipCursor}

function GetClipCursor(var lpRect: RECT): BOOL; stdcall;
{$EXTERNALSYM GetClipCursor}

function GetCursor: HCURSOR; stdcall;
{$EXTERNALSYM GetCursor}

function CreateCaret(hWnd: HWND; hBitmap: HBITMAP; nWidth, nHeight: Integer): BOOL; stdcall;
{$EXTERNALSYM CreateCaret}

function GetCaretBlinkTime: UINT; stdcall;
{$EXTERNALSYM GetCaretBlinkTime}

function SetCaretBlinkTime(uMSeconds: UINT): BOOL; stdcall;
{$EXTERNALSYM SetCaretBlinkTime}

function DestroyCaret: BOOL; stdcall;
{$EXTERNALSYM DestroyCaret}

function HideCaret(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM HideCaret}

function ShowCaret(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM ShowCaret}

function SetCaretPos(X, Y: Integer): BOOL; stdcall;
{$EXTERNALSYM SetCaretPos}

function GetCaretPos(var lpPoint: POINT): BOOL; stdcall;
{$EXTERNALSYM GetCaretPos}

function ClientToScreen(hWnd: HWND; var lpPoint: POINT): BOOL; stdcall;
{$EXTERNALSYM ClientToScreen}

function ScreenToClient(hWnd: HWND; var lpPoint: POINT): BOOL; stdcall;
{$EXTERNALSYM ScreenToClient}

function MapWindowPoints(hWndFrom, hWndTo: HWND; lpPoints: LPPOINT; cPoints: UINT): Integer; stdcall;
{$EXTERNALSYM MapWindowPoints}

function WindowFromPoint(Point: POINT): HWND; stdcall;
{$EXTERNALSYM WindowFromPoint}

function ChildWindowFromPoint(hWndParent: HWND; Point: POINT): HWND; stdcall;
{$EXTERNALSYM ChildWindowFromPoint}

const
  CWP_ALL             = $0000;
  {$EXTERNALSYM CWP_ALL}
  CWP_SKIPINVISIBLE   = $0001;
  {$EXTERNALSYM CWP_SKIPINVISIBLE}
  CWP_SKIPDISABLED    = $0002;
  {$EXTERNALSYM CWP_SKIPDISABLED}
  CWP_SKIPTRANSPARENT = $0004;
  {$EXTERNALSYM CWP_SKIPTRANSPARENT}

function ChildWindowFromPointEx(hwndParent: HWND; pt: POINT; uFlags: UINT): HWND; stdcall;
{$EXTERNALSYM ChildWindowFromPointEx}

//
// Color Types
//

const
  CTLCOLOR_MSGBOX    = 0;
  {$EXTERNALSYM CTLCOLOR_MSGBOX}
  CTLCOLOR_EDIT      = 1;
  {$EXTERNALSYM CTLCOLOR_EDIT}
  CTLCOLOR_LISTBOX   = 2;
  {$EXTERNALSYM CTLCOLOR_LISTBOX}
  CTLCOLOR_BTN       = 3;
  {$EXTERNALSYM CTLCOLOR_BTN}
  CTLCOLOR_DLG       = 4;
  {$EXTERNALSYM CTLCOLOR_DLG}
  CTLCOLOR_SCROLLBAR = 5;
  {$EXTERNALSYM CTLCOLOR_SCROLLBAR}
  CTLCOLOR_STATIC    = 6;
  {$EXTERNALSYM CTLCOLOR_STATIC}
  CTLCOLOR_MAX       = 7;
  {$EXTERNALSYM CTLCOLOR_MAX}

  COLOR_SCROLLBAR           = 0;
  {$EXTERNALSYM COLOR_SCROLLBAR}
  COLOR_BACKGROUND          = 1;
  {$EXTERNALSYM COLOR_BACKGROUND}
  COLOR_ACTIVECAPTION       = 2;
  {$EXTERNALSYM COLOR_ACTIVECAPTION}
  COLOR_INACTIVECAPTION     = 3;
  {$EXTERNALSYM COLOR_INACTIVECAPTION}
  COLOR_MENU                = 4;
  {$EXTERNALSYM COLOR_MENU}
  COLOR_WINDOW              = 5;
  {$EXTERNALSYM COLOR_WINDOW}
  COLOR_WINDOWFRAME         = 6;
  {$EXTERNALSYM COLOR_WINDOWFRAME}
  COLOR_MENUTEXT            = 7;
  {$EXTERNALSYM COLOR_MENUTEXT}
  COLOR_WINDOWTEXT          = 8;
  {$EXTERNALSYM COLOR_WINDOWTEXT}
  COLOR_CAPTIONTEXT         = 9;
  {$EXTERNALSYM COLOR_CAPTIONTEXT}
  COLOR_ACTIVEBORDER        = 10;
  {$EXTERNALSYM COLOR_ACTIVEBORDER}
  COLOR_INACTIVEBORDER      = 11;
  {$EXTERNALSYM COLOR_INACTIVEBORDER}
  COLOR_APPWORKSPACE        = 12;
  {$EXTERNALSYM COLOR_APPWORKSPACE}
  COLOR_HIGHLIGHT           = 13;
  {$EXTERNALSYM COLOR_HIGHLIGHT}
  COLOR_HIGHLIGHTTEXT       = 14;
  {$EXTERNALSYM COLOR_HIGHLIGHTTEXT}
  COLOR_BTNFACE             = 15;
  {$EXTERNALSYM COLOR_BTNFACE}
  COLOR_BTNSHADOW           = 16;
  {$EXTERNALSYM COLOR_BTNSHADOW}
  COLOR_GRAYTEXT            = 17;
  {$EXTERNALSYM COLOR_GRAYTEXT}
  COLOR_BTNTEXT             = 18;
  {$EXTERNALSYM COLOR_BTNTEXT}
  COLOR_INACTIVECAPTIONTEXT = 19;
  {$EXTERNALSYM COLOR_INACTIVECAPTIONTEXT}
  COLOR_BTNHIGHLIGHT        = 20;
  {$EXTERNALSYM COLOR_BTNHIGHLIGHT}

  COLOR_3DDKSHADOW = 21;
  {$EXTERNALSYM COLOR_3DDKSHADOW}
  COLOR_3DLIGHT    = 22;
  {$EXTERNALSYM COLOR_3DLIGHT}
  COLOR_INFOTEXT   = 23;
  {$EXTERNALSYM COLOR_INFOTEXT}
  COLOR_INFOBK     = 24;
  {$EXTERNALSYM COLOR_INFOBK}

  COLOR_HOTLIGHT                = 26;
  {$EXTERNALSYM COLOR_HOTLIGHT}
  COLOR_GRADIENTACTIVECAPTION   = 27;
  {$EXTERNALSYM COLOR_GRADIENTACTIVECAPTION}
  COLOR_GRADIENTINACTIVECAPTION = 28;
  {$EXTERNALSYM COLOR_GRADIENTINACTIVECAPTION}
  COLOR_MENUHILIGHT             = 29;
  {$EXTERNALSYM COLOR_MENUHILIGHT}
  COLOR_MENUBAR                 = 30;
  {$EXTERNALSYM COLOR_MENUBAR}

  COLOR_DESKTOP     = COLOR_BACKGROUND;
  {$EXTERNALSYM COLOR_DESKTOP}
  COLOR_3DFACE      = COLOR_BTNFACE;
  {$EXTERNALSYM COLOR_3DFACE}
  COLOR_3DSHADOW    = COLOR_BTNSHADOW;
  {$EXTERNALSYM COLOR_3DSHADOW}
  COLOR_3DHIGHLIGHT = COLOR_BTNHIGHLIGHT;
  {$EXTERNALSYM COLOR_3DHIGHLIGHT}
  COLOR_3DHILIGHT   = COLOR_BTNHIGHLIGHT;
  {$EXTERNALSYM COLOR_3DHILIGHT}
  COLOR_BTNHILIGHT  = COLOR_BTNHIGHLIGHT;
  {$EXTERNALSYM COLOR_BTNHILIGHT}

function GetSysColor(nIndex: Integer): DWORD; stdcall;
{$EXTERNALSYM GetSysColor}

function GetSysColorBrush(nIndex: Integer): HBRUSH; stdcall;
{$EXTERNALSYM GetSysColorBrush}

function SetSysColors(cElements: Integer; lpaElements: LPINT;
  lpaRgbValues: LPCOLORREF): BOOL; stdcall;
{$EXTERNALSYM SetSysColors}

function DrawFocusRect(hDC: HDC; const lprc: RECT): BOOL; stdcall;
{$EXTERNALSYM DrawFocusRect}

function FillRect(hDC: HDC; const lprc: RECT; hbr: HBRUSH): Integer; stdcall;
{$EXTERNALSYM FillRect}

function FrameRect(hDC: HDC; const lprc: RECT; hbr: HBRUSH): Integer; stdcall;
{$EXTERNALSYM FrameRect}

function InvertRect(hDC: HDC; const lprc: RECT): BOOL; stdcall;
{$EXTERNALSYM InvertRect}

function SetRect(var lprc: RECT; xLeft, yTop, xRight, yBottom: Integer): BOOL; stdcall;
{$EXTERNALSYM SetRect}

function SetRectEmpty(var lprc: RECT): BOOL; stdcall;
{$EXTERNALSYM SetRectEmpty}

function CopyRect(var lprcDst: RECT; const lprcSrc: RECT): BOOL; stdcall;
{$EXTERNALSYM CopyRect}

function InflateRect(var lprc: RECT; dx, dy: Integer): BOOL; stdcall;
{$EXTERNALSYM InflateRect}

function IntersectRect(var lprcDst: RECT; const lprcSrc1, lprcSrc2: RECT): BOOL; stdcall;
{$EXTERNALSYM IntersectRect}

function UnionRect(var lprcDst: RECT; const lprcSrc1, lprcSrc2: RECT): BOOL; stdcall;
{$EXTERNALSYM UnionRect}

function SubtractRect(var lprcDst: RECT; const lprcSrc1, lprcSrc2: RECT): BOOL; stdcall;
{$EXTERNALSYM SubtractRect}

function OffsetRect(var lprc: RECT; dx, dy: Integer): BOOL; stdcall;
{$EXTERNALSYM OffsetRect}

function IsRectEmpty(const lprc: RECT): BOOL; stdcall;
{$EXTERNALSYM IsRectEmpty}

function EqualRect(const lprc1, lprc2: RECT): BOOL; stdcall;
{$EXTERNALSYM EqualRect}

function PtInRect(const lprc: RECT; pt: POINT): BOOL; stdcall;
{$EXTERNALSYM PtInRect}

function GetWindowWord(hWnd: HWND; nIndex: Integer): WORD; stdcall;
{$EXTERNALSYM GetWindowWord}

function SetWindowWord(hWnd: HWND; nIndex: Integer; wNewWord: WORD): WORD; stdcall;
{$EXTERNALSYM SetWindowWord}

function GetWindowLongA(hWnd: HWND; nIndex: Integer): LONG; stdcall;
{$EXTERNALSYM GetWindowLongA}
function GetWindowLongW(hWnd: HWND; nIndex: Integer): LONG; stdcall;
{$EXTERNALSYM GetWindowLongW}
function GetWindowLong(hWnd: HWND; nIndex: Integer): LONG; stdcall;
{$EXTERNALSYM GetWindowLong}

function SetWindowLongA(hWnd: HWND; nIndex: Integer; dwNewLong: LONG): LONG; stdcall;
{$EXTERNALSYM SetWindowLongA}
function SetWindowLongW(hWnd: HWND; nIndex: Integer; dwNewLong: LONG): LONG; stdcall;
{$EXTERNALSYM SetWindowLongW}
function SetWindowLong(hWnd: HWND; nIndex: Integer; dwNewLong: LONG): LONG; stdcall;
{$EXTERNALSYM SetWindowLong}

function GetWindowLongPtrA(hWnd: HWND; nIndex: Integer): LONG_PTR;
{$EXTERNALSYM GetWindowLongPtrA}
function GetWindowLongPtrW(hWnd: HWND; nIndex: Integer): LONG_PTR;
{$EXTERNALSYM GetWindowLongPtrW}
function GetWindowLongPtr(hWnd: HWND; nIndex: Integer): LONG_PTR;
{$EXTERNALSYM GetWindowLongPtr}

function SetWindowLongPtrA(hWnd: HWND; nIndex: Integer; dwNewLong: LONG_PTR): LONG_PTR;
{$EXTERNALSYM SetWindowLongPtrA}
function SetWindowLongPtrW(hWnd: HWND; nIndex: Integer; dwNewLong: LONG_PTR): LONG_PTR;
{$EXTERNALSYM SetWindowLongPtrW}
function SetWindowLongPtr(hWnd: HWND; nIndex: Integer; dwNewLong: LONG_PTR): LONG_PTR;
{$EXTERNALSYM SetWindowLongPtr}

function GetClassWord(hWnd: HWND; nIndex: Integer): WORD; stdcall;
{$EXTERNALSYM GetClassWord}

function SetClassWord(hWnd: HWND; nIndex: Integer; wNewWord: WORD): WORD; stdcall;
{$EXTERNALSYM SetClassWord}

function GetClassLongA(hWnd: HWND; nIndex: Integer): DWORD; stdcall;
{$EXTERNALSYM GetClassLongA}
function GetClassLongW(hWnd: HWND; nIndex: Integer): DWORD; stdcall;
{$EXTERNALSYM GetClassLongW}
function GetClassLong(hWnd: HWND; nIndex: Integer): DWORD; stdcall;
{$EXTERNALSYM GetClassLong}

function SetClassLongA(hWnd: HWND; nIndex: Integer; dwNewLong: LONG): DWORD; stdcall;
{$EXTERNALSYM SetClassLongA}
function SetClassLongW(hWnd: HWND; nIndex: Integer; dwNewLong: LONG): DWORD; stdcall;
{$EXTERNALSYM SetClassLongW}
function SetClassLong(hWnd: HWND; nIndex: Integer; dwNewLong: LONG): DWORD; stdcall;
{$EXTERNALSYM SetClassLong}

function GetClassLongPtrA(hWnd: HWND; nIndex: Integer): ULONG_PTR;
{$EXTERNALSYM GetClassLongPtrA}
function GetClassLongPtrW(hWnd: HWND; nIndex: Integer): ULONG_PTR;
{$EXTERNALSYM GetClassLongPtrW}
function GetClassLongPtr(hWnd: HWND; nIndex: Integer): ULONG_PTR;
{$EXTERNALSYM GetClassLongPtr}

function SetClassLongPtrA(hWnd: HWND; nIndex: Integer; dwNewLong: ULONG_PTR): ULONG_PTR;
{$EXTERNALSYM SetClassLongPtrA}
function SetClassLongPtrW(hWnd: HWND; nIndex: Integer; dwNewLong: ULONG_PTR): ULONG_PTR;
{$EXTERNALSYM SetClassLongPtrW}
function SetClassLongPtr(hWnd: HWND; nIndex: Integer; dwNewLong: ULONG_PTR): ULONG_PTR;
{$EXTERNALSYM SetClassLongPtr}

function GetProcessDefaultLayout(var pdwDefaultLayout: DWORD): BOOL; stdcall;
{$EXTERNALSYM GetProcessDefaultLayout}

function SetProcessDefaultLayout(dwDefaultLayout: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetProcessDefaultLayout}

function GetDesktopWindow: HWND; stdcall;
{$EXTERNALSYM GetDesktopWindow}

function GetParent(hWnd: HWND): HWND; stdcall;
{$EXTERNALSYM GetParent}

function SetParent(hWndChild, hWndNewParent: HWND): HWND; stdcall;
{$EXTERNALSYM SetParent}

function EnumChildWindows(hWndParent: HWND; lpEnumFunc: WNDENUMPROC; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumChildWindows}

function FindWindowA(lpClassName, lpWindowName: LPCSTR): HWND; stdcall;
{$EXTERNALSYM FindWindowA}
function FindWindowW(lpClassName, lpWindowName: LPCWSTR): HWND; stdcall;
{$EXTERNALSYM FindWindowW}
function FindWindow(lpClassName, lpWindowName: LPCTSTR): HWND; stdcall;
{$EXTERNALSYM FindWindow}

function FindWindowExA(hwndParent, hwndChildAfter: HWND; lpszClass, lpszWindow: LPCSTR): HWND; stdcall;
{$EXTERNALSYM FindWindowExA}
function FindWindowExW(hwndParent, hwndChildAfter: HWND; lpszClass, lpszWindow: LPCWSTR): HWND; stdcall;
{$EXTERNALSYM FindWindowExW}
function FindWindowEx(hwndParent, hwndChildAfter: HWND; lpszClass, lpszWindow: LPCTSTR): HWND; stdcall;
{$EXTERNALSYM FindWindowEx}

function GetShellWindow: HWND; stdcall;
{$EXTERNALSYM GetShellWindow}

function RegisterShellHookWindow(h: HWND): BOOL; stdcall;
{$EXTERNALSYM RegisterShellHookWindow}

function DeregisterShellHookWindow(h: HWND): BOOL; stdcall;
{$EXTERNALSYM DeregisterShellHookWindow}

function EnumWindows(lpEnumFunc: WNDENUMPROC; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumWindows}

function EnumThreadWindows(dwThreadId: DWORD; lpfn: WNDENUMPROC; lParam: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumThreadWindows}

function EnumTaskWindows(hTask: HANDLE; lpfn: WNDENUMPROC; lParam: LPARAM): BOOL;
{$EXTERNALSYM EnumTaskWindows}

function GetClassNameA(hWnd: HWND; lpClassName: LPSTR; nMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetClassNameA}
function GetClassNameW(hWnd: HWND; lpClassName: LPWSTR; nMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetClassNameW}
function GetClassName(hWnd: HWND; lpClassName: LPTSTR; nMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM GetClassName}

function GetTopWindow(hWnd: HWND): HWND; stdcall;
{$EXTERNALSYM GetTopWindow}

function GetNextWindow(hWnd: HWND; wCmd: UINT): HWND;
{$EXTERNALSYM GetNextWindow}

function GetWindowThreadProcessId(hWnd: HWND; lpdwProcessId: LPDWORD): DWORD; stdcall;
{$EXTERNALSYM GetWindowThreadProcessId}

function IsGUIThread(bConvert: BOOL): BOOL; stdcall;
{$EXTERNALSYM IsGUIThread}

function GetWindowTask(hWnd: HWND): HANDLE;
{$EXTERNALSYM GetWindowTask}

function GetLastActivePopup(hWnd: HWND): HWND; stdcall;
{$EXTERNALSYM GetLastActivePopup}

//
// GetWindow() Constants
//

const
  GW_HWNDFIRST    = 0;
  {$EXTERNALSYM GW_HWNDFIRST}
  GW_HWNDLAST     = 1;
  {$EXTERNALSYM GW_HWNDLAST}
  GW_HWNDNEXT     = 2;
  {$EXTERNALSYM GW_HWNDNEXT}
  GW_HWNDPREV     = 3;
  {$EXTERNALSYM GW_HWNDPREV}
  GW_OWNER        = 4;
  {$EXTERNALSYM GW_OWNER}
  GW_CHILD        = 5;
  {$EXTERNALSYM GW_CHILD}
  {$IFNDEF WIN98_UP} // #if(WINVER <= 0x0400)
  GW_MAX          = 5;
  {$EXTERNALSYM GW_MAX}
  {$ELSE}
  GW_ENABLEDPOPUP = 6;
  {$EXTERNALSYM GW_ENABLEDPOPUP}
  GW_MAX          = 6;
  {$EXTERNALSYM GW_MAX}
  {$ENDIF WIN98ME_UP}

function GetWindow(hWnd: HWND; uCmd: UINT): HWND; stdcall;
{$EXTERNALSYM GetWindow}

function SetWindowsHookA(nFilterType: Integer; pfnFilterProc: HOOKPROC): HHOOK; stdcall;
{$EXTERNALSYM SetWindowsHookA}
function SetWindowsHookW(nFilterType: Integer; pfnFilterProc: HOOKPROC): HHOOK; stdcall;
{$EXTERNALSYM SetWindowsHookW}
function SetWindowsHook(nFilterType: Integer; pfnFilterProc: HOOKPROC): HHOOK; stdcall;
{$EXTERNALSYM SetWindowsHook}

function UnhookWindowsHook(nCode: Integer; pfnFilterProc: HOOKPROC): BOOL; stdcall;
{$EXTERNALSYM UnhookWindowsHook}

function SetWindowsHookExA(idHook: Integer; lpfn: HOOKPROC; hmod: HINST;
  dwThreadId: DWORD): HHOOK; stdcall;
{$EXTERNALSYM SetWindowsHookExA}
function SetWindowsHookExW(idHook: Integer; lpfn: HOOKPROC; hmod: HINST;
  dwThreadId: DWORD): HHOOK; stdcall;
{$EXTERNALSYM SetWindowsHookExW}
function SetWindowsHookEx(idHook: Integer; lpfn: HOOKPROC; hmod: HINST;
  dwThreadId: DWORD): HHOOK; stdcall;
{$EXTERNALSYM SetWindowsHookEx}

function UnhookWindowsHookEx(hhk: HHOOK): BOOL; stdcall;
{$EXTERNALSYM UnhookWindowsHookEx}

function CallNextHookEx(hhk: HHOOK; nCode: Integer; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM CallNextHookEx}

//
// Macros for source-level compatibility with old functions.
//

function DefHookProc(nCode: Integer; wParam: WPARAM; lParam: LPARAM; phhk: LPHHOOK): LRESULT;
{$EXTERNALSYM DefHookProc}

// ;win40  -- A lot of MF_* flags have been renamed as MFT_* and MFS_* flags//
//
// Menu flags for Add/Check/EnableMenuItem()
///)

const
  MF_INSERT = $00000000;
  {$EXTERNALSYM MF_INSERT}
  MF_CHANGE = $00000080;
  {$EXTERNALSYM MF_CHANGE}
  MF_APPEND = $00000100;
  {$EXTERNALSYM MF_APPEND}
  MF_DELETE = $00000200;
  {$EXTERNALSYM MF_DELETE}
  MF_REMOVE = $00001000;
  {$EXTERNALSYM MF_REMOVE}

  MF_BYCOMMAND  = $00000000;
  {$EXTERNALSYM MF_BYCOMMAND}
  MF_BYPOSITION = $00000400;
  {$EXTERNALSYM MF_BYPOSITION}

  MF_SEPARATOR = $00000800;
  {$EXTERNALSYM MF_SEPARATOR}

  MF_ENABLED  = $00000000;
  {$EXTERNALSYM MF_ENABLED}
  MF_GRAYED   = $00000001;
  {$EXTERNALSYM MF_GRAYED}
  MF_DISABLED = $00000002;
  {$EXTERNALSYM MF_DISABLED}

  MF_UNCHECKED       = $00000000;
  {$EXTERNALSYM MF_UNCHECKED}
  MF_CHECKED         = $00000008;
  {$EXTERNALSYM MF_CHECKED}
  MF_USECHECKBITMAPS = $00000200;
  {$EXTERNALSYM MF_USECHECKBITMAPS}

  MF_STRING    = $00000000;
  {$EXTERNALSYM MF_STRING}
  MF_BITMAP    = $00000004;
  {$EXTERNALSYM MF_BITMAP}
  MF_OWNERDRAW = $00000100;
  {$EXTERNALSYM MF_OWNERDRAW}

  MF_POPUP        = $00000010;
  {$EXTERNALSYM MF_POPUP}
  MF_MENUBARBREAK = $00000020;
  {$EXTERNALSYM MF_MENUBARBREAK}
  MF_MENUBREAK    = $00000040;
  {$EXTERNALSYM MF_MENUBREAK}

  MF_UNHILITE = $00000000;
  {$EXTERNALSYM MF_UNHILITE}
  MF_HILITE   = $00000080;
  {$EXTERNALSYM MF_HILITE}

  MF_DEFAULT      = $00001000;
  {$EXTERNALSYM MF_DEFAULT}
  MF_SYSMENU      = $00002000;
  {$EXTERNALSYM MF_SYSMENU}
  MF_HELP         = $00004000;
  {$EXTERNALSYM MF_HELP}
  MF_RIGHTJUSTIFY = $00004000;
  {$EXTERNALSYM MF_RIGHTJUSTIFY}

  MF_MOUSESELECT = $00008000;
  {$EXTERNALSYM MF_MOUSESELECT}
  MF_END         = $00000080; // Obsolete -- only used by old RES files
  {$EXTERNALSYM MF_END}

  MFT_STRING       = MF_STRING;
  {$EXTERNALSYM MFT_STRING}
  MFT_BITMAP       = MF_BITMAP;
  {$EXTERNALSYM MFT_BITMAP}
  MFT_MENUBARBREAK = MF_MENUBARBREAK;
  {$EXTERNALSYM MFT_MENUBARBREAK}
  MFT_MENUBREAK    = MF_MENUBREAK;
  {$EXTERNALSYM MFT_MENUBREAK}
  MFT_OWNERDRAW    = MF_OWNERDRAW;
  {$EXTERNALSYM MFT_OWNERDRAW}
  MFT_RADIOCHECK   = $00000200;
  {$EXTERNALSYM MFT_RADIOCHECK}
  MFT_SEPARATOR    = MF_SEPARATOR;
  {$EXTERNALSYM MFT_SEPARATOR}
  MFT_RIGHTORDER   = $00002000;
  {$EXTERNALSYM MFT_RIGHTORDER}
  MFT_RIGHTJUSTIFY = MF_RIGHTJUSTIFY;
  {$EXTERNALSYM MFT_RIGHTJUSTIFY}

// Menu flags for Add/Check/EnableMenuItem()

  MFS_GRAYED    = $00000003;
  {$EXTERNALSYM MFS_GRAYED}
  MFS_DISABLED  = MFS_GRAYED;
  {$EXTERNALSYM MFS_DISABLED}
  MFS_CHECKED   = MF_CHECKED;
  {$EXTERNALSYM MFS_CHECKED}
  MFS_HILITE    = MF_HILITE;
  {$EXTERNALSYM MFS_HILITE}
  MFS_ENABLED   = MF_ENABLED;
  {$EXTERNALSYM MFS_ENABLED}
  MFS_UNCHECKED = MF_UNCHECKED;
  {$EXTERNALSYM MFS_UNCHECKED}
  MFS_UNHILITE  = MF_UNHILITE;
  {$EXTERNALSYM MFS_UNHILITE}
  MFS_DEFAULT   = MF_DEFAULT;
  {$EXTERNALSYM MFS_DEFAULT}

function CheckMenuRadioItem(hmenu: HMENU; idFirst, idLast, idCheck, uFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM CheckMenuRadioItem}

//
// Menu item resource format
//

type
  PMENUITEMTEMPLATEHEADER = ^MENUITEMTEMPLATEHEADER;
  MENUITEMTEMPLATEHEADER = record
    versionNumber: WORD;
    offset: WORD;
  end;
  {$EXTERNALSYM MENUITEMTEMPLATEHEADER}
  TMenuItemTemplateHeader = MENUITEMTEMPLATEHEADER;

  PMENUITEMTEMPLATE = ^MENUITEMTEMPLATE; // version 0
  MENUITEMTEMPLATE = record
    mtOption: WORD;
    mtID: WORD;
    mtString: array [0..0] of WCHAR;
  end;
  {$EXTERNALSYM MENUITEMTEMPLATE}
  TMenuItemTemplate = MENUITEMTEMPLATE;

//
// System Menu Command Values
//

const
  SC_SIZE         = $F000;
  {$EXTERNALSYM SC_SIZE}
  SC_MOVE         = $F010;
  {$EXTERNALSYM SC_MOVE}
  SC_MINIMIZE     = $F020;
  {$EXTERNALSYM SC_MINIMIZE}
  SC_MAXIMIZE     = $F030;
  {$EXTERNALSYM SC_MAXIMIZE}
  SC_NEXTWINDOW   = $F040;
  {$EXTERNALSYM SC_NEXTWINDOW}
  SC_PREVWINDOW   = $F050;
  {$EXTERNALSYM SC_PREVWINDOW}
  SC_CLOSE        = $F060;
  {$EXTERNALSYM SC_CLOSE}
  SC_VSCROLL      = $F070;
  {$EXTERNALSYM SC_VSCROLL}
  SC_HSCROLL      = $F080;
  {$EXTERNALSYM SC_HSCROLL}
  SC_MOUSEMENU    = $F090;
  {$EXTERNALSYM SC_MOUSEMENU}
  SC_KEYMENU      = $F100;
  {$EXTERNALSYM SC_KEYMENU}
  SC_ARRANGE      = $F110;
  {$EXTERNALSYM SC_ARRANGE}
  SC_RESTORE      = $F120;
  {$EXTERNALSYM SC_RESTORE}
  SC_TASKLIST     = $F130;
  {$EXTERNALSYM SC_TASKLIST}
  SC_SCREENSAVE   = $F140;
  {$EXTERNALSYM SC_SCREENSAVE}
  SC_HOTKEY       = $F150;
  {$EXTERNALSYM SC_HOTKEY}
  SC_DEFAULT      = $F160;
  {$EXTERNALSYM SC_DEFAULT}
  SC_MONITORPOWER = $F170;
  {$EXTERNALSYM SC_MONITORPOWER}
  SC_CONTEXTHELP  = $F180;
  {$EXTERNALSYM SC_CONTEXTHELP}
  SC_SEPARATOR    = $F00F;
  {$EXTERNALSYM SC_SEPARATOR}

//
// Obsolete names
//

const
  SC_ICON = SC_MINIMIZE;
  {$EXTERNALSYM SC_ICON}
  SC_ZOOM = SC_MAXIMIZE;
  {$EXTERNALSYM SC_ZOOM}

//
// Resource Loading Routines
//

function LoadBitmapA(hInstance: HINST; lpBitmapName: LPCSTR): HBITMAP; stdcall;
{$EXTERNALSYM LoadBitmapA}
function LoadBitmapW(hInstance: HINST; lpBitmapName: LPCWSTR): HBITMAP; stdcall;
{$EXTERNALSYM LoadBitmapW}
function LoadBitmap(hInstance: HINST; lpBitmapName: LPCTSTR): HBITMAP; stdcall;
{$EXTERNALSYM LoadBitmap}

function LoadCursorA(hInstance: HINST; lpCursorName: LPCSTR): HCURSOR; stdcall;
{$EXTERNALSYM LoadCursorA}
function LoadCursorW(hInstance: HINST; lpCursorName: LPCWSTR): HCURSOR; stdcall;
{$EXTERNALSYM LoadCursorW}
function LoadCursor(hInstance: HINST; lpCursorName: LPCTSTR): HCURSOR; stdcall;
{$EXTERNALSYM LoadCursor}

function LoadCursorFromFileA(lpFileName: LPCSTR): HCURSOR; stdcall;
{$EXTERNALSYM LoadCursorFromFileA}
function LoadCursorFromFileW(lpFileName: LPCWSTR): HCURSOR; stdcall;
{$EXTERNALSYM LoadCursorFromFileW}
function LoadCursorFromFile(lpFileName: LPCTSTR): HCURSOR; stdcall;
{$EXTERNALSYM LoadCursorFromFile}

function CreateCursor(hInst: HINST; xHotSpot, yHotSpot, nWidth, nHeight: Integer;
  pvANDPlane: PVOID; pvXORPlane: PVOID): HCURSOR; stdcall;
{$EXTERNALSYM CreateCursor}

function DestroyCursor(hCursor: HCURSOR): BOOL; stdcall;
{$EXTERNALSYM DestroyCursor}

function CopyCursor(pcur: HCURSOR): HCURSOR;
{$EXTERNALSYM CopyCursor}

//
// Standard Cursor IDs
//

const
  IDC_ARROW       = MAKEINTRESOURCE(32512);
  {$EXTERNALSYM IDC_ARROW}
  IDC_IBEAM       = MAKEINTRESOURCE(32513);
  {$EXTERNALSYM IDC_IBEAM}
  IDC_WAIT        = MAKEINTRESOURCE(32514);
  {$EXTERNALSYM IDC_WAIT}
  IDC_CROSS       = MAKEINTRESOURCE(32515);
  {$EXTERNALSYM IDC_CROSS}
  IDC_UPARROW     = MAKEINTRESOURCE(32516);
  {$EXTERNALSYM IDC_UPARROW}
  IDC_SIZE        = MAKEINTRESOURCE(32640); // OBSOLETE: use IDC_SIZEALL
  {$EXTERNALSYM IDC_SIZE}
  IDC_ICON        = MAKEINTRESOURCE(32641); // OBSOLETE: use IDC_ARROW
  {$EXTERNALSYM IDC_ICON}
  IDC_SIZENWSE    = MAKEINTRESOURCE(32642);
  {$EXTERNALSYM IDC_SIZENWSE}
  IDC_SIZENESW    = MAKEINTRESOURCE(32643);
  {$EXTERNALSYM IDC_SIZENESW}
  IDC_SIZEWE      = MAKEINTRESOURCE(32644);
  {$EXTERNALSYM IDC_SIZEWE}
  IDC_SIZENS      = MAKEINTRESOURCE(32645);
  {$EXTERNALSYM IDC_SIZENS}
  IDC_SIZEALL     = MAKEINTRESOURCE(32646);
  {$EXTERNALSYM IDC_SIZEALL}
  IDC_NO          = MAKEINTRESOURCE(32648); // not in win3.1
  {$EXTERNALSYM IDC_NO}
  IDC_HAND        = MAKEINTRESOURCE(32649);
  {$EXTERNALSYM IDC_HAND}
  IDC_APPSTARTING = MAKEINTRESOURCE(32650); // not in win3.1
  {$EXTERNALSYM IDC_APPSTARTING}
  IDC_HELP        = MAKEINTRESOURCE(32651);
  {$EXTERNALSYM IDC_HELP}

function SetSystemCursor(hcur: HCURSOR; id: DWORD): BOOL; stdcall;
{$EXTERNALSYM SetSystemCursor}

type
  PICONINFO = ^ICONINFO;
  _ICONINFO = record
    fIcon: BOOL;
    xHotspot: DWORD;
    yHotspot: DWORD;
    hbmMask: HBITMAP;
    hbmColor: HBITMAP;
  end;
  {$EXTERNALSYM _ICONINFO}
  ICONINFO = _ICONINFO;
  {$EXTERNALSYM ICONINFO}
  TIconInfo = ICONINFO;

function LoadIconA(hInstance: HINST; lpIconName: LPCSTR): HICON; stdcall;
{$EXTERNALSYM LoadIconA}
function LoadIconW(hInstance: HINST; lpIconName: LPCWSTR): HICON; stdcall;
{$EXTERNALSYM LoadIconW}
function LoadIcon(hInstance: HINST; lpIconName: LPCTSTR): HICON; stdcall;
{$EXTERNALSYM LoadIcon}

function PrivateExtractIconsA(szFileName: LPCSTR; nIconIndex, cxIcon, cyIcon: Integer; var phicon: HICON;
  var piconid: UINT; nIcons, flags: UINT): UINT; stdcall;
{$EXTERNALSYM PrivateExtractIconsA}
function PrivateExtractIconsW(szFileName: LPCWSTR; nIconIndex, cxIcon, cyIcon: Integer; var phicon: HICON;
  var piconid: UINT; nIcons, flags: UINT): UINT; stdcall;
{$EXTERNALSYM PrivateExtractIconsW}
function PrivateExtractIcons(szFileName: LPCTSTR; nIconIndex, cxIcon, cyIcon: Integer; var phicon: HICON;
  var piconid: UINT; nIcons, flags: UINT): UINT; stdcall;
{$EXTERNALSYM PrivateExtractIcons}

function CreateIcon(hInstance: HINST; nWidth, nHeight: Integer; cPlanes,
  cBitsPixel: BYTE; lpbANDbits: LPBYTE; lpbXORbits: LPBYTE): HICON; stdcall;
{$EXTERNALSYM CreateIcon}

function DestroyIcon(hIcon: HICON): BOOL; stdcall;
{$EXTERNALSYM DestroyIcon}

function LookupIconIdFromDirectory(presbits: PBYTE; fIcon: BOOL): Integer; stdcall;
{$EXTERNALSYM LookupIconIdFromDirectory}

function LookupIconIdFromDirectoryEx(presbits: PBYTE; fIcon: BOOL;
  cxDesired, cyDesired: Integer; Flags: UINT): Integer; stdcall;
{$EXTERNALSYM LookupIconIdFromDirectoryEx}

function CreateIconFromResource(presbits: PBYTE; dwResSize: DWORD;
  fIcon: BOOL; dwVer: DWORD): HICON; stdcall;
{$EXTERNALSYM CreateIconFromResource}

function CreateIconFromResourceEx(presbits: PBYTE; dwResSize: DWORD; fIcon: BOOL;
  dwVer: DWORD; cxDesired, cyDesired: Integer; Flags: UINT): HICON; stdcall;
{$EXTERNALSYM CreateIconFromResourceEx}

// Icon/Cursor header//

type
  LPCURSORSHAPE = ^CURSORSHAPE;
  {$EXTERNALSYM LPCURSORSHAPE}
  tagCURSORSHAPE = record
    xHotSpot: Integer;
    yHotSpot: Integer;
    cx: Integer;
    cy: Integer;
    cbWidth: Integer;
    Planes: BYTE;
    BitsPixel: BYTE;
  end;
  {$EXTERNALSYM tagCURSORSHAPE}
  CURSORSHAPE = tagCURSORSHAPE;
  {$EXTERNALSYM CURSORSHAPE}
  TCursorShape = CURSORSHAPE;
  PCursorShape = LPCURSORSHAPE;

const
  IMAGE_BITMAP      = 0;
  {$EXTERNALSYM IMAGE_BITMAP}
  IMAGE_ICON        = 1;
  {$EXTERNALSYM IMAGE_ICON}
  IMAGE_CURSOR      = 2;
  {$EXTERNALSYM IMAGE_CURSOR}
  IMAGE_ENHMETAFILE = 3;
  {$EXTERNALSYM IMAGE_ENHMETAFILE}

  LR_DEFAULTCOLOR     = $0000;
  {$EXTERNALSYM LR_DEFAULTCOLOR}
  LR_MONOCHROME       = $0001;
  {$EXTERNALSYM LR_MONOCHROME}
  LR_COLOR            = $0002;
  {$EXTERNALSYM LR_COLOR}
  LR_COPYRETURNORG    = $0004;
  {$EXTERNALSYM LR_COPYRETURNORG}
  LR_COPYDELETEORG    = $0008;
  {$EXTERNALSYM LR_COPYDELETEORG}
  LR_LOADFROMFILE     = $0010;
  {$EXTERNALSYM LR_LOADFROMFILE}
  LR_LOADTRANSPARENT  = $0020;
  {$EXTERNALSYM LR_LOADTRANSPARENT}
  LR_DEFAULTSIZE      = $0040;
  {$EXTERNALSYM LR_DEFAULTSIZE}
  LR_VGACOLOR         = $0080;
  {$EXTERNALSYM LR_VGACOLOR}
  LR_LOADMAP3DCOLORS  = $1000;
  {$EXTERNALSYM LR_LOADMAP3DCOLORS}
  LR_CREATEDIBSECTION = $2000;
  {$EXTERNALSYM LR_CREATEDIBSECTION}
  LR_COPYFROMRESOURCE = $4000;
  {$EXTERNALSYM LR_COPYFROMRESOURCE}
  LR_SHARED           = $8000;
  {$EXTERNALSYM LR_SHARED}

function LoadImageA(hinst: HINST; lpszName: LPCSTR; uType: UINT;
  cxDesired, cyDesired: Integer; fuLoad: UINT): HANDLE; stdcall;
{$EXTERNALSYM LoadImageA}
function LoadImageW(hinst: HINST; lpszName: LPCWSTR; uType: UINT;
  cxDesired, cyDesired: Integer; fuLoad: UINT): HANDLE; stdcall;
{$EXTERNALSYM LoadImageW}
function LoadImage(hinst: HINST; lpszName: LPCTSTR; uType: UINT;
  cxDesired, cyDesired: Integer; fuLoad: UINT): HANDLE; stdcall;
{$EXTERNALSYM LoadImage}

function CopyImage(hinst: HANDLE; lpszName: UINT; cxDesired, cyDesired: Integer;
  fuFlags: UINT): HANDLE; stdcall;
{$EXTERNALSYM CopyImage}

const
  DI_MASK        = $0001;
  {$EXTERNALSYM DI_MASK}
  DI_IMAGE       = $0002;
  {$EXTERNALSYM DI_IMAGE}
  DI_NORMAL      = $0003;
  {$EXTERNALSYM DI_NORMAL}
  DI_COMPAT      = $0004;
  {$EXTERNALSYM DI_COMPAT}
  DI_DEFAULTSIZE = $0008;
  {$EXTERNALSYM DI_DEFAULTSIZE}
  DI_NOMIRROR    = $0010;
  {$EXTERNALSYM DI_NOMIRROR}

function DrawIconEx(hdc: HDC; xLeft, yTop: Integer; hIcon: HICON;
  cxWidth, cyWidth: Integer; istepIfAniCur: UINT; hbrFlickerFreeDraw: HBRUSH;
  diFlags: UINT): BOOL; stdcall;
{$EXTERNALSYM DrawIconEx}

function CreateIconIndirect(const piconinfo: ICONINFO): HICON; stdcall;
{$EXTERNALSYM CreateIconIndirect}

function CopyIcon(hIcon: HICON): HICON; stdcall;
{$EXTERNALSYM CopyIcon}

function GetIconInfo(hIcon: HICON; var piconinfo: ICONINFO): BOOL; stdcall;
{$EXTERNALSYM GetIconInfo}

const
  RES_ICON   = 1;
  {$EXTERNALSYM RES_ICON}
  RES_CURSOR = 2;
  {$EXTERNALSYM RES_CURSOR}

//
// OEM Resource Ordinal Numbers
//

  OBM_CLOSE    = 32754;
  {$EXTERNALSYM OBM_CLOSE}
  OBM_UPARROW  = 32753;
  {$EXTERNALSYM OBM_UPARROW}
  OBM_DNARROW  = 32752;
  {$EXTERNALSYM OBM_DNARROW}
  OBM_RGARROW  = 32751;
  {$EXTERNALSYM OBM_RGARROW}
  OBM_LFARROW  = 32750;
  {$EXTERNALSYM OBM_LFARROW}
  OBM_REDUCE   = 32749;
  {$EXTERNALSYM OBM_REDUCE}
  OBM_ZOOM     = 32748;
  {$EXTERNALSYM OBM_ZOOM}
  OBM_RESTORE  = 32747;
  {$EXTERNALSYM OBM_RESTORE}
  OBM_REDUCED  = 32746;
  {$EXTERNALSYM OBM_REDUCED}
  OBM_ZOOMD    = 32745;
  {$EXTERNALSYM OBM_ZOOMD}
  OBM_RESTORED = 32744;
  {$EXTERNALSYM OBM_RESTORED}
  OBM_UPARROWD = 32743;
  {$EXTERNALSYM OBM_UPARROWD}
  OBM_DNARROWD = 32742;
  {$EXTERNALSYM OBM_DNARROWD}
  OBM_RGARROWD = 32741;
  {$EXTERNALSYM OBM_RGARROWD}
  OBM_LFARROWD = 32740;
  {$EXTERNALSYM OBM_LFARROWD}
  OBM_MNARROW  = 32739;
  {$EXTERNALSYM OBM_MNARROW}
  OBM_COMBO    = 32738;
  {$EXTERNALSYM OBM_COMBO}
  OBM_UPARROWI = 32737;
  {$EXTERNALSYM OBM_UPARROWI}
  OBM_DNARROWI = 32736;
  {$EXTERNALSYM OBM_DNARROWI}
  OBM_RGARROWI = 32735;
  {$EXTERNALSYM OBM_RGARROWI}
  OBM_LFARROWI = 32734;
  {$EXTERNALSYM OBM_LFARROWI}

  OBM_OLD_CLOSE   = 32767;
  {$EXTERNALSYM OBM_OLD_CLOSE}
  OBM_SIZE        = 32766;
  {$EXTERNALSYM OBM_SIZE}
  OBM_OLD_UPARROW = 32765;
  {$EXTERNALSYM OBM_OLD_UPARROW}
  OBM_OLD_DNARROW = 32764;
  {$EXTERNALSYM OBM_OLD_DNARROW}
  OBM_OLD_RGARROW = 32763;
  {$EXTERNALSYM OBM_OLD_RGARROW}
  OBM_OLD_LFARROW = 32762;
  {$EXTERNALSYM OBM_OLD_LFARROW}
  OBM_BTSIZE      = 32761;
  {$EXTERNALSYM OBM_BTSIZE}
  OBM_CHECK       = 32760;
  {$EXTERNALSYM OBM_CHECK}
  OBM_CHECKBOXES  = 32759;
  {$EXTERNALSYM OBM_CHECKBOXES}
  OBM_BTNCORNERS  = 32758;
  {$EXTERNALSYM OBM_BTNCORNERS}
  OBM_OLD_REDUCE  = 32757;
  {$EXTERNALSYM OBM_OLD_REDUCE}
  OBM_OLD_ZOOM    = 32756;
  {$EXTERNALSYM OBM_OLD_ZOOM}
  OBM_OLD_RESTORE = 32755;
  {$EXTERNALSYM OBM_OLD_RESTORE}

  OCR_NORMAL      = 32512;
  {$EXTERNALSYM OCR_NORMAL}
  OCR_IBEAM       = 32513;
  {$EXTERNALSYM OCR_IBEAM}
  OCR_WAIT        = 32514;
  {$EXTERNALSYM OCR_WAIT}
  OCR_CROSS       = 32515;
  {$EXTERNALSYM OCR_CROSS}
  OCR_UP          = 32516;
  {$EXTERNALSYM OCR_UP}
  OCR_SIZE        = 32640; // OBSOLETE: use OCR_SIZEALL
  {$EXTERNALSYM OCR_SIZE}
  OCR_ICON        = 32641; // OBSOLETE: use OCR_NORMAL
  {$EXTERNALSYM OCR_ICON}
  OCR_SIZENWSE    = 32642;
  {$EXTERNALSYM OCR_SIZENWSE}
  OCR_SIZENESW    = 32643;
  {$EXTERNALSYM OCR_SIZENESW}
  OCR_SIZEWE      = 32644;
  {$EXTERNALSYM OCR_SIZEWE}
  OCR_SIZENS      = 32645;
  {$EXTERNALSYM OCR_SIZENS}
  OCR_SIZEALL     = 32646;
  {$EXTERNALSYM OCR_SIZEALL}
  OCR_ICOCUR      = 32647; // OBSOLETE: use OIC_WINLOGO
  {$EXTERNALSYM OCR_ICOCUR}
  OCR_NO          = 32648;
  {$EXTERNALSYM OCR_NO}
  OCR_HAND        = 32649;
  {$EXTERNALSYM OCR_HAND}
  OCR_APPSTARTING = 32650;
  {$EXTERNALSYM OCR_APPSTARTING}

  OIC_SAMPLE      = 32512;
  {$EXTERNALSYM OIC_SAMPLE}
  OIC_HAND        = 32513;
  {$EXTERNALSYM OIC_HAND}
  OIC_QUES        = 32514;
  {$EXTERNALSYM OIC_QUES}
  OIC_BANG        = 32515;
  {$EXTERNALSYM OIC_BANG}
  OIC_NOTE        = 32516;
  {$EXTERNALSYM OIC_NOTE}
  OIC_WINLOGO     = 32517;
  {$EXTERNALSYM OIC_WINLOGO}
  OIC_WARNING     = OIC_BANG;
  {$EXTERNALSYM OIC_WARNING}
  OIC_ERROR       = OIC_HAND;
  {$EXTERNALSYM OIC_ERROR}
  OIC_INFORMATION = OIC_NOTE;
  {$EXTERNALSYM OIC_INFORMATION}

  ORD_LANGDRIVER = 1; // The ordinal number for the entry point of language drivers.
  {$EXTERNALSYM ORD_LANGDRIVER}

//
// Standard Icon IDs
//

  IDI_APPLICATION = MAKEINTRESOURCE(32512);
  {$EXTERNALSYM IDI_APPLICATION}
  IDI_HAND        = MAKEINTRESOURCE(32513);
  {$EXTERNALSYM IDI_HAND}
  IDI_QUESTION    = MAKEINTRESOURCE(32514);
  {$EXTERNALSYM IDI_QUESTION}
  IDI_EXCLAMATION = MAKEINTRESOURCE(32515);
  {$EXTERNALSYM IDI_EXCLAMATION}
  IDI_ASTERISK    = MAKEINTRESOURCE(32516);
  {$EXTERNALSYM IDI_ASTERISK}
  IDI_WINLOGO = MAKEINTRESOURCE(32517);
  {$EXTERNALSYM IDI_WINLOGO}

  IDI_WARNING     = IDI_EXCLAMATION;
  {$EXTERNALSYM IDI_WARNING}
  IDI_ERROR       = IDI_HAND;
  {$EXTERNALSYM IDI_ERROR}
  IDI_INFORMATION = IDI_ASTERISK;
  {$EXTERNALSYM IDI_INFORMATION}

function LoadStringA(hInstance: HINST; uID: UINT; lpBuffer: LPSTR;
  nBufferMax: Integer): Integer; stdcall;
{$EXTERNALSYM LoadStringA}
function LoadStringW(hInstance: HINST; uID: UINT; lpBuffer: LPWSTR;
  nBufferMax: Integer): Integer; stdcall;
{$EXTERNALSYM LoadStringW}
function LoadString(hInstance: HINST; uID: UINT; lpBuffer: LPTSTR;
  nBufferMax: Integer): Integer; stdcall;
{$EXTERNALSYM LoadString}

//
// Dialog Box Command IDs
//

const
  IDOK     = 1;
  {$EXTERNALSYM IDOK}
  IDCANCEL = 2;
  {$EXTERNALSYM IDCANCEL}
  IDABORT  = 3;
  {$EXTERNALSYM IDABORT}
  IDRETRY  = 4;
  {$EXTERNALSYM IDRETRY}
  IDIGNORE = 5;
  {$EXTERNALSYM IDIGNORE}
  IDYES    = 6;
  {$EXTERNALSYM IDYES}
  IDNO     = 7;
  {$EXTERNALSYM IDNO}
  IDCLOSE  = 8;
  {$EXTERNALSYM IDCLOSE}
  IDHELP   = 9;
  {$EXTERNALSYM IDHELP}

  IDTRYAGAIN = 10;
  {$EXTERNALSYM IDTRYAGAIN}
  IDCONTINUE = 11;
  {$EXTERNALSYM IDCONTINUE}

  IDTIMEOUT  = 32000;
  {$EXTERNALSYM IDTIMEOUT}

//
// Control Manager Structures and Definitions
//

//
// Edit Control Styles
//

  ES_LEFT        = $0000;
  {$EXTERNALSYM ES_LEFT}
  ES_CENTER      = $0001;
  {$EXTERNALSYM ES_CENTER}
  ES_RIGHT       = $0002;
  {$EXTERNALSYM ES_RIGHT}
  ES_MULTILINE   = $0004;
  {$EXTERNALSYM ES_MULTILINE}
  ES_UPPERCASE   = $0008;
  {$EXTERNALSYM ES_UPPERCASE}
  ES_LOWERCASE   = $0010;
  {$EXTERNALSYM ES_LOWERCASE}
  ES_PASSWORD    = $0020;
  {$EXTERNALSYM ES_PASSWORD}
  ES_AUTOVSCROLL = $0040;
  {$EXTERNALSYM ES_AUTOVSCROLL}
  ES_AUTOHSCROLL = $0080;
  {$EXTERNALSYM ES_AUTOHSCROLL}
  ES_NOHIDESEL   = $0100;
  {$EXTERNALSYM ES_NOHIDESEL}
  ES_OEMCONVERT  = $0400;
  {$EXTERNALSYM ES_OEMCONVERT}
  ES_READONLY    = $0800;
  {$EXTERNALSYM ES_READONLY}
  ES_WANTRETURN  = $1000;
  {$EXTERNALSYM ES_WANTRETURN}
  ES_NUMBER      = $2000;
  {$EXTERNALSYM ES_NUMBER}

//
// Edit Control Notification Codes
//

  EN_SETFOCUS  = $0100;
  {$EXTERNALSYM EN_SETFOCUS}
  EN_KILLFOCUS = $0200;
  {$EXTERNALSYM EN_KILLFOCUS}
  EN_CHANGE    = $0300;
  {$EXTERNALSYM EN_CHANGE}
  EN_UPDATE    = $0400;
  {$EXTERNALSYM EN_UPDATE}
  EN_ERRSPACE  = $0500;
  {$EXTERNALSYM EN_ERRSPACE}
  EN_MAXTEXT   = $0501;
  {$EXTERNALSYM EN_MAXTEXT}
  EN_HSCROLL   = $0601;
  {$EXTERNALSYM EN_HSCROLL}
  EN_VSCROLL   = $0602;
  {$EXTERNALSYM EN_VSCROLL}

  EN_ALIGN_LTR_EC = $0700;
  {$EXTERNALSYM EN_ALIGN_LTR_EC}
  EN_ALIGN_RTL_EC = $0701;
  {$EXTERNALSYM EN_ALIGN_RTL_EC}

// Edit control EM_SETMARGIN parameters//

  EC_LEFTMARGIN  = $0001;
  {$EXTERNALSYM EC_LEFTMARGIN}
  EC_RIGHTMARGIN = $0002;
  {$EXTERNALSYM EC_RIGHTMARGIN}
  EC_USEFONTINFO = $ffff;
  {$EXTERNALSYM EC_USEFONTINFO}

// wParam of EM_GET/SETIMESTATUS //

  EMSIS_COMPOSITIONSTRING = $0001;
  {$EXTERNALSYM EMSIS_COMPOSITIONSTRING}

// lParam for EMSIS_COMPOSITIONSTRING //

  EIMES_GETCOMPSTRATONCE         = $0001;
  {$EXTERNALSYM EIMES_GETCOMPSTRATONCE}
  EIMES_CANCELCOMPSTRINFOCUS     = $0002;
  {$EXTERNALSYM EIMES_CANCELCOMPSTRINFOCUS}
  EIMES_COMPLETECOMPSTRKILLFOCUS = $0004;
  {$EXTERNALSYM EIMES_COMPLETECOMPSTRKILLFOCUS}

//
// Edit Control Messages
//

  EM_GETSEL              = $00B0;
  {$EXTERNALSYM EM_GETSEL}
  EM_SETSEL              = $00B1;
  {$EXTERNALSYM EM_SETSEL}
  EM_GETRECT             = $00B2;
  {$EXTERNALSYM EM_GETRECT}
  EM_SETRECT             = $00B3;
  {$EXTERNALSYM EM_SETRECT}
  EM_SETRECTNP           = $00B4;
  {$EXTERNALSYM EM_SETRECTNP}
  EM_SCROLL              = $00B5;
  {$EXTERNALSYM EM_SCROLL}
  EM_LINESCROLL          = $00B6;
  {$EXTERNALSYM EM_LINESCROLL}
  EM_SCROLLCARET         = $00B7;
  {$EXTERNALSYM EM_SCROLLCARET}
  EM_GETMODIFY           = $00B8;
  {$EXTERNALSYM EM_GETMODIFY}
  EM_SETMODIFY           = $00B9;
  {$EXTERNALSYM EM_SETMODIFY}
  EM_GETLINECOUNT        = $00BA;
  {$EXTERNALSYM EM_GETLINECOUNT}
  EM_LINEINDEX           = $00BB;
  {$EXTERNALSYM EM_LINEINDEX}
  EM_SETHANDLE           = $00BC;
  {$EXTERNALSYM EM_SETHANDLE}
  EM_GETHANDLE           = $00BD;
  {$EXTERNALSYM EM_GETHANDLE}
  EM_GETTHUMB            = $00BE;
  {$EXTERNALSYM EM_GETTHUMB}
  EM_LINELENGTH          = $00C1;
  {$EXTERNALSYM EM_LINELENGTH}
  EM_REPLACESEL          = $00C2;
  {$EXTERNALSYM EM_REPLACESEL}
  EM_GETLINE             = $00C4;
  {$EXTERNALSYM EM_GETLINE}
  EM_LIMITTEXT           = $00C5;
  {$EXTERNALSYM EM_LIMITTEXT}
  EM_CANUNDO             = $00C6;
  {$EXTERNALSYM EM_CANUNDO}
  EM_UNDO                = $00C7;
  {$EXTERNALSYM EM_UNDO}
  EM_FMTLINES            = $00C8;
  {$EXTERNALSYM EM_FMTLINES}
  EM_LINEFROMCHAR        = $00C9;
  {$EXTERNALSYM EM_LINEFROMCHAR}
  EM_SETTABSTOPS         = $00CB;
  {$EXTERNALSYM EM_SETTABSTOPS}
  EM_SETPASSWORDCHAR     = $00CC;
  {$EXTERNALSYM EM_SETPASSWORDCHAR}
  EM_EMPTYUNDOBUFFER     = $00CD;
  {$EXTERNALSYM EM_EMPTYUNDOBUFFER}
  EM_GETFIRSTVISIBLELINE = $00CE;
  {$EXTERNALSYM EM_GETFIRSTVISIBLELINE}
  EM_SETREADONLY         = $00CF;
  {$EXTERNALSYM EM_SETREADONLY}
  EM_SETWORDBREAKPROC    = $00D0;
  {$EXTERNALSYM EM_SETWORDBREAKPROC}
  EM_GETWORDBREAKPROC    = $00D1;
  {$EXTERNALSYM EM_GETWORDBREAKPROC}
  EM_GETPASSWORDCHAR     = $00D2;
  {$EXTERNALSYM EM_GETPASSWORDCHAR}
  EM_SETMARGINS          = $00D3;
  {$EXTERNALSYM EM_SETMARGINS}
  EM_GETMARGINS          = $00D4;
  {$EXTERNALSYM EM_GETMARGINS}
  EM_SETLIMITTEXT        = EM_LIMITTEXT; // ;win40 Name change
  {$EXTERNALSYM EM_SETLIMITTEXT}
  EM_GETLIMITTEXT        = $00D5;
  {$EXTERNALSYM EM_GETLIMITTEXT}
  EM_POSFROMCHAR         = $00D6;
  {$EXTERNALSYM EM_POSFROMCHAR}
  EM_CHARFROMPOS         = $00D7;
  {$EXTERNALSYM EM_CHARFROMPOS}

  EM_SETIMESTATUS = $00D8;
  {$EXTERNALSYM EM_SETIMESTATUS}
  EM_GETIMESTATUS = $00D9;
  {$EXTERNALSYM EM_GETIMESTATUS}

//
// EDITWORDBREAKPROC code values
//

  WB_LEFT        = 0;
  {$EXTERNALSYM WB_LEFT}
  WB_RIGHT       = 1;
  {$EXTERNALSYM WB_RIGHT}
  WB_ISDELIMITER = 2;
  {$EXTERNALSYM WB_ISDELIMITER}

//
// Button Control Styles
//

  BS_PUSHBUTTON      = $00000000;
  {$EXTERNALSYM BS_PUSHBUTTON}
  BS_DEFPUSHBUTTON   = $00000001;
  {$EXTERNALSYM BS_DEFPUSHBUTTON}
  BS_CHECKBOX        = $00000002;
  {$EXTERNALSYM BS_CHECKBOX}
  BS_AUTOCHECKBOX    = $00000003;
  {$EXTERNALSYM BS_AUTOCHECKBOX}
  BS_RADIOBUTTON     = $00000004;
  {$EXTERNALSYM BS_RADIOBUTTON}
  BS_3STATE          = $00000005;
  {$EXTERNALSYM BS_3STATE}
  BS_AUTO3STATE      = $00000006;
  {$EXTERNALSYM BS_AUTO3STATE}
  BS_GROUPBOX        = $00000007;
  {$EXTERNALSYM BS_GROUPBOX}
  BS_USERBUTTON      = $00000008;
  {$EXTERNALSYM BS_USERBUTTON}
  BS_AUTORADIOBUTTON = $00000009;
  {$EXTERNALSYM BS_AUTORADIOBUTTON}
  BS_PUSHBOX         = $0000000A;
  {$EXTERNALSYM BS_PUSHBOX}
  BS_OWNERDRAW       = $0000000B;
  {$EXTERNALSYM BS_OWNERDRAW}
  BS_TYPEMASK        = $0000000F;
  {$EXTERNALSYM BS_TYPEMASK}
  BS_LEFTTEXT        = $00000020;
  {$EXTERNALSYM BS_LEFTTEXT}
  BS_TEXT            = $00000000;
  {$EXTERNALSYM BS_TEXT}
  BS_ICON            = $00000040;
  {$EXTERNALSYM BS_ICON}
  BS_BITMAP          = $00000080;
  {$EXTERNALSYM BS_BITMAP}
  BS_LEFT            = $00000100;
  {$EXTERNALSYM BS_LEFT}
  BS_RIGHT           = $00000200;
  {$EXTERNALSYM BS_RIGHT}
  BS_CENTER          = $00000300;
  {$EXTERNALSYM BS_CENTER}
  BS_TOP             = $00000400;
  {$EXTERNALSYM BS_TOP}
  BS_BOTTOM          = $00000800;
  {$EXTERNALSYM BS_BOTTOM}
  BS_VCENTER         = $00000C00;
  {$EXTERNALSYM BS_VCENTER}
  BS_PUSHLIKE        = $00001000;
  {$EXTERNALSYM BS_PUSHLIKE}
  BS_MULTILINE       = $00002000;
  {$EXTERNALSYM BS_MULTILINE}
  BS_NOTIFY          = $00004000;
  {$EXTERNALSYM BS_NOTIFY}
  BS_FLAT            = $00008000;
  {$EXTERNALSYM BS_FLAT}
  BS_RIGHTBUTTON     = BS_LEFTTEXT;
  {$EXTERNALSYM BS_RIGHTBUTTON}

//
// User Button Notification Codes
//

  BN_CLICKED       = 0;
  {$EXTERNALSYM BN_CLICKED}
  BN_PAINT         = 1;
  {$EXTERNALSYM BN_PAINT}
  BN_HILITE        = 2;
  {$EXTERNALSYM BN_HILITE}
  BN_UNHILITE      = 3;
  {$EXTERNALSYM BN_UNHILITE}
  BN_DISABLE       = 4;
  {$EXTERNALSYM BN_DISABLE}
  BN_DOUBLECLICKED = 5;
  {$EXTERNALSYM BN_DOUBLECLICKED}
  BN_PUSHED        = BN_HILITE;
  {$EXTERNALSYM BN_PUSHED}
  BN_UNPUSHED      = BN_UNHILITE;
  {$EXTERNALSYM BN_UNPUSHED}
  BN_DBLCLK        = BN_DOUBLECLICKED;
  {$EXTERNALSYM BN_DBLCLK}
  BN_SETFOCUS      = 6;
  {$EXTERNALSYM BN_SETFOCUS}
  BN_KILLFOCUS     = 7;
  {$EXTERNALSYM BN_KILLFOCUS}

//
// Button Control Messages
//

  BM_GETCHECK = $00F0;
  {$EXTERNALSYM BM_GETCHECK}
  BM_SETCHECK = $00F1;
  {$EXTERNALSYM BM_SETCHECK}
  BM_GETSTATE = $00F2;
  {$EXTERNALSYM BM_GETSTATE}
  BM_SETSTATE = $00F3;
  {$EXTERNALSYM BM_SETSTATE}
  BM_SETSTYLE = $00F4;
  {$EXTERNALSYM BM_SETSTYLE}
  BM_CLICK    = $00F5;
  {$EXTERNALSYM BM_CLICK}
  BM_GETIMAGE = $00F6;
  {$EXTERNALSYM BM_GETIMAGE}
  BM_SETIMAGE = $00F7;
  {$EXTERNALSYM BM_SETIMAGE}

  BST_UNCHECKED     = $0000;
  {$EXTERNALSYM BST_UNCHECKED}
  BST_CHECKED       = $0001;
  {$EXTERNALSYM BST_CHECKED}
  BST_INDETERMINATE = $0002;
  {$EXTERNALSYM BST_INDETERMINATE}
  BST_PUSHED        = $0004;
  {$EXTERNALSYM BST_PUSHED}
  BST_FOCUS         = $0008;
  {$EXTERNALSYM BST_FOCUS}

//
// Static Control Constants
//

  SS_LEFT           = $00000000;
  {$EXTERNALSYM SS_LEFT}
  SS_CENTER         = $00000001;
  {$EXTERNALSYM SS_CENTER}
  SS_RIGHT          = $00000002;
  {$EXTERNALSYM SS_RIGHT}
  SS_ICON           = $00000003;
  {$EXTERNALSYM SS_ICON}
  SS_BLACKRECT      = $00000004;
  {$EXTERNALSYM SS_BLACKRECT}
  SS_GRAYRECT       = $00000005;
  {$EXTERNALSYM SS_GRAYRECT}
  SS_WHITERECT      = $00000006;
  {$EXTERNALSYM SS_WHITERECT}
  SS_BLACKFRAME     = $00000007;
  {$EXTERNALSYM SS_BLACKFRAME}
  SS_GRAYFRAME      = $00000008;
  {$EXTERNALSYM SS_GRAYFRAME}
  SS_WHITEFRAME     = $00000009;
  {$EXTERNALSYM SS_WHITEFRAME}
  SS_USERITEM       = $0000000A;
  {$EXTERNALSYM SS_USERITEM}
  SS_SIMPLE         = $0000000B;
  {$EXTERNALSYM SS_SIMPLE}
  SS_LEFTNOWORDWRAP = $0000000C;
  {$EXTERNALSYM SS_LEFTNOWORDWRAP}
  SS_OWNERDRAW      = $0000000D;
  {$EXTERNALSYM SS_OWNERDRAW}
  SS_BITMAP         = $0000000E;
  {$EXTERNALSYM SS_BITMAP}
  SS_ENHMETAFILE    = $0000000F;
  {$EXTERNALSYM SS_ENHMETAFILE}
  SS_ETCHEDHORZ     = $00000010;
  {$EXTERNALSYM SS_ETCHEDHORZ}
  SS_ETCHEDVERT     = $00000011;
  {$EXTERNALSYM SS_ETCHEDVERT}
  SS_ETCHEDFRAME    = $00000012;
  {$EXTERNALSYM SS_ETCHEDFRAME}
  SS_TYPEMASK       = $0000001F;
  {$EXTERNALSYM SS_TYPEMASK}
  SS_REALSIZECONTROL = $00000040;
  {$EXTERNALSYM SS_REALSIZECONTROL}
  SS_NOPREFIX       = $00000080; // Don't do "&" character translation
  {$EXTERNALSYM SS_NOPREFIX}
  SS_NOTIFY         = $00000100;
  {$EXTERNALSYM SS_NOTIFY}
  SS_CENTERIMAGE    = $00000200;
  {$EXTERNALSYM SS_CENTERIMAGE}
  SS_RIGHTJUST      = $00000400;
  {$EXTERNALSYM SS_RIGHTJUST}
  SS_REALSIZEIMAGE  = $00000800;
  {$EXTERNALSYM SS_REALSIZEIMAGE}
  SS_SUNKEN         = $00001000;
  {$EXTERNALSYM SS_SUNKEN}
  SS_EDITCONTROL    = $00002000;
  {$EXTERNALSYM SS_EDITCONTROL}
  SS_ENDELLIPSIS    = $00004000;
  {$EXTERNALSYM SS_ENDELLIPSIS}
  SS_PATHELLIPSIS   = $00008000;
  {$EXTERNALSYM SS_PATHELLIPSIS}
  SS_WORDELLIPSIS   = $0000C000;
  {$EXTERNALSYM SS_WORDELLIPSIS}
  SS_ELLIPSISMASK   = $0000C000;
  {$EXTERNALSYM SS_ELLIPSISMASK}

//
// Static Control Mesages
//

  STM_SETICON  = $0170;
  {$EXTERNALSYM STM_SETICON}
  STM_GETICON  = $0171;
  {$EXTERNALSYM STM_GETICON}
  STM_SETIMAGE = $0172;
  {$EXTERNALSYM STM_SETIMAGE}
  STM_GETIMAGE = $0173;
  {$EXTERNALSYM STM_GETIMAGE}
  STN_CLICKED  = 0;
  {$EXTERNALSYM STN_CLICKED}
  STN_DBLCLK   = 1;
  {$EXTERNALSYM STN_DBLCLK}
  STN_ENABLE   = 2;
  {$EXTERNALSYM STN_ENABLE}
  STN_DISABLE  = 3;
  {$EXTERNALSYM STN_DISABLE}
  STM_MSGMAX   = $0174;
  {$EXTERNALSYM STM_MSGMAX}

//
// Dialog window class
//

  WC_DIALOG = MAKEINTATOM($8002);
  {$EXTERNALSYM WC_DIALOG}

//
// Get/SetWindowWord/Long offsets for use with WC_DIALOG windows
//

  DWL_MSGRESULT = 0;
  {$EXTERNALSYM DWL_MSGRESULT}
  DWL_DLGPROC   = 4;
  {$EXTERNALSYM DWL_DLGPROC}
  DWL_USER      = 8;
  {$EXTERNALSYM DWL_USER}

  DWLP_MSGRESULT = 0;
  {$EXTERNALSYM DWLP_MSGRESULT}
  DWLP_DLGPROC   = DWLP_MSGRESULT + SizeOf(LRESULT);
  {$EXTERNALSYM DWLP_DLGPROC}
  DWLP_USER      = DWLP_DLGPROC + SizeOf(DLGPROC);
  {$EXTERNALSYM DWLP_USER}

//
// Dialog Manager Routines
//

function IsDialogMessageA(hDlg: HWND; const lpMsg: MSG): BOOL; stdcall;
{$EXTERNALSYM IsDialogMessageA}
function IsDialogMessageW(hDlg: HWND; const lpMsg: MSG): BOOL; stdcall;
{$EXTERNALSYM IsDialogMessageW}
function IsDialogMessage(hDlg: HWND; const lpMsg: MSG): BOOL; stdcall;
{$EXTERNALSYM IsDialogMessage}

function MapDialogRect(hDlg: HWND; var lpRect: RECT): BOOL; stdcall;
{$EXTERNALSYM MapDialogRect}

function DlgDirListA(hDlg: HWND; lpPathSpec: LPSTR; nIDListBox: Integer;
  nIDStaticPath: Integer; uFileType: UINT): Integer; stdcall;
{$EXTERNALSYM DlgDirListA}
function DlgDirListW(hDlg: HWND; lpPathSpec: LPWSTR; nIDListBox: Integer;
  nIDStaticPath: Integer; uFileType: UINT): Integer; stdcall;
{$EXTERNALSYM DlgDirListW}
function DlgDirList(hDlg: HWND; lpPathSpec: LPTSTR; nIDListBox: Integer;
  nIDStaticPath: Integer; uFileType: UINT): Integer; stdcall;
{$EXTERNALSYM DlgDirList}

//
// DlgDirList, DlgDirListComboBox flags values
//

const
  DDL_READWRITE = $0000;
  {$EXTERNALSYM DDL_READWRITE}
  DDL_READONLY  = $0001;
  {$EXTERNALSYM DDL_READONLY}
  DDL_HIDDEN    = $0002;
  {$EXTERNALSYM DDL_HIDDEN}
  DDL_SYSTEM    = $0004;
  {$EXTERNALSYM DDL_SYSTEM}
  DDL_DIRECTORY = $0010;
  {$EXTERNALSYM DDL_DIRECTORY}
  DDL_ARCHIVE   = $0020;
  {$EXTERNALSYM DDL_ARCHIVE}

  DDL_POSTMSGS  = $2000;
  {$EXTERNALSYM DDL_POSTMSGS}
  DDL_DRIVES    = $4000;
  {$EXTERNALSYM DDL_DRIVES}
  DDL_EXCLUSIVE = $8000;
  {$EXTERNALSYM DDL_EXCLUSIVE}

function DlgDirSelectExA(hDlg: HWND; lpString: LPSTR; nCount, nIDListBox: Integer): BOOL; stdcall;
{$EXTERNALSYM DlgDirSelectExA}
function DlgDirSelectExW(hDlg: HWND; lpString: LPWSTR; nCount, nIDListBox: Integer): BOOL; stdcall;
{$EXTERNALSYM DlgDirSelectExW}
function DlgDirSelectEx(hDlg: HWND; lpString: LPTSTR; nCount, nIDListBox: Integer): BOOL; stdcall;
{$EXTERNALSYM DlgDirSelectEx}

function DlgDirListComboBoxA(hDlg: HWND; lpPathSpec: LPSTR; nIDComboBox: Integer;
  nIDStaticPath: Integer; uFiletype: UINT): Integer; stdcall;
{$EXTERNALSYM DlgDirListComboBoxA}
function DlgDirListComboBoxW(hDlg: HWND; lpPathSpec: LPWSTR; nIDComboBox: Integer;
  nIDStaticPath: Integer; uFiletype: UINT): Integer; stdcall;
{$EXTERNALSYM DlgDirListComboBoxW}
function DlgDirListComboBox(hDlg: HWND; lpPathSpec: LPTSTR; nIDComboBox: Integer;
  nIDStaticPath: Integer; uFiletype: UINT): Integer; stdcall;
{$EXTERNALSYM DlgDirListComboBox}

function DlgDirSelectComboBoxExA(hDlg: HWND; lpString: LPSTR; nCount: Integer;
  nIDComboBox: Integer): BOOL; stdcall;
{$EXTERNALSYM DlgDirSelectComboBoxExA}
function DlgDirSelectComboBoxExW(hDlg: HWND; lpString: LPWSTR; nCount: Integer;
  nIDComboBox: Integer): BOOL; stdcall;
{$EXTERNALSYM DlgDirSelectComboBoxExW}
function DlgDirSelectComboBoxEx(hDlg: HWND; lpString: LPTSTR; nCount: Integer;
  nIDComboBox: Integer): BOOL; stdcall;
{$EXTERNALSYM DlgDirSelectComboBoxEx}

//
// Dialog Styles
//

const
  DS_ABSALIGN      = $01;
  {$EXTERNALSYM DS_ABSALIGN}
  DS_SYSMODAL      = $02;
  {$EXTERNALSYM DS_SYSMODAL}
  DS_LOCALEDIT     = $20; // Edit items get Local storage.
  {$EXTERNALSYM DS_LOCALEDIT}
  DS_SETFONT       = $40; // User specified font for Dlg controls
  {$EXTERNALSYM DS_SETFONT}
  DS_MODALFRAME    = $80; // Can be combined with WS_CAPTION
  {$EXTERNALSYM DS_MODALFRAME}
  DS_NOIDLEMSG     = $100; // WM_ENTERIDLE message will not be sent
  {$EXTERNALSYM DS_NOIDLEMSG}
  DS_SETFOREGROUND = $200; // not in win3.1
  {$EXTERNALSYM DS_SETFOREGROUND}

  DS_3DLOOK       = $0004;
  {$EXTERNALSYM DS_3DLOOK}
  DS_FIXEDSYS     = $0008;
  {$EXTERNALSYM DS_FIXEDSYS}
  DS_NOFAILCREATE = $0010;
  {$EXTERNALSYM DS_NOFAILCREATE}
  DS_CONTROL      = $0400;
  {$EXTERNALSYM DS_CONTROL}
  DS_CENTER       = $0800;
  {$EXTERNALSYM DS_CENTER}
  DS_CENTERMOUSE  = $1000;
  {$EXTERNALSYM DS_CENTERMOUSE}
  DS_CONTEXTHELP  = $2000;
  {$EXTERNALSYM DS_CONTEXTHELP}

  DS_SHELLFONT = DS_SETFONT or DS_FIXEDSYS;
  {$EXTERNALSYM DS_SHELLFONT}

//#if(_WIN32_WCE >= 0x0500)
  DS_USEPIXELS = $8000;
  {$EXTERNALSYM DS_USEPIXELS}
//#endif

  DM_GETDEFID = WM_USER + 0;
  {$EXTERNALSYM DM_GETDEFID}
  DM_SETDEFID = WM_USER + 1;
  {$EXTERNALSYM DM_SETDEFID}

  DM_REPOSITION = WM_USER + 2;
  {$EXTERNALSYM DM_REPOSITION}

//
// Returned in HIWORD() of DM_GETDEFID result if msg is supported
//

  DC_HASDEFID = $534B;
  {$EXTERNALSYM DC_HASDEFID}

//
// Dialog Codes
//

  DLGC_WANTARROWS      = $0001; // Control wants arrow keys
  {$EXTERNALSYM DLGC_WANTARROWS}
  DLGC_WANTTAB         = $0002; // Control wants tab keys
  {$EXTERNALSYM DLGC_WANTTAB}
  DLGC_WANTALLKEYS     = $0004; // Control wants all keys
  {$EXTERNALSYM DLGC_WANTALLKEYS}
  DLGC_WANTMESSAGE     = $0004; // Pass message to control
  {$EXTERNALSYM DLGC_WANTMESSAGE}
  DLGC_HASSETSEL       = $0008; // Understands EM_SETSEL message
  {$EXTERNALSYM DLGC_HASSETSEL}
  DLGC_DEFPUSHBUTTON   = $0010; // Default pushbutton
  {$EXTERNALSYM DLGC_DEFPUSHBUTTON}
  DLGC_UNDEFPUSHBUTTON = $0020; // Non-default pushbutton
  {$EXTERNALSYM DLGC_UNDEFPUSHBUTTON}
  DLGC_RADIOBUTTON     = $0040; // Radio button
  {$EXTERNALSYM DLGC_RADIOBUTTON}
  DLGC_WANTCHARS       = $0080; // Want WM_CHAR messages
  {$EXTERNALSYM DLGC_WANTCHARS}
  DLGC_STATIC          = $0100; // Static item: don't include
  {$EXTERNALSYM DLGC_STATIC}
  DLGC_BUTTON          = $2000; // Button item: can be checked
  {$EXTERNALSYM DLGC_BUTTON}

  LB_CTLCODE = 0;
  {$EXTERNALSYM LB_CTLCODE}

//
// Listbox Return Values
//

  LB_OKAY     = 0;
  {$EXTERNALSYM LB_OKAY}
  LB_ERR      = DWORD(-1);
  {$EXTERNALSYM LB_ERR}
  LB_ERRSPACE = DWORD(-2);
  {$EXTERNALSYM LB_ERRSPACE}

//
//  The idStaticPath parameter to DlgDirList can have the following values
//  ORed if the list box should show other details of the files along with
//  the name of the files;
//
// all other details also will be returned

//
// Listbox Notification Codes
//

  LBN_ERRSPACE  = DWORD(-2);
  {$EXTERNALSYM LBN_ERRSPACE}
  LBN_SELCHANGE = 1;
  {$EXTERNALSYM LBN_SELCHANGE}
  LBN_DBLCLK    = 2;
  {$EXTERNALSYM LBN_DBLCLK}
  LBN_SELCANCEL = 3;
  {$EXTERNALSYM LBN_SELCANCEL}
  LBN_SETFOCUS  = 4;
  {$EXTERNALSYM LBN_SETFOCUS}
  LBN_KILLFOCUS = 5;
  {$EXTERNALSYM LBN_KILLFOCUS}

//
// Listbox messages
//

  LB_ADDSTRING           = $0180;
  {$EXTERNALSYM LB_ADDSTRING}
  LB_INSERTSTRING        = $0181;
  {$EXTERNALSYM LB_INSERTSTRING}
  LB_DELETESTRING        = $0182;
  {$EXTERNALSYM LB_DELETESTRING}
  LB_SELITEMRANGEEX      = $0183;
  {$EXTERNALSYM LB_SELITEMRANGEEX}
  LB_RESETCONTENT        = $0184;
  {$EXTERNALSYM LB_RESETCONTENT}
  LB_SETSEL              = $0185;
  {$EXTERNALSYM LB_SETSEL}
  LB_SETCURSEL           = $0186;
  {$EXTERNALSYM LB_SETCURSEL}
  LB_GETSEL              = $0187;
  {$EXTERNALSYM LB_GETSEL}
  LB_GETCURSEL           = $0188;
  {$EXTERNALSYM LB_GETCURSEL}
  LB_GETTEXT             = $0189;
  {$EXTERNALSYM LB_GETTEXT}
  LB_GETTEXTLEN          = $018A;
  {$EXTERNALSYM LB_GETTEXTLEN}
  LB_GETCOUNT            = $018B;
  {$EXTERNALSYM LB_GETCOUNT}
  LB_SELECTSTRING        = $018C;
  {$EXTERNALSYM LB_SELECTSTRING}
  LB_DIR                 = $018D;
  {$EXTERNALSYM LB_DIR}
  LB_GETTOPINDEX         = $018E;
  {$EXTERNALSYM LB_GETTOPINDEX}
  LB_FINDSTRING          = $018F;
  {$EXTERNALSYM LB_FINDSTRING}
  LB_GETSELCOUNT         = $0190;
  {$EXTERNALSYM LB_GETSELCOUNT}
  LB_GETSELITEMS         = $0191;
  {$EXTERNALSYM LB_GETSELITEMS}
  LB_SETTABSTOPS         = $0192;
  {$EXTERNALSYM LB_SETTABSTOPS}
  LB_GETHORIZONTALEXTENT = $0193;
  {$EXTERNALSYM LB_GETHORIZONTALEXTENT}
  LB_SETHORIZONTALEXTENT = $0194;
  {$EXTERNALSYM LB_SETHORIZONTALEXTENT}
  LB_SETCOLUMNWIDTH      = $0195;
  {$EXTERNALSYM LB_SETCOLUMNWIDTH}
  LB_ADDFILE             = $0196;
  {$EXTERNALSYM LB_ADDFILE}
  LB_SETTOPINDEX         = $0197;
  {$EXTERNALSYM LB_SETTOPINDEX}
  LB_GETITEMRECT         = $0198;
  {$EXTERNALSYM LB_GETITEMRECT}
  LB_GETITEMDATA         = $0199;
  {$EXTERNALSYM LB_GETITEMDATA}
  LB_SETITEMDATA         = $019A;
  {$EXTERNALSYM LB_SETITEMDATA}
  LB_SELITEMRANGE        = $019B;
  {$EXTERNALSYM LB_SELITEMRANGE}
  LB_SETANCHORINDEX      = $019C;
  {$EXTERNALSYM LB_SETANCHORINDEX}
  LB_GETANCHORINDEX      = $019D;
  {$EXTERNALSYM LB_GETANCHORINDEX}
  LB_SETCARETINDEX       = $019E;
  {$EXTERNALSYM LB_SETCARETINDEX}
  LB_GETCARETINDEX       = $019F;
  {$EXTERNALSYM LB_GETCARETINDEX}
  LB_SETITEMHEIGHT       = $01A0;
  {$EXTERNALSYM LB_SETITEMHEIGHT}
  LB_GETITEMHEIGHT       = $01A1;
  {$EXTERNALSYM LB_GETITEMHEIGHT}
  LB_FINDSTRINGEXACT     = $01A2;
  {$EXTERNALSYM LB_FINDSTRINGEXACT}
  LB_SETLOCALE           = $01A5;
  {$EXTERNALSYM LB_SETLOCALE}
  LB_GETLOCALE           = $01A6;
  {$EXTERNALSYM LB_GETLOCALE}
  LB_SETCOUNT            = $01A7;
  {$EXTERNALSYM LB_SETCOUNT}
  LB_INITSTORAGE   = $01A8;
  {$EXTERNALSYM LB_INITSTORAGE}
  LB_ITEMFROMPOINT = $01A9;
  {$EXTERNALSYM LB_ITEMFROMPOINT}
  LB_MULTIPLEADDSTRING = $01B1;
  {$EXTERNALSYM LB_MULTIPLEADDSTRING}
  LB_GETLISTBOXINFO    = $01B2;
  {$EXTERNALSYM LB_GETLISTBOXINFO}

  {$IFDEF WINXP_UP}
  LB_MSGMAX = $01B3;
  {$EXTERNALSYM LB_MSGMAX}
  {$ELSE}
  LB_MSGMAX = $01B0;
  {$EXTERNALSYM LB_MSGMAX}
  {$ENDIF WINXP_UP}

//
// Listbox Styles
//

  LBS_NOTIFY            = $0001;
  {$EXTERNALSYM LBS_NOTIFY}
  LBS_SORT              = $0002;
  {$EXTERNALSYM LBS_SORT}
  LBS_NOREDRAW          = $0004;
  {$EXTERNALSYM LBS_NOREDRAW}
  LBS_MULTIPLESEL       = $0008;
  {$EXTERNALSYM LBS_MULTIPLESEL}
  LBS_OWNERDRAWFIXED    = $0010;
  {$EXTERNALSYM LBS_OWNERDRAWFIXED}
  LBS_OWNERDRAWVARIABLE = $0020;
  {$EXTERNALSYM LBS_OWNERDRAWVARIABLE}
  LBS_HASSTRINGS        = $0040;
  {$EXTERNALSYM LBS_HASSTRINGS}
  LBS_USETABSTOPS       = $0080;
  {$EXTERNALSYM LBS_USETABSTOPS}
  LBS_NOINTEGRALHEIGHT  = $0100;
  {$EXTERNALSYM LBS_NOINTEGRALHEIGHT}
  LBS_MULTICOLUMN       = $0200;
  {$EXTERNALSYM LBS_MULTICOLUMN}
  LBS_WANTKEYBOARDINPUT = $0400;
  {$EXTERNALSYM LBS_WANTKEYBOARDINPUT}
  LBS_EXTENDEDSEL       = $0800;
  {$EXTERNALSYM LBS_EXTENDEDSEL}
  LBS_DISABLENOSCROLL   = $1000;
  {$EXTERNALSYM LBS_DISABLENOSCROLL}
  LBS_NODATA            = $2000;
  {$EXTERNALSYM LBS_NODATA}
  LBS_NOSEL             = $4000;
  {$EXTERNALSYM LBS_NOSEL}
  LBS_COMBOBOX          = $8000;
  {$EXTERNALSYM LBS_COMBOBOX}
  
  LBS_STANDARD          = LBS_NOTIFY or LBS_SORT or WS_VSCROLL or WS_BORDER;
  {$EXTERNALSYM LBS_STANDARD}

//
// Combo Box return Values
//

  CB_OKAY     = 0;
  {$EXTERNALSYM CB_OKAY}
  CB_ERR      = DWORD(-1);
  {$EXTERNALSYM CB_ERR}
  CB_ERRSPACE = DWORD(-2);
  {$EXTERNALSYM CB_ERRSPACE}

//
// Combo Box Notification Codes
//

  CBN_ERRSPACE     = DWORD(-1);
  {$EXTERNALSYM CBN_ERRSPACE}
  CBN_SELCHANGE    = 1;
  {$EXTERNALSYM CBN_SELCHANGE}
  CBN_DBLCLK       = 2;
  {$EXTERNALSYM CBN_DBLCLK}
  CBN_SETFOCUS     = 3;
  {$EXTERNALSYM CBN_SETFOCUS}
  CBN_KILLFOCUS    = 4;
  {$EXTERNALSYM CBN_KILLFOCUS}
  CBN_EDITCHANGE   = 5;
  {$EXTERNALSYM CBN_EDITCHANGE}
  CBN_EDITUPDATE   = 6;
  {$EXTERNALSYM CBN_EDITUPDATE}
  CBN_DROPDOWN     = 7;
  {$EXTERNALSYM CBN_DROPDOWN}
  CBN_CLOSEUP      = 8;
  {$EXTERNALSYM CBN_CLOSEUP}
  CBN_SELENDOK     = 9;
  {$EXTERNALSYM CBN_SELENDOK}
  CBN_SELENDCANCEL = 10;
  {$EXTERNALSYM CBN_SELENDCANCEL}

//
// Combo Box styles
//

  CBS_SIMPLE            = $0001;
  {$EXTERNALSYM CBS_SIMPLE}
  CBS_DROPDOWN          = $0002;
  {$EXTERNALSYM CBS_DROPDOWN}
  CBS_DROPDOWNLIST      = $0003;
  {$EXTERNALSYM CBS_DROPDOWNLIST}
  CBS_OWNERDRAWFIXED    = $0010;
  {$EXTERNALSYM CBS_OWNERDRAWFIXED}
  CBS_OWNERDRAWVARIABLE = $0020;
  {$EXTERNALSYM CBS_OWNERDRAWVARIABLE}
  CBS_AUTOHSCROLL       = $0040;
  {$EXTERNALSYM CBS_AUTOHSCROLL}
  CBS_OEMCONVERT        = $0080;
  {$EXTERNALSYM CBS_OEMCONVERT}
  CBS_SORT              = $0100;
  {$EXTERNALSYM CBS_SORT}
  CBS_HASSTRINGS        = $0200;
  {$EXTERNALSYM CBS_HASSTRINGS}
  CBS_NOINTEGRALHEIGHT  = $0400;
  {$EXTERNALSYM CBS_NOINTEGRALHEIGHT}
  CBS_DISABLENOSCROLL   = $0800;
  {$EXTERNALSYM CBS_DISABLENOSCROLL}
  CBS_UPPERCASE         = $2000;
  {$EXTERNALSYM CBS_UPPERCASE}
  CBS_LOWERCASE         = $4000;
  {$EXTERNALSYM CBS_LOWERCASE}

//
// Combo Box messages
//

  CB_GETEDITSEL            = $0140;
  {$EXTERNALSYM CB_GETEDITSEL}
  CB_LIMITTEXT             = $0141;
  {$EXTERNALSYM CB_LIMITTEXT}
  CB_SETEDITSEL            = $0142;
  {$EXTERNALSYM CB_SETEDITSEL}
  CB_ADDSTRING             = $0143;
  {$EXTERNALSYM CB_ADDSTRING}
  CB_DELETESTRING          = $0144;
  {$EXTERNALSYM CB_DELETESTRING}
  CB_DIR                   = $0145;
  {$EXTERNALSYM CB_DIR}
  CB_GETCOUNT              = $0146;
  {$EXTERNALSYM CB_GETCOUNT}
  CB_GETCURSEL             = $0147;
  {$EXTERNALSYM CB_GETCURSEL}
  CB_GETLBTEXT             = $0148;
  {$EXTERNALSYM CB_GETLBTEXT}
  CB_GETLBTEXTLEN          = $0149;
  {$EXTERNALSYM CB_GETLBTEXTLEN}
  CB_INSERTSTRING          = $014A;
  {$EXTERNALSYM CB_INSERTSTRING}
  CB_RESETCONTENT          = $014B;
  {$EXTERNALSYM CB_RESETCONTENT}
  CB_FINDSTRING            = $014C;
  {$EXTERNALSYM CB_FINDSTRING}
  CB_SELECTSTRING          = $014D;
  {$EXTERNALSYM CB_SELECTSTRING}
  CB_SETCURSEL             = $014E;
  {$EXTERNALSYM CB_SETCURSEL}
  CB_SHOWDROPDOWN          = $014F;
  {$EXTERNALSYM CB_SHOWDROPDOWN}
  CB_GETITEMDATA           = $0150;
  {$EXTERNALSYM CB_GETITEMDATA}
  CB_SETITEMDATA           = $0151;
  {$EXTERNALSYM CB_SETITEMDATA}
  CB_GETDROPPEDCONTROLRECT = $0152;
  {$EXTERNALSYM CB_GETDROPPEDCONTROLRECT}
  CB_SETITEMHEIGHT         = $0153;
  {$EXTERNALSYM CB_SETITEMHEIGHT}
  CB_GETITEMHEIGHT         = $0154;
  {$EXTERNALSYM CB_GETITEMHEIGHT}
  CB_SETEXTENDEDUI         = $0155;
  {$EXTERNALSYM CB_SETEXTENDEDUI}
  CB_GETEXTENDEDUI         = $0156;
  {$EXTERNALSYM CB_GETEXTENDEDUI}
  CB_GETDROPPEDSTATE       = $0157;
  {$EXTERNALSYM CB_GETDROPPEDSTATE}
  CB_FINDSTRINGEXACT       = $0158;
  {$EXTERNALSYM CB_FINDSTRINGEXACT}
  CB_SETLOCALE             = $0159;
  {$EXTERNALSYM CB_SETLOCALE}
  CB_GETLOCALE             = $015A;
  {$EXTERNALSYM CB_GETLOCALE}
  CB_GETTOPINDEX           = $015b;
  {$EXTERNALSYM CB_GETTOPINDEX}
  CB_SETTOPINDEX           = $015c;
  {$EXTERNALSYM CB_SETTOPINDEX}
  CB_GETHORIZONTALEXTENT   = $015d;
  {$EXTERNALSYM CB_GETHORIZONTALEXTENT}
  CB_SETHORIZONTALEXTENT   = $015e;
  {$EXTERNALSYM CB_SETHORIZONTALEXTENT}
  CB_GETDROPPEDWIDTH       = $015f;
  {$EXTERNALSYM CB_GETDROPPEDWIDTH}
  CB_SETDROPPEDWIDTH       = $0160;
  {$EXTERNALSYM CB_SETDROPPEDWIDTH}
  CB_INITSTORAGE           = $0161;
  {$EXTERNALSYM CB_INITSTORAGE}
  CB_MULTIPLEADDSTRING     = $0163;
  {$EXTERNALSYM CB_MULTIPLEADDSTRING}
  CB_GETCOMBOBOXINFO       = $0164;
  {$EXTERNALSYM CB_GETCOMBOBOXINFO}

  {$IFDEF WINXP_UP}
  CB_MSGMAX = $0165;
  {$EXTERNALSYM CB_MSGMAX}
  {$ELSE}
  CB_MSGMAX = $0162;
  {$EXTERNALSYM CB_MSGMAX}
  {$ENDIF WINXP_UP}

//
// Scroll Bar Styles
//

  SBS_HORZ                    = $0000;
  {$EXTERNALSYM SBS_HORZ}
  SBS_VERT                    = $0001;
  {$EXTERNALSYM SBS_VERT}
  SBS_TOPALIGN                = $0002;
  {$EXTERNALSYM SBS_TOPALIGN}
  SBS_LEFTALIGN               = $0002;
  {$EXTERNALSYM SBS_LEFTALIGN}
  SBS_BOTTOMALIGN             = $0004;
  {$EXTERNALSYM SBS_BOTTOMALIGN}
  SBS_RIGHTALIGN              = $0004;
  {$EXTERNALSYM SBS_RIGHTALIGN}
  SBS_SIZEBOXTOPLEFTALIGN     = $0002;
  {$EXTERNALSYM SBS_SIZEBOXTOPLEFTALIGN}
  SBS_SIZEBOXBOTTOMRIGHTALIGN = $0004;
  {$EXTERNALSYM SBS_SIZEBOXBOTTOMRIGHTALIGN}
  SBS_SIZEBOX                 = $0008;
  {$EXTERNALSYM SBS_SIZEBOX}
  SBS_SIZEGRIP                = $0010;
  {$EXTERNALSYM SBS_SIZEGRIP}

//
// Scroll bar messages
//

  SBM_SETPOS         = $00E0; // not in win3.1
  {$EXTERNALSYM SBM_SETPOS}
  SBM_GETPOS         = $00E1; // not in win3.1
  {$EXTERNALSYM SBM_GETPOS}
  SBM_SETRANGE       = $00E2; // not in win3.1
  {$EXTERNALSYM SBM_SETRANGE}
  SBM_SETRANGEREDRAW = $00E6; // not in win3.1
  {$EXTERNALSYM SBM_SETRANGEREDRAW}
  SBM_GETRANGE       = $00E3; // not in win3.1
  {$EXTERNALSYM SBM_GETRANGE}
  SBM_ENABLE_ARROWS  = $00E4; // not in win3.1
  {$EXTERNALSYM SBM_ENABLE_ARROWS}
  SBM_SETSCROLLINFO  = $00E9;
  {$EXTERNALSYM SBM_SETSCROLLINFO}
  SBM_GETSCROLLINFO  = $00EA;
  {$EXTERNALSYM SBM_GETSCROLLINFO}
  
  SBM_GETSCROLLBARINFO = $00EB;
  {$EXTERNALSYM SBM_GETSCROLLBARINFO}

  SIF_RANGE           = $0001;
  {$EXTERNALSYM SIF_RANGE}
  SIF_PAGE            = $0002;
  {$EXTERNALSYM SIF_PAGE}
  SIF_POS             = $0004;
  {$EXTERNALSYM SIF_POS}
  SIF_DISABLENOSCROLL = $0008;
  {$EXTERNALSYM SIF_DISABLENOSCROLL}
  SIF_TRACKPOS        = $0010;
  {$EXTERNALSYM SIF_TRACKPOS}
  SIF_ALL             = SIF_RANGE or SIF_PAGE or SIF_POS or SIF_TRACKPOS;
  {$EXTERNALSYM SIF_ALL}

type
  LPSCROLLINFO = ^SCROLLINFO;
  {$EXTERNALSYM LPSCROLLINFO}
  tagSCROLLINFO = record
    cbSize: UINT;
    fMask: UINT;
    nMin: Integer;
    nMax: Integer;
    nPage: UINT;
    nPos: Integer;
    nTrackPos: Integer;
  end;
  {$EXTERNALSYM tagSCROLLINFO}
  SCROLLINFO = tagSCROLLINFO;
  {$EXTERNALSYM SCROLLINFO}
  TScrollInfo = SCROLLINFO;
  PScrollInfo = LPSCROLLINFO;

function SetScrollInfo(hwnd: HWND; fnBar: Integer; const lpsi: SCROLLINFO;
  fRedraw: BOOL): Integer; stdcall;
{$EXTERNALSYM SetScrollInfo}

function GetScrollInfo(hwnd: HWND; fnBar: Integer; var lpsi: SCROLLINFO): BOOL; stdcall;
{$EXTERNALSYM GetScrollInfo}

//
// MDI client style bits
//

const
  MDIS_ALLCHILDSTYLES = $0001;
  {$EXTERNALSYM MDIS_ALLCHILDSTYLES}

//
// wParam Flags for WM_MDITILE and WM_MDICASCADE messages.
//

const
  MDITILE_VERTICAL     = $0000; // not in win3.1
  {$EXTERNALSYM MDITILE_VERTICAL}
  MDITILE_HORIZONTAL   = $0001; // not in win3.1
  {$EXTERNALSYM MDITILE_HORIZONTAL}
  MDITILE_SKIPDISABLED = $0002; // not in win3.1
  {$EXTERNALSYM MDITILE_SKIPDISABLED}
  MDITILE_ZORDER       = $0004;
  {$EXTERNALSYM MDITILE_ZORDER}

type
  LPMDICREATESTRUCTA = ^MDICREATESTRUCTA;
  {$EXTERNALSYM LPMDICREATESTRUCTA}
  tagMDICREATESTRUCTA = record
    szClass: LPCSTR;
    szTitle: LPCSTR;
    hOwner: HANDLE;
    x: Integer;
    y: Integer;
    cx: Integer;
    cy: Integer;
    style: DWORD;
    lParam: LPARAM; // app-defined stuff//
  end;
  {$EXTERNALSYM tagMDICREATESTRUCTA}
  MDICREATESTRUCTA = tagMDICREATESTRUCTA;
  {$EXTERNALSYM MDICREATESTRUCTA}
  TMdiCreateStructA = MDICREATESTRUCTA;
  PMdiCreateStructA = LPMDICREATESTRUCTA;

  LPMDICREATESTRUCTW = ^MDICREATESTRUCTW;
  {$EXTERNALSYM LPMDICREATESTRUCTW}
  tagMDICREATESTRUCTW = record
    szClass: LPCWSTR;
    szTitle: LPCWSTR;
    hOwner: HANDLE;
    x: Integer;
    y: Integer;
    cx: Integer;
    cy: Integer;
    style: DWORD;
    lParam: LPARAM; // app-defined stuff//
  end;
  {$EXTERNALSYM tagMDICREATESTRUCTW}
  MDICREATESTRUCTW = tagMDICREATESTRUCTW;
  {$EXTERNALSYM MDICREATESTRUCTW}
  TMdiCreateStructW = MDICREATESTRUCTW;
  PMdiCreateStructW = LPMDICREATESTRUCTW;

  {$IFDEF UNICODE}
  MDICREATESTRUCT = MDICREATESTRUCTW;
  {$EXTERNALSYM MDICREATESTRUCT}
  LPMDICREATESTRUCT = LPMDICREATESTRUCTW;
  {$EXTERNALSYM LPMDICREATESTRUCT}
  TMdiCreateStruct = TMdiCreateStructW;
  PMdiCreateStruct = PMdiCreateStructW;
  {$ELSE}
  MDICREATESTRUCT = MDICREATESTRUCTA;
  {$EXTERNALSYM MDICREATESTRUCT}
  LPMDICREATESTRUCT = LPMDICREATESTRUCTA;
  {$EXTERNALSYM LPMDICREATESTRUCT}
  TMdiCreateStruct = TMdiCreateStructA;
  PMdiCreateStruct = PMdiCreateStructA;
  {$ENDIF UNICODE}

  LPCLIENTCREATESTRUCT = ^CLIENTCREATESTRUCT;
  {$EXTERNALSYM LPCLIENTCREATESTRUCT}
  tagCLIENTCREATESTRUCT = record
    hWindowMenu: HANDLE;
    idFirstChild: UINT;
  end;
  {$EXTERNALSYM tagCLIENTCREATESTRUCT}
  CLIENTCREATESTRUCT = tagCLIENTCREATESTRUCT;
  {$EXTERNALSYM CLIENTCREATESTRUCT}
  TClientCreateStruct = CLIENTCREATESTRUCT;
  PClientCreateStruct = LPCLIENTCREATESTRUCT;

function DefFrameProcA(hWnd: HWND; hWndMDIClient: HWND; uMsg: UINT;
  wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefFrameProcA}
function DefFrameProcW(hWnd: HWND; hWndMDIClient: HWND; uMsg: UINT;
  wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefFrameProcW}
function DefFrameProc(hWnd: HWND; hWndMDIClient: HWND; uMsg: UINT;
  wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefFrameProc}

function DefMDIChildProcA(hWnd: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefMDIChildProcA}
function DefMDIChildProcW(hWnd: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefMDIChildProcW}
function DefMDIChildProc(hWnd: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
{$EXTERNALSYM DefMDIChildProc}

function TranslateMDISysAccel(hWndClient: HWND; const lpMsg: MSG): BOOL; stdcall;
{$EXTERNALSYM TranslateMDISysAccel}

function ArrangeIconicWindows(hWnd: HWND): UINT; stdcall;
{$EXTERNALSYM ArrangeIconicWindows}

function CreateMDIWindowA(lpClassName, lpWindowName: LPCSTR; dwStyle: DWORD;
  X, Y, nWidth, nHeight: Integer; hWndParent: HWND; hInstance: HINST;
  lParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateMDIWindowA}
function CreateMDIWindowW(lpClassName, lpWindowName: LPCWSTR; dwStyle: DWORD;
  X, Y, nWidth, nHeight: Integer; hWndParent: HWND; hInstance: HINST;
  lParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateMDIWindowW}
function CreateMDIWindow(lpClassName, lpWindowName: LPCTSTR; dwStyle: DWORD;
  X, Y, nWidth, nHeight: Integer; hWndParent: HWND; hInstance: HINST;
  lParam: LPARAM): HWND; stdcall;
{$EXTERNALSYM CreateMDIWindow}

function TileWindows(hwndParent: HWND; wHow: UINT; lpRect: LPRECT; cKids: UINT;
  hwnd: HWND; lpKids: LPHWND): WORD; stdcall;
{$EXTERNALSYM TileWindows}

function CascadeWindows(hwndParent: HWND; wHow: UINT; lpRect: LPRECT;
  cKids: UINT; lpKids: LPHWND): WORD; stdcall;
{$EXTERNALSYM CascadeWindows}

//***** Help support ********************************************************/

type
  HELPPOLY = DWORD;
  {$EXTERNALSYM HELPPOLY}

  LPMULTIKEYHELPA = ^MULTIKEYHELPA;
  {$EXTERNALSYM LPMULTIKEYHELPA}
  tagMULTIKEYHELPA = record
    mkSize: DWORD;
    mkKeylist: CHAR;
    szKeyphrase: array [0..0] of CHAR;
  end;
  {$EXTERNALSYM tagMULTIKEYHELPA}
  MULTIKEYHELPA = tagMULTIKEYHELPA;
  {$EXTERNALSYM MULTIKEYHELPA}
  TMultiKeyHelpA = MULTIKEYHELPA;
  PMultiKeyHelpA = LPMULTIKEYHELPA;

  LPMULTIKEYHELPW = ^MULTIKEYHELPW;
  {$EXTERNALSYM LPMULTIKEYHELPW}
  tagMULTIKEYHELPW = record
    mkSize: DWORD;
    mkKeylist: WCHAR;
    szKeyphrase: array [0..0] of WCHAR;
  end;
  {$EXTERNALSYM tagMULTIKEYHELPW}
  MULTIKEYHELPW = tagMULTIKEYHELPW;
  {$EXTERNALSYM MULTIKEYHELPW}
  TMultiKeyHelpW = MULTIKEYHELPW;
  PMultiKeyHelpW = LPMULTIKEYHELPW;

  {$IFDEF UNICODE}
  MULTIKEYHELP = MULTIKEYHELPW;
  {$EXTERNALSYM MULTIKEYHELP}
  LPMULTIKEYHELP = LPMULTIKEYHELPW;
  {$EXTERNALSYM LPMULTIKEYHELP}
  TMultiKeyHelp = TMultiKeyHelpW;
  PMultiKeyHelp = PMultiKeyHelpW;
  {$ELSE}
  MULTIKEYHELP = MULTIKEYHELPA;
  {$EXTERNALSYM MULTIKEYHELP}
  LPMULTIKEYHELP = LPMULTIKEYHELPA;
  {$EXTERNALSYM LPMULTIKEYHELP}
  TMultiKeyHelp = TMultiKeyHelpA;
  PMultiKeyHelp = PMultiKeyHelpA;
  {$ENDIF UNICODE}

  LPHELPWININFOA = ^HELPWININFOA;
  {$EXTERNALSYM LPHELPWININFOA}
  tagHELPWININFOA = record
    wStructSize: Integer;
    x: Integer;
    y: Integer;
    dx: Integer;
    dy: Integer;
    wMax: Integer;
    rgchMember: array [0..1] of CHAR;
  end;
  {$EXTERNALSYM tagHELPWININFOA}
  HELPWININFOA = tagHELPWININFOA;
  {$EXTERNALSYM HELPWININFOA}
  THelpWinInfoA = HELPWININFOA;
  PHelpWinInfoA = LPHELPWININFOA;

  LPHELPWININFOW = ^HELPWININFOW;
  {$EXTERNALSYM LPHELPWININFOW}
  tagHELPWININFOW = record
    wStructSize: Integer;
    x: Integer;
    y: Integer;
    dx: Integer;
    dy: Integer;
    wMax: Integer;
    rgchMember: array [0..1] of WCHAR;
  end;
  {$EXTERNALSYM tagHELPWININFOW}
  HELPWININFOW = tagHELPWININFOW;
  {$EXTERNALSYM HELPWININFOW}
  THelpWinInfoW = HELPWININFOW;
  PHelpWinInfoW = LPHELPWININFOW;

  {$IFDEF UNICODE}
  HELPWININFO = HELPWININFOW;
  {$EXTERNALSYM HELPWININFO}
  LPHELPWININFO = LPHELPWININFOW;
  {$EXTERNALSYM LPHELPWININFO}
  THelpWinInfo = THelpWinInfoW;
  PHelpWinInfo = PHelpWinInfoW;
  {$ELSE}
  HELPWININFO = HELPWININFOA;
  {$EXTERNALSYM HELPWININFO}
  LPHELPWININFO = LPHELPWININFOA;
  {$EXTERNALSYM LPHELPWININFO}
  THelpWinInfo = THelpWinInfoA;
  PHelpWinInfo = PHelpWinInfoA;
  {$ENDIF UNICODE}

//
// Commands to pass to WinHelp()
//

const
  HELP_CONTEXT      = $0001; // Display topic in ulTopic
  {$EXTERNALSYM HELP_CONTEXT}
  HELP_QUIT         = $0002; // Terminate help
  {$EXTERNALSYM HELP_QUIT}
  HELP_INDEX        = $0003; // Display index
  {$EXTERNALSYM HELP_INDEX}
  HELP_CONTENTS     = $0003;
  {$EXTERNALSYM HELP_CONTENTS}
  HELP_HELPONHELP   = $0004; // Display help on using help
  {$EXTERNALSYM HELP_HELPONHELP}
  HELP_SETINDEX     = $0005; // Set current Index for multi index help
  {$EXTERNALSYM HELP_SETINDEX}
  HELP_SETCONTENTS  = $0005;
  {$EXTERNALSYM HELP_SETCONTENTS}
  HELP_CONTEXTPOPUP = $0008;
  {$EXTERNALSYM HELP_CONTEXTPOPUP}
  HELP_FORCEFILE    = $0009;
  {$EXTERNALSYM HELP_FORCEFILE}
  HELP_KEY          = $0101; // Display topic for keyword in offabData
  {$EXTERNALSYM HELP_KEY}
  HELP_COMMAND      = $0102;
  {$EXTERNALSYM HELP_COMMAND}
  HELP_PARTIALKEY   = $0105;
  {$EXTERNALSYM HELP_PARTIALKEY}
  HELP_MULTIKEY     = $0201;
  {$EXTERNALSYM HELP_MULTIKEY}
  HELP_SETWINPOS    = $0203;
  {$EXTERNALSYM HELP_SETWINPOS}

  HELP_CONTEXTMENU  = $000a;
  {$EXTERNALSYM HELP_CONTEXTMENU}
  HELP_FINDER       = $000b;
  {$EXTERNALSYM HELP_FINDER}
  HELP_WM_HELP      = $000c;
  {$EXTERNALSYM HELP_WM_HELP}
  HELP_SETPOPUP_POS = $000d;
  {$EXTERNALSYM HELP_SETPOPUP_POS}

  HELP_TCARD              = $8000;
  {$EXTERNALSYM HELP_TCARD}
  HELP_TCARD_DATA         = $0010;
  {$EXTERNALSYM HELP_TCARD_DATA}
  HELP_TCARD_OTHER_CALLER = $0011;
  {$EXTERNALSYM HELP_TCARD_OTHER_CALLER}

// These are in winhelp.h in Win95.

  IDH_NO_HELP             = 28440;
  {$EXTERNALSYM IDH_NO_HELP}
  IDH_MISSING_CONTEXT     = 28441; // Control doesn't have matching help context
  {$EXTERNALSYM IDH_MISSING_CONTEXT}
  IDH_GENERIC_HELP_BUTTON = 28442; // Property sheet help button
  {$EXTERNALSYM IDH_GENERIC_HELP_BUTTON}
  IDH_OK                  = 28443;
  {$EXTERNALSYM IDH_OK}
  IDH_CANCEL              = 28444;
  {$EXTERNALSYM IDH_CANCEL}
  IDH_HELP                = 28445;
  {$EXTERNALSYM IDH_HELP}

function WinHelpA(hWndMain: HWND; lpszHelp: LPCSTR; uCommand: UINT; dwData: ULONG_PTR): BOOL; stdcall;
{$EXTERNALSYM WinHelpA}
function WinHelpW(hWndMain: HWND; lpszHelp: LPCWSTR; uCommand: UINT; dwData: ULONG_PTR): BOOL; stdcall;
{$EXTERNALSYM WinHelpW}
function WinHelp(hWndMain: HWND; lpszHelp: LPCTSTR; uCommand: UINT; dwData: ULONG_PTR): BOOL; stdcall;
{$EXTERNALSYM WinHelp}

const
  GR_GDIOBJECTS  = 0; // Count of GDI objects
  {$EXTERNALSYM GR_GDIOBJECTS}
  GR_USEROBJECTS = 1; // Count of USER objects
  {$EXTERNALSYM GR_USEROBJECTS}

function GetGuiResources(hProcess: HANDLE; uiFlags: DWORD): DWORD; stdcall;
{$EXTERNALSYM GetGuiResources}

//
// Parameter for SystemParametersInfo()
//

const
  SPI_GETBEEP               = 1;
  {$EXTERNALSYM SPI_GETBEEP}
  SPI_SETBEEP               = 2;
  {$EXTERNALSYM SPI_SETBEEP}
  SPI_GETMOUSE              = 3;
  {$EXTERNALSYM SPI_GETMOUSE}
  SPI_SETMOUSE              = 4;
  {$EXTERNALSYM SPI_SETMOUSE}
  SPI_GETBORDER             = 5;
  {$EXTERNALSYM SPI_GETBORDER}
  SPI_SETBORDER             = 6;
  {$EXTERNALSYM SPI_SETBORDER}
  SPI_GETKEYBOARDSPEED      = 10;
  {$EXTERNALSYM SPI_GETKEYBOARDSPEED}
  SPI_SETKEYBOARDSPEED      = 11;
  {$EXTERNALSYM SPI_SETKEYBOARDSPEED}
  SPI_LANGDRIVER            = 12;
  {$EXTERNALSYM SPI_LANGDRIVER}
  SPI_ICONHORIZONTALSPACING = 13;
  {$EXTERNALSYM SPI_ICONHORIZONTALSPACING}
  SPI_GETSCREENSAVETIMEOUT  = 14;
  {$EXTERNALSYM SPI_GETSCREENSAVETIMEOUT}
  SPI_SETSCREENSAVETIMEOUT  = 15;
  {$EXTERNALSYM SPI_SETSCREENSAVETIMEOUT}
  SPI_GETSCREENSAVEACTIVE   = 16;
  {$EXTERNALSYM SPI_GETSCREENSAVEACTIVE}
  SPI_SETSCREENSAVEACTIVE   = 17;
  {$EXTERNALSYM SPI_SETSCREENSAVEACTIVE}
  SPI_GETGRIDGRANULARITY    = 18;
  {$EXTERNALSYM SPI_GETGRIDGRANULARITY}
  SPI_SETGRIDGRANULARITY    = 19;
  {$EXTERNALSYM SPI_SETGRIDGRANULARITY}
  SPI_SETDESKWALLPAPER      = 20;
  {$EXTERNALSYM SPI_SETDESKWALLPAPER}
  SPI_SETDESKPATTERN        = 21;
  {$EXTERNALSYM SPI_SETDESKPATTERN}
  SPI_GETKEYBOARDDELAY      = 22;
  {$EXTERNALSYM SPI_GETKEYBOARDDELAY}
  SPI_SETKEYBOARDDELAY      = 23;
  {$EXTERNALSYM SPI_SETKEYBOARDDELAY}
  SPI_ICONVERTICALSPACING   = 24;
  {$EXTERNALSYM SPI_ICONVERTICALSPACING}
  SPI_GETICONTITLEWRAP      = 25;
  {$EXTERNALSYM SPI_GETICONTITLEWRAP}
  SPI_SETICONTITLEWRAP      = 26;
  {$EXTERNALSYM SPI_SETICONTITLEWRAP}
  SPI_GETMENUDROPALIGNMENT  = 27;
  {$EXTERNALSYM SPI_GETMENUDROPALIGNMENT}
  SPI_SETMENUDROPALIGNMENT  = 28;
  {$EXTERNALSYM SPI_SETMENUDROPALIGNMENT}
  SPI_SETDOUBLECLKWIDTH     = 29;
  {$EXTERNALSYM SPI_SETDOUBLECLKWIDTH}
  SPI_SETDOUBLECLKHEIGHT    = 30;
  {$EXTERNALSYM SPI_SETDOUBLECLKHEIGHT}
  SPI_GETICONTITLELOGFONT   = 31;
  {$EXTERNALSYM SPI_GETICONTITLELOGFONT}
  SPI_SETDOUBLECLICKTIME    = 32;
  {$EXTERNALSYM SPI_SETDOUBLECLICKTIME}
  SPI_SETMOUSEBUTTONSWAP    = 33;
  {$EXTERNALSYM SPI_SETMOUSEBUTTONSWAP}
  SPI_SETICONTITLELOGFONT   = 34;
  {$EXTERNALSYM SPI_SETICONTITLELOGFONT}
  SPI_GETFASTTASKSWITCH     = 35;
  {$EXTERNALSYM SPI_GETFASTTASKSWITCH}
  SPI_SETFASTTASKSWITCH     = 36;
  {$EXTERNALSYM SPI_SETFASTTASKSWITCH}
  SPI_SETDRAGFULLWINDOWS    = 37;
  {$EXTERNALSYM SPI_SETDRAGFULLWINDOWS}
  SPI_GETDRAGFULLWINDOWS    = 38;
  {$EXTERNALSYM SPI_GETDRAGFULLWINDOWS}
  SPI_GETNONCLIENTMETRICS   = 41;
  {$EXTERNALSYM SPI_GETNONCLIENTMETRICS}
  SPI_SETNONCLIENTMETRICS   = 42;
  {$EXTERNALSYM SPI_SETNONCLIENTMETRICS}
  SPI_GETMINIMIZEDMETRICS   = 43;
  {$EXTERNALSYM SPI_GETMINIMIZEDMETRICS}
  SPI_SETMINIMIZEDMETRICS   = 44;
  {$EXTERNALSYM SPI_SETMINIMIZEDMETRICS}
  SPI_GETICONMETRICS        = 45;
  {$EXTERNALSYM SPI_GETICONMETRICS}
  SPI_SETICONMETRICS        = 46;
  {$EXTERNALSYM SPI_SETICONMETRICS}
  SPI_SETWORKAREA           = 47;
  {$EXTERNALSYM SPI_SETWORKAREA}
  SPI_GETWORKAREA           = 48;
  {$EXTERNALSYM SPI_GETWORKAREA}
  SPI_SETPENWINDOWS         = 49;
  {$EXTERNALSYM SPI_SETPENWINDOWS}

  SPI_GETHIGHCONTRAST       = 66;
  {$EXTERNALSYM SPI_GETHIGHCONTRAST}
  SPI_SETHIGHCONTRAST       = 67;
  {$EXTERNALSYM SPI_SETHIGHCONTRAST}
  SPI_GETKEYBOARDPREF       = 68;
  {$EXTERNALSYM SPI_GETKEYBOARDPREF}
  SPI_SETKEYBOARDPREF       = 69;
  {$EXTERNALSYM SPI_SETKEYBOARDPREF}
  SPI_GETSCREENREADER       = 70;
  {$EXTERNALSYM SPI_GETSCREENREADER}
  SPI_SETSCREENREADER       = 71;
  {$EXTERNALSYM SPI_SETSCREENREADER}
  SPI_GETANIMATION          = 72;
  {$EXTERNALSYM SPI_GETANIMATION}
  SPI_SETANIMATION          = 73;
  {$EXTERNALSYM SPI_SETANIMATION}
  SPI_GETFONTSMOOTHING      = 74;
  {$EXTERNALSYM SPI_GETFONTSMOOTHING}
  SPI_SETFONTSMOOTHING      = 75;
  {$EXTERNALSYM SPI_SETFONTSMOOTHING}
  SPI_SETDRAGWIDTH          = 76;
  {$EXTERNALSYM SPI_SETDRAGWIDTH}
  SPI_SETDRAGHEIGHT         = 77;
  {$EXTERNALSYM SPI_SETDRAGHEIGHT}
  SPI_SETHANDHELD           = 78;
  {$EXTERNALSYM SPI_SETHANDHELD}
  SPI_GETLOWPOWERTIMEOUT    = 79;
  {$EXTERNALSYM SPI_GETLOWPOWERTIMEOUT}
  SPI_GETPOWEROFFTIMEOUT    = 80;
  {$EXTERNALSYM SPI_GETPOWEROFFTIMEOUT}
  SPI_SETLOWPOWERTIMEOUT    = 81;
  {$EXTERNALSYM SPI_SETLOWPOWERTIMEOUT}
  SPI_SETPOWEROFFTIMEOUT    = 82;
  {$EXTERNALSYM SPI_SETPOWEROFFTIMEOUT}
  SPI_GETLOWPOWERACTIVE     = 83;
  {$EXTERNALSYM SPI_GETLOWPOWERACTIVE}
  SPI_GETPOWEROFFACTIVE     = 84;
  {$EXTERNALSYM SPI_GETPOWEROFFACTIVE}
  SPI_SETLOWPOWERACTIVE     = 85;
  {$EXTERNALSYM SPI_SETLOWPOWERACTIVE}
  SPI_SETPOWEROFFACTIVE     = 86;
  {$EXTERNALSYM SPI_SETPOWEROFFACTIVE}
  SPI_SETCURSORS            = 87;
  {$EXTERNALSYM SPI_SETCURSORS}
  SPI_SETICONS              = 88;
  {$EXTERNALSYM SPI_SETICONS}
  SPI_GETDEFAULTINPUTLANG   = 89;
  {$EXTERNALSYM SPI_GETDEFAULTINPUTLANG}
  SPI_SETDEFAULTINPUTLANG   = 90;
  {$EXTERNALSYM SPI_SETDEFAULTINPUTLANG}
  SPI_SETLANGTOGGLE         = 91;
  {$EXTERNALSYM SPI_SETLANGTOGGLE}
  SPI_GETWINDOWSEXTENSION   = 92;
  {$EXTERNALSYM SPI_GETWINDOWSEXTENSION}
  SPI_SETMOUSETRAILS        = 93;
  {$EXTERNALSYM SPI_SETMOUSETRAILS}
  SPI_GETMOUSETRAILS        = 94;
  {$EXTERNALSYM SPI_GETMOUSETRAILS}
  SPI_SETSCREENSAVERRUNNING = 97;
  {$EXTERNALSYM SPI_SETSCREENSAVERRUNNING}
  SPI_SCREENSAVERRUNNING    = SPI_SETSCREENSAVERRUNNING;
  {$EXTERNALSYM SPI_SCREENSAVERRUNNING}
  SPI_GETFILTERKEYS         = 50;
  {$EXTERNALSYM SPI_GETFILTERKEYS}
  SPI_SETFILTERKEYS         = 51;
  {$EXTERNALSYM SPI_SETFILTERKEYS}
  SPI_GETTOGGLEKEYS         = 52;
  {$EXTERNALSYM SPI_GETTOGGLEKEYS}
  SPI_SETTOGGLEKEYS         = 53;
  {$EXTERNALSYM SPI_SETTOGGLEKEYS}
  SPI_GETMOUSEKEYS          = 54;
  {$EXTERNALSYM SPI_GETMOUSEKEYS}
  SPI_SETMOUSEKEYS          = 55;
  {$EXTERNALSYM SPI_SETMOUSEKEYS}
  SPI_GETSHOWSOUNDS         = 56;
  {$EXTERNALSYM SPI_GETSHOWSOUNDS}
  SPI_SETSHOWSOUNDS         = 57;
  {$EXTERNALSYM SPI_SETSHOWSOUNDS}
  SPI_GETSTICKYKEYS         = 58;
  {$EXTERNALSYM SPI_GETSTICKYKEYS}
  SPI_SETSTICKYKEYS         = 59;
  {$EXTERNALSYM SPI_SETSTICKYKEYS}
  SPI_GETACCESSTIMEOUT      = 60;
  {$EXTERNALSYM SPI_GETACCESSTIMEOUT}
  SPI_SETACCESSTIMEOUT      = 61;
  {$EXTERNALSYM SPI_SETACCESSTIMEOUT}
  SPI_GETSERIALKEYS         = 62;
  {$EXTERNALSYM SPI_GETSERIALKEYS}
  SPI_SETSERIALKEYS         = 63;
  {$EXTERNALSYM SPI_SETSERIALKEYS}
  SPI_GETSOUNDSENTRY        = 64;
  {$EXTERNALSYM SPI_GETSOUNDSENTRY}
  SPI_SETSOUNDSENTRY        = 65;
  {$EXTERNALSYM SPI_SETSOUNDSENTRY}
  SPI_GETSNAPTODEFBUTTON    = 95;
  {$EXTERNALSYM SPI_GETSNAPTODEFBUTTON}
  SPI_SETSNAPTODEFBUTTON    = 96;
  {$EXTERNALSYM SPI_SETSNAPTODEFBUTTON}
  SPI_GETMOUSEHOVERWIDTH    = 98;
  {$EXTERNALSYM SPI_GETMOUSEHOVERWIDTH}
  SPI_SETMOUSEHOVERWIDTH    = 99;
  {$EXTERNALSYM SPI_SETMOUSEHOVERWIDTH}
  SPI_GETMOUSEHOVERHEIGHT   = 100;
  {$EXTERNALSYM SPI_GETMOUSEHOVERHEIGHT}
  SPI_SETMOUSEHOVERHEIGHT   = 101;
  {$EXTERNALSYM SPI_SETMOUSEHOVERHEIGHT}
  SPI_GETMOUSEHOVERTIME     = 102;
  {$EXTERNALSYM SPI_GETMOUSEHOVERTIME}
  SPI_SETMOUSEHOVERTIME     = 103;
  {$EXTERNALSYM SPI_SETMOUSEHOVERTIME}
  SPI_GETWHEELSCROLLLINES   = 104;
  {$EXTERNALSYM SPI_GETWHEELSCROLLLINES}
  SPI_SETWHEELSCROLLLINES   = 105;
  {$EXTERNALSYM SPI_SETWHEELSCROLLLINES}
  SPI_GETMENUSHOWDELAY      = 106;
  {$EXTERNALSYM SPI_GETMENUSHOWDELAY}
  SPI_SETMENUSHOWDELAY      = 107;
  {$EXTERNALSYM SPI_SETMENUSHOWDELAY}

  SPI_GETSHOWIMEUI = 110;
  {$EXTERNALSYM SPI_GETSHOWIMEUI}
  SPI_SETSHOWIMEUI = 111;
  {$EXTERNALSYM SPI_SETSHOWIMEUI}

  SPI_GETMOUSESPEED         = 112;
  {$EXTERNALSYM SPI_GETMOUSESPEED}
  SPI_SETMOUSESPEED         = 113;
  {$EXTERNALSYM SPI_SETMOUSESPEED}
  SPI_GETSCREENSAVERRUNNING = 114;
  {$EXTERNALSYM SPI_GETSCREENSAVERRUNNING}
  SPI_GETDESKWALLPAPER      = 115;
  {$EXTERNALSYM SPI_GETDESKWALLPAPER}

  SPI_GETACTIVEWINDOWTRACKING   = $1000;
  {$EXTERNALSYM SPI_GETACTIVEWINDOWTRACKING}
  SPI_SETACTIVEWINDOWTRACKING   = $1001;
  {$EXTERNALSYM SPI_SETACTIVEWINDOWTRACKING}
  SPI_GETMENUANIMATION          = $1002;
  {$EXTERNALSYM SPI_GETMENUANIMATION}
  SPI_SETMENUANIMATION          = $1003;
  {$EXTERNALSYM SPI_SETMENUANIMATION}
  SPI_GETCOMBOBOXANIMATION      = $1004;
  {$EXTERNALSYM SPI_GETCOMBOBOXANIMATION}
  SPI_SETCOMBOBOXANIMATION      = $1005;
  {$EXTERNALSYM SPI_SETCOMBOBOXANIMATION}
  SPI_GETLISTBOXSMOOTHSCROLLING = $1006;
  {$EXTERNALSYM SPI_GETLISTBOXSMOOTHSCROLLING}
  SPI_SETLISTBOXSMOOTHSCROLLING = $1007;
  {$EXTERNALSYM SPI_SETLISTBOXSMOOTHSCROLLING}
  SPI_GETGRADIENTCAPTIONS       = $1008;
  {$EXTERNALSYM SPI_GETGRADIENTCAPTIONS}
  SPI_SETGRADIENTCAPTIONS       = $1009;
  {$EXTERNALSYM SPI_SETGRADIENTCAPTIONS}
  SPI_GETKEYBOARDCUES           = $100A;
  {$EXTERNALSYM SPI_GETKEYBOARDCUES}
  SPI_SETKEYBOARDCUES           = $100B;
  {$EXTERNALSYM SPI_SETKEYBOARDCUES}
  SPI_GETMENUUNDERLINES         = SPI_GETKEYBOARDCUES;
  {$EXTERNALSYM SPI_GETMENUUNDERLINES}
  SPI_SETMENUUNDERLINES         = SPI_SETKEYBOARDCUES;
  {$EXTERNALSYM SPI_SETMENUUNDERLINES}
  SPI_GETACTIVEWNDTRKZORDER     = $100C;
  {$EXTERNALSYM SPI_GETACTIVEWNDTRKZORDER}
  SPI_SETACTIVEWNDTRKZORDER     = $100D;
  {$EXTERNALSYM SPI_SETACTIVEWNDTRKZORDER}
  SPI_GETHOTTRACKING            = $100E;
  {$EXTERNALSYM SPI_GETHOTTRACKING}
  SPI_SETHOTTRACKING            = $100F;
  {$EXTERNALSYM SPI_SETHOTTRACKING}
  SPI_GETMENUFADE               = $1012;
  {$EXTERNALSYM SPI_GETMENUFADE}
  SPI_SETMENUFADE               = $1013;
  {$EXTERNALSYM SPI_SETMENUFADE}
  SPI_GETSELECTIONFADE          = $1014;
  {$EXTERNALSYM SPI_GETSELECTIONFADE}
  SPI_SETSELECTIONFADE          = $1015;
  {$EXTERNALSYM SPI_SETSELECTIONFADE}
  SPI_GETTOOLTIPANIMATION       = $1016;
  {$EXTERNALSYM SPI_GETTOOLTIPANIMATION}
  SPI_SETTOOLTIPANIMATION       = $1017;
  {$EXTERNALSYM SPI_SETTOOLTIPANIMATION}
  SPI_GETTOOLTIPFADE            = $1018;
  {$EXTERNALSYM SPI_GETTOOLTIPFADE}
  SPI_SETTOOLTIPFADE            = $1019;
  {$EXTERNALSYM SPI_SETTOOLTIPFADE}
  SPI_GETCURSORSHADOW           = $101A;
  {$EXTERNALSYM SPI_GETCURSORSHADOW}
  SPI_SETCURSORSHADOW           = $101B;
  {$EXTERNALSYM SPI_SETCURSORSHADOW}

  SPI_GETMOUSESONAR             = $101C;
  {$EXTERNALSYM SPI_GETMOUSESONAR}
  SPI_SETMOUSESONAR             = $101D;
  {$EXTERNALSYM SPI_SETMOUSESONAR}
  SPI_GETMOUSECLICKLOCK         = $101E;
  {$EXTERNALSYM SPI_GETMOUSECLICKLOCK}
  SPI_SETMOUSECLICKLOCK         = $101F;
  {$EXTERNALSYM SPI_SETMOUSECLICKLOCK}
  SPI_GETMOUSEVANISH            = $1020;
  {$EXTERNALSYM SPI_GETMOUSEVANISH}
  SPI_SETMOUSEVANISH            = $1021;
  {$EXTERNALSYM SPI_SETMOUSEVANISH}
  SPI_GETFLATMENU               = $1022;
  {$EXTERNALSYM SPI_GETFLATMENU}
  SPI_SETFLATMENU               = $1023;
  {$EXTERNALSYM SPI_SETFLATMENU}
  SPI_GETDROPSHADOW             = $1024;
  {$EXTERNALSYM SPI_GETDROPSHADOW}
  SPI_SETDROPSHADOW             = $1025;
  {$EXTERNALSYM SPI_SETDROPSHADOW}
  SPI_GETBLOCKSENDINPUTRESETS   = $1026;
  {$EXTERNALSYM SPI_GETBLOCKSENDINPUTRESETS}
  SPI_SETBLOCKSENDINPUTRESETS   = $1027;
  {$EXTERNALSYM SPI_SETBLOCKSENDINPUTRESETS}

  SPI_GETUIEFFECTS = $103E;
  {$EXTERNALSYM SPI_GETUIEFFECTS}
  SPI_SETUIEFFECTS = $103F;
  {$EXTERNALSYM SPI_SETUIEFFECTS}

  SPI_GETFOREGROUNDLOCKTIMEOUT = $2000;
  {$EXTERNALSYM SPI_GETFOREGROUNDLOCKTIMEOUT}
  SPI_SETFOREGROUNDLOCKTIMEOUT = $2001;
  {$EXTERNALSYM SPI_SETFOREGROUNDLOCKTIMEOUT}
  SPI_GETACTIVEWNDTRKTIMEOUT   = $2002;
  {$EXTERNALSYM SPI_GETACTIVEWNDTRKTIMEOUT}
  SPI_SETACTIVEWNDTRKTIMEOUT   = $2003;
  {$EXTERNALSYM SPI_SETACTIVEWNDTRKTIMEOUT}
  SPI_GETFOREGROUNDFLASHCOUNT  = $2004;
  {$EXTERNALSYM SPI_GETFOREGROUNDFLASHCOUNT}
  SPI_SETFOREGROUNDFLASHCOUNT  = $2005;
  {$EXTERNALSYM SPI_SETFOREGROUNDFLASHCOUNT}
  SPI_GETCARETWIDTH            = $2006;
  {$EXTERNALSYM SPI_GETCARETWIDTH}
  SPI_SETCARETWIDTH            = $2007;
  {$EXTERNALSYM SPI_SETCARETWIDTH}

  SPI_GETMOUSECLICKLOCKTIME    = $2008;
  {$EXTERNALSYM SPI_GETMOUSECLICKLOCKTIME}
  SPI_SETMOUSECLICKLOCKTIME    = $2009;
  {$EXTERNALSYM SPI_SETMOUSECLICKLOCKTIME}
  SPI_GETFONTSMOOTHINGTYPE     = $200A;
  {$EXTERNALSYM SPI_GETFONTSMOOTHINGTYPE}
  SPI_SETFONTSMOOTHINGTYPE     = $200B;
  {$EXTERNALSYM SPI_SETFONTSMOOTHINGTYPE}

// constants for SPI_GETFONTSMOOTHINGTYPE and SPI_SETFONTSMOOTHINGTYPE

  FE_FONTSMOOTHINGSTANDARD     = $0001;
  {$EXTERNALSYM FE_FONTSMOOTHINGSTANDARD}
  FE_FONTSMOOTHINGCLEARTYPE    = $0002;
  {$EXTERNALSYM FE_FONTSMOOTHINGCLEARTYPE}
  FE_FONTSMOOTHINGDOCKING      = $8000;
  {$EXTERNALSYM FE_FONTSMOOTHINGDOCKING}

  SPI_GETFONTSMOOTHINGCONTRAST = $200C;
  {$EXTERNALSYM SPI_GETFONTSMOOTHINGCONTRAST}
  SPI_SETFONTSMOOTHINGCONTRAST = $200D;
  {$EXTERNALSYM SPI_SETFONTSMOOTHINGCONTRAST}

  SPI_GETFOCUSBORDERWIDTH      = $200E;
  {$EXTERNALSYM SPI_GETFOCUSBORDERWIDTH}
  SPI_SETFOCUSBORDERWIDTH      = $200F;
  {$EXTERNALSYM SPI_SETFOCUSBORDERWIDTH}
  SPI_GETFOCUSBORDERHEIGHT     = $2010;
  {$EXTERNALSYM SPI_GETFOCUSBORDERHEIGHT}
  SPI_SETFOCUSBORDERHEIGHT     = $2011;
  {$EXTERNALSYM SPI_SETFOCUSBORDERHEIGHT}

  SPI_GETFONTSMOOTHINGORIENTATION = $2012;
  {$EXTERNALSYM SPI_GETFONTSMOOTHINGORIENTATION}
  SPI_SETFONTSMOOTHINGORIENTATION = $2013;
  {$EXTERNALSYM SPI_SETFONTSMOOTHINGORIENTATION}

// constants for SPI_GETFONTSMOOTHINGORIENTATION and SPI_SETFONTSMOOTHINGORIENTATION:

  FE_FONTSMOOTHINGORIENTATIONBGR = $0000;
  {$EXTERNALSYM FE_FONTSMOOTHINGORIENTATIONBGR}
  FE_FONTSMOOTHINGORIENTATIONRGB = $0001;
  {$EXTERNALSYM FE_FONTSMOOTHINGORIENTATIONRGB}

//
// Flags
//

  SPIF_UPDATEINIFILE    = $0001;
  {$EXTERNALSYM SPIF_UPDATEINIFILE}
  SPIF_SENDWININICHANGE = $0002;
  {$EXTERNALSYM SPIF_SENDWININICHANGE}
  SPIF_SENDCHANGE       = SPIF_SENDWININICHANGE;
  {$EXTERNALSYM SPIF_SENDCHANGE}

  METRICS_USEDEFAULT = DWORD(-1);
  {$EXTERNALSYM METRICS_USEDEFAULT}

type
  LPNONCLIENTMETRICSA = ^NONCLIENTMETRICSA;
  {$EXTERNALSYM LPNONCLIENTMETRICSA}
  tagNONCLIENTMETRICSA = record
    cbSize: UINT;
    iBorderWidth: Integer;
    iScrollWidth: Integer;
    iScrollHeight: Integer;
    iCaptionWidth: Integer;
    iCaptionHeight: Integer;
    lfCaptionFont: LOGFONTA;
    iSmCaptionWidth: Integer;
    iSmCaptionHeight: Integer;
    lfSmCaptionFont: LOGFONTA;
    iMenuWidth: Integer;
    iMenuHeight: Integer;
    lfMenuFont: LOGFONTA;
    lfStatusFont: LOGFONTA;
    lfMessageFont: LOGFONTA;
  end;
  {$EXTERNALSYM tagNONCLIENTMETRICSA}
  NONCLIENTMETRICSA = tagNONCLIENTMETRICSA;
  {$EXTERNALSYM NONCLIENTMETRICSA}
  TNonClientMetricsA = NONCLIENTMETRICSA;
  PNonClientMetricsA = LPNONCLIENTMETRICSA;

  LPNONCLIENTMETRICSW = ^NONCLIENTMETRICSW;
  {$EXTERNALSYM LPNONCLIENTMETRICSW}
  tagNONCLIENTMETRICSW = record
    cbSize: UINT;
    iBorderWidth: Integer;
    iScrollWidth: Integer;
    iScrollHeight: Integer;
    iCaptionWidth: Integer;
    iCaptionHeight: Integer;
    lfCaptionFont: LOGFONTW;
    iSmCaptionWidth: Integer;
    iSmCaptionHeight: Integer;
    lfSmCaptionFont: LOGFONTW;
    iMenuWidth: Integer;
    iMenuHeight: Integer;
    lfMenuFont: LOGFONTW;
    lfStatusFont: LOGFONTW;
    lfMessageFont: LOGFONTW;
  end;
  {$EXTERNALSYM tagNONCLIENTMETRICSW}
  NONCLIENTMETRICSW = tagNONCLIENTMETRICSW;
  {$EXTERNALSYM NONCLIENTMETRICSW}
  TNonClientMetricsW = NONCLIENTMETRICSW;
  PNonClientMetricsW = LPNONCLIENTMETRICSW;

  {$IFDEF UNICODE}
  NONCLIENTMETRICS = NONCLIENTMETRICSW;
  {$EXTERNALSYM NONCLIENTMETRICS}
  LPNONCLIENTMETRICS = LPNONCLIENTMETRICSW;
  {$EXTERNALSYM LPNONCLIENTMETRICS}
  TNonClientMetrics = TNonClientMetricsW;
  PNonClientMetrics = PNonClientMetricsW;
  {$ELSE}
  NONCLIENTMETRICS = NONCLIENTMETRICSA;
  {$EXTERNALSYM NONCLIENTMETRICS}
  LPNONCLIENTMETRICS = LPNONCLIENTMETRICSA;
  {$EXTERNALSYM LPNONCLIENTMETRICS}
  TNonClientMetrics = TNonClientMetricsA;
  PNonClientMetrics = PNonClientMetricsA;
  {$ENDIF UNICODE}

const
  ARW_BOTTOMLEFT  = $0000;
  {$EXTERNALSYM ARW_BOTTOMLEFT}
  ARW_BOTTOMRIGHT = $0001;
  {$EXTERNALSYM ARW_BOTTOMRIGHT}
  ARW_TOPLEFT     = $0002;
  {$EXTERNALSYM ARW_TOPLEFT}
  ARW_TOPRIGHT    = $0003;
  {$EXTERNALSYM ARW_TOPRIGHT}
  ARW_STARTMASK   = $0003;
  {$EXTERNALSYM ARW_STARTMASK}
  ARW_STARTRIGHT  = $0001;
  {$EXTERNALSYM ARW_STARTRIGHT}
  ARW_STARTTOP    = $0002;
  {$EXTERNALSYM ARW_STARTTOP}

  ARW_LEFT  = $0000;
  {$EXTERNALSYM ARW_LEFT}
  ARW_RIGHT = $0000;
  {$EXTERNALSYM ARW_RIGHT}
  ARW_UP    = $0004;
  {$EXTERNALSYM ARW_UP}
  ARW_DOWN  = $0004;
  {$EXTERNALSYM ARW_DOWN}
  ARW_HIDE  = $0008;
  {$EXTERNALSYM ARW_HIDE}

type
  LPMINIMIZEDMETRICS = ^MINIMIZEDMETRICS;
  {$EXTERNALSYM LPMINIMIZEDMETRICS}
  tagMINIMIZEDMETRICS = record
    cbSize: UINT;
    iWidth: Integer;
    iHorzGap: Integer;
    iVertGap: Integer;
    iArrange: Integer;
  end;
  {$EXTERNALSYM tagMINIMIZEDMETRICS}
  MINIMIZEDMETRICS = tagMINIMIZEDMETRICS;
  {$EXTERNALSYM MINIMIZEDMETRICS}
  TMinimizedMetrics = MINIMIZEDMETRICS;
  PMinimizedMetrics = LPMINIMIZEDMETRICS;

  LPICONMETRICSA = ^ICONMETRICSA;
  {$EXTERNALSYM LPICONMETRICSA}
  tagICONMETRICSA = record
    cbSize: UINT;
    iHorzSpacing: Integer;
    iVertSpacing: Integer;
    iTitleWrap: Integer;
    lfFont: LOGFONTA;
  end;
  {$EXTERNALSYM tagICONMETRICSA}
  ICONMETRICSA = tagICONMETRICSA;
  {$EXTERNALSYM ICONMETRICSA}
  TIconMetricsA = ICONMETRICSA;
  PIconMetricsA = LPICONMETRICSA;

  LPICONMETRICSW = ^ICONMETRICSW;
  {$EXTERNALSYM LPICONMETRICSW}
  tagICONMETRICSW = record
    cbSize: UINT;
    iHorzSpacing: Integer;
    iVertSpacing: Integer;
    iTitleWrap: Integer;
    lfFont: LOGFONTW;
  end;
  {$EXTERNALSYM tagICONMETRICSW}
  ICONMETRICSW = tagICONMETRICSW;
  {$EXTERNALSYM ICONMETRICSW}
  TIconMetricsW = ICONMETRICSW;
  PIconMetricsW = LPICONMETRICSW;

  {$IFDEF UNICODE}
  ICONMETRICS = ICONMETRICSW;
  {$EXTERNALSYM ICONMETRICS}
  LPICONMETRICS = LPICONMETRICSW;
  {$EXTERNALSYM LPICONMETRICS}
  TIconMetrics = TIconMetricsW;
  PIconMetrics = PIconMetricsW;
  {$ELSE}
  ICONMETRICS = ICONMETRICSA;
  {$EXTERNALSYM ICONMETRICS}
  LPICONMETRICS = LPICONMETRICSA;
  {$EXTERNALSYM LPICONMETRICS}
  TIconMetrics = TIconMetricsA;
  PIconMetrics = PIconMetricsA;
  {$ENDIF UNICODE}

  LPANIMATIONINFO = ^ANIMATIONINFO;
  {$EXTERNALSYM LPANIMATIONINFO}
  tagANIMATIONINFO = record
    cbSize: UINT;
    iMinAnimate: Integer;
  end;
  {$EXTERNALSYM tagANIMATIONINFO}
  ANIMATIONINFO = tagANIMATIONINFO;
  {$EXTERNALSYM ANIMATIONINFO}
  TAnimationInfo = ANIMATIONINFO;
  PAnimationInfo = LPANIMATIONINFO;

  LPSERIALKEYSA = ^SERIALKEYSA;
  {$EXTERNALSYM LPSERIALKEYSA}
  tagSERIALKEYSA = record
    cbSize: UINT;
    dwFlags: DWORD;
    lpszActivePort: LPSTR;
    lpszPort: LPSTR;
    iBaudRate: UINT;
    iPortState: UINT;
    iActive: UINT;
  end;
  {$EXTERNALSYM tagSERIALKEYSA}
  SERIALKEYSA = tagSERIALKEYSA;
  {$EXTERNALSYM SERIALKEYSA}
  TSerialKeysA = SERIALKEYSA;
  PSerialKeysA = LPSERIALKEYSA;

  LPSERIALKEYSW = ^SERIALKEYSW;
  {$EXTERNALSYM LPSERIALKEYSW}
  tagSERIALKEYSW = record
    cbSize: UINT;
    dwFlags: DWORD;
    lpszActivePort: LPWSTR;
    lpszPort: LPWSTR;
    iBaudRate: UINT;
    iPortState: UINT;
    iActive: UINT;
  end;
  {$EXTERNALSYM tagSERIALKEYSW}
  SERIALKEYSW = tagSERIALKEYSW;
  {$EXTERNALSYM SERIALKEYSW}
  TSerialKeysW = SERIALKEYSW;
  PSerialKeysW = LPSERIALKEYSW;

  {$IFDEF UNICODE}
  SERIALKEYS = SERIALKEYSW;
  {$EXTERNALSYM SERIALKEYS}
  LPSERIALKEYS = LPSERIALKEYSW;
  {$EXTERNALSYM LPSERIALKEYS}
  TSerialKeys = TSerialKeysW;
  PSerialKeys = PSerialKeysW;
  {$ELSE}
  SERIALKEYS = SERIALKEYSA;
  {$EXTERNALSYM SERIALKEYS}
  LPSERIALKEYS = LPSERIALKEYSA;
  {$EXTERNALSYM LPSERIALKEYS}
  TSerialKeys = TSerialKeysA;
  PSerialKeys = PSerialKeysA;
  {$ENDIF UNICODE}

// flags for SERIALKEYS dwFlags field//

const
  SERKF_SERIALKEYSON = $00000001;
  {$EXTERNALSYM SERKF_SERIALKEYSON}
  SERKF_AVAILABLE    = $00000002;
  {$EXTERNALSYM SERKF_AVAILABLE}
  SERKF_INDICATOR    = $00000004;
  {$EXTERNALSYM SERKF_INDICATOR}

type
  LPHIGHCONTRASTA = ^HIGHCONTRASTA;
  {$EXTERNALSYM LPHIGHCONTRASTA}
  tagHIGHCONTRASTA = record
    cbSize: UINT;
    dwFlags: DWORD;
    lpszDefaultScheme: LPSTR;
  end;
  {$EXTERNALSYM tagHIGHCONTRASTA}
  HIGHCONTRASTA = tagHIGHCONTRASTA;
  {$EXTERNALSYM HIGHCONTRASTA}
  THighContrastA = HIGHCONTRASTA;
  PHighContrastA = LPHIGHCONTRASTA;

  LPHIGHCONTRASTW = ^HIGHCONTRASTW;
  {$EXTERNALSYM LPHIGHCONTRASTW}
  tagHIGHCONTRASTW = record
    cbSize: UINT;
    dwFlags: DWORD;
    lpszDefaultScheme: LPWSTR;
  end;
  {$EXTERNALSYM tagHIGHCONTRASTW}
  HIGHCONTRASTW = tagHIGHCONTRASTW;
  {$EXTERNALSYM HIGHCONTRASTW}
  THighContrastW = HIGHCONTRASTW;
  PHighContrastW = LPHIGHCONTRASTW;

  {$IFDEF UNICODE}
  HIGHCONTRAST = HIGHCONTRASTW;
  {$EXTERNALSYM HIGHCONTRAST}
  LPHIGHCONTRAST = LPHIGHCONTRASTW;
  {$EXTERNALSYM LPHIGHCONTRAST}
  THighContrast = THighContrastW;
  PHighContrast = PHighContrastW;
  {$ELSE}
  HIGHCONTRAST = HIGHCONTRASTA;
  {$EXTERNALSYM HIGHCONTRAST}
  LPHIGHCONTRAST = LPHIGHCONTRASTA;
  {$EXTERNALSYM LPHIGHCONTRAST}
  THighContrast = THighContrastA;
  PHighContrast = PHighContrastA;
  {$ENDIF UNICODE}

// flags for HIGHCONTRAST dwFlags field//

const
  HCF_HIGHCONTRASTON  = $00000001;
  {$EXTERNALSYM HCF_HIGHCONTRASTON}
  HCF_AVAILABLE       = $00000002;
  {$EXTERNALSYM HCF_AVAILABLE}
  HCF_HOTKEYACTIVE    = $00000004;
  {$EXTERNALSYM HCF_HOTKEYACTIVE}
  HCF_CONFIRMHOTKEY   = $00000008;
  {$EXTERNALSYM HCF_CONFIRMHOTKEY}
  HCF_HOTKEYSOUND     = $00000010;
  {$EXTERNALSYM HCF_HOTKEYSOUND}
  HCF_INDICATOR       = $00000020;
  {$EXTERNALSYM HCF_INDICATOR}
  HCF_HOTKEYAVAILABLE = $00000040;
  {$EXTERNALSYM HCF_HOTKEYAVAILABLE}

// Flags for ChangeDisplaySettings//

  CDS_UPDATEREGISTRY  = $00000001;
  {$EXTERNALSYM CDS_UPDATEREGISTRY}
  CDS_TEST            = $00000002;
  {$EXTERNALSYM CDS_TEST}
  CDS_FULLSCREEN      = $00000004;
  {$EXTERNALSYM CDS_FULLSCREEN}
  CDS_GLOBAL          = $00000008;
  {$EXTERNALSYM CDS_GLOBAL}
  CDS_SET_PRIMARY     = $00000010;
  {$EXTERNALSYM CDS_SET_PRIMARY}
  CDS_VIDEOPARAMETERS = $00000020;
  {$EXTERNALSYM CDS_VIDEOPARAMETERS}
  CDS_RESET           = $40000000;
  {$EXTERNALSYM CDS_RESET}
  CDS_NORESET         = $10000000;
  {$EXTERNALSYM CDS_NORESET}

// #include <tvout.h>

// Return values for ChangeDisplaySettings

  DISP_CHANGE_SUCCESSFUL = 0;
  {$EXTERNALSYM DISP_CHANGE_SUCCESSFUL}
  DISP_CHANGE_RESTART    = 1;
  {$EXTERNALSYM DISP_CHANGE_RESTART}
  DISP_CHANGE_FAILED     = DWORD(-1);
  {$EXTERNALSYM DISP_CHANGE_FAILED}
  DISP_CHANGE_BADMODE    = DWORD(-2);
  {$EXTERNALSYM DISP_CHANGE_BADMODE}
  DISP_CHANGE_NOTUPDATED = DWORD(-3);
  {$EXTERNALSYM DISP_CHANGE_NOTUPDATED}
  DISP_CHANGE_BADFLAGS   = DWORD(-4);
  {$EXTERNALSYM DISP_CHANGE_BADFLAGS}
  DISP_CHANGE_BADPARAM   = DWORD(-5);
  {$EXTERNALSYM DISP_CHANGE_BADPARAM}
  DISP_CHANGE_BADDUALVIEW = DWORD(-6);
  {$EXTERNALSYM DISP_CHANGE_BADDUALVIEW}

function ChangeDisplaySettingsA(lpDevMode: LPDEVMODEA; dwFlags: DWORD): LONG; stdcall;
{$EXTERNALSYM ChangeDisplaySettingsA}
function ChangeDisplaySettingsW(lpDevMode: LPDEVMODEW; dwFlags: DWORD): LONG; stdcall;
{$EXTERNALSYM ChangeDisplaySettingsW}
function ChangeDisplaySettings(lpDevMode: LPDEVMODE; dwFlags: DWORD): LONG; stdcall;
{$EXTERNALSYM ChangeDisplaySettings}

function ChangeDisplaySettingsExA(lpszDeviceName: LPCSTR; lpDevMode: LPDEVMODEA;
  hwnd: HWND; dwflags: DWORD; lParam: LPVOID): LONG; stdcall;
{$EXTERNALSYM ChangeDisplaySettingsExA}
function ChangeDisplaySettingsExW(lpszDeviceName: LPCWSTR; lpDevMode: LPDEVMODEW;
  hwnd: HWND; dwflags: DWORD; lParam: LPVOID): LONG; stdcall;
{$EXTERNALSYM ChangeDisplaySettingsExW}
function ChangeDisplaySettingsEx(lpszDeviceName: LPCTSTR; lpDevMode: LPDEVMODE;
  hwnd: HWND; dwflags: DWORD; lParam: LPVOID): LONG; stdcall;
{$EXTERNALSYM ChangeDisplaySettingsEx}

const
  ENUM_CURRENT_SETTINGS  = DWORD(-1);
  {$EXTERNALSYM ENUM_CURRENT_SETTINGS}
  ENUM_REGISTRY_SETTINGS = DWORD(-2);
  {$EXTERNALSYM ENUM_REGISTRY_SETTINGS}

function EnumDisplaySettingsA(lpszDeviceName: LPCSTR; iModeNum: DWORD;
  var lpDevMode: DEVMODEA): BOOL; stdcall;
{$EXTERNALSYM EnumDisplaySettingsA}
function EnumDisplaySettingsW(lpszDeviceName: LPCWSTR; iModeNum: DWORD;
  var lpDevMode: DEVMODEW): BOOL; stdcall;
{$EXTERNALSYM EnumDisplaySettingsW}
function EnumDisplaySettings(lpszDeviceName: LPCTSTR; iModeNum: DWORD;
  var lpDevMode: DEVMODE): BOOL; stdcall;
{$EXTERNALSYM EnumDisplaySettings}

function EnumDisplaySettingsExA(lpszDeviceName: LPCSTR; iModeNum: DWORD;
  var lpDevMode: DEVMODEA; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumDisplaySettingsExA}
function EnumDisplaySettingsExW(lpszDeviceName: LPCWSTR; iModeNum: DWORD;
  var lpDevMode: DEVMODEW; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumDisplaySettingsExW}
function EnumDisplaySettingsEx(lpszDeviceName: LPCTSTR; iModeNum: DWORD;
  var lpDevMode: DEVMODE; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumDisplaySettingsEx}

// Flags for EnumDisplaySettingsEx//

const
  EDS_RAWMODE = $00000002;
  {$EXTERNALSYM EDS_RAWMODE}

function EnumDisplayDevicesA(lpDevice: LPCSTR; iDevNum: DWORD;
  var lpDisplayDevice: DISPLAY_DEVICEA; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumDisplayDevicesA}
function EnumDisplayDevicesW(lpDevice: LPCWSTR; iDevNum: DWORD;
  var lpDisplayDevice: DISPLAY_DEVICEW; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumDisplayDevicesW}
function EnumDisplayDevices(lpDevice: LPCTSTR; iDevNum: DWORD;
  var lpDisplayDevice: DISPLAY_DEVICE; dwFlags: DWORD): BOOL; stdcall;
{$EXTERNALSYM EnumDisplayDevices}

function SystemParametersInfoA(uiAction: UINT; uiParam: UINT;
  pvParam: PVOID; fWinIni: UINT): BOOL; stdcall;
{$EXTERNALSYM SystemParametersInfoA}
function SystemParametersInfoW(uiAction: UINT; uiParam: UINT;
  pvParam: PVOID; fWinIni: UINT): BOOL; stdcall;
{$EXTERNALSYM SystemParametersInfoW}
function SystemParametersInfo(uiAction: UINT; uiParam: UINT;
  pvParam: PVOID; fWinIni: UINT): BOOL; stdcall;
{$EXTERNALSYM SystemParametersInfo}

//
// Accessibility support
//

type
  LPFILTERKEYS = ^FILTERKEYS;
  {$EXTERNALSYM LPFILTERKEYS}
  tagFILTERKEYS = record
    cbSize: UINT;
    dwFlags: DWORD;
    iWaitMSec: DWORD;   // Acceptance Delay
    iDelayMSec: DWORD;  // Delay Until Repeat
    iRepeatMSec: DWORD; // Repeat Rate
    iBounceMSec: DWORD; // Debounce Time
  end;
  {$EXTERNALSYM tagFILTERKEYS}
  FILTERKEYS = tagFILTERKEYS;
  {$EXTERNALSYM FILTERKEYS}
  TFilterKeys = FILTERKEYS;
  PFilterKeys = LPFILTERKEYS;

//
// FILTERKEYS dwFlags field
//

const
  FKF_FILTERKEYSON  = $00000001;
  {$EXTERNALSYM FKF_FILTERKEYSON}
  FKF_AVAILABLE     = $00000002;
  {$EXTERNALSYM FKF_AVAILABLE}
  FKF_HOTKEYACTIVE  = $00000004;
  {$EXTERNALSYM FKF_HOTKEYACTIVE}
  FKF_CONFIRMHOTKEY = $00000008;
  {$EXTERNALSYM FKF_CONFIRMHOTKEY}
  FKF_HOTKEYSOUND   = $00000010;
  {$EXTERNALSYM FKF_HOTKEYSOUND}
  FKF_INDICATOR     = $00000020;
  {$EXTERNALSYM FKF_INDICATOR}
  FKF_CLICKON       = $00000040;
  {$EXTERNALSYM FKF_CLICKON}

type
  LPSTICKYKEYS = ^STICKYKEYS;
  {$EXTERNALSYM LPSTICKYKEYS}
  tagSTICKYKEYS = record
    cbSize: UINT;
    dwFlags: DWORD;
  end;
  {$EXTERNALSYM tagSTICKYKEYS}
  STICKYKEYS = tagSTICKYKEYS;
  {$EXTERNALSYM STICKYKEYS}
  TStickyKeys = STICKYKEYS;
  PStickyKeys = LPSTICKYKEYS;

//
// STICKYKEYS dwFlags field
//

const
  SKF_STICKYKEYSON    = $00000001;
  {$EXTERNALSYM SKF_STICKYKEYSON}
  SKF_AVAILABLE       = $00000002;
  {$EXTERNALSYM SKF_AVAILABLE}
  SKF_HOTKEYACTIVE    = $00000004;
  {$EXTERNALSYM SKF_HOTKEYACTIVE}
  SKF_CONFIRMHOTKEY   = $00000008;
  {$EXTERNALSYM SKF_CONFIRMHOTKEY}
  SKF_HOTKEYSOUND     = $00000010;
  {$EXTERNALSYM SKF_HOTKEYSOUND}
  SKF_INDICATOR       = $00000020;
  {$EXTERNALSYM SKF_INDICATOR}
  SKF_AUDIBLEFEEDBACK = $00000040;
  {$EXTERNALSYM SKF_AUDIBLEFEEDBACK}
  SKF_TRISTATE        = $00000080;
  {$EXTERNALSYM SKF_TRISTATE}
  SKF_TWOKEYSOFF      = $00000100;
  {$EXTERNALSYM SKF_TWOKEYSOFF}
  SKF_LALTLATCHED     = $10000000;
  {$EXTERNALSYM SKF_LALTLATCHED}
  SKF_LCTLLATCHED     = $04000000;
  {$EXTERNALSYM SKF_LCTLLATCHED}
  SKF_LSHIFTLATCHED   = $01000000;
  {$EXTERNALSYM SKF_LSHIFTLATCHED}
  SKF_RALTLATCHED     = $20000000;
  {$EXTERNALSYM SKF_RALTLATCHED}
  SKF_RCTLLATCHED     = $08000000;
  {$EXTERNALSYM SKF_RCTLLATCHED}
  SKF_RSHIFTLATCHED   = $02000000;
  {$EXTERNALSYM SKF_RSHIFTLATCHED}
  SKF_LWINLATCHED     = $40000000;
  {$EXTERNALSYM SKF_LWINLATCHED}
  SKF_RWINLATCHED     = $80000000;
  {$EXTERNALSYM SKF_RWINLATCHED}
  SKF_LALTLOCKED      = $00100000;
  {$EXTERNALSYM SKF_LALTLOCKED}
  SKF_LCTLLOCKED      = $00040000;
  {$EXTERNALSYM SKF_LCTLLOCKED}
  SKF_LSHIFTLOCKED    = $00010000;
  {$EXTERNALSYM SKF_LSHIFTLOCKED}
  SKF_RALTLOCKED      = $00200000;
  {$EXTERNALSYM SKF_RALTLOCKED}
  SKF_RCTLLOCKED      = $00080000;
  {$EXTERNALSYM SKF_RCTLLOCKED}
  SKF_RSHIFTLOCKED    = $00020000;
  {$EXTERNALSYM SKF_RSHIFTLOCKED}
  SKF_LWINLOCKED      = $00400000;
  {$EXTERNALSYM SKF_LWINLOCKED}
  SKF_RWINLOCKED      = $00800000;
  {$EXTERNALSYM SKF_RWINLOCKED}

type
  LPMOUSEKEYS = ^MOUSEKEYS;
  {$EXTERNALSYM LPMOUSEKEYS}
  tagMOUSEKEYS = record
    cbSize: UINT;
    dwFlags: DWORD;
    iMaxSpeed: DWORD;
    iTimeToMaxSpeed: DWORD;
    iCtrlSpeed: DWORD;
    dwReserved1: DWORD;
    dwReserved2: DWORD;
  end;
  {$EXTERNALSYM tagMOUSEKEYS}
  MOUSEKEYS = tagMOUSEKEYS;
  {$EXTERNALSYM MOUSEKEYS}
  TMouseKeys = MOUSEKEYS;
  PMouseKeys = LPMOUSEKEYS;

//
// MOUSEKEYS dwFlags field
//

const
  MKF_MOUSEKEYSON     = $00000001;
  {$EXTERNALSYM MKF_MOUSEKEYSON}
  MKF_AVAILABLE       = $00000002;
  {$EXTERNALSYM MKF_AVAILABLE}
  MKF_HOTKEYACTIVE    = $00000004;
  {$EXTERNALSYM MKF_HOTKEYACTIVE}
  MKF_CONFIRMHOTKEY   = $00000008;
  {$EXTERNALSYM MKF_CONFIRMHOTKEY}
  MKF_HOTKEYSOUND     = $00000010;
  {$EXTERNALSYM MKF_HOTKEYSOUND}
  MKF_INDICATOR       = $00000020;
  {$EXTERNALSYM MKF_INDICATOR}
  MKF_MODIFIERS       = $00000040;
  {$EXTERNALSYM MKF_MODIFIERS}
  MKF_REPLACENUMBERS  = $00000080;
  {$EXTERNALSYM MKF_REPLACENUMBERS}
  MKF_LEFTBUTTONSEL   = $10000000;
  {$EXTERNALSYM MKF_LEFTBUTTONSEL}
  MKF_RIGHTBUTTONSEL  = $20000000;
  {$EXTERNALSYM MKF_RIGHTBUTTONSEL}
  MKF_LEFTBUTTONDOWN  = $01000000;
  {$EXTERNALSYM MKF_LEFTBUTTONDOWN}
  MKF_RIGHTBUTTONDOWN = $02000000;
  {$EXTERNALSYM MKF_RIGHTBUTTONDOWN}
  MKF_MOUSEMODE       = $80000000;
  {$EXTERNALSYM MKF_MOUSEMODE}

type
  LPACCESSTIMEOUT = ^ACCESSTIMEOUT;
  {$EXTERNALSYM LPACCESSTIMEOUT}
  tagACCESSTIMEOUT = record
    cbSize: UINT;
    dwFlags: DWORD;
    iTimeOutMSec: DWORD;
  end;
  {$EXTERNALSYM tagACCESSTIMEOUT}
  ACCESSTIMEOUT = tagACCESSTIMEOUT;
  {$EXTERNALSYM ACCESSTIMEOUT}
  TAccessTimeout = ACCESSTIMEOUT;
  PAccessTimeout = LPACCESSTIMEOUT;

//
// ACCESSTIMEOUT dwFlags field
//

const
  ATF_TIMEOUTON     = $00000001;
  {$EXTERNALSYM ATF_TIMEOUTON}
  ATF_ONOFFFEEDBACK = $00000002;
  {$EXTERNALSYM ATF_ONOFFFEEDBACK}

// values for SOUNDSENTRY iFSGrafEffect field//

  SSGF_NONE    = 0;
  {$EXTERNALSYM SSGF_NONE}
  SSGF_DISPLAY = 3;
  {$EXTERNALSYM SSGF_DISPLAY}

// values for SOUNDSENTRY iFSTextEffect field//

  SSTF_NONE    = 0;
  {$EXTERNALSYM SSTF_NONE}
  SSTF_CHARS   = 1;
  {$EXTERNALSYM SSTF_CHARS}
  SSTF_BORDER  = 2;
  {$EXTERNALSYM SSTF_BORDER}
  SSTF_DISPLAY = 3;
  {$EXTERNALSYM SSTF_DISPLAY}

// values for SOUNDSENTRY iWindowsEffect field//

  SSWF_NONE    = 0;
  {$EXTERNALSYM SSWF_NONE}
  SSWF_TITLE   = 1;
  {$EXTERNALSYM SSWF_TITLE}
  SSWF_WINDOW  = 2;
  {$EXTERNALSYM SSWF_WINDOW}
  SSWF_DISPLAY = 3;
  {$EXTERNALSYM SSWF_DISPLAY}
  SSWF_CUSTOM  = 4;
  {$EXTERNALSYM SSWF_CUSTOM}

type
  LPSOUNDSENTRYA = ^SOUNDSENTRYA;
  {$EXTERNALSYM LPSOUNDSENTRYA}
  tagSOUNDSENTRYA = record
    cbSize: UINT;
    dwFlags: DWORD;
    iFSTextEffect: DWORD;
    iFSTextEffectMSec: DWORD;
    iFSTextEffectColorBits: DWORD;
    iFSGrafEffect: DWORD;
    iFSGrafEffectMSec: DWORD;
    iFSGrafEffectColor: DWORD;
    iWindowsEffect: DWORD;
    iWindowsEffectMSec: DWORD;
    lpszWindowsEffectDLL: LPSTR;
    iWindowsEffectOrdinal: DWORD;
  end;
  {$EXTERNALSYM tagSOUNDSENTRYA}
  SOUNDSENTRYA = tagSOUNDSENTRYA;
  {$EXTERNALSYM SOUNDSENTRYA}
  TSoundsEntryA = SOUNDSENTRYA;
  PSoundsEntryA = LPSOUNDSENTRYA;

  LPSOUNDSENTRYW = ^SOUNDSENTRYW;
  {$EXTERNALSYM LPSOUNDSENTRYW}
  tagSOUNDSENTRYW = record
    cbSize: UINT;
    dwFlags: DWORD;
    iFSTextEffect: DWORD;
    iFSTextEffectMSec: DWORD;
    iFSTextEffectColorBits: DWORD;
    iFSGrafEffect: DWORD;
    iFSGrafEffectMSec: DWORD;
    iFSGrafEffectColor: DWORD;
    iWindowsEffect: DWORD;
    iWindowsEffectMSec: DWORD;
    lpszWindowsEffectDLL: LPWSTR;
    iWindowsEffectOrdinal: DWORD;
  end;
  {$EXTERNALSYM tagSOUNDSENTRYW}
  SOUNDSENTRYW = tagSOUNDSENTRYW;
  {$EXTERNALSYM SOUNDSENTRYW}
  TSoundsEntryW = SOUNDSENTRYW;
  PSoundsEntryW = LPSOUNDSENTRYW;

  {$IFDEF UNICODE}
  SOUNDSENTRY = SOUNDSENTRYW;
  {$EXTERNALSYM SOUNDSENTRY}
  LPSOUNDSENTRY = LPSOUNDSENTRYW;
  {$EXTERNALSYM LPSOUNDSENTRY}
  TSoundsEntry = TSoundsEntryW;
  PSoundsEntry = PSoundsEntryW;
  {$ELSE}
  SOUNDSENTRY = SOUNDSENTRYA;
  {$EXTERNALSYM SOUNDSENTRY}
  LPSOUNDSENTRY = LPSOUNDSENTRYA;
  {$EXTERNALSYM LPSOUNDSENTRY}
  TSoundsEntry = TSoundsEntryA;
  PSoundsEntry = PSoundsEntryA;
  {$ENDIF UNICODE}

//
// SOUNDSENTRY dwFlags field
//

const
  SSF_SOUNDSENTRYON = $00000001;
  {$EXTERNALSYM SSF_SOUNDSENTRYON}
  SSF_AVAILABLE     = $00000002;
  {$EXTERNALSYM SSF_AVAILABLE}
  SSF_INDICATOR     = $00000004;
  {$EXTERNALSYM SSF_INDICATOR}

type
  LPTOGGLEKEYS = ^TOGGLEKEYS;
  {$EXTERNALSYM LPTOGGLEKEYS}
  tagTOGGLEKEYS = record
    cbSize: UINT;
    dwFlags: DWORD;
  end;
  {$EXTERNALSYM tagTOGGLEKEYS}
  TOGGLEKEYS = tagTOGGLEKEYS;
  {$EXTERNALSYM TOGGLEKEYS}
  TToggleKeys = TOGGLEKEYS;
  PToggleKeys = LPTOGGLEKEYS;

//
// TOGGLEKEYS dwFlags field
//

const
  TKF_TOGGLEKEYSON  = $00000001;
  {$EXTERNALSYM TKF_TOGGLEKEYSON}
  TKF_AVAILABLE     = $00000002;
  {$EXTERNALSYM TKF_AVAILABLE}
  TKF_HOTKEYACTIVE  = $00000004;
  {$EXTERNALSYM TKF_HOTKEYACTIVE}
  TKF_CONFIRMHOTKEY = $00000008;
  {$EXTERNALSYM TKF_CONFIRMHOTKEY}
  TKF_HOTKEYSOUND   = $00000010;
  {$EXTERNALSYM TKF_HOTKEYSOUND}
  TKF_INDICATOR     = $00000020;
  {$EXTERNALSYM TKF_INDICATOR}

//
// Set debug level
//

procedure SetDebugErrorLevel(dwLevel: DWORD); stdcall;
{$EXTERNALSYM SetDebugErrorLevel}

//
// SetLastErrorEx() types.
//

const
  SLE_ERROR      = $00000001;
  {$EXTERNALSYM SLE_ERROR}
  SLE_MINORERROR = $00000002;
  {$EXTERNALSYM SLE_MINORERROR}
  SLE_WARNING    = $00000003;
  {$EXTERNALSYM SLE_WARNING}

procedure SetLastErrorEx(dwErrCode, dwType: DWORD); stdcall;
{$EXTERNALSYM SetLastErrorEx}

function InternalGetWindowText(hWnd: HWND; lpString: LPWSTR; nMaxCount: Integer): Integer; stdcall;
{$EXTERNALSYM InternalGetWindowText}

function EndTask(hWnd: HWND; fShutDown, fForce: BOOL): BOOL; stdcall;
{$EXTERNALSYM EndTask}

//
// Multimonitor API.
//

const
  MONITOR_DEFAULTTONULL    = $00000000;
  {$EXTERNALSYM MONITOR_DEFAULTTONULL}
  MONITOR_DEFAULTTOPRIMARY = $00000001;
  {$EXTERNALSYM MONITOR_DEFAULTTOPRIMARY}
  MONITOR_DEFAULTTONEAREST = $00000002;
  {$EXTERNALSYM MONITOR_DEFAULTTONEAREST}

function MonitorFromPoint(pt: POINT; dwFlags: DWORD): HMONITOR; stdcall;
{$EXTERNALSYM MonitorFromPoint}

function MonitorFromRect(const lprc: RECT; dwFlags: DWORD): HMONITOR; stdcall;
{$EXTERNALSYM MonitorFromRect}

function MonitorFromWindow(hwnd: HWND; dwFlags: DWORD): HMONITOR; stdcall;
{$EXTERNALSYM MonitorFromWindow}

const
  MONITORINFOF_PRIMARY = $00000001;
  {$EXTERNALSYM MONITORINFOF_PRIMARY}

  {$IFNDEF JWA_INCLUDEMODE}
  CCHDEVICENAME = 32;
  {$EXTERNALSYM CCHDEVICENAME}
  {$ENDIF !JWA_INCLUDEMODE}

type
  LPMONITORINFO = ^MONITORINFO;
  {$EXTERNALSYM LPMONITORINFO}
  tagMONITORINFO = record
    cbSize: DWORD;
    rcMonitor: RECT;
    rcWork: RECT;
    dwFlags: DWORD;
  end;
  {$EXTERNALSYM tagMONITORINFO}
  MONITORINFO = tagMONITORINFO;
  {$EXTERNALSYM MONITORINFO}
  TMonitorInfo = MONITORINFO;
  PMonitorInfo = LPMONITORINFO;

  LPMONITORINFOEXA = ^MONITORINFOEXA;
  {$EXTERNALSYM LPMONITORINFOEXA}
  tagMONITORINFOEXA = record
    MonitorInfo: MONITORINFO;
    szDevice: array [0..CCHDEVICENAME - 1] of CHAR;
  end;
  {$EXTERNALSYM tagMONITORINFOEXA}
  MONITORINFOEXA = tagMONITORINFOEXA;
  {$EXTERNALSYM MONITORINFOEXA}
  TMonitorinfoexa = MONITORINFOEXA;
  PMonitorInfoExA = LPMONITORINFOEXA;

  LPMONITORINFOEXW = ^MONITORINFOEXW;
  {$EXTERNALSYM LPMONITORINFOEXW}
  tagMONITORINFOEXW = record
    MonitorInfo: MONITORINFO;
    szDevice: array [0..CCHDEVICENAME - 1] of WCHAR;
  end;
  {$EXTERNALSYM tagMONITORINFOEXW}
  MONITORINFOEXW = tagMONITORINFOEXW;
  {$EXTERNALSYM MONITORINFOEXW}
  TMonitorInfoExW = MONITORINFOEXW;
  PMonitorInfoExW = LPMONITORINFOEXW;

  {$IFDEF UNICODE}
  MONITORINFOEX = MONITORINFOEXW;
  {$EXTERNALSYM MONITORINFOEX}
  LPMONITORINFOEX = LPMONITORINFOEXW;
  {$EXTERNALSYM LPMONITORINFOEX}
  TMonitorInfoEx = TMonitorInfoExW;
  PMonitorInfoEx = PMonitorInfoExW;
  {$ELSE}
  MONITORINFOEX = MONITORINFOEXA;
  {$EXTERNALSYM MONITORINFOEX}
  LPMONITORINFOEX = LPMONITORINFOEXA;
  {$EXTERNALSYM LPMONITORINFOEX}
  TMonitorInfoEx = TMonitorInfoExA;
  PMonitorInfoEx = PMonitorInfoExA;
  {$ENDIF UNICODE}

function GetMonitorInfoA(hMonitor: HMONITOR; lpmi: LPMONITORINFO): BOOL; stdcall;
{$EXTERNALSYM GetMonitorInfoA}
function GetMonitorInfoW(hMonitor: HMONITOR; lpmi: LPMONITORINFO): BOOL; stdcall;
{$EXTERNALSYM GetMonitorInfoW}
function GetMonitorInfo(hMonitor: HMONITOR; lpmi: LPMONITORINFO): BOOL; stdcall;
{$EXTERNALSYM GetMonitorInfo}

type
  MONITORENUMPROC = function(hMonitor: HMONITOR; hdcMonitor: HDC;
    lprcMonitor: LPRECT; dwData: LPARAM): BOOL; stdcall;
  {$EXTERNALSYM MONITORENUMPROC}
  TMonitorEnumProc = MONITORENUMPROC;

function EnumDisplayMonitors(hdc: HDC; lprcClip: LPCRECT;
  lpfnEnum: MONITORENUMPROC; dwData: LPARAM): BOOL; stdcall;
{$EXTERNALSYM EnumDisplayMonitors}

//
// WinEvents - Active Accessibility hooks
//

procedure NotifyWinEvent(event: DWORD; hwnd: HWND; idObject: LONG; idChild: LONG); stdcall;
{$EXTERNALSYM NotifyWinEvent}

type
  WINEVENTPROC = procedure(hWinEventHook: HWINEVENTHOOK; event: DWORD; hwnd: HWND;
    idObject, idChild: LONG; idEventThread, dwmsEventTime: DWORD); stdcall;
  {$EXTERNALSYM WINEVENTPROC}
  TWinEventProc = WINEVENTPROC;

function SetWinEventHook(eventMin: DWORD; eventMax: DWORD;
  hmodWinEventProc: HMODULE; pfnWinEventProc: WINEVENTPROC; idProcess: DWORD;
  idThread: DWORD; dwFlags: DWORD): HWINEVENTHOOK; stdcall;
{$EXTERNALSYM SetWinEventHook}

function IsWinEventHookInstalled(event: DWORD): BOOL; stdcall;
{$EXTERNALSYM IsWinEventHookInstalled}

//
// dwFlags for SetWinEventHook
//

const
  WINEVENT_OUTOFCONTEXT   = $0000; // Events are ASYNC
  {$EXTERNALSYM WINEVENT_OUTOFCONTEXT}
  WINEVENT_SKIPOWNTHREAD  = $0001; // Don't call back for events on installer's thread
  {$EXTERNALSYM WINEVENT_SKIPOWNTHREAD}
  WINEVENT_SKIPOWNPROCESS = $0002; // Don't call back for events on installer's process
  {$EXTERNALSYM WINEVENT_SKIPOWNPROCESS}
  WINEVENT_INCONTEXT      = $0004; // Events are SYNC, this causes your dll to be injected into every process
  {$EXTERNALSYM WINEVENT_INCONTEXT}

function UnhookWinEvent(hWinEventHook: HWINEVENTHOOK): BOOL; stdcall;
{$EXTERNALSYM UnhookWinEvent}

//
// idObject values for WinEventProc and NotifyWinEvent
//

//
// hwnd + idObject can be used with OLEACC.DLL's OleGetObjectFromWindow()
// to get an interface pointer to the container.  indexChild is the item
// within the container in question.  Setup a VARIANT with vt VT_I4 and
// lVal the indexChild and pass that in to all methods.  Then you
// are raring to go.
//

//
// Common object IDs (cookies, only for sending WM_GETOBJECT to get at the
// thing in question).  Positive IDs are reserved for apps (app specific),
// negative IDs are system things and are global, 0 means "just little old
// me".
//

const
  CHILDID_SELF      = 0;
  {$EXTERNALSYM CHILDID_SELF}
  INDEXID_OBJECT    = 0;
  {$EXTERNALSYM INDEXID_OBJECT}
  INDEXID_CONTAINER = 0;
  {$EXTERNALSYM INDEXID_CONTAINER}

//
// Reserved IDs for system objects
//

const
  OBJID_WINDOW            = DWORD($00000000);
  {$EXTERNALSYM OBJID_WINDOW}
  OBJID_SYSMENU           = DWORD($FFFFFFFF);
  {$EXTERNALSYM OBJID_SYSMENU}
  OBJID_TITLEBAR          = DWORD($FFFFFFFE);
  {$EXTERNALSYM OBJID_TITLEBAR}
  OBJID_MENU              = DWORD($FFFFFFFD);
  {$EXTERNALSYM OBJID_MENU}
  OBJID_CLIENT            = DWORD($FFFFFFFC);
  {$EXTERNALSYM OBJID_CLIENT}
  OBJID_VSCROLL           = DWORD($FFFFFFFB);
  {$EXTERNALSYM OBJID_VSCROLL}
  OBJID_HSCROLL           = DWORD($FFFFFFFA);
  {$EXTERNALSYM OBJID_HSCROLL}
  OBJID_SIZEGRIP          = DWORD($FFFFFFF9);
  {$EXTERNALSYM OBJID_SIZEGRIP}
  OBJID_CARET             = DWORD($FFFFFFF8);
  {$EXTERNALSYM OBJID_CARET}
  OBJID_CURSOR            = DWORD($FFFFFFF7);
  {$EXTERNALSYM OBJID_CURSOR}
  OBJID_ALERT             = DWORD($FFFFFFF6);
  {$EXTERNALSYM OBJID_ALERT}
  OBJID_SOUND             = DWORD($FFFFFFF5);
  {$EXTERNALSYM OBJID_SOUND}
  OBJID_QUERYCLASSNAMEIDX = DWORD($FFFFFFF4);
  {$EXTERNALSYM OBJID_QUERYCLASSNAMEIDX}
  OBJID_NATIVEOM          = DWORD($FFFFFFF0);
  {$EXTERNALSYM OBJID_NATIVEOM}

//
// EVENT DEFINITION
//

  EVENT_MIN = $00000001;
  {$EXTERNALSYM EVENT_MIN}
  EVENT_MAX = $7FFFFFFF;
  {$EXTERNALSYM EVENT_MAX}

//
//  EVENT_SYSTEM_SOUND
//  Sent when a sound is played.  Currently nothing is generating this, we
//  this event when a system sound (for menus, etc) is played.  Apps
//  generate this, if accessible, when a private sound is played.  For
//  example, if Mail plays a "New Mail" sound.
//
//  System Sounds:
//  (Generated by PlaySoundEvent in USER itself)
//      hwnd            is NULL
//      idObject        is OBJID_SOUND
//      idChild         is sound child ID if one
//  App Sounds:
//  (PlaySoundEvent won't generate notification; up to app)
//      hwnd + idObject gets interface pointer to Sound object
//      idChild identifies the sound in question
//  are going to be cleaning up the SOUNDSENTRY feature in the control panel
//  and will use this at that time.  Applications implementing WinEvents
//  are perfectly welcome to use it.  Clients of IAccessible* will simply
//  turn around and get back a non-visual object that describes the sound.
//

  EVENT_SYSTEM_SOUND = $0001;
  {$EXTERNALSYM EVENT_SYSTEM_SOUND}

//
// EVENT_SYSTEM_ALERT
// System Alerts:
// (Generated by MessageBox() calls for example)
//      hwnd            is hwndMessageBox
//      idObject        is OBJID_ALERT
// App Alerts:
// (Generated whenever)
//      hwnd+idObject gets interface pointer to Alert
//

  EVENT_SYSTEM_ALERT = $0002;
  {$EXTERNALSYM EVENT_SYSTEM_ALERT}

//
// EVENT_SYSTEM_FOREGROUND
// Sent when the foreground (active) window changes, even if it is changing
// to another window in the same thread as the previous one.
//      hwnd            is hwndNewForeground
//      idObject        is OBJID_WINDOW
//      idChild    is INDEXID_OBJECT
//

  EVENT_SYSTEM_FOREGROUND = $0003;
  {$EXTERNALSYM EVENT_SYSTEM_FOREGROUND}

//
// Menu
//      hwnd            is window (top level window or popup menu window)
//      idObject        is ID of control (OBJID_MENU, OBJID_SYSMENU, OBJID_SELF for popup)
//      idChild         is CHILDID_SELF

// EVENT_SYSTEM_MENUSTART
// EVENT_SYSTEM_MENUEND
// For MENUSTART, hwnd+idObject+idChild refers to the control with the menu bar,
//  or the control bringing up the context menu.

// Sent when entering into and leaving from menu mode (system, app bar, and
// track popups).
//

  EVENT_SYSTEM_MENUSTART = $0004;
  {$EXTERNALSYM EVENT_SYSTEM_MENUSTART}
  EVENT_SYSTEM_MENUEND   = $0005;
  {$EXTERNALSYM EVENT_SYSTEM_MENUEND}

//
// EVENT_SYSTEM_MENUPOPUPSTART
// EVENT_SYSTEM_MENUPOPUPEND
// Sent when a menu popup comes up and just before it is taken down.  Note
// that for a call to TrackPopupMenu(), a client will see EVENT_SYSTEM_MENUSTART
// followed almost immediately by EVENT_SYSTEM_MENUPOPUPSTART for the popup
// being shown.

// For MENUPOPUP, hwnd+idObject+idChild refers to the NEW popup coming up, not the
// parent item which is hierarchical.  You can get the parent menu/popup by
// asking for the accParent object.
//

  EVENT_SYSTEM_MENUPOPUPSTART = $0006;
  {$EXTERNALSYM EVENT_SYSTEM_MENUPOPUPSTART}
  EVENT_SYSTEM_MENUPOPUPEND   = $0007;
  {$EXTERNALSYM EVENT_SYSTEM_MENUPOPUPEND}

//
// EVENT_SYSTEM_CAPTURESTART
// EVENT_SYSTEM_CAPTUREEND
// Sent when a window takes the capture and releases the capture.
//

  EVENT_SYSTEM_CAPTURESTART = $0008;
  {$EXTERNALSYM EVENT_SYSTEM_CAPTURESTART}
  EVENT_SYSTEM_CAPTUREEND   = $0009;
  {$EXTERNALSYM EVENT_SYSTEM_CAPTUREEND}

//
// Move Size
// EVENT_SYSTEM_MOVESIZESTART
// EVENT_SYSTEM_MOVESIZEEND
// Sent when a window enters and leaves move-size dragging mode.
//

  EVENT_SYSTEM_MOVESIZESTART = $000A;
  {$EXTERNALSYM EVENT_SYSTEM_MOVESIZESTART}
  EVENT_SYSTEM_MOVESIZEEND   = $000B;
  {$EXTERNALSYM EVENT_SYSTEM_MOVESIZEEND}

//
// Context Help
// EVENT_SYSTEM_CONTEXTHELPSTART
// EVENT_SYSTEM_CONTEXTHELPEND
// Sent when a window enters and leaves context sensitive help mode.
//

  EVENT_SYSTEM_CONTEXTHELPSTART = $000C;
  {$EXTERNALSYM EVENT_SYSTEM_CONTEXTHELPSTART}
  EVENT_SYSTEM_CONTEXTHELPEND   = $000D;
  {$EXTERNALSYM EVENT_SYSTEM_CONTEXTHELPEND}

//
// Drag & Drop
// EVENT_SYSTEM_DRAGDROPSTART
// EVENT_SYSTEM_DRAGDROPEND
// Send the START notification just before going into drag&drop loop.  Send
// the END notification just after canceling out.
// Note that it is up to apps and OLE to generate this, since the system
// doesn't know.  Like EVENT_SYSTEM_SOUND, it will be a while before this
// is prevalent.
//

  EVENT_SYSTEM_DRAGDROPSTART = $000E;
  {$EXTERNALSYM EVENT_SYSTEM_DRAGDROPSTART}
  EVENT_SYSTEM_DRAGDROPEND   = $000F;
  {$EXTERNALSYM EVENT_SYSTEM_DRAGDROPEND}

//
// Dialog
// Send the START notification right after the dialog is completely
//  initialized and visible.  Send the END right before the dialog
//  is hidden and goes away.
// EVENT_SYSTEM_DIALOGSTART
// EVENT_SYSTEM_DIALOGEND
//

  EVENT_SYSTEM_DIALOGSTART = $0010;
  {$EXTERNALSYM EVENT_SYSTEM_DIALOGSTART}
  EVENT_SYSTEM_DIALOGEND   = $0011;
  {$EXTERNALSYM EVENT_SYSTEM_DIALOGEND}

//
// EVENT_SYSTEM_SCROLLING
// EVENT_SYSTEM_SCROLLINGSTART
// EVENT_SYSTEM_SCROLLINGEND
// Sent when beginning and ending the tracking of a scrollbar in a window,
// and also for scrollbar controls.
//

  EVENT_SYSTEM_SCROLLINGSTART = $0012;
  {$EXTERNALSYM EVENT_SYSTEM_SCROLLINGSTART}
  EVENT_SYSTEM_SCROLLINGEND   = $0013;
  {$EXTERNALSYM EVENT_SYSTEM_SCROLLINGEND}

//
// Alt-Tab Window
// Send the START notification right after the switch window is initialized
// and visible.  Send the END right before it is hidden and goes away.
// EVENT_SYSTEM_SWITCHSTART
// EVENT_SYSTEM_SWITCHEND
//

  EVENT_SYSTEM_SWITCHSTART = $0014;
  {$EXTERNALSYM EVENT_SYSTEM_SWITCHSTART}
  EVENT_SYSTEM_SWITCHEND   = $0015;
  {$EXTERNALSYM EVENT_SYSTEM_SWITCHEND}

//
// EVENT_SYSTEM_MINIMIZESTART
// EVENT_SYSTEM_MINIMIZEEND
// Sent when a window minimizes and just before it restores.
//

  EVENT_SYSTEM_MINIMIZESTART = $0016;
  {$EXTERNALSYM EVENT_SYSTEM_MINIMIZESTART}
  EVENT_SYSTEM_MINIMIZEEND   = $0017;
  {$EXTERNALSYM EVENT_SYSTEM_MINIMIZEEND}

  EVENT_CONSOLE_CARET             = $4001;
  {$EXTERNALSYM EVENT_CONSOLE_CARET}
  EVENT_CONSOLE_UPDATE_REGION     = $4002;
  {$EXTERNALSYM EVENT_CONSOLE_UPDATE_REGION}
  EVENT_CONSOLE_UPDATE_SIMPLE     = $4003;
  {$EXTERNALSYM EVENT_CONSOLE_UPDATE_SIMPLE}
  EVENT_CONSOLE_UPDATE_SCROLL     = $4004;
  {$EXTERNALSYM EVENT_CONSOLE_UPDATE_SCROLL}
  EVENT_CONSOLE_LAYOUT            = $4005;
  {$EXTERNALSYM EVENT_CONSOLE_LAYOUT}
  EVENT_CONSOLE_START_APPLICATION = $4006;
  {$EXTERNALSYM EVENT_CONSOLE_START_APPLICATION}
  EVENT_CONSOLE_END_APPLICATION   = $4007;
  {$EXTERNALSYM EVENT_CONSOLE_END_APPLICATION}

//
// Flags for EVENT_CONSOLE_START/END_APPLICATION.
//

  CONSOLE_APPLICATION_16BIT       = $0001;
  {$EXTERNALSYM CONSOLE_APPLICATION_16BIT}

//
// Flags for EVENT_CONSOLE_CARET
//

  CONSOLE_CARET_SELECTION         = $0001;
  {$EXTERNALSYM CONSOLE_CARET_SELECTION}
  CONSOLE_CARET_VISIBLE           = $0002;
  {$EXTERNALSYM CONSOLE_CARET_VISIBLE}

//
// Object events

// The system AND apps generate these.  The system generates these for
// real windows.  Apps generate these for objects within their window which
// act like a separate control, e.g. an item in a list view.

// When the system generate them, dwParam2 is always WMOBJID_SELF.  When
// apps generate them, apps put the has-meaning-to-the-app-only ID value
// in dwParam2.
// For all events, if you want detailed accessibility information, callers
// should
//      * Call AccessibleObjectFromWindow() with the hwnd, idObject parameters
//          of the event, and IID_IAccessible as the REFIID, to get back an
//          IAccessible* to talk to
//      * Initialize and fill in a VARIANT as VT_I4 with lVal the idChild
//          parameter of the event.
//      * If idChild isn't zero, call get_accChild() in the container to see
//          if the child is an object in its own right.  If so, you will get
//          back an IDispatch* object for the child.  You should release the
//          parent, and call QueryInterface() on the child object to get its
//          IAccessible*.  Then you talk directly to the child.  Otherwise,
//          if get_accChild() returns you nothing, you should continue to
//          use the child VARIANT.  You will ask the container for the properties
//          of the child identified by the VARIANT.  In other words, the
//          child in this case is accessible but not a full-blown object.
//          Like a button on a titlebar which is 'small' and has no children.
//

//
// For all EVENT_OBJECT events,
//      hwnd is the dude to Send the WM_GETOBJECT message to (unless NULL,
//          see above for system things)
//      idObject is the ID of the object that can resolve any queries a
//          client might have.  It's a way to deal with windowless controls,
//          controls that are just drawn on the screen in some larger parent
//          window (like SDM), or standard frame elements of a window.
//      idChild is the piece inside of the object that is affected.  This
//          allows clients to access things that are too small to have full
//          blown objects in their own right.  Like the thumb of a scrollbar.
//          The hwnd/idObject pair gets you to the container, the dude you
//          probably want to talk to most of the time anyway.  The idChild
//          can then be passed into the acc properties to get the name/value
//          of it as needed.

// Example #1:
//      System propagating a listbox selection change
//      EVENT_OBJECT_SELECTION
//          hwnd == listbox hwnd
//          idObject == OBJID_WINDOW
//          idChild == new selected item, or CHILDID_SELF if
//              nothing now selected within container.
//      Word '97 propagating a listbox selection change
//          hwnd == SDM window
//          idObject == SDM ID to get at listbox 'control'
//          idChild == new selected item, or CHILDID_SELF if
//              nothing

// Example #2:
//      System propagating a menu item selection on the menu bar
//      EVENT_OBJECT_SELECTION
//          hwnd == top level window
//          idObject == OBJID_MENU
//          idChild == ID of child menu bar item selected
// *
// Example #3:
//      System propagating a dropdown coming off of said menu bar item
//      EVENT_OBJECT_CREATE
//          hwnd == popup item
//          idObject == OBJID_WINDOW
//          idChild == CHILDID_SELF
//
// Example #4:
//
// For EVENT_OBJECT_REORDER, the object referred to by hwnd/idObject is the
// PARENT container in which the zorder is occurring.  This is because if
// one child is zordering, all of them are changing their relative zorder.
//

  EVENT_OBJECT_CREATE  = $8000; // hwnd + ID + idChild is created item
  {$EXTERNALSYM EVENT_OBJECT_CREATE}
  EVENT_OBJECT_DESTROY = $8001; // hwnd + ID + idChild is destroyed item
  {$EXTERNALSYM EVENT_OBJECT_DESTROY}
  EVENT_OBJECT_SHOW    = $8002; // hwnd + ID + idChild is shown item
  {$EXTERNALSYM EVENT_OBJECT_SHOW}
  EVENT_OBJECT_HIDE    = $8003; // hwnd + ID + idChild is hidden item
  {$EXTERNALSYM EVENT_OBJECT_HIDE}
  EVENT_OBJECT_REORDER = $8004; // hwnd + ID + idChild is parent of zordering children
  {$EXTERNALSYM EVENT_OBJECT_REORDER}

//
// NOTE:
// Minimize the number of notifications!
//
// When you are hiding a parent object, obviously all child objects are no
// longer visible on screen.  They still have the same "visible" status,
// but are not truly visible.  Hence do not send HIDE notifications for the
// children also.  One implies all.  The same goes for SHOW.
//

  EVENT_OBJECT_FOCUS           = $8005; // hwnd + ID + idChild is focused item
  {$EXTERNALSYM EVENT_OBJECT_FOCUS}
  EVENT_OBJECT_SELECTION       = $8006; // hwnd + ID + idChild is selected item (if only one), or idChild is OBJID_WINDOW if complex
  {$EXTERNALSYM EVENT_OBJECT_SELECTION}
  EVENT_OBJECT_SELECTIONADD    = $8007; // hwnd + ID + idChild is item added
  {$EXTERNALSYM EVENT_OBJECT_SELECTIONADD}
  EVENT_OBJECT_SELECTIONREMOVE = $8008; // hwnd + ID + idChild is item removed
  {$EXTERNALSYM EVENT_OBJECT_SELECTIONREMOVE}
  EVENT_OBJECT_SELECTIONWITHIN = $8009; // hwnd + ID + idChild is parent of changed selected items
  {$EXTERNALSYM EVENT_OBJECT_SELECTIONWITHIN}

//
// NOTES:
// There is only one "focused" child item in a parent.  This is the place
// keystrokes are going at a given moment.  Hence only send a notification
// about where the NEW focus is going.  A NEW item getting the focus already
// implies that the OLD item is losing it.
//
// SELECTION however can be multiple.  Hence the different SELECTION
// notifications.  Here's when to use each:
//
// (1) Send a SELECTION notification in the simple single selection
//     case (like the focus) when the item with the selection is
//     merely moving to a different item within a container.  hwnd + ID
//     is the container control, idChildItem is the new child with the
//     selection.
//
// (2) Send a SELECTIONADD notification when a new item has simply been added
//     to the selection within a container.  This is appropriate when the
//     number of newly selected items is very small.  hwnd + ID is the
//     container control, idChildItem is the new child added to the selection.
//
// (3) Send a SELECTIONREMOVE notification when a new item has simply been
//     removed from the selection within a container.  This is appropriate
//     when the number of newly selected items is very small, just like
//     SELECTIONADD.  hwnd + ID is the container control, idChildItem is the
//     new child removed from the selection.
//
// (4) Send a SELECTIONWITHIN notification when the selected items within a
//     control have changed substantially.  Rather than propagate a large
//     number of changes to reflect removal for some items, addition of
//     others, just tell somebody who cares that a lot happened.  It will
//     be faster an easier for somebody watching to just turn around and
//     query the container control what the new bunch of selected items
//     are.
//

  EVENT_OBJECT_STATECHANGE = $800A; // hwnd + ID + idChild is item w/ state change
  {$EXTERNALSYM EVENT_OBJECT_STATECHANGE}

//
// Examples of when to send an EVENT_OBJECT_STATECHANGE include
//      * It is being enabled/disabled (USER does for windows)
//      * It is being pressed/released (USER does for buttons)
//      * It is being checked/unchecked (USER does for radio/check buttons)
//

  EVENT_OBJECT_LOCATIONCHANGE = $800B; // hwnd + ID + idChild is moved/sized item
  {$EXTERNALSYM EVENT_OBJECT_LOCATIONCHANGE}

//
// Note:
// A LOCATIONCHANGE is not sent for every child object when the parent
// changes shape/moves.  Send one notification for the topmost object
// that is changing.  For example, if the user resizes a top level window,
// USER will generate a LOCATIONCHANGE for it, but not for the menu bar,
// title bar, scrollbars, etc.  that are also changing shape/moving.
//
// In other words, it only generates LOCATIONCHANGE notifications for
// real windows that are moving/sizing.  It will not generate a LOCATIONCHANGE
// for every non-floating child window when the parent moves (the children are
// logically moving also on screen, but not relative to the parent).
//
// Now, if the app itself resizes child windows as a result of being
// sized, USER will generate LOCATIONCHANGEs for those dudes also because
// it doesn't know better.
//
// Note also that USER will generate LOCATIONCHANGE notifications for two
// non-window sys objects:
//      (1) System caret
//      (2) Cursor
//

  EVENT_OBJECT_NAMECHANGE        = $800C; // hwnd + ID + idChild is item w/ name change
  {$EXTERNALSYM EVENT_OBJECT_NAMECHANGE}
  EVENT_OBJECT_DESCRIPTIONCHANGE = $800D; // hwnd + ID + idChild is item w/ desc change
  {$EXTERNALSYM EVENT_OBJECT_DESCRIPTIONCHANGE}
  EVENT_OBJECT_VALUECHANGE       = $800E; // hwnd + ID + idChild is item w/ value change
  {$EXTERNALSYM EVENT_OBJECT_VALUECHANGE}
  EVENT_OBJECT_PARENTCHANGE      = $800F; // hwnd + ID + idChild is item w/ new parent
  {$EXTERNALSYM EVENT_OBJECT_PARENTCHANGE}
  EVENT_OBJECT_HELPCHANGE        = $8010; // hwnd + ID + idChild is item w/ help change
  {$EXTERNALSYM EVENT_OBJECT_HELPCHANGE}
  EVENT_OBJECT_DEFACTIONCHANGE   = $8011; // hwnd + ID + idChild is item w/ def action change
  {$EXTERNALSYM EVENT_OBJECT_DEFACTIONCHANGE}
  EVENT_OBJECT_ACCELERATORCHANGE = $8012; // hwnd + ID + idChild is item w/ keybd accel change
  {$EXTERNALSYM EVENT_OBJECT_ACCELERATORCHANGE}

//
// Child IDs
//

//
// System Sounds (idChild of system SOUND notification)
//

  SOUND_SYSTEM_STARTUP     = 1;
  {$EXTERNALSYM SOUND_SYSTEM_STARTUP}
  SOUND_SYSTEM_SHUTDOWN    = 2;
  {$EXTERNALSYM SOUND_SYSTEM_SHUTDOWN}
  SOUND_SYSTEM_BEEP        = 3;
  {$EXTERNALSYM SOUND_SYSTEM_BEEP}
  SOUND_SYSTEM_ERROR       = 4;
  {$EXTERNALSYM SOUND_SYSTEM_ERROR}
  SOUND_SYSTEM_QUESTION    = 5;
  {$EXTERNALSYM SOUND_SYSTEM_QUESTION}
  SOUND_SYSTEM_WARNING     = 6;
  {$EXTERNALSYM SOUND_SYSTEM_WARNING}
  SOUND_SYSTEM_INFORMATION = 7;
  {$EXTERNALSYM SOUND_SYSTEM_INFORMATION}
  SOUND_SYSTEM_MAXIMIZE    = 8;
  {$EXTERNALSYM SOUND_SYSTEM_MAXIMIZE}
  SOUND_SYSTEM_MINIMIZE    = 9;
  {$EXTERNALSYM SOUND_SYSTEM_MINIMIZE}
  SOUND_SYSTEM_RESTOREUP   = 10;
  {$EXTERNALSYM SOUND_SYSTEM_RESTOREUP}
  SOUND_SYSTEM_RESTOREDOWN = 11;
  {$EXTERNALSYM SOUND_SYSTEM_RESTOREDOWN}
  SOUND_SYSTEM_APPSTART    = 12;
  {$EXTERNALSYM SOUND_SYSTEM_APPSTART}
  SOUND_SYSTEM_FAULT       = 13;
  {$EXTERNALSYM SOUND_SYSTEM_FAULT}
  SOUND_SYSTEM_APPEND      = 14;
  {$EXTERNALSYM SOUND_SYSTEM_APPEND}
  SOUND_SYSTEM_MENUCOMMAND = 15;
  {$EXTERNALSYM SOUND_SYSTEM_MENUCOMMAND}
  SOUND_SYSTEM_MENUPOPUP   = 16;
  {$EXTERNALSYM SOUND_SYSTEM_MENUPOPUP}
  CSOUND_SYSTEM            = 16;
  {$EXTERNALSYM CSOUND_SYSTEM}

//
// System Alerts (indexChild of system ALERT notification)
//

  ALERT_SYSTEM_INFORMATIONAL = 1; // MB_INFORMATION
  {$EXTERNALSYM ALERT_SYSTEM_INFORMATIONAL}
  ALERT_SYSTEM_WARNING       = 2; // MB_WARNING
  {$EXTERNALSYM ALERT_SYSTEM_WARNING}
  ALERT_SYSTEM_ERROR         = 3; // MB_ERROR
  {$EXTERNALSYM ALERT_SYSTEM_ERROR}
  ALERT_SYSTEM_QUERY         = 4; // MB_QUESTION
  {$EXTERNALSYM ALERT_SYSTEM_QUERY}
  ALERT_SYSTEM_CRITICAL      = 5; // HardSysErrBox
  {$EXTERNALSYM ALERT_SYSTEM_CRITICAL}
  CALERT_SYSTEM              = 6;
  {$EXTERNALSYM CALERT_SYSTEM}

type
  LPGUITHREADINFO = ^GUITHREADINFO;
  {$EXTERNALSYM LPGUITHREADINFO}
  tagGUITHREADINFO = record
    cbSize: DWORD;
    flags: DWORD;
    hwndActive: HWND;
    hwndFocus: HWND;
    hwndCapture: HWND;
    hwndMenuOwner: HWND;
    hwndMoveSize: HWND;
    hwndCaret: HWND;
    rcCaret: RECT;
  end;
  {$EXTERNALSYM tagGUITHREADINFO}
  GUITHREADINFO = tagGUITHREADINFO;
  {$EXTERNALSYM GUITHREADINFO}
  TGuiThreadInfo = GUITHREADINFO;
  PGuiThreadInfo = LPGUITHREADINFO;

const
  GUI_CARETBLINKING  = $00000001;
  {$EXTERNALSYM GUI_CARETBLINKING}
  GUI_INMOVESIZE     = $00000002;
  {$EXTERNALSYM GUI_INMOVESIZE}
  GUI_INMENUMODE     = $00000004;
  {$EXTERNALSYM GUI_INMENUMODE}
  GUI_SYSTEMMENUMODE = $00000008;
  {$EXTERNALSYM GUI_SYSTEMMENUMODE}
  GUI_POPUPMENUMODE  = $00000010;
  {$EXTERNALSYM GUI_POPUPMENUMODE}
  GUI_16BITTASK      = $00000020;
  {$EXTERNALSYM GUI_16BITTASK}

function GetGUIThreadInfo(idThread: DWORD; var pgui: GUITHREADINFO): BOOL; stdcall;
{$EXTERNALSYM GetGUIThreadInfo}

function GetWindowModuleFileNameA(hwnd: HWND; pszFileName: LPSTR; cchFileNameMax: UINT): UINT; stdcall;
{$EXTERNALSYM GetWindowModuleFileNameA}
function GetWindowModuleFileNameW(hwnd: HWND; pszFileName: LPWSTR; cchFileNameMax: UINT): UINT; stdcall;
{$EXTERNALSYM GetWindowModuleFileNameW}
function GetWindowModuleFileName(hwnd: HWND; pszFileName: LPTSTR; cchFileNameMax: UINT): UINT; stdcall;
{$EXTERNALSYM GetWindowModuleFileName}

const
  STATE_SYSTEM_UNAVAILABLE     = $00000001; // Disabled
  {$EXTERNALSYM STATE_SYSTEM_UNAVAILABLE}
  STATE_SYSTEM_SELECTED        = $00000002;
  {$EXTERNALSYM STATE_SYSTEM_SELECTED}
  STATE_SYSTEM_FOCUSED         = $00000004;
  {$EXTERNALSYM STATE_SYSTEM_FOCUSED}
  STATE_SYSTEM_PRESSED         = $00000008;
  {$EXTERNALSYM STATE_SYSTEM_PRESSED}
  STATE_SYSTEM_CHECKED         = $00000010;
  {$EXTERNALSYM STATE_SYSTEM_CHECKED}
  STATE_SYSTEM_MIXED           = $00000020; // 3-state checkbox or toolbar button
  {$EXTERNALSYM STATE_SYSTEM_MIXED}
  STATE_SYSTEM_INDETERMINATE   = STATE_SYSTEM_MIXED;
  {$EXTERNALSYM STATE_SYSTEM_INDETERMINATE}
  STATE_SYSTEM_READONLY        = $00000040;
  {$EXTERNALSYM STATE_SYSTEM_READONLY}
  STATE_SYSTEM_HOTTRACKED      = $00000080;
  {$EXTERNALSYM STATE_SYSTEM_HOTTRACKED}
  STATE_SYSTEM_DEFAULT         = $00000100;
  {$EXTERNALSYM STATE_SYSTEM_DEFAULT}
  STATE_SYSTEM_EXPANDED        = $00000200;
  {$EXTERNALSYM STATE_SYSTEM_EXPANDED}
  STATE_SYSTEM_COLLAPSED       = $00000400;
  {$EXTERNALSYM STATE_SYSTEM_COLLAPSED}
  STATE_SYSTEM_BUSY            = $00000800;
  {$EXTERNALSYM STATE_SYSTEM_BUSY}
  STATE_SYSTEM_FLOATING        = $00001000; // Children "owned" not "contained" by parent
  {$EXTERNALSYM STATE_SYSTEM_FLOATING}
  STATE_SYSTEM_MARQUEED        = $00002000;
  {$EXTERNALSYM STATE_SYSTEM_MARQUEED}
  STATE_SYSTEM_ANIMATED        = $00004000;
  {$EXTERNALSYM STATE_SYSTEM_ANIMATED}
  STATE_SYSTEM_INVISIBLE       = $00008000;
  {$EXTERNALSYM STATE_SYSTEM_INVISIBLE}
  STATE_SYSTEM_OFFSCREEN       = $00010000;
  {$EXTERNALSYM STATE_SYSTEM_OFFSCREEN}
  STATE_SYSTEM_SIZEABLE        = $00020000;
  {$EXTERNALSYM STATE_SYSTEM_SIZEABLE}
  STATE_SYSTEM_MOVEABLE        = $00040000;
  {$EXTERNALSYM STATE_SYSTEM_MOVEABLE}
  STATE_SYSTEM_SELFVOICING     = $00080000;
  {$EXTERNALSYM STATE_SYSTEM_SELFVOICING}
  STATE_SYSTEM_FOCUSABLE       = $00100000;
  {$EXTERNALSYM STATE_SYSTEM_FOCUSABLE}
  STATE_SYSTEM_SELECTABLE      = $00200000;
  {$EXTERNALSYM STATE_SYSTEM_SELECTABLE}
  STATE_SYSTEM_LINKED          = $00400000;
  {$EXTERNALSYM STATE_SYSTEM_LINKED}
  STATE_SYSTEM_TRAVERSED       = $00800000;
  {$EXTERNALSYM STATE_SYSTEM_TRAVERSED}
  STATE_SYSTEM_MULTISELECTABLE = $01000000; // Supports multiple selection
  {$EXTERNALSYM STATE_SYSTEM_MULTISELECTABLE}
  STATE_SYSTEM_EXTSELECTABLE   = $02000000; // Supports extended selection
  {$EXTERNALSYM STATE_SYSTEM_EXTSELECTABLE}
  STATE_SYSTEM_ALERT_LOW       = $04000000; // This information is of low priority
  {$EXTERNALSYM STATE_SYSTEM_ALERT_LOW}
  STATE_SYSTEM_ALERT_MEDIUM    = $08000000; // This information is of medium priority
  {$EXTERNALSYM STATE_SYSTEM_ALERT_MEDIUM}
  STATE_SYSTEM_ALERT_HIGH      = $10000000; // This information is of high priority
  {$EXTERNALSYM STATE_SYSTEM_ALERT_HIGH}
  STATE_SYSTEM_PROTECTED       = $20000000; // access to this is restricted
  {$EXTERNALSYM STATE_SYSTEM_PROTECTED}
  STATE_SYSTEM_VALID           = $3FFFFFFF;
  {$EXTERNALSYM STATE_SYSTEM_VALID}

  CCHILDREN_TITLEBAR  = 5;
  {$EXTERNALSYM CCHILDREN_TITLEBAR}
  CCHILDREN_SCROLLBAR = 5;
  {$EXTERNALSYM CCHILDREN_SCROLLBAR}

//
// Information about the global cursor.
//

type
  LPCURSORINFO = ^CURSORINFO;
  {$EXTERNALSYM LPCURSORINFO}
  tagCURSORINFO = record
    cbSize: DWORD;
    flags: DWORD;
    hCursor: HCURSOR;
    ptScreenPos: POINT;
  end;
  {$EXTERNALSYM tagCURSORINFO}
  CURSORINFO = tagCURSORINFO;
  {$EXTERNALSYM CURSORINFO}
  TCursorInfo = CURSORINFO;
  PCursorInfo = LPCURSORINFO;

const
  CURSOR_SHOWING = $00000001;
  {$EXTERNALSYM CURSOR_SHOWING}

function GetCursorInfo(var pci: CURSORINFO): BOOL; stdcall;
{$EXTERNALSYM GetCursorInfo}

//
// Window information snapshot
//

type
  LPWINDOWINFO = ^WINDOWINFO;
  {$EXTERNALSYM LPWINDOWINFO}
  tagWINDOWINFO = record
    cbSize: DWORD;
    rcWindow: RECT;
    rcClient: RECT;
    dwStyle: DWORD;
    dwExStyle: DWORD;
    dwWindowStatus: DWORD;
    cxWindowBorders: UINT;
    cyWindowBorders: UINT;
    atomWindowType: ATOM;
    wCreatorVersion: WORD;
  end;
  {$EXTERNALSYM tagWINDOWINFO}
  WINDOWINFO = tagWINDOWINFO;
  {$EXTERNALSYM WINDOWINFO}
  TWindowInfo = WINDOWINFO;
  PWindowInfo = LPWINDOWINFO;

const
  WS_ACTIVECAPTION = $0001;
  {$EXTERNALSYM WS_ACTIVECAPTION}

function GetWindowInfo(hwnd: HWND; var pwi: WINDOWINFO): BOOL; stdcall;
{$EXTERNALSYM GetWindowInfo}

//
// Titlebar information.
//

type
  LPTITLEBARINFO = ^TITLEBARINFO;
  {$EXTERNALSYM LPTITLEBARINFO}
  tagTITLEBARINFO = record
    cbSize: DWORD;
    rcTitleBar: RECT;
    rgstate: array [0..CCHILDREN_TITLEBAR] of DWORD;
  end;
  {$EXTERNALSYM tagTITLEBARINFO}
  TITLEBARINFO = tagTITLEBARINFO;
  {$EXTERNALSYM TITLEBARINFO}
  TTitleBarInfo = TITLEBARINFO;
  PTitleBarInfo = LPTITLEBARINFO;

function GetTitleBarInfo(hwnd: HWND; var pti: TITLEBARINFO): BOOL; stdcall;
{$EXTERNALSYM GetTitleBarInfo}

//
// Menubar information
//

type
  LPMENUBARINFO = ^MENUBARINFO;
  {$EXTERNALSYM LPMENUBARINFO}
  tagMENUBARINFO = record
    cbSize: DWORD;
    rcBar: RECT;          // rect of bar, popup, item
    hMenu: HMENU;         // real menu handle of bar, popup
    hwndMenu: HWND;       // hwnd of item submenu if one
    Flags: DWORD;
    // BOOL  fBarFocused:1;  // bar, popup has the focus
    // BOOL  fFocused:1;     // item has the focus
  end;
  {$EXTERNALSYM tagMENUBARINFO}
  MENUBARINFO = tagMENUBARINFO;
  {$EXTERNALSYM MENUBARINFO}
  TMenuBarInfo = MENUBARINFO;
  PMenuBarInfo = LPMENUBARINFO;

function GetMenuBarInfo(hwnd: HWND; idObject: LONG; idItem: LONG;
  var pmbi: MENUBARINFO): BOOL; stdcall;
{$EXTERNALSYM GetMenuBarInfo}

//
// Scrollbar information
//

type
  LPSCROLLBARINFO = ^SCROLLBARINFO;
  {$EXTERNALSYM LPSCROLLBARINFO}
  tagSCROLLBARINFO = record
    cbSize: DWORD;
    rcScrollBar: RECT;
    dxyLineButton: Integer;
    xyThumbTop: Integer;
    xyThumbBottom: Integer;
    reserved: Integer;
    rgstate: array [0..CCHILDREN_SCROLLBAR] of DWORD;
  end;
  {$EXTERNALSYM tagSCROLLBARINFO}
  SCROLLBARINFO = tagSCROLLBARINFO;
  {$EXTERNALSYM SCROLLBARINFO}
  TScrollBarInfo = SCROLLBARINFO;
  PScrollBarInfo = LPSCROLLBARINFO;

function GetScrollBarInfo(hwnd: HWND; idObject: LONG; var psbi: SCROLLBARINFO): BOOL; stdcall;
{$EXTERNALSYM GetScrollBarInfo}

//
// Combobox information
//

type
  LPCOMBOBOXINFO = ^COMBOBOXINFO;
  {$EXTERNALSYM LPCOMBOBOXINFO}
  tagCOMBOBOXINFO = record
    cbSize: DWORD;
    rcItem: RECT;
    rcButton: RECT;
    stateButton: DWORD;
    hwndCombo: HWND;
    hwndItem: HWND;
    hwndList: HWND;
  end;
  {$EXTERNALSYM tagCOMBOBOXINFO}
  COMBOBOXINFO = tagCOMBOBOXINFO;
  {$EXTERNALSYM COMBOBOXINFO}
  TComboBoxInfo = COMBOBOXINFO;
  PComboBoxInfo = LPCOMBOBOXINFO;

function GetComboBoxInfo(hwndCombo: HWND; var pcbi: COMBOBOXINFO): BOOL; stdcall;
{$EXTERNALSYM GetComboBoxInfo}

//
// The "real" ancestor window
//

const
  GA_PARENT    = 1;
  {$EXTERNALSYM GA_PARENT}
  GA_ROOT      = 2;
  {$EXTERNALSYM GA_ROOT}
  GA_ROOTOWNER = 3;
  {$EXTERNALSYM GA_ROOTOWNER}

function GetAncestor(hwnd: HWND; gaFlags: UINT): HWND; stdcall;
{$EXTERNALSYM GetAncestor}

//
// This gets the REAL child window at the point.  If it is in the dead
// space of a group box, it will try a sibling behind it.  But static
// fields will get returned.  In other words, it is kind of a cross between
// ChildWindowFromPointEx and WindowFromPoint.
//

function RealChildWindowFromPoint(hwndParent: HWND; ptParentClientCoords: POINT): HWND; stdcall;
{$EXTERNALSYM RealChildWindowFromPoint}

//
// This gets the name of the window TYPE, not class.  This allows us to
// recognize ThunderButton32 et al.
//

function RealGetWindowClassA(hwnd: HWND; pszType: LPSTR; cchType: UINT): UINT; stdcall;
{$EXTERNALSYM RealGetWindowClassA}

//
// This gets the name of the window TYPE, not class.  This allows us to
// recognize ThunderButton32 et al.
//

function RealGetWindowClassW(hwnd: HWND; pszType: LPWSTR; cchType: UINT): UINT; stdcall;
{$EXTERNALSYM RealGetWindowClassW}
function RealGetWindowClass(hwnd: HWND; pszType: LPTSTR; cchType: UINT): UINT; stdcall;
{$EXTERNALSYM RealGetWindowClass}

//
// Alt-Tab Switch window information.
//

type
  LPALTTABINFO = ^ALTTABINFO;
  {$EXTERNALSYM LPALTTABINFO}
  tagALTTABINFO = record
    cbSize: DWORD;
    cItems: Integer;
    cColumns: Integer;
    cRows: Integer;
    iColFocus: Integer;
    iRowFocus: Integer;
    cxItem: Integer;
    cyItem: Integer;
    ptStart: POINT;
  end;
  {$EXTERNALSYM tagALTTABINFO}
  ALTTABINFO = tagALTTABINFO;
  {$EXTERNALSYM ALTTABINFO}
  TAltTabInfo = ALTTABINFO;
  PAltTabInfo = LPALTTABINFO;

function GetAltTabInfoA(hwnd: HWND; iItem: Integer; var pati: ALTTABINFO;
  pszItemText: LPSTR; cchItemText: UINT): BOOL; stdcall;
{$EXTERNALSYM GetAltTabInfoA}
function GetAltTabInfoW(hwnd: HWND; iItem: Integer; var pati: ALTTABINFO;
  pszItemText: LPWSTR; cchItemText: UINT): BOOL; stdcall;
{$EXTERNALSYM GetAltTabInfoW}
function GetAltTabInfo(hwnd: HWND; iItem: Integer; var pati: ALTTABINFO;
  pszItemText: LPTSTR; cchItemText: UINT): BOOL; stdcall;
{$EXTERNALSYM GetAltTabInfo}

//
// Listbox information.
// Returns the number of items per row.
//

function GetListBoxInfo(hwnd: HWND): DWORD; stdcall;
{$EXTERNALSYM GetListBoxInfo}

function LockWorkStation: BOOL; stdcall;
{$EXTERNALSYM LockWorkStation}

function UserHandleGrantAccess(hUserHandle, hJob: HANDLE; bGrant: BOOL): BOOL; stdcall;
{$EXTERNALSYM UserHandleGrantAccess}

//
// Raw Input Messages.
//

type
  HRAWINPUT = HANDLE;
  {$EXTERNALSYM HRAWINPUT}

//
// WM_INPUT wParam
//

//
// Use this macro to get the input code from wParam.
//

function GET_RAWINPUT_CODE_WPARAM(wParam: WPARAM): DWORD;
{$EXTERNALSYM GET_RAWINPUT_CODE_WPARAM}

//
// The input is in the regular message flow,
// the app is required to call DefWindowProc
// so that the system can perform clean ups.
//

const
  RIM_INPUT       = 0;
  {$EXTERNALSYM RIM_INPUT}

//
// The input is sink only. The app is expected
// to behave nicely.
//

  RIM_INPUTSINK   = 1;
  {$EXTERNALSYM RIM_INPUTSINK}

//
// Raw Input data header
//

type
  tagRAWINPUTHEADER = record
    dwType: DWORD;
    dwSize: DWORD;
    hDevice: HANDLE;
    wParam: WPARAM;
  end;
  {$EXTERNALSYM tagRAWINPUTHEADER}
  RAWINPUTHEADER = tagRAWINPUTHEADER;
  {$EXTERNALSYM RAWINPUTHEADER}
  PRAWINPUTHEADER = ^RAWINPUTHEADER;
  {$EXTERNALSYM PRAWINPUTHEADER}
  LPRAWINPUTHEADER = ^RAWINPUTHEADER;
  {$EXTERNALSYM LPRAWINPUTHEADER}
  TRawInputHeader = RAWINPUTHEADER;

//
// Type of the raw input
//

const
  RIM_TYPEMOUSE      = 0;
  {$EXTERNALSYM RIM_TYPEMOUSE}
  RIM_TYPEKEYBOARD   = 1;
  {$EXTERNALSYM RIM_TYPEKEYBOARD}
  RIM_TYPEHID        = 2;
  {$EXTERNALSYM RIM_TYPEHID}

//
// Raw format of the mouse input
//

type
  tagRAWMOUSE = record
    //
    // Indicator flags.
    //
    usFlags: USHORT;

    //
    // The transition state of the mouse buttons.
    //

    union: record
    case Integer of
      0: (
        ulButtons: ULONG);
      1: (
        usButtonFlags: USHORT;
        usButtonData: USHORT);
    end;

    //
    // The raw state of the mouse buttons.
    //
    ulRawButtons: ULONG;

    //
    // The signed relative or absolute motion in the X direction.
    //
    lLastX: LONG;

    //
    // The signed relative or absolute motion in the Y direction.
    //
    lLastY: LONG;

    //
    // Device-specific additional information for the event.
    //
    ulExtraInformation: ULONG;
  end;
  {$EXTERNALSYM tagRAWMOUSE}
  RAWMOUSE = tagRAWMOUSE;
  {$EXTERNALSYM RAWMOUSE}
  PRAWMOUSE = ^RAWMOUSE;
  {$EXTERNALSYM PRAWMOUSE}
  LPRAWMOUSE = ^RAWMOUSE;
  {$EXTERNALSYM LPRAWMOUSE}
  TRawMouse = RAWMOUSE;

//
// Define the mouse button state indicators.
//

const
  RI_MOUSE_LEFT_BUTTON_DOWN   = $0001; // Left Button changed to down.
  {$EXTERNALSYM RI_MOUSE_LEFT_BUTTON_DOWN}
  RI_MOUSE_LEFT_BUTTON_UP     = $0002; // Left Button changed to up.
  {$EXTERNALSYM RI_MOUSE_LEFT_BUTTON_UP}
  RI_MOUSE_RIGHT_BUTTON_DOWN  = $0004; // Right Button changed to down.
  {$EXTERNALSYM RI_MOUSE_RIGHT_BUTTON_DOWN}
  RI_MOUSE_RIGHT_BUTTON_UP    = $0008; // Right Button changed to up.
  {$EXTERNALSYM RI_MOUSE_RIGHT_BUTTON_UP}
  RI_MOUSE_MIDDLE_BUTTON_DOWN = $0010; // Middle Button changed to down.
  {$EXTERNALSYM RI_MOUSE_MIDDLE_BUTTON_DOWN}
  RI_MOUSE_MIDDLE_BUTTON_UP   = $0020; // Middle Button changed to up.
  {$EXTERNALSYM RI_MOUSE_MIDDLE_BUTTON_UP}

  RI_MOUSE_BUTTON_1_DOWN = RI_MOUSE_LEFT_BUTTON_DOWN;
  {$EXTERNALSYM RI_MOUSE_BUTTON_1_DOWN}
  RI_MOUSE_BUTTON_1_UP   = RI_MOUSE_LEFT_BUTTON_UP;
  {$EXTERNALSYM RI_MOUSE_BUTTON_1_UP}
  RI_MOUSE_BUTTON_2_DOWN = RI_MOUSE_RIGHT_BUTTON_DOWN;
  {$EXTERNALSYM RI_MOUSE_BUTTON_2_DOWN}
  RI_MOUSE_BUTTON_2_UP   = RI_MOUSE_RIGHT_BUTTON_UP;
  {$EXTERNALSYM RI_MOUSE_BUTTON_2_UP}
  RI_MOUSE_BUTTON_3_DOWN = RI_MOUSE_MIDDLE_BUTTON_DOWN;
  {$EXTERNALSYM RI_MOUSE_BUTTON_3_DOWN}
  RI_MOUSE_BUTTON_3_UP   = RI_MOUSE_MIDDLE_BUTTON_UP;
  {$EXTERNALSYM RI_MOUSE_BUTTON_3_UP}

  RI_MOUSE_BUTTON_4_DOWN = $0040;
  {$EXTERNALSYM RI_MOUSE_BUTTON_4_DOWN}
  RI_MOUSE_BUTTON_4_UP   = $0080;
  {$EXTERNALSYM RI_MOUSE_BUTTON_4_UP}
  RI_MOUSE_BUTTON_5_DOWN = $0100;
  {$EXTERNALSYM RI_MOUSE_BUTTON_5_DOWN}
  RI_MOUSE_BUTTON_5_UP   = $0200;
  {$EXTERNALSYM RI_MOUSE_BUTTON_5_UP}

//
// If usButtonFlags has RI_MOUSE_WHEEL, the wheel delta is stored in usButtonData.
// Take it as a signed value.
//

  RI_MOUSE_WHEEL = $0400;
  {$EXTERNALSYM RI_MOUSE_WHEEL}

//
// Define the mouse indicator flags.
//

  MOUSE_MOVE_RELATIVE      = 0;
  {$EXTERNALSYM MOUSE_MOVE_RELATIVE}
  MOUSE_MOVE_ABSOLUTE      = 1;
  {$EXTERNALSYM MOUSE_MOVE_ABSOLUTE}
  MOUSE_VIRTUAL_DESKTOP    = $02; // the coordinates are mapped to the virtual desktop
  {$EXTERNALSYM MOUSE_VIRTUAL_DESKTOP}
  MOUSE_ATTRIBUTES_CHANGED = $04; // requery for mouse attributes
  {$EXTERNALSYM MOUSE_ATTRIBUTES_CHANGED}

//
// Raw format of the keyboard input
//

type
  tagRAWKEYBOARD = record
    //
    // The "make" scan code (key depression).
    //
    MakeCode: USHORT;

    //
    // The flags field indicates a "break" (key release) and other
    // miscellaneous scan code information defined in ntddkbd.h.
    //
    Flags: USHORT;

    Reserved: USHORT;

    //
    // Windows message compatible information
    //
    VKey: USHORT;
    Message: UINT;

    //
    // Device-specific additional information for the event.
    //
    ExtraInformation: ULONG;
  end;
  {$EXTERNALSYM tagRAWKEYBOARD}
  RAWKEYBOARD = tagRAWKEYBOARD;
  {$EXTERNALSYM RAWKEYBOARD}
  PRAWKEYBOARD = ^RAWKEYBOARD;
  {$EXTERNALSYM PRAWKEYBOARD}
  LPRAWKEYBOARD = ^RAWKEYBOARD;
  {$EXTERNALSYM LPRAWKEYBOARD}
  TRawKeyBoard = RAWKEYBOARD;

//
// Define the keyboard overrun MakeCode.
//

const
  KEYBOARD_OVERRUN_MAKE_CODE = $FF;
  {$EXTERNALSYM KEYBOARD_OVERRUN_MAKE_CODE}

//
// Define the keyboard input data Flags.
//

  RI_KEY_MAKE            = 0;
  {$EXTERNALSYM RI_KEY_MAKE}
  RI_KEY_BREAK           = 1;
  {$EXTERNALSYM RI_KEY_BREAK}
  RI_KEY_E0              = 2;
  {$EXTERNALSYM RI_KEY_E0}
  RI_KEY_E1              = 4;
  {$EXTERNALSYM RI_KEY_E1}
  RI_KEY_TERMSRV_SET_LED = 8;
  {$EXTERNALSYM RI_KEY_TERMSRV_SET_LED}
  RI_KEY_TERMSRV_SHADOW  = $10;
  {$EXTERNALSYM RI_KEY_TERMSRV_SHADOW}

//
// Raw format of the input from Human Input Devices
//

type
  tagRAWHID = record
    dwSizeHid: DWORD;    // byte size of each report
    dwCount: DWORD;      // number of input packed
    bRawData: array [0..0] of BYTE;
  end;
  {$EXTERNALSYM tagRAWHID}
  RAWHID = tagRAWHID;
  {$EXTERNALSYM RAWHID}
  PRAWHID = ^RAWHID;
  {$EXTERNALSYM PRAWHID}
  LPRAWHID = ^RAWHID;
  {$EXTERNALSYM LPRAWHID}
  TRawHid = RAWHID;

//
// RAWINPUT data structure.
//

  tagRAWINPUT = record
    header: RAWINPUTHEADER;
    case Integer of
      0: (mouse: RAWMOUSE);
      1: (keyboard: RAWKEYBOARD);
      2: (hid: RAWHID);
  end;
  {$EXTERNALSYM tagRAWINPUT}
  RAWINPUT = tagRAWINPUT;
  {$EXTERNALSYM RAWINPUT}
  PRAWINPUT = ^RAWINPUT;
  {$EXTERNALSYM PRAWINPUT}
  LPRAWINPUT = ^RAWINPUT;
  {$EXTERNALSYM LPRAWINPUT}
  TRawInput = RAWINPUT;

function RAWINPUT_ALIGN(x: Pointer): Pointer;
{$EXTERNALSYM RAWINPUT_ALIGN}

function NEXTRAWINPUTBLOCK(ptr: PRawInput): PRawInput;
{$EXTERNALSYM NEXTRAWINPUTBLOCK}

//
// Flags for GetRawInputData
//

const
  RID_INPUT  = $10000003;
  {$EXTERNALSYM RID_INPUT}
  RID_HEADER = $10000005;
  {$EXTERNALSYM RID_HEADER}

function GetRawInputData(hRawInput: HRAWINPUT; uiCommand: UINT; pData: LPVOID;
  var pcbSize: UINT; cbSizeHeader: UINT): UINT; stdcall;
{$EXTERNALSYM GetRawInputData}

//
// Raw Input Device Information
//

const
  RIDI_PREPARSEDDATA = $20000005;
  {$EXTERNALSYM RIDI_PREPARSEDDATA}
  RIDI_DEVICENAME    = $20000007; // the return valus is the character length, not the byte size
  {$EXTERNALSYM RIDI_DEVICENAME}
  RIDI_DEVICEINFO    = $2000000b;
  {$EXTERNALSYM RIDI_DEVICEINFO}

type
  PRID_DEVICE_INFO_MOUSE = ^RID_DEVICE_INFO_MOUSE;
  {$EXTERNALSYM PRID_DEVICE_INFO_MOUSE}
  tagRID_DEVICE_INFO_MOUSE = record
    dwId: DWORD;
    dwNumberOfButtons: DWORD;
    dwSampleRate: DWORD;
  end;
  {$EXTERNALSYM tagRID_DEVICE_INFO_MOUSE}
  RID_DEVICE_INFO_MOUSE = tagRID_DEVICE_INFO_MOUSE;
  {$EXTERNALSYM RID_DEVICE_INFO_MOUSE}
  TRidDeviceInfoMouse = RID_DEVICE_INFO_MOUSE;
  PRidDeviceInfoMouse = PRID_DEVICE_INFO_MOUSE;

  PRID_DEVICE_INFO_KEYBOARD = ^RID_DEVICE_INFO_KEYBOARD;
  {$EXTERNALSYM PRID_DEVICE_INFO_KEYBOARD}
  tagRID_DEVICE_INFO_KEYBOARD = record
    dwType: DWORD;
    dwSubType: DWORD;
    dwKeyboardMode: DWORD;
    dwNumberOfFunctionKeys: DWORD;
    dwNumberOfIndicators: DWORD;
    dwNumberOfKeysTotal: DWORD;
  end;
  {$EXTERNALSYM tagRID_DEVICE_INFO_KEYBOARD}
  RID_DEVICE_INFO_KEYBOARD = tagRID_DEVICE_INFO_KEYBOARD;
  {$EXTERNALSYM RID_DEVICE_INFO_KEYBOARD}
  TRidDeviceInfoKeyboard = RID_DEVICE_INFO_KEYBOARD;
  PRidDeviceInfoKeyboard = PRID_DEVICE_INFO_KEYBOARD;

  PRID_DEVICE_INFO_HID = ^RID_DEVICE_INFO_HID;
  {$EXTERNALSYM PRID_DEVICE_INFO_HID}
  tagRID_DEVICE_INFO_HID = record
    dwVendorId: DWORD;
    dwProductId: DWORD;
    dwVersionNumber: DWORD;
    //
    // Top level collection UsagePage and Usage
    //
    usUsagePage: USHORT;
    usUsage: USHORT;
  end;
  {$EXTERNALSYM tagRID_DEVICE_INFO_HID}
  RID_DEVICE_INFO_HID = tagRID_DEVICE_INFO_HID;
  {$EXTERNALSYM RID_DEVICE_INFO_HID}
  TRidDeviceInfoHid = RID_DEVICE_INFO_HID;
  PRidDeviceInfoHid = PRID_DEVICE_INFO_HID;

  tagRID_DEVICE_INFO = record
    cbSize: DWORD;
    dwType: DWORD;
    case Integer of
    0: (mouse: RID_DEVICE_INFO_MOUSE);
    1: (keyboard: RID_DEVICE_INFO_KEYBOARD);
    2: (hid: RID_DEVICE_INFO_HID);
  end;
  {$EXTERNALSYM tagRID_DEVICE_INFO}
  RID_DEVICE_INFO = tagRID_DEVICE_INFO;
  {$EXTERNALSYM RID_DEVICE_INFO}
  PRID_DEVICE_INFO = ^RID_DEVICE_INFO;
  {$EXTERNALSYM PRID_DEVICE_INFO}
  LPRID_DEVICE_INFO = ^RID_DEVICE_INFO;
  {$EXTERNALSYM LPRID_DEVICE_INFO}
  TRidDeviceInfo = RID_DEVICE_INFO;
  PRidDeviceInfo = PRID_DEVICE_INFO;

function GetRawInputDeviceInfoA(hDevice: HANDLE; uiCommand: UINT; pData: LPVOID;
  var pcbSize: UINT): UINT; stdcall;
{$EXTERNALSYM GetRawInputDeviceInfoA}
function GetRawInputDeviceInfoW(hDevice: HANDLE; uiCommand: UINT; pData: LPVOID;
  var pcbSize: UINT): UINT; stdcall;
{$EXTERNALSYM GetRawInputDeviceInfoW}
function GetRawInputDeviceInfo(hDevice: HANDLE; uiCommand: UINT; pData: LPVOID;
  var pcbSize: UINT): UINT; stdcall;
{$EXTERNALSYM GetRawInputDeviceInfo}

//
// Raw Input Bulk Read: GetRawInputBuffer
//

function GetRawInputBuffer(pData: PRAWINPUT; var pcbSize: UINT; cbSizeHeader: UINT): UINT; stdcall;
{$EXTERNALSYM GetRawInputBuffer}

//
// Raw Input request APIs
//

type
  LPRAWINPUTDEVICE = ^RAWINPUTDEVICE;
  {$EXTERNALSYM LPRAWINPUTDEVICE}
  PRAWINPUTDEVICE = ^RAWINPUTDEVICE;
  {$EXTERNALSYM PRAWINPUTDEVICE}
  tagRAWINPUTDEVICE = record
    usUsagePage: USHORT; // Toplevel collection UsagePage
    usUsage: USHORT;     // Toplevel collection Usage
    dwFlags: DWORD;
    hwndTarget: HWND;    // Target hwnd. NULL = follows keyboard focus
  end;
  {$EXTERNALSYM tagRAWINPUTDEVICE}
  RAWINPUTDEVICE = tagRAWINPUTDEVICE;
  {$EXTERNALSYM RAWINPUTDEVICE}
  TRawInputDevice = RAWINPUTDEVICE;

const
  RIDEV_REMOVE       = $00000001;
  {$EXTERNALSYM RIDEV_REMOVE}
  RIDEV_EXCLUDE      = $00000010;
  {$EXTERNALSYM RIDEV_EXCLUDE}
  RIDEV_PAGEONLY     = $00000020;
  {$EXTERNALSYM RIDEV_PAGEONLY}
  RIDEV_NOLEGACY     = $00000030;
  {$EXTERNALSYM RIDEV_NOLEGACY}
  RIDEV_INPUTSINK    = $00000100;
  {$EXTERNALSYM RIDEV_INPUTSINK}
  RIDEV_CAPTUREMOUSE = $00000200; // effective when mouse nolegacy is specified, otherwise it would be an error
  {$EXTERNALSYM RIDEV_CAPTUREMOUSE}
  RIDEV_NOHOTKEYS    = $00000200; // effective for keyboard.
  {$EXTERNALSYM RIDEV_NOHOTKEYS}
  RIDEV_APPKEYS      = $00000400;  // effective for keyboard.
  {$EXTERNALSYM RIDEV_APPKEYS}
  RIDEV_EXMODEMASK   = $000000F0;
  {$EXTERNALSYM RIDEV_EXMODEMASK}
  RIDEV_DEVNOTIFY    = $00002000;
  {$EXTERNALSYM RIDEV_DEVNOTIFY}

function RIDEV_EXMODE(mode: DWORD): DWORD;
{$EXTERNALSYM RIDEV_EXMODE}

function RegisterRawInputDevices(pRawInputDevices: PRAWINPUTDEVICE;
  uiNumDevices: UINT; cbSize: UINT): BOOL; stdcall;
{$EXTERNALSYM RegisterRawInputDevices}

function GetRegisteredRawInputDevices(pRawInputDevices: PRAWINPUTDEVICE;
  var puiNumDevices: UINT; cbSize: UINT): UINT; stdcall;
{$EXTERNALSYM GetRegisteredRawInputDevices}

type
  PRAWINPUTDEVICELIST = ^RAWINPUTDEVICELIST;
  {$EXTERNALSYM PRAWINPUTDEVICELIST}
  tagRAWINPUTDEVICELIST = record
    hDevice: HANDLE;
    dwType: DWORD;
  end;
  {$EXTERNALSYM tagRAWINPUTDEVICELIST}
  RAWINPUTDEVICELIST = tagRAWINPUTDEVICELIST;
  {$EXTERNALSYM RAWINPUTDEVICELIST}
  TRawInputDeviceList = RAWINPUTDEVICELIST;

function GetRawInputDeviceList(pRawInputDeviceList: PRAWINPUTDEVICELIST; var puiNumDevices: UINT;
  cbSize: UINT): UINT; stdcall;
{$EXTERNALSYM GetRawInputDeviceList}

function DefRawInputProc(paRawInput: PRAWINPUT; nInput: Integer; cbSizeHeader: UINT): LRESULT; stdcall;
{$EXTERNALSYM DefRawInputProc}

{$ENDIF JWA_INTERFACESECTION}

{$IFNDEF JWA_INCLUDEMODE}

implementation

uses
  JwaWinDLLNames;

{$ENDIF !JWA_INCLUDEMODE}

{$IFDEF JWA_IMPLEMENTATIONSECTION}

function IS_INTRESOURCE(wInteger: WORD): BOOL;
begin
  Result := (ULONG_PTR(wInteger) shr 16) = 0;
end;

function GET_WHEEL_DELTA_WPARAM(wParam: WPARAM): SHORT;
begin
  Result := SHORT(HIWORD(wParam));
end;

function GET_KEYSTATE_WPARAM(wParam: WPARAM): Integer;
begin
  Result := LOWORD(wParam);
end;

function GET_NCHITTEST_WPARAM(wParam: WPARAM): Shortint;
begin
  Result := LOWORD(wParam);
end;

function GET_XBUTTON_WPARAM(wParam: WPARAM): Integer;
begin
  Result := HIWORD(wParam);
end;

{$IFDEF WIN2000_UP}

function GET_APPCOMMAND_LPARAM(lParam: LPARAM): WORD;
begin
  Result := WORD(HIWORD(lParam) and not FAPPCOMMAND_MASK);
end;

function GET_DEVICE_LPARAM(lParam: LPARAM): WORD;
begin
  Result := WORD(HIWORD(lParam) and FAPPCOMMAND_MASK);
end;

function GET_MOUSEORKEY_LPARAM(lParam: LPARAM): WORD;
begin
  Result := GET_DEVICE_LPARAM(lParam);
end;

function GET_FLAGS_LPARAM(lParam: LPARAM): Integer;
begin
  Result := LOWORD(lParam);
end;

function GET_KEYSTATE_LPARAM(lParam: LPARAM): Integer;
begin
  Result := GET_FLAGS_LPARAM(lParam);
end;

{$ENDIF WIN2000_UP}

function MAKEWPARAM(wLow, wHigh: WORD): WPARAM;
begin
  Result := WPARAM(DWORD(MAKELONG(wLow, wHigh)));
end;

function MAKELPARAM(wLow, wHigh: WORD): LPARAM;
begin
  Result := LPARAM(DWORD(MAKELONG(wLow, wHigh)));
end;

function MAKELRESULT(wLow, wHigh: WORD): LRESULT;
begin
  Result := LRESULT(DWORD(MAKELONG(wLow, wHigh)));
end;

function ExitWindows(dwReserved: DWORD; uREserved: UINT): BOOL;
begin
  Result := ExitWindowsEx(EWX_LOGOFF, $FFFFFFFF);
end;

function PostAppMessageA(idThread: DWORD; wMsg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
begin
  Result := PostThreadMessageA(idThread, wMsg, wParam, lParam);
end;

function PostAppMessageW(idThread: DWORD; wMsg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
begin
  Result := PostThreadMessageW(idThread, wMsg, wParam, lParam);
end;

function PostAppMessage(idThread: DWORD; wMsg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
begin
  {$IFDEF UNICODE}
  Result := PostThreadMessageW(idThread, wMsg, wParam, lParam);
  {$ELSE}
  Result := PostThreadMessageA(idThread, wMsg, wParam, lParam);
  {$ENDIF UNICODE}
end;

function CreateWindowA(lpClassName: LPCSTR; lpWindowName: LPCSTR; dwStyle: DWORD;
  x, y, nWidth, nHeight: Integer; hWndParent: HWND; hMenu: HMENU;
  hInstance: HINST; lpParam: LPVOID): HWND;
begin
  Result := CreateWindowExA(0, lpClassName, lpWindowName, dwStyle, x, y,
    nWidth, nHeight, hWndParent, hMenu, hInstance, lpParam);
end;

function CreateWindowW(lpClassName: LPCWSTR; lpWindowName: LPCWSTR; dwStyle: DWORD;
  x, y, nWidth, nHeight: Integer; hWndParent: HWND; hMenu: HMENU;
  hInstance: HINST; lpParam: LPVOID): HWND;
begin
  Result := CreateWindowExW(0, lpClassName, lpWindowName, dwStyle, x, y,
    nWidth, nHeight, hWndParent, hMenu, hInstance, lpParam);
end;

function CreateWindow(lpClassName: LPCTSTR; lpWindowName: LPCTSTR; dwStyle: DWORD;
  x, y, nWidth, nHeight: Integer; hWndParent: HWND; hMenu: HMENU;
  hInstance: HINST; lpParam: LPVOID): HWND;
begin
  {$IFDEF UNICODE}
  Result := CreateWindowExW(0, lpClassName, lpWindowName, dwStyle, x, y,
    nWidth, nHeight, hWndParent, hMenu, hInstance, lpParam);
  {$ELSE}
  Result := CreateWindowExA(0, lpClassName, lpWindowName, dwStyle, x, y,
    nWidth, nHeight, hWndParent, hMenu, hInstance, lpParam);
  {$ENDIF UNICODE}
end;

function CreateDialogA(hInstance: HINST; lpName: LPCSTR; hWndParent: HWND; lpDialogFunc: DLGPROC): HWND;
begin
  Result := CreateDialogParamA(hInstance, lpName, hWndParent, lpDialogFunc, 0);
end;

function CreateDialogW(hInstance: HINST; lpName: LPCWSTR; hWndParent: HWND; lpDialogFunc: DLGPROC): HWND;
begin
  Result := CreateDialogParamW(hInstance, lpName, hWndParent, lpDialogFunc, 0);
end;

function CreateDialog(hInstance: HINST; lpName: LPCTSTR; hWndParent: HWND; lpDialogFunc: DLGPROC): HWND;
begin
  {$IFDEF UNICODE}
  Result := CreateDialogParamW(hInstance, lpName, hWndParent, lpDialogFunc, 0);
  {$ELSE}
  Result := CreateDialogParamA(hInstance, lpName, hWndParent, lpDialogFunc, 0);
  {$ENDIF UNICODE}
end;

function CreateDialogIndirectA(hInstance: HINST; const lpTemplate: DLGTEMPLATE;
  hWndParent: HWND; lpDialogFunc: DLGPROC): HWND;
begin
  Result := CreateDialogIndirectParamA(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0);
end;

function CreateDialogIndirectW(hInstance: HINST; const lpTemplate: DLGTEMPLATE;
  hWndParent: HWND; lpDialogFunc: DLGPROC): HWND;
begin
  Result := CreateDialogIndirectParamW(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0);
end;

function CreateDialogIndirect(hInstance: HINST; const lpTemplate: DLGTEMPLATE;
  hWndParent: HWND; lpDialogFunc: DLGPROC): HWND;
begin
  {$IFDEF UNICODE}
  Result := CreateDialogIndirectParamW(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0);
  {$ELSE}
  Result := CreateDialogIndirectParamA(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0);
  {$ENDIF UNICODE}
end;

function DialogBoxA(hInstance: HINST; lpTemplate: LPCSTR; hWndParent: HWND; lpDialogFunc: DLGPROC): INT_PTR;
begin
  Result := DialogBoxParamA(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0);
end;

function DialogBoxW(hInstance: HINST; lpTemplate: LPCWSTR; hWndParent: HWND; lpDialogFunc: DLGPROC): INT_PTR;
begin
  Result := DialogBoxParamW(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0);
end;

function DialogBox(hInstance: HINST; lpTemplate: LPCTSTR; hWndParent: HWND; lpDialogFunc: DLGPROC): INT_PTR;
begin
  {$IFDEF UNICODE}
  Result := DialogBoxParamW(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0);
  {$ELSE}
  Result := DialogBoxParamA(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0);
  {$ENDIF UNICODE}
end;

function DialogBoxIndirectA(hInstance: HINST; const lpTemplate: DLGTEMPLATE; hWndParent: HWND; lpDialogFunc: DLGPROC): INT_PTR;
begin
  Result := DialogBoxIndirectParamA(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0);
end;

function DialogBoxIndirectW(hInstance: HINST; const lpTemplate: DLGTEMPLATE; hWndParent: HWND; lpDialogFunc: DLGPROC): INT_PTR;
begin
  Result := DialogBoxIndirectParamW(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0);
end;

function DialogBoxIndirect(hInstance: HINST; const lpTemplate: DLGTEMPLATE; hWndParent: HWND; lpDialogFunc: DLGPROC): INT_PTR;
begin
  {$IFDEF UNICODE}
  Result := DialogBoxIndirectParamW(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0);
  {$ELSE}
  Result := DialogBoxIndirectParamA(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0);
  {$ENDIF UNICODE}
end;

function AnsiToOem(lpszSrc: LPCSTR; lpszDst: LPSTR): BOOL;
begin
  Result := CharToOemA(lpszSrc, lpszDst);
end;

function OemToAnsi(lpszSrc: LPCSTR; lpszDst: LPSTR): BOOL;
begin
  Result := OemToCharA(lpszSrc, lpszDst);
end;

function AnsiToOemBuff(lpszSrc: LPCSTR; lpszDst: LPSTR; cchDstLength: DWORD): BOOL;
begin
  Result := CharToOemBuffA(lpszSrc, lpszDst, cchDstLength);
end;

function OemToAnsiBuff(lpszSrc: LPCSTR; lpszDst: LPSTR; cchDstLength: DWORD): BOOL;
begin
  Result := OemToCharBuffA(lpszSrc, lpszDst, cchDstLength);
end;

function AnsiUpper(lpsz: LPSTR): LPSTR;
begin
  Result := CharUpperA(lpsz);
end;

function AnsiUpperBuff(lpsz: LPSTR; cchLength: DWORD): DWORD;
begin
  Result := CharUpperBuffA(lpsz, cchLength);
end;

function AnsiLower(lpsz: LPSTR): LPSTR;
begin
  Result := CharLowerA(lpsz);
end;

function AnsiLowerBuff(lpsz: LPSTR; cchLength: DWORD): DWORD;
begin
  Result := CharLowerBuffA(lpsz, cchLength);
end;

function AnsiNext(lpsz: LPCSTR): LPSTR;
begin
  Result := CharNextA(lpsz);
end;

function AnsiPrev(lpszStart: LPCSTR; lpszCurrent: LPCSTR): LPSTR;
begin
  Result := CharPrevA(lpszStart, lpszCurrent);
end;

function GetWindowLongPtrA(hWnd: HWND; nIndex: Integer): LONG_PTR;
begin
  Result := GetWindowLongA(hWnd, nIndex);
end;

function GetWindowLongPtrW(hWnd: HWND; nIndex: Integer): LONG_PTR;
begin
  Result := GetWindowLongW(hWnd, nIndex);
end;

function GetWindowLongPtr(hWnd: HWND; nIndex: Integer): LONG_PTR;
begin
  {$IFDEF UNICODE}
  Result := GetWindowLongW(hWnd, nIndex);
  {$ELSE}
  Result := GetWindowLongA(hWnd, nIndex);
  {$ENDIF UNICODE}
end;

function SetWindowLongPtrA(hWnd: HWND; nIndex: Integer; dwNewLong: LONG_PTR): LONG_PTR;
begin
  Result := SetWindowLongA(hWnd, nIndex, dwNewLong);
end;

function SetWindowLongPtrW(hWnd: HWND; nIndex: Integer; dwNewLong: LONG_PTR): LONG_PTR;
begin
  Result := SetWindowLongW(hWnd, nIndex, dwNewLong);
end;

function SetWindowLongPtr(hWnd: HWND; nIndex: Integer; dwNewLong: LONG_PTR): LONG_PTR;
begin
  {$IFDEF UNICODE}
  Result := SetWindowLongW(hWnd, nIndex, dwNewLong);
  {$ELSE}
  Result := SetWindowLongA(hWnd, nIndex, dwNewLong);
  {$ENDIF UNICODE}
end;

function GetClassLongPtrA(hWnd: HWND; nIndex: Integer): ULONG_PTR;
begin
  Result := GetClassLongA(hWnd, nIndex);
end;

function GetClassLongPtrW(hWnd: HWND; nIndex: Integer): ULONG_PTR;
begin
  Result := GetClassLongW(hWnd, nIndex);
end;

function GetClassLongPtr(hWnd: HWND; nIndex: Integer): ULONG_PTR;
begin
  {$IFDEF UNICODE}
  Result := GetClassLongW(hWnd, nIndex);
  {$ELSE}
  Result := GetClassLongA(hWnd, nIndex);
  {$ENDIF UNICODE}
end;

function SetClassLongPtrA(hWnd: HWND; nIndex: Integer; dwNewLong: ULONG_PTR): ULONG_PTR;
begin
  Result := SetClassLongA(hWnd, nIndex, dwNewLong);
end;

function SetClassLongPtrW(hWnd: HWND; nIndex: Integer; dwNewLong: ULONG_PTR): ULONG_PTR;
begin
  Result := SetClassLongW(hWnd, nIndex, dwNewLong);
end;

function SetClassLongPtr(hWnd: HWND; nIndex: Integer; dwNewLong: ULONG_PTR): ULONG_PTR;
begin
  {$IFDEF UNICODE}
  Result := SetClassLongW(hWnd, nIndex, dwNewLong);
  {$ELSE}
  Result := SetClassLongA(hWnd, nIndex, dwNewLong);
  {$ENDIF UNICODE}
end;

function EnumTaskWindows(hTask: HANDLE; lpfn: WNDENUMPROC; lParam: LPARAM): BOOL;
begin
  Result := EnumThreadWindows(ULONG(hTask), lpfn, lParam);
end;

function GetNextWindow(hWnd: HWND; wCmd: UINT): HWND;
begin
  Result := GetWindow(hWnd, wCmd);
end;

function GetWindowTask(hWnd: HWND): HANDLE;
begin
  Result := HANDLE(DWORD_PTR(GetWindowThreadProcessId(hWnd, nil)));
end;

function DefHookProc(nCode: Integer; wParam: WPARAM; lParam: LPARAM; phhk: LPHHOOK): LRESULT;
begin
  Result := CallNextHookEx(HHOOK(phhk^), nCode, wParam, lParam);
end;

function CopyCursor(pcur: HCURSOR): HCURSOR;
begin
 Result := HCURSOR(CopyIcon(HICON(pcur)));
end;

function GET_RAWINPUT_CODE_WPARAM(wParam: WPARAM): DWORD;
begin
  Result := wParam and $ff;
end;

function RAWINPUT_ALIGN(x: Pointer): Pointer;
begin
  Result := Pointer((Integer(x) + SizeOf(DWORD) - 1) and not (SizeOf(DWORD) - 1));
end;

function NEXTRAWINPUTBLOCK(ptr: PRawInput): PRawInput;
begin
  Result := PRAWINPUT(DWORD(RAWINPUT_ALIGN(ptr)) + ptr^.header.dwSize);
end;

function RIDEV_EXMODE(mode: DWORD): DWORD;
begin
  Result := mode and RIDEV_EXMODEMASK;
end;

{$IFDEF DYNAMIC_LINK}

var
  _IsHungAppWindow: Pointer;

function IsHungAppWindow;
begin
  GetProcedureAddress(_IsHungAppWindow, user32, 'IsHungAppWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsHungAppWindow]
  end;
end;

var
  _DisableProcessWindowsGhosting: Pointer;

procedure DisableProcessWindowsGhosting;
begin
  GetProcedureAddress(_DisableProcessWindowsGhosting, user32, 'DisableProcessWindowsGhosting');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DisableProcessWindowsGhosting]
  end;
end;

var
  _wvsprintfA: Pointer;

function wvsprintfA;
begin
  GetProcedureAddress(_wvsprintfA, user32, 'wvsprintfA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_wvsprintfA]
  end;
end;

var
  _wvsprintfW: Pointer;

function wvsprintfW;
begin
  GetProcedureAddress(_wvsprintfW, user32, 'wvsprintfW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_wvsprintfW]
  end;
end;

var
  _wvsprintf: Pointer;

function wvsprintf;
begin
  GetProcedureAddress(_wvsprintf, user32, 'wvsprintf' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_wvsprintf]
  end;
end;

var
  _wsprintfA: Pointer;

function wsprintfA;
begin
  GetProcedureAddress(_wsprintfA, user32, 'wsprintfA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_wsprintfA]
  end;
end;

var
  _wsprintfW: Pointer;

function wsprintfW;
begin
  GetProcedureAddress(_wsprintfW, user32, 'wsprintfW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_wsprintfW]
  end;
end;

var
  _wsprintf: Pointer;

function wsprintf;
begin
  GetProcedureAddress(_wsprintf, user32, 'wsprintf' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_wsprintf]
  end;
end;

var
  _LoadKeyboardLayoutA: Pointer;

function LoadKeyboardLayoutA;
begin
  GetProcedureAddress(_LoadKeyboardLayoutA, user32, 'LoadKeyboardLayoutA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadKeyboardLayoutA]
  end;
end;

var
  _LoadKeyboardLayoutW: Pointer;

function LoadKeyboardLayoutW;
begin
  GetProcedureAddress(_LoadKeyboardLayoutW, user32, 'LoadKeyboardLayoutW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadKeyboardLayoutW]
  end;
end;

var
  _LoadKeyboardLayout: Pointer;

function LoadKeyboardLayout;
begin
  GetProcedureAddress(_LoadKeyboardLayout, user32, 'LoadKeyboardLayout' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadKeyboardLayout]
  end;
end;

var
  _ActivateKeyboardLayout: Pointer;

function ActivateKeyboardLayout;
begin
  GetProcedureAddress(_ActivateKeyboardLayout, user32, 'ActivateKeyboardLayout');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ActivateKeyboardLayout]
  end;
end;

var
  _ToUnicodeEx: Pointer;

function ToUnicodeEx;
begin
  GetProcedureAddress(_ToUnicodeEx, user32, 'ToUnicodeEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ToUnicodeEx]
  end;
end;

var
  _UnloadKeyboardLayout: Pointer;

function UnloadKeyboardLayout;
begin
  GetProcedureAddress(_UnloadKeyboardLayout, user32, 'UnloadKeyboardLayout');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_UnloadKeyboardLayout]
  end;
end;

var
  _GetKeyboardLayoutNameA: Pointer;

function GetKeyboardLayoutNameA;
begin
  GetProcedureAddress(_GetKeyboardLayoutNameA, user32, 'GetKeyboardLayoutNameA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetKeyboardLayoutNameA]
  end;
end;

var
  _GetKeyboardLayoutNameW: Pointer;

function GetKeyboardLayoutNameW;
begin
  GetProcedureAddress(_GetKeyboardLayoutNameW, user32, 'GetKeyboardLayoutNameW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetKeyboardLayoutNameW]
  end;
end;

var
  _GetKeyboardLayoutName: Pointer;

function GetKeyboardLayoutName;
begin
  GetProcedureAddress(_GetKeyboardLayoutName, user32, 'GetKeyboardLayoutName' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetKeyboardLayoutName]
  end;
end;

var
  _GetKeyboardLayoutList: Pointer;

function GetKeyboardLayoutList;
begin
  GetProcedureAddress(_GetKeyboardLayoutList, user32, 'GetKeyboardLayoutList');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetKeyboardLayoutList]
  end;
end;

var
  _GetKeyboardLayout: Pointer;

function GetKeyboardLayout;
begin
  GetProcedureAddress(_GetKeyboardLayout, user32, 'GetKeyboardLayout');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetKeyboardLayout]
  end;
end;

var
  _GetMouseMovePointsEx: Pointer;

function GetMouseMovePointsEx;
begin
  GetProcedureAddress(_GetMouseMovePointsEx, user32, 'GetMouseMovePointsEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMouseMovePointsEx]
  end;
end;

var
  _CreateDesktopA: Pointer;

function CreateDesktopA;
begin
  GetProcedureAddress(_CreateDesktopA, user32, 'CreateDesktopA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateDesktopA]
  end;
end;

var
  _CreateDesktopW: Pointer;

function CreateDesktopW;
begin
  GetProcedureAddress(_CreateDesktopW, user32, 'CreateDesktopW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateDesktopW]
  end;
end;

var
  _CreateDesktop: Pointer;

function CreateDesktop;
begin
  GetProcedureAddress(_CreateDesktop, user32, 'CreateDesktop' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateDesktop]
  end;
end;

var
  _OpenDesktopA: Pointer;

function OpenDesktopA;
begin
  GetProcedureAddress(_OpenDesktopA, user32, 'OpenDesktopA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OpenDesktopA]
  end;
end;

var
  _OpenDesktopW: Pointer;

function OpenDesktopW;
begin
  GetProcedureAddress(_OpenDesktopW, user32, 'OpenDesktopW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OpenDesktopW]
  end;
end;

var
  _OpenDesktop: Pointer;

function OpenDesktop;
begin
  GetProcedureAddress(_OpenDesktop, user32, 'OpenDesktop' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OpenDesktop]
  end;
end;

var
  _OpenInputDesktop: Pointer;

function OpenInputDesktop;
begin
  GetProcedureAddress(_OpenInputDesktop, user32, 'OpenInputDesktop');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OpenInputDesktop]
  end;
end;

var
  _EnumDesktopsA: Pointer;

function EnumDesktopsA;
begin
  GetProcedureAddress(_EnumDesktopsA, user32, 'EnumDesktopsA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDesktopsA]
  end;
end;

var
  _EnumDesktopsW: Pointer;

function EnumDesktopsW;
begin
  GetProcedureAddress(_EnumDesktopsW, user32, 'EnumDesktopsW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDesktopsW]
  end;
end;

var
  _EnumDesktops: Pointer;

function EnumDesktops;
begin
  GetProcedureAddress(_EnumDesktops, user32, 'EnumDesktops' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDesktops]
  end;
end;

var
  _EnumDesktopWindows: Pointer;

function EnumDesktopWindows;
begin
  GetProcedureAddress(_EnumDesktopWindows, user32, 'EnumDesktopWindows');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDesktopWindows]
  end;
end;

var
  _SwitchDesktop: Pointer;

function SwitchDesktop;
begin
  GetProcedureAddress(_SwitchDesktop, user32, 'SwitchDesktop');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SwitchDesktop]
  end;
end;

var
  _SetThreadDesktop: Pointer;

function SetThreadDesktop;
begin
  GetProcedureAddress(_SetThreadDesktop, user32, 'SetThreadDesktop');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetThreadDesktop]
  end;
end;

var
  _CloseDesktop: Pointer;

function CloseDesktop;
begin
  GetProcedureAddress(_CloseDesktop, user32, 'CloseDesktop');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CloseDesktop]
  end;
end;

var
  _GetThreadDesktop: Pointer;

function GetThreadDesktop;
begin
  GetProcedureAddress(_GetThreadDesktop, user32, 'GetThreadDesktop');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetThreadDesktop]
  end;
end;

var
  _CreateWindowStationA: Pointer;

function CreateWindowStationA;
begin
  GetProcedureAddress(_CreateWindowStationA, user32, 'CreateWindowStationA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateWindowStationA]
  end;
end;

var
  _CreateWindowStationW: Pointer;

function CreateWindowStationW;
begin
  GetProcedureAddress(_CreateWindowStationW, user32, 'CreateWindowStationW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateWindowStationW]
  end;
end;

var
  _CreateWindowStation: Pointer;

function CreateWindowStation;
begin
  GetProcedureAddress(_CreateWindowStation, user32, 'CreateWindowStation' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateWindowStation]
  end;
end;

var
  _OpenWindowStationA: Pointer;

function OpenWindowStationA;
begin
  GetProcedureAddress(_OpenWindowStationA, user32, 'OpenWindowStationA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OpenWindowStationA]
  end;
end;

var
  _OpenWindowStationW: Pointer;

function OpenWindowStationW;
begin
  GetProcedureAddress(_OpenWindowStationW, user32, 'OpenWindowStationW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OpenWindowStationW]
  end;
end;

var
  _OpenWindowStation: Pointer;

function OpenWindowStation;
begin
  GetProcedureAddress(_OpenWindowStation, user32, 'OpenWindowStation' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OpenWindowStation]
  end;
end;

var
  _EnumWindowStationsA: Pointer;

function EnumWindowStationsA;
begin
  GetProcedureAddress(_EnumWindowStationsA, user32, 'EnumWindowStationsA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumWindowStationsA]
  end;
end;

var
  _EnumWindowStationsW: Pointer;

function EnumWindowStationsW;
begin
  GetProcedureAddress(_EnumWindowStationsW, user32, 'EnumWindowStationsW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumWindowStationsW]
  end;
end;

var
  _EnumWindowStations: Pointer;

function EnumWindowStations;
begin
  GetProcedureAddress(_EnumWindowStations, user32, 'EnumWindowStations' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumWindowStations]
  end;
end;

var
  _CloseWindowStation: Pointer;

function CloseWindowStation;
begin
  GetProcedureAddress(_CloseWindowStation, user32, 'CloseWindowStation');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CloseWindowStation]
  end;
end;

var
  _SetProcessWindowStation: Pointer;

function SetProcessWindowStation;
begin
  GetProcedureAddress(_SetProcessWindowStation, user32, 'SetProcessWindowStation');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetProcessWindowStation]
  end;
end;

var
  _GetProcessWindowStation: Pointer;

function GetProcessWindowStation;
begin
  GetProcedureAddress(_GetProcessWindowStation, user32, 'GetProcessWindowStation');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetProcessWindowStation]
  end;
end;

var
  _SetUserObjectSecurity: Pointer;

function SetUserObjectSecurity;
begin
  GetProcedureAddress(_SetUserObjectSecurity, user32, 'SetUserObjectSecurity');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetUserObjectSecurity]
  end;
end;

var
  _GetUserObjectSecurity: Pointer;

function GetUserObjectSecurity;
begin
  GetProcedureAddress(_GetUserObjectSecurity, user32, 'GetUserObjectSecurity');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetUserObjectSecurity]
  end;
end;

var
  _GetUserObjectInformationA: Pointer;

function GetUserObjectInformationA;
begin
  GetProcedureAddress(_GetUserObjectInformationA, user32, 'GetUserObjectInformationA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetUserObjectInformationA]
  end;
end;

var
  _GetUserObjectInformationW: Pointer;

function GetUserObjectInformationW;
begin
  GetProcedureAddress(_GetUserObjectInformationW, user32, 'GetUserObjectInformationW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetUserObjectInformationW]
  end;
end;

var
  _GetUserObjectInformation: Pointer;

function GetUserObjectInformation;
begin
  GetProcedureAddress(_GetUserObjectInformation, user32, 'GetUserObjectInformation' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetUserObjectInformation]
  end;
end;

var
  _SetUserObjectInformationA: Pointer;

function SetUserObjectInformationA;
begin
  GetProcedureAddress(_SetUserObjectInformationA, user32, 'SetUserObjectInformationA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetUserObjectInformationA]
  end;
end;

var
  _SetUserObjectInformationW: Pointer;

function SetUserObjectInformationW;
begin
  GetProcedureAddress(_SetUserObjectInformationW, user32, 'SetUserObjectInformationW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetUserObjectInformationW]
  end;
end;

var
  _SetUserObjectInformation: Pointer;

function SetUserObjectInformation;
begin
  GetProcedureAddress(_SetUserObjectInformation, user32, 'SetUserObjectInformation' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetUserObjectInformation]
  end;
end;

var
  _RegisterWindowMessageA: Pointer;

function RegisterWindowMessageA;
begin
  GetProcedureAddress(_RegisterWindowMessageA, user32, 'RegisterWindowMessageA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterWindowMessageA]
  end;
end;

var
  _RegisterWindowMessageW: Pointer;

function RegisterWindowMessageW;
begin
  GetProcedureAddress(_RegisterWindowMessageW, user32, 'RegisterWindowMessageW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterWindowMessageW]
  end;
end;

var
  _RegisterWindowMessage: Pointer;

function RegisterWindowMessage;
begin
  GetProcedureAddress(_RegisterWindowMessage, user32, 'RegisterWindowMessage' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterWindowMessage]
  end;
end;

var
  __TrackMouseEvent: Pointer;

function TrackMouseEvent;
begin
  GetProcedureAddress(__TrackMouseEvent, user32, 'TrackMouseEvent');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [__TrackMouseEvent]
  end;
end;

var
  _DrawEdge: Pointer;

function DrawEdge;
begin
  GetProcedureAddress(_DrawEdge, user32, 'DrawEdge');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawEdge]
  end;
end;

var
  _DrawFrameControl: Pointer;

function DrawFrameControl;
begin
  GetProcedureAddress(_DrawFrameControl, user32, 'DrawFrameControl');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawFrameControl]
  end;
end;

var
  _DrawCaption: Pointer;

function DrawCaption;
begin
  GetProcedureAddress(_DrawCaption, user32, 'DrawCaption');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawCaption]
  end;
end;

var
  _DrawAnimatedRects: Pointer;

function DrawAnimatedRects;
begin
  GetProcedureAddress(_DrawAnimatedRects, user32, 'DrawAnimatedRects');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawAnimatedRects]
  end;
end;

var
  _GetMessageA: Pointer;

function GetMessageA;
begin
  GetProcedureAddress(_GetMessageA, user32, 'GetMessageA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMessageA]
  end;
end;

var
  _GetMessageW: Pointer;

function GetMessageW;
begin
  GetProcedureAddress(_GetMessageW, user32, 'GetMessageW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMessageW]
  end;
end;

var
  _GetMessage: Pointer;

function GetMessage;
begin
  GetProcedureAddress(_GetMessage, user32, 'GetMessage' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMessage]
  end;
end;

var
  _TranslateMessage: Pointer;

function TranslateMessage;
begin
  GetProcedureAddress(_TranslateMessage, user32, 'TranslateMessage');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_TranslateMessage]
  end;
end;

var
  _DispatchMessageA: Pointer;

function DispatchMessageA;
begin
  GetProcedureAddress(_DispatchMessageA, user32, 'DispatchMessageA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DispatchMessageA]
  end;
end;

var
  _DispatchMessageW: Pointer;

function DispatchMessageW;
begin
  GetProcedureAddress(_DispatchMessageW, user32, 'DispatchMessageW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DispatchMessageW]
  end;
end;

var
  _DispatchMessage: Pointer;

function DispatchMessage;
begin
  GetProcedureAddress(_DispatchMessage, user32, 'DispatchMessage' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DispatchMessage]
  end;
end;

var
  _SetMessageQueue: Pointer;

function SetMessageQueue;
begin
  GetProcedureAddress(_SetMessageQueue, user32, 'SetMessageQueue');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetMessageQueue]
  end;
end;

var
  _PeekMessageA: Pointer;

function PeekMessageA;
begin
  GetProcedureAddress(_PeekMessageA, user32, 'PeekMessageA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PeekMessageA]
  end;
end;

var
  _PeekMessageW: Pointer;

function PeekMessageW;
begin
  GetProcedureAddress(_PeekMessageW, user32, 'PeekMessageW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PeekMessageW]
  end;
end;

var
  _PeekMessage: Pointer;

function PeekMessage;
begin
  GetProcedureAddress(_PeekMessage, user32, 'PeekMessage' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PeekMessage]
  end;
end;

var
  _RegisterHotKey: Pointer;

function RegisterHotKey;
begin
  GetProcedureAddress(_RegisterHotKey, user32, 'RegisterHotKey');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterHotKey]
  end;
end;

var
  _UnregisterHotKey: Pointer;

function UnregisterHotKey;
begin
  GetProcedureAddress(_UnregisterHotKey, user32, 'UnregisterHotKey');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_UnregisterHotKey]
  end;
end;

var
  _ExitWindowsEx: Pointer;

function ExitWindowsEx;
begin
  GetProcedureAddress(_ExitWindowsEx, user32, 'ExitWindowsEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ExitWindowsEx]
  end;
end;

var
  _SwapMouseButton: Pointer;

function SwapMouseButton;
begin
  GetProcedureAddress(_SwapMouseButton, user32, 'SwapMouseButton');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SwapMouseButton]
  end;
end;

var
  _GetMessagePos: Pointer;

function GetMessagePos;
begin
  GetProcedureAddress(_GetMessagePos, user32, 'GetMessagePos');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMessagePos]
  end;
end;

var
  _GetMessageTime: Pointer;

function GetMessageTime;
begin
  GetProcedureAddress(_GetMessageTime, user32, 'GetMessageTime');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMessageTime]
  end;
end;

var
  _GetMessageExtraInfo: Pointer;

function GetMessageExtraInfo;
begin
  GetProcedureAddress(_GetMessageExtraInfo, user32, 'GetMessageExtraInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMessageExtraInfo]
  end;
end;

var
  _SetMessageExtraInfo: Pointer;

function SetMessageExtraInfo;
begin
  GetProcedureAddress(_SetMessageExtraInfo, user32, 'SetMessageExtraInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetMessageExtraInfo]
  end;
end;

var
  _SendMessageA: Pointer;

function SendMessageA;
begin
  GetProcedureAddress(_SendMessageA, user32, 'SendMessageA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendMessageA]
  end;
end;

var
  _SendMessageW: Pointer;

function SendMessageW;
begin
  GetProcedureAddress(_SendMessageW, user32, 'SendMessageW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendMessageW]
  end;
end;

var
  _SendMessage: Pointer;

function SendMessage;
begin
  GetProcedureAddress(_SendMessage, user32, 'SendMessage' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendMessage]
  end;
end;

var
  _SendMessageTimeoutA: Pointer;

function SendMessageTimeoutA;
begin
  GetProcedureAddress(_SendMessageTimeoutA, user32, 'SendMessageTimeoutA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendMessageTimeoutA]
  end;
end;

var
  _SendMessageTimeoutW: Pointer;

function SendMessageTimeoutW;
begin
  GetProcedureAddress(_SendMessageTimeoutW, user32, 'SendMessageTimeoutW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendMessageTimeoutW]
  end;
end;

var
  _SendMessageTimeout: Pointer;

function SendMessageTimeout;
begin
  GetProcedureAddress(_SendMessageTimeout, user32, 'SendMessageTimeout' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendMessageTimeout]
  end;
end;

var
  _SendNotifyMessageA: Pointer;

function SendNotifyMessageA;
begin
  GetProcedureAddress(_SendNotifyMessageA, user32, 'SendNotifyMessageA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendNotifyMessageA]
  end;
end;

var
  _SendNotifyMessageW: Pointer;

function SendNotifyMessageW;
begin
  GetProcedureAddress(_SendNotifyMessageW, user32, 'SendNotifyMessageW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendNotifyMessageW]
  end;
end;

var
  _SendNotifyMessage: Pointer;

function SendNotifyMessage;
begin
  GetProcedureAddress(_SendNotifyMessage, user32, 'SendNotifyMessage' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendNotifyMessage]
  end;
end;

var
  _SendMessageCallbackA: Pointer;

function SendMessageCallbackA;
begin
  GetProcedureAddress(_SendMessageCallbackA, user32, 'SendMessageCallbackA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendMessageCallbackA]
  end;
end;

var
  _SendMessageCallbackW: Pointer;

function SendMessageCallbackW;
begin
  GetProcedureAddress(_SendMessageCallbackW, user32, 'SendMessageCallbackW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendMessageCallbackW]
  end;
end;

var
  _SendMessageCallback: Pointer;

function SendMessageCallback;
begin
  GetProcedureAddress(_SendMessageCallback, user32, 'SendMessageCallback' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendMessageCallback]
  end;
end;

var
  _BroadcastSystemMessageExA: Pointer;

function BroadcastSystemMessageExA;
begin
  GetProcedureAddress(_BroadcastSystemMessageExA, user32, 'BroadcastSystemMessageExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_BroadcastSystemMessageExA]
  end;
end;

var
  _BroadcastSystemMessageExW: Pointer;

function BroadcastSystemMessageExW;
begin
  GetProcedureAddress(_BroadcastSystemMessageExW, user32, 'BroadcastSystemMessageExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_BroadcastSystemMessageExW]
  end;
end;

var
  _BroadcastSystemMessageEx: Pointer;

function BroadcastSystemMessageEx;
begin
  GetProcedureAddress(_BroadcastSystemMessageEx, user32, 'BroadcastSystemMessageEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_BroadcastSystemMessageEx]
  end;
end;

var
  _BroadcastSystemMessageA: Pointer;

function BroadcastSystemMessageA;
begin
  GetProcedureAddress(_BroadcastSystemMessageA, user32, 'BroadcastSystemMessageA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_BroadcastSystemMessageA]
  end;
end;

var
  _BroadcastSystemMessageW: Pointer;

function BroadcastSystemMessageW;
begin
  GetProcedureAddress(_BroadcastSystemMessageW, user32, 'BroadcastSystemMessageW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_BroadcastSystemMessageW]
  end;
end;

var
  _BroadcastSystemMessage: Pointer;

function BroadcastSystemMessage;
begin
  GetProcedureAddress(_BroadcastSystemMessage, user32, 'BroadcastSystemMessage' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_BroadcastSystemMessage]
  end;
end;

var
  _RegisterDeviceNotificationA: Pointer;

function RegisterDeviceNotificationA;
begin
  GetProcedureAddress(_RegisterDeviceNotificationA, user32, 'RegisterDeviceNotificationA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterDeviceNotificationA]
  end;
end;

var
  _RegisterDeviceNotificationW: Pointer;

function RegisterDeviceNotificationW;
begin
  GetProcedureAddress(_RegisterDeviceNotificationW, user32, 'RegisterDeviceNotificationW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterDeviceNotificationW]
  end;
end;

var
  _RegisterDeviceNotification: Pointer;

function RegisterDeviceNotification;
begin
  GetProcedureAddress(_RegisterDeviceNotification, user32, 'RegisterDeviceNotification' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterDeviceNotification]
  end;
end;

var
  _UnregisterDeviceNotification: Pointer;

function UnregisterDeviceNotification;
begin
  GetProcedureAddress(_UnregisterDeviceNotification, user32, 'UnregisterDeviceNotification');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_UnregisterDeviceNotification]
  end;
end;

var
  _PostMessageA: Pointer;

function PostMessageA;
begin
  GetProcedureAddress(_PostMessageA, user32, 'PostMessageA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PostMessageA]
  end;
end;

var
  _PostMessageW: Pointer;

function PostMessageW;
begin
  GetProcedureAddress(_PostMessageW, user32, 'PostMessageW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PostMessageW]
  end;
end;

var
  _PostMessage: Pointer;

function PostMessage;
begin
  GetProcedureAddress(_PostMessage, user32, 'PostMessage' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PostMessage]
  end;
end;

var
  _PostThreadMessageA: Pointer;

function PostThreadMessageA;
begin
  GetProcedureAddress(_PostThreadMessageA, user32, 'PostThreadMessageA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PostThreadMessageA]
  end;
end;

var
  _PostThreadMessageW: Pointer;

function PostThreadMessageW;
begin
  GetProcedureAddress(_PostThreadMessageW, user32, 'PostThreadMessageW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PostThreadMessageW]
  end;
end;

var
  _PostThreadMessage: Pointer;

function PostThreadMessage;
begin
  GetProcedureAddress(_PostThreadMessage, user32, 'PostThreadMessage' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PostThreadMessage]
  end;
end;

var
  _AttachThreadInput: Pointer;

function AttachThreadInput;
begin
  GetProcedureAddress(_AttachThreadInput, user32, 'AttachThreadInput');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_AttachThreadInput]
  end;
end;

var
  _ReplyMessage: Pointer;

function ReplyMessage;
begin
  GetProcedureAddress(_ReplyMessage, user32, 'ReplyMessage');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ReplyMessage]
  end;
end;

var
  _WaitMessage: Pointer;

function WaitMessage;
begin
  GetProcedureAddress(_WaitMessage, user32, 'WaitMessage');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_WaitMessage]
  end;
end;

var
  _WaitForInputIdle: Pointer;

function WaitForInputIdle;
begin
  GetProcedureAddress(_WaitForInputIdle, user32, 'WaitForInputIdle');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_WaitForInputIdle]
  end;
end;

var
  _DefWindowProcA: Pointer;

function DefWindowProcA;
begin
  GetProcedureAddress(_DefWindowProcA, user32, 'DefWindowProcA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DefWindowProcA]
  end;
end;

var
  _DefWindowProcW: Pointer;

function DefWindowProcW;
begin
  GetProcedureAddress(_DefWindowProcW, user32, 'DefWindowProcW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DefWindowProcW]
  end;
end;

var
  _DefWindowProc: Pointer;

function DefWindowProc;
begin
  GetProcedureAddress(_DefWindowProc, user32, 'DefWindowProc' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DefWindowProc]
  end;
end;

var
  _PostQuitMessage: Pointer;

procedure PostQuitMessage;
begin
  GetProcedureAddress(_PostQuitMessage, user32, 'PostQuitMessage');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PostQuitMessage]
  end;
end;

var
  _CallWindowProcA: Pointer;

function CallWindowProcA;
begin
  GetProcedureAddress(_CallWindowProcA, user32, 'CallWindowProcA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CallWindowProcA]
  end;
end;

var
  _CallWindowProcW: Pointer;

function CallWindowProcW;
begin
  GetProcedureAddress(_CallWindowProcW, user32, 'CallWindowProcW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CallWindowProcW]
  end;
end;

var
  _CallWindowProc: Pointer;

function CallWindowProc;
begin
  GetProcedureAddress(_CallWindowProc, user32, 'CallWindowProc' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CallWindowProc]
  end;
end;

var
  _InSendMessage: Pointer;

function InSendMessage;
begin
  GetProcedureAddress(_InSendMessage, user32, 'InSendMessage');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_InSendMessage]
  end;
end;

var
  _InSendMessageEx: Pointer;

function InSendMessageEx;
begin
  GetProcedureAddress(_InSendMessageEx, user32, 'InSendMessageEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_InSendMessageEx]
  end;
end;

var
  _GetDoubleClickTime: Pointer;

function GetDoubleClickTime;
begin
  GetProcedureAddress(_GetDoubleClickTime, user32, 'GetDoubleClickTime');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetDoubleClickTime]
  end;
end;

var
  _SetDoubleClickTime: Pointer;

function SetDoubleClickTime;
begin
  GetProcedureAddress(_SetDoubleClickTime, user32, 'SetDoubleClickTime');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetDoubleClickTime]
  end;
end;

var
  _RegisterClassA: Pointer;

function RegisterClassA;
begin
  GetProcedureAddress(_RegisterClassA, user32, 'RegisterClassA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterClassA]
  end;
end;

var
  _RegisterClassW: Pointer;

function RegisterClassW;
begin
  GetProcedureAddress(_RegisterClassW, user32, 'RegisterClassW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterClassW]
  end;
end;

var
  _RegisterClass: Pointer;

function RegisterClass;
begin
  GetProcedureAddress(_RegisterClass, user32, 'RegisterClass' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterClass]
  end;
end;

var
  _UnregisterClassA: Pointer;

function UnregisterClassA;
begin
  GetProcedureAddress(_UnregisterClassA, user32, 'UnregisterClassA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_UnregisterClassA]
  end;
end;

var
  _UnregisterClassW: Pointer;

function UnregisterClassW;
begin
  GetProcedureAddress(_UnregisterClassW, user32, 'UnregisterClassW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_UnregisterClassW]
  end;
end;

var
  _UnregisterClass: Pointer;

function UnregisterClass;
begin
  GetProcedureAddress(_UnregisterClass, user32, 'UnregisterClass' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_UnregisterClass]
  end;
end;

var
  _GetClassInfoA: Pointer;

function GetClassInfoA;
begin
  GetProcedureAddress(_GetClassInfoA, user32, 'GetClassInfoA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClassInfoA]
  end;
end;

var
  _GetClassInfoW: Pointer;

function GetClassInfoW;
begin
  GetProcedureAddress(_GetClassInfoW, user32, 'GetClassInfoW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClassInfoW]
  end;
end;

var
  _GetClassInfo: Pointer;

function GetClassInfo;
begin
  GetProcedureAddress(_GetClassInfo, user32, 'GetClassInfo' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClassInfo]
  end;
end;

var
  _RegisterClassExA: Pointer;

function RegisterClassExA;
begin
  GetProcedureAddress(_RegisterClassExA, user32, 'RegisterClassExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterClassExA]
  end;
end;

var
  _RegisterClassExW: Pointer;

function RegisterClassExW;
begin
  GetProcedureAddress(_RegisterClassExW, user32, 'RegisterClassExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterClassExW]
  end;
end;

var
  _RegisterClassEx: Pointer;

function RegisterClassEx;
begin
  GetProcedureAddress(_RegisterClassEx, user32, 'RegisterClassEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterClassEx]
  end;
end;

var
  _GetClassInfoExA: Pointer;

function GetClassInfoExA;
begin
  GetProcedureAddress(_GetClassInfoExA, user32, 'GetClassInfoExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClassInfoExA]
  end;
end;

var
  _GetClassInfoExW: Pointer;

function GetClassInfoExW;
begin
  GetProcedureAddress(_GetClassInfoExW, user32, 'GetClassInfoExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClassInfoExW]
  end;
end;

var
  _GetClassInfoEx: Pointer;

function GetClassInfoEx;
begin
  GetProcedureAddress(_GetClassInfoEx, user32, 'GetClassInfoEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClassInfoEx]
  end;
end;

var
  _CreateWindowExA: Pointer;

function CreateWindowExA;
begin
  GetProcedureAddress(_CreateWindowExA, user32, 'CreateWindowExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateWindowExA]
  end;
end;

var
  _CreateWindowExW: Pointer;

function CreateWindowExW;
begin
  GetProcedureAddress(_CreateWindowExW, user32, 'CreateWindowExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateWindowExW]
  end;
end;

var
  _CreateWindowEx: Pointer;

function CreateWindowEx;
begin
  GetProcedureAddress(_CreateWindowEx, user32, 'CreateWindowEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateWindowEx]
  end;
end;

var
  _IsWindow: Pointer;

function IsWindow;
begin
  GetProcedureAddress(_IsWindow, user32, 'IsWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsWindow]
  end;
end;

var
  _IsMenu: Pointer;

function IsMenu;
begin
  GetProcedureAddress(_IsMenu, user32, 'IsMenu');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsMenu]
  end;
end;

var
  _IsChild: Pointer;

function IsChild;
begin
  GetProcedureAddress(_IsChild, user32, 'IsChild');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsChild]
  end;
end;

var
  _DestroyWindow: Pointer;

function DestroyWindow;
begin
  GetProcedureAddress(_DestroyWindow, user32, 'DestroyWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DestroyWindow]
  end;
end;

var
  _ShowWindow: Pointer;

function ShowWindow;
begin
  GetProcedureAddress(_ShowWindow, user32, 'ShowWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ShowWindow]
  end;
end;

var
  _AnimateWindow: Pointer;

function AnimateWindow;
begin
  GetProcedureAddress(_AnimateWindow, user32, 'AnimateWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_AnimateWindow]
  end;
end;

var
  _UpdateLayeredWindow: Pointer;

function UpdateLayeredWindow;
begin
  GetProcedureAddress(_UpdateLayeredWindow, user32, 'UpdateLayeredWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_UpdateLayeredWindow]
  end;
end;

var
  _GetLayeredWindowAttributes: Pointer;

function GetLayeredWindowAttributes;
begin
  GetProcedureAddress(_GetLayeredWindowAttributes, user32, 'GetLayeredWindowAttributes');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetLayeredWindowAttributes]
  end;
end;

var
  _PrintWindow: Pointer;

function PrintWindow;
begin
  GetProcedureAddress(_PrintWindow, user32, 'PrintWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PrintWindow]
  end;
end;

var
  _SetLayeredWindowAttributes: Pointer;

function SetLayeredWindowAttributes;
begin
  GetProcedureAddress(_SetLayeredWindowAttributes, user32, 'SetLayeredWindowAttributes');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetLayeredWindowAttributes]
  end;
end;

var
  _ShowWindowAsync: Pointer;

function ShowWindowAsync;
begin
  GetProcedureAddress(_ShowWindowAsync, user32, 'ShowWindowAsync');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ShowWindowAsync]
  end;
end;

var
  _FlashWindow: Pointer;

function FlashWindow;
begin
  GetProcedureAddress(_FlashWindow, user32, 'FlashWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_FlashWindow]
  end;
end;

var
  _FlashWindowEx: Pointer;

function FlashWindowEx;
begin
  GetProcedureAddress(_FlashWindowEx, user32, 'FlashWindowEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_FlashWindowEx]
  end;
end;

var
  _ShowOwnedPopups: Pointer;

function ShowOwnedPopups;
begin
  GetProcedureAddress(_ShowOwnedPopups, user32, 'ShowOwnedPopups');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ShowOwnedPopups]
  end;
end;

var
  _OpenIcon: Pointer;

function OpenIcon;
begin
  GetProcedureAddress(_OpenIcon, user32, 'OpenIcon');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OpenIcon]
  end;
end;

var
  _CloseWindow: Pointer;

function CloseWindow;
begin
  GetProcedureAddress(_CloseWindow, user32, 'CloseWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CloseWindow]
  end;
end;

var
  _MoveWindow: Pointer;

function MoveWindow;
begin
  GetProcedureAddress(_MoveWindow, user32, 'MoveWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MoveWindow]
  end;
end;

var
  _SetWindowPos: Pointer;

function SetWindowPos;
begin
  GetProcedureAddress(_SetWindowPos, user32, 'SetWindowPos');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowPos]
  end;
end;

var
  _GetWindowPlacement: Pointer;

function GetWindowPlacement;
begin
  GetProcedureAddress(_GetWindowPlacement, user32, 'GetWindowPlacement');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowPlacement]
  end;
end;

var
  _SetWindowPlacement: Pointer;

function SetWindowPlacement;
begin
  GetProcedureAddress(_SetWindowPlacement, user32, 'SetWindowPlacement');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowPlacement]
  end;
end;

var
  _BeginDeferWindowPos: Pointer;

function BeginDeferWindowPos;
begin
  GetProcedureAddress(_BeginDeferWindowPos, user32, 'BeginDeferWindowPos');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_BeginDeferWindowPos]
  end;
end;

var
  _DeferWindowPos: Pointer;

function DeferWindowPos;
begin
  GetProcedureAddress(_DeferWindowPos, user32, 'DeferWindowPos');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DeferWindowPos]
  end;
end;

var
  _EndDeferWindowPos: Pointer;

function EndDeferWindowPos;
begin
  GetProcedureAddress(_EndDeferWindowPos, user32, 'EndDeferWindowPos');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EndDeferWindowPos]
  end;
end;

var
  _IsWindowVisible: Pointer;

function IsWindowVisible;
begin
  GetProcedureAddress(_IsWindowVisible, user32, 'IsWindowVisible');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsWindowVisible]
  end;
end;

var
  _IsIconic: Pointer;

function IsIconic;
begin
  GetProcedureAddress(_IsIconic, user32, 'IsIconic');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsIconic]
  end;
end;

var
  _AnyPopup: Pointer;

function AnyPopup;
begin
  GetProcedureAddress(_AnyPopup, user32, 'AnyPopup');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_AnyPopup]
  end;
end;

var
  _BringWindowToTop: Pointer;

function BringWindowToTop;
begin
  GetProcedureAddress(_BringWindowToTop, user32, 'BringWindowToTop');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_BringWindowToTop]
  end;
end;

var
  _IsZoomed: Pointer;

function IsZoomed;
begin
  GetProcedureAddress(_IsZoomed, user32, 'IsZoomed');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsZoomed]
  end;
end;

var
  _CreateDialogParamA: Pointer;

function CreateDialogParamA;
begin
  GetProcedureAddress(_CreateDialogParamA, user32, 'CreateDialogParamA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateDialogParamA]
  end;
end;

var
  _CreateDialogParamW: Pointer;

function CreateDialogParamW;
begin
  GetProcedureAddress(_CreateDialogParamW, user32, 'CreateDialogParamW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateDialogParamW]
  end;
end;

var
  _CreateDialogParam: Pointer;

function CreateDialogParam;
begin
  GetProcedureAddress(_CreateDialogParam, user32, 'CreateDialogParam' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateDialogParam]
  end;
end;

var
  _CreateDialogIndirectParamA: Pointer;

function CreateDialogIndirectParamA;
begin
  GetProcedureAddress(_CreateDialogIndirectParamA, user32, 'CreateDialogIndirectParamA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateDialogIndirectParamA]
  end;
end;

var
  _CreateDialogIndirectParamW: Pointer;

function CreateDialogIndirectParamW;
begin
  GetProcedureAddress(_CreateDialogIndirectParamW, user32, 'CreateDialogIndirectParamW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateDialogIndirectParamW]
  end;
end;

var
  _CreateDialogIndirectParam: Pointer;

function CreateDialogIndirectParam;
begin
  GetProcedureAddress(_CreateDialogIndirectParam, user32, 'CreateDialogIndirectParam' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateDialogIndirectParam]
  end;
end;

var
  _DialogBoxParamA: Pointer;

function DialogBoxParamA;
begin
  GetProcedureAddress(_DialogBoxParamA, user32, 'DialogBoxParamA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DialogBoxParamA]
  end;
end;

var
  _DialogBoxParamW: Pointer;

function DialogBoxParamW;
begin
  GetProcedureAddress(_DialogBoxParamW, user32, 'DialogBoxParamW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DialogBoxParamW]
  end;
end;

var
  _DialogBoxParam: Pointer;

function DialogBoxParam;
begin
  GetProcedureAddress(_DialogBoxParam, user32, 'DialogBoxParam' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DialogBoxParam]
  end;
end;

var
  _DialogBoxIndirectParamA: Pointer;

function DialogBoxIndirectParamA;
begin
  GetProcedureAddress(_DialogBoxIndirectParamA, user32, 'DialogBoxIndirectParamA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DialogBoxIndirectParamA]
  end;
end;

var
  _DialogBoxIndirectParamW: Pointer;

function DialogBoxIndirectParamW;
begin
  GetProcedureAddress(_DialogBoxIndirectParamW, user32, 'DialogBoxIndirectParamW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DialogBoxIndirectParamW]
  end;
end;

var
  _DialogBoxIndirectParam: Pointer;

function DialogBoxIndirectParam;
begin
  GetProcedureAddress(_DialogBoxIndirectParam, user32, 'DialogBoxIndirectParam' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DialogBoxIndirectParam]
  end;
end;

var
  _EndDialog: Pointer;

function EndDialog;
begin
  GetProcedureAddress(_EndDialog, user32, 'EndDialog');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EndDialog]
  end;
end;

var
  _GetDlgItem: Pointer;

function GetDlgItem;
begin
  GetProcedureAddress(_GetDlgItem, user32, 'GetDlgItem');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetDlgItem]
  end;
end;

var
  _SetDlgItemInt: Pointer;

function SetDlgItemInt;
begin
  GetProcedureAddress(_SetDlgItemInt, user32, 'SetDlgItemInt');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetDlgItemInt]
  end;
end;

var
  _GetDlgItemInt: Pointer;

function GetDlgItemInt;
begin
  GetProcedureAddress(_GetDlgItemInt, user32, 'GetDlgItemInt');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetDlgItemInt]
  end;
end;

var
  _SetDlgItemTextA: Pointer;

function SetDlgItemTextA;
begin
  GetProcedureAddress(_SetDlgItemTextA, user32, 'SetDlgItemTextA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetDlgItemTextA]
  end;
end;

var
  _SetDlgItemTextW: Pointer;

function SetDlgItemTextW;
begin
  GetProcedureAddress(_SetDlgItemTextW, user32, 'SetDlgItemTextW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetDlgItemTextW]
  end;
end;

var
  _SetDlgItemText: Pointer;

function SetDlgItemText;
begin
  GetProcedureAddress(_SetDlgItemText, user32, 'SetDlgItemText' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetDlgItemText]
  end;
end;

var
  _GetDlgItemTextA: Pointer;

function GetDlgItemTextA;
begin
  GetProcedureAddress(_GetDlgItemTextA, user32, 'GetDlgItemTextA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetDlgItemTextA]
  end;
end;

var
  _GetDlgItemTextW: Pointer;

function GetDlgItemTextW;
begin
  GetProcedureAddress(_GetDlgItemTextW, user32, 'GetDlgItemTextW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetDlgItemTextW]
  end;
end;

var
  _GetDlgItemText: Pointer;

function GetDlgItemText;
begin
  GetProcedureAddress(_GetDlgItemText, user32, 'GetDlgItemText' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetDlgItemText]
  end;
end;

var
  _CheckDlgButton: Pointer;

function CheckDlgButton;
begin
  GetProcedureAddress(_CheckDlgButton, user32, 'CheckDlgButton');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CheckDlgButton]
  end;
end;

var
  _CheckRadioButton: Pointer;

function CheckRadioButton;
begin
  GetProcedureAddress(_CheckRadioButton, user32, 'CheckRadioButton');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CheckRadioButton]
  end;
end;

var
  _IsDlgButtonChecked: Pointer;

function IsDlgButtonChecked;
begin
  GetProcedureAddress(_IsDlgButtonChecked, user32, 'IsDlgButtonChecked');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsDlgButtonChecked]
  end;
end;

var
  _SendDlgItemMessageA: Pointer;

function SendDlgItemMessageA;
begin
  GetProcedureAddress(_SendDlgItemMessageA, user32, 'SendDlgItemMessageA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendDlgItemMessageA]
  end;
end;

var
  _SendDlgItemMessageW: Pointer;

function SendDlgItemMessageW;
begin
  GetProcedureAddress(_SendDlgItemMessageW, user32, 'SendDlgItemMessageW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendDlgItemMessageW]
  end;
end;

var
  _SendDlgItemMessage: Pointer;

function SendDlgItemMessage;
begin
  GetProcedureAddress(_SendDlgItemMessage, user32, 'SendDlgItemMessage' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendDlgItemMessage]
  end;
end;

var
  _GetNextDlgGroupItem: Pointer;

function GetNextDlgGroupItem;
begin
  GetProcedureAddress(_GetNextDlgGroupItem, user32, 'GetNextDlgGroupItem');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetNextDlgGroupItem]
  end;
end;

var
  _GetNextDlgTabItem: Pointer;

function GetNextDlgTabItem;
begin
  GetProcedureAddress(_GetNextDlgTabItem, user32, 'GetNextDlgTabItem');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetNextDlgTabItem]
  end;
end;

var
  _GetDlgCtrlID: Pointer;

function GetDlgCtrlID;
begin
  GetProcedureAddress(_GetDlgCtrlID, user32, 'GetDlgCtrlID');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetDlgCtrlID]
  end;
end;

var
  _GetDialogBaseUnits: Pointer;

function GetDialogBaseUnits;
begin
  GetProcedureAddress(_GetDialogBaseUnits, user32, 'GetDialogBaseUnits');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetDialogBaseUnits]
  end;
end;

var
  _DefDlgProcA: Pointer;

function DefDlgProcA;
begin
  GetProcedureAddress(_DefDlgProcA, user32, 'DefDlgProcA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DefDlgProcA]
  end;
end;

var
  _DefDlgProcW: Pointer;

function DefDlgProcW;
begin
  GetProcedureAddress(_DefDlgProcW, user32, 'DefDlgProcW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DefDlgProcW]
  end;
end;

var
  _DefDlgProc: Pointer;

function DefDlgProc;
begin
  GetProcedureAddress(_DefDlgProc, user32, 'DefDlgProc' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DefDlgProc]
  end;
end;

var
  _CallMsgFilterA: Pointer;

function CallMsgFilterA;
begin
  GetProcedureAddress(_CallMsgFilterA, user32, 'CallMsgFilterA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CallMsgFilterA]
  end;
end;

var
  _CallMsgFilterW: Pointer;

function CallMsgFilterW;
begin
  GetProcedureAddress(_CallMsgFilterW, user32, 'CallMsgFilterW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CallMsgFilterW]
  end;
end;

var
  _CallMsgFilter: Pointer;

function CallMsgFilter;
begin
  GetProcedureAddress(_CallMsgFilter, user32, 'CallMsgFilter' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CallMsgFilter]
  end;
end;

var
  _OpenClipboard: Pointer;

function OpenClipboard;
begin
  GetProcedureAddress(_OpenClipboard, user32, 'OpenClipboard');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OpenClipboard]
  end;
end;

var
  _CloseClipboard: Pointer;

function CloseClipboard;
begin
  GetProcedureAddress(_CloseClipboard, user32, 'CloseClipboard');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CloseClipboard]
  end;
end;

var
  _GetClipboardSequenceNumber: Pointer;

function GetClipboardSequenceNumber;
begin
  GetProcedureAddress(_GetClipboardSequenceNumber, user32, 'GetClipboardSequenceNumber');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClipboardSequenceNumber]
  end;
end;

var
  _GetClipboardOwner: Pointer;

function GetClipboardOwner;
begin
  GetProcedureAddress(_GetClipboardOwner, user32, 'GetClipboardOwner');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClipboardOwner]
  end;
end;

var
  _SetClipboardViewer: Pointer;

function SetClipboardViewer;
begin
  GetProcedureAddress(_SetClipboardViewer, user32, 'SetClipboardViewer');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetClipboardViewer]
  end;
end;

var
  _GetClipboardViewer: Pointer;

function GetClipboardViewer;
begin
  GetProcedureAddress(_GetClipboardViewer, user32, 'GetClipboardViewer');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClipboardViewer]
  end;
end;

var
  _ChangeClipboardChain: Pointer;

function ChangeClipboardChain;
begin
  GetProcedureAddress(_ChangeClipboardChain, user32, 'ChangeClipboardChain');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ChangeClipboardChain]
  end;
end;

var
  _SetClipboardData: Pointer;

function SetClipboardData;
begin
  GetProcedureAddress(_SetClipboardData, user32, 'SetClipboardData');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetClipboardData]
  end;
end;

var
  _GetClipboardData: Pointer;

function GetClipboardData;
begin
  GetProcedureAddress(_GetClipboardData, user32, 'GetClipboardData');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClipboardData]
  end;
end;

var
  _RegisterClipboardFormatA: Pointer;

function RegisterClipboardFormatA;
begin
  GetProcedureAddress(_RegisterClipboardFormatA, user32, 'RegisterClipboardFormatA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterClipboardFormatA]
  end;
end;

var
  _RegisterClipboardFormatW: Pointer;

function RegisterClipboardFormatW;
begin
  GetProcedureAddress(_RegisterClipboardFormatW, user32, 'RegisterClipboardFormatW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterClipboardFormatW]
  end;
end;

var
  _RegisterClipboardFormat: Pointer;

function RegisterClipboardFormat;
begin
  GetProcedureAddress(_RegisterClipboardFormat, user32, 'RegisterClipboardFormat' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterClipboardFormat]
  end;
end;

var
  _CountClipboardFormats: Pointer;

function CountClipboardFormats;
begin
  GetProcedureAddress(_CountClipboardFormats, user32, 'CountClipboardFormats');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CountClipboardFormats]
  end;
end;

var
  _EnumClipboardFormats: Pointer;

function EnumClipboardFormats;
begin
  GetProcedureAddress(_EnumClipboardFormats, user32, 'EnumClipboardFormats');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumClipboardFormats]
  end;
end;

var
  _GetClipboardFormatNameA: Pointer;

function GetClipboardFormatNameA;
begin
  GetProcedureAddress(_GetClipboardFormatNameA, user32, 'GetClipboardFormatNameA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClipboardFormatNameA]
  end;
end;

var
  _GetClipboardFormatNameW: Pointer;

function GetClipboardFormatNameW;
begin
  GetProcedureAddress(_GetClipboardFormatNameW, user32, 'GetClipboardFormatNameW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClipboardFormatNameW]
  end;
end;

var
  _GetClipboardFormatName: Pointer;

function GetClipboardFormatName;
begin
  GetProcedureAddress(_GetClipboardFormatName, user32, 'GetClipboardFormatName' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClipboardFormatName]
  end;
end;

var
  _EmptyClipboard: Pointer;

function EmptyClipboard;
begin
  GetProcedureAddress(_EmptyClipboard, user32, 'EmptyClipboard');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EmptyClipboard]
  end;
end;

var
  _IsClipboardFormatAvailable: Pointer;

function IsClipboardFormatAvailable;
begin
  GetProcedureAddress(_IsClipboardFormatAvailable, user32, 'IsClipboardFormatAvailable');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsClipboardFormatAvailable]
  end;
end;

var
  _GetPriorityClipboardFormat: Pointer;

function GetPriorityClipboardFormat;
begin
  GetProcedureAddress(_GetPriorityClipboardFormat, user32, 'GetPriorityClipboardFormat');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetPriorityClipboardFormat]
  end;
end;

var
  _GetOpenClipboardWindow: Pointer;

function GetOpenClipboardWindow;
begin
  GetProcedureAddress(_GetOpenClipboardWindow, user32, 'GetOpenClipboardWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetOpenClipboardWindow]
  end;
end;

var
  _CharToOemA: Pointer;

function CharToOemA;
begin
  GetProcedureAddress(_CharToOemA, user32, 'CharToOemA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharToOemA]
  end;
end;

var
  _CharToOemW: Pointer;

function CharToOemW;
begin
  GetProcedureAddress(_CharToOemW, user32, 'CharToOemW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharToOemW]
  end;
end;

var
  _CharToOem: Pointer;

function CharToOem;
begin
  GetProcedureAddress(_CharToOem, user32, 'CharToOem' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharToOem]
  end;
end;

var
  _OemToCharA: Pointer;

function OemToCharA;
begin
  GetProcedureAddress(_OemToCharA, user32, 'OemToCharA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OemToCharA]
  end;
end;

var
  _OemToCharW: Pointer;

function OemToCharW;
begin
  GetProcedureAddress(_OemToCharW, user32, 'OemToCharW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OemToCharW]
  end;
end;

var
  _OemToChar: Pointer;

function OemToChar;
begin
  GetProcedureAddress(_OemToChar, user32, 'OemToChar' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OemToChar]
  end;
end;

var
  _CharToOemBuffA: Pointer;

function CharToOemBuffA;
begin
  GetProcedureAddress(_CharToOemBuffA, user32, 'CharToOemBuffA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharToOemBuffA]
  end;
end;

var
  _CharToOemBuffW: Pointer;

function CharToOemBuffW;
begin
  GetProcedureAddress(_CharToOemBuffW, user32, 'CharToOemBuffW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharToOemBuffW]
  end;
end;

var
  _CharToOemBuff: Pointer;

function CharToOemBuff;
begin
  GetProcedureAddress(_CharToOemBuff, user32, 'CharToOemBuff' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharToOemBuff]
  end;
end;

var
  _OemToCharBuffA: Pointer;

function OemToCharBuffA;
begin
  GetProcedureAddress(_OemToCharBuffA, user32, 'OemToCharBuffA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OemToCharBuffA]
  end;
end;

var
  _OemToCharBuffW: Pointer;

function OemToCharBuffW;
begin
  GetProcedureAddress(_OemToCharBuffW, user32, 'OemToCharBuffW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OemToCharBuffW]
  end;
end;

var
  _OemToCharBuff: Pointer;

function OemToCharBuff;
begin
  GetProcedureAddress(_OemToCharBuff, user32, 'OemToCharBuff' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OemToCharBuff]
  end;
end;

var
  _CharUpperA: Pointer;

function CharUpperA;
begin
  GetProcedureAddress(_CharUpperA, user32, 'CharUpperA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharUpperA]
  end;
end;

var
  _CharUpperW: Pointer;

function CharUpperW;
begin
  GetProcedureAddress(_CharUpperW, user32, 'CharUpperW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharUpperW]
  end;
end;

var
  _CharUpper: Pointer;

function CharUpper;
begin
  GetProcedureAddress(_CharUpper, user32, 'CharUpper' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharUpper]
  end;
end;

var
  _CharUpperBuffA: Pointer;

function CharUpperBuffA;
begin
  GetProcedureAddress(_CharUpperBuffA, user32, 'CharUpperBuffA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharUpperBuffA]
  end;
end;

var
  _CharUpperBuffW: Pointer;

function CharUpperBuffW;
begin
  GetProcedureAddress(_CharUpperBuffW, user32, 'CharUpperBuffW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharUpperBuffW]
  end;
end;

var
  _CharUpperBuff: Pointer;

function CharUpperBuff;
begin
  GetProcedureAddress(_CharUpperBuff, user32, 'CharUpperBuff' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharUpperBuff]
  end;
end;

var
  _CharLowerA: Pointer;

function CharLowerA;
begin
  GetProcedureAddress(_CharLowerA, user32, 'CharLowerA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharLowerA]
  end;
end;

var
  _CharLowerW: Pointer;

function CharLowerW;
begin
  GetProcedureAddress(_CharLowerW, user32, 'CharLowerW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharLowerW]
  end;
end;

var
  _CharLower: Pointer;

function CharLower;
begin
  GetProcedureAddress(_CharLower, user32, 'CharLower' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharLower]
  end;
end;

var
  _CharLowerBuffA: Pointer;

function CharLowerBuffA;
begin
  GetProcedureAddress(_CharLowerBuffA, user32, 'CharLowerBuffA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharLowerBuffA]
  end;
end;

var
  _CharLowerBuffW: Pointer;

function CharLowerBuffW;
begin
  GetProcedureAddress(_CharLowerBuffW, user32, 'CharLowerBuffW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharLowerBuffW]
  end;
end;

var
  _CharLowerBuff: Pointer;

function CharLowerBuff;
begin
  GetProcedureAddress(_CharLowerBuff, user32, 'CharLowerBuff' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharLowerBuff]
  end;
end;

var
  _CharNextA: Pointer;

function CharNextA;
begin
  GetProcedureAddress(_CharNextA, user32, 'CharNextA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharNextA]
  end;
end;

var
  _CharNextW: Pointer;

function CharNextW;
begin
  GetProcedureAddress(_CharNextW, user32, 'CharNextW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharNextW]
  end;
end;

var
  _CharNext: Pointer;

function CharNext;
begin
  GetProcedureAddress(_CharNext, user32, 'CharNext' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharNext]
  end;
end;

var
  _CharPrevA: Pointer;

function CharPrevA;
begin
  GetProcedureAddress(_CharPrevA, user32, 'CharPrevA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharPrevA]
  end;
end;

var
  _CharPrevW: Pointer;

function CharPrevW;
begin
  GetProcedureAddress(_CharPrevW, user32, 'CharPrevW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharPrevW]
  end;
end;

var
  _CharPrev: Pointer;

function CharPrev;
begin
  GetProcedureAddress(_CharPrev, user32, 'CharPrev' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharPrev]
  end;
end;

var
  _CharNextExA: Pointer;

function CharNextExA;
begin
  GetProcedureAddress(_CharNextExA, user32, 'CharNextExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharNextExA]
  end;
end;

var
  _CharPrevExA: Pointer;

function CharPrevExA;
begin
  GetProcedureAddress(_CharPrevExA, user32, 'CharPrevExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CharPrevExA]
  end;
end;

var
  _IsCharAlphaA: Pointer;

function IsCharAlphaA;
begin
  GetProcedureAddress(_IsCharAlphaA, user32, 'IsCharAlphaA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsCharAlphaA]
  end;
end;

var
  _IsCharAlphaW: Pointer;

function IsCharAlphaW;
begin
  GetProcedureAddress(_IsCharAlphaW, user32, 'IsCharAlphaW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsCharAlphaW]
  end;
end;

var
  _IsCharAlpha: Pointer;

function IsCharAlpha;
begin
  GetProcedureAddress(_IsCharAlpha, user32, 'IsCharAlpha' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsCharAlpha]
  end;
end;

var
  _IsCharAlphaNumericA: Pointer;

function IsCharAlphaNumericA;
begin
  GetProcedureAddress(_IsCharAlphaNumericA, user32, 'IsCharAlphaNumericA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsCharAlphaNumericA]
  end;
end;

var
  _IsCharAlphaNumericW: Pointer;

function IsCharAlphaNumericW;
begin
  GetProcedureAddress(_IsCharAlphaNumericW, user32, 'IsCharAlphaNumericW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsCharAlphaNumericW]
  end;
end;

var
  _IsCharAlphaNumeric: Pointer;

function IsCharAlphaNumeric;
begin
  GetProcedureAddress(_IsCharAlphaNumeric, user32, 'IsCharAlphaNumeric' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsCharAlphaNumeric]
  end;
end;

var
  _IsCharUpperA: Pointer;

function IsCharUpperA;
begin
  GetProcedureAddress(_IsCharUpperA, user32, 'IsCharUpperA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsCharUpperA]
  end;
end;

var
  _IsCharUpperW: Pointer;

function IsCharUpperW;
begin
  GetProcedureAddress(_IsCharUpperW, user32, 'IsCharUpperW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsCharUpperW]
  end;
end;

var
  _IsCharUpper: Pointer;

function IsCharUpper;
begin
  GetProcedureAddress(_IsCharUpper, user32, 'IsCharUpper' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsCharUpper]
  end;
end;

var
  _IsCharLowerA: Pointer;

function IsCharLowerA;
begin
  GetProcedureAddress(_IsCharLowerA, user32, 'IsCharLowerA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsCharLowerA]
  end;
end;

var
  _IsCharLowerW: Pointer;

function IsCharLowerW;
begin
  GetProcedureAddress(_IsCharLowerW, user32, 'IsCharLowerW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsCharLowerW]
  end;
end;

var
  _IsCharLower: Pointer;

function IsCharLower;
begin
  GetProcedureAddress(_IsCharLower, user32, 'IsCharLower' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsCharLower]
  end;
end;

var
  _SetFocus: Pointer;

function SetFocus;
begin
  GetProcedureAddress(_SetFocus, user32, 'SetFocus');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetFocus]
  end;
end;

var
  _GetActiveWindow: Pointer;

function GetActiveWindow;
begin
  GetProcedureAddress(_GetActiveWindow, user32, 'GetActiveWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetActiveWindow]
  end;
end;

var
  _GetFocus: Pointer;

function GetFocus;
begin
  GetProcedureAddress(_GetFocus, user32, 'GetFocus');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetFocus]
  end;
end;

var
  _GetKBCodePage: Pointer;

function GetKBCodePage;
begin
  GetProcedureAddress(_GetKBCodePage, user32, 'GetKBCodePage');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetKBCodePage]
  end;
end;

var
  _GetKeyState: Pointer;

function GetKeyState;
begin
  GetProcedureAddress(_GetKeyState, user32, 'GetKeyState');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetKeyState]
  end;
end;

var
  _GetAsyncKeyState: Pointer;

function GetAsyncKeyState;
begin
  GetProcedureAddress(_GetAsyncKeyState, user32, 'GetAsyncKeyState');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetAsyncKeyState]
  end;
end;

var
  _GetKeyboardState: Pointer;

function GetKeyboardState;
begin
  GetProcedureAddress(_GetKeyboardState, user32, 'GetKeyboardState');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetKeyboardState]
  end;
end;

var
  _SetKeyboardState: Pointer;

function SetKeyboardState;
begin
  GetProcedureAddress(_SetKeyboardState, user32, 'SetKeyboardState');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetKeyboardState]
  end;
end;

var
  _GetKeyNameTextA: Pointer;

function GetKeyNameTextA;
begin
  GetProcedureAddress(_GetKeyNameTextA, user32, 'GetKeyNameTextA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetKeyNameTextA]
  end;
end;

var
  _GetKeyNameTextW: Pointer;

function GetKeyNameTextW;
begin
  GetProcedureAddress(_GetKeyNameTextW, user32, 'GetKeyNameTextW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetKeyNameTextW]
  end;
end;

var
  _GetKeyNameText: Pointer;

function GetKeyNameText;
begin
  GetProcedureAddress(_GetKeyNameText, user32, 'GetKeyNameText' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetKeyNameText]
  end;
end;

var
  _GetKeyboardType: Pointer;

function GetKeyboardType;
begin
  GetProcedureAddress(_GetKeyboardType, user32, 'GetKeyboardType');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetKeyboardType]
  end;
end;

var
  _ToAscii: Pointer;

function ToAscii;
begin
  GetProcedureAddress(_ToAscii, user32, 'ToAscii');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ToAscii]
  end;
end;

var
  _ToAsciiEx: Pointer;

function ToAsciiEx;
begin
  GetProcedureAddress(_ToAsciiEx, user32, 'ToAsciiEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ToAsciiEx]
  end;
end;

var
  _ToUnicode: Pointer;

function ToUnicode;
begin
  GetProcedureAddress(_ToUnicode, user32, 'ToUnicode');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ToUnicode]
  end;
end;

var
  _OemKeyScan: Pointer;

function OemKeyScan;
begin
  GetProcedureAddress(_OemKeyScan, user32, 'OemKeyScan');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OemKeyScan]
  end;
end;

var
  _VkKeyScanA: Pointer;

function VkKeyScanA;
begin
  GetProcedureAddress(_VkKeyScanA, user32, 'VkKeyScanA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_VkKeyScanA]
  end;
end;

var
  _VkKeyScanW: Pointer;

function VkKeyScanW;
begin
  GetProcedureAddress(_VkKeyScanW, user32, 'VkKeyScanW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_VkKeyScanW]
  end;
end;

var
  _VkKeyScan: Pointer;

function VkKeyScan;
begin
  GetProcedureAddress(_VkKeyScan, user32, 'VkKeyScan' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_VkKeyScan]
  end;
end;

var
  _VkKeyScanExA: Pointer;

function VkKeyScanExA;
begin
  GetProcedureAddress(_VkKeyScanExA, user32, 'VkKeyScanExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_VkKeyScanExA]
  end;
end;

var
  _VkKeyScanExW: Pointer;

function VkKeyScanExW;
begin
  GetProcedureAddress(_VkKeyScanExW, user32, 'VkKeyScanExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_VkKeyScanExW]
  end;
end;

var
  _VkKeyScanEx: Pointer;

function VkKeyScanEx;
begin
  GetProcedureAddress(_VkKeyScanEx, user32, 'VkKeyScanEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_VkKeyScanEx]
  end;
end;

var
  _keybd_event: Pointer;

procedure keybd_event;
begin
  GetProcedureAddress(_keybd_event, user32, 'keybd_event');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_keybd_event]
  end;
end;

var
  _mouse_event: Pointer;

procedure mouse_event;
begin
  GetProcedureAddress(_mouse_event, user32, 'mouse_event');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_mouse_event]
  end;
end;

var
  _SendInput: Pointer;

function SendInput;
begin
  GetProcedureAddress(_SendInput, user32, 'SendInput');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SendInput]
  end;
end;

var
  _GetLastInputInfo: Pointer;

function GetLastInputInfo;
begin
  GetProcedureAddress(_GetLastInputInfo, user32, 'GetLastInputInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetLastInputInfo]
  end;
end;

var
  _MapVirtualKeyA: Pointer;

function MapVirtualKeyA;
begin
  GetProcedureAddress(_MapVirtualKeyA, user32, 'MapVirtualKeyA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MapVirtualKeyA]
  end;
end;

var
  _MapVirtualKeyW: Pointer;

function MapVirtualKeyW;
begin
  GetProcedureAddress(_MapVirtualKeyW, user32, 'MapVirtualKeyW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MapVirtualKeyW]
  end;
end;

var
  _MapVirtualKey: Pointer;

function MapVirtualKey;
begin
  GetProcedureAddress(_MapVirtualKey, user32, 'MapVirtualKey' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MapVirtualKey]
  end;
end;

var
  _MapVirtualKeyExA: Pointer;

function MapVirtualKeyExA;
begin
  GetProcedureAddress(_MapVirtualKeyExA, user32, 'MapVirtualKeyExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MapVirtualKeyExA]
  end;
end;

var
  _MapVirtualKeyExW: Pointer;

function MapVirtualKeyExW;
begin
  GetProcedureAddress(_MapVirtualKeyExW, user32, 'MapVirtualKeyExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MapVirtualKeyExW]
  end;
end;

var
  _MapVirtualKeyEx: Pointer;

function MapVirtualKeyEx;
begin
  GetProcedureAddress(_MapVirtualKeyEx, user32, 'MapVirtualKeyEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MapVirtualKeyEx]
  end;
end;

var
  _GetInputState: Pointer;

function GetInputState;
begin
  GetProcedureAddress(_GetInputState, user32, 'GetInputState');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetInputState]
  end;
end;

var
  _GetQueueStatus: Pointer;

function GetQueueStatus;
begin
  GetProcedureAddress(_GetQueueStatus, user32, 'GetQueueStatus');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetQueueStatus]
  end;
end;

var
  _GetCapture: Pointer;

function GetCapture;
begin
  GetProcedureAddress(_GetCapture, user32, 'GetCapture');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetCapture]
  end;
end;

var
  _SetCapture: Pointer;

function SetCapture;
begin
  GetProcedureAddress(_SetCapture, user32, 'SetCapture');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetCapture]
  end;
end;

var
  _ReleaseCapture: Pointer;

function ReleaseCapture;
begin
  GetProcedureAddress(_ReleaseCapture, user32, 'ReleaseCapture');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ReleaseCapture]
  end;
end;

var
  _MsgWaitForMultipleObjects: Pointer;

function MsgWaitForMultipleObjects;
begin
  GetProcedureAddress(_MsgWaitForMultipleObjects, user32, 'MsgWaitForMultipleObjects');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MsgWaitForMultipleObjects]
  end;
end;

var
  _MsgWaitForMultipleObjectsEx: Pointer;

function MsgWaitForMultipleObjectsEx;
begin
  GetProcedureAddress(_MsgWaitForMultipleObjectsEx, user32, 'MsgWaitForMultipleObjectsEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MsgWaitForMultipleObjectsEx]
  end;
end;

var
  _SetTimer: Pointer;

function SetTimer;
begin
  GetProcedureAddress(_SetTimer, user32, 'SetTimer');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetTimer]
  end;
end;

var
  _KillTimer: Pointer;

function KillTimer;
begin
  GetProcedureAddress(_KillTimer, user32, 'KillTimer');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_KillTimer]
  end;
end;

var
  _IsWindowUnicode: Pointer;

function IsWindowUnicode;
begin
  GetProcedureAddress(_IsWindowUnicode, user32, 'IsWindowUnicode');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsWindowUnicode]
  end;
end;

var
  _EnableWindow: Pointer;

function EnableWindow;
begin
  GetProcedureAddress(_EnableWindow, user32, 'EnableWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnableWindow]
  end;
end;

var
  _IsWindowEnabled: Pointer;

function IsWindowEnabled;
begin
  GetProcedureAddress(_IsWindowEnabled, user32, 'IsWindowEnabled');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsWindowEnabled]
  end;
end;

var
  _LoadAcceleratorsA: Pointer;

function LoadAcceleratorsA;
begin
  GetProcedureAddress(_LoadAcceleratorsA, user32, 'LoadAcceleratorsA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadAcceleratorsA]
  end;
end;

var
  _LoadAcceleratorsW: Pointer;

function LoadAcceleratorsW;
begin
  GetProcedureAddress(_LoadAcceleratorsW, user32, 'LoadAcceleratorsW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadAcceleratorsW]
  end;
end;

var
  _LoadAccelerators: Pointer;

function LoadAccelerators;
begin
  GetProcedureAddress(_LoadAccelerators, user32, 'LoadAccelerators' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadAccelerators]
  end;
end;

var
  _CreateAcceleratorTableA: Pointer;

function CreateAcceleratorTableA;
begin
  GetProcedureAddress(_CreateAcceleratorTableA, user32, 'CreateAcceleratorTableA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateAcceleratorTableA]
  end;
end;

var
  _CreateAcceleratorTableW: Pointer;

function CreateAcceleratorTableW;
begin
  GetProcedureAddress(_CreateAcceleratorTableW, user32, 'CreateAcceleratorTableW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateAcceleratorTableW]
  end;
end;

var
  _CreateAcceleratorTable: Pointer;

function CreateAcceleratorTable;
begin
  GetProcedureAddress(_CreateAcceleratorTable, user32, 'CreateAcceleratorTable' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateAcceleratorTable]
  end;
end;

var
  _DestroyAcceleratorTable: Pointer;

function DestroyAcceleratorTable;
begin
  GetProcedureAddress(_DestroyAcceleratorTable, user32, 'DestroyAcceleratorTable');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DestroyAcceleratorTable]
  end;
end;

var
  _CopyAcceleratorTableA: Pointer;

function CopyAcceleratorTableA;
begin
  GetProcedureAddress(_CopyAcceleratorTableA, user32, 'CopyAcceleratorTableA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CopyAcceleratorTableA]
  end;
end;

var
  _CopyAcceleratorTableW: Pointer;

function CopyAcceleratorTableW;
begin
  GetProcedureAddress(_CopyAcceleratorTableW, user32, 'CopyAcceleratorTableW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CopyAcceleratorTableW]
  end;
end;

var
  _CopyAcceleratorTable: Pointer;

function CopyAcceleratorTable;
begin
  GetProcedureAddress(_CopyAcceleratorTable, user32, 'CopyAcceleratorTable' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CopyAcceleratorTable]
  end;
end;

var
  _TranslateAcceleratorA: Pointer;

function TranslateAcceleratorA;
begin
  GetProcedureAddress(_TranslateAcceleratorA, user32, 'TranslateAcceleratorA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_TranslateAcceleratorA]
  end;
end;

var
  _TranslateAcceleratorW: Pointer;

function TranslateAcceleratorW;
begin
  GetProcedureAddress(_TranslateAcceleratorW, user32, 'TranslateAcceleratorW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_TranslateAcceleratorW]
  end;
end;

var
  _TranslateAccelerator: Pointer;

function TranslateAccelerator;
begin
  GetProcedureAddress(_TranslateAccelerator, user32, 'TranslateAccelerator' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_TranslateAccelerator]
  end;
end;

var
  _GetSystemMetrics: Pointer;

function GetSystemMetrics;
begin
  GetProcedureAddress(_GetSystemMetrics, user32, 'GetSystemMetrics');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetSystemMetrics]
  end;
end;

var
  _LoadMenuA: Pointer;

function LoadMenuA;
begin
  GetProcedureAddress(_LoadMenuA, user32, 'LoadMenuAA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadMenuA]
  end;
end;

var
  _LoadMenuW: Pointer;

function LoadMenuW;
begin
  GetProcedureAddress(_LoadMenuW, user32, 'LoadMenuWA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadMenuW]
  end;
end;

var
  _LoadMenu: Pointer;

function LoadMenu;
begin
  GetProcedureAddress(_LoadMenu, user32, 'LoadMenu' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadMenu]
  end;
end;

var
  _LoadMenuIndirectA: Pointer;

function LoadMenuIndirectA;
begin
  GetProcedureAddress(_LoadMenuIndirectA, user32, 'LoadMenuIndirectA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadMenuIndirectA]
  end;
end;

var
  _LoadMenuIndirectW: Pointer;

function LoadMenuIndirectW;
begin
  GetProcedureAddress(_LoadMenuIndirectW, user32, 'LoadMenuIndirectW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadMenuIndirectW]
  end;
end;

var
  _LoadMenuIndirect: Pointer;

function LoadMenuIndirect;
begin
  GetProcedureAddress(_LoadMenuIndirect, user32, 'LoadMenuIndirect' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadMenuIndirect]
  end;
end;

var
  _GetMenu: Pointer;

function GetMenu;
begin
  GetProcedureAddress(_GetMenu, user32, 'GetMenu');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenu]
  end;
end;

var
  _SetMenu: Pointer;

function SetMenu;
begin
  GetProcedureAddress(_SetMenu, user32, 'SetMenu');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetMenu]
  end;
end;

var
  _ChangeMenuA: Pointer;

function ChangeMenuA;
begin
  GetProcedureAddress(_ChangeMenuA, user32, 'ChangeMenuA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ChangeMenuA]
  end;
end;

var
  _ChangeMenuW: Pointer;

function ChangeMenuW;
begin
  GetProcedureAddress(_ChangeMenuW, user32, 'ChangeMenuW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ChangeMenuW]
  end;
end;

var
  _ChangeMenu: Pointer;

function ChangeMenu;
begin
  GetProcedureAddress(_ChangeMenu, user32, 'ChangeMenu' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ChangeMenu]
  end;
end;

var
  _HiliteMenuItem: Pointer;

function HiliteMenuItem;
begin
  GetProcedureAddress(_HiliteMenuItem, user32, 'HiliteMenuItem');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_HiliteMenuItem]
  end;
end;

var
  _GetMenuStringA: Pointer;

function GetMenuStringA;
begin
  GetProcedureAddress(_GetMenuStringA, user32, 'GetMenuStringA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuStringA]
  end;
end;

var
  _GetMenuStringW: Pointer;

function GetMenuStringW;
begin
  GetProcedureAddress(_GetMenuStringW, user32, 'GetMenuStringW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuStringW]
  end;
end;

var
  _GetMenuString: Pointer;

function GetMenuString;
begin
  GetProcedureAddress(_GetMenuString, user32, 'GetMenuString' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuString]
  end;
end;

var
  _GetMenuState: Pointer;

function GetMenuState;
begin
  GetProcedureAddress(_GetMenuState, user32, 'GetMenuState');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuState]
  end;
end;

var
  _DrawMenuBar: Pointer;

function DrawMenuBar;
begin
  GetProcedureAddress(_DrawMenuBar, user32, 'DrawMenuBar');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawMenuBar]
  end;
end;

var
  _GetSystemMenu: Pointer;

function GetSystemMenu;
begin
  GetProcedureAddress(_GetSystemMenu, user32, 'GetSystemMenu');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetSystemMenu]
  end;
end;

var
  _CreateMenu: Pointer;

function CreateMenu;
begin
  GetProcedureAddress(_CreateMenu, user32, 'CreateMenu');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateMenu]
  end;
end;

var
  _CreatePopupMenu: Pointer;

function CreatePopupMenu;
begin
  GetProcedureAddress(_CreatePopupMenu, user32, 'CreatePopupMenu');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreatePopupMenu]
  end;
end;

var
  _DestroyMenu: Pointer;

function DestroyMenu;
begin
  GetProcedureAddress(_DestroyMenu, user32, 'DestroyMenu');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DestroyMenu]
  end;
end;

var
  _CheckMenuItem: Pointer;

function CheckMenuItem;
begin
  GetProcedureAddress(_CheckMenuItem, user32, 'CheckMenuItem');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CheckMenuItem]
  end;
end;

var
  _EnableMenuItem: Pointer;

function EnableMenuItem;
begin
  GetProcedureAddress(_EnableMenuItem, user32, 'EnableMenuItem');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnableMenuItem]
  end;
end;

var
  _GetSubMenu: Pointer;

function GetSubMenu;
begin
  GetProcedureAddress(_GetSubMenu, user32, 'GetSubMenu');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetSubMenu]
  end;
end;

var
  _GetMenuItemID: Pointer;

function GetMenuItemID;
begin
  GetProcedureAddress(_GetMenuItemID, user32, 'GetMenuItemID');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuItemID]
  end;
end;

var
  _GetMenuItemCount: Pointer;

function GetMenuItemCount;
begin
  GetProcedureAddress(_GetMenuItemCount, user32, 'GetMenuItemCount');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuItemCount]
  end;
end;

var
  _InsertMenuA: Pointer;

function InsertMenuA;
begin
  GetProcedureAddress(_InsertMenuA, user32, 'InsertMenuA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_InsertMenuA]
  end;
end;

var
  _InsertMenuW: Pointer;

function InsertMenuW;
begin
  GetProcedureAddress(_InsertMenuW, user32, 'InsertMenuW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_InsertMenuW]
  end;
end;

var
  _InsertMenu: Pointer;

function InsertMenu;
begin
  GetProcedureAddress(_InsertMenu, user32, 'InsertMenu' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_InsertMenu]
  end;
end;

var
  _AppendMenuA: Pointer;

function AppendMenuA;
begin
  GetProcedureAddress(_AppendMenuA, user32, 'AppendMenuA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_AppendMenuA]
  end;
end;

var
  _AppendMenuW: Pointer;

function AppendMenuW;
begin
  GetProcedureAddress(_AppendMenuW, user32, 'AppendMenuW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_AppendMenuW]
  end;
end;

var
  _AppendMenu: Pointer;

function AppendMenu;
begin
  GetProcedureAddress(_AppendMenu, user32, 'AppendMenu' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_AppendMenu]
  end;
end;

var
  _ModifyMenuA: Pointer;

function ModifyMenuA;
begin
  GetProcedureAddress(_ModifyMenuA, user32, 'ModifyMenuA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ModifyMenuA]
  end;
end;

var
  _ModifyMenuW: Pointer;

function ModifyMenuW;
begin
  GetProcedureAddress(_ModifyMenuW, user32, 'ModifyMenuW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ModifyMenuW]
  end;
end;

var
  _ModifyMenu: Pointer;

function ModifyMenu;
begin
  GetProcedureAddress(_ModifyMenu, user32, 'ModifyMenu' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ModifyMenu]
  end;
end;

var
  _RemoveMenu: Pointer;

function RemoveMenu;
begin
  GetProcedureAddress(_RemoveMenu, user32, 'RemoveMenu');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RemoveMenu]
  end;
end;

var
  _DeleteMenu: Pointer;

function DeleteMenu;
begin
  GetProcedureAddress(_DeleteMenu, user32, 'DeleteMenu');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DeleteMenu]
  end;
end;

var
  _SetMenuItemBitmaps: Pointer;

function SetMenuItemBitmaps;
begin
  GetProcedureAddress(_SetMenuItemBitmaps, user32, 'SetMenuItemBitmaps');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetMenuItemBitmaps]
  end;
end;

var
  _GetMenuCheckMarkDimensions: Pointer;

function GetMenuCheckMarkDimensions;
begin
  GetProcedureAddress(_GetMenuCheckMarkDimensions, user32, 'GetMenuCheckMarkDimensions');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuCheckMarkDimensions]
  end;
end;

var
  _TrackPopupMenu: Pointer;

function TrackPopupMenu;
begin
  GetProcedureAddress(_TrackPopupMenu, user32, 'TrackPopupMenu');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_TrackPopupMenu]
  end;
end;

var
  _TrackPopupMenuEx: Pointer;

function TrackPopupMenuEx;
begin
  GetProcedureAddress(_TrackPopupMenuEx, user32, 'TrackPopupMenuEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_TrackPopupMenuEx]
  end;
end;

var
  _GetMenuInfo: Pointer;

function GetMenuInfo;
begin
  GetProcedureAddress(_GetMenuInfo, user32, 'GetMenuInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuInfo]
  end;
end;

var
  _SetMenuInfo: Pointer;

function SetMenuInfo;
begin
  GetProcedureAddress(_SetMenuInfo, user32, 'SetMenuInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetMenuInfo]
  end;
end;

var
  _EndMenu: Pointer;

function EndMenu;
begin
  GetProcedureAddress(_EndMenu, user32, 'EndMenu');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EndMenu]
  end;
end;

var
  _InsertMenuItemA: Pointer;

function InsertMenuItemA;
begin
  GetProcedureAddress(_InsertMenuItemA, user32, 'InsertMenuItemA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_InsertMenuItemA]
  end;
end;

var
  _InsertMenuItemW: Pointer;

function InsertMenuItemW;
begin
  GetProcedureAddress(_InsertMenuItemW, user32, 'InsertMenuItemW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_InsertMenuItemW]
  end;
end;

var
  _InsertMenuItem: Pointer;

function InsertMenuItem;
begin
  GetProcedureAddress(_InsertMenuItem, user32, 'InsertMenuItem' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_InsertMenuItem]
  end;
end;

var
  _GetMenuItemInfoA: Pointer;

function GetMenuItemInfoA;
begin
  GetProcedureAddress(_GetMenuItemInfoA, user32, 'GetMenuItemInfoA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuItemInfoA]
  end;
end;

var
  _GetMenuItemInfoW: Pointer;

function GetMenuItemInfoW;
begin
  GetProcedureAddress(_GetMenuItemInfoW, user32, 'GetMenuItemInfoW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuItemInfoW]
  end;
end;

var
  _GetMenuItemInfo: Pointer;

function GetMenuItemInfo;
begin
  GetProcedureAddress(_GetMenuItemInfo, user32, 'GetMenuItemInfo' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuItemInfo]
  end;
end;

var
  _SetMenuItemInfoA: Pointer;

function SetMenuItemInfoA;
begin
  GetProcedureAddress(_SetMenuItemInfoA, user32, 'SetMenuItemInfoA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetMenuItemInfoA]
  end;
end;

var
  _SetMenuItemInfoW: Pointer;

function SetMenuItemInfoW;
begin
  GetProcedureAddress(_SetMenuItemInfoW, user32, 'SetMenuItemInfoW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetMenuItemInfoW]
  end;
end;

var
  _SetMenuItemInfo: Pointer;

function SetMenuItemInfo;
begin
  GetProcedureAddress(_SetMenuItemInfo, user32, 'SetMenuItemInfo' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetMenuItemInfo]
  end;
end;

var
  _GetMenuDefaultItem: Pointer;

function GetMenuDefaultItem;
begin
  GetProcedureAddress(_GetMenuDefaultItem, user32, 'GetMenuDefaultItem');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuDefaultItem]
  end;
end;

var
  _SetMenuDefaultItem: Pointer;

function SetMenuDefaultItem;
begin
  GetProcedureAddress(_SetMenuDefaultItem, user32, 'SetMenuDefaultItem');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetMenuDefaultItem]
  end;
end;

var
  _GetMenuItemRect: Pointer;

function GetMenuItemRect;
begin
  GetProcedureAddress(_GetMenuItemRect, user32, 'GetMenuItemRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuItemRect]
  end;
end;

var
  _MenuItemFromPoint: Pointer;

function MenuItemFromPoint;
begin
  GetProcedureAddress(_MenuItemFromPoint, user32, 'MenuItemFromPoint');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MenuItemFromPoint]
  end;
end;

var
  _DragObject: Pointer;

function DragObject;
begin
  GetProcedureAddress(_DragObject, user32, 'DragObject');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DragObject]
  end;
end;

var
  _DragDetect: Pointer;

function DragDetect;
begin
  GetProcedureAddress(_DragDetect, user32, 'DragDetect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DragDetect]
  end;
end;

var
  _DrawIcon: Pointer;

function DrawIcon;
begin
  GetProcedureAddress(_DrawIcon, user32, 'DrawIcon');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawIcon]
  end;
end;

var
  _DrawTextA: Pointer;

function DrawTextA;
begin
  GetProcedureAddress(_DrawTextA, user32, 'DrawTextA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawTextA]
  end;
end;

var
  _DrawTextW: Pointer;

function DrawTextW;
begin
  GetProcedureAddress(_DrawTextW, user32, 'DrawTextW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawTextW]
  end;
end;

var
  _DrawText: Pointer;

function DrawText;
begin
  GetProcedureAddress(_DrawText, user32, 'DrawText' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawText]
  end;
end;

var
  _DrawTextExA: Pointer;

function DrawTextExA;
begin
  GetProcedureAddress(_DrawTextExA, user32, 'DrawTextExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawTextExA]
  end;
end;

var
  _DrawTextExW: Pointer;

function DrawTextExW;
begin
  GetProcedureAddress(_DrawTextExW, user32, 'DrawTextExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawTextExW]
  end;
end;

var
  _DrawTextEx: Pointer;

function DrawTextEx;
begin
  GetProcedureAddress(_DrawTextEx, user32, 'DrawTextEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawTextEx]
  end;
end;

var
  _GrayStringA: Pointer;

function GrayStringA;
begin
  GetProcedureAddress(_GrayStringA, user32, 'GrayStringA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GrayStringA]
  end;
end;

var
  _GrayStringW: Pointer;

function GrayStringW;
begin
  GetProcedureAddress(_GrayStringW, user32, 'GrayStringW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GrayStringW]
  end;
end;

var
  _GrayString: Pointer;

function GrayString;
begin
  GetProcedureAddress(_GrayString, user32, 'GrayString' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GrayString]
  end;
end;

var
  _DrawStateA: Pointer;

function DrawStateA;
begin
  GetProcedureAddress(_DrawStateA, user32, 'DrawStateA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawStateA]
  end;
end;

var
  _DrawStateW: Pointer;

function DrawStateW;
begin
  GetProcedureAddress(_DrawStateW, user32, 'DrawStateW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawStateW]
  end;
end;

var
  _DrawState: Pointer;

function DrawState;
begin
  GetProcedureAddress(_DrawState, user32, 'DrawState' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawState]
  end;
end;

var
  _TabbedTextOutA: Pointer;

function TabbedTextOutA;
begin
  GetProcedureAddress(_TabbedTextOutA, user32, 'TabbedTextOutA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_TabbedTextOutA]
  end;
end;

var
  _TabbedTextOutW: Pointer;

function TabbedTextOutW;
begin
  GetProcedureAddress(_TabbedTextOutW, user32, 'TabbedTextOutW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_TabbedTextOutW]
  end;
end;

var
  _TabbedTextOut: Pointer;

function TabbedTextOut;
begin
  GetProcedureAddress(_TabbedTextOut, user32, 'TabbedTextOut' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_TabbedTextOut]
  end;
end;

var
  _GetTabbedTextExtentA: Pointer;

function GetTabbedTextExtentA;
begin
  GetProcedureAddress(_GetTabbedTextExtentA, user32, 'GetTabbedTextExtentA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetTabbedTextExtentA]
  end;
end;

var
  _GetTabbedTextExtentW: Pointer;

function GetTabbedTextExtentW;
begin
  GetProcedureAddress(_GetTabbedTextExtentW, user32, 'GetTabbedTextExtentW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetTabbedTextExtentW]
  end;
end;

var
  _GetTabbedTextExtent: Pointer;

function GetTabbedTextExtent;
begin
  GetProcedureAddress(_GetTabbedTextExtent, user32, 'GetTabbedTextExtent' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetTabbedTextExtent]
  end;
end;

var
  _UpdateWindow: Pointer;

function UpdateWindow;
begin
  GetProcedureAddress(_UpdateWindow, user32, 'UpdateWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_UpdateWindow]
  end;
end;

var
  _SetActiveWindow: Pointer;

function SetActiveWindow;
begin
  GetProcedureAddress(_SetActiveWindow, user32, 'SetActiveWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetActiveWindow]
  end;
end;

var
  _GetForegroundWindow: Pointer;

function GetForegroundWindow;
begin
  GetProcedureAddress(_GetForegroundWindow, user32, 'GetForegroundWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetForegroundWindow]
  end;
end;

var
  _PaintDesktop: Pointer;

function PaintDesktop;
begin
  GetProcedureAddress(_PaintDesktop, user32, 'PaintDesktop');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PaintDesktop]
  end;
end;

var
  _SwitchToThisWindow: Pointer;

procedure SwitchToThisWindow;
begin
  GetProcedureAddress(_SwitchToThisWindow, user32, 'SwitchToThisWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SwitchToThisWindow]
  end;
end;

var
  _SetForegroundWindow: Pointer;

function SetForegroundWindow;
begin
  GetProcedureAddress(_SetForegroundWindow, user32, 'SetForegroundWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetForegroundWindow]
  end;
end;

var
  _AllowSetForegroundWindow: Pointer;

function AllowSetForegroundWindow;
begin
  GetProcedureAddress(_AllowSetForegroundWindow, user32, 'AllowSetForegroundWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_AllowSetForegroundWindow]
  end;
end;

var
  _LockSetForegroundWindow: Pointer;

function LockSetForegroundWindow;
begin
  GetProcedureAddress(_LockSetForegroundWindow, user32, 'LockSetForegroundWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LockSetForegroundWindow]
  end;
end;

var
  _WindowFromDC: Pointer;

function WindowFromDC;
begin
  GetProcedureAddress(_WindowFromDC, user32, 'WindowFromDC');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_WindowFromDC]
  end;
end;

var
  _GetDC: Pointer;

function GetDC;
begin
  GetProcedureAddress(_GetDC, user32, 'GetDC');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetDC]
  end;
end;

var
  _GetDCEx: Pointer;

function GetDCEx;
begin
  GetProcedureAddress(_GetDCEx, user32, 'GetDCEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetDCEx]
  end;
end;

var
  _GetWindowDC: Pointer;

function GetWindowDC;
begin
  GetProcedureAddress(_GetWindowDC, user32, 'GetWindowDC');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowDC]
  end;
end;

var
  _ReleaseDC: Pointer;

function ReleaseDC;
begin
  GetProcedureAddress(_ReleaseDC, user32, 'ReleaseDC');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ReleaseDC]
  end;
end;

var
  _BeginPaint: Pointer;

function BeginPaint;
begin
  GetProcedureAddress(_BeginPaint, user32, 'BeginPaint');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_BeginPaint]
  end;
end;

var
  _EndPaint: Pointer;

function EndPaint;
begin
  GetProcedureAddress(_EndPaint, user32, 'EndPaint');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EndPaint]
  end;
end;

var
  _GetUpdateRect: Pointer;

function GetUpdateRect;
begin
  GetProcedureAddress(_GetUpdateRect, user32, 'GetUpdateRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetUpdateRect]
  end;
end;

var
  _GetUpdateRgn: Pointer;

function GetUpdateRgn;
begin
  GetProcedureAddress(_GetUpdateRgn, user32, 'GetUpdateRgn');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetUpdateRgn]
  end;
end;

var
  _SetWindowRgn: Pointer;

function SetWindowRgn;
begin
  GetProcedureAddress(_SetWindowRgn, user32, 'SetWindowRgn');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowRgn]
  end;
end;

var
  _GetWindowRgn: Pointer;

function GetWindowRgn;
begin
  GetProcedureAddress(_GetWindowRgn, user32, 'GetWindowRgn');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowRgn]
  end;
end;

var
  _GetWindowRgnBox: Pointer;

function GetWindowRgnBox;
begin
  GetProcedureAddress(_GetWindowRgnBox, user32, 'GetWindowRgnBox');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowRgnBox]
  end;
end;

var
  _ExcludeUpdateRgn: Pointer;

function ExcludeUpdateRgn;
begin
  GetProcedureAddress(_ExcludeUpdateRgn, user32, 'ExcludeUpdateRgn');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ExcludeUpdateRgn]
  end;
end;

var
  _InvalidateRect: Pointer;

function InvalidateRect;
begin
  GetProcedureAddress(_InvalidateRect, user32, 'InvalidateRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_InvalidateRect]
  end;
end;

var
  _ValidateRect: Pointer;

function ValidateRect;
begin
  GetProcedureAddress(_ValidateRect, user32, 'ValidateRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ValidateRect]
  end;
end;

var
  _InvalidateRgn: Pointer;

function InvalidateRgn;
begin
  GetProcedureAddress(_InvalidateRgn, user32, 'InvalidateRgn');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_InvalidateRgn]
  end;
end;

var
  _ValidateRgn: Pointer;

function ValidateRgn;
begin
  GetProcedureAddress(_ValidateRgn, user32, 'ValidateRgn');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ValidateRgn]
  end;
end;

var
  _RedrawWindow: Pointer;

function RedrawWindow;
begin
  GetProcedureAddress(_RedrawWindow, user32, 'RedrawWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RedrawWindow]
  end;
end;

var
  _LockWindowUpdate: Pointer;

function LockWindowUpdate;
begin
  GetProcedureAddress(_LockWindowUpdate, user32, 'LockWindowUpdate');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LockWindowUpdate]
  end;
end;

var
  _ScrollWindow: Pointer;

function ScrollWindow;
begin
  GetProcedureAddress(_ScrollWindow, user32, 'ScrollWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ScrollWindow]
  end;
end;

var
  _ScrollDC: Pointer;

function ScrollDC;
begin
  GetProcedureAddress(_ScrollDC, user32, 'ScrollDC');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ScrollDC]
  end;
end;

var
  _ScrollWindowEx: Pointer;

function ScrollWindowEx;
begin
  GetProcedureAddress(_ScrollWindowEx, user32, 'ScrollWindowEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ScrollWindowEx]
  end;
end;

var
  _SetScrollPos: Pointer;

function SetScrollPos;
begin
  GetProcedureAddress(_SetScrollPos, user32, 'SetScrollPos');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetScrollPos]
  end;
end;

var
  _GetScrollPos: Pointer;

function GetScrollPos;
begin
  GetProcedureAddress(_GetScrollPos, user32, 'GetScrollPos');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetScrollPos]
  end;
end;

var
  _SetScrollRange: Pointer;

function SetScrollRange;
begin
  GetProcedureAddress(_SetScrollRange, user32, 'SetScrollRange');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetScrollRange]
  end;
end;

var
  _GetScrollRange: Pointer;

function GetScrollRange;
begin
  GetProcedureAddress(_GetScrollRange, user32, 'GetScrollRange');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetScrollRange]
  end;
end;

var
  _ShowScrollBar: Pointer;

function ShowScrollBar;
begin
  GetProcedureAddress(_ShowScrollBar, user32, 'ShowScrollBar');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ShowScrollBar]
  end;
end;

var
  _EnableScrollBar: Pointer;

function EnableScrollBar;
begin
  GetProcedureAddress(_EnableScrollBar, user32, 'EnableScrollBar');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnableScrollBar]
  end;
end;

var
  _SetPropA: Pointer;

function SetPropA;
begin
  GetProcedureAddress(_SetPropA, user32, 'SetPropA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetPropA]
  end;
end;

var
  _SetPropW: Pointer;

function SetPropW;
begin
  GetProcedureAddress(_SetPropW, user32, 'SetPropW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetPropW]
  end;
end;

var
  _SetProp: Pointer;

function SetProp;
begin
  GetProcedureAddress(_SetProp, user32, 'SetProp' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetProp]
  end;
end;

var
  _GetPropA: Pointer;

function GetPropA;
begin
  GetProcedureAddress(_GetPropA, user32, 'GetPropA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetPropA]
  end;
end;

var
  _GetPropW: Pointer;

function GetPropW;
begin
  GetProcedureAddress(_GetPropW, user32, 'GetPropW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetPropW]
  end;
end;

var
  _GetProp: Pointer;

function GetProp;
begin
  GetProcedureAddress(_GetProp, user32, 'GetProp' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetProp]
  end;
end;

var
  _RemovePropA: Pointer;

function RemovePropA;
begin
  GetProcedureAddress(_RemovePropA, user32, 'RemovePropA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RemovePropA]
  end;
end;

var
  _RemovePropW: Pointer;

function RemovePropW;
begin
  GetProcedureAddress(_RemovePropW, user32, 'RemovePropW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RemovePropW]
  end;
end;

var
  _RemoveProp: Pointer;

function RemoveProp;
begin
  GetProcedureAddress(_RemoveProp, user32, 'RemoveProp' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RemoveProp]
  end;
end;

var
  _EnumPropsExA: Pointer;

function EnumPropsExA;
begin
  GetProcedureAddress(_EnumPropsExA, user32, 'EnumPropsExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumPropsExA]
  end;
end;

var
  _EnumPropsExW: Pointer;

function EnumPropsExW;
begin
  GetProcedureAddress(_EnumPropsExW, user32, 'EnumPropsExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumPropsExW]
  end;
end;

var
  _EnumPropsEx: Pointer;

function EnumPropsEx;
begin
  GetProcedureAddress(_EnumPropsEx, user32, 'EnumPropsEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumPropsEx]
  end;
end;

var
  _EnumPropsA: Pointer;

function EnumPropsA;
begin
  GetProcedureAddress(_EnumPropsA, user32, 'EnumPropsA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumPropsA]
  end;
end;

var
  _EnumPropsW: Pointer;

function EnumPropsW;
begin
  GetProcedureAddress(_EnumPropsW, user32, 'EnumPropsW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumPropsW]
  end;
end;

var
  _EnumProps: Pointer;

function EnumProps;
begin
  GetProcedureAddress(_EnumProps, user32, 'EnumProps' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumProps]
  end;
end;

var
  _SetWindowTextA: Pointer;

function SetWindowTextA;
begin
  GetProcedureAddress(_SetWindowTextA, user32, 'SetWindowTextA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowTextA]
  end;
end;

var
  _SetWindowTextW: Pointer;

function SetWindowTextW;
begin
  GetProcedureAddress(_SetWindowTextW, user32, 'SetWindowTextW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowTextW]
  end;
end;

var
  _SetWindowText: Pointer;

function SetWindowText;
begin
  GetProcedureAddress(_SetWindowText, user32, 'SetWindowText' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowText]
  end;
end;

var
  _GetWindowTextA: Pointer;

function GetWindowTextA;
begin
  GetProcedureAddress(_GetWindowTextA, user32, 'GetWindowTextA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowTextA]
  end;
end;

var
  _GetWindowTextW: Pointer;

function GetWindowTextW;
begin
  GetProcedureAddress(_GetWindowTextW, user32, 'GetWindowTextW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowTextW]
  end;
end;

var
  _GetWindowText: Pointer;

function GetWindowText;
begin
  GetProcedureAddress(_GetWindowText, user32, 'GetWindowText' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowText]
  end;
end;

var
  _GetWindowTextLengthA: Pointer;

function GetWindowTextLengthA;
begin
  GetProcedureAddress(_GetWindowTextLengthA, user32, 'GetWindowTextLengthA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowTextLengthA]
  end;
end;

var
  _GetWindowTextLengthW: Pointer;

function GetWindowTextLengthW;
begin
  GetProcedureAddress(_GetWindowTextLengthW, user32, 'GetWindowTextLengthW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowTextLengthW]
  end;
end;

var
  _GetWindowTextLength: Pointer;

function GetWindowTextLength;
begin
  GetProcedureAddress(_GetWindowTextLength, user32, 'GetWindowTextLength' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowTextLength]
  end;
end;

var
  _GetClientRect: Pointer;

function GetClientRect;
begin
  GetProcedureAddress(_GetClientRect, user32, 'GetClientRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClientRect]
  end;
end;

var
  _GetWindowRect: Pointer;

function GetWindowRect;
begin
  GetProcedureAddress(_GetWindowRect, user32, 'GetWindowRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowRect]
  end;
end;

var
  _AdjustWindowRect: Pointer;

function AdjustWindowRect;
begin
  GetProcedureAddress(_AdjustWindowRect, user32, 'AdjustWindowRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_AdjustWindowRect]
  end;
end;

var
  _AdjustWindowRectEx: Pointer;

function AdjustWindowRectEx;
begin
  GetProcedureAddress(_AdjustWindowRectEx, user32, 'AdjustWindowRectEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_AdjustWindowRectEx]
  end;
end;

var
  _SetWindowContextHelpId: Pointer;

function SetWindowContextHelpId;
begin
  GetProcedureAddress(_SetWindowContextHelpId, user32, 'SetWindowContextHelpId');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowContextHelpId]
  end;
end;

var
  _GetWindowContextHelpId: Pointer;

function GetWindowContextHelpId;
begin
  GetProcedureAddress(_GetWindowContextHelpId, user32, 'GetWindowContextHelpId');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowContextHelpId]
  end;
end;

var
  _SetMenuContextHelpId: Pointer;

function SetMenuContextHelpId;
begin
  GetProcedureAddress(_SetMenuContextHelpId, user32, 'SetMenuContextHelpId');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetMenuContextHelpId]
  end;
end;

var
  _GetMenuContextHelpId: Pointer;

function GetMenuContextHelpId;
begin
  GetProcedureAddress(_GetMenuContextHelpId, user32, 'GetMenuContextHelpId');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuContextHelpId]
  end;
end;

var
  _MessageBoxA: Pointer;

function MessageBoxA;
begin
  GetProcedureAddress(_MessageBoxA, user32, 'MessageBoxA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MessageBoxA]
  end;
end;

var
  _MessageBoxW: Pointer;

function MessageBoxW;
begin
  GetProcedureAddress(_MessageBoxW, user32, 'MessageBoxW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MessageBoxW]
  end;
end;

var
  _MessageBox: Pointer;

function MessageBox;
begin
  GetProcedureAddress(_MessageBox, user32, 'MessageBox' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MessageBox]
  end;
end;

var
  _MessageBoxExA: Pointer;

function MessageBoxExA;
begin
  GetProcedureAddress(_MessageBoxExA, user32, 'MessageBoxExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MessageBoxExA]
  end;
end;

var
  _MessageBoxExW: Pointer;

function MessageBoxExW;
begin
  GetProcedureAddress(_MessageBoxExW, user32, 'MessageBoxExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MessageBoxExW]
  end;
end;

var
  _MessageBoxEx: Pointer;

function MessageBoxEx;
begin
  GetProcedureAddress(_MessageBoxEx, user32, 'MessageBoxEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MessageBoxEx]
  end;
end;

var
  _MessageBoxIndirectA: Pointer;

function MessageBoxIndirectA;
begin
  GetProcedureAddress(_MessageBoxIndirectA, user32, 'MessageBoxIndirectA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MessageBoxIndirectA]
  end;
end;

var
  _MessageBoxIndirectW: Pointer;

function MessageBoxIndirectW;
begin
  GetProcedureAddress(_MessageBoxIndirectW, user32, 'MessageBoxIndirectW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MessageBoxIndirectW]
  end;
end;

var
  _MessageBoxIndirect: Pointer;

function MessageBoxIndirect;
begin
  GetProcedureAddress(_MessageBoxIndirect, user32, 'MessageBoxIndirect' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MessageBoxIndirect]
  end;
end;

var
  _MessageBeep: Pointer;

function MessageBeep;
begin
  GetProcedureAddress(_MessageBeep, user32, 'MessageBeep');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MessageBeep]
  end;
end;

var
  _ShowCursor: Pointer;

function ShowCursor;
begin
  GetProcedureAddress(_ShowCursor, user32, 'ShowCursor');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ShowCursor]
  end;
end;

var
  _SetCursorPos: Pointer;

function SetCursorPos;
begin
  GetProcedureAddress(_SetCursorPos, user32, 'SetCursorPos');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetCursorPos]
  end;
end;

var
  _SetCursor: Pointer;

function SetCursor;
begin
  GetProcedureAddress(_SetCursor, user32, 'SetCursor');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetCursor]
  end;
end;

var
  _GetCursorPos: Pointer;

function GetCursorPos;
begin
  GetProcedureAddress(_GetCursorPos, user32, 'GetCursorPos');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetCursorPos]
  end;
end;

var
  _ClipCursor: Pointer;

function ClipCursor;
begin
  GetProcedureAddress(_ClipCursor, user32, 'ClipCursor');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ClipCursor]
  end;
end;

var
  _GetClipCursor: Pointer;

function GetClipCursor;
begin
  GetProcedureAddress(_GetClipCursor, user32, 'GetClipCursor');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClipCursor]
  end;
end;

var
  _GetCursor: Pointer;

function GetCursor;
begin
  GetProcedureAddress(_GetCursor, user32, 'GetCursor');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetCursor]
  end;
end;

var
  _CreateCaret: Pointer;

function CreateCaret;
begin
  GetProcedureAddress(_CreateCaret, user32, 'CreateCaret');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateCaret]
  end;
end;

var
  _GetCaretBlinkTime: Pointer;

function GetCaretBlinkTime;
begin
  GetProcedureAddress(_GetCaretBlinkTime, user32, 'GetCaretBlinkTime');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetCaretBlinkTime]
  end;
end;

var
  _SetCaretBlinkTime: Pointer;

function SetCaretBlinkTime;
begin
  GetProcedureAddress(_SetCaretBlinkTime, user32, 'SetCaretBlinkTime');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetCaretBlinkTime]
  end;
end;

var
  _DestroyCaret: Pointer;

function DestroyCaret;
begin
  GetProcedureAddress(_DestroyCaret, user32, 'DestroyCaret');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DestroyCaret]
  end;
end;

var
  _HideCaret: Pointer;

function HideCaret;
begin
  GetProcedureAddress(_HideCaret, user32, 'HideCaret');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_HideCaret]
  end;
end;

var
  _ShowCaret: Pointer;

function ShowCaret;
begin
  GetProcedureAddress(_ShowCaret, user32, 'ShowCaret');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ShowCaret]
  end;
end;

var
  _SetCaretPos: Pointer;

function SetCaretPos;
begin
  GetProcedureAddress(_SetCaretPos, user32, 'SetCaretPos');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetCaretPos]
  end;
end;

var
  _GetCaretPos: Pointer;

function GetCaretPos;
begin
  GetProcedureAddress(_GetCaretPos, user32, 'GetCaretPos');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetCaretPos]
  end;
end;

var
  _ClientToScreen: Pointer;

function ClientToScreen;
begin
  GetProcedureAddress(_ClientToScreen, user32, 'ClientToScreen');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ClientToScreen]
  end;
end;

var
  _ScreenToClient: Pointer;

function ScreenToClient;
begin
  GetProcedureAddress(_ScreenToClient, user32, 'ScreenToClient');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ScreenToClient]
  end;
end;

var
  _MapWindowPoints: Pointer;

function MapWindowPoints;
begin
  GetProcedureAddress(_MapWindowPoints, user32, 'MapWindowPoints');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MapWindowPoints]
  end;
end;

var
  _WindowFromPoint: Pointer;

function WindowFromPoint;
begin
  GetProcedureAddress(_WindowFromPoint, user32, 'WindowFromPoint');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_WindowFromPoint]
  end;
end;

var
  _ChildWindowFromPoint: Pointer;

function ChildWindowFromPoint;
begin
  GetProcedureAddress(_ChildWindowFromPoint, user32, 'ChildWindowFromPoint');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ChildWindowFromPoint]
  end;
end;

var
  _ChildWindowFromPointEx: Pointer;

function ChildWindowFromPointEx;
begin
  GetProcedureAddress(_ChildWindowFromPointEx, user32, 'ChildWindowFromPointEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ChildWindowFromPointEx]
  end;
end;

var
  _GetSysColor: Pointer;

function GetSysColor;
begin
  GetProcedureAddress(_GetSysColor, user32, 'GetSysColor');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetSysColor]
  end;
end;

var
  _GetSysColorBrush: Pointer;

function GetSysColorBrush;
begin
  GetProcedureAddress(_GetSysColorBrush, user32, 'GetSysColorBrush');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetSysColorBrush]
  end;
end;

var
  _SetSysColors: Pointer;

function SetSysColors;
begin
  GetProcedureAddress(_SetSysColors, user32, 'SetSysColors');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetSysColors]
  end;
end;

var
  _DrawFocusRect: Pointer;

function DrawFocusRect;
begin
  GetProcedureAddress(_DrawFocusRect, user32, 'DrawFocusRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawFocusRect]
  end;
end;

var
  _FillRect: Pointer;

function FillRect;
begin
  GetProcedureAddress(_FillRect, user32, 'FillRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_FillRect]
  end;
end;

var
  _FrameRect: Pointer;

function FrameRect;
begin
  GetProcedureAddress(_FrameRect, user32, 'FrameRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_FrameRect]
  end;
end;

var
  _InvertRect: Pointer;

function InvertRect;
begin
  GetProcedureAddress(_InvertRect, user32, 'InvertRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_InvertRect]
  end;
end;

var
  _SetRect: Pointer;

function SetRect;
begin
  GetProcedureAddress(_SetRect, user32, 'SetRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetRect]
  end;
end;

var
  _SetRectEmpty: Pointer;

function SetRectEmpty;
begin
  GetProcedureAddress(_SetRectEmpty, user32, 'SetRectEmpty');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetRectEmpty]
  end;
end;

var
  _CopyRect: Pointer;

function CopyRect;
begin
  GetProcedureAddress(_CopyRect, user32, 'CopyRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CopyRect]
  end;
end;

var
  _InflateRect: Pointer;

function InflateRect;
begin
  GetProcedureAddress(_InflateRect, user32, 'InflateRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_InflateRect]
  end;
end;

var
  _IntersectRect: Pointer;

function IntersectRect;
begin
  GetProcedureAddress(_IntersectRect, user32, 'IntersectRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IntersectRect]
  end;
end;

var
  _UnionRect: Pointer;

function UnionRect;
begin
  GetProcedureAddress(_UnionRect, user32, 'UnionRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_UnionRect]
  end;
end;

var
  _SubtractRect: Pointer;

function SubtractRect;
begin
  GetProcedureAddress(_SubtractRect, user32, 'SubtractRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SubtractRect]
  end;
end;

var
  _OffsetRect: Pointer;

function OffsetRect;
begin
  GetProcedureAddress(_OffsetRect, user32, 'OffsetRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_OffsetRect]
  end;
end;

var
  _IsRectEmpty: Pointer;

function IsRectEmpty;
begin
  GetProcedureAddress(_IsRectEmpty, user32, 'IsRectEmpty');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsRectEmpty]
  end;
end;

var
  _EqualRect: Pointer;

function EqualRect;
begin
  GetProcedureAddress(_EqualRect, user32, 'EqualRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EqualRect]
  end;
end;

var
  _PtInRect: Pointer;

function PtInRect;
begin
  GetProcedureAddress(_PtInRect, user32, 'PtInRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PtInRect]
  end;
end;

var
  _GetWindowWord: Pointer;

function GetWindowWord;
begin
  GetProcedureAddress(_GetWindowWord, user32, 'GetWindowWord');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowWord]
  end;
end;

var
  _SetWindowWord: Pointer;

function SetWindowWord;
begin
  GetProcedureAddress(_SetWindowWord, user32, 'SetWindowWord');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowWord]
  end;
end;

var
  _GetWindowLongA: Pointer;

function GetWindowLongA;
begin
  GetProcedureAddress(_GetWindowLongA, user32, 'GetWindowLongA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowLongA]
  end;
end;

var
  _GetWindowLongW: Pointer;

function GetWindowLongW;
begin
  GetProcedureAddress(_GetWindowLongW, user32, 'GetWindowLongW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowLongW]
  end;
end;

var
  _GetWindowLong: Pointer;

function GetWindowLong;
begin
  GetProcedureAddress(_GetWindowLong, user32, 'GetWindowLong' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowLong]
  end;
end;

var
  _SetWindowLongA: Pointer;

function SetWindowLongA;
begin
  GetProcedureAddress(_SetWindowLongA, user32, 'SetWindowLongA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowLongA]
  end;
end;

var
  _SetWindowLongW: Pointer;

function SetWindowLongW;
begin
  GetProcedureAddress(_SetWindowLongW, user32, 'SetWindowLongW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowLongW]
  end;
end;

var
  _SetWindowLong: Pointer;

function SetWindowLong;
begin
  GetProcedureAddress(_SetWindowLong, user32, 'SetWindowLong' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowLong]
  end;
end;

var
  _GetClassWord: Pointer;

function GetClassWord;
begin
  GetProcedureAddress(_GetClassWord, user32, 'GetClassWord');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClassWord]
  end;
end;

var
  _SetClassWord: Pointer;

function SetClassWord;
begin
  GetProcedureAddress(_SetClassWord, user32, 'SetClassWord');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetClassWord]
  end;
end;

var
  _GetClassLongA: Pointer;

function GetClassLongA;
begin
  GetProcedureAddress(_GetClassLongA, user32, 'GetClassLongA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClassLongA]
  end;
end;

var
  _GetClassLongW: Pointer;

function GetClassLongW;
begin
  GetProcedureAddress(_GetClassLongW, user32, 'GetClassLongW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClassLongW]
  end;
end;

var
  _GetClassLong: Pointer;

function GetClassLong;
begin
  GetProcedureAddress(_GetClassLong, user32, 'GetClassLong' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClassLong]
  end;
end;

var
  _SetClassLongA: Pointer;

function SetClassLongA;
begin
  GetProcedureAddress(_SetClassLongA, user32, 'SetClassLongA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetClassLongA]
  end;
end;

var
  _SetClassLongW: Pointer;

function SetClassLongW;
begin
  GetProcedureAddress(_SetClassLongW, user32, 'SetClassLongW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetClassLongW]
  end;
end;

var
  _SetClassLong: Pointer;

function SetClassLong;
begin
  GetProcedureAddress(_SetClassLong, user32, 'SetClassLong' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetClassLong]
  end;
end;

var
  _GetProcessDefaultLayout: Pointer;

function GetProcessDefaultLayout;
begin
  GetProcedureAddress(_GetProcessDefaultLayout, user32, 'GetProcessDefaultLayout');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetProcessDefaultLayout]
  end;
end;

var
  _SetProcessDefaultLayout: Pointer;

function SetProcessDefaultLayout;
begin
  GetProcedureAddress(_SetProcessDefaultLayout, user32, 'SetProcessDefaultLayout');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetProcessDefaultLayout]
  end;
end;

var
  _GetDesktopWindow: Pointer;

function GetDesktopWindow;
begin
  GetProcedureAddress(_GetDesktopWindow, user32, 'GetDesktopWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetDesktopWindow]
  end;
end;

var
  _GetParent: Pointer;

function GetParent;
begin
  GetProcedureAddress(_GetParent, user32, 'GetParent');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetParent]
  end;
end;

var
  _SetParent: Pointer;

function SetParent;
begin
  GetProcedureAddress(_SetParent, user32, 'SetParent');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetParent]
  end;
end;

var
  _EnumChildWindows: Pointer;

function EnumChildWindows;
begin
  GetProcedureAddress(_EnumChildWindows, user32, 'EnumChildWindows');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumChildWindows]
  end;
end;

var
  _FindWindowA: Pointer;

function FindWindowA;
begin
  GetProcedureAddress(_FindWindowA, user32, 'FindWindowA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_FindWindowA]
  end;
end;

var
  _FindWindowW: Pointer;

function FindWindowW;
begin
  GetProcedureAddress(_FindWindowW, user32, 'FindWindowW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_FindWindowW]
  end;
end;

var
  _FindWindow: Pointer;

function FindWindow;
begin
  GetProcedureAddress(_FindWindow, user32, 'FindWindow' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_FindWindow]
  end;
end;

var
  _FindWindowExA: Pointer;

function FindWindowExA;
begin
  GetProcedureAddress(_FindWindowExA, user32, 'FindWindowExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_FindWindowExA]
  end;
end;

var
  _FindWindowExW: Pointer;

function FindWindowExW;
begin
  GetProcedureAddress(_FindWindowExW, user32, 'FindWindowExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_FindWindowExW]
  end;
end;

var
  _FindWindowEx: Pointer;

function FindWindowEx;
begin
  GetProcedureAddress(_FindWindowEx, user32, 'FindWindowEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_FindWindowEx]
  end;
end;

var
  _GetShellWindow: Pointer;

function GetShellWindow;
begin
  GetProcedureAddress(_GetShellWindow, user32, 'GetShellWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetShellWindow]
  end;
end;

var
  _RegisterShellHookWindow: Pointer;

function RegisterShellHookWindow;
begin
  GetProcedureAddress(_RegisterShellHookWindow, user32, 'RegisterShellHookWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterShellHookWindow]
  end;
end;

var
  _DeregisterShellHookWindow: Pointer;

function DeregisterShellHookWindow;
begin
  GetProcedureAddress(_DeregisterShellHookWindow, user32, 'DeregisterShellHookWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DeregisterShellHookWindow]
  end;
end;

var
  _EnumWindows: Pointer;

function EnumWindows;
begin
  GetProcedureAddress(_EnumWindows, user32, 'EnumWindows');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumWindows]
  end;
end;

var
  _EnumThreadWindows: Pointer;

function EnumThreadWindows;
begin
  GetProcedureAddress(_EnumThreadWindows, user32, 'EnumThreadWindows');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumThreadWindows]
  end;
end;

var
  _GetClassNameA: Pointer;

function GetClassNameA;
begin
  GetProcedureAddress(_GetClassNameA, user32, 'GetClassNameA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClassNameA]
  end;
end;

var
  _GetClassNameW: Pointer;

function GetClassNameW;
begin
  GetProcedureAddress(_GetClassNameW, user32, 'GetClassNameW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClassNameW]
  end;
end;

var
  _GetClassName: Pointer;

function GetClassName;
begin
  GetProcedureAddress(_GetClassName, user32, 'GetClassName' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetClassName]
  end;
end;

var
  _GetTopWindow: Pointer;

function GetTopWindow;
begin
  GetProcedureAddress(_GetTopWindow, user32, 'GetTopWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetTopWindow]
  end;
end;

var
  _GetWindowThreadProcessId: Pointer;

function GetWindowThreadProcessId;
begin
  GetProcedureAddress(_GetWindowThreadProcessId, user32, 'GetWindowThreadProcessId');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowThreadProcessId]
  end;
end;

var
  _IsGUIThread: Pointer;

function IsGUIThread;
begin
  GetProcedureAddress(_IsGUIThread, user32, 'IsGUIThread');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsGUIThread]
  end;
end;

var
  _GetLastActivePopup: Pointer;

function GetLastActivePopup;
begin
  GetProcedureAddress(_GetLastActivePopup, user32, 'GetLastActivePopup');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetLastActivePopup]
  end;
end;

var
  _GetWindow: Pointer;

function GetWindow;
begin
  GetProcedureAddress(_GetWindow, user32, 'GetWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindow]
  end;
end;

var
  _SetWindowsHookA: Pointer;

function SetWindowsHookA;
begin
  GetProcedureAddress(_SetWindowsHookA, user32, 'SetWindowsHookA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowsHookA]
  end;
end;

var
  _SetWindowsHookW: Pointer;

function SetWindowsHookW;
begin
  GetProcedureAddress(_SetWindowsHookW, user32, 'SetWindowsHookW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowsHookW]
  end;
end;

var
  _SetWindowsHook: Pointer;

function SetWindowsHook;
begin
  GetProcedureAddress(_SetWindowsHook, user32, 'SetWindowsHook' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowsHook]
  end;
end;

var
  _UnhookWindowsHook: Pointer;

function UnhookWindowsHook;
begin
  GetProcedureAddress(_UnhookWindowsHook, user32, 'UnhookWindowsHook');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_UnhookWindowsHook]
  end;
end;

var
  _SetWindowsHookExA: Pointer;

function SetWindowsHookExA;
begin
  GetProcedureAddress(_SetWindowsHookExA, user32, 'SetWindowsHookExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowsHookExA]
  end;
end;

var
  _SetWindowsHookExW: Pointer;

function SetWindowsHookExW;
begin
  GetProcedureAddress(_SetWindowsHookExW, user32, 'SetWindowsHookExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowsHookExW]
  end;
end;

var
  _SetWindowsHookEx: Pointer;

function SetWindowsHookEx;
begin
  GetProcedureAddress(_SetWindowsHookEx, user32, 'SetWindowsHookEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWindowsHookEx]
  end;
end;

var
  _UnhookWindowsHookEx: Pointer;

function UnhookWindowsHookEx;
begin
  GetProcedureAddress(_UnhookWindowsHookEx, user32, 'UnhookWindowsHookEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_UnhookWindowsHookEx]
  end;
end;

var
  _CallNextHookEx: Pointer;

function CallNextHookEx;
begin
  GetProcedureAddress(_CallNextHookEx, user32, 'CallNextHookEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CallNextHookEx]
  end;
end;

var
  _CheckMenuRadioItem: Pointer;

function CheckMenuRadioItem;
begin
  GetProcedureAddress(_CheckMenuRadioItem, user32, 'CheckMenuRadioItem');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CheckMenuRadioItem]
  end;
end;

var
  _LoadBitmapA: Pointer;

function LoadBitmapA;
begin
  GetProcedureAddress(_LoadBitmapA, user32, 'LoadBitmapA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadBitmapA]
  end;
end;

var
  _LoadBitmapW: Pointer;

function LoadBitmapW;
begin
  GetProcedureAddress(_LoadBitmapW, user32, 'LoadBitmapW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadBitmapW]
  end;
end;

var
  _LoadBitmap: Pointer;

function LoadBitmap;
begin
  GetProcedureAddress(_LoadBitmap, user32, 'LoadBitmap' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadBitmap]
  end;
end;

var
  _LoadCursorA: Pointer;

function LoadCursorA;
begin
  GetProcedureAddress(_LoadCursorA, user32, 'LoadCursorA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadCursorA]
  end;
end;

var
  _LoadCursorW: Pointer;

function LoadCursorW;
begin
  GetProcedureAddress(_LoadCursorW, user32, 'LoadCursorW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadCursorW]
  end;
end;

var
  _LoadCursor: Pointer;

function LoadCursor;
begin
  GetProcedureAddress(_LoadCursor, user32, 'LoadCursor' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadCursor]
  end;
end;

var
  _LoadCursorFromFileA: Pointer;

function LoadCursorFromFileA;
begin
  GetProcedureAddress(_LoadCursorFromFileA, user32, 'LoadCursorFromFileA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadCursorFromFileA]
  end;
end;

var
  _LoadCursorFromFileW: Pointer;

function LoadCursorFromFileW;
begin
  GetProcedureAddress(_LoadCursorFromFileW, user32, 'LoadCursorFromFileW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadCursorFromFileW]
  end;
end;

var
  _LoadCursorFromFile: Pointer;

function LoadCursorFromFile;
begin
  GetProcedureAddress(_LoadCursorFromFile, user32, 'LoadCursorFromFile' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadCursorFromFile]
  end;
end;

var
  _CreateCursor: Pointer;

function CreateCursor;
begin
  GetProcedureAddress(_CreateCursor, user32, 'CreateCursor');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateCursor]
  end;
end;

var
  _DestroyCursor: Pointer;

function DestroyCursor;
begin
  GetProcedureAddress(_DestroyCursor, user32, 'DestroyCursor');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DestroyCursor]
  end;
end;

var
  _SetSystemCursor: Pointer;

function SetSystemCursor;
begin
  GetProcedureAddress(_SetSystemCursor, user32, 'SetSystemCursor');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetSystemCursor]
  end;
end;

var
  _LoadIconA: Pointer;

function LoadIconA;
begin
  GetProcedureAddress(_LoadIconA, user32, 'LoadIconA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadIconA]
  end;
end;

var
  _LoadIconW: Pointer;

function LoadIconW;
begin
  GetProcedureAddress(_LoadIconW, user32, 'LoadIconW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadIconW]
  end;
end;

var
  _LoadIcon: Pointer;

function LoadIcon;
begin
  GetProcedureAddress(_LoadIcon, user32, 'LoadIcon' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadIcon]
  end;
end;

var
  _PrivateExtractIconsA: Pointer;

function PrivateExtractIconsA;
begin
  GetProcedureAddress(_PrivateExtractIconsA, user32, 'PrivateExtractIconsA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PrivateExtractIconsA]
  end;
end;

var
  _PrivateExtractIconsW: Pointer;

function PrivateExtractIconsW;
begin
  GetProcedureAddress(_PrivateExtractIconsW, user32, 'PrivateExtractIconsW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PrivateExtractIconsW]
  end;
end;

var
  _PrivateExtractIcons: Pointer;

function PrivateExtractIcons;
begin
  GetProcedureAddress(_PrivateExtractIcons, user32, 'PrivateExtractIcons' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_PrivateExtractIcons]
  end;
end;

var
  _CreateIcon: Pointer;

function CreateIcon;
begin
  GetProcedureAddress(_CreateIcon, user32, 'CreateIcon');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateIcon]
  end;
end;

var
  _DestroyIcon: Pointer;

function DestroyIcon;
begin
  GetProcedureAddress(_DestroyIcon, user32, 'DestroyIcon');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DestroyIcon]
  end;
end;

var
  _LookupIconIdFromDirectory: Pointer;

function LookupIconIdFromDirectory;
begin
  GetProcedureAddress(_LookupIconIdFromDirectory, user32, 'LookupIconIdFromDirectory');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LookupIconIdFromDirectory]
  end;
end;

var
  _LookupIconIdFromDirectoryEx: Pointer;

function LookupIconIdFromDirectoryEx;
begin
  GetProcedureAddress(_LookupIconIdFromDirectoryEx, user32, 'LookupIconIdFromDirectoryEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LookupIconIdFromDirectoryEx]
  end;
end;

var
  _CreateIconFromResource: Pointer;

function CreateIconFromResource;
begin
  GetProcedureAddress(_CreateIconFromResource, user32, 'CreateIconFromResource');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateIconFromResource]
  end;
end;

var
  _CreateIconFromResourceEx: Pointer;

function CreateIconFromResourceEx;
begin
  GetProcedureAddress(_CreateIconFromResourceEx, user32, 'CreateIconFromResourceEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateIconFromResourceEx]
  end;
end;

var
  _LoadImageA: Pointer;

function LoadImageA;
begin
  GetProcedureAddress(_LoadImageA, user32, 'LoadImageA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadImageA]
  end;
end;

var
  _LoadImageW: Pointer;

function LoadImageW;
begin
  GetProcedureAddress(_LoadImageW, user32, 'LoadImageW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadImageW]
  end;
end;

var
  _LoadImage: Pointer;

function LoadImage;
begin
  GetProcedureAddress(_LoadImage, user32, 'LoadImage' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadImage]
  end;
end;

var
  _CopyImage: Pointer;

function CopyImage;
begin
  GetProcedureAddress(_CopyImage, user32, 'CopyImage');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CopyImage]
  end;
end;

var
  _DrawIconEx: Pointer;

function DrawIconEx;
begin
  GetProcedureAddress(_DrawIconEx, user32, 'DrawIconEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DrawIconEx]
  end;
end;

var
  _CreateIconIndirect: Pointer;

function CreateIconIndirect;
begin
  GetProcedureAddress(_CreateIconIndirect, user32, 'CreateIconIndirect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateIconIndirect]
  end;
end;

var
  _CopyIcon: Pointer;

function CopyIcon;
begin
  GetProcedureAddress(_CopyIcon, user32, 'CopyIcon');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CopyIcon]
  end;
end;

var
  _GetIconInfo: Pointer;

function GetIconInfo;
begin
  GetProcedureAddress(_GetIconInfo, user32, 'GetIconInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetIconInfo]
  end;
end;

var
  _LoadStringA: Pointer;

function LoadStringA;
begin
  GetProcedureAddress(_LoadStringA, user32, 'LoadStringA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadStringA]
  end;
end;

var
  _LoadStringW: Pointer;

function LoadStringW;
begin
  GetProcedureAddress(_LoadStringW, user32, 'LoadStringW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadStringW]
  end;
end;

var
  _LoadString: Pointer;

function LoadString;
begin
  GetProcedureAddress(_LoadString, user32, 'LoadString' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LoadString]
  end;
end;

var
  _IsDialogMessageA: Pointer;

function IsDialogMessageA;
begin
  GetProcedureAddress(_IsDialogMessageA, user32, 'IsDialogMessageA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsDialogMessageA]
  end;
end;

var
  _IsDialogMessageW: Pointer;

function IsDialogMessageW;
begin
  GetProcedureAddress(_IsDialogMessageW, user32, 'IsDialogMessageW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsDialogMessageW]
  end;
end;

var
  _IsDialogMessage: Pointer;

function IsDialogMessage;
begin
  GetProcedureAddress(_IsDialogMessage, user32, 'IsDialogMessage' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsDialogMessage]
  end;
end;

var
  _MapDialogRect: Pointer;

function MapDialogRect;
begin
  GetProcedureAddress(_MapDialogRect, user32, 'MapDialogRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MapDialogRect]
  end;
end;

var
  _DlgDirListA: Pointer;

function DlgDirListA;
begin
  GetProcedureAddress(_DlgDirListA, user32, 'DlgDirListA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DlgDirListA]
  end;
end;

var
  _DlgDirListW: Pointer;

function DlgDirListW;
begin
  GetProcedureAddress(_DlgDirListW, user32, 'DlgDirListW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DlgDirListW]
  end;
end;

var
  _DlgDirList: Pointer;

function DlgDirList;
begin
  GetProcedureAddress(_DlgDirList, user32, 'DlgDirList' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DlgDirList]
  end;
end;

var
  _DlgDirSelectExA: Pointer;

function DlgDirSelectExA;
begin
  GetProcedureAddress(_DlgDirSelectExA, user32, 'DlgDirSelectExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DlgDirSelectExA]
  end;
end;

var
  _DlgDirSelectExW: Pointer;

function DlgDirSelectExW;
begin
  GetProcedureAddress(_DlgDirSelectExW, user32, 'DlgDirSelectExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DlgDirSelectExW]
  end;
end;

var
  _DlgDirSelectEx: Pointer;

function DlgDirSelectEx;
begin
  GetProcedureAddress(_DlgDirSelectEx, user32, 'DlgDirSelectEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DlgDirSelectEx]
  end;
end;

var
  _DlgDirListComboBoxA: Pointer;

function DlgDirListComboBoxA;
begin
  GetProcedureAddress(_DlgDirListComboBoxA, user32, 'DlgDirListComboBoxA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DlgDirListComboBoxA]
  end;
end;

var
  _DlgDirListComboBoxW: Pointer;

function DlgDirListComboBoxW;
begin
  GetProcedureAddress(_DlgDirListComboBoxW, user32, 'DlgDirListComboBoxW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DlgDirListComboBoxW]
  end;
end;

var
  _DlgDirListComboBox: Pointer;

function DlgDirListComboBox;
begin
  GetProcedureAddress(_DlgDirListComboBox, user32, 'DlgDirListComboBox' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DlgDirListComboBox]
  end;
end;

var
  _DlgDirSelectComboBoxExA: Pointer;

function DlgDirSelectComboBoxExA;
begin
  GetProcedureAddress(_DlgDirSelectComboBoxExA, user32, 'DlgDirSelectComboBoxExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DlgDirSelectComboBoxExA]
  end;
end;

var
  _DlgDirSelectComboBoxExW: Pointer;

function DlgDirSelectComboBoxExW;
begin
  GetProcedureAddress(_DlgDirSelectComboBoxExW, user32, 'DlgDirSelectComboBoxExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DlgDirSelectComboBoxExW]
  end;
end;

var
  _DlgDirSelectComboBoxEx: Pointer;

function DlgDirSelectComboBoxEx;
begin
  GetProcedureAddress(_DlgDirSelectComboBoxEx, user32, 'DlgDirSelectComboBoxEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DlgDirSelectComboBoxEx]
  end;
end;

var
  _SetScrollInfo: Pointer;

function SetScrollInfo;
begin
  GetProcedureAddress(_SetScrollInfo, user32, 'SetScrollInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetScrollInfo]
  end;
end;

var
  _GetScrollInfo: Pointer;

function GetScrollInfo;
begin
  GetProcedureAddress(_GetScrollInfo, user32, 'GetScrollInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetScrollInfo]
  end;
end;

var
  _DefFrameProcA: Pointer;

function DefFrameProcA;
begin
  GetProcedureAddress(_DefFrameProcA, user32, 'DefFrameProcA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DefFrameProcA]
  end;
end;

var
  _DefFrameProcW: Pointer;

function DefFrameProcW;
begin
  GetProcedureAddress(_DefFrameProcW, user32, 'DefFrameProcW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DefFrameProcW]
  end;
end;

var
  _DefFrameProc: Pointer;

function DefFrameProc;
begin
  GetProcedureAddress(_DefFrameProc, user32, 'DefFrameProc' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DefFrameProc]
  end;
end;

var
  _DefMDIChildProcA: Pointer;

function DefMDIChildProcA;
begin
  GetProcedureAddress(_DefMDIChildProcA, user32, 'DefMDIChildProcA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DefMDIChildProcA]
  end;
end;

var
  _DefMDIChildProcW: Pointer;

function DefMDIChildProcW;
begin
  GetProcedureAddress(_DefMDIChildProcW, user32, 'DefMDIChildProcW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DefMDIChildProcW]
  end;
end;

var
  _DefMDIChildProc: Pointer;

function DefMDIChildProc;
begin
  GetProcedureAddress(_DefMDIChildProc, user32, 'DefMDIChildProc' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DefMDIChildProc]
  end;
end;

var
  _TranslateMDISysAccel: Pointer;

function TranslateMDISysAccel;
begin
  GetProcedureAddress(_TranslateMDISysAccel, user32, 'TranslateMDISysAccel');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_TranslateMDISysAccel]
  end;
end;

var
  _ArrangeIconicWindows: Pointer;

function ArrangeIconicWindows;
begin
  GetProcedureAddress(_ArrangeIconicWindows, user32, 'ArrangeIconicWindows');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ArrangeIconicWindows]
  end;
end;

var
  _CreateMDIWindowA: Pointer;

function CreateMDIWindowA;
begin
  GetProcedureAddress(_CreateMDIWindowA, user32, 'CreateMDIWindowA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateMDIWindowA]
  end;
end;

var
  _CreateMDIWindowW: Pointer;

function CreateMDIWindowW;
begin
  GetProcedureAddress(_CreateMDIWindowW, user32, 'CreateMDIWindowW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateMDIWindowW]
  end;
end;

var
  _CreateMDIWindow: Pointer;

function CreateMDIWindow;
begin
  GetProcedureAddress(_CreateMDIWindow, user32, 'CreateMDIWindow' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CreateMDIWindow]
  end;
end;

var
  _TileWindows: Pointer;

function TileWindows;
begin
  GetProcedureAddress(_TileWindows, user32, 'TileWindows');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_TileWindows]
  end;
end;

var
  _CascadeWindows: Pointer;

function CascadeWindows;
begin
  GetProcedureAddress(_CascadeWindows, user32, 'CascadeWindows');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_CascadeWindows]
  end;
end;

var
  _WinHelpA: Pointer;

function WinHelpA;
begin
  GetProcedureAddress(_WinHelpA, user32, 'WinHelpA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_WinHelpA]
  end;
end;

var
  _WinHelpW: Pointer;

function WinHelpW;
begin
  GetProcedureAddress(_WinHelpW, user32, 'WinHelpW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_WinHelpW]
  end;
end;

var
  _WinHelp: Pointer;

function WinHelp;
begin
  GetProcedureAddress(_WinHelp, user32, 'WinHelp' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_WinHelp]
  end;
end;

var
  _GetGuiResources: Pointer;

function GetGuiResources;
begin
  GetProcedureAddress(_GetGuiResources, user32, 'GetGuiResources');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetGuiResources]
  end;
end;

var
  _ChangeDisplaySettingsA: Pointer;

function ChangeDisplaySettingsA;
begin
  GetProcedureAddress(_ChangeDisplaySettingsA, user32, 'ChangeDisplaySettingsA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ChangeDisplaySettingsA]
  end;
end;

var
  _ChangeDisplaySettingsW: Pointer;

function ChangeDisplaySettingsW;
begin
  GetProcedureAddress(_ChangeDisplaySettingsW, user32, 'ChangeDisplaySettingsW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ChangeDisplaySettingsW]
  end;
end;

var
  _ChangeDisplaySettings: Pointer;

function ChangeDisplaySettings;
begin
  GetProcedureAddress(_ChangeDisplaySettings, user32, 'ChangeDisplaySettings' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ChangeDisplaySettings]
  end;
end;

var
  _ChangeDisplaySettingsExA: Pointer;

function ChangeDisplaySettingsExA;
begin
  GetProcedureAddress(_ChangeDisplaySettingsExA, user32, 'ChangeDisplaySettingsExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ChangeDisplaySettingsExA]
  end;
end;

var
  _ChangeDisplaySettingsExW: Pointer;

function ChangeDisplaySettingsExW;
begin
  GetProcedureAddress(_ChangeDisplaySettingsExW, user32, 'ChangeDisplaySettingsExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ChangeDisplaySettingsExW]
  end;
end;

var
  _ChangeDisplaySettingsEx: Pointer;

function ChangeDisplaySettingsEx;
begin
  GetProcedureAddress(_ChangeDisplaySettingsEx, user32, 'ChangeDisplaySettingsEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_ChangeDisplaySettingsEx]
  end;
end;

var
  _EnumDisplaySettingsA: Pointer;

function EnumDisplaySettingsA;
begin
  GetProcedureAddress(_EnumDisplaySettingsA, user32, 'EnumDisplaySettingsA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDisplaySettingsA]
  end;
end;

var
  _EnumDisplaySettingsW: Pointer;

function EnumDisplaySettingsW;
begin
  GetProcedureAddress(_EnumDisplaySettingsW, user32, 'EnumDisplaySettingsW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDisplaySettingsW]
  end;
end;

var
  _EnumDisplaySettings: Pointer;

function EnumDisplaySettings;
begin
  GetProcedureAddress(_EnumDisplaySettings, user32, 'EnumDisplaySettings' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDisplaySettings]
  end;
end;

var
  _EnumDisplaySettingsExA: Pointer;

function EnumDisplaySettingsExA;
begin
  GetProcedureAddress(_EnumDisplaySettingsExA, user32, 'EnumDisplaySettingsExA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDisplaySettingsExA]
  end;
end;

var
  _EnumDisplaySettingsExW: Pointer;

function EnumDisplaySettingsExW;
begin
  GetProcedureAddress(_EnumDisplaySettingsExW, user32, 'EnumDisplaySettingsExW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDisplaySettingsExW]
  end;
end;

var
  _EnumDisplaySettingsEx: Pointer;

function EnumDisplaySettingsEx;
begin
  GetProcedureAddress(_EnumDisplaySettingsEx, user32, 'EnumDisplaySettingsEx' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDisplaySettingsEx]
  end;
end;

var
  _EnumDisplayDevicesA: Pointer;

function EnumDisplayDevicesA;
begin
  GetProcedureAddress(_EnumDisplayDevicesA, user32, 'EnumDisplayDevicesA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDisplayDevicesA]
  end;
end;

var
  _EnumDisplayDevicesW: Pointer;

function EnumDisplayDevicesW;
begin
  GetProcedureAddress(_EnumDisplayDevicesW, user32, 'EnumDisplayDevicesW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDisplayDevicesW]
  end;
end;

var
  _EnumDisplayDevices: Pointer;

function EnumDisplayDevices;
begin
  GetProcedureAddress(_EnumDisplayDevices, user32, 'EnumDisplayDevices' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDisplayDevices]
  end;
end;

var
  _SystemParametersInfoA: Pointer;

function SystemParametersInfoA;
begin
  GetProcedureAddress(_SystemParametersInfoA, user32, 'SystemParametersInfoA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SystemParametersInfoA]
  end;
end;

var
  _SystemParametersInfoW: Pointer;

function SystemParametersInfoW;
begin
  GetProcedureAddress(_SystemParametersInfoW, user32, 'SystemParametersInfoW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SystemParametersInfoW]
  end;
end;

var
  _SystemParametersInfo: Pointer;

function SystemParametersInfo;
begin
  GetProcedureAddress(_SystemParametersInfo, user32, 'SystemParametersInfo' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SystemParametersInfo]
  end;
end;

var
  _SetDebugErrorLevel: Pointer;

procedure SetDebugErrorLevel;
begin
  GetProcedureAddress(_SetDebugErrorLevel, user32, 'SetDebugErrorLevel');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetDebugErrorLevel]
  end;
end;

var
  _SetLastErrorEx: Pointer;

procedure SetLastErrorEx;
begin
  GetProcedureAddress(_SetLastErrorEx, user32, 'SetLastErrorEx');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetLastErrorEx]
  end;
end;

var
  _InternalGetWindowText: Pointer;

function InternalGetWindowText;
begin
  GetProcedureAddress(_InternalGetWindowText, user32, 'InternalGetWindowText');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_InternalGetWindowText]
  end;
end;

var
  _EndTask: Pointer;

function EndTask;
begin
  GetProcedureAddress(_EndTask, user32, 'EndTask');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EndTask]
  end;
end;

var
  _MonitorFromPoint: Pointer;

function MonitorFromPoint;
begin
  GetProcedureAddress(_MonitorFromPoint, user32, 'MonitorFromPoint');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MonitorFromPoint]
  end;
end;

var
  _MonitorFromRect: Pointer;

function MonitorFromRect;
begin
  GetProcedureAddress(_MonitorFromRect, user32, 'MonitorFromRect');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MonitorFromRect]
  end;
end;

var
  _MonitorFromWindow: Pointer;

function MonitorFromWindow;
begin
  GetProcedureAddress(_MonitorFromWindow, user32, 'MonitorFromWindow');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_MonitorFromWindow]
  end;
end;

var
  _GetMonitorInfoA: Pointer;

function GetMonitorInfoA;
begin
  GetProcedureAddress(_GetMonitorInfoA, user32, 'GetMonitorInfoA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMonitorInfoA]
  end;
end;

var
  _GetMonitorInfoW: Pointer;

function GetMonitorInfoW;
begin
  GetProcedureAddress(_GetMonitorInfoW, user32, 'GetMonitorInfoW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMonitorInfoW]
  end;
end;

var
  _GetMonitorInfo: Pointer;

function GetMonitorInfo;
begin
  GetProcedureAddress(_GetMonitorInfo, user32, 'GetMonitorInfo' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMonitorInfo]
  end;
end;

var
  _EnumDisplayMonitors: Pointer;

function EnumDisplayMonitors;
begin
  GetProcedureAddress(_EnumDisplayMonitors, user32, 'EnumDisplayMonitors');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_EnumDisplayMonitors]
  end;
end;

var
  _NotifyWinEvent: Pointer;

procedure NotifyWinEvent;
begin
  GetProcedureAddress(_NotifyWinEvent, user32, 'NotifyWinEvent');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_NotifyWinEvent]
  end;
end;

var
  _SetWinEventHook: Pointer;

function SetWinEventHook;
begin
  GetProcedureAddress(_SetWinEventHook, user32, 'SetWinEventHook');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_SetWinEventHook]
  end;
end;

var
  _IsWinEventHookInstalled: Pointer;

function IsWinEventHookInstalled;
begin
  GetProcedureAddress(_IsWinEventHookInstalled, user32, 'IsWinEventHookInstalled');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_IsWinEventHookInstalled]
  end;
end;

var
  _UnhookWinEvent: Pointer;

function UnhookWinEvent;
begin
  GetProcedureAddress(_UnhookWinEvent, user32, 'UnhookWinEvent');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_UnhookWinEvent]
  end;
end;

var
  _GetGUIThreadInfo: Pointer;

function GetGUIThreadInfo;
begin
  GetProcedureAddress(_GetGUIThreadInfo, user32, 'GetGUIThreadInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetGUIThreadInfo]
  end;
end;

var
  _GetWindowModuleFileNameA: Pointer;

function GetWindowModuleFileNameA;
begin
  GetProcedureAddress(_GetWindowModuleFileNameA, user32, 'GetWindowModuleFileNameA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowModuleFileNameA]
  end;
end;

var
  _GetWindowModuleFileNameW: Pointer;

function GetWindowModuleFileNameW;
begin
  GetProcedureAddress(_GetWindowModuleFileNameW, user32, 'GetWindowModuleFileNameW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowModuleFileNameW]
  end;
end;

var
  _GetWindowModuleFileName: Pointer;

function GetWindowModuleFileName;
begin
  GetProcedureAddress(_GetWindowModuleFileName, user32, 'GetWindowModuleFileName' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowModuleFileName]
  end;
end;

var
  _GetCursorInfo: Pointer;

function GetCursorInfo;
begin
  GetProcedureAddress(_GetCursorInfo, user32, 'GetCursorInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetCursorInfo]
  end;
end;

var
  _GetWindowInfo: Pointer;

function GetWindowInfo;
begin
  GetProcedureAddress(_GetWindowInfo, user32, 'GetWindowInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetWindowInfo]
  end;
end;

var
  _GetTitleBarInfo: Pointer;

function GetTitleBarInfo;
begin
  GetProcedureAddress(_GetTitleBarInfo, user32, 'GetTitleBarInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetTitleBarInfo]
  end;
end;

var
  _GetMenuBarInfo: Pointer;

function GetMenuBarInfo;
begin
  GetProcedureAddress(_GetMenuBarInfo, user32, 'GetMenuBarInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetMenuBarInfo]
  end;
end;

var
  _GetScrollBarInfo: Pointer;

function GetScrollBarInfo;
begin
  GetProcedureAddress(_GetScrollBarInfo, user32, 'GetScrollBarInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetScrollBarInfo]
  end;
end;

var
  _GetComboBoxInfo: Pointer;

function GetComboBoxInfo;
begin
  GetProcedureAddress(_GetComboBoxInfo, user32, 'GetComboBoxInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetComboBoxInfo]
  end;
end;

var
  _GetAncestor: Pointer;

function GetAncestor;
begin
  GetProcedureAddress(_GetAncestor, user32, 'GetAncestor');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetAncestor]
  end;
end;

var
  _RealChildWindowFromPoint: Pointer;

function RealChildWindowFromPoint;
begin
  GetProcedureAddress(_RealChildWindowFromPoint, user32, 'RealChildWindowFromPoint');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RealChildWindowFromPoint]
  end;
end;

var
  _RealGetWindowClassA: Pointer;

function RealGetWindowClassA;
begin
  GetProcedureAddress(_RealGetWindowClassA, user32, 'RealGetWindowClassA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RealGetWindowClassA]
  end;
end;

var
  _RealGetWindowClassW: Pointer;

function RealGetWindowClassW;
begin
  GetProcedureAddress(_RealGetWindowClassW, user32, 'RealGetWindowClassW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RealGetWindowClassW]
  end;
end;

var
  _RealGetWindowClass: Pointer;

function RealGetWindowClass;
begin
  GetProcedureAddress(_RealGetWindowClass, user32, 'RealGetWindowClass' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RealGetWindowClass]
  end;
end;

var
  _GetAltTabInfoA: Pointer;

function GetAltTabInfoA;
begin
  GetProcedureAddress(_GetAltTabInfoA, user32, 'GetAltTabInfoA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetAltTabInfoA]
  end;
end;

var
  _GetAltTabInfoW: Pointer;

function GetAltTabInfoW;
begin
  GetProcedureAddress(_GetAltTabInfoW, user32, 'GetAltTabInfoW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetAltTabInfoW]
  end;
end;

var
  _GetAltTabInfo: Pointer;

function GetAltTabInfo;
begin
  GetProcedureAddress(_GetAltTabInfo, user32, 'GetAltTabInfo' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetAltTabInfo]
  end;
end;

var
  _GetListBoxInfo: Pointer;

function GetListBoxInfo;
begin
  GetProcedureAddress(_GetListBoxInfo, user32, 'GetListBoxInfo');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetListBoxInfo]
  end;
end;

var
  _LockWorkStation: Pointer;

function LockWorkStation;
begin
  GetProcedureAddress(_LockWorkStation, user32, 'LockWorkStation');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_LockWorkStation]
  end;
end;

var
  _UserHandleGrantAccess: Pointer;

function UserHandleGrantAccess;
begin
  GetProcedureAddress(_UserHandleGrantAccess, user32, 'UserHandleGrantAccess');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_UserHandleGrantAccess]
  end;
end;

var
  _GetRawInputData: Pointer;

function GetRawInputData;
begin
  GetProcedureAddress(_GetRawInputData, user32, 'GetRawInputData');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetRawInputData]
  end;
end;

var
  _GetRawInputDeviceInfoA: Pointer;

function GetRawInputDeviceInfoA;
begin
  GetProcedureAddress(_GetRawInputDeviceInfoA, user32, 'GetRawInputDeviceInfoA');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetRawInputDeviceInfoA]
  end;
end;

var
  _GetRawInputDeviceInfoW: Pointer;

function GetRawInputDeviceInfoW;
begin
  GetProcedureAddress(_GetRawInputDeviceInfoW, user32, 'GetRawInputDeviceInfoW');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetRawInputDeviceInfoW]
  end;
end;

var
  _GetRawInputDeviceInfo: Pointer;

function GetRawInputDeviceInfo;
begin
  GetProcedureAddress(_GetRawInputDeviceInfo, user32, 'GetRawInputDeviceInfo' + AWSuffix);
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetRawInputDeviceInfo]
  end;
end;

var
  _GetRawInputBuffer: Pointer;

function GetRawInputBuffer;
begin
  GetProcedureAddress(_GetRawInputBuffer, user32, 'GetRawInputBuffer');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetRawInputBuffer]
  end;
end;

var
  _RegisterRawInputDevices: Pointer;

function RegisterRawInputDevices;
begin
  GetProcedureAddress(_RegisterRawInputDevices, user32, 'RegisterRawInputDevices');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_RegisterRawInputDevices]
  end;
end;

var
  _GetRegisteredRawInputDevices: Pointer;

function GetRegisteredRawInputDevices;
begin
  GetProcedureAddress(_GetRegisteredRawInputDevices, user32, 'GetRegisteredRawInputDevices');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetRegisteredRawInputDevices]
  end;
end;

var
  _GetRawInputDeviceList: Pointer;

function GetRawInputDeviceList;
begin
  GetProcedureAddress(_GetRawInputDeviceList, user32, 'GetRawInputDeviceList');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_GetRawInputDeviceList]
  end;
end;

var
  _DefRawInputProc: Pointer;

function DefRawInputProc;
begin
  GetProcedureAddress(_DefRawInputProc, user32, 'DefRawInputProc');
  asm
        MOV     ESP, EBP
        POP     EBP
        JMP     [_DefRawInputProc]
  end;
end;

{$ELSE}

function IsHungAppWindow; external user32 name 'IsHungAppWindow';
procedure DisableProcessWindowsGhosting; external user32 name 'DisableProcessWindowsGhosting';
function wvsprintfA; external user32 name 'wvsprintfA';
function wvsprintfW; external user32 name 'wvsprintfW';
function wvsprintf; external user32 name 'wvsprintf' + AWSuffix;
function wsprintfA; external user32 name 'wsprintfA';
function wsprintfW; external user32 name 'wsprintfW';
function wsprintf; external user32 name 'wsprintf' + AWSuffix;
function LoadKeyboardLayoutA; external user32 name 'LoadKeyboardLayoutA';
function LoadKeyboardLayoutW; external user32 name 'LoadKeyboardLayoutW';
function LoadKeyboardLayout; external user32 name 'LoadKeyboardLayout' + AWSuffix;
function ActivateKeyboardLayout; external user32 name 'ActivateKeyboardLayout';
function ToUnicodeEx; external user32 name 'ToUnicodeEx';
function UnloadKeyboardLayout; external user32 name 'UnloadKeyboardLayout';
function GetKeyboardLayoutNameA; external user32 name 'GetKeyboardLayoutNameA';
function GetKeyboardLayoutNameW; external user32 name 'GetKeyboardLayoutNameW';
function GetKeyboardLayoutName; external user32 name 'GetKeyboardLayoutName' + AWSuffix;
function GetKeyboardLayoutList; external user32 name 'GetKeyboardLayoutList';
function GetKeyboardLayout; external user32 name 'GetKeyboardLayout';
function GetMouseMovePointsEx; external user32 name 'GetMouseMovePointsEx';
function CreateDesktopA; external user32 name 'CreateDesktopA';
function CreateDesktopW; external user32 name 'CreateDesktopW';
function CreateDesktop; external user32 name 'CreateDesktop' + AWSuffix;
function OpenDesktopA; external user32 name 'OpenDesktopA';
function OpenDesktopW; external user32 name 'OpenDesktopW';
function OpenDesktop; external user32 name 'OpenDesktop' + AWSuffix;
function OpenInputDesktop; external user32 name 'OpenInputDesktop';
function EnumDesktopsA; external user32 name 'EnumDesktopsA';
function EnumDesktopsW; external user32 name 'EnumDesktopsW';
function EnumDesktops; external user32 name 'EnumDesktops' + AWSuffix;
function EnumDesktopWindows; external user32 name 'EnumDesktopWindows';
function SwitchDesktop; external user32 name 'SwitchDesktop';
function SetThreadDesktop; external user32 name 'SetThreadDesktop';
function CloseDesktop; external user32 name 'CloseDesktop';
function GetThreadDesktop; external user32 name 'GetThreadDesktop';
function CreateWindowStationA; external user32 name 'CreateWindowStationA';
function CreateWindowStationW; external user32 name 'CreateWindowStationW';
function CreateWindowStation; external user32 name 'CreateWindowStation' + AWSuffix;
function OpenWindowStationA; external user32 name 'OpenWindowStationA';
function OpenWindowStationW; external user32 name 'OpenWindowStationW';
function OpenWindowStation; external user32 name 'OpenWindowStation' + AWSuffix;
function EnumWindowStationsA; external user32 name 'EnumWindowStationsA';
function EnumWindowStationsW; external user32 name 'EnumWindowStationsW';
function EnumWindowStations; external user32 name 'EnumWindowStations' + AWSuffix;
function CloseWindowStation; external user32 name 'CloseWindowStation';
function SetProcessWindowStation; external user32 name 'SetProcessWindowStation';
function GetProcessWindowStation; external user32 name 'GetProcessWindowStation';
function SetUserObjectSecurity; external user32 name 'SetUserObjectSecurity';
function GetUserObjectSecurity; external user32 name 'GetUserObjectSecurity';
function GetUserObjectInformationA; external user32 name 'GetUserObjectInformationA';
function GetUserObjectInformationW; external user32 name 'GetUserObjectInformationW';
function GetUserObjectInformation; external user32 name 'GetUserObjectInformation' + AWSuffix;
function SetUserObjectInformationA; external user32 name 'SetUserObjectInformationA';
function SetUserObjectInformationW; external user32 name 'SetUserObjectInformationW';
function SetUserObjectInformation; external user32 name 'SetUserObjectInformation' + AWSuffix;
function RegisterWindowMessageA; external user32 name 'RegisterWindowMessageA';
function RegisterWindowMessageW; external user32 name 'RegisterWindowMessageW';
function RegisterWindowMessage; external user32 name 'RegisterWindowMessage' + AWSuffix;
function TrackMouseEvent; external user32 name 'TrackMouseEvent';
function DrawEdge; external user32 name 'DrawEdge';
function DrawFrameControl; external user32 name 'DrawFrameControl';
function DrawCaption; external user32 name 'DrawCaption';
function DrawAnimatedRects; external user32 name 'DrawAnimatedRects';
function GetMessageA; external user32 name 'GetMessageA';
function GetMessageW; external user32 name 'GetMessageW';
function GetMessage; external user32 name 'GetMessage' + AWSuffix;
function TranslateMessage; external user32 name 'TranslateMessage';
function DispatchMessageA; external user32 name 'DispatchMessageA';
function DispatchMessageW; external user32 name 'DispatchMessageW';
function DispatchMessage; external user32 name 'DispatchMessage' + AWSuffix;
function SetMessageQueue; external user32 name 'SetMessageQueue';
function PeekMessageA; external user32 name 'PeekMessageA';
function PeekMessageW; external user32 name 'PeekMessageW';
function PeekMessage; external user32 name 'PeekMessage' + AWSuffix;
function RegisterHotKey; external user32 name 'RegisterHotKey';
function UnregisterHotKey; external user32 name 'UnregisterHotKey';
function ExitWindowsEx; external user32 name 'ExitWindowsEx';
function SwapMouseButton; external user32 name 'SwapMouseButton';
function GetMessagePos; external user32 name 'GetMessagePos';
function GetMessageTime; external user32 name 'GetMessageTime';
function GetMessageExtraInfo; external user32 name 'GetMessageExtraInfo';
function SetMessageExtraInfo; external user32 name 'SetMessageExtraInfo';
function SendMessageA; external user32 name 'SendMessageA';
function SendMessageW; external user32 name 'SendMessageW';
function SendMessage; external user32 name 'SendMessage' + AWSuffix;
function SendMessageTimeoutA; external user32 name 'SendMessageTimeoutA';
function SendMessageTimeoutW; external user32 name 'SendMessageTimeoutW';
function SendMessageTimeout; external user32 name 'SendMessageTimeout' + AWSuffix;
function SendNotifyMessageA; external user32 name 'SendNotifyMessageA';
function SendNotifyMessageW; external user32 name 'SendNotifyMessageW';
function SendNotifyMessage; external user32 name 'SendNotifyMessage' + AWSuffix;
function SendMessageCallbackA; external user32 name 'SendMessageCallbackA';
function SendMessageCallbackW; external user32 name 'SendMessageCallbackW';
function SendMessageCallback; external user32 name 'SendMessageCallback' + AWSuffix;
function BroadcastSystemMessageExA; external user32 name 'BroadcastSystemMessageExA';
function BroadcastSystemMessageExW; external user32 name 'BroadcastSystemMessageExW';
function BroadcastSystemMessageEx; external user32 name 'BroadcastSystemMessageEx' + AWSuffix;
function BroadcastSystemMessageA; external user32 name 'BroadcastSystemMessageA';
function BroadcastSystemMessageW; external user32 name 'BroadcastSystemMessageW';
function BroadcastSystemMessage; external user32 name 'BroadcastSystemMessage' + AWSuffix;
function RegisterDeviceNotificationA; external user32 name 'RegisterDeviceNotificationA';
function RegisterDeviceNotificationW; external user32 name 'RegisterDeviceNotificationW';
function RegisterDeviceNotification; external user32 name 'RegisterDeviceNotification' + AWSuffix;
function UnregisterDeviceNotification; external user32 name 'UnregisterDeviceNotification';
function PostMessageA; external user32 name 'PostMessageA';
function PostMessageW; external user32 name 'PostMessageW';
function PostMessage; external user32 name 'PostMessage' + AWSuffix;
function PostThreadMessageA; external user32 name 'PostThreadMessageA';
function PostThreadMessageW; external user32 name 'PostThreadMessageW';
function PostThreadMessage; external user32 name 'PostThreadMessage' + AWSuffix;
function AttachThreadInput; external user32 name 'AttachThreadInput';
function ReplyMessage; external user32 name 'ReplyMessage';
function WaitMessage; external user32 name 'WaitMessage';
function WaitForInputIdle; external user32 name 'WaitForInputIdle';
function DefWindowProcA; external user32 name 'DefWindowProcA';
function DefWindowProcW; external user32 name 'DefWindowProcW';
function DefWindowProc; external user32 name 'DefWindowProc' + AWSuffix;
procedure PostQuitMessage; external user32 name 'PostQuitMessage';
function CallWindowProcA; external user32 name 'CallWindowProcA';
function CallWindowProcW; external user32 name 'CallWindowProcW';
function CallWindowProc; external user32 name 'CallWindowProc' + AWSuffix;
function InSendMessage; external user32 name 'InSendMessage';
function InSendMessageEx; external user32 name 'InSendMessageEx';
function GetDoubleClickTime; external user32 name 'GetDoubleClickTime';
function SetDoubleClickTime; external user32 name 'SetDoubleClickTime';
function RegisterClassA; external user32 name 'RegisterClassA';
function RegisterClassW; external user32 name 'RegisterClassW';
function RegisterClass; external user32 name 'RegisterClass' + AWSuffix;
function UnregisterClassA; external user32 name 'UnregisterClassA';
function UnregisterClassW; external user32 name 'UnregisterClassW';
function UnregisterClass; external user32 name 'UnregisterClass' + AWSuffix;
function GetClassInfoA; external user32 name 'GetClassInfoA';
function GetClassInfoW; external user32 name 'GetClassInfoW';
function GetClassInfo; external user32 name 'GetClassInfo' + AWSuffix;
function RegisterClassExA; external user32 name 'RegisterClassExA';
function RegisterClassExW; external user32 name 'RegisterClassExW';
function RegisterClassEx; external user32 name 'RegisterClassEx' + AWSuffix;
function GetClassInfoExA; external user32 name 'GetClassInfoExA';
function GetClassInfoExW; external user32 name 'GetClassInfoExW';
function GetClassInfoEx; external user32 name 'GetClassInfoEx' + AWSuffix;
function CreateWindowExA; external user32 name 'CreateWindowExA';
function CreateWindowExW; external user32 name 'CreateWindowExW';
function CreateWindowEx; external user32 name 'CreateWindowEx' + AWSuffix;
function IsWindow; external user32 name 'IsWindow';
function IsMenu; external user32 name 'IsMenu';
function IsChild; external user32 name 'IsChild';
function DestroyWindow; external user32 name 'DestroyWindow';
function ShowWindow; external user32 name 'ShowWindow';
function AnimateWindow; external user32 name 'AnimateWindow';
function UpdateLayeredWindow; external user32 name 'UpdateLayeredWindow';
function GetLayeredWindowAttributes; external user32 name 'GetLayeredWindowAttributes';
function PrintWindow; external user32 name 'PrintWindow';
function SetLayeredWindowAttributes; external user32 name 'SetLayeredWindowAttributes';
function ShowWindowAsync; external user32 name 'ShowWindowAsync';
function FlashWindow; external user32 name 'FlashWindow';
function FlashWindowEx; external user32 name 'FlashWindowEx';
function ShowOwnedPopups; external user32 name 'ShowOwnedPopups';
function OpenIcon; external user32 name 'OpenIcon';
function CloseWindow; external user32 name 'CloseWindow';
function MoveWindow; external user32 name 'MoveWindow';
function SetWindowPos; external user32 name 'SetWindowPos';
function GetWindowPlacement; external user32 name 'GetWindowPlacement';
function SetWindowPlacement; external user32 name 'SetWindowPlacement';
function BeginDeferWindowPos; external user32 name 'BeginDeferWindowPos';
function DeferWindowPos; external user32 name 'DeferWindowPos';
function EndDeferWindowPos; external user32 name 'EndDeferWindowPos';
function IsWindowVisible; external user32 name 'IsWindowVisible';
function IsIconic; external user32 name 'IsIconic';
function AnyPopup; external user32 name 'AnyPopup';
function BringWindowToTop; external user32 name 'BringWindowToTop';
function IsZoomed; external user32 name 'IsZoomed';
function CreateDialogParamA; external user32 name 'CreateDialogParamA';
function CreateDialogParamW; external user32 name 'CreateDialogParamW';
function CreateDialogParam; external user32 name 'CreateDialogParam' + AWSuffix;
function CreateDialogIndirectParamA; external user32 name 'CreateDialogIndirectParamA';
function CreateDialogIndirectParamW; external user32 name 'CreateDialogIndirectParamW';
function CreateDialogIndirectParam; external user32 name 'CreateDialogIndirectParam' + AWSuffix;
function DialogBoxParamA; external user32 name 'DialogBoxParamA';
function DialogBoxParamW; external user32 name 'DialogBoxParamW';
function DialogBoxParam; external user32 name 'DialogBoxParam' + AWSuffix;
function DialogBoxIndirectParamA; external user32 name 'DialogBoxIndirectParamA';
function DialogBoxIndirectParamW; external user32 name 'DialogBoxIndirectParamW';
function DialogBoxIndirectParam; external user32 name 'DialogBoxIndirectParam' + AWSuffix;
function EndDialog; external user32 name 'EndDialog';
function GetDlgItem; external user32 name 'GetDlgItem';
function SetDlgItemInt; external user32 name 'SetDlgItemInt';
function GetDlgItemInt; external user32 name 'GetDlgItemInt';
function SetDlgItemTextA; external user32 name 'SetDlgItemTextA';
function SetDlgItemTextW; external user32 name 'SetDlgItemTextW';
function SetDlgItemText; external user32 name 'SetDlgItemText' + AWSuffix;
function GetDlgItemTextA; external user32 name 'GetDlgItemTextA';
function GetDlgItemTextW; external user32 name 'GetDlgItemTextW';
function GetDlgItemText; external user32 name 'GetDlgItemText' + AWSuffix;
function CheckDlgButton; external user32 name 'CheckDlgButton';
function CheckRadioButton; external user32 name 'CheckRadioButton';
function IsDlgButtonChecked; external user32 name 'IsDlgButtonChecked';
function SendDlgItemMessageA; external user32 name 'SendDlgItemMessageA';
function SendDlgItemMessageW; external user32 name 'SendDlgItemMessageW';
function SendDlgItemMessage; external user32 name 'SendDlgItemMessage' + AWSuffix;
function GetNextDlgGroupItem; external user32 name 'GetNextDlgGroupItem';
function GetNextDlgTabItem; external user32 name 'GetNextDlgTabItem';
function GetDlgCtrlID; external user32 name 'GetDlgCtrlID';
function GetDialogBaseUnits; external user32 name 'GetDialogBaseUnits';
function DefDlgProcA; external user32 name 'DefDlgProcA';
function DefDlgProcW; external user32 name 'DefDlgProcW';
function DefDlgProc; external user32 name 'DefDlgProc' + AWSuffix;
function CallMsgFilterA; external user32 name 'CallMsgFilterA';
function CallMsgFilterW; external user32 name 'CallMsgFilterW';
function CallMsgFilter; external user32 name 'CallMsgFilter' + AWSuffix;
function OpenClipboard; external user32 name 'OpenClipboard';
function CloseClipboard; external user32 name 'CloseClipboard';
function GetClipboardSequenceNumber; external user32 name 'GetClipboardSequenceNumber';
function GetClipboardOwner; external user32 name 'GetClipboardOwner';
function SetClipboardViewer; external user32 name 'SetClipboardViewer';
function GetClipboardViewer; external user32 name 'GetClipboardViewer';
function ChangeClipboardChain; external user32 name 'ChangeClipboardChain';
function SetClipboardData; external user32 name 'SetClipboardData';
function GetClipboardData; external user32 name 'GetClipboardData';
function RegisterClipboardFormatA; external user32 name 'RegisterClipboardFormatA';
function RegisterClipboardFormatW; external user32 name 'RegisterClipboardFormatW';
function RegisterClipboardFormat; external user32 name 'RegisterClipboardFormat' + AWSuffix;
function CountClipboardFormats; external user32 name 'CountClipboardFormats';
function EnumClipboardFormats; external user32 name 'EnumClipboardFormats';
function GetClipboardFormatNameA; external user32 name 'GetClipboardFormatNameA';
function GetClipboardFormatNameW; external user32 name 'GetClipboardFormatNameW';
function GetClipboardFormatName; external user32 name 'GetClipboardFormatName' + AWSuffix;
function EmptyClipboard; external user32 name 'EmptyClipboard';
function IsClipboardFormatAvailable; external user32 name 'IsClipboardFormatAvailable';
function GetPriorityClipboardFormat; external user32 name 'GetPriorityClipboardFormat';
function GetOpenClipboardWindow; external user32 name 'GetOpenClipboardWindow';
function CharToOemA; external user32 name 'CharToOemA';
function CharToOemW; external user32 name 'CharToOemW';
function CharToOem; external user32 name 'CharToOem' + AWSuffix;
function OemToCharA; external user32 name 'OemToCharA';
function OemToCharW; external user32 name 'OemToCharW';
function OemToChar; external user32 name 'OemToChar' + AWSuffix;
function CharToOemBuffA; external user32 name 'CharToOemBuffA';
function CharToOemBuffW; external user32 name 'CharToOemBuffW';
function CharToOemBuff; external user32 name 'CharToOemBuff' + AWSuffix;
function OemToCharBuffA; external user32 name 'OemToCharBuffA';
function OemToCharBuffW; external user32 name 'OemToCharBuffW';
function OemToCharBuff; external user32 name 'OemToCharBuff' + AWSuffix;
function CharUpperA; external user32 name 'CharUpperA';
function CharUpperW; external user32 name 'CharUpperW';
function CharUpper; external user32 name 'CharUpper' + AWSuffix;
function CharUpperBuffA; external user32 name 'CharUpperBuffA';
function CharUpperBuffW; external user32 name 'CharUpperBuffW';
function CharUpperBuff; external user32 name 'CharUpperBuff' + AWSuffix;
function CharLowerA; external user32 name 'CharLowerA';
function CharLowerW; external user32 name 'CharLowerW';
function CharLower; external user32 name 'CharLower' + AWSuffix;
function CharLowerBuffA; external user32 name 'CharLowerBuffA';
function CharLowerBuffW; external user32 name 'CharLowerBuffW';
function CharLowerBuff; external user32 name 'CharLowerBuff' + AWSuffix;
function CharNextA; external user32 name 'CharNextA';
function CharNextW; external user32 name 'CharNextW';
function CharNext; external user32 name 'CharNext' + AWSuffix;
function CharPrevA; external user32 name 'CharPrevA';
function CharPrevW; external user32 name 'CharPrevW';
function CharPrev; external user32 name 'CharPrev' + AWSuffix;
function CharNextExA; external user32 name 'CharNextExA';
function CharPrevExA; external user32 name 'CharPrevExA';
function IsCharAlphaA; external user32 name 'IsCharAlphaA';
function IsCharAlphaW; external user32 name 'IsCharAlphaW';
function IsCharAlpha; external user32 name 'IsCharAlpha' + AWSuffix;
function IsCharAlphaNumericA; external user32 name 'IsCharAlphaNumericA';
function IsCharAlphaNumericW; external user32 name 'IsCharAlphaNumericW';
function IsCharAlphaNumeric; external user32 name 'IsCharAlphaNumeric' + AWSuffix;
function IsCharUpperA; external user32 name 'IsCharUpperA';
function IsCharUpperW; external user32 name 'IsCharUpperW';
function IsCharUpper; external user32 name 'IsCharUpper' + AWSuffix;
function IsCharLowerA; external user32 name 'IsCharLowerA';
function IsCharLowerW; external user32 name 'IsCharLowerW';
function IsCharLower; external user32 name 'IsCharLower' + AWSuffix;
function SetFocus; external user32 name 'SetFocus';
function GetActiveWindow; external user32 name 'GetActiveWindow';
function GetFocus; external user32 name 'GetFocus';
function GetKBCodePage; external user32 name 'GetKBCodePage';
function GetKeyState; external user32 name 'GetKeyState';
function GetAsyncKeyState; external user32 name 'GetAsyncKeyState';
function GetKeyboardState; external user32 name 'GetKeyboardState';
function SetKeyboardState; external user32 name 'SetKeyboardState';
function GetKeyNameTextA; external user32 name 'GetKeyNameTextA';
function GetKeyNameTextW; external user32 name 'GetKeyNameTextW';
function GetKeyNameText; external user32 name 'GetKeyNameText' + AWSuffix;
function GetKeyboardType; external user32 name 'GetKeyboardType';
function ToAscii; external user32 name 'ToAscii';
function ToAsciiEx; external user32 name 'ToAsciiEx';
function ToUnicode; external user32 name 'ToUnicode';
function OemKeyScan; external user32 name 'OemKeyScan';
function VkKeyScanA; external user32 name 'VkKeyScanA';
function VkKeyScanW; external user32 name 'VkKeyScanW';
function VkKeyScan; external user32 name 'VkKeyScan' + AWSuffix;
function VkKeyScanExA; external user32 name 'VkKeyScanExA';
function VkKeyScanExW; external user32 name 'VkKeyScanExW';
function VkKeyScanEx; external user32 name 'VkKeyScanEx' + AWSuffix;
procedure keybd_event; external user32 name 'keybd_event';
procedure mouse_event; external user32 name 'mouse_event';
function SendInput; external user32 name 'SendInput';
function GetLastInputInfo; external user32 name 'GetLastInputInfo';
function MapVirtualKeyA; external user32 name 'MapVirtualKeyA';
function MapVirtualKeyW; external user32 name 'MapVirtualKeyW';
function MapVirtualKey; external user32 name 'MapVirtualKey' + AWSuffix;
function MapVirtualKeyExA; external user32 name 'MapVirtualKeyExA';
function MapVirtualKeyExW; external user32 name 'MapVirtualKeyExW';
function MapVirtualKeyEx; external user32 name 'MapVirtualKeyEx' + AWSuffix;
function GetInputState; external user32 name 'GetInputState';
function GetQueueStatus; external user32 name 'GetQueueStatus';
function GetCapture; external user32 name 'GetCapture';
function SetCapture; external user32 name 'SetCapture';
function ReleaseCapture; external user32 name 'ReleaseCapture';
function MsgWaitForMultipleObjects; external user32 name 'MsgWaitForMultipleObjects';
function MsgWaitForMultipleObjectsEx; external user32 name 'MsgWaitForMultipleObjectsEx';
function SetTimer; external user32 name 'SetTimer';
function KillTimer; external user32 name 'KillTimer';
function IsWindowUnicode; external user32 name 'IsWindowUnicode';
function EnableWindow; external user32 name 'EnableWindow';
function IsWindowEnabled; external user32 name 'IsWindowEnabled';
function LoadAcceleratorsA; external user32 name 'LoadAcceleratorsA';
function LoadAcceleratorsW; external user32 name 'LoadAcceleratorsW';
function LoadAccelerators; external user32 name 'LoadAccelerators' + AWSuffix;
function CreateAcceleratorTableA; external user32 name 'CreateAcceleratorTableA';
function CreateAcceleratorTableW; external user32 name 'CreateAcceleratorTableW';
function CreateAcceleratorTable; external user32 name 'CreateAcceleratorTable' + AWSuffix;
function DestroyAcceleratorTable; external user32 name 'DestroyAcceleratorTable';
function CopyAcceleratorTableA; external user32 name 'CopyAcceleratorTableA';
function CopyAcceleratorTableW; external user32 name 'CopyAcceleratorTableW';
function CopyAcceleratorTable; external user32 name 'CopyAcceleratorTable' + AWSuffix;
function TranslateAcceleratorA; external user32 name 'TranslateAcceleratorA';
function TranslateAcceleratorW; external user32 name 'TranslateAcceleratorW';
function TranslateAccelerator; external user32 name 'TranslateAccelerator' + AWSuffix;
function GetSystemMetrics; external user32 name 'GetSystemMetrics';
function LoadMenuA; external user32 name 'LoadMenuAA';
function LoadMenuW; external user32 name 'LoadMenuWA';
function LoadMenu; external user32 name 'LoadMenu' + AWSuffix;
function LoadMenuIndirectA; external user32 name 'LoadMenuIndirectA';
function LoadMenuIndirectW; external user32 name 'LoadMenuIndirectW';
function LoadMenuIndirect; external user32 name 'LoadMenuIndirect' + AWSuffix;
function GetMenu; external user32 name 'GetMenu';
function SetMenu; external user32 name 'SetMenu';
function ChangeMenuA; external user32 name 'ChangeMenuA';
function ChangeMenuW; external user32 name 'ChangeMenuW';
function ChangeMenu; external user32 name 'ChangeMenu' + AWSuffix;
function HiliteMenuItem; external user32 name 'HiliteMenuItem';
function GetMenuStringA; external user32 name 'GetMenuStringA';
function GetMenuStringW; external user32 name 'GetMenuStringW';
function GetMenuString; external user32 name 'GetMenuString' + AWSuffix;
function GetMenuState; external user32 name 'GetMenuState';
function DrawMenuBar; external user32 name 'DrawMenuBar';
function GetSystemMenu; external user32 name 'GetSystemMenu';
function CreateMenu; external user32 name 'CreateMenu';
function CreatePopupMenu; external user32 name 'CreatePopupMenu';
function DestroyMenu; external user32 name 'DestroyMenu';
function CheckMenuItem; external user32 name 'CheckMenuItem';
function EnableMenuItem; external user32 name 'EnableMenuItem';
function GetSubMenu; external user32 name 'GetSubMenu';
function GetMenuItemID; external user32 name 'GetMenuItemID';
function GetMenuItemCount; external user32 name 'GetMenuItemCount';
function InsertMenuA; external user32 name 'InsertMenuA';
function InsertMenuW; external user32 name 'InsertMenuW';
function InsertMenu; external user32 name 'InsertMenu' + AWSuffix;
function AppendMenuA; external user32 name 'AppendMenuA';
function AppendMenuW; external user32 name 'AppendMenuW';
function AppendMenu; external user32 name 'AppendMenu' + AWSuffix;
function ModifyMenuA; external user32 name 'ModifyMenuA';
function ModifyMenuW; external user32 name 'ModifyMenuW';
function ModifyMenu; external user32 name 'ModifyMenu' + AWSuffix;
function RemoveMenu; external user32 name 'RemoveMenu';
function DeleteMenu; external user32 name 'DeleteMenu';
function SetMenuItemBitmaps; external user32 name 'SetMenuItemBitmaps';
function GetMenuCheckMarkDimensions; external user32 name 'GetMenuCheckMarkDimensions';
function TrackPopupMenu; external user32 name 'TrackPopupMenu';
function TrackPopupMenuEx; external user32 name 'TrackPopupMenuEx';
function GetMenuInfo; external user32 name 'GetMenuInfo';
function SetMenuInfo; external user32 name 'SetMenuInfo';
function EndMenu; external user32 name 'EndMenu';
function InsertMenuItemA; external user32 name 'InsertMenuItemA';
function InsertMenuItemW; external user32 name 'InsertMenuItemW';
function InsertMenuItem; external user32 name 'InsertMenuItem' + AWSuffix;
function GetMenuItemInfoA; external user32 name 'GetMenuItemInfoA';
function GetMenuItemInfoW; external user32 name 'GetMenuItemInfoW';
function GetMenuItemInfo; external user32 name 'GetMenuItemInfo' + AWSuffix;
function SetMenuItemInfoA; external user32 name 'SetMenuItemInfoA';
function SetMenuItemInfoW; external user32 name 'SetMenuItemInfoW';
function SetMenuItemInfo; external user32 name 'SetMenuItemInfo' + AWSuffix;
function GetMenuDefaultItem; external user32 name 'GetMenuDefaultItem';
function SetMenuDefaultItem; external user32 name 'SetMenuDefaultItem';
function GetMenuItemRect; external user32 name 'GetMenuItemRect';
function MenuItemFromPoint; external user32 name 'MenuItemFromPoint';
function DragObject; external user32 name 'DragObject';
function DragDetect; external user32 name 'DragDetect';
function DrawIcon; external user32 name 'DrawIcon';
function DrawTextA; external user32 name 'DrawTextA';
function DrawTextW; external user32 name 'DrawTextW';
function DrawText; external user32 name 'DrawText' + AWSuffix;
function DrawTextExA; external user32 name 'DrawTextExA';
function DrawTextExW; external user32 name 'DrawTextExW';
function DrawTextEx; external user32 name 'DrawTextEx' + AWSuffix;
function GrayStringA; external user32 name 'GrayStringA';
function GrayStringW; external user32 name 'GrayStringW';
function GrayString; external user32 name 'GrayString' + AWSuffix;
function DrawStateA; external user32 name 'DrawStateA';
function DrawStateW; external user32 name 'DrawStateW';
function DrawState; external user32 name 'DrawState' + AWSuffix;
function TabbedTextOutA; external user32 name 'TabbedTextOutA';
function TabbedTextOutW; external user32 name 'TabbedTextOutW';
function TabbedTextOut; external user32 name 'TabbedTextOut' + AWSuffix;
function GetTabbedTextExtentA; external user32 name 'GetTabbedTextExtentA';
function GetTabbedTextExtentW; external user32 name 'GetTabbedTextExtentW';
function GetTabbedTextExtent; external user32 name 'GetTabbedTextExtent' + AWSuffix;
function UpdateWindow; external user32 name 'UpdateWindow';
function SetActiveWindow; external user32 name 'SetActiveWindow';
function GetForegroundWindow; external user32 name 'GetForegroundWindow';
function PaintDesktop; external user32 name 'PaintDesktop';
procedure SwitchToThisWindow; external user32 name 'SwitchToThisWindow';
function SetForegroundWindow; external user32 name 'SetForegroundWindow';
function AllowSetForegroundWindow; external user32 name 'AllowSetForegroundWindow';
function LockSetForegroundWindow; external user32 name 'LockSetForegroundWindow';
function WindowFromDC; external user32 name 'WindowFromDC';
function GetDC; external user32 name 'GetDC';
function GetDCEx; external user32 name 'GetDCEx';
function GetWindowDC; external user32 name 'GetWindowDC';
function ReleaseDC; external user32 name 'ReleaseDC';
function BeginPaint; external user32 name 'BeginPaint';
function EndPaint; external user32 name 'EndPaint';
function GetUpdateRect; external user32 name 'GetUpdateRect';
function GetUpdateRgn; external user32 name 'GetUpdateRgn';
function SetWindowRgn; external user32 name 'SetWindowRgn';
function GetWindowRgn; external user32 name 'GetWindowRgn';
function GetWindowRgnBox; external user32 name 'GetWindowRgnBox';
function ExcludeUpdateRgn; external user32 name 'ExcludeUpdateRgn';
function InvalidateRect; external user32 name 'InvalidateRect';
function ValidateRect; external user32 name 'ValidateRect';
function InvalidateRgn; external user32 name 'InvalidateRgn';
function ValidateRgn; external user32 name 'ValidateRgn';
function RedrawWindow; external user32 name 'RedrawWindow';
function LockWindowUpdate; external user32 name 'LockWindowUpdate';
function ScrollWindow; external user32 name 'ScrollWindow';
function ScrollDC; external user32 name 'ScrollDC';
function ScrollWindowEx; external user32 name 'ScrollWindowEx';
function SetScrollPos; external user32 name 'SetScrollPos';
function GetScrollPos; external user32 name 'GetScrollPos';
function SetScrollRange; external user32 name 'SetScrollRange';
function GetScrollRange; external user32 name 'GetScrollRange';
function ShowScrollBar; external user32 name 'ShowScrollBar';
function EnableScrollBar; external user32 name 'EnableScrollBar';
function SetPropA; external user32 name 'SetPropA';
function SetPropW; external user32 name 'SetPropW';
function SetProp; external user32 name 'SetProp' + AWSuffix;
function GetPropA; external user32 name 'GetPropA';
function GetPropW; external user32 name 'GetPropW';
function GetProp; external user32 name 'GetProp' + AWSuffix;
function RemovePropA; external user32 name 'RemovePropA';
function RemovePropW; external user32 name 'RemovePropW';
function RemoveProp; external user32 name 'RemoveProp' + AWSuffix;
function EnumPropsExA; external user32 name 'EnumPropsExA';
function EnumPropsExW; external user32 name 'EnumPropsExW';
function EnumPropsEx; external user32 name 'EnumPropsEx' + AWSuffix;
function EnumPropsA; external user32 name 'EnumPropsA';
function EnumPropsW; external user32 name 'EnumPropsW';
function EnumProps; external user32 name 'EnumProps' + AWSuffix;
function SetWindowTextA; external user32 name 'SetWindowTextA';
function SetWindowTextW; external user32 name 'SetWindowTextW';
function SetWindowText; external user32 name 'SetWindowText' + AWSuffix;
function GetWindowTextA; external user32 name 'GetWindowTextA';
function GetWindowTextW; external user32 name 'GetWindowTextW';
function GetWindowText; external user32 name 'GetWindowText' + AWSuffix;
function GetWindowTextLengthA; external user32 name 'GetWindowTextLengthA';
function GetWindowTextLengthW; external user32 name 'GetWindowTextLengthW';
function GetWindowTextLength; external user32 name 'GetWindowTextLength' + AWSuffix;
function GetClientRect; external user32 name 'GetClientRect';
function GetWindowRect; external user32 name 'GetWindowRect';
function AdjustWindowRect; external user32 name 'AdjustWindowRect';
function AdjustWindowRectEx; external user32 name 'AdjustWindowRectEx';
function SetWindowContextHelpId; external user32 name 'SetWindowContextHelpId';
function GetWindowContextHelpId; external user32 name 'GetWindowContextHelpId';
function SetMenuContextHelpId; external user32 name 'SetMenuContextHelpId';
function GetMenuContextHelpId; external user32 name 'GetMenuContextHelpId';
function MessageBoxA; external user32 name 'MessageBoxA';
function MessageBoxW; external user32 name 'MessageBoxW';
function MessageBox; external user32 name 'MessageBox' + AWSuffix;
function MessageBoxExA; external user32 name 'MessageBoxExA';
function MessageBoxExW; external user32 name 'MessageBoxExW';
function MessageBoxEx; external user32 name 'MessageBoxEx' + AWSuffix;
function MessageBoxIndirectA; external user32 name 'MessageBoxIndirectA';
function MessageBoxIndirectW; external user32 name 'MessageBoxIndirectW';
function MessageBoxIndirect; external user32 name 'MessageBoxIndirect' + AWSuffix;
function MessageBeep; external user32 name 'MessageBeep';
function ShowCursor; external user32 name 'ShowCursor';
function SetCursorPos; external user32 name 'SetCursorPos';
function SetCursor; external user32 name 'SetCursor';
function GetCursorPos; external user32 name 'GetCursorPos';
function ClipCursor; external user32 name 'ClipCursor';
function GetClipCursor; external user32 name 'GetClipCursor';
function GetCursor; external user32 name 'GetCursor';
function CreateCaret; external user32 name 'CreateCaret';
function GetCaretBlinkTime; external user32 name 'GetCaretBlinkTime';
function SetCaretBlinkTime; external user32 name 'SetCaretBlinkTime';
function DestroyCaret; external user32 name 'DestroyCaret';
function HideCaret; external user32 name 'HideCaret';
function ShowCaret; external user32 name 'ShowCaret';
function SetCaretPos; external user32 name 'SetCaretPos';
function GetCaretPos; external user32 name 'GetCaretPos';
function ClientToScreen; external user32 name 'ClientToScreen';
function ScreenToClient; external user32 name 'ScreenToClient';
function MapWindowPoints; external user32 name 'MapWindowPoints';
function WindowFromPoint; external user32 name 'WindowFromPoint';
function ChildWindowFromPoint; external user32 name 'ChildWindowFromPoint';
function ChildWindowFromPointEx; external user32 name 'ChildWindowFromPointEx';
function GetSysColor; external user32 name 'GetSysColor';
function GetSysColorBrush; external user32 name 'GetSysColorBrush';
function SetSysColors; external user32 name 'SetSysColors';
function DrawFocusRect; external user32 name 'DrawFocusRect';
function FillRect; external user32 name 'FillRect';
function FrameRect; external user32 name 'FrameRect';
function InvertRect; external user32 name 'InvertRect';
function SetRect; external user32 name 'SetRect';
function SetRectEmpty; external user32 name 'SetRectEmpty';
function CopyRect; external user32 name 'CopyRect';
function InflateRect; external user32 name 'InflateRect';
function IntersectRect; external user32 name 'IntersectRect';
function UnionRect; external user32 name 'UnionRect';
function SubtractRect; external user32 name 'SubtractRect';
function OffsetRect; external user32 name 'OffsetRect';
function IsRectEmpty; external user32 name 'IsRectEmpty';
function EqualRect; external user32 name 'EqualRect';
function PtInRect; external user32 name 'PtInRect';
function GetWindowWord; external user32 name 'GetWindowWord';
function SetWindowWord; external user32 name 'SetWindowWord';
function GetWindowLongA; external user32 name 'GetWindowLongA';
function GetWindowLongW; external user32 name 'GetWindowLongW';
function GetWindowLong; external user32 name 'GetWindowLong' + AWSuffix;
function SetWindowLongA; external user32 name 'SetWindowLongA';
function SetWindowLongW; external user32 name 'SetWindowLongW';
function SetWindowLong; external user32 name 'SetWindowLong' + AWSuffix;
function GetClassWord; external user32 name 'GetClassWord';
function SetClassWord; external user32 name 'SetClassWord';
function GetClassLongA; external user32 name 'GetClassLongA';
function GetClassLongW; external user32 name 'GetClassLongW';
function GetClassLong; external user32 name 'GetClassLong' + AWSuffix;
function SetClassLongA; external user32 name 'SetClassLongA';
function SetClassLongW; external user32 name 'SetClassLongW';
function SetClassLong; external user32 name 'SetClassLong' + AWSuffix;
function GetProcessDefaultLayout; external user32 name 'GetProcessDefaultLayout';
function SetProcessDefaultLayout; external user32 name 'SetProcessDefaultLayout';
function GetDesktopWindow; external user32 name 'GetDesktopWindow';
function GetParent; external user32 name 'GetParent';
function SetParent; external user32 name 'SetParent';
function EnumChildWindows; external user32 name 'EnumChildWindows';
function FindWindowA; external user32 name 'FindWindowA';
function FindWindowW; external user32 name 'FindWindowW';
function FindWindow; external user32 name 'FindWindow' + AWSuffix;
function FindWindowExA; external user32 name 'FindWindowExA';
function FindWindowExW; external user32 name 'FindWindowExW';
function FindWindowEx; external user32 name 'FindWindowEx' + AWSuffix;
function GetShellWindow; external user32 name 'GetShellWindow';
function RegisterShellHookWindow; external user32 name 'RegisterShellHookWindow';
function DeregisterShellHookWindow; external user32 name 'DeregisterShellHookWindow';
function EnumWindows; external user32 name 'EnumWindows';
function EnumThreadWindows; external user32 name 'EnumThreadWindows';
function GetClassNameA; external user32 name 'GetClassNameA';
function GetClassNameW; external user32 name 'GetClassNameW';
function GetClassName; external user32 name 'GetClassName' + AWSuffix;
function GetTopWindow; external user32 name 'GetTopWindow';
function GetWindowThreadProcessId; external user32 name 'GetWindowThreadProcessId';
function IsGUIThread; external user32 name 'IsGUIThread';
function GetLastActivePopup; external user32 name 'GetLastActivePopup';
function GetWindow; external user32 name 'GetWindow';
function SetWindowsHookA; external user32 name 'SetWindowsHookA';
function SetWindowsHookW; external user32 name 'SetWindowsHookW';
function SetWindowsHook; external user32 name 'SetWindowsHook' + AWSuffix;
function UnhookWindowsHook; external user32 name 'UnhookWindowsHook';
function SetWindowsHookExA; external user32 name 'SetWindowsHookExA';
function SetWindowsHookExW; external user32 name 'SetWindowsHookExW';
function SetWindowsHookEx; external user32 name 'SetWindowsHookEx' + AWSuffix;
function UnhookWindowsHookEx; external user32 name 'UnhookWindowsHookEx';
function CallNextHookEx; external user32 name 'CallNextHookEx';
function CheckMenuRadioItem; external user32 name 'CheckMenuRadioItem';
function LoadBitmapA; external user32 name 'LoadBitmapA';
function LoadBitmapW; external user32 name 'LoadBitmapW';
function LoadBitmap; external user32 name 'LoadBitmap' + AWSuffix;
function LoadCursorA; external user32 name 'LoadCursorA';
function LoadCursorW; external user32 name 'LoadCursorW';
function LoadCursor; external user32 name 'LoadCursor' + AWSuffix;
function LoadCursorFromFileA; external user32 name 'LoadCursorFromFileA';
function LoadCursorFromFileW; external user32 name 'LoadCursorFromFileW';
function LoadCursorFromFile; external user32 name 'LoadCursorFromFile' + AWSuffix;
function CreateCursor; external user32 name 'CreateCursor';
function DestroyCursor; external user32 name 'DestroyCursor';
function SetSystemCursor; external user32 name 'SetSystemCursor';
function LoadIconA; external user32 name 'LoadIconA';
function LoadIconW; external user32 name 'LoadIconW';
function LoadIcon; external user32 name 'LoadIcon' + AWSuffix;
function PrivateExtractIconsA; external user32 name 'PrivateExtractIconsA';
function PrivateExtractIconsW; external user32 name 'PrivateExtractIconsW';
function PrivateExtractIcons; external user32 name 'PrivateExtractIcons' + AWSuffix;
function CreateIcon; external user32 name 'CreateIcon';
function DestroyIcon; external user32 name 'DestroyIcon';
function LookupIconIdFromDirectory; external user32 name 'LookupIconIdFromDirectory';
function LookupIconIdFromDirectoryEx; external user32 name 'LookupIconIdFromDirectoryEx';
function CreateIconFromResource; external user32 name 'CreateIconFromResource';
function CreateIconFromResourceEx; external user32 name 'CreateIconFromResourceEx';
function LoadImageA; external user32 name 'LoadImageA';
function LoadImageW; external user32 name 'LoadImageW';
function LoadImage; external user32 name 'LoadImage' + AWSuffix;
function CopyImage; external user32 name 'CopyImage';
function DrawIconEx; external user32 name 'DrawIconEx';
function CreateIconIndirect; external user32 name 'CreateIconIndirect';
function CopyIcon; external user32 name 'CopyIcon';
function GetIconInfo; external user32 name 'GetIconInfo';
function LoadStringA; external user32 name 'LoadStringA';
function LoadStringW; external user32 name 'LoadStringW';
function LoadString; external user32 name 'LoadString' + AWSuffix;
function IsDialogMessageA; external user32 name 'IsDialogMessageA';
function IsDialogMessageW; external user32 name 'IsDialogMessageW';
function IsDialogMessage; external user32 name 'IsDialogMessage' + AWSuffix;
function MapDialogRect; external user32 name 'MapDialogRect';
function DlgDirListA; external user32 name 'DlgDirListA';
function DlgDirListW; external user32 name 'DlgDirListW';
function DlgDirList; external user32 name 'DlgDirList' + AWSuffix;
function DlgDirSelectExA; external user32 name 'DlgDirSelectExA';
function DlgDirSelectExW; external user32 name 'DlgDirSelectExW';
function DlgDirSelectEx; external user32 name 'DlgDirSelectEx' + AWSuffix;
function DlgDirListComboBoxA; external user32 name 'DlgDirListComboBoxA';
function DlgDirListComboBoxW; external user32 name 'DlgDirListComboBoxW';
function DlgDirListComboBox; external user32 name 'DlgDirListComboBox' + AWSuffix;
function DlgDirSelectComboBoxExA; external user32 name 'DlgDirSelectComboBoxExA';
function DlgDirSelectComboBoxExW; external user32 name 'DlgDirSelectComboBoxExW';
function DlgDirSelectComboBoxEx; external user32 name 'DlgDirSelectComboBoxEx' + AWSuffix;
function SetScrollInfo; external user32 name 'SetScrollInfo';
function GetScrollInfo; external user32 name 'GetScrollInfo';
function DefFrameProcA; external user32 name 'DefFrameProcA';
function DefFrameProcW; external user32 name 'DefFrameProcW';
function DefFrameProc; external user32 name 'DefFrameProc' + AWSuffix;
function DefMDIChildProcA; external user32 name 'DefMDIChildProcA';
function DefMDIChildProcW; external user32 name 'DefMDIChildProcW';
function DefMDIChildProc; external user32 name 'DefMDIChildProc' + AWSuffix;
function TranslateMDISysAccel; external user32 name 'TranslateMDISysAccel';
function ArrangeIconicWindows; external user32 name 'ArrangeIconicWindows';
function CreateMDIWindowA; external user32 name 'CreateMDIWindowA';
function CreateMDIWindowW; external user32 name 'CreateMDIWindowW';
function CreateMDIWindow; external user32 name 'CreateMDIWindow' + AWSuffix;
function TileWindows; external user32 name 'TileWindows';
function CascadeWindows; external user32 name 'CascadeWindows';
function WinHelpA; external user32 name 'WinHelpA';
function WinHelpW; external user32 name 'WinHelpW';
function WinHelp; external user32 name 'WinHelp' + AWSuffix;
function GetGuiResources; external user32 name 'GetGuiResources';
function ChangeDisplaySettingsA; external user32 name 'ChangeDisplaySettingsA';
function ChangeDisplaySettingsW; external user32 name 'ChangeDisplaySettingsW';
function ChangeDisplaySettings; external user32 name 'ChangeDisplaySettings' + AWSuffix;
function ChangeDisplaySettingsExA; external user32 name 'ChangeDisplaySettingsExA';
function ChangeDisplaySettingsExW; external user32 name 'ChangeDisplaySettingsExW';
function ChangeDisplaySettingsEx; external user32 name 'ChangeDisplaySettingsEx' + AWSuffix;
function EnumDisplaySettingsA; external user32 name 'EnumDisplaySettingsA';
function EnumDisplaySettingsW; external user32 name 'EnumDisplaySettingsW';
function EnumDisplaySettings; external user32 name 'EnumDisplaySettings' + AWSuffix;
function EnumDisplaySettingsExA; external user32 name 'EnumDisplaySettingsExA';
function EnumDisplaySettingsExW; external user32 name 'EnumDisplaySettingsExW';
function EnumDisplaySettingsEx; external user32 name 'EnumDisplaySettingsEx' + AWSuffix;
function EnumDisplayDevicesA; external user32 name 'EnumDisplayDevicesA';
function EnumDisplayDevicesW; external user32 name 'EnumDisplayDevicesW';
function EnumDisplayDevices; external user32 name 'EnumDisplayDevices' + AWSuffix;
function SystemParametersInfoA; external user32 name 'SystemParametersInfoA';
function SystemParametersInfoW; external user32 name 'SystemParametersInfoW';
function SystemParametersInfo; external user32 name 'SystemParametersInfo' + AWSuffix;
procedure SetDebugErrorLevel; external user32 name 'SetDebugErrorLevel';
procedure SetLastErrorEx; external user32 name 'SetLastErrorEx';
function InternalGetWindowText; external user32 name 'InternalGetWindowText';
function EndTask; external user32 name 'EndTask';
function MonitorFromPoint; external user32 name 'MonitorFromPoint';
function MonitorFromRect; external user32 name 'MonitorFromRect';
function MonitorFromWindow; external user32 name 'MonitorFromWindow';
function GetMonitorInfoA; external user32 name 'GetMonitorInfoA';
function GetMonitorInfoW; external user32 name 'GetMonitorInfoW';
function GetMonitorInfo; external user32 name 'GetMonitorInfo' + AWSuffix;
function EnumDisplayMonitors; external user32 name 'EnumDisplayMonitors';
procedure NotifyWinEvent; external user32 name 'NotifyWinEvent';
function SetWinEventHook; external user32 name 'SetWinEventHook';
function IsWinEventHookInstalled; external user32 name 'IsWinEventHookInstalled';
function UnhookWinEvent; external user32 name 'UnhookWinEvent';
function GetGUIThreadInfo; external user32 name 'GetGUIThreadInfo';
function GetWindowModuleFileNameA; external user32 name 'GetWindowModuleFileNameA';
function GetWindowModuleFileNameW; external user32 name 'GetWindowModuleFileNameW';
function GetWindowModuleFileName; external user32 name 'GetWindowModuleFileName' + AWSuffix;
function GetCursorInfo; external user32 name 'GetCursorInfo';
function GetWindowInfo; external user32 name 'GetWindowInfo';
function GetTitleBarInfo; external user32 name 'GetTitleBarInfo';
function GetMenuBarInfo; external user32 name 'GetMenuBarInfo';
function GetScrollBarInfo; external user32 name 'GetScrollBarInfo';
function GetComboBoxInfo; external user32 name 'GetComboBoxInfo';
function GetAncestor; external user32 name 'GetAncestor';
function RealChildWindowFromPoint; external user32 name 'RealChildWindowFromPoint';
function RealGetWindowClassA; external user32 name 'RealGetWindowClassA';
function RealGetWindowClassW; external user32 name 'RealGetWindowClassW';
function RealGetWindowClass; external user32 name 'RealGetWindowClass' + AWSuffix;
function GetAltTabInfoA; external user32 name 'GetAltTabInfoA';
function GetAltTabInfoW; external user32 name 'GetAltTabInfoW';
function GetAltTabInfo; external user32 name 'GetAltTabInfo' + AWSuffix;
function GetListBoxInfo; external user32 name 'GetListBoxInfo';
function LockWorkStation; external user32 name 'LockWorkStation';
function UserHandleGrantAccess; external user32 name 'UserHandleGrantAccess';
function GetRawInputData; external user32 name 'GetRawInputData';
function GetRawInputDeviceInfoA; external user32 name 'GetRawInputDeviceInfoA';
function GetRawInputDeviceInfoW; external user32 name 'GetRawInputDeviceInfoW';
function GetRawInputDeviceInfo; external user32 name 'GetRawInputDeviceInfo' + AWSuffix;
function GetRawInputBuffer; external user32 name 'GetRawInputBuffer';
function RegisterRawInputDevices; external user32 name 'RegisterRawInputDevices';
function GetRegisteredRawInputDevices; external user32 name 'GetRegisteredRawInputDevices';
function GetRawInputDeviceList; external user32 name 'GetRawInputDeviceList';
function DefRawInputProc; external user32 name 'DefRawInputProc';

{$ENDIF DYNAMIC_LINK}

{$ENDIF JWA_IMPLEMENTATIONSECTION}

{$IFNDEF JWA_INCLUDEMODE}
end.
{$ENDIF !JWA_INCLUDEMODE}
