{*******************************************************}
{                                                       }
{                Delphi Runtime Library                 }
{                                                       }
{ Files: d3d11.h                                        }
{         Copyright (C) Microsoft Corporation.          }
{         All Rights Reserved.                          }
{                                                       }
{       Translator: Embarcadero Technologies, Inc.      }
{ Copyright(c) 1995-2014 Embarcadero Technologies, Inc. }
{                                                       }
{*******************************************************}
unit Winapi.D3D11;

{$ALIGN ON}
{$MINENUMSIZE 4}
{$WEAKPACKAGEUNIT}

interface

{$HPPEMIT '#include "D3D11.h"'}
{$HPPEMIT '#include "D3DCommon.h"'}
{$HPPEMIT '#include "D3D11Shader.h"'}

uses
  Winapi.DxgiFormat,
  Winapi.dxgiType,
  Winapi.dxgi,
  Winapi.d3dcommon,
  Winapi.Windows;

const
  D3D11dll = 'd3d11.dll';

const
  D3D11_16BIT_INDEX_STRIP_CUT_VALUE	= $FFFF;
  {$EXTERNALSYM D3D11_16BIT_INDEX_STRIP_CUT_VALUE}
  D3D11_32BIT_INDEX_STRIP_CUT_VALUE	= $FFFFFFFF;
  {$EXTERNALSYM D3D11_32BIT_INDEX_STRIP_CUT_VALUE}
  D3D11_8BIT_INDEX_STRIP_CUT_VALUE = $FF;
  {$EXTERNALSYM D3D11_8BIT_INDEX_STRIP_CUT_VALUE}
  D3D11_ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT = 9;
  {$EXTERNALSYM D3D11_ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT}
  D3D11_CLIP_OR_CULL_DISTANCE_COUNT = 8;
  {$EXTERNALSYM D3D11_CLIP_OR_CULL_DISTANCE_COUNT}
  D3D11_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT = 2;
  {$EXTERNALSYM D3D11_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT}
  D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT = 14;
  {$EXTERNALSYM D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT}
  D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENTS = 4;
  {$EXTERNALSYM D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENTS}
  D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT = 32;
  {$EXTERNALSYM D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT}
  D3D11_COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT = 15;
  {$EXTERNALSYM D3D11_COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT}
  D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS = 4;
  {$EXTERNALSYM D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS}
  D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT = 15;
  {$EXTERNALSYM D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT}
  D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST = 1;
  {$EXTERNALSYM D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST}
  D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS = 1;
  {$EXTERNALSYM D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS}
  D3D11_COMMONSHADER_FLOWCONTROL_NESTING_LIMIT = 64;
  {$EXTERNALSYM D3D11_COMMONSHADER_FLOWCONTROL_NESTING_LIMIT}
  D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS = 4;
  {$EXTERNALSYM D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS}
  D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT = 1;
  {$EXTERNALSYM D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT}
  D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST = 1;
  {$EXTERNALSYM D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST}
  D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS = 1;
  {$EXTERNALSYM D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS}
  D3D11_COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT = 32;
  {$EXTERNALSYM D3D11_COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT}
  D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS = 1;
  {$EXTERNALSYM D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS}
  D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT = 128;
  {$EXTERNALSYM D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT}
  D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST = 1;
  {$EXTERNALSYM D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST}
  D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS = 1;
  {$EXTERNALSYM D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS}
  D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT = 128;
  {$EXTERNALSYM D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT}
  D3D11_COMMONSHADER_SAMPLER_REGISTER_COMPONENTS = 1;
  {$EXTERNALSYM D3D11_COMMONSHADER_SAMPLER_REGISTER_COMPONENTS}
  D3D11_COMMONSHADER_SAMPLER_REGISTER_COUNT = 16;
  {$EXTERNALSYM D3D11_COMMONSHADER_SAMPLER_REGISTER_COUNT}
  D3D11_COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST = 1;
  {$EXTERNALSYM D3D11_COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST}
  D3D11_COMMONSHADER_SAMPLER_REGISTER_READ_PORTS = 1;
  {$EXTERNALSYM D3D11_COMMONSHADER_SAMPLER_REGISTER_READ_PORTS}
  D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT = 16;
  {$EXTERNALSYM D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT}
  D3D11_COMMONSHADER_SUBROUTINE_NESTING_LIMIT = 32;
  {$EXTERNALSYM D3D11_COMMONSHADER_SUBROUTINE_NESTING_LIMIT}
  D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENTS = 4;
  {$EXTERNALSYM D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENTS}
  D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT = 32;
  {$EXTERNALSYM D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_COMMONSHADER_TEMP_REGISTER_COUNT = 4096;
  {$EXTERNALSYM D3D11_COMMONSHADER_TEMP_REGISTER_COUNT}
  D3D11_COMMONSHADER_TEMP_REGISTER_READS_PER_INST = 3;
  {$EXTERNALSYM D3D11_COMMONSHADER_TEMP_REGISTER_READS_PER_INST}
  D3D11_COMMONSHADER_TEMP_REGISTER_READ_PORTS = 3;
  {$EXTERNALSYM D3D11_COMMONSHADER_TEMP_REGISTER_READ_PORTS}
  D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX = 10;
  {$EXTERNALSYM D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX}
  D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN	= 10;
  {$EXTERNALSYM D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN}
  D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE	= 8;
  {$EXTERNALSYM D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE}
  D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE = 7;
  {$EXTERNALSYM D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE}
  D3D11_CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 256;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP = 64;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 240;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP = 68;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 224;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP = 72;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 208;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP = 76;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 192;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP= 84;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 176;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP = 92;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 160;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP = 100;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 144;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP = 112;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 128;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP = 128;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 112;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP = 144;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 96;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP= 168;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 80;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP= 204;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 64;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP = 256;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 48;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP = 340;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 32;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP = 512;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD = 16;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD}
  D3D11_CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP = 768;
  {$EXTERNALSYM D3D11_CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP}
  D3D11_CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION = 1;
  {$EXTERNALSYM D3D11_CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION}
  D3D11_CS_4_X_RAW_UAV_BYTE_ALIGNMENT = 256;
  {$EXTERNALSYM D3D11_CS_4_X_RAW_UAV_BYTE_ALIGNMENT}
  D3D11_CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP = 768;
  {$EXTERNALSYM D3D11_CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP}
  D3D11_CS_4_X_THREAD_GROUP_MAX_X = 768;
  {$EXTERNALSYM D3D11_CS_4_X_THREAD_GROUP_MAX_X}
  D3D11_CS_4_X_THREAD_GROUP_MAX_Y = 768;
  {$EXTERNALSYM D3D11_CS_4_X_THREAD_GROUP_MAX_Y}
  D3D11_CS_4_X_UAV_REGISTER_COUNT = 1;
  {$EXTERNALSYM D3D11_CS_4_X_UAV_REGISTER_COUNT}
  D3D11_CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION = 65535;
  {$EXTERNALSYM D3D11_CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION}
  D3D11_CS_TGSM_REGISTER_COUNT = 8192;
  {$EXTERNALSYM D3D11_CS_TGSM_REGISTER_COUNT}
  D3D11_CS_TGSM_REGISTER_READS_PER_INST= 1;
  {$EXTERNALSYM D3D11_CS_TGSM_REGISTER_READS_PER_INST}
  D3D11_CS_TGSM_RESOURCE_REGISTER_COMPONENTS = 1;
  {$EXTERNALSYM D3D11_CS_TGSM_RESOURCE_REGISTER_COMPONENTS}
  D3D11_CS_TGSM_RESOURCE_REGISTER_READ_PORTS = 1;
  {$EXTERNALSYM D3D11_CS_TGSM_RESOURCE_REGISTER_READ_PORTS}
  D3D11_CS_THREAD_GROUP_MAX_THREADS_PER_GROUP = 1024;
  {$EXTERNALSYM D3D11_CS_THREAD_GROUP_MAX_THREADS_PER_GROUP}
  D3D11_CS_THREAD_GROUP_MAX_X = 1024;
  {$EXTERNALSYM D3D11_CS_THREAD_GROUP_MAX_X}
  D3D11_CS_THREAD_GROUP_MAX_Y = 1024;
  {$EXTERNALSYM D3D11_CS_THREAD_GROUP_MAX_Y}
  D3D11_CS_THREAD_GROUP_MAX_Z = 64;
  {$EXTERNALSYM D3D11_CS_THREAD_GROUP_MAX_Z}
  D3D11_CS_THREAD_GROUP_MIN_X = 1;
  {$EXTERNALSYM D3D11_CS_THREAD_GROUP_MIN_X}
  D3D11_CS_THREAD_GROUP_MIN_Y = 1;
  {$EXTERNALSYM D3D11_CS_THREAD_GROUP_MIN_Y}
  D3D11_CS_THREAD_GROUP_MIN_Z = 1;
  {$EXTERNALSYM D3D11_CS_THREAD_GROUP_MIN_Z}
  D3D11_CS_THREAD_LOCAL_TEMP_REGISTER_POOL = 16384;
  {$EXTERNALSYM D3D11_CS_THREAD_LOCAL_TEMP_REGISTER_POOL}
  D3D11_DEFAULT_BLEND_FACTOR_ALPHA = 1.0;
  {$EXTERNALSYM D3D11_DEFAULT_BLEND_FACTOR_ALPHA}
  D3D11_DEFAULT_BLEND_FACTOR_BLUE = 1.0;
  {$EXTERNALSYM D3D11_DEFAULT_BLEND_FACTOR_BLUE}
  D3D11_DEFAULT_BLEND_FACTOR_GREEN = 1.0;
  {$EXTERNALSYM D3D11_DEFAULT_BLEND_FACTOR_GREEN}
  D3D11_DEFAULT_BLEND_FACTOR_RED = 1.0;
  {$EXTERNALSYM D3D11_DEFAULT_BLEND_FACTOR_RED}
  D3D11_DEFAULT_BORDER_COLOR_COMPONENT = 0.0;
  {$EXTERNALSYM D3D11_DEFAULT_BORDER_COLOR_COMPONENT}
  D3D11_DEFAULT_DEPTH_BIAS = 0;
  {$EXTERNALSYM D3D11_DEFAULT_DEPTH_BIAS}
  D3D11_DEFAULT_DEPTH_BIAS_CLAMP = 0.0;
  {$EXTERNALSYM D3D11_DEFAULT_DEPTH_BIAS_CLAMP}
  D3D11_DEFAULT_MIP_LOD_BIAS = 0.0;
  {$EXTERNALSYM D3D11_DEFAULT_MIP_LOD_BIAS}
  D3D11_DEFAULT_RENDER_TARGET_ARRAY_INDEX= 0;
  {$EXTERNALSYM D3D11_DEFAULT_RENDER_TARGET_ARRAY_INDEX}
  D3D11_DEFAULT_SAMPLE_MASK	= $FFFFFFFF;
  {$EXTERNALSYM D3D11_DEFAULT_SAMPLE_MASK}
  D3D11_DEFAULT_SCISSOR_ENDX = 0;
  {$EXTERNALSYM D3D11_DEFAULT_SCISSOR_ENDX}
  D3D11_DEFAULT_SCISSOR_ENDY = 0;
  {$EXTERNALSYM D3D11_DEFAULT_SCISSOR_ENDY}
  D3D11_DEFAULT_SCISSOR_STARTX = 0 ;
  {$EXTERNALSYM D3D11_DEFAULT_SCISSOR_STARTX}
  D3D11_DEFAULT_SCISSOR_STARTY = 0 ;
  {$EXTERNALSYM D3D11_DEFAULT_SCISSOR_STARTY}
  D3D11_DEFAULT_SLOPE_SCALED_DEPTH_BIAS = 0.0;
  {$EXTERNALSYM D3D11_DEFAULT_SLOPE_SCALED_DEPTH_BIAS}
  D3D11_DEFAULT_STENCIL_READ_MASK = $ff;
  {$EXTERNALSYM D3D11_DEFAULT_STENCIL_READ_MASK}
  D3D11_DEFAULT_STENCIL_REFERENCE = 0;
  {$EXTERNALSYM D3D11_DEFAULT_STENCIL_REFERENCE}
  D3D11_DEFAULT_STENCIL_WRITE_MASK = $FF;
  {$EXTERNALSYM D3D11_DEFAULT_STENCIL_WRITE_MASK}
  D3D11_DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX  = 0;
  {$EXTERNALSYM D3D11_DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX}
  D3D11_DEFAULT_VIEWPORT_HEIGHT = 0;
  {$EXTERNALSYM D3D11_DEFAULT_VIEWPORT_HEIGHT}
  D3D11_DEFAULT_VIEWPORT_MAX_DEPTH = 0.0;
  {$EXTERNALSYM D3D11_DEFAULT_VIEWPORT_MAX_DEPTH}
  D3D11_DEFAULT_VIEWPORT_MIN_DEPTH = 0.0;
  {$EXTERNALSYM D3D11_DEFAULT_VIEWPORT_MIN_DEPTH}
  D3D11_DEFAULT_VIEWPORT_TOPLEFTX = 0;
  {$EXTERNALSYM D3D11_DEFAULT_VIEWPORT_TOPLEFTX}
  D3D11_DEFAULT_VIEWPORT_TOPLEFTY	= 0;
  {$EXTERNALSYM D3D11_DEFAULT_VIEWPORT_TOPLEFTY}
  D3D11_DEFAULT_VIEWPORT_WIDTH	= 0;
  {$EXTERNALSYM D3D11_DEFAULT_VIEWPORT_WIDTH}
  D3D11_DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS	= 3968;
  {$EXTERNALSYM D3D11_DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS}
  D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS	= 4;
  {$EXTERNALSYM D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS}
  D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COUNT	= 32;
  {$EXTERNALSYM D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COUNT}
  D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST}
  D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS}
  D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS	= 3;
  {$EXTERNALSYM D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS}
  D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COUNT	= 1;
  {$EXTERNALSYM D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COUNT}
  D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST}
  D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS}
  D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS	= 4;
  {$EXTERNALSYM D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS}
  D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT	= 32;
  {$EXTERNALSYM D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT}
  D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST}
  D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS}
  D3D11_DS_OUTPUT_REGISTER_COMPONENTS	= 4;
  {$EXTERNALSYM D3D11_DS_OUTPUT_REGISTER_COMPONENTS}
  D3D11_DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_DS_OUTPUT_REGISTER_COUNT	= 32;
  {$EXTERNALSYM D3D11_DS_OUTPUT_REGISTER_COUNT}
  D3D11_FLOAT16_FUSED_TOLERANCE_IN_ULP = 0.6;
  {$EXTERNALSYM D3D11_FLOAT16_FUSED_TOLERANCE_IN_ULP}
  D3D11_FLOAT32_MAX	=  3.402823466e+38;
  {$EXTERNALSYM D3D11_FLOAT32_MAX}
  D3D11_FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP	= 0.6;
  {$EXTERNALSYM D3D11_FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP}
  D3D11_FLOAT_TO_SRGB_EXPONENT_DENOMINATOR = 2.4;
  {$EXTERNALSYM D3D11_FLOAT_TO_SRGB_EXPONENT_DENOMINATOR}
  D3D11_FLOAT_TO_SRGB_EXPONENT_NUMERATOR = 1.0;
  {$EXTERNALSYM D3D11_FLOAT_TO_SRGB_EXPONENT_NUMERATOR}
  D3D11_FLOAT_TO_SRGB_OFFSET	= 0.055;
  {$EXTERNALSYM D3D11_FLOAT_TO_SRGB_OFFSET}
  D3D11_FLOAT_TO_SRGB_SCALE_1	= 12.92;
  {$EXTERNALSYM D3D11_FLOAT_TO_SRGB_SCALE_1}
  D3D11_FLOAT_TO_SRGB_SCALE_2	= 1.055;
  {$EXTERNALSYM D3D11_FLOAT_TO_SRGB_SCALE_2}
  D3D11_FLOAT_TO_SRGB_THRESHOLD	= 0.0031308;
  {$EXTERNALSYM D3D11_FLOAT_TO_SRGB_THRESHOLD}
  D3D11_FTOI_INSTRUCTION_MAX_INPUT = 2147483647.999;
  {$EXTERNALSYM D3D11_FTOI_INSTRUCTION_MAX_INPUT}
  D3D11_FTOI_INSTRUCTION_MIN_INPUT = -2147483648.999;
  {$EXTERNALSYM D3D11_FTOI_INSTRUCTION_MIN_INPUT}
  D3D11_FTOU_INSTRUCTION_MAX_INPUT = 4294967295.999;
  {$EXTERNALSYM D3D11_FTOU_INSTRUCTION_MAX_INPUT}
  D3D11_FTOU_INSTRUCTION_MIN_INPUT = 0.0;
  {$EXTERNALSYM D3D11_FTOU_INSTRUCTION_MIN_INPUT}
  D3D11_GS_INPUT_INSTANCE_ID_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_GS_INPUT_INSTANCE_ID_READS_PER_INST}
  D3D11_GS_INPUT_INSTANCE_ID_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_GS_INPUT_INSTANCE_ID_READ_PORTS}
  D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS	= 1;
  {$EXTERNALSYM D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS}
  D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COUNT	= 1;
  {$EXTERNALSYM D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COUNT}
  D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS	= 1;
  {$EXTERNALSYM D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS}
  D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_GS_INPUT_PRIM_CONST_REGISTER_COUNT	= 1;
  {$EXTERNALSYM D3D11_GS_INPUT_PRIM_CONST_REGISTER_COUNT}
  D3D11_GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST}
  D3D11_GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS}
  D3D11_GS_INPUT_REGISTER_COMPONENTS	= 4;
  {$EXTERNALSYM D3D11_GS_INPUT_REGISTER_COMPONENTS}
  D3D11_GS_INPUT_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_GS_INPUT_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_GS_INPUT_REGISTER_COUNT	= 32;
  {$EXTERNALSYM D3D11_GS_INPUT_REGISTER_COUNT}
  D3D11_GS_INPUT_REGISTER_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_GS_INPUT_REGISTER_READS_PER_INST}
  D3D11_GS_INPUT_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_GS_INPUT_REGISTER_READ_PORTS}
  D3D11_GS_INPUT_REGISTER_VERTICES	= 32;
  {$EXTERNALSYM D3D11_GS_INPUT_REGISTER_VERTICES}
  D3D11_GS_MAX_INSTANCE_COUNT	= 32;
  {$EXTERNALSYM D3D11_GS_MAX_INSTANCE_COUNT}
  D3D11_GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES	= 1024;
  {$EXTERNALSYM D3D11_GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES}
  D3D11_GS_OUTPUT_ELEMENTS	= 32;
  {$EXTERNALSYM D3D11_GS_OUTPUT_ELEMENTS}
  D3D11_GS_OUTPUT_REGISTER_COMPONENTS	= 4;
  {$EXTERNALSYM D3D11_GS_OUTPUT_REGISTER_COMPONENTS}
  D3D11_GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_GS_OUTPUT_REGISTER_COUNT	= 32;
  {$EXTERNALSYM D3D11_GS_OUTPUT_REGISTER_COUNT}
  D3D11_HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT	= 32;
  {$EXTERNALSYM D3D11_HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT}
  D3D11_HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT	= 32;
  {$EXTERNALSYM D3D11_HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT}
  D3D11_HS_CONTROL_POINT_REGISTER_COMPONENTS	= 4;
  {$EXTERNALSYM D3D11_HS_CONTROL_POINT_REGISTER_COMPONENTS}
  D3D11_HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_HS_CONTROL_POINT_REGISTER_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_HS_CONTROL_POINT_REGISTER_READS_PER_INST}
  D3D11_HS_CONTROL_POINT_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_HS_CONTROL_POINT_REGISTER_READ_PORTS}
  D3D11_HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND	= $FFFFFFFF;
  {$EXTERNALSYM D3D11_HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND}
  D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS	= 1;
  {$EXTERNALSYM D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS}
  D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT	= 1;
  {$EXTERNALSYM D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT}
  D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST}
  D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS}
  D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS	= 1;
  {$EXTERNALSYM D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS}
  D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT	= 1;
  {$EXTERNALSYM D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT}
  D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST}
  D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS}
  D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS	= 1;
  {$EXTERNALSYM D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS}
  D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT	= 1;
  {$EXTERNALSYM D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT}
  D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST}
  D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS}
  D3D11_HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND	= $FFFFFFFF;
  {$EXTERNALSYM D3D11_HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND}
  D3D11_HS_MAXTESSFACTOR_LOWER_BOUND = 1.0;
  {$EXTERNALSYM D3D11_HS_MAXTESSFACTOR_LOWER_BOUND}
  D3D11_HS_MAXTESSFACTOR_UPPER_BOUND = 64.0;
  {$EXTERNALSYM D3D11_HS_MAXTESSFACTOR_UPPER_BOUND}
  D3D11_HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS = 3968;
  {$EXTERNALSYM D3D11_HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS}
  D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS	= 1;
  {$EXTERNALSYM D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS}
  D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT	= 1;
  {$EXTERNALSYM D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT}
  D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST}
  D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS}
  D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS	= 4;
  {$EXTERNALSYM D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS}
  D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT	= 32;
  {$EXTERNALSYM D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT}
  D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST}
  D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS}
  D3D11_IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES	= 0;
  {$EXTERNALSYM D3D11_IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES}
  D3D11_IA_DEFAULT_PRIMITIVE_TOPOLOGY	= 0;
  {$EXTERNALSYM D3D11_IA_DEFAULT_PRIMITIVE_TOPOLOGY}
  D3D11_IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES	= 0;
  {$EXTERNALSYM D3D11_IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES}
  D3D11_IA_INDEX_INPUT_RESOURCE_SLOT_COUNT	= 1;
  {$EXTERNALSYM D3D11_IA_INDEX_INPUT_RESOURCE_SLOT_COUNT}
  D3D11_IA_INSTANCE_ID_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_IA_INSTANCE_ID_BIT_COUNT}
  D3D11_IA_INTEGER_ARITHMETIC_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_IA_INTEGER_ARITHMETIC_BIT_COUNT}
  D3D11_IA_PATCH_MAX_CONTROL_POINT_COUNT	= 32;
  {$EXTERNALSYM D3D11_IA_PATCH_MAX_CONTROL_POINT_COUNT}
  D3D11_IA_PRIMITIVE_ID_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_IA_PRIMITIVE_ID_BIT_COUNT}
  D3D11_IA_VERTEX_ID_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_IA_VERTEX_ID_BIT_COUNT}
  D3D11_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT	= 32;
  {$EXTERNALSYM D3D11_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT}
  D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS	= 128;
  {$EXTERNALSYM D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS}
  D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT	= 32;
  {$EXTERNALSYM D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT}
  D3D11_INTEGER_DIVIDE_BY_ZERO_QUOTIENT	= $FFFFFFFF;
  {$EXTERNALSYM D3D11_INTEGER_DIVIDE_BY_ZERO_QUOTIENT}
  D3D11_INTEGER_DIVIDE_BY_ZERO_REMAINDER	= $FFFFFFFF;
  {$EXTERNALSYM D3D11_INTEGER_DIVIDE_BY_ZERO_REMAINDER}
  D3D11_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL	= $FFFFFFFF;
  {$EXTERNALSYM D3D11_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL}
  D3D11_KEEP_UNORDERED_ACCESS_VIEWS	= $FFFFFFFF;
  {$EXTERNALSYM D3D11_KEEP_UNORDERED_ACCESS_VIEWS}
  D3D11_LINEAR_GAMMA = 1.0;
  {$EXTERNALSYM D3D11_LINEAR_GAMMA}
  D3D11_MAJOR_VERSION	= 11;
  {$EXTERNALSYM D3D11_MAJOR_VERSION}

  D3D11_MAX_BORDER_COLOR_COMPONENT = 1.0;
  {$EXTERNALSYM D3D11_MAX_BORDER_COLOR_COMPONENT}
  D3D11_MAX_DEPTH	= 1.0;
  {$EXTERNALSYM D3D11_MAX_DEPTH}
  D3D11_MAX_MAXANISOTROPY	= 16;
  {$EXTERNALSYM D3D11_MAX_MAXANISOTROPY}
  D3D11_MAX_MULTISAMPLE_SAMPLE_COUNT	= 32;
  {$EXTERNALSYM D3D11_MAX_MULTISAMPLE_SAMPLE_COUNT}

  D3D11_MAX_POSITION_VALUE = 3.402823466e+34;
  {$EXTERNALSYM D3D11_MAX_POSITION_VALUE}
  D3D11_MAX_TEXTURE_DIMENSION_2_TO_EXP	= 17;
  {$EXTERNALSYM D3D11_MAX_TEXTURE_DIMENSION_2_TO_EXP}
  D3D11_MINOR_VERSION	= 0;
  {$EXTERNALSYM D3D11_MINOR_VERSION}
  D3D11_MIN_BORDER_COLOR_COMPONENT = 0.0;
  {$EXTERNALSYM D3D11_MIN_BORDER_COLOR_COMPONENT}
  D3D11_MIN_DEPTH	= 0.0;
  {$EXTERNALSYM D3D11_MIN_DEPTH}
  D3D11_MIN_MAXANISOTROPY	= 0;
  {$EXTERNALSYM D3D11_MIN_MAXANISOTROPY}

  D3D11_MIP_LOD_BIAS_MAX = 15.99;
  {$EXTERNALSYM D3D11_MIP_LOD_BIAS_MAX}
  D3D11_MIP_LOD_BIAS_MIN = -16.0;
  {$EXTERNALSYM D3D11_MIP_LOD_BIAS_MIN}
  D3D11_MIP_LOD_FRACTIONAL_BIT_COUNT	= 8;
  {$EXTERNALSYM D3D11_MIP_LOD_FRACTIONAL_BIT_COUNT}
  D3D11_MIP_LOD_RANGE_BIT_COUNT	= 8;
  {$EXTERNALSYM D3D11_MIP_LOD_RANGE_BIT_COUNT}

  D3D11_MULTISAMPLE_ANTIALIAS_LINE_WIDTH = 1.4;
  {$EXTERNALSYM D3D11_MULTISAMPLE_ANTIALIAS_LINE_WIDTH}
  D3D11_NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT	= 0;
  {$EXTERNALSYM D3D11_NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT}
  D3D11_PIXEL_ADDRESS_RANGE_BIT_COUNT	= 15;
  {$EXTERNALSYM D3D11_PIXEL_ADDRESS_RANGE_BIT_COUNT}
  D3D11_PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT	= 16;
  {$EXTERNALSYM D3D11_PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT}
  D3D11_PS_CS_UAV_REGISTER_COMPONENTS	= 1;
  {$EXTERNALSYM D3D11_PS_CS_UAV_REGISTER_COMPONENTS}
  D3D11_PS_CS_UAV_REGISTER_COUNT	= 8;
  {$EXTERNALSYM D3D11_PS_CS_UAV_REGISTER_COUNT}
  D3D11_PS_CS_UAV_REGISTER_READS_PER_INST	= 1;
  {$EXTERNALSYM D3D11_PS_CS_UAV_REGISTER_READS_PER_INST}
  D3D11_PS_CS_UAV_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_PS_CS_UAV_REGISTER_READ_PORTS}
  D3D11_PS_FRONTFACING_DEFAULT_VALUE	= $FFFFFFFF;
  {$EXTERNALSYM D3D11_PS_FRONTFACING_DEFAULT_VALUE}
  D3D11_PS_FRONTFACING_FALSE_VALUE	= 0;
  {$EXTERNALSYM D3D11_PS_FRONTFACING_FALSE_VALUE}
  D3D11_PS_FRONTFACING_TRUE_VALUE	= $FFFFFFFF;
  {$EXTERNALSYM D3D11_PS_FRONTFACING_TRUE_VALUE}
  D3D11_PS_INPUT_REGISTER_COMPONENTS	= 4;
  {$EXTERNALSYM D3D11_PS_INPUT_REGISTER_COMPONENTS}
  D3D11_PS_INPUT_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_PS_INPUT_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_PS_INPUT_REGISTER_COUNT	= 32;
  {$EXTERNALSYM D3D11_PS_INPUT_REGISTER_COUNT}
  D3D11_PS_INPUT_REGISTER_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_PS_INPUT_REGISTER_READS_PER_INST}
  D3D11_PS_INPUT_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_PS_INPUT_REGISTER_READ_PORTS}

  D3D11_PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT = 0.0;
  {$EXTERNALSYM D3D11_PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT}
  D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENTS	= 1;
  {$EXTERNALSYM D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENTS}
  D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_PS_OUTPUT_DEPTH_REGISTER_COUNT	= 1;
  {$EXTERNALSYM D3D11_PS_OUTPUT_DEPTH_REGISTER_COUNT}
  D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENTS	= 1;
  {$EXTERNALSYM D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENTS}
  D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_PS_OUTPUT_MASK_REGISTER_COUNT	= 1;
  {$EXTERNALSYM D3D11_PS_OUTPUT_MASK_REGISTER_COUNT}
  D3D11_PS_OUTPUT_REGISTER_COMPONENTS	= 4;
  {$EXTERNALSYM D3D11_PS_OUTPUT_REGISTER_COMPONENTS}
  D3D11_PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_PS_OUTPUT_REGISTER_COUNT	= 8;
  {$EXTERNALSYM D3D11_PS_OUTPUT_REGISTER_COUNT}
  D3D11_PS_PIXEL_CENTER_FRACTIONAL_COMPONENT = 0.5;
  {$EXTERNALSYM D3D11_PS_PIXEL_CENTER_FRACTIONAL_COMPONENT}
  D3D11_RAW_UAV_SRV_BYTE_ALIGNMENT	= 16;
  {$EXTERNALSYM D3D11_RAW_UAV_SRV_BYTE_ALIGNMENT}
  D3D11_REQ_BLEND_OBJECT_COUNT_PER_DEVICE	= 4096;
  {$EXTERNALSYM D3D11_REQ_BLEND_OBJECT_COUNT_PER_DEVICE}
  D3D11_REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP	= 27;
  {$EXTERNALSYM D3D11_REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP}
  D3D11_REQ_CONSTANT_BUFFER_ELEMENT_COUNT	= 4096;
  {$EXTERNALSYM D3D11_REQ_CONSTANT_BUFFER_ELEMENT_COUNT}
  D3D11_REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE	= 4096;
  {$EXTERNALSYM D3D11_REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE}
  D3D11_REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP	= 32;
  {$EXTERNALSYM D3D11_REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP}
  D3D11_REQ_DRAW_VERTEX_COUNT_2_TO_EXP	= 32;
  {$EXTERNALSYM D3D11_REQ_DRAW_VERTEX_COUNT_2_TO_EXP}
  D3D11_REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION	= 16384;
  {$EXTERNALSYM D3D11_REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION}
  D3D11_REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT	= 1024;
  {$EXTERNALSYM D3D11_REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT}
  D3D11_REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT	= 4096;
  {$EXTERNALSYM D3D11_REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT}
  D3D11_REQ_MAXANISOTROPY	= 16;
  {$EXTERNALSYM D3D11_REQ_MAXANISOTROPY}
  D3D11_REQ_MIP_LEVELS	= 15;
  {$EXTERNALSYM D3D11_REQ_MIP_LEVELS}
  D3D11_REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES	= 2048;
  {$EXTERNALSYM D3D11_REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES}
  D3D11_REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE	= 4096;
  {$EXTERNALSYM D3D11_REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE}
  D3D11_REQ_RENDER_TO_BUFFER_WINDOW_WIDTH	= 16384;
  {$EXTERNALSYM D3D11_REQ_RENDER_TO_BUFFER_WINDOW_WIDTH}
  D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM	= 128;
  {$EXTERNALSYM D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM}
  D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM = 0.25;
  {$EXTERNALSYM D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM}
  D3D11_REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP	= 20;
  {$EXTERNALSYM D3D11_REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP}
  D3D11_REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE	= 4096;
  {$EXTERNALSYM D3D11_REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE}
  D3D11_REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION	= 2048;
  {$EXTERNALSYM D3D11_REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION}
  D3D11_REQ_TEXTURE1D_U_DIMENSION	= 16384;
  {$EXTERNALSYM D3D11_REQ_TEXTURE1D_U_DIMENSION}
  D3D11_REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION	= 2048;
  {$EXTERNALSYM D3D11_REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION}
  D3D11_REQ_TEXTURE2D_U_OR_V_DIMENSION	= 16384;
  {$EXTERNALSYM D3D11_REQ_TEXTURE2D_U_OR_V_DIMENSION}
  D3D11_REQ_TEXTURE3D_U_V_OR_W_DIMENSION	= 2048;
  {$EXTERNALSYM D3D11_REQ_TEXTURE3D_U_V_OR_W_DIMENSION}
  D3D11_REQ_TEXTURECUBE_DIMENSION	= 16384;
  {$EXTERNALSYM D3D11_REQ_TEXTURECUBE_DIMENSION}
  D3D11_RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL	= 0;
  {$EXTERNALSYM D3D11_RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL}
  D3D11_SHADER_MAJOR_VERSION	= 5;
  {$EXTERNALSYM D3D11_SHADER_MAJOR_VERSION}
  D3D11_SHADER_MAX_INSTANCES	= 65535;
  {$EXTERNALSYM D3D11_SHADER_MAX_INSTANCES}
  D3D11_SHADER_MAX_INTERFACES	= 253;
  {$EXTERNALSYM D3D11_SHADER_MAX_INTERFACES}
  D3D11_SHADER_MAX_INTERFACE_CALL_SITES	= 4096;
  {$EXTERNALSYM D3D11_SHADER_MAX_INTERFACE_CALL_SITES}
  D3D11_SHADER_MAX_TYPES	= 65535;
  {$EXTERNALSYM D3D11_SHADER_MAX_TYPES}
  D3D11_SHADER_MINOR_VERSION	= 0;
  {$EXTERNALSYM D3D11_SHADER_MINOR_VERSION}
  D3D11_SHIFT_INSTRUCTION_PAD_VALUE	= 0;
  {$EXTERNALSYM D3D11_SHIFT_INSTRUCTION_PAD_VALUE}
  D3D11_SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT	= 5;
  {$EXTERNALSYM D3D11_SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT}
  D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT	= 8;
  {$EXTERNALSYM D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT}
  D3D11_SO_BUFFER_MAX_STRIDE_IN_BYTES	= 2048;
  {$EXTERNALSYM D3D11_SO_BUFFER_MAX_STRIDE_IN_BYTES}
  D3D11_SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES	= 512;
  {$EXTERNALSYM D3D11_SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES}
  D3D11_SO_BUFFER_SLOT_COUNT	= 4;
  {$EXTERNALSYM D3D11_SO_BUFFER_SLOT_COUNT}
  D3D11_SO_DDI_REGISTER_INDEX_DENOTING_GAP	= $FFFFFFFF;
  {$EXTERNALSYM D3D11_SO_DDI_REGISTER_INDEX_DENOTING_GAP}
  D3D11_SO_NO_RASTERIZED_STREAM	= $FFFFFFFF;
  {$EXTERNALSYM D3D11_SO_NO_RASTERIZED_STREAM}
  D3D11_SO_OUTPUT_COMPONENT_COUNT	= 128;
  {$EXTERNALSYM D3D11_SO_OUTPUT_COMPONENT_COUNT}
  D3D11_SO_STREAM_COUNT	= 4;
  {$EXTERNALSYM D3D11_SO_STREAM_COUNT}
  D3D11_SPEC_DATE_DAY	= 04;
  {$EXTERNALSYM D3D11_SPEC_DATE_DAY}
  D3D11_SPEC_DATE_MONTH	= 06;
  {$EXTERNALSYM D3D11_SPEC_DATE_MONTH}
  D3D11_SPEC_DATE_YEAR	= 2009;
  {$EXTERNALSYM D3D11_SPEC_DATE_YEAR}
  D3D11_SPEC_VERSION = 1.0;
  {$EXTERNALSYM D3D11_SPEC_VERSION}
  D3D11_SRGB_GAMMA = 2.2;
  {$EXTERNALSYM D3D11_SRGB_GAMMA}
  D3D11_SRGB_TO_FLOAT_DENOMINATOR_1	= 12.92;
  {$EXTERNALSYM D3D11_SRGB_TO_FLOAT_DENOMINATOR_1}
  D3D11_SRGB_TO_FLOAT_DENOMINATOR_2	= 1.055;
  {$EXTERNALSYM D3D11_SRGB_TO_FLOAT_DENOMINATOR_2}
  D3D11_SRGB_TO_FLOAT_EXPONENT	= 2.4;
  {$EXTERNALSYM D3D11_SRGB_TO_FLOAT_EXPONENT}
  D3D11_SRGB_TO_FLOAT_OFFSET	= 0.055;
  {$EXTERNALSYM D3D11_SRGB_TO_FLOAT_OFFSET}
  D3D11_SRGB_TO_FLOAT_THRESHOLD	= 0.04045;
  {$EXTERNALSYM D3D11_SRGB_TO_FLOAT_THRESHOLD}
  D3D11_SRGB_TO_FLOAT_TOLERANCE_IN_ULP 	= 0.5;
  {$EXTERNALSYM D3D11_SRGB_TO_FLOAT_TOLERANCE_IN_ULP}
  D3D11_STANDARD_COMPONENT_BIT_COUNT = 32;
  {$EXTERNALSYM D3D11_STANDARD_COMPONENT_BIT_COUNT}
  D3D11_STANDARD_COMPONENT_BIT_COUNT_DOUBLED	= 64;
  {$EXTERNALSYM D3D11_STANDARD_COMPONENT_BIT_COUNT_DOUBLED}
  D3D11_STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE	= 4;
  {$EXTERNALSYM D3D11_STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE}
  D3D11_STANDARD_PIXEL_COMPONENT_COUNT	= 128;
  {$EXTERNALSYM D3D11_STANDARD_PIXEL_COMPONENT_COUNT}
  D3D11_STANDARD_PIXEL_ELEMENT_COUNT	= 32;
  {$EXTERNALSYM D3D11_STANDARD_PIXEL_ELEMENT_COUNT}
  D3D11_STANDARD_VECTOR_SIZE	= 4;
  {$EXTERNALSYM D3D11_STANDARD_VECTOR_SIZE}
  D3D11_STANDARD_VERTEX_ELEMENT_COUNT	= 32;
  {$EXTERNALSYM D3D11_STANDARD_VERTEX_ELEMENT_COUNT}
  D3D11_STANDARD_VERTEX_TOTAL_COMPONENT_COUNT	= 64;
  {$EXTERNALSYM D3D11_STANDARD_VERTEX_TOTAL_COMPONENT_COUNT}
  D3D11_SUBPIXEL_FRACTIONAL_BIT_COUNT	= 8;
  {$EXTERNALSYM D3D11_SUBPIXEL_FRACTIONAL_BIT_COUNT}
  D3D11_SUBTEXEL_FRACTIONAL_BIT_COUNT	= 8;
  {$EXTERNALSYM D3D11_SUBTEXEL_FRACTIONAL_BIT_COUNT}
  D3D11_TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR	= 64;
  {$EXTERNALSYM D3D11_TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR}
  D3D11_TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR	= 64;
  {$EXTERNALSYM D3D11_TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR}
  D3D11_TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR	= 63;
  {$EXTERNALSYM D3D11_TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR}
  D3D11_TESSELLATOR_MAX_TESSELLATION_FACTOR	= 64;
  {$EXTERNALSYM D3D11_TESSELLATOR_MAX_TESSELLATION_FACTOR}
  D3D11_TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR	= 2;
  {$EXTERNALSYM D3D11_TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR}
  D3D11_TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR	= 1;
  {$EXTERNALSYM D3D11_TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR}
  D3D11_TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR	= 1;
  {$EXTERNALSYM D3D11_TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR}
  D3D11_TEXEL_ADDRESS_RANGE_BIT_COUNT	= 16;
  {$EXTERNALSYM D3D11_TEXEL_ADDRESS_RANGE_BIT_COUNT}
  D3D11_UNBOUND_MEMORY_ACCESS_RESULT	= 0;
  {$EXTERNALSYM D3D11_UNBOUND_MEMORY_ACCESS_RESULT}
  D3D11_VIEWPORT_AND_SCISSORRECT_MAX_INDEX	= 15;
  {$EXTERNALSYM D3D11_VIEWPORT_AND_SCISSORRECT_MAX_INDEX}
  D3D11_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE	= 16;
  {$EXTERNALSYM D3D11_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE}
  D3D11_VIEWPORT_BOUNDS_MAX	= 32767;
  {$EXTERNALSYM D3D11_VIEWPORT_BOUNDS_MAX}
  D3D11_VIEWPORT_BOUNDS_MIN	= -32768;
  {$EXTERNALSYM D3D11_VIEWPORT_BOUNDS_MIN}
  D3D11_VS_INPUT_REGISTER_COMPONENTS	= 4;
  {$EXTERNALSYM D3D11_VS_INPUT_REGISTER_COMPONENTS}
  D3D11_VS_INPUT_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_VS_INPUT_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_VS_INPUT_REGISTER_COUNT	= 32;
  {$EXTERNALSYM D3D11_VS_INPUT_REGISTER_COUNT}
  D3D11_VS_INPUT_REGISTER_READS_PER_INST	= 2;
  {$EXTERNALSYM D3D11_VS_INPUT_REGISTER_READS_PER_INST}
  D3D11_VS_INPUT_REGISTER_READ_PORTS	= 1;
  {$EXTERNALSYM D3D11_VS_INPUT_REGISTER_READ_PORTS}
  D3D11_VS_OUTPUT_REGISTER_COMPONENTS	= 4;
  {$EXTERNALSYM D3D11_VS_OUTPUT_REGISTER_COMPONENTS}
  D3D11_VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT	= 32;
  {$EXTERNALSYM D3D11_VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT}
  D3D11_VS_OUTPUT_REGISTER_COUNT	= 32;
  {$EXTERNALSYM D3D11_VS_OUTPUT_REGISTER_COUNT}
  D3D11_WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT	= 10;
  {$EXTERNALSYM D3D11_WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT}
  D3D11_WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP	= 25;
  {$EXTERNALSYM D3D11_WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP}
  D3D11_WHQL_DRAW_VERTEX_COUNT_2_TO_EXP	= 25;
  {$EXTERNALSYM D3D11_WHQL_DRAW_VERTEX_COUNT_2_TO_EXP}

  _FACD3D11	= $87C;
  {$EXTERNALSYM _FACD3D11}
  _FACD3D11DEBUG =	_FACD3D11 + 1;
  {$EXTERNALSYM _FACD3D11DEBUG}

  D3D11_APPEND_ALIGNED_ELEMENT = $FFFFFFFF;
  {$EXTERNALSYM D3D11_APPEND_ALIGNED_ELEMENT}

  D3D11_FILTER_TYPE_MASK	= $3;
  {$EXTERNALSYM D3D11_FILTER_TYPE_MASK}

  D3D11_MIN_FILTER_SHIFT	= 4;
  {$EXTERNALSYM D3D11_MIN_FILTER_SHIFT}

  D3D11_MAG_FILTER_SHIFT	= 2;
  {$EXTERNALSYM D3D11_MAG_FILTER_SHIFT}

  D3D11_MIP_FILTER_SHIFT	= 0;
  {$EXTERNALSYM D3D11_MIP_FILTER_SHIFT}

  D3D11_COMPARISON_FILTERING_BIT	= $80;
  {$EXTERNALSYM D3D11_COMPARISON_FILTERING_BIT}

  D3D11_ANISOTROPIC_FILTERING_BIT	= $40;
  {$EXTERNALSYM D3D11_ANISOTROPIC_FILTERING_BIT}

  D3D11_STANDARD_MULTISAMPLE_PATTERN	= $FFFFFFFF;
  {$EXTERNALSYM D3D11_STANDARD_MULTISAMPLE_PATTERN}
  D3D11_CENTER_MULTISAMPLE_PATTERN	= $FFFFFFFE ;
  {$EXTERNALSYM D3D11_CENTER_MULTISAMPLE_PATTERN}

  D3D11_SDK_VERSION	= 7;
  {$EXTERNALSYM D3D11_SDK_VERSION}

type

  D3D11_BIND_FLAG = UINT;

  TD3D11_BIND_FLAG = D3D11_BIND_FLAG;
  {$EXTERNALSYM D3D11_BIND_FLAG}

const

    D3D11_BIND_VERTEX_BUFFER	= UINT($1);
  {$EXTERNALSYM D3D11_BIND_VERTEX_BUFFER}
    D3D11_BIND_INDEX_BUFFER	= UINT($2);
  {$EXTERNALSYM D3D11_BIND_INDEX_BUFFER}
    D3D11_BIND_CONSTANT_BUFFER	= UINT($4);
  {$EXTERNALSYM D3D11_BIND_CONSTANT_BUFFER}
    D3D11_BIND_SHADER_RESOURCE	= UINT($8);
  {$EXTERNALSYM D3D11_BIND_SHADER_RESOURCE}
    D3D11_BIND_STREAM_OUTPUT	= UINT($10);
  {$EXTERNALSYM D3D11_BIND_STREAM_OUTPUT}
    D3D11_BIND_RENDER_TARGET	= UINT($20);
  {$EXTERNALSYM D3D11_BIND_RENDER_TARGET}
    D3D11_BIND_DEPTH_STENCIL	= UINT($40);
  {$EXTERNALSYM D3D11_BIND_DEPTH_STENCIL}
    D3D11_BIND_UNORDERED_ACCESS	= UINT($80);
  {$EXTERNALSYM D3D11_BIND_UNORDERED_ACCESS}

type

  D3D11_CPU_ACCESS_FLAG = UINT;
  TD3D11_CPU_ACCESS_FLAG = D3D11_CPU_ACCESS_FLAG;
  {$EXTERNALSYM D3D11_CPU_ACCESS_FLAG}

const

    D3D11_CPU_ACCESS_WRITE	= UINT($10000);
  {$EXTERNALSYM D3D11_CPU_ACCESS_WRITE}
    D3D11_CPU_ACCESS_READ	= UINT($20000);
  {$EXTERNALSYM D3D11_CPU_ACCESS_READ}

type

  D3D11_CLEAR_FLAG = UINT;
  TD3D11_CLEAR_FLAG = D3D11_CLEAR_FLAG;
  {$EXTERNALSYM D3D11_CLEAR_FLAG}

const

    D3D11_CLEAR_DEPTH	= UINT($1);
  {$EXTERNALSYM D3D11_CLEAR_DEPTH}
    D3D11_CLEAR_STENCIL	= UINT($2);
  {$EXTERNALSYM D3D11_CLEAR_STENCIL}

type

  D3D11_MAP = UINT;
  TD3D11_MAP = D3D11_MAP;
  {$EXTERNALSYM D3D11_MAP}

const

    D3D11_MAP_READ	= 1;
  {$EXTERNALSYM D3D11_MAP_READ}
    D3D11_MAP_WRITE	= 2;
  {$EXTERNALSYM D3D11_MAP_WRITE}
    D3D11_MAP_READ_WRITE	= 3;
  {$EXTERNALSYM D3D11_MAP_READ_WRITE}
    D3D11_MAP_WRITE_DISCARD	= 4;
  {$EXTERNALSYM D3D11_MAP_WRITE_DISCARD}
    D3D11_MAP_WRITE_NO_OVERWRITE	= 5;
  {$EXTERNALSYM D3D11_MAP_WRITE_NO_OVERWRITE}

type
  //array types to be used on functions definitions
  TFourSingleArray = array [0..3] of Single;
  TFourUIntArray = array [0..3] of UInt;

// Forward Declarations

  ID3D11DeviceChild = interface;
  ID3D11DepthStencilState = interface;
  ID3D11BlendState = interface;
  ID3D11RasterizerState = interface;
  ID3D11Resource = interface;
  ID3D11Buffer = interface;
  ID3D11Texture1D = interface;
  ID3D11Texture2D = interface;
  ID3D11Texture3D = interface;
  ID3D11View = interface;
  ID3D11ShaderResourceView = interface;
  ID3D11RenderTargetView = interface;
  ID3D11DepthStencilView = interface;
  ID3D11UnorderedAccessView = interface;
  ID3D11VertexShader = interface;
  ID3D11HullShader = interface;
  ID3D11DomainShader = interface;
  ID3D11GeometryShader = interface;
  ID3D11PixelShader = interface;
  ID3D11ComputeShader = interface;
  ID3D11InputLayout = interface;
  ID3D11SamplerState = interface;
  ID3D11Asynchronous = interface;
  ID3D11Query = interface;
  ID3D11Predicate = interface;
  ID3D11Counter = interface;
  ID3D11ClassInstance = interface;
  ID3D11ClassLinkage = interface;
  ID3D11CommandList = interface;
  ID3D11DeviceContext = interface;
  ID3D11Device = interface;

  PID3D11VertexShader = ^ID3D11VertexShader;

// interface __MIDL_itf_d3d11_0000_0000
// [local]

  CD3D11_DEFAULT = record end;
  {$EXTERNALSYM CD3D11_DEFAULT}
  PCD3D11_DEFAULT = ^CD3D11_DEFAULT;
  D3D11_DEFAULT = CD3D11_DEFAULT;
  {$EXTERNALSYM D3D11_DEFAULT}


  D3D11_INPUT_CLASSIFICATION =(
    D3D11_INPUT_PER_VERTEX_DATA	= 0,
  {$EXTERNALSYM D3D11_INPUT_PER_VERTEX_DATA}
    D3D11_INPUT_PER_INSTANCE_DATA	= 1);
  {$EXTERNALSYM D3D11_INPUT_PER_INSTANCE_DATA}
  TD3D11_INPUT_CLASSIFICATION = D3D11_INPUT_CLASSIFICATION;
  {$EXTERNALSYM D3D11_INPUT_CLASSIFICATION}


  D3D11_INPUT_ELEMENT_DESC = record
    SemanticName: LPCSTR;
    SemanticIndex: UINT;
    Format: DXGI_FORMAT;
    InputSlot: UINT;
    AlignedByteOffset: UINT;
    InputSlotClass: D3D11_INPUT_CLASSIFICATION;
    InstanceDataStepRate: UINT;
  end;
  {$EXTERNALSYM D3D11_INPUT_ELEMENT_DESC}
  TD3D11_INPUT_ELEMENT_DESC =	D3D11_INPUT_ELEMENT_DESC;
  PD3D11_INPUT_ELEMENT_DESC = ^D3D11_INPUT_ELEMENT_DESC;

  D3D11_FILL_MODE = (
    D3D11_FILL_WIREFRAME	= 2,
  {$EXTERNALSYM D3D11_FILL_WIREFRAME}
    D3D11_FILL_SOLID	= 3);
  {$EXTERNALSYM D3D11_FILL_SOLID}
  TD3D11_FILL_MODE = D3D11_FILL_MODE;
  {$EXTERNALSYM D3D11_FILL_MODE}

  D3D11_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY;
  {$EXTERNALSYM D3D11_PRIMITIVE_TOPOLOGY}

  D3D11_PRIMITIVE = D3D_PRIMITIVE;
  {$EXTERNALSYM D3D11_PRIMITIVE}

  D3D11_CULL_MODE = (
    D3D11_CULL_NONE	= 1,
  {$EXTERNALSYM D3D11_CULL_NONE}
    D3D11_CULL_FRONT	= 2,
  {$EXTERNALSYM D3D11_CULL_FRONT}
    D3D11_CULL_BACK	= 3);
  {$EXTERNALSYM D3D11_CULL_BACK}
  TD3D11_CULL_MODE = D3D11_CULL_MODE;
  {$EXTERNALSYM D3D11_CULL_MODE}

  D3D11_SO_DECLARATION_ENTRY = record
    Stream: UINT;
    SemanticName: LPCSTR;
    SemanticIndex: UINT;
    StartComponent: BYTE;
    ComponentCount: BYTE;
    OutputSlot: BYTE;
  end;
  {$EXTERNALSYM D3D11_SO_DECLARATION_ENTRY}
  TD3D11_SO_DECLARATION_ENTRY = D3D11_SO_DECLARATION_ENTRY;
  PD3D11_SO_DECLARATION_ENTRY = ^D3D11_SO_DECLARATION_ENTRY;

  D3D11_VIEWPORT = record
    TopLeftX: Single;
    TopLeftY: Single;
    Width: Single;
    Height: Single;
    MinDepth: Single;
    MaxDepth: Single;
  public
    constructor Create(const o: D3D11_VIEWPORT); overload;
    constructor Create(aTopLeftX: Single; aTopLeftY: Single; aWidth: Single;
                aHeight: Single; aMinDepth: Single = D3D11_MIN_DEPTH;
                aMaxDepth: Single = D3D11_MAX_DEPTH); overload;
    constructor Create(buff: ID3D11Buffer; pRTView: ID3D11RenderTargetView;
                aTopLeftX: Single = 0.0; aMinDepth: Single = D3D11_MIN_DEPTH;
                aMaxDepth: Single = D3D11_MAX_DEPTH); overload;
    constructor Create(pTex1D: ID3D11Texture1D; pRTView: ID3D11RenderTargetView;
                aTopLeftX: Single = 0.0;aTinDepth: Single = D3D11_MIN_DEPTH;
                aTaxDepth: Single = D3D11_MAX_DEPTH); overload;
    constructor Create(pTex2D: ID3D11Texture2D; pRTView: ID3D11RenderTargetView;
                aTopLeftX: Single = 0.0; aTopLeftY: SIngle = 0.0;
                aMinDepth: Single = D3D11_MIN_DEPTH; aMaxDepth: Single = D3D11_MAX_DEPTH); overload;
    constructor Create(pTex3D: ID3D11Texture3D; pRTView: ID3D11RenderTargetView;
                aTopLeftX: Single = 0.0; aTopLeftY: Single = 0.0; aMinDepth: Single = D3D11_MIN_DEPTH;
                aMaxDepth: Single = D3D11_MAX_DEPTH); overload;
  end;
  {$EXTERNALSYM D3D11_VIEWPORT}
  TD3D11_VIEWPORT = D3D11_VIEWPORT;
  PD3D11_VIEWPORT = ^D3D11_VIEWPORT;

  D3D11_RESOURCE_DIMENSION = (
    D3D11_RESOURCE_DIMENSION_UNKNOWN	= 0,
  {$EXTERNALSYM D3D11_RESOURCE_DIMENSION_UNKNOWN}
    D3D11_RESOURCE_DIMENSION_BUFFER	= 1,
  {$EXTERNALSYM D3D11_RESOURCE_DIMENSION_BUFFER}
    D3D11_RESOURCE_DIMENSION_TEXTURE1D	= 2,
  {$EXTERNALSYM D3D11_RESOURCE_DIMENSION_TEXTURE1D}
    D3D11_RESOURCE_DIMENSION_TEXTURE2D	= 3,
  {$EXTERNALSYM D3D11_RESOURCE_DIMENSION_TEXTURE2D}
    D3D11_RESOURCE_DIMENSION_TEXTURE3D	= 4);
  {$EXTERNALSYM D3D11_RESOURCE_DIMENSION_TEXTURE3D}
  TD3D11_RESOURCE_DIMENSION = D3D11_RESOURCE_DIMENSION;
  {$EXTERNALSYM D3D11_RESOURCE_DIMENSION}

  D3D11_SRV_DIMENSION = D3D_SRV_DIMENSION;
  {$EXTERNALSYM D3D11_SRV_DIMENSION}

  D3D11_DSV_DIMENSION = (
    D3D11_DSV_DIMENSION_UNKNOWN	= 0,
  {$EXTERNALSYM D3D11_DSV_DIMENSION_UNKNOWN}
    D3D11_DSV_DIMENSION_TEXTURE1D	= 1,
  {$EXTERNALSYM D3D11_DSV_DIMENSION_TEXTURE1D}
    D3D11_DSV_DIMENSION_TEXTURE1DARRAY	= 2,
  {$EXTERNALSYM D3D11_DSV_DIMENSION_TEXTURE1DARRAY}
    D3D11_DSV_DIMENSION_TEXTURE2D	= 3,
  {$EXTERNALSYM D3D11_DSV_DIMENSION_TEXTURE2D}
    D3D11_DSV_DIMENSION_TEXTURE2DARRAY	= 4,
  {$EXTERNALSYM D3D11_DSV_DIMENSION_TEXTURE2DARRAY}
    D3D11_DSV_DIMENSION_TEXTURE2DMS	= 5,
  {$EXTERNALSYM D3D11_DSV_DIMENSION_TEXTURE2DMS}
    D3D11_DSV_DIMENSION_TEXTURE2DMSARRAY	= 6);
  {$EXTERNALSYM D3D11_DSV_DIMENSION_TEXTURE2DMSARRAY}
  TD3D11_DSV_DIMENSION = D3D11_DSV_DIMENSION;
  {$EXTERNALSYM D3D11_DSV_DIMENSION}


  D3D11_RTV_DIMENSION = (
    D3D11_RTV_DIMENSION_UNKNOWN	= 0,
  {$EXTERNALSYM D3D11_RTV_DIMENSION_UNKNOWN}
    D3D11_RTV_DIMENSION_BUFFER	= 1,
  {$EXTERNALSYM D3D11_RTV_DIMENSION_BUFFER}
    D3D11_RTV_DIMENSION_TEXTURE1D	= 2,
  {$EXTERNALSYM D3D11_RTV_DIMENSION_TEXTURE1D}
    D3D11_RTV_DIMENSION_TEXTURE1DARRAY	= 3,
  {$EXTERNALSYM D3D11_RTV_DIMENSION_TEXTURE1DARRAY}
    D3D11_RTV_DIMENSION_TEXTURE2D	= 4,
  {$EXTERNALSYM D3D11_RTV_DIMENSION_TEXTURE2D}
    D3D11_RTV_DIMENSION_TEXTURE2DARRAY	= 5,
  {$EXTERNALSYM D3D11_RTV_DIMENSION_TEXTURE2DARRAY}
    D3D11_RTV_DIMENSION_TEXTURE2DMS	= 6,
  {$EXTERNALSYM D3D11_RTV_DIMENSION_TEXTURE2DMS}
    D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY	= 7,
  {$EXTERNALSYM D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY}
    D3D11_RTV_DIMENSION_TEXTURE3D	= 8);
  {$EXTERNALSYM D3D11_RTV_DIMENSION_TEXTURE3D}
  TD3D11_RTV_DIMENSION = D3D11_RTV_DIMENSION;
  {$EXTERNALSYM D3D11_RTV_DIMENSION}

  D3D11_UAV_DIMENSION = (
    D3D11_UAV_DIMENSION_UNKNOWN	= 0,
  {$EXTERNALSYM D3D11_UAV_DIMENSION_UNKNOWN}
    D3D11_UAV_DIMENSION_BUFFER	= 1,
  {$EXTERNALSYM D3D11_UAV_DIMENSION_BUFFER}
    D3D11_UAV_DIMENSION_TEXTURE1D	= 2,
  {$EXTERNALSYM D3D11_UAV_DIMENSION_TEXTURE1D}
    D3D11_UAV_DIMENSION_TEXTURE1DARRAY	= 3,
  {$EXTERNALSYM D3D11_UAV_DIMENSION_TEXTURE1DARRAY}
    D3D11_UAV_DIMENSION_TEXTURE2D	= 4,
  {$EXTERNALSYM D3D11_UAV_DIMENSION_TEXTURE2D}
    D3D11_UAV_DIMENSION_TEXTURE2DARRAY	= 5,
  {$EXTERNALSYM D3D11_UAV_DIMENSION_TEXTURE2DARRAY}
    D3D11_UAV_DIMENSION_TEXTURE3D	= 8);
  {$EXTERNALSYM D3D11_UAV_DIMENSION_TEXTURE3D}
  TD3D11_UAV_DIMENSION = D3D11_UAV_DIMENSION;
  {$EXTERNALSYM D3D11_UAV_DIMENSION}

  D3D11_USAGE = (
    D3D11_USAGE_DEFAULT	= 0,
  {$EXTERNALSYM D3D11_USAGE_DEFAULT}
    D3D11_USAGE_IMMUTABLE	= 1,
  {$EXTERNALSYM D3D11_USAGE_IMMUTABLE}
    D3D11_USAGE_DYNAMIC	= 2,
  {$EXTERNALSYM D3D11_USAGE_DYNAMIC}
    D3D11_USAGE_STAGING	= 3);
  {$EXTERNALSYM D3D11_USAGE_STAGING}
  TD3D11_USAGE = D3D11_USAGE;
  {$EXTERNALSYM D3D11_USAGE}

  D3D11_RESOURCE_MISC_FLAG = (
    D3D11_RESOURCE_MISC_GENERATE_MIPS	= UINT($1),
  {$EXTERNALSYM D3D11_RESOURCE_MISC_GENERATE_MIPS}
    D3D11_RESOURCE_MISC_SHARED	= UINT($2),
  {$EXTERNALSYM D3D11_RESOURCE_MISC_SHARED}
    D3D11_RESOURCE_MISC_TEXTURECUBE	= UINT($4),
  {$EXTERNALSYM D3D11_RESOURCE_MISC_TEXTURECUBE}
    D3D11_RESOURCE_MISC_DRAWINDIRECT_ARGS	= UINT($10),
  {$EXTERNALSYM D3D11_RESOURCE_MISC_DRAWINDIRECT_ARGS}
    D3D11_RESOURCE_MISC_BUFFER_ALLOW_RAW_VIEWS	= UINT($20),
  {$EXTERNALSYM D3D11_RESOURCE_MISC_BUFFER_ALLOW_RAW_VIEWS}
    D3D11_RESOURCE_MISC_BUFFER_STRUCTURED	= UINT($40),
  {$EXTERNALSYM D3D11_RESOURCE_MISC_BUFFER_STRUCTURED}
    D3D11_RESOURCE_MISC_RESOURCE_CLAMP	= UINT($80),
  {$EXTERNALSYM D3D11_RESOURCE_MISC_RESOURCE_CLAMP}
    D3D11_RESOURCE_MISC_SHARED_KEYEDMUTEX	= UINT($100),
  {$EXTERNALSYM D3D11_RESOURCE_MISC_SHARED_KEYEDMUTEX}
    D3D11_RESOURCE_MISC_GDI_COMPATIBLE	= UINT($200));
  {$EXTERNALSYM D3D11_RESOURCE_MISC_GDI_COMPATIBLE}
  TD3D11_RESOURCE_MISC_FLAG = D3D11_RESOURCE_MISC_FLAG;
  {$EXTERNALSYM D3D11_RESOURCE_MISC_FLAG}

  D3D11_MAP_FLAG = (
    D3D11_MAP_FLAG_DO_NOT_WAIT	= UINT($100000));
  {$EXTERNALSYM D3D11_MAP_FLAG_DO_NOT_WAIT}
  TD3D11_MAP_FLAG = D3D11_MAP_FLAG;
  {$EXTERNALSYM D3D11_MAP_FLAG}

  D3D11_RAISE_FLAG = (
    D3D11_RAISE_FLAG_DRIVER_INTERNAL_ERROR	= UINT($1));
  {$EXTERNALSYM D3D11_RAISE_FLAG_DRIVER_INTERNAL_ERROR}
  TD3D11_RAISE_FLAG = D3D11_RAISE_FLAG;
  {$EXTERNALSYM D3D11_RAISE_FLAG}

  D3D11_RECT = TRect;
  {$EXTERNALSYM D3D11_RECT}
  PD3D11_RECT = ^D3D11_RECT;


  D3D11_BOX = record
    left: UINT;
    top: UINT;
    front: UINT;
    right: UINT;
    bottom: UINT;
    back: UINT;
    public
    constructor Create(const o: D3D11_BOX); overload;
    constructor Create(aLeft: LONG; aTop: LONG; aFront: LONG;
                aRight: LONG; aBottom: LONG; aBack: LONG); overload;
    class operator Equal(const l,r: D3D11_BOX): Boolean;
    class operator NotEqual(const l,r: D3D11_BOX): Boolean;
  end;
  {$EXTERNALSYM D3D11_BOX}
  TD3D11_BOX = D3D11_BOX;
  PD3D11_BOX = ^D3D11_BOX;

// interface ID3D11DeviceChild
// [unique][local][object][uuid]


  {$EXTERNALSYM ID3D11DeviceChild}
  IID_ID3D11DeviceChild = ID3D11DeviceChild;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11DeviceChild);'}
  {$EXTERNALSYM ID3D11DeviceChild}
  ID3D11DeviceChild = interface(IUnknown)
  ['{1841E5C8-16B0-489B-BCC8-44CFB0D5DEAE}']
    procedure GetDevice(out  ppDevice: ID3D11Device); stdcall;
    function GetPrivateData(
      (* _In_ *) const guid: TGUID;
      (* _Inout_*)  var pDataSize: UINT;
      (*_Out_writes_bytes_opt_( *pDataSize )*)  pData: Pointer): HRESULT; stdcall;

    function SetPrivateData(
      (*_In_*)  const guid: TGUID;
      (*_In_*)  DataSize: UINT;
      (*_In_reads_bytes_opt_( DataSize )*)  const pData: Pointer): HRESULT; stdcall;

    function SetPrivateDataInterface(
      (*_In_*)  const guid: TGUID;
      (*_In_opt_*)  const pData: IUnknown): HRESULT; stdcall;
   end;

// interface __MIDL_itf_d3d11_0000_0001
// [local]

  D3D11_COMPARISON_FUNC = (
    D3D11_COMPARISON_NEVER	= 1,
  {$EXTERNALSYM D3D11_COMPARISON_NEVER}
    D3D11_COMPARISON_LESS	= 2,
  {$EXTERNALSYM D3D11_COMPARISON_LESS}
    D3D11_COMPARISON_EQUAL	= 3,
  {$EXTERNALSYM D3D11_COMPARISON_EQUAL}
    D3D11_COMPARISON_LESS_EQUAL	= 4,
  {$EXTERNALSYM D3D11_COMPARISON_LESS_EQUAL}
    D3D11_COMPARISON_GREATER	= 5,
  {$EXTERNALSYM D3D11_COMPARISON_GREATER}
    D3D11_COMPARISON_NOT_EQUAL	= 6,
  {$EXTERNALSYM D3D11_COMPARISON_NOT_EQUAL}
    D3D11_COMPARISON_GREATER_EQUAL	= 7,
  {$EXTERNALSYM D3D11_COMPARISON_GREATER_EQUAL}
    D3D11_COMPARISON_ALWAYS	= 8);
  {$EXTERNALSYM D3D11_COMPARISON_ALWAYS}
  TD3D11_COMPARISON_FUNC = D3D11_COMPARISON_FUNC;
  {$EXTERNALSYM D3D11_COMPARISON_FUNC}

  D3D11_DEPTH_WRITE_MASK = (
    D3D11_DEPTH_WRITE_MASK_ZERO	= 0,
  {$EXTERNALSYM D3D11_DEPTH_WRITE_MASK_ZERO}
    D3D11_DEPTH_WRITE_MASK_ALL	= 1);
  {$EXTERNALSYM D3D11_DEPTH_WRITE_MASK_ALL}
  TD3D11_DEPTH_WRITE_MASK = D3D11_DEPTH_WRITE_MASK;
  {$EXTERNALSYM D3D11_DEPTH_WRITE_MASK}

  D3D11_STENCIL_OP = (
    D3D11_STENCIL_OP_KEEP	= 1,
  {$EXTERNALSYM D3D11_STENCIL_OP_KEEP}
    D3D11_STENCIL_OP_ZERO	= 2,
  {$EXTERNALSYM D3D11_STENCIL_OP_ZERO}
    D3D11_STENCIL_OP_REPLACE	= 3,
  {$EXTERNALSYM D3D11_STENCIL_OP_REPLACE}
    D3D11_STENCIL_OP_INCR_SAT	= 4,
  {$EXTERNALSYM D3D11_STENCIL_OP_INCR_SAT}
    D3D11_STENCIL_OP_DECR_SAT	= 5,
  {$EXTERNALSYM D3D11_STENCIL_OP_DECR_SAT}
    D3D11_STENCIL_OP_INVERT	= 6,
  {$EXTERNALSYM D3D11_STENCIL_OP_INVERT}
    D3D11_STENCIL_OP_INCR	= 7,
  {$EXTERNALSYM D3D11_STENCIL_OP_INCR}
    D3D11_STENCIL_OP_DECR	= 8);
  {$EXTERNALSYM D3D11_STENCIL_OP_DECR}
  TD3D11_STENCIL_OP = D3D11_STENCIL_OP;
  {$EXTERNALSYM D3D11_STENCIL_OP}

  D3D11_DEPTH_STENCILOP_DESC = record
    StencilFailOp : D3D11_STENCIL_OP;
    StencilDepthFailOp : D3D11_STENCIL_OP;
    StencilPassOp : D3D11_STENCIL_OP;
    StencilFunc : D3D11_COMPARISON_FUNC;
  end;
  {$EXTERNALSYM D3D11_DEPTH_STENCILOP_DESC}
  TD3D11_DEPTH_STENCILOP_DESC = D3D11_DEPTH_STENCILOP_DESC;
  PD3D11_DEPTH_STENCILOP_DESC = ^D3D11_DEPTH_STENCILOP_DESC;

  D3D11_DEPTH_STENCIL_DESC = record
    DepthEnable : BOOL;
    DepthWriteMask: D3D11_DEPTH_WRITE_MASK;
    DepthFunc : D3D11_COMPARISON_FUNC;
    StencilEnable: BOOL;
    StencilReadMask: UINT8;
    StencilWriteMask: UINT8;
    FrontFace: D3D11_DEPTH_STENCILOP_DESC;
    BackFace: D3D11_DEPTH_STENCILOP_DESC;
    Constructor Create(default: boolean); overload;
    Constructor Create(const o: D3D11_DEPTH_STENCIL_DESC); overload;
    Constructor Create(aDepthEnable: BOOL; aDepthWriteMask: D3D11_DEPTH_WRITE_MASK;
                    aDepthFunc: D3D11_COMPARISON_FUNC; aStencilEnable: BOOL; aStencilReadMask: UINT8;
                    aStencilWriteMask: UINT8; aFrontStencilFailOp: D3D11_STENCIL_OP;
                    aFrontStencilDepthFailOp: D3D11_STENCIL_OP; aFrontStencilPassOp: D3D11_STENCIL_OP;
                    aFrontStencilFunc: D3D11_COMPARISON_FUNC; aBackStencilFailOp: D3D11_STENCIL_OP;
                    aBackStencilDepthFailOp: D3D11_STENCIL_OP; aBackStencilPassOp: D3D11_STENCIL_OP;
                    aBackStencilFunc: D3D11_COMPARISON_FUNC); overload;

  end;
  {$EXTERNALSYM D3D11_DEPTH_STENCIL_DESC}
  TD3D11_DEPTH_STENCIL_DESC = D3D11_DEPTH_STENCIL_DESC;
  PD3D11_DEPTH_STENCIL_DESC = ^D3D11_DEPTH_STENCIL_DESC;


// interface ID3D11DepthStencilState
// [unique][local][object][uuid]



  {$EXTERNALSYM IID_ID3D11DepthStencilState}
  IID_ID3D11DepthStencilState = ID3D11DepthStencilState;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11DepthStencilState);'}
  {$EXTERNALSYM ID3D11DepthStencilState}
  ID3D11DepthStencilState = interface(ID3D11DeviceChild)
  ['{03823EFB-8D8F-4E1C-9AA2-F64BB2CBFDF1}']
    procedure GetDesc(out pDesc: D3D11_DEPTH_STENCIL_DESC); stdcall;
  end;

// interface __MIDL_itf_d3d11_0000_0002
// [local]

  D3D11_BLEND = (
    D3D11_BLEND_ZERO	= 1,
  {$EXTERNALSYM D3D11_BLEND_ZERO}
    D3D11_BLEND_ONE	= 2,
  {$EXTERNALSYM D3D11_BLEND_ONE}
    D3D11_BLEND_SRC_COLOR	= 3,
  {$EXTERNALSYM D3D11_BLEND_SRC_COLOR}
    D3D11_BLEND_INV_SRC_COLOR	= 4,
  {$EXTERNALSYM D3D11_BLEND_INV_SRC_COLOR}
    D3D11_BLEND_SRC_ALPHA	= 5,
  {$EXTERNALSYM D3D11_BLEND_SRC_ALPHA}
    D3D11_BLEND_INV_SRC_ALPHA	= 6,
  {$EXTERNALSYM D3D11_BLEND_INV_SRC_ALPHA}
    D3D11_BLEND_DEST_ALPHA	= 7,
  {$EXTERNALSYM D3D11_BLEND_DEST_ALPHA}
    D3D11_BLEND_INV_DEST_ALPHA	= 8,
  {$EXTERNALSYM D3D11_BLEND_INV_DEST_ALPHA}
    D3D11_BLEND_DEST_COLOR	= 9,
  {$EXTERNALSYM D3D11_BLEND_DEST_COLOR}
    D3D11_BLEND_INV_DEST_COLOR	= 10,
  {$EXTERNALSYM D3D11_BLEND_INV_DEST_COLOR}
    D3D11_BLEND_SRC_ALPHA_SAT	= 11,
  {$EXTERNALSYM D3D11_BLEND_SRC_ALPHA_SAT}
    D3D11_BLEND_BLEND_FACTOR	= 14,
  {$EXTERNALSYM D3D11_BLEND_BLEND_FACTOR}
    D3D11_BLEND_INV_BLEND_FACTOR	= 15,
  {$EXTERNALSYM D3D11_BLEND_INV_BLEND_FACTOR}
    D3D11_BLEND_SRC1_COLOR	= 16,
  {$EXTERNALSYM D3D11_BLEND_SRC1_COLOR}
    D3D11_BLEND_INV_SRC1_COLOR	= 17,
  {$EXTERNALSYM D3D11_BLEND_INV_SRC1_COLOR}
    D3D11_BLEND_SRC1_ALPHA	= 18,
  {$EXTERNALSYM D3D11_BLEND_SRC1_ALPHA}
    D3D11_BLEND_INV_SRC1_ALPHA	= 19);
  {$EXTERNALSYM D3D11_BLEND_INV_SRC1_ALPHA}
  TD3D11_BLEND = D3D11_BLEND;
  {$EXTERNALSYM D3D11_BLEND}

  D3D11_BLEND_OP = (
    D3D11_BLEND_OP_ADD	= 1,
  {$EXTERNALSYM D3D11_BLEND_OP_ADD}
    D3D11_BLEND_OP_SUBTRACT	= 2,
  {$EXTERNALSYM D3D11_BLEND_OP_SUBTRACT}
    D3D11_BLEND_OP_REV_SUBTRACT	= 3,
  {$EXTERNALSYM D3D11_BLEND_OP_REV_SUBTRACT}
    D3D11_BLEND_OP_MIN	= 4,
  {$EXTERNALSYM D3D11_BLEND_OP_MIN}
    D3D11_BLEND_OP_MAX	= 5);
  {$EXTERNALSYM D3D11_BLEND_OP_MAX}
  TD3D11_BLEND_OP = D3D11_BLEND_OP;
  {$EXTERNALSYM D3D11_BLEND_OP}

  D3D11_COLOR_WRITE_ENABLE = (
    D3D11_COLOR_WRITE_ENABLE_RED	= 1,
  {$EXTERNALSYM D3D11_COLOR_WRITE_ENABLE_RED}
    D3D11_COLOR_WRITE_ENABLE_GREEN	= 2,
  {$EXTERNALSYM D3D11_COLOR_WRITE_ENABLE_GREEN}
    D3D11_COLOR_WRITE_ENABLE_BLUE	= 4,
  {$EXTERNALSYM D3D11_COLOR_WRITE_ENABLE_BLUE}
    D3D11_COLOR_WRITE_ENABLE_ALPHA	= 8,
  {$EXTERNALSYM D3D11_COLOR_WRITE_ENABLE_ALPHA}
    D3D11_COLOR_WRITE_ENABLE_ALL	= (D3D11_COLOR_WRITE_ENABLE_RED + D3D11_COLOR_WRITE_ENABLE_GREEN + D3D11_COLOR_WRITE_ENABLE_BLUE + D3D11_COLOR_WRITE_ENABLE_ALPHA)
  {$EXTERNALSYM D3D11_COLOR_WRITE_ENABLE_ALL}
    );
  TD3D11_COLOR_WRITE_ENABLE = D3D11_COLOR_WRITE_ENABLE;
  {$EXTERNALSYM D3D11_COLOR_WRITE_ENABLE}

  D3D11_RENDER_TARGET_BLEND_DESC = record
    BlendEnable: BOOL;
    SrcBlend: D3D11_BLEND;
    DestBlend: D3D11_BLEND;
    BlendOp: D3D11_BLEND_OP;
    SrcBlendAlpha: D3D11_BLEND;
    DestBlendAlpha: D3D11_BLEND;
    BlendOpAlpha: D3D11_BLEND_OP;
    RenderTargetWriteMask: UINT8;
  end;
  {$EXTERNALSYM D3D11_RENDER_TARGET_BLEND_DESC}
  TD3D11_RENDER_TARGET_BLEND_DESC = D3D11_RENDER_TARGET_BLEND_DESC;
  PD3D11_RENDER_TARGET_BLEND_DESC = ^D3D11_RENDER_TARGET_BLEND_DESC;

  D3D11_BLEND_DESC = record
    AlphaToCoverageEnable: BOOL;
    IndependentBlendEnable: BOOL;
    RenderTarget: array [0..7] of D3D11_RENDER_TARGET_BLEND_DESC;
    constructor Create(Default: boolean); overload;
    constructor Create(const o: D3D11_BLEND_DESC); overload;
  end;
  {$EXTERNALSYM D3D11_BLEND_DESC}
  TD3D11_BLEND_DESC = D3D11_BLEND_DESC;
  PD3D11_BLEND_DESC = ^D3D11_BLEND_DESC;

(* Note, the array size for RenderTarget[] above is D3D11_SIMULTANEOUS_RENDERTARGET_COUNT.
   IDL processing/generation of this header replaces the define; this comment is merely explaining what happened. *)



// interface ID3D11BlendState
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11BlendState}
    IID_ID3D11BlendState = ID3D11BlendState;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11BlendState);'}
  {$EXTERNALSYM ID3D11BlendState}
    ID3D11BlendState = interface (ID3D11DeviceChild)
    ['{75B68FAA-347D-4159-8F45-A0640F01CD9A}']
      procedure GetDesc(out pDesc: D3D11_BLEND_DESC); stdcall;
    end;

// interface __MIDL_itf_d3d11_0000_0003
// [local]

  D3D11_RASTERIZER_DESC = record
    FillMode: D3D11_FILL_MODE;
    CullMode: D3D11_CULL_MODE;
    FrontCounterClockwise: BOOL;
    DepthBias: integer;
    DepthBiasClamp: Single;
    SlopeScaledDepthBias: Single;
    DepthClipEnable: BOOL;
    ScissorEnable: BOOL;
    MultisampleEnable: BOOL;
    AntialiasedLineEnable: BOOL;
    public
      constructor Create(const o: D3D11_RASTERIZER_DESC); overload;
      constructor Create(Default: boolean); overload;
      constructor Create(aFillMode: D3D11_FILL_MODE; aCullMode: D3D11_CULL_MODE;
                        aFrontCounterClockwise: BOOL; aDepthBias: integer;
                        aDepthBiasClamp: Single; aSlopeScaledDepthBias: Single;
                        aDepthClipEnable: BOOL; aScissorEnable: BOOL;
                        aMultisampleEnable: BOOL; aAntialiasedLineEnable: BOOL); overload;
  end;
  {$EXTERNALSYM D3D11_RASTERIZER_DESC}
  TD3D11_RASTERIZER_DESC = D3D11_RASTERIZER_DESC;
  PD3D11_RASTERIZER_DESC = ^D3D11_RASTERIZER_DESC;



// interface ID3D11RasterizerState
// [unique][local][object][uuid]


  {$EXTERNALSYM IID_ID3D11RasterizerState}
  IID_ID3D11RasterizerState = ID3D11RasterizerState;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11RasterizerState);'}
  {$EXTERNALSYM ID3D11RasterizerState}
  ID3D11RasterizerState = interface(ID3D11DeviceChild)
  ['{9BB4AB81-AB1A-4D8F-B506-FC04200B6EE7}']
    procedure GetDesc(out pDesc: D3D11_RASTERIZER_DESC); stdcall;
  end;


// interface __MIDL_itf_d3d11_0000_0004
// [local]

  D3D11_SUBRESOURCE_DATA = record
    (*const*) pSysMem: Pointer;
    SysMemPitch: UINT;
    SysMemSlicePitch: UINT;
  end;
  {$EXTERNALSYM D3D11_SUBRESOURCE_DATA}
  TD3D11_SUBRESOURCE_DATA = D3D11_SUBRESOURCE_DATA;
  PD3D11_SUBRESOURCE_DATA = ^D3D11_SUBRESOURCE_DATA;

  D3D11_MAPPED_SUBRESOURCE = record
    pData: Pointer;
    RowPitch: UINT;
    DepthPitch: UINT;
  end;
  {$EXTERNALSYM D3D11_MAPPED_SUBRESOURCE}
  TD3D11_MAPPED_SUBRESOURCE = D3D11_MAPPED_SUBRESOURCE;
  PD3D11_MAPPED_SUBRESOURCE = ^D3D11_MAPPED_SUBRESOURCE;


// interface ID3D11Resource
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11Resource}
  IID_ID3D11Resource = ID3D11Resource;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11Resource);'}
  {$EXTERNALSYM ID3D11Resource}
  ID3D11Resource = interface (ID3D11DeviceChild)
  ['{DC8E63F3-D12B-4952-B47B-5E45026A862D}']
    procedure GetType(out pResourceDimension: D3D11_RESOURCE_DIMENSION); stdcall;

    procedure SetEvictionPriority((*_In_*) EvictionPriority: UINT); stdcall;

    function GetEvictionPriority: UINT; stdcall;
  end;

// interface __MIDL_itf_d3d11_0000_0005
// [local]

  D3D11_BUFFER_DESC = record
    ByteWidth: UINT;
    Usage: D3D11_USAGE;
    BindFlags: UINT;
    CPUAccessFlags: UINT;
    MiscFlags: UINT;
    StructureByteStride: UINT;
    public
    constructor Create(const o: D3D11_BUFFER_DESC); overload;
    constructor Create(aByteWidth: UINT; aBindFlags: UINT;
                aUsage: D3D11_USAGE = D3D11_USAGE_DEFAULT; aCpuaccessFlags: UINT = 0;
                aMiscFlags: UINT = 0; aStructureByteStride: UINT = 0); overload;
  end;
  {$EXTERNALSYM D3D11_BUFFER_DESC}
  TD3D11_BUFFER_DESC = D3D11_BUFFER_DESC;
  PD3D11_BUFFER_DESC = ^D3D11_BUFFER_DESC;


// interface ID3D11Buffer
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11Buffer}
  IID_ID3D11Buffer = ID3D11Buffer;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11Buffer);'}
  {$EXTERNALSYM ID3D11Buffer}
  ID3D11Buffer = interface(ID3D11Resource)
  ['{48570B85-D1EE-4FCD-A250-EB350722B037}']
    procedure GetDesc(out  pDesc: D3D11_BUFFER_DESC); stdcall;
  end;


// interface __MIDL_itf_d3d11_0000_0006
// [local]

  D3D11_TEXTURE1D_DESC = record
    Width: UINT;
    MipLevels: UINT;
    ArraySize: UINT;
    Format: DXGI_FORMAT;
    Usage: D3D11_USAGE;
    BindFlags: UINT;
    CPUAccessFlags: UINT;
    MiscFlags: UINT;
  public
    constructor Create(const o: D3D11_TEXTURE1D_DESC); overload;
    constructor Create(aFormat: DXGI_FORMAT; aWidth: UINT; aArraySize: UINT = 1;
                aMipLevels: UINT = 0; aBindFlags: UINT = UINT(D3D11_BIND_SHADER_RESOURCE);
                aUsage: D3D11_USAGE = D3D11_USAGE_DEFAULT; aCpuaccessFlags: UINT = 0;
                aMiscFlags: UINT = 0); overload;
  end;
  {$EXTERNALSYM D3D11_TEXTURE1D_DESC}
  TD3D11_TEXTURE1D_DESC = D3D11_TEXTURE1D_DESC;
  PD3D11_TEXTURE1D_DESC = ^D3D11_TEXTURE1D_DESC;

// interface ID3D11Texture1D
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11Texture1D}
  IID_ID3D11Texture1D = ID3D11Texture1D;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11Texture1D);'}
  {$EXTERNALSYM ID3D11Texture1D}
  ID3D11Texture1D = interface(ID3D11Resource)
  ['{F8FB5C27-C6B3-4F75-A4C8-439AF2EF564C}']
    procedure GetDesc(out  pDesc: D3D11_TEXTURE1D_DESC); stdcall;
  end;

// interface __MIDL_itf_d3d11_0000_0007
// [local]

  D3D11_TEXTURE2D_DESC = record
    Width: UINT;
    Height: UINT;
    MipLevels: UINT;
    ArraySize: UINT;
    Format: DXGI_FORMAT;
    SampleDesc: DXGI_SAMPLE_DESC;
    Usage: D3D11_USAGE;
    BindFlags: UINT;
    CPUAccessFlags: UINT;
    MiscFlags: UINT;
  public
    constructor Create(const o: D3D11_TEXTURE2D_DESC); overload;
    constructor Create(aFormat: DXGI_FORMAT; aWidth: UINT; aHeight: UINT;
                aArraySize: UINT = 1; aMipLevels: UINT = 0;
                aBindFlags: UINT = UINT(D3D11_BIND_SHADER_RESOURCE);
                aUsage: D3D11_USAGE = D3D11_USAGE_DEFAULT;
                aCpuaccessFlags: UINT = 0; aSampleCount: UINT = 1;
                aSampleQuality: UINT = 0; aMiscFlags: UINT = 0); overload;

  end;
  {$EXTERNALSYM D3D11_TEXTURE2D_DESC}
  TD3D11_TEXTURE2D_DESC = D3D11_TEXTURE2D_DESC;
  PD3D11_TEXTURE2D_DESC = ^D3D11_TEXTURE2D_DESC;


// interface ID3D11Texture2D
// [unique][local][object][uuid]
  {$EXTERNALSYM IID_ID3D11Texture2D}
  IID_ID3D11Texture2D = ID3D11Texture2D;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11Texture2D);'}
  {$EXTERNALSYM ID3D11Texture2D}
  ID3D11Texture2D = interface(ID3D11Resource)
  ['{6F15AAF2-D208-4E89-9AB4-489535D34F9C}']
    procedure GetDesc(out pDesc: D3D11_TEXTURE2D_DESC); stdcall;
  end;


// interface __MIDL_itf_d3d11_0000_0008
// [local]

  D3D11_TEXTURE3D_DESC = record
    Width: UINT;
    Height: UINT;
    Depth: UINT;
    MipLevels: UINT;
    Format: DXGI_FORMAT;
    Usage: D3D11_USAGE;
    BindFlags: UINT;
    CPUAccessFlags: UINT;
    MiscFlags: UINT;
  public
    constructor Create(const o: D3D11_TEXTURE3D_DESC); overload;
    constructor Create(aFormat: DXGI_FORMAT; aWidth: UINT; aHeight: UINT;
                      aDepth: UINT; aMipLevels: UINT = 0;
                      aBindFlags: UINT = UINT(D3D11_BIND_SHADER_RESOURCE);
                      aUsage: D3D11_USAGE = D3D11_USAGE_DEFAULT;
                      aCpuaccessFlags: UINT = 0; aMiscFlags: UINT = 0); overload;
  end;
  {$EXTERNALSYM D3D11_TEXTURE3D_DESC}
  TD3D11_TEXTURE3D_DESC = D3D11_TEXTURE3D_DESC;
  PD3D11_TEXTURE3D_DESC = ^D3D11_TEXTURE3D_DESC;



// interface ID3D11Texture3D
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11Texture3D}
  IID_ID3D11Texture3D = ID3D11Texture3D;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11Texture3D);'}
  {$EXTERNALSYM ID3D11Texture3D}
  ID3D11Texture3D = interface(ID3D11Resource)
  ['{037E866E-F56D-4357-A8AF-9DABBE6E250E}']
    procedure GetDesc(out pDesc: D3D11_TEXTURE3D_DESC); stdcall;
  end;

// interface __MIDL_itf_d3d11_0000_0009
// [local]

  D3D11_TEXTURECUBE_FACE = (
    D3D11_TEXTURECUBE_FACE_POSITIVE_X	= 0,
  {$EXTERNALSYM D3D11_TEXTURECUBE_FACE_POSITIVE_X}
    D3D11_TEXTURECUBE_FACE_NEGATIVE_X	= 1,
  {$EXTERNALSYM D3D11_TEXTURECUBE_FACE_NEGATIVE_X}
    D3D11_TEXTURECUBE_FACE_POSITIVE_Y	= 2,
  {$EXTERNALSYM D3D11_TEXTURECUBE_FACE_POSITIVE_Y}
    D3D11_TEXTURECUBE_FACE_NEGATIVE_Y	= 3,
  {$EXTERNALSYM D3D11_TEXTURECUBE_FACE_NEGATIVE_Y}
    D3D11_TEXTURECUBE_FACE_POSITIVE_Z	= 4,
  {$EXTERNALSYM D3D11_TEXTURECUBE_FACE_POSITIVE_Z}
    D3D11_TEXTURECUBE_FACE_NEGATIVE_Z	= 5);
  {$EXTERNALSYM D3D11_TEXTURECUBE_FACE_NEGATIVE_Z}
  TD3D11_TEXTURECUBE_FACE = D3D11_TEXTURECUBE_FACE;
  {$EXTERNALSYM D3D11_TEXTURECUBE_FACE}

// interface ID3D11View
// [unique][local][object][uuid]


  {$EXTERNALSYM IID_ID3D11View}
  IID_ID3D11View = ID3D11View;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11View);'}
  {$EXTERNALSYM ID3D11View}
  ID3D11View = interface(ID3D11DeviceChild)
  ['{839D1216-BB2E-412B-B7F4-A9DBEBE08ED1}']
    procedure GetResource(out ppResource: ID3D11Resource); stdcall;
  end;

// interface __MIDL_itf_d3d11_0000_0010
// [local]

  D3D11_BUFFER_SRV = record
    case Byte of
      0:
        (FirstElement: UINT;
         NumElements: UINT;);
      1:
        (ElementOffset: UINT;
         ElementWidth: UINT;)
    end;
  {$EXTERNALSYM D3D11_BUFFER_SRV}
  TD3D11_BUFFER_SRV = D3D11_BUFFER_SRV;
  PD3D11_BUFFER_SRV = ^D3D11_BUFFER_SRV;


  D3D11_BUFFEREX_SRV_FLAG = (
    D3D11_BUFFEREX_SRV_FLAG_RAW	= $1);
  {$EXTERNALSYM D3D11_BUFFEREX_SRV_FLAG}
  TD3D11_BUFFEREX_SRV_FLAG = D3D11_BUFFEREX_SRV_FLAG;

  D3D11_BUFFEREX_SRV = record
    FirstElement: UINT;
    NumElements: UINT;
    Flags: UINT;
  end;
  {$EXTERNALSYM D3D11_BUFFEREX_SRV}
  TD3D11_BUFFEREX_SRV = D3D11_BUFFEREX_SRV;
  PD3D11_BUFFEREX_SRV = ^D3D11_BUFFEREX_SRV;

  D3D11_TEX1D_SRV = record
    MostDetailedMip: UINT;
    MipLevels: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX1D_SRV}
  TD3D11_TEX1D_SRV = D3D11_TEX1D_SRV;
  PD3D11_TEX1D_SRV = ^D3D11_TEX1D_SRV;

  D3D11_TEX1D_ARRAY_SRV = record
    MostDetailedMip: UINT;
    MipLevels: UINT;
    FirstArraySlice: UINT;
    ArraySize: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX1D_ARRAY_SRV}
  TD3D11_TEX1D_ARRAY_SRV = D3D11_TEX1D_ARRAY_SRV;
  PD3D11_TEX1D_ARRAY_SRV = ^D3D11_TEX1D_ARRAY_SRV;

  D3D11_TEX2D_SRV = record
    MostDetailedMip: UINT;
    MipLevels: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2D_SRV}
  TD3D11_TEX2D_SRV = D3D11_TEX2D_SRV;
  PD3D11_TEX2D_SRV = ^D3D11_TEX2D_SRV;

  D3D11_TEX2D_ARRAY_SRV = record
    MostDetailedMip: UINT;
    MipLevels: UINT;
    FirstArraySlice: UINT;
    ArraySize: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2D_ARRAY_SRV}
  TD3D11_TEX2D_ARRAY_SRV = D3D11_TEX2D_ARRAY_SRV;
  PD3D11_TEX2D_ARRAY_SRV = ^D3D11_TEX2D_ARRAY_SRV;

  D3D11_TEX3D_SRV = record
    MostDetailedMip: UINT;
    MipLevels: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX3D_SRV}
  TD3D11_TEX3D_SRV = D3D11_TEX3D_SRV;
  PD3D11_TEX3D_SRV = ^D3D11_TEX3D_SRV;

  D3D11_TEXCUBE_SRV = record
    MostDetailedMip: UINT;
    MipLevels: UINT;
  end;
  {$EXTERNALSYM D3D11_TEXCUBE_SRV}
  TD3D11_TEXCUBE_SRV = D3D11_TEXCUBE_SRV;
  PD3D11_TEXCUBE_SRV = ^D3D11_TEXCUBE_SRV;

  D3D11_TEXCUBE_ARRAY_SRV = record
    MostDetailedMip: UINT;
    MipLevels: UINT;
    First2DArrayFace: UINT;
    NumCubes: UINT;
  end;
  {$EXTERNALSYM D3D11_TEXCUBE_ARRAY_SRV}
  TD3D11_TEXCUBE_ARRAY_SRV = D3D11_TEXCUBE_ARRAY_SRV;
  PD3D11_TEXCUBE_ARRAY_SRV = ^D3D11_TEXCUBE_ARRAY_SRV;

  D3D11_TEX2DMS_SRV = record
    UnusedField_NothingToDefine: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2DMS_SRV}
  TD3D11_TEX2DMS_SRV = D3D11_TEX2DMS_SRV;
  PD3D11_TEX2DMS_SRV = ^D3D11_TEX2DMS_SRV;

  D3D11_TEX2DMS_ARRAY_SRV = record
    FirstArraySlice: UINT;
    ArraySize: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2DMS_ARRAY_SRV}
  TD3D11_TEX2DMS_ARRAY_SRV = D3D11_TEX2DMS_ARRAY_SRV;
  PD3D11_TEX2DMS_ARRAY_SRV = ^D3D11_TEX2DMS_ARRAY_SRV;

  D3D11_SHADER_RESOURCE_VIEW_DESC = record
    Format: DXGI_FORMAT;
    ViewDimension: D3D11_SRV_DIMENSION;
    public
      constructor Create(const o : D3D11_SHADER_RESOURCE_VIEW_DESC); overload;
      constructor Create(aViewDimension: D3D11_SRV_DIMENSION;
                aFormat: DXGI_FORMAT = DXGI_FORMAT_UNKNOWN;
                aMostDetailedMip: UINT = 0; // FirstElement for BUFFER
                aMipLevels : UINT = UINT(-1); // NumElements for BUFFER
                aFirstArraySlice: UINT = 0; // First2DArrayFace for TEXTURECUBEARRAY
                aArraySize : UINT = UINT(-1); // NumCubes for TEXTURECUBEARRAY
                aFlags: UINT = 0 (*BUFFEREX only *)); overload;
      constructor Create(aBuffer: ID3D11Buffer; aFormat: DXGI_FORMAT;
                aFirstElement: UINT; aNumElements: UINT;
                aFlags: UINT = 0); overload;
      constructor Create(pTex1D: ID3D11Texture1D; aViewDimension: D3D11_SRV_DIMENSION;
                aFormat: DXGI_FORMAT  = DXGI_FORMAT_UNKNOWN;
                aMostDetailedMip: UINT  = 0; aMipLevels: UINT  = UINT(-1);
                aFirstArraySlice: UINT = 0; aArraySize: UINT = UINT(-1)); overload;
      constructor Create(pTex2D: ID3D11Texture2D; aViewDimension: D3D11_SRV_DIMENSION;
                aFormat: DXGI_FORMAT = DXGI_FORMAT_UNKNOWN; aMostDetailedMip: UINT = 0;
                aMipLevels: UINT = UINT(-1); aFirstArraySlice: UINT = 0; (*First2DArrayFace for TEXTURECUBEARRAY *)
                aArraySize: UINT = UINT(-1)   (*NumCubes for TEXTURECUBEARRAY *)); overload;
      constructor Create(pTex3D: ID3D11Texture3D; aFormat: DXGI_FORMAT = DXGI_FORMAT_UNKNOWN;
                aMostDetailedMip: UINT = 0; aMipLevels: UINT = UINT(-1)); overload;

    case Byte of
      0: (Buffer: D3D11_BUFFER_SRV);
      1: (Texture1D: D3D11_TEX1D_SRV);
      2: (Texture1DArray: D3D11_TEX1D_ARRAY_SRV);
      3: (Texture2D: D3D11_TEX2D_SRV);
      4: (Texture2DArray: D3D11_TEX2D_ARRAY_SRV);
      5: (Texture2DMS: D3D11_TEX2DMS_SRV);
      6: (Texture2DMSArray: D3D11_TEX2DMS_ARRAY_SRV);
      7: (Texture3D: D3D11_TEX3D_SRV);
      8: (TextureCube: D3D11_TEXCUBE_SRV);
      9: (TextureCubeArray: D3D11_TEXCUBE_ARRAY_SRV);
      10: (BufferEx: D3D11_BUFFEREX_SRV);

  end;
  {$EXTERNALSYM D3D11_SHADER_RESOURCE_VIEW_DESC}
  TD3D11_SHADER_RESOURCE_VIEW_DESC = D3D11_SHADER_RESOURCE_VIEW_DESC;
  PD3D11_SHADER_RESOURCE_VIEW_DESC = ^D3D11_SHADER_RESOURCE_VIEW_DESC;


// interface ID3D11ShaderResourceView
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11ShaderResourceView}
  IID_ID3D11ShaderResourceView = ID3D11ShaderResourceView;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11ShaderResourceView);'}
  {$EXTERNALSYM ID3D11ShaderResourceView}
  ID3D11ShaderResourceView = interface(ID3D11View)
  ['{B0E06FE0-8192-4E1A-B1CA-36D7414710B2}']
    procedure GetDesc(out pDesc: D3D11_SHADER_RESOURCE_VIEW_DESC); stdcall;
  end;

// interface __MIDL_itf_d3d11_0000_0011
// [local]

  D3D11_BUFFER_RTV = record
    case Byte of
      0: (FirstElement: UINT;
        NumElements: UINT);
      1: (ElementOffset: UINT;
        ElementWidth: UINT);
  end;
  {$EXTERNALSYM D3D11_BUFFER_RTV}
  TD3D11_BUFFER_RTV = D3D11_BUFFER_RTV;
  PD3D11_BUFFER_RTV = ^D3D11_BUFFER_RTV;

  D3D11_TEX1D_RTV = record
    MipSlice: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX1D_RTV}
  TD3D11_TEX1D_RTV = D3D11_TEX1D_RTV;
  PD3D11_TEX1D_RTV = ^D3D11_TEX1D_RTV;

  D3D11_TEX1D_ARRAY_RTV = record
    MipSlice: UINT;
    FirstArraySlice: UINT;
    ArraySize: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX1D_ARRAY_RTV}
  TD3D11_TEX1D_ARRAY_RTV = D3D11_TEX1D_ARRAY_RTV;
  PD3D11_TEX1D_ARRAY_RTV = ^D3D11_TEX1D_ARRAY_RTV;

  D3D11_TEX2D_RTV = record
    MipSlice: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2D_RTV}
  TD3D11_TEX2D_RTV = D3D11_TEX2D_RTV;
  PD3D11_TEX2D_RTV = ^D3D11_TEX2D_RTV;

  D3D11_TEX2DMS_RTV = record
    UnusedField_NothingToDefine: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2DMS_RTV}
  TD3D11_TEX2DMS_RTV = D3D11_TEX2DMS_RTV;
  PD3D11_TEX2DMS_RTV = ^D3D11_TEX2DMS_RTV;

  D3D11_TEX2D_ARRAY_RTV = record
    MipSlice: UINT;
    FirstArraySlice: UINT;
    ArraySize: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2D_ARRAY_RTV}
  TD3D11_TEX2D_ARRAY_RTV = D3D11_TEX2D_ARRAY_RTV;
  PD3D11_TEX2D_ARRAY_RTV = ^D3D11_TEX2D_ARRAY_RTV;

  D3D11_TEX2DMS_ARRAY_RTV = record
    FirstArraySlice: UINT;
    ArraySize: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2DMS_ARRAY_RTV}
  TD3D11_TEX2DMS_ARRAY_RTV = D3D11_TEX2DMS_ARRAY_RTV;
  PD3D11_TEX2DMS_ARRAY_RTV = ^D3D11_TEX2DMS_ARRAY_RTV;


  D3D11_TEX3D_RTV = record
    MipSlice: UINT;
    FirstWSlice: UINT;
    WSize: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX3D_RTV}
  TD3D11_TEX3D_RTV = D3D11_TEX3D_RTV;
  PD3D11_TEX3D_RTV = ^D3D11_TEX3D_RTV;

  D3D11_RENDER_TARGET_VIEW_DESC = record
    Format: DXGI_FORMAT;
    ViewDimension: D3D11_RTV_DIMENSION;
    public
      constructor Create(const o: D3D11_RENDER_TARGET_VIEW_DESC); overload;
      constructor Create(aViewDimension: D3D11_RTV_DIMENSION;
                aFormat: DXGI_FORMAT  = DXGI_FORMAT_UNKNOWN;
                aMipSlice: UINT = 0; (*FirstElement for BUFFER*)
                aFirstArraySlice: UINT = 0; (* NumElements for BUFFER, FirstWSlice for TEXTURE3D *)
                aArraySize: UINT = UINT(-1) (* WSize for TEXTURE3D *)
                ); overload;
      constructor Create(aBuffer: ID3D11Buffer; aFormat: DXGI_FORMAT;
                aFirstElement: UINT; aNumElements: UINT); overload;
      constructor Create(pTex1D: ID3D11Texture1D; aViewDimension: D3D11_RTV_DIMENSION;
                aFormat: DXGI_FORMAT = DXGI_FORMAT_UNKNOWN; aMipSlice: UINT = 0;
                aFirstArraySlice: UINT = 0; aArraySize: UINT = UINT(-1)); overload;
      constructor Create(pTex2D: ID3D11Texture2D; aViewDimension: D3D11_RTV_DIMENSION;
                aFormat: DXGI_FORMAT = DXGI_FORMAT_UNKNOWN; aMipSlice: UINT = 0;
                aFirstArraySlice: UINT = 0; aArraySize: UINT = UINT(-1)); overload;
      constructor Create(pTex3D: ID3D11Texture3D; aFormat: DXGI_FORMAT = DXGI_FORMAT_UNKNOWN;
                aMipSlice: UINT = 0; aFirstWSlice: UINT = 0; awSize: UINT = UINT(-1)); overload;
    case Byte of
      0: (Buffer: D3D11_BUFFER_RTV);
      1: (Texture1D: D3D11_TEX1D_RTV);
      2: (Texture1DArray: D3D11_TEX1D_ARRAY_RTV);
      3: (Texture2D: D3D11_TEX2D_RTV);
      4: (Texture2DArray: D3D11_TEX2D_ARRAY_RTV);
      5: (Texture2DMS: D3D11_TEX2DMS_RTV);
      6: (Texture2DMSArray: D3D11_TEX2DMS_ARRAY_RTV);
      7: (Texture3D: D3D11_TEX3D_RTV);
  end;
  {$EXTERNALSYM D3D11_RENDER_TARGET_VIEW_DESC}
  TD3D11_RENDER_TARGET_VIEW_DESC = D3D11_RENDER_TARGET_VIEW_DESC;
  PD3D11_RENDER_TARGET_VIEW_DESC = ^D3D11_RENDER_TARGET_VIEW_DESC;


// interface ID3D11RenderTargetView
// [unique][local][object][uuid]


  {$EXTERNALSYM IID_ID3D11RenderTargetView}
  IID_ID3D11RenderTargetView = ID3D11RenderTargetView;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11RenderTargetView);'}
  {$EXTERNALSYM ID3D11RenderTargetView}
  ID3D11RenderTargetView = interface(ID3D11View)
  ['{DFDBA067-0B8D-4865-875B-D7B4516CC164}']
    procedure GetDesc(out pDesc: D3D11_RENDER_TARGET_VIEW_DESC); stdcall;
  end;

// interface __MIDL_itf_d3d11_0000_0012
// [local]

  D3D11_TEX1D_DSV = record
    MipSlice: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX1D_DSV}
  TD3D11_TEX1D_DSV = D3D11_TEX1D_DSV;
  PD3D11_TEX1D_DSV = ^D3D11_TEX1D_DSV;

  D3D11_TEX1D_ARRAY_DSV = record
    MipSlice: UINT;
    FirstArraySlice: UINT;
    ArraySize: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX1D_ARRAY_DSV}
  TD3D11_TEX1D_ARRAY_DSV = D3D11_TEX1D_ARRAY_DSV;
  PD3D11_TEX1D_ARRAY_DSV = ^D3D11_TEX1D_ARRAY_DSV;

  D3D11_TEX2D_DSV = record
    MipSlice: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2D_DSV}
  TD3D11_TEX2D_DSV = D3D11_TEX2D_DSV;
  PD3D11_TEX2D_DSV = ^D3D11_TEX2D_DSV;

  D3D11_TEX2D_ARRAY_DSV = record
    MipSlice: UINT;
    FirstArraySlice: UINT;
    ArraySize: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2D_ARRAY_DSV}
  TD3D11_TEX2D_ARRAY_DSV = D3D11_TEX2D_ARRAY_DSV;
  PD3D11_TEX2D_ARRAY_DSV = ^D3D11_TEX2D_ARRAY_DSV;

  D3D11_TEX2DMS_DSV = record
    UnusedField_NothingToDefine: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2DMS_DSV}
  TD3D11_TEX2DMS_DSV = D3D11_TEX2DMS_DSV;
  PD3D11_TEX2DMS_DSV = ^D3D11_TEX2DMS_DSV;

  D3D11_TEX2DMS_ARRAY_DSV = record
    FirstArraySlice: UINT;
    ArraySize: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2DMS_ARRAY_DSV}
  TD3D11_TEX2DMS_ARRAY_DSV = D3D11_TEX2DMS_ARRAY_DSV;
  PD3D11_TEX2DMS_ARRAY_DSV = ^D3D11_TEX2DMS_ARRAY_DSV;

  D3D11_DSV_FLAG = (
    D3D11_DSV_READ_ONLY_DEPTH	= UINT($1),
  {$EXTERNALSYM D3D11_DSV_READ_ONLY_DEPTH}
    D3D11_DSV_READ_ONLY_STENCIL	= UINT($2));
  {$EXTERNALSYM D3D11_DSV_READ_ONLY_STENCIL}
  TD3D11_DSV_FLAG = D3D11_DSV_FLAG;
  {$EXTERNALSYM D3D11_DSV_FLAG}
  PD3D11_DSV_FLAG = ^D3D11_DSV_FLAG;

  D3D11_DEPTH_STENCIL_VIEW_DESC = record
    Format: DXGI_FORMAT;
    ViewDimension: D3D11_DSV_DIMENSION;
    Flags: UINT;
    public
      constructor Create(const o: D3D11_DEPTH_STENCIL_VIEW_DESC); overload;
      constructor Create(aViewDimension: D3D11_DSV_DIMENSION;
                  aFormat: DXGI_FORMAT = DXGI_FORMAT_UNKNOWN;
                  aMipSlice: UINT = 0; aFirstArraySlice: UINT = 0;
                  aArraySize : UINT = UINT(-1); aFlags: UINT = 0); overload;
      constructor Create(pTex1D: ID3D11Texture1D; aViewDimension: D3D11_DSV_DIMENSION;
                  aFormat: DXGI_FORMAT = DXGI_FORMAT_UNKNOWN;
                  aMipSlice: UINT = 0; aFirstArraySlice: UINT = 0; aArraySize: UINT = UINT(-1);
                  aFlags: UINT = 0); overload;
      constructor Create(pTex2D: ID3D11Texture2D; aViewDimension: D3D11_DSV_DIMENSION;
                  aFormat: DXGI_FORMAT = DXGI_FORMAT_UNKNOWN;
                  aMipSlice: UINT = 0; aFirstArraySlice: UINT = 0; aArraySize: UINT = UINT(-1);
                  aFlags: UINT = 0); overload;
    case Byte of
      0: (Texture1D: D3D11_TEX1D_DSV);
      1: (Texture1DArray: D3D11_TEX1D_ARRAY_DSV);
      2: (Texture2D: D3D11_TEX2D_DSV);
      3: (Texture2DArray: D3D11_TEX2D_ARRAY_DSV);
      4: (Texture2DMS: D3D11_TEX2DMS_DSV);
      5: (Texture2DMSArray: D3D11_TEX2DMS_ARRAY_DSV);
  end;
  {$EXTERNALSYM D3D11_DEPTH_STENCIL_VIEW_DESC}
  TD3D11_DEPTH_STENCIL_VIEW_DESC = D3D11_DEPTH_STENCIL_VIEW_DESC;
  PD3D11_DEPTH_STENCIL_VIEW_DESC = ^D3D11_DEPTH_STENCIL_VIEW_DESC;



// interface ID3D11DepthStencilView */
// [unique][local][object][uuid] */


  {$EXTERNALSYM IID_ID3D11DepthStencilView}
  IID_ID3D11DepthStencilView = ID3D11DepthStencilView;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11DepthStencilView);'}
  {$EXTERNALSYM ID3D11DepthStencilView}
  ID3D11DepthStencilView = interface(ID3D11View)
  ['{9FDAC92A-1876-48C3-AFAD-25B94F84A9B6}']
    procedure GetDesc(out pDesc: D3D11_DEPTH_STENCIL_VIEW_DESC); stdcall;
  end;

// interface __MIDL_itf_d3d11_0000_0013
// [local]

  D3D11_BUFFER_UAV_FLAG = (
    D3D11_BUFFER_UAV_FLAG_RAW	= $1,
  {$EXTERNALSYM D3D11_BUFFER_UAV_FLAG_RAW}
    D3D11_BUFFER_UAV_FLAG_APPEND	= $2,
  {$EXTERNALSYM D3D11_BUFFER_UAV_FLAG_APPEND}
    D3D11_BUFFER_UAV_FLAG_COUNTER	= $4);
  {$EXTERNALSYM D3D11_BUFFER_UAV_FLAG_COUNTER}
  TD3D11_BUFFER_UAV_FLAG = D3D11_BUFFER_UAV_FLAG;
  {$EXTERNALSYM D3D11_BUFFER_UAV_FLAG}

  D3D11_BUFFER_UAV = record
    FirstElement: UINT;
    NumElements: UINT;
    Flags: UINT;
  end;
  {$EXTERNALSYM D3D11_BUFFER_UAV}
  TD3D11_BUFFER_UAV = D3D11_BUFFER_UAV;
  PD3D11_BUFFER_UAV = ^D3D11_BUFFER_UAV;

  D3D11_TEX1D_UAV = record
    MipSlice: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX1D_UAV}
  TD3D11_TEX1D_UAV = D3D11_TEX1D_UAV;
  PD3D11_TEX1D_UAV = ^D3D11_TEX1D_UAV;

  D3D11_TEX1D_ARRAY_UAV = record
    MipSlice: UINT;
    FirstArraySlice: UINT;
    ArraySize: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX1D_ARRAY_UAV}
  TD3D11_TEX1D_ARRAY_UAV = D3D11_TEX1D_ARRAY_UAV;
  PD3D11_TEX1D_ARRAY_UAV = ^D3D11_TEX1D_ARRAY_UAV;

  D3D11_TEX2D_UAV = record
    MipSlice: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2D_UAV}
  TD3D11_TEX2D_UAV = D3D11_TEX2D_UAV;
  PD3D11_TEX2D_UAV = ^D3D11_TEX2D_UAV;

  D3D11_TEX2D_ARRAY_UAV = record
    MipSlice: UINT;
    FirstArraySlice: UINT;
    ArraySize: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX2D_ARRAY_UAV}
  TD3D11_TEX2D_ARRAY_UAV = D3D11_TEX2D_ARRAY_UAV;
  PD3D11_TEX2D_ARRAY_UAV = ^D3D11_TEX2D_ARRAY_UAV;

  D3D11_TEX3D_UAV = record
    MipSlice: UINT;
    FirstWSlice: UINT;
    WSize: UINT;
  end;
  {$EXTERNALSYM D3D11_TEX3D_UAV}
  TD3D11_TEX3D_UAV = D3D11_TEX3D_UAV;
  PD3D11_TEX3D_UAV = ^D3D11_TEX3D_UAV;

  D3D11_UNORDERED_ACCESS_VIEW_DESC = record
    Format: DXGI_FORMAT;
    ViewDimension: D3D11_UAV_DIMENSION;
    public
      constructor Create(const o: D3D11_UNORDERED_ACCESS_VIEW_DESC); overload;
      constructor Create(aViewDimension: D3D11_UAV_DIMENSION;
                  aFormat: DXGI_FORMAT = DXGI_FORMAT_UNKNOWN;
                  aMipSlice: UINT = 0; (* FirstElement for BUFFER *)
                  aFirstArraySlice: UINT = 0; (* NumElements for BUFFER, FirstWSlice for TEXTURE3D *)
                  aArraySize: UINT = UINT(-1); (* WSize for TEXTURE3D *)
                  aFlags: UINT = 0 (* BUFFER only *)); overload;
      constructor Create(aBuffer: ID3D11Buffer; aFormat: DXGI_FORMAT;
                  aFirstElement: UINT; aNumElements: UINT;
                  aFlags: UINT = 0); overload;
      constructor Create(pTex1D: ID3D11Texture1D; aViewDimension: D3D11_UAV_DIMENSION;
                  aFormat: DXGI_FORMAT = DXGI_FORMAT_UNKNOWN; aMipSlice : UINT = 0;
                  aFirstArraySlice: UINT = 0; aArraySize: UINT = UINT(-1)); overload;
      constructor Create(pTex2D: ID3D11Texture2D; aViewDimension: D3D11_UAV_DIMENSION;
                  aFormat: DXGI_FORMAT = DXGI_FORMAT_UNKNOWN; aMipSlice : UINT = 0;
                  aFirstArraySlice: UINT = 0; aArraySize: UINT = UINT(-1)); overload;
      constructor Create(pTex3D: ID3D11Texture3D;
                  aFormat: DXGI_FORMAT = DXGI_FORMAT_UNKNOWN; aMipSlice : UINT = 0;
                  aFirstWSlice: UINT = 0; awSize: UINT = UINT(-1)); overload;
    case Byte of
      0: (Buffer: D3D11_BUFFER_UAV);
      1: (Texture1D: D3D11_TEX1D_UAV);
      2: (Texture1DArray: D3D11_TEX1D_ARRAY_UAV);
      3: (Texture2D: D3D11_TEX2D_UAV);
      4: (Texture2DArray: D3D11_TEX2D_ARRAY_UAV);
      5: (Texture3D: D3D11_TEX3D_UAV);
  end;
  {$EXTERNALSYM D3D11_UNORDERED_ACCESS_VIEW_DESC}
  TD3D11_UNORDERED_ACCESS_VIEW_DESC = D3D11_UNORDERED_ACCESS_VIEW_DESC;
  PD3D11_UNORDERED_ACCESS_VIEW_DESC = ^D3D11_UNORDERED_ACCESS_VIEW_DESC;


// interface ID3D11UnorderedAccessView
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11UnorderedAccessView}
  IID_ID3D11UnorderedAccessView = ID3D11UnorderedAccessView;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11UnorderedAccessView);'}
  {$EXTERNALSYM ID3D11UnorderedAccessView}
  ID3D11UnorderedAccessView = interface(ID3D11View)
  ['{28ACF509-7F5C-48F6-8611-F316010A6380}']
    procedure GetDesc(out pDesc: D3D11_UNORDERED_ACCESS_VIEW_DESC); stdcall;
  end;

// interface ID3D11VertexShader
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11VertexShader}
  IID_ID3D11VertexShader = ID3D11VertexShader;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11VertexShader);'}
  {$EXTERNALSYM ID3D11VertexShader}
  ID3D11VertexShader = interface(ID3D11DeviceChild)
  ['{3B301D64-D678-4289-8897-22F8928B72F3}']
  end;


// interface ID3D11HullShader
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11HullShader}
  IID_ID3D11HullShader = ID3D11HullShader;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11HullShader);'}
  {$EXTERNALSYM ID3D11HullShader}
  ID3D11HullShader = interface(ID3D11DeviceChild)
  ['{8E5C6061-628A-4C8E-8264-BBE45CB3D5DD}']
  end;


// interface ID3D11DomainShader
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11DomainShader}
  IID_ID3D11DomainShader = ID3D11DomainShader;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11DomainShader);'}
  {$EXTERNALSYM ID3D11DomainShader}
  ID3D11DomainShader = interface(ID3D11DeviceChild)
  ['{F582C508-0F36-490C-9977-31EECE268CFA}']
  end;

// interface ID3D11GeometryShader
// [unique][local][object][uuid]


  {$EXTERNALSYM IID_ID3D11GeometryShader}
  IID_ID3D11GeometryShader = ID3D11GeometryShader;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11GeometryShader);'}
  {$EXTERNALSYM ID3D11GeometryShader}
  ID3D11GeometryShader = interface(ID3D11DeviceChild)
  ['{38325B96-EFFB-4022-BA02-2E795B70275C}']
  end;

// interface ID3D11PixelShader
// [unique][local][object][uuid]


  {$EXTERNALSYM IID_ID3D11PixelShader}
  IID_ID3D11PixelShader = ID3D11PixelShader;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11PixelShader);'}
  {$EXTERNALSYM ID3D11PixelShader}
  ID3D11PixelShader = interface(ID3D11DeviceChild)
  ['{EA82E40D-51DC-4F33-93D4-DB7C9125AE8C}']
  end;


// interface ID3D11ComputeShader
// [unique][local][object][uuid]


  {$EXTERNALSYM IID_ID3D11ComputeShader}
  IID_ID3D11ComputeShader = ID3D11ComputeShader;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11ComputeShader);'}
  {$EXTERNALSYM ID3D11ComputeShader}
  ID3D11ComputeShader = interface(ID3D11DeviceChild)
  ['{4F5B196E-C2BD-495E-BD01-1FDED38E4969}']
  end;
// interface ID3D11InputLayout
// [unique][local][object][uuid]


  {$EXTERNALSYM IID_ID3D11InputLayout}
  IID_ID3D11InputLayout = ID3D11InputLayout;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11InputLayout);'}
  {$EXTERNALSYM ID3D11InputLayout}
  ID3D11InputLayout = interface(ID3D11DeviceChild)
  ['{E4819DDC-4CF0-4025-BD26-5DE82A3E07B7}']
  end;


// interface __MIDL_itf_d3d11_0000_0021
// [local]


  D3D11_FILTER = (
    D3D11_FILTER_MIN_MAG_MIP_POINT	= 0,
  {$EXTERNALSYM D3D11_FILTER_MIN_MAG_MIP_POINT}
    D3D11_FILTER_MIN_MAG_POINT_MIP_LINEAR	= $1,
  {$EXTERNALSYM D3D11_FILTER_MIN_MAG_POINT_MIP_LINEAR}
    D3D11_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT	= $4,
  {$EXTERNALSYM D3D11_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT}
    D3D11_FILTER_MIN_POINT_MAG_MIP_LINEAR	= $5,
  {$EXTERNALSYM D3D11_FILTER_MIN_POINT_MAG_MIP_LINEAR}
    D3D11_FILTER_MIN_LINEAR_MAG_MIP_POINT	= $10,
  {$EXTERNALSYM D3D11_FILTER_MIN_LINEAR_MAG_MIP_POINT}
    D3D11_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR	= $11,
  {$EXTERNALSYM D3D11_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR}
    D3D11_FILTER_MIN_MAG_LINEAR_MIP_POINT	= $14,
  {$EXTERNALSYM D3D11_FILTER_MIN_MAG_LINEAR_MIP_POINT}
    D3D11_FILTER_MIN_MAG_MIP_LINEAR	= $15,
  {$EXTERNALSYM D3D11_FILTER_MIN_MAG_MIP_LINEAR}
    D3D11_FILTER_ANISOTROPIC	= $55,
  {$EXTERNALSYM D3D11_FILTER_ANISOTROPIC}
    D3D11_FILTER_COMPARISON_MIN_MAG_MIP_POINT	= $80,
  {$EXTERNALSYM D3D11_FILTER_COMPARISON_MIN_MAG_MIP_POINT}
    D3D11_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR	= $81,
  {$EXTERNALSYM D3D11_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR}
    D3D11_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT	= $84,
  {$EXTERNALSYM D3D11_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT}
    D3D11_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR	= $85,
  {$EXTERNALSYM D3D11_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR}
    D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT	= $90,
  {$EXTERNALSYM D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT}
    D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR	= $91,
  {$EXTERNALSYM D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR}
    D3D11_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT	= $94,
  {$EXTERNALSYM D3D11_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT}
    D3D11_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR	= $95,
  {$EXTERNALSYM D3D11_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR}
    D3D11_FILTER_COMPARISON_ANISOTROPIC	= $d5);
  {$EXTERNALSYM D3D11_FILTER_COMPARISON_ANISOTROPIC}
  TD3D11_FILTER = D3D11_FILTER;
  {$EXTERNALSYM D3D11_FILTER}

  D3D11_FILTER_TYPE = (
    D3D11_FILTER_TYPE_POINT	= 0,
  {$EXTERNALSYM D3D11_FILTER_TYPE_POINT}
    D3D11_FILTER_TYPE_LINEAR	= 1);
  {$EXTERNALSYM D3D11_FILTER_TYPE_LINEAR}
  TD3D11_FILTER_TYPE = D3D11_FILTER_TYPE;
  {$EXTERNALSYM D3D11_FILTER_TYPE}

  D3D11_TEXTURE_ADDRESS_MODE = (
    D3D11_TEXTURE_ADDRESS_WRAP	= 1,
  {$EXTERNALSYM D3D11_TEXTURE_ADDRESS_WRAP}
    D3D11_TEXTURE_ADDRESS_MIRROR	= 2,
  {$EXTERNALSYM D3D11_TEXTURE_ADDRESS_MIRROR}
    D3D11_TEXTURE_ADDRESS_CLAMP	= 3,
  {$EXTERNALSYM D3D11_TEXTURE_ADDRESS_CLAMP}
    D3D11_TEXTURE_ADDRESS_BORDER	= 4,
  {$EXTERNALSYM D3D11_TEXTURE_ADDRESS_BORDER}
    D3D11_TEXTURE_ADDRESS_MIRROR_ONCE	= 5);
  {$EXTERNALSYM D3D11_TEXTURE_ADDRESS_MIRROR_ONCE}
  TD3D11_TEXTURE_ADDRESS_MODE = D3D11_TEXTURE_ADDRESS_MODE;
  {$EXTERNALSYM D3D11_TEXTURE_ADDRESS_MODE}

  D3D11_SAMPLER_DESC = record
    Filter: D3D11_FILTER;
    AddressU: D3D11_TEXTURE_ADDRESS_MODE;
    AddressV: D3D11_TEXTURE_ADDRESS_MODE;
    AddressW: D3D11_TEXTURE_ADDRESS_MODE;
    MipLODBias: Single;
    MaxAnisotropy: UINT;
    ComparisonFunc: D3D11_COMPARISON_FUNC;
    BorderColor: array [0..3] of Single;
    MinLOD: Single;
    MaxLOD: Single;
    public
      constructor Create(const o: D3D11_SAMPLER_DESC); overload;
      constructor Create(isDefault: boolean); overload;
      constructor Create(
        aFilter: D3D11_FILTER;
        aAddressU: D3D11_TEXTURE_ADDRESS_MODE;
        aAddressV: D3D11_TEXTURE_ADDRESS_MODE;
        aAddressW: D3D11_TEXTURE_ADDRESS_MODE;
        aMipLODBias: Single;
        aMaxAnisotropy: UINT;
        aComparisonFunc: D3D11_COMPARISON_FUNC;
        (*_In_reads_opt_(4 )*) const aBorderColor: array of Single; // RGBA
        aMinLOD: Single;
        aMaxLOD: Single); overload;
  end;
  {$EXTERNALSYM D3D11_SAMPLER_DESC}
  TD3D11_SAMPLER_DESC = D3D11_SAMPLER_DESC;
  PD3D11_SAMPLER_DESC = ^D3D11_SAMPLER_DESC;


// interface ID3D11SamplerState
// [unique][local][object][uuid]


  {$EXTERNALSYM IID_ID3D11SamplerState}
  IID_ID3D11SamplerState = ID3D11SamplerState;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11SamplerState);'}
  {$EXTERNALSYM ID3D11SamplerState}
  ID3D11SamplerState = interface(ID3D11DeviceChild)
  ['{DA6FEA51-564C-4487-9810-F0D0F9B4E3A5}']
    procedure GetDesc(out pDesc: D3D11_SAMPLER_DESC); stdcall;
  end;

// interface __MIDL_itf_d3d11_0000_0022
// [local]

  D3D11_FORMAT_SUPPORT =(
    D3D11_FORMAT_SUPPORT_BUFFER	= $1,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_BUFFER}
    D3D11_FORMAT_SUPPORT_IA_VERTEX_BUFFER	= $2,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_IA_VERTEX_BUFFER}
    D3D11_FORMAT_SUPPORT_IA_INDEX_BUFFER	= $4,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_IA_INDEX_BUFFER}
    D3D11_FORMAT_SUPPORT_SO_BUFFER	= $8,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_SO_BUFFER}
    D3D11_FORMAT_SUPPORT_TEXTURE1D	= $10,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_TEXTURE1D}
    D3D11_FORMAT_SUPPORT_TEXTURE2D	= $20,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_TEXTURE2D}
    D3D11_FORMAT_SUPPORT_TEXTURE3D	= $40,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_TEXTURE3D}
    D3D11_FORMAT_SUPPORT_TEXTURECUBE	= $80,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_TEXTURECUBE}
    D3D11_FORMAT_SUPPORT_SHADER_LOAD	= $100,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_SHADER_LOAD}
    D3D11_FORMAT_SUPPORT_SHADER_SAMPLE	= $200,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_SHADER_SAMPLE}
    D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_COMPARISON	= $400,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_COMPARISON}
    D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_MONO_TEXT	= $800,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_MONO_TEXT}
    D3D11_FORMAT_SUPPORT_MIP	= $1000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_MIP}
    D3D11_FORMAT_SUPPORT_MIP_AUTOGEN	= $2000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_MIP_AUTOGEN}
    D3D11_FORMAT_SUPPORT_RENDER_TARGET	= $4000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_RENDER_TARGET}
    D3D11_FORMAT_SUPPORT_BLENDABLE	= $8000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_BLENDABLE}
    D3D11_FORMAT_SUPPORT_DEPTH_STENCIL	= $10000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_DEPTH_STENCIL}
    D3D11_FORMAT_SUPPORT_CPU_LOCKABLE	= $20000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_CPU_LOCKABLE}
    D3D11_FORMAT_SUPPORT_MULTISAMPLE_RESOLVE	= $40000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_MULTISAMPLE_RESOLVE}
    D3D11_FORMAT_SUPPORT_DISPLAY	= $80000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_DISPLAY}
    D3D11_FORMAT_SUPPORT_CAST_WITHIN_BIT_LAYOUT	= $100000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_CAST_WITHIN_BIT_LAYOUT}
    D3D11_FORMAT_SUPPORT_MULTISAMPLE_RENDERTARGET	= $200000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_MULTISAMPLE_RENDERTARGET}
    D3D11_FORMAT_SUPPORT_MULTISAMPLE_LOAD	= $400000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_MULTISAMPLE_LOAD}
    D3D11_FORMAT_SUPPORT_SHADER_GATHER	= $800000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_SHADER_GATHER}
    D3D11_FORMAT_SUPPORT_BACK_BUFFER_CAST	= $1000000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_BACK_BUFFER_CAST}
    D3D11_FORMAT_SUPPORT_TYPED_UNORDERED_ACCESS_VIEW	= $2000000,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_TYPED_UNORDERED_ACCESS_VIEW}
    D3D11_FORMAT_SUPPORT_SHADER_GATHER_COMPARISON	= $4000000);
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT_SHADER_GATHER_COMPARISON}

  TD3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT;
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT}

  D3D11_FORMAT_SUPPORT2 = (
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_ADD	= $1,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_ADD}
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_BITWISE_OPS	= $2,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_BITWISE_OPS}
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_COMPARE_STORE_OR_COMPARE_EXCHANGE	= $4,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_COMPARE_STORE_OR_COMPARE_EXCHANGE}
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_EXCHANGE	= $8,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_EXCHANGE}
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_SIGNED_MIN_OR_MAX	= $10,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_SIGNED_MIN_OR_MAX}
    D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_UNSIGNED_MIN_OR_MAX	= $20,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_UNSIGNED_MIN_OR_MAX}
    D3D11_FORMAT_SUPPORT2_UAV_TYPED_LOAD	= $40,
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT2_UAV_TYPED_LOAD}
    D3D11_FORMAT_SUPPORT2_UAV_TYPED_STORE	= $80);
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT2_UAV_TYPED_STORE}
  TD3D11_FORMAT_SUPPORT2 = D3D11_FORMAT_SUPPORT2;
  {$EXTERNALSYM D3D11_FORMAT_SUPPORT2}

///* interface ID3D11Asynchronous */
///* [unique][local][object][uuid] */


  {$EXTERNALSYM IID_ID3D11Asynchronous}
  IID_ID3D11Asynchronous = ID3D11Asynchronous;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11Asynchronous);'}
  {$EXTERNALSYM ID3D11Asynchronous}
  ID3D11Asynchronous = interface(ID3D11DeviceChild)
  ['{4B35D0CD-1E15-4258-9C98-1B1333F6DD3B}']
    function GetDataSize: UINT; stdcall;
  end;

// interface __MIDL_itf_d3d11_0000_0023
// [local]

  D3D11_ASYNC_GETDATA_FLAG = (
    D3D11_ASYNC_GETDATA_DONOTFLUSH	= $1);
  {$EXTERNALSYM D3D11_ASYNC_GETDATA_FLAG}
  TD3D11_ASYNC_GETDATA_FLAG = D3D11_ASYNC_GETDATA_FLAG;

  D3D11_QUERY = (
    D3D11_QUERY_EVENT	= 0,
  {$EXTERNALSYM D3D11_QUERY_EVENT}
    D3D11_QUERY_OCCLUSION	= (D3D11_QUERY_EVENT + 1),
  {$EXTERNALSYM D3D11_QUERY_OCCLUSION	}
    D3D11_QUERY_TIMESTAMP	= (D3D11_QUERY_OCCLUSION + 1),
  {$EXTERNALSYM D3D11_QUERY_TIMESTAMP	}
    D3D11_QUERY_TIMESTAMP_DISJOINT	= (D3D11_QUERY_TIMESTAMP + 1),
  {$EXTERNALSYM D3D11_QUERY_TIMESTAMP_DISJOINT}
    D3D11_QUERY_PIPELINE_STATISTICS	= (D3D11_QUERY_TIMESTAMP_DISJOINT + 1),
  {$EXTERNALSYM D3D11_QUERY_PIPELINE_STATISTICS	}
    D3D11_QUERY_OCCLUSION_PREDICATE	= (D3D11_QUERY_PIPELINE_STATISTICS + 1),
  {$EXTERNALSYM D3D11_QUERY_OCCLUSION_PREDICATE	}
    D3D11_QUERY_SO_STATISTICS	= (D3D11_QUERY_OCCLUSION_PREDICATE + 1),
  {$EXTERNALSYM D3D11_QUERY_SO_STATISTICS	}
    D3D11_QUERY_SO_OVERFLOW_PREDICATE	= (D3D11_QUERY_SO_STATISTICS + 1),
  {$EXTERNALSYM D3D11_QUERY_SO_OVERFLOW_PREDICATE	}
    D3D11_QUERY_SO_STATISTICS_STREAM0	= (D3D11_QUERY_SO_OVERFLOW_PREDICATE + 1),
  {$EXTERNALSYM D3D11_QUERY_SO_STATISTICS_STREAM0	}
    D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM0	= (D3D11_QUERY_SO_STATISTICS_STREAM0 + 1),
  {$EXTERNALSYM D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM0	}
    D3D11_QUERY_SO_STATISTICS_STREAM1	= (D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM0 + 1),
  {$EXTERNALSYM D3D11_QUERY_SO_STATISTICS_STREAM1	}
    D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM1	= (D3D11_QUERY_SO_STATISTICS_STREAM1 + 1),
  {$EXTERNALSYM D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM1	}
    D3D11_QUERY_SO_STATISTICS_STREAM2	= (D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM1 + 1),
  {$EXTERNALSYM D3D11_QUERY_SO_STATISTICS_STREAM2	}
    D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM2	= (D3D11_QUERY_SO_STATISTICS_STREAM2 + 1),
  {$EXTERNALSYM D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM2	}
    D3D11_QUERY_SO_STATISTICS_STREAM3	= (D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM2 + 1),
  {$EXTERNALSYM D3D11_QUERY_SO_STATISTICS_STREAM3	}
    D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM3	= (D3D11_QUERY_SO_STATISTICS_STREAM3 + 1));
  {$EXTERNALSYM D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM3	}
  TD3D11_QUERY = D3D11_QUERY;
  {$EXTERNALSYM D3D11_QUERY}


  D3D11_QUERY_MISC_FLAG = (
    D3D11_QUERY_MISC_PREDICATEHINT	= $1);
  {$EXTERNALSYM D3D11_QUERY_MISC_PREDICATEHINT}
  TD3D11_QUERY_MISC_FLAG = D3D11_QUERY_MISC_FLAG;
  {$EXTERNALSYM D3D11_QUERY_MISC_FLAG}

  D3D11_QUERY_DESC = record
    Query: D3D11_QUERY;
    MiscFlags: UINT;
    public
      constructor create(const o: D3D11_QUERY_DESC); overload;
      constructor create(aQuery: D3D11_QUERY; aMiscFlags: UINT = 0); overload;
  end;
  {$EXTERNALSYM D3D11_QUERY_DESC}
  TD3D11_QUERY_DESC = D3D11_QUERY_DESC;
  PD3D11_QUERY_DESC = ^D3D11_QUERY_DESC;

///* interface ID3D11Query */
///* [unique][local][object][uuid] */

  {$EXTERNALSYM IID_ID3D11Query}
  IID_ID3D11Query = ID3D11Query;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11Query);'}
  {$EXTERNALSYM ID3D11Query}
  ID3D11Query = interface(ID3D11Asynchronous)
  ['{D6C00747-87B7-425E-B84D-44D108560AFD}']
     procedure GetDesc(out pDesc: D3D11_QUERY_DESC); stdcall;
  end;


// interface ID3D11Predicate
// [unique][local][object][uuid]


  {$EXTERNALSYM IID_ID3D11Predicate}
  IID_ID3D11Predicate = ID3D11Predicate;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11Predicate);'}
  {$EXTERNALSYM ID3D11Predicate}
  ID3D11Predicate = interface(ID3D11Query)
  ['{9EB576DD-9F77-4D86-81AA-8BAB5FE490E2}']
  end;


// interface __MIDL_itf_d3d11_0000_0025
// [local]

  D3D11_QUERY_DATA_TIMESTAMP_DISJOINT = record
    Frequency: UINT64;
    Disjoint: BOOL;
  end;
  {$EXTERNALSYM D3D11_QUERY_DATA_TIMESTAMP_DISJOINT}
  TD3D11_QUERY_DATA_TIMESTAMP_DISJOINT = D3D11_QUERY_DATA_TIMESTAMP_DISJOINT;
  PD3D11_QUERY_DATA_TIMESTAMP_DISJOINT = ^D3D11_QUERY_DATA_TIMESTAMP_DISJOINT;

  D3D11_QUERY_DATA_PIPELINE_STATISTICS = record
    IAVertices: UINT64;
    IAPrimitives: UINT64;
    VSInvocations: UINT64;
    GSInvocations: UINT64;
    GSPrimitives: UINT64;
    CInvocations: UINT64;
    CPrimitives: UINT64;
    PSInvocations: UINT64;
    HSInvocations: UINT64;
    DSInvocations: UINT64;
    CSInvocations: UINT64;
  end;
  {$EXTERNALSYM D3D11_QUERY_DATA_PIPELINE_STATISTICS}
  TD3D11_QUERY_DATA_PIPELINE_STATISTICS = D3D11_QUERY_DATA_PIPELINE_STATISTICS;
  PD3D11_QUERY_DATA_PIPELINE_STATISTICS = ^D3D11_QUERY_DATA_PIPELINE_STATISTICS;

  D3D11_QUERY_DATA_SO_STATISTICS = record
    NumPrimitivesWritten: UINT64;
    PrimitivesStorageNeeded: UINT64;
  end;
  {$EXTERNALSYM D3D11_QUERY_DATA_SO_STATISTICS}
  TD3D11_QUERY_DATA_SO_STATISTICS = D3D11_QUERY_DATA_SO_STATISTICS;
  PD3D11_QUERY_DATA_SO_STATISTICS = ^D3D11_QUERY_DATA_SO_STATISTICS;

  D3D11_COUNTER = (
    D3D11_COUNTER_DEVICE_DEPENDENT_0	= $40000000);
  {$EXTERNALSYM D3D11_COUNTER}
  TD3D11_COUNTER = D3D11_COUNTER;


  D3D11_COUNTER_TYPE = (
    D3D11_COUNTER_TYPE_FLOAT32	= 0,
  {$EXTERNALSYM D3D11_COUNTER_TYPE_FLOAT32}
    D3D11_COUNTER_TYPE_UINT16	= (D3D11_COUNTER_TYPE_FLOAT32 + 1),
  {$EXTERNALSYM D3D11_COUNTER_TYPE_UINT16	=}
    D3D11_COUNTER_TYPE_UINT32	= (D3D11_COUNTER_TYPE_UINT16 + 1),
  {$EXTERNALSYM D3D11_COUNTER_TYPE_UINT32	=}
    D3D11_COUNTER_TYPE_UINT64	= (D3D11_COUNTER_TYPE_UINT32 + 1));
  {$EXTERNALSYM D3D11_COUNTER_TYPE_UINT64	=}
  TD3D11_COUNTER_TYPE = D3D11_COUNTER_TYPE;
  {$EXTERNALSYM D3D11_COUNTER_TYPE}

  D3D11_COUNTER_DESC = record
    Counter: D3D11_COUNTER;
    MiscFlags: UINT;
    public
      constructor Create(const o: D3D11_COUNTER_DESC); overload;
      constructor Create(aCounter: D3D11_COUNTER; aMiscFlags: UINT = 0); overload;
  end;
  {$EXTERNALSYM D3D11_COUNTER_DESC}
  TD3D11_COUNTER_DESC = D3D11_COUNTER_DESC;
  PD3D11_COUNTER_DESC = ^D3D11_COUNTER_DESC;

  D3D11_COUNTER_INFO = record
    LastDeviceDependentCounter: D3D11_COUNTER;
    NumSimultaneousCounters: UINT;
    NumDetectableParallelUnits: UINT8;
  end;
  {$EXTERNALSYM D3D11_COUNTER_INFO}
  TD3D11_COUNTER_INFO = D3D11_COUNTER_INFO;
  PD3D11_COUNTER_INFO = ^D3D11_COUNTER_INFO;

// interface ID3D11Counter
// [unique][local][object][uuid]


  {$EXTERNALSYM IID_ID3D11Counter}
  IID_ID3D11Counter = ID3D11Counter;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11Counter);'}
  {$EXTERNALSYM ID3D11Counter}
  ID3D11Counter = interface(ID3D11Asynchronous)
  ['{6E8C49FB-A371-4770-B440-29086022B741}']
    procedure GetDesc(out pDesc: D3D11_COUNTER_DESC); stdcall;
  end;

// interface __MIDL_itf_d3d11_0000_0026
// [local]


  D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS = Longword;
  {$EXTERNALSYM D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS}
  TD3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS = D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS;



  D3D11_DEVICE_CONTEXT_TYPE = (
    D3D11_DEVICE_CONTEXT_IMMEDIATE	= 0,
  {$EXTERNALSYM D3D11_DEVICE_CONTEXT_IMMEDIATE}
    D3D11_DEVICE_CONTEXT_DEFERRED	= (D3D11_DEVICE_CONTEXT_IMMEDIATE + 1));
  {$EXTERNALSYM D3D11_DEVICE_CONTEXT_DEFERRED}
  TD3D11_DEVICE_CONTEXT_TYPE = D3D11_DEVICE_CONTEXT_TYPE;
  {$EXTERNALSYM D3D11_DEVICE_CONTEXT_TYPE}

  D3D11_CLASS_INSTANCE_DESC = record
    InstanceId: UINT;
    InstanceIndex: UINT;
    TypeId: UINT;
    ConstantBuffer: UINT;
    BaseConstantBufferOffset: UINT;
    BaseTexture: UINT;
    BaseSampler: UINT;
    Created: BOOL;
  end;
  {$EXTERNALSYM D3D11_CLASS_INSTANCE_DESC}
  TD3D11_CLASS_INSTANCE_DESC = D3D11_CLASS_INSTANCE_DESC;
  PD3D11_CLASS_INSTANCE_DESC = ^D3D11_CLASS_INSTANCE_DESC;


// interface ID3D11ClassInstance
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11ClassInstance}
  IID_ID3D11ClassInstance = ID3D11ClassInstance;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11ClassInstance);'}
  {$EXTERNALSYM ID3D11ClassInstance}
  ID3D11ClassInstance = interface(ID3D11DeviceChild)
  ['{A6CD7FAA-B0B7-4A2F-9436-8662A65797CB}']
    procedure GetClassLinkage(
        out ppLinkage: ID3D11ClassLinkage); stdcall;

    procedure GetDesc(
        out pDesc: D3D11_CLASS_INSTANCE_DESC); stdcall;

    procedure GetInstanceName(
        (*_Out_writes_opt_(*pBufferLength)*)  out pInstanceName: LPSTR;
        (*_Inout_*)  var pBufferLength: SIZE_T); stdcall;

    procedure GetTypeName(
        (*_Out_writes_opt_(*pBufferLength) *) out pTypeName: LPSTR;
        (*_Inout_*)  var pBufferLength: SIZE_T); stdcall;
  end;


// interface ID3D11ClassLinkage
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11ClassLinkage}
  IID_ID3D11ClassLinkage = ID3D11ClassLinkage;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11ClassLinkage);'}
  {$EXTERNALSYM ID3D11ClassLinkage}
  ID3D11ClassLinkage = interface(ID3D11DeviceChild)
  ['{DDF57CBA-9543-46E4-A12B-F207A0FE7FED}']
    function GetClassInstance(
    (*_In_*)  const pClassInstanceName: LPCSTR;
    (*_In_*)  const InstanceIndex: UINT;
    (*_Out_*)  out ppInstance: ID3D11ClassInstance): HRESULT; stdcall;

    function CreateClassInstance(
        (*_In_*)  const pClassTypeName: LPCSTR;
        (*_In_*)  const ConstantBufferOffset: UINT;
        (*_In_*)  const ConstantVectorOffset: UINT;
        (*_In_*)  const TextureOffset: UINT;
        (*_In_*)  const SamplerOffset: UINT;
        (*_Out_*) out ppInstance: ID3D11ClassInstance): HRESULT; stdcall;
  end;

// interface ID3D11CommandList
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11CommandList}
  IID_ID3D11CommandList = ID3D11CommandList;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11CommandList);'}
  {$EXTERNALSYM ID3D11CommandList}
  ID3D11CommandList = interface(ID3D11DeviceChild)
  ['{A24BC4D1-769E-43F7-8013-98FF566C18E2}']
    function GetContextFlags(): UINT; stdcall;
  end;

// interface __MIDL_itf_d3d11_0000_0029
// [local]

  D3D11_FEATURE = (
    D3D11_FEATURE_THREADING	= 0,
  {$EXTERNALSYM D3D11_FEATURE_THREADING}
    D3D11_FEATURE_DOUBLES	= (D3D11_FEATURE_THREADING + 1),
  {$EXTERNALSYM D3D11_FEATURE_DOUBLES	}
    D3D11_FEATURE_FORMAT_SUPPORT	= (D3D11_FEATURE_DOUBLES + 1),
  {$EXTERNALSYM D3D11_FEATURE_FORMAT_SUPPORT}
    D3D11_FEATURE_FORMAT_SUPPORT2	= (D3D11_FEATURE_FORMAT_SUPPORT + 1),
  {$EXTERNALSYM D3D11_FEATURE_FORMAT_SUPPORT2	}
    D3D11_FEATURE_D3D10_X_HARDWARE_OPTIONS	= (D3D11_FEATURE_FORMAT_SUPPORT2 + 1));
  {$EXTERNALSYM D3D11_FEATURE_D3D10_X_HARDWARE_OPTIONS}
  TD3D11_FEATURE = D3D11_FEATURE;
  {$EXTERNALSYM D3D11_FEATURE}

  D3D11_FEATURE_DATA_THREADING = record
    DriverConcurrentCreates: BOOL;
    DriverCommandLists: BOOL;
  end;
  {$EXTERNALSYM D3D11_FEATURE_DATA_THREADING}
  TD3D11_FEATURE_DATA_THREADING = D3D11_FEATURE_DATA_THREADING;
  PD3D11_FEATURE_DATA_THREADING = ^D3D11_FEATURE_DATA_THREADING;

  D3D11_FEATURE_DATA_DOUBLES = record
    DoublePrecisionFloatShaderOps: BOOL;
  end;
  {$EXTERNALSYM D3D11_FEATURE_DATA_DOUBLES}
  TD3D11_FEATURE_DATA_DOUBLES = D3D11_FEATURE_DATA_DOUBLES;
  PD3D11_FEATURE_DATA_DOUBLES = ^D3D11_FEATURE_DATA_DOUBLES;

  D3D11_FEATURE_DATA_FORMAT_SUPPORT = record
    InFormat: DXGI_FORMAT;
    OutFormatSupport: UINT;
  end;
  {$EXTERNALSYM D3D11_FEATURE_DATA_FORMAT_SUPPORT}
  TD3D11_FEATURE_DATA_FORMAT_SUPPORT = D3D11_FEATURE_DATA_FORMAT_SUPPORT;
  PD3D11_FEATURE_DATA_FORMAT_SUPPORT = ^D3D11_FEATURE_DATA_FORMAT_SUPPORT;

  D3D11_FEATURE_DATA_FORMAT_SUPPORT2 = record
    InFormat: DXGI_FORMAT;
    OutFormatSupport2: UINT;
  end;
  {$EXTERNALSYM D3D11_FEATURE_DATA_FORMAT_SUPPORT2}
  TD3D11_FEATURE_DATA_FORMAT_SUPPORT2 = D3D11_FEATURE_DATA_FORMAT_SUPPORT2;
  PD3D11_FEATURE_DATA_FORMAT_SUPPORT2 = ^D3D11_FEATURE_DATA_FORMAT_SUPPORT2;

  D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS = record
    ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x: BOOL;
  end;
  {$EXTERNALSYM D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS}
  TD3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS = D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS;
  PD3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS = ^D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS;

// interface ID3D11DeviceContext
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11DeviceContext}
  IID_ID3D11DeviceContext = ID3D11DeviceContext;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11DeviceContext);'}
  {$EXTERNALSYM ID3D11DeviceContext}
  ID3D11DeviceContext = interface(ID3D11DeviceChild)
  ['{C0BFA96C-E089-44FB-8EAF-26F8796190DA}']
    procedure VSSetConstantBuffers(
        (*_In_range_(0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )*)
        const StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )*)
        const NumBuffers: UINT;
        (*_In_reads_opt_(NumBuffers)*)
        const [Ref] ppConstantBuffers: ID3D11Buffer); stdcall;

    procedure PSSetShaderResources(
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        const StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        const NumViews: UINT;
        (*_In_reads_opt_(NumViews)*)
        const [Ref] ppShaderResourceViews: ID3D11ShaderResourceView); stdcall;

    procedure PSSetShader(
        (*_In_opt_*)
        pPixelShader: ID3D11PixelShader;
        (*_In_reads_opt_(NumClassInstances)*)
        const [Ref] ppClassInstances: ID3D11ClassInstance;
        NumClassInstances: UINT); stdcall;

    procedure PSSetSamplers(
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_(0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )*)
        NumSamplers: UINT;
        (*_In_reads_opt_(NumSamplers)*)
        const [Ref] ppSamplers: ID3D11SamplerState); stdcall;

    procedure VSSetShader(
        (*_In_opt_*)
        pVertexShader: ID3D11VertexShader;
        (*_In_reads_opt_(NumClassInstances)*)
        const [Ref] ppClassInstances: ID3D11ClassInstance;
        NumClassInstances: UINT); stdcall;

    procedure DrawIndexed(
        (*_In_*)  IndexCount: UINT;
        (*_In_*)  StartIndexLocation: UINT;
        (*_In_*)  BaseVertexLocation: Integer); stdcall;

    procedure Draw(
        (*_In_*)  VertexCount: UINT;
        (*_In_*)  StartVertexLocation: UINT); stdcall;

    function Map(
        (*_In_*)  pResource: ID3D11Resource;
        (*_In_*)  Subresource: UINT;
        (*_In_*)  MapType: D3D11_MAP;
        (*_In_*)  MapFlags: UINT;
        (*_Out_*)  out pMappedResource: D3D11_MAPPED_SUBRESOURCE): HRESULT ; stdcall;

    procedure Unmap(
        (*_In_*)  pResource: ID3D11Resource;
        (*_In_*)  Subresource: UINT); stdcall;

    procedure PSSetConstantBuffers(
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )*)
        NumBuffers: UINT;
        (*_In_reads_opt_(NumBuffers)*)
        const [Ref] ppConstantBuffers: ID3D11Buffer); stdcall;

    procedure IASetInputLayout(
        (*_In_opt_*)  pInputLayout: ID3D11InputLayout); stdcall;

    procedure IASetVertexBuffers(
        (*_In_range_( 0, D3D11_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        NumBuffers: UINT;
        (*_In_reads_opt_(NumBuffers)*)
        const [Ref] ppVertexBuffers: ID3D11Buffer;
        (*_In_reads_opt_(NumBuffers)*)
        const pStrides: PUINT;
        (*_In_reads_opt_(NumBuffers)*)
        const pOffsets: PUINT); stdcall;

    procedure IASetIndexBuffer(
        (*_In_opt_*)  pIndexBuffer: ID3D11Buffer;
        (*_In_*)  Format: DXGI_FORMAT;
        (*_In_*)  Offset: UINT); stdcall;

    procedure DrawIndexedInstanced(
        (*_In_*) IndexCountPerInstance: UINT;
        (*_In_*) InstanceCount: UINT;
        (*_In_*) StartIndexLocation: UINT;
        (*_In_*) BaseVertexLocation: Integer;
        (*_In_*) StartInstanceLocation: UINT); stdcall;

    procedure DrawInstanced(
        (*_In_*) VertexCountPerInstance: UINT;
        (*_In_*) InstanceCount: UINT;
        (*_In_*) StartVertexLocation: UINT;
        (*_In_*) StartInstanceLocation: UINT); stdcall;

    procedure GSSetConstantBuffers(
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )*)
        NumBuffers: UINT;
        (*_In_reads_opt_(NumBuffers)*)
        const [Ref] ppConstantBuffers: ID3D11Buffer); stdcall;

    procedure GSSetShader(
        (*_In_opt_*)
        pShader: ID3D11GeometryShader;
        (*_In_reads_opt_(NumClassInstances)*)
        const [Ref] ppClassInstances: ID3D11ClassInstance;
        NumClassInstances: UINT); stdcall;

    procedure IASetPrimitiveTopology(
        (*_In_*)  Topology: D3D11_PRIMITIVE_TOPOLOGY); stdcall;

    procedure VSSetShaderResources(
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        NumViews: UINT;
        (*_In_reads_opt_(NumViews)*)
        const [Ref] ppShaderResourceViews: ID3D11ShaderResourceView); stdcall;

    procedure VSSetSamplers(
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )*)
        NumSamplers: UINT;
        (*_In_reads_opt_(NumSamplers)*)
        const [Ref] ppSamplers: ID3D11SamplerState); stdcall;

    procedure  _Begin(
        (*_In_*)  pAsync: ID3D11Asynchronous); stdcall;

    procedure _End(
        (*_In_*)  pAsync: ID3D11Asynchronous); stdcall;

    function GetData(
        (*_In_*)  pAsync: ID3D11Asynchronous;
        (*_Out_writes_bytes_opt_( DataSize )*) pData: Pointer;
        (*_In_*)  DataSize: UINT;
        (*_In_*)  GetDataFlags: UINT): HRESULT; stdcall;

    procedure SetPredication(
        (*_In_opt_*)  pPredicate: ID3D11Predicate;
        (*_In_*)  PredicateValue: BOOL); stdcall;

    procedure GSSetShaderResources(
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        NumViews: UINT;
        (*_In_reads_opt_(NumViews)*)
        const [Ref] ppShaderResourceViews: ID3D11ShaderResourceView); stdcall;

    procedure GSSetSamplers(
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )*)
        NumSamplers: UINT;
        (*_In_reads_opt_(NumSamplers)*)
        const [Ref] ppSamplers: ID3D11SamplerState); stdcall;

    procedure OMSetRenderTargets(
       (*_In_range_( 0, D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT )*)
        NumViews: UINT;
        (*_In_reads_opt_(NumViews)*)
        const [Ref] ppRenderTargetViews: ID3D11RenderTargetView;
        (*_In_opt_*)
        pDepthStencilView: ID3D11DepthStencilView); stdcall;

    procedure OMSetRenderTargetsAndUnorderedAccessViews(
        (*_In_*)  NumRTVs: UINT;
        (*_In_reads_opt_(NumRTVs)*)  const [Ref] ppRenderTargetViews: ID3D11RenderTargetView;
        (*_In_opt_*)  pDepthStencilView: ID3D11DepthStencilView;
        (*_In_range_( 0, D3D11_1_UAV_SLOT_COUNT - 1 )*)  UAVStartSlot: UINT;
        (*_In_*)  NumUAVs: UINT;
        (*_In_reads_opt_(NumUAVs)*)  const [Ref] ppUnorderedAccessViews: ID3D11UnorderedAccessView;
        (*_In_reads_opt_(NumUAVs)*)  const pUAVInitialCounts: PUINT); stdcall;

    procedure OMSetBlendState(
        (*_In_opt_*)  pBlendState: ID3D11BlendState;
        (*_In_opt_*)  const BlendFactor: TFourSingleArray;
        (*_In_*)  SampleMask: UINT); stdcall;

    procedure OMSetDepthStencilState(
        (*_In_opt_*)  pDepthStencilState: ID3D11DepthStencilState;
        (*_In_*) StencilRef: UINT); stdcall;

    procedure SOSetTargets(
        (*_In_range_( 0, D3D11_SO_BUFFER_SLOT_COUNT)*)  NumBuffers: UINT;
        (*_In_reads_opt_(NumBuffers)*)  const [Ref] ppSOTargets: ID3D11Buffer;
        (*_In_reads_opt_(NumBuffers)*)  const pOffsets: PUINT); stdcall;

    procedure DrawAuto(); stdcall;

    procedure  DrawIndexedInstancedIndirect(
        (*_In_*)  pBufferForArgs: ID3D11Buffer;
        (*_In_*)  AlignedByteOffsetForArgs: UINT); stdcall;

    procedure DrawInstancedIndirect(
        (*_In_*)  pBufferForArgs: ID3D11Buffer;
        (*_In_*)  AlignedByteOffsetForArgs: UINT); stdcall;

    procedure Dispatch(
        (*_In_*)  ThreadGroupCountX: UINT;
        (*_In_*)  ThreadGroupCountY: UINT;
        (*_In_*)  ThreadGroupCountZ: UINT); stdcall;

    procedure DispatchIndirect(
        (*_In_*)  pBufferForArgs: ID3D11Buffer;
        (*_In_*)  AlignedByteOffsetForArgs: UINT); stdcall;

    procedure RSSetState(
        (*_In_opt_*)  pRasterizerState: ID3D11RasterizerState); stdcall;

    procedure RSSetViewports(
        (*_In_range_(0, D3D11_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE)*)  NumViewports: UINT;
        (*_In_reads_opt_(NumViewports)*)  const pViewports: PD3D11_VIEWPORT); stdcall;

    procedure RSSetScissorRects(
        (*_In_range_(0, D3D11_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE)*)  NumRects: UINT;
        (*_In_reads_opt_(NumRects)*)  const pRects: PD3D11_RECT); stdcall;

    procedure CopySubresourceRegion(
        (*_In_*)  const pDstResource: ID3D11Resource;
        (*_In_*)  DstSubresource: UINT;
        (*_In_*)  DstX: UINT;
        (*_In_*)  DstY: UINT;
        (*_In_*)  DstZ: UINT;
        (*_In_*)  const pSrcResource: ID3D11Resource;
        (*_In_*)  SrcSubresource: UINT;
        (*_In_opt_*)  const pSrcBox: PD3D11_BOX); stdcall;

    procedure CopyResource(
        (*_In_*)  pDstResource: ID3D11Resource;
        (*_In_*)  pSrcResource: ID3D11Resource); stdcall;

    procedure  UpdateSubresource(
        (*_In_*)  pDstResource: ID3D11Resource;
        (*_In_*)  DstSubresource: UINT;
        (*_In_opt_*)  const pDstBox: PD3D11_BOX;
        (*_In_*)  const pSrcData: Pointer;
        (*_In_*)  SrcRowPitch: UINT;
        (*_In_*)  SrcDepthPitch: UINT); stdcall;

    procedure CopyStructureCount(
        (*_In_*)  pDstBuffer: ID3D11Buffer;
        (*_In_*)  DstAlignedByteOffset: UINT;
        (*_In_*)  pSrcView: ID3D11UnorderedAccessView); stdcall;

    procedure ClearRenderTargetView(
        (*_In_*)  pRenderTargetView: ID3D11RenderTargetView;
        (*_In_*)  const ColorRGBA: TFourSingleArray); stdcall;

    procedure ClearUnorderedAccessViewUint(
        (*_In_*)  pUnorderedAccessView: ID3D11UnorderedAccessView;
        (*_In_*)  const Values: TFourUIntArray); stdcall;

    procedure ClearUnorderedAccessViewFloat(
        (*_In_*)  pUnorderedAccessView: ID3D11UnorderedAccessView;
        (*_In_*)  const Values: TFourSingleArray); stdcall;

    procedure ClearDepthStencilView(
        (*_In_*)  pDepthStencilView: ID3D11DepthStencilView;
        (*_In_*)  ClearFlags: UINT;
        (*_In_*)  Depth: Single;
        (*_In_*)  Stencil: UINT8); stdcall;

    procedure GenerateMips(
        (*_In_*)  pShaderResourceView: ID3D11ShaderResourceView); stdcall;

    procedure SetResourceMinLOD(
        (*_In_*)  pResource: ID3D11Resource;
        MinLOD: Single); stdcall;

    function GetResourceMinLOD(
        (*_In_*)  pResource: ID3D11Resource): Single; stdcall;

    procedure ResolveSubresource(
        (*_In_*)  pDstResource: ID3D11Resource;
        (*_In_*)  DstSubresource: UINT;
        (*_In_*)  pSrcResource: ID3D11Resource;
        (*_In_*)  SrcSubresource: UINT;
        (*_In_*)  Format: DXGI_FORMAT); stdcall;

    procedure ExecuteCommandList(
        (*_In_*)  pCommandList: ID3D11CommandList;
        RestoreContextState: BOOL); stdcall;

    procedure HSSetShaderResources(
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        NumViews: UINT;
        (*_In_reads_opt_(NumViews)*)
        const [Ref] ppShaderResourceViews: ID3D11ShaderResourceView); stdcall;

    procedure HSSetShader(
        (*_In_opt_*)
        pHullShader : ID3D11HullShader;
        (*_In_reads_opt_(NumClassInstances)*)
        const [Ref] ppClassInstances: ID3D11ClassInstance;
        NumClassInstances: UINT); stdcall;

    procedure HSSetSamplers(
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 ) *)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot ) *)
        NumSamplers: UINT;
        (*_In_reads_opt_(NumSamplers)  *)
        const [Ref] ppSamplers: ID3D11SamplerState); stdcall;

    procedure HSSetConstantBuffers(
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )*)
        NumBuffers: UINT;
        (*_In_reads_opt_(NumBuffers)*)
        const [Ref] ppConstantBuffers: ID3D11Buffer); stdcall;

    procedure DSSetShaderResources(
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        NumViews: UINT;
        (*_In_reads_opt_(NumViews)*)
        const [Ref] ppShaderResourceViews: ID3D11ShaderResourceView); stdcall;

    procedure DSSetShader(
        (*_In_opt_*)
        pDomainShader: ID3D11DomainShader;
        (*_In_reads_opt_(NumClassInstances)*)
        const [Ref] ppClassInstances: ID3D11ClassInstance;
        NumClassInstances: UINT); stdcall;

    procedure  DSSetSamplers(
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )*)
        NumSamplers: UINT;
        (*_In_reads_opt_(NumSamplers)*)
        const [Ref] ppSamplers: ID3D11SamplerState); stdcall;

    procedure DSSetConstantBuffers(
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )*)
        NumBuffers: UINT;
        (*_In_reads_opt_(NumBuffers)*)
        const [Ref] ppConstantBuffers: ID3D11Buffer); stdcall;

    procedure CSSetShaderResources(
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        NumViews: UINT;
        (*_In_reads_opt_(NumViews)*)
        const [Ref] ppShaderResourceViews: ID3D11ShaderResourceView); stdcall;

    procedure CSSetUnorderedAccessViews(
        (*_In_range_( 0, D3D11_1_UAV_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_1_UAV_SLOT_COUNT - StartSlot )*)
        NumUAVs: UINT;
        (*_In_reads_opt_(NumUAVs)*)
        const [Ref] ppUnorderedAccessViews: ID3D11UnorderedAccessView;
        (*_In_reads_opt_(NumUAVs)*)
        const pUAVInitialCounts: PUINT); stdcall;

    procedure CSSetShader(
        (*_In_opt_*)
        pComputeShader: ID3D11ComputeShader;
        (*_In_reads_opt_(NumClassInstances)*)
        const [Ref] ppClassInstances: ID3D11ClassInstance;
        NumClassInstances: UINT); stdcall;

    procedure CSSetSamplers(
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )*)
        NumSamplers: UINT;
        (*_In_reads_opt_(NumSamplers)*)
        const [Ref] ppSamplers: ID3D11SamplerState);

    procedure CSSetConstantBuffers(
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )*)
        NumBuffers: UINT;
        (*_In_reads_opt_(NumBuffers)*)
        const [Ref] ppConstantBuffers: ID3D11Buffer); stdcall;

    procedure VSGetConstantBuffers(
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )*)
        NumBuffers: UINT;
        (*_Out_writes_opt_(NumBuffers)*)
        out ppConstantBuffers: ID3D11Buffer); stdcall;

    procedure PSGetShaderResources(
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        NumViews: UINT;
        (*_Out_writes_opt_(NumViews)*)
        out ppShaderResourceViews: ID3D11ShaderResourceView); stdcall;

    procedure PSGetShader(
        (*_Out_*)
        out ppPixelShader: ID3D11PixelShader;
        (*_Out_writes_opt_(*pNumClassInstances)*)
        out ppClassInstances: ID3D11ClassInstance;
        (*_Inout_opt_*)
        var pNumClassInstances: UINT); stdcall;

    procedure PSGetSamplers(
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )*)
        NumSamplers: UINT;
        (*_Out_writes_opt_(NumSamplers)*)
        out ppSamplers: ID3D11SamplerState); stdcall;

    procedure VSGetShader(
        (*_Out_*)
        out ppVertexShader: ID3D11VertexShader;
        (*_Out_writes_opt_(*pNumClassInstances)*)
        out ppClassInstances: ID3D11ClassInstance;
        (*_Inout_opt_*)
        var pNumClassInstances: UINT); stdcall;

    procedure PSGetConstantBuffers(
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )*)
        NumBuffers: UINT;
        (*_Out_writes_opt_(NumBuffers)*)
        out ppConstantBuffers: ID3D11Buffer); stdcall;

    procedure IAGetInputLayout(
        (*_Out_*)  out ppInputLayout: ID3D11InputLayout); stdcall;

    procedure IAGetVertexBuffers(
        (*_In_range_( 0, D3D11_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        NumBuffers: UINT;
        (*_Out_writes_opt_(NumBuffers)*)
        out ppVertexBuffers: ID3D11Buffer;
        (*_Out_writes_opt_(NumBuffers)*)
        out pStrides: UINT;
        (*_Out_writes_opt_(NumBuffers)*)
        out pOffsets: UINT); stdcall;

    procedure IAGetIndexBuffer(
        (*_Out_opt_*)  out pIndexBuffer: ID3D11Buffer;
        (*_Out_opt_*)  out Format: DXGI_FORMAT;
        (*_Out_opt_*)  out Offset: UINT); stdcall;

    procedure GSGetConstantBuffers(
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )*)
        NumBuffers: UINT;
        (*_Out_writes_opt_(NumBuffers)*)
        out ppConstantBuffers: ID3D11Buffer); stdcall;

    procedure GSGetShader(
        (*_Out_*)
        out ppGeometryShader: ID3D11GeometryShader;
        (*_Out_writes_opt_(*pNumClassInstances)*)
        out ppClassInstances: ID3D11ClassInstance;
        (*_Inout_opt_*)
        var pNumClassInstances: UINT); stdcall;

    procedure IAGetPrimitiveTopology(
        (*_Out_*)  out pTopology: D3D11_PRIMITIVE_TOPOLOGY); stdcall;

    procedure VSGetShaderResources(
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        NumViews: UINT;
        (*_Out_writes_opt_(NumViews)*)
        out ppShaderResourceViews: ID3D11ShaderResourceView); stdcall;

    procedure VSGetSamplers(
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )*)
        NumSamplers: UINT;
        (*_Out_writes_opt_(NumSamplers)*)
        out ppSamplers: ID3D11SamplerState); stdcall;

    procedure GetPredication(
        (*_Out_opt_*)  out ppPredicate: ID3D11Predicate;
        (*_Out_opt_*)  out pPredicateValue: BOOL); stdcall;

    procedure GSGetShaderResources(
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        NumViews: UINT;
        (*_Out_writes_opt_(NumViews)*)
        out ppShaderResourceViews: ID3D11ShaderResourceView); stdcall;

    procedure GSGetSamplers(
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )*)
        NumSamplers: UINT;
        (*_Out_writes_opt_(NumSamplers)*)
        out ppSamplers: ID3D11SamplerState); stdcall;

    procedure OMGetRenderTargets(
        (*_In_range_( 0, D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT )*)
        NumViews: UINT;
        (*_Out_writes_opt_(NumViews)*)
        out ppRenderTargetViews: ID3D11RenderTargetView;
        (*_Out_opt_*)
        out ppDepthStencilView: ID3D11DepthStencilView); stdcall;

    procedure OMGetRenderTargetsAndUnorderedAccessViews(
        (*_In_range_( 0, D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT )*)
        NumRTVs: UINT;
        (*_Out_writes_opt_(NumRTVs)*)
        out ppRenderTargetViews: ID3D11RenderTargetView;
        (*_Out_opt_*)
        out ppDepthStencilView: ID3D11DepthStencilView;
        (*_In_range_( 0, D3D11_PS_CS_UAV_REGISTER_COUNT - 1 )*)
        UAVStartSlot: UINT;
        (*_In_range_( 0, D3D11_PS_CS_UAV_REGISTER_COUNT - UAVStartSlot )*)
        NumUAVs: UINT;
        (*_Out_writes_opt_(NumUAVs)*)
        out ppUnorderedAccessViews: ID3D11UnorderedAccessView); stdcall;

    procedure OMGetBlendState(
        (*_Out_opt_*)  out ppBlendState: ID3D11BlendState;
        (*_Out_opt_*)  out BlendFactor: TFourSingleArray;
        (*_Out_opt_*)  out pSampleMask: UINT); stdcall;

    procedure OMGetDepthStencilState(
        (*_Out_opt_*)
        out ppDepthStencilState: ID3D11DepthStencilState;
        (*_Out_opt_*)
        out pStencilRef: UINT); stdcall;

    procedure SOGetTargets(
        (*_In_range_( 0, D3D11_SO_BUFFER_SLOT_COUNT )*)
        NumBuffers: UINT;
        (*_Out_writes_opt_(NumBuffers)*)
        out ppSOTargets: ID3D11Buffer); stdcall;

    procedure RSGetState(
        (*_Out_*)
        out ppRasterizerState: ID3D11RasterizerState); stdcall;

    procedure RSGetViewports(
        (*_Inout_ /*_range(0, D3D11_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE )*/*)
        var pNumViewports: UINT;
        (*_Out_writes_opt_(*pNumViewports)*)
        pViewports: PD3D11_VIEWPORT); stdcall;

    procedure  RSGetScissorRects(
        (*_Inout_ /*_range(0, D3D11_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE )*/*)
        var pNumRects: UINT;
        (*_Out_writes_opt_(*pNumRects)*)
        out pRects: D3D11_RECT); stdcall;

    procedure HSGetShaderResources(
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        NumViews: UINT;
        (*_Out_writes_opt_(NumViews)*)
        out ppShaderResourceViews: ID3D11ShaderResourceView); stdcall;

    procedure HSGetShader(
        (*_Out_*)
        out ppHullShader: ID3D11HullShader;
        (*_Out_writes_opt_(*pNumClassInstances)*)
        out ppClassInstances: ID3D11ClassInstance;
        (*_Inout_opt_*)
        var pNumClassInstances: UINT); stdcall;

    procedure HSGetSamplers(
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )*)
        NumSamplers: UINT;
        (*_Out_writes_opt_(NumSamplers)*)
        out ppSamplers: ID3D11SamplerState); stdcall;

    procedure HSGetConstantBuffers(
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )*)
        NumBuffers: UINT;
        (*_Out_writes_opt_(NumBuffers)*)
        out ppConstantBuffers: ID3D11Buffer); stdcall;

    procedure DSGetShaderResources(
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        NumViews: UINT;
        (*_Out_writes_opt_(NumViews)*)
         out ppShaderResourceViews: ID3D11ShaderResourceView); stdcall;

    procedure DSGetShader(
        (*_Out_*)
        out ppDomainShader: ID3D11DomainShader;
        (*_Out_writes_opt_(*pNumClassInstances)*)
        out ppClassInstances: ID3D11ClassInstance;
        (*_Inout_opt_*)
        var pNumClassInstances: UINT); stdcall;

    procedure DSGetSamplers(
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )*)
        NumSamplers: UINT;
        (*_Out_writes_opt_(NumSamplers)*)
        out ppSamplers: ID3D11SamplerState); stdcall;

    procedure  DSGetConstantBuffers(
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )*)
        NumBuffers: UINT;
        (*_Out_writes_opt_(NumBuffers)*)
        out ppConstantBuffers: ID3D11Buffer); stdcall;

    procedure CSGetShaderResources(
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - 1 )*)
        StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT - StartSlot )*)
        NumViews: UINT;
        (*_Out_writes_opt_(NumViews)*)
        out ppShaderResourceViews: ID3D11ShaderResourceView); stdcall;

    procedure CSGetUnorderedAccessViews(
        (*_In_range_( 0, D3D11_PS_CS_UAV_REGISTER_COUNT - 1 )*)
         StartSlot: UINT;
        (*_In_range_( 0, D3D11_PS_CS_UAV_REGISTER_COUNT - StartSlot )*)
         NumUAVs: UINT;
        (*_Out_writes_opt_(NumUAVs)*)
        out ppUnorderedAccessViews: ID3D11UnorderedAccessView); stdcall;

    procedure CSGetShader(
        (*_Out_*)
         out ppComputeShader: ID3D11ComputeShader;
        (*_Out_writes_opt_(*pNumClassInstances)*)
         out ppClassInstances: ID3D11ClassInstance;
        (*_Inout_opt_*)
         var pNumClassInstances: UINT); stdcall;

    procedure CSGetSamplers(
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - 1 )*)
         StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT - StartSlot )*)
         NumSamplers:  UINT;
        (*_Out_writes_opt_(NumSamplers)*)
         out ppSamplers: ID3D11SamplerState); stdcall;

    procedure CSGetConstantBuffers(
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - 1 )*)
         StartSlot: UINT;
        (*_In_range_( 0, D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT - StartSlot )*)
         NumBuffers: UINT;
        (*_Out_writes_opt_(NumBuffers)*)
         out ppConstantBuffers: ID3D11Buffer); stdcall;

    procedure ClearState(); stdcall;

    procedure Flush(); stdcall;

    function GetType(): D3D11_DEVICE_CONTEXT_TYPE; stdcall;

    function GetContextFlags(): UINT; stdcall;

    function FinishCommandList(
        RestoreDeferredContextState: BOOL;
        (*_Out_opt_*)
        out ppCommandList: ID3D11CommandList): HRESULT; stdcall;
  end;

// interface ID3D11Device
// [unique][local][object][uuid]

  {$EXTERNALSYM IID_ID3D11Device}
  IID_ID3D11Device = ID3D11Device;
  {$HPPEMIT 'DECLARE_DINTERFACE_TYPE(ID3D11Device);'}
  {$EXTERNALSYM ID3D11Device}
  ID3D11Device = interface(IUnknown)
  ['{DB6F6DDB-AC77-4E88-8253-819DF9BBF140}']
    function CreateBuffer(
        (*_In_*)  const pDesc: TD3D11_BUFFER_DESC;
        (*_In_opt_*)  const pInitialData: PD3D11_SUBRESOURCE_DATA;
        (*_Out_opt_*)  out ppBuffer: ID3D11Buffer): HRESULT; stdcall;

    function CreateTexture1D(
        (*_In_*)  const pDesc: PD3D11_TEXTURE1D_DESC;
        (*_In_reads_opt_(_Inexpressible_(pDesc->MipLevels * pDesc->ArraySize))*)
        const pInitialData: PD3D11_SUBRESOURCE_DATA;
        (*_Out_opt_*)  out ppTexture1D: ID3D11Texture1D): HRESULT; stdcall;

    function CreateTexture2D(
        (*_In_*)  const pDesc: TD3D11_TEXTURE2D_DESC;
        (*_In_reads_opt_(_Inexpressible_(pDesc->MipLevels * pDesc->ArraySize)) *)
        const pInitialData: PD3D11_SUBRESOURCE_DATA;
        (*_Out_opt_*)  out ppTexture2D: ID3D11Texture2D): HRESULT; stdcall;

    function CreateTexture3D(
        (*_In_*)  const pDesc: PD3D11_TEXTURE3D_DESC;
        (*_In_reads_opt_(_Inexpressible_(pDesc->MipLevels))*)
        const pInitialData: PD3D11_SUBRESOURCE_DATA;
        (*_Out_opt_*)  out ppTexture3D: ID3D11Texture3D): HRESULT; stdcall;

    function CreateShaderResourceView(
        (*_In_*)  pResource: ID3D11Resource;
        (*_In_opt_*)  const pDesc: PD3D11_SHADER_RESOURCE_VIEW_DESC;
        (*_Out_opt_*)  out ppSRView: ID3D11ShaderResourceView): HRESULT; stdcall;

    function CreateUnorderedAccessView(
        (*_In_*)  pResource: ID3D11Resource;
        (*_In_opt_*)  const pDesc: PD3D11_UNORDERED_ACCESS_VIEW_DESC;
        (*_Out_opt_*)  out ppUAView: ID3D11UnorderedAccessView): HRESULT; stdcall;

    function CreateRenderTargetView(
        (*_In_*)  pResource: ID3D11Resource;
        (*_In_opt_*)  const pDesc: PD3D11_RENDER_TARGET_VIEW_DESC;
        (*_Out_opt_*)  out ppRTView: ID3D11RenderTargetView): HRESULT; stdcall;

    function CreateDepthStencilView(
        (*_In_*)  pResource: ID3D11Resource;
        (*_In_opt_*)  const pDesc: PD3D11_DEPTH_STENCIL_VIEW_DESC;
        (*_Out_opt_*)  out ppDepthStencilView: ID3D11DepthStencilView): HRESULT; stdcall;

    function CreateInputLayout(
        (*_In_reads_(NumElements)*)  const pInputElementDescs: PD3D11_INPUT_ELEMENT_DESC;
        (*_In_range_( 0, D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT)*)  NumElements: UINT;
        (*_In_reads_(BytecodeLength)*)  const pShaderBytecodeWithInputSignature: Pointer;
        (*_In_*)  BytecodeLength: SIZE_T;
        (*_Out_opt_*)  out ppInputLayout: ID3D11InputLayout): HRESULT; stdcall;

    function CreateVertexShader(
        (*_In_reads_(BytecodeLength)*)  const pShaderBytecode: Pointer;
        (*_In_*)  BytecodeLength: SIZE_T;
        (*_In_opt_*)  pClassLinkage: ID3D11ClassLinkage;
        (*_Out_opt_*)  ppVertexShader: PID3D11VertexShader): HRESULT; stdcall;

    function CreateGeometryShader(
        (*_In_reads_(BytecodeLength)*)  const pShaderBytecode: Pointer;
        (*_In_*)  BytecodeLength: SIZE_T;
        (*_In_opt_*)  pClassLinkage: ID3D11ClassLinkage;
        (*_Out_opt_*)  out ppGeometryShader: ID3D11GeometryShader): HRESULT; stdcall;

    function CreateGeometryShaderWithStreamOutput(
        (*_In_reads_(BytecodeLength)*)  const pShaderBytecode: Pointer;
        (*_In_*)  BytecodeLength: SIZE_T;
        (*_In_reads_opt_(NumEntries)*)  const pSODeclaration: PD3D11_SO_DECLARATION_ENTRY;
        (*_In_range_( 0, D3D11_SO_STREAM_COUNT * D3D11_SO_OUTPUT_COMPONENT_COUNT )*)  NumEntries: UINT;
        (*_In_reads_opt_(NumStrides)*)  const pBufferStrides: PUINT;
        (*_In_range_( 0, D3D11_SO_BUFFER_SLOT_COUNT )*)  NumStrides: UINT;
        (*_In_*)  RasterizedStream: UINT;
        (*_In_opt_*)  pClassLinkage: ID3D11ClassLinkage ;
        (*_Out_opt_*)  out ppGeometryShader: ID3D11GeometryShader): HRESULT; stdcall;

    function CreatePixelShader(
        (*_In_reads_(BytecodeLength)*)  const pShaderBytecode: Pointer;
        (*_In_*)  BytecodeLength: SIZE_T;
        (*_In_opt_*)  pClassLinkage: ID3D11ClassLinkage;
        (*_Out_opt_*)  out ppPixelShader: ID3D11PixelShader): HRESULT; stdcall;

    function CreateHullShader(
        (*_In_reads_(BytecodeLength)*)  const pShaderBytecode: Pointer;
        (*_In_*)  BytecodeLength: SIZE_T;
        (*_In_opt_*)  pClassLinkage: ID3D11ClassLinkage;
        (*_Out_opt_*)  out ppHullShader: ID3D11HullShader): HRESULT; stdcall;

    function CreateDomainShader(
        (*_In_reads_(BytecodeLength)*)  const pShaderBytecode: Pointer;
        (*_In_*)  BytecodeLength: SIZE_T;
        (*_In_opt_*)  pClassLinkage: ID3D11ClassLinkage;
        (*_Out_opt_*)  out ppDomainShader: ID3D11DomainShader): HRESULT; stdcall;

    function CreateComputeShader(
        (*_In_reads_(BytecodeLength)*)  const pShaderBytecode: Pointer;
        (*_In_*)  BytecodeLength: SIZE_T;
        (*_In_opt_*)  pClassLinkage: ID3D11ClassLinkage;
        (*_Out_opt_*)  out ppComputeShader: ID3D11ComputeShader): HRESULT; stdcall;

    function CreateClassLinkage(
        (*_Out_*)  out ppLinkage: ID3D11ClassLinkage): HRESULT; stdcall;

    function CreateBlendState(
        (*_In_*)  const pBlendStateDesc: D3D11_BLEND_DESC;
        (*_Out_opt_*)  out ppBlendState: ID3D11BlendState): HRESULT; stdcall;

    function CreateDepthStencilState(
        (*_In_*)  const pDepthStencilDesc: TD3D11_DEPTH_STENCIL_DESC;
        (*_Out_opt_*)  out ppDepthStencilState: ID3D11DepthStencilState): HRESULT; stdcall;

    function CreateRasterizerState(
        (*_In_*)  const pRasterizerDesc: TD3D11_RASTERIZER_DESC;
        (*_Out_opt_*)  out ppRasterizerState: ID3D11RasterizerState): HRESULT; stdcall;

    function CreateSamplerState(
        (*_In_*)  const pSamplerDesc: TD3D11_SAMPLER_DESC;
        (*_Out_opt_*)  out ppSamplerState: ID3D11SamplerState): HRESULT; stdcall;

    function CreateQuery(
        (*_In_*)  const pQueryDesc: PD3D11_QUERY_DESC;
        (*_Out_opt_*)  out ppQuery: ID3D11Query): HRESULT; stdcall;

    function CreatePredicate(
        (*_In_*)  const pPredicateDesc: PD3D11_QUERY_DESC;
        (*_Out_opt_*)  out ppPredicate: ID3D11Predicate): HRESULT; stdcall;

    function CreateCounter(
        (*_In_*)  const pCounterDesc: PD3D11_COUNTER_DESC;
        (*_Out_opt_*)  out ppCounter: ID3D11Counter): HRESULT; stdcall;

    function CreateDeferredContext(
        ContextFlags: UINT;
        (*_Out_opt_*)  out ppDeferredContext: ID3D11DeviceContext): HRESULT; stdcall;

    function OpenSharedResource(
        (*_In_*)  hResource: THandle;
        (*_In_*)  ReturnedInterface: TGUID;
        (*_Out_opt_*)  ppResource: PPointer): HRESULT; stdcall;

    function CheckFormatSupport(
        (*_In_*)  Format: DXGI_FORMAT;
        (*_Out_*)  out pFormatSupport: UINT): HRESULT; stdcall;

    function CheckMultisampleQualityLevels(
        (*_In_*)  Format: DXGI_FORMAT;
        (*_In_*)  SampleCount: UINT;
        (*_Out_*)  out pNumQualityLevels: UINT): HRESULT; stdcall;

    procedure CheckCounterInfo(
        (*_Out_*)  out pCounterInfo: D3D11_COUNTER_INFO); stdcall;

    function CheckCounter(
        (*_In_*)  const pDesc: PD3D11_COUNTER_DESC;
        (*_Out_*)  out pType: D3D11_COUNTER_TYPE;
        (*_Out_*)  out pActiveCounters: UINT;
        (*_Out_writes_opt_(*pNameLength)*)  szName: LPSTR;
        (*_Inout_opt_*)  var pNameLength: UINT;
        (*_Out_writes_opt_(*pUnitsLength)*)  szUnits: LPSTR;
        (*_Inout_opt_*)  var pUnitsLength: UINT;
        (*_Out_writes_opt_(*pDescriptionLength)*)  szDescription: LPSTR;
        (*_Inout_opt_*)  var pDescriptionLength: UINT): HRESULT; stdcall;

    function CheckFeatureSupport(
        Feature: D3D11_FEATURE;
        (*_Out_writes_bytes_(FeatureSupportDataSize)*)  pFeatureSupportData: Pointer;
        FeatureSupportDataSize: UINT): HRESULT; stdcall;

    function GetPrivateData(
        (*_In_*)  guid: TGUID;
        (*_Inout_*)  var pDataSize: UINT;
        (*_Out_writes_bytes_opt_(*pDataSize)*)  pData: Pointer): HRESULT; stdcall;

    function SetPrivateData(
        (*_In_*)  guid: TGUID;
        (*_In_*)  DataSize: UINT;
        (*_In_reads_bytes_opt_(DataSize)*)  const pData: Pointer): HRESULT; stdcall;

    function SetPrivateDataInterface(
        (*_In_*)  guid: TGUID;
        (*_In_opt_*)  const pData: IUnknown): HRESULT; stdcall;

    function GetFeatureLevel: D3D_FEATURE_LEVEL; stdcall;

    function GetCreationFlags: UINT; stdcall;

    function GetDeviceRemovedReason: HRESULT; stdcall;

    procedure GetImmediateContext(
        (*_Out_*)  out ppImmediateContext: ID3D11DeviceContext); stdcall;

    function SetExceptionMode(
        RaiseFlags: UINT): HRESULT; stdcall;

    function GetExceptionMode: UINT; stdcall;

  end;

type

  D3D11_CREATE_DEVICE_FLAG = UINT;
  TD3D11_CREATE_DEVICE_FLAG = D3D11_CREATE_DEVICE_FLAG;
  {$EXTERNALSYM D3D11_CREATE_DEVICE_FLAG}

const

    D3D11_CREATE_DEVICE_SINGLETHREADED	= $1;
  {$EXTERNALSYM D3D11_CREATE_DEVICE_SINGLETHREADED}
    D3D11_CREATE_DEVICE_DEBUG	= $2;
  {$EXTERNALSYM D3D11_CREATE_DEVICE_DEBUG}
    D3D11_CREATE_DEVICE_SWITCH_TO_REF	= $4;
  {$EXTERNALSYM D3D11_CREATE_DEVICE_SWITCH_TO_REF}
    D3D11_CREATE_DEVICE_PREVENT_INTERNAL_THREADING_OPTIMIZATIONS	= $8;
  {$EXTERNALSYM D3D11_CREATE_DEVICE_PREVENT_INTERNAL_THREADING_OPTIMIZATIONS}
    D3D11_CREATE_DEVICE_BGRA_SUPPORT	= $20;
  {$EXTERNALSYM D3D11_CREATE_DEVICE_BGRA_SUPPORT}
    D3D11_CREATE_DEVICE_DEBUGGABLE	= $40;
  {$EXTERNALSYM D3D11_CREATE_DEVICE_DEBUGGABLE}

type

///////////////////////////////////////////////////////////////////////////
// D3D11CreateDevice
// ------------------
//
// pAdapter
//      If NULL, D3D11CreateDevice will choose the primary adapter and
//      create a new instance from a temporarily created IDXGIFactory.
//      If non-NULL, D3D11CreateDevice will register the appropriate
//      device, if necessary (via IDXGIAdapter::RegisterDrver), before
//      creating the device.
// DriverType
//      Specifies the driver type to be created: hardware, reference or
//      null.
// Software
//      HMODULE of a DLL implementing a software rasterizer. Must be NULL for
//      non-Software driver types.
// Flags
//      Any of those documented for D3D11CreateDeviceAndSwapChain.
// pFeatureLevels
//      Any of those documented for D3D11CreateDeviceAndSwapChain.
// FeatureLevels
//      Size of feature levels array.
// SDKVersion
//      SDK version. Use the D3D11_SDK_VERSION macro.
// ppDevice
//      Pointer to returned interface. May be NULL.
// pFeatureLevel
//      Pointer to returned feature level. May be NULL.
// ppImmediateContext
//      Pointer to returned interface. May be NULL.
//
// Return Values
//  Any of those documented for
//          CreateDXGIFactory1
//          IDXGIFactory::EnumAdapters
//          IDXGIAdapter::RegisterDriver
//          D3D11CreateDevice
//
///////////////////////////////////////////////////////////////////////////


  {$EXTERNALSYM PFN_D3D11_CREATE_DEVICE}
  PFN_D3D11_CREATE_DEVICE = function (
    (*_In_opt_*) pAdapter: IDXGIAdapter;
    DriverType: D3D_DRIVER_TYPE;
    Software: HMODULE;
    Flags: UINT;
    (*_In_reads_opt_( FeatureLevels )*)
    const pFeatureLevels: PD3D_FEATURE_LEVEL;
    FeatureLevels: UINT;
    SDKVersion: UINT;
    (*_Out_opt_*) out ppDevice: ID3D11Device;
    (*_Out_opt_*) out pFeatureLevel: D3D_FEATURE_LEVEL;
    (*_Out_opt_*) out ppImmediateContext: ID3D11DeviceContext): HRESULT; stdcall;


///////////////////////////////////////////////////////////////////////////
// D3D11CreateDeviceAndSwapChain
// ------------------------------
//
// ppAdapter
//      If NULL, D3D11CreateDevice will choose the primary adapter and
//      create a new instance from a temporarily created IDXGIFactory.
//      If non-NULL, D3D11CreateDevice will register the appropriate
//      device, if necessary (via IDXGIAdapter::RegisterDrver), before
//      creating the device.
// DriverType
//      Specifies the driver type to be created: hardware, reference or
//      null.
// Software
//      HMODULE of a DLL implementing a software rasterizer. Must be NULL for
//      non-Software driver types.
// Flags
//      Any of those documented for D3D11CreateDevice.
// pFeatureLevels
//      Array of any of the following:
//          D3D_FEATURE_LEVEL_11_0
//          D3D_FEATURE_LEVEL_10_1
//          D3D_FEATURE_LEVEL_10_0
//          D3D_FEATURE_LEVEL_9_3
//          D3D_FEATURE_LEVEL_9_2
//          D3D_FEATURE_LEVEL_9_1
//      Order indicates sequence in which instantiation will be attempted. If
//      NULL, then the implied order is the same as previously listed (i.e.
//      prefer most features available).
// FeatureLevels
//      Size of feature levels array.
// SDKVersion
//      SDK version. Use the D3D11_SDK_VERSION macro.
// pSwapChainDesc
//      Swap chain description, may be NULL.
// ppSwapChain
//      Pointer to returned interface. May be NULL.
// ppDevice
//      Pointer to returned interface. May be NULL.
// pFeatureLevel
//      Pointer to returned feature level. May be NULL.
// ppImmediateContext
//      Pointer to returned interface. May be NULL.
//
// Return Values
//  Any of those documented for
//          CreateDXGIFactory1
//          IDXGIFactory::EnumAdapters
//          IDXGIAdapter::RegisterDriver
//          D3D11CreateDevice
//          IDXGIFactory::CreateSwapChain
//
///////////////////////////////////////////////////////////////////////////


  {$EXTERNALSYM PFN_D3D11_CREATE_DEVICE_AND_SWAP_CHAIN}
  PFN_D3D11_CREATE_DEVICE_AND_SWAP_CHAIN = function (
    (*_In_opt_*) pAdapter: IDXGIAdapter;
    DriverType: D3D_DRIVER_TYPE;
    Software: HMODULE;
    Flags: UINT;
    (*_In_reads_opt_( FeatureLevels )*)
    const pFeatureLevels: PD3D_FEATURE_LEVEL;
    FeatureLevels: UINT;
    SDKVersion: UINT;
    (*_In_opt_*) const pSwapChainDesc: PDXGISwapChainDesc;
    (*_Out_opt_*) out ppSwapChain: IDXGISwapChain;
    (*_Out_opt_*) out ppDevice: ID3D11Device;
    (*_Out_opt_*) out pFeatureLevel: D3D_FEATURE_LEVEL;
    (*_Out_opt_*) out ppImmediateContext: ID3D11DeviceContext): HRESULT; stdcall;


// Additional Prototypes for ALL interfaces

// end of Additional Prototypes
// helper funcions and record


(*
These helpers are not necessary, since D3D11_RECT is a TRECT that has all this stuff defined
struct CD3D11_RECT : public D3D11_RECT;
inline bool operator==( const D3D11_RECT& l, const D3D11_RECT& r )
inline bool operator!=( const D3D11_RECT& l, const D3D11_RECT& r )
*)

(* helper functionality has been added to the records, since we cannot add
 operator overload to a record helper*)
  CD3D11_BOX = D3D11_BOX;
  {$EXTERNALSYM CD3D11_BOX}
  CD3D11_DEPTH_STENCIL_DESC = D3D11_DEPTH_STENCIL_DESC;
  {$EXTERNALSYM CD3D11_DEPTH_STENCIL_DESC}
  CD3D11_BLEND_DESC = D3D11_BLEND_DESC;
  {$EXTERNALSYM CD3D11_BLEND_DESC}
  CD3D11_RASTERIZER_DESC = D3D11_RASTERIZER_DESC;
  {$EXTERNALSYM CD3D11_RASTERIZER_DESC}
  CD3D11_BUFFER_DESC = D3D11_BUFFER_DESC;
  {$EXTERNALSYM CD3D11_BUFFER_DESC}
  CD3D11_TEXTURE1D_DESC = D3D11_TEXTURE1D_DESC;
  {$EXTERNALSYM CD3D11_TEXTURE1D_DESC}
  CD3D11_TEXTURE2D_DESC = D3D11_TEXTURE2D_DESC;
  {$EXTERNALSYM CD3D11_TEXTURE2D_DESC}
  CD3D11_TEXTURE3D_DESC = D3D11_TEXTURE3D_DESC;
  {$EXTERNALSYM CD3D11_TEXTURE3D_DESC}
  CD3D11_SHADER_RESOURCE_VIEW_DESC = D3D11_SHADER_RESOURCE_VIEW_DESC;
  {$EXTERNALSYM CD3D11_SHADER_RESOURCE_VIEW_DESC}
  CD3D11_RENDER_TARGET_VIEW_DESC = D3D11_RENDER_TARGET_VIEW_DESC;
  {$EXTERNALSYM CD3D11_RENDER_TARGET_VIEW_DESC}
  CD3D11_VIEWPORT = D3D11_VIEWPORT;
  {$EXTERNALSYM CD3D11_VIEWPORT}
  CD3D11_DEPTH_STENCIL_VIEW_DESC = D3D11_DEPTH_STENCIL_VIEW_DESC;
  {$EXTERNALSYM CD3D11_DEPTH_STENCIL_VIEW_DESC}
  CD3D11_UNORDERED_ACCESS_VIEW_DESC = D3D11_UNORDERED_ACCESS_VIEW_DESC;
  {$EXTERNALSYM CD3D11_UNORDERED_ACCESS_VIEW_DESC}
  CD3D11_SAMPLER_DESC = D3D11_SAMPLER_DESC;
  {$EXTERNALSYM CD3D11_SAMPLER_DESC}
  CD3D11_QUERY_DESC = D3D11_QUERY_DESC;
  {$EXTERNALSYM CD3D11_QUERY_DESC}
  CD3D11_COUNTER_DESC = D3D11_COUNTER_DESC;
  {$EXTERNALSYM CD3D11_COUNTER_DESC}


function D3D11CreateDevice(
    (*_In_opt_*) pAdapter: IDXGIAdapter;
    DriverType: D3D_DRIVER_TYPE;
    Software: HMODULE;
    Flags: UINT;
    (*_In_reads_opt_( FeatureLevels )*)
    const pFeatureLevels: PD3D_FEATURE_LEVEL;
    FeatureLevels: UINT;
    SDKVersion: UINT;
    (*_Out_opt_*) out ppDevice: ID3D11Device;
    (*_Out_opt_*) out pFeatureLevel: D3D_FEATURE_LEVEL;
    (*_Out_opt_*) out ppImmediateContext: ID3D11DeviceContext): HRESULT; stdcall; external D3D11dll delayed;

  function D3D11CreateDeviceAndSwapChain(
    (*_In_opt_*) pAdapter: IDXGIAdapter;
    DriverType: D3D_DRIVER_TYPE;
    Software: HMODULE;
    Flags: UINT;
    (*_In_reads_opt_( FeatureLevels )*)
    const pFeatureLevels: PD3D_FEATURE_LEVEL;
    FeatureLevels: UINT;
    SDKVersion: UINT;
    (*_In_opt_*) const pSwapChainDesc: PDXGISwapChainDesc;
    (*_Out_opt_*) out ppSwapChain: IDXGISwapChain;
    (*_Out_opt_*) out ppDevice: ID3D11Device;
    (*_Out_opt_*) out pFeatureLevel: D3D_FEATURE_LEVEL;
    (*_Out_opt_*) out ppImmediateContext: ID3D11DeviceContext): HRESULT; stdcall; external D3D11dll delayed;


// MACRO DEFINITIONS TRANSLATION: All Macro functionality is moved here
  function MAKE_HRESULT(sev,fac,code: WORD): HRESULT; inline;
  function MAKE_D3D11_HRESULT(code : WORD): HRESULT; inline;
  function MAKE_D3D11_STATUS(code: WORD): HRESULT; inline;
  function D3D11_ERROR_TOO_MANY_UNIQUE_STATE_OBJECTS: HRESULT; inline;
  function D3D11_ERROR_FILE_NOT_FOUND: HRESULT; inline;
  function D3D11_ERROR_TOO_MANY_UNIQUE_VIEW_OBJECTS: HRESULT; inline;
  function D3D11_ERROR_DEFERRED_CONTEXT_MAP_WITHOUT_INITIAL_DISCARD: HRESULT; inline;

  function operator_equal(const l: D3D11_VIEWPORT; const r: D3D11_VIEWPORT): bool; inline;
  function operator_notEqual(const l: D3D11_VIEWPORT; const r: D3D11_VIEWPORT): bool; inline;
  function D3D11CalcSubresource(MipSlice: UINT; ArraySlice: UINT; MipLevels: UINT):UINT; inline;
  function D3D11_ENCODE_BASIC_FILTER(min, mag, mip, bComparison: UINT): D3D11_FILTER; inline;
  function D3D11_ENCODE_ANISOTROPIC_FILTER(bComparison: UINT): D3D11_FILTER; inline;
  function D3D11_DECODE_MIN_FILTER(d3d11Filter: UINT): D3D11_FILTER_TYPE; inline;
  function D3D11_DECODE_MAG_FILTER(d3d11Filter: UINT):D3D11_FILTER_TYPE; inline;
  function D3D11_DECODE_MIP_FILTER(d3d11Filter: UINT):D3D11_FILTER_TYPE; inline;
  function D3D11_DECODE_IS_COMPARISON_FILTER(d3d11Filter: UINT): Boolean; inline;
  function D3D11_DECODE_IS_ANISOTROPIC_FILTER(d3d11Filter: UINT): Boolean; inline;


// Moved here from D3DCommon to avoid circular references
  procedure D3D_SET_OBJECT_NAME_N_A(pObject: ID3D11DeviceChild; Chars: UINT; pName: Pointer); inline;
  procedure D3D_SET_OBJECT_NAME_A(pObject: ID3D11DeviceChild; pName: Pointer); inline;


implementation


function MAKE_HRESULT(sev,fac,code: WORD): HRESULT;
begin
   Result := HRESULT((UInt(sev) shl 31) or (UInt(fac) shl 16) or (UInt(code)));
end;

function MAKE_D3D11_HRESULT(code : WORD): HRESULT;
begin
  Result := MAKE_HRESULT(1, _FACD3D11, code);
end;

function MAKE_D3D11_STATUS(code: WORD): HRESULT;
begin
  Result := MAKE_HRESULT(0, _FACD3D11, code);
end;

function D3D11_ERROR_TOO_MANY_UNIQUE_STATE_OBJECTS: HRESULT;
begin
  Result := MAKE_D3D11_HRESULT(1);
end;

function D3D11_ERROR_FILE_NOT_FOUND: HRESULT;
begin
  Result := MAKE_D3D11_HRESULT(2);
end;

function D3D11_ERROR_TOO_MANY_UNIQUE_VIEW_OBJECTS: HRESULT;
begin
  Result := MAKE_D3D11_HRESULT(3);
end;

function D3D11_ERROR_DEFERRED_CONTEXT_MAP_WITHOUT_INITIAL_DISCARD: HRESULT;
begin
  Result := MAKE_D3D11_HRESULT(4);
end;



function operator_equal(const l: D3D11_VIEWPORT; const r: D3D11_VIEWPORT): bool; inline;
begin
  Result := (l.TopLeftX = r.TopLeftX) and (l.TopLeftY = r.TopLeftY) and (l.Width = r.Width) and
      (l.Height = r.Height) and (l.MinDepth = r.MinDepth) and (l.MaxDepth = r.MaxDepth);
end;
function operator_notEqual(const l: D3D11_VIEWPORT; const r: D3D11_VIEWPORT): bool; inline;
begin
  Result := not operator_equal(l, r);
end;

function D3D11CalcSubresource(MipSlice: UINT; ArraySlice: UINT; MipLevels: UINT):UINT; inline;
begin
  Result := MipSlice + ArraySlice * MipLevels;
end;

function D3D11_ENCODE_BASIC_FILTER(min, mag, mip, bComparison: UINT): D3D11_FILTER;
var
  LFiltering: UINT;
begin
  if bComparison = 0 then
    LFiltering := D3D11_COMPARISON_FILTERING_BIT
  else
    LFiltering := 0;
  Result := D3D11_FILTER(
    LFiltering or
    (((min) and D3D11_FILTER_TYPE_MASK) shl D3D11_MIN_FILTER_SHIFT) or
    (((mag) and D3D11_FILTER_TYPE_MASK) shl D3D11_MAG_FILTER_SHIFT) or
    (((mip) and D3D11_FILTER_TYPE_MASK) shl D3D11_MIP_FILTER_SHIFT));
end;

function D3D11_ENCODE_ANISOTROPIC_FILTER(bComparison: UINT): D3D11_FILTER;
begin
  Result := D3D11_FILTER(D3D11_ANISOTROPIC_FILTERING_BIT or
   UINT(D3D11_ENCODE_BASIC_FILTER(UINT(D3D11_FILTER_TYPE_LINEAR),
                              UINT(D3D11_FILTER_TYPE_LINEAR),
                              UINT(D3D11_FILTER_TYPE_LINEAR),
                              bComparison)));
end;

function D3D11_DECODE_MIN_FILTER(d3d11Filter: UINT): D3D11_FILTER_TYPE;
begin
  Result := D3D11_FILTER_TYPE((d3d11Filter shr D3D11_MIN_FILTER_SHIFT) and D3D11_FILTER_TYPE_MASK);
end;

function D3D11_DECODE_MAG_FILTER(d3d11Filter: UINT):D3D11_FILTER_TYPE;
begin
  Result := D3D11_FILTER_TYPE((d3d11Filter shr D3D11_MAG_FILTER_SHIFT) and D3D11_FILTER_TYPE_MASK) ;
end;

function D3D11_DECODE_MIP_FILTER(d3d11Filter: UINT):D3D11_FILTER_TYPE;
begin
  Result := D3D11_FILTER_TYPE((d3d11Filter shr D3D11_MIP_FILTER_SHIFT) and D3D11_FILTER_TYPE_MASK);
end;

function D3D11_DECODE_IS_COMPARISON_FILTER(d3d11Filter: UINT): Boolean;
begin
  Result := (d3d11Filter and D3D11_COMPARISON_FILTERING_BIT) <> 0;
end;

function D3D11_DECODE_IS_ANISOTROPIC_FILTER(d3d11Filter: UINT): Boolean;
begin
  Result := (Boolean(d3d11Filter and D3D11_ANISOTROPIC_FILTERING_BIT) and
    (D3D11_FILTER_TYPE_LINEAR = D3D11_DECODE_MIN_FILTER(d3d11Filter)) and
    (D3D11_FILTER_TYPE_LINEAR = D3D11_DECODE_MAG_FILTER(d3d11Filter)) and
    (D3D11_FILTER_TYPE_LINEAR = D3D11_DECODE_MIP_FILTER(d3d11Filter)));
end;

procedure D3D_SET_OBJECT_NAME_N_A(pObject: ID3D11DeviceChild; Chars: UINT; pName: Pointer);
begin
 pObject.SetPrivateData(WKPDID_D3DDebugObjectName, Chars, pName);
end;

procedure D3D_SET_OBJECT_NAME_A(pObject: ID3D11DeviceChild; pName: Pointer);
begin
 D3D_SET_OBJECT_NAME_N_A(pObject, length(string(pName)), pName);
end;


{ D3D11_BOX}

constructor D3D11_BOX.Create(const o: D3D11_BOX);
begin
  Self := o;
end;

constructor D3D11_BOX.Create(aLeft, aTop, aFront, aRight, aBottom, aBack: LONG);
begin
  left := aLeft;
  top := aTop;
  front := aFront;
  right := aRight;
  bottom := aBottom;
  back := aBack;
end;

class operator D3D11_BOX.Equal(const l, r: D3D11_BOX): Boolean;
begin
  Result := (l.left = r.left) and (l.top = r.top) and (l.front = r.front) and
            (l.right = r.right) and (l.bottom = r.bottom) and (l.back = r.back);
end;

class operator D3D11_BOX.NotEqual(const l, r: D3D11_BOX): Boolean;
begin
  Result := Not (l = r);
end;

{ D3D11_DEPTH_STENCIL_DESC}

constructor D3D11_DEPTH_STENCIL_DESC.Create(const o: D3D11_DEPTH_STENCIL_DESC);
begin
  Self := o;
end;

constructor D3D11_DEPTH_STENCIL_DESC.Create(default: boolean);
const
  defaultStencilOp: D3D11_DEPTH_STENCILOP_DESC =
          (StencilFailOp : D3D11_STENCIL_OP_KEEP;
           StencilDepthFailOp: D3D11_STENCIL_OP_KEEP;
           StencilPassOp:D3D11_STENCIL_OP_KEEP;
           StencilFunc: D3D11_COMPARISON_ALWAYS);
begin
  if default then
  begin
    DepthEnable := True;
    DepthWriteMask := D3D11_DEPTH_WRITE_MASK_ALL;
    DepthFunc := D3D11_COMPARISON_LESS;
    StencilEnable := False;
    StencilReadMask := D3D11_DEFAULT_STENCIL_READ_MASK;
    StencilWriteMask := D3D11_DEFAULT_STENCIL_WRITE_MASK;
    FrontFace := defaultStencilOp;
    BackFace := defaultStencilOp;
  end;
end;

constructor D3D11_DEPTH_STENCIL_DESC.Create(aDepthEnable: BOOL;
  aDepthWriteMask: D3D11_DEPTH_WRITE_MASK; aDepthFunc: D3D11_COMPARISON_FUNC;
  aStencilEnable: BOOL; aStencilReadMask, aStencilWriteMask: UINT8;
  aFrontStencilFailOp, aFrontStencilDepthFailOp,
  aFrontStencilPassOp: D3D11_STENCIL_OP;
  aFrontStencilFunc: D3D11_COMPARISON_FUNC; aBackStencilFailOp,
  aBackStencilDepthFailOp, aBackStencilPassOp: D3D11_STENCIL_OP;
  aBackStencilFunc: D3D11_COMPARISON_FUNC);
begin
  DepthEnable := aDepthEnable;
  DepthWriteMask := aDepthWriteMask;
  DepthFunc := aDepthFunc;
  StencilEnable := aStencilEnable;
  StencilReadMask := aStencilReadMask;
  StencilWriteMask := aStencilWriteMask;
  FrontFace.StencilFailOp := aFrontStencilFailOp;
  FrontFace.StencilDepthFailOp := aFrontStencilDepthFailOp;
  FrontFace.StencilPassOp := aFrontStencilPassOp;
  FrontFace.StencilFunc := aFrontStencilFunc;
  BackFace.StencilFailOp := aBackStencilFailOp;
  BackFace.StencilDepthFailOp := aBackStencilDepthFailOp;
  BackFace.StencilPassOp := aBackStencilPassOp;
  BackFace.StencilFunc := aBackStencilFunc;
end;

{ D3D11_BLEND_DESC}

constructor D3D11_BLEND_DESC.Create(Default: boolean);
const
  defaultRenderTargetBlendDesc: D3D11_RENDER_TARGET_BLEND_DESC =
    (BlendEnable: False;
    SrcBlend: D3D11_BLEND_ONE;
    DestBlend: D3D11_BLEND_ZERO;
    BlendOp: D3D11_BLEND_OP_ADD;
    SrcBlendAlpha: D3D11_BLEND_ONE;
    DestBlendAlpha: D3D11_BLEND_ZERO;
    BlendOpAlpha: D3D11_BLEND_OP_ADD;
    RenderTargetWriteMask: UInt8(D3D11_COLOR_WRITE_ENABLE_ALL));
var
  I: integer;
begin
  if Default then
  begin
    AlphaToCoverageEnable := False;
    IndependentBlendEnable := False;
    for I := 0 to D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT - 1 do
      RenderTarget[i] := defaultRenderTargetBlendDesc;
  end;
end;

constructor D3D11_BLEND_DESC.Create(const o: D3D11_BLEND_DESC);
begin
  Self := o;
end;

{ D3D11_RASTERIZER_DESC}

constructor D3D11_RASTERIZER_DESC.Create(const o: D3D11_RASTERIZER_DESC);
begin
  Self := o;
end;

constructor D3D11_RASTERIZER_DESC.Create(Default: boolean);
begin
  FillMode := D3D11_FILL_SOLID;
  CullMode := D3D11_CULL_BACK;
  FrontCounterClockwise := FALSE;
  DepthBias := D3D11_DEFAULT_DEPTH_BIAS;
  DepthBiasClamp := D3D11_DEFAULT_DEPTH_BIAS_CLAMP;
  SlopeScaledDepthBias := D3D11_DEFAULT_SLOPE_SCALED_DEPTH_BIAS;
  DepthClipEnable := True;
  ScissorEnable := False;
  MultisampleEnable := False;
  AntialiasedLineEnable := False;
end;

constructor D3D11_RASTERIZER_DESC.Create(aFillMode: D3D11_FILL_MODE; aCullMode: D3D11_CULL_MODE;
  aFrontCounterClockwise: BOOL; aDepthBias: integer;
  aDepthBiasClamp: Single; aSlopeScaledDepthBias: Single;
  aDepthClipEnable: BOOL; aScissorEnable: BOOL;
  aMultisampleEnable: BOOL; aAntialiasedLineEnable: BOOL);
begin
  FillMode := aFillMode;
  CullMode := aCullMode;
  FrontCounterClockwise := aFrontCounterClockwise;
  DepthBias := aDepthBias;
  DepthBiasClamp := aDepthBiasClamp;
  SlopeScaledDepthBias := aSlopeScaledDepthBias;
  DepthClipEnable := aDepthClipEnable;
  ScissorEnable := aScissorEnable;
  MultisampleEnable := aMultisampleEnable;
  AntialiasedLineEnable := aAntialiasedLineEnable;
end;

{ D3D11_BUFFER_DESC}

constructor D3D11_BUFFER_DESC.Create(const o: D3D11_BUFFER_DESC);
begin
  Self := o;
end;

constructor D3D11_BUFFER_DESC.Create(aByteWidth, aBindFlags: UINT;
  aUsage: D3D11_USAGE; aCpuaccessFlags, aMiscFlags, aStructureByteStride: UINT);
begin
  ByteWidth := aByteWidth;
  Usage := aUsage;
  BindFlags := aBindFlags;
  CPUAccessFlags := aCpuaccessFlags ;
  MiscFlags := aMiscFlags;
  StructureByteStride := aStructureByteStride;
end;

{ D3D11_TEXTURE1D_DESC}

constructor D3D11_TEXTURE1D_DESC.Create(const o: D3D11_TEXTURE1D_DESC);
begin
  Self := o;
end;

constructor D3D11_TEXTURE1D_DESC.Create(aFormat: DXGI_FORMAT; aWidth,
  aArraySize, aMipLevels, aBindFlags: UINT; aUsage: D3D11_USAGE;
  aCpuaccessFlags, aMiscFlags: UINT);
begin
  Width := aWidth;
  MipLevels := aMipLevels;
  ArraySize := aArraySize;
  Format := aFormat;
  Usage := aUsage;
  BindFlags := aBindFlags;
  CPUAccessFlags := aCpuaccessFlags;
  MiscFlags := aMiscFlags;
end;

{ D3D11_TEXTURE2D_DESC}

constructor D3D11_TEXTURE2D_DESC.Create(const o: D3D11_TEXTURE2D_DESC);
begin
  Self := o;
end;

constructor D3D11_TEXTURE2D_DESC.Create(aFormat: DXGI_FORMAT; aWidth, aHeight,
  aArraySize, aMipLevels, aBindFlags: UINT; aUsage: D3D11_USAGE;
  aCpuaccessFlags, aSampleCount, aSampleQuality, aMiscFlags: UINT);
begin
  Width := aWidth;
  Height := aHeight;
  MipLevels := aMipLevels;
  ArraySize := aArraySize;
  Format := aFormat;
  SampleDesc.Count := aSampleCount;
  SampleDesc.Quality := aSampleQuality;
  Usage := aUsage;
  BindFlags := aBindFlags;
  CPUAccessFlags := aCpuaccessFlags;
  MiscFlags := aMiscFlags;
end;

{ D3D11_TEXTURE3D_DESC}

constructor D3D11_TEXTURE3D_DESC.Create(const o: D3D11_TEXTURE3D_DESC);
begin
  Self := o;
end;

constructor D3D11_TEXTURE3D_DESC.Create(aFormat: DXGI_FORMAT; aWidth, aHeight,
  aDepth, aMipLevels, aBindFlags: UINT; aUsage: D3D11_USAGE; aCpuaccessFlags,
  aMiscFlags: UINT);
begin
  Width := aWidth;
  Height := aHeight;
  Depth := aDepth;
  MipLevels := aMipLevels;
  Format := aFormat;
  Usage := aUsage;
  BindFlags := aBindFlags;
  CPUAccessFlags := aCpuaccessFlags;
  MiscFlags := aMiscFlags;
end;

{ D3D11_SHADER_RESOURCE_VIEW_DESC}

constructor D3D11_SHADER_RESOURCE_VIEW_DESC.Create(
  const o: D3D11_SHADER_RESOURCE_VIEW_DESC);
begin
  Self := o;
end;

constructor D3D11_SHADER_RESOURCE_VIEW_DESC.Create(
  aViewDimension: D3D11_SRV_DIMENSION; aFormat: DXGI_FORMAT; aMostDetailedMip,
  aMipLevels, aFirstArraySlice, aArraySize, aFlags: UINT);
begin
  Format := aFormat;
  ViewDimension := aViewDimension;
  case aViewDimension of
    D3D11_SRV_DIMENSION_BUFFER:
    begin
      Buffer.FirstElement := aMostDetailedMip;
      Buffer.NumElements := aMipLevels;
    end;
    D3D11_SRV_DIMENSION_TEXTURE1D:
    begin
      Texture1D.MostDetailedMip := aMostDetailedMip;
      Texture1D.MipLevels := aMipLevels;
    end;
    D3D11_SRV_DIMENSION_TEXTURE1DARRAY:
    begin
      Texture1DArray.MostDetailedMip := aMostDetailedMip;
      Texture1DArray.MipLevels := aMipLevels;
      Texture1DArray.FirstArraySlice := aFirstArraySlice;
      Texture1DArray.ArraySize := aArraySize;
    end;
    D3D11_SRV_DIMENSION_TEXTURE2D:
    begin
      Texture2D.MostDetailedMip := aMostDetailedMip;
      Texture2D.MipLevels := aMipLevels;
    end;
    D3D11_SRV_DIMENSION_TEXTURE2DARRAY:
    begin
      Texture2DArray.MostDetailedMip := aMostDetailedMip;
      Texture2DArray.MipLevels := aMipLevels;
      Texture2DArray.FirstArraySlice := aFirstArraySlice;
      Texture2DArray.ArraySize := aArraySize;
    end;
    D3D11_SRV_DIMENSION_TEXTURE2DMS:
    begin
      // do nothing;
    end;
    D3D11_SRV_DIMENSION_TEXTURE2DMSARRAY:
    begin
      Texture2DMSArray.FirstArraySlice := aFirstArraySlice;
      Texture2DMSArray.ArraySize := aArraySize;
    end;
    D3D11_SRV_DIMENSION_TEXTURE3D:
    begin
      Texture3D.MostDetailedMip := aMostDetailedMip;
      Texture3D.MipLevels := aMipLevels;
    end;
    D3D11_SRV_DIMENSION_TEXTURECUBE:
    begin
      TextureCube.MostDetailedMip := aMostDetailedMip;
      TextureCube.MipLevels := aMipLevels;
    end;
    D3D11_SRV_DIMENSION_TEXTURECUBEARRAY:
    begin
      TextureCubeArray.MostDetailedMip := aMostDetailedMip;
      TextureCubeArray.MipLevels := aMipLevels;
      TextureCubeArray.First2DArrayFace := aFirstArraySlice;
      TextureCubeArray.NumCubes := aArraySize;
    end;
    D3D11_SRV_DIMENSION_BUFFEREX:
    begin
      BufferEx.FirstElement := aMostDetailedMip;
      BufferEx.NumElements := aMipLevels;
      BufferEx.Flags := aFlags;
    end;
  end;
end;

constructor D3D11_SHADER_RESOURCE_VIEW_DESC.Create(aBuffer: ID3D11Buffer;
  aFormat: DXGI_FORMAT; aFirstElement, aNumElements, aFlags: UINT);
begin
  Format := aFormat;
  ViewDimension := D3D11_SRV_DIMENSION_BUFFEREX;
  BufferEx.FirstElement := aFirstElement;
  BufferEx.NumElements := aNumElements;
  BufferEx.Flags := aFlags;
end;

constructor D3D11_SHADER_RESOURCE_VIEW_DESC.Create(pTex1D: ID3D11Texture1D;
  aViewDimension: D3D11_SRV_DIMENSION; aFormat: DXGI_FORMAT; aMostDetailedMip,
  aMipLevels, aFirstArraySlice, aArraySize: UINT);
var
  TexDesc: D3D11_TEXTURE1D_DESC;
begin
  ViewDimension := aViewDimension;
  if ((DXGI_FORMAT_UNKNOWN = aFormat) or (UINT(-1) = aMipLevels) or
      ((UINT(-1) = aArraySize) and (D3D11_SRV_DIMENSION_TEXTURE1DARRAY = aViewDimension))) then
  begin
      pTex1D.GetDesc(TexDesc);
      if (DXGI_FORMAT_UNKNOWN = aFormat)then
        format := TexDesc.Format;
      if (UINT(-1) = aMipLevels) then
        aMipLevels := TexDesc.MipLevels - aMostDetailedMip;
      if (UINT(-1) = aArraySize) then
         aArraySize := TexDesc.ArraySize - aFirstArraySlice;
  end;
  Format := aFormat;
  case aViewDimension of
    D3D11_SRV_DIMENSION_TEXTURE1D:
    begin
      Texture1D.MostDetailedMip := aMostDetailedMip;
      Texture1D.MipLevels := aMipLevels;
    end;
    D3D11_SRV_DIMENSION_TEXTURE1DARRAY:
    begin
      Texture1DArray.MostDetailedMip := aMostDetailedMip;
      Texture1DArray.MipLevels := aMipLevels;
      Texture1DArray.FirstArraySlice := aFirstArraySlice;
      Texture1DArray.ArraySize := aArraySize;
    end;
  end;
end;

constructor D3D11_SHADER_RESOURCE_VIEW_DESC.Create(pTex2D: ID3D11Texture2D;
  aViewDimension: D3D11_SRV_DIMENSION; aFormat: DXGI_FORMAT; aMostDetailedMip,
  aMipLevels, aFirstArraySlice, aArraySize: UINT);
var
  TexDesc: D3D11_TEXTURE2D_DESC;
begin
  ViewDimension := aViewDimension;
  if ((DXGI_FORMAT_UNKNOWN = aFormat) or
      ((UINT(-1) = aMipLevels) and
          (D3D11_SRV_DIMENSION_TEXTURE2DMS <> aViewDimension) and
          (D3D11_SRV_DIMENSION_TEXTURE2DMSARRAY <> aViewDimension)) or
      ((UINT(-1) = aArraySize) and
          ((D3D11_SRV_DIMENSION_TEXTURE2DARRAY = aViewDimension) or
          (D3D11_SRV_DIMENSION_TEXTURE2DMSARRAY = aViewDimension) or
          (D3D11_SRV_DIMENSION_TEXTURECUBEARRAY = aViewDimension)))) then
  begin
    pTex2D.GetDesc(TexDesc);
    if (DXGI_FORMAT_UNKNOWN = aFormat) then
      aFormat := TexDesc.Format;
    if (UINT(-1) = aMipLevels) then
      aMipLevels := TexDesc.MipLevels - aMostDetailedMip;
    if (UINT(-1) = aArraySize) then
    begin
      aArraySize := TexDesc.ArraySize - aFirstArraySlice;
      if (D3D11_SRV_DIMENSION_TEXTURECUBEARRAY = aViewDimension) then
        aArraySize := aArraySize div 6;
    end;
  end;
  Format := aFormat;
  case viewDimension of
    D3D11_SRV_DIMENSION_TEXTURE2D:
    begin
      Texture2D.MostDetailedMip := aMostDetailedMip;
      Texture2D.MipLevels := aMipLevels;
    end;
    D3D11_SRV_DIMENSION_TEXTURE2DARRAY:
    begin
      Texture2DArray.MostDetailedMip := aMostDetailedMip;
      Texture2DArray.MipLevels := aMipLevels;
      Texture2DArray.FirstArraySlice := aFirstArraySlice;
      Texture2DArray.ArraySize := aArraySize;
    end;
    D3D11_SRV_DIMENSION_TEXTURE2DMS:
    begin
      // do nothing
    end;
    D3D11_SRV_DIMENSION_TEXTURE2DMSARRAY:
    begin
      Texture2DMSArray.FirstArraySlice := aFirstArraySlice;
      Texture2DMSArray.ArraySize := aArraySize;
    end;
    D3D11_SRV_DIMENSION_TEXTURECUBE:
    begin
      TextureCube.MostDetailedMip := aMostDetailedMip;
      TextureCube.MipLevels := aMipLevels;
    end;
    D3D11_SRV_DIMENSION_TEXTURECUBEARRAY:
    begin
      TextureCubeArray.MostDetailedMip := aMostDetailedMip;
      TextureCubeArray.MipLevels := aMipLevels;
      TextureCubeArray.First2DArrayFace := aFirstArraySlice;
      TextureCubeArray.NumCubes := aArraySize;
    end;
  end;
end;

constructor D3D11_SHADER_RESOURCE_VIEW_DESC.Create(pTex3D: ID3D11Texture3D;
  aFormat: DXGI_FORMAT; aMostDetailedMip, aMipLevels: UINT);
var
  TexDesc: D3D11_TEXTURE3D_DESC;
begin
  ViewDimension := D3D11_SRV_DIMENSION_TEXTURE3D;
  if ((DXGI_FORMAT_UNKNOWN = aFormat) or (UINT(-1) = aMipLevels)) then
  begin
    pTex3D.GetDesc(TexDesc);
    if (DXGI_FORMAT_UNKNOWN = aFormat) then
      aFormat := TexDesc.Format;
    if (UINT(-1) = aMipLevels) then
      aMipLevels := TexDesc.MipLevels - aMostDetailedMip;
  end;
  Format := aFormat;
  Texture3D.MostDetailedMip := aMostDetailedMip;
  Texture3D.MipLevels := aMipLevels;
end;

{ D3D11_RENDER_TARGET_VIEW_DESC}

constructor D3D11_RENDER_TARGET_VIEW_DESC.Create(
  const o: D3D11_RENDER_TARGET_VIEW_DESC);
begin
  Self := o;
end;

constructor D3D11_RENDER_TARGET_VIEW_DESC.Create(
  aViewDimension: D3D11_RTV_DIMENSION; aFormat: DXGI_FORMAT; aMipSlice,
  aFirstArraySlice, aArraySize: UINT);
begin
  Format := aFormat;
  ViewDimension := aViewDimension;
  case aViewDimension of
    D3D11_RTV_DIMENSION_BUFFER:
    begin
      Buffer.FirstElement := aMipSlice;
      Buffer.NumElements := aFirstArraySlice;
    end;
    D3D11_RTV_DIMENSION_TEXTURE1D:
    begin
      Texture1D.MipSlice := aMipSlice;
    end;
    D3D11_RTV_DIMENSION_TEXTURE1DARRAY:
    begin
      Texture1DArray.MipSlice := aMipSlice;
      Texture1DArray.FirstArraySlice := aFirstArraySlice;
      Texture1DArray.ArraySize := aArraySize;
    end;
    D3D11_RTV_DIMENSION_TEXTURE2D:
    begin
      Texture2D.MipSlice := aMipSlice;
    end;
    D3D11_RTV_DIMENSION_TEXTURE2DARRAY:
    begin
      Texture2DArray.MipSlice := aMipSlice;
      Texture2DArray.FirstArraySlice := aFirstArraySlice;
      Texture2DArray.ArraySize := aArraySize;
    end;
    D3D11_RTV_DIMENSION_TEXTURE2DMS:
    begin
      // do nothing
    end;
    D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY:
    begin
      Texture2DMSArray.FirstArraySlice := aFirstArraySlice;
      Texture2DMSArray.ArraySize := aArraySize;
    end;
    D3D11_RTV_DIMENSION_TEXTURE3D:
    begin
      Texture3D.MipSlice := aMipSlice;
      Texture3D.FirstWSlice := aFirstArraySlice;
      Texture3D.WSize := aArraySize;
    end;
  end;
end;

constructor D3D11_RENDER_TARGET_VIEW_DESC.Create(aBuffer: ID3D11Buffer;
  aFormat: DXGI_FORMAT; aFirstElement, aNumElements: UINT);
begin
  Format := aFormat;
  ViewDimension := D3D11_RTV_DIMENSION_BUFFER;
  Buffer.FirstElement := aFirstElement;
  Buffer.NumElements := aNumElements;
end;

constructor D3D11_RENDER_TARGET_VIEW_DESC.Create(pTex1D: ID3D11Texture1D;
  aViewDimension: D3D11_RTV_DIMENSION; aFormat: DXGI_FORMAT; aMipSlice,
  aFirstArraySlice, aArraySize: UINT);
var
  TexDesc: D3D11_TEXTURE1D_DESC;
begin
  ViewDimension := aViewDimension;
  if ((DXGI_FORMAT_UNKNOWN = aFormat) or
      ((UINT(-1) = aArraySize) and (D3D11_RTV_DIMENSION_TEXTURE1DARRAY = aViewDimension))) then
  begin
    pTex1D.GetDesc(TexDesc);
    if (DXGI_FORMAT_UNKNOWN = aFormat) then
      aFormat := TexDesc.Format;
    if (UINT(-1) = aArraySize) then
      aArraySize := TexDesc.ArraySize - aFirstArraySlice;
  end;
  Format := aFormat;
  case viewDimension of
    D3D11_RTV_DIMENSION_TEXTURE1D:
    begin
      Texture1D.MipSlice := aMipSlice;
    end;
    D3D11_RTV_DIMENSION_TEXTURE1DARRAY:
    begin
      Texture1DArray.MipSlice := aMipSlice;
      Texture1DArray.FirstArraySlice := aFirstArraySlice;
      Texture1DArray.ArraySize := aArraySize;
    end;
  end;
end;

constructor D3D11_RENDER_TARGET_VIEW_DESC.Create(pTex2D: ID3D11Texture2D;
  aViewDimension: D3D11_RTV_DIMENSION; aFormat: DXGI_FORMAT; aMipSlice,
  aFirstArraySlice, aArraySize: UINT);
var
  TexDesc: D3D11_TEXTURE2D_DESC;
begin
  ViewDimension := aViewDimension;
  if ((DXGI_FORMAT_UNKNOWN = aFormat) or
      ((UINT(-1) = aArraySize) and
          ((D3D11_RTV_DIMENSION_TEXTURE2DARRAY = aViewDimension) or
          (D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY = aViewDimension)))) then
  begin
    pTex2D.GetDesc(TexDesc);
    if (DXGI_FORMAT_UNKNOWN = aFormat) then
      aFormat := TexDesc.Format;
    if (UINT(-1) = aArraySize) then
      aArraySize := TexDesc.ArraySize - aFirstArraySlice;
  end;
  Format := aFormat;
  case aViewDimension of
    D3D11_RTV_DIMENSION_TEXTURE2D:
    begin
      Texture2D.MipSlice := aMipSlice;
    end;
    D3D11_RTV_DIMENSION_TEXTURE2DARRAY:
    begin
      Texture2DArray.MipSlice := aMipSlice;
      Texture2DArray.FirstArraySlice := aFirstArraySlice;
      Texture2DArray.ArraySize := aArraySize;
    end;
    D3D11_RTV_DIMENSION_TEXTURE2DMS:
    begin
      // do nothing
    end;
    D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY:
    begin
      Texture2DMSArray.FirstArraySlice := aFirstArraySlice;
      Texture2DMSArray.ArraySize := aArraySize;
    end;
  end;
end;

constructor D3D11_RENDER_TARGET_VIEW_DESC.Create(pTex3D: ID3D11Texture3D;
  aFormat: DXGI_FORMAT; aMipSlice, aFirstWSlice, awSize: UINT);
var
  TexDesc: D3D11_TEXTURE3D_DESC;
begin
  ViewDimension := D3D11_RTV_DIMENSION_TEXTURE3D;
  if ((DXGI_FORMAT_UNKNOWN = aFormat) or (UINT(-1) = awSize)) then
  begin
    pTex3D.GetDesc(TexDesc);
    if (DXGI_FORMAT_UNKNOWN = aFormat) then
      aFormat := TexDesc.Format;
    if (UINT(-1) = awSize) then
      awSize := TexDesc.Depth - aFirstWSlice;
  end;
  Format := aFormat;
  Texture3D.MipSlice := aMipSlice;
  Texture3D.FirstWSlice := aFirstWSlice;
  Texture3D.WSize := awSize;
end;

{ D3D11_VIEWPORT}

constructor D3D11_VIEWPORT.Create(const o: D3D11_VIEWPORT);
begin
  Self := o;
end;

constructor D3D11_VIEWPORT.Create(aTopLeftX, aTopLeftY, aWidth, aHeight,
  aMinDepth, aMaxDepth: Single);
begin
  TopLeftX := aTopLeftX;
  TopLeftY := aTopLeftY;
  Width := aWidth;
  Height := aHeight;
  MinDepth := aMinDepth;
  MaxDepth := aMaxDepth;
end;

constructor D3D11_VIEWPORT.Create(buff: ID3D11Buffer;
  pRTView: ID3D11RenderTargetView; aTopLeftX, aMinDepth, aMaxDepth: Single);
var
  RTVDesc: D3D11_RENDER_TARGET_VIEW_DESC;
  NumElements: UINT;
begin

  pRTView.GetDesc(RTVDesc);
  NumElements := 0;
  case RTVDesc.ViewDimension of
    D3D11_RTV_DIMENSION_BUFFER:
      NumElements := RTVDesc.Buffer.NumElements;
  end;
  TopLeftX := aTopLeftX;
  TopLeftY := 0.0;
  Width := NumElements - aTopLeftX;
  Height := 1.0;
  MinDepth := aMinDepth;
  MaxDepth := aMaxDepth;
end;

constructor D3D11_VIEWPORT.Create(pTex1D: ID3D11Texture1D;
  pRTView: ID3D11RenderTargetView; aTopLeftX, aTinDepth, aTaxDepth: Single);
var
  TexDesc: D3D11_TEXTURE1D_DESC;
  RTVDesc: D3D11_RENDER_TARGET_VIEW_DESC;
  MipSlice: UINT;
  SubResourceWidth: UINT;
begin
  pTex1D.GetDesc(TexDesc);
  pRTView.GetDesc(RTVDesc);
  MipSlice := 0;
  case RTVDesc.ViewDimension of
    D3D11_RTV_DIMENSION_TEXTURE1D:
      MipSlice := RTVDesc.Texture1D.MipSlice;
    D3D11_RTV_DIMENSION_TEXTURE1DARRAY:
      MipSlice := RTVDesc.Texture1DArray.MipSlice;
  end;
  SubResourceWidth := TexDesc.Width div (UINT(1) shl MipSlice);
  TopLeftX := aTopLeftX;
  TopLeftY := 0.0;

  if SubResourceWidth > 0 then //Width := (SubResourceWidth ? SubResourceWidth : 1) - topLeftX
    Width := SubResourceWidth - topLeftX
  else
    Width := 1 - topLeftX;
  Height := 1.0;
  MinDepth := MinDepth;
  MaxDepth := MaxDepth;

end;

constructor D3D11_VIEWPORT.Create(pTex2D: ID3D11Texture2D;
  pRTView: ID3D11RenderTargetView; aTopLeftX, aTopLeftY, aMinDepth,
  aMaxDepth: Single);
var
  TexDesc: D3D11_TEXTURE2D_DESC;
  RTVDesc: D3D11_RENDER_TARGET_VIEW_DESC;
  MipSlice: UINT;
  SubResourceWidth,
  SubResourceHeight: UINT;
begin
  pTex2D.GetDesc(TexDesc);
  pRTView.GetDesc(RTVDesc);
  MipSlice := 0;
  case RTVDesc.ViewDimension of
    D3D11_RTV_DIMENSION_TEXTURE2D:
      MipSlice := RTVDesc.Texture2D.MipSlice;
    D3D11_RTV_DIMENSION_TEXTURE2DARRAY:
      MipSlice := RTVDesc.Texture2DArray.MipSlice;
    D3D11_RTV_DIMENSION_TEXTURE2DMS: ; //do nothing
    D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY:; //do nothing
  end;
  SubResourceWidth := TexDesc.Width div (UINT(1) shl MipSlice);
  SubResourceHeight := TexDesc.Height div (UINT(1) shl MipSlice);
  TopLeftX := aTopLeftX;
  TopLeftY := aTopLeftY;
  if SubResourceWidth = 0 then // Width := (SubResourceWidth ? SubResourceWidth : 1) - topLeftX;
    Width := 1 - topLeftX
  else
    Width := SubResourceWidth - topLeftX;

  if SubResourceHeight = 0 then // Height := (SubResourceHeight ? SubResourceHeight : 1) - topLeftY;
    Height := 1 - topLeftY
  else
    Height := SubResourceHeight - topLeftY;

  MinDepth := aMinDepth;
  MaxDepth := aMaxDepth;

end;

constructor D3D11_VIEWPORT.Create(pTex3D: ID3D11Texture3D;
  pRTView: ID3D11RenderTargetView; aTopLeftX, aTopLeftY, aMinDepth,
  aMaxDepth: Single);
var
  TexDesc: D3D11_TEXTURE3D_DESC;
  RTVDesc: D3D11_RENDER_TARGET_VIEW_DESC;
  MipSlice: UINT;
  SubResourceWidth,
  SubResourceHeight: UINT;
begin
  pTex3D.GetDesc(TexDesc);
  pRTView.GetDesc(RTVDesc);
  MipSlice := 0;
  case RTVDesc.ViewDimension of
    D3D11_RTV_DIMENSION_TEXTURE3D:
      MipSlice := RTVDesc.Texture3D.MipSlice;
  end;
  SubResourceWidth := TexDesc.Width div (UINT(1) shl MipSlice);
  SubResourceHeight := TexDesc.Height div (UINT(1) shl MipSlice);
  TopLeftX := aTopLeftX;
  TopLeftY := aTopLeftY;

  if SubResourceWidth = 0 then //Width = (SubResourceWidth ? SubResourceWidth : 1) - topLeftX;
    Width := 1 - topLeftX
  else
    Width := SubResourceWidth - topLeftX;

  if SubResourceHeight = 0 then //Height = (SubResourceHeight ? SubResourceHeight : 1) - topLeftY;
    Height := 1 - topLeftY
  else
    Height := SubResourceHeight - topLeftY;
  MinDepth := aMinDepth;
  MaxDepth := aMaxDepth;
end;

{ D3D11_DEPTH_STENCIL_VIEW_DESC}

constructor D3D11_DEPTH_STENCIL_VIEW_DESC.Create(
  const o: D3D11_DEPTH_STENCIL_VIEW_DESC);
begin
  Self := o;
end;

constructor D3D11_DEPTH_STENCIL_VIEW_DESC.Create(
  aViewDimension: D3D11_DSV_DIMENSION; aFormat: DXGI_FORMAT; aMipSlice,
  aFirstArraySlice, aArraySize, aFlags: UINT);
begin
  Format := aFormat;
  ViewDimension := aViewDimension;
  Flags := aFlags;
  case aViewDimension of
    D3D11_DSV_DIMENSION_TEXTURE1D:
      Texture1D.MipSlice := aMipSlice;
    D3D11_DSV_DIMENSION_TEXTURE1DARRAY:
    begin
      Texture1DArray.MipSlice := aMipSlice;
      Texture1DArray.FirstArraySlice := aFirstArraySlice;
      Texture1DArray.ArraySize := aArraySize;
    end;
    D3D11_DSV_DIMENSION_TEXTURE2D:
      Texture2D.MipSlice := aMipSlice;
    D3D11_DSV_DIMENSION_TEXTURE2DARRAY:
    begin
      Texture2DArray.MipSlice := aMipSlice;
      Texture2DArray.FirstArraySlice := aFirstArraySlice;
      Texture2DArray.ArraySize := aArraySize;
    end;
    D3D11_DSV_DIMENSION_TEXTURE2DMS: ; //do nothing
    D3D11_DSV_DIMENSION_TEXTURE2DMSARRAY:
    begin
      Texture2DMSArray.FirstArraySlice := aFirstArraySlice;
      Texture2DMSArray.ArraySize := aArraySize;
    end;
  end;
end;

constructor D3D11_DEPTH_STENCIL_VIEW_DESC.Create(pTex1D: ID3D11Texture1D;
  aViewDimension: D3D11_DSV_DIMENSION; aFormat: DXGI_FORMAT; aMipSlice,
  aFirstArraySlice,aArraySize, aFlags: UINT);
var
  TexDesc:D3D11_TEXTURE1D_DESC;
begin
  ViewDimension := aViewDimension;
  Flags := aFlags;
  if ((DXGI_FORMAT_UNKNOWN = aFormat) or
      ((UINT(-1) = aArraySize) and (D3D11_DSV_DIMENSION_TEXTURE1DARRAY = aViewDimension))) then
  begin
    pTex1D.GetDesc(TexDesc);
    if (DXGI_FORMAT_UNKNOWN = aFormat) then
      aFormat := TexDesc.Format;
    if (UINT(-1) = aArraySize) then
      aArraySize := TexDesc.ArraySize - aFirstArraySlice;
  end;
  Format := aFormat;
  case viewDimension of
    D3D11_DSV_DIMENSION_TEXTURE1D:
      Texture1D.MipSlice := aMipSlice;
    D3D11_DSV_DIMENSION_TEXTURE1DARRAY:
    begin
      Texture1DArray.MipSlice := aMipSlice;
      Texture1DArray.FirstArraySlice := aFirstArraySlice;
      Texture1DArray.ArraySize := aArraySize;
    end;
  end;
end;

constructor D3D11_DEPTH_STENCIL_VIEW_DESC.Create(pTex2D: ID3D11Texture2D;
  aViewDimension: D3D11_DSV_DIMENSION; aFormat: DXGI_FORMAT; aMipSlice,
  aFirstArraySlice, aArraySize, aFlags: UINT);
var
  TexDesc: D3D11_TEXTURE2D_DESC;
begin
  ViewDimension := aViewDimension;
  Flags := aFlags;
  if ((DXGI_FORMAT_UNKNOWN = aFormat) or
      ((UINT(-1) = aArraySize) and
          ((D3D11_DSV_DIMENSION_TEXTURE2DARRAY = aViewDimension) or
          (D3D11_DSV_DIMENSION_TEXTURE2DMSARRAY = aViewDimension)))) then
  begin
    pTex2D.GetDesc(TexDesc);
    if (DXGI_FORMAT_UNKNOWN = aFormat) then
      aFormat := TexDesc.Format;
    if (UINT(-1) = aArraySize) then
      aArraySize := TexDesc.ArraySize - aFirstArraySlice;
  end;
  Format := aFormat;
  case aViewDimension of
    D3D11_DSV_DIMENSION_TEXTURE2D:
      Texture2D.MipSlice := aMipSlice;
    D3D11_DSV_DIMENSION_TEXTURE2DARRAY:
    begin
      Texture2DArray.MipSlice := aMipSlice;
      Texture2DArray.FirstArraySlice := aFirstArraySlice;
      Texture2DArray.ArraySize := aArraySize;
    end;
    D3D11_DSV_DIMENSION_TEXTURE2DMS:; // do nothing
    D3D11_DSV_DIMENSION_TEXTURE2DMSARRAY:
    begin
      Texture2DMSArray.FirstArraySlice := aFirstArraySlice;
      Texture2DMSArray.ArraySize := aArraySize;
    end;
  end;

end;

{ D3D11_UNORDERED_ACCESS_VIEW_DESC}

constructor D3D11_UNORDERED_ACCESS_VIEW_DESC.Create(
  const o: D3D11_UNORDERED_ACCESS_VIEW_DESC);
begin
  Self := o;
end;

constructor D3D11_UNORDERED_ACCESS_VIEW_DESC.Create(
  aViewDimension: D3D11_UAV_DIMENSION; aFormat: DXGI_FORMAT; aMipSlice,
  aFirstArraySlice, aArraySize, aFlags: UINT);
begin
  Format := aFormat;
  ViewDimension := aViewDimension;
  case viewDimension of
    D3D11_UAV_DIMENSION_BUFFER:
    begin
      Buffer.FirstElement := aMipSlice;
      Buffer.NumElements := aFirstArraySlice;
      Buffer.Flags := aFlags;
    end;
    D3D11_UAV_DIMENSION_TEXTURE1D:
    begin
      Texture1D.MipSlice := aMipSlice;
    end;
    D3D11_UAV_DIMENSION_TEXTURE1DARRAY:
    begin
      Texture1DArray.MipSlice := aMipSlice;
      Texture1DArray.FirstArraySlice := aFirstArraySlice;
      Texture1DArray.ArraySize := aArraySize;
    end;
    D3D11_UAV_DIMENSION_TEXTURE2D:
    begin
      Texture2D.MipSlice := aMipSlice;
    end;
    D3D11_UAV_DIMENSION_TEXTURE2DARRAY:
    begin
      Texture2DArray.MipSlice := aMipSlice;
      Texture2DArray.FirstArraySlice := aFirstArraySlice;
      Texture2DArray.ArraySize := aArraySize;
    end;
    D3D11_UAV_DIMENSION_TEXTURE3D:
    begin
      Texture3D.MipSlice := aMipSlice;
      Texture3D.FirstWSlice := aFirstArraySlice;
      Texture3D.WSize := aArraySize;
    end;
  end;
end;

constructor D3D11_UNORDERED_ACCESS_VIEW_DESC.Create(aBuffer: ID3D11Buffer;
  aFormat: DXGI_FORMAT; aFirstElement, aNumElements, aFlags: UINT);
begin
  Format := aFormat;
  ViewDimension := D3D11_UAV_DIMENSION_BUFFER;
  Buffer.FirstElement := aFirstElement;
  Buffer.NumElements := aNumElements;
  Buffer.Flags := aFlags;
end;

constructor D3D11_UNORDERED_ACCESS_VIEW_DESC.Create(pTex1D: ID3D11Texture1D;
  aViewDimension: D3D11_UAV_DIMENSION; aFormat: DXGI_FORMAT; aMipSlice,
  aFirstArraySlice, aArraySize: UINT);
var
  TexDesc: D3D11_TEXTURE1D_DESC;
begin
  ViewDimension := aViewDimension;
  if ((DXGI_FORMAT_UNKNOWN = aFormat) or
      ((UINT(-1) = aArraySize) and
      (D3D11_UAV_DIMENSION_TEXTURE1DARRAY = aViewDimension))) then
  begin
    pTex1D.GetDesc(TexDesc);
    if (DXGI_FORMAT_UNKNOWN = format) then
      aFormat := TexDesc.Format;
    if (UINT(-1) = aArraySize) then
      aArraySize := TexDesc.ArraySize - aFirstArraySlice;
  end;
  Format := aFormat;
  case aViewDimension of
    D3D11_UAV_DIMENSION_TEXTURE1D:
      Texture1D.MipSlice := aMipSlice;
    D3D11_UAV_DIMENSION_TEXTURE1DARRAY:
    begin
      Texture1DArray.MipSlice := aMipSlice;
      Texture1DArray.FirstArraySlice := aFirstArraySlice;
      Texture1DArray.ArraySize := aArraySize;
    end;
  end;
end;

constructor D3D11_UNORDERED_ACCESS_VIEW_DESC.Create(pTex2D: ID3D11Texture2D;
  aViewDimension: D3D11_UAV_DIMENSION; aFormat: DXGI_FORMAT; aMipSlice,
  aFirstArraySlice, aArraySize: UINT);
var
  TexDesc: D3D11_TEXTURE2D_DESC;
begin
  ViewDimension := aViewDimension;
  if ((DXGI_FORMAT_UNKNOWN = aFormat) or
      ((UINT(-1) = aArraySize) and
      (D3D11_UAV_DIMENSION_TEXTURE2DARRAY = aViewDimension))) then
  begin
    pTex2D.GetDesc(TexDesc);
    if (DXGI_FORMAT_UNKNOWN = aFormat) then
      aFormat := TexDesc.Format;
    if (UINT(-1) = aArraySize) then
      aArraySize := TexDesc.ArraySize - aFirstArraySlice;
  end;
  Format := aFormat;
  case aViewDimension of
    D3D11_UAV_DIMENSION_TEXTURE2D:
      Texture2D.MipSlice := aMipSlice;
    D3D11_UAV_DIMENSION_TEXTURE2DARRAY:
    begin
      Texture2DArray.MipSlice := aMipSlice;
      Texture2DArray.FirstArraySlice := aFirstArraySlice;
      Texture2DArray.ArraySize := aArraySize;
    end;
  end;
end;

constructor D3D11_UNORDERED_ACCESS_VIEW_DESC.Create(pTex3D: ID3D11Texture3D;
  aFormat: DXGI_FORMAT; aMipSlice, aFirstWSlice, awSize: UINT);
var
  TexDesc: D3D11_TEXTURE3D_DESC;
begin
  ViewDimension := D3D11_UAV_DIMENSION_TEXTURE3D;
  if ((DXGI_FORMAT_UNKNOWN = aFormat) or (UINT(-1) = awSize)) then
  begin
    pTex3D.GetDesc(TexDesc);
    if (DXGI_FORMAT_UNKNOWN = aFormat) then
      aFormat := TexDesc.Format;
    if (UINT(-1) = awSize) then
      awSize := TexDesc.Depth - aFirstWSlice;
  end;
  Format := aFormat;
  Texture3D.MipSlice := aMipSlice;
  Texture3D.FirstWSlice := aFirstWSlice;
  Texture3D.WSize := awSize;
end;

{ D3D11_SAMPLER_DESC}

constructor D3D11_SAMPLER_DESC.Create(const o: D3D11_SAMPLER_DESC);
begin
  Self := o;
end;

constructor D3D11_SAMPLER_DESC.Create(isDefault: boolean);
begin
  Filter := D3D11_FILTER_MIN_MAG_MIP_LINEAR;
  AddressU := D3D11_TEXTURE_ADDRESS_CLAMP;
  AddressV := D3D11_TEXTURE_ADDRESS_CLAMP;
  AddressW := D3D11_TEXTURE_ADDRESS_CLAMP;
  MipLODBias := 0;
  MaxAnisotropy := 1;
  ComparisonFunc := D3D11_COMPARISON_NEVER;
  BorderColor[0] := 1.0;
  BorderColor[1] := 1.0;
  BorderColor[2] := 1.0;
  BorderColor[3] := 1.0;
  MinLOD := -3.402823466e+38; // -FLT_MAX
  MaxLOD := 3.402823466e+38; // FLT_MAX
end;

constructor D3D11_SAMPLER_DESC.Create(aFilter: D3D11_FILTER; aAddressU,
  aAddressV, aAddressW: D3D11_TEXTURE_ADDRESS_MODE; aMipLODBias: Single;
  aMaxAnisotropy: UINT; aComparisonFunc: D3D11_COMPARISON_FUNC;
  const aBorderColor: array of Single; aMinLOD, aMaxLOD: Single);
type
  TcolorArray = array [0..3] of Single;
const
  defaultColor: TColorArray = (1.0, 1.0, 1.0, 1.0);
begin
  Filter := aFilter;
  AddressU := aAddressU;
  AddressV := aAddressV;
  AddressW := aAddressW;
  MipLODBias := aMipLODBias;
  MaxAnisotropy := aMaxAnisotropy;
  ComparisonFunc := aComparisonFunc;
  if (@aBorderColor = nil) then
  begin
    BorderColor[0] := aBorderColor[0];
    BorderColor[1] := aBorderColor[1];
    BorderColor[2] := aBorderColor[2];
    BorderColor[3] := aBorderColor[3];
  end
  else
  begin
    BorderColor[0] := defaultColor[0];
    BorderColor[1] := defaultColor[1];
    BorderColor[2] := defaultColor[2];
    BorderColor[3] := defaultColor[3];
  end;
  MinLOD := aMinLOD;
  MaxLOD := aMaxLOD;
end;


{ D3D11_QUERY_DESC}

constructor D3D11_QUERY_DESC.create(const o: D3D11_QUERY_DESC);
begin
  Self := o;
end;

constructor D3D11_QUERY_DESC.create(aQuery: D3D11_QUERY; aMiscFlags: UINT);
begin
  Query := aQuery;
  MiscFlags := aMiscFlags;
end;


{ D3D11_COUNTER_DESC}

constructor D3D11_COUNTER_DESC.Create(const o: D3D11_COUNTER_DESC);
begin
  Self := o;
end;

constructor D3D11_COUNTER_DESC.Create(aCounter: D3D11_COUNTER; aMiscFlags: UINT);
begin
  Counter := aCounter;
  MiscFlags := aMiscFlags;
end;

end.
