# Created from MySQL Workbench
# (connected to art-service database on randyconnolly.com)
# 
# ***  Nov 25, 2018  ***
# 


DROP DATABASE IF EXISTS `art`;
CREATE DATABASE IF NOT EXISTS `art`;
USE `art`;

#
# Table structure for table 'Artists'
#

DROP TABLE IF EXISTS `Artists`;

CREATE TABLE `Artists` (
  `ArtistID` INTEGER NOT NULL AUTO_INCREMENT, 
  `FirstName` VARCHAR(50), 
  `LastName` VARCHAR(50) NOT NULL, 
  `Nationality` VARCHAR(50), 
  `Gender` VARCHAR(1) DEFAULT 'M', 
  `YearOfBirth` INTEGER DEFAULT 0, 
  `YearOfDeath` INTEGER DEFAULT 0, 
  `Details` LONGTEXT, 
  `ArtistLink` VARCHAR(255), 
  INDEX (`ArtistID`), 
  INDEX (`LastName`), 
  PRIMARY KEY (`ArtistID`)
) ENGINE=innodb DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Populating data for table 'Artists'
#
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (1,'Pablo','Picasso','Spain','M',1881,1973,'Pablo Ruiz Picasso was a Spanish painter, draughtsman, and sculptor who lived most of his life in France. He is widely known for co-founding the Cubist movement and for the wide variety of styles that he helped develop and explore. Among his most famous works are the proto-Cubist Les Demoiselles d\'Avignon (1907) and Guernica (1937), a portrayal of the German bombing of Guernica during the Spanish Civil War.','http://en.wikipedia.org/wiki/Picasso');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (2,'Henri','Matisse','France','M',1869,1954,'Henri Matisse was a French artist, known for his use of colour and his fluid and original draughtsmanship. He was a draughtsman, printmaker, and sculptor, but is known primarily as a painter. Matisse is commonly regarded, along with Picasso and Marcel Duchamp, as one of the three artists who helped to define the revolutionary developments in the plastic arts in the opening decades of the 20th century, responsible for significant developments in painting and sculpture. Although he was initially labelled a Fauve (wild beast), by the 1920s he was increasingly hailed as an upholder of the classical tradition in French painting. His mastery of the expressive language of colour and drawing, displayed in a body of work spanning over a half-century, won him recognition as a leading figure in modern art','http://en.wikipedia.org/wiki/Matisse');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (5,'Jacques-Louis','David','France','M',1748,1825,'Jacques-Louis David was a French painter in the Neoclassical style, considered to be the preeminent painter of the era. In the 1780s his cerebral brand of history painting marked a change in taste away from Rococo frivolity toward a classical austerity and severity, heightened feeling chiming with the moral climate of the final years of the Ancien Regime.','http://en.wikipedia.org/wiki/Jacques-Louis_David');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (6,'Jean-Auguste-Dominique','Ingres','France','M',1780,1867,'Jean-Auguste-Dominique Ingres was a French Neoclassical painter. Although he considered himself to be a painter of history in the tradition of Nicolas Poussin and Jacques-Louis David, by the end of his life it was Ingres\'s portraits, both painted and drawn, that were recognized as his greatest legacy.','http://en.wikipedia.org/wiki/Ingres');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (7,'Eugene','Delacroix','France','M',1798,1863,'Eugene Delacroix was a French Romantic artist regarded from the outset of his career as the leader of the French Romantic school. Delacroix\'s use of expressive brush strokes and his study of the optical effects of colour profoundly shaped the work of the Impressionists, while his passion for the exotic inspired the artists of the Symbolist movement. A fine lithographer, Delacroix illustrated various works of William Shakespeare, the Scottish writer Walter Scott and the German writer Johann Wolfgang von Goethe.','http://en.wikipedia.org/wiki/Eug%C3%A8ne_Delacroix');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (8,'Francisco','Goya','Spain','M',1746,1828,'Francisco Jose de Goya y Lucientes was a Spanish romantic painter and printmaker regarded both as the last of the Old Masters and the first of the moderns. Goya was a court painter to the Spanish Crown, and through his works was both a commentator on and chronicler of his era. The subversive and imaginative element in his art, as well as his bold handling of paint, provided a model for the work of later generations of artists, notably Manet, Picasso and Francis Bacon.','http://en.wikipedia.org/wiki/Goya');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (10,'Gustave','Courbet','France','M',1818,1877,'Jean Gustave Courbet was a French painter who led the Realist movement in 19th-century French painting. The Realist movement bridged the Romantic movement (characterized by the paintings of Theodore Gericault and Eugene Delacroix), with the Barbizon School and the Impressionists. Courbet occupies an important place in 19th century French painting as an innovator and as an artist willing to make bold social commentary in his work.','http://en.wikipedia.org/wiki/Courbet');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (12,'Edouard','Manet','France','M',1832,1883,'Edouard Manet was a French painter. One of the first 19th-century artists to approach modern-life subjects, he was a pivotal figure in the transition from Realism to Impressionism.','http://en.wikipedia.org/wiki/Manet');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (13,'James Abbott','Whistler','USA','M',1834,1903,'James Abbott McNeill Whistler was an American-born, British-based artist. Averse to sentimentality and moral allusion in painting, he was a leading proponent of the credo \"art for art\'s sake\". His famous signature for his paintings was in the shape of a stylized butterfly possessing a long stinger for a tail. The symbol was apt, for it combined both aspects of his personality; his art was characterized by a subtle delicacy, while his public persona was combative. Finding a parallel between painting and music, Whistler titled many of his paintings \"arrangements\", \"harmonies\", and \"nocturnes\", emphasizing the primacy of tonal harmony. His most famous painting is Whistler\'s Mother (1871), the revered and oft parodied portrait of motherhood. Whistler influenced the art world and the broader culture of his time with his artistic theories and his friendships with leading artists and writers.','http://en.wikipedia.org/wiki/James_Abbott_McNeill_Whistler');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (14,'Pierre Auguste','Renoir','France','M',1841,1919,'Pierre-Auguste Renoir was a French artist who was a leading painter in the development of the Impressionist style. As a celebrator of beauty, and especially feminine sensuality, it has been said that \"Renoir is the final representative of a tradition which runs directly from Rubens to Watteau.\"','http://en.wikipedia.org/wiki/Renoir');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (15,'Edgar','Degas','France','M',1834,1917,'Edgar Degas, born Hilaire-Germain-Edgar De Gas, was a French artist famous for his work in painting, sculpture, printmaking and drawing. He is regarded as one of the founders of Impressionism although he rejected the term, and preferred to be called a realist. A superb draughtsman, he is especially identified with the subject of the dance, and over half of his works depict dancers. These display his mastery in the depiction of movement, as do his racecourse subjects and female nudes. His portraits are notable for their psychological complexity and depiction of human isolation.','http://en.wikipedia.org/wiki/Degas');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (16,'Mary','Cassatt','USA','F',1845,1926,'Mary Stevenson Cassatt was an American painter and printmaker. She lived much of her adult life in France, where she first befriended Edgar Degas and later exhibited among the Impressionists. Cassatt often created images of the social and private lives of women, with particular emphasis on the intimate bonds between mothers and children.','http://en.wikipedia.org/wiki/Mary_Cassatt');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (17,'Claude','Monet','France','M',1840,1926,'Claude Monet was a founder of French impressionist painting, and the most consistent and prolific practitioner of the movement\'s philosophy of expressing one\'s perceptions before nature, especially as applied to plein-air landscape painting. The term Impressionism is derived from the title of his painting Impression, Sunrise (Impression, soleil levant).','http://en.wikipedia.org/wiki/Claude_Monet');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (18,'Paul','Gauguin','France','M',1848,1903,'Eugene Henri Paul Gauguin was a leading French Post-Impressionist artist. He was an important figure in the Symbolist movement as a painter, sculptor, print-maker, ceramist, and writer. His bold experimentation with coloring led directly to the Synthetist style of modern art while his expression of the inherent meaning of the subjects in his paintings, under the influence of the cloisonnist style, paved the way to Primitivism and the return to the pastoral. He was also an influential proponent of wood engraving and woodcuts as art forms.','http://en.wikipedia.org/wiki/Gauguin');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (19,'Vincent','Van Gogh','Netherlands','M',1853,1890,'Vincent Willem van Gogh was a Dutch post-Impressionist painter whose work, notable for its rough beauty, emotional honesty, and bold color, had a far-reaching influence on 20th-century art. After years of painful anxiety and frequent bouts of mental illness, he died at the age of 37 from a self-inflicted gunshot wound. His work was then known to only a handful of people and appreciated by fewer still.','http://en.wikipedia.org/wiki/Van_Gogh');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (20,'Georges','Seurat','France','M',1859,1891,'Georges-Pierre Seurat was a French Post-Impressionist painter and draftsman. He is noted for his innovative use of drawing media and for devising a technique of painting known as pointillism. His large-scale work A Sunday Afternoon on the Island of La Grande Jatte (1884-1886), Seurat\'s most famous painting, altered the direction of modern art by initiating Neo-impressionism, and is one of the icons of 19th century painting.','http://en.wikipedia.org/wiki/Seurat');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (21,'Paul','Cezanne','France','M',1839,1906,'Paul Cezanne was a French artist and Post-Impressionist painter whose work laid the foundations of the transition from the 19th century conception of artistic endeavour to a new and radically different world of art in the 20th century. Cezanne can be said to form the bridge between late 19th century Impressionism and the early 20th century\'s new line of artistic enquiry, Cubism. The line attributed to both Matisse and Picasso that Cezanne \"is the father of us all\" cannot be easily dismissed.','http://en.wikipedia.org/wiki/C%C3%A9zanne');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (24,'Edvard','Munch','Norway','M',1863,1944,'Edvard Munch was a Norwegian Symbolist painter, printmaker and an important forerunner of expressionist art. His best-known composition, The Scream, is part of a series The Frieze of Life, in which Munch explored the themes of love, fear, death, melancholia, and anxiety.','http://en.wikipedia.org/wiki/Edvard_Munch');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (28,'Henri','Toulouse-Lautrec','France','M',1864,1901,'Henri Marie Raymond de Toulouse-Lautrec-Monfa or simply Henri de Toulouse-Lautrec was a French painter, printmaker, draughtsman, and illustrator, whose immersion in the colourful and theatrical life of fin de siecle Paris yielded an oeuvre of exciting, elegant and provocative images of the modern and sometimes decadent life of those times. Toulouse-Lautrec is known along with Cezanne, Van Gogh, and Gauguin as one of the greatest painters of the Post-Impressionist period. In a 2005 auction at Christie\'s auction house a new record was set when \"La blanchisseuse\", an early painting of a young laundress, sold for $22.4 million U.S.','http://en.wikipedia.org/wiki/Toulouse-Lautrec');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (29,'Gustav','Klimt','Austria','M',1862,1918,'Gustav Klimt was an Austrian Symbolist painter and one of the most prominent members of the Vienna Secession movement. His major works include paintings, murals, sketches, and other art objects. Klimt\'s primary subject was the female body, and his works are marked by a frank eroticism; nowhere is this more apparent than in his numerous drawings in pencil.','http://en.wikipedia.org/wiki/Klimt');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (32,'Andre','Derain','France','M',1880,1919,'Andre Derain  was a French artist, painter, sculptor and co-founder of Fauvism with Henri Matisse','http://en.wikipedia.org/wiki/Andr%C3%A9_Derain');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (40,'Vasily','Kandinsky','Russia','M',1866,1944,'Wassily Wassilyevich Kandinsky was a Russian painter and art theorist. He is credited with painting the first purely-abstract works. Born in Moscow, Kandinsky spent his childhood in Odessa. He enrolled at the University of Moscow, studying law and economics. Successful in his profession; he was offered a professorship (chair of Roman Law) at the University of Dorpat and he began painting studies (life-drawing, sketching and anatomy) at the age of 30.','http://en.wikipedia.org/wiki/Kandinsky');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (41,'Giacomo','Balla','Italy','M',1871,1958,'Giacomo Balla was an Italian painter.','http://en.wikipedia.org/wiki/Giacomo_Balla');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (45,'Salvidor','Dali','Spain','M',1904,1989,'Salvador Dali was a prominent Spanish Catalan surrealist painter born in Figueres, Spain. Dali was a skilled draftsman, best known for the striking and bizarre images in his surrealist work. His painterly skills are often attributed to the influence of Renaissance masters. His best-known work, The Persistence of Memory, was completed in August 1931. Dali\'s expansive artistic repertoire included film, sculpture, and photography, at times in collaboration with a range of artists in a variety of media.','http://en.wikipedia.org/wiki/Salvador_Dal%C3%AD');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (60,'Paul','Klee','Switzerland','M',1879,1940,'Paul Klee was born in Munchenbuchsee, Switzerland, and is considered both a German and a Swiss painter. His highly individual style was influenced by movements in art that included expressionism, cubism, and surrealism. He was, as well, a student of orientalism. Klee was a natural draftsman who experimented with and eventually mastered color theory, and wrote extensively about it; his lectures Writings on Form and Design Theory (Schriften zur Form und Gestaltungslehre), published in English as the Paul Klee Notebooks, are considered so important for modern art that they are compared to the importance that Leonardo da Vinci\'s A Treatise on Painting had for Renaissance. He and his colleague, the Russian painter Wassily Kandinsky, both taught at the German Bauhaus school of art, design and architecture. His works reflect his dry humour and his sometimes childlike perspective, his personal moods and beliefs, and his musicality.','http://en.wikipedia.org/wiki/Paul_Klee');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (63,'Henri','Rousseau','France','M',1844,1910,'Henri Julien Felix Rousseau was a French Post-Impressionist painter in the Naive or Primitive manner. He was also known as Le Douanier (the customs officer), a humorous description of his occupation as a tax collector. Ridiculed during his life, he came to be recognized as a self-taught genius whose works are of high artistic quality.','http://en.wikipedia.org/wiki/Henri_Rousseau');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (64,'Marc','Chagall','Russia','M',1887,1985,'Marc Chagall was a Belorussian-French artist associated with several major artistic styles and one of the most successful artists of the 20th century. He was an early modernist, and created works in virtually every artistic medium, including painting, book illustrations, stained glass, stage sets, ceramic, tapestries and fine art prints.','http://en.wikipedia.org/wiki/Chagall');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (73,'Piet','Mondrian','Netherlands','M',1872,1944,'Pieter Cornelis \"Piet\" Mondriaan, after 1912 Mondrian, was a Dutch painter. He was an important contributor to the De Stijl art movement and group, which was founded by Theo van Doesburg. He evolved a non-representational form which he termed Neo-Plasticism. This consisted of white ground, upon which was painted a grid of vertical and horizontal black lines and the three primary colors.','http://en.wikipedia.org/wiki/Piet_Mondrian');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (92,'Filippo','Lippi','Italy','M',1406,1469,'Filippo Lippi, also called Lippo Lippi, was an Italian painter of the Italian Quattrocento (15th century).','http://en.wikipedia.org/wiki/Filippo_Lippi');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (93,'Piero della','Francesca','Italy','M',1412,1492,'Piero della Francesca was a painter of the Early Renaissance. As testified by Giorgio Vasari in his Lives of the Artists, to contemporaries he was also known as a mathematician and geometer. Nowadays Piero della Francesca is chiefly appreciated for his art. His painting was characterized by its serene humanism, its use of geometric forms and perspective. His most famous work is the cycle of frescoes \"The Legend of the True Cross\" in the church of San Francesco in the Tuscan town of Arezzo.','http://en.wikipedia.org/wiki/Piero_della_Francesca');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (94,'Andrea','Mantegna','Italy','M',1431,1506,'Andrea Mantegna was an Italian painter, a student of Roman archeology, and son in law of Jacopo Bellini. Like other artists of the time, Mantegna experimented with perspective, e.g., by lowering the horizon in order to create a sense of greater monumentality. His flinty, metallic landscapes and somewhat stony figures give evidence of a fundamentally sculptural approach to painting. He also led a workshop that was the leading producer of prints in Venice before 1500.','http://en.wikipedia.org/wiki/Andrea_Mantegna');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (95,'Sandro','Botticelli','Italy','M',1445,1510,'Alessandro di Mariano di Vanni Filipepi, better known as Sandro Botticelli was an Italian painter of the Early Renaissance. He belonged to the Florentine school under the patronage of Lorenzo de\' Medici, a movement that Giorgio Vasari would characterize less than a hundred years later as a \"golden age\", a thought, suitably enough, he expressed at the head of his Vita of Botticelli. Botticelli\'s posthumous reputation suffered until the late 19th century; since then his work has been seen to represent the linear grace of Early Renaissance painting. Among his best known works are The Birth of Venus and Primavera.','http://en.wikipedia.org/wiki/Sandro_Botticelli');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (96,'Pietro','Perugino','Italy','M',1446,1524,'Pietro Perugino, born Pietro Vannucci, was an Italian Renaissance painter of the Umbrian school, who developed some of the qualities that found classic expression in the High Renaissance. Raphael was his most famous pupil.','http://en.wikipedia.org/wiki/Pietro_Perugino');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (97,'Leonardo','da Vinci','Italy','M',1452,1519,'Leonardo di ser Piero da Vinci was an Italian Renaissance polymath: painter, sculptor, architect, musician, mathematician, engineer, inventor, anatomist, geologist, cartographer, botanist, and writer. His genius, perhaps more than that of any other figure, epitomized the Renaissance humanist ideal. Leonardo has often been described as the archetype of the Renaissance Man, a man of \"unquenchable curiosity\" and \"feverishly inventive imagination\". He is widely considered to be one of the greatest painters of all time and perhaps the most diversely talented person ever to have lived. According to art historian Helen Gardner, the scope and depth of his interests were without precedent and \"his mind and personality seem to us superhuman, the man himself mysterious and remote\". Marco Rosci states that while there is much speculation about Leonardo, his vision of the world is essentially logical rather than mysterious, and that the empirical methods he employed were unusual for his time.','http://en.wikipedia.org/wiki/Leonardo_da_Vinci');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (98,NULL,'Michelangelo','Italy','M',1475,1564,'Michelangelo di Lodovico Buonarroti Simoni commonly known as Michelangelo, was an Italian sculptor, painter, architect, poet, and engineer of the High Renaissance who exerted an unparalleled influence on the development of Western art. Despite making few forays beyond the arts, his versatility in the disciplines he took up was of such a high order that he is often considered a contender for the title of the archetypal Renaissance man, along with his fellow Italian Leonardo da Vinci. Michelangelo was considered the greatest living artist in his lifetime, and ever since then he has been held to be one of the greatest artists of all time. A number of his works in painting, sculpture, and architecture rank among the most famous in existence. His output in every field during his long life was prodigious; when the sheer volume of correspondence, sketches, and reminiscences that survive is also taken into account, he is the best-documented artist of the 16th century.','http://en.wikipedia.org/wiki/Michelangelo');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (99,NULL,'Raphael','Italy','M',1483,1520,'Raffaello Sanzio da Urbino, better known simply as Raphael, was an Italian painter and architect of the High Renaissance. His work is admired for its clarity of form and ease of composition and for its visual achievement of the Neoplatonic ideal of human grandeur. Together with Michelangelo and Leonardo da Vinci, he forms the traditional trinity of great masters of that period.','http://en.wikipedia.org/wiki/Raphael');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (100,NULL,'Titian','Italy','M',1488,1576,'Tiziano Vecelli known in English as Titian was an Italian painter, the most important member of the 16th-century Venetian school. He was born in Pieve di Cadore, near Belluno (in Veneto), in the Republic of Venice. During his lifetime he was often called da Cadore, taken from the place of his birth. During the course of his long life, Titian\'s artistic manner changed drastically[4] but he retained a lifelong interest in color. Although his mature works may not contain the vivid, luminous tints of his early pieces, their loose brushwork and subtlety of polychromatic modulations are without precedent in the history of Western art.','http://en.wikipedia.org/wiki/Titian');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (101,NULL,'Caravaggio','Italy','M',1571,1610,'Michelangelo Merisi da Caravaggio was an Italian artist active in Rome, Naples, Malta, and Sicily between 1593 and 1610. His paintings, which combine a realistic observation of the human state, both physical and emotional, with a dramatic use of lighting, had a formative influence on the Baroque school of painting.','http://en.wikipedia.org/wiki/Caravaggio');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (102,'Peter Paul','Rubens','Belgium','M',1577,1640,'Sir Peter Paul Rubens was a German-born Flemish Baroque painter, and a proponent of an extravagant Baroque style that emphasised movement, colour, and sensuality. He is well known for his Counter-Reformation altarpieces, portraits, landscapes, and history paintings of mythological and allegorical subjects.','http://en.wikipedia.org/wiki/Peter_Paul_Rubens');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (103,'Anthony van','Dyck','Belgium','M',1599,1641,'Sir Anthony van Dyck was a Flemish Baroque artist who became the leading court painter in England. He is most famous for his portraits of Charles I of England and his family and court, painted with a relaxed elegance that was to be the dominant influence on English portrait-painting for the next 150 years. He also painted biblical and mythological subjects, displayed outstanding facility as a draftsman, and was an important innovator in watercolour and etching.','http://en.wikipedia.org/wiki/Anthony_van_Dyck');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (104,'Diego','Velázquez','Spain','M',1599,1660,'Diego Rodriguez de Silva y Velazquez was a Spanish painter who was the leading artist in the court of King Philip IV. He was an individualistic artist of the contemporary Baroque period, important as a portrait artist. In addition to numerous renditions of scenes of historical and cultural significance, he painted scores of portraits of the Spanish royal family, other notable European figures, and commoners.','http://en.wikipedia.org/wiki/Diego_Vel%C3%A1zquez');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (105,NULL,'Rembrandt','Netherlands','M',1606,1669,'Rembrandt Harmenszoon van Rijn was a Dutch painter and etcher. He is generally considered one of the greatest painters and printmakers in European art history and the most important in Dutch history. His contributions to art came in a period of great wealth and cultural achievement that historians call the Dutch Golden Age when Dutch Golden Age painting, although in many ways antithetical to the Baroque style that dominated Europe, was extremely prolific and innovative.','http://en.wikipedia.org/wiki/Rembrandt');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (106,'Jan','Vermeer','Netherlands','M',1632,1675,'Jan Vermeer was a Dutch painter who specialized in domestic interior scenes of middle-class life. Vermeer was a moderately successful provincial genre painter in his lifetime. He seems never to have been particularly wealthy, leaving his wife and children in debt at his death, perhaps because he produced relatively few paintings. Vermeer worked slowly and with great care, using bright colours and sometimes expensive pigments, with a preference for cornflower blue and yellow. He is particularly renowned for his masterly treatment and use of light in his work.','http://en.wikipedia.org/wiki/Johannes_Vermeer');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (107,'Francois','Boucher','France','M',1703,1770,'Possibly the most popular 18th century artist, Francois Boucher was a French painter in the Rococo style. When he was 17 years old, Boucher was apprenticed for a short time to the French painter Francois Lemoyne, and then to the engraver Jean-Francois Cars. After three years of work and artistic study, Boucher won the Grand Prix de Rome, a scholarship for artistic study, allowing him to travel to Italy and further his study in art. Upon his return to France, he was accepted into the Royal Academy of Painting and Sculpture, and three years later became a faculty member.','http://en.wikipedia.org/wiki/Fran%C3%A7ois_Boucher');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (108,'Jean-Baptiste-Simeon','Chardin','France','M',1699,1779,'Jean-Baptiste-Simeon Chardin was an 18th-century French painter. He is considered a master of still life, and is also noted for his genre paintings which depict kitchen maids, children, and domestic activities. Carefully balanced composition, soft diffusion of light, and granular impasto characterize his work.','http://en.wikipedia.org/wiki/Jean-Baptiste-Sim%C3%A9on_Chardin');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (109,'Joshua','Reynolds','England','M',1740,1790,'Sir Joshua Reynolds was an influential eighteenth-century English painter, specialising in portraits and promoting the \"Grand Style\" in painting which depended on idealization of the imperfect. He was one of the founders and first president of the Royal Academy, and was knighted by George III in 1769.','http://en.wikipedia.org/wiki/Joshua_Reynolds');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (110,'Thomas','Gainsborough','England','M',1737,1788,'Thomas Gainsborough was an English portrait and landscape painter. He is credited as the originator of the 18th century British landscape school.','http://en.wikipedia.org/wiki/Thomas_Gainsborough');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (111,'Artemisia','Gentileschi','Italy','F',1593,1656,'Artemisia Gentileschi was an Italian Baroque painter, today considered one of the most accomplished painters in the generation after Caravaggio. In an era when female painters were not easily accepted by the artistic community or patrons, she was the first female painter to become a member of the Accademia di Arte del Disegno in Florence. She painted many pictures of strong and suffering women from myth and the Bible -- victims, suicides, warriors -- and made a speciality of the Judith story.  That she was a woman painting in the 17th century and that she was raped herself and participated in prosecuting the rapist long overshadowed her achievements as an artist. For many years she was regarded as a curiosity. Today she is regarded as one of the most progressive and expressionist painters of her generation.','http://en.wikipedia.org/wiki/Artemisia_Gentileschi');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (112,'Judith','Leyster','Netherlands','F',1609,1660,'Judith Jans Leyster (also Leijster)was a Dutch Golden Age painter. She was one of three significant women artists in Dutch Golden Age painting; the other two, Rachel Ruysch and Maria van Oosterwijk, were specialized painters of flower still-lifes, while Leyster painted genre works, a few portraits, and a single still life. The number of surviving works attributed to her varies between fewer than 20 and about 35. She largely gave up painting after her marriage, which produced five children.','http://en.wikipedia.org/wiki/Judith_Leyster');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (113,'Elisabeth Louise','Lebrun','France','F',1755,1842,'Elisabeth Louise Vigee Le Brun also known as Madame Lebrun, was a French painter, and is recognized as the most important female painter of the 18th century. Her style is generally considered Rococo and shows interest in the subject of neoclassical painting. Vigee Le Brun cannot be considered a pure Neoclassist, however, in that she creates mostly portraits in Neoclassical dress.','http://en.wikipedia.org/wiki/Elisabeth_Vigee-Lebrun');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (114,NULL,'Giotto','Italy','M',1266,1337,'Giotto di Bondone better known simply as Giotto, was an Italian painter and architect from Florence in the late Middle Ages. He is generally considered the first in a line of great artists who contributed to the Italian Renaissance.','https://en.wikipedia.org/wiki/Giotto');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (115,'Jan','van Eyck','Belgium','M',1390,1441,'Jan van Eyck was a Flemish painter active in Bruges and is generally considered one of the most significant Northern European painters of the 15th century. The few surviving records indicate that he was born around 1390, most likely in Maaseik. Outside of works completed with his brother Hubert van Eyck, only about 23 surviving works are confidently attributed to him, of which ten, including the Ghent altarpiece, are signed and dated.','http://en.wikipedia.org/wiki/Jan_van_Eyck');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (116,'Albrecht','Dürer','Germany','M',1471,1528,'Albrecht Durer was a German painter, engraver, printmaker, mathematician, and theorist from Nuremberg. His high-quality woodcuts established his reputation and influence across Europe when he was still in his twenties, and he has been conventionally regarded as the greatest artist of the Northern Renaissance ever since. His vast body of work includes altarpieces and religious works, numerous portraits and self-portraits, and copper engravings. The woodcuts, such as the Apocalypse series (1498), retain a more Gothic flavour than the rest of his work. His well-known prints include the Knight, Death, and the Devil (1513), Saint Jerome in his Study (1514) and Melencolia I (1514), which has been the subject of extensive analysis and interpretation. His watercolours also mark him as one of the first European landscape artists, while his ambitious woodcuts revolutionized the potential of that medium. Dürer\'s introduction of classical motifs into Northern art, through his knowledge of Italian artists and German humanists, has secured his reputation as one of the most important figures of the Northern Renaissance. This is reinforced by his theoretical treatises, which involve principles of mathematics, perspective and ideal proportions.','http://en.wikipedia.org/wiki/Albrecht_D%C3%Bcrer');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (117,'Hieronymus','Bosch','Netherlands','M',1450,1516,'Hieronymus Bosch was an Early Netherlandish painter. His work is known for its use of fantastic imagery to illustrate moral and religious concepts and narratives.','http://en.wikipedia.org/wiki/Hieronymus_Bosch');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (118,'Pieter','Bruegel the Elder','Netherlands','M',1525,1569,'Pieter Bruegel (Brueghel) the Elder was a Flemish Renaissance painter and printmaker known for his landscapes and peasant scenes (so called genre painting). He is sometimes referred to as the \"Peasant Bruegel.\" From 1559 he dropped the \'h\' from his name and signed his paintings as Bruegel.','http://en.wikipedia.org/wiki/Pieter_Bruegel_the_Elder');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (120,'Agnolo','Bronzino','Italy','M',1503,1572,'One of the greatest painters of the sixteenth century, Agnolo di Cosimo Tori, known as Bronzino, embodied the Mannerist style in the years of the government of Cosimo I de Medici.','http://en.wikipedia.org/wiki/Bronzino');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (121,'El','Greco','Greece','M',1514,1614,'El Greco, born Domnikos Theotokopoulos,  was a painter, sculptor and architect of the Spanish Renaissance. \"El Greco\" (The Greek) was a nickname,a reference to his national Greek origin. El Greco\'s dramatic and expressionistic style was met with puzzlement by his contemporaries but found appreciation in the 20th century. El Greco is regarded as a precursor of both Expressionism and Cubism.','http://en.wikipedia.org/wiki/El_Greco');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (123,'Frans','Hals','Netherlands','M',1582,1666,'Frans Hals the Elder was a Dutch Golden Age portrait painter who lived and worked in Haarlem. He is notable for his loose painterly brushwork, and he helped introduce this lively style of painting into Dutch art. Hals played an important role in the evolution of 17th-century group portraiture.','https://en.wikipedia.org/wiki/Frans_Hals');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (124,'Jan','Steen','Netherlands','M',1626,1679,'Jan Havickszoon Steen was a Dutch genre painter of the 17th century (also known as the Dutch Golden Age). His works are known for their psychological insight, sense of humour and abundance of colour','https://en.wikipedia.org/wiki/Jan_Steen');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (125,'Jan','Kruseman','Netherlands','M',1804,1862,'Jan Adam Kruseman (1804-1862) of Haarlem was apprenticed to his uncle Cornelis Kruseman. He later studied at Brussels and Paris. In 1834-1836, he made a series of journeys to Germany, England and Scotland. For a while, he lived in Driebergen, before returning to Haarlem in 1858. Kruseman painted historical, biblical and genre scenes, although mainly portraits. In all he received around five hundred commissions from aristocrats and wealthy commoners for portraits.','https://en.wikipedia.org/wiki/Jan_Adam_Kruseman');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (126,'Pieter de','Hooch','Netherlands','M',1629,1684,'Pieter de Hooch was a Dutch Golden Age painter famous for his genre works of quiet domestic scenes with an open doorway. He was a contemporary of Jan Vermeer in the Delft Guild of St. Luke, with whom his work shares themes and style.','https://en.wikipedia.org/wiki/Pieter_de_Hooch');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (127,'Jacob van','Ruisdael','Netherlands','M',1628,1682,'The Haarlem-born painter Jacob van Ruisdael (ca. 1628-1682) began to paint at an early age. His first work dates from 1646. Ruisdael probably had lessons from his father, but his uncle, the artist Salomon van Ruysdael, must also have been a great influence on the young painter. As well as being a painter, Ruisdael was also a doctor. He painted not only woodland landscapes with strong, central motifs such as ruins, watermills and oaks, but also cityscapes and seascapes. Ruisdael\'s compositions are often more imposing than reality. His \'Bentheim Castle\' and \'Windmill at Wijk bij Duurstede\' are good examples of this.','https://en.wikipedia.org/wiki/Jacob_van_Ruisdael');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (128,'Anton','Mauve','Netherlands','M',1838,1888,'Anthonij (Anton) Rudolf Mauve was a Dutch realist painter who was a leading member of the Hague School. He signed his paintings \'A. Mauve\' or with a monogrammed \'A.M.\'. A master colorist, he was a very significant early influence on his cousin-in-law Vincent van Gogh. Most of Mauve\'s work depicts people and animals in outdoor settings. In his Morning Ride in the Rijksmuseum, for example, fashionable equestrians at the seacoast are seen riding away from the viewer. An unconventional detail, horse droppings in the foreground, attests his commitment to realism.','https://en.wikipedia.org/wiki/Anton_Mauve');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (129,'Lawrence','Alma-Tadema','Netherlands','M',1836,1912,'Sir Lawrence Alma-Tadema (born Lourens Alma Tadema) was a Dutch painter of special British denizenship. Born in Dronrijp, the Netherlands, and trained at the Royal Academy of Antwerp, Belgium, he settled in England in 1870 and spent the rest of his life there. A classical-subject painter, he became famous for his depictions of the luxury and decadence of the Roman Empire, with languorous figures set in fabulous marbled interiors or against a backdrop of dazzling blue Mediterranean Sea and sky. Though admired during his lifetime for his draftsmanship and depictions of Classical antiquity, his work fell into disrepute after his death, and only since the 1960s has it been re-evaluated for its importance within nineteenth-century English art.','https://en.wikipedia.org/wiki/Lawrence_Alma-Tadema');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (130,'Therese','Schwartze','Netherlands','F',1851,1918,'Thérèse Schwartze was born on 20 December 1851 in Amsterdam in the Netherlands. She was the daughter of the painter Johan Georg Schwartze, who grew up in Philadelphia and trained in Dusseldorf. Schwartze received her first training from her father, before studying for a year at the Rijksacademie van Beeldende Kunsten. She then travelled to Munich and studied under Gabriel Max and Franz von Lenbach. In 1879 she went to Paris to continue her studies under Jean-Jacques Henner. When she returned to Amsterdam she became a member of Arti et Amicitiae.','https://en.wikipedia.org/wiki/Th%C3%A9r%C3%A8se_Schwartze');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (131,NULL,'Canaletto','Italy','M',1697,1768,'Giovanni Antonio Canal, better known as Canaletto, was an Italian painter of landscapes of Venice. He was also an important printmaker in etching. He was the son of the painter Bernardo Canal, he visited England between 1746-56 and he is famous for his urban landscapes of Venice. He is very famous for his scenes, usually associated with \"evocative views of the city\".','https://en.wikipedia.org/wiki/Canaletto');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (132,'Nicolas','Poussin','France','M',1594,1665,'Nicolas Poussin was the leading painter of the classical French Baroque style, although he spent most of his working life in Rome. His work is characterized by clarity, logic, and order, and favors line over color. Until the 20th century he remained a major inspiration for such classically oriented artists as Jacques-Louis David, Jean-Auguste-Dominique Ingres and Paul Cezanne. He worked in Rome for a circle of leading collectors from there and elsewhere, except for a short period when Cardinal Richelieu ordered him back to France to serve as First Painter to the King. Most of his works are history paintings of religious or mythological subjects that very often have a large landscape element.','https://en.wikipedia.org/wiki/Nicolas_Poussin');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (133,'Ferdinand Georg','Waldmüller','Austria','M',1793,1865,'Ferdinand Georg Waldmüller (1793-1865) is considered the most important Austrian artist of the 19th century. On the one hand, he produced outstanding works in the artistic disciplines prevalent at the time (portraiture, landscape, still life, and genre painting) and, on the other hand, he was always, throughout his life, in search of accomplishment, striding new paths that led the way into the future.','https://en.wikipedia.org/wiki/Ferdinand_Georg_Waldm%C3%Bcller');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (134,'Rogier van der','Weyden','Netherlands','M',1399,1464,'Rogier van der Weyden or Roger de la Pasture was an Early Netherlandish painter. His surviving works consist mainly of religious triptychs, altarpieces and commissioned single and diptych portraits. Although his life was generally uneventful, he was highly successful and internationally famous in his lifetime. His paintings were exported (or taken) to Italy and Spain, and he received commissions from, amongst others, Philip the Good, Netherlandish nobility and foreign princes. By the latter half of the 15th century, he had eclipsed Jan van Eyck in popularity. However his fame lasted only until the 17th century, and largely due to changing taste, he was almost totally forgotten by the mid-18th century. His reputation was slowly rebuilt during the following 200 years; today he is known, with Robert Campin and van Eyck, as the third of the three great Early Flemish artists, and widely as the most influential Northern painter of the 15th century.','https://en.wikipedia.org/wiki/Rogier_van_der_Weyden');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (135,'Giovanni','Bellini','Italy','M',1430,1516,'Giovanni Bellini was an Italian Renaissance painter, probably the best known of the Bellini family of Venetian painters. His father was Jacopo Bellini, his brother was Gentile Bellini, and his brother-in-law was Andrea Mantegna. He is considered to have revolutionized Venetian painting, moving it towards a more sensuous and colouristic style. Through the use of clear, slow-drying oil paints, Giovanni created deep, rich tints and detailed shadings. His sumptuous coloring and fluent, atmospheric landscapes had a great effect on the Venetian painting school, especially on his pupils Giorgione and Titian.','https://en.wikipedia.org/wiki/Giovanni_Bellini');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (136,'Francesco','Hayez','Italy','M',1791,1882,'Francesco Hayez was an Italian painter, the leading artist of Romanticism in mid-19th-century Milan, renowned for his grand historical paintings, political allegories and exceptionally fine portraits.','https://en.wikipedia.org/wiki/Francesco_Hayez');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (137,'Caspar David','Friedrich','Germany','M',1774,1840,'Caspar David Friedrich was a 19th-century German Romantic landscape painter, generally considered the most important German artist of his generation. He is best known for his mid-period allegorical landscapes which typically feature contemplative figures silhouetted against night skies, morning mists, barren trees or Gothic ruins.','https://en.wikipedia.org/wiki/Caspar_David_Friedrich');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (138,'Arnold','Bocklin','Switzerland','M',1827,1901,'Arnold Böcklin was a Swiss symbolist painter.','https://en.wikipedia.org/wiki/Arnold_B%C3%B6cklin');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (139,'John William','Waterhouse','England','M',1849,1917,'John William Waterhouse was an English painter known for working in the Pre-Raphaelite style. He worked several decades after the breakup of the Pre-Raphaelite Brotherhood, which had seen its heyday in the mid-nineteenth century, leading to his sobriquet \"the modern Pre-Raphaelite\". Borrowing stylistic influences not only from the earlier Pre-Raphaelites but also from his contemporaries, the Impressionists, his artworks were known for their depictions of women from both ancient Greek mythology and Arthurian legend.','https://en.wikipedia.org/wiki/John_William_Waterhouse');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (140,'William','Bouguereau','France','M',1825,1905,'William-Adolphe Bouguereau was a French academic painter and traditionalist. In his realistic genre paintings he used mythological themes, making modern interpretations of classical subjects, with an emphasis on the female human body. During his life he enjoyed significant popularity in France and the United States, was given numerous official honors, and received top prices for his work. As the quintessential salon painter of his generation, he was reviled by the Impressionist avant-garde. By the early twentieth century, Bouguereau and his art fell out of favor with the public, due in part to changing tastes. In the 1980s, a revival of interest in figure painting led to a rediscovery of Bouguereau and his work. Throughout the course of his life, Bouguereau executed 822 known finished paintings, although the whereabouts of many are still unknown.','https://en.wikipedia.org/wiki/William-Adolphe_Bouguereau');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (141,'Agnolo','Gaddi','Italy','M',1350,1396,'Taddeo Gaddi was himself the major pupil of the Florentine master Giotto. Agnolo was an influential and prolific artist who was the last major Florentine painter stylistically descended from Giotto.','https://en.wikipedia.org/wiki/Agnolo_Gaddi');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (142,'Egon','Schiele','Austria','M',1890,1918,'Egon Schiele was an Austrian painter. A protégé of Gustav Klimt, Schiele was a major figurative painter of the early 20th century. His work is noted for its intensity and its raw sexuality, and the many self-portraits the artist produced, including naked self-portraits. The twisted body shapes and the expressive line that characterize Schiele\'s paintings and drawings mark the artist as an early exponent of Expressionism.','https://en.wikipedia.org/wiki/Egon_Schiele');
INSERT INTO `Artists` (`ArtistID`,`FirstName`,`LastName`,`Nationality`,`Gender`,`YearOfBirth`,`YearOfDeath`,`Details`,`ArtistLink`) VALUES (143,'Friedrich','Amerling','Austria','M',1803,1887,'Friedrich von Amerling was an Austro-Hungarian portrait painter in the court of Franz Josef. He was born in Vienna and was court painter between 1835 and 1880. With Ferdinand Georg Waldmüller he is one of the outstanding Austrian portrait painters of the 19th century.','https://en.wikipedia.org/wiki/Friedrich_von_Amerling');

# 80 records

#
# Table structure for table 'CustomerLogon'
#

DROP TABLE IF EXISTS `CustomerLogon`;

CREATE TABLE `CustomerLogon` (
  `CustomerID` INTEGER NOT NULL AUTO_INCREMENT, 
  `UserName` VARCHAR(255), 
  `Pass` VARCHAR(255), 
  `Salt` VARCHAR(255), 
  `Password_sha256` VARCHAR(100),
  `State` INTEGER, 
  `DateJoined` DATETIME, 
  `DateLastModified` DATETIME, 
  PRIMARY KEY (`CustomerID`), 
  UNIQUE (`UserName`)
) ENGINE=innodb DEFAULT CHARSET=utf8;

SET autocommit=1;

INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (1,'luisg@embraer.com.br','$2a$12$F.jpatdVlOnrYWLi/lxPNO90T0auUpFnDP5JTb3aTx7z1QSu5nX42','048d741e931f907110adf460816ff958', '1b7f054c4c6a92aeb1813ccf0b162cab31cdb9cad0a6cd3820a724f0819af20c',1,'2012-10-08 00:00:00','2018-11-15 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (2,'leonekohler@surfeu.de','$2a$12$o9lzPmLOFgpODyhYHUOXO.wojqkQph.fBZKO8k83hromrC0bC4TFi','9bce2f838034b8c8d2ba1220daef2e7e', 'b3efa8c9c09f76778fdd7f70b340c69a03d48861d2424bb5f4f4cd0d7ce11c06',1,'2012-08-22 00:00:00','2018-10-15 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (3,'ftremblay@gmail.com','$2a$12$QYTq9bIvZ/asycZCoh.GAOhsycshCzvEahXvXRrCczdqnGFdZ0XVS','c3a10800118c3bc6c50b1ac82d31e4a6', 'b8e62ee19ebbc23976b21e0820723405e27de1d4f2fd24e4e1f456c129cee82c',1,'2012-10-28 00:00:00','2018-11-16 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (4,'bjorn.hansen@yahoo.no','$2a$12$43FcE3LDDWlev12JkV4qae45LouL6pbXz/GeE4vSNT56OU1tAzdW2','d24e7731e8051cf253ca8e89e0dd0be9', 'e7a6803fc7d3db79780e300167aa8d05efebcffe5dba3a760f4f8eafe84a1af6',1,'2012-07-31 00:00:00','2018-08-14 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (5,'frantisekw@jetbrains.com','$2a$12$FbS.fUfQT9Aq9D8REtRx5udl4wKwxKwSuhgEe1Ef0EPcGDZoB8GCS','b3f2be95228f481bc544154fa77b56c6', 'c7c097bac3f74fb336965b98de2aa84afa6bae00651761be7277bc464869efce',1,'2012-08-06 00:00:00','2018-09-25 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (6,'hholy@gmail.com','$2a$12$TnZVOMj5H27JLk/IHtEsD.1cVrSuvToa9dAyM8QbENRXP74MVT5cm','231e1ed0db2b5dc8193ac7c78071aea4', '62f5f09daf08a97ef8471d76ebf625bdaab121451bfd062d5a138bf04e30f8a1',1,'2012-11-01 00:00:00','2018-12-14 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (7,'astrid.gruber@apple.at','$2a$12$VWASiGnTzmFyqnv1j/WkaO5ihBDsQ/swN9ZkrooGkzxweGV/uft8K','7f9301cbee13b0afb7e7c79aa65c9483', 'ee3f23dcb0a13743fc84384ab46244b03ede2ee1bc56f6c77af906140fc78f94',1,'2012-06-05 00:00:00','2019-01-10 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (8,'fharris@google.com','$2a$12$R1vJzRYOg/SIW1yNyWEjCugGbBIC58fmxjjd.0ck1W6iWvrSBKGh6','1fc0e8b9a5704994608c34a189228f51', 'fb78347933ba30fd2ac53bd1d98581bbd612721f2ca177e87913c5a7773e6e40',1,'2012-09-25 00:00:00','2019-11-18 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (9,'jacksmith@microsoft.com','$2a$12$mWaauD2uy2oWG/9TO7nGvOSMZf44334WBjXJjOIzR9s66ziS3KuSq','1fc0e8b9a5704994608c34a189228f51', 'fb78347933ba30fd2ac53bd1d98581bbd612721f2ca177e87913c5a7773e6e40',1,'2012-11-16 00:00:00','2019-01-18 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (10,'michelleb@aol.com','$2a$12$Wb8L5KpmiYMDkh5dbPFM1OsyJMRhvZ0ZuidyOiudB9OX7qy6T/.I6','23a56dcf9c599bf803f2b7abf1db4b79', 'c46a4d121688f1fe18d23d35af64a74325255a4dbea07f6b18640ca055c54b68',1,'2012-12-07 00:00:00','2019-03-07 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (11,'tgoyer@apple.com','$2y$12$mgw9OzdYyB2zIXYGptdiHef7022jL.VLk.37oAodHyYA2Qd1nll4G','ea9f13c97a277bb3917b63a2a1234b39', '746848aba0c93093bbba9dd75f41e687f1651b5888d06c10a21b65d80005e1ee',1,'2013-01-14 00:00:00','2019-04-19 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (12,'robbrown@shaw.ca','$2y$12$gdd2LeAoUr0hzE43MhCeJuOSOLoEB/o0G.tUYjr65cNUUCTbnM2Xe','23a56dcf9c599bf803f2b7abf1db4b79', 'c46a4d121688f1fe18d23d35af64a74325255a4dbea07f6b18640ca055c54b68',1,'2013-02-07 00:00:00','2019-06-11 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (13,'edfrancis@yachoo.ca','$2y$12$ZrtstCZGgKBbbC7kSFrQHOacz3blMEXQgTfpwv4GQyKG5pOSOsN/i','1fc0e8b9a5704994608c34a189228f51', 'fb78347933ba30fd2ac53bd1d98581bbd612721f2ca177e87913c5a7773e6e40',1,'2012-12-20 00:00:00','2019-01-11 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (14,'mphilips12@shaw.ca','$2a$12$F.jpatdVlOnrYWLi/lxPNO90T0auUpFnDP5JTb3aTx7z1QSu5nX42','7f9301cbee13b0afb7e7c79aa65c9483', 'ee3f23dcb0a13743fc84384ab46244b03ede2ee1bc56f6c77af906140fc78f94',1,'2012-05-21 00:00:00','2018-10-28 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (15,'marthasilk@gmail.com','$2y$12$uOsOiU5EUrsHxDlQuGSh9em/Dd8Sub9FDCPcshfdYdlGthwZUi9FW','231e1ed0db2b5dc8193ac7c78071aea4', '62f5f09daf08a97ef8471d76ebf625bdaab121451bfd062d5a138bf04e30f8a1',1,'2012-11-17 00:00:00','2018-12-01 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (16,'aaronmitchell@yahoo.ca','$2y$12$xpmpbRqGQx4Oc0DWl6i27egN/hBRkIEA6sYQo4zbKLXyGJRNY6voO','b3f2be95228f481bc544154fa77b56c6', 'c7c097bac3f74fb336965b98de2aa84afa6bae00651761be7277bc464869efce',1,'2013-02-12 00:00:00','2019-03-21 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (17,'ellie.sullivan@shaw.ca','$2a$12$o9lzPmLOFgpODyhYHUOXO.wojqkQph.fBZKO8k83hromrC0bC4TFi','d24e7731e8051cf253ca8e89e0dd0be9', 'e7a6803fc7d3db79780e300167aa8d05efebcffe5dba3a760f4f8eafe84a1af6',1,'2012-09-10 00:00:00','2018-11-05 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (18,'jfernandes@yahoo.pt','$2a$12$FbS.fUfQT9Aq9D8REtRx5udl4wKwxKwSuhgEe1Ef0EPcGDZoB8GCS','9bce2f838034b8c8d2ba1220daef2e7e', 'b3efa8c9c09f76778fdd7f70b340c69a03d48861d2424bb5f4f4cd0d7ce11c06',1,'2012-08-27 00:00:00','2018-09-03 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (19,'masampaio@sapo.pt','$2a$12$Wb8L5KpmiYMDkh5dbPFM1OsyJMRhvZ0ZuidyOiudB9OX7qy6T/.I6','048d741e931f907110adf460816ff958', '1b7f054c4c6a92aeb1813ccf0b162cab31cdb9cad0a6cd3820a724f0819af20c',1,'2012-07-29 00:00:00','2018-12-10 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (20,'hannah.schneider@yahoo.de','$2y$12$qzh6jvFIvGSKtSpr4SOBcuPgZ0N/zRfwTq594pV2oz59JQwGBEakW','c3a10800118c3bc6c50b1ac82d31e4a6', 'b8e62ee19ebbc23976b21e0820723405e27de1d4f2fd24e4e1f456c129cee82c',1,'2012-08-01 00:00:00','2018-11-02 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (21,'camille.bernard@yahoo.fr','$2a$12$o9lzPmLOFgpODyhYHUOXO.wojqkQph.fBZKO8k83hromrC0bC4TFi','ea9f13c97a277bb3917b63a2a1234b39', '746848aba0c93093bbba9dd75f41e687f1651b5888d06c10a21b65d80005e1ee',1,'2012-10-29 00:00:00','2018-12-07 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (22,'isabelle_mercier@apple.fr','$2a$12$F.jpatdVlOnrYWLi/lxPNO90T0auUpFnDP5JTb3aTx7z1QSu5nX42','ea9f13c97a277bb3917b63a2a1234b39', '746848aba0c93093bbba9dd75f41e687f1651b5888d06c10a21b65d80005e1ee',1,'2012-11-12 00:00:00','2019-01-21 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (23,'emma_jones@hotmail.com','$2y$12$uOsOiU5EUrsHxDlQuGSh9em/Dd8Sub9FDCPcshfdYdlGthwZUi9FW','23a56dcf9c599bf803f2b7abf1db4b79', 'c46a4d121688f1fe18d23d35af64a74325255a4dbea07f6b18640ca055c54b68',1,'2013-05-14 00:00:00','2019-05-14 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (24,'phil.hughes@gmail.com','$2y$12$ZhfTqJ3svu5zPT3/rxJko.fsw1Pt1mLyrMlQh5Wv.6AqE9bvWDxbm','1fc0e8b9a5704994608c34a189228f51', 'fb78347933ba30fd2ac53bd1d98581bbd612721f2ca177e87913c5a7773e6e40',1,'2013-05-24 00:00:00','2019-05-24 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (25,'manoj.pareek@rediff.com','$2a$12$TnZVOMj5H27JLk/IHtEsD.1cVrSuvToa9dAyM8QbENRXP74MVT5cm','231e1ed0db2b5dc8193ac7c78071aea4', '62f5f09daf08a97ef8471d76ebf625bdaab121451bfd062d5a138bf04e30f8a1',1,'2013-05-07 00:00:00','2019-05-07 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (26,'puja_srivastava@yahoo.in','$2y$12$DnFhcTPWRs7maY.hr4ATVuJJ5fqbJL18JE7CceHQizLAchXEXcAPu','b3f2be95228f481bc544154fa77b56c6', 'c7c097bac3f74fb336965b98de2aa84afa6bae00651761be7277bc464869efce',1,'2013-06-01 00:00:00','2019-06-01 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (27,'mark.taylor@yahoo.au','$2y$12$l8QIBkyp/7mEYl.983P5l..H9DNsCY.LES4aBAYptS.UTJ5IqbHSK','d24e7731e8051cf253ca8e89e0dd0be9', 'e7a6803fc7d3db79780e300167aa8d05efebcffe5dba3a760f4f8eafe84a1af6',1,'2013-05-17 00:00:00','2019-05-17 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (28,'ricunningham@hotmail.com','$2y$12$lYIaYSjt3KqiZNSrTENGOushxHk9B1yMLkzK.N25bfF3C3h2lS7He','9bce2f838034b8c8d2ba1220daef2e7e', 'b3efa8c9c09f76778fdd7f70b340c69a03d48861d2424bb5f4f4cd0d7ce11c06',1,'2013-05-21 00:00:00','2019-05-21 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (29,'patrick.gray@aol.com','$2a$12$mWaauD2uy2oWG/9TO7nGvOSMZf44334WBjXJjOIzR9s66ziS3KuSq','048d741e931f907110adf460816ff958', '1b7f054c4c6a92aeb1813ccf0b162cab31cdb9cad0a6cd3820a724f0819af20c',1,'2013-05-27 00:00:00','2019-05-27 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (30,'terhi.hamalainen@apple.fi','$2a$12$F.jpatdVlOnrYWLi/lxPNO90T0auUpFnDP5JTb3aTx7z1QSu5nX42','c3a10800118c3bc6c50b1ac82d31e4a6', 'b8e62ee19ebbc23976b21e0820723405e27de1d4f2fd24e4e1f456c129cee82c',1,'2013-05-24 00:00:00','2019-05-26 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (31,'stanisław.wójcik@wp.pl','$2y$12$uOsOiU5EUrsHxDlQuGSh9em/Dd8Sub9FDCPcshfdYdlGthwZUi9FW','7f9301cbee13b0afb7e7c79aa65c9483', 'ee3f23dcb0a13743fc84384ab46244b03ede2ee1bc56f6c77af906140fc78f94',1,'2013-05-25 00:00:00','2019-06-25 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (32,'nschroder@surfeu.de','$2a$12$mWaauD2uy2oWG/9TO7nGvOSMZf44334WBjXJjOIzR9s66ziS3KuSq','ea9f13c97a277bb3917b63a2a1234b39', '746848aba0c93093bbba9dd75f41e687f1651b5888d06c10a21b65d80005e1ee',1,'2013-07-01 00:00:00','2019-07-01 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (33,'dominiquelefebvre@gmail.com','$2y$12$vZXsba.JjWdVZapfMrMYY.yPZSy/.3TXTbUu0V1DLsa4wh4NRS9aC','ea9f13c97a277bb3917b63a2a1234b39', '746848aba0c93093bbba9dd75f41e687f1651b5888d06c10a21b65d80005e1ee',1,'2013-07-01 00:00:00','2019-07-01 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (34,'diego.gutierrez@yahoo.ar','$2y$12$N1U1bMrtI9APjQakQ6LoQOjWzc8Zend78QusCDGjY3EMJItw4bUSe','23a56dcf9c599bf803f2b7abf1db4b79', 'c46a4d121688f1fe18d23d35af64a74325255a4dbea07f6b18640ca055c54b68',1,'2013-07-05 00:00:00','2019-07-05 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (35,'ladislav_kovacs@apple.hu','$2y$12$l8QIBkyp/7mEYl.983P5l..H9DNsCY.LES4aBAYptS.UTJ5IqbHSK','231e1ed0db2b5dc8193ac7c78071aea4', '62f5f09daf08a97ef8471d76ebf625bdaab121451bfd062d5a138bf04e30f8a1',1,'2013-07-06 00:00:00','2019-07-08 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (36,'lucas.mancini@yahoo.it','$2y$12$lYIaYSjt3KqiZNSrTENGOushxHk9B1yMLkzK.N25bfF3C3h2lS7He','d24e7731e8051cf253ca8e89e0dd0be9', 'e7a6803fc7d3db79780e300167aa8d05efebcffe5dba3a760f4f8eafe84a1af6',1,'2013-07-11 00:00:00','2019-07-11 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (37,'johavanderberg@yahoo.nl','$2y$12$DnFhcTPWRs7maY.hr4ATVuJJ5fqbJL18JE7CceHQizLAchXEXcAPu','9bce2f838034b8c8d2ba1220daef2e7e', 'b3efa8c9c09f76778fdd7f70b340c69a03d48861d2424bb5f4f4cd0d7ce11c06',1,'2013-07-13 00:00:00','2019-07-13 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (38,'enrique_munoz@yahoo.es','$2a$12$VWASiGnTzmFyqnv1j/WkaO5ihBDsQ/swN9ZkrooGkzxweGV/uft8K','048d741e931f907110adf460816ff958', '1b7f054c4c6a92aeb1813ccf0b162cab31cdb9cad0a6cd3820a724f0819af20c',1,'2013-07-13 00:00:00','2019-07-13 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (39,'joakim.johansson@yahoo.se','2a$12$Wb8L5KpmiYMDkh5dbPFM1OsyJMRhvZ0ZuidyOiudB9OX7qy6T/.I6','c3a10800118c3bc6c50b1ac82d31e4a6', 'b8e62ee19ebbc23976b21e0820723405e27de1d4f2fd24e4e1f456c129cee82c',1,'2013-07-15 00:00:00','2019-07-15 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (40,'jubarnett@gmail.com','$2a$12$VWASiGnTzmFyqnv1j/WkaO5ihBDsQ/swN9ZkrooGkzxweGV/uft8K','7f9301cbee13b0afb7e7c79aa65c9483', 'ee3f23dcb0a13743fc84384ab46244b03ede2ee1bc56f6c77af906140fc78f94',1,'2013-07-16 00:00:00','2019-07-16 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (41,'fralston@gmail.com','$2y$12$ZhfTqJ3svu5zPT3/rxJko.fsw1Pt1mLyrMlQh5Wv.6AqE9bvWDxbm','ea9f13c97a277bb3917b63a2a1234b39', '746848aba0c93093bbba9dd75f41e687f1651b5888d06c10a21b65d80005e1ee',1,'2013-07-17 00:00:00','2019-07-17 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (42,'johngordon22@yahoo.com','$2y$12$N1U1bMrtI9APjQakQ6LoQOjWzc8Zend78QusCDGjY3EMJItw4bUSe','23a56dcf9c599bf803f2b7abf1db4b79', 'c46a4d121688f1fe18d23d35af64a74325255a4dbea07f6b18640ca055c54b68',1,'2013-07-17 00:00:00','2019-07-17 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (43,'hleacock@gmail.com','$2y$12$lYIaYSjt3KqiZNSrTENGOushxHk9B1yMLkzK.N25bfF3C3h2lS7He','1fc0e8b9a5704994608c34a189228f51', 'fb78347933ba30fd2ac53bd1d98581bbd612721f2ca177e87913c5a7773e6e40',1,'2013-07-17 00:00:00','2019-07-17 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (48,'jenniferp@rogers.ca','$2y$12$DnFhcTPWRs7maY.hr4ATVuJJ5fqbJL18JE7CceHQizLAchXEXcAPu','7f9301cbee13b0afb7e7c79aa65c9483', 'ee3f23dcb0a13743fc84384ab46244b03ede2ee1bc56f6c77af906140fc78f94',1,'2013-07-18 00:00:00','2019-07-18 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (49,'michael@chinookcorp.com','$2a$12$TnZVOMj5H27JLk/IHtEsD.1cVrSuvToa9dAyM8QbENRXP74MVT5cm','231e1ed0db2b5dc8193ac7c78071aea4', '62f5f09daf08a97ef8471d76ebf625bdaab121451bfd062d5a138bf04e30f8a1',1,'2013-07-18 00:00:00','2019-07-18 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (50,'steve@chinookcorp.com','$2y$12$l8QIBkyp/7mEYl.983P5l..H9DNsCY.LES4aBAYptS.UTJ5IqbHSK','b3f2be95228f481bc544154fa77b56c6', 'c7c097bac3f74fb336965b98de2aa84afa6bae00651761be7277bc464869efce',1,'2013-07-19 00:00:00','2019-07-20 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (51,'kara.nielsen@jubii.dk','$2y$12$vZXsba.JjWdVZapfMrMYY.yPZSy/.3TXTbUu0V1DLsa4wh4NRS9aC','d24e7731e8051cf253ca8e89e0dd0be9', 'e7a6803fc7d3db79780e300167aa8d05efebcffe5dba3a760f4f8eafe84a1af6',1,'2013-08-22 00:00:00','2019-08-22 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (52,'kachase@hotmail.com','$2a$12$FbS.fUfQT9Aq9D8REtRx5udl4wKwxKwSuhgEe1Ef0EPcGDZoB8GCS','c3a10800118c3bc6c50b1ac82d31e4a6', 'b8e62ee19ebbc23976b21e0820723405e27de1d4f2fd24e4e1f456c129cee82c',1,'2013-08-23 00:00:00','2019-08-23 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (53,'hughoreilly@apple.ie','$2a$12$FbS.fUfQT9Aq9D8REtRx5udl4wKwxKwSuhgEe1Ef0EPcGDZoB8GCS','9bce2f838034b8c8d2ba1220daef2e7e', 'b3efa8c9c09f76778fdd7f70b340c69a03d48861d2424bb5f4f4cd0d7ce11c06',1,'2013-08-26 00:00:00','2019-08-26 00:00:00');
INSERT INTO `CustomerLogon` (`CustomerID`,`UserName`,`Pass`,`Salt`,`Password_sha256`,`State`,`DateJoined`,`DateLastModified`) VALUES (54,'luisrojas@yahoo.cl','$2y$12$ZhfTqJ3svu5zPT3/rxJko.fsw1Pt1mLyrMlQh5Wv.6AqE9bvWDxbm','048d741e931f907110adf460816ff958', '1b7f054c4c6a92aeb1813ccf0b162cab31cdb9cad0a6cd3820a724f0819af20c',1,'2013-08-27 00:00:00','2019-08-27 00:00:00');

# 50 records

#
# Table structure for table 'Customers'
#

DROP TABLE IF EXISTS `Customers`;

CREATE TABLE `Customers` (
  `CustomerID` INTEGER NOT NULL AUTO_INCREMENT, 
  `FirstName` VARCHAR(255), 
  `LastName` VARCHAR(255), 
  `Address` VARCHAR(255), 
  `City` VARCHAR(255), 
  `Region` VARCHAR(255), 
  `Country` VARCHAR(255), 
  `Postal` VARCHAR(255), 
  `Phone` VARCHAR(255), 
  `Email` VARCHAR(255), 
  `Privacy` VARCHAR(255), 
  PRIMARY KEY (`CustomerID`)
) ENGINE=innodb DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'Customers'
#

INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (1, 'Luís', 'Gonçalves', 'Av. Brigadeiro Faria Lima, 2170', 'São José dos Campos', 'SP', 'Brazil', '12227-000', '+55 (12) 3923-5555', 'luisg@embraer.com.br', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (2, 'Leonie', 'Köhler', 'Theodor-Heuss-Straße 34', 'Stuttgart', NULL, 'Germany', '70174', '+49 0711 2842222', 'leonekohler@surfeu.de', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (3, 'Bjørn', 'Hansen', 'Ullevålsveien 14', 'Oslo', NULL, 'Norway', '0171', '+47 22 44 22 22', 'bjorn.hansen@yahoo.no', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (4, 'François', 'Tremblay', '1498 rue Bélanger', 'Montréal', 'QC', 'Canada', 'H2G 1A7', '+1 (514) 721-4711', 'ftremblay@gmail.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (5, 'František', 'Wichterlová', 'Klanova 9/506', 'Prague', NULL, 'Czech Republic', '14700', '+420 2 4172 5555', 'frantisekw@jetbrains.com', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (6, 'Helena', 'Holý', 'Rilská 3174/6', 'Prague', NULL, 'Czech Republic', '14300', '+420 2 4177 0449', 'hholy@gmail.com', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (7, 'Astrid', 'Gruber', 'Rotenturmstraße 4, 1010 Innere Stadt', 'Vienna', NULL, 'Austria', '1010', '+43 01 5134505', 'astrid.gruber@apple.at', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (8, 'Frank', 'Harris', '1600 Amphitheatre Parkway', 'Mountain View', 'CA', 'USA', '94043-1351', '+1 (425) 882-8080', 'fharris@google.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (9, 'Jack', 'Smith', '1 Microsoft Way', 'Redmond', 'WA', 'USA', '98052-8300', '+1 (425) 882-8080', 'jacksmith@microsoft.com', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (10, 'Michelle', 'Brooks', '627 Broadway', 'New York', 'NY', 'USA', '10012-2612', '+1 (212) 221-3546', 'michelleb@aol.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (11, 'Tim', 'Goyer', '1 Infinite Loop', 'Cupertino', 'CA', 'USA', '95014', '+1 (408) 996-1010', 'tgoyer@apple.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (12, 'Robert', 'Brown', '796 Dundas Street West', 'Toronto', 'ON', 'Canada', 'M6J 1V1', '+1 (416) 363-8888', 'robbrown@shaw.ca', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (13, 'Edward', 'Francis', '230 Elgin Street', 'Ottawa', 'ON', 'Canada', 'K2P 1L7', '+1 (613) 234-3322', 'edfrancis@yachoo.ca', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (14, 'Mark', 'Philips', '8210 111 ST NW', 'Edmonto', 'AB', 'Canada', 'T6G 2C7', '+1 (780) 434-4554', 'mphilips12@shaw.ca', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (15, 'Martha', 'Silk', '194A Chain Lake Drive', 'Halifax', 'NS', 'Canada', 'B3S 1C5', '+1 (902) 450-0450', 'marthasilk@gmail.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (16, 'Aaron', 'Mitchell', '696 Osborne Street', 'Winnipeg', 'MB', 'Canada', 'R3L 2B9', '+1 (204) 452-6452', 'aaronmitchell@yahoo.ca', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (17, 'Ellie', 'Sullivan', '5112 48 Street', 'Yellowknife', 'NT', 'Canada', 'X1A 1N6', '+1 (867) 920-2233', 'ellie.sullivan@shaw.ca', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (18, 'João', 'Fernandes', 'Rua da Assunção 53', 'Lisbon', NULL, 'Portugal', NULL, '+351 (213) 466-111', 'jfernandes@yahoo.pt', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (19, 'Madalena', 'Sampaio', 'Rua dos Campeões Europeus de Viena, 4350', 'Porto', NULL, 'Portugal', NULL, '+351 (225) 022-448', 'masampaio@sapo.pt', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (20, 'Hannah', 'Schneider', 'Tauentzienstraße 8', 'Berlin', NULL, 'Germany', '10789', '+49 030 26550280', 'hannah.schneider@yahoo.de', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (21, 'Camille', 'Bernard', '4, Rue Milton', 'Paris', NULL, 'France', '75009', '+33 01 49 70 65 65', 'camille.bernard@yahoo.fr', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (22, 'Isabelle', 'Mercier', '68, Rue Jouvence', 'Dijon', NULL, 'France', '21000', '+33 03 80 73 66 99', 'isabelle_mercier@apple.fr', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (23, 'Emma', 'Jones', '202 Hoxton Street', 'London', NULL, 'United Kingdom', 'N1 5LH', '+44 020 7707 0707', 'emma_jones@hotmail.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (24, 'Phil', 'Hughes', '113 Lupus St', 'London', NULL, 'United Kingdom', 'SW1V 3EN', '+44 020 7976 5722', 'phil.hughes@gmail.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (25, 'Manoj', 'Pareek', '12,Community Centre', 'Delhi', NULL, 'India', '110017', '+91 0124 39883988', 'manoj.pareek@rediff.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (26, 'Puja', 'Srivastava', '3,Raj Bhavan Road', 'Bangalore', NULL, 'India', '560001', '+91 080 22289999', 'puja_srivastava@yahoo.in', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (27, 'Mark', 'Taylor', '421 Bourke Street', 'Sidney', 'NSW', 'Australia', '2010', '+61 (02) 9332 3633', 'mark.taylor@yahoo.au', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (28, 'Richard', 'Cunningham', '2211 W Berry Street', 'Fort Worth', 'TX', 'USA', '76110', '+1 (817) 924-7272', 'ricunningham@hotmail.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (29, 'Patrick', 'Gray', '1033 N Park Ave', 'Tucson', 'AZ', 'USA', '85719', '+1 (520) 622-4200', 'patrick.gray@aol.com', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (30, 'Terhi', 'Hämäläinen', 'Porthaninkatu 9', 'Helsinki', NULL, 'Finland', '00530', '+358 09 870 2000', 'terhi.hamalainen@apple.fi', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (31, 'Stanisław', 'Wójcik', 'Ordynacka 10', 'Warsaw', NULL, 'Poland', '00-358', '+48 22 828 37 39', 'stanisław.wójcik@wp.pl', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (32, 'Niklas', 'Schröder', 'Barbarossastraße 19', 'Berlin', NULL, 'Germany', '10779', '+49 030 2141444', 'nschroder@surfeu.de', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (33, 'Dominique', 'Lefebvre', '8, Rue Hanovre', 'Paris', NULL, 'France', '75002', '+33 01 47 42 71 71', 'dominiquelefebvre@gmail.com', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (34, 'Diego', 'Gutiérrez', '307 Macacha Güemes', 'Buenos Aires', NULL, 'Argentina', '1106', '+54 (0)11 4311 4333', 'diego.gutierrez@yahoo.ar', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (35, 'Ladislav', 'Kovács', 'Erzsébet krt. 58.', 'Budapest', NULL, 'Hungary', 'H-1073', NULL, 'ladislav_kovacs@apple.hu', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (36, 'Lucas', 'Mancini', 'Via Degli Scipioni, 43', 'Rome', 'RM', 'Italy', '00192', '+39 06 39733434', 'lucas.mancini@yahoo.it', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (37, 'Johannes', 'Van der Berg', 'Lijnbaansgracht 120bg', 'Amsterdam', 'VV', 'Netherlands', '1016', '+31 020 6223130', 'johavanderberg@yahoo.nl', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (38, 'Enrique', 'Muñoz', 'C/ San Bernardo 85', 'Madrid', NULL, 'Spain', '28015', '+34 914 454 454', 'enrique_munoz@yahoo.es', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (39, 'Joakim', 'Johansson', 'Celsiusg. 9', 'Stockholm', NULL, 'Sweden', '11230', '+46 08-651 52 52', 'joakim.johansson@yahoo.se', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (40, 'Julia', 'Barnett', '302 S 700 E', 'Salt Lake City', 'UT', 'USA', '84102', '+1 (801) 531-7272', 'jubarnett@gmail.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (41, 'Frank', 'Ralston', '162 E Superior Street', 'Chicago', 'IL', 'USA', '60611', '+1 (312) 332-3232', 'fralston@gmail.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (42, 'John', 'Gordon', '69 Salem Street', 'Boston', 'MA', 'USA', '2113', '+1 (617) 522-1333', 'johngordon22@yahoo.com', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (43, 'Heather', 'Leacock', '120 S Orange Ave', 'Orlando', 'FL', 'USA', '32801', '+1 (407) 999-7788', 'hleacock@gmail.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (48, 'Jennifer', 'Peterson', '700 W Pender Street', 'Vancouver', 'BC', 'Canada', 'V6C 1G8', '+1 (604) 688-2255', 'jenniferp@rogers.ca', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (49, 'Michael', 'Mitchell', '5827 Bowness Road NW', 'Calgary', 'AB', 'Canada', 'T3B 0C5', '+1 (403) 246-9887', 'michael@chinookcorp.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (50, 'Steve', 'Johnson', '7727B 41 Ave SW', 'Calgary', 'AB', 'Canada', 'T3B 1Y7', '+1 (780) 836-9987', 'steve@chinookcorp.com', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (51, 'Kara', 'Nielsen', 'Sønder Boulevard 51', 'Copenhagen', NULL, 'Denmark', '1720', '+453 3331 9991', 'kara.nielsen@jubii.dk', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (52, 'Kathy', 'Chase', '801 W 4th Street', 'Reno', 'NV', 'USA', '89503', '+1 (775) 223-7665', 'kachase@hotmail.com', '2');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (53, 'Hugh', 'O\'Reilly', '3 Chatham Street', 'Dublin', NULL, 'Ireland', NULL, '+353 01 6792424', 'hughoreilly@apple.ie', '1');
INSERT INTO `Customers` (`CustomerID`, `FirstName`, `LastName`, `Address`, `City`, `Region`, `Country`, `Postal`, `Phone`, `Email`, `Privacy`) VALUES (54, 'Luis', 'Rojas', 'Calle Lira, 198', 'Santiago', NULL, 'Chile', NULL, '+56 (0)2 635 4444', 'luisrojas@yahoo.cl', '2');
# 50 records

#
# Table structure for table 'Eras'
#

DROP TABLE IF EXISTS `Eras`;

CREATE TABLE `Eras` (
  `EraID` INTEGER NOT NULL AUTO_INCREMENT, 
  `EraName` VARCHAR(255), 
  `EraYears` VARCHAR(255), 
  INDEX (`EraID`), 
  PRIMARY KEY (`EraID`)
) ENGINE=innodb DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'Eras'
#

INSERT INTO `Eras` (`EraID`, `EraName`, `EraYears`) VALUES (1, 'Medieval', 'Before 1400');
INSERT INTO `Eras` (`EraID`, `EraName`, `EraYears`) VALUES (2, 'Renaissance', '1400-1550');
INSERT INTO `Eras` (`EraID`, `EraName`, `EraYears`) VALUES (3, 'Post Renaissance', '1550-1700');
INSERT INTO `Eras` (`EraID`, `EraName`, `EraYears`) VALUES (4, 'Early Modern', '1700-1875');
INSERT INTO `Eras` (`EraID`, `EraName`, `EraYears`) VALUES (5, 'Modern', '1875-1945');
INSERT INTO `Eras` (`EraID`, `EraName`, `EraYears`) VALUES (6, 'Contemporary', 'After 1945');
# 6 records

#
# Table structure for table 'Galleries'
#

DROP TABLE IF EXISTS `Galleries`;

CREATE TABLE `Galleries` (
  `GalleryID` INTEGER NOT NULL AUTO_INCREMENT, 
  `GalleryName` VARCHAR(255), 
  `GalleryNativeName` VARCHAR(255), 
  `GalleryCity` VARCHAR(255), 
  `GalleryAddress` VARCHAR(255), 
  `GalleryCountry` VARCHAR(255), 
  `Latitude` DOUBLE NULL, 
  `Longitude` DOUBLE NULL, 
  `GalleryWebSite` VARCHAR(255), 
  `FlickrPlaceID` VARCHAR(255), 
  `YahooWoeID` VARCHAR(255), 
  `GooglePlaceID` VARCHAR(255), 
  INDEX (`GalleryID`), 
  INDEX (`GooglePlaceID`), 
  INDEX (`FlickrPlaceID`), 
  PRIMARY KEY (`GalleryID`), 
  INDEX (`YahooWoeID`)
) ENGINE=innodb DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Populating data for table 'Galleries'
#
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (2,'Prado Museum','Museo del Prado','Madrid','Paseo del Prado, s/n, 28014','Spain',40.413393,-3.691953,'http://www.museodelprado.es/','XrSazRhTUrh4j1shyQ','20219885','ChIJ7aLYZp0oQg0RWoitk33wlBA');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (3,'State Museum','Staatliche Museen','Berlin','Genthiner Str. 38 D','Germany',52.50861,13.36472,'http://www.smb.museum/','VULyzjBXVb89VXc','675695','ChIJ6c-eGLRRqEcR_S0RGNMMbWw');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (4,'Uffizi Museum','Galleria degli Uffizi','Florence','Piazzale degli Uffizi, 6, 50122','Italy',43.76863888,11.25521,'http://www.polomuseale.firenze.it/en/musei/?m=uffizi','GKD_20BTUrvaoc1jyA','20150278','ChIJgZDFjQBUKhMRzcTwm8i33s0');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (5,'National Gallery','National Gallery','London','Trafalgar Square','UK',51.5086,-0.1283,'http://www.nationalgallery.org.uk/','1EPGyGtTUrrDXJmGCA','20094364','ChIJeclqF84EdkgRtKAjTmWFr0I');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (6,'Metropolitan Museum of Art','Metropolitan Museum of Art','New York City','1000 5th Ave','USA',40.7794472,-73.963111,'http://www.metmuseum.org','zzA0hmBTUb9GY797pA','23511893','ChIJb8Jg9pZYwokR-qHGtvSkLzs');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (7,'National Gallery of Art','National Gallery of Art','Washington, DC','6th & Constitution Ave NW','USA',38.89147,-77.02001,'http://www.nga.gov/content/ngaweb.html','i0jd9gJTWr3c.68Wbg','28751392','ChIJSYxSO5u3t4kRm4eyKw_Y7Kg');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (11,'The Art Institute of Chicago','The Art Institute of Chicago','Chicago','111 S Michigan Ave','USA',41.8794444,-87.62388,'http://www.artic.edu/','S7hSKqFTVr6exT4J','2441891','ChIJlUbZ4qMsDogR3tCinMzzKUg');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (13,'Philadelphia Museum of Art','Philadelphia Museum of Art','Philadelphia','2600 Benjamin Franklin Pkwy','USA',39.966,-75.181,'http://www.philamuseum.org/','xDQDYKNTVrp.RmQV','2401619','ChIJ_5CoRebFxokR08ApAyF2KIs');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (16,'Louvre Museum','Musée du Louvre','Paris','Rue de Rivoli, 75001','France',48.8611,2.33638,'http://www.louvre.fr/','36CFHdZUV7KNOKK4LQ','55843752','ChIJ8XJ_6CVu5kcRWP1XT9TkBt4');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (17,'Tate Britain','Tate Britain','London','Millbank, Westminster','UK',51.490833,-0.127222,'http://www.tate.org.uk/visit/tate-britain','BjVxeKdVU7z_Fw','41676','ChIJvWjCxekEdkgRoCgQVJHZH_U');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (18,'Art History Museum (Vienna)','Kunsthistorisches Museum','Vienna','Maria-Theresien-Platz, 1010','Austria',48.2037,16.3614,'http://www.khm.at/','GmGVGDJUV7vR.KE','551756','ChIJ8XfPY5oHbUcRQbimbLVSYG8');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (19,'Musee d\'Orsay','Musée d\'Orsay','Paris','1 Rue de la Légion d\'Honneur','France',48.86,2.327,'http://www.musee-orsay.fr/','.jdUillUV7Kt1uHqAg','55843777','ChIJG5Qwtitu5kcR2CNEsYy9cdA');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (20,'Museum of Modern Art','Museum of Modern Art','New York','11 W 53rd St','USA',40.761484,-73.977664,'http://www.moma.org/','byMt1GpTWrhtqOpahg','28288823','ChIJKxDbe_lYwokRVf__s8CPn-o');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (22,'Belvedere Gallery','Österreichische Galerie Belvedere','Vienna','Schloss Belvedere, Prinz Eugen-Stra├ƒe 27, 1030','Austria',48.19138,16.38,'http://www.belvedere.at/','wVuFk_FUV7sGJng','551795','ChIJpZ4LAn0HbUcRMNCmNwlXeN8');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (24,'Hermitage Museum','Hermitage Museum','St. Petersburg','Palace Square, 2','Russia',59.941,30.3129,'http://www.hermitagemuseum.org/','BfjabGxYUrw0knsYVA','90600519','ChIJ6eLLMgsxlkYR_F1QoCoDTgc');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (27,'J. Paul Getty Museum','J. Paul Getty Museum','Los Angeles','1200 Getty Center Dr','USA',34.0775,-118.475,'http://www.getty.edu/museum/','6A92XzRTWr3WXDwJwQ','28751324','ChIJpbxvgcW8woARza8I4QhFyyY');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (28,'National Gallery of Norway','Nationalgalleriet','Oslo','Universitetsgata 13, 0164','Norway',59.9162,10.7375,'http://www.nasjonalmuseet.no/','lQQM7sZZVL.Hngs','865764','ChIJOdGZU3xuQUYRRpZUX1Z3YUM');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (29,'Van Gogh Museum','Van Gogh Museum','Amsterdam','Museumplein 6, 1071 DJ','Netherlands',52.358417,4.881083,'http://www.vangoghmuseum.nl/','xfcEFYhWULKtjYI','728410','ChIJX1rTlu8JxkcRGsV8-a4oKMI');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (30,'Rijksmuseum','Rijksmuseum','Amsterdam','Museumstraat 1, 1071 XX','Netherlands',52.36,4.885278,'http://www.rijksmuseum.nl/','xfcEFYhWULKtjYI','728410','ChIJ5Ra7we4JxkcRhYVAaq5zQ9U');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (32,'Royal Picture Gallery Mauritshuis','Royal Picture Gallery Mauritshuis','The Hague','Plein 29, 2511 CS Den Haag','Netherlands',52.080556,4.314444,'http://www.mauritshuis.nl/','gycEsvZWUbkGyFQ','733553','ChIJEa9zVSO3xUcRXKUtUE5Qgbk');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (34,'Musee du Petit Palais','Petit Palais','Paris','Avenue Winston Churchill, 75008','France',48.866084,2.314759,'http://www.parismusees.paris.fr/','a5KHUTVUVL6wFRTYsQ','56448116','ChIJSUOPztFv5kcRnEbSPYG-9fM');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (35,'Solomon R. Guggenheim Museum','Solomon R. Guggenheim Museum','New York','1071 5th Ave','USA',40.782975,-73.958992,'http://www.guggenheim.org/new-york','1AJK9adTWr3qYGsuLA','28751193','ChIJmZ5emqJYwokRuDz79o0coAQ');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (36,'The Courtauld Institute of Art','The Courtauld Institute of Art','London','Strand','UK',51.510833,-0.117222,'http://www.courtauld.ac.uk/','AZPsrPxTUbyolQ','23636','ChIJvZhvcMoEdkgRB5qnzGs_VNw');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (37,'Barnes Foundation','Barnes Foundation','Philadelphia','2025 Benjamin Franklin Pkwy','USA',39.960659,-75.172523,'http://www.barnesfoundation.org/','y3CJNJRTW7m785fi2A','29389142','ChIJrcsBU8vHxokR4FXP2BplJks');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (38,'Sistine Chapel','Sistine Chapel','Rome','00120, Vatican City','Italy',41.903056,12.454444,'http://mv.vatican.va/','xfftaFtTUb6gXRUjTg','23424986','ChIJ268jxWVgLxMRIj61f4fIFqs');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (41,'Picture Gallery (Berlin)','Gemäldegalerie','Berlin','Matthäikirchplatz, 10785','Germany',52.508472,13.365417,'http://www.smb.museum/','VULyzjBXVb89VXc','675695','ChIJveOIOrRRqEcRIsZHHE5dQxA');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (42,'Brooklyn Museum','Brooklyn Museum','New York','200 Eastern Pkwy','USA',40.671306,-73.96375,'http://www.brooklynmuseum.org/','9R6NtodTWr2le.Hw.A','28751453','ChIJyTmcRApbwokR-oXJRqpVI8Y');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (43,'Old Masters Gallery','Gemäldegalerie Alte Meister','Dresden','Theaterplatz 1, 01067','Germany',51.053611,13.734722,'http://www.skd.museum/','fr.j5iRTVLL4Bs4Wag','26822156','ChIJE6ZpuWjPCUcR0dN6tE-_u6o');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (49,'Museum of Fine Arts','Museum of Fine Arts','Boston','465 Huntington Ave','USA',42.339167,-71.094167,'http://www.mfa.org/','c1_W2UJUVL.DGU.MbQ','56574533','ChIJS3rn5w1644kRZNWVxNY_Ay8');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (50,'National Gallery of Scotland','National Gallery of Scotland','Edinburgh','The Mound','Scotland',55.950917,-3.195667,'http://www.nationalgalleries.org/','AtPXsOpTUrrN5fImVw','20094252','ChIJ68bm6kjGh0gRkyF0XlT5Rww');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (51,'Albright-Knox Art Gallery','Albright-Knox Art Gallery','Buffalo','1285 Elmwood Ave','USA',42.932078,-78.877072,'http://www.albrightknox.org/','dLCnqMtUV7L6BRUi6g','55806539','ChIJe6SdptAS04kRzppu7BanDfk');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (52,'Detroit Institute of Arts','Detroit Institute of Arts','Detroit','5200 Woodward Ave','USA',42.359292,-83.064797,'http://www.dia.org/','aLB8_gVUVLt45Q4MaQ','56192713','ChIJO6USub3SJIgRshN1AKZBH20');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (70,'Indianapolis Museum of Art','Indianapolis Museum of Art','Indianapolis','4000 Michigan Rd','USA',39.8259,-86.1855,'http://www.imamuseum.org/','42QAS0hTV7j9Fq9a','2523727','ChIJJYnup7pWa4gRheOf5vIg2JE');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (81,'Brera Art Gallery','Pinacoteca di Brera','Milan','Via Brera, 28, 20121','Italy',45.471944,9.188056,'http://www.brera.beniculturali.it/','49Gidk1WU7JxrFY','718345','ChIJH05-WBHuhkcRNjexLI56Nhs');
INSERT INTO `Galleries` (`GalleryID`,`GalleryName`,`GalleryNativeName`,`GalleryCity`,`GalleryAddress`,`GalleryCountry`,`Latitude`,`Longitude`,`GalleryWebSite`,`FlickrPlaceID`,`YahooWoeID`,`GooglePlaceID`) VALUES (82,'Leopold Museum','Leopold Museum','Vienna','Museumsplatz 1, A 1070','Austria',48.202635,16.359088,'https://www.leopoldmuseum.org','vyIUe41UV7uao.Y','551801','ChIJAzFFGJAHbUcROmKaJWvcKyE');
# 35 records

#
# Table structure for table 'Genres'
#

DROP TABLE IF EXISTS `Genres`;

CREATE TABLE `Genres` (
  `GenreID` INTEGER NOT NULL AUTO_INCREMENT, 
  `GenreName` VARCHAR(50) NOT NULL, 
  `EraID` INTEGER, 
  `Description` LONGTEXT, 
  `Link` VARCHAR(255), 
  UNIQUE (`GenreName`), 
  INDEX (`GenreID`), 
  PRIMARY KEY (`GenreID`)
) ENGINE=innodb DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'Genres'
#
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (1,'Cubism',5,'Cubism was a 20th century avant-garde art movement, pioneered by Pablo Picasso and Georges Braque, that revolutionized European painting and sculpture, and inspired related movements in music, literature and architecture. In cubist artworks, objects are broken up, analyzed, and re-assembled in an abstracted form; instead of depicting objects from one viewpoint, the artist depicts the subject from a multitude of viewpoints to represent the subject in a greater context. Often the surfaces intersect at seemingly random angles, removing a coherent sense of depth. The background and object planes interpenetrate one another to create the shallow ambiguous space, one of cubism\'s distinct characteristics.','http://en.wikipedia.org/wiki/Cubism');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (33,'Romanticism',4,'Romanticism was an artistic, literary and intellectual movement that originated in the second half of the 18th century in Europe, and gained strength in reaction to the Industrial Revolution. In part, it was a revolt against aristocratic social and political norms of the Age of Enlightenment and a reaction against the scientific rationalization of nature. It was embodied most strongly in the visual arts, music, and literature, but had a major impact on historiography, education and natural history.','http://en.wikipedia.org/wiki/Romanticism');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (34,'Realism',4,'Realism as a tendency in 19th century art was related to similar movements in the theatre, literature and opera. All emphasized the depiction of everyday subjects, but by no means always discarding classical, Romantic or sentimental approaches to their treatment. The movement began in the 1850s in France. One of Gustave Courbet\'s most important works is A Burial at Ornans, 1849-1850, a canvas recording an event which he witnessed in September 1848. Courbet\'s painting of the funeral of his grand uncle became the first grand statement of the Realist style.','http://en.wikipedia.org/wiki/Realist_painting');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (35,'Impressionism',4,'Impressionism was a 19th-century art movement that originated with a group of Paris-based artists whose independent exhibitions brought them to prominence during the 1870s and 1880s. The name of the style is derived from the title of a Claude Monet work, Impression, soleil levant (Impression, Sunrise), which provoked the critic Louis Leroy to coin the term in a satiric review published in the Parisian newspaper Le Charivari.','http://en.wikipedia.org/wiki/Impressionism');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (36,'Post-Impressionism',5,'Post-Impressionism is the term coined by the British artist and art critic Roger Fry in 1910 to describe the development of French art since Manet. Fry used the term when he organized the 1910 exhibition Manet and Post-Impressionism. Post-Impressionists extended Impressionism while rejecting its limitations: they continued using vivid colours, thick application of paint, distinctive brush strokes, and real-life subject matter, but they were more inclined to emphasize geometric forms, to distort form for expressive effect, and to use unnatural or arbitrary colour.','http://en.wikipedia.org/wiki/Post_Impressionism');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (40,'Fauvism',5,'Fauvism is the style of les Fauves (French for \"the wild beasts\"), a short-lived and loose group of early twentieth-century Modern artists whose works emphasized painterly qualities and strong colour over the representational or realistic values retained by Impressionism. While Fauvism as a style began around 1900 and continued beyond 1910, the movement as such lasted only a few years, 1904-1908, and had three exhibitions. The leaders of the movement were Henri Matisse and Andre Derain.','http://en.wikipedia.org/wiki/Fauvism');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (47,'Surrealism',5,'Surrealism is a cultural movement that began in the early 1920s, and is best known for the visual artworks and writings of the group members. Surrealist works feature the element of surprise, unexpected juxtapositions and non sequitur; however, many Surrealist artists and writers regard their work as an expression of the philosophical movement first and foremost, with the works being an artifact. Leader Andre Breton was explicit in his assertion that Surrealism was above all a revolutionary movement.','http://en.wikipedia.org/wiki/Surrealism');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (56,'Expressionism',5,'Expressionism was a modernist movement, initially in poetry and painting, originating in Germany at the beginning of the 20th century. Its typical trait is to present the world solely from a subjective perspective, distorting it radically for emotional effect in order to evoke moods or ideas. Expressionist artists sought to express meaning or emotional experience rather than physical reality.','http://en.wikipedia.org/wiki/Expressionism');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (64,'Symbolism',5,'Symbolism was a late nineteenth-century art movement of French, Russian and Belgian origin in poetry and other arts. The aesthetic was developed by Stephane Mallarme and Paul Verlaine during the 1860s and \'70s. In the 1880s, the aesthetic was articulated by a series of manifestos and attracted a generation of writers. The name \"symbolist\" itself was first applied by the critic Jean Moreas, who invented the term to distinguish the symbolists from the related decadents of literature and of art.','http://en.wikipedia.org/wiki/Symbolism_(arts)');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (76,'Neoclassicism',5,'Neoclassicism is the name given to Western movements in the decorative and visual arts, literature, theatre, music, and architecture that draw inspiration from the \"classical\" art and culture of Ancient Greece or Ancient Rome. One such movement was dominant in Europe from the mid-18th to the 19th centuries.','http://en.wikipedia.org/wiki/Neoclassicism');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (77,'Northern Renaissance',2,'The Northern Renaissance is the Renaissance in northern Europe. Before 1597 Italian Renaissance humanism had little influence outside Italy. From the late 15th century the ideas spread around Europe. This influenced the German Renaissance, French Renaissance, English Renaissance, Renaissance in the Low Countries, Polish Renaissance and other national and localized movements, each with different characteristics and strengths.','http://en.wikipedia.org/wiki/Northern_Renaissance');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (78,'Renaissance',2,'Renaissance art is the painting, sculpture and decorative arts of that period of European history known as the Renaissance, emerging as a distinct style in Italy in about 1400, in parallel with developments which occurred in philosophy, literature, music and science. Renaissance art, perceived as a \"rebirth\" of ancient traditions, took as its foundation the art of Classical antiquity, but transformed that tradition by the absorption of recent developments in the art of Northern Europe and by application of contemporary scientific knowledge. Renaissance art, with Renaissance Humanist philosophy, spread throughout Europe, affecting both artists and their patrons with the development of new techniques and new artistic sensibilities. Renaissance art marks the transition of Europe from the medieval period to the Early modern age.','http://en.wikipedia.org/wiki/Renaissance_art');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (79,'High Renaissance',2,'High Renaissance is the period denoting the apogee of the visual arts in the Italian Renaissance. The High Renaissance period is traditionally taken to begin in the 1490s, with Leonardo\'s fresco of the Last Supper in Milan and the death of Lorenzo de\' Medici in Florence, and to have ended in 1527 with the sacking of Rome by the troops of Charles V. This term was first used in German (Hochrenaissance) in the early nineteenth century, and has its origins in the \"High Style\" of painting and sculpture described by Johann Joachim Winckelmann. Over the last twenty years, use of the term has been frequently criticized by academic art historians for oversimplifying artistic developments, ignoring historical context, and focusing only on a few iconic works.','http://en.wikipedia.org/wiki/High_Renaissance');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (80,'Mannerism',3,'Mannerism is a period of European art that emerged from the later years of the Italian High Renaissance around 1520. It lasted until about 1580 in Italy, when the Baroque style began to replace it, but Northern Mannerism continued into the early 17th century.','http://en.wikipedia.org/wiki/Mannerism');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (81,'International Gothic',1,'International Gothicis a phase of Gothic art which developed in Burgundy, Bohemia, France and northern Italy in the late 14th century and early 15th century. It then spread very widely across Western Europe, hence the name for the period, which was introduced by the French art historian Louis Courajod at the end of the 19th century.','http://en.wikipedia.org/wiki/International_Gothic');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (83,'Rococo',3,'Rococo, less commonly roccoco, also referred to as \"Late Baroque\", is an 18th-century artistic movement and style, which affected several aspects of the arts including painting, sculpture, architecture, interior design, decoration, literature, music and theatre. The Rococo developed in the early part of the 18th century in Paris, France as a reaction against the grandeur, symmetry and strict regulations of the Baroque, especially that of the Palace of Versailles. In such a way, Rococo artists opted for a more jocular, florid and graceful approach to Baroque art and architecture. Rococo art and architecture in such a way was ornate and made strong usage of creamy, pastel-like colours, asymmetrical designs, curves and gold. Unlike the more politically focused Baroque, the Rococo had more playful and often witty artistic themes. With regards to interior decoration, Rococo rooms were designed as total works of art with elegant and ornate furniture, small sculptures, ornamental mirrors, and tapestry complementing architecture, reliefs, and wall paintings. The Rococo additionally played an important role in theatre. In the book The Rococo, it is written that there was no other culture which \"has produced a wittier, more elegant, and teasing dialogue full of elusive and camouflaging language and gestures, refined feelings and subtle criticism\" than Rococo theatre, especially that of France.','http://en.wikipedia.org/wiki/Rococo');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (84,'Baroque',3,'The Baroque is a period of artistic style that used exaggerated motion and clear, easily interpreted detail to produce drama, tension, exuberance, and grandeur in sculpture, painting, architecture, literature, dance and music. The style began around 1600 in Rome, Italy and spread to most of Europe. The popularity and success of the Baroque style was encouraged by the Roman Catholic Church, which had decided at the time of the Council of Trent, in response to the Protestant Reformation, that the arts should communicate religious themes in direct and emotional involvement. The aristocracy also saw the dramatic style of Baroque architecture and art as a means of impressing visitors and expressing triumphant power and control. Baroque palaces are built around an entrance of courts, grand staircases and reception rooms of sequentially increasing opulence.','http://en.wikipedia.org/wiki/Baroque');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (87,'Dutch Golden Age',3,'Dutch Golden Age painting spans the 17th century, during and after the later part of the Eighty Years\' War (1568-1648) for Dutch independence. Although Dutch painting of the Golden Age comes in the general European period of Baroque painting, and often shows many of its characteristics, most lacks the idealization and love of splendour typical of much Baroque work, including that of neighbouring Flanders. Most work, including that for which the period is best known, reflects the traditions of detailed realism inherited from Early Netherlandish painting.','https://en.wikipedia.org/wiki/Dutch_Golden_Age_painting');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (88,'Academic Art',4,'Academic Art is a style of painting and sculpture produced under the influence of European academies of art. Specifically, academic art is the art and artists influenced by the standards of the French Academie des Beaux-Arts, which practiced under the movements of Neoclassicism and Romanticism, and the art that followed these two movements in the attempt to synthesize both of their styles, and which is best reflected by the paintings of William-Adolphe Bouguereau, Thomas Couture, and Hans Makart. In this context it is often called \"academism\", \"academicism\", \"L\'art pompier\", and \"eclecticism\", and sometimes linked with \"historicism\" and \"syncretism\". The art influenced by academies in general is also called \"academic art.\" In this context as new styles are embraced by academics, the new styles come to be considered academic, thus what was at one time a rebellion against academic art becomes academic art.','https://en.wikipedia.org/wiki/Academic_art');
INSERT INTO `Genres` (`GenreID`,`GenreName`,`EraID`,`Description`,`Link`) VALUES (89,'Biedermeier',4,'The Biedermeier period does not refer to the era as a whole, but to a particular mood and set of trends that grew out of the unique underpinnings of the time in Central Europe between 1815 and 1848. During this time, the middle class grew in number and arts appealed to common sensibilities. The effect was for artists and society in general to concentrate on the domestic and (at least in public) the non-political. Painting during this era is characterized by the commitment to portray a sentimental and pious view of the world in a realistic way. Biedermeier themes reinforced feelings of security, Gemütlichkeit, traditional pieties and simplicity, eschewing political and social commentary during the epoch. Thus, the techniques, while classic in nature were of the utmost importance to reach a realistic rendering. Regarding the thematic, the technique was seen not only as a narrative medium to tell the past in anecdotal vignettes, but also to represent the present.','https://en.wikipedia.org/wiki/Biedermeier');

# 20 records

#
# Table structure for table 'OrderDetails'
#

DROP TABLE IF EXISTS `OrderDetails`;

CREATE TABLE `OrderDetails` (
  `OrderDetailID` INTEGER NOT NULL, 
  `OrderID` INTEGER, 
  `PaintingID` INTEGER, 
  `FrameID` INTEGER, 
  `GlassID` INTEGER, 
  `MattID` INTEGER, 
  INDEX (`FrameID`), 
  INDEX (`GlassID`), 
  INDEX (`MattID`), 
  PRIMARY KEY (`OrderDetailID`), 
  INDEX (`OrderID`), 
  INDEX (`PaintingID`)
) ENGINE=innodb DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'OrderDetails'
#

INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (1, 102, 559, 9, 5, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (2, 477, 230, 3, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (3, 93, 563, 12, 5, 6);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (4, 324, 16, 11, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (5, 440, 432, 4, 5, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (6, 252, 213, 11, 5, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (7, 490, 51, 3, 2, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (8, 299, 430, 10, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (9, 82, 195, 4, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (10, 160, 351, 17, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (11, 260, 567, 6, 2, 26);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (12, 126, 538, 2, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (13, 91, 65, 18, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (14, 247, 577, 15, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (15, 337, 42, 12, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (16, 68, 571, 14, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (17, 272, 425, 18, 5, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (18, 305, 564, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (19, 483, 426, 15, 5, 26);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (20, 391, 587, 4, 5, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (21, 234, 399, 4, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (22, 343, 596, 2, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (23, 459, 41, 12, 5, 31);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (24, 480, 588, 6, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (25, 157, 230, 4, 5, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (26, 58, 427, 18, 5, 31);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (27, 338, 498, 12, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (28, 253, 550, 1, 5, 29);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (29, 189, 539, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (30, 277, 428, 15, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (31, 290, 51, 18, 1, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (32, 19, 408, 4, 5, 1);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (33, 436, 427, 12, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (34, 398, 63, 15, 5, 27);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (35, 284, 42, 14, 5, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (36, 200, 443, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (37, 263, 516, 8, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (38, 5, 30, 18, 5, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (39, 2, 399, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (40, 194, 578, 12, 5, 22);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (41, 275, 192, 18, 3, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (42, 143, 484, 18, 5, 34);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (43, 264, 60, 9, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (44, 7, 11, 3, 5, 15);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (45, 59, 425, 10, 5, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (46, 326, 48, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (47, 398, 401, 18, 5, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (48, 73, 81, 5, 2, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (49, 266, 484, 9, 3, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (50, 227, 573, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (51, 136, 484, 18, 5, 27);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (52, 480, 291, 13, 1, 31);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (53, 442, 58, 18, 5, 1);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (54, 478, 419, 6, 3, 22);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (55, 97, 463, 18, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (56, 234, 47, 4, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (57, 130, 383, 12, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (58, 114, 433, 1, 2, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (59, 200, 549, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (60, 47, 231, 18, 5, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (61, 422, 580, 1, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (62, 259, 225, 18, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (63, 45, 48, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (64, 122, 101, 6, 5, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (65, 10, 514, 3, 5, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (66, 101, 527, 8, 2, 8);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (67, 165, 392, 18, 1, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (68, 386, 46, 18, 4, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (69, 88, 593, 14, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (70, 354, 578, 1, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (71, 317, 520, 4, 5, 26);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (72, 232, 588, 1, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (73, 275, 498, 18, 1, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (74, 286, 545, 18, 4, 1);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (75, 443, 574, 8, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (76, 270, 574, 4, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (77, 357, 548, 6, 5, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (78, 162, 235, 18, 4, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (79, 138, 575, 1, 5, 4);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (80, 351, 36, 5, 5, 26);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (81, 394, 554, 3, 5, 4);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (82, 413, 49, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (83, 438, 294, 11, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (84, 450, 425, 18, 5, 4);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (85, 236, 391, 13, 5, 29);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (86, 447, 548, 9, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (87, 403, 443, 11, 2, 17);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (88, 158, 457, 8, 5, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (89, 119, 37, 12, 5, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (90, 438, 348, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (91, 317, 369, 14, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (92, 319, 574, 18, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (93, 162, 430, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (94, 486, 425, 11, 5, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (95, 30, 349, 18, 4, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (96, 382, 172, 18, 1, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (97, 239, 399, 18, 3, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (98, 199, 581, 7, 4, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (99, 211, 426, 10, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (100, 447, 52, 12, 5, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (101, 212, 333, 12, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (102, 495, 288, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (103, 116, 157, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (104, 390, 526, 1, 5, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (105, 63, 556, 12, 2, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (106, 38, 333, 8, 5, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (107, 404, 83, 14, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (108, 332, 549, 12, 3, 30);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (109, 182, 546, 15, 4, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (110, 144, 399, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (111, 53, 428, 18, 5, 34);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (112, 378, 530, 2, 5, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (113, 368, 46, 18, 5, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (114, 159, 482, 13, 5, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (115, 308, 37, 3, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (116, 399, 408, 18, 5, 8);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (117, 170, 406, 5, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (118, 75, 549, 8, 3, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (119, 188, 565, 16, 4, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (120, 45, 431, 2, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (121, 226, 509, 8, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (122, 198, 501, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (123, 60, 451, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (124, 137, 14, 6, 3, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (125, 278, 430, 9, 5, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (126, 174, 514, 12, 5, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (127, 231, 388, 12, 5, 31);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (128, 396, 549, 18, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (129, 224, 588, 18, 5, 6);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (130, 164, 509, 18, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (131, 179, 165, 18, 5, 22);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (132, 464, 392, 7, 4, 11);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (133, 252, 472, 5, 2, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (134, 127, 296, 17, 2, 31);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (135, 39, 439, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (136, 361, 519, 16, 5, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (137, 71, 581, 15, 5, 30);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (138, 173, 48, 3, 4, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (139, 51, 588, 10, 2, 1);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (140, 363, 58, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (141, 484, 568, 1, 4, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (142, 204, 576, 16, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (143, 28, 598, 4, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (144, 41, 48, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (145, 410, 438, 13, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (146, 330, 581, 16, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (147, 401, 369, 12, 4, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (148, 321, 60, 17, 1, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (149, 197, 50, 18, 5, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (150, 187, 374, 5, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (151, 151, 15, 12, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (152, 179, 192, 18, 5, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (153, 76, 534, 12, 5, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (154, 45, 425, 18, 5, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (155, 349, 590, 18, 5, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (156, 409, 539, 9, 4, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (157, 204, 214, 5, 5, 17);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (158, 266, 157, 3, 2, 29);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (159, 486, 36, 5, 5, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (160, 1, 529, 17, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (161, 325, 535, 10, 2, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (162, 72, 554, 9, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (163, 119, 516, 6, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (164, 367, 339, 18, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (165, 37, 588, 3, 2, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (166, 240, 508, 18, 5, 31);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (167, 109, 393, 4, 4, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (168, 26, 47, 4, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (169, 37, 426, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (170, 420, 103, 13, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (171, 314, 60, 4, 3, 17);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (172, 201, 398, 18, 3, 29);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (173, 379, 587, 18, 3, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (174, 207, 581, 5, 3, 4);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (175, 152, 504, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (176, 133, 463, 18, 5, 30);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (177, 406, 58, 10, 5, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (178, 208, 393, 3, 5, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (179, 81, 426, 18, 5, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (180, 221, 516, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (181, 253, 457, 18, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (182, 357, 570, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (183, 159, 426, 4, 5, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (184, 210, 60, 12, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (185, 171, 588, 4, 4, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (186, 378, 582, 8, 2, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (187, 432, 379, 4, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (188, 485, 172, 18, 5, 27);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (189, 347, 290, 18, 4, 11);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (190, 254, 333, 3, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (191, 23, 459, 18, 5, 27);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (192, 243, 213, 18, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (193, 86, 408, 4, 4, 6);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (194, 183, 45, 12, 5, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (195, 396, 399, 9, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (196, 230, 300, 3, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (197, 159, 63, 18, 5, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (198, 411, 48, 4, 2, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (199, 416, 525, 18, 4, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (200, 150, 49, 6, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (201, 296, 37, 4, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (202, 308, 472, 14, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (203, 194, 66, 16, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (204, 341, 48, 13, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (205, 274, 435, 18, 1, 4);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (206, 241, 588, 18, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (207, 461, 531, 7, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (208, 167, 534, 16, 5, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (209, 50, 377, 18, 5, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (210, 84, 562, 18, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (211, 342, 427, 15, 3, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (212, 328, 583, 10, 5, 31);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (213, 36, 349, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (214, 452, 392, 12, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (215, 21, 516, 5, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (216, 57, 562, 18, 5, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (217, 106, 67, 10, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (218, 180, 35, 8, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (219, 311, 192, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (220, 54, 439, 14, 5, 34);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (221, 437, 69, 12, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (222, 74, 30, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (223, 334, 545, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (224, 284, 507, 8, 5, 11);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (225, 464, 195, 5, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (226, 34, 152, 18, 1, 27);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (227, 291, 178, 18, 5, 34);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (228, 300, 60, 18, 2, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (229, 218, 61, 13, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (230, 403, 291, 11, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (231, 231, 386, 18, 2, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (232, 380, 48, 7, 5, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (233, 421, 471, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (234, 312, 541, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (235, 217, 437, 12, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (236, 170, 258, 4, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (237, 368, 408, 12, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (238, 95, 492, 17, 2, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (239, 343, 103, 18, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (240, 237, 408, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (241, 420, 478, 3, 1, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (242, 243, 124, 16, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (243, 448, 486, 17, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (244, 370, 588, 12, 4, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (245, 269, 391, 18, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (246, 245, 47, 18, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (247, 207, 288, 12, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (248, 3, 63, 13, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (249, 383, 488, 8, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (250, 258, 571, 13, 5, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (251, 202, 424, 15, 2, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (252, 231, 225, 10, 5, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (253, 68, 459, 1, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (254, 421, 408, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (255, 463, 573, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (256, 479, 77, 8, 5, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (257, 238, 419, 18, 5, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (258, 444, 439, 18, 5, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (259, 50, 543, 18, 3, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (260, 37, 172, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (261, 413, 420, 8, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (262, 320, 498, 18, 5, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (263, 395, 290, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (264, 117, 484, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (265, 113, 559, 13, 2, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (266, 476, 333, 7, 5, 6);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (267, 303, 463, 4, 5, 27);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (268, 427, 581, 5, 5, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (269, 180, 532, 12, 2, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (270, 247, 515, 18, 5, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (271, 297, 46, 4, 5, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (272, 156, 63, 4, 5, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (273, 401, 483, 5, 5, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (274, 49, 432, 13, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (275, 98, 48, 11, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (276, 85, 425, 8, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (277, 85, 598, 4, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (278, 74, 581, 18, 4, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (279, 358, 406, 5, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (280, 173, 288, 18, 5, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (281, 391, 114, 4, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (282, 355, 572, 18, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (283, 395, 571, 2, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (284, 24, 525, 2, 2, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (285, 253, 474, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (286, 176, 526, 18, 5, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (287, 44, 546, 15, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (288, 250, 39, 8, 5, 15);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (289, 458, 535, 18, 4, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (290, 395, 599, 4, 1, 27);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (291, 64, 45, 10, 4, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (292, 294, 31, 4, 3, 31);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (293, 170, 50, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (294, 418, 63, 17, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (295, 230, 432, 12, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (296, 496, 428, 18, 5, 11);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (297, 5, 231, 18, 1, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (298, 217, 152, 3, 5, 26);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (299, 165, 366, 18, 4, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (300, 473, 590, 8, 5, 29);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (301, 55, 213, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (302, 87, 417, 8, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (303, 493, 399, 2, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (304, 115, 561, 12, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (305, 419, 393, 12, 5, 8);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (306, 267, 472, 12, 3, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (307, 499, 505, 16, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (308, 104, 540, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (309, 461, 540, 8, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (310, 167, 484, 6, 5, 27);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (311, 315, 173, 14, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (312, 235, 590, 18, 3, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (313, 335, 401, 12, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (314, 474, 146, 8, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (315, 381, 68, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (316, 338, 291, 18, 2, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (317, 483, 478, 2, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (318, 48, 16, 12, 4, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (319, 457, 498, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (320, 67, 563, 15, 2, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (321, 254, 48, 11, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (322, 344, 16, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (323, 49, 420, 7, 5, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (324, 93, 294, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (325, 164, 484, 4, 5, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (326, 177, 152, 12, 5, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (327, 325, 506, 18, 1, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (328, 234, 554, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (329, 371, 413, 4, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (330, 387, 590, 9, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (331, 79, 586, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (332, 396, 140, 18, 5, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (333, 179, 51, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (334, 120, 192, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (335, 128, 194, 17, 5, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (336, 260, 258, 18, 5, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (337, 307, 587, 12, 5, 15);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (338, 387, 71, 18, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (339, 100, 554, 12, 1, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (340, 103, 61, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (341, 102, 333, 9, 5, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (342, 451, 515, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (343, 409, 418, 18, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (344, 78, 576, 14, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (345, 170, 570, 18, 5, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (346, 40, 48, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (347, 234, 568, 10, 5, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (348, 369, 299, 10, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (349, 284, 424, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (350, 56, 102, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (351, 164, 48, 6, 3, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (352, 132, 590, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (353, 161, 590, 4, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (354, 268, 377, 18, 1, 4);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (355, 394, 578, 14, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (356, 31, 192, 16, 2, 30);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (357, 298, 498, 4, 5, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (358, 182, 387, 18, 5, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (359, 101, 165, 18, 5, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (360, 208, 60, 1, 2, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (361, 263, 590, 9, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (362, 282, 219, 4, 5, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (363, 27, 462, 16, 2, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (364, 302, 445, 12, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (365, 475, 408, 8, 4, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (366, 270, 30, 1, 5, 34);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (367, 414, 496, 6, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (368, 92, 420, 5, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (369, 295, 588, 18, 5, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (370, 293, 547, 11, 1, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (371, 147, 541, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (372, 309, 178, 4, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (373, 325, 219, 13, 5, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (374, 223, 425, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (375, 445, 182, 12, 1, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (376, 205, 443, 17, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (377, 29, 583, 2, 1, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (378, 242, 488, 12, 5, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (379, 456, 509, 18, 3, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (380, 419, 577, 9, 5, 22);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (381, 430, 469, 1, 5, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (382, 218, 54, 15, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (383, 143, 12, 15, 2, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (384, 458, 47, 18, 5, 17);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (385, 193, 423, 12, 5, 6);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (386, 74, 591, 12, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (387, 489, 64, 12, 2, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (388, 177, 439, 2, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (389, 271, 504, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (390, 412, 393, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (391, 205, 570, 4, 4, 29);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (392, 497, 535, 5, 2, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (393, 249, 47, 6, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (394, 108, 499, 14, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (395, 453, 513, 18, 5, 1);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (396, 348, 291, 18, 5, 29);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (397, 213, 543, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (398, 43, 124, 15, 5, 1);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (399, 57, 525, 5, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (400, 104, 5, 18, 1, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (401, 396, 310, 9, 2, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (402, 415, 566, 6, 5, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (403, 285, 484, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (404, 59, 213, 18, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (405, 80, 63, 18, 2, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (406, 20, 544, 18, 5, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (407, 310, 420, 12, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (408, 107, 154, 3, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (409, 449, 469, 18, 5, 8);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (410, 316, 48, 1, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (411, 208, 39, 18, 5, 30);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (412, 13, 387, 15, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (413, 419, 405, 18, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (414, 361, 376, 18, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (415, 32, 562, 14, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (416, 119, 501, 5, 1, 8);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (417, 386, 61, 8, 3, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (418, 366, 65, 18, 2, 30);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (419, 225, 346, 8, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (420, 459, 401, 3, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (421, 33, 574, 1, 5, 11);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (422, 244, 467, 5, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (423, 100, 425, 6, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (424, 250, 483, 4, 5, 26);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (425, 166, 54, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (426, 469, 401, 12, 5, 30);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (427, 303, 31, 3, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (428, 246, 587, 12, 2, 34);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (429, 190, 525, 18, 2, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (430, 194, 504, 18, 4, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (431, 204, 588, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (432, 313, 259, 17, 2, 22);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (433, 110, 373, 3, 2, 15);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (434, 282, 39, 18, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (435, 127, 594, 4, 5, 30);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (436, 323, 408, 17, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (437, 68, 77, 10, 5, 29);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (438, 259, 422, 14, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (439, 17, 63, 2, 5, 8);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (440, 423, 60, 2, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (441, 433, 505, 14, 5, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (442, 423, 519, 9, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (443, 329, 500, 12, 3, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (444, 96, 589, 3, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (445, 470, 46, 18, 1, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (446, 46, 509, 10, 2, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (447, 491, 392, 8, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (448, 307, 582, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (449, 112, 154, 3, 2, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (450, 415, 572, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (451, 89, 561, 13, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (452, 307, 190, 18, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (453, 424, 408, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (454, 336, 376, 18, 5, 17);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (455, 286, 36, 13, 5, 11);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (456, 171, 172, 18, 5, 6);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (457, 258, 54, 18, 5, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (458, 435, 455, 18, 5, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (459, 178, 502, 18, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (460, 168, 401, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (461, 435, 592, 12, 5, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (462, 495, 464, 4, 3, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (463, 148, 462, 16, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (464, 427, 543, 18, 5, 26);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (465, 481, 48, 10, 5, 17);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (466, 333, 426, 9, 5, 6);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (467, 459, 412, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (468, 211, 526, 12, 5, 6);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (469, 177, 425, 13, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (470, 217, 54, 18, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (471, 233, 592, 12, 2, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (472, 124, 551, 10, 5, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (473, 255, 405, 18, 5, 4);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (474, 105, 11, 1, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (475, 465, 63, 3, 5, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (476, 413, 599, 13, 5, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (477, 456, 408, 11, 2, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (478, 133, 581, 18, 3, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (479, 44, 173, 17, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (480, 9, 598, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (481, 288, 379, 14, 5, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (482, 130, 568, 7, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (483, 466, 7, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (484, 298, 401, 6, 2, 1);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (485, 369, 554, 18, 5, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (486, 131, 45, 18, 2, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (487, 307, 39, 12, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (488, 276, 48, 18, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (489, 337, 55, 8, 4, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (490, 185, 569, 18, 1, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (491, 443, 484, 8, 3, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (492, 246, 142, 4, 5, 27);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (493, 127, 432, 9, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (494, 345, 294, 18, 2, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (495, 278, 258, 14, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (496, 392, 572, 18, 2, 34);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (497, 373, 334, 16, 4, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (498, 127, 507, 16, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (499, 52, 60, 2, 5, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (500, 144, 475, 9, 5, 17);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (501, 253, 575, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (502, 72, 459, 17, 4, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (503, 277, 61, 2, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (504, 15, 427, 18, 2, 6);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (505, 142, 192, 17, 5, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (506, 397, 509, 11, 3, 27);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (507, 66, 481, 8, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (508, 214, 392, 10, 5, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (509, 125, 58, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (510, 482, 178, 12, 3, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (511, 327, 374, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (512, 283, 392, 4, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (513, 442, 393, 14, 5, 1);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (514, 174, 69, 16, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (515, 89, 88, 7, 5, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (516, 378, 339, 17, 5, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (517, 362, 299, 4, 5, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (518, 341, 51, 1, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (519, 279, 459, 8, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (520, 154, 425, 6, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (521, 279, 559, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (522, 420, 393, 3, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (523, 155, 373, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (524, 59, 165, 18, 5, 31);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (525, 144, 592, 8, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (526, 203, 518, 8, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (527, 459, 63, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (528, 306, 388, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (529, 500, 527, 8, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (530, 228, 433, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (531, 263, 16, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (532, 463, 428, 4, 5, 22);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (533, 380, 403, 12, 5, 1);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (534, 171, 51, 18, 5, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (535, 194, 145, 8, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (536, 422, 401, 8, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (537, 182, 24, 8, 5, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (538, 472, 66, 18, 5, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (539, 421, 475, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (540, 4, 172, 9, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (541, 26, 146, 18, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (542, 209, 579, 11, 3, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (543, 331, 80, 7, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (544, 319, 65, 8, 5, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (545, 266, 64, 18, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (546, 322, 114, 18, 4, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (547, 251, 509, 16, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (548, 431, 486, 18, 3, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (549, 276, 558, 3, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (550, 410, 587, 5, 3, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (551, 6, 559, 9, 5, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (552, 135, 431, 18, 2, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (553, 146, 349, 4, 5, 31);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (554, 15, 52, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (555, 460, 508, 8, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (556, 77, 388, 12, 5, 8);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (557, 455, 570, 12, 5, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (558, 4, 520, 11, 5, 31);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (559, 425, 484, 8, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (560, 248, 388, 18, 1, 29);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (561, 500, 484, 18, 1, 15);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (562, 22, 536, 18, 5, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (563, 444, 152, 18, 5, 15);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (564, 359, 504, 2, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (565, 51, 521, 18, 5, 15);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (566, 318, 500, 4, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (567, 215, 484, 14, 1, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (568, 376, 507, 8, 5, 34);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (569, 50, 348, 18, 4, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (570, 72, 310, 12, 2, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (571, 154, 406, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (572, 384, 52, 4, 2, 6);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (573, 85, 419, 4, 4, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (574, 195, 48, 18, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (575, 57, 442, 9, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (576, 404, 424, 12, 4, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (577, 323, 501, 7, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (578, 142, 48, 16, 2, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (579, 356, 470, 1, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (580, 405, 333, 9, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (581, 19, 389, 11, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (582, 258, 61, 17, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (583, 390, 501, 4, 2, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (584, 364, 501, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (585, 340, 63, 16, 2, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (586, 431, 171, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (587, 27, 527, 17, 1, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (588, 373, 502, 17, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (589, 495, 259, 18, 5, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (590, 438, 572, 15, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (591, 246, 63, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (592, 111, 419, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (593, 245, 468, 2, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (594, 292, 565, 18, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (595, 139, 258, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (596, 99, 300, 8, 2, 29);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (597, 246, 409, 8, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (598, 48, 438, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (599, 25, 419, 12, 5, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (600, 495, 54, 17, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (601, 65, 399, 18, 3, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (602, 426, 585, 4, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (603, 346, 493, 18, 5, 15);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (604, 442, 369, 2, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (605, 499, 424, 17, 5, 34);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (606, 11, 467, 18, 5, 8);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (607, 468, 16, 18, 2, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (608, 306, 118, 4, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (609, 500, 577, 17, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (610, 60, 63, 9, 5, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (611, 216, 392, 13, 2, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (612, 85, 195, 3, 5, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (613, 169, 408, 4, 2, 27);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (614, 353, 392, 7, 3, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (615, 219, 35, 18, 5, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (616, 492, 333, 8, 3, 22);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (617, 498, 89, 11, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (618, 222, 392, 17, 5, 26);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (619, 186, 399, 18, 5, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (620, 180, 381, 14, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (621, 342, 45, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (622, 87, 65, 18, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (623, 410, 233, 18, 5, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (624, 421, 48, 15, 5, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (625, 120, 467, 18, 5, 27);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (626, 182, 432, 12, 2, 26);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (627, 421, 30, 18, 3, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (628, 250, 467, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (629, 123, 589, 8, 1, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (630, 429, 291, 4, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (631, 304, 458, 16, 2, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (632, 159, 391, 18, 3, 11);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (633, 52, 349, 5, 3, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (634, 51, 517, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (635, 336, 259, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (636, 175, 535, 5, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (637, 172, 482, 18, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (638, 121, 430, 11, 5, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (639, 155, 587, 1, 4, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (640, 85, 146, 12, 5, 32);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (641, 153, 593, 18, 2, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (642, 195, 599, 18, 5, 22);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (643, 62, 499, 18, 4, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (644, 246, 419, 9, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (645, 199, 541, 7, 1, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (646, 273, 425, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (647, 400, 388, 16, 2, 1);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (648, 196, 195, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (649, 194, 65, 1, 5, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (650, 350, 571, 5, 5, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (651, 96, 420, 13, 5, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (652, 277, 469, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (653, 158, 486, 10, 3, 6);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (654, 366, 388, 8, 5, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (655, 339, 15, 18, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (656, 295, 192, 16, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (657, 408, 433, 1, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (658, 8, 467, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (659, 163, 426, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (660, 60, 63, 17, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (661, 441, 26, 1, 5, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (662, 488, 423, 14, 5, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (663, 279, 213, 8, 4, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (664, 406, 388, 8, 5, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (665, 437, 492, 3, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (666, 114, 36, 12, 5, 1);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (667, 372, 468, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (668, 84, 407, 10, 5, 16);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (669, 58, 67, 18, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (670, 374, 543, 18, 2, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (671, 215, 547, 17, 4, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (672, 301, 15, 15, 1, 8);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (673, 26, 508, 6, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (674, 157, 420, 18, 5, 10);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (675, 57, 11, 4, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (676, 389, 103, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (677, 103, 433, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (678, 467, 401, 7, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (679, 184, 507, 12, 4, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (680, 217, 587, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (681, 140, 467, 12, 3, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (682, 387, 512, 4, 5, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (683, 163, 578, 17, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (684, 262, 521, 10, 1, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (685, 149, 153, 12, 5, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (686, 83, 373, 18, 5, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (687, 100, 574, 8, 1, 26);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (688, 368, 349, 18, 5, 27);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (689, 414, 543, 17, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (690, 62, 219, 17, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (691, 35, 474, 4, 5, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (692, 129, 564, 18, 5, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (693, 342, 349, 18, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (694, 184, 375, 4, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (695, 403, 472, 4, 5, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (696, 462, 399, 16, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (697, 84, 595, 5, 5, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (698, 303, 448, 4, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (699, 486, 422, 12, 5, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (700, 99, 300, 10, 4, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (701, 363, 537, 7, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (702, 102, 587, 18, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (703, 38, 541, 12, 5, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (704, 278, 568, 4, 5, 29);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (705, 68, 57, 18, 2, 4);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (706, 454, 561, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (707, 446, 232, 18, 5, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (708, 70, 583, 18, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (709, 289, 556, 12, 2, 17);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (710, 230, 157, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (711, 281, 482, 9, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (712, 45, 51, 14, 3, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (713, 324, 588, 18, 4, 1);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (714, 499, 114, 18, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (715, 284, 26, 5, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (716, 360, 378, 12, 5, 4);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (717, 149, 514, 18, 5, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (718, 393, 79, 17, 5, 34);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (719, 471, 483, 18, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (720, 22, 213, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (721, 265, 35, 18, 5, 33);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (722, 422, 422, 14, 5, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (723, 14, 514, 18, 5, 17);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (724, 61, 484, 18, 1, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (725, 145, 36, 7, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (726, 443, 79, 11, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (727, 141, 598, 18, 1, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (728, 261, 391, 18, 4, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (729, 387, 476, 3, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (730, 181, 56, 13, 5, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (731, 455, 525, 18, 5, 22);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (732, 118, 588, 4, 5, 29);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (733, 280, 405, 15, 5, 15);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (734, 191, 471, 18, 5, 34);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (735, 253, 463, 6, 2, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (736, 428, 486, 4, 5, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (737, 4, 585, 13, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (738, 154, 172, 6, 5, 6);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (739, 51, 46, 8, 5, 23);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (740, 198, 559, 18, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (741, 287, 63, 18, 3, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (742, 18, 427, 6, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (743, 273, 527, 11, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (744, 323, 401, 12, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (745, 96, 192, 9, 5, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (746, 12, 392, 12, 5, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (747, 377, 392, 12, 1, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (748, 16, 30, 18, 5, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (749, 229, 373, 4, 5, 17);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (750, 249, 300, 10, 4, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (751, 48, 541, 7, 5, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (752, 90, 77, 8, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (753, 193, 347, 15, 1, 9);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (754, 375, 334, 9, 5, 13);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (755, 56, 408, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (756, 337, 31, 18, 5, 8);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (757, 249, 543, 18, 5, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (758, 460, 346, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (759, 365, 554, 18, 2, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (760, 96, 71, 4, 1, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (761, 487, 145, 18, 5, 31);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (762, 145, 334, 18, 4, 19);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (763, 246, 502, 12, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (764, 364, 515, 10, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (765, 494, 80, 15, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (766, 273, 587, 13, 4, 6);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (767, 257, 570, 18, 5, 12);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (768, 269, 24, 18, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (769, 202, 500, 13, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (770, 192, 333, 12, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (771, 369, 376, 8, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (772, 323, 569, 4, 5, 30);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (773, 69, 572, 18, 4, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (774, 230, 469, 18, 5, 21);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (775, 159, 105, 12, 5, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (776, 434, 386, 1, 5, 2);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (777, 390, 561, 12, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (778, 417, 517, 18, 5, 18);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (779, 388, 41, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (780, 286, 48, 18, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (781, 94, 425, 18, 3, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (782, 343, 486, 18, 1, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (783, 260, 375, 6, 5, 15);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (784, 256, 403, 11, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (785, 385, 192, 4, 4, 7);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (786, 206, 498, 7, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (787, 15, 334, 14, 4, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (788, 439, 291, 4, 5, 31);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (789, 8, 530, 18, 2, 28);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (790, 398, 524, 14, 5, 5);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (791, 220, 5, 12, 3, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (792, 134, 64, 12, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (793, 402, 54, 18, 2, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (794, 153, 57, 7, 5, 20);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (795, 42, 58, 18, 5, 3);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (796, 68, 58, 18, 5, 35);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (797, 407, 424, 16, 5, 24);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (798, 352, 476, 12, 4, 14);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (799, 166, 419, 18, 5, 25);
INSERT INTO `OrderDetails` (`OrderDetailID`, `OrderID`, `PaintingID`, `FrameID`, `GlassID`, `MattID`) VALUES (800, 425, 504, 4, 5, 12);
# 800 records

#
# Table structure for table 'Orders'
#

DROP TABLE IF EXISTS `Orders`;

CREATE TABLE `Orders` (
  `OrderID` INTEGER NOT NULL, 
  `ShipperID` INTEGER, 
  `CustomerID` INTEGER, 
  `DateStarted` DATETIME, 
  `Quantity` INTEGER, 
  INDEX (`CustomerID`), 
  PRIMARY KEY (`OrderID`), 
  INDEX (`ShipperID`)
) ENGINE=innodb DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'Orders'
#

INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (1, 83, 27, '2015-12-22 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (2, 62, 28, '2015-12-13 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (3, 83, 41, '2016-06-13 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (4, 63, 54, '2016-02-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (5, 83, 37, '2016-10-27 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (6, 63, 52, '2017-05-18 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (7, 89, 12, '2016-02-13 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (8, 63, 28, '2017-07-08 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (9, 63, 38, '2016-08-12 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (10, 88, 14, '2016-11-08 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (11, 63, 39, '2017-05-16 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (12, 83, 53, '2017-01-30 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (13, 87, 17, '2016-07-30 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (14, 83, 41, '2016-07-04 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (15, 89, 7, '2017-07-15 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (16, 62, 23, '2015-10-31 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (17, 63, 22, '2016-05-24 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (18, 62, 50, '2016-06-01 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (19, 90, 43, '2015-12-03 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (20, 85, 28, '2016-01-14 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (21, 83, 38, '2016-03-15 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (22, 89, 28, '2016-10-28 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (23, 62, 20, '2017-06-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (24, 90, 15, '2016-01-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (25, 62, 10, '2016-03-31 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (26, 83, 53, '2016-01-27 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (27, 85, 40, '2017-07-28 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (28, 90, 42, '2017-06-30 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (29, 83, 29, '2016-09-10 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (30, 85, 28, '2015-11-20 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (31, 62, 49, '2017-07-23 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (32, 62, 2, '2016-10-28 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (33, 63, 6, '2015-12-17 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (34, 62, 30, '2017-06-11 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (35, 87, 22, '2017-06-25 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (36, 85, 9, '2016-12-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (37, 86, 33, '2016-08-13 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (38, 62, 21, '2016-03-24 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (39, 62, 27, '2015-11-11 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (40, 83, 31, '2016-11-12 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (41, 90, 38, '2017-04-30 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (42, 83, 48, '2015-12-12 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (43, 85, 50, '2017-08-15 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (44, 63, 42, '2016-03-10 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (45, 90, 3, '2016-01-23 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (46, 88, 3, '2015-09-24 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (47, 63, 51, '2016-09-08 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (48, 62, 6, '2017-02-06 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (49, 90, 2, '2016-08-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (50, 85, 50, '2016-10-16 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (51, 89, 39, '2016-02-10 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (52, 89, 41, '2015-12-05 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (53, 62, 37, '2017-01-14 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (54, 90, 3, '2017-09-05 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (55, 62, 2, '2015-10-26 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (56, 86, 12, '2015-09-24 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (57, 63, 32, '2016-03-18 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (58, 90, 10, '2017-04-14 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (59, 83, 28, '2016-01-07 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (60, 62, 43, '2017-04-11 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (61, 83, 42, '2017-04-03 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (62, 62, 31, '2016-01-19 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (63, 90, 12, '2017-07-30 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (64, 62, 39, '2016-02-01 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (65, 62, 54, '2017-03-30 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (66, 62, 31, '2017-08-29 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (67, 83, 53, '2016-06-08 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (68, 85, 28, '2016-01-21 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (69, 62, 28, '2017-01-26 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (70, 62, 28, '2017-02-11 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (71, 62, 43, '2016-04-22 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (72, 62, 3, '2016-02-21 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (73, 87, 14, '2017-02-10 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (74, 81, 12, '2016-09-09 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (75, 85, 28, '2017-02-18 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (76, 62, 39, '2016-02-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (77, 81, 51, '2015-12-09 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (78, 81, 8, '2016-02-29 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (79, 62, 42, '2017-06-22 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (80, 85, 19, '2016-01-17 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (81, 83, 17, '2016-09-26 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (82, 63, 33, '2015-11-28 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (83, 89, 38, '2016-06-10 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (84, 62, 28, '2016-12-27 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (85, 85, 34, '2017-07-08 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (86, 62, 52, '2015-09-23 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (87, 88, 14, '2016-12-31 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (88, 81, 28, '2016-06-08 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (89, 81, 51, '2016-08-05 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (90, 87, 28, '2015-11-02 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (91, 63, 6, '2017-07-23 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (92, 62, 31, '2017-04-10 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (93, 62, 28, '2016-01-01 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (94, 62, 23, '2016-03-28 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (95, 62, 50, '2016-02-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (96, 83, 39, '2016-05-02 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (97, 90, 28, '2016-07-20 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (98, 62, 1, '2015-10-10 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (99, 87, 11, '2016-09-24 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (100, 62, 24, '2016-03-30 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (101, 89, 17, '2016-12-10 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (102, 62, 42, '2016-08-30 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (103, 83, 28, '2016-01-13 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (104, 88, 19, '2016-02-17 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (105, 88, 50, '2016-11-02 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (106, 88, 33, '2016-09-24 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (107, 81, 39, '2016-01-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (108, 89, 26, '2017-08-25 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (109, 89, 10, '2016-05-12 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (110, 62, 40, '2015-11-30 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (111, 85, 14, '2015-10-23 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (112, 83, 6, '2017-08-05 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (113, 90, 50, '2017-01-15 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (114, 63, 7, '2015-09-18 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (115, 63, 26, '2016-06-05 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (116, 86, 42, '2015-12-10 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (117, 62, 18, '2016-07-25 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (118, 87, 43, '2016-04-08 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (119, 87, 32, '2016-12-04 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (120, 89, 8, '2017-05-31 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (121, 63, 28, '2016-03-17 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (122, 87, 42, '2017-09-03 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (123, 62, 28, '2017-01-04 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (124, 88, 26, '2017-06-25 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (125, 63, 16, '2016-11-09 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (126, 88, 40, '2016-05-13 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (127, 62, 42, '2016-08-06 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (128, 81, 17, '2016-06-11 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (129, 87, 29, '2017-09-09 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (130, 62, 28, '2017-06-05 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (131, 85, 30, '2015-12-02 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (132, 85, 50, '2016-10-25 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (133, 90, 28, '2017-04-26 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (134, 85, 17, '2016-01-16 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (135, 63, 8, '2016-01-28 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (136, 81, 22, '2017-05-23 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (137, 90, 39, '2017-07-12 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (138, 90, 50, '2017-01-22 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (139, 86, 43, '2017-02-25 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (140, 62, 4, '2017-07-14 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (141, 62, 3, '2016-02-21 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (142, 62, 34, '2017-05-13 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (143, 62, 8, '2017-05-23 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (144, 83, 38, '2016-02-17 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (145, 62, 14, '2017-05-14 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (146, 83, 2, '2016-01-19 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (147, 86, 9, '2015-12-10 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (148, 62, 28, '2017-03-17 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (149, 62, 42, '2017-04-14 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (150, 90, 20, '2017-01-02 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (151, 62, 28, '2015-10-06 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (152, 88, 26, '2016-05-25 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (153, 89, 14, '2015-10-20 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (154, 62, 35, '2015-11-18 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (155, 63, 50, '2016-01-17 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (156, 87, 25, '2017-04-05 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (157, 62, 39, '2016-03-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (158, 62, 36, '2016-02-12 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (159, 63, 32, '2016-02-05 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (160, 83, 28, '2017-03-06 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (161, 88, 37, '2015-12-31 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (162, 90, 35, '2015-10-26 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (163, 81, 19, '2015-10-17 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (164, 83, 30, '2017-01-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (165, 62, 12, '2017-04-28 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (166, 81, 49, '2016-12-04 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (167, 81, 24, '2016-07-12 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (168, 62, 21, '2017-04-07 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (169, 90, 54, '2016-06-04 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (170, 62, 31, '2016-11-16 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (171, 62, 28, '2017-01-24 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (172, 62, 23, '2016-01-13 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (173, 63, 42, '2015-11-16 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (174, 62, 39, '2016-10-16 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (175, 85, 22, '2016-12-11 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (176, 63, 5, '2016-11-24 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (177, 62, 10, '2016-06-19 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (178, 81, 8, '2016-02-15 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (179, 63, 28, '2016-10-25 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (180, 86, 28, '2017-03-04 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (181, 62, 28, '2016-12-07 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (182, 90, 14, '2016-11-21 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (183, 62, 50, '2016-07-15 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (184, 85, 24, '2016-01-12 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (185, 87, 42, '2015-11-19 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (186, 62, 9, '2017-01-03 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (187, 83, 10, '2016-04-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (188, 63, 12, '2016-08-07 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (189, 81, 27, '2017-06-16 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (190, 90, 22, '2017-09-06 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (191, 62, 42, '2017-01-13 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (192, 83, 11, '2017-06-05 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (193, 85, 10, '2016-01-31 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (194, 86, 42, '2017-01-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (195, 62, 17, '2016-05-06 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (196, 62, 18, '2015-11-23 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (197, 63, 12, '2016-07-30 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (198, 62, 28, '2017-08-23 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (199, 62, 53, '2016-05-08 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (200, 62, 6, '2015-10-06 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (201, 87, 26, '2015-11-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (202, 85, 14, '2016-03-13 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (203, 62, 42, '2016-10-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (204, 62, 18, '2016-08-09 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (205, 62, 28, '2016-10-11 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (206, 63, 23, '2015-12-30 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (207, 83, 34, '2017-01-05 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (208, 62, 7, '2016-01-20 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (209, 63, 33, '2016-04-21 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (210, 88, 41, '2016-03-21 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (211, 62, 15, '2016-11-11 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (212, 83, 42, '2016-04-22 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (213, 85, 21, '2017-06-24 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (214, 90, 12, '2015-10-25 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (215, 90, 34, '2016-04-18 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (216, 89, 23, '2016-04-21 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (217, 62, 50, '2015-09-22 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (218, 86, 28, '2015-12-26 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (219, 62, 38, '2017-02-26 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (220, 62, 28, '2016-09-24 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (221, 89, 20, '2016-01-30 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (222, 89, 5, '2015-11-18 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (223, 85, 3, '2016-09-06 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (224, 83, 50, '2017-02-24 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (225, 62, 5, '2015-12-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (226, 86, 38, '2016-04-26 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (227, 86, 42, '2016-07-18 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (228, 85, 33, '2016-05-18 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (229, 86, 19, '2017-08-19 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (230, 62, 21, '2016-10-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (231, 62, 42, '2016-11-08 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (232, 87, 9, '2017-04-10 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (233, 90, 49, '2016-06-23 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (234, 88, 22, '2016-08-27 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (235, 62, 28, '2016-05-08 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (236, 62, 50, '2016-01-02 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (237, 90, 5, '2017-07-18 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (238, 62, 54, '2016-04-10 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (239, 85, 39, '2017-05-23 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (240, 87, 9, '2016-06-05 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (241, 83, 17, '2016-04-11 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (242, 62, 22, '2017-06-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (243, 81, 4, '2015-09-17 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (244, 63, 50, '2017-05-08 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (245, 85, 49, '2017-06-06 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (246, 83, 15, '2016-07-12 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (247, 63, 28, '2016-09-16 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (248, 83, 17, '2016-11-14 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (249, 90, 38, '2017-06-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (250, 63, 1, '2017-01-21 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (251, 83, 19, '2017-05-12 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (252, 62, 28, '2016-08-29 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (253, 63, 41, '2017-08-31 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (254, 90, 52, '2017-06-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (255, 89, 39, '2017-07-30 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (256, 81, 10, '2016-10-05 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (257, 62, 27, '2017-07-06 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (258, 62, 38, '2016-09-30 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (259, 62, 42, '2017-05-08 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (260, 85, 27, '2016-01-09 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (261, 62, 53, '2017-04-19 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (262, 81, 16, '2016-03-08 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (263, 83, 26, '2016-07-30 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (264, 90, 38, '2016-05-21 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (265, 90, 36, '2016-01-14 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (266, 81, 29, '2017-05-31 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (267, 87, 10, '2017-02-20 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (268, 63, 40, '2017-02-09 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (269, 85, 28, '2016-08-13 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (270, 83, 13, '2017-02-18 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (271, 89, 28, '2017-06-20 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (272, 87, 30, '2015-09-17 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (273, 62, 50, '2017-07-27 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (274, 83, 27, '2016-11-25 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (275, 63, 50, '2016-06-23 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (276, 62, 37, '2016-01-17 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (277, 63, 28, '2017-06-13 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (278, 62, 9, '2015-11-08 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (279, 63, 15, '2016-06-01 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (280, 86, 29, '2017-03-26 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (281, 62, 22, '2015-12-21 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (282, 85, 4, '2017-03-04 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (283, 62, 31, '2017-08-27 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (284, 62, 7, '2017-09-14 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (285, 62, 10, '2017-01-30 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (286, 89, 23, '2017-08-06 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (287, 89, 54, '2016-02-06 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (288, 89, 21, '2016-11-01 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (289, 86, 28, '2017-08-12 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (290, 88, 27, '2016-10-05 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (291, 88, 42, '2017-05-13 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (292, 83, 34, '2017-05-16 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (293, 62, 42, '2017-04-30 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (294, 83, 21, '2016-08-04 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (295, 87, 17, '2016-04-30 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (296, 85, 42, '2015-09-16 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (297, 62, 51, '2015-11-24 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (298, 83, 25, '2017-04-17 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (299, 62, 41, '2015-11-08 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (300, 83, 2, '2017-05-22 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (301, 85, 23, '2016-04-28 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (302, 62, 27, '2015-12-25 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (303, 62, 53, '2017-03-22 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (304, 81, 18, '2017-02-17 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (305, 87, 19, '2015-09-23 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (306, 85, 22, '2016-12-03 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (307, 83, 50, '2017-01-09 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (308, 86, 29, '2017-08-15 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (309, 81, 17, '2015-11-02 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (310, 62, 9, '2016-11-18 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (311, 87, 15, '2017-06-02 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (312, 83, 50, '2016-06-12 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (313, 87, 39, '2016-01-16 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (314, 85, 28, '2017-09-12 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (315, 86, 28, '2017-08-29 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (316, 90, 37, '2016-02-06 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (317, 87, 4, '2016-04-28 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (318, 83, 33, '2016-06-29 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (319, 85, 54, '2015-11-09 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (320, 86, 17, '2016-11-15 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (321, 83, 26, '2017-02-13 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (322, 62, 50, '2016-02-23 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (323, 62, 34, '2016-07-22 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (324, 62, 9, '2016-10-22 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (325, 62, 13, '2016-07-20 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (326, 83, 28, '2016-08-08 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (327, 83, 2, '2016-10-25 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (328, 62, 15, '2015-11-04 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (329, 88, 6, '2017-01-23 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (330, 90, 1, '2016-05-21 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (331, 87, 17, '2017-03-03 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (332, 90, 41, '2017-03-02 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (333, 62, 8, '2017-05-29 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (334, 63, 42, '2016-04-15 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (335, 83, 10, '2017-07-04 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (336, 62, 50, '2017-02-06 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (337, 83, 20, '2015-10-21 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (338, 83, 22, '2016-09-29 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (339, 62, 7, '2017-06-22 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (340, 62, 50, '2016-12-17 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (341, 62, 19, '2017-05-25 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (342, 62, 41, '2015-12-11 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (343, 62, 10, '2016-06-02 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (344, 90, 10, '2015-11-01 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (345, 62, 49, '2016-11-17 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (346, 81, 13, '2017-06-11 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (347, 81, 34, '2016-03-20 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (348, 62, 12, '2017-05-10 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (349, 62, 21, '2016-10-21 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (350, 62, 42, '2016-02-23 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (351, 88, 18, '2017-08-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (352, 63, 17, '2016-05-02 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (353, 62, 28, '2016-11-23 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (354, 88, 6, '2016-06-08 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (355, 90, 48, '2016-07-06 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (356, 87, 33, '2016-04-01 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (357, 87, 33, '2015-10-19 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (358, 83, 22, '2016-11-25 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (359, 88, 43, '2017-06-17 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (360, 85, 30, '2016-08-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (361, 62, 11, '2017-01-02 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (362, 83, 32, '2017-05-19 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (363, 62, 1, '2016-05-18 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (364, 87, 39, '2016-05-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (365, 62, 41, '2016-09-18 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (366, 63, 10, '2015-12-05 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (367, 83, 17, '2016-11-04 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (368, 63, 37, '2015-11-09 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (369, 83, 31, '2016-01-04 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (370, 89, 28, '2017-08-18 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (371, 63, 25, '2017-07-11 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (372, 63, 52, '2016-04-30 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (373, 62, 7, '2017-06-21 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (374, 62, 14, '2016-07-27 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (375, 90, 31, '2017-06-23 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (376, 86, 37, '2016-12-01 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (377, 89, 28, '2016-06-21 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (378, 87, 42, '2017-02-22 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (379, 90, 2, '2015-10-08 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (380, 85, 1, '2017-05-25 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (381, 83, 30, '2016-05-09 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (382, 83, 4, '2017-02-04 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (383, 89, 14, '2017-03-01 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (384, 62, 49, '2016-04-25 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (385, 62, 14, '2016-06-28 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (386, 62, 28, '2016-07-09 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (387, 62, 35, '2016-07-08 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (388, 89, 34, '2016-07-20 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (389, 62, 28, '2016-10-21 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (390, 62, 49, '2017-08-02 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (391, 90, 28, '2015-12-16 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (392, 85, 34, '2015-10-07 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (393, 62, 28, '2016-10-14 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (394, 81, 4, '2017-02-02 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (395, 62, 38, '2016-04-20 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (396, 88, 49, '2016-10-11 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (397, 81, 52, '2016-04-26 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (398, 85, 23, '2016-09-26 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (399, 88, 1, '2016-01-13 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (400, 62, 28, '2016-04-23 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (401, 62, 38, '2017-07-17 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (402, 85, 37, '2016-04-09 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (403, 88, 40, '2016-06-18 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (404, 88, 28, '2017-04-18 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (405, 62, 15, '2017-08-16 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (406, 62, 36, '2015-10-13 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (407, 83, 39, '2016-05-22 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (408, 85, 31, '2015-11-25 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (409, 87, 7, '2017-01-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (410, 63, 34, '2016-07-14 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (411, 63, 33, '2016-12-31 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (412, 83, 50, '2016-08-02 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (413, 63, 42, '2016-02-21 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (414, 90, 42, '2017-03-03 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (415, 85, 28, '2016-09-25 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (416, 62, 8, '2017-09-15 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (417, 89, 22, '2016-08-31 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (418, 87, 36, '2016-05-06 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (419, 83, 15, '2016-11-17 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (420, 86, 4, '2016-05-08 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (421, 63, 17, '2016-11-12 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (422, 83, 5, '2015-10-14 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (423, 81, 5, '2017-04-07 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (424, 83, 11, '2017-06-27 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (425, 62, 22, '2016-06-29 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (426, 83, 43, '2016-10-13 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (427, 86, 28, '2016-07-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (428, 62, 50, '2017-05-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (429, 62, 23, '2016-12-18 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (430, 62, 52, '2017-07-17 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (431, 63, 17, '2017-06-10 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (432, 85, 21, '2017-07-15 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (433, 85, 14, '2017-01-29 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (434, 85, 35, '2017-07-18 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (435, 62, 9, '2016-12-17 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (436, 62, 10, '2016-08-29 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (437, 88, 17, '2016-09-01 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (438, 85, 22, '2017-01-16 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (439, 81, 28, '2017-01-20 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (440, 62, 51, '2016-05-22 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (441, 62, 48, '2016-05-25 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (442, 83, 50, '2016-12-17 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (443, 90, 6, '2016-08-24 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (444, 88, 38, '2017-06-18 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (445, 89, 34, '2015-10-31 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (446, 62, 31, '2015-10-18 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (447, 62, 17, '2016-08-24 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (448, 90, 50, '2016-03-14 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (449, 62, 8, '2017-07-06 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (450, 81, 50, '2017-03-05 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (451, 81, 27, '2017-06-02 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (452, 83, 28, '2016-10-16 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (453, 62, 3, '2015-10-29 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (454, 62, 23, '2016-08-16 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (455, 86, 24, '2016-02-05 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (456, 83, 38, '2016-02-22 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (457, 89, 38, '2016-06-10 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (458, 81, 34, '2016-03-29 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (459, 83, 30, '2017-08-24 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (460, 62, 33, '2017-01-17 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (461, 62, 13, '2016-08-03 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (462, 83, 17, '2016-04-12 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (463, 63, 34, '2015-11-21 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (464, 63, 17, '2017-03-19 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (465, 86, 42, '2017-07-25 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (466, 85, 10, '2016-06-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (467, 62, 33, '2017-05-15 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (468, 86, 17, '2016-04-21 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (469, 62, 12, '2016-09-02 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (470, 90, 42, '2017-08-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (471, 62, 28, '2017-05-12 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (472, 62, 4, '2016-09-17 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (473, 83, 39, '2016-05-02 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (474, 88, 35, '2015-09-26 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (475, 83, 34, '2017-05-01 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (476, 62, 32, '2016-03-30 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (477, 88, 41, '2017-01-02 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (478, 83, 28, '2017-04-10 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (479, 83, 28, '2017-08-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (480, 62, 28, '2016-07-05 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (481, 87, 37, '2017-04-05 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (482, 62, 49, '2015-10-28 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (483, 86, 28, '2017-04-28 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (484, 62, 50, '2017-04-09 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (485, 62, 15, '2016-07-07 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (486, 83, 28, '2017-04-02 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (487, 83, 17, '2017-08-10 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (488, 81, 48, '2017-04-06 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (489, 62, 28, '2016-01-23 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (490, 88, 41, '2016-08-21 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (491, 62, 38, '2017-02-10 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (492, 62, 26, '2017-01-26 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (493, 88, 32, '2016-11-16 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (494, 62, 10, '2015-12-04 00:00:00', 2);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (495, 90, 7, '2015-12-12 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (496, 90, 6, '2016-03-03 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (497, 88, 9, '2017-03-23 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (498, 88, 29, '2016-11-29 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (499, 87, 50, '2015-11-01 00:00:00', 1);
INSERT INTO `Orders` (`OrderID`, `ShipperID`, `CustomerID`, `DateStarted`, `Quantity`) VALUES (500, 89, 23, '2017-06-04 00:00:00', 2);
# 500 records

#
# Table structure for table 'PaintingGenres'
#

DROP TABLE IF EXISTS `PaintingGenres`;

CREATE TABLE `PaintingGenres` (
  `PaintingGenreID` INTEGER NOT NULL AUTO_INCREMENT, 
  `PaintingID` INTEGER DEFAULT 0, 
  `GenreID` INTEGER DEFAULT 0, 
  INDEX (`GenreID`), 
  PRIMARY KEY (`PaintingGenreID`), 
  INDEX (`PaintingID`), 
  INDEX (`PaintingGenreID`)
) ENGINE=innodb DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Populating data for table 'PaintingGenres'
#
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (7,5,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (9,7,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (10,8,1);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (13,11,1);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (14,12,1);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (16,14,1);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (17,15,1);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (18,16,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (25,23,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (26,24,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (28,25,1);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (29,26,1);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (32,29,1);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (33,30,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (34,31,1);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (38,35,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (39,36,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (40,37,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (42,39,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (44,41,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (45,42,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (47,45,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (48,46,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (49,47,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (50,48,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (51,49,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (52,50,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (54,52,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (56,54,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (57,55,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (58,56,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (59,57,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (60,58,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (62,60,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (63,61,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (65,63,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (66,64,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (67,65,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (68,66,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (69,67,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (70,68,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (71,70,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (72,71,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (89,88,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (90,89,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (102,101,40);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (103,102,40);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (104,103,40);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (106,105,40);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (115,114,47);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (119,118,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (121,119,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (131,124,47);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (134,139,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (135,140,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (137,142,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (140,145,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (141,146,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (146,152,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (147,153,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (148,154,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (151,157,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (156,162,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (159,165,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (161,167,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (165,171,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (166,172,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (167,173,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (169,178,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (170,179,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (172,181,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (173,182,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (181,190,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (182,191,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (183,192,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (185,194,40);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (186,195,40);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (204,213,47);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (205,214,89);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (213,225,47);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (218,230,47);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (219,231,64);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (220,232,64);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (221,233,64);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (223,235,64);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (243,258,47);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (244,259,47);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (263,287,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (264,288,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (265,290,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (266,291,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (269,294,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (271,296,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (274,299,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (275,300,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (285,310,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (309,339,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (313,342,40);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (314,343,40);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (317,346,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (318,347,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (319,348,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (320,349,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (322,351,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (323,352,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (327,115,47);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (333,51,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (334,77,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (335,78,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (336,79,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (337,80,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (338,81,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (340,83,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (349,301,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (353,69,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (360,366,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (363,369,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (364,370,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (367,373,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (368,374,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (369,375,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (370,376,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (371,377,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (372,378,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (373,379,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (374,380,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (375,381,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (377,383,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (378,384,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (379,384,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (380,386,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (381,386,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (382,387,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (383,387,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (384,388,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (385,388,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (386,389,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (387,389,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (390,391,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (391,391,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (392,392,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (393,392,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (394,393,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (395,393,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (396,394,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (397,394,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (404,398,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (405,398,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (406,399,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (407,399,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (410,401,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (411,401,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (414,403,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (415,403,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (418,405,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (419,405,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (421,406,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (422,406,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (423,407,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (424,407,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (425,408,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (426,408,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (429,412,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (430,413,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (434,417,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (435,418,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (436,419,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (437,420,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (438,422,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (439,423,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (440,424,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (441,425,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (442,426,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (443,427,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (444,428,83);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (446,430,83);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (447,431,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (448,432,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (449,433,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (451,435,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (452,436,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (453,430,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (454,409,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (455,409,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (456,437,83);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (457,438,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (458,439,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (459,439,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (461,435,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (462,436,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (466,441,81);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (468,442,77);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (469,443,77);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (471,445,77);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (474,448,77);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (476,450,80);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (477,451,80);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (479,453,80);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (480,455,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (481,455,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (482,456,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (483,456,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (484,457,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (485,457,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (486,458,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (487,458,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (488,459,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (489,459,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (490,460,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (491,460,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (492,461,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (493,461,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (494,462,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (495,462,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (496,463,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (497,463,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (498,464,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (499,464,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (500,465,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (501,465,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (502,466,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (503,466,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (504,467,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (505,467,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (506,468,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (507,468,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (508,469,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (509,469,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (510,470,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (511,470,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (512,471,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (513,471,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (514,472,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (515,472,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (516,473,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (517,473,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (518,474,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (519,474,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (520,475,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (521,475,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (522,476,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (523,476,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (524,477,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (525,477,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (526,478,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (527,478,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (528,479,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (529,479,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (530,481,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (531,481,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (532,482,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (533,482,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (534,483,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (535,483,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (536,484,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (537,484,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (538,486,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (539,486,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (540,487,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (541,487,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (542,488,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (543,488,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (544,489,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (545,489,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (546,490,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (547,490,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (548,492,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (549,493,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (550,495,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (551,495,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (552,496,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (553,497,83);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (554,498,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (555,499,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (556,500,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (557,501,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (558,502,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (559,504,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (560,505,83);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (561,505,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (562,506,83);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (563,506,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (564,507,83);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (565,507,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (566,508,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (567,509,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (568,510,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (569,511,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (570,512,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (571,513,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (572,514,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (573,515,80);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (574,508,80);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (575,516,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (576,516,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (577,517,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (578,517,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (579,518,83);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (580,519,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (581,520,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (582,521,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (583,522,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (584,523,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (585,524,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (586,524,35);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (587,525,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (588,526,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (589,526,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (590,527,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (591,527,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (592,528,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (593,528,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (594,529,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (595,530,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (596,531,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (597,532,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (598,533,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (599,531,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (600,532,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (601,533,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (602,534,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (603,535,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (604,536,77);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (605,537,77);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (606,538,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (607,539,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (608,540,77);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (609,541,77);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (610,542,77);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (611,543,77);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (612,544,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (613,545,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (614,546,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (615,547,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (616,548,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (617,549,77);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (618,550,77);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (619,551,77);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (620,552,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (621,553,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (622,554,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (623,554,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (624,555,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (625,555,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (626,556,80);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (627,557,83);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (628,557,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (629,558,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (630,559,79);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (631,560,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (632,561,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (633,562,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (634,563,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (635,564,78);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (636,565,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (637,566,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (638,567,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (639,566,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (640,567,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (641,568,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (642,569,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (643,570,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (644,571,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (645,571,64);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (646,572,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (647,572,64);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (648,573,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (649,573,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (650,574,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (651,574,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (652,575,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (653,575,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (654,576,83);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (655,577,83);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (656,577,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (657,578,81);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (658,579,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (659,580,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (660,581,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (661,582,83);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (662,583,47);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (663,584,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (664,585,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (665,585,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (666,586,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (667,587,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (668,587,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (669,588,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (670,589,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (671,590,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (672,591,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (673,592,36);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (674,593,80);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (675,594,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (676,594,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (677,595,76);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (678,595,83);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (679,596,64);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (681,597,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (682,597,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (683,598,81);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (684,599,81);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (685,420,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (686,600,89);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (687,601,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (688,602,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (689,603,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (690,604,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (691,605,33);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (692,606,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (693,607,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (694,608,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (695,609,56);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (696,610,89);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (697,611,89);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (698,612,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (699,612,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (700,613,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (701,613,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (702,614,84);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (703,614,87);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (704,526,89);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (705,527,89);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (706,528,89);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (707,600,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (708,600,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (709,610,88);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (710,610,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (711,611,34);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (712,478,89);
INSERT INTO `PaintingGenres` (`PaintingGenreID`,`PaintingID`,`GenreID`) VALUES (713,479,89);
# 434 records

#
# Table structure for table 'Paintings'
#

DROP TABLE IF EXISTS `Paintings`;

CREATE TABLE `Paintings` (
  `PaintingID` INTEGER NOT NULL AUTO_INCREMENT, 
  `ArtistID` INTEGER DEFAULT 0, 
  `GalleryID` INTEGER, 
  `ImageFileName` VARCHAR(50) NOT NULL, 
  `Title` VARCHAR(255) NOT NULL, 
  `ShapeID` INTEGER, 
  `MuseumLink` VARCHAR(255), 
  `AccessionNumber` VARCHAR(255), 
  `CopyrightText` VARCHAR(255) DEFAULT 'Public domain', 
  `Description` LONGTEXT, 
  `Excerpt` LONGTEXT, 
  `YearOfWork` INTEGER DEFAULT 0, 
  `Width` INTEGER, 
  `Height` INTEGER, 
  `Medium` VARCHAR(255) DEFAULT 'Oil on canvas', 
  `Cost` DECIMAL(19,4) DEFAULT 700, 
  `MSRP` DECIMAL(19,4) DEFAULT 900, 
  `GoogleLink` VARCHAR(255), 
  `GoogleDescription` LONGTEXT, 
  `WikiLink` VARCHAR(255), 
  `JsonAnnotations` LONGTEXT,
  INDEX (`ArtistID`), 
  UNIQUE (`ImageFileName`), 
  INDEX (`GalleryID`), 
  PRIMARY KEY (`PaintingID`), 
  INDEX (`ShapeID`), 
  INDEX (`Title`), 
  INDEX (`PaintingID`)
) ENGINE=innodb DEFAULT CHARSET=utf8;

SET autocommit=1;

INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (5,1,20,'001050','Self-portrait (Yo)',1,'http://www.moma.org/collection/works/80026?locale=en','587.1998','Estate of Pablo Picasso / Artists Rights Society',NULL,NULL,1901,54,32,'Oil on cardboard on panel',125.0000,135.0000,NULL,NULL,'https://en.wikipedia.org/wiki/Yo,_Picasso','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":47,\"green\":53,\"blue\":52},\"web\":\"#2F3534\",\"name\":\"Aztec\"},{\"color\":{\"red\":221,\"green\":184,\"blue\":96},\"web\":\"#DDB860\",\"name\":\"Equator\"},{\"color\":{\"red\":112,\"green\":73,\"blue\":57},\"web\":\"#704939\",\"name\":\"Old Copper\"},{\"color\":{\"red\":138,\"green\":118,\"blue\":80},\"web\":\"#8a7650\",\"name\":\"Shadow\"},{\"color\":{\"red\":216,\"green\":144,\"blue\":67},\"web\":\"#d89043\",\"name\":\"Fire Bush\"},{\"color\":{\"red\":76,\"green\":78,\"blue\":71},\"web\":\"#4C4E47\",\"name\":\"Gravel\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (7,1,7,'001080','Family of Saltimbanques',3,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.46665.html','1963.10.190','Estate of Pablo Picasso/Artists Rights Society','Family of Saltimbanques (La famille de saltimbanques) is a 1905 painting by Pablo Picasso. It is considered the masterpiece of Picasso\'s circus period. The painting depicts six saltimbanques, a kind of itinerant circus performer, in a desolate landscape. The composition groups them together, but they do not seem connected to each other and are not looking at each other.[',' Family of Saltimbanques (La famille de saltimbanques) is a 1905 painting by Pablo Picasso. It is considered the masterpiece of Picasso\'s circus period.',1905,213,230,'Oil on canvas',440.0000,570.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Family_of_Saltimbanques','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":206,\"green\":191,\"blue\":189},\"web\":\"#CEBFBD\",\"name\":\"Alto\"},{\"color\":{\"red\":81,\"green\":47,\"blue\":31},\"web\":\"#512F1F\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":129,\"green\":50,\"blue\":27},\"web\":\"#81321B\",\"name\":\"Burnt Umber\"},{\"color\":{\"red\":213,\"green\":188,\"blue\":170},\"web\":\"#D5BCAA\",\"name\":\"Just Right\"},{\"color\":{\"red\":171,\"green\":155,\"blue\":153},\"web\":\"#847474\",\"name\":\"Bazaar\"},{\"color\":{\"red\":93,\"green\":118,\"blue\":161},\"web\":\"#5d76a1\",\"name\":\"Waikawa Grey\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (8,1,11,'001090','Portrait of Daniel-Henry Kahnweiler',1,'http://www.artic.edu/aic/collections/artwork/111060',NULL,'Estate of Pablo Picasso / Artists Rights Society','In 1907 Picasso joined an art gallery that had recently been opened in Paris by Daniel-Henry Kahnweiler. Kahnweiler was a German art historian, art collector who became one of the premier French art dealers of the 20th century. He was among the first champions of Pablo Picasso, Georges Braque and the Cubism that they jointly developed. Kahnweiler promoted burgeoning artists such as Andre Derain, Kees Van Dongen, Fernand Leger, Juan Gris, Maurice de Vlaminck and several others who had come from all over the globe to live and work in Montparnasse at the time.','In 1907 Picasso joined an art gallery that had recently been opened in Paris by Daniel-Henry Kahnweiler. Kahnweiler was a German art historian, art collector who became one of the premier French art dealers of the 20th century.',1910,101,73,'Oil on canvas',900.0000,1000.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":2,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":67,\"green\":48,\"blue\":27},\"web\":\"#43301B\",\"name\":\"Clinker\"},{\"color\":{\"red\":177,\"green\":151,\"blue\":124},\"web\":\"#B1977C\",\"name\":\"Sandrift\"},{\"color\":{\"red\":99,\"green\":78,\"blue\":54},\"web\":\"#634E36\",\"name\":\"Dallas\"},{\"color\":{\"red\":141,\"green\":117,\"blue\":90},\"web\":\"#8D755A\",\"name\":\"Cement\"},{\"color\":{\"red\":168,\"green\":117,\"blue\":47},\"web\":\"#a8752f\",\"name\":\"Hot Toddy\"},{\"color\":{\"red\":45,\"green\":26,\"blue\":11},\"web\":\"#2D1A0B\",\"name\":\"Cocoa Brown\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (11,1,13,'001130','Self Portrait With A Palette',1,'http://www.philamuseum.org/collections/permanent/50947.html','1950-1-1','Estate of Pablo Picasso / Artists Rights Society','This self-portrait casts the twenty-five-year-old painter as a hardy, athletic figure and sets the stage for the legend of Picasso as the artistic champion of the twentieth century. In preparatory drawings the artist included a brush in his right hand, but he removed it in this final version. Its absence attests to the notion that creative genius is not simply manual dexterity but the expression of an inner vision, here symbolized by the artist\'s intense, staring eyes.','This self-portrait casts the twenty-five-year-old painter as a hardy, athletic figure and sets the stage for the legend of Picasso as the artistic champion of the twentieth century.',1906,92,73,'Oil on canvas',500.0000,800.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":239,\"green\":234,\"blue\":224},\"web\":\"#EFEAE0\",\"name\":\"White Linen\"},{\"color\":{\"red\":112,\"green\":118,\"blue\":123},\"web\":\"#70767B\",\"name\":\"Raven\"},{\"color\":{\"red\":83,\"green\":89,\"blue\":94},\"web\":\"#53595E\",\"name\":\"Fiord\"},{\"color\":{\"red\":197,\"green\":144,\"blue\":103},\"web\":\"#c59067\",\"name\":\"Whiskey\"},{\"color\":{\"red\":148,\"green\":129,\"blue\":110},\"web\":\"#94816e\",\"name\":\"Squirrel\"},{\"color\":{\"red\":232,\"green\":227,\"blue\":215},\"web\":\"#e8e3d7\",\"name\":\"Cararra\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (12,1,6,'001150','Portrait of Gertrude Stein',1,'http://www.metmuseum.org/art/collection/search/488221','47.106','Estate of Pablo Picasso / Artists Rights Society','By 1905 Picasso became a favorite of the American art collectors Leo and Gertrude Stein. Their older brother Michael Stein and his wife Sarah also became collectors of his work. Picasso painted portraits of both Gertrude Stein and her nephew Allan Stein. Gertrude Stein became Picasso\'s principal patron, acquiring his drawings and paintings and exhibiting them in her informal Salon at her home in Paris. At one of her gatherings in 1905, he met Henri Matisse, who was to become a lifelong friend and rival. The Steins introduced him to Claribel Cone and her sister Etta who were American art collectors; they also began to acquire Picasso and Matisse\'s paintings. Eventually Leo Stein moved to Italy, and Michael and Sarah Stein became patrons of Matisse; while Gertrude Stein continued to collect Picasso.','By 1905 Picasso became a favorite of the American art collectors Leo and Gertrude Stein. Their older brother Michael Stein and his wife Sarah also became collectors of his work. Picasso painted portraits of both Gertrude Stein and her nephew Allan Stein.',1907,100,81,'oil on canvas',620.0000,800.0000,NULL,NULL,'http://www.metmuseum.org/Collections/search-the-collections/210008443','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":52,\"green\":49,\"blue\":51},\"web\":\"#343133\",\"name\":\"Melanzane\"},{\"color\":{\"red\":105,\"green\":72,\"blue\":61},\"web\":\"#69483D\",\"name\":\"Spice\"},{\"color\":{\"red\":209,\"green\":189,\"blue\":153},\"web\":\"#D1BD99\",\"name\":\"Vanilla\"},{\"color\":{\"red\":26,\"green\":30,\"blue\":36},\"web\":\"#1A1E24\",\"name\":\"Black Pearl\"},{\"color\":{\"red\":106,\"green\":84,\"blue\":65},\"web\":\"#6A5441\",\"name\":\"Tobacco Brown\"},{\"color\":{\"red\":77,\"green\":53,\"blue\":53},\"web\":\"#4D3535\",\"name\":\"Cocoa Bean\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (14,1,20,'001170','Two Nudes',5,'http://www.moma.org/collection/works/80111?locale=en','621.1959','Estate of Pablo Picasso / Artists Rights Society','The terracotta shades and heavy monumentality of the figures in <em>Two Nudes</em> derive from Picasso\'s interest at the time in the ancient Iberian sculpture of his native Spain. Like many artists in the first decades of the twentieth century, Picasso found ancient and non-western art to be fruitful alternatives both to the prescribed forms of academic painting and the visual culture of industrial modernity. These two women are nearly mirror images, but the face of the figure on the left bears a strong resemblance to that of the figure on the far left in <em>Les Demoiselles d\'Avignon</em>. Like the woman in Demoiselles, with whom she shares her chiseled nose and dark, hollow eyes, this woman holds open what appears to be a curtain and gazes outward, as though beckoning viewers in.','The terracotta shades and heavy monumentality of the figures in <em>Two Nudes</em> derive from Picasso\'s interest at the time in the ancient Iberian sculpture of his native Spain. Like many artists in the first decades of the twentieth century, Picasso found ancient and non-western art to be fruitful alternatives both to the prescribed forms of academic painting and the visual culture of industrial modernity.',1907,151,93,'Oil on canvas',800.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":178,\"green\":146,\"blue\":87},\"web\":\"#B29257\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":68,\"green\":57,\"blue\":33},\"web\":\"#443921\",\"name\":\"Mikado\"},{\"color\":{\"red\":93,\"green\":73,\"blue\":45},\"web\":\"#5D492D\",\"name\":\"Dallas\"},{\"color\":{\"red\":100,\"green\":66,\"blue\":40},\"web\":\"#644228\",\"name\":\"Irish Coffee\"},{\"color\":{\"red\":151,\"green\":106,\"blue\":60},\"web\":\"#976a3c\",\"name\":\"McKenzie\"},{\"color\":{\"red\":140,\"green\":119,\"blue\":85},\"web\":\"#8C7755\",\"name\":\"Cement\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (15,1,24,'001180','Three Women',1,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/28585/?lng=en','9658','Personal non-commercial use','This is one of the most important of Picasso\'s Cubist works. He made about seventy sketches and rough drafts for it. The artist took the traditional subject of the Three Graces and reworked it in his own style.','This is one of the most important of Picasso\'s Cubist works. He made about seventy sketches and rough drafts for it. The artist took the traditional subject of the Three Graces and reworked it in his own style.',1908,200,178,'Oil on canvas',875.0000,1000.0000,NULL,NULL,'http://www.hermitagemuseum.org/html_En/03/hm3_3_1_8c.html','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":161,\"green\":46,\"blue\":32},\"web\":\"#A12E20\",\"name\":\"Brown \"},{\"color\":{\"red\":185,\"green\":90,\"blue\":61},\"web\":\"#B95A3D\",\"name\":\"Smoke Tree\"},{\"color\":{\"red\":100,\"green\":26,\"blue\":27},\"web\":\"#641A1B\",\"name\":\"Pohutukawa\"},{\"color\":{\"red\":222,\"green\":119,\"blue\":62},\"web\":\"#DE773E\",\"name\":\"Jaffa\"},{\"color\":{\"red\":43,\"green\":59,\"blue\":71},\"web\":\"#2b3b47\",\"name\":\"Tarawera\"},{\"color\":{\"red\":98,\"green\":71,\"blue\":65},\"web\":\"#624741\",\"name\":\"Congo Brown\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (16,1,11,'001190','Woman and Child on the Seashore',3,'http://www.artic.edu/aic/collections/artwork/109275',NULL,'Estate of Pablo Picasso / Artists Rights Society','Inspired by ancient art he saw while in Rome, Picasso began painting heavy-set figures in a neoclassical mode. In 1918, having married the Russian dancer Olga Koklova, Picasso was drawn to images of mothers with children.','Inspired by ancient art he saw while in Rome, Picasso began painting heavy-set figures in a neoclassical mode. In 1918, having married the Russian dancer Olga Koklova, Picasso was drawn to images of mothers with children.',1921,143,162,'Oil on canvas',750.0000,900.0000,NULL,NULL,'http://www.artic.edu/aic/collections/exhibitions/modernwing/artwork/109275','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":128,\"green\":114,\"blue\":109},\"web\":\"#80726D\",\"name\":\"Hurricane\"},{\"color\":{\"red\":77,\"green\":41,\"blue\":27},\"web\":\"#4D291B\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":132,\"green\":51,\"blue\":19},\"web\":\"#843313\",\"name\":\"Burnt Umber\"},{\"color\":{\"red\":171,\"green\":159,\"blue\":152},\"web\":\"#AB9F98\",\"name\":\"Del Rio\"},{\"color\":{\"red\":200,\"green\":142,\"blue\":115},\"web\":\"#c88e73\",\"name\":\"Feldspar\"},{\"color\":{\"red\":170,\"green\":75,\"blue\":37},\"web\":\"#aa4b25\",\"name\":\"Rose Of Sharon\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (23,1,7,'001020','The Tragedy',1,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.46671.html','1963.10.196','Estate of Pablo Picasso/Artists Rights Society',NULL,NULL,1903,105,69,'Oil on canvas',430.0000,600.0000,NULL,NULL,'http://www.nga.gov/feature/picasso/technique.shtm','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":45,\"green\":85,\"blue\":111},\"web\":\"#2D556F\",\"name\":\"Chathams Blue\"},{\"color\":{\"red\":85,\"green\":170,\"blue\":221},\"web\":\"#55AADD\",\"name\":\"Picton Blue\"},{\"color\":{\"red\":55,\"green\":131,\"blue\":182},\"web\":\"#3783B6\",\"name\":\"Curious Blue\"},{\"color\":{\"red\":70,\"green\":126,\"blue\":149},\"web\":\"#467E95\",\"name\":\"Jelly Bean\"},{\"color\":{\"red\":28,\"green\":57,\"blue\":81},\"web\":\"#1C3951\",\"name\":\"Regal Blue\"},{\"color\":{\"red\":109,\"green\":193,\"blue\":241},\"web\":\"#6DC1F1\",\"name\":\"Maya Blue\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (24,1,11,'001060','Old Guitarist',1,'http://www.artic.edu/aic/collections/artwork/28067',NULL,'Estate of Pablo Picasso / Artists Rights Society',NULL,NULL,1903,121,82,'Oil on panel',823.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":90,\"green\":89,\"blue\":65},\"web\":\"#5A5941\",\"name\":\"Verdigris\"},{\"color\":{\"red\":104,\"green\":115,\"blue\":76},\"web\":\"#68734C\",\"name\":\"Siam\"},{\"color\":{\"red\":168,\"green\":207,\"blue\":167},\"web\":\"#A8CFA7\",\"name\":\"Zanah\"},{\"color\":{\"red\":116,\"green\":163,\"blue\":151},\"web\":\"#74A397\",\"name\":\"Acapulco\"},{\"color\":{\"red\":88,\"green\":97,\"blue\":63},\"web\":\"#58613F\",\"name\":\"Woodland\"},{\"color\":{\"red\":85,\"green\":128,\"blue\":119},\"web\":\"#558077\",\"name\":\"Breaker Bay\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (25,1,11,'001100','The Glass',5,'http://www.artic.edu/aic/collections/artwork/66159',NULL,'Estate of Pablo Picasso / Artists Rights Society',NULL,NULL,1911,32,17,'Oil on canvas',753.0000,975.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":178,\"green\":150,\"blue\":94},\"web\":\"#B2965E\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":133,\"green\":119,\"blue\":86},\"web\":\"#857756\",\"name\":\"Clay Creek\"},{\"color\":{\"red\":145,\"green\":118,\"blue\":69},\"web\":\"#917645\",\"name\":\"Shadow\"},{\"color\":{\"red\":98,\"green\":87,\"blue\":58},\"web\":\"#62573A\",\"name\":\"West Coast\"},{\"color\":{\"red\":166,\"green\":154,\"blue\":117},\"web\":\"#A69A75\",\"name\":\"Tallow\"},{\"color\":{\"red\":159,\"green\":111,\"blue\":59},\"web\":\"#9F6F3B\",\"name\":\"Buttered Rum\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (26,1,20,'001140','Les Demoiselles d\'Avignon',3,'http://www.moma.org/collection/works/79766?locale=en','333.1939','Estate of Pablo Picasso / Artists Rights Society','Les Demoiselles d\'Avignon (The Young Ladies of Avignon, and originally titled The Brothel of Avignon) is a large oil painting of 1907 by the Spanish artist Pablo Picasso (1881-1973). The work portrays five nude female prostitutes from a brothel in Barcelona. Each figure is depicted in a disconcerting confrontational manner and none are conventionally feminine. The women appear as slightly menacing and rendered with angular and disjointed body shapes. Two are shown with African mask-like faces and three more with faces in the Iberian style of Picasso\'s native Spain, giving them a savage aura. In this adaptation of Primitivism and abandonment of perspective in favor of a flat, two-dimensional picture plane, Picasso makes a radical departure from traditional European painting. The work is widely considered to be seminal in the early development of both cubism and modern art. Demoiselles was revolutionary and controversial, and led to wide anger and disagreement, even amongst his closest associates and friends.','Les Demoiselles d\'Avignon (The Young Ladies of Avignon, and originally titled The Brothel of Avignon) is a large oil painting of 1907 by the Spanish artist Pablo Picasso (1881-1973). The work portrays five nude female prostitutes from a brothel in Barcelona. Each figure is depicted in a disconcerting confrontational manner and none are conventionally feminine. ',1907,244,234,'Oil on canvas',1170.0000,1400.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Les_Demoiselles_d%27Avignon','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":5},\"dominantColors\":[{\"color\":{\"red\":202,\"green\":193,\"blue\":186},\"web\":\"#CAC1BA\",\"name\":\"Pale Slate\"},{\"color\":{\"red\":113,\"green\":72,\"blue\":63},\"web\":\"#71483F\",\"name\":\"Bole\"},{\"color\":{\"red\":163,\"green\":158,\"blue\":152},\"web\":\"#A39E98\",\"name\":\"Mountain Mist\"},{\"color\":{\"red\":204,\"green\":147,\"blue\":138},\"web\":\"#cc938a\",\"name\":\"Oriental Pink\"},{\"color\":{\"red\":190,\"green\":120,\"blue\":107},\"web\":\"#be786b\",\"name\":\"Contessa\"},{\"color\":{\"red\":103,\"green\":123,\"blue\":133},\"web\":\"#677b85\",\"name\":\"Lynch\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (29,1,13,'001260','Three Musicians',3,'http://www.philamuseum.org/collections/permanent/53963','1952-61-96','Estate of Pablo Picasso / Artists Rights Society','Three Musicians is the title of two similar collage and oil paintings by Spanish artist Pablo Picasso. They were both completed in 1921 in Fontainebleau near Paris, France, and exemplify the Synthetic Cubist style. Each painting features a Harlequin, a Pierrot, and a monk, who are generally believed to represent Picasso, Guillaume Apollinaire, and Max Jacob, respectively.','Three Musicians is the title of two similar collage and oil paintings by Spanish artist Pablo Picasso. They were both completed in 1921 in Fontainebleau near Paris, France, and exemplify the Synthetic Cubist style. Each painting features a Harlequin, a Pierrot, and a monk, who are generally believed to represent Picasso, Guillaume Apollinaire, and Max Jacob, respectively.',1921,203,188,'Oil on canvas',430.0000,500.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Three_Musicians','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":218,\"green\":27,\"blue\":23},\"web\":\"#DA1B17\",\"name\":\"Harley Davidson Orange\"},{\"color\":{\"red\":246,\"green\":171,\"blue\":44},\"web\":\"#F6AB2C\",\"name\":\"Lightning Yellow\"},{\"color\":{\"red\":241,\"green\":246,\"blue\":172},\"web\":\"#F1F6AC\",\"name\":\"Australian Mint\"},{\"color\":{\"red\":11,\"green\":60,\"blue\":106},\"web\":\"#0B3C6A\",\"name\":\"Prussian Blue\"},{\"color\":{\"red\":242,\"green\":235,\"blue\":37},\"web\":\"#F2EB25\",\"name\":\"Golden Fizz\"},{\"color\":{\"red\":75,\"green\":36,\"blue\":25},\"web\":\"#4b2419\",\"name\":\"Brown Pod\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (30,1,7,'001270','Lovers',1,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.46667.html','1963.10.192','Estate of Pablo Picasso/Artists Rights Society',NULL,NULL,1923,130,97,'Oil on linen',480.0000,600.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":165,\"green\":94,\"blue\":125},\"web\":\"#A55E7D\",\"name\":\"Strikemaster\"},{\"color\":{\"red\":109,\"green\":155,\"blue\":200},\"web\":\"#6D9BC8\",\"name\":\"Picton Blue\"},{\"color\":{\"red\":192,\"green\":153,\"blue\":54},\"web\":\"#C09936\",\"name\":\"Hokey Pokey\"},{\"color\":{\"red\":219,\"green\":239,\"blue\":239},\"web\":\"#DBEFEF\",\"name\":\"Oyster Bay\"},{\"color\":{\"red\":63,\"green\":93,\"blue\":58},\"web\":\"#3F5D3A\",\"name\":\"Green House\"},{\"color\":{\"red\":197,\"green\":86,\"blue\":57},\"web\":\"#c55639\",\"name\":\"Trinidad\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (31,1,20,'001280','Girl Before a Mirror',1,'http://www.moma.org/collection/works/78311?locale=en','2.1938','Estate of Pablo Picasso / Artists Rights Society','Girl Before a Mirror shows Picasso\'s young mistress Marie-Therese Walter, one of his favorite subjects in the early 1930s. Her white-haloed profile, rendered in a smooth lavender pink, appears serene. But it merges with a more roughly painted, frontal view of her face-a crescent, like the moon, yet intensely yellow, like the sun, and \"made up\" with a gilding of rouge, lipstick, and green eye-shadow. Perhaps the painting suggests both Walter\'s day-self and her night-self, both her tranquility and her vitality, but also the transition from an innocent girl to a worldly woman aware of her own sexuality.','Girl Before a Mirror shows Picasso\'s young mistress Marie-Therese Walter, one of his favorite subjects in the early 1930s. Her white-haloed profile, rendered in a smooth lavender pink, appears serene. ',1932,162,130,'Oil on canvas',800.0000,900.0000,NULL,NULL,'http://www.moma.org/collection/object.php?object_id=78311','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":104,\"green\":116,\"blue\":135},\"web\":\"#687487\",\"name\":\"Raven\"},{\"color\":{\"red\":193,\"green\":187,\"blue\":193},\"web\":\"#C1BBC1\",\"name\":\"Lola\"},{\"color\":{\"red\":117,\"green\":77,\"blue\":61},\"web\":\"#754D3D\",\"name\":\"Old Copper\"},{\"color\":{\"red\":95,\"green\":126,\"blue\":98},\"web\":\"#5F7E62\",\"name\":\"Hippie Green\"},{\"color\":{\"red\":170,\"green\":78,\"blue\":56},\"web\":\"#AA4E38\",\"name\":\"Orange Roughy\"},{\"color\":{\"red\":197,\"green\":184,\"blue\":102},\"web\":\"#c5b866\",\"name\":\"Dark Khaki\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (35,6,16,'006030','La Grande Odalisque',2,'http://www.louvre.fr/en/oeuvre-notices/une-odalisque','R.F. 1158','&copy; Musee du Louvre','Grande Odalisque, also known as Une Odalisque or La Grande Odalisque, is an oil painting of 1814 by Jean Auguste Dominique Ingres depicting an odalisque, or concubine. Ingres\' contemporaries considered the work to signify Ingres\' break from Neoclassicism, indicating a shift toward exotic Romanticism. It attracted wide criticism when it was first shown. It has been especially noted for the elongated proportions and lack of anatomical realism. The work is housed in the Louvre, Paris.','Grande Odalisque, also known as Une Odalisque or La Grande Odalisque, is an oil painting of 1814 by Jean Auguste Dominique Ingres depicting an odalisque, or concubine. Ingres\' contemporaries considered the work to signify Ingres\' break from Neoclassicism, indicating a shift toward exotic Romanticism.',1814,89,163,'Oil on canvas',125.0000,175.0000,NULL,NULL,'http://en.wikipedia.org/wiki/La_Grande_Odalisque','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":5},\"dominantColors\":[{\"color\":{\"red\":16,\"green\":18,\"blue\":23},\"web\":\"#101217\",\"name\":\"Black Russian\"},{\"color\":{\"red\":33,\"green\":53,\"blue\":69},\"web\":\"#213545\",\"name\":\"Blue Whale\"},{\"color\":{\"red\":208,\"green\":191,\"blue\":156},\"web\":\"#D0BF9C\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":94,\"green\":81,\"blue\":58},\"web\":\"#5E513A\",\"name\":\"Metallic Bronze\"},{\"color\":{\"red\":44,\"green\":97,\"blue\":112},\"web\":\"#2C6170\",\"name\":\"Blumine\"},{\"color\":{\"red\":195,\"green\":144,\"blue\":53},\"web\":\"#C39035\",\"name\":\"Hokey Pokey\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (36,7,16,'007020','Liberty Leading the People',3,'http://www.louvre.fr/en/oeuvre-notices/july-28-liberty-leading-people','R.F. 129','&copy; Musee du Louvre','Liberty Leading the People (French: La Liberte guidant le peuple) is a painting by Eugene Delacroix commemorating the July Revolution of 1830, which toppled Charles X of France. A woman personifying Liberty leads the people forward over the bodies of the fallen, holding the tricolor flag of the French Revolution in one hand and brandishing a bayonetted musket with the other. The painting is perhaps Delacroix\'s best-known work.','Liberty Leading the People is a painting by Eugene Delacroix commemorating the July Revolution of 1830, which toppled Charles X of France. A woman personifying Liberty leads the people forward over the bodies of the fallen, holding the tricolor flag of the French Revolution in one hand and brandishing a bayonetted musket with the other. The painting is perhaps Delacroix\'s best-known work.',1830,260,325,'Oil on canvas',625.0000,860.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Liberty_Leading_the_People','{\"safeSearchAnnotation\":{\"violence\":4,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":62,\"green\":49,\"blue\":28},\"web\":\"#3E311C\",\"name\":\"Mikado\"},{\"color\":{\"red\":24,\"green\":22,\"blue\":16},\"web\":\"#181610\",\"name\":\"Maire\"},{\"color\":{\"red\":133,\"green\":118,\"blue\":95},\"web\":\"#85765F\",\"name\":\"Stonewall\"},{\"color\":{\"red\":95,\"green\":81,\"blue\":57},\"web\":\"#5F5139\",\"name\":\"Metallic Bronze\"},{\"color\":{\"red\":70,\"green\":84,\"blue\":92},\"web\":\"#46545c\",\"name\":\"San Juan\"},{\"color\":{\"red\":145,\"green\":63,\"blue\":50},\"web\":\"#913f32\",\"name\":\"Thunderbird\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (37,10,19,'010020','Burial at Ornans',4,'http://www.musee-orsay.fr/en/collections/works-in-focus/search/commentaire/commentaire_id/un-enterrement-a-ornans-130.html','RF 325','&copy; Home','The Burial, one of Courbet\'s most important works, records the funeral of his grandfather which he attended in September 1848. People who attended the funeral were the models for the painting. Previously, models had been used as actors in historical narratives, but in <em>Burial</em> Courbet said he \"painted the very people who had been present at the interment, all the townspeople\". The result is a realistic presentation of them, and of life in Ornans.','The Burial, one of Courbet\'s most important works, records the funeral of his grandfather which he attended in September 1848. People who attended the funeral were the models for the painting. ',1849,314,663,'Oil on canvas',1145.0000,1190.0000,'https://www.google.com/culturalinstitute/beta/asset/a-burial-at-ornans/jwESwQ4qvb87oQ','At the end of summer 1849, Courbet started work on his first monumental painting. He wanted to make it his \"statement of principle\" and made this clear by calling the work Painting of Human Figures, the History of a Burial at Ornans. He took his inspiration from group portraits of Dutch civic guards in the 17th century while the sumptuous blacks recall Spanish art. The nuances of colour in the dark greens and dull greys produces an austere tone, the thick, robust technique gives the people and the natural elements density and weight. The rigorous frieze-like composition and the gaping grave strewn with bones invite us to think about the human condition.','http://en.wikipedia.org/wiki/A_Burial_at_Ornans','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":24,\"green\":20,\"blue\":25},\"web\":\"#181419\",\"name\":\"Blackcurrant\"},{\"color\":{\"red\":128,\"green\":118,\"blue\":87},\"web\":\"#807657\",\"name\":\"Pablo\"},{\"color\":{\"red\":166,\"green\":155,\"blue\":119},\"web\":\"#A69B77\",\"name\":\"Tallow\"},{\"color\":{\"red\":93,\"green\":85,\"blue\":60},\"web\":\"#5D553C\",\"name\":\"Panda\"},{\"color\":{\"red\":204,\"green\":193,\"blue\":156},\"web\":\"#CCC19C\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":103,\"green\":53,\"blue\":31},\"web\":\"#67351f\",\"name\":\"New Amber\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (39,12,36,'012060','Bar at the Folies Bergere',2,'http://courtauld.ac.uk/gallery/collection/impressionism-post-impressionism/edouard-manet-a-bar-at-the-folies-bergere',NULL,'&copy; The Courtauld Gallery','A Bar at the Folies-Bergere (French: Un bar aux Folies Bergère), painted and exhibited at the Paris Salon in 1882, was the last major work by French painter Edouard Manet. It depicts a scene in the Folies Bergere nightclub in Paris.  The painting is filled with contemporaneous details specific to the Folies-Bergere. The distant pair of green feet in the upper left-hand corner belong to a trapeze artist, who is performing above the restaurant\'s patrons.','A Bar at the Folies-Bergere (French: Un bar aux Folies Bergère), painted and exhibited at the Paris Salon in 1882, was the last major work by French painter Edouard Manet. It depicts a scene in the Folies Bergere nightclub in Paris.  The painting is filled with contemporaneous details specific to the Folies-Bergere. The distant pair of green feet in the upper left-hand corner belong to a trapeze artist, who is performing above the restaurant\'s patrons.',1882,96,130,'Oil on canvas',125.0000,200.0000,NULL,NULL,'http://en.wikipedia.org/wiki/A_Bar_at_the_Folies-Berg%C3%A8re','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":47,\"green\":51,\"blue\":53},\"web\":\"#2F3335\",\"name\":\"Gunmetal\"},{\"color\":{\"red\":156,\"green\":157,\"blue\":149},\"web\":\"#9C9D95\",\"name\":\"Star Dust\"},{\"color\":{\"red\":192,\"green\":149,\"blue\":135},\"web\":\"#c09587\",\"name\":\"Quicksand\"},{\"color\":{\"red\":202,\"green\":105,\"blue\":56},\"web\":\"#ca6938\",\"name\":\"Ecstasy\"},{\"color\":{\"red\":34,\"green\":48,\"blue\":61},\"web\":\"#22303D\",\"name\":\"Midnight\"},{\"color\":{\"red\":114,\"green\":138,\"blue\":105},\"web\":\"#728a69\",\"name\":\"Xanadu\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (41,14,6,'014040','At the Piano',1,'http://www.metmuseum.org/art/collection/search/459112','1975.1.201','Open Access for Scholarly Content','In late 1891 or early 1892 Renoir was invited by the French government to execute a painting for a new museum in Paris, the Musee du Luxembourg, which was to be devoted to the work of living artists. He chose as his subject two girls at the piano. Aware of the intense scrutiny to which his submission would be subjected, Renoir lavished extraordinary care on this project, developing and refining the composition in a series of five canvases. The Lehman painting and the nearly identical version formerly in the collection of Renoir\'s fellow Impressionist Gustave Caillebotte have long been regarded as the most accomplished variants of this intimate and engaging scene of bourgeois domestic life.','Aware of the intense scrutiny to which his submission would be subjected, Renoir lavished extraordinary care on this project, developing and refining the composition in a series of five canvases.',1892,116,90,'Oil on canvas',790.0000,940.0000,'https://www.google.com/culturalinstitute/beta/asset/young-girls-at-the-piano/ZAGwT97hbG0-sg','In the early 1890s, friends and admirers of Renoir took exception to the fact that the French State had never made any official purchase from the painter, then almost fifty years old. In 1892, St├®phane Mallarm├®, who knew and admired the artist, helped by Roger Marx, a young member of the Beaux Arts administration and open to new trends, took steps to bring Impressionist works into the national museums. This was how, following an informal commission from the administration, Young Girls at the Piano was acquired and placed in the Mus├®e du Luxembourg.',NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":131,\"green\":118,\"blue\":89},\"web\":\"#837659\",\"name\":\"Stonewall\"},{\"color\":{\"red\":63,\"green\":51,\"blue\":30},\"web\":\"#3F331E\",\"name\":\"Mikado\"},{\"color\":{\"red\":191,\"green\":194,\"blue\":184},\"web\":\"#BFC2B8\",\"name\":\"Tasman\"},{\"color\":{\"red\":98,\"green\":125,\"blue\":112},\"web\":\"#627D70\",\"name\":\"Cutty Sark\"},{\"color\":{\"red\":205,\"green\":167,\"blue\":144},\"web\":\"#cda790\",\"name\":\"Cameo\"},{\"color\":{\"red\":73,\"green\":111,\"blue\":141},\"web\":\"#496f8d\",\"name\":\"Wedgewood\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (42,16,7,'016070','The Boating Party',2,'https://www.nga.gov/collection/art-object-page.46569.html','1963.10.94','Open Access','This bold composition reveals the influence of the flat, patterned surfaces, simplified color, and unusual angles of Japanese prints, which enjoyed a huge vogue in Paris in the late 1800s. The dark figure of the man compresses the picture onto the flat plane of the canvas, and the horizon is pushed to the top, collapsing a sense of distance. Our higher vantage point gives us an oblique view into the boat. Its form is divided into decorative shapes by the intersection of its horizontal supports.','This bold composition reveals the influence of the flat, patterned surfaces, simplified color, and unusual angles of Japanese prints, which enjoyed a huge vogue in Paris in the late 1800s. ',1893,117,90,'Oil on canvas',1225.0000,1300.0000,'https://artsandculture.google.com/asset/5wGHW8o0QOcQ3g','','https://en.wikipedia.org/wiki/The_Boating_Party','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":151,\"green\":162,\"blue\":90},\"web\":\"#97A25A\",\"name\":\"Green Smoke\"},{\"color\":{\"red\":190,\"green\":145,\"blue\":128},\"web\":\"#BE9180\",\"name\":\"Quicksand\"},{\"color\":{\"red\":122,\"green\":127,\"blue\":117},\"web\":\"#7A7F75\",\"name\":\"Camouflage Green\"},{\"color\":{\"red\":14,\"green\":26,\"blue\":41},\"web\":\"#0E1A29\",\"name\":\"Black Pearl\"},{\"color\":{\"red\":57,\"green\":96,\"blue\":109},\"web\":\"#39606D\",\"name\":\"Blumine\"},{\"color\":{\"red\":150,\"green\":179,\"blue\":137},\"web\":\"#96b389\",\"name\":\"Mantle\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (45,17,19,'017020','Women in the Garden',1,'http://www.musee-orsay.fr/en/collections/works-in-focus/search/commentaire/commentaire_id/femmes-au-jardin-343.html','RF 2773','&copy; Home','Women in the Garden (French: Femmes au jardin) is an oil painting begun in 1866 by French artist Claude Monet when he was 26. It is a large work painted en plein air; the size of the canvas necessitated Monet painting its upper half with the canvas lowered into a trench he had dug, so that he could maintain a single point of view for the entire work. The setting is the garden of a property he was renting. His companion Camille posed for the figures. Monet finished the work indoors, and used magazine illustrations to render fashionable clothing','The setting is the garden of a property he was renting. His companion Camille posed for the figures. Monet finished the work indoors, and used magazine illustrations to render fashionable clothing',1866,205,255,'Oil on canvas',850.0000,1050.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Women_in_the_Garden','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":93,\"green\":81,\"blue\":61},\"web\":\"#5D513D\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":205,\"green\":195,\"blue\":172},\"web\":\"#CDC3AC\",\"name\":\"Parchment\"},{\"color\":{\"red\":126,\"green\":115,\"blue\":94},\"web\":\"#7E735E\",\"name\":\"Stonewall\"},{\"color\":{\"red\":184,\"green\":186,\"blue\":180},\"web\":\"#b8bab4\",\"name\":\"Tasman\"},{\"color\":{\"red\":171,\"green\":180,\"blue\":195},\"web\":\"#abb4c3\",\"name\":\"Echo Blue\"},{\"color\":{\"red\":122,\"green\":130,\"blue\":89},\"web\":\"#7a8259\",\"name\":\"Finch\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (46,17,11,'017030','Stacks of Wheat (End of Summer)',2,'http://www.artic.edu/aic/collections/artwork/64818',NULL,'Rights-Managed (RM)','The monumental stacks that Claude Monet depicted in his series Stacks of Wheat rose fifteen to twenty feet and stood just outside the artist\'s farmhouse at Giverny. Through 1890 and 1891, he worked on this series both in the field, painting simultaneously at several easels, and in the studio, refining pictorial harmonies. In May 1891, Monet hung fifteen of these canvases next to each other in one small room in the Galerie Durand-Ruel in Paris. An unprecedented critical and financial success, the exhibition marked a breakthrough in Monet\'s career, as well as in the history of French art.','The monumental stacks that Claude Monet depicted in his series Stacks of Wheat rose fifteen to twenty feet and stood just outside the artist\'s farmhouse at Giverny.',1891,60,100,'Oil on canvas',1200.0000,1500.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":74,\"green\":89,\"blue\":23},\"web\":\"#4A5917\",\"name\":\"Verdun Green\"},{\"color\":{\"red\":47,\"green\":61,\"blue\":5},\"web\":\"#2F3D05\",\"name\":\"Turtle Green\"},{\"color\":{\"red\":100,\"green\":81,\"blue\":22},\"web\":\"#645116\",\"name\":\"Bronze Olive\"},{\"color\":{\"red\":104,\"green\":119,\"blue\":50},\"web\":\"#687732\",\"name\":\"Rain Forest\"},{\"color\":{\"red\":116,\"green\":75,\"blue\":28},\"web\":\"#744B1C\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":128,\"green\":111,\"blue\":50},\"web\":\"#806F32\",\"name\":\"Pesto\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (47,17,6,'017070','The Houses of Parliament (Effect of Fog)',3,'http://www.metmuseum.org/art/collection/search/437128','56.135.6','Open Access for Scholarly Content','In the fall of 1899 and the early months of 1900 and of 1901, Monet executed a series of views of the Thames River in London. From his room at the Savoy Hotel, he painted Waterloo Bridge to the east, and Charing Cross Bridge to the west; beginning in February 1900, he set up his easel on a terrace at Saint Thomas\'s Hospital across the river, reserving time in the late afternoon to depict the Houses of Parliament.\r\n\r\nWhile in London, Monet produced nearly a hundred canvases, reportedly moving from one to another as the light changed. He continued to work on these paintings in his studio at Giverny. In May 1904, thirty-seven were exhibited at the Galerie Durand-Ruel in Paris, including this view of the Houses of Parliament cloaked in dense fog.','In the fall of 1899 and the early months of 1900 and of 1901, Monet executed a series of views of the Thames River in London. From his room at the Savoy Hotel, he painted Waterloo Bridge to the east, and Charing Cross Bridge to the west; beginning in February 1900, he set up his easel on a terrace at Saint Thomas\'s Hospital across the river, reserving time in the late afternoon to depict the Houses of Parliament.',1903,81,92,'Oil on canvas',750.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/houses-of-parliament-in-the-fog/owEEr48qDGwjqQ','Monet continued to record fleeting effects of light and atmosphere long after many of his fellow Impressionists had abandoned the practice. Around 1890 he began to paint multiple versions of the same motif. Around the turn of the century Monet was working in London and painted a series of views of the Houses of Parliament as seen from a balcony of Saint ThomasÔÇÖs hospital directly across the River Thames. As is typical of MonetÔÇÖs late work, this composition, which has no suggestion of depth and features very free brushwork, verges on abstraction.','http://www.metmuseum.org/collections/search-the-collections/110001576','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":36,\"green\":61,\"blue\":80},\"web\":\"#243D50\",\"name\":\"Nile Blue\"},{\"color\":{\"red\":94,\"green\":106,\"blue\":111},\"web\":\"#5e6a6f\",\"name\":\"Pale Sky\"},{\"color\":{\"red\":53,\"green\":79,\"blue\":95},\"web\":\"#354f5f\",\"name\":\"Cello\"},{\"color\":{\"red\":132,\"green\":109,\"blue\":91},\"web\":\"#846d5b\",\"name\":\"Donkey Brown\"},{\"color\":{\"red\":154,\"green\":101,\"blue\":63},\"web\":\"#9a653f\",\"name\":\"Desert\"},{\"color\":{\"red\":109,\"green\":110,\"blue\":102},\"web\":\"#6d6e66\",\"name\":\"Finch\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (48,17,6,'017060','Water Lilies',4,'http://www.metmuseum.org/art/collection/search/438008','1998.325.2','Open Access for Scholarly Content','Monet left much of his late work unfinished and released few paintings for sale, reporting that he was not yet satisfied and was still working on them \"with passion.\" This canvas is one of four water-lily pictures that, quite exceptionally, he did complete, sign, and sell in 1919.','Monet left much of his late work unfinished and released few paintings for sale, reporting that he was not yet satisfied and was still working on them \"with passion.\" This canvas is one of four water-lily pictures that, quite exceptionally, he did complete, sign, and sell in 1919.',1919,101,200,'Oil on canvas',750.0000,900.0000,NULL,NULL,'http://www.metmuseum.org/Collections/search-the-collections/110002464','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":121,\"green\":117,\"blue\":90},\"web\":\"#79755A\",\"name\":\"Kokoda\"},{\"color\":{\"red\":92,\"green\":97,\"blue\":37},\"web\":\"#5C6125\",\"name\":\"Saratoga\"},{\"color\":{\"red\":116,\"green\":116,\"blue\":111},\"web\":\"#74746F\",\"name\":\"Tapa\"},{\"color\":{\"red\":131,\"green\":93,\"blue\":75},\"web\":\"#835d4b\",\"name\":\"Spicy Mix\"},{\"color\":{\"red\":99,\"green\":96,\"blue\":42},\"web\":\"#63602A\",\"name\":\"Costa Del Sol\"},{\"color\":{\"red\":112,\"green\":116,\"blue\":57},\"web\":\"#707439\",\"name\":\"Crete\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (49,17,19,'017050','Rouen Cathedral, Full Sunlight',1,'http://www.musee-orsay.fr/en/collections/index-of-works/notice.html?no_cache=1&nnumid=001285','RF 2002','&copy; Home',NULL,NULL,1894,107,73,'Oil on canvas',1300.0000,4125.0000,NULL,NULL,'https://en.wikipedia.org/wiki/Rouen_Cathedral_(Monet_series)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":183,\"green\":154,\"blue\":70},\"web\":\"#B79A46\",\"name\":\"Roti\"},{\"color\":{\"red\":139,\"green\":59,\"blue\":18},\"web\":\"#8b3b12\",\"name\":\"Saddle Brown\"},{\"color\":{\"red\":178,\"green\":152,\"blue\":87},\"web\":\"#B29857\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":212,\"green\":187,\"blue\":97},\"web\":\"#D4BB61\",\"name\":\"Tacha\"},{\"color\":{\"red\":147,\"green\":119,\"blue\":57},\"web\":\"#937739\",\"name\":\"Corn Harvest\"},{\"color\":{\"red\":106,\"green\":133,\"blue\":138},\"web\":\"#6a858a\",\"name\":\"Gothic\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (50,17,7,'017040','Woman with a Parasol - Madame Monet and Her Son',1,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.61379.html','1983.1.29','Open Access','Woman with a Parasol was painted outdoors, probably in a single session of several hours\' duration. The artist intended the work to convey the feeling of a casual family outing rather than a formal portrait, and used pose and placement to suggest that his wife and son interrupted their stroll while he captured their likenesses. The brevity of the moment portrayed here is conveyed by a repertory of animated brushstrokes of vibrant color, hallmarks of the style Monet was instrumental in forming. Bright sunlight shines from behind Camille to whiten the top of her parasol and the flowing cloth at her back, while colored reflections from the wildflowers below touch her front with yellow.','Woman with a Parasol was painted outdoors, probably in a single session of several hours\' duration.',1875,100,81,'Oil on canvas',500.0000,940.0000,'https://www.google.com/culturalinstitute/beta/asset/woman-with-a-parasol-madame-monet-and-her-son/EwHxeymQQnprMg','With Manet\'s assistance, Monet found lodging in suburban Argenteuil in late 1871, a move that initiated one of the most fertile phases of his career. Impressionism evolved in the late 1860s from a desire to create fullÔÇôscale, multiÔÇôfigure depictions of ordinary people in casual outdoor situations. At its purest, impressionism was attuned to landscape painting, a subject Monet favored. In Woman with a Parasol ÔÇô Madame Monet and Her Son, his skill as a figure painter is equally evident. Contrary to the artificial conventions of academic portraiture, Monet delineated the features of his sitters as freely as their surroundings. The spontaneity and naturalness of the resulting image were praised when it appeared in the second impressionist exhibition in 1876.',NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":135,\"green\":161,\"blue\":182},\"web\":\"#87A1B6\",\"name\":\"Nepal\"},{\"color\":{\"red\":152,\"green\":162,\"blue\":165},\"web\":\"#98A2A5\",\"name\":\"Botticelli\"},{\"color\":{\"red\":188,\"green\":191,\"blue\":187},\"web\":\"#BCBFBB\",\"name\":\"Rainee\"},{\"color\":{\"red\":107,\"green\":125,\"blue\":143},\"web\":\"#6B7D8F\",\"name\":\"Slate Grey\"},{\"color\":{\"red\":80,\"green\":87,\"blue\":68},\"web\":\"#505744\",\"name\":\"Lunar Green\"},{\"color\":{\"red\":106,\"green\":109,\"blue\":59},\"web\":\"#6a6d3b\",\"name\":\"Woodland\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (51,18,50,'018020','Vision of the Sermon',3,'https://www.nationalgalleries.org/object/NG 1643','NG 1643',NULL,'This painting depicts the scene from the Bible in which Jacob wrestles an angel. As if in a modern-day wrestling arena, French women watch the wrestling match from afar. This painting was created during Gaugin\'s stay in Pont-Avon, France, which is where he created his other masterpieces, The Yellow Christ and The Green Christ. This painting also incorporates elements from his Christ series, which also place Breton French women alongside a Biblical scene, placing them as observers in the story. In his typical style, flat areas of color are outlined by thick black lines, and the figures are void of any shading or depth of color.','This painting depicts the scene from the Bible in which Jacob wrestles an angel. As if in a modern-day wrestling arena, French women watch the wrestling match from afar. This painting was created during Gaugin\'s stay in Pont-Avon, France.',1888,74,93,'Oil on canvas',230.0000,290.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Vision_After_the_Sermon','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":174,\"green\":88,\"blue\":80},\"web\":\"#AE5850\",\"name\":\"Apple Blossom\"},{\"color\":{\"red\":199,\"green\":188,\"blue\":182},\"web\":\"#C7BCB6\",\"name\":\"Pale Slate\"},{\"color\":{\"red\":114,\"green\":65,\"blue\":72},\"web\":\"#724148\",\"name\":\"Tosca\"},{\"color\":{\"red\":32,\"green\":22,\"blue\":26},\"web\":\"#20161A\",\"name\":\"Aubergine\"},{\"color\":{\"red\":170,\"green\":161,\"blue\":158},\"web\":\"#AAA19E\",\"name\":\"Martini\"},{\"color\":{\"red\":158,\"green\":106,\"blue\":94},\"web\":\"#9E6A5E\",\"name\":\"u Chico\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (52,18,29,'018030','Self-Portrait with Portrait of Emile Bernard',2,'https://www.vangoghmuseum.nl/en/collection/s0224V1962','s0224V1962','Non commercial use','Gauguin painted himself in the guise of Jean Valjean, the main character of Victor Hugo\'s novel Les Miserables, equating the vibrant and loving fictional outcast with the misunderstood artists of his time.','Gauguin painted himself in the guise of Jean Valjean, the main character of Victor Hugo\'s novel Les Miserables, equating the vibrant and loving fictional outcast with the misunderstood artists of his time.',1888,45,55,'Oil on canvas',250.0000,300.0000,'https://www.google.com/culturalinstitute/beta/asset/self-portrait-with-portrait-of-bernard-les-mis%C3%A9rables/FQFNzW6eTVCpwQ','Paul GauguinÔÇÖs face bears a troubled expression, for the artist has painted himself in the role of Jean Valjean, the protagonist in the Victor Hugo novel Les Mis├®rables. Gauguin compared this fictional hero, a man rejected by society despite his inner power and love, with the misunderstood artists of his own time, including himself.',NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":205,\"green\":150,\"blue\":29},\"web\":\"#CD961D\",\"name\":\"Buttercup\"},{\"color\":{\"red\":191,\"green\":146,\"blue\":121},\"web\":\"#BF9279\",\"name\":\"Pale Taupe\"},{\"color\":{\"red\":116,\"green\":124,\"blue\":104},\"web\":\"#747c68\",\"name\":\"Camouflage Green\"},{\"color\":{\"red\":76,\"green\":89,\"blue\":90},\"web\":\"#4c595a\",\"name\":\"Mako\"},{\"color\":{\"red\":142,\"green\":161,\"blue\":118},\"web\":\"#8ea176\",\"name\":\"Sage\"},{\"color\":{\"red\":158,\"green\":132,\"blue\":236},\"web\":\"#9e846b\",\"name\":\"Sandal\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (54,18,51,'018040','Yellow Christ',3,'https://www.albrightknox.org/collection/search/piece:360/','360','Public Domain','The Yellow Christ, in addition to The Green Christ, also painted by Gaugin, is said to be one of the key works in Cloisonnism. The Christ in the painting is a direct representation of a crucifix in Pont-Avon, France, where Gaugin visited to paint a number of times. It depicts a yellow form of Christ being crucified in 19th century northern France. French Breton women gather around the cross in prayer. The only shading in the painting is of the women bowed in prayer, the figure of Christ on the cross clearly outlined in black, and his form is flat, typical of the Gaugin\'s symbolic style.','The Yellow Christ, in addition to <em>The Green Christ</em>, also painted by Gaugin, is said to be one of the key works in Cloisonnism. The Christ in the painting is a direct representation of a crucifix in Pont-Avon, France, where Gaugin visited to paint a number of times.',1889,92,73,'Oil on canvas',250.0000,300.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Yellow_Christ','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":152,\"green\":120,\"blue\":24},\"web\":\"#987818\",\"name\":\"Hacienda\"},{\"color\":{\"red\":170,\"green\":155,\"blue\":122},\"web\":\"#AA9B7A\",\"name\":\"Tallow\"},{\"color\":{\"red\":180,\"green\":146,\"blue\":21},\"web\":\"#B49215\",\"name\":\"Buddha Gold\"},{\"color\":{\"red\":154,\"green\":105,\"blue\":18},\"web\":\"#9A6912\",\"name\":\"Golden Brown\"},{\"color\":{\"red\":134,\"green\":69,\"blue\":19},\"web\":\"#864513\",\"name\":\"Saddle Brown\"},{\"color\":{\"red\":38,\"green\":49,\"blue\":70},\"web\":\"#263146\",\"name\":\"Bunting\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (55,18,6,'018050','We Greet Thee Mary',3,'http://www.metmuseum.org/art/collection/search/438821','51.112.2','Open Access for Scholarly Content','Before embarking on a series of pictures inspired by Polynesian religious beliefs, Gauguin devoted this, his first major Tahitian canvas, to a Christian theme, describing it in a letter of March 1892: \"An angel with yellow wings reveals Mary and Jesus, both Tahitians, to two Tahitian women, nudes dressed in pareus, a sort of cotton cloth printed with flowers that can be draped from the waist. Very somber, mountainous background and flowering trees . . . a dark violet path and an emerald green foreground, with bananas on the left. I\'m rather happy with it.\" Gauguin based much of the composition on a photograph he owned of a bas-relief in the Javanese temple of Borobudur.','Before embarking on a series of pictures inspired by Polynesian religious beliefs, Gauguin devoted this, his first major Tahitian canvas, to a Christian theme.',1891,114,88,'Oil on canvas',900.0000,1075.0000,'https://www.google.com/culturalinstitute/beta/asset/ia-orana-maria-hail-mary/IAEsSZ2MO1CG2A','Before embarking on a series of pictures inspired by Polynesian religious beliefs, Gauguin devoted this, his first major Tahitian canvas, to a Christian theme, describing it in a letter of March 1892: \"An angel with yellow wings reveals Mary and Jesus, both Tahitians, to two Tahitian women, nudes dressed in pareus, a sort of cotton cloth printed with flowers that can be draped from the waist. Very somber, mountainous background and flowering trees . . . a dark violet path and an emerald green foreground, with bananas on the left. I\'m rather happy with it.\" Gauguin based much of the composition on a photograph he owned of a bas-relief in the Javanese temple of Borobudur.',NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":66,\"green\":88,\"blue\":71},\"web\":\"#425847\",\"name\":\"Goblin\"},{\"color\":{\"red\":179,\"green\":88,\"blue\":63},\"web\":\"#B3583F\",\"name\":\"Tuscany\"},{\"color\":{\"red\":112,\"green\":120,\"blue\":117},\"web\":\"#707875\",\"name\":\"Rolling Stone\"},{\"color\":{\"red\":125,\"green\":121,\"blue\":91},\"web\":\"#7D795B\",\"name\":\"Kokoda\"},{\"color\":{\"red\":160,\"green\":157,\"blue\":129},\"web\":\"#A09D81\",\"name\":\"Grey Olive\"},{\"color\":{\"red\":153,\"green\":155,\"blue\":144},\"web\":\"#999B90\",\"name\":\"Star Dust\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (56,18,49,'018080','Where Do We Come From? What Are We? Where Are We Going?',4,'http://www.mfa.org/collections/object/where-do-we-come-from-what-are-we-where-are-we-going-32558','36.270','Public domain','This is Paul Gaugin\'s most famous painting, and he considered it his masterpiece, and the culmination of his thoughts. In Tahiti, as he was painting his masterpiece, Gaugin declared that he would commit suicide upon its completion. Although this was something he had previously attempted, this was not the case, as the artist died of syphilis in 1903. The painting was meant to be read from right to left, with the three main figures in the painting representing the three questions of the title. The figures are arranged from the beginning stages of life, from young figures with a child, to the middle aged figure in the middle, to the elder figure on the left of the painting. The idol in the background, situated behind the elder figure, represents the Beyond.','This is Paul Gaugin\'s most famous painting, and he considered it his masterpiece, and the culmination of his thoughts. In Tahiti, as he was painting his masterpiece, Gaugin declared that he would commit suicide upon its completion.',1897,139,375,'Oil on canvas',650.0000,800.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Where_Do_We_Come_From%3F_What_Are_We%3F_Where_Are_We_Going%3F','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":137,\"green\":98,\"blue\":44},\"web\":\"#89622c\",\"name\":\"Rusty Nail\"},{\"color\":{\"red\":39,\"green\":88,\"blue\":103},\"web\":\"#275867\",\"name\":\"Chathams Blue\"},{\"color\":{\"red\":142,\"green\":119,\"blue\":63},\"web\":\"#8E773F\",\"name\":\"Corn Harvest\"},{\"color\":{\"red\":225,\"green\":187,\"blue\":96},\"web\":\"#E1BB60\",\"name\":\"Equator\"},{\"color\":{\"red\":24,\"green\":56,\"blue\":76},\"web\":\"#18384C\",\"name\":\"Blue Whale\"},{\"color\":{\"red\":60,\"green\":51,\"blue\":30},\"web\":\"#3C331E\",\"name\":\"Mikado\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (57,19,52,'019010','Self Portrait',1,'https://www.dia.org/art/collection/object/self-portrait-46065','22.13','&copy; Detroit Institute of Arts','\"For want of a better model,\" Van Gogh chose to paint his own portrait on many occasions. While in Paris between 1886 and 1888, Van Gogh lightened his palette under the influence of the brilliant colors of the impressionists, but he soon reserved the use of such light colors to express particular moods. Van Gogh\'s stay in Paris was a relatively happy one, and in this painting, created during the summer of 1887, he portrays himself with an almost light-hearted appearance.','\"For want of a better model,\" Van Gogh chose to paint his own portrait on many occasions. While in Paris between 1886 and 1888, Van Gogh lightened his palette under the influence of the brilliant colors of the impressionists, but he soon reserved the use of such light colors to express particular moods.',1887,35,27,'Oil on canvas',420.0000,550.0000,'https://www.google.com/culturalinstitute/beta/asset/self-portrait/GAHTFEDf6XGHKQ',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":63,\"green\":82,\"blue\":143},\"web\":\"#3F528F\",\"name\":\"Tory Blue\"},{\"color\":{\"red\":91,\"green\":117,\"blue\":172},\"web\":\"#5B75AC\",\"name\":\"San Marino\"},{\"color\":{\"red\":167,\"green\":159,\"blue\":132},\"web\":\"#A79F84\",\"name\":\"Hillary\"},{\"color\":{\"red\":238,\"green\":202,\"blue\":65},\"web\":\"#EECA41\",\"name\":\"Festival\"},{\"color\":{\"red\":121,\"green\":74,\"blue\":25},\"web\":\"#794A19\",\"name\":\"Raw Umber\"},{\"color\":{\"red\":158,\"green\":101,\"blue\":21},\"web\":\"#9E6515\",\"name\":\"Golden Brown\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (58,19,7,'019170','Self-Portrait',1,'https://www.nga.gov/collection/art-object-page.106382.html','1998.74.5','Open Access','This self–portrait is a particularly bold painting, apparently executed in a single sitting without later retouching. Here Van Gogh portrayed himself at work, dressed in his artist\'s smock with his palette and brushes in hand, a guise he had already adopted in two earlier self–portraits. While the pose itself and the intense scrutiny of the artist\'s gaze are hardly unique—one need but think of the occasionally uncompromising self–portraits of Rembrandt—the haunting and haunted quality of the image is distinct. The dark blue–violet of the smock and ground, the vivid orange of his hair and beard, create a startling contrast to the yellow and green of his face and heighten the gauntness of his features in a sallow complexion. The dynamic, even frenzied brushwork lends an uncommon immediacy and expressiveness to his portrayal.','This self–portrait is a particularly bold painting, apparently executed in a single sitting without later retouching. Here Van Gogh portrayed himself at work, dressed in his artist\'s smock with his palette and brushes in hand, a guise he had already adopted in two earlier self–portraits. ',1889,45,58,'Oil on canvas',1250.0000,1350.0000,'https://artsandculture.google.com/asset/self-portrait/zAFdL1SpZE0r-A','','https://commons.wikimedia.org/wiki/File:Vincent_van_Gogh_-_Self-Portrait_-_Google_Art_Project_(719161).jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":48,\"green\":86,\"blue\":110},\"web\":\"#30566E\",\"name\":\"Chathams Blue\"},{\"color\":{\"red\":185,\"green\":194,\"blue\":125},\"web\":\"#B9C27D\",\"name\":\"Pine Glade\"},{\"color\":{\"red\":144,\"green\":116,\"blue\":32},\"web\":\"#907420\",\"name\":\"Corn Harvest\"},{\"color\":{\"red\":67,\"green\":122,\"blue\":139},\"web\":\"#437A8B\",\"name\":\"Jelly Bean\"},{\"color\":{\"red\":206,\"green\":194,\"blue\":127},\"web\":\"#CEC27F\",\"name\":\"Winter Hazel\"},{\"color\":{\"red\":28,\"green\":59,\"blue\":81},\"web\":\"#1C3B51\",\"name\":\"Regal Blue\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (60,19,29,'019050','Sunflowers',1,'https://www.vangoghmuseum.nl/en/collection/s0031V1962','s0031V1962','Non commercial use','Van Gogh\'s paintings of sunflowers are among his most famous. He did them in Arles, in the south of France, in 1888 and 1889. Vincent painted a total of five large canvases with sunflowers in a vase, with three shades of yellow (and nothing else). In this way, he demonstrated that it was possible to create an image with numerous variations of a single colour, without any loss of eloquence.','The sunflower paintings had a special significance for Van Gogh: they communicated gratitude, he wrote.',1889,73,95,'Oil on canvas',1300.0000,1500.0000,'http://www.googleartproject.com/museums/vangogh/sunflowers-24','Van Gogh produced in total five versions of bouquets of sunflowers in vases, all subtly different from each other. His Sunflowers are among his most famous paintings. He made these floral still lifes to decorate the so-called Yellow House in Arles, where initially he had his studio but would later live.','http://en.wikipedia.org/wiki/Sunflowers_(painting)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":154,\"green\":106,\"blue\":6},\"web\":\"#9A6A06\",\"name\":\"Golden Brown\"},{\"color\":{\"red\":185,\"green\":150,\"blue\":21},\"web\":\"#B99615\",\"name\":\"Buddha Gold\"},{\"color\":{\"red\":150,\"green\":124,\"blue\":27},\"web\":\"#967c1b\",\"name\":\"Hacienda\"},{\"color\":{\"red\":133,\"green\":83,\"blue\":2},\"web\":\"#855302\",\"name\":\"Raw Umber\"},{\"color\":{\"red\":118,\"green\":122,\"blue\":20},\"web\":\"#767A14\",\"name\":\"Trendy Green\"},{\"color\":{\"red\":213,\"green\":184,\"blue\":53},\"web\":\"#D5B835\",\"name\":\"Old Gold\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (61,19,29,'019040','Decoration for the Yellow House',2,'https://www.vangoghmuseum.nl/en/collection/s0032V1962','s0032V1962','Non commercial use','The Decoration for the Yellow House was the main project Vincent van Gogh focused on in Arles, from August 1888 until his breakdown the day before Christmas. This Decoration had no pre-defined form or size; the central idea of the Decoration grew step by step, with the progress of his work. Starting with the Sunflowers, portraits were included in the next step. Finally, mid-September 1888, the idea took shape: from this time on he concentrated on size 30 canvases (Toiles de 30), which were all meant to form part of this Decoration','Sunflowers (original title, in French: Tournesols) are the subject of two series of still life paintings by the Dutch painter Vincent van Gogh. The earlier series executed in Paris in 1887 gives the flowers lying on the ground, while the second set executed a year later in Arles shows bouquets of sunflowers in a vase.',1888,72,92,'Oil on canvas',1290.0000,1540.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_D%C3%A9coration_for_the_Yellow_House','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":178,\"green\":158,\"blue\":98},\"web\":\"#B29E62\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":204,\"green\":180,\"blue\":116},\"web\":\"#CCB474\",\"name\":\"Putty\"},{\"color\":{\"red\":144,\"green\":120,\"blue\":64},\"web\":\"#907840\",\"name\":\"Shadow\"},{\"color\":{\"red\":169,\"green\":156,\"blue\":119},\"web\":\"#A99C77\",\"name\":\"Tallow\"},{\"color\":{\"red\":62,\"green\":89,\"blue\":125},\"web\":\"#3e597d\",\"name\":\"Matisse\"},{\"color\":{\"red\":84,\"green\":93,\"blue\":73},\"web\":\"#545d49\",\"name\":\"Cabbage Pont\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (63,19,20,'019070','Starry Night',3,'http://www.moma.org/collection/works/79802?locale=en','472.1941','&copy; Art Resource','In the later part of his life, Van Gogh committed himself to an asylum in Saint Remy de Provence. The Starry Night was the view from the window in Van Gogh\'s sanitarium bedroom. Although it is a night scene, it was painted during the day. The painting is often referred to as Van Gogh\'s magnus opus. As he often sent his works to his brother Theo for his approval, he mailed this one to him in late 1889. He also wrote that he was not so happy about the work, which did not seem complete, as he had originally intended it to simply be a study of the night sky.','In the later part of his life, Van Gogh committed himself to an asylum in Saint Remy de Provence. The Starry Night was the view from the window in Van Gogh\'s sanitarium bedroom. Although it is a night scene, it was painted during the day. ',1889,74,92,'Oil on canvas',1340.0000,1410.0000,'https://www.google.com/culturalinstitute/beta/asset/the-starry-night/bgEuwDxel93-Pg','Van Gogh\'s night sky is a field of roiling energy. Below the exploding stars, the village is a place of quiet order. Connecting earth and sky is the flamelike cypress, a tree traditionally associated with graveyards and mourning. But death was not ominous for van Gogh. \"Looking at the stars always makes me dream,\" he said, \"Why, I ask myself, shouldn\'t the shining dots of the sky be as accessible as the black dots on the map of France? Just as we take the train to get to Tarascon or Rouen, we take death to reach a star.\"','http://en.wikipedia.org/wiki/The_Starry_Night','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":95,\"green\":120,\"blue\":151},\"web\":\"#5F7897\",\"name\":\"Waikawa Grey\"},{\"color\":{\"red\":26,\"green\":30,\"blue\":28},\"web\":\"#1A1E1C\",\"name\":\"Midnight Moss\"},{\"color\":{\"red\":66,\"green\":89,\"blue\":121},\"web\":\"#425979\",\"name\":\"Chambray\"},{\"color\":{\"red\":186,\"green\":187,\"blue\":119},\"web\":\"#babb77\",\"name\":\"Pine Glade\"},{\"color\":{\"red\":61,\"green\":87,\"blue\":134},\"web\":\"#3D5786\",\"name\":\"Fun Blue\"},{\"color\":{\"red\":185,\"green\":163,\"blue\":43},\"web\":\"#b9a32b\",\"name\":\"Earls Green\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (64,19,36,'019060','Self Portrait With Bandaged Ear',1,'http://courtauld.ac.uk/gallery/collection/impressionism-post-impressionism/vincent-van-gogh-self-portrait-with-bandaged-ear',NULL,'&copy; The Courtauld Gallery','This self-portrait was painted shortly after Van Gogh returned home from hospital having mutilated his own ear.','This self-portrait was painted shortly after Van Gogh returned home from hospital having mutilated his own ear.',1889,60,50,'Oil on canvas',250.0000,300.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":41,\"green\":58,\"blue\":36},\"web\":\"#293A24\",\"name\":\"Myrtle\"},{\"color\":{\"red\":44,\"green\":49,\"blue\":42},\"web\":\"#2C312A\",\"name\":\"Oil\"},{\"color\":{\"red\":140,\"green\":45,\"blue\":31},\"web\":\"#8C2D1F\",\"name\":\"\"},{\"color\":{\"red\":229,\"green\":191,\"blue\":104},\"web\":\"#\",\"name\":\"Burnt Umber\"},{\"color\":{\"red\":220,\"green\":102,\"blue\":53},\"web\":\"#dc6635\",\"name\":\"Sorbus\"},{\"color\":{\"red\":64,\"green\":82,\"blue\":53},\"web\":\"#405235\",\"name\":\"Mallard\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (65,19,29,'019080','Wheatfield with Crows',4,'https://www.vangoghmuseum.nl/en/collection/s0149V1962','s0149V1962','Non commercial use','Wheatfield with Crows is a July 1890 painting by Vincent van Gogh. It is commonly but mistakenly stated that this was Van Gogh\'s last painting. Art historians are uncertain as to which painting was Van Gogh\'s last, as no clear historical records exist, but the evidence of his letters suggests that Wheatfield with Crows was completed around 10 July and predates such paintings as Auvers Town Hall on 14 July 1890 and Daubigny\'s Garden.','Wheatfield with Crows is a July 1890 painting by Vincent van Gogh. It is commonly but mistakenly stated that this was Van Gogh\'s last painting.',1890,50,103,'Oil on canvas',300.0000,350.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Wheatfield_with_Crows','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":147,\"green\":114,\"blue\":27},\"web\":\"#93721B\",\"name\":\"Corn Harvest\"},{\"color\":{\"red\":105,\"green\":85,\"blue\":29},\"web\":\"#69551D\",\"name\":\"Horses Neck\"},{\"color\":{\"red\":74,\"green\":127,\"blue\":149},\"web\":\"#4A7F95\",\"name\":\"Jelly Bean\"},{\"color\":{\"red\":34,\"green\":86,\"blue\":135},\"web\":\"#225687\",\"name\":\"Endeavour\"},{\"color\":{\"red\":100,\"green\":99,\"blue\":40},\"web\":\"#646328\",\"name\":\"Costa Del Sol\"},{\"color\":{\"red\":32,\"green\":45,\"blue\":72},\"web\":\"#202d48\",\"name\":\"Bunting\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (66,20,11,'020040','A Sunday Afternoon on the Island of La Grande Jatt',2,'http://www.artic.edu/aic/collections/artwork/27992',NULL,'Rights-Managed (RM)','Seurat spent over two years painting A Sunday Afternoon, focusing meticulously on the landscape of the park. He reworked the original as well as completed numerous preliminary drawings and oil sketches. He would go and sit in the park and make numerous sketches of the various figures in order to perfect their form. He concentrated on the issues of colour, light, and form. ','Seurat spent over two years painting A Sunday Afternoon, focusing meticulously on the landscape of the park. He reworked the original as well as completed numerous preliminary drawings and oil sketches. He would go and sit in the park and make numerous sketches of the various figures in order to perfect their form. He concentrated on the issues of colour, light, and form. ',1884,208,308,'Oil on canvas',425.0000,550.0000,'https://www.google.com/culturalinstitute/beta/asset/a-sunday-on-la-grande-jatte-1884/twGyqq52R-lYpA','In his best-known and largest painting, Georges Seurat depicted people relaxing in a suburban park on an island in the Seine River called La Grande Jatte. The artist worked on the painting in several campaigns, beginning in 1884 with a layer of small horizontal brushstrokes of complementary colors. He later added small dots, also in complementary colors, that appear as solid and luminous forms when seen from a distance.Seurat\'s use of this highly systematic and \"scientific\" technique, subsequently called Pointillism, distinguished his art from the more intuitive approach to painting used by the Impressionists. Although Seurat embraced the subject matter of modern life preferred by artists such as Claude Monet and Pierre-Auguste Renoir, he went beyond their concern for capturing the accidental and instantaneous qualities of light in nature. Seurat sought to evoke permanence by recalling the art of the past, especially Egyptian and Greek sculpture and even Italian Renaissance frescoes. As he explained to the French poet Gustave Kahn, \"The Panathenaeans of Phidias formed a procession. I want to make modern people, in their essential traits, move about as they do on those friezes, and place them on canvases organized by harmonies of color.\" Some contemporary critics, however, found his figures to be less a nod to earlier art history than a commentary on the posturing and artificiality of modern Parisian society.Seurat made the final changes to La Grande Jatte in 1889. He restretched the canvas in order to add a painted border of red, orange, and blue dots that provides a visual transition between the interior of the painting and his specially designed white frame.','http://en.wikipedia.org/wiki/Sunday_Afternoon_on_the_Island_of_La_Grande_Jatte','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":125,\"green\":118,\"blue\":66},\"web\":\"#7D7642\",\"name\":\"Go Ben\"},{\"color\":{\"red\":96,\"green\":89,\"blue\":65},\"web\":\"#605941\",\"name\":\"Millbrook\"},{\"color\":{\"red\":86,\"green\":83,\"blue\":80},\"web\":\"#565350\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":126,\"green\":118,\"blue\":112},\"web\":\"#7E7670\",\"name\":\"Americano\"},{\"color\":{\"red\":117,\"green\":119,\"blue\":64},\"web\":\"#757740\",\"name\":\"Hemlock\"},{\"color\":{\"red\":139,\"green\":121,\"blue\":105},\"web\":\"#8b7969\",\"name\":\"Squirrel\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (67,20,19,'020070','Circus',1,'http://www.musee-orsay.fr/en/collections/works-in-focus/search/commentaire/commentaire_id/cirque-7090.html','RF 2511','&copy; Home',NULL,NULL,1891,185,152,'Oil on canvas',450.0000,500.0000,'https://www.google.com/culturalinstitute/beta/asset/the-circus/agFX4peHSDwt_g','The circus theme was often covered in the 1880\'s, especially by Renoir, Degas and Toulouse-Lautrec. However, The Circus, far from a merely anecdotal rendering of a modern form of entertainment, constitutes one of the most impressive applications of Divisionist theory.',NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":228,\"green\":186,\"blue\":54},\"web\":\"#E4BA36\",\"name\":\"Bright Sun\"},{\"color\":{\"red\":214,\"green\":148,\"blue\":67},\"web\":\"#D69443\",\"name\":\"Fire Bush\"},{\"color\":{\"red\":213,\"green\":201,\"blue\":168},\"web\":\"#D5C9A8\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":144,\"green\":155,\"blue\":185},\"web\":\"#909BB9\",\"name\":\"Rock Blue\"},{\"color\":{\"red\":209,\"green\":68,\"blue\":30},\"web\":\"#D1441E\",\"name\":\"Harley Davidson Orange\"},{\"color\":{\"red\":190,\"green\":142,\"blue\":122},\"web\":\"#BE8E7A\",\"name\":\"Pale Taupe\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (68,21,37,'021010','Mont Sainte-Victoire seen from Bellevue',2,'http://www.barnesfoundation.org/collections/art-collection/object/4672/mont-sainte-victoire-la-montagne-sainte-victoire','BF13','&copy; The Barnes Foundation','Mont Sainte-Victoire seen from Bellevue is a landscape painting dating from around 1885, by the French artist Paul Cezanne. The subject of the painting is the Montagne Sainte-Victoire in Provence in southern France. Cezanne spent a lot of time in Aix-en-Provence at the time, and developed a special relationship with the landscape. This particular mountain, that stood out in the surrounding landscape, he could see from his house, and he painted it in on numerous occasions.','Cezanne spent a lot of time in Aix-en-Provence at the time, and developed a special relationship with the landscape. This particular mountain, that stood out in the surrounding landscape, he could see from his house, and he painted it in on numerous occasions.',1885,73,92,'Oil on canvas',850.0000,900.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Mont_Sainte-Victoire_seen_from_Bellevue','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":178,\"green\":155,\"blue\":93},\"web\":\"#B29B5D\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":222,\"green\":185,\"blue\":91},\"web\":\"#DEB95B\",\"name\":\"Equator\"},{\"color\":{\"red\":111,\"green\":128,\"blue\":62},\"web\":\"#6F803E\",\"name\":\"Dingley\"},{\"color\":{\"red\":64,\"green\":92,\"blue\":57},\"web\":\"#405C39\",\"name\":\"Green House\"},{\"color\":{\"red\":228,\"green\":224,\"blue\":198},\"web\":\"#E4E0C6\",\"name\":\"Travertine\"},{\"color\":{\"red\":208,\"green\":148,\"blue\":64},\"web\":\"#D09440\",\"name\":\"Anzac\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (69,21,13,'021020','Portrait of Madame Cezanne with Loosened Hair',1,'http://www.philamuseum.org/collections/permanent/82555.html','1986-26-1','Public Domain','Portrait of Madame Cezanne with Loosened Hair (or Madame Cezanne with Unbound Hair) is an oil-on-canvas painting by French artist Paul Cezanne, variously dated from the mid 1870s to the early 1890s. Although the model, his wife Hortense Fiquet, was not supportive and did not understand or take an interest her husband\'s work, this is one of forty-four portraits in which she sat for him from 1869, a period during which she progressed from mistress, to wife, to ex-wife. Something of a socialite, Cezanne latterly found Fiquet often fickle and shallow, and once remarked, \"My wife only cares for Switzerland and lemonade\". The sensitivity and depth ascribed to her in this work, is likely drawn from his own personality, projected onto her image.','Although the model, his wife Hortense Fiquet, was not supportive and did not understand or take an interest her husband\'s work, this is one of forty-four portraits in which she sat for him from 1869, a period during which she progressed from mistress, to wife, to ex-wife.',1869,62,51,'Oil on canvas',750.0000,900.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Portrait_of_Madame_C%C3%A9zanne_with_Loosened_Hair','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":39,\"green\":47,\"blue\":50},\"web\":\"#272F32\",\"name\":\"Oxford Blue\"},{\"color\":{\"red\":135,\"green\":123,\"blue\":106},\"web\":\"#877B6A\",\"name\":\"Sand Dune\"},{\"color\":{\"red\":83,\"green\":87,\"blue\":81},\"web\":\"#535751\",\"name\":\"Battleship Grey\"},{\"color\":{\"red\":118,\"green\":113,\"blue\":103},\"web\":\"#767167\",\"name\":\"Pablo\"},{\"color\":{\"red\":157,\"green\":142,\"blue\":125},\"web\":\"#9D8E7D\",\"name\":\"Heathered Grey\"},{\"color\":{\"red\":150,\"green\":132,\"blue\":116},\"web\":\"#968474\",\"name\":\"Almond Frost\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (70,21,6,'021070','Card Players',3,'http://www.metmuseum.org/art/collection/search/435868','61.101.1','Open Access for Scholarly Content','The Card Players is a series of oil paintings from the French Post-Impressionist artist Paul Cezanne. Painted during Cezanne\'s final period in the early 1890s, there are five paintings in the series. The versions vary in size and in the number of players depicted. The series is considered by critics to be a cornerstone of Cezanne\'s work during the early-to-mid 1890s period, as well as a \"prelude\" to his final years, when he painted some of his most acclaimed work.','The Card Players is a series of oil paintings from the French Post-Impressionist artist Paul Cezanne. Painted during Cezanne\'s final period in the early 1890s, there are five paintings in the series.',1890,134,182,'Oil on canvas',200.0000,275.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Card_Players','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":53,\"green\":52,\"blue\":51},\"web\":\"#353433\",\"name\":\"Acadia \"},{\"color\":{\"red\":143,\"green\":154,\"blue\":153},\"web\":\"#8F9A99\",\"name\":\"Submarine\"},{\"color\":{\"red\":112,\"green\":122,\"blue\":121},\"web\":\"#707A79\",\"name\":\"Rolling Stone\"},{\"color\":{\"red\":39,\"green\":54,\"blue\":72},\"web\":\"#273648\",\"name\":\"Licorice\"},{\"color\":{\"red\":64,\"green\":84,\"blue\":104},\"web\":\"#405468\",\"name\":\"Cello\"},{\"color\":{\"red\":146,\"green\":102,\"blue\":67},\"web\":\"#926643\",\"name\":\"McKenzie\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (71,21,7,'021060','Still Life with Milk Jug and Fruit',2,'https://www.nga.gov/collection/art-object-page.53123.html','1972.9.5','Open Access','','',1900,55,46,'Oil on canvas',1225.0000,1300.0000,'',NULL,'','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":187,\"green\":96,\"blue\":31},\"web\":\"#BB601F\",\"name\":\"Christine\"},{\"color\":{\"red\":173,\"green\":151,\"blue\":121},\"web\":\"#AD9779\",\"name\":\"Bronco\"},{\"color\":{\"red\":172,\"green\":108,\"blue\":32},\"web\":\"#AC6C20\",\"name\":\"Hot Toddy\"},{\"color\":{\"red\":175,\"green\":87,\"blue\":52},\"web\":\"#AF5734\",\"name\":\"Fiery Orange\"},{\"color\":{\"red\":207,\"green\":138,\"blue\":25},\"web\":\"#CF8A19\",\"name\":\"Buttercup\"},{\"color\":{\"red\":75,\"green\":80,\"blue\":80},\"web\":\"#4b5050\",\"name\":\"Mako\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (77,16,13,'016080','Woman with a Pearl Necklace in a Loge',1,'http://www.philamuseum.org/collections/permanent/72182.html','1978-1-5','Open Access','Woman with a Pearl Necklace in a Loge (or Lydia in a Loge) is an 1879 painting by American artist Mary Cassatt. The Philadelphia Museum of Art acquired the painting in 1978 from the bequest of Charlotte Dorrance Wright. The style in which it was painted and the depiction of shifting light and color was influenced by Impressionism. This painting shows a view of the modern woman and is similar in style to Degas.','The style in which it was painted and the depiction of shifting light and color was influenced by Impressionism. This painting shows a view of the modern woman and is similar in style to Degas.',1879,60,81,'Oil on canvas',375.0000,400.0000,'https://artsandculture.google.com/asset/twFaMNqHtSxehg',NULL,'https://en.wikipedia.org/wiki/Woman_with_a_Pearl_Necklace_in_a_Loge','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":98,\"green\":24,\"blue\":22},\"web\":\"#621816\",\"name\":\"Red Oxide\"},{\"color\":{\"red\":218,\"green\":181,\"blue\":181},\"web\":\"#DAB5B5\",\"name\":\"Oyster Pink\"},{\"color\":{\"red\":212,\"green\":188,\"blue\":154},\"web\":\"#6C120A\",\"name\":\"Falu Red\"},{\"color\":{\"red\":108,\"green\":18,\"blue\":10},\"web\":\"#53281E\",\"name\":\"Caput Mortuum\"},{\"color\":{\"red\":220,\"green\":192,\"blue\":139},\"web\":\"#DCC08B\",\"name\":\"Zombie\"},{\"color\":{\"red\":110,\"green\":67,\"blue\":57},\"web\":\"#6E4339\",\"name\":\"Metallic Copper\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (78,24,28,'024020','Death in the sickroom',3,'http://www.nasjonalmuseet.no/en/collections_and_research/our_collections/edvard_munch_in_the_national_museum/Death+in+the+Sick-Room%2C+prob.+1893.b7C_wljU3c.ips','NG.M.00940','&copy; National Museum of Norway','The picture shows what we can assume to be the artist\'s family grouped around his sister Sophie, who died in 1877. She is sitting in a chair with her back to us. To the right stands an aunt, Karen Bjolstad, who moved in with the family to take care of the children and the household after the mother died of tuberculosis in 1868. In the background stands the father, the doctor Christian Munch, with his hands clasped as if in prayer. Near the centre of the picture is a male figure, probably Edvard, in quarter-face. Sister Laura is sitting in the foreground with her hands in her lap, while the third sister, Inger, stands staring straight at us. The male figure to the left is generally identified as Edvard\'s younger brother Andreas. In Death in the SickRoom there is no physical contact between the people, except for the hand that aunt Karen has laid on the back of the chair in which the invalid sits.','The picture shows what we can assume to be the artist\'s family grouped around his sister Sophie, who died in 1877.',1892,134,160,'Tempura and Crayon on canvas',250.0000,275.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":109,\"green\":112,\"blue\":108},\"web\":\"#6D706C\",\"name\":\"Finlandia\"},{\"color\":{\"red\":176,\"green\":122,\"blue\":87},\"web\":\"#b07a57\",\"name\":\"Medium Wood\"},{\"color\":{\"red\":122,\"green\":118,\"blue\":96},\"web\":\"#7A7660\",\"name\":\"Kokoda\"},{\"color\":{\"red\":77,\"green\":91,\"blue\":106},\"web\":\"#4D5B6A\",\"name\":\"Fiord\"},{\"color\":{\"red\":114,\"green\":82,\"blue\":68},\"web\":\"#725244\",\"name\":\"Spice\"},{\"color\":{\"red\":118,\"green\":129,\"blue\":100},\"web\":\"#768164\",\"name\":\"Camouflage Green\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (79,24,28,'024030','Cry (The Scream)',1,'http://www.nasjonalmuseet.no/en/collections_and_research/our_collections/edvard_munch_in_the_national_museum/The+Scream%2C+1893.b7C_wljU1a.ips','NG.M.00939','&copy; National Museum of Norway','Scream is the title of expressionist paintings and prints in a series by Norwegian artist Edvard Munch, showing an agonized figure against a blood red sky. The landscape in the background is the Oslofjord, viewed from the hill of Ekeberg, in Oslo (then Kristiania), Norway.','Scream is the title of expressionist paintings and prints in a series by Norwegian artist Edvard Munch, showing an agonized figure against a blood red sky.',1893,91,74,'Oil, tempera and pastel on cardboard',175.0000,225.0000,'https://www.google.com/culturalinstitute/beta/asset/the-scream/eQFdRTFKDtVQ1A','The Scream is undoubtedly MunchÔÇÖs most famous motif. It belongs to a series of motifs that Munch developed in Berlin and ├àsg├Ñrdsstrand in the 1890ÔÇÖs. Munch later gave the series the title Frieze of Life, and described this pictorial cycle as a poem of love, life and death.','http://en.wikipedia.org/wiki/The_Scream','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":90,\"green\":82,\"blue\":80},\"web\":\"#5A5250\",\"name\":\"Tundora\"},{\"color\":{\"red\":129,\"green\":113,\"blue\":92},\"web\":\"#81715C\",\"name\":\"Cement\"},{\"color\":{\"red\":103,\"green\":87,\"blue\":71},\"web\":\"#675747\",\"name\":\"Tobacco Brown\"},{\"color\":{\"red\":117,\"green\":109,\"blue\":101},\"web\":\"#756D65\",\"name\":\"Sandstone\"},{\"color\":{\"red\":161,\"green\":107,\"blue\":75},\"web\":\"#a16b4b\",\"name\":\"Dark Tan\"},{\"color\":{\"red\":168,\"green\":89,\"blue\":64},\"web\":\"#a85940\",\"name\":\"Sepia\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (80,24,28,'024040','Puberty',1,'http://www.nasjonalmuseet.no/en/collections_and_research/our_collections/edvard_munch_in_the_national_museum/Puberty%2C+1894%E2%80%9395.b7C_wljWWK.ips','NG.M.00807','&copy; National Museum of Norway','Puberty is a painting created by Edvard Munch. Munch is an artist native to Norway and is widely known for his role in expressionistic art. Puberty has also been done as a lithograph and an etching by Munch.','Puberty is a painting created by Edvard Munch. Munch is an artist native to Norway and is widely known for his role in expressionistic art. Puberty has also been done as a lithograph and an etching by Munch.',1894,152,110,'Oil on canvas',125.0000,165.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Puberty_(Edvard_Munch)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":5},\"dominantColors\":[{\"color\":{\"red\":73,\"green\":40,\"blue\":26},\"web\":\"#49281A\",\"name\":\"Morocco Brown\"},{\"color\":{\"red\":34,\"green\":25,\"blue\":22},\"web\":\"#221916\",\"name\":\"Wood Bark\"},{\"color\":{\"red\":202,\"green\":191,\"blue\":162},\"web\":\"#CABFA2\",\"name\":\"Sisal\"},{\"color\":{\"red\":99,\"green\":78,\"blue\":56},\"web\":\"#634E38\",\"name\":\"Dallas\"},{\"color\":{\"red\":196,\"green\":163,\"blue\":109},\"web\":\"#c4a36d\",\"name\":\"Fallow\"},{\"color\":{\"red\":168,\"green\":124,\"blue\":74},\"web\":\"#a87c4a\",\"name\":\"Muddy Waters\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (81,24,28,'024050','Madonna',1,'http://www.nasjonalmuseet.no/en/collections_and_research/our_collections/edvard_munch_in_the_national_museum/Madonna%2C+1894%E2%80%9395.b7C_wljU5e.ips','NG.M.00841','&copy; National Museum of Norway','Madonna is a painting by the Norwegian expressionist Edvard Munch. Munch painted five versions of the Madonna between 1894 and 1895, using oils on canvas. Although it is a highly unusual representation, nevertheless, this painting is of Mary, the mother of Jesus. True to the Norwegian cultural beliefs and way of life, the painting is a strong dose of conceivable realism.','Madonna is a painting by the Norwegian expressionist Edvard Munch. Munch painted five versions of the Madonna between 1894 and 1895, using oils on canvas. Although it is a highly unusual representation, nevertheless, this painting is of Mary, the mother of Jesus. True to the Norwegian cultural beliefs and way of life, the painting is a strong dose of conceivable realism.',1895,91,70,'Oil on canvas',190.0000,230.0000,'https://www.google.com/culturalinstitute/beta/asset/madonna/1gHp7gNaErg8lA','The painting shows a young woman with long, black hair down her shoulders. The deep set eyes are closed as she leans her head back. With her arms held behind her head and back, she exposes her naked body. The wavy lines that surround her, give the impression that she is floating or soaring. The artist has given her a red hat reminiscent of a halo. In MunchÔÇÖs art the colour red often symbolize love, passion or agony.','http://en.wikipedia.org/wiki/Madonna_(Edvard_Munch)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":99,\"green\":81,\"blue\":60},\"web\":\"#63513C\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":58,\"green\":51,\"blue\":48},\"web\":\"#3A3330\",\"name\":\"Kilamanjaro\"},{\"color\":{\"red\":175,\"green\":148,\"blue\":87},\"web\":\"#AF9457\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":132,\"green\":57,\"blue\":20},\"web\":\"#843914\",\"name\":\"Saddle Brown\"},{\"color\":{\"red\":85,\"green\":77,\"blue\":72},\"web\":\"#554D48\",\"name\":\"Cork\"},{\"color\":{\"red\":131,\"green\":115,\"blue\":86},\"web\":\"#837356\",\"name\":\"Shadow\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (83,24,28,'024070','Dance of Life',2,'http://www.nasjonalmuseet.no/en/collections_and_research/our_collections/edvard_munch_in_the_national_museum/The+Dance+of+Life%2C+1899%E2%80%931900.b7C_wljW5c.ips','NG.M.00941','&copy; National Museum of Norway','Munch\'s painting shows several couples dancing in a luminous summer night. The central element of the composition is a couple, of whom the woman is wearing a bright red dress that wraps itself around the feet of her dancing partner. Her loose hair swirling about him, they seem to become a single entity. This couple is flanked by two other women, one of them young and radiant in a white dress, the other pale, with sunken cheeks and dressed in black. It is as if a story were being told about various stages in a woman\'s life. Munch has set the scene on the seashore, a landscape with elements from Asgardstrand. Many of the pictures in Munch\'s protracted Frieze of Life project were inspired by Asgardstrand\'s curving shoreline and characteristic landscape.','Munch\'s painting shows several couples dancing in a luminous summer night. ',1900,126,190,'Oil on canvas',250.0000,325.0000,'https://www.google.com/culturalinstitute/beta/asset/the-dance-of-life/2QHHE-2HLPWV0g','The motif Dance of Life is central to the series Frieze of Life. The first time Munch painted the motif was in 1899-1900. Many years later, in 1925, he painted it once more when he took up again several of the motifs from the Frieze of Life. The technique was different, but the motifs and colours were the same\r\nIn the middle a young couple are dancing. They seem to have melted together. The womanÔÇÖs red dress wraps itself around the manÔÇÖs leg. The red colour continues like a contour line around the man and runs into his clothes. They dance face to face, silent and unsmiling, and the womanÔÇÖs hair blows towards the man. \r\nOn either side of the couple there is a woman. In from the left a young woman dressed in white comes towards us, bright and happy. On the right stands a woman dressed in black, rigid and serious.',NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":158,\"green\":44,\"blue\":32},\"web\":\"#9E2C20\",\"name\":\"Brown\"},{\"color\":{\"red\":35,\"green\":65,\"blue\":35},\"web\":\"#234123\",\"name\":\"Myrtle\"},{\"color\":{\"red\":27,\"green\":21,\"blue\":20},\"web\":\"#1B1514\",\"name\":\"Seal Brown\"},{\"color\":{\"red\":81,\"green\":41,\"blue\":30},\"web\":\"#51291E\",\"name\":\"Caput Mortuum\"},{\"color\":{\"red\":206,\"green\":188,\"blue\":160},\"web\":\"#CEBCA0\",\"name\":\"Soft Amber\"},{\"color\":{\"red\":90,\"green\":84,\"blue\":97},\"web\":\"#5a5461\",\"name\":\"Mobster\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (88,28,19,'028010','In Bed',2,'https://www.musee-orsay.fr/en/collections/index-of-works/notice.html?no_cache=1&nnumid=00704&cHash=ff186a6bb4','RF 1937 38','Public Domain',NULL,NULL,1893,71,54,'Oil on Cardboard',340.0000,400.0000,NULL,NULL,'https://commons.wikimedia.org/wiki/File:Lautrec_in_bed_1893.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":207,\"green\":190,\"blue\":167},\"web\":\"#CFBEA7\",\"name\":\"Soft Amber\"},{\"color\":{\"red\":95,\"green\":82,\"blue\":65},\"web\":\"#5F5241\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":172,\"green\":156,\"blue\":136},\"web\":\"#AC9C88\",\"name\":\"Malta\"},{\"color\":{\"red\":109,\"green\":72,\"blue\":62},\"web\":\"#6D483E\",\"name\":\"Spice\"},{\"color\":{\"red\":143,\"green\":67,\"blue\":62},\"web\":\"#8f433e\",\"name\":\"Mojo\"},{\"color\":{\"red\":201,\"green\":132,\"blue\":96},\"web\":\"#c98460\",\"name\":\"Burning Sand\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (89,28,7,'028050','The Medical Inspection at the Rue des Moulins Brothel',1,'https://www.nga.gov/collection/art-object-page.46544.html','1963.10.69','Open Access','','',1894,61,84,'Oil on cardboard',475.0000,654.0000,NULL,NULL,'https://commons.wikimedia.org/wiki/File:Lautrec_rue_des_moulins,_the_medical_inspection_1894.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":128,\"green\":92,\"blue\":78},\"web\":\"#805c4e\",\"name\":\"Spicy Mix\"},{\"color\":{\"red\":131,\"green\":115,\"blue\":94},\"web\":\"#83735E\",\"name\":\"Cement\"},{\"color\":{\"red\":85,\"green\":89,\"blue\":82},\"web\":\"#555952\",\"name\":\"Battleship Grey\"},{\"color\":{\"red\":164,\"green\":159,\"blue\":137},\"web\":\"#A49F89\",\"name\":\"Dawn\"},{\"color\":{\"red\":118,\"green\":117,\"blue\":106},\"web\":\"#76756A\",\"name\":\"Dove Grey\"},{\"color\":{\"red\":67,\"green\":92,\"blue\":84},\"web\":\"#435C54\",\"name\":\"Stromboli\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (101,2,17,'002020','Andre Derain',1,'http://www.tate.org.uk/art/artworks/matisse-andre-derain-n06241','N06241','Succession Henri Matisse/DACS 2016','Matisse and Derain painted portraits of each other while staying at the port of Collioure in the south of France. Using vivid, apparently arbitrary, colours, Matisse has captured the sensation of sunlight striking the sitter\'s face and casting a heavy shadow down one side. He has also tried to create a dynamic but balanced relationship between complementary colours, such as blue and orange, red and green. Complementary colours \'complete\' each other: they are at their most intense when placed together. Matisse adjusted his colours to obtain the maximum intensity. This non-naturalistic use of colour can be seen as a radical development of certain aspects of Impressionist art, and it led the critics to dub Matisse a \'fauve\' (wild beast).','Using vivid, apparently arbitrary, colours, Matisse has captured the sensation of sunlight striking the sitter\'s face and casting a heavy shadow down one side.',1905,39,29,'Oil on canvas',523.0000,700.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":135,\"green\":151,\"blue\":185},\"web\":\"#8797B9\",\"name\":\"Rock Blue\"},{\"color\":{\"red\":199,\"green\":147,\"blue\":124},\"web\":\"#c7937c\",\"name\":\"Feldspar \"},{\"color\":{\"red\":209,\"green\":188,\"blue\":159},\"web\":\"#D1BC9F\",\"name\":\"Soft Amber\"},{\"color\":{\"red\":137,\"green\":62,\"blue\":81},\"web\":\"#893E51\",\"name\":\"Camelot\"},{\"color\":{\"red\":102,\"green\":125,\"blue\":176},\"web\":\"#667DB0\",\"name\":\"Chetwode Blue\"},{\"color\":{\"red\":109,\"green\":151,\"blue\":144},\"web\":\"#6d9790\",\"name\":\"Gumbo\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (102,2,37,'002030','Joy of Life',2,'http://www.barnesfoundation.org/collections/art-collection/object/7199/le-bonheur-de-vivre-also-called-the-joy-of-life','BF719','&copy; The Barnes Foundation','Le bonheur de vivre (The joy of Life), is a painting by Henri Matisse. In the central background of the piece is a group of figures that is similar to the group depicted in his painting The Dance (second version).','Le bonheur de vivre (The joy of Life), is a painting by Henri Matisse. In the central background of the piece is a group of figures that is similar to the group depicted in his painting The Dance (second version).',1905,175,241,'Oil on canvas',900.0000,1240.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Le_bonheur_de_vivre','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":197,\"green\":172,\"blue\":160},\"web\":\"#c5aca0\",\"name\":\"Silk\"},{\"color\":{\"red\":196,\"green\":166,\"blue\":106},\"web\":\"#c4a66a\",\"name\":\"Laser\"},{\"color\":{\"red\":90,\"green\":119,\"blue\":117},\"web\":\"#5a7775\",\"name\":\"Breaker Bay\"},{\"color\":{\"red\":184,\"green\":90,\"blue\":52},\"web\":\"#b85a34\",\"name\":\"Smoke Tree\"},{\"color\":{\"red\":219,\"green\":192,\"blue\":84},\"web\":\"#dbc054\",\"name\":\"Tacha\"},{\"color\":{\"red\":210,\"green\":205,\"blue\":100},\"web\":\"#D2CD64\",\"name\":\"Goldenrod\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (103,2,20,'002040','Red Studio',3,'http://www.moma.org/collection/works/78389?locale=en','8.1949','Succession H. Matisse / Artists Rights Society','\"Where I got the color red, to be sure, I just don\'t know,\" Matisse once remarked. \"I find that all these things . . . only become what they are to me when I see them together with the color red.\" This painting features a small retrospective of Matisse\'s recent painting, sculpture, and ceramics, displayed in his studio. The artworks appear in color and in detail, while the room\'s architecture and furnishings are indicated only by negative gaps in the red surface. The composition\'s central axis is a grandfather clock without hands-it is as if, in the oasis of the artist\'s studio, time were suspended.','The artworks appear in color and in detail, while the room\'s architecture and furnishings are indicated only by negative gaps in the red surface. The composition\'s central axis is a grandfather clock without hands, it is as if, in the oasis of the artist\'s studio, time were suspended.',1911,181,219,'Oil on canvas',1153.0000,1175.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":136,\"green\":44,\"blue\":20},\"web\":\"#882C14\",\"name\":\"Burnt Umber\"},{\"color\":{\"red\":212,\"green\":130,\"blue\":152},\"web\":\"#D48298\",\"name\":\"Can Can\"},{\"color\":{\"red\":177,\"green\":157,\"blue\":99},\"web\":\"#B19D63\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":165,\"green\":176,\"blue\":164},\"web\":\"#a5b0a4\",\"name\":\"Spring Rain\"},{\"color\":{\"red\":162,\"green\":125,\"blue\":87},\"web\":\"#a27d57\",\"name\":\"Muesli\"},{\"color\":{\"red\":67,\"green\":63,\"blue\":55},\"web\":\"#433f37\",\"name\":\"Onion\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (105,32,7,'032010','Charing Cross Bridge',2,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.61249.html','1982.76.3','Open Access',NULL,NULL,1905,80,100,'Oil on canvas',500.0000,800.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":38,\"green\":45,\"blue\":103},\"web\":\"#262D67\",\"name\":\"Deep Koamaru\"},{\"color\":{\"red\":226,\"green\":189,\"blue\":55},\"web\":\"#E2BD37\",\"name\":\"Bright Sun\"},{\"color\":{\"red\":77,\"green\":134,\"blue\":85},\"web\":\"#4D8655\",\"name\":\"Killarney\"},{\"color\":{\"red\":209,\"green\":198,\"blue\":168},\"web\":\"#D1C6A8\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":134,\"green\":167,\"blue\":127},\"web\":\"#86A77F\",\"name\":\"Amulet\"},{\"color\":{\"red\":178,\"green\":90,\"blue\":91},\"web\":\"#B25A5B\",\"name\":\"Hippie Pink\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (114,40,11,'040020','Improvisation No. 30 (Cannons)',3,'http://www.artic.edu/aic/collections/artwork/8991',NULL,'Rights-Managed (RM)','Although Improvisation No. 30 (Cannons) at first appears to be an almost random assortment of brilliant colors, shapes, and lines, the artist also included leaning buildings, a crowd of people, and a wheeled, smoking cannon.','Although Improvisation No. 30 (Cannons) at first appears to be an almost random assortment of brilliant colors, shapes, and lines, the artist also included leaning buildings, a crowd of people, and a wheeled, smoking cannon.',1913,109,109,'Oil on canvas',530.0000,700.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":58,\"green\":86,\"blue\":136},\"web\":\"#3A5688\",\"name\":\"Fun Blue\"},{\"color\":{\"red\":86,\"green\":122,\"blue\":116},\"web\":\"#567A74\",\"name\":\"William\"},{\"color\":{\"red\":160,\"green\":105,\"blue\":63},\"web\":\"#A0693F\",\"name\":\"Desert\"},{\"color\":{\"red\":205,\"green\":145,\"blue\":61},\"web\":\"#CD913D\",\"name\":\"Anzac\"},{\"color\":{\"red\":235,\"green\":189,\"blue\":60},\"web\":\"#EBBD3C\",\"name\":\"Bright Sun\"},{\"color\":{\"red\":196,\"green\":63,\"blue\":52},\"web\":\"#C43F34\",\"name\":\"Persian Red\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (115,40,24,'040010','Composition VI',2,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/35744/?lng=en','9662','Personal non-commercial use','Abandoning objectivity in a depiction and immersing himself in “the resonance of colour and shape”, Kandinsky successfully came up with three types of abstract painting. Impressions, born under the influence of the outside world, and improvisations, reflecting inner emotional experience, were created in isolation from figurativeness, but still retained a link with reality. It was in the third type of painting, compositions, that Kandinsky’s long years of creative searching found their fullest expression. The essence of the artist’s creative work shifted into the expressiveness of line and colours that are not connected with the world of objects and are directed to the sphere of emotions and sensations. The starting point for Composition VI was a picture on glass called The Flood that the artist sought to rethink. An inner sense of catastrophe, expressed in an abstract form, is the content of the canvas.','Abandoning objectivity in a depiction and immersing himself in “the resonance of colour and shape”, Kandinsky successfully came up with three types of abstract painting. Impressions, born under the influence of the outside world, and improvisations, reflecting inner emotional experience, were created in isolation from figurativeness, but still retained a link with reality.',1913,195,300,'Oil on canvas',203.0000,220.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":213,\"green\":189,\"blue\":161},\"web\":\"#D5BDA1\",\"name\":\"Soft Amber\"},{\"color\":{\"red\":196,\"green\":147,\"blue\":130},\"web\":\"#C49382\",\"name\":\"Quicksand\"},{\"color\":{\"red\":128,\"green\":7,\"blue\":18},\"web\":\"#800712\",\"name\":\"Burgundy\"},{\"color\":{\"red\":227,\"green\":178,\"blue\":158},\"web\":\"#E3B29E\",\"name\":\"Wax Flower\"},{\"color\":{\"red\":56,\"green\":110,\"blue\":134},\"web\":\"#386e86\",\"name\":\"Astral\"},{\"color\":{\"red\":197,\"green\":143,\"blue\":71},\"web\":\"#c58f47\",\"name\":\"Tussock\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (118,41,51,'041010','Dynamism of a Dog on a Leash',2,'https://www.albrightknox.org/collection/search/piece:505/','505','Public Domain',NULL,NULL,1912,90,110,'Oil on canvas',300.0000,400.0000,NULL,NULL,'https://en.wikipedia.org/wiki/Dynamism_of_a_Dog_on_a_Leash','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":186,\"green\":191,\"blue\":187},\"web\":\"#babfbb\",\"name\":\"Paris White\"},{\"color\":{\"red\":103,\"green\":121,\"blue\":147},\"web\":\"#677993\",\"name\":\"Slate Grey\"},{\"color\":{\"red\":162,\"green\":53,\"blue\":28},\"web\":\"#a2351c\",\"name\":\"Rock Spray\"},{\"color\":{\"red\":54,\"green\":67,\"blue\":46},\"web\":\"#36432e\",\"name\":\"Mallard\"},{\"color\":{\"red\":147,\"green\":106,\"blue\":110},\"web\":\"#936a6e\",\"name\":\"Mauve Taupe\"},{\"color\":{\"red\":122,\"green\":142,\"blue\":92},\"web\":\"#7a8e5c\",\"name\":\"Highland\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (119,41,35,'041020','Abstract Speed + Sound',2,'https://www.guggenheim.org/artwork/300','76.2553.31','Artists Rights Society','It has been proposed that Abstract Speed + Sound< was the central section of a narrative triptych suggesting the alteration of landscape by the passage of a car through the atmosphere. The related Abstract Speed and Abstract Speed The Car Has Passed would have been the flanking panels. Indications of sky and a single landscape are present in the three paintings; the interpretation of fragmented evocations of the car\'s speed varies from panel to panel. The Peggy Guggenheim work is distinguished by crisscross motifs, representing sound, and a multiplication of the number of lines and planes.','It has been proposed that Abstract Speed + Sound< was the central section of a narrative triptych suggesting the alteration of landscape by the passage of a car through the atmosphere. ',1913,54,76,'Oil on millboard',320.0000,360.0000,NULL,NULL,'http://www.guggenheim.org/new-york/collections/collection-online/show-full/piece/?search=Giacomo%20Balla&page=1&f=People&cr=1','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":230,\"green\":232,\"blue\":229},\"web\":\"#E6E8E5\",\"name\":\"Panache\"},{\"color\":{\"red\":95,\"green\":121,\"blue\":150},\"web\":\"#5F7996\",\"name\":\"Waikawa Grey\"},{\"color\":{\"red\":39,\"green\":60,\"blue\":30},\"web\":\"#273C1E\",\"name\":\"Black Forest\"},{\"color\":{\"red\":150,\"green\":111,\"blue\":123},\"web\":\"#966F7B\",\"name\":\"Venus\"},{\"color\":{\"red\":170,\"green\":39,\"blue\":11},\"web\":\"#AA270B\",\"name\":\"Fire Brick\"},{\"color\":{\"red\":81,\"green\":115,\"blue\":165},\"web\":\"#5173A5\",\"name\":\"San Marino\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (124,45,20,'045020','Persistence of Memory',3,'http://www.moma.org/collection/works/79018?locale=en','162.1934','Salvador Dali, Gala-Salvador Dali Foundation / Artists Rights Society','The Persistence of Memory is by far Salvador Dali\'s most recognizable paintings, and there are many references to it in popular culture. Although it was conjectured that the soft melting watches were the result of Dali\'s interpretation of the theory of relativity, Dali himself state that their inspiration was camembert cheese melting under the sun. The sequence of melting clocks in a disjointed landscape is the depiction of a dream that Dali had experienced, the figure in the middle of the painting being the face of the dreamer himself. The general interpretation is that the painting, which portrays many melting watches, is a rejection of time as a solid and deterministic influence.','The Persistence of Memory is by far Salvador Dali\'s most recognizable paintings, and there are many references to it in popular culture.',1931,24,33,'Oil on canvas',800.0000,900.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Persistence_of_Memory','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":83,\"green\":75,\"blue\":49},\"web\":\"#534B31\",\"name\":\"Punga\"},{\"color\":{\"red\":172,\"green\":168,\"blue\":132},\"web\":\"#ACA884\",\"name\":\"Neutral Green\"},{\"color\":{\"red\":86,\"green\":86,\"blue\":80},\"web\":\"#565650\",\"name\":\"Ship Grey\"},{\"color\":{\"red\":50,\"green\":48,\"blue\":41},\"web\":\"#323029\",\"name\":\"Graphite\"},{\"color\":{\"red\":111,\"green\":112,\"blue\":108},\"web\":\"#6F706C\",\"name\":\"Gunsmoke\"},{\"color\":{\"red\":122,\"green\":145,\"blue\":139},\"web\":\"#7a918b\",\"name\":\"Granny Smith\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (139,5,16,'005010','The Oath of the Horatii',2,'http://www.louvre.fr/en/oeuvre-notices/oath-horatii','INV. 3692','&copy; Musee du Louvre','Oath of the Horatii (French: Le Serment des Horaces), is a work by French artist Jacques-Louis David painted in 1784. It depicts a scene from a Roman legend about a dispute between two warring cities; Rome and Alba Longa, when three brothers from a Roman family, the Horatii, agree to end the war by fighting three brothers from an Alba Longa family, the Curiatii. The three brothers, all of which appear willing to sacrifice their lives for the good of Rome, are shown saluting their father who holds their swords out for them. The principal sources for the story behind David\'s Oath are the first book of Livy (sections 24-6) which was elaborated by Dionysius in book 3 of his Roman Antiquities. However, the moment depicted in David\'s painting is his own invention.','It depicts a scene from a Roman legend about a dispute between two warring cities; Rome and Alba Longa, when three brothers from a Roman family, the Horatii, agree to end the war by fighting three brothers from an Alba Longa family, the Curiatii.',1784,330,425,'Oil on canvas',550.0000,800.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Oath_of_the_Horatii','{\"safeSearchAnnotation\":{\"violence\":2,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":141,\"green\":60,\"blue\":56},\"web\":\"#8D3C38\",\"name\":\"Prairie Sand\"},{\"color\":{\"red\":43,\"green\":41,\"blue\":38},\"web\":\"#2b2926\",\"name\":\"Black Magic\"},{\"color\":{\"red\":143,\"green\":135,\"blue\":99},\"web\":\"#8f8763\",\"name\":\"Granite Green\"},{\"color\":{\"red\":185,\"green\":171,\"blue\":123},\"web\":\"#b9ab7b\",\"name\":\"Ecru\"},{\"color\":{\"red\":138,\"green\":108,\"blue\":74},\"web\":\"#8a6c4a\",\"name\":\"Shadow\"},{\"color\":{\"red\":192,\"green\":74,\"blue\":60},\"web\":\"#c04a3c\",\"name\":\"Grenadier\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (140,6,16,'006010','Mademoiselle Caroline Riviere',1,'http://www.louvre.fr/en/oeuvre-notices/mademoiselle-caroline-riviere','M.I. 1447','&copy; Musee du Louvre','The portrait of Mademoiselle Caroline Rivière was painted in 1806 by the French Neoclassical artist Jean Auguste Dominique Ingres, and today hangs in the Louvre. It is the third of three portraits of the Rivière family the artist painted that year. Caroline\'s father, Philibert Rivière, was a successful court official under Napoleon\'s empire, and sought to commemorate himself, his wife and daughter through a commission with the then young and rising artist - his portraits of Philibert and his wife are also still extant. Although Ingres favoured subject matter drawn from history or Greek legend, at this early stage in his career he earned his living mainly through commissions from wealthy patrons. The family lived outside Paris, at St. Germain-en-Laye, and Mademoiselle Caroline Rivière would have been between 13 and 15 at the time she was portrayed; according to Ingres the \"ravishing daughter\".','The portrait of Mademoiselle Caroline Rivière was painted in 1806 by the French Neoclassical artist Jean Auguste Dominique Ingres, and today hangs in the Louvre. It is the third of three portraits of the Rivière family the artist painted that year. ',1806,100,70,'Oil on canvas',230.0000,400.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Mademoiselle_Caroline_Rivi%C3%A8re','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":203,\"green\":196,\"blue\":170},\"web\":\"#CBC4AA\",\"name\":\"Parchment\"},{\"color\":{\"red\":124,\"green\":119,\"blue\":92},\"web\":\"#7C775C\",\"name\":\"Kokoda\"},{\"color\":{\"red\":30,\"green\":24,\"blue\":20},\"web\":\"#1E1814\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":163,\"green\":158,\"blue\":133},\"web\":\"#A39E85\",\"name\":\"Grey Olive\"},{\"color\":{\"red\":161,\"green\":167,\"blue\":155},\"web\":\"#A1A79B\",\"name\":\"Silver Chalice\"},{\"color\":{\"red\":227,\"green\":219,\"blue\":193},\"web\":\"#E3DBC1\",\"name\":\"Wheatfield\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (142,7,16,'007010','Death of Sardanapalus',3,'http://www.louvre.fr/en/oeuvre-notices/death-sardanapalus','R.F. 2346','&copy; Musee du Louvre','Death of Sardanapalus (La Mort de Sardanapale) is an oil painting on canvas, dated 1827 by Eugene Delacroix. Its dominant feature is a large divan, with its golden elephants, on which a nude prostrates herself and beseeches the apathetic Sardanapalus for mercy. Sardanapalus (Detail) had ordered his possessions destroyed and sex slaves murdered before immolating himself, once he learned that he was faced with military defeat.','Death of Sardanapalus (La Mort de Sardanapale) is an oil painting on canvas, dated 1827 by Eugene Delacroix. Its dominant feature is a large divan, with its golden elephants, on which a nude prostrates herself and beseeches the apathetic Sardanapalus for mercy. Sardanapalus (Detail) had ordered his possessions destroyed and sex slaves murdered before immolating himself, once he learned that he was faced with military defeat.',1827,392,496,'Oil on canvas',850.0000,1175.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Death_of_Sardanapalus','{\"safeSearchAnnotation\":{\"violence\":4,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":34,\"green\":15,\"blue\":1},\"web\":\"#220f01\",\"name\":\"Wood Bark\"},{\"color\":{\"red\":135,\"green\":49,\"blue\":18},\"web\":\"#873112\",\"name\":\"Burnt Umber\"},{\"color\":{\"red\":186,\"green\":151,\"blue\":69},\"web\":\"#BA9745\",\"name\":\"Roti\"},{\"color\":{\"red\":170,\"green\":110,\"blue\":38},\"web\":\"#AA6E26\",\"name\":\"Hot Toddy\"},{\"color\":{\"red\":110,\"green\":30,\"blue\":6},\"web\":\"#6E1E06\",\"name\":\"Falu Red\"},{\"color\":{\"red\":153,\"green\":121,\"blue\":42},\"web\":\"#99792A\",\"name\":\"Hacienda\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (145,10,34,'010030','The Young Ladies on the Banks of the Seine (Summer)',3,'http://www.petitpalais.paris.fr/fr/collections/les-demoiselles-des-bords-de-la-seine-ete','PPP00377','&copy; Petit Palais','This very modern subject prefigures the future popularity of the banks of the Seine, celebrated by the Impressionists a generation later. This work, unique in its modern subject and unusually large format for a genre scene, broke away from the conventions of the day. Courbet, always a provocateur, unleashed a critical scandal by exhibiting the Young Ladies at the Salon in 1857.','This very modern subject prefigures the future popularity of the banks of the Seine, celebrated by the Impressionists a generation later. This work, unique in its modern subject and unusually large format for a genre scene, broke away from the conventions of the day. Courbet, always a provocateur, unleashed a critical scandal by exhibiting the Young Ladies at the Salon in 1857.',1856,174,200,'Oil on canvas',250.0000,350.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":56,\"green\":50,\"blue\":44},\"web\":\"#38322c\",\"name\":\"Acadia\"},{\"color\":{\"red\":166,\"green\":171,\"blue\":171},\"web\":\"#a6abab\",\"name\":\"Hit Grey\"},{\"color\":{\"red\":193,\"green\":183,\"blue\":168},\"web\":\"#c1b7a8\",\"name\":\"Tea\"},{\"color\":{\"red\":104,\"green\":92,\"blue\":62},\"web\":\"#685c3e\",\"name\":\"Yellow Metal\"},{\"color\":{\"red\":127,\"green\":155,\"blue\":146},\"web\":\"#7f9b92\",\"name\":\"Granny Smith\"},{\"color\":{\"red\":128,\"green\":75,\"blue\":65},\"web\":\"#804b41\",\"name\":\"Nutmeg\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (146,10,34,'010040','The Sleepers',2,'http://www.petitpalais.paris.fr/fr/collections/le-sommeil','PPP03130','&copy; Petit Palais','In the 1860\'s Courbet began painting erotic nudes scenes, including depictions of female genitalia, nude women in erotic poses, and this painting, depicting lesbianism. Courbet gained much notoriety for his erotic nudes, which he displayed alongside hunting scenes, ensuring a sales and a reputation. Le Sommeil was commissioned by the Turkish diplomat Khalil Bey, who also commissioned The Origin of the World, to include his private collection of erotic paintings. This particular painting was also part of a police report in 1872 when a painting dealer held in it an exhibition. It was not allowed to be displayed publicly until 1988.','In the 1860\'s Courbet began painting erotic nudes scenes, including depictions of female genitalia, nude women in erotic poses, and this painting, depicting lesbianism. Courbet gained much notoriety for his erotic nudes, which he displayed alongside hunting scenes, ensuring a sales and a reputation. Le Sommeil was commissioned by the Turkish diplomat Khalil Bey, who also commissioned The Origin of the World, to include his private collection of erotic paintings. This particular painting was also part of a police report in 1872 when a painting dealer held in it an exhibition. It was not allowed to be displayed publicly until 1988.',1866,135,200,'Oil on canvas',300.0000,375.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":5},\"dominantColors\":[{\"color\":{\"red\":224,\"green\":193,\"blue\":141},\"web\":\"#E0C18D\",\"name\":\"New Orleans\"},{\"color\":{\"red\":27,\"green\":19,\"blue\":49},\"web\":\"#1B1331\",\"name\":\"Haiti\"},{\"color\":{\"red\":191,\"green\":156,\"blue\":101},\"web\":\"#BF9C65\",\"name\":\"Fallow\"},{\"color\":{\"red\":244,\"green\":217,\"blue\":168},\"web\":\"#F4D9A8\",\"name\":\"Astra\"},{\"color\":{\"red\":223,\"green\":198,\"blue\":160},\"web\":\"#DFC6A0\",\"name\":\"Raffia\"},{\"color\":{\"red\":174,\"green\":107,\"blue\":75},\"web\":\"#ae6b4b\",\"name\":\"Sante Fe\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (152,13,19,'013030','Arrangement in Grey and Black: Portrait of the Painter\'s Mother',3,'http://www.musee-orsay.fr/en/collections/works-in-focus/search/commentaire/commentaire_id/arrangement-en-gris-et-noir-n1-445.html','RF 699','&copy; Home','Arrangement in Grey and Black: The Artist\'s Mother, famous under its colloquial name Whistler\'s Mother, is an 1871 oil-on-canvas painting by American-born painter James McNeill Whistler.  It occasionally tours worldwide. Although an icon of American art, it rarely appears in the United States.','Arrangement in Grey and Black: The Artist\'s Mother, famous under its colloquial name Whistler\'s Mother, is an 1871 oil-on-canvas painting by American-born painter James McNeill Whistler.  It occasionally tours worldwide. Although an icon of American art, it rarely appears in the United States.',1871,144,162,'Oil on canvas',1225.0000,1300.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Whistler%27s_Mother','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":125,\"green\":115,\"blue\":106},\"web\":\"#7D736A\",\"name\":\"Sand Dune\"},{\"color\":{\"red\":203,\"green\":191,\"blue\":182},\"web\":\"#CBBFB6\",\"name\":\"Pale Slate\"},{\"color\":{\"red\":49,\"green\":39,\"blue\":39},\"web\":\"#312727\",\"name\":\"Night Rider\"},{\"color\":{\"red\":78,\"green\":66,\"blue\":34},\"web\":\"#4e4222\",\"name\":\"Madras\"},{\"color\":{\"red\":118,\"green\":109,\"blue\":92},\"web\":\"#766D5C\",\"name\":\"Pablo\"},{\"color\":{\"red\":127,\"green\":92,\"blue\":56},\"web\":\"#7f5c38\",\"name\":\"Shingle Fawn\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (153,14,13,'014030','Large Bathers',2,'http://www.philamuseum.org/collections/permanent/59196.html','1963-116-13','Public Domain','Renoir labored over this painting for a period of three years before he was happy with its composition. Along with at least two full-sized figure drawings of the models, Renoir also created many preparatory drawings for each of the figures before eventually putting brush to canvas. Due to the criticism he received for the painting\'s sculptural smoothness and a change in the artist\'s perceived style, Renoir, who was exhausted by the effort, claimed that he would never again devote such a long period of time for a single piece of work.','Renoir labored over this painting for a period of three years before he was happy with its composition. Along with at least two full-sized figure drawings of the models, Renoir also created many preparatory drawings for each of the figures before eventually putting brush to canvas.',1887,170,116,'Oil on canvas',900.0000,1000.0000,'https://www.google.com/culturalinstitute/beta/asset/the-large-bathers/2wE1mqTuUoBmtA','Although this painting depicts a fleeting moment when one bather playfully threatens to splash a companion, it has a timeless, monumental quality. The sculptural rendering of the figures against a shimmering landscape and the careful application of dry paint reflect the tradition of seventeenth- and eighteenth-century French painting. Renoir--in an attempt to reconcile this tradition with modern painting--labored over this work for three years, making numerous preparatory drawings for individual figures and at least two full-scale, multifigure drawings. Faced with criticism of his new style after completing The Large Bathers, an exhausted Renoir never again devoted such painstaking effort to a single work.','http://www.philamuseum.org/collections/permanent/59196.html','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":5},\"dominantColors\":[{\"color\":{\"red\":211,\"green\":191,\"blue\":167},\"web\":\"#D3BFA7\",\"name\":\"Soft Amber\"},{\"color\":{\"red\":170,\"green\":153,\"blue\":130},\"web\":\"#AA9982\",\"name\":\"Bronco\"},{\"color\":{\"red\":131,\"green\":118,\"blue\":94},\"web\":\"#83765E\",\"name\":\"Stonewall\"},{\"color\":{\"red\":97,\"green\":86,\"blue\":62},\"web\":\"#61563E\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":203,\"green\":193,\"blue\":186},\"web\":\"#CBC1BA\",\"name\":\"Pale Slate\"},{\"color\":{\"red\":127,\"green\":118,\"blue\":113},\"web\":\"#7F7671\",\"name\":\"Hurricane\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (154,15,19,'015010','The Belleli Family',2,'http://www.musee-orsay.fr/en/collections/works-in-focus/search/commentaire/commentaire_id/la-famille-bellelli-7077.html','RF 2210','&copy; Home','Degas\' early masterpiece, The Bellelli Family depicts his aunt, her husband and their two little girls. It is believed that the artist drew each of the figures individually, later combining them in this unique portrayal of their family dynamic. The woman, Degas\' aunt Laura, wears a black dress in mourning for her recently deceased father, whose portrait hangs on the wall behind her. It is likely that this portrait hung at the Paris Salon of 1867, but it was badly hung and as a result was largely ignored by the critics. As a result, Degas kept it in his personal collection, where it remained until he left it to his dealer in 1913. In 1918, after his death, it was revealed an exhibition of the artist\'s estate, and was immediately bought for 400,000 by the Luxembourg Museum.','Degas\' early masterpiece, The Bellelli Family depicts his aunt, her husband and their two little girls. It is believed that the artist drew each of the figures individually, later combining them in this unique portrayal of their family dynamic.',1860,200,250,'Oil on canvas',1350.0000,1400.0000,'https://www.google.com/culturalinstitute/beta/asset/the-bellelli-family/CAEtElXoJtKBnQ','Between the ages of 22 and 26, Edgar Degas completed his training in Italy, where part of his familly lived. Here he painted his father\'s sister, Laure, with her husband, the baron Bellelli (1812-1864) and her two daughters, Giula and Giovanna.\r\n\r\nThe baron was an Italian patriot, banned from Naples, who lived an exile in Florence. His wife is in mourning for her father, Hilaire, who died recently and whose portrait appears on the framed redline painting close to his daughter\'s face.','http://en.wikipedia.org/wiki/Portrait_of_the_Bellelli_Family','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":29,\"green\":21,\"blue\":23},\"web\":\"#1D1517\",\"name\":\"Rustic Red\"},{\"color\":{\"red\":204,\"green\":194,\"blue\":187},\"web\":\"#CCC2BB\",\"name\":\"Pale Slate\"},{\"color\":{\"red\":55,\"green\":50,\"blue\":48},\"web\":\"#373230\",\"name\":\"Gondola\"},{\"color\":{\"red\":79,\"green\":82,\"blue\":77},\"web\":\"#4F524D\",\"name\":\"Cabbage Pont\"},{\"color\":{\"red\":97,\"green\":79,\"blue\":61},\"web\":\"#614F3D\",\"name\":\"Rock\"},{\"color\":{\"red\":207,\"green\":142,\"blue\":81},\"web\":\"#cf8e51\",\"name\":\"Whiskey Sour\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (157,15,5,'015060','Young Spartans Exercising',2,'https://www.nationalgallery.org.uk/paintings/hilaire-germain-edgar-degas-young-spartans-exercising','NG3860','Creative Commons BY-NC-ND 4.0','Young Spartans Exercising, also known as Young Spartans, is an oil on canvas painting by French impressionist artist Edgar Degas. The work depicts two groups of male and female Spartan youths exercising, though the subject matter of the painting has, in recent times, been challenged.','Young Spartans Exercising, also known as Young Spartans, is an oil on canvas painting by French impressionist artist Edgar Degas. The work depicts two groups of male and female Spartan youths exercising, though the subject matter of the painting has, in recent times, been challenged.',1860,110,155,'Oil on canvas',180.0000,220.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Young_Spartans_Exercising','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":100,\"green\":85,\"blue\":39},\"web\":\"#645527\",\"name\":\"West Coast\"},{\"color\":{\"red\":99,\"green\":80,\"blue\":47},\"web\":\"#63502F\",\"name\":\"Horses Neck\"},{\"color\":{\"red\":130,\"green\":112,\"blue\":78},\"web\":\"#82704E\",\"name\":\"Shadow\"},{\"color\":{\"red\":72,\"green\":53,\"blue\":24},\"web\":\"#483518\",\"name\":\"Clinker\"},{\"color\":{\"red\":113,\"green\":78,\"blue\":39},\"web\":\"#714E27\",\"name\":\"Cafe Royale\"},{\"color\":{\"red\":102,\"green\":110,\"blue\":82},\"web\":\"#666e52\",\"name\":\"Siam\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (162,15,19,'015100','The Tub',2,'http://www.musee-orsay.fr/en/collections/works-in-focus/search/commentaire/commentaire_id/le-tub-7086.html','RF 4046','&copy; Home','Degas, in the Classic line of descent from Ingres as a draughtsman--and one of the greatest in Europe since the giants of the Renaissance--exchanged oil paint for pastel, as in this example, with a sense of greater freedom in being able to draw in the medium as well as to apply color. The word \"classic\" refers to his preoccupation with the human figure but not to any desire to depict an ideal type of humanity. ','Degas, in the Classic line of descent from Ingres as a draughtsman--and one of the greatest in Europe since the giants of the Renaissance--exchanged oil paint for pastel, as in this example, with a sense of greater freedom in being able to draw in the medium as well as to apply color.',1886,60,83,'Pastel on paper',875.0000,890.0000,NULL,NULL,'http://www.ibiblio.org/wm/paint/auth/degas/combing-hair/','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":174,\"green\":152,\"blue\":121},\"web\":\"#AE9879\",\"name\":\"Bronco\"},{\"color\":{\"red\":209,\"green\":173,\"blue\":122},\"web\":\"#D1AD7A\",\"name\":\"Calico\"},{\"color\":{\"red\":212,\"green\":188,\"blue\":156},\"web\":\"#D4BC9C\",\"name\":\"Vanilla\"},{\"color\":{\"red\":141,\"green\":117,\"blue\":89},\"web\":\"#8D7559\",\"name\":\"Cement\"},{\"color\":{\"red\":193,\"green\":139,\"blue\":65},\"web\":\"#C18B41\",\"name\":\"Anzac\"},{\"color\":{\"red\":133,\"green\":82,\"blue\":42},\"web\":\"#85522A\",\"name\":\"Korma\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (165,16,7,'016010','Little Girl in a Blue Chair',2,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.61368.html','1983.1.18','Open Access','Little Girl in a Blue Armchair stands as a testament to the newly formed relationship between Mary Cassatt and the impressionists, and to her assimilation of a freer style of painting. With a limited palette and vibrant brushstroke, she created a dynamic interplay of forms that is echoed in this captured moment between rest and play.','Little Girl in a Blue Armchair stands as a testament to the newly formed relationship between Mary Cassatt and the impressionists',1878,90,130,'Oil on canvas',670.0000,800.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":193,\"green\":194,\"blue\":184},\"web\":\"#C1C2B8\",\"name\":\"Kidnapper\"},{\"color\":{\"red\":178,\"green\":160,\"blue\":137},\"web\":\"#B2A089\",\"name\":\"Bronco\"},{\"color\":{\"red\":53,\"green\":129,\"blue\":140},\"web\":\"#35818C\",\"name\":\"Blue Chill\"},{\"color\":{\"red\":109,\"green\":161,\"blue\":157},\"web\":\"#6DA19D\",\"name\":\"Cadet Blue\"},{\"color\":{\"red\":89,\"green\":84,\"blue\":66},\"web\":\"#595442\",\"name\":\"Millbrook\"},{\"color\":{\"red\":204,\"green\":184,\"blue\":161},\"web\":\"#CCB8A1\",\"name\":\"Grain Brown\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (167,16,11,'016030','Bath',1,'http://www.artic.edu/aic/collections/artwork/111442',NULL,'Rights-Managed (RM)','The Child\'s Bath (or The Bath) is an 1893 oil painting by American artist Mary Cassatt. The subject matter and the overhead perspective were inspired by Japanese woodblocks. It shows dignity in motherhood and has a style similar to that of Degas.','The Child\'s Bath (or The Bath) is an 1893 oil painting by American artist Mary Cassatt. The subject matter and the overhead perspective were inspired by Japanese woodblocks. It shows dignity in motherhood and has a style similar to that of Degas.',1891,100,66,'Oil on canvas',725.0000,900.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Child%27s_Bath','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":91,\"green\":87,\"blue\":65},\"web\":\"#5B5741\",\"name\":\"Millbrook\"},{\"color\":{\"red\":87,\"green\":53,\"blue\":38},\"web\":\"#573526\",\"name\":\"Carnaby Tan\"},{\"color\":{\"red\":84,\"green\":86,\"blue\":85},\"web\":\"#545655\",\"name\":\"Cape Cod\"},{\"color\":{\"red\":119,\"green\":118,\"blue\":121},\"web\":\"#777679\",\"name\":\"Topaz\"},{\"color\":{\"red\":155,\"green\":155,\"blue\":161},\"web\":\"#9B9BA1\",\"name\":\"Santas Grey\"},{\"color\":{\"red\":74,\"green\":87,\"blue\":104},\"web\":\"#4A5768\",\"name\":\"East Bay\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (171,18,20,'018010','Still Life with Three Puppies',5,'http://www.moma.org/collection/works/78616?locale=en','48.1952','&copy; Art Resource','This painting features three distinct zones: a still life of fruit in the foreground, a row of three blue goblets and apples diagonally bisecting the canvas, and three puppies drinking from a large pan. The incongruous scale and placement of these objects on a dramatically upturned tabletop results in a disorienting composition.','This painting features three distinct zones: a still life of fruit in the foreground, a row of three blue goblets and apples diagonally bisecting the canvas, and three puppies drinking from a large pan. The incongruous scale and placement of these objects on a dramatically upturned tabletop results in a disorienting composition.',1888,88,62,'Oil on canvas',875.0000,1225.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":73,\"green\":79,\"blue\":80},\"web\":\"#494F50\",\"name\":\"Trout\"},{\"color\":{\"red\":202,\"green\":199,\"blue\":179},\"web\":\"#CAC7B3\",\"name\":\"Chrome White\"},{\"color\":{\"red\":72,\"green\":81,\"blue\":100},\"web\":\"#485164\",\"name\":\"East Bay\"},{\"color\":{\"red\":116,\"green\":119,\"blue\":114},\"web\":\"#747772\",\"name\":\"Camouflage Green\"},{\"color\":{\"red\":187,\"green\":108,\"blue\":75},\"web\":\"#bb6c4b\",\"name\":\"Red Damask\"},{\"color\":{\"red\":136,\"green\":142,\"blue\":98},\"web\":\"#888e62\",\"name\":\"Bitter\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (172,18,51,'018060','Spirit of the Dead Watching',2,'https://www.albrightknox.org/collection/search/piece:511/','515','Public Domain','Spirit of the Dead Watching (Manao tupapau) is an 1892 oil on burlap canvas painting by Paul Gauguin, depicting a nude Tahitian girl lying on her stomach. An old woman is seated behind her. In Tahitian mythology the title may refer to either the girl imagining the ghost, or the ghost imagining her.','Spirit of the Dead Watching (Manao tupapau) is an 1892 oil on burlap canvas painting by Paul Gauguin, depicting a nude Tahitian girl lying on her stomach. An old woman is seated behind her. In Tahitian mythology the title may refer to either the girl imagining the ghost, or the ghost imagining her.',1892,72,92,'Oil on burlap mounted on canvas',225.0000,325.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Spirit_of_the_Dead_Watching','{\"safeSearchAnnotation\":{\"violence\":2,\"racy\":5},\"dominantColors\":[{\"color\":{\"red\":176,\"green\":161,\"blue\":129},\"web\":\"#B0A181\",\"name\":\"Pavlova\"},{\"color\":{\"red\":89,\"green\":51,\"blue\":41},\"web\":\"#593329\",\"name\":\"Redwood\"},{\"color\":{\"red\":100,\"green\":67,\"blue\":100},\"web\":\"#644364\",\"name\":\"Seance\"},{\"color\":{\"red\":171,\"green\":86,\"blue\":106},\"web\":\"#AB566A\",\"name\":\"Blush\"},{\"color\":{\"red\":164,\"green\":110,\"blue\":62},\"web\":\"#A46E3E\",\"name\":\"Bourbon\"},{\"color\":{\"red\":33,\"green\":26,\"blue\":45},\"web\":\"#211a2d\",\"name\":\"Haiti\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (173,12,19,'012010','Luncheon on the Grass',2,'http://www.musee-orsay.fr/en/collections/works-in-focus/search/commentaire/commentaire_id/le-dejeuner-sur-lherbe-7123.html','RF 1668','&copy; Home','The Luncheon on the Grass (Le dejeuner sur l\'herbe) was rejected by the Paris Salon in 1863 but Manet exhibited it at the Salon des Refuses (Salon of the Rejected) later in the year. Emperor Napoleon III had initiated The Salon des Refuses after the Paris Salon rejected more than 4,000 paintings in 1863.','The Luncheon on the Grass (Le dejeuner sur l\'herbe) was rejected by the Paris Salon in 1863 but Manet exhibited it at the Salon des Refuses (Salon of the Rejected) later in the year. ',1863,214,269,'Oil on canvas',1225.0000,1300.0000,'https://www.google.com/culturalinstitute/beta/asset/luncheon-on-the-grass/twELHYoc3ID_VA',NULL,'http://en.wikipedia.org/wiki/Le_d%C3%A9jeuner_sur_l%27herbe','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":245,\"green\":225,\"blue\":190},\"web\":\"#F5E1BE\",\"name\":\"Dutch White\"},{\"color\":{\"red\":170,\"green\":151,\"blue\":95},\"web\":\"#AA975F\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":213,\"green\":194,\"blue\":160},\"web\":\"#D5C2A0\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":171,\"green\":155,\"blue\":122},\"web\":\"#AB9B7A\",\"name\":\"Bronco\"},{\"color\":{\"red\":112,\"green\":119,\"blue\":130},\"web\":\"#707782\",\"name\":\"Storm Grey\"},{\"color\":{\"red\":64,\"green\":53,\"blue\":29},\"web\":\"#40351D\",\"name\":\"Mikado\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (178,13,7,'013010','Symphony in White, No. 1: The White Girl',5,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.12198.html','1943.6.2','Open Access','Symphony in White, No. 1, also known as The White Girl, is a painting by James Abbott McNeill Whistler. The work shows a woman in full figure standing on a wolf skin in front of a white curtain with a lily in her hand. The colour scheme of the painting is almost entirely white. The model is Joanna Heffernan, the artist\'s mistress. Though the painting was originally called The White Girl, Whistler later started calling it Symphony in White, No. 1. By referring to his work in such abstract terms, he intended to emphasise his \"art for art\'s sake\" philosophy.','Symphony in White, No. 1, also known as The White Girl, is a painting by James Abbott McNeill Whistler. The work shows a woman in full figure standing on a wolf skin in front of a white curtain with a lily in her hand. The colour scheme of the painting is almost entirely white.',1862,215,108,'Oil on canvas',700.0000,900.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Symphony_in_White,_No._1:_The_White_Girl','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":208,\"green\":197,\"blue\":190},\"web\":\"#D0C5BE\",\"name\":\"Pale Slate\"},{\"color\":{\"red\":201,\"green\":185,\"blue\":165},\"web\":\"#C9B9A5\",\"name\":\"Grain Brown\"},{\"color\":{\"red\":178,\"green\":161,\"blue\":142},\"web\":\"#B2A18E\",\"name\":\"Cloudy\"},{\"color\":{\"red\":177,\"green\":164,\"blue\":155},\"web\":\"#B1A49B\",\"name\":\"Silk\"},{\"color\":{\"red\":228,\"green\":216,\"blue\":210},\"web\":\"#E4D8D2\",\"name\":\"Dawn Pink\"},{\"color\":{\"red\":143,\"green\":122,\"blue\":100},\"web\":\"#8F7A64\",\"name\":\"Squirrel\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (179,14,7,'014060','Pont Neuf, Paris',2,'https://www.nga.gov/collection/art-object-page.52202.html','1970.17.58','Open Access','While his figure paintings are better known, Renoir\'s landscapes resonate with a vigor and freshness of vision central to the development of impressionism, most apparent here in his transcription of the effects of sunlight. Midday sun suffuses the panorama, its intensity heightening the artist\'s palette and suppressing incidental detail to clarify the crowded scene. Painted in the wake of the Franco–Prussian War and ensuing civil strife that had devastated France in 1870 and 1871, Renoir\'s 1872 image shows a representative sampling of French citizenry crossing the oldest bridge in Paris, the intact heart of the recovering country.','Painted in the wake of the Franco–Prussian War and ensuing civil strife that had devastated France in 1870 and 1871, Renoir\'s 1872 image shows a representative sampling of French citizenry crossing the oldest bridge in Paris, the intact heart of the recovering country.',1872,94,75,'Oil on Canvcas',125.0000,200.0000,'https://artsandculture.google.com/asset/pont-neuf-paris/WAFRh_vU9ZvTPg',NULL,'https://fr.wikipedia.org/wiki/Le_Pont-Neuf','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":130,\"green\":169,\"blue\":199},\"web\":\"#82A9C7\",\"name\":\"Polo Blue\"},{\"color\":{\"red\":112,\"green\":161,\"blue\":207},\"web\":\"#70A1CF\",\"name\":\"Picton Blue\"},{\"color\":{\"red\":179,\"green\":194,\"blue\":193},\"web\":\"#B3C2C1\",\"name\":\"Jungle Mist\"},{\"color\":{\"red\":145,\"green\":155,\"blue\":147},\"web\":\"#919B93\",\"name\":\"Pewter\"},{\"color\":{\"red\":119,\"green\":124,\"blue\":102},\"web\":\"#777C66\",\"name\":\"Finch\"},{\"color\":{\"red\":100,\"green\":124,\"blue\":115},\"web\":\"#647C73\",\"name\":\"Cutty Shark\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (181,8,2,'008010','The Shootings of May Third 1808',2,'https://www.museodelprado.es/en/the-collection/art-work/the-3rd-of-may-1808-in-madrid-or-the-executions/5e177409-2993-4240-97fb-847a02c6496c','P00749','Private, personal, academic, research or educational','The Third of May 1808 is a painting completed in 1814 by the Spanish painter Francisco Goya, now in the Museo del Prado, Madrid. In the work, Goya sought to commemorate Spanish resistance to Napoleon\'s armies during the occupation of 1808. Along with its companion piece of the same size, The Second of May 1808 (or The Charge of the Mamelukes), it was commissioned by the provisional government of Spain at Goya\'s suggestion.','The Third of May 1808 is a painting completed in 1814 by the Spanish painter Francisco Goya, now in the Museo del Prado, Madrid. In the work, Goya sought to commemorate Spanish resistance to Napoleon\'s armies during the occupation of 1808. Along with its companion piece of the same size, The Second of May 1808 (or The Charge of the Mamelukes), it was commissioned by the provisional government of Spain at Goya\'s suggestion.',1814,268,347,'Oil on canvas',400.0000,650.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Third_of_May_1808','{\"safeSearchAnnotation\":{\"violence\":5,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":98,\"green\":82,\"blue\":59},\"web\":\"#62523B\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":172,\"green\":151,\"blue\":123},\"web\":\"#AC977B\",\"name\":\"Bronco\"},{\"color\":{\"red\":207,\"green\":189,\"blue\":165},\"web\":\"#CFBDA5\",\"name\":\"Soft Amber\"},{\"color\":{\"red\":66,\"green\":52,\"blue\":33},\"web\":\"#423421\",\"name\":\"Clinker\"},{\"color\":{\"red\":178,\"green\":150,\"blue\":92},\"web\":\"#B2965C\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":99,\"green\":49,\"blue\":26},\"web\":\"#63311a\",\"name\":\"Baker\'s Chocolate\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (182,10,19,'010060','The Painter\'s Studio; A Real Allegory',4,'http://www.musee-orsay.fr/en/collections/works-in-focus/search/commentaire/commentaire_id/latelier-du-peintre-7091.html','RF 2257','&copy; Home','The Artist\'s Studio: A Real Allegory of a Seven Year Phase in my Artistic and Moral Life is an allegory of Coubet\'s life as a painter, seen as an heroic venture, in which he is flanked by friends and admirers on the right, and challenges and opposition to the left. Friends on the right include the art critics Champfleury, and Charles Baudelaire, and art collector Alfred Bruyas. On the left are figures (priest, prostitute, grave digger, merchant and others) who represent what Courbet described in a letter to Champfleury as \"the other world of trivial life, the people, misery, poverty, wealth, the exploited and the exploiters, the people who live off death.\"','The Artist\'s Studio: A Real Allegory of a Seven Year Phase in my Artistic and Moral Life is an allegory of Coubet\'s life as a painter, seen as an heroic venture, in which he is flanked by friends and admirers on the right, and challenges and opposition to the left.',1855,361,598,'Oil on canvas',1225.0000,1325.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Artist%27s_Studio','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":136,\"green\":114,\"blue\":89},\"web\":\"#887259\",\"name\":\"Cement\"},{\"color\":{\"red\":31,\"green\":25,\"blue\":21},\"web\":\"#1F1915\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":101,\"green\":83,\"blue\":61},\"web\":\"#65533D\",\"name\":\"Tobacco Brown\"},{\"color\":{\"red\":171,\"green\":150,\"blue\":122},\"web\":\"#AB967A\",\"name\":\"Bronco\"},{\"color\":{\"red\":64,\"green\":51,\"blue\":32},\"web\":\"#403320\",\"name\":\"Mikado\"},{\"color\":{\"red\":243,\"green\":231,\"blue\":203},\"web\":\"#F3E7CB\",\"name\":\"Gin Fizz\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (190,28,20,'028040','La Goulue Arriving at the Moulin Rouge with Two Women',1,'http://www.moma.org/collection/works/34936?locale=en','161.1957','&copy; Art Resource','Louise Weber, nicknamed La Goulue (the glutton), is depicted in the Moulin Rouge Montmartre cabaret frequented by the Parisian demimonde flanked by her sister to her right and, to her left, her lover.','Louise Weber, nicknamed La Goulue (the glutton), is depicted in the Moulin Rouge Montmartre cabaret frequented by the Parisian demimonde flanked by her sister to her right and, to her left, her lover.',1892,79,59,'Oil on canvas',1400.0000,1450.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":34,\"green\":72,\"blue\":61},\"web\":\"#22483d\",\"name\":\"Te Papa Green\"},{\"color\":{\"red\":92,\"green\":85,\"blue\":64},\"web\":\"#5C5540\",\"name\":\"Millbrook\"},{\"color\":{\"red\":154,\"green\":156,\"blue\":147},\"web\":\"#9A9C93\",\"name\":\"Delta\"},{\"color\":{\"red\":86,\"green\":83,\"blue\":76},\"web\":\"#56534C\",\"name\":\"Masala\"},{\"color\":{\"red\":97,\"green\":56,\"blue\":50},\"web\":\"#613832\",\"name\":\"Redwood\"},{\"color\":{\"red\":201,\"green\":79,\"blue\":74},\"web\":\"#c94f4a\",\"name\":\"Sunset\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (191,28,70,'028020','Moulin Rouge La Goulue',1,'http://collection.imamuseum.org/artwork/44070/','36.4','Public Domain','The Moulin Rouge dance hall opened in Montmartre in 1889 and Toulouse-Lautrec was a regular from the beginning. For his first poster and for the first time in poster design, Toulouse-Lautrec featured the actual entertainers in the advertisement: La Goulue (the Glutton) dancing the can-can accompanied by her partner \"No-Bones\" Valentin.\r\n\r\nNo one in the fall of 1891 would have predicted that this ephemeral advertisement would become within days a collected item, within weeks the object of press reviews, within months the partner of paintings in avant-garde exhibitions, and within a year the internationally recognized symbol of 1890s Paris.','For his first poster and for the first time in poster design, Toulouse-Lautrec featured the actual entertainers in the advertisement',1891,191,117,'Poster',80.0000,100.0000,'https://www.google.com/culturalinstitute/beta/asset/moulin-rouge-la-goulue/HwHWsv1o7adJ3A','The Moulin Rouge dance hall opened in Montmartre in 1889 and Toulouse-Lautrec was a regular from the beginning.├┐ For his first poster and for the first time in poster design, Toulouse-Lautrec featured the actual entertainers in the advertisement: La Goulue (the Glutton) dancing the can-can accompanied by her partner \"No-Bones\" Valentin. No one in the fall of 1891 would have predicted that this ephemeral advertisement would become within days a collected item, within weeks the object of press reviews, within months the partner of paintings in avant-garde exhibitions, and within a year the internationally recognized symbol of 1890s Paris.','http://fr.wikipedia.org/wiki/Moulin_rouge_-_La_Goulue','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":151,\"green\":108,\"blue\":60},\"web\":\"#976C3C\",\"name\":\"McKenzie\"},{\"color\":{\"red\":252,\"green\":173,\"blue\":12},\"web\":\"#FCAD0C\",\"name\":\"Dark Tangerine\"},{\"color\":{\"red\":49,\"green\":18,\"blue\":2},\"web\":\"#1C0D09\",\"name\":\"Seal Brown\"},{\"color\":{\"red\":121,\"green\":76,\"blue\":31},\"web\":\"#794C1F\",\"name\":\"Russet\"},{\"color\":{\"red\":198,\"green\":78,\"blue\":20},\"web\":\"#c64e14\",\"name\":\"Rust\"},{\"color\":{\"red\":198,\"green\":141,\"blue\":58},\"web\":\"#C68D3A\",\"name\":\"Anzac\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (192,29,22,'029010','The Kiss',3,'http://digital.belvedere.at/objects/6678/liebespaar','912','Private use','The Kiss (original Der Kuss) was painted by Gustav Klimt, and is probably his most famous work. He began work on it in 1907 and it is the highpoint of his so-called \'Golden Period\', when he painted a number of works in a similar style. It depicts a couple embracing, their bodies largely hidden by elaborate robes decorated in a style that bears little relation to any historical textile designs. As well as conventional oil paint, gold leaf has been used, one of the aspects of the work that gives it a strikingly modern appearance, while evoking memories of much earlier art. The painting is now in the Aûsterreichische Galerie Belvedere museum, in the Belvedere palace, in Vienna, Austria.','The Kiss (original Der Kuss) was painted by Gustav Klimt, and is probably his most famous work. He began work on it in 1907 and it is the highpoint of his so-called \'Golden Period\', when he painted a number of works in a similar style.',1907,180,180,'Oil and gold on canvas',230.0000,320.0000,'https://www.google.com/culturalinstitute/beta/asset/the-kiss/HQGxUutM_F6ZGg','ÔÇ£The KissÔÇØ, probably the most popular work by Gustav Klimt, was first exhibited in 1908 at the Kunstschau art exhibition on the site of todayÔÇÖs Konzerthaus. The Ministry bought it from there for the sum of 25,000 Kronen and thus secured for the state one of the icons of Viennese Jugendstil and indeed of European modern art. It undoubtedly represents the culmination of the phase known as the ÔÇ£Golden EpochÔÇØ. In this decade, the artist created a puzzling, ornamental encoded programme that revolved around the mystery of existence, love and fulfilment through art. Klimt gained initial inspiration for this in 1903 on a journey to Ravenna to see the Byzantine mosaics. In addition, the painting contains a myriad of motifs from various cultural epochs, above all from Ancient Egyptian mythology. Most recent research has, however, revealed that it is not enough to read the ornaments in the picture just as symbols rooted in tradition aiming to convey a timelessly valid message. They reveal more, such as references to KlimtÔÇÖs love for Emilie Fl├Âge and the artistÔÇÖs exploration of the sculptor Auguste RodinÔÇÖs art.','http://en.wikipedia.org/wiki/The_Kiss_(Klimt_painting)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":191,\"green\":164,\"blue\":73},\"web\":\"#BFA449\",\"name\":\"Sundance\"},{\"color\":{\"red\":207,\"green\":180,\"blue\":84},\"web\":\"#CFB454\",\"name\":\"Tacha\"},{\"color\":{\"red\":181,\"green\":159,\"blue\":93},\"web\":\"#B59F5D\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":132,\"green\":144,\"blue\":95},\"web\":\"#84905f\",\"name\":\"Bitter\"},{\"color\":{\"red\":204,\"green\":183,\"blue\":115},\"web\":\"#CCB773\",\"name\":\"Putty\"},{\"color\":{\"red\":148,\"green\":122,\"blue\":137},\"web\":\"#947a89\",\"name\":\"Mountbatten Pink\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (194,32,24,'032020','Portrait of a Girl in Black',1,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/28225/?lng=en','9125','Personal non-commercial use',NULL,NULL,1913,116,89,'Oil on canvas',320.0000,360.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":151,\"green\":152,\"blue\":174},\"web\":\"#9798AE\",\"name\":\"Logan\"},{\"color\":{\"red\":188,\"green\":184,\"blue\":196},\"web\":\"#BCB8C4\",\"name\":\"French Grey\"},{\"color\":{\"red\":178,\"green\":184,\"blue\":203},\"web\":\"#B2B8CB\",\"name\":\"Echo Blue\"},{\"color\":{\"red\":94,\"green\":78,\"blue\":78},\"web\":\"#5E4E4E\",\"name\":\"Matterhorn\"},{\"color\":{\"red\":240,\"green\":227,\"blue\":239},\"web\":\"#Selago\",\"name\":\"F0E3EF\"},{\"color\":{\"red\":161,\"green\":157,\"blue\":169},\"web\":\"#A19DA9\",\"name\":\"Spun Pearl\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (195,32,42,'032030','Landscape in Provence',2,'https://www.brooklynmuseum.org/opencollection/objects/4725','39.273','Creative Commons - Attribution',NULL,NULL,1908,32,41,'Oil on canvas',1180.0000,1210.0000,NULL,NULL,'http://www.brooklynmuseum.org/opencollection/objects/4725/Landscape_in_Provence_Paysage_de_Provence','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":125,\"green\":80,\"blue\":37},\"web\":\"#7D5025\",\"name\":\"Korma\"},{\"color\":{\"red\":95,\"green\":80,\"blue\":53},\"web\":\"#5F5035\",\"name\":\"West Coast\"},{\"color\":{\"red\":46,\"green\":50,\"blue\":48},\"web\":\"#2E3230\",\"name\":\"Holly\"},{\"color\":{\"red\":180,\"green\":164,\"blue\":135},\"web\":\"#B4A487\",\"name\":\"Pavlova\"},{\"color\":{\"red\":107,\"green\":86,\"blue\":32},\"web\":\"#6B5620\",\"name\":\"Horses Neck\"},{\"color\":{\"red\":72,\"green\":91,\"blue\":59},\"web\":\"#485B3B\",\"name\":\"Cabbage Pont\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (213,45,13,'045030','Soft Construction with Boiled Beans',2,'http://www.philamuseum.org/collections/permanent/51315.html','1950-134-41','Salvador Dali, Gala-Salvador Dali Foundation / Artists Rights Society','Depicted is a grimacing dismembered figure symbolic of the Spanish state in civil war, alternately grasping upward at itself and holding itself down underfoot, a relationship morbidly prescient of Escher\'s later Drawing Hands (1948). The painting resides at the Philadelphia Museum of Art.','Depicted is a grimacing dismembered figure symbolic of the Spanish state in civil war, alternately grasping upward at itself and holding itself down underfoot, a relationship morbidly prescient of Escher\'s later Drawing Hands (1948). ',1936,100,99,'Oil on canvas',300.0000,340.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Soft_Construction_with_Boiled_Beans_(Premonition_of_Civil_War)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":5,\"green\":77,\"blue\":169},\"web\":\"#054DA9\",\"name\":\"Cobalt\"},{\"color\":{\"red\":183,\"green\":149,\"blue\":62},\"web\":\"B7953E\",\"name\":\"Roti\"},{\"color\":{\"red\":141,\"green\":159,\"blue\":121},\"web\":\"#8D9F79\",\"name\":\"Sage\"},{\"color\":{\"red\":67,\"green\":127,\"blue\":184},\"web\":\"#437FB8\",\"name\":\"Steel Blue\"},{\"color\":{\"red\":158,\"green\":160,\"blue\":133},\"web\":\"#9EA085\",\"name\":\"Lemon Grass\"},{\"color\":{\"red\":133,\"green\":116,\"blue\":51},\"web\":\"#857433\",\"name\":\"Corn Harvest\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (214,133,82,'133050','The Conscript’s Farewell',2,'https://www.leopoldmuseum.org/en/leopoldcollection/focus/19century','634','&copy; Leopold Museum','','',1854,74,59,'Oil on wood',290.0000,350.0000,'https://artsandculture.google.com/asset/the-conscript%E2%80%99s-farewell/MgEp01gC5WK-Tg',NULL,'','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":115,\"green\":74,\"blue\":54},\"web\":\"#734A36\",\"name\":\"Cape Palliser\"},{\"color\":{\"red\":177,\"green\":151,\"blue\":125},\"web\":\"#B1977D\",\"name\":\"Sandrift\"},{\"color\":{\"red\":103,\"green\":38,\"blue\":14},\"web\":\"#67260E\",\"name\":\"Baker\'s Chocolate\"},{\"color\":{\"red\":90,\"green\":124,\"blue\":136},\"web\":\"#5a7c88\",\"name\":\"Hoki\"},{\"color\":{\"red\":100,\"green\":81,\"blue\":60},\"web\":\"#64513C\",\"name\":\"Rock\"},{\"color\":{\"red\":161,\"green\":61,\"blue\":46},\"web\":\"#a13d2e\",\"name\":\"Rock Spray\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (225,60,35,'060010','Red Balloon',3,'https://www.guggenheim.org/artwork/2143','48.1172.524','Artists Rights Society','Red Balloon is at once a cluster of delicately colored, floating geometric shapes and a charming cityscape.','Red Balloon is at once a cluster of delicately colored, floating geometric shapes and a charming cityscape.',1922,32,31,'Oil on muslin primed with chalk',230.0000,280.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":176,\"green\":155,\"blue\":97},\"web\":\"#B09B61\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":158,\"green\":34,\"blue\":24},\"web\":\"#9E2218\",\"name\":\"Mandarian Orange\"},{\"color\":{\"red\":214,\"green\":32,\"blue\":21},\"web\":\"#D62015\",\"name\":\"Harley Davidson Orange\"},{\"color\":{\"red\":188,\"green\":155,\"blue\":65},\"web\":\"#BC9B41\",\"name\":\"Roti\"},{\"color\":{\"red\":90,\"green\":115,\"blue\":68},\"web\":\"#5a7344\",\"name\":\"Chalet Green\"},{\"color\":{\"red\":72,\"green\":89,\"blue\":114},\"web\":\"#485972\",\"name\":\"Chambray\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (230,60,6,'060040','Tale à la Hoffmann',1,'https://www.metmuseum.org/art/collection/search/483143','1984.315.26','Artists Rights Society','Klee loved the tales of the German poet and writer E. T. A. Hoffmann (1776-1822), who was nicknamed \"Ghost Hoffmann\" in his own country. Tale à la Hoffmann appears to be loosely based on the poet\'s best-known lyrical tale, The Golden Pot (1814), a magical story that switches back and forth between high fantasy and everyday life in Dresden. It recounts the trials of the pure and foolish young Anselmus and his efforts to gain entry to Atlantis, the heaven of poetry. The tree from which Anselmus first heard fateful voices speaking to him might thus be on the left. The odd, tubelike construction on the right perhaps represents the glass bottle in which Anselmus found himself briefly imprisoned. The tale\'s repeated references to time are reflected in the two clocks, and the vessel in the center may stand for the golden pot with the fantastic lily that gives the story its name.','Tale à la Hoffmann appears to be loosely based on the poet\'s best-known lyrical tale, The Golden Pot (1814), a magical story that switches back and forth between high fantasy and everyday life in Dresden',1921,32,40,'Watercolor and ink; oil transfer on paper with gouache and ink borders on cardboard',600.0000,800.0000,NULL,NULL,'https://commons.wikimedia.org/wiki/File:Tale_%C3%A0_la_Hoffmann_MET_DT1768.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":217,\"green\":195,\"blue\":136},\"web\":\"#D9C388\",\"name\":\"Zombie\"},{\"color\":{\"red\":179,\"green\":155,\"blue\":98},\"web\":\"#B39B62\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":174,\"green\":155,\"blue\":123},\"web\":\"#AE9B7B\",\"name\":\"Bronco\"},{\"color\":{\"red\":219,\"green\":193,\"blue\":98},\"web\":\"#DBC162\",\"name\":\"Tacha\"},{\"color\":{\"red\":208,\"green\":140,\"blue\":124},\"web\":\"#d08c7c\",\"name\":\"My Pink\"},{\"color\":{\"red\":140,\"green\":90,\"blue\":29},\"web\":\"#8c5a1d\",\"name\":\"Afghan Tan\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (231,63,20,'063010','Dream',2,'http://www.moma.org/collection/works/79277?locale=en','252.1954','&copy; Art Resource','Although Rousseau completed more than twenty-five jungle paintings in his career, he never traveled outside France. He instead drew on images of the exotic as it was presented to the urban dweller through popular literature, colonial expositions, and the Paris Zoo. The lush jungle, wild animals, and mysterious horn player featured in this work were inspired by Rousseau\'s visits to the city\'s natural history museum and Jardin des plantes (a combined zoo and botanical garden). Of his visits the artist said, \"When I am in these hothouses and see the strange plants from exotic lands, it seems to me that I am entering a dream.\" The nude model in this painting reclines on a sofa, mixing the domestic and the exotic.','Although Rousseau completed more than twenty-five jungle paintings in his career, he never traveled outside France. He instead drew on images of the exotic as it was presented to the urban dweller through popular literature, colonial expositions, and the Paris Zoo.',1910,204,298,'Oil on canvas',830.0000,975.0000,'http://www.googleartproject.com/museums/moma/the-dream-32',NULL,'http://www.moma.org/collection/browse_results.php?object_id=79277','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":120,\"green\":107,\"blue\":86},\"web\":\"#786b56\",\"name\":\"Coffee\"},{\"color\":{\"red\":123,\"green\":140,\"blue\":135},\"web\":\"#7b8c87\",\"name\":\"Granny Smith\"},{\"color\":{\"red\":48,\"green\":51,\"blue\":46},\"web\":\"#30332E\",\"name\":\"Oil\"},{\"color\":{\"red\":76,\"green\":78,\"blue\":71},\"web\":\"#4C4E47\",\"name\":\"Gravel\"},{\"color\":{\"red\":117,\"green\":120,\"blue\":113},\"web\":\"#757871\",\"name\":\"Gunsmoke\"},{\"color\":{\"red\":68,\"green\":83,\"blue\":67},\"web\":\"#445343\",\"name\":\"Grey-Asparagus\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (232,63,20,'063020','Sleeping Gypsy',2,'http://www.moma.org/collection/works/80172?locale=en','646.1939','&copy; Art Resource','Rousseau described the subject of The Sleeping Gypsy: A wandering Negress, a mandolin player, lies with her jar beside her (a vase with drinking water), overcome by fatigue in a deep sleep. A lion chances to pass by, picks up her scent yet does not devour her. There is a moonlight effect, very poetic. A toll collector for the city of Paris, Rousseau was a largely self-taught painter, although he had ambitions of entering the Academy. This goal was never realized, but his sharp colors, fantastic imagery, and precise outlines-derived from the style and subject matter of popular print culture struck a chord with a younger generation of avant-garde painters, including Pablo Picasso, Vasily Kandinsky, and Frida Kahlo.','Rousseau described the subject of The Sleeping Gypsy: A wandering Negress, a mandolin player, lies with her jar beside her (a vase with drinking water), overcome by fatigue in a deep sleep. A lion chances to pass by, picks up her scent yet does not devour her. ',1897,130,201,'Oil on canvas',750.0000,950.0000,'http://www.googleartproject.com/museums/moma/the-sleeping-gypsy-24',NULL,'http://www.moma.org/collection/browse_results.php?object_id=80172','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":69,\"green\":82,\"blue\":88},\"web\":\"#455258\",\"name\":\"Trout\"},{\"color\":{\"red\":51,\"green\":45,\"blue\":40},\"web\":\"#332D28\",\"name\":\"Coffee Bean\"},{\"color\":{\"red\":34,\"green\":31,\"blue\":26},\"web\":\"#221F1A\",\"name\":\"Black Magic\"},{\"color\":{\"red\":107,\"green\":97,\"blue\":85},\"web\":\"#6b6155\",\"name\":\"Makara\"},{\"color\":{\"red\":95,\"green\":81,\"blue\":67},\"web\":\"#5F5143\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":111,\"green\":112,\"blue\":108},\"web\":\"#6F706C\",\"name\":\"Gunsmoke\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (233,64,20,'064010','Birthday',2,'http://www.moma.org/collection/works/79360?locale=en','275.1949','&copy; Art Resource',NULL,NULL,1915,80,100,'Oil on cardboard',460.0000,550.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":169,\"green\":162,\"blue\":142},\"web\":\"#a9a28e\",\"name\":\"Napa\"},{\"color\":{\"red\":144,\"green\":45,\"blue\":19},\"web\":\"#902d13\",\"name\":\"Burnt Umber\"},{\"color\":{\"red\":27,\"green\":32,\"blue\":29},\"web\":\"#1b201d\",\"name\":\"Midnight Moss\"},{\"color\":{\"red\":72,\"green\":66,\"blue\":58},\"web\":\"#48423a\",\"name\":\"Space Shuttle\"},{\"color\":{\"red\":128,\"green\":60,\"blue\":35},\"web\":\"#803c23\",\"name\":\"Copper Canyon\"},{\"color\":{\"red\":146,\"green\":93,\"blue\":65},\"web\":\"#925d41\",\"name\":\"Rope\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (235,64,20,'064030','I and the Village',1,'http://www.moma.org/collection/works/78984?locale=en','146.1945','Artists Rights Society','Painted the year after Chagall came to Paris, I and the Village evokes his memories of his native Hasidic community outside Vitebsk. In the village, peasants and animals lived side by side, in a mutual dependence here signified by the line from peasant to cow, connecting their eyes. The peasant\'s flowering sprig, symbolically a tree of life, is the reward of their partnership. For Hasids, animals were also humanity\'s link to the universe, and the painting\'s large circular forms suggest the orbiting sun, moon (in eclipse at the lower left), and earth.','Painted the year after Chagall came to Paris, I and the Village evokes his memories of his native Hasidic community outside Vitebsk.',1911,192,151,'Oil on canvas',800.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":146,\"green\":68,\"blue\":59},\"web\":\"#92443B\",\"name\":\"Mojo\"},{\"color\":{\"red\":193,\"green\":194,\"blue\":204},\"web\":\"#C1C2CC\",\"name\":\"Ghost\"},{\"color\":{\"red\":154,\"green\":156,\"blue\":178},\"web\":\"#9A9CB2\",\"name\":\"Logan\"},{\"color\":{\"red\":143,\"green\":107,\"blue\":124},\"web\":\"#8F6B7C\",\"name\":\"Strikemaster\"},{\"color\":{\"red\":60,\"green\":91,\"blue\":78},\"web\":\"#3C5B4E\",\"name\":\"Plantation\"},{\"color\":{\"red\":25,\"green\":46,\"blue\":104},\"web\":\"#192E68\",\"name\":\"Sapphire\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (258,73,17,'073010','Composition with Yellow, Blue and Red',3,'http://www.tate.org.uk/art/artworks/mondrian-composition-with-yellow-blue-and-red-t00648','T00648','Creative Commons CC-BY-NC-ND 3.0','Mondrian\'s interest lay in the abstract quality of line but by 1914 he had all but eliminated the curved line from his work. By 1916 he had suppressed any sense of a subject. Still later he developed a new form of rigorous abstraction called Neo-Plasticism in which he limited himself to straight, horizontal and vertical lines and basic primary colours. Typically his compositions were not symmetrical but could scarcely be purer in their elements. He felt this art reflected a greater, universal truth beyond everyday appearance.','Mondrian\'s interest lay in the abstract quality of line but by 1914 he had all but eliminated the curved line from his work. By 1916 he had suppressed any sense of a subject. Still later he developed a new form of rigorous abstraction called Neo-Plasticism in which he limited himself to straight, horizontal and vertical lines and basic primary colours. Typically his compositions were not symmetrical but could scarcely be purer in their elements. He felt this art reflected a greater, universal truth beyond everyday appearance.',1937,72,69,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":177,\"green\":78,\"blue\":46},\"web\":\"#B14E2E\",\"name\":\"Red Stage\"},{\"color\":{\"red\":232,\"green\":231,\"blue\":227},\"web\":\"#E8E7E3\",\"name\":\"Narvik\"},{\"color\":{\"red\":48,\"green\":47,\"blue\":44},\"web\":\"#302F2C\",\"name\":\"Graphite\"},{\"color\":{\"red\":235,\"green\":208,\"blue\":85},\"web\":\"#EBD055\",\"name\":\"Portica\"},{\"color\":{\"red\":138,\"green\":74,\"blue\":46},\"web\":\"#8A4A2E\",\"name\":\"Paarl\"},{\"color\":{\"red\":143,\"green\":129,\"blue\":75},\"web\":\"#5370A2\",\"name\":\"San Marino\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (259,73,20,'073020','Broadway Boogie Woogie',3,'http://www.moma.org/collection/works/78682?locale=en','73.1943','&copy; Art Resource','Mondrian, who had escaped to New York from Europe after the outbreak of World War II, delighted in the city\'s architecture. He was also fascinated by American jazz, particularly boogie-woogie, finding its syncopated beat, irreverent approach to melody, and improvisational aesthetic akin to what he called, in his own work, the \"destruction of natural appearance; and construction through continuous opposition of pure meansÔÇödynamic rhythm.\" In this painting, his penultimate, Mondrian replaced the black grid that had long governed his canvases with predominantly yellow lines that intersect at points marked by squares of blue and red. These atomized bands of stuttering chromatic pulses, interrupted by light gray, create paths across the canvas suggesting the city\'s grid, the movement of traffic, and blinking electric lights, as well as the rhythms of jazz.','These atomized bands of stuttering chromatic pulses, interrupted by light gray, create paths across the canvas suggesting the city\'s grid, the movement of traffic, and blinking electric lights, as well as the rhythms of jazz.',1942,127,127,'Oil on canvas',900.0000,1100.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":224,\"green\":211,\"blue\":26},\"web\":\"#E0D31A\",\"name\":\"Barberry\"},{\"color\":{\"red\":240,\"green\":240,\"blue\":238},\"web\":\"#F0F0EE\",\"name\":\"Sugar Cane\"},{\"color\":{\"red\":168,\"green\":49,\"blue\":38},\"web\":\"#A83126\",\"name\":\"Brown\"},{\"color\":{\"red\":73,\"green\":106,\"blue\":196},\"web\":\"#496AC4\",\"name\":\"Free Speech Blue\"},{\"color\":{\"red\":163,\"green\":166,\"blue\":178},\"web\":\"#a3a6b2\",\"name\":\"Mischka\"},{\"color\":{\"red\":223,\"green\":202,\"blue\":88},\"web\":\"#dfca58\",\"name\":\"Festival\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (287,12,19,'012020','Olympia',2,'http://www.musee-orsay.fr/en/collections/works-in-focus/search/commentaire/commentaire_id/olympia-7087.html','RF 644','&copy; Home','As he had in Luncheon on the Grass, Manet again paraphrased a respected work by a Renaissance artist in the painting Olympia (1863), a nude portrayed in a style reminiscent of early studio photographs, but whose pose was based on Titian\'s Venus of Urbino (1538). The painting is also reminiscent of Francisco Goya\'s painting, The Nude Maja (1800).','As he had in Luncheon on the Grass, Manet again paraphrased a respected work by a Renaissance artist in the painting Olympia (1863), a nude portrayed in a style reminiscent of early studio photographs, but whose pose was based on Titian\'s Venus of Urbino (1538). The painting is also reminiscent of Francisco Goya\'s painting, The Nude Maja (1800).',1863,130,190,'Oil on canvas',1175.0000,1225.0000,'https://www.google.com/culturalinstitute/beta/asset/olympia/ywFEI4rxgCSO1Q','With Olympia, Manet reworked the traditional theme of the female nude, using a strong, uncompromising technique. Both the subject matter and its depiction explain the scandal caused by this painting at the 1865 Salon.\r\n\r\nEven though Manet quoted numerous formal and iconographic references, such as Titian\'s Venus of Urbino, Goya\'s Maja desnuda, and the theme of the odalisque with her black slave, already handled by Ingres among others, the picture portrays the cold and prosaic reality of a truly contemporary subject.','http://en.wikipedia.org/wiki/Olympia_(Manet)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":195,\"green\":188,\"blue\":155},\"web\":\"#C3BC9B\",\"name\":\"Sisal\"},{\"color\":{\"red\":170,\"green\":162,\"blue\":132},\"web\":\"#AAA284\",\"name\":\"Neutral Green\"},{\"color\":{\"red\":128,\"green\":122,\"blue\":97},\"web\":\"#807A61\",\"name\":\"Olive Haze\"},{\"color\":{\"red\":93,\"green\":88,\"blue\":63},\"web\":\"#5D583F\",\"name\":\"Millbrook\"},{\"color\":{\"red\":29,\"green\":28,\"blue\":26},\"web\":\"#1d1c1a\",\"name\":\"Maire\"},{\"color\":{\"red\":192,\"green\":189,\"blue\":177},\"web\":\"#C0BDB1\",\"name\":\"Grey Nickel\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (288,12,5,'012050','Music in the Tuileries Gardens',2,'https://www.nationalgallery.org.uk/paintings/edouard-manet-music-in-the-tuileries-gardens','NG3260','Creative Commons BY-NC-ND 4.0','It is an early example of Manet\'s painterly style, inspired by Frans Hals and Diego Velázquez, and it is a harbinger of his life-long interest in the subject of leisure.','It is an early example of Manet\'s painterly style, inspired by Frans Hals and Diego Velázquez, and it is a harbinger of his life-long interest in the subject of leisure.',1862,76,118,'Oil on canvas',300.0000,350.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Music_in_the_Tuileries','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":37,\"green\":43,\"blue\":24},\"web\":\"#252b18\",\"name\":\"Rangoon Green\"},{\"color\":{\"red\":246,\"green\":224,\"blue\":156},\"web\":\"#F6E09C\",\"name\":\"Buttermilk\"},{\"color\":{\"red\":220,\"green\":196,\"blue\":134},\"web\":\"#DCC486\",\"name\":\"Zombie\"},{\"color\":{\"red\":202,\"green\":194,\"blue\":164},\"web\":\"#CAC2A4\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":163,\"green\":154,\"blue\":124},\"web\":\"#A39A7C\",\"name\":\"Grey Olive\"},{\"color\":{\"red\":69,\"green\":80,\"blue\":103},\"web\":\"#455067\",\"name\":\"East Bay\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (290,12,19,'012030','Balcony',1,'http://www.musee-orsay.fr/en/collections/works-in-focus/search/commentaire/commentaire_id/le-balcon-7121.html','RF 2772','&copy; Home','When Manet painted this piece, scenes of bourgeois life were in vogue. Yet The Balcony went against the conventions of the day. All the subjects were close acquaintances of the artist, especially Berthe Morisot who here, pictured sitting in the foreground, makes her first appearance in Manet\'s work, and who went on to become one of his favourite models. The painting tells no story or anecdote; the protagonists are frozen, as if isolated in an interior dream, evidence that Manet was freeing himself from academic constraints, despite the obvious reference to Goya\'s Majas at the Balcony.','The painting tells no story or anecdote; the protagonists are frozen, as if isolated in an interior dream, evidence that Manet was freeing himself from academic constraints, despite the obvious reference to Goya\'s Majas at the Balcony.',1868,170,124,'Oil on canvas',1175.0000,1225.0000,'https://www.google.com/culturalinstitute/beta/asset/the-balcony/ggFK0UgXAd7OCA','When Manet painted this piece, scenes of bourgeois life were in vogue. Yet The Balcony went against the conventions of the day. All the subjects were close acquaintances of the artist, especially Berthe Morisot who here, pictured sitting in the foreground, makes her first appearance in Manet\'s work, and who went on to become one of his favourite models. The painting tells no story or anecdote; the protagonists are frozen, as if isolated in an interior dream, evidence that Manet was freeing himself from academic constraints, despite the obvious reference to Goya\'s Majas at the Balcony.','https://commons.wikimedia.org/wiki/File:Edouard_Manet_-_The_Balcony_-_Google_Art_Project.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":47,\"green\":49,\"blue\":47},\"web\":\"#2F312F\",\"name\":\"Gordons Green\"},{\"color\":{\"red\":98,\"green\":123,\"blue\":111},\"web\":\"#627B6F\",\"name\":\"Sirocco\"},{\"color\":{\"red\":184,\"green\":193,\"blue\":193},\"web\":\"#B8C1C1\",\"name\":\"Jungle Mist\"},{\"color\":{\"red\":80,\"green\":87,\"blue\":81},\"web\":\"#505751\",\"name\":\"Nandor\"},{\"color\":{\"red\":69,\"green\":92,\"blue\":81},\"web\":\"#455C51\",\"name\":\"Viridian Green\"},{\"color\":{\"red\":203,\"green\":194,\"blue\":169},\"web\":\"#CBC2A9\",\"name\":\"Double Spanish White\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (291,12,7,'012040','Railroad',3,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.43624.html','1956.10.1','Open Access','The Railway, widely known as The Gare Saint-Lazare, was painted in 1873. The setting is the urban landscape of Paris in the late 19th century. Using his favorite model in his last painting of her, a fellow painter, Victorine Meurent, also the model for Olympia and the Luncheon on the Grass, sits before an iron fence holding a sleeping puppy and an open book in her lap. Next to her is a little girl with her back to the painter, who watches a train pass beneath them.','The setting is the urban landscape of Paris in the late 19th century. Using his favorite model in his last painting of her, a fellow painter, Victorine Meurent, also the model for Olympia and the Luncheon on the Grass, sits before an iron fence holding a sleeping puppy and an open book in her lap. Next to her is a little girl with her back to the painter, who watches a train pass beneath them.',1872,93,112,'Oil on canvas',725.0000,860.0000,'https://www.google.com/culturalinstitute/beta/asset/the-railway/kAHNAxL76AyLUA','The Gare SaintÔÇôLazare, in 1873 the largest and busiest train station in Paris, is unseen in this painting. Advances in industrial technology and train travel, intrinsic to most contemporary depictions of the site, remain in Manet\'s painting the almost invisible background for a genre depiction of a woman and child. Confined to a narrow space backed by the black bars of an iron fence and isolated by clouds of steam sent up from a train passing below, Manet\'s two models are enigmatic presences. The woman is Victorine Meurent, Manet\'s favorite model in the 1860s, and the child was the daughter of a fellow painter who allowed Manet to use his garden to create The Railway. The composition is a complex contrapuntal apposition of the two figures: one clad in a white dress trimmed with a blue bow and the other dressed in dark blue trimmed with white; one with hair bound by a narrow black ribbon and the other with flowing tresses under a black hat; and one a child standing and looking at anonymous trains and buildings in the background and the other a seated adult staring forward to confront viewers directly.',NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":17,\"green\":29,\"blue\":48},\"web\":\"#111D30\",\"name\":\"Midnight Express\"},{\"color\":{\"red\":164,\"green\":157,\"blue\":132},\"web\":\"#A49D84\",\"name\":\"Grey Olive\"},{\"color\":{\"red\":190,\"green\":196,\"blue\":193},\"web\":\"#BEC4C1\",\"name\":\"Tiara\"},{\"color\":{\"red\":49,\"green\":86,\"blue\":134},\"web\":\"#315686\",\"name\":\"St Tropaz\"},{\"color\":{\"red\":233,\"green\":237,\"blue\":231},\"web\":\"#E9EDE7\",\"name\":\"Panache\"},{\"color\":{\"red\":108,\"green\":76,\"blue\":52},\"web\":\"#6c4c34\",\"name\":\"Jambalaya\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (294,20,5,'020010','Bathing At Asnieres',2,'https://www.nationalgallery.org.uk/paintings/georges-seurat-bathers-at-asnieres','NG3908','Creative Commons BY-NC-ND 4.0','Bathers at Asnieres is an oil-on-canvas painting by the French artist Georges-Pierre Seurat, the first of his two masterpieces on the monumental scale. Seurat borrowed from sources such as those of the fresco painters of the 15th century, the French classicism of Nicolas Poussin, and of contemporary Impressionism to create a unified canvas of a suburban, but placid Parisian riverside scene. The isolated figures and their clothes piled sculpturally on the riverbank, together with the trees, and austere boundary walls and buildings, are presented in a formal layout. A combination of complex brushstroke techniques, and a meticulous application of contemporary colour theory bring to the composition a sense of gentle vibrancy and timelessness.','Bathers at Asnieres is an oil-on-canvas painting by the French artist Georges-Pierre Seurat, the first of his two masterpieces on the monumental scale. ',1883,201,300,'Oil on canvas',825.0000,900.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Bathers_at_Asni%C3%A8res','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":159,\"green\":161,\"blue\":162},\"web\":\"#9FA1A2\",\"name\":\"Grey Chateau\"},{\"color\":{\"red\":62,\"green\":50,\"blue\":52},\"web\":\"#3E3234\",\"name\":\"Cab Sav\"},{\"color\":{\"red\":156,\"green\":165,\"blue\":132},\"web\":\"#9ca584\",\"name\":\"Sage\"},{\"color\":{\"red\":231,\"green\":221,\"blue\":203},\"web\":\"#e7ddcb\",\"name\":\"Half Spanish White\"},{\"color\":{\"red\":89,\"green\":99,\"blue\":115},\"web\":\"#596373\",\"name\":\"Shuttle Grey\"},{\"color\":{\"red\":151,\"green\":108,\"blue\":95},\"web\":\"#976c5f\",\"name\":\"Dark Chestnut\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (296,20,6,'020050','Circus Sideshow (Parade de cirque)',2,'http://www.metmuseum.org/art/collection/search/437654','61.101.17','Open Access for Scholarly Content','At the Salon des Independants in 1888 Seurat demonstrated the versatility of his technique by exhibiting Circus Sideshow, a nighttime outdoor scene in artificial light, and Models, an indoor, daylight scene (Barnes Foundation, Philadelphia). This is Seurat\'s first nocturnal painting and his first depiction of popular entertainment. It represents the parade, or sideshow, of the Circus Corvi, which had set up near the place de la Nation in Paris in the spring of 1887. Sideshows were held on the street, for free, to entice passersby to purchase tickets. The onlookers at the far right are queued on stairs leading to the box office.','At the Salon des Independants in 1888 Seurat demonstrated the versatility of his technique by exhibiting Circus Sideshow, a nighttime outdoor scene in artificial light, and Models, an indoor, daylight scene .',1888,100,156,'Oil on canvas',605.0000,845.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":93,\"green\":81,\"blue\":81},\"web\":\"#5D5151\",\"name\":\"Matterhorn\"},{\"color\":{\"red\":135,\"green\":112,\"blue\":96},\"web\":\"#877060\",\"name\":\"Donkey Brown\"},{\"color\":{\"red\":94,\"green\":82,\"blue\":64},\"web\":\"#5E5240\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":121,\"green\":103,\"blue\":98},\"web\":\"#796762\",\"name\":\"Russet\"},{\"color\":{\"red\":63,\"green\":54,\"blue\":57},\"web\":\"#3F3639\",\"name\":\"\"},{\"color\":{\"red\":119,\"green\":86,\"blue\":74},\"web\":\"#77564A\",\"name\":\"Quincy\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (299,21,6,'021030','Portrait of Uncle Dominique, as a Monk',1,'http://www.metmuseum.org/art/collection/search/435869','1993.400.1','Open Access for Scholarly Content','In the fall of 1866 Cezanne painted nine portraits of his maternal uncle, Dominique Aubert. The forty-nine-year-old bailiff indulged his nephew with multiple sittings and agreed to pose in various costumes. Whereas he is shown here in the habit of a Dominican monk, in another likeness of this date, also in the Metropolitan\'s collection, he wears a tassled cap and robe.','In the fall of 1866 Cezanne painted nine portraits of his maternal uncle, Dominique Aubert. The forty-nine-year-old bailiff indulged his nephew with multiple sittings and agreed to pose in various costumes.',1866,65,55,'Oil on canvas',250.0000,280.0000,NULL,NULL,'http://www.metmuseum.org/collections/search-the-collections/110000302','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":202,\"green\":193,\"blue\":169},\"web\":\"#CAC1A9\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":79,\"green\":84,\"blue\":77},\"web\":\"#4F544D\",\"name\":\"Battleship Grey\"},{\"color\":{\"red\":171,\"green\":158,\"blue\":130},\"web\":\"#AB9E82\",\"name\":\"Napa\"},{\"color\":{\"red\":46,\"green\":52,\"blue\":47},\"web\":\"#2E342F\",\"name\":\"Gordons Green\"},{\"color\":{\"red\":94,\"green\":82,\"blue\":60},\"web\":\"#5E523C\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":134,\"green\":118,\"blue\":92},\"web\":\"#86765C\",\"name\":\"Cement\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (300,21,11,'021040','The Basket of Apples',3,'http://www.artic.edu/aic/collections/artwork/111436',NULL,'Rights-Managed (RM)','The Basket of Apples is a still life oil painting noted for its disjointed perspective. It has been described as a balanced composition due to its unbalanced parts; the tilted bottle, the incline of the basket, and the foreshortened lines of the cookies meshing with the lines of the tablecloth. Additionally, the right side of the tabletop is not in the same plane as the left side, as if the image simultaneously reflects two viewpoints. Paintings such as this helped form a bridge between Impressionism and Cubism.','The Basket of Apples is a still life oil painting noted for its disjointed perspective. It has been described as a balanced composition due to its unbalanced parts; the tilted bottle, the incline of the basket, and the foreshortened lines of the cookies meshing with the lines of the tablecloth.',1895,65,80,'Oil on canvas',800.0000,1050.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Basket_of_Apples','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":204,\"green\":200,\"blue\":167},\"web\":\"#CCC8A7\",\"name\":\"Kangaroo\"},{\"color\":{\"red\":139,\"green\":54,\"blue\":25},\"web\":\"#8B3619\",\"name\":\"Burnt Umber\"},{\"color\":{\"red\":190,\"green\":95,\"blue\":31},\"web\":\"#BE5F1F\",\"name\":\"Christine\"},{\"color\":{\"red\":169,\"green\":41,\"blue\":12},\"web\":\"#A9290C\",\"name\":\"Fire Brick\"},{\"color\":{\"red\":79,\"green\":38,\"blue\":23},\"web\":\"#4F2617\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":209,\"green\":141,\"blue\":59},\"web\":\"#D18D3B\",\"name\":\"Fuel Yellow\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (301,21,13,'021050','Large Bathers',3,'http://www.philamuseum.org/collections/permanent/104464.html','W1937-1-1','Public Domain','The Large Bathers (French: Les Grandes Baigneuses) is an oil painting by French artist Paul Cezanne first exhibited in 1906. The painting is the largest of a series of \"Bather\" paintings by Cezanne; the others are in the Museum of Modern Art in New York City and the National Gallery, London. Occasionally referred to as the Big Bathers or Large Bathers to distinguish it from the smaller works, the painting is considered one of the masterpieces of modern art, and is often considered Cezanne\'s finest work. Cezanne worked on the painting for seven years, and it remained unfinished at the time of his death in 1906. The painting was purchased in 1937 for $110,000 with funds from a trust fund for the Philadelphia Museum of Art by their major benefactor Joseph E. Widener. It was previously owned by Leo Stein.','The Large Bathers (French: Les Grandes Baigneuses) is an oil painting by French artist Paul Cezanne first exhibited in 1906. The painting is the largest of a series of \"Bather\" paintings by Cezanne; the others are in the Museum of Modern Art in New York City and the National Gallery, London.',1899,208,249,'Oil on canvas',300.0000,375.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Bathers_(C%C3%A9zanne)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":151,\"green\":156,\"blue\":155},\"web\":\"#979C9B\",\"name\":\"Cascade\"},{\"color\":{\"red\":117,\"green\":123,\"blue\":122},\"web\":\"#757B7A\",\"name\":\"Rolling Stone\"},{\"color\":{\"red\":165,\"green\":153,\"blue\":128},\"web\":\"#A59980\",\"name\":\"Napa\"},{\"color\":{\"red\":131,\"green\":120,\"blue\":95},\"web\":\"#83785F\",\"name\":\"Stonewall\"},{\"color\":{\"red\":94,\"green\":86,\"blue\":63},\"web\":\"#5E563F\",\"name\":\"Millbrook\"},{\"color\":{\"red\":134,\"green\":150,\"blue\":165},\"web\":\"#8696A5\",\"name\":\"Bali Hai\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (310,16,7,'016060','Girl Arranging Her Hair',1,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.46572.html','1963.10.97','Open Access','It was Edgar Degas who invited Cassatt to participate in the impressionist exhibitions, and the two remained close associates. Degas respected Cassatt\'s work, seeing in her careful compositions an approach to art that was deliberate and well thought out. Degas was known for his sharp criticism of other artists\' work. He once complained to Cassatt: \"What do women know about style?\" She took his words as a challenge to produce a work whose appeal derived, not from a conventionally pretty subject, but purely from artifice, the painter\'s skill, and style. This painting is the result.','The beauty of the picture comes from the rigor of the composition and its harmonized contrast of pinks and blues in the sitter\'s nightdress, in the background, and even in her skin.',1886,75,62,'Oil on canvas',485.0000,745.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":152,\"green\":160,\"blue\":159},\"web\":\"#98A09F\",\"name\":\"Hit Grey\"},{\"color\":{\"red\":144,\"green\":111,\"blue\":113},\"web\":\"#906F71\",\"name\":\"Turkish Rose\"},{\"color\":{\"red\":93,\"green\":74,\"blue\":55},\"web\":\"#5D4A37\",\"name\":\"Brown Derby\"},{\"color\":{\"red\":109,\"green\":76,\"blue\":80},\"web\":\"#6D4C50\",\"name\":\"Falcon\"},{\"color\":{\"red\":181,\"green\":186,\"blue\":184},\"web\":\"#B5BAB8\",\"name\":\"Loblolly\"},{\"color\":{\"red\":120,\"green\":124,\"blue\":125},\"web\":\"#787C7D\",\"name\":\"Regent Grey\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (339,14,19,'014010','Dance at Le Moulin de la Galette',2,'http://www.musee-orsay.fr/en/collections/works-in-focus/search/commentaire/commentaire_id/bal-du-moulin-de-la-galette-7083.html','RF 2739','&copy; Home','Dance at Moulin de la Galette is one of Impressionism\'s most highly revered masterpieces. The scene is of a Sunday afternoon at Moulin de la Galette, where Parisians would typically dress up and spend all day dancing, drinking, and eating galettes, or flat cakes. The painting was in the collection of Gustave Caillebotte, but it was claimed by the French government upon his death due to the non payment of death duties. It was later transferred from the Luxembourg Museum, to the Louvre, and then later to the Musee d\'Orsay. Its sale price at auction in 2009 was the fifth highest price ever paid for a painting at auction.','Dance at Moulin de la Galette is one of Impressionism\'s most highly revered masterpieces. The scene is of a Sunday afternoon at Moulin de la Galette, where Parisians would typically dress up and spend all day dancing, drinking, and eating galettes, or flat cakes. ',1876,131,175,'Oil on canvas',400.0000,550.0000,'https://www.google.com/culturalinstitute/beta/asset/dance-at-le-moulin-de-la-galette/rQEx7CtGiKE3yg','This painting is doubtless Renoir\'s most important work of the mid 1870\'s and was shown at the Impressionist exhibition in 1877. Though some of his friends appear in the picture, Renoir\'s main aim was to convey the vivacious and joyful atmosphere of this popular dance garden on the Butte Montmartre. The study of the moving crowd, bathed in natural and artificial light, is handled using vibrant, brightly coloured brushstrokes. The somewhat blurred impression of the scene prompted negative reactions from contemporary critics.','http://en.wikipedia.org/wiki/Bal_du_moulin_de_la_Galette','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":72,\"green\":90,\"blue\":55},\"web\":\"#485A37\",\"name\":\"Dell\"},{\"color\":{\"red\":128,\"green\":119,\"blue\":93},\"web\":\"#80775D\",\"name\":\"Stonewall\"},{\"color\":{\"red\":46,\"green\":52,\"blue\":51},\"web\":\"#2E3433\",\"name\":\"Aztec\"},{\"color\":{\"red\":150,\"green\":156,\"blue\":152},\"web\":\"#969C98\",\"name\":\"Edward\"},{\"color\":{\"red\":127,\"green\":152,\"blue\":162},\"web\":\"#7f98a2\",\"name\":\"Bali Hai\"},{\"color\":{\"red\":24,\"green\":32,\"blue\":35},\"web\":\"#182023\",\"name\":\"Black Pearl\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (342,2,37,'002070','The Red Madras Headdress',1,'http://www.barnesfoundation.org/collections/art-collection/object/6365/red-madras-headdress-le-madras-rouge','BF448','&copy; The Barnes Foundation','Madras Rouge (The Red Madras Headress) is a painting by Henri Matisse from 1907. The woman depicted is the painter\'s wife, Amelie Noellie Parayre Matisse.','Madras Rouge (The Red Madras Headress) is a painting by Henri Matisse from 1907. The woman depicted is the painter\'s wife, Amelie Noellie Parayre Matisse.',1907,99,80,'Oil on canvas',850.0000,1000.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Madras_Rouge','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":64,\"green\":122,\"blue\":138},\"web\":\"#407A8A\",\"name\":\"Jelly Bean\"},{\"color\":{\"red\":172,\"green\":41,\"blue\":4},\"web\":\"#AC2904\",\"name\":\"Rust\"},{\"color\":{\"red\":216,\"green\":192,\"blue\":130},\"web\":\"#D8C082\",\"name\":\"Straw\"},{\"color\":{\"red\":246,\"green\":197,\"blue\":21},\"web\":\"#F6C515\",\"name\":\"Moon Yellow\"},{\"color\":{\"red\":224,\"green\":191,\"blue\":119},\"web\":\"#e0bf77\",\"name\":\"Chenin\"},{\"color\":{\"red\":190,\"green\":46,\"blue\":6},\"web\":\"#be2e06\",\"name\":\"Harley Davidson Orange\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (343,2,24,'002080','Dance (II)',2,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/28411/?lng=en','9673','Personal non-commercial use','There are two versions of The Dance, the first, painted in March of 1909, is the study for the second one, completed in 1910. The large work, painted along the lines of William Blake\'s painting Oberon, Titania and Puck with Fairies Dancing, was painted along with its companion piece, Music, which depicts nudes playing music in a similar setting. The pieces were specially created for Russian businessman and art collector Sergei Shchukin, who was a long-time associate of Matisse\'s. This painting is often recognized as a key point in the development of Matisse\'s artwork, as well as in the development of modern painting. It is also often associated with Dance of the Young Girls, in The Rite of Spring by Igor Stravinsky.','This painting is often recognized as a key point in the development of Matisse\'s artwork, as well as in the development of modern painting. ',1910,260,391,'Oil on canvas',1450.0000,1800.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Dance_(Matisse)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":191,\"green\":69,\"blue\":50},\"web\":\"#BF4532\",\"name\":\"Grenadier\"},{\"color\":{\"red\":60,\"green\":100,\"blue\":93},\"web\":\"#3C645D\",\"name\":\"Stromboli\"},{\"color\":{\"red\":149,\"green\":56,\"blue\":36},\"web\":\"#953824\",\"name\":\"Fire\"},{\"color\":{\"red\":49,\"green\":83,\"blue\":131},\"web\":\"#315383\",\"name\":\"St Tropaz\"},{\"color\":{\"red\":117,\"green\":31,\"blue\":19},\"web\":\"#751F13\",\"name\":\"Falu Red\"},{\"color\":{\"red\":43,\"green\":64,\"blue\":97},\"web\":\"#2b4061\",\"name\":\"Catalina Blue\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (346,5,6,'005040','The Death of Socrates',2,'http://www.metmuseum.org/art/collection/search/436105','31.45','Open Access for Scholarly Content','The Death of Socrates  is an oil on canvas painted by French painter Jacques-Louis David in 1787. The painting focuses on a classical subject like many of his works from that decade, in this case the story of the execution of Socrates as told by Plato in his Phaedo. In this story, Socrates has been convicted of corrupting the youth of Athens and introducing strange gods, and has been sentenced to die by drinking poison hemlock. Socrates uses his death as a final lesson for his pupils rather than fleeing when the opportunity arises, and faces it calmly. The Phaedo depicts the death of Socrates and is also Plato\'s fourth and last dialogue to detail the philosopher\'s final days, which is also detailed in Euthyphro, Apology, and Crito.','The painting focuses on a classical subject like many of his works from that decade, in this case the story of the execution of Socrates as told by Plato in his Phaedo.',1787,196,129,'Oil on canvas',1500.0000,1800.0000,'https://www.google.com/culturalinstitute/beta/asset/the-death-of-socrates/sAGm14MzWjaN9Q','Accused by the Athenian government of denying the gods and corrupting the young through his teachings, Socrates (469ÔÇô399 B.C.) was offered the choice of renouncing his beliefs or dying by drinking a cup of hemlock. David shows him prepared to die and discoursing on the immortality of the soul with his grief-stricken disciples.','https://en.wikipedia.org/wiki/The_Death_of_Socrates','{\"safeSearchAnnotation\":{\"violence\":2,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":135,\"green\":59,\"blue\":24},\"web\":\"#873B18\",\"name\":\"Saddle Brown\"},{\"color\":{\"red\":95,\"green\":81,\"blue\":54},\"web\":\"#5F5136\",\"name\":\"West Coast\"},{\"color\":{\"red\":168,\"green\":154,\"blue\":123},\"web\":\"#A89A7B\",\"name\":\"Tallow\"},{\"color\":{\"red\":85,\"green\":43,\"blue\":22},\"web\":\"#552B16\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":123,\"green\":69,\"blue\":30},\"web\":\"#7B451E\",\"name\":\"Russet\"},{\"color\":{\"red\":156,\"green\":103,\"blue\":57},\"web\":\"#9C6739\",\"name\":\"Mai Tai\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (347,5,22,'005050','Napoleon Crossing the Alps',1,'http://digital.belvedere.at/objects/7889/napoleon-am-groen-st-bernhard','2089','Private use','Napoleon Crossing the Alps (also known as Napoleon at the Saint-Bernard Pass) is the title given to the five versions of an oil on canvas equestrian portrait of Napoleon Bonaparte painted by the French artist Jacques-Louis David between 1801 and 1805. Initially commissioned by the king of Spain, the composition shows a strongly idealized view of the real crossing that Napoleon and his army made across the Alps through the Great St. Bernard Pass in May 1800.','Napoleon Crossing the Alps (also known as Napoleon at the Saint-Bernard Pass) is the title given to the five versions of an oil on canvas equestrian portrait of Napoleon Bonaparte painted by the French artist Jacques-Louis David between 1801 and 1805.',1800,261,221,'Oil on canvas',600.0000,950.0000,'https://www.google.com/culturalinstitute/beta/asset/bonaparte-crossing-the-grand-saint-bernard-pass-20-may-1800/QwEFHqZhgW6ulw',NULL,'http://en.wikipedia.org/wiki/Napoleon_at_the_Saint-Bernard_Pass','{\"safeSearchAnnotation\":{\"violence\":2,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":167,\"green\":49,\"blue\":36},\"web\":\"#A73124\",\"name\":\"Brown\"},{\"color\":{\"red\":161,\"green\":110,\"blue\":62},\"web\":\"#A16E3E\",\"name\":\"Bourbon\"},{\"color\":{\"red\":103,\"green\":35,\"blue\":31},\"web\":\"#67231F\",\"name\":\"Red Oxide\"},{\"color\":{\"red\":217,\"green\":192,\"blue\":169},\"web\":\"#D9C0A9\",\"name\":\"Bone\"},{\"color\":{\"red\":96,\"green\":83,\"blue\":60},\"web\":\"#60533C\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":20,\"green\":25,\"blue\":19},\"web\":\"#141913\",\"name\":\"Myrtle\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (348,5,16,'005060','The Coronation of Napoleon',2,'http://www.louvre.fr/en/oeuvre-notices/consecration-emperor-napoleon-and-coronation-empress-josephine-december-2-1804','INV. 3699','&copy; Musee du Louvre','The Coronation of Napoleon (French: Le Sacre de Napoleon) is a painting completed in 1807 by Jacques-Louis David, the official painter of Napoleon. The painting has imposing dimensions, as it is almost ten metres wide by approximately six metres tall. The crowning and the coronation took place at Notre-Dame de Paris, a way for Napoleon to make it clear that he was a son of the Revolution.','The Coronation of Napoleon (French: Le Sacre de Napoleon) is a painting completed in 1807 by Jacques-Louis David, the official painter of Napoleon. The painting has imposing dimensions, as it is almost ten metres wide by approximately six metres tall.',1805,621,979,'Oil on canvas',800.0000,1200.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Coronation_of_Napoleon','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":87,\"green\":78,\"blue\":57},\"web\":\"#574e39\",\"name\":\"Panda\"},{\"color\":{\"red\":64,\"green\":66,\"blue\":59},\"web\":\"#40423b\",\"name\":\"Zeus\"},{\"color\":{\"red\":151,\"green\":131,\"blue\":77},\"web\":\"#97834d\",\"name\":\"Muesli\"},{\"color\":{\"red\":87,\"green\":55,\"blue\":54},\"web\":\"#573736\",\"name\":\"Van Cleef\"},{\"color\":{\"red\":202,\"green\":179,\"blue\":99},\"web\":\"#cab363\",\"name\":\"Tacha\"},{\"color\":{\"red\":127,\"green\":146,\"blue\":109},\"web\":\"#7f926d\",\"name\":\"Highland\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (349,18,6,'018090','Two Tahitian Women',1,'http://www.metmuseum.org/art/collection/search/436446','49.58.1','Open Access for Scholarly Content','The painting depicts two topless women, one holding mango blossoms, on the Pacific Island of Tahiti. Currently, the painting is housed at the National Gallery of Art, on loan from the Metropolitan Museum of Art in New York.','The painting depicts two topless women, one holding mango blossoms, on the Pacific Island of Tahiti. Currently, the painting is housed at the National Gallery of Art, on loan from the Metropolitan Museum of Art in New York.',1899,94,72,'Oil on canvas',340.0000,400.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Two_Tahitian_Women','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":138,\"green\":122,\"blue\":61},\"web\":\"#8A7A3D\",\"name\":\"Corn Harvest\"},{\"color\":{\"red\":29,\"green\":44,\"blue\":67},\"web\":\"#1D2C43\",\"name\":\"Midnight\"},{\"color\":{\"red\":72,\"green\":114,\"blue\":141},\"web\":\"#48728D\",\"name\":\"Jelly Bean\"},{\"color\":{\"red\":49,\"green\":93,\"blue\":86},\"web\":\"#315D56\",\"name\":\"Eden\"},{\"color\":{\"red\":157,\"green\":126,\"blue\":48},\"web\":\"#9D7E30\",\"name\":\"Hacienda\"},{\"color\":{\"red\":171,\"green\":156,\"blue\":46},\"web\":\"#ab9c2e\",\"name\":\"Sahara\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (351,19,49,'019110','Postman Joseph Roulin',1,'http://www.mfa.org/collections/object/postman-joseph-roulin-32542','35.1982','Public domain','The Roulin Family is group of portrait paintings Vincent van Gogh executed in Arles in 1888 and 1889 on Joseph, his wife Augustine and their three children: Armand, Camille and Marcelle. This series is unique in many ways. Although Van Gogh loved to paint portraits, it was difficult for financial and other reasons for him to find models. So, finding an entire family that agreed to sit for paintings, in fact for several sittings each was a bounty.\r\nJoseph Roulin became a particularly good, loyal and supporting friend to Van Gogh during his stay in Arles. To represent a man he truly admired was important to him. The family, with children ranging in age from four months to seventeen years, also gave him the opportunity to produces works of individuals in several different stages of life.\r\nRather than making photographic-like works, Van Gogh used his imagination, colors and themes artistically and creatively to evoke desired emotions from the audience.','The Roulin Family is group of portrait paintings Vincent van Gogh executed in Arles in 1888 and 1889 on Joseph, his wife Augustine and their three children: Armand, Camille and Marcelle.',1888,81,65,'Oil on canvas',350.0000,420.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Roulin_Family_(Van_Gogh_series)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":171,\"green\":197,\"blue\":199},\"web\":\"#abc5c7\",\"name\":\"jungle Mist\"},{\"color\":{\"red\":20,\"green\":67,\"blue\":99},\"web\":\"#144363\",\"name\":\"Astronaut Blue\"},{\"color\":{\"red\":10,\"green\":24,\"blue\":40},\"web\":\"#0a1828\",\"name\":\"Black Pearl\"},{\"color\":{\"red\":190,\"green\":163,\"blue\":120},\"web\":\"#bea378\",\"name\":\"Fallow\"},{\"color\":{\"red\":71,\"green\":109,\"blue\":85},\"web\":\"#476d55\",\"name\":\"Como\"},{\"color\":{\"red\":77,\"green\":106,\"blue\":113},\"web\":\"#4d6a71\",\"name\":\"Tax Break\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (352,19,29,'019120','The Sower',3,'https://www.vangoghmuseum.nl/en/collection/s0029V1962','s0029V1962','Non commercial use','Here, Van Gogh used colours meant to express emotion and passion. He assigned the leading roles to the greenish-yellow of the sky and the purple of the field. The bright yellow sun looks like a halo, turning the sower into a saint.','Here, Van Gogh used colours meant to express emotion and passion. He assigned the leading roles to the greenish-yellow of the sky and the purple of the field. The bright yellow sun looks like a halo, turning the sower into a saint.',1888,40,32,'Oil on canvas',350.0000,400.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":69,\"green\":95,\"blue\":121},\"web\":\"#455F79\",\"name\":\"Chambray\"},{\"color\":{\"red\":170,\"green\":149,\"blue\":54},\"web\":\"#AA9536\",\"name\":\"Reef Gold\"},{\"color\":{\"red\":120,\"green\":125,\"blue\":57},\"web\":\"#787D39\",\"name\":\"Crete\"},{\"color\":{\"red\":79,\"green\":108,\"blue\":136},\"web\":\"#4F6C88\",\"name\":\"Wedgewood\"},{\"color\":{\"red\":55,\"green\":52,\"blue\":31},\"web\":\"#37341F\",\"name\":\"Graphite\"},{\"color\":{\"red\":39,\"green\":58,\"blue\":30},\"web\":\"#273A1E\",\"name\":\"Black Forest\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (366,92,4,'092010','Madonna and Child',1,'http://www.uffizi.firenze.it/catalogo/','1890, 1598','Public domain','Madonna with Child is a painting by the Italian Renaissance artist Filippo Lippi, executed around 1465. It is one of the few works by Lippi which was not executed with the help of his workshop and was an influential model for later depictions of the Madonna and Child, including those by Sandro Botticelli.','Madonna with Child is a painting by the Italian Renaissance artist Filippo Lippi, executed around 1465. It is one of the few works by Lippi which was not executed with the help of his workshop and was an influential model for later depictions of the Madonna and Child, including those by Sandro Botticelli.',1465,95,64,'Tempera on panel',500.0000,600.0000,'https://www.google.com/culturalinstitute/beta/asset/madonna-and-child-with-two-angels/9AE9qn4SE5pOPg','A famous example of the artist\'s maturity, this painting was transferred to the Uffizi in 1796 from the Villa of Poggio Imperiale. Thanks to the spontaneity and naturalness of the composition, it reaped great interest as an iconographic model for numerous artists including the young Botticelli, apprenticed to the friar Lippi. On the back of the panel there is an autograph charcoal sketch of a female figure.','http://en.wikipedia.org/wiki/Madonna_and_Child_(Fra_Lippo_Lippi)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":22,\"green\":19,\"blue\":23},\"web\":\"#161317\",\"name\":\"Blackcurrant\"},{\"color\":{\"red\":89,\"green\":82,\"blue\":90},\"web\":\"#59525A\",\"name\":\"Fedora\"},{\"color\":{\"red\":75,\"green\":42,\"blue\":24},\"web\":\"#4B2A18\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":142,\"green\":154,\"blue\":184},\"web\":\"#8E9AB8\",\"name\":\"Rock Blue\"},{\"color\":{\"red\":134,\"green\":87,\"blue\":51},\"web\":\"#865733\",\"name\":\"Korma\"},{\"color\":{\"red\":200,\"green\":147,\"blue\":105},\"web\":\"#c89369\",\"name\":\"Whiskey\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (369,92,41,'092040','Adoration in the Forest',3,'http://www.smb-digital.de/eMuseumPlus?service=ExternalInterface&module=collection&objectId=864730&viewType=detailView','69','Creative Commons Attribution-NonCommercial-ShareAlike 3.0','Adoration in the Forest is a painting completed before 1459 by the Carmelite friar, Filippo Lippi, of the Virgin Mary and the newly born Christ Child lying on the ground, in the unusual setting of a steep, dark, wooded wilderness. There are no shepherds, kings, ox, ass, there is no Joseph. It was painted for one of the wealthiest men in Renaissance Florence, the banker Cosimo de Medici. In later times it had a turbulent history. Hitler ordered it to be hidden in WW2 and it became part of the story of a mutiny in the U.S. Army.','Adoration in the Forest is a painting completed before 1459 by the Carmelite friar, Filippo Lippi, of the Virgin Mary and the newly born Christ Child lying on the ground, in the unusual setting of a steep, dark, wooded wilderness. ',1459,1185,1295,'Oil on wood',1200.0000,1600.0000,'http://www.googleartproject.com/collection/gemaldegalerie-staatliche-museen-zu-berlin/artwork/the-adoration-in-the-forest-filippo-lippi/331331/',NULL,'http://en.wikipedia.org/wiki/Adoration_in_the_Forest_(Lippi)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":153,\"green\":109,\"blue\":86},\"web\":\"#996D56\",\"name\":\"Dark Tan\"},{\"color\":{\"red\":215,\"green\":187,\"blue\":159},\"web\":\"#D7BB9F\",\"name\":\"Cashmere\"},{\"color\":{\"red\":114,\"green\":115,\"blue\":136},\"web\":\"#727388\",\"name\":\"Storm Grey\"},{\"color\":{\"red\":154,\"green\":153,\"blue\":165},\"web\":\"#9A99A5\",\"name\":\"Santas Grey\"},{\"color\":{\"red\":119,\"green\":78,\"blue\":59},\"web\":\"#774E3B\",\"name\":\"Old Copper\"},{\"color\":{\"red\":167,\"green\":80,\"blue\":75},\"web\":\"#a7504b\",\"name\":\"Apple Blossom\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (370,93,5,'093010','Baptism of Christ',1,'https://www.nationalgallery.org.uk/paintings/piero-della-francesca-the-baptism-of-christ','NG665','Creative Commons BY-NC-ND 4.0','The Baptism of Christ was commissioned presumably some time about 1440 by the Camaldolese Monastery of Sansepolcro in Tuscany, originally part of a triptych. Its dating to Piero della Francesca\'s early career is evidenced by the strong relationship with the \"light painting\" of his master, Domenico Veneziano. It portrays Christ being baptised by John, his head surmounted by a dove representing the Holy Spirit. Christ, John\'s hand, the bird and the bowl form an axis which divides the painting in two symmetrical parts. A second division is created by the tree on the left, which instead divides it according to the golden ratio.','The Baptism of Christ was commissioned presumably some time about 1440 by the Camaldolese Monastery of Sansepolcro in Tuscany, originally part of a triptych. ',1450,167,116,'Tempera on panel',900.0000,1100.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Baptism_of_Christ_(Piero_della_Francesca)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":111,\"green\":133,\"blue\":152},\"web\":\"#6F8598\",\"name\":\"Light Slate Grey\"},{\"color\":{\"red\":59,\"green\":55,\"blue\":31},\"web\":\"#3B371F\",\"name\":\"Graphite\"},{\"color\":{\"red\":163,\"green\":152,\"blue\":125},\"web\":\"#A3987D\",\"name\":\"Grey Olive\"},{\"color\":{\"red\":119,\"green\":79,\"blue\":33},\"web\":\"#774F21\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":92,\"green\":83,\"blue\":56},\"web\":\"#5C5338\",\"name\":\"West Coast\"},{\"color\":{\"red\":165,\"green\":154,\"blue\":128},\"web\":\"a59a80\",\"name\":\"Nomad\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (373,94,81,'094010','Lamentation of Christ',2,'http://pinacotecabrera.org/collezione-online/opere/cristo-morto-nel-sepolcro-e-tre-dolenti/','352','Public Domain','The Lamentation of Christ is a painting of about 1480 by the Italian Renaissance artist Andrea Mantegna. While the dating of the piece is debated, it was completed between 1475 and 1501, probably in the early 1480s. It portrays the body Christ supine on a marble slab. He is watched over by the Virgin Mary and Saint John whose cut-off profile is behind the Virgin Mary, who are weeping for his death.','The Lamentation of Christ is a painting of about 1480 by the Italian Renaissance artist Andrea Mantegna.',1480,68,81,'Tempera on canvas',400.0000,600.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Lamentation_over_the_Dead_Christ_(Mantegna)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":163,\"green\":155,\"blue\":146},\"web\":\"#A39B92\",\"name\":\"Zorba\"},{\"color\":{\"red\":128,\"green\":121,\"blue\":115},\"web\":\"#807973\",\"name\":\"Americano\"},{\"color\":{\"red\":169,\"green\":155,\"blue\":139},\"web\":\"#A99B8B\",\"name\":\"Malta\"},{\"color\":{\"red\":87,\"green\":84,\"blue\":86},\"web\":\"#575456\",\"name\":\"Liver\"},{\"color\":{\"red\":191,\"green\":183,\"blue\":173},\"web\":\"#BFB7AD\",\"name\":\"Tide\"},{\"color\":{\"red\":190,\"green\":180,\"blue\":163},\"web\":\"#8E7E6E\",\"name\":\"Squirrel\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (374,94,18,'094020','St. Sebastian',5,'https://www.khm.at/de/object/285f89b802/','301','Only for private use','St. Sebastian is the subject of three paintings by the Italian Early Renaissance master Andrea Mantegna. The Paduan artist lived in a period of frequent plagues; Sebastian was considered protector against the plague as having been shot through by arrows, and it was thought that plague spread abroad through the air.','St. Sebastian is the subject of three paintings by the Italian Early Renaissance master Andrea Mantegna. The Paduan artist lived in a period of frequent plagues; Sebastian was considered protector against the plague as having been shot through by arrows, and it was thought that plague spread abroad through the air.',1457,300,680,'Oil on panel',900.0000,1200.0000,'http://www.googleartproject.com/collection/kunsthistorisches-museum-vienna-museum-of-fine-arts/artwork/st-sebastian-andrea-mantegna/677761/',NULL,'http://en.wikipedia.org/wiki/St._Sebastian_of_Vienna_(Mantegna)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":138,\"green\":119,\"blue\":93},\"web\":\"#8A775D\",\"name\":\"Cement\"},{\"color\":{\"red\":77,\"green\":89,\"blue\":94},\"web\":\"#4D595E\",\"name\":\"Fiord\"},{\"color\":{\"red\":194,\"green\":181,\"blue\":157},\"web\":\"#C2B59D\",\"name\":\"Tea\"},{\"color\":{\"red\":105,\"green\":83,\"blue\":59},\"web\":\"#69533B\",\"name\":\"Tobacco Brown\"},{\"color\":{\"red\":72,\"green\":54,\"blue\":32},\"web\":\"#483620\",\"name\":\"Clinker\"},{\"color\":{\"red\":97,\"green\":111,\"blue\":114},\"web\":\"#616F72\",\"name\":\"Pale Sky\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (375,92,7,'092030','The Adoration of the Magi',3,'https://www.nga.gov/collection/art-object-page.41581.html','1952.2.2','Open Access','This brilliantly colored, richly decorated circular panel presents a splendid vision of the arrival of the Magi, accompanied by a courtly entourage. A 1492 inventory of Lorenzo de\' Medici\'s estate possibly identifies this picture as the most valuable in the collection of the powerful Florentine family, and attributes it to Fra Angelico. The Adoration of the Magi actually appears to be the product of two artists; Fra Angelico may only have started the altarpiece, the greatest part of the work having been taken up by Fra Filippo Lippi.','This brilliantly colored, richly decorated circular panel presents a splendid vision of the arrival of the Magi, accompanied by a courtly entourage. ',1450,137,137,'Tempera on canvas',800.0000,900.0000,'https://artsandculture.google.com/asset/the-adoration-of-the-magi/_wFPekHefj84QQ',NULL,'https://en.wikipedia.org/wiki/Adoration_of_the_Magi_(Fra_Angelico_and_Filippo_Lippi)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":157,\"green\":109,\"blue\":62},\"web\":\"#9D6D3E\",\"name\":\"Mai Tai\"},{\"color\":{\"red\":56,\"green\":87,\"blue\":113},\"web\":\"#385771\",\"name\":\"Matisse\"},{\"color\":{\"red\":144,\"green\":116,\"blue\":66},\"web\":\"#907442\",\"name\":\"Shadow\"},{\"color\":{\"red\":125,\"green\":79,\"blue\":39},\"web\":\"#7D4F27\",\"name\":\"Korma\"},{\"color\":{\"red\":197,\"green\":141,\"blue\":63},\"web\":\"#C58D3F\",\"name\":\"Anzac\"},{\"color\":{\"red\":102,\"green\":84,\"blue\":55},\"web\":\"#665437\",\"name\":\"Horses Neck\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (376,95,4,'095010','Primavera',2,'http://www.uffizi.firenze.it/catalogo/','1890, 8360','Public domain','Primavera, also known as Allegory of Spring, is a tempera panel painting by Italian Renaissance artist Sandro Botticelli. Painted ca. 1482, the painting is described in Culture & Values (2009) as \"[o]ne of the most popular paintings in Western art\". It is also \"one of the most written about, and most controversial paintings in the world.\" While most critics agree that the painting, depicting a group of mythological figures in a garden, is allegorical for the lush growth of Spring, other meanings have also been explored. Among them, the work is sometimes cited as illustrating the ideal of Neoplatonic love. The painting itself carries no title and was first called La Primavera by the art historian Giorgio Vasari who saw it at Villa Castello, just outside Florence, in 1550.','Painted ca. 1482, the painting is described in Culture & Values (2009) as \"[o]ne of the most popular paintings in Western art\". It is also \"one of the most written about, and most controversial paintings in the world.\" While most critics agree that the painting, depicting a group of mythological figures in a garden, is allegorical for the lush growth of Spring, other meanings have also been explored.',1482,202,314,'Tempera on panel',900.0000,1100.0000,'http://www.googleartproject.com/collection/uffizi-gallery/artwork/la-primavera-spring-botticelli-filipepi/331460/','Commissioned by Lorenzo and Giovanni di Pierfrancesco de\' Medici, cousins of Lorenzo il Magnifico, in 1498 this painting was in their florentine residence. Probably based on a theme suggested by Poliziano, it depicts a symbolic and allegorical subject with a complex interpretation: the Realm of Venus. Zephyr chases the nymph Chloris, who turns into the goddess Flora at right. Venus is underneath a blindfolded Cupid in flight with the three Graces and Mercury at left.','http://en.wikipedia.org/wiki/Primavera_(Painting)','{\"safeSearchAnnotation\":{\"violence\":2,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":139,\"green\":50,\"blue\":27},\"web\":\"#8B321B\",\"name\":\"Burnt Umber\"},{\"color\":{\"red\":215,\"green\":189,\"blue\":158},\"web\":\"#D7BD9E\",\"name\":\"Soft Amber\"},{\"color\":{\"red\":151,\"green\":111,\"blue\":85},\"web\":\"#976F55\",\"name\":\"Beaver\"},{\"color\":{\"red\":180,\"green\":153,\"blue\":122},\"web\":\"#B4997A\",\"name\":\"Sandrift\"},{\"color\":{\"red\":178,\"green\":91,\"blue\":62},\"web\":\"#B25B3E\",\"name\":\"Tuscany\"},{\"color\":{\"red\":186,\"green\":144,\"blue\":115},\"web\":\"#BA9073\",\"name\":\"pale Taupe\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (377,95,4,'095020','The Birth of Venus',2,'http://www.uffizi.firenze.it/catalogo/','1890, 878','Public domain','The Birth of Venus is a 1486 painting by Sandro Botticelli. Botticelli was commissioned to paint the work by the Medici family of Florence, specifically Lorenzo di Pierfrancesco de\' Medici under the influence of his cousin Lorenzo de\' Medici, close friend to Botticelli . It depicts the goddess Venus, having emerged from the sea as a fully grown woman, arriving at the sea-shore (which is related to the Venus Anadyomene motif).The painting is on display at the Uffizi Gallery in Florence, Italy.','It depicts the goddess Venus, having emerged from the sea as a fully grown woman, arriving at the sea-shore (which is related to the Venus Anadyomene motif).The painting is on display at the Uffizi Gallery in Florence, Italy.',1486,172,278,'Tempera on canvas',1200.0000,1100.0000,'http://www.googleartproject.com/collection/uffizi-gallery/artwork/the-birth-of-venus-botticelli-sandro-botticelli/331474/','The painting was commissioned by Lorenzo di Pierfrancesco deÔÇÖMedici, a cousin of Lorenzo the Magnificent. The theme was probably suggested by the humanist Poliziano. It depicts Venus born from the sea foam, blown by the west wind, Zephyr, and the nymph, Chloris, towards one of the Horai, who prepares to dress her with a flowered mantle.','http://en.wikipedia.org/wiki/The_Birth_of_Venus_(Botticelli)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":165,\"green\":159,\"blue\":125},\"web\":\"#A59F7D\",\"name\":\"Hillary\"},{\"color\":{\"red\":58,\"green\":50,\"blue\":27},\"web\":\"#3A321B\",\"name\":\"Mikado\"},{\"color\":{\"red\":199,\"green\":189,\"blue\":153},\"web\":\"#C7BD99\",\"name\":\"Sisal\"},{\"color\":{\"red\":125,\"green\":119,\"blue\":89},\"web\":\"#7D7759\",\"name\":\"Kokoda\"},{\"color\":{\"red\":174,\"green\":153,\"blue\":99},\"web\":\"#AE9963\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":153,\"green\":162,\"blue\":121},\"web\":\"#99A279\",\"name\":\"Sage\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (378,95,5,'095030','Venus and Mars',4,'https://www.nationalgallery.org.uk/paintings/sandro-botticelli-venus-and-mars','NG915','Creative Commons BY-NC-ND 4.0','Venus and Mars is a c. 1483 painting by the Italian Renaissance master Sandro Botticelli. It shows the Roman gods Venus and Mars in an allegory of Beauty and Valour. Venus watches Mars sleep while two infant satyrs play carrying his armour as another rests under his arm. A fourth blows a small conch shell in his ear in an effort to wake him. The scene is set in a forest, and the background shows, in the distance, the sea from which Venus emerged. A swarm of wasps hover around Mars\' head, possibly as a symbol that love is often accompanied by pain. Another possible explanation is that the wasps represent the Vespucci family that may have commissioned the painting; the symbol of the Vespucci house is the wasp. The painting is thought originally to have been the back of a lettuccio, a wooden sofa.','Venus and Mars is a c. 1483 painting by the Italian Renaissance master Sandro Botticelli. It shows the Roman gods Venus and Mars in an allegory of Beauty and Valour',1483,69,173,'Tempera on panel',900.0000,1000.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Venus_and_Mars_(Botticelli)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":63,\"green\":49,\"blue\":28},\"web\":\"#3F311C\",\"name\":\"Mikado\"},{\"color\":{\"red\":205,\"green\":192,\"blue\":195},\"web\":\"#CDC0C3\",\"name\":\"Melanie\"},{\"color\":{\"red\":182,\"green\":157,\"blue\":144},\"web\":\"#b69d90\",\"name\":\"Del Rio\"},{\"color\":{\"red\":192,\"green\":117,\"blue\":139},\"web\":\"#c0758b\",\"name\":\"Tapestry\"},{\"color\":{\"red\":99,\"green\":117,\"blue\":57},\"web\":\"#637539\",\"name\":\"Chalet Green\"},{\"color\":{\"red\":131,\"green\":99,\"blue\":46},\"web\":\"#83632e\",\"name\":\"Hot Curry\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (379,142,82,'142050','Self-Portrait with Physalis',1,'https://www.leopoldmuseum.org/en/leopoldcollection/masterpieces/36','454','&copy; Leopold Museum','This self-portrait is one of the most popular in Schiele\'s work. The artist has squeezed himself into a horizontal format, cropping the chest and hair. The head turns to the right although his eyes look in the other direction. This evokes a strong sense of tension in the picturek which is carried through to the sitter\'s surroundings. the twig with leaves and Chinese lanterns on the left of the picture echoes the inclined head while the slanting shoulders create a slight contrast to the rigidly structured background. The lines within the main forms are also in tune with the outstanding composition. Note, for example, the line of the shoulder on the right, which is continued by the jawbone. Schiele\'s use of colour is also on a par with his sensitive drawing. Striking features include the rich nuances of the skin and the light eye with the red pupil. In this portrait Schiele depicted himself as a sensitive person and artist.','This self-portrait is one of the most popular in Schiele\'s work. The artist has squeezed himself into a horizontal format, cropping the chest and hair. The head turns to the right although his eyes look in the other direction. ',1912,70,32,'Oil on wood',1000.0000,1075.0000,'https://artsandculture.google.com/asset/self-portrait-with-chinese-lantern-plant/lAGS1DQVHQVm6Q',NULL,'https://commons.wikimedia.org/wiki/File:Egon_Schiele_-_Self-Portrait_with_Physalis_-_Google_Art_Project.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":48,\"green\":52,\"blue\":56},\"web\":\"#303438\",\"name\":\"Cod Grey\"},{\"color\":{\"red\":157,\"green\":41,\"blue\":37},\"web\":\"#9D2925\",\"name\":\"Brown\"},{\"color\":{\"red\":140,\"green\":120,\"blue\":100},\"web\":\"#8C7864\",\"name\":\"Sand Dune\"},{\"color\":{\"red\":194,\"green\":185,\"blue\":167},\"web\":\"#C2B9A7\",\"name\":\"Tea\"},{\"color\":{\"red\":188,\"green\":156,\"blue\":95},\"web\":\"#BC9C5F\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":134,\"green\":119,\"blue\":111},\"web\":\"#86776F\",\"name\":\"Hurricane\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (380,95,4,'095050','Adoration of the Magi',2,'http://www.uffizi.firenze.it/catalogo/','1890, 882','Public domain','The Adoration of the Magi is a painting by the Italian Renaissance master Sandro Botticelli, dating from 1475 or 1476. It is housed in the Uffizi of Florence. Botticelli was commissioned to paint at least seven versions of The Adoration of the Magi. The Adoration of the Magi theme was popular in the Renaissance Florence. The work was commissioned by Gaspare di Zanobi del Lama, a banker of humble origins and dubious morality connected to the House of Medici, for his chapel in the church of Santa Maria Novella (now destroyed). In the scene are present numerous characters among which are several members of the Medici family: Cosimo de\' Medici (the Magus kneeling in front of the Virgin, described by Vasari as \"the finest of all that are now extant for its life and vigour\"), his sons Piero (the second Magus kneeling in the centre with the red mantle) and Giovanni (the third Magus), and his grandsons Giuliano and Lorenzo. The three Medici portrayed as Magi were all dead at the time the picture was painted, and Florence was effectively ruled by Lorenzo.','The Adoration of the Magi is a painting by the Italian Renaissance master Sandro Botticelli, dating from 1475 or 1476.',1475,111,134,'Tempera on panel',800.0000,600.0000,'http://www.googleartproject.com/collection/uffizi-gallery/artwork/adoration-of-the-magi-botticelli-filipepi/324472/','Commissioned by merchant broker of the Money Changing Guild, Guasparre di Zanobi del Lama for his chapel in Santa Maria Novella in Florence, this small panel depicts Cosimo the Elder and his sons Giovanni and Piero as the Magi, with Lorenzo il Magnifico and his brother Giuliano looking on. Facing the observer, we recognize the artist in a yellow cloak and the patron in a blue robe wearing white gloves.','http://en.wikipedia.org/wiki/Adoration_of_the_Magi_of_1475_(Botticelli)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":61,\"green\":50,\"blue\":27},\"web\":\"#3d321b\",\"name\":\"Mikado\"},{\"color\":{\"red\":118,\"green\":93,\"blue\":53},\"web\":\"#765d35\",\"name\":\"Shingle Fawn\"},{\"color\":{\"red\":160,\"green\":133,\"blue\":68},\"web\":\"#a08544\",\"name\":\"Luxor Gold\"},{\"color\":{\"red\":173,\"green\":61,\"blue\":36},\"web\":\"#ad3d24\",\"name\":\"Medium Carmine\"},{\"color\":{\"red\":173,\"green\":168,\"blue\":134},\"web\":\"#ada886\",\"name\":\"Neutral Green\"},{\"color\":{\"red\":212,\"green\":222,\"blue\":213},\"web\":\"#d4ded5\",\"name\":\"Aqua Squeeze\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (381,96,38,'096010','Delivery of the Keys',2,'http://mv.vatican.va/3_EN/pages/x-Schede/CSNs/CSNs_N_StCristo_05.html',NULL,NULL,'The Delivery of the Keys, or Christ Giving the Keys to St. Peter is a fresco by the Italian Renaissance painter Pietro Perugino, executed in 1481-1482 and located in the Sistine Chapel, Rome. The scene, part of the series of the Stories of Jesus on the chapel\'s northern wall, is a reference to Matthew 16 in which the \"keys of the kingdom of heaven\" are given to St.Peter. These keys represent the power to forgive and to share the word of God thereby giving them the power to allow others into heaven.','The Delivery of the Keys, or Christ Giving the Keys to St. Peter is a fresco by the Italian Renaissance painter Pietro Perugino, executed in 1481-1482 and located in the Sistine Chapel, Rome.',1481,330,550,'Fresco',900.0000,1100.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Delivery_of_the_Keys_(Perugino)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":89,\"green\":70,\"blue\":55},\"web\":\"#594637\",\"name\":\"Brown Derby\"},{\"color\":{\"red\":178,\"green\":155,\"blue\":119},\"web\":\"#b29b77\",\"name\":\"Bronco\"},{\"color\":{\"red\":237,\"green\":230,\"blue\":211},\"web\":\"#ede6d3\",\"name\":\"Cararra\"},{\"color\":{\"red\":90,\"green\":104,\"blue\":147},\"web\":\"#5a6893\",\"name\":\"Waikawa Grey\"},{\"color\":{\"red\":184,\"green\":129,\"blue\":50},\"web\":\"#b88132\",\"name\":\"Mandalay\"},{\"color\":{\"red\":179,\"green\":86,\"blue\":48},\"web\":\"#b35630\",\"name\":\"Fiery Orange\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (383,96,4,'096030','Portrait of Francesco delle Opere',1,'http://www.uffizi.firenze.it/catalogo/','1890, 1700','Public domain','The Portrait of Francesco delle Opere is a painting by the Italian Renaissance artist Perugino, dating to 1494 and housed in the Uffizi Gallery, Florence. Francesco delle Opere is portrayed from three-quarters, with a black beret and a mantle of the same color, a red blouse under which is a white shirt. His hand holds a cartouche with the words Timete Devm (\"Beware of God\"), the beginning of a famous preaching by Girolamo Savonarola. The hands lie on an invisible parapet which coincides with the painting\'s lower border, as in Flemish contemporary works such as Hans Memling\'s Man with a Letter.','Francesco delle Opere is portrayed from three-quarters, with a black beret and a mantle of the same color, a red blouse under which is a white shirt.',1494,52,44,'Oil on panel',400.0000,500.0000,'http://www.googleartproject.com/collection/uffizi-gallery/artwork/portrait-of-francesco-delle-opere-perugino-vannucci/324475/','The painting, signed and dated on the back, portrays Francesco delle Opere (who died in Venice in 1496), brother of Giovanni delle Corniole, famous master carver of precious stones and friend of Perugino. The meticulousness of the details of the portrait set against a gentle landscape is reminiscent of Flemish prototypes. The inscription TIMETE DEUM on the scroll is a recurrent warning in Savonarola\'s sermons. From the collection of Cardinal Leopoldo de\' Medici (1617- 1675) it has been in the Uffizi since 1833.','http://en.wikipedia.org/wiki/Portrait_of_Francesco_delle_Opere','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":45,\"green\":41,\"blue\":37},\"web\":\"#2D2925\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":96,\"green\":127,\"blue\":154},\"web\":\"#607F9A\",\"name\":\"Air Force Blue\"},{\"color\":{\"red\":209,\"green\":199,\"blue\":172},\"web\":\"#D1C7AC\",\"name\":\"Parchment\"},{\"color\":{\"red\":164,\"green\":50,\"blue\":52},\"web\":\"#a43234\",\"name\":\"Guardsman Red\"},{\"color\":{\"red\":172,\"green\":124,\"blue\":76},\"web\":\"#ac7c4c\",\"name\":\"Muddy Waters\"},{\"color\":{\"red\":92,\"green\":102,\"blue\":79},\"web\":\"#5c664f\",\"name\":\"Chalet Green\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (384,97,5,'097010','Virgin of the Rocks',1,'https://www.nationalgallery.org.uk/paintings/leonardo-da-vinci-the-virgin-of-the-rocks','NG1093','Creative Commons BY-NC-ND 4.0','The Virgin of the Rocks (sometimes the Madonna of the Rocks) is the name used for two paintings by Leonardo da Vinci, of the same subject, and of a composition which is identical except for several significant details. The version generally considered the prime version, that is the earlier of the two, hangs in the Musee du Louvre in Paris and the other in the National Gallery, London. The paintings are both nearly 2 metres (over 6 feet) high and are painted in oils. Both were painted on wooden panel; that in the Louvre has been transferred to canvas. Both paintings show the Madonna and Christ Child with the infant John the Baptist and an angel, in a rocky setting which gives the paintings their usual name. The significant compositional differences are in the gaze and right hand of the angel. There are many minor ways in which the works differ, including the colours, the lighting, the flora, and the way in which sfumato has been used. Although the date of an associated commission is documented, the complete histories of the two paintings are unknown, and lead to speculation about which of the two is earlier.','The Virgin of the Rocks (sometimes the Madonna of the Rocks) is the name used for two paintings by Leonardo da Vinci, of the same subject, and of a composition which is identical except for several significant details.',1505,190,120,'Oil on panel',600.0000,670.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Virgin_of_the_Rocks','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":48,\"green\":39,\"blue\":28},\"web\":\"#30271c\",\"name\":\"Black Magic\"},{\"color\":{\"red\":37,\"green\":68,\"blue\":92},\"web\":\"#25445c\",\"name\":\"Regal Blue\"},{\"color\":{\"red\":252,\"green\":252,\"blue\":249},\"web\":\"#FCFCF9\",\"name\":\"Ivory\"},{\"color\":{\"red\":125,\"green\":110,\"blue\":99},\"web\":\"#7d6e63\",\"name\":\"Donkey Brown\"},{\"color\":{\"red\":185,\"green\":173,\"blue\":167},\"web\":\"#b9ada7\",\"name\":\"Martini\"},{\"color\":{\"red\":35,\"green\":93,\"blue\":97},\"web\":\"#235d61\",\"name\":\"Blue Stone\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (386,97,4,'097020','Annunciation',4,'http://www.uffizi.firenze.it/catalogo/','1890, 1618','Public domain','This is a painting of the traditional subject of the Annunciation, by the Italian Renaissance artists Leonardo da Vinci and Andrea del Verrocchio, dating from circa 1472-1475 and housed in the Uffizi Gallery of Florence, Italy. The angel holds a Madonna lily, a symbol of Mary\'s virginity and of the city of Florence. It is supposed that Leonardo originally copied the wings from those of a bird in flight, but they have since been lengthened by a later artist.','This is a painting of the traditional subject of the Annunciation, by the Italian Renaissance artists Leonardo da Vinci and Andrea del Verrocchio, dating from circa 1472-1475 and housed in the Uffizi Gallery of Florence, Italy. The angel holds a Madonna lily, a symbol of Mary\'s virginity and of the city of Florence.',1472,98,217,'Oil and tempera on panel',550.0000,620.0000,'http://www.googleartproject.com/collection/uffizi-gallery/artwork/annunciation-leonardo-da-vinci/324474/','The original location and commissioning of this work are unknown. It was painted at about the time Leonardo was still at Verroccchio\'s workshop (1472, ca.) It came to the Uffizi in 1867 from the sacristy of San Bartolomeo a Monteoliveto outside the gate of San Frediano. One can already see the careful attention to the atmospheric changes in the landscape which will be further developed by the artist in later work. The work is meant to be seen from below and from the right. From this point of view certain details come into proper alignment such as the keystones on the building, the foreshortening of the Virgin\'s arm and the lectern.','http://en.wikipedia.org/wiki/Annunciation_(Leonardo)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":57,\"green\":44,\"blue\":72},\"web\":\"#392C48\",\"name\":\"Jagger\"},{\"color\":{\"red\":210,\"green\":198,\"blue\":168},\"web\":\"#D2C6A8\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":134,\"green\":120,\"blue\":92},\"web\":\"#86785C\",\"name\":\"Stonewall\"},{\"color\":{\"red\":149,\"green\":59,\"blue\":37},\"web\":\"#953b25\",\"name\":\"Fire\"},{\"color\":{\"red\":121,\"green\":115,\"blue\":112},\"web\":\"#797370\",\"name\":\"Hurricane\"},{\"color\":{\"red\":117,\"green\":79,\"blue\":59},\"web\":\"#754f3b\",\"name\":\"Old Copper\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (387,97,7,'097030','Ginevra de\' Benci',3,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.50724.html','1967.6.1.a','Open Access','Ginevra de Benci was an aristocrat from 15th-century Florence, admired for her intelligence by Florentine contemporaries. She is the subject of a portrait painting by Leonardo da Vinci. The oil-on-wood portrait was acquired by the National Gallery of Art in Washington, D.C., in 1967, for US$5 million paid to the Princely House of Liechtenstein, a record price at the time, from the Ailsa Mellon Bruce Fund. It is the only painting by Leonardo on public view in the Americas.','Ginevra de Benci was an aristocrat from 15th-century Florence, admired for her intelligence by Florentine contemporaries. She is the subject of a portrait painting by Leonardo da Vinci.',1474,38,37,'Oil on panel',650.0000,900.0000,'http://www.googleartproject.com/collection/national-gallery-of-art-washington-dc/artwork/ginevra-de-benci-leonardo-da-vinci/714778/',NULL,'http://en.wikipedia.org/wiki/Ginevra_de%27_Benci','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":61,\"green\":48,\"blue\":27},\"web\":\"#3D301B\",\"name\":\"Mikado\"},{\"color\":{\"red\":26,\"green\":19,\"blue\":16},\"web\":\"#1A1310\",\"name\":\"Wood Bark\"},{\"color\":{\"red\":208,\"green\":196,\"blue\":169},\"web\":\"#D0C4A9\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":120,\"green\":166,\"blue\":187},\"web\":\"#78A6BB\",\"name\":\"Glacier\"},{\"color\":{\"red\":118,\"green\":131,\"blue\":122},\"web\":\"#76837a\",\"name\":\"Blue Smoke\"},{\"color\":{\"red\":134,\"green\":101,\"blue\":61},\"web\":\"#86653d\",\"name\":\"McKenzie\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (388,97,16,'097040','The Virgin and Child with St. Anne',1,'http://www.louvre.fr/en/oeuvre-notices/virgin-and-child-saint-anne','INV. 776','&copy; Musee du Louvre','The Virgin and Child with Saint Anne is an oil painting by Leonardo da Vinci depicting St. Anne, her daughter the Virgin Mary and the infant Jesus. Christ is shown grappling with a sacrificial lamb symbolizing his Passion as the Virgin tries to restrain him. The painting was commissioned as the high altarpiece for the Church of Santissima Annunziata in Florence and its theme had long preoccupied Leonardo.','The Virgin and Child with Saint Anne is an oil painting by Leonardo da Vinci depicting St. Anne, her daughter the Virgin Mary and the infant Jesus.',1508,168,112,'Oil on wood',500.0000,550.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Virgin_and_Child_with_St._Anne_(Leonardo_da_Vinci)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":76,\"green\":44,\"blue\":23},\"web\":\"#4C2C17\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":166,\"green\":156,\"blue\":129},\"web\":\"#A69C81\",\"name\":\"Grey Olive\"},{\"color\":{\"red\":113,\"green\":68,\"blue\":28},\"web\":\"#71441C\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":154,\"green\":159,\"blue\":149},\"web\":\"#9A9F95\",\"name\":\"Delta\"},{\"color\":{\"red\":200,\"green\":191,\"blue\":166},\"web\":\"#C8BFA6\",\"name\":\"Sisal\"},{\"color\":{\"red\":197,\"green\":134,\"blue\":71},\"web\":\"#c58647\",\"name\":\"Peru\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (389,97,16,'097050','Mona Lisa',1,'http://www.louvre.fr/en/oeuvre-notices/mona-lisa-portrait-lisa-gherardini-wife-francesco-del-giocondo','INV. 779','&copy; Musee du Louvre','The Mona Lisa (or La Gioconda) is a half-length portrait of a woman by the Italian artist Leonardo da Vinci, which has been acclaimed as \"the best known, the most visited, the most written about, the most sung about, the most parodied work of art in the world.\" The painting, thought to be a portrait of Lisa Gherardini, the wife of Francesco del Giocondo, is in oil on a poplar panel, and is believed to have been painted between 1503 and 1506. It was acquired by King Francis I of France and is now the property of the French Republic, on permanent display at the Musee du Louvre in Paris since 1797. The ambiguity of the subject\'s expression, which is frequently described as enigmatic, the monumentality of the composition, the subtle modeling of forms and the atmospheric illusionism were novel qualities that have contributed to the continuing fascination and study of the work.','The Mona Lisa (or La Gioconda) is a half-length portrait of a woman by the Italian artist Leonardo da Vinci, which has been acclaimed as \"the best known, the most visited, the most written about, the most sung about, the most parodied work of art in the world.\" ',1503,77,53,'Oil on wood',400.0000,450.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Mona_Lisa','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":30,\"green\":18,\"blue\":40},\"web\":\"#1E1228\",\"name\":\"Blackcurrant\"},{\"color\":{\"red\":110,\"green\":124,\"blue\":81},\"web\":\"#6E7C51\",\"name\":\"Willow Grove\"},{\"color\":{\"red\":150,\"green\":155,\"blue\":99},\"web\":\"#969B63\",\"name\":\"Avocado\"},{\"color\":{\"red\":88,\"green\":83,\"blue\":59},\"web\":\"#58533B\",\"name\":\"Panda\"},{\"color\":{\"red\":225,\"green\":189,\"blue\":98},\"web\":\"#E1BD62\",\"name\":\"Equator\"},{\"color\":{\"red\":119,\"green\":77,\"blue\":40},\"web\":\"#774d28\",\"name\":\"Korma\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (391,98,4,'098010','Doni Tondo',3,'http://www.uffizi.firenze.it/catalogo/','1890, 1456','Public domain','The Doni Tondo, sometimes called The Holy Family, is the only finished panel painting by the mature Michelangelo to survive. Now in the Uffizi in Florence, Italy, and still in its original frame, the painting was probably commissioned by Agnolo Doni to commemorate his marriage to Maddalena Strozzi, the daughter of a powerful Tuscan family. The painting is in the form of a tondo, or round frame, which is frequently associated during the Renaissance with domestic ideas. The work was most likely created during the period after the Doni\'s marriage in 1503 or 1504, as well as after the excavation of the Laocoon about 1506, yet before the Sistine Chapel ceiling frescoes were begun in 1508, dating the painting to approximately late 1506 or 1507. The Doni Tondo features the Christian Holy family (the child Jesus, Mary, and Saint Joseph) along with John the Baptist in the foreground and contains five ambiguous nude male figures in the background. The inclusion of these nude figures has been interpreted in a variety of ways.','The Doni Tondo is the only finished panel painting by the mature Michelangelo to survive. Now in the Uffizi in Florence, Italy, and still in its original frame, the painting was probably commissioned by Agnolo Doni to commemorate his marriage to Maddalena Strozzi, the daughter of a powerful Tuscan family. ',1507,120,120,'Oil and tempera on panel',600.0000,700.0000,'http://www.googleartproject.com/collection/uffizi-gallery/artwork/doni-tondo-michelangelo-buonarroti/324477/','The Doni Tondo is the most famous among the very few paintings on panel by Michelangelo, made on commission from the Florentine merchant Agnolo Doni for his wedding to Maddalena Strozzi in 1504. Originally it hung in the bedchamber of their home on Corso dei Tintori in Florence. The foreground is occupied by the highly modeled figures of the holy Family; the three figures together form a compact group in which the baby Jesus stands out against the intertwining arms of the Virgin and Joseph.','http://en.wikipedia.org/wiki/Doni_Tondo','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":244,\"green\":249,\"blue\":250},\"web\":\"#F4F9FA\",\"name\":\"Azure\"},{\"color\":{\"red\":195,\"green\":189,\"blue\":233},\"web\":\"#C3BDE9\",\"name\":\"Melrose\"},{\"color\":{\"red\":82,\"green\":78,\"blue\":134},\"web\":\"#524E86\",\"name\":\"Victoria\"},{\"color\":{\"red\":81,\"green\":43,\"blue\":28},\"web\":\"#512B1C\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":221,\"green\":195,\"blue\":110},\"web\":\"#DDC36E\",\"name\":\"Chenin\"},{\"color\":{\"red\":153,\"green\":105,\"blue\":67},\"web\":\"#996943\",\"name\":\"Dark Tan\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (392,98,38,'098020','The Creation of Adam',4,'http://mv.vatican.va/3_EN/pages/x-Schede/CSNs/CSNs_V_StCentr_06.html',NULL,NULL,'The Creation of Adam is arguably the most famous section of Michelangelo\'s fresco Sistine Chapel ceiling painted circa 1511-1512. It is traditionally thought to illustrate the Biblical creation narrative from the Book of Genesis in which God breathes life into Adam, the first man. Chronologically the fourth in the series of panels depicting episodes from Genesis on the Sistine ceiling, it was among the last to be completed. It is the most well-known of the Sistine Chapel fresco panels, and its fame as a piece of art is rivaled only by the Mona Lisa by Leonardo da Vinci. The image of the near-touching hands of God and Adam has become one of the single most iconic images of humanity and has been reproduced in countless imitations and parodies. Along with Leonardo da Vinci\'s The Last Supper, The Creation of Adam and the other Sistine Chapel panels are the most replicated religious paintings of all time.','The Creation of Adam is arguably the most famous section of Michelangelo\'s fresco Sistine Chapel ceiling painted circa 1511-1512. It is traditionally thought to illustrate the Biblical creation narrative from the Book of Genesis in which God breathes life into Adam, the first man.',1512,480,230,'Fresco',1200.0000,1400.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Creation_of_Adam','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":186,\"green\":191,\"blue\":191},\"web\":\"#BABFBF\",\"name\":\"Jungle Mist\"},{\"color\":{\"red\":92,\"green\":81,\"blue\":56},\"web\":\"#5C5138\",\"name\":\"West Coast\"},{\"color\":{\"red\":172,\"green\":154,\"blue\":126},\"web\":\"#AC9A7E\",\"name\":\"Bronco\"},{\"color\":{\"red\":207,\"green\":187,\"blue\":157},\"web\":\"#CFBB9D\",\"name\":\"Vanilla\"},{\"color\":{\"red\":82,\"green\":43,\"blue\":20},\"web\":\"#522B14\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":102,\"green\":133,\"blue\":149},\"web\":\"#668595\",\"name\":\"Horizon\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (393,98,38,'098030','Libyan Sibyl',3,'http://mv.vatican.va/3_EN/pages/x-Schede/CSNs/CSNs_V_SibProf_08.html',NULL,NULL,'On the five pendentives along each side of the ceiling of the Sistine Chapel and the two at either end, Michelangelo painted the largest figures on the ceiling: twelve people who prophesied or represented some aspect of the Coming of Christ. Of those twelve, seven were Prophets of Israel and were male. The remaining five were prophets of the Classical World, called Sibyls and were female. The Libyan Sibyl, named Phemonoe, was the prophetic priestess presiding over the Zeus Ammon Oracle (Zeus represented with the horns of Ammon) at Siwa Oasis in the Libyan Desert.','On the five pendentives along each side of the ceiling of the Sistine Chapel and the two at either end, Michelangelo painted the largest figures on the ceiling: twelve people who prophesied or represented some aspect of the Coming of Christ.',1510,395,380,'Fresco',1000.0000,1100.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Libyan_Sibyl','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":177,\"green\":95,\"blue\":18},\"web\":\"#B15F12\",\"name\":\"Golden Brown\"},{\"color\":{\"red\":209,\"green\":136,\"blue\":21},\"web\":\"#D18815\",\"name\":\"Ochre\"},{\"color\":{\"red\":208,\"green\":145,\"blue\":103},\"web\":\"#D09167\",\"name\":\"Whiskey\"},{\"color\":{\"red\":135,\"green\":59,\"blue\":19},\"web\":\"#873B13\",\"name\":\"Saddle Brown\"},{\"color\":{\"red\":166,\"green\":159,\"blue\":130},\"web\":\"#a69f82\",\"name\":\"Hillary\"},{\"color\":{\"red\":109,\"green\":139,\"blue\":115},\"web\":\"#6d8b73\",\"name\":\"Laurel\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (394,99,18,'099010','Madonna in the Meadow',1,'https://www.khm.at/de/object/77f959f119/','175','Only for private use','The Madonna of the Meadow is also known as Madonna del prato. In it, the three figures in a calm green meadow are linked by looks and touching hands. The Virgin Mary is shown in a contrapposto pose, wearing a gold-bordered blue mantle set against a red dress and with her right leg lying along a diagonal. The blue symbolizes the church and the red Christ\'s death, with the Madonna the uniting of Mother Church with Christ\'s sacrifice. With her eyes fixed on Christ, her head is turned to the left and slightly inclined, and in her hands she holds up Christ, as he leans forward unsteadily to touch the miniature cross held by John. The poppy refers to Christ\'s passion, death and resurrection.','In it, the three figures in a calm green meadow are linked by looks and touching hands. The Virgin Mary is shown in a contrapposto pose, wearing a gold-bordered blue mantle set against a red dress and with her right leg lying along a diagonal. The blue symbolizes the church and the red Christ\'s death, with the Madonna the uniting of Mother Church with Christ\'s sacrifice.',1505,113,88,'Oil on wood',400.0000,450.0000,'http://www.googleartproject.com/collection/kunsthistorisches-museum-vienna-museum-of-fine-arts/artwork/madonna-in-the-meadow-raphael/676851/','In 1504 the young Raphael came from Perugia to Florence, where Leonardo da Vinci and Michelangelo dominated artistic life. Especially under the influence of LeonardoÔÇÖs compositions, the newcomer created a series of Madonna depictions. Particularly in Florence, the Madonna image had experienced a change in function: it was no longer mainly a religious item for practical use, but primarily an exquisite expression of artistic achievement. Raphael gave the Madonna in the Meadow to his Florentine patron Taddeo Taddi as a gift; in 1662 it was acquired at its place of origin by Archduke Ferdinand Karl of Tirol. In keeping with the Sienese type of the Madonna Humilitatis the Virgin Maryis sitting on an elevation on the ground. Supporting the infant Jesus with both hands, she looks at little John the Baptist. The encounter of the two children has been mentioned in Tuscan devotional literature since the late 13th century. The cross is simultaneously a toy, an attribute of John the Baptist and a Passion symbol. The latter is also true of the conspicuously positioned poppy on the right. In the present painting, which was created at the beginning of his series of full-length Madonna depictions, Raphael decided on a strictly geometrical structure: the group is incorporated in an equilateral triangle. However, within the seemingly rigid structure, a lively scene unfolds. Parallel and opposing movements and glances blend with the landscape in the background to create a composition that is in keeping with the demands of the High Renaissance for perfect balance and harmony','http://en.wikipedia.org/wiki/Madonna_of_the_meadow_(Raphael)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":102,\"green\":81,\"blue\":31},\"web\":\"#66511F\",\"name\":\"Horses Neck\"},{\"color\":{\"red\":187,\"green\":201,\"blue\":199},\"web\":\"#BBC9C7\",\"name\":\"Jungle Mist\"},{\"color\":{\"red\":15,\"green\":49,\"blue\":92},\"web\":\"#0F315C\",\"name\":\"Prussian Blue\"},{\"color\":{\"red\":155,\"green\":38,\"blue\":21},\"web\":\"#9B2615\",\"name\":\"Mandarian Orange\"},{\"color\":{\"red\":137,\"green\":168,\"blue\":187},\"web\":\"#89A8BB\",\"name\":\"Nepal\"},{\"color\":{\"red\":155,\"green\":178,\"blue\":154},\"web\":\"#9bb29a\",\"name\":\"Mantel\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (398,99,16,'099050','Portrait of Baldassare Castiglione',1,'http://cartelen.louvre.fr/cartelen/visite?srv=car_not_frame&idNotice=13961','INV. 611','&copy; Musee du Louvre','Considered one of the great portraits of the Renaissance, it has an enduring influence. It depicts Raphael\'s friend, the diplomat and humanist Baldassare Castiglione, who is considered a quintessential example of the High Renaissance gentleman.','Considered one of the great portraits of the Renaissance, it has an enduring influence. It depicts Raphael\'s friend, the diplomat and humanist Baldassare Castiglione, who is considered a quintessential example of the High Renaissance gentleman.',1514,67,82,'Oil on wood',500.0000,540.0000,'','','https://en.wikipedia.org/wiki/Portrait_of_Baldassare_Castiglione','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":166,\"green\":146,\"blue\":108},\"web\":\"#A6926C\",\"name\":\"Pale Oyster\"},{\"color\":{\"red\":63,\"green\":52,\"blue\":33},\"web\":\"#3F3421\",\"name\":\"Mikado\"},{\"color\":{\"red\":29,\"green\":27,\"blue\":22},\"web\":\"#1D1B16\",\"name\":\"Maire\"},{\"color\":{\"red\":239,\"green\":228,\"blue\":195},\"web\":\"#EFE4C3\",\"name\":\"Half Colonial White\"},{\"color\":{\"red\":93,\"green\":78,\"blue\":57},\"web\":\"#5D4E39\",\"name\":\"Metallic Bronze\"},{\"color\":{\"red\":150,\"green\":130,\"blue\":86},\"web\":\"#968256\",\"name\":\"Muesli\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (399,99,7,'099060','Alba Madonna',3,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.26.html','1937.1.24','Open Access','The Alba Madonna is a painting by the Italian High Renaissance artist Raphael, depicting Mary, Jesus and John the Baptist, in a typical Italian countryside. John the Baptist is holding up a cross to Jesus, which the baby Jesus is grasping. All three figures are staring at the cross. The three figures are grouped to the left in the round design, but the outstretched arm of the Madonna and the billowing material of her cloak balance the image.','The Alba Madonna is a painting by the Italian High Renaissance artist Raphael, depicting Mary, Jesus and John the Baptist, in a typical Italian countryside. John the Baptist is holding up a cross to Jesus, which the baby Jesus is grasping. All three figures are staring at the cross. The three figures are grouped to the left in the round design, but the outstretched arm of the Madonna and the billowing material of her cloak balance the image.',1510,94,94,'Oil transferred from wood to canvas',600.0000,700.0000,'http://www.googleartproject.com/collection/national-gallery-of-art-washington-dc/artwork/the-alba-madonna-raphael/712887/',NULL,'http://en.wikipedia.org/wiki/Alba_Madonna','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":147,\"green\":196,\"blue\":223},\"web\":\"#93C4DF\",\"name\":\"Cornflower\"},{\"color\":{\"red\":100,\"green\":83,\"blue\":53},\"web\":\"#645335\",\"name\":\"Horses Neck\"},{\"color\":{\"red\":45,\"green\":54,\"blue\":53},\"web\":\"#2D3635\",\"name\":\"Aztec\"},{\"color\":{\"red\":91,\"green\":127,\"blue\":118},\"web\":\"#5B7F76\",\"name\":\"Cutty Sark\"},{\"color\":{\"red\":199,\"green\":159,\"blue\":131},\"web\":\"#c79f83\",\"name\":\"Rodeo Dust\"},{\"color\":{\"red\":197,\"green\":116,\"blue\":115},\"web\":\"#c57473\",\"name\":\"Contessa\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (401,99,43,'099080','Sistine Madonna',1,'http://skd-online-collection.skd.museum/de/contents/show?id=372144','93',NULL,'Sistine Madonna is an oil painting by the Italian artist Raphael. Commissioned in 1512 by Pope Julius II as an altarpiece for the church of San Sisto, Piacenza, it was one of the last Madonnas painted by the artist. Relocated to Dresden from 1754, the well-known painting has been particularly influential in Germany. After World War II, it was relocated to Moscow for a decade before it was returned to Germany. There, it resides as one of the central pieces in the Gemeldegalerie Alte Meister. The painting has been highly praised by many notable critics, and Giorgio Vasari called it a \"a truly rare and extraordinary work\".','Sistine Madonna is an oil painting by the Italian artist Raphael. Commissioned in 1512 by Pope Julius II as an altarpiece for the church of San Sisto, Piacenza, it was one of the last Madonnas painted by the artist. Relocated to Dresden from 1754, the well-known painting has been particularly influential in Germany. The painting has been highly praised by many notable critics, and Giorgio Vasari called it a \"a truly rare and extraordinary work\".',1512,265,196,'Oil on canvas',900.0000,1000.0000,'http://www.googleartproject.com/collection/gemaldegalerie-alte-meister-old-masters-picture-gallery/artwork/the-sistine-madonna-raphael/712643/',NULL,'http://en.wikipedia.org/wiki/Sistine_Madonna','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":208,\"green\":191,\"blue\":154},\"web\":\"#D0BF9A\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":113,\"green\":75,\"blue\":31},\"web\":\"#714B1F\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":170,\"green\":157,\"blue\":127},\"web\":\"#AA9D7F\",\"name\":\"Napa\"},{\"color\":{\"red\":27,\"green\":52,\"blue\":26},\"web\":\"#1b341a\",\"name\":\"Myrtle\"},{\"color\":{\"red\":153,\"green\":112,\"blue\":63},\"web\":\"#99703f\",\"name\":\"Buttered Rum\"},{\"color\":{\"red\":113,\"green\":42,\"blue\":30},\"web\":\"#712a1e\",\"name\":\"Pueblo\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (403,99,43,'099100','Madonna of the Chair',3,'http://skd-online-collection.skd.museum/en/contents/showSearch?id=505378','97',NULL,'The Madonna of the Chair or the Madonna della seggiola is a Madonna painting by the Italian renaissance artist Raphael, dating to c. 1513-1514 and housed in the Palazzo Pitti collection in Florence. It depicts Mary embracing the child Christ, while the young John the Baptist devoutly watches. Painted during his Roman period, this Madonna does not have the strict geometrical form and linear style of his earlier Florentine treatments of the same subject. Instead, the warmer colors seem to suggest the influence of Titian and Raphael\'s rival Sebastiano del Piombo.','The Madonna of the Chair or the Madonna della seggiola is a Madonna painting by the Italian renaissance artist Raphael, dating to c. 1513-1514 and housed in the Palazzo Pitti collection in Florence.',1514,71,71,'Oil on panel',500.0000,600.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Madonna_della_seggiola','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":75,\"green\":42,\"blue\":30},\"web\":\"#4B2A1E\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":218,\"green\":191,\"blue\":157},\"web\":\"#DABF9D\",\"name\":\"Raffia\"},{\"color\":{\"red\":140,\"green\":117,\"blue\":92},\"web\":\"#8C755C\",\"name\":\"Cement\"},{\"color\":{\"red\":130,\"green\":160,\"blue\":179},\"web\":\"#82A0B3\",\"name\":\"Bali Hai\"},{\"color\":{\"red\":150,\"green\":194,\"blue\":212},\"web\":\"#96C2D4\",\"name\":\"Regent St Blue\"},{\"color\":{\"red\":198,\"green\":108,\"blue\":94},\"web\":\"#c66c5e\",\"name\":\"Contessa\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (405,99,7,'099120','Portrait of Bindo Altoviti',1,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.12131.html','1943.4.33','Open Access','The Portrait of Bindo Altoviti is a painting finished around 1515 by the Italian High Renaissance painter Raphael. Bindo Altoviti was a rich banker born in Rome in 1491, but of Florentine origin. He was a cultured man who loved the arts. The graceful, almost effeminate position of the subject along with the heavy contrast between light and shadow are atypical of Raphael\'s work, particularly of his portraits of men, demonstrating the artist\'s experimentation with different styles and forms in his later Roman period. The influence of the works of Leonardo, which Raphael studied astutely during this period of his career, are strikingly evident in this particular piece.','The Portrait of Bindo Altoviti is a painting finished around 1515 by the Italian High Renaissance painter Raphael. Bindo Altoviti was a rich banker born in Rome in 1491, but of Florentine origin.',1515,60,44,'Oil on wood',600.0000,660.0000,'http://www.googleartproject.com/collection/national-gallery-of-art-washington-dc/artwork/bindo-altoviti-raphael/718252/',NULL,'http://en.wikipedia.org/wiki/Portrait_of_Bindo_Altoviti_(Raphael)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":42,\"green\":56,\"blue\":22},\"web\":\"#2A3816\",\"name\":\"Pine Tree\"},{\"color\":{\"red\":23,\"green\":23,\"blue\":22},\"web\":\"#171716\",\"name\":\"Maire\"},{\"color\":{\"red\":58,\"green\":87,\"blue\":103},\"web\":\"#3A5767\",\"name\":\"San Juan\"},{\"color\":{\"red\":110,\"green\":73,\"blue\":33},\"web\":\"#6E4921\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":30,\"green\":59,\"blue\":76},\"web\":\"#1E3B4C\",\"name\":\"Nile Blue\"},{\"color\":{\"red\":175,\"green\":132,\"blue\":85},\"web\":\"#af8455\",\"name\":\"Muddy Waters\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (406,100,5,'100010','A Man with a Quilted Sleeve',1,'https://www.nationalgallery.org.uk/paintings/titian-portrait-of-gerolamo-barbarigo','NG1944','Creative Commons BY-NC-ND 4.0','This portrait was eloquently described by Giorgio Vasari in his 1568 biography of Titian. He identified the man as a member of the Barbarigo, an aristocratic Venetian family. The most likely candidate is Gerolamo, who was 30 years old in 1509. He had numerous political and literary contacts and would have helped the young Titian on his path to success.','This portrait was eloquently described by Giorgio Vasari in his 1568 biography of Titian. He identified the man as a member of the Barbarigo, an aristocratic Venetian family. The most likely candidate is Gerolamo, who was 30 years old in 1509. He had numerous political and literary contacts and would have helped the young Titian on his path to success.',1509,81,66,'Oil on canvas',500.0000,550.0000,'http://www.googleartproject.com/collection/the-national-gallery-london/artwork/portrait-of-gerolamo-barbarigo-titian/330402/',NULL,'http://en.wikipedia.org/wiki/A_Man_with_a_Quilted_Sleeve','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":76,\"green\":76,\"blue\":79},\"web\":\"#4c4c4f\",\"name\":\"Gun Powder\"},{\"color\":{\"red\":24,\"green\":21,\"blue\":17},\"web\":\"#181511\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":93,\"green\":76,\"blue\":38},\"web\":\"#5d4c26\",\"name\":\"Bronze Olive\"},{\"color\":{\"red\":168,\"green\":127,\"blue\":77},\"web\":\"#a87f4d\",\"name\":\"Muddy Waters\"},{\"color\":{\"red\":85,\"green\":75,\"blue\":48},\"web\":\"#554B30\",\"name\":\"Punga\"},{\"color\":{\"red\":206,\"green\":197,\"blue\":164},\"web\":\"#CEC5A4\",\"name\":\"Double Spanish White\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (407,100,4,'100020','Flora',1,'http://www.uffizi.firenze.it/catalogo/','1890, 146','Public domain','Flora is an oil painting by Italian late Renaissance painter Titian, dated to around 1515 and now held at the Uffizi Gallery in Florence. The work was reproduced in numerous 16th century etchings. It portrays an idealized beautiful woman, a model established in the Venetian school by Titian\'s master Giorgione with his Laura. Her left hands holds a pink-shaded mantle, while another holds a handful of flowers and leaves. The meaning of the painting is disputed: some, basing for example to inscriptions added to the 16th century reproductions, identifies the woman as a courtesan; other consider it a symbol of nuptial love, although her dress is not a dressing one. The identification with Flora, the ancient goddess of Spring and vegetation, derives from the presence of Spring flowers in her hands.','It portrays an idealized beautiful woman, a model established in the Venetian school by Titian\'s master Giorgione with his Laura. Her left hands holds a pink-shaded mantle, while another holds a handful of flowers and leaves.',1515,80,63,'Oil on canvas',700.0000,800.0000,'http://www.googleartproject.com/collection/uffizi-gallery/artwork/flora-tiziano-vecellio/327477/','Until 1641 this painting belonged to Alfonso L├▓pez, a businessman and Cardinal Richelieu\'s agent in Amsterdam. Documented in the Imperial Gallery of Vienna after 1728, it was exchanged for another painting in the Uffizi in 1793. Over the years, unsuccessful attempts have been made to identify the woman portrayed, although the most probable hypothesis remains that it represents the mythological figure, Flora.','http://en.wikipedia.org/wiki/Flora_(Titian)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":17,\"green\":14,\"blue\":15},\"web\":\"#110E0F\",\"name\":\"Rustic Red\"},{\"color\":{\"red\":202,\"green\":190,\"blue\":160},\"web\":\"#CABEA0\",\"name\":\"Sisal\"},{\"color\":{\"red\":114,\"green\":75,\"blue\":32},\"web\":\"#724B20\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":168,\"green\":158,\"blue\":131},\"web\":\"#A89E83\",\"name\":\"Napa\"},{\"color\":{\"red\":129,\"green\":119,\"blue\":93},\"web\":\"#81775D\",\"name\":\"Stonewall\"},{\"color\":{\"red\":209,\"green\":172,\"blue\":127},\"web\":\"#d1ac7f\",\"name\":\"Calico\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (408,100,5,'100030','Bacchus and Ariadne',3,'https://www.nationalgallery.org.uk/paintings/titian-bacchus-and-ariadne','NG35','Creative Commons BY-NC-ND 4.0','Bacchus and Ariadne (1520-23) is an oil painting by Titian. It is one of a cycle of paintings on mythological subjects produced for Alfonso d\'Este, the Duke of Ferrara, for the Camerino d\'Alabastro - a private room in his palazzo in Ferrara decorated with paintings based on classical texts. An advance payment was given to Raphael, who originally held the commission for the subject of a Triumph of Bacchus. At the time of Raphael\'s death in 1520, only a preliminary drawing was completed and the commission was then handed to Titian. In the case of Bacchus and Ariadne, the subject matter was derived from the Roman poets Catullus and Ovid. The painting, considered one of Titian\'s greatest works, now hangs in the National Gallery in London.','Bacchus and Ariadne (1520-23) is an oil painting by Titian. It is one of a cycle of paintings on mythological subjects produced for Alfonso d\'Este, the Duke of Ferrara, for the Camerino d\'Alabastro - a private room in his palazzo in Ferrara decorated with paintings based on classical texts.',1520,176,191,'Oil on canvas',1200.0000,1400.0000,'http://www.googleartproject.com/collection/the-national-gallery-london/artwork/bacchus-and-ariadne-titian/331385/',NULL,'http://en.wikipedia.org/wiki/Bacchus_and_Ariadne','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":92,\"green\":117,\"blue\":166},\"web\":\"#5C75A6\",\"name\":\"San Marino\"},{\"color\":{\"red\":65,\"green\":52,\"blue\":30},\"web\":\"#41341E\",\"name\":\"Mikado\"},{\"color\":{\"red\":215,\"green\":186,\"blue\":152},\"web\":\"#D7BA98\",\"name\":\"Pancho\"},{\"color\":{\"red\":225,\"green\":175,\"blue\":134},\"web\":\"#E1AF86\",\"name\":\"Manhattan\"},{\"color\":{\"red\":135,\"green\":154,\"blue\":173},\"web\":\"#879aad\",\"name\":\"Bali Hai\"},{\"color\":{\"red\":129,\"green\":82,\"blue\":82},\"web\":\"#815252\",\"name\":\"Lotus\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (409,100,4,'100040','Venus of Urbino',2,'http://www.uffizi.firenze.it/catalogo/','1890, 1437','Public domain','The Venus of Urbino is a 1538 oil painting by the Italian master Titian. It depicts a nude young woman, identified with the goddess Venus, reclining on a couch or bed in the sumptuous surroundings of a Renaissance palace. It hangs in the Galleria degli Uffizi in Florence. The figure\'s pose is based on Giorgione\'s Sleeping Venus (c. 1510), which Titian completed. In this depiction, Titian has domesticated Venus by moving her to an indoor setting, engaging her with the viewer, and making her sensuality explicit. Devoid as it is of any classical or allegorical trappings - Venus displays none of the attributes of the goddess she is supposed to represent - the painting is unapologetically erotic.','It depicts a nude young woman, identified with the goddess Venus, reclining on a couch or bed in the sumptuous surroundings of a Renaissance palace.',1538,166,119,'Oil on canvas',1000.0000,1100.0000,'http://www.googleartproject.com/collection/uffizi-gallery/artwork/venus-of-urbino-tiziano-vecellio/324480/','This painting was purchased in 1538 by Guidobaldo della Rovere, duke of Urbino, who called it the image of a \"nude woman\" in the correspondence with his ambassador in Venice. It was Giorgio Vasari who described it as \"a young Venus lying down\", an identification thereafter unanimously accepted. It reached Florence with Vittoria della Rovere who, in 1631, inherited the estate of her grandfather, Francesco Maria II; in 1637, she married Ferdinand II of Tuscany. The Venus was placed in the Tribuna of the Uffizi in 1736, but it was hidden from the visitors\' view by a cover depicting Sacred Love.','http://en.wikipedia.org/wiki/Venus_of_Urbino','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":5},\"dominantColors\":[{\"color\":{\"red\":18,\"green\":12,\"blue\":16},\"web\":\"#120C10\",\"name\":\"Melanzane\"},{\"color\":{\"red\":52,\"green\":18,\"blue\":6},\"web\":\"#341206\",\"name\":\"Seal Brown\"},{\"color\":{\"red\":244,\"green\":226,\"blue\":206},\"web\":\"#F4E2CE\",\"name\":\"Sazerac\"},{\"color\":{\"red\":110,\"green\":23,\"blue\":11},\"web\":\"#6E170B\",\"name\":\"Falu Red\"},{\"color\":{\"red\":222,\"green\":170,\"blue\":102},\"web\":\"#deaa66\",\"name\":\"Equator\"},{\"color\":{\"red\":236,\"green\":202,\"blue\":153},\"web\":\"#ecca99\",\"name\":\"Chamois\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (412,101,5,'101030','Supper at Emmaus',2,'https://www.nationalgallery.org.uk/paintings/michelangelo-merisi-da-caravaggio-the-supper-at-emmaus','NG172','Creative Commons BY-NC-ND 4.0','The Supper at Emmaus is a painting by the Italian Baroque master Caravaggio, and now in the National Gallery in London. The painting depicts the moment when the resurrected but incognito Jesus, reveals himself to two of his disciples (presumed to be Luke and Cleopas), only to soon vanish from their sight. Cleopas wears the scallopshell of a pilgrim. The other apostle wears torn clothes. Cleopas gesticulates in a perspectively-challenging extension of arms in and out of the frame of reference. The standing groom, forehead smooth and face in darkness, appears oblivious to the event. The painting is unusual for the life-sized figures, the dark and blank background. The table lays out a still-life meal. The basket of food teeters perilously over the edge.','The painting depicts the moment when the resurrected but incognito Jesus, reveals himself to two of his disciples (presumed to be Luke and Cleopas), only to soon vanish from their sight.',1601,141,196,'Oil on canvas',1300.0000,1500.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Supper_at_Emmaus_(London)_(Caravaggio)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":126,\"green\":115,\"blue\":84},\"web\":\"#7E7354\",\"name\":\"Pablo\"},{\"color\":{\"red\":66,\"green\":51,\"blue\":29},\"web\":\"#42331D\",\"name\":\"Clinker\"},{\"color\":{\"red\":42,\"green\":29,\"blue\":12},\"web\":\"#2A1D0C\",\"name\":\"Cocoa Brown\"},{\"color\":{\"red\":79,\"green\":43,\"blue\":28},\"web\":\"#4F2B1C\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":125,\"green\":116,\"blue\":69},\"web\":\"#7D7445\",\"name\":\"Go Ben\"},{\"color\":{\"red\":154,\"green\":144,\"blue\":118},\"web\":\"#9A9076\",\"name\":\"Pale Oyster\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (413,102,5,'102010','The Judgement of Paris',2,'https://www.nationalgallery.org.uk/paintings/peter-paul-rubens-the-judgement-of-paris','NG194','Creative Commons BY-NC-ND 4.0','The Judgement of Paris produced by Peter Paul Rubens is one of two very similar paintings. Both show Rubens\' version of idealised feminine beauty, with the goddesses Venus, Minerva and Juno on one side and Paris accompanied by Mercury on the other.','The Judgement of Paris produced by Peter Paul Rubens is one of two very similar paintings. Both show Rubens\' version of idealised feminine beauty, with the goddesses Venus, Minerva and Juno on one side and Paris accompanied by Mercury on the other.',1636,144,193,'Oil on canvas',900.0000,1100.0000,'http://www.googleartproject.com/collection/the-national-gallery-london/artwork/the-judgement-of-paris-peter-paul-rubens/331377/details/',NULL,'http://en.wikipedia.org/wiki/The_Judgment_of_Paris_(Rubens)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":189,\"green\":150,\"blue\":132},\"web\":\"#BD9684\",\"name\":\"Pale Taupe\"},{\"color\":{\"red\":215,\"green\":187,\"blue\":168},\"web\":\"#D7BBA8\",\"name\":\"Just Right\"},{\"color\":{\"red\":41,\"green\":11,\"blue\":13},\"web\":\"#290B0D\",\"name\":\"Rustic Red\"},{\"color\":{\"red\":149,\"green\":109,\"blue\":90},\"web\":\"#956D5A\",\"name\":\"Beaver\"},{\"color\":{\"red\":132,\"green\":112,\"blue\":89},\"web\":\"#847059\",\"name\":\"Cement\"},{\"color\":{\"red\":140,\"green\":53,\"blue\":28},\"web\":\"#8c351c\",\"name\":\"Burnt Umber\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (417,104,2,'104010','Las Meninas',1,'https://www.museodelprado.es/en/the-collection/art-work/las-meninas/9fdc7800-9ade-48b0-ab8b-edee94ea877f','P01174','Private, personal, academic, research or educational','Las Meninas (Spanish for The Maids of Honour) is a 1656 painting by Diego Velazquez, the leading artist of the Spanish Golden Age, in the Museo del Prado in Madrid. The work\'s complex and enigmatic composition raises questions about reality and illusion, and creates an uncertain relationship between the viewer and the figures depicted. Because of these complexities, Las Meninas has been one of the most widely analyzed works in Western painting. The painting shows a large room in the Madrid palace of King Philip IV of Spain, and presents several figures, most identifiable from the Spanish court, captured, according to some commentators, in a particular moment as if in a snapshot. Some look out of the canvas towards the viewer, while others interact among themselves. The young Infanta Margaret Theresa is surrounded by her entourage of maids of honour, chaperone, bodyguard, two dwarfs and a dog. Just behind them, Velazquez portrays himself working at a large canvas. Velazquez looks outwards, beyond the pictorial space to where a viewer of the painting would stand. In the background there is a mirror that reflects the upper bodies of the king and queen. They appear to be placed outside the picture space in a position similar to that of the viewer, although some scholars have speculated that their image is a reflection from the painting Velazquez is shown working on.','The work\'s complex and enigmatic composition raises questions about reality and illusion, and creates an uncertain relationship between the viewer and the figures depicted. Because of these complexities, Las Meninas has been one of the most widely analyzed works in Western painting.',1656,318,276,'Oil on canvas',1100.0000,1200.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Las_Meninas','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":51,\"green\":48,\"blue\":39},\"web\":\"#333027\",\"name\":\"Graphite\"},{\"color\":{\"red\":172,\"green\":155,\"blue\":127},\"web\":\"#AC9B7F\",\"name\":\"Bronco\"},{\"color\":{\"red\":60,\"green\":51,\"blue\":33},\"web\":\"#3C3321\",\"name\":\"Mikado\"},{\"color\":{\"red\":92,\"green\":79,\"blue\":58},\"web\":\"#5C4F3A\",\"name\":\"Metallic Bronze\"},{\"color\":{\"red\":78,\"green\":74,\"blue\":63},\"web\":\"#4E4A3F\",\"name\":\"Panda\"},{\"color\":{\"red\":201,\"green\":186,\"blue\":159},\"web\":\"#C9BA9F\",\"name\":\"Sisal\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (418,104,2,'104020','The Surrender of Breda',2,'https://www.museodelprado.es/en/the-collection/art-work/the-surrender-of-breda/0cc7577a-51d9-44fd-b4d5-4dba8d9cb13a','P01172','Private, personal, academic, research or educational','The Surrender of Breda is a painting by Velazquez, painted during the years 1634-35, and inspired while Velazquez was visiting Italy with Ambrogio Spinola, the Genoese general who conquered Breda on June 5, 1625. It is considered one of Velazquez\'s best artworks. Jan Morris has called it \"one of the most Spanish of all pictures\". The capture of Breda in 1625 was one of the few major successes of Spanish arms in the latter stages of the Eighty Years\' War. The Spanish general, the Genoese aristocrat Ambrogio Spinola, conquered Breda in contradiction to the instructions of his superiors. Before its capture the Spanish government had decided that siege warfare of heavily defended towns of the Low Countries was too wasteful and that it would concentrate on the economic blockade of the Dutch republic. The bulk of Spanish forces were diverted to the unfolding vast Thirty Years War.','The Surrender of Breda is a painting by Velazquez, painted during the years 1634-35, and inspired while Velazquez was visiting Italy with Ambrogio Spinola, the Genoese general who conquered Breda on June 5, 1625.',1634,307,367,'Oil on canvas',1000.0000,1100.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Surrender_of_Breda','{\"safeSearchAnnotation\":{\"violence\":2,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":98,\"green\":81,\"blue\":60},\"web\":\"#62513C\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":130,\"green\":116,\"blue\":92},\"web\":\"#82745C\",\"name\":\"Stonewall\"},{\"color\":{\"red\":167,\"green\":154,\"blue\":130},\"web\":\"#A79A82\",\"name\":\"Bronco\"},{\"color\":{\"red\":69,\"green\":53,\"blue\":36},\"web\":\"#453524\",\"name\":\"Clinker\"},{\"color\":{\"red\":150,\"green\":157,\"blue\":152},\"web\":\"#969D98\",\"name\":\"Edward\"},{\"color\":{\"red\":121,\"green\":125,\"blue\":116},\"web\":\"#797D74\",\"name\":\"Gunsmoke\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (419,104,5,'104030','Rokeby Venus',2,'https://www.nationalgallery.org.uk/paintings/diego-velazquez-the-toilet-of-venus-the-rokeby-venus','NG2057','Creative Commons BY-NC-ND 4.0','The Rokeby Venus is a painting by Diego Velazquez (1599-1660), the leading artist of the Spanish Golden Age. Completed between 1647 and 1651, and probably painted during the artist\'s visit to Italy, the work depicts the goddess Venus in a sensual pose, lying on a bed and looking into a mirror held by the Roman god of physical love, her son Cupid. Numerous works, from the ancient to the baroque, have been cited as sources of inspiration for Velazquez. The nude Venuses of the Italian painters, such as Giorgione\'s Sleeping Venus (c. 1510) and Titian\'s Venus of Urbino (1538), were the main precedents. In this work, Velazquez combined two established poses for Venus: recumbent on a couch or a bed, and gazing at a mirror. She is often described as looking at herself on the mirror, although this is physically impossible since viewers can see her face reflected in their direction. This phenomenon is known as the Venus effect. In a number of ways the painting represents a pictorial departure, through its central use of a mirror, and because it shows the body of Venus turned away from the observer of the painting.','Completed between 1647 and 1651, and probably painted during the artist\'s visit to Italy, the work depicts the goddess Venus in a sensual pose, lying on a bed and looking into a mirror held by the Roman god of physical love, her son Cupid. Numerous works, from the ancient to the baroque, have been cited as sources of inspiration for Velazquez.',1647,122,177,'Oil on canvas',600.0000,700.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Rokeby_Venus','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":5},\"dominantColors\":[{\"color\":{\"red\":167,\"green\":156,\"blue\":150},\"web\":\"#A79C96\",\"name\":\"Del Rio\"},{\"color\":{\"red\":59,\"green\":62,\"blue\":73},\"web\":\"#3b3e49\",\"name\":\"Blue Zodiac\"},{\"color\":{\"red\":75,\"green\":35,\"blue\":43},\"web\":\"#4B232B\",\"name\":\"Bordeaux\"},{\"color\":{\"red\":135,\"green\":60,\"blue\":73},\"web\":\"#873c49\",\"name\":\"Camelot\"},{\"color\":{\"red\":48,\"green\":48,\"blue\":48},\"web\":\"#303030\",\"name\":\"Night Rider\"},{\"color\":{\"red\":178,\"green\":147,\"blue\":147},\"web\":\"#B29393\",\"name\":\"Rosy Brown\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (420,105,32,'105010','The Anatomy Lesson of Dr. Nicolaes Tulp',2,'https://www.mauritshuis.nl/en/explore/the-collection/artworks/the-anatomy-lesson-of-dr-nicolaes-tulp-146/','146','Private Use Only','The Anatomy Lesson of Dr. Nicolaes Tulp is a 1632 oil painting by Rembrandt housed in the Mauritshuis museum in The Hague, the Netherlands. Dr. Nicolaes Tulp is pictured explaining the musculature of the arm to medical professionals. Some of the spectators are various doctors who paid commissions to be included in the painting. The painting is signed in the top-left hand corner Rembrant. This may be the first instance of Rembrandt signing a painting with his forename (in its original form) as opposed to the monogramme RHL (Rembrant Harmenszoon of Leiden), and is thus a sign of his growing artistic confidence.','Dr. Nicolaes Tulp is pictured explaining the musculature of the arm to medical professionals. Some of the spectators are various doctors who paid commissions to be included in the painting.',1632,216,170,'Oil on canvas',900.0000,1100.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Anatomy_Lesson_of_Dr._Nicolaes_Tulp','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":25,\"green\":21,\"blue\":13},\"web\":\"#19150D\",\"name\":\"Maire\"},{\"color\":{\"red\":171,\"green\":153,\"blue\":128},\"web\":\"#AB9980\",\"name\":\"Bronco\"},{\"color\":{\"red\":54,\"green\":49,\"blue\":38},\"web\":\"#363126\",\"name\":\"Graphite\"},{\"color\":{\"red\":135,\"green\":117,\"blue\":94},\"web\":\"#87755E\",\"name\":\"Cement\"},{\"color\":{\"red\":122,\"green\":88,\"blue\":57},\"web\":\"#7a5839\",\"name\":\"Shingle Fawn\"},{\"color\":{\"red\":93,\"green\":80,\"blue\":59},\"web\":\"#5D503B\",\"name\":\"Metallic Bronze\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (422,105,43,'105020','The Prodigal Son in the Tavern',1,'http://skd-online-collection.skd.museum/en/contents/showSearch?id=376227','1559',NULL,'The Prodigal Son in the Brothel is a painting by the Dutch master Rembrandt. It is housed in the Staatliche Kunstsammlungen of Dresden, Germany. It is signed \"REMBRANDT F.\". It portrays two people who had been identified as Rembrandt himself and his wife Saskia. In the Protestant contemporary world, the theme of the prodigal son was a frequent subject for works of art due to its moral background.','It portrays two people who had been identified as Rembrandt himself and his wife Saskia. In the Protestant contemporary world, the theme of the prodigal son was a frequent subject for works of art due to its moral background.',1637,161,131,'Oil on canvas',850.0000,920.0000,'http://www.googleartproject.com/collection/gemaldegalerie-alte-meister-old-masters-picture-gallery/artwork/rembrandt-and-saskia-in-the-scene-of-the-prodigal-son-rembrandt/712645/',NULL,'http://en.wikipedia.org/wiki/The_Prodigal_Son_in_the_Tavern','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":57,\"green\":44,\"blue\":22},\"web\":\"#392C16\",\"name\":\"Black Magic\"},{\"color\":{\"red\":27,\"green\":18,\"blue\":10},\"web\":\"#1B120A\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":196,\"green\":144,\"blue\":56},\"web\":\"#C49038\",\"name\":\"Pizza\"},{\"color\":{\"red\":100,\"green\":80,\"blue\":37},\"web\":\"#645025\",\"name\":\"Horses Neck\"},{\"color\":{\"red\":49,\"green\":23,\"blue\":5},\"web\":\"#311705\",\"name\":\"Brown Pod\"},{\"color\":{\"red\":129,\"green\":85,\"blue\":25},\"web\":\"#815519\",\"name\":\"Hot Curry\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (423,105,24,'105030','The Return of the Prodigal Son',1,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/43413/?lng=en','742','Personal non-commercial use','The Return of the Prodigal Son is an oil painting by Rembrandt. It is among the Dutch master\'s final works, likely completed within two years of his death in 1669. Depicting the moment of the prodigal son\'s return to his father in the Biblical parable, it is a renowned work described by art historian Kenneth Clark as \"a picture which those who have seen the original in Leningrad may be forgiven for claiming as the greatest picture ever painted\".','The Return of the Prodigal Son is an oil painting by Rembrandt. It is among the Dutch master\'s final works, likely completed within two years of his death in 1669. ',1661,262,205,'Oil on canvas',700.0000,775.0000,'http://www.googleartproject.com/collection/the-state-hermitage-museum/artwork/return-of-the-prodigal-son-rembrandt-harmensz-van-rijn/327455/',NULL,'http://en.wikipedia.org/wiki/The_Return_of_the_Prodigal_Son_(Rembrandt)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":75,\"green\":42,\"blue\":29},\"web\":\"#4B2A1D\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":192,\"green\":153,\"blue\":66},\"web\":\"#C09942\",\"name\":\"Roti\"},{\"color\":{\"red\":146,\"green\":115,\"blue\":60},\"web\":\"#92733C\",\"name\":\"Buttered Rum\"},{\"color\":{\"red\":53,\"green\":40,\"blue\":39},\"web\":\"#352827\",\"name\":\"Livid Brown\"},{\"color\":{\"red\":145,\"green\":56,\"blue\":33},\"web\":\"#913821\",\"name\":\"Burnt Umber\"},{\"color\":{\"red\":42,\"green\":21,\"blue\":23},\"web\":\"#2A1517\",\"name\":\"Rustic Red\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (424,106,30,'106010','The Milkmaid',1,'http://hdl.handle.net/10934/RM0001.COLLECT.6417','SK-A-2344','Public domain','The Milkmaid is an oil-on-canvas painting of a \"milkmaid\", in fact a domestic kitchen maid, by the Dutch artist Johannes Vermeer. It is now in the Rijksmuseum in Amsterdam, Netherlands, which regards it as \"unquestionably one of the museum\'s finest attractions\". The painting is strikingly illusionistic, conveying not just details but a sense of the weight of the woman and the table. \"The light, though bright, doesn\'t wash out the rough texture of the bread crusts or flatten the volumes of the maid\'s thick waist and rounded shoulders\", wrote Karen Rosenberg, an art critic for The New York Times. Yet with half of the woman\'s face in shadow, it is \"impossible to tell whether her downcast eyes and pursed lips express wistfulness or concentration,\" she wrote.','The Milkmaid is an oil-on-canvas painting of a \"milkmaid\", in fact a domestic kitchen maid, by the Dutch artist Johannes Vermeer. It is now in the Rijksmuseum in Amsterdam, Netherlands, which regards it as \"unquestionably one of the museum\'s finest attractions\".',1657,46,41,'Oil on canvas',450.0000,525.0000,'http://www.googleartproject.com/collection/rijksmuseum/artwork/the-milkmaid-johannes-vermeer/328442/','Intent on her task, the kitchen maid pours milk from a jug. The composition radiates a quiet calm, the only movement being the flow of milk into the bowl. Its most exceptional feature is the rendering of light. The tiny dots representing the reflection of light - as in the br eadrolls on the table - are typical of Vermeer\'s technique. This painting is a high point within Vermeer\'s oeuvre. Of the thirty or so works he produced, four are in the Rijksmuseum.','http://en.wikipedia.org/wiki/The_Milkmaid_(Vermeer)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":203,\"green\":196,\"blue\":173},\"web\":\"#CBC4AD\",\"name\":\"Parchment\"},{\"color\":{\"red\":131,\"green\":119,\"blue\":94},\"web\":\"#83775E\",\"name\":\"Stonewall\"},{\"color\":{\"red\":62,\"green\":52,\"blue\":32},\"web\":\"#3E3420\",\"name\":\"Mikado \"},{\"color\":{\"red\":171,\"green\":155,\"blue\":101},\"web\":\"#AB9B65\",\"name\":\"Tallow\"},{\"color\":{\"red\":35,\"green\":44,\"blue\":95},\"web\":\"#232C5F\",\"name\":\"Lucky Point\"},{\"color\":{\"red\":202,\"green\":188,\"blue\":134},\"web\":\"#CABC86\",\"name\":\"Yuma\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (425,106,32,'106020','Girl with a Pearl Earring',1,'https://www.mauritshuis.nl/en/explore/the-collection/artworks/girl-with-a-pearl-earring-670/','670','Private Use Only','Girl with a Pearl Earring is one of Johannes Vermeer\'s masterworks and, as the name implies, uses a pearl earring for a focal point. Today the painting is kept in the Mauritshuis gallery in The Hague. It is sometimes referred to as \"the Mona Lisa of the North\" or \"the Dutch Mona Lisa\". More recent Vermeer literature points to the image being a tronie, the Dutch 17th-century description of a head that was not meant to be a portrait. After the most recent restoration of the painting in 1994, the subtle colour scheme and the intimacy of the girl\'s gaze toward the viewer have been greatly enhanced.','Girl with a Pearl Earring is one of Johannes Vermeer\'s masterworks and, as the name implies, uses a pearl earring for a focal point. ',1665,44,39,'Oil on canvas',500.0000,600.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Girl_with_a_Pearl_Earring','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":37,\"green\":29,\"blue\":16},\"web\":\"#251D10\",\"name\":\"Black Magic\"},{\"color\":{\"red\":59,\"green\":82,\"blue\":101},\"web\":\"#3B5265\",\"name\":\"Cello\"},{\"color\":{\"red\":137,\"green\":161,\"blue\":182},\"web\":\"#89A1B6\",\"name\":\"Nepal\"},{\"color\":{\"red\":135,\"green\":116,\"blue\":86},\"web\":\"#877456\",\"name\":\"Cement\"},{\"color\":{\"red\":171,\"green\":150,\"blue\":119},\"web\":\"#AB9677\",\"name\":\"Bronco\"},{\"color\":{\"red\":211,\"green\":190,\"blue\":161},\"web\":\"#D3BEA1\",\"name\":\"Soft Amber\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (426,106,18,'106030','The Art of Painting',3,'https://www.khm.at/de/object/8f125da0b3/','9128','Only for private use','The Art of Painting is a famous 17th century oil on canvas painting by Dutch painter, Johannes Vermeer. Many art historians believe that it is an allegory of painting, hence the alternative title of the painting. After Vermeer\'s The Procuress it is the largest work by the master. Its composition and iconography also make it the most complex Vermeer work of all.','The Art of Painting is a famous 17th century oil on canvas painting by Dutch painter, Johannes Vermeer. Many art historians believe that it is an allegory of painting, hence the alternative title of the painting. ',1666,130,110,'Oil on canvas',850.0000,925.0000,'http://www.googleartproject.com/collection/kunsthistorisches-museum-vienna-museum-of-fine-arts/artwork/the-art-of-painting-jan-vermeer/680295/',NULL,'http://en.wikipedia.org/wiki/The_Art_of_Painting','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":132,\"green\":115,\"blue\":88},\"web\":\"#847358\",\"name\":\"Cement\"},{\"color\":{\"red\":103,\"green\":86,\"blue\":60},\"web\":\"#67563C\",\"name\":\"Tobacco Brown\"},{\"color\":{\"red\":168,\"green\":149,\"blue\":120},\"web\":\"#A89578\",\"name\":\"Bronco\"},{\"color\":{\"red\":63,\"green\":50,\"blue\":30},\"web\":\"#2E2232\",\"name\":\"Blackcurrant\"},{\"color\":{\"red\":108,\"green\":139,\"blue\":144},\"web\":\"#6c8b90\",\"name\":\"Gothic\"},{\"color\":{\"red\":191,\"green\":153,\"blue\":100},\"web\":\"#bf9964\",\"name\":\"Fallow\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (427,106,30,'106040','The Love Letter',3,'http://hdl.handle.net/10934/RM0001.COLLECT.6418','SK-A-1595','Public domain','The Love Letter is a 17th-century genre painting by Jan Vermeer. The painting shows a servant maid handing a letter to a young woman with a cittern. The tied-up curtain in the foreground creates the impression that the viewer is looking at an intensely private, personal scene. There is also an element of trompe l\'oeil as Dutch paintings were often hung with little curtains to conserve them, and the device of painted curtains is seen in other Dutch works of the period. The diagonals on the chequered floor create the impression of depth and three-dimensionality. The fact that it is a love letter that the woman has received is made clear by the fact that she is carrying a lute (more specifically, a cittern, a member of the lute/guitar family). The lute was a symbol of love - often carnal love; luit was also a slang term for vagina. This idea is further reinforced by the slippers at the very bottom of the picture. The removed slipper was another symbol of sex. The floor brush would appear to represent domesticity, and its placement at the side of the painting may suggest that domestic concerns have been forgotten or pushed aside.','The painting shows a servant maid handing a letter to a young woman with a cittern. The tied-up curtain in the foreground creates the impression that the viewer is looking at an intensely private, personal scene.',1666,44,38,'Oil on canvas',750.0000,900.0000,'http://www.googleartproject.com/collection/rijksmuseum/artwork/the-love-letter-johannes-vermeer/324409/','Here Vermeer has chosen an unusual vantage point. From the depths of a shadowy space, we are given a glimpse of a room. A richly clad woman has momentarily ceased her music-making for a letter that has just been handed to her. She looks up expectantly at the servant girl. The subject of the letter could be related to the seascape behind the two women. In the 17th century the sea was often compared to love, and the lover to a ship.','http://en.wikipedia.org/wiki/The_Love_Letter_(Vermeer)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":66,\"green\":51,\"blue\":25},\"web\":\"#423319\",\"name\":\"Mikado\"},{\"color\":{\"red\":163,\"green\":158,\"blue\":130},\"web\":\"#A39E82\",\"name\":\"Hillary\"},{\"color\":{\"red\":93,\"green\":79,\"blue\":49},\"web\":\"#5D4F31\",\"name\":\"West Coast\"},{\"color\":{\"red\":129,\"green\":120,\"blue\":92},\"web\":\"#81785C\",\"name\":\"Stonewall\"},{\"color\":{\"red\":42,\"green\":28,\"blue\":6},\"web\":\"#2A1C06\",\"name\":\"Cocoa Brown\"},{\"color\":{\"red\":40,\"green\":53,\"blue\":66},\"web\":\"#283542\",\"name\":\"Midnight\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (428,107,50,'107010','Madame de Pompadour',2,'https://www.nationalgalleries.org/object/NG 429','NG 429',NULL,'Jeanne Antoinette Poisson, Marquise de Pompadour, otherwise known as Madame de Pompadour, was the mistress of King Louis XV, as well as a prominent patron of Francois Boucher. Unlike the many other mistresses of the king, Madame de Pompadour continued to be a presence at the court by creating a cordial relationship with the Queen, by accompanying the King on hunting trips and social gatherings, and commissioning paintings of herself, which hid her aging looks. Although she did commission works from other artists, the majority of her portraits were done by Boucher.','Jeanne Antoinette Poisson, otherwise known as Madame de Pompadour, was the mistress of King Louis XV, as well as a prominent patron of Francois Boucher. Unlike the many other mistresses of the king, Madame de Pompadour continued to be a presence at the court by creating a cordial relationship with the Queen, by accompanying the King on hunting trips and social gatherings, and commissioning paintings of herself, which hid her aging looks.',1758,463,379,'Oil on canvas',1400.0000,1500.0000,'http://www.googleartproject.com/collection/national-galleries-of-scotland/artwork/madame-de-pompadour-jeanne-antoinette-poisson-1721-1764-attributed-to-francois-boucher/427538/',NULL,'http://en.wikipedia.org/wiki/Madame_de_Pompadour','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":45,\"green\":46,\"blue\":43},\"web\":\"#2D2E2B\",\"name\":\"Eternity\"},{\"color\":{\"red\":84,\"green\":121,\"blue\":151},\"web\":\"#547997\",\"name\":\"Kashmir Blue\"},{\"color\":{\"red\":55,\"green\":87,\"blue\":113},\"web\":\"#375771\",\"name\":\"Venice Blue\"},{\"color\":{\"red\":29,\"green\":56,\"blue\":77},\"web\":\"#1D384D\",\"name\":\"Nile Blue\"},{\"color\":{\"red\":134,\"green\":110,\"blue\":111},\"web\":\"#866e6f\",\"name\":\"Empress\"},{\"color\":{\"red\":219,\"green\":215,\"blue\":214},\"web\":\"#dbd7d6\",\"name\":\"Mercury\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (430,108,27,'108010','Still Life with Peaches, a Silver Goblet, Grapes, and Walnuts',2,'http://www.getty.edu/art/collection/objects/793/jean-simeon-chardin-still-life-with-peaches-a-silver-goblet-grapes-and-walnuts-french-about-1759-1760/','86.PA.544','Public domain','In still lifes, genre scenes, and the occasional portrait, Chardin\'s skill at rendering the visual and tactile qualities of simple objects won him the admiration of critics like Diderot. In this small still life, Chardin portrayed a modest subject--three walnuts, four peaches, two bunches of grapes, and a pewter mug--but gave the objects monumentality by arranging them in pure geometric groupings and concentrating on their basic forms. He suggested the objects\' various textures and substances through the play of light across surfaces and successive applications of paint. In this way, Chardin conveyed the fuzzy skin of the peaches, the hard, brittle shell of the walnuts, the translucence of the grapes, and the heavy, cold exterior of the pewter mug.',' In this small still life, Chardin portrayed a modest subject--three walnuts, four peaches, two bunches of grapes, and a pewter mug--but gave the objects monumentality by arranging them in pure geometric groupings and concentrating on their basic forms. He suggested the objects\' various textures and substances through the play of light across surfaces and successive applications of paint. In this way, Chardin conveyed the fuzzy skin of the peaches, the hard, brittle shell of the walnuts, the translucence of the grapes, and the heavy, cold exterior of the pewter mug.',1759,46,38,'Oil on canvas',500.0000,550.0000,'http://www.googleartproject.com/collection/the-j-paul-getty-museum/artwork/still-life-with-peaches-a-silver-goblet-grapes-and-walnuts-jean-simeon-chardin-french-1699-1779/2788394/',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":111,\"green\":67,\"blue\":55},\"web\":\"#6F4337\",\"name\":\"Metallic Copper\"},{\"color\":{\"red\":95,\"green\":79,\"blue\":61},\"web\":\"#5F4F3D\",\"name\":\"Rock\"},{\"color\":{\"red\":92,\"green\":48,\"blue\":39},\"web\":\"#5C3027\",\"name\":\"Redwood\"},{\"color\":{\"red\":71,\"green\":56,\"blue\":40},\"web\":\"#473828\",\"name\":\"Clinker\"},{\"color\":{\"red\":127,\"green\":110,\"blue\":88},\"web\":\"#7F6E58\",\"name\":\"Cement\"},{\"color\":{\"red\":138,\"green\":104,\"blue\":89},\"web\":\"#8A6859\",\"name\":\"Leather\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (431,109,17,'109010','Age of Innocence',1,'http://www.tate.org.uk/art/artworks/reynolds-the-age-of-innocence-n00307','N00307','Creative Commons CC-BY-NC-ND 3.0','The Age of Innocence is an oil on canvas picture by Sir Joshua Reynolds, painted in either 1785 or 1788 and measuring 765 x 638 mm. The sitter is unknown, but was possibly Reynolds\'s great-niece Theophila Gwatkin (who was three in 1785), or Lady Anne Spencer (1773-1865), the youngest daughter of the 4th Duke of Marlborough. The picture is a character study, or, in 18th-century terms, a fancy picture, and was painted over another Reynolds work, A Strawberry Girl, perhaps because Strawberry had suffered some paint losses. Only the hands remain in their original state. Innocence itself has deteriorated since 1859. The picture was presented to the National Gallery in 1847 by Robert Vernon, and has hung in the Tate since 1951. The picture became a favourite with the public, and was copied hundreds of times.','The Age of Innocence is an oil on canvas picture by Sir Joshua Reynolds, painted in either 1785 or 1788 and measuring 765 x 638 mm. The sitter is unknown, but was possibly Reynolds\'s great-niece Theophila Gwatkin (who was three in 1785), or Lady Anne Spencer (1773-1865), the youngest daughter of the 4th Duke of Marlborough.',1788,76,64,'Oil on canvas',700.0000,800.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Age_of_Innocence_(painting)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":58,\"green\":46,\"blue\":28},\"web\":\"#3A2E1C\",\"name\":\"Black Magic\"},{\"color\":{\"red\":206,\"green\":180,\"blue\":132},\"web\":\"#CEB484\",\"name\":\"Tan\"},{\"color\":{\"red\":94,\"green\":110,\"blue\":93},\"web\":\"#5E6E5D\",\"name\":\"Finlandia\"},{\"color\":{\"red\":40,\"green\":30,\"blue\":18},\"web\":\"#281E12\",\"name\":\"Cocoa Brown\"},{\"color\":{\"red\":91,\"green\":78,\"blue\":54},\"web\":\"#5B4E36\",\"name\":\"Punga\"},{\"color\":{\"red\":132,\"green\":123,\"blue\":95},\"web\":\"#847B5F\",\"name\":\"Olive Haze\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (432,109,17,'109020','Three Ladies Adorning a Term of Hymen',2,'http://www.tate.org.uk/art/artworks/reynolds-three-ladies-adorning-a-term-of-hymen-n00079','N00079','Creative Commons CC-BY-NC-ND 3.0','Shows the aristocratic Montgomery sisters: Barbara, Elizabeth and Anne. Their father was the Irish aristocrat Sir William Montgomery and they were known as the Irish Graces. They are shown gathering flowers to decorate a statue of Hymen, the Roman god of marriage.','Shows the aristocratic Montgomery sisters: Barbara, Elizabeth and Anne. Their father was the Irish aristocrat Sir William Montgomery and they were known as the Irish Graces. They are shown gathering flowers to decorate a statue of Hymen, the Roman god of marriage.',1773,233,290,'Oil on Canvas',1200.0000,1400.0000,NULL,NULL,'http://en.m.wikipedia.org/wiki/File:Sir_Joshua_Reynolds_-_Three_Ladies_Adorning_a_Term_of_Hymen_-_Google_Art_Project.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":67,\"green\":50,\"blue\":31},\"web\":\"#43321F\",\"name\":\"Clinker\"},{\"color\":{\"red\":116,\"green\":77,\"blue\":33},\"web\":\"#744D21\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":233,\"green\":225,\"blue\":218},\"web\":\"#E9E1DA\",\"name\":\"Spring Wood\"},{\"color\":{\"red\":75,\"green\":43,\"blue\":24},\"web\":\"#4B2B18\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":99,\"green\":80,\"blue\":56},\"web\":\"#635038\",\"name\":\"Dallas\"},{\"color\":{\"red\":133,\"green\":116,\"blue\":92},\"web\":\"#85745C\",\"name\":\"Cement\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (433,110,5,'110010','Mr and Mrs Andrews',4,'https://www.nationalgallery.org.uk/paintings/thomas-gainsborough-mr-and-mrs-andrews','NG6301','Creative Commons BY-NC-ND 4.0','Mr and Mrs Andrews is an oil on canvas portrait by Thomas Gainsborough in the National Gallery, London. Today it is one of his most famous works. Thomas Gainsborough was twenty-one when he painted Mr and Mrs Andrews in 1750.','Mr and Mrs Andrews is an oil on canvas portrait by Thomas Gainsborough in the National Gallery, London. Today it is one of his most famous works. Thomas Gainsborough was twenty-one when he painted Mr and Mrs Andrews in 1750.',1750,69,119,'Oil on Canvas',900.0000,1100.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Mr_and_Mrs_Andrews','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":131,\"green\":124,\"blue\":62},\"web\":\"#837C3E\",\"name\":\"Highball\"},{\"color\":{\"red\":145,\"green\":165,\"blue\":148},\"web\":\"#91A594\",\"name\":\"Envy\"},{\"color\":{\"red\":121,\"green\":121,\"blue\":95},\"web\":\"#79795F\",\"name\":\"Kokoda\"},{\"color\":{\"red\":156,\"green\":159,\"blue\":129},\"web\":\"#9C9F81\",\"name\":\"Locust\"},{\"color\":{\"red\":115,\"green\":120,\"blue\":106},\"web\":\"#73786A\",\"name\":\"Gunsmoke\"},{\"color\":{\"red\":94,\"green\":91,\"blue\":63},\"web\":\"#5E5B3F\",\"name\":\"Verdigris\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (435,110,5,'110030','Portrait of Mrs. Sarah Siddons',1,'https://www.nationalgallery.org.uk/paintings/thomas-gainsborough-mrs-siddons','NG683','Creative Commons BY-NC-ND 4.0','Sarah Siddons was the outstanding tragic actress of her time. Reynolds and other artists also painted her portrait. Gainsborough is reported to have had difficulties with the nose.','Sarah Siddons was the outstanding tragic actress of her time. Reynolds and other artists also painted her portrait. Gainsborough is reported to have had difficulties with the nose.',1785,126,100,'Oil on Canvas',700.0000,800.0000,NULL,NULL,'http://en.wikipedia.org/wiki/File:Thomas_Gainsborough_015.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":83,\"green\":44,\"blue\":28},\"web\":\"#532C1C\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":40,\"green\":22,\"blue\":23},\"web\":\"#281617\",\"name\":\"Rustic Red\"},{\"color\":{\"red\":114,\"green\":107,\"blue\":88},\"web\":\"#726b58\",\"name\":\"Peat\"},{\"color\":{\"red\":85,\"green\":96,\"blue\":108},\"web\":\"#55606c\",\"name\":\"Shuttle Grey\"},{\"color\":{\"red\":207,\"green\":192,\"blue\":157},\"web\":\"#cfc09d\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":228,\"green\":196,\"blue\":142},\"web\":\"#e4c48e\",\"name\":\"New Orleans\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (436,110,7,'110040','Mrs. Richard Brinsley Sheridan',1,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.99.html','1937.1.92','Open Access','Mrs. Richard Brinsley Sheridan is an oil on canvas portrait painted by Thomas Gainsborough between 1785 and 1787. It was acquired by the National Gallery of Art in 1937. Mrs. Sheridan (Elizabeth Ann Linley) was a talented musician who enjoyed professional success in Bath and London before marrying Richard Brinsley Sheridan in 1773 and abandoning her career. She was 31 when she sat for Gainsborough. She died from tuberculosis at the age of thirty-eight.','Mrs. Sheridan (Elizabeth Ann Linley) was a talented musician who enjoyed professional success in Bath and London before marrying Richard Brinsley Sheridan in 1773 and abandoning her career.',1787,219,153,'Oil on Canvas',550.0000,625.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Mrs._Richard_Brinsley_Sheridan_(painting)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":125,\"green\":122,\"blue\":97},\"web\":\"#7D7A61\",\"name\":\"Kokoda\"},{\"color\":{\"red\":160,\"green\":153,\"blue\":125},\"web\":\"#A0997D\",\"name\":\"Grey Olive\"},{\"color\":{\"red\":96,\"green\":87,\"blue\":63},\"web\":\"#60573F\",\"name\":\"Millbrook\"},{\"color\":{\"red\":185,\"green\":143,\"blue\":111},\"web\":\"#B98F6F\",\"name\":\"Fallow\"},{\"color\":{\"red\":206,\"green\":188,\"blue\":151},\"web\":\"#CEBC97\",\"name\":\"Sour Dough\"},{\"color\":{\"red\":113,\"green\":125,\"blue\":100},\"web\":\"#717D64\",\"name\":\"Camouflage Green\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (437,113,5,'113010','Self-portrait in a Straw Hat',1,'https://www.nationalgallery.org.uk/paintings/elisabeth-louise-vigee-le-brun-self-portrait-in-a-straw-hat','NG1653','Creative Commons BY-NC-ND 4.0','The painting appears, after cleaning, to be an autograph replica of a picture, the original of which was painted in Brussels in 1782 in free imitation of Rubens\'s \'Chapeau de Paille\', which Vigee Le Brun had seen in Antwerp. It was exhibited in Paris in 1782 at the Salon de la Correspondance. Vigee Le Brun\'s original is recorded in a private collection in France.','The painting appears, after cleaning, to be an autograph replica of a picture, the original of which was painted in Brussels in 1782 in free imitation of Rubens\'s \'Chapeau de Paille\', which Vigee Le Brun had seen in Antwerp. It was exhibited in Paris in 1782 at the Salon de la Correspondance. Vigee Le Brun\'s original is recorded in a private collection in France.',1782,98,71,'Oil on Canvas',700.0000,800.0000,NULL,NULL,'http://en.wikipedia.org/wiki/File:Self-portrait_in_a_Straw_Hat_by_Elisabeth-Louise_Vig%C3%A9e-Lebrun.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":115,\"green\":140,\"blue\":145},\"web\":\"#738c91\",\"name\":\"Gothic\"},{\"color\":{\"red\":30,\"green\":24,\"blue\":25},\"web\":\"#1e1819\",\"name\":\"Rustic Red\"},{\"color\":{\"red\":85,\"green\":88,\"blue\":85},\"web\":\"#555855\",\"name\":\"Nandor\"},{\"color\":{\"red\":60,\"green\":41,\"blue\":30},\"web\":\"#3c291e\",\"name\":\"Bistre\"},{\"color\":{\"red\":120,\"green\":97,\"blue\":67},\"web\":\"#786143\",\"name\":\"Yellow Metal\"},{\"color\":{\"red\":202,\"green\":188,\"blue\":163},\"web\":\"#cabca3\",\"name\":\"Soft Amber\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (438,112,32,'112010','The Proposition',1,'https://www.mauritshuis.nl/en/explore/the-collection/artworks/man-offering-money-to-a-young-woman-564','564','Private Use Only','The Proposition is a genre painting of 1631 by Judith Leyster, now in the Mauritshuis in The Hague, who title it Man offering money to a young woman. It depicts a woman, sewing by candlelight, as a man leans over her, touching her right shoulder with his left hand. He is offering her coins in her right hand, but she is apparently ignoring the offer and concentrating intently upon her sewing.','The Proposition is a genre painting of 1631 by Judith Leyster, now in the Mauritshuis in The Hague, who title it Man offering money to a young woma',1631,31,24,'Oil on Canvas',500.0000,600.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Proposition_(painting)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":69,\"green\":56,\"blue\":31},\"web\":\"#45381F\",\"name\":\"Mikado\"},{\"color\":{\"red\":156,\"green\":152,\"blue\":141},\"web\":\"#9C988D\",\"name\":\"Nomad\"},{\"color\":{\"red\":150,\"green\":112,\"blue\":73},\"web\":\"#967049\",\"name\":\"Pale Brown\"},{\"color\":{\"red\":122,\"green\":117,\"blue\":107},\"web\":\"#7A756B\",\"name\":\"Arrowtown\"},{\"color\":{\"red\":85,\"green\":86,\"blue\":76},\"web\":\"#55564C\",\"name\":\"Ship Grey\"},{\"color\":{\"red\":90,\"green\":77,\"blue\":56},\"web\":\"#5A4D38\",\"name\":\"Metallic Bronze\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (439,111,4,'111010','Judith Slaying Holofernes',1,'http://www.uffizi.firenze.it/catalogo/',NULL,'Public domain','Judith Slaying Holofernes is a painting by the Italian early Baroque artist Artemisia Gentileschi completed between 1611-12. The work shows an apocrypha scene from the Old Testament Book of Judith which details the delivery of Israel from the Assyrian general Holofernes. In this scene, Judith and her maidservant behead the general after he has fallen asleep drunk. The painting is relentlessly physical, from the wide spurts of blood to the energy of the two women as they try to wield the large dagger. The effort of the women\'s struggle is most finely represented by the delicate face of the maid, which is grasped by the oversized, muscular fist of Holofernes as he desperately struggles to survive. Although the painting depicts a classic scene from the Bible, Gentileschi drew herself as Judith and her mentor Agostino Tassi, who was tried in court for her rape, as Holofernes.','Judith Slaying Holofernes is a painting by the Italian early Baroque artist Artemisia Gentileschi completed between 1611-12. The work shows an apocrypha scene from the Old Testament Book of Judith which details the delivery of Israel from the Assyrian general Holofernes.',1611,159,126,'Oil on Canvas',700.0000,800.0000,'http://www.google.com/culturalinstitute/asset-viewer/judith-and-holofernes/oQF3gDEYNkutBA?projectId=art-project','This large painting signed by the artist was in Palazzo Pitti in 1638 and was tranferred to the Uffizi in 1774. In 1635 the Artist thanked Galileo Galilei for having helped her obtain payment, most likely for this painting for Cosimo III who was an empassioned collector of caravaggesque paintings. Artemisia Gentilleschi was in Florence from 1613 to 1620 and completed several paintings for the Medici Court.','https://commons.wikimedia.org/wiki/File:Artemisia_Gentileschi_-_Giuditta_decapita_Oloferne_-_Google_Art_Project.jpg','{\"safeSearchAnnotation\":{\"violence\":5,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":207,\"green\":149,\"blue\":68},\"web\":\"#CF9544\",\"name\":\"Anzac\"},{\"color\":{\"red\":159,\"green\":108,\"blue\":60},\"web\":\"#9F6C3C\",\"name\":\"Mai Tai\"},{\"color\":{\"red\":77,\"green\":41,\"blue\":22},\"web\":\"#4D2916\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":120,\"green\":74,\"blue\":33},\"web\":\"#784A21\",\"name\":\"Russet\"},{\"color\":{\"red\":196,\"green\":143,\"blue\":85},\"web\":\"#C48F55\",\"name\":\"Twine\"},{\"color\":{\"red\":227,\"green\":183,\"blue\":88},\"web\":\"#E3B758\",\"name\":\"Ronchi\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (441,114,4,'114020','Madonna Enthroned',1,'http://www.uffizi.firenze.it/catalogo/','1890, 8343','Public domain','Madonna Enthroned, also known as the Ognissanti Madonna, is a painting by the Italian late medieval artist Giotto di Bondone, housed in the Uffizi Gallery of Florence, Italy. It is generally dated to around 1310. The painting has a traditional Christian subject, representing the Virgin Mary and the Christ Child seated on her lap, with saints surrounding the two. It is celebrated often as the first painting of the Renaissance due to its newfound naturalism and escape from the constraints of Gothic art.','The painting has a traditional Christian subject, representing the Virgin Mary and the Christ Child seated on her lap, with saints surrounding the two. It is celebrated often as the first painting of the Renaissance due to its newfound naturalism and escape from the constraints of Gothic art.',1310,325,204,'Tempura on Wood',1500.0000,2000.0000,'https://www.google.com/culturalinstitute/beta/asset/the-ognissanti-madonna/OgE-RDjvff-y6g','The panel from 1306-10, ca. was originally placed on the old partition wall of the church of Ognissanti, officiated by the Umiliati friars before it was moved to their convent, at least by the end of the 17th century. In 1810, following the French suppression of convents, it was placed in the Accademia. It has been in the Uffizi since 1919.','https://en.wikipedia.org/wiki/Ognissanti_Madonna','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":19,\"green\":18,\"blue\":20},\"web\":\"#131214\",\"name\":\"Blackcurrant\"},{\"color\":{\"red\":207,\"green\":152,\"blue\":64},\"web\":\"#CF9840\",\"name\":\"Anzac\"},{\"color\":{\"red\":116,\"green\":69,\"blue\":19},\"web\":\"#744513\",\"name\":\"Raw Umber\"},{\"color\":{\"red\":153,\"green\":142,\"blue\":168},\"web\":\"#998EA8\",\"name\":\"Cold Purple\"},{\"color\":{\"red\":92,\"green\":47,\"blue\":4},\"web\":\"#5C2F04\",\"name\":\"Baker\'s Chocolate\"},{\"color\":{\"red\":196,\"green\":156,\"blue\":67},\"web\":\"#C49C43\",\"name\":\"Roti\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (442,115,5,'115010','Arnolfini Portrait',1,'https://www.nationalgallery.org.uk/paintings/jan-van-eyck-the-arnolfini-portrait','NG186','Creative Commons BY-NC-ND 4.0','The Arnolfini Portrait is an oil painting on oak panel dated 1434 by the Early Netherlandish painter Jan van Eyck. The painting is a small full-length double portrait, which is believed to represent the Italian merchant Giovanni di Nicolao Arnolfini and possibly his wife, presumably in their home in the Flemish city of Bruges. It is considered one of the more original and complex paintings in Western art because of the iconography, the unusual geometric orthogonal perspective, the use of the mirror to reflect the space, and that the portrait is considered unique by some art historians as the record of a marriage contract in the form of a painting.','The painting is a small full-length double portrait, which is believed to represent the Italian merchant Giovanni di Nicolao Arnolfini and possibly his wife, presumably in their home in the Flemish city of Bruges.',1434,82,62,'Oil on oak panel',900.0000,1100.0000,NULL,NULL,'http://en.wikipedia.org/wiki/The_Arnolfini_Portrait','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":39,\"green\":51,\"blue\":13},\"web\":\"#27330D\",\"name\":\"Pine Tree\"},{\"color\":{\"red\":50,\"green\":42,\"blue\":36},\"web\":\"#322A24\",\"name\":\"Coffee Bean\"},{\"color\":{\"red\":72,\"green\":36,\"blue\":29},\"web\":\"#48241D\",\"name\":\"Brown Pod\"},{\"color\":{\"red\":46,\"green\":62,\"blue\":9},\"web\":\"#2E3E09\",\"name\":\"Turtle Green\"},{\"color\":{\"red\":36,\"green\":31,\"blue\":14},\"web\":\"#241F0E\",\"name\":\"Maire\"},{\"color\":{\"red\":91,\"green\":78,\"blue\":56},\"web\":\"#5B4E38\",\"name\":\"Metallic Bronze\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (443,116,16,'116010','Portrait of the Artist Holding a Thistle',1,'http://www.louvre.fr/en/oeuvre-notices/self-portrait-or-portrait-artist-holding-thistle','R.F. 2382','&copy; Musee du Louvre','Portrait of the Artist Holding a Thistle is an oil painting on parchment pasted on canvas by German artist Albrecht Durer, painted in 1493. It is the earliest of Durer\'s painted self-portraits and has been identified as one of the first self-portraits painted by a Northern artist. The date, and the plant in the artist\'s hand, seem to suggest that this is a betrothal portrait.','It is the earliest of Durer\'s painted self-portraits and has been identified as one of the first self-portraits painted by a Northern artist.',1493,57,44,'Oil on Wood',600.0000,675.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Portrait_of_the_Artist_Holding_a_Thistle_(Albrecht_D%C3%BCrer)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":62,\"green\":50,\"blue\":30},\"web\":\"#3E321E\",\"name\":\"Mikado\"},{\"color\":{\"red\":118,\"green\":74,\"blue\":26},\"web\":\"#764A1A\",\"name\":\"Raw Umber\"},{\"color\":{\"red\":212,\"green\":183,\"blue\":128},\"web\":\"#D4B780\",\"name\":\"Straw\"},{\"color\":{\"red\":96,\"green\":80,\"blue\":55},\"web\":\"#605037\",\"name\":\"Metallic Bronze\"},{\"color\":{\"red\":79,\"green\":43,\"blue\":26},\"web\":\"#4F2B1A\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":151,\"green\":51,\"blue\":23},\"web\":\"#973317\",\"name\":\"Burnt Ummber\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (445,117,2,'117010','The Garden of Earthly Delights',2,'https://www.museodelprado.es/en/the-collection/art-work/the-garden-of-earthly-delights-triptych/02388242-6d6a-4e9e-a992-e1311eab3609','P02823','Private, personal, academic, research or educational','The Garden of Earthly Delights is the modern title given to a triptych painted by the Early Netherlandish master Hieronymus Bosch. It has been housed in the Museo del Prado in Madrid since 1939. Dating from between 1490 and 1510, when Bosch was between about 40 and 60 years old, it is his best-known and most ambitious complete work. It reveals the artist at the height of his powers; in no other painting does he achieve such complexity of meaning or such vivid imagery.','It is his best-known and most ambitious complete work. It reveals the artist at the height of his powers; in no other painting does he achieve such complexity of meaning or such vivid imagery.',1490,220,390,'Oil on panel',1400.0000,1600.0000,'https://www.google.com/culturalinstitute/beta/asset/the-garden-of-earthly-delights/EwHP5mUuUOzqVg',NULL,'http://en.wikipedia.org/wiki/The_Garden_of_Earthly_Delights','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":147,\"green\":135,\"blue\":76},\"web\":\"#93874c\",\"name\":\"Highball\"},{\"color\":{\"red\":207,\"green\":191,\"blue\":169},\"web\":\"#cfbfa9\",\"name\":\"Soft Amber\"},{\"color\":{\"red\":177,\"green\":145,\"blue\":109},\"web\":\"#b1916d\",\"name\":\"Mongoose\"},{\"color\":{\"red\":145,\"green\":165,\"blue\":165},\"web\":\"#91a5a5\",\"name\":\"Submarine\"},{\"color\":{\"red\":154,\"green\":100,\"blue\":74},\"web\":\"#9a644a\",\"name\":\"Dark Tan\"},{\"color\":{\"red\":79,\"green\":110,\"blue\":120},\"web\":\"#4f6e78\",\"name\":\"Bismark\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (448,118,18,'118030','The Peasant Wedding',2,'https://www.khm.at/de/object/fe73f687e5/','1027','Only for private use','The Peasant Wedding is a 1567 painting by the Flemish Renaissance painter and printmaker Pieter Bruegel the Elder, one of his many depicting peasant life. It is currently housed in the Kunsthistorisches Museum, Vienna.','The Peasant Wedding is a 1567 painting by the Flemish Renaissance painter and printmaker Pieter Bruegel the Elder, one of his many depicting peasant life. It is currently housed in the Kunsthistorisches Museum, Vienna.',1567,124,164,'Oil on Panel',500.0000,600.0000,'http://www.google.com/culturalinstitute/asset-viewer/peasant-wedding/hgGvote2WI8P3w?projectId=art-project',NULL,'http://en.wikipedia.org/wiki/The_Peasant_Wedding','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":65,\"green\":49,\"blue\":26},\"web\":\"#41311A\",\"name\":\"Clinker\"},{\"color\":{\"red\":23,\"green\":15,\"blue\":13},\"web\":\"#170F0D\",\"name\":\"Seal Brown\"},{\"color\":{\"red\":143,\"green\":117,\"blue\":62},\"web\":\"#8F753E\",\"name\":\"Corn Harvest\"},{\"color\":{\"red\":201,\"green\":195,\"blue\":189},\"web\":\"#C9C3BD\",\"name\":\"Stark White\"},{\"color\":{\"red\":143,\"green\":65,\"blue\":43},\"web\":\"#8f412b\",\"name\":\"Fire\"},{\"color\":{\"red\":147,\"green\":162,\"blue\":164},\"web\":\"#93a2a4\",\"name\":\"Submarine\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (450,120,4,'120010','Portrait of Eleanor of Toledo',1,'http://www.uffizi.firenze.it/catalogo/','1890, 748','Public domain','The Portrait of Eleanor of Toledo and Her Son is a painting by the Italian artist Agnolo di Cosimo, known as Bronzino, finished ca. 1545. One of his most famous works, it is housed in the Uffizi Gallery of Florence, Italy and is considered one of the preeminent examples of Mannerist portraiture. The painting depicts Eleanor of Toledo, the wife of Cosimo I de\' Medici, Grand Duke of Tuscany, sitting with her hand resting on the shoulder of one of her sons. This gesture, as well as the pomegranate motif on her dress, referred to her role as mother. Eleanor wears a heavily brocaded dress with black arabesques. In this pose, she is depicted as the ideal woman of the Renaissance.','The painting depicts Eleanor of Toledo, the wife of Cosimo I de\' Medici, Grand Duke of Tuscany, sitting with her hand resting on the shoulder of one of her sons.',1545,115,96,'Oil on Panel',675.0000,850.0000,'https://www.google.com/culturalinstitute/beta/asset/portrait-of-eleonora-di-toledo-with-her-son-giovanni/QAEccCsLDtbB4A','This precious painting, documented by Vasari, depicts the Dutchess of Florence, Eleonora di Toledo, with her little son Giovanni. It was painted in 1545 by Bronzino, who was a student of Pontormo and the court portrait artist of the Medici. In spite of the official nature of the portrait, seen through the very refined clothing and the splendor of the jewelry, Bronzino joins the figures of the mother and child in an affectionate pose creating one of the masterpieces of European Portraiture of the 16th century. The painting has been in the Tribune since 1620.','http://en.wikipedia.org/wiki/Portrait_of_Eleanor_of_Toledo','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":38,\"green\":48,\"blue\":97},\"web\":\"#263061\",\"name\":\"Lucky Point\"},{\"color\":{\"red\":22,\"green\":17,\"blue\":18},\"web\":\"#161112\",\"name\":\"Rustic Red\"},{\"color\":{\"red\":116,\"green\":106,\"blue\":83},\"web\":\"#746a53\",\"name\":\"Coffee\"},{\"color\":{\"red\":61,\"green\":75,\"blue\":130},\"web\":\"#3D4B82\",\"name\":\"Tory Blue\"},{\"color\":{\"red\":177,\"green\":150,\"blue\":113},\"web\":\"#b19671\",\"name\":\"Sandrift\"},{\"color\":{\"red\":99,\"green\":74,\"blue\":35},\"web\":\"#634a23\",\"name\":\"Dark Brown\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (451,120,5,'120020','Venus, Cupid, Folly and Time',1,'https://www.nationalgallery.org.uk/paintings/bronzino-an-allegory-with-venus-and-cupid','NG651','Creative Commons BY-NC-ND 4.0','Venus, Cupid, Folly, and Time is an allegorical painting by the Florentine artist Agnolo Bronzino. It is now in the National Gallery, London.','Venus, Cupid, Folly, and Time is an allegorical painting by the Florentine artist Agnolo Bronzino. It is now in the National Gallery, London.',1545,146,116,'Oil on Wood',800.0000,900.0000,NULL,NULL,'http://en.wikipedia.org/wiki/Venus,_Cupid,_Folly,_and_Time','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":5},\"dominantColors\":[{\"color\":{\"red\":215,\"green\":191,\"blue\":163},\"web\":\"#D7BFA3\",\"name\":\"Soft Amber\"},{\"color\":{\"red\":63,\"green\":50,\"blue\":28},\"web\":\"#3F321C\",\"name\":\"Mikado\"},{\"color\":{\"red\":25,\"green\":18,\"blue\":14},\"web\":\"#19120E\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":39,\"green\":45,\"blue\":71},\"web\":\"#272d47\",\"name\":\"Lucky Point\"},{\"color\":{\"red\":177,\"green\":108,\"blue\":108},\"web\":\"#b16c6c\",\"name\":\"Coral Tree\"},{\"color\":{\"red\":159,\"green\":151,\"blue\":154},\"web\":\"#9f979a\",\"name\":\"Shady Lady\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (453,121,6,'121020','View of Toledo',1,'http://www.metmuseum.org/art/collection/search/436575','29.100.6','Open Access for Scholarly Content','View of Toledo, is one of the two surviving landscapes painted by El Greco. The other, called View and Plan of Toledo lies at Museo Del Greco, Toledo, Spain. Along with Vincent van Gogh\'s The Starry Night, some landscapes by William Turner, and some works by Monet, it is among the best known depictions of the sky in Western art, and features sharp color contrast between the sky and the hills below. Painted in a Mannerist (or Baroque) style, the work takes liberties with the actual layout of Toledo (some buildings are depicted in different positions than their actual location, but truthfully depicts on the side the Castle of San Servando).','View of Toledo, is one of the two surviving landscapes painted by El Greco. ',1600,121,108,'Oil on canvas',700.0000,800.0000,'http://www.google.com/culturalinstitute/asset-viewer/view-of-toledo/LQEbD5GpU4Q65Q?projectId=art-project',NULL,'http://en.wikipedia.org/wiki/View_of_Toledo','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":44,\"green\":54,\"blue\":50},\"web\":\"#2C3632\",\"name\":\"Woodsmoke\"},{\"color\":{\"red\":74,\"green\":85,\"blue\":55},\"web\":\"#4A5537\",\"name\":\"Clover\"},{\"color\":{\"red\":72,\"green\":84,\"blue\":82},\"web\":\"#485452\",\"name\":\"Dark Slate\"},{\"color\":{\"red\":38,\"green\":63,\"blue\":62},\"web\":\"#263F3E\",\"name\":\"Tiber\"},{\"color\":{\"red\":60,\"green\":88,\"blue\":87},\"web\":\"#3C5857\",\"name\":\"Oracle\"},{\"color\":{\"red\":26,\"green\":33,\"blue\":30},\"web\":\"#1A211E\",\"name\":\"Cardin Green\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (455,123,30,'123010','Portrait of a Couple, Probably Isaac Abrahamsz Massa and Beatrix van der Laen',2,'http://hdl.handle.net/10934/RM0001.COLLECT.8608','SK-A-133','Public domain','This happy, smiling pair sits comfortably close to each other. Posing a couple together in this way was highly unusual at the time. It may have been prompted by the sitters\' friendship with the painter and the occasion for the commission of their marriage in April 1622. The painting thus contains references to love and devotion, such as the garden of love at right, and at left an eryngium thistle.','This happy, smiling pair sits comfortably close to each other. Posing a couple together in this way was highly unusual at the time. It may have been prompted by the sitters\' friendship with the painter and the occasion for the commission of their marriage in April 1622. The painting thus contains references to love and devotion, such as the garden of love at right, and at left an eryngium thistle.',1622,140,166,'Oil on canvas',700.0000,900.0000,NULL,'This is probably the marriage portrait of Isaac Abrahamsz Massa and Beatrix van der Laen, c. 1622. The Haarlem merchant Isaac Massa (1586-1643) and Beatrix van der Laen (1592-1639), the daughter of a former burgomaster, had their portraits painted on the occasion of their marriage, 25 April 1622. Her wedding-ring, worn on the right index finger, according to the custom of the day, is prominently displayed. Frans Hals has incorporated various symbols of love into the painting. For example, the spear thistle on the left is also known as \'man\'s fidelity\'. The ivy at the bride\'s feet also signifies faithfulness: the woman clings to her husband just as ivy clings to a wall. The vine twisting itself around the tree has a similar connotation.','https://en.wikipedia.org/wiki/Marriage_Portrait_of_Isaac_Massa_and_Beatrix_van_der_Laen','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":28,\"green\":27,\"blue\":22},\"web\":\"#1C1B16\",\"name\":\"Maire\"},{\"color\":{\"red\":54,\"green\":51,\"blue\":31},\"web\":\"#36331F\",\"name\":\"Graphite\"},{\"color\":{\"red\":159,\"green\":162,\"blue\":154},\"web\":\"#9FA29A\",\"name\":\"Delta\"},{\"color\":{\"red\":86,\"green\":82,\"blue\":57},\"web\":\"#565239\",\"name\":\"Panda\"},{\"color\":{\"red\":105,\"green\":114,\"blue\":116},\"web\":\"#697274\",\"name\":\"Pale Sky\"},{\"color\":{\"red\":121,\"green\":118,\"blue\":92},\"web\":\"#79765C\",\"name\":\"Kokoda\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (456,123,30,'123020','Portrait of Feyntje van Steenkiste',1,'http://hdl.handle.net/10934/RM0001.COLLECT.8611','SK-C-557','Public domain','This pendant portrays the wife of Lucas de Clercq. Spouses were customarily depicted separately, the husband on the left and the wife on the right, both turned towards each other. The light almost always came from the left, illuminating the face of the woman evenly, and casting striking shadows on that of the man. Hals portrayed the woman - as was usual - in a more static pose than that of the man.','This pendant portrays the wife of Lucas de Clercq. Spouses were customarily depicted separately, the husband on the left and the wife on the right, both turned towards each other. The light almost always came from the left, illuminating the face of the woman evenly, and casting striking shadows on that of the man. Hals portrayed the woman - as was usual - in a more static pose than that of the man.',1635,123,93,'Oil on canvas',700.0000,800.0000,NULL,NULL,'https://en.wikipedia.org/wiki/Feyntje_Steenkiste','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":84,\"green\":75,\"blue\":40},\"web\":\"#544B28\",\"name\":\"Bronze Olive\"},{\"color\":{\"red\":19,\"green\":18,\"blue\":18},\"web\":\"#131212\",\"name\":\"Seal Brown\"},{\"color\":{\"red\":206,\"green\":199,\"blue\":172},\"web\":\"#CEC7AC\",\"name\":\"Parchment\"},{\"color\":{\"red\":98,\"green\":87,\"blue\":40},\"web\":\"#625728\",\"name\":\"Costa Del Sol\"},{\"color\":{\"red\":184,\"green\":150,\"blue\":96},\"web\":\"#b89660\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":122,\"green\":109,\"blue\":59},\"web\":\"#7A6D3B\",\"name\":\"Yellow Metal\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (457,123,30,'123030','Portrait of Lucas de Clercq',1,'http://hdl.handle.net/10934/RM0001.COLLECT.8612','SK-C-556','Public domain','Frans Hals, like no other, was able to bring his sitters to life. In this portrait, the Haarlem merchant Lucas de Clercq is shown with his left arm akimbo and his right arm resting on his stomach. Even though his hands are hidden and still, his vitality is expressed in the animated contour of his body and his slightly turned head.',' In this portrait, the Haarlem merchant Lucas de Clercq is shown with his left arm akimbo and his right arm resting on his stomach.',1635,126,93,'Oil on canvas',700.0000,800.0000,'https://www.google.com/culturalinstitute/beta/asset/portrait-of-lucas-de-clercq/CwGkOpgoJLk5cQ',NULL,'https://commons.wikimedia.org/wiki/File:Frans_Hals_-_Lucas_de_Clercq_-_WGA11125.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":84,\"green\":75,\"blue\":40},\"web\":\"#544B28\",\"name\":\"Bronze Olive\"},{\"color\":{\"red\":19,\"green\":18,\"blue\":18},\"web\":\"#131212\",\"name\":\"Seal Brown\"},{\"color\":{\"red\":206,\"green\":199,\"blue\":172},\"web\":\"#CEC7AC\",\"name\":\"Parchment\"},{\"color\":{\"red\":98,\"green\":87,\"blue\":40},\"web\":\"#625728\",\"name\":\"Costa Del Sol\"},{\"color\":{\"red\":184,\"green\":150,\"blue\":96},\"web\":\"#b89660\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":122,\"green\":109,\"blue\":59},\"web\":\"#7A6D3B\",\"name\":\"Yellow Metal\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (458,123,30,'123040','Portrait of Maritge Claesdr Vooght',1,'http://hdl.handle.net/10934/RM0001.COLLECT.8688','SK-C-139','Public domain','Frans Hals painted a large number of superb likenesses of members of Haarlem\'s upper class: he clearly knew how to satisfy the demands of his eminent patrons. Maritge Vooght, wife of the mayor Pieter Olycan, is here portrayed in a traditional pose, proudly sitting upright and looking straight out at the viewer. Hals noted her age, 62, at left. Her coat of arms was added later by a different hand.','Maritge Vooght, wife of the mayor Pieter Olycan, is here portrayed in a traditional pose, proudly sitting upright and looking straight out at the viewer.',1639,128,94,'Oil on canvas',700.0000,800.0000,NULL,NULL,'https://en.wikipedia.org/wiki/Maritge_Claesdr._Voogt','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":84,\"green\":75,\"blue\":40},\"web\":\"#544B28\",\"name\":\"Bronze Olive\"},{\"color\":{\"red\":19,\"green\":18,\"blue\":18},\"web\":\"#131212\",\"name\":\"Seal Brown\"},{\"color\":{\"red\":206,\"green\":199,\"blue\":172},\"web\":\"#CEC7AC\",\"name\":\"Parchment\"},{\"color\":{\"red\":98,\"green\":87,\"blue\":40},\"web\":\"#625728\",\"name\":\"Costa Del Sol\"},{\"color\":{\"red\":184,\"green\":150,\"blue\":96},\"web\":\"#b89660\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":122,\"green\":109,\"blue\":59},\"web\":\"#7A6D3B\",\"name\":\"Yellow Metal\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (459,123,30,'123050','Portrait of a Woman',3,'http://hdl.handle.net/10934/RM0001.COLLECT.8607','SK-A-1247','Public domain','Compared with the dynamic Portrait of a Man, this one of his wife makes a somewhat more formal impression. The pose is traditional, with the upper torso turned slightly to the left. She looks straight at the viewer, her lips slightly parted as though she is about to speak. Her face is rendered in much thinner paint than that of her husband, beautifully suggesting the greater softness of a woman\'s skin.','Compared with the dynamic Portrait of a Man, this one of his wife makes a somewhat more formal impression. The pose is traditional, with the upper torso turned slightly to the left. She looks straight at the viewer, her lips slightly parted as though she is about to speak. ',1635,79,66,'Oil on canvas',700.0000,800.0000,'https://www.google.com/culturalinstitute/beta/asset/portrait-of-a-woman/XwGjG4Da87WLzQ',NULL,'https://en.wikipedia.org/wiki/Sara_Wolphaerts_van_Diemen','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":72,\"green\":58,\"blue\":35},\"web\":\"#483A23\",\"name\":\"Clinker\"},{\"color\":{\"red\":27,\"green\":24,\"blue\":17},\"web\":\"#1B1811\",\"name\":\"Maire\"},{\"color\":{\"red\":158,\"green\":151,\"blue\":140},\"web\":\"#9E978C\",\"name\":\"Napa\"},{\"color\":{\"red\":126,\"green\":120,\"blue\":109},\"web\":\"#7E786D\",\"name\":\"Arrowtown\"},{\"color\":{\"red\":50,\"green\":47,\"blue\":38},\"web\":\"#322F26\",\"name\":\"Graphite\"},{\"color\":{\"red\":131,\"green\":119,\"blue\":97},\"web\":\"#837761\",\"name\":\"Stonewall\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (460,123,30,'123060','A Militiaman Holding a Berkemeyer',3,'http://hdl.handle.net/10934/RM0001.COLLECT.8609','SK-A-135','Public domain','This militiaman merrily raises his glass to toast us - who would not wish to join him? The execution is just as free and easy as the sitter himself: the swift, spontaneously applied brushstrokes enhance the portrait\'s sense of liveliness and animation. The man actually seems to be moving. This bravura painting style ensured the continued success of Frans Hals.','This militiaman merrily raises his glass to toast us - who would not wish to join him? The execution is just as free and easy as the sitter himself: the swift, spontaneously applied brushstrokes enhance the portrait\'s sense of liveliness and animation. The man actually seems to be moving. This bravura painting style ensured the continued success of Frans Hals.',1629,81,66,'Oil on canvas',800.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/a-militiaman-holding-a-berkemeyer-known-as-the-merry-drinker/EgGWR2aHD9M7aA','This cheery young man is raising his glass as if to propose a toast. Although the fashion was then for intricate, detailed paintings, Hals applied his paints with quick, confident strokes. This style of painting gives the subject a real sense of movement. This is most obvious with the right hand.',NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":97,\"green\":86,\"blue\":58},\"web\":\"#61563A\",\"name\":\"West Coast\"},{\"color\":{\"red\":142,\"green\":117,\"blue\":63},\"web\":\"#8E753F\",\"name\":\"Shadow\"},{\"color\":{\"red\":31,\"green\":31,\"blue\":25},\"web\":\"#1F1F19\",\"name\":\"Maire\"},{\"color\":{\"red\":62,\"green\":52,\"blue\":29},\"web\":\"#3E341D\",\"name\":\"Mikado\"},{\"color\":{\"red\":127,\"green\":113,\"blue\":80},\"web\":\"#7F7150\",\"name\":\"Shadow\"},{\"color\":{\"red\":170,\"green\":155,\"blue\":115},\"web\":\"#AA9B73\",\"name\":\"Tallow\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (461,123,30,'123070','Militia Company of District XI',4,'http://hdl.handle.net/10934/RM0001.COLLECT.8613','SK-C-374','Public domain','A commission for a civic guard portrait was rarely granted to a painter from outside the city. Quite exceptionally, Frans Hals - from Haarlem - was asked to paint this group portrait. However, he soon found himself at odds with the guardsmen, and the Amsterdam painter Pieter Codde had to step in to finish the seven figures on the right. Known for his small-scale, very smoothly and finely executed works, Codde nevertheless imitated Hals\'s loose style as best he could.','A commission for a civic guard portrait was rarely granted to a painter from outside the city. Quite exceptionally, Frans Hals - from Haarlem - was asked to paint this group portrait. However, he soon found himself at odds with the guardsmen.',1637,429,209,'Oil on canvas',1000.0000,1400.0000,'https://www.google.com/culturalinstitute/beta/asset/militia-company-of-district-xi-under-the-command-of-captain-reynier-reael-known-as-the-meagre-company/hAEZoaxqjpODHg',NULL,'https://en.wikipedia.org/wiki/Meagre_Company','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":32,\"green\":23,\"blue\":19},\"web\":\"#201713\",\"name\":\"Wood Bark\"},{\"color\":{\"red\":141,\"green\":116,\"blue\":72},\"web\":\"#8d7448\",\"name\":\"Shadow\"},{\"color\":{\"red\":200,\"green\":194,\"blue\":183},\"web\":\"#c8c2b7\",\"name\":\"Cloud\"},{\"color\":{\"red\":180,\"green\":128,\"blue\":50},\"web\":\"#b48032\",\"name\":\"Mandalay\"},{\"color\":{\"red\":169,\"green\":185,\"blue\":190},\"web\":\"#a9b9be\",\"name\":\"Casper\"},{\"color\":{\"red\":142,\"green\":102,\"blue\":43},\"web\":\"#8e662b\",\"name\":\"Rusty Nail\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (462,124,30,'124010','Self-portrait',3,'http://hdl.handle.net/10934/RM0001.COLLECT.378037','SK-A-383','Public domain','A distinguished citizen dressed in decorous black is seated before a red curtain and tassel. Jan Steen, known primarily for his humorous scenes with simple folk, portrayed himself here as utterly self-assured. He also regularly included himself in other paintings, but then usually in a comic role.','Jan Steen, known primarily for his humorous scenes with simple folk, portrayed himself here as utterly self-assured.',1670,73,62,'Oil on canvas',700.0000,800.0000,NULL,NULL,'https://commons.wikimedia.org/wiki/File:1670_Jan_Havicksz._Steen_-_zelfportret.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":24,\"green\":22,\"blue\":16},\"web\":\"#181610\",\"name\":\"Maire\"},{\"color\":{\"red\":55,\"green\":45,\"blue\":26},\"web\":\"#372D1A\",\"name\":\"Black Magic\"},{\"color\":{\"red\":132,\"green\":116,\"blue\":83},\"web\":\"#847453\",\"name\":\"Shadow\"},{\"color\":{\"red\":168,\"green\":148,\"blue\":95},\"web\":\"#A8945F\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":75,\"green\":41,\"blue\":19},\"web\":\"#4B2913\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":84,\"green\":45,\"blue\":20},\"web\":\"#542d14\",\"name\":\"Baker\'s Chocolate\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (463,124,30,'124020','The Merry Family',1,'http://hdl.handle.net/10934/RM0001.COLLECT.5577','SK-C-229','Public domain','This boisterous family is making a lot of noise: the father sings at the top of his lungs while raising a glass; the mother and grandmother chime in; and the children are either blowing into a wind instrument or smoking a long pipe. The note hanging from the mantelpiece gives away the moral of the story: \"As the old sing, so shall the young twitter.\" What will become of the children if their parents set the wrong example?','This boisterous family is making a lot of noise: the father sings at the top of his lungs while raising a glass; the mother and grandmother chime in; and the children are either blowing into a wind instrument or smoking a long pipe. The note hanging from the mantelpiece gives away the moral of the story: \"As the old sing, so shall the young twitter.\" What will become of the children if their parents set the wrong example?',1668,110,141,'Oil on canvas',800.0000,1000.0000,'https://www.google.com/culturalinstitute/beta/asset/PgG66BfO4KGbiA','The household depicted here is a cheerful madhouse. Old and young are enjoying themselves to the hilt: the mother and grand - mother have broken into song, the children are making music or smoking, while the father raises his glass. The younger children follow his example. The note on the\r\nmantel-piece says it all: \'So father, so son.\' Steen\'s composition illustrated this old saying, making it clear that bad examples are quickly followed. Jan Steen is perhaps best known for his scenes taken from everyday life: families gathered around the table, people drinking in a tavern. At first glance they are amusing, but there is often a subtle reference or hidden message tucked away somewhere in a text. Steen was a good storyteller with a gift for staging, and he knew how to capture the mood of a piece.','https://en.wikipedia.org/wiki/Jan_Steen#/media/File:Jan_Havicksz._Steen_-_Het_vrolijke_huisgezin_-_Google_Art_Project.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":66,\"green\":52,\"blue\":30},\"web\":\"#42341E\",\"name\":\"Mikado\"},{\"color\":{\"red\":93,\"green\":75,\"blue\":50},\"web\":\"#5D4B32\",\"name\":\"Dallas\"},{\"color\":{\"red\":132,\"green\":117,\"blue\":90},\"web\":\"#84755A\",\"name\":\"Stonewall\"},{\"color\":{\"red\":169,\"green\":153,\"blue\":123},\"web\":\"#A9997B\",\"name\":\"Bronco\"},{\"color\":{\"red\":127,\"green\":75,\"blue\":39},\"web\":\"#7f4b27\",\"name\":\"Korma\"},{\"color\":{\"red\":52,\"green\":45,\"blue\":36},\"web\":\"#342D24\",\"name\":\"Black Magic\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (464,124,30,'124030','The Feast of St Nicholas',1,'http://hdl.handle.net/10934/RM0001.COLLECT.5500','SK-A-385','Public domain','The feast of St Nicholas takes place in December. In the Netherlands, it has been celebrated in the same way for centuries. Good children receive gifts from the saint. The little girl in the foreground, for instance, has a bucket full of treats. Naughty children, like the wailing boy at the left, get only a switch (a bundle of twigs) in their shoe. Jan Steen was a born storyteller. He succeeded in incorporating all of the elements of the popular feast in this picture.','Good children receive gifts from the saint. The little girl in the foreground, for instance, has a bucket full of treats. Naughty children, like the wailing boy at the left, get only a switch (a bundle of twigs) in their shoe.',1666,82,70,'Oil on canvas',700.0000,800.0000,'https://www.google.com/culturalinstitute/beta/asset/HQH272DWHOl8aA','It is the fifth of December: the feast of St. Nicholas. Next to the chimney, traditional carols are being sung. The holy man has just arrived with presents for the children: a doll and a bucket full of candy for the girl, and for her little brother a golf club. The boy is pointing gleefully at his big brother, who has found a birch rod in his shoe instead of a present (indicating he has been a naughty boy). But grandmother is beckoning to him: no doubt there is a present for him after all, behind the curtain. Steen has succeeded in capturing the special atmosphere of this celebration. Considerable attention is given to all the goodies in the foreground: \'speculaas\', waffles, and a diamond-shaped sweet loaf called a \'duivekater\'. But the story is the main focus of the painting. And, like the born storyteller he is, Steen uses looks and gestures to make this clear.','https://en.wikipedia.org/wiki/The_Feast_of_Saint_Nicholas','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":40,\"green\":29,\"blue\":15},\"web\":\"#281D0F\",\"name\":\"Cocoa Brown\"},{\"color\":{\"red\":92,\"green\":81,\"blue\":59},\"web\":\"#5C513B\",\"name\":\"Mondo\"},{\"color\":{\"red\":125,\"green\":116,\"blue\":93},\"web\":\"#7D745D\",\"name\":\"Pablo\"},{\"color\":{\"red\":106,\"green\":52,\"blue\":25},\"web\":\"#6a3419\",\"name\":\"New Amber\"},{\"color\":{\"red\":114,\"green\":80,\"blue\":42},\"web\":\"#72502a\",\"name\":\"Cafe Royale\"},{\"color\":{\"red\":57,\"green\":45,\"blue\":28},\"web\":\"#392D1C\",\"name\":\"Black Magic\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (465,124,30,'124040','Children Teaching a Cat to Dance',1,'http://hdl.handle.net/10934/RM0001.COLLECT.5502','SK-A-718','Public domain','There is mischief-making going on here! A group of children are teaching a cat to dance, to the music of a shawm, a 17th-century wind instrument. They are clearly enjoying themselves, but the cat is screeching its displeasure, and the dog is barking loudly. An old man angrily reprimands the children from a window high in the wall of the room. Jan Steen knew how to reproduce the ear splitting din of the scene.','These children are up to mischief: they are teaching a cat to dance to the music of a shawm, a 17th-century wind instrument.',1670,68,59,'Oil on panel',700.0000,800.0000,'https://www.google.com/culturalinstitute/beta/asset/children-teaching-a-cat-to-dance-known-as-the-dancing-lesson/sAFdhRy2KCBhPA',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":62,\"green\":46,\"blue\":27},\"web\":\"#3E2E1B\",\"name\":\"Cola\"},{\"color\":{\"red\":28,\"green\":21,\"blue\":13},\"web\":\"#1C150D\",\"name\":\"Bokara Grey \"},{\"color\":{\"red\":84,\"green\":65,\"blue\":42},\"web\":\"#54412a\",\"name\":\"Deep Bronze\"},{\"color\":{\"red\":46,\"green\":61,\"blue\":68},\"web\":\"#2e3d44\",\"name\":\"Big Stone\"},{\"color\":{\"red\":123,\"green\":137,\"blue\":136},\"web\":\"#7b8988\",\"name\":\"Oslo Grey\"},{\"color\":{\"red\":147,\"green\":142,\"blue\":124},\"web\":\"#938e7c\",\"name\":\"Heathered Grey\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (466,124,30,'124050','Woman at her Toilet',1,'http://hdl.handle.net/10934/RM0001.COLLECT.5507','SK-A-4052','Public domain','This is an intimate moment: a girl undressing before going to bed. She is just pulling off a stocking. The indentation left by her garter is visible just below her knee. Her raised skirt allows the viewer a peak up along her bare legs. The image\'s explicit eroticism did not always find favour; until a hundred years ago, an underskirt was painted over her thighs.','This is an intimate moment: a girl undressing before going to bed. She is just pulling off a stocking. The indentation left by her garter is visible just below her knee. Her raised skirt allows the viewer a peak up along her bare legs. The image\'s explicit eroticism did not always find favour; until a hundred years ago, an underskirt was painted over her thighs.',1658,37,27,'Oil on canvas',450.0000,500.0000,NULL,NULL,'https://en.wikipedia.org/wiki/Jan_Steen#/media/File:Jan_Havicksz._Steen00.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":132,\"green\":119,\"blue\":95},\"web\":\"#84775F\",\"name\":\"Stonewall\"},{\"color\":{\"red\":98,\"green\":83,\"blue\":60},\"web\":\"#62533C\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":157,\"green\":147,\"blue\":123},\"web\":\"#9D937B\",\"name\":\"Tallow\"},{\"color\":{\"red\":65,\"green\":51,\"blue\":28},\"web\":\"#41331C\",\"name\":\"Mikado\"},{\"color\":{\"red\":87,\"green\":84,\"blue\":72},\"web\":\"#575448\",\"name\":\"Millbrook\"},{\"color\":{\"red\":126,\"green\":119,\"blue\":108},\"web\":\"#7E776C\",\"name\":\"Arrowtown\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (467,106,30,'106050','Woman Reading a Letter',3,'http://hdl.handle.net/10934/RM0001.COLLECT.6420','SK-C-251','Public domain','Enjoying a quiet, private moment, this young woman is absorbed in reading a letter in the morning light. She is still wearing her blue night jacket. All of the colours in the composition are secondary to its radiant lapis lazuli blue. Vermeer recorded the effects of light with extraordinary precision. Particularly innovative is his rendering of the woman\'s skin with pale grey, and the shadows on the wall using light blue.','Enjoying a quiet, private moment, this young woman is absorbed in reading a letter in the morning light. She is still wearing her blue night jacket. All of the colours in the composition are secondary to its radiant lapis lazuli blue. Vermeer recorded the effects of light with extraordinary precision. Particularly innovative is his rendering of the woman\'s skin with pale grey, and the shadows on the wall using light blue.',1663,46,39,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/woman-reading-a-letter/QQF82wPVTRfMPw',NULL,'https://en.wikipedia.org/wiki/Woman_in_Blue_Reading_a_Letter','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":104,\"green\":121,\"blue\":152},\"web\":\"#687998\",\"name\":\"Slate Grey\"},{\"color\":{\"red\":82,\"green\":79,\"blue\":48},\"web\":\"#524F30\",\"name\":\"Camouflage\"},{\"color\":{\"red\":72,\"green\":89,\"blue\":121},\"web\":\"#485979\",\"name\":\"Chambray\"},{\"color\":{\"red\":127,\"green\":125,\"blue\":93},\"web\":\"#7F7D5D\",\"name\":\"Kokoda\"},{\"color\":{\"red\":66,\"green\":63,\"blue\":35},\"web\":\"#423F23\",\"name\":\"Woodrush\"},{\"color\":{\"red\":199,\"green\":202,\"blue\":196},\"web\":\"#C7CAC4\",\"name\":\"Ottoman\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (468,106,30,'106060','View of Houses in Delft',3,'http://hdl.handle.net/10934/RM0001.COLLECT.6419','SK-A-2860','Public domain','This painting of a quiet street with a few figures occupies an exceptional place in Vermeer\'s oeuvre. Straight angles give the composition balance, while the triangle of the sky introduces a sense of dynamism. The old walls, coarse bricks, and white plasterwork are almost palpable. Vermeer nonetheless took some liberties with reality, such as the oversized green shutters.','This painting of a quiet street with a few figures occupies an exceptional place in Vermeer\'s oeuvre. Straight angles give the composition balance, while the triangle of the sky introduces a sense of dynamism. The old walls, coarse bricks, and white plasterwork are almost palpable. Vermeer nonetheless took some liberties with reality, such as the oversized green shutters.',1658,44,54,'Oil on canvas',1000.0000,1200.0000,'https://www.google.com/culturalinstitute/beta/asset/the-little-street/YAGJRuPz8yVuRQ','Also known as View of Houses in Delft, this is the only known outdoor scene by Vermeer of this type: a quiet street with only a few figures. The artist has captured the various materials meticulously: the worn bricks of the masonry, the gleam of the leaded windows, the white- plastered wall. The paint is applied thickly in one spot and thinly in another; in some places it is smooth, in others grainy.','https://en.wikipedia.org/wiki/The_Little_Street','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":112,\"green\":77,\"blue\":55},\"web\":\"#704D37\",\"name\":\"Old Copper\"},{\"color\":{\"red\":199,\"green\":192,\"blue\":171},\"web\":\"#C7C0AB\",\"name\":\"Cotton Seed\"},{\"color\":{\"red\":101,\"green\":82,\"blue\":62},\"web\":\"#65523E\",\"name\":\"Tobacco Brown\"},{\"color\":{\"red\":64,\"green\":48,\"blue\":32},\"web\":\"#403020\",\"name\":\"Cola\"},{\"color\":{\"red\":125,\"green\":110,\"blue\":90},\"web\":\"#7D6E5A\",\"name\":\"Sandstone\"},{\"color\":{\"red\":78,\"green\":49,\"blue\":31},\"web\":\"#4E311F\",\"name\":\"Indian Tan\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (469,105,30,'105040','Militia Company of District II under the Command of Captain Frans Banninck Cocq (Night Watch)',2,'http://hdl.handle.net/10934/RM0001.COLLECT.5216','SK-C-5','Public domain','Rembrandt\'s largest, most famous canvas was made for the Arquebusiers guild hall. This was one of several halls of Amsterdam\'s civic guard, the city\'s militia and police. Rembrandt was the first to paint figures in a group portrait actually doing something. The captain, dressed in black, is telling his lieutenant to start the company marching. The guardsmen are getting into formation. Rembrandt used the light to focus on particular details, like the captain\'s gesturing hand and the young girl in the foreground. She was the company mascot.','Rembrandt\'s largest, most famous canvas was made for the Arquebusiers guild hall. This was one of several halls of Amsterdam\'s civic guard, the city\'s militia and police. Rembrandt was the first to paint figures in a group portrait actually doing something.',1642,453,379,'Oil on canvas',4000.0000,4500.0000,'https://www.google.com/culturalinstitute/beta/asset/the-night-watch/eQEojRwTdypUKA','The Night Watch, the most famous painting in the Rijksmuseum, actually has another title: Militia Company of District II under the Command of Captain Frans Banninck Cocq. A militia painting is a group portrait of a division of the civic guard. Rembrandt depicted the group of militiamen in an unusual way. Not in a neat row or sitting at their annual banquet, rather, he recorded a moment: a group of militiamen have just moved into action and are about to march off.','https://en.wikipedia.org/wiki/The_Night_Watch','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":37,\"green\":27,\"blue\":8},\"web\":\"#251B08\",\"name\":\"Black Magic\"},{\"color\":{\"red\":127,\"green\":26,\"blue\":26},\"web\":\"#7F1A1A\",\"name\":\"Falu Red\"},{\"color\":{\"red\":92,\"green\":79,\"blue\":49},\"web\":\"#5C4F31\",\"name\":\"West Coast\"},{\"color\":{\"red\":100,\"green\":80,\"blue\":31},\"web\":\"#64501F\",\"name\":\"Bronze Olive\"},{\"color\":{\"red\":172,\"green\":152,\"blue\":94},\"web\":\"#AC985E\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":75,\"green\":54,\"blue\":12},\"web\":\"#4B360C\",\"name\":\"Madras\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (470,105,30,'105050','Portrait of Johannes Wtenbogaert',1,'http://hdl.handle.net/10934/RM0001.COLLECT.50214','SK-A-4885','Public domain','The 76-year-old Remonstrant minister, once the court chaplain of Prince Maurice, wears a calotte (skullcap) and a fur-lined cloak, the kind of clothing elderly scholars preferred to be portrayed in. Wtenbogaert\'s face is more realistically modelled than his hands, which may have been done by a pupil in Rembrandt\'s workshop.','The 76-year-old Remonstrant minister, once the court chaplain of Prince Maurice, wears a calotte (skullcap) and a fur-lined cloak, the kind of clothing elderly scholars preferred to be portrayed in. Wtenbogaert\'s face is more realistically modelled than his hands, which may have been done by a pupil in Rembrandt\'s workshop.',1633,103,130,'Oil on canvas',1000.0000,1200.0000,'https://www.google.com/culturalinstitute/beta/asset/portrait-of-johannes-wtenbogaert/OAGi5DuRI07nxg','Wtenbogaert (1557- 644) was a famous preacher, the founder and leader of the Remonstrant Brotherhood. At the request of one of his followers, he had his portrait painted by Rembrandt when he was 76 years of age. At this time Rembrandt was beginning to make a name for himself in Amsterdam as a portrait painter. This large work is one of the best portraits from that period. The large black cloak lends an imposing gravity to the figure of the old man, automatically leading the eye of the viewer to the white collar and the face. The hands appear to have been done by an assistant, but the face is Rembrandt at his best: with the raised eyebrows the artist has given the old man an individual characterization.','https://en.wikipedia.org/wiki/Johannes_Wtenbogaert','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":20,\"green\":17,\"blue\":12},\"web\":\"#14110C\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":91,\"green\":84,\"blue\":64},\"web\":\"#5B5440\",\"name\":\"Millbrook\"},{\"color\":{\"red\":57,\"green\":49,\"blue\":32},\"web\":\"#393120\",\"name\":\"Mikado\"},{\"color\":{\"red\":38,\"green\":31,\"blue\":16},\"web\":\"#261F10\",\"name\":\"Maire\"},{\"color\":{\"red\":52,\"green\":49,\"blue\":39},\"web\":\"#343127\",\"name\":\"Graphite\"},{\"color\":{\"red\":126,\"green\":113,\"blue\":85},\"web\":\"#7E7155\",\"name\":\"Pablo\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (471,105,30,'105060','Self-portrait',1,'http://hdl.handle.net/10934/RM0001.COLLECT.5236','SK-A-4691','Public domain','Even as an inexperienced young artist, Rembrandt did not shy away from experimenting. Here the light glances along his right cheek, while the rest of his face is veiled in shadow. It takes a while to realize that the artist is gazing intently out at us. Using the butt end of his brush, Rembrandt made scratches in the still wet paint to accentuate the curls of his tousled hair.','Here the light glances along his right cheek, while the rest of his face is veiled in shadow. It takes a while to realize that the artist is gazing intently out at us.',1628,187,22,'Oil on canvas',800.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/self-portrait/AQHvOEXiF3p9fg','This is one of the first works in which Rembrandt portrayed himself - he was about 22 years old. The light is strong and comes from behind. Rembrandt\'s face is in shadow and difficult to distinguish. The experimental manner in which the hair is rendered is interesting: Rembrandt made scratches in the wet paint, allowing the undercoat to show through.',NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":90,\"green\":83,\"blue\":62},\"web\":\"#5A533E\",\"name\":\"Panda\"},{\"color\":{\"red\":122,\"green\":116,\"blue\":91},\"web\":\"#7A745B\",\"name\":\"Pablo\"},{\"color\":{\"red\":64,\"green\":54,\"blue\":33},\"web\":\"#403621\",\"name\":\"Mikado\"},{\"color\":{\"red\":171,\"green\":145,\"blue\":90},\"web\":\"#AB915A\",\"name\":\"Teak\"},{\"color\":{\"red\":38,\"green\":28,\"blue\":12},\"web\":\"#261C0C\",\"name\":\"Black Magic\"},{\"color\":{\"red\":144,\"green\":117,\"blue\":68},\"web\":\"#907544\",\"name\":\"Shadow\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (472,105,30,'105070','Portrait of Marten Soolmans',1,'http://hdl.handle.net/10934/RM0001.COLLECT.612987','SK-A-5033','Public domain','Painted on the occasion of his marriage to Oopjen Coppit in 1634 and in 2015 purchased from the Rothschilds as part of a joint collaboration between the Rijksmuseum and the Louvre. It is considered a pendant portrait, and the portrait of his wife was included in the sale. Together the paintings were sold for 160 million Euro','Painted on the occasion of his marriage to Oopjen Coppit in 1634',1634,132,207,'Oil on canvas',600.0000,700.0000,NULL,NULL,'https://en.wikipedia.org/wiki/Portrait_of_Marten_Soolmans','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":22,\"green\":20,\"blue\":17},\"web\":\"#161411\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":161,\"green\":156,\"blue\":134},\"web\":\"#A19C86\",\"name\":\"Grey Olive\"},{\"color\":{\"red\":80,\"green\":80,\"blue\":80},\"web\":\"#505050\",\"name\":\"Matterhorn\"},{\"color\":{\"red\":52,\"green\":46,\"blue\":28},\"web\":\"#342E1C\",\"name\":\"Graphite\"},{\"color\":{\"red\":191,\"green\":188,\"blue\":168},\"web\":\"#BFBCA8\",\"name\":\"Ash\"},{\"color\":{\"red\":128,\"green\":121,\"blue\":100},\"web\":\"#807964\",\"name\":\"Arrowtown\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (473,105,30,'105080','The Sampling Officials of the Amsterdam Drapers Guild',2,'http://hdl.handle.net/10934/RM0001.COLLECT.5217','SK-C-6','Public domain','This is Rembrandt\'s first and only corporate group portrait. The Syndics stands out for its exceptionally large format and more than life-sized figures. All eyes of the sampling officials - who assessed the quality of dyed cloth - are turned to us and one figure even rises from his chair as if to acknowledge our presence. Because of the low vantage point, the table seems to jut out of the picture.','This is Rembrandt\'s first and only corporate group portrait. The Syndics stands out for its exceptionally large format and more than life-sized figures. All eyes of the sampling officials - who assessed the quality of dyed cloth - are turned to us and one figure even rises from his chair as if to acknowledge our presence. Because of the low vantage point, the table seems to jut out of the picture.',1662,279,191,'Oil on canvas',1800.0000,1900.0000,'https://www.google.com/culturalinstitute/beta/asset/the-syndics/ZgHt6DZhk-6SVw','It is as if we just distracted the wardens of the Amsterdam drapers\' guild from their work, so realistically Rembrandt has portrayed them. The servant in the background is the only person without a hat. To avoid having all the heads on exactly the same level, one of the officials is standing, just about to seat himself. This clever solution, the loose brushstrokes and the subtle light make this one of the most lively group portraits of the 17th century. The syndics monitored the quality of dyed \'laken\', a feltlike woollen fabric. Their portrait was intended over the fireplace of the conference room of the laken guild. Rembrandt has adjusted his perspective to take this into account: we are looking at the table as if from below. Painted for the Staalhof, the headquarters of the laken guild in the Staalstraat in Amsterdam. In 1771 it was transferred to the townhall.','https://en.wikipedia.org/wiki/Syndics_of_the_Drapers%27_Guild','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":61,\"green\":47,\"blue\":27},\"web\":\"#3D2F1B\",\"name\":\"Cola\"},{\"color\":{\"red\":24,\"green\":22,\"blue\":14},\"web\":\"#18160E\",\"name\":\"Maire\"},{\"color\":{\"red\":90,\"green\":73,\"blue\":46},\"web\":\"#5A492E\",\"name\":\"Punga\"},{\"color\":{\"red\":73,\"green\":44,\"blue\":27},\"web\":\"#492C1B\",\"name\":\"Morocco Brown\"},{\"color\":{\"red\":117,\"green\":60,\"blue\":37},\"web\":\"#753c25\",\"name\":\"New Amber\"},{\"color\":{\"red\":198,\"green\":193,\"blue\":172},\"web\":\"#c6c1ac\",\"name\":\"Kangaroo\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (474,105,30,'105090','Portrait of a Couple as Isaac and Rebecca, known as \'The Jewish Bride\'',2,'http://hdl.handle.net/10934/RM0001.COLLECT.5223','SK-C-216','Public domain','Two contemporaries had themselves portrayed by Rembrandt in historicizing costumes as characters from the Bible. The couple\'s tender embrace is at the centre of this poignant painting: the man\'s loving gesture is returned with a gentle caress. The figures and their poses agree with the study (No 67), only the figure of King Abimelech spying on them is missing. We, the viewers, assume his role as witnesses of their clandestine love.','The couple\'s tender embrace is at the centre of this poignant painting: the man\'s loving gesture is returned with a gentle caress.',1667,166,121,'Oil on canvas',1000.0000,1200.0000,'https://www.google.com/culturalinstitute/beta/asset/isaac-and-rebecca-known-as-the-jewish-bride/hAERFV8rdOOssw','The name \'The Jewish bride\', given to this painting in the 19th century, is a flight of fancy. The sitters probably asked Rembrandt to portray them as the biblical couple Isaac and Rebecca. They are attired in splendid oriental robes, and their tender embrace betrays their great love for one another. For this painting, which was done towards the end of his life, Rembrandt adopted an exceptionally free style. The man\'s sleeve is particularly interesting. The paint has been applied in blobs and daubs which reflect the light. In this way he used paint to add not only colour, but also relief.','https://en.wikipedia.org/wiki/The_Jewish_Bride','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":28,\"green\":21,\"blue\":15},\"web\":\"#1C150F\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":56,\"green\":41,\"blue\":24},\"web\":\"#382918\",\"name\":\"Cocoa Brown\"},{\"color\":{\"red\":144,\"green\":117,\"blue\":65},\"web\":\"#907541\",\"name\":\"Shadow\"},{\"color\":{\"red\":55,\"green\":22,\"blue\":16},\"web\":\"#371610\",\"name\":\"Seal Brown\"},{\"color\":{\"red\":148,\"green\":114,\"blue\":69},\"web\":\"#947245\",\"name\":\"Pale Brown\"},{\"color\":{\"red\":100,\"green\":36,\"blue\":27},\"web\":\"#64241b\",\"name\":\"Caput Mortuum\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (475,105,30,'105100','Portrait of Haesje Jacobsdr van Cleyburg',1,'http://hdl.handle.net/10934/RM0001.COLLECT.5225','SK-A-4833','Public domain','Haesje van Cleyburg, the wife of a wealthy Rotterdam beer brewer, is fashionably yet extremely soberly dressed. She has not been made more beautiful than she was: the wrinkles, shadows under her eyes, the bushy eyebrows, and the greying hair are all rendered with painstaking realism. What makes the portrait so charming is the faint smile that plays across her slightly parted lips.','Haesje van Cleyburg, the wife of a wealthy Rotterdam beer brewer, is fashionably yet extremely soberly dressed.',1634,53,68,'Oil on canvas',700.0000,800.0000,NULL,NULL,'https://commons.wikimedia.org/wiki/File:Rembrandt,_Portret_van_Haesje_v.Cleyburg_1634.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":22,\"green\":20,\"blue\":17},\"web\":\"#161411\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":161,\"green\":156,\"blue\":134},\"web\":\"#A19C86\",\"name\":\"Grey Olive\"},{\"color\":{\"red\":80,\"green\":80,\"blue\":80},\"web\":\"#505050\",\"name\":\"Matterhorn\"},{\"color\":{\"red\":52,\"green\":46,\"blue\":28},\"web\":\"#342E1C\",\"name\":\"Graphite\"},{\"color\":{\"red\":191,\"green\":188,\"blue\":168},\"web\":\"#BFBCA8\",\"name\":\"Ash\"},{\"color\":{\"red\":128,\"green\":121,\"blue\":100},\"web\":\"#807964\",\"name\":\"Arrowtown\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (476,105,30,'105110','Self Portrait as the Apostle Paul',1,'http://hdl.handle.net/10934/RM0001.COLLECT.5280','SK-A-4050','Public domain','This is Rembrandt\'s first and only self portrait in the guise of a biblical figure. The manuscript and the sword projecting from his cloak are Paul\'s traditional attributes. Like the other apostles Rembrandt painted in the same period, Paul too is a real, everyday person. By using his own likeness here Rembrandt encourages a direct bond with the saint.','This is Rembrandt\'s first and only self portrait in the guise of a biblical figure. The manuscript and the sword projecting from his cloak are Paul\'s traditional attributes. Like the other apostles Rembrandt painted in the same period, Paul too is a real, everyday person. By using his own likeness here Rembrandt encourages a direct bond with the saint.',1661,77,91,'Oil on canvas',800.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/self-portrait-as-the-apostle-paul/LwGcE5lQC5dLUg','Here Rembrandt is 55 or 56 years old. He has portrayed himself as the apostle Paul, shown together with his traditional attributes: a sword - the hilt of which is sticking out of his coat - and a manuscript written in letters which resemble Hebrew. In Protestant circles St. Paul was revered as the most important preacher of the Word of God.','https://en.wikipedia.org/wiki/Self-portrait_as_the_Apostle_Paul','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":60,\"green\":52,\"blue\":32},\"web\":\"#3C3420\",\"name\":\"Mikado\"},{\"color\":{\"red\":172,\"green\":153,\"blue\":104},\"web\":\"#AC9968\",\"name\":\"Tallow\"},{\"color\":{\"red\":38,\"green\":29,\"blue\":15},\"web\":\"#261D0F\",\"name\":\"Black Magic\"},{\"color\":{\"red\":94,\"green\":79,\"blue\":50},\"web\":\"#5E4F32\",\"name\":\"West Coast\"},{\"color\":{\"red\":170,\"green\":153,\"blue\":114},\"web\":\"#AA9972\",\"name\":\"Tallow\"},{\"color\":{\"red\":132,\"green\":115,\"blue\":81},\"web\":\"#847351\",\"name\":\"Shadow\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (477,105,30,'105120','Jeremiah Lamenting the Destruction of Jerusalem',1,'http://hdl.handle.net/10934/RM0001.COLLECT.5242','SK-A-3276','Public domain','Downcast, the biblical prophet Jeremiah leans his tired head on his hand. He mourns the burning city of Jerusalem (left background), the destruction of which he had predicted. The most important part of the depiction - the figure of Jeremiah - is painted with great precision, while his surroundings are barely worked out. Rembrandt used powerful contrasts of light and shadow to heighten the drama of the scene.','Downcast, the biblical prophet Jeremiah leans his tired head on his hand. He mourns the burning city of Jerusalem (left background), the destruction of which he had predicted. ',1630,46,58,'Oil on panel',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/jeremiah-lamenting-the-destruction-of-jerusalem/4gE-j88Uz3znNw','Despondently, his old head in his hands, the Biblical prophet Jeremia weeps over the burning of Jerusalem, visible in the left background. The prophet had himself predicted its destruction. This is one of the best paintings Rembrandt did just before leaving the city of Leiden. By this time he was making use of pronounced light and dark contrasts to separate significant elements from less important ones, and to heighten the dramatic impact of a scene. The differences in finishing are also characteristic: the surroundings are rendered cursorily, whereas in the foreground Rembrandt has devoted considerable attention to the representation of fabric and materials, and the reflection of light.','https://commons.wikimedia.org/wiki/File:Rembrandt_Harmensz._van_Rijn_-_Jeremia_treurend_over_de_verwoesting_van_Jeruzalem_-_Google_Art_Project.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":95,\"green\":81,\"blue\":54},\"web\":\"#5F5136\",\"name\":\"West Coast\"},{\"color\":{\"red\":69,\"green\":54,\"blue\":29},\"web\":\"#45361D\",\"name\":\"Clinker\"},{\"color\":{\"red\":86,\"green\":80,\"blue\":74},\"web\":\"#56504A\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":105,\"green\":85,\"blue\":42},\"web\":\"#69552A\",\"name\":\"Horses Neck\"},{\"color\":{\"red\":122,\"green\":107,\"blue\":77},\"web\":\"#7A6B4D\",\"name\":\"Go Ben\"},{\"color\":{\"red\":58,\"green\":53,\"blue\":46},\"web\":\"#3A352E\",\"name\":\"Acadia\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (478,125,30,'125010','Portrait of Alida Christina Assink',1,'http://hdl.handle.net/10934/RM0001.COLLECT.358121','SK-C-1672','Public domain','Dressed in the latest fashion, Alida Assink poses here for the society painter Kruseman. The clothing gives her a stylish silhouette: broad shoulders, puff sleeves and a hoop skirt make her waist seem very slim. The large belt buckle further accentuates this. Kruseman admired English portraiture. The rural set-ting with a hunting dog and a garden vase is derived from English models.','Dressed in the latest fashion, Alida Assink poses here for the society painter Kruseman.',1833,149,206,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":129,\"green\":115,\"blue\":92},\"web\":\"#81735C\",\"name\":\"Stonewall\"},{\"color\":{\"red\":119,\"green\":79,\"blue\":31},\"web\":\"#774F1F\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":42,\"green\":12,\"blue\":13},\"web\":\"#2A0C0D\",\"name\":\"Rustic Red\"},{\"color\":{\"red\":125,\"green\":119,\"blue\":112},\"web\":\"#7D7770\",\"name\":\"Sand Dune\"},{\"color\":{\"red\":43,\"green\":58,\"blue\":17},\"web\":\"#2b3a11\",\"name\":\"Turtle Green\"},{\"color\":{\"red\":108,\"green\":26,\"blue\":30},\"web\":\"#6c1a1e\",\"name\":\"Red Berry\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (479,125,30,'125020','Portrait of William II, King of the Netherlands',1,'http://hdl.handle.net/10934/RM0001.COLLECT.10653','SK-C-170','Public domain','This is a portrait of King William II in military uniform, but with a decidedly informal air. Accompanied by his hound, he poses casually in the dunes, which in the Romantic era was considered the quintessentially Dutch landscape. In 1848, when revolutions were raging throughout Europe, William II renounced royal autocracy and the Netherlands became a parliamentary democracy.','This is a portrait of King William II in military uniform, but with a decidedly informal air. Accompanied by his hound, he poses casually in the dunes, which in the Romantic era was considered the quintessentially Dutch landscape.',1839,86,109,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":171,\"green\":162,\"blue\":139},\"web\":\"#ABA28B\",\"name\":\"Napa\"},{\"color\":{\"red\":54,\"green\":44,\"blue\":37},\"web\":\"#362C25\",\"name\":\"Coffee Bean\"},{\"color\":{\"red\":98,\"green\":81,\"blue\":55},\"web\":\"#625137\",\"name\":\"Dallas\"},{\"color\":{\"red\":131,\"green\":113,\"blue\":86},\"web\":\"#837156\",\"name\":\"Cement\"},{\"color\":{\"red\":144,\"green\":115,\"blue\":67},\"web\":\"#907343\",\"name\":\"Shadow\"},{\"color\":{\"red\":136,\"green\":55,\"blue\":42},\"web\":\"#88372a\",\"name\":\"Crab Apple\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (481,126,30,'126010','A Mother Delousing her Child’s Hair, Known as ‘A Mother’s Duty’',3,'http://hdl.handle.net/10934/RM0001.COLLECT.8769','SK-C-149','Public domain','A mother thoroughly inspects her child\'s head for lice. She pursues her task in a sober Dutch interior, with Delft blue tiles and a box bed. In the right foreground is a potty chair. Through the doorway is a glimpse of a sunny back room and a garden. De Hooch specialized in such \'through-views\'.','A mother thoroughly inspects her child\'s head for lice. She pursues her task in a sober Dutch interior, with Delft blue tiles and a box bed. In the right foreground is a potty chair. Through the doorway is a glimpse of a sunny back room and a garden. De Hooch specialized in such \'through-views\'.',1659,61,52,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":72,\"green\":42,\"blue\":24},\"web\":\"#482A18\",\"name\":\"Morocco Brown\"},{\"color\":{\"red\":27,\"green\":21,\"blue\":15},\"web\":\"#1B150F\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":169,\"green\":151,\"blue\":123},\"web\":\"#A9977B\",\"name\":\"Bronco\"},{\"color\":{\"red\":125,\"green\":56,\"blue\":27},\"web\":\"#7d381b\",\"name\":\"Peru Tan\"},{\"color\":{\"red\":108,\"green\":71,\"blue\":45},\"web\":\"#6C472D\",\"name\":\"Semi-Sweet Chocolate\"},{\"color\":{\"red\":192,\"green\":153,\"blue\":122},\"web\":\"#C0997A\",\"name\":\"Pale Taupe\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (482,126,30,'126020','Interior with Women beside a Linen Cupboard`',3,'http://hdl.handle.net/10934/RM0001.COLLECT.8772','SK-C-1191','Public domain','This scene of domestic virtue dates from De Hooch\'s Amsterdam period. In a richly appointed house, two women put freshly pressed linen into a cupboard. They have hitched up their skirts to keep them clean while doing household chores. In the doorway a child plays with a kolfstok, a kind of hockey stick. Brightly lit canal houses can be seen.','In a richly appointed house, two women put freshly pressed linen into a cupboard. They have hitched up their skirts to keep them clean while doing household chores. In the doorway a child plays with a kolfstok, a kind of hockey stick. Brightly lit canal houses can be seen.',1663,75,70,'Oil on canvas',670.0000,920.0000,NULL,NULL,'https://en.wikipedia.org/wiki/Two_Women_Beside_a_Linen_Chest,_with_a_Child','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":160,\"green\":122,\"blue\":42},\"web\":\"#A07A2A\",\"name\":\"Hot Toddy\"},{\"color\":{\"red\":122,\"green\":76,\"blue\":29},\"web\":\"#7A4C1D\",\"name\":\"Russet\"},{\"color\":{\"red\":133,\"green\":119,\"blue\":94},\"web\":\"#85775E\",\"name\":\"Stonewall\"},{\"color\":{\"red\":81,\"green\":47,\"blue\":1},\"web\":\"#512F01\",\"name\":\"Baker\'s Chocolate\"},{\"color\":{\"red\":148,\"green\":113,\"blue\":54},\"web\":\"#947136\",\"name\":\"Buttered Rum\"},{\"color\":{\"red\":97,\"green\":82,\"blue\":56},\"web\":\"#615238\",\"name\":\"West Coast\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (483,127,30,'127010','The Windmill at Wijk bij Duurstede',3,'http://hdl.handle.net/10934/RM0001.COLLECT.5333','SK-C-211','Public domain','The windmill rises up majestically, defying the dark rain clouds and overshadowing the castle and the church of Wijk bij Duurstede. The River Lek flows in the foreground. This painting is world famous, and rightly so. In this impressive composition, Ruisdael united all the typical Dutch elements - the low-lying land, the water and the expansive sky - manipulating them to converge on the equally characteristic Dutch watermill.','The windmill rises up majestically, defying the dark rain clouds and overshadowing the castle and the church of Wijk bij Duurstede. The River Lek flows in the foreground. This painting is world famous, and rightly so.',1670,101,83,'Oil on canvas',1100.0000,1200.0000,'https://www.google.com/culturalinstitute/beta/asset/the-windmill-at-wijk-bij-duurstede/5gHsKOHsLvPatg','Viewed from a low perspective, the mill contrasts majestically against the dark sky. The buildings further in the distance are the castle and St Maarten\'s church at Wijk bij Duurstede, a major city in the Golden Age. The river in the foreground is the Lek. This is the epitome of a Dutch landscape: flat country, lots of water, sky and windmills.','https://en.wikipedia.org/wiki/Windmill_at_Wijk_bij_Duurstede','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":144,\"green\":146,\"blue\":138},\"web\":\"#90928A\",\"name\":\"Delta\"},{\"color\":{\"red\":36,\"green\":31,\"blue\":17},\"web\":\"#241F11\",\"name\":\"Maire\"},{\"color\":{\"red\":91,\"green\":92,\"blue\":85},\"web\":\"#5B5C55\",\"name\":\"Chicago\"},{\"color\":{\"red\":128,\"green\":119,\"blue\":94},\"web\":\"#80775E\",\"name\":\"Stonewall\"},{\"color\":{\"red\":158,\"green\":155,\"blue\":133},\"web\":\"#9E9B85\",\"name\":\"Grey Olive\"},{\"color\":{\"red\":90,\"green\":85,\"blue\":65},\"web\":\"#5A5541\",\"name\":\"Millbrook\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (484,127,30,'127020','Winter Landscape',3,'http://hdl.handle.net/10934/RM0001.COLLECT.5331','SK-A-349','Public domain','Ruisdael painted around 25 winter landscapes. This scene is dominated by ominous dark clouds, and lit from the left by low, raking sunlight. The warmly dressed figures on the ice seem insignificant in the face of this inclement weather. A cheerful crowd of ice skaters would have been out of place in such a wintery landscape by Ruisdael.',' This scene is dominated by ominous dark clouds, and lit from the left by low, raking sunlight.',1665,49,42,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":56,\"green\":45,\"blue\":28},\"web\":\"#382D1C\",\"name\":\"Black Magic\"},{\"color\":{\"red\":81,\"green\":79,\"blue\":72},\"web\":\"#514F48\",\"name\":\"Dune\"},{\"color\":{\"red\":124,\"green\":125,\"blue\":120},\"web\":\"#7C7D78\",\"name\":\"Gunsmoke\"},{\"color\":{\"red\":90,\"green\":79,\"blue\":61},\"web\":\"#5A4F3D\",\"name\":\"Mondo\"},{\"color\":{\"red\":50,\"green\":49,\"blue\":46},\"web\":\"#32312E\",\"name\":\"Graphite\"},{\"color\":{\"red\":149,\"green\":149,\"blue\":144},\"web\":\"#959590\",\"name\":\"Lemon Grass\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (486,128,30,'128010','Morning Ride Along the Beach',2,'http://hdl.handle.net/10934/RM0001.COLLECT.9020','SK-A-3602','Public domain','Hague School painters were drawn to the harsh existence of poor fishermen, like those living in nearby Scheveningen. Here, however, Mauve depicted the other side of that fishing village: the sunny world of the well-to-do bourgeoisie. Three riders descend to the beach, where the bathing cabins stand ready for swimmers. The blond and blue colour scheme effectively conveys the briny atmosphere of a summer day along the seashore.','Here Mauve depicted the other side of that fishing village: the sunny world of the well-to-do bourgeoisie.',1876,68,43,'Oil on canvas',700.0000,900.0000,NULL,NULL,'https://commons.wikimedia.org/wiki/File:Anton_Mauve_-_Morgenrit_langs_het_strand.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":61,\"green\":50,\"blue\":33},\"web\":\"#3D3221\",\"name\":\"Creole\"},{\"color\":{\"red\":33,\"green\":27,\"blue\":20},\"web\":\"#211B14\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":92,\"green\":81,\"blue\":61},\"web\":\"#5C513D\",\"name\":\"Mondo\"},{\"color\":{\"red\":126,\"green\":118,\"blue\":94},\"web\":\"#7E765E\",\"name\":\"Stonewall\"},{\"color\":{\"red\":168,\"green\":178,\"blue\":156},\"web\":\"#bab29c\",\"name\":\"Akaroa\"},{\"color\":{\"red\":128,\"green\":121,\"blue\":91},\"web\":\"#80795b\",\"name\":\"Kokoda\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (487,128,30,'128020','The Vegetable Garden',2,'http://hdl.handle.net/10934/RM0001.COLLECT.9024','SK-A-2524','Public domain','Mauve called himself a real \'outdoors man\'. From 1884 he regularly painted the vegetable and fruit gardens of farms. He used a bright palette instead of the greyish tones he had favoured a few years earlier. The vegetable garden here displays a wealth of green tonalities. The white accents of the linen and the woman\'s cap lend depth and freshness to the image.','The vegetable garden here displays a wealth of green tonalities. The white accents of the linen and the woman\'s cap lend depth and freshness to the image.',1885,87,61,'Oil on canvas',750.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":79,\"green\":75,\"blue\":46},\"web\":\"#4f4b2e\",\"name\":\"Camouflage\"},{\"color\":{\"red\":55,\"green\":49,\"blue\":33},\"web\":\"#373121\",\"name\":\"Graphite\"},{\"color\":{\"red\":115,\"green\":110,\"blue\":70},\"web\":\"#736e46\",\"name\":\"Go Ben\"},{\"color\":{\"red\":172,\"green\":163,\"blue\":141},\"web\":\"#aca38d\",\"name\":\"Napa\"},{\"color\":{\"red\":121,\"green\":114,\"blue\":91},\"web\":\"#79725b\",\"name\":\"Pablo\"},{\"color\":{\"red\":39,\"green\":30,\"blue\":15},\"web\":\"#271E0F\",\"name\":\"Black Magic\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (488,129,30,'129010','The Death of the Pharaoh\'s Firstborn Son',2,'http://hdl.handle.net/10934/RM0001.COLLECT.5773','SK-A-2664','Public domain','In this scene from the biblical book of Exodus, Moses and Aaron (upper right) visit the pharaoh, who is mourning his son. The Egyptian ruler\'s son had died from one of the plagues sent by God to secure the Israelites\' release from Egypt. The gloom of the painting reflects the father\'s intense grief. One has to look long and hard to discern all the figures and details.','In this scene from the biblical book of Exodus, Moses and Aaron (upper right) visit the pharaoh, who is mourning his son. The Egyptian ruler\'s son had died from one of the plagues sent by God to secure the Israelites\' release from Egypt. The gloom of the painting reflects the father\'s intense grief.',1872,124,77,'Oil on canvas',900.0000,1200.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":61,\"green\":45,\"blue\":22},\"web\":\"#3D2D16\",\"name\":\"Black Magic\"},{\"color\":{\"red\":145,\"green\":101,\"blue\":50},\"web\":\"#916532\",\"name\":\"McKenzie\"},{\"color\":{\"red\":38,\"green\":27,\"blue\":11},\"web\":\"#261B0B\",\"name\":\"Cocoa Brown\"},{\"color\":{\"red\":96,\"green\":77,\"blue\":49},\"web\":\"#604D31\",\"name\":\"Dallas\"},{\"color\":{\"red\":116,\"green\":80,\"blue\":39},\"web\":\"#745027\",\"name\":\"Cafe Royale\"},{\"color\":{\"red\":71,\"green\":44,\"blue\":17},\"web\":\"#472C11\",\"name\":\"Bistre\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (489,129,30,'129020','The Egyptian Widow',2,'http://hdl.handle.net/10934/RM0001.COLLECT.5776','SK-A-2427','Public domain','The Frisian artist Alma-Tadema was a great success in England, where he was even knighted. His representations of ancient Egyptian, Greek and Roman scenes made him one of the most popular 19th-century painters. In this picture, full of archaeological details, a woman is mourning beside the inner mummy case containing the body of her husband. His sarcophagus stands at left, while priests and singers lament the departed.','In this picture, full of archaeological details, a woman is mourning beside the inner mummy case containing the body of her husband.',1872,99,74,'Oil on canvas',800.0000,1050.0000,'https://www.google.com/culturalinstitute/beta/asset/the-egyptian-widow/twGCKY0wRr9MWw?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":137,\"green\":116,\"blue\":65},\"web\":\"#897441\",\"name\":\"Shadow\"},{\"color\":{\"red\":63,\"green\":48,\"blue\":23},\"web\":\"#3F3017\",\"name\":\"Mikado\"},{\"color\":{\"red\":107,\"green\":86,\"blue\":38},\"web\":\"#6B5626\",\"name\":\"Horses Neck\"},{\"color\":{\"red\":167,\"green\":147,\"blue\":94},\"web\":\"#A7935E\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":97,\"green\":80,\"blue\":46},\"web\":\"#61502E\",\"name\":\"West Coast\"},{\"color\":{\"red\":75,\"green\":54,\"blue\":12},\"web\":\"#4B360C\",\"name\":\"Madras\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (490,129,27,'129030','Spring',5,'http://www.getty.edu/art/collection/objects/611/lawrence-alma-tadema-spring-dutch-1894/','72.PA.3','Public domain','A procession of women and children descending marble stairs carry and wear brightly colored flowers. Cheering spectators fill the windows and roof of a classical building. Lawrence Alma-Tadema here represented the Victorian custom of sending children into the country to collect flowers on the morning of May 1, or May Day, but placed the scene in ancient Rome. In this way, he suggested the festival\'s great antiquity through architectural details, dress, sculpture, and even the musical instruments based on Roman originals.','A procession of women and children descending marble stairs carry and wear brightly colored flowers.',1894,178,80,'Oil on canvas',1000.0000,1300.0000,NULL,NULL,'https://commons.wikimedia.org/wiki/File:Alma_Tadema_Spring.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":131,\"green\":116,\"blue\":89},\"web\":\"#837459\",\"name\":\"Cement\"},{\"color\":{\"red\":99,\"green\":85,\"blue\":60},\"web\":\"#63553C\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":65,\"green\":50,\"blue\":30},\"web\":\"#41321E\",\"name\":\"Clinker\"},{\"color\":{\"red\":138,\"green\":152,\"blue\":156},\"web\":\"#8A989C\",\"name\":\"8A989C\"},{\"color\":{\"red\":162,\"green\":149,\"blue\":121},\"web\":\"#A29579\",\"name\":\"Tallow\"},{\"color\":{\"red\":129,\"green\":154,\"blue\":167},\"web\":\"#819AA7\",\"name\":\"Bali Hai\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (492,130,30,'130010','Portrait of a young Woman, with \'Puck\' the Dog',1,'http://hdl.handle.net/10934/RM0001.COLLECT.7476','SK-A-1703','Public domain','Therese Schwartze painted this model wearing Italian garb in her atelier in Paris. The young woman exchanges a glance with Puck, the dog at her right. The various rich fabrics of her dress are masterfully rendered. At the time, for a young Dutch woman to work in Paris was as unconventional as pursuing an artistic career. However, as the seasoned daughter of a professional painter, Schwartze was not deterred by such obstacles.','Therese Schwartze painted this model wearing Italian garb in her atelier in Paris. The young woman exchanges a glance with Puck, the dog at her right. The various rich fabrics of her dress are masterfully rendered. At the time, for a young Dutch woman to work in Paris was as unconventional as pursuing an artistic career. ',1880,103,144,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":15,\"green\":16,\"blue\":12},\"web\":\"#0F100C\",\"name\":\"Rangoon Green\"},{\"color\":{\"red\":133,\"green\":149,\"blue\":123},\"web\":\"#85957B\",\"name\":\"Amulet\"},{\"color\":{\"red\":165,\"green\":154,\"blue\":120},\"web\":\"#A59A78\",\"name\":\"Tallow\"},{\"color\":{\"red\":131,\"green\":122,\"blue\":92},\"web\":\"#837A5C\",\"name\":\"Clay Creek\"},{\"color\":{\"red\":206,\"green\":196,\"blue\":162},\"web\":\"#CEC4A2\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":118,\"green\":59,\"blue\":35},\"web\":\"#763b23\",\"name\":\"Peru Tan\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (493,130,30,'130020','Three girls from the Amsterdam Orphanage',3,'http://hdl.handle.net/10934/RM0001.COLLECT.7207','SK-A-1190','Public domain','Three girls from the Amsterdam Orphanage. One reads from a book while another listens and is another busy mending. To the left is a laundry basket, while on the right lies a sleeping cat on a bench.','Three girls from the Amsterdam Orphanage. One reads from a book while another listens and is another busy mending. To the left is a laundry basket, while on the right lies a sleeping cat on a bench.',1885,96,81,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":28,\"green\":21,\"blue\":16},\"web\":\"#1C1510\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":55,\"green\":43,\"blue\":27},\"web\":\"#372B1B\",\"name\":\"Black Magic\"},{\"color\":{\"red\":201,\"green\":195,\"blue\":172},\"web\":\"#C9C3AC\",\"name\":\"Parchment\"},{\"color\":{\"red\":87,\"green\":40,\"blue\":38},\"web\":\"#572826\",\"name\":\"Caput Mortuum\"},{\"color\":{\"red\":51,\"green\":44,\"blue\":39},\"web\":\"#332C27\",\"name\":\"Coffee Bean\"},{\"color\":{\"red\":128,\"green\":118,\"blue\":97},\"web\":\"#807661\",\"name\":\"Stonewall\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (495,5,27,'005080','Portrait of the Sisters Zenaide and Charlotte Bonaparte',1,'http://www.getty.edu/art/collection/objects/802/jacques-louis-david-portrait-of-the-sisters-zenaide-and-charlotte-bonaparte-french-1821/','86.PA.740','Public domain','The Sisters Zenaide and Charlotte Bonaparte, Napoleon\'s nieces, embrace as they read a letter from their father, Joseph Bonaparte, who was exiled in the United States while they lived in Brussels, Belgium, after Napoleon\'s fall from power. The folds of the carefully creased paper are realistically rendered, and the viewer can even decipher a Philadelphia address on the letter.','The Sisters Zenaide and Charlotte Bonaparte, Napoleon\'s nieces, embrace as they read a letter from their father, Joseph Bonaparte',1821,100,129,'Oil on canvas',800.0000,1000.0000,'https://www.google.com/culturalinstitute/beta/asset/zenaide-and-carlotta-bonaparte/OQEgWJJ50fcp7g',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":63,\"green\":49,\"blue\":30},\"web\":\"#3F311E\",\"name\":\"Cola\"},{\"color\":{\"red\":23,\"green\":17,\"blue\":13},\"web\":\"#17110D\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":86,\"green\":84,\"blue\":81},\"web\":\"#565451\",\"name\":\"Masala\"},{\"color\":{\"red\":112,\"green\":72,\"blue\":25},\"web\":\"#704819\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":54,\"green\":13,\"blue\":9},\"web\":\"#360D09\",\"name\":\"Seal Brown\"},{\"color\":{\"red\":101,\"green\":42,\"blue\":39},\"web\":\"#652a27\",\"name\":\"Kenyan Copper\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (496,108,27,'108020','Still Life with Fish, Vegetables, Gougres, Pots, and Cruets on a Table',1,'http://www.getty.edu/art/collection/objects/201125/jean-simeon-chardin-still-life-with-fish-vegetables-gougeres-pots-and-cruets-on-a-table-french-1769/','2003.13','Public domain','The objects\' arrangement is spare but dynamic: Two mackerels hang vertically in front of a plain background, perpendicular to an arrangement of food on the tabletop below. Brilliant light directs the eye, attracting attention to the shiny fish, leafy greens, root vegetables, a wheel of cheese, and covered bowls. Although the overall palette is subdued, the oil and vinegar cruets are infused with rich color. The signature and date in the lower right corner are the last Chardin is known to have applied to a still life.','Chardin here transforms a simple kitchen scene with a subtle palette, innovative composition, and virtuoso brushwork',1769,58,68,'Oil on canvas',800.0000,950.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":134,\"green\":114,\"blue\":88},\"web\":\"#867258\",\"name\":\"Cement\"},{\"color\":{\"red\":103,\"green\":85,\"blue\":63},\"web\":\"#67553F\",\"name\":\"Tobacco Brown\"},{\"color\":{\"red\":162,\"green\":144,\"blue\":119},\"web\":\"#A29077\",\"name\":\"Pale Oyster\"},{\"color\":{\"red\":66,\"green\":50,\"blue\":29},\"web\":\"#42321D\",\"name\":\"Clinker\"},{\"color\":{\"red\":66,\"green\":39,\"blue\":32},\"web\":\"#422720\",\"name\":\"Brown Pod\"},{\"color\":{\"red\":38,\"green\":49,\"blue\":32},\"web\":\"#263120\",\"name\":\"Black Forest\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (497,113,27,'113020','The Vicomtesse de Vaudreuil',1,'http://www.getty.edu/art/collection/objects/782/elisabeth-louise-vigee-le-brun-the-vicomtesse-de-vaudreuil-french-1785/','85.PB.443','Public domain','On an oval panel, a young woman poses in front of a landscape. Smiling slightly, she looks candidly out at the viewer. The sitter, Victoire-Pauline de Riquet de Carama, was an aristocrat and her status improved when she married Jean-Louis, Vicomte de Vaudreuil in 1781. The artist Elisabeth Louise Vigee Le Brun emphasized the Vicomtesse\'s status and refinement by carefully describing her fashionable straw hat, silk dress, and gauze scarf, collar, and cuffs. Displaying her learning, the Vicomtesse places her right thumb in her book to mark her place, as if she has been interrupted while reading. Vigee Le Brun adopted this obvious gesture, often used in men\'s portraits, to illustrate women\'s importance in French Enlightenment circles.','The artist Elisabeth Louise Vigee Le Brun emphasized the Vicomtesse\'s status and refinement by carefully describing her fashionable straw hat, silk dress, and gauze scarf, collar, and cuffs. Displaying her learning, the Vicomtesse places her right thumb in her book to mark her place, as if she has been interrupted while reading.',1785,64,83,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":104,\"green\":116,\"blue\":112},\"web\":\"#687470\",\"name\":\"Rolling Stone\"},{\"color\":{\"red\":132,\"green\":118,\"blue\":95},\"web\":\"#84765F\",\"name\":\"Stonewall\"},{\"color\":{\"red\":141,\"green\":53,\"blue\":29},\"web\":\"#8D351D\",\"name\":\"Burnt Umber\"},{\"color\":{\"red\":164,\"green\":151,\"blue\":130},\"web\":\"#A49782\",\"name\":\"Malta\"},{\"color\":{\"red\":86,\"green\":114,\"blue\":113},\"web\":\"#567271\",\"name\":\"William\"},{\"color\":{\"red\":70,\"green\":41,\"blue\":54},\"web\":\"#462936\",\"name\":\"Barossa\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (498,19,27,'019130','Irises',2,'http://www.getty.edu/art/collection/objects/826/vincent-van-gogh-irises-dutch-1889/','90.PA.20','Public domain','In May 1889, after episodes of self-mutilation and hospitalization, Vincent van Gogh chose to enter an asylum in Saint-Remy, France. There, in the last year before his death, he created almost 130 paintings. Within the first week, he began Irises, working from nature in the asylum\'s garden. The cropped composition, divided into broad areas of vivid color with monumental irises overflowing its borders, was probably influenced by the decorative patterning of Japanese woodblock prints. Each one of Van Gogh\'s irises is unique. He carefully studied their movements and shapes to create a variety of curved silhouettes bounded by wavy, twisting, and curling lines. The painting\'s first owner, French art critic Octave Mirbeau, one of Van Gogh\'s earliest supporters, wrote: \"How well he has understood the exquisite nature of flowers!\"','Each one of Van Gogh\'s irises is unique. He carefully studied their movements and shapes to create a variety of curved silhouettes bounded by wavy, twisting, and curling lines.',1889,94,74,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/irises/DgFVFAJo_30MeQ',NULL,'https://en.wikipedia.org/wiki/Irises_(painting)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":88,\"green\":130,\"blue\":117},\"web\":\"#588275\",\"name\":\"Cutty Sark\"},{\"color\":{\"red\":64,\"green\":88,\"blue\":114},\"web\":\"#405872\",\"name\":\"Chambray\"},{\"color\":{\"red\":156,\"green\":108,\"blue\":88},\"web\":\"#9C6C58\",\"name\":\"Toast\"},{\"color\":{\"red\":116,\"green\":160,\"blue\":145},\"web\":\"#74A091\",\"name\":\"Acapulco\"},{\"color\":{\"red\":160,\"green\":200,\"blue\":125},\"web\":\"#5E8161\",\"name\":\"Hippie Green\"},{\"color\":{\"red\":94,\"green\":129,\"blue\":97},\"web\":\"#5E7692\",\"name\":\"Waikawa Grey\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (499,100,27,'100050','Venus and Adonis',2,'http://www.getty.edu/art/collection/objects/846/titian-tiziano-vecellio-venus-and-adonis-italian-about-1555-1560/','92.PA.42','Public domain','Titian\'s loose, energetic strokes of paint give the painting a sense of spontaneity and movement. In some areas, the artist even painted with his finger, as seen in Adonis\'s arm. The composition\'s dynamism springs from the torsion caused by Venus\'s awkward pose, which was inspired by an ancient sculptural relief. Titian used rich colors, shimmering highlights, and a lush landscape to create the painting\'s evocative, poignant mood.','The composition\'s dynamism springs from the torsion caused by Venus\'s awkward pose, which was inspired by an ancient sculptural relief. Titian used rich colors, shimmering highlights, and a lush landscape to create the painting\'s evocative, poignant mood.',1558,196,160,'Oil on canvas',800.0000,1000.0000,NULL,NULL,'https://en.wikipedia.org/wiki/Venus_and_Adonis_(Titian,_Madrid)','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":190,\"green\":146,\"blue\":115},\"web\":\"#BE9273\",\"name\":\"Pale Taupe\"},{\"color\":{\"red\":156,\"green\":111,\"blue\":84},\"web\":\"#9C6F54\",\"name\":\"Dark Tan\"},{\"color\":{\"red\":166,\"green\":112,\"blue\":75},\"web\":\"#A6704B\",\"name\":\"Sante Fe\"},{\"color\":{\"red\":116,\"green\":75,\"blue\":51},\"web\":\"#744B33\",\"name\":\"Cape Palliser\"},{\"color\":{\"red\":83,\"green\":42,\"blue\":23},\"web\":\"#532A17\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":98,\"green\":99,\"blue\":96},\"web\":\"#626360\",\"name\":\"Chicago\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (500,142,82,'142080','Crescent of Houses II (Island Town)',2,'https://www.leopoldmuseum.org/en/leopoldcollection/masterpieces/50','456','&copy; Leopold Museum','Viewed from the castle hill at Krumau, this curved cluster of houses can be precisely identified. To make them stand out clearly, the painter omitted the houses in the background and the bridge and opposite bank with St Jodocus’s Church. His concern was not to represent the topography, but to draw, with a cubist touch, a maze-like network of angular lines whose compositional center is located on the island-like peninsula. With their different components of façades, roofs, and chimneys, the buildings have the appearance of stereometric structures. Green and lilac bands follow the exterior of the houses in tune to themselves and to each other, like voices in a fugue. The sense of movement in this crescent is enhanced by the row of autumnal trees. Like the linear boundaries between land and dark water, all of the trees and structures of the land have been composed into a bow shape, which thereby adds to the spatial tug of the block of buildings.','Viewed from the castle hill at Krumau, this curved cluster of houses can be precisely identified. To make them stand out clearly, the painter omitted the houses in the background and the bridge and opposite bank with St Jodocus’s Church. ',1915,141,111,'Oil on canvas',800.0000,1060.0000,'https://artsandculture.google.com/asset/crescent-of-houses-ii-island-town/0QFSwRlsDowptw',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":135,\"green\":118,\"blue\":62},\"web\":\"#87763E\",\"name\":\"Go Ben\"},{\"color\":{\"red\":167,\"green\":113,\"blue\":42},\"web\":\"#A7712A\",\"name\":\"Hot Toddy\"},{\"color\":{\"red\":122,\"green\":120,\"blue\":90},\"web\":\"#7A785A\",\"name\":\"Kokoda\"},{\"color\":{\"red\":92,\"green\":87,\"blue\":59},\"web\":\"#5C573B\",\"name\":\"Panda\"},{\"color\":{\"red\":158,\"green\":110,\"blue\":54},\"web\":\"#9E6E36\",\"name\":\"Buttered Rum\"},{\"color\":{\"red\":104,\"green\":88,\"blue\":36},\"web\":\"#685824\",\"name\":\"Horses Neck\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (501,131,27,'131010','The Grand Canal in Venice from Palazzo Flangini to Campo San Marcuola',2,'http://www.getty.edu/art/collection/objects/225593/canaletto-giovanni-antonio-canal-the-grand-canal-in-venice-from-palazzo-flangini-to-campo-san-marcuola-italian-about-1738/','2013.22','Public domain','Each one of Van Gogh\'s irises is unique. He carefully studied their movements and shapes to create a variety of curved silhouettes bounded by wavy, twisting, and curling lines.','Canaletto was at the peak of his powers when he created this view of the sun-drenched palaces lining the Grand Canal and reflected in its shimmering water. With precise brushwork, he also evoked the effects of soot and crumbling stucco disfiguring the facades.',1738,78,47,'Oil on canvas',900.0000,1100.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":114,\"green\":132,\"blue\":130},\"web\":\"#728482\",\"name\":\"Gumbo\"},{\"color\":{\"red\":93,\"green\":79,\"blue\":57},\"web\":\"#5D4F39\",\"name\":\"Metallic Bronze\"},{\"color\":{\"red\":135,\"green\":148,\"blue\":141},\"web\":\"#87948D\",\"name\":\"Granny Smith\"},{\"color\":{\"red\":105,\"green\":132,\"blue\":133},\"web\":\"#698485\",\"name\":\"Gothic\"},{\"color\":{\"red\":65,\"green\":54,\"blue\":34},\"web\":\"#413622\",\"name\":\"Mikado\"},{\"color\":{\"red\":162,\"green\":155,\"blue\":128},\"web\":\"#A29B80\",\"name\":\"Grey Olive\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (502,131,6,'131020','Piazza San Marco',2,'http://www.metmuseum.org/art/collection/search/435839','1988.162','Open Access for Scholarly Content','The most celebrated view painter of eighteenth-century Venice, Canaletto was particularly popular with British visitors to the city. This wonderfully fresh and well-preserved canvas shows the square of San Marco. The windows of the bell tower are fewer in number than in actuality, and the flagstaffs are too tall, but otherwise Canaletto took few liberties with the topography.','This wonderfully fresh and well-preserved canvas shows the square of San Marco.',1727,112,69,'Oil on canvas',1100.0000,1400.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":77,\"green\":84,\"blue\":44},\"web\":\"#4D542C\",\"name\":\"Saratoga\"},{\"color\":{\"red\":163,\"green\":150,\"blue\":87},\"web\":\"#A39657\",\"name\":\"Husk\"},{\"color\":{\"red\":174,\"green\":193,\"blue\":188},\"web\":\"#AEC1BC\",\"name\":\"Opal\"},{\"color\":{\"red\":134,\"green\":167,\"blue\":169},\"web\":\"#86A7A9\",\"name\":\"Ziggurat\"},{\"color\":{\"red\":97,\"green\":88,\"blue\":31},\"web\":\"#61581F\",\"name\":\"Costa Del Sol\"},{\"color\":{\"red\":10,\"green\":17,\"blue\":9},\"web\":\"#0a1109\",\"name\":\"Myrtle\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (504,131,6,'131030','Venice: Santa Maria della Salute',2,'http://www.metmuseum.org/art/collection/search/435840','59.38','Open Access for Scholarly Content','A bird\'s eye view is to a degree imaginary, even if the scene is real, and this view is taken from high above the Grand Canal and the landing stage at Santa Maria della Salute. The panorama embraces the entrance to the canal in the direction of the bacino, with, at the right, the facade and dome of the church, one of the most splendid sights that Venice affords.','A bird\'s eye view is to a degree imaginary, even if the scene is real, and this view is taken from high above the Grand Canal and the landing stage at Santa Maria della Salute.',1740,79,47,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":112,\"green\":73,\"blue\":30},\"web\":\"#70491E\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":205,\"green\":186,\"blue\":154},\"web\":\"#CDBA9A\",\"name\":\"Vanilla\"},{\"color\":{\"red\":80,\"green\":47,\"blue\":19},\"web\":\"#502F13\",\"name\":\"Brown Bramble\"},{\"color\":{\"red\":199,\"green\":150,\"blue\":70},\"web\":\"#C79646\",\"name\":\"Tussock\"},{\"color\":{\"red\":184,\"green\":166,\"blue\":140},\"web\":\"#B8A68C\",\"name\":\"Pavlova\"},{\"color\":{\"red\":220,\"green\":196,\"blue\":148},\"web\":\"#DCC494\",\"name\":\"Raffia\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (505,132,6,'132010','The Abduction of the Sabine Women',2,'http://www.metmuseum.org/art/collection/search/437329','46.160','Open Access for Scholarly Content','The Romans invited the neighboring Sabines with the intention of forcibly retaining their young women as wives. Romulus raised his cloak as the pre-arranged signal for the warriors to seize the women. The yellow armor worn by the man at the right is modeled after a Roman lorica, which was made of leather and reproduced the anatomy of the male torso. ','The Romans invited the neighboring Sabines with the intention of forcibly retaining their young women as wives. Romulus raised his cloak as the pre-arranged signal for the warriors to seize the women.',1633,209,61,'Oil on canvas',1300.0000,1800.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":4,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":44,\"green\":16,\"blue\":25},\"web\":\"#2C1019\",\"name\":\"Rustic Red\"},{\"color\":{\"red\":177,\"green\":154,\"blue\":131},\"web\":\"#B19A83\",\"name\":\"Sandrift\"},{\"color\":{\"red\":73,\"green\":40,\"blue\":46},\"web\":\"#49282E\",\"name\":\"Cab Sav\"},{\"color\":{\"red\":104,\"green\":75,\"blue\":78},\"web\":\"#684B4E\",\"name\":\"Don Juan\"},{\"color\":{\"red\":190,\"green\":122,\"blue\":106},\"web\":\"#be7a6a\",\"name\":\"Contessa\"},{\"color\":{\"red\":132,\"green\":51,\"blue\":46},\"web\":\"#84332e\",\"name\":\"Crab Apple\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (506,132,6,'132020','The Rest on the Flight into Egypt',1,'http://www.metmuseum.org/art/collection/search/438025','1997.117.6','Open Access for Scholarly Content','This tenderly poetic picture reveals a side of Poussin not otherwise represented by the Museum\'s splendid holdings of this artist. During the 1620s Poussin was especially attracted by Venetian painting, studying Titian\'s great mythological compositions, some of which were in aristocratic collections in Rome. He took the inspiration for the fruit-gathering cherubs and the landscape from Titian\'s Bacchanals.','During the 1620s Poussin was especially attracted by Venetian painting, studying Titian\'s great mythological compositions, some of which were in aristocratic collections in Rome.',1627,63,76,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":175,\"green\":150,\"blue\":125},\"web\":\"#AF967D\",\"name\":\"Sandrift\"},{\"color\":{\"red\":130,\"green\":120,\"blue\":118},\"web\":\"#827876\",\"name\":\"Hurricane\"},{\"color\":{\"red\":113,\"green\":78,\"blue\":55},\"web\":\"#714E37\",\"name\":\"Old Copper\"},{\"color\":{\"red\":153,\"green\":108,\"blue\":64},\"web\":\"#996C40\",\"name\":\"McKenzie\"},{\"color\":{\"red\":138,\"green\":116,\"blue\":92},\"web\":\"#8A745C\",\"name\":\"Cement\"},{\"color\":{\"red\":140,\"green\":37,\"blue\":32},\"web\":\"#8c2520\",\"name\":\"Mandarian Orange\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (507,132,27,'132030','Landscape with a Calm\r\nLandscape with a Calm',2,'http://www.getty.edu/art/collection/objects/106381/nicolas-poussin-landscape-with-a-calm-un-temps-calme-et-serein-french-1650-1651/','97.PA.60','Public domain','In the late 1640s and early 1650s, at the height of his artistic maturity, Nicolas Poussin turned from historical narrative to landscape painting. Landscape with a Calm does not illustrate a story but rather evokes a mood. The ordered composition and clear, golden light contribute to A Calm\'s utter tranquility, while glowing, gem-like colors and fluid paint strokes enliven this scene of benevolent nature. Poussin\'s sketching campaigns in the Roman countryside with his friend and fellow landscape painter Claude Lorrain account, in part, for its fresh observation of cloud-scattered sky and grazing goats.','Landscape with a Calm does not illustrate a story but rather evokes a mood. The ordered composition and clear, golden light contribute to A Calm\'s utter tranquility, while glowing, gem-like colors and fluid paint strokes enliven this scene of benevolent nature.',1650,131,97,'Oil on canvas',800.0000,1100.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":92,\"green\":89,\"blue\":64},\"web\":\"#5C5940\",\"name\":\"Verdigris\"},{\"color\":{\"red\":124,\"green\":118,\"blue\":90},\"web\":\"#7c765a\",\"name\":\"Kokoda\"},{\"color\":{\"red\":115,\"green\":123,\"blue\":119},\"web\":\"#737B77\",\"name\":\"Sirocco\"},{\"color\":{\"red\":81,\"green\":91,\"blue\":88},\"web\":\"#515B58\",\"name\":\"Cape Cod\"},{\"color\":{\"red\":141,\"green\":145,\"blue\":136},\"web\":\"#8D9188\",\"name\":\"Delta\"},{\"color\":{\"red\":86,\"green\":101,\"blue\":106},\"web\":\"#56656a\",\"name\":\"Smalt Blue\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (508,121,6,'121030','Cardinal Fernando Nino de Guevara',1,'http://www.metmuseum.org/art/collection/search/436573','29.100.5','Open Access for Scholarly Content','This intense portrait depicts Fernando Nico de Guevara (1541-1609), who in 1596 was named cardinal and is dressed as such here. In 1599 he became Inquisitor General of Spain but resigned in 1602 to serve the rest of his life as Archbishop of Seville. The painting probably dates from the spring of 1600 when the cardinal was in Toledo with Philip III and members of the Madrid court. El Greco had lived in Venice and in the Farnese Palace in Rome, where Titian\'s portraits (such as those of the Farnese Pope Paul III) would have revealed to the Greek painter the psychological possibilities of portraiture.','This intense portrait depicts Fernando Nico de Guevara (1541-1609), who in 1596 was named cardinal and is dressed as such here.',1600,108,170,'Oil on canvas',800.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":125,\"green\":118,\"blue\":90},\"web\":\"#7D765A\",\"name\":\"Kokoda\"},{\"color\":{\"red\":66,\"green\":51,\"blue\":33},\"web\":\"#423321\",\"name\":\"Clinker\"},{\"color\":{\"red\":78,\"green\":42,\"blue\":45},\"web\":\"#4E2A2D\",\"name\":\"Heath\"},{\"color\":{\"red\":112,\"green\":72,\"blue\":77},\"web\":\"#70484D\",\"name\":\"Tosca\"},{\"color\":{\"red\":151,\"green\":108,\"blue\":114},\"web\":\"#976C72\",\"name\":\"Turkish Rose\"},{\"color\":{\"red\":188,\"green\":142,\"blue\":151},\"web\":\"#BC8E97\",\"name\":\"Viola\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (509,15,6,'015120','The Dance Class',3,'http://www.metmuseum.org/art/collection/search/438817','1987.47.1','Open Access for Scholarly Content','This work and its variant in the Musee d\'Orsay, Paris, represent the most ambitious paintings Degas devoted to the theme of the dance. Some twenty-four women, ballerinas and their mothers, wait while a dancer executes an \"attitude\" for her examination. Jules Perrot, a famous ballet master, conducts the class. The imaginary scene is set in a rehearsal room in the old Paris Opera, which had recently burned to the ground. On the wall beside the mirror, a poster for Rossini\'s Guillaume Tell pays tribute to the singer Jean-Baptiste Faure, who commissioned the picture and lent it to the 1876 Impressionist exhibition.','This work and its variant in the Musee d\'Orsay, Paris, represent the most ambitious paintings Degas devoted to the theme of the dance. ',1874,77,83,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":166,\"green\":155,\"blue\":126},\"web\":\"#A69B7E\",\"name\":\"Grey Olive\"},{\"color\":{\"red\":153,\"green\":63,\"blue\":32},\"web\":\"#993F20\",\"name\":\"Tia Maria\"},{\"color\":{\"red\":204,\"green\":191,\"blue\":161},\"web\":\"#CCBFA1\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":133,\"green\":119,\"blue\":88},\"web\":\"#857758\",\"name\":\"Stonewall\"},{\"color\":{\"red\":115,\"green\":130,\"blue\":91},\"web\":\"#73825B\",\"name\":\"Willow Grove\"},{\"color\":{\"red\":179,\"green\":153,\"blue\":101},\"web\":\"#B39965\",\"name\":\"Barley Corn\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (510,15,6,'015130','Sulking',2,'http://www.metmuseum.org/art/collection/search/436162','29.100.43','Open Access for Scholarly Content','Two well-known personalities in the art world, the writer Edmond Duranty and model Emma Dobigny, posed for this early genre scene by Degas, set in an office, possibly a small bank. From the faithfully copied British racing print to the stylishly attired female protagonist, it recalls the work of fellow artist James Tissot. Yet for all the exacting detail, the subject of this picture remains elusive. The model\'s elegant visiting dress, curiously worn without a hat, and the informality of her pose may suggest a familial or intimate relationship, but Degas offers faint clue as to the cause of his \"sulking.\"','Two well-known personalities in the art world, the writer Edmond Duranty and model Emma Dobigny, posed for this early genre scene by Degas, set in an office, possibly a small bank.',1870,46,32,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":63,\"green\":47,\"blue\":27},\"web\":\"#3F2F1B\",\"name\":\"Cola\"},{\"color\":{\"red\":172,\"green\":158,\"blue\":130},\"web\":\"#AC9E82\",\"name\":\"Napa\"},{\"color\":{\"red\":73,\"green\":44,\"blue\":25},\"web\":\"#492C19\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":134,\"green\":83,\"blue\":43},\"web\":\"#86532b\",\"name\":\"Korma\"},{\"color\":{\"red\":178,\"green\":137,\"blue\":98},\"web\":\"#b28962\",\"name\":\"Medium Wood\"},{\"color\":{\"red\":92,\"green\":81,\"blue\":73},\"web\":\"#5C5149\",\"name\":\"Saddle\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (511,6,6,'006040','Madame Jacques-Louis Leblanc',1,'http://www.metmuseum.org/art/collection/search/436703','19.77.2','Open Access for Scholarly Content','For this portrait there are more than two dozen drawings investigating a variety of poses (Musee Ingres, Montauban). Similar studies do not exist for the likeness of Madame Leblanc\'s husband (19.77.1). The two paintings-the only pair of portraits Ingres produced-were probably intended to hang facing one another, since the light falls differently in each, but they are unified by the visual harmony of hands, gold chains, and rich textiles that enhance the couple\'s black clothing.','For this portrait there are more than two dozen drawings investigating a variety of poses (Musee Ingres, Montauban). Similar studies do not exist for the likeness of Madame Leblanc\'s husband (19.77.1). The two paintings-the only pair of portraits Ingres produced-were probably intended to hang facing one another, since the light falls differently in each, but they are unified by the visual harmony of hands, gold chains, and rich textiles that enhance the couple\'s black clothing.',1823,92,117,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":80,\"green\":58,\"blue\":39},\"web\":\"#503a27\",\"name\":\"Woodburn\"},{\"color\":{\"red\":174,\"green\":140,\"blue\":114},\"web\":\"#ae8c72\",\"name\":\"Mongoose\"},{\"color\":{\"red\":235,\"green\":202,\"blue\":172},\"web\":\"#ebcaac\",\"name\":\"Desert Sand\"},{\"color\":{\"red\":164,\"green\":153,\"blue\":139},\"web\":\"#a4998b\",\"name\":\"Malta\"},{\"color\":{\"red\":151,\"green\":79,\"blue\":38},\"web\":\"#974f26\",\"name\":\"Hawaiian Tan\"},{\"color\":{\"red\":153,\"green\":111,\"blue\":31},\"web\":\"#996f1f\",\"name\":\"Golden Brown\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (512,6,6,'006050','Joséphine-Éléonore-Marie-Pauline de Galard de Brassac de Béarn',1,'http://www.metmuseum.org/art/collection/search/459106','1975.1.186','Open Access for Scholarly Content','Jean-Auguste-Dominique Ingres, the neo-classical French artist par excellence, painted this masterpiece toward the end of his life when his reputation as a portraitist to prominent citizens and Orleanist aristocrats had been long established. Pauline de Broglie sat for the artist\'s final commission. Ingres captures the shy reserve of his subject while illuminating through seamless brushwork the material quality of her many fine attributes: her rich blue satin and lace ball gown, the gold embroidered shawl, and silk damask chair, together with finely tooled jewels of pearl, enamel, and gold. The portrait was commissioned by the sitter\'s husband, Albert de Broglie, a few years after their ill-fated marriage. Pauline was stricken with tuberculosis soon after completion of the exquisite portrait, leaving five sons and a grieving husband. Through Albert\'s lifetime, it was draped in fabric on the walls of the family residence.','Ingres captures the shy reserve of his subject while illuminating through seamless brushwork the material quality of her many fine attributes: her rich blue satin and lace ball gown, the gold embroidered shawl, and silk damask chair, together with finely tooled jewels of pearl, enamel, and gold.',1851,121,91,'Oil on canvas',1100.0000,1400.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":51,\"green\":54,\"blue\":43},\"web\":\"#33362B\",\"name\":\"Eternity\"},{\"color\":{\"red\":36,\"green\":84,\"blue\":129},\"web\":\"#245481\",\"name\":\"Bahama Blue\"},{\"color\":{\"red\":88,\"green\":84,\"blue\":63},\"web\":\"#58543F\",\"name\":\"Panda\"},{\"color\":{\"red\":206,\"green\":195,\"blue\":162},\"web\":\"#CEC3A2\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":115,\"green\":162,\"blue\":182},\"web\":\"#73A2B6\",\"name\":\"Glacier\"},{\"color\":{\"red\":173,\"green\":144,\"blue\":52},\"web\":\"#ad9034\",\"name\":\"Reef Gold\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (513,6,6,'006060','Joseph-Antoine Moltedo',1,'http://www.metmuseum.org/art/collection/search/438818','29.100.23','Open Access for Scholarly Content','Corsican by birth, Moltedo was an enterprising businessman and inventor, agent to the French clergy at the Vatican, and director of the Roman post office from 1803 until 1814. Painted during one of the most productive periods of Ingres\'s nascent career, this refined portrait belongs to a series of commissions he received from French officials in Napoleonic Rome. They are distinguished by the inclusion of Roman views as backdrops-in this case the Appian Way and the Colosseum-as well as by stormy gray skies, a Romantic conceit that serves as a foil to the calm and secure expressions of the men portrayed.','Painted during one of the most productive periods of Ingres\'s nascent career, this refined portrait belongs to a series of commissions he received from French officials in Napoleonic Rome.',1810,58,75,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":73,\"green\":54,\"blue\":33},\"web\":\"#493621\",\"name\":\"Clinker\"},{\"color\":{\"red\":53,\"green\":52,\"blue\":46},\"web\":\"#35342E\",\"name\":\"Graphite\"},{\"color\":{\"red\":30,\"green\":24,\"blue\":20},\"web\":\"#1E1814\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":90,\"green\":77,\"blue\":55},\"web\":\"#5A4D37\",\"name\":\"Metallic Bronze\"},{\"color\":{\"red\":78,\"green\":81,\"blue\":70},\"web\":\"#4E5146\",\"name\":\"Lunar Green\"},{\"color\":{\"red\":77,\"green\":48,\"blue\":26},\"web\":\"#4D301A\",\"name\":\"Brown Bramble\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (514,14,6,'014050','By the Seashore',1,'http://www.metmuseum.org/art/collection/search/437430','29.100.125','Open Access for Scholarly Content','Renoir likely painted this work in his studio, posing his model and future wife, Aline Charigot, in a wicker chair. The beach behind her probably represents the Normandy coast near Dieppe. This canvas reflects the impact of Renoir\'s trip to Italy in 1881-82, which inspired him to unite the \'grandeur and simplicity\' he admired in Renaissance art with the luminosity of Impressionism. His new approach, which he called his \'dry\' manner, is evident in Aline\'s face, with its carefully drawn features and smooth handling of paint. The medley of quick strokes in the background, however, displays the freer technique of Renoir\'s earlier years.','Renoir likely painted this work in his studio, posing his model and future wife, Aline Charigot, in a wicker chair. ',1883,72,92,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":169,\"green\":156,\"blue\":126},\"web\":\"#A99C7E\",\"name\":\"Napa\"},{\"color\":{\"red\":136,\"green\":118,\"blue\":61},\"web\":\"#88763D\",\"name\":\"Corn Harvest\"},{\"color\":{\"red\":146,\"green\":159,\"blue\":187},\"web\":\"#929FBB\",\"name\":\"Rock Blue\"},{\"color\":{\"red\":44,\"green\":52,\"blue\":73},\"web\":\"#2C3449\",\"name\":\"Bunting\"},{\"color\":{\"red\":77,\"green\":91,\"blue\":32},\"web\":\"#4D5B20\",\"name\":\"Army Green\"},{\"color\":{\"red\":204,\"green\":192,\"blue\":163},\"web\":\"#CCC0A3\",\"name\":\"Double Spanish White\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (515,120,6,'120030','Portrait of a Young Man',1,'http://www.metmuseum.org/art/collection/search/435802','29.100.16','Open Access for Scholarly Content','This portrait, among Bronzino\'s most arresting, was painted in the 1530s. The sitter is not known, but he must have belonged to Bronzino\'s close circle of literary friends in Florence, a number of whom sat for the artist. Bronzino himself composed verses in the style of the great Florentine poet Petrarch (1304-74), and the fanciful and witty details in this picture: the carved grotesque heads on the table and chair and the masklike face suggested in the folds of the youth\'s breeches would have been appreciated by writers as comments on masks and identity. The book is doubtless a collection of poems. For a technical study of the changes Bronzino made to the painting as he worked see metmuseum.org/collections.','This portrait, among Bronzino\'s most arresting, was painted in the 1530s. The sitter is not known, but he must have belonged to Bronzino\'s close circle of literary friends in Florence, a number of whom sat for the artist.',1530,75,96,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":55,\"green\":51,\"blue\":47},\"web\":\"#37332F\",\"name\":\"Acadia\"},{\"color\":{\"red\":85,\"green\":82,\"blue\":74},\"web\":\"#55524A\",\"name\":\"Dune\"},{\"color\":{\"red\":98,\"green\":87,\"blue\":66},\"web\":\"#625742\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":63,\"green\":39,\"blue\":42},\"web\":\"#3F272A\",\"name\":\"Havana\"},{\"color\":{\"red\":136,\"green\":115,\"blue\":65},\"web\":\"#887341\",\"name\":\"Shadow\"},{\"color\":{\"red\":171,\"green\":140,\"blue\":119},\"web\":\"#ab8c77\",\"name\":\"Sandrift\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (516,105,32,'105130','Self Portrait',3,'https://www.mauritshuis.nl/en/explore/the-collection/artworks/selfportrait-840/','840','Private Use Only','No seventeenth-century artist made as many self-portraits as Rembrandt did. This self-portrait dates from 1669, the year Rembrandt died, so it may be the last he painted. The expressive freedom of style shows that Rembrandt was certainly not exhausted at the end of his life. The way he painted the face with strong brushstrokes is remarkable. With thick layers of paint that are almost modelled, Rembrandt suggests a man of flesh and blood. This is a true masterpiece.','This self-portrait dates from 1669, the year Rembrandt died, so it may be the last he painted.',1669,60,65,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":23,\"green\":18,\"blue\":13},\"web\":\"#17120D\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":60,\"green\":46,\"blue\":31},\"web\":\"#3C2E1F\",\"name\":\"Cola\"},{\"color\":{\"red\":58,\"green\":46,\"blue\":37},\"web\":\"#2B1D12\",\"name\":\"Cocoa Brown\"},{\"color\":{\"red\":95,\"green\":78,\"blue\":59},\"web\":\"#5F4E3B\",\"name\":\"Rock\"},{\"color\":{\"red\":73,\"green\":44,\"blue\":28},\"web\":\"#492C1C\",\"name\":\"Morocco Brown\"},{\"color\":{\"red\":106,\"green\":75,\"blue\":56},\"web\":\"#6A4B38\",\"name\":\"Jambalaya\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (517,127,32,'127030','View of Haarlem with Bleaching Grounds',3,'https://www.mauritshuis.nl/en/explore/the-collection/artworks/view-of-haarlem-with-bleaching-grounds-155','155','Private Use Only','In this painting, Van Ruisdael captured the essence of the Dutch landscape. From a high dune, we look out over the flat land in the direction of Haarlem, the city in the distance. Above the city stretches an immense sky with clouds drifting by.','In this painting, Van Ruisdael captured the essence of the Dutch landscape.',1675,62,55,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":137,\"green\":143,\"blue\":142},\"web\":\"#898f8e\",\"name\":\"Oslo Grey\"},{\"color\":{\"red\":50,\"green\":45,\"blue\":31},\"web\":\"#322d1f\",\"name\":\"Graphite\"},{\"color\":{\"red\":144,\"green\":172,\"blue\":194},\"web\":\"#90acc2\",\"name\":\"Nepal\"},{\"color\":{\"red\":187,\"green\":186,\"blue\":175},\"web\":\"#bbbaaf\",\"name\":\"Mist Grey\"},{\"color\":{\"red\":142,\"green\":128,\"blue\":87},\"web\":\"#8e8057\",\"name\":\"Clay Creek\"},{\"color\":{\"red\":103,\"green\":68,\"blue\":31},\"web\":\"#67441f\",\"name\":\"Dark Brown\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (518,110,24,'110050','Women in Blue',1,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/38759/?lng=en','3509','Personal non-commercial use','Gainsborough\'s portrait of this unknown lady is rightly regarded as one of the most charming and excellent works in the Hermitage collection of English painting. Although the artist did not in fact like painting portraits, preferring to work on landscapes, it is for his portraits that he was best loved and is best known today. Here he created an image of great elegance and beauty, a painting dominated by a mood of romantic dreaminess. The light, mobile, melting brushstrokes convey the soft skin, the greyish-blue silk of the shawl, and the luxuriant feather of the headdress which surmounts the powdered wig. Free, sketchy painting is combined with fine transitions of colour to create an effect something akin to pastel. Gainsborough\'s style was noted and much admired by contemporaries, and even his great rival, the President of the Royal Academy, Sir Joshua Reynolds, admitted his skill.','Here Gainsborough created an image of great elegance and beauty, a painting dominated by a mood of romantic dreaminess.',1781,63,76,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":60,\"green\":46,\"blue\":30},\"web\":\"#3C2E1E\",\"name\":\"Cola\"},{\"color\":{\"red\":210,\"green\":191,\"blue\":172},\"web\":\"#D2BFAC\",\"name\":\"Bone\"},{\"color\":{\"red\":169,\"green\":153,\"blue\":133},\"web\":\"#A99985\",\"name\":\"Malta\"},{\"color\":{\"red\":132,\"green\":119,\"blue\":100},\"web\":\"#847764\",\"name\":\"Sand Dune\"},{\"color\":{\"red\":112,\"green\":130,\"blue\":133},\"web\":\"#708285\",\"name\":\"Regent Grey\"},{\"color\":{\"red\":50,\"green\":75,\"blue\":88},\"web\":\"#324b58\",\"name\":\"Arapawa\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (519,17,7,'017080','The Bridge at Argenteuil',2,'https://www.nga.gov/collection/art-object-page.61374.html','1983.1.24','Personal non-commercial use','From a distance of ten feet or so, Monet\'s brushstrokes blend to yield a convincing view of the Seine and the pleasure boats that drew tourists to Argenteuil. Up close, however, each dab of paint is distinct, and the scene dissolves into a mosaic of paint—brilliant, unblended tones of blue, red, green, yellow. In the water, quick, fluid skips of the brush mimic the lapping surface. In the trees, thicker paint is applied with denser, stubbier strokes. The figure in the sailboat is only a ghostly wash of dusty blue, the women rowing nearby are indicated by mere shorthand.','From a distance of ten feet or so, Monet\'s brushstrokes blend to yield a convincing view of the Seine and the pleasure boats that drew tourists to Argenteuil.',1874,98,78,'Oil on canvas',700.0000,900.0000,'https://artsandculture.google.com/asset/the-bridge-at-argenteuil/CQGVAX9Xla6sag',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":163,\"green\":155,\"blue\":122},\"web\":\"#A39B7A\",\"name\":\"Tallow\"},{\"color\":{\"red\":79,\"green\":86,\"blue\":80},\"web\":\"#4F5650\",\"name\":\"Nandor\"},{\"color\":{\"red\":109,\"green\":174,\"blue\":193},\"web\":\"#6DAEC1\",\"name\":\"Glacier\"},{\"color\":{\"red\":125,\"green\":123,\"blue\":95},\"web\":\"#7D7B5F\",\"name\":\"Kokoda\"},{\"color\":{\"red\":174,\"green\":156,\"blue\":100},\"web\":\"#AE9C64\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":109,\"green\":119,\"blue\":112},\"web\":\"#6D7770\",\"name\":\"Sirocco\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (520,7,24,'007003','Lion Hunt in Morocco',3,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/37102/?lng=en','3853','Personal non-commercial use','Delacroix took the subject for this painting from his recollections of the journey through Morocco in 1832. In the foreground he depicted two hunters - a man and a youth - beneath the luxurious crown of a tree, as well as two Arabs in the background with a horse. The outlines of the figures and the rock, the twisted trunks of the trees create a sense of tension. The rifle in the hands of one of the hunters and the unsheathed sabre lying on the ground emphasize that things are coming to an end. The dramatism so typical of Romanticism is created here by energetic brushstrokes and the contrast of complementary colours - red and green, blue and orange - and light and dark patches: the dark green foliage and shaded rock seem to be more tangible in contrast with the sky and the mountain stream.','Delacroix took the subject for this painting from his recollections of the journey through Morocco in 1832.',1854,92,74,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":2,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":26,\"green\":21,\"blue\":19},\"web\":\"#1A1513\",\"name\":\"Wood Bark\"},{\"color\":{\"red\":145,\"green\":18,\"blue\":23},\"web\":\"#911217\",\"name\":\"Carmine\"},{\"color\":{\"red\":115,\"green\":70,\"blue\":25},\"web\":\"#734619\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":136,\"green\":119,\"blue\":64},\"web\":\"#887740\",\"name\":\"Shadow\"},{\"color\":{\"red\":225,\"green\":196,\"blue\":105},\"web\":\"#E1C469\",\"name\":\"Chenin\"},{\"color\":{\"red\":140,\"green\":170,\"blue\":128},\"web\":\"#8CAA80\",\"name\":\"Amulet\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (521,21,24,'021080','Smoker',1,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/28720/?lng=en','6561','Personal non-commercial use','One of a whole series of pictures of smokers and card players, this excellent work was painted in the artist\'s studio. The prototypes for such figures appeared in the paintings of the Old Masters back in the 17th century, but here there is no subject, no narrative interest. Nor is there any sense of a genre, despite the prosaic nature of the motif. The calm, solid pose, the generalised face without any gestures or expression, the monumental figure, all give the image a classical majesty. The integrity of human nature is captured in three-dimensional forms.','One of a whole series of pictures of smokers and card players, this excellent work was painted in the artist\'s studio.',1892,73,92,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":159,\"green\":153,\"blue\":162},\"web\":\"#9F99A2\",\"name\":\"Amethyst Smoke\"},{\"color\":{\"red\":118,\"green\":66,\"blue\":27},\"web\":\"#76421B\",\"name\":\"Peru Tan\"},{\"color\":{\"red\":81,\"green\":43,\"blue\":27},\"web\":\"#512B1B\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":43,\"green\":49,\"blue\":66},\"web\":\"#2B3142\",\"name\":\"Bunting\"},{\"color\":{\"red\":76,\"green\":83,\"blue\":105},\"web\":\"#4C5369\",\"name\":\"East bay\"},{\"color\":{\"red\":108,\"green\":115,\"blue\":139},\"web\":\"#6C738B\",\"name\":\"Storm Grey\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (522,19,7,'019160','Farmhouse in Provence',2,'https://www.nga.gov/collection/art-object-page.52178.html','1970.17.34','Open Access','Pairs of complementary colors—the red and green of the plants, the woven highlights of oranges and blue in the fence, even the pink clouds that enliven the turquoise sky—shimmer and seem almost to vibrate against each other. The impressionists used this technique to enhance the luminosity of their pictures. Pissarro, who helped introduce Van Gogh to these concepts, noted, \"if I didn\'t know how colors behaved from the researches of...scientists, we [the impressionists] would not have been able to pursue our study of light with so much confidence.\"','Pairs of complementary colors—the red and green of the plants, the woven highlights of oranges and blue in the fence, even the pink clouds that enliven the turquoise sky—shimmer and seem almost to vibrate against each other. ',1888,61,46,'Oil on canvas',700.0000,900.0000,NULL,NULL,'https://en.wikipedia.org/wiki/Farmhouse_in_Provence','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":178,\"green\":149,\"blue\":58},\"web\":\"#B2953A\",\"name\":\"Roti\"},{\"color\":{\"red\":139,\"green\":120,\"blue\":61},\"web\":\"#8B783D\",\"name\":\"Corn Harvest\"},{\"color\":{\"red\":140,\"green\":152,\"blue\":172},\"web\":\"#8C98AC\",\"name\":\"Rock Blue\"},{\"color\":{\"red\":70,\"green\":91,\"blue\":57},\"web\":\"#465B39\",\"name\":\"Dell\"},{\"color\":{\"red\":153,\"green\":209,\"blue\":204},\"web\":\"#99D1CC\",\"name\":\"Morning Glory\"},{\"color\":{\"red\":156,\"green\":123,\"blue\":37},\"web\":\"#9C7B25\",\"name\":\"Hacienda\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (523,142,82,'142060','Portrait of Wally Neuzil',2,'http://www.leopoldmuseum.org/en/leopoldcollection/masterpieces/33','453','&copy; Leopold Museum','This woman nicknamed Wally, gazing out of the painting with wide-open, outsized eyes, was of enormous importance to the young Schiele.The portrait, of balanced composition, is a counterpart to the Self-Portrait with Chinese Lantern Fruit, which the artist created around the same time.When Schiele was taken into investigative custody in April 1912, she brought him painting supplies and an orange which, as Schiele noted in his diary, represented his “sole light” during these dark days.The main charge which he faced—abduction of a minor—proved groundless, but the court even so proceeded to convict him of the “distribution of indecent drawings.”Schiele was to spend a total of 24 days in prison, during which he painted several sketches.','The portrait, of balanced composition, is a counterpart to the Self-Portrait with Chinese Lantern Fruit, which the artist created around the same time.',1912,40,32,'Oil on wood',700.0000,900.0000,'https://artsandculture.google.com/asset/portrait-of-wally-neuzil/YQHhoShdZHB5rg',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":181,\"green\":162,\"blue\":133},\"web\":\"#B5A285\",\"name\":\"Pavlova\"},{\"color\":{\"red\":43,\"green\":45,\"blue\":39},\"web\":\"#2B2D27\",\"name\":\"Rangoon Green\"},{\"color\":{\"red\":122,\"green\":72,\"blue\":39},\"web\":\"#7A4827\",\"name\":\"Bull Shot\"},{\"color\":{\"red\":216,\"green\":174,\"blue\":145},\"web\":\"#D8AE91\",\"name\":\"Cashmere\"},{\"color\":{\"red\":21,\"green\":98,\"blue\":42},\"web\":\"#15622a\",\"name\":\"Crusoe\"},{\"color\":{\"red\":187,\"green\":47,\"blue\":30},\"web\":\"#bb2f1e\",\"name\":\"Fire Brick\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (524,128,42,'128030','Digging Sand, or The Sand Cart',2,'https://www.brooklynmuseum.org/opencollection/objects/64506','51.13','Creative Commons - Attribution',NULL,NULL,1875,81,56,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":61,\"green\":53,\"blue\":34},\"web\":\"#3D3522\",\"name\":\"Mikado\"},{\"color\":{\"red\":90,\"green\":79,\"blue\":54},\"web\":\"#5A4F36\",\"name\":\"West Coast\"},{\"color\":{\"red\":132,\"green\":123,\"blue\":100},\"web\":\"#847B64\",\"name\":\"Arrowtown\"},{\"color\":{\"red\":36,\"green\":30,\"blue\":16},\"web\":\"#241E10\",\"name\":\"Maire\"},{\"color\":{\"red\":150,\"green\":144,\"blue\":121},\"web\":\"#969079\",\"name\":\"Gurkha\"},{\"color\":{\"red\":56,\"green\":49,\"blue\":39},\"web\":\"#383127\",\"name\":\"Creole\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (525,29,22,'029050','Fritza Riedler',1,'http://digital.belvedere.at/objects/2177/fritza-riedler','3379','Private use',NULL,NULL,1906,133,153,'Oil on canvas',2200.0000,2700.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":136,\"green\":71,\"blue\":62},\"web\":\"#88473E\",\"name\":\"Matrix\"},{\"color\":{\"red\":153,\"green\":145,\"blue\":142},\"web\":\"#99918e\",\"name\":\"Zorba\"},{\"color\":{\"red\":101,\"green\":72,\"blue\":66},\"web\":\"#654842\",\"name\":\"Congo Brown\"},{\"color\":{\"red\":152,\"green\":114,\"blue\":78},\"web\":\"#98724e\",\"name\":\"Pale Brown\"},{\"color\":{\"red\":78,\"green\":79,\"blue\":111},\"web\":\"#4e4f6f\",\"name\":\"Corn Flower Blue\"},{\"color\":{\"red\":198,\"green\":190,\"blue\":185},\"web\":\"#C6BEB9\",\"name\":\"Pale Slate\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (526,133,22,'133010','Anna Bayer, the Artist\'s 2nd Wife',1,'http://digital.belvedere.at/objects/5997/anna-bayer-die-zweite-gattin-des-kunstlers','291','Private use',NULL,NULL,1850,55,68,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":50,\"green\":45,\"blue\":49},\"web\":\"#322D31\",\"name\":\"Melanzane\"},{\"color\":{\"red\":137,\"green\":58,\"blue\":66},\"web\":\"#893A42\",\"name\":\"Stiletto\"},{\"color\":{\"red\":222,\"green\":195,\"blue\":128},\"web\":\"#DEC380\",\"name\":\"Chalky\"},{\"color\":{\"red\":93,\"green\":80,\"blue\":82},\"web\":\"#5D5052\",\"name\":\"Don Juan\"},{\"color\":{\"red\":73,\"green\":44,\"blue\":47},\"web\":\"#492C2F\",\"name\":\"Cab Sav\"},{\"color\":{\"red\":103,\"green\":72,\"blue\":75},\"web\":\"#67484B\",\"name\":\"Don Juan\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (527,133,22,'133020','Self Portrait as a Young Man',1,'http://digital.belvedere.at/objects/7921/selbstportrat-in-jungen-jahren','2121','Private use',NULL,NULL,1828,75,95,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":59,\"green\":50,\"blue\":21},\"web\":\"#3B3215\",\"name\":\"Mikado\"},{\"color\":{\"red\":31,\"green\":27,\"blue\":23},\"web\":\"#1F1B17\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":84,\"green\":131,\"blue\":153},\"web\":\"#548399\",\"name\":\"Hippie Blue\"},{\"color\":{\"red\":97,\"green\":81,\"blue\":29},\"web\":\"#61511D\",\"name\":\"Bronze Olive\"},{\"color\":{\"red\":107,\"green\":153,\"blue\":171},\"web\":\"#6B99AB\",\"name\":\"Shakespeare\"},{\"color\":{\"red\":169,\"green\":137,\"blue\":71},\"web\":\"#a98947\",\"name\":\"Luxor Gold\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (528,133,22,'133030','Prince Esterházy\'s Councillor Mathias Kerzmann with his Second Wife',1,'http://digital.belvedere.at/objects/536/der-furstlich-esterhazysche-rat-mathias-kerzmann-mit-seiner','1521','Private use',NULL,NULL,1835,158,205,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":99,\"green\":82,\"blue\":60},\"web\":\"#63523C\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":170,\"green\":153,\"blue\":134},\"web\":\"#AA9986\",\"name\":\"Malta\"},{\"color\":{\"red\":162,\"green\":157,\"blue\":153},\"web\":\"#A29D99\",\"name\":\"Zorba\"},{\"color\":{\"red\":138,\"green\":158,\"blue\":184},\"web\":\"#8A9EB8\",\"name\":\"Rock Blue\"},{\"color\":{\"red\":189,\"green\":145,\"blue\":79},\"web\":\"#bd914f\",\"name\":\"Tussock\"},{\"color\":{\"red\":110,\"green\":54,\"blue\":42},\"web\":\"#6e362a\",\"name\":\"Mocha\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (529,19,29,'019140','The Bedroom',3,'https://www.vangoghmuseum.nl/en/collection/s0047V1962','s0047V1962','Non commercial use','While he was in Arles, Van Gogh made this painting of his bedroom in the Yellow House. He prepared the room himself with simple furniture and with his own work on the wall. The bright colours were meant to express absolute \'repose\' or \'sleep\'. Research shows that the strongly contrasting colours we see in the work today are the result of discolouration over the years. The walls and doors, for instance, were originally purple rather than blue.','While he was in Arles, Van Gogh made this painting of his bedroom in the Yellow House. He prepared the room himself with simple furniture and with his own work on the wall. The bright colours were meant to express absolute \'repose\' or \'sleep\'. Research shows that the strongly contrasting colours we see in the work today are the result of discolouration over the years. The walls and doors, for instance, were originally purple rather than blue.',1888,91,72,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":187,\"green\":136,\"blue\":7},\"web\":\"#BB8807\",\"name\":\"Dark Goldenrod\"},{\"color\":{\"red\":135,\"green\":52,\"blue\":14},\"web\":\"#87340E\",\"name\":\"Saddle Brown\"},{\"color\":{\"red\":169,\"green\":113,\"blue\":23},\"web\":\"#A97117\",\"name\":\"Golden Brown\"},{\"color\":{\"red\":183,\"green\":192,\"blue\":196},\"web\":\"#b7c0c4\",\"name\":\"Heather\"},{\"color\":{\"red\":152,\"green\":168,\"blue\":197},\"web\":\"#98a8c5\",\"name\":\"Rock Blue\"},{\"color\":{\"red\":75,\"green\":99,\"blue\":82},\"web\":\"#4b6352\",\"name\":\"Mineral Green\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (530,19,29,'019150','Almond Blossom',3,'https://www.vangoghmuseum.nl/en/collection/s0176V1962','s0176V1962','Non commercial use','Large blossom branches like this against a blue sky were one of Van Gogh\'s favourite subjects. Almond trees flower early in the spring making them a symbol of new life. Van Gogh borrowed the subject, the bold outlines and the positioning of the tree in the picture plane from Japanese printmaking.','Large blossom branches like this against a blue sky were one of Van Gogh\'s favourite subjects. Almond trees flower early in the spring making them a symbol of new life. Van Gogh borrowed the subject, the bold outlines and the positioning of the tree in the picture plane from Japanese printmaking.',1890,92,73,'Oil on canvas',1200.0000,1900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":109,\"green\":161,\"blue\":152},\"web\":\"#6DA198\",\"name\":\"Juniper\"},{\"color\":{\"red\":83,\"green\":131,\"blue\":120},\"web\":\"#538378\",\"name\":\"Breaker Bay\"},{\"color\":{\"red\":84,\"green\":162,\"blue\":172},\"web\":\"#54A2AC\",\"name\":\"Cadet Blue\"},{\"color\":{\"red\":100,\"green\":129,\"blue\":96},\"web\":\"#648160\",\"name\":\"Hippie Green\"},{\"color\":{\"red\":72,\"green\":164,\"blue\":152},\"web\":\"#48A498\",\"name\":\"Gossamer\"},{\"color\":{\"red\":132,\"green\":159,\"blue\":125},\"web\":\"#849F7D\",\"name\":\"Amulet\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (531,103,24,'103020','Portrait of Elizabeth and Philadelphia Wharton',1,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/48240/?lng=en','533','Personal non-commercial use','Few artists have truly successfully depicted children, but Anthony van Dyck in this portrait of the daughters of Philip, 4th Lord Wharton, produced a genuinely appealing image. It was painted during the late, English period of the artist\'s career, and is executed well within the traditions of Western European official portraiture. The girls are shown posing statically against a very roughly indicated, generalised background, with just a hint of a decorative landscape. Dressed and coiffed a la mode, they look like true grown up ladies, the eldest holding herself importantly and with a sense of her own importance, just like a lady at court. The youngest gently holds her sister by the shoulder, frozen in the pose in which she has been stood by the artist. The official majesty of the formal portrait is softened by the little dog, surprised by his mistresses\' immobility, who scratches wonderingly at the eldest girl\'s dress with one paw. With its elegant colour scheme, dominated by cold pearly-grey and silver-blue, and the virtuoso skill in conveying the texture of fabrics and jewellery, van Dyck\'s painting yet manages to be a very gentle and informal image of two charming girls.','Anthony van Dyck in this portrait of the daughters of Philip, 4th Lord Wharton, produced a genuinely appealing image.',1640,130,162,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":66,\"green\":49,\"blue\":30},\"web\":\"#42311E\",\"name\":\"Clinker\"},{\"color\":{\"red\":23,\"green\":23,\"blue\":22},\"web\":\"#171716\",\"name\":\"Maire\"},{\"color\":{\"red\":146,\"green\":129,\"blue\":106},\"web\":\"#92816a\",\"name\":\"Squirrel\"},{\"color\":{\"red\":125,\"green\":123,\"blue\":113},\"web\":\"#7d7b71\",\"name\":\"Dove Grey\"},{\"color\":{\"red\":60,\"green\":84,\"blue\":85},\"web\":\"#3c5455\",\"name\":\"Oracle\"},{\"color\":{\"red\":201,\"green\":188,\"blue\":181},\"web\":\"#c9bcb5\",\"name\":\"Pale Slate\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (532,103,24,'103030','Portrait of Henry Danvers, Earl of Danby',1,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/48262/?lng=en','545','Personal non-commercial use','From 1632 to 1641 van Dyck worked at the court of the English King Charles I, where he produced a marvellous serious of portraits of the English aristocracy, of which this is perhaps one of the most outstanding. Henry Danvers, Earl of Danby (1573-1644), was a member of the Privy Council, Keeper of the Royal Seal and founder of the first botanical garden in England, at Oxford. He was also a renowned military commander, having fought in Ireland, the Southern Netherlands and France. Here, the Earl is seen wearing the attire of a Knight of the Order of the Garter, to which he was elevated in 1633. By his left temple is a black patch, which must cover a scar. The energetic, wilful gesture of the right hand is evidence of his decisiveness, whilst the left hand resting on the sword indicates his watchfulness, necessary to one of the King\'s inner circle. The elegant pose, the rich picturesqueness of the costume and the luxurious setting give the portrait a very official feel. Combining a true likeness of the sitter with a convincing impression of his character, this painting is also an important historical document.','From 1632 to 1641 van Dyck worked at the court of the English King Charles I, where he produced a marvellous serious of portraits of the English aristocracy, of which this is perhaps one of the most outstanding.',1638,130,223,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":162,\"green\":105,\"blue\":60},\"web\":\"#A2693C\",\"name\":\"Mai Tai\"},{\"color\":{\"red\":77,\"green\":40,\"blue\":27},\"web\":\"#4D281B\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":202,\"green\":188,\"blue\":155},\"web\":\"#CABC9B\",\"name\":\"Sisal\"},{\"color\":{\"red\":237,\"green\":224,\"blue\":193},\"web\":\"#EDE0C1\",\"name\":\"Double Pearl Lusta\"},{\"color\":{\"red\":234,\"green\":184,\"blue\":159},\"web\":\"#EAB89F\",\"name\":\"Wax Flower\"},{\"color\":{\"red\":126,\"green\":76,\"blue\":36},\"web\":\"#7E4C24\",\"name\":\"Korma\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (533,103,27,'103040','Portrait of Agostino Pallavicini',1,'http://www.getty.edu/art/collection/objects/524/anthony-van-dyck-portrait-of-agostino-pallavicini-flemish-about-1621/','68.PA.2','Public domain','Agostino Pallavicini, a member of the Genoese branch of the Pallavicini family and the future doge of Genoa, sits enveloped by the sumptuous, flowing red robes worn in his role as ambassador to the Pope. The wide expanse of fabric, spectacularly rendered, seems to have a life of its own and almost threatens to take over the painting. The luxurious swirl of cloth, its brilliant sheen, and the way it glimmers and reflects light display Anthony van Dyck\'s virtuosity as a painter. The family coat of arms seen on the drapery behind the sitter at the left, along with other documented portraits, firmly establishes Pallavicini\'s identity.','Agostino Pallavicini, a member of the Genoese branch of the Pallavicini family and the future doge of Genoa, sits enveloped by the sumptuous, flowing red robes worn in his role as ambassador to the Pope.',1621,141,216,'Oil on canvas',900.0000,1000.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":109,\"green\":19,\"blue\":4},\"web\":\"#6D1304\",\"name\":\"Maroon\"},{\"color\":{\"red\":193,\"green\":142,\"blue\":123},\"web\":\"#C18E7B\",\"name\":\"Brandy Rose\"},{\"color\":{\"red\":102,\"green\":93,\"blue\":83},\"web\":\"#665d53\",\"name\":\"Makara \"},{\"color\":{\"red\":87,\"green\":18,\"blue\":10},\"web\":\"#BB5D45\",\"name\":\"Flame Pea\"},{\"color\":{\"red\":79,\"green\":41,\"blue\":26},\"web\":\"#57120A\",\"name\":\"Red Oxide\"},{\"color\":{\"red\":187,\"green\":70,\"blue\":52},\"web\":\"#BB4634\",\"name\":\"Grenadier\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (534,18,24,'018100','Sacred Spring: Sweet Dreams',2,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/28178/?lng=en','6510','Personal non-commercial use','Gauguin returned from his first stay in Tahiti (1891-1893) to spend nearly two years in Paris, where he painted this work. The exotic world of Oceania had captured the artist\'s imagination with its harmony of man and nature, with what he saw as the preservation of primitive simplicity. This work captures his recollections of Tahiti and his romantic dreams of the harmony of all on earth. The Tahitian girls symbolise different stages in life. The young islander with the halo above her head, deep in sleep, is the embodiment of virgin purity, while the second girl with the fruit in her hand, ready to take a bite, is like Eve. In the depths of the landscape islanders are dancing around an idol, some mysterious ancient god. The canvas reveals the artist\'s very individual style with its pure colours applied in generalised flat areas which, like the lines, are subjugated to a single rhythm.','Gauguin returned from his first stay in Tahiti (1891-1893) to spend nearly two years in Paris, where he painted this work.',1894,100,74,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":93,\"green\":82,\"blue\":57},\"web\":\"#5D5239\",\"name\":\"West Coast\"},{\"color\":{\"red\":145,\"green\":57,\"blue\":33},\"web\":\"#913921\",\"name\":\"Fire\"},{\"color\":{\"red\":41,\"green\":51,\"blue\":75},\"web\":\"#29334B\",\"name\":\"Bunting\"},{\"color\":{\"red\":176,\"green\":141,\"blue\":149},\"web\":\"#B08D95\",\"name\":\"Viola\"},{\"color\":{\"red\":149,\"green\":99,\"blue\":56},\"web\":\"#956338\",\"name\":\"McKenzie\"},{\"color\":{\"red\":123,\"green\":78,\"blue\":39},\"web\":\"#7B4E27\",\"name\":\"Korma\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (535,17,24,'017090','Haystack at Giverny',2,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/28486/?lng=en','6563','Personal non-commercial use','Most of the second half of Monet\'s life was spent in and around Giverny, where the leader of the Impressionists was particularly drawn by the landscape of central France. He captured views of Giverny in numerous canvases. A year before he painted this work in 1886, Monet had already shown a field of poppies (\"Poppy Field\", 1885; Paul Mellon Collection, USA), but without the haystack. The Hermitage work is one of the first of his paintings to show the haystack, which was to be the subject of whole series of works. Monet in virtuoso style captures the fine nuances of effects of light and air, picking the very moment at which the weather is changing and the horizon brightening on an overcast, windy day. The Impressionists painted such overcast weather with bright, light colours, which enabled them to capture the translucent sky and bring out the endlessly rich nuances of colour.','The Hermitage work is one of the first of his paintings to show the haystack, which was to be the subject of whole series of works.',1886,81,60,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":200,\"green\":189,\"blue\":188},\"web\":\"#C8BDBC\",\"name\":\"Silver\"},{\"color\":{\"red\":169,\"green\":155,\"blue\":97},\"web\":\"#A99B61\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":103,\"green\":124,\"blue\":82},\"web\":\"#677C52\",\"name\":\"Willow Grove\"},{\"color\":{\"red\":42,\"green\":55,\"blue\":54},\"web\":\"#2A3736\",\"name\":\"Aztec\"},{\"color\":{\"red\":189,\"green\":139,\"blue\":92},\"web\":\"#bd8b5c\",\"name\":\"Twine\"},{\"color\":{\"red\":208,\"green\":131,\"blue\":88},\"web\":\"#d08358\",\"name\":\"Burning Sand\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (536,117,2,'117020','The Creation',5,'https://www.museodelprado.es/coleccion/obra-de-arte/la-creacion/b5cb7209-0009-4b8f-ab20-d6db0617a9fa','P02053','Private, personal, academic, research or educational',NULL,NULL,1495,77,188,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":162,\"green\":149,\"blue\":97},\"web\":\"#A29561\",\"name\":\"Gurkha\"},{\"color\":{\"red\":73,\"green\":94,\"blue\":82},\"web\":\"#495E52\",\"name\":\"Feldgrau\"},{\"color\":{\"red\":161,\"green\":149,\"blue\":112},\"web\":\"#A19570\",\"name\":\"Tallow\"},{\"color\":{\"red\":186,\"green\":137,\"blue\":99},\"web\":\"#BA8963\",\"name\":\"Twine\"},{\"color\":{\"red\":146,\"green\":158,\"blue\":124},\"web\":\"#929E7C\",\"name\":\"Sage\"},{\"color\":{\"red\":82,\"green\":78,\"blue\":48},\"web\":\"#524E30\",\"name\":\"Thatch Green\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (537,117,5,'117030','Christ Crowned with Thorns',1,'https://www.nationalgallery.org.uk/paintings/hieronymus-bosch-christ-mocked-the-crowning-with-thorns','NG474','Private, personal, academic, research or educational','Four torturers surround Christ, pressing towards him, while he looks out at us. Bosch\'s picture emphasises the contrast between the brutality of the tormentors and the mild, suffering Christ. Its emotional intensity is achieved in a variety of ways. The half-length figures create a sense of proximity, and the lack of recession in the painting makes it appear very claustrophobic. From the centre of the picture Christ seems to appeal to us to share in his suffering.','Bosch\'s picture emphasises the contrast between the brutality of the tormentors and the mild, suffering Christ.',1495,59,74,'Oil on canvas',700.0000,900.0000,'https://artsandculture.google.com/asset/christ-mocked-the-crowning-with-thorns/tgEYBOMT1BeBzw',NULL,'https://en.wikipedia.org/wiki/Christ_Crowned_with_Thorns_(Bosch,_London)','{\"safeSearchAnnotation\":{\"violence\":3,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":56,\"green\":49,\"blue\":22},\"web\":\"#383116\",\"name\":\"Mikado\"},{\"color\":{\"red\":168,\"green\":156,\"blue\":127},\"web\":\"#A89C7F\",\"name\":\"Napa\"},{\"color\":{\"red\":28,\"green\":26,\"blue\":22},\"web\":\"#1C1A16\",\"name\":\"Maire\"},{\"color\":{\"red\":79,\"green\":85,\"blue\":26},\"web\":\"#4F551A\",\"name\":\"Army Green\"},{\"color\":{\"red\":201,\"green\":150,\"blue\":132},\"web\":\"#c99684\",\"name\":\"Quicksand\"},{\"color\":{\"red\":163,\"green\":54,\"blue\":60},\"web\":\"#a3363c\",\"name\":\"Guardsman Red\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (538,104,2,'104040','The Crucified Christ',1,'https://www.museodelprado.es/en/the-collection/art-work/the-crucified-christ/72cbb57e-f622-4531-9b25-27ff0a9559d7','P01167','Private, personal, academic, research or educational','Stylistically, this work appears to have been made in the early 1630s -soon after the artist returned from Italy- and most authors date it from around 1632. The Apollonian perfection of the anatomy and the figure`s pale complexion recall the neo-Attic character of Guido Reni\'s work, but it must have been Velazquez`s intention to imbue the figure with a divine and ineffable beauty, reflecting the belief that Christ was the most beautiful of men.','Stylistically, this work appears to have been made in the early 1630s -soon after the artist returned from Italy- and most authors date it from around 1632. The Apollonian perfection of the anatomy and the figure`s pale complexion recall the neo-Attic character of Guido Reni\'s work, but it must have been Velazquez`s intention to imbue the figure with a divine and ineffable beauty, reflecting the belief that Christ was the most beautiful of men.',1632,169,248,'Oil on canvas',1400.0000,1800.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":208,\"green\":191,\"blue\":154},\"web\":\"#D0BF9A\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":132,\"green\":86,\"blue\":49},\"web\":\"#845631\",\"name\":\"Korma\"},{\"color\":{\"red\":173,\"green\":156,\"blue\":122},\"web\":\"#AD9C7A\",\"name\":\"Bronco\"},{\"color\":{\"red\":137,\"green\":122,\"blue\":91},\"web\":\"#897A5B\",\"name\":\"Clay Creek\"},{\"color\":{\"red\":142,\"green\":97,\"blue\":61},\"web\":\"#8E613D\",\"name\":\"McKenzie\"},{\"color\":{\"red\":236,\"green\":221,\"blue\":190},\"web\":\"#ECDDBE\",\"name\":\"Double Pearl Lusta\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (539,8,2,'008020','The Parasol',2,'https://www.museodelprado.es/en/the-collection/art-work/the-parasol/a230a80f-a899-4535-9e90-ad883bd096c5','P00773','Private, personal, academic, research or educational','This tapestry cartoon depicts a young woman. She is sitting, with a dog on her lap, and is accompanied by a Majo who protects her from the sun with a parasol. This work\'s format and bottom-to-top perspective indicates that it was intended to hang over a window. It\'s pyramidal composition, with the figures in the foreground, reflects the influence of classical Italian painting on Goya, as well as his mastery at painting light and shadows. The resultant tapestry was intended to hang in the dining room of the Prince and Princess of Asturias (the future Carlos IV and his wife Maria Luisa de Parma) at the Monastery of El Escorial.','This tapestry cartoon depicts a young woman. She is sitting, with a dog on her lap, and is accompanied by a Majo who protects her from the sun with a parasol.',1777,152,104,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":156,\"green\":154,\"blue\":145},\"web\":\"#9c9a91\",\"name\":\"Dawn\"},{\"color\":{\"red\":66,\"green\":63,\"blue\":49},\"web\":\"#423f31\",\"name\":\"Woodrush\"},{\"color\":{\"red\":82,\"green\":95,\"blue\":67},\"web\":\"#525f43\",\"name\":\"Cabbage Pont\"},{\"color\":{\"red\":174,\"green\":141,\"blue\":71},\"web\":\"#ae8d47\",\"name\":\"Turmeric\"},{\"color\":{\"red\":144,\"green\":159,\"blue\":178},\"web\":\"#909FB2\",\"name\":\"Rock Blue\"},{\"color\":{\"red\":136,\"green\":138,\"blue\":97},\"web\":\"#888a61\",\"name\":\"Bitter\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (540,116,2,'116030','Self-Portrait',1,'https://www.museodelprado.es/en/the-collection/art-work/self-portrait/8417d190-eb9d-4c52-9c89-dcdcd0109b5b','P02179','Private, personal, academic, research or educational','In the same year that he published the Apocalipsis cum figuris, Durer painted himself as a gentleman, dressed in light toned clothes and looking his best. He wears an open black and white doublet with a striped cap in the same colours, an undershirt trimmed with gold and a silk cord of blue and white threads holding up a grey-brown cloak that falls over his right shoulder. Durer has sheathed the hands that he uses to paint in grey kidskin gloves indicative of high rank with the aim of elevating his social status from that of craftsman to artist and of locating painting among the liberal arts, as in Italy.','In the same year that he published the Apocalipsis cum figuris, Durer painted himself as a gentleman, dressed in light toned clothes and looking his best. ',1498,41,52,'Oil on panel',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":95,\"green\":81,\"blue\":58},\"web\":\"#5F513A\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":57,\"green\":47,\"blue\":41},\"web\":\"#392F29\",\"name\":\"Sambuca\"},{\"color\":{\"red\":168,\"green\":154,\"blue\":121},\"web\":\"#A89A79\",\"name\":\"Tallow\"},{\"color\":{\"red\":132,\"green\":118,\"blue\":92},\"web\":\"#84765C\",\"name\":\"Stonewall\"},{\"color\":{\"red\":198,\"green\":182,\"blue\":145},\"web\":\"#C6B691\",\"name\":\"Akaroa\"},{\"color\":{\"red\":118,\"green\":118,\"blue\":110},\"web\":\"#76766E\",\"name\":\"Tapa\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (541,134,2,'134010','The Descent from the Cross',2,'https://www.museodelprado.es/en/the-collection/art-work/the-descent-from-the-cross/856d822a-dd22-4425-bebd-920a1d416aa7','P02825','Private, personal, academic, research or educational','The Deposition was painted for the chapel of Our Lady outside the walls of Louvain, which was founded in the fourteenth century by the guild of bowmen, sold in 1798 and demolished shortly thereafter. The occupation of the founders is indicated by the two small crossbows hanging on the tracery of the two major corners of the table.','The Descent from the Cross was painted for the Chapel of Our Lady Outside the Walls at Leuven',1443,261,204,'Oil on panel',2700.0000,3900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":64,\"green\":86,\"blue\":109},\"web\":\"#40566D\",\"name\":\"Chambray\"},{\"color\":{\"red\":66,\"green\":53,\"blue\":30},\"web\":\"#42351E\",\"name\":\"Mikado\"},{\"color\":{\"red\":130,\"green\":115,\"blue\":87},\"web\":\"#827357\",\"name\":\"Shadow\"},{\"color\":{\"red\":49,\"green\":49,\"blue\":47},\"web\":\"#31312F\",\"name\":\"El Paso\"},{\"color\":{\"red\":122,\"green\":58,\"blue\":49},\"web\":\"#7a3a31\",\"name\":\"Crown Of Thorns\"},{\"color\":{\"red\":179,\"green\":145,\"blue\":67},\"web\":\"#b39143\",\"name\":\"Turmeric\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (542,134,27,'134020','Portrait of Isabella of Portugal',1,'http://www.getty.edu/art/collection/objects/651/workshop-of-rogier-van-der-weyden-portrait-of-isabella-of-portugal-netherlandish-about-1450/','78.PB.3','Public domain','Seated with her hands crossed in her lap, Isabella of Portugal, the duchess of Burgundy, conveys the poise and confidence of her noble position. Her sumptuous attire, heavily woven with gold thread, and her jeweled fingers and headdress reflect her aristocratic status. Oddly, the artist did not match the patterns of the sleeves, as would have been customary during this period.','Seated with her hands crossed in her lap, Isabella of Portugal, the duchess of Burgundy, conveys the poise and confidence of her noble position.',1450,37,46,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/portrait-of-isabella-of-portugal/dQFnG1h6Jg1hYg?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":77,\"green\":42,\"blue\":21},\"web\":\"#4D2A15\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":176,\"green\":156,\"blue\":130},\"web\":\"#B09C82\",\"name\":\"Bronco\"},{\"color\":{\"red\":67,\"green\":50,\"blue\":31},\"web\":\"#43321F\",\"name\":\"Clinker\"},{\"color\":{\"red\":108,\"green\":69,\"blue\":47},\"web\":\"#6C452F\",\"name\":\"Jambalaya\"},{\"color\":{\"red\":133,\"green\":116,\"blue\":94},\"web\":\"#85745E\",\"name\":\"Cement\"},{\"color\":{\"red\":99,\"green\":27,\"blue\":20},\"web\":\"#631B14\",\"name\":\"Red Oxide\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (543,134,24,'134030','St Luke Drawing the Virgin',3,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/38861/?lng=en','419','Personal non-commercial use','The subject is taken from a 6th-century legend of Greek origin, according to which St Luke was the first ever to draw a portrait of the Virgin Mary. Artists saw Luke as the patron of their art. Rogier van der Weyden set the action in an open loggia. To the left, at the foot of a throne, sits the Virgin, feeding the Christ Child. The throne, hinting at her future status as the Queen of Heaven, is decorated with sculptural figures of Adam and Eve, indicating that Christ and the Virgin will atone for their Original Sin. Opposite the Madonna, St Luke has sunk respectfully to his knees as he seeks to capture her appearance. The artist manages to convey both Luke\'s trembling reverence and his concentration on his drawing. Behind St Luke we can just see a bull and a book, both traditional attributes of the Apostle Luke. Two figures contemplating the landscape from the battlements possibly represent Joachim and Anna, the Virgin\'s parents.','The subject is taken from a 6th-century legend of Greek origin, according to which St Luke was the first ever to draw a portrait of the Virgin Mary.',1445,108,102,'Oil on canvas',900.0000,1100.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":100,\"green\":76,\"blue\":42},\"web\":\"#644c2a\",\"name\":\"Dallas\"},{\"color\":{\"red\":111,\"green\":32,\"blue\":23},\"web\":\"#6f2017\",\"name\":\"Red Oxide\"},{\"color\":{\"red\":130,\"green\":103,\"blue\":45},\"web\":\"#82672d\",\"name\":\"Yukon Gold\"},{\"color\":{\"red\":200,\"green\":150,\"blue\":112},\"web\":\"#c89670\",\"name\":\"Fallow\"},{\"color\":{\"red\":246,\"green\":246,\"blue\":233},\"web\":\"#f6f6e9\",\"name\":\"Promenade\"},{\"color\":{\"red\":110,\"green\":111,\"blue\":97},\"web\":\"#6e6f61\",\"name\":\"Finch\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (544,102,2,'102020','The Three Graces',1,'https://www.museodelprado.es/en/the-collection/art-work/the-three-graces/145eadd9-0b54-4b2d-affe-09af370b6932','P01670','Private, personal, academic, research or educational','Ruben\'s depicts the three graces beside a fountain, under a garland of flowers in a landscape. The figures are based on classical sculpture, which is visible in the artist\'s effort to reproduce the coldness of marble in their flesh. The circular rhythm and elegant undulation are customary characteristics of this artist, along with the grandiloquent shapes and warm colors he brought into his painting in his final years. The figure on the left is directly inspired by his second wife, Helene Forment.','Ruben\'s depicts the three graces beside a fountain, under a garland of flowers in a landscape. The figures are based on classical sculpture, which is visible in the artist\'s effort to reproduce the coldness of marble in their flesh.',1635,182,220,'Oil on panel',1600.0000,1900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":5},\"dominantColors\":[{\"color\":{\"red\":62,\"green\":50,\"blue\":25},\"web\":\"#3E3219\",\"name\":\"Mikado\"},{\"color\":{\"red\":21,\"green\":14,\"blue\":8},\"web\":\"#150E08\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":95,\"green\":82,\"blue\":52},\"web\":\"#5F5234\",\"name\":\"West Coast\"},{\"color\":{\"red\":131,\"green\":115,\"blue\":86},\"web\":\"#837356\",\"name\":\"Shadow\"},{\"color\":{\"red\":211,\"green\":187,\"blue\":163},\"web\":\"#D3BBA3\",\"name\":\"Soft Amber\"},{\"color\":{\"red\":109,\"green\":124,\"blue\":148},\"web\":\"#6d7c94\",\"name\":\"Slate Grey\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (545,102,2,'102030','The Judgement of Paris',2,'https://www.museodelprado.es/en/the-collection/art-work/the-judgement-of-paris/918bc2de-00a9-480d-87ba-96ac25f22bf4','P01731','Private, personal, academic, research or educational','As Homer tells it in The Iliad, Paris the shepherd, son of Priam, had to decide with of the three goddesses -Juno, Venus or Minerva- was the most beautiful, and give her the golden apple Mercury he had received from Mercury. On the left, Paris appears to be meditating, with the apple still in his hands. His attention is focused on Venus, in the middle of the composition. Minerva\'s weapons are visible in the foreground. The setting and elegance of this work bear a clear relation to southern painting as a result of the artist\'s stay in Italy. The figures are based on classical sculptures and the influence of mannerist painting is visible in the sinuous rhythm of their anatomies. This work was first documented at Madrid\'s Alcaízar Palace in 1666.','As Homer tells it in The Iliad, Paris the shepherd, son of Priam, had to decide with of the three goddesses -Juno, Venus or Minerva- was the most beautiful, and give her the golden apple Mercury he had received from Mercury.',1608,114,89,'Oil on panel',900.0000,1100.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":102,\"green\":81,\"blue\":54},\"web\":\"#665136\",\"name\":\"Dallas\"},{\"color\":{\"red\":70,\"green\":52,\"blue\":29},\"web\":\"#46341D\",\"name\":\"Clinker\"},{\"color\":{\"red\":150,\"green\":112,\"blue\":84},\"web\":\"#967054\",\"name\":\"Pale Brown\"},{\"color\":{\"red\":112,\"green\":78,\"blue\":51},\"web\":\"#704E33\",\"name\":\"Old Copper\"},{\"color\":{\"red\":185,\"green\":147,\"blue\":117},\"web\":\"#B99375\",\"name\":\"Pale Taupe\"},{\"color\":{\"red\":97,\"green\":106,\"blue\":93},\"web\":\"#616a5d\",\"name\":\"Finlandia\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (546,118,18,'118040','The Tower of Babel',2,'https://www.khm.at/de/object/bc6dc48b74/','1026','Only for private use','Bruegel\'s monumental composition had several forerunners in Netherlandish painting, but his work became the most famous classic among the Tower of Babel depictions and was frequently copied in many different variations. The sense of scale is provided by the flemish-style port city, which is impressively tiny in comparison to the tower.','BruegelÔÇÖs monumental composition had several forerunners in Netherlandish painting, but his work became the most famous classic among the Tower of Babel depictions and was frequently copied in many different variations.',1563,155,114,'Oil on canvas',900.0000,1000.0000,'https://www.google.com/culturalinstitute/beta/asset/the-tower-of-babel/bAGKOdJfvfAhYQ?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":140,\"green\":118,\"blue\":90},\"web\":\"#8C765A\",\"name\":\"Cement\"},{\"color\":{\"red\":102,\"green\":84,\"blue\":60},\"web\":\"#66543C\",\"name\":\"Tobacco Brown\"},{\"color\":{\"red\":181,\"green\":154,\"blue\":109},\"web\":\"#B59A6D\",\"name\":\"Fallow\"},{\"color\":{\"red\":156,\"green\":108,\"blue\":87},\"web\":\"#9C6C57\",\"name\":\"Toast\"},{\"color\":{\"red\":115,\"green\":74,\"blue\":57},\"web\":\"#734A39\",\"name\":\"Old Copper\"},{\"color\":{\"red\":144,\"green\":151,\"blue\":161},\"web\":\"#9097a1\",\"name\":\"Grey Chateau\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (547,118,18,'118050','Children\'s Games',2,'https://www.khm.at/de/object/caf1a3dfb5/','1017','Only for private use','Children - more than 230 in all - are occupied with 83 different games. The whole city seems to be theirs. Bruegel gives the beholder an encyclopaedic view of the children\'s games of his time.','Children - more than 230 in all - are occupied with 83 different games. The whole city seems to be theirs. Bruegel gives the beholder an encyclopaedic view of the children\'s games of his time.',1560,161,118,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/children%E2%80%99s-games/CQEeZWQPOI2Yjg?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":179,\"green\":147,\"blue\":93},\"web\":\"#B3935D\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":148,\"green\":118,\"blue\":64},\"web\":\"#947640\",\"name\":\"Buttered Rum\"},{\"color\":{\"red\":174,\"green\":152,\"blue\":114},\"web\":\"#AE9872\",\"name\":\"Tallow\"},{\"color\":{\"red\":116,\"green\":76,\"blue\":27},\"web\":\"#744C1B\",\"name\":\"Raw Umber\"},{\"color\":{\"red\":154,\"green\":75,\"blue\":28},\"web\":\"#9a4b1c\",\"name\":\"Rich Gold\"},{\"color\":{\"red\":149,\"green\":169,\"blue\":139},\"web\":\"#95a98b\",\"name\":\"Mantle\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (548,118,18,'118060','Hunters in the Snow (Winter)',2,'https://www.khm.at/de/object/b83aac23b9/','1838','Only for private use','On top of the hill a group of hunters accompanied by a pack of dogs is seen, making their way back to the village below. Their catch is poor: a single fox dangling from the spear the hunter on the left carries on his shoulder. To the hunter\'s left, Bruegel added a motif that had been used for quite some time in book illumination for depicting the month of December: the preparations for singeing a pig over an open fire outside a building. The damaged sign hanging above them reveals the name of the inn: \"To the Deer\" a well-aimed passing shot. Entertaining details, such as the people ice-skating on the frozen lakes, have contributed to the painting\'s enormous popularity.','On top of the hill a group of hunters accompanied by a pack of dogs is seen, making their way back to the village below. Their catch is poor: a single fox dangling from the spear the hunter on the left carries on his shoulder.',1565,162,117,'Oil on canvas',900.0000,1150.0000,'https://www.google.com/culturalinstitute/beta/asset/hunters-in-the-snow-winter/WgFmzFNNN74nUg?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":163,\"green\":158,\"blue\":132},\"web\":\"#A39E84\",\"name\":\"Hillary\"},{\"color\":{\"red\":23,\"green\":21,\"blue\":15},\"web\":\"#17150F\",\"name\":\"Maire\"},{\"color\":{\"red\":103,\"green\":122,\"blue\":105},\"web\":\"#677A69\",\"name\":\"Laurel\"},{\"color\":{\"red\":238,\"green\":229,\"blue\":204},\"web\":\"#EEE5CC\",\"name\":\"Orange White\"},{\"color\":{\"red\":94,\"green\":87,\"blue\":62},\"web\":\"#5E573E\",\"name\":\"Millbrook\"},{\"color\":{\"red\":118,\"green\":67,\"blue\":9},\"web\":\"#764309\",\"name\":\"Raw Umber\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (549,134,18,'134040','Triptych: The Crucifixion',2,'https://www.khm.at/de/object/5a1e3a5aed/','901','Only for private use','Today this Crucifixion scene is spread across a winged altar, but it was probably originally a single panel, with the frame only painted on to it. Not long after it was created, however, the work was sawn into three parts, making the portraits of St. Mary Magdalene and St. Veronica wings of a triptych. Given its original condition, it makes van der Weyden\'s artistic innovation even more significant: for the first time he unites all of the participants- the Crucifixion group, saints and the donors - in front of a continuous landscape, in which an idealised Jerusalem appears on the horizon. The realism of such a unified space had never been attempted in earlier works. Unknown today, the patrons are separated only by a conspicuous fissure in the ground from the central subject of religious contemplation, a concept that was so progressive that it was initially attenuated in the paintings of the period that followed.','Today this Crucifixion scene is spread across a winged altar, but it was probably originally a single panel, with the frame only painted on to it. Not long after it was created, however, the work was sawn into three parts, making the portraits of St. Mary Magdalene and St. Veronica wings of a triptych. ',1444,131,101,'Oil on panel',2000.0000,2400.0000,'https://www.google.com/culturalinstitute/beta/asset/triptych-the-crucifixion/3gF9kN6BYvNuxw?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":104,\"green\":83,\"blue\":30},\"web\":\"#68531E\",\"name\":\"Horses Neck\"},{\"color\":{\"red\":71,\"green\":129,\"blue\":145},\"web\":\"#478191\",\"name\":\"Jelly Bean\"},{\"color\":{\"red\":20,\"green\":14,\"blue\":10},\"web\":\"#140E0A\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":166,\"green\":199,\"blue\":195},\"web\":\"#A6C7C3\",\"name\":\"Opal\"},{\"color\":{\"red\":140,\"green\":49,\"blue\":26},\"web\":\"#8C311A\",\"name\":\"Burnt Umber\"},{\"color\":{\"red\":138,\"green\":114,\"blue\":62},\"web\":\"#8A723E\",\"name\":\"Shadow\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (550,115,18,'115030','Cardinal Niccolo Albergati',1,'https://www.khm.at/de/object/fccb3cdc9a/','975','Only for private use','During a peace congress that was seeking to bring an end to decades of enmity between France and Burgundy, van Eyck painted portraits of some of those in attendance, among them, most likely, Cardinal Niccoli Albergati, who in his position as nuncio was one the most important participants in the negotiations. In Arras, van Eyck created a silverpoint drawing (Dresden, Staatliche Kunstsammlungen, Kupferstichkabinett), which most probably depicts the cardinal. Here the Flemish painter not only captured the physiognomy of the aged cleric but in his notes also specified the coloration.','During a peace congress that was seeking to bring an end to decades of enmity between France and Burgundy, van Eyck painted portraits of some of those in attendance, among them, most likely, Cardinal Niccoli Albergati, who in his position as nuncio was one the most important participants in the negotiations.',1435,34,29,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/kardinal-niccol%C3%B2-albergati/0AEB0A0Fyh6sBw?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":21,\"green\":20,\"blue\":17},\"web\":\"#151411\",\"name\":\"Maire\"},{\"color\":{\"red\":165,\"green\":44,\"blue\":15},\"web\":\"#a52c0f\",\"name\":\"Rust\"},{\"color\":{\"red\":190,\"green\":129,\"blue\":73},\"web\":\"#be8149\",\"name\":\"Brandy Punch\"},{\"color\":{\"red\":134,\"green\":34,\"blue\":11},\"web\":\"#86220b\",\"name\":\"Falu Red\"},{\"color\":{\"red\":173,\"green\":133,\"blue\":83},\"web\":\"#ad8553\",\"name\":\"Muddy Waters\"},{\"color\":{\"red\":40,\"green\":103,\"blue\":136},\"web\":\"#286788\",\"name\":\"Astral\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (551,116,18,'116050','Portrait of a Young Venetian Woman',1,'https://www.khm.at/de/object/f29c21d489/','6440','Only for private use','This honest, close-up view of a gentle face is in keeping with Venetian portraits of the time. The sandy hair of the unknown woman is held at the back of the head by a shining golden net, the prevailing fashion in Venice. Durer has used carefully distributed highlights to emphasise the curly hair falling to either side of the face; it has a formal counterpart in the fine ribbons of her dress. The fact that Durer left the preparatory underdrawing of the ribbon on the left has led to the assumption that the picture is unfinished, but technical analysis of the entire surface of the painting speaks against it. It makes sense from a compositional point of view: the colour of the one ribbon matches the woman\'s hair, while the other picks up the monochrome tone of the background and is also found in the young woman\'s dark eyes.','This honest, close-up view of a gentle face is in keeping with Venetian portraits of the time. The sandy hair of the unknown woman is held at the back of the head by a shining golden net, the prevailing fashion in Venice.',1505,24,32,'Oil on wood',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/portrait-of-a-young-venetian-woman/4QHm8iCbgjn1Og?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":12,\"green\":2,\"blue\":1},\"web\":\"#0C0201\",\"name\":\"Black\"},{\"color\":{\"red\":214,\"green\":190,\"blue\":149},\"web\":\"#D6BE95\",\"name\":\"Raffia\"},{\"color\":{\"red\":123,\"green\":70,\"blue\":28},\"web\":\"#7B461C\",\"name\":\"Russet\"},{\"color\":{\"red\":78,\"green\":37,\"blue\":19},\"web\":\"#4E2513\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":156,\"green\":107,\"blue\":56},\"web\":\"#9C6B38\",\"name\":\"Buttered Rum\"},{\"color\":{\"red\":132,\"green\":56,\"blue\":25},\"web\":\"#843819\",\"name\":\"Burnt Umber\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (552,101,18,'101050','The Crowning with Thorns',2,'https://www.khm.at/de/object/18997733ec/','307','Only for private use','With a complete command of anatomy, Caravaggio characterises the varied physical appearance of the protagonists. Christ\'s delicate skin is in obvious contrast to the bronzed appearance of his tormentors. His exposed, outstretched neck, which has been forced into a horizontal position, is a clear indication of the brutality of the action. Caravaggio uses decisive contrasts of light and dark to create a strong physical presence.','With a complete command of anatomy, Caravaggio characterises the varied physical appearance of the protagonists.',1603,166,127,'Oil on canvas',1200.0000,1400.0000,'https://www.google.com/culturalinstitute/beta/asset/the-crowning-with-thorns/yAGZLO5MaPVjfQ?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":3,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":62,\"green\":42,\"blue\":15},\"web\":\"#3E2A0F\",\"name\":\"Cocoa Brow\"},{\"color\":{\"red\":230,\"green\":180,\"blue\":121},\"web\":\"#E6B479\",\"name\":\"Corvette\"},{\"color\":{\"red\":113,\"green\":72,\"blue\":26},\"web\":\"#71481A\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":199,\"green\":151,\"blue\":96},\"web\":\"#C79760\",\"name\":\"Fallow\"},{\"color\":{\"red\":216,\"green\":160,\"blue\":98},\"web\":\"#d8a062\",\"name\":\"Porsche\"},{\"color\":{\"red\":107,\"green\":42,\"blue\":19},\"web\":\"#6b2a13\",\"name\":\"Baker\'s Chocolate\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (553,102,18,'102040','The Miracles of St. Francis Xavier',1,'https://www.khm.at/de/object/c7af0926b2/','519','Only for private use','Like a monument, the protagonist stands in a dark robe with deep folds on the plinth-like projection of a wall. Francis Xavier dominates the scene as the \'missionary to the Asian peoples\', his left hand pointing to Fides, the personification of faith, his right hand extended towards the toppling idols, and his gaze turned to the listeners and supplicants. Rubens has used dramatic lighting to stage the group of listeners and observers, who, keeping a respectful distance, are bathed in bright light. Standing in the shadows the armoured soldier creates an optical turning point in the composition, leading the gaze of the viewer to the actual miracle depicted: in the left foreground deathly pale figures are rising from their graves.','Like a monument, the protagonist stands in a dark robe with deep folds on the plinth-like projection of a wall. Francis Xavier dominates the scene as the \'missionary to the Asian peoples\', his left hand pointing to Fides, the personification of faith, his right hand extended towards the toppling idols, and his gaze turned to the listeners and supplicants.',1618,395,535,'Oil on canvas',2300.0000,2700.0000,'https://www.google.com/culturalinstitute/beta/asset/the-miracles-of-st-francis-xavier/mAG-VIH-g-_RNA?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":123,\"green\":116,\"blue\":93},\"web\":\"#7B745D\",\"name\":\"Pablo\"},{\"color\":{\"red\":96,\"green\":118,\"blue\":107},\"web\":\"#60766B\",\"name\":\"Sirocco\"},{\"color\":{\"red\":118,\"green\":72,\"blue\":34},\"web\":\"#764822\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":199,\"green\":149,\"blue\":98},\"web\":\"#C79562\",\"name\":\"Fallow\"},{\"color\":{\"red\":92,\"green\":86,\"blue\":62},\"web\":\"#5C563E\",\"name\":\"Millbrook\"},{\"color\":{\"red\":202,\"green\":192,\"blue\":163},\"web\":\"#CAC0A3\",\"name\":\"Sisal\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (554,126,18,'126030','Woman and Child with Serving Maid',2,'https://www.khm.at/de/object/c32d9bf27a/','5976','Only for private use',' De Hooch painted the present work during his time in Amsterdam (starting in 1660), where he specialised in depicting the style of home furnishings and life typical of the city\'s well-situated citizens. Despite the presence of a serving maid, the elegantly clad mother is caring personally for her infant; she does not waste money on a wet-nurse. Across the spotless tile floor, we look into a second room at the back, then through the half-open door to a house on a canal and the city beyond. A fire is burning on the hearth, providing a colourful accent that recurs in the infant\'s clothing and the sunlit view. In a similarly rhythmic fashion, the red of the fabric drying on the hearth is repeated at several points in the picture, giving the composition a balance of colour. This scene makes clear the understanding of (ideal) roles at the time: attentive childcare and a well-run household are a woman\'s province.','Despite the presence of a serving maid, the elegantly clad mother is caring personally for her infant; she does not waste money on a wet-nurse. Across the spotless tile floor, we look into a second room at the back, then through the half-open door to a house on a canal and the city beyond',1664,76,64,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/woman-and-child-with-serving-maid/PwEM1bzSv2ImXw?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":59,\"green\":45,\"blue\":24},\"web\":\"#3B2D18\",\"name\":\"Black Magic\"},{\"color\":{\"red\":118,\"green\":69,\"blue\":25},\"web\":\"#764519\",\"name\":\"Russet\"},{\"color\":{\"red\":146,\"green\":117,\"blue\":68},\"web\":\"#927544\",\"name\":\"Shadow\"},{\"color\":{\"red\":127,\"green\":55,\"blue\":11},\"web\":\"#7F370B\",\"name\":\"Saddle Brown\"},{\"color\":{\"red\":176,\"green\":143,\"blue\":87},\"web\":\"#B08F57\",\"name\":\"Teak\"},{\"color\":{\"red\":93,\"green\":51,\"blue\":12},\"web\":\"#5D330C\",\"name\":\"Baker\'s Chocolate\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (555,124,18,'124060','Beware of Luxury',2,'https://www.khm.at/de/object/9a1de01f89/','791','Only for private use','Jan Steen arranges the various actors as though on a theatre stage. The gentle depth of the composition is based on a triangle, with the magnificently dressed young woman at its top point. Her clothing and seductive look identify her as a \'loose-living\' girl. She, however, is not the focus of the scene; that is provided by the lady of the house, who has fallen asleep at the table on the left. Her \'absence\' has resulted in the rest of the story: the dog is finishing the meat pie that was served on the table, one of the children is filching something from the cabinet on the wall (\'opportunity makes the thief\'), the little girl\'s brother is trying out a pipe, and the youngest child, sitting in his highchair, is playing carelessly with a string of pearls. His attention diverted to the side, a young man is trying to play a violin. Young people who continued to live at home were considered suspect in the popular culture of the Netherlands at the time. The prostitute in the foreground has already been mentioned: in a provocative gesture she holds a filled glass between the legs of the man of the house, while he dismisses with a grin the admonishment of the nun (a Beguine?) standing on the right. The duck on the shoulder of the man next to her identifies him as a Quaker, who urges the reading of pious texts. Finally, the pig in the doorway to the kitchen is an allusion to another proverb: \'Neither cast ye your pearls [here: roses] before swine\'. Hanging above the heads of these sinners are the symbols of the penalty to be expected for unbridled, lustful behaviour: a sword and a crutch in a basket suspended from the ceiling.','Jan Steen arranges the various actors as though on a theatre stage. The gentle depth of the composition is based on a triangle, with the magnificently dressed young woman at its top point. Her clothing and seductive look identify her as a \'loose-living\' girl. She, however, is not the focus of the scene; that is provided by the lady of the house, who has fallen asleep at the table on the left. ',1663,145,105,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/beware-of-luxury-%E2%80%9Cin-weelde-siet-toe%E2%80%9D/iAEDJelKemoXnA?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":174,\"green\":150,\"blue\":123},\"web\":\"#AE967B\",\"name\":\"Sandrift\"},{\"color\":{\"red\":69,\"green\":40,\"blue\":18},\"web\":\"#452812\",\"name\":\"Bistre\"},{\"color\":{\"red\":44,\"green\":27,\"blue\":11},\"web\":\"#2C1B0B\",\"name\":\"Cocoa Brown\"},{\"color\":{\"red\":164,\"green\":70,\"blue\":34},\"web\":\"#a44622\",\"name\":\"Rock Spray\"},{\"color\":{\"red\":140,\"green\":117,\"blue\":89},\"web\":\"#8C7559\",\"name\":\"Cement\"},{\"color\":{\"red\":100,\"green\":77,\"blue\":50},\"web\":\"#644D32\",\"name\":\"Dallas\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (556,120,18,'120050','Holy Family with St. Anne and the Infant St. John',1,'https://www.khm.at/de/object/432aca3a1e/','183','Only for private use','Completely in contrast to the principles of Venetian painting, which made colour the dominant means of expression, Renaissance painting in Florence gave priority to the drawing as the means of expressing artistic invention. Thus there was a demand that the contours in painting be dear and sometimes even sharp. Bronzino\'s works are considered the epitome of Florentine disegno and, at the same time, its final pinnacle, which had already assumed the character of Mannerism. Bronzino, who was a pupil of Jacopo Pontormo and thus extremely familiar with the works of Michelangelo, served for many years as court painter to the Medici. He created decorations (now lost) for numerous theatrical works and festive occasions and supplied brilliant designs for the Medici tapestry factory. In his composition Bronzino organises the group in close proximity to one another in the foreground. Nevertheless the figures are arranged next to and behind each other in a way that makes them easy to recognise. The infant St. John is in the foremost position, his gaze and gesture pointing to the infant Jesus, who is depicted frontally. Behind them stands St. Mary, who is holding her son\'s arm in a loving gesture. The composition is extended by St. Anne and St. Joseph, who stand out from the central group of three because of their more natural skin colour. More than in almost any other of his works, Bronzino has emphasised the sharply outlined and sculptural figures almost to the point of stony coldness, especially in the case of the two boys. This artistic decision is also an example of paragone (Italian: comparison) - the competition, discussed in art theory at the time, between painting and sculpture to see which could create the better depiction of three-dimensional forms. Here Bronzino creates exciting contrasts: the coolness and clarity of his composition as opposed to the intimate familiar atmosphere; soft and gentle movements contrasted with formal severity and abstraction; turning away from natural models on the one hand but depicting all of their details on the other.','Completely in contrast to the principles of Venetian painting, which made colour the dominant means of expression, Renaissance painting in Florence gave priority to the drawing as the means of expressing artistic invention.',1545,101,126,'Oil on wood',900.0000,1200.0000,'https://www.google.com/culturalinstitute/beta/asset/holy-family-with-st-anne-and-the-infant-st-john/kQF72Dy8lZiemg?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":73,\"green\":61,\"blue\":45},\"web\":\"#493d2d\",\"name\":\"Deep Bronze\"},{\"color\":{\"red\":193,\"green\":175,\"blue\":163},\"web\":\"#c1afa3\",\"name\":\"Silk\"},{\"color\":{\"red\":20,\"green\":33,\"blue\":32},\"web\":\"#142120\",\"name\":\"Swamp\"},{\"color\":{\"red\":84,\"green\":32,\"blue\":23},\"web\":\"#542017\",\"name\":\"Caput Mortuum\"},{\"color\":{\"red\":44,\"green\":51,\"blue\":92},\"web\":\"#2c335c\",\"name\":\"Lucky Point\"},{\"color\":{\"red\":177,\"green\":113,\"blue\":96},\"web\":\"#b17160\",\"name\":\"Coral Tree\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (557,132,18,'132050','The Conquest of Jerusalem by Emperor Titus',2,'https://www.khm.at/de/object/78b9cab199/','1556','Only for private use','Poussin came to Rome in 1624, and only a short stay in Paris (1640-1642) was to interrupt his Roman career. As a friend of his successful fellow-painter Claude Lorrain and a protege of Pope Urban VIII and the cultured members of the papal court, Poussin became one of Rome\'s most prominent painters. His frequently documented interest in the art of antiquity gave his works a classical touch, which manifests itself in the present painting in its relief-like composition and plain coloration. The chaotic action appears well-organised, with the bodies precisely laid out on the canvas, and the mighty columns of the temple and the rigid figures in the foreground providing a counterweight to the battlefield tumult.','The chaotic action appears well-organised, with the bodies precisely laid out on the canvas, and the mighty columns of the temple and the rigid figures in the foreground providing a counterweight to the battlefield tumult.',1638,198,147,'Oil on canvas',1200.0000,1500.0000,'https://www.google.com/culturalinstitute/beta/asset/the-conquest-of-jerusalem-by-emperor-titus/YgFi1vGsvyQXXA?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":173,\"green\":156,\"blue\":122},\"web\":\"#AD9C7A\",\"name\":\"Bronco\"},{\"color\":{\"red\":118,\"green\":73,\"blue\":38},\"web\":\"#764926\",\"name\":\"Bull Shot\"},{\"color\":{\"red\":201,\"green\":192,\"blue\":155},\"web\":\"#C9C09B\",\"name\":\"Sisal\"},{\"color\":{\"red\":137,\"green\":117,\"blue\":87},\"web\":\"#897557\",\"name\":\"Cement\"},{\"color\":{\"red\":130,\"green\":53,\"blue\":26},\"web\":\"#82351a\",\"name\":\"Burnt Umber\"},{\"color\":{\"red\":133,\"green\":150,\"blue\":152},\"web\":\"#859698\",\"name\":\"Submarine\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (558,94,81,'094070','Madonna and Child with a Choir of Cherubs',1,'http://pinacotecabrera.org/en/collezione-online/opere/madonna-and-child-with-a-choir-of-cherubs/','297','Public domain','The panel, attributed to Giovanni Bellini until 1885, when Luigi Cavenaghi\'s restoration made it possible to recognize the hand of Mantegna, is probably the one that the artist gave to his friend the abbe Matteo Bosso. It came to Brera in 1808 from the Venetian church of Santa Maria Maggiore following the Napoleonic abolitions.','The panel, attributed to Giovanni Bellini until 1885, when Luigi Cavenaghi\'s restoration made it possible to recognize the hand of Mantegna, is probably the one that the artist gave to his friend the abbe Matteo Bosso. It came to Brera in 1808 from the Venetian church of Santa Maria Maggiore following the Napoleonic abolitions.',1490,70,88,'Tempera on panel',1000.0000,1300.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":19,\"green\":16,\"blue\":22},\"web\":\"#131016\",\"name\":\"Blackcurrant\"},{\"color\":{\"red\":79,\"green\":41,\"blue\":32},\"web\":\"#4F2920\",\"name\":\"Caput Mortuum\"},{\"color\":{\"red\":93,\"green\":120,\"blue\":146},\"web\":\"#5D7892\",\"name\":\"Kashmir Blue\"},{\"color\":{\"red\":226,\"green\":187,\"blue\":170},\"web\":\"#E2BBAA\",\"name\":\"Just Right\"},{\"color\":{\"red\":157,\"green\":40,\"blue\":33},\"web\":\"#9D2821\",\"name\":\"Brown\"},{\"color\":{\"red\":87,\"green\":82,\"blue\":86},\"web\":\"#575256\",\"name\":\"Purple Taupe\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (559,99,81,'099150','The Marriage of the Virgin',1,'http://pinacotecabrera.org/en/collezione-online/opere/the-marriage-of-the-virgin/','336','Public domain','The painting, dating from 1504, was moved from the Church of San Francesco in Cittiá di Castello to the Pinacoteca in 1805. Raphael painted the Marriage of the Virgin having in mind the altarpiece with the same subject by Perugino, which is conserved at the Musee des Beaux-Arts in Caen. Raphael took inspiration from it, using its composition structure and iconography to obtain a result of incredible and unachievable perfection.','The painting, dating from 1504, was moved from the Church of San Francesco in Cittiá di Castello to the Pinacoteca in 1805. Raphael painted the Marriage of the Virgin having in mind the altarpiece with the same subject by Perugino, which is conserved at the Musee des Beaux-Arts in Caen.',1504,118,171,'Oil on canvas',1200.0000,1500.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":177,\"green\":153,\"blue\":119},\"web\":\"#B19977\",\"name\":\"Bronco\"},{\"color\":{\"red\":155,\"green\":160,\"blue\":181},\"web\":\"#9BA0B5\",\"name\":\"Mischka\"},{\"color\":{\"red\":138,\"green\":114,\"blue\":81},\"web\":\"#8A7251\",\"name\":\"Shadow\"},{\"color\":{\"red\":209,\"green\":186,\"blue\":157},\"web\":\"#D1BA9D\",\"name\":\"Vanilla\"},{\"color\":{\"red\":112,\"green\":74,\"blue\":50},\"web\":\"#704A32\",\"name\":\"Cape Palliser\"},{\"color\":{\"red\":145,\"green\":26,\"blue\":40},\"web\":\"#911a28\",\"name\":\"Bright Red\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (560,93,81,'093020','The Virgin with Child, Angels and Saints',1,'http://pinacotecabrera.org/en/collezione-online/opere/the-virgin-with-child-angels-and-saints/','180','Public domain','After the Napoleonic abolitions, the altarpiece came to Brera from the church of San Bernardino in Urbino, erected by Federico da Montefeltro to house his own grave. It is likely that Federico commissioned it after the birth of his heir, followed by the death of his wife Battista Sforza (1472), and that he wanted to underline the protection granted by the Virgin to his own dynastic authority through this work dense in symbols.','After the Napoleonic abolitions, the altarpiece came to Brera from the church of San Bernardino in Urbino, erected by Federico da Montefeltro to house his own grave.',1474,172,252,'Tempera on panel',2500.0000,4000.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":169,\"green\":159,\"blue\":135},\"web\":\"#A99F87\",\"name\":\"Napa\"},{\"color\":{\"red\":86,\"green\":85,\"blue\":80},\"web\":\"#565550\",\"name\":\"Millbrook\"},{\"color\":{\"red\":197,\"green\":190,\"blue\":170},\"web\":\"#C5BEAA\",\"name\":\"Cotton Seed\"},{\"color\":{\"red\":97,\"green\":82,\"blue\":61},\"web\":\"#61523D\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":190,\"green\":99,\"blue\":85},\"web\":\"#be6355\",\"name\":\"Sunglo\"},{\"color\":{\"red\":119,\"green\":125,\"blue\":144},\"web\":\"#777d90\",\"name\":\"Storm Grey\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (561,135,81,'135010','Pieta',2,'http://pinacotecabrera.org/en/collezione-online/opere/pieta-giovanni-bellini/','228','Public domain','The panel, dated to the years between 1465 and 1470, marks an evident emancipation of the artist from the influence of Andrea Mantegna, to whom he was linked not just by cultural affinities but also by close ties of kinship (they were brothers-in-law).','The panel, dated to the years between 1465 and 1470, marks an evident emancipation of the artist from the influence of Andrea Mantegna, to whom he was linked not just by cultural affinities but also by close ties of kinship.',1470,107,86,'Tempera on panel',900.0000,1200.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":169,\"green\":150,\"blue\":130},\"web\":\"#A99682\",\"name\":\"Bronco\"},{\"color\":{\"red\":27,\"green\":22,\"blue\":15},\"web\":\"#1B160F\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":97,\"green\":79,\"blue\":62},\"web\":\"#614F3E\",\"name\":\"Rock\"},{\"color\":{\"red\":153,\"green\":150,\"blue\":144},\"web\":\"#999690\",\"name\":\"Nomad\"},{\"color\":{\"red\":137,\"green\":118,\"blue\":99},\"web\":\"#897663\",\"name\":\"Sand Dune\"},{\"color\":{\"red\":64,\"green\":73,\"blue\":82},\"web\":\"#404952\",\"name\":\"Rhino\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (562,135,81,'135020','Madonna and Child',2,'http://pinacotecabrera.org/en/collezione-online/opere/madonna-and-child/','298','Public domain','The Madonna and Child, dated 1510, is the latest of the works by Bellini in Brera. When he painted it, Bellini was around eighty and one of the most prestigious figures of the Venetian Renaissance, a sort of charismatic patriarch who, at the end of his career, showed that he was able to take in and guide a new direction in style.','The space of the picture is dominated by the monumental figure of the Virgin seated on a throne, wrapped in loose drapery that dilates the volume of her body in line with 15th-century schemes for construction of the image.',1510,115,85,'Oil on canvas',900.0000,1100.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":91,\"green\":82,\"blue\":62},\"web\":\"#5B523E\",\"name\":\"Mondo\"},{\"color\":{\"red\":13,\"green\":28,\"blue\":50},\"web\":\"#0D1C32\",\"name\":\"Black Pearl\"},{\"color\":{\"red\":70,\"green\":119,\"blue\":173},\"web\":\"#4677AD\",\"name\":\"Steel Blue\"},{\"color\":{\"red\":55,\"green\":53,\"blue\":47},\"web\":\"#37352F\",\"name\":\"Graphite\"},{\"color\":{\"red\":157,\"green\":158,\"blue\":153},\"web\":\"#9D9E99\",\"name\":\"Star Dust \"},{\"color\":{\"red\":155,\"green\":130,\"blue\":129},\"web\":\"#9b8281\",\"name\":\"Opium\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (563,135,70,'135030','Madonna and Child with St. John the Baptist',1,'http://collection.imamuseum.org/artwork/41175/','2000.341','Public domain',NULL,NULL,1500,58,76,'Oil on wood',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":17,\"green\":11,\"blue\":13},\"web\":\"#110B0D\",\"name\":\"Rustic Red\"},{\"color\":{\"red\":54,\"green\":16,\"blue\":8},\"web\":\"#361008\",\"name\":\"Seal Brown\"},{\"color\":{\"red\":108,\"green\":115,\"blue\":142},\"web\":\"#6C738E\",\"name\":\"Storm Grey\"},{\"color\":{\"red\":162,\"green\":153,\"blue\":156},\"web\":\"#A2999C\",\"name\":\"Shady Lady\"},{\"color\":{\"red\":87,\"green\":76,\"blue\":110},\"web\":\"#574C6E\",\"name\":\"Mulled Wine\"},{\"color\":{\"red\":110,\"green\":32,\"blue\":12},\"web\":\"#6E200C\",\"name\":\"Falu Red\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (564,135,18,'135040','Young Woman at Her Toilette',2,'https://www.khm.at/de/object/274ad4786c/','97','Only for private use','The nude figure is integrated into a system of horizontal and vertical features. She is sitting on a bench that has been covered with a precious carpet, and behind her is a dark-green surface on which a mirror has been hung. On the left a view of a Venetian landscape gives the painting depth. By using the same colours in the principal motif and landscape, Bellini connects the two spheres, and the basic mood of the painting is gentle and unified. In her right hand the young woman is holding another mirror, which is a symbol of vanitas on the one hand and an attribute of Venus Pudica on the other. Using the device of two mirrors, Bellini enables the observer to see two views of the woman\'s head from a single vantage point, a perspective possible only in painting.','The nude figure is integrated into a system of horizontal and vertical features. She is sitting on a bench that has been covered with a precious carpet, and behind her is a dark-green surface on which a mirror has been hung.',1515,78,63,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/young-woman-at-her-toilette/dQE6qBYljWU39A?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":33,\"green\":46,\"blue\":23},\"web\":\"#212E17\",\"name\":\"Pine Tree\"},{\"color\":{\"red\":208,\"green\":192,\"blue\":153},\"web\":\"#D0C099\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":131,\"green\":112,\"blue\":62},\"web\":\"#83703E\",\"name\":\"Go Ben\"},{\"color\":{\"red\":75,\"green\":97,\"blue\":113},\"web\":\"#4B6171\",\"name\":\"Fiord\"},{\"color\":{\"red\":178,\"green\":126,\"blue\":85},\"web\":\"#b27e55\",\"name\":\"Muddy Waters\"},{\"color\":{\"red\":135,\"green\":67,\"blue\":38},\"web\":\"#874326\",\"name\":\"Fire\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (565,131,81,'131040','View of St. Mark\'s from the Punta della Dogana',2,'http://pinacotecabrera.org/en/collezione-online/opere/view-of-st-marks-from-the-punta-della-dogana/','2236','Public domain','The View of St. Mark\'s Basin came to Brera in 1828 with the View of the Grand Canal Looking toward the Punta della Dogana from Campo Sant\'Ivo. They are subjects of which the artist was very fond, replicating them several times and varying the angle and breadth of the view: the two versions in Brera date from around 1740-45, i.e. the years immediately preceding Canaletto\'s journey to England.','The View of St. Mark\'s Basin came to Brera in 1828 with the View of the Grand Canal Looking toward the Punta della Dogana from Campo Sant\'Ivo. They are subjects of which the artist was very fond, replicating them several times and varying the angle and breadth of the view: the two versions in Brera date from around 1740-45, i.e. the years immediately preceding Canaletto\'s journey to England.',1745,70,53,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":180,\"green\":194,\"blue\":206},\"web\":\"#b4c2ce\",\"name\":\"Spindle\"},{\"color\":{\"red\":138,\"green\":123,\"blue\":98},\"web\":\"#8a7b62\",\"name\":\"Arrowtown\"},{\"color\":{\"red\":68,\"green\":64,\"blue\":55},\"web\":\"#444037\",\"name\":\"Onion\"},{\"color\":{\"red\":100,\"green\":106,\"blue\":99},\"web\":\"#646a63\",\"name\":\"Finlandia\"},{\"color\":{\"red\":214,\"green\":180,\"blue\":128},\"web\":\"#d6b480\",\"name\":\"Calico\"},{\"color\":{\"red\":237,\"green\":238,\"blue\":230},\"web\":\"#edeee6\",\"name\":\"Sugar Cane\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (566,136,81,'136010','The Kiss',1,'http://pinacotecabrera.org/en/collezione-online/opere/the-kiss/','6335','Public domain','It is one of the emblematic images of the Pinacoteca and perhaps the most widely reproduced Italian painting of the whole of the 19th century, created with the aim of symbolizing the love of the motherland and thirst for life on the part of the young nation that had emerged from the Second War of Independence and which now placed so many hopes in its new rulers. It proved an immediate and resounding success both for its patriotic values and for the medieval inspiration of the subject, typical of the Romantic taste of the time: Hayez painted other versions of it, now in various European collections.','It is one of the emblematic images of the Pinacoteca and perhaps the most widely reproduced Italian painting of the whole of the 19th century.',1859,88,112,'Oil on canvas',800.0000,1000.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":150,\"green\":155,\"blue\":189},\"web\":\"#969BBD\",\"name\":\"Logan\"},{\"color\":{\"red\":119,\"green\":75,\"blue\":58},\"web\":\"#774B3A\",\"name\":\"Cigar\"},{\"color\":{\"red\":187,\"green\":194,\"blue\":223},\"web\":\"#BBC2DF\",\"name\":\"Periwinkle\"},{\"color\":{\"red\":198,\"green\":191,\"blue\":186},\"web\":\"#C6BFBA\",\"name\":\"Pale Slate\"},{\"color\":{\"red\":200,\"green\":184,\"blue\":163},\"web\":\"#C8B8A3\",\"name\":\"Grain Brown\"},{\"color\":{\"red\":137,\"green\":88,\"blue\":64},\"web\":\"#895840\",\"name\":\"Rope\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (567,136,81,'136020','Melancholy',1,'http://pinacotecabrera.org/en/collezione-online/opere/melancholy/','6331','Public domain','The work, executed between 1840 and 1842, is full of erudite references to the Italian and European pictorial tradition: from reflections on the 16th-century painting of the Veneto exemplified by the treatment of the clothing, which echoes the textural effects of Savoldo and Titian, to the citation of Flemish still lifes.','The work, executed between 1840 and 1842, is full of erudite references to the Italian and European pictorial tradition.',1842,101,138,'Oil on canvas',900.0000,1100.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":123,\"green\":119,\"blue\":95},\"web\":\"#7B775F\",\"name\":\"Kokoda\"},{\"color\":{\"red\":88,\"green\":89,\"blue\":81},\"web\":\"#585951\",\"name\":\"Chicago\"},{\"color\":{\"red\":25,\"green\":33,\"blue\":44},\"web\":\"#19212c\",\"name\":\"Blue Charcoal\"},{\"color\":{\"red\":198,\"green\":190,\"blue\":161},\"web\":\"#c6bea1\",\"name\":\"Sisal\"},{\"color\":{\"red\":200,\"green\":195,\"blue\":167},\"web\":\"#C8C3A7\",\"name\":\"Kangaroo\"},{\"color\":{\"red\":95,\"green\":64,\"blue\":66},\"web\":\"#5f4042\",\"name\":\"Emperor\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (568,137,3,'137010','Abbey among Oak Trees',2,'http://www.smb-digital.de/eMuseumPlus?service=ExternalInterface&module=collection&objectId=968249&viewType=detailView','8/85','Public domain','Abbey among Oak Trees is the companion piece to Monk by the Sea. Friedrich showed both paintings in the Berlin Academy Exhibition of 1810. In their perplexing remoteness and formal radicalism they were to become key works in German Romanticism.','Abbey among Oak Trees is the companion piece to Monk by the Sea. Friedrich showed both paintings in the Berlin Academy Exhibition of 1810.',1810,171,110,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/abbey-among-oak-trees/UAEmmuxqtNUt-g',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":169,\"green\":156,\"blue\":128},\"web\":\"#A99C80\",\"name\":\"Napa\"},{\"color\":{\"red\":137,\"green\":122,\"blue\":100},\"web\":\"#897A64\",\"name\":\"Sand Dune\"},{\"color\":{\"red\":194,\"green\":181,\"blue\":141},\"web\":\"#C2B58D\",\"name\":\"Coriander\"},{\"color\":{\"red\":98,\"green\":83,\"blue\":63},\"web\":\"#62533F\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":98,\"green\":87,\"blue\":79},\"web\":\"#62574F\",\"name\":\"Domino\"},{\"color\":{\"red\":67,\"green\":51,\"blue\":32},\"web\":\"#433320\",\"name\":\"Clinker\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (569,137,3,'137020','Man and Women Contemplating the Moon',2,'http://www.smb-digital.de/eMuseumPlus?service=ExternalInterface&module=collection&objectId=964081&viewType=detailView','II 887','Public domain','During a nighttime walk through a mountain forest a pair remains on a hill next to a dramatically stirring, uprooted oak. Darkness surrounds the hikers, their eyes are directed to the orb of the moon, whose light solemnly quiet fills the atmosphere.','During a nighttime walk through a mountain forest a pair remains on a hill next to a dramatically stirring, uprooted oak. Darkness surrounds the hikers, their eyes are directed to the orb of the moon, whose light solemnly quiet fills the atmosphere.',1824,44,34,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/two-men-contemplating-the-moon/AQHW6lwY6LzX1Q',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":221,\"green\":195,\"blue\":211},\"web\":\"#DDC3D3\",\"name\":\"Twilight\"},{\"color\":{\"red\":253,\"green\":233,\"blue\":203},\"web\":\"#FDE9CB\",\"name\":\"Blanched Almond\"},{\"color\":{\"red\":62,\"green\":48,\"blue\":32},\"web\":\"#3E3020\",\"name\":\"Cola\"},{\"color\":{\"red\":203,\"green\":185,\"blue\":212},\"web\":\"#CBB9D4\",\"name\":\"Prelude\"},{\"color\":{\"red\":244,\"green\":214,\"blue\":221},\"web\":\"#F4D6DD\",\"name\":\"Cherub\"},{\"color\":{\"red\":167,\"green\":155,\"blue\":159},\"web\":\"#A79B9F\",\"name\":\"Shady Lady\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (570,137,3,'137030','Moonrise over the Sea',2,'http://www.smb-digital.de/eMuseumPlus?service=ExternalInterface&module=collection&objectId=959550&viewType=detailView','53','Public domain','Like its companion piece, the evening picture of the diptych was painted in 1822. In Moonrise on the Seashore Friedrich took up one of his favorite themes. In the reflected light of the night sky, it is as though the surface of the water begins to glow all of its own accord, taking up the light of heaven, as it were.','Like its companion piece, the evening picture of the diptych was painted in 1822.',1822,71,55,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/moonrise-over-the-sea/mwFGGdzKbfGMkg',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":182,\"green\":156,\"blue\":134},\"web\":\"#B69C86\",\"name\":\"Pale Taupe\"},{\"color\":{\"red\":220,\"green\":173,\"blue\":117},\"web\":\"#DCAD75\",\"name\":\"Manhattan\"},{\"color\":{\"red\":45,\"green\":40,\"blue\":35},\"web\":\"#2D2823\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":78,\"green\":45,\"blue\":18},\"web\":\"#4E2D12\",\"name\":\"Brown Bramble\"},{\"color\":{\"red\":161,\"green\":146,\"blue\":144},\"web\":\"#A19290\",\"name\":\"Thatch\"},{\"color\":{\"red\":132,\"green\":124,\"blue\":127},\"web\":\"#847C7F\",\"name\":\"Venus\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (571,138,3,'138010','The Isle of the Dead',2,'http://www.smb-digital.de/eMuseumPlus?service=ExternalInterface&module=collection&objectId=967648&viewType=detailView','2/80','Public domain','Arnold Bocklin spent the autumn of 1879 on Ischia. The Castello Alfonso, on a small island nearby, deeply impressed him during his stay. When the young, widowed Marie Berna visited Bocklin\'s studio in Florence in 1880 and asked for a \'picture to dream by,\' the memory of that landscape must have merged with earlier memories of, for example, the islands of the dead like San Michele in Venice and Etruscan cliff-necropolises. The Isle of the Dead became one of Bocklin\'s most popular pictorial works. He achieved this by combining a limited number of ideas into an impressive atmospheric composition. The motifs - island, water, and castle or villa by the sea - are already familiar from many of his earlier works. However, in this case they have been concentrated into a statement of the artist\'s Weltanschauung. The location is sinister. The viewer\'s gaze is led up the steps but can penetrate no further into the darkness. The island\'s strict symmetry, the calm horizontals and verticals, the circular island surrounded by high cliff walls, and the magical lighting create an atmosphere that is both solemn and sublime, evoking a sense of stillness and other-worldliness. The ripple-less surface of the water and the boat bearing the coffin with a figure shrouded in white behind it add a melancholy tone to the whole.',' The Isle of the Dead became one of Bocklin\'s most popular pictorial works. He achieved this by combining a limited number of ideas into an impressive atmospheric composition.',1883,150,80,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/the-isle-of-the-dead/0wFgMTIQ3kZCpg?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":34,\"green\":28,\"blue\":30},\"web\":\"#221c1e\",\"name\":\"Aubergine\"},{\"color\":{\"red\":163,\"green\":151,\"blue\":151},\"web\":\"#a39797\",\"name\":\"Nobel\"},{\"color\":{\"red\":85,\"green\":84,\"blue\":101},\"web\":\"#555465\",\"name\":\"Smoky\"},{\"color\":{\"red\":132,\"green\":113,\"blue\":95},\"web\":\"#84715f\",\"name\":\"Donkey Brown\"},{\"color\":{\"red\":119,\"green\":69,\"blue\":38},\"web\":\"#774526\",\"name\":\"Bull Shot\"},{\"color\":{\"red\":129,\"green\":116,\"blue\":110},\"web\":\"#81746E\",\"name\":\"Hurricane\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (572,138,3,'138020','The Deposition',2,'http://www.smb-digital.de/eMuseumPlus?service=ExternalInterface&module=collection&objectId=963112&viewType=detailView','I 827','Public domain',NULL,NULL,1876,250,164,'Oil on canvas',900.0000,1100.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":36,\"green\":36,\"blue\":36},\"web\":\"#242424\",\"name\":\"Nero\"},{\"color\":{\"red\":61,\"green\":79,\"blue\":93},\"web\":\"#3d4f5d\",\"name\":\"Cello\"},{\"color\":{\"red\":115,\"green\":83,\"blue\":61},\"web\":\"#73533d\",\"name\":\"Old Copper\"},{\"color\":{\"red\":88,\"green\":77,\"blue\":63},\"web\":\"#584d3f\",\"name\":\"Mondo\"},{\"color\":{\"red\":135,\"green\":125,\"blue\":100},\"web\":\"#877d64\",\"name\":\"Olive Haze\"},{\"color\":{\"red\":208,\"green\":194,\"blue\":182},\"web\":\"#d0c2b6\",\"name\":\"Stark White\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (573,139,17,'139010','The Lady of Shalott',2,'http://www.tate.org.uk/art/artworks/waterhouse-the-lady-of-shalott-n01543','N01543','Creative Commons CC-BY-NC-ND (3.0 Unported)','Tennyson\'s poem, first published in 1832, tells of a woman who suffers under an undisclosed curse. She lives isolated in a tower on an island called Shalott, on a river which flows down from King Arthur\'s castle at Camelot. Not daring to look upon reality, she is allowed to see the outside world only through its reflection in a mirror. One day she glimpses the reflected image of the handsome knight Lancelot, and cannot resist looking at him directly. The mirror cracks from side to side, and she feels the curse come upon her. The punishment that follows results in her drifting in her boat downstream to Camelot singing her last song, but dying before she reaches there.','Tennyson\'s poem, first published in 1832, tells of a woman who suffers under an undisclosed curse. She lives isolated in a tower on an island called Shalott, on a river which flows down from King Arthur\'s castle at Camelot. ',1888,200,153,'Oil on canvas',1300.0000,1700.0000,'https://www.google.com/culturalinstitute/beta/asset/the-lady-of-shalott/RQHFwa4u2LTw0g?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":170,\"green\":155,\"blue\":132},\"web\":\"#AA9B84\",\"name\":\"Bronco\"},{\"color\":{\"red\":198,\"green\":187,\"blue\":166},\"web\":\"#C6BBA6\",\"name\":\"Sisal\"},{\"color\":{\"red\":136,\"green\":118,\"blue\":93},\"web\":\"#88765D\",\"name\":\"Cement\"},{\"color\":{\"red\":202,\"green\":192,\"blue\":182},\"web\":\"#CAC0B6\",\"name\":\"Stark White\"},{\"color\":{\"red\":103,\"green\":85,\"blue\":63},\"web\":\"#67553F\",\"name\":\"Tobacco Brown\"},{\"color\":{\"red\":126,\"green\":54,\"blue\":57},\"web\":\"#7e3639\",\"name\":\"Stiletto\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (574,139,17,'139020','Consulting the Oracle',2,'http://www.tate.org.uk/art/artworks/waterhouse-consulting-the-oracle-n01541','N01541','Creative Commons CC-BY-NC-ND (3.0 Unported)','Miracles, magic and the power of prophecy are common themes in Waterhouse\'s art. In this picture he shows a group of seven young girls, sitting in a semicircle round a lamplit shrine, waiting in excitement while the priestess interprets the words of the Oracle.','In this picture a group of seven young girls, sitting in a semicircle round a lamplit shrine, waiting in excitement while the priestess interprets the words of the Oracle.',1884,198,119,'Oil on canvas',1100.0000,1300.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":195,\"green\":180,\"blue\":145},\"web\":\"#c3b491\",\"name\":\"Akora\"},{\"color\":{\"red\":102,\"green\":85,\"blue\":61},\"web\":\"#66553D\",\"name\":\"Tobacco Brown\"},{\"color\":{\"red\":137,\"green\":80,\"blue\":49},\"web\":\"#895031\",\"name\":\"Paarl\"},{\"color\":{\"red\":152,\"green\":140,\"blue\":117},\"web\":\"#988c75\",\"name\":\"Pale Oyster\"},{\"color\":{\"red\":184,\"green\":154,\"blue\":97},\"web\":\"#b89a61\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":89,\"green\":80,\"blue\":72},\"web\":\"#595048\",\"name\":\"Rock\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (575,139,17,'139030','Saint Eulalia',1,'http://www.tate.org.uk/art/artworks/waterhouse-saint-eulalia-n01542','N01542','Creative Commons CC-BY-NC-ND (3.0 Unported)','Waterhouse exhibited this picture at the Royal Academy in 1885 with the following note: \'Prudentius says that the body of St. Eulalia was shrouded \"by the miraculous fall of snow when lying in the forum after her martyrdom.\"\'','Waterhouse exhibited this picture at the Royal Academy in 1885 with the following note: \'Prudentius says that the body of St. Eulalia was shrouded \"by the miraculous fall of snow when lying in the forum after her martyrdom.\"\'',1885,117,189,'Oil on canvas',1200.0000,1350.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":134,\"green\":114,\"blue\":89},\"web\":\"#867259\",\"name\":\"Cement\"},{\"color\":{\"red\":226,\"green\":222,\"blue\":211},\"web\":\"#E2DED3\",\"name\":\"Sea Fog\"},{\"color\":{\"red\":169,\"green\":151,\"blue\":124},\"web\":\"#A9977C\",\"name\":\"Bronco\"},{\"color\":{\"red\":105,\"green\":85,\"blue\":61},\"web\":\"#69553D\",\"name\":\"Tobacco Brown\"},{\"color\":{\"red\":205,\"green\":191,\"blue\":168},\"web\":\"#CDBFA8\",\"name\":\"Soft Amber\"},{\"color\":{\"red\":110,\"green\":78,\"blue\":54},\"web\":\"#6E4E36\",\"name\":\"Old Copper\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (576,107,7,'107030','Madame Bergeret',1,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.32681.html','1946.7.3','Open Access','In the 1740s Boucher was establishing himself as a mature painter in Parisian art circles. In this portrait he defines the chic of that decade: Madame Bergeret is placed in a garden setting, dressed in a creamy silk gown, tight in the bodice with\r\npuffed sleeves highlighted with blue ribbons. Her face glows with youth and beauty depicted in translucent whites. The most important motif, and the charm of the composition, is the profusion of roses -- emerging from a bronze vase, decorating her sleeves and hair, and arranged across the bench and on the foreground plane. Sacred to Venus, the rose was a symbol well suited for a portrait of Bergeret\'s beloved wife.','In this portrait he defines the chic of that decade: Madame Bergeret is placed in a garden setting, dressed in a creamy silk gown, tight in the bodice with\r\npuffed sleeves highlighted with blue ribbons.',1766,105,143,'Oil on canvas',900.0000,1200.0000,'https://www.google.com/culturalinstitute/beta/asset/madame-bergeret/TwFs06EqPBEgug',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":159,\"green\":158,\"blue\":131},\"web\":\"#9F9E83\",\"name\":\"Lemon Grass\"},{\"color\":{\"red\":87,\"green\":121,\"blue\":110},\"web\":\"#57796E\",\"name\":\"Cutty Shark\"},{\"color\":{\"red\":126,\"green\":124,\"blue\":93},\"web\":\"#7E7C5D\",\"name\":\"Kokoda\"},{\"color\":{\"red\":227,\"green\":228,\"blue\":206},\"web\":\"#E3E4CE\",\"name\":\"Frost\"},{\"color\":{\"red\":58,\"green\":95,\"blue\":85},\"web\":\"#3A5F55\",\"name\":\"Spectra\"},{\"color\":{\"red\":217,\"green\":216,\"blue\":200},\"web\":\"#d9d8c8\",\"name\":\"Loafer\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (577,107,7,'107040','The Bath of Venus',1,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.12200.html','1943.7.2','Open Access','In The Bath of Venus, the mythological goddess has lost any allusions to classical history painting and is offered up to the viewer as an object of physical beauty. Venus, located in a lush garden setting, coyly attempts to restrain a pouting Cupid as two putti point to the scene in mocking disapproval. Boucher\'s success in communicating the charm and sensuality of the nude lies in his mastery of color and fluid brushstrokes. Venus is rendered in porcelain tones, delicately accented in pink, her body highlighted against luscious blue velvet and silk. The two white doves at her feet contrast a thick impasto surface with the transparent water and cool greens and blues of the foliage. The painting exemplifies the rococo love of asymmetric lines and sinuous curves, artfully arranged to seduce both the eye and the mind of the beholder.','In The Bath of Venus, the mythological goddess has lost any allusions to classical history painting and is offered up to the viewer as an object of physical beauty.',1751,84,107,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":40,\"green\":57,\"blue\":28},\"web\":\"#28391C\",\"name\":\"Black Forest\"},{\"color\":{\"red\":30,\"green\":30,\"blue\":9},\"web\":\"#1E1E09\",\"name\":\"Maire\"},{\"color\":{\"red\":49,\"green\":127,\"blue\":140},\"web\":\"#317F8C\",\"name\":\"Atoll\"},{\"color\":{\"red\":204,\"green\":192,\"blue\":168},\"web\":\"#CCC0A8\",\"name\":\"Soft Amber\"},{\"color\":{\"red\":64,\"green\":87,\"blue\":54},\"web\":\"#405736\",\"name\":\"Green House\"},{\"color\":{\"red\":100,\"green\":164,\"blue\":177},\"web\":\"#64A4B1\",\"name\":\"Fountain Blue\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (578,114,7,'114030','Madonna and Child',1,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.397.html','1939.1.256','Open Access','Painted during the latter part of Giotto\'s career, the Madonna and Child was the central part of a five-section polyptych, or altarpiece in many panels (see Reconstruction). Giotto utilized a conservative Byzantine-style background in gold leaf, symbolizing the realm of heaven, and included a white rose, the traditional symbol of Mary\'s purity as well as a reference to the innocence lost through Original Sin. Yet, the Madonna and Child introduces a new naturalistic trend in painting. Instead of making the blessing gesture of a philosopher, the infant Christ grasps his mother\'s left index finger in a typically baby-like way as he playfully reaches for the flower that she holds.','Painted during the latter part of Giotto\'s career, the Madonna and Child was the central part of a five-section polyptych',1315,62,85,'Tempera on panel',1900.0000,2300.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":61,\"green\":49,\"blue\":28},\"web\":\"#3D311C\",\"name\":\"Mikado\"},{\"color\":{\"red\":112,\"green\":73,\"blue\":28},\"web\":\"#70491C\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":228,\"green\":174,\"blue\":89},\"web\":\"#E4AE59\",\"name\":\"Rob Roy\"},{\"color\":{\"red\":53,\"green\":48,\"blue\":40},\"web\":\"#353028\",\"name\":\"Creole\"},{\"color\":{\"red\":9,\"green\":4,\"blue\":3},\"web\":\"#090403\",\"name\":\"Black\"},{\"color\":{\"red\":91,\"green\":51,\"blue\":9},\"web\":\"#5B3309\",\"name\":\"Baker\'s Chocolate\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (579,112,7,'112020','Self-Portrait',3,'http://www.nga.gov/content/ngaweb/Collection/art-object-page.37003.html','1949.6.1','Open Access','Judith Leyster\'s Self-Portrait exudes self-confidence in her abilities, and it has become one of the National Gallery of Art\'s most popular Dutch paintings. Leyster has depicted herself at her easel, briefly interrupting work on a painting of a violin player to interact with the viewer. The momentary quality of the portrait and the vigorous brushwork echo the work of Frans Hals.','Judith Leyster\'s Self-Portrait exudes self-confidence in her abilities, and it has become one of the National Gallery of Art\'s most popular Dutch paintings. Leyster has depicted herself at her easel, briefly interrupting work on a painting of a violin player to interact with the viewer. The momentary quality of the portrait and the vigorous brushwork echo the work of Frans Hals.',1630,65,74,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":121,\"green\":118,\"blue\":92},\"web\":\"#79765C\",\"name\":\"Kokoda\"},{\"color\":{\"red\":24,\"green\":21,\"blue\":22},\"web\":\"#181516\",\"name\":\"Rustic Red\"},{\"color\":{\"red\":93,\"green\":85,\"blue\":63},\"web\":\"#5D553F\",\"name\":\"Millbrook\"},{\"color\":{\"red\":80,\"green\":78,\"blue\":68},\"web\":\"#504E44\",\"name\":\"Merlin\"},{\"color\":{\"red\":220,\"green\":180,\"blue\":141},\"web\":\"#dcb48d\",\"name\":\"Brandy\"},{\"color\":{\"red\":143,\"green\":108,\"blue\":86},\"web\":\"#8f6c56\",\"name\":\"Leather\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (580,111,52,'111040','Judith and Maidservant with the Head of Holophernes',1,'http://www.dia.org/object-info/0573dd3e-1079-4ce3-8262-78b0e1e68331.aspx','52.253','&copy; Detroit Institute of Arts','One of Artemisia\'s best works, this scene is tense with imminent danger as Judith and Abra prepare to flee Holofernes\'s tent with his severed head. Dramatic and unusual chiaroscuro, especially the shadows Judith\'s hand casts on her face, together with vigilant expressions and posture, add urgency to the scene.','One of Artemisia\'s best works, this scene is tense with imminent danger as Judith and Abra prepare to flee Holofernes\'s tent with his severed head.',1625,141,184,'Oil on canvas',1100.0000,1500.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":3,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":241,\"green\":195,\"blue\":58},\"web\":\"#F1C33A\",\"name\":\"Saffron\"},{\"color\":{\"red\":167,\"green\":104,\"blue\":26},\"web\":\"#A7681A\",\"name\":\"Golden Brown\"},{\"color\":{\"red\":93,\"green\":42,\"blue\":4},\"web\":\"#5D2A04\",\"name\":\"Baker\'s Chocolate\"},{\"color\":{\"red\":202,\"green\":142,\"blue\":58},\"web\":\"#CA8E3A\",\"name\":\"Anzac\"},{\"color\":{\"red\":254,\"green\":220,\"blue\":123},\"web\":\"#FEDC7B\",\"name\":\"Salomie\"},{\"color\":{\"red\":210,\"green\":147,\"blue\":38},\"web\":\"#D29326\",\"name\":\"Buttercup\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (581,111,24,'111030','Cupid and Psyche',2,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/31669/?lng=en','6889','Personal non-commercial use',NULL,NULL,1639,160,130,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":49,\"green\":20,\"blue\":5},\"web\":\"#311405\",\"name\":\"Brown Pod\"},{\"color\":{\"red\":187,\"green\":151,\"blue\":88},\"web\":\"#BB9758\",\"name\":\"Barley Corn\"},{\"color\":{\"red\":89,\"green\":44,\"blue\":7},\"web\":\"#592C07\",\"name\":\"Baker\'s Chocolate\"},{\"color\":{\"red\":234,\"green\":179,\"blue\":95},\"web\":\"#EAB35F\",\"name\":\"Harvest Gold\"},{\"color\":{\"red\":36,\"green\":15,\"blue\":10},\"web\":\"#240F0A\",\"name\":\"Seal Brown\"},{\"color\":{\"red\":70,\"green\":34,\"blue\":11},\"web\":\"#46220B\",\"name\":\"Brown Pod\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (582,113,24,'113030','Portrait of Emperor Pavel I\'s Daughters',3,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/38159/?lng=en','7747','Personal non-commercial use',NULL,NULL,1796,99,99,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":141,\"green\":114,\"blue\":64},\"web\":\"#8D7240\",\"name\":\"Shadow\"},{\"color\":{\"red\":115,\"green\":73,\"blue\":33},\"web\":\"#734921\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":56,\"green\":50,\"blue\":45},\"web\":\"#38322D\",\"name\":\"Coffee Bean\"},{\"color\":{\"red\":211,\"green\":189,\"blue\":159},\"web\":\"#D3BD9F\",\"name\":\"Soft Amber\"},{\"color\":{\"red\":50,\"green\":71,\"blue\":66},\"web\":\"#324742\",\"name\":\"Gable Green\"},{\"color\":{\"red\":17,\"green\":31,\"blue\":31},\"web\":\"#111f1f\",\"name\":\"Swamp\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (583,40,24,'040030','Landscape',2,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/35717/?lng=en','9098','Personal non-commercial use',NULL,NULL,1913,100,88,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":80,\"green\":75,\"blue\":94},\"web\":\"#504b5e\",\"name\":\"Mulled Wine\"},{\"color\":{\"red\":182,\"green\":132,\"blue\":110},\"web\":\"#b6846e\",\"name\":\"Brandy Rose\"},{\"color\":{\"red\":220,\"green\":181,\"blue\":110},\"web\":\"#dcb56e\",\"name\":\"Equator\"},{\"color\":{\"red\":194,\"green\":102,\"blue\":75},\"web\":\"#c2664b\",\"name\":\"Flame Pea\"},{\"color\":{\"red\":75,\"green\":80,\"blue\":132},\"web\":\"#4b5084\",\"name\":\"Jacksons Purple\"},{\"color\":{\"red\":193,\"green\":124,\"blue\":134},\"web\":\"#c17c86\",\"name\":\"Charm\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (584,101,24,'101060','Lute Player',2,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/31511/?lng=en','45','Personal non-commercial use','This is an early work by Caravaggio, who sought above all to convey the reality and solidity of the surrounding world. We can already see the elements of the artist\'s style which were to have such a widespread influence on other artists. The figure of a young boy dressed in a white shirt stands out clearly against the dark background. The sharp sidelighting and the falling shadows give the objects an almost tangible volume and weight. Caravaggio was interested in the uniqueness of the surrounding world, and there are markedly individual features not only in the youth\'s face but also in the objects which make up the still life: the damaged pear, the crack in the lute, the crumpled pages of the music. The melody written on those pages is that of a then fashionable song by Jacques Arcadelt, \"You know that I love you\". Love as the theme of this work is also indicated by other objects. For instance, the cracked lute was a metaphor for the love that fails,.','This is an early work by Caravaggio, who sought above all to convey the reality and solidity of the surrounding world. We can already see the elements of the artist\'s style which were to have such a widespread influence on other artists.',1596,119,94,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":62,\"green\":46,\"blue\":24},\"web\":\"#3E2E18\",\"name\":\"Cola\"},{\"color\":{\"red\":102,\"green\":79,\"blue\":31},\"web\":\"#664F1F\",\"name\":\"Horses Neck\"},{\"color\":{\"red\":139,\"green\":116,\"blue\":62},\"web\":\"#8B743E\",\"name\":\"Corn Harvest\"},{\"color\":{\"red\":39,\"green\":27,\"blue\":10},\"web\":\"#271B0A\",\"name\":\"Cocoa Brown\"},{\"color\":{\"red\":109,\"green\":70,\"blue\":20},\"web\":\"#6D4614\",\"name\":\"Raw Umber\"},{\"color\":{\"red\":186,\"green\":151,\"blue\":67},\"web\":\"#BA9743\",\"name\":\"Roti\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (585,108,24,'108030','Saying Grace',1,'https://www.hermitagemuseum.org/wps/portal/hermitage/digital-collection/01.+Paintings/37525/?lng=en','1193','Personal non-commercial use','Chardin was the first to introduce the themes of the family, motherhood and housework to French 18th-century art. The heroes of Saying Grace belong to the Third Estate, that class of craftsmen and small traders with whose way of life Chardin was most familiar. The action centres on the table where a young mother is dishing out soup and seeking to make her two daughters repeat the words of a lunchtime prayer. Composed with great care, the painting seeks to portray the artist\'s ideal of the closely-knit family, of their caring attitude towards each other. He produced a warm and touching image in the younger daughter, capturing the feelings of the child who does not as yet fully comprehend the meaning of the words, making it one of the best images of children Chardin ever created.','Composed with great care, the painting seeks to portray the artist\'s ideal of the closely-knit family, of their caring attitude towards each other.',1744,38,49,'Oil on canvas',700.0000,900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":195,\"green\":147,\"blue\":94},\"web\":\"#C3935E\",\"name\":\"Twine\"},{\"color\":{\"red\":228,\"green\":189,\"blue\":128},\"web\":\"#E4BD80\",\"name\":\"Maize\"},{\"color\":{\"red\":157,\"green\":110,\"blue\":64},\"web\":\"#423520\",\"name\":\"Mikado\"},{\"color\":{\"red\":230,\"green\":180,\"blue\":124},\"web\":\"#9D6E40\",\"name\":\"Mai Tai\"},{\"color\":{\"red\":208,\"green\":129,\"blue\":57},\"web\":\"#d08139\",\"name\":\"Golden Bell\"},{\"color\":{\"red\":202,\"green\":97,\"blue\":64},\"web\":\"#ca6140\",\"name\":\"Ecstasy\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (586,8,27,'008030','Portrait of the Marquesa de Santiago',1,'http://www.getty.edu/art/collection/objects/706/francisco-jose-de-goya-y-lucientes-francisco-de-goya-portrait-of-the-marquesa-de-santiago-spanish-1804/','83.PA.12','Public domain','The Marquesa de Santiago stands full-length in front of a landscape of gently sloping hills. Well-born, very wealthy, and a commanding presence, she confronts the viewer directly. Her white lace mantilla extends to her knees, and she holds a closed fan in her left hand. Heavily applied make-up accentuates her features. Known for her dissolute lifestyle, the Marquesa died at the age of forty-three, three years after this portrait was made.','The Marquesa de Santiago stands full-length in front of a landscape of gently sloping hills. Well-born, very wealthy, and a commanding presence, she confronts the viewer directly.',1804,126,209,'Oil on canvas',900.0000,1100.0000,'https://www.google.com/culturalinstitute/beta/asset/portrait-of-the-marquesa-de-santiago/IgE6HJDa9WgHrg','The Marquesa de Santiago stands full-length in front of a landscape of gently sloping hills. Well-born, very wealthy, and a commanding presence, she confronts the viewer directly. Her white lace mantilla extends to her knees, and she holds a closed fan in her left hand. Heavily applied make-up accentuates her features. Known for her dissolute lifestyle, the Marquesa died at the age of forty-three, three years after this portrait was made. An English visitor to Spain once described her as \"very profligate and loose in her manners and conversations, and scarcely admitted into female society┬┐and said to boast of her nocturnal revels.\" While contemporary portraitists sought to convey ideal beauty with a highly finished technique, Goya used a more expressionistic handling of the paint. Broad, quick brushstrokes describe her dark dress, and the application of thick impasto suggests the gold braid on the Marquesa\'s sleeve and lace of her mantilla. In the background, crude cottages and trees are merely indicated with wide, rapid sweeps of the brush.',NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":91,\"green\":123,\"blue\":115},\"web\":\"#5B7B73\",\"name\":\"Cutty Sark\"},{\"color\":{\"red\":204,\"green\":194,\"blue\":172},\"web\":\"#CCC2AC\",\"name\":\"Parchment\"},{\"color\":{\"red\":14,\"green\":8,\"blue\":7},\"web\":\"#0E0807\",\"name\":\"Black\"},{\"color\":{\"red\":234,\"green\":227,\"blue\":204},\"web\":\"#EAE3CC\",\"name\":\"Orange White\"},{\"color\":{\"red\":168,\"green\":156,\"blue\":129},\"web\":\"#A89C81\",\"name\":\"Napa\"},{\"color\":{\"red\":128,\"green\":157,\"blue\":151},\"web\":\"#809D97\",\"name\":\"Granny Smith\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (587,140,27,'140010','A Young Girl Defending Herself against Eros',1,'http://www.getty.edu/art/collection/objects/548/william-adolphe-bouguereau-a-young-girl-defending-herself-against-eros-french-about-1880/','70.PA.3','Public domain','A young nude woman sits with her arms outstretched, pushing away a winged boy. He is Cupid, the god of love, holding up an arrow to pierce her. The title suggests that the young woman is trying to defend herself, yet she smiles and struggles unconvincingly against the mischievous little god.','A young nude woman sits with her arms outstretched, pushing away a winged boy. He is Cupid, the god of love, holding up an arrow to pierce her. The title suggests that the young woman is trying to defend herself, yet she smiles and struggles unconvincingly against the mischievous little god.',1880,57,81,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/a-young-girl-defending-herself-against-eros/WwG4E841q7Lwgg?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":4},\"dominantColors\":[{\"color\":{\"red\":57,\"green\":48,\"blue\":20},\"web\":\"#393014\",\"name\":\"Mikado\"},{\"color\":{\"red\":154,\"green\":153,\"blue\":145},\"web\":\"#9A9991\",\"name\":\"Dawn\"},{\"color\":{\"red\":25,\"green\":60,\"blue\":59},\"web\":\"#193C3B\",\"name\":\"Tiber\"},{\"color\":{\"red\":37,\"green\":29,\"blue\":3},\"web\":\"#251D03\",\"name\":\"Maire\"},{\"color\":{\"red\":91,\"green\":78,\"blue\":55},\"web\":\"#5B4E37\",\"name\":\"Metallic Bronze\"},{\"color\":{\"red\":124,\"green\":113,\"blue\":92},\"web\":\"#7C715C\",\"name\":\"Pablo\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (588,140,42,'140020','The Elder Sister',1,'https://www.brooklynmuseum.org/opencollection/objects/4390','21.99','Creative Commons - Attribution','An academic painter who had achieved great success in the Paris Salon with mythological, historical, and religious subjects, Bouguereau later turned to genre scenes such as this image of a young woman caring for her younger brother. Although the figures are defined as siblings in the title, Bouguereau evokes the Madonna and Child with a tender pose-much like that seen in the altarpieces on the opposite wallÔÇöand the Catholic rosary beads in the child\'s hand. Moreover, scholars have linked Bouguereau\'s composition and the dark, dreamy look of the girl to the Sistine Madonna by Raphael. Bouguereau\'s works appealed to a middle-class clientele-both French and American-that cherished Christian and domestic values.','An academic painter who had achieved great success in the Paris Salon with mythological, historical, and religious subjects, Bouguereau later turned to genre scenes such as this image of a young woman caring for her younger brother.',1864,45,55,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/the-elder-sister-reduction-la-soeur-a%C3%AEn%C3%A9e-r%C3%A9duction/IgFK1YTUuvzIrQ?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":176,\"green\":153,\"blue\":130},\"web\":\"#B09982\",\"name\":\"Sandrift\"},{\"color\":{\"red\":50,\"green\":46,\"blue\":41},\"web\":\"#322E29\",\"name\":\"Acadia\"},{\"color\":{\"red\":52,\"green\":23,\"blue\":16},\"web\":\"#341710\",\"name\":\"Seal Brown\"},{\"color\":{\"red\":88,\"green\":83,\"blue\":77},\"web\":\"#58534D\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":139,\"green\":118,\"blue\":95},\"web\":\"#8B765F\",\"name\":\"Sand Dune\"},{\"color\":{\"red\":191,\"green\":186,\"blue\":180},\"web\":\"#BFBAB4\",\"name\":\"Cloud\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (589,140,52,'140030','The Nut Gatherers',2,'http://www.dia.org/object-info/2d7edad7-ef64-461f-8c1c-ee02475ecb81.aspx','54.458','&copy; Detroit Institute of Arts',NULL,NULL,1882,134,87,'Oil on canvas',900.0000,1000.0000,'https://www.google.com/culturalinstitute/beta/asset/the-nut-gatherers/GwH-a-m2kog8Mw?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":65,\"green\":50,\"blue\":31},\"web\":\"#41321F\",\"name\":\"Clinker\"},{\"color\":{\"red\":137,\"green\":118,\"blue\":60},\"web\":\"#89763C\",\"name\":\"Corn Harvest\"},{\"color\":{\"red\":245,\"green\":236,\"blue\":238},\"web\":\"#F5ECEE\",\"name\":\"Armour\"},{\"color\":{\"red\":93,\"green\":77,\"blue\":47},\"web\":\"#5D4D2F\",\"name\":\"West Coast\"},{\"color\":{\"red\":221,\"green\":188,\"blue\":175},\"web\":\"#ddbcaf\",\"name\":\"Wafer\"},{\"color\":{\"red\":155,\"green\":149,\"blue\":152},\"web\":\"#9b9598\",\"name\":\"Shady Lady\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (590,5,27,'005090','The Farewell of Telemachus and Eucharis',3,'http://www.getty.edu/art/collection/objects/806/jacques-louis-david-the-farewell-of-telemachus-and-eucharis-french-1818/','87.PA.27','Public domain','Fixing the viewer with a dreamy gaze, the fair-haired Telemachus grasps Eucharis\'s thigh with his right hand while holding his sword upright with the other. In the 1699 French novel Les Aventures de Telemaque, loosely based on characters from the Odyssey, the author Fenelon describes how Telemachus, the son of Odysseus, fell passionately in love with the beautiful nymph Eucharis. His duty as a son, however, required that he end their romance and depart in search of his missing father.','Fixing the viewer with a dreamy gaze, the fair-haired Telemachus grasps Eucharis\'s thigh with his right hand while holding his sword upright with the other.',1818,103,88,'Oil on canvas',900.0000,1200.0000,'https://www.google.com/culturalinstitute/beta/asset/the-farewell-of-telemachus-and-eucharis/rwHbSEhvONtMwg?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":25,\"green\":23,\"blue\":19},\"web\":\"#191713\",\"name\":\"Maire\"},{\"color\":{\"red\":79,\"green\":42,\"blue\":27},\"web\":\"#4F2A1B\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":177,\"green\":153,\"blue\":128},\"web\":\"#B19980\",\"name\":\"Sandrift\"},{\"color\":{\"red\":28,\"green\":50,\"blue\":65},\"web\":\"#1C3241\",\"name\":\"Blue Whale\"},{\"color\":{\"red\":62,\"green\":48,\"blue\":28},\"web\":\"#3E301C\",\"name\":\"Cola\"},{\"color\":{\"red\":43,\"green\":46,\"blue\":45},\"web\":\"#2B2E2D\",\"name\":\"Woodsmoke\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (591,137,27,'137040','A Walk at Dusk',2,'http://www.getty.edu/art/collection/objects/862/caspar-david-friedrich-a-walk-at-dusk-german-about-1830-1835/','93.PA.14','Public domain','His head bowed, a man walks alone in the silvery, cold moonlit night while contemplating a megalithic tomb and its implicit message of death. It is winter, and all around him nature is dying. Leafless trees loom behind like specters, but a grove of verdant oaks rises through the mist in the background with the promise of life. The waxing moon, high in the sky, also acts as a counterbalance to death, symbolizing Christ and the promise of rebirth for the artist Caspar David Friedrich.','His head bowed, a man walks alone in the silvery, cold moonlit night while contemplating a megalithic tomb and its implicit message of death. It is winter, and all around him nature is dying',1835,43,33,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/a-walk-at-dusk/5wFxD61nj36xGQ?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":97,\"green\":79,\"blue\":93},\"web\":\"#614F5D\",\"name\":\"Salt Box\"},{\"color\":{\"red\":125,\"green\":106,\"blue\":129},\"web\":\"#7D6A81\",\"name\":\"Rum\"},{\"color\":{\"red\":90,\"green\":75,\"blue\":83},\"web\":\"#5A4B53\",\"name\":\"Liver\"},{\"color\":{\"red\":75,\"green\":57,\"blue\":62},\"web\":\"#4B393E\",\"name\":\"Jon\"},{\"color\":{\"red\":119,\"green\":101,\"blue\":119},\"web\":\"#776577\",\"name\":\"Old Lavender\"},{\"color\":{\"red\":67,\"green\":52,\"blue\":53},\"web\":\"#433435\",\"name\":\"Cab Sav\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (592,12,27,'012070','Jeanne (Spring)',1,'http://www.getty.edu/art/collection/objects/268843/edouard-manet-jeanne-spring-french-1881/','2014.62','Public domain','A chic young woman in a day dress with floral accents holds a parasol against a background of exuberant foliage. She looks straight ahead, a picture of poise and detachment even as she seems fully aware of the viewer\'s admiring gaze.','A chic young woman in a day dress with floral accents holds a parasol against a background of exuberant foliage.',1881,51,74,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/le-printemps-jeanne-demarsy/ewHUkby4MoOrrw?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":48,\"green\":92,\"blue\":77},\"web\":\"#305C4D\",\"name\":\"Spectra\"},{\"color\":{\"red\":160,\"green\":156,\"blue\":126},\"web\":\"#A09C7E\",\"name\":\"Grey Olive\"},{\"color\":{\"red\":27,\"green\":14,\"blue\":6},\"web\":\"#1B0E06\",\"name\":\"Wood Bark\"},{\"color\":{\"red\":30,\"green\":112,\"blue\":161},\"web\":\"#1E70A1\",\"name\":\"Lochmara\"},{\"color\":{\"red\":59,\"green\":94,\"blue\":64},\"web\":\"#3B5E40\",\"name\":\"Hunter Green\"},{\"color\":{\"red\":151,\"green\":130,\"blue\":77},\"web\":\"#97824d\",\"name\":\"Muesli\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (593,121,27,'121040','Christ on the Cross',1,'http://www.getty.edu/art/collection/objects/129847/el-greco-domenico-theotocopuli-christ-on-the-cross-greek-1600-1610/','2000.40','Public domain','Isolated atop a mountain, a gaunt, tormented Christ dominates a nearly empty landscape. On a road leading to the walled city of Jerusalem, horsemen pass by the execution hill, literally turning their backs on Christ. El Greco\'s use of dramatic colors and exaggerated proportions distorts the figure, conveying the transcendent moment when Christ sublimated his physical pain and commended his spirit to God. Turning his eyes upward toward heaven, Christ looks away from the bones and skulls that lie at his feet, representative of his triumph over death. Light plays across his undulating form, illuminating his tortured body against the dark background. To heighten empathy between the viewer and Christ, the elongated but graceful figure appears alone. This private, devotional image was meant to encourage contemplation and spiritual reflection.','On a road leading to the walled city of Jerusalem, horsemen pass by the execution hill, literally turning their backs on Christ. El Greco\'s use of dramatic colors and exaggerated proportions distorts the figure.',1610,51,82,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/christ-on-the-cross/cgHO8uo2dVOJoQ?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":3},\"dominantColors\":[{\"color\":{\"red\":129,\"green\":120,\"blue\":112},\"web\":\"#817870\",\"name\":\"Americano\"},{\"color\":{\"red\":19,\"green\":14,\"blue\":10},\"web\":\"#130E0A\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":159,\"green\":151,\"blue\":142},\"web\":\"#9F978E\",\"name\":\"Zorba\"},{\"color\":{\"red\":93,\"green\":86,\"blue\":78},\"web\":\"#5D564E\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":190,\"green\":184,\"blue\":172},\"web\":\"#BEB8AC\",\"name\":\"Cotton Seed\"},{\"color\":{\"red\":126,\"green\":115,\"blue\":101},\"web\":\"#7E7365\",\"name\":\"Sand Dune\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (594,105,27,'105140','An Old Man in Military Costume',1,'http://www.getty.edu/art/collection/objects/673/rembrandt-harmensz-van-rijn-an-old-man-in-military-costume-dutch-about-1630-1631/','78.PB.246','Public domain','The subject, who appears in different guises in several other paintings by Rembrandt van Rijn and his contemporaries, wears a plumed hat and metal breastplate. His military costume may symbolize Dutch strength and patriotism during the struggle for independence from Spain. Although he faces front, the man\'s torso is turned in a three-quarter view; his watery eyes gazing off to the side give the image a sense of immediacy.','The subject, who appears in different guises in several other paintings by Rembrandt van Rijn and his contemporaries, wears a plumed hat and metal breastplate.',1630,51,66,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/an-old-man-in-military-costume/5QHSdGU-GIOq5A?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":57,\"green\":46,\"blue\":28},\"web\":\"#392E1C\",\"name\":\"Black Magic\"},{\"color\":{\"red\":81,\"green\":49,\"blue\":27},\"web\":\"#51311B\",\"name\":\"Brown Bramble\"},{\"color\":{\"red\":20,\"green\":14,\"blue\":7},\"web\":\"#140E07\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":93,\"green\":76,\"blue\":49},\"web\":\"#5D4C31\",\"name\":\"Punga\"},{\"color\":{\"red\":135,\"green\":106,\"blue\":65},\"web\":\"#876A41\",\"name\":\"McKenzie\"},{\"color\":{\"red\":105,\"green\":100,\"blue\":86},\"web\":\"#696456\",\"name\":\"Crocodile\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (595,107,27,'107050','The Bird Catchers',2,'http://www.getty.edu/art/collection/objects/590/francois-boucher-the-bird-catchers-french-1748/','71.PA.38','Public domain','Responding to the contemporary rage for pastorals depicting amorous countryside games, Francois Boucher here exhibited young, fashionable couples in the act of catching birds. In the 1700s, small birds played an important symbolic role in courtship ritual: the gift of a caged bird from a man to a woman signified her capture of his heart. Posed in front of the ruins of a temple to Vesta, young aristocratic women dressed in exquisite finery play with small birds; some still hold them on strings while others daintily hold them on their fingers.','Responding to the contemporary rage for pastorals depicting amorous countryside games, Francois Boucher here exhibited young, fashionable couples in the act of catching birds.',1748,294,337,'Oil on canvas',1600.0000,2000.0000,'https://www.google.com/culturalinstitute/beta/asset/the-bird-catchers/xwEWTp-JlLY4BA?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":48,\"green\":52,\"blue\":43},\"web\":\"#30342B\",\"name\":\"Black Forest\"},{\"color\":{\"red\":166,\"green\":20,\"blue\":3},\"web\":\"#A61403\",\"name\":\"Free Speech Red\"},{\"color\":{\"red\":92,\"green\":131,\"blue\":151},\"web\":\"#5c8397\",\"name\":\"Horizon\"},{\"color\":{\"red\":155,\"green\":148,\"blue\":127},\"web\":\"#9b947f\",\"name\":\"Grey Olive\"},{\"color\":{\"red\":162,\"green\":118,\"blue\":29},\"web\":\"#a2761d\",\"name\":\"Hacienda\"},{\"color\":{\"red\":150,\"green\":133,\"blue\":81},\"web\":\"#968551\",\"name\":\"Clay Creek\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (596,63,27,'063030','A Centennial of Independence',2,'http://www.getty.edu/art/collection/objects/816/henri-rousseau-a-centennial-of-independence-french-1892/','88.PA.58','Public domain','Henri Rousseau commemorated the one-hundredth anniversary of the proclamation of the first French Republic in 1792. Peasants dance the farandole, a popular southern French dance, around three liberty trees and two female figures representing the First and Third Republics. Rousseau copied the dancers from a French magazine illustration but added waving banners, the liberty poles, and the allegorical figures. A wagon in the background is full of costumed musicians, reminiscent of parades the artist had seen. He used brilliant colors and solid forms to express the happiness of the scene symbolizing good government. To the right, the erect posture of the dignified republican leaders signals the solidity of the French Republic.','Henri Rousseau commemorated the one-hundredth anniversary of the proclamation of the first French Republic in 1792.',1892,158,111,'Oil on canvas',700.0000,900.0000,'https://www.google.com/culturalinstitute/beta/asset/a-centennial-of-independence/WAFKMD3ymhrp_g?hl=en',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":42,\"green\":97,\"blue\":80},\"web\":\"#2A6150\",\"name\":\"Evening Sea\"},{\"color\":{\"red\":117,\"green\":71,\"blue\":27},\"web\":\"#75471B\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":81,\"green\":39,\"blue\":20},\"web\":\"#512714\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":179,\"green\":148,\"blue\":59},\"web\":\"#B3943B\",\"name\":\"Roti\"},{\"color\":{\"red\":61,\"green\":94,\"blue\":62},\"web\":\"#3D5E3E\",\"name\":\"Hunter Green\"},{\"color\":{\"red\":85,\"green\":122,\"blue\":138},\"web\":\"#557a8a\",\"name\":\"Hoki\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (597,103,30,'103050','William II, Prince of Orange, and his Bride, Mary Stuart',1,'http://hdl.handle.net/10934/RM0001.COLLECT.8289','SK-A-102','Public domain','The boy is fourteen and the girl only nine. William\'s father, Frederick Henry, commissioned the celebrated Flemish painter Van Dyck to portray the young Dutch prince and English princess on the occasion of their marriage in London. The union with the daughter of the English king enhanced the status of the House of Orange. On her gown, Mary wears a gift from William, a large diamond brooch.','The boy is fourteen and the girl only nine. William\'s father, Frederick Henry, commissioned the celebrated Flemish painter Van Dyck to portray the young Dutch prince and English princess on the occasion of their marriage in London.',1641,142,182,'Oil on canvas',1100.0000,1500.0000,'https://www.google.com/culturalinstitute/beta/asset/william-ii-prince-of-orange-and-his-bride-mary-stuart/ZQFrg3nK-U4BXQ',NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":97,\"green\":82,\"blue\":59},\"web\":\"#61523B\",\"name\":\"Judge Grey\"},{\"color\":{\"red\":172,\"green\":158,\"blue\":135},\"web\":\"#AC9E87\",\"name\":\"Napa\"},{\"color\":{\"red\":61,\"green\":48,\"blue\":32},\"web\":\"#3D3020\",\"name\":\"Cola\"},{\"color\":{\"red\":61,\"green\":54,\"blue\":45},\"web\":\"#3D362D\",\"name\":\"Jacko Bean\"},{\"color\":{\"red\":74,\"green\":39,\"blue\":28},\"web\":\"#4A271C\",\"name\":\"Morocco Brown\"},{\"color\":{\"red\":86,\"green\":80,\"blue\":70},\"web\":\"#565046\",\"name\":\"Mondo\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (598,141,6,'141010','Saint Margaret and the Dragon',1,'http://www.metmuseum.org/art/collection/search/436429','41.190.23','Open Access for Scholarly Content','Together with two other small panels, this depiction of Saint Margaret emerging from the mouth of a dragon formed part of the predella of an unidentified altarpiece. Supposedly martyred in 304, legend had it that Margaret was swallowed by Satan in the guise of a dragon, but emerged unscathed due to the cross she possessed.','Together with two other small panels, this depiction of Saint Margaret emerging from the mouth of a dragon formed part of the predella of an unidentified altarpiece.',1390,20,23,'Tempera on wood',1500.0000,1900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":202,\"green\":196,\"blue\":167},\"web\":\"#CAC4A7\",\"name\":\"Kangaroo\"},{\"color\":{\"red\":231,\"green\":225,\"blue\":163},\"web\":\"#E7E1A3\",\"name\":\"Pale Goldenrod\"},{\"color\":{\"red\":233,\"green\":231,\"blue\":188},\"web\":\"#E9E7BC\",\"name\":\"Tusk\"},{\"color\":{\"red\":218,\"green\":205,\"blue\":140},\"web\":\"#DACD8C\",\"name\":\"Sandwisp\"},{\"color\":{\"red\":192,\"green\":137,\"blue\":127},\"web\":\"#C0897F\",\"name\":\"Oriental Pink\"},{\"color\":{\"red\":190,\"green\":143,\"blue\":148},\"web\":\"#BE8F94\",\"name\":\"Viola\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (599,141,6,'141020','The Trinity',5,'http://www.metmuseum.org/art/collection/search/436428','41.100.33','Open Access for Scholarly Content','This imposing representation of the Trinity (God the Father, his son Jesus on the cross, and the dove of the Holy Spirit) was painted about 1390 and is probably the center of a triptych. Among the leading painters in late-fourteenth-century Florence, Agnolo\'s work, with its pastel colors and delicate modeling, was especially important for Lorenzo Monaco, whose four prophets hang nearby.','This imposing representation of the Trinity (God the Father, his son Jesus on the cross, and the dove of the Holy Spirit) was painted about 1390 and is probably the center of a triptych.',1395,70,129,'Tempera on wood',1800.0000,2200.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":229,\"green\":195,\"blue\":105},\"web\":\"#E5C369\",\"name\":\"Chenin\"},{\"color\":{\"red\":232,\"green\":170,\"blue\":62},\"web\":\"#e8aa3e\",\"name\":\"Tulip Tree\"},{\"color\":{\"red\":64,\"green\":47,\"blue\":24},\"web\":\"#402F18\",\"name\":\"Cola\"},{\"color\":{\"red\":248,\"green\":234,\"blue\":207},\"web\":\"#F8EACF\",\"name\":\"Gin Fizz\"},{\"color\":{\"red\":113,\"green\":74,\"blue\":26},\"web\":\"#714A1A\",\"name\":\"Raw Umber\"},{\"color\":{\"red\":199,\"green\":119,\"blue\":45},\"web\":\"#c7772d\",\"name\":\"Bronze\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (600,133,22,'133040','The Godmother\'s Departure (After Confirmation)',1,'https://digital.belvedere.at/objects/6067/der-abschied-der-patin-nach-der-firmung','353','Creative Commons License CC BY-SA 4.0',NULL,NULL,1859,61,80,'Oil on canvas',1000.0000,1400.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":139,\"green\":118,\"blue\":85},\"web\":\"#8B7655\",\"name\":\"Cement\"},{\"color\":{\"red\":31,\"green\":25,\"blue\":20},\"web\":\"#1F1914\",\"name\":\"Bokara Grey\"},{\"color\":{\"red\":160,\"green\":111,\"blue\":64},\"web\":\"#A06F40\",\"name\":\"Bourbon\"},{\"color\":{\"red\":181,\"green\":93,\"blue\":68},\"web\":\"#B55D44\",\"name\":\"Flame Pea\"},{\"color\":{\"red\":153,\"green\":112,\"blue\":88},\"web\":\"#997058\",\"name\":\"Beaver\"},{\"color\":{\"red\":86,\"green\":122,\"blue\":137},\"web\":\"#567A89\",\"name\":\"Hoki\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (601,29,82,'029090','Death and Life',1,'https://www.leopoldmuseum.org/en/leopoldcollection/masterpieces/41','630','&copy; Leopold Museum','Death and Life is an oil on canvas painting by Austrian symbolist painter, Gustav Klimt whose primary subject was the female body. His paintings, murals, and sketches are marked by a sensual eroticism, which is especially apparent in his pencil drawings. The painting was started in 1908 and completed in 1915. It is created in an Art Nouveau (Modern) style by use of allegorical painting genre during Golden phase. This is one of Klimt’s central themes, central also to his time and to his contemporaries among them Edvard Munch and Egon Schiele. Klimt makes of it a modern dance of death, but unlike Schiele, he introduces a note of hope and reconciliation, instead of feeling threatened by the figure of death, his human beings seem to disregard it.','Death and Life is an oil on canvas painting by Austrian symbolist painter, Gustav Klimt whose primary subject was the female body. ',1910,2005,1805,'Oil on canvas',198.0000,178.0000,'https://artsandculture.google.com/asset/death-and-life/YgFW0Kwjd_ptXQ',NULL,'https://en.wikipedia.org/wiki/Death_and_Life','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":2},\"dominantColors\":[{\"color\":{\"red\":157,\"green\":112,\"blue\":88},\"web\":\"#9D7058\",\"name\":\"Toast\"},{\"color\":{\"red\":36,\"green\":42,\"blue\":45},\"web\":\"#242a2d\",\"name\":\"Cinder\"},{\"color\":{\"red\":144,\"green\":118,\"blue\":90},\"web\":\"#90765A\",\"name\":\"Pale Brown\"},{\"color\":{\"red\":161,\"green\":155,\"blue\":149},\"web\":\"#A19B95\",\"name\":\"Zorba\"},{\"color\":{\"red\":150,\"green\":110,\"blue\":115},\"web\":\"#966E73\",\"name\":\"Turkish Rose\"},{\"color\":{\"red\":81,\"green\":100,\"blue\":140},\"web\":\"#51648c\",\"name\":\"Kashmir Blue\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (602,29,22,'029070','Johanna Staude',1,'https://digital.belvedere.at/objects/4302/johanna-staude','5551','Creative Commons License CC BY-SA 4.0','The half portrait of Johanna Staude (1883-1967) is one of Klimt’s last portraits.','The half portrait of Johanna Staude (1883-1967) is one of Klimt’s last portraits.',1918,50,70,'Oil on canvas',1400.0000,1900.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":12,\"green\":34,\"blue\":27},\"web\":\"#0C221B\",\"name\":\"Dark Green\"},{\"color\":{\"red\":46,\"green\":130,\"blue\":147},\"web\":\"#2E8293\",\"name\":\"Scooter\"},{\"color\":{\"red\":45,\"green\":165,\"blue\":171},\"web\":\"#2DA5AB\",\"name\":\"Pelorous\"},{\"color\":{\"red\":203,\"green\":192,\"blue\":167},\"web\":\"#CBC0A7\",\"name\":\"Double Spanish White\"},{\"color\":{\"red\":194,\"green\":120,\"blue\":74},\"web\":\"#c2784a\",\"name\":\"Brandy Punch\"},{\"color\":{\"red\":188,\"green\":80,\"blue\":56},\"web\":\"#bc5038\",\"name\":\"Grenadier\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (603,29,22,'029080','Avenue in the Park of Schloss Kammer',3,'https://digital.belvedere.at/objects/8691/allee-zum-schloss-kammer','2892','Creative Commons License CC BY-SA 4.0',NULL,NULL,1912,110,110,'Oil on canvas',1000.0000,1200.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":75,\"green\":124,\"blue\":102},\"web\":\"#4b7c66\",\"name\":\"Viridian\"},{\"color\":{\"red\":194,\"green\":201,\"blue\":132},\"web\":\"#C2C984\",\"name\":\"Pine Glade\"},{\"color\":{\"red\":92,\"green\":128,\"blue\":134},\"web\":\"#5c8086\",\"name\":\"Hoki\"},{\"color\":{\"red\":54,\"green\":108,\"blue\":106},\"web\":\"#366c6a\",\"name\":\"Genoa\"},{\"color\":{\"red\":117,\"green\":139,\"blue\":69},\"web\":\"#758b45\",\"name\":\"Wasabi\"},{\"color\":{\"red\":165,\"green\":189,\"blue\":185},\"web\":\"#a5bdb9\",\"name\":\"Opal\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (604,137,22,'137050','Sea beach in the fog',2,'https://digital.belvedere.at/objects/2495/meeresstrand-im-nebel','3700','Creative Commons License CC BY-SA 4.0',NULL,NULL,1807,34,50,'Oil on canvas',700.0000,900.0000,NULL,NULL,'https://commons.wikimedia.org/wiki/File:Caspar_David_Friedrich_-_Meeresstrand_im_Nebel.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":155,\"green\":161,\"blue\":149},\"web\":\"#9BA195\",\"name\":\"Delta\"},{\"color\":{\"red\":67,\"green\":56,\"blue\":38},\"web\":\"#433826\",\"name\":\"Jacko Bean\"},{\"color\":{\"red\":116,\"green\":126,\"blue\":115},\"web\":\"#747E73\",\"name\":\"Davy\'s Grey\"},{\"color\":{\"red\":177,\"green\":181,\"blue\":168},\"web\":\"#B1B5A8\",\"name\":\"Silver Chalice\"},{\"color\":{\"red\":83,\"green\":78,\"blue\":60},\"web\":\"#534E3C\",\"name\":\"Panda\"},{\"color\":{\"red\":45,\"green\":36,\"blue\":25},\"web\":\"#2d2419\",\"name\":\"Black Magic\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (605,137,22,'137060','Rocky Ravine in the Elbe Sandstone Mountains',1,'https://digital.belvedere.at/objects/8389/felsenlandschaft-im-elbsandsteingebirge','2589','Creative Commons License CC BY-SA 4.0',NULL,NULL,1822,74,94,'Oil on canvas',700.0000,950.0000,'https://artsandculture.google.com/asset/rocky-landscape-in-the-elbe-sandstone-mountains/JQGp7w7smVLqyA',NULL,'https://commons.wikimedia.org/wiki/File:Rocky_Landscape_in_the_Elbe_Sandstone_Mountains_-_Caspar_David_Friedrich_-_Google_Cultural_Institute.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":39,\"green\":40,\"blue\":33},\"web\":\"#272821\",\"name\":\"Green Waterloo\"},{\"color\":{\"red\":217,\"green\":199,\"blue\":184},\"web\":\"#d9c7b8\",\"name\":\"Stark White\"},{\"color\":{\"red\":134,\"green\":112,\"blue\":95},\"web\":\"#86705f\",\"name\":\"Donkey Brown\"},{\"color\":{\"red\":86,\"green\":68,\"blue\":49},\"web\":\"#564431\",\"name\":\"Deep Bronze\"},{\"color\":{\"red\":175,\"green\":155,\"blue\":139},\"web\":\"#af9b8b\",\"name\":\"Zorba\"},{\"color\":{\"red\":148,\"green\":134,\"blue\":93},\"web\":\"#94865d\",\"name\":\"Granite Green\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (606,142,22,'142010','Eduard Kosmack',3,'https://digital.belvedere.at/objects/3456/eduard-kosmack','4702','Creative Commons License CC BY-SA 4.0',NULL,NULL,1910,100,100,'Oil on canvas',900.0000,1100.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":203,\"green\":187,\"blue\":163},\"web\":\"#CBBBA3\",\"name\":\"Grain Brown\"},{\"color\":{\"red\":85,\"green\":79,\"blue\":71},\"web\":\"#554F47\",\"name\":\"Mondo\"},{\"color\":{\"red\":183,\"green\":166,\"blue\":143},\"web\":\"#B7A68F\",\"name\":\"Pavlova\"},{\"color\":{\"red\":65,\"green\":59,\"blue\":53},\"web\":\"#413B35\",\"name\":\"Taupe\"},{\"color\":{\"red\":53,\"green\":89,\"blue\":77},\"web\":\"#35594d\",\"name\":\"Spectra\"},{\"color\":{\"red\":186,\"green\":92,\"blue\":31},\"web\":\"#ba5c1f\",\"name\":\"Christine\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (607,142,22,'142020','Death and the Maiden',2,'https://digital.belvedere.at/objects/1968/tod-und-madchen','3171','Creative Commons License CC BY-SA 4.0',NULL,NULL,1915,180,150,'Oil on canvas',900.0000,1100.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":152,\"green\":111,\"blue\":94},\"web\":\"#986F5E\",\"name\":\"Toast\"},{\"color\":{\"red\":70,\"green\":54,\"blue\":48},\"web\":\"#463630\",\"name\":\"Rebel\"},{\"color\":{\"red\":198,\"green\":191,\"blue\":180},\"web\":\"#C6BFB4\",\"name\":\"Cloud\"},{\"color\":{\"red\":139,\"green\":117,\"blue\":92},\"web\":\"#8B755C\",\"name\":\"Cement\"},{\"color\":{\"red\":169,\"green\":145,\"blue\":121},\"web\":\"#A99179\",\"name\":\"Sandrift\"},{\"color\":{\"red\":179,\"green\":139,\"blue\":122},\"web\":\"#B38B7A\",\"name\":\"Brandy Rose\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (608,142,22,'142030','Portrait of the Artist\'s Wife, Edith Schiele',1,'https://digital.belvedere.at/objects/1029/bildnis-der-frau-des-kunstlers-edith-schiele','1991','Creative Commons License CC BY-SA 4.0',NULL,NULL,1918,110,140,'Oil on canvas',900.0000,1100.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":52,\"green\":60,\"blue\":62},\"web\":\"#343C3E\",\"name\":\"Mine Shaft\"},{\"color\":{\"red\":125,\"green\":121,\"blue\":96},\"web\":\"#7D7960\",\"name\":\"Kokoda\"},{\"color\":{\"red\":156,\"green\":108,\"blue\":58},\"web\":\"#9C6C3A\",\"name\":\"Buttered Rum\"},{\"color\":{\"red\":73,\"green\":81,\"blue\":79},\"web\":\"#49514F\",\"name\":\"Corduroy\"},{\"color\":{\"red\":72,\"green\":86,\"blue\":111},\"web\":\"#48566F\",\"name\":\"East Bay\"},{\"color\":{\"red\":158,\"green\":153,\"blue\":129},\"web\":\"#9E9981\",\"name\":\"Grey Olive\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (609,142,22,'142040','Mother With Two Children, II',2,'https://digital.belvedere.at/objects/3267/mutter-mit-zwei-kindern-iii','4473','Creative Commons License CC BY-SA 4.0',NULL,NULL,1915,160,150,'Oil on canvas',1100.0000,1400.0000,NULL,NULL,NULL,'{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":201,\"green\":193,\"blue\":172},\"web\":\"#C9C1AC\",\"name\":\"Parchment\"},{\"color\":{\"red\":157,\"green\":103,\"blue\":58},\"web\":\"#9D673A\",\"name\":\"Mai Tai\"},{\"color\":{\"red\":166,\"green\":158,\"blue\":134},\"web\":\"#A69E86\",\"name\":\"Napa\"},{\"color\":{\"red\":131,\"green\":121,\"blue\":97},\"web\":\"#837961\",\"name\":\"Stonewall\"},{\"color\":{\"red\":231,\"green\":224,\"blue\":205},\"web\":\"#E7E0CD\",\"name\":\"Orange White\"},{\"color\":{\"red\":126,\"green\":76,\"blue\":35},\"web\":\"#7E4C23\",\"name\":\"Korma\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (610,143,22,'143010','Rudolf von Arthaber with his Children',1,'https://digital.belvedere.at/objects/8045/rudolf-von-arthaber-und-seine-kinder-rudolf-emilie-und-gust','2245','Creative Commons License CC BY-SA 4.0',NULL,NULL,1837,155,221,'Oil on canvas',1100.0000,1400.0000,NULL,NULL,'https://commons.wikimedia.org/wiki/File:Friedrich_von_Amerling_-_Rudolf_von_Arthaber_with_his_Children_-_WGA00262.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":62,\"green\":43,\"blue\":30},\"web\":\"#3e2b1e\",\"name\":\"Bistre\"},{\"color\":{\"red\":102,\"green\":61,\"blue\":31},\"web\":\"#663d1f\",\"name\":\"Dark Brown\"},{\"color\":{\"red\":182,\"green\":156,\"blue\":121},\"web\":\"#b69c79\",\"name\":\"Pale Taupe\"},{\"color\":{\"red\":175,\"green\":108,\"blue\":39},\"web\":\"#af6c27\",\"name\":\"Reno Sand\"},{\"color\":{\"red\":23,\"green\":41,\"blue\":62},\"web\":\"#17293e\",\"name\":\"Tangaroa\"},{\"color\":{\"red\":72,\"green\":87,\"blue\":39},\"web\":\"#485727\",\"name\":\"Clover\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`,`JsonAnnotations`) VALUES (611,143,22,'143020','Amelie Klein',1,'https://digital.belvedere.at/objects/2626/amalie-klein','3832','Creative Commons License CC BY-SA 4.0',NULL,NULL,1834,103,127,'Oil on canvas',1200.0000,1500.0000,NULL,NULL,'https://commons.wikimedia.org/wiki/File:Amerling%E2%80%93Amalie_Klein,_n%C3%A9e_von_Henikstein.jpg','{\"safeSearchAnnotation\":{\"violence\":1,\"racy\":1},\"dominantColors\":[{\"color\":{\"red\":60,\"green\":45,\"blue\":26},\"web\":\"#3C2D1A\",\"name\":\"Cola\"},{\"color\":{\"red\":115,\"green\":70,\"blue\":28},\"web\":\"#73461C\",\"name\":\"Antique Brass\"},{\"color\":{\"red\":36,\"green\":76,\"blue\":121},\"web\":\"#4A2816\",\"name\":\"Indian Tan\"},{\"color\":{\"red\":209,\"green\":192,\"blue\":184},\"web\":\"#d1c0b8\",\"name\":\"Wafer\"},{\"color\":{\"red\":23,\"green\":41,\"blue\":62},\"web\":\"#17293e\",\"name\":\"Tangaroa\"},{\"color\":{\"red\":175,\"green\":108,\"blue\":39},\"web\":\"#af6c27\",\"name\":\"Reno Sand\"}]}');
INSERT INTO `Paintings` (`PaintingID`,`ArtistID`,`GalleryID`,`ImageFileName`,`Title`,`ShapeID`,`MuseumLink`,`AccessionNumber`,`CopyrightText`,`Description`,`Excerpt`,`YearOfWork`,`Width`,`Height`,`Medium`,`Cost`,`MSRP`,`GoogleLink`,`GoogleDescription`,`WikiLink`