.equ LOCALID_PROF_OAK,        4
.equ LOCALID_BULBASAUR_BALL,  5
.equ LOCALID_SQUIRTLE_BALL,   6
.equ LOCALID_CHARMANDER_BALL, 7
.equ LOCALID_RIVAL,           8
.equ LOCALID_POKEDEX_1,       9
.equ LOCALID_POKEDEX_2,       10

.equ PLAYER_STARTER_NUM,      VAR_TEMP_1
.equ PLAYER_STARTER_SPECIES,  VAR_TEMP_2
.equ RIVAL_STARTER_SPECIES,   VAR_TEMP_3
.equ RIVAL_STARTER_ID,        VAR_TEMP_4

.equ SHOWED_OAK_COMPLETE_DEX, FLAG_TEMP_2

PalletTown_ProfessorOaksLab_MapScripts::
	map_script MAP_SCRIPT_ON_TRANSITION, PalletTown_ProfessorOaksLab_OnTransition
	map_script MAP_SCRIPT_ON_WARP_INTO_MAP_TABLE, PalletTown_ProfessorOaksLab_OnWarp
	map_script MAP_SCRIPT_ON_FRAME_TABLE, PalletTown_ProfessorOaksLab_OnFrame
	.byte 0

PalletTown_ProfessorOaksLab_OnTransition::
	setflag FLAG_VISITED_OAKS_LAB
	call_if_eq VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 1, PalletTown_ProfessorOaksLab_EventScript_ReadyOakForStarterScene
	call_if_eq VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 7, PalletTown_ProfessorOaksLab_EventScript_ReadyOakForNationalDexScene
	call_if_eq VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 8, PalletTown_ProfessorOaksLab_EventScript_SetNationalDexSceneFinished
	call_if_set FLAG_GOT_POKEBALLS_FROM_OAK_AFTER_22_RIVAL, PalletTown_ProfessorOaksLab_EventScript_SetSkipPokeBallCheck
	end

PalletTown_ProfessorOaksLab_EventScript_SetSkipPokeBallCheck::
	setflag FLAG_OAK_SKIP_22_RIVAL_CHECK
	return

PalletTown_ProfessorOaksLab_EventScript_SetNationalDexSceneFinished::
	setvar VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 9
	return

PalletTown_ProfessorOaksLab_EventScript_ReadyOakForStarterScene::
	setobjectxyperm LOCALID_PROF_OAK, 6, 11
	setobjectmovementtype LOCALID_PROF_OAK, MOVEMENT_TYPE_FACE_UP
	savebgm MUS_OAK
	return

PalletTown_ProfessorOaksLab_EventScript_ReadyOakForNationalDexScene::
	setobjectxyperm LOCALID_PROF_OAK, 6, 11
	setobjectmovementtype LOCALID_PROF_OAK, MOVEMENT_TYPE_FACE_UP
	return

PalletTown_ProfessorOaksLab_OnWarp::
	map_script_2 VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 1, PalletTown_ProfessorOaksLab_EventScript_ReadyPlayerForStarterScene
	.2byte 0

PalletTown_ProfessorOaksLab_EventScript_ReadyPlayerForStarterScene::
	turnobject OBJ_EVENT_ID_PLAYER, DIR_NORTH
	end

PalletTown_ProfessorOaksLab_OnFrame::
	map_script_2 VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 1, PalletTown_ProfessorOaksLab_ChooseStarterScene
	map_script_2 VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 7, PalletTown_ProfessorOaksLab_EventScript_EnterForNationalDexScene
	.2byte 0

PalletTown_ProfessorOaksLab_EventScript_EnterForNationalDexScene:: @ 8169002 
	lockall
	setvar VAR_FACING, DIR_NORTH
	textcolor NPC_TEXT_COLOR_MALE
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakEnter
	waitmovement 0
	removeobject LOCALID_PROF_OAK
	setobjectxyperm LOCALID_PROF_OAK, 6, 3
	setobjectmovementtype LOCALID_PROF_OAK, MOVEMENT_TYPE_FACE_DOWN
	clearflag FLAG_HIDE_OAK_IN_HIS_LAB
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_PlayerEnter
	waitmovement 0
	goto PalletTown_ProfessorOaksLab_EventScript_NationalDexScene
	end

PalletTown_ProfessorOaksLab_EventScript_NationalDexScene::
	msgbox PalletTown_ProfessorOaksLab_Text_OakSightingsOfRareMons
	closemessage
	call_if_eq VAR_FACING, DIR_NORTH, PalletTown_ProfessorOaksLab_EventScript_NationalDexSceneRivalEnterNorth
	call_if_eq VAR_FACING, DIR_SOUTH, PalletTown_ProfessorOaksLab_EventScript_NationalDexSceneRivalEnterSouth
	call_if_eq VAR_FACING, DIR_EAST, PalletTown_ProfessorOaksLab_EventScript_NationalDexSceneRivalEnterEastWest
	call_if_eq VAR_FACING, DIR_WEST, PalletTown_ProfessorOaksLab_EventScript_NationalDexSceneRivalEnterEastWest
	msgbox PalletTown_ProfessorOaksLab_Text_RivalJustLetMeHandleEverything
	fadedefaultbgm
	msgbox PalletTown_ProfessorOaksLab_Text_OakNeedYourHelpTooNeedToSeePokedexes
	call_if_eq VAR_FACING, DIR_NORTH, PalletTown_ProfessorOaksLab_EventScript_PlayerFaceOakNorth
	call_if_eq VAR_FACING, DIR_WEST, PalletTown_ProfessorOaksLab_EventScript_PlayerFaceOakWest
	textcolor NPC_TEXT_COLOR_NEUTRAL
	msgbox PalletTown_ProfessorOaksLab_Text_OakTookBothPokedexUnits
	closemessage
	call EventScript_RestorePrevTextColor
	call_if_eq VAR_FACING, DIR_NORTH, PalletTown_ProfessorOaksLab_EventScript_OakBringDexesToDeskNorth
	call_if_eq VAR_FACING, DIR_SOUTH, PalletTown_ProfessorOaksLab_EventScript_OakBringDexesToDeskSouth
	call_if_eq VAR_FACING, DIR_EAST, PalletTown_ProfessorOaksLab_EventScript_OakBringDexesToDeskEast
	call_if_eq VAR_FACING, DIR_WEST, PalletTown_ProfessorOaksLab_EventScript_OakBringDexesToDeskWest
	addobject LOCALID_POKEDEX_1
	addobject LOCALID_POKEDEX_2
	delay 30
	msgbox PalletTown_ProfessorOaksLab_Text_OakNowTheseUnitsCanRecordMoreData
	closemessage
	removeobject LOCALID_POKEDEX_1
	removeobject LOCALID_POKEDEX_2
	delay 30
	call_if_eq VAR_FACING, DIR_NORTH, PalletTown_ProfessorOaksLab_EventScript_OakBringDexesOverNorth
	call_if_eq VAR_FACING, DIR_SOUTH, PalletTown_ProfessorOaksLab_EventScript_OakBringDexesOverSouth
	call_if_eq VAR_FACING, DIR_EAST, PalletTown_ProfessorOaksLab_EventScript_OakBringDexesOverEast
	call_if_eq VAR_FACING, DIR_WEST, PalletTown_ProfessorOaksLab_EventScript_OakBringDexesOverWest
	textcolor NPC_TEXT_COLOR_NEUTRAL
	playfanfare MUS_OBTAIN_KEY_ITEM
	message PalletTown_ProfessorOaksLab_Text_PlayersPokedexWasUpgraded
	waitmessage
	waitfanfare
	call EventScript_RestorePrevTextColor
	special EnableNationalPokedex
	msgbox PalletTown_ProfessorOaksLab_Text_OakMustReallyWorkToFillPokedex
	msgbox PalletTown_ProfessorOaksLab_Text_RivalIllCompleteThePokedex
	closemessage
	playbgm MUS_RIVAL_EXIT, 0
	call_if_eq VAR_FACING, DIR_NORTH, PalletTown_ProfessorOaksLab_EventScript_RivalExitNorth
	call_if_eq VAR_FACING, DIR_SOUTH, PalletTown_ProfessorOaksLab_EventScript_RivalExit
	call_if_eq VAR_FACING, DIR_EAST, PalletTown_ProfessorOaksLab_EventScript_RivalExit
	call_if_eq VAR_FACING, DIR_WEST, PalletTown_ProfessorOaksLab_EventScript_RivalExit
	removeobject LOCALID_RIVAL
	fadedefaultbgm
	setvar VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 8
	releaseall
	end

PalletTown_ProfessorOaksLab_EventScript_NationalDexSceneRivalEnterNorth::
	setobjectxyperm LOCALID_RIVAL, 5, 10
	addobject LOCALID_RIVAL
	playbgm MUS_ENCOUNTER_RIVAL, 0
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_WatchRivalEnterNorth
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalEnter
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_NationalDexSceneRivalEnterEastWest::
	setobjectxyperm LOCALID_RIVAL, 6, 10
	addobject LOCALID_RIVAL
	playbgm MUS_ENCOUNTER_RIVAL, 0
	applymovement LOCALID_PROF_OAK, Common_Movement_WalkInPlaceFasterDown
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_WatchRivalEnterEastWest
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalEnter
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_NationalDexSceneRivalEnterSouth::
	setobjectxyperm LOCALID_RIVAL, 6, 10
	addobject LOCALID_RIVAL
	playbgm MUS_ENCOUNTER_RIVAL, 0
	applymovement LOCALID_PROF_OAK, Common_Movement_WalkInPlaceFasterDown
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalEnter
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_PlayerFaceOakNorth::
	applymovement OBJ_EVENT_ID_PLAYER, Common_Movement_WalkInPlaceFasterUp
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_PlayerFaceOakWest::
	applymovement OBJ_EVENT_ID_PLAYER, Common_Movement_WalkInPlaceFasterLeft
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_OakBringDexesToDeskNorth::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakBringDexesToDesk
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_OakBringDexesToDeskSouth::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakBringDexesToDeskSouth
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_WatchOakWalkToDesk
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_WatchOakWalkToDesk
	waitmovement LOCALID_PROF_OAK
	return

PalletTown_ProfessorOaksLab_EventScript_OakBringDexesToDeskEast::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakBringDexesToDesk
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_WatchOakWalkToDeskEast
	waitmovement LOCALID_PROF_OAK
	return

PalletTown_ProfessorOaksLab_EventScript_OakBringDexesToDeskWest::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakBringDexesToDesk
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_Movement_OakBringDexesToDesk::
	walk_up
	walk_left
	walk_in_place_faster_up
	delay_16
	delay_4
	step_end

PalletTown_ProfessorOaksLab_Movement_OakBringDexesToDeskSouth::
	walk_left
	walk_left
	walk_up
	delay_16
	delay_4
	step_end

PalletTown_ProfessorOaksLab_ChooseStarterScene::
	lockall
	textcolor NPC_TEXT_COLOR_MALE
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakEnter
	waitmovement 0
	removeobject LOCALID_PROF_OAK
	setobjectxyperm LOCALID_PROF_OAK, 6, 3
	setobjectmovementtype LOCALID_PROF_OAK, MOVEMENT_TYPE_FACE_DOWN
	clearflag FLAG_HIDE_OAK_IN_HIS_LAB
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_PlayerEnter
	waitmovement 0
	applymovement LOCALID_RIVAL, Common_Movement_WalkInPlaceFasterUp
	waitmovement 0
	clearflag FLAG_DONT_TRANSITION_MUSIC
	savebgm MUS_DUMMY
	fadedefaultbgm
	msgbox PalletTown_ProfessorOaksLab_Text_RivalFedUpWithWaiting
	closemessage
	delay 60
	msgbox PalletTown_ProfessorOaksLab_Text_OakThreeMonsChooseOne
	closemessage
	delay 30
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalReact
	waitmovement 0
	msgbox PalletTown_ProfessorOaksLab_Text_RivalNoFairWhatAboutMe
	msgbox PalletTown_ProfessorOaksLab_Text_OakBePatientRival
	setvar VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 2
	releaseall
	end

PalletTown_ProfessorOaksLab_Movement_OakEnter::
	walk_up
	walk_up
	walk_up
	walk_up
	walk_up
	walk_up
	step_end

PalletTown_ProfessorOaksLab_Movement_PlayerEnter::
	walk_up
	walk_up
	walk_up
	walk_up
	walk_up
	walk_up
	walk_up
	walk_up
	step_end

PalletTown_ProfessorOaksLab_Movement_RivalReact::
	walk_in_place_up
	walk_in_place_up
	step_end

PalletTown_ProfessorOaksLab_EventScript_LeaveStarterSceneTrigger::
	lockall
	textcolor NPC_TEXT_COLOR_MALE
	applymovement LOCALID_PROF_OAK, Common_Movement_FaceDown
	waitmovement 0
	msgbox PalletTown_ProfessorOaksLab_Text_OakHeyDontGoAwayYet
	closemessage
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_PlayerWalkUp
	waitmovement 0
	releaseall
	end

PalletTown_ProfessorOaksLab_Movement_PlayerWalkUp::
	walk_up
	step_end

PalletTown_ProfessorOaksLab_EventScript_RivalBattleTriggerLeft::
	lockall
	setvar VAR_TEMP_2, 1
	goto PalletTown_ProfessorOaksLab_EventScript_RivalBattle
	end

PalletTown_ProfessorOaksLab_EventScript_RivalBattleTriggerMid::
	lockall
	setvar VAR_TEMP_2, 2
	goto PalletTown_ProfessorOaksLab_EventScript_RivalBattle
	end

PalletTown_ProfessorOaksLab_EventScript_RivalBattleTriggerRight::
	lockall
	setvar VAR_TEMP_2, 3
	goto PalletTown_ProfessorOaksLab_EventScript_RivalBattle
	end

PalletTown_ProfessorOaksLab_EventScript_RivalBattle::
	textcolor NPC_TEXT_COLOR_MALE
	playbgm MUS_ENCOUNTER_RIVAL, 0
	applymovement LOCALID_RIVAL, Common_Movement_WalkInPlaceFasterDown
	waitmovement 0
	applymovement OBJ_EVENT_ID_PLAYER, Common_Movement_WalkInPlaceFasterUp
	waitmovement 0
	msgbox PalletTown_ProfessorOaksLab_Text_RivalLetsCheckOutMons
	closemessage
	applymovement LOCALID_PROF_OAK, Common_Movement_FaceDown
	waitmovement 0
	goto_if_eq VAR_STARTER_MON, 0, PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleCharmander
	goto_if_eq VAR_STARTER_MON, 1, PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleBulbasaur
	goto_if_eq VAR_STARTER_MON, 2, PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleSquirtle
	end

@ The scripts for the rival approaching the player for battle are a bit bloated because
@ both the player and rival can be in 3 different positions, so theres 9 different approaches
@ NOTE: Names below refer to the Rival's mon (e.g. for RivalBattleSquirtle, player has Charmander)

PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleSquirtle::
	goto_if_eq VAR_TEMP_2, 1, PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleSquirtleLeft
	goto_if_eq VAR_TEMP_2, 2, PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleSquirtleMid
	goto_if_eq VAR_TEMP_2, 3, PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleSquirtleRight
	end

PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleSquirtleLeft::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalApproachForBattleSquirtleLeft
	waitmovement 0
	goto PalletTown_ProfessorOaksLab_EventScript_RivalBattleSquirtle
	end

PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleSquirtleMid::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalApproachForBattleSquirtleMid
	waitmovement 0
	goto PalletTown_ProfessorOaksLab_EventScript_RivalBattleSquirtle
	end

PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleSquirtleRight::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalApproachForBattleSquirtleRight
	waitmovement 0
	goto PalletTown_ProfessorOaksLab_EventScript_RivalBattleSquirtle
	end

PalletTown_ProfessorOaksLab_EventScript_RivalBattleSquirtle::
	trainerbattle_earlyrival TRAINER_RIVAL_OAKS_LAB_SQUIRTLE, RIVAL_BATTLE_TUTORIAL, PalletTown_ProfessorOaksLab_Text_RivalDefeat, Text_RivalVictory
	goto PalletTown_ProfessorOaksLab_EventScript_EndRivalBattle
	end

PalletTown_ProfessorOaksLab_Movement_RivalApproachForBattleSquirtleLeft::
	walk_left
	walk_left
	walk_left
	walk_left
	walk_down
	walk_down
	step_end

PalletTown_ProfessorOaksLab_Movement_RivalApproachForBattleSquirtleMid::
	walk_left
	walk_left
	walk_left
	walk_down
	walk_down
	step_end

PalletTown_ProfessorOaksLab_Movement_RivalApproachForBattleSquirtleRight::
	walk_left
	walk_left
	walk_down
	walk_down
	step_end

PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleCharmander::
	goto_if_eq VAR_TEMP_2, 1, PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleCharmanderLeft
	goto_if_eq VAR_TEMP_2, 2, PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleCharmanderMid
	goto_if_eq VAR_TEMP_2, 3, PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleCharmanderRight
	end

PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleCharmanderLeft::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_ApproachForBattleCharmanderLeft
	waitmovement 0
	goto PalletTown_ProfessorOaksLab_EventScript_RivalBattleCharmander
	end

PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleCharmanderMid::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_ApproachForBattleCharmanderMid
	waitmovement 0
	goto PalletTown_ProfessorOaksLab_EventScript_RivalBattleCharmander
	end

PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleCharmanderRight::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_ApproachForBattleCharmanderRight
	waitmovement 0
	goto PalletTown_ProfessorOaksLab_EventScript_RivalBattleCharmander
	end

PalletTown_ProfessorOaksLab_EventScript_RivalBattleCharmander::
	trainerbattle_earlyrival TRAINER_RIVAL_OAKS_LAB_CHARMANDER, RIVAL_BATTLE_TUTORIAL, PalletTown_ProfessorOaksLab_Text_RivalDefeat, Text_RivalVictory
	goto PalletTown_ProfessorOaksLab_EventScript_EndRivalBattle
	end

PalletTown_ProfessorOaksLab_Movement_ApproachForBattleCharmanderLeft::
	walk_left
	walk_left
	walk_left
	walk_left
	walk_left
	walk_down
	walk_down
	step_end

PalletTown_ProfessorOaksLab_Movement_ApproachForBattleCharmanderMid::
	walk_left
	walk_left
	walk_left
	walk_left
	walk_down
	walk_down
	step_end

PalletTown_ProfessorOaksLab_Movement_ApproachForBattleCharmanderRight::
	walk_left
	walk_left
	walk_left
	walk_down
	walk_down
	step_end

PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleBulbasaur::
	goto_if_eq VAR_TEMP_2, 1, PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleBulbasaurLeft
	goto_if_eq VAR_TEMP_2, 2, PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleBulbasaurMid
	goto_if_eq VAR_TEMP_2, 3, PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleBulbasaurRight
	end

PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleBulbasaurLeft::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalApproachForBattleBulbasaurLeft
	waitmovement 0
	goto PalletTown_ProfessorOaksLab_EventScript_RivalBattleBulbasaur
	end

PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleBulbasaurMid::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalApproachForBattleBulbasaurMid
	waitmovement 0
	goto PalletTown_ProfessorOaksLab_EventScript_RivalBattleBulbasaur
	end

PalletTown_ProfessorOaksLab_EventScript_RivalApproachForBattleBulbasaurRight::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalApproachForBattleBulbasaurRight
	waitmovement 0
	goto PalletTown_ProfessorOaksLab_EventScript_RivalBattleBulbasaur
	end

PalletTown_ProfessorOaksLab_EventScript_RivalBattleBulbasaur::
	trainerbattle_earlyrival TRAINER_RIVAL_OAKS_LAB_BULBASAUR, RIVAL_BATTLE_TUTORIAL, PalletTown_ProfessorOaksLab_Text_RivalDefeat, Text_RivalVictory
	goto PalletTown_ProfessorOaksLab_EventScript_EndRivalBattle
	end

PalletTown_ProfessorOaksLab_Movement_RivalApproachForBattleBulbasaurLeft::
	walk_left
	walk_left
	walk_left
	walk_down
	walk_down
	step_end

PalletTown_ProfessorOaksLab_Movement_RivalApproachForBattleBulbasaurMid::
	walk_left
	walk_left
	walk_down
	walk_down
	step_end

PalletTown_ProfessorOaksLab_Movement_RivalApproachForBattleBulbasaurRight::
	walk_left
	walk_down
	walk_down
	step_end

PalletTown_ProfessorOaksLab_EventScript_EndRivalBattle::
	special HealPlayerParty
	msgbox PalletTown_ProfessorOaksLab_Text_RivalGoToughenMyMon
	closemessage
	playbgm MUS_RIVAL_EXIT, 0
	call_if_eq VAR_TEMP_2, 1, PalletTown_ProfessorOaksLab_EventScript_RivalExitAfterBattleLeft
	call_if_eq VAR_TEMP_2, 2, PalletTown_ProfessorOaksLab_EventScript_RivalExitAfterBattleMid
	call_if_eq VAR_TEMP_2, 3, PalletTown_ProfessorOaksLab_EventScript_RivalExitAfterBattleRight
	removeobject LOCALID_RIVAL
	playse SE_EXIT
	fadedefaultbgm
	setvar VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 4
	setflag FLAG_BEAT_RIVAL_IN_OAKS_LAB
	releaseall
	end

PalletTown_ProfessorOaksLab_EventScript_RivalExitAfterBattleLeft::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalExitAfterBattleLeft
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_PlayerWatchRivalExitAfterBattle
	waitmovement LOCALID_RIVAL
	return

PalletTown_ProfessorOaksLab_EventScript_RivalExitAfterBattleMid::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalExitAfterBattleMid
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_PlayerWatchRivalExitAfterBattle
	waitmovement LOCALID_RIVAL
	return

PalletTown_ProfessorOaksLab_EventScript_RivalExitAfterBattleRight::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalExitAfterBattleRight
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_PlayerWatchRivalExitAfterBattleRight
	waitmovement LOCALID_RIVAL
	return

PalletTown_ProfessorOaksLab_Movement_RivalExitAfterBattleLeft::
	walk_right
	walk_down
	walk_down
	walk_down
	walk_down
	walk_down
	delay_8
	step_end

PalletTown_ProfessorOaksLab_Movement_RivalExitAfterBattleRight::
	walk_left
	walk_down
	walk_down
	walk_down
	walk_down
	walk_down
	delay_8
	step_end

PalletTown_ProfessorOaksLab_Movement_RivalExitAfterBattleMid::
	walk_right
	walk_down
	walk_down
	walk_down
	walk_left
	walk_down
	walk_down
	delay_8
	step_end

PalletTown_ProfessorOaksLab_Movement_PlayerWatchRivalExitAfterBattle::
	delay_16
	delay_8
	walk_in_place_faster_right
	delay_16
	walk_in_place_faster_down
	step_end

PalletTown_ProfessorOaksLab_Movement_PlayerWatchRivalExitAfterBattleRight::
	delay_16
	delay_8
	walk_in_place_faster_left
	delay_16
	walk_in_place_faster_down
	step_end

PalletTown_ProfessorOaksLab_EventScript_Rival::
	lock
	faceplayer
	goto_if_eq VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 3, PalletTown_ProfessorOaksLab_EventScript_RivalChoseStarter
	goto_if_eq VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 2, PalletTown_ProfessorOaksLab_EventScript_RivalWaitingForStarter
	msgbox PalletTown_ProfessorOaksLab_Text_RivalGrampsIsntAround
	release
	end

PalletTown_ProfessorOaksLab_EventScript_RivalWaitingForStarter::
	msgbox PalletTown_ProfessorOaksLab_Text_RivalGoChoosePlayer
	release
	end

PalletTown_ProfessorOaksLab_EventScript_RivalChoseStarter::
	msgbox PalletTown_ProfessorOaksLab_Text_RivalMyMonLooksTougher
	release
	end

PalletTown_ProfessorOaksLab_EventScript_ProfOak::
	lock
	faceplayer
	goto_if_set SHOWED_OAK_COMPLETE_DEX, PalletTown_ProfessorOaksLab_EventScript_OakJustShownCompleteDex
	goto_if_eq VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 9, PalletTown_ProfessorOaksLab_EventScript_RatePokedex
	goto_if_eq VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 8, PalletTown_ProfessorOaksLab_EventScript_MonsAroundWorldWait
	goto_if_set FLAG_SYS_GAME_CLEAR, PalletTown_ProfessorOaksLab_EventScript_TryStartNationalDexScene
	goto_if_eq VAR_MAP_SCENE_CERULEAN_CITY_RIVAL, 1, PalletTown_ProfessorOaksLab_EventScript_RatePokedex
	goto_if_eq VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 6, PalletTown_ProfessorOaksLab_EventScript_RatePokedexOrTryGiveBalls
	goto_if_ge VAR_MAP_SCENE_VIRIDIAN_CITY_MART, 1, PalletTown_ProfessorOaksLab_EventScript_ReceiveDexScene
	goto_if_eq VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 4, PalletTown_ProfessorOaksLab_EventScript_OakBattleMonForItToGrow
	goto_if_eq VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 3, PalletTown_ProfessorOaksLab_EventScript_OakCanReachNextTownWithMon
	msgbox PalletTown_ProfessorOaksLab_Text_OakWhichOneWillYouChoose
	release
	end

PalletTown_ProfessorOaksLab_EventScript_OakJustShownCompleteDex::
	msgbox PokedexRating_Text_ThankYouMadeDreamReality
	release
	end

PalletTown_ProfessorOaksLab_EventScript_OakCanReachNextTownWithMon::
	msgbox PalletTown_ProfessorOaksLab_Text_OakCanReachNextTownWithMon
	release
	end

PalletTown_ProfessorOaksLab_EventScript_OakBattleMonForItToGrow::
	msgbox PalletTown_ProfessorOaksLab_Text_OakBattleMonForItToGrow
	release
	end

PalletTown_ProfessorOaksLab_EventScript_ReceiveDexScene::
	msgbox PalletTown_ProfessorOaksLab_Text_OakHaveSomethingForMe
	textcolor NPC_TEXT_COLOR_NEUTRAL
	playfanfare MUS_OBTAIN_TMHM
	message PalletTown_ProfessorOaksLab_Text_DeliveredOaksParcel
	waitmessage
	waitfanfare
	call EventScript_RestorePrevTextColor
	removeitem ITEM_OAKS_PARCEL
	msgbox PalletTown_ProfessorOaksLab_Text_OakCustomBallIOrdered
	playbgm MUS_ENCOUNTER_RIVAL, 0
	msgbox PalletTown_ProfessorOaksLab_Text_RivalGramps
	closemessage
	call_if_eq VAR_FACING, DIR_NORTH, PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalEnterNorth
	call_if_eq VAR_FACING, DIR_SOUTH, PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalEnterSouth
	call_if_eq VAR_FACING, DIR_EAST, PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalEnterEastWest
	call_if_eq VAR_FACING, DIR_WEST, PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalEnterEastWest
	fadedefaultbgm
	msgbox PalletTown_ProfessorOaksLab_Text_RivalWhatDidYouCallMeFor
	closemessage
	delay 30
	playse SE_PIN
	applymovement LOCALID_PROF_OAK, Common_Movement_ExclamationMark
	waitmovement 0
	applymovement LOCALID_PROF_OAK, Common_Movement_Delay48
	waitmovement 0
	call_if_eq VAR_FACING, DIR_SOUTH, PalletTown_ProfessorOaksLab_EventScript_DexSceneOakFacePlayerAndRivalSouth
	call_if_eq VAR_FACING, DIR_EAST, PalletTown_ProfessorOaksLab_EventScript_DexSceneOakFacePlayerAndRivalEast
	call_if_eq VAR_FACING, DIR_WEST, PalletTown_ProfessorOaksLab_EventScript_DexSceneOakFacePlayerAndRivalWest
	call_if_eq VAR_FACING, DIR_NORTH, PalletTown_ProfessorOaksLab_EventScript_DexSceneOakFacePlayerAndRivalNorth
	msgbox PalletTown_ProfessorOaksLab_Text_OakHaveRequestForYouTwo
	closemessage
	call_if_eq VAR_FACING, DIR_NORTH, PalletTown_ProfessorOaksLab_EventScript_DexSceneOakWalkToDeskNorth
	call_if_eq VAR_FACING, DIR_SOUTH, PalletTown_ProfessorOaksLab_EventScript_DexSceneOakWalkToDeskSouth
	call_if_eq VAR_FACING, DIR_EAST, PalletTown_ProfessorOaksLab_EventScript_DexSceneOakWalkToDeskEast
	call_if_eq VAR_FACING, DIR_WEST, PalletTown_ProfessorOaksLab_EventScript_DexSceneOakWalkToDeskWest
	msgbox PalletTown_ProfessorOaksLab_Text_OakPokedexOnDesk
	closemessage
	delay 40
	msgbox PalletTown_ProfessorOaksLab_Text_OakTakeTheseWithYou
	closemessage
	applymovement LOCALID_PROF_OAK, Common_Movement_WalkInPlaceFasterUp
	waitmovement 0
	removeobject LOCALID_POKEDEX_1
	delay 10
	removeobject LOCALID_POKEDEX_2
	delay 25
	call_if_eq VAR_FACING, DIR_NORTH, PalletTown_ProfessorOaksLab_EventScript_OakBringDexesOverNorth
	call_if_eq VAR_FACING, DIR_SOUTH, PalletTown_ProfessorOaksLab_EventScript_OakBringDexesOverSouth
	call_if_eq VAR_FACING, DIR_EAST, PalletTown_ProfessorOaksLab_EventScript_OakBringDexesOverEast
	call_if_eq VAR_FACING, DIR_WEST, PalletTown_ProfessorOaksLab_EventScript_OakBringDexesOverWest
	delay 10
	textcolor NPC_TEXT_COLOR_NEUTRAL
	playfanfare MUS_OBTAIN_KEY_ITEM
	message PalletTown_ProfessorOaksLab_Text_ReceivedPokedexFromOak
	waitmessage
	waitfanfare
	call EventScript_RestorePrevTextColor
	setflag FLAG_SYS_POKEDEX_GET
	special SetUnlockedPokedexFlags
	setvar VAR_MAP_SCENE_POKEMON_CENTER_TEALA, 1
	msgbox PalletTown_ProfessorOaksLab_Text_OakCatchMonsForDataTakeThese
	giveitem_msg PalletTown_ProfessorOaksLab_Text_ReceivedFivePokeBalls, ITEM_POKE_BALL, 5
	msgbox PalletTown_ProfessorOaksLab_Text_OakExplainCatching
	famechecker FAMECHECKER_OAK, 1
	msgbox PalletTown_ProfessorOaksLab_Text_OakCompleteMonGuideWasMyDream
	msgbox PalletTown_ProfessorOaksLab_Text_RivalLeaveItToMeGramps
	call_if_eq VAR_FACING, DIR_NORTH, PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalFacePlayerNorth
	call_if_eq VAR_FACING, DIR_SOUTH, PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalFacePlayerSouth
	call_if_eq VAR_FACING, DIR_EAST, PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalFacePlayerEastWest
	call_if_eq VAR_FACING, DIR_WEST, PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalFacePlayerEastWest
	msgbox PalletTown_ProfessorOaksLab_Text_RivalTellSisNotToGiveYouMap
	closemessage
	playbgm MUS_RIVAL_EXIT, 0
	call_if_eq VAR_FACING, DIR_NORTH, PalletTown_ProfessorOaksLab_EventScript_RivalExitNorth
	call_if_eq VAR_FACING, DIR_SOUTH, PalletTown_ProfessorOaksLab_EventScript_RivalExit
	call_if_eq VAR_FACING, DIR_EAST, PalletTown_ProfessorOaksLab_EventScript_RivalExit
	call_if_eq VAR_FACING, DIR_WEST, PalletTown_ProfessorOaksLab_EventScript_RivalExit
	removeobject LOCALID_RIVAL
	fadedefaultbgm
	setvar VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 6
	setvar VAR_MAP_SCENE_VIRIDIAN_CITY_MART, 2
	setvar VAR_MAP_SCENE_VIRIDIAN_CITY_OLD_MAN, 1
	setvar VAR_MAP_SCENE_PALLET_TOWN_RIVALS_HOUSE, 1
	setvar VAR_MAP_SCENE_ROUTE22, 1
	release
	end

PalletTown_ProfessorOaksLab_EventScript_OakBringDexesOverNorth::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakBringDexesOver
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_OakBringDexesOverSouth::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakBringDexesOverSouth
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_OakBringDexesOverEast::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakBringDexesOver
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_PlayerFaceOakForDexEast
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_OakBringDexesOverWest::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakBringDexesOver
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_Movement_PlayerFaceOakForDexEast::
	delay_16
	delay_8
	walk_in_place_faster_right
	step_end

PalletTown_ProfessorOaksLab_Movement_OakBringDexesOver::
	walk_right
	walk_down
	step_end

PalletTown_ProfessorOaksLab_Movement_OakBringDexesOverSouth::
	walk_down
	walk_right
	step_end

PalletTown_ProfessorOaksLab_EventScript_DexSceneOakWalkToDeskNorth::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakWalkToDesk
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_DexSceneOakWalkToDeskSouth::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakWalkToDeskSouth
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_WatchOakWalkToDesk
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_WatchOakWalkToDesk
	waitmovement LOCALID_PROF_OAK
	return

PalletTown_ProfessorOaksLab_EventScript_DexSceneOakWalkToDeskEast::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakWalkToDesk
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_WatchOakWalkToDeskEast
	waitmovement LOCALID_PROF_OAK
	return

PalletTown_ProfessorOaksLab_EventScript_DexSceneOakWalkToDeskWest::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakWalkToDesk
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_Movement_WatchOakWalkToDeskEast::
	delay_16
	delay_8
	walk_in_place_faster_up
	step_end

PalletTown_ProfessorOaksLab_Movement_WatchOakWalkToDesk::
	delay_16
	delay_8
	walk_in_place_faster_left
	step_end

PalletTown_ProfessorOaksLab_Movement_OakWalkToDesk::
	walk_up
	walk_left
	delay_16
	walk_in_place_faster_down
	step_end

PalletTown_ProfessorOaksLab_Movement_OakWalkToDeskSouth::
	walk_left
	walk_left
	walk_up
	delay_16
	walk_in_place_faster_right
	step_end

PalletTown_ProfessorOaksLab_EventScript_RatePokedexOrTryGiveBalls::
	setvar VAR_0x8004, 0
	specialvar VAR_RESULT, GetPokedexCount
	copyvar VAR_0x8008, VAR_0x8005
	copyvar VAR_0x8009, VAR_0x8006
	buffernumberstring STR_VAR_1, VAR_0x8008
	buffernumberstring STR_VAR_2, VAR_0x8009
	goto_if_eq VAR_0x8009, 1, PalletTown_ProfessorOaksLab_EventScript_CheckIfPlayerNeedsBalls  @ Player only has starter
	goto PalletTown_ProfessorOaksLab_EventScript_RatePokedex
	end

PalletTown_ProfessorOaksLab_EventScript_RatePokedex::
	call PokedexRating_EventScript_RateInPerson
	goto_if_set FLAG_OAK_SAW_DEX_COMPLETION, PalletTown_ProfessorOaksLab_EventScript_DexCompleted
	release
	end

PalletTown_ProfessorOaksLab_EventScript_DexCompleted::
	closemessage
	delay 40
	message PokedexRating_Text_Wroooaaarrr
	waitmessage
	call_if_eq VAR_FACING, DIR_NORTH, PalletTown_ProfessorOaksLab_EventScript_OakExcitedNorth
	call_if_eq VAR_FACING, DIR_SOUTH, PalletTown_ProfessorOaksLab_EventScript_OakExcitedSouth
	call_if_eq VAR_FACING, DIR_EAST, PalletTown_ProfessorOaksLab_EventScript_OakExcitedEast
	call_if_eq VAR_FACING, DIR_WEST, PalletTown_ProfessorOaksLab_EventScript_OakExcitedWest
	applymovement LOCALID_PROF_OAK, Common_Movement_FacePlayer
	waitmovement 0
	closemessage
	delay 70
	msgbox PokedexRating_Text_ThankYouMadeDreamReality
	setflag SHOWED_OAK_COMPLETE_DEX
	release
	end

PalletTown_ProfessorOaksLab_EventScript_OakExcitedNorth::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakExcitedNorth
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_OakExcitedSouth::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakExcitedSouth
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_OakExcitedEast::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakExcitedEast
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_OakExcitedWest::
	applymovement LOCALID_PROF_OAK, PalletTown_ProfessorOaksLab_Movement_OakExcitedWest
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_Movement_OakExcitedNorth::
	walk_in_place_down
	walk_in_place_fast_down
	walk_in_place_down
	walk_in_place_down
	walk_in_place_fast_down
	walk_in_place_down
	step_end

PalletTown_ProfessorOaksLab_Movement_OakExcitedSouth::
	walk_in_place_up
	walk_in_place_fast_up
	walk_in_place_up
	walk_in_place_up
	walk_in_place_fast_up
	walk_in_place_up
	step_end

PalletTown_ProfessorOaksLab_Movement_OakExcitedEast::
	walk_in_place_left
	walk_in_place_fast_left
	walk_in_place_left
	walk_in_place_left
	walk_in_place_fast_left
	walk_in_place_left
	step_end

PalletTown_ProfessorOaksLab_Movement_OakExcitedWest::
	walk_in_place_right
	walk_in_place_fast_right
	walk_in_place_right
	walk_in_place_right
	walk_in_place_fast_right
	walk_in_place_right
	step_end

@ Unused
PalletTown_ProfessorOaksLab_Movement_Search:
	walk_left
	walk_in_place_faster_down
	delay_8
	walk_in_place_faster_right
	delay_8
	walk_in_place_faster_up
	delay_8
	walk_in_place_faster_left
	delay_8
	walk_in_place_faster_down
	delay_8
	walk_right
	walk_right
	walk_in_place_faster_up
	delay_8
	walk_in_place_faster_left
	delay_8
	walk_in_place_faster_down
	delay_8
	walk_in_place_faster_right
	delay_8
	walk_in_place_faster_up
	delay_8
	walk_left
	step_end

@ Unused
PalletTown_ProfessorOaksLab_Movement_VerticalPacing:
	walk_up
	walk_down
	walk_down
	walk_in_place_down
	walk_up
	delay_16
	delay_16
	delay_16
	step_end

PalletTown_ProfessorOaksLab_EventScript_TryStartNationalDexScene::
	call PokedexRating_EventScript_RateInPerson
	closemessage
	goto_if_lt VAR_0x8009, 60, PalletTown_ProfessorOaksLab_EventScript_DontStartNationalDexScene
	goto_if_unset FLAG_WORLD_MAP_ONE_ISLAND, PalletTown_ProfessorOaksLab_EventScript_DontStartNationalDexScene
	delay 30
	msgbox PalletTown_ProfessorOaksLab_Text_OakFavorToAskYouPlayer
	goto PalletTown_ProfessorOaksLab_EventScript_NationalDexScene
	end

PalletTown_ProfessorOaksLab_EventScript_DontStartNationalDexScene::
	release
	end

PalletTown_ProfessorOaksLab_EventScript_CheckIfPlayerNeedsBalls::
	goto_if_questlog EventScript_ReleaseEnd
	special QuestLog_CutRecording
	goto_if_set FLAG_OAK_SKIP_22_RIVAL_CHECK, PalletTown_ProfessorOaksLab_EventScript_MonsAroundWorldWait
	goto_if_set FLAG_GOT_POKEBALLS_FROM_OAK_AFTER_22_RIVAL, PalletTown_ProfessorOaksLab_EventScript_PlayerAlreadyGotBalls
	checkitem ITEM_POKE_BALL
	goto_if_eq VAR_RESULT, FALSE, PalletTown_ProfessorOaksLab_EventScript_PlayerOutOfBalls
	goto PalletTown_ProfessorOaksLab_EventScript_MonsAroundWorldWait
	end

PalletTown_ProfessorOaksLab_EventScript_PlayerOutOfBalls::
	goto_if_ge VAR_MAP_SCENE_ROUTE22, 2, PalletTown_ProfessorOaksLab_EventScript_GivePlayerMoreBalls
	goto PalletTown_ProfessorOaksLab_EventScript_MonsAroundWorldWait
	end

PalletTown_ProfessorOaksLab_EventScript_GivePlayerMoreBalls::
	msgbox PalletTown_ProfessorOaksLab_Text_OakAddedNothingToPokedex
	giveitem_msg PalletTown_ProfessorOaksLab_Text_ReceivedFivePokeBalls, ITEM_POKE_BALL, 5
	setflag FLAG_GOT_POKEBALLS_FROM_OAK_AFTER_22_RIVAL
	release
	end

PalletTown_ProfessorOaksLab_EventScript_MonsAroundWorldWait::
	msgbox PalletTown_ProfessorOaksLab_Text_OakMonsAroundWorldWait
	release
	end

PalletTown_ProfessorOaksLab_EventScript_PlayerAlreadyGotBalls::
	msgbox PalletTown_ProfessorOaksLab_Text_OakComeSeeMeSometime
	release
	end

PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalEnterNorth::
	setobjectxyperm LOCALID_RIVAL, 5, 10
	addobject LOCALID_RIVAL
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_WatchRivalEnterNorth
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalEnter
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalEnterEastWest::
	setobjectxyperm LOCALID_RIVAL, 6, 10
	addobject LOCALID_RIVAL
	applymovement LOCALID_PROF_OAK, Common_Movement_WalkInPlaceFasterDown
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_WatchRivalEnterEastWest
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalEnter
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalEnterSouth::
	setobjectxyperm LOCALID_RIVAL, 6, 10
	addobject LOCALID_RIVAL
	applymovement LOCALID_PROF_OAK, Common_Movement_WalkInPlaceFasterDown
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalEnter
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_DexSceneOakFacePlayerAndRivalSouth::
	applymovement LOCALID_PROF_OAK, Common_Movement_FacePlayer
	waitmovement 0
	delay 15
	applymovement LOCALID_PROF_OAK, Common_Movement_WalkInPlaceFasterDown
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_DexSceneOakFacePlayerAndRivalWest::
	applymovement LOCALID_PROF_OAK, Common_Movement_FacePlayer
	waitmovement 0
	delay 15
	applymovement OBJ_EVENT_ID_PLAYER, Common_Movement_WalkInPlaceFasterLeft
	applymovement LOCALID_PROF_OAK, Common_Movement_WalkInPlaceFasterDown
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_DexSceneOakFacePlayerAndRivalEast::
	applymovement LOCALID_PROF_OAK, Common_Movement_FacePlayer
	waitmovement 0
	delay 15
	applymovement OBJ_EVENT_ID_PLAYER, Common_Movement_WalkInPlaceFasterRight
	applymovement LOCALID_PROF_OAK, Common_Movement_WalkInPlaceFasterDown
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalFacePlayerNorth::
	applymovement LOCALID_RIVAL, Common_Movement_FacePlayer
	applymovement OBJ_EVENT_ID_PLAYER, Common_Movement_WalkInPlaceFasterLeft
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalFacePlayerSouth::
	applymovement LOCALID_RIVAL, Common_Movement_WalkInPlaceFasterUp
	applymovement OBJ_EVENT_ID_PLAYER, Common_Movement_WalkInPlaceFasterDown
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_DexSceneRivalFacePlayerEastWest::
	applymovement LOCALID_RIVAL, Common_Movement_FacePlayer
	applymovement OBJ_EVENT_ID_PLAYER, Common_Movement_WalkInPlaceFasterDown
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_RivalExitNorth::
	applymovement OBJ_EVENT_ID_PLAYER, PalletTown_ProfessorOaksLab_Movement_WatchRivalEnterEastWest
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalExit
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_RivalExit::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalExit
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_EventScript_DexSceneOakFacePlayerAndRivalNorth::
	applymovement OBJ_EVENT_ID_PLAYER, Common_Movement_WalkInPlaceFasterUp
	waitmovement 0
	return

PalletTown_ProfessorOaksLab_Movement_WatchRivalEnterEastWest::
	delay_4
	walk_in_place_faster_down
	step_end

PalletTown_ProfessorOaksLab_Movement_WatchRivalEnterNorth::
	walk_in_place_faster_down
	delay_16
	delay_16
	delay_16
	delay_16
	delay_16
	delay_8
	walk_in_place_faster_left
	step_end

PalletTown_ProfessorOaksLab_Movement_RivalEnter::
	walk_up
	walk_up
	walk_up
	walk_up
	walk_up
	walk_up
	step_end

PalletTown_ProfessorOaksLab_Movement_RivalExit::
	walk_down
	walk_down
	walk_down
	walk_down
	walk_down
	walk_down
	step_end

PalletTown_ProfessorOaksLab_EventScript_BulbasaurBall::
	lock
	faceplayer
	setvar PLAYER_STARTER_NUM, 0
	setvar PLAYER_STARTER_SPECIES, SPECIES_BULBASAUR
	setvar RIVAL_STARTER_SPECIES, SPECIES_CHARMANDER
	setvar RIVAL_STARTER_ID, LOCALID_CHARMANDER_BALL
	goto_if_ge VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 3, PalletTown_ProfessorOaksLab_EventScript_LastPokeBall
	goto_if_eq VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 2, PalletTown_ProfessorOaksLab_EventScript_ConfirmStarterChoice
	msgbox PalletTown_ProfessorOaksLab_Text_ThoseArePokeBalls
	release
	end

PalletTown_ProfessorOaksLab_EventScript_ConfirmStarterChoice::
	applymovement LOCALID_PROF_OAK, Common_Movement_FaceRight
	waitmovement 0
	showmonpic PLAYER_STARTER_SPECIES, 10, 3
	textcolor NPC_TEXT_COLOR_MALE
	goto_if_eq PLAYER_STARTER_NUM, 0, PalletTown_ProfessorOaksLab_EventScript_ConfirmBulbasaur
	goto_if_eq PLAYER_STARTER_NUM, 1, PalletTown_ProfessorOaksLab_EventScript_ConfirmSquirtle
	goto_if_eq PLAYER_STARTER_NUM, 2, PalletTown_ProfessorOaksLab_EventScript_ConfirmCharmander
	end

PalletTown_ProfessorOaksLab_EventScript_ConfirmBulbasaur::
	msgbox PalletTown_ProfessorOaksLab_Text_OakChoosingBulbasaur, MSGBOX_YESNO
	goto_if_eq VAR_RESULT, YES, PalletTown_ProfessorOaksLab_EventScript_ChoseStarter
	goto_if_eq VAR_RESULT, NO, PalletTown_ProfessorOaksLab_EventScript_DeclinedStarter
	end

PalletTown_ProfessorOaksLab_EventScript_ConfirmSquirtle::
	msgbox PalletTown_ProfessorOaksLab_Text_OakChoosingSquirtle, MSGBOX_YESNO
	goto_if_eq VAR_RESULT, YES, PalletTown_ProfessorOaksLab_EventScript_ChoseStarter
	goto_if_eq VAR_RESULT, NO, PalletTown_ProfessorOaksLab_EventScript_DeclinedStarter
	end

PalletTown_ProfessorOaksLab_EventScript_ConfirmCharmander::
	msgbox PalletTown_ProfessorOaksLab_Text_OakChoosingCharmander, MSGBOX_YESNO
	goto_if_eq VAR_RESULT, YES, PalletTown_ProfessorOaksLab_EventScript_ChoseStarter
	goto_if_eq VAR_RESULT, NO, PalletTown_ProfessorOaksLab_EventScript_DeclinedStarter
	end

PalletTown_ProfessorOaksLab_EventScript_DeclinedStarter::
	hidemonpic
	release
	end

PalletTown_ProfessorOaksLab_EventScript_ChoseStarter::
	hidemonpic
	removeobject VAR_LAST_TALKED
	msgbox PalletTown_ProfessorOaksLab_Text_OakThisMonIsEnergetic
	call EventScript_RestorePrevTextColor
	setflag FLAG_SYS_POKEMON_GET
	setflag FLAG_PALLET_LADY_NOT_BLOCKING_SIGN
	givemon PLAYER_STARTER_SPECIES, 5
	copyvar VAR_STARTER_MON, PLAYER_STARTER_NUM
	bufferspeciesname STR_VAR_1, PLAYER_STARTER_SPECIES
	message PalletTown_ProfessorOaksLab_Text_ReceivedMonFromOak
	waitmessage
	playfanfare MUS_OBTAIN_KEY_ITEM
	waitfanfare
	msgbox Text_GiveNicknameToThisMon, MSGBOX_YESNO
	goto_if_eq VAR_RESULT, YES, EventScript_GiveNicknameToStarter
	goto_if_eq VAR_RESULT, NO, PalletTown_ProfessorOaksLab_EventScript_RivalPicksStarter
	end

EventScript_GiveNicknameToStarter::
	setvar VAR_0x8004, 0
	call EventScript_ChangePokemonNickname
	goto PalletTown_ProfessorOaksLab_EventScript_RivalPicksStarter
	end

PalletTown_ProfessorOaksLab_EventScript_RivalPicksStarter::
	closemessage
	goto_if_eq PLAYER_STARTER_NUM, 0, PalletTown_ProfessorOaksLab_EventScript_RivalWalksToCharmander
	goto_if_eq PLAYER_STARTER_NUM, 1, PalletTown_ProfessorOaksLab_EventScript_RivalWalksToBulbasaur
	goto_if_eq PLAYER_STARTER_NUM, 2, PalletTown_ProfessorOaksLab_EventScript_RivalWalksToSquirtle
	end

PalletTown_ProfessorOaksLab_EventScript_RivalWalksToCharmander::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalWalksToCharmander
	waitmovement 0
	goto PalletTown_ProfessorOaksLab_EventScript_RivalTakesStarter
	end

PalletTown_ProfessorOaksLab_EventScript_RivalWalksToSquirtle::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalWalksToSquirtle
	waitmovement 0
	goto PalletTown_ProfessorOaksLab_EventScript_RivalTakesStarter
	end

PalletTown_ProfessorOaksLab_EventScript_RivalWalksToBulbasaur::
	applymovement LOCALID_RIVAL, PalletTown_ProfessorOaksLab_Movement_RivalWalksToBulbasaur
	waitmovement 0
	goto PalletTown_ProfessorOaksLab_EventScript_RivalTakesStarter
	end

PalletTown_ProfessorOaksLab_EventScript_RivalTakesStarter::
	textcolor NPC_TEXT_COLOR_MALE
	msgbox PalletTown_ProfessorOaksLab_Text_RivalIllTakeThisOneThen
	removeobject RIVAL_STARTER_ID
	textcolor NPC_TEXT_COLOR_NEUTRAL
	bufferspeciesname STR_VAR_1, RIVAL_STARTER_SPECIES
	message PalletTown_ProfessorOaksLab_Text_RivalReceivedMonFromOak
	waitmessage
	playfanfare MUS_OBTAIN_KEY_ITEM
	waitfanfare
	setvar VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 3
	call_if_set FLAG_OPENED_START_MENU, PalletTown_ProfessorOaksLab_EventScript_ReadyEndSignLadyScene
	release
	end

PalletTown_ProfessorOaksLab_EventScript_ReadyEndSignLadyScene::
	setvar VAR_MAP_SCENE_PALLET_TOWN_SIGN_LADY, 1
	return

PalletTown_ProfessorOaksLab_Movement_RivalWalksToCharmander::
	walk_down
	walk_down
	walk_right
	walk_right
	walk_right
	walk_right
	walk_right
	walk_up
	step_end

PalletTown_ProfessorOaksLab_Movement_RivalWalksToSquirtle::
	walk_down
	walk_right
	walk_right
	walk_right
	walk_right
	walk_in_place_faster_up
	step_end

PalletTown_ProfessorOaksLab_Movement_RivalWalksToBulbasaur::
	walk_down
	walk_right
	walk_right
	walk_right
	walk_in_place_faster_up
	step_end

PalletTown_ProfessorOaksLab_EventScript_SquirtleBall::
	lock
	faceplayer
	setvar PLAYER_STARTER_NUM, 1
	setvar PLAYER_STARTER_SPECIES, SPECIES_SQUIRTLE
	setvar RIVAL_STARTER_SPECIES, SPECIES_BULBASAUR
	setvar RIVAL_STARTER_ID, LOCALID_BULBASAUR_BALL
	goto_if_ge VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 3, PalletTown_ProfessorOaksLab_EventScript_LastPokeBall
	goto_if_eq VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 2, PalletTown_ProfessorOaksLab_EventScript_ConfirmStarterChoice
	msgbox PalletTown_ProfessorOaksLab_Text_ThoseArePokeBalls
	release
	end

PalletTown_ProfessorOaksLab_EventScript_CharmanderBall::
	lock
	faceplayer
	setvar PLAYER_STARTER_NUM, 2
	setvar PLAYER_STARTER_SPECIES, SPECIES_CHARMANDER
	setvar RIVAL_STARTER_SPECIES, SPECIES_SQUIRTLE
	setvar RIVAL_STARTER_ID, LOCALID_SQUIRTLE_BALL
	goto_if_ge VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 3, PalletTown_ProfessorOaksLab_EventScript_LastPokeBall
	goto_if_eq VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 2, PalletTown_ProfessorOaksLab_EventScript_ConfirmStarterChoice
	msgbox PalletTown_ProfessorOaksLab_Text_ThoseArePokeBalls
	release
	end

PalletTown_ProfessorOaksLab_EventScript_LastPokeBall::
	msgbox PalletTown_ProfessorOaksLab_Text_OaksLastMon
	release
	end

PalletTown_ProfessorOaksLab_EventScript_Aide1::
	lock
	faceplayer
	goto_if_set FLAG_SYS_GAME_CLEAR, PalletTown_ProfessorOaksLab_EventScript_Aide1GameClear
	msgbox PalletTown_ProfessorOaksLab_Text_StudyAsOaksAide
	release
	end

PalletTown_ProfessorOaksLab_EventScript_Aide1GameClear::
	famechecker FAMECHECKER_OAK, 5
	msgbox PalletTown_ProfessorOaksLab_Text_OakIsGoingToHaveRadioShow
	release
	end

PalletTown_ProfessorOaksLab_EventScript_Aide2::
	lock
	faceplayer
	goto_if_set FLAG_SYS_GAME_CLEAR, PalletTown_ProfessorOaksLab_EventScript_Aide2GameClear
	msgbox PalletTown_ProfessorOaksLab_Text_StudyAsOaksAide
	release
	end

PalletTown_ProfessorOaksLab_EventScript_Aide2GameClear::
	famechecker FAMECHECKER_DAISY, 0
	msgbox PalletTown_ProfessorOaksLab_Text_DaisyWillGroomMons
	release
	end

PalletTown_ProfessorOaksLab_EventScript_Aide3::
	lock
	faceplayer
	famechecker FAMECHECKER_OAK, 2
	msgbox PalletTown_ProfessorOaksLab_Text_OakIsAuthorityOnMons
	release
	end

PalletTown_ProfessorOaksLab_EventScript_Pokedex::
	msgbox PalletTown_ProfessorOaksLab_Text_BlankEncyclopedia, MSGBOX_NPC
	end

PalletTown_ProfessorOaksLab_EventScript_Computer::
	msgbox PalletTown_ProfessorOaksLab_Text_EmailMessage, MSGBOX_SIGN
	end

PalletTown_ProfessorOaksLab_EventScript_LeftSign::
	msgbox PalletTown_ProfessorOaksLab_Text_PressStartToOpenMenu, MSGBOX_SIGN
	end

PalletTown_ProfessorOaksLab_EventScript_RightSign::
	lockall
	goto_if_ge VAR_MAP_SCENE_PALLET_TOWN_PROFESSOR_OAKS_LAB, 6, PalletTown_ProfessorOaksLab_EventScript_RightSignAlt
	msgbox PalletTown_ProfessorOaksLab_Text_SaveOptionInMenu
	releaseall
	end

PalletTown_ProfessorOaksLab_EventScript_RightSignAlt::
	msgbox PalletTown_ProfessorOaksLab_Text_AllMonTypesHaveStrongAndWeakPoints
	releaseall
	end
