.set LOCALID_PLAYER, 1
.set LOCALID_ATTENDANT_1, 2
.set LOCALID_ATTENDANT_2, 3
.set LOCALID_PARTNER, 4

BattleFrontier_BattleTowerMultiCorridor_MapScripts::
	map_script MAP_SCRIPT_ON_TRANSITION, BattleFrontier_BattleTowerMultiCorridor_OnTransition
	map_script MAP_SCRIPT_ON_WARP_INTO_MAP_TABLE, BattleFrontier_BattleTowerMultiCorridor_OnWarp
	map_script MAP_SCRIPT_ON_FRAME_TABLE, BattleFrontier_BattleTowerMultiCorridor_OnFrame
	.byte 0

	@ On this map the player (OBJ_EVENT_ID_PLAYER) is hidden
	@ The player is represented instead by LOCALID_PLAYER, and has the gfx id VAR_OBJ_GFX_ID_F
	@ The multi partner is represented by LOCALID_PARTNER, and has the gfx id VAR_OBJ_GFX_ID_E

BattleFrontier_BattleTowerMultiCorridor_OnTransition:
	call_if_eq VAR_FRONTIER_BATTLE_MODE, FRONTIER_MODE_MULTIS, BattleFrontier_BattleTowerMultiCorridor_EventScript_SetObjGfx
	call_if_eq VAR_FRONTIER_BATTLE_MODE, FRONTIER_MODE_LINK_MULTIS, BattleFrontier_BattleTowerMultiCorridor_EventScript_SetLinkPlayerGfx
	end

BattleFrontier_BattleTowerMultiCorridor_EventScript_SetObjGfx::
	tower_setpartnergfx
	checkplayergender
	goto_if_eq VAR_RESULT, FEMALE, BattleFrontier_BattleTowerMultiCorridor_EventScript_SetPlayerGfxFemale
	setvar VAR_OBJ_GFX_ID_F, OBJ_EVENT_GFX_BRENDAN_NORMAL
	return

BattleFrontier_BattleTowerMultiCorridor_EventScript_SetPlayerGfxFemale::
	setvar VAR_OBJ_GFX_ID_F, OBJ_EVENT_GFX_MAY_NORMAL
	return

BattleFrontier_BattleTowerMultiCorridor_EventScript_SetLinkPlayerGfx::
	special SetBattleTowerLinkPlayerGfx
	return

BattleFrontier_BattleTowerMultiCorridor_OnWarp:
	map_script_2 VAR_TEMP_1, 0, BattleFrontier_BattleTowerMultiCorridor_EventScript_SetUpObjects
	.2byte 0

BattleFrontier_BattleTowerMultiCorridor_EventScript_SetUpObjects::
	hideobjectat OBJ_EVENT_ID_PLAYER, MAP_BATTLE_FRONTIER_BATTLE_TOWER_MULTI_CORRIDOR
	hideobjectat LOCALID_PLAYER, MAP_BATTLE_FRONTIER_BATTLE_TOWER_MULTI_CORRIDOR
	hideobjectat LOCALID_PARTNER, MAP_BATTLE_FRONTIER_BATTLE_TOWER_MULTI_CORRIDOR
	special OffsetCameraForBattle
	end

BattleFrontier_BattleTowerMultiCorridor_OnFrame:
	map_script_2 VAR_TEMP_1, 0, BattleFrontier_BattleTowerMultiCorridor_EventScript_EnterCorridor
	.2byte 0

BattleFrontier_BattleTowerMultiCorridor_EventScript_EnterCorridor::
	lockall
	setflag FLAG_ENABLE_MULTI_CORRIDOR_DOOR
	setvar VAR_0x8004, 14  @ x coord of far door, used by DrawDoor
	setvar VAR_0x8005, 1   @ y coord of far door, used by DrawDoor
	opendoor 1, 1
	waitdooranim
	clearflag FLAG_ENABLE_MULTI_CORRIDOR_DOOR
	showobjectat LOCALID_PLAYER, MAP_BATTLE_FRONTIER_BATTLE_TOWER_MULTI_CORRIDOR
	showobjectat LOCALID_PARTNER, MAP_BATTLE_FRONTIER_BATTLE_TOWER_MULTI_CORRIDOR
	applymovement LOCALID_PLAYER, BattleFrontier_BattleTowerMultiCorridor_Movement_ExitElevator
	applymovement LOCALID_PARTNER, BattleFrontier_BattleTowerMultiCorridor_Movement_ExitElevator
	waitmovement 0
	setflag FLAG_ENABLE_MULTI_CORRIDOR_DOOR
	setvar VAR_0x8004, 14  @ x coord of far door, used by DrawDoor
	setvar VAR_0x8005, 1   @ y coord of far door, used by DrawDoor
	closedoor 1, 1
	waitdooranim
	clearflag FLAG_ENABLE_MULTI_CORRIDOR_DOOR
	applymovement LOCALID_PLAYER, BattleFrontier_BattleTowerMultiCorridor_Movement_PlayerWalkToDoor
	applymovement LOCALID_PARTNER, BattleFrontier_BattleTowerMultiCorridor_Movement_PartnerWalkToDoor
	applymovement LOCALID_ATTENDANT_2, BattleFrontier_BattleTowerMultiCorridor_Movement_PlayerAttendantWalkToDoor
	applymovement LOCALID_ATTENDANT_1, BattleFrontier_BattleTowerMultiCorridor_Movement_PartnerAttendantWalkToDoor
	waitmovement 0
	delay 40
	applymovement LOCALID_ATTENDANT_2, Common_Movement_WalkInPlaceFasterUp
	applymovement LOCALID_ATTENDANT_1, Common_Movement_WalkInPlaceFasterUp
	waitmovement 0
	opendoor 7, 1
	waitdooranim
	applymovement LOCALID_ATTENDANT_2, BattleFrontier_BattleTowerMultiCorridor_Movement_AttendantEnterDoor
	applymovement LOCALID_ATTENDANT_1, BattleFrontier_BattleTowerMultiCorridor_Movement_AttendantEnterDoor
	applymovement LOCALID_PLAYER, BattleFrontier_BattleTowerMultiCorridor_Movement_TrainerEnterDoor
	applymovement LOCALID_PARTNER, BattleFrontier_BattleTowerMultiCorridor_Movement_TrainerEnterDoor
	waitmovement 0
	closedoor 7, 1
	waitdooranim
	delay 30
	setvar VAR_TEMP_1, 1
	call BattleFrontier_BattleTowerMultiCorridor_EventScript_WarpToBattleRoom
	releaseall
	end

BattleFrontier_BattleTowerMultiCorridor_EventScript_WarpToBattleRoom::
	call_if_eq VAR_FRONTIER_BATTLE_MODE, FRONTIER_MODE_SINGLES, BattleFrontier_BattleTowerMultiCorridor_EventScript_WarpToNormalBattleRoom
	call_if_eq VAR_FRONTIER_BATTLE_MODE, FRONTIER_MODE_DOUBLES, BattleFrontier_BattleTowerMultiCorridor_EventScript_WarpToNormalBattleRoom
	call_if_eq VAR_FRONTIER_BATTLE_MODE, FRONTIER_MODE_MULTIS, BattleFrontier_BattleTowerMultiCorridor_EventScript_WarpToMultiBattleRoom
	call_if_eq VAR_FRONTIER_BATTLE_MODE, FRONTIER_MODE_LINK_MULTIS, BattleFrontier_BattleTowerMultiCorridor_EventScript_WarpToLinkMultiBattleRoom
	return

BattleFrontier_BattleTowerMultiCorridor_EventScript_WarpToNormalBattleRoom::
	warp MAP_BATTLE_FRONTIER_BATTLE_TOWER_BATTLE_ROOM, 4, 8
	waitstate
	return

BattleFrontier_BattleTowerMultiCorridor_EventScript_WarpToMultiBattleRoom::
	warp MAP_BATTLE_FRONTIER_BATTLE_TOWER_MULTI_BATTLE_ROOM, 4, 5
	waitstate
	return

@ Unnecessary duplicate of the above
BattleFrontier_BattleTowerMultiCorridor_EventScript_WarpToLinkMultiBattleRoom::
	warp MAP_BATTLE_FRONTIER_BATTLE_TOWER_MULTI_BATTLE_ROOM, 4, 5
	waitstate
	return

BattleFrontier_BattleTowerMultiCorridor_Movement_PlayerWalkToDoor:
	walk_down
	walk_right
	walk_right
	walk_right
	walk_right
	walk_right
	walk_right
	step_end

BattleFrontier_BattleTowerMultiCorridor_Movement_PartnerWalkToDoor:
	walk_down
	walk_left
	walk_left
	walk_left
	walk_left
	walk_left
	walk_left
	step_end

BattleFrontier_BattleTowerMultiCorridor_Movement_PlayerAttendantWalkToDoor:
	walk_right
	walk_right
	walk_right
	walk_right
	walk_right
	walk_right
	walk_up
	walk_in_place_faster_right
	step_end

BattleFrontier_BattleTowerMultiCorridor_Movement_PartnerAttendantWalkToDoor:
	walk_left
	walk_left
	walk_left
	walk_left
	walk_left
	walk_left
	walk_up
	walk_in_place_faster_left
	step_end

BattleFrontier_BattleTowerMultiCorridor_Movement_TrainerEnterDoor:
	delay_16
	walk_up
	walk_up
	set_invisible
	step_end

BattleFrontier_BattleTowerMultiCorridor_Movement_AttendantEnterDoor:
	walk_up
	set_invisible
	step_end

BattleFrontier_BattleTowerMultiCorridor_Movement_ExitElevator:
	walk_down
	step_end

