.set LOCALID_OPPONENT_1, 1
.set LOCALID_ATTENDANT_1, 2
.set LOCALID_ATTENDANT_2, 3
.set LOCALID_OPPONENT_2, 4
.set LOCALID_PLAYER, 5
.set LOCALID_PARTNER, 6

BattleFrontier_BattleTowerMultiBattleRoom_MapScripts::
	map_script MAP_SCRIPT_ON_TRANSITION, BattleFrontier_BattleTowerMultiBattleRoom_OnTransition
	map_script MAP_SCRIPT_ON_WARP_INTO_MAP_TABLE, BattleFrontier_BattleTowerMultiBattleRoom_OnWarp
	map_script MAP_SCRIPT_ON_FRAME_TABLE, BattleFrontier_BattleTowerMultiBattleRoom_OnFrame
	.byte 0

	@ On this map the player (OBJ_EVENT_ID_PLAYER) is hidden
	@ The player is represented instead by LOCALID_PLAYER, which has the gfx id VAR_OBJ_GFX_ID_F
	@ The multi partner is represented by LOCALID_PARTNER, which has the gfx id VAR_OBJ_GFX_ID_E

BattleFrontier_BattleTowerMultiBattleRoom_OnTransition:
	call_if_eq VAR_FRONTIER_BATTLE_MODE, FRONTIER_MODE_MULTIS, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_SetObjGfx
	call_if_eq VAR_FRONTIER_BATTLE_MODE, FRONTIER_MODE_LINK_MULTIS, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_SetLinkPlayerGfx
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_SetObjGfx::
	tower_setpartnergfx
	checkplayergender
	goto_if_eq VAR_RESULT, FEMALE, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_SetPlayerGfxFemale
	setvar VAR_OBJ_GFX_ID_F, OBJ_EVENT_GFX_BRENDAN_NORMAL
	return

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_SetPlayerGfxFemale::
	setvar VAR_OBJ_GFX_ID_F, OBJ_EVENT_GFX_MAY_NORMAL
	return

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_SetLinkPlayerGfx::
	special SetBattleTowerLinkPlayerGfx
	return

BattleFrontier_BattleTowerMultiBattleRoom_OnWarp:
	map_script_2 VAR_TEMP_1, 0, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_HidePlayerObj
	.2byte 0

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_HidePlayerObj::
	hideobjectat OBJ_EVENT_ID_PLAYER, MAP_BATTLE_FRONTIER_BATTLE_TOWER_MULTI_BATTLE_ROOM
	end

BattleFrontier_BattleTowerMultiBattleRoom_OnFrame:
	map_script_2 VAR_TEMP_0, 0, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_EnterRoom
	.2byte 0

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_EnterRoom::
	setvar VAR_TEMP_0, 1
	applymovement LOCALID_PLAYER, BattleFrontier_BattleTowerMultiBattleRoom_Movement_PlayerEnterRoom
	applymovement LOCALID_PARTNER, BattleFrontier_BattleTowerMultiBattleRoom_Movement_PartnerEnterRoom
	waitmovement 0
	frontier_get FRONTIER_DATA_BATTLE_NUM
	goto_if_eq VAR_RESULT, 0, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_OpponentsEnter
	applymovement LOCALID_ATTENDANT_1, BattleFrontier_BattleTowerMultiBattleRoom_Movement_AttendantApproachPlayer
	applymovement LOCALID_ATTENDANT_2, BattleFrontier_BattleTowerMultiBattleRoom_Movement_AttendantApproachPlayer
	waitmovement 0
	applymovement LOCALID_PLAYER, BattleFrontier_BattleTowerMultiBattleRoom_Movement_FaceAttendant
	applymovement LOCALID_PARTNER, BattleFrontier_BattleTowerMultiBattleRoom_Movement_FaceAttendant
	waitmovement 0
	frontier_set FRONTIER_DATA_RECORD_DISABLED, TRUE
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_OpponentsEnter::
	tower_setopponent
	addobject LOCALID_OPPONENT_1
	addobject LOCALID_OPPONENT_2
	applymovement LOCALID_OPPONENT_1, BattleFrontier_BattleTowerMultiBattleRoom_Movement_Opponent1Enter
	applymovement LOCALID_OPPONENT_2, BattleFrontier_BattleTowerMultiBattleRoom_Movement_Opponent2Enter
	waitmovement 0
	goto_if_eq VAR_FRONTIER_BATTLE_MODE, FRONTIER_MODE_LINK_MULTIS, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_DoOpponentIntrosLink
	tower_getopponentintro 0
	delay 15
	applymovement LOCALID_OPPONENT_1, BattleFrontier_BattleTowerMultiBattleRoom_Movement_WalkInPlaceLeft
	waitmovement 0
	msgbox gStringVar4, MSGBOX_DEFAULT
	waitmessage
	tower_getopponentintro 1
	applymovement LOCALID_OPPONENT_2, BattleFrontier_BattleTowerMultiBattleRoom_Movement_WalkInPlaceLeft
	waitmovement 0
	msgbox gStringVar4, MSGBOX_DEFAULT
	waitmessage
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_DoTowerBattle

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_DoOpponentIntrosLink::
	tower_getopponentintro 0
	delay 15
	applymovement LOCALID_OPPONENT_1, BattleFrontier_BattleTowerMultiBattleRoom_Movement_WalkInPlaceLeft
	waitmovement 0
	messageautoscroll gStringVar4
	waitmessage
	delay 48
	tower_getopponentintro 1
	applymovement LOCALID_OPPONENT_2, BattleFrontier_BattleTowerMultiBattleRoom_Movement_WalkInPlaceLeft
	waitmovement 0
	messageautoscroll gStringVar4
	waitmessage
	delay 48
BattleFrontier_BattleTowerMultiBattleRoom_EventScript_DoTowerBattle::
	call BattleFrontier_BattleTowerBattleRoom_EventScript_DoTowerBattle
	switch VAR_RESULT
	case B_OUTCOME_WON, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_DefeatedOpponents
BattleFrontier_BattleTowerMultiBattleRoom_EventScript_WarpToLobbyLost::
	frontier_set FRONTIER_DATA_CHALLENGE_STATUS, CHALLENGE_STATUS_LOST
	tower_set TOWER_DATA_LVL_MODE
	setvar VAR_0x8004, FANCOUNTER_USED_BATTLE_TOWER
	special Script_TryGainNewFanFromCounter
	goto BattleFrontier_BattleTowerBattleRoom_EventScript_WarpToLobby

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_DefeatedOpponents::
	call BattleFrontier_EventScript_IncrementWinStreak
	tower_setbattlewon
	switch VAR_RESULT
	case 7, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_WarpToLobbyWon
	applymovement LOCALID_OPPONENT_2, BattleFrontier_BattleTowerMultiBattleRoom_Movement_Opponent2Exit
	applymovement LOCALID_OPPONENT_1, BattleFrontier_BattleTowerMultiBattleRoom_Movement_Opponent1Exit
	waitmovement 0
	removeobject LOCALID_OPPONENT_1
	removeobject LOCALID_OPPONENT_2
	applymovement LOCALID_ATTENDANT_1, BattleFrontier_BattleTowerMultiBattleRoom_Movement_AttendantApproachPlayer
	applymovement LOCALID_ATTENDANT_2, BattleFrontier_BattleTowerMultiBattleRoom_Movement_AttendantApproachPlayer
	waitmovement 0
	applymovement LOCALID_PLAYER, BattleFrontier_BattleTowerMultiBattleRoom_Movement_FaceAttendant
	applymovement LOCALID_PARTNER, BattleFrontier_BattleTowerMultiBattleRoom_Movement_FaceAttendant
	waitmovement 0
	goto_if_eq VAR_FRONTIER_BATTLE_MODE, FRONTIER_MODE_LINK_MULTIS, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_RetorePartyMsgLink
	msgbox BattleFrontier_BattleTowerBattleRoom_Text_RestoreMonsToFullHealth, MSGBOX_DEFAULT
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_RestoreParty

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_RetorePartyMsgLink::
	messageautoscroll BattleFrontier_BattleTowerBattleRoom_Text_RestoreMonsToFullHealth
	waitmessage
	delay 48
BattleFrontier_BattleTowerMultiBattleRoom_EventScript_RestoreParty::
	special LoadPlayerParty
	frontier_setpartyorder FRONTIER_MULTI_PARTY_SIZE
	call_if_eq VAR_FRONTIER_BATTLE_MODE, FRONTIER_MODE_LINK_MULTIS, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReconnectLink
	playfanfare MUS_HEAL
	waitfanfare
	special HealPlayerParty
BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents::
	frontier_get FRONTIER_DATA_BATTLE_NUM
	call BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyForNextOpponentSet
	goto_if_eq VAR_FRONTIER_BATTLE_MODE, FRONTIER_MODE_LINK_MULTIS, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ContinueChallenge
	call BattleFrontier_EventScript_GetCantRecordBattle
	goto_if_eq VAR_RESULT, TRUE, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponentsNoRecord
	multichoice 19, 4, MULTI_GO_ON_RECORD_REST_RETIRE, TRUE
	switch VAR_RESULT
	case 0, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ContinueChallenge
	case 1, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskRecordBattle
	case 2, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskPauseChallenge
	case 3, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskRetireChallenge
	case MULTI_B_PRESSED, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponentsNoRecord::
	multichoice 20, 6, MULTI_GO_ON_REST_RETIRE, TRUE
	switch VAR_RESULT
	case 0, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ContinueChallenge
	case 1, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskPauseChallenge
	case 2, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskRetireChallenge
	case MULTI_B_PRESSED, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskRecordBattle::
	message BattleFrontier_BattleTowerBattleRoom_Text_RecordYourBattle
	waitmessage
	multichoicedefault 20, 8, MULTI_YESNO, 1, FALSE
	switch VAR_RESULT
	case 1, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents
	case 0, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_RecordBattle
	case MULTI_B_PRESSED, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_RecordBattle::
	call BattleFrontier_EventScript_SaveBattle
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskPauseChallenge::
	msgbox BattleFrontier_BattleTowerBattleRoom_Text_SaveAndQuitGame, MSGBOX_YESNO
	switch VAR_RESULT
	case NO, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents
	case YES, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_PauseChallenge
	case MULTI_B_PRESSED, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskRetireChallenge::
	message BattleFrontier_BattleTowerBattleRoom_Text_CancelYourChallenge
	waitmessage
	multichoicedefault 20, 8, MULTI_YESNO, 1, FALSE
	switch VAR_RESULT
	case 1, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents
	case 0, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_WarpToLobbyLost
	case MULTI_B_PRESSED, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ContinueChallenge::
	closemessage
	clearflag FLAG_TEMP_2
	applymovement LOCALID_PLAYER, BattleFrontier_BattleTowerMultiBattleRoom_Movement_FaceBattle
	applymovement LOCALID_PARTNER, BattleFrontier_BattleTowerMultiBattleRoom_Movement_FaceBattle
	waitmovement 0
	applymovement LOCALID_ATTENDANT_1, BattleFrontier_BattleTowerMultiBattleRoom_Movement_AttendantReturnToPos
	applymovement LOCALID_ATTENDANT_2, BattleFrontier_BattleTowerMultiBattleRoom_Movement_AttendantReturnToPos
	waitmovement 0
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_OpponentsEnter
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_WarpToLobbyWon::
	frontier_set FRONTIER_DATA_CHALLENGE_STATUS, CHALLENGE_STATUS_WON
	tower_set TOWER_DATA_LVL_MODE
	setvar VAR_0x8004, FANCOUNTER_USED_BATTLE_TOWER
	special Script_TryGainNewFanFromCounter
	goto BattleFrontier_BattleTowerBattleRoom_EventScript_WarpToLobby

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_PauseChallenge::
	message BattleFrontier_BattleTowerBattleRoom_Text_SavingPleaseWait
	waitmessage
	tower_save CHALLENGE_STATUS_PAUSED
	playse SE_SAVE
	waitse
	fadescreen 1
	frontier_reset
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyForNextOpponentSet::
	goto_if_eq VAR_FRONTIER_BATTLE_MODE, FRONTIER_MODE_LINK_MULTIS, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyForNextOpponentSetLink
	copyvar VAR_TEMP_F, VAR_RESULT
	switch VAR_TEMP_F
	case 1, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor2ndOpponentSet
	case 2, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor3rdOpponentSet
	case 3, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor4thOpponentSet
	case 4, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor5thOpponentSet
	case 5, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor6thOpponentSet
	case 6, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor7thOpponentSet

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor2ndOpponentSet::
	message BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor2ndOpponentSet
	waitmessage
	return

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor3rdOpponentSet::
	message BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor3rdOpponentSet
	waitmessage
	return

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor4thOpponentSet::
	message BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor4thOpponentSet
	waitmessage
	return

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor5thOpponentSet::
	message BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor5thOpponentSet
	waitmessage
	return

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor6thOpponentSet::
	message BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor6thOpponentSet
	waitmessage
	return

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor7thOpponentSet::
	message BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor7thOpponentSet
	waitmessage
	return

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyForNextOpponentSetLink::
	copyvar VAR_TEMP_F, VAR_RESULT
	switch VAR_TEMP_F
	case 1, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor2ndOpponentSetLink
	case 2, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor3rdOpponentSetLink
	case 3, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor4thOpponentSetLink
	case 4, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor5thOpponentSetLink
	case 5, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor6thOpponentSetLink
	case 6, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor7thOpponentSetLink

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor2ndOpponentSetLink::
	message BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor2ndOpponentSet
	waitmessage
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponentsLink
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor3rdOpponentSetLink::
	message BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor3rdOpponentSet
	waitmessage
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponentsLink
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor4thOpponentSetLink::
	message BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor4thOpponentSet
	waitmessage
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponentsLink
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor5thOpponentSetLink::
	message BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor5thOpponentSet
	waitmessage
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponentsLink
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor6thOpponentSetLink::
	message BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor6thOpponentSet
	waitmessage
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponentsLink
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReadyFor7thOpponentSetLink::
	message BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor7thOpponentSet
	waitmessage
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponentsLink
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_LinkDelayForMsg::
	waitmessage
	delay 48
	return

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponentsLink::
	goto_if_set FLAG_TEMP_2, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponentsLinkNoRecord
	multichoice 19, 6, MULTI_GO_ON_RECORD_RETIRE, TRUE
	switch VAR_RESULT
	case 0, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ContinueChallengeLink
	case 1, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskRecordBattleLink
	case 2, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskRetireChallengeLink
	case MULTI_B_PRESSED, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskRetireChallengeLink
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponentsLinkNoRecord::
	multichoice 20, 8, MULTI_GO_ON_RETIRE, TRUE
	switch VAR_RESULT
	case 0, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ContinueChallengeLink
	case 1, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskRetireChallengeLink
	case MULTI_B_PRESSED, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskRetireChallengeLink
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ContinueChallengeLink::
	setvar VAR_0x8004, BATTLE_TOWER_LINK_CONTINUE
	setvar VAR_0x8005, 0
	message gText_LinkStandby3
	waitmessage
	special LinkRetireStatusWithBattleTowerPartner
	waitstate
	goto_if_ne VAR_RESULT, BATTLE_TOWER_LINKSTAT_CONTINUE, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_WarpToLobbyLost
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_LinkDelayForMsg
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskRecordBattleLink::
	message BattleFrontier_BattleTowerBattleRoom_Text_RecordYourBattle
	waitmessage
	multichoicedefault 20, 8, MULTI_YESNO, 1, FALSE
	switch VAR_RESULT
	case 1, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents
	case MULTI_B_PRESSED, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents
	call BattleFrontier_EventScript_SaveBattle
	setflag FLAG_TEMP_2
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskRetireChallengeLink::
	message BattleFrontier_BattleTowerBattleRoom_Text_CancelYourChallenge
	waitmessage
	multichoicedefault 20, 8, MULTI_YESNO, 1, FALSE
	goto_if_eq VAR_RESULT, 0, BattleFrontier_BattleTowerMultiBattleRoom_EventScript_RetireChallengeLink
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_AskReadyForOpponents
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_RetireChallengeLink::
	setvar VAR_0x8004, BATTLE_TOWER_LINK_RETIRE
	setvar VAR_0x8005, 0
	message gText_LinkStandby3
	waitmessage
	special LinkRetireStatusWithBattleTowerPartner
	waitstate
	goto BattleFrontier_BattleTowerMultiBattleRoom_EventScript_WarpToLobbyLost
	end

BattleFrontier_BattleTowerMultiBattleRoom_EventScript_ReconnectLink::
	special BattleTowerReconnectLink
	return

BattleFrontier_BattleTowerMultiBattleRoom_Movement_PlayerEnterRoom:
	walk_up
	walk_up
	walk_up
	walk_up
	face_right
	step_end

BattleFrontier_BattleTowerMultiBattleRoom_Movement_PartnerEnterRoom:
	walk_left
	walk_up
	walk_up
	walk_up
	face_right
	step_end

BattleFrontier_BattleTowerMultiBattleRoom_Movement_FaceAttendant:
	face_left
	step_end

BattleFrontier_BattleTowerMultiBattleRoom_Movement_FaceBattle:
	walk_in_place_faster_right
	step_end

BattleFrontier_BattleTowerMultiBattleRoom_Movement_Opponent1Enter:
	walk_down
	walk_down
	walk_down
	walk_down
	face_left
	step_end

BattleFrontier_BattleTowerMultiBattleRoom_Movement_Opponent2Enter:
	walk_right
	walk_down
	walk_down
	walk_down
	face_left
	step_end

BattleFrontier_BattleTowerMultiBattleRoom_Movement_Opponent2Exit:
	walk_up
	walk_up
	walk_up
	set_invisible
	step_end

BattleFrontier_BattleTowerMultiBattleRoom_Movement_Opponent1Exit:
	walk_up
	walk_up
	walk_up
	walk_up
	step_end

BattleFrontier_BattleTowerMultiBattleRoom_Movement_AttendantApproachPlayer:
	walk_right
	walk_right
	step_end

BattleFrontier_BattleTowerMultiBattleRoom_Movement_AttendantReturnToPos:
	walk_left
	walk_left
	walk_in_place_faster_right
	step_end

BattleFrontier_BattleTowerMultiBattleRoom_Movement_WalkInPlaceLeft:
	walk_in_place_left
	step_end

BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor2ndOpponentSet:
	.string "The 2nd set of opponents is next.\n"
	.string "Are you ready?$"

BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor3rdOpponentSet:
	.string "The 3rd set of opponents is next.\n"
	.string "Are you ready?$"

BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor4thOpponentSet:
	.string "The 4th set of opponents is next.\n"
	.string "Are you ready?$"

BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor5thOpponentSet:
	.string "The 5th set of opponents is next.\n"
	.string "Are you ready?$"

BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor6thOpponentSet:
	.string "The 6th set of opponents is next.\n"
	.string "Are you ready?$"

BattleFrontier_BattleTowerMultiBattleRoom_Text_ReadyFor7thOpponentSet:
	.string "The 7th set of opponents is next.\n"
	.string "Are you ready?$"

@ Unused
BattleFrontier_BattleTowerMultiBattleRoom_Text_2ndOpponentSetNext:
	.string "The 2nd set of opponents is next.\n"
	.string "Do your best!$"

@ Unused
BattleFrontier_BattleTowerMultiBattleRoom_Text_3rdOpponentSetNext:
	.string "The 3rd set of opponents is next.\n"
	.string "Do your best!$"

@ Unused
BattleFrontier_BattleTowerMultiBattleRoom_Text_4thOpponentSetNext:
	.string "The 4th set of opponents is next.\n"
	.string "Do your best!$"

@ Unused
BattleFrontier_BattleTowerMultiBattleRoom_Text_5thOpponentSetNext:
	.string "The 5th set of opponents is next.\n"
	.string "Do your best!$"

@ Unused
BattleFrontier_BattleTowerMultiBattleRoom_Text_6thOpponentSetNext:
	.string "The 6th set of opponents is next.\n"
	.string "Do your best!$"

@ Unused
BattleFrontier_BattleTowerMultiBattleRoom_Text_7thOpponentSetNext:
	.string "The 7th set of opponents is next.\n"
	.string "Do your best!$"

gText_LinkStandby3::
	.string "Link standby…$"

gText_YourPartnerHasRetired::
	.string "Your partner has retired.\p"
	.string "Your BATTLE ROOM challenge\n"
	.string "will be canceled.$"
