# Pokémon Emerald / Fire Red Combo Warp Randomizer

Have you ever played a Pokemon randomizer and thought "I like this, but wish there was twice as much of it?"  Well, we have finally solved that universal problem with the Pokemon Emerald / Fire Red Combo Warp Randomizer!

With the Pokemon Emerald / Fire Red Combo Warp Randomizer, you and your party will be able to move seamlessly between Hoenn and Kanto on your very confusing and disjointed adventure.  The warps are randomized, and any door can go to either game.

We guarantee all seeds are winnable or your money back!

![Illustration](https://user-images.githubusercontent.com/7422646/219937320-9ed8c3e0-07a0-4a4b-9668-a0c84957d349.png)

## How to install

This is an emulator script for the mGBA emulator, not a traditional ROM hack.  That means the setup instructions will be more complicated than usual.

### What you need

To run this script, you need: 
* A copy of the [mGBA emulator](https://mgba.io/) version 0.10.0 or later.  No other emulators are currently supported.
* A ROM of the US version of Pokemon Emerald.
* A ROM of the US 1.1 version of Pokemon Fire Red.  Note that the US 1.0 version is currently not supported.
* The [current release of this randomizer](https://github.com/Bratmon/FREComboRandomizer/releases).

### How to run

1. Unzip the Randomizer release.
2. Place both ROMs in the "Put ROMs Here" folder in the Randomizer folder.  They must be named exactly "Pokemon - Emerald Version (U).gba" and "Pokemon - Fire Red Version (U) (V1.1).gba"

<img src="https://user-images.githubusercontent.com/7422646/219937358-8012a5bd-9062-43b2-93d9-25ccc4a975ad.png" height="150">

3. Open mGBA
4. Open the "Scripting" panel in mGBA
<img src="https://user-images.githubusercontent.com/7422646/219937387-13905a5f-e61e-4bf7-bb9f-cd2a8545cecb.png" height="450">

5. Click "Load Script" and load the Combo Randomizer script.  The script will automatically perform some initial setup.  Note that you must open this script every time you play.
<img src="https://user-images.githubusercontent.com/7422646/219937401-e352e852-c2cc-415c-ad66-aeb3e0810071.png" height="275">

<img src="https://user-images.githubusercontent.com/7422646/219937409-8da70d13-d0d9-46f3-b062-36611360ab98.png" height="150">

6. When the setup is complete, type "NewGame()" into the text field in the script window.  You may optionally put a number in between the () to set a fixed seed.

<img src="https://user-images.githubusercontent.com/7422646/219937786-cc2c8dd5-5acf-4ac1-b60c-6fa50f62dbbf.png" height="400">

7. Load the newly created "Pokemon - Fire Red Version (U) (V1.1).gba.patched.gba" ROM from the "Patched ROMs" folder.

<img src="https://user-images.githubusercontent.com/7422646/219937445-f081b6b2-ed88-4b09-9f91-ff6af6b015d1.png" height="400">

<img src="https://user-images.githubusercontent.com/7422646/219937896-0163e027-4280-4d9b-a9f9-f86d2125c806.png" height="250">

8. Begin your confusing Pokemon journey.

## How to play

When Fire Red begins, you will be able to go through the tutorial normally and pick your starter.   As soon as you enter a building that's not required for the tutorial, you will be sent somewhere random.

The first time you go to Hoenn, you and your Pokemon will find yourselves in a familiar truck.  At that point, you will be able to do the Emerald tutorial and get your Hoenn starter.

It is recommended to finish the tutorials of both games (up to the point where you get Pokeballs) before exploring at random.  If you don't want to do that, you should at least wait until you have a Pokemon.  After all, a little girl warned you about that.

<img src="https://user-images.githubusercontent.com/7422646/219937478-1f9bd558-66d2-4b96-ad23-973839f82c6d.png" height="350">

Once you're on your way, the goal is to beat all the Gyms of both games and both Elite Fours in order.  We don't really have any special tracking for that, so you have to keep track yourself.

Your party Pokemon carry over between games, but your items and badges do not.  Also, your box isn't shared either (Bill's PC and Lanette's PC are different after all)

### Saving

There is currently a bug in mGBA that prevents savestates and hard saves from working normally after a ROM swap.  To save, please use the "Save State File" option in mGBA.

<img src="https://user-images.githubusercontent.com/125828415/219980675-15d1f15f-96e6-41e7-82c3-ead251db79f0.png" height="350">

This script also makes frequent autosaves.  You can find them in the "Savestates" folder.

### Resuming

When restarting mGBA, you need to load the "Combo Randomizer.lua" script to continue playing.  You do not need to run "NewGame" again.

### If you get stuck

Although all seeds are beatable, it is possible to softlock yourself.  If you do get stuck, here are some ways to free yourself.

* Teleport from anywhere and fly from anywhere are both enabled.
* Load an old autosave from the "Savestates" folder
* If that doesn't work, you can restart the emulator without the script and go somewhere else
* If all else fails, you can try a walk through walls cheat
