<?php

require dirname(__FILE__, 2) . '/NBT.php';

$bigtestarr = [
	'Level' => [
		'longTest' => 9223372036854775807,
		'shortTest' => 32767,
		'stringTest' => 'HELLO WORLD THIS IS A TEST STRING ÅÄÖ!',
		'floatTest' => 0.49823147058487,
		'intTest' => 2147483647,
		'nested compound test' => [
			'ham' => [
				'name' => 'Hampus',
				'value' => 0.75
			],
			'egg' => [
				'name' => 'Eggbert',
				'value' => 0.5
			]
		],
		'listTest (long)' => [ 11, 12, 13, 14, 15 ],
		'listTest (compound)' => [
			[
				'name' => 'Compound tag #0',
				'created-on' => 1264099775885
			],
			[
				'name' => 'Compound tag #1',
				'created-on' => 1264099775885
			]
		],
		'byteTest' => 127,
		'byteArrayTest (the first 1000 values of (n*n*255+n*7)%100, starting with n=0 (0, 62, 34, 16, 8, ...))' => [ 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48 ],
		'doubleTest' => 0.49312871321823
	]
];
$stringteststr = 'H4sIAAAAAAAAADWQS07jQBCGy0kA21mAyHYWjTQ7iPAr2Mku5IURRBE266htV0wrthu12xo4ke/hC8xi7oPo0Wh2pa/+h/SbAAZozAQArQc9lmk3GpwseFNJzYS+pLkGw9cqEUiPNClQ64PxwDJcFzSvlenLhLOM1e8F/TRg8MQF6oqewWXX+ks8YFXjjHQtvXYniv9Q9B5TXiKh5BctjqzKb4j8d8BQfR+bIyb840qJlc3v2iB+YzVhEkuS0ookSAQeuMgxu4JR1066tljtwgV5Wm024XYT9eEk5QUXMPj9R4fBlpYI50oXSRTIyY5WsgYTzlcfUtC5lIIljcRa/28zvJlj+TPHtnUwuGA5q2Kaw2jxMl/HqmC/eQmX++ghXMf6371g+PwahYv9br6NI1XYNIr9xINnZYHljP1sko49hwbjYJri2A+CwPbuppnreipfshJrSct3uLCtW3t661jEnbl3ZPcM0IPTJS1pjmoL+AbimZy0qAEAAA==';
$stringtestarr = [
	[
		'i' => [
			[
				'id' => 300,
				'Count' => 1,
				'tag' => [
					'Unbreakable' => 1,
					'HideFlags' => 254,
					'display' => [
						'Lore' => [
							'§7Defense: §a+35',
							'',
							'§7Become a walking, talking',
							'§7Jukebox!',
							'',
							'§7§8This item can be reforged!',
							'§5§lEPIC LEGGINGS'
						],
						'color' => 315347,
						'Name' => '§5Stereo Pants'
					],
					'ExtraAttributes' => [
						'color' => '4:207:211',
						'originTag' => 'CRAFTING_GRID_SHIFT',
						'id' => 'MUSIC_PANTS',
						'uuid' => 'ef40d802-7d5c-42a8-89ce-78881469d334',
						'timestamp' => '10/19/20 3:36 PM'
					]
				],
				'Damage' => 0
			]
		]
	]
];

$bigtest = NBT::readFile(__DIR__  . '/bigtest.nbt');

echo 'bigtest.nbt - ' . (print_r($bigtest, true) == print_r($bigtestarr, true) ? 'PASS' : 'FAIL') . "\n";

foreach( $bigtest['Level'] as $index => $test ) {
	$equal = $test === $bigtestarr['Level'][$index];
	if (is_float($test))
		$equal = strval($test) === strval($bigtestarr['Level'][$index]);
	echo '  ' . $index . ' - ' . ($equal ? 'PASS' : 'FAIL') . "\n";
}

$stringtest = NBT::readString(gzdecode(base64_decode($stringteststr)));

echo 'string test - ' . ($stringtest == $stringtestarr ? 'PASS' : 'FAIL');

?>