/*
 * Decompiled with CFR 0.152.
 */
import com.adobe.flash.compiler.clients.COMPC;
import com.adobe.flash.compiler.clients.MXMLC;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.regex.Pattern;

public class ascsh {
    private static ArrayList<ArrayList<String>> targets = new ArrayList();
    private static ArrayList<Object> compilers = new ArrayList();
    static ByteArrayOutputStream buffer;
    static PrintStream oldOut;
    static Pattern errPattern;

    public static void main(String[] stringArray) {
        System.out.println("ascsh v0.4 by Jeff Ward, simbulus.com");
        if (stringArray.length > 0) {
            ascsh.compile(stringArray);
        }
        Scanner scanner = new Scanner(System.in);
        while (true) {
            System.out.print("(fcsh) ");
            String string = scanner.nextLine();
            if (string == null || string.equals("")) continue;
            if ((string = string.trim()).equals("quit") || string.equals("exit")) break;
            if (string.equals("help")) {
                ascsh.print_help();
                continue;
            }
            String[] stringArray2 = null;
            if (string.indexOf("|x|") >= 0) {
                stringArray2 = string.split("\\|x\\|");
            } else {
                try {
                    stringArray2 = Commandline.translateCommandline(string);
                }
                catch (Exception exception) {
                    System.out.println("Error parsing command:\n" + string);
                    continue;
                }
            }
            ascsh.compile(stringArray2);
        }
        System.exit(0);
    }

    public static void compile(String[] stringArray) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        String string = arrayList.remove(0);
        if (string.equals("compile")) {
            int n2 = Integer.parseInt(arrayList.get(0)) - 1;
            if (n2 >= compilers.size()) {
                System.out.println("fcsh: Target " + (n2 + 1) + " not found");
                return;
            }
            Object object = compilers.get(n2);
            arrayList = targets.get(n2);
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            if (object instanceof MXMLC) {
                ascsh.startCapture();
                MXMLC cfr_ignored_0 = (MXMLC)object;
                n = MXMLC.staticMainNoExit((String[])stringArray);
                ascsh.stopCapture();
            } else {
                ascsh.startCapture();
                COMPC cfr_ignored_1 = (COMPC)object;
                n = COMPC.staticMainNoExit((String[])stringArray);
                ascsh.stopCapture();
            }
        } else {
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            if (targets.size() > 0) {
                System.out.println("WARNING: ascsh currently only reliably handles one compile target via staticMainNoExit");
            }
            System.out.println("fcsh: Assigned " + (targets.size() + 1) + " as the compile target id");
            if (string.equals("mxmlc")) {
                MXMLC mXMLC = new MXMLC();
                compilers.add(mXMLC);
                targets.add(arrayList);
                ascsh.startCapture();
                n = MXMLC.staticMainNoExit((String[])stringArray);
                ascsh.stopCapture();
            } else if (string.equals("compc")) {
                COMPC cOMPC = new COMPC();
                compilers.add(cOMPC);
                targets.add(arrayList);
                ascsh.startCapture();
                n = COMPC.staticMainNoExit((String[])stringArray);
                ascsh.stopCapture();
            } else {
                System.out.println("ascsh unknown command '" + string + "'");
                n = 255;
            }
        }
        System.out.println("Compile status: " + n);
    }

    static void startCapture() {
        buffer = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(buffer);
        oldOut = System.err;
        System.setErr(printStream);
    }

    static void stopCapture() {
        System.err.flush();
        System.setErr(oldOut);
        String[] stringArray = buffer.toString().split("\n");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i].trim();
            if (errPattern.matcher(string).matches()) {
                System.err.print(string);
                System.err.print(": ");
                continue;
            }
            System.err.println(stringArray[i]);
        }
        oldOut = null;
        buffer = null;
    }

    public static void print_help() {
        System.out.print("List of fcsh commands:\nmxmlc arg1 arg2 ...      full compilation and optimization; return a target id\ncompc arg1 arg2 ...      full SWC compilation\ncompile id               incremental compilation\nclear [id]               clear target(s) (NOT SUPPORTED)\ninfo [id]                display compile target info\nquit                     quit\n");
    }

    static {
        errPattern = Pattern.compile(".*\\.[a-z]+.*:[0-9]+");
    }
}

