(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.CanvasJS = f()}})(function(){var define,module,exports;return (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;

	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var ghostCtx = this._eventManager.ghostCtx;

	var axisXProps = plotUnit.axisX.lineCoordinates;
	var axisYProps = plotUnit.axisY.lineCoordinates;
	var markers = [];

	var plotArea = this.plotArea;
	ctx.save();

	if (_utils.isCanvasSupported) ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		ghostCtx.beginPath();
		ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		ghostCtx.clip();
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];

		var dataPoints = dataSeries.dataPoints;

		var seriesId = dataSeries.id;
		this._eventManager.objectMap[seriesId] = {
			objectType: "dataSeries", dataSeriesIndex: dataSeriesIndex
		};

		var hexColor = (0, _utils.intToHexColorString)(seriesId);
		ghostCtx.fillStyle = hexColor;
		//ghostCtx.lineWidth = dataSeries.lineThickness;
		//ghostCtx.lineWidth = 20;

		markers = [];

		var isFirstDataPointInPlotArea = true;
		var i = 0,
		    x,
		    y;
		var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number back and forth.

		var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;
		var baseY;

		var startPoint = null;

		if (dataPoints.length > 0) {
			//ctx.strokeStyle = "#4572A7 ";
			var color = dataSeries._colorSet[i % dataSeries._colorSet.length];
			//ctx.strokeStyle = "red";
			ctx.fillStyle = color;
			ctx.strokeStyle = color;
			ctx.lineWidth = dataSeries.lineThickness;

			if (ctx.setLineDash) {
				ctx.setLineDash((0, _utils.getLineDashArray)(dataSeries.lineDashType, dataSeries.lineThickness));
			}

			var prevDataNull = true;
			for (; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].x.getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (typeof dataPoints[i].y !== "number") {
					closeArea();

					prevDataNull = true;
					continue;
				}

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				y = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				if (isFirstDataPointInPlotArea || prevDataNull) {
					ctx.beginPath();
					ctx.moveTo(x, y);
					startPoint = {
						x: x, y: y
					};

					if (_utils.isCanvasSupported) {
						ghostCtx.beginPath();
						ghostCtx.moveTo(x, y);
					}

					isFirstDataPointInPlotArea = false;
					prevDataNull = false;
				} else {

					ctx.lineTo(x, y);

					if (_utils.isCanvasSupported) ghostCtx.lineTo(x, y);

					if (i % 250 == 0) {
						closeArea();
					}
				}

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x, y1: y
				};

				//Render Marker
				if (dataPoints[i].markerSize !== 0) {
					if (dataPoints[i].markerSize > 0 || dataSeries.markerSize > 0) {
						var markerProps = dataSeries.getMarkerProperties(i, x, y, ctx);
						markers.push(markerProps);

						//if (!dataSeries.maxWidthInX || markerProps.size > dataSeries.maxWidthInX) {
						//	dataSeries.maxWidthInX = markerProps.size / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);
						//}

						var markerColor = (0, _utils.intToHexColorString)(id);

						if (_utils.isCanvasSupported) {
							markers.push({
								x: x, y: y, ctx: ghostCtx,
								type: markerProps.type,
								size: markerProps.size,
								color: markerColor,
								borderColor: markerColor,
								borderThickness: markerProps.borderThickness
							});
						}
					}
				}

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "area",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						point: {
							x: x, y: y
						},
						direction: dataPoints[i].y >= 0 ? 1 : -1,
						color: color
					});
				}
			}

			closeArea();

			//startPoint = { x: x, y: y };
			_render2.default.drawMarkers(markers);
		}
	}

	ctx.restore();
	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	function closeArea() {

		if (!startPoint) return;

		if (dataSeries.lineThickness > 0) ctx.stroke();

		if (plotUnit.axisY.viewportMinimum <= 0 && plotUnit.axisY.viewportMaximum >= 0) {
			baseY = yZeroToPixel;
		} else if (plotUnit.axisY.viewportMaximum < 0) baseY = axisYProps.y1;else if (plotUnit.axisY.viewportMinimum > 0) baseY = axisXProps.y2;

		ctx.lineTo(x, baseY);
		ctx.lineTo(startPoint.x, baseY);
		ctx.closePath();

		ctx.globalAlpha = dataSeries.fillOpacity;
		ctx.fill();
		ctx.globalAlpha = 1;

		if (_utils.isCanvasSupported) {
			ghostCtx.lineTo(x, baseY);
			ghostCtx.lineTo(startPoint.x, baseY);
			ghostCtx.closePath();
			ghostCtx.fill();
		}

		ctx.beginPath();
		ctx.moveTo(x, y);
		ghostCtx.beginPath();
		ghostCtx.moveTo(x, y);

		startPoint = {
			x: x, y: y
		};
	}

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: _animator2.default.xClipAnimation, easingFunction: _animator2.default.easing.linear, animationBase: 0
	};
	return animationInfo;
};

var _render = require('../helpers/render');

var _render2 = _interopRequireDefault(_render);

var _animator = require('../helpers/animator');

var _animator2 = _interopRequireDefault(_animator);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

},{"../helpers/animator":37,"../helpers/render":38,"../helpers/utils":39}],2:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;
	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var color = null;

	var plotArea = this.plotArea;

	var i = 0,
	    x,
	    y;
	var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number from dataTime everytime it is used.

	//In case of Bar Chart, yZeroToPixel is x co-ordinate!
	var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) << 0;

	var maxBarWidth = this.dataPointMaxWidth ? this.dataPointMaxWidth : Math.min(this.height * .15, this.plotArea.height / plotUnit.plotType.totalDataSeries * .9) << 0;
	var xMinDiff = plotUnit.axisX.dataInfo.minDiff;
	//var barWidth = (((plotArea.height / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum)) * Math.abs(xMinDiff)) / totalDataSeries * .9) << 0;

	var barWidth = plotArea.height / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum) * Math.abs(xMinDiff) / plotUnit.plotType.totalDataSeries * .9 << 0;

	if (barWidth > maxBarWidth) barWidth = maxBarWidth;else if (xMinDiff === Infinity) {
		barWidth = maxBarWidth / plotUnit.plotType.totalDataSeries * .9;
	} else if (barWidth < 1) barWidth = 1;

	ctx.save();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		this._eventManager.ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		this._eventManager.ghostCtx.clip();
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var isFirstDataPointInPlotArea = true;

		//dataSeries.maxWidthInX = barWidth / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);


		if (dataPoints.length > 0) {
			//var xy = this.getPixelCoordinatesOnPlotArea(dataPoints[0].x, dataPoints[0].y);

			var bevelEnabled = barWidth > 5 && dataSeries.bevelEnabled ? true : false;

			ctx.strokeStyle = "#4572A7 ";

			for (i = 0; i < dataPoints.length; i++) {

				dataPoints[i].getTime ? dataPointX = dataPoints[i].x.getTime() : dataPointX = dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (typeof dataPoints[i].y !== "number") continue;

				//x and y are pixel co-ordinates of point and should not be confused with X and Y values
				y = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				x = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				var y1 = y - plotUnit.plotType.totalDataSeries * barWidth / 2 + (plotUnit.previousDataSeriesCount + j) * barWidth << 0;
				var y2 = y1 + barWidth << 0;
				var x1;
				var x2;

				if (dataPoints[i].y >= 0) {
					x1 = yZeroToPixel;
					x2 = x;
				} else {
					x1 = x;
					x2 = yZeroToPixel;
				}

				//drawRect(ctx, x1, y1, plotArea.x2, y2, "#EEEEEE", 0, null, false, false, false, false);
				//drawRect(ctx, x1, y1, plotArea.x2, y2, "#BDCED3", 0, null, false, false, false, false);

				color = dataPoints[i].color ? dataPoints[i].color : dataSeries._colorSet[i % dataSeries._colorSet.length];
				//color = "#1B4962";
				(0, _utils.drawRect)(ctx, x1, y1, x2, y2, color, 0, null, bevelEnabled, false, false, false, dataSeries.fillOpacity);

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x1, y1: y1, x2: x2, y2: y2
				};
				color = (0, _utils.intToHexColorString)(id);

				if (_utils.isCanvasSupported) (0, _utils.drawRect)(this._eventManager.ghostCtx, x1, y1, x2, y2, color, 0, null, false, false, false, false);

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) this._indexLabels.push({
					chartType: "bar",
					dataPoint: dataPoints[i],
					dataSeries: dataSeries,
					point: {
						x: dataPoints[i].y >= 0 ? x2 : x1, y: y1 + (y2 - y1) / 2
					},
					direction: dataPoints[i].y >= 0 ? 1 : -1,
					bounds: {
						x1: Math.min(x1, x2), y1: y1, x2: Math.max(x1, x2), y2: y2
					},
					color: color
				});
			}
		}
	}

	ctx.restore();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	//source and dest would be same when animation is not enabled
	var animationBase = Math.max(yZeroToPixel, plotUnit.axisX.boundingRect.x2);
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: _animator2.default.xScaleAnimation, easingFunction: _animator2.default.easing.easeOutQuart, animationBase: animationBase
	};
	return animationInfo;
};

var _animator = require('../helpers/animator');

var _animator2 = _interopRequireDefault(_animator);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

},{"../helpers/animator":37,"../helpers/utils":39}],3:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {

	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;

	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var color = null;

	var plotArea = this.plotArea;

	var i = 0,
	    x,
	    y;
	var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number from dataTime everytime it is used.

	var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) << 0;

	var maxBarWidth = this.dataPointMaxWidth ? this.dataPointMaxWidth : this.width * .15 << 0;
	var xMinDiff = plotUnit.axisX.dataInfo.minDiff;
	var barWidth = plotArea.width / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum) * Math.abs(xMinDiff) / totalDataSeries * .9 << 0;

	ctx.save();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		this._eventManager.ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		this._eventManager.ghostCtx.clip();
	}

	var maxZ = -Infinity;
	var minZ = Infinity;

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];
		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var z = 0;

		for (var i = 0; i < dataPoints.length; i++) {

			dataPointX = dataPoints[i].getTime ? dataPointX = dataPoints[i].x.getTime() : dataPointX = dataPoints[i].x;

			if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
				continue;
			}

			if (typeof dataPoints[i].z !== "undefined") {

				z = dataPoints[i].z;

				if (z > maxZ) maxZ = z;

				if (z < minZ) minZ = z;
			}
		}
	}

	var minArea = Math.PI * 5 * 5;
	var maxArea = Math.max(Math.pow(Math.min(plotArea.height, plotArea.width) * .25 / 2, 2) * Math.PI, minArea);

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var isFirstDataPointInPlotArea = true;

		if (dataPoints.length == 1) barWidth = maxBarWidth;

		if (barWidth < 1) barWidth = 1;else if (barWidth > maxBarWidth) barWidth = maxBarWidth;

		if (dataPoints.length > 0) {
			//var xy = this.getPixelCoordinatesOnPlotArea(dataPoints[0].x, dataPoints[0].y);
			//var bevelEnabled = (barWidth > 5) ? false : false;

			ctx.strokeStyle = "#4572A7 ";

			for (var i = 0; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].getTime ? dataPointX = dataPoints[i].x.getTime() : dataPointX = dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (typeof dataPoints[i].y !== "number") continue;

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				y = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				var z = dataPoints[i].z;

				var area = maxZ === minZ ? maxArea / 2 : minArea + (maxArea - minArea) / (maxZ - minZ) * (z - minZ);
				var radius = Math.max(Math.sqrt(area / Math.PI) << 0, 1);

				var markerSize = radius * 2;
				var markerProps = dataSeries.getMarkerProperties(i, ctx);
				markerProps.size = markerSize;

				ctx.globalAlpha = dataSeries.fillOpacity;
				_render2.default.drawMarker(x, y, ctx, markerProps.type, markerProps.size, markerProps.color, markerProps.borderColor, markerProps.borderThickness);
				ctx.globalAlpha = 1;

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x, y1: y, size: markerSize
				};
				var markerColor = (0, _utils.intToHexColorString)(id);
				//RenderHelper.drawMarker(x, y, this._eventManager.ghostCtx, markerType, markerSize, markerColor, markerColor, dataSeries.markerBorderThickness);
				if (_utils.isCanvasSupported) _render2.default.drawMarker(x, y, this._eventManager.ghostCtx, markerProps.type, markerProps.size, markerColor, markerColor, markerProps.borderThickness);

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "bubble",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						point: {
							x: x, y: y
						},
						direction: 1,
						bounds: {
							x1: x - markerProps.size / 2, y1: y - markerProps.size / 2, x2: x + markerProps.size / 2, y2: y + markerProps.size / 2
						},
						color: color
					});
				}
			}
		}
	}

	ctx.restore();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: _animator2.default.fadeInAnimation, easingFunction: _animator2.default.easing.easeInQuad, animationBase: 0
	};
	return animationInfo;
};

var _render = require('../helpers/render');

var _render2 = _interopRequireDefault(_render);

var _animator = require('../helpers/animator');

var _animator2 = _interopRequireDefault(_animator);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

},{"../helpers/animator":37,"../helpers/render":38,"../helpers/utils":39}],4:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;
	var ghostCtx = this._eventManager.ghostCtx;

	var totalDataSeries = plotUnit.dataSeriesIndexes.length;
	if (totalDataSeries <= 0) return;

	var color = null;

	var plotArea = this.plotArea;

	var i = 0,
	    x,
	    y1,
	    y2,
	    y3,
	    y4;
	var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number from dataTime everytime it is used.

	var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) << 0;

	var maxBarWidth = this.dataPointMaxWidth ? this.dataPointMaxWidth : this.width * .015;
	var xMinDiff = plotUnit.axisX.dataInfo.minDiff;
	var barWidth = plotArea.width / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum) * Math.abs(xMinDiff) * .7 << 0;

	if (barWidth > maxBarWidth) barWidth = maxBarWidth;else if (xMinDiff === Infinity) {
		barWidth = maxBarWidth;
	} else if (barWidth < 1) barWidth = 1;

	ctx.save();
	if (_utils.isCanvasSupported) ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		ghostCtx.clip();
	}
	//ctx.beginPath();

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var isFirstDataPointInPlotArea = true;

		// Reducing pixelPerUnit by 1 just to overcome any problems due to rounding off of pixels.
		//dataSeries.maxWidthInX = barWidth / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);

		//var offsetX = barWidth * plotUnit.index << 0;


		if (dataPoints.length > 0) {
			//var xy = this.getPixelCoordinatesOnPlotArea(dataPoints[0].x, dataPoints[0].y);

			var bevelEnabled = barWidth > 5 && dataSeries.bevelEnabled ? true : false;

			for (i = 0; i < dataPoints.length; i++) {

				dataPoints[i].getTime ? dataPointX = dataPoints[i].x.getTime() : dataPointX = dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (dataPoints[i].y === null || !dataPoints[i].y.length || typeof dataPoints[i].y[0] !== "number" || typeof dataPoints[i].y[1] !== "number" || typeof dataPoints[i].y[2] !== "number" || typeof dataPoints[i].y[3] !== "number") continue;

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				y1 = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y[0] - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;
				y2 = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y[1] - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				y3 = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y[2] - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;
				y4 = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y[3] - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				var x1 = x - barWidth / 2 << 0;
				var x2 = x1 + barWidth << 0;

				color = dataPoints[i].color ? dataPoints[i].color : dataSeries._colorSet[0];

				//var borderThickness = Math.max(2, ((barWidth * .1) / 2 << 0) * 2); // Set only even numbers for border
				var borderThickness = Math.round(Math.max(1, barWidth * .15));
				//borderThickness = (borderThickness / 2 << 0) * 2;
				//borderThickness = 2;
				var offset = borderThickness % 2 === 0 ? 0 : .5;

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x1, y1: y1, x2: x2, y2: y2,
					x3: x, y3: y3, x4: x, y4: y4, borderThickness: borderThickness, color: color
				};

				ctx.strokeStyle = color;
				ctx.beginPath();
				ctx.lineWidth = borderThickness;
				ghostCtx.lineWidth = Math.max(borderThickness, 4);

				if (dataSeries.type === "candlestick") {

					ctx.moveTo(x - offset, y2);
					ctx.lineTo(x - offset, Math.min(y1, y4));
					ctx.stroke();
					ctx.moveTo(x - offset, Math.max(y1, y4));
					ctx.lineTo(x - offset, y3);
					ctx.stroke();

					drawRect(ctx, x1, Math.min(y1, y4), x2, Math.max(y1, y4), dataPoints[i].y[0] <= dataPoints[i].y[3] ? dataSeries.risingColor : color, borderThickness, color, bevelEnabled, bevelEnabled, false, false, dataSeries.fillOpacity);

					if (_utils.isCanvasSupported) {
						color = intToHexColorString(id);
						ghostCtx.strokeStyle = color;

						ghostCtx.moveTo(x - offset, y2);
						ghostCtx.lineTo(x - offset, Math.min(y1, y4));
						ghostCtx.stroke();
						ghostCtx.moveTo(x - offset, Math.max(y1, y4));
						ghostCtx.lineTo(x - offset, y3);
						ghostCtx.stroke();
						drawRect(ghostCtx, x1, Math.min(y1, y4), x2, Math.max(y1, y4), color, 0, null, false, false, false, false);
					}
				} else if (dataSeries.type === "ohlc") {

					ctx.moveTo(x - offset, y2);
					ctx.lineTo(x - offset, y3);
					ctx.stroke();

					ctx.beginPath();
					ctx.moveTo(x, y1);
					ctx.lineTo(x1, y1);
					ctx.stroke();

					ctx.beginPath();
					ctx.moveTo(x, y4);
					ctx.lineTo(x2, y4);
					ctx.stroke();

					if (_utils.isCanvasSupported) {

						color = intToHexColorString(id);
						ghostCtx.strokeStyle = color;

						ghostCtx.moveTo(x - offset, y2);
						ghostCtx.lineTo(x - offset, y3);
						ghostCtx.stroke();

						ghostCtx.beginPath();
						ghostCtx.moveTo(x, y1);
						ghostCtx.lineTo(x1, y1);
						ghostCtx.stroke();

						ghostCtx.beginPath();
						ghostCtx.moveTo(x, y4);
						ghostCtx.lineTo(x2, y4);
						ghostCtx.stroke();
					}
				}

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: dataSeries.type,
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						point: {
							x: x1 + (x2 - x1) / 2, y: y2
						},
						direction: 1,
						bounds: {
							x1: x1, y1: Math.min(y2, y3), x2: x2, y2: Math.max(y2, y3)
						},
						color: color
					});
				}
			}
		}
	}

	ctx.restore();

	if (_utils.isCanvasSupported) ghostCtx.restore();

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: AnimationHelper.fadeInAnimation, easingFunction: AnimationHelper.easing.easeInQuad, animationBase: 0
	};
	return animationInfo;
};

var _utils = require("../helpers/utils");

},{"../helpers/utils":39}],5:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {

	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;

	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var color = null;

	var plotArea = this.plotArea;

	var i = 0,
	    x,
	    y;
	var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number from dataTime everytime it is used.

	var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) << 0;

	var maxBarWidth = this.dataPointMaxWidth ? this.dataPointMaxWidth : Math.min(this.width * .15, this.plotArea.width / plotUnit.plotType.totalDataSeries * .9) << 0;
	var xMinDiff = plotUnit.axisX.dataInfo.minDiff;
	var barWidth = plotArea.width / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum) * Math.abs(xMinDiff) / plotUnit.plotType.totalDataSeries * .9 << 0;

	if (barWidth > maxBarWidth) barWidth = maxBarWidth;else if (xMinDiff === Infinity) {
		barWidth = maxBarWidth / plotUnit.plotType.totalDataSeries * .9;
	} else if (barWidth < 1) barWidth = 1;

	ctx.save();
	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		this._eventManager.ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		this._eventManager.ghostCtx.clip();
	}
	//ctx.beginPath();

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var isFirstDataPointInPlotArea = true;

		// Reducing pixelPerUnit by 1 just to overcome any problems due to rounding off of pixels.
		//dataSeries.maxWidthInX = barWidth / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);

		//var offsetX = barWidth * plotUnit.index << 0;


		if (dataPoints.length > 0) {
			//var xy = this.getPixelCoordinatesOnPlotArea(dataPoints[0].x, dataPoints[0].y);

			var bevelEnabled = barWidth > 5 && dataSeries.bevelEnabled ? true : false;

			for (i = 0; i < dataPoints.length; i++) {

				dataPoints[i].getTime ? dataPointX = dataPoints[i].x.getTime() : dataPointX = dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (typeof dataPoints[i].y !== "number") continue;

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				y = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				var x1 = x - plotUnit.plotType.totalDataSeries * barWidth / 2 + (plotUnit.previousDataSeriesCount + j) * barWidth << 0;
				var x2 = x1 + barWidth << 0;
				var y1;
				var y2;

				if (dataPoints[i].y >= 0) {
					y1 = y;

					y2 = yZeroToPixel;

					if (y1 > y2) {
						var temp = y1;
						y1 = y2;
						y2 = y1;
					}
				} else {
					y2 = y;

					y1 = yZeroToPixel;

					if (y1 > y2) {
						var temp = y1;
						y1 = y2;
						y2 = y1;
					}
				}

				color = dataPoints[i].color ? dataPoints[i].color : dataSeries._colorSet[i % dataSeries._colorSet.length];
				(0, _utils.drawRect)(ctx, x1, y1, x2, y2, color, 0, null, bevelEnabled && dataPoints[i].y >= 0, dataPoints[i].y < 0 && bevelEnabled, false, false, dataSeries.fillOpacity);

				//if (dataSeries.markerType && dataSeries.markerSize > 0) {
				//    RenderHelper.drawMarker(x1 + (x2 - x1) / 2, y, ctx, dataSeries.markerType, dataSeries.markerSize, color, dataSeries.markerBorderColor, dataSeries.markerBorderThickness ? dataSeries.markerBorderThickness : 1);
				//}

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x1, y1: y1, x2: x2, y2: y2
				};

				color = (0, _utils.intToHexColorString)(id);
				if (_utils.isCanvasSupported) (0, _utils.drawRect)(this._eventManager.ghostCtx, x1, y1, x2, y2, color, 0, null, false, false, false, false);

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "column",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						point: {
							x: x1 + (x2 - x1) / 2, y: dataPoints[i].y >= 0 ? y1 : y2
						},
						direction: dataPoints[i].y >= 0 ? 1 : -1,
						bounds: {
							x1: x1, y1: Math.min(y1, y2), x2: x2, y2: Math.max(y1, y2)
						},
						color: color
					});
				}
			}
		}
	}

	ctx.restore();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	//source and dest would be same when animation is not enabled
	var animationBase = Math.min(yZeroToPixel, plotUnit.axisY.boundingRect.y2);
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: _animator2.default.yScaleAnimation, easingFunction: _animator2.default.easing.easeOutQuart, animationBase: animationBase
	};
	return animationInfo;
};

var _animator = require('../helpers/animator');

var _animator2 = _interopRequireDefault(_animator);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

},{"../helpers/animator":37,"../helpers/utils":39}],6:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PieChart = exports.RangeSplineAreaChart = exports.RangeAreaChart = exports.RangeBarChart = exports.RangeColumnChart = exports.CandlestickChart = exports.ScatterChart = exports.BubbleChart = exports.StackedArea100Chart = exports.StackedAreaChart = exports.StepAreaChart = exports.SplineAreaChart = exports.AreaChart = exports.StackedBar100Chart = exports.StackedBarChart = exports.BarChart = exports.StackedColumn100Chart = exports.StackedColumnChart = exports.ColumnChart = exports.SplineChart = undefined;

var _spline = require('../charts/spline');

var _spline2 = _interopRequireDefault(_spline);

var _column = require('../charts/column');

var _column2 = _interopRequireDefault(_column);

var _stacked_column = require('../charts/stacked_column');

var _stacked_column2 = _interopRequireDefault(_stacked_column);

var _stacked_column_ = require('../charts/stacked_column_100');

var _stacked_column_2 = _interopRequireDefault(_stacked_column_);

var _bar = require('../charts/bar');

var _bar2 = _interopRequireDefault(_bar);

var _stacked_bar = require('../charts/stacked_bar');

var _stacked_bar2 = _interopRequireDefault(_stacked_bar);

var _stacked_bar_ = require('../charts/stacked_bar_100');

var _stacked_bar_2 = _interopRequireDefault(_stacked_bar_);

var _area = require('../charts/area');

var _area2 = _interopRequireDefault(_area);

var _spline_area = require('../charts/spline_area');

var _spline_area2 = _interopRequireDefault(_spline_area);

var _step_area = require('../charts/step_area');

var _step_area2 = _interopRequireDefault(_step_area);

var _stacked_area = require('../charts/stacked_area');

var _stacked_area2 = _interopRequireDefault(_stacked_area);

var _stacked_area_ = require('../charts/stacked_area_100');

var _stacked_area_2 = _interopRequireDefault(_stacked_area_);

var _bubble = require('../charts/bubble');

var _bubble2 = _interopRequireDefault(_bubble);

var _scatter = require('../charts/scatter');

var _scatter2 = _interopRequireDefault(_scatter);

var _candlestick = require('../charts/candlestick');

var _candlestick2 = _interopRequireDefault(_candlestick);

var _range_column = require('../charts/range_column');

var _range_column2 = _interopRequireDefault(_range_column);

var _range_bar = require('../charts/range_bar');

var _range_bar2 = _interopRequireDefault(_range_bar);

var _range_area = require('../charts/range_area');

var _range_area2 = _interopRequireDefault(_range_area);

var _range_spline_area = require('../charts/range_spline_area');

var _range_spline_area2 = _interopRequireDefault(_range_spline_area);

var _pie = require('../charts/pie');

var _pie2 = _interopRequireDefault(_pie);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.SplineChart = _spline2.default;
exports.ColumnChart = _column2.default;
exports.StackedColumnChart = _stacked_column2.default;
exports.StackedColumn100Chart = _stacked_column_2.default;
exports.BarChart = _bar2.default;
exports.StackedBarChart = _stacked_bar2.default;
exports.StackedBar100Chart = _stacked_bar_2.default;
exports.AreaChart = _area2.default;
exports.SplineAreaChart = _spline_area2.default;
exports.StepAreaChart = _step_area2.default;
exports.StackedAreaChart = _stacked_area2.default;
exports.StackedArea100Chart = _stacked_area_2.default;
exports.BubbleChart = _bubble2.default;
exports.ScatterChart = _scatter2.default;
exports.CandlestickChart = _candlestick2.default;
exports.RangeColumnChart = _range_column2.default;
exports.RangeBarChart = _range_bar2.default;
exports.RangeAreaChart = _range_area2.default;
exports.RangeSplineAreaChart = _range_spline_area2.default;
exports.PieChart = _pie2.default;

},{"../charts/area":1,"../charts/bar":2,"../charts/bubble":3,"../charts/candlestick":4,"../charts/column":5,"../charts/pie":7,"../charts/range_area":8,"../charts/range_bar":9,"../charts/range_column":10,"../charts/range_spline_area":11,"../charts/scatter":12,"../charts/spline":13,"../charts/spline_area":14,"../charts/stacked_area":15,"../charts/stacked_area_100":16,"../charts/stacked_bar":17,"../charts/stacked_bar_100":18,"../charts/stacked_column":19,"../charts/stacked_column_100":20,"../charts/step_area":21}],7:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {

	var _this = this;
	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var dataSeriesIndex = plotUnit.dataSeriesIndexes[0];
	var dataSeries = this.data[dataSeriesIndex];
	var dataPoints = dataSeries.dataPoints;
	var indexLabelLineEdgeLength = 10;
	var explodeDuration = 500;

	var plotArea = this.plotArea;

	//var maxFrame = isCanvasSupported ? 300 : 4;
	//var totalRecursions = 0;
	var dataPointEOs = []; //dataPoint Extension Objects Behaves like a storage place for all additional data relating to dataPoints. Requred because actual dataPoints should not be modified.

	var minDistanceBetweenLabels = 2;
	var indexLabelRadiusToRadiusRatio = 1.3;
	var poleAnglularDistance = 20 / 180 * Math.PI; //Anglular Distance from 90 & 270 to be considered pole
	var precision = 6;

	var center = {
		x: (plotArea.x2 + plotArea.x1) / 2, y: (plotArea.y2 + plotArea.y1) / 2
	};

	var sum = 0;
	var isIndexLabelPresent = false;
	for (var j = 0; j < dataPoints.length; j++) {
		sum += Math.abs(dataPoints[j].y);

		if (!isIndexLabelPresent && typeof dataPoints[j].indexLabel !== "undefined" && dataPoints[j].indexLabel !== null && dataPoints[j].indexLabel.toString().length > 0) isIndexLabelPresent = true;

		if (!isIndexLabelPresent && typeof dataPoints[j].label !== "undefined" && dataPoints[j].label !== null && dataPoints[j].label.toString().length > 0) isIndexLabelPresent = true;
	}

	if (sum === 0) return;

	isIndexLabelPresent = isIndexLabelPresent || typeof dataSeries.indexLabel !== "undefined" && dataSeries.indexLabel !== null && dataSeries.indexLabel.toString().length > 0;

	var outerRadius = dataSeries.indexLabelPlacement !== "inside" && isIndexLabelPresent ? Math.min(plotArea.width, plotArea.height) * 0.75 / 2 : Math.min(plotArea.width, plotArea.height) * .92 / 2;

	if (dataSeries.radius) outerRadius = (0, _utils.convertPercentToValue)(dataSeries.radius, outerRadius);

	var innerRadius = typeof dataSeries.innerRadius !== 'undefined' && dataSeries.innerRadius !== null ? (0, _utils.convertPercentToValue)(dataSeries.innerRadius, outerRadius) : 0.7 * outerRadius;

	var percentInnerRadius = Math.min(innerRadius / outerRadius, (outerRadius - 1) / outerRadius);

	function initLabels() {

		if (!dataSeries || !dataPoints) return;

		var noDPNearSouthPole = 0;
		var noDPNearNorthPole = 0;
		var firstDPCloseToSouth = 0;
		var firstDPCloseToNorth = 0;

		for (j = 0; j < dataPoints.length; j++) {

			var dataPoint = dataPoints[j];
			var id = dataSeries.dataPointIds[j];

			var dataPointEO = {
				id: id, objectType: "dataPoint", dataPointIndex: j, dataSeriesIndex: 0
			};
			dataPointEOs.push(dataPointEO);

			var percentAndTotal = {
				percent: null, total: null
			};
			var formatterParameter = null;

			percentAndTotal = _this.getPercentAndTotal(dataSeries, dataPoint);

			if (dataSeries.indexLabelFormatter || dataPoint.indexLabelFormatter) formatterParameter = {
				chart: _this._options, dataSeries: dataSeries, dataPoint: dataPoint, total: percentAndTotal.total, percent: percentAndTotal.percent
			};

			var indexLabelText = dataPoint.indexLabelFormatter ? dataPoint.indexLabelFormatter(formatterParameter) : dataPoint.indexLabel ? _this.replaceKeywordsWithValue(dataPoint.indexLabel, dataPoint, dataSeries, j) : dataSeries.indexLabelFormatter ? dataSeries.indexLabelFormatter(formatterParameter) : dataSeries.indexLabel ? _this.replaceKeywordsWithValue(dataSeries.indexLabel, dataPoint, dataSeries, j) : dataPoint.label ? dataPoint.label : '';

			_this._eventManager.objectMap[id] = dataPointEO;

			//dataPointEO.indexLabelText = j.toString() + " " + "kingfisher: " + dataPoint.y.toString();;
			dataPointEO.center = {
				x: center.x, y: center.y
			};
			dataPointEO.y = dataPoint.y;
			dataPointEO.radius = outerRadius;
			dataPointEO.percentInnerRadius = percentInnerRadius;
			dataPointEO.indexLabelText = indexLabelText;
			dataPointEO.indexLabelPlacement = dataSeries.indexLabelPlacement;
			dataPointEO.indexLabelLineColor = dataPoint.indexLabelLineColor ? dataPoint.indexLabelLineColor : dataSeries.indexLabelLineColor ? dataSeries.indexLabelLineColor : dataPoint.color ? dataPoint.color : dataSeries._colorSet[j % dataSeries._colorSet.length];
			dataPointEO.indexLabelLineThickness = dataPoint.indexLabelLineThickness ? dataPoint.indexLabelLineThickness : dataSeries.indexLabelLineThickness;
			dataPointEO.indexLabelLineDashType = dataPoint.indexLabelLineDashType ? dataPoint.indexLabelLineDashType : dataSeries.indexLabelLineDashType;
			dataPointEO.indexLabelFontColor = dataPoint.indexLabelFontColor ? dataPoint.indexLabelFontColor : dataSeries.indexLabelFontColor;
			dataPointEO.indexLabelFontStyle = dataPoint.indexLabelFontStyle ? dataPoint.indexLabelFontStyle : dataSeries.indexLabelFontStyle;
			dataPointEO.indexLabelFontWeight = dataPoint.indexLabelFontWeight ? dataPoint.indexLabelFontWeight : dataSeries.indexLabelFontWeight;
			dataPointEO.indexLabelFontSize = dataPoint.indexLabelFontSize ? dataPoint.indexLabelFontSize : dataSeries.indexLabelFontSize;
			dataPointEO.indexLabelFontFamily = dataPoint.indexLabelFontFamily ? dataPoint.indexLabelFontFamily : dataSeries.indexLabelFontFamily;
			dataPointEO.indexLabelBackgroundColor = dataPoint.indexLabelBackgroundColor ? dataPoint.indexLabelBackgroundColor : dataSeries.indexLabelBackgroundColor ? dataSeries.indexLabelBackgroundColor : null;
			dataPointEO.indexLabelMaxWidth = dataPoint.indexLabelMaxWidth ? dataPoint.indexLabelMaxWidth : dataSeries.indexLabelMaxWidth ? dataSeries.indexLabelMaxWidth : plotArea.width * .33;
			dataPointEO.indexLabelWrap = typeof dataPoint.indexLabelWrap !== "undefined" ? dataPoint.indexLabelWrap : dataSeries.indexLabelWrap;

			dataPointEO.startAngle = j === 0 ? dataSeries.startAngle ? dataSeries.startAngle / 180 * Math.PI : 0 : dataPointEOs[j - 1].endAngle;

			dataPointEO.startAngle = (dataPointEO.startAngle + 2 * Math.PI) % (2 * Math.PI);

			dataPointEO.endAngle = dataPointEO.startAngle + 2 * Math.PI / sum * Math.abs(dataPoint.y);

			//var midAngle = dataPointEO.startAngle + Math.abs(dataPointEO.endAngle - dataPointEO.startAngle) / 2;
			var midAngle = (dataPointEO.endAngle + dataPointEO.startAngle) / 2;

			//var midAngle = (180 / Math.PI * midAngle);

			midAngle = (midAngle + 2 * Math.PI) % (2 * Math.PI);

			dataPointEO.midAngle = midAngle;

			if (dataPointEO.midAngle > Math.PI / 2 - poleAnglularDistance && dataPointEO.midAngle < Math.PI / 2 + poleAnglularDistance) {
				if (noDPNearSouthPole === 0 || dataPointEOs[firstDPCloseToSouth].midAngle > dataPointEO.midAngle) firstDPCloseToSouth = j;

				noDPNearSouthPole++;
			} else if (dataPointEO.midAngle > 3 * Math.PI / 2 - poleAnglularDistance && dataPointEO.midAngle < 3 * Math.PI / 2 + poleAnglularDistance) {
				if (noDPNearNorthPole === 0 || dataPointEOs[firstDPCloseToNorth].midAngle > dataPointEO.midAngle) firstDPCloseToNorth = j;

				noDPNearNorthPole++;
			}

			if (midAngle > Math.PI / 2 && midAngle <= 3 * Math.PI / 2) dataPointEO.hemisphere = "left";else dataPointEO.hemisphere = "right";

			//dataPointEO.indexLabelText = j.toString() + "; " + dataPoint.y.toString() + "; " + midAngle.toString() + "; junk";
			dataPointEO.indexLabelTextBlock = new _text_block2.default(_this.plotArea.ctx, {
				fontSize: dataPointEO.indexLabelFontSize, fontFamily: dataPointEO.indexLabelFontFamily, fontColor: dataPointEO.indexLabelFontColor,
				fontStyle: dataPointEO.indexLabelFontStyle, fontWeight: dataPointEO.indexLabelFontWeight,
				horizontalAlign: "left",
				backgroundColor: dataPointEO.indexLabelBackgroundColor,
				maxWidth: dataPointEO.indexLabelMaxWidth, maxHeight: dataPointEO.indexLabelWrap ? dataPointEO.indexLabelFontSize * 5 : dataPointEO.indexLabelFontSize * 1.5,
				text: dataPointEO.indexLabelText,
				padding: 0,
				//textBaseline: dataPointEO.indexLabelBackgroundColor ? "middle" : "top"
				textBaseline: "top"
			});

			dataPointEO.indexLabelTextBlock.measureText();

			//dataPoint.labelWidth = ctx.measureText(j.toString() + "; " + dataPoint.label).width;

			//console.log(dataPoint.label);
		}

		var noOfDPToRightOfSouthPole = 0;
		var noOfDPToLeftOfNorthPole = 0;
		var keepSameDirection = false; // once a dataPoint's hemisphere is changed, others should follow the same so that there are no labes near pole pointing in opposite direction.

		for (j = 0; j < dataPoints.length; j++) {

			var dataPointEO = dataPointEOs[(firstDPCloseToSouth + j) % dataPoints.length];

			if (noDPNearSouthPole > 1 && dataPointEO.midAngle > Math.PI / 2 - poleAnglularDistance && dataPointEO.midAngle < Math.PI / 2 + poleAnglularDistance) {

				if (noOfDPToRightOfSouthPole <= noDPNearSouthPole / 2 && !keepSameDirection) {
					dataPointEO.hemisphere = "right";
					noOfDPToRightOfSouthPole++;
				} else {
					dataPointEO.hemisphere = "left";
					keepSameDirection = true;
				}
			}
		}

		keepSameDirection = false;
		for (j = 0; j < dataPoints.length; j++) {

			var dataPointEO = dataPointEOs[(firstDPCloseToNorth + j) % dataPoints.length];

			//if (dataPoint.hemisphere = "right")
			//	break;

			if (noDPNearNorthPole > 1 && dataPointEO.midAngle > 3 * Math.PI / 2 - poleAnglularDistance && dataPointEO.midAngle < 3 * Math.PI / 2 + poleAnglularDistance) {

				if (noOfDPToLeftOfNorthPole <= noDPNearNorthPole / 2 && !keepSameDirection) {
					dataPointEO.hemisphere = "left";
					noOfDPToLeftOfNorthPole++;
				} else {
					dataPointEO.hemisphere = "right";
					keepSameDirection = true;
				}
			}
		}
	} //End of initLabels()

	function renderLabels() {

		var ctx = _this.plotArea.ctx;
		ctx.fillStyle = "black";
		ctx.strokeStyle = "grey";
		var fontSize = 16;
		//ctx.font = fontSize + "px Arial";
		ctx.textBaseline = "middle";
		ctx.lineJoin = "round";
		var i = 0,
		    j = 0;

		for (i = 0; i < dataPoints.length; i++) {
			var dataPointEO = dataPointEOs[i];

			if (!dataPointEO.indexLabelText) continue;

			dataPointEO.indexLabelTextBlock.y -= dataPointEO.indexLabelTextBlock.height / 2;

			var xOffset = 0;

			if (dataPointEO.hemisphere === "left") {
				var xOffset = dataSeries.indexLabelPlacement !== "inside" ? -(dataPointEO.indexLabelTextBlock.width + indexLabelLineEdgeLength) : -dataPointEO.indexLabelTextBlock.width / 2;
			} else {
				var xOffset = dataSeries.indexLabelPlacement !== "inside" ? indexLabelLineEdgeLength : -dataPointEO.indexLabelTextBlock.width / 2;
			}

			dataPointEO.indexLabelTextBlock.x += xOffset;
			dataPointEO.indexLabelTextBlock.render(true);
			dataPointEO.indexLabelTextBlock.x -= xOffset;

			//if (i < 4)
			//	customPrompt(i + "; " + center.y + "; " + dataPointEO.indexLabelTextBlock.y.toFixed(2));

			dataPointEO.indexLabelTextBlock.y += dataPointEO.indexLabelTextBlock.height / 2;

			if (dataPointEO.indexLabelPlacement !== "inside") {
				var indexLabelLineStartX = dataPointEO.center.x + outerRadius * Math.cos(dataPointEO.midAngle);
				var indexLabelLineStartY = dataPointEO.center.y + outerRadius * Math.sin(dataPointEO.midAngle);

				//ctx.strokeStyle = dataPoints[i].color ? dataPoints[i].color : dataSeries._colorSet[i % dataSeries._colorSet.length];
				ctx.strokeStyle = dataPointEO.indexLabelLineColor;
				ctx.lineWidth = dataPointEO.indexLabelLineThickness;

				if (ctx.setLineDash) {
					ctx.setLineDash((0, _utils.getLineDashArray)(dataPointEO.indexLabelLineDashType, dataPointEO.indexLabelLineThickness));
				}

				//ctx.lineWidth = 4;
				ctx.beginPath();
				ctx.moveTo(indexLabelLineStartX, indexLabelLineStartY);
				ctx.lineTo(dataPointEO.indexLabelTextBlock.x, dataPointEO.indexLabelTextBlock.y);
				ctx.lineTo(dataPointEO.indexLabelTextBlock.x + (dataPointEO.hemisphere === "left" ? -indexLabelLineEdgeLength : indexLabelLineEdgeLength), dataPointEO.indexLabelTextBlock.y);
				ctx.stroke();
				//ctx.closePath();
				//window.alert("contine??");
				//animate();
			}

			ctx.lineJoin = "miter";
		}
	}

	function animate(fractionComplete) {

		var ctx = _this.plotArea.ctx;

		ctx.clearRect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		ctx.fillStyle = _this.backgroundColor;
		ctx.fillRect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);

		var maxAngle = dataPointEOs[0].startAngle + 2 * Math.PI * fractionComplete;

		for (var i = 0; i < dataPoints.length; i++) {

			var startAngle = i === 0 ? dataPointEOs[i].startAngle : endAngle;
			var endAngle = startAngle + (dataPointEOs[i].endAngle - dataPointEOs[i].startAngle);

			var shouldBreak = false;

			if (endAngle > maxAngle) {
				endAngle = maxAngle;
				shouldBreak = true;
			}

			var color = dataPoints[i].color ? dataPoints[i].color : dataSeries._colorSet[i % dataSeries._colorSet.length];

			if (endAngle > startAngle) (0, _utils.drawSegment)(_this.plotArea.ctx, dataPointEOs[i].center, dataPointEOs[i].radius, color, dataSeries.type, startAngle, endAngle, dataSeries.fillOpacity, dataPointEOs[i].percentInnerRadius);

			if (shouldBreak) break;
		}
	}

	function explodeToggle(fractionComplete) {

		var ctx = _this.plotArea.ctx;

		ctx.clearRect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		ctx.fillStyle = _this.backgroundColor;
		ctx.fillRect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);

		for (var i = 0; i < dataPoints.length; i++) {

			var startAngle = dataPointEOs[i].startAngle;
			var endAngle = dataPointEOs[i].endAngle;

			if (endAngle > startAngle) {

				var offsetX = outerRadius * .07 * Math.cos(dataPointEOs[i].midAngle);
				var offsetY = outerRadius * .07 * Math.sin(dataPointEOs[i].midAngle);
				var isInTransition = false;

				if (dataPoints[i].exploded) {
					if (Math.abs(dataPointEOs[i].center.x - (center.x + offsetX)) > 0.000000001 || Math.abs(dataPointEOs[i].center.y - (center.y + offsetY)) > 0.000000001) {

						dataPointEOs[i].center.x = center.x + offsetX * fractionComplete;
						dataPointEOs[i].center.y = center.y + offsetY * fractionComplete;

						isInTransition = true;
					}
				} else if (Math.abs(dataPointEOs[i].center.x - center.x) > 0 || Math.abs(dataPointEOs[i].center.y - center.y) > 0) {
					dataPointEOs[i].center.x = center.x + offsetX * (1 - fractionComplete);
					dataPointEOs[i].center.y = center.y + offsetY * (1 - fractionComplete);

					isInTransition = true;
				}

				if (isInTransition) {
					var entry = {};
					entry.dataSeries = dataSeries;
					entry.dataPoint = dataSeries.dataPoints[i];
					entry.index = i;
					_this._toolTip.highlightObjects([entry]);
				}

				var color = dataPoints[i].color ? dataPoints[i].color : dataSeries._colorSet[i % dataSeries._colorSet.length];

				(0, _utils.drawSegment)(_this.plotArea.ctx, dataPointEOs[i].center, dataPointEOs[i].radius, color, dataSeries.type, startAngle, endAngle, dataSeries.fillOpacity, dataPointEOs[i].percentInnerRadius);
			}
		}

		//window.alert("next??");
		renderLabels();
	}

	function areDataPointsTooClose(first, second) {

		var label1 = {
			x1: first.indexLabelTextBlock.x, y1: first.indexLabelTextBlock.y - first.indexLabelTextBlock.height / 2, x2: first.indexLabelTextBlock.x + first.indexLabelTextBlock.width, y2: first.indexLabelTextBlock.y + first.indexLabelTextBlock.height / 2
		};
		var label2 = {
			x1: second.indexLabelTextBlock.x, y1: second.indexLabelTextBlock.y - second.indexLabelTextBlock.height / 2, x2: second.indexLabelTextBlock.x + second.indexLabelTextBlock.width, y2: second.indexLabelTextBlock.y + second.indexLabelTextBlock.height / 2
		};

		if (label1.x2 < label2.x1 - indexLabelLineEdgeLength || label1.x1 > label2.x2 + indexLabelLineEdgeLength || label1.y1 > label2.y2 + indexLabelLineEdgeLength || label1.y2 < label2.y1 - indexLabelLineEdgeLength) return false;

		return true;
	}

	function getVerticalDistanceBetweenLabels(first, second) {

		var distance = 0;
		var label1 = {
			y: first.indexLabelTextBlock.y, y1: first.indexLabelTextBlock.y - first.indexLabelTextBlock.height / 2, y2: first.indexLabelTextBlock.y + first.indexLabelTextBlock.height / 2
		};
		var label2 = {
			y: second.indexLabelTextBlock.y, y1: second.indexLabelTextBlock.y - second.indexLabelTextBlock.height / 2, y2: second.indexLabelTextBlock.y + second.indexLabelTextBlock.height / 2
		};

		if (label2.y > label1.y) {
			distance = label2.y1 - label1.y2;
		} else {
			distance = label1.y1 - label2.y2;
		}

		return distance;
	}

	function getNextLabelIndex(currentLabelIndex) {
		var nextLabelIndex = null;

		for (var i = 1; i < dataPoints.length; i++) {

			nextLabelIndex = (currentLabelIndex + i + dataPointEOs.length) % dataPointEOs.length;

			if (dataPointEOs[nextLabelIndex].hemisphere !== dataPointEOs[currentLabelIndex].hemisphere) {
				nextLabelIndex = null;
				break;
			} else if (dataPointEOs[nextLabelIndex].indexLabelText && nextLabelIndex !== currentLabelIndex && (getVerticalDistanceBetweenLabels(dataPointEOs[nextLabelIndex], dataPointEOs[currentLabelIndex]) < 0 || (dataPointEOs[currentLabelIndex].hemisphere === "right" ? dataPointEOs[nextLabelIndex].indexLabelTextBlock.y >= dataPointEOs[currentLabelIndex].indexLabelTextBlock.y : dataPointEOs[nextLabelIndex].indexLabelTextBlock.y <= dataPointEOs[currentLabelIndex].indexLabelTextBlock.y))) break;else {
				nextLabelIndex = null;
			}
		}

		return nextLabelIndex;
	}

	function getPreviousLabelIndex(currentLabelIndex) {
		var prevLabelIndex = null;

		for (var i = 1; i < dataPoints.length; i++) {

			prevLabelIndex = (currentLabelIndex - i + dataPointEOs.length) % dataPointEOs.length;

			if (dataPointEOs[prevLabelIndex].hemisphere !== dataPointEOs[currentLabelIndex].hemisphere) {
				prevLabelIndex = null;
				break;
			} else if (dataPointEOs[prevLabelIndex].indexLabelText && dataPointEOs[prevLabelIndex].hemisphere === dataPointEOs[currentLabelIndex].hemisphere && prevLabelIndex !== currentLabelIndex && (getVerticalDistanceBetweenLabels(dataPointEOs[prevLabelIndex], dataPointEOs[currentLabelIndex]) < 0 || (dataPointEOs[currentLabelIndex].hemisphere === "right" ? dataPointEOs[prevLabelIndex].indexLabelTextBlock.y <= dataPointEOs[currentLabelIndex].indexLabelTextBlock.y : dataPointEOs[prevLabelIndex].indexLabelTextBlock.y >= dataPointEOs[currentLabelIndex].indexLabelTextBlock.y))) break;else {
				prevLabelIndex = null;
			}
		}

		return prevLabelIndex;
	}

	function rePositionLabels(dataPointIndex, offset) {
		offset = offset || 0;

		var actualOffset = 0;

		//var labelYMin = 2;
		//var labelYMax = ctx.canvas.height - 2;
		//var labelYMin = _this.plotArea.ctx.canvas.height / 2 - indexLabelRadius * 1;
		//var labelYMax = _this.plotArea.ctx.canvas.height / 2 + indexLabelRadius * 1;

		var labelYMin = center.y - indexLabelRadius * 1;
		var labelYMax = center.y + indexLabelRadius * 1;

		//console.log(totalRecursions);

		if (dataPointIndex >= 0 && dataPointIndex < dataPoints.length) {

			var dataPointEO = dataPointEOs[dataPointIndex];
			//if (dataPointIndex === 0)
			//	customPrompt(labelYMin.toFixed(2) + "; " + labelYMax.toFixed(2) + "; " + dataPointEO.indexLabelTextBlock.y.toFixed(2));

			// If label is already outside the bounds, return
			if (offset < 0 && dataPointEO.indexLabelTextBlock.y < labelYMin || offset > 0 && dataPointEO.indexLabelTextBlock.y > labelYMax) return 0;

			var validOffset = offset;

			//Check if the offset falls within the bounds (labelYMin, labelYMax, tangential bounds) without considering overlap. Else use the closest offset that is possible - validOffset.
			{
				var distFromIndexLineStart = 0;
				var indexLabelLineStartX = 0;
				var indexLabelLineStartY = 0;
				var indexLabelAngle = 0;
				var indexLabelAngleWhenTangent = 0;

				if (validOffset < 0) {
					if (dataPointEO.indexLabelTextBlock.y - dataPointEO.indexLabelTextBlock.height / 2 > labelYMin && dataPointEO.indexLabelTextBlock.y - dataPointEO.indexLabelTextBlock.height / 2 + validOffset < labelYMin) validOffset = -(labelYMin - (dataPointEO.indexLabelTextBlock.y - dataPointEO.indexLabelTextBlock.height / 2 + validOffset));
				} else {
					if (dataPointEO.indexLabelTextBlock.y + dataPointEO.indexLabelTextBlock.height / 2 < labelYMin && dataPointEO.indexLabelTextBlock.y + dataPointEO.indexLabelTextBlock.height / 2 + validOffset > labelYMax) validOffset = dataPointEO.indexLabelTextBlock.y + dataPointEO.indexLabelTextBlock.height / 2 + validOffset - labelYMax;
				}

				var newlabelY = dataPointEO.indexLabelTextBlock.y + validOffset;
				var newlabelX = 0;

				if (dataPointEO.hemisphere === "right") {
					newlabelX = center.x + Math.sqrt(Math.pow(indexLabelRadius, 2) - Math.pow(newlabelY - center.y, 2));
				} else newlabelX = center.x - Math.sqrt(Math.pow(indexLabelRadius, 2) - Math.pow(newlabelY - center.y, 2));

				indexLabelLineStartX = center.x + outerRadius * Math.cos(dataPointEO.midAngle);
				indexLabelLineStartY = center.y + outerRadius * Math.sin(dataPointEO.midAngle);

				distFromIndexLineStart = Math.sqrt(Math.pow(newlabelX - indexLabelLineStartX, 2) + Math.pow(newlabelY - indexLabelLineStartY, 2));

				indexLabelAngleWhenTangent = Math.acos(outerRadius / indexLabelRadius);

				//indexLabelAngle = Math.acos((outerRadius * outerRadius + distFromIndexLineStart * distFromIndexLineStart - indexLabelRadius * indexLabelRadius) / (2 * outerRadius * distFromIndexLineStart));
				indexLabelAngle = Math.acos((indexLabelRadius * indexLabelRadius + outerRadius * outerRadius - distFromIndexLineStart * distFromIndexLineStart) / (2 * outerRadius * indexLabelRadius));

				if (indexLabelAngle < indexLabelAngleWhenTangent) {
					validOffset = newlabelY - dataPointEO.indexLabelTextBlock.y;
					//dataPointEO.indexLabelTextBlock.x = newlabelX;
				} else {

					validOffset = 0;

					//dataPointEO.indexLabelTextBlock.x = newlabelX;

					//Index Line is overlapping the pie. So lets find out the point where indexline becomes a tangent.

					//distFromIndexLineStart = Math.sqrt(indexLabelRadius * indexLabelRadius - outerRadius * outerRadius);
					////distFromIndexLineStart *= offset < 0 ? -1 : 1;
					////indexLabelAngle = Math.acos((indexLabelRadius * indexLabelRadius + outerRadius * outerRadius - distFromIndexLineStart * distFromIndexLineStart) / (2 * outerRadius * indexLabelRadius));
					//indexLabelAngle = Math.atan2(distFromIndexLineStart, outerRadius);

					//newlabelX = center.x + indexLabelRadius * Math.cos(indexLabelAngle);
					//newlabelY = center.y + indexLabelRadius * Math.sin(indexLabelAngle);

					//actualOffset = newlabelY - dataPointEO.indexLabelTextBlock.y;

					//dataPointEO.indexLabelTextBlock.y = newlabelY;
					//dataPointEO.indexLabelTextBlock.x = newlabelX;
				}
			}

			//var tempIndex = (dataPointIndex + dataPointEOs.length - 1) % dataPointEOs.length;

			//var prevDataPointIndex = dataPointEOs[tempIndex].hemisphere === dataPointEO.hemisphere ? tempIndex : null;

			var prevDataPointIndex = getPreviousLabelIndex(dataPointIndex);

			//tempIndex = (dataPointIndex + dataPointEOs.length + 1) % dataPointEOs.length;

			//var nextDataPointIndex = dataPointEOs[tempIndex].hemisphere === dataPointEO.hemisphere ? tempIndex : null;

			var nextDataPointIndex = getNextLabelIndex(dataPointIndex);

			var otherdataPointEO, otherDataPointIndex, distanceFromOtherLabel;
			var otherDataPointOffset = 0;
			var otherDataPointActualOffset = 0;

			if (validOffset < 0) {

				otherDataPointIndex = dataPointEO.hemisphere === "right" ? prevDataPointIndex : nextDataPointIndex;

				actualOffset = validOffset;

				if (otherDataPointIndex !== null) {

					//if (dataPointIndex < 4)
					//	customPrompt("valid: " + validOffset);

					var tempOffset = -validOffset;

					var distanceFromOtherLabel = dataPointEO.indexLabelTextBlock.y - dataPointEO.indexLabelTextBlock.height / 2 - (dataPointEOs[otherDataPointIndex].indexLabelTextBlock.y + dataPointEOs[otherDataPointIndex].indexLabelTextBlock.height / 2);

					if (distanceFromOtherLabel - tempOffset < minDistanceBetweenLabels) {
						otherDataPointOffset = -tempOffset;
						//totalRecursions++;
						otherDataPointActualOffset = rePositionLabels(otherDataPointIndex, otherDataPointOffset, recursionCount + 1);

						//if (dataPointIndex < 4)
						//	customPrompt(dataPointIndex + "; " + "offset: " + otherDataPointOffset);


						if (+otherDataPointActualOffset.toFixed(precision) > +otherDataPointOffset.toFixed(precision)) {

							if (distanceFromOtherLabel > minDistanceBetweenLabels) actualOffset = -(distanceFromOtherLabel - minDistanceBetweenLabels);
							//else
							//	actualOffset = 0;
							else actualOffset = -(tempOffset - (otherDataPointActualOffset - otherDataPointOffset));
						}

						//if (dataPointIndex < 4)
						//	customPrompt("actual: " + actualOffset);
					}
				}
			} else if (validOffset > 0) {

				otherDataPointIndex = dataPointEO.hemisphere === "right" ? nextDataPointIndex : prevDataPointIndex;

				actualOffset = validOffset;

				if (otherDataPointIndex !== null) {

					var tempOffset = validOffset;

					var distanceFromOtherLabel = dataPointEOs[otherDataPointIndex].indexLabelTextBlock.y - dataPointEOs[otherDataPointIndex].indexLabelTextBlock.height / 2 - (dataPointEO.indexLabelTextBlock.y + dataPointEO.indexLabelTextBlock.height / 2);

					if (distanceFromOtherLabel - tempOffset < minDistanceBetweenLabels) {
						otherDataPointOffset = tempOffset;
						//totalRecursions++;
						otherDataPointActualOffset = rePositionLabels(otherDataPointIndex, otherDataPointOffset, recursionCount + 1);

						if (+otherDataPointActualOffset.toFixed(precision) < +otherDataPointOffset.toFixed(precision)) {

							if (distanceFromOtherLabel > minDistanceBetweenLabels) actualOffset = distanceFromOtherLabel - minDistanceBetweenLabels;
							//else
							//	actualOffset = 0;
							else actualOffset = tempOffset - (otherDataPointOffset - otherDataPointActualOffset);
						}
					}
				}

				//if (!(dataPointEO.indexLabelTextBlock.y + dataPointEO.indexLabelTextBlock.height / 2 + actualOffset < labelYMax)) {
				//	if (dataPointEO.indexLabelTextBlock.y + dataPointEO.indexLabelTextBlock.height / 2 < labelYMax) {
				//		actualOffset = labelYMax - (dataPointEO.indexLabelTextBlock.y + dataPointEO.indexLabelTextBlock.height / 2);
				//	}
				//	else {
				//		actualOffset = 0;
				//	}
				//}
			}

			if (actualOffset) {

				var newLabelY = dataPointEO.indexLabelTextBlock.y + actualOffset;

				var newLabelX = 0;

				if (dataPointEO.hemisphere === "right") {
					newLabelX = center.x + Math.sqrt(Math.pow(indexLabelRadius, 2) - Math.pow(newLabelY - center.y, 2));
				} else newLabelX = center.x - Math.sqrt(Math.pow(indexLabelRadius, 2) - Math.pow(newLabelY - center.y, 2));

				if (dataPointEO.midAngle > Math.PI / 2 - poleAnglularDistance && dataPointEO.midAngle < Math.PI / 2 + poleAnglularDistance) {

					var prevDPIndex = (dataPointIndex - 1 + dataPointEOs.length) % dataPointEOs.length;
					var prevDP = dataPointEOs[prevDPIndex];
					var nextDP = dataPointEOs[(dataPointIndex + 1 + dataPointEOs.length) % dataPointEOs.length];

					if (dataPointEO.hemisphere === "left" && prevDP.hemisphere === "right" && newLabelX > prevDP.indexLabelTextBlock.x) {
						newLabelX = prevDP.indexLabelTextBlock.x - 15;
					} else if (dataPointEO.hemisphere === "right" && nextDP.hemisphere === "left" && newLabelX < nextDP.indexLabelTextBlock.x) {
						newLabelX = nextDP.indexLabelTextBlock.x + 15;
					}
				} else if (dataPointEO.midAngle > 3 * Math.PI / 2 - poleAnglularDistance && dataPointEO.midAngle < 3 * Math.PI / 2 + poleAnglularDistance) {

					var prevDPIndex = (dataPointIndex - 1 + dataPointEOs.length) % dataPointEOs.length;
					var prevDP = dataPointEOs[prevDPIndex];
					var nextDP = dataPointEOs[(dataPointIndex + 1 + dataPointEOs.length) % dataPointEOs.length];

					if (dataPointEO.hemisphere === "right" && prevDP.hemisphere === "left" && newLabelX < prevDP.indexLabelTextBlock.x) {
						newLabelX = prevDP.indexLabelTextBlock.x + 15;
					} else if (dataPointEO.hemisphere === "left" && nextDP.hemisphere === "right" && newLabelX > nextDP.indexLabelTextBlock.x) {
						newLabelX = nextDP.indexLabelTextBlock.x - 15;
					}
				}

				//if (actualOffset < 0 && dataPointIndex < 4)
				//	customPrompt(actualOffset.toFixed(2) + "; " + dataPointEO.indexLabelTextBlock.y.toFixed(2) + "; " + newLabelY.toFixed(2));

				dataPointEO.indexLabelTextBlock.y = newLabelY;

				dataPointEO.indexLabelTextBlock.x = newLabelX;

				dataPointEO.indexLabelAngle = Math.atan2(dataPointEO.indexLabelTextBlock.y - center.y, dataPointEO.indexLabelTextBlock.x - center.x);
			}
		}

		return actualOffset;
	}

	function positionLabels() {
		var ctx = _this.plotArea.ctx;

		ctx.fillStyle = "grey";
		ctx.strokeStyle = "grey";
		var fontSize = 16;
		ctx.font = fontSize + "px Arial";
		ctx.textBaseline = "middle";
		var i = 0,
		    j = 0;
		var deltaR = 0;

		var resizeFlag = true;

		var _loop = function _loop() {

			if (dataSeries.radius || !dataSeries.radius && typeof dataSeries.innerRadius !== 'undefined' && dataSeries.innerRadius !== null && outerRadius - deltaR <= innerRadius) resizeFlag = false;

			if (resizeFlag) outerRadius -= deltaR;

			deltaR = 0;

			if (dataSeries.indexLabelPlacement !== "inside") {
				indexLabelRadius = outerRadius * indexLabelRadiusToRadiusRatio;


				for (i = 0; i < dataPoints.length; i++) {
					dataPointEO = dataPointEOs[i];


					dataPointEO.indexLabelTextBlock.x = center.x + indexLabelRadius * Math.cos(dataPointEO.midAngle);
					dataPointEO.indexLabelTextBlock.y = center.y + indexLabelRadius * Math.sin(dataPointEO.midAngle);

					dataPointEO.indexLabelAngle = dataPointEO.midAngle;
					dataPointEO.radius = outerRadius;
					dataPointEO.percentInnerRadius = percentInnerRadius;
					//dataPointEO.indexLabelFontSize = dataPoint.indexLabelFontSize ? dataPoint.indexLabelFontSize : dataSeries.indexLabelFontSize;
				}

				for (i = 0; i < dataPoints.length; i++) {
					dataPointEO = dataPointEOs[i];
					//dataPointEO.lab
					//resetAnimationFrame();
					//animate();
					//renderLabels();

					//var prevDataPointIndex = (i - 1 + dataPointEOs.length) % dataPointEOs.length;

					//var nextDataPointIndex = (i + 1 + dataPointEOs.length) % dataPointEOs.length;
					//nextDataPointIndex = dataPointEOs[nextDataPointIndex].hemisphere === dataPointEO.hemisphere && nextDataPointIndex !== i ? nextDataPointIndex : null;

					nextDataPointIndex = getNextLabelIndex(i);


					if (nextDataPointIndex === null) continue;

					currentDataPoint = dataPointEOs[i];
					nextDataPoint = dataPointEOs[nextDataPointIndex];

					distanceFromNextLabel = 0;

					//if (dataPointEO.hemisphere === "right")
					//	distanceFromNextLabel = (nextDataPoint.indexLabelTextBlock.y - nextDataPoint.indexLabelTextBlock.height / 2) - (currentDataPoint.indexLabelTextBlock.y + currentDataPoint.indexLabelTextBlock.height / 2) - minDistanceBetweenLabels;
					//else
					//	distanceFromNextLabel = (currentDataPoint.indexLabelTextBlock.y - currentDataPoint.indexLabelTextBlock.height / 2) - (nextDataPoint.indexLabelTextBlock.y + nextDataPoint.indexLabelTextBlock.height / 2) - minDistanceBetweenLabels;

					distanceFromNextLabel = getVerticalDistanceBetweenLabels(currentDataPoint, nextDataPoint) - minDistanceBetweenLabels;

					if (distanceFromNextLabel < 0) {
						dataPointsAbove = 0;
						dataPointsBelow = 0;
						//var indexLabelAngleWhenTangent = Math.acos(outerRadius / indexLabelRadius) / Math.PI * 180;


						for (k = 0; k < dataPoints.length; k++) {

							if (k === i) continue;

							//if (dataPointEOs[k].hemisphere !== dataPointEO.hemisphere || Math.abs(dataPointEOs[k].midAngle - dataPointEO.midAngle) > 30)
							//	continue;
							//if (dataPointEOs[k].hemisphere !== dataPointEO.hemisphere || Math.abs(dataPointEOs[k].labelAngle - dataPointEO.indexLabelAngle) > 30)
							//	continue;
							//if (dataPointEOs[k].hemisphere !== dataPointEO.hemisphere || Math.abs(dataPointEOs[k].midAngle - dataPointEO.midAngle) > indexLabelAngleWhenTangent)
							//	continue;
							if (dataPointEOs[k].hemisphere !== dataPointEO.hemisphere) continue;

							if (dataPointEOs[k].indexLabelTextBlock.y < dataPointEO.indexLabelTextBlock.y) dataPointsAbove++;else dataPointsBelow++;
						}

						//var upWardsOffset = (distanceFromNextLabel) / dataPoints.length * (dataPointsBelow);
						upWardsOffset = distanceFromNextLabel / (dataPointsAbove + dataPointsBelow || 1) * dataPointsBelow;
						downWardsOffset = -1 * (distanceFromNextLabel - upWardsOffset);
						actualUpwardOffset = 0;
						actualDownwardOffset = 0;


						if (dataPointEO.hemisphere === "right") {
							actualUpwardOffset = rePositionLabels(i, upWardsOffset);

							//if (i < 4 && actualDownwardOffset !== upWardsOffset)
							//	customPrompt(i + "; " + upWardsOffset.toFixed(2) + "; " + actualUpwardOffset.toFixed(2));


							downWardsOffset = -1 * (distanceFromNextLabel - actualUpwardOffset);

							actualDownwardOffset = rePositionLabels(nextDataPointIndex, downWardsOffset);

							//window.alert(typeof +downWardsOffset.toFixed(precision));
							//Setting precision to make sure that they don't become not equal become of minor differences - like a difference of .000001
							if (+actualDownwardOffset.toFixed(precision) < +downWardsOffset.toFixed(precision) && +actualUpwardOffset.toFixed(precision) <= +upWardsOffset.toFixed(precision)) rePositionLabels(i, -(downWardsOffset - actualDownwardOffset));
						} else {
							actualUpwardOffset = rePositionLabels(nextDataPointIndex, upWardsOffset);

							downWardsOffset = -1 * (distanceFromNextLabel - actualUpwardOffset);

							actualDownwardOffset = rePositionLabels(i, downWardsOffset);

							//Setting precision to make sure that they don't become not equal become of minor differences - like a difference of .000001
							if (+actualDownwardOffset.toFixed(precision) < +downWardsOffset.toFixed(precision) && +actualUpwardOffset.toFixed(precision) <= +upWardsOffset.toFixed(precision)) rePositionLabels(nextDataPointIndex, -(downWardsOffset - actualDownwardOffset));
						}
					}

					//resetAnimationFrame();
					//animate();
					//renderLabels();
					//window.alert("next??");
				}
			} else {
				for (i = 0; i < dataPoints.length; i++) {
					dataPointEO = dataPointEOs[i];

					indexLabelRadius = dataSeries.type === "pie" ? outerRadius * .7 : outerRadius * .8;

					dx = center.x + indexLabelRadius * Math.cos(dataPointEO.midAngle);
					dy = center.y + indexLabelRadius * Math.sin(dataPointEO.midAngle);


					dataPointEO.indexLabelTextBlock.x = dx;
					dataPointEO.indexLabelTextBlock.y = dy;
				}
			}

			// Resize Pie based on the label length.
			for (i = 0; i < dataPoints.length; i++) {

				dataPointEO = dataPointEOs[i];

				size = dataPointEO.indexLabelTextBlock.measureText();
				// To make sure that null text or empty strings don't affect the radius. Required when user is not showing any labels

				if (size.height === 0 || size.width === 0) continue;

				xOverflow = 0;
				xdr = 0;


				if (dataPointEO.hemisphere === "right") {
					xOverflow = plotArea.x2 - (dataPointEO.indexLabelTextBlock.x + dataPointEO.indexLabelTextBlock.width + indexLabelLineEdgeLength);
					xOverflow *= -1;
				} else {
					xOverflow = plotArea.x1 - (dataPointEO.indexLabelTextBlock.x - dataPointEO.indexLabelTextBlock.width - indexLabelLineEdgeLength);
				}
				if (xOverflow > 0) {
					if (!resizeFlag && dataPointEO.indexLabelText) {
						newIndexLabelMaxWidth = dataPointEO.hemisphere === "right" ? plotArea.x2 - dataPointEO.indexLabelTextBlock.x : dataPointEO.indexLabelTextBlock.x - plotArea.x1;

						dataPointEO.indexLabelTextBlock.maxWidth * .3 > newIndexLabelMaxWidth ? dataPointEO.indexLabelText = "" : dataPointEO.indexLabelTextBlock.maxWidth = newIndexLabelMaxWidth * .85;
						if (dataPointEO.indexLabelTextBlock.maxWidth * .3 < newIndexLabelMaxWidth) dataPointEO.indexLabelTextBlock.x -= dataPointEO.hemisphere === "right" ? 2 : -2;
					}

					if (Math.abs(dataPointEO.indexLabelTextBlock.y - dataPointEO.indexLabelTextBlock.height / 2 - center.y) < outerRadius || Math.abs(dataPointEO.indexLabelTextBlock.y + dataPointEO.indexLabelTextBlock.height / 2 - center.y) < outerRadius) {

						xdr = xOverflow / Math.abs(Math.cos(dataPointEO.indexLabelAngle));

						if (xdr > 9) xdr = xdr * .3;

						if (xdr > deltaR) deltaR = xdr;
					}
				}

				yOverflow = 0;
				ydr = 0;


				if (dataPointEO.indexLabelAngle > 0 && dataPointEO.indexLabelAngle < Math.PI) {
					yOverflow = plotArea.y2 - (dataPointEO.indexLabelTextBlock.y + dataPointEO.indexLabelTextBlock.height / 2 + 5);
					yOverflow *= -1;
				} else {
					yOverflow = plotArea.y1 - (dataPointEO.indexLabelTextBlock.y - dataPointEO.indexLabelTextBlock.height / 2 - 5);
				}

				if (yOverflow > 0) {
					if (!resizeFlag && dataPointEO.indexLabelText) {
						positionMultiplier = dataPointEO.indexLabelAngle > 0 && dataPointEO.indexLabelAngle < Math.PI ? -1 : 1;

						if (rePositionLabels(i, yOverflow * positionMultiplier) === 0) rePositionLabels(i, 2 * positionMultiplier);
					}
					if (Math.abs(dataPointEO.indexLabelTextBlock.x - center.x) < outerRadius) {

						ydr = yOverflow / Math.abs(Math.sin(dataPointEO.indexLabelAngle));

						if (ydr > 9) ydr = ydr * .3;

						if (ydr > deltaR) deltaR = ydr;
					}
				}
			}

			function removeLabelsForSmallSegments(totalOverlap, startIndex, endIndex) {

				var dpEOs = [];
				var totalRemovedLabelHeight = 0;

				for (var i = startIndex; true; i = (i + 1 + dataPoints.length) % dataPoints.length) {
					dpEOs.push(dataPointEOs[i]);

					if (i === endIndex) break;
				}

				dpEOs.sort(function (entry1, entry2) {
					return entry1.y - entry2.y;
				});

				for (i = 0; i < dpEOs.length; i++) {
					var dpEO = dpEOs[i];

					if (totalRemovedLabelHeight < totalOverlap * .7) {
						totalRemovedLabelHeight += dpEO.indexLabelTextBlock.height;
						dpEO.indexLabelTextBlock.text = "";
						dpEO.indexLabelText = "";
						dpEO.indexLabelTextBlock.measureText();
					} else break;
				}
			}

			//resetAnimationFrame(1);
			//animate();
			//window.alert("next??");
			function skipLabels() {
				var overlapStartIndex = -1;
				var overlapEndIndex = -1;
				var totalOverlap = 0;
				var removeLabels = false;

				for (var k = 0; k < dataPoints.length; k++) {
					removeLabels = false;
					currentDataPoint = dataPointEOs[k];

					if (!currentDataPoint.indexLabelText) continue;

					var nextLabelIndex = getNextLabelIndex(k);
					if (nextLabelIndex === null) continue;

					var nextDataPoint = dataPointEOs[nextLabelIndex];

					distanceFromNextLabel = 0;

					//if (nextDataPoint.indexLabelTextBlock.y > currentDataPoint.indexLabelTextBlock.y)
					//	distanceFromNextLabel = (nextDataPoint.indexLabelTextBlock.y - (nextDataPoint.indexLabelTextBlock.height / 2)) - (currentDataPoint.indexLabelTextBlock.y + (currentDataPoint.indexLabelTextBlock.height / 2));
					//else
					//	distanceFromNextLabel = (currentDataPoint.indexLabelTextBlock.y - (currentDataPoint.indexLabelTextBlock.height / 2)) - (nextDataPoint.indexLabelTextBlock.y + (nextDataPoint.indexLabelTextBlock.height / 2));

					distanceFromNextLabel = getVerticalDistanceBetweenLabels(currentDataPoint, nextDataPoint);

					if (distanceFromNextLabel < 0 && areDataPointsTooClose(currentDataPoint, nextDataPoint)) {
						//if (distanceFromNextLabel < 0 && areDataPointsTooClose(currentDataPoint, nextDataPoint) ) {
						if (overlapStartIndex < 0) overlapStartIndex = k;

						if (nextLabelIndex !== overlapStartIndex) {
							overlapEndIndex = nextLabelIndex;

							totalOverlap += -distanceFromNextLabel;
						}

						if (k % Math.max(dataPoints.length / 10, 3) === 0) removeLabels = true;

						//nextDataPoint.indexLabelText = "";
						//nextDataPoint.indexLabelTextBlock.text = "";
						//nextDataPoint.indexLabelTextBlock.measureText();
					} else {

						removeLabels = true;
					}

					if (removeLabels) {

						if (totalOverlap > 0 && overlapStartIndex >= 0 && overlapEndIndex >= 0) {
							removeLabelsForSmallSegments(totalOverlap, overlapStartIndex, overlapEndIndex);

							overlapStartIndex = -1;
							overlapEndIndex = -1;
							totalOverlap = 0;
						}
					}
				}

				if (totalOverlap > 0) removeLabelsForSmallSegments(totalOverlap, overlapStartIndex, overlapEndIndex);
			}

			skipLabels();
		};

		for (j = 0; j < 10 && (j < 1 || deltaR > 0); j++) {
			var indexLabelRadius;
			var dataPointEO;
			var currentDataPoint, nextDataPoint;
			var dataPointEO;
			var nextDataPointIndex;
			var distanceFromNextLabel;
			var dataPointsAbove;
			var dataPointsBelow;
			var k;
			var upWardsOffset;
			var downWardsOffset;
			var actualUpwardOffset;
			var actualDownwardOffset;
			var dataPointEO;
			var dx;
			var dy;
			var size;
			var xOverflow;
			var xdr;
			var newIndexLabelMaxWidth;
			var yOverflow;
			var ydr;
			var positionMultiplier;

			_loop();
		}
		//window.alert("next??");


		//resetAnimationFrame(_this.animationEnabled && _this.renderCount === 0 ? isCanvasSupported ? 60 : 30 : 1);
		//animate();

		//console.log("totalRecursions: " + totalRecursions);
	}

	this.pieDoughnutClickHandler = function (e) {

		if (_this.isAnimating) {
			return;
		}

		var i = e.dataPointIndex;
		var dataPoint = e.dataPoint;
		var dataSeries = this;

		var id = dataSeries.dataPointIds[i];

		//dataPointEO = _this._eventManager.objectMap[id];

		if (dataPoint.exploded) dataPoint.exploded = false;else dataPoint.exploded = true;

		// So that it doesn't try to explode when there is only one segment
		if (dataSeries.dataPoints.length > 1) {
			_this._animator.animate(0, explodeDuration, function (fractionComplete) {

				explodeToggle(fractionComplete);
				renderChartElementsInPlotArea();
				//console.log("Explode Start");
			});
		}

		return;
	};

	initLabels();

	positionLabels();
	positionLabels();
	positionLabels();
	positionLabels();

	this.disableToolTip = true;
	this._animator.animate(0, this.animatedRender ? this.animationDuration : 0, function (fractionComplete) {

		animate(fractionComplete);
		renderChartElementsInPlotArea();
	}, function () {

		_this.disableToolTip = false;
		_this._animator.animate(0, _this.animatedRender ? explodeDuration : 0, function (fractionComplete) {

			explodeToggle(fractionComplete);
			renderChartElementsInPlotArea();
		});

		//console.log("Animation Complete");
	});

	function renderChartElementsInPlotArea() {

		_this.plotArea.layoutManager.reset();

		if (_this._title) {
			if (_this._title.dockInsidePlotArea || _this._title.horizontalAlign === "center" && _this._title.verticalAlign === "center") _this._title.render();
		}

		if (_this.subtitles) for (var i = 0; i < _this.subtitles.length; i++) {
			var subtitle = _this.subtitles[i];
			if (subtitle.dockInsidePlotArea || subtitle.horizontalAlign === "center" && subtitle.verticalAlign === "center") subtitle.render();
		}

		if (_this.legend) {
			if (_this.legend.dockInsidePlotArea || _this.legend.horizontalAlign === "center" && _this.legend.verticalAlign === "center") _this.legend.render();
		}
	}

	//this.ctx.strokeRect(plotArea.x1 + 1, plotArea.y1, plotArea.width - 2, plotArea.height);
};

var _text_block = require('../core/text_block');

var _text_block2 = _interopRequireDefault(_text_block);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

},{"../core/text_block":34,"../helpers/utils":39}],8:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;
	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var ghostCtx = this._eventManager.ghostCtx;

	var axisXProps = plotUnit.axisX.lineCoordinates;
	var axisYProps = plotUnit.axisY.lineCoordinates;
	var markers = [];

	var plotArea = this.plotArea;
	ctx.save();

	if (_utils.isCanvasSupported) ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		ghostCtx.beginPath();
		ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		ghostCtx.clip();
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var closingPath = [];

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];

		var dataPoints = dataSeries.dataPoints;

		var seriesId = dataSeries.id;
		this._eventManager.objectMap[seriesId] = {
			objectType: "dataSeries", dataSeriesIndex: dataSeriesIndex
		};

		var hexColor = intToHexColorString(seriesId);
		ghostCtx.fillStyle = hexColor;
		//ghostCtx.lineWidth = dataSeries.lineThickness;
		//ghostCtx.lineWidth = 20;

		markers = [];

		var isFirstDataPointInPlotArea = true;
		var i = 0,
		    x,
		    y1,
		    y2;
		var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number back and forth.

		var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;
		var baseY;

		var startPoint = null;

		if (dataPoints.length > 0) {
			//ctx.strokeStyle = "#4572A7 ";
			var color = dataSeries._colorSet[i % dataSeries._colorSet.length];
			//ctx.strokeStyle = "red";
			ctx.fillStyle = color;
			ctx.strokeStyle = color;
			ctx.lineWidth = dataSeries.lineThickness;

			if (ctx.setLineDash) {
				ctx.setLineDash(getLineDashArray(dataSeries.lineDashType, dataSeries.lineThickness));
			}

			var prevDataNull = true;
			for (; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].x.getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (dataPoints[i].y === null || !dataPoints[i].y.length || typeof dataPoints[i].y[0] !== "number" || typeof dataPoints[i].y[1] !== "number") {

					closeArea();

					prevDataNull = true;
					continue;
				}

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;

				y1 = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y[0] - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;
				y2 = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y[1] - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				if (isFirstDataPointInPlotArea || prevDataNull) {
					ctx.beginPath();
					ctx.moveTo(x, y1);
					startPoint = {
						x: x, y: y1
					};
					closingPath = [];
					closingPath.push({ x: x, y: y2 });

					if (_utils.isCanvasSupported) {
						ghostCtx.beginPath();
						ghostCtx.moveTo(x, y1);
					}

					isFirstDataPointInPlotArea = false;
					prevDataNull = false;
				} else {

					ctx.lineTo(x, y1);
					closingPath.push({ x: x, y: y2 });

					if (_utils.isCanvasSupported) ghostCtx.lineTo(x, y1);

					if (i % 250 == 0) {
						closeArea();
					}
				}

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x, y1: y1, y2: y2
				};

				//Render Marker
				if (dataPoints[i].markerSize !== 0) {
					if (dataPoints[i].markerSize > 0 || dataSeries.markerSize > 0) {
						var markerProps = dataSeries.getMarkerProperties(i, x, y2, ctx);
						markers.push(markerProps);

						//if (!dataSeries.maxWidthInX || markerProps.size > dataSeries.maxWidthInX) {
						//	dataSeries.maxWidthInX = markerProps.size / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);
						//}

						var markerColor = intToHexColorString(id);

						if (_utils.isCanvasSupported) {
							markers.push({
								x: x, y: y2, ctx: ghostCtx,
								type: markerProps.type,
								size: markerProps.size,
								color: markerColor,
								borderColor: markerColor,
								borderThickness: markerProps.borderThickness
							});
						}

						markerProps = dataSeries.getMarkerProperties(i, x, y1, ctx);
						markers.push(markerProps);

						var markerColor = intToHexColorString(id);

						if (_utils.isCanvasSupported) {
							markers.push({
								x: x, y: y1, ctx: ghostCtx,
								type: markerProps.type,
								size: markerProps.size,
								color: markerColor,
								borderColor: markerColor,
								borderThickness: markerProps.borderThickness
							});
						}
					}
				}

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "rangeArea",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						indexKeyword: 0,
						point: {
							x: x, y: y1
						},
						direction: dataPoints[i].y[0] <= dataPoints[i].y[1] ? -1 : 1,
						color: color
					});

					this._indexLabels.push({
						chartType: "rangeArea",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						indexKeyword: 1,
						point: {
							x: x, y: y2
						},
						direction: dataPoints[i].y[0] <= dataPoints[i].y[1] ? 1 : -1,
						color: color
					});
				}

				//alert("hi");
			}

			closeArea();

			//startPoint = { x: x, y: y };
			RenderHelper.drawMarkers(markers);
		}
	}

	ctx.restore();
	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	function closeArea() {

		if (!startPoint) return;

		var point = null;

		if (dataSeries.lineThickness > 0) ctx.stroke();

		for (var i = closingPath.length - 1; i >= 0; i--) {
			point = closingPath[i];
			ctx.lineTo(point.x, point.y);
			ghostCtx.lineTo(point.x, point.y);
		}

		ctx.closePath();
		//ctx.lineTo(startPoint.x, startPoint.y);

		ctx.globalAlpha = dataSeries.fillOpacity;
		ctx.fill();
		ctx.globalAlpha = 1;

		ghostCtx.fill();

		//if (isCanvasSupported) {
		//	ghostCtx.lineTo(x, baseY);
		//	ghostCtx.lineTo(startPoint.x, baseY);
		//	ghostCtx.closePath();
		//	ghostCtx.fill();
		//}

		if (dataSeries.lineThickness > 0) {
			ctx.beginPath();
			ctx.moveTo(point.x, point.y);
			for (var i = 0; i < closingPath.length; i++) {
				point = closingPath[i];
				ctx.lineTo(point.x, point.y);
			}

			ctx.stroke();
		}

		ctx.beginPath();
		ctx.moveTo(x, y1);
		ghostCtx.beginPath();
		ghostCtx.moveTo(x, y1);

		startPoint = {
			x: x, y: y1
		};
		closingPath = [];
		closingPath.push({ x: x, y: y2 });
	}

	//ctx.beginPath();
	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: AnimationHelper.xClipAnimation, easingFunction: AnimationHelper.easing.linear, animationBase: 0
	};
	return animationInfo;
};

var _utils = require("../helpers/utils");

},{"../helpers/utils":39}],9:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;
	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var color = null;

	var plotArea = this.plotArea;

	var i = 0,
	    x1,
	    x2,
	    y;
	var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number from dataTime everytime it is used.

	//In case of Bar Chart, yZeroToPixel is x co-ordinate!
	var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) << 0;

	var maxBarWidth = this.dataPointMaxWidth ? this.dataPointMaxWidth : Math.min(this.height * .15, this.plotArea.height / plotUnit.plotType.totalDataSeries * .9) << 0;
	var xMinDiff = plotUnit.axisX.dataInfo.minDiff;
	//var barWidth = (((plotArea.height / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum)) * Math.abs(xMinDiff)) / totalDataSeries * .9) << 0;

	var barWidth = plotArea.height / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum) * Math.abs(xMinDiff) / plotUnit.plotType.totalDataSeries * .9 << 0;

	if (barWidth > maxBarWidth) barWidth = maxBarWidth;else if (xMinDiff === Infinity) {
		barWidth = maxBarWidth / plotUnit.plotType.totalDataSeries * .9;
	} else if (barWidth < 1) barWidth = 1;

	ctx.save();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		this._eventManager.ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		this._eventManager.ghostCtx.clip();
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var isFirstDataPointInPlotArea = true;

		//dataSeries.maxWidthInX = barWidth / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);


		if (dataPoints.length > 0) {
			//var xy = this.getPixelCoordinatesOnPlotArea(dataPoints[0].x, dataPoints[0].y);

			var bevelEnabled = barWidth > 5 && dataSeries.bevelEnabled ? true : false;

			ctx.strokeStyle = "#4572A7 ";

			for (i = 0; i < dataPoints.length; i++) {

				dataPoints[i].getTime ? dataPointX = dataPoints[i].x.getTime() : dataPointX = dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (dataPoints[i].y === null || !dataPoints[i].y.length || typeof dataPoints[i].y[0] !== "number" || typeof dataPoints[i].y[1] !== "number") continue;

				//x and y are pixel co-ordinates of point and should not be confused with X and Y values
				x1 = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y[0] - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;
				x2 = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y[1] - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				y = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;

				var y1 = y - plotUnit.plotType.totalDataSeries * barWidth / 2 + (plotUnit.previousDataSeriesCount + j) * barWidth << 0;
				var y2 = y1 + barWidth << 0;

				if (x1 > x2) {
					var temp = x1;
					x1 = x2;
					x2 = temp;
				}

				//drawRect(ctx, x1, y1, plotArea.x2, y2, "#EEEEEE", 0, null, false, false, false, false);
				//drawRect(ctx, x1, y1, plotArea.x2, y2, "#BDCED3", 0, null, false, false, false, false);

				color = dataPoints[i].color ? dataPoints[i].color : dataSeries._colorSet[i % dataSeries._colorSet.length];
				//color = "#1B4962";
				drawRect(ctx, x1, y1, x2, y2, color, 0, null, bevelEnabled, false, false, false, dataSeries.fillOpacity);

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x1, y1: y1, x2: x2, y2: y2
				};
				color = intToHexColorString(id);

				if (_utils.isCanvasSupported) drawRect(this._eventManager.ghostCtx, x1, y1, x2, y2, color, 0, null, false, false, false, false);

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "rangeBar",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						indexKeyword: 0,
						point: {
							x: dataPoints[i].y[1] >= dataPoints[i].y[0] ? x1 : x2, y: y1 + (y2 - y1) / 2
						},
						direction: dataPoints[i].y[1] >= dataPoints[i].y[0] ? -1 : 1,
						bounds: {
							x1: Math.min(x1, x2), y1: y1, x2: Math.max(x1, x2), y2: y2
						},
						color: color
					});

					this._indexLabels.push({
						chartType: "rangeBar",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						indexKeyword: 1,
						point: {
							x: dataPoints[i].y[1] >= dataPoints[i].y[0] ? x2 : x1, y: y1 + (y2 - y1) / 2
						},
						direction: dataPoints[i].y[1] >= dataPoints[i].y[0] ? 1 : -1,
						bounds: {
							x1: Math.min(x1, x2), y1: y1, x2: Math.max(x1, x2), y2: y2
						},
						color: color
					});
				}
			}
		}
	}

	ctx.restore();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: AnimationHelper.fadeInAnimation, easingFunction: AnimationHelper.easing.easeInQuad, animationBase: 0
	};
	return animationInfo;
};

var _utils = require("../helpers/utils");

},{"../helpers/utils":39}],10:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;
	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var color = null;

	var plotArea = this.plotArea;

	var i = 0,
	    x,
	    y1,
	    y2;
	var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number from dataTime everytime it is used.

	var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) << 0;

	var maxBarWidth = this.dataPointMaxWidth ? this.dataPointMaxWidth : this.width * .03;
	//var maxBarWidth = (this.width * .015);
	var xMinDiff = plotUnit.axisX.dataInfo.minDiff;
	//var barWidth = (((plotArea.width / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum)) * Math.abs(xMinDiff)) * .9) << 0;
	var barWidth = plotArea.width / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum) * Math.abs(xMinDiff) / plotUnit.plotType.totalDataSeries * .9 << 0;

	if (barWidth > maxBarWidth) barWidth = maxBarWidth;else if (xMinDiff === Infinity) {
		barWidth = maxBarWidth / plotUnit.plotType.totalDataSeries * .9;
	} else if (barWidth < 1) barWidth = 1;

	ctx.save();
	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		this._eventManager.ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		this._eventManager.ghostCtx.clip();
	}
	//ctx.beginPath();

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var isFirstDataPointInPlotArea = true;

		// Reducing pixelPerUnit by 1 just to overcome any problems due to rounding off of pixels.
		//dataSeries.maxWidthInX = barWidth / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);

		//var offsetX = barWidth * plotUnit.index << 0;


		if (dataPoints.length > 0) {
			//var xy = this.getPixelCoordinatesOnPlotArea(dataPoints[0].x, dataPoints[0].y);

			var bevelEnabled = barWidth > 5 && dataSeries.bevelEnabled ? true : false;

			for (i = 0; i < dataPoints.length; i++) {

				dataPoints[i].getTime ? dataPointX = dataPoints[i].x.getTime() : dataPointX = dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (dataPoints[i].y === null || !dataPoints[i].y.length || typeof dataPoints[i].y[0] !== "number" || typeof dataPoints[i].y[1] !== "number") continue;

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				y1 = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y[0] - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;
				y2 = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y[1] - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				//var x1 = x - barWidth / 2 << 0;
				var x1 = x - plotUnit.plotType.totalDataSeries * barWidth / 2 + (plotUnit.previousDataSeriesCount + j) * barWidth << 0;
				var x2 = x1 + barWidth << 0;
				var y1;
				var y2;

				color = dataPoints[i].color ? dataPoints[i].color : dataSeries._colorSet[i % dataSeries._colorSet.length];

				if (y1 > y2) {
					var temp = y1;
					y1 = y2;
					y2 = temp;
				}

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x1, y1: y1, x2: x2, y2: y2
				};

				//var borderThickness = Math.max(1, (barWidth * .1 << 0));
				var borderThickness = 0;

				drawRect(ctx, x1, y1, x2, y2, color, borderThickness, color, bevelEnabled, bevelEnabled, false, false, dataSeries.fillOpacity);
				color = intToHexColorString(id);

				if (_utils.isCanvasSupported) drawRect(this._eventManager.ghostCtx, x1, y1, x2, y2, color, 0, null, false, false, false, false);

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "rangeColumn",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						indexKeyword: 0,
						point: {
							x: x1 + (x2 - x1) / 2, y: dataPoints[i].y[1] >= dataPoints[i].y[0] ? y2 : y1
						},
						direction: dataPoints[i].y[1] >= dataPoints[i].y[0] ? -1 : 1,
						bounds: {
							x1: x1, y1: Math.min(y1, y2), x2: x2, y2: Math.max(y1, y2)
						},
						color: color
					});

					this._indexLabels.push({
						chartType: "rangeColumn",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						indexKeyword: 1,
						point: {
							x: x1 + (x2 - x1) / 2, y: dataPoints[i].y[1] >= dataPoints[i].y[0] ? y1 : y2
						},
						direction: dataPoints[i].y[1] >= dataPoints[i].y[0] ? 1 : -1,
						bounds: {
							x1: x1, y1: Math.min(y1, y2), x2: x2, y2: Math.max(y1, y2)
						},
						color: color
					});
				}
			}
		}
	}

	ctx.restore();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: AnimationHelper.fadeInAnimation, easingFunction: AnimationHelper.easing.easeInQuad, animationBase: 0
	};
	return animationInfo;
};

var _utils = require("../helpers/utils");

},{"../helpers/utils":39}],11:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;
	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var ghostCtx = this._eventManager.ghostCtx;

	var axisXProps = plotUnit.axisX.lineCoordinates;
	var axisYProps = plotUnit.axisY.lineCoordinates;
	var markers = [];

	var plotArea = this.plotArea;
	ctx.save();

	if (_utils.isCanvasSupported) ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		ghostCtx.beginPath();
		ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		ghostCtx.clip();
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];

		var dataPoints = dataSeries.dataPoints;

		var seriesId = dataSeries.id;
		this._eventManager.objectMap[seriesId] = {
			objectType: "dataSeries", dataSeriesIndex: dataSeriesIndex
		};

		var hexColor = intToHexColorString(seriesId);
		ghostCtx.fillStyle = hexColor;
		//ghostCtx.lineWidth = dataSeries.lineThickness;
		//ghostCtx.lineWidth = 20;

		markers = [];

		var isFirstDataPointInPlotArea = true;
		var i = 0,
		    x,
		    y1,
		    y2;
		var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number back and forth.

		var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;
		var baseY;

		var startPoint = null;

		var pixelsY1 = [];
		var pixelsY2 = [];

		if (dataPoints.length > 0) {
			//ctx.strokeStyle = "#4572A7 ";
			color = dataSeries._colorSet[i % dataSeries._colorSet.length];
			//ctx.strokeStyle = "red";
			ctx.fillStyle = color;
			ctx.strokeStyle = color;
			ctx.lineWidth = dataSeries.lineThickness;

			if (ctx.setLineDash) {
				ctx.setLineDash(getLineDashArray(dataSeries.lineDashType, dataSeries.lineThickness));
			}

			for (; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].x.getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (dataPoints[i].y === null || !dataPoints[i].y.length || typeof dataPoints[i].y[0] !== "number" || typeof dataPoints[i].y[1] !== "number") {
					if (i > 0) {
						renderBezierArea();
						pixelsY1 = [];
						pixelsY2 = [];
					}
					continue;
				}

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				y1 = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y[0] - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;
				y2 = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y[1] - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x, y1: y1, y2: y2
				};

				pixelsY1[pixelsY1.length] = {
					x: x, y: y1
				};
				pixelsY2[pixelsY2.length] = {
					x: x, y: y2
				};

				//Render Marker
				if (dataPoints[i].markerSize !== 0) {
					if (dataPoints[i].markerSize > 0 || dataSeries.markerSize > 0) {
						var markerProps = dataSeries.getMarkerProperties(i, x, y1, ctx);
						markers.push(markerProps);

						//if (!dataSeries.maxWidthInX || markerProps.size > dataSeries.maxWidthInX) {
						//	dataSeries.maxWidthInX = markerProps.size / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);
						//}

						var markerColor = intToHexColorString(id);

						if (_utils.isCanvasSupported) {
							markers.push({
								x: x, y: y1, ctx: ghostCtx,
								type: markerProps.type,
								size: markerProps.size,
								color: markerColor,
								borderColor: markerColor,
								borderThickness: markerProps.borderThickness
							});
						}

						var markerProps = dataSeries.getMarkerProperties(i, x, y2, ctx);
						markers.push(markerProps);

						//if (!dataSeries.maxWidthInX || markerProps.size > dataSeries.maxWidthInX) {
						//	dataSeries.maxWidthInX = markerProps.size / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);
						//}

						var markerColor = intToHexColorString(id);

						if (_utils.isCanvasSupported) {
							markers.push({
								x: x, y: y2, ctx: ghostCtx,
								type: markerProps.type,
								size: markerProps.size,
								color: markerColor,
								borderColor: markerColor,
								borderThickness: markerProps.borderThickness
							});
						}
					}
				}

				//Render Index Labels
				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "splineArea",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						indexKeyword: 0,
						point: {
							x: x, y: y1
						},
						direction: dataPoints[i].y[0] <= dataPoints[i].y[1] ? -1 : 1,
						color: color
					});

					this._indexLabels.push({
						chartType: "splineArea",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						indexKeyword: 1,
						point: {
							x: x, y: y2
						},
						direction: dataPoints[i].y[0] <= dataPoints[i].y[1] ? 1 : -1,
						color: color
					});
				}
			}

			renderBezierArea();

			RenderHelper.drawMarkers(markers);
		}
	}

	ctx.restore();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	function renderBezierArea() {
		var bp = getBezierPoints(pixelsY1, 2);

		if (bp.length > 0) {
			ctx.beginPath();
			ctx.moveTo(bp[0].x, bp[0].y);

			if (_utils.isCanvasSupported) {
				ghostCtx.beginPath();
				ghostCtx.moveTo(bp[0].x, bp[0].y);
			}

			for (var i = 0; i < bp.length - 3; i += 3) {

				ctx.bezierCurveTo(bp[i + 1].x, bp[i + 1].y, bp[i + 2].x, bp[i + 2].y, bp[i + 3].x, bp[i + 3].y);

				if (_utils.isCanvasSupported) ghostCtx.bezierCurveTo(bp[i + 1].x, bp[i + 1].y, bp[i + 2].x, bp[i + 2].y, bp[i + 3].x, bp[i + 3].y);
			}

			if (dataSeries.lineThickness > 0) ctx.stroke();

			bp = getBezierPoints(pixelsY2, 2);

			ctx.lineTo(pixelsY2[pixelsY2.length - 1].x, pixelsY2[pixelsY2.length - 1].y);

			for (var i = bp.length - 1; i > 2; i -= 3) {

				ctx.bezierCurveTo(bp[i - 1].x, bp[i - 1].y, bp[i - 2].x, bp[i - 2].y, bp[i - 3].x, bp[i - 3].y);

				if (_utils.isCanvasSupported) ghostCtx.bezierCurveTo(bp[i - 1].x, bp[i - 1].y, bp[i - 2].x, bp[i - 2].y, bp[i - 3].x, bp[i - 3].y);
			}

			ctx.closePath();

			ctx.globalAlpha = dataSeries.fillOpacity;
			ctx.fill();
			ctx.globalAlpha = 1;

			if (dataSeries.lineThickness > 0) {
				ctx.beginPath();
				ctx.moveTo(pixelsY2[pixelsY2.length - 1].x, pixelsY2[pixelsY2.length - 1].y);

				for (var i = bp.length - 1; i > 2; i -= 3) {

					ctx.bezierCurveTo(bp[i - 1].x, bp[i - 1].y, bp[i - 2].x, bp[i - 2].y, bp[i - 3].x, bp[i - 3].y);

					if (_utils.isCanvasSupported) ghostCtx.bezierCurveTo(bp[i - 1].x, bp[i - 1].y, bp[i - 2].x, bp[i - 2].y, bp[i - 3].x, bp[i - 3].y);
				}
				ctx.stroke();
			}

			ctx.beginPath();

			if (_utils.isCanvasSupported) {
				ghostCtx.closePath();
				ghostCtx.fill();
			}
		}
	}

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: AnimationHelper.xClipAnimation, easingFunction: AnimationHelper.easing.linear, animationBase: 0
	};
	return animationInfo;
};

var _utils = require("../helpers/utils");

//#region pieChart

var drawSegment = function drawSegment(ctx, center, radius, color, type, theta1, theta2, fillOpacity, percentInnerRadius) {

	if (typeof fillOpacity === "undefined") fillOpacity = 1;

	//IE8- FIX: In IE8- segment doesn't get draw if theta2 is equal to theta1 + 2*PI.
	if (!_utils.isCanvasSupported) {
		var theta2Mod = Number((theta2 % (2 * Math.PI)).toFixed(8));
		var theta1Mod = Number((theta1 % (2 * Math.PI)).toFixed(8));
		if (theta1Mod === theta2Mod) theta2 -= .0001;
	}

	ctx.save();
	ctx.globalAlpha = fillOpacity;

	if (type === "pie") {
		ctx.beginPath();
		ctx.moveTo(center.x, center.y);
		ctx.arc(center.x, center.y, radius, theta1, theta2, false);
		ctx.fillStyle = color;
		ctx.strokeStyle = "white";
		ctx.lineWidth = 2;
		//    ctx.shadowOffsetX = 2;
		//    ctx.shadowOffsetY = 1;
		//     ctx.shadowBlur = 2;
		//    ctx.shadowColor = '#BFBFBF';
		ctx.closePath();
		//ctx.stroke();
		ctx.fill();
	} else if (type === "doughnut") {
		ctx.beginPath();
		ctx.arc(center.x, center.y, radius, theta1, theta2, false);
		ctx.arc(center.x, center.y, percentInnerRadius * radius, theta2, theta1, true);
		ctx.closePath();
		ctx.fillStyle = color;
		ctx.strokeStyle = "white";
		ctx.lineWidth = 2;
		// shadow properties
		//     ctx.shadowOffsetX = 1;
		//    ctx.shadowOffsetY = 1;
		//     ctx.shadowBlur = 1;
		//    ctx.shadowColor = '#BFBFBF';  //grey shadow
		//ctx.stroke();
		ctx.fill();
	}

	ctx.globalAlpha = 1;

	ctx.restore();
};

},{"../helpers/utils":39}],12:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;
	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var color = null;

	var plotArea = this.plotArea;

	var i = 0,
	    x,
	    y;
	var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number from dataTime everytime it is used.

	var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) << 0;

	var maxBarWidth = this.dataPointMaxWidth ? this.dataPointMaxWidth : this.width * .15 << 0;
	var xMinDiff = plotUnit.axisX.dataInfo.minDiff;
	var barWidth = plotArea.width / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum) * Math.abs(xMinDiff) / totalDataSeries * .9 << 0;

	ctx.save();
	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		this._eventManager.ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		this._eventManager.ghostCtx.clip();
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var isFirstDataPointInPlotArea = true;

		if (dataPoints.length == 1) barWidth = maxBarWidth;

		if (barWidth < 1) barWidth = 1;else if (barWidth > maxBarWidth) barWidth = maxBarWidth;

		if (dataPoints.length > 0) {
			//var bevelEnabled = (barWidth > 5) ? false : false;

			ctx.strokeStyle = "#4572A7 ";

			var maxArea = Math.pow(Math.min(plotArea.height, plotArea.width) * .3 / 2, 2) * Math.PI;

			var prevDataPointX = 0;
			var prevDataPointY = 0;

			for (var i = 0; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].getTime ? dataPointX = dataPoints[i].x.getTime() : dataPointX = dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (typeof dataPoints[i].y !== "number") continue;

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				y = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				var markerProps = dataSeries.getMarkerProperties(i, x, y, ctx);

				ctx.globalAlpha = dataSeries.fillOpacity;
				_render2.default.drawMarker(markerProps.x, markerProps.y, markerProps.ctx, markerProps.type, markerProps.size, markerProps.color, markerProps.borderColor, markerProps.borderThickness);
				ctx.globalAlpha = 1;

				//if (Math.abs(prevDataPointX - x) < markerProps.size / 2 && Math.abs(prevDataPointY - y) < markerProps.size / 2) {
				//    continue;
				//}

				//if (!dataSeries.maxWidthInX || markerProps.size > dataSeries.maxWidthInX) {
				//	dataSeries.maxWidthInX = markerProps.size / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);
				//}

				if (Math.sqrt((prevDataPointX - x) * (prevDataPointX - x) + (prevDataPointY - y) * (prevDataPointY - y)) < Math.min(markerProps.size, 5) && dataPoints.length > Math.min(this.plotArea.width, this.plotArea.height)) {
					continue;
				}

				//Render ID on Ghost Canvas - for event handling
				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x, y1: y
				};
				var markerColor = (0, _utils.intToHexColorString)(id);

				if (_utils.isCanvasSupported) {
					_render2.default.drawMarker(markerProps.x, markerProps.y, this._eventManager.ghostCtx, markerProps.type, markerProps.size, markerColor, markerColor, markerProps.borderThickness);
				}
				//markers.push();

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "scatter",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						point: {
							x: x, y: y
						},
						direction: 1,
						bounds: {
							x1: x - markerProps.size / 2, y1: y - markerProps.size / 2, x2: x + markerProps.size / 2, y2: y + markerProps.size / 2
						},
						color: color
					});
				}

				prevDataPointX = x;
				prevDataPointY = y;
			}
		}
	}

	ctx.restore();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: _animator2.default.fadeInAnimation, easingFunction: _animator2.default.easing.easeInQuad, animationBase: 0
	};
	return animationInfo;
};

var _render = require('../helpers/render');

var _render2 = _interopRequireDefault(_render);

var _animator = require('../helpers/animator');

var _animator2 = _interopRequireDefault(_animator);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

},{"../helpers/animator":37,"../helpers/render":38,"../helpers/utils":39}],13:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;

	var totalDataSeries = plotUnit.dataSeriesIndexes.length;
	if (totalDataSeries <= 0) return;

	var ghostCtx = this._eventManager.ghostCtx;

	ctx.save();

	var plotArea = this.plotArea;

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	var markers = [];

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		ctx.lineWidth = dataSeries.lineThickness;
		var dataPoints = dataSeries.dataPoints;

		if (ctx.setLineDash) {
			ctx.setLineDash(getLineDashArray(dataSeries.lineDashType, dataSeries.lineThickness));
		}

		var seriesId = dataSeries.id;
		this._eventManager.objectMap[seriesId] = {
			objectType: "dataSeries", dataSeriesIndex: dataSeriesIndex
		};
		var hexColor = intToHexColorString(seriesId);
		ghostCtx.strokeStyle = hexColor;
		//ghostCtx.lineWidth = dataSeries.lineThickness;
		ghostCtx.lineWidth = dataSeries.lineThickness > 0 ? Math.max(dataSeries.lineThickness, 4) : 0;

		var colorSet = dataSeries._colorSet;
		var color = colorSet[0];
		ctx.strokeStyle = color;

		var isFirstDataPointInPlotArea = true;
		var i = 0,
		    x,
		    y;
		var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number back and forth.

		//if (!dataSeries._options.markerSize && dataSeries.dataPoints.length < 1000)
		//    dataSeries.markerSize = 8;

		var pixels = [];

		ctx.beginPath();
		if (dataPoints.length > 0) {

			for (i = 0; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) continue;

				//if (!isFinite(dataPoints[i].y))
				//    continue;

				if (typeof dataPoints[i].y !== "number") {
					if (i > 0) {
						// if first dataPoint is null then no need to call stroke method
						renderBezier(pixels);
						pixels = [];
					}

					continue;
				}

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				y = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x, y1: y
				};

				pixels[pixels.length] = {
					x: x, y: y
				};

				//Add Markers
				if (dataPoints[i].markerSize > 0 || dataSeries.markerSize > 0) {

					var markerProps = dataSeries.getMarkerProperties(i, x, y, ctx);
					markers.push(markerProps);

					//if (!dataSeries.maxWidthInX || markerProps.size > dataSeries.maxWidthInX) {
					//	dataSeries.maxWidthInX = markerProps.size / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);
					//}

					var markerColor = intToHexColorString(id);

					//window.console.log("index: " + i + "; id: " + id + "; hex: " + markerColor);
					if (_utils.isCanvasSupported) {
						markers.push({
							x: x, y: y, ctx: ghostCtx,
							type: markerProps.type,
							size: markerProps.size,
							color: markerColor,
							borderColor: markerColor,
							borderThickness: markerProps.borderThickness
						});
					}
				}

				//Add Labels
				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "spline",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						point: {
							x: x, y: y
						},
						direction: dataPoints[i].y >= 0 ? 1 : -1,
						color: color
					});
				}
			}
		}

		renderBezier(pixels);
	}

	RenderHelper.drawMarkers(markers);
	ctx.restore();

	ctx.beginPath();

	if (_utils.isCanvasSupported) ghostCtx.beginPath();

	function renderBezier(pixels) {

		var bp = getBezierPoints(pixels, 2);

		if (bp.length > 0) {
			ctx.beginPath();
			if (_utils.isCanvasSupported) ghostCtx.beginPath();

			ctx.moveTo(bp[0].x, bp[0].y);
			if (_utils.isCanvasSupported) ghostCtx.moveTo(bp[0].x, bp[0].y);

			for (var i = 0; i < bp.length - 3; i += 3) {

				ctx.bezierCurveTo(bp[i + 1].x, bp[i + 1].y, bp[i + 2].x, bp[i + 2].y, bp[i + 3].x, bp[i + 3].y);

				if (_utils.isCanvasSupported) ghostCtx.bezierCurveTo(bp[i + 1].x, bp[i + 1].y, bp[i + 2].x, bp[i + 2].y, bp[i + 3].x, bp[i + 3].y);

				if (i > 0 && i % 3000 === 0) {
					ctx.stroke();
					ctx.beginPath();
					ctx.moveTo(bp[i + 3].x, bp[i + 3].y);

					if (_utils.isCanvasSupported) {
						ghostCtx.stroke();
						ghostCtx.beginPath();
						ghostCtx.moveTo(bp[i + 3].x, bp[i + 3].y);
					}
				}
			}

			ctx.stroke();

			if (_utils.isCanvasSupported) ghostCtx.stroke();
		}
	}

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: AnimationHelper.xClipAnimation, easingFunction: AnimationHelper.easing.linear, animationBase: 0
	};
	return animationInfo;
};

var _utils = require("../helpers/utils");

var drawRect = function drawRect(ctx, x1, y1, x2, y2, color, borderThickness, borderColor, top, bottom, left, right, fillOpacity) {
	if (typeof fillOpacity === "undefined") fillOpacity = 1;

	borderThickness = borderThickness || 0;
	borderColor = borderColor || "black";
	//alert("top"+ top + "bottom" + bottom + " lt" + left+ "rt" + right )
	var a1 = x1,
	    a2 = x2,
	    b1 = y1,
	    b2 = y2,
	    edgeY,
	    edgeX;
	if (x2 - x1 > 15 && y2 - y1 > 15) var bevelDepth = 8;else var bevelDepth = 0.35 * Math.min(x2 - x1, y2 - y1);
	//alert(a1 + "" + a2);
	var color2 = "rgba(255, 255, 255, .4)";
	var color3 = "rgba(255, 255, 255, 0.1)";
	//color1 = "rgba(" + r + "," + g + ", " + b + ",1)";
	var color1 = color;

	ctx.beginPath();
	ctx.moveTo(x1, y1);
	ctx.save();
	ctx.fillStyle = color1;

	ctx.globalAlpha = fillOpacity;
	ctx.fillRect(x1, y1, x2 - x1, y2 - y1);
	ctx.globalAlpha = 1;

	if (borderThickness > 0) {
		var offset = borderThickness % 2 === 0 ? 0 : .5;
		ctx.beginPath();
		ctx.lineWidth = borderThickness;
		ctx.strokeStyle = borderColor;
		ctx.moveTo(x1, y1);
		ctx.rect(x1 - offset, y1 - offset, x2 - x1 + 2 * offset, y2 - y1 + 2 * offset);
		ctx.stroke();
	}

	ctx.restore();
	//   ctx.beginPath();
	if (top === true) {
		// alert(x1 + "" + x2 + " " + bevelDepth);
		ctx.save();
		ctx.beginPath();
		ctx.moveTo(x1, y1);
		ctx.lineTo(x1 + bevelDepth, y1 + bevelDepth);
		ctx.lineTo(x2 - bevelDepth, y1 + bevelDepth);
		ctx.lineTo(x2, y1);
		ctx.closePath();
		var grd = ctx.createLinearGradient((x2 + x1) / 2, b1 + bevelDepth, (x2 + x1) / 2, b1);
		grd.addColorStop(0, color1);
		grd.addColorStop(1, color2);
		ctx.fillStyle = grd;
		ctx.fill();
		//              ctx.stroke();
		ctx.restore();
	}

	if (bottom === true) {
		ctx.save();
		ctx.beginPath();
		ctx.moveTo(x1, y2);
		ctx.lineTo(x1 + bevelDepth, y2 - bevelDepth);
		ctx.lineTo(x2 - bevelDepth, y2 - bevelDepth);
		ctx.lineTo(x2, y2);
		ctx.closePath();
		var grd = ctx.createLinearGradient((x2 + x1) / 2, b2 - bevelDepth, (x2 + x1) / 2, b2);
		grd.addColorStop(0, color1);
		grd.addColorStop(1, color2);
		ctx.fillStyle = grd;
		//       ctx.stroke();
		ctx.fill();
		ctx.restore();
	}

	if (left === true) {
		//   alert(x1)
		ctx.save();
		ctx.beginPath();
		ctx.moveTo(x1, y1);
		ctx.lineTo(x1 + bevelDepth, y1 + bevelDepth);
		ctx.lineTo(x1 + bevelDepth, y2 - bevelDepth);
		ctx.lineTo(x1, y2);
		ctx.closePath();
		var grd = ctx.createLinearGradient(a1 + bevelDepth, (y2 + y1) / 2, a1, (y2 + y1) / 2);
		grd.addColorStop(0, color1);
		grd.addColorStop(1, color3);
		ctx.fillStyle = grd;
		ctx.fill();
		//     ctx.stroke();
		ctx.restore();
	}

	if (right === true) {
		ctx.save();
		ctx.beginPath();
		ctx.moveTo(x2, y1);
		ctx.lineTo(x2 - bevelDepth, y1 + bevelDepth);
		ctx.lineTo(x2 - bevelDepth, y2 - bevelDepth);
		ctx.lineTo(x2, y2);
		var grd = ctx.createLinearGradient(a2 - bevelDepth, (y2 + y1) / 2, a2, (y2 + y1) / 2);
		grd.addColorStop(0, color1);
		grd.addColorStop(1, color3);
		ctx.fillStyle = grd;
		grd.addColorStop(0, color1);
		grd.addColorStop(1, color3);
		ctx.fillStyle = grd;
		ctx.fill();
		ctx.closePath();
		//          ctx.stroke();
		ctx.restore();
	}
	//
};

},{"../helpers/utils":39}],14:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;

	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var ghostCtx = this._eventManager.ghostCtx;

	var axisXProps = plotUnit.axisX.lineCoordinates;
	var axisYProps = plotUnit.axisY.lineCoordinates;
	var markers = [];

	var plotArea = this.plotArea;
	ctx.save();

	if (_utils.isCanvasSupported) ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		ghostCtx.beginPath();
		ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		ghostCtx.clip();
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];

		var dataPoints = dataSeries.dataPoints;

		var seriesId = dataSeries.id;
		this._eventManager.objectMap[seriesId] = {
			objectType: "dataSeries", dataSeriesIndex: dataSeriesIndex
		};

		var hexColor = intToHexColorString(seriesId);
		ghostCtx.fillStyle = hexColor;
		//ghostCtx.lineWidth = dataSeries.lineThickness;
		//ghostCtx.lineWidth = 20;

		markers = [];

		var isFirstDataPointInPlotArea = true;
		var i = 0,
		    x,
		    y;
		var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number back and forth.

		var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;
		var baseY;

		var startPoint = null;

		var pixels = [];

		if (dataPoints.length > 0) {
			//ctx.strokeStyle = "#4572A7 ";
			color = dataSeries._colorSet[i % dataSeries._colorSet.length];
			ctx.fillStyle = color;
			ctx.strokeStyle = color;
			ctx.lineWidth = dataSeries.lineThickness;

			if (ctx.setLineDash) {
				ctx.setLineDash(getLineDashArray(dataSeries.lineDashType, dataSeries.lineThickness));
			}

			for (; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].x.getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (typeof dataPoints[i].y !== "number") {
					if (i > 0) {
						renderBezierArea();
						pixels = [];
					}
					continue;
				}

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				y = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x, y1: y
				};

				pixels[pixels.length] = {
					x: x, y: y
				};

				//Render Marker
				if (dataPoints[i].markerSize !== 0) {
					if (dataPoints[i].markerSize > 0 || dataSeries.markerSize > 0) {
						var markerProps = dataSeries.getMarkerProperties(i, x, y, ctx);
						markers.push(markerProps);

						//if (!dataSeries.maxWidthInX || markerProps.size > dataSeries.maxWidthInX) {
						//	dataSeries.maxWidthInX = markerProps.size / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);
						//}

						var markerColor = intToHexColorString(id);

						if (_utils.isCanvasSupported) {
							markers.push({
								x: x, y: y, ctx: ghostCtx,
								type: markerProps.type,
								size: markerProps.size,
								color: markerColor,
								borderColor: markerColor,
								borderThickness: markerProps.borderThickness
							});
						}
					}
				}

				//Render Index Labels
				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "splineArea",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						point: {
							x: x, y: y
						},
						direction: dataPoints[i].y >= 0 ? 1 : -1,
						color: color
					});
				}
			}

			renderBezierArea();

			RenderHelper.drawMarkers(markers);
		}
	}

	ctx.restore();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	function renderBezierArea() {
		var bp = getBezierPoints(pixels, 2);

		if (bp.length > 0) {
			ctx.beginPath();
			ctx.moveTo(bp[0].x, bp[0].y);

			if (_utils.isCanvasSupported) {
				ghostCtx.beginPath();
				ghostCtx.moveTo(bp[0].x, bp[0].y);
			}

			for (var i = 0; i < bp.length - 3; i += 3) {

				ctx.bezierCurveTo(bp[i + 1].x, bp[i + 1].y, bp[i + 2].x, bp[i + 2].y, bp[i + 3].x, bp[i + 3].y);

				if (_utils.isCanvasSupported) ghostCtx.bezierCurveTo(bp[i + 1].x, bp[i + 1].y, bp[i + 2].x, bp[i + 2].y, bp[i + 3].x, bp[i + 3].y);
			}

			if (dataSeries.lineThickness > 0) ctx.stroke();

			if (plotUnit.axisY.viewportMinimum <= 0 && plotUnit.axisY.viewportMaximum >= 0) {
				baseY = yZeroToPixel;
			} else if (plotUnit.axisY.viewportMaximum < 0) baseY = axisYProps.y1;else if (plotUnit.axisY.viewportMinimum > 0) baseY = axisXProps.y2;

			startPoint = {
				x: bp[0].x, y: bp[0].y
			};

			ctx.lineTo(bp[bp.length - 1].x, baseY);
			ctx.lineTo(startPoint.x, baseY);
			ctx.closePath();

			ctx.globalAlpha = dataSeries.fillOpacity;
			ctx.fill();
			ctx.globalAlpha = 1;

			if (_utils.isCanvasSupported) {
				ghostCtx.lineTo(bp[bp.length - 1].x, baseY);
				ghostCtx.lineTo(startPoint.x, baseY);
				ghostCtx.closePath();
				ghostCtx.fill();
			}
		}
	}

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: AnimationHelper.xClipAnimation, easingFunction: AnimationHelper.easing.linear, animationBase: 0
	};
	return animationInfo;
};

var _utils = require("../helpers/utils");

},{"../helpers/utils":39}],15:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;

	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var color = null;
	var markers = [];

	var plotArea = this.plotArea;

	var offsetY = [];

	var allXValues = [];
	//var offsetNegativeY = [];

	var i = 0,
	    x,
	    y;
	var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number everytime it is accessed.

	//var yZeroToPixel = (axisYProps.y2 - axisYProps.height / rangeY * Math.abs(0 - plotUnit.axisY.viewportMinimum) + .5) << 0;
	var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) << 0;

	var xMinDiff = plotUnit.axisX.dataInfo.minDiff;

	var ghostCtx = this._eventManager.ghostCtx;

	if (_utils.isCanvasSupported) ghostCtx.beginPath();

	ctx.save();

	if (_utils.isCanvasSupported) ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		ghostCtx.beginPath();
		ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		ghostCtx.clip();
	}

	var xValuePresent = [];
	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];
		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var xValue;

		dataSeries.dataPointIndexes = [];

		for (i = 0; i < dataPoints.length; i++) {
			xValue = dataPoints[i].x.getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;
			dataSeries.dataPointIndexes[xValue] = i;

			if (!xValuePresent[xValue]) {
				allXValues.push(xValue);
				xValuePresent[xValue] = true;
			}
		}

		allXValues.sort(_utils.compareNumbers);
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var isFirstDataPointInPlotArea = true;

		var currentBaseValues = [];

		var seriesId = dataSeries.id;
		this._eventManager.objectMap[seriesId] = {
			objectType: "dataSeries", dataSeriesIndex: dataSeriesIndex
		};
		var hexColor = (0, _utils.intToHexColorString)(seriesId);
		ghostCtx.fillStyle = hexColor;

		if (allXValues.length > 0) {

			color = dataSeries._colorSet[0];
			//ctx.strokeStyle = "red";
			ctx.fillStyle = color;
			ctx.strokeStyle = color;
			ctx.lineWidth = dataSeries.lineThickness;

			if (ctx.setLineDash) {
				ctx.setLineDash((0, _utils.getLineDashArray)(dataSeries.lineDashType, dataSeries.lineThickness));
			}

			for (i = 0; i < allXValues.length; i++) {

				dataPointX = allXValues[i];
				var dataPoint = null;

				if (dataSeries.dataPointIndexes[dataPointX] >= 0) dataPoint = dataPoints[dataSeries.dataPointIndexes[dataPointX]];else dataPoint = {
					x: dataPointX, y: 0
				};

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (typeof dataPoint.y !== "number") continue;

				var x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				//var y = (plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoint.y - plotUnit.axisY.conversionParameters.minimum) + .5) << 0;
				var y = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoint.y - plotUnit.axisY.conversionParameters.minimum);

				var offset = offsetY[dataPointX] ? offsetY[dataPointX] : 0;

				y = y - offset;
				currentBaseValues.push({ x: x, y: yZeroToPixel - offset });
				offsetY[dataPointX] = yZeroToPixel - y;

				if (isFirstDataPointInPlotArea) {
					ctx.beginPath();
					ctx.moveTo(x, y);

					if (_utils.isCanvasSupported) {
						ghostCtx.beginPath();
						ghostCtx.moveTo(x, y);
					}

					isFirstDataPointInPlotArea = false;
				} else {

					ctx.lineTo(x, y);

					if (_utils.isCanvasSupported) ghostCtx.lineTo(x, y);

					if (i % 250 == 0) {

						if (dataSeries.lineThickness > 0) ctx.stroke();

						while (currentBaseValues.length > 0) {
							var point = currentBaseValues.pop();
							ctx.lineTo(point.x, point.y);

							if (_utils.isCanvasSupported) ghostCtx.lineTo(point.x, point.y);
						}

						ctx.closePath();

						ctx.globalAlpha = dataSeries.fillOpacity;
						ctx.fill();
						ctx.globalAlpha = 1;

						ctx.beginPath();
						ctx.moveTo(x, y);

						if (_utils.isCanvasSupported) {
							ghostCtx.closePath();
							ghostCtx.fill();

							ghostCtx.beginPath();
							ghostCtx.moveTo(x, y);
						}

						currentBaseValues.push({ x: x, y: yZeroToPixel - offset });
					}
				}

				if (dataSeries.dataPointIndexes[dataPointX] >= 0) {
					var id = dataSeries.dataPointIds[dataSeries.dataPointIndexes[dataPointX]];
					this._eventManager.objectMap[id] = {
						id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: dataSeries.dataPointIndexes[dataPointX], x1: x, y1: y
					};
				}

				//Render Marker
				if (dataSeries.dataPointIndexes[dataPointX] >= 0 && dataPoint.markerSize !== 0) {
					if (dataPoint.markerSize > 0 || dataSeries.markerSize > 0) {

						var markerProps = dataSeries.getMarkerProperties(i, x, y, ctx);
						markers.push(markerProps);

						//if (!dataSeries.maxWidthInX || markerProps.size > dataSeries.maxWidthInX) {
						//	dataSeries.maxWidthInX = markerProps.size / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);
						//}

						markerColor = (0, _utils.intToHexColorString)(id);

						if (_utils.isCanvasSupported) {
							markers.push({
								x: x, y: y, ctx: ghostCtx,
								type: markerProps.type,
								size: markerProps.size,
								color: markerColor,
								borderColor: markerColor,
								borderThickness: markerProps.borderThickness
							});
						}
					}
				}

				if (dataPoint.indexLabel || dataSeries.indexLabel || dataPoint.indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "stackedArea",
						dataPoint: dataPoint,
						dataSeries: dataSeries,
						point: {
							x: x, y: y
						},
						direction: dataPoints[i].y >= 0 ? 1 : -1,
						color: color
					});
				}
			}

			if (dataSeries.lineThickness > 0) ctx.stroke();

			while (currentBaseValues.length > 0) {
				var point = currentBaseValues.pop();
				ctx.lineTo(point.x, point.y);

				if (_utils.isCanvasSupported) ghostCtx.lineTo(point.x, point.y);
			}

			ctx.closePath();

			ctx.globalAlpha = dataSeries.fillOpacity;
			ctx.fill();
			ctx.globalAlpha = 1;

			ctx.beginPath();
			ctx.moveTo(x, y);

			if (_utils.isCanvasSupported) {
				ghostCtx.closePath();
				ghostCtx.fill();
				ghostCtx.beginPath();
				ghostCtx.moveTo(x, y);
			}
		}

		delete dataSeries.dataPointIndexes;
	}

	_render2.default.drawMarkers(markers);

	ctx.restore();

	if (_utils.isCanvasSupported) ghostCtx.restore();

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: _animator2.default.xClipAnimation, easingFunction: _animator2.default.easing.linear, animationBase: 0
	};
	return animationInfo;
};

var _render = require('../helpers/render');

var _render2 = _interopRequireDefault(_render);

var _animator = require('../helpers/animator');

var _animator2 = _interopRequireDefault(_animator);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

},{"../helpers/animator":37,"../helpers/render":38,"../helpers/utils":39}],16:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;

	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var color = null;

	var plotArea = this.plotArea;
	var markers = [];

	var offsetY = [];

	var allXValues = [];
	//var offsetNegativeY = [];

	var i = 0,
	    x,
	    y;
	var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number everytime it is accessed.


	//var yZeroToPixel = (axisYProps.y2 - axisYProps.height / rangeY * Math.abs(0 - plotUnit.axisY.viewportMinimum) + .5) << 0;
	var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) << 0;

	var maxBarWidth = this.dataPointMaxWidth ? this.dataPointMaxWidth : this.width * .15 << 0;
	var xMinDiff = plotUnit.axisX.dataInfo.minDiff;
	var barWidth = plotArea.width / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum) * Math.abs(xMinDiff) * .9 << 0;

	var ghostCtx = this._eventManager.ghostCtx;

	ctx.save();

	if (_utils.isCanvasSupported) ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		ghostCtx.beginPath();
		ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		ghostCtx.clip();
	}

	var xValuePresent = [];
	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];
		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var xValue;

		dataSeries.dataPointIndexes = [];

		for (i = 0; i < dataPoints.length; i++) {
			xValue = dataPoints[i].x.getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;
			dataSeries.dataPointIndexes[xValue] = i;

			if (!xValuePresent[xValue]) {
				allXValues.push(xValue);
				xValuePresent[xValue] = true;
			}
		}

		allXValues.sort(_utils.compareNumbers);
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var isFirstDataPointInPlotArea = true;

		var seriesId = dataSeries.id;
		this._eventManager.objectMap[seriesId] = {
			objectType: "dataSeries", dataSeriesIndex: dataSeriesIndex
		};
		var hexColor = (0, _utils.intToHexColorString)(seriesId);
		ghostCtx.fillStyle = hexColor;

		if (dataPoints.length == 1) barWidth = maxBarWidth;

		if (barWidth < 1) barWidth = 1;else if (barWidth > maxBarWidth) barWidth = maxBarWidth;

		var currentBaseValues = [];

		if (allXValues.length > 0) {

			color = dataSeries._colorSet[i % dataSeries._colorSet.length];
			//ctx.strokeStyle = "red";
			ctx.fillStyle = color;
			ctx.strokeStyle = color;
			ctx.lineWidth = dataSeries.lineThickness;

			if (ctx.setLineDash) {
				ctx.setLineDash((0, _utils.getLineDashArray)(dataSeries.lineDashType, dataSeries.lineThickness));
			}

			var bevelEnabled = barWidth > 5 ? false : false;

			//ctx.strokeStyle = "#4572A7 ";

			for (i = 0; i < allXValues.length; i++) {

				dataPointX = allXValues[i];
				var dataPoint = null;

				if (dataSeries.dataPointIndexes[dataPointX] >= 0) dataPoint = dataPoints[dataSeries.dataPointIndexes[dataPointX]];else dataPoint = {
					x: dataPointX, y: 0
				};

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (typeof dataPoint.y !== "number") continue;

				var yPercent;
				if (plotUnit.dataPointYSums[dataPointX] !== 0) yPercent = dataPoint.y / plotUnit.dataPointYSums[dataPointX] * 100;else yPercent = 0;

				var x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				var y = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (yPercent - plotUnit.axisY.conversionParameters.minimum);

				var offset = offsetY[dataPointX] ? offsetY[dataPointX] : 0;

				y = y - offset;
				currentBaseValues.push({ x: x, y: yZeroToPixel - offset });
				offsetY[dataPointX] = yZeroToPixel - y;

				if (isFirstDataPointInPlotArea) {
					ctx.beginPath();
					ctx.moveTo(x, y);

					if (_utils.isCanvasSupported) {
						ghostCtx.beginPath();
						ghostCtx.moveTo(x, y);
					}

					isFirstDataPointInPlotArea = false;
				} else {

					ctx.lineTo(x, y);

					if (_utils.isCanvasSupported) ghostCtx.lineTo(x, y);

					if (i % 250 == 0) {

						if (dataSeries.lineThickness > 0) ctx.stroke();

						while (currentBaseValues.length > 0) {
							var point = currentBaseValues.pop();
							ctx.lineTo(point.x, point.y);

							if (_utils.isCanvasSupported) ghostCtx.lineTo(point.x, point.y);
						}

						ctx.closePath();

						ctx.globalAlpha = dataSeries.fillOpacity;
						ctx.fill();
						ctx.globalAlpha = 1;

						ctx.beginPath();
						ctx.moveTo(x, y);

						if (_utils.isCanvasSupported) {
							ghostCtx.closePath();
							ghostCtx.fill();
							ghostCtx.beginPath();
							ghostCtx.moveTo(x, y);
						}

						currentBaseValues.push({ x: x, y: yZeroToPixel - offset });
					}
				}

				if (dataSeries.dataPointIndexes[dataPointX] >= 0) {
					var id = dataSeries.dataPointIds[dataSeries.dataPointIndexes[dataPointX]];
					this._eventManager.objectMap[id] = {
						id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: dataSeries.dataPointIndexes[dataPointX], x1: x, y1: y
					};
				}

				//Render Marker
				if (dataSeries.dataPointIndexes[dataPointX] >= 0 && dataPoint.markerSize !== 0) {
					if (dataPoint.markerSize > 0 || dataSeries.markerSize > 0) {
						var markerProps = dataSeries.getMarkerProperties(i, x, y, ctx);
						markers.push(markerProps);

						//if (!dataSeries.maxWidthInX || markerProps.size > dataSeries.maxWidthInX) {
						//	dataSeries.maxWidthInX = markerProps.size / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);
						//}

						markerColor = (0, _utils.intToHexColorString)(id);

						if (_utils.isCanvasSupported) {
							markers.push({
								x: x, y: y, ctx: ghostCtx,
								type: markerProps.type,
								size: markerProps.size,
								color: markerColor,
								borderColor: markerColor,
								borderThickness: markerProps.borderThickness
							});
						}
					}
				}

				if (dataPoint.indexLabel || dataSeries.indexLabel || dataPoint.indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "stackedArea100",
						dataPoint: dataPoint,
						dataSeries: dataSeries,
						point: {
							x: x, y: y
						},
						direction: dataPoints[i].y >= 0 ? 1 : -1,
						color: color
					});
				}
			}

			if (dataSeries.lineThickness > 0) ctx.stroke();

			while (currentBaseValues.length > 0) {
				var point = currentBaseValues.pop();
				ctx.lineTo(point.x, point.y);

				if (_utils.isCanvasSupported) ghostCtx.lineTo(point.x, point.y);
			}

			ctx.closePath();

			ctx.globalAlpha = dataSeries.fillOpacity;
			ctx.fill();
			ctx.globalAlpha = 1;

			ctx.beginPath();
			ctx.moveTo(x, y);

			if (_utils.isCanvasSupported) {
				ghostCtx.closePath();
				ghostCtx.fill();
				ghostCtx.beginPath();
				ghostCtx.moveTo(x, y);
			}
		}

		delete dataSeries.dataPointIndexes;
	}

	_render2.default.drawMarkers(markers);

	ctx.restore();

	if (_utils.isCanvasSupported) ghostCtx.restore();

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: _animator2.default.xClipAnimation, easingFunction: _animator2.default.easing.linear, animationBase: 0
	};
	return animationInfo;
};

var _render = require('../helpers/render');

var _render2 = _interopRequireDefault(_render);

var _animator = require('../helpers/animator');

var _animator2 = _interopRequireDefault(_animator);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

},{"../helpers/animator":37,"../helpers/render":38,"../helpers/utils":39}],17:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;
	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var color = null;

	var plotArea = this.plotArea;

	var offsetPositiveY = [];
	var offsetNegativeY = [];

	var i = 0,
	    x,
	    y;
	var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number everytime it is accessed.

	//var yZeroToPixel = (axisYProps.y2 - axisYProps.height / rangeY * Math.abs(0 - plotUnit.axisY.viewportMinimum) + .5) << 0;
	var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) << 0;

	var maxBarWidth = this.dataPointMaxWidth ? this.dataPointMaxWidth : this.height * .15 << 0;
	var xMinDiff = plotUnit.axisX.dataInfo.minDiff;
	var barWidth = plotArea.height / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum) * Math.abs(xMinDiff) / plotUnit.plotType.plotUnits.length * .9 << 0;

	if (barWidth > maxBarWidth) barWidth = maxBarWidth;else if (xMinDiff === Infinity) {
		barWidth = maxBarWidth;
	} else if (barWidth < 1) barWidth = 1;

	ctx.save();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		this._eventManager.ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		this._eventManager.ghostCtx.clip();
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var isFirstDataPointInPlotArea = true;

		//dataSeries.maxWidthInX = barWidth / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);

		if (dataPoints.length > 0) {
			//var xy = this.getPixelCoordinatesOnPlotArea(dataPoints[0].x, dataPoints[0].y);

			var bevelEnabled = barWidth > 5 && dataSeries.bevelEnabled ? true : false;

			ctx.strokeStyle = "#4572A7 ";

			for (i = 0; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].x.getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (typeof dataPoints[i].y !== "number") continue;

				y = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				//x = (plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y - plotUnit.axisY.conversionParameters.minimum) + .5) << 0;
				x = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y - plotUnit.axisY.conversionParameters.minimum);

				//var x1 = x - (plotUnit.plotType.plotUnits.length * barWidth / 2) + (plotUnit.index * barWidth) << 0;

				var y1 = y - plotUnit.plotType.plotUnits.length * barWidth / 2 + plotUnit.index * barWidth << 0;
				var y2 = y1 + barWidth << 0;
				var x1;
				var x2;

				if (dataPoints[i].y >= 0) {
					var offset = offsetPositiveY[dataPointX] ? offsetPositiveY[dataPointX] : 0;

					x1 = yZeroToPixel + offset;
					x2 = x + offset;

					offsetPositiveY[dataPointX] = offset + (x2 - x1);
				} else {
					var offset = offsetNegativeY[dataPointX] ? offsetNegativeY[dataPointX] : 0;

					x1 = x - offset;
					x2 = yZeroToPixel - offset;

					offsetNegativeY[dataPointX] = offset + (x2 - x1);
				}

				color = dataPoints[i].color ? dataPoints[i].color : dataSeries._colorSet[i % dataSeries._colorSet.length];
				drawRect(ctx, x1, y1, x2, y2, color, 0, null, bevelEnabled, false, false, false, dataSeries.fillOpacity);

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x1, y1: y1, x2: x2, y2: y2
				};
				color = intToHexColorString(id);

				if (_utils.isCanvasSupported) drawRect(this._eventManager.ghostCtx, x1, y1, x2, y2, color, 0, null, false, false, false, false);

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) this._indexLabels.push({
					chartType: "stackedBar",
					dataPoint: dataPoints[i],
					dataSeries: dataSeries,
					point: {
						x: dataPoints[i].y >= 0 ? x2 : x1, y: y
					},
					direction: dataPoints[i].y >= 0 ? 1 : -1,
					bounds: {
						x1: Math.min(x1, x2), y1: y1, x2: Math.max(x1, x2), y2: y2
					},
					color: color
				});
			}
		}
	}

	ctx.restore();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	//source and dest would be same when animation is not enabled
	var animationBase = Math.max(yZeroToPixel, plotUnit.axisX.boundingRect.x2);
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: AnimationHelper.xScaleAnimation, easingFunction: AnimationHelper.easing.easeOutQuart, animationBase: animationBase
	};
	return animationInfo;
};

var _utils = require("../helpers/utils");

},{"../helpers/utils":39}],18:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;
	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var color = null;

	var plotArea = this.plotArea;

	var offsetPositiveY = [];
	var offsetNegativeY = [];

	var i = 0,
	    x,
	    y;
	var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number everytime it is accessed.

	//var yZeroToPixel = (axisYProps.y2 - axisYProps.height / rangeY * Math.abs(0 - plotUnit.axisY.viewportMinimum) + .5) << 0;
	var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) << 0;

	var maxBarWidth = this.dataPointMaxWidth ? this.dataPointMaxWidth : this.height * .15 << 0;
	var xMinDiff = plotUnit.axisX.dataInfo.minDiff;
	var barWidth = plotArea.height / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum) * Math.abs(xMinDiff) / plotUnit.plotType.plotUnits.length * .9 << 0;

	if (barWidth > maxBarWidth) barWidth = maxBarWidth;else if (xMinDiff === Infinity) {
		barWidth = maxBarWidth;
	} else if (barWidth < 1) barWidth = 1;

	ctx.save();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		this._eventManager.ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		this._eventManager.ghostCtx.clip();
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var isFirstDataPointInPlotArea = true;

		//dataSeries.maxWidthInX = barWidth / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);

		if (dataPoints.length > 0) {
			//var xy = this.getPixelCoordinatesOnPlotArea(dataPoints[0].x, dataPoints[0].y);

			var bevelEnabled = barWidth > 5 && dataSeries.bevelEnabled ? true : false;

			ctx.strokeStyle = "#4572A7 ";

			for (i = 0; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].x.getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (typeof dataPoints[i].y !== "number") continue;

				y = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;

				var yPercent;
				if (plotUnit.dataPointYSums[dataPointX] !== 0) yPercent = dataPoints[i].y / plotUnit.dataPointYSums[dataPointX] * 100;else yPercent = 0;

				//x = (plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (yPercent - plotUnit.axisY.conversionParameters.minimum) + .5) << 0;
				x = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (yPercent - plotUnit.axisY.conversionParameters.minimum);

				var y1 = y - plotUnit.plotType.plotUnits.length * barWidth / 2 + plotUnit.index * barWidth << 0;
				var y2 = y1 + barWidth << 0;
				var x1;
				var x2;

				if (dataPoints[i].y >= 0) {
					var offset = offsetPositiveY[dataPointX] ? offsetPositiveY[dataPointX] : 0;

					x1 = yZeroToPixel + offset;
					x2 = x + offset;

					offsetPositiveY[dataPointX] = offset + (x2 - x1);
				} else {
					var offset = offsetNegativeY[dataPointX] ? offsetNegativeY[dataPointX] : 0;

					x1 = x - offset;
					x2 = yZeroToPixel - offset;

					offsetNegativeY[dataPointX] = offset + (x2 - x1);
				}

				color = dataPoints[i].color ? dataPoints[i].color : dataSeries._colorSet[i % dataSeries._colorSet.length];
				drawRect(ctx, x1, y1, x2, y2, color, 0, null, bevelEnabled, false, false, false, dataSeries.fillOpacity);

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x1, y1: y1, x2: x2, y2: y2
				};
				color = intToHexColorString(id);

				if (_utils.isCanvasSupported) drawRect(this._eventManager.ghostCtx, x1, y1, x2, y2, color, 0, null, false, false, false, false);

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) this._indexLabels.push({
					chartType: "stackedBar100",
					dataPoint: dataPoints[i],
					dataSeries: dataSeries,
					point: {
						x: dataPoints[i].y >= 0 ? x2 : x1, y: y
					},
					direction: dataPoints[i].y >= 0 ? 1 : -1,
					bounds: {
						x1: Math.min(x1, x2), y1: y1, x2: Math.max(x1, x2), y2: y2
					},
					color: color
				});
			}
		}
	}

	ctx.restore();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	//source and dest would be same when animation is not enabled
	var animationBase = Math.max(yZeroToPixel, plotUnit.axisX.boundingRect.x2);
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: AnimationHelper.xScaleAnimation, easingFunction: AnimationHelper.easing.easeOutQuart, animationBase: animationBase
	};
	return animationInfo;
};

var _utils = require("../helpers/utils");

},{"../helpers/utils":39}],19:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {

	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;
	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var color = null;

	var plotArea = this.plotArea;

	var offsetPositiveY = [];
	var offsetNegativeY = [];

	var i = 0,
	    x,
	    y;
	var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number everytime it is accessed.

	//var yZeroToPixel = (axisYProps.y2 - axisYProps.height / rangeY * Math.abs(0 - plotUnit.axisY.viewportMinimum) + .5) << 0;
	var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) << 0;

	var maxBarWidth = this.dataPointMaxWidth ? this.dataPointMaxWidth : this.width * .15 << 0;
	var xMinDiff = plotUnit.axisX.dataInfo.minDiff;
	var barWidth = plotArea.width / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum) * Math.abs(xMinDiff) / plotUnit.plotType.plotUnits.length * .9 << 0;

	if (barWidth > maxBarWidth) barWidth = maxBarWidth;else if (xMinDiff === Infinity) {
		barWidth = maxBarWidth;
	} else if (barWidth < 1) barWidth = 1;

	ctx.save();
	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		this._eventManager.ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		this._eventManager.ghostCtx.clip();
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];
		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var isFirstDataPointInPlotArea = true;

		// Reducing pixelPerUnit by 1 just to overcome any problems due to rounding off of pixels.
		//dataSeries.maxWidthInX = barWidth / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);


		if (dataPoints.length > 0) {
			//var xy = this.getPixelCoordinatesOnPlotArea(dataPoints[0].x, dataPoints[0].y);

			var bevelEnabled = barWidth > 5 && dataSeries.bevelEnabled ? true : false;

			ctx.strokeStyle = "#4572A7 ";

			for (i = 0; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].x.getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (typeof dataPoints[i].y !== "number") continue;

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				y = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y - plotUnit.axisY.conversionParameters.minimum);

				var x1 = x - plotUnit.plotType.plotUnits.length * barWidth / 2 + plotUnit.index * barWidth << 0;
				var x2 = x1 + barWidth << 0;
				var y1;
				var y2;

				if (dataPoints[i].y >= 0) {
					var offset = offsetPositiveY[dataPointX] ? offsetPositiveY[dataPointX] : 0;

					y1 = y - offset;
					y2 = yZeroToPixel - offset;

					offsetPositiveY[dataPointX] = offset + (y2 - y1);
				} else {
					var offset = offsetNegativeY[dataPointX] ? offsetNegativeY[dataPointX] : 0;

					y2 = y + offset;
					y1 = yZeroToPixel + offset;

					offsetNegativeY[dataPointX] = offset + (y2 - y1);
				}

				color = dataPoints[i].color ? dataPoints[i].color : dataSeries._colorSet[i % dataSeries._colorSet.length];

				drawRect(ctx, x1, y1, x2, y2, color, 0, null, bevelEnabled && dataPoints[i].y >= 0, dataPoints[i].y < 0 && bevelEnabled, false, false, dataSeries.fillOpacity);

				//if (dataSeries.markerType && dataSeries.markerSize > 0) {
				//    RenderHelper.drawMarker(x1 + (x2 - x1)/2, y1, ctx, dataSeries.markerType, dataSeries.markerSize, color, dataSeries.markerBorderColor, dataSeries.markerBorderThickness ? dataSeries.markerBorderThickness : 1);
				//}

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x1, y1: y1, x2: x2, y2: y2
				};
				color = intToHexColorString(id);

				if (_utils.isCanvasSupported) drawRect(this._eventManager.ghostCtx, x1, y1, x2, y2, color, 0, null, false, false, false, false);

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "stackedColumn",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						point: {
							x: x, y: dataPoints[i].y >= 0 ? y1 : y2
						},
						direction: dataPoints[i].y >= 0 ? 1 : -1,
						bounds: {
							x1: x1, y1: Math.min(y1, y2), x2: x2, y2: Math.max(y1, y2)
						},
						color: color
					});
				}
			}
		}
	}

	ctx.restore();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	//source and dest would be same when animation is not enabled
	var animationBase = Math.min(yZeroToPixel, plotUnit.axisY.boundingRect.y2);
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: AnimationHelper.yScaleAnimation, easingFunction: AnimationHelper.easing.easeOutQuart, animationBase: animationBase
	};
	return animationInfo;
};

var _utils = require("../helpers/utils");

},{"../helpers/utils":39}],20:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;
	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var color = null;

	var plotArea = this.plotArea;

	var offsetPositiveY = [];
	var offsetNegativeY = [];

	var i = 0,
	    x,
	    y;
	var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number everytime it is accessed.

	//var yZeroToPixel = (axisYProps.y2 - axisYProps.height / rangeY * Math.abs(0 - plotUnit.axisY.viewportMinimum) + .5) << 0;
	var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) << 0;

	var maxBarWidth = this.dataPointMaxWidth ? this.dataPointMaxWidth : this.width * .15 << 0;
	var xMinDiff = plotUnit.axisX.dataInfo.minDiff;
	var barWidth = plotArea.width / Math.abs(plotUnit.axisX.viewportMaximum - plotUnit.axisX.viewportMinimum) * Math.abs(xMinDiff) / plotUnit.plotType.plotUnits.length * .9 << 0;

	if (barWidth > maxBarWidth) barWidth = maxBarWidth;else if (xMinDiff === Infinity) {
		barWidth = maxBarWidth;
	} else if (barWidth < 1) barWidth = 1;

	ctx.save();
	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		this._eventManager.ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		this._eventManager.ghostCtx.clip();
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		var dataPoints = dataSeries.dataPoints;
		var isFirstDataPointInPlotArea = true;

		//dataSeries.maxWidthInX = barWidth / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);


		if (dataPoints.length > 0) {
			//var xy = this.getPixelCoordinatesOnPlotArea(dataPoints[0].x, dataPoints[0].y);

			var bevelEnabled = barWidth > 5 && dataSeries.bevelEnabled ? true : false;

			//ctx.strokeStyle = "#4572A7 ";

			for (i = 0; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].x.getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				if (typeof dataPoints[i].y !== "number") continue;

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;

				var yPercent;
				if (plotUnit.dataPointYSums[dataPointX] !== 0) yPercent = dataPoints[i].y / plotUnit.dataPointYSums[dataPointX] * 100;else yPercent = 0;

				//y = (plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (yPercent - plotUnit.axisY.conversionParameters.minimum) + .5) << 0;
				y = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (yPercent - plotUnit.axisY.conversionParameters.minimum);

				var x1 = x - plotUnit.plotType.plotUnits.length * barWidth / 2 + plotUnit.index * barWidth << 0;
				var x2 = x1 + barWidth << 0;
				var y1;
				var y2;

				if (dataPoints[i].y >= 0) {
					var offset = offsetPositiveY[dataPointX] ? offsetPositiveY[dataPointX] : 0;

					y1 = y - offset;
					y2 = yZeroToPixel - offset;

					offsetPositiveY[dataPointX] = offset + (y2 - y1);
				} else {
					var offset = offsetNegativeY[dataPointX] ? offsetNegativeY[dataPointX] : 0;

					y2 = y + offset;
					y1 = yZeroToPixel + offset;

					offsetNegativeY[dataPointX] = offset + (y2 - y1);
				}

				color = dataPoints[i].color ? dataPoints[i].color : dataSeries._colorSet[i % dataSeries._colorSet.length];
				drawRect(ctx, x1, y1, x2, y2, color, 0, null, bevelEnabled && dataPoints[i].y >= 0, dataPoints[i].y < 0 && bevelEnabled, false, false, dataSeries.fillOpacity);

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x1, y1: y1, x2: x2, y2: y2
				};
				color = intToHexColorString(id);

				if (_utils.isCanvasSupported) drawRect(this._eventManager.ghostCtx, x1, y1, x2, y2, color, 0, null, false, false, false, false);

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "stackedColumn100",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						point: {
							x: x, y: dataPoints[i].y >= 0 ? y1 : y2
						},
						direction: dataPoints[i].y >= 0 ? 1 : -1,
						bounds: {
							x1: x1, y1: Math.min(y1, y2), x2: x2, y2: Math.max(y1, y2)
						},
						color: color
					});
				}
			}
		}
	}

	ctx.restore();

	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	//source and dest would be same when animation is not enabled
	var animationBase = Math.min(yZeroToPixel, plotUnit.axisY.boundingRect.y2);
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: AnimationHelper.yScaleAnimation, easingFunction: AnimationHelper.easing.easeOutQuart, animationBase: animationBase
	};
	return animationInfo;
};

var _utils = require("../helpers/utils");

},{"../helpers/utils":39}],21:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;

	var totalDataSeries = plotUnit.dataSeriesIndexes.length;

	if (totalDataSeries <= 0) return;

	var ghostCtx = this._eventManager.ghostCtx;

	var axisXProps = plotUnit.axisX.lineCoordinates;
	var axisYProps = plotUnit.axisY.lineCoordinates;
	var markers = [];

	var plotArea = this.plotArea;
	ctx.save();

	if (_utils.isCanvasSupported) ghostCtx.save();

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	if (_utils.isCanvasSupported) {
		ghostCtx.beginPath();
		ghostCtx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
		ghostCtx.clip();
	}

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];

		var dataPoints = dataSeries.dataPoints;

		var seriesId = dataSeries.id;
		this._eventManager.objectMap[seriesId] = {
			objectType: "dataSeries", dataSeriesIndex: dataSeriesIndex
		};

		var hexColor = intToHexColorString(seriesId);
		ghostCtx.fillStyle = hexColor;
		//ghostCtx.lineWidth = dataSeries.lineThickness;
		//ghostCtx.lineWidth = 20;

		markers = [];

		var isFirstDataPointInPlotArea = true;
		var i = 0,
		    x,
		    y;
		var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number back and forth.

		var yZeroToPixel = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (0 - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;
		var baseY;

		var startPoint = null;

		var prevDataNull = false;
		if (dataPoints.length > 0) {
			//ctx.strokeStyle = "#4572A7 ";
			var color = dataSeries._colorSet[i % dataSeries._colorSet.length];
			//ctx.strokeStyle = "red";
			ctx.fillStyle = color;
			ctx.strokeStyle = color;
			ctx.lineWidth = dataSeries.lineThickness;

			if (ctx.setLineDash) {
				ctx.setLineDash(getLineDashArray(dataSeries.lineDashType, dataSeries.lineThickness));
			}

			for (; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].x.getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) {
					continue;
				}

				var prevY = y;

				if (typeof dataPoints[i].y !== "number") {
					closeArea();

					prevDataNull = true;
					continue;
				}

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				y = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				if (isFirstDataPointInPlotArea || prevDataNull) {
					ctx.beginPath();
					ctx.moveTo(x, y);
					startPoint = {
						x: x, y: y
					};

					if (_utils.isCanvasSupported) {
						ghostCtx.beginPath();
						ghostCtx.moveTo(x, y);
					}

					isFirstDataPointInPlotArea = false;
					prevDataNull = false;
				} else {

					ctx.lineTo(x, prevY);
					if (_utils.isCanvasSupported) ghostCtx.lineTo(x, prevY);

					ctx.lineTo(x, y);

					if (_utils.isCanvasSupported) ghostCtx.lineTo(x, y);

					if (i % 250 == 0) {
						closeArea();
					}
				}

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x, y1: y
				};

				//Render Marker
				if (dataPoints[i].markerSize !== 0) {
					if (dataPoints[i].markerSize > 0 || dataSeries.markerSize > 0) {
						var markerProps = dataSeries.getMarkerProperties(i, x, y, ctx);
						markers.push(markerProps);

						//if (!dataSeries.maxWidthInX || markerProps.size > dataSeries.maxWidthInX) {
						//	dataSeries.maxWidthInX = markerProps.size / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);
						//}

						var markerColor = intToHexColorString(id);

						if (_utils.isCanvasSupported) {
							markers.push({
								x: x, y: y, ctx: ghostCtx,
								type: markerProps.type,
								size: markerProps.size,
								color: markerColor,
								borderColor: markerColor,
								borderThickness: markerProps.borderThickness
							});
						}
					}
				}

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "stepArea",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						point: {
							x: x, y: y
						},
						direction: dataPoints[i].y >= 0 ? 1 : -1,
						color: color
					});
				}
			}

			closeArea();

			RenderHelper.drawMarkers(markers);
		}
	}

	ctx.restore();
	if (_utils.isCanvasSupported) this._eventManager.ghostCtx.restore();

	function closeArea() {

		if (!startPoint) return;

		if (dataSeries.lineThickness > 0) ctx.stroke();

		if (plotUnit.axisY.viewportMinimum <= 0 && plotUnit.axisY.viewportMaximum >= 0) {
			baseY = yZeroToPixel;
		} else if (plotUnit.axisY.viewportMaximum < 0) baseY = axisYProps.y1;else if (plotUnit.axisY.viewportMinimum > 0) baseY = axisXProps.y2;

		ctx.lineTo(x, baseY);
		ctx.lineTo(startPoint.x, baseY);
		ctx.closePath();

		ctx.globalAlpha = dataSeries.fillOpacity;
		ctx.fill();
		ctx.globalAlpha = 1;

		if (_utils.isCanvasSupported) {
			ghostCtx.lineTo(x, baseY);
			ghostCtx.lineTo(startPoint.x, baseY);
			ghostCtx.closePath();
			ghostCtx.fill();
		}

		ctx.beginPath();
		ctx.moveTo(x, y);
		ghostCtx.beginPath();
		ghostCtx.moveTo(x, y);

		startPoint = {
			x: x, y: y
		};
	}

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: AnimationHelper.xClipAnimation, easingFunction: AnimationHelper.easing.linear, animationBase: 0
	};
	return animationInfo;
};

var _utils = require("../helpers/utils");

},{"../helpers/utils":39}],22:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var cultures = exports.cultures = {
  "en": {}
  //Derives from the default options
  //,
  //"es": {
  //    decimalSeparator: ",",
  //    digitGroupSeparator: ".",
  //    zoomText: "zoom",
  //    panText: "pan",
  //    resetText: "reset",
  //    days: ["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"],
  //}
};

var constants = exports.constants = {
  numberDuration: 1,
  yearDuration: 1000 * 60 * 60 * 24 * 364,
  monthDuration: 1000 * 60 * 60 * 24 * 30,
  weekDuration: 1000 * 60 * 60 * 24 * 7,
  dayDuration: 1000 * 60 * 60 * 24,
  hourDuration: 1000 * 60 * 60,
  minuteDuration: 1000 * 60,
  secondDuration: 1000,
  millisecondDuration: 1,

  dayOfWeekFromInt: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
};

},{}],23:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
			value: true
});
var isDebugMode = exports.isDebugMode = false;

var isCanvasSupported = exports.isCanvasSupported = !!document.createElement("canvas").getContext;
//isCanvasSupported = false;

//Default values for all Chart Elements that can be set by the user. CanvasJSObject.setOptions looks into this while setting the default/user-defined values.
var defaultOptions = exports.defaultOptions = {
			Chart: {
						width: 500,
						height: 400,
						zoomEnabled: false,
						zoomType: "x",
						backgroundColor: "white",
						theme: "theme1",
						animationEnabled: false,
						animationDuration: 1200,
						dataPointMaxWidth: null,

						colorSet: "colorSet1",
						culture: "en",
						creditText: "CanvasJS.com",
						interactivityEnabled: true,
						exportEnabled: false,
						exportFileName: "Chart",

						rangeChanging: null,
						rangeChanged: null
			},

			Title: {
						padding: 0,
						text: null,
						verticalAlign: "top", //top, center, bottom
						horizontalAlign: "center", //left, center, right
						fontSize: 20, //in pixels
						fontFamily: "Calibri",
						fontWeight: "normal", //normal, bold, bolder, lighter,
						fontColor: "black",
						fontStyle: "normal", // normal, italic, oblique

						borderThickness: 0,
						borderColor: "black",
						cornerRadius: 0,
						backgroundColor: null,
						margin: 5,
						wrap: true,
						maxWidth: null,

						dockInsidePlotArea: false
						//toolTipContent: null//string - To be implemented (TBI)
			},

			Subtitle: {
						padding: 0,
						text: null,
						verticalAlign: "top", //top, center, bottom
						horizontalAlign: "center", //left, center, right
						fontSize: 14, //in pixels
						fontFamily: "Calibri",
						fontWeight: "normal", //normal, bold, bolder, lighter,
						fontColor: "black",
						fontStyle: "normal", // normal, italic, oblique

						borderThickness: 0,
						borderColor: "black",
						cornerRadius: 0,
						backgroundColor: null,
						margin: 2,
						wrap: true,
						maxWidth: null,

						dockInsidePlotArea: false
						//toolTipContent: null//string - To be implemented (TBI)
			},

			Legend: {
						name: null,
						verticalAlign: "center",
						horizontalAlign: "right",

						fontSize: 14, //in pixels
						fontFamily: "calibri",
						fontWeight: "normal", //normal, bold, bolder, lighter,
						fontColor: "black",
						fontStyle: "normal", // normal, italic, oblique

						cursor: null,
						itemmouseover: null,
						itemmouseout: null,
						itemmousemove: null,
						itemclick: null,

						dockInsidePlotArea: false,
						reversed: false,

						maxWidth: null,
						maxHeight: null,

						itemMaxWidth: null,
						itemWidth: null,
						itemWrap: true,
						itemTextFormatter: null
			},

			ToolTip: {
						enabled: true,
						shared: false,
						animationEnabled: true,
						content: null,
						contentFormatter: null,

						reversed: false,

						backgroundColor: null,

						borderColor: null,
						borderThickness: 2, //in pixels
						cornerRadius: 5, // in pixels

						fontSize: 14, // in pixels
						fontColor: "#000000",
						fontFamily: "Calibri, Arial, Georgia, serif;",
						fontWeight: "normal", //normal, bold, bolder, lighter,
						fontStyle: "italic" // normal, italic, oblique
			},

			Axis: {
						minimum: null, //Minimum value to be shown on the Axis
						maximum: null, //Minimum value to be shown on the Axis
						viewportMinimum: null,
						viewportMaximum: null,
						interval: null, // Interval for tick marks and grid lines
						intervalType: null, //number, millisecond, second, minute, hour, day, month, year
						//reversed: false,

						title: null, // string
						titleFontColor: "black",
						titleFontSize: 20,
						titleFontFamily: "arial",
						titleFontWeight: "normal",
						titleFontStyle: "normal",

						labelAngle: 0,
						labelFontFamily: "arial",
						labelFontColor: "black",
						labelFontSize: 12,
						labelFontWeight: "normal",
						labelFontStyle: "normal",
						labelAutoFit: false,
						labelWrap: true,
						labelMaxWidth: null, //null for auto
						labelFormatter: null,

						prefix: "",
						suffix: "",

						includeZero: true, //Applies only for axisY. Ignored in axisX.

						tickLength: 5,
						tickColor: "black",
						tickThickness: 1,

						lineColor: "black",
						lineThickness: 1,
						lineDashType: "solid",

						gridColor: "A0A0A0",
						gridThickness: 0,
						gridDashType: "solid",

						interlacedColor: null,

						valueFormatString: null,

						margin: 2,

						stripLines: [] // Just a placeholder. Does not have any effect on the actual number of striplines
			},

			StripLine: {
						value: null,
						startValue: null,
						endValue: null,

						color: "orange",
						opacity: null,
						thickness: 2,
						lineDashType: "solid",
						label: "",
						labelBackgroundColor: "#EEEEEE",
						labelFontFamily: "arial",
						labelFontColor: "orange",
						labelFontSize: 12,
						labelFontWeight: "normal",
						labelFontStyle: "normal",
						labelFormatter: null,

						showOnTop: false
			},

			DataSeries: {
						name: null,
						dataPoints: null,
						label: "",
						bevelEnabled: false,
						highlightEnabled: true,

						cursor: null,

						indexLabel: "",
						indexLabelPlacement: "auto", //inside, outside, auto
						indexLabelOrientation: "horizontal",
						indexLabelFontColor: "black",
						indexLabelFontSize: 12,
						indexLabelFontStyle: "normal", //   italic ,oblique, normal
						indexLabelFontFamily: "Arial", // fx: Arial Verdana "Courier New" Serif
						indexLabelFontWeight: "normal", // bold ,bolder, lighter, normal
						indexLabelBackgroundColor: null,
						indexLabelLineColor: null,
						indexLabelLineThickness: 1,
						indexLabelLineDashType: "solid",
						indexLabelMaxWidth: null,
						indexLabelWrap: true,
						indexLabelFormatter: null,

						lineThickness: 2,
						lineDashType: "solid",

						color: null,
						risingColor: "white",
						fillOpacity: null,

						startAngle: 0,

						radius: null,
						innerRadius: null,

						type: "column", //line, column, bar, area, scatter stackedColumn, stackedBar, stackedArea, stackedColumn100, stackedBar100, stackedArea100, pie, doughnut
						xValueType: "number", //number, dateTime
						axisYType: "primary",

						xValueFormatString: null,
						yValueFormatString: null,
						zValueFormatString: null,
						percentFormatString: null,

						showInLegend: null,
						legendMarkerType: null,
						legendMarkerColor: null,
						legendText: null,
						legendMarkerBorderColor: null,
						legendMarkerBorderThickness: null,

						markerType: "circle", //none, circle, square, cross, triangle, line
						markerColor: null,
						markerSize: null,
						markerBorderColor: null,
						markerBorderThickness: null,
						//animationEnabled: true,
						mouseover: null,
						mouseout: null,
						mousemove: null,
						click: null,
						toolTipContent: null,

						visible: true
			},

			//Private
			TextBlock: {
						x: 0,
						y: 0,
						width: null, //read only
						height: null, //read only
						maxWidth: null,
						maxHeight: null,
						padding: 0,
						angle: 0,
						text: "",
						horizontalAlign: "center", //left, center, right
						fontSize: 12, //in pixels
						fontFamily: "calibri",
						fontWeight: "normal", //normal, bold, bolder, lighter,
						fontColor: "black",
						fontStyle: "normal", // normal, italic, oblique

						borderThickness: 0,
						borderColor: "black",
						cornerRadius: 0,
						backgroundColor: null,
						textBaseline: "top"
			},

			CultureInfo: {
						decimalSeparator: ".",
						digitGroupSeparator: ",",
						zoomText: "Zoom",
						panText: "Pan",
						resetText: "Reset",

						menuText: "More Options",
						saveJPGText: "Save as JPG",
						savePNGText: "Save as PNG",

						days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
						shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],

						months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
						shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
			}
};

},{}],24:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});
exports.themes = exports.colorSets = undefined;

var _utils = require("../helpers/utils");

var colorSets = exports.colorSets = {

	"colorSet1": ["#369EAD", "#C24642", "#7F6084",
	//"#96C412",
	"#86B402", "#A2D1CF",
	//"#D8C641",
	"#C8B631", "#6DBCEB",
	//"#4A4946",
	"#52514E", "#4F81BC", "#A064A1", "#F79647"],
	"colorSet2": ["#4F81BC", "#C0504E", "#9BBB58", "#23BFAA",
	//"#FAA586",
	"#8064A1", "#4AACC5", "#F79647",
	//"#77AA33",
	//"#7F6084"
	"#33558B"],
	"colorSet3": ["#8CA1BC", "#36845C", "#017E82", "#8CB9D0", "#708C98", "#94838D", "#F08891", "#0366A7", "#008276", "#EE7757", "#E5BA3A", "#F2990B", "#03557B", "#782970"] //,
	//"colorSet4": [
	//    "#3698C5",
	//    "#009B8D",
	//    "#F1D691",
	//    "#F8B90C",
	//    "#0081B8",
	//    "#5B5A96",
	//    "#ACBDD1",
	//    "#88A891",
	//    "#39969D",
	//    "#AECEDD",
	//    "#A0B2BC",
	//    "#BBAEB7",
	//    "#A0C65F",
	//    "#EEA6AA",
	//    "#3798C5"
	//],
	//"colorSet5": [
	//    "#88ADBF",
	//    "#84C336",
	//    "#7B91C3",
	//    "#4661EE",
	//    "#EC5657",
	//    "#1BCDD1",
	//    "#8FAABB",
	//    "#B08BEB",
	//    "#3EA0DD",
	//    "#F5A52A",
	//    "#23BFAA",
	//    "#FAA586",
	//    "#EB8CC6"
	//]

};

var themes = exports.themes = {

	"theme1": {
		Chart: {
			colorSet: "colorSet1"
		},
		Title: {
			fontFamily: _utils.isCanvasSupported ? "Calibri, Optima, Candara, Verdana, Geneva, sans-serif" : "calibri",
			fontSize: 33,
			fontColor: "#3A3A3A",
			fontWeight: "bold",
			verticalAlign: "top",
			margin: 5
		},
		Subtitle: {
			fontFamily: _utils.isCanvasSupported ? "Calibri, Optima, Candara, Verdana, Geneva, sans-serif" : "calibri",
			fontSize: 16,
			fontColor: "#3A3A3A",
			fontWeight: "bold",
			verticalAlign: "top",
			margin: 5
		},
		Axis: {
			titleFontSize: 26,
			//titleFontColor: "rgb(98,98,98)",
			titleFontColor: "#666666",
			//titleFontFamily: "arial black",
			//titleFontFamily: "Verdana, Geneva, Calibri, sans-serif",
			titleFontFamily: _utils.isCanvasSupported ? "Calibri, Optima, Candara, Verdana, Geneva, sans-serif" : "calibri",
			//titleFontWeight: "bold",

			//labelFontFamily: "Times New Roman, Times, serif",
			labelFontFamily: _utils.isCanvasSupported ? "Calibri, Optima, Candara, Verdana, Geneva, sans-serif" : "calibri",
			//labelFontFamily: "Helvetica Neue, Helvetica",
			labelFontSize: 18,
			labelFontColor: "grey",
			//labelFontWeight: "bold",
			tickColor: "#BBBBBB",
			tickThickness: 2,
			gridThickness: 2,
			gridColor: "#BBBBBB",
			lineThickness: 2,
			lineColor: "#BBBBBB"
		},
		Legend: {
			verticalAlign: "bottom",
			horizontalAlign: "center",
			fontFamily: _utils.isCanvasSupported ? "monospace, sans-serif,arial black" : "calibri"
		},
		DataSeries: {
			//bevelEnabled: true,
			indexLabelFontColor: "grey",
			//indexLabelFontFamily: "Trebuchet MS, monospace, Courier New, Courier",
			indexLabelFontFamily: _utils.isCanvasSupported ? "Calibri, Optima, Candara, Verdana, Geneva, sans-serif" : "calibri",
			//indexLabelFontWeight: "bold",
			indexLabelFontSize: 18,
			//indexLabelLineColor: "lightgrey",
			indexLabelLineThickness: 1
		}
	},

	"theme2": {
		Chart: {
			colorSet: "colorSet2"
		},
		Title: {
			fontFamily: "impact, charcoal, arial black, sans-serif",
			fontSize: 32, //fontColor: "rgb(58,58,58)",
			fontColor: "#333333",
			verticalAlign: "top",
			margin: 5
		},
		Subtitle: {
			fontFamily: "impact, charcoal, arial black, sans-serif",
			fontSize: 14, //fontColor: "rgb(58,58,58)",
			fontColor: "#333333",
			verticalAlign: "top",
			margin: 5
		},
		Axis: {
			titleFontSize: 22,
			titleFontColor: "rgb(98,98,98)",
			//titleFontFamily: "arial black",
			titleFontFamily: _utils.isCanvasSupported ? "monospace, sans-serif,arial black" : "arial",
			titleFontWeight: "bold",

			labelFontFamily: _utils.isCanvasSupported ? "monospace, Courier New, Courier" : "arial",
			//labelFontFamily: "Helvetica Neue, Helvetica",
			labelFontSize: 16,
			labelFontColor: "grey",
			labelFontWeight: "bold",
			tickColor: "grey",
			tickThickness: 2,
			gridThickness: 2,
			gridColor: "grey",
			lineColor: "grey",
			lineThickness: 0
		},
		Legend: {
			verticalAlign: "bottom",
			horizontalAlign: "center",
			fontFamily: _utils.isCanvasSupported ? "monospace, sans-serif,arial black" : "arial"
		},
		DataSeries: {
			indexLabelFontColor: "grey",
			//indexLabelFontFamily: "Trebuchet MS, monospace, Courier New, Courier",
			indexLabelFontFamily: _utils.isCanvasSupported ? "Courier New, Courier, monospace" : "arial",
			indexLabelFontWeight: "bold",
			indexLabelFontSize: 18,
			//indexLabelLineColor: "lightgrey",
			indexLabelLineThickness: 1
		}
	},

	"theme3": {
		Chart: {
			colorSet: "colorSet1"
		},
		Title: {
			fontFamily: _utils.isCanvasSupported ? "Candara, Optima, Trebuchet MS, Helvetica Neue, Helvetica, Trebuchet MS, serif" : "calibri",
			fontSize: 32,
			fontColor: "#3A3A3A",
			fontWeight: "bold",
			verticalAlign: "top",
			margin: 5
		},
		Subtitle: {
			fontFamily: _utils.isCanvasSupported ? "Candara, Optima, Trebuchet MS, Helvetica Neue, Helvetica, Trebuchet MS, serif" : "calibri",
			fontSize: 16,
			fontColor: "#3A3A3A",
			fontWeight: "bold",
			verticalAlign: "top",
			margin: 5
		},
		Axis: {
			titleFontSize: 22,
			titleFontColor: "rgb(98,98,98)",
			//titleFontFamily: "arial black",
			titleFontFamily: _utils.isCanvasSupported ? "Verdana, Geneva, Calibri, sans-serif" : "calibri",
			//titleFontWeight: "bold",

			//labelFontFamily: "Times New Roman, Times, serif",
			labelFontFamily: _utils.isCanvasSupported ? "Calibri, Optima, Candara, Verdana, Geneva, sans-serif" : "calibri",
			//labelFontFamily: "Helvetica Neue, Helvetica",
			labelFontSize: 18,
			labelFontColor: "grey",
			//labelFontWeight: "bold",
			tickColor: "grey",
			tickThickness: 2,
			gridThickness: 2,
			gridColor: "grey",
			lineThickness: 2,
			lineColor: "grey"
		},
		Legend: {
			verticalAlign: "bottom",
			horizontalAlign: "center",
			fontFamily: _utils.isCanvasSupported ? "monospace, sans-serif,arial black" : "calibri"
		},
		DataSeries: {
			bevelEnabled: true,
			indexLabelFontColor: "grey",
			//indexLabelFontFamily: "Trebuchet MS, monospace, Courier New, Courier",
			indexLabelFontFamily: _utils.isCanvasSupported ? "Candara, Optima, Calibri, Verdana, Geneva, sans-serif" : "calibri",
			//indexLabelFontWeight: "bold",
			indexLabelFontSize: 18,
			indexLabelLineColor: "lightgrey",
			indexLabelLineThickness: 2
		}
	}
};

},{"../helpers/utils":39}],25:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _animator = require('../helpers/animator');

var _animator2 = _interopRequireDefault(_animator);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Animator(chart) {

  this.chart = chart;
  this.ctx = this.chart.plotArea.ctx;
  this.animations = [];
  this.animationRequestId = null;
}

//Animator.prototype.animate = function (duration, base, dest, source, animationCallback, onComplete) {
//#region Animator

Animator.prototype.animate = function (startDelay, duration, animationCallback, onComplete, easingFunction) {
  var _this = this;

  this.chart.isAnimating = true;
  easingFunction = easingFunction || _animator2.default.easing.linear;

  if (animationCallback) {

    this.animations.push({
      startTime: new Date().getTime() + (startDelay ? startDelay : 0),
      duration: duration,
      animationCallback: animationCallback,
      onComplete: onComplete
    });
  }

  var remainingAnimations = [];

  while (this.animations.length > 0) {

    var animation = this.animations.shift();
    var now = new Date().getTime();
    var fractionComplete = 0;
    //var fractionComplete = Math.min(((new Date()).getTime() - animation.startTime) / animation.duration, 1);

    if (animation.startTime <= now) {
      fractionComplete = easingFunction(Math.min(now - animation.startTime, animation.duration), 0, 1, animation.duration);
      //var fractionComplete = AnimationHelper.easing.easeOutQuad(Math.min(((new Date()).getTime() - animation.startTime), animation.duration), 0, 1, animation.duration);

      fractionComplete = Math.min(fractionComplete, 1);

      if (isNaN(fractionComplete) || !isFinite(fractionComplete)) fractionComplete = 1;
    }

    if (fractionComplete < 1) {
      remainingAnimations.push(animation);
    }

    animation.animationCallback(fractionComplete);

    if (fractionComplete >= 1 && animation.onComplete) animation.onComplete();
  }

  this.animations = remainingAnimations;

  if (this.animations.length > 0) {
    this.animationRequestId = this.chart.requestAnimFrame.call(window, function () {
      _this.animate.call(_this);
    });
  } else {
    this.chart.isAnimating = false;
  }
};

Animator.prototype.cancelAllAnimations = function () {

  this.animations = [];

  if (this.animationRequestId) {
    this.chart.cancelRequestAnimFrame.call(window, this.animationRequestId);
  }

  this.animationRequestId = null;
  this.chart.isAnimating = false;
};

exports.default = Animator;

},{"../helpers/animator":37}],26:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _canvasjs = require('./canvasjs');

var _canvasjs2 = _interopRequireDefault(_canvasjs);

var _text_block = require('./text_block');

var _text_block2 = _interopRequireDefault(_text_block);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Axis(chart, options, type, position) {

	Axis.base.constructor.call(this, "Axis", options, chart.theme);

	this.chart = chart;
	this.canvas = chart.canvas;
	this.ctx = chart.ctx;
	this.maxWidth = 0;
	this.maxHeight = 0;
	this.intervalStartPosition = 0;
	this.labels = [];
	this._labels = null;

	//Processed information about the data that gets plotted against this axis
	this.dataInfo = {
		min: Infinity,
		max: -Infinity,
		viewPortMin: Infinity,
		viewPortMax: -Infinity,
		minDiff: Infinity // Used only in case of axisX
	};

	if (type === "axisX") {
		this.sessionVariables = this.chart.sessionVariables[type];

		if (!this._options.interval) this.intervalType = null;
	} else {
		if (position === "left" || position === "top") this.sessionVariables = this.chart.sessionVariables["axisY"];else {
			this.sessionVariables = this.chart.sessionVariables["axisY2"];
		}
	}

	if (typeof this._options.titleFontSize === "undefined") {

		this.titleFontSize = this.chart.getAutoFontSize(this.titleFontSize);

		//window.console.log("titleFontSize: " + this.titleFontSize);
	}

	if (typeof this._options.labelFontSize === "undefined") {

		this.labelFontSize = this.chart.getAutoFontSize(this.labelFontSize);

		//window.console.log("labelFontSize: " + this.labelFontSize);
	}

	//Axis Type : axisX, axisY
	this.type = type;
	if (type === "axisX" && (!options || typeof options.gridThickness === "undefined")) this.gridThickness = 0;

	this._position = position;

	this.lineCoordinates = {
		x1: null, y1: null, x2: null, y2: null, width: null
	}; //{x1:, y1:, x2:, y2:, width:}
	//
	{
		this.labelAngle = (this.labelAngle % 360 + 360) % 360;

		if (this.labelAngle > 90 && this.labelAngle <= 270) this.labelAngle -= 180;else if (this.labelAngle > 180 && this.labelAngle <= 270) this.labelAngle -= 180;else if (this.labelAngle > 270 && this.labelAngle <= 360) this.labelAngle -= 360;
	}

	if (this._options.stripLines && this._options.stripLines.length > 0) {

		this.stripLines = [];

		for (var i = 0; i < this._options.stripLines.length; i++) {
			this.stripLines.push(new StripLine(this.chart, this._options.stripLines[i], chart.theme, ++this.chart._eventManager.lastObjectId, this));
		}
	}

	this._titleTextBlock = null;

	if (!this.hasOptionChanged("viewportMinimum") && !isNaN(this.sessionVariables.newViewportMinimum) && this.sessionVariables.newViewportMinimum !== null) this.viewportMinimum = this.sessionVariables.newViewportMinimum;else this.sessionVariables.newViewportMinimum = null;

	if (!this.hasOptionChanged("viewportMaximum") && !isNaN(this.sessionVariables.newViewportMaximum) && this.sessionVariables.newViewportMaximum !== null) this.viewportMaximum = this.sessionVariables.newViewportMaximum;else this.sessionVariables.newViewportMaximum = null;

	if (this.minimum !== null && this.viewportMinimum !== null) this.viewportMinimum = Math.max(this.viewportMinimum, this.minimum);

	if (this.maximum !== null && this.viewportMaximum !== null) this.viewportMaximum = Math.min(this.viewportMaximum, this.maximum);

	this.trackChanges("viewportMinimum");
	this.trackChanges("viewportMaximum");
}

(0, _utils.extend)(Axis, _canvasjs2.default);

Axis.prototype.createLabels = function () {

	var textBlock;
	var i = 0;
	var endPoint;

	var labelMaxWidth = 0;
	var labelMaxHeight = 0;
	var intervalInPixels = 0;

	//var intervalInPixels = this.conversionParameters.pixelPerUnit * this.interval;


	if (this._position === "bottom" || this._position === "top") {
		intervalInPixels = this.lineCoordinates.width / Math.abs(this.viewportMaximum - this.viewportMinimum) * this.interval;

		if (this.labelAutoFit) {
			labelMaxWidth = typeof this._options.labelMaxWidth === "undefined" ? intervalInPixels * .9 >> 0 : this.labelMaxWidth;
		} else {
			labelMaxWidth = typeof this._options.labelMaxWidth === "undefined" ? this.chart.width * .7 >> 0 : this.labelMaxWidth;
		}

		labelMaxHeight = typeof this._options.labelWrap === "undefined" || this.labelWrap ? this.chart.height * .5 >> 0 : this.labelFontSize * 1.5;
	} else if (this._position === "left" || this._position === "right") {

		intervalInPixels = this.lineCoordinates.height / Math.abs(this.viewportMaximum - this.viewportMinimum) * this.interval;

		if (this.labelAutoFit) {
			labelMaxWidth = typeof this._options.labelMaxWidth === "undefined" ? this.chart.width * .3 >> 0 : this.labelMaxWidth;
		} else {
			labelMaxWidth = typeof this._options.labelMaxWidth === "undefined" ? this.chart.width * .5 >> 0 : this.labelMaxWidth;
		}

		labelMaxHeight = typeof this._options.labelWrap === "undefined" || this.labelWrap ? intervalInPixels * 2 >> 0 : this.labelFontSize * 1.5;
	}

	if (this.type === "axisX" && this.chart.plotInfo.axisXValueType === "dateTime") {
		endPoint = addToDateTime(new Date(this.viewportMaximum), this.interval, this.intervalType);
		//endPoint = this.viewportMaximum;

		for (i = this.intervalStartPosition; i < endPoint; addToDateTime(i, this.interval, this.intervalType)) {

			//var text = dateFormat(i, this.valueFormatString);
			var timeInMilliseconds = i.getTime();
			var text = this.labelFormatter ? this.labelFormatter({ chart: this.chart, axis: this._options, value: i, label: this.labels[i] ? this.labels[i] : null }) : this.type === "axisX" && this.labels[timeInMilliseconds] ? this.labels[timeInMilliseconds] : dateFormat(i, this.valueFormatString, this.chart._cultureInfo);

			textBlock = new _text_block2.default(this.ctx, {
				x: 0,
				y: 0,
				//maxWidth: this.maxHeight,
				//maxHeight: this.labelFontSize,
				maxWidth: labelMaxWidth,
				maxHeight: labelMaxHeight,
				angle: this.labelAngle,
				text: this.prefix + text + this.suffix,
				horizontalAlign: "left", //left, center, right
				fontSize: this.labelFontSize, //in pixels
				fontFamily: this.labelFontFamily,
				fontWeight: this.labelFontWeight, //normal, bold, bolder, lighter,
				fontColor: this.labelFontColor,
				fontStyle: this.labelFontStyle, // normal, italic, oblique
				textBaseline: "middle"
			});

			this._labels.push({ position: i.getTime(), textBlock: textBlock, effectiveHeight: null });
		}
	} else {
		endPoint = this.viewportMaximum;

		//if ((Math.floor(this.interval) < this.interval && !this._options.interval) || true) {

		//Check if it should be rendered as a category axis. If yes, then ceil the interval
		if (this.labels && this.labels.length) {
			var tempInterval = Math.ceil(this.interval);
			var tempStartPoint = Math.ceil(this.intervalStartPosition);
			var hasAllLabels = false;
			for (i = tempStartPoint; i < this.viewportMaximum; i += tempInterval) {
				if (this.labels[i]) {
					hasAllLabels = true;
				} else {
					hasAllLabels = false;
					break;
				}
			}

			if (hasAllLabels) {
				this.interval = tempInterval;
				this.intervalStartPosition = tempStartPoint;
			}
		}

		//parseFloat & toPrecision are being used to avoid issues related to precision.
		for (i = this.intervalStartPosition; i <= endPoint; i = parseFloat((i + this.interval).toFixed(14))) {

			var text = this.labelFormatter ? this.labelFormatter({ chart: this.chart, axis: this._options, value: i, label: this.labels[i] ? this.labels[i] : null }) : this.type === "axisX" && this.labels[i] ? this.labels[i] : (0, _utils.numberFormat)(i, this.valueFormatString, this.chart._cultureInfo);

			textBlock = new _text_block2.default(this.ctx, {
				x: 0,
				y: 0,
				//maxWidth: this.maxHeight,
				//maxHeight: this.labelFontSize,
				maxWidth: labelMaxWidth,
				maxHeight: labelMaxHeight,
				angle: this.labelAngle,
				text: this.prefix + text + this.suffix,
				horizontalAlign: "left", //left, center, right
				fontSize: this.labelFontSize, //in pixels
				fontFamily: this.labelFontFamily,
				fontWeight: this.labelFontWeight, //normal, bold, bolder, lighter,
				fontColor: this.labelFontColor,
				fontStyle: this.labelFontStyle, // normal, italic, oblique
				textBaseline: "middle",
				borderThickness: 0
			});

			this._labels.push({ position: i, textBlock: textBlock, effectiveHeight: null });
		}
	}

	for (var i = 0; i < this.stripLines.length; i++) {

		var stripLine = this.stripLines[i];

		textBlock = new _text_block2.default(this.ctx, {
			x: 0,
			y: 0,
			//maxWidth: this.maxHeight,
			//maxHeight: this.labelFontSize,
			backgroundColor: stripLine.labelBackgroundColor,
			maxWidth: labelMaxWidth,
			maxHeight: labelMaxHeight,
			angle: this.labelAngle,
			text: stripLine.labelFormatter ? stripLine.labelFormatter({ chart: this.chart, axis: this, stripLine: stripLine }) : stripLine.label,
			horizontalAlign: "left", //left, center, right
			fontSize: stripLine.labelFontSize, //in pixels
			fontFamily: stripLine.labelFontFamily,
			fontWeight: stripLine.labelFontWeight, //normal, bold, bolder, lighter,
			fontColor: stripLine._options.labelFontColor || stripLine.color,
			fontStyle: stripLine.labelFontStyle, // normal, italic, oblique
			textBaseline: "middle",
			borderThickness: 0
		});

		this._labels.push({ position: stripLine.value, textBlock: textBlock, effectiveHeight: null, stripLine: stripLine });
	}
};

Axis.prototype.createLabelsAndCalculateWidth = function () {

	var maxLabelEffectiveWidth = 0;
	this._labels = [];

	if (this._position === "left" || this._position === "right") {

		this.createLabels();

		for (var i = 0; i < this._labels.length; i++) {

			var textBlock = this._labels[i].textBlock;

			var size = textBlock.measureText();

			//var hypotenuse = Math.sqrt(Math.pow(size.height / 2, 2) + Math.pow(size.width, 2));
			//labelEffectiveWidth = hypotenuse * Math.cos(Math.abs(Math.PI / 180 * this.labelAngle) - Math.abs(Math.acos(size.width / hypotenuse)));

			var labelEffectiveWidth = 0;

			if (this.labelAngle === 0) labelEffectiveWidth = size.width;else labelEffectiveWidth = size.width * Math.cos(Math.PI / 180 * Math.abs(this.labelAngle)) + size.height / 2 * Math.sin(Math.PI / 180 * Math.abs(this.labelAngle));

			if (maxLabelEffectiveWidth < labelEffectiveWidth) maxLabelEffectiveWidth = labelEffectiveWidth;

			this._labels[i].effectiveWidth = labelEffectiveWidth;
		}
	}

	var titleHeight = this.title ? getFontHeightInPixels(this.titleFontFamily, this.titleFontSize, this.titleFontWeight) + 2 : 0;

	var axisWidth = titleHeight + maxLabelEffectiveWidth + this.tickLength + 5;

	//if (isDebugMode && window.console) {
	//	window.console.log(this.type + "--- axisWidth: " + axisWidth);
	//}

	return axisWidth;
};

Axis.prototype.createLabelsAndCalculateHeight = function () {
	var maxLabelEffectiveHeight = 0;
	this._labels = [];
	var textBlock;
	var i = 0;

	this.createLabels();

	if (this._position === "bottom" || this._position === "top") {

		for (i = 0; i < this._labels.length; i++) {

			textBlock = this._labels[i].textBlock;

			var size = textBlock.measureText();
			//var diagonal = Math.sqrt(Math.pow(size.height, 2) + Math.pow(size.width, 2));

			//var hypotenuse = Math.sqrt(Math.pow(size.height / 2, 2) + Math.pow(size.width, 2));
			//var labelEffectiveHeight = hypotenuse * Math.cos(Math.PI / 2 - (Math.abs(Math.PI / 180 * this.labelAngle) + Math.abs(Math.acos(size.width / hypotenuse))));

			var labelEffectiveHeight = 0;

			if (this.labelAngle === 0) labelEffectiveHeight = size.height;else labelEffectiveHeight = size.width * Math.sin(Math.PI / 180 * Math.abs(this.labelAngle)) + size.height / 2 * Math.cos(Math.PI / 180 * Math.abs(this.labelAngle));

			if (maxLabelEffectiveHeight < labelEffectiveHeight) maxLabelEffectiveHeight = labelEffectiveHeight;

			this._labels[i].effectiveHeight = labelEffectiveHeight;
		}
	}

	//var titleHeight = this.title ? this.titleFontSize + 5 : 0;
	var titleHeight = this.title ? getFontHeightInPixels(this.titleFontFamily, this.titleFontSize, this.titleFontWeight) + 2 : 0;

	return titleHeight + maxLabelEffectiveHeight + this.tickLength + 5;
};

//Static Method that co-ordinates between axisX, axisY and renders them
Axis.setLayoutAndRender = function (axisX, axisY, axisY2, axisPlacement, freeSpace) {
	var x1, y1, x2, y2;
	var chart = axisX.chart;
	var ctx = chart.ctx;

	axisX.calculateAxisParameters();

	if (axisY) axisY.calculateAxisParameters();

	if (axisY2) axisY2.calculateAxisParameters();

	//if (axisY && axisY2 && typeof (axisY._options.viewportMaximum) === "undefined" && typeof (axisY._options.viewportMinimum) === "undefined" && typeof (axisY._options.interval) === "undefined"
	//		&& typeof (axisY2._options.viewportMaximum) === "undefined" && typeof (axisY2._options.viewportMinimum) === "undefined" && typeof (axisY2._options.interval) === "undefined") {

	//	var noTicksY = (axisY.viewportMaximum - axisY.viewportMinimum) / axisY.interval;

	//	var noTicksY2 = (axisY2.viewportMaximum - axisY2.viewportMinimum) / axisY2.interval;

	//	if (noTicksY > noTicksY2) {
	//		axisY2.viewportMaximum = axisY2.interval * noTicksY + axisY2.viewportMinimum;
	//	} else if (noTicksY2 > noTicksY) {
	//		axisY.viewportMaximum = axisY.interval * noTicksY2 + axisY.viewportMinimum;
	//	}
	//}

	var axisYlineThickness = axisY ? axisY.lineThickness ? axisY.lineThickness : 0 : 0;
	var axisY2lineThickness = axisY2 ? axisY2.lineThickness ? axisY2.lineThickness : 0 : 0;

	var axisYGridThickness = axisY ? axisY.gridThickness ? axisY.gridThickness : 0 : 0;
	var axisY2GridThickness = axisY2 ? axisY2.gridThickness ? axisY2.gridThickness : 0 : 0;

	var axisYMargin = axisY ? axisY.margin : 0;
	var axisY2Margin = axisY ? axisY.margin : 0;

	if (axisPlacement === "normal") {

		axisX.lineCoordinates = {};

		var axisYWidth = Math.ceil(axisY ? axisY.createLabelsAndCalculateWidth() : 0);
		x1 = Math.round(freeSpace.x1 + axisYWidth + axisYMargin);
		axisX.lineCoordinates.x1 = x1;

		var axisY2Width = Math.ceil(axisY2 ? axisY2.createLabelsAndCalculateWidth() : 0);
		x2 = Math.round(freeSpace.x2 - axisY2Width > axisX.chart.width - 10 ? axisX.chart.width - 10 : freeSpace.x2 - axisY2Width);
		axisX.lineCoordinates.x2 = x2;

		axisX.lineCoordinates.width = Math.abs(x2 - x1); // required early on inside createLabels of axisX

		var axisXHeight = Math.ceil(axisX.createLabelsAndCalculateHeight());

		// Position axisX based on the available free space, Margin and its height
		//x1 = freeSpace.x1 + axisYWidth + axisYMargin + axisYlineThickness / 2;
		y1 = Math.round(freeSpace.y2 - axisXHeight - axisX.margin);
		y2 = Math.round(freeSpace.y2 - axisX.margin);

		//axisX.lineCoordinates = { x1: x1, y1: y1, x2: x2, y2: y1, width: Math.abs(x2 - x1) }
		axisX.lineCoordinates.y1 = y1;
		axisX.lineCoordinates.y2 = y1;

		axisX.boundingRect = {
			x1: x1, y1: y1, x2: x2, y2: y2, width: x2 - x1, height: y2 - y1
		};

		//if (isDebugMode) {
		//	axisX.ctx.rect(axisX.boundingRect.x1, axisX.boundingRect.y1, axisX.boundingRect.width, axisX.boundingRect.height);
		//	axisX.ctx.stroke();
		//}

		// Position axisY based on the available free space, Margin and its height
		if (axisY) {
			x1 = Math.round(freeSpace.x1 + axisY.margin);
			y1 = Math.round(freeSpace.y1 < 10 ? 10 : freeSpace.y1);
			x2 = Math.round(freeSpace.x1 + axisYWidth + axisY.margin);
			//y2 = freeSpace.y2 - axisXHeight - axisX.margin - axisX.lineThickness / 2;
			y2 = Math.round(freeSpace.y2 - axisXHeight - axisX.margin);

			axisY.lineCoordinates = {
				x1: x2, y1: y1, x2: x2, y2: y2, height: Math.abs(y2 - y1)
			};

			axisY.boundingRect = {
				x1: x1, y1: y1, x2: x2, y2: y2, width: x2 - x1, height: y2 - y1
			};
		}

		//if (isDebugMode && axisY) {
		//	axisY.ctx.rect(axisY.boundingRect.x1, axisY.boundingRect.y1, axisY.boundingRect.width, axisY.boundingRect.height);
		//	axisY.ctx.stroke();
		//}

		// Position axisY2 based on the available free space, Margin and its height
		if (axisY2) {
			x1 = Math.round(axisX.lineCoordinates.x2);
			y1 = Math.round(freeSpace.y1 < 10 ? 10 : freeSpace.y1);
			x2 = Math.round(x1 + axisY2Width + axisY2.margin);
			//y2 = freeSpace.y2 - axisXHeight - axisX.margin - axisX.lineThickness / 2;
			y2 = Math.round(freeSpace.y2 - axisXHeight - axisX.margin);

			axisY2.lineCoordinates = {
				x1: x1, y1: y1, x2: x1, y2: y2, height: Math.abs(y2 - y1)
			};

			axisY2.boundingRect = {
				x1: x1, y1: y1, x2: x2, y2: y2, width: x2 - x1, height: y2 - y1
			};
		}

		axisX.calculateValueToPixelConversionParameters();

		if (axisY) axisY.calculateValueToPixelConversionParameters();

		if (axisY2) axisY2.calculateValueToPixelConversionParameters();

		ctx.save();
		ctx.rect(5, axisX.boundingRect.y1, axisX.chart.width - 10, axisX.boundingRect.height);
		ctx.clip();

		axisX.renderLabelsTicksAndTitle();
		ctx.restore();

		if (axisY) axisY.renderLabelsTicksAndTitle();

		if (axisY2) axisY2.renderLabelsTicksAndTitle();

		chart.preparePlotArea();
		var plotArea = axisX.chart.plotArea;

		ctx.save();

		ctx.rect(plotArea.x1, plotArea.y1, Math.abs(plotArea.x2 - plotArea.x1), Math.abs(plotArea.y2 - plotArea.y1));

		ctx.clip();

		axisX.renderStripLinesOfThicknessType("value");

		if (axisY) axisY.renderStripLinesOfThicknessType("value");

		if (axisY2) axisY2.renderStripLinesOfThicknessType("value");

		axisX.renderInterlacedColors();

		if (axisY) axisY.renderInterlacedColors();

		if (axisY2) axisY2.renderInterlacedColors();

		ctx.restore();

		axisX.renderGrid();

		if (axisY) axisY.renderGrid();

		if (axisY2) axisY2.renderGrid();

		axisX.renderAxisLine();

		if (axisY) axisY.renderAxisLine();

		if (axisY2) axisY2.renderAxisLine();

		//No need to clip to plotArea because stripLines need to render on top of gridlines
		axisX.renderStripLinesOfThicknessType("pixel");

		if (axisY) axisY.renderStripLinesOfThicknessType("pixel");

		if (axisY2) axisY2.renderStripLinesOfThicknessType("pixel");
	} else {
		var axisXWidth = Math.ceil(axisX.createLabelsAndCalculateWidth());

		if (axisY) {
			axisY.lineCoordinates = {};

			x1 = Math.round(freeSpace.x1 + axisXWidth + axisX.margin);
			x2 = Math.round(freeSpace.x2 > axisY.chart.width - 10 ? axisY.chart.width - 10 : freeSpace.x2);

			axisY.lineCoordinates.x1 = x1;
			axisY.lineCoordinates.x2 = x2;
			axisY.lineCoordinates.width = Math.abs(x2 - x1);
		}

		if (axisY2) {
			axisY2.lineCoordinates = {};
			x1 = Math.round(freeSpace.x1 + axisXWidth + axisX.margin);
			x2 = Math.round(freeSpace.x2 > axisY2.chart.width - 10 ? axisY2.chart.width - 10 : freeSpace.x2);

			axisY2.lineCoordinates.x1 = x1;
			axisY2.lineCoordinates.x2 = x2;
			axisY2.lineCoordinates.width = Math.abs(x2 - x1);
		}

		var axisYHeight = Math.ceil(axisY ? axisY.createLabelsAndCalculateHeight() : 0);
		var axisY2Height = Math.ceil(axisY2 ? axisY2.createLabelsAndCalculateHeight() : 0);

		// Position axisY based on the available free space, Margin and its height
		if (axisY) {
			//x1 = freeSpace.x1 + axisXWidth + axisX.margin + axisX.lineThickness / 2;
			//x2 = freeSpace.x2 > axisY.chart.width - 10 ? axisY.chart.width - 10 : freeSpace.x2;

			y1 = Math.round(freeSpace.y2 - axisYHeight - axisY.margin);
			y2 = Math.round(freeSpace.y2 - axisYMargin > axisY.chart.height - 10 ? axisY.chart.height - 10 : freeSpace.y2 - axisYMargin);

			//axisY.lineCoordinates = { x1: x1, y1: y1, x2: x2, y2: y1, width: Math.abs(x2 - x1) }
			axisY.lineCoordinates.y1 = y1;
			axisY.lineCoordinates.y2 = y1;

			axisY.boundingRect = {
				x1: x1, y1: y1, x2: x2, y2: y2, width: x2 - x1, height: axisYHeight
			};
		}

		// Position axisY based on the available free space, Margin and its height
		if (axisY2) {
			//x1 = freeSpace.x1 + axisXWidth + axisX.margin + axisX.lineThickness / 2;
			//x2 = freeSpace.x2 > axisY2.chart.width - 10 ? axisY2.chart.width - 10 : freeSpace.x2;

			y1 = Math.round(freeSpace.y1 + axisY2.margin);
			y2 = freeSpace.y1 + axisY2.margin + axisY2Height;

			//axisY2.lineCoordinates = { x1: x1, y1: y2, x2: x2, y2: y2, width: Math.abs(x2 - x1) }
			axisY2.lineCoordinates.y1 = y2;
			axisY2.lineCoordinates.y2 = y2;

			axisY2.boundingRect = {
				x1: x1, y1: y1, x2: x2, y2: y2, width: x2 - x1, height: axisY2Height
			};
		}

		//axisY.ctx.rect(axisY.boundingRect.x1, axisY.boundingRect.y1, axisY.boundingRect.width, axisY.boundingRect.height);
		//axisY.ctx.stroke();

		// Position axisX based on the available free space, Margin and its height
		x1 = Math.round(freeSpace.x1 + axisX.margin);
		y1 = Math.round(axisY2 ? axisY2.lineCoordinates.y2 : freeSpace.y1 < 10 ? 10 : freeSpace.y1);
		x2 = Math.round(freeSpace.x1 + axisXWidth + axisX.margin);
		y2 = Math.round(axisY ? axisY.lineCoordinates.y1 : freeSpace.y2 - axisYMargin > axisX.chart.height - 10 ? axisX.chart.height - 10 : freeSpace.y2 - axisYMargin);

		axisX.lineCoordinates = {
			x1: x2, y1: y1, x2: x2, y2: y2, height: Math.abs(y2 - y1)
		};

		axisX.boundingRect = {
			x1: x1, y1: y1, x2: x2, y2: y2, width: x2 - x1, height: y2 - y1
		};

		//axisX.ctx.rect(axisX.boundingRect.x1, axisX.boundingRect.y1, axisX.boundingRect.width, axisX.boundingRect.height);
		//axisX.ctx.stroke();

		axisX.calculateValueToPixelConversionParameters();

		if (axisY) axisY.calculateValueToPixelConversionParameters();
		if (axisY2) axisY2.calculateValueToPixelConversionParameters();

		//ctx.save();
		//ctx.rect(axisY.boundingRect.x1 - 30, axisY.boundingRect.y1, axisY.boundingRect.width + 60, axisY.boundingRect.height);
		//ctx.clip();

		if (axisY) axisY.renderLabelsTicksAndTitle();

		if (axisY2) axisY2.renderLabelsTicksAndTitle();

		//ctx.restore();

		axisX.renderLabelsTicksAndTitle();

		chart.preparePlotArea();
		var plotArea = axisX.chart.plotArea;

		ctx.save();
		ctx.rect(plotArea.x1, plotArea.y1, Math.abs(plotArea.x2 - plotArea.x1), Math.abs(plotArea.y2 - plotArea.y1));

		ctx.clip();

		//No need to clip to plotArea because stripLines need to render on top of gridlines
		axisX.renderStripLinesOfThicknessType("value");

		if (axisY) axisY.renderStripLinesOfThicknessType("value");
		if (axisY2) axisY2.renderStripLinesOfThicknessType("value");

		axisX.renderInterlacedColors();

		if (axisY) axisY.renderInterlacedColors();
		if (axisY2) axisY2.renderInterlacedColors();

		ctx.restore();

		axisX.renderGrid();

		if (axisY) axisY.renderGrid();

		if (axisY2) axisY2.renderGrid();

		axisX.renderAxisLine();

		if (axisY) axisY.renderAxisLine();

		if (axisY2) axisY2.renderAxisLine();

		axisX.renderStripLinesOfThicknessType("pixel");

		if (axisY) axisY.renderStripLinesOfThicknessType("pixel");
		if (axisY2) axisY2.renderStripLinesOfThicknessType("pixel");
	}
};

Axis.prototype.renderLabelsTicksAndTitle = function () {

	var skipLabels = false;
	var totalLabelWidth = 0;
	var thresholdRatio = 1;
	var labelCount = 0;

	var intervalInPixels = this.conversionParameters.pixelPerUnit * this.interval;

	if (this.labelAngle !== 0 && this.labelAngle !== 360) thresholdRatio = 1.2;

	//Don't skip labels when interval is explicitely set
	if (typeof this._options.interval === "undefined") {
		if (this._position === "bottom" || this._position === "top") {

			//thresholdRatio = .9;// More space is preferred between labels when axis is horizontally aligned

			for (i = 0; i < this._labels.length; i++) {
				label = this._labels[i];
				if (label.position < this.viewportMinimum || label.stripLine) // don't consider stripLine's lable
					continue;

				var width = label.textBlock.width * Math.cos(Math.PI / 180 * this.labelAngle) + label.textBlock.height * Math.sin(Math.PI / 180 * this.labelAngle);

				totalLabelWidth += width;
			}

			if (totalLabelWidth > this.lineCoordinates.width * thresholdRatio) {
				skipLabels = true;
			}
		}if (this._position === "left" || this._position === "right") {
			for (i = 0; i < this._labels.length; i++) {
				label = this._labels[i];
				if (label.position < this.viewportMinimum || label.stripLine) // don't consider stripLine's lable
					continue;

				var width = label.textBlock.height * Math.cos(Math.PI / 180 * this.labelAngle) + label.textBlock.width * Math.sin(Math.PI / 180 * this.labelAngle);

				totalLabelWidth += width;
			}

			if (totalLabelWidth > this.lineCoordinates.height * thresholdRatio) {
				skipLabels = true;
			}
		}
	}

	if (this._position === "bottom") {
		var i = 0;

		var label;
		var xy;

		for (i = 0; i < this._labels.length; i++) {

			label = this._labels[i];
			if (label.position < this.viewportMinimum || label.position > this.viewportMaximum) continue;

			xy = this.getPixelCoordinatesOnAxis(label.position);

			if (this.tickThickness && !this._labels[i].stripLine || this._labels[i].stripLine && this._labels[i].stripLine._thicknessType === "pixel") {

				if (this._labels[i].stripLine) {
					stripLine = this._labels[i].stripLine;
					this.ctx.lineWidth = stripLine.thickness;
					this.ctx.strokeStyle = stripLine.color;
				} else {
					this.ctx.lineWidth = this.tickThickness;
					this.ctx.strokeStyle = this.tickColor;
				}

				var tickX = this.ctx.lineWidth % 2 === 1 ? (xy.x << 0) + .5 : xy.x << 0;
				this.ctx.beginPath();
				this.ctx.moveTo(tickX, xy.y << 0);
				this.ctx.lineTo(tickX, xy.y + this.tickLength << 0);
				this.ctx.stroke();
			}

			//Don't skip stripLine's labels
			if (skipLabels && labelCount++ % 2 !== 0 && !this._labels[i].stripLine) continue;

			if (label.textBlock.angle === 0) {
				xy.x -= label.textBlock.width / 2;
				//xy.y += this.tickLength + label.textBlock.height / 2;
				xy.y += this.tickLength + label.textBlock.fontSize / 2;
			} else {
				xy.x -= this.labelAngle < 0 ? label.textBlock.width * Math.cos(Math.PI / 180 * this.labelAngle) : 0;
				xy.y += this.tickLength + Math.abs(this.labelAngle < 0 ? label.textBlock.width * Math.sin(Math.PI / 180 * this.labelAngle) - 5 : 5);
			}
			label.textBlock.x = xy.x;
			label.textBlock.y = xy.y;

			label.textBlock.render(true);
		}

		if (this.title) {

			this._titleTextBlock = new _text_block2.default(this.ctx, {
				x: this.lineCoordinates.x1, // This is recalculated again
				y: this.boundingRect.y2 - this.titleFontSize - 5, // This is recalculated again
				maxWidth: this.lineCoordinates.width,
				maxHeight: this.titleFontSize * 1.5,
				angle: 0,
				text: this.title,
				horizontalAlign: "center", //left, center, right
				fontSize: this.titleFontSize, //in pixels
				fontFamily: this.titleFontFamily,
				fontWeight: this.titleFontWeight, //normal, bold, bolder, lighter,
				fontColor: this.titleFontColor,
				fontStyle: this.titleFontStyle, // normal, italic, oblique
				textBaseline: "top"
			});

			this._titleTextBlock.measureText();
			this._titleTextBlock.x = this.lineCoordinates.x1 + this.lineCoordinates.width / 2 - this._titleTextBlock.width / 2;
			this._titleTextBlock.y = this.boundingRect.y2 - this._titleTextBlock.height - 3;
			this._titleTextBlock.render(true);
		}
	} else if (this._position === "top") {
		var i = 0;

		var label;
		var xy;
		var stripLine;

		for (i = 0; i < this._labels.length; i++) {
			label = this._labels[i];
			if (label.position < this.viewportMinimum || label.position > this.viewportMaximum) continue;

			xy = this.getPixelCoordinatesOnAxis(label.position);

			if (this.tickThickness && !this._labels[i].stripLine || this._labels[i].stripLine && this._labels[i].stripLine._thicknessType === "pixel") {

				if (this._labels[i].stripLine) {
					stripLine = this._labels[i].stripLine;

					this.ctx.lineWidth = stripLine.thickness;
					this.ctx.strokeStyle = stripLine.color;
				} else {
					this.ctx.lineWidth = this.tickThickness;
					this.ctx.strokeStyle = this.tickColor;
				}

				var tickX = this.ctx.lineWidth % 2 === 1 ? (xy.x << 0) + .5 : xy.x << 0;
				this.ctx.beginPath();
				this.ctx.moveTo(tickX, xy.y << 0);
				this.ctx.lineTo(tickX, xy.y - this.tickLength << 0);
				this.ctx.stroke();
			}

			//Don't skip stripLine's labels
			if (skipLabels && labelCount++ % 2 !== 0 && !this._labels[i].stripLine) continue;

			if (label.textBlock.angle === 0) {
				xy.x -= label.textBlock.width / 2;
				xy.y -= this.tickLength + label.textBlock.height / 2;
			} else {
				xy.x -= this.labelAngle > 0 ? label.textBlock.width * Math.cos(Math.PI / 180 * this.labelAngle) : 0;
				xy.y -= this.tickLength + Math.abs(this.labelAngle > 0 ? label.textBlock.width * Math.sin(Math.PI / 180 * this.labelAngle) + 5 : 5);
			}
			label.textBlock.x = xy.x;
			label.textBlock.y = xy.y;

			label.textBlock.render(true);
		}

		if (this.title) {

			this._titleTextBlock = new _text_block2.default(this.ctx, {
				x: this.lineCoordinates.x1, // This is recalculated again
				y: this.boundingRect.y1 + 1,
				maxWidth: this.lineCoordinates.width,
				maxHeight: this.titleFontSize * 1.5,
				angle: 0,
				text: this.title,
				horizontalAlign: "center", //left, center, right
				fontSize: this.titleFontSize, //in pixels
				fontFamily: this.titleFontFamily,
				fontWeight: this.titleFontWeight, //normal, bold, bolder, lighter,
				fontColor: this.titleFontColor,
				fontStyle: this.titleFontStyle, // normal, italic, oblique
				textBaseline: "top"
			});

			this._titleTextBlock.measureText();
			this._titleTextBlock.x = this.lineCoordinates.x1 + this.lineCoordinates.width / 2 - this._titleTextBlock.width / 2;
			this._titleTextBlock.render(true);
		}
	} else if (this._position === "left") {

		var label;
		var xy;
		for (var i = 0; i < this._labels.length; i++) {
			label = this._labels[i];
			if (label.position < this.viewportMinimum || label.position > this.viewportMaximum) continue;

			xy = this.getPixelCoordinatesOnAxis(label.position);

			if (this.tickThickness && !this._labels[i].stripLine || this._labels[i].stripLine && this._labels[i].stripLine._thicknessType === "pixel") {

				if (this._labels[i].stripLine) {
					stripLine = this._labels[i].stripLine;

					this.ctx.lineWidth = stripLine.thickness;
					this.ctx.strokeStyle = stripLine.color;
				} else {
					this.ctx.lineWidth = this.tickThickness;
					this.ctx.strokeStyle = this.tickColor;
				}

				var tickY = this.ctx.lineWidth % 2 === 1 ? (xy.y << 0) + .5 : xy.y << 0;
				this.ctx.beginPath();
				this.ctx.moveTo(xy.x << 0, tickY);
				this.ctx.lineTo(xy.x - this.tickLength << 0, tickY);
				this.ctx.stroke();
			}

			//Don't skip stripLine's labels
			if (skipLabels && labelCount++ % 2 !== 0 && !this._labels[i].stripLine) continue;

			label.textBlock.x = xy.x - label.textBlock.width * Math.cos(Math.PI / 180 * this.labelAngle) - this.tickLength - 5;

			if (this.labelAngle === 0) {
				label.textBlock.y = xy.y;
			} else label.textBlock.y = xy.y - label.textBlock.width * Math.sin(Math.PI / 180 * this.labelAngle);

			label.textBlock.render(true);
		}

		if (this.title) {

			this._titleTextBlock = new _text_block2.default(this.ctx, {
				x: this.boundingRect.x1 + 1,
				y: this.lineCoordinates.y2,
				maxWidth: this.lineCoordinates.height,
				maxHeight: this.titleFontSize * 1.5,
				angle: -90,
				text: this.title,
				horizontalAlign: "center", //left, center, right
				fontSize: this.titleFontSize, //in pixels
				fontFamily: this.titleFontFamily,
				fontWeight: this.titleFontWeight, //normal, bold, bolder, lighter,
				fontColor: this.titleFontColor,
				fontStyle: this.titleFontStyle, // normal, italic, oblique
				textBaseline: "top"
			});

			var size = this._titleTextBlock.measureText();

			//this._titleTextBlock.x -= 4;

			this._titleTextBlock.y = this.lineCoordinates.height / 2 + this._titleTextBlock.width / 2 + this.lineCoordinates.y1;
			this._titleTextBlock.render(true);

			//if (isDebugMode) {
			//	window.console.log("titleFontSize: " + this.titleFontSize + "; width: " + size.width + "; height: " + size.height);
			//	window.console.log("this.boundingRect.x1: " + this.boundingRect.x1);

			//	//this.ctx.rect(this._titleTextBlock.x, this._titleTextBlock.y, this._titleTextBlock.height, -this._titleTextBlock.width);
			//	//this.ctx.stroke();

			//}
		}
	} else if (this._position === "right") {

		var label;
		var xy;

		for (var i = 0; i < this._labels.length; i++) {
			label = this._labels[i];
			if (label.position < this.viewportMinimum || label.position > this.viewportMaximum) continue;

			xy = this.getPixelCoordinatesOnAxis(label.position);

			if (this.tickThickness && !this._labels[i].stripLine || this._labels[i].stripLine && this._labels[i].stripLine._thicknessType === "pixel") {

				if (this._labels[i].stripLine) {
					stripLine = this._labels[i].stripLine;

					this.ctx.lineWidth = stripLine.thickness;
					this.ctx.strokeStyle = stripLine.color;
				} else {
					this.ctx.lineWidth = this.tickThickness;
					this.ctx.strokeStyle = this.tickColor;
				}

				var tickY = this.ctx.lineWidth % 2 === 1 ? (xy.y << 0) + .5 : xy.y << 0;
				this.ctx.beginPath();
				this.ctx.moveTo(xy.x << 0, tickY);
				this.ctx.lineTo(xy.x + this.tickLength << 0, tickY);
				this.ctx.stroke();
			}

			//Don't skip stripLine's labels
			if (skipLabels && labelCount++ % 2 !== 0 && !this._labels[i].stripLine) continue;

			label.textBlock.x = xy.x + this.tickLength + 5;
			//label.textBlock.y = xy.y - (label.textBlock.width * Math.sin(Math.PI / 180 * this.labelAngle));
			if (this.labelAngle === 0) {
				label.textBlock.y = xy.y;
			} else label.textBlock.y = xy.y;

			label.textBlock.render(true);
		}

		if (this.title) {

			this._titleTextBlock = new _text_block2.default(this.ctx, {
				x: this.boundingRect.x2 - 1,
				y: this.lineCoordinates.y2,
				maxWidth: this.lineCoordinates.height,
				maxHeight: this.titleFontSize * 1.5,
				angle: 90,
				text: this.title,
				horizontalAlign: "center", //left, center, right
				fontSize: this.titleFontSize, //in pixels
				fontFamily: this.titleFontFamily,
				fontWeight: this.titleFontWeight, //normal, bold, bolder, lighter,
				fontColor: this.titleFontColor,
				fontStyle: this.titleFontStyle, // normal, italic, oblique
				textBaseline: "top"
			});

			this._titleTextBlock.measureText();
			this._titleTextBlock.y = this.lineCoordinates.height / 2 - this._titleTextBlock.width / 2 + this.lineCoordinates.y1;
			this._titleTextBlock.render(true);
		}
	}
};

Axis.prototype.renderInterlacedColors = function () {
	var ctx = this.chart.plotArea.ctx;
	//return;

	var interlacedGridStartPoint;
	var interlacedGridEndPoint;
	var plotAreaCoordinates = this.chart.plotArea;
	var i = 0,
	    renderInterlacedGrid = true;

	if ((this._position === "bottom" || this._position === "top") && this.interlacedColor) {

		ctx.fillStyle = this.interlacedColor;

		for (i = 0; i < this._labels.length; i++) {

			if (this._labels[i].stripLine) continue;

			if (renderInterlacedGrid) {
				//So that the interlaced color alternates
				interlacedGridStartPoint = this.getPixelCoordinatesOnAxis(this._labels[i].position);

				if (i + 1 >= this._labels.length - 1) interlacedGridEndPoint = this.getPixelCoordinatesOnAxis(this.viewportMaximum);else interlacedGridEndPoint = this.getPixelCoordinatesOnAxis(this._labels[i + 1].position);

				ctx.fillRect(interlacedGridStartPoint.x, plotAreaCoordinates.y1, Math.abs(interlacedGridEndPoint.x - interlacedGridStartPoint.x), Math.abs(plotAreaCoordinates.y1 - plotAreaCoordinates.y2));
				renderInterlacedGrid = false;
			} else renderInterlacedGrid = true;
		}
	} else if ((this._position === "left" || this._position === "right") && this.interlacedColor) {

		ctx.fillStyle = this.interlacedColor;

		for (i = 0; i < this._labels.length; i++) {
			if (this._labels[i].stripLine) continue;

			if (renderInterlacedGrid) {
				//So that the interlaced color alternates

				interlacedGridEndPoint = this.getPixelCoordinatesOnAxis(this._labels[i].position);

				if (i + 1 >= this._labels.length - 1) interlacedGridStartPoint = this.getPixelCoordinatesOnAxis(this.viewportMaximum);else interlacedGridStartPoint = this.getPixelCoordinatesOnAxis(this._labels[i + 1].position);

				ctx.fillRect(plotAreaCoordinates.x1, interlacedGridStartPoint.y, Math.abs(plotAreaCoordinates.x1 - plotAreaCoordinates.x2), Math.abs(interlacedGridStartPoint.y - interlacedGridEndPoint.y));
				renderInterlacedGrid = false;
			} else renderInterlacedGrid = true;
		}
		//throw "123";
	}

	ctx.beginPath();
};

//Renders stripLines of given thickness type.
Axis.prototype.renderStripLinesOfThicknessType = function (thicknessType) {

	if (!(this.stripLines && this.stripLines.length > 0) || !thicknessType) return;

	var _this = this;

	var i = 0;
	for (i = 0; i < this.stripLines.length; i++) {

		var stripLine = this.stripLines[i];

		if (stripLine._thicknessType !== thicknessType) continue;

		//Should be skipped only if thicknessType is "pixel". If it is "value" then clipping is automatically applied before calling.
		if (thicknessType === "pixel" && (stripLine.value < this.viewportMinimum || stripLine.value > this.viewportMaximum)) continue;

		if (stripLine.showOnTop) {
			this.chart.addEventListener("dataAnimationIterationEnd", stripLine.render, stripLine);
		} else stripLine.render();
	}
};

Axis.prototype.renderGrid = function () {

	if (!(this.gridThickness && this.gridThickness > 0)) return;

	//var ctx = this.chart.plotArea.ctx;
	var ctx = this.chart.ctx;

	var xy;
	var plotAreaCoordinates = this.chart.plotArea;
	var stripLine;
	var tempLineWidth, tempStrokeStyle;
	//return;

	ctx.lineWidth = this.gridThickness;
	ctx.strokeStyle = this.gridColor;

	if (ctx.setLineDash) {
		ctx.setLineDash((0, _utils.getLineDashArray)(this.gridDashType, this.gridThickness));
	}

	if (this._position === "bottom" || this._position === "top") {

		for (i = 0; i < this._labels.length && !this._labels[i].stripLine; i++) {

			if (this._labels[i].position < this.viewportMinimum || this._labels[i].position > this.viewportMaximum) continue;

			ctx.beginPath();

			xy = this.getPixelCoordinatesOnAxis(this._labels[i].position);

			var gridX = ctx.lineWidth % 2 === 1 ? (xy.x << 0) + .5 : xy.x << 0;

			ctx.moveTo(gridX, plotAreaCoordinates.y1 << 0);
			ctx.lineTo(gridX, plotAreaCoordinates.y2 << 0);

			ctx.stroke();
		}
	} else if (this._position === "left" || this._position === "right") {

		for (var i = 0; i < this._labels.length && !this._labels[i].stripLine; i++) {

			if (i === 0 && this.type === "axisY" && this.chart.axisX && this.chart.axisX.lineThickness) continue;

			if (this._labels[i].position < this.viewportMinimum || this._labels[i].position > this.viewportMaximum) continue;

			ctx.beginPath();

			xy = this.getPixelCoordinatesOnAxis(this._labels[i].position);

			var gridY = ctx.lineWidth % 2 === 1 ? (xy.y << 0) + .5 : xy.y << 0;

			ctx.moveTo(plotAreaCoordinates.x1 << 0, gridY);
			ctx.lineTo(plotAreaCoordinates.x2 << 0, gridY);

			ctx.stroke();
		}
	}
};

Axis.prototype.renderAxisLine = function () {
	//var ctx = this.chart.plotArea.ctx;
	var ctx = this.chart.ctx;

	if (this._position === "bottom" || this._position === "top") {
		if (this.lineThickness) {
			ctx.lineWidth = this.lineThickness;
			ctx.strokeStyle = this.lineColor ? this.lineColor : "black";

			if (ctx.setLineDash) {
				ctx.setLineDash((0, _utils.getLineDashArray)(this.lineDashType, this.lineThickness));
			}

			var lineY = this.lineThickness % 2 === 1 ? (this.lineCoordinates.y1 << 0) + .5 : this.lineCoordinates.y1 << 0;

			ctx.beginPath();
			ctx.moveTo(this.lineCoordinates.x1, lineY);
			ctx.lineTo(this.lineCoordinates.x2, lineY);
			ctx.stroke();
		}
	} else if (this._position === "left" || this._position === "right") {
		if (this.lineThickness) {
			ctx.lineWidth = this.lineThickness;
			ctx.strokeStyle = this.lineColor;

			if (ctx.setLineDash) {
				ctx.setLineDash((0, _utils.getLineDashArray)(this.lineDashType, this.lineThickness));
			}

			var lineX = this.lineThickness % 2 === 1 ? (this.lineCoordinates.x1 << 0) + .5 : this.lineCoordinates.x1 << 0;

			ctx.beginPath();
			ctx.moveTo(lineX, this.lineCoordinates.y1);
			ctx.lineTo(lineX, this.lineCoordinates.y2);
			ctx.stroke();
		}
	}
};

Axis.prototype.getPixelCoordinatesOnAxis = function (value) {
	var xy = {};
	var width = this.lineCoordinates.width;
	var height = this.lineCoordinates.height;

	if (this._position === "bottom" || this._position === "top") {
		//var pixelPerUnit = width / Math.abs(this.viewportMaximum - this.viewportMinimum);
		var pixelPerUnit = this.conversionParameters.pixelPerUnit;

		//xy.x = this.lineCoordinates.x1 + (pixelPerUnit * (value - this.viewportMinimum));
		xy.x = this.conversionParameters.reference + pixelPerUnit * (value - this.viewportMinimum);
		xy.y = this.lineCoordinates.y1;
	}
	if (this._position === "left" || this._position === "right") {
		//var pixelPerUnit = height / Math.abs(this.viewportMaximum - this.viewportMinimum);
		var pixelPerUnit = -this.conversionParameters.pixelPerUnit;

		//xy.y = this.lineCoordinates.y2 - (pixelPerUnit * (value - this.viewportMinimum));
		xy.y = this.conversionParameters.reference - pixelPerUnit * (value - this.viewportMinimum);
		xy.x = this.lineCoordinates.x2;
	}

	return xy;
};

Axis.prototype.convertPixelToValue = function (pixel) {

	if (!pixel) return null;

	var value = 0;
	var p = this._position === "left" || this._position === "right" ? pixel.y : pixel.x;

	value = this.conversionParameters.minimum + (p - this.conversionParameters.reference) / this.conversionParameters.pixelPerUnit;

	return value;
};

Axis.prototype.setViewPortRange = function (viewportMinimum, viewportMaximum) {

	this.sessionVariables.newViewportMinimum = this.viewportMinimum = Math.min(viewportMinimum, viewportMaximum);
	this.sessionVariables.newViewportMaximum = this.viewportMaximum = Math.max(viewportMinimum, viewportMaximum);
};

Axis.prototype.getXValueAt = function (pixel) {
	if (!pixel) return null;

	var xval = null;

	if (this._position === "left") {
		xval = (this.chart.axisX.viewportMaximum - this.chart.axisX.viewportMinimum) / this.chart.axisX.lineCoordinates.height * (this.chart.axisX.lineCoordinates.y2 - pixel.y) + this.chart.axisX.viewportMinimum;
	} else if (this._position === "bottom") {
		xval = (this.chart.axisX.viewportMaximum - this.chart.axisX.viewportMinimum) / this.chart.axisX.lineCoordinates.width * (pixel.x - this.chart.axisX.lineCoordinates.x1) + this.chart.axisX.viewportMinimum;
	}

	return xval;
};

Axis.prototype.calculateValueToPixelConversionParameters = function (value) {
	this.reversed = false;

	var conversionParameters = {
		pixelPerUnit: null, minimum: null, reference: null
	};

	var width = this.lineCoordinates.width;
	var height = this.lineCoordinates.height;

	conversionParameters.minimum = this.viewportMinimum;

	if (this._position === "bottom" || this._position === "top") {
		conversionParameters.pixelPerUnit = (this.reversed ? -1 : 1) * width / Math.abs(this.viewportMaximum - this.viewportMinimum);
		conversionParameters.reference = this.reversed ? this.lineCoordinates.x2 : this.lineCoordinates.x1;
	}

	if (this._position === "left" || this._position === "right") {
		conversionParameters.pixelPerUnit = (this.reversed ? 1 : -1) * height / Math.abs(this.viewportMaximum - this.viewportMinimum);
		conversionParameters.reference = this.reversed ? this.lineCoordinates.y1 : this.lineCoordinates.y2;
	}

	this.conversionParameters = conversionParameters;
};

Axis.prototype.calculateAxisParameters = function () {

	var freeSpace = this.chart.layoutManager.getFreeSpace();
	var availableWidth = 0;
	var availableHeight = 0;
	var isLessThanTwoDataPoints = false;

	if (this._position === "bottom" || this._position === "top") {
		this.maxWidth = freeSpace.width;
		this.maxHeight = freeSpace.height;
	} else {
		this.maxWidth = freeSpace.height;
		this.maxHeight = freeSpace.width;
	}

	var noTicks = this.type === "axisX" ? this.maxWidth < 500 ? 8 : Math.max(6, Math.floor(this.maxWidth / 62)) : Math.max(Math.floor(this.maxWidth / 40), 2);
	var min, max;
	var minDiff;
	var range;
	var rangePadding = 0;

	if (this.viewportMinimum === null || isNaN(this.viewportMinimum)) this.viewportMinimum = this.minimum;

	if (this.viewportMaximum === null || isNaN(this.viewportMaximum)) this.viewportMaximum = this.maximum;

	if (this.type === "axisX") {
		min = this.viewportMinimum !== null ? this.viewportMinimum : this.dataInfo.viewPortMin;
		max = this.viewportMaximum !== null ? this.viewportMaximum : this.dataInfo.viewPortMax;

		if (max - min === 0) {
			rangePadding = typeof this._options.interval === "undefined" ? .4 : this._options.interval;

			max += rangePadding;
			min -= rangePadding;
		}

		if (this.dataInfo.minDiff !== Infinity) minDiff = this.dataInfo.minDiff;else if (max - min > 1) {
			minDiff = Math.abs(max - min) * .5;
		} else {
			minDiff = 1;

			if (this.chart.plotInfo.axisXValueType === "dateTime") isLessThanTwoDataPoints = true;
		}
	} else if (this.type === "axisY") {

		//min = typeof (this._options.viewportMinimum) === "undefined" || this._options.viewportMinimum === null ? this.dataInfo.viewPortMin : this._options.viewportMinimum;
		//max = typeof (this._options.viewportMaximum) === "undefined" || this._options.viewportMaximum === null ? this.dataInfo.viewPortMax : this._options.viewportMaximum;
		min = this.viewportMinimum !== null ? this.viewportMinimum : this.dataInfo.viewPortMin;
		max = this.viewportMaximum !== null ? this.viewportMaximum : this.dataInfo.viewPortMax;

		if (!isFinite(min) && !isFinite(max)) {
			max = typeof this._options.interval === "undefined" ? -Infinity : this._options.interval;
			min = 0;
		} else if (!isFinite(min)) {
			min = max;
		} else if (!isFinite(max)) {
			max = min;
		}

		if (min === 0 && max === 0) {
			// When all dataPoints are zero
			max += 9;
			min = 0;
		} else if (max - min === 0) {
			// When there is only a single dataPoint or when all dataPoints have same Y Value
			rangePadding = Math.min(Math.abs(Math.abs(max) * .01), 5);
			max += rangePadding;
			min -= rangePadding;
		} else if (min > max) {
			rangePadding = Math.min(Math.abs(Math.abs(max - min) * .01), 5);

			if (max >= 0) min = max - rangePadding;else max = min + rangePadding;
		} else {

			rangePadding = Math.min(Math.abs(Math.abs(max - min) * .01), .05);

			if (max !== 0) max += rangePadding;
			if (min !== 0) min -= rangePadding;
		}

		if (this.dataInfo.minDiff !== Infinity) minDiff = this.dataInfo.minDiff;else if (max - min > 1) {
			minDiff = Math.abs(max - min) * .5;
		} else {
			minDiff = 1;
		}

		//Apply includeZero
		if (this.includeZero && (this.viewportMinimum === null || isNaN(this.viewportMinimum))) {
			if (min > 0) min = 0;
		}
		if (this.includeZero && (this.viewportMaximum === null || isNaN(this.viewportMaximum))) {
			if (max < 0) max = 0;
		}
	}

	range = (isNaN(this.viewportMaximum) || this.viewportMaximum === null ? max : this.viewportMaximum) - (isNaN(this.viewportMinimum) || this.viewportMinimum === null ? min : this.viewportMinimum);

	if (this.type === "axisX" && this.chart.plotInfo.axisXValueType === "dateTime") {

		if (!this.intervalType) {

			if (range / (1 * 1) <= noTicks) {
				this.interval = 1;
				this.intervalType = "millisecond";
			} else if (range / (1 * 2) <= noTicks) {
				this.interval = 2;
				this.intervalType = "millisecond";
			} else if (range / (1 * 5) <= noTicks) {
				this.interval = 5;
				this.intervalType = "millisecond";
			} else if (range / (1 * 10) <= noTicks) {
				this.interval = 10;
				this.intervalType = "millisecond";
			} else if (range / (1 * 20) <= noTicks) {
				this.interval = 20;
				this.intervalType = "millisecond";
			} else if (range / (1 * 50) <= noTicks) {
				this.interval = 50;
				this.intervalType = "millisecond";
			} else if (range / (1 * 100) <= noTicks) {
				this.interval = 100;
				this.intervalType = "millisecond";
			} else if (range / (1 * 200) <= noTicks) {
				this.interval = 200;
				this.intervalType = "millisecond";
			} else if (range / (1 * 250) <= noTicks) {
				this.interval = 250;
				this.intervalType = "millisecond";
			} else if (range / (1 * 300) <= noTicks) {
				this.interval = 300;
				this.intervalType = "millisecond";
			} else if (range / (1 * 400) <= noTicks) {
				this.interval = 400;
				this.intervalType = "millisecond";
			} else if (range / (1 * 500) <= noTicks) {
				this.interval = 500;
				this.intervalType = "millisecond";
			} else if (range / (constants.secondDuration * 1) <= noTicks) {
				this.interval = 1;
				this.intervalType = "second";
			} else if (range / (constants.secondDuration * 2) <= noTicks) {
				this.interval = 2;
				this.intervalType = "second";
			} else if (range / (constants.secondDuration * 5) <= noTicks) {
				this.interval = 5;
				this.intervalType = "second";
			} else if (range / (constants.secondDuration * 10) <= noTicks) {
				this.interval = 10;
				this.intervalType = "second";
			} else if (range / (constants.secondDuration * 15) <= noTicks) {
				this.interval = 15;
				this.intervalType = "second";
			} else if (range / (constants.secondDuration * 20) <= noTicks) {
				this.interval = 20;
				this.intervalType = "second";
			} else if (range / (constants.secondDuration * 30) <= noTicks) {
				this.interval = 30;
				this.intervalType = "second";
			} else if (range / (constants.minuteDuration * 1) <= noTicks) {
				this.interval = 1;
				this.intervalType = "minute";
			} else if (range / (constants.minuteDuration * 2) <= noTicks) {
				this.interval = 2;
				this.intervalType = "minute";
			} else if (range / (constants.minuteDuration * 5) <= noTicks) {
				this.interval = 5;
				this.intervalType = "minute";
			} else if (range / (constants.minuteDuration * 10) <= noTicks) {
				this.interval = 10;
				this.intervalType = "minute";
			} else if (range / (constants.minuteDuration * 15) <= noTicks) {
				this.interval = 15;
				this.intervalType = "minute";
			} else if (range / (constants.minuteDuration * 20) <= noTicks) {
				this.interval = 20;
				this.intervalType = "minute";
			} else if (range / (constants.minuteDuration * 30) <= noTicks) {
				this.interval = 30;
				this.intervalType = "minute";
			} else if (range / (constants.hourDuration * 1) <= noTicks) {
				this.interval = 1;
				this.intervalType = "hour";
			} else if (range / (constants.hourDuration * 2) <= noTicks) {
				this.interval = 2;
				this.intervalType = "hour";
			} else if (range / (constants.hourDuration * 3) <= noTicks) {
				this.interval = 3;
				this.intervalType = "hour";
			} else if (range / (constants.hourDuration * 6) <= noTicks) {
				this.interval = 6;
				this.intervalType = "hour";
			} else if (range / (constants.dayDuration * 1) <= noTicks) {
				this.interval = 1;
				this.intervalType = "day";
			} else if (range / (constants.dayDuration * 2) <= noTicks) {
				this.interval = 2;
				this.intervalType = "day";
			} else if (range / (constants.dayDuration * 4) <= noTicks) {
				this.interval = 4;
				this.intervalType = "day";
			} else if (range / (constants.weekDuration * 1) <= noTicks) {
				this.interval = 1;
				this.intervalType = "week";
			} else if (range / (constants.weekDuration * 2) <= noTicks) {
				this.interval = 2;
				this.intervalType = "week";
			} else if (range / (constants.weekDuration * 3) <= noTicks) {
				this.interval = 3;
				this.intervalType = "week";
			} else if (range / (constants.monthDuration * 1) <= noTicks) {
				this.interval = 1;
				this.intervalType = "month";
			} else if (range / (constants.monthDuration * 2) <= noTicks) {
				this.interval = 2;
				this.intervalType = "month";
			} else if (range / (constants.monthDuration * 3) <= noTicks) {
				this.interval = 3;
				this.intervalType = "month";
			} else if (range / (constants.monthDuration * 6) <= noTicks) {
				this.interval = 6;
				this.intervalType = "month";
			} else if (range / (constants.yearDuration * 1) <= noTicks) {
				this.interval = 1;
				this.intervalType = "year";
			} else if (range / (constants.yearDuration * 2) <= noTicks) {
				this.interval = 2;
				this.intervalType = "year";
			} else if (range / (constants.yearDuration * 4) <= noTicks) {
				this.interval = 4;
				this.intervalType = "year";
			} else {
				this.interval = Math.floor(Axis.getNiceNumber(range / (noTicks - 1), true) / constants.yearDuration);
				this.intervalType = "year";
			}
		}

		if (this.viewportMinimum === null || isNaN(this.viewportMinimum)) this.viewportMinimum = min - minDiff / 2;

		if (this.viewportMaximum === null || isNaN(this.viewportMaximum)) this.viewportMaximum = max + minDiff / 2;

		if (!this.valueFormatString) {
			if (isLessThanTwoDataPoints) {
				this.valueFormatString = "MMM DD YYYY HH:mm";
			} else if (this.intervalType === "year") {
				this.valueFormatString = "YYYY";
			} else if (this.intervalType === "month") {
				this.valueFormatString = "MMM YYYY";
			} else if (this.intervalType === "week") {
				this.valueFormatString = "MMM DD YYYY";
			} else if (this.intervalType === "day") {
				this.valueFormatString = "MMM DD YYYY";
			} else if (this.intervalType === "hour") {
				this.valueFormatString = "hh:mm TT";
			} else if (this.intervalType === "minute") {
				this.valueFormatString = "hh:mm TT";
			} else if (this.intervalType === "second") {
				this.valueFormatString = "hh:mm:ss TT";
			} else if (this.intervalType === "millisecond") {
				this.valueFormatString = "fff'ms'";
			}
		}
	} else {

		this.intervalType = "number";

		range = Axis.getNiceNumber(range, false);

		if (this._options && this._options.interval) this.interval = this._options.interval;else {
			this.interval = Axis.getNiceNumber(range / (noTicks - 1), true);
		}

		if (this.viewportMinimum === null || isNaN(this.viewportMinimum)) {
			if (this.type === "axisX") this.viewportMinimum = min - minDiff / 2;else this.viewportMinimum = Math.floor(min / this.interval) * this.interval;
		}

		if (this.viewportMaximum === null || isNaN(this.viewportMaximum)) {
			if (this.type === "axisX") this.viewportMaximum = max + minDiff / 2;else this.viewportMaximum = Math.ceil(max / this.interval) * this.interval;
		}

		if (this.viewportMaximum === 0 && this.viewportMinimum === 0) {

			if (this._options.viewportMinimum === 0) {
				this.viewportMaximum += 10;
			} else if (this._options.viewportMaximum === 0) {
				this.viewportMinimum -= 10;
			}

			if (this._options && typeof this._options.interval === "undefined") {
				this.interval = Axis.getNiceNumber((this.viewportMaximum - this.viewportMinimum) / (noTicks - 1), true);
			}
		}
	}

	//Calculate minimum and maximum if not provided by the user
	if (this.minimum === null || this.maximum === null) {
		if (this.type === "axisX") {
			min = this.minimum !== null ? this.minimum : this.dataInfo.min;
			max = this.maximum !== null ? this.maximum : this.dataInfo.max;

			if (max - min === 0) {
				rangePadding = typeof this._options.interval === "undefined" ? .4 : this._options.interval;

				max += rangePadding;
				min -= rangePadding;
			}

			if (this.dataInfo.minDiff !== Infinity) minDiff = this.dataInfo.minDiff;else if (max - min > 1) {
				minDiff = Math.abs(max - min) * .5;
			} else {
				minDiff = 1;
			}
		} else if (this.type === "axisY") {

			min = this.minimum !== null ? this.minimum : this.dataInfo.min;
			max = this.maximum !== null ? this.maximum : this.dataInfo.max;

			if (!isFinite(min) && !isFinite(max)) {
				max = typeof this._options.interval === "undefined" ? -Infinity : this._options.interval;
				min = 0;
			} else if (min === 0 && max === 0) {
				// When all dataPoints are zero
				max += 9;
				min = 0;
			} else if (max - min === 0) {
				// When there is only a single dataPoint or when all dataPoints have same Y Value
				rangePadding = Math.min(Math.abs(Math.abs(max) * .01), 5);
				max += rangePadding;
				min -= rangePadding;
			} else if (min > max) {
				rangePadding = Math.min(Math.abs(Math.abs(max - min) * .01), 5);

				if (max >= 0) min = max - rangePadding;else max = min + rangePadding;
			} else {

				rangePadding = Math.min(Math.abs(Math.abs(max - min) * .01), .05);

				if (max !== 0) max += rangePadding;
				if (min !== 0) min -= rangePadding;
			}

			if (this.dataInfo.minDiff !== Infinity) minDiff = this.dataInfo.minDiff;else if (max - min > 1) {
				minDiff = Math.abs(max - min) * .5;
			} else {
				minDiff = 1;
			}

			//Apply includeZero
			if (this.includeZero && (this.minimum === null || isNaN(this.minimum))) {
				if (min > 0) min = 0;
			}
			if (this.includeZero && (this.maximum === null || isNaN(this.maximum))) {
				if (max < 0) max = 0;
			}
		}

		range = max - min;

		if (this.type === "axisX" && this.chart.plotInfo.axisXValueType === "dateTime") {

			if (this.minimum === null || isNaN(this.minimum)) this.minimum = min - minDiff / 2;

			if (this.maximum === null || isNaN(this.maximum)) this.maximum = max + minDiff / 2;
		} else {

			this.intervalType = "number";

			if (this.minimum === null) {
				if (this.type === "axisX") this.minimum = min - minDiff / 2;else this.minimum = Math.floor(min / this.interval) * this.interval;

				this.minimum = Math.min(this.minimum, this.sessionVariables.viewportMinimum === null || isNaN(this.sessionVariables.viewportMinimum) ? Infinity : this.sessionVariables.viewportMinimum);
			}

			if (this.maximum === null) {
				if (this.type === "axisX") this.maximum = max + minDiff / 2;else this.maximum = Math.ceil(max / this.interval) * this.interval;

				this.maximum = Math.max(this.maximum, this.sessionVariables.viewportMaximum === null || isNaN(this.sessionVariables.viewportMaximum) ? -Infinity : this.sessionVariables.viewportMaximum);
			}

			//var nfrac = Math.max(-Math.floor(Math.log(d)/Math.LN10), 0); //number of fractional digits to show


			if (this.maximum === 0 && this.minimum === 0) {

				if (this._options.minimum === 0) {
					this.maximum += 10;
				} else if (this._options.maximum === 0) {
					this.minimum -= 10;
				}
			}
		}
	}

	this.viewportMinimum = Math.max(this.viewportMinimum, this.minimum);
	this.viewportMaximum = Math.min(this.viewportMaximum, this.maximum);

	if (this.type === "axisX" && this.chart.plotInfo.axisXValueType === "dateTime") this.intervalStartPosition = this.getLabelStartPoint(new Date(this.viewportMinimum), this.intervalType, this.interval);else this.intervalStartPosition = Math.floor((this.viewportMinimum + this.interval * .2) / this.interval) * this.interval;

	//Set valueFormatString
	if (!this.valueFormatString) {
		this.valueFormatString = "#,##0.##";

		range = Math.abs(this.viewportMaximum - this.viewportMinimum);

		if (range < 1) {
			var numberOfDecimals = Math.floor(Math.abs(Math.log(range) / Math.LN10)) + 2;

			if (isNaN(numberOfDecimals) || !isFinite(numberOfDecimals)) numberOfDecimals = 2;

			if (numberOfDecimals > 2) {
				for (var i = 0; i < numberOfDecimals - 2; i++) {
					this.valueFormatString += "#";
				}
			}
		}
	}

	//if (isDebugMode && window.console) {
	//    window.console.log(this.type + ": Min = " + this.viewportMinimum);
	//    window.console.log(this.type + ": Max = " + this.viewportMaximum);
	//    window.console.log(this.type + ": Interval = " + this.interval);
	//}
};

Axis.getNiceNumber = function (x, round) {

	var exp = Math.floor(Math.log(x) / Math.LN10);
	var f = x / Math.pow(10, exp);
	var nf;

	if (round) {
		if (f < 1.5) nf = 1;else if (f < 3) nf = 2;else if (f < 7) nf = 5;else nf = 10;
	} else {
		if (f <= 1) nf = 1;else if (f <= 2) nf = 2;else if (f <= 5) nf = 5;else nf = 10;
	}

	return Number((nf * Math.pow(10, exp)).toFixed(20));
};

Axis.prototype.getLabelStartPoint = function () {

	var intervalInMilliseconds = convertToNumber(this.interval, this.intervalType);
	var minimum = Math.floor(this.viewportMinimum / intervalInMilliseconds) * intervalInMilliseconds;
	var dateTime = new Date(minimum);

	if (this.intervalType === "millisecond") {
		//millisecond = dateTime.getMilliSecond();
		//millisecond = Math.floor((millisecond + this.interval) / this.interval) * this.interval;
	} else if (this.intervalType === "second") {
		if (dateTime.getMilliseconds() > 0) {
			dateTime.setSeconds(dateTime.getSeconds() + 1);
			dateTime.setMilliseconds(0);
		}
	} else if (this.intervalType === "minute") {
		if (dateTime.getSeconds() > 0 || dateTime.getMilliseconds() > 0) {
			dateTime.setMinutes(dateTime.getMinutes() + 1);
			dateTime.setSeconds(0);
			dateTime.setMilliseconds(0);
		}
	} else if (this.intervalType === "hour") {
		if (dateTime.getMinutes() > 0 || dateTime.getSeconds() > 0 || dateTime.getMilliseconds() > 0) {
			dateTime.setHours(dateTime.getHours() + 1);
			dateTime.setMinutes(0);
			dateTime.setSeconds(0);
			dateTime.setMilliseconds(0);
		}
	} else if (this.intervalType === "day") {
		if (dateTime.getHours() > 0 || dateTime.getMinutes() > 0 || dateTime.getSeconds() > 0 || dateTime.getMilliseconds() > 0) {
			dateTime.setDate(dateTime.getDate() + 1);
			dateTime.setHours(0);
			dateTime.setMinutes(0);
			dateTime.setSeconds(0);
			dateTime.setMilliseconds(0);
		}
	} else if (this.intervalType === "week") {
		if (dateTime.getDay() > 0 || dateTime.getHours() > 0 || dateTime.getMinutes() > 0 || dateTime.getSeconds() > 0 || dateTime.getMilliseconds() > 0) {
			dateTime.setDate(dateTime.getDate() + (7 - dateTime.getDay()));
			dateTime.setHours(0);
			dateTime.setMinutes(0);
			dateTime.setSeconds(0);
			dateTime.setMilliseconds(0);
		}
	} else if (this.intervalType === "month") {
		if (dateTime.getDate() > 1 || dateTime.getHours() > 0 || dateTime.getMinutes() > 0 || dateTime.getSeconds() > 0 || dateTime.getMilliseconds() > 0) {
			dateTime.setMonth(dateTime.getMonth() + 1);
			dateTime.setDate(1);
			dateTime.setHours(0);
			dateTime.setMinutes(0);
			dateTime.setSeconds(0);
			dateTime.setMilliseconds(0);
		}
	} else if (this.intervalType === "year") {
		if (dateTime.getMonth() > 0 || dateTime.getDate() > 1 || dateTime.getHours() > 0 || dateTime.getMinutes() > 0 || dateTime.getSeconds() > 0 || dateTime.getMilliseconds() > 0) {
			dateTime.setFullYear(dateTime.getFullYear() + 1);
			dateTime.setMonth(0);
			dateTime.setDate(1);
			dateTime.setHours(0);
			dateTime.setMinutes(0);
			dateTime.setSeconds(0);
			dateTime.setMilliseconds(0);
		}
	}

	return dateTime;
};

exports.default = Axis;

},{"../helpers/utils":39,"./canvasjs":27,"./text_block":34}],27:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _themes = require('../constants/themes');

var _options = require('../constants/options');

function CanvasJSObject(defaultsKey, options, theme, parent) {
  this._defaultsKey = defaultsKey;

  this.parent = parent;

  this._eventListeners = []; //Multidimentional array with an array for each event type

  var currentThemeOptions = {};

  if (theme && _themes.themes[theme] && _themes.themes[theme][defaultsKey]) currentThemeOptions = _themes.themes[theme][defaultsKey];

  this._options = options ? options : {};
  this.setOptions(this._options, currentThemeOptions);
}

CanvasJSObject.prototype.setOptions = function (options, currentThemeOptions) {

  if (!_options.defaultOptions[this._defaultsKey]) {
    if (_options.isDebugMode && window.console) console.log("defaults not set");
  } else {
    var defaults = _options.defaultOptions[this._defaultsKey];

    for (var prop in defaults) {

      if (defaults.hasOwnProperty(prop)) {
        if (options && prop in options) this[prop] = options[prop];else if (currentThemeOptions && prop in currentThemeOptions) this[prop] = currentThemeOptions[prop];else this[prop] = defaults[prop];

        //if (typeof this[prop] === "function") {
        //    alert("function");
        //    this[prop] = this[prop]();
        //}
      }
    }
  }
};

// Update options. Returns true if changed or else false
CanvasJSObject.prototype.updateOption = function (prop) {

  if (!_options.defaultOptions[this._defaultsKey] && _options.isDebugMode && window.console) console.log("defaults not set");

  var defaults = _options.defaultOptions[this._defaultsKey];
  var theme = this._options.theme ? this._options.theme : this.chart && this.chart._options.theme ? this.chart._options.theme : "theme1";

  var currentThemeOptions = {};
  var newValue = this[prop];

  if (theme && _themes.themes[theme] && _themes.themes[theme][this._defaultsKey]) currentThemeOptions = _themes.themes[theme][this._defaultsKey];

  if (prop in defaults) {
    if (prop in this._options) newValue = this._options[prop];else if (currentThemeOptions && prop in currentThemeOptions) newValue = currentThemeOptions[prop];else newValue = defaults[prop];
  }

  if (newValue === this[prop]) return false;

  this[prop] = newValue;
  return true;
};

//Stores values in _oldOptions so that it can be tracked for any changes
CanvasJSObject.prototype.trackChanges = function (option) {
  if (!this.sessionVariables) throw "Session Variable Store not set";

  this.sessionVariables[option] = this._options[option];
};

CanvasJSObject.prototype.isBeingTracked = function (option) {
  if (!this._options._oldOptions) this._options._oldOptions = {};

  if (this._options._oldOptions[option]) return true;else return false;
};

CanvasJSObject.prototype.hasOptionChanged = function (option) {
  if (!this.sessionVariables) throw "Session Variable Store not set";

  var hasChanged = !(this.sessionVariables[option] === this._options[option]);

  return hasChanged;
};

CanvasJSObject.prototype.addEventListener = function (eventName, eventHandler, context) {
  if (!eventName || !eventHandler) return;

  context = context || this;

  this._eventListeners[eventName] = this._eventListeners[eventName] || [];

  this._eventListeners[eventName].push({ context: context, eventHandler: eventHandler });
};

CanvasJSObject.prototype.removeEventListener = function (eventName, eventHandler) {
  if (!eventName || !eventHandler || !this._eventListeners[eventName]) return;

  var listeners = this._eventListeners[eventName];
  for (var i = 0; i < listeners.length; i++) {

    if (listeners[i].eventHandler === eventHandler) {
      listeners[i].splice(i, 1);
      break;
    }
  }
};

CanvasJSObject.prototype.removeAllEventListeners = function () {
  this._eventListeners = [];
};

CanvasJSObject.prototype.dispatchEvent = function (eventName, eventParameter, context) {

  //For Internal Events
  if (eventName && this._eventListeners[eventName]) {

    eventParameter = eventParameter || {};

    var listeners = this._eventListeners[eventName];
    for (var i = 0; i < listeners.length; i++) {

      listeners[i].eventHandler.call(listeners[i].context, eventParameter);
    }
  }

  //External Events do not require registering as the property name is suffient to fire the event.
  if (typeof this[eventName] === "function") {
    this[eventName].call(context || this.chart._publicChartReference, eventParameter);
  }
};

exports.default = CanvasJSObject;

},{"../constants/options":23,"../constants/themes":24}],28:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _canvasjs = require('./canvasjs');

var _canvasjs2 = _interopRequireDefault(_canvasjs);

var _animator = require('./animator');

var _animator2 = _interopRequireDefault(_animator);

var _data_series = require('./data_series');

var _data_series2 = _interopRequireDefault(_data_series);

var _text_block = require('./text_block');

var _text_block2 = _interopRequireDefault(_text_block);

var _render = require('../helpers/render');

var _render2 = _interopRequireDefault(_render);

var _layout_manager = require('./layout_manager');

var _layout_manager2 = _interopRequireDefault(_layout_manager);

var _event_manager = require('./event_manager');

var _event_manager2 = _interopRequireDefault(_event_manager);

var _tooltip = require('./tooltip');

var _tooltip2 = _interopRequireDefault(_tooltip);

var _culture_info = require('../core/culture_info');

var _culture_info2 = _interopRequireDefault(_culture_info);

var _axis = require('../core/axis');

var _axis2 = _interopRequireDefault(_axis);

var _title = require('../core/title');

var _title2 = _interopRequireDefault(_title);

var _legend = require('../core/legend');

var _legend2 = _interopRequireDefault(_legend);

var _animator3 = require('../helpers/animator');

var _animator4 = _interopRequireDefault(_animator3);

var _themes = require('../constants/themes');

var _options = require('../constants/options');

var _utils = require('../helpers/utils');

var _index = require('../charts/index');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
// import {inherits} from 'util';

var devicePixelBackingStoreRatio = (0, _utils.getDevicePixelBackingStoreRatio)();

function Chart(containerId, options, publicChartReference) {

	this._publicChartReference = publicChartReference;

	options = options || {};

	Chart.base.constructor.call(this, "Chart", options, options.theme ? options.theme : "theme1");

	var _this = this;

	this._containerId = containerId;
	this._objectsInitialized = false;
	this.ctx = null;
	this.overlaidCanvasCtx = null;
	this._indexLabels = [];
	this._panTimerId = 0;
	this._lastTouchEventType = "";
	this._lastTouchData = null;
	this.isAnimating = false;
	this.renderCount = 0;
	this.animatedRender = false;
	this.disableToolTip = false;

	this.panEnabled = false;
	this._defaultCursor = "default";
	this.plotArea = { canvas: null, ctx: null, x1: 0, y1: 0, x2: 0, y2: 0, width: 0, height: 0 };
	this._dataInRenderedOrder = [];

	this._container = typeof this._containerId === "string" ? document.getElementById(this._containerId) : this._containerId;

	if (!this._container) {
		if (window.console) window.console.log("CanvasJS Error: Chart Container with id \"" + this._containerId + "\" was not found");
		return;
	}

	this._container.innerHTML = "";

	var width = 0;
	var height = 0;

	if (this._options.width) width = this.width;else width = this._container.clientWidth > 0 ? this._container.clientWidth : this.width;

	if (this._options.height) height = this.height;else height = this._container.clientHeight > 0 ? this._container.clientHeight : this.height;

	this.width = width;
	this.height = height;

	this.x1 = this.y1 = 0;
	this.x2 = this.width;
	this.y2 = this.height;

	this._selectedColorSet = typeof _themes.colorSets[this.colorSet] !== "undefined" ? _themes.colorSets[this.colorSet] : _themes.colorSets["colorSet1"];

	this._canvasJSContainer = document.createElement("div");
	this._canvasJSContainer.setAttribute("class", "canvasjs-chart-container");

	this._canvasJSContainer.style.position = "relative";
	this._canvasJSContainer.style.textAlign = "left";
	this._canvasJSContainer.style.cursor = "auto";

	if (!_utils.isCanvasSupported) {
		this._canvasJSContainer.style.height = "0px"; //In IE6 toolTip doesn't show at proper position if not set.
	}
	this._container.appendChild(this._canvasJSContainer);

	this.canvas = (0, _utils.createCanvas)(width, height);

	this.canvas.style.position = "absolute";
	if (this.canvas.getContext) {
		//try {
		//	this.canvas.style.background = this.backgroundColor;
		//} catch (e) { }
		this._canvasJSContainer.appendChild(this.canvas);
		this.ctx = this.canvas.getContext("2d");
		this.ctx.textBaseline = "top";
		(0, _utils.extendCtx)(this.ctx);
	} else return;

	//this.canvas.style.cursor = "pointer";

	if (!_utils.isCanvasSupported) {
		this.plotArea.canvas = (0, _utils.createCanvas)(width, height);
		this.plotArea.canvas.style.position = "absolute";
		this.plotArea.canvas.setAttribute("class", "plotAreaCanvas");
		this._canvasJSContainer.appendChild(this.plotArea.canvas);

		this.plotArea.ctx = this.plotArea.canvas.getContext("2d");
	} else {
		this.plotArea.ctx = this.ctx;
	}

	this.overlaidCanvas = (0, _utils.createCanvas)(width, height);
	this.overlaidCanvas.style.position = "absolute";
	this._canvasJSContainer.appendChild(this.overlaidCanvas);
	this.overlaidCanvasCtx = this.overlaidCanvas.getContext("2d");
	this.overlaidCanvasCtx.textBaseline = "top";

	this._eventManager = new _event_manager2.default(this);

	(0, _utils.addEvent)(window, "resize", function () {
		//this._container.addEventListener("DOMSubtreeModified", function () {

		if (_this._updateSize()) _this.render();
	});

	this._toolBar = document.createElement("div");
	this._toolBar.setAttribute("class", "canvasjs-chart-toolbar");
	this._toolBar.style.cssText = "position: absolute; right: 1px; top: 1px;";
	this._canvasJSContainer.appendChild(this._toolBar);

	this.bounds = { x1: 0, y1: 0, x2: this.width, y2: this.height };

	(0, _utils.addEvent)(this.overlaidCanvas, 'click', function (e) {
		_this._mouseEventHandler(e);
	});

	(0, _utils.addEvent)(this.overlaidCanvas, 'mousemove', function (e) {
		_this._mouseEventHandler(e);
	});

	(0, _utils.addEvent)(this.overlaidCanvas, 'mouseup', function (e) {
		_this._mouseEventHandler(e);
	});

	(0, _utils.addEvent)(this.overlaidCanvas, 'mousedown', function (e) {
		_this._mouseEventHandler(e);
		(0, _utils.hide)(_this._dropdownMenu);
	});

	(0, _utils.addEvent)(this.overlaidCanvas, 'mouseout', function (e) {
		_this._mouseEventHandler(e);
	});

	(0, _utils.addEvent)(this.overlaidCanvas, window.navigator.msPointerEnabled ? "MSPointerDown" : "touchstart", function (e) {
		_this._touchEventHandler(e);
	});

	(0, _utils.addEvent)(this.overlaidCanvas, window.navigator.msPointerEnabled ? "MSPointerMove" : 'touchmove', function (e) {
		_this._touchEventHandler(e);
	});

	(0, _utils.addEvent)(this.overlaidCanvas, window.navigator.msPointerEnabled ? "MSPointerUp" : 'touchend', function (e) {
		_this._touchEventHandler(e);
	});

	(0, _utils.addEvent)(this.overlaidCanvas, window.navigator.msPointerEnabled ? "MSPointerCancel" : 'touchcancel', function (e) {
		_this._touchEventHandler(e);
	});

	if (!this._creditLink) {

		this._creditLink = document.createElement("a");
		this._creditLink.setAttribute("class", "canvasjs-chart-credit");
		this._creditLink.setAttribute("style", "outline:none;margin:0px;position:absolute;right:3px;top:" + (this.height - 14) + "px;color:dimgrey;text-decoration:none;font-size:10px;font-family:Lucida Grande, Lucida Sans Unicode, Arial, sans-serif");

		this._creditLink.setAttribute("tabIndex", -1);

		this._creditLink.setAttribute("target", "_blank");
	}

	this._toolTip = new _tooltip2.default(this, this._options.toolTip, this.theme);

	this.data = null;
	this.axisX = null;
	this.axisY = null;
	this.axisY2 = null;

	this.sessionVariables = {
		axisX: {},
		axisY: {},
		axisY2: {}
	};
}

(0, _utils.extend)(Chart, _canvasjs2.default);

//Update Chart Properties
Chart.prototype._updateOptions = function () {

	var _this = this;

	this.updateOption("width");
	this.updateOption("height");
	this.updateOption("dataPointMaxWidth");
	this.updateOption("interactivityEnabled");
	this.updateOption("theme");

	if (this.updateOption("colorSet")) this._selectedColorSet = typeof _themes.colorSets[this.colorSet] !== "undefined" ? _themes.colorSets[this.colorSet] : _themes.colorSets["colorSet1"];

	this.updateOption("backgroundColor");
	if (!this.backgroundColor) this.backgroundColor = "rgba(0,0,0,0)";

	this.updateOption("culture");
	this._cultureInfo = new _culture_info2.default(this._options.culture);

	this.updateOption("animationEnabled");
	this.animationEnabled = this.animationEnabled && _utils.isCanvasSupported;
	this.updateOption("animationDuration");

	this.updateOption("rangeChanging");
	this.updateOption("rangeChanged");

	//Need to check this._options.zoomEnabled because this.zoomEnabled is used internally to keep track of state - and hence changes.
	if (this._options.zoomEnabled) {

		if (!this._zoomButton) {

			(0, _utils.hide)(this._zoomButton = document.createElement("button"));

			setButtonState(this, this._zoomButton, "pan");

			this._toolBar.appendChild(this._zoomButton);
			(0, _utils.addEvent)(this._zoomButton, "click", function () {
				if (_this.zoomEnabled) {
					_this.zoomEnabled = false;
					_this.panEnabled = true;

					setButtonState(_this, _this._zoomButton, "zoom");
				} else {
					_this.zoomEnabled = true;
					_this.panEnabled = false;

					setButtonState(_this, _this._zoomButton, "pan");
				}

				_this.render();
			});
		}

		if (!this._resetButton) {
			(0, _utils.hide)(this._resetButton = document.createElement("button"));
			setButtonState(this, this._resetButton, "reset");
			this._toolBar.appendChild(this._resetButton);

			(0, _utils.addEvent)(this._resetButton, "click", function () {

				_this._toolTip.hide();

				if (_this.zoomEnabled || _this.panEnabled) {
					_this.zoomEnabled = true;
					_this.panEnabled = false;
					setButtonState(_this, _this._zoomButton, "pan");

					_this._defaultCursor = "default";
					_this.overlaidCanvas.style.cursor = _this._defaultCursor;
				} else {
					_this.zoomEnabled = false;
					_this.panEnabled = false;
				}
				//Reset axisX
				if (_this.sessionVariables.axisX) {
					_this.sessionVariables.axisX.newViewportMinimum = null;
					_this.sessionVariables.axisX.newViewportMaximum = null;
				}

				//Reset axisY
				if (_this.sessionVariables.axisY) {
					_this.sessionVariables.axisY.newViewportMinimum = null;
					_this.sessionVariables.axisY.newViewportMaximum = null;
				}

				//Reset axisY2
				if (_this.sessionVariables.axisY2) {
					_this.sessionVariables.axisY2.newViewportMinimum = null;
					_this.sessionVariables.axisY2.newViewportMaximum = null;
				}

				_this.resetOverlayedCanvas();

				(0, _utils.hide)(_this._zoomButton, _this._resetButton);

				_this._dispatchRangeEvent("rangeChanging", "reset");
				_this.render();
				_this._dispatchRangeEvent("rangeChanged", "reset");
			});

			this.overlaidCanvas.style.cursor = _this._defaultCursor;
		}

		if (!this.zoomEnabled && !this.panEnabled) {
			if (!this._zoomButton) {
				this.zoomEnabled = true;
				this.panEnabled = false;
			} else {

				if (_this._zoomButton.getAttribute("state") === _this._cultureInfo.zoomText) {
					this.panEnabled = true;
					this.zoomEnabled = false;
				} else {
					this.zoomEnabled = true;
					this.panEnabled = false;
				}

				(0, _utils.show)(_this._zoomButton, _this._resetButton);
			}
		}
	} else {
		this.zoomEnabled = false;
		this.panEnabled = false;
	}

	if (this._menuButton) {
		if (this.exportEnabled) (0, _utils.show)(this._menuButton);else (0, _utils.hide)(this._menuButton);
	} else if (this.exportEnabled && _utils.isCanvasSupported) {
		this._menuButton = document.createElement("button");
		setButtonState(this, this._menuButton, "menu");
		this._toolBar.appendChild(this._menuButton);

		(0, _utils.addEvent)(this._menuButton, "click", function () {
			if (_this._dropdownMenu.style.display === "none") {

				if (_this._dropDownCloseTime && new Date().getTime() - _this._dropDownCloseTime.getTime() <= 500) return;

				_this._dropdownMenu.style.display = "block";
				_this._menuButton.blur();
				_this._dropdownMenu.focus();
			}
		}, true);
	}

	if (!this._dropdownMenu && this.exportEnabled && _utils.isCanvasSupported) {
		this._dropdownMenu = document.createElement("div");
		this._dropdownMenu.setAttribute("tabindex", -1);
		this._dropdownMenu.style.cssText = "position: absolute; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none; cursor: pointer;right: 1px;top: 25px;min-width: 120px;outline: 0;border: 1px solid silver;font-size: 14px;font-family: Calibri, Verdana, sans-serif;padding: 5px 0px 5px 0px;text-align: left;background-color: #fff;line-height: 20px;box-shadow: 2px 2px 10px #888888;";
		_this._dropdownMenu.style.display = "none";
		this._toolBar.appendChild(this._dropdownMenu);

		(0, _utils.addEvent)(this._dropdownMenu, "blur", function () {
			(0, _utils.hide)(_this._dropdownMenu);

			_this._dropDownCloseTime = new Date();
		}, true);

		var exportOption = document.createElement("div");
		exportOption.style.cssText = "padding: 2px 15px 2px 10px";
		exportOption.innerHTML = this._cultureInfo.saveJPGText;
		this._dropdownMenu.appendChild(exportOption);

		(0, _utils.addEvent)(exportOption, "mouseover", function () {
			this.style.backgroundColor = "#EEEEEE";
		}, true);

		(0, _utils.addEvent)(exportOption, "mouseout", function () {
			this.style.backgroundColor = "transparent";
		}, true);

		(0, _utils.addEvent)(exportOption, "click", function () {
			exportCanvas(_this.canvas, "jpg", _this.exportFileName);
			(0, _utils.hide)(_this._dropdownMenu);
		}, true);

		var exportOption = document.createElement("div");
		exportOption.style.cssText = "padding: 2px 15px 2px 10px";
		exportOption.innerHTML = this._cultureInfo.savePNGText;
		this._dropdownMenu.appendChild(exportOption);

		(0, _utils.addEvent)(exportOption, "mouseover", function () {
			this.style.backgroundColor = "#EEEEEE";
		}, true);

		(0, _utils.addEvent)(exportOption, "mouseout", function () {
			this.style.backgroundColor = "transparent";
		}, true);

		(0, _utils.addEvent)(exportOption, "click", function () {
			exportCanvas(_this.canvas, "png", _this.exportFileName);
			(0, _utils.hide)(_this._dropdownMenu);
		}, true);
	}

	if (this._toolBar.style.display !== "none" && this._zoomButton) {

		this.panEnabled ? setButtonState(_this, _this._zoomButton, "zoom") : setButtonState(_this, _this._zoomButton, "pan");

		if (_this._resetButton.getAttribute("state") !== _this._cultureInfo.resetText) setButtonState(_this, _this._resetButton, "reset");
	}

	if (typeof _options.defaultOptions.Chart.creditHref === "undefined") {
		this.creditHref = "http://canvasjs.com/";
		this.creditText = "CanvasJS.com";
	} else {
		var creditTextChanged = this.updateOption("creditText");
		var creditHrefChanged = this.updateOption("creditHref");
	}

	if (this.renderCount === 0 || creditTextChanged || creditHrefChanged) {
		this._creditLink.setAttribute("href", this.creditHref);
		this._creditLink.innerHTML = this.creditText;
	}

	if (this.creditHref && this.creditText) {
		if (!this._creditLink.parentElement) this._canvasJSContainer.appendChild(this._creditLink);
	} else if (this._creditLink.parentElement) this._canvasJSContainer.removeChild(this._creditLink);

	if (this._options.toolTip && this._toolTip._options !== this._options.toolTip) this._toolTip._options = this._options.toolTip;

	for (var prop in this._toolTip._options) {

		if (this._toolTip._options.hasOwnProperty(prop)) {
			this._toolTip.updateOption(prop);
		}
	}
};

Chart.prototype._updateSize = function () {
	var width = 0;
	var height = 0;

	if (this._options.width) width = this.width;else this.width = width = this._container.clientWidth > 0 ? this._container.clientWidth : this.width;

	if (this._options.height) height = this.height;else this.height = height = this._container.clientHeight > 0 ? this._container.clientHeight : this.height;

	if (this.canvas.width !== width * devicePixelBackingStoreRatio || this.canvas.height !== height * devicePixelBackingStoreRatio) {
		(0, _utils.setCanvasSize)(this.canvas, width, height);

		(0, _utils.setCanvasSize)(this.overlaidCanvas, width, height);
		(0, _utils.setCanvasSize)(this._eventManager.ghostCanvas, width, height);

		return true;
	}

	return false;
};

// initialize chart objects
Chart.prototype._initialize = function () {
	///<signature>
	///<summary>Initializes Chart objects/state. Creates DataSeries class instance for each DataSeries provided by ther user. Sets the Axis Type based on the user data</summary>
	///</signature>
	//this.width = this.width;

	if (!this._animator) this._animator = new _animator2.default(this);else {
		this._animator.cancelAllAnimations();
	}

	this.removeAllEventListeners();

	this.disableToolTip = false;

	this._axes = [];

	this.pieDoughnutClickHandler = null;
	//this._touchCurrentCoordinates = null;

	if (this.animationRequestId) this.cancelRequestAnimFrame.call(window, this.animationRequestId);

	this._updateOptions();

	this.animatedRender = _utils.isCanvasSupported && this.animationEnabled && this.renderCount === 0;

	this._updateSize();

	//this._selectedColorSet = colorSets["colorSet2"];

	//this.ctx.clearRect(0, 0, this.width, this.height);
	this.clearCanvas();
	this.ctx.beginPath();

	this.axisX = null;
	this.axisY = null;
	this.axisY2 = null;
	this._indexLabels = [];
	this._dataInRenderedOrder = [];

	this._events = [];
	if (this._eventManager) this._eventManager.reset();

	this.plotInfo = {
		axisPlacement: null,
		axisXValueType: null,
		plotTypes: [] //array of plotType: {type:"", axisYType: "primary", dataSeriesIndexes:[]}
	};

	this.layoutManager = new _layout_manager2.default(0, 0, this.width, this.height, 2);

	if (this.plotArea.layoutManager) this.plotArea.layoutManager.reset();

	this.data = [];
	var dataSeriesIndex = 0;

	for (var series = 0; series < this._options.data.length; series++) {
		//for (series in this._options.data) {

		dataSeriesIndex++;

		if (!(!this._options.data[series].type || Chart._supportedChartTypes.indexOf(this._options.data[series].type) >= 0)) continue;

		var dataSeries = new _data_series2.default(this, this._options.data[series], this.theme, dataSeriesIndex - 1, ++this._eventManager.lastObjectId);
		if (dataSeries.name === null) dataSeries.name = "DataSeries " + dataSeriesIndex;

		if (dataSeries.color === null) {
			if (this._options.data.length > 1) {
				dataSeries._colorSet = [this._selectedColorSet[dataSeries.index % this._selectedColorSet.length]];
				dataSeries.color = this._selectedColorSet[dataSeries.index % this._selectedColorSet.length];
			} else {
				if (dataSeries.type === "line" || dataSeries.type === "stepLine" || dataSeries.type === "spline" || dataSeries.type === "area" || dataSeries.type === "stepArea" || dataSeries.type === "splineArea" || dataSeries.type === "stackedArea" || dataSeries.type === "stackedArea100" || dataSeries.type === "rangeArea" || dataSeries.type === "rangeSplineArea" || dataSeries.type === "candlestick" || dataSeries.type === "ohlc") {
					dataSeries._colorSet = [this._selectedColorSet[0]];
				} else dataSeries._colorSet = this._selectedColorSet;
			}
		} else {
			dataSeries._colorSet = [dataSeries.color];
		}

		if (dataSeries.markerSize === null) {
			if ((dataSeries.type === "line" || dataSeries.type === "stepLine" || dataSeries.type === "spline") && dataSeries.dataPoints && dataSeries.dataPoints.length < this.width / 16 || dataSeries.type === "scatter") {
				//if (dataSeries.type === "line") {
				dataSeries.markerSize = 8;
			}
		}

		if ((dataSeries.type === "bubble" || dataSeries.type === "scatter") && dataSeries.dataPoints) {
			dataSeries.dataPoints.sort(_utils.compareDataPointX);
		}

		//if (dataSeries.markerBorderThickness === null && dataSeries.type === "scatter") {
		//    dataSeries.markerBorderThickness = 2;
		//}

		//if (dataSeries.markerType === null) {
		//    if (dataSeries.type === "line" & dataSeries.dataPoints.length < 500) {
		//        dataSeries.markerType = "circle";
		//    }
		//}

		this.data.push(dataSeries);

		var seriesAxisPlacement = dataSeries.axisPlacement;

		//if (isDebugMode && window.console)
		//    window.console.log(dataSeries.type);

		var errorMessage;

		if (seriesAxisPlacement === "normal") {

			if (this.plotInfo.axisPlacement === "xySwapped") {
				errorMessage = "You cannot combine \"" + dataSeries.type + "\" with bar chart";
			} else if (this.plotInfo.axisPlacement === "none") {
				errorMessage = "You cannot combine \"" + dataSeries.type + "\" with pie chart";
			} else if (this.plotInfo.axisPlacement === null) this.plotInfo.axisPlacement = "normal";
		} else if (seriesAxisPlacement === "xySwapped") {

			if (this.plotInfo.axisPlacement === "normal") {
				errorMessage = "You cannot combine \"" + dataSeries.type + "\" with line, area, column or pie chart";
			} else if (this.plotInfo.axisPlacement === "none") {
				errorMessage = "You cannot combine \"" + dataSeries.type + "\" with pie chart";
			} else if (this.plotInfo.axisPlacement === null) this.plotInfo.axisPlacement = "xySwapped";
		} else if (seriesAxisPlacement == "none") {

			if (this.plotInfo.axisPlacement === "normal") {
				errorMessage = "You cannot combine \"" + dataSeries.type + "\" with line, area, column or bar chart";
			} else if (this.plotInfo.axisPlacement === "xySwapped") {
				errorMessage = "You cannot combine \"" + dataSeries.type + "\" with bar chart";
			} else if (this.plotInfo.axisPlacement === null) this.plotInfo.axisPlacement = "none";
		}

		if (errorMessage && window.console) {
			window.console.log(errorMessage);
			return;
		}
	}

	//if (isDebugMode && window.console) {
	//    window.console.log("xMin: " + this.plotInfo.viewPortXMin + "; xMax: " + this.plotInfo.viewPortXMax + "; yMin: " + this.plotInfo.yMin + "; yMax: " + this.plotInfo.yMax);
	//}

	this._objectsInitialized = true;
};

//indexOf is not supported in IE8-
Chart._supportedChartTypes = (0, _utils.addArrayIndexOf)(["line", "stepLine", "spline", "column", "area", "stepArea", "splineArea", "bar", "bubble", "scatter", "stackedColumn", "stackedColumn100", "stackedBar", "stackedBar100", "stackedArea", "stackedArea100", "candlestick", "ohlc", "rangeColumn", "rangeBar", "rangeArea", "rangeSplineArea", "pie", "doughnut", "funnel"]);

Chart.prototype.render = function (options) {

	if (options) this._options = options;

	this._initialize();
	var plotAreaElements = []; //Elements to be rendered inside the plotArea

	//Create Primary and Secondary axis and assign them to the series
	for (var i = 0; i < this.data.length; i++) {

		if (this.plotInfo.axisPlacement === "normal" || this.plotInfo.axisPlacement === "xySwapped") {
			if (!this.data[i].axisYType || this.data[i].axisYType === "primary") {
				if (!this.axisY) {

					if (this.plotInfo.axisPlacement === "normal") {
						this._axes.push(this.axisY = new _axis2.default(this, this._options.axisY, "axisY", "left"));
					} else if (this.plotInfo.axisPlacement === "xySwapped") {
						this._axes.push(this.axisY = new _axis2.default(this, this._options.axisY, "axisY", "bottom"));
					}
				}
				this.data[i].axisY = this.axisY;
			} else if (this.data[i].axisYType === "secondary") {
				if (!this.axisY2) {
					if (this.plotInfo.axisPlacement === "normal") {
						this._axes.push(this.axisY2 = new _axis2.default(this, this._options.axisY2, "axisY", "right"));
					} else if (this.plotInfo.axisPlacement === "xySwapped") {
						this._axes.push(this.axisY2 = new _axis2.default(this, this._options.axisY2, "axisY", "top"));
					}
				}
				this.data[i].axisY = this.axisY2;
			}

			if (!this.axisX) {
				if (this.plotInfo.axisPlacement === "normal") {
					this._axes.push(this.axisX = new _axis2.default(this, this._options.axisX, "axisX", "bottom"));
				} else if (this.plotInfo.axisPlacement === "xySwapped") {
					this._axes.push(this.axisX = new _axis2.default(this, this._options.axisX, "axisX", "left"));
				}
			}

			this.data[i].axisX = this.axisX;
		}
	}

	//If Both Primary and Secondary axis are present, disable gridlines for one of them unless the user has set value for both
	if (this.axisY && this.axisY2) {
		if (this.axisY.gridThickness > 0 && typeof this.axisY2._options.gridThickness === "undefined") this.axisY2.gridThickness = 0;else if (this.axisY2.gridThickness > 0 && typeof this.axisY._options.gridThickness === "undefined") this.axisY.gridThickness = 0;
	}

	//Show toolBar when viewportMinimum/viewportMaximum are set
	var showToolBar = false;
	if (this._axes.length > 0 && (this.zoomEnabled || this.panEnabled)) {
		for (var i = 0; i < this._axes.length; i++) {
			if (this._axes[i].viewportMinimum !== null || this._axes[i].viewportMaximum !== null) {
				showToolBar = true;
				break;
			}
		}
	}

	if (showToolBar) {
		(0, _utils.show)(this._zoomButton, this._resetButton);
	} else {
		(0, _utils.hide)(this._zoomButton, this._resetButton);
	}

	this._processData(); // Categorises the dataSeries and calculates min, max and other values

	if (this._options.title) {
		this._title = new _title2.default(this, this._options.title);

		if (!this._title.dockInsidePlotArea) this._title.render();else plotAreaElements.push(this._title);
	}

	if (this._options.subtitles) {
		for (var i = 0; i < this._options.subtitles.length; i++) {

			this.subtitles = [];

			var subtitle = new Subtitle(this, this._options.subtitles[i]);
			this.subtitles.push(subtitle);

			if (!subtitle.dockInsidePlotArea) subtitle.render();else plotAreaElements.push(subtitle);
		}
	}

	this.legend = new _legend2.default(this, this._options.legend, this.theme);
	for (var i = 0; i < this.data.length; i++) {
		if (this.data[i].showInLegend || this.data[i].type === "pie" || this.data[i].type === "doughnut") {
			this.legend.dataSeries.push(this.data[i]);
		}
	}

	if (!this.legend.dockInsidePlotArea) this.legend.render();else plotAreaElements.push(this.legend);

	//TBI: Revisit and check if the functionality is enough.
	if (this.plotInfo.axisPlacement === "normal" || this.plotInfo.axisPlacement === "xySwapped") {

		//var freeSpace = this.layoutManager.getFreeSpace();

		_axis2.default.setLayoutAndRender(this.axisX, this.axisY, this.axisY2, this.plotInfo.axisPlacement, this.layoutManager.getFreeSpace());
	} else if (this.plotInfo.axisPlacement === "none") {
		//In case of charts with axis this method is called inside setLayoutAndRender
		this.preparePlotArea();
	} else {
		return;
	}

	var index = 0;
	for (index in plotAreaElements) {
		if (plotAreaElements.hasOwnProperty(index)) plotAreaElements[index].render();
	}

	var animations = [];
	if (this.animatedRender) {
		var initialState = (0, _utils.createCanvas)(this.width, this.height);
		var initialStateCtx = initialState.getContext("2d");
		initialStateCtx.drawImage(this.canvas, 0, 0, this.width, this.height);
	}

	for (var i = 0; i < this.plotInfo.plotTypes.length; i++) {
		var plotType = this.plotInfo.plotTypes[i];

		for (var j = 0; j < plotType.plotUnits.length; j++) {

			var plotUnit = plotType.plotUnits[j];
			var animationInfo = null;

			plotUnit.targetCanvas = null; //In case chart updates before the animation is complete, previous canvases need to be removed

			if (this.animatedRender) {
				plotUnit.targetCanvas = (0, _utils.createCanvas)(this.width, this.height);
				plotUnit.targetCanvasCtx = plotUnit.targetCanvas.getContext("2d");
			}

			if (plotUnit.type === "line") animationInfo = this.renderLine(plotUnit);else if (plotUnit.type === "stepLine") animationInfo = this.renderStepLine(plotUnit);else if (plotUnit.type === "spline") animationInfo = this.renderSpline(plotUnit);else if (plotUnit.type === "column") animationInfo = this.renderColumn(plotUnit);else if (plotUnit.type === "bar") animationInfo = this.renderBar(plotUnit);else if (plotUnit.type === "area") animationInfo = this.renderArea(plotUnit);else if (plotUnit.type === "stepArea") animationInfo = this.renderStepArea(plotUnit);else if (plotUnit.type === "splineArea") animationInfo = this.renderSplineArea(plotUnit);else if (plotUnit.type === "stackedColumn") animationInfo = this.renderStackedColumn(plotUnit);else if (plotUnit.type === "stackedColumn100") animationInfo = this.renderStackedColumn100(plotUnit);else if (plotUnit.type === "stackedBar") animationInfo = this.renderStackedBar(plotUnit);else if (plotUnit.type === "stackedBar100") animationInfo = this.renderStackedBar100(plotUnit);else if (plotUnit.type === "stackedArea") animationInfo = this.renderStackedArea(plotUnit);else if (plotUnit.type === "stackedArea100") animationInfo = this.renderStackedArea100(plotUnit);else if (plotUnit.type === "bubble") animationInfo = animationInfo = this.renderBubble(plotUnit);else if (plotUnit.type === "scatter") animationInfo = this.renderScatter(plotUnit);else if (plotUnit.type === "pie") this.renderPie(plotUnit);else if (plotUnit.type === "doughnut") this.renderPie(plotUnit);else if (plotUnit.type === "candlestick") animationInfo = this.renderCandlestick(plotUnit);else if (plotUnit.type === "ohlc") animationInfo = this.renderCandlestick(plotUnit);else if (plotUnit.type === "rangeColumn") animationInfo = this.renderRangeColumn(plotUnit);else if (plotUnit.type === "rangeBar") animationInfo = this.renderRangeBar(plotUnit);else if (plotUnit.type === "rangeArea") animationInfo = this.renderRangeArea(plotUnit);else if (plotUnit.type === "rangeSplineArea") animationInfo = this.renderRangeSplineArea(plotUnit);

			for (var k = 0; k < plotUnit.dataSeriesIndexes.length; k++) {
				this._dataInRenderedOrder.push(this.data[plotUnit.dataSeriesIndexes[k]]);
			}

			if (this.animatedRender && animationInfo) animations.push(animationInfo);
		}
	}

	if (this.animatedRender && this._indexLabels.length > 0) {
		var indexLabelCanvas = (0, _utils.createCanvas)(this.width, this.height);
		var indexLabelCanvasCtx = indexLabelCanvas.getContext("2d");
		animations.push(this.renderIndexLabels(indexLabelCanvasCtx));
	}

	var _this = this;

	if (animations.length > 0) {
		//var animationCount = 0;
		_this.disableToolTip = true;
		_this._animator.animate(200, _this.animationDuration, function (fractionComplete) {

			//console.log(fractionComplete);
			//animationCount++;

			_this.ctx.clearRect(0, 0, _this.width, _this.height);

			//  _this.ctx.drawImage(initialState, 0, 0, _this.width * devicePixelBackingStoreRatio, _this.height * devicePixelBackingStoreRatio, 0, 0, _this.width, _this.height);
			_this.ctx.drawImage(initialState, 0, 0, Math.floor(_this.width * devicePixelBackingStoreRatio), Math.floor(_this.height * devicePixelBackingStoreRatio), 0, 0, _this.width, _this.height);

			for (var l = 0; l < animations.length; l++) {

				animationInfo = animations[l];

				if (fractionComplete < 1 && typeof animationInfo.startTimePercent !== "undefined") {
					if (fractionComplete >= animationInfo.startTimePercent) {
						//animationInfo.animationCallback(AnimationHelper.easing.linear(fractionComplete - animationInfo.startTimePercent, 0, 1, 1 - animationInfo.startTimePercent), animationInfo);

						animationInfo.animationCallback(animationInfo.easingFunction(fractionComplete - animationInfo.startTimePercent, 0, 1, 1 - animationInfo.startTimePercent), animationInfo);
					}
				} else {

					animationInfo.animationCallback(animationInfo.easingFunction(fractionComplete, 0, 1, 1), animationInfo);
				}
			}

			_this.dispatchEvent("dataAnimationIterationEnd", {
				chart: _this
			});
		}, function () {

			animations = [];

			var count = 0;

			//Delete all render target canvases used for animation.
			for (var i = 0; i < _this.plotInfo.plotTypes.length; i++) {
				var plotType = _this.plotInfo.plotTypes[i];

				for (var j = 0; j < plotType.plotUnits.length; j++) {
					var plotUnit = plotType.plotUnits[j];
					plotUnit.targetCanvas = null;
				}
			}

			initialState = null;
			_this.disableToolTip = false;
			//console.log("*********** Animation Complete - " + animationCount + " ***********");
		});
	} else {
		if (_this._indexLabels.length > 0) _this.renderIndexLabels();

		_this.dispatchEvent("dataAnimationIterationEnd", {
			chart: _this
		});
	}

	this.attachPlotAreaEventHandlers();

	if (!this.zoomEnabled && !this.panEnabled && this._zoomButton && this._zoomButton.style.display !== "none") {
		(0, _utils.hide)(this._zoomButton, this._resetButton);
	}

	this._toolTip._updateToolTip();

	this.renderCount++;

	//if (window.console) {
	//    window.console.log(new Date().getTime() - dt);
	//}

	if (_options.isDebugMode) {

		var _this = this;
		setTimeout(function () {
			var ghostCanvasCopy = document.getElementById("ghostCanvasCopy");

			if (ghostCanvasCopy) {
				//console.log(ghostCanvasCopy.clientWidth);
				(0, _utils.setCanvasSize)(ghostCanvasCopy, _this.width, _this.height);
				var ghostCanvasCopyCtx = ghostCanvasCopy.getContext("2d");

				//ghostCanvasCopyCtx.scale(1, 1);
				//var imageData = this._eventManager.ghostCtx.getImageData(0, 0, this._container.clientWidth, this._container.clientHeight);
				//this._eventManager.ghostCtx.drawImage(this._eventManager.ghostCanvas, 0, 0);
				//this.ctx.drawImage(this._eventManager.ghostCanvas, 0, 0);

				ghostCanvasCopyCtx.drawImage(_this._eventManager.ghostCanvas, 0, 0);
				//_this._canvasJSContainer.appendChild(_this._eventManager.ghostCanvas);
				//_this.overlaidCanvasCtx.drawImage(_this._eventManager.ghostCanvas, 0, 0);
			}
		}, 2000);
	}
};

Chart.prototype.attachPlotAreaEventHandlers = function () {
	var _attachEvent;

	//this._toolBar.style.display = "inline";

	this.attachEvent((_attachEvent = {
		context: this,
		chart: this,
		mousedown: this._plotAreaMouseDown,
		mouseup: this._plotAreaMouseUp,
		mousemove: this._plotAreaMouseMove,
		cursor: this.zoomEnabled ? "col-resize" : "move"
	}, _defineProperty(_attachEvent, 'cursor', this.panEnabled ? "move" : "default"), _defineProperty(_attachEvent, 'capture', true), _defineProperty(_attachEvent, 'bounds', this.plotArea), _attachEvent));
};

Chart.prototype.categoriseDataSeries = function () {
	var dataSeries = "";

	for (var i = 0; i < this.data.length; i++) {
		dataSeries = this.data[i];
		if (!dataSeries.dataPoints || dataSeries.dataPoints.length === 0 || !dataSeries.visible) continue;

		if (Chart._supportedChartTypes.indexOf(dataSeries.type) >= 0) {

			var plotType = null;
			var plotTypeExists = false;

			var plotUnit = null;
			var plotUnitExists = false;

			for (var j = 0; j < this.plotInfo.plotTypes.length; j++) {
				if (this.plotInfo.plotTypes[j].type === dataSeries.type) {
					plotTypeExists = true;
					var plotType = this.plotInfo.plotTypes[j];
					break;
				}
			}

			if (!plotTypeExists) {
				plotType = {
					type: dataSeries.type,
					totalDataSeries: 0,
					plotUnits: []
				};
				this.plotInfo.plotTypes.push(plotType);
			}

			for (var j = 0; j < plotType.plotUnits.length; j++) {
				if (plotType.plotUnits[j].axisYType === dataSeries.axisYType) {
					plotUnitExists = true;
					var plotUnit = plotType.plotUnits[j];
					break;
				}
			}

			if (!plotUnitExists) {
				plotUnit = {
					type: dataSeries.type,
					previousDataSeriesCount: 0, //to be set next
					index: plotType.plotUnits.length,
					plotType: plotType,
					axisYType: dataSeries.axisYType,
					axisY: dataSeries.axisYType === "primary" ? this.axisY : this.axisY2,
					axisX: this.axisX,
					dataSeriesIndexes: [], //index of dataSeries
					yTotals: []
				};
				plotType.plotUnits.push(plotUnit);
			}

			plotType.totalDataSeries++;

			plotUnit.dataSeriesIndexes.push(i);

			dataSeries.plotUnit = plotUnit;
		}
	}

	for (var i = 0; i < this.plotInfo.plotTypes.length; i++) {
		var plotType = this.plotInfo.plotTypes[i];
		var previousDataSeriesCount = 0;

		for (var j = 0; j < plotType.plotUnits.length; j++) {

			plotType.plotUnits[j].previousDataSeriesCount = previousDataSeriesCount;

			previousDataSeriesCount += plotType.plotUnits[j].dataSeriesIndexes.length;
		}
	}
};

Chart.prototype.assignIdToDataPoints = function () {

	for (var i = 0; i < this.data.length; i++) {
		var dataSeries = this.data[i];

		if (!dataSeries.dataPoints) continue;

		var length = dataSeries.dataPoints.length;

		for (var j = 0; j < length; j++) {
			dataSeries.dataPointIds[j] = ++this._eventManager.lastObjectId;
		}
	}
};

Chart.prototype._processData = function () {
	this.assignIdToDataPoints();
	this.categoriseDataSeries();

	for (var i = 0; i < this.plotInfo.plotTypes.length; i++) {
		var plotType = this.plotInfo.plotTypes[i];

		for (var j = 0; j < plotType.plotUnits.length; j++) {

			var plotUnit = plotType.plotUnits[j];

			if (plotUnit.type === "line" || plotUnit.type === "stepLine" || plotUnit.type === "spline" || plotUnit.type === "column" || plotUnit.type === "area" || plotUnit.type === "stepArea" || plotUnit.type === "splineArea" || plotUnit.type === "bar" || plotUnit.type === "bubble" || plotUnit.type === "scatter") this._processMultiseriesPlotUnit(plotUnit);else if (plotUnit.type === "stackedColumn" || plotUnit.type === "stackedBar" || plotUnit.type === "stackedArea") this._processStackedPlotUnit(plotUnit);else if (plotUnit.type === "stackedColumn100" || plotUnit.type === "stackedBar100" || plotUnit.type === "stackedArea100") this._processStacked100PlotUnit(plotUnit);else if (plotUnit.type === "candlestick" || plotUnit.type === "ohlc" || plotUnit.type === "rangeColumn" || plotUnit.type === "rangeBar" || plotUnit.type === "rangeArea" || plotUnit.type === "rangeSplineArea") this._processMultiYPlotUnit(plotUnit);
		}
	}
};

Chart.prototype._processMultiseriesPlotUnit = function (plotUnit) {
	if (!plotUnit.dataSeriesIndexes || plotUnit.dataSeriesIndexes.length < 1) return;

	var axisYDataInfo = plotUnit.axisY.dataInfo;
	var axisXDataInfo = plotUnit.axisX.dataInfo;
	var dataPointX, dataPointY;
	var isDateTime = false;

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {
		var dataSeries = this.data[plotUnit.dataSeriesIndexes[j]];
		var i = 0;
		var isFirstDPInViewPort = false;
		var isLastDPInViewPort = false;

		if (dataSeries.axisPlacement === "normal" || dataSeries.axisPlacement === "xySwapped") {

			var plotAreaXMin = this.sessionVariables.axisX.newViewportMinimum ? this.sessionVariables.axisX.newViewportMinimum : this._options.axisX && this._options.axisX.viewportMinimum ? this._options.axisX.viewportMinimum : this._options.axisX && this._options.axisX.minimum ? this._options.axisX.minimum : -Infinity;

			var plotAreaXMax = this.sessionVariables.axisX.newViewportMaximum ? this.sessionVariables.axisX.newViewportMaximum : this._options.axisX && this._options.axisX.viewportMaximum ? this._options.axisX.viewportMaximum : this._options.axisX && this._options.axisX.maximum ? this._options.axisX.maximum : Infinity;
		}

		if (dataSeries.dataPoints[i].x && dataSeries.dataPoints[i].x.getTime || dataSeries.xValueType === "dateTime") {
			isDateTime = true;
		}

		for (i = 0; i < dataSeries.dataPoints.length; i++) {

			if (typeof dataSeries.dataPoints[i].x === "undefined") {
				dataSeries.dataPoints[i].x = i;
			}

			if (dataSeries.dataPoints[i].x.getTime) {
				isDateTime = true;
				dataPointX = dataSeries.dataPoints[i].x.getTime(); //dataPointX is used so that getTime is called only once in case of dateTime values
			} else dataPointX = dataSeries.dataPoints[i].x;

			dataPointY = dataSeries.dataPoints[i].y;

			if (dataPointX < axisXDataInfo.min) axisXDataInfo.min = dataPointX;
			if (dataPointX > axisXDataInfo.max) axisXDataInfo.max = dataPointX;

			if (dataPointY < axisYDataInfo.min) axisYDataInfo.min = dataPointY;

			if (dataPointY > axisYDataInfo.max) axisYDataInfo.max = dataPointY;

			if (i > 0) {
				var xDiff = dataPointX - dataSeries.dataPoints[i - 1].x;
				xDiff < 0 && (xDiff = xDiff * -1); //If Condition shortcut

				if (axisXDataInfo.minDiff > xDiff && xDiff !== 0) {
					axisXDataInfo.minDiff = xDiff;
				}

				if (dataPointY !== null && dataSeries.dataPoints[i - 1].y !== null) {
					var yDiff = dataPointY - dataSeries.dataPoints[i - 1].y;
					yDiff < 0 && (yDiff = yDiff * -1); //If Condition shortcut

					if (axisYDataInfo.minDiff > yDiff && yDiff !== 0) {
						axisYDataInfo.minDiff = yDiff;
					}
				}
			}

			// This section makes sure that partially visible dataPoints are included in the begining
			if (dataPointX < plotAreaXMin && !isFirstDPInViewPort) {
				continue;
			} else if (!isFirstDPInViewPort) {
				isFirstDPInViewPort = true;

				if (i > 0) {
					i -= 2;
					continue;
				}
			}

			// This section makes sure that partially visible dataPoints are included at the end
			if (dataPointX > plotAreaXMax && !isLastDPInViewPort) {
				isLastDPInViewPort = true;
			} else if (dataPointX > plotAreaXMax && isLastDPInViewPort) {
				continue;
			}

			if (dataSeries.dataPoints[i].label) plotUnit.axisX.labels[dataPointX] = dataSeries.dataPoints[i].label;

			if (dataPointX < axisXDataInfo.viewPortMin) axisXDataInfo.viewPortMin = dataPointX;
			if (dataPointX > axisXDataInfo.viewPortMax) axisXDataInfo.viewPortMax = dataPointX;

			if (dataPointY === null) continue;

			if (dataPointY < axisYDataInfo.viewPortMin) axisYDataInfo.viewPortMin = dataPointY;
			if (dataPointY > axisYDataInfo.viewPortMax) axisYDataInfo.viewPortMax = dataPointY;
		}

		this.plotInfo.axisXValueType = dataSeries.xValueType = isDateTime ? "dateTime" : "number";
	}

	//this.dataPoints.sort(compareDataPointX);
	//this.dataPoints.sort(function (dataPoint1, dataPoint2) { return dataPoint1.x - dataPoint2.x; });
};

Chart.prototype._processStackedPlotUnit = function (plotUnit) {

	if (!plotUnit.dataSeriesIndexes || plotUnit.dataSeriesIndexes.length < 1) return;

	var axisYDataInfo = plotUnit.axisY.dataInfo;
	var axisXDataInfo = plotUnit.axisX.dataInfo;

	var dataPointX, dataPointY;
	var isDateTime = false;

	var dataPointYPositiveSums = [];
	var dataPointYNegativeSums = [];

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {
		var dataSeries = this.data[plotUnit.dataSeriesIndexes[j]];
		var i = 0;
		var isFirstDPInViewPort = false;
		var isLastDPInViewPort = false;

		if (dataSeries.axisPlacement === "normal" || dataSeries.axisPlacement === "xySwapped") {

			var plotAreaXMin = this.sessionVariables.axisX.newViewportMinimum ? this.sessionVariables.axisX.newViewportMinimum : this._options.axisX && this._options.axisX.viewportMinimum ? this._options.axisX.viewportMinimum : this._options.axisX && this._options.axisX.minimum ? this._options.axisX.minimum : -Infinity;

			var plotAreaXMax = this.sessionVariables.axisX.newViewportMaximum ? this.sessionVariables.axisX.newViewportMaximum : this._options.axisX && this._options.axisX.viewportMaximum ? this._options.axisX.viewportMaximum : this._options.axisX && this._options.axisX.maximum ? this._options.axisX.maximum : Infinity;
		}

		if (dataSeries.dataPoints[i].x && dataSeries.dataPoints[i].x.getTime || dataSeries.xValueType === "dateTime") {
			isDateTime = true;
		}

		for (i = 0; i < dataSeries.dataPoints.length; i++) {

			// Requird when no x values are provided
			if (typeof dataSeries.dataPoints[i].x === "undefined") {
				dataSeries.dataPoints[i].x = i;
			}

			if (dataSeries.dataPoints[i].x.getTime) {
				isDateTime = true;
				dataPointX = dataSeries.dataPoints[i].x.getTime(); //dataPointX is used so that getTime is called only once in case of dateTime values
			} else dataPointX = dataSeries.dataPoints[i].x;

			dataPointY = dataSeries.dataPoints[i].y;

			if (dataPointX < axisXDataInfo.min) axisXDataInfo.min = dataPointX;
			if (dataPointX > axisXDataInfo.max) axisXDataInfo.max = dataPointX;

			if (i > 0) {
				var xDiff = dataPointX - dataSeries.dataPoints[i - 1].x;
				xDiff < 0 && (xDiff = xDiff * -1); //If Condition shortcut

				if (axisXDataInfo.minDiff > xDiff && xDiff !== 0) {
					axisXDataInfo.minDiff = xDiff;
				}

				if (dataPointY !== null && dataSeries.dataPoints[i - 1].y !== null) {
					var yDiff = dataPointY - dataSeries.dataPoints[i - 1].y;
					yDiff < 0 && (yDiff = yDiff * -1); //If Condition shortcut

					if (axisYDataInfo.minDiff > yDiff && yDiff !== 0) {
						axisYDataInfo.minDiff = yDiff;
					}
				}
			}

			// This section makes sure that partially visible dataPoints are included in the begining
			if (dataPointX < plotAreaXMin && !isFirstDPInViewPort) {
				continue;
			} else if (!isFirstDPInViewPort) {
				isFirstDPInViewPort = true;

				if (i > 0) {
					i -= 2;
					continue;
				}
			}

			// This section makes sure that partially visible dataPoints are included at the end
			if (dataPointX > plotAreaXMax && !isLastDPInViewPort) {
				isLastDPInViewPort = true;
			} else if (dataPointX > plotAreaXMax && isLastDPInViewPort) {
				continue;
			}

			if (dataSeries.dataPoints[i].label) plotUnit.axisX.labels[dataPointX] = dataSeries.dataPoints[i].label;

			if (dataPointX < axisXDataInfo.viewPortMin) axisXDataInfo.viewPortMin = dataPointX;
			if (dataPointX > axisXDataInfo.viewPortMax) axisXDataInfo.viewPortMax = dataPointX;

			if (dataPointY === null) continue;

			plotUnit.yTotals[dataPointX] = (!plotUnit.yTotals[dataPointX] ? 0 : plotUnit.yTotals[dataPointX]) + Math.abs(dataPointY);

			if (dataPointY >= 0) {
				if (dataPointYPositiveSums[dataPointX]) dataPointYPositiveSums[dataPointX] += dataPointY;else dataPointYPositiveSums[dataPointX] = dataPointY;
			} else {
				if (dataPointYNegativeSums[dataPointX]) dataPointYNegativeSums[dataPointX] += dataPointY;else dataPointYNegativeSums[dataPointX] = dataPointY;
			}
		}

		this.plotInfo.axisXValueType = dataSeries.xValueType = isDateTime ? "dateTime" : "number";
	}

	for (i in dataPointYPositiveSums) {
		if (dataPointYPositiveSums.hasOwnProperty(i)) {
			if (isNaN(i)) {
				continue;
			}
			var ySum = dataPointYPositiveSums[i];

			if (ySum < axisYDataInfo.min) axisYDataInfo.min = ySum;

			if (ySum > axisYDataInfo.max) axisYDataInfo.max = ySum;

			if (i < axisXDataInfo.viewPortMin || i > axisXDataInfo.viewPortMax) continue;

			if (ySum < axisYDataInfo.viewPortMin) axisYDataInfo.viewPortMin = ySum;
			if (ySum > axisYDataInfo.viewPortMax) axisYDataInfo.viewPortMax = ySum;
		}
	}

	for (i in dataPointYNegativeSums) {

		if (dataPointYNegativeSums.hasOwnProperty(i)) {
			if (isNaN(i)) {
				continue;
			}

			var ySum = dataPointYNegativeSums[i];

			if (ySum < axisYDataInfo.min) axisYDataInfo.min = ySum;

			if (ySum > axisYDataInfo.max) axisYDataInfo.max = ySum;

			if (i < axisXDataInfo.viewPortMin || i > axisXDataInfo.viewPortMax) continue;

			if (ySum < axisYDataInfo.viewPortMin) axisYDataInfo.viewPortMin = ySum;
			if (ySum > axisYDataInfo.viewPortMax) axisYDataInfo.viewPortMax = ySum;
		}
	}

	//this.dataPoints.sort(compareDataPointX);
	//this.dataPoints.sort(function (dataPoint1, dataPoint2) { return dataPoint1.x - dataPoint2.x; });

	//window.console.log("viewPortYMin: " + plotInfo.viewPortYMin + "; viewPortYMax: " + plotInfo.viewPortYMax);
};

Chart.prototype._processStacked100PlotUnit = function (plotUnit) {
	if (!plotUnit.dataSeriesIndexes || plotUnit.dataSeriesIndexes.length < 1) return;

	var axisYDataInfo = plotUnit.axisY.dataInfo;
	var axisXDataInfo = plotUnit.axisX.dataInfo;

	var dataPointX, dataPointY;
	var isDateTime = false;
	var containsPositiveY = false;
	var containsNegativeY = false;

	var dataPointYSums = [];

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {
		var dataSeries = this.data[plotUnit.dataSeriesIndexes[j]];
		var i = 0;
		var isFirstDPInViewPort = false;
		var isLastDPInViewPort = false;

		if (dataSeries.axisPlacement === "normal" || dataSeries.axisPlacement === "xySwapped") {

			var plotAreaXMin = this.sessionVariables.axisX.newViewportMinimum ? this.sessionVariables.axisX.newViewportMinimum : this._options.axisX && this._options.axisX.viewportMinimum ? this._options.axisX.viewportMinimum : this._options.axisX && this._options.axisX.minimum ? this._options.axisX.minimum : -Infinity;

			var plotAreaXMax = this.sessionVariables.axisX.newViewportMaximum ? this.sessionVariables.axisX.newViewportMaximum : this._options.axisX && this._options.axisX.viewportMaximum ? this._options.axisX.viewportMaximum : this._options.axisX && this._options.axisX.maximum ? this._options.axisX.maximum : Infinity;
		}

		if (dataSeries.dataPoints[i].x && dataSeries.dataPoints[i].x.getTime || dataSeries.xValueType === "dateTime") {
			isDateTime = true;
		}

		for (i = 0; i < dataSeries.dataPoints.length; i++) {

			// Requird when no x values are provided
			if (typeof dataSeries.dataPoints[i].x === "undefined") {
				dataSeries.dataPoints[i].x = i;
			}

			if (dataSeries.dataPoints[i].x.getTime) {
				isDateTime = true;
				dataPointX = dataSeries.dataPoints[i].x.getTime(); //dataPointX is used so that getTime is called only once in case of dateTime values
			} else dataPointX = dataSeries.dataPoints[i].x;

			dataPointY = dataSeries.dataPoints[i].y;

			if (dataPointX < axisXDataInfo.min) axisXDataInfo.min = dataPointX;
			if (dataPointX > axisXDataInfo.max) axisXDataInfo.max = dataPointX;

			if (i > 0) {
				var xDiff = dataPointX - dataSeries.dataPoints[i - 1].x;
				xDiff < 0 && (xDiff = xDiff * -1); //If Condition shortcut

				if (axisXDataInfo.minDiff > xDiff && xDiff !== 0) {
					axisXDataInfo.minDiff = xDiff;
				}

				if (dataPointY !== null && dataSeries.dataPoints[i - 1].y !== null) {
					var yDiff = dataPointY - dataSeries.dataPoints[i - 1].y;
					yDiff < 0 && (yDiff = yDiff * -1); //If Condition shortcut

					if (axisYDataInfo.minDiff > yDiff && yDiff !== 0) {
						axisYDataInfo.minDiff = yDiff;
					}
				}
			}

			// This section makes sure that partially visible dataPoints are included in the begining
			if (dataPointX < plotAreaXMin && !isFirstDPInViewPort) {
				continue;
			} else if (!isFirstDPInViewPort) {
				isFirstDPInViewPort = true;

				if (i > 0) {
					i -= 2;
					continue;
				}
			}

			// This section makes sure that partially visible dataPoints are included at the end
			if (dataPointX > plotAreaXMax && !isLastDPInViewPort) {
				isLastDPInViewPort = true;
			} else if (dataPointX > plotAreaXMax && isLastDPInViewPort) {
				continue;
			}

			if (dataSeries.dataPoints[i].label) plotUnit.axisX.labels[dataPointX] = dataSeries.dataPoints[i].label;

			if (dataPointX < axisXDataInfo.viewPortMin) axisXDataInfo.viewPortMin = dataPointX;
			if (dataPointX > axisXDataInfo.viewPortMax) axisXDataInfo.viewPortMax = dataPointX;

			if (dataPointY === null) continue;

			plotUnit.yTotals[dataPointX] = (!plotUnit.yTotals[dataPointX] ? 0 : plotUnit.yTotals[dataPointX]) + Math.abs(dataPointY);

			if (dataPointY >= 0) {
				containsPositiveY = true;
			} else {
				containsNegativeY = true;
			}

			if (dataPointYSums[dataPointX]) dataPointYSums[dataPointX] += Math.abs(dataPointY);else dataPointYSums[dataPointX] = Math.abs(dataPointY);
		}

		this.plotInfo.axisXValueType = dataSeries.xValueType = isDateTime ? "dateTime" : "number";
	}

	if (containsPositiveY && !containsNegativeY) {
		axisYDataInfo.max = 99;
		axisYDataInfo.min = 1;
	} else if (containsPositiveY && containsNegativeY) {
		axisYDataInfo.max = 99;
		axisYDataInfo.min = -99;
	} else if (!containsPositiveY && containsNegativeY) {
		axisYDataInfo.max = -1;
		axisYDataInfo.min = -99;
	}

	axisYDataInfo.viewPortMin = axisYDataInfo.min;
	axisYDataInfo.viewPortMax = axisYDataInfo.max;

	plotUnit.dataPointYSums = dataPointYSums;

	//this.dataPoints.sort(compareDataPointX);
	//this.dataPoints.sort(function (dataPoint1, dataPoint2) { return dataPoint1.x - dataPoint2.x; });

	//window.console.log("viewPortYMin: " + plotInfo.viewPortYMin + "; viewPortYMax: " + plotInfo.viewPortYMax);
};

Chart.prototype._processMultiYPlotUnit = function (plotUnit) {
	if (!plotUnit.dataSeriesIndexes || plotUnit.dataSeriesIndexes.length < 1) return;

	var axisYDataInfo = plotUnit.axisY.dataInfo;
	var axisXDataInfo = plotUnit.axisX.dataInfo;
	var dataPointX, dataPointY, dataPointYMin, dataPointYMax;
	var isDateTime = false;

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {
		var dataSeries = this.data[plotUnit.dataSeriesIndexes[j]];
		var i = 0;
		var isFirstDPInViewPort = false;
		var isLastDPInViewPort = false;

		if (dataSeries.axisPlacement === "normal" || dataSeries.axisPlacement === "xySwapped") {

			var plotAreaXMin = this.sessionVariables.axisX.newViewportMinimum ? this.sessionVariables.axisX.newViewportMinimum : this._options.axisX && this._options.axisX.viewportMinimum ? this._options.axisX.viewportMinimum : this._options.axisX && this._options.axisX.minimum ? this._options.axisX.minimum : -Infinity;

			var plotAreaXMax = this.sessionVariables.axisX.newViewportMaximum ? this.sessionVariables.axisX.newViewportMaximum : this._options.axisX && this._options.axisX.viewportMaximum ? this._options.axisX.viewportMaximum : this._options.axisX && this._options.axisX.maximum ? this._options.axisX.maximum : Infinity;
		}

		if (dataSeries.dataPoints[i].x && dataSeries.dataPoints[i].x.getTime || dataSeries.xValueType === "dateTime") {
			isDateTime = true;
		}

		for (i = 0; i < dataSeries.dataPoints.length; i++) {

			if (typeof dataSeries.dataPoints[i].x === "undefined") {
				dataSeries.dataPoints[i].x = i;
			}

			if (dataSeries.dataPoints[i].x.getTime) {
				isDateTime = true;
				dataPointX = dataSeries.dataPoints[i].x.getTime(); //dataPointX is used so that getTime is called only once in case of dateTime values
			} else dataPointX = dataSeries.dataPoints[i].x;

			dataPointY = dataSeries.dataPoints[i].y;

			if (dataPointY && dataPointY.length) {
				dataPointYMin = Math.min.apply(null, dataPointY);
				dataPointYMax = Math.max.apply(null, dataPointY);
			}

			if (dataPointX < axisXDataInfo.min) axisXDataInfo.min = dataPointX;
			if (dataPointX > axisXDataInfo.max) axisXDataInfo.max = dataPointX;

			if (dataPointYMin < axisYDataInfo.min) axisYDataInfo.min = dataPointYMin;

			if (dataPointYMax > axisYDataInfo.max) axisYDataInfo.max = dataPointYMax;

			if (i > 0) {
				var xDiff = dataPointX - dataSeries.dataPoints[i - 1].x;
				xDiff < 0 && (xDiff = xDiff * -1); //If Condition shortcut

				if (axisXDataInfo.minDiff > xDiff && xDiff !== 0) {
					axisXDataInfo.minDiff = xDiff;
				}

				if (dataPointY[0] !== null && dataSeries.dataPoints[i - 1].y[0] !== null) {
					var yDiff = dataPointY[0] - dataSeries.dataPoints[i - 1].y[0];
					yDiff < 0 && (yDiff = yDiff * -1); //If Condition shortcut

					if (axisYDataInfo.minDiff > yDiff && yDiff !== 0) {
						axisYDataInfo.minDiff = yDiff;
					}
				}
			}

			// This section makes sure that partially visible dataPoints are included in the begining
			if (dataPointX < plotAreaXMin && !isFirstDPInViewPort) {
				continue;
			} else if (!isFirstDPInViewPort) {
				isFirstDPInViewPort = true;

				if (i > 0) {
					i -= 2;
					continue;
				}
			}

			// This section makes sure that partially visible dataPoints are included at the end
			if (dataPointX > plotAreaXMax && !isLastDPInViewPort) {
				isLastDPInViewPort = true;
			} else if (dataPointX > plotAreaXMax && isLastDPInViewPort) {
				continue;
			}

			if (dataSeries.dataPoints[i].label) plotUnit.axisX.labels[dataPointX] = dataSeries.dataPoints[i].label;

			if (dataPointX < axisXDataInfo.viewPortMin) axisXDataInfo.viewPortMin = dataPointX;
			if (dataPointX > axisXDataInfo.viewPortMax) axisXDataInfo.viewPortMax = dataPointX;

			if (dataPointY === null) continue;

			if (dataPointYMin < axisYDataInfo.viewPortMin) axisYDataInfo.viewPortMin = dataPointYMin;
			if (dataPointYMax > axisYDataInfo.viewPortMax) axisYDataInfo.viewPortMax = dataPointYMax;
		}

		this.plotInfo.axisXValueType = dataSeries.xValueType = isDateTime ? "dateTime" : "number";
	}

	//this.dataPoints.sort(compareDataPointX);
	//this.dataPoints.sort(function (dataPoint1, dataPoint2) { return dataPoint1.x - dataPoint2.x; });
};

//getClosest returns objects nearby and hence shouldn't be used for events like click, mouseover, mousemove, etc which require object that is exactly under the mouse.
Chart.prototype.getDataPointAtXY = function (mouseX, mouseY, getClosest) {

	getClosest = getClosest || false;
	var results = [];

	for (var i = this._dataInRenderedOrder.length - 1; i >= 0; i--) {
		var dataSeries = this._dataInRenderedOrder[i];

		var result = null;

		result = dataSeries.getDataPointAtXY(mouseX, mouseY, getClosest);
		if (result) results.push(result);
	}

	var closestResult = null;
	var onlyLineAreaTypes = false;

	for (var m = 0; m < results.length; m++) {

		if (results[m].dataSeries.type === "line" || results[m].dataSeries.type === "stepLine" || results[m].dataSeries.type === "area" || results[m].dataSeries.type === "stepArea") {
			var markerSize = (0, _utils.getProperty)("markerSize", results[m].dataPoint, results[m].dataSeries) || 8;
			if (results[m].distance <= markerSize / 2) {
				onlyLineAreaTypes = true;
				break;
			}
		}
	}

	for (m = 0; m < results.length; m++) {

		if (onlyLineAreaTypes && results[m].dataSeries.type !== "line" && results[m].dataSeries.type !== "stepLine" && results[m].dataSeries.type !== "area" && results[m].dataSeries.type !== "stepArea") continue;

		if (!closestResult) {
			closestResult = results[m];
		} else if (results[m].distance <= closestResult.distance) {
			closestResult = results[m];
		}
	}

	return closestResult;
};

Chart.prototype.getObjectAtXY = function (mouseX, mouseY, getClosest) {
	getClosest = getClosest || false;

	var id = null;

	var dataPointInfo = this.getDataPointAtXY(mouseX, mouseY, getClosest);

	if (dataPointInfo) {
		id = dataPointInfo.dataSeries.dataPointIds[dataPointInfo.dataPointIndex];
	} else if (_utils.isCanvasSupported) {
		//IE9+
		id = (0, _utils.getObjectId)(mouseX, mouseY, this._eventManager.ghostCtx);
	} else {
		for (var i = 0; i < this.legend.items.length; i++) {
			var item = this.legend.items[i];

			if (mouseX >= item.x1 && mouseX <= item.x2 && mouseY >= item.y1 && mouseY <= item.y2) {
				id = item.id;
			}
		}
	}

	return id;
};

/// <summary>Calculates Font Size based on standardSize and Chart Size</summary>
/// <param name="standardSize" type="Number">Standard font size for a Chart with min(width,height) = 400px</param>
/// <returns type="Number">The area.</returns>
Chart.prototype.getAutoFontSize = function (standardSize, width, height) {

	width = width || this.width;
	height = height || this.height;

	var fontSizeScaleFactor = standardSize / 400;

	return Math.round(Math.min(this.width, this.height) * fontSizeScaleFactor);
};

//#region Events

Chart.prototype.resetOverlayedCanvas = function () {
	//var width = this.overlaidCanvas.width;
	//this.overlaidCanvas.width = 0;
	//this.overlaidCanvas.width = width;
	this.overlaidCanvasCtx.clearRect(0, 0, this.width, this.height);
};

Chart.prototype.clearCanvas = function () {
	this.ctx.clearRect(0, 0, this.width, this.height);

	if (this.backgroundColor) {
		this.ctx.fillStyle = this.backgroundColor;
		this.ctx.fillRect(0, 0, this.width, this.height);
	}
};

Chart.prototype.attachEvent = function (param) {
	this._events.push(param);
};

Chart.prototype._touchEventHandler = function (ev) {
	if (!ev.changedTouches || !this.interactivityEnabled) return;

	var mouseEvents = [];
	var touches = ev.changedTouches;
	var first = touches ? touches[0] : ev;
	var touchCurrentCoordinates = null;

	//window.console.log(touches.length);

	switch (ev.type) {
		case "touchstart":case "MSPointerDown":
			mouseEvents = ["mousemove", "mousedown"];
			this._lastTouchData = (0, _utils.getMouseCoordinates)(first);
			this._lastTouchData.time = new Date();
			break;
		case "touchmove":case "MSPointerMove":
			mouseEvents = ["mousemove"];break;
		case "touchend":case "MSPointerUp":
			mouseEvents = this._lastTouchEventType === "touchstart" || this._lastTouchEventType === "MSPointerDown" ? ["mouseup", "click"] : ["mouseup"];
			break;
		default:
			return;
	}

	if (touches && touches.length > 1) return;

	touchCurrentCoordinates = (0, _utils.getMouseCoordinates)(first);
	touchCurrentCoordinates.time = new Date();
	try {
		var dy = touchCurrentCoordinates.y - this._lastTouchData.y;
		var dx = touchCurrentCoordinates.x - this._lastTouchData.x;
		var dt = touchCurrentCoordinates.time - this._lastTouchData.time;

		if (Math.abs(dy) > 15 && (!!this._lastTouchData.scroll || dt < 200)) {
			//this._lastTouchData.y = touchCurrentCoordinates.y;
			this._lastTouchData.scroll = true;

			var win = window.parent || window;
			if (win && win.scrollBy) win.scrollBy(0, -dy);
		}
	} catch (e) {};

	this._lastTouchEventType = ev.type;

	if (!!this._lastTouchData.scroll && this.zoomEnabled) {
		if (this.isDrag) this.resetOverlayedCanvas();

		this.isDrag = false;
		return;
	}

	for (var i = 0; i < mouseEvents.length; i++) {

		var type = mouseEvents[i];
		var simulatedEvent = document.createEvent("MouseEvent");
		simulatedEvent.initMouseEvent(type, true, true, window, 1, first.screenX, first.screenY, first.clientX, first.clientY, false, false, false, false, 0, null);

		first.target.dispatchEvent(simulatedEvent);

		if (ev.preventManipulation) {
			//alert("preventManipulation");
			ev.preventManipulation();
		}

		if (ev.preventDefault) {
			//alert("preventDefault");
			ev.preventDefault();
		}
	}
};

Chart.prototype._dispatchRangeEvent = function (eventName, triggerSource) {
	var eventParameter = {};

	eventParameter.chart = this._publicChartReference;
	eventParameter.type = eventName;
	eventParameter.trigger = triggerSource;

	var axes = [];

	if (this.axisX) axes.push("axisX");
	if (this.axisY) axes.push("axisY");
	if (this.axisY2) axes.push("axisY2");

	for (var i = 0; i < axes.length; i++) {
		eventParameter[axes[i]] = {
			viewportMinimum: this[axes[i]].sessionVariables.newViewportMinimum,
			viewportMaximum: this[axes[i]].sessionVariables.newViewportMaximum
		};
	}

	this.dispatchEvent(eventName, eventParameter, this._publicChartReference);
};

Chart.prototype._mouseEventHandler = function (ev) {

	if (!this.interactivityEnabled) return;

	if (this._ignoreNextEvent) {
		this._ignoreNextEvent = false;
		return;
	}

	// stop panning and zooming so we can draw
	if (ev.preventManipulation) {
		//alert("preventManipulation");
		ev.preventManipulation();
	}

	// we are handling this event
	if (ev.preventDefault) {
		//alert("preventDefault");
		ev.preventDefault();
	}

	//IE8- uses srcElement instead of target. So instead of checking this condition everytime, its better to create a reference called target.
	if (typeof ev.target === "undefined" && ev.srcElement) ev.target = ev.srcElement;

	//console.log(ev.type);

	var xy = (0, _utils.getMouseCoordinates)(ev);
	var type = ev.type;
	var eventParam;
	var rightclick;

	if (!ev) var e = window.event;
	if (ev.which) rightclick = ev.which == 3;else if (ev.button) rightclick = ev.button == 2;

	//window.console.log(type + " --> x: " + xy.x + "; y:" + xy.y);

	//if (type === "mouseout") {
	//    this._toolTip.hide();
	//}

	if (_options.isDebugMode && window.console) {
		window.console.log(type + " --> x: " + xy.x + "; y:" + xy.y);
		if (rightclick) window.console.log(ev.which);

		if (type === "mouseup") window.console.log("mouseup");
	}

	if (rightclick) return;

	//if (this.plotInfo.axisPlacement === "xySwapped") {
	//    //var temp = xy.x;
	//    //xy.x = xy.y;
	//    //xy.y = temp;
	//    xy = {x: xy.y, y: xy.x};
	//}

	if (Chart.capturedEventParam) {
		eventParam = Chart.capturedEventParam;

		if (type === "mouseup") {
			Chart.capturedEventParam = null;

			if (eventParam.chart.overlaidCanvas.releaseCapture) eventParam.chart.overlaidCanvas.releaseCapture();else document.body.removeEventListener("mouseup", eventParam.chart._mouseEventHandler, false);
		}

		if (eventParam.hasOwnProperty(type)) eventParam[type].call(eventParam.context, xy.x, xy.y);
	} else if (this._events) {

		for (var i = 0; i < this._events.length; i++) {
			if (!this._events[i].hasOwnProperty(type)) continue;

			eventParam = this._events[i];
			var bounds = eventParam.bounds;

			if (xy.x >= bounds.x1 && xy.x <= bounds.x2 && xy.y >= bounds.y1 && xy.y <= bounds.y2) {
				eventParam[type].call(eventParam.context, xy.x, xy.y);

				if (type === "mousedown" && eventParam.capture === true) {
					Chart.capturedEventParam = eventParam;

					if (this.overlaidCanvas.setCapture) this.overlaidCanvas.setCapture();else {
						document.body.addEventListener("mouseup", this._mouseEventHandler, false);
						//addEvent(document.body, "mouseup", this._mouseEventHandler);
					}
				} else if (type === "mouseup") {
					if (eventParam.chart.overlaidCanvas.releaseCapture) eventParam.chart.overlaidCanvas.releaseCapture();else document.body.removeEventListener("mouseup", this._mouseEventHandler, false);
				}

				break;
			} else eventParam = null;
		}

		if (eventParam && eventParam.cursor) {
			ev.target.style.cursor = eventParam.cursor;
		} else ev.target.style.cursor = this._defaultCursor;

		//eventParam =
	}

	if (this._toolTip && this._toolTip.enabled) {

		var plotArea = this.plotArea;

		if (xy.x < plotArea.x1 || xy.x > plotArea.x2 || xy.y < plotArea.y1 || xy.y > plotArea.y2) this._toolTip.hide();
	}

	if ((!this.isDrag || !this.zoomEnabled) && this._eventManager) {

		this._eventManager.mouseEventHandler(ev);
		//this._updateToolTip(ev.x, ev.y);
	}

	//if (this._toolTip.enabled)
	//    this._toolTip.mouseMoveHandler(ev.x, ev.y);
};

Chart.prototype._plotAreaMouseDown = function (x, y) {
	this.isDrag = true;

	if (this.plotInfo.axisPlacement !== "none") {
		this.dragStartPoint = { x: x, y: y };
	} else {
		this.dragStartPoint = { x: x, y: y };
	}
};

Chart.prototype._plotAreaMouseUp = function (x, y) {

	if (this.plotInfo.axisPlacement === "normal" || this.plotInfo.axisPlacement === "xySwapped") {
		if (this.isDrag) {
			var dragDelta = 0,
			    dragDeltaPY = y - this.dragStartPoint.y,
			    dragDeltaPX = x - this.dragStartPoint.x,
			    zoomPX = this.zoomType.indexOf("x") >= 0,
			    //Whether to zoom horizontally
			zoomPY = this.zoomType.indexOf("y") >= 0,
			    //Whether to zoom vertically
			reRender = false;

			this.resetOverlayedCanvas();

			if (this.plotInfo.axisPlacement === "xySwapped") {
				var temp = zoomPY;
				zoomPY = zoomPX;
				zoomPX = temp;
			}

			if (this.panEnabled || this.zoomEnabled) {
				if (this.panEnabled) {

					var overflow = 0;

					for (var i = 0; i < this._axes.length; i++) {
						var axis = this._axes[i];

						if (axis.viewportMinimum < axis.minimum) {

							overflow = axis.minimum - axis.viewportMinimum;

							axis.sessionVariables.newViewportMinimum = axis.viewportMinimum + overflow;
							axis.sessionVariables.newViewportMaximum = axis.viewportMaximum + overflow;

							reRender = true;
						} else if (axis.viewportMaximum > axis.maximum) {

							overflow = axis.viewportMaximum - axis.maximum;
							axis.sessionVariables.newViewportMinimum = axis.viewportMinimum - overflow;
							axis.sessionVariables.newViewportMaximum = axis.viewportMaximum - overflow;

							reRender = true;
						}
					}
				} else if ((!zoomPX || Math.abs(dragDeltaPX) > 2) && (!zoomPY || Math.abs(dragDeltaPY) > 2) && this.zoomEnabled) {

					if (!this.dragStartPoint) return;

					var selectedRegion = {
						x1: zoomPX ? this.dragStartPoint.x : this.plotArea.x1,
						y1: zoomPY ? this.dragStartPoint.y : this.plotArea.y1,
						x2: zoomPX ? x : this.plotArea.x2,
						y2: zoomPY ? y : this.plotArea.y2
					};

					if (Math.abs(selectedRegion.x1 - selectedRegion.x2) > 2 && Math.abs(selectedRegion.y1 - selectedRegion.y2) > 2) {

						if (this._zoomPanToSelectedRegion(selectedRegion.x1, selectedRegion.y1, selectedRegion.x2, selectedRegion.y2)) {

							reRender = true;
						}
					}
				}

				if (reRender) {
					this._ignoreNextEvent = true; //Required so that click event doesn't fire after zooming into a section of the chart.

					this._dispatchRangeEvent("rangeChanging", "zoom");
					this.render();
					this._dispatchRangeEvent("rangeChanged", "zoom");

					if (reRender && this.zoomEnabled && this._zoomButton.style.display === "none") {
						(0, _utils.show)(this._zoomButton, this._resetButton);
						setButtonState(this, this._zoomButton, "pan");
						setButtonState(this, this._resetButton, "reset");
					}
				}
			}
		}
	}

	this.isDrag = false;
};

Chart.prototype._plotAreaMouseMove = function (x, y) {
	if (this.isDrag && this.plotInfo.axisPlacement !== "none") {

		var dragDeltaPX = 0,
		    dragDeltaPY = 0,
		    alpha = null,
		    selectedRegion = null,
		    zoomPX = this.zoomType.indexOf("x") >= 0,
		    //Whether to zoom horizontally
		zoomPY = this.zoomType.indexOf("y") >= 0,
		    //Whether to zoom vertically
		_this = this;

		if (this.plotInfo.axisPlacement === "xySwapped") {
			var temp = zoomPY;
			zoomPY = zoomPX;
			zoomPX = temp;
		}

		dragDeltaPX = this.dragStartPoint.x - x;
		dragDeltaPY = this.dragStartPoint.y - y;

		if (Math.abs(dragDeltaPX) > 2 && Math.abs(dragDeltaPX) < 8 && (this.panEnabled || this.zoomEnabled)) {
			this._toolTip.hide();
		} else if (!this.panEnabled && !this.zoomEnabled) {
			this._toolTip.mouseMoveHandler(x, y);
		}

		if ((!zoomPX || Math.abs(dragDeltaPX) > 2 || !zoomPY || Math.abs(dragDeltaPY) > 2) && (this.panEnabled || this.zoomEnabled)) {
			if (this.panEnabled) {

				selectedRegion = {
					x1: zoomPX ? this.plotArea.x1 + dragDeltaPX : this.plotArea.x1,
					y1: zoomPY ? this.plotArea.y1 + dragDeltaPY : this.plotArea.y1,
					x2: zoomPX ? this.plotArea.x2 + dragDeltaPX : this.plotArea.x2,
					y2: zoomPY ? this.plotArea.y2 + dragDeltaPY : this.plotArea.y2
				};

				if (this._zoomPanToSelectedRegion(selectedRegion.x1, selectedRegion.y1, selectedRegion.x2, selectedRegion.y2, true)) {
					this._dispatchRangeEvent("rangeChanging", "pan");
					this.render();
					this._dispatchRangeEvent("rangeChanged", "pan");

					this.dragStartPoint.x = x;
					this.dragStartPoint.y = y;

					//clearTimeout(this._panTimerId);
					//this._panTimerId = setTimeout(function () {
					//	_this._dispatchRangeEvent("rangeChanging", "pan");
					//	_this.render();
					//	_this._dispatchRangeEvent("rangeChanged", "pan");
					//}, 0);
				}
			} else if (this.zoomEnabled) {

				this.resetOverlayedCanvas();

				alpha = this.overlaidCanvasCtx.globalAlpha;

				this.overlaidCanvasCtx.globalAlpha = .7;
				this.overlaidCanvasCtx.fillStyle = "#A0ABB8";

				var rect = {
					x1: zoomPX ? this.dragStartPoint.x : this.plotArea.x1,
					y1: zoomPY ? this.dragStartPoint.y : this.plotArea.y1,
					x2: zoomPX ? x - this.dragStartPoint.x : this.plotArea.x2 - this.plotArea.x1,
					y2: zoomPY ? y - this.dragStartPoint.y : this.plotArea.y2 - this.plotArea.y1
				};

				this.overlaidCanvasCtx.fillRect(rect.x1, rect.y1, rect.x2, rect.y2);

				this.overlaidCanvasCtx.globalAlpha = alpha;
			}
		}
	} else this._toolTip.mouseMoveHandler(x, y);
};

//#endregion Events

//Sets the viewport range of Axis based on the given rect bounds (pixels). Also limits the zooming/panning based on axis bounds. Returns a boolean to indicate whether it was succesful or not based on the selected region.
Chart.prototype._zoomPanToSelectedRegion = function (px1, py1, px2, py2, keepAxisIndependent) {

	keepAxisIndependent = keepAxisIndependent || false;

	var zoomPX = this.zoomType.indexOf("x") >= 0,
	    //Whether to zoom horizontally
	zoomPY = this.zoomType.indexOf("y") >= 0,
	    //Whether to zoom vertically
	validRegion = false;

	var axes = [],
	    axesWithValidRange = [];
	if (this.axisX && zoomPX) axes.push(this.axisX);
	if (this.axisY && zoomPY) axes.push(this.axisY);
	if (this.axisY2 && zoomPY) axes.push(this.axisY2);

	var params = [];

	for (var i = 0; i < axes.length; i++) {
		var axis = axes[i];
		//var range = Math.abs(axis.viewportMaximum - axis.viewportMinimum);

		var val1 = axis.convertPixelToValue({ x: px1, y: py1 });
		var val2 = axis.convertPixelToValue({ x: px2, y: py2 });

		if (val1 > val2) {
			var temp = val2;
			val2 = val1;
			val1 = temp;
		}

		if (isFinite(axis.dataInfo.minDiff)) {
			if (!(Math.abs(val2 - val1) < 3 * Math.abs(axis.dataInfo.minDiff) || val1 < axis.minimum || val2 > axis.maximum)) {
				axesWithValidRange.push(axis);
				params.push({ val1: val1, val2: val2 });

				validRegion = true;
			} else if (!keepAxisIndependent) {
				validRegion = false;
				break;
			}
		}
	}

	if (validRegion) {
		for (var i = 0; i < axesWithValidRange.length; i++) {
			var axis = axesWithValidRange[i];
			var param = params[i];

			axis.setViewPortRange(param.val1, param.val2);
		}
	}

	return validRegion;
};

Chart.prototype.preparePlotArea = function () {

	var plotArea = this.plotArea;

	var yAxis = this.axisY ? this.axisY : this.axisY2;

	if (!_utils.isCanvasSupported && (plotArea.x1 > 0 || plotArea.y1 > 0)) {
		plotArea.ctx.translate(plotArea.x1, plotArea.y1);
	}

	if (this.axisX && yAxis) {
		plotArea.x1 = this.axisX.lineCoordinates.x1 < this.axisX.lineCoordinates.x2 ? this.axisX.lineCoordinates.x1 : yAxis.lineCoordinates.x1;
		plotArea.y1 = this.axisX.lineCoordinates.y1 < yAxis.lineCoordinates.y1 ? this.axisX.lineCoordinates.y1 : yAxis.lineCoordinates.y1;

		plotArea.x2 = this.axisX.lineCoordinates.x2 > yAxis.lineCoordinates.x2 ? this.axisX.lineCoordinates.x2 : yAxis.lineCoordinates.x2;
		plotArea.y2 = this.axisX.lineCoordinates.y2 > this.axisX.lineCoordinates.y1 ? this.axisX.lineCoordinates.y2 : yAxis.lineCoordinates.y2;

		plotArea.width = plotArea.x2 - plotArea.x1;
		plotArea.height = plotArea.y2 - plotArea.y1;
		//plotArea = { x1: x1, y1: y1, x2: x2, y2: y2, width: x2 - x1, height: y2 - y1 };
	} else {
		//ToDo: @sunil
		var freeSpace = this.layoutManager.getFreeSpace();
		plotArea.x1 = freeSpace.x1;
		plotArea.x2 = freeSpace.x2;
		plotArea.y1 = freeSpace.y1;
		plotArea.y2 = freeSpace.y2;

		plotArea.width = freeSpace.width;
		plotArea.height = freeSpace.height;
	}

	if (!_utils.isCanvasSupported) {

		plotArea.canvas.width = plotArea.width;
		plotArea.canvas.height = plotArea.height;

		plotArea.canvas.style.left = plotArea.x1 + "px";
		plotArea.canvas.style.top = plotArea.y1 + "px";

		if (plotArea.x1 > 0 || plotArea.y1 > 0) {
			plotArea.ctx.translate(-plotArea.x1, -plotArea.y1);
		}
	}

	plotArea.layoutManager = new _layout_manager2.default(plotArea.x1, plotArea.y1, plotArea.x2, plotArea.y2, 2);
};

Chart.prototype.getPixelCoordinatesOnPlotArea = function (x, y) {
	return {
		x: this.axisX.getPixelCoordinatesOnAxis(x).x, y: this.axisY.getPixelCoordinatesOnAxis(y).y
		//return { x: 5, y: 10 };
	};
};

//#region Render Methods

Chart.prototype.renderIndexLabels = function (targetCtx) {
	var ctx = targetCtx || this.plotArea.ctx;

	var plotArea = this.plotArea;

	var mid = 0;
	var yMinLimit = 0;
	var yMaxLimit = 0;
	var xMinLimit = 0;
	var xMaxLimit = 0;
	var marginX = 0,
	    marginY = 0; // Margin between label and dataPoint / PlotArea
	var offSetX = 0,
	    offSetY = 0; // Distance to offSet textBlock (top) from dataPoint inorder to position it
	var visibleWidth = 0;
	var visibleHeight = 0;

	for (var i = 0; i < this._indexLabels.length; i++) {

		var indexLabel = this._indexLabels[i];
		var chartTypeLower = indexLabel.chartType.toLowerCase();

		var x, y, angle;

		var fontColor = (0, _utils.getProperty)("indexLabelFontColor", indexLabel.dataPoint, indexLabel.dataSeries);
		var fontSize = (0, _utils.getProperty)("indexLabelFontSize", indexLabel.dataPoint, indexLabel.dataSeries);
		var fontFamily = (0, _utils.getProperty)("indexLabelFontFamily", indexLabel.dataPoint, indexLabel.dataSeries);
		var fontStyle = (0, _utils.getProperty)("indexLabelFontStyle", indexLabel.dataPoint, indexLabel.dataSeries);
		var fontWeight = (0, _utils.getProperty)("indexLabelFontWeight", indexLabel.dataPoint, indexLabel.dataSeries);
		var backgroundColor = (0, _utils.getProperty)("indexLabelBackgroundColor", indexLabel.dataPoint, indexLabel.dataSeries);
		var maxWidth = (0, _utils.getProperty)("indexLabelMaxWidth", indexLabel.dataPoint, indexLabel.dataSeries);
		var indexLabelWrap = (0, _utils.getProperty)("indexLabelWrap", indexLabel.dataPoint, indexLabel.dataSeries);

		var percentAndTotal = {
			percent: null, total: null
		};
		var formatterParameter = null;

		if (indexLabel.dataSeries.type.indexOf("stacked") >= 0 || indexLabel.dataSeries.type === "pie" || indexLabel.dataSeries.type === "doughnut") percentAndTotal = this.getPercentAndTotal(indexLabel.dataSeries, indexLabel.dataPoint);

		if (indexLabel.dataSeries.indexLabelFormatter || indexLabel.dataPoint.indexLabelFormatter) formatterParameter = {
			chart: this._options, dataSeries: indexLabel.dataSeries, dataPoint: indexLabel.dataPoint, index: indexLabel.indexKeyword, total: percentAndTotal.total, percent: percentAndTotal.percent
		};

		var indexLabelText = indexLabel.dataPoint.indexLabelFormatter ? indexLabel.dataPoint.indexLabelFormatter(formatterParameter) : indexLabel.dataPoint.indexLabel ? this.replaceKeywordsWithValue(indexLabel.dataPoint.indexLabel, indexLabel.dataPoint, indexLabel.dataSeries, null, indexLabel.indexKeyword) : indexLabel.dataSeries.indexLabelFormatter ? indexLabel.dataSeries.indexLabelFormatter(formatterParameter) : indexLabel.dataSeries.indexLabel ? this.replaceKeywordsWithValue(indexLabel.dataSeries.indexLabel, indexLabel.dataPoint, indexLabel.dataSeries, null, indexLabel.indexKeyword) : null;

		if (indexLabelText === null || indexLabelText === "") continue;

		var placement = (0, _utils.getProperty)("indexLabelPlacement", indexLabel.dataPoint, indexLabel.dataSeries);
		var orientation = (0, _utils.getProperty)("indexLabelOrientation", indexLabel.dataPoint, indexLabel.dataSeries);
		var angle = 0;

		var direction = indexLabel.direction; // +1 for above the point and -1 for below the point

		var axisX = indexLabel.dataSeries.axisX;
		var axisY = indexLabel.dataSeries.axisY;

		var textBlock = new _text_block2.default(ctx, {
			x: 0,
			y: 0,
			maxWidth: maxWidth ? maxWidth : this.width * .5,
			maxHeight: indexLabelWrap ? fontSize * 5 : fontSize * 1.5,
			angle: orientation === "horizontal" ? 0 : -90,
			text: indexLabelText,
			padding: 0,
			backgroundColor: backgroundColor,
			horizontalAlign: "left", //left, center, right
			fontSize: fontSize, //in pixels
			fontFamily: fontFamily,
			fontWeight: fontWeight, //normal, bold, bolder, lighter,
			fontColor: fontColor,
			fontStyle: fontStyle, // normal, italic, oblique
			textBaseline: "top"
		});

		var textSize = textBlock.measureText();

		//if (indexLabel.dataPoint.x < axisX.viewportMinimum || indexLabel.dataPoint.x > axisX.viewportMaximum || indexLabel.dataPoint.y < axisY.viewportMinimum || indexLabel.dataPoint.y > axisY.viewportMaximum)
		//	continue;

		if (chartTypeLower.indexOf("line") >= 0 || chartTypeLower.indexOf("area") >= 0 || chartTypeLower.indexOf("bubble") >= 0 || chartTypeLower.indexOf("scatter") >= 0) {

			if (indexLabel.dataPoint.x < axisX.viewportMinimum || indexLabel.dataPoint.x > axisX.viewportMaximum || indexLabel.dataPoint.y < axisY.viewportMinimum || indexLabel.dataPoint.y > axisY.viewportMaximum) continue;
		} else {
			if (indexLabel.dataPoint.x < axisX.viewportMinimum || indexLabel.dataPoint.x > axisX.viewportMaximum) continue;
		}

		marginY = 2;
		marginX = 2;

		if (orientation === "horizontal") {
			visibleWidth = textBlock.width;
			visibleHeight = textBlock.height;
		} else {
			visibleHeight = textBlock.width;
			visibleWidth = textBlock.height;
		}

		if (this.plotInfo.axisPlacement === "normal") {

			if (chartTypeLower.indexOf("line") >= 0 || chartTypeLower.indexOf("area") >= 0) {

				placement = "auto";
				marginY = 4;
			} else if (chartTypeLower.indexOf("stacked") >= 0) {

				if (placement === "auto") placement = "inside";
			} else if (chartTypeLower === "bubble" || chartTypeLower === "scatter") {

				placement = "inside";
			}

			x = indexLabel.point.x - visibleWidth / 2;

			if (placement !== "inside") {
				//outside or auto

				yMinLimit = plotArea.y1;
				yMaxLimit = plotArea.y2;

				if (direction > 0) {
					y = indexLabel.point.y - visibleHeight - marginY;

					if (y < yMinLimit) {
						if (placement === "auto") {
							y = Math.max(indexLabel.point.y, yMinLimit) + marginY;
						} else {
							y = yMinLimit + marginY;
						}
					}
				} else {
					y = indexLabel.point.y + marginY;

					if (y > yMaxLimit - visibleHeight - marginY) {
						if (placement === "auto") {
							y = Math.min(indexLabel.point.y, yMaxLimit) - visibleHeight - marginY;
						} else {
							y = yMaxLimit - visibleHeight - marginY;
						}
					}
				}
			} else {

				yMinLimit = Math.max(indexLabel.bounds.y1, plotArea.y1);
				yMaxLimit = Math.min(indexLabel.bounds.y2, plotArea.y2);

				if (chartTypeLower.indexOf("range") >= 0) {
					if (direction > 0) mid = Math.max(indexLabel.bounds.y1, plotArea.y1) + visibleHeight / 2 + marginY;else mid = Math.min(indexLabel.bounds.y2, plotArea.y2) - visibleHeight / 2 - marginY;
				} else mid = (Math.max(indexLabel.bounds.y1, plotArea.y1) + Math.min(indexLabel.bounds.y2, plotArea.y2)) / 2;

				if (direction > 0) {
					y = Math.max(indexLabel.point.y, mid) - visibleHeight / 2;

					if (y < yMinLimit && (chartTypeLower === "bubble" || chartTypeLower === "scatter")) {
						y = Math.max(indexLabel.point.y - visibleHeight - marginY, plotArea.y1 + marginY);
					}
				} else {
					y = Math.min(indexLabel.point.y, mid) - visibleHeight / 2;

					if (y > yMaxLimit - visibleHeight - marginY && (chartTypeLower === "bubble" || chartTypeLower === "scatter")) {
						y = Math.min(indexLabel.point.y + marginY, plotArea.y2 - visibleHeight - marginY);
					}
				}

				// Make Sure that it does not overlap the axis line
				y = Math.min(y, yMaxLimit - visibleHeight);
			}
		} else {

			if (chartTypeLower.indexOf("line") >= 0 || chartTypeLower.indexOf("area") >= 0 || chartTypeLower.indexOf("scatter") >= 0) {

				placement = "auto";
				marginX = 4;
			} else if (chartTypeLower.indexOf("stacked") >= 0) {

				if (placement === "auto") placement = "inside";
			} else if (chartTypeLower === "bubble") {

				placement = "inside";
			}

			y = indexLabel.point.y - visibleHeight / 2;

			if (placement !== "inside") {
				//outside or auto

				xMinLimit = plotArea.x1;
				xMaxLimit = plotArea.x2;

				if (direction < 0) {
					x = indexLabel.point.x - visibleWidth - marginX;

					if (x < xMinLimit) {
						if (placement === "auto") {
							x = Math.max(indexLabel.point.x, xMinLimit) + marginX;
						} else {
							x = xMinLimit + marginX;
						}
					}
				} else {
					x = indexLabel.point.x + marginX;

					if (x > xMaxLimit - visibleWidth - marginX) {
						if (placement === "auto") {
							x = Math.min(indexLabel.point.x, xMaxLimit) - visibleWidth - marginX;
						} else {
							x = xMaxLimit - visibleWidth - marginX;
						}
					}
				}
			} else {

				xMinLimit = Math.max(indexLabel.bounds.x1, plotArea.x1);
				xMaxLimit = Math.min(indexLabel.bounds.x2, plotArea.x2);

				if (chartTypeLower.indexOf("range") >= 0) {
					if (direction < 0) mid = Math.max(indexLabel.bounds.x1, plotArea.x1) + visibleWidth / 2 + marginX;else mid = Math.min(indexLabel.bounds.x2, plotArea.x2) - visibleWidth / 2 - marginX;
				} else var mid = (Math.max(indexLabel.bounds.x1, plotArea.x1) + Math.min(indexLabel.bounds.x2, plotArea.x2)) / 2;

				if (direction < 0) {
					x = Math.max(indexLabel.point.x, mid) - visibleWidth / 2;

					//if (y < xMinLimit) {
					//	y = Math.max(indexLabel.point.y - visibleHeight - marginY, plotArea.y1 + marginY);
					//}
				} else {
					x = Math.min(indexLabel.point.x, mid) - visibleWidth / 2;

					//if (y > xMaxLimit - visibleHeight - marginY) {
					//	y = Math.min(indexLabel.point.y + marginY, plotArea.y2 - visibleHeight - marginY);
					//}
				}

				// Make Sure that it does not overlap the axis line
				x = Math.max(x, xMinLimit);
			}
		}

		if (orientation === "vertical") {
			y += visibleHeight;
		}

		textBlock.x = x;
		textBlock.y = y;

		//console.log(textBlock.text + ": " + textBlock.x + "; " + textBlock.y);

		textBlock.render(true);
	}

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: _animator4.default.fadeInAnimation, easingFunction: _animator4.default.easing.easeInQuad, animationBase: 0, startTimePercent: .7
	};
	return animationInfo;
};

Chart.prototype.renderLine = function (plotUnit) {

	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;

	var totalDataSeries = plotUnit.dataSeriesIndexes.length;
	if (totalDataSeries <= 0) return;

	var ghostCtx = this._eventManager.ghostCtx;
	//var ghostCtx = this.overlaidCanvasCtx;

	ctx.save();

	var plotArea = this.plotArea;

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	var markers = [];

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		ctx.lineWidth = dataSeries.lineThickness;
		var dataPoints = dataSeries.dataPoints;

		if (ctx.setLineDash) {
			ctx.setLineDash((0, _utils.getLineDashArray)(dataSeries.lineDashType, dataSeries.lineThickness));
		}

		var seriesId = dataSeries.id;
		this._eventManager.objectMap[seriesId] = {
			objectType: "dataSeries", dataSeriesIndex: dataSeriesIndex
		};
		var hexColor = (0, _utils.intToHexColorString)(seriesId);
		ghostCtx.strokeStyle = hexColor;
		//ghostCtx.lineWidth = dataSeries.lineThickness;
		ghostCtx.lineWidth = dataSeries.lineThickness > 0 ? Math.max(dataSeries.lineThickness, 4) : 0;

		var colorSet = dataSeries._colorSet;
		var color = colorSet[0];
		ctx.strokeStyle = color;

		var isFirstDataPointInPlotArea = true;
		var i = 0,
		    x,
		    y;
		var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number back and forth.

		//if (!dataSeries._options.markerSize && dataSeries.dataPoints.length < 1000)
		//    dataSeries.markerSize = 8;
		ctx.beginPath();
		if (dataPoints.length > 0) {
			//var xy = this.getPixelCoordinatesOnPlotArea(dataPoints[0].x, dataPoints[0].y);

			//dataSeries.noDataPointsInPlotArea = 0
			var prevDataNull = false;
			for (i = 0; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].x.getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) continue;

				//if (!isFinite(dataPoints[i].y))
				//    continue;

				if (typeof dataPoints[i].y !== "number") {
					if (i > 0) {
						// if first dataPoint is null then no need to call stroke method
						ctx.stroke();

						if (_utils.isCanvasSupported) {
							ghostCtx.stroke();
						}
					}

					prevDataNull = true;
					continue;
				}

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				y = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x, y1: y
				};

				//dataSeries.noDataPointsInPlotArea++;

				if (isFirstDataPointInPlotArea || prevDataNull) {
					ctx.beginPath();
					ctx.moveTo(x, y);

					if (_utils.isCanvasSupported) {
						ghostCtx.beginPath();
						ghostCtx.moveTo(x, y);
					}

					isFirstDataPointInPlotArea = false;
					prevDataNull = false;
				} else {

					ctx.lineTo(x, y);

					if (_utils.isCanvasSupported) ghostCtx.lineTo(x, y);

					if (i % 500 == 0) {
						ctx.stroke();
						ctx.beginPath();
						ctx.moveTo(x, y);

						if (_utils.isCanvasSupported) {
							ghostCtx.stroke();
							ghostCtx.beginPath();
							ghostCtx.moveTo(x, y);
						}
					}
				}

				//Render Marker
				if (dataPoints[i].markerSize > 0 || dataSeries.markerSize > 0) {

					var markerProps = dataSeries.getMarkerProperties(i, x, y, ctx);
					markers.push(markerProps);

					//if (!dataSeries.maxWidthInX || markerProps.size > dataSeries.maxWidthInX) {
					//	dataSeries.maxWidthInX = markerProps.size / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);
					//}

					var markerColor = (0, _utils.intToHexColorString)(id);

					//window.console.log("index: " + i + "; id: " + id + "; hex: " + markerColor);

					if (_utils.isCanvasSupported) {
						markers.push({
							x: x, y: y, ctx: ghostCtx,
							type: markerProps.type,
							size: markerProps.size,
							color: markerColor,
							borderColor: markerColor,
							borderThickness: markerProps.borderThickness
						});
					}
				}

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "line",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						point: {
							x: x, y: y
						},
						direction: dataPoints[i].y >= 0 ? 1 : -1,
						color: color
					});
				}
			}

			ctx.stroke();

			if (_utils.isCanvasSupported) ghostCtx.stroke();
		}
	}

	_render2.default.drawMarkers(markers);
	ctx.restore();

	ctx.beginPath();

	if (_utils.isCanvasSupported) ghostCtx.beginPath();

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: _animator4.default.xClipAnimation, easingFunction: _animator4.default.easing.linear, animationBase: 0
	};
	return animationInfo;
};

Chart.prototype.renderStepLine = function (plotUnit) {
	var ctx = plotUnit.targetCanvasCtx || this.plotArea.ctx;

	var totalDataSeries = plotUnit.dataSeriesIndexes.length;
	if (totalDataSeries <= 0) return;

	var ghostCtx = this._eventManager.ghostCtx;
	//var ghostCtx = this.overlaidCanvasCtx;

	ctx.save();

	var plotArea = this.plotArea;

	ctx.beginPath();
	ctx.rect(plotArea.x1, plotArea.y1, plotArea.width, plotArea.height);
	ctx.clip();

	var markers = [];

	for (var j = 0; j < plotUnit.dataSeriesIndexes.length; j++) {

		var dataSeriesIndex = plotUnit.dataSeriesIndexes[j];

		var dataSeries = this.data[dataSeriesIndex];
		ctx.lineWidth = dataSeries.lineThickness;
		var dataPoints = dataSeries.dataPoints;

		if (ctx.setLineDash) {
			ctx.setLineDash((0, _utils.getLineDashArray)(dataSeries.lineDashType, dataSeries.lineThickness));
		}

		var seriesId = dataSeries.id;
		this._eventManager.objectMap[seriesId] = {
			objectType: "dataSeries", dataSeriesIndex: dataSeriesIndex
		};
		var hexColor = (0, _utils.intToHexColorString)(seriesId);
		ghostCtx.strokeStyle = hexColor;
		//ghostCtx.lineWidth = dataSeries.lineThickness;
		ghostCtx.lineWidth = dataSeries.lineThickness > 0 ? Math.max(dataSeries.lineThickness, 4) : 0;

		var colorSet = dataSeries._colorSet;
		var color = colorSet[0];
		ctx.strokeStyle = color;

		var isFirstDataPointInPlotArea = true;
		var i = 0,
		    x,
		    y;
		var dataPointX; //Used so that when dataPoint.x is a DateTime value, it doesn't get converted to number back and forth.

		//if (!dataSeries._options.markerSize && dataSeries.dataPoints.length < 1000)
		//    dataSeries.markerSize = 8;
		ctx.beginPath();
		if (dataPoints.length > 0) {
			//var xy = this.getPixelCoordinatesOnPlotArea(dataPoints[0].x, dataPoints[0].y);

			//dataSeries.noDataPointsInPlotArea = 0
			var prevDataNull = false;
			for (i = 0; i < dataPoints.length; i++) {

				dataPointX = dataPoints[i].getTime ? dataPoints[i].x.getTime() : dataPoints[i].x;

				if (dataPointX < plotUnit.axisX.dataInfo.viewPortMin || dataPointX > plotUnit.axisX.dataInfo.viewPortMax) continue;

				//if (!isFinite(dataPoints[i].y))
				//    continue;

				if (typeof dataPoints[i].y !== "number") {
					if (i > 0) {
						// if first dataPoint is null then no need to call stroke method
						ctx.stroke();

						if (_utils.isCanvasSupported) {
							ghostCtx.stroke();
						}
					}

					prevDataNull = true;
					continue;
				}

				var prevY = y;

				x = plotUnit.axisX.conversionParameters.reference + plotUnit.axisX.conversionParameters.pixelPerUnit * (dataPointX - plotUnit.axisX.conversionParameters.minimum) + .5 << 0;
				y = plotUnit.axisY.conversionParameters.reference + plotUnit.axisY.conversionParameters.pixelPerUnit * (dataPoints[i].y - plotUnit.axisY.conversionParameters.minimum) + .5 << 0;

				var id = dataSeries.dataPointIds[i];
				this._eventManager.objectMap[id] = {
					id: id, objectType: "dataPoint", dataSeriesIndex: dataSeriesIndex, dataPointIndex: i, x1: x, y1: y
				};

				//dataSeries.noDataPointsInPlotArea++;

				if (isFirstDataPointInPlotArea || prevDataNull) {
					ctx.beginPath();
					ctx.moveTo(x, y);

					if (_utils.isCanvasSupported) {
						ghostCtx.beginPath();
						ghostCtx.moveTo(x, y);
					}

					isFirstDataPointInPlotArea = false;
					prevDataNull = false;
				} else {

					ctx.lineTo(x, prevY);
					if (_utils.isCanvasSupported) ghostCtx.lineTo(x, prevY);

					ctx.lineTo(x, y);
					if (_utils.isCanvasSupported) ghostCtx.lineTo(x, y);

					if (i % 500 == 0) {
						ctx.stroke();
						ctx.beginPath();
						ctx.moveTo(x, y);

						if (_utils.isCanvasSupported) {
							ghostCtx.stroke();
							ghostCtx.beginPath();
							ghostCtx.moveTo(x, y);
						}
					}
				}

				//Render Marker
				if (dataPoints[i].markerSize > 0 || dataSeries.markerSize > 0) {

					var markerProps = dataSeries.getMarkerProperties(i, x, y, ctx);
					markers.push(markerProps);

					//if (!dataSeries.maxWidthInX || markerProps.size > dataSeries.maxWidthInX) {
					//	dataSeries.maxWidthInX = markerProps.size / (plotUnit.axisX.conversionParameters.pixelPerUnit > 1 ? plotUnit.axisX.conversionParameters.pixelPerUnit - 1 : plotUnit.axisX.conversionParameters.pixelPerUnit);
					//}

					var markerColor = (0, _utils.intToHexColorString)(id);

					//window.console.log("index: " + i + "; id: " + id + "; hex: " + markerColor);
					if (_utils.isCanvasSupported) {
						markers.push({
							x: x, y: y, ctx: ghostCtx,
							type: markerProps.type,
							size: markerProps.size,
							color: markerColor,
							borderColor: markerColor,
							borderThickness: markerProps.borderThickness
						});
					}
				}

				if (dataPoints[i].indexLabel || dataSeries.indexLabel || dataPoints[i].indexLabelFormatter || dataSeries.indexLabelFormatter) {

					this._indexLabels.push({
						chartType: "stepLine",
						dataPoint: dataPoints[i],
						dataSeries: dataSeries,
						point: {
							x: x, y: y
						},
						direction: dataPoints[i].y >= 0 ? 1 : -1,
						color: color
					});
				}
			}

			ctx.stroke();
			if (_utils.isCanvasSupported) ghostCtx.stroke();
		}
	}

	_render2.default.drawMarkers(markers);
	ctx.restore();

	ctx.beginPath();

	if (_utils.isCanvasSupported) ghostCtx.beginPath();

	//source and dest would be same when animation is not enabled
	var animationInfo = {
		source: ctx, dest: this.plotArea.ctx, animationCallback: _animator4.default.xClipAnimation, easingFunction: _animator4.default.easing.linear, animationBase: 0
	};
	return animationInfo;
};

Chart.prototype.animationRequestId = null;

Chart.prototype.requestAnimFrame = function () {
	return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function (callback) {
		window.setTimeout(callback, 1000 / 60);
	};
}();

Chart.prototype.cancelRequestAnimFrame = function () {
	return window.cancelAnimationFrame || window.webkitCancelRequestAnimationFrame || window.mozCancelRequestAnimationFrame || window.oCancelRequestAnimationFrame || window.msCancelRequestAnimationFrame || clearTimeout;
}();

Chart.prototype.getPercentAndTotal = function (ds, dp) {

	var dpX = null;
	var total = null;
	var percent = null;

	if (ds.type.indexOf("stacked") >= 0) {
		total = 0;
		dpX = dp.x.getTime ? dp.x.getTime() : dp.x;
		if (dpX in ds.plotUnit.yTotals) {
			total = ds.plotUnit.yTotals[dpX];

			if (!isNaN(dp.y)) {
				if (total === 0) percent = 0;else percent = dp.y / total * 100;
			} else percent = 0;
		}
	} else if (ds.type === "pie" || ds.type === "doughnut") {
		total = 0;
		for (var i = 0; i < ds.dataPoints.length; i++) {

			if (!isNaN(ds.dataPoints[i].y)) total += ds.dataPoints[i].y;
		}

		if (!isNaN(dp.y)) percent = dp.y / total * 100;else percent = 0;
	}

	return {
		percent: percent, total: total
	};
};

Chart.prototype.replaceKeywordsWithValue = function (str, dp, ds, dpIndex, indexKeywordValue) {
	//var regex = /\{\s*[a-zA-Z]+\s*\}|"[^"]*"|'[^']*'/g;
	var regex = /\{.*?\}|"[^"]*"|'[^']*'/g;
	var chart = this;
	indexKeywordValue = typeof indexKeywordValue === "undefined" ? 0 : indexKeywordValue;

	if ((ds.type.indexOf("stacked") >= 0 || ds.type === "pie" || ds.type === "doughnut") && (str.indexOf("#percent") >= 0 || str.indexOf("#total") >= 0)) {
		var percent = "#percent";
		var total = "#total";
		var dpX = null;

		var percentAndTotal = this.getPercentAndTotal(ds, dp);

		total = isNaN(percentAndTotal.total) ? total : percentAndTotal.total;
		percent = isNaN(percentAndTotal.percent) ? percent : percentAndTotal.percent;

		do {
			var percentFormatString = "";
			if (ds.percentFormatString) percentFormatString = ds.percentFormatString;else {
				percentFormatString = "#,##0.";
				var numberOfDecimals = Math.max(Math.ceil(Math.log(1 / Math.abs(percent)) / Math.LN10), 2);

				if (isNaN(numberOfDecimals) || !isFinite(numberOfDecimals)) numberOfDecimals = 2;

				for (var n = 0; n < numberOfDecimals; n++) {
					percentFormatString += "#";
				}
			}

			str = str.replace("#percent", (0, _utils.numberFormat)(percent, percentFormatString, chart._cultureInfo));
			str = str.replace("#total", (0, _utils.numberFormat)(total, ds.yValueFormatString ? ds.yValueFormatString : "#,##0.########"));
		} while (str.indexOf("#percent") >= 0 || str.indexOf("#total") >= 0);
	}

	var fcn = function fcn($0) {
		if ($0[0] === "\"" && $0[$0.length - 1] === "\"" || $0[0] === "\'" && $0[$0.length - 1] === "\'") return $0.slice(1, $0.length - 1);

		var key = (0, _utils.trimString)($0.slice(1, $0.length - 1));
		key = key.replace("#index", indexKeywordValue);

		var index = null;

		try {
			var match = key.match(/(.*?)\s*\[\s*(.*?)\s*\]/);
			if (match && match.length > 0) {
				index = (0, _utils.trimString)(match[2]);
				key = (0, _utils.trimString)(match[1]);
			}
		} catch (e) {};

		var obj = null;

		if (key === "color") {
			return dp.color ? dp.color : ds.color ? ds.color : ds._colorSet[dpIndex % ds._colorSet.length];
		}

		if (dp.hasOwnProperty(key)) obj = dp;else if (ds.hasOwnProperty(key)) obj = ds;else return "";

		var value = obj[key];
		if (index !== null) value = value[index];

		if (key === "x") {
			if (chart.axisX && chart.plotInfo.axisXValueType === "dateTime") return dateFormat(value, dp.xValueFormatString ? dp.xValueFormatString : ds.xValueFormatString ? ds.xValueFormatString : chart.axisX && chart.axisX.valueFormatString ? chart.axisX.valueFormatString : "DD MMM YY", chart._cultureInfo);else return (0, _utils.numberFormat)(value, dp.xValueFormatString ? dp.xValueFormatString : ds.xValueFormatString ? ds.xValueFormatString : "#,##0.########", chart._cultureInfo);
		} else if (key === "y") return (0, _utils.numberFormat)(value, dp.yValueFormatString ? dp.yValueFormatString : ds.yValueFormatString ? ds.yValueFormatString : "#,##0.########", chart._cultureInfo);else if (key === "z") return (0, _utils.numberFormat)(value, dp.zValueFormatString ? dp.zValueFormatString : ds.zValueFormatString ? ds.zValueFormatString : "#,##0.########", chart._cultureInfo);else return value;
	};

	return str.replace(regex, fcn);
};

Chart.prototype.renderSpline = _index.SplineChart;

Chart.prototype.renderColumn = _index.ColumnChart;

Chart.prototype.renderStackedColumn = _index.StackedColumnChart;

Chart.prototype.renderStackedColumn100 = _index.StackedColumn100Chart;

Chart.prototype.renderBar = _index.BarChart;

Chart.prototype.renderStackedBar = _index.StackedBarChart;

Chart.prototype.renderStackedBar100 = _index.StackedBar100Chart;

Chart.prototype.renderArea = _index.AreaChart;

Chart.prototype.renderSplineArea = _index.SplineAreaChart;

Chart.prototype.renderStepArea = _index.StepAreaChart;

Chart.prototype.renderStackedArea = _index.StackedAreaChart;

Chart.prototype.renderStackedArea100 = _index.StackedArea100Chart;

Chart.prototype.renderBubble = _index.BubbleChart;

Chart.prototype.renderScatter = _index.ScatterChart;

Chart.prototype.renderCandlestick = _index.CandlestickChart;

Chart.prototype.renderRangeColumn = _index.RangeColumnChart;

Chart.prototype.renderRangeBar = _index.RangeBarChart;

Chart.prototype.renderRangeArea = _index.RangeAreaChart;

Chart.prototype.renderRangeSplineArea = _index.RangeSplineAreaChart;

Chart.prototype.renderPie = _index.PieChart;

exports.default = Chart;

},{"../charts/index":6,"../constants/options":23,"../constants/themes":24,"../core/axis":26,"../core/culture_info":29,"../core/legend":33,"../core/title":35,"../helpers/animator":37,"../helpers/render":38,"../helpers/utils":39,"./animator":25,"./canvasjs":27,"./data_series":30,"./event_manager":31,"./layout_manager":32,"./text_block":34,"./tooltip":36}],29:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _canvasjs = require('./canvasjs');

var _canvasjs2 = _interopRequireDefault(_canvasjs);

var _utils = require('../helpers/utils');

var _culture = require('../constants/culture');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function CultureInfo(culture) {

  var cultureInfo;

  if (culture && _culture.cultures[culture]) cultureInfo = _culture.cultures[culture];

  CultureInfo.base.constructor.call(this, "CultureInfo", cultureInfo);
}

(0, _utils.extend)(CultureInfo, _canvasjs2.default);

exports.default = CultureInfo;

},{"../constants/culture":22,"../helpers/utils":39,"./canvasjs":27}],30:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _canvasjs = require('./canvasjs');

var _canvasjs2 = _interopRequireDefault(_canvasjs);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function DataSeries(chart, options, theme, index, id) {
  DataSeries.base.constructor.call(this, "DataSeries", options, theme);

  this.chart = chart;
  this.canvas = chart.canvas;
  this._ctx = chart.canvas.ctx;
  this.index = index;
  this.noDataPointsInPlotArea = 0;
  //this.maxWidthInX = 0;
  this.id = id;
  this.chart._eventManager.objectMap[id] = {
    id: id, objectType: "dataSeries", dataSeriesIndex: index
  };
  this.dataPointIds = [];
  this.plotUnit = [];

  this.axisX = null;
  this.axisY = null;

  if (this.fillOpacity === null) {
    if (this.type.match(/area/i)) this.fillOpacity = .7;else this.fillOpacity = 1;
  }

  this.axisPlacement = this.getDefaultAxisPlacement();

  if (typeof this._options.indexLabelFontSize === "undefined") {

    this.indexLabelFontSize = this.chart.getAutoFontSize(this.indexLabelFontSize);
  }
}

(0, _utils.extend)(DataSeries, _canvasjs2.default);

//Static Method that returns the axisPlacement for a given ChartType. Returns one of "normal", "xySwapped", "none"
DataSeries.prototype.getDefaultAxisPlacement = function () {

  //if (!this.visible)
  //	return "none";

  //type = this.type.toLowerCase();
  var type = this.type;

  if (type === "column" || type === "line" || type === "stepLine" || type === "spline" || type === "area" || type === "stepArea" || type === "splineArea" || type === "stackedColumn" || type === "stackedLine" || type === "bubble" || type === "scatter" || type === "stackedArea" || type === "stackedColumn100" || type === "stackedLine100" || type === "stackedArea100" || type === "candlestick" || type === "ohlc" || type === "rangeColumn" || type === "rangeArea" || type === "rangeSplineArea") {
    return "normal";
  } else if (type === "bar" || type === "stackedBar" || type === "stackedBar100" || type === "rangeBar") {

    return "xySwapped";
  } else if (type === "pie" || type === "doughnut" || type === "funnel") {
    return "none";
  } else {
    window.console.log("Unknown Chart Type: " + type);
    return null;
  }
};

DataSeries.getDefaultLegendMarker = function (type) {

  //type = type.toLowerCase();

  if (type === "column" || type === "stackedColumn" || type === "stackedLine" || type === "bar" || type === "stackedBar" || type === "stackedBar100" || type === "bubble" || type === "scatter" || type === "stackedColumn100" || type === "stackedLine100" || type === "stepArea" || type === "candlestick" || type === "ohlc" || type === "rangeColumn" || type === "rangeBar" || type === "rangeArea" || type === "rangeSplineArea") {
    return "square";
  } else if (type === "line" || type === "stepLine" || type === "spline" || type === "pie" || type === "doughnut" || type === "funnel") {
    return "circle";
  } else if (type === "area" || type === "splineArea" || type === "stackedArea" || type === "stackedArea100") {
    return "triangle";
  } else {
    window.console.log("Unknown Chart Type: " + type);
    return null;
  }
};

//Finds dataPoint with the given x value. If findClosest is set, finds dataPoint with closest x value.
//Returns searchResult object if found, else returns null
DataSeries.prototype.getDataPointAtX = function (x, findClosest) {

  if (!this.dataPoints || this.dataPoints.length === 0) return null;

  var searchResult = {
    dataPoint: null, distance: Infinity, index: NaN
  };
  var dataPoint = null;

  var j = 0;
  var i = 0;
  var direction = 1; // +1 for foward and -1 for backward.

  var minimumXDistance = Infinity;
  var forwardMissCount = 0,
      backwardMissCount = 0;
  var maxMissCount = 1000;
  var searchStartIndex = 0;

  if (this.chart.plotInfo.axisPlacement !== "none") {

    //var xRange = (this.dataPoints[this.dataPoints.length - 1].x - this.dataPoints[0].x);

    //if (xRange > 0)
    //	searchStartIndex = ((this.dataPoints.length - 1) / xRange * (x - this.dataPoints[0].x)) >> 0;
    //else
    //	searchStartIndex = 0;

    var xRange = this.dataPoints[this.dataPoints.length - 1].x - this.dataPoints[0].x;

    if (xRange > 0) searchStartIndex = Math.min(Math.max((this.dataPoints.length - 1) / xRange * (x - this.dataPoints[0].x) >> 0, 0), this.dataPoints.length);else searchStartIndex = 0;

    //searchStartIndex = ((this.dataPoints[this.dataPoints.length - 1].x - this.dataPoints[0].x) / this.dataPoints.length * (x - this.dataPoints[0].x)) >> 0;
  }

  while (true) {

    i = direction > 0 ? searchStartIndex + j : searchStartIndex - j;

    if (i >= 0 && i < this.dataPoints.length) {

      dataPoint = this.dataPoints[i];

      var distance = Math.abs(dataPoint.x - x);

      if (distance < searchResult.distance) {
        searchResult.dataPoint = dataPoint;
        searchResult.distance = distance;
        searchResult.index = i;
      }

      var xDistance = Math.abs(dataPoint.x - x);
      if (xDistance <= minimumXDistance) minimumXDistance = xDistance;else {
        if (direction > 0) forwardMissCount++;else backwardMissCount++;
      }

      if (forwardMissCount > maxMissCount && backwardMissCount > maxMissCount) break;
    } else if (searchStartIndex - j < 0 && searchStartIndex + j >= this.dataPoints.length) break;

    if (direction === -1) {
      j++;
      direction = 1;
    } else direction = -1;
  }

  if (!findClosest && searchResult.dataPoint.x === x) return searchResult;else if (findClosest && searchResult.dataPoint !== null) return searchResult;else return null;
};

// x & y should be in pixels. Can be used only after rendering the chart.
DataSeries.prototype.getDataPointAtXY = function (x, y, getClosest) {

  if (!this.dataPoints || this.dataPoints.length === 0) return null;

  getClosest = getClosest || false;
  var results = [];
  var j = 0,
      i = 0;
  var direction = 1; // +1 for foward and -1 for backward.
  var foundDataPoint = false;
  var minimumXDistance = Infinity;
  var forwardMissCount = 0,
      backwardMissCount = 0;
  var maxMissCount = 1000;
  var searchStartIndex = 0;

  if (this.chart.plotInfo.axisPlacement !== "none") {
    var xval = this.chart.axisX.getXValueAt({ x: x, y: y });

    var xRange = this.dataPoints[this.dataPoints.length - 1].x - this.dataPoints[0].x;

    if (xRange > 0) searchStartIndex = Math.min(Math.max((this.dataPoints.length - 1) / xRange * (xval - this.dataPoints[0].x) >> 0, 0), this.dataPoints.length);else searchStartIndex = 0;

    //var xRange = (this.axisX._absoluteMaximum - this.axisX._absoluteMinimum);

    //if (xRange > 0)
    //	searchStartIndex = Math.min(Math.max(((this.dataPoints.length - 1) / xRange * (xval - this.axisX._absoluteMinimum)) >> 0, 0), this.dataPoints.length);
    //else
    //	searchStartIndex = 0;
  }

  while (true) {

    //i = searchStartIndex + (j * direction);
    i = direction > 0 ? searchStartIndex + j : searchStartIndex - j;

    if (i >= 0 && i < this.dataPoints.length) {

      var id = this.dataPointIds[i];
      var visualInfo = this.chart._eventManager.objectMap[id];
      var dataPoint = this.dataPoints[i];
      var distance = null;

      if (visualInfo) {

        switch (this.type) {

          case "column":
          case "stackedColumn":
          case "stackedColumn100":
          case "bar":
          case "stackedBar":
          case "stackedBar100":
          case "rangeColumn":
          case "rangeBar":

            if (x >= visualInfo.x1 && x <= visualInfo.x2 && y >= visualInfo.y1 && y <= visualInfo.y2) {
              results.push({
                dataPoint: dataPoint,
                dataPointIndex: i,
                dataSeries: this,
                distance: Math.min(Math.abs(visualInfo.x1 - x), Math.abs(visualInfo.x2 - x), Math.abs(visualInfo.y1 - y), Math.abs(visualInfo.y2 - y))
                //distance:0
              });

              foundDataPoint = true;
            }
            break;

          case "line":
          case "stepLine":
          case "spline":
          case "area":
          case "stepArea":
          case "stackedArea":
          case "stackedArea100":
          case "splineArea":
          case "scatter":
            var markerSize = (0, _utils.getProperty)("markerSize", dataPoint, this) || 4;
            var snapDistance = getClosest ? 20 : markerSize;

            distance = Math.sqrt(Math.pow(visualInfo.x1 - x, 2) + Math.pow(visualInfo.y1 - y, 2));
            if (distance <= snapDistance) {
              results.push({
                dataPoint: dataPoint,
                dataPointIndex: i,
                dataSeries: this,
                distance: distance
              });
            }

            var xDistance = Math.abs(visualInfo.x1 - x);
            if (xDistance <= minimumXDistance) minimumXDistance = xDistance;else {
              if (direction > 0) forwardMissCount++;else backwardMissCount++;
            }

            if (distance <= markerSize / 2) {
              foundDataPoint = true;
            }

            break;

          case "rangeArea":
          case "rangeSplineArea":

            var markerSize = (0, _utils.getProperty)("markerSize", dataPoint, this) || 4;
            var snapDistance = getClosest ? 20 : markerSize;

            distance = Math.min(Math.sqrt(Math.pow(visualInfo.x1 - x, 2) + Math.pow(visualInfo.y1 - y, 2)), Math.sqrt(Math.pow(visualInfo.x1 - x, 2) + Math.pow(visualInfo.y2 - y, 2)));
            if (distance <= snapDistance) {
              results.push({
                dataPoint: dataPoint,
                dataPointIndex: i,
                dataSeries: this,
                distance: distance
              });
            }

            var xDistance = Math.abs(visualInfo.x1 - x);
            if (xDistance <= minimumXDistance) minimumXDistance = xDistance;else {
              if (direction > 0) forwardMissCount++;else backwardMissCount++;
            }

            if (distance <= markerSize / 2) {
              foundDataPoint = true;
            }

            break;

          case "bubble":
            var markerSize = visualInfo.size;
            distance = Math.sqrt(Math.pow(visualInfo.x1 - x, 2) + Math.pow(visualInfo.y1 - y, 2));
            if (distance <= markerSize / 2) {
              results.push({
                dataPoint: dataPoint,
                dataPointIndex: i,
                dataSeries: this,
                distance: distance
              });

              foundDataPoint = true;
            }
            break;

          case "pie":
          case "doughnut":
            var center = visualInfo.center;
            var innerRadius = this.type === "doughnut" ? visualInfo.percentInnerRadius * visualInfo.radius : 0;

            distance = Math.sqrt(Math.pow(center.x - x, 2) + Math.pow(center.y - y, 2));
            if (distance < visualInfo.radius && distance > innerRadius) {

              var deltaY = y - center.y;
              var deltaX = x - center.x;
              var angle = Math.atan2(deltaY, deltaX);

              if (angle < 0) angle += Math.PI * 2;

              angle = Number(((angle / Math.PI * 180 % 360 + 360) % 360).toFixed(12));
              //console.log(angle);


              var startAngle = Number(((visualInfo.startAngle / Math.PI * 180 % 360 + 360) % 360).toFixed(12));
              var endAngle = Number(((visualInfo.endAngle / Math.PI * 180 % 360 + 360) % 360).toFixed(12));

              //So that data point is detected when there is only one dataPoint
              if (endAngle === 0 && visualInfo.endAngle > 1) {
                endAngle = 360;
              }

              if (startAngle >= endAngle && dataPoint.y !== 0) {
                endAngle += 360;

                if (angle < startAngle) angle += 360;
              }

              if (angle > startAngle && angle < endAngle) {
                results.push({
                  dataPoint: dataPoint,
                  dataPointIndex: i,
                  dataSeries: this,
                  distance: 0
                });

                foundDataPoint = true;
              }
            }

            break;

          case "candlestick":
            if (x >= visualInfo.x1 - visualInfo.borderThickness / 2 && x <= visualInfo.x2 + visualInfo.borderThickness / 2 && y >= visualInfo.y2 - visualInfo.borderThickness / 2 && y <= visualInfo.y3 + visualInfo.borderThickness / 2 || Math.abs(visualInfo.x2 - x + visualInfo.x1 - x) < visualInfo.borderThickness && y >= visualInfo.y1 && y <= visualInfo.y4) {
              results.push({
                dataPoint: dataPoint,
                dataPointIndex: i,
                dataSeries: this,
                distance: Math.min(Math.abs(visualInfo.x1 - x), Math.abs(visualInfo.x2 - x), Math.abs(visualInfo.y2 - y), Math.abs(visualInfo.y3 - y))
                //distance:0
              });

              foundDataPoint = true;
            }
            break;

          case "ohlc":

            if (Math.abs(visualInfo.x2 - x + visualInfo.x1 - x) < visualInfo.borderThickness && y >= visualInfo.y2 && y <= visualInfo.y3 || x >= visualInfo.x1 && x <= (visualInfo.x2 + visualInfo.x1) / 2 && y >= visualInfo.y1 - visualInfo.borderThickness / 2 && y <= visualInfo.y1 + visualInfo.borderThickness / 2 || x >= (visualInfo.x1 + visualInfo.x2) / 2 && x <= visualInfo.x2 && y >= visualInfo.y4 - visualInfo.borderThickness / 2 && y <= visualInfo.y4 + visualInfo.borderThickness / 2) {

              results.push({
                dataPoint: dataPoint,
                dataPointIndex: i,
                dataSeries: this,
                distance: Math.min(Math.abs(visualInfo.x1 - x), Math.abs(visualInfo.x2 - x), Math.abs(visualInfo.y2 - y), Math.abs(visualInfo.y3 - y))
                //distance:0
              });

              foundDataPoint = true;
            }
            break;

        }

        if (foundDataPoint || forwardMissCount > maxMissCount && backwardMissCount > maxMissCount) break;
      }
    } else if (searchStartIndex - j < 0 && searchStartIndex + j >= this.dataPoints.length) break;

    if (direction === -1) {
      j++;
      direction = 1;
    } else direction = -1;
  }

  var closestResult = null;

  for (var m = 0; m < results.length; m++) {
    if (!closestResult) {
      closestResult = results[m];
    } else if (results[m].distance <= closestResult.distance) {
      closestResult = results[m];
    }
  }

  //if (window.console)
  //	window.console.log("forwardMissCount: " + forwardMissCount + "; backwardMissCount: " + backwardMissCount + "; getClosest: " + getClosest);

  //if (window.console && closestResult)
  //    window.console.log(j + ": distance = " + closestResult.distance);

  return closestResult;
};

DataSeries.prototype.getMarkerProperties = function (index, x, y, ctx) {
  var dataPoints = this.dataPoints;
  var dataSeries = this;

  var markerColor = dataPoints[index].markerColor ? dataPoints[index].markerColor : dataSeries.markerColor ? dataSeries.markerColor : dataPoints[index].color ? dataPoints[index].color : dataSeries.color ? dataSeries.color : dataSeries._colorSet[index % dataSeries._colorSet.length];
  var markerBorderColor = dataPoints[index].markerBorderColor ? dataPoints[index].markerBorderColor : dataSeries.markerBorderColor ? dataSeries.markerBorderColor : null;
  var markerBorderThickness = dataPoints[index].markerBorderThickness ? dataPoints[index].markerBorderThickness : dataSeries.markerBorderThickness ? dataSeries.markerBorderThickness : null;
  var markerType = dataPoints[index].markerType ? dataPoints[index].markerType : dataSeries.markerType;
  var markerSize = dataPoints[index].markerSize ? dataPoints[index].markerSize : dataSeries.markerSize;

  return {
    x: x, y: y, ctx: ctx,
    type: markerType,
    size: markerSize,
    color: markerColor,
    borderColor: markerBorderColor,
    borderThickness: markerBorderThickness
  };
};

exports.default = DataSeries;

},{"../helpers/utils":39,"./canvasjs":27}],31:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _utils = require("../helpers/utils");

function EventManager(chart) {
  this.chart = chart;
  this.lastObjectId = 0;
  var _this = this;
  this.objectMap = [];
  this.rectangularRegionEventSubscriptions = [];
  this.previousDataPointEventObject = null;
  //this.previousDataSeriesEventObject = null;

  this.ghostCanvas = (0, _utils.createCanvas)(this.chart.width, this.chart.height);
  //this.ghostCanvas.width = this.chart.width;
  //this.ghostCanvas.height = this.chart.height;

  this.ghostCtx = this.ghostCanvas.getContext("2d");

  var eventHandler = function eventHandler(ev) {
    _this.mouseEventHandler.call(_this, ev);
  };

  this.mouseoveredObjectMaps = [];
  //this.chart.canvas.addEventListener("mouseover", eventHandler);
  //this.chart.canvas.addEventListener("mousemove", eventHandler);
  //this.chart.canvas.addEventListener("mouseout", eventHandler);
  //this.chart.canvas.addEventListener("click", eventHandler);
}

EventManager.prototype.reset = function () {
  this.lastObjectId = 0;
  this.objectMap = [];
  this.rectangularRegionEventSubscriptions = [];
  this.previousDataPointEventObject = null;

  this.eventObjects = [];
  //this.ghostCanvas.width = this.chart.width;
  //this.ghostCanvas.height = this.chart.height;

  if (_utils.isCanvasSupported) {
    this.ghostCtx.clearRect(0, 0, this.chart.width, this.chart.height);
    this.ghostCtx.beginPath();
  }
};

EventManager.prototype.getNewObjectTrackingId = function () {
  return ++this.lastObjectId;
};

EventManager.prototype.mouseEventHandler = function (ev) {

  if (ev.type !== "mousemove" && ev.type !== "click") return;

  var eventObjectMaps = [];
  var xy = (0, _utils.getMouseCoordinates)(ev);
  var id = null;

  //var dataPointInfo = this.chart.getDataPointAtXY(xy.x, xy.y, false);

  //if (dataPointInfo) {
  //	id = dataPointInfo.dataSeries.dataPointIds[dataPointInfo.dataPointIndex];
  //} else if (isCanvasSupported) {//IE9+
  //	id = getObjectId(xy.x, xy.y, this.ghostCtx);
  //}
  id = this.chart.getObjectAtXY(xy.x, xy.y, false);

  if (id && typeof this.objectMap[id] !== "undefined") {

    var eventObjectMap = this.objectMap[id];

    if (eventObjectMap.objectType === "dataPoint") {
      var dataSeries = this.chart.data[eventObjectMap.dataSeriesIndex];
      var dataPoint = dataSeries.dataPoints[eventObjectMap.dataPointIndex];
      var dataPointIndex = eventObjectMap.dataPointIndex;

      //Event Parameter should not contain reference to dataSeries directly. But to its options.
      eventObjectMap.eventParameter = {
        x: xy.x, y: xy.y, dataPoint: dataPoint,
        dataSeries: dataSeries._options, dataPointIndex: dataPointIndex, dataSeriesIndex: dataSeries.index,
        chart: this.chart._publicChartReference
      };
      eventObjectMap.eventContext = {
        context: dataPoint, userContext: dataPoint, mouseover: "mouseover", mousemove: "mousemove", mouseout: "mouseout", click: "click"
      };
      eventObjectMaps.push(eventObjectMap);

      //Add Dataseries too because mouse event on dataPoint also means there is an event on dataSeries. DataSeries is not present on ghost canvas
      eventObjectMap = this.objectMap[dataSeries.id];

      //Event Parameter should not contain reference to dataSeries directly. But to its options.
      eventObjectMap.eventParameter = {
        x: xy.x, y: xy.y,
        dataPoint: dataPoint, dataSeries: dataSeries._options, dataPointIndex: dataPointIndex, dataSeriesIndex: dataSeries.index,
        chart: this.chart._publicChartReference
      };

      eventObjectMap.eventContext = {
        context: dataSeries, userContext: dataSeries._options, mouseover: "mouseover", mousemove: "mousemove", mouseout: "mouseout", click: "click"
      };
      eventObjectMaps.push(this.objectMap[dataSeries.id]);
    }
    //else if (eventObjectMap.objectType === "stripLine") {

    //	//Event Parameter should not contain reference to stripLine directly. But to its options.
    //	eventObjectMap.eventParameter = { x: xy.x, y: xy.y, stripLine: eventObjectMap.stripLine._options, axis: eventObjectMap.axis._options, stripLineIndex: eventObjectMap.stripLineIndex };
    //	eventObjectMap.eventContext = { context: eventObjectMap.stripLine, userContext: eventObjectMap.stripLine._options, mouseover: "mouseover", mousemove: "mousemove", mouseout: "mouseout", click: "click" };

    //	eventObjectMaps.push(eventObjectMap);
    //}
    else if (eventObjectMap.objectType === "legendItem") {

        var dataSeries = this.chart.data[eventObjectMap.dataSeriesIndex];
        var dataPoint = eventObjectMap.dataPointIndex !== null ? dataSeries.dataPoints[eventObjectMap.dataPointIndex] : null;

        //Event Parameter should not contain reference to DataSeries directly. But to its options.
        eventObjectMap.eventParameter = {
          x: xy.x, y: xy.y,
          dataSeries: dataSeries._options, dataPoint: dataPoint, dataPointIndex: eventObjectMap.dataPointIndex, dataSeriesIndex: eventObjectMap.dataSeriesIndex,
          chart: this.chart._publicChartReference
        };
        eventObjectMap.eventContext = {
          context: this.chart.legend, userContext: this.chart.legend._options, mouseover: "itemmouseover", mousemove: "itemmousemove", mouseout: "itemmouseout", click: "itemclick"
        };
        eventObjectMaps.push(eventObjectMap);
      }
  }

  //Fire mouseout if existing mouseovered objects are not present in the objectmap.
  var mouseOutObjectMapsExcluded = [];
  for (var i = 0; i < this.mouseoveredObjectMaps.length; i++) {
    var mouseOut = true;

    for (var j = 0; j < eventObjectMaps.length; j++) {
      if (eventObjectMaps[j].id === this.mouseoveredObjectMaps[i].id) {
        mouseOut = false;
        break;
      }
    }

    if (mouseOut) {
      this.fireEvent(this.mouseoveredObjectMaps[i], "mouseout", ev);
    } else {
      mouseOutObjectMapsExcluded.push(this.mouseoveredObjectMaps[i]);
    }
  }

  this.mouseoveredObjectMaps = mouseOutObjectMapsExcluded;

  //Process new eventObectMaps
  //If they already don't exist, add them and fire mouseover
  //If ev.type is mousemove, then just fire mousemove
  //If ev.type is click, then fire two events - click followed by mousemove
  for (var i = 0; i < eventObjectMaps.length; i++) {

    var existing = false;

    for (var j = 0; j < this.mouseoveredObjectMaps.length; j++) {
      if (eventObjectMaps[i].id === this.mouseoveredObjectMaps[j].id) {
        existing = true;
        break;
      }
    }

    if (!existing) {
      this.fireEvent(eventObjectMaps[i], "mouseover", ev);
      this.mouseoveredObjectMaps.push(eventObjectMaps[i]);
    }

    if (ev.type === "click") {
      this.fireEvent(eventObjectMaps[i], "click", ev);
    } else if (ev.type === "mousemove") {
      this.fireEvent(eventObjectMaps[i], "mousemove", ev);
    }
  }
};

EventManager.prototype.fireEvent = function (eventObjectMap, eventType, ev) {

  if (!eventObjectMap || !eventType) return;

  var eventParameter = eventObjectMap.eventParameter;
  var eventContext = eventObjectMap.eventContext;
  //var context = eventObjectMap.eventContext.context;
  var userContext = eventObjectMap.eventContext.userContext;

  if (userContext && eventContext && userContext[eventContext[eventType]]) userContext[eventContext[eventType]].call(userContext, eventParameter);

  if (eventType !== "mouseout") {
    if (userContext.cursor && userContext.cursor !== ev.target.style.cursor) {
      ev.target.style.cursor = userContext.cursor;
    }
  } else {
    ev.target.style.cursor = this.chart._defaultCursor;
    delete eventObjectMap.eventParameter; // reference no longer required.
    delete eventObjectMap.eventContext; // reference no longer required.
  }

  //This is just a quick fix. Need to find a better way of calling internal event handlers.
  if (eventType === "click" && eventObjectMap.objectType === "dataPoint" && this.chart.pieDoughnutClickHandler) {
    this.chart.pieDoughnutClickHandler.call(this.chart.data[eventObjectMap.dataSeriesIndex], eventParameter);
  }
};

exports.default = EventManager;

},{"../helpers/utils":39}],32:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
function LayoutManager(x1, y1, x2, y2, padding) {

  if (typeof padding === "undefined") padding = 0;

  this._padding = padding;

  this._x1 = x1;
  this._y1 = y1;
  this._x2 = x2;
  this._y2 = y2;

  this._topOccupied = this._padding;
  this._bottomOccupied = this._padding;
  this._leftOccupied = this._padding;
  this._rightOccupied = this._padding;
}

LayoutManager.prototype.registerSpace = function (position, size) {
  if (position === "top") {
    this._topOccupied += size.height;
  } else if (position === "bottom") {
    this._bottomOccupied += size.height;
  } else if (position === "left") {
    this._leftOccupied += size.width; // this is width when seen upright/vertically
  } else if (position === "right") {
    this._rightOccupied += size.width; // this is width when seen upright/vertically
  }
};

LayoutManager.prototype.unRegisterSpace = function (position, size) {
  if (position === "top") {
    this._topOccupied -= size.height;
  } else if (position === "bottom") {
    this._bottomOccupied -= size.height;
  } else if (position === "left") {
    this._leftOccupied -= size.width; // this is width when seen upright/vertically
  } else if (position === "right") {
    this._rightOccupied -= size.width; // this is width when seen upright/vertically
  }
};

LayoutManager.prototype.getFreeSpace = function () {
  ///<signature>
  ///<summary>Returns available free space {x1:number, y1:number, x2:number, y2:number}</summary>
  ///</signature>

  return {
    x1: this._x1 + this._leftOccupied,
    y1: this._y1 + this._topOccupied,
    x2: this._x2 - this._rightOccupied,
    y2: this._y2 - this._bottomOccupied,
    width: this._x2 - this._x1 - this._rightOccupied - this._leftOccupied,
    height: this._y2 - this._y1 - this._bottomOccupied - this._topOccupied
  };
};

LayoutManager.prototype.reset = function () {
  //so that there is enough padding.
  this._topOccupied = this._padding;
  this._bottomOccupied = this._padding;
  this._leftOccupied = this._padding;
  this._rightOccupied = this._padding;
};

exports.default = LayoutManager;

},{}],33:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _data_series = require('./data_series');

var _data_series2 = _interopRequireDefault(_data_series);

var _canvasjs = require('./canvasjs');

var _canvasjs2 = _interopRequireDefault(_canvasjs);

var _text_block = require('./text_block');

var _text_block2 = _interopRequireDefault(_text_block);

var _render = require('../helpers/render');

var _render2 = _interopRequireDefault(_render);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Legend(chart, options, theme) {
  Legend.base.constructor.call(this, "Legend", options, theme);

  this.chart = chart;
  this.canvas = chart.canvas;
  this.ctx = this.chart.ctx;
  this.ghostCtx = this.chart._eventManager.ghostCtx;
  this.items = [];

  this.width = 0,
  //this.fontSize = 12,
  this.height = 0, this.orientation = null, this.dataSeries = [];
  this.bounds = {
    x1: null, y1: null, x2: null, y2: null
  };

  if (typeof this._options.fontSize === "undefined") {
    this.fontSize = this.chart.getAutoFontSize(this.fontSize);
    //window.console.log("fontSize: " + this.fontSize);
  }

  this.lineHeight = (0, _utils.getFontHeightInPixels)(this.fontFamily, this.fontSize, this.fontWeight);

  this.horizontalSpacing = this.fontSize;
}

(0, _utils.extend)(Legend, _canvasjs2.default);

Legend.prototype.render = function () {

  var container = !this.dockInsidePlotArea ? this.chart : this.chart.plotArea;
  var freeSpace = container.layoutManager.getFreeSpace();
  var position = null;
  var top = 0;
  var left = 0;
  var maxWidth = 0;
  var maxHeight = 0;
  var itemMargin = 5;

  var items = [];
  var rows = [];

  //this.ctx.font = getFontString("", this, null);
  //this.ctx.fontColor = this.fontColor;

  if (this.verticalAlign === "top" || this.verticalAlign === "bottom") {
    this.orientation = "horizontal";
    position = this.verticalAlign;

    maxWidth = this.maxWidth !== null ? this.maxWidth : freeSpace.width * .7;
    maxHeight = this.maxHeight !== null ? this.maxHeight : freeSpace.height * .5;
  } else if (this.verticalAlign === "center") {
    this.orientation = "vertical";
    position = this.horizontalAlign;

    maxWidth = this.maxWidth !== null ? this.maxWidth : freeSpace.width * .5;
    maxHeight = this.maxHeight !== null ? this.maxHeight : freeSpace.height * .7;
  }

  for (var i = 0; i < this.dataSeries.length; i++) {
    var dataSeries = this.dataSeries[i];

    if (dataSeries.type !== "pie" && dataSeries.type !== "doughnut" && dataSeries.type !== "funnel") {

      var markerType = dataSeries.legendMarkerType ? dataSeries.legendMarkerType : (dataSeries.type === "line" || dataSeries.type === "stepLine" || dataSeries.type === "spline" || dataSeries.type === "scatter" || dataSeries.type === "bubble") && dataSeries.markerType ? dataSeries.markerType : _data_series2.default.getDefaultLegendMarker(dataSeries.type);
      var legendText = dataSeries.legendText ? dataSeries.legendText : this.itemTextFormatter ? this.itemTextFormatter({ chart: this.chart, legend: this._options, dataSeries: dataSeries, dataPoint: null }) : dataSeries.name;
      var markerColor = dataSeries.legendMarkerColor ? dataSeries.legendMarkerColor : dataSeries.markerColor ? dataSeries.markerColor : dataSeries._colorSet[0];
      var markerSize = !dataSeries.markerSize && (dataSeries.type === "line" || dataSeries.type === "stepLine" || dataSeries.type === "spline") ? 0 : this.lineHeight * .6;
      var markerBorderColor = dataSeries.legendMarkerBorderColor ? dataSeries.legendMarkerBorderColor : dataSeries.markerBorderColor;
      var markerBorderThickness = dataSeries.legendMarkerBorderThickness ? dataSeries.legendMarkerBorderThickness : dataSeries.markerBorderThickness ? Math.max(1, Math.round(markerSize * .2)) : 0;
      var lineColor = dataSeries._colorSet[0];

      legendText = this.chart.replaceKeywordsWithValue(legendText, dataSeries.dataPoints[0], dataSeries, i);
      var item = {
        markerType: markerType, markerColor: markerColor, text: legendText, textBlock: null, chartType: dataSeries.type, markerSize: markerSize, lineColor: dataSeries._colorSet[0],
        dataSeriesIndex: dataSeries.index, dataPointIndex: null, markerBorderColor: markerBorderColor, markerBorderThickness: markerBorderThickness
      };

      items.push(item);
    } else {
      for (var dataPointIndex = 0; dataPointIndex < dataSeries.dataPoints.length; dataPointIndex++) {

        var dataPoint = dataSeries.dataPoints[dataPointIndex];

        var markerType = dataPoint.legendMarkerType ? dataPoint.legendMarkerType : dataSeries.legendMarkerType ? dataSeries.legendMarkerType : _data_series2.default.getDefaultLegendMarker(dataSeries.type);
        var legendText = dataPoint.legendText ? dataPoint.legendText : dataSeries.legendText ? dataSeries.legendText : this.itemTextFormatter ? this.itemTextFormatter({ chart: this.chart, legend: this._options, dataSeries: dataSeries, dataPoint: dataPoint }) : dataPoint.name ? dataPoint.name : "DataPoint: " + (dataPointIndex + 1);
        var markerColor = dataPoint.legendMarkerColor ? dataPoint.legendMarkerColor : dataSeries.legendMarkerColor ? dataSeries.legendMarkerColor : dataPoint.color ? dataPoint.color : dataSeries.color ? dataSeries.color : dataSeries._colorSet[dataPointIndex % dataSeries._colorSet.length];
        var markerSize = this.lineHeight * .6;
        var markerBorderColor = dataPoint.legendMarkerBorderColor ? dataPoint.legendMarkerBorderColor : dataSeries.legendMarkerBorderColor ? dataSeries.legendMarkerBorderColor : dataPoint.markerBorderColor ? dataPoint.markerBorderColor : dataSeries.markerBorderColor;
        var markerBorderThickness = dataPoint.legendMarkerBorderThickness ? dataPoint.legendMarkerBorderThickness : dataSeries.legendMarkerBorderThickness ? dataSeries.legendMarkerBorderThickness : dataPoint.markerBorderThickness || dataSeries.markerBorderThickness ? Math.max(1, Math.round(markerSize * .2)) : 0;

        legendText = this.chart.replaceKeywordsWithValue(legendText, dataPoint, dataSeries, dataPointIndex);

        var item = {
          markerType: markerType, markerColor: markerColor, text: legendText, textBlock: null, chartType: dataSeries.type, markerSize: markerSize,
          dataSeriesIndex: i, dataPointIndex: dataPointIndex, markerBorderColor: markerBorderColor, markerBorderThickness: markerBorderThickness
        };

        if (dataPoint.showInLegend || dataSeries.showInLegend && dataPoint.showInLegend !== false) {
          items.push(item);
        }
      }
    }
    item = null;
  }
  if (this.reversed === true) {
    items.reverse();
  }

  // Find out the required width and height of Legend and position the items relative to the container
  if (items.length > 0) {
    var row = null;
    var rowIndex = 0; // required for vertical orientation
    var textMaxWidth = 0;
    var columnHeight = 0;

    if (this.itemWidth !== null) {
      if (this.itemMaxWidth !== null) {
        textMaxWidth = Math.min(this.itemWidth, this.itemMaxWidth, maxWidth);
      } else {
        textMaxWidth = Math.min(this.itemWidth, maxWidth);
      }
    } else {
      if (this.itemMaxWidth !== null) {
        textMaxWidth = Math.min(this.itemMaxWidth, maxWidth);
      } else {
        textMaxWidth = maxWidth;
      }
    }

    markerSize = markerSize === 0 ? this.lineHeight * .6 : markerSize;
    textMaxWidth = textMaxWidth - (markerSize + this.horizontalSpacing * .1);

    for (var i = 0; i < items.length; i++) {
      var item = items[i];

      if (item.chartType === "line" || item.chartType === "spline" || item.chartType === "stepLine") {
        textMaxWidth = textMaxWidth - 2 * (this.lineHeight * .1);
      }

      if (maxHeight <= 0 || typeof maxHeight === "undefined" || textMaxWidth <= 0 || typeof textMaxWidth === "undefined") {
        continue;
      }

      if (this.orientation === "horizontal") {

        item.textBlock = new _text_block2.default(this.ctx, {
          x: 0,
          y: 0, //TBI
          maxWidth: textMaxWidth,
          maxHeight: this.itemWrap ? maxHeight : this.lineHeight, //TBI: FontSize
          angle: 0,
          text: item.text,
          horizontalAlign: "left", //left, center, right
          fontSize: this.fontSize, //in pixels
          fontFamily: this.fontFamily,
          fontWeight: this.fontWeight, //normal, bold, bolder, lighter,
          fontColor: this.fontColor,
          fontStyle: this.fontStyle, // normal, italic, oblique
          textBaseline: "top"
        });
        item.textBlock.measureText();

        if (this.itemWidth !== null) {
          item.textBlock.width = this.itemWidth - (markerSize + this.horizontalSpacing * .1 + (item.chartType === "line" || item.chartType === "spline" || item.chartType === "stepLine" ? 2 * (this.lineHeight * .1) : 0));
        }

        if (!row || row.width + Math.round(item.textBlock.width + this.horizontalSpacing * .1 + markerSize + (row.width === 0 ? 0 : this.horizontalSpacing) + (item.chartType === "line" || item.chartType === "spline" || item.chartType === "stepLine" ? 2 * (this.lineHeight * .1) : 0)) > maxWidth) {
          row = {
            items: [], width: 0
          };
          rows.push(row);
          this.height += columnHeight;
          columnHeight = 0;
        }

        columnHeight = Math.max(columnHeight, item.textBlock.height);

        item.textBlock.x = row.width;
        item.textBlock.y = 0;

        row.width += Math.round(item.textBlock.width + this.horizontalSpacing * .1 + markerSize + (row.width === 0 ? 0 : this.horizontalSpacing) + (item.chartType === "line" || item.chartType === "spline" || item.chartType === "stepLine" ? 2 * (this.lineHeight * .1) : 0));
        row.items.push(item);

        this.width = Math.max(row.width, this.width);
      } else {

        item.textBlock = new _text_block2.default(this.ctx, {
          x: 0,
          y: 0, //TBI
          maxWidth: textMaxWidth,
          maxHeight: this.itemWrap === true ? maxHeight : this.fontSize * 1.5, //TBI: FontSize
          angle: 0,
          text: item.text,
          horizontalAlign: "left", //left, center, right
          fontSize: this.fontSize, //in pixels
          fontFamily: this.fontFamily,
          fontWeight: this.fontWeight, //normal, bold, bolder, lighter,
          fontColor: this.fontColor,
          fontStyle: this.fontStyle, // normal, italic, oblique
          textBaseline: "top"
        });

        item.textBlock.measureText();

        if (this.itemWidth !== null) {
          item.textBlock.width = this.itemWidth - (markerSize + this.horizontalSpacing * .1 + (item.chartType === "line" || item.chartType === "spline" || item.chartType === "stepLine" ? 2 * (this.lineHeight * .1) : 0));
        }

        if (this.height <= maxHeight) {
          row = {
            items: [], width: 0
          };
          rows.push(row);
        } else {
          row = rows[rowIndex];
          rowIndex = (rowIndex + 1) % rows.length;
        }

        this.height += item.textBlock.height;

        item.textBlock.x = row.width; // relative to the row
        item.textBlock.y = 0; // relative to the row

        row.width += Math.round(item.textBlock.width + this.horizontalSpacing * .1 + markerSize + (row.width === 0 ? 0 : this.horizontalSpacing) + (item.chartType === "line" || item.chartType === "spline" || item.chartType === "stepLine" ? 2 * (this.lineHeight * .1) : 0));
        row.items.push(item);

        this.width = Math.max(row.width, this.width);
      }
    }

    if (this.itemWrap === false) {
      this.height = rows.length * this.lineHeight;
    } else {
      this.height += columnHeight;
    }

    this.height = Math.min(maxHeight, this.height);
    this.width = Math.min(maxWidth, this.width);
  }

  if (this.verticalAlign === "top") {
    if (this.horizontalAlign === "left") left = freeSpace.x1;else if (this.horizontalAlign === "right") left = freeSpace.x2 - this.width;else left = freeSpace.x1 + freeSpace.width / 2 - this.width / 2;

    top = freeSpace.y1;
  } else if (this.verticalAlign === "center") {
    if (this.horizontalAlign === "left") left = freeSpace.x1;else if (this.horizontalAlign === "right") left = freeSpace.x2 - this.width;else left = freeSpace.x1 + freeSpace.width / 2 - this.width / 2;

    top = freeSpace.y1 + freeSpace.height / 2 - this.height / 2;
  } else if (this.verticalAlign === "bottom") {
    if (this.horizontalAlign === "left") left = freeSpace.x1;else if (this.horizontalAlign === "right") left = freeSpace.x2 - this.width;else left = freeSpace.x1 + freeSpace.width / 2 - this.width / 2;

    top = freeSpace.y2 - this.height;
  }

  this.items = items;

  //Assign ids to all legendItems
  for (var i = 0; i < this.items.length; i++) {

    var item = items[i];

    item.id = ++this.chart._eventManager.lastObjectId;
    this.chart._eventManager.objectMap[item.id] = {
      id: item.id, objectType: "legendItem", legendItemIndex: i, dataSeriesIndex: item.dataSeriesIndex, dataPointIndex: item.dataPointIndex
    };
    //delete item.textBlock;// Not Required anymore
  }

  var rowHeight = 0;
  for (var i = 0; i < rows.length; i++) {
    var row = rows[i];
    var columnHeight = 0;
    for (var itemIndex = 0; itemIndex < row.items.length; itemIndex++) {
      var item = row.items[itemIndex];

      var itemX = item.textBlock.x + left + (itemIndex === 0 ? markerSize * .2 : this.horizontalSpacing);
      var itemY = top + rowHeight;

      var ghostX = itemX;

      if (!this.chart.data[item.dataSeriesIndex].visible) this.ctx.globalAlpha = .5;

      this.ctx.save();
      this.ctx.rect(left, top, maxWidth, maxHeight);
      this.ctx.clip();

      if (item.chartType === "line" || item.chartType === "stepLine" || item.chartType === "spline") {
        this.ctx.strokeStyle = item.lineColor;
        this.ctx.lineWidth = Math.ceil(this.lineHeight / 8);
        this.ctx.beginPath();
        this.ctx.moveTo(itemX - this.lineHeight * .1, itemY + this.lineHeight / 2);
        this.ctx.lineTo(itemX + this.lineHeight * .7, itemY + this.lineHeight / 2);
        this.ctx.stroke();

        ghostX -= this.lineHeight * .1;
      }

      _render2.default.drawMarker(itemX + markerSize / 2, itemY + this.lineHeight / 2, this.ctx, item.markerType, item.markerSize, item.markerColor, item.markerBorderColor, item.markerBorderThickness);

      item.textBlock.x = itemX + this.horizontalSpacing * .1 + markerSize;

      if (item.chartType === "line" || item.chartType === "stepLine" || item.chartType === "spline") {
        item.textBlock.x = item.textBlock.x + this.lineHeight * .1;
      }

      item.textBlock.y = itemY;

      item.textBlock.render(true);

      this.ctx.restore();

      if (itemIndex > 0) {
        columnHeight = Math.max(columnHeight, item.textBlock.height);
      } else {
        columnHeight = item.textBlock.height;
      }

      if (!this.chart.data[item.dataSeriesIndex].visible) this.ctx.globalAlpha = 1;

      var hexColor = intToHexColorString(item.id);
      this.ghostCtx.fillStyle = hexColor;
      this.ghostCtx.beginPath();
      this.ghostCtx.fillRect(ghostX, item.textBlock.y, item.textBlock.x + item.textBlock.width - ghostX, item.textBlock.height);

      item.x1 = this.chart._eventManager.objectMap[item.id].x1 = ghostX;
      item.y1 = this.chart._eventManager.objectMap[item.id].y1 = item.textBlock.y;
      item.x2 = this.chart._eventManager.objectMap[item.id].x2 = item.textBlock.x + item.textBlock.width;
      item.y2 = this.chart._eventManager.objectMap[item.id].y2 = item.textBlock.y + item.textBlock.height;
    }
    rowHeight = rowHeight + columnHeight;
  }

  //this.ctx.beginPath();
  //this.ctx.lineWidth = 2;
  //this.ctx.strokeStyle = "red";
  //this.ctx.rect(left, top, this.width, this.height);
  //this.ctx.stroke();

  container.layoutManager.registerSpace(position, { width: this.width + 2 + 2, height: this.height + 5 + 5 });

  this.bounds = {
    x1: left, y1: top, x2: left + this.width, y2: top + this.height
  };
};

exports.default = Legend;

},{"../helpers/render":38,"../helpers/utils":39,"./canvasjs":27,"./data_series":30,"./text_block":34}],34:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _canvasjs = require('./canvasjs');

var _canvasjs2 = _interopRequireDefault(_canvasjs);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function TextBlock(ctx, options) {

  TextBlock.base.constructor.call(this, "TextBlock", options);

  this.ctx = ctx;
  this._isDirty = true;
  this._wrappedText = null;
  this._lineHeight = (0, _utils.getFontHeightInPixels)(this.fontFamily, this.fontSize, this.fontWeight);
}

(0, _utils.extend)(TextBlock, _canvasjs2.default);

TextBlock.prototype.render = function (preserveContext) {
  if (preserveContext) this.ctx.save();

  var font = this.ctx.font;
  this.ctx.textBaseline = this.textBaseline;

  var offsetY = 0;

  if (this._isDirty) this.measureText(this.ctx);

  this.ctx.translate(this.x, this.y + offsetY);

  if (this.textBaseline === "middle") {
    offsetY = -this._lineHeight / 2;
  }

  this.ctx.font = this._getFontString();

  this.ctx.rotate(Math.PI / 180 * this.angle);

  var textLeft = 0;
  var textTop = this.padding;
  //var textTop = this.padding;
  var line = null;

  if (this.borderThickness > 0 && this.borderColor || this.backgroundColor) {
    this.ctx.roundRect(0, offsetY, this.width, this.height, this.cornerRadius, this.borderThickness, this.backgroundColor, this.borderColor);

    //if (this.textBaseline === "middle") {
    //	//textTop += this.fontSize / 2;
    //	textTop += this._lineHeight / 2;
    //}
  }

  this.ctx.fillStyle = this.fontColor;

  for (var i = 0; i < this._wrappedText.lines.length; i++) {

    line = this._wrappedText.lines[i];
    if (this.horizontalAlign === "right") textLeft = this.width - line.width - this.padding;else if (this.horizontalAlign === "left") textLeft = this.padding;else if (this.horizontalAlign === "center") textLeft = (this.width - this.padding * 2) / 2 - line.width / 2 + this.padding;

    this.ctx.fillText(line.text, textLeft, textTop);

    textTop += line.height;
  }

  this.ctx.font = font;

  if (preserveContext) this.ctx.restore();
};

TextBlock.prototype.setText = function (text) {
  this.text = text;
  this._isDirty = true;
  this._wrappedText = null;
};

TextBlock.prototype.measureText = function () {
  if (this.maxWidth === null) {
    throw "Please set maxWidth and height for TextBlock";
  }

  this._wrapText(this.ctx);
  this._isDirty = false;

  return {
    width: this.width, height: this.height
  };
};

TextBlock.prototype._getLineWithWidth = function (text, width, clipWord) {
  text = String(text);
  clipWord = clipWord || false;

  if (!text) return {
    text: "", width: 0
  };

  var textWidth = 0,
      min = 0,
      max = text.length - 1,
      mid = Infinity;

  this.ctx.font = this._getFontString();

  while (min <= max) {
    mid = Math.floor((min + max) / 2);
    var tempText = text.substr(0, mid + 1);

    textWidth = this.ctx.measureText(tempText).width;

    if (textWidth < width) {
      min = mid + 1;
    } else if (textWidth > width) {
      max = mid - 1;
    } else {
      break;
    }
  }

  //edge cases
  if (textWidth > width && tempText.length > 1) {
    tempText = tempText.substr(0, tempText.length - 1);
    textWidth = this.ctx.measureText(tempText).width;
  }

  var isClipped = true;

  if (tempText.length === text.length || text[tempText.length] === " ") isClipped = false;

  if (isClipped) {
    var resultWords = tempText.split(" ");
    if (resultWords.length > 1) resultWords.pop();

    tempText = resultWords.join(" ");
    textWidth = this.ctx.measureText(tempText).width;
  }

  return {
    text: tempText, width: textWidth
  };
};

TextBlock.prototype._wrapText = function wrapText() {
  //this.ctx.save();
  var text = new String((0, _utils.trimString)(String(this.text)));
  var lines = [];
  var font = this.ctx.font; // Save the current Font
  var height = 0;
  var width = 0;

  this.ctx.font = this._getFontString();

  while (text.length > 0) {

    var maxWidth = this.maxWidth - this.padding * 2;
    var maxHeight = this.maxHeight - this.padding * 2;

    var line = this._getLineWithWidth(text, maxWidth, false);
    line.height = this._lineHeight;

    lines.push(line);

    width = Math.max(width, line.width);
    height += line.height;
    text = (0, _utils.trimString)(text.slice(line.text.length, text.length));

    if (maxHeight && height > maxHeight) {
      var line = lines.pop();
      height -= line.height;
    }
  }

  this._wrappedText = {
    lines: lines, width: width, height: height
  };
  this.width = width + this.padding * 2;
  this.height = height + this.padding * 2;

  this.ctx.font = font; // Restore the font
};

TextBlock.prototype._getFontString = function () {
  //return this.fontStyle + " " + this.fontWeight + " " + this.fontSize + "px " + this.fontFamily
  return (0, _utils.getFontString)("", this, null);
};

exports.default = TextBlock;

},{"../helpers/utils":39,"./canvasjs":27}],35:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _canvasjs = require('./canvasjs');

var _canvasjs2 = _interopRequireDefault(_canvasjs);

var _text_block = require('./text_block');

var _text_block2 = _interopRequireDefault(_text_block);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Title(chart, options) {
	Title.base.constructor.call(this, "Title", options, chart.theme);

	this.chart = chart;
	this.canvas = chart.canvas;
	this.ctx = this.chart.ctx;

	if (typeof this._options.fontSize === "undefined") {

		this.fontSize = this.chart.getAutoFontSize(this.fontSize);

		//window.console.log("Chart Title fontSize: " + this.fontSize);
	}

	this.width = null, //read only
	this.height = null; //read only
	this.bounds = {
		x1: null, y1: null, x2: null, y2: null
	};
}

(0, _utils.extend)(Title, _canvasjs2.default);

Title.prototype.render = function () {

	if (!this.text) return;

	var container = !this.dockInsidePlotArea ? this.chart : this.chart.plotArea;
	var freespace = container.layoutManager.getFreeSpace();
	var left = freespace.x1;
	var top = freespace.y1;
	var angle = 0;
	var maxHeight = 0;
	var containerMargin = 2; //Margin towards the container
	var rightOffset = this.chart._menuButton && this.chart.exportEnabled && this.verticalAlign === "top" ? 22 : 0; //So that Title doesn't overlap menu button.

	var textBlockHorizontalAlign;
	var position;

	if (this.verticalAlign === "top" || this.verticalAlign === "bottom") {
		if (this.maxWidth === null) this.maxWidth = freespace.width - containerMargin * 2 - rightOffset * (this.horizontalAlign === "center" ? 2 : 1);

		maxHeight = freespace.height * .5 - this.margin - containerMargin;
		angle = 0;
	} else if (this.verticalAlign === "center") {

		if (this.horizontalAlign === "left" || this.horizontalAlign === "right") {
			if (this.maxWidth === null) this.maxWidth = freespace.height - containerMargin * 2;

			maxHeight = freespace.width * .5 - this.margin - containerMargin;
		} else if (this.horizontalAlign === "center") {
			if (this.maxWidth === null) this.maxWidth = freespace.width - containerMargin * 2;

			maxHeight = freespace.height * .5 - containerMargin * 2;
		}
	}

	if (!this.wrap) maxHeight = Math.min(maxHeight, Math.max(this.fontSize * 1.5, this.fontSize + this.padding * 2.5));
	//console.log(this.maxWidth);

	var textBlock = new _text_block2.default(this.ctx, {
		fontSize: this.fontSize, fontFamily: this.fontFamily, fontColor: this.fontColor,
		fontStyle: this.fontStyle, fontWeight: this.fontWeight,
		horizontalAlign: this.horizontalAlign, verticalAlign: this.verticalAlign,
		borderColor: this.borderColor, borderThickness: this.borderThickness,
		backgroundColor: this.backgroundColor,
		maxWidth: this.maxWidth, maxHeight: maxHeight,
		cornerRadius: this.cornerRadius,
		text: this.text,
		padding: this.padding,
		textBaseline: "top"
	});

	var textBlockSize = textBlock.measureText();

	if (this.verticalAlign === "top" || this.verticalAlign === "bottom") {

		if (this.verticalAlign === "top") {
			top = freespace.y1 + containerMargin;
			position = "top";
		} else if (this.verticalAlign === "bottom") {
			top = freespace.y2 - containerMargin - textBlockSize.height;
			position = "bottom";
		}

		if (this.horizontalAlign === "left") {
			left = freespace.x1 + containerMargin;
		} else if (this.horizontalAlign === "center") {
			left = freespace.x1 + freespace.width / 2 - textBlockSize.width / 2;
		} else if (this.horizontalAlign === "right") {
			left = freespace.x2 - containerMargin - textBlockSize.width - rightOffset;
		}

		textBlockHorizontalAlign = this.horizontalAlign;

		this.width = textBlockSize.width;
		this.height = textBlockSize.height;
	} else if (this.verticalAlign === "center") {

		if (this.horizontalAlign === "left") {

			left = freespace.x1 + containerMargin;
			top = freespace.y2 - containerMargin - (this.maxWidth / 2 - textBlockSize.width / 2);
			angle = -90;

			position = "left";
			this.width = textBlockSize.height;
			this.height = textBlockSize.width;
		} else if (this.horizontalAlign === "right") {
			left = freespace.x2 - containerMargin;
			top = freespace.y1 + containerMargin + (this.maxWidth / 2 - textBlockSize.width / 2);
			angle = 90;

			position = "right";
			this.width = textBlockSize.height;
			this.height = textBlockSize.width;
		} else if (this.horizontalAlign === "center") {
			top = container.y1 + (container.height / 2 - textBlockSize.height / 2);
			left = container.x1 + (container.width / 2 - textBlockSize.width / 2);

			position = "center";
			this.width = textBlockSize.width;
			this.height = textBlockSize.height;
		}

		textBlockHorizontalAlign = "center";
	}

	textBlock.x = left;
	textBlock.y = top;
	textBlock.angle = angle;
	textBlock.horizontalAlign = textBlockHorizontalAlign;
	textBlock.render(true);

	container.layoutManager.registerSpace(position, {
		width: this.width + (position === "left" || position === "right" ? this.margin + containerMargin : 0),
		height: this.height + (position === "top" || position === "bottom" ? this.margin + containerMargin : 0)
	});

	this.bounds = {
		x1: left, y1: top, x2: left + this.width, y2: top + this.height
	};

	this.ctx.textBaseline = "top";
};

exports.default = Title;

},{"../helpers/utils":39,"./canvasjs":27,"./text_block":34}],36:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _animator = require('../helpers/animator');

var _animator2 = _interopRequireDefault(_animator);

var _render = require('../helpers/render');

var _render2 = _interopRequireDefault(_render);

var _canvasjs = require('./canvasjs');

var _canvasjs2 = _interopRequireDefault(_canvasjs);

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ToolTip(chart, options, theme) {

  ToolTip.base.constructor.call(this, "ToolTip", options, theme);

  this.chart = chart;
  this.canvas = chart.canvas;
  this.ctx = this.chart.ctx;
  this.currentSeriesIndex = -1;
  this.currentDataPointIndex = -1;
  this._timerId = 0;
  this._prevX = NaN;
  this._prevY = NaN;

  this._initialize();
}

(0, _utils.extend)(ToolTip, _canvasjs2.default);

ToolTip.prototype._initialize = function () {

  if (this.enabled) {
    this.container = document.createElement("div");
    this.container.setAttribute("class", "canvasjs-chart-tooltip");
    this.container.style.position = "absolute";
    this.container.style.height = "auto";
    this.container.style.boxShadow = "1px 1px 2px 2px rgba(0,0,0,0.1)";
    this.container.style.zIndex = "1000";
    //this.container.style.pointerEvents = "none";
    this.container.style.display = "none";
    //this.container.style.whiteSpace = "no-wrap";

    var toolTipHtml = "<div style=\" width: auto;";
    toolTipHtml += "height: auto;";
    toolTipHtml += "min-width: 50px;";
    toolTipHtml += "line-height: auto;";
    toolTipHtml += "margin: 0px 0px 0px 0px;";
    toolTipHtml += "padding: 5px;";
    toolTipHtml += "font-family: Calibri, Arial, Georgia, serif;";
    toolTipHtml += "font-weight: normal;";
    toolTipHtml += "font-style: " + (_utils.isCanvasSupported ? "italic;" : "normal;");
    toolTipHtml += "font-size: 14px;";
    toolTipHtml += "color: #000000;";
    toolTipHtml += "text-shadow: 1px 1px 1px rgba(0, 0, 0, 0.1);";
    toolTipHtml += "text-align: left;";
    toolTipHtml += "border: 2px solid gray;";

    //Older browsers like IE8- don't support alpha values
    toolTipHtml += _utils.isCanvasSupported ? "background: rgba(255,255,255,.9);" : "background: rgb(255,255,255);";

    toolTipHtml += "text-indent: 0px;";
    toolTipHtml += "white-space: nowrap;";
    //toolTipHtml += "pointer-events:none;";
    toolTipHtml += "border-radius: 5px;";

    //Disable Text Selection
    toolTipHtml += "-moz-user-select:none;";
    toolTipHtml += "-khtml-user-select: none;";
    toolTipHtml += "-webkit-user-select: none;";
    toolTipHtml += "-ms-user-select: none;";
    toolTipHtml += "user-select: none;";

    //toolTipHtml += "opacity: 0;";
    //toolTipHtml += "filter: progid: DXImageTransform.Microsoft.gradient(GradientType = 0, startColorstr = '#4cffffff', endColorstr = '#4cffffff');";

    if (!_utils.isCanvasSupported) {
      //toolTipHtml += "-ms-filter:'progid:DXImageTransform.Microsoft.Alpha(Opacity=90)'";
      //-ms-filter: "progid:DXImageTransform.Microsoft.Shadow(Strength=4, Direction=135, Color='#000000')";
      /* For IE 5.5 - 7 */
      toolTipHtml += "filter: alpha(opacity = 90);";
      toolTipHtml += "filter: progid:DXImageTransform.Microsoft.Shadow(Strength=3, Direction=135, Color='#666666');";
    }

    toolTipHtml += "} \"> Sample Tooltip</div>";

    this.container.innerHTML = toolTipHtml;
    this.contentDiv = this.container.firstChild;

    this.container.style.borderRadius = this.contentDiv.style.borderRadius;
    this.chart._canvasJSContainer.appendChild(this.container);
  }
};

ToolTip.prototype.mouseMoveHandler = function (x, y) {

  if (!(this._lastUpdated && new Date().getTime() - this._lastUpdated < 40)) {
    this._lastUpdated = new Date().getTime();
    this._updateToolTip(x, y);
  }
};

ToolTip.prototype._updateToolTip = function (mouseX, mouseY) {
  //return;

  if (this.chart.disableToolTip) // Disabled during animation, etc
    return;

  if (typeof mouseX === "undefined" || typeof mouseY === "undefined") {
    if (isNaN(this._prevX) || isNaN(this._prevY)) return;else {
      mouseX = this._prevX;
      mouseY = this._prevY;
    }
  } else {
    this._prevX = mouseX;
    this._prevY = mouseY;
  }

  var dataPoint = null;
  var dataSeries = null;
  var toolTipContent = "";
  var entries = [];
  var toolTipRight;
  var toolTipBottom;
  var x = 0;

  if (this.shared && this.enabled && this.chart.plotInfo.axisPlacement !== "none") {
    // && this.chart.plotInfo.axisPlacement !== "none"
    if (this.chart.plotInfo.axisPlacement === "xySwapped") {
      x = (this.chart.axisX.viewportMaximum - this.chart.axisX.viewportMinimum) / this.chart.axisX.lineCoordinates.height * (this.chart.axisX.lineCoordinates.y2 - mouseY) + this.chart.axisX.viewportMinimum;
    } else {
      x = (this.chart.axisX.viewportMaximum - this.chart.axisX.viewportMinimum) / this.chart.axisX.lineCoordinates.width * (mouseX - this.chart.axisX.lineCoordinates.x1) + this.chart.axisX.viewportMinimum;
    }

    var nearbyEntries = [];

    for (var i = 0; i < this.chart.data.length; i++) {
      var entry = this.chart.data[i].getDataPointAtX(x, true);

      if (entry && entry.index >= 0) {
        entry.dataSeries = this.chart.data[i];

        if (entry.dataPoint.y !== null) nearbyEntries.push(entry);
      }
    }

    if (nearbyEntries.length === 0) return;

    nearbyEntries.sort(function (entry1, entry2) {
      return entry1.distance - entry2.distance;
    });

    var closest = nearbyEntries[0];

    for (i = 0; i < nearbyEntries.length; i++) {

      if (nearbyEntries[i].dataPoint.x.valueOf() === closest.dataPoint.x.valueOf()) entries.push(nearbyEntries[i]);
    }

    nearbyEntries = null;
  } else {

    var dataPointInfo = this.chart.getDataPointAtXY(mouseX, mouseY, true);
    //dataPointInfo = null;

    if (dataPointInfo) {
      this.currentDataPointIndex = dataPointInfo.dataPointIndex;
      this.currentSeriesIndex = dataPointInfo.dataSeries.index;
    } else if (_utils.isCanvasSupported) {

      var id = (0, _utils.getObjectId)(mouseX, mouseY, this.chart._eventManager.ghostCtx);
      if (id > 0 && typeof this.chart._eventManager.objectMap[id] !== "undefined") {
        //DataPoint/DataSeries event
        var eventObject = this.chart._eventManager.objectMap[id];

        if (eventObject.objectType === "legendItem") return;

        //if (this.currentSeriesIndex === eventObject.dataSeriesIndex && this.currentDataPointIndex === eventObject.dataPointIndex)
        //  return;
        //else {
        this.currentSeriesIndex = eventObject.dataSeriesIndex;
        this.currentDataPointIndex = eventObject.dataPointIndex >= 0 ? eventObject.dataPointIndex : -1;
        //}

        //window.console.log("id: " + id + "; hex: " + intToHexColorString(id));
      } else this.currentDataPointIndex = -1;
    } else this.currentDataPointIndex = -1;

    if (this.currentSeriesIndex >= 0) {

      dataSeries = this.chart.data[this.currentSeriesIndex];

      var entry = {};

      if (this.currentDataPointIndex >= 0) {
        dataPoint = dataSeries.dataPoints[this.currentDataPointIndex];

        entry.dataSeries = dataSeries;
        entry.dataPoint = dataPoint;
        entry.index = this.currentDataPointIndex;
        entry.distance = Math.abs(dataPoint.x - x);
      } else if (this.enabled && (dataSeries.type === "line" || dataSeries.type === "stepLine" || dataSeries.type === "spline" || dataSeries.type === "area" || dataSeries.type === "stepArea" || dataSeries.type === "splineArea" || dataSeries.type === "stackedArea" || dataSeries.type === "stackedArea100" || dataSeries.type === "rangeArea" || dataSeries.type === "rangeSplineArea" || dataSeries.type === "candlestick" || dataSeries.type === "ohlc")) {

        //var x = (this.chart.axisX.viewportMaximum - this.chart.axisX.viewportMinimum) / this.chart.axisX.lineCoordinates.width * (mouseX - this.chart.axisX.lineCoordinates.x1) + this.chart.axisX.viewportMinimum.valueOf();
        var x = dataSeries.axisX.conversionParameters.minimum + (mouseX - dataSeries.axisX.conversionParameters.reference) / dataSeries.axisX.conversionParameters.pixelPerUnit;

        entry = dataSeries.getDataPointAtX(x, true);
        entry.dataSeries = dataSeries;
        this.currentDataPointIndex = entry.index;
        dataPoint = entry.dataPoint;
      } else {
        //this.hide();
        return;
      }

      if (entry.dataPoint.y !== null) {
        if (entry.dataSeries.axisY) {
          if (entry.dataPoint.y.length > 0) {
            var unboundToViewport = 0;
            for (var i = 0; i < entry.dataPoint.y.length; i++) {
              if (entry.dataPoint.y[i] < entry.dataSeries.axisY.viewportMinimum) unboundToViewport--;else if (entry.dataPoint.y[i] > entry.dataSeries.axisY.viewportMaximum) unboundToViewport++;
            }if (unboundToViewport < entry.dataPoint.y.length && unboundToViewport > -entry.dataPoint.y.length) entries.push(entry);
          } else {
            if (entry.dataPoint.y >= entry.dataSeries.axisY.viewportMinimum && entry.dataPoint.y <= entry.dataSeries.axisY.viewportMaximum) entries.push(entry);
          }
        } else entries.push(entry);
      }
    }
  }

  if (entries.length > 0) {

    this.highlightObjects(entries);

    if (this.enabled) {

      var toolTipInnerHtml = "";

      toolTipInnerHtml = this.getToolTipInnerHTML({ entries: entries });

      if (toolTipInnerHtml !== null) {
        this.contentDiv.innerHTML = toolTipInnerHtml;

        this.contentDiv.innerHTML = toolTipInnerHtml;

        var previouslyHidden = false;
        if (this.container.style.display === "none") {
          previouslyHidden = true;
          this.container.style.display = "block";
        }

        try {
          this.contentDiv.style.background = this.backgroundColor ? this.backgroundColor : _utils.isCanvasSupported ? "rgba(255,255,255,.9)" : "rgb(255,255,255)";

          this.contentDiv.style.borderRightColor = this.contentDiv.style.borderLeftColor = this.contentDiv.style.borderColor = this.borderColor ? this.borderColor : entries[0].dataPoint.color ? entries[0].dataPoint.color : entries[0].dataSeries.color ? entries[0].dataSeries.color : entries[0].dataSeries._colorSet[entries[0].index % entries[0].dataSeries._colorSet.length];

          this.contentDiv.style.borderWidth = this.borderThickness || this.borderThickness === 0 ? this.borderThickness + "px" : 2 + "px";

          this.contentDiv.style.borderRadius = this.cornerRadius || this.cornerRadius === 0 ? this.cornerRadius + "px" : 5 + "px";
          this.container.style.borderRadius = this.contentDiv.style.borderRadius;

          this.contentDiv.style.fontSize = this.fontSize || this.fontSize === 0 ? this.fontSize + "px" : 14 + "px";
          this.contentDiv.style.color = this.fontColor ? this.fontColor : "#000000";
          this.contentDiv.style.fontFamily = this.fontFamily ? this.fontFamily : "Calibri, Arial, Georgia, serif;";
          this.contentDiv.style.fontWeight = this.fontWeight ? this.fontWeight : "normal";
          this.contentDiv.style.fontStyle = this.fontStyle ? this.fontStyle : _utils.isCanvasSupported ? "italic" : "normal";
        } catch (e) {}

        var toolTipLeft;

        if (entries[0].dataSeries.type === "pie" || entries[0].dataSeries.type === "doughnut" || entries[0].dataSeries.type === "funnel" || entries[0].dataSeries.type === "bar" || entries[0].dataSeries.type === "rangeBar" || entries[0].dataSeries.type === "stackedBar" || entries[0].dataSeries.type === "stackedBar100") {
          toolTipLeft = mouseX - 10 - this.container.clientWidth;
        } else {
          //toolTipLeft = (((this.chart.axisX.lineCoordinates.width / Math.abs(this.chart.axisX.viewportMaximum - this.chart.axisX.viewportMinimum)) * Math.abs(entries[0].dataPoint.x - this.chart.axisX.viewportMinimum)) + this.chart.axisX.lineCoordinates.x1 + .5) - this.container.clientWidth << 0;
          toolTipLeft = entries[0].dataSeries.axisX.conversionParameters.reference + entries[0].dataSeries.axisX.conversionParameters.pixelPerUnit * (entries[0].dataPoint.x - entries[0].dataSeries.axisX.conversionParameters.minimum) - this.container.clientWidth << 0;
          toolTipLeft -= 10;
        }

        if (toolTipLeft < 0) {
          toolTipLeft += this.container.clientWidth + 20;
        }

        if (toolTipLeft + this.container.clientWidth > this.chart._container.clientWidth) toolTipLeft = Math.max(0, this.chart._container.clientWidth - this.container.clientWidth);

        toolTipLeft += "px";

        if (entries.length === 1 && !this.shared && (entries[0].dataSeries.type === "line" || entries[0].dataSeries.type === "stepLine" || entries[0].dataSeries.type === "spline" || entries[0].dataSeries.type === "area" || entries[0].dataSeries.type === "stepArea" || entries[0].dataSeries.type === "splineArea" || entries[0].dataSeries.type === "stackedArea" || entries[0].dataSeries.type === "stackedArea100")) {
          //toolTipBottom = (entries[0].dataSeries.axisY.lineCoordinates.y2 - entries[0].dataSeries.axisY.lineCoordinates.height / Math.abs(entries[0].dataSeries.axisY.maximum - entries[0].dataSeries.axisY.viewportMinimum) * Math.abs(entries[0].dataPoint.y - entries[0].dataSeries.axisY.viewportMinimum) + .5) << 0;
          toolTipBottom = entries[0].dataSeries.axisY.conversionParameters.reference + entries[0].dataSeries.axisY.conversionParameters.pixelPerUnit * (entries[0].dataPoint.y - entries[0].dataSeries.axisY.viewportMinimum) + .5 << 0;
        } else if (entries[0].dataSeries.type === "bar" || entries[0].dataSeries.type === "rangeBar" || entries[0].dataSeries.type === "stackedBar" || entries[0].dataSeries.type === "stackedBar100") {
          //toolTipBottom = (entries[0].dataSeries.axisX.lineCoordinates.y2 - entries[0].dataSeries.axisX.lineCoordinates.height / Math.abs(entries[0].dataSeries.axisX.maximum - entries[0].dataSeries.axisX.viewportMinimum) * Math.abs(entries[0].dataPoint.x - entries[0].dataSeries.axisX.viewportMinimum) + .5) << 0;
          toolTipBottom = entries[0].dataSeries.axisX.conversionParameters.reference + entries[0].dataSeries.axisX.conversionParameters.pixelPerUnit * (entries[0].dataPoint.x - entries[0].dataSeries.axisX.viewportMinimum) + .5 << 0;
        } else {
          toolTipBottom = mouseY;
        }

        toolTipBottom = -toolTipBottom + 10;

        if (toolTipBottom + this.container.clientHeight + 5 > 0) {
          toolTipBottom -= toolTipBottom + this.container.clientHeight + 5 - 0;
        }

        toolTipBottom += "px";

        //this.container.style.right = toolTipRight;
        this.container.style.left = toolTipLeft;
        this.container.style.bottom = toolTipBottom;

        if (!this.animationEnabled || previouslyHidden) {
          this.disableAnimation();
        } else this.enableAnimation();
      } else {
        this.hide(false);
      }
    }

    //if (isDebugMode)
    //  console.log("searchX: " + x + " x: " + searchResult.dataPoint.x + "; y: " + searchResult.dataPoint.y + "; distance: " + searchResult.distance + "; steps: " + steps);
  }
};

ToolTip.prototype.highlightObjects = function (entries) {
  //if (!this.enabled)
  //	return;

  //this.chart.overlaidCanvasCtx.clearRect(0, 0, this.chart.overlaidCanvas.width, this.chart.overlaidCanvas.height);
  var overlaidCanvasCtx = this.chart.overlaidCanvasCtx;
  this.chart.resetOverlayedCanvas();

  overlaidCanvasCtx.clearRect(0, 0, this.chart.width, this.chart.height);
  overlaidCanvasCtx.save();

  var plotArea = this.chart.plotArea;
  var offset = 0;

  overlaidCanvasCtx.rect(plotArea.x1, plotArea.y1, plotArea.x2 - plotArea.x1, plotArea.y2 - plotArea.y1);
  overlaidCanvasCtx.clip();

  for (var i = 0; i < entries.length; i++) {

    var entry = entries[i];

    var eventObject = this.chart._eventManager.objectMap[entry.dataSeries.dataPointIds[entry.index]];

    if (!eventObject || !eventObject.objectType || eventObject.objectType !== "dataPoint") continue;

    var dataSeries = this.chart.data[eventObject.dataSeriesIndex];
    var dataPoint = dataSeries.dataPoints[eventObject.dataPointIndex];
    var index = eventObject.dataPointIndex;

    if (dataPoint.highlightEnabled !== false && (dataSeries.highlightEnabled === true || dataPoint.highlightEnabled === true)) {

      if (dataSeries.type === "line" || dataSeries.type === "stepLine" || dataSeries.type === "spline" || dataSeries.type === "scatter" || dataSeries.type === "area" || dataSeries.type === "stepArea" || dataSeries.type === "splineArea" || dataSeries.type === "stackedArea" || dataSeries.type === "stackedArea100" || dataSeries.type === "rangeArea" || dataSeries.type === "rangeSplineArea") {
        var markerProps = dataSeries.getMarkerProperties(index, eventObject.x1, eventObject.y1, this.chart.overlaidCanvasCtx);
        markerProps.size = Math.max(markerProps.size * 1.5 << 0, 10);

        markerProps.borderColor = markerProps.borderColor || "#FFFFFF";
        markerProps.borderThickness = markerProps.borderThickness || Math.ceil(markerProps.size * .1);

        //overlaidCanvasCtx.globalAlpha = .8;
        _render2.default.drawMarkers([markerProps]);
        //overlaidCanvasCtx.globalAlpha = .8;

        if (typeof eventObject.y2 !== "undefined") {

          var markerProps = dataSeries.getMarkerProperties(index, eventObject.x1, eventObject.y2, this.chart.overlaidCanvasCtx);
          markerProps.size = Math.max(markerProps.size * 1.5 << 0, 10);

          markerProps.borderColor = markerProps.borderColor || "#FFFFFF";
          markerProps.borderThickness = markerProps.borderThickness || Math.ceil(markerProps.size * .1);

          //overlaidCanvasCtx.globalAlpha = .8;
          _render2.default.drawMarkers([markerProps]);
          //overlaidCanvasCtx.globalAlpha = .8;
        }
      } else if (dataSeries.type === "bubble") {
        var markerProps = dataSeries.getMarkerProperties(index, eventObject.x1, eventObject.y1, this.chart.overlaidCanvasCtx);
        markerProps.size = eventObject.size;
        markerProps.color = "white";
        markerProps.borderColor = "white";
        //markerProps.borderThickness = 2;
        overlaidCanvasCtx.globalAlpha = .3;
        _render2.default.drawMarkers([markerProps]);
        overlaidCanvasCtx.globalAlpha = 1;
      } else if (dataSeries.type === "column" || dataSeries.type === "stackedColumn" || dataSeries.type === "stackedColumn100" || dataSeries.type === "bar" || dataSeries.type === "rangeBar" || dataSeries.type === "stackedBar" || dataSeries.type === "stackedBar100" || dataSeries.type === "rangeColumn") {
        (0, _utils.drawRect)(overlaidCanvasCtx, eventObject.x1, eventObject.y1, eventObject.x2, eventObject.y2, "white", 0, null, false, false, false, false, .3);
      } else if (dataSeries.type === "pie" || dataSeries.type === "doughnut") {
        (0, _utils.drawSegment)(overlaidCanvasCtx, eventObject.center, eventObject.radius, "white", dataSeries.type, eventObject.startAngle, eventObject.endAngle, .3, eventObject.percentInnerRadius);
      } else if (dataSeries.type === "candlestick") {

        overlaidCanvasCtx.globalAlpha = 1;
        overlaidCanvasCtx.strokeStyle = eventObject.color;
        overlaidCanvasCtx.lineWidth = eventObject.borderThickness * 2;
        offset = overlaidCanvasCtx.lineWidth % 2 === 0 ? 0 : .5;

        overlaidCanvasCtx.beginPath();
        overlaidCanvasCtx.moveTo(eventObject.x3 - offset, eventObject.y2);
        overlaidCanvasCtx.lineTo(eventObject.x3 - offset, Math.min(eventObject.y1, eventObject.y4));
        overlaidCanvasCtx.stroke();

        overlaidCanvasCtx.beginPath();
        overlaidCanvasCtx.moveTo(eventObject.x3 - offset, Math.max(eventObject.y1, eventObject.y4));
        overlaidCanvasCtx.lineTo(eventObject.x3 - offset, eventObject.y3);
        overlaidCanvasCtx.stroke();

        (0, _utils.drawRect)(overlaidCanvasCtx, eventObject.x1, Math.min(eventObject.y1, eventObject.y4), eventObject.x2, Math.max(eventObject.y1, eventObject.y4), "transparent", eventObject.borderThickness * 2, eventObject.color, false, false, false, false);
        overlaidCanvasCtx.globalAlpha = 1;
      } else if (dataSeries.type === "ohlc") {
        overlaidCanvasCtx.globalAlpha = 1;

        overlaidCanvasCtx.strokeStyle = eventObject.color;
        overlaidCanvasCtx.lineWidth = eventObject.borderThickness * 2;

        offset = overlaidCanvasCtx.lineWidth % 2 === 0 ? 0 : .5;

        overlaidCanvasCtx.beginPath();
        overlaidCanvasCtx.moveTo(eventObject.x3 - offset, eventObject.y2);
        overlaidCanvasCtx.lineTo(eventObject.x3 - offset, eventObject.y3);
        overlaidCanvasCtx.stroke();

        overlaidCanvasCtx.beginPath();
        overlaidCanvasCtx.moveTo(eventObject.x3, eventObject.y1);
        overlaidCanvasCtx.lineTo(eventObject.x1, eventObject.y1);
        overlaidCanvasCtx.stroke();

        overlaidCanvasCtx.beginPath();
        overlaidCanvasCtx.moveTo(eventObject.x3, eventObject.y4);
        overlaidCanvasCtx.lineTo(eventObject.x2, eventObject.y4);
        overlaidCanvasCtx.stroke();

        overlaidCanvasCtx.globalAlpha = 1;
      }
    }
  }

  overlaidCanvasCtx.restore();
  overlaidCanvasCtx.globalAlpha = 1;
  overlaidCanvasCtx.beginPath();

  return;
};

ToolTip.prototype.getToolTipInnerHTML = function (e) {
  var entries = e.entries;
  var toolTipInnerHtml = null;
  var dataSeries = null;
  var dataPoint = null;
  var index = 0;
  var color = null;
  var toolTipContent = "";

  var isToolTipDefinedInData = true;
  for (var i = 0; i < entries.length; i++) {
    if (entries[i].dataSeries.toolTipContent || entries[i].dataPoint.toolTipContent) {
      isToolTipDefinedInData = false;
      break;
    }
  }

  if (isToolTipDefinedInData && (this.content && typeof this.content === "function" || this.contentFormatter)) {

    var param = {
      chart: this.chart, toolTip: this._options, entries: entries
    };
    toolTipInnerHtml = this.contentFormatter ? this.contentFormatter(param) : this.content(param);
  } else {

    if (this.shared && this.chart.plotInfo.axisPlacement !== "none") {

      var toolTipInnerHtmlPrefix = "";

      for (var i = 0; i < entries.length; i++) {
        dataSeries = entries[i].dataSeries;
        dataPoint = entries[i].dataPoint;
        index = entries[i].index;

        toolTipContent = "";

        if (i === 0 && isToolTipDefinedInData && !this.content) {
          toolTipInnerHtmlPrefix += typeof this.chart.axisX.labels[dataPoint.x] !== "undefined" ? this.chart.axisX.labels[dataPoint.x] : "{x}";
          toolTipInnerHtmlPrefix += "</br>";
          toolTipInnerHtmlPrefix = this.chart.replaceKeywordsWithValue(toolTipInnerHtmlPrefix, dataPoint, dataSeries, index);
        }

        //Allows disabling of toolTip for individual dataPoints/dataSeries
        if (dataPoint.toolTipContent === null || typeof dataPoint.toolTipContent === "undefined" && dataSeries._options.toolTipContent === null) continue;

        if (dataSeries.type === "line" || dataSeries.type === "stepLine" || dataSeries.type === "spline" || dataSeries.type === "area" || dataSeries.type === "stepArea" || dataSeries.type === "splineArea" || dataSeries.type === "column" || dataSeries.type === "bar" || dataSeries.type === "scatter" || dataSeries.type === "stackedColumn" || dataSeries.type === "stackedColumn100" || dataSeries.type === "stackedBar" || dataSeries.type === "stackedBar100" || dataSeries.type === "stackedArea" || dataSeries.type === "stackedArea100") {
          toolTipContent += dataPoint.toolTipContent ? dataPoint.toolTipContent : dataSeries.toolTipContent ? dataSeries.toolTipContent : this.content && typeof this.content !== "function" ? this.content : "<span style='\"'color:{color};'\"'>{name}:</span>&nbsp;&nbsp;{y}";
        } else if (dataSeries.type === "bubble") {
          toolTipContent += dataPoint.toolTipContent ? dataPoint.toolTipContent : dataSeries.toolTipContent ? dataSeries.toolTipContent : this.content && typeof this.content !== "function" ? this.content : "<span style='\"'color:{color};'\"'>{name}:</span>&nbsp;&nbsp;{y}, &nbsp;&nbsp;{z}";
        } else if (dataSeries.type === "pie" || dataSeries.type === "doughnut" || dataSeries.type === "funnel") {
          toolTipContent += dataPoint.toolTipContent ? dataPoint.toolTipContent : dataSeries.toolTipContent ? dataSeries.toolTipContent : this.content && typeof this.content !== "function" ? this.content : "&nbsp;&nbsp;{y}";
        } else if (dataSeries.type === "rangeColumn" || dataSeries.type === "rangeBar" || dataSeries.type === "rangeArea" || dataSeries.type === "rangeSplineArea") {
          toolTipContent += dataPoint.toolTipContent ? dataPoint.toolTipContent : dataSeries.toolTipContent ? dataSeries.toolTipContent : this.content && typeof this.content !== "function" ? this.content : "<span style='\"'color:{color};'\"'>{name}:</span>&nbsp;&nbsp;{y[0]},&nbsp;{y[1]}";
        } else if (dataSeries.type === "candlestick" || dataSeries.type === "ohlc") {
          toolTipContent += dataPoint.toolTipContent ? dataPoint.toolTipContent : dataSeries.toolTipContent ? dataSeries.toolTipContent : this.content && typeof this.content !== "function" ? this.content : "<span style='\"'color:{color};'\"'>{name}:</span>" + "<br/>Open: &nbsp;&nbsp;{y[0]}" + "<br/>High: &nbsp;&nbsp;&nbsp;{y[1]}" + "<br/>Low:&nbsp;&nbsp;&nbsp;{y[2]}" + "<br/>Close: &nbsp;&nbsp;{y[3]}";
        }

        if (toolTipInnerHtml === null) toolTipInnerHtml = "";

        if (this.reversed === true) {

          toolTipInnerHtml = this.chart.replaceKeywordsWithValue(toolTipContent, dataPoint, dataSeries, index) + toolTipInnerHtml;

          if (i < entries.length - 1) toolTipInnerHtml = "</br>" + toolTipInnerHtml;
        } else {

          toolTipInnerHtml += this.chart.replaceKeywordsWithValue(toolTipContent, dataPoint, dataSeries, index);

          if (i < entries.length - 1) toolTipInnerHtml += "</br>";
        }
      }

      if (toolTipInnerHtml !== null) toolTipInnerHtml = toolTipInnerHtmlPrefix + toolTipInnerHtml;
    } else {

      dataSeries = entries[0].dataSeries;
      dataPoint = entries[0].dataPoint;
      index = entries[0].index;

      //Allows disabling of toolTip for individual dataPoints/dataSeries
      if (dataPoint.toolTipContent === null || typeof dataPoint.toolTipContent === "undefined" && dataSeries._options.toolTipContent === null) return null;

      if (dataSeries.type === "line" || dataSeries.type === "stepLine" || dataSeries.type === "spline" || dataSeries.type === "area" || dataSeries.type === "stepArea" || dataSeries.type === "splineArea" || dataSeries.type === "column" || dataSeries.type === "bar" || dataSeries.type === "scatter" || dataSeries.type === "stackedColumn" || dataSeries.type === "stackedColumn100" || dataSeries.type === "stackedBar" || dataSeries.type === "stackedBar100" || dataSeries.type === "stackedArea" || dataSeries.type === "stackedArea100") {
        toolTipContent = dataPoint.toolTipContent ? dataPoint.toolTipContent : dataSeries.toolTipContent ? dataSeries.toolTipContent : this.content && typeof this.content !== "function" ? this.content : "<span style='\"'color:{color};'\"'>" + (dataPoint.label ? "{label}" : "{x}") + " :</span>&nbsp;&nbsp;{y}";
      } else if (dataSeries.type === "bubble") {
        toolTipContent = dataPoint.toolTipContent ? dataPoint.toolTipContent : dataSeries.toolTipContent ? dataSeries.toolTipContent : this.content && typeof this.content !== "function" ? this.content : "<span style='\"'color:{color};'\"'>" + (dataPoint.label ? "{label}" : "{x}") + ":</span>&nbsp;&nbsp;{y}, &nbsp;&nbsp;{z}";
      } else if (dataSeries.type === "pie" || dataSeries.type === "doughnut" || dataSeries.type === "funnel") {
        toolTipContent = dataPoint.toolTipContent ? dataPoint.toolTipContent : dataSeries.toolTipContent ? dataSeries.toolTipContent : this.content && typeof this.content !== "function" ? this.content : (dataPoint.name ? "{name}:&nbsp;&nbsp;" : dataPoint.label ? "{label}:&nbsp;&nbsp;" : "") + "{y}";
      } else if (dataSeries.type === "rangeColumn" || dataSeries.type === "rangeBar" || dataSeries.type === "rangeArea" || dataSeries.type === "rangeSplineArea") {
        toolTipContent = dataPoint.toolTipContent ? dataPoint.toolTipContent : dataSeries.toolTipContent ? dataSeries.toolTipContent : this.content && typeof this.content !== "function" ? this.content : "<span style='\"'color:{color};'\"'>" + (dataPoint.label ? "{label}" : "{x}") + " :</span>&nbsp;&nbsp;{y[0]}, &nbsp;{y[1]}";
      } else if (dataSeries.type === "candlestick" || dataSeries.type === "ohlc") {
        toolTipContent = dataPoint.toolTipContent ? dataPoint.toolTipContent : dataSeries.toolTipContent ? dataSeries.toolTipContent : this.content && typeof this.content !== "function" ? this.content : "<span style='\"'color:{color};'\"'>" + (dataPoint.label ? "{label}" : "{x}") + "</span>" + "<br/>Open: &nbsp;&nbsp;{y[0]}" + "<br/>High: &nbsp;&nbsp;&nbsp;{y[1]}" + "<br/>Low: &nbsp;&nbsp;&nbsp;&nbsp;{y[2]}" + "<br/>Close: &nbsp;&nbsp;{y[3]}";
      }

      if (toolTipInnerHtml === null) toolTipInnerHtml = "";

      toolTipInnerHtml += this.chart.replaceKeywordsWithValue(toolTipContent, dataPoint, dataSeries, index);
    }
  }

  return toolTipInnerHtml;
};

ToolTip.prototype.enableAnimation = function () {
  if (this.container.style.WebkitTransition) return;

  this.container.style.WebkitTransition = "left .2s ease-out, bottom .2s ease-out";
  this.container.style.MozTransition = "left .2s ease-out, bottom .2s ease-out";
  this.container.style.MsTransition = "left .2s ease-out, bottom .2s ease-out";
  this.container.style.transition = "left .2s ease-out, bottom .2s ease-out";
};

ToolTip.prototype.disableAnimation = function () {
  if (!this.container.style.WebkitTransition) return;

  this.container.style.WebkitTransition = "";
  this.container.style.MozTransition = "";
  this.container.style.MsTransition = "";
  this.container.style.transition = "";
};

ToolTip.prototype.hide = function (resetOverlayedCanvas) {
  if (!this.enabled) return;

  resetOverlayedCanvas = typeof resetOverlayedCanvas === "undefined" ? true : resetOverlayedCanvas;

  this.container.style.display = "none";
  this.currentSeriesIndex = -1;
  this._prevX = NaN;
  this._prevY = NaN;
  //this.chart.overlaidCanvasCtx.clearRect(0, 0, this.chart.overlaidCanvas.width, this.chart.overlaidCanvas.height);
  if (resetOverlayedCanvas) this.chart.resetOverlayedCanvas();
};

exports.default = ToolTip;

},{"../helpers/animator":37,"../helpers/render":38,"../helpers/utils":39,"./canvasjs":27}],37:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

function yScaleAnimation(fractionComplete, animationInfo) {

  if (fractionComplete === 0) return;

  var ctx = animationInfo.dest;
  var sourceCanvas = animationInfo.source.canvas;
  var base = animationInfo.animationBase;

  var offsetY = base - base * fractionComplete;

  ctx.drawImage(sourceCanvas, 0, 0, sourceCanvas.width, sourceCanvas.height, 0, offsetY, ctx.canvas.width / devicePixelBackingStoreRatio, fractionComplete * ctx.canvas.height / devicePixelBackingStoreRatio);
}

function xScaleAnimation(fractionComplete, animationInfo) {

  if (fractionComplete === 0) return;

  var ctx = animationInfo.dest;
  var sourceCanvas = animationInfo.source.canvas;
  var base = animationInfo.animationBase;

  var offsetX = base - base * fractionComplete;

  ctx.drawImage(sourceCanvas, 0, 0, sourceCanvas.width, sourceCanvas.height, offsetX, 0, fractionComplete * ctx.canvas.width / devicePixelBackingStoreRatio, ctx.canvas.height / devicePixelBackingStoreRatio);
}

function xClipAnimation(fractionComplete, animationInfo) {

  if (fractionComplete === 0) return;

  var ctx = animationInfo.dest;
  var sourceCanvas = animationInfo.source.canvas;

  ctx.save();

  if (fractionComplete > 0) ctx.drawImage(sourceCanvas, 0, 0, sourceCanvas.width * fractionComplete, sourceCanvas.height, 0, 0, sourceCanvas.width * fractionComplete / devicePixelBackingStoreRatio, sourceCanvas.height / devicePixelBackingStoreRatio);

  ctx.restore();
}

function fadeInAnimation(fractionComplete, animationInfo) {

  if (fractionComplete === 0) return;

  var ctx = animationInfo.dest;
  var sourceCanvas = animationInfo.source.canvas;

  ctx.save();

  ctx.globalAlpha = fractionComplete;

  ctx.drawImage(sourceCanvas, 0, 0, sourceCanvas.width, sourceCanvas.height, 0, 0, ctx.canvas.width / devicePixelBackingStoreRatio, ctx.canvas.height / devicePixelBackingStoreRatio);

  ctx.restore();
}

var easing = {
  linear: function linear(t, b, c, d) {
    return c * t / d + b;
  },
  easeOutQuad: function easeOutQuad(t, b, c, d) {
    return -c * (t /= d) * (t - 2) + b;
  },
  easeOutQuart: function easeOutQuart(t, b, c, d) {
    return -c * ((t = t / d - 1) * t * t * t - 1) + b;
  },
  easeInQuad: function easeInQuad(t, b, c, d) {
    return c * (t /= d) * t + b;
  },
  easeInQuart: function easeInQuart(t, b, c, d) {
    return c * (t /= d) * t * t * t + b;
  }
};

exports.default = {

  yScaleAnimation: yScaleAnimation,
  xScaleAnimation: xScaleAnimation,
  xClipAnimation: xClipAnimation,
  fadeInAnimation: fadeInAnimation,
  easing: easing

};

},{}],38:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
      value: true
});
var RenderHelper = {

      drawMarker: function drawMarker(x, y, ctx, markerType, markerSize, markerColor, markerBorderColor, markerBorderThickness) {

            if (!ctx) return;

            var alpha = 1;

            ctx.fillStyle = markerColor ? markerColor : "#000000";
            ctx.strokeStyle = markerBorderColor ? markerBorderColor : "#000000";
            ctx.lineWidth = markerBorderThickness ? markerBorderThickness : 0;

            if (markerType === "circle") {

                  ctx.moveTo(x, y);
                  ctx.beginPath();
                  //return;

                  ctx.arc(x, y, markerSize / 2, 0, Math.PI * 2, false);

                  if (markerColor) ctx.fill();

                  if (markerBorderThickness) {

                        if (!markerBorderColor) {
                              alpha = ctx.globalAlpha;
                              ctx.globalAlpha = .15;
                              ctx.strokeStyle = "black";
                              ctx.stroke();
                              ctx.globalAlpha = alpha;
                        } else ctx.stroke();
                  }
            } else if (markerType === "square") {

                  //ctx.moveTo(x - markerSize / 2, y - markerSize / 2);
                  ctx.beginPath();
                  ctx.rect(x - markerSize / 2, y - markerSize / 2, markerSize, markerSize);

                  if (markerColor) ctx.fill();

                  if (markerBorderThickness) {

                        if (!markerBorderColor) {
                              alpha = ctx.globalAlpha;
                              ctx.globalAlpha = .15;
                              ctx.strokeStyle = "black";
                              ctx.stroke();
                              ctx.globalAlpha = alpha;
                        } else ctx.stroke();
                  }
            } else if (markerType === "triangle") {

                  ctx.beginPath();
                  ctx.moveTo(x - markerSize / 2, y + markerSize / 2);
                  ctx.lineTo(x + markerSize / 2, y + markerSize / 2);
                  ctx.lineTo(x, y - markerSize / 2);
                  ctx.closePath();

                  if (markerColor) ctx.fill();

                  if (markerBorderThickness) {

                        if (!markerBorderColor) {
                              alpha = ctx.globalAlpha;
                              ctx.globalAlpha = .15;
                              ctx.strokeStyle = "black";
                              ctx.stroke();
                              ctx.globalAlpha = alpha;
                        } else ctx.stroke();
                  }
                  ctx.beginPath();
            } else if (markerType === "cross") {

                  ctx.strokeStyle = markerColor;
                  markerBorderThickness = markerSize / 4;
                  ctx.lineWidth = markerBorderThickness;

                  ctx.beginPath();
                  ctx.moveTo(x - markerSize / 2, y - markerSize / 2);
                  ctx.lineTo(x + markerSize / 2, y + markerSize / 2);
                  ctx.stroke();

                  ctx.moveTo(x + markerSize / 2, y - markerSize / 2);
                  ctx.lineTo(x - markerSize / 2, y + markerSize / 2);
                  ctx.stroke();
            }
      },
      drawMarkers: function drawMarkers(markers) {
            for (var i = 0; i < markers.length; i++) {
                  var marker = markers[i];

                  RenderHelper.drawMarker(marker.x, marker.y, marker.ctx, marker.type, marker.size, marker.color, marker.borderColor, marker.borderThickness);
            }
      }
      //,
      //draw1pxLine: function (x1, y1, x2, y2, color, ctx) {
      //	ctx.beginPath();
      //	ctx.drawRect(x1, y1, x2 - x1, y2 - y1);
      //	ctx.stroke();
      //}
};

exports.default = RenderHelper;

},{}],39:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extend = extend;
exports.inherit = inherit;
exports.addToDateTime = addToDateTime;
exports.convertToNumber = convertToNumber;
exports.pad = pad;
exports.trimString = trimString;
exports.extendCtx = extendCtx;
exports.compareNumbers = compareNumbers;
exports.compareDataPointX = compareDataPointX;
exports.intToHexColorString = intToHexColorString;
exports.RGBToInt = RGBToInt;
exports.intToRGB = intToRGB;
exports.arrayIndexOf = arrayIndexOf;
exports.addArrayIndexOf = addArrayIndexOf;
exports.getFontHeightInPixels = getFontHeightInPixels;
exports.getLineDashArray = getLineDashArray;
exports.addEvent = addEvent;
exports.dateFormat = dateFormat;
exports.numberFormat = numberFormat;
exports.getObjectId = getObjectId;
exports.getMouseCoordinates = getMouseCoordinates;
exports.getFontString = getFontString;
exports.getProperty = getProperty;
exports.getDevicePixelBackingStoreRatio = getDevicePixelBackingStoreRatio;
exports.setCanvasSize = setCanvasSize;
exports.createCanvas = createCanvas;
exports.exportCanvas = exportCanvas;
exports.setButtonState = setButtonState;
exports.show = show;
exports.hide = hide;
exports.getBezierPoints = getBezierPoints;
exports.convertPercentToValue = convertPercentToValue;
exports.drawRect = drawRect;
exports.drawSegment = drawSegment;
function extend(derived, base) {
  derived.prototype = inherit(base.prototype);
  derived.prototype.constructor = derived;
  derived.base = base.prototype;
}

function inherit(proto) {
  function F() {}
  F.prototype = proto;
  return new F();
}

function addToDateTime(dateTime, num, type) {
  if (type === "millisecond") dateTime.setMilliseconds(dateTime.getMilliseconds() + 1 * num);else if (type === "second") dateTime.setSeconds(dateTime.getSeconds() + 1 * num);else if (type === "minute") dateTime.setMinutes(dateTime.getMinutes() + 1 * num);else if (type === "hour") dateTime.setHours(dateTime.getHours() + 1 * num);else if (type === "day") dateTime.setDate(dateTime.getDate() + 1 * num);else if (type === "week") dateTime.setDate(dateTime.getDate() + 7 * num);else if (type === "month") dateTime.setMonth(dateTime.getMonth() + 1 * num);else if (type === "year") dateTime.setFullYear(dateTime.getFullYear() + 1 * num);

  return dateTime;
}

function convertToNumber(num, type) {
  return constants[type + "Duration"] * num;
}

function pad(value, length) {
  var isNegative = false;
  if (value < 0) {
    isNegative = true;
    value *= -1;
  }

  value = "" + value;
  length = !length ? 1 : length;

  while (value.length < length) {
    value = "0" + value;
  }return isNegative ? "-" + value : value;
}

function trimString(str) {
  if (!str) return str;

  str = str.replace(/^\s\s*/, "");
  var ws = /\s/;
  var i = str.length;
  while (ws.test(str.charAt(--i))) {}
  return str.slice(0, i + 1);
}

function extendCtx(context) {
  context.roundRect = function (x, y, width, height, radius, borderThickness, backgroundColor, borderColor) {
    ///<signature>
    ///<summary>Creates a rounded rectangle with given fill/stroke parameters</summary>
    ///<param name="x" type="number">x value</param>
    ///<param name="y" type="number">y value</param>
    ///<param name="width" type="number">Border Width</param>
    ///<param name="height" type="number">Border Height</param>
    ///<param name="radius" type="number">Border CornerRadius</param>
    ///<param name="borderThickness" type="number">Border Thickess</param>
    ///<param name="backgroundColor" type="number">Background Color</param>
    ///<param name="borderColor" type="number">Border Color</param>
    ///</signature>

    if (backgroundColor) {
      this.fillStyle = backgroundColor;
    }

    if (borderColor) {
      this.strokeStyle = borderColor;
    }

    //if (typeof stroke == "undefined") {
    //	stroke = true;
    //}

    if (typeof radius === "undefined") {
      radius = 5;
    }

    this.lineWidth = borderThickness;

    this.beginPath();
    this.moveTo(x + radius, y);
    this.lineTo(x + width - radius, y);
    this.quadraticCurveTo(x + width, y, x + width, y + radius);
    this.lineTo(x + width, y + height - radius);
    this.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);
    this.lineTo(x + radius, y + height);
    this.quadraticCurveTo(x, y + height, x, y + height - radius);
    this.lineTo(x, y + radius);
    this.quadraticCurveTo(x, y, x + radius, y);
    this.closePath();

    if (backgroundColor) {
      this.fill();
    }

    if (borderColor && borderThickness > 0) {
      this.stroke();
    }
  };
}

function compareNumbers(a, b) {
  return a - b;
}

function compareDataPointX(dataPoint1, dataPoint2) {
  return dataPoint1.x - dataPoint2.x;
}

function intToHexColorString(num) {
  var r = ((num & 0xff0000) >> 16).toString(16);
  var g = ((num & 0x00ff00) >> 8).toString(16);
  var b = ((num & 0x0000ff) >> 0).toString(16);

  r = r.length < 2 ? "0" + r : r;
  g = g.length < 2 ? "0" + g : g;
  b = b.length < 2 ? "0" + b : b;

  return "#" + r + g + b;
}

function RGBToInt(r, g, b) {
  var num = r << 16 | g << 8 | b;

  return num;
}

function intToRGB(num) {
  var rgb = [];
  var r = (num & 0xff0000) >> 16;
  var g = (num & 0x00ff00) >> 8;
  var b = (num & 0x0000ff) >> 0;

  //r = r.length < 2 ? "0" + r : r;
  //g = g.length < 2 ? "0" + g : g;
  //b = b.length < 2 ? "0" + b : b;

  rgb[0] = r;
  rgb[1] = g;
  rgb[2] = b;

  return rgb;
}

function arrayIndexOf(elt /*, from*/) {
  var len = this.length >>> 0;

  var from = Number(arguments[1]) || 0;
  from = from < 0 ? Math.ceil(from) : Math.floor(from);
  if (from < 0) from += len;

  for (; from < len; from++) {
    if (from in this && this[from] === elt) return from;
  }
  return -1;
}

//IE8- Fix: indexOf is not supported in IE8- for arrays
function addArrayIndexOf(obj) {
  if (!obj.indexOf) {
    obj.indexOf = arrayIndexOf;
  }

  return obj;
}

var fontHeightInPixels = {};
var textMeasureEl = null;

function getFontHeightInPixels(fontFamily, fontSize, fontWeight) {
  //return fontSize;

  fontWeight = fontWeight || "normal";

  var entry = fontFamily + "_" + fontSize + "_" + fontWeight;
  var height = fontHeightInPixels[entry];

  if (isNaN(height)) {
    try {
      var style = "position:absolute; left:0px; top:-20000px; padding:0px;margin:0px;border:none;white-space:pre;line-height:normal;" + "font-family:" + fontFamily + "; " + "font-size:" + fontSize + "px; font-weight:" + fontWeight + ";";
      //console.log(style);
      if (!textMeasureEl) {
        var body = document.body;
        textMeasureEl = document.createElement("span");
        textMeasureEl.innerHTML = "";
        var textNode = document.createTextNode("Mpgyi");
        textMeasureEl.appendChild(textNode);
        body.appendChild(textMeasureEl);
      }

      textMeasureEl.style.display = "";
      textMeasureEl.setAttribute("style", style);

      height = Math.round(textMeasureEl.offsetHeight);
      textMeasureEl.style.display = "none";
      //body.removeChild(tempDiv);

      //if (window.console)
      //	window.console.log(fontSize + ": " + height);
    } catch (e) {
      height = Math.ceil(fontSize * 1.1);
    }

    height = Math.max(height, fontSize);

    fontHeightInPixels[entry] = height;
  }

  return height;
}

function getLineDashArray(lineDashType, lineThickness) {
  lineDashType = lineDashType || "solid";

  var lineDashArray = [];

  var lineDashTypeMap = {
    solid: [],
    shortDash: [3, 1],
    shortDot: [1, 1],
    shortDashDot: [3, 1, 1, 1],
    shortDashDotDot: [3, 1, 1, 1, 1, 1],
    dot: [1, 2],
    dash: [4, 2],
    dashDot: [4, 2, 1, 2],
    longDash: [8, 2],
    longDashDot: [8, 2, 1, 2],
    longDashDotDot: [8, 2, 1, 2, 1, 2]
  };

  lineDashArray = lineDashTypeMap[lineDashType];

  if (lineDashArray) {
    for (var i = 0; i < lineDashArray.length; i++) {
      lineDashArray[i] *= lineThickness;
    }
  } else lineDashArray = [];

  return lineDashArray;
}

//userCapture is optional. Defaults to false
function addEvent(obj, eventType, fn, useCapture) {
  if (obj.addEventListener) {
    obj.addEventListener(eventType, fn, useCapture || false);
  } else if (obj.attachEvent) {
    obj.attachEvent("on" + eventType, function (e) {
      e = e || window.event;
      e.preventDefault = e.preventDefault || function () {
        e.returnValue = false;
      };
      e.stopPropagation = e.stopPropagation || function () {
        e.cancelBubble = true;
      };
      fn.call(obj, e);
    });
  } else return false;
}

//#region formatting functions/methods
function dateFormat() {
  var reg = /D{1,4}|M{1,4}|Y{1,4}|h{1,2}|H{1,2}|m{1,2}|s{1,2}|f{1,3}|t{1,2}|T{1,2}|K|z{1,3}|"[^"]*"|'[^']*'/g;

  var defDays = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
  var defShortDays = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];

  var defMonths = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
  var defShortMonths = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];

  var timezone = /\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g;
  var timezoneClip = /[^-+\dA-Z]/g;

  return function (dt, formatString, cultureInfo) {
    var days = cultureInfo ? cultureInfo.days : defDays;
    var months = cultureInfo ? cultureInfo.months : defMonths;

    var shortDays = cultureInfo ? cultureInfo.shortDays : defShortDays;
    var shortMonths = cultureInfo ? cultureInfo.shortMonths : defShortMonths;

    var result = "";
    var utc = false;

    dt = dt && dt.getTime ? dt : dt ? new Date(dt) : new Date();
    if (isNaN(dt)) throw SyntaxError("invalid date");

    if (formatString.slice(0, 4) === "UTC:") {
      formatString = formatString.slice(4);
      utc = true;
    }

    var pre = utc ? "getUTC" : "get";
    var date = dt[pre + "Date"]();
    var day = dt[pre + "Day"]();
    var month = dt[pre + "Month"]();
    var year = dt[pre + "FullYear"]();
    var hours = dt[pre + "Hours"]();
    var minutes = dt[pre + "Minutes"]();
    var seconds = dt[pre + "Seconds"]();
    var milliseconds = dt[pre + "Milliseconds"]();
    var offset = utc ? 0 : dt.getTimezoneOffset();

    result = formatString.replace(reg, function (key) {
      switch (key) {
        case "D":
          return date;
        case "DD":
          return pad(date, 2);
        case "DDD":
          return shortDays[day];
        case "DDDD":
          return days[day];

        case "M":
          return month + 1;
        case "MM":
          return pad(month + 1, 2);
        case "MMM":
          return shortMonths[month];
        case "MMMM":
          return months[month];

        case "Y":
          return parseInt(String(year).slice(-2));
        case "YY":
          return pad(String(year).slice(-2), 2);
        case "YYY":
          return pad(String(year).slice(-3), 3);
        case "YYYY":
          return pad(year, 4);

        case "h":
          return hours % 12 || 12;
        case "hh":
          return pad(hours % 12 || 12, 2);

        case "H":
          return hours;
        case "HH":
          return pad(hours, 2);

        case "m":
          return minutes;
        case "mm":
          return pad(minutes, 2);

        case "s":
          return seconds;
        case "ss":
          return pad(seconds, 2);

        case "f":
          return String(milliseconds).slice(0, 1);
        case "ff":
          return pad(String(milliseconds).slice(0, 2), 2);
        case "fff":
          return pad(String(milliseconds).slice(0, 3), 3);

        case "t":
          return hours < 12 ? "a" : "p";
        case "tt":
          return hours < 12 ? "am" : "pm";
        case "T":
          return hours < 12 ? "A" : "P";
        case "TT":
          return hours < 12 ? "AM" : "PM";

        case "K":
          return utc ? "UTC" : (String(dt).match(timezone) || [""]).pop().replace(timezoneClip, ""); // Time Zone;
        case "z":
          return (offset > 0 ? "-" : "+") + Math.floor(Math.abs(offset) / 60); // Hour Offset from UTC without padding
        case "zz":
          return (offset > 0 ? "-" : "+") + pad(Math.floor(Math.abs(offset) / 60), 2); // Hour Offset from UTC with padding
        case "zzz":
          return (offset > 0 ? "-" : "+") + pad(Math.floor(Math.abs(offset) / 60), 2) + pad(Math.abs(offset) % 60, 2); // Hour and Minute Offset from UTC with padding

        default:
          return key.slice(1, key.length - 1);
      }
    });

    return result;
  };
}

function numberFormat(v, fs, cultureInfo) {
  if (v === null) return "";

  v = Number(v);
  var isNegative = v < 0 ? true : false;
  if (isNegative) v *= -1;

  var decimalSeparator = cultureInfo ? cultureInfo.decimalSeparator : ".";
  var digitGroupSeparator = cultureInfo ? cultureInfo.digitGroupSeparator : ",";

  var vString = "";
  fs = String(fs);
  var multiplier = 1;
  var temp;
  var result = "";

  var matches = "";
  var decimalPosition = -1;
  var fsBeforeDecimal = [];
  var fsAfterDecimal = [];
  var noPhBeforeDecimal = 0; // Number of Placeholders before Decimal
  var noPhAfterDecimal = 0; // Number of Placeholders after Decimal
  var noComma = 0;
  var isScientificNotation = false;
  var exponent = 0;

  matches = fs.match(/"[^"]*"|'[^']*'|[eE][+-]*[0]+|[,]+[.]|‰|./g);
  //window.console.log(matches + " = " + matches.length);
  var match = null;

  for (var i = 0; matches && i < matches.length; i++) {
    match = matches[i];

    if (match === "." && decimalPosition < 0) {
      decimalPosition = i;
      continue;
    } else if (match === "%") {
      multiplier *= 100;
    } else if (match === "‰") {
      multiplier *= 1000;
      continue;
    } else if (match[0] === "," && match[match.length - 1] === ".") {
      multiplier /= Math.pow(1000, match.length - 1);
      decimalPosition = i + match.length - 1;
      continue;
    } else if ((match[0] === "E" || match[0] === "e") && match[match.length - 1] === "0") {
      isScientificNotation = true;
    }

    if (decimalPosition < 0) {
      fsBeforeDecimal.push(match);
      if (match === "#" || match === "0") noPhBeforeDecimal++;else if (match === ",") noComma++;
    } else {
      fsAfterDecimal.push(match);
      if (match === "#" || match === "0") noPhAfterDecimal++;
    }
  }

  if (isScientificNotation) {
    var integer = Math.floor(v);
    exponent = (integer === 0 ? "" : String(integer)).length - noPhBeforeDecimal;
    multiplier /= Math.pow(10, exponent);
  }

  v *= multiplier;

  if (decimalPosition < 0) decimalPosition = i;

  vString = v.toFixed(noPhAfterDecimal);
  var split = vString.split(".");
  //window.console.log(split);
  var vStringBeforeDecimal = (split[0] + "").split("");
  var vStringAfterDecimal = (split[1] + "").split("");

  if (vStringBeforeDecimal && vStringBeforeDecimal[0] === "0") vStringBeforeDecimal.shift();

  //window.console.log(fsBeforeDecimal + "<---------->" + fsAfterDecimal + " &        " + vStringBeforeDecimal + "<---------->" + vStringAfterDecimal);

  var noPhProcessed = 0;
  var noDigitsAdded = 0;
  var noCommaAdded = 0;
  var commaDistance = 0;
  var distanceFromLastComma = 0;

  while (fsBeforeDecimal.length > 0) {
    match = fsBeforeDecimal.pop();

    if (match === "#" || match === "0") {
      noPhProcessed++;

      if (noPhProcessed === noPhBeforeDecimal) {
        var digits = vStringBeforeDecimal;
        vStringBeforeDecimal = [];

        if (match === "0") {
          //var totalDigits = result.match(/[0-9]/g).length;
          var toPad = noPhBeforeDecimal - noDigitsAdded - (digits ? digits.length : 0);

          while (toPad > 0) {
            digits.unshift("0");
            toPad--;
          }
        }

        while (digits.length > 0) {
          result = digits.pop() + result;
          distanceFromLastComma++;

          if (distanceFromLastComma % commaDistance === 0 && noCommaAdded === noComma && digits.length > 0) result = digitGroupSeparator + result;
        }

        if (isNegative) result = "-" + result;
      } else {
        if (vStringBeforeDecimal.length > 0) {
          result = vStringBeforeDecimal.pop() + result;
          noDigitsAdded++;
          distanceFromLastComma++;
        } else if (match === "0") {
          result = "0" + result;
          noDigitsAdded++;
          distanceFromLastComma++;
        }

        if (distanceFromLastComma % commaDistance === 0 && noCommaAdded === noComma && vStringBeforeDecimal.length > 0) result = digitGroupSeparator + result;
      }
    } else if ((match[0] === "E" || match[0] === "e") && match[match.length - 1] === "0" && /[eE][+-]*[0]+/.test(match)) {
      if (exponent < 0) match = match.replace("+", "").replace("-", "");else match = match.replace("-", "");

      result += match.replace(/[0]+/, function ($0) {
        return pad(exponent, $0.length);
      });
    } else {
      if (match === ",") {
        noCommaAdded++;
        commaDistance = distanceFromLastComma;
        distanceFromLastComma = 0;

        if (vStringBeforeDecimal.length > 0) result = digitGroupSeparator + result;
      } else if (match.length > 1 && (match[0] === '"' && match[match.length - 1] === '"' || match[0] === "'" && match[match.length - 1] === "'")) {
        result = match.slice(1, match.length - 1) + result;
      } else result = match + result;
    }
  }

  var charCount = 0;
  var resultAfterDecimal = "";
  var addDecimalSeparator = false;

  while (fsAfterDecimal.length > 0) {
    match = fsAfterDecimal.shift();

    if (match === "#" || match === "0") {
      if (vStringAfterDecimal.length > 0 && Number(vStringAfterDecimal.join("")) !== 0) {
        resultAfterDecimal += vStringAfterDecimal.shift();
        addDecimalSeparator = true;
      } else if (match === "0") {
        resultAfterDecimal += "0";
        addDecimalSeparator = true;
      }
    } else if (match.length > 1 && (match[0] === '"' && match[match.length - 1] === '"' || match[0] === "'" && match[match.length - 1] === "'")) {
      resultAfterDecimal += match.slice(1, match.length - 1);
      //addDecimalSeparator = true;
    } else if ((match[0] === "E" || match[0] === "e") && match[match.length - 1] === "0" && /[eE][+-]*[0]+/.test(match)) {
      if (exponent < 0) match = match.replace("+", "").replace("-", "");else match = match.replace("-", "");
      resultAfterDecimal += match.replace(/[0]+/, function ($0) {
        return pad(exponent, $0.length);
      });
    } else {
      resultAfterDecimal += match;
      //addDecimalSeparator = true;
    }
  }

  result += (addDecimalSeparator ? decimalSeparator : "") + resultAfterDecimal;
  //window.console.log(result);
  return result;
}

//#endregion formatting functions/methods

function getObjectId(x, y, ctx) {
  x *= devicePixelBackingStoreRatio;
  y *= devicePixelBackingStoreRatio;
  var pixels = ctx.getImageData(x, y, 2, 2).data;
  var isObject = true;

  for (var i = 0; i < 4; i++) {
    if (pixels[i] !== pixels[i + 4] | pixels[i] !== pixels[i + 8] | pixels[i] !== pixels[i + 12]) {
      isObject = false;
      break;
    }
  }

  if (isObject) {
    return RGBToInt(pixels[0], pixels[1], pixels[2]);
  } else {
    return 0;
  }

  //window.console.log(pixels);
}

//extracts mouse coordinates from the event parameters
function getMouseCoordinates(ev) {
  var x = 0;
  var y = 0;

  ev = ev || window.event;

  if (ev.offsetX || ev.offsetX === 0) {
    x = ev.offsetX;
    y = ev.offsetY;
  } else if (ev.layerX || ev.layerX == 0) {
    // Firefox
    x = ev.layerX;
    y = ev.layerY;
  } else {
    x = ev.pageX - ev.target.offsetLeft;
    y = ev.pageY - ev.target.offsetTop;
  }

  return { x: x, y: y };
}

function getFontString(prefix, object, fallbackObject) {
  var fontString = "";

  var fontStyleString = prefix ? prefix + "FontStyle" : "fontStyle";
  var fontWeightString = prefix ? prefix + "FontWeight" : "fontWeight";
  var fontSizeString = prefix ? prefix + "FontSize" : "fontSize";
  var fontFamilyString = prefix ? prefix + "FontFamily" : "fontFamily";

  fontString += object[fontStyleString] ? object[fontStyleString] + " " : fallbackObject && fallbackObject[fontStyleString] ? fallbackObject[fontStyleString] + " " : "";
  fontString += object[fontWeightString] ? object[fontWeightString] + " " : fallbackObject && fallbackObject[fontWeightString] ? fallbackObject[fontWeightString] + " " : "";
  fontString += object[fontSizeString] ? object[fontSizeString] + "px " : fallbackObject && fallbackObject[fontSizeString] ? fallbackObject[fontSizeString] + "px " : "";

  var fontFamily = object[fontFamilyString] ? object[fontFamilyString] + "" : fallbackObject && fallbackObject[fontFamilyString] ? fallbackObject[fontFamilyString] + "" : "";

  if (!isCanvasSupported && fontFamily) {
    var firstFontFamily = fontFamily.split(",")[0];

    if (firstFontFamily[0] !== "'" && firstFontFamily[0] !== '"') firstFontFamily = "'" + firstFontFamily + "'";

    fontString += firstFontFamily;
  } else fontString += fontFamily;

  return fontString;
}

function getProperty(propertyName, object, fallbackObject) {
  var value = propertyName in object ? object[propertyName] : fallbackObject[propertyName];

  return value;
}

var optimizeForHiDPI = true;
//optimizeForHiDPI = false;
var devicePixelRatio = window.devicePixelRatio || 1;
var backingStoreRatio = 1;

function getDevicePixelBackingStoreRatio() {
  return optimizeForHiDPI ? devicePixelRatio / backingStoreRatio : 1;
}

var devicePixelBackingStoreRatio = getDevicePixelBackingStoreRatio();

function setCanvasSize(canvas, width, height) {
  if (isCanvasSupported && !!optimizeForHiDPI) {
    var ctx = canvas.getContext("2d");
    backingStoreRatio = ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1;

    devicePixelBackingStoreRatio = getDevicePixelBackingStoreRatio();

    canvas.width = width * devicePixelBackingStoreRatio;
    canvas.height = height * devicePixelBackingStoreRatio;

    if (devicePixelRatio !== backingStoreRatio) {
      canvas.style.width = width + "px";
      canvas.style.height = height + "px";

      ctx.scale(devicePixelBackingStoreRatio, devicePixelBackingStoreRatio);
    }

    //window.alert(backingStoreRatio);
    //window.alert(devicePixelRatio);
  } else {
    canvas.width = width;
    canvas.height = height;
  }
}

function createCanvas(width, height) {
  var canvas = document.createElement("canvas");
  canvas.setAttribute("class", "canvasjs-chart-canvas");

  setCanvasSize(canvas, width, height);

  if (!isCanvasSupported && typeof G_vmlCanvasManager !== "undefined") {
    G_vmlCanvasManager.initElement(canvas);
  }

  return canvas;
}

function exportCanvas(canvas, format, fileName) {
  if (!canvas || !format || !fileName) return;

  var fullFileName = fileName + "." + (format === "jpeg" ? "jpg" : format);
  var mimeType = "image/" + format;
  var img = canvas.toDataURL(mimeType);
  var saved = false;

  var downloadLink = document.createElement("a");
  downloadLink.download = fullFileName;
  downloadLink.href = img;
  downloadLink.target = "_blank";
  var e;

  if (typeof Blob !== "undefined" && !!new Blob()) {
    //alert("blob");
    var imgData = img.replace(/^data:[a-z/]*;base64,/, "");

    var byteString = atob(imgData);
    var buffer = new ArrayBuffer(byteString.length);
    var intArray = new Uint8Array(buffer);
    for (var i = 0; i < byteString.length; i++) {
      intArray[i] = byteString.charCodeAt(i);
    }

    var blob = new Blob([buffer], { type: "image/" + format });

    // Save the blob
    try {
      window.navigator.msSaveBlob(blob, fullFileName);
      saved = true;
    } catch (e) {
      downloadLink.dataset.downloadurl = [mimeType, downloadLink.download, downloadLink.href].join(":");
      downloadLink.href = window.URL.createObjectURL(blob);
    }
  }

  if (!saved) {
    try {
      event = document.createEvent("MouseEvents");

      event.initMouseEvent("click", true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);

      if (downloadLink.dispatchEvent) {
        //alert("dispatchEvent");
        downloadLink.dispatchEvent(event);
      } else if (downloadLink.fireEvent) {
        //alert("fireEvent");
        downloadLink.fireEvent("onclick");
      }
    } catch (e) {
      var win = window.open();
      //alert("<IE10");
      //window.console.log("IE");
      win.document.write("<img src='" + img + "'></img><div>Please right click on the image and save it to your device</div>");
      win.document.close();
    }
  }
}

var base64Images = {
  reset: {
    image: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAcCAYAAAAAwr0iAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAKRSURBVEiJrdY/iF1FFMfxzwnZrGISUSR/JLGIhoh/QiRNBLWxMLIWEkwbgiAoFgoW2mhlY6dgpY2IlRBRxBSKhSAKIklWJRYuMZKAhiyopAiaTY7FvRtmZ+/ed9/zHRjezLw5v/O9d86cuZGZpmURAfdn5o9DfdZNLXpjz+LziPgyIl6MiG0jPTJzZBuyDrP4BVm0P/AKbljTb4ToY/gGewYA7KyCl+1b3DUYANvwbiHw0gCAGRzBOzjTAXEOu0cC4Ch+r5x/HrpdrcZmvIDFSucMtnYCYC++6HmNDw8FKDT34ETrf639/azOr5vwRk/g5fbeuABtgC04XWk9VQLciMP4EH/3AFzErRNC7MXlQmsesSoHsGPE23hmEoBW+61K66HMXFmIMvN8myilXS36R01ub+KfYvw43ZXwYDX+AHP4BAci4pFJomfmr/ihmNofESsBImJGk7mlncrM45n5JPbhz0kAWpsv+juxaX21YIPmVJS2uNzJMS6ZNexC0d+I7fUWXLFyz2kSZlpWPvASlmqAf/FXNXf3FAF2F/1LuFifAlionB6dRuSI2IwHi6lzmXmp6xR8XY0fiIh7psAwh+3FuDkRHQVjl+a8lkXjo0kLUKH7XaV5oO86PmZ1FTzyP4K/XGl9v/zwfbW7BriiuETGCP5ch9bc9f97HF/vcFzCa5gdEPgWq+t/4v0V63oE1uF4h0DiFJ7HnSWMppDdh1dxtsPvJ2wcBNAKbsJXa0Ck5opdaBPsRNu/usba09i1KsaAVzmLt3sghrRjuK1Tf4xkegInxwy8gKf7dKMVH2QRsV5zXR/Cftyu+aKaKbbkQrsdH+PTzLzcqzkOQAVzM+7FHdiqqe2/YT4zF/t8S/sPmawyvC974vcAAAAASUVORK5CYII="
  },
  pan: {
    image: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAJVSURBVFiFvZe7a1RBGMV/x2hWI4JpfKCIiSBKOoOCkID/wP4BFqIIFkE02ChIiC8QDKlSiI3YqRBsBVGwUNAUdiIEUgjiAzQIIsuKJsfizsXr5t7d+8jmwLDfzHz3nLOzc7+ZxTZlGyDgZiWOCuJ9wH2gCUyuqQFgF/AGcKJNrYkBYBj40CIet+muGQi/96kM4WS7C/Tm5VUg7whJg8BkEGkCR4BDYfodsADUgP6wErO5iCtswsuJb32hdbXy8qzL5TIdmzJinHdZoZIBZcSFkGlAKs1Z3YCketZcBtouuaQNkrblMiBpBrhme7mAgU4wMCvpcFsDkq4C54DFVRTH9h+i6vlE0r5UA5ImgCuh28jB28iIs7BIVCOeStoZD64P4uPAjUTygKSx2FsK2TIwkugfk9Qkfd/E+yMWHQCeSRqx/R3gOp3LazfaS2C4B5gHDgD7U9x3E3uAH7KNpC3AHHAwTL4FHgM9GQ8vAaPA0dB/Abxqk2/gBLA9MXba9r1k/d4LfA3JtwueBeM58ucS+edXnAW23wP10N3advEi9CXizTnyN4bPS7Zn4sH/dq3t18AY4e1YLYSy3g/csj2VnFshZPuOpOeSKHCodUINuGj7YetE6je1PV9QoNPJ9StNHKodx7nRbiWrGHBGXAi5DUiqtQwtpcWK0Jubt8CltA5MEV1IfwO7+VffPwGfia5m34CT4bXujIIX0Qna1/cGMNqV/wUJE2czxD8CQ4X5Sl7Jz7SILwCDpbjKPBRMHAd+EtX4HWV5Spdc2w8kDQGPbH8py/MXMygM69/FKz4AAAAASUVORK5CYII="
  },
  zoom: {
    image: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAK6wAACusBgosNWgAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAMqSURBVFiFvdfbj91TFMDxz57U6GUEMS1aYzyMtCSSDhWjCZMInpAI3khE/QHtgzdRkXgSCS8SES9epKLi0oRKNETjRahREq2KS1stdRujtDPtbA97n5zdn9+5zJxTK9k5v3POXmt991p7r71+IcaoGwkhTOIebMRqzOBTvIG3Y4zTXRmqSoyx5cAKbMJOHMFJnMZ8/jyFaXyMR7G6nb1aH22cP4BvcBxziG3GKfyTIR9D6BYg1KUghPBCDveFlb/24Av8iuUYw41YVsz5G7uxKcZ4aMEpwGt5NY3V/YbHsQ6rcAHOw/kYxigewr5CZw4fYGxBKcCLOFEYehXrMdRhr5yLETxVScsOLOkKAPfn1TYMPIvLFrShUlS2FDZm8XRHACzFAWl3R2xbqPMCYhmeLCAOYEMngAczbcTvuHYxzguIy/FesR9e6gSwU/OoPYHBHgHgviIKX2Flq7k34KhmcVnbi/PC8JX4MgMcxb118wZwdz5aISscqx7VRcox7MrPQ7i+btIAJrAkf9+bI9EPmZY2IAxiTSuAldLq4Y9+AcSUh78KP0tbAcwU35cXMD1JCIFUoGiehlqAz6TNB1f1C0DK+0h+nsNPrQC2a4bqGmlD9kOGcWt+Po6pVgDvSxfJaSkFd4UQBvoAsBYbCoB3a2flM7slA0R8iyt6rAFDeDPbm8eOTpVwGD9qVq7nLbIaZnmksPU1JtsCZMXNmpdRxFasWITzh6Xj3LCzra1OxcD2QjHiGVzdpfORnMqZio2PcF23ABdJF1Np4BPptlyPi6WzPYBzpJZtHe7A6xW9cnyP8TqA//SEIYRL8Bxul7rihvwgtVn78WcGGZXa9HGd5TDujDHuOePXNiHdKjWgZX/YbsxLx/ktqbjVzTlcjUSnvI5JrdlUVp6WesZZ6R1hRrpq9+EVTGS9jTjYAuKIouGpbcurEkIYxC051KNSamazsc+xK8b4S0VnEi/j0hqTP+M27O258egQwZuzs7pI7Mf4WQXIEDc5s9sux+5+1Py2EmP8UOq6GvWhIScxfdYjUERiAt9Jd84J6a16zf8JEKT3yCm8g1UxRv8CC4pyRhzR1uUAAAAASUVORK5CYII="
  },
  menu: {
    image: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAgCAYAAAAbifjMAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAK6wAACusBgosNWgAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAAWdEVYdENyZWF0aW9uIFRpbWUAMDcvMTUvMTTPsvU0AAAAP0lEQVRIie2SMQoAIBDDUvH/X667g8sJJ9KOhYYOkW0qGaU1MPdC0vGSbV19EACo3YMPAFH5BUBUjsqfAPpVXtNgGDfxEDCtAAAAAElFTkSuQmCC"
  }
};

function setButtonState(chart, button, state) {
  if (button.getAttribute("state") !== state) {
    button.setAttribute("state", state);
    button.setAttribute("type", "button");
    button.style.position = "relative";
    button.style.margin = "0px 0px 0px 0px";
    button.style.padding = "3px 4px 0px 4px";
    button.style.cssFloat = "left";
    button.setAttribute("title", chart._cultureInfo[state + "Text"]);
    button.innerHTML = "<img style='height:16px;' src='" + base64Images[state].image + "' alt='" + chart._cultureInfo[state + "Text"] + "' />";
  }
}

function show() {
  var element = null;

  for (var i = 0; i < arguments.length; i++) {
    element = arguments[i];
    if (element.style) element.style.display = "inline";
  }
}

function hide() {
  var element = null;

  for (var i = 0; i < arguments.length; i++) {
    element = arguments[i];
    if (element && element.style) element.style.display = "none";
  }
}

var isCanvasSupported = exports.isCanvasSupported = !!document.createElement("canvas").getContext;

function getBezierPoints(points, tension) {
  var bezierPoints = [];

  for (var i = 0; i < points.length; i++) {
    if (i == 0) {
      bezierPoints.push(points[0]);
      continue;
    }

    var i1, i2, pointIndex;

    pointIndex = i - 1;
    i1 = pointIndex === 0 ? 0 : pointIndex - 1;
    i2 = pointIndex === points.length - 1 ? pointIndex : pointIndex + 1;

    var drv1 = {
      x: (points[i2].x - points[i1].x) / tension,
      y: (points[i2].y - points[i1].y) / tension
    };
    var cp1 = {
      x: points[pointIndex].x + drv1.x / 3,
      y: points[pointIndex].y + drv1.y / 3
    };
    bezierPoints[bezierPoints.length] = cp1;

    pointIndex = i;
    i1 = pointIndex === 0 ? 0 : pointIndex - 1;
    i2 = pointIndex === points.length - 1 ? pointIndex : pointIndex + 1;

    var drv2 = {
      x: (points[i2].x - points[i1].x) / tension,
      y: (points[i2].y - points[i1].y) / tension
    };
    var cp2 = {
      x: points[pointIndex].x - drv2.x / 3,
      y: points[pointIndex].y - drv2.y / 3
    };
    bezierPoints[bezierPoints.length] = cp2;

    bezierPoints[bezierPoints.length] = points[i];
  }

  return bezierPoints;
}

function convertPercentToValue(input, referenceValue) {
  //input can be a number or string
  if (input === null || typeof input === "undefined") return referenceValue;

  var result = parseFloat(input.toString()) * (input.toString().indexOf("%") >= 0 ? referenceValue / 100 : 1);

  // limit to plot area
  if (!isNaN(result) && result <= referenceValue && result >= 0) return result;

  return referenceValue;
}

function drawRect(ctx, x1, y1, x2, y2, color, borderThickness, borderColor, top, bottom, left, right, fillOpacity) {
  if (typeof fillOpacity === "undefined") fillOpacity = 1;

  borderThickness = borderThickness || 0;
  borderColor = borderColor || "black";
  //alert("top"+ top + "bottom" + bottom + " lt" + left+ "rt" + right )
  var a1 = x1,
      a2 = x2,
      b1 = y1,
      b2 = y2,
      edgeY,
      edgeX;
  if (x2 - x1 > 15 && y2 - y1 > 15) var bevelDepth = 8;else var bevelDepth = 0.35 * Math.min(x2 - x1, y2 - y1);
  //alert(a1 + "" + a2);
  var color2 = "rgba(255, 255, 255, .4)";
  var color3 = "rgba(255, 255, 255, 0.1)";
  //color1 = "rgba(" + r + "," + g + ", " + b + ",1)";
  var color1 = color;

  ctx.beginPath();
  ctx.moveTo(x1, y1);
  ctx.save();
  ctx.fillStyle = color1;

  ctx.globalAlpha = fillOpacity;
  ctx.fillRect(x1, y1, x2 - x1, y2 - y1);
  ctx.globalAlpha = 1;

  if (borderThickness > 0) {
    var offset = borderThickness % 2 === 0 ? 0 : 0.5;
    ctx.beginPath();
    ctx.lineWidth = borderThickness;
    ctx.strokeStyle = borderColor;
    ctx.moveTo(x1, y1);
    ctx.rect(x1 - offset, y1 - offset, x2 - x1 + 2 * offset, y2 - y1 + 2 * offset);
    ctx.stroke();
  }

  ctx.restore();
  //   ctx.beginPath();
  if (top === true) {
    // alert(x1 + "" + x2 + " " + bevelDepth);
    ctx.save();
    ctx.beginPath();
    ctx.moveTo(x1, y1);
    ctx.lineTo(x1 + bevelDepth, y1 + bevelDepth);
    ctx.lineTo(x2 - bevelDepth, y1 + bevelDepth);
    ctx.lineTo(x2, y1);
    ctx.closePath();
    var grd = ctx.createLinearGradient((x2 + x1) / 2, b1 + bevelDepth, (x2 + x1) / 2, b1);
    grd.addColorStop(0, color1);
    grd.addColorStop(1, color2);
    ctx.fillStyle = grd;
    ctx.fill();
    //              ctx.stroke();
    ctx.restore();
  }

  if (bottom === true) {
    ctx.save();
    ctx.beginPath();
    ctx.moveTo(x1, y2);
    ctx.lineTo(x1 + bevelDepth, y2 - bevelDepth);
    ctx.lineTo(x2 - bevelDepth, y2 - bevelDepth);
    ctx.lineTo(x2, y2);
    ctx.closePath();
    var grd = ctx.createLinearGradient((x2 + x1) / 2, b2 - bevelDepth, (x2 + x1) / 2, b2);
    grd.addColorStop(0, color1);
    grd.addColorStop(1, color2);
    ctx.fillStyle = grd;
    //       ctx.stroke();
    ctx.fill();
    ctx.restore();
  }

  if (left === true) {
    //   alert(x1)
    ctx.save();
    ctx.beginPath();
    ctx.moveTo(x1, y1);
    ctx.lineTo(x1 + bevelDepth, y1 + bevelDepth);
    ctx.lineTo(x1 + bevelDepth, y2 - bevelDepth);
    ctx.lineTo(x1, y2);
    ctx.closePath();
    var grd = ctx.createLinearGradient(a1 + bevelDepth, (y2 + y1) / 2, a1, (y2 + y1) / 2);
    grd.addColorStop(0, color1);
    grd.addColorStop(1, color3);
    ctx.fillStyle = grd;
    ctx.fill();
    //     ctx.stroke();
    ctx.restore();
  }

  if (right === true) {
    ctx.save();
    ctx.beginPath();
    ctx.moveTo(x2, y1);
    ctx.lineTo(x2 - bevelDepth, y1 + bevelDepth);
    ctx.lineTo(x2 - bevelDepth, y2 - bevelDepth);
    ctx.lineTo(x2, y2);
    var grd = ctx.createLinearGradient(a2 - bevelDepth, (y2 + y1) / 2, a2, (y2 + y1) / 2);
    grd.addColorStop(0, color1);
    grd.addColorStop(1, color3);
    ctx.fillStyle = grd;
    grd.addColorStop(0, color1);
    grd.addColorStop(1, color3);
    ctx.fillStyle = grd;
    ctx.fill();
    ctx.closePath();
    //          ctx.stroke();
    ctx.restore();
  }
  //
}

function drawSegment(ctx, center, radius, color, type, theta1, theta2, fillOpacity, percentInnerRadius) {
  if (typeof fillOpacity === "undefined") fillOpacity = 1;

  //IE8- FIX: In IE8- segment doesn't get draw if theta2 is equal to theta1 + 2*PI.
  if (!isCanvasSupported) {
    var theta2Mod = Number((theta2 % (2 * Math.PI)).toFixed(8));
    var theta1Mod = Number((theta1 % (2 * Math.PI)).toFixed(8));
    if (theta1Mod === theta2Mod) theta2 -= 0.0001;
  }

  ctx.save();
  ctx.globalAlpha = fillOpacity;

  if (type === "pie") {
    ctx.beginPath();
    ctx.moveTo(center.x, center.y);
    ctx.arc(center.x, center.y, radius, theta1, theta2, false);
    ctx.fillStyle = color;
    ctx.strokeStyle = "white";
    ctx.lineWidth = 2;
    //    ctx.shadowOffsetX = 2;
    //    ctx.shadowOffsetY = 1;
    //     ctx.shadowBlur = 2;
    //    ctx.shadowColor = '#BFBFBF';
    ctx.closePath();
    //ctx.stroke();
    ctx.fill();
  } else if (type === "doughnut") {
    ctx.beginPath();
    ctx.arc(center.x, center.y, radius, theta1, theta2, false);
    ctx.arc(center.x, center.y, percentInnerRadius * radius, theta2, theta1, true);
    ctx.closePath();
    ctx.fillStyle = color;
    ctx.strokeStyle = "white";
    ctx.lineWidth = 2;
    // shadow properties
    //     ctx.shadowOffsetX = 1;
    //    ctx.shadowOffsetY = 1;
    //     ctx.shadowBlur = 1;
    //    ctx.shadowColor = '#BFBFBF';  //grey shadow
    //ctx.stroke();
    ctx.fill();
  }

  ctx.globalAlpha = 1;

  ctx.restore();
}

},{}],40:[function(require,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.formatDate = exports.formatNumber = exports.addCultureInfo = exports.addColorSet = undefined;
exports.Chart = Chart;

var _charts = require('../core/charts');

var _charts2 = _interopRequireDefault(_charts);

var _culture_info = require('../core/culture_info');

var _culture_info2 = _interopRequireDefault(_culture_info);

var _themes = require('../constants/themes');

var _culture = require('../constants/culture');

var _utils = require('../helpers/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Chart(containerId, options) {
    var _this = this;

    var _chart = new _charts2.default(containerId, options, this);

    this.render = function () {
        return _chart.render(_this.options);
    };

    this.options = _chart._options;
} /**
  * @preserve CanvasJS HTML5 & JavaScript Charts - v1.8.0 Beta 2 - http://canvasjs.com/
  * CanvasJS Charts follows Dual Licensing Model as mentioned below.
  *
  * ---------------------Free for Non-Commercial Use--------------------
  *
  * For non-commercial purposes you can use the software for free under Creative Commons Attribution-NonCommercial 3.0 License. Refer to the following link for further details on the same.
  * http://creativecommons.org/licenses/by-nc/3.0/deed.en_US
  *
  * ---------------------Commercial License--------------------
  * Commercial use of CanvasJS requires you to purchase a license. Without a commercial license you can use it for evaluation purposes only. Please refer to the following link for further details.
  * http://canvasjs.com/
  *
  **/
;

var addColorSet = exports.addColorSet = function addColorSet(name, colorSet) {

    _themes.colorSets[name] = colorSet;
};

var addCultureInfo = exports.addCultureInfo = function addCultureInfo(name, cultureInfo) {

    _culture.cultures[name] = cultureInfo;
};

var formatNumber = exports.formatNumber = function formatNumber(number, formatString, culture) {

    culture = culture || "en";
    formatString = formatString || "#,##0.##";

    if (!_culture.cultures[culture]) throw "Unknown Culture Name";else (0, _utils.numberFormat)(number, formatString, new _culture_info2.default(culture));
};

var formatDate = exports.formatDate = function formatDate(date, formatString, culture) {

    culture = culture || "en";
    formatString = formatString || "DD MMM YYYY";

    if (!_culture.cultures[culture]) throw "Unknown Culture Name";else (0, _utils.dateFormat)(date, formatString, new _culture_info2.default(culture));
};

Chart.version = "v1.8.2";

},{"../constants/culture":22,"../constants/themes":24,"../core/charts":28,"../core/culture_info":29,"../helpers/utils":39}]},{},[40])(40)
});

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm5vZGVfbW9kdWxlcy9icm93c2VyLXBhY2svX3ByZWx1ZGUuanMiLCJzcmMvY2hhcnRzL2FyZWEuanMiLCJzcmMvY2hhcnRzL2Jhci5qcyIsInNyYy9jaGFydHMvYnViYmxlLmpzIiwic3JjL2NoYXJ0cy9jYW5kbGVzdGljay5qcyIsInNyYy9jaGFydHMvY29sdW1uLmpzIiwic3JjL2NoYXJ0cy9pbmRleC5qcyIsInNyYy9jaGFydHMvcGllLmpzIiwic3JjL2NoYXJ0cy9yYW5nZV9hcmVhLmpzIiwic3JjL2NoYXJ0cy9yYW5nZV9iYXIuanMiLCJzcmMvY2hhcnRzL3JhbmdlX2NvbHVtbi5qcyIsInNyYy9jaGFydHMvcmFuZ2Vfc3BsaW5lX2FyZWEuanMiLCJzcmMvY2hhcnRzL3NjYXR0ZXIuanMiLCJzcmMvY2hhcnRzL3NwbGluZS5qcyIsInNyYy9jaGFydHMvc3BsaW5lX2FyZWEuanMiLCJzcmMvY2hhcnRzL3N0YWNrZWRfYXJlYS5qcyIsInNyYy9jaGFydHMvc3RhY2tlZF9hcmVhXzEwMC5qcyIsInNyYy9jaGFydHMvc3RhY2tlZF9iYXIuanMiLCJzcmMvY2hhcnRzL3N0YWNrZWRfYmFyXzEwMC5qcyIsInNyYy9jaGFydHMvc3RhY2tlZF9jb2x1bW4uanMiLCJzcmMvY2hhcnRzL3N0YWNrZWRfY29sdW1uXzEwMC5qcyIsInNyYy9jaGFydHMvc3RlcF9hcmVhLmpzIiwic3JjL2NvbnN0YW50cy9jdWx0dXJlLmpzIiwic3JjL2NvbnN0YW50cy9vcHRpb25zLmpzIiwic3JjL2NvbnN0YW50cy90aGVtZXMuanMiLCJzcmMvY29yZS9hbmltYXRvci5qcyIsInNyYy9jb3JlL2F4aXMuanMiLCJzcmMvY29yZS9jYW52YXNqcy5qcyIsInNyYy9jb3JlL2NoYXJ0cy5qcyIsInNyYy9jb3JlL2N1bHR1cmVfaW5mby5qcyIsInNyYy9jb3JlL2RhdGFfc2VyaWVzLmpzIiwic3JjL2NvcmUvZXZlbnRfbWFuYWdlci5qcyIsInNyYy9jb3JlL2xheW91dF9tYW5hZ2VyLmpzIiwic3JjL2NvcmUvbGVnZW5kLmpzIiwic3JjL2NvcmUvdGV4dF9ibG9jay5qcyIsInNyYy9jb3JlL3RpdGxlLmpzIiwic3JjL2NvcmUvdG9vbHRpcC5qcyIsInNyYy9oZWxwZXJzL2FuaW1hdG9yLmpzIiwic3JjL2hlbHBlcnMvcmVuZGVyLmpzIiwic3JjL2hlbHBlcnMvdXRpbHMuanMiLCJzcmMvbWFpbi9pbmRleC5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7OztrQkNLZSxVQUFVLFFBQVYsRUFBb0I7QUFDbEMsS0FBSSxNQUFNLFNBQVMsZUFBVCxJQUE0QixLQUFLLFFBQUwsQ0FBYyxHQUFwRDs7QUFFQSxLQUFJLGtCQUFrQixTQUFTLGlCQUFULENBQTJCLE1BQWpEOztBQUVBLEtBQUksbUJBQW1CLENBQXZCLEVBQ0M7O0FBRUQsS0FBSSxXQUFXLEtBQUssYUFBTCxDQUFtQixRQUFsQzs7QUFFQSxLQUFJLGFBQWEsU0FBUyxLQUFULENBQWUsZUFBaEM7QUFDQSxLQUFJLGFBQWEsU0FBUyxLQUFULENBQWUsZUFBaEM7QUFDQSxLQUFJLFVBQVUsRUFBZDs7QUFFQSxLQUFJLFdBQVcsS0FBSyxRQUFwQjtBQUNBLEtBQUksSUFBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQ0MsU0FBUyxJQUFUOztBQUVELEtBQUksU0FBSjtBQUNBLEtBQUksSUFBSixDQUFTLFNBQVMsRUFBbEIsRUFBc0IsU0FBUyxFQUEvQixFQUFtQyxTQUFTLEtBQTVDLEVBQW1ELFNBQVMsTUFBNUQ7QUFDQSxLQUFJLElBQUo7O0FBRUEsS0FBSSx3QkFBSixFQUF1QjtBQUN0QixXQUFTLFNBQVQ7QUFDQSxXQUFTLElBQVQsQ0FBYyxTQUFTLEVBQXZCLEVBQTJCLFNBQVMsRUFBcEMsRUFBd0MsU0FBUyxLQUFqRCxFQUF3RCxTQUFTLE1BQWpFO0FBQ0EsV0FBUyxJQUFUO0FBQ0E7O0FBRUQsTUFBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFNBQVMsaUJBQVQsQ0FBMkIsTUFBL0MsRUFBdUQsR0FBdkQsRUFBNEQ7O0FBRTNELE1BQUksa0JBQWtCLFNBQVMsaUJBQVQsQ0FBMkIsQ0FBM0IsQ0FBdEI7O0FBRUEsTUFBSSxhQUFhLEtBQUssSUFBTCxDQUFVLGVBQVYsQ0FBakI7O0FBRUEsTUFBSSxhQUFhLFdBQVcsVUFBNUI7O0FBRUEsTUFBSSxXQUFXLFdBQVcsRUFBMUI7QUFDQSxPQUFLLGFBQUwsQ0FBbUIsU0FBbkIsQ0FBNkIsUUFBN0IsSUFBeUM7QUFDeEMsZUFBWSxZQUQ0QixFQUNkLGlCQUFpQjtBQURILEdBQXpDOztBQUlBLE1BQUksV0FBVyxnQ0FBb0IsUUFBcEIsQ0FBZjtBQUNBLFdBQVMsU0FBVCxHQUFxQixRQUFyQjtBQUNBO0FBQ0E7O0FBRUEsWUFBVSxFQUFWOztBQUVBLE1BQUksNkJBQTZCLElBQWpDO0FBQ0EsTUFBSSxJQUFJLENBQVI7QUFBQSxNQUFXLENBQVg7QUFBQSxNQUFjLENBQWQ7QUFDQSxNQUFJLFVBQUosQ0F0QjJELENBc0IzQzs7QUFFaEIsTUFBSSxlQUFnQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxJQUFJLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQTVGLENBQWhELEdBQXVKLEVBQXhKLElBQStKLENBQWxMO0FBQ0EsTUFBSSxLQUFKOztBQUVBLE1BQUksYUFBYSxJQUFqQjs7QUFFQSxNQUFJLFdBQVcsTUFBWCxHQUFvQixDQUF4QixFQUEyQjtBQUMxQjtBQUNBLE9BQUksUUFBUSxXQUFXLFNBQVgsQ0FBcUIsSUFBSSxXQUFXLFNBQVgsQ0FBcUIsTUFBOUMsQ0FBWjtBQUNBO0FBQ0EsT0FBSSxTQUFKLEdBQWdCLEtBQWhCO0FBQ0EsT0FBSSxXQUFKLEdBQWtCLEtBQWxCO0FBQ0EsT0FBSSxTQUFKLEdBQWdCLFdBQVcsYUFBM0I7O0FBRUEsT0FBSSxJQUFJLFdBQVIsRUFBcUI7QUFDcEIsUUFBSSxXQUFKLENBQWdCLDZCQUFpQixXQUFXLFlBQTVCLEVBQTBDLFdBQVcsYUFBckQsQ0FBaEI7QUFDQTs7QUFFRCxPQUFJLGVBQWUsSUFBbkI7QUFDQSxVQUFPLElBQUksV0FBVyxNQUF0QixFQUE4QixHQUE5QixFQUFtQzs7QUFFbEMsaUJBQWEsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixHQUEwQixXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLE9BQWhCLEVBQTFCLEdBQXNELFdBQVcsQ0FBWCxFQUFjLENBQWpGOztBQUVBLFFBQUksYUFBYSxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLFdBQXJDLElBQW9ELGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUE3RixFQUEwRztBQUN6RztBQUNBOztBQUVELFFBQUksT0FBUSxXQUFXLENBQVgsRUFBYyxDQUF0QixLQUE2QixRQUFqQyxFQUEyQztBQUMxQzs7QUFFQSxvQkFBZSxJQUFmO0FBQ0E7QUFDQTs7QUFFRCxRQUFLLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELGFBQWEsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBckcsQ0FBaEQsR0FBZ0ssRUFBakssSUFBd0ssQ0FBNUs7QUFDQSxRQUFLLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELFdBQVcsQ0FBWCxFQUFjLENBQWQsR0FBa0IsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBMUcsQ0FBaEQsR0FBcUssRUFBdEssSUFBNkssQ0FBakw7O0FBRUEsUUFBSSw4QkFBOEIsWUFBbEMsRUFBZ0Q7QUFDL0MsU0FBSSxTQUFKO0FBQ0EsU0FBSSxNQUFKLENBQVcsQ0FBWCxFQUFjLENBQWQ7QUFDQSxrQkFBYTtBQUNaLFNBQUcsQ0FEUyxFQUNOLEdBQUc7QUFERyxNQUFiOztBQUlBLFNBQUksd0JBQUosRUFBdUI7QUFDdEIsZUFBUyxTQUFUO0FBQ0EsZUFBUyxNQUFULENBQWdCLENBQWhCLEVBQW1CLENBQW5CO0FBQ0E7O0FBRUQsa0NBQTZCLEtBQTdCO0FBQ0Esb0JBQWUsS0FBZjtBQUNBLEtBZEQsTUFlSzs7QUFFSixTQUFJLE1BQUosQ0FBVyxDQUFYLEVBQWMsQ0FBZDs7QUFFQSxTQUFJLHdCQUFKLEVBQ0MsU0FBUyxNQUFULENBQWdCLENBQWhCLEVBQW1CLENBQW5COztBQUVELFNBQUksSUFBSSxHQUFKLElBQVcsQ0FBZixFQUFrQjtBQUNqQjtBQUNBO0FBQ0Q7O0FBR0QsUUFBSSxLQUFLLFdBQVcsWUFBWCxDQUF3QixDQUF4QixDQUFUO0FBQ0EsU0FBSyxhQUFMLENBQW1CLFNBQW5CLENBQTZCLEVBQTdCLElBQW1DO0FBQ2xDLFNBQUksRUFEOEIsRUFDMUIsWUFBWSxXQURjLEVBQ0QsaUJBQWlCLGVBRGhCLEVBQ2lDLGdCQUFnQixDQURqRCxFQUNvRCxJQUFJLENBRHhELEVBQzJELElBQUk7QUFEL0QsS0FBbkM7O0FBSUE7QUFDQSxRQUFJLFdBQVcsQ0FBWCxFQUFjLFVBQWQsS0FBNkIsQ0FBakMsRUFBb0M7QUFDbkMsU0FBSSxXQUFXLENBQVgsRUFBYyxVQUFkLEdBQTJCLENBQTNCLElBQWdDLFdBQVcsVUFBWCxHQUF3QixDQUE1RCxFQUErRDtBQUM5RCxVQUFJLGNBQWMsV0FBVyxtQkFBWCxDQUErQixDQUEvQixFQUFrQyxDQUFsQyxFQUFxQyxDQUFyQyxFQUF3QyxHQUF4QyxDQUFsQjtBQUNBLGNBQVEsSUFBUixDQUFhLFdBQWI7O0FBRUE7QUFDQTtBQUNBOztBQUVBLFVBQUksY0FBYyxnQ0FBb0IsRUFBcEIsQ0FBbEI7O0FBRUEsVUFBSSx3QkFBSixFQUF1QjtBQUN0QixlQUFRLElBQVIsQ0FBYTtBQUNaLFdBQUcsQ0FEUyxFQUNOLEdBQUcsQ0FERyxFQUNBLEtBQUssUUFETDtBQUVaLGNBQU0sWUFBWSxJQUZOO0FBR1osY0FBTSxZQUFZLElBSE47QUFJWixlQUFPLFdBSks7QUFLWixxQkFBYSxXQUxEO0FBTVoseUJBQWlCLFlBQVk7QUFOakIsUUFBYjtBQVFBO0FBQ0Q7QUFDRDs7QUFFRCxRQUFJLFdBQVcsQ0FBWCxFQUFjLFVBQWQsSUFBNEIsV0FBVyxVQUF2QyxJQUFxRCxXQUFXLENBQVgsRUFBYyxtQkFBbkUsSUFBMEYsV0FBVyxtQkFBekcsRUFBOEg7O0FBRTdILFVBQUssWUFBTCxDQUFrQixJQUFsQixDQUF1QjtBQUN0QixpQkFBVyxNQURXO0FBRXRCLGlCQUFXLFdBQVcsQ0FBWCxDQUZXO0FBR3RCLGtCQUFZLFVBSFU7QUFJdEIsYUFBTztBQUNOLFVBQUcsQ0FERyxFQUNBLEdBQUc7QUFESCxPQUplO0FBT3RCLGlCQUFXLFdBQVcsQ0FBWCxFQUFjLENBQWQsSUFBbUIsQ0FBbkIsR0FBdUIsQ0FBdkIsR0FBMkIsQ0FBQyxDQVBqQjtBQVF0QixhQUFPO0FBUmUsTUFBdkI7QUFXQTtBQUNEOztBQUVEOztBQUVBO0FBQ0Esb0JBQWEsV0FBYixDQUF5QixPQUF6QjtBQUNBO0FBQ0Q7O0FBRUQsS0FBSSxPQUFKO0FBQ0EsS0FBSSx3QkFBSixFQUNDLEtBQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixPQUE1Qjs7QUFFRCxVQUFTLFNBQVQsR0FBcUI7O0FBRXBCLE1BQUksQ0FBQyxVQUFMLEVBQ0M7O0FBRUQsTUFBSSxXQUFXLGFBQVgsR0FBMkIsQ0FBL0IsRUFDQyxJQUFJLE1BQUo7O0FBRUQsTUFBSSxTQUFTLEtBQVQsQ0FBZSxlQUFmLElBQWtDLENBQWxDLElBQXVDLFNBQVMsS0FBVCxDQUFlLGVBQWYsSUFBa0MsQ0FBN0UsRUFBZ0Y7QUFDL0UsV0FBUSxZQUFSO0FBQ0EsR0FGRCxNQUdLLElBQUksU0FBUyxLQUFULENBQWUsZUFBZixHQUFpQyxDQUFyQyxFQUNKLFFBQVEsV0FBVyxFQUFuQixDQURJLEtBRUEsSUFBSSxTQUFTLEtBQVQsQ0FBZSxlQUFmLEdBQWlDLENBQXJDLEVBQ0osUUFBUSxXQUFXLEVBQW5COztBQUVELE1BQUksTUFBSixDQUFXLENBQVgsRUFBYyxLQUFkO0FBQ0EsTUFBSSxNQUFKLENBQVcsV0FBVyxDQUF0QixFQUF5QixLQUF6QjtBQUNBLE1BQUksU0FBSjs7QUFFQSxNQUFJLFdBQUosR0FBa0IsV0FBVyxXQUE3QjtBQUNBLE1BQUksSUFBSjtBQUNBLE1BQUksV0FBSixHQUFrQixDQUFsQjs7QUFFQSxNQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLFlBQVMsTUFBVCxDQUFnQixDQUFoQixFQUFtQixLQUFuQjtBQUNBLFlBQVMsTUFBVCxDQUFnQixXQUFXLENBQTNCLEVBQThCLEtBQTlCO0FBQ0EsWUFBUyxTQUFUO0FBQ0EsWUFBUyxJQUFUO0FBQ0E7O0FBRUQsTUFBSSxTQUFKO0FBQ0EsTUFBSSxNQUFKLENBQVcsQ0FBWCxFQUFjLENBQWQ7QUFDQSxXQUFTLFNBQVQ7QUFDQSxXQUFTLE1BQVQsQ0FBZ0IsQ0FBaEIsRUFBbUIsQ0FBbkI7O0FBRUEsZUFBYTtBQUNaLE1BQUcsQ0FEUyxFQUNOLEdBQUc7QUFERyxHQUFiO0FBR0E7O0FBRUQ7QUFDQSxLQUFJLGdCQUFnQjtBQUNuQixVQUFRLEdBRFcsRUFDTixNQUFNLEtBQUssUUFBTCxDQUFjLEdBRGQsRUFDbUIsbUJBQW1CLG1CQUFnQixjQUR0RCxFQUNzRSxnQkFBZ0IsbUJBQWdCLE1BQWhCLENBQXVCLE1BRDdHLEVBQ3FILGVBQWU7QUFEcEksRUFBcEI7QUFHQSxRQUFPLGFBQVA7QUFDQSxDOztBQWpPRDs7OztBQUNBOzs7O0FBQ0E7Ozs7Ozs7Ozs7O2tCQ0NlLFVBQVUsUUFBVixFQUFvQjtBQUNsQyxLQUFJLE1BQU0sU0FBUyxlQUFULElBQTRCLEtBQUssUUFBTCxDQUFjLEdBQXBEO0FBQ0EsS0FBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixNQUFqRDs7QUFFQSxLQUFJLG1CQUFtQixDQUF2QixFQUNDOztBQUVELEtBQUksUUFBUSxJQUFaOztBQUVBLEtBQUksV0FBVyxLQUFLLFFBQXBCOztBQUVBLEtBQUksSUFBSSxDQUFSO0FBQUEsS0FBVyxDQUFYO0FBQUEsS0FBYyxDQUFkO0FBQ0EsS0FBSSxVQUFKLENBWmtDLENBWWxCOztBQUVoQjtBQUNBLEtBQUksZUFBZ0IsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsSUFBSSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUE1RixDQUFqRCxJQUEwSixDQUE3Szs7QUFFQSxLQUFJLGNBQWMsS0FBSyxpQkFBTCxHQUF5QixLQUFLLGlCQUE5QixHQUFrRCxLQUFLLEdBQUwsQ0FBVSxLQUFLLE1BQUwsR0FBYyxHQUF4QixFQUE4QixLQUFLLFFBQUwsQ0FBYyxNQUFkLEdBQXVCLFNBQVMsUUFBVCxDQUFrQixlQUF6QyxHQUEyRCxFQUF6RixLQUFnRyxDQUFwSztBQUNBLEtBQUksV0FBVyxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLE9BQXZDO0FBQ0E7O0FBRUEsS0FBSSxXQUFjLFNBQVMsTUFBVCxHQUFrQixLQUFLLEdBQUwsQ0FBUyxTQUFTLEtBQVQsQ0FBZSxlQUFmLEdBQWlDLFNBQVMsS0FBVCxDQUFlLGVBQXpELENBQW5CLEdBQWdHLEtBQUssR0FBTCxDQUFTLFFBQVQsQ0FBakcsR0FBdUgsU0FBUyxRQUFULENBQWtCLGVBQXpJLEdBQTJKLEVBQTVKLElBQW1LLENBQWxMOztBQUVBLEtBQUksV0FBVyxXQUFmLEVBQ0MsV0FBVyxXQUFYLENBREQsS0FFSyxJQUFJLGFBQWEsUUFBakIsRUFBMkI7QUFDL0IsYUFBVyxjQUFjLFNBQVMsUUFBVCxDQUFrQixlQUFoQyxHQUFrRCxFQUE3RDtBQUNBLEVBRkksTUFFRSxJQUFJLFdBQVcsQ0FBZixFQUNOLFdBQVcsQ0FBWDs7QUFFRCxLQUFJLElBQUo7O0FBRUEsS0FBSSx3QkFBSixFQUNDLEtBQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixJQUE1Qjs7QUFFRCxLQUFJLFNBQUo7QUFDQSxLQUFJLElBQUosQ0FBUyxTQUFTLEVBQWxCLEVBQXNCLFNBQVMsRUFBL0IsRUFBbUMsU0FBUyxLQUE1QyxFQUFtRCxTQUFTLE1BQTVEO0FBQ0EsS0FBSSxJQUFKOztBQUVBLEtBQUksd0JBQUosRUFBdUI7QUFDdEIsT0FBSyxhQUFMLENBQW1CLFFBQW5CLENBQTRCLElBQTVCLENBQWlDLFNBQVMsRUFBMUMsRUFBOEMsU0FBUyxFQUF2RCxFQUEyRCxTQUFTLEtBQXBFLEVBQTJFLFNBQVMsTUFBcEY7QUFDQSxPQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsSUFBNUI7QUFDQTs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0Qjs7QUFFQSxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsZUFBVixDQUFqQjtBQUNBLE1BQUksYUFBYSxXQUFXLFVBQTVCO0FBQ0EsTUFBSSw2QkFBNkIsSUFBakM7O0FBR0E7OztBQUdBLE1BQUksV0FBVyxNQUFYLEdBQW9CLENBQXhCLEVBQTJCO0FBQzFCOztBQUVBLE9BQUksZUFBZ0IsV0FBVyxDQUFaLElBQWtCLFdBQVcsWUFBN0IsR0FBNEMsSUFBNUMsR0FBbUQsS0FBdEU7O0FBRUEsT0FBSSxXQUFKLEdBQWtCLFVBQWxCOztBQUVBLFFBQUssSUFBSSxDQUFULEVBQVksSUFBSSxXQUFXLE1BQTNCLEVBQW1DLEdBQW5DLEVBQXdDOztBQUV2QyxlQUFXLENBQVgsRUFBYyxPQUFkLEdBQXdCLGFBQWEsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixFQUFyQyxHQUFpRSxhQUFhLFdBQVcsQ0FBWCxFQUFjLENBQTVGOztBQUVBLFFBQUksYUFBYSxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLFdBQXJDLElBQW9ELGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUE3RixFQUEwRztBQUN6RztBQUNBOztBQUVELFFBQUksT0FBUSxXQUFXLENBQVgsRUFBYyxDQUF0QixLQUE2QixRQUFqQyxFQUNDOztBQUVEO0FBQ0EsUUFBSyxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQXJHLENBQWhELEdBQWdLLEVBQWpLLElBQXdLLENBQTVLO0FBQ0EsUUFBSyxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxXQUFXLENBQVgsRUFBYyxDQUFkLEdBQWtCLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQTFHLENBQWhELEdBQXFLLEVBQXRLLElBQTZLLENBQWpMOztBQUdBLFFBQUksS0FBTSxJQUFLLFNBQVMsUUFBVCxDQUFrQixlQUFsQixHQUFvQyxRQUFwQyxHQUErQyxDQUFwRCxHQUEwRCxDQUFDLFNBQVMsdUJBQVQsR0FBbUMsQ0FBcEMsSUFBeUMsUUFBcEcsSUFBa0gsQ0FBM0g7QUFDQSxRQUFJLEtBQUssS0FBSyxRQUFMLElBQWlCLENBQTFCO0FBQ0EsUUFBSSxFQUFKO0FBQ0EsUUFBSSxFQUFKOztBQUVBLFFBQUksV0FBVyxDQUFYLEVBQWMsQ0FBZCxJQUFtQixDQUF2QixFQUEwQjtBQUN6QixVQUFLLFlBQUw7QUFDQSxVQUFLLENBQUw7QUFDQSxLQUhELE1BR087QUFDTixVQUFLLENBQUw7QUFDQSxVQUFLLFlBQUw7QUFDQTs7QUFFRDtBQUNBOztBQUVBLFlBQVEsV0FBVyxDQUFYLEVBQWMsS0FBZCxHQUFzQixXQUFXLENBQVgsRUFBYyxLQUFwQyxHQUE0QyxXQUFXLFNBQVgsQ0FBcUIsSUFBSSxXQUFXLFNBQVgsQ0FBcUIsTUFBOUMsQ0FBcEQ7QUFDQTtBQUNBLHlCQUFTLEdBQVQsRUFBYyxFQUFkLEVBQWtCLEVBQWxCLEVBQXNCLEVBQXRCLEVBQTBCLEVBQTFCLEVBQThCLEtBQTlCLEVBQXFDLENBQXJDLEVBQXdDLElBQXhDLEVBQThDLFlBQTlDLEVBQTRELEtBQTVELEVBQW1FLEtBQW5FLEVBQTBFLEtBQTFFLEVBQWlGLFdBQVcsV0FBNUY7O0FBR0EsUUFBSSxLQUFLLFdBQVcsWUFBWCxDQUF3QixDQUF4QixDQUFUO0FBQ0EsU0FBSyxhQUFMLENBQW1CLFNBQW5CLENBQTZCLEVBQTdCLElBQW1DO0FBQ2xDLFNBQUksRUFEOEIsRUFDMUIsWUFBWSxXQURjLEVBQ0QsaUJBQWlCLGVBRGhCLEVBQ2lDLGdCQUFnQixDQURqRCxFQUNvRCxJQUFJLEVBRHhELEVBQzRELElBQUksRUFEaEUsRUFDb0UsSUFBSSxFQUR4RSxFQUM0RSxJQUFJO0FBRGhGLEtBQW5DO0FBR0EsWUFBUSxnQ0FBb0IsRUFBcEIsQ0FBUjs7QUFFQSxRQUFJLHdCQUFKLEVBQ0MscUJBQVMsS0FBSyxhQUFMLENBQW1CLFFBQTVCLEVBQXNDLEVBQXRDLEVBQTBDLEVBQTFDLEVBQThDLEVBQTlDLEVBQWtELEVBQWxELEVBQXNELEtBQXRELEVBQTZELENBQTdELEVBQWdFLElBQWhFLEVBQXNFLEtBQXRFLEVBQTZFLEtBQTdFLEVBQW9GLEtBQXBGLEVBQTJGLEtBQTNGOztBQUVELFFBQUksV0FBVyxDQUFYLEVBQWMsVUFBZCxJQUE0QixXQUFXLFVBQXZDLElBQXFELFdBQVcsQ0FBWCxFQUFjLG1CQUFuRSxJQUEwRixXQUFXLG1CQUF6RyxFQUNDLEtBQUssWUFBTCxDQUFrQixJQUFsQixDQUF1QjtBQUN0QixnQkFBVyxLQURXO0FBRXRCLGdCQUFXLFdBQVcsQ0FBWCxDQUZXO0FBR3RCLGlCQUFZLFVBSFU7QUFJdEIsWUFBTztBQUNOLFNBQUcsV0FBVyxDQUFYLEVBQWMsQ0FBZCxJQUFtQixDQUFuQixHQUF1QixFQUF2QixHQUE0QixFQUR6QixFQUM2QixHQUFHLEtBQUssQ0FBQyxLQUFLLEVBQU4sSUFBWTtBQURqRCxNQUplO0FBT3RCLGdCQUFXLFdBQVcsQ0FBWCxFQUFjLENBQWQsSUFBbUIsQ0FBbkIsR0FBdUIsQ0FBdkIsR0FBMkIsQ0FBQyxDQVBqQjtBQVF0QixhQUFRO0FBQ1AsVUFBSSxLQUFLLEdBQUwsQ0FBUyxFQUFULEVBQWEsRUFBYixDQURHLEVBQ2UsSUFBSSxFQURuQixFQUN1QixJQUFJLEtBQUssR0FBTCxDQUFTLEVBQVQsRUFBYSxFQUFiLENBRDNCLEVBQzZDLElBQUk7QUFEakQsTUFSYztBQVd0QixZQUFPO0FBWGUsS0FBdkI7QUFhRDtBQUNEO0FBQ0Q7O0FBRUQsS0FBSSxPQUFKOztBQUVBLEtBQUksd0JBQUosRUFDQyxLQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsT0FBNUI7O0FBRUQ7QUFDQSxLQUFJLGdCQUFnQixLQUFLLEdBQUwsQ0FBUyxZQUFULEVBQXVCLFNBQVMsS0FBVCxDQUFlLFlBQWYsQ0FBNEIsRUFBbkQsQ0FBcEI7QUFDQSxLQUFJLGdCQUFnQjtBQUNuQixVQUFRLEdBRFcsRUFDTixNQUFNLEtBQUssUUFBTCxDQUFjLEdBRGQsRUFDbUIsbUJBQW1CLG1CQUFnQixlQUR0RCxFQUN1RSxnQkFBZ0IsbUJBQWdCLE1BQWhCLENBQXVCLFlBRDlHLEVBQzRILGVBQWU7QUFEM0ksRUFBcEI7QUFHQSxRQUFPLGFBQVA7QUFDQSxDOztBQTdJRDs7OztBQUNBOzs7Ozs7Ozs7OztrQkNHZSxVQUFVLFFBQVYsRUFBb0I7O0FBRWxDLEtBQUksTUFBTSxTQUFTLGVBQVQsSUFBNEIsS0FBSyxRQUFMLENBQWMsR0FBcEQ7O0FBRUEsS0FBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixNQUFqRDs7QUFFQSxLQUFJLG1CQUFtQixDQUF2QixFQUNDOztBQUVELEtBQUksUUFBUSxJQUFaOztBQUVBLEtBQUksV0FBVyxLQUFLLFFBQXBCOztBQUVBLEtBQUksSUFBSSxDQUFSO0FBQUEsS0FBVyxDQUFYO0FBQUEsS0FBYyxDQUFkO0FBQ0EsS0FBSSxVQUFKLENBZGtDLENBY2xCOztBQUVoQixLQUFJLGVBQWdCLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELElBQUksU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBNUYsQ0FBakQsSUFBMEosQ0FBN0s7O0FBRUEsS0FBSSxjQUFjLEtBQUssaUJBQUwsR0FBeUIsS0FBSyxpQkFBOUIsR0FBa0QsS0FBSyxLQUFMLEdBQWEsR0FBYixJQUFvQixDQUF4RjtBQUNBLEtBQUksV0FBVyxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLE9BQXZDO0FBQ0EsS0FBSSxXQUFjLFNBQVMsS0FBVCxHQUFpQixLQUFLLEdBQUwsQ0FBUyxTQUFTLEtBQVQsQ0FBZSxlQUFmLEdBQWlDLFNBQVMsS0FBVCxDQUFlLGVBQXpELENBQWxCLEdBQStGLEtBQUssR0FBTCxDQUFTLFFBQVQsQ0FBaEcsR0FBc0gsZUFBdEgsR0FBd0ksRUFBekksSUFBZ0osQ0FBL0o7O0FBR0EsS0FBSSxJQUFKOztBQUVBLEtBQUksd0JBQUosRUFDQyxLQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsSUFBNUI7O0FBRUQsS0FBSSxTQUFKO0FBQ0EsS0FBSSxJQUFKLENBQVMsU0FBUyxFQUFsQixFQUFzQixTQUFTLEVBQS9CLEVBQW1DLFNBQVMsS0FBNUMsRUFBbUQsU0FBUyxNQUE1RDtBQUNBLEtBQUksSUFBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLE9BQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixJQUE1QixDQUFpQyxTQUFTLEVBQTFDLEVBQThDLFNBQVMsRUFBdkQsRUFBMkQsU0FBUyxLQUFwRSxFQUEyRSxTQUFTLE1BQXBGO0FBQ0EsT0FBSyxhQUFMLENBQW1CLFFBQW5CLENBQTRCLElBQTVCO0FBQ0E7O0FBRUQsS0FBSSxPQUFPLENBQUMsUUFBWjtBQUNBLEtBQUksT0FBTyxRQUFYOztBQUVBLE1BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxTQUFTLGlCQUFULENBQTJCLE1BQS9DLEVBQXVELEdBQXZELEVBQTREOztBQUUzRCxNQUFJLGtCQUFrQixTQUFTLGlCQUFULENBQTJCLENBQTNCLENBQXRCO0FBQ0EsTUFBSSxhQUFhLEtBQUssSUFBTCxDQUFVLGVBQVYsQ0FBakI7QUFDQSxNQUFJLGFBQWEsV0FBVyxVQUE1QjtBQUNBLE1BQUksSUFBSSxDQUFSOztBQUVBLE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxXQUFXLE1BQS9CLEVBQXVDLEdBQXZDLEVBQTRDOztBQUUzQyxnQkFBYSxXQUFXLENBQVgsRUFBYyxPQUFkLEdBQXdCLGFBQWEsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixFQUFyQyxHQUFpRSxhQUFhLFdBQVcsQ0FBWCxFQUFjLENBQXpHOztBQUVBLE9BQUksYUFBYSxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLFdBQXJDLElBQW9ELGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUE3RixFQUEwRztBQUN6RztBQUNBOztBQUVELE9BQUksT0FBUSxXQUFXLENBQVgsRUFBYyxDQUF0QixLQUE2QixXQUFqQyxFQUE4Qzs7QUFFN0MsUUFBSSxXQUFXLENBQVgsRUFBYyxDQUFsQjs7QUFFQSxRQUFJLElBQUksSUFBUixFQUNDLE9BQU8sQ0FBUDs7QUFFRCxRQUFJLElBQUksSUFBUixFQUNDLE9BQU8sQ0FBUDtBQUNEO0FBQ0Q7QUFDRDs7QUFFRCxLQUFJLFVBQVUsS0FBSyxFQUFMLEdBQVUsQ0FBVixHQUFjLENBQTVCO0FBQ0EsS0FBSSxVQUFVLEtBQUssR0FBTCxDQUFTLEtBQUssR0FBTCxDQUFTLEtBQUssR0FBTCxDQUFTLFNBQVMsTUFBbEIsRUFBMEIsU0FBUyxLQUFuQyxJQUE0QyxHQUE1QyxHQUFrRCxDQUEzRCxFQUE4RCxDQUE5RCxJQUFtRSxLQUFLLEVBQWpGLEVBQXFGLE9BQXJGLENBQWQ7O0FBRUEsTUFBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFNBQVMsaUJBQVQsQ0FBMkIsTUFBL0MsRUFBdUQsR0FBdkQsRUFBNEQ7O0FBRTNELE1BQUksa0JBQWtCLFNBQVMsaUJBQVQsQ0FBMkIsQ0FBM0IsQ0FBdEI7O0FBRUEsTUFBSSxhQUFhLEtBQUssSUFBTCxDQUFVLGVBQVYsQ0FBakI7QUFDQSxNQUFJLGFBQWEsV0FBVyxVQUE1QjtBQUNBLE1BQUksNkJBQTZCLElBQWpDOztBQUVBLE1BQUksV0FBVyxNQUFYLElBQXFCLENBQXpCLEVBQ0MsV0FBVyxXQUFYOztBQUVELE1BQUksV0FBVyxDQUFmLEVBQ0MsV0FBVyxDQUFYLENBREQsS0FFSyxJQUFJLFdBQVcsV0FBZixFQUNKLFdBQVcsV0FBWDs7QUFFRCxNQUFJLFdBQVcsTUFBWCxHQUFvQixDQUF4QixFQUEyQjtBQUMxQjtBQUNBOztBQUVBLE9BQUksV0FBSixHQUFrQixVQUFsQjs7QUFJQSxRQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksV0FBVyxNQUEvQixFQUF1QyxHQUF2QyxFQUE0Qzs7QUFFM0MsaUJBQWEsV0FBVyxDQUFYLEVBQWMsT0FBZCxHQUF3QixhQUFhLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsRUFBckMsR0FBaUUsYUFBYSxXQUFXLENBQVgsRUFBYyxDQUF6Rzs7QUFFQSxRQUFJLGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUFyQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBN0YsRUFBMEc7QUFDekc7QUFDQTs7QUFFRCxRQUFJLE9BQVEsV0FBVyxDQUFYLEVBQWMsQ0FBdEIsS0FBNkIsUUFBakMsRUFDQzs7QUFFRCxRQUFLLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELGFBQWEsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBckcsQ0FBaEQsR0FBZ0ssRUFBakssSUFBd0ssQ0FBNUs7QUFDQSxRQUFLLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELFdBQVcsQ0FBWCxFQUFjLENBQWQsR0FBa0IsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBMUcsQ0FBaEQsR0FBcUssRUFBdEssSUFBNkssQ0FBakw7O0FBRUEsUUFBSSxJQUFJLFdBQVcsQ0FBWCxFQUFjLENBQXRCOztBQUVBLFFBQUksT0FBUSxTQUFTLElBQVYsR0FBa0IsVUFBVSxDQUE1QixHQUFnQyxVQUFVLENBQUMsVUFBVSxPQUFYLEtBQXVCLE9BQU8sSUFBOUIsS0FBdUMsSUFBSSxJQUEzQyxDQUFyRDtBQUNBLFFBQUksU0FBUyxLQUFLLEdBQUwsQ0FBUyxLQUFLLElBQUwsQ0FBVSxPQUFPLEtBQUssRUFBdEIsS0FBNkIsQ0FBdEMsRUFBeUMsQ0FBekMsQ0FBYjs7QUFFQSxRQUFJLGFBQWEsU0FBUyxDQUExQjtBQUNBLFFBQUksY0FBYyxXQUFXLG1CQUFYLENBQStCLENBQS9CLEVBQWtDLEdBQWxDLENBQWxCO0FBQ0EsZ0JBQVksSUFBWixHQUFtQixVQUFuQjs7QUFHQSxRQUFJLFdBQUosR0FBa0IsV0FBVyxXQUE3QjtBQUNBLHFCQUFhLFVBQWIsQ0FBd0IsQ0FBeEIsRUFBMkIsQ0FBM0IsRUFBOEIsR0FBOUIsRUFBbUMsWUFBWSxJQUEvQyxFQUFxRCxZQUFZLElBQWpFLEVBQXVFLFlBQVksS0FBbkYsRUFBMEYsWUFBWSxXQUF0RyxFQUFtSCxZQUFZLGVBQS9IO0FBQ0EsUUFBSSxXQUFKLEdBQWtCLENBQWxCOztBQUVBLFFBQUksS0FBSyxXQUFXLFlBQVgsQ0FBd0IsQ0FBeEIsQ0FBVDtBQUNBLFNBQUssYUFBTCxDQUFtQixTQUFuQixDQUE2QixFQUE3QixJQUFtQztBQUNsQyxTQUFJLEVBRDhCLEVBQzFCLFlBQVksV0FEYyxFQUNELGlCQUFpQixlQURoQixFQUNpQyxnQkFBZ0IsQ0FEakQsRUFDb0QsSUFBSSxDQUR4RCxFQUMyRCxJQUFJLENBRC9ELEVBQ2tFLE1BQU07QUFEeEUsS0FBbkM7QUFHQSxRQUFJLGNBQWMsZ0NBQW9CLEVBQXBCLENBQWxCO0FBQ0E7QUFDQSxRQUFJLHdCQUFKLEVBQ0MsaUJBQWEsVUFBYixDQUF3QixDQUF4QixFQUEyQixDQUEzQixFQUE4QixLQUFLLGFBQUwsQ0FBbUIsUUFBakQsRUFBMkQsWUFBWSxJQUF2RSxFQUE2RSxZQUFZLElBQXpGLEVBQStGLFdBQS9GLEVBQTRHLFdBQTVHLEVBQXlILFlBQVksZUFBckk7O0FBR0QsUUFBSSxXQUFXLENBQVgsRUFBYyxVQUFkLElBQTRCLFdBQVcsVUFBdkMsSUFBcUQsV0FBVyxDQUFYLEVBQWMsbUJBQW5FLElBQTBGLFdBQVcsbUJBQXpHLEVBQThIOztBQUU3SCxVQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUI7QUFDdEIsaUJBQVcsUUFEVztBQUV0QixpQkFBVyxXQUFXLENBQVgsQ0FGVztBQUd0QixrQkFBWSxVQUhVO0FBSXRCLGFBQU87QUFDTixVQUFHLENBREcsRUFDQSxHQUFHO0FBREgsT0FKZTtBQU90QixpQkFBVyxDQVBXO0FBUXRCLGNBQVE7QUFDUCxXQUFJLElBQUksWUFBWSxJQUFaLEdBQW1CLENBRHBCLEVBQ3VCLElBQUksSUFBSSxZQUFZLElBQVosR0FBbUIsQ0FEbEQsRUFDcUQsSUFBSSxJQUFJLFlBQVksSUFBWixHQUFtQixDQURoRixFQUNtRixJQUFJLElBQUksWUFBWSxJQUFaLEdBQW1CO0FBRDlHLE9BUmM7QUFXdEIsYUFBTztBQVhlLE1BQXZCO0FBYUE7QUFDRDtBQUNEO0FBQ0Q7O0FBRUQsS0FBSSxPQUFKOztBQUVBLEtBQUksd0JBQUosRUFDQyxLQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsT0FBNUI7O0FBRUQ7QUFDQSxLQUFJLGdCQUFnQjtBQUNuQixVQUFRLEdBRFcsRUFDTixNQUFNLEtBQUssUUFBTCxDQUFjLEdBRGQsRUFDbUIsbUJBQW1CLG1CQUFnQixlQUR0RCxFQUN1RSxnQkFBZ0IsbUJBQWdCLE1BQWhCLENBQXVCLFVBRDlHLEVBQzBILGVBQWU7QUFEekksRUFBcEI7QUFHQSxRQUFPLGFBQVA7QUFDQSxDOztBQXZLRDs7OztBQUNBOzs7O0FBQ0E7Ozs7Ozs7Ozs7O2tCQ0FlLFVBQVUsUUFBVixFQUFvQjtBQUNsQyxLQUFJLE1BQU0sU0FBUyxlQUFULElBQTRCLEtBQUssUUFBTCxDQUFjLEdBQXBEO0FBQ0EsS0FBSSxXQUFXLEtBQUssYUFBTCxDQUFtQixRQUFsQzs7QUFFQSxLQUFJLGtCQUFrQixTQUFTLGlCQUFULENBQTJCLE1BQWpEO0FBQ0EsS0FBSSxtQkFBbUIsQ0FBdkIsRUFDQzs7QUFFRCxLQUFJLFFBQVEsSUFBWjs7QUFFQSxLQUFJLFdBQVcsS0FBSyxRQUFwQjs7QUFFQSxLQUFJLElBQUksQ0FBUjtBQUFBLEtBQVcsQ0FBWDtBQUFBLEtBQWMsRUFBZDtBQUFBLEtBQWtCLEVBQWxCO0FBQUEsS0FBc0IsRUFBdEI7QUFBQSxLQUEwQixFQUExQjtBQUNBLEtBQUksVUFBSixDQWJrQyxDQWFsQjs7QUFFaEIsS0FBSSxlQUFnQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxJQUFJLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQTVGLENBQWpELElBQTBKLENBQTdLOztBQUVBLEtBQUksY0FBYyxLQUFLLGlCQUFMLEdBQXlCLEtBQUssaUJBQTlCLEdBQW1ELEtBQUssS0FBTCxHQUFhLElBQWxGO0FBQ0EsS0FBSSxXQUFXLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsT0FBdkM7QUFDQSxLQUFJLFdBQWMsU0FBUyxLQUFULEdBQWlCLEtBQUssR0FBTCxDQUFTLFNBQVMsS0FBVCxDQUFlLGVBQWYsR0FBaUMsU0FBUyxLQUFULENBQWUsZUFBekQsQ0FBbEIsR0FBK0YsS0FBSyxHQUFMLENBQVMsUUFBVCxDQUFoRyxHQUFzSCxFQUF2SCxJQUE4SCxDQUE3STs7QUFFQSxLQUFJLFdBQVcsV0FBZixFQUNDLFdBQVcsV0FBWCxDQURELEtBRUssSUFBSSxhQUFhLFFBQWpCLEVBQTJCO0FBQy9CLGFBQVcsV0FBWDtBQUNBLEVBRkksTUFFRSxJQUFJLFdBQVcsQ0FBZixFQUNOLFdBQVcsQ0FBWDs7QUFFRCxLQUFJLElBQUo7QUFDQSxLQUFJLHdCQUFKLEVBQ0MsU0FBUyxJQUFUOztBQUVELEtBQUksU0FBSjtBQUNBLEtBQUksSUFBSixDQUFTLFNBQVMsRUFBbEIsRUFBc0IsU0FBUyxFQUEvQixFQUFtQyxTQUFTLEtBQTVDLEVBQW1ELFNBQVMsTUFBNUQ7QUFDQSxLQUFJLElBQUo7O0FBRUEsS0FBSSx3QkFBSixFQUF1QjtBQUN0QixXQUFTLElBQVQsQ0FBYyxTQUFTLEVBQXZCLEVBQTJCLFNBQVMsRUFBcEMsRUFBd0MsU0FBUyxLQUFqRCxFQUF3RCxTQUFTLE1BQWpFO0FBQ0EsV0FBUyxJQUFUO0FBQ0E7QUFDRDs7QUFFQSxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0Qjs7QUFFQSxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsZUFBVixDQUFqQjtBQUNBLE1BQUksYUFBYSxXQUFXLFVBQTVCO0FBQ0EsTUFBSSw2QkFBNkIsSUFBakM7O0FBR0E7QUFDQTs7QUFFQTs7O0FBR0EsTUFBSSxXQUFXLE1BQVgsR0FBb0IsQ0FBeEIsRUFBMkI7QUFDMUI7O0FBRUEsT0FBSSxlQUFnQixXQUFXLENBQVosSUFBa0IsV0FBVyxZQUE3QixHQUE0QyxJQUE1QyxHQUFtRCxLQUF0RTs7QUFFQSxRQUFLLElBQUksQ0FBVCxFQUFZLElBQUksV0FBVyxNQUEzQixFQUFtQyxHQUFuQyxFQUF3Qzs7QUFFdkMsZUFBVyxDQUFYLEVBQWMsT0FBZCxHQUF3QixhQUFhLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsRUFBckMsR0FBaUUsYUFBYSxXQUFXLENBQVgsRUFBYyxDQUE1Rjs7QUFFQSxRQUFJLGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUFyQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBN0YsRUFBMEc7QUFDekc7QUFDQTs7QUFFRCxRQUFJLFdBQVcsQ0FBWCxFQUFjLENBQWQsS0FBb0IsSUFBcEIsSUFBNEIsQ0FBQyxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLE1BQTdDLElBQ0EsT0FBUSxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLENBQVIsS0FBZ0MsUUFEaEMsSUFDNEMsT0FBUSxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLENBQVIsS0FBZ0MsUUFENUUsSUFFQSxPQUFRLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsQ0FBUixLQUFnQyxRQUZoQyxJQUU0QyxPQUFRLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsQ0FBUixLQUFnQyxRQUZoRixFQUdDOztBQUVELFFBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUFyRyxDQUFoRCxHQUFnSyxFQUFqSyxJQUF3SyxDQUE1SztBQUNBLFNBQU0sU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixJQUFxQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUE3RyxDQUFoRCxHQUF3SyxFQUF6SyxJQUFnTCxDQUFyTDtBQUNBLFNBQU0sU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixJQUFxQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUE3RyxDQUFoRCxHQUF3SyxFQUF6SyxJQUFnTCxDQUFyTDs7QUFFQSxTQUFNLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsSUFBcUIsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBN0csQ0FBaEQsR0FBd0ssRUFBekssSUFBZ0wsQ0FBckw7QUFDQSxTQUFNLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsSUFBcUIsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBN0csQ0FBaEQsR0FBd0ssRUFBekssSUFBZ0wsQ0FBckw7O0FBRUEsUUFBSSxLQUFNLElBQUksV0FBVyxDQUFoQixJQUFzQixDQUEvQjtBQUNBLFFBQUksS0FBTSxLQUFLLFFBQU4sSUFBbUIsQ0FBNUI7O0FBR0EsWUFBUSxXQUFXLENBQVgsRUFBYyxLQUFkLEdBQXNCLFdBQVcsQ0FBWCxFQUFjLEtBQXBDLEdBQTRDLFdBQVcsU0FBWCxDQUFxQixDQUFyQixDQUFwRDs7QUFHQTtBQUNBLFFBQUksa0JBQWtCLEtBQUssS0FBTCxDQUFXLEtBQUssR0FBTCxDQUFTLENBQVQsRUFBYSxXQUFXLEdBQXhCLENBQVgsQ0FBdEI7QUFDQTtBQUNBO0FBQ0EsUUFBSSxTQUFTLGtCQUFrQixDQUFsQixLQUF3QixDQUF4QixHQUE0QixDQUE1QixHQUFnQyxFQUE3Qzs7QUFHQSxRQUFJLEtBQUssV0FBVyxZQUFYLENBQXdCLENBQXhCLENBQVQ7QUFDQSxTQUFLLGFBQUwsQ0FBbUIsU0FBbkIsQ0FBNkIsRUFBN0IsSUFBbUM7QUFDbEMsU0FBSSxFQUQ4QixFQUMxQixZQUFZLFdBRGMsRUFDRCxpQkFBaUIsZUFEaEIsRUFDaUMsZ0JBQWdCLENBRGpELEVBQ29ELElBQUksRUFEeEQsRUFDNEQsSUFBSSxFQURoRSxFQUNvRSxJQUFJLEVBRHhFLEVBQzRFLElBQUksRUFEaEY7QUFFbEMsU0FBSSxDQUY4QixFQUUzQixJQUFJLEVBRnVCLEVBRW5CLElBQUksQ0FGZSxFQUVaLElBQUksRUFGUSxFQUVKLGlCQUFpQixlQUZiLEVBRThCLE9BQU87QUFGckMsS0FBbkM7O0FBS0EsUUFBSSxXQUFKLEdBQWtCLEtBQWxCO0FBQ0EsUUFBSSxTQUFKO0FBQ0EsUUFBSSxTQUFKLEdBQWdCLGVBQWhCO0FBQ0EsYUFBUyxTQUFULEdBQXFCLEtBQUssR0FBTCxDQUFTLGVBQVQsRUFBMEIsQ0FBMUIsQ0FBckI7O0FBRUEsUUFBSSxXQUFXLElBQVgsS0FBb0IsYUFBeEIsRUFBdUM7O0FBRXRDLFNBQUksTUFBSixDQUFXLElBQUksTUFBZixFQUF1QixFQUF2QjtBQUNBLFNBQUksTUFBSixDQUFXLElBQUksTUFBZixFQUF1QixLQUFLLEdBQUwsQ0FBUyxFQUFULEVBQWEsRUFBYixDQUF2QjtBQUNBLFNBQUksTUFBSjtBQUNBLFNBQUksTUFBSixDQUFXLElBQUksTUFBZixFQUF1QixLQUFLLEdBQUwsQ0FBUyxFQUFULEVBQWEsRUFBYixDQUF2QjtBQUNBLFNBQUksTUFBSixDQUFXLElBQUksTUFBZixFQUF1QixFQUF2QjtBQUNBLFNBQUksTUFBSjs7QUFFQSxjQUFTLEdBQVQsRUFBYyxFQUFkLEVBQWtCLEtBQUssR0FBTCxDQUFTLEVBQVQsRUFBYSxFQUFiLENBQWxCLEVBQW9DLEVBQXBDLEVBQXdDLEtBQUssR0FBTCxDQUFTLEVBQVQsRUFBYSxFQUFiLENBQXhDLEVBQTBELFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsS0FBc0IsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixDQUF0QixHQUEyQyxXQUFXLFdBQXRELEdBQW9FLEtBQTlILEVBQXFJLGVBQXJJLEVBQXNKLEtBQXRKLEVBQTZKLFlBQTdKLEVBQTJLLFlBQTNLLEVBQXlMLEtBQXpMLEVBQWdNLEtBQWhNLEVBQXVNLFdBQVcsV0FBbE47O0FBR0EsU0FBSSx3QkFBSixFQUF1QjtBQUN0QixjQUFRLG9CQUFvQixFQUFwQixDQUFSO0FBQ0EsZUFBUyxXQUFULEdBQXVCLEtBQXZCOztBQUVBLGVBQVMsTUFBVCxDQUFnQixJQUFJLE1BQXBCLEVBQTRCLEVBQTVCO0FBQ0EsZUFBUyxNQUFULENBQWdCLElBQUksTUFBcEIsRUFBNEIsS0FBSyxHQUFMLENBQVMsRUFBVCxFQUFhLEVBQWIsQ0FBNUI7QUFDQSxlQUFTLE1BQVQ7QUFDQSxlQUFTLE1BQVQsQ0FBZ0IsSUFBSSxNQUFwQixFQUE0QixLQUFLLEdBQUwsQ0FBUyxFQUFULEVBQWEsRUFBYixDQUE1QjtBQUNBLGVBQVMsTUFBVCxDQUFnQixJQUFJLE1BQXBCLEVBQTRCLEVBQTVCO0FBQ0EsZUFBUyxNQUFUO0FBQ0EsZUFBUyxRQUFULEVBQW1CLEVBQW5CLEVBQXVCLEtBQUssR0FBTCxDQUFTLEVBQVQsRUFBYSxFQUFiLENBQXZCLEVBQXlDLEVBQXpDLEVBQTZDLEtBQUssR0FBTCxDQUFTLEVBQVQsRUFBYSxFQUFiLENBQTdDLEVBQStELEtBQS9ELEVBQXNFLENBQXRFLEVBQXlFLElBQXpFLEVBQStFLEtBQS9FLEVBQXNGLEtBQXRGLEVBQTZGLEtBQTdGLEVBQW9HLEtBQXBHO0FBQ0E7QUFDRCxLQXhCRCxNQXlCSyxJQUFJLFdBQVcsSUFBWCxLQUFvQixNQUF4QixFQUFnQzs7QUFFcEMsU0FBSSxNQUFKLENBQVcsSUFBSSxNQUFmLEVBQXVCLEVBQXZCO0FBQ0EsU0FBSSxNQUFKLENBQVcsSUFBSSxNQUFmLEVBQXVCLEVBQXZCO0FBQ0EsU0FBSSxNQUFKOztBQUVBLFNBQUksU0FBSjtBQUNBLFNBQUksTUFBSixDQUFXLENBQVgsRUFBYyxFQUFkO0FBQ0EsU0FBSSxNQUFKLENBQVcsRUFBWCxFQUFlLEVBQWY7QUFDQSxTQUFJLE1BQUo7O0FBRUEsU0FBSSxTQUFKO0FBQ0EsU0FBSSxNQUFKLENBQVcsQ0FBWCxFQUFjLEVBQWQ7QUFDQSxTQUFJLE1BQUosQ0FBVyxFQUFYLEVBQWUsRUFBZjtBQUNBLFNBQUksTUFBSjs7QUFFQSxTQUFJLHdCQUFKLEVBQXVCOztBQUV0QixjQUFRLG9CQUFvQixFQUFwQixDQUFSO0FBQ0EsZUFBUyxXQUFULEdBQXVCLEtBQXZCOztBQUVBLGVBQVMsTUFBVCxDQUFnQixJQUFJLE1BQXBCLEVBQTRCLEVBQTVCO0FBQ0EsZUFBUyxNQUFULENBQWdCLElBQUksTUFBcEIsRUFBNEIsRUFBNUI7QUFDQSxlQUFTLE1BQVQ7O0FBRUEsZUFBUyxTQUFUO0FBQ0EsZUFBUyxNQUFULENBQWdCLENBQWhCLEVBQW1CLEVBQW5CO0FBQ0EsZUFBUyxNQUFULENBQWdCLEVBQWhCLEVBQW9CLEVBQXBCO0FBQ0EsZUFBUyxNQUFUOztBQUVBLGVBQVMsU0FBVDtBQUNBLGVBQVMsTUFBVCxDQUFnQixDQUFoQixFQUFtQixFQUFuQjtBQUNBLGVBQVMsTUFBVCxDQUFnQixFQUFoQixFQUFvQixFQUFwQjtBQUNBLGVBQVMsTUFBVDtBQUNBO0FBQ0Q7O0FBRUQsUUFBSSxXQUFXLENBQVgsRUFBYyxVQUFkLElBQTRCLFdBQVcsVUFBdkMsSUFBcUQsV0FBVyxDQUFYLEVBQWMsbUJBQW5FLElBQTBGLFdBQVcsbUJBQXpHLEVBQThIOztBQUU3SCxVQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUI7QUFDdEIsaUJBQVcsV0FBVyxJQURBO0FBRXRCLGlCQUFXLFdBQVcsQ0FBWCxDQUZXO0FBR3RCLGtCQUFZLFVBSFU7QUFJdEIsYUFBTztBQUNOLFVBQUcsS0FBSyxDQUFDLEtBQUssRUFBTixJQUFZLENBRGQsRUFDaUIsR0FBRztBQURwQixPQUplO0FBT3RCLGlCQUFXLENBUFc7QUFRdEIsY0FBUTtBQUNQLFdBQUksRUFERyxFQUNDLElBQUksS0FBSyxHQUFMLENBQVMsRUFBVCxFQUFhLEVBQWIsQ0FETCxFQUN1QixJQUFJLEVBRDNCLEVBQytCLElBQUksS0FBSyxHQUFMLENBQVMsRUFBVCxFQUFhLEVBQWI7QUFEbkMsT0FSYztBQVd0QixhQUFPO0FBWGUsTUFBdkI7QUFjQTtBQUNEO0FBQ0Q7QUFDRDs7QUFFRCxLQUFJLE9BQUo7O0FBRUEsS0FBSSx3QkFBSixFQUNDLFNBQVMsT0FBVDs7QUFFRDtBQUNBLEtBQUksZ0JBQWdCO0FBQ25CLFVBQVEsR0FEVyxFQUNOLE1BQU0sS0FBSyxRQUFMLENBQWMsR0FEZCxFQUNtQixtQkFBbUIsZ0JBQWdCLGVBRHRELEVBQ3VFLGdCQUFnQixnQkFBZ0IsTUFBaEIsQ0FBdUIsVUFEOUcsRUFDMEgsZUFBZTtBQUR6SSxFQUFwQjtBQUdBLFFBQU8sYUFBUDtBQUNBLEM7O0FBMU1EOzs7Ozs7Ozs7a0JDR2UsVUFBVSxRQUFWLEVBQW9COztBQUVsQyxLQUFJLE1BQU0sU0FBUyxlQUFULElBQTRCLEtBQUssUUFBTCxDQUFjLEdBQXBEOztBQUVBLEtBQUksa0JBQWtCLFNBQVMsaUJBQVQsQ0FBMkIsTUFBakQ7O0FBRUEsS0FBSSxtQkFBbUIsQ0FBdkIsRUFDQzs7QUFFRCxLQUFJLFFBQVEsSUFBWjs7QUFFQSxLQUFJLFdBQVcsS0FBSyxRQUFwQjs7QUFFQSxLQUFJLElBQUksQ0FBUjtBQUFBLEtBQVcsQ0FBWDtBQUFBLEtBQWMsQ0FBZDtBQUNBLEtBQUksVUFBSixDQWRrQyxDQWNsQjs7QUFFaEIsS0FBSSxlQUFnQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxJQUFJLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQTVGLENBQWpELElBQTBKLENBQTdLOztBQUVBLEtBQUksY0FBYyxLQUFLLGlCQUFMLEdBQXlCLEtBQUssaUJBQTlCLEdBQWtELEtBQUssR0FBTCxDQUFVLEtBQUssS0FBTCxHQUFhLEdBQXZCLEVBQTZCLEtBQUssUUFBTCxDQUFjLEtBQWQsR0FBc0IsU0FBUyxRQUFULENBQWtCLGVBQXhDLEdBQTBELEVBQXZGLEtBQThGLENBQWxLO0FBQ0EsS0FBSSxXQUFXLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsT0FBdkM7QUFDQSxLQUFJLFdBQWMsU0FBUyxLQUFULEdBQWlCLEtBQUssR0FBTCxDQUFTLFNBQVMsS0FBVCxDQUFlLGVBQWYsR0FBaUMsU0FBUyxLQUFULENBQWUsZUFBekQsQ0FBbEIsR0FBK0YsS0FBSyxHQUFMLENBQVMsUUFBVCxDQUFoRyxHQUFzSCxTQUFTLFFBQVQsQ0FBa0IsZUFBeEksR0FBMEosRUFBM0osSUFBa0ssQ0FBakw7O0FBRUEsS0FBSSxXQUFXLFdBQWYsRUFDQyxXQUFXLFdBQVgsQ0FERCxLQUVLLElBQUksYUFBYSxRQUFqQixFQUEyQjtBQUMvQixhQUFXLGNBQWMsU0FBUyxRQUFULENBQWtCLGVBQWhDLEdBQWtELEVBQTdEO0FBQ0EsRUFGSSxNQUVFLElBQUksV0FBVyxDQUFmLEVBQ04sV0FBVyxDQUFYOztBQUVELEtBQUksSUFBSjtBQUNBLEtBQUksd0JBQUosRUFDQyxLQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsSUFBNUI7O0FBRUQsS0FBSSxTQUFKO0FBQ0EsS0FBSSxJQUFKLENBQVMsU0FBUyxFQUFsQixFQUFzQixTQUFTLEVBQS9CLEVBQW1DLFNBQVMsS0FBNUMsRUFBbUQsU0FBUyxNQUE1RDtBQUNBLEtBQUksSUFBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLE9BQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixJQUE1QixDQUFpQyxTQUFTLEVBQTFDLEVBQThDLFNBQVMsRUFBdkQsRUFBMkQsU0FBUyxLQUFwRSxFQUEyRSxTQUFTLE1BQXBGO0FBQ0EsT0FBSyxhQUFMLENBQW1CLFFBQW5CLENBQTRCLElBQTVCO0FBQ0E7QUFDRDs7QUFFQSxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0Qjs7QUFFQSxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsZUFBVixDQUFqQjtBQUNBLE1BQUksYUFBYSxXQUFXLFVBQTVCO0FBQ0EsTUFBSSw2QkFBNkIsSUFBakM7O0FBR0E7QUFDQTs7QUFFQTs7O0FBR0EsTUFBSSxXQUFXLE1BQVgsR0FBb0IsQ0FBeEIsRUFBMkI7QUFDMUI7O0FBRUEsT0FBSSxlQUFnQixXQUFXLENBQVosSUFBa0IsV0FBVyxZQUE3QixHQUE0QyxJQUE1QyxHQUFtRCxLQUF0RTs7QUFFQSxRQUFLLElBQUksQ0FBVCxFQUFZLElBQUksV0FBVyxNQUEzQixFQUFtQyxHQUFuQyxFQUF3Qzs7QUFFdkMsZUFBVyxDQUFYLEVBQWMsT0FBZCxHQUF3QixhQUFhLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsRUFBckMsR0FBaUUsYUFBYSxXQUFXLENBQVgsRUFBYyxDQUE1Rjs7QUFFQSxRQUFJLGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUFyQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBN0YsRUFBMEc7QUFDekc7QUFDQTs7QUFFRCxRQUFJLE9BQVEsV0FBVyxDQUFYLEVBQWMsQ0FBdEIsS0FBNkIsUUFBakMsRUFDQzs7QUFFRCxRQUFLLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELGFBQWEsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBckcsQ0FBaEQsR0FBZ0ssRUFBakssSUFBd0ssQ0FBNUs7QUFDQSxRQUFLLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELFdBQVcsQ0FBWCxFQUFjLENBQWQsR0FBa0IsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBMUcsQ0FBaEQsR0FBcUssRUFBdEssSUFBNkssQ0FBakw7O0FBRUEsUUFBSSxLQUFLLElBQUssU0FBUyxRQUFULENBQWtCLGVBQWxCLEdBQW9DLFFBQXBDLEdBQStDLENBQXBELEdBQTBELENBQUMsU0FBUyx1QkFBVCxHQUFtQyxDQUFwQyxJQUF5QyxRQUFuRyxJQUFnSCxDQUF6SDtBQUNBLFFBQUksS0FBSyxLQUFLLFFBQUwsSUFBaUIsQ0FBMUI7QUFDQSxRQUFJLEVBQUo7QUFDQSxRQUFJLEVBQUo7O0FBRUEsUUFBSSxXQUFXLENBQVgsRUFBYyxDQUFkLElBQW1CLENBQXZCLEVBQTBCO0FBQ3pCLFVBQUssQ0FBTDs7QUFFQSxVQUFLLFlBQUw7O0FBRUEsU0FBSSxLQUFLLEVBQVQsRUFBYTtBQUNaLFVBQUksT0FBTyxFQUFYO0FBQ0EsV0FBSyxFQUFMO0FBQ0EsV0FBSyxFQUFMO0FBQ0E7QUFFRCxLQVhELE1BV087QUFDTixVQUFLLENBQUw7O0FBRUEsVUFBSyxZQUFMOztBQUVBLFNBQUksS0FBSyxFQUFULEVBQWE7QUFDWixVQUFJLE9BQU8sRUFBWDtBQUNBLFdBQUssRUFBTDtBQUNBLFdBQUssRUFBTDtBQUNBO0FBQ0Q7O0FBRUQsWUFBUSxXQUFXLENBQVgsRUFBYyxLQUFkLEdBQXNCLFdBQVcsQ0FBWCxFQUFjLEtBQXBDLEdBQTRDLFdBQVcsU0FBWCxDQUFxQixJQUFJLFdBQVcsU0FBWCxDQUFxQixNQUE5QyxDQUFwRDtBQUNBLHlCQUFTLEdBQVQsRUFBYyxFQUFkLEVBQWtCLEVBQWxCLEVBQXNCLEVBQXRCLEVBQTBCLEVBQTFCLEVBQThCLEtBQTlCLEVBQXFDLENBQXJDLEVBQXdDLElBQXhDLEVBQThDLGdCQUFpQixXQUFXLENBQVgsRUFBYyxDQUFkLElBQW1CLENBQWxGLEVBQXVGLFdBQVcsQ0FBWCxFQUFjLENBQWQsR0FBa0IsQ0FBbkIsSUFBeUIsWUFBL0csRUFBNkgsS0FBN0gsRUFBb0ksS0FBcEksRUFBMkksV0FBVyxXQUF0Sjs7QUFFQTtBQUNBO0FBQ0E7O0FBRUEsUUFBSSxLQUFLLFdBQVcsWUFBWCxDQUF3QixDQUF4QixDQUFUO0FBQ0EsU0FBSyxhQUFMLENBQW1CLFNBQW5CLENBQTZCLEVBQTdCLElBQW1DO0FBQ2xDLFNBQUksRUFEOEIsRUFDMUIsWUFBWSxXQURjLEVBQ0QsaUJBQWlCLGVBRGhCLEVBQ2lDLGdCQUFnQixDQURqRCxFQUNvRCxJQUFJLEVBRHhELEVBQzRELElBQUksRUFEaEUsRUFDb0UsSUFBSSxFQUR4RSxFQUM0RSxJQUFJO0FBRGhGLEtBQW5DOztBQUlBLFlBQVEsZ0NBQW9CLEVBQXBCLENBQVI7QUFDQSxRQUFJLHdCQUFKLEVBQ0MscUJBQVMsS0FBSyxhQUFMLENBQW1CLFFBQTVCLEVBQXNDLEVBQXRDLEVBQTBDLEVBQTFDLEVBQThDLEVBQTlDLEVBQWtELEVBQWxELEVBQXNELEtBQXRELEVBQTZELENBQTdELEVBQWdFLElBQWhFLEVBQXNFLEtBQXRFLEVBQTZFLEtBQTdFLEVBQW9GLEtBQXBGLEVBQTJGLEtBQTNGOztBQUVELFFBQUksV0FBVyxDQUFYLEVBQWMsVUFBZCxJQUE0QixXQUFXLFVBQXZDLElBQXFELFdBQVcsQ0FBWCxFQUFjLG1CQUFuRSxJQUEwRixXQUFXLG1CQUF6RyxFQUE4SDs7QUFFN0gsVUFBSyxZQUFMLENBQWtCLElBQWxCLENBQXVCO0FBQ3RCLGlCQUFXLFFBRFc7QUFFdEIsaUJBQVcsV0FBVyxDQUFYLENBRlc7QUFHdEIsa0JBQVksVUFIVTtBQUl0QixhQUFPO0FBQ04sVUFBRyxLQUFLLENBQUMsS0FBSyxFQUFOLElBQVksQ0FEZCxFQUNpQixHQUFHLFdBQVcsQ0FBWCxFQUFjLENBQWQsSUFBbUIsQ0FBbkIsR0FBdUIsRUFBdkIsR0FBNEI7QUFEaEQsT0FKZTtBQU90QixpQkFBVyxXQUFXLENBQVgsRUFBYyxDQUFkLElBQW1CLENBQW5CLEdBQXVCLENBQXZCLEdBQTJCLENBQUMsQ0FQakI7QUFRdEIsY0FBUTtBQUNQLFdBQUksRUFERyxFQUNDLElBQUksS0FBSyxHQUFMLENBQVMsRUFBVCxFQUFhLEVBQWIsQ0FETCxFQUN1QixJQUFJLEVBRDNCLEVBQytCLElBQUksS0FBSyxHQUFMLENBQVMsRUFBVCxFQUFhLEVBQWI7QUFEbkMsT0FSYztBQVd0QixhQUFPO0FBWGUsTUFBdkI7QUFjQTtBQUNEO0FBQ0Q7QUFDRDs7QUFFRCxLQUFJLE9BQUo7O0FBRUEsS0FBSSx3QkFBSixFQUNDLEtBQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixPQUE1Qjs7QUFFRDtBQUNBLEtBQUksZ0JBQWdCLEtBQUssR0FBTCxDQUFTLFlBQVQsRUFBdUIsU0FBUyxLQUFULENBQWUsWUFBZixDQUE0QixFQUFuRCxDQUFwQjtBQUNBLEtBQUksZ0JBQWdCO0FBQ25CLFVBQVEsR0FEVyxFQUNOLE1BQU0sS0FBSyxRQUFMLENBQWMsR0FEZCxFQUNtQixtQkFBbUIsbUJBQWdCLGVBRHRELEVBQ3VFLGdCQUFnQixtQkFBZ0IsTUFBaEIsQ0FBdUIsWUFEOUcsRUFDNEgsZUFBZTtBQUQzSSxFQUFwQjtBQUdBLFFBQU8sYUFBUDtBQUNBLEM7O0FBNUpEOzs7O0FBQ0E7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7UUNGTyxXO1FBQ0EsVztRQUNBLGtCO1FBQ0EscUI7UUFDQSxRO1FBQ0EsZTtRQUNBLGtCO1FBQ0EsUztRQUNBLGU7UUFDQSxhO1FBQ0EsZ0I7UUFDQSxtQjtRQUNBLFc7UUFDQSxZO1FBQ0EsZ0I7UUFDQSxnQjtRQUNBLGE7UUFDQSxjO1FBQ0Esb0I7UUFDQSxROzs7Ozs7Ozs7a0JDZlEsVUFBVSxRQUFWLEVBQW9COztBQUVsQyxLQUFJLFFBQVEsSUFBWjtBQUNBLEtBQUksa0JBQWtCLFNBQVMsaUJBQVQsQ0FBMkIsTUFBakQ7O0FBRUEsS0FBSSxtQkFBbUIsQ0FBdkIsRUFDQzs7QUFFRCxLQUFJLGtCQUFrQixTQUFTLGlCQUFULENBQTJCLENBQTNCLENBQXRCO0FBQ0EsS0FBSSxhQUFhLEtBQUssSUFBTCxDQUFVLGVBQVYsQ0FBakI7QUFDQSxLQUFJLGFBQWEsV0FBVyxVQUE1QjtBQUNBLEtBQUksMkJBQTJCLEVBQS9CO0FBQ0EsS0FBSSxrQkFBa0IsR0FBdEI7O0FBRUEsS0FBSSxXQUFXLEtBQUssUUFBcEI7O0FBRUE7QUFDQTtBQUNBLEtBQUksZUFBZSxFQUFuQixDQWxCa0MsQ0FrQlg7O0FBRXZCLEtBQUksMkJBQTJCLENBQS9CO0FBQ0EsS0FBSSxnQ0FBZ0MsR0FBcEM7QUFDQSxLQUFJLHVCQUF3QixLQUFLLEdBQU4sR0FBYSxLQUFLLEVBQTdDLENBdEJrQyxDQXNCZTtBQUNqRCxLQUFJLFlBQVksQ0FBaEI7O0FBRUEsS0FBSSxTQUFTO0FBQ1osS0FBRyxDQUFDLFNBQVMsRUFBVCxHQUFjLFNBQVMsRUFBeEIsSUFBOEIsQ0FEckIsRUFDd0IsR0FBRyxDQUFDLFNBQVMsRUFBVCxHQUFjLFNBQVMsRUFBeEIsSUFBOEI7QUFEekQsRUFBYjs7QUFJQSxLQUFJLE1BQU0sQ0FBVjtBQUNBLEtBQUksc0JBQXNCLEtBQTFCO0FBQ0EsTUFBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFdBQVcsTUFBL0IsRUFBdUMsR0FBdkMsRUFBNEM7QUFDM0MsU0FBTyxLQUFLLEdBQUwsQ0FBUyxXQUFXLENBQVgsRUFBYyxDQUF2QixDQUFQOztBQUVBLE1BQUksQ0FBQyxtQkFBRCxJQUF3QixPQUFRLFdBQVcsQ0FBWCxFQUFjLFVBQXRCLEtBQXNDLFdBQTlELElBQTZFLFdBQVcsQ0FBWCxFQUFjLFVBQWQsS0FBNkIsSUFBMUcsSUFBa0gsV0FBVyxDQUFYLEVBQWMsVUFBZCxDQUF5QixRQUF6QixHQUFvQyxNQUFwQyxHQUE2QyxDQUFuSyxFQUNDLHNCQUFzQixJQUF0Qjs7QUFFRCxNQUFJLENBQUMsbUJBQUQsSUFBd0IsT0FBUSxXQUFXLENBQVgsRUFBYyxLQUF0QixLQUFpQyxXQUF6RCxJQUF3RSxXQUFXLENBQVgsRUFBYyxLQUFkLEtBQXdCLElBQWhHLElBQXdHLFdBQVcsQ0FBWCxFQUFjLEtBQWQsQ0FBb0IsUUFBcEIsR0FBK0IsTUFBL0IsR0FBd0MsQ0FBcEosRUFDQyxzQkFBc0IsSUFBdEI7QUFDRDs7QUFFRCxLQUFJLFFBQVEsQ0FBWixFQUNDOztBQUVELHVCQUFzQix1QkFBd0IsT0FBUSxXQUFXLFVBQW5CLEtBQW1DLFdBQW5DLElBQWtELFdBQVcsVUFBWCxLQUEwQixJQUE1RSxJQUFvRixXQUFXLFVBQVgsQ0FBc0IsUUFBdEIsR0FBaUMsTUFBakMsR0FBMEMsQ0FBNUs7O0FBRUEsS0FBSSxjQUFjLFdBQVcsbUJBQVgsS0FBbUMsUUFBbkMsSUFBK0MsbUJBQS9DLEdBQXNFLEtBQUssR0FBTCxDQUFTLFNBQVMsS0FBbEIsRUFBeUIsU0FBUyxNQUFsQyxJQUE0QyxJQUE3QyxHQUFxRCxDQUExSCxHQUErSCxLQUFLLEdBQUwsQ0FBUyxTQUFTLEtBQWxCLEVBQXlCLFNBQVMsTUFBbEMsSUFBNEMsR0FBN0MsR0FBb0QsQ0FBcE07O0FBRUEsS0FBSSxXQUFXLE1BQWYsRUFDQyxjQUFjLGtDQUFzQixXQUFXLE1BQWpDLEVBQXlDLFdBQXpDLENBQWQ7O0FBR0QsS0FBSSxjQUFlLE9BQU8sV0FBVyxXQUFsQixLQUFrQyxXQUFsQyxJQUFpRCxXQUFXLFdBQVgsS0FBMkIsSUFBN0UsR0FBcUYsa0NBQXNCLFdBQVcsV0FBakMsRUFBOEMsV0FBOUMsQ0FBckYsR0FBa0osTUFBTSxXQUExSzs7QUFFQSxLQUFJLHFCQUFxQixLQUFLLEdBQUwsQ0FBUyxjQUFjLFdBQXZCLEVBQW9DLENBQUMsY0FBYyxDQUFmLElBQW9CLFdBQXhELENBQXpCOztBQUVBLFVBQVMsVUFBVCxHQUFzQjs7QUFFckIsTUFBSSxDQUFDLFVBQUQsSUFBZSxDQUFDLFVBQXBCLEVBQ0M7O0FBR0QsTUFBSSxvQkFBb0IsQ0FBeEI7QUFDQSxNQUFJLG9CQUFvQixDQUF4QjtBQUNBLE1BQUksc0JBQXNCLENBQTFCO0FBQ0EsTUFBSSxzQkFBc0IsQ0FBMUI7O0FBRUEsT0FBSyxJQUFJLENBQVQsRUFBWSxJQUFJLFdBQVcsTUFBM0IsRUFBbUMsR0FBbkMsRUFBd0M7O0FBRXZDLE9BQUksWUFBWSxXQUFXLENBQVgsQ0FBaEI7QUFDQSxPQUFJLEtBQUssV0FBVyxZQUFYLENBQXdCLENBQXhCLENBQVQ7O0FBRUEsT0FBSSxjQUFjO0FBQ2pCLFFBQUksRUFEYSxFQUNULFlBQVksV0FESCxFQUNnQixnQkFBZ0IsQ0FEaEMsRUFDbUMsaUJBQWlCO0FBRHBELElBQWxCO0FBR0EsZ0JBQWEsSUFBYixDQUFrQixXQUFsQjs7QUFFQSxPQUFJLGtCQUFrQjtBQUNyQixhQUFTLElBRFksRUFDTixPQUFPO0FBREQsSUFBdEI7QUFHQSxPQUFJLHFCQUFxQixJQUF6Qjs7QUFFQSxxQkFBa0IsTUFBTSxrQkFBTixDQUF5QixVQUF6QixFQUFxQyxTQUFyQyxDQUFsQjs7QUFFQSxPQUFJLFdBQVcsbUJBQVgsSUFBa0MsVUFBVSxtQkFBaEQsRUFDQyxxQkFBcUI7QUFDcEIsV0FBTyxNQUFNLFFBRE8sRUFDRyxZQUFZLFVBRGYsRUFDMkIsV0FBVyxTQUR0QyxFQUNpRCxPQUFPLGdCQUFnQixLQUR4RSxFQUMrRSxTQUFTLGdCQUFnQjtBQUR4RyxJQUFyQjs7QUFJRCxPQUFJLGlCQUFpQixVQUFVLG1CQUFWLEdBQWdDLFVBQVUsbUJBQVYsQ0FBOEIsa0JBQTlCLENBQWhDLEdBQ2IsVUFBVSxVQUFWLEdBQXVCLE1BQU0sd0JBQU4sQ0FBK0IsVUFBVSxVQUF6QyxFQUFxRCxTQUFyRCxFQUFnRSxVQUFoRSxFQUE0RSxDQUE1RSxDQUF2QixHQUNBLFdBQVcsbUJBQVgsR0FBaUMsV0FBVyxtQkFBWCxDQUErQixrQkFBL0IsQ0FBakMsR0FDQSxXQUFXLFVBQVgsR0FBd0IsTUFBTSx3QkFBTixDQUErQixXQUFXLFVBQTFDLEVBQXNELFNBQXRELEVBQWlFLFVBQWpFLEVBQTZFLENBQTdFLENBQXhCLEdBQTBHLFVBQVUsS0FBVixHQUFrQixVQUFVLEtBQTVCLEdBQW9DLEVBSHRKOztBQU1BLFNBQU0sYUFBTixDQUFvQixTQUFwQixDQUE4QixFQUE5QixJQUFvQyxXQUFwQzs7QUFFQTtBQUNBLGVBQVksTUFBWixHQUFxQjtBQUNwQixPQUFHLE9BQU8sQ0FEVSxFQUNQLEdBQUcsT0FBTztBQURILElBQXJCO0FBR0EsZUFBWSxDQUFaLEdBQWdCLFVBQVUsQ0FBMUI7QUFDQSxlQUFZLE1BQVosR0FBcUIsV0FBckI7QUFDQSxlQUFZLGtCQUFaLEdBQWlDLGtCQUFqQztBQUNBLGVBQVksY0FBWixHQUE2QixjQUE3QjtBQUNBLGVBQVksbUJBQVosR0FBa0MsV0FBVyxtQkFBN0M7QUFDQSxlQUFZLG1CQUFaLEdBQWtDLFVBQVUsbUJBQVYsR0FBZ0MsVUFBVSxtQkFBMUMsR0FBZ0UsV0FBVyxtQkFBWCxHQUFpQyxXQUFXLG1CQUE1QyxHQUFrRSxVQUFVLEtBQVYsR0FBa0IsVUFBVSxLQUE1QixHQUFvQyxXQUFXLFNBQVgsQ0FBcUIsSUFBSSxXQUFXLFNBQVgsQ0FBcUIsTUFBOUMsQ0FBeE07QUFDQSxlQUFZLHVCQUFaLEdBQXNDLFVBQVUsdUJBQVYsR0FBb0MsVUFBVSx1QkFBOUMsR0FBd0UsV0FBVyx1QkFBekg7QUFDQSxlQUFZLHNCQUFaLEdBQXFDLFVBQVUsc0JBQVYsR0FBbUMsVUFBVSxzQkFBN0MsR0FBc0UsV0FBVyxzQkFBdEg7QUFDQSxlQUFZLG1CQUFaLEdBQWtDLFVBQVUsbUJBQVYsR0FBZ0MsVUFBVSxtQkFBMUMsR0FBZ0UsV0FBVyxtQkFBN0c7QUFDQSxlQUFZLG1CQUFaLEdBQWtDLFVBQVUsbUJBQVYsR0FBZ0MsVUFBVSxtQkFBMUMsR0FBZ0UsV0FBVyxtQkFBN0c7QUFDQSxlQUFZLG9CQUFaLEdBQW1DLFVBQVUsb0JBQVYsR0FBaUMsVUFBVSxvQkFBM0MsR0FBa0UsV0FBVyxvQkFBaEg7QUFDQSxlQUFZLGtCQUFaLEdBQWlDLFVBQVUsa0JBQVYsR0FBK0IsVUFBVSxrQkFBekMsR0FBOEQsV0FBVyxrQkFBMUc7QUFDQSxlQUFZLG9CQUFaLEdBQW1DLFVBQVUsb0JBQVYsR0FBaUMsVUFBVSxvQkFBM0MsR0FBa0UsV0FBVyxvQkFBaEg7QUFDQSxlQUFZLHlCQUFaLEdBQXdDLFVBQVUseUJBQVYsR0FBc0MsVUFBVSx5QkFBaEQsR0FBNEUsV0FBVyx5QkFBWCxHQUF1QyxXQUFXLHlCQUFsRCxHQUE4RSxJQUFsTTtBQUNBLGVBQVksa0JBQVosR0FBaUMsVUFBVSxrQkFBVixHQUErQixVQUFVLGtCQUF6QyxHQUE4RCxXQUFXLGtCQUFYLEdBQWdDLFdBQVcsa0JBQTNDLEdBQWdFLFNBQVMsS0FBVCxHQUFpQixHQUFoTDtBQUNBLGVBQVksY0FBWixHQUE2QixPQUFRLFVBQVUsY0FBbEIsS0FBc0MsV0FBdEMsR0FBb0QsVUFBVSxjQUE5RCxHQUErRSxXQUFXLGNBQXZIOztBQUVBLGVBQVksVUFBWixHQUF5QixNQUFNLENBQU4sR0FBVSxXQUFXLFVBQVgsR0FBeUIsV0FBVyxVQUFYLEdBQXdCLEdBQXpCLEdBQWdDLEtBQUssRUFBN0QsR0FBa0UsQ0FBNUUsR0FBZ0YsYUFBYSxJQUFJLENBQWpCLEVBQW9CLFFBQTdIOztBQUVBLGVBQVksVUFBWixHQUF5QixDQUFDLFlBQVksVUFBWixHQUEwQixJQUFJLEtBQUssRUFBcEMsS0FBNEMsSUFBSSxLQUFLLEVBQXJELENBQXpCOztBQUVBLGVBQVksUUFBWixHQUF1QixZQUFZLFVBQVosR0FBMkIsSUFBSSxLQUFLLEVBQVQsR0FBYyxHQUFmLEdBQXNCLEtBQUssR0FBTCxDQUFTLFVBQVUsQ0FBbkIsQ0FBdkU7O0FBRUE7QUFDQSxPQUFJLFdBQVcsQ0FBQyxZQUFZLFFBQVosR0FBdUIsWUFBWSxVQUFwQyxJQUFrRCxDQUFqRTs7QUFFQTs7QUFFQSxjQUFXLENBQUMsV0FBWSxJQUFJLEtBQUssRUFBdEIsS0FBOEIsSUFBSSxLQUFLLEVBQXZDLENBQVg7O0FBRUEsZUFBWSxRQUFaLEdBQXVCLFFBQXZCOztBQUVBLE9BQUksWUFBWSxRQUFaLEdBQXdCLEtBQUssRUFBTCxHQUFVLENBQVgsR0FBZ0Isb0JBQXZDLElBQStELFlBQVksUUFBWixHQUF3QixLQUFLLEVBQUwsR0FBVSxDQUFYLEdBQWdCLG9CQUExRyxFQUFnSTtBQUMvSCxRQUFJLHNCQUFzQixDQUF0QixJQUEyQixhQUFhLG1CQUFiLEVBQWtDLFFBQWxDLEdBQTZDLFlBQVksUUFBeEYsRUFDQyxzQkFBc0IsQ0FBdEI7O0FBRUQ7QUFDQSxJQUxELE1BTUssSUFBSSxZQUFZLFFBQVosR0FBd0IsSUFBSSxLQUFLLEVBQVQsR0FBYyxDQUFmLEdBQW9CLG9CQUEzQyxJQUFtRSxZQUFZLFFBQVosR0FBd0IsSUFBSSxLQUFLLEVBQVQsR0FBYyxDQUFmLEdBQW9CLG9CQUFsSCxFQUF3STtBQUM1SSxRQUFJLHNCQUFzQixDQUF0QixJQUEyQixhQUFhLG1CQUFiLEVBQWtDLFFBQWxDLEdBQTZDLFlBQVksUUFBeEYsRUFDQyxzQkFBc0IsQ0FBdEI7O0FBRUQ7QUFDQTs7QUFHRCxPQUFJLFdBQVksS0FBSyxFQUFMLEdBQVUsQ0FBdEIsSUFBNEIsWUFBYSxJQUFJLEtBQUssRUFBVCxHQUFjLENBQTNELEVBQ0MsWUFBWSxVQUFaLEdBQXlCLE1BQXpCLENBREQsS0FHQyxZQUFZLFVBQVosR0FBeUIsT0FBekI7O0FBRUQ7QUFDQSxlQUFZLG1CQUFaLEdBQWtDLElBQUksb0JBQUosQ0FBYyxNQUFNLFFBQU4sQ0FBZSxHQUE3QixFQUFrQztBQUNuRSxjQUFVLFlBQVksa0JBRDZDLEVBQ3pCLFlBQVksWUFBWSxvQkFEQyxFQUNxQixXQUFXLFlBQVksbUJBRDVDO0FBRW5FLGVBQVcsWUFBWSxtQkFGNEMsRUFFdkIsWUFBWSxZQUFZLG9CQUZEO0FBR25FLHFCQUFpQixNQUhrRDtBQUluRSxxQkFBaUIsWUFBWSx5QkFKc0M7QUFLbkUsY0FBVSxZQUFZLGtCQUw2QyxFQUt6QixXQUFXLFlBQVksY0FBWixHQUE2QixZQUFZLGtCQUFaLEdBQWlDLENBQTlELEdBQWtFLFlBQVksa0JBQVosR0FBaUMsR0FMckY7QUFNbkUsVUFBTSxZQUFZLGNBTmlEO0FBT25FLGFBQVMsQ0FQMEQ7QUFRbkU7QUFDQSxrQkFBYztBQVRxRCxJQUFsQyxDQUFsQzs7QUFZQSxlQUFZLG1CQUFaLENBQWdDLFdBQWhDOztBQUVBOztBQUVBO0FBQ0E7O0FBRUQsTUFBSSwyQkFBMkIsQ0FBL0I7QUFDQSxNQUFJLDBCQUEwQixDQUE5QjtBQUNBLE1BQUksb0JBQW9CLEtBQXhCLENBdEhxQixDQXNIVTs7QUFFL0IsT0FBSyxJQUFJLENBQVQsRUFBWSxJQUFJLFdBQVcsTUFBM0IsRUFBbUMsR0FBbkMsRUFBd0M7O0FBRXZDLE9BQUksY0FBYyxhQUFhLENBQUMsc0JBQXNCLENBQXZCLElBQTRCLFdBQVcsTUFBcEQsQ0FBbEI7O0FBRUEsT0FBSSxvQkFBb0IsQ0FBcEIsSUFBeUIsWUFBWSxRQUFaLEdBQXdCLEtBQUssRUFBTCxHQUFVLENBQVgsR0FBZ0Isb0JBQWhFLElBQXdGLFlBQVksUUFBWixHQUF3QixLQUFLLEVBQUwsR0FBVSxDQUFYLEdBQWdCLG9CQUFuSSxFQUF5Sjs7QUFFeEosUUFBSSw0QkFBNEIsb0JBQW9CLENBQWhELElBQXFELENBQUMsaUJBQTFELEVBQTZFO0FBQzVFLGlCQUFZLFVBQVosR0FBeUIsT0FBekI7QUFDQTtBQUNBLEtBSEQsTUFJSztBQUNKLGlCQUFZLFVBQVosR0FBeUIsTUFBekI7QUFDQSx5QkFBb0IsSUFBcEI7QUFDQTtBQUNEO0FBQ0Q7O0FBRUQsc0JBQW9CLEtBQXBCO0FBQ0EsT0FBSyxJQUFJLENBQVQsRUFBWSxJQUFJLFdBQVcsTUFBM0IsRUFBbUMsR0FBbkMsRUFBd0M7O0FBRXZDLE9BQUksY0FBYyxhQUFhLENBQUMsc0JBQXNCLENBQXZCLElBQTRCLFdBQVcsTUFBcEQsQ0FBbEI7O0FBRUE7QUFDQTs7QUFFQSxPQUFJLG9CQUFvQixDQUFwQixJQUF5QixZQUFZLFFBQVosR0FBd0IsSUFBSSxLQUFLLEVBQVQsR0FBYyxDQUFmLEdBQW9CLG9CQUFwRSxJQUE0RixZQUFZLFFBQVosR0FBd0IsSUFBSSxLQUFLLEVBQVQsR0FBYyxDQUFmLEdBQW9CLG9CQUEzSSxFQUFpSzs7QUFFaEssUUFBSSwyQkFBMkIsb0JBQW9CLENBQS9DLElBQW9ELENBQUMsaUJBQXpELEVBQTRFO0FBQzNFLGlCQUFZLFVBQVosR0FBeUIsTUFBekI7QUFDQTtBQUNBLEtBSEQsTUFJSztBQUNKLGlCQUFZLFVBQVosR0FBeUIsT0FBekI7QUFDQSx5QkFBb0IsSUFBcEI7QUFDQTtBQUNEO0FBQ0Q7QUFDRCxFQXJOaUMsQ0FxTmpDOztBQUVELFVBQVMsWUFBVCxHQUF3Qjs7QUFFdkIsTUFBSSxNQUFNLE1BQU0sUUFBTixDQUFlLEdBQXpCO0FBQ0EsTUFBSSxTQUFKLEdBQWdCLE9BQWhCO0FBQ0EsTUFBSSxXQUFKLEdBQWtCLE1BQWxCO0FBQ0EsTUFBSSxXQUFXLEVBQWY7QUFDQTtBQUNBLE1BQUksWUFBSixHQUFtQixRQUFuQjtBQUNBLE1BQUksUUFBSixHQUFlLE9BQWY7QUFDQSxNQUFJLElBQUksQ0FBUjtBQUFBLE1BQVcsSUFBSSxDQUFmOztBQUVBLE9BQUssSUFBSSxDQUFULEVBQVksSUFBSSxXQUFXLE1BQTNCLEVBQW1DLEdBQW5DLEVBQXdDO0FBQ3ZDLE9BQUksY0FBYyxhQUFhLENBQWIsQ0FBbEI7O0FBRUEsT0FBSSxDQUFDLFlBQVksY0FBakIsRUFDQzs7QUFFRCxlQUFZLG1CQUFaLENBQWdDLENBQWhDLElBQXFDLFlBQVksbUJBQVosQ0FBZ0MsTUFBaEMsR0FBeUMsQ0FBOUU7O0FBRUEsT0FBSSxVQUFVLENBQWQ7O0FBRUEsT0FBSSxZQUFZLFVBQVosS0FBMkIsTUFBL0IsRUFBdUM7QUFDdEMsUUFBSSxVQUFVLFdBQVcsbUJBQVgsS0FBbUMsUUFBbkMsR0FBOEMsRUFBRSxZQUFZLG1CQUFaLENBQWdDLEtBQWhDLEdBQXdDLHdCQUExQyxDQUE5QyxHQUFvSCxDQUFDLFlBQVksbUJBQVosQ0FBZ0MsS0FBakMsR0FBeUMsQ0FBM0s7QUFDQSxJQUZELE1BR0s7QUFDSixRQUFJLFVBQVUsV0FBVyxtQkFBWCxLQUFtQyxRQUFuQyxHQUE4Qyx3QkFBOUMsR0FBeUUsQ0FBQyxZQUFZLG1CQUFaLENBQWdDLEtBQWpDLEdBQXlDLENBQWhJO0FBQ0E7O0FBRUQsZUFBWSxtQkFBWixDQUFnQyxDQUFoQyxJQUFxQyxPQUFyQztBQUNBLGVBQVksbUJBQVosQ0FBZ0MsTUFBaEMsQ0FBdUMsSUFBdkM7QUFDQSxlQUFZLG1CQUFaLENBQWdDLENBQWhDLElBQXFDLE9BQXJDOztBQUVBO0FBQ0E7O0FBRUEsZUFBWSxtQkFBWixDQUFnQyxDQUFoQyxJQUFxQyxZQUFZLG1CQUFaLENBQWdDLE1BQWhDLEdBQXlDLENBQTlFOztBQUVBLE9BQUksWUFBWSxtQkFBWixLQUFvQyxRQUF4QyxFQUFrRDtBQUNqRCxRQUFJLHVCQUF1QixZQUFZLE1BQVosQ0FBbUIsQ0FBbkIsR0FBdUIsY0FBYyxLQUFLLEdBQUwsQ0FBUyxZQUFZLFFBQXJCLENBQWhFO0FBQ0EsUUFBSSx1QkFBdUIsWUFBWSxNQUFaLENBQW1CLENBQW5CLEdBQXVCLGNBQWMsS0FBSyxHQUFMLENBQVMsWUFBWSxRQUFyQixDQUFoRTs7QUFFQTtBQUNBLFFBQUksV0FBSixHQUFrQixZQUFZLG1CQUE5QjtBQUNBLFFBQUksU0FBSixHQUFnQixZQUFZLHVCQUE1Qjs7QUFFQSxRQUFJLElBQUksV0FBUixFQUFxQjtBQUNwQixTQUFJLFdBQUosQ0FBZ0IsNkJBQWlCLFlBQVksc0JBQTdCLEVBQXFELFlBQVksdUJBQWpFLENBQWhCO0FBQ0E7O0FBRUQ7QUFDQSxRQUFJLFNBQUo7QUFDQSxRQUFJLE1BQUosQ0FBVyxvQkFBWCxFQUFpQyxvQkFBakM7QUFDQSxRQUFJLE1BQUosQ0FBVyxZQUFZLG1CQUFaLENBQWdDLENBQTNDLEVBQThDLFlBQVksbUJBQVosQ0FBZ0MsQ0FBOUU7QUFDQSxRQUFJLE1BQUosQ0FBVyxZQUFZLG1CQUFaLENBQWdDLENBQWhDLElBQXFDLFlBQVksVUFBWixLQUEyQixNQUEzQixHQUFvQyxDQUFDLHdCQUFyQyxHQUFnRSx3QkFBckcsQ0FBWCxFQUEySSxZQUFZLG1CQUFaLENBQWdDLENBQTNLO0FBQ0EsUUFBSSxNQUFKO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUQsT0FBSSxRQUFKLEdBQWUsT0FBZjtBQUNBO0FBQ0Q7O0FBRUQsVUFBUyxPQUFULENBQWlCLGdCQUFqQixFQUFtQzs7QUFFbEMsTUFBSSxNQUFNLE1BQU0sUUFBTixDQUFlLEdBQXpCOztBQUVBLE1BQUksU0FBSixDQUFjLFNBQVMsRUFBdkIsRUFBMkIsU0FBUyxFQUFwQyxFQUF3QyxTQUFTLEtBQWpELEVBQXdELFNBQVMsTUFBakU7QUFDQSxNQUFJLFNBQUosR0FBZ0IsTUFBTSxlQUF0QjtBQUNBLE1BQUksUUFBSixDQUFhLFNBQVMsRUFBdEIsRUFBMEIsU0FBUyxFQUFuQyxFQUF1QyxTQUFTLEtBQWhELEVBQXVELFNBQVMsTUFBaEU7O0FBRUEsTUFBSSxXQUFXLGFBQWEsQ0FBYixFQUFnQixVQUFoQixHQUE4QixJQUFJLEtBQUssRUFBVCxHQUFjLGdCQUEzRDs7QUFFQSxPQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksV0FBVyxNQUEvQixFQUF1QyxHQUF2QyxFQUE0Qzs7QUFFM0MsT0FBSSxhQUFhLE1BQU0sQ0FBTixHQUFVLGFBQWEsQ0FBYixFQUFnQixVQUExQixHQUF1QyxRQUF4RDtBQUNBLE9BQUksV0FBVyxjQUFjLGFBQWEsQ0FBYixFQUFnQixRQUFoQixHQUEyQixhQUFhLENBQWIsRUFBZ0IsVUFBekQsQ0FBZjs7QUFFQSxPQUFJLGNBQWMsS0FBbEI7O0FBRUEsT0FBSSxXQUFXLFFBQWYsRUFBeUI7QUFDeEIsZUFBVyxRQUFYO0FBQ0Esa0JBQWMsSUFBZDtBQUNBOztBQUVELE9BQUksUUFBUSxXQUFXLENBQVgsRUFBYyxLQUFkLEdBQXNCLFdBQVcsQ0FBWCxFQUFjLEtBQXBDLEdBQTRDLFdBQVcsU0FBWCxDQUFxQixJQUFJLFdBQVcsU0FBWCxDQUFxQixNQUE5QyxDQUF4RDs7QUFFQSxPQUFJLFdBQVcsVUFBZixFQUNDLHdCQUFZLE1BQU0sUUFBTixDQUFlLEdBQTNCLEVBQWdDLGFBQWEsQ0FBYixFQUFnQixNQUFoRCxFQUF3RCxhQUFhLENBQWIsRUFBZ0IsTUFBeEUsRUFBZ0YsS0FBaEYsRUFBdUYsV0FBVyxJQUFsRyxFQUF3RyxVQUF4RyxFQUFvSCxRQUFwSCxFQUE4SCxXQUFXLFdBQXpJLEVBQXNKLGFBQWEsQ0FBYixFQUFnQixrQkFBdEs7O0FBRUQsT0FBSSxXQUFKLEVBQ0M7QUFDRDtBQUNEOztBQUVELFVBQVMsYUFBVCxDQUF1QixnQkFBdkIsRUFBeUM7O0FBRXhDLE1BQUksTUFBTSxNQUFNLFFBQU4sQ0FBZSxHQUF6Qjs7QUFFQSxNQUFJLFNBQUosQ0FBYyxTQUFTLEVBQXZCLEVBQTJCLFNBQVMsRUFBcEMsRUFBd0MsU0FBUyxLQUFqRCxFQUF3RCxTQUFTLE1BQWpFO0FBQ0EsTUFBSSxTQUFKLEdBQWdCLE1BQU0sZUFBdEI7QUFDQSxNQUFJLFFBQUosQ0FBYSxTQUFTLEVBQXRCLEVBQTBCLFNBQVMsRUFBbkMsRUFBdUMsU0FBUyxLQUFoRCxFQUF1RCxTQUFTLE1BQWhFOztBQUVBLE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxXQUFXLE1BQS9CLEVBQXVDLEdBQXZDLEVBQTRDOztBQUUzQyxPQUFJLGFBQWEsYUFBYSxDQUFiLEVBQWdCLFVBQWpDO0FBQ0EsT0FBSSxXQUFXLGFBQWEsQ0FBYixFQUFnQixRQUEvQjs7QUFFQSxPQUFJLFdBQVcsVUFBZixFQUEyQjs7QUFHMUIsUUFBSSxVQUFXLGNBQWMsR0FBZCxHQUFvQixLQUFLLEdBQUwsQ0FBUyxhQUFhLENBQWIsRUFBZ0IsUUFBekIsQ0FBbkM7QUFDQSxRQUFJLFVBQVcsY0FBYyxHQUFkLEdBQW9CLEtBQUssR0FBTCxDQUFTLGFBQWEsQ0FBYixFQUFnQixRQUF6QixDQUFuQztBQUNBLFFBQUksaUJBQWlCLEtBQXJCOztBQUVBLFFBQUksV0FBVyxDQUFYLEVBQWMsUUFBbEIsRUFBNEI7QUFDM0IsU0FBSSxLQUFLLEdBQUwsQ0FBUyxhQUFhLENBQWIsRUFBZ0IsTUFBaEIsQ0FBdUIsQ0FBdkIsSUFBNEIsT0FBTyxDQUFQLEdBQVcsT0FBdkMsQ0FBVCxJQUE0RCxXQUE1RCxJQUEyRSxLQUFLLEdBQUwsQ0FBUyxhQUFhLENBQWIsRUFBZ0IsTUFBaEIsQ0FBdUIsQ0FBdkIsSUFBNEIsT0FBTyxDQUFQLEdBQVcsT0FBdkMsQ0FBVCxJQUE0RCxXQUEzSSxFQUF3Sjs7QUFFdkosbUJBQWEsQ0FBYixFQUFnQixNQUFoQixDQUF1QixDQUF2QixHQUEyQixPQUFPLENBQVAsR0FBVyxVQUFVLGdCQUFoRDtBQUNBLG1CQUFhLENBQWIsRUFBZ0IsTUFBaEIsQ0FBdUIsQ0FBdkIsR0FBMkIsT0FBTyxDQUFQLEdBQVcsVUFBVSxnQkFBaEQ7O0FBRUEsdUJBQWlCLElBQWpCO0FBQ0E7QUFDRCxLQVJELE1BUU8sSUFBSSxLQUFLLEdBQUwsQ0FBUyxhQUFhLENBQWIsRUFBZ0IsTUFBaEIsQ0FBdUIsQ0FBdkIsR0FBMkIsT0FBTyxDQUEzQyxJQUFnRCxDQUFoRCxJQUFxRCxLQUFLLEdBQUwsQ0FBUyxhQUFhLENBQWIsRUFBZ0IsTUFBaEIsQ0FBdUIsQ0FBdkIsR0FBMkIsT0FBTyxDQUEzQyxJQUFnRCxDQUF6RyxFQUE0RztBQUNsSCxrQkFBYSxDQUFiLEVBQWdCLE1BQWhCLENBQXVCLENBQXZCLEdBQTJCLE9BQU8sQ0FBUCxHQUFXLFdBQVcsSUFBSSxnQkFBZixDQUF0QztBQUNBLGtCQUFhLENBQWIsRUFBZ0IsTUFBaEIsQ0FBdUIsQ0FBdkIsR0FBMkIsT0FBTyxDQUFQLEdBQVcsV0FBVyxJQUFJLGdCQUFmLENBQXRDOztBQUVBLHNCQUFpQixJQUFqQjtBQUNBOztBQUVELFFBQUksY0FBSixFQUFvQjtBQUNuQixTQUFJLFFBQVEsRUFBWjtBQUVBLFdBQU0sVUFBTixHQUFtQixVQUFuQjtBQUNBLFdBQU0sU0FBTixHQUFrQixXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsQ0FBbEI7QUFDQSxXQUFNLEtBQU4sR0FBYyxDQUFkO0FBQ0EsV0FBTSxRQUFOLENBQWUsZ0JBQWYsQ0FBZ0MsQ0FBQyxLQUFELENBQWhDO0FBQ0E7O0FBRUQsUUFBSSxRQUFRLFdBQVcsQ0FBWCxFQUFjLEtBQWQsR0FBc0IsV0FBVyxDQUFYLEVBQWMsS0FBcEMsR0FBNEMsV0FBVyxTQUFYLENBQXFCLElBQUksV0FBVyxTQUFYLENBQXFCLE1BQTlDLENBQXhEOztBQUVBLDRCQUFZLE1BQU0sUUFBTixDQUFlLEdBQTNCLEVBQWdDLGFBQWEsQ0FBYixFQUFnQixNQUFoRCxFQUF3RCxhQUFhLENBQWIsRUFBZ0IsTUFBeEUsRUFBZ0YsS0FBaEYsRUFBdUYsV0FBVyxJQUFsRyxFQUF3RyxVQUF4RyxFQUFvSCxRQUFwSCxFQUE4SCxXQUFXLFdBQXpJLEVBQXNKLGFBQWEsQ0FBYixFQUFnQixrQkFBdEs7QUFDQTtBQUNEOztBQUVEO0FBQ0E7QUFDQTs7QUFFRCxVQUFTLHFCQUFULENBQStCLEtBQS9CLEVBQXNDLE1BQXRDLEVBQThDOztBQUU3QyxNQUFJLFNBQVM7QUFDWixPQUFJLE1BQU0sbUJBQU4sQ0FBMEIsQ0FEbEIsRUFDcUIsSUFBSSxNQUFNLG1CQUFOLENBQTBCLENBQTFCLEdBQThCLE1BQU0sbUJBQU4sQ0FBMEIsTUFBMUIsR0FBbUMsQ0FEMUYsRUFDNkYsSUFBSSxNQUFNLG1CQUFOLENBQTBCLENBQTFCLEdBQThCLE1BQU0sbUJBQU4sQ0FBMEIsS0FEekosRUFDZ0ssSUFBSSxNQUFNLG1CQUFOLENBQTBCLENBQTFCLEdBQThCLE1BQU0sbUJBQU4sQ0FBMEIsTUFBMUIsR0FBbUM7QUFEck8sR0FBYjtBQUdBLE1BQUksU0FBUztBQUNaLE9BQUksT0FBTyxtQkFBUCxDQUEyQixDQURuQixFQUNzQixJQUFJLE9BQU8sbUJBQVAsQ0FBMkIsQ0FBM0IsR0FBK0IsT0FBTyxtQkFBUCxDQUEyQixNQUEzQixHQUFvQyxDQUQ3RixFQUNnRyxJQUFJLE9BQU8sbUJBQVAsQ0FBMkIsQ0FBM0IsR0FBK0IsT0FBTyxtQkFBUCxDQUEyQixLQUQ5SixFQUNxSyxJQUFJLE9BQU8sbUJBQVAsQ0FBMkIsQ0FBM0IsR0FBK0IsT0FBTyxtQkFBUCxDQUEyQixNQUEzQixHQUFvQztBQUQ1TyxHQUFiOztBQUlBLE1BQUksT0FBTyxFQUFQLEdBQVksT0FBTyxFQUFQLEdBQVksd0JBQXhCLElBQW9ELE9BQU8sRUFBUCxHQUFZLE9BQU8sRUFBUCxHQUFZLHdCQUE1RSxJQUF3RyxPQUFPLEVBQVAsR0FBWSxPQUFPLEVBQVAsR0FBWSx3QkFBaEksSUFBNEosT0FBTyxFQUFQLEdBQVksT0FBTyxFQUFQLEdBQVksd0JBQXhMLEVBQ0MsT0FBTyxLQUFQOztBQUVELFNBQU8sSUFBUDtBQUNBOztBQUVELFVBQVMsZ0NBQVQsQ0FBMEMsS0FBMUMsRUFBaUQsTUFBakQsRUFBeUQ7O0FBRXhELE1BQUksV0FBVyxDQUFmO0FBQ0EsTUFBSSxTQUFTO0FBQ1osTUFBRyxNQUFNLG1CQUFOLENBQTBCLENBRGpCLEVBQ29CLElBQUksTUFBTSxtQkFBTixDQUEwQixDQUExQixHQUE4QixNQUFNLG1CQUFOLENBQTBCLE1BQTFCLEdBQW1DLENBRHpGLEVBQzRGLElBQUksTUFBTSxtQkFBTixDQUEwQixDQUExQixHQUE4QixNQUFNLG1CQUFOLENBQTBCLE1BQTFCLEdBQW1DO0FBRGpLLEdBQWI7QUFHQSxNQUFJLFNBQVM7QUFDWixNQUFHLE9BQU8sbUJBQVAsQ0FBMkIsQ0FEbEIsRUFDcUIsSUFBSSxPQUFPLG1CQUFQLENBQTJCLENBQTNCLEdBQStCLE9BQU8sbUJBQVAsQ0FBMkIsTUFBM0IsR0FBb0MsQ0FENUYsRUFDK0YsSUFBSSxPQUFPLG1CQUFQLENBQTJCLENBQTNCLEdBQStCLE9BQU8sbUJBQVAsQ0FBMkIsTUFBM0IsR0FBb0M7QUFEdEssR0FBYjs7QUFJQSxNQUFJLE9BQU8sQ0FBUCxHQUFXLE9BQU8sQ0FBdEIsRUFBeUI7QUFDeEIsY0FBVyxPQUFPLEVBQVAsR0FBWSxPQUFPLEVBQTlCO0FBQ0EsR0FGRCxNQUdLO0FBQ0osY0FBVyxPQUFPLEVBQVAsR0FBWSxPQUFPLEVBQTlCO0FBQ0E7O0FBRUQsU0FBTyxRQUFQO0FBQ0E7O0FBRUQsVUFBUyxpQkFBVCxDQUEyQixpQkFBM0IsRUFBOEM7QUFDN0MsTUFBSSxpQkFBaUIsSUFBckI7O0FBRUEsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFdBQVcsTUFBL0IsRUFBdUMsR0FBdkMsRUFBNEM7O0FBRTNDLG9CQUFpQixDQUFDLG9CQUFvQixDQUFwQixHQUF3QixhQUFhLE1BQXRDLElBQWdELGFBQWEsTUFBOUU7O0FBRUEsT0FBSSxhQUFhLGNBQWIsRUFBNkIsVUFBN0IsS0FBNEMsYUFBYSxpQkFBYixFQUFnQyxVQUFoRixFQUE0RjtBQUMzRixxQkFBaUIsSUFBakI7QUFDQTtBQUNBLElBSEQsTUFJSyxJQUFLLGFBQWEsY0FBYixFQUE2QixjQUE5QixJQUFrRCxtQkFBbUIsaUJBQXJFLEtBQ0gsaUNBQWlDLGFBQWEsY0FBYixDQUFqQyxFQUErRCxhQUFhLGlCQUFiLENBQS9ELElBQWtHLENBQW5HLEtBQTBHLGFBQWEsaUJBQWIsRUFBZ0MsVUFBaEMsS0FBK0MsT0FBL0MsR0FBeUQsYUFBYSxjQUFiLEVBQTZCLG1CQUE3QixDQUFpRCxDQUFqRCxJQUFzRCxhQUFhLGlCQUFiLEVBQWdDLG1CQUFoQyxDQUFvRCxDQUFuSyxHQUF1SyxhQUFhLGNBQWIsRUFBNkIsbUJBQTdCLENBQWlELENBQWpELElBQXNELGFBQWEsaUJBQWIsRUFBZ0MsbUJBQWhDLENBQW9ELENBQTNYLENBREksQ0FBSixFQUVKLE1BRkksS0FHQTtBQUNKLHFCQUFpQixJQUFqQjtBQUNBO0FBQ0Q7O0FBRUQsU0FBTyxjQUFQO0FBQ0E7O0FBRUQsVUFBUyxxQkFBVCxDQUErQixpQkFBL0IsRUFBa0Q7QUFDakQsTUFBSSxpQkFBaUIsSUFBckI7O0FBRUEsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFdBQVcsTUFBL0IsRUFBdUMsR0FBdkMsRUFBNEM7O0FBRTNDLG9CQUFpQixDQUFDLG9CQUFvQixDQUFwQixHQUF3QixhQUFhLE1BQXRDLElBQWdELGFBQWEsTUFBOUU7O0FBRUEsT0FBSSxhQUFhLGNBQWIsRUFBNkIsVUFBN0IsS0FBNEMsYUFBYSxpQkFBYixFQUFnQyxVQUFoRixFQUE0RjtBQUMzRixxQkFBaUIsSUFBakI7QUFDQTtBQUNBLElBSEQsTUFJSyxJQUFLLGFBQWEsY0FBYixFQUE2QixjQUE5QixJQUFrRCxhQUFhLGNBQWIsRUFBNkIsVUFBN0IsS0FBNEMsYUFBYSxpQkFBYixFQUFnQyxVQUE5SCxJQUE4SSxtQkFBbUIsaUJBQWpLLEtBQ0gsaUNBQWlDLGFBQWEsY0FBYixDQUFqQyxFQUErRCxhQUFhLGlCQUFiLENBQS9ELElBQWtHLENBQW5HLEtBQTBHLGFBQWEsaUJBQWIsRUFBZ0MsVUFBaEMsS0FBK0MsT0FBL0MsR0FBeUQsYUFBYSxjQUFiLEVBQTZCLG1CQUE3QixDQUFpRCxDQUFqRCxJQUFzRCxhQUFhLGlCQUFiLEVBQWdDLG1CQUFoQyxDQUFvRCxDQUFuSyxHQUF1SyxhQUFhLGNBQWIsRUFBNkIsbUJBQTdCLENBQWlELENBQWpELElBQXNELGFBQWEsaUJBQWIsRUFBZ0MsbUJBQWhDLENBQW9ELENBQTNYLENBREksQ0FBSixFQUVKLE1BRkksS0FHQTtBQUNKLHFCQUFpQixJQUFqQjtBQUNBO0FBRUQ7O0FBRUQsU0FBTyxjQUFQO0FBQ0E7O0FBRUQsVUFBUyxnQkFBVCxDQUEwQixjQUExQixFQUEwQyxNQUExQyxFQUFrRDtBQUNqRCxXQUFTLFVBQVUsQ0FBbkI7O0FBRUEsTUFBSSxlQUFlLENBQW5COztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBLE1BQUksWUFBWSxPQUFPLENBQVAsR0FBVyxtQkFBbUIsQ0FBOUM7QUFDQSxNQUFJLFlBQVksT0FBTyxDQUFQLEdBQVcsbUJBQW1CLENBQTlDOztBQUVBOztBQUVBLE1BQUksa0JBQWtCLENBQWxCLElBQXVCLGlCQUFpQixXQUFXLE1BQXZELEVBQStEOztBQUU5RCxPQUFJLGNBQWMsYUFBYSxjQUFiLENBQWxCO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLE9BQUssU0FBUyxDQUFULElBQWMsWUFBWSxtQkFBWixDQUFnQyxDQUFoQyxHQUFvQyxTQUFuRCxJQUFrRSxTQUFTLENBQVQsSUFBYyxZQUFZLG1CQUFaLENBQWdDLENBQWhDLEdBQW9DLFNBQXhILEVBQ0MsT0FBTyxDQUFQOztBQUdELE9BQUksY0FBYyxNQUFsQjs7QUFHQTtBQUNBO0FBQ0MsUUFBSSx5QkFBeUIsQ0FBN0I7QUFDQSxRQUFJLHVCQUF1QixDQUEzQjtBQUNBLFFBQUksdUJBQXVCLENBQTNCO0FBQ0EsUUFBSSxrQkFBa0IsQ0FBdEI7QUFDQSxRQUFJLDZCQUE2QixDQUFqQzs7QUFFQSxRQUFJLGNBQWMsQ0FBbEIsRUFBcUI7QUFDcEIsU0FBSSxZQUFZLG1CQUFaLENBQWdDLENBQWhDLEdBQW9DLFlBQVksbUJBQVosQ0FBZ0MsTUFBaEMsR0FBeUMsQ0FBN0UsR0FBaUYsU0FBakYsSUFBOEYsWUFBWSxtQkFBWixDQUFnQyxDQUFoQyxHQUFvQyxZQUFZLG1CQUFaLENBQWdDLE1BQWhDLEdBQXlDLENBQTdFLEdBQWlGLFdBQWpGLEdBQStGLFNBQWpNLEVBQ0MsY0FBYyxFQUFFLGFBQWEsWUFBWSxtQkFBWixDQUFnQyxDQUFoQyxHQUFvQyxZQUFZLG1CQUFaLENBQWdDLE1BQWhDLEdBQXlDLENBQTdFLEdBQWlGLFdBQTlGLENBQUYsQ0FBZDtBQUNELEtBSEQsTUFHTztBQUNOLFNBQUksWUFBWSxtQkFBWixDQUFnQyxDQUFoQyxHQUFvQyxZQUFZLG1CQUFaLENBQWdDLE1BQWhDLEdBQXlDLENBQTdFLEdBQWlGLFNBQWpGLElBQThGLFlBQVksbUJBQVosQ0FBZ0MsQ0FBaEMsR0FBb0MsWUFBWSxtQkFBWixDQUFnQyxNQUFoQyxHQUF5QyxDQUE3RSxHQUFpRixXQUFqRixHQUErRixTQUFqTSxFQUNDLGNBQWUsWUFBWSxtQkFBWixDQUFnQyxDQUFoQyxHQUFvQyxZQUFZLG1CQUFaLENBQWdDLE1BQWhDLEdBQXlDLENBQTdFLEdBQWlGLFdBQWxGLEdBQWlHLFNBQS9HO0FBQ0Q7O0FBRUQsUUFBSSxZQUFZLFlBQVksbUJBQVosQ0FBZ0MsQ0FBaEMsR0FBb0MsV0FBcEQ7QUFDQSxRQUFJLFlBQVksQ0FBaEI7O0FBRUEsUUFBSSxZQUFZLFVBQVosS0FBMkIsT0FBL0IsRUFBd0M7QUFDdkMsaUJBQVksT0FBTyxDQUFQLEdBQVcsS0FBSyxJQUFMLENBQVUsS0FBSyxHQUFMLENBQVMsZ0JBQVQsRUFBMkIsQ0FBM0IsSUFBZ0MsS0FBSyxHQUFMLENBQVMsWUFBWSxPQUFPLENBQTVCLEVBQStCLENBQS9CLENBQTFDLENBQXZCO0FBQ0EsS0FGRCxNQUlDLFlBQVksT0FBTyxDQUFQLEdBQVcsS0FBSyxJQUFMLENBQVUsS0FBSyxHQUFMLENBQVMsZ0JBQVQsRUFBMkIsQ0FBM0IsSUFBZ0MsS0FBSyxHQUFMLENBQVMsWUFBWSxPQUFPLENBQTVCLEVBQStCLENBQS9CLENBQTFDLENBQXZCOztBQUdELDJCQUF1QixPQUFPLENBQVAsR0FBVyxjQUFjLEtBQUssR0FBTCxDQUFTLFlBQVksUUFBckIsQ0FBaEQ7QUFDQSwyQkFBdUIsT0FBTyxDQUFQLEdBQVcsY0FBYyxLQUFLLEdBQUwsQ0FBUyxZQUFZLFFBQXJCLENBQWhEOztBQUVBLDZCQUF5QixLQUFLLElBQUwsQ0FBVSxLQUFLLEdBQUwsQ0FBUyxZQUFZLG9CQUFyQixFQUEyQyxDQUEzQyxJQUFnRCxLQUFLLEdBQUwsQ0FBUyxZQUFZLG9CQUFyQixFQUEyQyxDQUEzQyxDQUExRCxDQUF6Qjs7QUFFQSxpQ0FBNkIsS0FBSyxJQUFMLENBQVUsY0FBYyxnQkFBeEIsQ0FBN0I7O0FBRUE7QUFDQSxzQkFBa0IsS0FBSyxJQUFMLENBQVUsQ0FBQyxtQkFBbUIsZ0JBQW5CLEdBQXNDLGNBQWMsV0FBcEQsR0FBa0UseUJBQXlCLHNCQUE1RixLQUF1SCxJQUFJLFdBQUosR0FBa0IsZ0JBQXpJLENBQVYsQ0FBbEI7O0FBRUEsUUFBSSxrQkFBa0IsMEJBQXRCLEVBQWtEO0FBQ2pELG1CQUFjLFlBQVksWUFBWSxtQkFBWixDQUFnQyxDQUExRDtBQUNBO0FBQ0EsS0FIRCxNQUlLOztBQUVKLG1CQUFjLENBQWQ7O0FBRUE7O0FBRUE7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBRUE7QUFFRDs7QUFFRDs7QUFFQTs7QUFFQSxPQUFJLHFCQUFxQixzQkFBc0IsY0FBdEIsQ0FBekI7O0FBRUE7O0FBRUE7O0FBRUEsT0FBSSxxQkFBcUIsa0JBQWtCLGNBQWxCLENBQXpCOztBQUVBLE9BQUksZ0JBQUosRUFBc0IsbUJBQXRCLEVBQTJDLHNCQUEzQztBQUNBLE9BQUksdUJBQXVCLENBQTNCO0FBQ0EsT0FBSSw2QkFBNkIsQ0FBakM7O0FBR0EsT0FBSSxjQUFjLENBQWxCLEVBQXFCOztBQUVwQiwwQkFBc0IsWUFBWSxVQUFaLEtBQTJCLE9BQTNCLEdBQXFDLGtCQUFyQyxHQUEwRCxrQkFBaEY7O0FBRUEsbUJBQWUsV0FBZjs7QUFFQSxRQUFJLHdCQUF3QixJQUE1QixFQUFrQzs7QUFFakM7QUFDQTs7QUFFQSxTQUFJLGFBQWEsQ0FBQyxXQUFsQjs7QUFFQSxTQUFJLHlCQUEwQixZQUFZLG1CQUFaLENBQWdDLENBQWhDLEdBQW9DLFlBQVksbUJBQVosQ0FBZ0MsTUFBaEMsR0FBeUMsQ0FBOUUsSUFBb0YsYUFBYSxtQkFBYixFQUFrQyxtQkFBbEMsQ0FBc0QsQ0FBdEQsR0FBMEQsYUFBYSxtQkFBYixFQUFrQyxtQkFBbEMsQ0FBc0QsTUFBdEQsR0FBK0QsQ0FBN00sQ0FBN0I7O0FBRUEsU0FBSSx5QkFBeUIsVUFBekIsR0FBc0Msd0JBQTFDLEVBQW9FO0FBQ25FLDZCQUF1QixDQUFDLFVBQXhCO0FBQ0E7QUFDQSxtQ0FBNkIsaUJBQWlCLG1CQUFqQixFQUFzQyxvQkFBdEMsRUFBNEQsaUJBQWlCLENBQTdFLENBQTdCOztBQUVBO0FBQ0E7OztBQUdBLFVBQUksQ0FBQywyQkFBMkIsT0FBM0IsQ0FBbUMsU0FBbkMsQ0FBRCxHQUFpRCxDQUFDLHFCQUFxQixPQUFyQixDQUE2QixTQUE3QixDQUF0RCxFQUErRjs7QUFFOUYsV0FBSSx5QkFBeUIsd0JBQTdCLEVBQ0MsZUFBZSxFQUFFLHlCQUF5Qix3QkFBM0IsQ0FBZjtBQUNBO0FBQ0E7QUFIRCxZQUtDLGVBQWUsRUFBRSxjQUFjLDZCQUE2QixvQkFBM0MsQ0FBRixDQUFmO0FBQ0Q7O0FBRUQ7QUFDQTtBQUNBO0FBRUQ7QUFFRCxJQXhDRCxNQXdDTyxJQUFJLGNBQWMsQ0FBbEIsRUFBcUI7O0FBRTNCLDBCQUFzQixZQUFZLFVBQVosS0FBMkIsT0FBM0IsR0FBcUMsa0JBQXJDLEdBQTBELGtCQUFoRjs7QUFFQSxtQkFBZSxXQUFmOztBQUVBLFFBQUksd0JBQXdCLElBQTVCLEVBQWtDOztBQUVqQyxTQUFJLGFBQWEsV0FBakI7O0FBRUEsU0FBSSx5QkFBMEIsYUFBYSxtQkFBYixFQUFrQyxtQkFBbEMsQ0FBc0QsQ0FBdEQsR0FBMEQsYUFBYSxtQkFBYixFQUFrQyxtQkFBbEMsQ0FBc0QsTUFBdEQsR0FBK0QsQ0FBMUgsSUFBZ0ksWUFBWSxtQkFBWixDQUFnQyxDQUFoQyxHQUFvQyxZQUFZLG1CQUFaLENBQWdDLE1BQWhDLEdBQXlDLENBQTdNLENBQTdCOztBQUVBLFNBQUkseUJBQXlCLFVBQXpCLEdBQXNDLHdCQUExQyxFQUFvRTtBQUNuRSw2QkFBdUIsVUFBdkI7QUFDQTtBQUNBLG1DQUE2QixpQkFBaUIsbUJBQWpCLEVBQXNDLG9CQUF0QyxFQUE0RCxpQkFBaUIsQ0FBN0UsQ0FBN0I7O0FBRUEsVUFBSSxDQUFDLDJCQUEyQixPQUEzQixDQUFtQyxTQUFuQyxDQUFELEdBQWlELENBQUMscUJBQXFCLE9BQXJCLENBQTZCLFNBQTdCLENBQXRELEVBQStGOztBQUU5RixXQUFJLHlCQUF5Qix3QkFBN0IsRUFDQyxlQUFlLHlCQUF5Qix3QkFBeEM7QUFDQTtBQUNBO0FBSEQsWUFLQyxlQUFlLGNBQWMsdUJBQXVCLDBCQUFyQyxDQUFmO0FBQ0Q7QUFDRDtBQUVEOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFFQTs7QUFFRCxPQUFJLFlBQUosRUFBa0I7O0FBRWpCLFFBQUksWUFBWSxZQUFZLG1CQUFaLENBQWdDLENBQWhDLEdBQW9DLFlBQXBEOztBQUtBLFFBQUksWUFBWSxDQUFoQjs7QUFFQSxRQUFJLFlBQVksVUFBWixLQUEyQixPQUEvQixFQUF3QztBQUN2QyxpQkFBWSxPQUFPLENBQVAsR0FBVyxLQUFLLElBQUwsQ0FBVSxLQUFLLEdBQUwsQ0FBUyxnQkFBVCxFQUEyQixDQUEzQixJQUFnQyxLQUFLLEdBQUwsQ0FBUyxZQUFZLE9BQU8sQ0FBNUIsRUFBK0IsQ0FBL0IsQ0FBMUMsQ0FBdkI7QUFDQSxLQUZELE1BSUMsWUFBWSxPQUFPLENBQVAsR0FBVyxLQUFLLElBQUwsQ0FBVSxLQUFLLEdBQUwsQ0FBUyxnQkFBVCxFQUEyQixDQUEzQixJQUFnQyxLQUFLLEdBQUwsQ0FBUyxZQUFZLE9BQU8sQ0FBNUIsRUFBK0IsQ0FBL0IsQ0FBMUMsQ0FBdkI7O0FBRUQsUUFBSSxZQUFZLFFBQVosR0FBd0IsS0FBSyxFQUFMLEdBQVUsQ0FBWCxHQUFnQixvQkFBdkMsSUFBK0QsWUFBWSxRQUFaLEdBQXdCLEtBQUssRUFBTCxHQUFVLENBQVgsR0FBZ0Isb0JBQTFHLEVBQWdJOztBQUUvSCxTQUFJLGNBQWMsQ0FBQyxpQkFBaUIsQ0FBakIsR0FBcUIsYUFBYSxNQUFuQyxJQUE2QyxhQUFhLE1BQTVFO0FBQ0EsU0FBSSxTQUFTLGFBQWEsV0FBYixDQUFiO0FBQ0EsU0FBSSxTQUFTLGFBQWEsQ0FBQyxpQkFBaUIsQ0FBakIsR0FBcUIsYUFBYSxNQUFuQyxJQUE2QyxhQUFhLE1BQXZFLENBQWI7O0FBRUEsU0FBSSxZQUFZLFVBQVosS0FBMkIsTUFBM0IsSUFBcUMsT0FBTyxVQUFQLEtBQXNCLE9BQTNELElBQXNFLFlBQVksT0FBTyxtQkFBUCxDQUEyQixDQUFqSCxFQUFvSDtBQUNuSCxrQkFBWSxPQUFPLG1CQUFQLENBQTJCLENBQTNCLEdBQStCLEVBQTNDO0FBQ0EsTUFGRCxNQUVPLElBQUksWUFBWSxVQUFaLEtBQTJCLE9BQTNCLElBQXNDLE9BQU8sVUFBUCxLQUFzQixNQUE1RCxJQUFzRSxZQUFZLE9BQU8sbUJBQVAsQ0FBMkIsQ0FBakgsRUFBb0g7QUFDMUgsa0JBQVksT0FBTyxtQkFBUCxDQUEyQixDQUEzQixHQUErQixFQUEzQztBQUNBO0FBQ0QsS0FYRCxNQVdPLElBQUksWUFBWSxRQUFaLEdBQXdCLElBQUksS0FBSyxFQUFULEdBQWMsQ0FBZixHQUFvQixvQkFBM0MsSUFBbUUsWUFBWSxRQUFaLEdBQXdCLElBQUksS0FBSyxFQUFULEdBQWMsQ0FBZixHQUFvQixvQkFBbEgsRUFBd0k7O0FBRTlJLFNBQUksY0FBYyxDQUFDLGlCQUFpQixDQUFqQixHQUFxQixhQUFhLE1BQW5DLElBQTZDLGFBQWEsTUFBNUU7QUFDQSxTQUFJLFNBQVMsYUFBYSxXQUFiLENBQWI7QUFDQSxTQUFJLFNBQVMsYUFBYSxDQUFDLGlCQUFpQixDQUFqQixHQUFxQixhQUFhLE1BQW5DLElBQTZDLGFBQWEsTUFBdkUsQ0FBYjs7QUFFQSxTQUFJLFlBQVksVUFBWixLQUEyQixPQUEzQixJQUFzQyxPQUFPLFVBQVAsS0FBc0IsTUFBNUQsSUFBc0UsWUFBWSxPQUFPLG1CQUFQLENBQTJCLENBQWpILEVBQW9IO0FBQ25ILGtCQUFZLE9BQU8sbUJBQVAsQ0FBMkIsQ0FBM0IsR0FBK0IsRUFBM0M7QUFDQSxNQUZELE1BRU8sSUFBSSxZQUFZLFVBQVosS0FBMkIsTUFBM0IsSUFBcUMsT0FBTyxVQUFQLEtBQXNCLE9BQTNELElBQXNFLFlBQVksT0FBTyxtQkFBUCxDQUEyQixDQUFqSCxFQUFvSDtBQUMxSCxrQkFBWSxPQUFPLG1CQUFQLENBQTJCLENBQTNCLEdBQStCLEVBQTNDO0FBQ0E7QUFDRDs7QUFFRDtBQUNBOztBQUVBLGdCQUFZLG1CQUFaLENBQWdDLENBQWhDLEdBQW9DLFNBQXBDOztBQUVBLGdCQUFZLG1CQUFaLENBQWdDLENBQWhDLEdBQW9DLFNBQXBDOztBQUVBLGdCQUFZLGVBQVosR0FBOEIsS0FBSyxLQUFMLENBQVksWUFBWSxtQkFBWixDQUFnQyxDQUFoQyxHQUFvQyxPQUFPLENBQXZELEVBQTRELFlBQVksbUJBQVosQ0FBZ0MsQ0FBaEMsR0FBb0MsT0FBTyxDQUF2RyxDQUE5QjtBQUVBO0FBR0Q7O0FBRUQsU0FBTyxZQUFQO0FBQ0E7O0FBR0QsVUFBUyxjQUFULEdBQTBCO0FBQ3pCLE1BQUksTUFBTSxNQUFNLFFBQU4sQ0FBZSxHQUF6Qjs7QUFFQSxNQUFJLFNBQUosR0FBZ0IsTUFBaEI7QUFDQSxNQUFJLFdBQUosR0FBa0IsTUFBbEI7QUFDQSxNQUFJLFdBQVcsRUFBZjtBQUNBLE1BQUksSUFBSixHQUFXLFdBQVcsVUFBdEI7QUFDQSxNQUFJLFlBQUosR0FBbUIsUUFBbkI7QUFDQSxNQUFJLElBQUksQ0FBUjtBQUFBLE1BQVcsSUFBSSxDQUFmO0FBQ0EsTUFBSSxTQUFTLENBQWI7O0FBRUEsTUFBSSxhQUFhLElBQWpCOztBQVh5Qjs7QUFleEIsT0FBSSxXQUFXLE1BQVgsSUFBc0IsQ0FBQyxXQUFXLE1BQVosSUFBc0IsT0FBTyxXQUFXLFdBQWxCLEtBQWtDLFdBQXhELElBQXVFLFdBQVcsV0FBWCxLQUEyQixJQUFsRyxJQUEwRyxjQUFjLE1BQWQsSUFBd0IsV0FBNUosRUFDQyxhQUFhLEtBQWI7O0FBRUQsT0FBSSxVQUFKLEVBQ0EsZUFBZSxNQUFmOztBQUVBLFlBQVMsQ0FBVDs7QUFFQSxPQUFJLFdBQVcsbUJBQVgsS0FBbUMsUUFBdkMsRUFBaUQ7QUFFNUMsdUJBQW1CLGNBQWMsNkJBRlc7OztBQUloRCxTQUFLLElBQUksQ0FBVCxFQUFZLElBQUksV0FBVyxNQUEzQixFQUFtQyxHQUFuQyxFQUF3QztBQUNuQyxtQkFBYyxhQUFhLENBQWIsQ0FEcUI7OztBQUd2QyxpQkFBWSxtQkFBWixDQUFnQyxDQUFoQyxHQUFvQyxPQUFPLENBQVAsR0FBVyxtQkFBbUIsS0FBSyxHQUFMLENBQVMsWUFBWSxRQUFyQixDQUFsRTtBQUNBLGlCQUFZLG1CQUFaLENBQWdDLENBQWhDLEdBQW9DLE9BQU8sQ0FBUCxHQUFXLG1CQUFtQixLQUFLLEdBQUwsQ0FBUyxZQUFZLFFBQXJCLENBQWxFOztBQUVBLGlCQUFZLGVBQVosR0FBOEIsWUFBWSxRQUExQztBQUNBLGlCQUFZLE1BQVosR0FBcUIsV0FBckI7QUFDQSxpQkFBWSxrQkFBWixHQUFpQyxrQkFBakM7QUFDQTtBQUNBOztBQUdELFNBQUssSUFBSSxDQUFULEVBQVksSUFBSSxXQUFXLE1BQTNCLEVBQW1DLEdBQW5DLEVBQXdDO0FBRW5DLG1CQUFjLGFBQWEsQ0FBYixDQUZxQjtBQUd2QztBQUNBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBOztBQUVJLDBCQUFxQixrQkFBa0IsQ0FBbEIsQ0FiYzs7O0FBZXZDLFNBQUksdUJBQXVCLElBQTNCLEVBQ0M7O0FBRUQsd0JBQW1CLGFBQWEsQ0FBYixDQUFuQjtBQUNBLHFCQUFnQixhQUFhLGtCQUFiLENBQWhCOztBQUdJLDZCQUF3QixDQXRCVzs7QUF3QnZDO0FBQ0E7QUFDQTtBQUNBOztBQUVBLDZCQUF3QixpQ0FBaUMsZ0JBQWpDLEVBQW1ELGFBQW5ELElBQW9FLHdCQUE1Rjs7QUFHQSxTQUFJLHdCQUF3QixDQUE1QixFQUErQjtBQUUxQix3QkFBa0IsQ0FGUTtBQUcxQix3QkFBa0IsQ0FIUTtBQUk5Qjs7O0FBR0EsV0FBUyxJQUFJLENBQWIsRUFBZ0IsSUFBSSxXQUFXLE1BQS9CLEVBQXVDLEdBQXZDLEVBQTRDOztBQUUzQyxXQUFJLE1BQU0sQ0FBVixFQUNDOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFdBQUksYUFBYSxDQUFiLEVBQWdCLFVBQWhCLEtBQStCLFlBQVksVUFBL0MsRUFDQzs7QUFFRCxXQUFJLGFBQWEsQ0FBYixFQUFnQixtQkFBaEIsQ0FBb0MsQ0FBcEMsR0FBd0MsWUFBWSxtQkFBWixDQUFnQyxDQUE1RSxFQUNDLGtCQURELEtBR0M7QUFDRDs7QUFFRDtBQUNJLHNCQUFpQixxQkFBRCxJQUEyQixrQkFBa0IsZUFBbEIsSUFBcUMsQ0FBaEUsSUFBc0UsZUE1QjVEO0FBNkIxQix3QkFBa0IsQ0FBQyxDQUFELElBQU0sd0JBQXdCLGFBQTlCLENBN0JRO0FBK0IxQiwyQkFBcUIsQ0EvQks7QUFnQzFCLDZCQUF1QixDQWhDRzs7O0FBa0M5QixVQUFJLFlBQVksVUFBWixLQUEyQixPQUEvQixFQUF3QztBQUN2Qyw0QkFBcUIsaUJBQWlCLENBQWpCLEVBQW9CLGFBQXBCLENBQXJCOztBQUVBO0FBQ0E7OztBQUdBLHlCQUFrQixDQUFDLENBQUQsSUFBTSx3QkFBd0Isa0JBQTlCLENBQWxCOztBQUVBLDhCQUF1QixpQkFBaUIsa0JBQWpCLEVBQXFDLGVBQXJDLENBQXZCOztBQUVBO0FBQ0E7QUFDQSxXQUFJLENBQUMscUJBQXFCLE9BQXJCLENBQTZCLFNBQTdCLENBQUQsR0FBMkMsQ0FBQyxnQkFBZ0IsT0FBaEIsQ0FBd0IsU0FBeEIsQ0FBNUMsSUFBa0YsQ0FBQyxtQkFBbUIsT0FBbkIsQ0FBMkIsU0FBM0IsQ0FBRCxJQUEwQyxDQUFDLGNBQWMsT0FBZCxDQUFzQixTQUF0QixDQUFqSSxFQUNDLGlCQUFpQixDQUFqQixFQUFvQixFQUFFLGtCQUFrQixvQkFBcEIsQ0FBcEI7QUFFRCxPQWhCRCxNQWdCTztBQUNOLDRCQUFxQixpQkFBaUIsa0JBQWpCLEVBQXFDLGFBQXJDLENBQXJCOztBQUVBLHlCQUFrQixDQUFDLENBQUQsSUFBTSx3QkFBd0Isa0JBQTlCLENBQWxCOztBQUVBLDhCQUF1QixpQkFBaUIsQ0FBakIsRUFBb0IsZUFBcEIsQ0FBdkI7O0FBRUE7QUFDQSxXQUFJLENBQUMscUJBQXFCLE9BQXJCLENBQTZCLFNBQTdCLENBQUQsR0FBMkMsQ0FBQyxnQkFBZ0IsT0FBaEIsQ0FBd0IsU0FBeEIsQ0FBNUMsSUFBa0YsQ0FBQyxtQkFBbUIsT0FBbkIsQ0FBMkIsU0FBM0IsQ0FBRCxJQUEwQyxDQUFDLGNBQWMsT0FBZCxDQUFzQixTQUF0QixDQUFqSSxFQUNDLGlCQUFpQixrQkFBakIsRUFBcUMsRUFBRSxrQkFBa0Isb0JBQXBCLENBQXJDO0FBQ0Q7QUFDRDs7QUFHRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0QsSUF0SEQsTUFzSE87QUFDTixTQUFLLElBQUksQ0FBVCxFQUFZLElBQUksV0FBVyxNQUEzQixFQUFtQyxHQUFuQyxFQUF3QztBQUVuQyxtQkFBYyxhQUFhLENBQWIsQ0FGcUI7O0FBR3ZDLHdCQUFtQixXQUFXLElBQVgsS0FBb0IsS0FBcEIsR0FBNEIsY0FBYyxFQUExQyxHQUErQyxjQUFjLEVBQWhGOztBQUdJLFVBQUssT0FBTyxDQUFQLEdBQVcsbUJBQW9CLEtBQUssR0FBTCxDQUFVLFlBQVksUUFBdEIsQ0FORDtBQU9uQyxVQUFLLE9BQU8sQ0FBUCxHQUFXLG1CQUFvQixLQUFLLEdBQUwsQ0FBVSxZQUFZLFFBQXRCLENBUEQ7OztBQVN2QyxpQkFBWSxtQkFBWixDQUFnQyxDQUFoQyxHQUFvQyxFQUFwQztBQUNBLGlCQUFZLG1CQUFaLENBQWdDLENBQWhDLEdBQW9DLEVBQXBDO0FBQ0E7QUFDRDs7QUFFRDtBQUNBLFFBQUssSUFBSSxDQUFULEVBQVksSUFBSSxXQUFXLE1BQTNCLEVBQW1DLEdBQW5DLEVBQXdDOztBQUV2QyxrQkFBYyxhQUFhLENBQWIsQ0FBZDs7QUFFSSxXQUFPLFlBQVksbUJBQVosQ0FBZ0MsV0FBaEMsRUFKNEI7QUFLdkM7O0FBQ0EsUUFBSSxLQUFLLE1BQUwsS0FBZ0IsQ0FBaEIsSUFBcUIsS0FBSyxLQUFMLEtBQWUsQ0FBeEMsRUFDQzs7QUFFRyxnQkFBWSxDQVR1QjtBQVVuQyxVQUFNLENBVjZCOzs7QUFZdkMsUUFBSSxZQUFZLFVBQVosS0FBMkIsT0FBL0IsRUFBd0M7QUFDdkMsaUJBQVksU0FBUyxFQUFULElBQWUsWUFBWSxtQkFBWixDQUFnQyxDQUFoQyxHQUFvQyxZQUFZLG1CQUFaLENBQWdDLEtBQXBFLEdBQTRFLHdCQUEzRixDQUFaO0FBQ0Esa0JBQWEsQ0FBQyxDQUFkO0FBQ0EsS0FIRCxNQUdPO0FBQ04saUJBQVksU0FBUyxFQUFULElBQWUsWUFBWSxtQkFBWixDQUFnQyxDQUFoQyxHQUFvQyxZQUFZLG1CQUFaLENBQWdDLEtBQXBFLEdBQTRFLHdCQUEzRixDQUFaO0FBQ0E7QUFDRCxRQUFJLFlBQVksQ0FBaEIsRUFBbUI7QUFDbEIsU0FBSSxDQUFDLFVBQUQsSUFBZSxZQUFZLGNBQS9CLEVBQStDO0FBQzFDLDhCQUF3QixZQUFZLFVBQVosS0FBMkIsT0FBM0IsR0FBcUMsU0FBUyxFQUFULEdBQWMsWUFBWSxtQkFBWixDQUFnQyxDQUFuRixHQUF1RixZQUFZLG1CQUFaLENBQWdDLENBQWhDLEdBQW9DLFNBQVMsRUFEbEg7O0FBRTlDLGtCQUFZLG1CQUFaLENBQWdDLFFBQWhDLEdBQTJDLEVBQTNDLEdBQWdELHFCQUFoRCxHQUF3RSxZQUFZLGNBQVosR0FBNkIsRUFBckcsR0FBMEcsWUFBWSxtQkFBWixDQUFnQyxRQUFoQyxHQUEyQyx3QkFBd0IsR0FBN0s7QUFDQSxVQUFJLFlBQVksbUJBQVosQ0FBZ0MsUUFBaEMsR0FBMkMsRUFBM0MsR0FBZ0QscUJBQXBELEVBQTJFLFlBQVksbUJBQVosQ0FBZ0MsQ0FBaEMsSUFBcUMsWUFBWSxVQUFaLEtBQTJCLE9BQTNCLEdBQXFDLENBQXJDLEdBQXlDLENBQUMsQ0FBL0U7QUFDNUU7O0FBRUEsU0FBSSxLQUFLLEdBQUwsQ0FBUyxZQUFZLG1CQUFaLENBQWdDLENBQWhDLEdBQW9DLFlBQVksbUJBQVosQ0FBZ0MsTUFBaEMsR0FBeUMsQ0FBN0UsR0FBaUYsT0FBTyxDQUFqRyxJQUFzRyxXQUF0RyxJQUNBLEtBQUssR0FBTCxDQUFTLFlBQVksbUJBQVosQ0FBZ0MsQ0FBaEMsR0FBb0MsWUFBWSxtQkFBWixDQUFnQyxNQUFoQyxHQUF5QyxDQUE3RSxHQUFpRixPQUFPLENBQWpHLElBQXNHLFdBRDFHLEVBQ3VIOztBQUV0SCxZQUFNLFlBQVksS0FBSyxHQUFMLENBQVMsS0FBSyxHQUFMLENBQVMsWUFBWSxlQUFyQixDQUFULENBQWxCOztBQUVBLFVBQUksTUFBTSxDQUFWLEVBQ0MsTUFBTSxNQUFNLEVBQVo7O0FBRUQsVUFBSSxNQUFNLE1BQVYsRUFDQyxTQUFTLEdBQVQ7QUFDRDtBQUNEOztBQUVHLGdCQUFZLENBdEN1QjtBQXVDbkMsVUFBTSxDQXZDNkI7OztBQXlDdkMsUUFBSSxZQUFZLGVBQVosR0FBOEIsQ0FBOUIsSUFBbUMsWUFBWSxlQUFaLEdBQThCLEtBQUssRUFBMUUsRUFBOEU7QUFDN0UsaUJBQVksU0FBUyxFQUFULElBQWUsWUFBWSxtQkFBWixDQUFnQyxDQUFoQyxHQUFvQyxZQUFZLG1CQUFaLENBQWdDLE1BQWhDLEdBQXlDLENBQTdFLEdBQWlGLENBQWhHLENBQVo7QUFDQSxrQkFBYSxDQUFDLENBQWQ7QUFDQSxLQUhELE1BR087QUFDTixpQkFBWSxTQUFTLEVBQVQsSUFBZSxZQUFZLG1CQUFaLENBQWdDLENBQWhDLEdBQW9DLFlBQVksbUJBQVosQ0FBZ0MsTUFBaEMsR0FBeUMsQ0FBN0UsR0FBaUYsQ0FBaEcsQ0FBWjtBQUNBOztBQUVELFFBQUksWUFBWSxDQUFoQixFQUFtQjtBQUNsQixTQUFJLENBQUMsVUFBRCxJQUFlLFlBQVksY0FBL0IsRUFBK0M7QUFDMUMsMkJBQXFCLFlBQVksZUFBWixHQUE4QixDQUE5QixJQUFtQyxZQUFZLGVBQVosR0FBOEIsS0FBSyxFQUF0RSxHQUEyRSxDQUFDLENBQTVFLEdBQWdGLENBRDNEOztBQUU5QyxVQUFJLGlCQUFpQixDQUFqQixFQUFvQixZQUFZLGtCQUFoQyxNQUF3RCxDQUE1RCxFQUNDLGlCQUFpQixDQUFqQixFQUFvQixJQUFJLGtCQUF4QjtBQUNEO0FBQ0QsU0FBSSxLQUFLLEdBQUwsQ0FBUyxZQUFZLG1CQUFaLENBQWdDLENBQWhDLEdBQW9DLE9BQU8sQ0FBcEQsSUFBeUQsV0FBN0QsRUFBMEU7O0FBRXpFLFlBQU0sWUFBWSxLQUFLLEdBQUwsQ0FBUyxLQUFLLEdBQUwsQ0FBUyxZQUFZLGVBQXJCLENBQVQsQ0FBbEI7O0FBRUEsVUFBSSxNQUFNLENBQVYsRUFDQyxNQUFNLE1BQU0sRUFBWjs7QUFFRCxVQUFJLE1BQU0sTUFBVixFQUNDLFNBQVMsR0FBVDtBQUVEO0FBQ0Q7QUFFRDs7QUFFRCxZQUFTLDRCQUFULENBQXNDLFlBQXRDLEVBQW9ELFVBQXBELEVBQWdFLFFBQWhFLEVBQTBFOztBQUV6RSxRQUFJLFFBQVEsRUFBWjtBQUNBLFFBQUksMEJBQTBCLENBQTlCOztBQUVBLFNBQUssSUFBSSxJQUFJLFVBQWIsRUFBeUIsSUFBekIsRUFBK0IsSUFBSSxDQUFDLElBQUksQ0FBSixHQUFRLFdBQVcsTUFBcEIsSUFBOEIsV0FBVyxNQUE1RSxFQUFvRjtBQUNuRixXQUFNLElBQU4sQ0FBVyxhQUFhLENBQWIsQ0FBWDs7QUFFQSxTQUFJLE1BQU0sUUFBVixFQUNDO0FBQ0Q7O0FBRUQsVUFBTSxJQUFOLENBQVcsVUFBVSxNQUFWLEVBQWtCLE1BQWxCLEVBQTBCO0FBQ3BDLFlBQU8sT0FBTyxDQUFQLEdBQVcsT0FBTyxDQUF6QjtBQUNBLEtBRkQ7O0FBSUEsU0FBSyxJQUFJLENBQVQsRUFBWSxJQUFJLE1BQU0sTUFBdEIsRUFBOEIsR0FBOUIsRUFBbUM7QUFDbEMsU0FBSSxPQUFPLE1BQU0sQ0FBTixDQUFYOztBQUVBLFNBQUksMEJBQTBCLGVBQWUsRUFBN0MsRUFBaUQ7QUFDaEQsaUNBQTJCLEtBQUssbUJBQUwsQ0FBeUIsTUFBcEQ7QUFDQSxXQUFLLG1CQUFMLENBQXlCLElBQXpCLEdBQWdDLEVBQWhDO0FBQ0EsV0FBSyxjQUFMLEdBQXNCLEVBQXRCO0FBQ0EsV0FBSyxtQkFBTCxDQUF5QixXQUF6QjtBQUNBLE1BTEQsTUFNQztBQUNEO0FBRUQ7O0FBRUQ7QUFDQTtBQUNBO0FBQ0EsWUFBUyxVQUFULEdBQXNCO0FBQ3RCLFFBQUksb0JBQW9CLENBQUMsQ0FBekI7QUFDQSxRQUFJLGtCQUFrQixDQUFDLENBQXZCO0FBQ0EsUUFBSSxlQUFlLENBQW5CO0FBQ0MsUUFBSSxlQUFlLEtBQW5COztBQUVELFNBQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxXQUFXLE1BQS9CLEVBQXVDLEdBQXZDLEVBQTRDO0FBQzFDLG9CQUFlLEtBQWY7QUFDRCx3QkFBbUIsYUFBYSxDQUFiLENBQW5COztBQUVBLFNBQUksQ0FBQyxpQkFBaUIsY0FBdEIsRUFDQzs7QUFFRCxTQUFJLGlCQUFpQixrQkFBa0IsQ0FBbEIsQ0FBckI7QUFDQSxTQUFJLG1CQUFtQixJQUF2QixFQUNDOztBQUVELFNBQUksZ0JBQWdCLGFBQWEsY0FBYixDQUFwQjs7QUFFQSw2QkFBd0IsQ0FBeEI7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsNkJBQXdCLGlDQUFpQyxnQkFBakMsRUFBbUQsYUFBbkQsQ0FBeEI7O0FBRUEsU0FBSSx3QkFBd0IsQ0FBeEIsSUFBNkIsc0JBQXNCLGdCQUF0QixFQUF3QyxhQUF4QyxDQUFqQyxFQUF5RjtBQUN2RjtBQUNELFVBQUksb0JBQW9CLENBQXhCLEVBQ0Msb0JBQW9CLENBQXBCOztBQUVBLFVBQUksbUJBQW1CLGlCQUF2QixFQUEwQztBQUMxQyx5QkFBa0IsY0FBbEI7O0FBRUQsdUJBQWdCLENBQUMscUJBQWpCO0FBQ0U7O0FBRUQsVUFBSSxJQUFJLEtBQUssR0FBTCxDQUFTLFdBQVcsTUFBWCxHQUFvQixFQUE3QixFQUFpQyxDQUFqQyxDQUFKLEtBQTRDLENBQWhELEVBQ0MsZUFBZSxJQUFmOztBQUVGO0FBQ0E7QUFDQTtBQUNBLE1BakJELE1BaUJPOztBQUVMLHFCQUFlLElBQWY7QUFDQTs7QUFFRCxTQUFJLFlBQUosRUFBa0I7O0FBRWpCLFVBQUksZUFBZSxDQUFmLElBQW9CLHFCQUFxQixDQUF6QyxJQUE4QyxtQkFBbUIsQ0FBckUsRUFBd0U7QUFDeEUsb0NBQTZCLFlBQTdCLEVBQTJDLGlCQUEzQyxFQUE4RCxlQUE5RDs7QUFFQSwyQkFBb0IsQ0FBQyxDQUFyQjtBQUNBLHlCQUFrQixDQUFDLENBQW5CO0FBQ0Esc0JBQWUsQ0FBZjtBQUNBO0FBQ0Q7QUFDRDs7QUFFRCxRQUFJLGVBQWUsQ0FBbkIsRUFDQyw2QkFBNkIsWUFBN0IsRUFBMkMsaUJBQTNDLEVBQThELGVBQTlEO0FBQ0E7O0FBRUQ7QUFyVXdCOztBQWF6QixPQUFLLElBQUksQ0FBVCxFQUFZLElBQUksRUFBSixLQUFXLElBQUksQ0FBSixJQUFTLFNBQVMsQ0FBN0IsQ0FBWixFQUE4QyxHQUE5QyxFQUFtRDtBQUFBLE9BWTdDLGdCQVo2QztBQUFBLE9BZTVDLFdBZjRDO0FBQUEsT0EwQjdDLGdCQTFCNkMsRUEwQjNCLGFBMUIyQjtBQUFBLE9BNkI1QyxXQTdCNEM7QUFBQSxPQXdDNUMsa0JBeEM0QztBQUFBLE9BaUQ1QyxxQkFqRDRDO0FBQUEsT0E2RDNDLGVBN0QyQztBQUFBLE9BOEQzQyxlQTlEMkM7QUFBQSxPQWtFdEMsQ0FsRXNDO0FBQUEsT0F1RjNDLGFBdkYyQztBQUFBLE9Bd0YzQyxlQXhGMkM7QUFBQSxPQTBGM0Msa0JBMUYyQztBQUFBLE9BMkYzQyxvQkEzRjJDO0FBQUEsT0FtSTVDLFdBbkk0QztBQUFBLE9BdUk1QyxFQXZJNEM7QUFBQSxPQXdJNUMsRUF4STRDO0FBQUEsT0FvSjdDLElBcEo2QztBQUFBLE9BeUo3QyxTQXpKNkM7QUFBQSxPQTBKN0MsR0ExSjZDO0FBQUEsT0FvSzNDLHFCQXBLMkM7QUFBQSxPQXNMN0MsU0F0TDZDO0FBQUEsT0F1TDdDLEdBdkw2QztBQUFBLE9Ba00zQyxrQkFsTTJDOztBQUFBO0FBMlRsRDtBQUNEOzs7QUFHQTtBQUNBOztBQUVBO0FBQ0E7O0FBR0QsTUFBSyx1QkFBTCxHQUErQixVQUFVLENBQVYsRUFBYTs7QUFFM0MsTUFBSSxNQUFNLFdBQVYsRUFBdUI7QUFDdEI7QUFDQTs7QUFFRCxNQUFJLElBQUksRUFBRSxjQUFWO0FBQ0EsTUFBSSxZQUFZLEVBQUUsU0FBbEI7QUFDQSxNQUFJLGFBQWEsSUFBakI7O0FBR0EsTUFBSSxLQUFLLFdBQVcsWUFBWCxDQUF3QixDQUF4QixDQUFUOztBQUVBOztBQUVBLE1BQUksVUFBVSxRQUFkLEVBQ0MsVUFBVSxRQUFWLEdBQXFCLEtBQXJCLENBREQsS0FHQyxVQUFVLFFBQVYsR0FBcUIsSUFBckI7O0FBR0Q7QUFDQSxNQUFJLFdBQVcsVUFBWCxDQUFzQixNQUF0QixHQUErQixDQUFuQyxFQUFzQztBQUNyQyxTQUFNLFNBQU4sQ0FBZ0IsT0FBaEIsQ0FBd0IsQ0FBeEIsRUFBMkIsZUFBM0IsRUFBNEMsVUFBVSxnQkFBVixFQUE0Qjs7QUFFdkUsa0JBQWMsZ0JBQWQ7QUFDQTtBQUNBO0FBRUEsSUFORDtBQU9BOztBQUVEO0FBQ0EsRUFqQ0Q7O0FBbUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBLE1BQUssY0FBTCxHQUFzQixJQUF0QjtBQUNBLE1BQUssU0FBTCxDQUFlLE9BQWYsQ0FBdUIsQ0FBdkIsRUFBMEIsS0FBSyxjQUFMLEdBQXNCLEtBQUssaUJBQTNCLEdBQStDLENBQXpFLEVBQTRFLFVBQVUsZ0JBQVYsRUFBNEI7O0FBRXZHLFVBQVEsZ0JBQVI7QUFDQTtBQUVBLEVBTEQsRUFLRyxZQUFZOztBQUVkLFFBQU0sY0FBTixHQUF1QixLQUF2QjtBQUNBLFFBQU0sU0FBTixDQUFnQixPQUFoQixDQUF3QixDQUF4QixFQUEyQixNQUFNLGNBQU4sR0FBdUIsZUFBdkIsR0FBeUMsQ0FBcEUsRUFBdUUsVUFBVSxnQkFBVixFQUE0Qjs7QUFFbEcsaUJBQWMsZ0JBQWQ7QUFDQTtBQUVBLEdBTEQ7O0FBT0E7QUFDQSxFQWhCRDs7QUFrQkEsVUFBUyw2QkFBVCxHQUF5Qzs7QUFFeEMsUUFBTSxRQUFOLENBQWUsYUFBZixDQUE2QixLQUE3Qjs7QUFFQSxNQUFJLE1BQU0sTUFBVixFQUFrQjtBQUNqQixPQUFJLE1BQU0sTUFBTixDQUFhLGtCQUFiLElBQW9DLE1BQU0sTUFBTixDQUFhLGVBQWIsS0FBaUMsUUFBakMsSUFBNkMsTUFBTSxNQUFOLENBQWEsYUFBYixLQUErQixRQUFwSCxFQUNDLE1BQU0sTUFBTixDQUFhLE1BQWI7QUFFRDs7QUFFRCxNQUFJLE1BQU0sU0FBVixFQUNDLEtBQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxNQUFNLFNBQU4sQ0FBZ0IsTUFBcEMsRUFBNEMsR0FBNUMsRUFBaUQ7QUFDaEQsT0FBSSxXQUFXLE1BQU0sU0FBTixDQUFnQixDQUFoQixDQUFmO0FBQ0EsT0FBSSxTQUFTLGtCQUFULElBQWdDLFNBQVMsZUFBVCxLQUE2QixRQUE3QixJQUF5QyxTQUFTLGFBQVQsS0FBMkIsUUFBeEcsRUFDQyxTQUFTLE1BQVQ7QUFDRDs7QUFFRixNQUFJLE1BQU0sTUFBVixFQUFrQjtBQUNqQixPQUFJLE1BQU0sTUFBTixDQUFhLGtCQUFiLElBQW9DLE1BQU0sTUFBTixDQUFhLGVBQWIsS0FBaUMsUUFBakMsSUFBNkMsTUFBTSxNQUFOLENBQWEsYUFBYixLQUErQixRQUFwSCxFQUNDLE1BQU0sTUFBTixDQUFhLE1BQWI7QUFDRDtBQUNEOztBQUVEO0FBQ0EsQzs7QUFqbUNEOzs7O0FBQ0E7Ozs7Ozs7Ozs7O2tCQ0NlLFVBQVUsUUFBVixFQUFvQjtBQUNsQyxLQUFJLE1BQU0sU0FBUyxlQUFULElBQTRCLEtBQUssUUFBTCxDQUFjLEdBQXBEO0FBQ0EsS0FBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixNQUFqRDs7QUFFQSxLQUFJLG1CQUFtQixDQUF2QixFQUNDOztBQUVELEtBQUksV0FBVyxLQUFLLGFBQUwsQ0FBbUIsUUFBbEM7O0FBRUEsS0FBSSxhQUFhLFNBQVMsS0FBVCxDQUFlLGVBQWhDO0FBQ0EsS0FBSSxhQUFhLFNBQVMsS0FBVCxDQUFlLGVBQWhDO0FBQ0EsS0FBSSxVQUFVLEVBQWQ7O0FBRUEsS0FBSSxXQUFXLEtBQUssUUFBcEI7QUFDQSxLQUFJLElBQUo7O0FBRUEsS0FBSSx3QkFBSixFQUNDLFNBQVMsSUFBVDs7QUFFRCxLQUFJLFNBQUo7QUFDQSxLQUFJLElBQUosQ0FBUyxTQUFTLEVBQWxCLEVBQXNCLFNBQVMsRUFBL0IsRUFBbUMsU0FBUyxLQUE1QyxFQUFtRCxTQUFTLE1BQTVEO0FBQ0EsS0FBSSxJQUFKOztBQUVBLEtBQUksd0JBQUosRUFBdUI7QUFDdEIsV0FBUyxTQUFUO0FBQ0EsV0FBUyxJQUFULENBQWMsU0FBUyxFQUF2QixFQUEyQixTQUFTLEVBQXBDLEVBQXdDLFNBQVMsS0FBakQsRUFBd0QsU0FBUyxNQUFqRTtBQUNBLFdBQVMsSUFBVDtBQUNBOztBQUVELE1BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxTQUFTLGlCQUFULENBQTJCLE1BQS9DLEVBQXVELEdBQXZELEVBQTREOztBQUUzRCxNQUFJLGNBQWMsRUFBbEI7O0FBRUEsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0Qjs7QUFFQSxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsZUFBVixDQUFqQjs7QUFFQSxNQUFJLGFBQWEsV0FBVyxVQUE1Qjs7QUFFQSxNQUFJLFdBQVcsV0FBVyxFQUExQjtBQUNBLE9BQUssYUFBTCxDQUFtQixTQUFuQixDQUE2QixRQUE3QixJQUF5QztBQUN4QyxlQUFZLFlBRDRCLEVBQ2QsaUJBQWlCO0FBREgsR0FBekM7O0FBSUEsTUFBSSxXQUFXLG9CQUFvQixRQUFwQixDQUFmO0FBQ0EsV0FBUyxTQUFULEdBQXFCLFFBQXJCO0FBQ0E7QUFDQTs7QUFFQSxZQUFVLEVBQVY7O0FBRUEsTUFBSSw2QkFBNkIsSUFBakM7QUFDQSxNQUFJLElBQUksQ0FBUjtBQUFBLE1BQVcsQ0FBWDtBQUFBLE1BQWMsRUFBZDtBQUFBLE1BQWtCLEVBQWxCO0FBQ0EsTUFBSSxVQUFKLENBeEIyRCxDQXdCM0M7O0FBRWhCLE1BQUksZUFBZ0IsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsSUFBSSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUE1RixDQUFoRCxHQUF1SixFQUF4SixJQUErSixDQUFsTDtBQUNBLE1BQUksS0FBSjs7QUFFQSxNQUFJLGFBQWEsSUFBakI7O0FBRUEsTUFBSSxXQUFXLE1BQVgsR0FBb0IsQ0FBeEIsRUFBMkI7QUFDMUI7QUFDQSxPQUFJLFFBQVEsV0FBVyxTQUFYLENBQXFCLElBQUksV0FBVyxTQUFYLENBQXFCLE1BQTlDLENBQVo7QUFDQTtBQUNBLE9BQUksU0FBSixHQUFnQixLQUFoQjtBQUNBLE9BQUksV0FBSixHQUFrQixLQUFsQjtBQUNBLE9BQUksU0FBSixHQUFnQixXQUFXLGFBQTNCOztBQUVBLE9BQUksSUFBSSxXQUFSLEVBQXFCO0FBQ3BCLFFBQUksV0FBSixDQUFnQixpQkFBaUIsV0FBVyxZQUE1QixFQUEwQyxXQUFXLGFBQXJELENBQWhCO0FBQ0E7O0FBRUQsT0FBSSxlQUFlLElBQW5CO0FBQ0EsVUFBTyxJQUFJLFdBQVcsTUFBdEIsRUFBOEIsR0FBOUIsRUFBbUM7O0FBRWxDLGlCQUFhLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsR0FBMEIsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixFQUExQixHQUFzRCxXQUFXLENBQVgsRUFBYyxDQUFqRjs7QUFFQSxRQUFJLGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUFyQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBN0YsRUFBMEc7QUFDekc7QUFDQTs7QUFFRCxRQUFJLFdBQVcsQ0FBWCxFQUFjLENBQWQsS0FBb0IsSUFBcEIsSUFBNEIsQ0FBQyxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLE1BQTdDLElBQ0EsT0FBUSxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLENBQVIsS0FBZ0MsUUFEaEMsSUFDNEMsT0FBUSxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLENBQVIsS0FBZ0MsUUFEaEYsRUFDMEY7O0FBRXpGOztBQUVBLG9CQUFlLElBQWY7QUFDQTtBQUNBOztBQUVELFFBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUFyRyxDQUFoRCxHQUFnSyxFQUFqSyxJQUF3SyxDQUE1Szs7QUFFQSxTQUFNLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsSUFBcUIsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBN0csQ0FBaEQsR0FBd0ssRUFBekssSUFBZ0wsQ0FBckw7QUFDQSxTQUFNLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsSUFBcUIsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBN0csQ0FBaEQsR0FBd0ssRUFBekssSUFBZ0wsQ0FBckw7O0FBRUEsUUFBSSw4QkFBOEIsWUFBbEMsRUFBZ0Q7QUFDL0MsU0FBSSxTQUFKO0FBQ0EsU0FBSSxNQUFKLENBQVcsQ0FBWCxFQUFjLEVBQWQ7QUFDQSxrQkFBYTtBQUNaLFNBQUcsQ0FEUyxFQUNOLEdBQUc7QUFERyxNQUFiO0FBR0EsbUJBQWMsRUFBZDtBQUNBLGlCQUFZLElBQVosQ0FBaUIsRUFBRSxHQUFHLENBQUwsRUFBUSxHQUFHLEVBQVgsRUFBakI7O0FBRUEsU0FBSSx3QkFBSixFQUF1QjtBQUN0QixlQUFTLFNBQVQ7QUFDQSxlQUFTLE1BQVQsQ0FBZ0IsQ0FBaEIsRUFBbUIsRUFBbkI7QUFDQTs7QUFFRCxrQ0FBNkIsS0FBN0I7QUFDQSxvQkFBZSxLQUFmO0FBQ0EsS0FoQkQsTUFpQks7O0FBRUosU0FBSSxNQUFKLENBQVcsQ0FBWCxFQUFjLEVBQWQ7QUFDQSxpQkFBWSxJQUFaLENBQWlCLEVBQUUsR0FBRyxDQUFMLEVBQVEsR0FBRyxFQUFYLEVBQWpCOztBQUVBLFNBQUksd0JBQUosRUFDQyxTQUFTLE1BQVQsQ0FBZ0IsQ0FBaEIsRUFBbUIsRUFBbkI7O0FBRUQsU0FBSSxJQUFJLEdBQUosSUFBVyxDQUFmLEVBQWtCO0FBQ2pCO0FBQ0E7QUFDRDs7QUFHRCxRQUFJLEtBQUssV0FBVyxZQUFYLENBQXdCLENBQXhCLENBQVQ7QUFDQSxTQUFLLGFBQUwsQ0FBbUIsU0FBbkIsQ0FBNkIsRUFBN0IsSUFBbUM7QUFDbEMsU0FBSSxFQUQ4QixFQUMxQixZQUFZLFdBRGMsRUFDRCxpQkFBaUIsZUFEaEIsRUFDaUMsZ0JBQWdCLENBRGpELEVBQ29ELElBQUksQ0FEeEQsRUFDMkQsSUFBSSxFQUQvRCxFQUNtRSxJQUFJO0FBRHZFLEtBQW5DOztBQUlBO0FBQ0EsUUFBSSxXQUFXLENBQVgsRUFBYyxVQUFkLEtBQTZCLENBQWpDLEVBQW9DO0FBQ25DLFNBQUksV0FBVyxDQUFYLEVBQWMsVUFBZCxHQUEyQixDQUEzQixJQUFnQyxXQUFXLFVBQVgsR0FBd0IsQ0FBNUQsRUFBK0Q7QUFDOUQsVUFBSSxjQUFjLFdBQVcsbUJBQVgsQ0FBK0IsQ0FBL0IsRUFBa0MsQ0FBbEMsRUFBcUMsRUFBckMsRUFBeUMsR0FBekMsQ0FBbEI7QUFDQSxjQUFRLElBQVIsQ0FBYSxXQUFiOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSxVQUFJLGNBQWMsb0JBQW9CLEVBQXBCLENBQWxCOztBQUVBLFVBQUksd0JBQUosRUFBdUI7QUFDdEIsZUFBUSxJQUFSLENBQWE7QUFDWixXQUFHLENBRFMsRUFDTixHQUFHLEVBREcsRUFDQyxLQUFLLFFBRE47QUFFWixjQUFNLFlBQVksSUFGTjtBQUdaLGNBQU0sWUFBWSxJQUhOO0FBSVosZUFBTyxXQUpLO0FBS1oscUJBQWEsV0FMRDtBQU1aLHlCQUFpQixZQUFZO0FBTmpCLFFBQWI7QUFRQTs7QUFFRCxvQkFBYyxXQUFXLG1CQUFYLENBQStCLENBQS9CLEVBQWtDLENBQWxDLEVBQXFDLEVBQXJDLEVBQXlDLEdBQXpDLENBQWQ7QUFDQSxjQUFRLElBQVIsQ0FBYSxXQUFiOztBQUlBLFVBQUksY0FBYyxvQkFBb0IsRUFBcEIsQ0FBbEI7O0FBRUEsVUFBSSx3QkFBSixFQUF1QjtBQUN0QixlQUFRLElBQVIsQ0FBYTtBQUNaLFdBQUcsQ0FEUyxFQUNOLEdBQUcsRUFERyxFQUNDLEtBQUssUUFETjtBQUVaLGNBQU0sWUFBWSxJQUZOO0FBR1osY0FBTSxZQUFZLElBSE47QUFJWixlQUFPLFdBSks7QUFLWixxQkFBYSxXQUxEO0FBTVoseUJBQWlCLFlBQVk7QUFOakIsUUFBYjtBQVFBO0FBQ0Q7QUFDRDs7QUFFRCxRQUFJLFdBQVcsQ0FBWCxFQUFjLFVBQWQsSUFBNEIsV0FBVyxVQUF2QyxJQUFxRCxXQUFXLENBQVgsRUFBYyxtQkFBbkUsSUFBMEYsV0FBVyxtQkFBekcsRUFBOEg7O0FBRTdILFVBQUssWUFBTCxDQUFrQixJQUFsQixDQUF1QjtBQUN0QixpQkFBVyxXQURXO0FBRXRCLGlCQUFXLFdBQVcsQ0FBWCxDQUZXO0FBR3RCLGtCQUFZLFVBSFU7QUFJdEIsb0JBQWMsQ0FKUTtBQUt0QixhQUFPO0FBQ04sVUFBRyxDQURHLEVBQ0EsR0FBRztBQURILE9BTGU7QUFRdEIsaUJBQVcsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixLQUFzQixXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLENBQXRCLEdBQTJDLENBQUMsQ0FBNUMsR0FBZ0QsQ0FSckM7QUFTdEIsYUFBTztBQVRlLE1BQXZCOztBQVlBLFVBQUssWUFBTCxDQUFrQixJQUFsQixDQUF1QjtBQUN0QixpQkFBVyxXQURXO0FBRXRCLGlCQUFXLFdBQVcsQ0FBWCxDQUZXO0FBR3RCLGtCQUFZLFVBSFU7QUFJdEIsb0JBQWMsQ0FKUTtBQUt0QixhQUFPO0FBQ04sVUFBRyxDQURHLEVBQ0EsR0FBRztBQURILE9BTGU7QUFRdEIsaUJBQVcsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixLQUFzQixXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLENBQXRCLEdBQTJDLENBQTNDLEdBQStDLENBQUMsQ0FSckM7QUFTdEIsYUFBTztBQVRlLE1BQXZCO0FBWUE7O0FBRUQ7QUFDQTs7QUFFRDs7QUFFQTtBQUNBLGdCQUFhLFdBQWIsQ0FBeUIsT0FBekI7QUFDQTtBQUNEOztBQUVELEtBQUksT0FBSjtBQUNBLEtBQUksd0JBQUosRUFDQyxLQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsT0FBNUI7O0FBRUQsVUFBUyxTQUFULEdBQXFCOztBQUVwQixNQUFJLENBQUMsVUFBTCxFQUNDOztBQUVELE1BQUksUUFBUSxJQUFaOztBQUVBLE1BQUksV0FBVyxhQUFYLEdBQTJCLENBQS9CLEVBQ0MsSUFBSSxNQUFKOztBQUVELE9BQUssSUFBSSxJQUFJLFlBQVksTUFBWixHQUFxQixDQUFsQyxFQUFxQyxLQUFLLENBQTFDLEVBQTZDLEdBQTdDLEVBQWtEO0FBQ2pELFdBQVEsWUFBWSxDQUFaLENBQVI7QUFDQSxPQUFJLE1BQUosQ0FBVyxNQUFNLENBQWpCLEVBQW9CLE1BQU0sQ0FBMUI7QUFDQSxZQUFTLE1BQVQsQ0FBZ0IsTUFBTSxDQUF0QixFQUF5QixNQUFNLENBQS9CO0FBQ0E7O0FBSUQsTUFBSSxTQUFKO0FBQ0E7O0FBRUEsTUFBSSxXQUFKLEdBQWtCLFdBQVcsV0FBN0I7QUFDQSxNQUFJLElBQUo7QUFDQSxNQUFJLFdBQUosR0FBa0IsQ0FBbEI7O0FBRUEsV0FBUyxJQUFUOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSxNQUFJLFdBQVcsYUFBWCxHQUEyQixDQUEvQixFQUFrQztBQUNqQyxPQUFJLFNBQUo7QUFDQSxPQUFJLE1BQUosQ0FBVyxNQUFNLENBQWpCLEVBQW9CLE1BQU0sQ0FBMUI7QUFDQSxRQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksWUFBWSxNQUFoQyxFQUF3QyxHQUF4QyxFQUE2QztBQUM1QyxZQUFRLFlBQVksQ0FBWixDQUFSO0FBQ0EsUUFBSSxNQUFKLENBQVcsTUFBTSxDQUFqQixFQUFvQixNQUFNLENBQTFCO0FBQ0E7O0FBRUQsT0FBSSxNQUFKO0FBQ0E7O0FBR0QsTUFBSSxTQUFKO0FBQ0EsTUFBSSxNQUFKLENBQVcsQ0FBWCxFQUFjLEVBQWQ7QUFDQSxXQUFTLFNBQVQ7QUFDQSxXQUFTLE1BQVQsQ0FBZ0IsQ0FBaEIsRUFBbUIsRUFBbkI7O0FBRUEsZUFBYTtBQUNaLE1BQUcsQ0FEUyxFQUNOLEdBQUc7QUFERyxHQUFiO0FBR0EsZ0JBQWMsRUFBZDtBQUNBLGNBQVksSUFBWixDQUFpQixFQUFFLEdBQUcsQ0FBTCxFQUFRLEdBQUcsRUFBWCxFQUFqQjtBQUNBOztBQUVEO0FBQ0E7QUFDQSxLQUFJLGdCQUFnQjtBQUNuQixVQUFRLEdBRFcsRUFDTixNQUFNLEtBQUssUUFBTCxDQUFjLEdBRGQsRUFDbUIsbUJBQW1CLGdCQUFnQixjQUR0RCxFQUNzRSxnQkFBZ0IsZ0JBQWdCLE1BQWhCLENBQXVCLE1BRDdHLEVBQ3FILGVBQWU7QUFEcEksRUFBcEI7QUFHQSxRQUFPLGFBQVA7QUFDQSxDOztBQTFSRDs7Ozs7Ozs7O2tCQ0VlLFVBQVUsUUFBVixFQUFvQjtBQUNsQyxLQUFJLE1BQU0sU0FBUyxlQUFULElBQTRCLEtBQUssUUFBTCxDQUFjLEdBQXBEO0FBQ0EsS0FBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixNQUFqRDs7QUFFQSxLQUFJLG1CQUFtQixDQUF2QixFQUNDOztBQUVELEtBQUksUUFBUSxJQUFaOztBQUVBLEtBQUksV0FBVyxLQUFLLFFBQXBCOztBQUVBLEtBQUksSUFBSSxDQUFSO0FBQUEsS0FBVyxFQUFYO0FBQUEsS0FBZSxFQUFmO0FBQUEsS0FBbUIsQ0FBbkI7QUFDQSxLQUFJLFVBQUosQ0Faa0MsQ0FZbEI7O0FBRWhCO0FBQ0EsS0FBSSxlQUFnQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxJQUFJLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQTVGLENBQWpELElBQTBKLENBQTdLOztBQUVBLEtBQUksY0FBYyxLQUFLLGlCQUFMLEdBQXlCLEtBQUssaUJBQTlCLEdBQWtELEtBQUssR0FBTCxDQUFVLEtBQUssTUFBTCxHQUFjLEdBQXhCLEVBQThCLEtBQUssUUFBTCxDQUFjLE1BQWQsR0FBdUIsU0FBUyxRQUFULENBQWtCLGVBQXpDLEdBQTJELEVBQXpGLEtBQWdHLENBQXBLO0FBQ0EsS0FBSSxXQUFXLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsT0FBdkM7QUFDQTs7QUFFQSxLQUFJLFdBQWMsU0FBUyxNQUFULEdBQWtCLEtBQUssR0FBTCxDQUFTLFNBQVMsS0FBVCxDQUFlLGVBQWYsR0FBaUMsU0FBUyxLQUFULENBQWUsZUFBekQsQ0FBbkIsR0FBZ0csS0FBSyxHQUFMLENBQVMsUUFBVCxDQUFqRyxHQUF1SCxTQUFTLFFBQVQsQ0FBa0IsZUFBekksR0FBMkosRUFBNUosSUFBbUssQ0FBbEw7O0FBRUEsS0FBSSxXQUFXLFdBQWYsRUFDQyxXQUFXLFdBQVgsQ0FERCxLQUVLLElBQUksYUFBYSxRQUFqQixFQUEyQjtBQUMvQixhQUFXLGNBQWMsU0FBUyxRQUFULENBQWtCLGVBQWhDLEdBQWtELEVBQTdEO0FBQ0EsRUFGSSxNQUVFLElBQUksV0FBVyxDQUFmLEVBQ04sV0FBVyxDQUFYOztBQUVELEtBQUksSUFBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQ0MsS0FBSyxhQUFMLENBQW1CLFFBQW5CLENBQTRCLElBQTVCOztBQUVELEtBQUksU0FBSjtBQUNBLEtBQUksSUFBSixDQUFTLFNBQVMsRUFBbEIsRUFBc0IsU0FBUyxFQUEvQixFQUFtQyxTQUFTLEtBQTVDLEVBQW1ELFNBQVMsTUFBNUQ7QUFDQSxLQUFJLElBQUo7O0FBRUEsS0FBSSx3QkFBSixFQUF1QjtBQUN0QixPQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsSUFBNUIsQ0FBaUMsU0FBUyxFQUExQyxFQUE4QyxTQUFTLEVBQXZELEVBQTJELFNBQVMsS0FBcEUsRUFBMkUsU0FBUyxNQUFwRjtBQUNBLE9BQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixJQUE1QjtBQUNBOztBQUVELE1BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxTQUFTLGlCQUFULENBQTJCLE1BQS9DLEVBQXVELEdBQXZELEVBQTREOztBQUUzRCxNQUFJLGtCQUFrQixTQUFTLGlCQUFULENBQTJCLENBQTNCLENBQXRCOztBQUVBLE1BQUksYUFBYSxLQUFLLElBQUwsQ0FBVSxlQUFWLENBQWpCO0FBQ0EsTUFBSSxhQUFhLFdBQVcsVUFBNUI7QUFDQSxNQUFJLDZCQUE2QixJQUFqQzs7QUFHQTs7O0FBR0EsTUFBSSxXQUFXLE1BQVgsR0FBb0IsQ0FBeEIsRUFBMkI7QUFDMUI7O0FBRUEsT0FBSSxlQUFnQixXQUFXLENBQVosSUFBa0IsV0FBVyxZQUE3QixHQUE0QyxJQUE1QyxHQUFtRCxLQUF0RTs7QUFFQSxPQUFJLFdBQUosR0FBa0IsVUFBbEI7O0FBRUEsUUFBSyxJQUFJLENBQVQsRUFBWSxJQUFJLFdBQVcsTUFBM0IsRUFBbUMsR0FBbkMsRUFBd0M7O0FBRXZDLGVBQVcsQ0FBWCxFQUFjLE9BQWQsR0FBd0IsYUFBYSxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLE9BQWhCLEVBQXJDLEdBQWlFLGFBQWEsV0FBVyxDQUFYLEVBQWMsQ0FBNUY7O0FBRUEsUUFBSSxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBckMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLFdBQTdGLEVBQTBHO0FBQ3pHO0FBQ0E7O0FBRUQsUUFBSSxXQUFXLENBQVgsRUFBYyxDQUFkLEtBQW9CLElBQXBCLElBQTRCLENBQUMsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixNQUE3QyxJQUNBLE9BQVEsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixDQUFSLEtBQWdDLFFBRGhDLElBQzRDLE9BQVEsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixDQUFSLEtBQWdDLFFBRGhGLEVBRUM7O0FBRUQ7QUFDQSxTQUFNLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsSUFBcUIsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBN0csQ0FBaEQsR0FBd0ssRUFBekssSUFBZ0wsQ0FBckw7QUFDQSxTQUFNLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsSUFBcUIsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBN0csQ0FBaEQsR0FBd0ssRUFBekssSUFBZ0wsQ0FBckw7O0FBRUEsUUFBSyxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQXJHLENBQWhELEdBQWdLLEVBQWpLLElBQXdLLENBQTVLOztBQUdBLFFBQUksS0FBTSxJQUFLLFNBQVMsUUFBVCxDQUFrQixlQUFsQixHQUFvQyxRQUFwQyxHQUErQyxDQUFwRCxHQUEwRCxDQUFDLFNBQVMsdUJBQVQsR0FBbUMsQ0FBcEMsSUFBeUMsUUFBcEcsSUFBa0gsQ0FBM0g7QUFDQSxRQUFJLEtBQUssS0FBSyxRQUFMLElBQWlCLENBQTFCOztBQUVBLFFBQUksS0FBSyxFQUFULEVBQWE7QUFDWixTQUFJLE9BQU8sRUFBWDtBQUNBLFVBQUssRUFBTDtBQUNBLFVBQUssSUFBTDtBQUNBOztBQUVEO0FBQ0E7O0FBRUEsWUFBUSxXQUFXLENBQVgsRUFBYyxLQUFkLEdBQXNCLFdBQVcsQ0FBWCxFQUFjLEtBQXBDLEdBQTRDLFdBQVcsU0FBWCxDQUFxQixJQUFJLFdBQVcsU0FBWCxDQUFxQixNQUE5QyxDQUFwRDtBQUNBO0FBQ0EsYUFBUyxHQUFULEVBQWMsRUFBZCxFQUFrQixFQUFsQixFQUFzQixFQUF0QixFQUEwQixFQUExQixFQUE4QixLQUE5QixFQUFxQyxDQUFyQyxFQUF3QyxJQUF4QyxFQUE4QyxZQUE5QyxFQUE0RCxLQUE1RCxFQUFtRSxLQUFuRSxFQUEwRSxLQUExRSxFQUFpRixXQUFXLFdBQTVGOztBQUdBLFFBQUksS0FBSyxXQUFXLFlBQVgsQ0FBd0IsQ0FBeEIsQ0FBVDtBQUNBLFNBQUssYUFBTCxDQUFtQixTQUFuQixDQUE2QixFQUE3QixJQUFtQztBQUNsQyxTQUFJLEVBRDhCLEVBQzFCLFlBQVksV0FEYyxFQUNELGlCQUFpQixlQURoQixFQUNpQyxnQkFBZ0IsQ0FEakQsRUFDb0QsSUFBSSxFQUR4RCxFQUM0RCxJQUFJLEVBRGhFLEVBQ29FLElBQUksRUFEeEUsRUFDNEUsSUFBSTtBQURoRixLQUFuQztBQUdBLFlBQVEsb0JBQW9CLEVBQXBCLENBQVI7O0FBRUEsUUFBSSx3QkFBSixFQUNDLFNBQVMsS0FBSyxhQUFMLENBQW1CLFFBQTVCLEVBQXNDLEVBQXRDLEVBQTBDLEVBQTFDLEVBQThDLEVBQTlDLEVBQWtELEVBQWxELEVBQXNELEtBQXRELEVBQTZELENBQTdELEVBQWdFLElBQWhFLEVBQXNFLEtBQXRFLEVBQTZFLEtBQTdFLEVBQW9GLEtBQXBGLEVBQTJGLEtBQTNGOztBQUdELFFBQUksV0FBVyxDQUFYLEVBQWMsVUFBZCxJQUE0QixXQUFXLFVBQXZDLElBQXFELFdBQVcsQ0FBWCxFQUFjLG1CQUFuRSxJQUEwRixXQUFXLG1CQUF6RyxFQUE4SDs7QUFFN0gsVUFBSyxZQUFMLENBQWtCLElBQWxCLENBQXVCO0FBQ3RCLGlCQUFXLFVBRFc7QUFFdEIsaUJBQVcsV0FBVyxDQUFYLENBRlc7QUFHdEIsa0JBQVksVUFIVTtBQUl0QixvQkFBYyxDQUpRO0FBS3RCLGFBQU87QUFDTixVQUFHLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsS0FBc0IsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixDQUF0QixHQUEyQyxFQUEzQyxHQUFnRCxFQUQ3QyxFQUNpRCxHQUFHLEtBQUssQ0FBQyxLQUFLLEVBQU4sSUFBWTtBQURyRSxPQUxlO0FBUXRCLGlCQUFXLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsS0FBc0IsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixDQUF0QixHQUEyQyxDQUFDLENBQTVDLEdBQWdELENBUnJDO0FBU3RCLGNBQVE7QUFDUCxXQUFJLEtBQUssR0FBTCxDQUFTLEVBQVQsRUFBYSxFQUFiLENBREcsRUFDZSxJQUFJLEVBRG5CLEVBQ3VCLElBQUksS0FBSyxHQUFMLENBQVMsRUFBVCxFQUFhLEVBQWIsQ0FEM0IsRUFDNkMsSUFBSTtBQURqRCxPQVRjO0FBWXRCLGFBQU87QUFaZSxNQUF2Qjs7QUFlQSxVQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUI7QUFDdEIsaUJBQVcsVUFEVztBQUV0QixpQkFBVyxXQUFXLENBQVgsQ0FGVztBQUd0QixrQkFBWSxVQUhVO0FBSXRCLG9CQUFjLENBSlE7QUFLdEIsYUFBTztBQUNOLFVBQUcsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixLQUFzQixXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLENBQXRCLEdBQTJDLEVBQTNDLEdBQWdELEVBRDdDLEVBQ2lELEdBQUcsS0FBSyxDQUFDLEtBQUssRUFBTixJQUFZO0FBRHJFLE9BTGU7QUFRdEIsaUJBQVcsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixLQUFzQixXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLENBQXRCLEdBQTJDLENBQTNDLEdBQStDLENBQUMsQ0FSckM7QUFTdEIsY0FBUTtBQUNQLFdBQUksS0FBSyxHQUFMLENBQVMsRUFBVCxFQUFhLEVBQWIsQ0FERyxFQUNlLElBQUksRUFEbkIsRUFDdUIsSUFBSSxLQUFLLEdBQUwsQ0FBUyxFQUFULEVBQWEsRUFBYixDQUQzQixFQUM2QyxJQUFJO0FBRGpELE9BVGM7QUFZdEIsYUFBTztBQVplLE1BQXZCO0FBY0E7QUFDRDtBQUNEO0FBQ0Q7O0FBRUQsS0FBSSxPQUFKOztBQUVBLEtBQUksd0JBQUosRUFDQyxLQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsT0FBNUI7O0FBRUQ7QUFDQSxLQUFJLGdCQUFnQjtBQUNuQixVQUFRLEdBRFcsRUFDTixNQUFNLEtBQUssUUFBTCxDQUFjLEdBRGQsRUFDbUIsbUJBQW1CLGdCQUFnQixlQUR0RCxFQUN1RSxnQkFBZ0IsZ0JBQWdCLE1BQWhCLENBQXVCLFVBRDlHLEVBQzBILGVBQWU7QUFEekksRUFBcEI7QUFHQSxRQUFPLGFBQVA7QUFDQSxDOztBQTdKRDs7Ozs7Ozs7O2tCQ0VlLFVBQVUsUUFBVixFQUFvQjtBQUNsQyxLQUFJLE1BQU0sU0FBUyxlQUFULElBQTRCLEtBQUssUUFBTCxDQUFjLEdBQXBEO0FBQ0EsS0FBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixNQUFqRDs7QUFFQSxLQUFJLG1CQUFtQixDQUF2QixFQUNDOztBQUVELEtBQUksUUFBUSxJQUFaOztBQUVBLEtBQUksV0FBVyxLQUFLLFFBQXBCOztBQUVBLEtBQUksSUFBSSxDQUFSO0FBQUEsS0FBVyxDQUFYO0FBQUEsS0FBYyxFQUFkO0FBQUEsS0FBa0IsRUFBbEI7QUFDQSxLQUFJLFVBQUosQ0Faa0MsQ0FZbEI7O0FBRWhCLEtBQUksZUFBZ0IsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsSUFBSSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUE1RixDQUFqRCxJQUEwSixDQUE3Szs7QUFFQSxLQUFJLGNBQWMsS0FBSyxpQkFBTCxHQUF5QixLQUFLLGlCQUE5QixHQUFtRCxLQUFLLEtBQUwsR0FBYSxHQUFsRjtBQUNBO0FBQ0EsS0FBSSxXQUFXLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsT0FBdkM7QUFDQTtBQUNBLEtBQUksV0FBYyxTQUFTLEtBQVQsR0FBaUIsS0FBSyxHQUFMLENBQVMsU0FBUyxLQUFULENBQWUsZUFBZixHQUFpQyxTQUFTLEtBQVQsQ0FBZSxlQUF6RCxDQUFsQixHQUErRixLQUFLLEdBQUwsQ0FBUyxRQUFULENBQWhHLEdBQXNILFNBQVMsUUFBVCxDQUFrQixlQUF4SSxHQUEwSixFQUEzSixJQUFrSyxDQUFqTDs7QUFFQSxLQUFJLFdBQVcsV0FBZixFQUNDLFdBQVcsV0FBWCxDQURELEtBRUssSUFBSSxhQUFhLFFBQWpCLEVBQTJCO0FBQy9CLGFBQVcsY0FBYyxTQUFTLFFBQVQsQ0FBa0IsZUFBaEMsR0FBa0QsRUFBN0Q7QUFDQSxFQUZJLE1BRUUsSUFBSSxXQUFXLENBQWYsRUFDTixXQUFXLENBQVg7O0FBRUQsS0FBSSxJQUFKO0FBQ0EsS0FBSSx3QkFBSixFQUNDLEtBQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixJQUE1Qjs7QUFFRCxLQUFJLFNBQUo7QUFDQSxLQUFJLElBQUosQ0FBUyxTQUFTLEVBQWxCLEVBQXNCLFNBQVMsRUFBL0IsRUFBbUMsU0FBUyxLQUE1QyxFQUFtRCxTQUFTLE1BQTVEO0FBQ0EsS0FBSSxJQUFKOztBQUVBLEtBQUksd0JBQUosRUFBdUI7QUFDdEIsT0FBSyxhQUFMLENBQW1CLFFBQW5CLENBQTRCLElBQTVCLENBQWlDLFNBQVMsRUFBMUMsRUFBOEMsU0FBUyxFQUF2RCxFQUEyRCxTQUFTLEtBQXBFLEVBQTJFLFNBQVMsTUFBcEY7QUFDQSxPQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsSUFBNUI7QUFDQTtBQUNEOztBQUVBLE1BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxTQUFTLGlCQUFULENBQTJCLE1BQS9DLEVBQXVELEdBQXZELEVBQTREOztBQUUzRCxNQUFJLGtCQUFrQixTQUFTLGlCQUFULENBQTJCLENBQTNCLENBQXRCOztBQUVBLE1BQUksYUFBYSxLQUFLLElBQUwsQ0FBVSxlQUFWLENBQWpCO0FBQ0EsTUFBSSxhQUFhLFdBQVcsVUFBNUI7QUFDQSxNQUFJLDZCQUE2QixJQUFqQzs7QUFHQTtBQUNBOztBQUVBOzs7QUFHQSxNQUFJLFdBQVcsTUFBWCxHQUFvQixDQUF4QixFQUEyQjtBQUMxQjs7QUFFQSxPQUFJLGVBQWdCLFdBQVcsQ0FBWixJQUFrQixXQUFXLFlBQTdCLEdBQTRDLElBQTVDLEdBQW1ELEtBQXRFOztBQUVBLFFBQUssSUFBSSxDQUFULEVBQVksSUFBSSxXQUFXLE1BQTNCLEVBQW1DLEdBQW5DLEVBQXdDOztBQUV2QyxlQUFXLENBQVgsRUFBYyxPQUFkLEdBQXdCLGFBQWEsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixFQUFyQyxHQUFpRSxhQUFhLFdBQVcsQ0FBWCxFQUFjLENBQTVGOztBQUVBLFFBQUksYUFBYSxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLFdBQXJDLElBQW9ELGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUE3RixFQUEwRztBQUN6RztBQUNBOztBQUVELFFBQUksV0FBVyxDQUFYLEVBQWMsQ0FBZCxLQUFvQixJQUFwQixJQUE0QixDQUFDLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsTUFBN0MsSUFDQSxPQUFRLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsQ0FBUixLQUFnQyxRQURoQyxJQUM0QyxPQUFRLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsQ0FBUixLQUFnQyxRQURoRixFQUVDOztBQUVELFFBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUFyRyxDQUFoRCxHQUFnSyxFQUFqSyxJQUF3SyxDQUE1SztBQUNBLFNBQU0sU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixJQUFxQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUE3RyxDQUFoRCxHQUF3SyxFQUF6SyxJQUFnTCxDQUFyTDtBQUNBLFNBQU0sU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixJQUFxQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUE3RyxDQUFoRCxHQUF3SyxFQUF6SyxJQUFnTCxDQUFyTDs7QUFFQTtBQUNBLFFBQUksS0FBSyxJQUFLLFNBQVMsUUFBVCxDQUFrQixlQUFsQixHQUFvQyxRQUFwQyxHQUErQyxDQUFwRCxHQUEwRCxDQUFDLFNBQVMsdUJBQVQsR0FBbUMsQ0FBcEMsSUFBeUMsUUFBbkcsSUFBZ0gsQ0FBekg7QUFDQSxRQUFJLEtBQUssS0FBSyxRQUFMLElBQWlCLENBQTFCO0FBQ0EsUUFBSSxFQUFKO0FBQ0EsUUFBSSxFQUFKOztBQUdBLFlBQVEsV0FBVyxDQUFYLEVBQWMsS0FBZCxHQUFzQixXQUFXLENBQVgsRUFBYyxLQUFwQyxHQUE0QyxXQUFXLFNBQVgsQ0FBcUIsSUFBSSxXQUFXLFNBQVgsQ0FBcUIsTUFBOUMsQ0FBcEQ7O0FBRUEsUUFBSSxLQUFLLEVBQVQsRUFBYTtBQUNaLFNBQUksT0FBTyxFQUFYO0FBQ0EsVUFBSyxFQUFMO0FBQ0EsVUFBSyxJQUFMO0FBQ0E7O0FBRUQsUUFBSSxLQUFLLFdBQVcsWUFBWCxDQUF3QixDQUF4QixDQUFUO0FBQ0EsU0FBSyxhQUFMLENBQW1CLFNBQW5CLENBQTZCLEVBQTdCLElBQW1DO0FBQ2xDLFNBQUksRUFEOEIsRUFDMUIsWUFBWSxXQURjLEVBQ0QsaUJBQWlCLGVBRGhCLEVBQ2lDLGdCQUFnQixDQURqRCxFQUNvRCxJQUFJLEVBRHhELEVBQzRELElBQUksRUFEaEUsRUFDb0UsSUFBSSxFQUR4RSxFQUM0RSxJQUFJO0FBRGhGLEtBQW5DOztBQUlBO0FBQ0EsUUFBSSxrQkFBa0IsQ0FBdEI7O0FBRUEsYUFBUyxHQUFULEVBQWMsRUFBZCxFQUFrQixFQUFsQixFQUFzQixFQUF0QixFQUEwQixFQUExQixFQUE4QixLQUE5QixFQUFxQyxlQUFyQyxFQUFzRCxLQUF0RCxFQUE2RCxZQUE3RCxFQUEyRSxZQUEzRSxFQUF5RixLQUF6RixFQUFnRyxLQUFoRyxFQUF1RyxXQUFXLFdBQWxIO0FBQ0EsWUFBUSxvQkFBb0IsRUFBcEIsQ0FBUjs7QUFFQSxRQUFJLHdCQUFKLEVBQ0MsU0FBUyxLQUFLLGFBQUwsQ0FBbUIsUUFBNUIsRUFBc0MsRUFBdEMsRUFBMEMsRUFBMUMsRUFBOEMsRUFBOUMsRUFBa0QsRUFBbEQsRUFBc0QsS0FBdEQsRUFBNkQsQ0FBN0QsRUFBZ0UsSUFBaEUsRUFBc0UsS0FBdEUsRUFBNkUsS0FBN0UsRUFBb0YsS0FBcEYsRUFBMkYsS0FBM0Y7O0FBR0QsUUFBSSxXQUFXLENBQVgsRUFBYyxVQUFkLElBQTRCLFdBQVcsVUFBdkMsSUFBcUQsV0FBVyxDQUFYLEVBQWMsbUJBQW5FLElBQTBGLFdBQVcsbUJBQXpHLEVBQThIOztBQUU3SCxVQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUI7QUFDdEIsaUJBQVcsYUFEVztBQUV0QixpQkFBVyxXQUFXLENBQVgsQ0FGVztBQUd0QixrQkFBWSxVQUhVO0FBSXRCLG9CQUFjLENBSlE7QUFLdEIsYUFBTztBQUNOLFVBQUcsS0FBSyxDQUFDLEtBQUssRUFBTixJQUFZLENBRGQsRUFDaUIsR0FBRyxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLEtBQXNCLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsQ0FBdEIsR0FBMkMsRUFBM0MsR0FBZ0Q7QUFEcEUsT0FMZTtBQVF0QixpQkFBVyxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLEtBQXNCLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsQ0FBdEIsR0FBMkMsQ0FBQyxDQUE1QyxHQUFnRCxDQVJyQztBQVN0QixjQUFRO0FBQ1AsV0FBSSxFQURHLEVBQ0MsSUFBSSxLQUFLLEdBQUwsQ0FBUyxFQUFULEVBQWEsRUFBYixDQURMLEVBQ3VCLElBQUksRUFEM0IsRUFDK0IsSUFBSSxLQUFLLEdBQUwsQ0FBUyxFQUFULEVBQWEsRUFBYjtBQURuQyxPQVRjO0FBWXRCLGFBQU87QUFaZSxNQUF2Qjs7QUFlQSxVQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUI7QUFDdEIsaUJBQVcsYUFEVztBQUV0QixpQkFBVyxXQUFXLENBQVgsQ0FGVztBQUd0QixrQkFBWSxVQUhVO0FBSXRCLG9CQUFjLENBSlE7QUFLdEIsYUFBTztBQUNOLFVBQUcsS0FBSyxDQUFDLEtBQUssRUFBTixJQUFZLENBRGQsRUFDaUIsR0FBRyxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLEtBQXNCLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsQ0FBdEIsR0FBMkMsRUFBM0MsR0FBZ0Q7QUFEcEUsT0FMZTtBQVF0QixpQkFBVyxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLEtBQXNCLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsQ0FBdEIsR0FBMkMsQ0FBM0MsR0FBK0MsQ0FBQyxDQVJyQztBQVN0QixjQUFRO0FBQ1AsV0FBSSxFQURHLEVBQ0MsSUFBSSxLQUFLLEdBQUwsQ0FBUyxFQUFULEVBQWEsRUFBYixDQURMLEVBQ3VCLElBQUksRUFEM0IsRUFDK0IsSUFBSSxLQUFLLEdBQUwsQ0FBUyxFQUFULEVBQWEsRUFBYjtBQURuQyxPQVRjO0FBWXRCLGFBQU87QUFaZSxNQUF2QjtBQWVBO0FBQ0Q7QUFDRDtBQUNEOztBQUVELEtBQUksT0FBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQ0MsS0FBSyxhQUFMLENBQW1CLFFBQW5CLENBQTRCLE9BQTVCOztBQUdEO0FBQ0EsS0FBSSxnQkFBZ0I7QUFDbkIsVUFBUSxHQURXLEVBQ04sTUFBTSxLQUFLLFFBQUwsQ0FBYyxHQURkLEVBQ21CLG1CQUFtQixnQkFBZ0IsZUFEdEQsRUFDdUUsZ0JBQWdCLGdCQUFnQixNQUFoQixDQUF1QixVQUQ5RyxFQUMwSCxlQUFlO0FBRHpJLEVBQXBCO0FBR0EsUUFBTyxhQUFQO0FBQ0EsQzs7QUEvSkQ7Ozs7Ozs7OztrQkNFZSxVQUFTLFFBQVQsRUFBbUI7QUFDakMsS0FBSSxNQUFNLFNBQVMsZUFBVCxJQUE0QixLQUFLLFFBQUwsQ0FBYyxHQUFwRDtBQUNBLEtBQUksa0JBQWtCLFNBQVMsaUJBQVQsQ0FBMkIsTUFBakQ7O0FBRUEsS0FBSSxtQkFBbUIsQ0FBdkIsRUFDQzs7QUFFRCxLQUFJLFdBQVcsS0FBSyxhQUFMLENBQW1CLFFBQWxDOztBQUVBLEtBQUksYUFBYSxTQUFTLEtBQVQsQ0FBZSxlQUFoQztBQUNBLEtBQUksYUFBYSxTQUFTLEtBQVQsQ0FBZSxlQUFoQztBQUNBLEtBQUksVUFBVSxFQUFkOztBQUVBLEtBQUksV0FBVyxLQUFLLFFBQXBCO0FBQ0EsS0FBSSxJQUFKOztBQUVBLEtBQUksd0JBQUosRUFDQyxTQUFTLElBQVQ7O0FBRUQsS0FBSSxTQUFKO0FBQ0EsS0FBSSxJQUFKLENBQVMsU0FBUyxFQUFsQixFQUFzQixTQUFTLEVBQS9CLEVBQW1DLFNBQVMsS0FBNUMsRUFBbUQsU0FBUyxNQUE1RDtBQUNBLEtBQUksSUFBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLFdBQVMsU0FBVDtBQUNBLFdBQVMsSUFBVCxDQUFjLFNBQVMsRUFBdkIsRUFBMkIsU0FBUyxFQUFwQyxFQUF3QyxTQUFTLEtBQWpELEVBQXdELFNBQVMsTUFBakU7QUFDQSxXQUFTLElBQVQ7QUFDQTs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0Qjs7QUFFQSxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsZUFBVixDQUFqQjs7QUFFQSxNQUFJLGFBQWEsV0FBVyxVQUE1Qjs7QUFFQSxNQUFJLFdBQVcsV0FBVyxFQUExQjtBQUNBLE9BQUssYUFBTCxDQUFtQixTQUFuQixDQUE2QixRQUE3QixJQUF5QztBQUN4QyxlQUFZLFlBRDRCLEVBQ2QsaUJBQWlCO0FBREgsR0FBekM7O0FBSUEsTUFBSSxXQUFXLG9CQUFvQixRQUFwQixDQUFmO0FBQ0EsV0FBUyxTQUFULEdBQXFCLFFBQXJCO0FBQ0E7QUFDQTs7QUFFQSxZQUFVLEVBQVY7O0FBRUEsTUFBSSw2QkFBNkIsSUFBakM7QUFDQSxNQUFJLElBQUksQ0FBUjtBQUFBLE1BQVcsQ0FBWDtBQUFBLE1BQWMsRUFBZDtBQUFBLE1BQWtCLEVBQWxCO0FBQ0EsTUFBSSxVQUFKLENBdEIyRCxDQXNCM0M7O0FBRWhCLE1BQUksZUFBZ0IsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsSUFBSSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUE1RixDQUFoRCxHQUF1SixFQUF4SixJQUErSixDQUFsTDtBQUNBLE1BQUksS0FBSjs7QUFFQSxNQUFJLGFBQWEsSUFBakI7O0FBRUEsTUFBSSxXQUFXLEVBQWY7QUFDQSxNQUFJLFdBQVcsRUFBZjs7QUFFQSxNQUFJLFdBQVcsTUFBWCxHQUFvQixDQUF4QixFQUEyQjtBQUMxQjtBQUNBLFdBQVEsV0FBVyxTQUFYLENBQXFCLElBQUksV0FBVyxTQUFYLENBQXFCLE1BQTlDLENBQVI7QUFDQTtBQUNBLE9BQUksU0FBSixHQUFnQixLQUFoQjtBQUNBLE9BQUksV0FBSixHQUFrQixLQUFsQjtBQUNBLE9BQUksU0FBSixHQUFnQixXQUFXLGFBQTNCOztBQUVBLE9BQUksSUFBSSxXQUFSLEVBQXFCO0FBQ3BCLFFBQUksV0FBSixDQUFnQixpQkFBaUIsV0FBVyxZQUE1QixFQUEwQyxXQUFXLGFBQXJELENBQWhCO0FBQ0E7O0FBRUQsVUFBTyxJQUFJLFdBQVcsTUFBdEIsRUFBOEIsR0FBOUIsRUFBbUM7O0FBRWxDLGlCQUFhLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsR0FBMEIsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixFQUExQixHQUFzRCxXQUFXLENBQVgsRUFBYyxDQUFqRjs7QUFFQSxRQUFJLGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUFyQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBN0YsRUFBMEc7QUFDekc7QUFDQTs7QUFFRCxRQUFJLFdBQVcsQ0FBWCxFQUFjLENBQWQsS0FBb0IsSUFBcEIsSUFBNEIsQ0FBQyxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLE1BQTdDLElBQXVELE9BQVEsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixDQUFSLEtBQWdDLFFBQXZGLElBQW1HLE9BQVEsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixDQUFSLEtBQWdDLFFBQXZJLEVBQWlKO0FBQ2hKLFNBQUksSUFBSSxDQUFSLEVBQVc7QUFDVjtBQUNBLGlCQUFXLEVBQVg7QUFDQSxpQkFBVyxFQUFYO0FBQ0E7QUFDRDtBQUNBOztBQUVELFFBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUFyRyxDQUFoRCxHQUFnSyxFQUFqSyxJQUF3SyxDQUE1SztBQUNBLFNBQU0sU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixJQUFxQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUE3RyxDQUFoRCxHQUF3SyxFQUF6SyxJQUFnTCxDQUFyTDtBQUNBLFNBQU0sU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixDQUFoQixJQUFxQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUE3RyxDQUFoRCxHQUF3SyxFQUF6SyxJQUFnTCxDQUFyTDs7QUFHQSxRQUFJLEtBQUssV0FBVyxZQUFYLENBQXdCLENBQXhCLENBQVQ7QUFDQSxTQUFLLGFBQUwsQ0FBbUIsU0FBbkIsQ0FBNkIsRUFBN0IsSUFBbUM7QUFDbEMsU0FBSSxFQUQ4QixFQUMxQixZQUFZLFdBRGMsRUFDRCxpQkFBaUIsZUFEaEIsRUFDaUMsZ0JBQWdCLENBRGpELEVBQ29ELElBQUksQ0FEeEQsRUFDMkQsSUFBSSxFQUQvRCxFQUNtRSxJQUFJO0FBRHZFLEtBQW5DOztBQUlBLGFBQVMsU0FBUyxNQUFsQixJQUE0QjtBQUMzQixRQUFHLENBRHdCLEVBQ3JCLEdBQUc7QUFEa0IsS0FBNUI7QUFHQSxhQUFTLFNBQVMsTUFBbEIsSUFBNEI7QUFDM0IsUUFBRyxDQUR3QixFQUNyQixHQUFHO0FBRGtCLEtBQTVCOztBQUlBO0FBQ0EsUUFBSSxXQUFXLENBQVgsRUFBYyxVQUFkLEtBQTZCLENBQWpDLEVBQW9DO0FBQ25DLFNBQUksV0FBVyxDQUFYLEVBQWMsVUFBZCxHQUEyQixDQUEzQixJQUFnQyxXQUFXLFVBQVgsR0FBd0IsQ0FBNUQsRUFBK0Q7QUFDOUQsVUFBSSxjQUFjLFdBQVcsbUJBQVgsQ0FBK0IsQ0FBL0IsRUFBa0MsQ0FBbEMsRUFBcUMsRUFBckMsRUFBeUMsR0FBekMsQ0FBbEI7QUFDQSxjQUFRLElBQVIsQ0FBYSxXQUFiOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSxVQUFJLGNBQWMsb0JBQW9CLEVBQXBCLENBQWxCOztBQUVBLFVBQUksd0JBQUosRUFBdUI7QUFDdEIsZUFBUSxJQUFSLENBQWE7QUFDWixXQUFHLENBRFMsRUFDTixHQUFHLEVBREcsRUFDQyxLQUFLLFFBRE47QUFFWixjQUFNLFlBQVksSUFGTjtBQUdaLGNBQU0sWUFBWSxJQUhOO0FBSVosZUFBTyxXQUpLO0FBS1oscUJBQWEsV0FMRDtBQU1aLHlCQUFpQixZQUFZO0FBTmpCLFFBQWI7QUFRQTs7QUFFRCxVQUFJLGNBQWMsV0FBVyxtQkFBWCxDQUErQixDQUEvQixFQUFrQyxDQUFsQyxFQUFxQyxFQUFyQyxFQUF5QyxHQUF6QyxDQUFsQjtBQUNBLGNBQVEsSUFBUixDQUFhLFdBQWI7O0FBRUE7QUFDQTtBQUNBOztBQUVBLFVBQUksY0FBYyxvQkFBb0IsRUFBcEIsQ0FBbEI7O0FBRUEsVUFBSSx3QkFBSixFQUF1QjtBQUN0QixlQUFRLElBQVIsQ0FBYTtBQUNaLFdBQUcsQ0FEUyxFQUNOLEdBQUcsRUFERyxFQUNDLEtBQUssUUFETjtBQUVaLGNBQU0sWUFBWSxJQUZOO0FBR1osY0FBTSxZQUFZLElBSE47QUFJWixlQUFPLFdBSks7QUFLWixxQkFBYSxXQUxEO0FBTVoseUJBQWlCLFlBQVk7QUFOakIsUUFBYjtBQVFBO0FBQ0Q7QUFDRDs7QUFHRDtBQUNBLFFBQUksV0FBVyxDQUFYLEVBQWMsVUFBZCxJQUE0QixXQUFXLFVBQXZDLElBQXFELFdBQVcsQ0FBWCxFQUFjLG1CQUFuRSxJQUEwRixXQUFXLG1CQUF6RyxFQUE4SDs7QUFFN0gsVUFBSyxZQUFMLENBQWtCLElBQWxCLENBQXVCO0FBQ3RCLGlCQUFXLFlBRFc7QUFFdEIsaUJBQVcsV0FBVyxDQUFYLENBRlc7QUFHdEIsa0JBQVksVUFIVTtBQUl0QixvQkFBYyxDQUpRO0FBS3RCLGFBQU87QUFDTixVQUFHLENBREcsRUFDQSxHQUFHO0FBREgsT0FMZTtBQVF0QixpQkFBVyxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLEtBQXNCLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsQ0FBdEIsR0FBMkMsQ0FBQyxDQUE1QyxHQUFnRCxDQVJyQztBQVN0QixhQUFPO0FBVGUsTUFBdkI7O0FBWUEsVUFBSyxZQUFMLENBQWtCLElBQWxCLENBQXVCO0FBQ3RCLGlCQUFXLFlBRFc7QUFFdEIsaUJBQVcsV0FBVyxDQUFYLENBRlc7QUFHdEIsa0JBQVksVUFIVTtBQUl0QixvQkFBYyxDQUpRO0FBS3RCLGFBQU87QUFDTixVQUFHLENBREcsRUFDQSxHQUFHO0FBREgsT0FMZTtBQVF0QixpQkFBVyxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLENBQWhCLEtBQXNCLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsQ0FBaEIsQ0FBdEIsR0FBMkMsQ0FBM0MsR0FBK0MsQ0FBQyxDQVJyQztBQVN0QixhQUFPO0FBVGUsTUFBdkI7QUFZQTtBQUNEOztBQUVEOztBQUVBLGdCQUFhLFdBQWIsQ0FBeUIsT0FBekI7QUFDQTtBQUNEOztBQUVELEtBQUksT0FBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQ0MsS0FBSyxhQUFMLENBQW1CLFFBQW5CLENBQTRCLE9BQTVCOztBQUVELFVBQVMsZ0JBQVQsR0FBNEI7QUFDM0IsTUFBSSxLQUFLLGdCQUFnQixRQUFoQixFQUEwQixDQUExQixDQUFUOztBQUVBLE1BQUksR0FBRyxNQUFILEdBQVksQ0FBaEIsRUFBbUI7QUFDbEIsT0FBSSxTQUFKO0FBQ0EsT0FBSSxNQUFKLENBQVcsR0FBRyxDQUFILEVBQU0sQ0FBakIsRUFBb0IsR0FBRyxDQUFILEVBQU0sQ0FBMUI7O0FBRUEsT0FBSSx3QkFBSixFQUF1QjtBQUN0QixhQUFTLFNBQVQ7QUFDQSxhQUFTLE1BQVQsQ0FBZ0IsR0FBRyxDQUFILEVBQU0sQ0FBdEIsRUFBeUIsR0FBRyxDQUFILEVBQU0sQ0FBL0I7QUFDQTs7QUFHRCxRQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksR0FBRyxNQUFILEdBQVksQ0FBaEMsRUFBbUMsS0FBSyxDQUF4QyxFQUEyQzs7QUFFMUMsUUFBSSxhQUFKLENBQWtCLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBNUIsRUFBK0IsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUF6QyxFQUE0QyxHQUFHLElBQUksQ0FBUCxFQUFVLENBQXRELEVBQXlELEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBbkUsRUFBc0UsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUFoRixFQUFtRixHQUFHLElBQUksQ0FBUCxFQUFVLENBQTdGOztBQUVBLFFBQUksd0JBQUosRUFDQyxTQUFTLGFBQVQsQ0FBdUIsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUFqQyxFQUFvQyxHQUFHLElBQUksQ0FBUCxFQUFVLENBQTlDLEVBQWlELEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBM0QsRUFBOEQsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUF4RSxFQUEyRSxHQUFHLElBQUksQ0FBUCxFQUFVLENBQXJGLEVBQXdGLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBbEc7QUFDRDs7QUFFRCxPQUFJLFdBQVcsYUFBWCxHQUEyQixDQUEvQixFQUNDLElBQUksTUFBSjs7QUFFRCxRQUFLLGdCQUFnQixRQUFoQixFQUEwQixDQUExQixDQUFMOztBQUVBLE9BQUksTUFBSixDQUFXLFNBQVMsU0FBUyxNQUFULEdBQWtCLENBQTNCLEVBQThCLENBQXpDLEVBQTRDLFNBQVMsU0FBUyxNQUFULEdBQWtCLENBQTNCLEVBQThCLENBQTFFOztBQUVBLFFBQUssSUFBSSxJQUFJLEdBQUcsTUFBSCxHQUFZLENBQXpCLEVBQTRCLElBQUksQ0FBaEMsRUFBbUMsS0FBSyxDQUF4QyxFQUEyQzs7QUFFMUMsUUFBSSxhQUFKLENBQWtCLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBNUIsRUFBK0IsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUF6QyxFQUE0QyxHQUFHLElBQUksQ0FBUCxFQUFVLENBQXRELEVBQXlELEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBbkUsRUFBc0UsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUFoRixFQUFtRixHQUFHLElBQUksQ0FBUCxFQUFVLENBQTdGOztBQUVBLFFBQUksd0JBQUosRUFDQyxTQUFTLGFBQVQsQ0FBdUIsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUFqQyxFQUFvQyxHQUFHLElBQUksQ0FBUCxFQUFVLENBQTlDLEVBQWlELEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBM0QsRUFBOEQsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUF4RSxFQUEyRSxHQUFHLElBQUksQ0FBUCxFQUFVLENBQXJGLEVBQXdGLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBbEc7QUFDRDs7QUFFRCxPQUFJLFNBQUo7O0FBRUEsT0FBSSxXQUFKLEdBQWtCLFdBQVcsV0FBN0I7QUFDQSxPQUFJLElBQUo7QUFDQSxPQUFJLFdBQUosR0FBa0IsQ0FBbEI7O0FBR0EsT0FBSSxXQUFXLGFBQVgsR0FBMkIsQ0FBL0IsRUFBa0M7QUFDakMsUUFBSSxTQUFKO0FBQ0EsUUFBSSxNQUFKLENBQVcsU0FBUyxTQUFTLE1BQVQsR0FBa0IsQ0FBM0IsRUFBOEIsQ0FBekMsRUFBNEMsU0FBUyxTQUFTLE1BQVQsR0FBa0IsQ0FBM0IsRUFBOEIsQ0FBMUU7O0FBRUEsU0FBSyxJQUFJLElBQUksR0FBRyxNQUFILEdBQVksQ0FBekIsRUFBNEIsSUFBSSxDQUFoQyxFQUFtQyxLQUFLLENBQXhDLEVBQTJDOztBQUUxQyxTQUFJLGFBQUosQ0FBa0IsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUE1QixFQUErQixHQUFHLElBQUksQ0FBUCxFQUFVLENBQXpDLEVBQTRDLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBdEQsRUFBeUQsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUFuRSxFQUFzRSxHQUFHLElBQUksQ0FBUCxFQUFVLENBQWhGLEVBQW1GLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBN0Y7O0FBRUEsU0FBSSx3QkFBSixFQUNDLFNBQVMsYUFBVCxDQUF1QixHQUFHLElBQUksQ0FBUCxFQUFVLENBQWpDLEVBQW9DLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBOUMsRUFBaUQsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUEzRCxFQUE4RCxHQUFHLElBQUksQ0FBUCxFQUFVLENBQXhFLEVBQTJFLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBckYsRUFBd0YsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUFsRztBQUNEO0FBQ0QsUUFBSSxNQUFKO0FBQ0E7O0FBRUQsT0FBSSxTQUFKOztBQUdBLE9BQUksd0JBQUosRUFBdUI7QUFDdEIsYUFBUyxTQUFUO0FBQ0EsYUFBUyxJQUFUO0FBQ0E7QUFDRDtBQUNEOztBQUVEO0FBQ0EsS0FBSSxnQkFBZ0I7QUFDbkIsVUFBUSxHQURXLEVBQ04sTUFBTSxLQUFLLFFBQUwsQ0FBYyxHQURkLEVBQ21CLG1CQUFtQixnQkFBZ0IsY0FEdEQsRUFDc0UsZ0JBQWdCLGdCQUFnQixNQUFoQixDQUF1QixNQUQ3RyxFQUNxSCxlQUFlO0FBRHBJLEVBQXBCO0FBR0EsUUFBTyxhQUFQO0FBQ0EsQzs7QUE1UUQ7O0FBNlFBOztBQUVBLElBQUksY0FBYyxTQUFkLFdBQWMsQ0FBVSxHQUFWLEVBQWUsTUFBZixFQUF1QixNQUF2QixFQUErQixLQUEvQixFQUFzQyxJQUF0QyxFQUE0QyxNQUE1QyxFQUFvRCxNQUFwRCxFQUE0RCxXQUE1RCxFQUF5RSxrQkFBekUsRUFBNkY7O0FBRTlHLEtBQUksT0FBUSxXQUFSLEtBQXlCLFdBQTdCLEVBQ0MsY0FBYyxDQUFkOztBQUVEO0FBQ0EsS0FBSSxDQUFDLHdCQUFMLEVBQXdCO0FBQ3ZCLE1BQUksWUFBWSxPQUFPLENBQUMsVUFBVSxJQUFJLEtBQUssRUFBbkIsQ0FBRCxFQUF5QixPQUF6QixDQUFpQyxDQUFqQyxDQUFQLENBQWhCO0FBQ0EsTUFBSSxZQUFZLE9BQU8sQ0FBQyxVQUFVLElBQUksS0FBSyxFQUFuQixDQUFELEVBQXlCLE9BQXpCLENBQWlDLENBQWpDLENBQVAsQ0FBaEI7QUFDQSxNQUFJLGNBQWMsU0FBbEIsRUFDQyxVQUFVLEtBQVY7QUFDRDs7QUFFRCxLQUFJLElBQUo7QUFDQSxLQUFJLFdBQUosR0FBa0IsV0FBbEI7O0FBRUEsS0FBSSxTQUFTLEtBQWIsRUFBb0I7QUFDbkIsTUFBSSxTQUFKO0FBQ0EsTUFBSSxNQUFKLENBQVcsT0FBTyxDQUFsQixFQUFxQixPQUFPLENBQTVCO0FBQ0EsTUFBSSxHQUFKLENBQVEsT0FBTyxDQUFmLEVBQWtCLE9BQU8sQ0FBekIsRUFBNEIsTUFBNUIsRUFBb0MsTUFBcEMsRUFBNEMsTUFBNUMsRUFBb0QsS0FBcEQ7QUFDQSxNQUFJLFNBQUosR0FBZ0IsS0FBaEI7QUFDQSxNQUFJLFdBQUosR0FBa0IsT0FBbEI7QUFDQSxNQUFJLFNBQUosR0FBZ0IsQ0FBaEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE1BQUksU0FBSjtBQUNBO0FBQ0EsTUFBSSxJQUFKO0FBQ0EsRUFkRCxNQWVLLElBQUksU0FBUyxVQUFiLEVBQXlCO0FBQzdCLE1BQUksU0FBSjtBQUNBLE1BQUksR0FBSixDQUFRLE9BQU8sQ0FBZixFQUFrQixPQUFPLENBQXpCLEVBQTRCLE1BQTVCLEVBQW9DLE1BQXBDLEVBQTRDLE1BQTVDLEVBQW9ELEtBQXBEO0FBQ0EsTUFBSSxHQUFKLENBQVEsT0FBTyxDQUFmLEVBQWtCLE9BQU8sQ0FBekIsRUFBNEIscUJBQXFCLE1BQWpELEVBQXlELE1BQXpELEVBQWlFLE1BQWpFLEVBQXlFLElBQXpFO0FBQ0EsTUFBSSxTQUFKO0FBQ0EsTUFBSSxTQUFKLEdBQWdCLEtBQWhCO0FBQ0EsTUFBSSxXQUFKLEdBQWtCLE9BQWxCO0FBQ0EsTUFBSSxTQUFKLEdBQWdCLENBQWhCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsTUFBSSxJQUFKO0FBQ0E7O0FBRUQsS0FBSSxXQUFKLEdBQWtCLENBQWxCOztBQUVBLEtBQUksT0FBSjtBQUNBLENBbkREOzs7Ozs7Ozs7a0JDM1FlLFVBQVUsUUFBVixFQUFvQjtBQUNsQyxLQUFJLE1BQU0sU0FBUyxlQUFULElBQTRCLEtBQUssUUFBTCxDQUFjLEdBQXBEO0FBQ0EsS0FBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixNQUFqRDs7QUFFQSxLQUFJLG1CQUFtQixDQUF2QixFQUNDOztBQUVELEtBQUksUUFBUSxJQUFaOztBQUVBLEtBQUksV0FBVyxLQUFLLFFBQXBCOztBQUVBLEtBQUksSUFBSSxDQUFSO0FBQUEsS0FBVyxDQUFYO0FBQUEsS0FBYyxDQUFkO0FBQ0EsS0FBSSxVQUFKLENBWmtDLENBWWxCOztBQUVoQixLQUFJLGVBQWdCLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELElBQUksU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBNUYsQ0FBakQsSUFBMEosQ0FBN0s7O0FBRUEsS0FBSSxjQUFjLEtBQUssaUJBQUwsR0FBeUIsS0FBSyxpQkFBOUIsR0FBa0QsS0FBSyxLQUFMLEdBQWEsR0FBYixJQUFvQixDQUF4RjtBQUNBLEtBQUksV0FBVyxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLE9BQXZDO0FBQ0EsS0FBSSxXQUFjLFNBQVMsS0FBVCxHQUFpQixLQUFLLEdBQUwsQ0FBUyxTQUFTLEtBQVQsQ0FBZSxlQUFmLEdBQWlDLFNBQVMsS0FBVCxDQUFlLGVBQXpELENBQWxCLEdBQStGLEtBQUssR0FBTCxDQUFTLFFBQVQsQ0FBaEcsR0FBc0gsZUFBdEgsR0FBd0ksRUFBekksSUFBZ0osQ0FBL0o7O0FBR0EsS0FBSSxJQUFKO0FBQ0EsS0FBSSx3QkFBSixFQUNDLEtBQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixJQUE1Qjs7QUFFRCxLQUFJLFNBQUo7QUFDQSxLQUFJLElBQUosQ0FBUyxTQUFTLEVBQWxCLEVBQXNCLFNBQVMsRUFBL0IsRUFBbUMsU0FBUyxLQUE1QyxFQUFtRCxTQUFTLE1BQTVEO0FBQ0EsS0FBSSxJQUFKOztBQUVBLEtBQUksd0JBQUosRUFBdUI7QUFDdEIsT0FBSyxhQUFMLENBQW1CLFFBQW5CLENBQTRCLElBQTVCLENBQWlDLFNBQVMsRUFBMUMsRUFBOEMsU0FBUyxFQUF2RCxFQUEyRCxTQUFTLEtBQXBFLEVBQTJFLFNBQVMsTUFBcEY7QUFDQSxPQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsSUFBNUI7QUFDQTs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0Qjs7QUFFQSxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsZUFBVixDQUFqQjtBQUNBLE1BQUksYUFBYSxXQUFXLFVBQTVCO0FBQ0EsTUFBSSw2QkFBNkIsSUFBakM7O0FBRUEsTUFBSSxXQUFXLE1BQVgsSUFBcUIsQ0FBekIsRUFDQyxXQUFXLFdBQVg7O0FBRUQsTUFBSSxXQUFXLENBQWYsRUFDQyxXQUFXLENBQVgsQ0FERCxLQUVLLElBQUksV0FBVyxXQUFmLEVBQ0osV0FBVyxXQUFYOztBQUVELE1BQUksV0FBVyxNQUFYLEdBQW9CLENBQXhCLEVBQTJCO0FBQzFCOztBQUVBLE9BQUksV0FBSixHQUFrQixVQUFsQjs7QUFFQSxPQUFJLFVBQVUsS0FBSyxHQUFMLENBQVMsS0FBSyxHQUFMLENBQVMsU0FBUyxNQUFsQixFQUEwQixTQUFTLEtBQW5DLElBQTRDLEVBQTVDLEdBQWlELENBQTFELEVBQTZELENBQTdELElBQWtFLEtBQUssRUFBckY7O0FBRUEsT0FBSSxpQkFBaUIsQ0FBckI7QUFDQSxPQUFJLGlCQUFpQixDQUFyQjs7QUFFQSxRQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksV0FBVyxNQUEvQixFQUF1QyxHQUF2QyxFQUE0Qzs7QUFFM0MsaUJBQWEsV0FBVyxDQUFYLEVBQWMsT0FBZCxHQUF3QixhQUFhLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsRUFBckMsR0FBaUUsYUFBYSxXQUFXLENBQVgsRUFBYyxDQUF6Rzs7QUFFQSxRQUFJLGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUFyQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBN0YsRUFBMEc7QUFDekc7QUFDQTs7QUFFRCxRQUFJLE9BQVEsV0FBVyxDQUFYLEVBQWMsQ0FBdEIsS0FBNkIsUUFBakMsRUFDQzs7QUFFRCxRQUFLLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELGFBQWEsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBckcsQ0FBaEQsR0FBZ0ssRUFBakssSUFBd0ssQ0FBNUs7QUFDQSxRQUFLLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELFdBQVcsQ0FBWCxFQUFjLENBQWQsR0FBa0IsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBMUcsQ0FBaEQsR0FBcUssRUFBdEssSUFBNkssQ0FBakw7O0FBRUEsUUFBSSxjQUFjLFdBQVcsbUJBQVgsQ0FBK0IsQ0FBL0IsRUFBa0MsQ0FBbEMsRUFBcUMsQ0FBckMsRUFBd0MsR0FBeEMsQ0FBbEI7O0FBRUEsUUFBSSxXQUFKLEdBQWtCLFdBQVcsV0FBN0I7QUFDQSxxQkFBYSxVQUFiLENBQXdCLFlBQVksQ0FBcEMsRUFBdUMsWUFBWSxDQUFuRCxFQUFzRCxZQUFZLEdBQWxFLEVBQXVFLFlBQVksSUFBbkYsRUFBeUYsWUFBWSxJQUFyRyxFQUEyRyxZQUFZLEtBQXZILEVBQThILFlBQVksV0FBMUksRUFBdUosWUFBWSxlQUFuSztBQUNBLFFBQUksV0FBSixHQUFrQixDQUFsQjs7QUFHQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBLFFBQUssS0FBSyxJQUFMLENBQVUsQ0FBQyxpQkFBaUIsQ0FBbEIsS0FBd0IsaUJBQWlCLENBQXpDLElBQThDLENBQUMsaUJBQWlCLENBQWxCLEtBQXdCLGlCQUFpQixDQUF6QyxDQUF4RCxJQUF1RyxLQUFLLEdBQUwsQ0FBUyxZQUFZLElBQXJCLEVBQTJCLENBQTNCLENBQXhHLElBQ0EsV0FBVyxNQUFYLEdBQXFCLEtBQUssR0FBTCxDQUFTLEtBQUssUUFBTCxDQUFjLEtBQXZCLEVBQThCLEtBQUssUUFBTCxDQUFjLE1BQTVDLENBRHpCLEVBQytFO0FBQzlFO0FBQ0E7O0FBRUQ7QUFDQSxRQUFJLEtBQUssV0FBVyxZQUFYLENBQXdCLENBQXhCLENBQVQ7QUFDQSxTQUFLLGFBQUwsQ0FBbUIsU0FBbkIsQ0FBNkIsRUFBN0IsSUFBbUM7QUFDbEMsU0FBSSxFQUQ4QixFQUMxQixZQUFZLFdBRGMsRUFDRCxpQkFBaUIsZUFEaEIsRUFDaUMsZ0JBQWdCLENBRGpELEVBQ29ELElBQUksQ0FEeEQsRUFDMkQsSUFBSTtBQUQvRCxLQUFuQztBQUdBLFFBQUksY0FBYyxnQ0FBb0IsRUFBcEIsQ0FBbEI7O0FBRUEsUUFBSSx3QkFBSixFQUF1QjtBQUN0QixzQkFBYSxVQUFiLENBQ0UsWUFBWSxDQURkLEVBQ2lCLFlBQVksQ0FEN0IsRUFDZ0MsS0FBSyxhQUFMLENBQW1CLFFBRG5ELEVBRUUsWUFBWSxJQUZkLEVBR0UsWUFBWSxJQUhkLEVBSUUsV0FKRixFQUtFLFdBTEYsRUFNRSxZQUFZLGVBTmQ7QUFRQTtBQUNEOztBQUVBLFFBQUksV0FBVyxDQUFYLEVBQWMsVUFBZCxJQUE0QixXQUFXLFVBQXZDLElBQXFELFdBQVcsQ0FBWCxFQUFjLG1CQUFuRSxJQUEwRixXQUFXLG1CQUF6RyxFQUE4SDs7QUFFN0gsVUFBSyxZQUFMLENBQWtCLElBQWxCLENBQXVCO0FBQ3RCLGlCQUFXLFNBRFc7QUFFdEIsaUJBQVcsV0FBVyxDQUFYLENBRlc7QUFHdEIsa0JBQVksVUFIVTtBQUl0QixhQUFPO0FBQ04sVUFBRyxDQURHLEVBQ0EsR0FBRztBQURILE9BSmU7QUFPdEIsaUJBQVcsQ0FQVztBQVF0QixjQUFRO0FBQ1AsV0FBSSxJQUFJLFlBQVksSUFBWixHQUFtQixDQURwQixFQUN1QixJQUFJLElBQUksWUFBWSxJQUFaLEdBQW1CLENBRGxELEVBQ3FELElBQUksSUFBSSxZQUFZLElBQVosR0FBbUIsQ0FEaEYsRUFDbUYsSUFBSSxJQUFJLFlBQVksSUFBWixHQUFtQjtBQUQ5RyxPQVJjO0FBV3RCLGFBQU87QUFYZSxNQUF2QjtBQWFBOztBQUVELHFCQUFpQixDQUFqQjtBQUNBLHFCQUFpQixDQUFqQjtBQUNBO0FBQ0Q7QUFDRDs7QUFFRCxLQUFJLE9BQUo7O0FBRUEsS0FBSSx3QkFBSixFQUNDLEtBQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixPQUE1Qjs7QUFFRDtBQUNBLEtBQUksZ0JBQWdCO0FBQ25CLFVBQVEsR0FEVyxFQUNOLE1BQU0sS0FBSyxRQUFMLENBQWMsR0FEZCxFQUNtQixtQkFBbUIsbUJBQWdCLGVBRHRELEVBQ3VFLGdCQUFnQixtQkFBZ0IsTUFBaEIsQ0FBdUIsVUFEOUcsRUFDMEgsZUFBZTtBQUR6SSxFQUFwQjtBQUdBLFFBQU8sYUFBUDtBQUNBLEM7O0FBdEpEOzs7O0FBQ0E7Ozs7QUFDQTs7Ozs7Ozs7Ozs7a0JDQWUsVUFBVSxRQUFWLEVBQW9CO0FBQ2pDLEtBQUksTUFBTSxTQUFTLGVBQVQsSUFBNEIsS0FBSyxRQUFMLENBQWMsR0FBcEQ7O0FBRUEsS0FBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixNQUFqRDtBQUNBLEtBQUksbUJBQW1CLENBQXZCLEVBQ0M7O0FBRUQsS0FBSSxXQUFXLEtBQUssYUFBTCxDQUFtQixRQUFsQzs7QUFFQSxLQUFJLElBQUo7O0FBRUEsS0FBSSxXQUFXLEtBQUssUUFBcEI7O0FBRUEsS0FBSSxTQUFKO0FBQ0EsS0FBSSxJQUFKLENBQVMsU0FBUyxFQUFsQixFQUFzQixTQUFTLEVBQS9CLEVBQW1DLFNBQVMsS0FBNUMsRUFBbUQsU0FBUyxNQUE1RDtBQUNBLEtBQUksSUFBSjs7QUFFQSxLQUFJLFVBQVUsRUFBZDs7QUFFQSxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0Qjs7QUFFQSxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsZUFBVixDQUFqQjtBQUNBLE1BQUksU0FBSixHQUFnQixXQUFXLGFBQTNCO0FBQ0EsTUFBSSxhQUFhLFdBQVcsVUFBNUI7O0FBRUEsTUFBSSxJQUFJLFdBQVIsRUFBcUI7QUFDcEIsT0FBSSxXQUFKLENBQWdCLGlCQUFpQixXQUFXLFlBQTVCLEVBQTBDLFdBQVcsYUFBckQsQ0FBaEI7QUFDQTs7QUFFRCxNQUFJLFdBQVcsV0FBVyxFQUExQjtBQUNBLE9BQUssYUFBTCxDQUFtQixTQUFuQixDQUE2QixRQUE3QixJQUF5QztBQUN4QyxlQUFZLFlBRDRCLEVBQ2QsaUJBQWlCO0FBREgsR0FBekM7QUFHQSxNQUFJLFdBQVcsb0JBQW9CLFFBQXBCLENBQWY7QUFDQSxXQUFTLFdBQVQsR0FBdUIsUUFBdkI7QUFDQTtBQUNBLFdBQVMsU0FBVCxHQUFxQixXQUFXLGFBQVgsR0FBMkIsQ0FBM0IsR0FBK0IsS0FBSyxHQUFMLENBQVMsV0FBVyxhQUFwQixFQUFtQyxDQUFuQyxDQUEvQixHQUF1RSxDQUE1Rjs7QUFFQSxNQUFJLFdBQVcsV0FBVyxTQUExQjtBQUNBLE1BQUksUUFBUSxTQUFTLENBQVQsQ0FBWjtBQUNBLE1BQUksV0FBSixHQUFrQixLQUFsQjs7QUFFQSxNQUFJLDZCQUE2QixJQUFqQztBQUNBLE1BQUksSUFBSSxDQUFSO0FBQUEsTUFBVyxDQUFYO0FBQUEsTUFBYyxDQUFkO0FBQ0EsTUFBSSxVQUFKLENBM0IyRCxDQTJCM0M7O0FBRWhCO0FBQ0E7O0FBRUEsTUFBSSxTQUFTLEVBQWI7O0FBRUEsTUFBSSxTQUFKO0FBQ0EsTUFBSSxXQUFXLE1BQVgsR0FBb0IsQ0FBeEIsRUFBMkI7O0FBRTFCLFFBQUssSUFBSSxDQUFULEVBQVksSUFBSSxXQUFXLE1BQTNCLEVBQW1DLEdBQW5DLEVBQXdDOztBQUV2QyxpQkFBYSxXQUFXLENBQVgsRUFBYyxPQUFkLEdBQXdCLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsRUFBeEIsR0FBb0QsV0FBVyxDQUFYLEVBQWMsQ0FBL0U7O0FBRUEsUUFBSSxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBckMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLFdBQTdGLEVBQ0M7O0FBRUQ7QUFDQTs7QUFFQSxRQUFJLE9BQVEsV0FBVyxDQUFYLEVBQWMsQ0FBdEIsS0FBNkIsUUFBakMsRUFBMkM7QUFDMUMsU0FBSSxJQUFJLENBQVIsRUFBVztBQUFDO0FBQ1gsbUJBQWEsTUFBYjtBQUNBLGVBQVMsRUFBVDtBQUNBOztBQUVEO0FBQ0E7O0FBRUQsUUFBSyxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQXJHLENBQWhELEdBQWdLLEVBQWpLLElBQXdLLENBQTVLO0FBQ0EsUUFBSyxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxXQUFXLENBQVgsRUFBYyxDQUFkLEdBQWtCLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQTFHLENBQWhELEdBQXFLLEVBQXRLLElBQTZLLENBQWpMOztBQUVBLFFBQUksS0FBSyxXQUFXLFlBQVgsQ0FBd0IsQ0FBeEIsQ0FBVDtBQUNBLFNBQUssYUFBTCxDQUFtQixTQUFuQixDQUE2QixFQUE3QixJQUFtQztBQUNsQyxTQUFJLEVBRDhCLEVBQzFCLFlBQVksV0FEYyxFQUNELGlCQUFpQixlQURoQixFQUNpQyxnQkFBZ0IsQ0FEakQsRUFDb0QsSUFBSSxDQUR4RCxFQUMyRCxJQUFJO0FBRC9ELEtBQW5DOztBQUtBLFdBQU8sT0FBTyxNQUFkLElBQXdCO0FBQ3ZCLFFBQUcsQ0FEb0IsRUFDakIsR0FBRztBQURjLEtBQXhCOztBQUtBO0FBQ0EsUUFBSSxXQUFXLENBQVgsRUFBYyxVQUFkLEdBQTJCLENBQTNCLElBQWdDLFdBQVcsVUFBWCxHQUF3QixDQUE1RCxFQUErRDs7QUFFOUQsU0FBSSxjQUFjLFdBQVcsbUJBQVgsQ0FBK0IsQ0FBL0IsRUFBa0MsQ0FBbEMsRUFBcUMsQ0FBckMsRUFBd0MsR0FBeEMsQ0FBbEI7QUFDQSxhQUFRLElBQVIsQ0FBYSxXQUFiOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSxTQUFJLGNBQWMsb0JBQW9CLEVBQXBCLENBQWxCOztBQUVBO0FBQ0EsU0FBSSx3QkFBSixFQUF1QjtBQUN0QixjQUFRLElBQVIsQ0FBYTtBQUNaLFVBQUcsQ0FEUyxFQUNOLEdBQUcsQ0FERyxFQUNBLEtBQUssUUFETDtBQUVaLGFBQU0sWUFBWSxJQUZOO0FBR1osYUFBTSxZQUFZLElBSE47QUFJWixjQUFPLFdBSks7QUFLWixvQkFBYSxXQUxEO0FBTVosd0JBQWlCLFlBQVk7QUFOakIsT0FBYjtBQVFBO0FBQ0Q7O0FBRUQ7QUFDQSxRQUFJLFdBQVcsQ0FBWCxFQUFjLFVBQWQsSUFBNEIsV0FBVyxVQUF2QyxJQUFxRCxXQUFXLENBQVgsRUFBYyxtQkFBbkUsSUFBMEYsV0FBVyxtQkFBekcsRUFBOEg7O0FBRTdILFVBQUssWUFBTCxDQUFrQixJQUFsQixDQUF1QjtBQUN0QixpQkFBVyxRQURXO0FBRXRCLGlCQUFXLFdBQVcsQ0FBWCxDQUZXO0FBR3RCLGtCQUFZLFVBSFU7QUFJdEIsYUFBTztBQUNOLFVBQUcsQ0FERyxFQUNBLEdBQUc7QUFESCxPQUplO0FBT3RCLGlCQUFXLFdBQVcsQ0FBWCxFQUFjLENBQWQsSUFBbUIsQ0FBbkIsR0FBdUIsQ0FBdkIsR0FBMkIsQ0FBQyxDQVBqQjtBQVF0QixhQUFPO0FBUmUsTUFBdkI7QUFXQTtBQUVEO0FBQ0Q7O0FBRUQsZUFBYSxNQUFiO0FBQ0E7O0FBRUQsY0FBYSxXQUFiLENBQXlCLE9BQXpCO0FBQ0EsS0FBSSxPQUFKOztBQUVBLEtBQUksU0FBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQ0MsU0FBUyxTQUFUOztBQUVELFVBQVMsWUFBVCxDQUFzQixNQUF0QixFQUE4Qjs7QUFFN0IsTUFBSSxLQUFLLGdCQUFnQixNQUFoQixFQUF3QixDQUF4QixDQUFUOztBQUVBLE1BQUksR0FBRyxNQUFILEdBQVksQ0FBaEIsRUFBbUI7QUFDbEIsT0FBSSxTQUFKO0FBQ0EsT0FBSSx3QkFBSixFQUNDLFNBQVMsU0FBVDs7QUFFRCxPQUFJLE1BQUosQ0FBVyxHQUFHLENBQUgsRUFBTSxDQUFqQixFQUFvQixHQUFHLENBQUgsRUFBTSxDQUExQjtBQUNBLE9BQUksd0JBQUosRUFDQyxTQUFTLE1BQVQsQ0FBZ0IsR0FBRyxDQUFILEVBQU0sQ0FBdEIsRUFBeUIsR0FBRyxDQUFILEVBQU0sQ0FBL0I7O0FBRUQsUUFBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEdBQUcsTUFBSCxHQUFZLENBQWhDLEVBQW1DLEtBQUssQ0FBeEMsRUFBMkM7O0FBRTFDLFFBQUksYUFBSixDQUFrQixHQUFHLElBQUksQ0FBUCxFQUFVLENBQTVCLEVBQStCLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBekMsRUFBNEMsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUF0RCxFQUF5RCxHQUFHLElBQUksQ0FBUCxFQUFVLENBQW5FLEVBQXNFLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBaEYsRUFBbUYsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUE3Rjs7QUFFQSxRQUFJLHdCQUFKLEVBQ0MsU0FBUyxhQUFULENBQXVCLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBakMsRUFBb0MsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUE5QyxFQUFpRCxHQUFHLElBQUksQ0FBUCxFQUFVLENBQTNELEVBQThELEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBeEUsRUFBMkUsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUFyRixFQUF3RixHQUFHLElBQUksQ0FBUCxFQUFVLENBQWxHOztBQUVELFFBQUksSUFBSSxDQUFKLElBQVMsSUFBSSxJQUFKLEtBQWEsQ0FBMUIsRUFBNkI7QUFDNUIsU0FBSSxNQUFKO0FBQ0EsU0FBSSxTQUFKO0FBQ0EsU0FBSSxNQUFKLENBQVcsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUFyQixFQUF3QixHQUFHLElBQUksQ0FBUCxFQUFVLENBQWxDOztBQUVBLFNBQUksd0JBQUosRUFBdUI7QUFDdEIsZUFBUyxNQUFUO0FBQ0EsZUFBUyxTQUFUO0FBQ0EsZUFBUyxNQUFULENBQWdCLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBMUIsRUFBNkIsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUF2QztBQUNBO0FBQ0Q7QUFDRDs7QUFFRCxPQUFJLE1BQUo7O0FBRUEsT0FBSSx3QkFBSixFQUNDLFNBQVMsTUFBVDtBQUNEO0FBQ0Q7O0FBRUQ7QUFDQSxLQUFJLGdCQUFnQjtBQUNuQixVQUFRLEdBRFcsRUFDTixNQUFNLEtBQUssUUFBTCxDQUFjLEdBRGQsRUFDbUIsbUJBQW1CLGdCQUFnQixjQUR0RCxFQUNzRSxnQkFBZ0IsZ0JBQWdCLE1BQWhCLENBQXVCLE1BRDdHLEVBQ3FILGVBQWU7QUFEcEksRUFBcEI7QUFHQSxRQUFPLGFBQVA7QUFDQSxDOztBQS9MRjs7QUFpTUMsSUFBSSxXQUFXLFNBQVgsUUFBVyxDQUFVLEdBQVYsRUFBZSxFQUFmLEVBQW1CLEVBQW5CLEVBQXVCLEVBQXZCLEVBQTJCLEVBQTNCLEVBQStCLEtBQS9CLEVBQXNDLGVBQXRDLEVBQXVELFdBQXZELEVBQW9FLEdBQXBFLEVBQXlFLE1BQXpFLEVBQWlGLElBQWpGLEVBQXVGLEtBQXZGLEVBQThGLFdBQTlGLEVBQTJHO0FBQ3pILEtBQUksT0FBUSxXQUFSLEtBQXlCLFdBQTdCLEVBQ0MsY0FBYyxDQUFkOztBQUVELG1CQUFrQixtQkFBbUIsQ0FBckM7QUFDQSxlQUFjLGVBQWUsT0FBN0I7QUFDQTtBQUNBLEtBQUksS0FBSyxFQUFUO0FBQUEsS0FBYSxLQUFLLEVBQWxCO0FBQUEsS0FBc0IsS0FBSyxFQUEzQjtBQUFBLEtBQStCLEtBQUssRUFBcEM7QUFBQSxLQUF3QyxLQUF4QztBQUFBLEtBQStDLEtBQS9DO0FBQ0EsS0FBSSxLQUFLLEVBQUwsR0FBVSxFQUFWLElBQWdCLEtBQUssRUFBTCxHQUFVLEVBQTlCLEVBQ0MsSUFBSSxhQUFhLENBQWpCLENBREQsS0FHQyxJQUFJLGFBQWEsT0FBTyxLQUFLLEdBQUwsQ0FBVSxLQUFLLEVBQWYsRUFBcUIsS0FBSyxFQUExQixDQUF4QjtBQUNEO0FBQ0EsS0FBSSxTQUFTLHlCQUFiO0FBQ0EsS0FBSSxTQUFTLDBCQUFiO0FBQ0E7QUFDQSxLQUFJLFNBQVMsS0FBYjs7QUFFQSxLQUFJLFNBQUo7QUFDQSxLQUFJLE1BQUosQ0FBVyxFQUFYLEVBQWUsRUFBZjtBQUNBLEtBQUksSUFBSjtBQUNBLEtBQUksU0FBSixHQUFnQixNQUFoQjs7QUFFQSxLQUFJLFdBQUosR0FBa0IsV0FBbEI7QUFDQSxLQUFJLFFBQUosQ0FBYSxFQUFiLEVBQWlCLEVBQWpCLEVBQXFCLEtBQUssRUFBMUIsRUFBOEIsS0FBSyxFQUFuQztBQUNBLEtBQUksV0FBSixHQUFrQixDQUFsQjs7QUFFQSxLQUFJLGtCQUFrQixDQUF0QixFQUF5QjtBQUN4QixNQUFJLFNBQVMsa0JBQWtCLENBQWxCLEtBQXdCLENBQXhCLEdBQTRCLENBQTVCLEdBQWdDLEVBQTdDO0FBQ0EsTUFBSSxTQUFKO0FBQ0EsTUFBSSxTQUFKLEdBQWdCLGVBQWhCO0FBQ0EsTUFBSSxXQUFKLEdBQWtCLFdBQWxCO0FBQ0EsTUFBSSxNQUFKLENBQVcsRUFBWCxFQUFlLEVBQWY7QUFDQSxNQUFJLElBQUosQ0FBUyxLQUFLLE1BQWQsRUFBc0IsS0FBSyxNQUEzQixFQUFtQyxLQUFLLEVBQUwsR0FBVSxJQUFJLE1BQWpELEVBQXlELEtBQUssRUFBTCxHQUFVLElBQUksTUFBdkU7QUFDQSxNQUFJLE1BQUo7QUFDQTs7QUFFRCxLQUFJLE9BQUo7QUFDQTtBQUNBLEtBQUksUUFBUSxJQUFaLEVBQWtCO0FBQ2pCO0FBQ0EsTUFBSSxJQUFKO0FBQ0EsTUFBSSxTQUFKO0FBQ0EsTUFBSSxNQUFKLENBQVcsRUFBWCxFQUFlLEVBQWY7QUFDQSxNQUFJLE1BQUosQ0FBVyxLQUFLLFVBQWhCLEVBQTRCLEtBQUssVUFBakM7QUFDQSxNQUFJLE1BQUosQ0FBVyxLQUFLLFVBQWhCLEVBQTRCLEtBQUssVUFBakM7QUFDQSxNQUFJLE1BQUosQ0FBVyxFQUFYLEVBQWUsRUFBZjtBQUNBLE1BQUksU0FBSjtBQUNBLE1BQUksTUFBTSxJQUFJLG9CQUFKLENBQXlCLENBQUMsS0FBSyxFQUFOLElBQVksQ0FBckMsRUFBd0MsS0FBSyxVQUE3QyxFQUF5RCxDQUFDLEtBQUssRUFBTixJQUFZLENBQXJFLEVBQXdFLEVBQXhFLENBQVY7QUFDQSxNQUFJLFlBQUosQ0FBaUIsQ0FBakIsRUFBb0IsTUFBcEI7QUFDQSxNQUFJLFlBQUosQ0FBaUIsQ0FBakIsRUFBb0IsTUFBcEI7QUFDQSxNQUFJLFNBQUosR0FBZ0IsR0FBaEI7QUFDQSxNQUFJLElBQUo7QUFDQTtBQUNBLE1BQUksT0FBSjtBQUNBOztBQUdELEtBQUksV0FBVyxJQUFmLEVBQXFCO0FBQ3BCLE1BQUksSUFBSjtBQUNBLE1BQUksU0FBSjtBQUNBLE1BQUksTUFBSixDQUFXLEVBQVgsRUFBZSxFQUFmO0FBQ0EsTUFBSSxNQUFKLENBQVcsS0FBSyxVQUFoQixFQUE0QixLQUFLLFVBQWpDO0FBQ0EsTUFBSSxNQUFKLENBQVcsS0FBSyxVQUFoQixFQUE0QixLQUFLLFVBQWpDO0FBQ0EsTUFBSSxNQUFKLENBQVcsRUFBWCxFQUFlLEVBQWY7QUFDQSxNQUFJLFNBQUo7QUFDQSxNQUFJLE1BQU0sSUFBSSxvQkFBSixDQUF5QixDQUFDLEtBQUssRUFBTixJQUFZLENBQXJDLEVBQXdDLEtBQUssVUFBN0MsRUFBeUQsQ0FBQyxLQUFLLEVBQU4sSUFBWSxDQUFyRSxFQUF3RSxFQUF4RSxDQUFWO0FBQ0EsTUFBSSxZQUFKLENBQWlCLENBQWpCLEVBQW9CLE1BQXBCO0FBQ0EsTUFBSSxZQUFKLENBQWlCLENBQWpCLEVBQW9CLE1BQXBCO0FBQ0EsTUFBSSxTQUFKLEdBQWdCLEdBQWhCO0FBQ0E7QUFDQSxNQUFJLElBQUo7QUFDQSxNQUFJLE9BQUo7QUFDQTs7QUFFRCxLQUFJLFNBQVMsSUFBYixFQUFtQjtBQUNsQjtBQUNBLE1BQUksSUFBSjtBQUNBLE1BQUksU0FBSjtBQUNBLE1BQUksTUFBSixDQUFXLEVBQVgsRUFBZSxFQUFmO0FBQ0EsTUFBSSxNQUFKLENBQVcsS0FBSyxVQUFoQixFQUE0QixLQUFLLFVBQWpDO0FBQ0EsTUFBSSxNQUFKLENBQVcsS0FBSyxVQUFoQixFQUE0QixLQUFLLFVBQWpDO0FBQ0EsTUFBSSxNQUFKLENBQVcsRUFBWCxFQUFlLEVBQWY7QUFDQSxNQUFJLFNBQUo7QUFDQSxNQUFJLE1BQU0sSUFBSSxvQkFBSixDQUF5QixLQUFLLFVBQTlCLEVBQTBDLENBQUMsS0FBSyxFQUFOLElBQVksQ0FBdEQsRUFBeUQsRUFBekQsRUFBNkQsQ0FBQyxLQUFLLEVBQU4sSUFBWSxDQUF6RSxDQUFWO0FBQ0EsTUFBSSxZQUFKLENBQWlCLENBQWpCLEVBQW9CLE1BQXBCO0FBQ0EsTUFBSSxZQUFKLENBQWlCLENBQWpCLEVBQW9CLE1BQXBCO0FBQ0EsTUFBSSxTQUFKLEdBQWdCLEdBQWhCO0FBQ0EsTUFBSSxJQUFKO0FBQ0E7QUFDQSxNQUFJLE9BQUo7QUFDQTs7QUFHRCxLQUFJLFVBQVUsSUFBZCxFQUFvQjtBQUNuQixNQUFJLElBQUo7QUFDQSxNQUFJLFNBQUo7QUFDQSxNQUFJLE1BQUosQ0FBVyxFQUFYLEVBQWUsRUFBZjtBQUNBLE1BQUksTUFBSixDQUFXLEtBQUssVUFBaEIsRUFBNEIsS0FBSyxVQUFqQztBQUNBLE1BQUksTUFBSixDQUFXLEtBQUssVUFBaEIsRUFBNEIsS0FBSyxVQUFqQztBQUNBLE1BQUksTUFBSixDQUFXLEVBQVgsRUFBZSxFQUFmO0FBQ0EsTUFBSSxNQUFNLElBQUksb0JBQUosQ0FBeUIsS0FBSyxVQUE5QixFQUEwQyxDQUFDLEtBQUssRUFBTixJQUFZLENBQXRELEVBQXlELEVBQXpELEVBQTZELENBQUMsS0FBSyxFQUFOLElBQVksQ0FBekUsQ0FBVjtBQUNBLE1BQUksWUFBSixDQUFpQixDQUFqQixFQUFvQixNQUFwQjtBQUNBLE1BQUksWUFBSixDQUFpQixDQUFqQixFQUFvQixNQUFwQjtBQUNBLE1BQUksU0FBSixHQUFnQixHQUFoQjtBQUNBLE1BQUksWUFBSixDQUFpQixDQUFqQixFQUFvQixNQUFwQjtBQUNBLE1BQUksWUFBSixDQUFpQixDQUFqQixFQUFvQixNQUFwQjtBQUNBLE1BQUksU0FBSixHQUFnQixHQUFoQjtBQUNBLE1BQUksSUFBSjtBQUNBLE1BQUksU0FBSjtBQUNBO0FBQ0EsTUFBSSxPQUFKO0FBQ0E7QUFDRDtBQUVBLENBbkhEOzs7Ozs7Ozs7a0JDL0xjLFVBQVUsUUFBVixFQUFvQjtBQUNsQyxLQUFJLE1BQU0sU0FBUyxlQUFULElBQTRCLEtBQUssUUFBTCxDQUFjLEdBQXBEOztBQUVBLEtBQUksa0JBQWtCLFNBQVMsaUJBQVQsQ0FBMkIsTUFBakQ7O0FBRUEsS0FBSSxtQkFBbUIsQ0FBdkIsRUFDQzs7QUFFRCxLQUFJLFdBQVcsS0FBSyxhQUFMLENBQW1CLFFBQWxDOztBQUVBLEtBQUksYUFBYSxTQUFTLEtBQVQsQ0FBZSxlQUFoQztBQUNBLEtBQUksYUFBYSxTQUFTLEtBQVQsQ0FBZSxlQUFoQztBQUNBLEtBQUksVUFBVSxFQUFkOztBQUVBLEtBQUksV0FBVyxLQUFLLFFBQXBCO0FBQ0EsS0FBSSxJQUFKOztBQUVBLEtBQUksd0JBQUosRUFDQyxTQUFTLElBQVQ7O0FBRUQsS0FBSSxTQUFKO0FBQ0EsS0FBSSxJQUFKLENBQVMsU0FBUyxFQUFsQixFQUFzQixTQUFTLEVBQS9CLEVBQW1DLFNBQVMsS0FBNUMsRUFBbUQsU0FBUyxNQUE1RDtBQUNBLEtBQUksSUFBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLFdBQVMsU0FBVDtBQUNBLFdBQVMsSUFBVCxDQUFjLFNBQVMsRUFBdkIsRUFBMkIsU0FBUyxFQUFwQyxFQUF3QyxTQUFTLEtBQWpELEVBQXdELFNBQVMsTUFBakU7QUFDQSxXQUFTLElBQVQ7QUFDQTs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0Qjs7QUFFQSxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsZUFBVixDQUFqQjs7QUFFQSxNQUFJLGFBQWEsV0FBVyxVQUE1Qjs7QUFFQSxNQUFJLFdBQVcsV0FBVyxFQUExQjtBQUNBLE9BQUssYUFBTCxDQUFtQixTQUFuQixDQUE2QixRQUE3QixJQUF5QztBQUN4QyxlQUFZLFlBRDRCLEVBQ2QsaUJBQWlCO0FBREgsR0FBekM7O0FBSUEsTUFBSSxXQUFXLG9CQUFvQixRQUFwQixDQUFmO0FBQ0EsV0FBUyxTQUFULEdBQXFCLFFBQXJCO0FBQ0E7QUFDQTs7QUFFQSxZQUFVLEVBQVY7O0FBRUEsTUFBSSw2QkFBNkIsSUFBakM7QUFDQSxNQUFJLElBQUksQ0FBUjtBQUFBLE1BQVcsQ0FBWDtBQUFBLE1BQWMsQ0FBZDtBQUNBLE1BQUksVUFBSixDQXRCMkQsQ0FzQjNDOztBQUVoQixNQUFJLGVBQWdCLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELElBQUksU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBNUYsQ0FBaEQsR0FBdUosRUFBeEosSUFBK0osQ0FBbEw7QUFDQSxNQUFJLEtBQUo7O0FBRUEsTUFBSSxhQUFhLElBQWpCOztBQUVBLE1BQUksU0FBUyxFQUFiOztBQUVBLE1BQUksV0FBVyxNQUFYLEdBQW9CLENBQXhCLEVBQTJCO0FBQzFCO0FBQ0EsV0FBUSxXQUFXLFNBQVgsQ0FBcUIsSUFBSSxXQUFXLFNBQVgsQ0FBcUIsTUFBOUMsQ0FBUjtBQUNBLE9BQUksU0FBSixHQUFnQixLQUFoQjtBQUNBLE9BQUksV0FBSixHQUFrQixLQUFsQjtBQUNBLE9BQUksU0FBSixHQUFnQixXQUFXLGFBQTNCOztBQUVBLE9BQUksSUFBSSxXQUFSLEVBQXFCO0FBQ3BCLFFBQUksV0FBSixDQUFnQixpQkFBaUIsV0FBVyxZQUE1QixFQUEwQyxXQUFXLGFBQXJELENBQWhCO0FBQ0E7O0FBRUQsVUFBTyxJQUFJLFdBQVcsTUFBdEIsRUFBOEIsR0FBOUIsRUFBbUM7O0FBRWxDLGlCQUFhLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsR0FBMEIsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixFQUExQixHQUFzRCxXQUFXLENBQVgsRUFBYyxDQUFqRjs7QUFFQSxRQUFJLGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUFyQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBN0YsRUFBMEc7QUFDekc7QUFDQTs7QUFFRCxRQUFJLE9BQVEsV0FBVyxDQUFYLEVBQWMsQ0FBdEIsS0FBNkIsUUFBakMsRUFBMkM7QUFDMUMsU0FBSSxJQUFJLENBQVIsRUFBVztBQUNWO0FBQ0EsZUFBUyxFQUFUO0FBQ0E7QUFDRDtBQUNBOztBQUVELFFBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUFyRyxDQUFoRCxHQUFnSyxFQUFqSyxJQUF3SyxDQUE1SztBQUNBLFFBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsV0FBVyxDQUFYLEVBQWMsQ0FBZCxHQUFrQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUExRyxDQUFoRCxHQUFxSyxFQUF0SyxJQUE2SyxDQUFqTDs7QUFHQSxRQUFJLEtBQUssV0FBVyxZQUFYLENBQXdCLENBQXhCLENBQVQ7QUFDQSxTQUFLLGFBQUwsQ0FBbUIsU0FBbkIsQ0FBNkIsRUFBN0IsSUFBbUM7QUFDbEMsU0FBSSxFQUQ4QixFQUMxQixZQUFZLFdBRGMsRUFDRCxpQkFBaUIsZUFEaEIsRUFDaUMsZ0JBQWdCLENBRGpELEVBQ29ELElBQUksQ0FEeEQsRUFDMkQsSUFBSTtBQUQvRCxLQUFuQzs7QUFJQSxXQUFPLE9BQU8sTUFBZCxJQUF3QjtBQUN2QixRQUFHLENBRG9CLEVBQ2pCLEdBQUc7QUFEYyxLQUF4Qjs7QUFJQTtBQUNBLFFBQUksV0FBVyxDQUFYLEVBQWMsVUFBZCxLQUE2QixDQUFqQyxFQUFvQztBQUNuQyxTQUFJLFdBQVcsQ0FBWCxFQUFjLFVBQWQsR0FBMkIsQ0FBM0IsSUFBZ0MsV0FBVyxVQUFYLEdBQXdCLENBQTVELEVBQStEO0FBQzlELFVBQUksY0FBYyxXQUFXLG1CQUFYLENBQStCLENBQS9CLEVBQWtDLENBQWxDLEVBQXFDLENBQXJDLEVBQXdDLEdBQXhDLENBQWxCO0FBQ0EsY0FBUSxJQUFSLENBQWEsV0FBYjs7QUFFQTtBQUNBO0FBQ0E7O0FBRUEsVUFBSSxjQUFjLG9CQUFvQixFQUFwQixDQUFsQjs7QUFFQSxVQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLGVBQVEsSUFBUixDQUFhO0FBQ1osV0FBRyxDQURTLEVBQ04sR0FBRyxDQURHLEVBQ0EsS0FBSyxRQURMO0FBRVosY0FBTSxZQUFZLElBRk47QUFHWixjQUFNLFlBQVksSUFITjtBQUlaLGVBQU8sV0FKSztBQUtaLHFCQUFhLFdBTEQ7QUFNWix5QkFBaUIsWUFBWTtBQU5qQixRQUFiO0FBUUE7QUFDRDtBQUNEOztBQUdEO0FBQ0EsUUFBSSxXQUFXLENBQVgsRUFBYyxVQUFkLElBQTRCLFdBQVcsVUFBdkMsSUFBcUQsV0FBVyxDQUFYLEVBQWMsbUJBQW5FLElBQTBGLFdBQVcsbUJBQXpHLEVBQThIOztBQUU3SCxVQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUI7QUFDdEIsaUJBQVcsWUFEVztBQUV0QixpQkFBVyxXQUFXLENBQVgsQ0FGVztBQUd0QixrQkFBWSxVQUhVO0FBSXRCLGFBQU87QUFDTixVQUFHLENBREcsRUFDQSxHQUFHO0FBREgsT0FKZTtBQU90QixpQkFBVyxXQUFXLENBQVgsRUFBYyxDQUFkLElBQW1CLENBQW5CLEdBQXVCLENBQXZCLEdBQTJCLENBQUMsQ0FQakI7QUFRdEIsYUFBTztBQVJlLE1BQXZCO0FBV0E7QUFDRDs7QUFFRDs7QUFFQSxnQkFBYSxXQUFiLENBQXlCLE9BQXpCO0FBQ0E7QUFDRDs7QUFFRCxLQUFJLE9BQUo7O0FBRUEsS0FBSSx3QkFBSixFQUNDLEtBQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixPQUE1Qjs7QUFFRCxVQUFTLGdCQUFULEdBQTRCO0FBQzNCLE1BQUksS0FBSyxnQkFBZ0IsTUFBaEIsRUFBd0IsQ0FBeEIsQ0FBVDs7QUFFQSxNQUFJLEdBQUcsTUFBSCxHQUFZLENBQWhCLEVBQW1CO0FBQ2xCLE9BQUksU0FBSjtBQUNBLE9BQUksTUFBSixDQUFXLEdBQUcsQ0FBSCxFQUFNLENBQWpCLEVBQW9CLEdBQUcsQ0FBSCxFQUFNLENBQTFCOztBQUVBLE9BQUksd0JBQUosRUFBdUI7QUFDdEIsYUFBUyxTQUFUO0FBQ0EsYUFBUyxNQUFULENBQWdCLEdBQUcsQ0FBSCxFQUFNLENBQXRCLEVBQXlCLEdBQUcsQ0FBSCxFQUFNLENBQS9CO0FBQ0E7O0FBR0QsUUFBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEdBQUcsTUFBSCxHQUFZLENBQWhDLEVBQW1DLEtBQUssQ0FBeEMsRUFBMkM7O0FBRTFDLFFBQUksYUFBSixDQUFrQixHQUFHLElBQUksQ0FBUCxFQUFVLENBQTVCLEVBQStCLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBekMsRUFBNEMsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUF0RCxFQUF5RCxHQUFHLElBQUksQ0FBUCxFQUFVLENBQW5FLEVBQXNFLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBaEYsRUFBbUYsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUE3Rjs7QUFFQSxRQUFJLHdCQUFKLEVBQ0MsU0FBUyxhQUFULENBQXVCLEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBakMsRUFBb0MsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUE5QyxFQUFpRCxHQUFHLElBQUksQ0FBUCxFQUFVLENBQTNELEVBQThELEdBQUcsSUFBSSxDQUFQLEVBQVUsQ0FBeEUsRUFBMkUsR0FBRyxJQUFJLENBQVAsRUFBVSxDQUFyRixFQUF3RixHQUFHLElBQUksQ0FBUCxFQUFVLENBQWxHO0FBRUQ7O0FBRUQsT0FBSSxXQUFXLGFBQVgsR0FBMkIsQ0FBL0IsRUFDQyxJQUFJLE1BQUo7O0FBRUQsT0FBSSxTQUFTLEtBQVQsQ0FBZSxlQUFmLElBQWtDLENBQWxDLElBQXVDLFNBQVMsS0FBVCxDQUFlLGVBQWYsSUFBa0MsQ0FBN0UsRUFBZ0Y7QUFDL0UsWUFBUSxZQUFSO0FBQ0EsSUFGRCxNQUdLLElBQUksU0FBUyxLQUFULENBQWUsZUFBZixHQUFpQyxDQUFyQyxFQUNKLFFBQVEsV0FBVyxFQUFuQixDQURJLEtBRUEsSUFBSSxTQUFTLEtBQVQsQ0FBZSxlQUFmLEdBQWlDLENBQXJDLEVBQ0osUUFBUSxXQUFXLEVBQW5COztBQUVELGdCQUFhO0FBQ1osT0FBRyxHQUFHLENBQUgsRUFBTSxDQURHLEVBQ0EsR0FBRyxHQUFHLENBQUgsRUFBTTtBQURULElBQWI7O0FBSUEsT0FBSSxNQUFKLENBQVcsR0FBRyxHQUFHLE1BQUgsR0FBWSxDQUFmLEVBQWtCLENBQTdCLEVBQWdDLEtBQWhDO0FBQ0EsT0FBSSxNQUFKLENBQVcsV0FBVyxDQUF0QixFQUF5QixLQUF6QjtBQUNBLE9BQUksU0FBSjs7QUFFQSxPQUFJLFdBQUosR0FBa0IsV0FBVyxXQUE3QjtBQUNBLE9BQUksSUFBSjtBQUNBLE9BQUksV0FBSixHQUFrQixDQUFsQjs7QUFFQSxPQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLGFBQVMsTUFBVCxDQUFnQixHQUFHLEdBQUcsTUFBSCxHQUFZLENBQWYsRUFBa0IsQ0FBbEMsRUFBcUMsS0FBckM7QUFDQSxhQUFTLE1BQVQsQ0FBZ0IsV0FBVyxDQUEzQixFQUE4QixLQUE5QjtBQUNBLGFBQVMsU0FBVDtBQUNBLGFBQVMsSUFBVDtBQUNBO0FBQ0Q7QUFDRDs7QUFFRDtBQUNBLEtBQUksZ0JBQWdCO0FBQ25CLFVBQVEsR0FEVyxFQUNOLE1BQU0sS0FBSyxRQUFMLENBQWMsR0FEZCxFQUNtQixtQkFBbUIsZ0JBQWdCLGNBRHRELEVBQ3NFLGdCQUFnQixnQkFBZ0IsTUFBaEIsQ0FBdUIsTUFEN0csRUFDcUgsZUFBZTtBQURwSSxFQUFwQjtBQUdBLFFBQU8sYUFBUDtBQUNBLEM7O0FBeE5EOzs7Ozs7Ozs7a0JDSWUsVUFBVSxRQUFWLEVBQW9CO0FBQ2xDLEtBQUksTUFBTSxTQUFTLGVBQVQsSUFBNEIsS0FBSyxRQUFMLENBQWMsR0FBcEQ7O0FBRUEsS0FBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixNQUFqRDs7QUFFQSxLQUFJLG1CQUFtQixDQUF2QixFQUNDOztBQUVELEtBQUksUUFBUSxJQUFaO0FBQ0EsS0FBSSxVQUFVLEVBQWQ7O0FBRUEsS0FBSSxXQUFXLEtBQUssUUFBcEI7O0FBRUEsS0FBSSxVQUFVLEVBQWQ7O0FBRUEsS0FBSSxhQUFhLEVBQWpCO0FBQ0E7O0FBRUEsS0FBSSxJQUFJLENBQVI7QUFBQSxLQUFXLENBQVg7QUFBQSxLQUFjLENBQWQ7QUFDQSxLQUFJLFVBQUosQ0FuQmtDLENBbUJsQjs7QUFFaEI7QUFDQSxLQUFJLGVBQWdCLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELElBQUksU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBNUYsQ0FBakQsSUFBMEosQ0FBN0s7O0FBRUEsS0FBSSxXQUFXLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsT0FBdkM7O0FBRUEsS0FBSSxXQUFXLEtBQUssYUFBTCxDQUFtQixRQUFsQzs7QUFFQSxLQUFJLHdCQUFKLEVBQ0MsU0FBUyxTQUFUOztBQUVELEtBQUksSUFBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQ0MsU0FBUyxJQUFUOztBQUVELEtBQUksU0FBSjtBQUNBLEtBQUksSUFBSixDQUFTLFNBQVMsRUFBbEIsRUFBc0IsU0FBUyxFQUEvQixFQUFtQyxTQUFTLEtBQTVDLEVBQW1ELFNBQVMsTUFBNUQ7QUFDQSxLQUFJLElBQUo7O0FBRUEsS0FBSSx3QkFBSixFQUF1QjtBQUN0QixXQUFTLFNBQVQ7QUFDQSxXQUFTLElBQVQsQ0FBYyxTQUFTLEVBQXZCLEVBQTJCLFNBQVMsRUFBcEMsRUFBd0MsU0FBUyxLQUFqRCxFQUF3RCxTQUFTLE1BQWpFO0FBQ0EsV0FBUyxJQUFUO0FBQ0E7O0FBRUQsS0FBSSxnQkFBZ0IsRUFBcEI7QUFDQSxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0QjtBQUNBLE1BQUksYUFBYSxLQUFLLElBQUwsQ0FBVSxlQUFWLENBQWpCO0FBQ0EsTUFBSSxhQUFhLFdBQVcsVUFBNUI7QUFDQSxNQUFJLE1BQUo7O0FBRUEsYUFBVyxnQkFBWCxHQUE4QixFQUE5Qjs7QUFFQSxPQUFLLElBQUksQ0FBVCxFQUFZLElBQUksV0FBVyxNQUEzQixFQUFtQyxHQUFuQyxFQUF3QztBQUN2QyxZQUFTLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsR0FBMEIsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixFQUExQixHQUFzRCxXQUFXLENBQVgsRUFBYyxDQUE3RTtBQUNBLGNBQVcsZ0JBQVgsQ0FBNEIsTUFBNUIsSUFBc0MsQ0FBdEM7O0FBRUEsT0FBSSxDQUFDLGNBQWMsTUFBZCxDQUFMLEVBQTRCO0FBQzNCLGVBQVcsSUFBWCxDQUFnQixNQUFoQjtBQUNBLGtCQUFjLE1BQWQsSUFBd0IsSUFBeEI7QUFDQTtBQUNEOztBQUVELGFBQVcsSUFBWCxDQUFnQixxQkFBaEI7QUFDQTs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0Qjs7QUFFQSxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsZUFBVixDQUFqQjtBQUNBLE1BQUksYUFBYSxXQUFXLFVBQTVCO0FBQ0EsTUFBSSw2QkFBNkIsSUFBakM7O0FBRUEsTUFBSSxvQkFBb0IsRUFBeEI7O0FBR0EsTUFBSSxXQUFXLFdBQVcsRUFBMUI7QUFDQSxPQUFLLGFBQUwsQ0FBbUIsU0FBbkIsQ0FBNkIsUUFBN0IsSUFBeUM7QUFDeEMsZUFBWSxZQUQ0QixFQUNkLGlCQUFpQjtBQURILEdBQXpDO0FBR0EsTUFBSSxXQUFXLGdDQUFvQixRQUFwQixDQUFmO0FBQ0EsV0FBUyxTQUFULEdBQXFCLFFBQXJCOztBQUlBLE1BQUksV0FBVyxNQUFYLEdBQW9CLENBQXhCLEVBQTJCOztBQUUxQixXQUFRLFdBQVcsU0FBWCxDQUFxQixDQUFyQixDQUFSO0FBQ0E7QUFDQSxPQUFJLFNBQUosR0FBZ0IsS0FBaEI7QUFDQSxPQUFJLFdBQUosR0FBa0IsS0FBbEI7QUFDQSxPQUFJLFNBQUosR0FBZ0IsV0FBVyxhQUEzQjs7QUFFQSxPQUFJLElBQUksV0FBUixFQUFxQjtBQUNwQixRQUFJLFdBQUosQ0FBZ0IsNkJBQWlCLFdBQVcsWUFBNUIsRUFBMEMsV0FBVyxhQUFyRCxDQUFoQjtBQUNBOztBQUVELFFBQUssSUFBSSxDQUFULEVBQVksSUFBSSxXQUFXLE1BQTNCLEVBQW1DLEdBQW5DLEVBQXdDOztBQUV2QyxpQkFBYSxXQUFXLENBQVgsQ0FBYjtBQUNBLFFBQUksWUFBWSxJQUFoQjs7QUFFQSxRQUFJLFdBQVcsZ0JBQVgsQ0FBNEIsVUFBNUIsS0FBMkMsQ0FBL0MsRUFDQyxZQUFZLFdBQVcsV0FBVyxnQkFBWCxDQUE0QixVQUE1QixDQUFYLENBQVosQ0FERCxLQUdDLFlBQVk7QUFDWCxRQUFHLFVBRFEsRUFDSSxHQUFHO0FBRFAsS0FBWjs7QUFJRCxRQUFJLGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUFyQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBN0YsRUFBMEc7QUFDekc7QUFDQTs7QUFFRCxRQUFJLE9BQVEsVUFBVSxDQUFsQixLQUF5QixRQUE3QixFQUNDOztBQUVELFFBQUksSUFBSyxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQXJHLENBQWhELEdBQWdLLEVBQWpLLElBQXdLLENBQWhMO0FBQ0E7QUFDQSxRQUFJLElBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsVUFBVSxDQUFWLEdBQWMsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBdEcsQ0FBekQ7O0FBRUEsUUFBSSxTQUFTLFFBQVEsVUFBUixJQUFzQixRQUFRLFVBQVIsQ0FBdEIsR0FBNEMsQ0FBekQ7O0FBRUEsUUFBSSxJQUFJLE1BQVI7QUFDQSxzQkFBa0IsSUFBbEIsQ0FBdUIsRUFBRSxHQUFHLENBQUwsRUFBUSxHQUFHLGVBQWUsTUFBMUIsRUFBdkI7QUFDQSxZQUFRLFVBQVIsSUFBc0IsZUFBZSxDQUFyQzs7QUFFQSxRQUFJLDBCQUFKLEVBQWdDO0FBQy9CLFNBQUksU0FBSjtBQUNBLFNBQUksTUFBSixDQUFXLENBQVgsRUFBYyxDQUFkOztBQUVBLFNBQUksd0JBQUosRUFBdUI7QUFDdEIsZUFBUyxTQUFUO0FBQ0EsZUFBUyxNQUFULENBQWdCLENBQWhCLEVBQW1CLENBQW5CO0FBQ0E7O0FBRUQsa0NBQTZCLEtBQTdCO0FBQ0EsS0FWRCxNQVdLOztBQUVKLFNBQUksTUFBSixDQUFXLENBQVgsRUFBYyxDQUFkOztBQUVBLFNBQUksd0JBQUosRUFDQyxTQUFTLE1BQVQsQ0FBZ0IsQ0FBaEIsRUFBbUIsQ0FBbkI7O0FBRUQsU0FBSSxJQUFJLEdBQUosSUFBVyxDQUFmLEVBQWtCOztBQUVqQixVQUFJLFdBQVcsYUFBWCxHQUEyQixDQUEvQixFQUNDLElBQUksTUFBSjs7QUFFRCxhQUFPLGtCQUFrQixNQUFsQixHQUEyQixDQUFsQyxFQUFxQztBQUNwQyxXQUFJLFFBQVEsa0JBQWtCLEdBQWxCLEVBQVo7QUFDQSxXQUFJLE1BQUosQ0FBVyxNQUFNLENBQWpCLEVBQW9CLE1BQU0sQ0FBMUI7O0FBRUEsV0FBSSx3QkFBSixFQUNDLFNBQVMsTUFBVCxDQUFnQixNQUFNLENBQXRCLEVBQXlCLE1BQU0sQ0FBL0I7QUFFRDs7QUFFRCxVQUFJLFNBQUo7O0FBRUEsVUFBSSxXQUFKLEdBQWtCLFdBQVcsV0FBN0I7QUFDQSxVQUFJLElBQUo7QUFDQSxVQUFJLFdBQUosR0FBa0IsQ0FBbEI7O0FBRUEsVUFBSSxTQUFKO0FBQ0EsVUFBSSxNQUFKLENBQVcsQ0FBWCxFQUFjLENBQWQ7O0FBRUEsVUFBSSx3QkFBSixFQUF1QjtBQUN0QixnQkFBUyxTQUFUO0FBQ0EsZ0JBQVMsSUFBVDs7QUFFQSxnQkFBUyxTQUFUO0FBQ0EsZ0JBQVMsTUFBVCxDQUFnQixDQUFoQixFQUFtQixDQUFuQjtBQUNBOztBQUVELHdCQUFrQixJQUFsQixDQUF1QixFQUFFLEdBQUcsQ0FBTCxFQUFRLEdBQUcsZUFBZSxNQUExQixFQUF2QjtBQUNBO0FBRUQ7O0FBRUQsUUFBSSxXQUFXLGdCQUFYLENBQTRCLFVBQTVCLEtBQTJDLENBQS9DLEVBQWtEO0FBQ2pELFNBQUksS0FBSyxXQUFXLFlBQVgsQ0FBd0IsV0FBVyxnQkFBWCxDQUE0QixVQUE1QixDQUF4QixDQUFUO0FBQ0EsVUFBSyxhQUFMLENBQW1CLFNBQW5CLENBQTZCLEVBQTdCLElBQW1DO0FBQ2xDLFVBQUksRUFEOEIsRUFDMUIsWUFBWSxXQURjLEVBQ0QsaUJBQWlCLGVBRGhCLEVBQ2lDLGdCQUFnQixXQUFXLGdCQUFYLENBQTRCLFVBQTVCLENBRGpELEVBQzBGLElBQUksQ0FEOUYsRUFDaUcsSUFBSTtBQURyRyxNQUFuQztBQUdBOztBQUVEO0FBQ0EsUUFBSSxXQUFXLGdCQUFYLENBQTRCLFVBQTVCLEtBQTJDLENBQTNDLElBQWdELFVBQVUsVUFBVixLQUF5QixDQUE3RSxFQUFnRjtBQUMvRSxTQUFJLFVBQVUsVUFBVixHQUF1QixDQUF2QixJQUE0QixXQUFXLFVBQVgsR0FBd0IsQ0FBeEQsRUFBMkQ7O0FBRTFELFVBQUksY0FBYyxXQUFXLG1CQUFYLENBQStCLENBQS9CLEVBQWtDLENBQWxDLEVBQXFDLENBQXJDLEVBQXdDLEdBQXhDLENBQWxCO0FBQ0EsY0FBUSxJQUFSLENBQWEsV0FBYjs7QUFFQTtBQUNBO0FBQ0E7O0FBRUEsb0JBQWMsZ0NBQW9CLEVBQXBCLENBQWQ7O0FBRUEsVUFBSSx3QkFBSixFQUF1QjtBQUN0QixlQUFRLElBQVIsQ0FBYTtBQUNaLFdBQUcsQ0FEUyxFQUNOLEdBQUcsQ0FERyxFQUNBLEtBQUssUUFETDtBQUVaLGNBQU0sWUFBWSxJQUZOO0FBR1osY0FBTSxZQUFZLElBSE47QUFJWixlQUFPLFdBSks7QUFLWixxQkFBYSxXQUxEO0FBTVoseUJBQWlCLFlBQVk7QUFOakIsUUFBYjtBQVFBO0FBQ0Q7QUFDRDs7QUFFRCxRQUFJLFVBQVUsVUFBVixJQUF3QixXQUFXLFVBQW5DLElBQWlELFVBQVUsbUJBQTNELElBQWtGLFdBQVcsbUJBQWpHLEVBQXNIOztBQUVySCxVQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUI7QUFDdEIsaUJBQVcsYUFEVztBQUV0QixpQkFBVyxTQUZXO0FBR3RCLGtCQUFZLFVBSFU7QUFJdEIsYUFBTztBQUNOLFVBQUcsQ0FERyxFQUNBLEdBQUc7QUFESCxPQUplO0FBT3RCLGlCQUFXLFdBQVcsQ0FBWCxFQUFjLENBQWQsSUFBbUIsQ0FBbkIsR0FBdUIsQ0FBdkIsR0FBMkIsQ0FBQyxDQVBqQjtBQVF0QixhQUFPO0FBUmUsTUFBdkI7QUFXQTtBQUNEOztBQUVELE9BQUksV0FBVyxhQUFYLEdBQTJCLENBQS9CLEVBQ0MsSUFBSSxNQUFKOztBQUVELFVBQU8sa0JBQWtCLE1BQWxCLEdBQTJCLENBQWxDLEVBQXFDO0FBQ3BDLFFBQUksUUFBUSxrQkFBa0IsR0FBbEIsRUFBWjtBQUNBLFFBQUksTUFBSixDQUFXLE1BQU0sQ0FBakIsRUFBb0IsTUFBTSxDQUExQjs7QUFFQSxRQUFJLHdCQUFKLEVBQ0MsU0FBUyxNQUFULENBQWdCLE1BQU0sQ0FBdEIsRUFBeUIsTUFBTSxDQUEvQjtBQUNEOztBQUVELE9BQUksU0FBSjs7QUFFQSxPQUFJLFdBQUosR0FBa0IsV0FBVyxXQUE3QjtBQUNBLE9BQUksSUFBSjtBQUNBLE9BQUksV0FBSixHQUFrQixDQUFsQjs7QUFFQSxPQUFJLFNBQUo7QUFDQSxPQUFJLE1BQUosQ0FBVyxDQUFYLEVBQWMsQ0FBZDs7QUFFQSxPQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLGFBQVMsU0FBVDtBQUNBLGFBQVMsSUFBVDtBQUNBLGFBQVMsU0FBVDtBQUNBLGFBQVMsTUFBVCxDQUFnQixDQUFoQixFQUFtQixDQUFuQjtBQUNBO0FBQ0Q7O0FBRUQsU0FBUSxXQUFXLGdCQUFuQjtBQUNBOztBQUVELGtCQUFhLFdBQWIsQ0FBeUIsT0FBekI7O0FBR0EsS0FBSSxPQUFKOztBQUVBLEtBQUksd0JBQUosRUFDQyxTQUFTLE9BQVQ7O0FBRUQ7QUFDQSxLQUFJLGdCQUFnQjtBQUNuQixVQUFRLEdBRFcsRUFDTixNQUFNLEtBQUssUUFBTCxDQUFjLEdBRGQsRUFDbUIsbUJBQW1CLG1CQUFnQixjQUR0RCxFQUNzRSxnQkFBZ0IsbUJBQWdCLE1BQWhCLENBQXVCLE1BRDdHLEVBQ3FILGVBQWU7QUFEcEksRUFBcEI7QUFHQSxRQUFPLGFBQVA7QUFDQSxDOztBQXpSRDs7OztBQUNBOzs7O0FBQ0E7Ozs7Ozs7Ozs7O2tCQ0VlLFVBQVMsUUFBVCxFQUFtQjtBQUNqQyxLQUFJLE1BQU0sU0FBUyxlQUFULElBQTRCLEtBQUssUUFBTCxDQUFjLEdBQXBEOztBQUVBLEtBQUksa0JBQWtCLFNBQVMsaUJBQVQsQ0FBMkIsTUFBakQ7O0FBRUEsS0FBSSxtQkFBbUIsQ0FBdkIsRUFDQzs7QUFFRCxLQUFJLFFBQVEsSUFBWjs7QUFFQSxLQUFJLFdBQVcsS0FBSyxRQUFwQjtBQUNBLEtBQUksVUFBVSxFQUFkOztBQUVBLEtBQUksVUFBVSxFQUFkOztBQUVBLEtBQUksYUFBYSxFQUFqQjtBQUNBOztBQUVBLEtBQUksSUFBSSxDQUFSO0FBQUEsS0FBVyxDQUFYO0FBQUEsS0FBYyxDQUFkO0FBQ0EsS0FBSSxVQUFKLENBbkJpQyxDQW1CakI7OztBQUdoQjtBQUNBLEtBQUksZUFBZ0IsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsSUFBSSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUE1RixDQUFqRCxJQUEwSixDQUE3Szs7QUFFQSxLQUFJLGNBQWMsS0FBSyxpQkFBTCxHQUF5QixLQUFLLGlCQUE5QixHQUFrRCxLQUFLLEtBQUwsR0FBYSxHQUFiLElBQW9CLENBQXhGO0FBQ0EsS0FBSSxXQUFXLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsT0FBdkM7QUFDQSxLQUFJLFdBQWMsU0FBUyxLQUFULEdBQWlCLEtBQUssR0FBTCxDQUFTLFNBQVMsS0FBVCxDQUFlLGVBQWYsR0FBaUMsU0FBUyxLQUFULENBQWUsZUFBekQsQ0FBbEIsR0FBK0YsS0FBSyxHQUFMLENBQVMsUUFBVCxDQUFoRyxHQUFzSCxFQUF2SCxJQUE4SCxDQUE3STs7QUFFQSxLQUFJLFdBQVcsS0FBSyxhQUFMLENBQW1CLFFBQWxDOztBQUVBLEtBQUksSUFBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQ0MsU0FBUyxJQUFUOztBQUdELEtBQUksU0FBSjtBQUNBLEtBQUksSUFBSixDQUFTLFNBQVMsRUFBbEIsRUFBc0IsU0FBUyxFQUEvQixFQUFtQyxTQUFTLEtBQTVDLEVBQW1ELFNBQVMsTUFBNUQ7QUFDQSxLQUFJLElBQUo7O0FBRUEsS0FBSSx3QkFBSixFQUF1QjtBQUN0QixXQUFTLFNBQVQ7QUFDQSxXQUFTLElBQVQsQ0FBYyxTQUFTLEVBQXZCLEVBQTJCLFNBQVMsRUFBcEMsRUFBd0MsU0FBUyxLQUFqRCxFQUF3RCxTQUFTLE1BQWpFO0FBQ0EsV0FBUyxJQUFUO0FBQ0E7O0FBRUQsS0FBSSxnQkFBZ0IsRUFBcEI7QUFDQSxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0QjtBQUNBLE1BQUksYUFBYSxLQUFLLElBQUwsQ0FBVSxlQUFWLENBQWpCO0FBQ0EsTUFBSSxhQUFhLFdBQVcsVUFBNUI7QUFDQSxNQUFJLE1BQUo7O0FBRUEsYUFBVyxnQkFBWCxHQUE4QixFQUE5Qjs7QUFFQSxPQUFLLElBQUksQ0FBVCxFQUFZLElBQUksV0FBVyxNQUEzQixFQUFtQyxHQUFuQyxFQUF3QztBQUN2QyxZQUFTLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsR0FBMEIsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixFQUExQixHQUFzRCxXQUFXLENBQVgsRUFBYyxDQUE3RTtBQUNBLGNBQVcsZ0JBQVgsQ0FBNEIsTUFBNUIsSUFBc0MsQ0FBdEM7O0FBRUEsT0FBSSxDQUFDLGNBQWMsTUFBZCxDQUFMLEVBQTRCO0FBQzNCLGVBQVcsSUFBWCxDQUFnQixNQUFoQjtBQUNBLGtCQUFjLE1BQWQsSUFBd0IsSUFBeEI7QUFDQTtBQUNEOztBQUVELGFBQVcsSUFBWCxDQUFnQixxQkFBaEI7QUFDQTs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0Qjs7QUFFQSxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsZUFBVixDQUFqQjtBQUNBLE1BQUksYUFBYSxXQUFXLFVBQTVCO0FBQ0EsTUFBSSw2QkFBNkIsSUFBakM7O0FBR0EsTUFBSSxXQUFXLFdBQVcsRUFBMUI7QUFDQSxPQUFLLGFBQUwsQ0FBbUIsU0FBbkIsQ0FBNkIsUUFBN0IsSUFBeUM7QUFDeEMsZUFBWSxZQUQ0QixFQUNkLGlCQUFpQjtBQURILEdBQXpDO0FBR0EsTUFBSSxXQUFXLGdDQUFvQixRQUFwQixDQUFmO0FBQ0EsV0FBUyxTQUFULEdBQXFCLFFBQXJCOztBQUVBLE1BQUksV0FBVyxNQUFYLElBQXFCLENBQXpCLEVBQ0MsV0FBVyxXQUFYOztBQUVELE1BQUksV0FBVyxDQUFmLEVBQ0MsV0FBVyxDQUFYLENBREQsS0FFSyxJQUFJLFdBQVcsV0FBZixFQUNKLFdBQVcsV0FBWDs7QUFFRCxNQUFJLG9CQUFvQixFQUF4Qjs7QUFFQSxNQUFJLFdBQVcsTUFBWCxHQUFvQixDQUF4QixFQUEyQjs7QUFFMUIsV0FBUSxXQUFXLFNBQVgsQ0FBcUIsSUFBSSxXQUFXLFNBQVgsQ0FBcUIsTUFBOUMsQ0FBUjtBQUNBO0FBQ0EsT0FBSSxTQUFKLEdBQWdCLEtBQWhCO0FBQ0EsT0FBSSxXQUFKLEdBQWtCLEtBQWxCO0FBQ0EsT0FBSSxTQUFKLEdBQWdCLFdBQVcsYUFBM0I7O0FBRUEsT0FBSSxJQUFJLFdBQVIsRUFBcUI7QUFDcEIsUUFBSSxXQUFKLENBQWdCLDZCQUFpQixXQUFXLFlBQTVCLEVBQTBDLFdBQVcsYUFBckQsQ0FBaEI7QUFDQTs7QUFFRCxPQUFJLGVBQWdCLFdBQVcsQ0FBWixHQUFpQixLQUFqQixHQUF5QixLQUE1Qzs7QUFFQTs7QUFFQSxRQUFLLElBQUksQ0FBVCxFQUFZLElBQUksV0FBVyxNQUEzQixFQUFtQyxHQUFuQyxFQUF3Qzs7QUFFdkMsaUJBQWEsV0FBVyxDQUFYLENBQWI7QUFDQSxRQUFJLFlBQVksSUFBaEI7O0FBRUEsUUFBSSxXQUFXLGdCQUFYLENBQTRCLFVBQTVCLEtBQTJDLENBQS9DLEVBQ0MsWUFBWSxXQUFXLFdBQVcsZ0JBQVgsQ0FBNEIsVUFBNUIsQ0FBWCxDQUFaLENBREQsS0FHQyxZQUFZO0FBQ1gsUUFBRyxVQURRLEVBQ0ksR0FBRztBQURQLEtBQVo7O0FBSUQsUUFBSSxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBckMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLFdBQTdGLEVBQTBHO0FBQ3pHO0FBQ0E7O0FBRUQsUUFBSSxPQUFRLFVBQVUsQ0FBbEIsS0FBeUIsUUFBN0IsRUFDQzs7QUFFRCxRQUFJLFFBQUo7QUFDQSxRQUFJLFNBQVMsY0FBVCxDQUF3QixVQUF4QixNQUF3QyxDQUE1QyxFQUNDLFdBQVcsVUFBVSxDQUFWLEdBQWMsU0FBUyxjQUFULENBQXdCLFVBQXhCLENBQWQsR0FBb0QsR0FBL0QsQ0FERCxLQUdDLFdBQVcsQ0FBWDs7QUFFRCxRQUFJLElBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUFyRyxDQUFoRCxHQUFnSyxFQUFqSyxJQUF3SyxDQUFoTDtBQUNBLFFBQUksSUFBSyxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxXQUFXLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQW5HLENBQXpEOztBQUVBLFFBQUksU0FBUyxRQUFRLFVBQVIsSUFBc0IsUUFBUSxVQUFSLENBQXRCLEdBQTRDLENBQXpEOztBQUVBLFFBQUksSUFBSSxNQUFSO0FBQ0Esc0JBQWtCLElBQWxCLENBQXVCLEVBQUUsR0FBRyxDQUFMLEVBQVEsR0FBRyxlQUFlLE1BQTFCLEVBQXZCO0FBQ0EsWUFBUSxVQUFSLElBQXNCLGVBQWUsQ0FBckM7O0FBRUEsUUFBSSwwQkFBSixFQUFnQztBQUMvQixTQUFJLFNBQUo7QUFDQSxTQUFJLE1BQUosQ0FBVyxDQUFYLEVBQWMsQ0FBZDs7QUFFQSxTQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLGVBQVMsU0FBVDtBQUNBLGVBQVMsTUFBVCxDQUFnQixDQUFoQixFQUFtQixDQUFuQjtBQUNBOztBQUVELGtDQUE2QixLQUE3QjtBQUNBLEtBVkQsTUFXSzs7QUFFSixTQUFJLE1BQUosQ0FBVyxDQUFYLEVBQWMsQ0FBZDs7QUFFQSxTQUFJLHdCQUFKLEVBQ0MsU0FBUyxNQUFULENBQWdCLENBQWhCLEVBQW1CLENBQW5COztBQUVELFNBQUksSUFBSSxHQUFKLElBQVcsQ0FBZixFQUFrQjs7QUFFakIsVUFBSSxXQUFXLGFBQVgsR0FBMkIsQ0FBL0IsRUFDQyxJQUFJLE1BQUo7O0FBRUQsYUFBTyxrQkFBa0IsTUFBbEIsR0FBMkIsQ0FBbEMsRUFBcUM7QUFDcEMsV0FBSSxRQUFRLGtCQUFrQixHQUFsQixFQUFaO0FBQ0EsV0FBSSxNQUFKLENBQVcsTUFBTSxDQUFqQixFQUFvQixNQUFNLENBQTFCOztBQUVBLFdBQUksd0JBQUosRUFDQyxTQUFTLE1BQVQsQ0FBZ0IsTUFBTSxDQUF0QixFQUF5QixNQUFNLENBQS9CO0FBQ0Q7O0FBRUQsVUFBSSxTQUFKOztBQUVBLFVBQUksV0FBSixHQUFrQixXQUFXLFdBQTdCO0FBQ0EsVUFBSSxJQUFKO0FBQ0EsVUFBSSxXQUFKLEdBQWtCLENBQWxCOztBQUVBLFVBQUksU0FBSjtBQUNBLFVBQUksTUFBSixDQUFXLENBQVgsRUFBYyxDQUFkOztBQUVBLFVBQUksd0JBQUosRUFBdUI7QUFDdEIsZ0JBQVMsU0FBVDtBQUNBLGdCQUFTLElBQVQ7QUFDQSxnQkFBUyxTQUFUO0FBQ0EsZ0JBQVMsTUFBVCxDQUFnQixDQUFoQixFQUFtQixDQUFuQjtBQUNBOztBQUVELHdCQUFrQixJQUFsQixDQUF1QixFQUFFLEdBQUcsQ0FBTCxFQUFRLEdBQUcsZUFBZSxNQUExQixFQUF2QjtBQUNBO0FBQ0Q7O0FBR0QsUUFBSSxXQUFXLGdCQUFYLENBQTRCLFVBQTVCLEtBQTJDLENBQS9DLEVBQWtEO0FBQ2pELFNBQUksS0FBSyxXQUFXLFlBQVgsQ0FBd0IsV0FBVyxnQkFBWCxDQUE0QixVQUE1QixDQUF4QixDQUFUO0FBQ0EsVUFBSyxhQUFMLENBQW1CLFNBQW5CLENBQTZCLEVBQTdCLElBQW1DO0FBQ2xDLFVBQUksRUFEOEIsRUFDMUIsWUFBWSxXQURjLEVBQ0QsaUJBQWlCLGVBRGhCLEVBQ2lDLGdCQUFnQixXQUFXLGdCQUFYLENBQTRCLFVBQTVCLENBRGpELEVBQzBGLElBQUksQ0FEOUYsRUFDaUcsSUFBSTtBQURyRyxNQUFuQztBQUdBOztBQUVEO0FBQ0EsUUFBSSxXQUFXLGdCQUFYLENBQTRCLFVBQTVCLEtBQTJDLENBQTNDLElBQWdELFVBQVUsVUFBVixLQUF5QixDQUE3RSxFQUFnRjtBQUMvRSxTQUFJLFVBQVUsVUFBVixHQUF1QixDQUF2QixJQUE0QixXQUFXLFVBQVgsR0FBd0IsQ0FBeEQsRUFBMkQ7QUFDMUQsVUFBSSxjQUFjLFdBQVcsbUJBQVgsQ0FBK0IsQ0FBL0IsRUFBa0MsQ0FBbEMsRUFBcUMsQ0FBckMsRUFBd0MsR0FBeEMsQ0FBbEI7QUFDQSxjQUFRLElBQVIsQ0FBYSxXQUFiOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSxvQkFBYyxnQ0FBb0IsRUFBcEIsQ0FBZDs7QUFFQSxVQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLGVBQVEsSUFBUixDQUFhO0FBQ1osV0FBRyxDQURTLEVBQ04sR0FBRyxDQURHLEVBQ0EsS0FBSyxRQURMO0FBRVosY0FBTSxZQUFZLElBRk47QUFHWixjQUFNLFlBQVksSUFITjtBQUlaLGVBQU8sV0FKSztBQUtaLHFCQUFhLFdBTEQ7QUFNWix5QkFBaUIsWUFBWTtBQU5qQixRQUFiO0FBUUE7QUFDRDtBQUNEOztBQUVELFFBQUksVUFBVSxVQUFWLElBQXdCLFdBQVcsVUFBbkMsSUFBaUQsVUFBVSxtQkFBM0QsSUFBa0YsV0FBVyxtQkFBakcsRUFBc0g7O0FBRXJILFVBQUssWUFBTCxDQUFrQixJQUFsQixDQUF1QjtBQUN0QixpQkFBVyxnQkFEVztBQUV0QixpQkFBVyxTQUZXO0FBR3RCLGtCQUFZLFVBSFU7QUFJdEIsYUFBTztBQUNOLFVBQUcsQ0FERyxFQUNBLEdBQUc7QUFESCxPQUplO0FBT3RCLGlCQUFXLFdBQVcsQ0FBWCxFQUFjLENBQWQsSUFBbUIsQ0FBbkIsR0FBdUIsQ0FBdkIsR0FBMkIsQ0FBQyxDQVBqQjtBQVF0QixhQUFPO0FBUmUsTUFBdkI7QUFXQTtBQUNEOztBQUVELE9BQUksV0FBVyxhQUFYLEdBQTJCLENBQS9CLEVBQ0MsSUFBSSxNQUFKOztBQUVELFVBQU8sa0JBQWtCLE1BQWxCLEdBQTJCLENBQWxDLEVBQXFDO0FBQ3BDLFFBQUksUUFBUSxrQkFBa0IsR0FBbEIsRUFBWjtBQUNBLFFBQUksTUFBSixDQUFXLE1BQU0sQ0FBakIsRUFBb0IsTUFBTSxDQUExQjs7QUFFQSxRQUFJLHdCQUFKLEVBQ0MsU0FBUyxNQUFULENBQWdCLE1BQU0sQ0FBdEIsRUFBeUIsTUFBTSxDQUEvQjtBQUNEOztBQUVELE9BQUksU0FBSjs7QUFFQSxPQUFJLFdBQUosR0FBa0IsV0FBVyxXQUE3QjtBQUNBLE9BQUksSUFBSjtBQUNBLE9BQUksV0FBSixHQUFrQixDQUFsQjs7QUFFQSxPQUFJLFNBQUo7QUFDQSxPQUFJLE1BQUosQ0FBVyxDQUFYLEVBQWMsQ0FBZDs7QUFFQSxPQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLGFBQVMsU0FBVDtBQUNBLGFBQVMsSUFBVDtBQUNBLGFBQVMsU0FBVDtBQUNBLGFBQVMsTUFBVCxDQUFnQixDQUFoQixFQUFtQixDQUFuQjtBQUNBO0FBQ0Q7O0FBRUQsU0FBUSxXQUFXLGdCQUFuQjtBQUNBOztBQUVELGtCQUFhLFdBQWIsQ0FBeUIsT0FBekI7O0FBRUEsS0FBSSxPQUFKOztBQUVBLEtBQUksd0JBQUosRUFDQyxTQUFTLE9BQVQ7O0FBRUQ7QUFDQSxLQUFJLGdCQUFnQjtBQUNuQixVQUFRLEdBRFcsRUFDTixNQUFNLEtBQUssUUFBTCxDQUFjLEdBRGQsRUFDbUIsbUJBQW1CLG1CQUFnQixjQUR0RCxFQUNzRSxnQkFBZ0IsbUJBQWdCLE1BQWhCLENBQXVCLE1BRDdHLEVBQ3FILGVBQWU7QUFEcEksRUFBcEI7QUFHQSxRQUFPLGFBQVA7QUFDQSxDOztBQXJTRDs7OztBQUNBOzs7O0FBQ0E7Ozs7Ozs7Ozs7O2tCQ0FlLFVBQVUsUUFBVixFQUFvQjtBQUNsQyxLQUFJLE1BQU0sU0FBUyxlQUFULElBQTRCLEtBQUssUUFBTCxDQUFjLEdBQXBEO0FBQ0EsS0FBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixNQUFqRDs7QUFFQSxLQUFJLG1CQUFtQixDQUF2QixFQUNDOztBQUVELEtBQUksUUFBUSxJQUFaOztBQUVBLEtBQUksV0FBVyxLQUFLLFFBQXBCOztBQUVBLEtBQUksa0JBQWtCLEVBQXRCO0FBQ0EsS0FBSSxrQkFBa0IsRUFBdEI7O0FBRUEsS0FBSSxJQUFJLENBQVI7QUFBQSxLQUFXLENBQVg7QUFBQSxLQUFjLENBQWQ7QUFDQSxLQUFJLFVBQUosQ0Fma0MsQ0FlbEI7O0FBRWhCO0FBQ0EsS0FBSSxlQUFnQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxJQUFJLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQTVGLENBQWpELElBQTBKLENBQTdLOztBQUVBLEtBQUksY0FBYyxLQUFLLGlCQUFMLEdBQXlCLEtBQUssaUJBQTlCLEdBQWtELEtBQUssTUFBTCxHQUFjLEdBQWQsSUFBcUIsQ0FBekY7QUFDQSxLQUFJLFdBQVcsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixPQUF2QztBQUNBLEtBQUksV0FBYyxTQUFTLE1BQVQsR0FBa0IsS0FBSyxHQUFMLENBQVMsU0FBUyxLQUFULENBQWUsZUFBZixHQUFpQyxTQUFTLEtBQVQsQ0FBZSxlQUF6RCxDQUFuQixHQUFnRyxLQUFLLEdBQUwsQ0FBUyxRQUFULENBQWpHLEdBQXVILFNBQVMsUUFBVCxDQUFrQixTQUFsQixDQUE0QixNQUFuSixHQUE0SixFQUE3SixJQUFvSyxDQUFuTDs7QUFFQSxLQUFJLFdBQVcsV0FBZixFQUNDLFdBQVcsV0FBWCxDQURELEtBRUssSUFBSSxhQUFhLFFBQWpCLEVBQTJCO0FBQy9CLGFBQVcsV0FBWDtBQUNBLEVBRkksTUFFRSxJQUFJLFdBQVcsQ0FBZixFQUNOLFdBQVcsQ0FBWDs7QUFFRCxLQUFJLElBQUo7O0FBRUEsS0FBSSx3QkFBSixFQUNDLEtBQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixJQUE1Qjs7QUFFRCxLQUFJLFNBQUo7QUFDQSxLQUFJLElBQUosQ0FBUyxTQUFTLEVBQWxCLEVBQXNCLFNBQVMsRUFBL0IsRUFBbUMsU0FBUyxLQUE1QyxFQUFtRCxTQUFTLE1BQTVEO0FBQ0EsS0FBSSxJQUFKOztBQUVBLEtBQUksd0JBQUosRUFBdUI7QUFDdEIsT0FBSyxhQUFMLENBQW1CLFFBQW5CLENBQTRCLElBQTVCLENBQWlDLFNBQVMsRUFBMUMsRUFBOEMsU0FBUyxFQUF2RCxFQUEyRCxTQUFTLEtBQXBFLEVBQTJFLFNBQVMsTUFBcEY7QUFDQSxPQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsSUFBNUI7QUFDQTs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0Qjs7QUFFQSxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsZUFBVixDQUFqQjtBQUNBLE1BQUksYUFBYSxXQUFXLFVBQTVCO0FBQ0EsTUFBSSw2QkFBNkIsSUFBakM7O0FBRUE7O0FBRUEsTUFBSSxXQUFXLE1BQVgsR0FBb0IsQ0FBeEIsRUFBMkI7QUFDMUI7O0FBRUEsT0FBSSxlQUFnQixXQUFXLENBQVosSUFBa0IsV0FBVyxZQUE3QixHQUE0QyxJQUE1QyxHQUFtRCxLQUF0RTs7QUFFQSxPQUFJLFdBQUosR0FBa0IsVUFBbEI7O0FBRUEsUUFBSyxJQUFJLENBQVQsRUFBWSxJQUFJLFdBQVcsTUFBM0IsRUFBbUMsR0FBbkMsRUFBd0M7O0FBRXZDLGlCQUFhLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsR0FBMEIsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixFQUExQixHQUFzRCxXQUFXLENBQVgsRUFBYyxDQUFqRjs7QUFHQSxRQUFJLGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUFyQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBN0YsRUFBMEc7QUFDekc7QUFDQTs7QUFFRCxRQUFJLE9BQVEsV0FBVyxDQUFYLEVBQWMsQ0FBdEIsS0FBNkIsUUFBakMsRUFDQzs7QUFFRCxRQUFLLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELGFBQWEsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBckcsQ0FBaEQsR0FBZ0ssRUFBakssSUFBd0ssQ0FBNUs7QUFDQTtBQUNBLFFBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsV0FBVyxDQUFYLEVBQWMsQ0FBZCxHQUFrQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUExRyxDQUFyRDs7QUFFQTs7QUFFQSxRQUFJLEtBQUssSUFBSyxTQUFTLFFBQVQsQ0FBa0IsU0FBbEIsQ0FBNEIsTUFBNUIsR0FBcUMsUUFBckMsR0FBZ0QsQ0FBckQsR0FBMkQsU0FBUyxLQUFULEdBQWlCLFFBQTVFLElBQXlGLENBQWxHO0FBQ0EsUUFBSSxLQUFLLEtBQUssUUFBTCxJQUFpQixDQUExQjtBQUNBLFFBQUksRUFBSjtBQUNBLFFBQUksRUFBSjs7QUFFQSxRQUFJLFdBQVcsQ0FBWCxFQUFjLENBQWQsSUFBbUIsQ0FBdkIsRUFBMEI7QUFDekIsU0FBSSxTQUFTLGdCQUFnQixVQUFoQixJQUE4QixnQkFBZ0IsVUFBaEIsQ0FBOUIsR0FBNEQsQ0FBekU7O0FBRUEsVUFBSyxlQUFlLE1BQXBCO0FBQ0EsVUFBSyxJQUFJLE1BQVQ7O0FBRUEscUJBQWdCLFVBQWhCLElBQThCLFVBQVUsS0FBSyxFQUFmLENBQTlCO0FBRUEsS0FSRCxNQVFPO0FBQ04sU0FBSSxTQUFTLGdCQUFnQixVQUFoQixJQUE4QixnQkFBZ0IsVUFBaEIsQ0FBOUIsR0FBNEQsQ0FBekU7O0FBRUEsVUFBSyxJQUFJLE1BQVQ7QUFDQSxVQUFLLGVBQWUsTUFBcEI7O0FBRUEscUJBQWdCLFVBQWhCLElBQThCLFVBQVUsS0FBSyxFQUFmLENBQTlCO0FBQ0E7O0FBR0QsWUFBUSxXQUFXLENBQVgsRUFBYyxLQUFkLEdBQXNCLFdBQVcsQ0FBWCxFQUFjLEtBQXBDLEdBQTRDLFdBQVcsU0FBWCxDQUFxQixJQUFJLFdBQVcsU0FBWCxDQUFxQixNQUE5QyxDQUFwRDtBQUNBLGFBQVMsR0FBVCxFQUFjLEVBQWQsRUFBa0IsRUFBbEIsRUFBc0IsRUFBdEIsRUFBMEIsRUFBMUIsRUFBOEIsS0FBOUIsRUFBcUMsQ0FBckMsRUFBd0MsSUFBeEMsRUFBOEMsWUFBOUMsRUFBNEQsS0FBNUQsRUFBbUUsS0FBbkUsRUFBMEUsS0FBMUUsRUFBaUYsV0FBVyxXQUE1Rjs7QUFFQSxRQUFJLEtBQUssV0FBVyxZQUFYLENBQXdCLENBQXhCLENBQVQ7QUFDQSxTQUFLLGFBQUwsQ0FBbUIsU0FBbkIsQ0FBNkIsRUFBN0IsSUFBbUM7QUFDbEMsU0FBSSxFQUQ4QixFQUMxQixZQUFZLFdBRGMsRUFDRCxpQkFBaUIsZUFEaEIsRUFDaUMsZ0JBQWdCLENBRGpELEVBQ29ELElBQUksRUFEeEQsRUFDNEQsSUFBSSxFQURoRSxFQUNvRSxJQUFJLEVBRHhFLEVBQzRFLElBQUk7QUFEaEYsS0FBbkM7QUFHQSxZQUFRLG9CQUFvQixFQUFwQixDQUFSOztBQUVBLFFBQUksd0JBQUosRUFDQyxTQUFTLEtBQUssYUFBTCxDQUFtQixRQUE1QixFQUFzQyxFQUF0QyxFQUEwQyxFQUExQyxFQUE4QyxFQUE5QyxFQUFrRCxFQUFsRCxFQUFzRCxLQUF0RCxFQUE2RCxDQUE3RCxFQUFnRSxJQUFoRSxFQUFzRSxLQUF0RSxFQUE2RSxLQUE3RSxFQUFvRixLQUFwRixFQUEyRixLQUEzRjs7QUFFRCxRQUFJLFdBQVcsQ0FBWCxFQUFjLFVBQWQsSUFBNEIsV0FBVyxVQUF2QyxJQUFxRCxXQUFXLENBQVgsRUFBYyxtQkFBbkUsSUFBMEYsV0FBVyxtQkFBekcsRUFDQyxLQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUI7QUFDdEIsZ0JBQVcsWUFEVztBQUV0QixnQkFBVyxXQUFXLENBQVgsQ0FGVztBQUd0QixpQkFBWSxVQUhVO0FBSXRCLFlBQU87QUFDTixTQUFHLFdBQVcsQ0FBWCxFQUFjLENBQWQsSUFBbUIsQ0FBbkIsR0FBdUIsRUFBdkIsR0FBNEIsRUFEekIsRUFDNkIsR0FBRztBQURoQyxNQUplO0FBT3RCLGdCQUFXLFdBQVcsQ0FBWCxFQUFjLENBQWQsSUFBbUIsQ0FBbkIsR0FBdUIsQ0FBdkIsR0FBMkIsQ0FBQyxDQVBqQjtBQVF0QixhQUFRO0FBQ1AsVUFBSSxLQUFLLEdBQUwsQ0FBUyxFQUFULEVBQWEsRUFBYixDQURHLEVBQ2UsSUFBSSxFQURuQixFQUN1QixJQUFJLEtBQUssR0FBTCxDQUFTLEVBQVQsRUFBYSxFQUFiLENBRDNCLEVBQzZDLElBQUk7QUFEakQsTUFSYztBQVd0QixZQUFPO0FBWGUsS0FBdkI7QUFhRDtBQUNEO0FBQ0Q7O0FBRUQsS0FBSSxPQUFKOztBQUVBLEtBQUksd0JBQUosRUFDQyxLQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsT0FBNUI7O0FBRUQ7QUFDQSxLQUFJLGdCQUFnQixLQUFLLEdBQUwsQ0FBUyxZQUFULEVBQXVCLFNBQVMsS0FBVCxDQUFlLFlBQWYsQ0FBNEIsRUFBbkQsQ0FBcEI7QUFDQSxLQUFJLGdCQUFnQjtBQUNuQixVQUFRLEdBRFcsRUFDTixNQUFNLEtBQUssUUFBTCxDQUFjLEdBRGQsRUFDbUIsbUJBQW1CLGdCQUFnQixlQUR0RCxFQUN1RSxnQkFBZ0IsZ0JBQWdCLE1BQWhCLENBQXVCLFlBRDlHLEVBQzRILGVBQWU7QUFEM0ksRUFBcEI7QUFHQSxRQUFPLGFBQVA7QUFDQSxDOztBQWxKRDs7Ozs7Ozs7O2tCQ0VlLFVBQVUsUUFBVixFQUFvQjtBQUNsQyxLQUFJLE1BQU0sU0FBUyxlQUFULElBQTRCLEtBQUssUUFBTCxDQUFjLEdBQXBEO0FBQ0EsS0FBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixNQUFqRDs7QUFFQSxLQUFJLG1CQUFtQixDQUF2QixFQUNDOztBQUVELEtBQUksUUFBUSxJQUFaOztBQUVBLEtBQUksV0FBVyxLQUFLLFFBQXBCOztBQUVBLEtBQUksa0JBQWtCLEVBQXRCO0FBQ0EsS0FBSSxrQkFBa0IsRUFBdEI7O0FBRUEsS0FBSSxJQUFJLENBQVI7QUFBQSxLQUFXLENBQVg7QUFBQSxLQUFjLENBQWQ7QUFDQSxLQUFJLFVBQUosQ0Fma0MsQ0FlbEI7O0FBRWhCO0FBQ0EsS0FBSSxlQUFnQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxJQUFJLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQTVGLENBQWpELElBQTBKLENBQTdLOztBQUVBLEtBQUksY0FBYyxLQUFLLGlCQUFMLEdBQXlCLEtBQUssaUJBQTlCLEdBQWtELEtBQUssTUFBTCxHQUFjLEdBQWQsSUFBcUIsQ0FBekY7QUFDQSxLQUFJLFdBQVcsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixPQUF2QztBQUNBLEtBQUksV0FBYyxTQUFTLE1BQVQsR0FBa0IsS0FBSyxHQUFMLENBQVMsU0FBUyxLQUFULENBQWUsZUFBZixHQUFpQyxTQUFTLEtBQVQsQ0FBZSxlQUF6RCxDQUFuQixHQUFnRyxLQUFLLEdBQUwsQ0FBUyxRQUFULENBQWpHLEdBQXVILFNBQVMsUUFBVCxDQUFrQixTQUFsQixDQUE0QixNQUFuSixHQUE0SixFQUE3SixJQUFvSyxDQUFuTDs7QUFFQSxLQUFJLFdBQVcsV0FBZixFQUNDLFdBQVcsV0FBWCxDQURELEtBRUssSUFBSSxhQUFhLFFBQWpCLEVBQTJCO0FBQy9CLGFBQVcsV0FBWDtBQUNBLEVBRkksTUFFRSxJQUFJLFdBQVcsQ0FBZixFQUNOLFdBQVcsQ0FBWDs7QUFFRCxLQUFJLElBQUo7O0FBRUEsS0FBSSx3QkFBSixFQUNDLEtBQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixJQUE1Qjs7QUFFRCxLQUFJLFNBQUo7QUFDQSxLQUFJLElBQUosQ0FBUyxTQUFTLEVBQWxCLEVBQXNCLFNBQVMsRUFBL0IsRUFBbUMsU0FBUyxLQUE1QyxFQUFtRCxTQUFTLE1BQTVEO0FBQ0EsS0FBSSxJQUFKOztBQUVBLEtBQUksd0JBQUosRUFBdUI7QUFDdEIsT0FBSyxhQUFMLENBQW1CLFFBQW5CLENBQTRCLElBQTVCLENBQWlDLFNBQVMsRUFBMUMsRUFBOEMsU0FBUyxFQUF2RCxFQUEyRCxTQUFTLEtBQXBFLEVBQTJFLFNBQVMsTUFBcEY7QUFDQSxPQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsSUFBNUI7QUFDQTs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0Qjs7QUFFQSxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsZUFBVixDQUFqQjtBQUNBLE1BQUksYUFBYSxXQUFXLFVBQTVCO0FBQ0EsTUFBSSw2QkFBNkIsSUFBakM7O0FBRUE7O0FBRUEsTUFBSSxXQUFXLE1BQVgsR0FBb0IsQ0FBeEIsRUFBMkI7QUFDMUI7O0FBRUEsT0FBSSxlQUFnQixXQUFXLENBQVosSUFBa0IsV0FBVyxZQUE3QixHQUE0QyxJQUE1QyxHQUFtRCxLQUF0RTs7QUFFQSxPQUFJLFdBQUosR0FBa0IsVUFBbEI7O0FBRUEsUUFBSyxJQUFJLENBQVQsRUFBWSxJQUFJLFdBQVcsTUFBM0IsRUFBbUMsR0FBbkMsRUFBd0M7O0FBRXZDLGlCQUFhLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsR0FBMEIsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixFQUExQixHQUFzRCxXQUFXLENBQVgsRUFBYyxDQUFqRjs7QUFHQSxRQUFJLGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUFyQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBN0YsRUFBMEc7QUFDekc7QUFDQTs7QUFFRCxRQUFJLE9BQVEsV0FBVyxDQUFYLEVBQWMsQ0FBdEIsS0FBNkIsUUFBakMsRUFDQzs7QUFFRCxRQUFLLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELGFBQWEsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBckcsQ0FBaEQsR0FBZ0ssRUFBakssSUFBd0ssQ0FBNUs7O0FBRUEsUUFBSSxRQUFKO0FBQ0EsUUFBSSxTQUFTLGNBQVQsQ0FBd0IsVUFBeEIsTUFBd0MsQ0FBNUMsRUFDQyxXQUFXLFdBQVcsQ0FBWCxFQUFjLENBQWQsR0FBa0IsU0FBUyxjQUFULENBQXdCLFVBQXhCLENBQWxCLEdBQXdELEdBQW5FLENBREQsS0FHQyxXQUFXLENBQVg7O0FBRUQ7QUFDQSxRQUFLLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELFdBQVcsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBbkcsQ0FBckQ7O0FBRUEsUUFBSSxLQUFLLElBQUssU0FBUyxRQUFULENBQWtCLFNBQWxCLENBQTRCLE1BQTVCLEdBQXFDLFFBQXJDLEdBQWdELENBQXJELEdBQTJELFNBQVMsS0FBVCxHQUFpQixRQUE1RSxJQUF5RixDQUFsRztBQUNBLFFBQUksS0FBSyxLQUFLLFFBQUwsSUFBaUIsQ0FBMUI7QUFDQSxRQUFJLEVBQUo7QUFDQSxRQUFJLEVBQUo7O0FBR0EsUUFBSSxXQUFXLENBQVgsRUFBYyxDQUFkLElBQW1CLENBQXZCLEVBQTBCO0FBQ3pCLFNBQUksU0FBUyxnQkFBZ0IsVUFBaEIsSUFBOEIsZ0JBQWdCLFVBQWhCLENBQTlCLEdBQTRELENBQXpFOztBQUVBLFVBQUssZUFBZSxNQUFwQjtBQUNBLFVBQUssSUFBSSxNQUFUOztBQUVBLHFCQUFnQixVQUFoQixJQUE4QixVQUFVLEtBQUssRUFBZixDQUE5QjtBQUVBLEtBUkQsTUFRTztBQUNOLFNBQUksU0FBUyxnQkFBZ0IsVUFBaEIsSUFBOEIsZ0JBQWdCLFVBQWhCLENBQTlCLEdBQTRELENBQXpFOztBQUVBLFVBQUssSUFBSSxNQUFUO0FBQ0EsVUFBSyxlQUFlLE1BQXBCOztBQUVBLHFCQUFnQixVQUFoQixJQUE4QixVQUFVLEtBQUssRUFBZixDQUE5QjtBQUNBOztBQUdELFlBQVEsV0FBVyxDQUFYLEVBQWMsS0FBZCxHQUFzQixXQUFXLENBQVgsRUFBYyxLQUFwQyxHQUE0QyxXQUFXLFNBQVgsQ0FBcUIsSUFBSSxXQUFXLFNBQVgsQ0FBcUIsTUFBOUMsQ0FBcEQ7QUFDQSxhQUFTLEdBQVQsRUFBYyxFQUFkLEVBQWtCLEVBQWxCLEVBQXNCLEVBQXRCLEVBQTBCLEVBQTFCLEVBQThCLEtBQTlCLEVBQXFDLENBQXJDLEVBQXdDLElBQXhDLEVBQThDLFlBQTlDLEVBQTRELEtBQTVELEVBQW1FLEtBQW5FLEVBQTBFLEtBQTFFLEVBQWlGLFdBQVcsV0FBNUY7O0FBRUEsUUFBSSxLQUFLLFdBQVcsWUFBWCxDQUF3QixDQUF4QixDQUFUO0FBQ0EsU0FBSyxhQUFMLENBQW1CLFNBQW5CLENBQTZCLEVBQTdCLElBQW1DO0FBQ2xDLFNBQUksRUFEOEIsRUFDMUIsWUFBWSxXQURjLEVBQ0QsaUJBQWlCLGVBRGhCLEVBQ2lDLGdCQUFnQixDQURqRCxFQUNvRCxJQUFJLEVBRHhELEVBQzRELElBQUksRUFEaEUsRUFDb0UsSUFBSSxFQUR4RSxFQUM0RSxJQUFJO0FBRGhGLEtBQW5DO0FBR0EsWUFBUSxvQkFBb0IsRUFBcEIsQ0FBUjs7QUFFQSxRQUFJLHdCQUFKLEVBQ0MsU0FBUyxLQUFLLGFBQUwsQ0FBbUIsUUFBNUIsRUFBc0MsRUFBdEMsRUFBMEMsRUFBMUMsRUFBOEMsRUFBOUMsRUFBa0QsRUFBbEQsRUFBc0QsS0FBdEQsRUFBNkQsQ0FBN0QsRUFBZ0UsSUFBaEUsRUFBc0UsS0FBdEUsRUFBNkUsS0FBN0UsRUFBb0YsS0FBcEYsRUFBMkYsS0FBM0Y7O0FBRUQsUUFBSSxXQUFXLENBQVgsRUFBYyxVQUFkLElBQTRCLFdBQVcsVUFBdkMsSUFBcUQsV0FBVyxDQUFYLEVBQWMsbUJBQW5FLElBQTBGLFdBQVcsbUJBQXpHLEVBQ0MsS0FBSyxZQUFMLENBQWtCLElBQWxCLENBQXVCO0FBQ3RCLGdCQUFXLGVBRFc7QUFFdEIsZ0JBQVcsV0FBVyxDQUFYLENBRlc7QUFHdEIsaUJBQVksVUFIVTtBQUl0QixZQUFPO0FBQ04sU0FBRyxXQUFXLENBQVgsRUFBYyxDQUFkLElBQW1CLENBQW5CLEdBQXVCLEVBQXZCLEdBQTRCLEVBRHpCLEVBQzZCLEdBQUc7QUFEaEMsTUFKZTtBQU90QixnQkFBVyxXQUFXLENBQVgsRUFBYyxDQUFkLElBQW1CLENBQW5CLEdBQXVCLENBQXZCLEdBQTJCLENBQUMsQ0FQakI7QUFRdEIsYUFBUTtBQUNQLFVBQUksS0FBSyxHQUFMLENBQVMsRUFBVCxFQUFhLEVBQWIsQ0FERyxFQUNlLElBQUksRUFEbkIsRUFDdUIsSUFBSSxLQUFLLEdBQUwsQ0FBUyxFQUFULEVBQWEsRUFBYixDQUQzQixFQUM2QyxJQUFJO0FBRGpELE1BUmM7QUFXdEIsWUFBTztBQVhlLEtBQXZCO0FBYUQ7QUFDRDtBQUNEOztBQUVELEtBQUksT0FBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQ0MsS0FBSyxhQUFMLENBQW1CLFFBQW5CLENBQTRCLE9BQTVCOztBQUVEO0FBQ0EsS0FBSSxnQkFBZ0IsS0FBSyxHQUFMLENBQVMsWUFBVCxFQUF1QixTQUFTLEtBQVQsQ0FBZSxZQUFmLENBQTRCLEVBQW5ELENBQXBCO0FBQ0EsS0FBSSxnQkFBZ0I7QUFDbkIsVUFBUSxHQURXLEVBQ04sTUFBTSxLQUFLLFFBQUwsQ0FBYyxHQURkLEVBQ21CLG1CQUFtQixnQkFBZ0IsZUFEdEQsRUFDdUUsZ0JBQWdCLGdCQUFnQixNQUFoQixDQUF1QixZQUQ5RyxFQUM0SCxlQUFlO0FBRDNJLEVBQXBCO0FBR0EsUUFBTyxhQUFQO0FBQ0EsQzs7QUF4SkQ7Ozs7Ozs7OztrQkNFZSxVQUFVLFFBQVYsRUFBb0I7O0FBRWxDLEtBQUksTUFBTSxTQUFTLGVBQVQsSUFBNEIsS0FBSyxRQUFMLENBQWMsR0FBcEQ7QUFDQSxLQUFJLGtCQUFrQixTQUFTLGlCQUFULENBQTJCLE1BQWpEOztBQUVBLEtBQUksbUJBQW1CLENBQXZCLEVBQ0M7O0FBRUQsS0FBSSxRQUFRLElBQVo7O0FBRUEsS0FBSSxXQUFXLEtBQUssUUFBcEI7O0FBRUEsS0FBSSxrQkFBa0IsRUFBdEI7QUFDQSxLQUFJLGtCQUFrQixFQUF0Qjs7QUFFQSxLQUFJLElBQUksQ0FBUjtBQUFBLEtBQVcsQ0FBWDtBQUFBLEtBQWMsQ0FBZDtBQUNBLEtBQUksVUFBSixDQWhCa0MsQ0FnQmxCOztBQUVoQjtBQUNBLEtBQUksZUFBZ0IsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsSUFBSSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUE1RixDQUFqRCxJQUEwSixDQUE3Szs7QUFFQSxLQUFJLGNBQWMsS0FBSyxpQkFBTCxHQUF5QixLQUFLLGlCQUE5QixHQUFrRCxLQUFLLEtBQUwsR0FBYSxHQUFiLElBQW9CLENBQXhGO0FBQ0EsS0FBSSxXQUFXLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsT0FBdkM7QUFDQSxLQUFJLFdBQWMsU0FBUyxLQUFULEdBQWlCLEtBQUssR0FBTCxDQUFTLFNBQVMsS0FBVCxDQUFlLGVBQWYsR0FBaUMsU0FBUyxLQUFULENBQWUsZUFBekQsQ0FBbEIsR0FBK0YsS0FBSyxHQUFMLENBQVMsUUFBVCxDQUFoRyxHQUFzSCxTQUFTLFFBQVQsQ0FBa0IsU0FBbEIsQ0FBNEIsTUFBbEosR0FBMkosRUFBNUosSUFBbUssQ0FBbEw7O0FBRUEsS0FBSSxXQUFXLFdBQWYsRUFDQyxXQUFXLFdBQVgsQ0FERCxLQUVLLElBQUksYUFBYSxRQUFqQixFQUEyQjtBQUMvQixhQUFXLFdBQVg7QUFDQSxFQUZJLE1BRUUsSUFBSSxXQUFXLENBQWYsRUFDTixXQUFXLENBQVg7O0FBSUQsS0FBSSxJQUFKO0FBQ0EsS0FBSSx3QkFBSixFQUNDLEtBQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixJQUE1Qjs7QUFFRCxLQUFJLFNBQUo7QUFDQSxLQUFJLElBQUosQ0FBUyxTQUFTLEVBQWxCLEVBQXNCLFNBQVMsRUFBL0IsRUFBbUMsU0FBUyxLQUE1QyxFQUFtRCxTQUFTLE1BQTVEO0FBQ0EsS0FBSSxJQUFKOztBQUVBLEtBQUksd0JBQUosRUFBdUI7QUFDdEIsT0FBSyxhQUFMLENBQW1CLFFBQW5CLENBQTRCLElBQTVCLENBQWlDLFNBQVMsRUFBMUMsRUFBOEMsU0FBUyxFQUF2RCxFQUEyRCxTQUFTLEtBQXBFLEVBQTJFLFNBQVMsTUFBcEY7QUFDQSxPQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsSUFBNUI7QUFDQTs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0QjtBQUNBLE1BQUksYUFBYSxLQUFLLElBQUwsQ0FBVSxlQUFWLENBQWpCO0FBQ0EsTUFBSSxhQUFhLFdBQVcsVUFBNUI7QUFDQSxNQUFJLDZCQUE2QixJQUFqQzs7QUFFQTtBQUNBOzs7QUFHQSxNQUFJLFdBQVcsTUFBWCxHQUFvQixDQUF4QixFQUEyQjtBQUMxQjs7QUFFQSxPQUFJLGVBQWdCLFdBQVcsQ0FBWixJQUFrQixXQUFXLFlBQTdCLEdBQTRDLElBQTVDLEdBQW1ELEtBQXRFOztBQUVBLE9BQUksV0FBSixHQUFrQixVQUFsQjs7QUFFQSxRQUFLLElBQUksQ0FBVCxFQUFZLElBQUksV0FBVyxNQUEzQixFQUFtQyxHQUFuQyxFQUF3Qzs7QUFFdkMsaUJBQWEsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixHQUEwQixXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLE9BQWhCLEVBQTFCLEdBQXNELFdBQVcsQ0FBWCxFQUFjLENBQWpGOztBQUdBLFFBQUksYUFBYSxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLFdBQXJDLElBQW9ELGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUE3RixFQUEwRztBQUN6RztBQUNBOztBQUVELFFBQUksT0FBUSxXQUFXLENBQVgsRUFBYyxDQUF0QixLQUE2QixRQUFqQyxFQUNDOztBQUVELFFBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUFyRyxDQUFoRCxHQUFnSyxFQUFqSyxJQUF3SyxDQUE1SztBQUNBLFFBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsV0FBVyxDQUFYLEVBQWMsQ0FBZCxHQUFrQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUExRyxDQUFyRDs7QUFFQSxRQUFJLEtBQUssSUFBSyxTQUFTLFFBQVQsQ0FBa0IsU0FBbEIsQ0FBNEIsTUFBNUIsR0FBcUMsUUFBckMsR0FBZ0QsQ0FBckQsR0FBMkQsU0FBUyxLQUFULEdBQWlCLFFBQTVFLElBQXlGLENBQWxHO0FBQ0EsUUFBSSxLQUFLLEtBQUssUUFBTCxJQUFpQixDQUExQjtBQUNBLFFBQUksRUFBSjtBQUNBLFFBQUksRUFBSjs7QUFHQSxRQUFJLFdBQVcsQ0FBWCxFQUFjLENBQWQsSUFBbUIsQ0FBdkIsRUFBMEI7QUFDekIsU0FBSSxTQUFTLGdCQUFnQixVQUFoQixJQUE4QixnQkFBZ0IsVUFBaEIsQ0FBOUIsR0FBNEQsQ0FBekU7O0FBRUEsVUFBSyxJQUFJLE1BQVQ7QUFDQSxVQUFLLGVBQWUsTUFBcEI7O0FBRUEscUJBQWdCLFVBQWhCLElBQThCLFVBQVUsS0FBSyxFQUFmLENBQTlCO0FBRUEsS0FSRCxNQVFPO0FBQ04sU0FBSSxTQUFTLGdCQUFnQixVQUFoQixJQUE4QixnQkFBZ0IsVUFBaEIsQ0FBOUIsR0FBNEQsQ0FBekU7O0FBRUEsVUFBSyxJQUFJLE1BQVQ7QUFDQSxVQUFLLGVBQWUsTUFBcEI7O0FBRUEscUJBQWdCLFVBQWhCLElBQThCLFVBQVUsS0FBSyxFQUFmLENBQTlCO0FBQ0E7O0FBRUQsWUFBUSxXQUFXLENBQVgsRUFBYyxLQUFkLEdBQXNCLFdBQVcsQ0FBWCxFQUFjLEtBQXBDLEdBQTRDLFdBQVcsU0FBWCxDQUFxQixJQUFJLFdBQVcsU0FBWCxDQUFxQixNQUE5QyxDQUFwRDs7QUFFQSxhQUFTLEdBQVQsRUFBYyxFQUFkLEVBQWtCLEVBQWxCLEVBQXNCLEVBQXRCLEVBQTBCLEVBQTFCLEVBQThCLEtBQTlCLEVBQXFDLENBQXJDLEVBQXdDLElBQXhDLEVBQThDLGdCQUFpQixXQUFXLENBQVgsRUFBYyxDQUFkLElBQW1CLENBQWxGLEVBQXVGLFdBQVcsQ0FBWCxFQUFjLENBQWQsR0FBa0IsQ0FBbkIsSUFBeUIsWUFBL0csRUFBNkgsS0FBN0gsRUFBb0ksS0FBcEksRUFBMkksV0FBVyxXQUF0Sjs7QUFFQTtBQUNBO0FBQ0E7O0FBRUEsUUFBSSxLQUFLLFdBQVcsWUFBWCxDQUF3QixDQUF4QixDQUFUO0FBQ0EsU0FBSyxhQUFMLENBQW1CLFNBQW5CLENBQTZCLEVBQTdCLElBQW1DO0FBQ2xDLFNBQUksRUFEOEIsRUFDMUIsWUFBWSxXQURjLEVBQ0QsaUJBQWlCLGVBRGhCLEVBQ2lDLGdCQUFnQixDQURqRCxFQUNvRCxJQUFJLEVBRHhELEVBQzRELElBQUksRUFEaEUsRUFDb0UsSUFBSSxFQUR4RSxFQUM0RSxJQUFJO0FBRGhGLEtBQW5DO0FBR0EsWUFBUSxvQkFBb0IsRUFBcEIsQ0FBUjs7QUFFQSxRQUFJLHdCQUFKLEVBQ0MsU0FBUyxLQUFLLGFBQUwsQ0FBbUIsUUFBNUIsRUFBc0MsRUFBdEMsRUFBMEMsRUFBMUMsRUFBOEMsRUFBOUMsRUFBa0QsRUFBbEQsRUFBc0QsS0FBdEQsRUFBNkQsQ0FBN0QsRUFBZ0UsSUFBaEUsRUFBc0UsS0FBdEUsRUFBNkUsS0FBN0UsRUFBb0YsS0FBcEYsRUFBMkYsS0FBM0Y7O0FBR0QsUUFBSSxXQUFXLENBQVgsRUFBYyxVQUFkLElBQTRCLFdBQVcsVUFBdkMsSUFBcUQsV0FBVyxDQUFYLEVBQWMsbUJBQW5FLElBQTBGLFdBQVcsbUJBQXpHLEVBQThIOztBQUU3SCxVQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUI7QUFDdEIsaUJBQVcsZUFEVztBQUV0QixpQkFBVyxXQUFXLENBQVgsQ0FGVztBQUd0QixrQkFBWSxVQUhVO0FBSXRCLGFBQU87QUFDTixVQUFHLENBREcsRUFDQSxHQUFHLFdBQVcsQ0FBWCxFQUFjLENBQWQsSUFBbUIsQ0FBbkIsR0FBdUIsRUFBdkIsR0FBNEI7QUFEL0IsT0FKZTtBQU90QixpQkFBVyxXQUFXLENBQVgsRUFBYyxDQUFkLElBQW1CLENBQW5CLEdBQXVCLENBQXZCLEdBQTJCLENBQUMsQ0FQakI7QUFRdEIsY0FBUTtBQUNQLFdBQUksRUFERyxFQUNDLElBQUksS0FBSyxHQUFMLENBQVMsRUFBVCxFQUFhLEVBQWIsQ0FETCxFQUN1QixJQUFJLEVBRDNCLEVBQytCLElBQUksS0FBSyxHQUFMLENBQVMsRUFBVCxFQUFhLEVBQWI7QUFEbkMsT0FSYztBQVd0QixhQUFPO0FBWGUsTUFBdkI7QUFjQTtBQUNEO0FBQ0Q7QUFDRDs7QUFFRCxLQUFJLE9BQUo7O0FBRUEsS0FBSSx3QkFBSixFQUNDLEtBQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixPQUE1Qjs7QUFFRDtBQUNBLEtBQUksZ0JBQWdCLEtBQUssR0FBTCxDQUFTLFlBQVQsRUFBdUIsU0FBUyxLQUFULENBQWUsWUFBZixDQUE0QixFQUFuRCxDQUFwQjtBQUNBLEtBQUksZ0JBQWdCO0FBQ25CLFVBQVEsR0FEVyxFQUNOLE1BQU0sS0FBSyxRQUFMLENBQWMsR0FEZCxFQUNtQixtQkFBbUIsZ0JBQWdCLGVBRHRELEVBQ3VFLGdCQUFnQixnQkFBZ0IsTUFBaEIsQ0FBdUIsWUFEOUcsRUFDNEgsZUFBZTtBQUQzSSxFQUFwQjtBQUdBLFFBQU8sYUFBUDtBQUNBLEM7O0FBM0pEOzs7Ozs7Ozs7a0JDRWUsVUFBVSxRQUFWLEVBQW9CO0FBQ2xDLEtBQUksTUFBTSxTQUFTLGVBQVQsSUFBNEIsS0FBSyxRQUFMLENBQWMsR0FBcEQ7QUFDQSxLQUFJLGtCQUFrQixTQUFTLGlCQUFULENBQTJCLE1BQWpEOztBQUVBLEtBQUksbUJBQW1CLENBQXZCLEVBQ0M7O0FBRUQsS0FBSSxRQUFRLElBQVo7O0FBRUEsS0FBSSxXQUFXLEtBQUssUUFBcEI7O0FBRUEsS0FBSSxrQkFBa0IsRUFBdEI7QUFDQSxLQUFJLGtCQUFrQixFQUF0Qjs7QUFFQSxLQUFJLElBQUksQ0FBUjtBQUFBLEtBQVcsQ0FBWDtBQUFBLEtBQWMsQ0FBZDtBQUNBLEtBQUksVUFBSixDQWZrQyxDQWVsQjs7QUFFaEI7QUFDQSxLQUFJLGVBQWdCLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELElBQUksU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBNUYsQ0FBakQsSUFBMEosQ0FBN0s7O0FBRUEsS0FBSSxjQUFjLEtBQUssaUJBQUwsR0FBeUIsS0FBSyxpQkFBOUIsR0FBa0QsS0FBSyxLQUFMLEdBQWEsR0FBYixJQUFvQixDQUF4RjtBQUNBLEtBQUksV0FBVyxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLE9BQXZDO0FBQ0EsS0FBSSxXQUFjLFNBQVMsS0FBVCxHQUFpQixLQUFLLEdBQUwsQ0FBUyxTQUFTLEtBQVQsQ0FBZSxlQUFmLEdBQWlDLFNBQVMsS0FBVCxDQUFlLGVBQXpELENBQWxCLEdBQStGLEtBQUssR0FBTCxDQUFTLFFBQVQsQ0FBaEcsR0FBc0gsU0FBUyxRQUFULENBQWtCLFNBQWxCLENBQTRCLE1BQWxKLEdBQTJKLEVBQTVKLElBQW1LLENBQWxMOztBQUVBLEtBQUksV0FBVyxXQUFmLEVBQ0MsV0FBVyxXQUFYLENBREQsS0FFSyxJQUFJLGFBQWEsUUFBakIsRUFBMkI7QUFDL0IsYUFBVyxXQUFYO0FBQ0EsRUFGSSxNQUVFLElBQUksV0FBVyxDQUFmLEVBQ04sV0FBVyxDQUFYOztBQUVELEtBQUksSUFBSjtBQUNBLEtBQUksd0JBQUosRUFDQyxLQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsSUFBNUI7O0FBRUQsS0FBSSxTQUFKO0FBQ0EsS0FBSSxJQUFKLENBQVMsU0FBUyxFQUFsQixFQUFzQixTQUFTLEVBQS9CLEVBQW1DLFNBQVMsS0FBNUMsRUFBbUQsU0FBUyxNQUE1RDtBQUNBLEtBQUksSUFBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLE9BQUssYUFBTCxDQUFtQixRQUFuQixDQUE0QixJQUE1QixDQUFpQyxTQUFTLEVBQTFDLEVBQThDLFNBQVMsRUFBdkQsRUFBMkQsU0FBUyxLQUFwRSxFQUEyRSxTQUFTLE1BQXBGO0FBQ0EsT0FBSyxhQUFMLENBQW1CLFFBQW5CLENBQTRCLElBQTVCO0FBQ0E7O0FBRUQsTUFBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFNBQVMsaUJBQVQsQ0FBMkIsTUFBL0MsRUFBdUQsR0FBdkQsRUFBNEQ7O0FBRTNELE1BQUksa0JBQWtCLFNBQVMsaUJBQVQsQ0FBMkIsQ0FBM0IsQ0FBdEI7O0FBRUEsTUFBSSxhQUFhLEtBQUssSUFBTCxDQUFVLGVBQVYsQ0FBakI7QUFDQSxNQUFJLGFBQWEsV0FBVyxVQUE1QjtBQUNBLE1BQUksNkJBQTZCLElBQWpDOztBQUdBOzs7QUFHQSxNQUFJLFdBQVcsTUFBWCxHQUFvQixDQUF4QixFQUEyQjtBQUMxQjs7QUFFQSxPQUFJLGVBQWdCLFdBQVcsQ0FBWixJQUFrQixXQUFXLFlBQTdCLEdBQTRDLElBQTVDLEdBQW1ELEtBQXRFOztBQUVBOztBQUVBLFFBQUssSUFBSSxDQUFULEVBQVksSUFBSSxXQUFXLE1BQTNCLEVBQW1DLEdBQW5DLEVBQXdDOztBQUV2QyxpQkFBYSxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLE9BQWhCLEdBQTBCLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsRUFBMUIsR0FBc0QsV0FBVyxDQUFYLEVBQWMsQ0FBakY7O0FBR0EsUUFBSSxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBckMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLFdBQTdGLEVBQTBHO0FBQ3pHO0FBQ0E7O0FBRUQsUUFBSSxPQUFRLFdBQVcsQ0FBWCxFQUFjLENBQXRCLEtBQTZCLFFBQWpDLEVBQ0M7O0FBRUQsUUFBSyxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQXJHLENBQWhELEdBQWdLLEVBQWpLLElBQXdLLENBQTVLOztBQUVBLFFBQUksUUFBSjtBQUNBLFFBQUksU0FBUyxjQUFULENBQXdCLFVBQXhCLE1BQXdDLENBQTVDLEVBQ0MsV0FBVyxXQUFXLENBQVgsRUFBYyxDQUFkLEdBQWtCLFNBQVMsY0FBVCxDQUF3QixVQUF4QixDQUFsQixHQUF3RCxHQUFuRSxDQURELEtBR0MsV0FBVyxDQUFYOztBQUVEO0FBQ0EsUUFBSyxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxTQUFwQyxHQUFnRCxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxZQUFwQyxJQUFvRCxXQUFXLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLE9BQW5HLENBQXJEOztBQUVBLFFBQUksS0FBSyxJQUFLLFNBQVMsUUFBVCxDQUFrQixTQUFsQixDQUE0QixNQUE1QixHQUFxQyxRQUFyQyxHQUFnRCxDQUFyRCxHQUEyRCxTQUFTLEtBQVQsR0FBaUIsUUFBNUUsSUFBeUYsQ0FBbEc7QUFDQSxRQUFJLEtBQUssS0FBSyxRQUFMLElBQWlCLENBQTFCO0FBQ0EsUUFBSSxFQUFKO0FBQ0EsUUFBSSxFQUFKOztBQUdBLFFBQUksV0FBVyxDQUFYLEVBQWMsQ0FBZCxJQUFtQixDQUF2QixFQUEwQjtBQUN6QixTQUFJLFNBQVMsZ0JBQWdCLFVBQWhCLElBQThCLGdCQUFnQixVQUFoQixDQUE5QixHQUE0RCxDQUF6RTs7QUFFQSxVQUFLLElBQUksTUFBVDtBQUNBLFVBQUssZUFBZSxNQUFwQjs7QUFFQSxxQkFBZ0IsVUFBaEIsSUFBOEIsVUFBVSxLQUFLLEVBQWYsQ0FBOUI7QUFFQSxLQVJELE1BUU87QUFDTixTQUFJLFNBQVMsZ0JBQWdCLFVBQWhCLElBQThCLGdCQUFnQixVQUFoQixDQUE5QixHQUE0RCxDQUF6RTs7QUFFQSxVQUFLLElBQUksTUFBVDtBQUNBLFVBQUssZUFBZSxNQUFwQjs7QUFFQSxxQkFBZ0IsVUFBaEIsSUFBOEIsVUFBVSxLQUFLLEVBQWYsQ0FBOUI7QUFDQTs7QUFHRCxZQUFRLFdBQVcsQ0FBWCxFQUFjLEtBQWQsR0FBc0IsV0FBVyxDQUFYLEVBQWMsS0FBcEMsR0FBNEMsV0FBVyxTQUFYLENBQXFCLElBQUksV0FBVyxTQUFYLENBQXFCLE1BQTlDLENBQXBEO0FBQ0EsYUFBUyxHQUFULEVBQWMsRUFBZCxFQUFrQixFQUFsQixFQUFzQixFQUF0QixFQUEwQixFQUExQixFQUE4QixLQUE5QixFQUFxQyxDQUFyQyxFQUF3QyxJQUF4QyxFQUE4QyxnQkFBaUIsV0FBVyxDQUFYLEVBQWMsQ0FBZCxJQUFtQixDQUFsRixFQUF1RixXQUFXLENBQVgsRUFBYyxDQUFkLEdBQWtCLENBQW5CLElBQXlCLFlBQS9HLEVBQTZILEtBQTdILEVBQW9JLEtBQXBJLEVBQTJJLFdBQVcsV0FBdEo7O0FBRUEsUUFBSSxLQUFLLFdBQVcsWUFBWCxDQUF3QixDQUF4QixDQUFUO0FBQ0EsU0FBSyxhQUFMLENBQW1CLFNBQW5CLENBQTZCLEVBQTdCLElBQW1DO0FBQ2xDLFNBQUksRUFEOEIsRUFDMUIsWUFBWSxXQURjLEVBQ0QsaUJBQWlCLGVBRGhCLEVBQ2lDLGdCQUFnQixDQURqRCxFQUNvRCxJQUFJLEVBRHhELEVBQzRELElBQUksRUFEaEUsRUFDb0UsSUFBSSxFQUR4RSxFQUM0RSxJQUFJO0FBRGhGLEtBQW5DO0FBR0EsWUFBUSxvQkFBb0IsRUFBcEIsQ0FBUjs7QUFFQSxRQUFJLHdCQUFKLEVBQ0MsU0FBUyxLQUFLLGFBQUwsQ0FBbUIsUUFBNUIsRUFBc0MsRUFBdEMsRUFBMEMsRUFBMUMsRUFBOEMsRUFBOUMsRUFBa0QsRUFBbEQsRUFBc0QsS0FBdEQsRUFBNkQsQ0FBN0QsRUFBZ0UsSUFBaEUsRUFBc0UsS0FBdEUsRUFBNkUsS0FBN0UsRUFBb0YsS0FBcEYsRUFBMkYsS0FBM0Y7O0FBR0QsUUFBSSxXQUFXLENBQVgsRUFBYyxVQUFkLElBQTRCLFdBQVcsVUFBdkMsSUFBcUQsV0FBVyxDQUFYLEVBQWMsbUJBQW5FLElBQTBGLFdBQVcsbUJBQXpHLEVBQThIOztBQUU3SCxVQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUI7QUFDdEIsaUJBQVcsa0JBRFc7QUFFdEIsaUJBQVcsV0FBVyxDQUFYLENBRlc7QUFHdEIsa0JBQVksVUFIVTtBQUl0QixhQUFPO0FBQ04sVUFBRyxDQURHLEVBQ0EsR0FBRyxXQUFXLENBQVgsRUFBYyxDQUFkLElBQW1CLENBQW5CLEdBQXVCLEVBQXZCLEdBQTRCO0FBRC9CLE9BSmU7QUFPdEIsaUJBQVcsV0FBVyxDQUFYLEVBQWMsQ0FBZCxJQUFtQixDQUFuQixHQUF1QixDQUF2QixHQUEyQixDQUFDLENBUGpCO0FBUXRCLGNBQVE7QUFDUCxXQUFJLEVBREcsRUFDQyxJQUFJLEtBQUssR0FBTCxDQUFTLEVBQVQsRUFBYSxFQUFiLENBREwsRUFDdUIsSUFBSSxFQUQzQixFQUMrQixJQUFJLEtBQUssR0FBTCxDQUFTLEVBQVQsRUFBYSxFQUFiO0FBRG5DLE9BUmM7QUFXdEIsYUFBTztBQVhlLE1BQXZCO0FBY0E7QUFDRDtBQUNEO0FBQ0Q7O0FBRUQsS0FBSSxPQUFKOztBQUVBLEtBQUksd0JBQUosRUFDQyxLQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsT0FBNUI7O0FBRUQ7QUFDQSxLQUFJLGdCQUFnQixLQUFLLEdBQUwsQ0FBUyxZQUFULEVBQXVCLFNBQVMsS0FBVCxDQUFlLFlBQWYsQ0FBNEIsRUFBbkQsQ0FBcEI7QUFDQSxLQUFJLGdCQUFnQjtBQUNuQixVQUFRLEdBRFcsRUFDTixNQUFNLEtBQUssUUFBTCxDQUFjLEdBRGQsRUFDbUIsbUJBQW1CLGdCQUFnQixlQUR0RCxFQUN1RSxnQkFBZ0IsZ0JBQWdCLE1BQWhCLENBQXVCLFlBRDlHLEVBQzRILGVBQWU7QUFEM0ksRUFBcEI7QUFHQSxRQUFPLGFBQVA7QUFDQSxDOztBQTdKRDs7Ozs7Ozs7O2tCQ0VlLFVBQVUsUUFBVixFQUFvQjtBQUNsQyxLQUFJLE1BQU0sU0FBUyxlQUFULElBQTRCLEtBQUssUUFBTCxDQUFjLEdBQXBEOztBQUVBLEtBQUksa0JBQWtCLFNBQVMsaUJBQVQsQ0FBMkIsTUFBakQ7O0FBRUEsS0FBSSxtQkFBbUIsQ0FBdkIsRUFDQzs7QUFFRCxLQUFJLFdBQVcsS0FBSyxhQUFMLENBQW1CLFFBQWxDOztBQUVBLEtBQUksYUFBYSxTQUFTLEtBQVQsQ0FBZSxlQUFoQztBQUNBLEtBQUksYUFBYSxTQUFTLEtBQVQsQ0FBZSxlQUFoQztBQUNBLEtBQUksVUFBVSxFQUFkOztBQUVBLEtBQUksV0FBVyxLQUFLLFFBQXBCO0FBQ0EsS0FBSSxJQUFKOztBQUVBLEtBQUksd0JBQUosRUFDQyxTQUFTLElBQVQ7O0FBRUQsS0FBSSxTQUFKO0FBQ0EsS0FBSSxJQUFKLENBQVMsU0FBUyxFQUFsQixFQUFzQixTQUFTLEVBQS9CLEVBQW1DLFNBQVMsS0FBNUMsRUFBbUQsU0FBUyxNQUE1RDtBQUNBLEtBQUksSUFBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLFdBQVMsU0FBVDtBQUNBLFdBQVMsSUFBVCxDQUFjLFNBQVMsRUFBdkIsRUFBMkIsU0FBUyxFQUFwQyxFQUF3QyxTQUFTLEtBQWpELEVBQXdELFNBQVMsTUFBakU7QUFDQSxXQUFTLElBQVQ7QUFDQTs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDs7QUFFM0QsTUFBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUF0Qjs7QUFFQSxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsZUFBVixDQUFqQjs7QUFFQSxNQUFJLGFBQWEsV0FBVyxVQUE1Qjs7QUFFQSxNQUFJLFdBQVcsV0FBVyxFQUExQjtBQUNBLE9BQUssYUFBTCxDQUFtQixTQUFuQixDQUE2QixRQUE3QixJQUF5QztBQUN4QyxlQUFZLFlBRDRCLEVBQ2QsaUJBQWlCO0FBREgsR0FBekM7O0FBSUEsTUFBSSxXQUFXLG9CQUFvQixRQUFwQixDQUFmO0FBQ0EsV0FBUyxTQUFULEdBQXFCLFFBQXJCO0FBQ0E7QUFDQTs7QUFFQSxZQUFVLEVBQVY7O0FBRUEsTUFBSSw2QkFBNkIsSUFBakM7QUFDQSxNQUFJLElBQUksQ0FBUjtBQUFBLE1BQVcsQ0FBWDtBQUFBLE1BQWMsQ0FBZDtBQUNBLE1BQUksVUFBSixDQXRCMkQsQ0FzQjNDOztBQUVoQixNQUFJLGVBQWdCLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELElBQUksU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBNUYsQ0FBaEQsR0FBdUosRUFBeEosSUFBK0osQ0FBbEw7QUFDQSxNQUFJLEtBQUo7O0FBRUEsTUFBSSxhQUFhLElBQWpCOztBQUVBLE1BQUksZUFBZSxLQUFuQjtBQUNBLE1BQUksV0FBVyxNQUFYLEdBQW9CLENBQXhCLEVBQTJCO0FBQzFCO0FBQ0EsT0FBSSxRQUFRLFdBQVcsU0FBWCxDQUFxQixJQUFJLFdBQVcsU0FBWCxDQUFxQixNQUE5QyxDQUFaO0FBQ0E7QUFDQSxPQUFJLFNBQUosR0FBZ0IsS0FBaEI7QUFDQSxPQUFJLFdBQUosR0FBa0IsS0FBbEI7QUFDQSxPQUFJLFNBQUosR0FBZ0IsV0FBVyxhQUEzQjs7QUFFQSxPQUFJLElBQUksV0FBUixFQUFxQjtBQUNwQixRQUFJLFdBQUosQ0FBZ0IsaUJBQWlCLFdBQVcsWUFBNUIsRUFBMEMsV0FBVyxhQUFyRCxDQUFoQjtBQUNBOztBQUVELFVBQU8sSUFBSSxXQUFXLE1BQXRCLEVBQThCLEdBQTlCLEVBQW1DOztBQUVsQyxpQkFBYSxXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLE9BQWhCLEdBQTBCLFdBQVcsQ0FBWCxFQUFjLENBQWQsQ0FBZ0IsT0FBaEIsRUFBMUIsR0FBc0QsV0FBVyxDQUFYLEVBQWMsQ0FBakY7O0FBRUEsUUFBSSxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBckMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLFdBQTdGLEVBQTBHO0FBQ3pHO0FBQ0E7O0FBRUQsUUFBSSxRQUFRLENBQVo7O0FBRUEsUUFBSSxPQUFRLFdBQVcsQ0FBWCxFQUFjLENBQXRCLEtBQTZCLFFBQWpDLEVBQTJDO0FBQzFDOztBQUVBLG9CQUFlLElBQWY7QUFDQTtBQUNBOztBQUVELFFBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUFyRyxDQUFoRCxHQUFnSyxFQUFqSyxJQUF3SyxDQUE1SztBQUNBLFFBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsV0FBVyxDQUFYLEVBQWMsQ0FBZCxHQUFrQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUExRyxDQUFoRCxHQUFxSyxFQUF0SyxJQUE2SyxDQUFqTDs7QUFJQSxRQUFJLDhCQUE4QixZQUFsQyxFQUFnRDtBQUMvQyxTQUFJLFNBQUo7QUFDQSxTQUFJLE1BQUosQ0FBVyxDQUFYLEVBQWMsQ0FBZDtBQUNBLGtCQUFhO0FBQ1osU0FBRyxDQURTLEVBQ04sR0FBRztBQURHLE1BQWI7O0FBSUEsU0FBSSx3QkFBSixFQUF1QjtBQUN0QixlQUFTLFNBQVQ7QUFDQSxlQUFTLE1BQVQsQ0FBZ0IsQ0FBaEIsRUFBbUIsQ0FBbkI7QUFDQTs7QUFFRCxrQ0FBNkIsS0FBN0I7QUFDQSxvQkFBZSxLQUFmO0FBQ0EsS0FkRCxNQWVLOztBQUVKLFNBQUksTUFBSixDQUFXLENBQVgsRUFBYyxLQUFkO0FBQ0EsU0FBSSx3QkFBSixFQUNDLFNBQVMsTUFBVCxDQUFnQixDQUFoQixFQUFtQixLQUFuQjs7QUFFRCxTQUFJLE1BQUosQ0FBVyxDQUFYLEVBQWMsQ0FBZDs7QUFFQSxTQUFJLHdCQUFKLEVBQ0MsU0FBUyxNQUFULENBQWdCLENBQWhCLEVBQW1CLENBQW5COztBQUVELFNBQUksSUFBSSxHQUFKLElBQVcsQ0FBZixFQUFrQjtBQUNqQjtBQUNBO0FBQ0Q7O0FBR0QsUUFBSSxLQUFLLFdBQVcsWUFBWCxDQUF3QixDQUF4QixDQUFUO0FBQ0EsU0FBSyxhQUFMLENBQW1CLFNBQW5CLENBQTZCLEVBQTdCLElBQW1DO0FBQ2xDLFNBQUksRUFEOEIsRUFDMUIsWUFBWSxXQURjLEVBQ0QsaUJBQWlCLGVBRGhCLEVBQ2lDLGdCQUFnQixDQURqRCxFQUNvRCxJQUFJLENBRHhELEVBQzJELElBQUk7QUFEL0QsS0FBbkM7O0FBSUE7QUFDQSxRQUFJLFdBQVcsQ0FBWCxFQUFjLFVBQWQsS0FBNkIsQ0FBakMsRUFBb0M7QUFDbkMsU0FBSSxXQUFXLENBQVgsRUFBYyxVQUFkLEdBQTJCLENBQTNCLElBQWdDLFdBQVcsVUFBWCxHQUF3QixDQUE1RCxFQUErRDtBQUM5RCxVQUFJLGNBQWMsV0FBVyxtQkFBWCxDQUErQixDQUEvQixFQUFrQyxDQUFsQyxFQUFxQyxDQUFyQyxFQUF3QyxHQUF4QyxDQUFsQjtBQUNBLGNBQVEsSUFBUixDQUFhLFdBQWI7O0FBRUE7QUFDQTtBQUNBOztBQUVBLFVBQUksY0FBYyxvQkFBb0IsRUFBcEIsQ0FBbEI7O0FBRUEsVUFBSSx3QkFBSixFQUF1QjtBQUN0QixlQUFRLElBQVIsQ0FBYTtBQUNaLFdBQUcsQ0FEUyxFQUNOLEdBQUcsQ0FERyxFQUNBLEtBQUssUUFETDtBQUVaLGNBQU0sWUFBWSxJQUZOO0FBR1osY0FBTSxZQUFZLElBSE47QUFJWixlQUFPLFdBSks7QUFLWixxQkFBYSxXQUxEO0FBTVoseUJBQWlCLFlBQVk7QUFOakIsUUFBYjtBQVFBO0FBQ0Q7QUFDRDs7QUFFRCxRQUFJLFdBQVcsQ0FBWCxFQUFjLFVBQWQsSUFBNEIsV0FBVyxVQUF2QyxJQUFxRCxXQUFXLENBQVgsRUFBYyxtQkFBbkUsSUFBMEYsV0FBVyxtQkFBekcsRUFBOEg7O0FBRTdILFVBQUssWUFBTCxDQUFrQixJQUFsQixDQUF1QjtBQUN0QixpQkFBVyxVQURXO0FBRXRCLGlCQUFXLFdBQVcsQ0FBWCxDQUZXO0FBR3RCLGtCQUFZLFVBSFU7QUFJdEIsYUFBTztBQUNOLFVBQUcsQ0FERyxFQUNBLEdBQUc7QUFESCxPQUplO0FBT3RCLGlCQUFXLFdBQVcsQ0FBWCxFQUFjLENBQWQsSUFBbUIsQ0FBbkIsR0FBdUIsQ0FBdkIsR0FBMkIsQ0FBQyxDQVBqQjtBQVF0QixhQUFPO0FBUmUsTUFBdkI7QUFXQTtBQUNEOztBQUVEOztBQUVBLGdCQUFhLFdBQWIsQ0FBeUIsT0FBekI7QUFDQTtBQUNEOztBQUVELEtBQUksT0FBSjtBQUNBLEtBQUksd0JBQUosRUFDQyxLQUFLLGFBQUwsQ0FBbUIsUUFBbkIsQ0FBNEIsT0FBNUI7O0FBRUQsVUFBUyxTQUFULEdBQXFCOztBQUVwQixNQUFJLENBQUMsVUFBTCxFQUNDOztBQUVELE1BQUksV0FBVyxhQUFYLEdBQTJCLENBQS9CLEVBQ0MsSUFBSSxNQUFKOztBQUVELE1BQUksU0FBUyxLQUFULENBQWUsZUFBZixJQUFrQyxDQUFsQyxJQUF1QyxTQUFTLEtBQVQsQ0FBZSxlQUFmLElBQWtDLENBQTdFLEVBQWdGO0FBQy9FLFdBQVEsWUFBUjtBQUNBLEdBRkQsTUFHSyxJQUFJLFNBQVMsS0FBVCxDQUFlLGVBQWYsR0FBaUMsQ0FBckMsRUFDSixRQUFRLFdBQVcsRUFBbkIsQ0FESSxLQUVBLElBQUksU0FBUyxLQUFULENBQWUsZUFBZixHQUFpQyxDQUFyQyxFQUNKLFFBQVEsV0FBVyxFQUFuQjs7QUFFRCxNQUFJLE1BQUosQ0FBVyxDQUFYLEVBQWMsS0FBZDtBQUNBLE1BQUksTUFBSixDQUFXLFdBQVcsQ0FBdEIsRUFBeUIsS0FBekI7QUFDQSxNQUFJLFNBQUo7O0FBRUEsTUFBSSxXQUFKLEdBQWtCLFdBQVcsV0FBN0I7QUFDQSxNQUFJLElBQUo7QUFDQSxNQUFJLFdBQUosR0FBa0IsQ0FBbEI7O0FBRUEsTUFBSSx3QkFBSixFQUF1QjtBQUN0QixZQUFTLE1BQVQsQ0FBZ0IsQ0FBaEIsRUFBbUIsS0FBbkI7QUFDQSxZQUFTLE1BQVQsQ0FBZ0IsV0FBVyxDQUEzQixFQUE4QixLQUE5QjtBQUNBLFlBQVMsU0FBVDtBQUNBLFlBQVMsSUFBVDtBQUNBOztBQUVELE1BQUksU0FBSjtBQUNBLE1BQUksTUFBSixDQUFXLENBQVgsRUFBYyxDQUFkO0FBQ0EsV0FBUyxTQUFUO0FBQ0EsV0FBUyxNQUFULENBQWdCLENBQWhCLEVBQW1CLENBQW5COztBQUVBLGVBQWE7QUFDWixNQUFHLENBRFMsRUFDTixHQUFHO0FBREcsR0FBYjtBQUdBOztBQUVEO0FBQ0EsS0FBSSxnQkFBZ0I7QUFDbkIsVUFBUSxHQURXLEVBQ04sTUFBTSxLQUFLLFFBQUwsQ0FBYyxHQURkLEVBQ21CLG1CQUFtQixnQkFBZ0IsY0FEdEQsRUFDc0UsZ0JBQWdCLGdCQUFnQixNQUFoQixDQUF1QixNQUQ3RyxFQUNxSCxlQUFlO0FBRHBJLEVBQXBCO0FBR0EsUUFBTyxhQUFQO0FBQ0EsQzs7QUF0T0Q7Ozs7Ozs7O0FDRE8sSUFBTSw4QkFBVztBQUN0QixRQUFNO0FBQ0o7QUFDRDtBQUNEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFYc0IsQ0FBakI7O0FBY0EsSUFBTSxnQ0FBWTtBQUN2QixrQkFBZ0IsQ0FETztBQUV2QixnQkFBYyxPQUFPLEVBQVAsR0FBWSxFQUFaLEdBQWlCLEVBQWpCLEdBQXNCLEdBRmI7QUFHdkIsaUJBQWUsT0FBTyxFQUFQLEdBQVksRUFBWixHQUFpQixFQUFqQixHQUFzQixFQUhkO0FBSXZCLGdCQUFjLE9BQU8sRUFBUCxHQUFZLEVBQVosR0FBaUIsRUFBakIsR0FBc0IsQ0FKYjtBQUt2QixlQUFhLE9BQU8sRUFBUCxHQUFZLEVBQVosR0FBaUIsRUFMUDtBQU12QixnQkFBYyxPQUFPLEVBQVAsR0FBWSxFQU5IO0FBT3ZCLGtCQUFnQixPQUFPLEVBUEE7QUFRdkIsa0JBQWdCLElBUk87QUFTdkIsdUJBQXFCLENBVEU7O0FBV3ZCLG9CQUFrQixDQUFDLFFBQUQsRUFBVyxRQUFYLEVBQXFCLFNBQXJCLEVBQWdDLFdBQWhDLEVBQTZDLFVBQTdDLEVBQXlELFFBQXpELEVBQW1FLFVBQW5FO0FBWEssQ0FBbEI7Ozs7Ozs7O0FDYkEsSUFBTSxvQ0FBYyxLQUFwQjs7QUFFQSxJQUFNLGdEQUFvQixDQUFDLENBQUMsU0FBUyxhQUFULENBQXVCLFFBQXZCLEVBQWlDLFVBQTdEO0FBQ047O0FBRUE7QUFDTSxJQUFNLDBDQUFpQjtBQUM1QixVQUFPO0FBQ04sYUFBTyxHQUREO0FBRU4sY0FBUSxHQUZGO0FBR04sbUJBQWEsS0FIUDtBQUlOLGdCQUFVLEdBSko7QUFLTix1QkFBaUIsT0FMWDtBQU1OLGFBQU8sUUFORDtBQU9OLHdCQUFrQixLQVBaO0FBUU4seUJBQW1CLElBUmI7QUFTTix5QkFBbUIsSUFUYjs7QUFXTixnQkFBVSxXQVhKO0FBWU4sZUFBUyxJQVpIO0FBYU4sa0JBQVksY0FiTjtBQWNOLDRCQUFzQixJQWRoQjtBQWVOLHFCQUFlLEtBZlQ7QUFnQk4sc0JBQWdCLE9BaEJWOztBQWtCTixxQkFBZSxJQWxCVDtBQW1CTixvQkFBYztBQW5CUixJQURxQjs7QUF1QjVCLFVBQU87QUFDTixlQUFTLENBREg7QUFFTixZQUFNLElBRkE7QUFHTixxQkFBZSxLQUhULEVBR2U7QUFDckIsdUJBQWlCLFFBSlgsRUFJb0I7QUFDMUIsZ0JBQVUsRUFMSixFQUtPO0FBQ2Isa0JBQVksU0FOTjtBQU9OLGtCQUFZLFFBUE4sRUFPZ0I7QUFDdEIsaUJBQVcsT0FSTDtBQVNOLGlCQUFXLFFBVEwsRUFTZTs7QUFFckIsdUJBQWlCLENBWFg7QUFZTixtQkFBYSxPQVpQO0FBYU4sb0JBQWMsQ0FiUjtBQWNOLHVCQUFpQixJQWRYO0FBZU4sY0FBUSxDQWZGO0FBZ0JOLFlBQU0sSUFoQkE7QUFpQk4sZ0JBQVUsSUFqQko7O0FBbUJOLDBCQUFvQjtBQUNwQjtBQXBCTSxJQXZCcUI7O0FBOEM1QixhQUFVO0FBQ1QsZUFBUyxDQURBO0FBRVQsWUFBTSxJQUZHO0FBR1QscUJBQWUsS0FITixFQUdZO0FBQ3JCLHVCQUFpQixRQUpSLEVBSWlCO0FBQzFCLGdCQUFVLEVBTEQsRUFLSTtBQUNiLGtCQUFZLFNBTkg7QUFPVCxrQkFBWSxRQVBILEVBT2E7QUFDdEIsaUJBQVcsT0FSRjtBQVNULGlCQUFXLFFBVEYsRUFTWTs7QUFFckIsdUJBQWlCLENBWFI7QUFZVCxtQkFBYSxPQVpKO0FBYVQsb0JBQWMsQ0FiTDtBQWNULHVCQUFpQixJQWRSO0FBZVQsY0FBUSxDQWZDO0FBZ0JULFlBQU0sSUFoQkc7QUFpQlQsZ0JBQVUsSUFqQkQ7O0FBbUJULDBCQUFvQjtBQUNwQjtBQXBCUyxJQTlDa0I7O0FBcUU1QixXQUFRO0FBQ1AsWUFBTSxJQURDO0FBRVAscUJBQWUsUUFGUjtBQUdQLHVCQUFpQixPQUhWOztBQUtQLGdCQUFVLEVBTEgsRUFLTTtBQUNiLGtCQUFZLFNBTkw7QUFPUCxrQkFBWSxRQVBMLEVBT2U7QUFDdEIsaUJBQVcsT0FSSjtBQVNQLGlCQUFXLFFBVEosRUFTYzs7QUFFckIsY0FBUSxJQVhEO0FBWVAscUJBQWUsSUFaUjtBQWFQLG9CQUFjLElBYlA7QUFjUCxxQkFBZSxJQWRSO0FBZVAsaUJBQVcsSUFmSjs7QUFpQlAsMEJBQW9CLEtBakJiO0FBa0JQLGdCQUFVLEtBbEJIOztBQW9CUCxnQkFBVSxJQXBCSDtBQXFCUCxpQkFBVyxJQXJCSjs7QUF1QlAsb0JBQWMsSUF2QlA7QUF3QlAsaUJBQVcsSUF4Qko7QUF5QlAsZ0JBQVUsSUF6Qkg7QUEwQlAseUJBQW1CO0FBMUJaLElBckVvQjs7QUFrRzVCLFlBQVM7QUFDUixlQUFTLElBREQ7QUFFUixjQUFRLEtBRkE7QUFHUix3QkFBa0IsSUFIVjtBQUlSLGVBQVMsSUFKRDtBQUtSLHdCQUFrQixJQUxWOztBQU9SLGdCQUFVLEtBUEY7O0FBU1IsdUJBQWlCLElBVFQ7O0FBV1IsbUJBQWEsSUFYTDtBQVlSLHVCQUFpQixDQVpULEVBWVk7QUFDcEIsb0JBQWMsQ0FiTixFQWFTOztBQUVqQixnQkFBVSxFQWZGLEVBZU07QUFDZCxpQkFBVyxTQWhCSDtBQWlCUixrQkFBWSxpQ0FqQko7QUFrQlIsa0JBQVksUUFsQkosRUFrQmM7QUFDdEIsaUJBQVcsUUFuQkgsQ0FtQmE7QUFuQmIsSUFsR21COztBQXdINUIsU0FBTTtBQUNMLGVBQVMsSUFESixFQUNVO0FBQ2YsZUFBUyxJQUZKLEVBRVU7QUFDZix1QkFBaUIsSUFIWjtBQUlMLHVCQUFpQixJQUpaO0FBS0wsZ0JBQVUsSUFMTCxFQUtXO0FBQ2hCLG9CQUFjLElBTlQsRUFNZTtBQUNwQjs7QUFFQSxhQUFPLElBVEYsRUFTUTtBQUNiLHNCQUFnQixPQVZYO0FBV0wscUJBQWUsRUFYVjtBQVlMLHVCQUFpQixPQVpaO0FBYUwsdUJBQWlCLFFBYlo7QUFjTCxzQkFBZ0IsUUFkWDs7QUFnQkwsa0JBQVksQ0FoQlA7QUFpQkwsdUJBQWlCLE9BakJaO0FBa0JMLHNCQUFnQixPQWxCWDtBQW1CTCxxQkFBZSxFQW5CVjtBQW9CTCx1QkFBaUIsUUFwQlo7QUFxQkwsc0JBQWdCLFFBckJYO0FBc0JMLG9CQUFjLEtBdEJUO0FBdUJMLGlCQUFXLElBdkJOO0FBd0JMLHFCQUFlLElBeEJWLEVBd0JlO0FBQ3BCLHNCQUFnQixJQXpCWDs7QUEyQkwsY0FBUSxFQTNCSDtBQTRCTCxjQUFRLEVBNUJIOztBQThCTCxtQkFBYSxJQTlCUixFQThCYzs7QUFFbkIsa0JBQVksQ0FoQ1A7QUFpQ0wsaUJBQVcsT0FqQ047QUFrQ0wscUJBQWUsQ0FsQ1Y7O0FBb0NMLGlCQUFXLE9BcENOO0FBcUNMLHFCQUFlLENBckNWO0FBc0NMLG9CQUFjLE9BdENUOztBQXdDTCxpQkFBVyxRQXhDTjtBQXlDTCxxQkFBZSxDQXpDVjtBQTBDTCxvQkFBYyxPQTFDVDs7QUE0Q0wsdUJBQWlCLElBNUNaOztBQThDTCx5QkFBbUIsSUE5Q2Q7O0FBZ0RMLGNBQVEsQ0FoREg7O0FBa0RMLGtCQUFZLEVBbERQLENBa0RVO0FBbERWLElBeEhzQjs7QUE2SzVCLGNBQVc7QUFDVixhQUFPLElBREc7QUFFVixrQkFBWSxJQUZGO0FBR1YsZ0JBQVUsSUFIQTs7QUFLVixhQUFPLFFBTEc7QUFNVixlQUFTLElBTkM7QUFPVixpQkFBVyxDQVBEO0FBUVYsb0JBQWMsT0FSSjtBQVNWLGFBQU8sRUFURztBQVVWLDRCQUFzQixTQVZaO0FBV1YsdUJBQWlCLE9BWFA7QUFZVixzQkFBZ0IsUUFaTjtBQWFWLHFCQUFlLEVBYkw7QUFjVix1QkFBaUIsUUFkUDtBQWVWLHNCQUFnQixRQWZOO0FBZ0JWLHNCQUFnQixJQWhCTjs7QUFrQlYsaUJBQVc7QUFsQkQsSUE3S2lCOztBQWtNNUIsZUFBWTtBQUNYLFlBQU0sSUFESztBQUVYLGtCQUFZLElBRkQ7QUFHWCxhQUFPLEVBSEk7QUFJWCxvQkFBYyxLQUpIO0FBS1gsd0JBQWtCLElBTFA7O0FBT1gsY0FBUSxJQVBHOztBQVNYLGtCQUFZLEVBVEQ7QUFVWCwyQkFBcUIsTUFWVixFQVVtQjtBQUM5Qiw2QkFBdUIsWUFYWjtBQVlYLDJCQUFxQixPQVpWO0FBYVgsMEJBQW9CLEVBYlQ7QUFjWCwyQkFBcUIsUUFkVixFQWNvQjtBQUMvQiw0QkFBc0IsT0FmWCxFQWVxQjtBQUNoQyw0QkFBc0IsUUFoQlgsRUFnQnNCO0FBQ2pDLGlDQUEyQixJQWpCaEI7QUFrQlgsMkJBQXFCLElBbEJWO0FBbUJYLCtCQUF5QixDQW5CZDtBQW9CWCw4QkFBd0IsT0FwQmI7QUFxQlgsMEJBQW9CLElBckJUO0FBc0JYLHNCQUFnQixJQXRCTDtBQXVCWCwyQkFBcUIsSUF2QlY7O0FBeUJYLHFCQUFlLENBekJKO0FBMEJYLG9CQUFjLE9BMUJIOztBQTRCWCxhQUFPLElBNUJJO0FBNkJYLG1CQUFhLE9BN0JGO0FBOEJYLG1CQUFhLElBOUJGOztBQWdDWCxrQkFBWSxDQWhDRDs7QUFrQ1gsY0FBUSxJQWxDRztBQW1DWCxtQkFBYSxJQW5DRjs7QUFxQ1gsWUFBTSxRQXJDSyxFQXFDSztBQUNoQixrQkFBWSxRQXRDRCxFQXNDVztBQUN0QixpQkFBVyxTQXZDQTs7QUF5Q1gsMEJBQW9CLElBekNUO0FBMENYLDBCQUFvQixJQTFDVDtBQTJDWCwwQkFBb0IsSUEzQ1Q7QUE0Q1gsMkJBQXFCLElBNUNWOztBQThDWCxvQkFBYyxJQTlDSDtBQStDWCx3QkFBa0IsSUEvQ1A7QUFnRFgseUJBQW1CLElBaERSO0FBaURYLGtCQUFZLElBakREO0FBa0RYLCtCQUF5QixJQWxEZDtBQW1EWCxtQ0FBNkIsSUFuRGxCOztBQXFEWCxrQkFBWSxRQXJERCxFQXFEVztBQUN0QixtQkFBYSxJQXRERjtBQXVEWCxrQkFBWSxJQXZERDtBQXdEWCx5QkFBbUIsSUF4RFI7QUF5RFgsNkJBQXVCLElBekRaO0FBMERYO0FBQ0EsaUJBQVcsSUEzREE7QUE0RFgsZ0JBQVUsSUE1REM7QUE2RFgsaUJBQVcsSUE3REE7QUE4RFgsYUFBTyxJQTlESTtBQStEWCxzQkFBZ0IsSUEvREw7O0FBaUVYLGVBQVM7QUFqRUUsSUFsTWdCOztBQXNRNUI7QUFDQSxjQUFXO0FBQ1YsU0FBRyxDQURPO0FBRVYsU0FBRyxDQUZPO0FBR1YsYUFBTyxJQUhHLEVBR0U7QUFDWixjQUFRLElBSkUsRUFJRztBQUNiLGdCQUFVLElBTEE7QUFNVixpQkFBVyxJQU5EO0FBT1YsZUFBUyxDQVBDO0FBUVYsYUFBTyxDQVJHO0FBU1YsWUFBTSxFQVRJO0FBVVYsdUJBQWlCLFFBVlAsRUFVZ0I7QUFDMUIsZ0JBQVUsRUFYQSxFQVdHO0FBQ2Isa0JBQVksU0FaRjtBQWFWLGtCQUFZLFFBYkYsRUFhWTtBQUN0QixpQkFBVyxPQWREO0FBZVYsaUJBQVcsUUFmRCxFQWVXOztBQUVyQix1QkFBaUIsQ0FqQlA7QUFrQlYsbUJBQWEsT0FsQkg7QUFtQlYsb0JBQWMsQ0FuQko7QUFvQlYsdUJBQWlCLElBcEJQO0FBcUJWLG9CQUFjO0FBckJKLElBdlFpQjs7QUErUjVCLGdCQUFhO0FBQ1osd0JBQWtCLEdBRE47QUFFWiwyQkFBcUIsR0FGVDtBQUdaLGdCQUFVLE1BSEU7QUFJWixlQUFTLEtBSkc7QUFLWixpQkFBVyxPQUxDOztBQU9aLGdCQUFVLGNBUEU7QUFRWixtQkFBYSxhQVJEO0FBU1osbUJBQWEsYUFURDs7QUFXWixZQUFNLENBQUMsUUFBRCxFQUFXLFFBQVgsRUFBcUIsU0FBckIsRUFBZ0MsV0FBaEMsRUFBNkMsVUFBN0MsRUFBeUQsUUFBekQsRUFBbUUsVUFBbkUsQ0FYTTtBQVlaLGlCQUFXLENBQUMsS0FBRCxFQUFRLEtBQVIsRUFBZSxLQUFmLEVBQXNCLEtBQXRCLEVBQTZCLEtBQTdCLEVBQW9DLEtBQXBDLEVBQTJDLEtBQTNDLENBWkM7O0FBY1osY0FBUSxDQUFDLFNBQUQsRUFBWSxVQUFaLEVBQXdCLE9BQXhCLEVBQWlDLE9BQWpDLEVBQTBDLEtBQTFDLEVBQWlELE1BQWpELEVBQXlELE1BQXpELEVBQWlFLFFBQWpFLEVBQTJFLFdBQTNFLEVBQXdGLFNBQXhGLEVBQW1HLFVBQW5HLEVBQStHLFVBQS9HLENBZEk7QUFlWixtQkFBYSxDQUFDLEtBQUQsRUFBUSxLQUFSLEVBQWUsS0FBZixFQUFzQixLQUF0QixFQUE2QixLQUE3QixFQUFvQyxLQUFwQyxFQUEyQyxLQUEzQyxFQUFrRCxLQUFsRCxFQUF5RCxLQUF6RCxFQUFnRSxLQUFoRSxFQUF1RSxLQUF2RSxFQUE4RSxLQUE5RTtBQWZEO0FBL1JlLENBQXZCOzs7Ozs7Ozs7O0FDTlA7O0FBRU8sSUFBTSxnQ0FBWTs7QUFFdkIsY0FBYSxDQUNaLFNBRFksRUFFWixTQUZZLEVBR1osU0FIWTtBQUlaO0FBQ0EsVUFMWSxFQU1aLFNBTlk7QUFPWjtBQUNBLFVBUlksRUFTWixTQVRZO0FBVVo7QUFDQSxVQVhZLEVBWVosU0FaWSxFQWFaLFNBYlksRUFjWixTQWRZLENBRlU7QUFrQnZCLGNBQWEsQ0FDWixTQURZLEVBRVosU0FGWSxFQUdaLFNBSFksRUFJWixTQUpZO0FBS1o7QUFDQSxVQU5ZLEVBT1osU0FQWSxFQVFaLFNBUlk7QUFTWjtBQUNBO0FBQ0EsVUFYWSxDQWxCVTtBQStCdkIsY0FBYSxDQUNaLFNBRFksRUFFWixTQUZZLEVBR1osU0FIWSxFQUlaLFNBSlksRUFLWixTQUxZLEVBTVosU0FOWSxFQU9aLFNBUFksRUFRWixTQVJZLEVBU1osU0FUWSxFQVVaLFNBVlksRUFXWixTQVhZLEVBWVosU0FaWSxFQWFaLFNBYlksRUFjWixTQWRZLENBL0JVLENBOEN0QjtBQUNEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBOUV1QixDQUFsQjs7QUFrRkEsSUFBTSwwQkFBUzs7QUFFbkIsV0FBVTtBQUNULFNBQ0M7QUFDQyxhQUFVO0FBRFgsR0FGUTtBQUtULFNBQU87QUFDTixlQUFZLDJCQUFvQix1REFBcEIsR0FBOEUsU0FEcEY7QUFFTixhQUFVLEVBRko7QUFHTixjQUFXLFNBSEw7QUFJTixlQUFZLE1BSk47QUFLTixrQkFBZSxLQUxUO0FBTU4sV0FBUTtBQU5GLEdBTEU7QUFhVCxZQUFVO0FBQ1QsZUFBWSwyQkFBb0IsdURBQXBCLEdBQThFLFNBRGpGO0FBRVQsYUFBVSxFQUZEO0FBR1QsY0FBVyxTQUhGO0FBSVQsZUFBWSxNQUpIO0FBS1Qsa0JBQWUsS0FMTjtBQU1ULFdBQVE7QUFOQyxHQWJEO0FBcUJULFFBQU07QUFDTCxrQkFBZSxFQURWO0FBRUw7QUFDQSxtQkFBZ0IsU0FIWDtBQUlMO0FBQ0E7QUFDQSxvQkFBaUIsMkJBQW9CLHVEQUFwQixHQUE4RSxTQU4xRjtBQU9MOztBQUVBO0FBQ0Esb0JBQWlCLDJCQUFvQix1REFBcEIsR0FBOEUsU0FWMUY7QUFXTDtBQUNBLGtCQUFlLEVBWlY7QUFhTCxtQkFBZ0IsTUFiWDtBQWNMO0FBQ0EsY0FBVyxTQWZOO0FBZ0JMLGtCQUFlLENBaEJWO0FBaUJMLGtCQUFlLENBakJWO0FBa0JMLGNBQVcsU0FsQk47QUFtQkwsa0JBQWUsQ0FuQlY7QUFvQkwsY0FBVztBQXBCTixHQXJCRztBQTJDVCxVQUFRO0FBQ1Asa0JBQWUsUUFEUjtBQUVQLG9CQUFpQixRQUZWO0FBR1AsZUFBWSwyQkFBb0IsbUNBQXBCLEdBQTBEO0FBSC9ELEdBM0NDO0FBZ0RULGNBQVk7QUFDWDtBQUNBLHdCQUFxQixNQUZWO0FBR1g7QUFDQSx5QkFBc0IsMkJBQW9CLHVEQUFwQixHQUE4RSxTQUp6RjtBQUtYO0FBQ0EsdUJBQW9CLEVBTlQ7QUFPWDtBQUNBLDRCQUF5QjtBQVJkO0FBaERILEVBRlM7O0FBOERuQixXQUFVO0FBQ1QsU0FDQztBQUNDLGFBQVU7QUFEWCxHQUZRO0FBS1QsU0FBTztBQUNOLGVBQVksMkNBRE47QUFFTixhQUFVLEVBRkosRUFFTztBQUNiLGNBQVcsU0FITDtBQUlOLGtCQUFlLEtBSlQ7QUFLTixXQUFRO0FBTEYsR0FMRTtBQVlULFlBQVU7QUFDVCxlQUFZLDJDQURIO0FBRVQsYUFBVSxFQUZELEVBRUk7QUFDYixjQUFXLFNBSEY7QUFJVCxrQkFBZSxLQUpOO0FBS1QsV0FBUTtBQUxDLEdBWkQ7QUFtQlQsUUFBTTtBQUNMLGtCQUFlLEVBRFY7QUFFTCxtQkFBZ0IsZUFGWDtBQUdMO0FBQ0Esb0JBQWlCLDJCQUFvQixtQ0FBcEIsR0FBMEQsT0FKdEU7QUFLTCxvQkFBaUIsTUFMWjs7QUFRTCxvQkFBaUIsMkJBQW9CLGlDQUFwQixHQUF3RCxPQVJwRTtBQVNMO0FBQ0Esa0JBQWUsRUFWVjtBQVdMLG1CQUFnQixNQVhYO0FBWUwsb0JBQWlCLE1BWlo7QUFhTCxjQUFXLE1BYk47QUFjTCxrQkFBZSxDQWRWO0FBZUwsa0JBQWUsQ0FmVjtBQWdCTCxjQUFXLE1BaEJOO0FBaUJMLGNBQVcsTUFqQk47QUFrQkwsa0JBQWU7QUFsQlYsR0FuQkc7QUF1Q1QsVUFBUTtBQUNQLGtCQUFlLFFBRFI7QUFFUCxvQkFBaUIsUUFGVjtBQUdQLGVBQVksMkJBQW9CLG1DQUFwQixHQUEwRDtBQUgvRCxHQXZDQztBQTRDVCxjQUFZO0FBQ1gsd0JBQXFCLE1BRFY7QUFFWDtBQUNBLHlCQUFzQiwyQkFBb0IsaUNBQXBCLEdBQXdELE9BSG5FO0FBSVgseUJBQXNCLE1BSlg7QUFLWCx1QkFBb0IsRUFMVDtBQU1YO0FBQ0EsNEJBQXlCO0FBUGQ7QUE1Q0gsRUE5RFM7O0FBcUhuQixXQUFVO0FBQ1QsU0FDQztBQUNDLGFBQVU7QUFEWCxHQUZRO0FBS1QsU0FBTztBQUNOLGVBQVksMkJBQW9CLCtFQUFwQixHQUFzRyxTQUQ1RztBQUVOLGFBQVUsRUFGSjtBQUdOLGNBQVcsU0FITDtBQUlOLGVBQVksTUFKTjtBQUtOLGtCQUFlLEtBTFQ7QUFNTixXQUFRO0FBTkYsR0FMRTtBQWFULFlBQVU7QUFDVCxlQUFZLDJCQUFvQiwrRUFBcEIsR0FBc0csU0FEekc7QUFFVCxhQUFVLEVBRkQ7QUFHVCxjQUFXLFNBSEY7QUFJVCxlQUFZLE1BSkg7QUFLVCxrQkFBZSxLQUxOO0FBTVQsV0FBUTtBQU5DLEdBYkQ7QUFxQlQsUUFBTTtBQUNMLGtCQUFlLEVBRFY7QUFFTCxtQkFBZ0IsZUFGWDtBQUdMO0FBQ0Esb0JBQWlCLDJCQUFvQixzQ0FBcEIsR0FBNkQsU0FKekU7QUFLTDs7QUFFQTtBQUNBLG9CQUFpQiwyQkFBb0IsdURBQXBCLEdBQThFLFNBUjFGO0FBU0w7QUFDQSxrQkFBZSxFQVZWO0FBV0wsbUJBQWdCLE1BWFg7QUFZTDtBQUNBLGNBQVcsTUFiTjtBQWNMLGtCQUFlLENBZFY7QUFlTCxrQkFBZSxDQWZWO0FBZ0JMLGNBQVcsTUFoQk47QUFpQkwsa0JBQWUsQ0FqQlY7QUFrQkwsY0FBVztBQWxCTixHQXJCRztBQXlDVCxVQUFRO0FBQ1Asa0JBQWUsUUFEUjtBQUVQLG9CQUFpQixRQUZWO0FBR1AsZUFBWSwyQkFBb0IsbUNBQXBCLEdBQTBEO0FBSC9ELEdBekNDO0FBOENULGNBQVk7QUFDWCxpQkFBYyxJQURIO0FBRVgsd0JBQXFCLE1BRlY7QUFHWDtBQUNBLHlCQUFzQiwyQkFBb0IsdURBQXBCLEdBQThFLFNBSnpGO0FBS1g7QUFDQSx1QkFBb0IsRUFOVDtBQU9YLHdCQUFxQixXQVBWO0FBUVgsNEJBQXlCO0FBUmQ7QUE5Q0g7QUFySFMsQ0FBZjs7Ozs7Ozs7O0FDbkZQOzs7Ozs7QUFFQSxTQUFTLFFBQVQsQ0FBa0IsS0FBbEIsRUFBeUI7O0FBRXZCLE9BQUssS0FBTCxHQUFhLEtBQWI7QUFDQSxPQUFLLEdBQUwsR0FBVyxLQUFLLEtBQUwsQ0FBVyxRQUFYLENBQW9CLEdBQS9CO0FBQ0EsT0FBSyxVQUFMLEdBQWtCLEVBQWxCO0FBQ0EsT0FBSyxrQkFBTCxHQUEwQixJQUExQjtBQUNEOztBQUVEO0FBWkE7O0FBYUEsU0FBUyxTQUFULENBQW1CLE9BQW5CLEdBQTZCLFVBQVUsVUFBVixFQUFzQixRQUF0QixFQUFnQyxpQkFBaEMsRUFBbUQsVUFBbkQsRUFBK0QsY0FBL0QsRUFBK0U7QUFDMUcsTUFBSSxRQUFRLElBQVo7O0FBRUEsT0FBSyxLQUFMLENBQVcsV0FBWCxHQUF5QixJQUF6QjtBQUNBLG1CQUFpQixrQkFBa0IsbUJBQWdCLE1BQWhCLENBQXVCLE1BQTFEOztBQUVBLE1BQUksaUJBQUosRUFBdUI7O0FBRXJCLFNBQUssVUFBTCxDQUFnQixJQUFoQixDQUFxQjtBQUNuQixpQkFBWSxJQUFJLElBQUosRUFBRCxDQUFhLE9BQWIsTUFBMEIsYUFBYSxVQUFiLEdBQTBCLENBQXBELENBRFE7QUFFbkIsZ0JBQVUsUUFGUztBQUduQix5QkFBbUIsaUJBSEE7QUFJbkIsa0JBQVk7QUFKTyxLQUFyQjtBQU1EOztBQUVELE1BQUksc0JBQXNCLEVBQTFCOztBQUVBLFNBQU8sS0FBSyxVQUFMLENBQWdCLE1BQWhCLEdBQXlCLENBQWhDLEVBQW1DOztBQUVqQyxRQUFJLFlBQVksS0FBSyxVQUFMLENBQWdCLEtBQWhCLEVBQWhCO0FBQ0EsUUFBSSxNQUFPLElBQUksSUFBSixFQUFELENBQWEsT0FBYixFQUFWO0FBQ0EsUUFBSSxtQkFBbUIsQ0FBdkI7QUFDQTs7QUFFQSxRQUFJLFVBQVUsU0FBVixJQUF1QixHQUEzQixFQUFnQztBQUM5Qix5QkFBbUIsZUFBZSxLQUFLLEdBQUwsQ0FBVSxNQUFNLFVBQVUsU0FBMUIsRUFBc0MsVUFBVSxRQUFoRCxDQUFmLEVBQTBFLENBQTFFLEVBQTZFLENBQTdFLEVBQWdGLFVBQVUsUUFBMUYsQ0FBbkI7QUFDQTs7QUFFQSx5QkFBbUIsS0FBSyxHQUFMLENBQVMsZ0JBQVQsRUFBMkIsQ0FBM0IsQ0FBbkI7O0FBRUEsVUFBSSxNQUFNLGdCQUFOLEtBQTJCLENBQUMsU0FBUyxnQkFBVCxDQUFoQyxFQUNFLG1CQUFtQixDQUFuQjtBQUNIOztBQUVELFFBQUksbUJBQW1CLENBQXZCLEVBQTBCO0FBQ3hCLDBCQUFvQixJQUFwQixDQUF5QixTQUF6QjtBQUNEOztBQUVELGNBQVUsaUJBQVYsQ0FBNEIsZ0JBQTVCOztBQUVBLFFBQUksb0JBQW9CLENBQXBCLElBQXlCLFVBQVUsVUFBdkMsRUFDRSxVQUFVLFVBQVY7QUFDSDs7QUFFRCxPQUFLLFVBQUwsR0FBa0IsbUJBQWxCOztBQUVBLE1BQUksS0FBSyxVQUFMLENBQWdCLE1BQWhCLEdBQXlCLENBQTdCLEVBQWdDO0FBQzlCLFNBQUssa0JBQUwsR0FBMEIsS0FBSyxLQUFMLENBQVcsZ0JBQVgsQ0FBNEIsSUFBNUIsQ0FBaUMsTUFBakMsRUFBeUMsWUFBWTtBQUM3RSxZQUFNLE9BQU4sQ0FBYyxJQUFkLENBQW1CLEtBQW5CO0FBQ0QsS0FGeUIsQ0FBMUI7QUFHRCxHQUpELE1BSU87QUFDTCxTQUFLLEtBQUwsQ0FBVyxXQUFYLEdBQXlCLEtBQXpCO0FBQ0Q7QUFFRixDQXZERDs7QUF5REEsU0FBUyxTQUFULENBQW1CLG1CQUFuQixHQUF5QyxZQUFZOztBQUVuRCxPQUFLLFVBQUwsR0FBa0IsRUFBbEI7O0FBRUEsTUFBSSxLQUFLLGtCQUFULEVBQTZCO0FBQzNCLFNBQUssS0FBTCxDQUFXLHNCQUFYLENBQWtDLElBQWxDLENBQXVDLE1BQXZDLEVBQStDLEtBQUssa0JBQXBEO0FBQ0Q7O0FBRUQsT0FBSyxrQkFBTCxHQUEwQixJQUExQjtBQUNBLE9BQUssS0FBTCxDQUFXLFdBQVgsR0FBeUIsS0FBekI7QUFDRCxDQVZEOztrQkFZZSxROzs7Ozs7Ozs7QUNqRmY7Ozs7QUFDQTs7OztBQUNBOzs7O0FBRUEsU0FBUyxJQUFULENBQWMsS0FBZCxFQUFxQixPQUFyQixFQUE4QixJQUE5QixFQUFvQyxRQUFwQyxFQUE4Qzs7QUFFN0MsTUFBSyxJQUFMLENBQVUsV0FBVixDQUFzQixJQUF0QixDQUEyQixJQUEzQixFQUFpQyxNQUFqQyxFQUF5QyxPQUF6QyxFQUFrRCxNQUFNLEtBQXhEOztBQUVBLE1BQUssS0FBTCxHQUFhLEtBQWI7QUFDQSxNQUFLLE1BQUwsR0FBYyxNQUFNLE1BQXBCO0FBQ0EsTUFBSyxHQUFMLEdBQVcsTUFBTSxHQUFqQjtBQUNBLE1BQUssUUFBTCxHQUFnQixDQUFoQjtBQUNBLE1BQUssU0FBTCxHQUFpQixDQUFqQjtBQUNBLE1BQUsscUJBQUwsR0FBNkIsQ0FBN0I7QUFDQSxNQUFLLE1BQUwsR0FBYyxFQUFkO0FBQ0EsTUFBSyxPQUFMLEdBQWUsSUFBZjs7QUFFQTtBQUNBLE1BQUssUUFBTCxHQUFnQjtBQUNmLE9BQUssUUFEVTtBQUVmLE9BQUssQ0FBQyxRQUZTO0FBR2YsZUFBYSxRQUhFO0FBSWYsZUFBYSxDQUFDLFFBSkM7QUFLZixXQUFTLFFBTE0sQ0FLRztBQUxILEVBQWhCOztBQVFBLEtBQUksU0FBUyxPQUFiLEVBQXNCO0FBQ3JCLE9BQUssZ0JBQUwsR0FBd0IsS0FBSyxLQUFMLENBQVcsZ0JBQVgsQ0FBNEIsSUFBNUIsQ0FBeEI7O0FBRUEsTUFBSSxDQUFDLEtBQUssUUFBTCxDQUFjLFFBQW5CLEVBQ0MsS0FBSyxZQUFMLEdBQW9CLElBQXBCO0FBQ0QsRUFMRCxNQUtPO0FBQ04sTUFBSSxhQUFhLE1BQWIsSUFBdUIsYUFBYSxLQUF4QyxFQUNDLEtBQUssZ0JBQUwsR0FBd0IsS0FBSyxLQUFMLENBQVcsZ0JBQVgsQ0FBNEIsT0FBNUIsQ0FBeEIsQ0FERCxLQUVLO0FBQ0osUUFBSyxnQkFBTCxHQUF3QixLQUFLLEtBQUwsQ0FBVyxnQkFBWCxDQUE0QixRQUE1QixDQUF4QjtBQUNBO0FBQ0Q7O0FBSUQsS0FBSSxPQUFRLEtBQUssUUFBTCxDQUFjLGFBQXRCLEtBQXlDLFdBQTdDLEVBQTBEOztBQUV6RCxPQUFLLGFBQUwsR0FBcUIsS0FBSyxLQUFMLENBQVcsZUFBWCxDQUEyQixLQUFLLGFBQWhDLENBQXJCOztBQUVBO0FBQ0E7O0FBRUQsS0FBSSxPQUFRLEtBQUssUUFBTCxDQUFjLGFBQXRCLEtBQXlDLFdBQTdDLEVBQTBEOztBQUV6RCxPQUFLLGFBQUwsR0FBcUIsS0FBSyxLQUFMLENBQVcsZUFBWCxDQUEyQixLQUFLLGFBQWhDLENBQXJCOztBQUVBO0FBRUE7O0FBRUQ7QUFDQSxNQUFLLElBQUwsR0FBWSxJQUFaO0FBQ0EsS0FBSSxTQUFTLE9BQVQsS0FBcUIsQ0FBQyxPQUFELElBQVksT0FBUSxRQUFRLGFBQWhCLEtBQW1DLFdBQXBFLENBQUosRUFDQyxLQUFLLGFBQUwsR0FBcUIsQ0FBckI7O0FBRUQsTUFBSyxTQUFMLEdBQWlCLFFBQWpCOztBQUVBLE1BQUssZUFBTCxHQUF1QjtBQUN0QixNQUFJLElBRGtCLEVBQ1osSUFBSSxJQURRLEVBQ0YsSUFBSSxJQURGLEVBQ1EsSUFBSSxJQURaLEVBQ2tCLE9BQU87QUFEekIsRUFBdkIsQ0EzRDZDLENBNkQzQztBQUNGO0FBQ0E7QUFDQyxPQUFLLFVBQUwsR0FBa0IsQ0FBRSxLQUFLLFVBQUwsR0FBa0IsR0FBbkIsR0FBMEIsR0FBM0IsSUFBa0MsR0FBcEQ7O0FBRUEsTUFBSSxLQUFLLFVBQUwsR0FBa0IsRUFBbEIsSUFBd0IsS0FBSyxVQUFMLElBQW1CLEdBQS9DLEVBQ0MsS0FBSyxVQUFMLElBQW1CLEdBQW5CLENBREQsS0FFSyxJQUFJLEtBQUssVUFBTCxHQUFrQixHQUFsQixJQUF5QixLQUFLLFVBQUwsSUFBbUIsR0FBaEQsRUFDSixLQUFLLFVBQUwsSUFBbUIsR0FBbkIsQ0FESSxLQUVBLElBQUksS0FBSyxVQUFMLEdBQWtCLEdBQWxCLElBQXlCLEtBQUssVUFBTCxJQUFtQixHQUFoRCxFQUNKLEtBQUssVUFBTCxJQUFtQixHQUFuQjtBQUNEOztBQUVELEtBQUksS0FBSyxRQUFMLENBQWMsVUFBZCxJQUE0QixLQUFLLFFBQUwsQ0FBYyxVQUFkLENBQXlCLE1BQXpCLEdBQWtDLENBQWxFLEVBQXFFOztBQUVwRSxPQUFLLFVBQUwsR0FBa0IsRUFBbEI7O0FBRUEsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEtBQUssUUFBTCxDQUFjLFVBQWQsQ0FBeUIsTUFBN0MsRUFBcUQsR0FBckQsRUFBMEQ7QUFDekQsUUFBSyxVQUFMLENBQWdCLElBQWhCLENBQXFCLElBQUksU0FBSixDQUFjLEtBQUssS0FBbkIsRUFBMEIsS0FBSyxRQUFMLENBQWMsVUFBZCxDQUF5QixDQUF6QixDQUExQixFQUF1RCxNQUFNLEtBQTdELEVBQW9FLEVBQUUsS0FBSyxLQUFMLENBQVcsYUFBWCxDQUF5QixZQUEvRixFQUE2RyxJQUE3RyxDQUFyQjtBQUNBO0FBQ0Q7O0FBRUQsTUFBSyxlQUFMLEdBQXVCLElBQXZCOztBQUVBLEtBQUksQ0FBQyxLQUFLLGdCQUFMLENBQXNCLGlCQUF0QixDQUFELElBQTZDLENBQUMsTUFBTSxLQUFLLGdCQUFMLENBQXNCLGtCQUE1QixDQUE5QyxJQUFpRyxLQUFLLGdCQUFMLENBQXNCLGtCQUF0QixLQUE2QyxJQUFsSixFQUNDLEtBQUssZUFBTCxHQUF1QixLQUFLLGdCQUFMLENBQXNCLGtCQUE3QyxDQURELEtBR0MsS0FBSyxnQkFBTCxDQUFzQixrQkFBdEIsR0FBMkMsSUFBM0M7O0FBRUQsS0FBSSxDQUFDLEtBQUssZ0JBQUwsQ0FBc0IsaUJBQXRCLENBQUQsSUFBNkMsQ0FBQyxNQUFNLEtBQUssZ0JBQUwsQ0FBc0Isa0JBQTVCLENBQTlDLElBQWlHLEtBQUssZ0JBQUwsQ0FBc0Isa0JBQXRCLEtBQTZDLElBQWxKLEVBQ0MsS0FBSyxlQUFMLEdBQXVCLEtBQUssZ0JBQUwsQ0FBc0Isa0JBQTdDLENBREQsS0FHQyxLQUFLLGdCQUFMLENBQXNCLGtCQUF0QixHQUEyQyxJQUEzQzs7QUFFRCxLQUFJLEtBQUssT0FBTCxLQUFpQixJQUFqQixJQUF5QixLQUFLLGVBQUwsS0FBeUIsSUFBdEQsRUFDQyxLQUFLLGVBQUwsR0FBdUIsS0FBSyxHQUFMLENBQVMsS0FBSyxlQUFkLEVBQStCLEtBQUssT0FBcEMsQ0FBdkI7O0FBRUQsS0FBSSxLQUFLLE9BQUwsS0FBaUIsSUFBakIsSUFBeUIsS0FBSyxlQUFMLEtBQXlCLElBQXRELEVBQ0MsS0FBSyxlQUFMLEdBQXVCLEtBQUssR0FBTCxDQUFTLEtBQUssZUFBZCxFQUErQixLQUFLLE9BQXBDLENBQXZCOztBQUVELE1BQUssWUFBTCxDQUFrQixpQkFBbEI7QUFDQSxNQUFLLFlBQUwsQ0FBa0IsaUJBQWxCO0FBQ0E7O0FBRUQsbUJBQU8sSUFBUCxFQUFhLGtCQUFiOztBQUVBLEtBQUssU0FBTCxDQUFlLFlBQWYsR0FBOEIsWUFBWTs7QUFFekMsS0FBSSxTQUFKO0FBQ0EsS0FBSSxJQUFJLENBQVI7QUFDQSxLQUFJLFFBQUo7O0FBRUEsS0FBSSxnQkFBZ0IsQ0FBcEI7QUFDQSxLQUFJLGlCQUFpQixDQUFyQjtBQUNBLEtBQUksbUJBQW1CLENBQXZCOztBQUVBOzs7QUFHQSxLQUFJLEtBQUssU0FBTCxLQUFtQixRQUFuQixJQUErQixLQUFLLFNBQUwsS0FBbUIsS0FBdEQsRUFBNkQ7QUFDNUQscUJBQW1CLEtBQUssZUFBTCxDQUFxQixLQUFyQixHQUE2QixLQUFLLEdBQUwsQ0FBUyxLQUFLLGVBQUwsR0FBdUIsS0FBSyxlQUFyQyxDQUE3QixHQUFxRixLQUFLLFFBQTdHOztBQUVBLE1BQUksS0FBSyxZQUFULEVBQXVCO0FBQ3RCLG1CQUFnQixPQUFRLEtBQUssUUFBTCxDQUFjLGFBQXRCLEtBQXlDLFdBQXpDLEdBQXVELG1CQUFtQixFQUFuQixJQUF5QixDQUFoRixHQUFvRixLQUFLLGFBQXpHO0FBQ0EsR0FGRCxNQUdLO0FBQ0osbUJBQWdCLE9BQVEsS0FBSyxRQUFMLENBQWMsYUFBdEIsS0FBeUMsV0FBekMsR0FBdUQsS0FBSyxLQUFMLENBQVcsS0FBWCxHQUFtQixFQUFuQixJQUF5QixDQUFoRixHQUFvRixLQUFLLGFBQXpHO0FBQ0E7O0FBRUQsbUJBQWlCLE9BQVEsS0FBSyxRQUFMLENBQWMsU0FBdEIsS0FBcUMsV0FBckMsSUFBb0QsS0FBSyxTQUF6RCxHQUFxRSxLQUFLLEtBQUwsQ0FBVyxNQUFYLEdBQW9CLEVBQXBCLElBQTBCLENBQS9GLEdBQW1HLEtBQUssYUFBTCxHQUFxQixHQUF6STtBQUNBLEVBWEQsTUFZSyxJQUFJLEtBQUssU0FBTCxLQUFtQixNQUFuQixJQUE2QixLQUFLLFNBQUwsS0FBbUIsT0FBcEQsRUFBNkQ7O0FBRWpFLHFCQUFtQixLQUFLLGVBQUwsQ0FBcUIsTUFBckIsR0FBOEIsS0FBSyxHQUFMLENBQVMsS0FBSyxlQUFMLEdBQXVCLEtBQUssZUFBckMsQ0FBOUIsR0FBc0YsS0FBSyxRQUE5Rzs7QUFHQSxNQUFJLEtBQUssWUFBVCxFQUF1QjtBQUN0QixtQkFBZ0IsT0FBUSxLQUFLLFFBQUwsQ0FBYyxhQUF0QixLQUF5QyxXQUF6QyxHQUF1RCxLQUFLLEtBQUwsQ0FBVyxLQUFYLEdBQW1CLEVBQW5CLElBQXlCLENBQWhGLEdBQW9GLEtBQUssYUFBekc7QUFDQSxHQUZELE1BR0s7QUFDSixtQkFBZ0IsT0FBUSxLQUFLLFFBQUwsQ0FBYyxhQUF0QixLQUF5QyxXQUF6QyxHQUF1RCxLQUFLLEtBQUwsQ0FBVyxLQUFYLEdBQW1CLEVBQW5CLElBQXlCLENBQWhGLEdBQW9GLEtBQUssYUFBekc7QUFDQTs7QUFFRCxtQkFBaUIsT0FBUSxLQUFLLFFBQUwsQ0FBYyxTQUF0QixLQUFxQyxXQUFyQyxJQUFvRCxLQUFLLFNBQXpELEdBQXFFLG1CQUFtQixDQUFuQixJQUF3QixDQUE3RixHQUFpRyxLQUFLLGFBQUwsR0FBcUIsR0FBdkk7QUFDQTs7QUFFRCxLQUFJLEtBQUssSUFBTCxLQUFjLE9BQWQsSUFBeUIsS0FBSyxLQUFMLENBQVcsUUFBWCxDQUFvQixjQUFwQixLQUF1QyxVQUFwRSxFQUFnRjtBQUMvRSxhQUFXLGNBQWMsSUFBSSxJQUFKLENBQVMsS0FBSyxlQUFkLENBQWQsRUFBOEMsS0FBSyxRQUFuRCxFQUE2RCxLQUFLLFlBQWxFLENBQVg7QUFDQTs7QUFFQSxPQUFLLElBQUksS0FBSyxxQkFBZCxFQUFxQyxJQUFJLFFBQXpDLEVBQW1ELGNBQWMsQ0FBZCxFQUFpQixLQUFLLFFBQXRCLEVBQWdDLEtBQUssWUFBckMsQ0FBbkQsRUFBdUc7O0FBRXRHO0FBQ0EsT0FBSSxxQkFBcUIsRUFBRSxPQUFGLEVBQXpCO0FBQ0EsT0FBSSxPQUFPLEtBQUssY0FBTCxHQUFzQixLQUFLLGNBQUwsQ0FBb0IsRUFBRSxPQUFPLEtBQUssS0FBZCxFQUFxQixNQUFNLEtBQUssUUFBaEMsRUFBMEMsT0FBTyxDQUFqRCxFQUFvRCxPQUFPLEtBQUssTUFBTCxDQUFZLENBQVosSUFBaUIsS0FBSyxNQUFMLENBQVksQ0FBWixDQUFqQixHQUFrQyxJQUE3RixFQUFwQixDQUF0QixHQUNSLEtBQUssSUFBTCxLQUFjLE9BQWQsSUFBeUIsS0FBSyxNQUFMLENBQVksa0JBQVosQ0FBekIsR0FBMkQsS0FBSyxNQUFMLENBQVksa0JBQVosQ0FBM0QsR0FBNkYsV0FBVyxDQUFYLEVBQWMsS0FBSyxpQkFBbkIsRUFBc0MsS0FBSyxLQUFMLENBQVcsWUFBakQsQ0FEaEc7O0FBR0EsZUFBWSxJQUFJLG9CQUFKLENBQWMsS0FBSyxHQUFuQixFQUF3QjtBQUNuQyxPQUFHLENBRGdDO0FBRW5DLE9BQUcsQ0FGZ0M7QUFHbkM7QUFDQTtBQUNBLGNBQVUsYUFMeUI7QUFNbkMsZUFBVyxjQU53QjtBQU9uQyxXQUFPLEtBQUssVUFQdUI7QUFRbkMsVUFBTSxLQUFLLE1BQUwsR0FBYyxJQUFkLEdBQXFCLEtBQUssTUFSRztBQVNuQyxxQkFBaUIsTUFUa0IsRUFTWDtBQUN4QixjQUFVLEtBQUssYUFWb0IsRUFVTjtBQUM3QixnQkFBWSxLQUFLLGVBWGtCO0FBWW5DLGdCQUFZLEtBQUssZUFaa0IsRUFZRDtBQUNsQyxlQUFXLEtBQUssY0FibUI7QUFjbkMsZUFBVyxLQUFLLGNBZG1CLEVBY0g7QUFDaEMsa0JBQWM7QUFmcUIsSUFBeEIsQ0FBWjs7QUFrQkEsUUFBSyxPQUFMLENBQWEsSUFBYixDQUFrQixFQUFFLFVBQVUsRUFBRSxPQUFGLEVBQVosRUFBeUIsV0FBVyxTQUFwQyxFQUErQyxpQkFBaUIsSUFBaEUsRUFBbEI7QUFDQTtBQUVELEVBaENELE1BaUNLO0FBQ0osYUFBVyxLQUFLLGVBQWhCOztBQUVBOztBQUVBO0FBQ0EsTUFBSSxLQUFLLE1BQUwsSUFBZSxLQUFLLE1BQUwsQ0FBWSxNQUEvQixFQUF1QztBQUN0QyxPQUFJLGVBQWUsS0FBSyxJQUFMLENBQVUsS0FBSyxRQUFmLENBQW5CO0FBQ0EsT0FBSSxpQkFBaUIsS0FBSyxJQUFMLENBQVUsS0FBSyxxQkFBZixDQUFyQjtBQUNBLE9BQUksZUFBZSxLQUFuQjtBQUNBLFFBQUssSUFBSSxjQUFULEVBQXlCLElBQUksS0FBSyxlQUFsQyxFQUFtRCxLQUFLLFlBQXhELEVBQXNFO0FBQ3JFLFFBQUksS0FBSyxNQUFMLENBQVksQ0FBWixDQUFKLEVBQW9CO0FBQ25CLG9CQUFlLElBQWY7QUFDQSxLQUZELE1BRU87QUFDTixvQkFBZSxLQUFmO0FBQ0E7QUFDQTtBQUNEOztBQUVELE9BQUksWUFBSixFQUFrQjtBQUNqQixTQUFLLFFBQUwsR0FBZ0IsWUFBaEI7QUFDQSxTQUFLLHFCQUFMLEdBQTZCLGNBQTdCO0FBQ0E7QUFDRDs7QUFFRDtBQUNBLE9BQUssSUFBSSxLQUFLLHFCQUFkLEVBQXFDLEtBQUssUUFBMUMsRUFBb0QsSUFBSSxXQUFXLENBQUMsSUFBSSxLQUFLLFFBQVYsRUFBb0IsT0FBcEIsQ0FBNEIsRUFBNUIsQ0FBWCxDQUF4RCxFQUFxRzs7QUFFcEcsT0FBSSxPQUFPLEtBQUssY0FBTCxHQUFzQixLQUFLLGNBQUwsQ0FBb0IsRUFBRSxPQUFPLEtBQUssS0FBZCxFQUFxQixNQUFNLEtBQUssUUFBaEMsRUFBMEMsT0FBTyxDQUFqRCxFQUFvRCxPQUFPLEtBQUssTUFBTCxDQUFZLENBQVosSUFBaUIsS0FBSyxNQUFMLENBQVksQ0FBWixDQUFqQixHQUFrQyxJQUE3RixFQUFwQixDQUF0QixHQUNSLEtBQUssSUFBTCxLQUFjLE9BQWQsSUFBeUIsS0FBSyxNQUFMLENBQVksQ0FBWixDQUF6QixHQUEwQyxLQUFLLE1BQUwsQ0FBWSxDQUFaLENBQTFDLEdBQTJELHlCQUFhLENBQWIsRUFBZ0IsS0FBSyxpQkFBckIsRUFBd0MsS0FBSyxLQUFMLENBQVcsWUFBbkQsQ0FEOUQ7O0FBR0EsZUFBWSxJQUFJLG9CQUFKLENBQWMsS0FBSyxHQUFuQixFQUF3QjtBQUNuQyxPQUFHLENBRGdDO0FBRW5DLE9BQUcsQ0FGZ0M7QUFHbkM7QUFDQTtBQUNBLGNBQVUsYUFMeUI7QUFNbkMsZUFBVyxjQU53QjtBQU9uQyxXQUFPLEtBQUssVUFQdUI7QUFRbkMsVUFBTSxLQUFLLE1BQUwsR0FBYyxJQUFkLEdBQXFCLEtBQUssTUFSRztBQVNuQyxxQkFBaUIsTUFUa0IsRUFTWDtBQUN4QixjQUFVLEtBQUssYUFWb0IsRUFVTjtBQUM3QixnQkFBWSxLQUFLLGVBWGtCO0FBWW5DLGdCQUFZLEtBQUssZUFaa0IsRUFZRDtBQUNsQyxlQUFXLEtBQUssY0FibUI7QUFjbkMsZUFBVyxLQUFLLGNBZG1CLEVBY0g7QUFDaEMsa0JBQWMsUUFmcUI7QUFnQm5DLHFCQUFpQjtBQWhCa0IsSUFBeEIsQ0FBWjs7QUFtQkEsUUFBSyxPQUFMLENBQWEsSUFBYixDQUFrQixFQUFFLFVBQVUsQ0FBWixFQUFlLFdBQVcsU0FBMUIsRUFBcUMsaUJBQWlCLElBQXRELEVBQWxCO0FBQ0E7QUFDRDs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksS0FBSyxVQUFMLENBQWdCLE1BQXBDLEVBQTRDLEdBQTVDLEVBQWlEOztBQUVoRCxNQUFJLFlBQVksS0FBSyxVQUFMLENBQWdCLENBQWhCLENBQWhCOztBQUVBLGNBQVksSUFBSSxvQkFBSixDQUFjLEtBQUssR0FBbkIsRUFBd0I7QUFDbkMsTUFBRyxDQURnQztBQUVuQyxNQUFHLENBRmdDO0FBR25DO0FBQ0E7QUFDQSxvQkFBaUIsVUFBVSxvQkFMUTtBQU1uQyxhQUFVLGFBTnlCO0FBT25DLGNBQVcsY0FQd0I7QUFRbkMsVUFBTyxLQUFLLFVBUnVCO0FBU25DLFNBQU0sVUFBVSxjQUFWLEdBQTJCLFVBQVUsY0FBVixDQUF5QixFQUFFLE9BQU8sS0FBSyxLQUFkLEVBQXFCLE1BQU0sSUFBM0IsRUFBaUMsV0FBVyxTQUE1QyxFQUF6QixDQUEzQixHQUErRyxVQUFVLEtBVDVGO0FBVW5DLG9CQUFpQixNQVZrQixFQVVYO0FBQ3hCLGFBQVUsVUFBVSxhQVhlLEVBV0Q7QUFDbEMsZUFBWSxVQUFVLGVBWmE7QUFhbkMsZUFBWSxVQUFVLGVBYmEsRUFhSTtBQUN2QyxjQUFXLFVBQVUsUUFBVixDQUFtQixjQUFuQixJQUFxQyxVQUFVLEtBZHZCO0FBZW5DLGNBQVcsVUFBVSxjQWZjLEVBZUU7QUFDckMsaUJBQWMsUUFoQnFCO0FBaUJuQyxvQkFBaUI7QUFqQmtCLEdBQXhCLENBQVo7O0FBb0JBLE9BQUssT0FBTCxDQUFhLElBQWIsQ0FBa0IsRUFBRSxVQUFVLFVBQVUsS0FBdEIsRUFBNkIsV0FBVyxTQUF4QyxFQUFtRCxpQkFBaUIsSUFBcEUsRUFBMEUsV0FBVyxTQUFyRixFQUFsQjtBQUNBO0FBRUQsQ0ExSkQ7O0FBNEpBLEtBQUssU0FBTCxDQUFlLDZCQUFmLEdBQStDLFlBQVk7O0FBRTFELEtBQUkseUJBQXlCLENBQTdCO0FBQ0EsTUFBSyxPQUFMLEdBQWUsRUFBZjs7QUFFQSxLQUFJLEtBQUssU0FBTCxLQUFtQixNQUFuQixJQUE2QixLQUFLLFNBQUwsS0FBbUIsT0FBcEQsRUFBNkQ7O0FBRTVELE9BQUssWUFBTDs7QUFFQSxPQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksS0FBSyxPQUFMLENBQWEsTUFBakMsRUFBeUMsR0FBekMsRUFBOEM7O0FBRTdDLE9BQUksWUFBWSxLQUFLLE9BQUwsQ0FBYSxDQUFiLEVBQWdCLFNBQWhDOztBQUVBLE9BQUksT0FBTyxVQUFVLFdBQVYsRUFBWDs7QUFFQTtBQUNBOztBQUVBLE9BQUksc0JBQXNCLENBQTFCOztBQUVBLE9BQUksS0FBSyxVQUFMLEtBQW9CLENBQXhCLEVBQ0Msc0JBQXNCLEtBQUssS0FBM0IsQ0FERCxLQUdDLHNCQUF1QixLQUFLLEtBQUwsR0FBYSxLQUFLLEdBQUwsQ0FBUyxLQUFLLEVBQUwsR0FBVSxHQUFWLEdBQWdCLEtBQUssR0FBTCxDQUFTLEtBQUssVUFBZCxDQUF6QixDQUFkLEdBQXNFLEtBQUssTUFBTCxHQUFjLENBQWQsR0FBa0IsS0FBSyxHQUFMLENBQVMsS0FBSyxFQUFMLEdBQVUsR0FBVixHQUFnQixLQUFLLEdBQUwsQ0FBUyxLQUFLLFVBQWQsQ0FBekIsQ0FBOUc7O0FBR0QsT0FBSSx5QkFBeUIsbUJBQTdCLEVBQ0MseUJBQXlCLG1CQUF6Qjs7QUFFRCxRQUFLLE9BQUwsQ0FBYSxDQUFiLEVBQWdCLGNBQWhCLEdBQWlDLG1CQUFqQztBQUNBO0FBQ0Q7O0FBSUQsS0FBSSxjQUFjLEtBQUssS0FBTCxHQUFhLHNCQUFzQixLQUFLLGVBQTNCLEVBQTRDLEtBQUssYUFBakQsRUFBZ0UsS0FBSyxlQUFyRSxJQUF3RixDQUFyRyxHQUF5RyxDQUEzSDs7QUFFQSxLQUFJLFlBQVksY0FBYyxzQkFBZCxHQUF1QyxLQUFLLFVBQTVDLEdBQXlELENBQXpFOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSxRQUFPLFNBQVA7QUFDQSxDQTVDRDs7QUE4Q0EsS0FBSyxTQUFMLENBQWUsOEJBQWYsR0FBZ0QsWUFBWTtBQUMzRCxLQUFJLDBCQUEwQixDQUE5QjtBQUNBLE1BQUssT0FBTCxHQUFlLEVBQWY7QUFDQSxLQUFJLFNBQUo7QUFDQSxLQUFJLElBQUksQ0FBUjs7QUFFQSxNQUFLLFlBQUw7O0FBRUEsS0FBSSxLQUFLLFNBQUwsS0FBbUIsUUFBbkIsSUFBK0IsS0FBSyxTQUFMLEtBQW1CLEtBQXRELEVBQTZEOztBQUU1RCxPQUFLLElBQUksQ0FBVCxFQUFZLElBQUksS0FBSyxPQUFMLENBQWEsTUFBN0IsRUFBcUMsR0FBckMsRUFBMEM7O0FBRXpDLGVBQVksS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixTQUE1Qjs7QUFFQSxPQUFJLE9BQU8sVUFBVSxXQUFWLEVBQVg7QUFDQTs7QUFFQTtBQUNBOztBQUVBLE9BQUksdUJBQXVCLENBQTNCOztBQUVBLE9BQUksS0FBSyxVQUFMLEtBQW9CLENBQXhCLEVBQ0MsdUJBQXVCLEtBQUssTUFBNUIsQ0FERCxLQUdDLHVCQUF3QixLQUFLLEtBQUwsR0FBYSxLQUFLLEdBQUwsQ0FBUyxLQUFLLEVBQUwsR0FBVSxHQUFWLEdBQWdCLEtBQUssR0FBTCxDQUFTLEtBQUssVUFBZCxDQUF6QixDQUFkLEdBQXNFLEtBQUssTUFBTCxHQUFjLENBQWQsR0FBa0IsS0FBSyxHQUFMLENBQVMsS0FBSyxFQUFMLEdBQVUsR0FBVixHQUFnQixLQUFLLEdBQUwsQ0FBUyxLQUFLLFVBQWQsQ0FBekIsQ0FBL0c7O0FBRUQsT0FBSSwwQkFBMEIsb0JBQTlCLEVBQ0MsMEJBQTBCLG9CQUExQjs7QUFFRCxRQUFLLE9BQUwsQ0FBYSxDQUFiLEVBQWdCLGVBQWhCLEdBQWtDLG9CQUFsQztBQUNBO0FBQ0Q7O0FBRUQ7QUFDQSxLQUFJLGNBQWMsS0FBSyxLQUFMLEdBQWEsc0JBQXNCLEtBQUssZUFBM0IsRUFBNEMsS0FBSyxhQUFqRCxFQUFnRSxLQUFLLGVBQXJFLElBQXdGLENBQXJHLEdBQXlHLENBQTNIOztBQUVBLFFBQU8sY0FBYyx1QkFBZCxHQUF3QyxLQUFLLFVBQTdDLEdBQTBELENBQWpFO0FBQ0EsQ0F0Q0Q7O0FBd0NBO0FBQ0EsS0FBSyxrQkFBTCxHQUEwQixVQUFVLEtBQVYsRUFBaUIsS0FBakIsRUFBd0IsTUFBeEIsRUFBZ0MsYUFBaEMsRUFBK0MsU0FBL0MsRUFBMEQ7QUFDbkYsS0FBSSxFQUFKLEVBQVEsRUFBUixFQUFZLEVBQVosRUFBZ0IsRUFBaEI7QUFDQSxLQUFJLFFBQVEsTUFBTSxLQUFsQjtBQUNBLEtBQUksTUFBTSxNQUFNLEdBQWhCOztBQUVBLE9BQU0sdUJBQU47O0FBRUEsS0FBSSxLQUFKLEVBQ0MsTUFBTSx1QkFBTjs7QUFFRCxLQUFJLE1BQUosRUFDQyxPQUFPLHVCQUFQOztBQUVEO0FBQ0E7O0FBRUE7O0FBRUE7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBLEtBQUkscUJBQXFCLFFBQVEsTUFBTSxhQUFOLEdBQXNCLE1BQU0sYUFBNUIsR0FBNEMsQ0FBcEQsR0FBd0QsQ0FBakY7QUFDQSxLQUFJLHNCQUFzQixTQUFTLE9BQU8sYUFBUCxHQUF1QixPQUFPLGFBQTlCLEdBQThDLENBQXZELEdBQTJELENBQXJGOztBQUVBLEtBQUkscUJBQXFCLFFBQVEsTUFBTSxhQUFOLEdBQXNCLE1BQU0sYUFBNUIsR0FBNEMsQ0FBcEQsR0FBd0QsQ0FBakY7QUFDQSxLQUFJLHNCQUFzQixTQUFTLE9BQU8sYUFBUCxHQUF1QixPQUFPLGFBQTlCLEdBQThDLENBQXZELEdBQTJELENBQXJGOztBQUVBLEtBQUksY0FBYyxRQUFRLE1BQU0sTUFBZCxHQUF1QixDQUF6QztBQUNBLEtBQUksZUFBZSxRQUFRLE1BQU0sTUFBZCxHQUF1QixDQUExQzs7QUFFQSxLQUFJLGtCQUFrQixRQUF0QixFQUFnQzs7QUFFL0IsUUFBTSxlQUFOLEdBQXdCLEVBQXhCOztBQUdBLE1BQUksYUFBYSxLQUFLLElBQUwsQ0FBVSxRQUFRLE1BQU0sNkJBQU4sRUFBUixHQUFnRCxDQUExRCxDQUFqQjtBQUNBLE9BQUssS0FBSyxLQUFMLENBQVcsVUFBVSxFQUFWLEdBQWUsVUFBZixHQUE0QixXQUF2QyxDQUFMO0FBQ0EsUUFBTSxlQUFOLENBQXNCLEVBQXRCLEdBQTJCLEVBQTNCOztBQUVBLE1BQUksY0FBYyxLQUFLLElBQUwsQ0FBVSxTQUFTLE9BQU8sNkJBQVAsRUFBVCxHQUFrRCxDQUE1RCxDQUFsQjtBQUNBLE9BQUssS0FBSyxLQUFMLENBQVcsVUFBVSxFQUFWLEdBQWUsV0FBZixHQUE2QixNQUFNLEtBQU4sQ0FBWSxLQUFaLEdBQW9CLEVBQWpELEdBQXNELE1BQU0sS0FBTixDQUFZLEtBQVosR0FBb0IsRUFBMUUsR0FBK0UsVUFBVSxFQUFWLEdBQWUsV0FBekcsQ0FBTDtBQUNBLFFBQU0sZUFBTixDQUFzQixFQUF0QixHQUEyQixFQUEzQjs7QUFFQSxRQUFNLGVBQU4sQ0FBc0IsS0FBdEIsR0FBOEIsS0FBSyxHQUFMLENBQVMsS0FBSyxFQUFkLENBQTlCLENBYitCLENBYWtCOztBQUVqRCxNQUFJLGNBQWMsS0FBSyxJQUFMLENBQVUsTUFBTSw4QkFBTixFQUFWLENBQWxCOztBQUVBO0FBQ0E7QUFDQSxPQUFLLEtBQUssS0FBTCxDQUFXLFVBQVUsRUFBVixHQUFlLFdBQWYsR0FBNkIsTUFBTSxNQUE5QyxDQUFMO0FBQ0EsT0FBSyxLQUFLLEtBQUwsQ0FBVyxVQUFVLEVBQVYsR0FBZSxNQUFNLE1BQWhDLENBQUw7O0FBRUE7QUFDQSxRQUFNLGVBQU4sQ0FBc0IsRUFBdEIsR0FBMkIsRUFBM0I7QUFDQSxRQUFNLGVBQU4sQ0FBc0IsRUFBdEIsR0FBMkIsRUFBM0I7O0FBRUEsUUFBTSxZQUFOLEdBQXFCO0FBQ3BCLE9BQUksRUFEZ0IsRUFDWixJQUFJLEVBRFEsRUFDSixJQUFJLEVBREEsRUFDSSxJQUFJLEVBRFIsRUFDWSxPQUFPLEtBQUssRUFEeEIsRUFDNEIsUUFBUSxLQUFLO0FBRHpDLEdBQXJCOztBQUlBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0EsTUFBSSxLQUFKLEVBQVc7QUFDVixRQUFLLEtBQUssS0FBTCxDQUFXLFVBQVUsRUFBVixHQUFlLE1BQU0sTUFBaEMsQ0FBTDtBQUNBLFFBQUssS0FBSyxLQUFMLENBQVcsVUFBVSxFQUFWLEdBQWUsRUFBZixHQUFvQixFQUFwQixHQUF5QixVQUFVLEVBQTlDLENBQUw7QUFDQSxRQUFLLEtBQUssS0FBTCxDQUFXLFVBQVUsRUFBVixHQUFlLFVBQWYsR0FBNEIsTUFBTSxNQUE3QyxDQUFMO0FBQ0E7QUFDQSxRQUFLLEtBQUssS0FBTCxDQUFXLFVBQVUsRUFBVixHQUFlLFdBQWYsR0FBNkIsTUFBTSxNQUE5QyxDQUFMOztBQUVBLFNBQU0sZUFBTixHQUF3QjtBQUN2QixRQUFJLEVBRG1CLEVBQ2YsSUFBSSxFQURXLEVBQ1AsSUFBSSxFQURHLEVBQ0MsSUFBSSxFQURMLEVBQ1MsUUFBUSxLQUFLLEdBQUwsQ0FBUyxLQUFLLEVBQWQ7QUFEakIsSUFBeEI7O0FBSUEsU0FBTSxZQUFOLEdBQXFCO0FBQ3BCLFFBQUksRUFEZ0IsRUFDWixJQUFJLEVBRFEsRUFDSixJQUFJLEVBREEsRUFDSSxJQUFJLEVBRFIsRUFDWSxPQUFPLEtBQUssRUFEeEIsRUFDNEIsUUFBUSxLQUFLO0FBRHpDLElBQXJCO0FBR0E7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSxNQUFJLE1BQUosRUFBWTtBQUNYLFFBQUssS0FBSyxLQUFMLENBQVcsTUFBTSxlQUFOLENBQXNCLEVBQWpDLENBQUw7QUFDQSxRQUFLLEtBQUssS0FBTCxDQUFXLFVBQVUsRUFBVixHQUFlLEVBQWYsR0FBb0IsRUFBcEIsR0FBeUIsVUFBVSxFQUE5QyxDQUFMO0FBQ0EsUUFBSyxLQUFLLEtBQUwsQ0FBVyxLQUFLLFdBQUwsR0FBbUIsT0FBTyxNQUFyQyxDQUFMO0FBQ0E7QUFDQSxRQUFLLEtBQUssS0FBTCxDQUFXLFVBQVUsRUFBVixHQUFlLFdBQWYsR0FBNkIsTUFBTSxNQUE5QyxDQUFMOztBQUVBLFVBQU8sZUFBUCxHQUF5QjtBQUN4QixRQUFJLEVBRG9CLEVBQ2hCLElBQUksRUFEWSxFQUNSLElBQUksRUFESSxFQUNBLElBQUksRUFESixFQUNRLFFBQVEsS0FBSyxHQUFMLENBQVMsS0FBSyxFQUFkO0FBRGhCLElBQXpCOztBQUlBLFVBQU8sWUFBUCxHQUFzQjtBQUNyQixRQUFJLEVBRGlCLEVBQ2IsSUFBSSxFQURTLEVBQ0wsSUFBSSxFQURDLEVBQ0csSUFBSSxFQURQLEVBQ1csT0FBTyxLQUFLLEVBRHZCLEVBQzJCLFFBQVEsS0FBSztBQUR4QyxJQUF0QjtBQUdBOztBQUdELFFBQU0seUNBQU47O0FBRUEsTUFBSSxLQUFKLEVBQ0MsTUFBTSx5Q0FBTjs7QUFFRCxNQUFJLE1BQUosRUFDQyxPQUFPLHlDQUFQOztBQUdELE1BQUksSUFBSjtBQUNBLE1BQUksSUFBSixDQUFTLENBQVQsRUFBWSxNQUFNLFlBQU4sQ0FBbUIsRUFBL0IsRUFBbUMsTUFBTSxLQUFOLENBQVksS0FBWixHQUFvQixFQUF2RCxFQUEyRCxNQUFNLFlBQU4sQ0FBbUIsTUFBOUU7QUFDQSxNQUFJLElBQUo7O0FBRUEsUUFBTSx5QkFBTjtBQUNBLE1BQUksT0FBSjs7QUFFQSxNQUFJLEtBQUosRUFDQyxNQUFNLHlCQUFOOztBQUVELE1BQUksTUFBSixFQUNDLE9BQU8seUJBQVA7O0FBR0QsUUFBTSxlQUFOO0FBQ0EsTUFBSSxXQUFXLE1BQU0sS0FBTixDQUFZLFFBQTNCOztBQUVBLE1BQUksSUFBSjs7QUFFQSxNQUFJLElBQUosQ0FBUyxTQUFTLEVBQWxCLEVBQXNCLFNBQVMsRUFBL0IsRUFBbUMsS0FBSyxHQUFMLENBQVMsU0FBUyxFQUFULEdBQWMsU0FBUyxFQUFoQyxDQUFuQyxFQUF3RSxLQUFLLEdBQUwsQ0FBUyxTQUFTLEVBQVQsR0FBYyxTQUFTLEVBQWhDLENBQXhFOztBQUVBLE1BQUksSUFBSjs7QUFFQSxRQUFNLCtCQUFOLENBQXNDLE9BQXRDOztBQUVBLE1BQUksS0FBSixFQUNDLE1BQU0sK0JBQU4sQ0FBc0MsT0FBdEM7O0FBRUQsTUFBSSxNQUFKLEVBQ0MsT0FBTywrQkFBUCxDQUF1QyxPQUF2Qzs7QUFHRCxRQUFNLHNCQUFOOztBQUVBLE1BQUksS0FBSixFQUNDLE1BQU0sc0JBQU47O0FBRUQsTUFBSSxNQUFKLEVBQ0MsT0FBTyxzQkFBUDs7QUFFRCxNQUFJLE9BQUo7O0FBR0EsUUFBTSxVQUFOOztBQUVBLE1BQUksS0FBSixFQUNDLE1BQU0sVUFBTjs7QUFFRCxNQUFJLE1BQUosRUFDQyxPQUFPLFVBQVA7O0FBR0QsUUFBTSxjQUFOOztBQUVBLE1BQUksS0FBSixFQUNDLE1BQU0sY0FBTjs7QUFFRCxNQUFJLE1BQUosRUFDQyxPQUFPLGNBQVA7O0FBR0Q7QUFDQSxRQUFNLCtCQUFOLENBQXNDLE9BQXRDOztBQUVBLE1BQUksS0FBSixFQUNDLE1BQU0sK0JBQU4sQ0FBc0MsT0FBdEM7O0FBRUQsTUFBSSxNQUFKLEVBQ0MsT0FBTywrQkFBUCxDQUF1QyxPQUF2QztBQUNELEVBekpELE1BMEpLO0FBQ0osTUFBSSxhQUFhLEtBQUssSUFBTCxDQUFVLE1BQU0sNkJBQU4sRUFBVixDQUFqQjs7QUFFQSxNQUFJLEtBQUosRUFBVztBQUNWLFNBQU0sZUFBTixHQUF3QixFQUF4Qjs7QUFHQSxRQUFLLEtBQUssS0FBTCxDQUFXLFVBQVUsRUFBVixHQUFlLFVBQWYsR0FBNEIsTUFBTSxNQUE3QyxDQUFMO0FBQ0EsUUFBSyxLQUFLLEtBQUwsQ0FBVyxVQUFVLEVBQVYsR0FBZSxNQUFNLEtBQU4sQ0FBWSxLQUFaLEdBQW9CLEVBQW5DLEdBQXdDLE1BQU0sS0FBTixDQUFZLEtBQVosR0FBb0IsRUFBNUQsR0FBaUUsVUFBVSxFQUF0RixDQUFMOztBQUVBLFNBQU0sZUFBTixDQUFzQixFQUF0QixHQUEyQixFQUEzQjtBQUNBLFNBQU0sZUFBTixDQUFzQixFQUF0QixHQUEyQixFQUEzQjtBQUNBLFNBQU0sZUFBTixDQUFzQixLQUF0QixHQUE4QixLQUFLLEdBQUwsQ0FBUyxLQUFLLEVBQWQsQ0FBOUI7QUFDQTs7QUFFRCxNQUFJLE1BQUosRUFBWTtBQUNYLFVBQU8sZUFBUCxHQUF5QixFQUF6QjtBQUVBLFFBQUssS0FBSyxLQUFMLENBQVcsVUFBVSxFQUFWLEdBQWUsVUFBZixHQUE0QixNQUFNLE1BQTdDLENBQUw7QUFDQSxRQUFLLEtBQUssS0FBTCxDQUFXLFVBQVUsRUFBVixHQUFlLE9BQU8sS0FBUCxDQUFhLEtBQWIsR0FBcUIsRUFBcEMsR0FBeUMsT0FBTyxLQUFQLENBQWEsS0FBYixHQUFxQixFQUE5RCxHQUFtRSxVQUFVLEVBQXhGLENBQUw7O0FBRUEsVUFBTyxlQUFQLENBQXVCLEVBQXZCLEdBQTRCLEVBQTVCO0FBQ0EsVUFBTyxlQUFQLENBQXVCLEVBQXZCLEdBQTRCLEVBQTVCO0FBQ0EsVUFBTyxlQUFQLENBQXVCLEtBQXZCLEdBQStCLEtBQUssR0FBTCxDQUFTLEtBQUssRUFBZCxDQUEvQjtBQUNBOztBQUlELE1BQUksY0FBYyxLQUFLLElBQUwsQ0FBVSxRQUFRLE1BQU0sOEJBQU4sRUFBUixHQUFpRCxDQUEzRCxDQUFsQjtBQUNBLE1BQUksZUFBZSxLQUFLLElBQUwsQ0FBVSxTQUFTLE9BQU8sOEJBQVAsRUFBVCxHQUFtRCxDQUE3RCxDQUFuQjs7QUFHQTtBQUNBLE1BQUksS0FBSixFQUFXO0FBQ1Y7QUFDQTs7QUFFQSxRQUFLLEtBQUssS0FBTCxDQUFXLFVBQVUsRUFBVixHQUFlLFdBQWYsR0FBNkIsTUFBTSxNQUE5QyxDQUFMO0FBQ0EsUUFBSyxLQUFLLEtBQUwsQ0FBVyxVQUFVLEVBQVYsR0FBZSxXQUFmLEdBQTZCLE1BQU0sS0FBTixDQUFZLE1BQVosR0FBcUIsRUFBbEQsR0FBdUQsTUFBTSxLQUFOLENBQVksTUFBWixHQUFxQixFQUE1RSxHQUFpRixVQUFVLEVBQVYsR0FBZSxXQUEzRyxDQUFMOztBQUVBO0FBQ0EsU0FBTSxlQUFOLENBQXNCLEVBQXRCLEdBQTJCLEVBQTNCO0FBQ0EsU0FBTSxlQUFOLENBQXNCLEVBQXRCLEdBQTJCLEVBQTNCOztBQUVBLFNBQU0sWUFBTixHQUFxQjtBQUNwQixRQUFJLEVBRGdCLEVBQ1osSUFBSSxFQURRLEVBQ0osSUFBSSxFQURBLEVBQ0ksSUFBSSxFQURSLEVBQ1ksT0FBTyxLQUFLLEVBRHhCLEVBQzRCLFFBQVE7QUFEcEMsSUFBckI7QUFHQTs7QUFFRDtBQUNBLE1BQUksTUFBSixFQUFZO0FBQ1g7QUFDQTs7QUFFQSxRQUFLLEtBQUssS0FBTCxDQUFXLFVBQVUsRUFBVixHQUFlLE9BQU8sTUFBakMsQ0FBTDtBQUNBLFFBQU0sVUFBVSxFQUFWLEdBQWUsT0FBTyxNQUF0QixHQUErQixZQUFyQzs7QUFFQTtBQUNBLFVBQU8sZUFBUCxDQUF1QixFQUF2QixHQUE0QixFQUE1QjtBQUNBLFVBQU8sZUFBUCxDQUF1QixFQUF2QixHQUE0QixFQUE1Qjs7QUFFQSxVQUFPLFlBQVAsR0FBc0I7QUFDckIsUUFBSSxFQURpQixFQUNiLElBQUksRUFEUyxFQUNMLElBQUksRUFEQyxFQUNHLElBQUksRUFEUCxFQUNXLE9BQU8sS0FBSyxFQUR2QixFQUMyQixRQUFRO0FBRG5DLElBQXRCO0FBR0E7O0FBRUQ7QUFDQTs7QUFFQTtBQUNBLE9BQUssS0FBSyxLQUFMLENBQVcsVUFBVSxFQUFWLEdBQWUsTUFBTSxNQUFoQyxDQUFMO0FBQ0EsT0FBSyxLQUFLLEtBQUwsQ0FBVyxTQUFTLE9BQU8sZUFBUCxDQUF1QixFQUFoQyxHQUFzQyxVQUFVLEVBQVYsR0FBZSxFQUFmLEdBQW9CLEVBQXBCLEdBQXlCLFVBQVUsRUFBcEYsQ0FBTDtBQUNBLE9BQUssS0FBSyxLQUFMLENBQVcsVUFBVSxFQUFWLEdBQWUsVUFBZixHQUE0QixNQUFNLE1BQTdDLENBQUw7QUFDQSxPQUFLLEtBQUssS0FBTCxDQUFXLFFBQVEsTUFBTSxlQUFOLENBQXNCLEVBQTlCLEdBQW9DLFVBQVUsRUFBVixHQUFlLFdBQWYsR0FBNkIsTUFBTSxLQUFOLENBQVksTUFBWixHQUFxQixFQUFsRCxHQUF1RCxNQUFNLEtBQU4sQ0FBWSxNQUFaLEdBQXFCLEVBQTVFLEdBQWlGLFVBQVUsRUFBVixHQUFlLFdBQS9JLENBQUw7O0FBR0EsUUFBTSxlQUFOLEdBQXdCO0FBQ3ZCLE9BQUksRUFEbUIsRUFDZixJQUFJLEVBRFcsRUFDUCxJQUFJLEVBREcsRUFDQyxJQUFJLEVBREwsRUFDUyxRQUFRLEtBQUssR0FBTCxDQUFTLEtBQUssRUFBZDtBQURqQixHQUF4Qjs7QUFJQSxRQUFNLFlBQU4sR0FBcUI7QUFDcEIsT0FBSSxFQURnQixFQUNaLElBQUksRUFEUSxFQUNKLElBQUksRUFEQSxFQUNJLElBQUksRUFEUixFQUNZLE9BQU8sS0FBSyxFQUR4QixFQUM0QixRQUFRLEtBQUs7QUFEekMsR0FBckI7O0FBSUE7QUFDQTs7QUFFQSxRQUFNLHlDQUFOOztBQUVBLE1BQUksS0FBSixFQUNDLE1BQU0seUNBQU47QUFDRCxNQUFJLE1BQUosRUFDQyxPQUFPLHlDQUFQOztBQUdEO0FBQ0E7QUFDQTs7QUFFQSxNQUFJLEtBQUosRUFDQyxNQUFNLHlCQUFOOztBQUVELE1BQUksTUFBSixFQUNDLE9BQU8seUJBQVA7O0FBRUQ7O0FBRUEsUUFBTSx5QkFBTjs7QUFFQSxRQUFNLGVBQU47QUFDQSxNQUFJLFdBQVcsTUFBTSxLQUFOLENBQVksUUFBM0I7O0FBRUEsTUFBSSxJQUFKO0FBQ0EsTUFBSSxJQUFKLENBQVMsU0FBUyxFQUFsQixFQUFzQixTQUFTLEVBQS9CLEVBQW1DLEtBQUssR0FBTCxDQUFTLFNBQVMsRUFBVCxHQUFjLFNBQVMsRUFBaEMsQ0FBbkMsRUFBd0UsS0FBSyxHQUFMLENBQVMsU0FBUyxFQUFULEdBQWMsU0FBUyxFQUFoQyxDQUF4RTs7QUFFQSxNQUFJLElBQUo7O0FBR0E7QUFDQSxRQUFNLCtCQUFOLENBQXNDLE9BQXRDOztBQUVBLE1BQUksS0FBSixFQUNDLE1BQU0sK0JBQU4sQ0FBc0MsT0FBdEM7QUFDRCxNQUFJLE1BQUosRUFDQyxPQUFPLCtCQUFQLENBQXVDLE9BQXZDOztBQUVELFFBQU0sc0JBQU47O0FBRUEsTUFBSSxLQUFKLEVBQ0MsTUFBTSxzQkFBTjtBQUNELE1BQUksTUFBSixFQUNDLE9BQU8sc0JBQVA7O0FBRUQsTUFBSSxPQUFKOztBQUdBLFFBQU0sVUFBTjs7QUFHQSxNQUFJLEtBQUosRUFDQyxNQUFNLFVBQU47O0FBRUQsTUFBSSxNQUFKLEVBQ0MsT0FBTyxVQUFQOztBQUdELFFBQU0sY0FBTjs7QUFFQSxNQUFJLEtBQUosRUFDQyxNQUFNLGNBQU47O0FBRUQsTUFBSSxNQUFKLEVBQ0MsT0FBTyxjQUFQOztBQUdELFFBQU0sK0JBQU4sQ0FBc0MsT0FBdEM7O0FBRUEsTUFBSSxLQUFKLEVBQ0MsTUFBTSwrQkFBTixDQUFzQyxPQUF0QztBQUNELE1BQUksTUFBSixFQUNDLE9BQU8sK0JBQVAsQ0FBdUMsT0FBdkM7QUFDRDtBQUVELENBaldEOztBQW1XQSxLQUFLLFNBQUwsQ0FBZSx5QkFBZixHQUEyQyxZQUFZOztBQUV0RCxLQUFJLGFBQWEsS0FBakI7QUFDQSxLQUFJLGtCQUFrQixDQUF0QjtBQUNBLEtBQUksaUJBQWlCLENBQXJCO0FBQ0EsS0FBSSxhQUFhLENBQWpCOztBQUVBLEtBQUksbUJBQW1CLEtBQUssb0JBQUwsQ0FBMEIsWUFBMUIsR0FBeUMsS0FBSyxRQUFyRTs7QUFFQSxLQUFJLEtBQUssVUFBTCxLQUFvQixDQUFwQixJQUF5QixLQUFLLFVBQUwsS0FBb0IsR0FBakQsRUFDQyxpQkFBaUIsR0FBakI7O0FBRUQ7QUFDQSxLQUFJLE9BQVEsS0FBSyxRQUFMLENBQWMsUUFBdEIsS0FBb0MsV0FBeEMsRUFBcUQ7QUFDcEQsTUFBSSxLQUFLLFNBQUwsS0FBbUIsUUFBbkIsSUFBK0IsS0FBSyxTQUFMLEtBQW1CLEtBQXRELEVBQTZEOztBQUU1RDs7QUFFQSxRQUFLLElBQUksQ0FBVCxFQUFZLElBQUksS0FBSyxPQUFMLENBQWEsTUFBN0IsRUFBcUMsR0FBckMsRUFBMEM7QUFDekMsWUFBUSxLQUFLLE9BQUwsQ0FBYSxDQUFiLENBQVI7QUFDQSxRQUFJLE1BQU0sUUFBTixHQUFpQixLQUFLLGVBQXRCLElBQXlDLE1BQU0sU0FBbkQsRUFBNkQ7QUFDNUQ7O0FBRUQsUUFBSSxRQUFRLE1BQU0sU0FBTixDQUFnQixLQUFoQixHQUF3QixLQUFLLEdBQUwsQ0FBUyxLQUFLLEVBQUwsR0FBVSxHQUFWLEdBQWdCLEtBQUssVUFBOUIsQ0FBeEIsR0FBb0UsTUFBTSxTQUFOLENBQWdCLE1BQWhCLEdBQXlCLEtBQUssR0FBTCxDQUFTLEtBQUssRUFBTCxHQUFVLEdBQVYsR0FBZ0IsS0FBSyxVQUE5QixDQUF6Rzs7QUFFQSx1QkFBbUIsS0FBbkI7QUFDQTs7QUFFRCxPQUFJLGtCQUFrQixLQUFLLGVBQUwsQ0FBcUIsS0FBckIsR0FBNkIsY0FBbkQsRUFBbUU7QUFDbEUsaUJBQWEsSUFBYjtBQUNBO0FBQ0QsR0FBQyxJQUFJLEtBQUssU0FBTCxLQUFtQixNQUFuQixJQUE2QixLQUFLLFNBQUwsS0FBbUIsT0FBcEQsRUFBNkQ7QUFDOUQsUUFBSyxJQUFJLENBQVQsRUFBWSxJQUFJLEtBQUssT0FBTCxDQUFhLE1BQTdCLEVBQXFDLEdBQXJDLEVBQTBDO0FBQ3pDLFlBQVEsS0FBSyxPQUFMLENBQWEsQ0FBYixDQUFSO0FBQ0EsUUFBSSxNQUFNLFFBQU4sR0FBaUIsS0FBSyxlQUF0QixJQUF5QyxNQUFNLFNBQW5ELEVBQTZEO0FBQzVEOztBQUVELFFBQUksUUFBUSxNQUFNLFNBQU4sQ0FBZ0IsTUFBaEIsR0FBeUIsS0FBSyxHQUFMLENBQVMsS0FBSyxFQUFMLEdBQVUsR0FBVixHQUFnQixLQUFLLFVBQTlCLENBQXpCLEdBQXFFLE1BQU0sU0FBTixDQUFnQixLQUFoQixHQUF3QixLQUFLLEdBQUwsQ0FBUyxLQUFLLEVBQUwsR0FBVSxHQUFWLEdBQWdCLEtBQUssVUFBOUIsQ0FBekc7O0FBRUEsdUJBQW1CLEtBQW5CO0FBQ0E7O0FBRUQsT0FBSSxrQkFBa0IsS0FBSyxlQUFMLENBQXFCLE1BQXJCLEdBQThCLGNBQXBELEVBQW9FO0FBQ25FLGlCQUFhLElBQWI7QUFDQTtBQUNEO0FBQ0Q7O0FBRUQsS0FBSSxLQUFLLFNBQUwsS0FBbUIsUUFBdkIsRUFBaUM7QUFDaEMsTUFBSSxJQUFJLENBQVI7O0FBRUEsTUFBSSxLQUFKO0FBQ0EsTUFBSSxFQUFKOztBQUVBLE9BQUssSUFBSSxDQUFULEVBQVksSUFBSSxLQUFLLE9BQUwsQ0FBYSxNQUE3QixFQUFxQyxHQUFyQyxFQUEwQzs7QUFFekMsV0FBUSxLQUFLLE9BQUwsQ0FBYSxDQUFiLENBQVI7QUFDQSxPQUFJLE1BQU0sUUFBTixHQUFpQixLQUFLLGVBQXRCLElBQXlDLE1BQU0sUUFBTixHQUFpQixLQUFLLGVBQW5FLEVBQ0M7O0FBRUQsUUFBSyxLQUFLLHlCQUFMLENBQStCLE1BQU0sUUFBckMsQ0FBTDs7QUFFQSxPQUFLLEtBQUssYUFBTCxJQUFzQixDQUFDLEtBQUssT0FBTCxDQUFhLENBQWIsRUFBZ0IsU0FBeEMsSUFBdUQsS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixTQUFoQixJQUE2QixLQUFLLE9BQUwsQ0FBYSxDQUFiLEVBQWdCLFNBQWhCLENBQTBCLGNBQTFCLEtBQTZDLE9BQXJJLEVBQStJOztBQUU5SSxRQUFJLEtBQUssT0FBTCxDQUFhLENBQWIsRUFBZ0IsU0FBcEIsRUFBK0I7QUFDOUIsaUJBQVksS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixTQUE1QjtBQUNBLFVBQUssR0FBTCxDQUFTLFNBQVQsR0FBcUIsVUFBVSxTQUEvQjtBQUNBLFVBQUssR0FBTCxDQUFTLFdBQVQsR0FBdUIsVUFBVSxLQUFqQztBQUVBLEtBTEQsTUFLTztBQUNOLFVBQUssR0FBTCxDQUFTLFNBQVQsR0FBcUIsS0FBSyxhQUExQjtBQUNBLFVBQUssR0FBTCxDQUFTLFdBQVQsR0FBdUIsS0FBSyxTQUE1QjtBQUNBOztBQUdELFFBQUksUUFBUyxLQUFLLEdBQUwsQ0FBUyxTQUFULEdBQXFCLENBQXJCLEtBQTJCLENBQTVCLEdBQWlDLENBQUMsR0FBRyxDQUFILElBQVEsQ0FBVCxJQUFjLEVBQS9DLEdBQXFELEdBQUcsQ0FBSCxJQUFRLENBQXpFO0FBQ0EsU0FBSyxHQUFMLENBQVMsU0FBVDtBQUNBLFNBQUssR0FBTCxDQUFTLE1BQVQsQ0FBZ0IsS0FBaEIsRUFBdUIsR0FBRyxDQUFILElBQVEsQ0FBL0I7QUFDQSxTQUFLLEdBQUwsQ0FBUyxNQUFULENBQWdCLEtBQWhCLEVBQXdCLEdBQUcsQ0FBSCxHQUFPLEtBQUssVUFBYixJQUE0QixDQUFuRDtBQUNBLFNBQUssR0FBTCxDQUFTLE1BQVQ7QUFDQTs7QUFFRDtBQUNBLE9BQUksY0FBYyxlQUFlLENBQWYsS0FBcUIsQ0FBbkMsSUFBd0MsQ0FBQyxLQUFLLE9BQUwsQ0FBYSxDQUFiLEVBQWdCLFNBQTdELEVBQ0M7O0FBRUQsT0FBSSxNQUFNLFNBQU4sQ0FBZ0IsS0FBaEIsS0FBMEIsQ0FBOUIsRUFBaUM7QUFDaEMsT0FBRyxDQUFILElBQVEsTUFBTSxTQUFOLENBQWdCLEtBQWhCLEdBQXdCLENBQWhDO0FBQ0E7QUFDQSxPQUFHLENBQUgsSUFBUSxLQUFLLFVBQUwsR0FBa0IsTUFBTSxTQUFOLENBQWdCLFFBQWhCLEdBQTJCLENBQXJEO0FBRUEsSUFMRCxNQUtPO0FBQ04sT0FBRyxDQUFILElBQVMsS0FBSyxVQUFMLEdBQWtCLENBQWxCLEdBQXVCLE1BQU0sU0FBTixDQUFnQixLQUFoQixHQUF3QixLQUFLLEdBQUwsQ0FBUyxLQUFLLEVBQUwsR0FBVSxHQUFWLEdBQWdCLEtBQUssVUFBOUIsQ0FBL0MsR0FBNEYsQ0FBckc7QUFDQSxPQUFHLENBQUgsSUFBUSxLQUFLLFVBQUwsR0FBa0IsS0FBSyxHQUFMLENBQVUsS0FBSyxVQUFMLEdBQWtCLENBQWxCLEdBQXNCLE1BQU0sU0FBTixDQUFnQixLQUFoQixHQUF3QixLQUFLLEdBQUwsQ0FBUyxLQUFLLEVBQUwsR0FBVSxHQUFWLEdBQWdCLEtBQUssVUFBOUIsQ0FBeEIsR0FBb0UsQ0FBMUYsR0FBOEYsQ0FBeEcsQ0FBMUI7QUFDQTtBQUNELFNBQU0sU0FBTixDQUFnQixDQUFoQixHQUFvQixHQUFHLENBQXZCO0FBQ0EsU0FBTSxTQUFOLENBQWdCLENBQWhCLEdBQW9CLEdBQUcsQ0FBdkI7O0FBRUEsU0FBTSxTQUFOLENBQWdCLE1BQWhCLENBQXVCLElBQXZCO0FBQ0E7O0FBRUQsTUFBSSxLQUFLLEtBQVQsRUFBZ0I7O0FBRWYsUUFBSyxlQUFMLEdBQXVCLElBQUksb0JBQUosQ0FBYyxLQUFLLEdBQW5CLEVBQXdCO0FBQzlDLE9BQUcsS0FBSyxlQUFMLENBQXFCLEVBRHNCLEVBQ25CO0FBQzNCLE9BQUcsS0FBSyxZQUFMLENBQWtCLEVBQWxCLEdBQXVCLEtBQUssYUFBNUIsR0FBNEMsQ0FGRCxFQUVHO0FBQ2pELGNBQVUsS0FBSyxlQUFMLENBQXFCLEtBSGU7QUFJOUMsZUFBVyxLQUFLLGFBQUwsR0FBcUIsR0FKYztBQUs5QyxXQUFPLENBTHVDO0FBTTlDLFVBQU0sS0FBSyxLQU5tQztBQU85QyxxQkFBaUIsUUFQNkIsRUFPcEI7QUFDMUIsY0FBVSxLQUFLLGFBUitCLEVBUWpCO0FBQzdCLGdCQUFZLEtBQUssZUFUNkI7QUFVOUMsZ0JBQVksS0FBSyxlQVY2QixFQVVaO0FBQ2xDLGVBQVcsS0FBSyxjQVg4QjtBQVk5QyxlQUFXLEtBQUssY0FaOEIsRUFZZDtBQUNoQyxrQkFBYztBQWJnQyxJQUF4QixDQUF2Qjs7QUFnQkEsUUFBSyxlQUFMLENBQXFCLFdBQXJCO0FBQ0EsUUFBSyxlQUFMLENBQXFCLENBQXJCLEdBQXlCLEtBQUssZUFBTCxDQUFxQixFQUFyQixHQUEwQixLQUFLLGVBQUwsQ0FBcUIsS0FBckIsR0FBNkIsQ0FBdkQsR0FBMkQsS0FBSyxlQUFMLENBQXFCLEtBQXJCLEdBQTZCLENBQWpIO0FBQ0EsUUFBSyxlQUFMLENBQXFCLENBQXJCLEdBQXlCLEtBQUssWUFBTCxDQUFrQixFQUFsQixHQUF1QixLQUFLLGVBQUwsQ0FBcUIsTUFBNUMsR0FBcUQsQ0FBOUU7QUFDQSxRQUFLLGVBQUwsQ0FBcUIsTUFBckIsQ0FBNEIsSUFBNUI7QUFDQTtBQUNELEVBNUVELE1BNkVLLElBQUksS0FBSyxTQUFMLEtBQW1CLEtBQXZCLEVBQThCO0FBQ2xDLE1BQUksSUFBSSxDQUFSOztBQUVBLE1BQUksS0FBSjtBQUNBLE1BQUksRUFBSjtBQUNBLE1BQUksU0FBSjs7QUFFQSxPQUFLLElBQUksQ0FBVCxFQUFZLElBQUksS0FBSyxPQUFMLENBQWEsTUFBN0IsRUFBcUMsR0FBckMsRUFBMEM7QUFDekMsV0FBUSxLQUFLLE9BQUwsQ0FBYSxDQUFiLENBQVI7QUFDQSxPQUFJLE1BQU0sUUFBTixHQUFpQixLQUFLLGVBQXRCLElBQXlDLE1BQU0sUUFBTixHQUFpQixLQUFLLGVBQW5FLEVBQ0M7O0FBRUQsUUFBSyxLQUFLLHlCQUFMLENBQStCLE1BQU0sUUFBckMsQ0FBTDs7QUFFQSxPQUFLLEtBQUssYUFBTCxJQUFzQixDQUFDLEtBQUssT0FBTCxDQUFhLENBQWIsRUFBZ0IsU0FBeEMsSUFBdUQsS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixTQUFoQixJQUE2QixLQUFLLE9BQUwsQ0FBYSxDQUFiLEVBQWdCLFNBQWhCLENBQTBCLGNBQTFCLEtBQTZDLE9BQXJJLEVBQStJOztBQUc5SSxRQUFJLEtBQUssT0FBTCxDQUFhLENBQWIsRUFBZ0IsU0FBcEIsRUFBK0I7QUFDOUIsaUJBQVksS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixTQUE1Qjs7QUFFQSxVQUFLLEdBQUwsQ0FBUyxTQUFULEdBQXFCLFVBQVUsU0FBL0I7QUFDQSxVQUFLLEdBQUwsQ0FBUyxXQUFULEdBQXVCLFVBQVUsS0FBakM7QUFFQSxLQU5ELE1BTU87QUFDTixVQUFLLEdBQUwsQ0FBUyxTQUFULEdBQXFCLEtBQUssYUFBMUI7QUFDQSxVQUFLLEdBQUwsQ0FBUyxXQUFULEdBQXVCLEtBQUssU0FBNUI7QUFDQTs7QUFFRCxRQUFJLFFBQVMsS0FBSyxHQUFMLENBQVMsU0FBVCxHQUFxQixDQUFyQixLQUEyQixDQUE1QixHQUFpQyxDQUFDLEdBQUcsQ0FBSCxJQUFRLENBQVQsSUFBYyxFQUEvQyxHQUFxRCxHQUFHLENBQUgsSUFBUSxDQUF6RTtBQUNBLFNBQUssR0FBTCxDQUFTLFNBQVQ7QUFDQSxTQUFLLEdBQUwsQ0FBUyxNQUFULENBQWdCLEtBQWhCLEVBQXVCLEdBQUcsQ0FBSCxJQUFRLENBQS9CO0FBQ0EsU0FBSyxHQUFMLENBQVMsTUFBVCxDQUFnQixLQUFoQixFQUF3QixHQUFHLENBQUgsR0FBTyxLQUFLLFVBQWIsSUFBNEIsQ0FBbkQ7QUFDQSxTQUFLLEdBQUwsQ0FBUyxNQUFUO0FBRUE7O0FBRUQ7QUFDQSxPQUFJLGNBQWMsZUFBZSxDQUFmLEtBQXFCLENBQW5DLElBQXdDLENBQUMsS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixTQUE3RCxFQUNDOztBQUVELE9BQUksTUFBTSxTQUFOLENBQWdCLEtBQWhCLEtBQTBCLENBQTlCLEVBQWlDO0FBQ2hDLE9BQUcsQ0FBSCxJQUFRLE1BQU0sU0FBTixDQUFnQixLQUFoQixHQUF3QixDQUFoQztBQUNBLE9BQUcsQ0FBSCxJQUFRLEtBQUssVUFBTCxHQUFrQixNQUFNLFNBQU4sQ0FBZ0IsTUFBaEIsR0FBeUIsQ0FBbkQ7QUFDQSxJQUhELE1BR087QUFDTixPQUFHLENBQUgsSUFBUyxLQUFLLFVBQUwsR0FBa0IsQ0FBbEIsR0FBdUIsTUFBTSxTQUFOLENBQWdCLEtBQWhCLEdBQXdCLEtBQUssR0FBTCxDQUFTLEtBQUssRUFBTCxHQUFVLEdBQVYsR0FBZ0IsS0FBSyxVQUE5QixDQUEvQyxHQUE0RixDQUFyRztBQUNBLE9BQUcsQ0FBSCxJQUFRLEtBQUssVUFBTCxHQUFrQixLQUFLLEdBQUwsQ0FBVSxLQUFLLFVBQUwsR0FBa0IsQ0FBbEIsR0FBc0IsTUFBTSxTQUFOLENBQWdCLEtBQWhCLEdBQXdCLEtBQUssR0FBTCxDQUFTLEtBQUssRUFBTCxHQUFVLEdBQVYsR0FBZ0IsS0FBSyxVQUE5QixDQUF4QixHQUFvRSxDQUExRixHQUE4RixDQUF4RyxDQUExQjtBQUNBO0FBQ0QsU0FBTSxTQUFOLENBQWdCLENBQWhCLEdBQW9CLEdBQUcsQ0FBdkI7QUFDQSxTQUFNLFNBQU4sQ0FBZ0IsQ0FBaEIsR0FBb0IsR0FBRyxDQUF2Qjs7QUFFQSxTQUFNLFNBQU4sQ0FBZ0IsTUFBaEIsQ0FBdUIsSUFBdkI7QUFDQTs7QUFFRCxNQUFJLEtBQUssS0FBVCxFQUFnQjs7QUFFZixRQUFLLGVBQUwsR0FBdUIsSUFBSSxvQkFBSixDQUFjLEtBQUssR0FBbkIsRUFBd0I7QUFDOUMsT0FBRyxLQUFLLGVBQUwsQ0FBcUIsRUFEc0IsRUFDbkI7QUFDM0IsT0FBRyxLQUFLLFlBQUwsQ0FBa0IsRUFBbEIsR0FBdUIsQ0FGb0I7QUFHOUMsY0FBVSxLQUFLLGVBQUwsQ0FBcUIsS0FIZTtBQUk5QyxlQUFXLEtBQUssYUFBTCxHQUFxQixHQUpjO0FBSzlDLFdBQU8sQ0FMdUM7QUFNOUMsVUFBTSxLQUFLLEtBTm1DO0FBTzlDLHFCQUFpQixRQVA2QixFQU9wQjtBQUMxQixjQUFVLEtBQUssYUFSK0IsRUFRakI7QUFDN0IsZ0JBQVksS0FBSyxlQVQ2QjtBQVU5QyxnQkFBWSxLQUFLLGVBVjZCLEVBVVo7QUFDbEMsZUFBVyxLQUFLLGNBWDhCO0FBWTlDLGVBQVcsS0FBSyxjQVo4QixFQVlkO0FBQ2hDLGtCQUFjO0FBYmdDLElBQXhCLENBQXZCOztBQWdCQSxRQUFLLGVBQUwsQ0FBcUIsV0FBckI7QUFDQSxRQUFLLGVBQUwsQ0FBcUIsQ0FBckIsR0FBeUIsS0FBSyxlQUFMLENBQXFCLEVBQXJCLEdBQTBCLEtBQUssZUFBTCxDQUFxQixLQUFyQixHQUE2QixDQUF2RCxHQUEyRCxLQUFLLGVBQUwsQ0FBcUIsS0FBckIsR0FBNkIsQ0FBakg7QUFDQSxRQUFLLGVBQUwsQ0FBcUIsTUFBckIsQ0FBNEIsSUFBNUI7QUFDQTtBQUNELEVBM0VJLE1BNEVBLElBQUksS0FBSyxTQUFMLEtBQW1CLE1BQXZCLEVBQStCOztBQUduQyxNQUFJLEtBQUo7QUFDQSxNQUFJLEVBQUo7QUFDQSxPQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksS0FBSyxPQUFMLENBQWEsTUFBakMsRUFBeUMsR0FBekMsRUFBOEM7QUFDN0MsV0FBUSxLQUFLLE9BQUwsQ0FBYSxDQUFiLENBQVI7QUFDQSxPQUFJLE1BQU0sUUFBTixHQUFpQixLQUFLLGVBQXRCLElBQXlDLE1BQU0sUUFBTixHQUFpQixLQUFLLGVBQW5FLEVBQ0M7O0FBRUQsUUFBSyxLQUFLLHlCQUFMLENBQStCLE1BQU0sUUFBckMsQ0FBTDs7QUFFQSxPQUFLLEtBQUssYUFBTCxJQUFzQixDQUFDLEtBQUssT0FBTCxDQUFhLENBQWIsRUFBZ0IsU0FBeEMsSUFBdUQsS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixTQUFoQixJQUE2QixLQUFLLE9BQUwsQ0FBYSxDQUFiLEVBQWdCLFNBQWhCLENBQTBCLGNBQTFCLEtBQTZDLE9BQXJJLEVBQStJOztBQUU5SSxRQUFJLEtBQUssT0FBTCxDQUFhLENBQWIsRUFBZ0IsU0FBcEIsRUFBK0I7QUFDOUIsaUJBQVksS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixTQUE1Qjs7QUFFQSxVQUFLLEdBQUwsQ0FBUyxTQUFULEdBQXFCLFVBQVUsU0FBL0I7QUFDQSxVQUFLLEdBQUwsQ0FBUyxXQUFULEdBQXVCLFVBQVUsS0FBakM7QUFDQSxLQUxELE1BS087QUFDTixVQUFLLEdBQUwsQ0FBUyxTQUFULEdBQXFCLEtBQUssYUFBMUI7QUFDQSxVQUFLLEdBQUwsQ0FBUyxXQUFULEdBQXVCLEtBQUssU0FBNUI7QUFDQTs7QUFFRCxRQUFJLFFBQVMsS0FBSyxHQUFMLENBQVMsU0FBVCxHQUFxQixDQUFyQixLQUEyQixDQUE1QixHQUFpQyxDQUFDLEdBQUcsQ0FBSCxJQUFRLENBQVQsSUFBYyxFQUEvQyxHQUFxRCxHQUFHLENBQUgsSUFBUSxDQUF6RTtBQUNBLFNBQUssR0FBTCxDQUFTLFNBQVQ7QUFDQSxTQUFLLEdBQUwsQ0FBUyxNQUFULENBQWdCLEdBQUcsQ0FBSCxJQUFRLENBQXhCLEVBQTJCLEtBQTNCO0FBQ0EsU0FBSyxHQUFMLENBQVMsTUFBVCxDQUFpQixHQUFHLENBQUgsR0FBTyxLQUFLLFVBQWIsSUFBNEIsQ0FBNUMsRUFBK0MsS0FBL0M7QUFDQSxTQUFLLEdBQUwsQ0FBUyxNQUFUO0FBQ0E7O0FBRUQ7QUFDQSxPQUFJLGNBQWMsZUFBZSxDQUFmLEtBQXFCLENBQW5DLElBQXdDLENBQUMsS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixTQUE3RCxFQUNDOztBQUVELFNBQU0sU0FBTixDQUFnQixDQUFoQixHQUFvQixHQUFHLENBQUgsR0FBUSxNQUFNLFNBQU4sQ0FBZ0IsS0FBaEIsR0FBd0IsS0FBSyxHQUFMLENBQVMsS0FBSyxFQUFMLEdBQVUsR0FBVixHQUFnQixLQUFLLFVBQTlCLENBQWhDLEdBQTZFLEtBQUssVUFBbEYsR0FBK0YsQ0FBbkg7O0FBRUEsT0FBSSxLQUFLLFVBQUwsS0FBb0IsQ0FBeEIsRUFBMkI7QUFDMUIsVUFBTSxTQUFOLENBQWdCLENBQWhCLEdBQW9CLEdBQUcsQ0FBdkI7QUFDQSxJQUZELE1BR0MsTUFBTSxTQUFOLENBQWdCLENBQWhCLEdBQW9CLEdBQUcsQ0FBSCxHQUFRLE1BQU0sU0FBTixDQUFnQixLQUFoQixHQUF3QixLQUFLLEdBQUwsQ0FBUyxLQUFLLEVBQUwsR0FBVSxHQUFWLEdBQWdCLEtBQUssVUFBOUIsQ0FBcEQ7O0FBRUQsU0FBTSxTQUFOLENBQWdCLE1BQWhCLENBQXVCLElBQXZCO0FBQ0E7O0FBRUQsTUFBSSxLQUFLLEtBQVQsRUFBZ0I7O0FBRWYsUUFBSyxlQUFMLEdBQXVCLElBQUksb0JBQUosQ0FBYyxLQUFLLEdBQW5CLEVBQXdCO0FBQzlDLE9BQUcsS0FBSyxZQUFMLENBQWtCLEVBQWxCLEdBQXVCLENBRG9CO0FBRTlDLE9BQUcsS0FBSyxlQUFMLENBQXFCLEVBRnNCO0FBRzlDLGNBQVUsS0FBSyxlQUFMLENBQXFCLE1BSGU7QUFJOUMsZUFBVyxLQUFLLGFBQUwsR0FBcUIsR0FKYztBQUs5QyxXQUFPLENBQUMsRUFMc0M7QUFNOUMsVUFBTSxLQUFLLEtBTm1DO0FBTzlDLHFCQUFpQixRQVA2QixFQU9wQjtBQUMxQixjQUFVLEtBQUssYUFSK0IsRUFRakI7QUFDN0IsZ0JBQVksS0FBSyxlQVQ2QjtBQVU5QyxnQkFBWSxLQUFLLGVBVjZCLEVBVVo7QUFDbEMsZUFBVyxLQUFLLGNBWDhCO0FBWTlDLGVBQVcsS0FBSyxjQVo4QixFQVlkO0FBQ2hDLGtCQUFjO0FBYmdDLElBQXhCLENBQXZCOztBQWdCQSxPQUFJLE9BQU8sS0FBSyxlQUFMLENBQXFCLFdBQXJCLEVBQVg7O0FBRUE7O0FBRUEsUUFBSyxlQUFMLENBQXFCLENBQXJCLEdBQTBCLEtBQUssZUFBTCxDQUFxQixNQUFyQixHQUE4QixDQUE5QixHQUFrQyxLQUFLLGVBQUwsQ0FBcUIsS0FBckIsR0FBNkIsQ0FBL0QsR0FBbUUsS0FBSyxlQUFMLENBQXFCLEVBQWxIO0FBQ0EsUUFBSyxlQUFMLENBQXFCLE1BQXJCLENBQTRCLElBQTVCOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBRUE7QUFDRCxFQWhGSSxNQWlGQSxJQUFJLEtBQUssU0FBTCxLQUFtQixPQUF2QixFQUFnQzs7QUFHcEMsTUFBSSxLQUFKO0FBQ0EsTUFBSSxFQUFKOztBQUVBLE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxLQUFLLE9BQUwsQ0FBYSxNQUFqQyxFQUF5QyxHQUF6QyxFQUE4QztBQUM3QyxXQUFRLEtBQUssT0FBTCxDQUFhLENBQWIsQ0FBUjtBQUNBLE9BQUksTUFBTSxRQUFOLEdBQWlCLEtBQUssZUFBdEIsSUFBeUMsTUFBTSxRQUFOLEdBQWlCLEtBQUssZUFBbkUsRUFDQzs7QUFFRCxRQUFLLEtBQUsseUJBQUwsQ0FBK0IsTUFBTSxRQUFyQyxDQUFMOztBQUVBLE9BQUssS0FBSyxhQUFMLElBQXNCLENBQUMsS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixTQUF4QyxJQUF1RCxLQUFLLE9BQUwsQ0FBYSxDQUFiLEVBQWdCLFNBQWhCLElBQTZCLEtBQUssT0FBTCxDQUFhLENBQWIsRUFBZ0IsU0FBaEIsQ0FBMEIsY0FBMUIsS0FBNkMsT0FBckksRUFBK0k7O0FBRTlJLFFBQUksS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixTQUFwQixFQUErQjtBQUM5QixpQkFBWSxLQUFLLE9BQUwsQ0FBYSxDQUFiLEVBQWdCLFNBQTVCOztBQUVBLFVBQUssR0FBTCxDQUFTLFNBQVQsR0FBcUIsVUFBVSxTQUEvQjtBQUNBLFVBQUssR0FBTCxDQUFTLFdBQVQsR0FBdUIsVUFBVSxLQUFqQztBQUNBLEtBTEQsTUFLTztBQUNOLFVBQUssR0FBTCxDQUFTLFNBQVQsR0FBcUIsS0FBSyxhQUExQjtBQUNBLFVBQUssR0FBTCxDQUFTLFdBQVQsR0FBdUIsS0FBSyxTQUE1QjtBQUNBOztBQUVELFFBQUksUUFBUyxLQUFLLEdBQUwsQ0FBUyxTQUFULEdBQXFCLENBQXJCLEtBQTJCLENBQTVCLEdBQWlDLENBQUMsR0FBRyxDQUFILElBQVEsQ0FBVCxJQUFjLEVBQS9DLEdBQXFELEdBQUcsQ0FBSCxJQUFRLENBQXpFO0FBQ0EsU0FBSyxHQUFMLENBQVMsU0FBVDtBQUNBLFNBQUssR0FBTCxDQUFTLE1BQVQsQ0FBZ0IsR0FBRyxDQUFILElBQVEsQ0FBeEIsRUFBMkIsS0FBM0I7QUFDQSxTQUFLLEdBQUwsQ0FBUyxNQUFULENBQWlCLEdBQUcsQ0FBSCxHQUFPLEtBQUssVUFBYixJQUE0QixDQUE1QyxFQUErQyxLQUEvQztBQUNBLFNBQUssR0FBTCxDQUFTLE1BQVQ7QUFFQTs7QUFFRDtBQUNBLE9BQUksY0FBYyxlQUFlLENBQWYsS0FBcUIsQ0FBbkMsSUFBd0MsQ0FBQyxLQUFLLE9BQUwsQ0FBYSxDQUFiLEVBQWdCLFNBQTdELEVBQ0M7O0FBRUQsU0FBTSxTQUFOLENBQWdCLENBQWhCLEdBQW9CLEdBQUcsQ0FBSCxHQUFPLEtBQUssVUFBWixHQUF5QixDQUE3QztBQUNBO0FBQ0EsT0FBSSxLQUFLLFVBQUwsS0FBb0IsQ0FBeEIsRUFBMkI7QUFDMUIsVUFBTSxTQUFOLENBQWdCLENBQWhCLEdBQW9CLEdBQUcsQ0FBdkI7QUFDQSxJQUZELE1BSUMsTUFBTSxTQUFOLENBQWdCLENBQWhCLEdBQW9CLEdBQUcsQ0FBdkI7O0FBRUQsU0FBTSxTQUFOLENBQWdCLE1BQWhCLENBQXVCLElBQXZCO0FBQ0E7O0FBRUQsTUFBSSxLQUFLLEtBQVQsRUFBZ0I7O0FBRWYsUUFBSyxlQUFMLEdBQXVCLElBQUksb0JBQUosQ0FBYyxLQUFLLEdBQW5CLEVBQXdCO0FBQzlDLE9BQUcsS0FBSyxZQUFMLENBQWtCLEVBQWxCLEdBQXVCLENBRG9CO0FBRTlDLE9BQUcsS0FBSyxlQUFMLENBQXFCLEVBRnNCO0FBRzlDLGNBQVUsS0FBSyxlQUFMLENBQXFCLE1BSGU7QUFJOUMsZUFBVyxLQUFLLGFBQUwsR0FBcUIsR0FKYztBQUs5QyxXQUFPLEVBTHVDO0FBTTlDLFVBQU0sS0FBSyxLQU5tQztBQU85QyxxQkFBaUIsUUFQNkIsRUFPcEI7QUFDMUIsY0FBVSxLQUFLLGFBUitCLEVBUWpCO0FBQzdCLGdCQUFZLEtBQUssZUFUNkI7QUFVOUMsZ0JBQVksS0FBSyxlQVY2QixFQVVaO0FBQ2xDLGVBQVcsS0FBSyxjQVg4QjtBQVk5QyxlQUFXLEtBQUssY0FaOEIsRUFZZDtBQUNoQyxrQkFBYztBQWJnQyxJQUF4QixDQUF2Qjs7QUFnQkEsUUFBSyxlQUFMLENBQXFCLFdBQXJCO0FBQ0EsUUFBSyxlQUFMLENBQXFCLENBQXJCLEdBQTBCLEtBQUssZUFBTCxDQUFxQixNQUFyQixHQUE4QixDQUE5QixHQUFrQyxLQUFLLGVBQUwsQ0FBcUIsS0FBckIsR0FBNkIsQ0FBL0QsR0FBbUUsS0FBSyxlQUFMLENBQXFCLEVBQWxIO0FBQ0EsUUFBSyxlQUFMLENBQXFCLE1BQXJCLENBQTRCLElBQTVCO0FBRUE7QUFDRDtBQUNELENBbFdEOztBQW9XQSxLQUFLLFNBQUwsQ0FBZSxzQkFBZixHQUF3QyxZQUFZO0FBQ25ELEtBQUksTUFBTSxLQUFLLEtBQUwsQ0FBVyxRQUFYLENBQW9CLEdBQTlCO0FBQ0E7O0FBRUEsS0FBSSx3QkFBSjtBQUNBLEtBQUksc0JBQUo7QUFDQSxLQUFJLHNCQUFzQixLQUFLLEtBQUwsQ0FBVyxRQUFyQztBQUNBLEtBQUksSUFBSSxDQUFSO0FBQUEsS0FBVyx1QkFBdUIsSUFBbEM7O0FBRUEsS0FBSSxDQUFDLEtBQUssU0FBTCxLQUFtQixRQUFuQixJQUErQixLQUFLLFNBQUwsS0FBbUIsS0FBbkQsS0FBNkQsS0FBSyxlQUF0RSxFQUF1Rjs7QUFFdEYsTUFBSSxTQUFKLEdBQWdCLEtBQUssZUFBckI7O0FBRUEsT0FBSyxJQUFJLENBQVQsRUFBWSxJQUFJLEtBQUssT0FBTCxDQUFhLE1BQTdCLEVBQXFDLEdBQXJDLEVBQTBDOztBQUV6QyxPQUFJLEtBQUssT0FBTCxDQUFhLENBQWIsRUFBZ0IsU0FBcEIsRUFDQzs7QUFFRCxPQUFJLG9CQUFKLEVBQTBCO0FBQUM7QUFDMUIsK0JBQTJCLEtBQUsseUJBQUwsQ0FBK0IsS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixRQUEvQyxDQUEzQjs7QUFFQSxRQUFJLElBQUksQ0FBSixJQUFTLEtBQUssT0FBTCxDQUFhLE1BQWIsR0FBc0IsQ0FBbkMsRUFDQyx5QkFBeUIsS0FBSyx5QkFBTCxDQUErQixLQUFLLGVBQXBDLENBQXpCLENBREQsS0FHQyx5QkFBeUIsS0FBSyx5QkFBTCxDQUErQixLQUFLLE9BQUwsQ0FBYSxJQUFJLENBQWpCLEVBQW9CLFFBQW5ELENBQXpCOztBQUVELFFBQUksUUFBSixDQUFhLHlCQUF5QixDQUF0QyxFQUF5QyxvQkFBb0IsRUFBN0QsRUFBaUUsS0FBSyxHQUFMLENBQVMsdUJBQXVCLENBQXZCLEdBQTJCLHlCQUF5QixDQUE3RCxDQUFqRSxFQUFrSSxLQUFLLEdBQUwsQ0FBUyxvQkFBb0IsRUFBcEIsR0FBeUIsb0JBQW9CLEVBQXRELENBQWxJO0FBQ0EsMkJBQXVCLEtBQXZCO0FBQ0EsSUFWRCxNQVdDLHVCQUF1QixJQUF2QjtBQUVEO0FBRUQsRUF4QkQsTUF3Qk8sSUFBSSxDQUFDLEtBQUssU0FBTCxLQUFtQixNQUFuQixJQUE2QixLQUFLLFNBQUwsS0FBbUIsT0FBakQsS0FBNkQsS0FBSyxlQUF0RSxFQUF1Rjs7QUFFN0YsTUFBSSxTQUFKLEdBQWdCLEtBQUssZUFBckI7O0FBRUEsT0FBSyxJQUFJLENBQVQsRUFBWSxJQUFJLEtBQUssT0FBTCxDQUFhLE1BQTdCLEVBQXFDLEdBQXJDLEVBQTBDO0FBQ2xDLE9BQUksS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixTQUFwQixFQUNJOztBQUVYLE9BQUksb0JBQUosRUFBMEI7QUFBQzs7QUFFMUIsNkJBQXlCLEtBQUsseUJBQUwsQ0FBK0IsS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixRQUEvQyxDQUF6Qjs7QUFFQSxRQUFJLElBQUksQ0FBSixJQUFTLEtBQUssT0FBTCxDQUFhLE1BQWIsR0FBc0IsQ0FBbkMsRUFDQywyQkFBMkIsS0FBSyx5QkFBTCxDQUErQixLQUFLLGVBQXBDLENBQTNCLENBREQsS0FHQywyQkFBMkIsS0FBSyx5QkFBTCxDQUErQixLQUFLLE9BQUwsQ0FBYSxJQUFJLENBQWpCLEVBQW9CLFFBQW5ELENBQTNCOztBQUVELFFBQUksUUFBSixDQUFhLG9CQUFvQixFQUFqQyxFQUFxQyx5QkFBeUIsQ0FBOUQsRUFBaUUsS0FBSyxHQUFMLENBQVMsb0JBQW9CLEVBQXBCLEdBQXlCLG9CQUFvQixFQUF0RCxDQUFqRSxFQUE0SCxLQUFLLEdBQUwsQ0FBUyx5QkFBeUIsQ0FBekIsR0FBNkIsdUJBQXVCLENBQTdELENBQTVIO0FBQ0EsMkJBQXVCLEtBQXZCO0FBQ0EsSUFYRCxNQVlDLHVCQUF1QixJQUF2QjtBQUNEO0FBQ0c7QUFDSjs7QUFFRCxLQUFJLFNBQUo7QUFDQSxDQTNERDs7QUE2REE7QUFDQSxLQUFLLFNBQUwsQ0FBZSwrQkFBZixHQUFpRCxVQUFVLGFBQVYsRUFBeUI7O0FBRXpFLEtBQUksRUFBRSxLQUFLLFVBQUwsSUFBbUIsS0FBSyxVQUFMLENBQWdCLE1BQWhCLEdBQXlCLENBQTlDLEtBQW9ELENBQUMsYUFBekQsRUFDQzs7QUFFRCxLQUFJLFFBQVEsSUFBWjs7QUFFQSxLQUFJLElBQUksQ0FBUjtBQUNBLE1BQUssSUFBSSxDQUFULEVBQVksSUFBSSxLQUFLLFVBQUwsQ0FBZ0IsTUFBaEMsRUFBd0MsR0FBeEMsRUFBNkM7O0FBRTVDLE1BQUksWUFBWSxLQUFLLFVBQUwsQ0FBZ0IsQ0FBaEIsQ0FBaEI7O0FBRUEsTUFBSSxVQUFVLGNBQVYsS0FBNkIsYUFBakMsRUFDQzs7QUFHRDtBQUNBLE1BQUksa0JBQWtCLE9BQWxCLEtBQThCLFVBQVUsS0FBVixHQUFrQixLQUFLLGVBQXZCLElBQTBDLFVBQVUsS0FBVixHQUFrQixLQUFLLGVBQS9GLENBQUosRUFDQzs7QUFFRCxNQUFJLFVBQVUsU0FBZCxFQUF5QjtBQUN4QixRQUFLLEtBQUwsQ0FBVyxnQkFBWCxDQUE0QiwyQkFBNUIsRUFBeUQsVUFBVSxNQUFuRSxFQUEyRSxTQUEzRTtBQUNBLEdBRkQsTUFJQyxVQUFVLE1BQVY7QUFDRDtBQUNELENBMUJEOztBQTRCQSxLQUFLLFNBQUwsQ0FBZSxVQUFmLEdBQTRCLFlBQVk7O0FBRXZDLEtBQUksRUFBRSxLQUFLLGFBQUwsSUFBc0IsS0FBSyxhQUFMLEdBQXFCLENBQTdDLENBQUosRUFDQzs7QUFFRDtBQUNBLEtBQUksTUFBTSxLQUFLLEtBQUwsQ0FBVyxHQUFyQjs7QUFFQSxLQUFJLEVBQUo7QUFDQSxLQUFJLHNCQUFzQixLQUFLLEtBQUwsQ0FBVyxRQUFyQztBQUNBLEtBQUksU0FBSjtBQUNBLEtBQUksYUFBSixFQUFtQixlQUFuQjtBQUNBOztBQUVBLEtBQUksU0FBSixHQUFnQixLQUFLLGFBQXJCO0FBQ0EsS0FBSSxXQUFKLEdBQWtCLEtBQUssU0FBdkI7O0FBRUEsS0FBSSxJQUFJLFdBQVIsRUFBcUI7QUFDcEIsTUFBSSxXQUFKLENBQWdCLDZCQUFpQixLQUFLLFlBQXRCLEVBQW9DLEtBQUssYUFBekMsQ0FBaEI7QUFDQTs7QUFHRCxLQUFJLEtBQUssU0FBTCxLQUFtQixRQUFuQixJQUErQixLQUFLLFNBQUwsS0FBbUIsS0FBdEQsRUFBNkQ7O0FBRTVELE9BQUssSUFBSSxDQUFULEVBQVksSUFBSSxLQUFLLE9BQUwsQ0FBYSxNQUFqQixJQUEyQixDQUFDLEtBQUssT0FBTCxDQUFhLENBQWIsRUFBZ0IsU0FBeEQsRUFBbUUsR0FBbkUsRUFBd0U7O0FBRXZFLE9BQUksS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixRQUFoQixHQUEyQixLQUFLLGVBQWhDLElBQW1ELEtBQUssT0FBTCxDQUFhLENBQWIsRUFBZ0IsUUFBaEIsR0FBMkIsS0FBSyxlQUF2RixFQUNDOztBQUVELE9BQUksU0FBSjs7QUFFQSxRQUFLLEtBQUsseUJBQUwsQ0FBK0IsS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixRQUEvQyxDQUFMOztBQUVBLE9BQUksUUFBUyxJQUFJLFNBQUosR0FBZ0IsQ0FBaEIsS0FBc0IsQ0FBdkIsR0FBNEIsQ0FBQyxHQUFHLENBQUgsSUFBUSxDQUFULElBQWMsRUFBMUMsR0FBZ0QsR0FBRyxDQUFILElBQVEsQ0FBcEU7O0FBRUEsT0FBSSxNQUFKLENBQVcsS0FBWCxFQUFrQixvQkFBb0IsRUFBcEIsSUFBMEIsQ0FBNUM7QUFDQSxPQUFJLE1BQUosQ0FBVyxLQUFYLEVBQWtCLG9CQUFvQixFQUFwQixJQUEwQixDQUE1Qzs7QUFFQSxPQUFJLE1BQUo7QUFDQTtBQUVELEVBbkJELE1Bb0JLLElBQUksS0FBSyxTQUFMLEtBQW1CLE1BQW5CLElBQTZCLEtBQUssU0FBTCxLQUFtQixPQUFwRCxFQUE2RDs7QUFFakUsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEtBQUssT0FBTCxDQUFhLE1BQWpCLElBQTJCLENBQUMsS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixTQUE1RCxFQUF1RSxHQUF2RSxFQUE0RTs7QUFFM0UsT0FBSSxNQUFNLENBQU4sSUFBVyxLQUFLLElBQUwsS0FBYyxPQUF6QixJQUFvQyxLQUFLLEtBQUwsQ0FBVyxLQUEvQyxJQUF3RCxLQUFLLEtBQUwsQ0FBVyxLQUFYLENBQWlCLGFBQTdFLEVBQ0M7O0FBRUQsT0FBSSxLQUFLLE9BQUwsQ0FBYSxDQUFiLEVBQWdCLFFBQWhCLEdBQTJCLEtBQUssZUFBaEMsSUFBbUQsS0FBSyxPQUFMLENBQWEsQ0FBYixFQUFnQixRQUFoQixHQUEyQixLQUFLLGVBQXZGLEVBQ0M7O0FBRUQsT0FBSSxTQUFKOztBQUVBLFFBQUssS0FBSyx5QkFBTCxDQUErQixLQUFLLE9BQUwsQ0FBYSxDQUFiLEVBQWdCLFFBQS9DLENBQUw7O0FBRUEsT0FBSSxRQUFTLElBQUksU0FBSixHQUFnQixDQUFoQixLQUFzQixDQUF2QixHQUE0QixDQUFDLEdBQUcsQ0FBSCxJQUFRLENBQVQsSUFBYyxFQUExQyxHQUFnRCxHQUFHLENBQUgsSUFBUSxDQUFwRTs7QUFFQSxPQUFJLE1BQUosQ0FBVyxvQkFBb0IsRUFBcEIsSUFBMEIsQ0FBckMsRUFBd0MsS0FBeEM7QUFDQSxPQUFJLE1BQUosQ0FBVyxvQkFBb0IsRUFBcEIsSUFBMEIsQ0FBckMsRUFBd0MsS0FBeEM7O0FBRUEsT0FBSSxNQUFKO0FBQ0E7QUFFRDtBQUNELENBakVEOztBQW1FQSxLQUFLLFNBQUwsQ0FBZSxjQUFmLEdBQWdDLFlBQVk7QUFDM0M7QUFDQSxLQUFJLE1BQU0sS0FBSyxLQUFMLENBQVcsR0FBckI7O0FBRUEsS0FBSSxLQUFLLFNBQUwsS0FBbUIsUUFBbkIsSUFBK0IsS0FBSyxTQUFMLEtBQW1CLEtBQXRELEVBQTZEO0FBQzVELE1BQUksS0FBSyxhQUFULEVBQXdCO0FBQ3ZCLE9BQUksU0FBSixHQUFnQixLQUFLLGFBQXJCO0FBQ0EsT0FBSSxXQUFKLEdBQWtCLEtBQUssU0FBTCxHQUFpQixLQUFLLFNBQXRCLEdBQWtDLE9BQXBEOztBQUVBLE9BQUksSUFBSSxXQUFSLEVBQXFCO0FBQ3BCLFFBQUksV0FBSixDQUFnQiw2QkFBaUIsS0FBSyxZQUF0QixFQUFvQyxLQUFLLGFBQXpDLENBQWhCO0FBQ0E7O0FBRUQsT0FBSSxRQUFTLEtBQUssYUFBTCxHQUFxQixDQUFyQixLQUEyQixDQUE1QixHQUFpQyxDQUFDLEtBQUssZUFBTCxDQUFxQixFQUFyQixJQUEyQixDQUE1QixJQUFpQyxFQUFsRSxHQUF3RSxLQUFLLGVBQUwsQ0FBcUIsRUFBckIsSUFBMkIsQ0FBL0c7O0FBRUEsT0FBSSxTQUFKO0FBQ0EsT0FBSSxNQUFKLENBQVcsS0FBSyxlQUFMLENBQXFCLEVBQWhDLEVBQW9DLEtBQXBDO0FBQ0EsT0FBSSxNQUFKLENBQVcsS0FBSyxlQUFMLENBQXFCLEVBQWhDLEVBQW9DLEtBQXBDO0FBQ0EsT0FBSSxNQUFKO0FBQ0E7QUFFRCxFQWpCRCxNQWlCTyxJQUFJLEtBQUssU0FBTCxLQUFtQixNQUFuQixJQUE2QixLQUFLLFNBQUwsS0FBbUIsT0FBcEQsRUFBNkQ7QUFDbkUsTUFBSSxLQUFLLGFBQVQsRUFBd0I7QUFDdkIsT0FBSSxTQUFKLEdBQWdCLEtBQUssYUFBckI7QUFDQSxPQUFJLFdBQUosR0FBa0IsS0FBSyxTQUF2Qjs7QUFFQSxPQUFJLElBQUksV0FBUixFQUFxQjtBQUNwQixRQUFJLFdBQUosQ0FBZ0IsNkJBQWlCLEtBQUssWUFBdEIsRUFBb0MsS0FBSyxhQUF6QyxDQUFoQjtBQUNBOztBQUVELE9BQUksUUFBUyxLQUFLLGFBQUwsR0FBcUIsQ0FBckIsS0FBMkIsQ0FBNUIsR0FBaUMsQ0FBQyxLQUFLLGVBQUwsQ0FBcUIsRUFBckIsSUFBMkIsQ0FBNUIsSUFBaUMsRUFBbEUsR0FBd0UsS0FBSyxlQUFMLENBQXFCLEVBQXJCLElBQTJCLENBQS9HOztBQUVBLE9BQUksU0FBSjtBQUNBLE9BQUksTUFBSixDQUFXLEtBQVgsRUFBa0IsS0FBSyxlQUFMLENBQXFCLEVBQXZDO0FBQ0EsT0FBSSxNQUFKLENBQVcsS0FBWCxFQUFrQixLQUFLLGVBQUwsQ0FBcUIsRUFBdkM7QUFDQSxPQUFJLE1BQUo7QUFDQTtBQUNEO0FBQ0QsQ0F0Q0Q7O0FBd0NBLEtBQUssU0FBTCxDQUFlLHlCQUFmLEdBQTJDLFVBQVUsS0FBVixFQUFpQjtBQUMzRCxLQUFJLEtBQUssRUFBVDtBQUVBLEtBQUksUUFBUSxLQUFLLGVBQUwsQ0FBcUIsS0FBakM7QUFDQSxLQUFJLFNBQVMsS0FBSyxlQUFMLENBQXFCLE1BQWxDOztBQUVBLEtBQUksS0FBSyxTQUFMLEtBQW1CLFFBQW5CLElBQStCLEtBQUssU0FBTCxLQUFtQixLQUF0RCxFQUE2RDtBQUM1RDtBQUNBLE1BQUksZUFBZSxLQUFLLG9CQUFMLENBQTBCLFlBQTdDOztBQUVBO0FBQ0EsS0FBRyxDQUFILEdBQU8sS0FBSyxvQkFBTCxDQUEwQixTQUExQixHQUF1QyxnQkFBZ0IsUUFBUSxLQUFLLGVBQTdCLENBQTlDO0FBQ0EsS0FBRyxDQUFILEdBQU8sS0FBSyxlQUFMLENBQXFCLEVBQTVCO0FBQ0E7QUFDRCxLQUFJLEtBQUssU0FBTCxLQUFtQixNQUFuQixJQUE2QixLQUFLLFNBQUwsS0FBbUIsT0FBcEQsRUFBNkQ7QUFDNUQ7QUFDQSxNQUFJLGVBQWUsQ0FBQyxLQUFLLG9CQUFMLENBQTBCLFlBQTlDOztBQUVBO0FBQ0EsS0FBRyxDQUFILEdBQU8sS0FBSyxvQkFBTCxDQUEwQixTQUExQixHQUF1QyxnQkFBZ0IsUUFBUSxLQUFLLGVBQTdCLENBQTlDO0FBQ0EsS0FBRyxDQUFILEdBQU8sS0FBSyxlQUFMLENBQXFCLEVBQTVCO0FBQ0E7O0FBRUQsUUFBTyxFQUFQO0FBQ0EsQ0F4QkQ7O0FBMEJBLEtBQUssU0FBTCxDQUFlLG1CQUFmLEdBQXFDLFVBQVUsS0FBVixFQUFpQjs7QUFFckQsS0FBSSxDQUFDLEtBQUwsRUFDQyxPQUFPLElBQVA7O0FBRUQsS0FBSSxRQUFRLENBQVo7QUFDQSxLQUFJLElBQUssS0FBSyxTQUFMLEtBQW1CLE1BQW5CLElBQTZCLEtBQUssU0FBTCxLQUFtQixPQUFqRCxHQUE0RCxNQUFNLENBQWxFLEdBQXNFLE1BQU0sQ0FBcEY7O0FBRUEsU0FBUSxLQUFLLG9CQUFMLENBQTBCLE9BQTFCLEdBQW9DLENBQUMsSUFBSSxLQUFLLG9CQUFMLENBQTBCLFNBQS9CLElBQTRDLEtBQUssb0JBQUwsQ0FBMEIsWUFBbEg7O0FBRUEsUUFBTyxLQUFQO0FBQ0EsQ0FYRDs7QUFhQSxLQUFLLFNBQUwsQ0FBZSxnQkFBZixHQUFrQyxVQUFVLGVBQVYsRUFBMkIsZUFBM0IsRUFBNEM7O0FBRTdFLE1BQUssZ0JBQUwsQ0FBc0Isa0JBQXRCLEdBQTJDLEtBQUssZUFBTCxHQUF1QixLQUFLLEdBQUwsQ0FBUyxlQUFULEVBQTBCLGVBQTFCLENBQWxFO0FBQ0EsTUFBSyxnQkFBTCxDQUFzQixrQkFBdEIsR0FBMkMsS0FBSyxlQUFMLEdBQXVCLEtBQUssR0FBTCxDQUFTLGVBQVQsRUFBMEIsZUFBMUIsQ0FBbEU7QUFFQSxDQUxEOztBQU9BLEtBQUssU0FBTCxDQUFlLFdBQWYsR0FBNkIsVUFBVSxLQUFWLEVBQWlCO0FBQzdDLEtBQUksQ0FBQyxLQUFMLEVBQ0MsT0FBTyxJQUFQOztBQUVELEtBQUksT0FBTyxJQUFYOztBQUVBLEtBQUksS0FBSyxTQUFMLEtBQW1CLE1BQXZCLEVBQStCO0FBQzlCLFNBQU8sQ0FBQyxLQUFLLEtBQUwsQ0FBVyxLQUFYLENBQWlCLGVBQWpCLEdBQW1DLEtBQUssS0FBTCxDQUFXLEtBQVgsQ0FBaUIsZUFBckQsSUFBd0UsS0FBSyxLQUFMLENBQVcsS0FBWCxDQUFpQixlQUFqQixDQUFpQyxNQUF6RyxJQUFvSCxLQUFLLEtBQUwsQ0FBVyxLQUFYLENBQWlCLGVBQWpCLENBQWlDLEVBQWpDLEdBQXNDLE1BQU0sQ0FBaEssSUFBc0ssS0FBSyxLQUFMLENBQVcsS0FBWCxDQUFpQixlQUE5TDtBQUNBLEVBRkQsTUFHSyxJQUFJLEtBQUssU0FBTCxLQUFtQixRQUF2QixFQUFpQztBQUNyQyxTQUFPLENBQUMsS0FBSyxLQUFMLENBQVcsS0FBWCxDQUFpQixlQUFqQixHQUFtQyxLQUFLLEtBQUwsQ0FBVyxLQUFYLENBQWlCLGVBQXJELElBQXdFLEtBQUssS0FBTCxDQUFXLEtBQVgsQ0FBaUIsZUFBakIsQ0FBaUMsS0FBekcsSUFBa0gsTUFBTSxDQUFOLEdBQVUsS0FBSyxLQUFMLENBQVcsS0FBWCxDQUFpQixlQUFqQixDQUFpQyxFQUE3SixJQUFtSyxLQUFLLEtBQUwsQ0FBVyxLQUFYLENBQWlCLGVBQTNMO0FBQ0E7O0FBRUQsUUFBTyxJQUFQO0FBQ0EsQ0FkRDs7QUFnQkEsS0FBSyxTQUFMLENBQWUseUNBQWYsR0FBMkQsVUFBVSxLQUFWLEVBQWlCO0FBQzNFLE1BQUssUUFBTCxHQUFnQixLQUFoQjs7QUFFQSxLQUFJLHVCQUF1QjtBQUMxQixnQkFBYyxJQURZLEVBQ04sU0FBUyxJQURILEVBQ1MsV0FBVztBQURwQixFQUEzQjs7QUFJQSxLQUFJLFFBQVEsS0FBSyxlQUFMLENBQXFCLEtBQWpDO0FBQ0EsS0FBSSxTQUFTLEtBQUssZUFBTCxDQUFxQixNQUFsQzs7QUFFQSxzQkFBcUIsT0FBckIsR0FBK0IsS0FBSyxlQUFwQzs7QUFFQSxLQUFJLEtBQUssU0FBTCxLQUFtQixRQUFuQixJQUErQixLQUFLLFNBQUwsS0FBbUIsS0FBdEQsRUFBNkQ7QUFDNUQsdUJBQXFCLFlBQXJCLEdBQW9DLENBQUMsS0FBSyxRQUFMLEdBQWdCLENBQUMsQ0FBakIsR0FBcUIsQ0FBdEIsSUFBMkIsS0FBM0IsR0FBbUMsS0FBSyxHQUFMLENBQVMsS0FBSyxlQUFMLEdBQXVCLEtBQUssZUFBckMsQ0FBdkU7QUFDQSx1QkFBcUIsU0FBckIsR0FBa0MsS0FBSyxRQUFMLEdBQWdCLEtBQUssZUFBTCxDQUFxQixFQUFyQyxHQUEwQyxLQUFLLGVBQUwsQ0FBcUIsRUFBakc7QUFDQTs7QUFFRCxLQUFJLEtBQUssU0FBTCxLQUFtQixNQUFuQixJQUE2QixLQUFLLFNBQUwsS0FBbUIsT0FBcEQsRUFBNkQ7QUFDNUQsdUJBQXFCLFlBQXJCLEdBQW9DLENBQUMsS0FBSyxRQUFMLEdBQWdCLENBQWhCLEdBQW9CLENBQUMsQ0FBdEIsSUFBMkIsTUFBM0IsR0FBb0MsS0FBSyxHQUFMLENBQVMsS0FBSyxlQUFMLEdBQXVCLEtBQUssZUFBckMsQ0FBeEU7QUFDQSx1QkFBcUIsU0FBckIsR0FBa0MsS0FBSyxRQUFMLEdBQWdCLEtBQUssZUFBTCxDQUFxQixFQUFyQyxHQUEwQyxLQUFLLGVBQUwsQ0FBcUIsRUFBakc7QUFDQTs7QUFHRCxNQUFLLG9CQUFMLEdBQTRCLG9CQUE1QjtBQUNBLENBeEJEOztBQTBCQSxLQUFLLFNBQUwsQ0FBZSx1QkFBZixHQUF5QyxZQUFZOztBQUVwRCxLQUFJLFlBQVksS0FBSyxLQUFMLENBQVcsYUFBWCxDQUF5QixZQUF6QixFQUFoQjtBQUNBLEtBQUksaUJBQWlCLENBQXJCO0FBQ0EsS0FBSSxrQkFBa0IsQ0FBdEI7QUFDQSxLQUFJLDBCQUEwQixLQUE5Qjs7QUFFQSxLQUFJLEtBQUssU0FBTCxLQUFtQixRQUFuQixJQUErQixLQUFLLFNBQUwsS0FBbUIsS0FBdEQsRUFBNkQ7QUFDNUQsT0FBSyxRQUFMLEdBQWdCLFVBQVUsS0FBMUI7QUFDQSxPQUFLLFNBQUwsR0FBaUIsVUFBVSxNQUEzQjtBQUNBLEVBSEQsTUFHTztBQUNOLE9BQUssUUFBTCxHQUFnQixVQUFVLE1BQTFCO0FBQ0EsT0FBSyxTQUFMLEdBQWlCLFVBQVUsS0FBM0I7QUFDQTs7QUFFRCxLQUFJLFVBQVUsS0FBSyxJQUFMLEtBQWMsT0FBZCxHQUF5QixLQUFLLFFBQUwsR0FBZ0IsR0FBaEIsR0FBc0IsQ0FBdEIsR0FBMEIsS0FBSyxHQUFMLENBQVMsQ0FBVCxFQUFZLEtBQUssS0FBTCxDQUFXLEtBQUssUUFBTCxHQUFnQixFQUEzQixDQUFaLENBQW5ELEdBQWtHLEtBQUssR0FBTCxDQUFTLEtBQUssS0FBTCxDQUFXLEtBQUssUUFBTCxHQUFnQixFQUEzQixDQUFULEVBQXlDLENBQXpDLENBQWhIO0FBQ0EsS0FBSSxHQUFKLEVBQVMsR0FBVDtBQUNBLEtBQUksT0FBSjtBQUNBLEtBQUksS0FBSjtBQUNBLEtBQUksZUFBZSxDQUFuQjs7QUFHQSxLQUFJLEtBQUssZUFBTCxLQUF5QixJQUF6QixJQUFpQyxNQUFNLEtBQUssZUFBWCxDQUFyQyxFQUNDLEtBQUssZUFBTCxHQUF1QixLQUFLLE9BQTVCOztBQUVELEtBQUksS0FBSyxlQUFMLEtBQXlCLElBQXpCLElBQWlDLE1BQU0sS0FBSyxlQUFYLENBQXJDLEVBQ0MsS0FBSyxlQUFMLEdBQXVCLEtBQUssT0FBNUI7O0FBRUQsS0FBSSxLQUFLLElBQUwsS0FBYyxPQUFsQixFQUEyQjtBQUMxQixRQUFPLEtBQUssZUFBTCxLQUF5QixJQUExQixHQUFrQyxLQUFLLGVBQXZDLEdBQXlELEtBQUssUUFBTCxDQUFjLFdBQTdFO0FBQ0EsUUFBTyxLQUFLLGVBQUwsS0FBeUIsSUFBMUIsR0FBa0MsS0FBSyxlQUF2QyxHQUF5RCxLQUFLLFFBQUwsQ0FBYyxXQUE3RTs7QUFFQSxNQUFJLE1BQU0sR0FBTixLQUFjLENBQWxCLEVBQXFCO0FBQ3BCLGtCQUFlLE9BQVEsS0FBSyxRQUFMLENBQWMsUUFBdEIsS0FBb0MsV0FBcEMsR0FBa0QsRUFBbEQsR0FBdUQsS0FBSyxRQUFMLENBQWMsUUFBcEY7O0FBRUEsVUFBTyxZQUFQO0FBQ0EsVUFBTyxZQUFQO0FBQ0E7O0FBRUQsTUFBSSxLQUFLLFFBQUwsQ0FBYyxPQUFkLEtBQTBCLFFBQTlCLEVBQ0MsVUFBVSxLQUFLLFFBQUwsQ0FBYyxPQUF4QixDQURELEtBRUssSUFBSSxNQUFNLEdBQU4sR0FBWSxDQUFoQixFQUFtQjtBQUN2QixhQUFVLEtBQUssR0FBTCxDQUFTLE1BQU0sR0FBZixJQUFzQixFQUFoQztBQUNBLEdBRkksTUFHQTtBQUNKLGFBQVUsQ0FBVjs7QUFFQSxPQUFJLEtBQUssS0FBTCxDQUFXLFFBQVgsQ0FBb0IsY0FBcEIsS0FBdUMsVUFBM0MsRUFDQywwQkFBMEIsSUFBMUI7QUFDRDtBQUVELEVBdkJELE1BdUJPLElBQUksS0FBSyxJQUFMLEtBQWMsT0FBbEIsRUFBMkI7O0FBRWpDO0FBQ0E7QUFDQSxRQUFPLEtBQUssZUFBTCxLQUF5QixJQUExQixHQUFrQyxLQUFLLGVBQXZDLEdBQXlELEtBQUssUUFBTCxDQUFjLFdBQTdFO0FBQ0EsUUFBTyxLQUFLLGVBQUwsS0FBeUIsSUFBMUIsR0FBa0MsS0FBSyxlQUF2QyxHQUF5RCxLQUFLLFFBQUwsQ0FBYyxXQUE3RTs7QUFFQSxNQUFJLENBQUMsU0FBUyxHQUFULENBQUQsSUFBa0IsQ0FBQyxTQUFTLEdBQVQsQ0FBdkIsRUFBc0M7QUFDckMsU0FBTSxPQUFRLEtBQUssUUFBTCxDQUFjLFFBQXRCLEtBQW9DLFdBQXBDLEdBQWtELENBQUMsUUFBbkQsR0FBOEQsS0FBSyxRQUFMLENBQWMsUUFBbEY7QUFDQSxTQUFNLENBQU47QUFDQSxHQUhELE1BR08sSUFBSSxDQUFDLFNBQVMsR0FBVCxDQUFMLEVBQW9CO0FBQzFCLFNBQU0sR0FBTjtBQUNBLEdBRk0sTUFFQSxJQUFJLENBQUMsU0FBUyxHQUFULENBQUwsRUFBb0I7QUFDMUIsU0FBTSxHQUFOO0FBQ0E7O0FBRUEsTUFBSSxRQUFRLENBQVIsSUFBYSxRQUFRLENBQXpCLEVBQTRCO0FBQUM7QUFDNUIsVUFBTyxDQUFQO0FBQ0EsU0FBTSxDQUFOO0FBQ0EsR0FIRCxNQUlLLElBQUksTUFBTSxHQUFOLEtBQWMsQ0FBbEIsRUFBcUI7QUFBQztBQUMxQixrQkFBZSxLQUFLLEdBQUwsQ0FBUyxLQUFLLEdBQUwsQ0FBUyxLQUFLLEdBQUwsQ0FBUyxHQUFULElBQWdCLEdBQXpCLENBQVQsRUFBd0MsQ0FBeEMsQ0FBZjtBQUNBLFVBQU8sWUFBUDtBQUNBLFVBQU8sWUFBUDtBQUNBLEdBSkksTUFLQSxJQUFJLE1BQU0sR0FBVixFQUFlO0FBQ25CLGtCQUFlLEtBQUssR0FBTCxDQUFTLEtBQUssR0FBTCxDQUFTLEtBQUssR0FBTCxDQUFTLE1BQU0sR0FBZixJQUFzQixHQUEvQixDQUFULEVBQThDLENBQTlDLENBQWY7O0FBRUEsT0FBSSxPQUFPLENBQVgsRUFDQyxNQUFNLE1BQU0sWUFBWixDQURELEtBR0MsTUFBTSxNQUFNLFlBQVo7QUFDRCxHQVBJLE1BUUE7O0FBRUosa0JBQWUsS0FBSyxHQUFMLENBQVMsS0FBSyxHQUFMLENBQVMsS0FBSyxHQUFMLENBQVMsTUFBTSxHQUFmLElBQXNCLEdBQS9CLENBQVQsRUFBOEMsR0FBOUMsQ0FBZjs7QUFFQSxPQUFJLFFBQVEsQ0FBWixFQUNDLE9BQU8sWUFBUDtBQUNELE9BQUksUUFBUSxDQUFaLEVBQ0MsT0FBTyxZQUFQO0FBQ0Q7O0FBRUYsTUFBSSxLQUFLLFFBQUwsQ0FBYyxPQUFkLEtBQTBCLFFBQTlCLEVBQ0MsVUFBVSxLQUFLLFFBQUwsQ0FBYyxPQUF4QixDQURELEtBRUssSUFBSSxNQUFNLEdBQU4sR0FBWSxDQUFoQixFQUFtQjtBQUN2QixhQUFVLEtBQUssR0FBTCxDQUFTLE1BQU0sR0FBZixJQUFzQixFQUFoQztBQUNBLEdBRkksTUFHQTtBQUNKLGFBQVUsQ0FBVjtBQUNBOztBQUdEO0FBQ0EsTUFBSSxLQUFLLFdBQUwsS0FBcUIsS0FBSyxlQUFMLEtBQXlCLElBQXpCLElBQWlDLE1BQU0sS0FBSyxlQUFYLENBQXRELENBQUosRUFBd0Y7QUFDdkYsT0FBSSxNQUFNLENBQVYsRUFDQyxNQUFNLENBQU47QUFDRDtBQUNELE1BQUksS0FBSyxXQUFMLEtBQXFCLEtBQUssZUFBTCxLQUF5QixJQUF6QixJQUFpQyxNQUFNLEtBQUssZUFBWCxDQUF0RCxDQUFKLEVBQXdGO0FBQ3ZGLE9BQUksTUFBTSxDQUFWLEVBQ0MsTUFBTSxDQUFOO0FBQ0Q7QUFDRDs7QUFFRCxTQUFRLENBQUMsTUFBTSxLQUFLLGVBQVgsS0FBK0IsS0FBSyxlQUFMLEtBQXlCLElBQXhELEdBQStELEdBQS9ELEdBQXFFLEtBQUssZUFBM0UsS0FBK0YsTUFBTSxLQUFLLGVBQVgsS0FBK0IsS0FBSyxlQUFMLEtBQXlCLElBQXhELEdBQStELEdBQS9ELEdBQXFFLEtBQUssZUFBekssQ0FBUjs7QUFFQSxLQUFJLEtBQUssSUFBTCxLQUFjLE9BQWQsSUFBeUIsS0FBSyxLQUFMLENBQVcsUUFBWCxDQUFvQixjQUFwQixLQUF1QyxVQUFwRSxFQUFnRjs7QUFFL0UsTUFBSSxDQUFDLEtBQUssWUFBVixFQUF3Qjs7QUFFdkIsT0FBSSxTQUFTLElBQUksQ0FBYixLQUFtQixPQUF2QixFQUFnQztBQUMvQixTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsYUFBcEI7QUFDQSxJQUhELE1BR08sSUFBSSxTQUFTLElBQUksQ0FBYixLQUFtQixPQUF2QixFQUFnQztBQUN0QyxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsYUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLElBQUksQ0FBYixLQUFtQixPQUF2QixFQUFnQztBQUN0QyxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsYUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLElBQUksRUFBYixLQUFvQixPQUF4QixFQUFpQztBQUN2QyxTQUFLLFFBQUwsR0FBZ0IsRUFBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsYUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLElBQUksRUFBYixLQUFvQixPQUF4QixFQUFpQztBQUN2QyxTQUFLLFFBQUwsR0FBZ0IsRUFBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsYUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLElBQUksRUFBYixLQUFvQixPQUF4QixFQUFpQztBQUN2QyxTQUFLLFFBQUwsR0FBZ0IsRUFBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsYUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLElBQUksR0FBYixLQUFxQixPQUF6QixFQUFrQztBQUN4QyxTQUFLLFFBQUwsR0FBZ0IsR0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsYUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLElBQUksR0FBYixLQUFxQixPQUF6QixFQUFrQztBQUN4QyxTQUFLLFFBQUwsR0FBZ0IsR0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsYUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLElBQUksR0FBYixLQUFxQixPQUF6QixFQUFrQztBQUN4QyxTQUFLLFFBQUwsR0FBZ0IsR0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsYUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLElBQUksR0FBYixLQUFxQixPQUF6QixFQUFrQztBQUN4QyxTQUFLLFFBQUwsR0FBZ0IsR0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsYUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLElBQUksR0FBYixLQUFxQixPQUF6QixFQUFrQztBQUN4QyxTQUFLLFFBQUwsR0FBZ0IsR0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsYUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLElBQUksR0FBYixLQUFxQixPQUF6QixFQUFrQztBQUN4QyxTQUFLLFFBQUwsR0FBZ0IsR0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsYUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixDQUFwQyxLQUEwQyxPQUE5QyxFQUF1RDtBQUM3RCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixDQUFwQyxLQUEwQyxPQUE5QyxFQUF1RDtBQUM3RCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixDQUFwQyxLQUEwQyxPQUE5QyxFQUF1RDtBQUM3RCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixFQUFwQyxLQUEyQyxPQUEvQyxFQUF3RDtBQUM5RCxTQUFLLFFBQUwsR0FBZ0IsRUFBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixFQUFwQyxLQUEyQyxPQUEvQyxFQUF3RDtBQUM5RCxTQUFLLFFBQUwsR0FBZ0IsRUFBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixFQUFwQyxLQUEyQyxPQUEvQyxFQUF3RDtBQUM5RCxTQUFLLFFBQUwsR0FBZ0IsRUFBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixFQUFwQyxLQUEyQyxPQUEvQyxFQUF3RDtBQUM5RCxTQUFLLFFBQUwsR0FBZ0IsRUFBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixDQUFwQyxLQUEwQyxPQUE5QyxFQUF1RDtBQUM3RCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixDQUFwQyxLQUEwQyxPQUE5QyxFQUF1RDtBQUM3RCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixDQUFwQyxLQUEwQyxPQUE5QyxFQUF1RDtBQUM3RCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixFQUFwQyxLQUEyQyxPQUEvQyxFQUF3RDtBQUM5RCxTQUFLLFFBQUwsR0FBZ0IsRUFBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixFQUFwQyxLQUEyQyxPQUEvQyxFQUF3RDtBQUM5RCxTQUFLLFFBQUwsR0FBZ0IsRUFBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixFQUFwQyxLQUEyQyxPQUEvQyxFQUF3RDtBQUM5RCxTQUFLLFFBQUwsR0FBZ0IsRUFBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsY0FBVixHQUEyQixFQUFwQyxLQUEyQyxPQUEvQyxFQUF3RDtBQUM5RCxTQUFLLFFBQUwsR0FBZ0IsRUFBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsUUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsWUFBVixHQUF5QixDQUFsQyxLQUF3QyxPQUE1QyxFQUFxRDtBQUMzRCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsTUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsWUFBVixHQUF5QixDQUFsQyxLQUF3QyxPQUE1QyxFQUFxRDtBQUMzRCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsTUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsWUFBVixHQUF5QixDQUFsQyxLQUF3QyxPQUE1QyxFQUFxRDtBQUMzRCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsTUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsWUFBVixHQUF5QixDQUFsQyxLQUF3QyxPQUE1QyxFQUFxRDtBQUMzRCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsTUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsV0FBVixHQUF3QixDQUFqQyxLQUF1QyxPQUEzQyxFQUFvRDtBQUMxRCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsS0FBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsV0FBVixHQUF3QixDQUFqQyxLQUF1QyxPQUEzQyxFQUFvRDtBQUMxRCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsS0FBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsV0FBVixHQUF3QixDQUFqQyxLQUF1QyxPQUEzQyxFQUFvRDtBQUMxRCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsS0FBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsWUFBVixHQUF5QixDQUFsQyxLQUF3QyxPQUE1QyxFQUFxRDtBQUMzRCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsTUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsWUFBVixHQUF5QixDQUFsQyxLQUF3QyxPQUE1QyxFQUFxRDtBQUMzRCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsTUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsWUFBVixHQUF5QixDQUFsQyxLQUF3QyxPQUE1QyxFQUFxRDtBQUMzRCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsTUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsYUFBVixHQUEwQixDQUFuQyxLQUF5QyxPQUE3QyxFQUFzRDtBQUM1RCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsT0FBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsYUFBVixHQUEwQixDQUFuQyxLQUF5QyxPQUE3QyxFQUFzRDtBQUM1RCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsT0FBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsYUFBVixHQUEwQixDQUFuQyxLQUF5QyxPQUE3QyxFQUFzRDtBQUM1RCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsT0FBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsYUFBVixHQUEwQixDQUFuQyxLQUF5QyxPQUE3QyxFQUFzRDtBQUM1RCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsT0FBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsWUFBVixHQUF5QixDQUFsQyxLQUF3QyxPQUE1QyxFQUFxRDtBQUMzRCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsTUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsWUFBVixHQUF5QixDQUFsQyxLQUF3QyxPQUE1QyxFQUFxRDtBQUMzRCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsTUFBcEI7QUFDQSxJQUhNLE1BR0EsSUFBSSxTQUFTLFVBQVUsWUFBVixHQUF5QixDQUFsQyxLQUF3QyxPQUE1QyxFQUFxRDtBQUMzRCxTQUFLLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxTQUFLLFlBQUwsR0FBb0IsTUFBcEI7QUFDQSxJQUhNLE1BR0E7QUFDTixTQUFLLFFBQUwsR0FBZ0IsS0FBSyxLQUFMLENBQVcsS0FBSyxhQUFMLENBQW1CLFNBQVMsVUFBVSxDQUFuQixDQUFuQixFQUEwQyxJQUExQyxJQUFrRCxVQUFVLFlBQXZFLENBQWhCO0FBQ0EsU0FBSyxZQUFMLEdBQW9CLE1BQXBCO0FBQ0E7QUFFRDs7QUFFRCxNQUFJLEtBQUssZUFBTCxLQUF5QixJQUF6QixJQUFpQyxNQUFNLEtBQUssZUFBWCxDQUFyQyxFQUNDLEtBQUssZUFBTCxHQUF1QixNQUFNLFVBQVUsQ0FBdkM7O0FBRUQsTUFBSSxLQUFLLGVBQUwsS0FBeUIsSUFBekIsSUFBaUMsTUFBTSxLQUFLLGVBQVgsQ0FBckMsRUFDQyxLQUFLLGVBQUwsR0FBdUIsTUFBTSxVQUFVLENBQXZDOztBQUdELE1BQUksQ0FBQyxLQUFLLGlCQUFWLEVBQTZCO0FBQzVCLE9BQUksdUJBQUosRUFBNkI7QUFDNUIsU0FBSyxpQkFBTCxHQUF5QixtQkFBekI7QUFDQSxJQUZELE1BRU8sSUFBSSxLQUFLLFlBQUwsS0FBc0IsTUFBMUIsRUFBa0M7QUFDeEMsU0FBSyxpQkFBTCxHQUF5QixNQUF6QjtBQUNBLElBRk0sTUFFQSxJQUFJLEtBQUssWUFBTCxLQUFzQixPQUExQixFQUFtQztBQUN6QyxTQUFLLGlCQUFMLEdBQXlCLFVBQXpCO0FBQ0EsSUFGTSxNQUVBLElBQUksS0FBSyxZQUFMLEtBQXNCLE1BQTFCLEVBQWtDO0FBQ3hDLFNBQUssaUJBQUwsR0FBeUIsYUFBekI7QUFDQSxJQUZNLE1BRUEsSUFBSSxLQUFLLFlBQUwsS0FBc0IsS0FBMUIsRUFBaUM7QUFDdkMsU0FBSyxpQkFBTCxHQUF5QixhQUF6QjtBQUNBLElBRk0sTUFFQSxJQUFJLEtBQUssWUFBTCxLQUFzQixNQUExQixFQUFrQztBQUN4QyxTQUFLLGlCQUFMLEdBQXlCLFVBQXpCO0FBQ0EsSUFGTSxNQUVBLElBQUksS0FBSyxZQUFMLEtBQXNCLFFBQTFCLEVBQW9DO0FBQzFDLFNBQUssaUJBQUwsR0FBeUIsVUFBekI7QUFDQSxJQUZNLE1BRUEsSUFBSSxLQUFLLFlBQUwsS0FBc0IsUUFBMUIsRUFBb0M7QUFDMUMsU0FBSyxpQkFBTCxHQUF5QixhQUF6QjtBQUNBLElBRk0sTUFFQSxJQUFJLEtBQUssWUFBTCxLQUFzQixhQUExQixFQUF5QztBQUMvQyxTQUFLLGlCQUFMLEdBQXlCLFNBQXpCO0FBQ0E7QUFDRDtBQUVELEVBektELE1BeUtPOztBQUVOLE9BQUssWUFBTCxHQUFvQixRQUFwQjs7QUFFQSxVQUFRLEtBQUssYUFBTCxDQUFtQixLQUFuQixFQUEwQixLQUExQixDQUFSOztBQUVBLE1BQUksS0FBSyxRQUFMLElBQWlCLEtBQUssUUFBTCxDQUFjLFFBQW5DLEVBQ0MsS0FBSyxRQUFMLEdBQWdCLEtBQUssUUFBTCxDQUFjLFFBQTlCLENBREQsS0FFSztBQUNKLFFBQUssUUFBTCxHQUFnQixLQUFLLGFBQUwsQ0FBbUIsU0FBUyxVQUFVLENBQW5CLENBQW5CLEVBQTBDLElBQTFDLENBQWhCO0FBQ0E7O0FBRUQsTUFBSSxLQUFLLGVBQUwsS0FBeUIsSUFBekIsSUFBaUMsTUFBTSxLQUFLLGVBQVgsQ0FBckMsRUFBa0U7QUFDakUsT0FBSSxLQUFLLElBQUwsS0FBYyxPQUFsQixFQUNDLEtBQUssZUFBTCxHQUF1QixNQUFNLFVBQVUsQ0FBdkMsQ0FERCxLQUdDLEtBQUssZUFBTCxHQUF1QixLQUFLLEtBQUwsQ0FBVyxNQUFNLEtBQUssUUFBdEIsSUFBa0MsS0FBSyxRQUE5RDtBQUNEOztBQUVELE1BQUksS0FBSyxlQUFMLEtBQXlCLElBQXpCLElBQWlDLE1BQU0sS0FBSyxlQUFYLENBQXJDLEVBQWtFO0FBQ2pFLE9BQUksS0FBSyxJQUFMLEtBQWMsT0FBbEIsRUFDQyxLQUFLLGVBQUwsR0FBdUIsTUFBTSxVQUFVLENBQXZDLENBREQsS0FHQyxLQUFLLGVBQUwsR0FBdUIsS0FBSyxJQUFMLENBQVUsTUFBTSxLQUFLLFFBQXJCLElBQWlDLEtBQUssUUFBN0Q7QUFDRDs7QUFFRCxNQUFJLEtBQUssZUFBTCxLQUF5QixDQUF6QixJQUE4QixLQUFLLGVBQUwsS0FBeUIsQ0FBM0QsRUFBOEQ7O0FBRTdELE9BQUksS0FBSyxRQUFMLENBQWMsZUFBZCxLQUFrQyxDQUF0QyxFQUF5QztBQUN4QyxTQUFLLGVBQUwsSUFBd0IsRUFBeEI7QUFDQSxJQUZELE1BR0ssSUFBSSxLQUFLLFFBQUwsQ0FBYyxlQUFkLEtBQWtDLENBQXRDLEVBQXlDO0FBQzdDLFNBQUssZUFBTCxJQUF3QixFQUF4QjtBQUNBOztBQUVELE9BQUksS0FBSyxRQUFMLElBQWlCLE9BQVEsS0FBSyxRQUFMLENBQWMsUUFBdEIsS0FBb0MsV0FBekQsRUFBc0U7QUFDckUsU0FBSyxRQUFMLEdBQWdCLEtBQUssYUFBTCxDQUFtQixDQUFDLEtBQUssZUFBTCxHQUF1QixLQUFLLGVBQTdCLEtBQWlELFVBQVUsQ0FBM0QsQ0FBbkIsRUFBa0YsSUFBbEYsQ0FBaEI7QUFDQTtBQUNEO0FBQ0Q7O0FBRUQ7QUFDQSxLQUFJLEtBQUssT0FBTCxLQUFpQixJQUFqQixJQUF5QixLQUFLLE9BQUwsS0FBaUIsSUFBOUMsRUFBb0Q7QUFDbkQsTUFBSSxLQUFLLElBQUwsS0FBYyxPQUFsQixFQUEyQjtBQUMxQixTQUFPLEtBQUssT0FBTCxLQUFpQixJQUFsQixHQUEwQixLQUFLLE9BQS9CLEdBQXlDLEtBQUssUUFBTCxDQUFjLEdBQTdEO0FBQ0EsU0FBTyxLQUFLLE9BQUwsS0FBaUIsSUFBbEIsR0FBMEIsS0FBSyxPQUEvQixHQUF5QyxLQUFLLFFBQUwsQ0FBYyxHQUE3RDs7QUFFQSxPQUFJLE1BQU0sR0FBTixLQUFjLENBQWxCLEVBQXFCO0FBQ3BCLG1CQUFlLE9BQVEsS0FBSyxRQUFMLENBQWMsUUFBdEIsS0FBb0MsV0FBcEMsR0FBa0QsRUFBbEQsR0FBdUQsS0FBSyxRQUFMLENBQWMsUUFBcEY7O0FBRUEsV0FBTyxZQUFQO0FBQ0EsV0FBTyxZQUFQO0FBQ0E7O0FBRUQsT0FBSSxLQUFLLFFBQUwsQ0FBYyxPQUFkLEtBQTBCLFFBQTlCLEVBQ0MsVUFBVSxLQUFLLFFBQUwsQ0FBYyxPQUF4QixDQURELEtBRUssSUFBSSxNQUFNLEdBQU4sR0FBWSxDQUFoQixFQUFtQjtBQUN2QixjQUFVLEtBQUssR0FBTCxDQUFTLE1BQU0sR0FBZixJQUFzQixFQUFoQztBQUNBLElBRkksTUFHQTtBQUNKLGNBQVUsQ0FBVjtBQUNBO0FBRUQsR0FwQkQsTUFvQk8sSUFBSSxLQUFLLElBQUwsS0FBYyxPQUFsQixFQUEyQjs7QUFFakMsU0FBTyxLQUFLLE9BQUwsS0FBaUIsSUFBbEIsR0FBMEIsS0FBSyxPQUEvQixHQUF5QyxLQUFLLFFBQUwsQ0FBYyxHQUE3RDtBQUNBLFNBQU8sS0FBSyxPQUFMLEtBQWlCLElBQWxCLEdBQTBCLEtBQUssT0FBL0IsR0FBeUMsS0FBSyxRQUFMLENBQWMsR0FBN0Q7O0FBRUEsT0FBSSxDQUFDLFNBQVMsR0FBVCxDQUFELElBQWtCLENBQUMsU0FBUyxHQUFULENBQXZCLEVBQXNDO0FBQ3JDLFVBQU0sT0FBUSxLQUFLLFFBQUwsQ0FBYyxRQUF0QixLQUFvQyxXQUFwQyxHQUFrRCxDQUFDLFFBQW5ELEdBQThELEtBQUssUUFBTCxDQUFjLFFBQWxGO0FBQ0EsVUFBTSxDQUFOO0FBQ0EsSUFIRCxNQUtDLElBQUksUUFBUSxDQUFSLElBQWEsUUFBUSxDQUF6QixFQUE0QjtBQUFDO0FBQzVCLFdBQU8sQ0FBUDtBQUNBLFVBQU0sQ0FBTjtBQUNBLElBSEQsTUFJSyxJQUFJLE1BQU0sR0FBTixLQUFjLENBQWxCLEVBQXFCO0FBQUM7QUFDMUIsbUJBQWUsS0FBSyxHQUFMLENBQVMsS0FBSyxHQUFMLENBQVMsS0FBSyxHQUFMLENBQVMsR0FBVCxJQUFnQixHQUF6QixDQUFULEVBQXdDLENBQXhDLENBQWY7QUFDQSxXQUFPLFlBQVA7QUFDQSxXQUFPLFlBQVA7QUFDQSxJQUpJLE1BS0EsSUFBSSxNQUFNLEdBQVYsRUFBZTtBQUNuQixtQkFBZSxLQUFLLEdBQUwsQ0FBUyxLQUFLLEdBQUwsQ0FBUyxLQUFLLEdBQUwsQ0FBUyxNQUFNLEdBQWYsSUFBc0IsR0FBL0IsQ0FBVCxFQUE4QyxDQUE5QyxDQUFmOztBQUVBLFFBQUksT0FBTyxDQUFYLEVBQ0MsTUFBTSxNQUFNLFlBQVosQ0FERCxLQUdDLE1BQU0sTUFBTSxZQUFaO0FBQ0QsSUFQSSxNQVFBOztBQUVKLG1CQUFlLEtBQUssR0FBTCxDQUFTLEtBQUssR0FBTCxDQUFTLEtBQUssR0FBTCxDQUFTLE1BQU0sR0FBZixJQUFzQixHQUEvQixDQUFULEVBQThDLEdBQTlDLENBQWY7O0FBRUEsUUFBSSxRQUFRLENBQVosRUFDQyxPQUFPLFlBQVA7QUFDRCxRQUFJLFFBQVEsQ0FBWixFQUNDLE9BQU8sWUFBUDtBQUNEOztBQUVGLE9BQUksS0FBSyxRQUFMLENBQWMsT0FBZCxLQUEwQixRQUE5QixFQUNDLFVBQVUsS0FBSyxRQUFMLENBQWMsT0FBeEIsQ0FERCxLQUVLLElBQUksTUFBTSxHQUFOLEdBQVksQ0FBaEIsRUFBbUI7QUFDdkIsY0FBVSxLQUFLLEdBQUwsQ0FBUyxNQUFNLEdBQWYsSUFBc0IsRUFBaEM7QUFDQSxJQUZJLE1BR0E7QUFDSixjQUFVLENBQVY7QUFDQTs7QUFHRDtBQUNBLE9BQUksS0FBSyxXQUFMLEtBQXFCLEtBQUssT0FBTCxLQUFpQixJQUFqQixJQUF5QixNQUFNLEtBQUssT0FBWCxDQUE5QyxDQUFKLEVBQXdFO0FBQ3ZFLFFBQUksTUFBTSxDQUFWLEVBQ0MsTUFBTSxDQUFOO0FBQ0Q7QUFDRCxPQUFJLEtBQUssV0FBTCxLQUFxQixLQUFLLE9BQUwsS0FBaUIsSUFBakIsSUFBeUIsTUFBTSxLQUFLLE9BQVgsQ0FBOUMsQ0FBSixFQUF3RTtBQUN2RSxRQUFJLE1BQU0sQ0FBVixFQUNDLE1BQU0sQ0FBTjtBQUNEO0FBQ0Q7O0FBRUQsVUFBUSxNQUFNLEdBQWQ7O0FBRUEsTUFBSSxLQUFLLElBQUwsS0FBYyxPQUFkLElBQXlCLEtBQUssS0FBTCxDQUFXLFFBQVgsQ0FBb0IsY0FBcEIsS0FBdUMsVUFBcEUsRUFBZ0Y7O0FBRS9FLE9BQUksS0FBSyxPQUFMLEtBQWlCLElBQWpCLElBQXlCLE1BQU0sS0FBSyxPQUFYLENBQTdCLEVBQ0MsS0FBSyxPQUFMLEdBQWUsTUFBTSxVQUFVLENBQS9COztBQUVELE9BQUksS0FBSyxPQUFMLEtBQWlCLElBQWpCLElBQXlCLE1BQU0sS0FBSyxPQUFYLENBQTdCLEVBQ0MsS0FBSyxPQUFMLEdBQWUsTUFBTSxVQUFVLENBQS9CO0FBRUQsR0FSRCxNQVFPOztBQUVOLFFBQUssWUFBTCxHQUFvQixRQUFwQjs7QUFFQSxPQUFJLEtBQUssT0FBTCxLQUFpQixJQUFyQixFQUEyQjtBQUMxQixRQUFJLEtBQUssSUFBTCxLQUFjLE9BQWxCLEVBQ0MsS0FBSyxPQUFMLEdBQWUsTUFBTSxVQUFVLENBQS9CLENBREQsS0FHRCxLQUFLLE9BQUwsR0FBZSxLQUFLLEtBQUwsQ0FBVyxNQUFNLEtBQUssUUFBdEIsSUFBa0MsS0FBSyxRQUF0RDs7QUFFQyxTQUFLLE9BQUwsR0FBZSxLQUFLLEdBQUwsQ0FBUyxLQUFLLE9BQWQsRUFBdUIsS0FBSyxnQkFBTCxDQUFzQixlQUF0QixLQUEwQyxJQUExQyxJQUFrRCxNQUFNLEtBQUssZ0JBQUwsQ0FBc0IsZUFBNUIsQ0FBbEQsR0FBaUcsUUFBakcsR0FBNEcsS0FBSyxnQkFBTCxDQUFzQixlQUF6SixDQUFmO0FBQ0E7O0FBRUQsT0FBSSxLQUFLLE9BQUwsS0FBaUIsSUFBckIsRUFBMkI7QUFDMUIsUUFBSSxLQUFLLElBQUwsS0FBYyxPQUFsQixFQUNDLEtBQUssT0FBTCxHQUFlLE1BQU0sVUFBVSxDQUEvQixDQURELEtBR0QsS0FBSyxPQUFMLEdBQWUsS0FBSyxJQUFMLENBQVUsTUFBTSxLQUFLLFFBQXJCLElBQWlDLEtBQUssUUFBckQ7O0FBRUMsU0FBSyxPQUFMLEdBQWUsS0FBSyxHQUFMLENBQVMsS0FBSyxPQUFkLEVBQXVCLEtBQUssZ0JBQUwsQ0FBc0IsZUFBdEIsS0FBMEMsSUFBMUMsSUFBa0QsTUFBTSxLQUFLLGdCQUFMLENBQXNCLGVBQTVCLENBQWxELEdBQWlHLENBQUMsUUFBbEcsR0FBNkcsS0FBSyxnQkFBTCxDQUFzQixlQUExSixDQUFmO0FBQ0E7O0FBRUY7OztBQUdBLE9BQUksS0FBSyxPQUFMLEtBQWlCLENBQWpCLElBQXNCLEtBQUssT0FBTCxLQUFpQixDQUEzQyxFQUE4Qzs7QUFFN0MsUUFBSSxLQUFLLFFBQUwsQ0FBYyxPQUFkLEtBQTBCLENBQTlCLEVBQWlDO0FBQ2hDLFVBQUssT0FBTCxJQUFnQixFQUFoQjtBQUNBLEtBRkQsTUFHSyxJQUFJLEtBQUssUUFBTCxDQUFjLE9BQWQsS0FBMEIsQ0FBOUIsRUFBaUM7QUFDckMsVUFBSyxPQUFMLElBQWdCLEVBQWhCO0FBQ0E7QUFDQTtBQUNBO0FBQ0Q7O0FBRUYsTUFBSyxlQUFMLEdBQXVCLEtBQUssR0FBTCxDQUFTLEtBQUssZUFBZCxFQUErQixLQUFLLE9BQXBDLENBQXZCO0FBQ0EsTUFBSyxlQUFMLEdBQXVCLEtBQUssR0FBTCxDQUFTLEtBQUssZUFBZCxFQUErQixLQUFLLE9BQXBDLENBQXZCOztBQUVBLEtBQUksS0FBSyxJQUFMLEtBQWMsT0FBZCxJQUF5QixLQUFLLEtBQUwsQ0FBVyxRQUFYLENBQW9CLGNBQXBCLEtBQXVDLFVBQXBFLEVBQ0MsS0FBSyxxQkFBTCxHQUE2QixLQUFLLGtCQUFMLENBQXdCLElBQUksSUFBSixDQUFTLEtBQUssZUFBZCxDQUF4QixFQUF3RCxLQUFLLFlBQTdELEVBQTJFLEtBQUssUUFBaEYsQ0FBN0IsQ0FERCxLQUdDLEtBQUsscUJBQUwsR0FBNkIsS0FBSyxLQUFMLENBQVcsQ0FBQyxLQUFLLGVBQUwsR0FBd0IsS0FBSyxRQUFMLEdBQWdCLEVBQXpDLElBQWdELEtBQUssUUFBaEUsSUFBNEUsS0FBSyxRQUE5Rzs7QUFFRDtBQUNBLEtBQUksQ0FBQyxLQUFLLGlCQUFWLEVBQTZCO0FBQzVCLE9BQUssaUJBQUwsR0FBeUIsVUFBekI7O0FBRUEsVUFBUSxLQUFLLEdBQUwsQ0FBUyxLQUFLLGVBQUwsR0FBdUIsS0FBSyxlQUFyQyxDQUFSOztBQUVBLE1BQUksUUFBUSxDQUFaLEVBQWU7QUFDZCxPQUFJLG1CQUFtQixLQUFLLEtBQUwsQ0FBVyxLQUFLLEdBQUwsQ0FBUyxLQUFLLEdBQUwsQ0FBUyxLQUFULElBQWtCLEtBQUssSUFBaEMsQ0FBWCxJQUFvRCxDQUEzRTs7QUFFQSxPQUFJLE1BQU0sZ0JBQU4sS0FBMkIsQ0FBQyxTQUFTLGdCQUFULENBQWhDLEVBQ0MsbUJBQW1CLENBQW5COztBQUVELE9BQUksbUJBQW1CLENBQXZCLEVBQTBCO0FBQ3pCLFNBQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxtQkFBbUIsQ0FBdkMsRUFBMEMsR0FBMUM7QUFDQyxVQUFLLGlCQUFMLElBQTBCLEdBQTFCO0FBREQ7QUFFQTtBQUNEO0FBRUQ7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLENBdmVEOztBQXllQSxLQUFLLGFBQUwsR0FBcUIsVUFBVSxDQUFWLEVBQWEsS0FBYixFQUFvQjs7QUFFeEMsS0FBSSxNQUFNLEtBQUssS0FBTCxDQUFXLEtBQUssR0FBTCxDQUFTLENBQVQsSUFBYyxLQUFLLElBQTlCLENBQVY7QUFDQSxLQUFJLElBQUksSUFBSSxLQUFLLEdBQUwsQ0FBUyxFQUFULEVBQWEsR0FBYixDQUFaO0FBQ0EsS0FBSSxFQUFKOztBQUVBLEtBQUksS0FBSixFQUFXO0FBQ1YsTUFBSSxJQUFJLEdBQVIsRUFDQyxLQUFLLENBQUwsQ0FERCxLQUVLLElBQUksSUFBSSxDQUFSLEVBQ0osS0FBSyxDQUFMLENBREksS0FFQSxJQUFJLElBQUksQ0FBUixFQUNKLEtBQUssQ0FBTCxDQURJLEtBR0osS0FBSyxFQUFMO0FBQ0QsRUFURCxNQVVLO0FBQ0osTUFBSSxLQUFLLENBQVQsRUFDQyxLQUFLLENBQUwsQ0FERCxLQUVLLElBQUksS0FBSyxDQUFULEVBQ0osS0FBSyxDQUFMLENBREksS0FFQSxJQUFJLEtBQUssQ0FBVCxFQUNKLEtBQUssQ0FBTCxDQURJLEtBRUEsS0FBSyxFQUFMO0FBQ0w7O0FBRUQsUUFBTyxPQUFPLENBQUMsS0FBSyxLQUFLLEdBQUwsQ0FBUyxFQUFULEVBQWEsR0FBYixDQUFOLEVBQXlCLE9BQXpCLENBQWlDLEVBQWpDLENBQVAsQ0FBUDtBQUNBLENBM0JEOztBQTZCQSxLQUFLLFNBQUwsQ0FBZSxrQkFBZixHQUFvQyxZQUFZOztBQUUvQyxLQUFJLHlCQUF5QixnQkFBZ0IsS0FBSyxRQUFyQixFQUErQixLQUFLLFlBQXBDLENBQTdCO0FBQ0EsS0FBSSxVQUFVLEtBQUssS0FBTCxDQUFZLEtBQUssZUFBTixHQUF5QixzQkFBcEMsSUFBOEQsc0JBQTVFO0FBQ0EsS0FBSSxXQUFXLElBQUksSUFBSixDQUFTLE9BQVQsQ0FBZjs7QUFFQSxLQUFJLEtBQUssWUFBTCxLQUFzQixhQUExQixFQUF5QztBQUN4QztBQUNBO0FBQ0EsRUFIRCxNQUlLLElBQUksS0FBSyxZQUFMLEtBQXNCLFFBQTFCLEVBQW9DO0FBQ3hDLE1BQUksU0FBUyxlQUFULEtBQTZCLENBQWpDLEVBQW9DO0FBQ25DLFlBQVMsVUFBVCxDQUFvQixTQUFTLFVBQVQsS0FBd0IsQ0FBNUM7QUFDQSxZQUFTLGVBQVQsQ0FBeUIsQ0FBekI7QUFDQTtBQUNELEVBTEksTUFNQSxJQUFJLEtBQUssWUFBTCxLQUFzQixRQUExQixFQUFvQztBQUN4QyxNQUFJLFNBQVMsVUFBVCxLQUF3QixDQUF4QixJQUE2QixTQUFTLGVBQVQsS0FBNkIsQ0FBOUQsRUFBaUU7QUFDaEUsWUFBUyxVQUFULENBQW9CLFNBQVMsVUFBVCxLQUF3QixDQUE1QztBQUNBLFlBQVMsVUFBVCxDQUFvQixDQUFwQjtBQUNBLFlBQVMsZUFBVCxDQUF5QixDQUF6QjtBQUNBO0FBQ0QsRUFOSSxNQU9BLElBQUksS0FBSyxZQUFMLEtBQXNCLE1BQTFCLEVBQWtDO0FBQ3RDLE1BQUksU0FBUyxVQUFULEtBQXdCLENBQXhCLElBQTZCLFNBQVMsVUFBVCxLQUF3QixDQUFyRCxJQUEwRCxTQUFTLGVBQVQsS0FBNkIsQ0FBM0YsRUFBOEY7QUFDN0YsWUFBUyxRQUFULENBQWtCLFNBQVMsUUFBVCxLQUFzQixDQUF4QztBQUNBLFlBQVMsVUFBVCxDQUFvQixDQUFwQjtBQUNBLFlBQVMsVUFBVCxDQUFvQixDQUFwQjtBQUNBLFlBQVMsZUFBVCxDQUF5QixDQUF6QjtBQUNBO0FBQ0QsRUFQSSxNQVFBLElBQUksS0FBSyxZQUFMLEtBQXNCLEtBQTFCLEVBQWlDO0FBQ3JDLE1BQUksU0FBUyxRQUFULEtBQXNCLENBQXRCLElBQTJCLFNBQVMsVUFBVCxLQUF3QixDQUFuRCxJQUF3RCxTQUFTLFVBQVQsS0FBd0IsQ0FBaEYsSUFBcUYsU0FBUyxlQUFULEtBQTZCLENBQXRILEVBQXlIO0FBQ3hILFlBQVMsT0FBVCxDQUFpQixTQUFTLE9BQVQsS0FBcUIsQ0FBdEM7QUFDQSxZQUFTLFFBQVQsQ0FBa0IsQ0FBbEI7QUFDQSxZQUFTLFVBQVQsQ0FBb0IsQ0FBcEI7QUFDQSxZQUFTLFVBQVQsQ0FBb0IsQ0FBcEI7QUFDQSxZQUFTLGVBQVQsQ0FBeUIsQ0FBekI7QUFDQTtBQUNELEVBUkksTUFTQSxJQUFJLEtBQUssWUFBTCxLQUFzQixNQUExQixFQUFrQztBQUN0QyxNQUFJLFNBQVMsTUFBVCxLQUFvQixDQUFwQixJQUF5QixTQUFTLFFBQVQsS0FBc0IsQ0FBL0MsSUFBb0QsU0FBUyxVQUFULEtBQXdCLENBQTVFLElBQWlGLFNBQVMsVUFBVCxLQUF3QixDQUF6RyxJQUE4RyxTQUFTLGVBQVQsS0FBNkIsQ0FBL0ksRUFBa0o7QUFDakosWUFBUyxPQUFULENBQWlCLFNBQVMsT0FBVCxNQUFzQixJQUFJLFNBQVMsTUFBVCxFQUExQixDQUFqQjtBQUNBLFlBQVMsUUFBVCxDQUFrQixDQUFsQjtBQUNBLFlBQVMsVUFBVCxDQUFvQixDQUFwQjtBQUNBLFlBQVMsVUFBVCxDQUFvQixDQUFwQjtBQUNBLFlBQVMsZUFBVCxDQUF5QixDQUF6QjtBQUNBO0FBQ0QsRUFSSSxNQVNBLElBQUksS0FBSyxZQUFMLEtBQXNCLE9BQTFCLEVBQW1DO0FBQ3ZDLE1BQUksU0FBUyxPQUFULEtBQXFCLENBQXJCLElBQTBCLFNBQVMsUUFBVCxLQUFzQixDQUFoRCxJQUFxRCxTQUFTLFVBQVQsS0FBd0IsQ0FBN0UsSUFBa0YsU0FBUyxVQUFULEtBQXdCLENBQTFHLElBQStHLFNBQVMsZUFBVCxLQUE2QixDQUFoSixFQUFtSjtBQUNsSixZQUFTLFFBQVQsQ0FBa0IsU0FBUyxRQUFULEtBQXNCLENBQXhDO0FBQ0EsWUFBUyxPQUFULENBQWlCLENBQWpCO0FBQ0EsWUFBUyxRQUFULENBQWtCLENBQWxCO0FBQ0EsWUFBUyxVQUFULENBQW9CLENBQXBCO0FBQ0EsWUFBUyxVQUFULENBQW9CLENBQXBCO0FBQ0EsWUFBUyxlQUFULENBQXlCLENBQXpCO0FBQ0E7QUFDRCxFQVRJLE1BVUEsSUFBSSxLQUFLLFlBQUwsS0FBc0IsTUFBMUIsRUFBa0M7QUFDdEMsTUFBSSxTQUFTLFFBQVQsS0FBc0IsQ0FBdEIsSUFBMkIsU0FBUyxPQUFULEtBQXFCLENBQWhELElBQXFELFNBQVMsUUFBVCxLQUFzQixDQUEzRSxJQUFnRixTQUFTLFVBQVQsS0FBd0IsQ0FBeEcsSUFBNkcsU0FBUyxVQUFULEtBQXdCLENBQXJJLElBQTBJLFNBQVMsZUFBVCxLQUE2QixDQUEzSyxFQUE4SztBQUM3SyxZQUFTLFdBQVQsQ0FBcUIsU0FBUyxXQUFULEtBQXlCLENBQTlDO0FBQ0EsWUFBUyxRQUFULENBQWtCLENBQWxCO0FBQ0EsWUFBUyxPQUFULENBQWlCLENBQWpCO0FBQ0EsWUFBUyxRQUFULENBQWtCLENBQWxCO0FBQ0EsWUFBUyxVQUFULENBQW9CLENBQXBCO0FBQ0EsWUFBUyxVQUFULENBQW9CLENBQXBCO0FBQ0EsWUFBUyxlQUFULENBQXlCLENBQXpCO0FBQ0E7QUFDRDs7QUFFRCxRQUFPLFFBQVA7QUFDQSxDQXhFRDs7a0JBMEVlLEk7Ozs7Ozs7OztBQ3Y1RGY7O0FBQ0E7O0FBRUEsU0FBUyxjQUFULENBQXdCLFdBQXhCLEVBQXFDLE9BQXJDLEVBQThDLEtBQTlDLEVBQXFELE1BQXJELEVBQTZEO0FBQzNELE9BQUssWUFBTCxHQUFvQixXQUFwQjs7QUFFQSxPQUFLLE1BQUwsR0FBYyxNQUFkOztBQUVBLE9BQUssZUFBTCxHQUF1QixFQUF2QixDQUwyRCxDQUtqQzs7QUFFMUIsTUFBSSxzQkFBc0IsRUFBMUI7O0FBRUEsTUFBSSxTQUFTLGVBQU8sS0FBUCxDQUFULElBQTBCLGVBQU8sS0FBUCxFQUFjLFdBQWQsQ0FBOUIsRUFDRSxzQkFBc0IsZUFBTyxLQUFQLEVBQWMsV0FBZCxDQUF0Qjs7QUFFRixPQUFLLFFBQUwsR0FBZ0IsVUFBVSxPQUFWLEdBQW9CLEVBQXBDO0FBQ0EsT0FBSyxVQUFMLENBQWdCLEtBQUssUUFBckIsRUFBK0IsbUJBQS9CO0FBQ0Q7O0FBRUQsZUFBZSxTQUFmLENBQXlCLFVBQXpCLEdBQXNDLFVBQVUsT0FBVixFQUFtQixtQkFBbkIsRUFBd0M7O0FBRTVFLE1BQUksQ0FBQyx3QkFBZSxLQUFLLFlBQXBCLENBQUwsRUFBd0M7QUFDdEMsUUFBSSx3QkFBZSxPQUFPLE9BQTFCLEVBQ0UsUUFBUSxHQUFSLENBQVksa0JBQVo7QUFDSCxHQUhELE1BSUs7QUFDSCxRQUFJLFdBQVcsd0JBQWUsS0FBSyxZQUFwQixDQUFmOztBQUVBLFNBQUssSUFBSSxJQUFULElBQWlCLFFBQWpCLEVBQTJCOztBQUV6QixVQUFJLFNBQVMsY0FBVCxDQUF3QixJQUF4QixDQUFKLEVBQW1DO0FBQ25DLFlBQUksV0FBVyxRQUFRLE9BQXZCLEVBQ0UsS0FBSyxJQUFMLElBQWEsUUFBUSxJQUFSLENBQWIsQ0FERixLQUVLLElBQUksdUJBQXVCLFFBQVEsbUJBQW5DLEVBQ0gsS0FBSyxJQUFMLElBQWEsb0JBQW9CLElBQXBCLENBQWIsQ0FERyxLQUVBLEtBQUssSUFBTCxJQUFhLFNBQVMsSUFBVCxDQUFiOztBQUVMO0FBQ0E7QUFDQTtBQUNBO0FBQ0Q7QUFFRjtBQUNBO0FBQ0YsQ0ExQkQ7O0FBNEJBO0FBQ0EsZUFBZSxTQUFmLENBQXlCLFlBQXpCLEdBQXdDLFVBQVUsSUFBVixFQUFnQjs7QUFFdEQsTUFBSSxDQUFDLHdCQUFlLEtBQUssWUFBcEIsQ0FBRCxJQUFzQyxvQkFBdEMsSUFBcUQsT0FBTyxPQUFoRSxFQUNFLFFBQVEsR0FBUixDQUFZLGtCQUFaOztBQUVGLE1BQUksV0FBVyx3QkFBZSxLQUFLLFlBQXBCLENBQWY7QUFDQSxNQUFJLFFBQVEsS0FBSyxRQUFMLENBQWMsS0FBZCxHQUFzQixLQUFLLFFBQUwsQ0FBYyxLQUFwQyxHQUE2QyxLQUFLLEtBQUwsSUFBYyxLQUFLLEtBQUwsQ0FBVyxRQUFYLENBQW9CLEtBQW5DLEdBQTRDLEtBQUssS0FBTCxDQUFXLFFBQVgsQ0FBb0IsS0FBaEUsR0FBd0UsUUFBaEk7O0FBRUEsTUFBSSxzQkFBc0IsRUFBMUI7QUFDQSxNQUFJLFdBQVcsS0FBSyxJQUFMLENBQWY7O0FBRUEsTUFBSSxTQUFTLGVBQU8sS0FBUCxDQUFULElBQTBCLGVBQU8sS0FBUCxFQUFjLEtBQUssWUFBbkIsQ0FBOUIsRUFDRSxzQkFBc0IsZUFBTyxLQUFQLEVBQWMsS0FBSyxZQUFuQixDQUF0Qjs7QUFFRixNQUFJLFFBQVEsUUFBWixFQUFzQjtBQUNwQixRQUFJLFFBQVEsS0FBSyxRQUFqQixFQUNFLFdBQVcsS0FBSyxRQUFMLENBQWMsSUFBZCxDQUFYLENBREYsS0FFSyxJQUFJLHVCQUF1QixRQUFRLG1CQUFuQyxFQUNILFdBQVcsb0JBQW9CLElBQXBCLENBQVgsQ0FERyxLQUVBLFdBQVcsU0FBUyxJQUFULENBQVg7QUFDTjs7QUFFRCxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQWpCLEVBQ0UsT0FBTyxLQUFQOztBQUVGLE9BQUssSUFBTCxJQUFhLFFBQWI7QUFDQSxTQUFPLElBQVA7QUFDRCxDQTNCRDs7QUE2QkE7QUFDQSxlQUFlLFNBQWYsQ0FBeUIsWUFBekIsR0FBd0MsVUFBVSxNQUFWLEVBQWtCO0FBQ3hELE1BQUksQ0FBQyxLQUFLLGdCQUFWLEVBQ0UsTUFBTSxnQ0FBTjs7QUFFRixPQUFLLGdCQUFMLENBQXNCLE1BQXRCLElBQWdDLEtBQUssUUFBTCxDQUFjLE1BQWQsQ0FBaEM7QUFDRCxDQUxEOztBQU9BLGVBQWUsU0FBZixDQUF5QixjQUF6QixHQUEwQyxVQUFVLE1BQVYsRUFBa0I7QUFDMUQsTUFBSSxDQUFDLEtBQUssUUFBTCxDQUFjLFdBQW5CLEVBQ0UsS0FBSyxRQUFMLENBQWMsV0FBZCxHQUE0QixFQUE1Qjs7QUFFRixNQUFJLEtBQUssUUFBTCxDQUFjLFdBQWQsQ0FBMEIsTUFBMUIsQ0FBSixFQUNFLE9BQU8sSUFBUCxDQURGLEtBR0UsT0FBTyxLQUFQO0FBQ0gsQ0FSRDs7QUFVQSxlQUFlLFNBQWYsQ0FBeUIsZ0JBQXpCLEdBQTRDLFVBQVUsTUFBVixFQUFrQjtBQUM1RCxNQUFJLENBQUMsS0FBSyxnQkFBVixFQUNFLE1BQU0sZ0NBQU47O0FBRUYsTUFBSSxhQUFhLEVBQUUsS0FBSyxnQkFBTCxDQUFzQixNQUF0QixNQUFrQyxLQUFLLFFBQUwsQ0FBYyxNQUFkLENBQXBDLENBQWpCOztBQUVBLFNBQU8sVUFBUDtBQUNELENBUEQ7O0FBU0EsZUFBZSxTQUFmLENBQXlCLGdCQUF6QixHQUE0QyxVQUFVLFNBQVYsRUFBcUIsWUFBckIsRUFBbUMsT0FBbkMsRUFBNEM7QUFDdEYsTUFBSSxDQUFDLFNBQUQsSUFBYyxDQUFDLFlBQW5CLEVBQ0U7O0FBRUYsWUFBVSxXQUFXLElBQXJCOztBQUVBLE9BQUssZUFBTCxDQUFxQixTQUFyQixJQUFrQyxLQUFLLGVBQUwsQ0FBcUIsU0FBckIsS0FBbUMsRUFBckU7O0FBRUEsT0FBSyxlQUFMLENBQXFCLFNBQXJCLEVBQWdDLElBQWhDLENBQXFDLEVBQUUsU0FBUyxPQUFYLEVBQW9CLGNBQWMsWUFBbEMsRUFBckM7QUFDRCxDQVREOztBQVdBLGVBQWUsU0FBZixDQUF5QixtQkFBekIsR0FBK0MsVUFBVSxTQUFWLEVBQXFCLFlBQXJCLEVBQW1DO0FBQ2hGLE1BQUksQ0FBQyxTQUFELElBQWMsQ0FBQyxZQUFmLElBQStCLENBQUMsS0FBSyxlQUFMLENBQXFCLFNBQXJCLENBQXBDLEVBQ0U7O0FBRUYsTUFBSSxZQUFZLEtBQUssZUFBTCxDQUFxQixTQUFyQixDQUFoQjtBQUNBLE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxVQUFVLE1BQTlCLEVBQXNDLEdBQXRDLEVBQTJDOztBQUV6QyxRQUFJLFVBQVUsQ0FBVixFQUFhLFlBQWIsS0FBOEIsWUFBbEMsRUFBZ0Q7QUFDOUMsZ0JBQVUsQ0FBVixFQUFhLE1BQWIsQ0FBb0IsQ0FBcEIsRUFBdUIsQ0FBdkI7QUFDQTtBQUNEO0FBQ0Y7QUFDRixDQVpEOztBQWNBLGVBQWUsU0FBZixDQUF5Qix1QkFBekIsR0FBbUQsWUFBWTtBQUM3RCxPQUFLLGVBQUwsR0FBdUIsRUFBdkI7QUFDRCxDQUZEOztBQUlBLGVBQWUsU0FBZixDQUF5QixhQUF6QixHQUF5QyxVQUFVLFNBQVYsRUFBcUIsY0FBckIsRUFBcUMsT0FBckMsRUFBOEM7O0FBRXJGO0FBQ0EsTUFBSSxhQUFhLEtBQUssZUFBTCxDQUFxQixTQUFyQixDQUFqQixFQUFrRDs7QUFFbEQscUJBQWlCLGtCQUFrQixFQUFuQzs7QUFFQSxRQUFJLFlBQVksS0FBSyxlQUFMLENBQXFCLFNBQXJCLENBQWhCO0FBQ0EsU0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFVBQVUsTUFBOUIsRUFBc0MsR0FBdEMsRUFBMkM7O0FBRXpDLGdCQUFVLENBQVYsRUFBYSxZQUFiLENBQTBCLElBQTFCLENBQStCLFVBQVUsQ0FBVixFQUFhLE9BQTVDLEVBQXFELGNBQXJEO0FBQ0Q7QUFDRjs7QUFFQztBQUNBLE1BQUksT0FBUSxLQUFLLFNBQUwsQ0FBUixLQUE2QixVQUFqQyxFQUE2QztBQUMzQyxTQUFLLFNBQUwsRUFBZ0IsSUFBaEIsQ0FBcUIsV0FBVyxLQUFLLEtBQUwsQ0FBVyxxQkFBM0MsRUFBa0UsY0FBbEU7QUFDRDtBQUNGLENBbEJEOztrQkFvQmUsYzs7Ozs7Ozs7O0FDeEpmOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7O0FBQ0E7O0FBR0E7O0FBcUJBOzs7OztBQXZCQTs7QUE4Q0EsSUFBSSwrQkFBK0IsNkNBQW5DOztBQUVBLFNBQVMsS0FBVCxDQUFlLFdBQWYsRUFBNEIsT0FBNUIsRUFBcUMsb0JBQXJDLEVBQTJEOztBQUUxRCxNQUFLLHFCQUFMLEdBQTZCLG9CQUE3Qjs7QUFFQSxXQUFVLFdBQVcsRUFBckI7O0FBRUEsT0FBTSxJQUFOLENBQVcsV0FBWCxDQUF1QixJQUF2QixDQUE0QixJQUE1QixFQUFrQyxPQUFsQyxFQUEyQyxPQUEzQyxFQUFvRCxRQUFRLEtBQVIsR0FBZ0IsUUFBUSxLQUF4QixHQUFnQyxRQUFwRjs7QUFFQSxLQUFJLFFBQVEsSUFBWjs7QUFFQSxNQUFLLFlBQUwsR0FBb0IsV0FBcEI7QUFDQSxNQUFLLG1CQUFMLEdBQTJCLEtBQTNCO0FBQ0EsTUFBSyxHQUFMLEdBQVcsSUFBWDtBQUNBLE1BQUssaUJBQUwsR0FBeUIsSUFBekI7QUFDQSxNQUFLLFlBQUwsR0FBb0IsRUFBcEI7QUFDQSxNQUFLLFdBQUwsR0FBbUIsQ0FBbkI7QUFDQSxNQUFLLG1CQUFMLEdBQTJCLEVBQTNCO0FBQ0EsTUFBSyxjQUFMLEdBQXNCLElBQXRCO0FBQ0EsTUFBSyxXQUFMLEdBQW1CLEtBQW5CO0FBQ0EsTUFBSyxXQUFMLEdBQW1CLENBQW5CO0FBQ0EsTUFBSyxjQUFMLEdBQXNCLEtBQXRCO0FBQ0EsTUFBSyxjQUFMLEdBQXNCLEtBQXRCOztBQUdBLE1BQUssVUFBTCxHQUFrQixLQUFsQjtBQUNBLE1BQUssY0FBTCxHQUFzQixTQUF0QjtBQUNBLE1BQUssUUFBTCxHQUFnQixFQUFFLFFBQVEsSUFBVixFQUFnQixLQUFLLElBQXJCLEVBQTJCLElBQUksQ0FBL0IsRUFBa0MsSUFBSSxDQUF0QyxFQUF5QyxJQUFJLENBQTdDLEVBQWdELElBQUksQ0FBcEQsRUFBdUQsT0FBTyxDQUE5RCxFQUFpRSxRQUFRLENBQXpFLEVBQWhCO0FBQ0EsTUFBSyxvQkFBTCxHQUE0QixFQUE1Qjs7QUFFQSxNQUFLLFVBQUwsR0FBa0IsT0FBUSxLQUFLLFlBQWIsS0FBK0IsUUFBL0IsR0FBMEMsU0FBUyxjQUFULENBQXdCLEtBQUssWUFBN0IsQ0FBMUMsR0FBdUYsS0FBSyxZQUE5Rzs7QUFFQSxLQUFJLENBQUMsS0FBSyxVQUFWLEVBQXNCO0FBQ3JCLE1BQUksT0FBTyxPQUFYLEVBQ0MsT0FBTyxPQUFQLENBQWUsR0FBZixDQUFtQiwrQ0FBK0MsS0FBSyxZQUFwRCxHQUFtRSxrQkFBdEY7QUFDRDtBQUNBOztBQUVELE1BQUssVUFBTCxDQUFnQixTQUFoQixHQUE0QixFQUE1Qjs7QUFFQSxLQUFJLFFBQVEsQ0FBWjtBQUNBLEtBQUksU0FBUyxDQUFiOztBQUVBLEtBQUksS0FBSyxRQUFMLENBQWMsS0FBbEIsRUFDQyxRQUFRLEtBQUssS0FBYixDQURELEtBR0MsUUFBUSxLQUFLLFVBQUwsQ0FBZ0IsV0FBaEIsR0FBOEIsQ0FBOUIsR0FBa0MsS0FBSyxVQUFMLENBQWdCLFdBQWxELEdBQWdFLEtBQUssS0FBN0U7O0FBRUQsS0FBSSxLQUFLLFFBQUwsQ0FBYyxNQUFsQixFQUNDLFNBQVMsS0FBSyxNQUFkLENBREQsS0FHQyxTQUFTLEtBQUssVUFBTCxDQUFnQixZQUFoQixHQUErQixDQUEvQixHQUFtQyxLQUFLLFVBQUwsQ0FBZ0IsWUFBbkQsR0FBa0UsS0FBSyxNQUFoRjs7QUFFRCxNQUFLLEtBQUwsR0FBYSxLQUFiO0FBQ0EsTUFBSyxNQUFMLEdBQWMsTUFBZDs7QUFFQSxNQUFLLEVBQUwsR0FBVSxLQUFLLEVBQUwsR0FBVSxDQUFwQjtBQUNBLE1BQUssRUFBTCxHQUFVLEtBQUssS0FBZjtBQUNBLE1BQUssRUFBTCxHQUFVLEtBQUssTUFBZjs7QUFHQSxNQUFLLGlCQUFMLEdBQXlCLE9BQVEsa0JBQVUsS0FBSyxRQUFmLENBQVIsS0FBc0MsV0FBdEMsR0FBb0Qsa0JBQVUsS0FBSyxRQUFmLENBQXBELEdBQStFLGtCQUFVLFdBQVYsQ0FBeEc7O0FBRUEsTUFBSyxrQkFBTCxHQUEwQixTQUFTLGFBQVQsQ0FBdUIsS0FBdkIsQ0FBMUI7QUFDQSxNQUFLLGtCQUFMLENBQXdCLFlBQXhCLENBQXFDLE9BQXJDLEVBQThDLDBCQUE5Qzs7QUFFQSxNQUFLLGtCQUFMLENBQXdCLEtBQXhCLENBQThCLFFBQTlCLEdBQXlDLFVBQXpDO0FBQ0EsTUFBSyxrQkFBTCxDQUF3QixLQUF4QixDQUE4QixTQUE5QixHQUEwQyxNQUExQztBQUNBLE1BQUssa0JBQUwsQ0FBd0IsS0FBeEIsQ0FBOEIsTUFBOUIsR0FBdUMsTUFBdkM7O0FBRUEsS0FBSSxDQUFDLHdCQUFMLEVBQXdCO0FBQ3ZCLE9BQUssa0JBQUwsQ0FBd0IsS0FBeEIsQ0FBOEIsTUFBOUIsR0FBdUMsS0FBdkMsQ0FEdUIsQ0FDc0I7QUFDN0M7QUFDRCxNQUFLLFVBQUwsQ0FBZ0IsV0FBaEIsQ0FBNEIsS0FBSyxrQkFBakM7O0FBR0EsTUFBSyxNQUFMLEdBQWMseUJBQWEsS0FBYixFQUFvQixNQUFwQixDQUFkOztBQUVBLE1BQUssTUFBTCxDQUFZLEtBQVosQ0FBa0IsUUFBbEIsR0FBNkIsVUFBN0I7QUFDQSxLQUFJLEtBQUssTUFBTCxDQUFZLFVBQWhCLEVBQTRCO0FBQzNCO0FBQ0E7QUFDQTtBQUNBLE9BQUssa0JBQUwsQ0FBd0IsV0FBeEIsQ0FBb0MsS0FBSyxNQUF6QztBQUNBLE9BQUssR0FBTCxHQUFXLEtBQUssTUFBTCxDQUFZLFVBQVosQ0FBdUIsSUFBdkIsQ0FBWDtBQUNBLE9BQUssR0FBTCxDQUFTLFlBQVQsR0FBd0IsS0FBeEI7QUFDQSx3QkFBVSxLQUFLLEdBQWY7QUFFQSxFQVRELE1BU087O0FBRVA7O0FBRUEsS0FBSSxDQUFDLHdCQUFMLEVBQXdCO0FBQ3ZCLE9BQUssUUFBTCxDQUFjLE1BQWQsR0FBdUIseUJBQWEsS0FBYixFQUFvQixNQUFwQixDQUF2QjtBQUNBLE9BQUssUUFBTCxDQUFjLE1BQWQsQ0FBcUIsS0FBckIsQ0FBMkIsUUFBM0IsR0FBc0MsVUFBdEM7QUFDQSxPQUFLLFFBQUwsQ0FBYyxNQUFkLENBQXFCLFlBQXJCLENBQWtDLE9BQWxDLEVBQTJDLGdCQUEzQztBQUNBLE9BQUssa0JBQUwsQ0FBd0IsV0FBeEIsQ0FBb0MsS0FBSyxRQUFMLENBQWMsTUFBbEQ7O0FBRUEsT0FBSyxRQUFMLENBQWMsR0FBZCxHQUFvQixLQUFLLFFBQUwsQ0FBYyxNQUFkLENBQXFCLFVBQXJCLENBQWdDLElBQWhDLENBQXBCO0FBQ0EsRUFQRCxNQU9PO0FBQ04sT0FBSyxRQUFMLENBQWMsR0FBZCxHQUFvQixLQUFLLEdBQXpCO0FBQ0E7O0FBRUQsTUFBSyxjQUFMLEdBQXNCLHlCQUFhLEtBQWIsRUFBb0IsTUFBcEIsQ0FBdEI7QUFDQSxNQUFLLGNBQUwsQ0FBb0IsS0FBcEIsQ0FBMEIsUUFBMUIsR0FBcUMsVUFBckM7QUFDQSxNQUFLLGtCQUFMLENBQXdCLFdBQXhCLENBQW9DLEtBQUssY0FBekM7QUFDQSxNQUFLLGlCQUFMLEdBQXlCLEtBQUssY0FBTCxDQUFvQixVQUFwQixDQUErQixJQUEvQixDQUF6QjtBQUNBLE1BQUssaUJBQUwsQ0FBdUIsWUFBdkIsR0FBc0MsS0FBdEM7O0FBRUEsTUFBSyxhQUFMLEdBQXFCLElBQUksdUJBQUosQ0FBaUIsSUFBakIsQ0FBckI7O0FBRUEsc0JBQVMsTUFBVCxFQUFpQixRQUFqQixFQUEyQixZQUFZO0FBQ3RDOztBQUVBLE1BQUksTUFBTSxXQUFOLEVBQUosRUFDQyxNQUFNLE1BQU47QUFDRCxFQUxEOztBQVFBLE1BQUssUUFBTCxHQUFnQixTQUFTLGFBQVQsQ0FBdUIsS0FBdkIsQ0FBaEI7QUFDQSxNQUFLLFFBQUwsQ0FBYyxZQUFkLENBQTJCLE9BQTNCLEVBQW9DLHdCQUFwQztBQUNBLE1BQUssUUFBTCxDQUFjLEtBQWQsQ0FBb0IsT0FBcEIsR0FBOEIsMkNBQTlCO0FBQ0EsTUFBSyxrQkFBTCxDQUF3QixXQUF4QixDQUFvQyxLQUFLLFFBQXpDOztBQUdBLE1BQUssTUFBTCxHQUFjLEVBQUUsSUFBSSxDQUFOLEVBQVMsSUFBSSxDQUFiLEVBQWdCLElBQUksS0FBSyxLQUF6QixFQUFnQyxJQUFJLEtBQUssTUFBekMsRUFBZDs7QUFFQSxzQkFBUyxLQUFLLGNBQWQsRUFBOEIsT0FBOUIsRUFBdUMsVUFBVSxDQUFWLEVBQWE7QUFDbkQsUUFBTSxrQkFBTixDQUF5QixDQUF6QjtBQUNBLEVBRkQ7O0FBSUEsc0JBQVMsS0FBSyxjQUFkLEVBQThCLFdBQTlCLEVBQTJDLFVBQVUsQ0FBVixFQUFhO0FBQ3ZELFFBQU0sa0JBQU4sQ0FBeUIsQ0FBekI7QUFDQSxFQUZEOztBQUlBLHNCQUFTLEtBQUssY0FBZCxFQUE4QixTQUE5QixFQUF5QyxVQUFVLENBQVYsRUFBYTtBQUNyRCxRQUFNLGtCQUFOLENBQXlCLENBQXpCO0FBQ0EsRUFGRDs7QUFJQSxzQkFBUyxLQUFLLGNBQWQsRUFBOEIsV0FBOUIsRUFBMkMsVUFBVSxDQUFWLEVBQWE7QUFDdkQsUUFBTSxrQkFBTixDQUF5QixDQUF6QjtBQUNBLG1CQUFLLE1BQU0sYUFBWDtBQUNBLEVBSEQ7O0FBS0Esc0JBQVMsS0FBSyxjQUFkLEVBQThCLFVBQTlCLEVBQTBDLFVBQVUsQ0FBVixFQUFhO0FBQ3RELFFBQU0sa0JBQU4sQ0FBeUIsQ0FBekI7QUFDQSxFQUZEOztBQUtBLHNCQUFTLEtBQUssY0FBZCxFQUE4QixPQUFPLFNBQVAsQ0FBaUIsZ0JBQWpCLEdBQW9DLGVBQXBDLEdBQXNELFlBQXBGLEVBQWtHLFVBQVUsQ0FBVixFQUFhO0FBQzlHLFFBQU0sa0JBQU4sQ0FBeUIsQ0FBekI7QUFDQSxFQUZEOztBQUlBLHNCQUFTLEtBQUssY0FBZCxFQUE4QixPQUFPLFNBQVAsQ0FBaUIsZ0JBQWpCLEdBQW9DLGVBQXBDLEdBQXNELFdBQXBGLEVBQWlHLFVBQVUsQ0FBVixFQUFhO0FBQzdHLFFBQU0sa0JBQU4sQ0FBeUIsQ0FBekI7QUFDQSxFQUZEOztBQUlBLHNCQUFTLEtBQUssY0FBZCxFQUE4QixPQUFPLFNBQVAsQ0FBaUIsZ0JBQWpCLEdBQW9DLGFBQXBDLEdBQW9ELFVBQWxGLEVBQThGLFVBQVUsQ0FBVixFQUFhO0FBQzFHLFFBQU0sa0JBQU4sQ0FBeUIsQ0FBekI7QUFDQSxFQUZEOztBQUlBLHNCQUFTLEtBQUssY0FBZCxFQUE4QixPQUFPLFNBQVAsQ0FBaUIsZ0JBQWpCLEdBQW9DLGlCQUFwQyxHQUF3RCxhQUF0RixFQUFxRyxVQUFVLENBQVYsRUFBYTtBQUNqSCxRQUFNLGtCQUFOLENBQXlCLENBQXpCO0FBQ0EsRUFGRDs7QUFJQSxLQUFJLENBQUMsS0FBSyxXQUFWLEVBQXVCOztBQUV0QixPQUFLLFdBQUwsR0FBbUIsU0FBUyxhQUFULENBQXVCLEdBQXZCLENBQW5CO0FBQ0EsT0FBSyxXQUFMLENBQWlCLFlBQWpCLENBQThCLE9BQTlCLEVBQXVDLHVCQUF2QztBQUNBLE9BQUssV0FBTCxDQUFpQixZQUFqQixDQUE4QixPQUE5QixFQUF1Qyw4REFBOEQsS0FBSyxNQUFMLEdBQWMsRUFBNUUsSUFBa0Ysd0hBQXpIOztBQUVBLE9BQUssV0FBTCxDQUFpQixZQUFqQixDQUE4QixVQUE5QixFQUEwQyxDQUFDLENBQTNDOztBQUVBLE9BQUssV0FBTCxDQUFpQixZQUFqQixDQUE4QixRQUE5QixFQUF3QyxRQUF4QztBQUNBOztBQUVELE1BQUssUUFBTCxHQUFnQixJQUFJLGlCQUFKLENBQVksSUFBWixFQUFrQixLQUFLLFFBQUwsQ0FBYyxPQUFoQyxFQUF5QyxLQUFLLEtBQTlDLENBQWhCOztBQUVBLE1BQUssSUFBTCxHQUFZLElBQVo7QUFDQSxNQUFLLEtBQUwsR0FBYSxJQUFiO0FBQ0EsTUFBSyxLQUFMLEdBQWEsSUFBYjtBQUNBLE1BQUssTUFBTCxHQUFjLElBQWQ7O0FBRUEsTUFBSyxnQkFBTCxHQUF3QjtBQUN2QixTQUFPLEVBRGdCO0FBRXZCLFNBQU8sRUFGZ0I7QUFHdkIsVUFBUTtBQUhlLEVBQXhCO0FBS0E7O0FBRUQsbUJBQU8sS0FBUCxFQUFjLGtCQUFkOztBQUVBO0FBQ0EsTUFBTSxTQUFOLENBQWdCLGNBQWhCLEdBQWlDLFlBQVk7O0FBRTVDLEtBQUksUUFBUSxJQUFaOztBQUVBLE1BQUssWUFBTCxDQUFrQixPQUFsQjtBQUNBLE1BQUssWUFBTCxDQUFrQixRQUFsQjtBQUNBLE1BQUssWUFBTCxDQUFrQixtQkFBbEI7QUFDQSxNQUFLLFlBQUwsQ0FBa0Isc0JBQWxCO0FBQ0EsTUFBSyxZQUFMLENBQWtCLE9BQWxCOztBQUVBLEtBQUksS0FBSyxZQUFMLENBQWtCLFVBQWxCLENBQUosRUFDQyxLQUFLLGlCQUFMLEdBQXlCLE9BQVEsa0JBQVUsS0FBSyxRQUFmLENBQVIsS0FBc0MsV0FBdEMsR0FBb0Qsa0JBQVUsS0FBSyxRQUFmLENBQXBELEdBQStFLGtCQUFVLFdBQVYsQ0FBeEc7O0FBRUQsTUFBSyxZQUFMLENBQWtCLGlCQUFsQjtBQUNBLEtBQUksQ0FBQyxLQUFLLGVBQVYsRUFDQyxLQUFLLGVBQUwsR0FBdUIsZUFBdkI7O0FBRUQsTUFBSyxZQUFMLENBQWtCLFNBQWxCO0FBQ0EsTUFBSyxZQUFMLEdBQW9CLElBQUksc0JBQUosQ0FBZ0IsS0FBSyxRQUFMLENBQWMsT0FBOUIsQ0FBcEI7O0FBRUEsTUFBSyxZQUFMLENBQWtCLGtCQUFsQjtBQUNBLE1BQUssZ0JBQUwsR0FBd0IsS0FBSyxnQkFBTCxJQUF5Qix3QkFBakQ7QUFDQSxNQUFLLFlBQUwsQ0FBa0IsbUJBQWxCOztBQUVBLE1BQUssWUFBTCxDQUFrQixlQUFsQjtBQUNBLE1BQUssWUFBTCxDQUFrQixjQUFsQjs7QUFFQTtBQUNBLEtBQUksS0FBSyxRQUFMLENBQWMsV0FBbEIsRUFBK0I7O0FBRTlCLE1BQUksQ0FBQyxLQUFLLFdBQVYsRUFBdUI7O0FBRXRCLG9CQUFLLEtBQUssV0FBTCxHQUFtQixTQUFTLGFBQVQsQ0FBdUIsUUFBdkIsQ0FBeEI7O0FBRUEsa0JBQWUsSUFBZixFQUFxQixLQUFLLFdBQTFCLEVBQXVDLEtBQXZDOztBQUVBLFFBQUssUUFBTCxDQUFjLFdBQWQsQ0FBMEIsS0FBSyxXQUEvQjtBQUNBLHdCQUFTLEtBQUssV0FBZCxFQUEyQixPQUEzQixFQUFvQyxZQUFZO0FBQy9DLFFBQUksTUFBTSxXQUFWLEVBQXVCO0FBQ3RCLFdBQU0sV0FBTixHQUFvQixLQUFwQjtBQUNBLFdBQU0sVUFBTixHQUFtQixJQUFuQjs7QUFFQSxvQkFBZSxLQUFmLEVBQXNCLE1BQU0sV0FBNUIsRUFBeUMsTUFBekM7QUFFQSxLQU5ELE1BTU87QUFDTixXQUFNLFdBQU4sR0FBb0IsSUFBcEI7QUFDQSxXQUFNLFVBQU4sR0FBbUIsS0FBbkI7O0FBRUEsb0JBQWUsS0FBZixFQUFzQixNQUFNLFdBQTVCLEVBQXlDLEtBQXpDO0FBQ0E7O0FBRUQsVUFBTSxNQUFOO0FBQ0EsSUFmRDtBQWdCQTs7QUFHRCxNQUFJLENBQUMsS0FBSyxZQUFWLEVBQXdCO0FBQ3ZCLG9CQUFLLEtBQUssWUFBTCxHQUFvQixTQUFTLGFBQVQsQ0FBdUIsUUFBdkIsQ0FBekI7QUFDQSxrQkFBZSxJQUFmLEVBQXFCLEtBQUssWUFBMUIsRUFBd0MsT0FBeEM7QUFDQSxRQUFLLFFBQUwsQ0FBYyxXQUFkLENBQTBCLEtBQUssWUFBL0I7O0FBRUEsd0JBQVMsS0FBSyxZQUFkLEVBQTRCLE9BQTVCLEVBQXFDLFlBQVk7O0FBRWhELFVBQU0sUUFBTixDQUFlLElBQWY7O0FBRUEsUUFBSSxNQUFNLFdBQU4sSUFBcUIsTUFBTSxVQUEvQixFQUEyQztBQUMxQyxXQUFNLFdBQU4sR0FBb0IsSUFBcEI7QUFDQSxXQUFNLFVBQU4sR0FBbUIsS0FBbkI7QUFDQSxvQkFBZSxLQUFmLEVBQXNCLE1BQU0sV0FBNUIsRUFBeUMsS0FBekM7O0FBRUEsV0FBTSxjQUFOLEdBQXVCLFNBQXZCO0FBQ0EsV0FBTSxjQUFOLENBQXFCLEtBQXJCLENBQTJCLE1BQTNCLEdBQW9DLE1BQU0sY0FBMUM7QUFDQSxLQVBELE1BT087QUFDTixXQUFNLFdBQU4sR0FBb0IsS0FBcEI7QUFDQSxXQUFNLFVBQU4sR0FBbUIsS0FBbkI7QUFDQTtBQUNEO0FBQ0EsUUFBSSxNQUFNLGdCQUFOLENBQXVCLEtBQTNCLEVBQWtDO0FBQ2pDLFdBQU0sZ0JBQU4sQ0FBdUIsS0FBdkIsQ0FBNkIsa0JBQTdCLEdBQWtELElBQWxEO0FBQ0EsV0FBTSxnQkFBTixDQUF1QixLQUF2QixDQUE2QixrQkFBN0IsR0FBa0QsSUFBbEQ7QUFDQTs7QUFFRDtBQUNBLFFBQUksTUFBTSxnQkFBTixDQUF1QixLQUEzQixFQUFrQztBQUNqQyxXQUFNLGdCQUFOLENBQXVCLEtBQXZCLENBQTZCLGtCQUE3QixHQUFrRCxJQUFsRDtBQUNBLFdBQU0sZ0JBQU4sQ0FBdUIsS0FBdkIsQ0FBNkIsa0JBQTdCLEdBQWtELElBQWxEO0FBQ0E7O0FBRUQ7QUFDQSxRQUFJLE1BQU0sZ0JBQU4sQ0FBdUIsTUFBM0IsRUFBbUM7QUFDbEMsV0FBTSxnQkFBTixDQUF1QixNQUF2QixDQUE4QixrQkFBOUIsR0FBbUQsSUFBbkQ7QUFDQSxXQUFNLGdCQUFOLENBQXVCLE1BQXZCLENBQThCLGtCQUE5QixHQUFtRCxJQUFuRDtBQUNBOztBQUVELFVBQU0sb0JBQU47O0FBRUEscUJBQUssTUFBTSxXQUFYLEVBQXdCLE1BQU0sWUFBOUI7O0FBRUEsVUFBTSxtQkFBTixDQUEwQixlQUExQixFQUEyQyxPQUEzQztBQUNBLFVBQU0sTUFBTjtBQUNBLFVBQU0sbUJBQU4sQ0FBMEIsY0FBMUIsRUFBMEMsT0FBMUM7QUFDQSxJQXhDRDs7QUEwQ0EsUUFBSyxjQUFMLENBQW9CLEtBQXBCLENBQTBCLE1BQTFCLEdBQW1DLE1BQU0sY0FBekM7QUFDQTs7QUFFRCxNQUFJLENBQUMsS0FBSyxXQUFOLElBQXFCLENBQUMsS0FBSyxVQUEvQixFQUEyQztBQUMxQyxPQUFJLENBQUMsS0FBSyxXQUFWLEVBQXVCO0FBQ3RCLFNBQUssV0FBTCxHQUFtQixJQUFuQjtBQUNBLFNBQUssVUFBTCxHQUFrQixLQUFsQjtBQUNBLElBSEQsTUFHTzs7QUFFTixRQUFJLE1BQU0sV0FBTixDQUFrQixZQUFsQixDQUErQixPQUEvQixNQUE0QyxNQUFNLFlBQU4sQ0FBbUIsUUFBbkUsRUFBNkU7QUFDNUUsVUFBSyxVQUFMLEdBQWtCLElBQWxCO0FBQ0EsVUFBSyxXQUFMLEdBQW1CLEtBQW5CO0FBQ0EsS0FIRCxNQUlLO0FBQ0osVUFBSyxXQUFMLEdBQW1CLElBQW5CO0FBQ0EsVUFBSyxVQUFMLEdBQWtCLEtBQWxCO0FBQ0E7O0FBRUQscUJBQUssTUFBTSxXQUFYLEVBQXdCLE1BQU0sWUFBOUI7QUFDQTtBQUNEO0FBSUQsRUFuR0QsTUFtR087QUFDTixPQUFLLFdBQUwsR0FBbUIsS0FBbkI7QUFDQSxPQUFLLFVBQUwsR0FBa0IsS0FBbEI7QUFDQTs7QUFJRCxLQUFJLEtBQUssV0FBVCxFQUFzQjtBQUNyQixNQUFJLEtBQUssYUFBVCxFQUNDLGlCQUFLLEtBQUssV0FBVixFQURELEtBR0MsaUJBQUssS0FBSyxXQUFWO0FBQ0QsRUFMRCxNQUtPLElBQUksS0FBSyxhQUFMLElBQXNCLHdCQUExQixFQUE2QztBQUNuRCxPQUFLLFdBQUwsR0FBbUIsU0FBUyxhQUFULENBQXVCLFFBQXZCLENBQW5CO0FBQ0EsaUJBQWUsSUFBZixFQUFxQixLQUFLLFdBQTFCLEVBQXVDLE1BQXZDO0FBQ0EsT0FBSyxRQUFMLENBQWMsV0FBZCxDQUEwQixLQUFLLFdBQS9COztBQUVBLHVCQUFTLEtBQUssV0FBZCxFQUEyQixPQUEzQixFQUFvQyxZQUFZO0FBQy9DLE9BQUksTUFBTSxhQUFOLENBQW9CLEtBQXBCLENBQTBCLE9BQTFCLEtBQXNDLE1BQTFDLEVBQWtEOztBQUVqRCxRQUFJLE1BQU0sa0JBQU4sSUFBOEIsSUFBSSxJQUFKLEVBQUQsQ0FBYSxPQUFiLEtBQXlCLE1BQU0sa0JBQU4sQ0FBeUIsT0FBekIsRUFBekIsSUFBK0QsR0FBaEcsRUFDQzs7QUFFRCxVQUFNLGFBQU4sQ0FBb0IsS0FBcEIsQ0FBMEIsT0FBMUIsR0FBb0MsT0FBcEM7QUFDQSxVQUFNLFdBQU4sQ0FBa0IsSUFBbEI7QUFDQSxVQUFNLGFBQU4sQ0FBb0IsS0FBcEI7QUFDQTtBQUVELEdBWEQsRUFXRyxJQVhIO0FBWUE7O0FBR0QsS0FBSSxDQUFDLEtBQUssYUFBTixJQUF1QixLQUFLLGFBQTVCLElBQTZDLHdCQUFqRCxFQUFvRTtBQUNuRSxPQUFLLGFBQUwsR0FBcUIsU0FBUyxhQUFULENBQXVCLEtBQXZCLENBQXJCO0FBQ0EsT0FBSyxhQUFMLENBQW1CLFlBQW5CLENBQWdDLFVBQWhDLEVBQTRDLENBQUMsQ0FBN0M7QUFDQSxPQUFLLGFBQUwsQ0FBbUIsS0FBbkIsQ0FBeUIsT0FBekIsR0FBbUMsMlhBQW5DO0FBQ0EsUUFBTSxhQUFOLENBQW9CLEtBQXBCLENBQTBCLE9BQTFCLEdBQW9DLE1BQXBDO0FBQ0EsT0FBSyxRQUFMLENBQWMsV0FBZCxDQUEwQixLQUFLLGFBQS9COztBQUVBLHVCQUFTLEtBQUssYUFBZCxFQUE2QixNQUE3QixFQUFxQyxZQUFZO0FBQ2hELG9CQUFLLE1BQU0sYUFBWDs7QUFFQSxTQUFNLGtCQUFOLEdBQTJCLElBQUksSUFBSixFQUEzQjtBQUNBLEdBSkQsRUFJRyxJQUpIOztBQU1BLE1BQUksZUFBZSxTQUFTLGFBQVQsQ0FBdUIsS0FBdkIsQ0FBbkI7QUFDQSxlQUFhLEtBQWIsQ0FBbUIsT0FBbkIsR0FBNkIsNEJBQTdCO0FBQ0EsZUFBYSxTQUFiLEdBQXlCLEtBQUssWUFBTCxDQUFrQixXQUEzQztBQUNBLE9BQUssYUFBTCxDQUFtQixXQUFuQixDQUErQixZQUEvQjs7QUFFQSx1QkFBUyxZQUFULEVBQXVCLFdBQXZCLEVBQW9DLFlBQVk7QUFDL0MsUUFBSyxLQUFMLENBQVcsZUFBWCxHQUE2QixTQUE3QjtBQUNBLEdBRkQsRUFFRyxJQUZIOztBQUlBLHVCQUFTLFlBQVQsRUFBdUIsVUFBdkIsRUFBbUMsWUFBWTtBQUM5QyxRQUFLLEtBQUwsQ0FBVyxlQUFYLEdBQTZCLGFBQTdCO0FBQ0EsR0FGRCxFQUVHLElBRkg7O0FBSUEsdUJBQVMsWUFBVCxFQUF1QixPQUF2QixFQUFnQyxZQUFZO0FBQzNDLGdCQUFhLE1BQU0sTUFBbkIsRUFBMkIsS0FBM0IsRUFBa0MsTUFBTSxjQUF4QztBQUNBLG9CQUFLLE1BQU0sYUFBWDtBQUNBLEdBSEQsRUFHRyxJQUhIOztBQUtBLE1BQUksZUFBZSxTQUFTLGFBQVQsQ0FBdUIsS0FBdkIsQ0FBbkI7QUFDQSxlQUFhLEtBQWIsQ0FBbUIsT0FBbkIsR0FBNkIsNEJBQTdCO0FBQ0EsZUFBYSxTQUFiLEdBQXlCLEtBQUssWUFBTCxDQUFrQixXQUEzQztBQUNBLE9BQUssYUFBTCxDQUFtQixXQUFuQixDQUErQixZQUEvQjs7QUFFQSx1QkFBUyxZQUFULEVBQXVCLFdBQXZCLEVBQW9DLFlBQVk7QUFDL0MsUUFBSyxLQUFMLENBQVcsZUFBWCxHQUE2QixTQUE3QjtBQUNBLEdBRkQsRUFFRyxJQUZIOztBQUlBLHVCQUFTLFlBQVQsRUFBdUIsVUFBdkIsRUFBbUMsWUFBWTtBQUM5QyxRQUFLLEtBQUwsQ0FBVyxlQUFYLEdBQTZCLGFBQTdCO0FBQ0EsR0FGRCxFQUVHLElBRkg7O0FBSUEsdUJBQVMsWUFBVCxFQUF1QixPQUF2QixFQUFnQyxZQUFZO0FBQzNDLGdCQUFhLE1BQU0sTUFBbkIsRUFBMkIsS0FBM0IsRUFBa0MsTUFBTSxjQUF4QztBQUNBLG9CQUFLLE1BQU0sYUFBWDtBQUNBLEdBSEQsRUFHRyxJQUhIO0FBSUE7O0FBR0QsS0FBSSxLQUFLLFFBQUwsQ0FBYyxLQUFkLENBQW9CLE9BQXBCLEtBQWdDLE1BQWhDLElBQTBDLEtBQUssV0FBbkQsRUFBZ0U7O0FBRS9ELE9BQUssVUFBTCxHQUFrQixlQUFlLEtBQWYsRUFBc0IsTUFBTSxXQUE1QixFQUF5QyxNQUF6QyxDQUFsQixHQUFxRSxlQUFlLEtBQWYsRUFBc0IsTUFBTSxXQUE1QixFQUF5QyxLQUF6QyxDQUFyRTs7QUFHQSxNQUFJLE1BQU0sWUFBTixDQUFtQixZQUFuQixDQUFnQyxPQUFoQyxNQUE2QyxNQUFNLFlBQU4sQ0FBbUIsU0FBcEUsRUFDQyxlQUFlLEtBQWYsRUFBc0IsTUFBTSxZQUE1QixFQUEwQyxPQUExQztBQUNEOztBQUVELEtBQUksT0FBUSx3QkFBZSxLQUFmLENBQXFCLFVBQTdCLEtBQTZDLFdBQWpELEVBQThEO0FBQzdELE9BQUssVUFBTCxHQUFrQixzQkFBbEI7QUFDQSxPQUFLLFVBQUwsR0FBa0IsY0FBbEI7QUFDQSxFQUhELE1BR087QUFDTixNQUFJLG9CQUFvQixLQUFLLFlBQUwsQ0FBa0IsWUFBbEIsQ0FBeEI7QUFDQSxNQUFJLG9CQUFvQixLQUFLLFlBQUwsQ0FBa0IsWUFBbEIsQ0FBeEI7QUFDQTs7QUFFRCxLQUFJLEtBQUssV0FBTCxLQUFxQixDQUFyQixJQUEyQixxQkFBcUIsaUJBQXBELEVBQXdFO0FBQ3ZFLE9BQUssV0FBTCxDQUFpQixZQUFqQixDQUE4QixNQUE5QixFQUFzQyxLQUFLLFVBQTNDO0FBQ0EsT0FBSyxXQUFMLENBQWlCLFNBQWpCLEdBQTZCLEtBQUssVUFBbEM7QUFDQTs7QUFFRCxLQUFJLEtBQUssVUFBTCxJQUFtQixLQUFLLFVBQTVCLEVBQXdDO0FBQ3ZDLE1BQUksQ0FBQyxLQUFLLFdBQUwsQ0FBaUIsYUFBdEIsRUFDQyxLQUFLLGtCQUFMLENBQXdCLFdBQXhCLENBQW9DLEtBQUssV0FBekM7QUFDRCxFQUhELE1BSUssSUFBSSxLQUFLLFdBQUwsQ0FBaUIsYUFBckIsRUFDSixLQUFLLGtCQUFMLENBQXdCLFdBQXhCLENBQW9DLEtBQUssV0FBekM7O0FBRUQsS0FBSSxLQUFLLFFBQUwsQ0FBYyxPQUFkLElBQXlCLEtBQUssUUFBTCxDQUFjLFFBQWQsS0FBMkIsS0FBSyxRQUFMLENBQWMsT0FBdEUsRUFDQyxLQUFLLFFBQUwsQ0FBYyxRQUFkLEdBQXlCLEtBQUssUUFBTCxDQUFjLE9BQXZDOztBQUVELE1BQUssSUFBSSxJQUFULElBQWlCLEtBQUssUUFBTCxDQUFjLFFBQS9CLEVBQXlDOztBQUV4QyxNQUFJLEtBQUssUUFBTCxDQUFjLFFBQWQsQ0FBdUIsY0FBdkIsQ0FBc0MsSUFBdEMsQ0FBSixFQUFpRDtBQUNoRCxRQUFLLFFBQUwsQ0FBYyxZQUFkLENBQTJCLElBQTNCO0FBQ0E7QUFDRDtBQUVELENBelBEOztBQTJQQSxNQUFNLFNBQU4sQ0FBZ0IsV0FBaEIsR0FBOEIsWUFBWTtBQUN6QyxLQUFJLFFBQVEsQ0FBWjtBQUNBLEtBQUksU0FBUyxDQUFiOztBQUVBLEtBQUksS0FBSyxRQUFMLENBQWMsS0FBbEIsRUFDQyxRQUFRLEtBQUssS0FBYixDQURELEtBR0MsS0FBSyxLQUFMLEdBQWEsUUFBUSxLQUFLLFVBQUwsQ0FBZ0IsV0FBaEIsR0FBOEIsQ0FBOUIsR0FBa0MsS0FBSyxVQUFMLENBQWdCLFdBQWxELEdBQWdFLEtBQUssS0FBMUY7O0FBRUQsS0FBSSxLQUFLLFFBQUwsQ0FBYyxNQUFsQixFQUNDLFNBQVMsS0FBSyxNQUFkLENBREQsS0FHQyxLQUFLLE1BQUwsR0FBYyxTQUFTLEtBQUssVUFBTCxDQUFnQixZQUFoQixHQUErQixDQUEvQixHQUFtQyxLQUFLLFVBQUwsQ0FBZ0IsWUFBbkQsR0FBa0UsS0FBSyxNQUE5Rjs7QUFFRCxLQUFJLEtBQUssTUFBTCxDQUFZLEtBQVosS0FBc0IsUUFBUSw0QkFBOUIsSUFBOEQsS0FBSyxNQUFMLENBQVksTUFBWixLQUF1QixTQUFTLDRCQUFsRyxFQUFnSTtBQUMvSCw0QkFBYyxLQUFLLE1BQW5CLEVBQTJCLEtBQTNCLEVBQWtDLE1BQWxDOztBQUVBLDRCQUFjLEtBQUssY0FBbkIsRUFBbUMsS0FBbkMsRUFBMEMsTUFBMUM7QUFDQSw0QkFBYyxLQUFLLGFBQUwsQ0FBbUIsV0FBakMsRUFBOEMsS0FBOUMsRUFBcUQsTUFBckQ7O0FBRUEsU0FBTyxJQUFQO0FBQ0E7O0FBRUQsUUFBTyxLQUFQO0FBQ0EsQ0F4QkQ7O0FBMEJBO0FBQ0EsTUFBTSxTQUFOLENBQWdCLFdBQWhCLEdBQThCLFlBQVk7QUFDekM7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsS0FBSSxDQUFDLEtBQUssU0FBVixFQUNDLEtBQUssU0FBTCxHQUFpQixJQUFJLGtCQUFKLENBQWEsSUFBYixDQUFqQixDQURELEtBRUs7QUFDSixPQUFLLFNBQUwsQ0FBZSxtQkFBZjtBQUNBOztBQUVELE1BQUssdUJBQUw7O0FBRUEsTUFBSyxjQUFMLEdBQXNCLEtBQXRCOztBQUVBLE1BQUssS0FBTCxHQUFhLEVBQWI7O0FBRUEsTUFBSyx1QkFBTCxHQUErQixJQUEvQjtBQUNBOztBQUVBLEtBQUksS0FBSyxrQkFBVCxFQUNDLEtBQUssc0JBQUwsQ0FBNEIsSUFBNUIsQ0FBaUMsTUFBakMsRUFBeUMsS0FBSyxrQkFBOUM7O0FBRUQsTUFBSyxjQUFMOztBQUVBLE1BQUssY0FBTCxHQUFzQiw0QkFBcUIsS0FBSyxnQkFBMUIsSUFBK0MsS0FBSyxXQUFMLEtBQXFCLENBQTFGOztBQUVBLE1BQUssV0FBTDs7QUFFQTs7QUFFQTtBQUNBLE1BQUssV0FBTDtBQUNBLE1BQUssR0FBTCxDQUFTLFNBQVQ7O0FBRUEsTUFBSyxLQUFMLEdBQWEsSUFBYjtBQUNBLE1BQUssS0FBTCxHQUFhLElBQWI7QUFDQSxNQUFLLE1BQUwsR0FBYyxJQUFkO0FBQ0EsTUFBSyxZQUFMLEdBQW9CLEVBQXBCO0FBQ0EsTUFBSyxvQkFBTCxHQUE0QixFQUE1Qjs7QUFFQSxNQUFLLE9BQUwsR0FBZSxFQUFmO0FBQ0EsS0FBSSxLQUFLLGFBQVQsRUFDQyxLQUFLLGFBQUwsQ0FBbUIsS0FBbkI7O0FBRUQsTUFBSyxRQUFMLEdBQWdCO0FBQ2YsaUJBQWUsSUFEQTtBQUVmLGtCQUFnQixJQUZEO0FBR2YsYUFBVyxFQUhJLENBR0Y7QUFIRSxFQUFoQjs7QUFNQSxNQUFLLGFBQUwsR0FBcUIsSUFBSSx3QkFBSixDQUFrQixDQUFsQixFQUFxQixDQUFyQixFQUF3QixLQUFLLEtBQTdCLEVBQW9DLEtBQUssTUFBekMsRUFBaUQsQ0FBakQsQ0FBckI7O0FBRUEsS0FBSSxLQUFLLFFBQUwsQ0FBYyxhQUFsQixFQUNDLEtBQUssUUFBTCxDQUFjLGFBQWQsQ0FBNEIsS0FBNUI7O0FBR0QsTUFBSyxJQUFMLEdBQVksRUFBWjtBQUNBLEtBQUksa0JBQWtCLENBQXRCOztBQUVBLE1BQUssSUFBSSxTQUFTLENBQWxCLEVBQXFCLFNBQVMsS0FBSyxRQUFMLENBQWMsSUFBZCxDQUFtQixNQUFqRCxFQUF5RCxRQUF6RCxFQUFtRTtBQUNsRTs7QUFFQTs7QUFFQSxNQUFJLEVBQUUsQ0FBQyxLQUFLLFFBQUwsQ0FBYyxJQUFkLENBQW1CLE1BQW5CLEVBQTJCLElBQTVCLElBQW9DLE1BQU0sb0JBQU4sQ0FBMkIsT0FBM0IsQ0FBbUMsS0FBSyxRQUFMLENBQWMsSUFBZCxDQUFtQixNQUFuQixFQUEyQixJQUE5RCxLQUF1RSxDQUE3RyxDQUFKLEVBQ0M7O0FBRUQsTUFBSSxhQUFhLElBQUkscUJBQUosQ0FBZSxJQUFmLEVBQXFCLEtBQUssUUFBTCxDQUFjLElBQWQsQ0FBbUIsTUFBbkIsQ0FBckIsRUFBaUQsS0FBSyxLQUF0RCxFQUE2RCxrQkFBa0IsQ0FBL0UsRUFBa0YsRUFBRSxLQUFLLGFBQUwsQ0FBbUIsWUFBdkcsQ0FBakI7QUFDQSxNQUFJLFdBQVcsSUFBWCxLQUFvQixJQUF4QixFQUNDLFdBQVcsSUFBWCxHQUFrQixnQkFBaUIsZUFBbkM7O0FBRUQsTUFBSSxXQUFXLEtBQVgsS0FBcUIsSUFBekIsRUFBK0I7QUFDOUIsT0FBSSxLQUFLLFFBQUwsQ0FBYyxJQUFkLENBQW1CLE1BQW5CLEdBQTRCLENBQWhDLEVBQW1DO0FBQ2xDLGVBQVcsU0FBWCxHQUF1QixDQUFDLEtBQUssaUJBQUwsQ0FBdUIsV0FBVyxLQUFYLEdBQW1CLEtBQUssaUJBQUwsQ0FBdUIsTUFBakUsQ0FBRCxDQUF2QjtBQUNBLGVBQVcsS0FBWCxHQUFtQixLQUFLLGlCQUFMLENBQXVCLFdBQVcsS0FBWCxHQUFtQixLQUFLLGlCQUFMLENBQXVCLE1BQWpFLENBQW5CO0FBQ0EsSUFIRCxNQUdPO0FBQ04sUUFBSSxXQUFXLElBQVgsS0FBb0IsTUFBcEIsSUFBOEIsV0FBVyxJQUFYLEtBQW9CLFVBQWxELElBQWdFLFdBQVcsSUFBWCxLQUFvQixRQUFwRixJQUFnRyxXQUFXLElBQVgsS0FBb0IsTUFBcEgsSUFDQSxXQUFXLElBQVgsS0FBb0IsVUFEcEIsSUFDa0MsV0FBVyxJQUFYLEtBQW9CLFlBRHRELElBQ3NFLFdBQVcsSUFBWCxLQUFvQixhQUQxRixJQUMyRyxXQUFXLElBQVgsS0FBb0IsZ0JBRC9ILElBRUEsV0FBVyxJQUFYLEtBQW9CLFdBRnBCLElBRW1DLFdBQVcsSUFBWCxLQUFvQixpQkFGdkQsSUFFNEUsV0FBVyxJQUFYLEtBQW9CLGFBRmhHLElBRWlILFdBQVcsSUFBWCxLQUFvQixNQUZ6SSxFQUVpSjtBQUNoSixnQkFBVyxTQUFYLEdBQXVCLENBQUMsS0FBSyxpQkFBTCxDQUF1QixDQUF2QixDQUFELENBQXZCO0FBQ0EsS0FKRCxNQU1DLFdBQVcsU0FBWCxHQUF1QixLQUFLLGlCQUE1QjtBQUNEO0FBQ0QsR0FiRCxNQWFPO0FBQ04sY0FBVyxTQUFYLEdBQXVCLENBQUMsV0FBVyxLQUFaLENBQXZCO0FBQ0E7O0FBRUQsTUFBSSxXQUFXLFVBQVgsS0FBMEIsSUFBOUIsRUFBb0M7QUFDbkMsT0FBSyxDQUFDLFdBQVcsSUFBWCxLQUFvQixNQUFwQixJQUE4QixXQUFXLElBQVgsS0FBb0IsVUFBbEQsSUFBZ0UsV0FBVyxJQUFYLEtBQW9CLFFBQXJGLEtBQWtHLFdBQVcsVUFBN0csSUFBMkgsV0FBVyxVQUFYLENBQXNCLE1BQXRCLEdBQStCLEtBQUssS0FBTCxHQUFhLEVBQXhLLElBQStLLFdBQVcsSUFBWCxLQUFvQixTQUF2TSxFQUFrTjtBQUNqTjtBQUNBLGVBQVcsVUFBWCxHQUF3QixDQUF4QjtBQUNBO0FBQ0Q7O0FBRUQsTUFBSSxDQUFDLFdBQVcsSUFBWCxLQUFvQixRQUFwQixJQUFnQyxXQUFXLElBQVgsS0FBb0IsU0FBckQsS0FBbUUsV0FBVyxVQUFsRixFQUE4RjtBQUM3RixjQUFXLFVBQVgsQ0FBc0IsSUFBdEIsQ0FBMkIsd0JBQTNCO0FBQ0E7O0FBRUQ7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsT0FBSyxJQUFMLENBQVUsSUFBVixDQUFlLFVBQWY7O0FBRUEsTUFBSSxzQkFBc0IsV0FBVyxhQUFyQzs7QUFFQTtBQUNBOztBQUVBLE1BQUksWUFBSjs7QUFFQSxNQUFJLHdCQUF3QixRQUE1QixFQUFzQzs7QUFFckMsT0FBSSxLQUFLLFFBQUwsQ0FBYyxhQUFkLEtBQWdDLFdBQXBDLEVBQWlEO0FBQ2hELG1CQUFlLDBCQUEwQixXQUFXLElBQXJDLEdBQTRDLG1CQUEzRDtBQUNBLElBRkQsTUFFTyxJQUFJLEtBQUssUUFBTCxDQUFjLGFBQWQsS0FBZ0MsTUFBcEMsRUFBNEM7QUFDbEQsbUJBQWUsMEJBQTBCLFdBQVcsSUFBckMsR0FBNEMsbUJBQTNEO0FBQ0EsSUFGTSxNQUVBLElBQUksS0FBSyxRQUFMLENBQWMsYUFBZCxLQUFnQyxJQUFwQyxFQUNOLEtBQUssUUFBTCxDQUFjLGFBQWQsR0FBOEIsUUFBOUI7QUFDRCxHQVJELE1BU0ssSUFBSSx3QkFBd0IsV0FBNUIsRUFBeUM7O0FBRTdDLE9BQUksS0FBSyxRQUFMLENBQWMsYUFBZCxLQUFnQyxRQUFwQyxFQUE4QztBQUM3QyxtQkFBZSwwQkFBMEIsV0FBVyxJQUFyQyxHQUE0Qyx5Q0FBM0Q7QUFDQSxJQUZELE1BRU8sSUFBSSxLQUFLLFFBQUwsQ0FBYyxhQUFkLEtBQWdDLE1BQXBDLEVBQTRDO0FBQ2xELG1CQUFlLDBCQUEwQixXQUFXLElBQXJDLEdBQTRDLG1CQUEzRDtBQUNBLElBRk0sTUFFQSxJQUFJLEtBQUssUUFBTCxDQUFjLGFBQWQsS0FBZ0MsSUFBcEMsRUFDTixLQUFLLFFBQUwsQ0FBYyxhQUFkLEdBQThCLFdBQTlCO0FBQ0QsR0FSSSxNQVNBLElBQUksdUJBQXVCLE1BQTNCLEVBQW1DOztBQUV2QyxPQUFJLEtBQUssUUFBTCxDQUFjLGFBQWQsS0FBZ0MsUUFBcEMsRUFBOEM7QUFDN0MsbUJBQWUsMEJBQTBCLFdBQVcsSUFBckMsR0FBNEMseUNBQTNEO0FBQ0EsSUFGRCxNQUVPLElBQUksS0FBSyxRQUFMLENBQWMsYUFBZCxLQUFnQyxXQUFwQyxFQUFpRDtBQUN2RCxtQkFBZSwwQkFBMEIsV0FBVyxJQUFyQyxHQUE0QyxtQkFBM0Q7QUFDQSxJQUZNLE1BRUEsSUFBSSxLQUFLLFFBQUwsQ0FBYyxhQUFkLEtBQWdDLElBQXBDLEVBQ04sS0FBSyxRQUFMLENBQWMsYUFBZCxHQUE4QixNQUE5QjtBQUNEOztBQUVELE1BQUksZ0JBQWdCLE9BQU8sT0FBM0IsRUFBb0M7QUFDbkMsVUFBTyxPQUFQLENBQWUsR0FBZixDQUFtQixZQUFuQjtBQUNBO0FBQ0E7QUFDRDs7QUFFRDtBQUNBO0FBQ0E7O0FBRUEsTUFBSyxtQkFBTCxHQUEyQixJQUEzQjtBQUNBLENBL0pEOztBQWlLQTtBQUNBLE1BQU0sb0JBQU4sR0FBNkIsNEJBQWdCLENBQUMsTUFBRCxFQUFTLFVBQVQsRUFBcUIsUUFBckIsRUFBK0IsUUFBL0IsRUFBeUMsTUFBekMsRUFBaUQsVUFBakQsRUFBNkQsWUFBN0QsRUFBMkUsS0FBM0UsRUFBa0YsUUFBbEYsRUFBNEYsU0FBNUYsRUFDNUMsZUFENEMsRUFDM0Isa0JBRDJCLEVBQ1AsWUFETyxFQUNPLGVBRFAsRUFFNUMsYUFGNEMsRUFFN0IsZ0JBRjZCLEVBRzVDLGFBSDRDLEVBSTVDLE1BSjRDLEVBSzVDLGFBTDRDLEVBTTVDLFVBTjRDLEVBTzVDLFdBUDRDLEVBUTVDLGlCQVI0QyxFQVM1QyxLQVQ0QyxFQVNyQyxVQVRxQyxFQVN6QixRQVR5QixDQUFoQixDQUE3Qjs7QUFZQSxNQUFNLFNBQU4sQ0FBZ0IsTUFBaEIsR0FBeUIsVUFBVSxPQUFWLEVBQW1COztBQUUzQyxLQUFJLE9BQUosRUFDQyxLQUFLLFFBQUwsR0FBZ0IsT0FBaEI7O0FBRUQsTUFBSyxXQUFMO0FBQ0EsS0FBSSxtQkFBbUIsRUFBdkIsQ0FOMkMsQ0FNaEI7O0FBRTNCO0FBQ0EsTUFBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEtBQUssSUFBTCxDQUFVLE1BQTlCLEVBQXNDLEdBQXRDLEVBQTJDOztBQUUxQyxNQUFJLEtBQUssUUFBTCxDQUFjLGFBQWQsS0FBZ0MsUUFBaEMsSUFBNEMsS0FBSyxRQUFMLENBQWMsYUFBZCxLQUFnQyxXQUFoRixFQUE2RjtBQUM1RixPQUFJLENBQUMsS0FBSyxJQUFMLENBQVUsQ0FBVixFQUFhLFNBQWQsSUFBMkIsS0FBSyxJQUFMLENBQVUsQ0FBVixFQUFhLFNBQWIsS0FBMkIsU0FBMUQsRUFBcUU7QUFDcEUsUUFBSSxDQUFDLEtBQUssS0FBVixFQUFpQjs7QUFFaEIsU0FBSSxLQUFLLFFBQUwsQ0FBYyxhQUFkLEtBQWdDLFFBQXBDLEVBQThDO0FBQzdDLFdBQUssS0FBTCxDQUFXLElBQVgsQ0FBZ0IsS0FBSyxLQUFMLEdBQWEsSUFBSSxjQUFKLENBQVMsSUFBVCxFQUFlLEtBQUssUUFBTCxDQUFjLEtBQTdCLEVBQW9DLE9BQXBDLEVBQTZDLE1BQTdDLENBQTdCO0FBQ0EsTUFGRCxNQUdLLElBQUksS0FBSyxRQUFMLENBQWMsYUFBZCxLQUFnQyxXQUFwQyxFQUFpRDtBQUNyRCxXQUFLLEtBQUwsQ0FBVyxJQUFYLENBQWdCLEtBQUssS0FBTCxHQUFhLElBQUksY0FBSixDQUFTLElBQVQsRUFBZSxLQUFLLFFBQUwsQ0FBYyxLQUE3QixFQUFvQyxPQUFwQyxFQUE2QyxRQUE3QyxDQUE3QjtBQUNBO0FBQ0Q7QUFDRCxTQUFLLElBQUwsQ0FBVSxDQUFWLEVBQWEsS0FBYixHQUFxQixLQUFLLEtBQTFCO0FBQ0EsSUFYRCxNQVlLLElBQUksS0FBSyxJQUFMLENBQVUsQ0FBVixFQUFhLFNBQWIsS0FBMkIsV0FBL0IsRUFBNEM7QUFDaEQsUUFBSSxDQUFDLEtBQUssTUFBVixFQUFrQjtBQUNqQixTQUFJLEtBQUssUUFBTCxDQUFjLGFBQWQsS0FBZ0MsUUFBcEMsRUFBOEM7QUFDN0MsV0FBSyxLQUFMLENBQVcsSUFBWCxDQUFnQixLQUFLLE1BQUwsR0FBYyxJQUFJLGNBQUosQ0FBUyxJQUFULEVBQWUsS0FBSyxRQUFMLENBQWMsTUFBN0IsRUFBcUMsT0FBckMsRUFBOEMsT0FBOUMsQ0FBOUI7QUFDQSxNQUZELE1BR0ssSUFBSSxLQUFLLFFBQUwsQ0FBYyxhQUFkLEtBQWdDLFdBQXBDLEVBQWlEO0FBQ3JELFdBQUssS0FBTCxDQUFXLElBQVgsQ0FBZ0IsS0FBSyxNQUFMLEdBQWMsSUFBSSxjQUFKLENBQVMsSUFBVCxFQUFlLEtBQUssUUFBTCxDQUFjLE1BQTdCLEVBQXFDLE9BQXJDLEVBQThDLEtBQTlDLENBQTlCO0FBQ0E7QUFDRDtBQUNELFNBQUssSUFBTCxDQUFVLENBQVYsRUFBYSxLQUFiLEdBQXFCLEtBQUssTUFBMUI7QUFDQTs7QUFFRCxPQUFJLENBQUMsS0FBSyxLQUFWLEVBQWlCO0FBQ2hCLFFBQUksS0FBSyxRQUFMLENBQWMsYUFBZCxLQUFnQyxRQUFwQyxFQUE4QztBQUM3QyxVQUFLLEtBQUwsQ0FBVyxJQUFYLENBQWdCLEtBQUssS0FBTCxHQUFhLElBQUksY0FBSixDQUFTLElBQVQsRUFBZSxLQUFLLFFBQUwsQ0FBYyxLQUE3QixFQUFvQyxPQUFwQyxFQUE2QyxRQUE3QyxDQUE3QjtBQUNBLEtBRkQsTUFFTyxJQUFJLEtBQUssUUFBTCxDQUFjLGFBQWQsS0FBZ0MsV0FBcEMsRUFBaUQ7QUFDdkQsVUFBSyxLQUFMLENBQVcsSUFBWCxDQUFnQixLQUFLLEtBQUwsR0FBYSxJQUFJLGNBQUosQ0FBUyxJQUFULEVBQWUsS0FBSyxRQUFMLENBQWMsS0FBN0IsRUFBb0MsT0FBcEMsRUFBNkMsTUFBN0MsQ0FBN0I7QUFDQTtBQUNEOztBQUVELFFBQUssSUFBTCxDQUFVLENBQVYsRUFBYSxLQUFiLEdBQXFCLEtBQUssS0FBMUI7QUFDQTtBQUNEOztBQUVEO0FBQ0EsS0FBSSxLQUFLLEtBQUwsSUFBYyxLQUFLLE1BQXZCLEVBQStCO0FBQzlCLE1BQUksS0FBSyxLQUFMLENBQVcsYUFBWCxHQUEyQixDQUEzQixJQUFnQyxPQUFRLEtBQUssTUFBTCxDQUFZLFFBQVosQ0FBcUIsYUFBN0IsS0FBZ0QsV0FBcEYsRUFDQyxLQUFLLE1BQUwsQ0FBWSxhQUFaLEdBQTRCLENBQTVCLENBREQsS0FFSyxJQUFJLEtBQUssTUFBTCxDQUFZLGFBQVosR0FBNEIsQ0FBNUIsSUFBaUMsT0FBUSxLQUFLLEtBQUwsQ0FBVyxRQUFYLENBQW9CLGFBQTVCLEtBQStDLFdBQXBGLEVBQ0osS0FBSyxLQUFMLENBQVcsYUFBWCxHQUEyQixDQUEzQjtBQUNEOztBQUdEO0FBQ0EsS0FBSSxjQUFjLEtBQWxCO0FBQ0EsS0FBSSxLQUFLLEtBQUwsQ0FBVyxNQUFYLEdBQW9CLENBQXBCLEtBQTBCLEtBQUssV0FBTCxJQUFvQixLQUFLLFVBQW5ELENBQUosRUFBb0U7QUFDbkUsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEtBQUssS0FBTCxDQUFXLE1BQS9CLEVBQXVDLEdBQXZDLEVBQTRDO0FBQzNDLE9BQUksS0FBSyxLQUFMLENBQVcsQ0FBWCxFQUFjLGVBQWQsS0FBa0MsSUFBbEMsSUFBMEMsS0FBSyxLQUFMLENBQVcsQ0FBWCxFQUFjLGVBQWQsS0FBa0MsSUFBaEYsRUFBc0Y7QUFDckYsa0JBQWMsSUFBZDtBQUNBO0FBQ0E7QUFDRDtBQUNEOztBQUVELEtBQUksV0FBSixFQUFpQjtBQUNoQixtQkFBSyxLQUFLLFdBQVYsRUFBdUIsS0FBSyxZQUE1QjtBQUNBLEVBRkQsTUFFTztBQUNOLG1CQUFLLEtBQUssV0FBVixFQUF1QixLQUFLLFlBQTVCO0FBQ0E7O0FBR0QsTUFBSyxZQUFMLEdBM0UyQyxDQTJFdkI7O0FBRXBCLEtBQUksS0FBSyxRQUFMLENBQWMsS0FBbEIsRUFBeUI7QUFDeEIsT0FBSyxNQUFMLEdBQWMsSUFBSSxlQUFKLENBQVUsSUFBVixFQUFnQixLQUFLLFFBQUwsQ0FBYyxLQUE5QixDQUFkOztBQUVBLE1BQUksQ0FBQyxLQUFLLE1BQUwsQ0FBWSxrQkFBakIsRUFDQyxLQUFLLE1BQUwsQ0FBWSxNQUFaLEdBREQsS0FHQyxpQkFBaUIsSUFBakIsQ0FBc0IsS0FBSyxNQUEzQjtBQUNEOztBQUVELEtBQUksS0FBSyxRQUFMLENBQWMsU0FBbEIsRUFBNkI7QUFDNUIsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEtBQUssUUFBTCxDQUFjLFNBQWQsQ0FBd0IsTUFBNUMsRUFBb0QsR0FBcEQsRUFBeUQ7O0FBRXhELFFBQUssU0FBTCxHQUFpQixFQUFqQjs7QUFFQSxPQUFJLFdBQVcsSUFBSSxRQUFKLENBQWEsSUFBYixFQUFtQixLQUFLLFFBQUwsQ0FBYyxTQUFkLENBQXdCLENBQXhCLENBQW5CLENBQWY7QUFDQSxRQUFLLFNBQUwsQ0FBZSxJQUFmLENBQW9CLFFBQXBCOztBQUVBLE9BQUksQ0FBQyxTQUFTLGtCQUFkLEVBQ0MsU0FBUyxNQUFULEdBREQsS0FHQyxpQkFBaUIsSUFBakIsQ0FBc0IsUUFBdEI7QUFDRDtBQUNEOztBQUVELE1BQUssTUFBTCxHQUFjLElBQUksZ0JBQUosQ0FBVyxJQUFYLEVBQWlCLEtBQUssUUFBTCxDQUFjLE1BQS9CLEVBQXVDLEtBQUssS0FBNUMsQ0FBZDtBQUNBLE1BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxLQUFLLElBQUwsQ0FBVSxNQUE5QixFQUFzQyxHQUF0QyxFQUEyQztBQUMxQyxNQUFJLEtBQUssSUFBTCxDQUFVLENBQVYsRUFBYSxZQUFiLElBQTZCLEtBQUssSUFBTCxDQUFVLENBQVYsRUFBYSxJQUFiLEtBQXNCLEtBQW5ELElBQTRELEtBQUssSUFBTCxDQUFVLENBQVYsRUFBYSxJQUFiLEtBQXNCLFVBQXRGLEVBQWtHO0FBQ2pHLFFBQUssTUFBTCxDQUFZLFVBQVosQ0FBdUIsSUFBdkIsQ0FBNEIsS0FBSyxJQUFMLENBQVUsQ0FBVixDQUE1QjtBQUNBO0FBQ0Q7O0FBRUQsS0FBSSxDQUFDLEtBQUssTUFBTCxDQUFZLGtCQUFqQixFQUNDLEtBQUssTUFBTCxDQUFZLE1BQVosR0FERCxLQUdDLGlCQUFpQixJQUFqQixDQUFzQixLQUFLLE1BQTNCOztBQUVEO0FBQ0EsS0FBSSxLQUFLLFFBQUwsQ0FBYyxhQUFkLEtBQWdDLFFBQWhDLElBQTRDLEtBQUssUUFBTCxDQUFjLGFBQWQsS0FBZ0MsV0FBaEYsRUFBNkY7O0FBRTVGOztBQUVBLGlCQUFLLGtCQUFMLENBQXdCLEtBQUssS0FBN0IsRUFBb0MsS0FBSyxLQUF6QyxFQUFnRCxLQUFLLE1BQXJELEVBQTZELEtBQUssUUFBTCxDQUFjLGFBQTNFLEVBQTBGLEtBQUssYUFBTCxDQUFtQixZQUFuQixFQUExRjtBQUNBLEVBTEQsTUFLTyxJQUFJLEtBQUssUUFBTCxDQUFjLGFBQWQsS0FBZ0MsTUFBcEMsRUFBNEM7QUFDbEQ7QUFDQSxPQUFLLGVBQUw7QUFDQSxFQUhNLE1BSUY7QUFDSjtBQUNBOztBQUVELEtBQUksUUFBUSxDQUFaO0FBQ0EsTUFBSyxLQUFMLElBQWMsZ0JBQWQsRUFBZ0M7QUFDL0IsTUFBRyxpQkFBaUIsY0FBakIsQ0FBZ0MsS0FBaEMsQ0FBSCxFQUNBLGlCQUFpQixLQUFqQixFQUF3QixNQUF4QjtBQUNBOztBQUVELEtBQUksYUFBYSxFQUFqQjtBQUNBLEtBQUksS0FBSyxjQUFULEVBQXlCO0FBQ3hCLE1BQUksZUFBZSx5QkFBYSxLQUFLLEtBQWxCLEVBQXlCLEtBQUssTUFBOUIsQ0FBbkI7QUFDQSxNQUFJLGtCQUFrQixhQUFhLFVBQWIsQ0FBd0IsSUFBeEIsQ0FBdEI7QUFDQSxrQkFBZ0IsU0FBaEIsQ0FBMEIsS0FBSyxNQUEvQixFQUF1QyxDQUF2QyxFQUEwQyxDQUExQyxFQUE2QyxLQUFLLEtBQWxELEVBQXlELEtBQUssTUFBOUQ7QUFDQTs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksS0FBSyxRQUFMLENBQWMsU0FBZCxDQUF3QixNQUE1QyxFQUFvRCxHQUFwRCxFQUF5RDtBQUN4RCxNQUFJLFdBQVcsS0FBSyxRQUFMLENBQWMsU0FBZCxDQUF3QixDQUF4QixDQUFmOztBQUVBLE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxTQUFTLFNBQVQsQ0FBbUIsTUFBdkMsRUFBK0MsR0FBL0MsRUFBb0Q7O0FBRW5ELE9BQUksV0FBVyxTQUFTLFNBQVQsQ0FBbUIsQ0FBbkIsQ0FBZjtBQUNBLE9BQUksZ0JBQWdCLElBQXBCOztBQUVBLFlBQVMsWUFBVCxHQUF3QixJQUF4QixDQUxtRCxDQUtyQjs7QUFFOUIsT0FBSSxLQUFLLGNBQVQsRUFBeUI7QUFDeEIsYUFBUyxZQUFULEdBQXdCLHlCQUFhLEtBQUssS0FBbEIsRUFBeUIsS0FBSyxNQUE5QixDQUF4QjtBQUNBLGFBQVMsZUFBVCxHQUEyQixTQUFTLFlBQVQsQ0FBc0IsVUFBdEIsQ0FBaUMsSUFBakMsQ0FBM0I7QUFDQTs7QUFFRCxPQUFJLFNBQVMsSUFBVCxLQUFrQixNQUF0QixFQUNDLGdCQUFnQixLQUFLLFVBQUwsQ0FBZ0IsUUFBaEIsQ0FBaEIsQ0FERCxLQUVLLElBQUksU0FBUyxJQUFULEtBQWtCLFVBQXRCLEVBQ0osZ0JBQWdCLEtBQUssY0FBTCxDQUFvQixRQUFwQixDQUFoQixDQURJLEtBRUEsSUFBSSxTQUFTLElBQVQsS0FBa0IsUUFBdEIsRUFDSixnQkFBZ0IsS0FBSyxZQUFMLENBQWtCLFFBQWxCLENBQWhCLENBREksS0FFQSxJQUFJLFNBQVMsSUFBVCxLQUFrQixRQUF0QixFQUNKLGdCQUFnQixLQUFLLFlBQUwsQ0FBa0IsUUFBbEIsQ0FBaEIsQ0FESSxLQUVBLElBQUksU0FBUyxJQUFULEtBQWtCLEtBQXRCLEVBQ0osZ0JBQWdCLEtBQUssU0FBTCxDQUFlLFFBQWYsQ0FBaEIsQ0FESSxLQUVBLElBQUksU0FBUyxJQUFULEtBQWtCLE1BQXRCLEVBQ0osZ0JBQWdCLEtBQUssVUFBTCxDQUFnQixRQUFoQixDQUFoQixDQURJLEtBRUEsSUFBSSxTQUFTLElBQVQsS0FBa0IsVUFBdEIsRUFDSixnQkFBZ0IsS0FBSyxjQUFMLENBQW9CLFFBQXBCLENBQWhCLENBREksS0FFQSxJQUFJLFNBQVMsSUFBVCxLQUFrQixZQUF0QixFQUNKLGdCQUFnQixLQUFLLGdCQUFMLENBQXNCLFFBQXRCLENBQWhCLENBREksS0FFQSxJQUFJLFNBQVMsSUFBVCxLQUFrQixlQUF0QixFQUNKLGdCQUFnQixLQUFLLG1CQUFMLENBQXlCLFFBQXpCLENBQWhCLENBREksS0FFQSxJQUFJLFNBQVMsSUFBVCxLQUFrQixrQkFBdEIsRUFDSixnQkFBZ0IsS0FBSyxzQkFBTCxDQUE0QixRQUE1QixDQUFoQixDQURJLEtBRUEsSUFBSSxTQUFTLElBQVQsS0FBa0IsWUFBdEIsRUFDSixnQkFBZ0IsS0FBSyxnQkFBTCxDQUFzQixRQUF0QixDQUFoQixDQURJLEtBRUEsSUFBSSxTQUFTLElBQVQsS0FBa0IsZUFBdEIsRUFDSixnQkFBZ0IsS0FBSyxtQkFBTCxDQUF5QixRQUF6QixDQUFoQixDQURJLEtBRUEsSUFBSSxTQUFTLElBQVQsS0FBa0IsYUFBdEIsRUFDSixnQkFBZ0IsS0FBSyxpQkFBTCxDQUF1QixRQUF2QixDQUFoQixDQURJLEtBRUEsSUFBSSxTQUFTLElBQVQsS0FBa0IsZ0JBQXRCLEVBQ0osZ0JBQWdCLEtBQUssb0JBQUwsQ0FBMEIsUUFBMUIsQ0FBaEIsQ0FESSxLQUVBLElBQUksU0FBUyxJQUFULEtBQWtCLFFBQXRCLEVBQ0osZ0JBQWdCLGdCQUFnQixLQUFLLFlBQUwsQ0FBa0IsUUFBbEIsQ0FBaEMsQ0FESSxLQUVBLElBQUksU0FBUyxJQUFULEtBQWtCLFNBQXRCLEVBQ0osZ0JBQWdCLEtBQUssYUFBTCxDQUFtQixRQUFuQixDQUFoQixDQURJLEtBRUEsSUFBSSxTQUFTLElBQVQsS0FBa0IsS0FBdEIsRUFDSixLQUFLLFNBQUwsQ0FBZSxRQUFmLEVBREksS0FFQSxJQUFJLFNBQVMsSUFBVCxLQUFrQixVQUF0QixFQUNKLEtBQUssU0FBTCxDQUFlLFFBQWYsRUFESSxLQUVBLElBQUksU0FBUyxJQUFULEtBQWtCLGFBQXRCLEVBQ0osZ0JBQWdCLEtBQUssaUJBQUwsQ0FBdUIsUUFBdkIsQ0FBaEIsQ0FESSxLQUVBLElBQUksU0FBUyxJQUFULEtBQWtCLE1BQXRCLEVBQ0osZ0JBQWdCLEtBQUssaUJBQUwsQ0FBdUIsUUFBdkIsQ0FBaEIsQ0FESSxLQUVBLElBQUksU0FBUyxJQUFULEtBQWtCLGFBQXRCLEVBQ0osZ0JBQWdCLEtBQUssaUJBQUwsQ0FBdUIsUUFBdkIsQ0FBaEIsQ0FESSxLQUVBLElBQUksU0FBUyxJQUFULEtBQWtCLFVBQXRCLEVBQ0osZ0JBQWdCLEtBQUssY0FBTCxDQUFvQixRQUFwQixDQUFoQixDQURJLEtBRUEsSUFBSSxTQUFTLElBQVQsS0FBa0IsV0FBdEIsRUFDSixnQkFBZ0IsS0FBSyxlQUFMLENBQXFCLFFBQXJCLENBQWhCLENBREksS0FFQSxJQUFJLFNBQVMsSUFBVCxLQUFrQixpQkFBdEIsRUFDSixnQkFBZ0IsS0FBSyxxQkFBTCxDQUEyQixRQUEzQixDQUFoQjs7QUFFRCxRQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDtBQUMzRCxTQUFLLG9CQUFMLENBQTBCLElBQTFCLENBQStCLEtBQUssSUFBTCxDQUFVLFNBQVMsaUJBQVQsQ0FBMkIsQ0FBM0IsQ0FBVixDQUEvQjtBQUNBOztBQUVELE9BQUksS0FBSyxjQUFMLElBQXVCLGFBQTNCLEVBQ0MsV0FBVyxJQUFYLENBQWdCLGFBQWhCO0FBQ0Q7QUFDRDs7QUFFRCxLQUFJLEtBQUssY0FBTCxJQUF1QixLQUFLLFlBQUwsQ0FBa0IsTUFBbEIsR0FBMkIsQ0FBdEQsRUFBeUQ7QUFDeEQsTUFBSSxtQkFBbUIseUJBQWEsS0FBSyxLQUFsQixFQUF5QixLQUFLLE1BQTlCLENBQXZCO0FBQ0EsTUFBSSxzQkFBc0IsaUJBQWlCLFVBQWpCLENBQTRCLElBQTVCLENBQTFCO0FBQ0EsYUFBVyxJQUFYLENBQWdCLEtBQUssaUJBQUwsQ0FBdUIsbUJBQXZCLENBQWhCO0FBQ0E7O0FBRUQsS0FBSSxRQUFRLElBQVo7O0FBRUEsS0FBSSxXQUFXLE1BQVgsR0FBb0IsQ0FBeEIsRUFBMkI7QUFDMUI7QUFDQSxRQUFNLGNBQU4sR0FBdUIsSUFBdkI7QUFDQSxRQUFNLFNBQU4sQ0FBZ0IsT0FBaEIsQ0FBd0IsR0FBeEIsRUFBNkIsTUFBTSxpQkFBbkMsRUFBc0QsVUFBVSxnQkFBVixFQUE0Qjs7QUFFakY7QUFDQTs7QUFFQSxTQUFNLEdBQU4sQ0FBVSxTQUFWLENBQW9CLENBQXBCLEVBQXVCLENBQXZCLEVBQTBCLE1BQU0sS0FBaEMsRUFBdUMsTUFBTSxNQUE3Qzs7QUFHQTtBQUNBLFNBQU0sR0FBTixDQUFVLFNBQVYsQ0FBb0IsWUFBcEIsRUFBa0MsQ0FBbEMsRUFBcUMsQ0FBckMsRUFBd0MsS0FBSyxLQUFMLENBQVcsTUFBTSxLQUFOLEdBQWMsNEJBQXpCLENBQXhDLEVBQWdHLEtBQUssS0FBTCxDQUFXLE1BQU0sTUFBTixHQUFlLDRCQUExQixDQUFoRyxFQUF5SixDQUF6SixFQUE0SixDQUE1SixFQUErSixNQUFNLEtBQXJLLEVBQTRLLE1BQU0sTUFBbEw7O0FBRUEsUUFBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFdBQVcsTUFBL0IsRUFBdUMsR0FBdkMsRUFBNEM7O0FBRTNDLG9CQUFnQixXQUFXLENBQVgsQ0FBaEI7O0FBRUEsUUFBSSxtQkFBbUIsQ0FBbkIsSUFBd0IsT0FBUSxjQUFjLGdCQUF0QixLQUE0QyxXQUF4RSxFQUFxRjtBQUNwRixTQUFJLG9CQUFvQixjQUFjLGdCQUF0QyxFQUF3RDtBQUN2RDs7QUFFQSxvQkFBYyxpQkFBZCxDQUFnQyxjQUFjLGNBQWQsQ0FBNkIsbUJBQW1CLGNBQWMsZ0JBQTlELEVBQWdGLENBQWhGLEVBQW1GLENBQW5GLEVBQXNGLElBQUksY0FBYyxnQkFBeEcsQ0FBaEMsRUFBMkosYUFBM0o7QUFDQTtBQUNELEtBTkQsTUFNTzs7QUFFTixtQkFBYyxpQkFBZCxDQUFnQyxjQUFjLGNBQWQsQ0FBNkIsZ0JBQTdCLEVBQStDLENBQS9DLEVBQWtELENBQWxELEVBQXFELENBQXJELENBQWhDLEVBQXlGLGFBQXpGO0FBQ0E7QUFDRDs7QUFFRCxTQUFNLGFBQU4sQ0FBb0IsMkJBQXBCLEVBQ0s7QUFDQyxXQUFPO0FBRFIsSUFETDtBQUtBLEdBaENELEVBZ0NHLFlBQVk7O0FBRWQsZ0JBQWEsRUFBYjs7QUFFQSxPQUFJLFFBQVEsQ0FBWjs7QUFFQTtBQUNBLFFBQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxNQUFNLFFBQU4sQ0FBZSxTQUFmLENBQXlCLE1BQTdDLEVBQXFELEdBQXJELEVBQTBEO0FBQ3pELFFBQUksV0FBVyxNQUFNLFFBQU4sQ0FBZSxTQUFmLENBQXlCLENBQXpCLENBQWY7O0FBRUEsU0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFNBQVMsU0FBVCxDQUFtQixNQUF2QyxFQUErQyxHQUEvQyxFQUFvRDtBQUNuRCxTQUFJLFdBQVcsU0FBUyxTQUFULENBQW1CLENBQW5CLENBQWY7QUFDQSxjQUFTLFlBQVQsR0FBd0IsSUFBeEI7QUFDQTtBQUNEOztBQUVELGtCQUFlLElBQWY7QUFDQSxTQUFNLGNBQU4sR0FBdUIsS0FBdkI7QUFDQTtBQUVBLEdBcEREO0FBcURBLEVBeERELE1Bd0RPO0FBQ04sTUFBSSxNQUFNLFlBQU4sQ0FBbUIsTUFBbkIsR0FBNEIsQ0FBaEMsRUFDQyxNQUFNLGlCQUFOOztBQUVELFFBQU0sYUFBTixDQUFvQiwyQkFBcEIsRUFDRTtBQUNDLFVBQU87QUFEUixHQURGO0FBSUE7O0FBRUQsTUFBSywyQkFBTDs7QUFFQSxLQUFJLENBQUMsS0FBSyxXQUFOLElBQXFCLENBQUMsS0FBSyxVQUEzQixJQUF5QyxLQUFLLFdBQTlDLElBQTZELEtBQUssV0FBTCxDQUFpQixLQUFqQixDQUF1QixPQUF2QixLQUFtQyxNQUFwRyxFQUE0RztBQUMzRyxtQkFBSyxLQUFLLFdBQVYsRUFBdUIsS0FBSyxZQUE1QjtBQUNBOztBQUVELE1BQUssUUFBTCxDQUFjLGNBQWQ7O0FBRUEsTUFBSyxXQUFMOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSxLQUFJLG9CQUFKLEVBQWlCOztBQUVoQixNQUFJLFFBQVEsSUFBWjtBQUNBLGFBQVcsWUFBWTtBQUN0QixPQUFJLGtCQUFrQixTQUFTLGNBQVQsQ0FBd0IsaUJBQXhCLENBQXRCOztBQUVBLE9BQUksZUFBSixFQUFxQjtBQUNwQjtBQUNBLDhCQUFjLGVBQWQsRUFBK0IsTUFBTSxLQUFyQyxFQUE0QyxNQUFNLE1BQWxEO0FBQ0EsUUFBSSxxQkFBcUIsZ0JBQWdCLFVBQWhCLENBQTJCLElBQTNCLENBQXpCOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBLHVCQUFtQixTQUFuQixDQUE2QixNQUFNLGFBQU4sQ0FBb0IsV0FBakQsRUFBOEQsQ0FBOUQsRUFBaUUsQ0FBakU7QUFDQTtBQUNBO0FBQ0E7QUFDRCxHQWpCRCxFQWlCRyxJQWpCSDtBQWtCQTtBQUNELENBblVEOztBQXFVQSxNQUFNLFNBQU4sQ0FBZ0IsMkJBQWhCLEdBQThDLFlBQVk7QUFBQTs7QUFFekQ7O0FBRUEsTUFBSyxXQUFMO0FBQ0MsV0FBUyxJQURWO0FBRUMsU0FBTyxJQUZSO0FBR0MsYUFBVyxLQUFLLGtCQUhqQjtBQUlDLFdBQVMsS0FBSyxnQkFKZjtBQUtDLGFBQVcsS0FBSyxrQkFMakI7QUFNQyxVQUFRLEtBQUssV0FBTCxHQUFtQixZQUFuQixHQUFrQztBQU4zQyw0Q0FPUyxLQUFLLFVBQUwsR0FBa0IsTUFBbEIsR0FBMkIsU0FQcEMsNENBUVUsSUFSViwyQ0FTUyxLQUFLLFFBVGQ7QUFZQSxDQWhCRDs7QUFrQkEsTUFBTSxTQUFOLENBQWdCLG9CQUFoQixHQUF1QyxZQUFZO0FBQ2xELEtBQUksYUFBYSxFQUFqQjs7QUFFQSxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksS0FBSyxJQUFMLENBQVUsTUFBOUIsRUFBc0MsR0FBdEMsRUFBMkM7QUFDMUMsZUFBYSxLQUFLLElBQUwsQ0FBVSxDQUFWLENBQWI7QUFDQSxNQUFJLENBQUMsV0FBVyxVQUFaLElBQTBCLFdBQVcsVUFBWCxDQUFzQixNQUF0QixLQUFpQyxDQUEzRCxJQUFnRSxDQUFDLFdBQVcsT0FBaEYsRUFDQzs7QUFFRCxNQUFJLE1BQU0sb0JBQU4sQ0FBMkIsT0FBM0IsQ0FBbUMsV0FBVyxJQUE5QyxLQUF1RCxDQUEzRCxFQUE4RDs7QUFFN0QsT0FBSSxXQUFXLElBQWY7QUFDQSxPQUFJLGlCQUFpQixLQUFyQjs7QUFFQSxPQUFJLFdBQVcsSUFBZjtBQUNBLE9BQUksaUJBQWlCLEtBQXJCOztBQUVBLFFBQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxLQUFLLFFBQUwsQ0FBYyxTQUFkLENBQXdCLE1BQTVDLEVBQW9ELEdBQXBELEVBQXlEO0FBQ3hELFFBQUksS0FBSyxRQUFMLENBQWMsU0FBZCxDQUF3QixDQUF4QixFQUEyQixJQUEzQixLQUFvQyxXQUFXLElBQW5ELEVBQXlEO0FBQ3hELHNCQUFpQixJQUFqQjtBQUNBLFNBQUksV0FBVyxLQUFLLFFBQUwsQ0FBYyxTQUFkLENBQXdCLENBQXhCLENBQWY7QUFDQTtBQUNBO0FBQ0Q7O0FBRUQsT0FBSSxDQUFDLGNBQUwsRUFBcUI7QUFDcEIsZUFBVztBQUNWLFdBQU0sV0FBVyxJQURQO0FBRVYsc0JBQWlCLENBRlA7QUFHVixnQkFBVztBQUhELEtBQVg7QUFLQSxTQUFLLFFBQUwsQ0FBYyxTQUFkLENBQXdCLElBQXhCLENBQTZCLFFBQTdCO0FBQ0E7O0FBRUQsUUFBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFNBQVMsU0FBVCxDQUFtQixNQUF2QyxFQUErQyxHQUEvQyxFQUFvRDtBQUNuRCxRQUFJLFNBQVMsU0FBVCxDQUFtQixDQUFuQixFQUFzQixTQUF0QixLQUFvQyxXQUFXLFNBQW5ELEVBQThEO0FBQzdELHNCQUFpQixJQUFqQjtBQUNBLFNBQUksV0FBVyxTQUFTLFNBQVQsQ0FBbUIsQ0FBbkIsQ0FBZjtBQUNBO0FBQ0E7QUFDRDs7QUFFRCxPQUFJLENBQUMsY0FBTCxFQUFxQjtBQUNwQixlQUFXO0FBQ1YsV0FBTSxXQUFXLElBRFA7QUFFViw4QkFBeUIsQ0FGZixFQUVrQjtBQUM1QixZQUFPLFNBQVMsU0FBVCxDQUFtQixNQUhoQjtBQUlWLGVBQVUsUUFKQTtBQUtWLGdCQUFXLFdBQVcsU0FMWjtBQU1WLFlBQU8sV0FBVyxTQUFYLEtBQXlCLFNBQXpCLEdBQXFDLEtBQUssS0FBMUMsR0FBa0QsS0FBSyxNQU5wRDtBQU9WLFlBQU8sS0FBSyxLQVBGO0FBUVYsd0JBQW1CLEVBUlQsRUFRYTtBQUN2QixjQUFTO0FBVEMsS0FBWDtBQVdBLGFBQVMsU0FBVCxDQUFtQixJQUFuQixDQUF3QixRQUF4QjtBQUNBOztBQUVELFlBQVMsZUFBVDs7QUFFQSxZQUFTLGlCQUFULENBQTJCLElBQTNCLENBQWdDLENBQWhDOztBQUVBLGNBQVcsUUFBWCxHQUFzQixRQUF0QjtBQUNBO0FBQ0Q7O0FBRUQsTUFBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEtBQUssUUFBTCxDQUFjLFNBQWQsQ0FBd0IsTUFBNUMsRUFBb0QsR0FBcEQsRUFBeUQ7QUFDeEQsTUFBSSxXQUFXLEtBQUssUUFBTCxDQUFjLFNBQWQsQ0FBd0IsQ0FBeEIsQ0FBZjtBQUNBLE1BQUksMEJBQTBCLENBQTlCOztBQUVBLE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxTQUFTLFNBQVQsQ0FBbUIsTUFBdkMsRUFBK0MsR0FBL0MsRUFBb0Q7O0FBRW5ELFlBQVMsU0FBVCxDQUFtQixDQUFuQixFQUFzQix1QkFBdEIsR0FBZ0QsdUJBQWhEOztBQUVBLDhCQUEyQixTQUFTLFNBQVQsQ0FBbUIsQ0FBbkIsRUFBc0IsaUJBQXRCLENBQXdDLE1BQW5FO0FBQ0E7QUFDRDtBQUNELENBM0VEOztBQTZFQSxNQUFNLFNBQU4sQ0FBZ0Isb0JBQWhCLEdBQXVDLFlBQVk7O0FBRWxELE1BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxLQUFLLElBQUwsQ0FBVSxNQUE5QixFQUFzQyxHQUF0QyxFQUEyQztBQUMxQyxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsQ0FBVixDQUFqQjs7QUFFQSxNQUFJLENBQUMsV0FBVyxVQUFoQixFQUNDOztBQUVELE1BQUksU0FBUyxXQUFXLFVBQVgsQ0FBc0IsTUFBbkM7O0FBRUEsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLE1BQXBCLEVBQTRCLEdBQTVCLEVBQWlDO0FBQ2hDLGNBQVcsWUFBWCxDQUF3QixDQUF4QixJQUE2QixFQUFFLEtBQUssYUFBTCxDQUFtQixZQUFsRDtBQUNBO0FBQ0Q7QUFDRCxDQWREOztBQWdCQSxNQUFNLFNBQU4sQ0FBZ0IsWUFBaEIsR0FBK0IsWUFBWTtBQUMxQyxNQUFLLG9CQUFMO0FBQ0EsTUFBSyxvQkFBTDs7QUFFQSxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksS0FBSyxRQUFMLENBQWMsU0FBZCxDQUF3QixNQUE1QyxFQUFvRCxHQUFwRCxFQUF5RDtBQUN4RCxNQUFJLFdBQVcsS0FBSyxRQUFMLENBQWMsU0FBZCxDQUF3QixDQUF4QixDQUFmOztBQUVBLE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxTQUFTLFNBQVQsQ0FBbUIsTUFBdkMsRUFBK0MsR0FBL0MsRUFBb0Q7O0FBRW5ELE9BQUksV0FBVyxTQUFTLFNBQVQsQ0FBbUIsQ0FBbkIsQ0FBZjs7QUFFQSxPQUFJLFNBQVMsSUFBVCxLQUFrQixNQUFsQixJQUE0QixTQUFTLElBQVQsS0FBa0IsVUFBOUMsSUFBNEQsU0FBUyxJQUFULEtBQWtCLFFBQTlFLElBQTBGLFNBQVMsSUFBVCxLQUFrQixRQUE1RyxJQUF3SCxTQUFTLElBQVQsS0FBa0IsTUFBMUksSUFBb0osU0FBUyxJQUFULEtBQWtCLFVBQXRLLElBQW9MLFNBQVMsSUFBVCxLQUFrQixZQUF0TSxJQUFzTixTQUFTLElBQVQsS0FBa0IsS0FBeE8sSUFBaVAsU0FBUyxJQUFULEtBQWtCLFFBQW5RLElBQStRLFNBQVMsSUFBVCxLQUFrQixTQUFyUyxFQUNDLEtBQUssMkJBQUwsQ0FBaUMsUUFBakMsRUFERCxLQUVLLElBQUksU0FBUyxJQUFULEtBQWtCLGVBQWxCLElBQXFDLFNBQVMsSUFBVCxLQUFrQixZQUF2RCxJQUF1RSxTQUFTLElBQVQsS0FBa0IsYUFBN0YsRUFDSixLQUFLLHVCQUFMLENBQTZCLFFBQTdCLEVBREksS0FFQSxJQUFJLFNBQVMsSUFBVCxLQUFrQixrQkFBbEIsSUFBd0MsU0FBUyxJQUFULEtBQWtCLGVBQTFELElBQTZFLFNBQVMsSUFBVCxLQUFrQixnQkFBbkcsRUFDSixLQUFLLDBCQUFMLENBQWdDLFFBQWhDLEVBREksS0FFQSxJQUFJLFNBQVMsSUFBVCxLQUFrQixhQUFsQixJQUFtQyxTQUFTLElBQVQsS0FBa0IsTUFBckQsSUFBK0QsU0FBUyxJQUFULEtBQWtCLGFBQWpGLElBQWtHLFNBQVMsSUFBVCxLQUFrQixVQUFwSCxJQUFrSSxTQUFTLElBQVQsS0FBa0IsV0FBcEosSUFBbUssU0FBUyxJQUFULEtBQWtCLGlCQUF6TCxFQUNKLEtBQUssc0JBQUwsQ0FBNEIsUUFBNUI7QUFDRDtBQUNEO0FBRUQsQ0F0QkQ7O0FBd0JBLE1BQU0sU0FBTixDQUFnQiwyQkFBaEIsR0FBOEMsVUFBVSxRQUFWLEVBQW9CO0FBQ2pFLEtBQUksQ0FBQyxTQUFTLGlCQUFWLElBQStCLFNBQVMsaUJBQVQsQ0FBMkIsTUFBM0IsR0FBb0MsQ0FBdkUsRUFDQzs7QUFFRCxLQUFJLGdCQUFnQixTQUFTLEtBQVQsQ0FBZSxRQUFuQztBQUNBLEtBQUksZ0JBQWdCLFNBQVMsS0FBVCxDQUFlLFFBQW5DO0FBQ0EsS0FBSSxVQUFKLEVBQWdCLFVBQWhCO0FBQ0EsS0FBSSxhQUFhLEtBQWpCOztBQUdBLE1BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxTQUFTLGlCQUFULENBQTJCLE1BQS9DLEVBQXVELEdBQXZELEVBQTREO0FBQzNELE1BQUksYUFBYSxLQUFLLElBQUwsQ0FBVSxTQUFTLGlCQUFULENBQTJCLENBQTNCLENBQVYsQ0FBakI7QUFDQSxNQUFJLElBQUksQ0FBUjtBQUNBLE1BQUksc0JBQXNCLEtBQTFCO0FBQ0EsTUFBSSxxQkFBcUIsS0FBekI7O0FBRUEsTUFBSSxXQUFXLGFBQVgsS0FBNkIsUUFBN0IsSUFBeUMsV0FBVyxhQUFYLEtBQTZCLFdBQTFFLEVBQXVGOztBQUV0RixPQUFJLGVBQWUsS0FBSyxnQkFBTCxDQUFzQixLQUF0QixDQUE0QixrQkFBNUIsR0FBaUQsS0FBSyxnQkFBTCxDQUFzQixLQUF0QixDQUE0QixrQkFBN0UsR0FBbUcsS0FBSyxRQUFMLENBQWMsS0FBZCxJQUF1QixLQUFLLFFBQUwsQ0FBYyxLQUFkLENBQW9CLGVBQTVDLEdBQ3BILEtBQUssUUFBTCxDQUFjLEtBQWQsQ0FBb0IsZUFEZ0csR0FDN0UsS0FBSyxRQUFMLENBQWMsS0FBZCxJQUF1QixLQUFLLFFBQUwsQ0FBYyxLQUFkLENBQW9CLE9BQTVDLEdBQXVELEtBQUssUUFBTCxDQUFjLEtBQWQsQ0FBb0IsT0FBM0UsR0FBcUYsQ0FBQyxRQUQ3SDs7QUFHQSxPQUFJLGVBQWUsS0FBSyxnQkFBTCxDQUFzQixLQUF0QixDQUE0QixrQkFBNUIsR0FBaUQsS0FBSyxnQkFBTCxDQUFzQixLQUF0QixDQUE0QixrQkFBN0UsR0FBbUcsS0FBSyxRQUFMLENBQWMsS0FBZCxJQUF1QixLQUFLLFFBQUwsQ0FBYyxLQUFkLENBQW9CLGVBQTVDLEdBQ3BILEtBQUssUUFBTCxDQUFjLEtBQWQsQ0FBb0IsZUFEZ0csR0FDN0UsS0FBSyxRQUFMLENBQWMsS0FBZCxJQUF1QixLQUFLLFFBQUwsQ0FBYyxLQUFkLENBQW9CLE9BQTVDLEdBQXVELEtBQUssUUFBTCxDQUFjLEtBQWQsQ0FBb0IsT0FBM0UsR0FBcUYsUUFENUg7QUFFQTs7QUFHRCxNQUFJLFdBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixDQUF6QixJQUE4QixXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsQ0FBekIsQ0FBMkIsT0FBekQsSUFBb0UsV0FBVyxVQUFYLEtBQTBCLFVBQWxHLEVBQThHO0FBQzdHLGdCQUFhLElBQWI7QUFDQTs7QUFFRCxPQUFLLElBQUksQ0FBVCxFQUFZLElBQUksV0FBVyxVQUFYLENBQXNCLE1BQXRDLEVBQThDLEdBQTlDLEVBQW1EOztBQUVsRCxPQUFJLE9BQU8sV0FBVyxVQUFYLENBQXNCLENBQXRCLEVBQXlCLENBQWhDLEtBQXNDLFdBQTFDLEVBQXVEO0FBQ3RELGVBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixDQUF6QixHQUE2QixDQUE3QjtBQUNBOztBQUVELE9BQUksV0FBVyxVQUFYLENBQXNCLENBQXRCLEVBQXlCLENBQXpCLENBQTJCLE9BQS9CLEVBQXdDO0FBQ3ZDLGlCQUFhLElBQWI7QUFDQSxpQkFBYSxXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsQ0FBekIsQ0FBMkIsT0FBM0IsRUFBYixDQUZ1QyxDQUVXO0FBQ2xELElBSEQsTUFLQyxhQUFhLFdBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixDQUF0Qzs7QUFFRCxnQkFBYSxXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsQ0FBdEM7O0FBR0EsT0FBSSxhQUFhLGNBQWMsR0FBL0IsRUFDQyxjQUFjLEdBQWQsR0FBb0IsVUFBcEI7QUFDRCxPQUFJLGFBQWEsY0FBYyxHQUEvQixFQUNDLGNBQWMsR0FBZCxHQUFvQixVQUFwQjs7QUFFRCxPQUFJLGFBQWEsY0FBYyxHQUEvQixFQUNDLGNBQWMsR0FBZCxHQUFvQixVQUFwQjs7QUFFRCxPQUFJLGFBQWEsY0FBYyxHQUEvQixFQUNDLGNBQWMsR0FBZCxHQUFvQixVQUFwQjs7QUFHRCxPQUFJLElBQUksQ0FBUixFQUFXO0FBQ1YsUUFBSSxRQUFRLGFBQWEsV0FBVyxVQUFYLENBQXNCLElBQUksQ0FBMUIsRUFBNkIsQ0FBdEQ7QUFDQSxZQUFRLENBQVIsS0FBYyxRQUFRLFFBQVEsQ0FBQyxDQUEvQixFQUZVLENBRXlCOztBQUVuQyxRQUFJLGNBQWMsT0FBZCxHQUF3QixLQUF4QixJQUFpQyxVQUFVLENBQS9DLEVBQWtEO0FBQ2pELG1CQUFjLE9BQWQsR0FBd0IsS0FBeEI7QUFDQTs7QUFFRCxRQUFJLGVBQWUsSUFBZixJQUF1QixXQUFXLFVBQVgsQ0FBc0IsSUFBSSxDQUExQixFQUE2QixDQUE3QixLQUFtQyxJQUE5RCxFQUFvRTtBQUNuRSxTQUFJLFFBQVEsYUFBYSxXQUFXLFVBQVgsQ0FBc0IsSUFBSSxDQUExQixFQUE2QixDQUF0RDtBQUNBLGFBQVEsQ0FBUixLQUFjLFFBQVEsUUFBUSxDQUFDLENBQS9CLEVBRm1FLENBRWhDOztBQUVuQyxTQUFJLGNBQWMsT0FBZCxHQUF3QixLQUF4QixJQUFpQyxVQUFVLENBQS9DLEVBQWtEO0FBQ2pELG9CQUFjLE9BQWQsR0FBd0IsS0FBeEI7QUFDRjtBQUNDO0FBQ0Q7O0FBRUQ7QUFDQSxPQUFJLGFBQWEsWUFBYixJQUE2QixDQUFDLG1CQUFsQyxFQUF1RDtBQUN0RDtBQUNBLElBRkQsTUFFTyxJQUFJLENBQUMsbUJBQUwsRUFBMEI7QUFDaEMsMEJBQXNCLElBQXRCOztBQUVBLFFBQUksSUFBSSxDQUFSLEVBQVc7QUFDVixVQUFLLENBQUw7QUFDQTtBQUNBO0FBQ0Q7O0FBRUQ7QUFDQSxPQUFJLGFBQWEsWUFBYixJQUE2QixDQUFDLGtCQUFsQyxFQUFzRDtBQUNyRCx5QkFBcUIsSUFBckI7QUFDQSxJQUZELE1BRU8sSUFBSSxhQUFhLFlBQWIsSUFBNkIsa0JBQWpDLEVBQXFEO0FBQzNEO0FBQ0E7O0FBRUQsT0FBSSxXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsS0FBN0IsRUFDQyxTQUFTLEtBQVQsQ0FBZSxNQUFmLENBQXNCLFVBQXRCLElBQW9DLFdBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixLQUE3RDs7QUFHRCxPQUFJLGFBQWEsY0FBYyxXQUEvQixFQUNDLGNBQWMsV0FBZCxHQUE0QixVQUE1QjtBQUNELE9BQUksYUFBYSxjQUFjLFdBQS9CLEVBQ0MsY0FBYyxXQUFkLEdBQTRCLFVBQTVCOztBQUVELE9BQUksZUFBZSxJQUFuQixFQUNDOztBQUVELE9BQUksYUFBYSxjQUFjLFdBQS9CLEVBQ0MsY0FBYyxXQUFkLEdBQTRCLFVBQTVCO0FBQ0QsT0FBSSxhQUFhLGNBQWMsV0FBL0IsRUFDQyxjQUFjLFdBQWQsR0FBNEIsVUFBNUI7QUFDRDs7QUFFRCxPQUFLLFFBQUwsQ0FBYyxjQUFkLEdBQStCLFdBQVcsVUFBWCxHQUF3QixhQUFhLFVBQWIsR0FBMEIsUUFBakY7QUFDQTs7QUFFRDtBQUNBO0FBQ0EsQ0F0SEQ7O0FBd0hBLE1BQU0sU0FBTixDQUFnQix1QkFBaEIsR0FBMEMsVUFBVSxRQUFWLEVBQW9COztBQUU3RCxLQUFJLENBQUMsU0FBUyxpQkFBVixJQUErQixTQUFTLGlCQUFULENBQTJCLE1BQTNCLEdBQW9DLENBQXZFLEVBQ0M7O0FBRUQsS0FBSSxnQkFBZ0IsU0FBUyxLQUFULENBQWUsUUFBbkM7QUFDQSxLQUFJLGdCQUFnQixTQUFTLEtBQVQsQ0FBZSxRQUFuQzs7QUFFQSxLQUFJLFVBQUosRUFBZ0IsVUFBaEI7QUFDQSxLQUFJLGFBQWEsS0FBakI7O0FBRUEsS0FBSSx5QkFBeUIsRUFBN0I7QUFDQSxLQUFJLHlCQUF5QixFQUE3Qjs7QUFFQSxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDtBQUMzRCxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUFWLENBQWpCO0FBQ0EsTUFBSSxJQUFJLENBQVI7QUFDQSxNQUFJLHNCQUFzQixLQUExQjtBQUNBLE1BQUkscUJBQXFCLEtBQXpCOztBQUVBLE1BQUksV0FBVyxhQUFYLEtBQTZCLFFBQTdCLElBQXlDLFdBQVcsYUFBWCxLQUE2QixXQUExRSxFQUF1Rjs7QUFFdEYsT0FBSSxlQUFlLEtBQUssZ0JBQUwsQ0FBc0IsS0FBdEIsQ0FBNEIsa0JBQTVCLEdBQWlELEtBQUssZ0JBQUwsQ0FBc0IsS0FBdEIsQ0FBNEIsa0JBQTdFLEdBQW1HLEtBQUssUUFBTCxDQUFjLEtBQWQsSUFBdUIsS0FBSyxRQUFMLENBQWMsS0FBZCxDQUFvQixlQUE1QyxHQUNwSCxLQUFLLFFBQUwsQ0FBYyxLQUFkLENBQW9CLGVBRGdHLEdBQzdFLEtBQUssUUFBTCxDQUFjLEtBQWQsSUFBdUIsS0FBSyxRQUFMLENBQWMsS0FBZCxDQUFvQixPQUE1QyxHQUF1RCxLQUFLLFFBQUwsQ0FBYyxLQUFkLENBQW9CLE9BQTNFLEdBQXFGLENBQUMsUUFEN0g7O0FBR0EsT0FBSSxlQUFlLEtBQUssZ0JBQUwsQ0FBc0IsS0FBdEIsQ0FBNEIsa0JBQTVCLEdBQWlELEtBQUssZ0JBQUwsQ0FBc0IsS0FBdEIsQ0FBNEIsa0JBQTdFLEdBQW1HLEtBQUssUUFBTCxDQUFjLEtBQWQsSUFBdUIsS0FBSyxRQUFMLENBQWMsS0FBZCxDQUFvQixlQUE1QyxHQUNwSCxLQUFLLFFBQUwsQ0FBYyxLQUFkLENBQW9CLGVBRGdHLEdBQzdFLEtBQUssUUFBTCxDQUFjLEtBQWQsSUFBdUIsS0FBSyxRQUFMLENBQWMsS0FBZCxDQUFvQixPQUE1QyxHQUF1RCxLQUFLLFFBQUwsQ0FBYyxLQUFkLENBQW9CLE9BQTNFLEdBQXFGLFFBRDVIO0FBRUE7O0FBR0QsTUFBSSxXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsQ0FBekIsSUFBOEIsV0FBVyxVQUFYLENBQXNCLENBQXRCLEVBQXlCLENBQXpCLENBQTJCLE9BQXpELElBQW9FLFdBQVcsVUFBWCxLQUEwQixVQUFsRyxFQUE4RztBQUM3RyxnQkFBYSxJQUFiO0FBQ0E7O0FBRUQsT0FBSyxJQUFJLENBQVQsRUFBWSxJQUFJLFdBQVcsVUFBWCxDQUFzQixNQUF0QyxFQUE4QyxHQUE5QyxFQUFtRDs7QUFFbEQ7QUFDQSxPQUFJLE9BQU8sV0FBVyxVQUFYLENBQXNCLENBQXRCLEVBQXlCLENBQWhDLEtBQXNDLFdBQTFDLEVBQXVEO0FBQ3RELGVBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixDQUF6QixHQUE2QixDQUE3QjtBQUNBOztBQUVELE9BQUksV0FBVyxVQUFYLENBQXNCLENBQXRCLEVBQXlCLENBQXpCLENBQTJCLE9BQS9CLEVBQXdDO0FBQ3ZDLGlCQUFhLElBQWI7QUFDQSxpQkFBYSxXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsQ0FBekIsQ0FBMkIsT0FBM0IsRUFBYixDQUZ1QyxDQUVXO0FBQ2xELElBSEQsTUFLQyxhQUFhLFdBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixDQUF0Qzs7QUFFRCxnQkFBYSxXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsQ0FBdEM7O0FBSUEsT0FBSSxhQUFhLGNBQWMsR0FBL0IsRUFDQyxjQUFjLEdBQWQsR0FBb0IsVUFBcEI7QUFDRCxPQUFJLGFBQWEsY0FBYyxHQUEvQixFQUNDLGNBQWMsR0FBZCxHQUFvQixVQUFwQjs7QUFFRCxPQUFJLElBQUksQ0FBUixFQUFXO0FBQ1YsUUFBSSxRQUFRLGFBQWEsV0FBVyxVQUFYLENBQXNCLElBQUksQ0FBMUIsRUFBNkIsQ0FBdEQ7QUFDQSxZQUFRLENBQVIsS0FBYyxRQUFRLFFBQVEsQ0FBQyxDQUEvQixFQUZVLENBRXlCOztBQUVuQyxRQUFJLGNBQWMsT0FBZCxHQUF3QixLQUF4QixJQUFpQyxVQUFVLENBQS9DLEVBQWtEO0FBQ2pELG1CQUFjLE9BQWQsR0FBd0IsS0FBeEI7QUFDQTs7QUFFRCxRQUFJLGVBQWUsSUFBZixJQUF1QixXQUFXLFVBQVgsQ0FBc0IsSUFBSSxDQUExQixFQUE2QixDQUE3QixLQUFtQyxJQUE5RCxFQUFvRTtBQUNuRSxTQUFJLFFBQVEsYUFBYSxXQUFXLFVBQVgsQ0FBc0IsSUFBSSxDQUExQixFQUE2QixDQUF0RDtBQUNBLGFBQVEsQ0FBUixLQUFjLFFBQVEsUUFBUSxDQUFDLENBQS9CLEVBRm1FLENBRWhDOztBQUVuQyxTQUFJLGNBQWMsT0FBZCxHQUF3QixLQUF4QixJQUFpQyxVQUFVLENBQS9DLEVBQWtEO0FBQ2pELG9CQUFjLE9BQWQsR0FBd0IsS0FBeEI7QUFDRjtBQUNDO0FBQ0Q7O0FBRUQ7QUFDQSxPQUFJLGFBQWEsWUFBYixJQUE2QixDQUFDLG1CQUFsQyxFQUF1RDtBQUN0RDtBQUNBLElBRkQsTUFFTyxJQUFJLENBQUMsbUJBQUwsRUFBMEI7QUFDaEMsMEJBQXNCLElBQXRCOztBQUVBLFFBQUksSUFBSSxDQUFSLEVBQVc7QUFDVixVQUFLLENBQUw7QUFDQTtBQUNBO0FBQ0Q7O0FBRUQ7QUFDQSxPQUFJLGFBQWEsWUFBYixJQUE2QixDQUFDLGtCQUFsQyxFQUFzRDtBQUNyRCx5QkFBcUIsSUFBckI7QUFDQSxJQUZELE1BRU8sSUFBSSxhQUFhLFlBQWIsSUFBNkIsa0JBQWpDLEVBQXFEO0FBQzNEO0FBQ0E7O0FBR0QsT0FBSSxXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsS0FBN0IsRUFDQyxTQUFTLEtBQVQsQ0FBZSxNQUFmLENBQXNCLFVBQXRCLElBQW9DLFdBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixLQUE3RDs7QUFFRCxPQUFJLGFBQWEsY0FBYyxXQUEvQixFQUNDLGNBQWMsV0FBZCxHQUE0QixVQUE1QjtBQUNELE9BQUksYUFBYSxjQUFjLFdBQS9CLEVBQ0MsY0FBYyxXQUFkLEdBQTRCLFVBQTVCOztBQUVELE9BQUksZUFBZSxJQUFuQixFQUNDOztBQUVELFlBQVMsT0FBVCxDQUFpQixVQUFqQixJQUErQixDQUFDLENBQUMsU0FBUyxPQUFULENBQWlCLFVBQWpCLENBQUQsR0FBZ0MsQ0FBaEMsR0FBb0MsU0FBUyxPQUFULENBQWlCLFVBQWpCLENBQXJDLElBQXFFLEtBQUssR0FBTCxDQUFTLFVBQVQsQ0FBcEc7O0FBRUEsT0FBSSxjQUFjLENBQWxCLEVBQXFCO0FBQ3BCLFFBQUksdUJBQXVCLFVBQXZCLENBQUosRUFDQyx1QkFBdUIsVUFBdkIsS0FBc0MsVUFBdEMsQ0FERCxLQUdDLHVCQUF1QixVQUF2QixJQUFxQyxVQUFyQztBQUNELElBTEQsTUFLTztBQUNOLFFBQUksdUJBQXVCLFVBQXZCLENBQUosRUFDQyx1QkFBdUIsVUFBdkIsS0FBc0MsVUFBdEMsQ0FERCxLQUdDLHVCQUF1QixVQUF2QixJQUFxQyxVQUFyQztBQUNEO0FBQ0Q7O0FBRUQsT0FBSyxRQUFMLENBQWMsY0FBZCxHQUErQixXQUFXLFVBQVgsR0FBd0IsYUFBYSxVQUFiLEdBQTBCLFFBQWpGO0FBQ0E7O0FBRUQsTUFBSyxDQUFMLElBQVUsc0JBQVYsRUFBa0M7QUFDakMsTUFBSSx1QkFBdUIsY0FBdkIsQ0FBc0MsQ0FBdEMsQ0FBSixFQUE4QztBQUM5QyxPQUFJLE1BQU0sQ0FBTixDQUFKLEVBQWM7QUFDYjtBQUNBO0FBQ0QsT0FBSSxPQUFPLHVCQUF1QixDQUF2QixDQUFYOztBQUVBLE9BQUksT0FBTyxjQUFjLEdBQXpCLEVBQ0MsY0FBYyxHQUFkLEdBQW9CLElBQXBCOztBQUVELE9BQUksT0FBTyxjQUFjLEdBQXpCLEVBQ0MsY0FBYyxHQUFkLEdBQW9CLElBQXBCOztBQUVELE9BQUksSUFBSSxjQUFjLFdBQWxCLElBQWlDLElBQUksY0FBYyxXQUF2RCxFQUNDOztBQUVELE9BQUksT0FBTyxjQUFjLFdBQXpCLEVBQ0MsY0FBYyxXQUFkLEdBQTRCLElBQTVCO0FBQ0QsT0FBSSxPQUFPLGNBQWMsV0FBekIsRUFDQyxjQUFjLFdBQWQsR0FBNEIsSUFBNUI7QUFDRDtBQUVBOztBQUVELE1BQUssQ0FBTCxJQUFVLHNCQUFWLEVBQWtDOztBQUVqQyxNQUFJLHVCQUF1QixjQUF2QixDQUFzQyxDQUF0QyxDQUFKLEVBQThDO0FBQzlDLE9BQUksTUFBTSxDQUFOLENBQUosRUFBYztBQUNiO0FBQ0E7O0FBRUQsT0FBSSxPQUFPLHVCQUF1QixDQUF2QixDQUFYOztBQUVBLE9BQUksT0FBTyxjQUFjLEdBQXpCLEVBQ0MsY0FBYyxHQUFkLEdBQW9CLElBQXBCOztBQUVELE9BQUksT0FBTyxjQUFjLEdBQXpCLEVBQ0MsY0FBYyxHQUFkLEdBQW9CLElBQXBCOztBQUVELE9BQUksSUFBSSxjQUFjLFdBQWxCLElBQWlDLElBQUksY0FBYyxXQUF2RCxFQUNDOztBQUVELE9BQUksT0FBTyxjQUFjLFdBQXpCLEVBQ0MsY0FBYyxXQUFkLEdBQTRCLElBQTVCO0FBQ0QsT0FBSSxPQUFPLGNBQWMsV0FBekIsRUFDQyxjQUFjLFdBQWQsR0FBNEIsSUFBNUI7QUFDRDtBQUVBOztBQUdEO0FBQ0E7O0FBRUE7QUFDQSxDQW5MRDs7QUFxTEEsTUFBTSxTQUFOLENBQWdCLDBCQUFoQixHQUE2QyxVQUFVLFFBQVYsRUFBb0I7QUFDaEUsS0FBSSxDQUFDLFNBQVMsaUJBQVYsSUFBK0IsU0FBUyxpQkFBVCxDQUEyQixNQUEzQixHQUFvQyxDQUF2RSxFQUNDOztBQUVELEtBQUksZ0JBQWdCLFNBQVMsS0FBVCxDQUFlLFFBQW5DO0FBQ0EsS0FBSSxnQkFBZ0IsU0FBUyxLQUFULENBQWUsUUFBbkM7O0FBRUEsS0FBSSxVQUFKLEVBQWdCLFVBQWhCO0FBQ0EsS0FBSSxhQUFhLEtBQWpCO0FBQ0EsS0FBSSxvQkFBb0IsS0FBeEI7QUFDQSxLQUFJLG9CQUFvQixLQUF4Qjs7QUFFQSxLQUFJLGlCQUFpQixFQUFyQjs7QUFFQSxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksU0FBUyxpQkFBVCxDQUEyQixNQUEvQyxFQUF1RCxHQUF2RCxFQUE0RDtBQUMzRCxNQUFJLGFBQWEsS0FBSyxJQUFMLENBQVUsU0FBUyxpQkFBVCxDQUEyQixDQUEzQixDQUFWLENBQWpCO0FBQ0EsTUFBSSxJQUFJLENBQVI7QUFDQSxNQUFJLHNCQUFzQixLQUExQjtBQUNBLE1BQUkscUJBQXFCLEtBQXpCOztBQUVBLE1BQUksV0FBVyxhQUFYLEtBQTZCLFFBQTdCLElBQXlDLFdBQVcsYUFBWCxLQUE2QixXQUExRSxFQUF1Rjs7QUFFdEYsT0FBSSxlQUFlLEtBQUssZ0JBQUwsQ0FBc0IsS0FBdEIsQ0FBNEIsa0JBQTVCLEdBQWlELEtBQUssZ0JBQUwsQ0FBc0IsS0FBdEIsQ0FBNEIsa0JBQTdFLEdBQW1HLEtBQUssUUFBTCxDQUFjLEtBQWQsSUFBdUIsS0FBSyxRQUFMLENBQWMsS0FBZCxDQUFvQixlQUE1QyxHQUNwSCxLQUFLLFFBQUwsQ0FBYyxLQUFkLENBQW9CLGVBRGdHLEdBQzdFLEtBQUssUUFBTCxDQUFjLEtBQWQsSUFBdUIsS0FBSyxRQUFMLENBQWMsS0FBZCxDQUFvQixPQUE1QyxHQUF1RCxLQUFLLFFBQUwsQ0FBYyxLQUFkLENBQW9CLE9BQTNFLEdBQXFGLENBQUMsUUFEN0g7O0FBR0EsT0FBSSxlQUFlLEtBQUssZ0JBQUwsQ0FBc0IsS0FBdEIsQ0FBNEIsa0JBQTVCLEdBQWlELEtBQUssZ0JBQUwsQ0FBc0IsS0FBdEIsQ0FBNEIsa0JBQTdFLEdBQW1HLEtBQUssUUFBTCxDQUFjLEtBQWQsSUFBdUIsS0FBSyxRQUFMLENBQWMsS0FBZCxDQUFvQixlQUE1QyxHQUNwSCxLQUFLLFFBQUwsQ0FBYyxLQUFkLENBQW9CLGVBRGdHLEdBQzdFLEtBQUssUUFBTCxDQUFjLEtBQWQsSUFBdUIsS0FBSyxRQUFMLENBQWMsS0FBZCxDQUFvQixPQUE1QyxHQUF1RCxLQUFLLFFBQUwsQ0FBYyxLQUFkLENBQW9CLE9BQTNFLEdBQXFGLFFBRDVIO0FBRUE7O0FBR0QsTUFBSSxXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsQ0FBekIsSUFBOEIsV0FBVyxVQUFYLENBQXNCLENBQXRCLEVBQXlCLENBQXpCLENBQTJCLE9BQXpELElBQW9FLFdBQVcsVUFBWCxLQUEwQixVQUFsRyxFQUE4RztBQUM3RyxnQkFBYSxJQUFiO0FBQ0E7O0FBRUQsT0FBSyxJQUFJLENBQVQsRUFBWSxJQUFJLFdBQVcsVUFBWCxDQUFzQixNQUF0QyxFQUE4QyxHQUE5QyxFQUFtRDs7QUFFbEQ7QUFDQSxPQUFJLE9BQU8sV0FBVyxVQUFYLENBQXNCLENBQXRCLEVBQXlCLENBQWhDLEtBQXNDLFdBQTFDLEVBQXVEO0FBQ3RELGVBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixDQUF6QixHQUE2QixDQUE3QjtBQUNBOztBQUVELE9BQUksV0FBVyxVQUFYLENBQXNCLENBQXRCLEVBQXlCLENBQXpCLENBQTJCLE9BQS9CLEVBQXdDO0FBQ3ZDLGlCQUFhLElBQWI7QUFDQSxpQkFBYSxXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsQ0FBekIsQ0FBMkIsT0FBM0IsRUFBYixDQUZ1QyxDQUVXO0FBQ2xELElBSEQsTUFLQyxhQUFhLFdBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixDQUF0Qzs7QUFFRCxnQkFBYSxXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsQ0FBdEM7O0FBSUEsT0FBSSxhQUFhLGNBQWMsR0FBL0IsRUFDQyxjQUFjLEdBQWQsR0FBb0IsVUFBcEI7QUFDRCxPQUFJLGFBQWEsY0FBYyxHQUEvQixFQUNDLGNBQWMsR0FBZCxHQUFvQixVQUFwQjs7QUFFRCxPQUFJLElBQUksQ0FBUixFQUFXO0FBQ1YsUUFBSSxRQUFRLGFBQWEsV0FBVyxVQUFYLENBQXNCLElBQUksQ0FBMUIsRUFBNkIsQ0FBdEQ7QUFDQSxZQUFRLENBQVIsS0FBYyxRQUFRLFFBQVEsQ0FBQyxDQUEvQixFQUZVLENBRXlCOztBQUVuQyxRQUFJLGNBQWMsT0FBZCxHQUF3QixLQUF4QixJQUFpQyxVQUFVLENBQS9DLEVBQWtEO0FBQ2pELG1CQUFjLE9BQWQsR0FBd0IsS0FBeEI7QUFDQTs7QUFFRCxRQUFJLGVBQWUsSUFBZixJQUF1QixXQUFXLFVBQVgsQ0FBc0IsSUFBSSxDQUExQixFQUE2QixDQUE3QixLQUFtQyxJQUE5RCxFQUFvRTtBQUNuRSxTQUFJLFFBQVEsYUFBYSxXQUFXLFVBQVgsQ0FBc0IsSUFBSSxDQUExQixFQUE2QixDQUF0RDtBQUNBLGFBQVEsQ0FBUixLQUFjLFFBQVEsUUFBUSxDQUFDLENBQS9CLEVBRm1FLENBRWhDOztBQUVuQyxTQUFJLGNBQWMsT0FBZCxHQUF3QixLQUF4QixJQUFpQyxVQUFVLENBQS9DLEVBQWtEO0FBQ2pELG9CQUFjLE9BQWQsR0FBd0IsS0FBeEI7QUFDRjtBQUNDO0FBQ0Q7O0FBRUQ7QUFDQSxPQUFJLGFBQWEsWUFBYixJQUE2QixDQUFDLG1CQUFsQyxFQUF1RDtBQUN0RDtBQUNBLElBRkQsTUFFTyxJQUFJLENBQUMsbUJBQUwsRUFBMEI7QUFDaEMsMEJBQXNCLElBQXRCOztBQUVBLFFBQUksSUFBSSxDQUFSLEVBQVc7QUFDVixVQUFLLENBQUw7QUFDQTtBQUNBO0FBQ0Q7O0FBRUQ7QUFDQSxPQUFJLGFBQWEsWUFBYixJQUE2QixDQUFDLGtCQUFsQyxFQUFzRDtBQUNyRCx5QkFBcUIsSUFBckI7QUFDQSxJQUZELE1BRU8sSUFBSSxhQUFhLFlBQWIsSUFBNkIsa0JBQWpDLEVBQXFEO0FBQzNEO0FBQ0E7O0FBRUQsT0FBSSxXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsS0FBN0IsRUFDQyxTQUFTLEtBQVQsQ0FBZSxNQUFmLENBQXNCLFVBQXRCLElBQW9DLFdBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixLQUE3RDs7QUFFRCxPQUFJLGFBQWEsY0FBYyxXQUEvQixFQUNDLGNBQWMsV0FBZCxHQUE0QixVQUE1QjtBQUNELE9BQUksYUFBYSxjQUFjLFdBQS9CLEVBQ0MsY0FBYyxXQUFkLEdBQTRCLFVBQTVCOztBQUVELE9BQUksZUFBZSxJQUFuQixFQUNDOztBQUVELFlBQVMsT0FBVCxDQUFpQixVQUFqQixJQUErQixDQUFDLENBQUMsU0FBUyxPQUFULENBQWlCLFVBQWpCLENBQUQsR0FBZ0MsQ0FBaEMsR0FBb0MsU0FBUyxPQUFULENBQWlCLFVBQWpCLENBQXJDLElBQXFFLEtBQUssR0FBTCxDQUFTLFVBQVQsQ0FBcEc7O0FBRUEsT0FBSSxjQUFjLENBQWxCLEVBQXFCO0FBQ3BCLHdCQUFvQixJQUFwQjtBQUNBLElBRkQsTUFFTztBQUNOLHdCQUFvQixJQUFwQjtBQUNBOztBQUVELE9BQUksZUFBZSxVQUFmLENBQUosRUFDQyxlQUFlLFVBQWYsS0FBOEIsS0FBSyxHQUFMLENBQVMsVUFBVCxDQUE5QixDQURELEtBR0MsZUFBZSxVQUFmLElBQTZCLEtBQUssR0FBTCxDQUFTLFVBQVQsQ0FBN0I7QUFDRDs7QUFFRCxPQUFLLFFBQUwsQ0FBYyxjQUFkLEdBQStCLFdBQVcsVUFBWCxHQUF3QixhQUFhLFVBQWIsR0FBMEIsUUFBakY7QUFDQTs7QUFHRCxLQUFJLHFCQUFxQixDQUFDLGlCQUExQixFQUE2QztBQUM1QyxnQkFBYyxHQUFkLEdBQW9CLEVBQXBCO0FBQ0EsZ0JBQWMsR0FBZCxHQUFvQixDQUFwQjtBQUNBLEVBSEQsTUFHTyxJQUFJLHFCQUFxQixpQkFBekIsRUFBNEM7QUFDbEQsZ0JBQWMsR0FBZCxHQUFvQixFQUFwQjtBQUNBLGdCQUFjLEdBQWQsR0FBb0IsQ0FBQyxFQUFyQjtBQUNBLEVBSE0sTUFHQSxJQUFJLENBQUMsaUJBQUQsSUFBc0IsaUJBQTFCLEVBQTZDO0FBQ25ELGdCQUFjLEdBQWQsR0FBb0IsQ0FBQyxDQUFyQjtBQUNBLGdCQUFjLEdBQWQsR0FBb0IsQ0FBQyxFQUFyQjtBQUNBOztBQUVELGVBQWMsV0FBZCxHQUE0QixjQUFjLEdBQTFDO0FBQ0EsZUFBYyxXQUFkLEdBQTRCLGNBQWMsR0FBMUM7O0FBRUEsVUFBUyxjQUFULEdBQTBCLGNBQTFCOztBQUVBO0FBQ0E7O0FBRUE7QUFDQSxDQS9JRDs7QUFpSkEsTUFBTSxTQUFOLENBQWdCLHNCQUFoQixHQUF5QyxVQUFVLFFBQVYsRUFBb0I7QUFDNUQsS0FBSSxDQUFDLFNBQVMsaUJBQVYsSUFBK0IsU0FBUyxpQkFBVCxDQUEyQixNQUEzQixHQUFvQyxDQUF2RSxFQUNDOztBQUVELEtBQUksZ0JBQWdCLFNBQVMsS0FBVCxDQUFlLFFBQW5DO0FBQ0EsS0FBSSxnQkFBZ0IsU0FBUyxLQUFULENBQWUsUUFBbkM7QUFDQSxLQUFJLFVBQUosRUFBZ0IsVUFBaEIsRUFBNEIsYUFBNUIsRUFBMkMsYUFBM0M7QUFDQSxLQUFJLGFBQWEsS0FBakI7O0FBR0EsTUFBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFNBQVMsaUJBQVQsQ0FBMkIsTUFBL0MsRUFBdUQsR0FBdkQsRUFBNEQ7QUFDM0QsTUFBSSxhQUFhLEtBQUssSUFBTCxDQUFVLFNBQVMsaUJBQVQsQ0FBMkIsQ0FBM0IsQ0FBVixDQUFqQjtBQUNBLE1BQUksSUFBSSxDQUFSO0FBQ0EsTUFBSSxzQkFBc0IsS0FBMUI7QUFDQSxNQUFJLHFCQUFxQixLQUF6Qjs7QUFFQSxNQUFJLFdBQVcsYUFBWCxLQUE2QixRQUE3QixJQUF5QyxXQUFXLGFBQVgsS0FBNkIsV0FBMUUsRUFBdUY7O0FBRXRGLE9BQUksZUFBZSxLQUFLLGdCQUFMLENBQXNCLEtBQXRCLENBQTRCLGtCQUE1QixHQUFpRCxLQUFLLGdCQUFMLENBQXNCLEtBQXRCLENBQTRCLGtCQUE3RSxHQUFtRyxLQUFLLFFBQUwsQ0FBYyxLQUFkLElBQXVCLEtBQUssUUFBTCxDQUFjLEtBQWQsQ0FBb0IsZUFBNUMsR0FDcEgsS0FBSyxRQUFMLENBQWMsS0FBZCxDQUFvQixlQURnRyxHQUM3RSxLQUFLLFFBQUwsQ0FBYyxLQUFkLElBQXVCLEtBQUssUUFBTCxDQUFjLEtBQWQsQ0FBb0IsT0FBNUMsR0FBdUQsS0FBSyxRQUFMLENBQWMsS0FBZCxDQUFvQixPQUEzRSxHQUFxRixDQUFDLFFBRDdIOztBQUdBLE9BQUksZUFBZSxLQUFLLGdCQUFMLENBQXNCLEtBQXRCLENBQTRCLGtCQUE1QixHQUFpRCxLQUFLLGdCQUFMLENBQXNCLEtBQXRCLENBQTRCLGtCQUE3RSxHQUFtRyxLQUFLLFFBQUwsQ0FBYyxLQUFkLElBQXVCLEtBQUssUUFBTCxDQUFjLEtBQWQsQ0FBb0IsZUFBNUMsR0FDcEgsS0FBSyxRQUFMLENBQWMsS0FBZCxDQUFvQixlQURnRyxHQUM3RSxLQUFLLFFBQUwsQ0FBYyxLQUFkLElBQXVCLEtBQUssUUFBTCxDQUFjLEtBQWQsQ0FBb0IsT0FBNUMsR0FBdUQsS0FBSyxRQUFMLENBQWMsS0FBZCxDQUFvQixPQUEzRSxHQUFxRixRQUQ1SDtBQUVBOztBQUdELE1BQUksV0FBVyxVQUFYLENBQXNCLENBQXRCLEVBQXlCLENBQXpCLElBQThCLFdBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixDQUF6QixDQUEyQixPQUF6RCxJQUFvRSxXQUFXLFVBQVgsS0FBMEIsVUFBbEcsRUFBOEc7QUFDN0csZ0JBQWEsSUFBYjtBQUNBOztBQUVELE9BQUssSUFBSSxDQUFULEVBQVksSUFBSSxXQUFXLFVBQVgsQ0FBc0IsTUFBdEMsRUFBOEMsR0FBOUMsRUFBbUQ7O0FBRWxELE9BQUksT0FBTyxXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsQ0FBaEMsS0FBc0MsV0FBMUMsRUFBdUQ7QUFDdEQsZUFBVyxVQUFYLENBQXNCLENBQXRCLEVBQXlCLENBQXpCLEdBQTZCLENBQTdCO0FBQ0E7O0FBRUQsT0FBSSxXQUFXLFVBQVgsQ0FBc0IsQ0FBdEIsRUFBeUIsQ0FBekIsQ0FBMkIsT0FBL0IsRUFBd0M7QUFDdkMsaUJBQWEsSUFBYjtBQUNBLGlCQUFhLFdBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixDQUF6QixDQUEyQixPQUEzQixFQUFiLENBRnVDLENBRVc7QUFDbEQsSUFIRCxNQUtDLGFBQWEsV0FBVyxVQUFYLENBQXNCLENBQXRCLEVBQXlCLENBQXRDOztBQUVELGdCQUFhLFdBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixDQUF0Qzs7QUFFQSxPQUFJLGNBQWMsV0FBVyxNQUE3QixFQUFxQztBQUNwQyxvQkFBZ0IsS0FBSyxHQUFMLENBQVMsS0FBVCxDQUFlLElBQWYsRUFBcUIsVUFBckIsQ0FBaEI7QUFDQSxvQkFBZ0IsS0FBSyxHQUFMLENBQVMsS0FBVCxDQUFlLElBQWYsRUFBcUIsVUFBckIsQ0FBaEI7QUFDQTs7QUFHRCxPQUFJLGFBQWEsY0FBYyxHQUEvQixFQUNDLGNBQWMsR0FBZCxHQUFvQixVQUFwQjtBQUNELE9BQUksYUFBYSxjQUFjLEdBQS9CLEVBQ0MsY0FBYyxHQUFkLEdBQW9CLFVBQXBCOztBQUVELE9BQUksZ0JBQWdCLGNBQWMsR0FBbEMsRUFDQyxjQUFjLEdBQWQsR0FBb0IsYUFBcEI7O0FBRUQsT0FBSSxnQkFBZ0IsY0FBYyxHQUFsQyxFQUNDLGNBQWMsR0FBZCxHQUFvQixhQUFwQjs7QUFHRCxPQUFJLElBQUksQ0FBUixFQUFXO0FBQ1YsUUFBSSxRQUFRLGFBQWEsV0FBVyxVQUFYLENBQXNCLElBQUksQ0FBMUIsRUFBNkIsQ0FBdEQ7QUFDQSxZQUFRLENBQVIsS0FBYyxRQUFRLFFBQVEsQ0FBQyxDQUEvQixFQUZVLENBRXlCOztBQUVuQyxRQUFJLGNBQWMsT0FBZCxHQUF3QixLQUF4QixJQUFpQyxVQUFVLENBQS9DLEVBQWtEO0FBQ2pELG1CQUFjLE9BQWQsR0FBd0IsS0FBeEI7QUFDQTs7QUFFRCxRQUFJLFdBQVcsQ0FBWCxNQUFrQixJQUFsQixJQUEwQixXQUFXLFVBQVgsQ0FBc0IsSUFBSSxDQUExQixFQUE2QixDQUE3QixDQUErQixDQUEvQixNQUFzQyxJQUFwRSxFQUEwRTtBQUN6RSxTQUFJLFFBQVEsV0FBVyxDQUFYLElBQWdCLFdBQVcsVUFBWCxDQUFzQixJQUFJLENBQTFCLEVBQTZCLENBQTdCLENBQStCLENBQS9CLENBQTVCO0FBQ0EsYUFBUSxDQUFSLEtBQWMsUUFBUSxRQUFRLENBQUMsQ0FBL0IsRUFGeUUsQ0FFdEM7O0FBRW5DLFNBQUksY0FBYyxPQUFkLEdBQXdCLEtBQXhCLElBQWlDLFVBQVUsQ0FBL0MsRUFBa0Q7QUFDakQsb0JBQWMsT0FBZCxHQUF3QixLQUF4QjtBQUNGO0FBQ0M7QUFDRDs7QUFFRDtBQUNBLE9BQUksYUFBYSxZQUFiLElBQTZCLENBQUMsbUJBQWxDLEVBQXVEO0FBQ3REO0FBQ0EsSUFGRCxNQUVPLElBQUksQ0FBQyxtQkFBTCxFQUEwQjtBQUNoQywwQkFBc0IsSUFBdEI7O0FBRUEsUUFBSSxJQUFJLENBQVIsRUFBVztBQUNWLFVBQUssQ0FBTDtBQUNBO0FBQ0E7QUFDRDs7QUFFRDtBQUNBLE9BQUksYUFBYSxZQUFiLElBQTZCLENBQUMsa0JBQWxDLEVBQXNEO0FBQ3JELHlCQUFxQixJQUFyQjtBQUNBLElBRkQsTUFFTyxJQUFJLGFBQWEsWUFBYixJQUE2QixrQkFBakMsRUFBcUQ7QUFDM0Q7QUFDQTs7QUFFRCxPQUFJLFdBQVcsVUFBWCxDQUFzQixDQUF0QixFQUF5QixLQUE3QixFQUNDLFNBQVMsS0FBVCxDQUFlLE1BQWYsQ0FBc0IsVUFBdEIsSUFBb0MsV0FBVyxVQUFYLENBQXNCLENBQXRCLEVBQXlCLEtBQTdEOztBQUdELE9BQUksYUFBYSxjQUFjLFdBQS9CLEVBQ0MsY0FBYyxXQUFkLEdBQTRCLFVBQTVCO0FBQ0QsT0FBSSxhQUFhLGNBQWMsV0FBL0IsRUFDQyxjQUFjLFdBQWQsR0FBNEIsVUFBNUI7O0FBRUQsT0FBSSxlQUFlLElBQW5CLEVBQ0M7O0FBRUQsT0FBSSxnQkFBZ0IsY0FBYyxXQUFsQyxFQUNDLGNBQWMsV0FBZCxHQUE0QixhQUE1QjtBQUNELE9BQUksZ0JBQWdCLGNBQWMsV0FBbEMsRUFDQyxjQUFjLFdBQWQsR0FBNEIsYUFBNUI7QUFDRDs7QUFFRCxPQUFLLFFBQUwsQ0FBYyxjQUFkLEdBQStCLFdBQVcsVUFBWCxHQUF3QixhQUFhLFVBQWIsR0FBMEIsUUFBakY7QUFDQTs7QUFFRDtBQUNBO0FBQ0EsQ0EzSEQ7O0FBNkhBO0FBQ0EsTUFBTSxTQUFOLENBQWdCLGdCQUFoQixHQUFtQyxVQUFVLE1BQVYsRUFBa0IsTUFBbEIsRUFBMEIsVUFBMUIsRUFBc0M7O0FBRXhFLGNBQWEsY0FBYyxLQUEzQjtBQUNBLEtBQUksVUFBVSxFQUFkOztBQUVBLE1BQUssSUFBSSxJQUFJLEtBQUssb0JBQUwsQ0FBMEIsTUFBMUIsR0FBbUMsQ0FBaEQsRUFBbUQsS0FBSyxDQUF4RCxFQUEyRCxHQUEzRCxFQUFnRTtBQUMvRCxNQUFJLGFBQWEsS0FBSyxvQkFBTCxDQUEwQixDQUExQixDQUFqQjs7QUFFQSxNQUFJLFNBQVMsSUFBYjs7QUFFQSxXQUFTLFdBQVcsZ0JBQVgsQ0FBNEIsTUFBNUIsRUFBb0MsTUFBcEMsRUFBNEMsVUFBNUMsQ0FBVDtBQUNBLE1BQUksTUFBSixFQUNDLFFBQVEsSUFBUixDQUFhLE1BQWI7QUFDRDs7QUFFRCxLQUFJLGdCQUFnQixJQUFwQjtBQUNBLEtBQUksb0JBQW9CLEtBQXhCOztBQUVBLE1BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxRQUFRLE1BQTVCLEVBQW9DLEdBQXBDLEVBQXlDOztBQUV4QyxNQUFJLFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsSUFBdEIsS0FBK0IsTUFBL0IsSUFBeUMsUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixJQUF0QixLQUErQixVQUF4RSxJQUFzRixRQUFRLENBQVIsRUFBVyxVQUFYLENBQXNCLElBQXRCLEtBQStCLE1BQXJILElBQStILFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsSUFBdEIsS0FBK0IsVUFBbEssRUFBOEs7QUFDN0ssT0FBSSxhQUFhLHdCQUFZLFlBQVosRUFBMEIsUUFBUSxDQUFSLEVBQVcsU0FBckMsRUFBZ0QsUUFBUSxDQUFSLEVBQVcsVUFBM0QsS0FBMEUsQ0FBM0Y7QUFDQSxPQUFJLFFBQVEsQ0FBUixFQUFXLFFBQVgsSUFBdUIsYUFBYSxDQUF4QyxFQUEyQztBQUMxQyx3QkFBb0IsSUFBcEI7QUFDQTtBQUNBO0FBQ0Q7QUFDRDs7QUFFRCxNQUFLLElBQUksQ0FBVCxFQUFZLElBQUksUUFBUSxNQUF4QixFQUFnQyxHQUFoQyxFQUFxQzs7QUFFcEMsTUFBSSxxQkFBcUIsUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixJQUF0QixLQUErQixNQUFwRCxJQUE4RCxRQUFRLENBQVIsRUFBVyxVQUFYLENBQXNCLElBQXRCLEtBQStCLFVBQTdGLElBQTJHLFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsSUFBdEIsS0FBK0IsTUFBMUksSUFBb0osUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixJQUF0QixLQUErQixVQUF2TCxFQUNDOztBQUVELE1BQUksQ0FBQyxhQUFMLEVBQW9CO0FBQ25CLG1CQUFnQixRQUFRLENBQVIsQ0FBaEI7QUFDQSxHQUZELE1BRU8sSUFBSSxRQUFRLENBQVIsRUFBVyxRQUFYLElBQXVCLGNBQWMsUUFBekMsRUFBbUQ7QUFDekQsbUJBQWdCLFFBQVEsQ0FBUixDQUFoQjtBQUNBO0FBQ0Q7O0FBRUQsUUFBTyxhQUFQO0FBQ0EsQ0ExQ0Q7O0FBNENBLE1BQU0sU0FBTixDQUFnQixhQUFoQixHQUFnQyxVQUFVLE1BQVYsRUFBa0IsTUFBbEIsRUFBMEIsVUFBMUIsRUFBc0M7QUFDckUsY0FBYSxjQUFjLEtBQTNCOztBQUVBLEtBQUksS0FBSyxJQUFUOztBQUVBLEtBQUksZ0JBQWdCLEtBQUssZ0JBQUwsQ0FBc0IsTUFBdEIsRUFBOEIsTUFBOUIsRUFBc0MsVUFBdEMsQ0FBcEI7O0FBRUEsS0FBSSxhQUFKLEVBQW1CO0FBQ2xCLE9BQUssY0FBYyxVQUFkLENBQXlCLFlBQXpCLENBQXNDLGNBQWMsY0FBcEQsQ0FBTDtBQUNBLEVBRkQsTUFFTyxJQUFJLHdCQUFKLEVBQXVCO0FBQUM7QUFDOUIsT0FBSyx3QkFBWSxNQUFaLEVBQW9CLE1BQXBCLEVBQTRCLEtBQUssYUFBTCxDQUFtQixRQUEvQyxDQUFMO0FBQ0EsRUFGTSxNQUdGO0FBQ0osT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEtBQUssTUFBTCxDQUFZLEtBQVosQ0FBa0IsTUFBdEMsRUFBOEMsR0FBOUMsRUFBbUQ7QUFDbEQsT0FBSSxPQUFPLEtBQUssTUFBTCxDQUFZLEtBQVosQ0FBa0IsQ0FBbEIsQ0FBWDs7QUFFQSxPQUFJLFVBQVUsS0FBSyxFQUFmLElBQXFCLFVBQVUsS0FBSyxFQUFwQyxJQUEwQyxVQUFVLEtBQUssRUFBekQsSUFBK0QsVUFBVSxLQUFLLEVBQWxGLEVBQXNGO0FBQ3JGLFNBQUssS0FBSyxFQUFWO0FBQ0E7QUFDRDtBQUNEOztBQUVELFFBQU8sRUFBUDtBQUNBLENBdkJEOztBQXlCQTtBQUNBO0FBQ0E7QUFDQSxNQUFNLFNBQU4sQ0FBZ0IsZUFBaEIsR0FBa0MsVUFBVSxZQUFWLEVBQXdCLEtBQXhCLEVBQStCLE1BQS9CLEVBQXVDOztBQUV4RSxTQUFRLFNBQVMsS0FBSyxLQUF0QjtBQUNBLFVBQVMsVUFBVSxLQUFLLE1BQXhCOztBQUVBLEtBQUksc0JBQXNCLGVBQWUsR0FBekM7O0FBRUEsUUFBTyxLQUFLLEtBQUwsQ0FBVyxLQUFLLEdBQUwsQ0FBUyxLQUFLLEtBQWQsRUFBcUIsS0FBSyxNQUExQixJQUFvQyxtQkFBL0MsQ0FBUDtBQUNBLENBUkQ7O0FBVUE7O0FBRUEsTUFBTSxTQUFOLENBQWdCLG9CQUFoQixHQUF1QyxZQUFZO0FBQ2xEO0FBQ0E7QUFDQTtBQUNBLE1BQUssaUJBQUwsQ0FBdUIsU0FBdkIsQ0FBaUMsQ0FBakMsRUFBb0MsQ0FBcEMsRUFBdUMsS0FBSyxLQUE1QyxFQUFtRCxLQUFLLE1BQXhEO0FBQ0EsQ0FMRDs7QUFPQSxNQUFNLFNBQU4sQ0FBZ0IsV0FBaEIsR0FBOEIsWUFBWTtBQUN6QyxNQUFLLEdBQUwsQ0FBUyxTQUFULENBQW1CLENBQW5CLEVBQXNCLENBQXRCLEVBQXlCLEtBQUssS0FBOUIsRUFBcUMsS0FBSyxNQUExQzs7QUFFQSxLQUFJLEtBQUssZUFBVCxFQUEwQjtBQUN6QixPQUFLLEdBQUwsQ0FBUyxTQUFULEdBQXFCLEtBQUssZUFBMUI7QUFDQSxPQUFLLEdBQUwsQ0FBUyxRQUFULENBQWtCLENBQWxCLEVBQXFCLENBQXJCLEVBQXdCLEtBQUssS0FBN0IsRUFBb0MsS0FBSyxNQUF6QztBQUNBO0FBQ0QsQ0FQRDs7QUFTQSxNQUFNLFNBQU4sQ0FBZ0IsV0FBaEIsR0FBOEIsVUFBVSxLQUFWLEVBQWlCO0FBQzlDLE1BQUssT0FBTCxDQUFhLElBQWIsQ0FBa0IsS0FBbEI7QUFDQSxDQUZEOztBQUlBLE1BQU0sU0FBTixDQUFnQixrQkFBaEIsR0FBcUMsVUFBVSxFQUFWLEVBQWM7QUFDbEQsS0FBSSxDQUFDLEdBQUcsY0FBSixJQUFzQixDQUFDLEtBQUssb0JBQWhDLEVBQ0M7O0FBRUQsS0FBSSxjQUFjLEVBQWxCO0FBQ0EsS0FBSSxVQUFVLEdBQUcsY0FBakI7QUFDQSxLQUFJLFFBQVEsVUFBVSxRQUFRLENBQVIsQ0FBVixHQUF1QixFQUFuQztBQUNBLEtBQUksMEJBQTBCLElBQTlCOztBQUVBOztBQUVBLFNBQVEsR0FBRyxJQUFYO0FBQ0MsT0FBSyxZQUFMLENBQW1CLEtBQUssZUFBTDtBQUNsQixpQkFBYyxDQUFDLFdBQUQsRUFBYyxXQUFkLENBQWQ7QUFDQSxRQUFLLGNBQUwsR0FBc0IsZ0NBQW9CLEtBQXBCLENBQXRCO0FBQ0EsUUFBSyxjQUFMLENBQW9CLElBQXBCLEdBQTJCLElBQUksSUFBSixFQUEzQjtBQUNBO0FBQ0QsT0FBSyxXQUFMLENBQWtCLEtBQUssZUFBTDtBQUFzQixpQkFBYyxDQUFDLFdBQUQsQ0FBZCxDQUE2QjtBQUNyRSxPQUFLLFVBQUwsQ0FBaUIsS0FBSyxhQUFMO0FBQW9CLGlCQUFlLEtBQUssbUJBQUwsS0FBNkIsWUFBN0IsSUFBNkMsS0FBSyxtQkFBTCxLQUE2QixlQUEzRSxHQUE4RixDQUFDLFNBQUQsRUFBWSxPQUFaLENBQTlGLEdBQXFILENBQUMsU0FBRCxDQUFuSTtBQUNwQztBQUNEO0FBQVM7QUFUVjs7QUFZQSxLQUFJLFdBQVcsUUFBUSxNQUFSLEdBQWlCLENBQWhDLEVBQW1DOztBQUduQywyQkFBMEIsZ0NBQW9CLEtBQXBCLENBQTFCO0FBQ0EseUJBQXdCLElBQXhCLEdBQStCLElBQUksSUFBSixFQUEvQjtBQUNBLEtBQUk7QUFDSCxNQUFJLEtBQUssd0JBQXdCLENBQXhCLEdBQTRCLEtBQUssY0FBTCxDQUFvQixDQUF6RDtBQUNBLE1BQUksS0FBSyx3QkFBd0IsQ0FBeEIsR0FBNEIsS0FBSyxjQUFMLENBQW9CLENBQXpEO0FBQ0EsTUFBSSxLQUFLLHdCQUF3QixJQUF4QixHQUErQixLQUFLLGNBQUwsQ0FBb0IsSUFBNUQ7O0FBRUEsTUFBSSxLQUFLLEdBQUwsQ0FBUyxFQUFULElBQWUsRUFBZixLQUFzQixDQUFDLENBQUMsS0FBSyxjQUFMLENBQW9CLE1BQXRCLElBQWdDLEtBQUssR0FBM0QsQ0FBSixFQUFxRTtBQUNwRTtBQUNBLFFBQUssY0FBTCxDQUFvQixNQUFwQixHQUE2QixJQUE3Qjs7QUFFQSxPQUFJLE1BQU0sT0FBTyxNQUFQLElBQWlCLE1BQTNCO0FBQ0EsT0FBSSxPQUFPLElBQUksUUFBZixFQUNDLElBQUksUUFBSixDQUFhLENBQWIsRUFBZ0IsQ0FBQyxFQUFqQjtBQUNEO0FBQ0QsRUFiRCxDQWFFLE9BQU8sQ0FBUCxFQUFVLENBQUc7O0FBRWYsTUFBSyxtQkFBTCxHQUEyQixHQUFHLElBQTlCOztBQUVBLEtBQUksQ0FBQyxDQUFDLEtBQUssY0FBTCxDQUFvQixNQUF0QixJQUFnQyxLQUFLLFdBQXpDLEVBQXNEO0FBQ3JELE1BQUksS0FBSyxNQUFULEVBQ0MsS0FBSyxvQkFBTDs7QUFFRCxPQUFLLE1BQUwsR0FBYyxLQUFkO0FBQ0E7QUFDQTs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksWUFBWSxNQUFoQyxFQUF3QyxHQUF4QyxFQUE2Qzs7QUFFNUMsTUFBSSxPQUFPLFlBQVksQ0FBWixDQUFYO0FBQ0EsTUFBSSxpQkFBaUIsU0FBUyxXQUFULENBQXFCLFlBQXJCLENBQXJCO0FBQ0EsaUJBQWUsY0FBZixDQUE4QixJQUE5QixFQUFvQyxJQUFwQyxFQUEwQyxJQUExQyxFQUFnRCxNQUFoRCxFQUF3RCxDQUF4RCxFQUNRLE1BQU0sT0FEZCxFQUN1QixNQUFNLE9BRDdCLEVBRVEsTUFBTSxPQUZkLEVBRXVCLE1BQU0sT0FGN0IsRUFFc0MsS0FGdEMsRUFHUSxLQUhSLEVBR2UsS0FIZixFQUdzQixLQUh0QixFQUc2QixDQUg3QixFQUdnQyxJQUhoQzs7QUFLQSxRQUFNLE1BQU4sQ0FBYSxhQUFiLENBQTJCLGNBQTNCOztBQUVBLE1BQUksR0FBRyxtQkFBUCxFQUE0QjtBQUMzQjtBQUNBLE1BQUcsbUJBQUg7QUFDQTs7QUFFRCxNQUFJLEdBQUcsY0FBUCxFQUF1QjtBQUN0QjtBQUNBLE1BQUcsY0FBSDtBQUNBO0FBQ0Q7QUFDRCxDQTFFRDs7QUE0RUEsTUFBTSxTQUFOLENBQWdCLG1CQUFoQixHQUFzQyxVQUFVLFNBQVYsRUFBcUIsYUFBckIsRUFBb0M7QUFDekUsS0FBSSxpQkFBaUIsRUFBckI7O0FBRUEsZ0JBQWUsS0FBZixHQUF1QixLQUFLLHFCQUE1QjtBQUNBLGdCQUFlLElBQWYsR0FBc0IsU0FBdEI7QUFDQSxnQkFBZSxPQUFmLEdBQXlCLGFBQXpCOztBQUVBLEtBQUksT0FBTyxFQUFYOztBQUVBLEtBQUksS0FBSyxLQUFULEVBQ0MsS0FBSyxJQUFMLENBQVUsT0FBVjtBQUNELEtBQUksS0FBSyxLQUFULEVBQ0MsS0FBSyxJQUFMLENBQVUsT0FBVjtBQUNELEtBQUksS0FBSyxNQUFULEVBQ0MsS0FBSyxJQUFMLENBQVUsUUFBVjs7QUFFRCxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksS0FBSyxNQUF6QixFQUFpQyxHQUFqQyxFQUFzQztBQUNyQyxpQkFBZSxLQUFLLENBQUwsQ0FBZixJQUEwQjtBQUN6QixvQkFBaUIsS0FBSyxLQUFLLENBQUwsQ0FBTCxFQUFjLGdCQUFkLENBQStCLGtCQUR2QjtBQUV6QixvQkFBaUIsS0FBSyxLQUFLLENBQUwsQ0FBTCxFQUFjLGdCQUFkLENBQStCO0FBRnZCLEdBQTFCO0FBSUE7O0FBRUQsTUFBSyxhQUFMLENBQW1CLFNBQW5CLEVBQThCLGNBQTlCLEVBQThDLEtBQUsscUJBQW5EO0FBQ0EsQ0F4QkQ7O0FBMEJBLE1BQU0sU0FBTixDQUFnQixrQkFBaEIsR0FBcUMsVUFBVSxFQUFWLEVBQWM7O0FBRWxELEtBQUksQ0FBQyxLQUFLLG9CQUFWLEVBQ0M7O0FBRUQsS0FBSSxLQUFLLGdCQUFULEVBQTJCO0FBQzFCLE9BQUssZ0JBQUwsR0FBd0IsS0FBeEI7QUFDQTtBQUNBOztBQUVEO0FBQ0EsS0FBSSxHQUFHLG1CQUFQLEVBQTRCO0FBQzNCO0FBQ0EsS0FBRyxtQkFBSDtBQUNBOztBQUVEO0FBQ0EsS0FBSSxHQUFHLGNBQVAsRUFBdUI7QUFDdEI7QUFDQSxLQUFHLGNBQUg7QUFDQTs7QUFFRDtBQUNBLEtBQUksT0FBUSxHQUFHLE1BQVgsS0FBdUIsV0FBdkIsSUFBc0MsR0FBRyxVQUE3QyxFQUNDLEdBQUcsTUFBSCxHQUFZLEdBQUcsVUFBZjs7QUFFRDs7QUFFQSxLQUFJLEtBQUssZ0NBQW9CLEVBQXBCLENBQVQ7QUFDQSxLQUFJLE9BQU8sR0FBRyxJQUFkO0FBQ0EsS0FBSSxVQUFKO0FBQ0EsS0FBSSxVQUFKOztBQUVBLEtBQUksQ0FBQyxFQUFMLEVBQVMsSUFBSSxJQUFJLE9BQU8sS0FBZjtBQUNULEtBQUksR0FBRyxLQUFQLEVBQWMsYUFBYyxHQUFHLEtBQUgsSUFBWSxDQUExQixDQUFkLEtBQ0ssSUFBSSxHQUFHLE1BQVAsRUFBZSxhQUFjLEdBQUcsTUFBSCxJQUFhLENBQTNCOztBQUVwQjs7QUFFQTtBQUNBO0FBQ0E7O0FBRUEsS0FBSSx3QkFBZSxPQUFPLE9BQTFCLEVBQW1DO0FBQ2xDLFNBQU8sT0FBUCxDQUFlLEdBQWYsQ0FBbUIsT0FBTyxVQUFQLEdBQW9CLEdBQUcsQ0FBdkIsR0FBMkIsTUFBM0IsR0FBb0MsR0FBRyxDQUExRDtBQUNBLE1BQUksVUFBSixFQUNDLE9BQU8sT0FBUCxDQUFlLEdBQWYsQ0FBbUIsR0FBRyxLQUF0Qjs7QUFFRCxNQUFJLFNBQVMsU0FBYixFQUNDLE9BQU8sT0FBUCxDQUFlLEdBQWYsQ0FBbUIsU0FBbkI7QUFDRDs7QUFFRCxLQUFJLFVBQUosRUFDQzs7QUFFRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsS0FBSSxNQUFNLGtCQUFWLEVBQThCO0FBQzdCLGVBQWEsTUFBTSxrQkFBbkI7O0FBRUEsTUFBSSxTQUFTLFNBQWIsRUFBd0I7QUFDdkIsU0FBTSxrQkFBTixHQUEyQixJQUEzQjs7QUFFQSxPQUFJLFdBQVcsS0FBWCxDQUFpQixjQUFqQixDQUFnQyxjQUFwQyxFQUNDLFdBQVcsS0FBWCxDQUFpQixjQUFqQixDQUFnQyxjQUFoQyxHQURELEtBR0MsU0FBUyxJQUFULENBQWMsbUJBQWQsQ0FBa0MsU0FBbEMsRUFBNkMsV0FBVyxLQUFYLENBQWlCLGtCQUE5RCxFQUFrRixLQUFsRjtBQUVEOztBQUVELE1BQUksV0FBVyxjQUFYLENBQTBCLElBQTFCLENBQUosRUFDQyxXQUFXLElBQVgsRUFBaUIsSUFBakIsQ0FBc0IsV0FBVyxPQUFqQyxFQUEwQyxHQUFHLENBQTdDLEVBQWdELEdBQUcsQ0FBbkQ7QUFJRCxFQWxCRCxNQW1CSyxJQUFJLEtBQUssT0FBVCxFQUFrQjs7QUFFdEIsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEtBQUssT0FBTCxDQUFhLE1BQWpDLEVBQXlDLEdBQXpDLEVBQThDO0FBQzdDLE9BQUksQ0FBQyxLQUFLLE9BQUwsQ0FBYSxDQUFiLEVBQWdCLGNBQWhCLENBQStCLElBQS9CLENBQUwsRUFDQzs7QUFFRCxnQkFBYSxLQUFLLE9BQUwsQ0FBYSxDQUFiLENBQWI7QUFDQSxPQUFJLFNBQVMsV0FBVyxNQUF4Qjs7QUFFQSxPQUFJLEdBQUcsQ0FBSCxJQUFRLE9BQU8sRUFBZixJQUFxQixHQUFHLENBQUgsSUFBUSxPQUFPLEVBQXBDLElBQTBDLEdBQUcsQ0FBSCxJQUFRLE9BQU8sRUFBekQsSUFBK0QsR0FBRyxDQUFILElBQVEsT0FBTyxFQUFsRixFQUFzRjtBQUNyRixlQUFXLElBQVgsRUFBaUIsSUFBakIsQ0FBc0IsV0FBVyxPQUFqQyxFQUEwQyxHQUFHLENBQTdDLEVBQWdELEdBQUcsQ0FBbkQ7O0FBRUEsUUFBSSxTQUFTLFdBQVQsSUFBd0IsV0FBVyxPQUFYLEtBQXVCLElBQW5ELEVBQXlEO0FBQ3hELFdBQU0sa0JBQU4sR0FBMkIsVUFBM0I7O0FBRUEsU0FBSSxLQUFLLGNBQUwsQ0FBb0IsVUFBeEIsRUFDQyxLQUFLLGNBQUwsQ0FBb0IsVUFBcEIsR0FERCxLQUVLO0FBQ0osZUFBUyxJQUFULENBQWMsZ0JBQWQsQ0FBK0IsU0FBL0IsRUFBMEMsS0FBSyxrQkFBL0MsRUFBbUUsS0FBbkU7QUFDQTtBQUNBO0FBQ0QsS0FURCxNQVNPLElBQUksU0FBUyxTQUFiLEVBQXdCO0FBQzlCLFNBQUksV0FBVyxLQUFYLENBQWlCLGNBQWpCLENBQWdDLGNBQXBDLEVBQ0MsV0FBVyxLQUFYLENBQWlCLGNBQWpCLENBQWdDLGNBQWhDLEdBREQsS0FHQyxTQUFTLElBQVQsQ0FBYyxtQkFBZCxDQUFrQyxTQUFsQyxFQUE2QyxLQUFLLGtCQUFsRCxFQUFzRSxLQUF0RTtBQUNEOztBQUVEO0FBQ0EsSUFwQkQsTUFzQkMsYUFBYSxJQUFiO0FBQ0Q7O0FBRUQsTUFBSSxjQUFjLFdBQVcsTUFBN0IsRUFBcUM7QUFDcEMsTUFBRyxNQUFILENBQVUsS0FBVixDQUFnQixNQUFoQixHQUF5QixXQUFXLE1BQXBDO0FBQ0EsR0FGRCxNQUlDLEdBQUcsTUFBSCxDQUFVLEtBQVYsQ0FBZ0IsTUFBaEIsR0FBeUIsS0FBSyxjQUE5Qjs7QUFFRDtBQUNBOztBQUVELEtBQUksS0FBSyxRQUFMLElBQWlCLEtBQUssUUFBTCxDQUFjLE9BQW5DLEVBQTRDOztBQUUzQyxNQUFJLFdBQVcsS0FBSyxRQUFwQjs7QUFFQSxNQUFJLEdBQUcsQ0FBSCxHQUFPLFNBQVMsRUFBaEIsSUFBc0IsR0FBRyxDQUFILEdBQU8sU0FBUyxFQUF0QyxJQUE0QyxHQUFHLENBQUgsR0FBTyxTQUFTLEVBQTVELElBQWtFLEdBQUcsQ0FBSCxHQUFPLFNBQVMsRUFBdEYsRUFDQyxLQUFLLFFBQUwsQ0FBYyxJQUFkO0FBQ0Q7O0FBR0QsS0FBSSxDQUFDLENBQUMsS0FBSyxNQUFOLElBQWdCLENBQUMsS0FBSyxXQUF2QixLQUF1QyxLQUFLLGFBQWhELEVBQStEOztBQUU5RCxPQUFLLGFBQUwsQ0FBbUIsaUJBQW5CLENBQXFDLEVBQXJDO0FBQ0E7QUFDQTs7QUFFRDtBQUNBO0FBQ0EsQ0E3SUQ7O0FBK0lBLE1BQU0sU0FBTixDQUFnQixrQkFBaEIsR0FBcUMsVUFBVSxDQUFWLEVBQWEsQ0FBYixFQUFnQjtBQUNwRCxNQUFLLE1BQUwsR0FBYyxJQUFkOztBQUVBLEtBQUksS0FBSyxRQUFMLENBQWMsYUFBZCxLQUFnQyxNQUFwQyxFQUE0QztBQUMzQyxPQUFLLGNBQUwsR0FBc0IsRUFBRSxHQUFHLENBQUwsRUFBUSxHQUFHLENBQVgsRUFBdEI7QUFDQSxFQUZELE1BRU87QUFDTixPQUFLLGNBQUwsR0FBc0IsRUFBRSxHQUFHLENBQUwsRUFBUSxHQUFHLENBQVgsRUFBdEI7QUFDQTtBQUNELENBUkQ7O0FBVUEsTUFBTSxTQUFOLENBQWdCLGdCQUFoQixHQUFtQyxVQUFVLENBQVYsRUFBYSxDQUFiLEVBQWdCOztBQUVsRCxLQUFJLEtBQUssUUFBTCxDQUFjLGFBQWQsS0FBZ0MsUUFBaEMsSUFBNEMsS0FBSyxRQUFMLENBQWMsYUFBZCxLQUFnQyxXQUFoRixFQUE2RjtBQUM1RixNQUFJLEtBQUssTUFBVCxFQUFpQjtBQUNoQixPQUFJLFlBQVksQ0FBaEI7QUFBQSxPQUNDLGNBQWMsSUFBSSxLQUFLLGNBQUwsQ0FBb0IsQ0FEdkM7QUFBQSxPQUVDLGNBQWMsSUFBSSxLQUFLLGNBQUwsQ0FBb0IsQ0FGdkM7QUFBQSxPQUdDLFNBQVMsS0FBSyxRQUFMLENBQWMsT0FBZCxDQUFzQixHQUF0QixLQUE4QixDQUh4QztBQUFBLE9BRzJDO0FBQzFDLFlBQVMsS0FBSyxRQUFMLENBQWMsT0FBZCxDQUFzQixHQUF0QixLQUE4QixDQUp4QztBQUFBLE9BSTJDO0FBQzFDLGNBQVcsS0FMWjs7QUFPQSxRQUFLLG9CQUFMOztBQUVBLE9BQUksS0FBSyxRQUFMLENBQWMsYUFBZCxLQUFnQyxXQUFwQyxFQUFpRDtBQUNoRCxRQUFJLE9BQU8sTUFBWDtBQUNBLGFBQVMsTUFBVDtBQUNBLGFBQVMsSUFBVDtBQUNBOztBQUVELE9BQUksS0FBSyxVQUFMLElBQW1CLEtBQUssV0FBNUIsRUFBeUM7QUFDeEMsUUFBSSxLQUFLLFVBQVQsRUFBcUI7O0FBRXBCLFNBQUksV0FBVyxDQUFmOztBQUVBLFVBQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxLQUFLLEtBQUwsQ0FBVyxNQUEvQixFQUF1QyxHQUF2QyxFQUE0QztBQUMzQyxVQUFJLE9BQU8sS0FBSyxLQUFMLENBQVcsQ0FBWCxDQUFYOztBQUVBLFVBQUksS0FBSyxlQUFMLEdBQXVCLEtBQUssT0FBaEMsRUFBeUM7O0FBRXhDLGtCQUFXLEtBQUssT0FBTCxHQUFlLEtBQUssZUFBL0I7O0FBRUEsWUFBSyxnQkFBTCxDQUFzQixrQkFBdEIsR0FBMkMsS0FBSyxlQUFMLEdBQXVCLFFBQWxFO0FBQ0EsWUFBSyxnQkFBTCxDQUFzQixrQkFBdEIsR0FBMkMsS0FBSyxlQUFMLEdBQXVCLFFBQWxFOztBQUVELGtCQUFXLElBQVg7QUFDQyxPQVJELE1BUU8sSUFBSSxLQUFLLGVBQUwsR0FBdUIsS0FBSyxPQUFoQyxFQUF5Qzs7QUFFL0Msa0JBQVcsS0FBSyxlQUFMLEdBQXVCLEtBQUssT0FBdkM7QUFDQSxZQUFLLGdCQUFMLENBQXNCLGtCQUF0QixHQUEyQyxLQUFLLGVBQUwsR0FBdUIsUUFBbEU7QUFDQSxZQUFLLGdCQUFMLENBQXNCLGtCQUF0QixHQUEyQyxLQUFLLGVBQUwsR0FBdUIsUUFBbEU7O0FBRUQsa0JBQVcsSUFBWDtBQUNBO0FBQ0E7QUFFRCxLQXpCRCxNQTBCSyxJQUFLLENBQUMsQ0FBQyxNQUFELElBQVcsS0FBSyxHQUFMLENBQVMsV0FBVCxJQUF3QixDQUFwQyxNQUEyQyxDQUFDLE1BQUQsSUFBVyxLQUFLLEdBQUwsQ0FBUyxXQUFULElBQXdCLENBQTlFLENBQUQsSUFBc0YsS0FBSyxXQUEvRixFQUE0Rzs7QUFFaEgsU0FBSSxDQUFDLEtBQUssY0FBVixFQUNDOztBQUVELFNBQUksaUJBQWlCO0FBQ3BCLFVBQUksU0FBUyxLQUFLLGNBQUwsQ0FBb0IsQ0FBN0IsR0FBaUMsS0FBSyxRQUFMLENBQWMsRUFEL0I7QUFFcEIsVUFBSSxTQUFTLEtBQUssY0FBTCxDQUFvQixDQUE3QixHQUFpQyxLQUFLLFFBQUwsQ0FBYyxFQUYvQjtBQUdwQixVQUFJLFNBQVMsQ0FBVCxHQUFhLEtBQUssUUFBTCxDQUFjLEVBSFg7QUFJcEIsVUFBSSxTQUFTLENBQVQsR0FBYSxLQUFLLFFBQUwsQ0FBYztBQUpYLE1BQXJCOztBQU9BLFNBQUksS0FBSyxHQUFMLENBQVMsZUFBZSxFQUFmLEdBQW9CLGVBQWUsRUFBNUMsSUFBa0QsQ0FBbEQsSUFBdUQsS0FBSyxHQUFMLENBQVMsZUFBZSxFQUFmLEdBQW9CLGVBQWUsRUFBNUMsSUFBa0QsQ0FBN0csRUFBZ0g7O0FBRS9HLFVBQUksS0FBSyx3QkFBTCxDQUE4QixlQUFlLEVBQTdDLEVBQWlELGVBQWUsRUFBaEUsRUFBb0UsZUFBZSxFQUFuRixFQUF1RixlQUFlLEVBQXRHLENBQUosRUFBK0c7O0FBRTlHLGtCQUFXLElBQVg7QUFFRTtBQUNEO0FBQ0Q7O0FBRUgsUUFBSSxRQUFKLEVBQWM7QUFDYixVQUFLLGdCQUFMLEdBQXdCLElBQXhCLENBRGEsQ0FDZ0I7O0FBRTdCLFVBQUssbUJBQUwsQ0FBeUIsZUFBekIsRUFBMEMsTUFBMUM7QUFDRyxVQUFLLE1BQUw7QUFDSCxVQUFLLG1CQUFMLENBQXlCLGNBQXpCLEVBQXlDLE1BQXpDOztBQUVBLFNBQUksWUFBWSxLQUFLLFdBQWpCLElBQWdDLEtBQUssV0FBTCxDQUFpQixLQUFqQixDQUF1QixPQUF2QixLQUFtQyxNQUF2RSxFQUErRTtBQUMvRSx1QkFBSyxLQUFLLFdBQVYsRUFBdUIsS0FBSyxZQUE1QjtBQUNBLHFCQUFlLElBQWYsRUFBcUIsS0FBSyxXQUExQixFQUF1QyxLQUF2QztBQUNBLHFCQUFlLElBQWYsRUFBcUIsS0FBSyxZQUExQixFQUF3QyxPQUF4QztBQUNBO0FBQ0Q7QUFDRDtBQUNBO0FBRUQ7O0FBRUQsTUFBSyxNQUFMLEdBQWMsS0FBZDtBQUNBLENBdkZEOztBQXlGQSxNQUFNLFNBQU4sQ0FBZ0Isa0JBQWhCLEdBQXFDLFVBQVUsQ0FBVixFQUFhLENBQWIsRUFBZ0I7QUFDcEQsS0FBSSxLQUFLLE1BQUwsSUFBZSxLQUFLLFFBQUwsQ0FBYyxhQUFkLEtBQWdDLE1BQW5ELEVBQTJEOztBQUUxRCxNQUFJLGNBQWMsQ0FBbEI7QUFBQSxNQUNDLGNBQWMsQ0FEZjtBQUFBLE1BRUMsUUFBUSxJQUZUO0FBQUEsTUFHQyxpQkFBaUIsSUFIbEI7QUFBQSxNQUlDLFNBQVMsS0FBSyxRQUFMLENBQWMsT0FBZCxDQUFzQixHQUF0QixLQUE4QixDQUp4QztBQUFBLE1BSTJDO0FBQzFDLFdBQVMsS0FBSyxRQUFMLENBQWMsT0FBZCxDQUFzQixHQUF0QixLQUE4QixDQUx4QztBQUFBLE1BSzJDO0FBQzFDLFVBQVEsSUFOVDs7QUFRQSxNQUFJLEtBQUssUUFBTCxDQUFjLGFBQWQsS0FBZ0MsV0FBcEMsRUFBaUQ7QUFDaEQsT0FBSSxPQUFPLE1BQVg7QUFDQSxZQUFTLE1BQVQ7QUFDQSxZQUFTLElBQVQ7QUFDQTs7QUFFRCxnQkFBYyxLQUFLLGNBQUwsQ0FBb0IsQ0FBcEIsR0FBd0IsQ0FBdEM7QUFDQSxnQkFBYyxLQUFLLGNBQUwsQ0FBb0IsQ0FBcEIsR0FBd0IsQ0FBdEM7O0FBRUEsTUFBSSxLQUFLLEdBQUwsQ0FBUyxXQUFULElBQXdCLENBQXhCLElBQTZCLEtBQUssR0FBTCxDQUFTLFdBQVQsSUFBd0IsQ0FBckQsS0FBMkQsS0FBSyxVQUFMLElBQW1CLEtBQUssV0FBbkYsQ0FBSixFQUFxRztBQUNwRyxRQUFLLFFBQUwsQ0FBYyxJQUFkO0FBQ0EsR0FGRCxNQUVPLElBQUksQ0FBQyxLQUFLLFVBQU4sSUFBb0IsQ0FBQyxLQUFLLFdBQTlCLEVBQTJDO0FBQ2pELFFBQUssUUFBTCxDQUFjLGdCQUFkLENBQStCLENBQS9CLEVBQWtDLENBQWxDO0FBQ0E7O0FBRUQsTUFBSSxDQUFFLENBQUMsTUFBRCxJQUFXLEtBQUssR0FBTCxDQUFTLFdBQVQsSUFBd0IsQ0FBcEMsSUFBMkMsQ0FBQyxNQUFELElBQVcsS0FBSyxHQUFMLENBQVMsV0FBVCxJQUF3QixDQUEvRSxNQUF1RixLQUFLLFVBQUwsSUFBbUIsS0FBSyxXQUEvRyxDQUFKLEVBQWlJO0FBQ2hJLE9BQUksS0FBSyxVQUFULEVBQXFCOztBQUVwQixxQkFDQztBQUNDLFNBQUksU0FBUyxLQUFLLFFBQUwsQ0FBYyxFQUFkLEdBQW1CLFdBQTVCLEdBQTBDLEtBQUssUUFBTCxDQUFjLEVBRDdEO0FBRUMsU0FBSSxTQUFTLEtBQUssUUFBTCxDQUFjLEVBQWQsR0FBbUIsV0FBNUIsR0FBMEMsS0FBSyxRQUFMLENBQWMsRUFGN0Q7QUFHQyxTQUFJLFNBQVMsS0FBSyxRQUFMLENBQWMsRUFBZCxHQUFtQixXQUE1QixHQUEwQyxLQUFLLFFBQUwsQ0FBYyxFQUg3RDtBQUlDLFNBQUksU0FBUyxLQUFLLFFBQUwsQ0FBYyxFQUFkLEdBQW1CLFdBQTVCLEdBQTBDLEtBQUssUUFBTCxDQUFjO0FBSjdELEtBREQ7O0FBUUEsUUFBSSxLQUFLLHdCQUFMLENBQThCLGVBQWUsRUFBN0MsRUFBaUQsZUFBZSxFQUFoRSxFQUFvRSxlQUFlLEVBQW5GLEVBQXVGLGVBQWUsRUFBdEcsRUFBMEcsSUFBMUcsQ0FBSixFQUFxSDtBQUNwSCxVQUFLLG1CQUFMLENBQXlCLGVBQXpCLEVBQTBDLEtBQTFDO0FBQ0EsVUFBSyxNQUFMO0FBQ0EsVUFBSyxtQkFBTCxDQUF5QixjQUF6QixFQUF5QyxLQUF6Qzs7QUFFQSxVQUFLLGNBQUwsQ0FBb0IsQ0FBcEIsR0FBd0IsQ0FBeEI7QUFDQSxVQUFLLGNBQUwsQ0FBb0IsQ0FBcEIsR0FBd0IsQ0FBeEI7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFFRCxJQTFCRCxNQTBCTyxJQUFJLEtBQUssV0FBVCxFQUFzQjs7QUFFNUIsU0FBSyxvQkFBTDs7QUFFQSxZQUFRLEtBQUssaUJBQUwsQ0FBdUIsV0FBL0I7O0FBRUEsU0FBSyxpQkFBTCxDQUF1QixXQUF2QixHQUFxQyxFQUFyQztBQUNBLFNBQUssaUJBQUwsQ0FBdUIsU0FBdkIsR0FBbUMsU0FBbkM7O0FBRUEsUUFBSSxPQUFPO0FBQ1YsU0FBSSxTQUFTLEtBQUssY0FBTCxDQUFvQixDQUE3QixHQUFpQyxLQUFLLFFBQUwsQ0FBYyxFQUR6QztBQUVWLFNBQUksU0FBUyxLQUFLLGNBQUwsQ0FBb0IsQ0FBN0IsR0FBaUMsS0FBSyxRQUFMLENBQWMsRUFGekM7QUFHVixTQUFJLFNBQVMsSUFBSSxLQUFLLGNBQUwsQ0FBb0IsQ0FBakMsR0FBcUMsS0FBSyxRQUFMLENBQWMsRUFBZCxHQUFtQixLQUFLLFFBQUwsQ0FBYyxFQUhoRTtBQUlWLFNBQUksU0FBUyxJQUFJLEtBQUssY0FBTCxDQUFvQixDQUFqQyxHQUFxQyxLQUFLLFFBQUwsQ0FBYyxFQUFkLEdBQW1CLEtBQUssUUFBTCxDQUFjO0FBSmhFLEtBQVg7O0FBT0EsU0FBSyxpQkFBTCxDQUF1QixRQUF2QixDQUFnQyxLQUFLLEVBQXJDLEVBQXlDLEtBQUssRUFBOUMsRUFBa0QsS0FBSyxFQUF2RCxFQUEyRCxLQUFLLEVBQWhFOztBQUVBLFNBQUssaUJBQUwsQ0FBdUIsV0FBdkIsR0FBcUMsS0FBckM7QUFDQTtBQUNEO0FBRUQsRUExRUQsTUEyRUMsS0FBSyxRQUFMLENBQWMsZ0JBQWQsQ0FBK0IsQ0FBL0IsRUFBa0MsQ0FBbEM7QUFDRCxDQTdFRDs7QUErRUE7O0FBRUE7QUFDQSxNQUFNLFNBQU4sQ0FBZ0Isd0JBQWhCLEdBQTJDLFVBQVUsR0FBVixFQUFlLEdBQWYsRUFBb0IsR0FBcEIsRUFBeUIsR0FBekIsRUFBOEIsbUJBQTlCLEVBQW1EOztBQUU3Rix1QkFBc0IsdUJBQXVCLEtBQTdDOztBQUVBLEtBQUksU0FBUyxLQUFLLFFBQUwsQ0FBYyxPQUFkLENBQXNCLEdBQXRCLEtBQThCLENBQTNDO0FBQUEsS0FBOEM7QUFDN0MsVUFBUyxLQUFLLFFBQUwsQ0FBYyxPQUFkLENBQXNCLEdBQXRCLEtBQThCLENBRHhDO0FBQUEsS0FDMkM7QUFDMUMsZUFBYyxLQUZmOztBQUlBLEtBQUksT0FBTyxFQUFYO0FBQUEsS0FBZSxxQkFBcUIsRUFBcEM7QUFDQSxLQUFJLEtBQUssS0FBTCxJQUFjLE1BQWxCLEVBQ0MsS0FBSyxJQUFMLENBQVUsS0FBSyxLQUFmO0FBQ0QsS0FBSSxLQUFLLEtBQUwsSUFBYyxNQUFsQixFQUNDLEtBQUssSUFBTCxDQUFVLEtBQUssS0FBZjtBQUNELEtBQUksS0FBSyxNQUFMLElBQWUsTUFBbkIsRUFDQyxLQUFLLElBQUwsQ0FBVSxLQUFLLE1BQWY7O0FBRUQsS0FBSSxTQUFTLEVBQWI7O0FBRUEsTUFBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEtBQUssTUFBekIsRUFBaUMsR0FBakMsRUFBc0M7QUFDckMsTUFBSSxPQUFPLEtBQUssQ0FBTCxDQUFYO0FBQ0E7O0FBRUEsTUFBSSxPQUFPLEtBQUssbUJBQUwsQ0FBeUIsRUFBRSxHQUFHLEdBQUwsRUFBVSxHQUFHLEdBQWIsRUFBekIsQ0FBWDtBQUNBLE1BQUksT0FBTyxLQUFLLG1CQUFMLENBQXlCLEVBQUUsR0FBRyxHQUFMLEVBQVUsR0FBRyxHQUFiLEVBQXpCLENBQVg7O0FBRUEsTUFBSSxPQUFPLElBQVgsRUFBaUI7QUFDaEIsT0FBSSxPQUFPLElBQVg7QUFDQSxVQUFPLElBQVA7QUFDQSxVQUFPLElBQVA7QUFDQTs7QUFFRCxNQUFJLFNBQVMsS0FBSyxRQUFMLENBQWMsT0FBdkIsQ0FBSixFQUFxQztBQUNwQyxPQUFJLEVBQUUsS0FBSyxHQUFMLENBQVMsT0FBTyxJQUFoQixJQUF3QixJQUFJLEtBQUssR0FBTCxDQUFTLEtBQUssUUFBTCxDQUFjLE9BQXZCLENBQTVCLElBQ0YsT0FBTyxLQUFLLE9BRFYsSUFDdUIsT0FBTyxLQUFLLE9BRHJDLENBQUosRUFDb0Q7QUFDbkQsdUJBQW1CLElBQW5CLENBQXdCLElBQXhCO0FBQ0EsV0FBTyxJQUFQLENBQVksRUFBRSxNQUFNLElBQVIsRUFBYyxNQUFNLElBQXBCLEVBQVo7O0FBRUEsa0JBQWMsSUFBZDtBQUNBLElBTkQsTUFNTyxJQUFJLENBQUMsbUJBQUwsRUFBMEI7QUFDaEMsa0JBQWMsS0FBZDtBQUNBO0FBQ0E7QUFDRDtBQUNEOztBQUVELEtBQUksV0FBSixFQUFpQjtBQUNoQixPQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksbUJBQW1CLE1BQXZDLEVBQStDLEdBQS9DLEVBQW9EO0FBQ25ELE9BQUksT0FBTyxtQkFBbUIsQ0FBbkIsQ0FBWDtBQUNBLE9BQUksUUFBUSxPQUFPLENBQVAsQ0FBWjs7QUFFQSxRQUFLLGdCQUFMLENBQXNCLE1BQU0sSUFBNUIsRUFBa0MsTUFBTSxJQUF4QztBQUNBO0FBQ0Q7O0FBRUQsUUFBTyxXQUFQO0FBQ0EsQ0F2REQ7O0FBeURBLE1BQU0sU0FBTixDQUFnQixlQUFoQixHQUFrQyxZQUFZOztBQUU3QyxLQUFJLFdBQVcsS0FBSyxRQUFwQjs7QUFFQSxLQUFJLFFBQVEsS0FBSyxLQUFMLEdBQWEsS0FBSyxLQUFsQixHQUEwQixLQUFLLE1BQTNDOztBQUVBLEtBQUksQ0FBQyx3QkFBRCxLQUF1QixTQUFTLEVBQVQsR0FBYyxDQUFkLElBQW1CLFNBQVMsRUFBVCxHQUFjLENBQXhELENBQUosRUFBZ0U7QUFDL0QsV0FBUyxHQUFULENBQWEsU0FBYixDQUF1QixTQUFTLEVBQWhDLEVBQW9DLFNBQVMsRUFBN0M7QUFDQTs7QUFFRCxLQUFJLEtBQUssS0FBTCxJQUFjLEtBQWxCLEVBQXlCO0FBQ3hCLFdBQVMsRUFBVCxHQUFjLEtBQUssS0FBTCxDQUFXLGVBQVgsQ0FBMkIsRUFBM0IsR0FBZ0MsS0FBSyxLQUFMLENBQVcsZUFBWCxDQUEyQixFQUEzRCxHQUFnRSxLQUFLLEtBQUwsQ0FBVyxlQUFYLENBQTJCLEVBQTNGLEdBQWdHLE1BQU0sZUFBTixDQUFzQixFQUFwSTtBQUNBLFdBQVMsRUFBVCxHQUFlLEtBQUssS0FBTCxDQUFXLGVBQVgsQ0FBMkIsRUFBM0IsR0FBZ0MsTUFBTSxlQUFOLENBQXNCLEVBQXRELEdBQTJELEtBQUssS0FBTCxDQUFXLGVBQVgsQ0FBMkIsRUFBdEYsR0FBMkYsTUFBTSxlQUFOLENBQXNCLEVBQWhJOztBQUVBLFdBQVMsRUFBVCxHQUFlLEtBQUssS0FBTCxDQUFXLGVBQVgsQ0FBMkIsRUFBM0IsR0FBZ0MsTUFBTSxlQUFOLENBQXNCLEVBQXRELEdBQTJELEtBQUssS0FBTCxDQUFXLGVBQVgsQ0FBMkIsRUFBdEYsR0FBMkYsTUFBTSxlQUFOLENBQXNCLEVBQWhJO0FBQ0EsV0FBUyxFQUFULEdBQWMsS0FBSyxLQUFMLENBQVcsZUFBWCxDQUEyQixFQUEzQixHQUFnQyxLQUFLLEtBQUwsQ0FBVyxlQUFYLENBQTJCLEVBQTNELEdBQWdFLEtBQUssS0FBTCxDQUFXLGVBQVgsQ0FBMkIsRUFBM0YsR0FBZ0csTUFBTSxlQUFOLENBQXNCLEVBQXBJOztBQUVBLFdBQVMsS0FBVCxHQUFpQixTQUFTLEVBQVQsR0FBYyxTQUFTLEVBQXhDO0FBQ0EsV0FBUyxNQUFULEdBQWtCLFNBQVMsRUFBVCxHQUFjLFNBQVMsRUFBekM7QUFDQTtBQUNBLEVBVkQsTUFVTztBQUNOO0FBQ0EsTUFBSSxZQUFZLEtBQUssYUFBTCxDQUFtQixZQUFuQixFQUFoQjtBQUNBLFdBQVMsRUFBVCxHQUFjLFVBQVUsRUFBeEI7QUFDQSxXQUFTLEVBQVQsR0FBYyxVQUFVLEVBQXhCO0FBQ0EsV0FBUyxFQUFULEdBQWMsVUFBVSxFQUF4QjtBQUNBLFdBQVMsRUFBVCxHQUFjLFVBQVUsRUFBeEI7O0FBRUEsV0FBUyxLQUFULEdBQWlCLFVBQVUsS0FBM0I7QUFDQSxXQUFTLE1BQVQsR0FBa0IsVUFBVSxNQUE1QjtBQUNBOztBQUVELEtBQUksQ0FBQyx3QkFBTCxFQUF3Qjs7QUFFdkIsV0FBUyxNQUFULENBQWdCLEtBQWhCLEdBQXdCLFNBQVMsS0FBakM7QUFDQSxXQUFTLE1BQVQsQ0FBZ0IsTUFBaEIsR0FBeUIsU0FBUyxNQUFsQzs7QUFFQSxXQUFTLE1BQVQsQ0FBZ0IsS0FBaEIsQ0FBc0IsSUFBdEIsR0FBNkIsU0FBUyxFQUFULEdBQWMsSUFBM0M7QUFDQSxXQUFTLE1BQVQsQ0FBZ0IsS0FBaEIsQ0FBc0IsR0FBdEIsR0FBNEIsU0FBUyxFQUFULEdBQWMsSUFBMUM7O0FBRUEsTUFBSSxTQUFTLEVBQVQsR0FBYyxDQUFkLElBQW1CLFNBQVMsRUFBVCxHQUFjLENBQXJDLEVBQXdDO0FBQ3ZDLFlBQVMsR0FBVCxDQUFhLFNBQWIsQ0FBdUIsQ0FBQyxTQUFTLEVBQWpDLEVBQXFDLENBQUMsU0FBUyxFQUEvQztBQUNBO0FBQ0Q7O0FBRUQsVUFBUyxhQUFULEdBQXlCLElBQUksd0JBQUosQ0FBa0IsU0FBUyxFQUEzQixFQUErQixTQUFTLEVBQXhDLEVBQTRDLFNBQVMsRUFBckQsRUFBeUQsU0FBUyxFQUFsRSxFQUFzRSxDQUF0RSxDQUF6QjtBQUNBLENBOUNEOztBQWdEQSxNQUFNLFNBQU4sQ0FBZ0IsNkJBQWhCLEdBQWdELFVBQVUsQ0FBVixFQUFhLENBQWIsRUFBZ0I7QUFDL0QsUUFBTztBQUNOLEtBQUcsS0FBSyxLQUFMLENBQVcseUJBQVgsQ0FBcUMsQ0FBckMsRUFBd0MsQ0FEckMsRUFDd0MsR0FBRyxLQUFLLEtBQUwsQ0FBVyx5QkFBWCxDQUFxQyxDQUFyQyxFQUF3QztBQUUxRjtBQUhPLEVBQVA7QUFJQSxDQUxEOztBQU9BOztBQUVBLE1BQU0sU0FBTixDQUFnQixpQkFBaEIsR0FBb0MsVUFBVSxTQUFWLEVBQXFCO0FBQ3hELEtBQUksTUFBTSxhQUFhLEtBQUssUUFBTCxDQUFjLEdBQXJDOztBQUVBLEtBQUksV0FBVyxLQUFLLFFBQXBCOztBQUVBLEtBQUksTUFBTSxDQUFWO0FBQ0EsS0FBSSxZQUFZLENBQWhCO0FBQ0EsS0FBSSxZQUFZLENBQWhCO0FBQ0EsS0FBSSxZQUFZLENBQWhCO0FBQ0EsS0FBSSxZQUFZLENBQWhCO0FBQ0EsS0FBSSxVQUFVLENBQWQ7QUFBQSxLQUFpQixVQUFVLENBQTNCLENBVndELENBVTFCO0FBQzlCLEtBQUksVUFBVSxDQUFkO0FBQUEsS0FBaUIsVUFBVSxDQUEzQixDQVh3RCxDQVcxQjtBQUM5QixLQUFJLGVBQWUsQ0FBbkI7QUFDQSxLQUFJLGdCQUFnQixDQUFwQjs7QUFFQSxNQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksS0FBSyxZQUFMLENBQWtCLE1BQXRDLEVBQThDLEdBQTlDLEVBQW1EOztBQUVsRCxNQUFJLGFBQWEsS0FBSyxZQUFMLENBQWtCLENBQWxCLENBQWpCO0FBQ0EsTUFBSSxpQkFBaUIsV0FBVyxTQUFYLENBQXFCLFdBQXJCLEVBQXJCOztBQUVBLE1BQUksQ0FBSixFQUFPLENBQVAsRUFBVSxLQUFWOztBQUVBLE1BQUksWUFBWSx3QkFBWSxxQkFBWixFQUFtQyxXQUFXLFNBQTlDLEVBQXlELFdBQVcsVUFBcEUsQ0FBaEI7QUFDQSxNQUFJLFdBQVcsd0JBQVksb0JBQVosRUFBa0MsV0FBVyxTQUE3QyxFQUF3RCxXQUFXLFVBQW5FLENBQWY7QUFDQSxNQUFJLGFBQWEsd0JBQVksc0JBQVosRUFBb0MsV0FBVyxTQUEvQyxFQUEwRCxXQUFXLFVBQXJFLENBQWpCO0FBQ0EsTUFBSSxZQUFZLHdCQUFZLHFCQUFaLEVBQW1DLFdBQVcsU0FBOUMsRUFBeUQsV0FBVyxVQUFwRSxDQUFoQjtBQUNBLE1BQUksYUFBYSx3QkFBWSxzQkFBWixFQUFvQyxXQUFXLFNBQS9DLEVBQTBELFdBQVcsVUFBckUsQ0FBakI7QUFDQSxNQUFJLGtCQUFrQix3QkFBWSwyQkFBWixFQUF5QyxXQUFXLFNBQXBELEVBQStELFdBQVcsVUFBMUUsQ0FBdEI7QUFDQSxNQUFJLFdBQVcsd0JBQVksb0JBQVosRUFBa0MsV0FBVyxTQUE3QyxFQUF3RCxXQUFXLFVBQW5FLENBQWY7QUFDQSxNQUFJLGlCQUFpQix3QkFBWSxnQkFBWixFQUE4QixXQUFXLFNBQXpDLEVBQW9ELFdBQVcsVUFBL0QsQ0FBckI7O0FBRUEsTUFBSSxrQkFBa0I7QUFDckIsWUFBUyxJQURZLEVBQ04sT0FBTztBQURELEdBQXRCO0FBR0EsTUFBSSxxQkFBcUIsSUFBekI7O0FBRUEsTUFBSSxXQUFXLFVBQVgsQ0FBc0IsSUFBdEIsQ0FBMkIsT0FBM0IsQ0FBbUMsU0FBbkMsS0FBaUQsQ0FBakQsSUFBc0QsV0FBVyxVQUFYLENBQXNCLElBQXRCLEtBQStCLEtBQXJGLElBQThGLFdBQVcsVUFBWCxDQUFzQixJQUF0QixLQUErQixVQUFqSSxFQUNDLGtCQUFrQixLQUFLLGtCQUFMLENBQXdCLFdBQVcsVUFBbkMsRUFBK0MsV0FBVyxTQUExRCxDQUFsQjs7QUFFRCxNQUFJLFdBQVcsVUFBWCxDQUFzQixtQkFBdEIsSUFBNkMsV0FBVyxTQUFYLENBQXFCLG1CQUF0RSxFQUNDLHFCQUFxQjtBQUNwQixVQUFPLEtBQUssUUFEUSxFQUNFLFlBQVksV0FBVyxVQUR6QixFQUNxQyxXQUFXLFdBQVcsU0FEM0QsRUFDc0UsT0FBTyxXQUFXLFlBRHhGLEVBQ3NHLE9BQU8sZ0JBQWdCLEtBRDdILEVBQ29JLFNBQVMsZ0JBQWdCO0FBRDdKLEdBQXJCOztBQUtELE1BQUksaUJBQWlCLFdBQVcsU0FBWCxDQUFxQixtQkFBckIsR0FBMkMsV0FBVyxTQUFYLENBQXFCLG1CQUFyQixDQUF5QyxrQkFBekMsQ0FBM0MsR0FDbEIsV0FBVyxTQUFYLENBQXFCLFVBQXJCLEdBQWtDLEtBQUssd0JBQUwsQ0FBOEIsV0FBVyxTQUFYLENBQXFCLFVBQW5ELEVBQStELFdBQVcsU0FBMUUsRUFBcUYsV0FBVyxVQUFoRyxFQUE0RyxJQUE1RyxFQUFrSCxXQUFXLFlBQTdILENBQWxDLEdBQ0EsV0FBVyxVQUFYLENBQXNCLG1CQUF0QixHQUE0QyxXQUFXLFVBQVgsQ0FBc0IsbUJBQXRCLENBQTBDLGtCQUExQyxDQUE1QyxHQUNBLFdBQVcsVUFBWCxDQUFzQixVQUF0QixHQUFtQyxLQUFLLHdCQUFMLENBQThCLFdBQVcsVUFBWCxDQUFzQixVQUFwRCxFQUFnRSxXQUFXLFNBQTNFLEVBQXNGLFdBQVcsVUFBakcsRUFBNkcsSUFBN0csRUFBbUgsV0FBVyxZQUE5SCxDQUFuQyxHQUFpTCxJQUhwTDs7QUFLQSxNQUFJLG1CQUFtQixJQUFuQixJQUEyQixtQkFBbUIsRUFBbEQsRUFDQzs7QUFFRCxNQUFJLFlBQVksd0JBQVkscUJBQVosRUFBbUMsV0FBVyxTQUE5QyxFQUF5RCxXQUFXLFVBQXBFLENBQWhCO0FBQ0EsTUFBSSxjQUFjLHdCQUFZLHVCQUFaLEVBQXFDLFdBQVcsU0FBaEQsRUFBMkQsV0FBVyxVQUF0RSxDQUFsQjtBQUNBLE1BQUksUUFBUSxDQUFaOztBQUVBLE1BQUksWUFBWSxXQUFXLFNBQTNCLENBMUNrRCxDQTBDWjs7QUFFdEMsTUFBSSxRQUFRLFdBQVcsVUFBWCxDQUFzQixLQUFsQztBQUNBLE1BQUksUUFBUSxXQUFXLFVBQVgsQ0FBc0IsS0FBbEM7O0FBR0EsTUFBSSxZQUFZLElBQUksb0JBQUosQ0FBYyxHQUFkLEVBQW1CO0FBQ2xDLE1BQUcsQ0FEK0I7QUFFbEMsTUFBRyxDQUYrQjtBQUdsQyxhQUFVLFdBQVcsUUFBWCxHQUFzQixLQUFLLEtBQUwsR0FBYSxFQUhYO0FBSWxDLGNBQVcsaUJBQWlCLFdBQVcsQ0FBNUIsR0FBZ0MsV0FBVyxHQUpwQjtBQUtsQyxVQUFPLGdCQUFnQixZQUFoQixHQUErQixDQUEvQixHQUFtQyxDQUFDLEVBTFQ7QUFNbEMsU0FBTSxjQU40QjtBQU9sQyxZQUFTLENBUHlCO0FBUWxDLG9CQUFpQixlQVJpQjtBQVNsQyxvQkFBaUIsTUFUaUIsRUFTVjtBQUN4QixhQUFVLFFBVndCLEVBVWY7QUFDbkIsZUFBWSxVQVhzQjtBQVlsQyxlQUFZLFVBWnNCLEVBWVY7QUFDeEIsY0FBVyxTQWJ1QjtBQWNsQyxjQUFXLFNBZHVCLEVBY1o7QUFDdEIsaUJBQWM7QUFmb0IsR0FBbkIsQ0FBaEI7O0FBa0JBLE1BQUksV0FBVyxVQUFVLFdBQVYsRUFBZjs7QUFFQTtBQUNBOztBQUVBLE1BQUksZUFBZSxPQUFmLENBQXVCLE1BQXZCLEtBQWtDLENBQWxDLElBQXVDLGVBQWUsT0FBZixDQUF1QixNQUF2QixLQUFrQyxDQUF6RSxJQUNDLGVBQWUsT0FBZixDQUF1QixRQUF2QixLQUFvQyxDQURyQyxJQUMwQyxlQUFlLE9BQWYsQ0FBdUIsU0FBdkIsS0FBcUMsQ0FEbkYsRUFDc0Y7O0FBRXJGLE9BQUksV0FBVyxTQUFYLENBQXFCLENBQXJCLEdBQXlCLE1BQU0sZUFBL0IsSUFBa0QsV0FBVyxTQUFYLENBQXFCLENBQXJCLEdBQXlCLE1BQU0sZUFBakYsSUFBb0csV0FBVyxTQUFYLENBQXFCLENBQXJCLEdBQXlCLE1BQU0sZUFBbkksSUFBc0osV0FBVyxTQUFYLENBQXFCLENBQXJCLEdBQXlCLE1BQU0sZUFBekwsRUFDQztBQUNELEdBTEQsTUFNSztBQUNKLE9BQUksV0FBVyxTQUFYLENBQXFCLENBQXJCLEdBQXlCLE1BQU0sZUFBL0IsSUFBa0QsV0FBVyxTQUFYLENBQXFCLENBQXJCLEdBQXlCLE1BQU0sZUFBckYsRUFDQztBQUNEOztBQUVELFlBQVUsQ0FBVjtBQUNBLFlBQVUsQ0FBVjs7QUFFQSxNQUFJLGdCQUFnQixZQUFwQixFQUFrQztBQUNqQyxrQkFBZSxVQUFVLEtBQXpCO0FBQ0EsbUJBQWdCLFVBQVUsTUFBMUI7QUFDQSxHQUhELE1BR087QUFDTixtQkFBZ0IsVUFBVSxLQUExQjtBQUNBLGtCQUFlLFVBQVUsTUFBekI7QUFDQTs7QUFFRCxNQUFJLEtBQUssUUFBTCxDQUFjLGFBQWQsS0FBZ0MsUUFBcEMsRUFBOEM7O0FBRTdDLE9BQUksZUFBZSxPQUFmLENBQXVCLE1BQXZCLEtBQWtDLENBQWxDLElBQXVDLGVBQWUsT0FBZixDQUF1QixNQUF2QixLQUFrQyxDQUE3RSxFQUFnRjs7QUFFL0UsZ0JBQVksTUFBWjtBQUNBLGNBQVUsQ0FBVjtBQUVBLElBTEQsTUFLTyxJQUFJLGVBQWUsT0FBZixDQUF1QixTQUF2QixLQUFxQyxDQUF6QyxFQUE0Qzs7QUFFbEQsUUFBSSxjQUFjLE1BQWxCLEVBQ0MsWUFBWSxRQUFaO0FBRUQsSUFMTSxNQUtBLElBQUksbUJBQW1CLFFBQW5CLElBQStCLG1CQUFtQixTQUF0RCxFQUFpRTs7QUFFdkUsZ0JBQVksUUFBWjtBQUVBOztBQUVELE9BQUksV0FBVyxLQUFYLENBQWlCLENBQWpCLEdBQXFCLGVBQWUsQ0FBeEM7O0FBRUEsT0FBSSxjQUFjLFFBQWxCLEVBQTRCO0FBQUU7O0FBRTdCLGdCQUFZLFNBQVMsRUFBckI7QUFDQSxnQkFBWSxTQUFTLEVBQXJCOztBQUVBLFFBQUksWUFBWSxDQUFoQixFQUFtQjtBQUNsQixTQUFJLFdBQVcsS0FBWCxDQUFpQixDQUFqQixHQUFxQixhQUFyQixHQUFxQyxPQUF6Qzs7QUFFQSxTQUFJLElBQUksU0FBUixFQUFtQjtBQUNsQixVQUFJLGNBQWMsTUFBbEIsRUFBMEI7QUFDekIsV0FBSSxLQUFLLEdBQUwsQ0FBUyxXQUFXLEtBQVgsQ0FBaUIsQ0FBMUIsRUFBNkIsU0FBN0IsSUFBMEMsT0FBOUM7QUFDQSxPQUZELE1BR0s7QUFDSixXQUFJLFlBQVksT0FBaEI7QUFDQTtBQUNEO0FBQ0QsS0FYRCxNQVlLO0FBQ0osU0FBSSxXQUFXLEtBQVgsQ0FBaUIsQ0FBakIsR0FBcUIsT0FBekI7O0FBRUEsU0FBSSxJQUFJLFlBQVksYUFBWixHQUE0QixPQUFwQyxFQUE2QztBQUM1QyxVQUFJLGNBQWMsTUFBbEIsRUFBMEI7QUFDekIsV0FBSSxLQUFLLEdBQUwsQ0FBUyxXQUFXLEtBQVgsQ0FBaUIsQ0FBMUIsRUFBNkIsU0FBN0IsSUFBMEMsYUFBMUMsR0FBMEQsT0FBOUQ7QUFDQSxPQUZELE1BR0s7QUFDSixXQUFJLFlBQVksYUFBWixHQUE0QixPQUFoQztBQUNBO0FBQ0Q7QUFDRDtBQUVELElBOUJELE1BOEJPOztBQUdOLGdCQUFZLEtBQUssR0FBTCxDQUFTLFdBQVcsTUFBWCxDQUFrQixFQUEzQixFQUErQixTQUFTLEVBQXhDLENBQVo7QUFDQSxnQkFBWSxLQUFLLEdBQUwsQ0FBUyxXQUFXLE1BQVgsQ0FBa0IsRUFBM0IsRUFBK0IsU0FBUyxFQUF4QyxDQUFaOztBQUdBLFFBQUksZUFBZSxPQUFmLENBQXVCLE9BQXZCLEtBQW1DLENBQXZDLEVBQTBDO0FBQ3pDLFNBQUksWUFBWSxDQUFoQixFQUNDLE1BQU0sS0FBSyxHQUFMLENBQVMsV0FBVyxNQUFYLENBQWtCLEVBQTNCLEVBQStCLFNBQVMsRUFBeEMsSUFBOEMsZ0JBQWdCLENBQTlELEdBQWtFLE9BQXhFLENBREQsS0FHQyxNQUFNLEtBQUssR0FBTCxDQUFTLFdBQVcsTUFBWCxDQUFrQixFQUEzQixFQUErQixTQUFTLEVBQXhDLElBQThDLGdCQUFnQixDQUE5RCxHQUFrRSxPQUF4RTtBQUNELEtBTEQsTUFPQyxNQUFNLENBQUMsS0FBSyxHQUFMLENBQVMsV0FBVyxNQUFYLENBQWtCLEVBQTNCLEVBQStCLFNBQVMsRUFBeEMsSUFBOEMsS0FBSyxHQUFMLENBQVMsV0FBVyxNQUFYLENBQWtCLEVBQTNCLEVBQStCLFNBQVMsRUFBeEMsQ0FBL0MsSUFBOEYsQ0FBcEc7O0FBRUQsUUFBSSxZQUFZLENBQWhCLEVBQW1CO0FBQ2xCLFNBQUksS0FBSyxHQUFMLENBQVMsV0FBVyxLQUFYLENBQWlCLENBQTFCLEVBQTZCLEdBQTdCLElBQW9DLGdCQUFnQixDQUF4RDs7QUFFQSxTQUFJLElBQUksU0FBSixLQUFrQixtQkFBbUIsUUFBbkIsSUFBK0IsbUJBQW1CLFNBQXBFLENBQUosRUFBb0Y7QUFDbkYsVUFBSSxLQUFLLEdBQUwsQ0FBUyxXQUFXLEtBQVgsQ0FBaUIsQ0FBakIsR0FBcUIsYUFBckIsR0FBcUMsT0FBOUMsRUFBdUQsU0FBUyxFQUFULEdBQWMsT0FBckUsQ0FBSjtBQUNBO0FBQ0QsS0FORCxNQU9LO0FBQ0osU0FBSSxLQUFLLEdBQUwsQ0FBUyxXQUFXLEtBQVgsQ0FBaUIsQ0FBMUIsRUFBNkIsR0FBN0IsSUFBb0MsZ0JBQWdCLENBQXhEOztBQUVBLFNBQUksSUFBSSxZQUFZLGFBQVosR0FBNEIsT0FBaEMsS0FBNEMsbUJBQW1CLFFBQW5CLElBQStCLG1CQUFtQixTQUE5RixDQUFKLEVBQThHO0FBQzdHLFVBQUksS0FBSyxHQUFMLENBQVMsV0FBVyxLQUFYLENBQWlCLENBQWpCLEdBQXFCLE9BQTlCLEVBQXVDLFNBQVMsRUFBVCxHQUFjLGFBQWQsR0FBOEIsT0FBckUsQ0FBSjtBQUNBO0FBQ0Q7O0FBRWE7QUFDZCxRQUFJLEtBQUssR0FBTCxDQUFTLENBQVQsRUFBWSxZQUFZLGFBQXhCLENBQUo7QUFDQTtBQUNELEdBcEZELE1BcUZLOztBQUVKLE9BQUksZUFBZSxPQUFmLENBQXVCLE1BQXZCLEtBQWtDLENBQWxDLElBQXVDLGVBQWUsT0FBZixDQUF1QixNQUF2QixLQUFrQyxDQUF6RSxJQUNBLGVBQWUsT0FBZixDQUF1QixTQUF2QixLQUFxQyxDQUR6QyxFQUM0Qzs7QUFFM0MsZ0JBQVksTUFBWjtBQUNBLGNBQVUsQ0FBVjtBQUVBLElBTkQsTUFNTyxJQUFJLGVBQWUsT0FBZixDQUF1QixTQUF2QixLQUFxQyxDQUF6QyxFQUE0Qzs7QUFFbEQsUUFBSSxjQUFjLE1BQWxCLEVBQ0MsWUFBWSxRQUFaO0FBRUQsSUFMTSxNQUtBLElBQUksbUJBQW1CLFFBQXZCLEVBQWlDOztBQUV2QyxnQkFBWSxRQUFaO0FBRUE7O0FBRUQsT0FBSSxXQUFXLEtBQVgsQ0FBaUIsQ0FBakIsR0FBcUIsZ0JBQWdCLENBQXpDOztBQUVBLE9BQUksY0FBYyxRQUFsQixFQUE0QjtBQUFFOztBQUU3QixnQkFBWSxTQUFTLEVBQXJCO0FBQ0EsZ0JBQVksU0FBUyxFQUFyQjs7QUFFQSxRQUFJLFlBQVksQ0FBaEIsRUFBbUI7QUFDbEIsU0FBSSxXQUFXLEtBQVgsQ0FBaUIsQ0FBakIsR0FBcUIsWUFBckIsR0FBb0MsT0FBeEM7O0FBRUEsU0FBSSxJQUFJLFNBQVIsRUFBbUI7QUFDbEIsVUFBSSxjQUFjLE1BQWxCLEVBQTBCO0FBQ3pCLFdBQUksS0FBSyxHQUFMLENBQVMsV0FBVyxLQUFYLENBQWlCLENBQTFCLEVBQTZCLFNBQTdCLElBQTBDLE9BQTlDO0FBQ0EsT0FGRCxNQUdLO0FBQ0osV0FBSSxZQUFZLE9BQWhCO0FBQ0E7QUFDRDtBQUNELEtBWEQsTUFZSztBQUNKLFNBQUksV0FBVyxLQUFYLENBQWlCLENBQWpCLEdBQXFCLE9BQXpCOztBQUVBLFNBQUksSUFBSSxZQUFZLFlBQVosR0FBMkIsT0FBbkMsRUFBNEM7QUFDM0MsVUFBSSxjQUFjLE1BQWxCLEVBQTBCO0FBQ3pCLFdBQUksS0FBSyxHQUFMLENBQVMsV0FBVyxLQUFYLENBQWlCLENBQTFCLEVBQTZCLFNBQTdCLElBQTBDLFlBQTFDLEdBQXlELE9BQTdEO0FBQ0EsT0FGRCxNQUdLO0FBQ0osV0FBSSxZQUFZLFlBQVosR0FBMkIsT0FBL0I7QUFDQTtBQUNEO0FBQ0Q7QUFFRCxJQTlCRCxNQThCTzs7QUFFTixnQkFBWSxLQUFLLEdBQUwsQ0FBUyxXQUFXLE1BQVgsQ0FBa0IsRUFBM0IsRUFBK0IsU0FBUyxFQUF4QyxDQUFaO0FBQ0EsZ0JBQVksS0FBSyxHQUFMLENBQVMsV0FBVyxNQUFYLENBQWtCLEVBQTNCLEVBQStCLFNBQVMsRUFBeEMsQ0FBWjs7QUFFQSxRQUFJLGVBQWUsT0FBZixDQUF1QixPQUF2QixLQUFtQyxDQUF2QyxFQUEwQztBQUN6QyxTQUFJLFlBQVksQ0FBaEIsRUFDQyxNQUFNLEtBQUssR0FBTCxDQUFTLFdBQVcsTUFBWCxDQUFrQixFQUEzQixFQUErQixTQUFTLEVBQXhDLElBQThDLGVBQWUsQ0FBN0QsR0FBaUUsT0FBdkUsQ0FERCxLQUdDLE1BQU0sS0FBSyxHQUFMLENBQVMsV0FBVyxNQUFYLENBQWtCLEVBQTNCLEVBQStCLFNBQVMsRUFBeEMsSUFBOEMsZUFBZSxDQUE3RCxHQUFpRSxPQUF2RTtBQUNELEtBTEQsTUFPQyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEdBQUwsQ0FBUyxXQUFXLE1BQVgsQ0FBa0IsRUFBM0IsRUFBK0IsU0FBUyxFQUF4QyxJQUE4QyxLQUFLLEdBQUwsQ0FBUyxXQUFXLE1BQVgsQ0FBa0IsRUFBM0IsRUFBK0IsU0FBUyxFQUF4QyxDQUEvQyxJQUE4RixDQUF4Rzs7QUFFRCxRQUFJLFlBQVksQ0FBaEIsRUFBbUI7QUFDbEIsU0FBSSxLQUFLLEdBQUwsQ0FBUyxXQUFXLEtBQVgsQ0FBaUIsQ0FBMUIsRUFBNkIsR0FBN0IsSUFBb0MsZUFBZSxDQUF2RDs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxLQU5ELE1BT0s7QUFDSixTQUFJLEtBQUssR0FBTCxDQUFTLFdBQVcsS0FBWCxDQUFpQixDQUExQixFQUE2QixHQUE3QixJQUFvQyxlQUFlLENBQXZEOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVFO0FBQ0EsUUFBSSxLQUFLLEdBQUwsQ0FBUyxDQUFULEVBQVksU0FBWixDQUFKO0FBQ0g7QUFDRDs7QUFHRCxNQUFJLGdCQUFnQixVQUFwQixFQUFnQztBQUMvQixRQUFLLGFBQUw7QUFDQTs7QUFFRCxZQUFVLENBQVYsR0FBYyxDQUFkO0FBQ0EsWUFBVSxDQUFWLEdBQWMsQ0FBZDs7QUFFQTs7QUFFQSxZQUFVLE1BQVYsQ0FBaUIsSUFBakI7QUFDQTs7QUFFRDtBQUNBLEtBQUksZ0JBQWdCO0FBQ25CLFVBQVEsR0FEVyxFQUNOLE1BQU0sS0FBSyxRQUFMLENBQWMsR0FEZCxFQUNtQixtQkFBbUIsbUJBQWdCLGVBRHRELEVBQ3VFLGdCQUFnQixtQkFBZ0IsTUFBaEIsQ0FBdUIsVUFEOUcsRUFDMEgsZUFBZSxDQUR6SSxFQUM0SSxrQkFBa0I7QUFEOUosRUFBcEI7QUFHQSxRQUFPLGFBQVA7QUFDQSxDQXhTRDs7QUEwU0EsTUFBTSxTQUFOLENBQWdCLFVBQWhCLEdBQTZCLFVBQVUsUUFBVixFQUFvQjs7QUFFaEQsS0FBSSxNQUFNLFNBQVMsZUFBVCxJQUE0QixLQUFLLFFBQUwsQ0FBYyxHQUFwRDs7QUFFQSxLQUFJLGtCQUFrQixTQUFTLGlCQUFULENBQTJCLE1BQWpEO0FBQ0EsS0FBSSxtQkFBbUIsQ0FBdkIsRUFDQzs7QUFFRCxLQUFJLFdBQVcsS0FBSyxhQUFMLENBQW1CLFFBQWxDO0FBQ0E7O0FBRUEsS0FBSSxJQUFKOztBQUVBLEtBQUksV0FBVyxLQUFLLFFBQXBCOztBQUVBLEtBQUksU0FBSjtBQUNBLEtBQUksSUFBSixDQUFTLFNBQVMsRUFBbEIsRUFBc0IsU0FBUyxFQUEvQixFQUFtQyxTQUFTLEtBQTVDLEVBQW1ELFNBQVMsTUFBNUQ7QUFDQSxLQUFJLElBQUo7O0FBRUEsS0FBSSxVQUFVLEVBQWQ7O0FBRUEsTUFBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFNBQVMsaUJBQVQsQ0FBMkIsTUFBL0MsRUFBdUQsR0FBdkQsRUFBNEQ7O0FBRTNELE1BQUksa0JBQWtCLFNBQVMsaUJBQVQsQ0FBMkIsQ0FBM0IsQ0FBdEI7O0FBRUEsTUFBSSxhQUFhLEtBQUssSUFBTCxDQUFVLGVBQVYsQ0FBakI7QUFDQSxNQUFJLFNBQUosR0FBZ0IsV0FBVyxhQUEzQjtBQUNBLE1BQUksYUFBYSxXQUFXLFVBQTVCOztBQUdBLE1BQUksSUFBSSxXQUFSLEVBQXFCO0FBQ3BCLE9BQUksV0FBSixDQUFnQiw2QkFBaUIsV0FBVyxZQUE1QixFQUEwQyxXQUFXLGFBQXJELENBQWhCO0FBQ0E7O0FBRUQsTUFBSSxXQUFXLFdBQVcsRUFBMUI7QUFDQSxPQUFLLGFBQUwsQ0FBbUIsU0FBbkIsQ0FBNkIsUUFBN0IsSUFBeUM7QUFDeEMsZUFBWSxZQUQ0QixFQUNkLGlCQUFpQjtBQURILEdBQXpDO0FBR0EsTUFBSSxXQUFXLGdDQUFvQixRQUFwQixDQUFmO0FBQ0EsV0FBUyxXQUFULEdBQXVCLFFBQXZCO0FBQ0E7QUFDQSxXQUFTLFNBQVQsR0FBcUIsV0FBVyxhQUFYLEdBQTJCLENBQTNCLEdBQStCLEtBQUssR0FBTCxDQUFTLFdBQVcsYUFBcEIsRUFBbUMsQ0FBbkMsQ0FBL0IsR0FBdUUsQ0FBNUY7O0FBRUEsTUFBSSxXQUFXLFdBQVcsU0FBMUI7QUFDQSxNQUFJLFFBQVEsU0FBUyxDQUFULENBQVo7QUFDQSxNQUFJLFdBQUosR0FBa0IsS0FBbEI7O0FBRUEsTUFBSSw2QkFBNkIsSUFBakM7QUFDQSxNQUFJLElBQUksQ0FBUjtBQUFBLE1BQVcsQ0FBWDtBQUFBLE1BQWMsQ0FBZDtBQUNBLE1BQUksVUFBSixDQTVCMkQsQ0E0QjNDOztBQUVoQjtBQUNBO0FBQ0EsTUFBSSxTQUFKO0FBQ0EsTUFBSSxXQUFXLE1BQVgsR0FBb0IsQ0FBeEIsRUFBMkI7QUFDMUI7O0FBRUE7QUFDQSxPQUFJLGVBQWUsS0FBbkI7QUFDQSxRQUFLLElBQUksQ0FBVCxFQUFZLElBQUksV0FBVyxNQUEzQixFQUFtQyxHQUFuQyxFQUF3Qzs7QUFFdkMsaUJBQWEsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixHQUEwQixXQUFXLENBQVgsRUFBYyxDQUFkLENBQWdCLE9BQWhCLEVBQTFCLEdBQXNELFdBQVcsQ0FBWCxFQUFjLENBQWpGOztBQUVBLFFBQUksYUFBYSxTQUFTLEtBQVQsQ0FBZSxRQUFmLENBQXdCLFdBQXJDLElBQW9ELGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUE3RixFQUNDOztBQUVEO0FBQ0E7O0FBRUEsUUFBSSxPQUFRLFdBQVcsQ0FBWCxFQUFjLENBQXRCLEtBQTZCLFFBQWpDLEVBQTJDO0FBQzFDLFNBQUksSUFBSSxDQUFSLEVBQVc7QUFBQztBQUNYLFVBQUksTUFBSjs7QUFFQSxVQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLGdCQUFTLE1BQVQ7QUFDQTtBQUNEOztBQUdELG9CQUFlLElBQWY7QUFDQTtBQUNBOztBQUVELFFBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsYUFBYSxTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUFyRyxDQUFoRCxHQUFnSyxFQUFqSyxJQUF3SyxDQUE1SztBQUNBLFFBQUssU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsU0FBcEMsR0FBZ0QsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsWUFBcEMsSUFBb0QsV0FBVyxDQUFYLEVBQWMsQ0FBZCxHQUFrQixTQUFTLEtBQVQsQ0FBZSxvQkFBZixDQUFvQyxPQUExRyxDQUFoRCxHQUFxSyxFQUF0SyxJQUE2SyxDQUFqTDs7QUFFQSxRQUFJLEtBQUssV0FBVyxZQUFYLENBQXdCLENBQXhCLENBQVQ7QUFDQSxTQUFLLGFBQUwsQ0FBbUIsU0FBbkIsQ0FBNkIsRUFBN0IsSUFBbUM7QUFDbEMsU0FBSSxFQUQ4QixFQUMxQixZQUFZLFdBRGMsRUFDRCxpQkFBaUIsZUFEaEIsRUFDaUMsZ0JBQWdCLENBRGpELEVBQ29ELElBQUksQ0FEeEQsRUFDMkQsSUFBSTtBQUQvRCxLQUFuQzs7QUFLQTs7QUFFQSxRQUFJLDhCQUE4QixZQUFsQyxFQUFnRDtBQUMvQyxTQUFJLFNBQUo7QUFDQSxTQUFJLE1BQUosQ0FBVyxDQUFYLEVBQWMsQ0FBZDs7QUFHQSxTQUFJLHdCQUFKLEVBQXVCO0FBQ3RCLGVBQVMsU0FBVDtBQUNBLGVBQVMsTUFBVCxDQUFnQixDQUFoQixFQUFtQixDQUFuQjtBQUNBOztBQUVELGtDQUE2QixLQUE3QjtBQUNBLG9CQUFlLEtBQWY7QUFDQSxLQVpELE1BWU87O0FBRU4sU0FBSSxNQUFKLENBQVcsQ0FBWCxFQUFjLENBQWQ7O0FBRUEsU0FBSSx3QkFBSixFQUNDLFNBQVMsTUFBVCxDQUFnQixDQUFoQixFQUFtQixDQUFuQjs7QUFFRCxTQUFJLElBQUksR0FBSixJQUFXLENBQWYsRUFBa0I7QUFDakIsVUFBSSxNQUFKO0FBQ0EsVUFBSSxTQUFKO0FBQ0EsVUFBSSxNQUFKLENBQVcsQ0FBWCxFQUFjLENBQWQ7O0FBRUEsVUFBSSx3QkFBSixFQUF1QjtBQUN0QixnQkFBUyxNQUFUO0FBQ0EsZ0JBQVMsU0FBVDtBQUNBLGdCQUFTLE1BQVQsQ0FBZ0IsQ0FBaEIsRUFBbUIsQ0FBbkI7QUFDQTtBQUNEO0FBQ0Q7O0FBRUQ7QUFDQSxRQUFJLFdBQVcsQ0FBWCxFQUFjLFVBQWQsR0FBMkIsQ0FBM0IsSUFBZ0MsV0FBVyxVQUFYLEdBQXdCLENBQTVELEVBQStEOztBQUU5RCxTQUFJLGNBQWMsV0FBVyxtQkFBWCxDQUErQixDQUEvQixFQUFrQyxDQUFsQyxFQUFxQyxDQUFyQyxFQUF3QyxHQUF4QyxDQUFsQjtBQUNBLGFBQVEsSUFBUixDQUFhLFdBQWI7O0FBRUE7QUFDQTtBQUNBOztBQUVBLFNBQUksY0FBYyxnQ0FBb0IsRUFBcEIsQ0FBbEI7O0FBRUE7O0FBRUEsU0FBSSx3QkFBSixFQUF1QjtBQUN0QixjQUFRLElBQVIsQ0FBYTtBQUNaLFVBQUcsQ0FEUyxFQUNOLEdBQUcsQ0FERyxFQUNBLEtBQUssUUFETDtBQUVaLGFBQU0sWUFBWSxJQUZOO0FBR1osYUFBTSxZQUFZLElBSE47QUFJWixjQUFPLFdBSks7QUFLWixvQkFBYSxXQUxEO0FBTVosd0JBQWlCLFlBQVk7QUFOakIsT0FBYjtBQVFBO0FBQ0Q7O0FBRUQsUUFBSSxXQUFXLENBQVgsRUFBYyxVQUFkLElBQTRCLFdBQVcsVUFBdkMsSUFBcUQsV0FBVyxDQUFYLEVBQWMsbUJBQW5FLElBQTBGLFdBQVcsbUJBQXpHLEVBQThIOztBQUU3SCxVQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUI7QUFDdEIsaUJBQVcsTUFEVztBQUV0QixpQkFBVyxXQUFXLENBQVgsQ0FGVztBQUd0QixrQkFBWSxVQUhVO0FBSXRCLGFBQU87QUFDTixVQUFHLENBREcsRUFDQSxHQUFHO0FBREgsT0FKZTtBQU90QixpQkFBVyxXQUFXLENBQVgsRUFBYyxDQUFkLElBQW1CLENBQW5CLEdBQXVCLENBQXZCLEdBQTJCLENBQUMsQ0FQakI7QUFRdEIsYUFBTztBQVJlLE1BQXZCO0FBV0E7QUFFRDs7QUFFRCxPQUFJLE1BQUo7O0FBRUEsT0FBSSx3QkFBSixFQUNDLFNBQVMsTUFBVDtBQUNEO0FBRUQ7O0FBR0Qsa0JBQWEsV0FBYixDQUF5QixPQUF6QjtBQUNBLEtBQUksT0FBSjs7QUFFQSxLQUFJLFNBQUo7O0FBRUEsS0FBSSx3QkFBSixFQUNDLFNBQVMsU0FBVDs7QUFFRDtBQUNBLEtBQUksZ0JBQWdCO0FBQ25CLFVBQVEsR0FEVyxFQUNOLE1BQU0sS0FBSyxRQUFMLENBQWMsR0FEZCxFQUNtQixtQkFBbUIsbUJBQWdCLGNBRHRELEVBQ3NFLGdCQUFnQixtQkFBZ0IsTUFBaEIsQ0FBdUIsTUFEN0csRUFDcUgsZUFBZTtBQURwSSxFQUFwQjtBQUdBLFFBQU8sYUFBUDtBQUNBLENBL0xEOztBQWlNQSxNQUFNLFNBQU4sQ0FBZ0IsY0FBaEIsR0FBaUMsVUFBVSxRQUFWLEVBQW9CO0FBQ3BELEtBQUksTUFBTSxTQUFTLGVBQVQsSUFBNEIsS0FBSyxRQUFMLENBQWMsR0FBcEQ7O0FBRUEsS0FBSSxrQkFBa0IsU0FBUyxpQkFBVCxDQUEyQixNQUFqRDtBQUNBLEtBQUksbUJBQW1CLENBQXZCLEVBQ0M7O0FBRUQsS0FBSSxXQUFXLEtBQUssYUFBTCxDQUFtQixRQUFsQztBQUNBOztBQUVBLEtBQUksSUFBSjs7QUFFQSxLQUFJLFdBQVcsS0FBSyxRQUFwQjs7QUFFQSxLQUFJLFNBQUo7QUFDQSxLQUFJLElBQUosQ0FBUyxTQUFTLEVBQWxCLEVBQXNCLFNBQVMsRUFBL0IsRUFBbUMsU0FBUyxLQUE1QyxFQUFtRCxTQUFTLE1BQTVEO0FBQ0EsS0FBSSxJQUFKOztBQUVBLEtBQUksVUFBVSxFQUFkOztBQUVBLE1BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxTQUFTLGlCQUFULENBQTJCLE1BQS9DLEVBQXVELEdBQXZELEVBQTREOztBQUUzRCxNQUFJLGtCQUFrQixTQUFTLGlCQUFULENBQTJCLENBQTNCLENBQXRCOztBQUVBLE1BQUksYUFBYSxLQUFLLElBQUwsQ0FBVSxlQUFWLENBQWpCO0FBQ0EsTUFBSSxTQUFKLEdBQWdCLFdBQVcsYUFBM0I7QUFDQSxNQUFJLGFBQWEsV0FBVyxVQUE1Qjs7QUFFQSxNQUFJLElBQUksV0FBUixFQUFxQjtBQUNwQixPQUFJLFdBQUosQ0FBZ0IsNkJBQWlCLFdBQVcsWUFBNUIsRUFBMEMsV0FBVyxhQUFyRCxDQUFoQjtBQUNBOztBQUVELE1BQUksV0FBVyxXQUFXLEVBQTFCO0FBQ0EsT0FBSyxhQUFMLENBQW1CLFNBQW5CLENBQTZCLFFBQTdCLElBQXlDO0FBQ3hDLGVBQVksWUFENEIsRUFDZCxpQkFBaUI7QUFESCxHQUF6QztBQUdBLE1BQUksV0FBVyxnQ0FBb0IsUUFBcEIsQ0FBZjtBQUNBLFdBQVMsV0FBVCxHQUF1QixRQUF2QjtBQUNBO0FBQ0EsV0FBUyxTQUFULEdBQXFCLFdBQVcsYUFBWCxHQUEyQixDQUEzQixHQUErQixLQUFLLEdBQUwsQ0FBUyxXQUFXLGFBQXBCLEVBQW1DLENBQW5DLENBQS9CLEdBQXVFLENBQTVGOztBQUVBLE1BQUksV0FBVyxXQUFXLFNBQTFCO0FBQ0EsTUFBSSxRQUFRLFNBQVMsQ0FBVCxDQUFaO0FBQ0EsTUFBSSxXQUFKLEdBQWtCLEtBQWxCOztBQUVBLE1BQUksNkJBQTZCLElBQWpDO0FBQ0EsTUFBSSxJQUFJLENBQVI7QUFBQSxNQUFXLENBQVg7QUFBQSxNQUFjLENBQWQ7QUFDQSxNQUFJLFVBQUosQ0EzQjJELENBMkIzQzs7QUFFaEI7QUFDQTtBQUNBLE1BQUksU0FBSjtBQUNBLE1BQUksV0FBVyxNQUFYLEdBQW9CLENBQXhCLEVBQTJCO0FBQzFCOztBQUVBO0FBQ0EsT0FBSSxlQUFlLEtBQW5CO0FBQ0EsUUFBSyxJQUFJLENBQVQsRUFBWSxJQUFJLFdBQVcsTUFBM0IsRUFBbUMsR0FBbkMsRUFBd0M7O0FBRXZDLGlCQUFhLFdBQVcsQ0FBWCxFQUFjLE9BQWQsR0FBd0IsV0FBVyxDQUFYLEVBQWMsQ0FBZCxDQUFnQixPQUFoQixFQUF4QixHQUFvRCxXQUFXLENBQVgsRUFBYyxDQUEvRTs7QUFFQSxRQUFJLGFBQWEsU0FBUyxLQUFULENBQWUsUUFBZixDQUF3QixXQUFyQyxJQUFvRCxhQUFhLFNBQVMsS0FBVCxDQUFlLFFBQWYsQ0FBd0IsV0FBN0YsRUFDQzs7QUFFRDtBQUNBOztBQUVBLFFBQUksT0FBUSxXQUFXLENBQVgsRUFBYyxDQUF0QixLQUE2QixRQUFqQyxFQUEyQztBQUMxQyxTQUFJLElBQUksQ0FBUixFQUFXO0FBQUM7QUFDWCxVQUFJLE1BQUo7O0FBRUEsVUFBSSx3QkFBSixFQUF1QjtBQUN0QixnQkFBUyxNQUFUO0FBQ0E7QUFDRDs7QUFFRCxvQkFBZSxJQUFmO0FBQ0E7QUFDQTs7QUFFRCxRQUFJLFFBQVEsQ0FBWjs7QUFFQSxRQUFLLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELGFBQWEsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBckcsQ0FBaEQsR0FBZ0ssRUFBakssSUFBd0ssQ0FBNUs7QUFDQSxRQUFLLFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFNBQXBDLEdBQWdELFNBQVMsS0FBVCxDQUFlLG9CQUFmLENBQW9DLFlBQXBDLElBQW9ELFdBQVcsQ0FBWCxFQUFjLENBQWQsR0FBa0IsU0FBUyxLQUFULENBQWUsb0JBQWYsQ0FBb0MsT0FBMUcsQ0FBaEQsR0FBcUssRUFBdEssSUFBNkssQ0FBakw7O0FBRUEsUUFBSSxLQUFLLFdBQVcsWUFBWCxDQUF3QixDQUF4QixDQUFUO0FBQ0EsU0FBSyxhQUFMLENBQW1CLFNBQW5CLENBQTZCLEVBQTdCLElBQW1DO0FBQ2xDLFNBQUksRUFEOEIsRUFDMUIsWUFBWSxXQURjLEVBQ0QsaUJBQWlCLGVBRGhCLEVBQ2lDLGdCQUFnQixDQURqRCxFQUNvRCxJQUFJLENBRHhELEVBQzJELElBQUk7QUFEL0QsS0FBbkM7O0FBS0E7O0FBRUEsUUFBSSw4QkFBOEIsWUFBbEMsRUFBZ0Q7QUFDL0MsU0FBSSxTQUFKO0FBQ0EsU0FBSSxNQUFKLENBQVcsQ0FBWCxFQUFjLENBQWQ7O0FBRUEsU0FBSSx3QkFBSixFQUF1QjtBQUN0QixlQUFTLFNBQVQ7QUFDQSxlQUFTLE1BQVQsQ0FBZ0IsQ0FBaEIsRUFBbUIsQ0FBbkI7QUFDQTs7QUFFRCxrQ0FBNkIsS0FBN0I7QUFDQSxvQkFBZSxLQUFmO0FBQ0EsS0FYRCxNQVdPOztBQUVOLFNBQUksTUFBSixDQUFXLENBQVgsRUFBYyxLQUFkO0FBQ0EsU0FBSSx3QkFBSixFQUNDLFNBQVMsTUFBVCxDQUFnQixDQUFoQixFQUFtQixLQUFuQjs7QUFFRCxTQUFJLE1BQUosQ0FBVyxDQUFYLEVBQWMsQ0FBZDtBQUNBLFNBQUksd0JBQUosRUFDQyxTQUFTLE1BQVQsQ0FBZ0IsQ0FBaEIsRUFBbUIsQ0FBbkI7O0FBRUQsU0FBSSxJQUFJLEdBQUosSUFBVyxDQUFmLEVBQWtCO0FBQ2pCLFVBQUksTUFBSjtBQUNBLFVBQUksU0FBSjtBQUNBLFVBQUksTUFBSixDQUFXLENBQVgsRUFBYyxDQUFkOztBQUVBLFVBQUksd0JBQUosRUFBdUI7QUFDdEIsZ0JBQVMsTUFBVDtBQUNBLGdCQUFTLFNBQVQ7QUFDQSxnQkFBUyxNQUFULENBQWdCLENBQWhCLEVBQW1CLENBQW5CO0FBQ0E7QUFDRDtBQUNEOztBQUVEO0FBQ0EsUUFBSSxXQUFXLENBQVgsRUFBYyxVQUFkLEdBQTJCLENBQTNCLElBQWdDLFdBQVcsVUFBWCxHQUF3QixDQUE1RCxFQUErRDs7QUFFOUQsU0FBSSxjQUFjLFdBQVcsbUJBQVgsQ0FBK0IsQ0FBL0IsRUFBa0MsQ0FBbEMsRUFBcUMsQ0FBckMsRUFBd0MsR0FBeEMsQ0FBbEI7QUFDQSxhQUFRLElBQVIsQ0FBYSxXQUFiOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSxTQUFJLGNBQWMsZ0NBQW9CLEVBQXBCLENBQWxCOztBQUVBO0FBQ0EsU0FBSSx3QkFBSixFQUF1QjtBQUN0QixjQUFRLElBQVIsQ0FBYTtBQUNaLFVBQUcsQ0FEUyxFQUNOLEdBQUcsQ0FERyxFQUNBLEtBQUssUUFETDtBQUVaLGFBQU0sWUFBWSxJQUZOO0FBR1osYUFBTSxZQUFZLElBSE47QUFJWixjQUFPLFdBSks7QUFLWixvQkFBYSxXQUxEO0FBTVosd0JBQWlCLFlBQVk7QUFOakIsT0FBYjtBQVFBO0FBQ0Q7O0FBRUQsUUFBSSxXQUFXLENBQVgsRUFBYyxVQUFkLElBQTRCLFdBQVcsVUFBdkMsSUFBcUQsV0FBVyxDQUFYLEVBQWMsbUJBQW5FLElBQTBGLFdBQVcsbUJBQXpHLEVBQThIOztBQUU3SCxVQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUI7QUFDdEIsaUJBQVcsVUFEVztBQUV0QixpQkFBVyxXQUFXLENBQVgsQ0FGVztBQUd0QixrQkFBWSxVQUhVO0FBSXRCLGFBQU87QUFDTixVQUFHLENBREcsRUFDQSxHQUFHO0FBREgsT0FKZTtBQU90QixpQkFBVyxXQUFXLENBQVgsRUFBYyxDQUFkLElBQW1CLENBQW5CLEdBQXVCLENBQXZCLEdBQTJCLENBQUMsQ0FQakI7QUFRdEIsYUFBTztBQVJlLE1BQXZCO0FBV0E7QUFFRDs7QUFFRCxPQUFJLE1BQUo7QUFDQSxPQUFJLHdCQUFKLEVBQ0MsU0FBUyxNQUFUO0FBQ0Q7QUFDRDs7QUFHRCxrQkFBYSxXQUFiLENBQXlCLE9BQXpCO0FBQ0EsS0FBSSxPQUFKOztBQUVBLEtBQUksU0FBSjs7QUFFQSxLQUFJLHdCQUFKLEVBQ0MsU0FBUyxTQUFUOztBQUVEO0FBQ0EsS0FBSSxnQkFBZ0I7QUFDbkIsVUFBUSxHQURXLEVBQ04sTUFBTSxLQUFLLFFBQUwsQ0FBYyxHQURkLEVBQ21CLG1CQUFtQixtQkFBZ0IsY0FEdEQsRUFDc0UsZ0JBQWdCLG1CQUFnQixNQUFoQixDQUF1QixNQUQ3RyxFQUNxSCxlQUFlO0FBRHBJLEVBQXBCO0FBR0EsUUFBTyxhQUFQO0FBQ0EsQ0E3TEQ7O0FBK0xBLE1BQU0sU0FBTixDQUFnQixrQkFBaEIsR0FBcUMsSUFBckM7O0FBRUEsTUFBTSxTQUFOLENBQWdCLGdCQUFoQixHQUFvQyxZQUFZO0FBQy9DLFFBQU8sT0FBTyxxQkFBUCxJQUNMLE9BQU8sMkJBREYsSUFFTCxPQUFPLHdCQUZGLElBR0wsT0FBTyxzQkFIRixJQUlMLE9BQU8sdUJBSkYsSUFLTCxVQUFVLFFBQVYsRUFBb0I7QUFDbkIsU0FBTyxVQUFQLENBQWtCLFFBQWxCLEVBQTRCLE9BQU8sRUFBbkM7QUFDQSxFQVBIO0FBUUEsQ0FUa0MsRUFBbkM7O0FBV0EsTUFBTSxTQUFOLENBQWdCLHNCQUFoQixHQUEwQyxZQUFZO0FBQ3JELFFBQU8sT0FBTyxvQkFBUCxJQUNOLE9BQU8saUNBREQsSUFFTixPQUFPLDhCQUZELElBR04sT0FBTyw0QkFIRCxJQUlOLE9BQU8sNkJBSkQsSUFLTixZQUxEO0FBTUEsQ0FQd0MsRUFBekM7O0FBU0EsTUFBTSxTQUFOLENBQWdCLGtCQUFoQixHQUFxQyxVQUFVLEVBQVYsRUFBYyxFQUFkLEVBQWtCOztBQUV0RCxLQUFJLE1BQU0sSUFBVjtBQUNBLEtBQUksUUFBUSxJQUFaO0FBQ0EsS0FBSSxVQUFVLElBQWQ7O0FBRUEsS0FBSSxHQUFHLElBQUgsQ0FBUSxPQUFSLENBQWdCLFNBQWhCLEtBQThCLENBQWxDLEVBQXFDO0FBQ3BDLFVBQVEsQ0FBUjtBQUNBLFFBQU0sR0FBRyxDQUFILENBQUssT0FBTCxHQUFlLEdBQUcsQ0FBSCxDQUFLLE9BQUwsRUFBZixHQUFnQyxHQUFHLENBQXpDO0FBQ0EsTUFBSSxPQUFPLEdBQUcsUUFBSCxDQUFZLE9BQXZCLEVBQWdDO0FBQy9CLFdBQVEsR0FBRyxRQUFILENBQVksT0FBWixDQUFvQixHQUFwQixDQUFSOztBQUVBLE9BQUksQ0FBQyxNQUFNLEdBQUcsQ0FBVCxDQUFMLEVBQWtCO0FBQ2QsUUFBSSxVQUFVLENBQWQsRUFDSSxVQUFVLENBQVYsQ0FESixLQUdJLFVBQVcsR0FBRyxDQUFILEdBQU8sS0FBUixHQUFpQixHQUEzQjtBQUNQLElBTEQsTUFPSSxVQUFVLENBQVY7QUFDSjtBQUNELEVBZkQsTUFlTyxJQUFJLEdBQUcsSUFBSCxLQUFZLEtBQVosSUFBcUIsR0FBRyxJQUFILEtBQVksVUFBckMsRUFBaUQ7QUFDdkQsVUFBUSxDQUFSO0FBQ0EsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEdBQUcsVUFBSCxDQUFjLE1BQWxDLEVBQTBDLEdBQTFDLEVBQStDOztBQUU5QyxPQUFJLENBQUMsTUFBTSxHQUFHLFVBQUgsQ0FBYyxDQUFkLEVBQWlCLENBQXZCLENBQUwsRUFDQyxTQUFTLEdBQUcsVUFBSCxDQUFjLENBQWQsRUFBaUIsQ0FBMUI7QUFDRDs7QUFFRCxNQUFJLENBQUMsTUFBTSxHQUFHLENBQVQsQ0FBTCxFQUNDLFVBQVcsR0FBRyxDQUFILEdBQU8sS0FBUixHQUFpQixHQUEzQixDQURELEtBR0MsVUFBVSxDQUFWO0FBQ0Q7O0FBRUQsUUFBTztBQUNOLFdBQVMsT0FESCxFQUNZLE9BQU87QUFEbkIsRUFBUDtBQUdBLENBdENEOztBQXdDQSxNQUFNLFNBQU4sQ0FBZ0Isd0JBQWhCLEdBQTJDLFVBQVUsR0FBVixFQUFlLEVBQWYsRUFBbUIsRUFBbkIsRUFBdUIsT0FBdkIsRUFBZ0MsaUJBQWhDLEVBQW1EO0FBQzdGO0FBQ0EsS0FBSSxRQUFRLDBCQUFaO0FBQ0EsS0FBSSxRQUFRLElBQVo7QUFDQSxxQkFBb0IsT0FBUSxpQkFBUixLQUErQixXQUEvQixHQUE2QyxDQUE3QyxHQUFpRCxpQkFBckU7O0FBRUEsS0FBSSxDQUFDLEdBQUcsSUFBSCxDQUFRLE9BQVIsQ0FBZ0IsU0FBaEIsS0FBOEIsQ0FBOUIsSUFBb0MsR0FBRyxJQUFILEtBQVksS0FBWixJQUFxQixHQUFHLElBQUgsS0FBWSxVQUF0RSxNQUF1RixJQUFJLE9BQUosQ0FBWSxVQUFaLEtBQTJCLENBQTNCLElBQWdDLElBQUksT0FBSixDQUFZLFFBQVosS0FBeUIsQ0FBaEosQ0FBSixFQUF3SjtBQUN2SixNQUFJLFVBQVUsVUFBZDtBQUNBLE1BQUksUUFBUSxRQUFaO0FBQ0EsTUFBSSxNQUFNLElBQVY7O0FBRUEsTUFBSSxrQkFBa0IsS0FBSyxrQkFBTCxDQUF3QixFQUF4QixFQUE0QixFQUE1QixDQUF0Qjs7QUFFQSxVQUFRLE1BQU0sZ0JBQWdCLEtBQXRCLElBQStCLEtBQS9CLEdBQXVDLGdCQUFnQixLQUEvRDtBQUNBLFlBQVUsTUFBTSxnQkFBZ0IsT0FBdEIsSUFBaUMsT0FBakMsR0FBMkMsZ0JBQWdCLE9BQXJFOztBQUVBLEtBQUc7QUFDRixPQUFJLHNCQUFzQixFQUExQjtBQUNBLE9BQUksR0FBRyxtQkFBUCxFQUNDLHNCQUFzQixHQUFHLG1CQUF6QixDQURELEtBRUs7QUFDSiwwQkFBc0IsUUFBdEI7QUFDQSxRQUFJLG1CQUFtQixLQUFLLEdBQUwsQ0FBUyxLQUFLLElBQUwsQ0FBVSxLQUFLLEdBQUwsQ0FBUyxJQUFJLEtBQUssR0FBTCxDQUFTLE9BQVQsQ0FBYixJQUFrQyxLQUFLLElBQWpELENBQVQsRUFBaUUsQ0FBakUsQ0FBdkI7O0FBRUEsUUFBSSxNQUFNLGdCQUFOLEtBQTJCLENBQUMsU0FBUyxnQkFBVCxDQUFoQyxFQUNDLG1CQUFtQixDQUFuQjs7QUFFRCxTQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksZ0JBQXBCLEVBQXNDLEdBQXRDLEVBQTJDO0FBQzFDLDRCQUF1QixHQUF2QjtBQUNBO0FBQ0Q7O0FBRUQsU0FBTSxJQUFJLE9BQUosQ0FBWSxVQUFaLEVBQXdCLHlCQUFhLE9BQWIsRUFBc0IsbUJBQXRCLEVBQTJDLE1BQU0sWUFBakQsQ0FBeEIsQ0FBTjtBQUNBLFNBQU0sSUFBSSxPQUFKLENBQVksUUFBWixFQUFzQix5QkFBYSxLQUFiLEVBQW9CLEdBQUcsa0JBQUgsR0FBd0IsR0FBRyxrQkFBM0IsR0FBZ0QsZ0JBQXBFLENBQXRCLENBQU47QUFDQSxHQWxCRCxRQWtCUyxJQUFJLE9BQUosQ0FBWSxVQUFaLEtBQTJCLENBQTNCLElBQWdDLElBQUksT0FBSixDQUFZLFFBQVosS0FBeUIsQ0FsQmxFO0FBbUJBOztBQUdELEtBQUksTUFBTSxTQUFOLEdBQU0sQ0FBVSxFQUFWLEVBQWM7QUFDdkIsTUFBSyxHQUFHLENBQUgsTUFBVSxJQUFWLElBQWtCLEdBQUcsR0FBRyxNQUFILEdBQVksQ0FBZixNQUFzQixJQUF6QyxJQUFtRCxHQUFHLENBQUgsTUFBVSxJQUFWLElBQWtCLEdBQUcsR0FBRyxNQUFILEdBQVksQ0FBZixNQUFzQixJQUEvRixFQUNDLE9BQU8sR0FBRyxLQUFILENBQVMsQ0FBVCxFQUFZLEdBQUcsTUFBSCxHQUFZLENBQXhCLENBQVA7O0FBRUQsTUFBSSxNQUFNLHVCQUFXLEdBQUcsS0FBSCxDQUFTLENBQVQsRUFBWSxHQUFHLE1BQUgsR0FBWSxDQUF4QixDQUFYLENBQVY7QUFDQSxRQUFNLElBQUksT0FBSixDQUFZLFFBQVosRUFBc0IsaUJBQXRCLENBQU47O0FBRUEsTUFBSSxRQUFRLElBQVo7O0FBRUEsTUFBSTtBQUNILE9BQUksUUFBUSxJQUFJLEtBQUosQ0FBVSx5QkFBVixDQUFaO0FBQ0EsT0FBSSxTQUFTLE1BQU0sTUFBTixHQUFlLENBQTVCLEVBQStCO0FBQzlCLFlBQVEsdUJBQVcsTUFBTSxDQUFOLENBQVgsQ0FBUjtBQUNBLFVBQU0sdUJBQVcsTUFBTSxDQUFOLENBQVgsQ0FBTjtBQUNBO0FBQ0QsR0FORCxDQU1FLE9BQU8sQ0FBUCxFQUFVLENBQ1g7O0FBR0QsTUFBSSxNQUFNLElBQVY7O0FBRUEsTUFBSSxRQUFRLE9BQVosRUFBcUI7QUFDcEIsVUFBTyxHQUFHLEtBQUgsR0FBVyxHQUFHLEtBQWQsR0FBc0IsR0FBRyxLQUFILEdBQVcsR0FBRyxLQUFkLEdBQXNCLEdBQUcsU0FBSCxDQUFhLFVBQVUsR0FBRyxTQUFILENBQWEsTUFBcEMsQ0FBbkQ7QUFDQTs7QUFFRCxNQUFJLEdBQUcsY0FBSCxDQUFrQixHQUFsQixDQUFKLEVBQ0MsTUFBTSxFQUFOLENBREQsS0FFSyxJQUFJLEdBQUcsY0FBSCxDQUFrQixHQUFsQixDQUFKLEVBQ0osTUFBTSxFQUFOLENBREksS0FFQSxPQUFPLEVBQVA7O0FBRUwsTUFBSSxRQUFRLElBQUksR0FBSixDQUFaO0FBQ0EsTUFBSSxVQUFVLElBQWQsRUFDQyxRQUFRLE1BQU0sS0FBTixDQUFSOztBQUVELE1BQUksUUFBUSxHQUFaLEVBQWlCO0FBQ2hCLE9BQUksTUFBTSxLQUFOLElBQWUsTUFBTSxRQUFOLENBQWUsY0FBZixLQUFrQyxVQUFyRCxFQUNDLE9BQU8sV0FBVyxLQUFYLEVBQWtCLEdBQUcsa0JBQUgsR0FBd0IsR0FBRyxrQkFBM0IsR0FBZ0QsR0FBRyxrQkFBSCxHQUF3QixHQUFHLGtCQUEzQixHQUFnRCxNQUFNLEtBQU4sSUFBZSxNQUFNLEtBQU4sQ0FBWSxpQkFBM0IsR0FBK0MsTUFBTSxLQUFOLENBQVksaUJBQTNELEdBQStFLFdBQWpNLEVBQThNLE1BQU0sWUFBcE4sQ0FBUCxDQURELEtBR0MsT0FBTyx5QkFBYSxLQUFiLEVBQW9CLEdBQUcsa0JBQUgsR0FBd0IsR0FBRyxrQkFBM0IsR0FBZ0QsR0FBRyxrQkFBSCxHQUF3QixHQUFHLGtCQUEzQixHQUFnRCxnQkFBcEgsRUFBc0ksTUFBTSxZQUE1SSxDQUFQO0FBQ0QsR0FMRCxNQUtPLElBQUksUUFBUSxHQUFaLEVBQ04sT0FBTyx5QkFBYSxLQUFiLEVBQW9CLEdBQUcsa0JBQUgsR0FBd0IsR0FBRyxrQkFBM0IsR0FBZ0QsR0FBRyxrQkFBSCxHQUF3QixHQUFHLGtCQUEzQixHQUFnRCxnQkFBcEgsRUFBc0ksTUFBTSxZQUE1SSxDQUFQLENBRE0sS0FFRixJQUFJLFFBQVEsR0FBWixFQUNKLE9BQU8seUJBQWEsS0FBYixFQUFvQixHQUFHLGtCQUFILEdBQXdCLEdBQUcsa0JBQTNCLEdBQWdELEdBQUcsa0JBQUgsR0FBd0IsR0FBRyxrQkFBM0IsR0FBZ0QsZ0JBQXBILEVBQXNJLE1BQU0sWUFBNUksQ0FBUCxDQURJLEtBR0osT0FBTyxLQUFQO0FBQ0QsRUE5Q0Q7O0FBZ0RBLFFBQU8sSUFBSSxPQUFKLENBQVksS0FBWixFQUFtQixHQUFuQixDQUFQO0FBQ0EsQ0F2RkQ7O0FBMEZBLE1BQU0sU0FBTixDQUFnQixZQUFoQixHQUErQixrQkFBL0I7O0FBRUEsTUFBTSxTQUFOLENBQWdCLFlBQWhCLEdBQStCLGtCQUEvQjs7QUFFQSxNQUFNLFNBQU4sQ0FBZ0IsbUJBQWhCLEdBQXNDLHlCQUF0Qzs7QUFFQSxNQUFNLFNBQU4sQ0FBZ0Isc0JBQWhCLEdBQXlDLDRCQUF6Qzs7QUFFQSxNQUFNLFNBQU4sQ0FBZ0IsU0FBaEIsR0FBNEIsZUFBNUI7O0FBRUEsTUFBTSxTQUFOLENBQWdCLGdCQUFoQixHQUFtQyxzQkFBbkM7O0FBRUEsTUFBTSxTQUFOLENBQWdCLG1CQUFoQixHQUFzQyx5QkFBdEM7O0FBRUEsTUFBTSxTQUFOLENBQWdCLFVBQWhCLEdBQTZCLGdCQUE3Qjs7QUFFQSxNQUFNLFNBQU4sQ0FBZ0IsZ0JBQWhCLEdBQW1DLHNCQUFuQzs7QUFFQSxNQUFNLFNBQU4sQ0FBZ0IsY0FBaEIsR0FBaUMsb0JBQWpDOztBQUVBLE1BQU0sU0FBTixDQUFnQixpQkFBaEIsR0FBb0MsdUJBQXBDOztBQUVBLE1BQU0sU0FBTixDQUFnQixvQkFBaEIsR0FBdUMsMEJBQXZDOztBQUVBLE1BQU0sU0FBTixDQUFnQixZQUFoQixHQUErQixrQkFBL0I7O0FBRUEsTUFBTSxTQUFOLENBQWdCLGFBQWhCLEdBQWdDLG1CQUFoQzs7QUFFQSxNQUFNLFNBQU4sQ0FBZ0IsaUJBQWhCLEdBQW9DLHVCQUFwQzs7QUFFQSxNQUFNLFNBQU4sQ0FBZ0IsaUJBQWhCLEdBQW9DLHVCQUFwQzs7QUFFQSxNQUFNLFNBQU4sQ0FBZ0IsY0FBaEIsR0FBaUMsb0JBQWpDOztBQUVBLE1BQU0sU0FBTixDQUFnQixlQUFoQixHQUFrQyxxQkFBbEM7O0FBRUEsTUFBTSxTQUFOLENBQWdCLHFCQUFoQixHQUF3QywyQkFBeEM7O0FBRUEsTUFBTSxTQUFOLENBQWdCLFNBQWhCLEdBQTRCLGVBQTVCOztrQkFFZSxLOzs7Ozs7Ozs7QUN6ckdmOzs7O0FBQ0E7O0FBQ0E7Ozs7QUFFQSxTQUFTLFdBQVQsQ0FBcUIsT0FBckIsRUFBOEI7O0FBRTVCLE1BQUksV0FBSjs7QUFFQSxNQUFJLFdBQVcsa0JBQVMsT0FBVCxDQUFmLEVBQWtDLGNBQWMsa0JBQVMsT0FBVCxDQUFkOztBQUVsQyxjQUFZLElBQVosQ0FBaUIsV0FBakIsQ0FBNkIsSUFBN0IsQ0FBa0MsSUFBbEMsRUFBd0MsYUFBeEMsRUFBdUQsV0FBdkQ7QUFFRDs7QUFFRCxtQkFBTyxXQUFQLEVBQW9CLGtCQUFwQjs7a0JBRWUsVzs7Ozs7Ozs7O0FDaEJmOzs7O0FBQ0E7Ozs7QUFFQSxTQUFTLFVBQVQsQ0FBb0IsS0FBcEIsRUFBMkIsT0FBM0IsRUFBb0MsS0FBcEMsRUFBMkMsS0FBM0MsRUFBa0QsRUFBbEQsRUFBc0Q7QUFDcEQsYUFBVyxJQUFYLENBQWdCLFdBQWhCLENBQTRCLElBQTVCLENBQWlDLElBQWpDLEVBQXVDLFlBQXZDLEVBQXFELE9BQXJELEVBQThELEtBQTlEOztBQUVBLE9BQUssS0FBTCxHQUFhLEtBQWI7QUFDQSxPQUFLLE1BQUwsR0FBYyxNQUFNLE1BQXBCO0FBQ0EsT0FBSyxJQUFMLEdBQVksTUFBTSxNQUFOLENBQWEsR0FBekI7QUFDQSxPQUFLLEtBQUwsR0FBYSxLQUFiO0FBQ0EsT0FBSyxzQkFBTCxHQUE4QixDQUE5QjtBQUNBO0FBQ0EsT0FBSyxFQUFMLEdBQVUsRUFBVjtBQUNBLE9BQUssS0FBTCxDQUFXLGFBQVgsQ0FBeUIsU0FBekIsQ0FBbUMsRUFBbkMsSUFBeUM7QUFDdkMsUUFBSSxFQURtQyxFQUMvQixZQUFZLFlBRG1CLEVBQ0wsaUJBQWlCO0FBRFosR0FBekM7QUFHQSxPQUFLLFlBQUwsR0FBb0IsRUFBcEI7QUFDQSxPQUFLLFFBQUwsR0FBZ0IsRUFBaEI7O0FBRUEsT0FBSyxLQUFMLEdBQWEsSUFBYjtBQUNBLE9BQUssS0FBTCxHQUFhLElBQWI7O0FBRUEsTUFBSSxLQUFLLFdBQUwsS0FBcUIsSUFBekIsRUFBK0I7QUFDN0IsUUFBSSxLQUFLLElBQUwsQ0FBVSxLQUFWLENBQWdCLE9BQWhCLENBQUosRUFDRSxLQUFLLFdBQUwsR0FBbUIsRUFBbkIsQ0FERixLQUdFLEtBQUssV0FBTCxHQUFtQixDQUFuQjtBQUNIOztBQUdELE9BQUssYUFBTCxHQUFxQixLQUFLLHVCQUFMLEVBQXJCOztBQUVBLE1BQUksT0FBUSxLQUFLLFFBQUwsQ0FBYyxrQkFBdEIsS0FBOEMsV0FBbEQsRUFBK0Q7O0FBRTdELFNBQUssa0JBQUwsR0FBMEIsS0FBSyxLQUFMLENBQVcsZUFBWCxDQUEyQixLQUFLLGtCQUFoQyxDQUExQjtBQUNEO0FBQ0Y7O0FBRUQsbUJBQU8sVUFBUCxFQUFtQixrQkFBbkI7O0FBRUE7QUFDQSxXQUFXLFNBQVgsQ0FBcUIsdUJBQXJCLEdBQStDLFlBQVk7O0FBRXpEO0FBQ0E7O0FBRUE7QUFDQSxNQUFJLE9BQU8sS0FBSyxJQUFoQjs7QUFFQSxNQUFJLFNBQVMsUUFBVCxJQUFxQixTQUFTLE1BQTlCLElBQXdDLFNBQVMsVUFBakQsSUFBK0QsU0FBUyxRQUF4RSxJQUFvRixTQUFTLE1BQTdGLElBQXVHLFNBQVMsVUFBaEgsSUFBOEgsU0FBUyxZQUF2SSxJQUF1SixTQUFTLGVBQWhLLElBQW1MLFNBQVMsYUFBNUwsSUFBNk0sU0FBUyxRQUF0TixJQUFrTyxTQUFTLFNBQTNPLElBQ0MsU0FBUyxhQURWLElBQzJCLFNBQVMsa0JBRHBDLElBQzBELFNBQVMsZ0JBRG5FLElBQ3VGLFNBQVMsZ0JBRGhHLElBRUMsU0FBUyxhQUZWLElBRTJCLFNBQVMsTUFGcEMsSUFFOEMsU0FBUyxhQUZ2RCxJQUV3RSxTQUFTLFdBRmpGLElBRWdHLFNBQVMsaUJBRjdHLEVBRWdJO0FBQzlILFdBQU8sUUFBUDtBQUNELEdBSkQsTUFLSyxJQUFJLFNBQVMsS0FBVCxJQUFrQixTQUFTLFlBQTNCLElBQTJDLFNBQVMsZUFBcEQsSUFBdUUsU0FBUyxVQUFwRixFQUFnRzs7QUFFbkcsV0FBTyxXQUFQO0FBQ0QsR0FISSxNQUlBLElBQUksU0FBUyxLQUFULElBQWtCLFNBQVMsVUFBM0IsSUFBeUMsU0FBUyxRQUF0RCxFQUFnRTtBQUNuRSxXQUFPLE1BQVA7QUFDRCxHQUZJLE1BRUU7QUFDTCxXQUFPLE9BQVAsQ0FBZSxHQUFmLENBQW1CLHlCQUF5QixJQUE1QztBQUNBLFdBQU8sSUFBUDtBQUNEO0FBQ0YsQ0F2QkQ7O0FBeUJBLFdBQVcsc0JBQVgsR0FBb0MsVUFBVSxJQUFWLEVBQWdCOztBQUVsRDs7QUFFQSxNQUFJLFNBQVMsUUFBVCxJQUFxQixTQUFTLGVBQTlCLElBQWlELFNBQVMsYUFBMUQsSUFBMkUsU0FBUyxLQUFwRixJQUE2RixTQUFTLFlBQXRHLElBQXNILFNBQVMsZUFBL0gsSUFDQyxTQUFTLFFBRFYsSUFDc0IsU0FBUyxTQUQvQixJQUVDLFNBQVMsa0JBRlYsSUFFZ0MsU0FBUyxnQkFGekMsSUFFNkQsU0FBUyxVQUZ0RSxJQUdDLFNBQVMsYUFIVixJQUcyQixTQUFTLE1BSHBDLElBRzhDLFNBQVMsYUFIdkQsSUFHd0UsU0FBUyxVQUhqRixJQUcrRixTQUFTLFdBSHhHLElBR3VILFNBQVMsaUJBSHBJLEVBR3VKO0FBQ3JKLFdBQU8sUUFBUDtBQUNELEdBTEQsTUFNSyxJQUFJLFNBQVMsTUFBVCxJQUFtQixTQUFTLFVBQTVCLElBQTBDLFNBQVMsUUFBbkQsSUFBK0QsU0FBUyxLQUF4RSxJQUFpRixTQUFTLFVBQTFGLElBQXdHLFNBQVMsUUFBckgsRUFBK0g7QUFDbEksV0FBTyxRQUFQO0FBQ0QsR0FGSSxNQUVFLElBQUksU0FBUyxNQUFULElBQW1CLFNBQVMsWUFBNUIsSUFBNEMsU0FBUyxhQUFyRCxJQUFzRSxTQUFTLGdCQUFuRixFQUFxRztBQUMxRyxXQUFPLFVBQVA7QUFDRCxHQUZNLE1BRUE7QUFDTCxXQUFPLE9BQVAsQ0FBZSxHQUFmLENBQW1CLHlCQUF5QixJQUE1QztBQUNBLFdBQU8sSUFBUDtBQUNEO0FBQ0YsQ0FsQkQ7O0FBb0JBO0FBQ0E7QUFDQSxXQUFXLFNBQVgsQ0FBcUIsZUFBckIsR0FBdUMsVUFBVSxDQUFWLEVBQWEsV0FBYixFQUEwQjs7QUFFL0QsTUFBSSxDQUFDLEtBQUssVUFBTixJQUFvQixLQUFLLFVBQUwsQ0FBZ0IsTUFBaEIsS0FBMkIsQ0FBbkQsRUFBc0QsT0FBTyxJQUFQOztBQUV0RCxNQUFJLGVBQWU7QUFDakIsZUFBVyxJQURNLEVBQ0EsVUFBVSxRQURWLEVBQ29CLE9BQU87QUFEM0IsR0FBbkI7QUFHQSxNQUFJLFlBQVksSUFBaEI7O0FBRUEsTUFBSSxJQUFJLENBQVI7QUFDQSxNQUFJLElBQUksQ0FBUjtBQUNBLE1BQUksWUFBWSxDQUFoQixDQVgrRCxDQVc1Qzs7QUFFbkIsTUFBSSxtQkFBbUIsUUFBdkI7QUFDQSxNQUFJLG1CQUFtQixDQUF2QjtBQUFBLE1BQTBCLG9CQUFvQixDQUE5QztBQUNBLE1BQUksZUFBZSxJQUFuQjtBQUNBLE1BQUksbUJBQW1CLENBQXZCOztBQUVBLE1BQUksS0FBSyxLQUFMLENBQVcsUUFBWCxDQUFvQixhQUFwQixLQUFzQyxNQUExQyxFQUFrRDs7QUFFaEQ7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsUUFBSSxTQUFVLEtBQUssVUFBTCxDQUFnQixLQUFLLFVBQUwsQ0FBZ0IsTUFBaEIsR0FBeUIsQ0FBekMsRUFBNEMsQ0FBNUMsR0FBZ0QsS0FBSyxVQUFMLENBQWdCLENBQWhCLEVBQW1CLENBQWpGOztBQUVBLFFBQUksU0FBUyxDQUFiLEVBQ0UsbUJBQW1CLEtBQUssR0FBTCxDQUFTLEtBQUssR0FBTCxDQUFVLENBQUMsS0FBSyxVQUFMLENBQWdCLE1BQWhCLEdBQXlCLENBQTFCLElBQStCLE1BQS9CLElBQXlDLElBQUksS0FBSyxVQUFMLENBQWdCLENBQWhCLEVBQW1CLENBQWhFLENBQUQsSUFBd0UsQ0FBakYsRUFBb0YsQ0FBcEYsQ0FBVCxFQUFpRyxLQUFLLFVBQUwsQ0FBZ0IsTUFBakgsQ0FBbkIsQ0FERixLQUdFLG1CQUFtQixDQUFuQjs7QUFFRjtBQUNEOztBQUVELFNBQU8sSUFBUCxFQUFhOztBQUVYLFFBQUssWUFBWSxDQUFiLEdBQWtCLG1CQUFtQixDQUFyQyxHQUF5QyxtQkFBbUIsQ0FBaEU7O0FBRUEsUUFBSSxLQUFLLENBQUwsSUFBVSxJQUFJLEtBQUssVUFBTCxDQUFnQixNQUFsQyxFQUEwQzs7QUFFeEMsa0JBQVksS0FBSyxVQUFMLENBQWdCLENBQWhCLENBQVo7O0FBRUEsVUFBSSxXQUFXLEtBQUssR0FBTCxDQUFTLFVBQVUsQ0FBVixHQUFjLENBQXZCLENBQWY7O0FBRUEsVUFBSSxXQUFXLGFBQWEsUUFBNUIsRUFBc0M7QUFDcEMscUJBQWEsU0FBYixHQUF5QixTQUF6QjtBQUNBLHFCQUFhLFFBQWIsR0FBd0IsUUFBeEI7QUFDQSxxQkFBYSxLQUFiLEdBQXFCLENBQXJCO0FBQ0Q7O0FBRUQsVUFBSSxZQUFZLEtBQUssR0FBTCxDQUFTLFVBQVUsQ0FBVixHQUFjLENBQXZCLENBQWhCO0FBQ0EsVUFBSSxhQUFhLGdCQUFqQixFQUNFLG1CQUFtQixTQUFuQixDQURGLEtBRUs7QUFDSCxZQUFJLFlBQVksQ0FBaEIsRUFDRSxtQkFERixLQUdFO0FBQ0g7O0FBRUQsVUFBSSxtQkFBbUIsWUFBbkIsSUFBbUMsb0JBQW9CLFlBQTNELEVBQ0U7QUFHSCxLQTFCRCxNQTBCTyxJQUFJLG1CQUFtQixDQUFuQixHQUF1QixDQUF2QixJQUE0QixtQkFBbUIsQ0FBbkIsSUFBd0IsS0FBSyxVQUFMLENBQWdCLE1BQXhFLEVBQ0w7O0FBRUYsUUFBSSxjQUFjLENBQUMsQ0FBbkIsRUFBc0I7QUFDcEI7QUFDQSxrQkFBWSxDQUFaO0FBQ0QsS0FIRCxNQUlFLFlBQVksQ0FBQyxDQUFiO0FBQ0g7O0FBR0QsTUFBSSxDQUFDLFdBQUQsSUFBZ0IsYUFBYSxTQUFiLENBQXVCLENBQXZCLEtBQTZCLENBQWpELEVBQ0UsT0FBTyxZQUFQLENBREYsS0FFSyxJQUFJLGVBQWUsYUFBYSxTQUFiLEtBQTJCLElBQTlDLEVBQ0gsT0FBTyxZQUFQLENBREcsS0FHSCxPQUFPLElBQVA7QUFDSCxDQXBGRDs7QUFzRkE7QUFDQSxXQUFXLFNBQVgsQ0FBcUIsZ0JBQXJCLEdBQXdDLFVBQVUsQ0FBVixFQUFhLENBQWIsRUFBZ0IsVUFBaEIsRUFBNEI7O0FBRWxFLE1BQUksQ0FBQyxLQUFLLFVBQU4sSUFBb0IsS0FBSyxVQUFMLENBQWdCLE1BQWhCLEtBQTJCLENBQW5ELEVBQXNELE9BQU8sSUFBUDs7QUFFdEQsZUFBYSxjQUFjLEtBQTNCO0FBQ0EsTUFBSSxVQUFVLEVBQWQ7QUFDQSxNQUFJLElBQUksQ0FBUjtBQUFBLE1BQVcsSUFBSSxDQUFmO0FBQ0EsTUFBSSxZQUFZLENBQWhCLENBUGtFLENBTy9DO0FBQ25CLE1BQUksaUJBQWlCLEtBQXJCO0FBQ0EsTUFBSSxtQkFBbUIsUUFBdkI7QUFDQSxNQUFJLG1CQUFtQixDQUF2QjtBQUFBLE1BQTBCLG9CQUFvQixDQUE5QztBQUNBLE1BQUksZUFBZSxJQUFuQjtBQUNBLE1BQUksbUJBQW1CLENBQXZCOztBQUVBLE1BQUksS0FBSyxLQUFMLENBQVcsUUFBWCxDQUFvQixhQUFwQixLQUFzQyxNQUExQyxFQUFrRDtBQUNoRCxRQUFJLE9BQU8sS0FBSyxLQUFMLENBQVcsS0FBWCxDQUFpQixXQUFqQixDQUE2QixFQUFFLEdBQUcsQ0FBTCxFQUFRLEdBQUcsQ0FBWCxFQUE3QixDQUFYOztBQUVBLFFBQUksU0FBVSxLQUFLLFVBQUwsQ0FBZ0IsS0FBSyxVQUFMLENBQWdCLE1BQWhCLEdBQXlCLENBQXpDLEVBQTRDLENBQTVDLEdBQWdELEtBQUssVUFBTCxDQUFnQixDQUFoQixFQUFtQixDQUFqRjs7QUFFQSxRQUFJLFNBQVMsQ0FBYixFQUNFLG1CQUFtQixLQUFLLEdBQUwsQ0FBUyxLQUFLLEdBQUwsQ0FBVSxDQUFDLEtBQUssVUFBTCxDQUFnQixNQUFoQixHQUF5QixDQUExQixJQUErQixNQUEvQixJQUF5QyxPQUFPLEtBQUssVUFBTCxDQUFnQixDQUFoQixFQUFtQixDQUFuRSxDQUFELElBQTJFLENBQXBGLEVBQXVGLENBQXZGLENBQVQsRUFBb0csS0FBSyxVQUFMLENBQWdCLE1BQXBILENBQW5CLENBREYsS0FHRSxtQkFBbUIsQ0FBbkI7O0FBRUY7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDRDs7QUFFRCxTQUFPLElBQVAsRUFBYTs7QUFFWDtBQUNBLFFBQUssWUFBWSxDQUFiLEdBQWtCLG1CQUFtQixDQUFyQyxHQUF5QyxtQkFBbUIsQ0FBaEU7O0FBRUEsUUFBSSxLQUFLLENBQUwsSUFBVSxJQUFJLEtBQUssVUFBTCxDQUFnQixNQUFsQyxFQUEwQzs7QUFFeEMsVUFBSSxLQUFLLEtBQUssWUFBTCxDQUFrQixDQUFsQixDQUFUO0FBQ0EsVUFBSSxhQUFhLEtBQUssS0FBTCxDQUFXLGFBQVgsQ0FBeUIsU0FBekIsQ0FBbUMsRUFBbkMsQ0FBakI7QUFDQSxVQUFJLFlBQVksS0FBSyxVQUFMLENBQWdCLENBQWhCLENBQWhCO0FBQ0EsVUFBSSxXQUFXLElBQWY7O0FBRUEsVUFBSSxVQUFKLEVBQWdCOztBQUVkLGdCQUFRLEtBQUssSUFBYjs7QUFFRSxlQUFLLFFBQUw7QUFDQSxlQUFLLGVBQUw7QUFDQSxlQUFLLGtCQUFMO0FBQ0EsZUFBSyxLQUFMO0FBQ0EsZUFBSyxZQUFMO0FBQ0EsZUFBSyxlQUFMO0FBQ0EsZUFBSyxhQUFMO0FBQ0EsZUFBSyxVQUFMOztBQUVFLGdCQUFJLEtBQUssV0FBVyxFQUFoQixJQUFzQixLQUFLLFdBQVcsRUFBdEMsSUFBNEMsS0FBSyxXQUFXLEVBQTVELElBQWtFLEtBQUssV0FBVyxFQUF0RixFQUEwRjtBQUN4RixzQkFBUSxJQUFSLENBQWE7QUFDWCwyQkFBVyxTQURBO0FBRVgsZ0NBQWdCLENBRkw7QUFHWCw0QkFBWSxJQUhEO0FBSVgsMEJBQVUsS0FBSyxHQUFMLENBQVMsS0FBSyxHQUFMLENBQVMsV0FBVyxFQUFYLEdBQWdCLENBQXpCLENBQVQsRUFBc0MsS0FBSyxHQUFMLENBQVMsV0FBVyxFQUFYLEdBQWdCLENBQXpCLENBQXRDLEVBQW1FLEtBQUssR0FBTCxDQUFTLFdBQVcsRUFBWCxHQUFnQixDQUF6QixDQUFuRSxFQUFnRyxLQUFLLEdBQUwsQ0FBUyxXQUFXLEVBQVgsR0FBZ0IsQ0FBekIsQ0FBaEc7QUFDVjtBQUxXLGVBQWI7O0FBUUEsK0JBQWlCLElBQWpCO0FBQ0Q7QUFDRDs7QUFFRixlQUFLLE1BQUw7QUFDQSxlQUFLLFVBQUw7QUFDQSxlQUFLLFFBQUw7QUFDQSxlQUFLLE1BQUw7QUFDQSxlQUFLLFVBQUw7QUFDQSxlQUFLLGFBQUw7QUFDQSxlQUFLLGdCQUFMO0FBQ0EsZUFBSyxZQUFMO0FBQ0EsZUFBSyxTQUFMO0FBQ0UsZ0JBQUksYUFBYSx3QkFBWSxZQUFaLEVBQTBCLFNBQTFCLEVBQXFDLElBQXJDLEtBQThDLENBQS9EO0FBQ0EsZ0JBQUksZUFBZSxhQUFhLEVBQWIsR0FBa0IsVUFBckM7O0FBRUEsdUJBQVcsS0FBSyxJQUFMLENBQVUsS0FBSyxHQUFMLENBQVMsV0FBVyxFQUFYLEdBQWdCLENBQXpCLEVBQTRCLENBQTVCLElBQWlDLEtBQUssR0FBTCxDQUFTLFdBQVcsRUFBWCxHQUFnQixDQUF6QixFQUE0QixDQUE1QixDQUEzQyxDQUFYO0FBQ0EsZ0JBQUksWUFBWSxZQUFoQixFQUE4QjtBQUM1QixzQkFBUSxJQUFSLENBQWE7QUFDWCwyQkFBVyxTQURBO0FBRVgsZ0NBQWdCLENBRkw7QUFHWCw0QkFBWSxJQUhEO0FBSVgsMEJBQVU7QUFKQyxlQUFiO0FBTUQ7O0FBRUQsZ0JBQUksWUFBWSxLQUFLLEdBQUwsQ0FBUyxXQUFXLEVBQVgsR0FBZ0IsQ0FBekIsQ0FBaEI7QUFDQSxnQkFBSSxhQUFhLGdCQUFqQixFQUNFLG1CQUFtQixTQUFuQixDQURGLEtBRUs7QUFDSCxrQkFBSSxZQUFZLENBQWhCLEVBQ0UsbUJBREYsS0FHRTtBQUNIOztBQUVELGdCQUFJLFlBQVksYUFBYSxDQUE3QixFQUFnQztBQUM5QiwrQkFBaUIsSUFBakI7QUFDRDs7QUFFRDs7QUFFRixlQUFLLFdBQUw7QUFDQSxlQUFLLGlCQUFMOztBQUVFLGdCQUFJLGFBQWEsd0JBQVksWUFBWixFQUEwQixTQUExQixFQUFxQyxJQUFyQyxLQUE4QyxDQUEvRDtBQUNBLGdCQUFJLGVBQWUsYUFBYSxFQUFiLEdBQWtCLFVBQXJDOztBQUVBLHVCQUFXLEtBQUssR0FBTCxDQUFTLEtBQUssSUFBTCxDQUFVLEtBQUssR0FBTCxDQUFTLFdBQVcsRUFBWCxHQUFnQixDQUF6QixFQUE0QixDQUE1QixJQUFpQyxLQUFLLEdBQUwsQ0FBUyxXQUFXLEVBQVgsR0FBZ0IsQ0FBekIsRUFBNEIsQ0FBNUIsQ0FBM0MsQ0FBVCxFQUFxRixLQUFLLElBQUwsQ0FBVSxLQUFLLEdBQUwsQ0FBUyxXQUFXLEVBQVgsR0FBZ0IsQ0FBekIsRUFBNEIsQ0FBNUIsSUFBaUMsS0FBSyxHQUFMLENBQVMsV0FBVyxFQUFYLEdBQWdCLENBQXpCLEVBQTRCLENBQTVCLENBQTNDLENBQXJGLENBQVg7QUFDQSxnQkFBSSxZQUFZLFlBQWhCLEVBQThCO0FBQzVCLHNCQUFRLElBQVIsQ0FBYTtBQUNYLDJCQUFXLFNBREE7QUFFWCxnQ0FBZ0IsQ0FGTDtBQUdYLDRCQUFZLElBSEQ7QUFJWCwwQkFBVTtBQUpDLGVBQWI7QUFNRDs7QUFFRCxnQkFBSSxZQUFZLEtBQUssR0FBTCxDQUFTLFdBQVcsRUFBWCxHQUFnQixDQUF6QixDQUFoQjtBQUNBLGdCQUFJLGFBQWEsZ0JBQWpCLEVBQ0UsbUJBQW1CLFNBQW5CLENBREYsS0FFSztBQUNILGtCQUFJLFlBQVksQ0FBaEIsRUFDRSxtQkFERixLQUdFO0FBQ0g7O0FBRUQsZ0JBQUksWUFBWSxhQUFhLENBQTdCLEVBQWdDO0FBQzlCLCtCQUFpQixJQUFqQjtBQUNEOztBQUVEOztBQUVGLGVBQUssUUFBTDtBQUNFLGdCQUFJLGFBQWEsV0FBVyxJQUE1QjtBQUNBLHVCQUFXLEtBQUssSUFBTCxDQUFVLEtBQUssR0FBTCxDQUFTLFdBQVcsRUFBWCxHQUFnQixDQUF6QixFQUE0QixDQUE1QixJQUFpQyxLQUFLLEdBQUwsQ0FBUyxXQUFXLEVBQVgsR0FBZ0IsQ0FBekIsRUFBNEIsQ0FBNUIsQ0FBM0MsQ0FBWDtBQUNBLGdCQUFJLFlBQVksYUFBYSxDQUE3QixFQUFnQztBQUM5QixzQkFBUSxJQUFSLENBQWE7QUFDWCwyQkFBVyxTQURBO0FBRVgsZ0NBQWdCLENBRkw7QUFHWCw0QkFBWSxJQUhEO0FBSVgsMEJBQVU7QUFKQyxlQUFiOztBQU9BLCtCQUFpQixJQUFqQjtBQUNEO0FBQ0Q7O0FBRUYsZUFBSyxLQUFMO0FBQ0EsZUFBSyxVQUFMO0FBQ0UsZ0JBQUksU0FBUyxXQUFXLE1BQXhCO0FBQ0EsZ0JBQUksY0FBYyxLQUFLLElBQUwsS0FBYyxVQUFkLEdBQTJCLFdBQVcsa0JBQVgsR0FBZ0MsV0FBVyxNQUF0RSxHQUErRSxDQUFqRzs7QUFFQSx1QkFBVyxLQUFLLElBQUwsQ0FBVSxLQUFLLEdBQUwsQ0FBUyxPQUFPLENBQVAsR0FBVyxDQUFwQixFQUF1QixDQUF2QixJQUE0QixLQUFLLEdBQUwsQ0FBUyxPQUFPLENBQVAsR0FBVyxDQUFwQixFQUF1QixDQUF2QixDQUF0QyxDQUFYO0FBQ0EsZ0JBQUksV0FBVyxXQUFXLE1BQXRCLElBQWdDLFdBQVcsV0FBL0MsRUFBNEQ7O0FBRTFELGtCQUFJLFNBQVMsSUFBSSxPQUFPLENBQXhCO0FBQ0Esa0JBQUksU0FBUyxJQUFJLE9BQU8sQ0FBeEI7QUFDQSxrQkFBSSxRQUFRLEtBQUssS0FBTCxDQUFXLE1BQVgsRUFBbUIsTUFBbkIsQ0FBWjs7QUFFQSxrQkFBSSxRQUFRLENBQVosRUFDRSxTQUFTLEtBQUssRUFBTCxHQUFVLENBQW5COztBQUVGLHNCQUFRLE9BQU8sQ0FBQyxDQUFFLFFBQVEsS0FBSyxFQUFiLEdBQWtCLEdBQWxCLEdBQXdCLEdBQXpCLEdBQWdDLEdBQWpDLElBQXdDLEdBQXpDLEVBQThDLE9BQTlDLENBQXNELEVBQXRELENBQVAsQ0FBUjtBQUNBOzs7QUFHQSxrQkFBSSxhQUFhLE9BQU8sQ0FBQyxDQUFFLFdBQVcsVUFBWCxHQUF3QixLQUFLLEVBQTdCLEdBQWtDLEdBQWxDLEdBQXdDLEdBQXpDLEdBQWdELEdBQWpELElBQXdELEdBQXpELEVBQThELE9BQTlELENBQXNFLEVBQXRFLENBQVAsQ0FBakI7QUFDQSxrQkFBSSxXQUFXLE9BQU8sQ0FBQyxDQUFFLFdBQVcsUUFBWCxHQUFzQixLQUFLLEVBQTNCLEdBQWdDLEdBQWhDLEdBQXNDLEdBQXZDLEdBQThDLEdBQS9DLElBQXNELEdBQXZELEVBQTRELE9BQTVELENBQW9FLEVBQXBFLENBQVAsQ0FBZjs7QUFFQTtBQUNBLGtCQUFJLGFBQWEsQ0FBYixJQUFrQixXQUFXLFFBQVgsR0FBc0IsQ0FBNUMsRUFBK0M7QUFDN0MsMkJBQVcsR0FBWDtBQUNEOztBQUVELGtCQUFJLGNBQWMsUUFBZCxJQUEwQixVQUFVLENBQVYsS0FBZ0IsQ0FBOUMsRUFBaUQ7QUFDL0MsNEJBQVksR0FBWjs7QUFFQSxvQkFBSSxRQUFRLFVBQVosRUFDRSxTQUFTLEdBQVQ7QUFDSDs7QUFHRCxrQkFBSSxRQUFRLFVBQVIsSUFBc0IsUUFBUSxRQUFsQyxFQUE0QztBQUMxQyx3QkFBUSxJQUFSLENBQWE7QUFDWCw2QkFBVyxTQURBO0FBRVgsa0NBQWdCLENBRkw7QUFHWCw4QkFBWSxJQUhEO0FBSVgsNEJBQVU7QUFKQyxpQkFBYjs7QUFPQSxpQ0FBaUIsSUFBakI7QUFDRDtBQUVGOztBQUVEOztBQUVGLGVBQUssYUFBTDtBQUNFLGdCQUFNLEtBQU0sV0FBVyxFQUFYLEdBQWdCLFdBQVcsZUFBWCxHQUE2QixDQUFwRCxJQUE0RCxLQUFNLFdBQVcsRUFBWCxHQUFnQixXQUFXLGVBQVgsR0FBNkIsQ0FBL0csSUFDQyxLQUFLLFdBQVcsRUFBWCxHQUFnQixXQUFXLGVBQVgsR0FBNkIsQ0FEbkQsSUFDMEQsS0FBSyxXQUFXLEVBQVgsR0FBZ0IsV0FBVyxlQUFYLEdBQTZCLENBRDdHLElBRUUsS0FBSyxHQUFMLENBQVMsV0FBVyxFQUFYLEdBQWdCLENBQWhCLEdBQW9CLFdBQVcsRUFBL0IsR0FBb0MsQ0FBN0MsSUFBa0QsV0FBVyxlQUE3RCxJQUFpRixLQUFLLFdBQVcsRUFBaEIsSUFBc0IsS0FBSyxXQUFXLEVBRjdILEVBRW1JO0FBQ2pJLHNCQUFRLElBQVIsQ0FBYTtBQUNYLDJCQUFXLFNBREE7QUFFWCxnQ0FBZ0IsQ0FGTDtBQUdYLDRCQUFZLElBSEQ7QUFJWCwwQkFBVSxLQUFLLEdBQUwsQ0FBUyxLQUFLLEdBQUwsQ0FBUyxXQUFXLEVBQVgsR0FBZ0IsQ0FBekIsQ0FBVCxFQUFzQyxLQUFLLEdBQUwsQ0FBUyxXQUFXLEVBQVgsR0FBZ0IsQ0FBekIsQ0FBdEMsRUFBbUUsS0FBSyxHQUFMLENBQVMsV0FBVyxFQUFYLEdBQWdCLENBQXpCLENBQW5FLEVBQWdHLEtBQUssR0FBTCxDQUFTLFdBQVcsRUFBWCxHQUFnQixDQUF6QixDQUFoRztBQUNWO0FBTFcsZUFBYjs7QUFRQSwrQkFBaUIsSUFBakI7QUFDRDtBQUNEOztBQUVGLGVBQUssTUFBTDs7QUFFRSxnQkFBSyxLQUFLLEdBQUwsQ0FBUyxXQUFXLEVBQVgsR0FBZ0IsQ0FBaEIsR0FBb0IsV0FBVyxFQUEvQixHQUFvQyxDQUE3QyxJQUFrRCxXQUFXLGVBQTdELElBQWlGLEtBQUssV0FBVyxFQUFoQixJQUFzQixLQUFLLFdBQVcsRUFBeEgsSUFFRSxLQUFLLFdBQVcsRUFBaEIsSUFBdUIsS0FBSyxDQUFDLFdBQVcsRUFBWCxHQUFnQixXQUFXLEVBQTVCLElBQWtDLENBQTlELElBQ0UsS0FBSyxXQUFXLEVBQVgsR0FBZ0IsV0FBVyxlQUFYLEdBQTZCLENBRHBELElBQzJELEtBQUssV0FBVyxFQUFYLEdBQWdCLFdBQVcsZUFBWCxHQUE2QixDQUgvRyxJQUtHLEtBQUssQ0FBQyxXQUFXLEVBQVgsR0FBZ0IsV0FBVyxFQUE1QixJQUFrQyxDQUF4QyxJQUErQyxLQUFLLFdBQVcsRUFBL0QsSUFDRSxLQUFLLFdBQVcsRUFBWCxHQUFnQixXQUFXLGVBQVgsR0FBNkIsQ0FEcEQsSUFDMkQsS0FBSyxXQUFXLEVBQVgsR0FBZ0IsV0FBVyxlQUFYLEdBQTZCLENBTm5ILEVBTXdIOztBQUV0SCxzQkFBUSxJQUFSLENBQWE7QUFDWCwyQkFBVyxTQURBO0FBRVgsZ0NBQWdCLENBRkw7QUFHWCw0QkFBWSxJQUhEO0FBSVgsMEJBQVUsS0FBSyxHQUFMLENBQVMsS0FBSyxHQUFMLENBQVMsV0FBVyxFQUFYLEdBQWdCLENBQXpCLENBQVQsRUFBc0MsS0FBSyxHQUFMLENBQVMsV0FBVyxFQUFYLEdBQWdCLENBQXpCLENBQXRDLEVBQW1FLEtBQUssR0FBTCxDQUFTLFdBQVcsRUFBWCxHQUFnQixDQUF6QixDQUFuRSxFQUFnRyxLQUFLLEdBQUwsQ0FBUyxXQUFXLEVBQVgsR0FBZ0IsQ0FBekIsQ0FBaEc7QUFDVjtBQUxXLGVBQWI7O0FBUUEsK0JBQWlCLElBQWpCO0FBQ0Q7QUFDRDs7QUFuTUo7O0FBdU1BLFlBQUksa0JBQW1CLG1CQUFtQixZQUFuQixJQUFtQyxvQkFBb0IsWUFBOUUsRUFDRTtBQUNIO0FBRUYsS0FwTkQsTUFvTk8sSUFBSSxtQkFBbUIsQ0FBbkIsR0FBdUIsQ0FBdkIsSUFBNEIsbUJBQW1CLENBQW5CLElBQXdCLEtBQUssVUFBTCxDQUFnQixNQUF4RSxFQUNMOztBQUVGLFFBQUksY0FBYyxDQUFDLENBQW5CLEVBQXNCO0FBQ3BCO0FBQ0Esa0JBQVksQ0FBWjtBQUNELEtBSEQsTUFJRSxZQUFZLENBQUMsQ0FBYjtBQUVIOztBQUlELE1BQUksZ0JBQWdCLElBQXBCOztBQUVBLE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxRQUFRLE1BQTVCLEVBQW9DLEdBQXBDLEVBQXlDO0FBQ3ZDLFFBQUksQ0FBQyxhQUFMLEVBQW9CO0FBQ2xCLHNCQUFnQixRQUFRLENBQVIsQ0FBaEI7QUFDRCxLQUZELE1BRU8sSUFBSSxRQUFRLENBQVIsRUFBVyxRQUFYLElBQXVCLGNBQWMsUUFBekMsRUFBbUQ7QUFDeEQsc0JBQWdCLFFBQVEsQ0FBUixDQUFoQjtBQUNEO0FBQ0Y7O0FBRUQ7QUFDQTs7QUFFQTtBQUNBOztBQUVBLFNBQU8sYUFBUDtBQUNELENBdlJEOztBQXlSQSxXQUFXLFNBQVgsQ0FBcUIsbUJBQXJCLEdBQTJDLFVBQVUsS0FBVixFQUFpQixDQUFqQixFQUFvQixDQUFwQixFQUF1QixHQUF2QixFQUE0QjtBQUNyRSxNQUFJLGFBQWEsS0FBSyxVQUF0QjtBQUNBLE1BQUksYUFBYSxJQUFqQjs7QUFFQSxNQUFJLGNBQWMsV0FBVyxLQUFYLEVBQWtCLFdBQWxCLEdBQWdDLFdBQVcsS0FBWCxFQUFrQixXQUFsRCxHQUFnRSxXQUFXLFdBQVgsR0FBeUIsV0FBVyxXQUFwQyxHQUFrRCxXQUFXLEtBQVgsRUFBa0IsS0FBbEIsR0FBMEIsV0FBVyxLQUFYLEVBQWtCLEtBQTVDLEdBQW9ELFdBQVcsS0FBWCxHQUFtQixXQUFXLEtBQTlCLEdBQXNDLFdBQVcsU0FBWCxDQUFxQixRQUFRLFdBQVcsU0FBWCxDQUFxQixNQUFsRCxDQUE5TjtBQUNBLE1BQUksb0JBQW9CLFdBQVcsS0FBWCxFQUFrQixpQkFBbEIsR0FBc0MsV0FBVyxLQUFYLEVBQWtCLGlCQUF4RCxHQUE0RSxXQUFXLGlCQUFYLEdBQStCLFdBQVcsaUJBQTFDLEdBQThELElBQWxLO0FBQ0EsTUFBSSx3QkFBd0IsV0FBVyxLQUFYLEVBQWtCLHFCQUFsQixHQUEwQyxXQUFXLEtBQVgsRUFBa0IscUJBQTVELEdBQW9GLFdBQVcscUJBQVgsR0FBbUMsV0FBVyxxQkFBOUMsR0FBc0UsSUFBdEw7QUFDQSxNQUFJLGFBQWEsV0FBVyxLQUFYLEVBQWtCLFVBQWxCLEdBQStCLFdBQVcsS0FBWCxFQUFrQixVQUFqRCxHQUE4RCxXQUFXLFVBQTFGO0FBQ0EsTUFBSSxhQUFhLFdBQVcsS0FBWCxFQUFrQixVQUFsQixHQUErQixXQUFXLEtBQVgsRUFBa0IsVUFBakQsR0FBOEQsV0FBVyxVQUExRjs7QUFHQSxTQUFPO0FBQ0wsT0FBRyxDQURFLEVBQ0MsR0FBRyxDQURKLEVBQ08sS0FBSyxHQURaO0FBRUwsVUFBTSxVQUZEO0FBR0wsVUFBTSxVQUhEO0FBSUwsV0FBTyxXQUpGO0FBS0wsaUJBQWEsaUJBTFI7QUFNTCxxQkFBaUI7QUFOWixHQUFQO0FBUUQsQ0FuQkQ7O2tCQXFCZSxVOzs7Ozs7Ozs7QUM3ZGY7O0FBRUEsU0FBUyxZQUFULENBQXNCLEtBQXRCLEVBQTZCO0FBQzNCLE9BQUssS0FBTCxHQUFhLEtBQWI7QUFDQSxPQUFLLFlBQUwsR0FBb0IsQ0FBcEI7QUFDQSxNQUFJLFFBQVEsSUFBWjtBQUNBLE9BQUssU0FBTCxHQUFpQixFQUFqQjtBQUNBLE9BQUssbUNBQUwsR0FBMkMsRUFBM0M7QUFDQSxPQUFLLDRCQUFMLEdBQW9DLElBQXBDO0FBQ0E7O0FBRUEsT0FBSyxXQUFMLEdBQW1CLHlCQUFhLEtBQUssS0FBTCxDQUFXLEtBQXhCLEVBQStCLEtBQUssS0FBTCxDQUFXLE1BQTFDLENBQW5CO0FBQ0E7QUFDQTs7QUFFQSxPQUFLLFFBQUwsR0FBZ0IsS0FBSyxXQUFMLENBQWlCLFVBQWpCLENBQTRCLElBQTVCLENBQWhCOztBQUVBLE1BQUksZUFBZSxTQUFmLFlBQWUsQ0FBVSxFQUFWLEVBQWM7QUFDL0IsVUFBTSxpQkFBTixDQUF3QixJQUF4QixDQUE2QixLQUE3QixFQUFvQyxFQUFwQztBQUNELEdBRkQ7O0FBSUEsT0FBSyxxQkFBTCxHQUE2QixFQUE3QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Q7O0FBRUQsYUFBYSxTQUFiLENBQXVCLEtBQXZCLEdBQStCLFlBQVk7QUFDekMsT0FBSyxZQUFMLEdBQW9CLENBQXBCO0FBQ0EsT0FBSyxTQUFMLEdBQWlCLEVBQWpCO0FBQ0EsT0FBSyxtQ0FBTCxHQUEyQyxFQUEzQztBQUNBLE9BQUssNEJBQUwsR0FBb0MsSUFBcEM7O0FBRUEsT0FBSyxZQUFMLEdBQW9CLEVBQXBCO0FBQ0E7QUFDQTs7QUFFQSxNQUFJLHdCQUFKLEVBQXVCO0FBQ3JCLFNBQUssUUFBTCxDQUFjLFNBQWQsQ0FBd0IsQ0FBeEIsRUFBMkIsQ0FBM0IsRUFBOEIsS0FBSyxLQUFMLENBQVcsS0FBekMsRUFBZ0QsS0FBSyxLQUFMLENBQVcsTUFBM0Q7QUFDQSxTQUFLLFFBQUwsQ0FBYyxTQUFkO0FBQ0Q7QUFDRixDQWREOztBQWdCQSxhQUFhLFNBQWIsQ0FBdUIsc0JBQXZCLEdBQWdELFlBQVk7QUFDMUQsU0FBTyxFQUFFLEtBQUssWUFBZDtBQUNELENBRkQ7O0FBSUEsYUFBYSxTQUFiLENBQXVCLGlCQUF2QixHQUEyQyxVQUFVLEVBQVYsRUFBYzs7QUFFdkQsTUFBSSxHQUFHLElBQUgsS0FBWSxXQUFaLElBQTJCLEdBQUcsSUFBSCxLQUFZLE9BQTNDLEVBQ0U7O0FBRUYsTUFBSSxrQkFBa0IsRUFBdEI7QUFDQSxNQUFJLEtBQUssZ0NBQW9CLEVBQXBCLENBQVQ7QUFDQSxNQUFJLEtBQUssSUFBVDs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsT0FBSyxLQUFLLEtBQUwsQ0FBVyxhQUFYLENBQXlCLEdBQUcsQ0FBNUIsRUFBK0IsR0FBRyxDQUFsQyxFQUFxQyxLQUFyQyxDQUFMOztBQUVBLE1BQUksTUFBTSxPQUFRLEtBQUssU0FBTCxDQUFlLEVBQWYsQ0FBUixLQUFnQyxXQUExQyxFQUF1RDs7QUFFckQsUUFBSSxpQkFBaUIsS0FBSyxTQUFMLENBQWUsRUFBZixDQUFyQjs7QUFFQSxRQUFJLGVBQWUsVUFBZixLQUE4QixXQUFsQyxFQUErQztBQUM3QyxVQUFJLGFBQWEsS0FBSyxLQUFMLENBQVcsSUFBWCxDQUFnQixlQUFlLGVBQS9CLENBQWpCO0FBQ0EsVUFBSSxZQUFZLFdBQVcsVUFBWCxDQUFzQixlQUFlLGNBQXJDLENBQWhCO0FBQ0EsVUFBSSxpQkFBaUIsZUFBZSxjQUFwQzs7QUFFQTtBQUNBLHFCQUFlLGNBQWYsR0FBZ0M7QUFDOUIsV0FBRyxHQUFHLENBRHdCLEVBQ3JCLEdBQUcsR0FBRyxDQURlLEVBQ1osV0FBVyxTQURDO0FBRTlCLG9CQUFZLFdBQVcsUUFGTyxFQUVHLGdCQUFnQixjQUZuQixFQUVtQyxpQkFBaUIsV0FBVyxLQUYvRDtBQUc5QixlQUFPLEtBQUssS0FBTCxDQUFXO0FBSFksT0FBaEM7QUFLQSxxQkFBZSxZQUFmLEdBQThCO0FBQzVCLGlCQUFTLFNBRG1CLEVBQ1IsYUFBYSxTQURMLEVBQ2dCLFdBQVcsV0FEM0IsRUFDd0MsV0FBVyxXQURuRCxFQUNnRSxVQUFVLFVBRDFFLEVBQ3NGLE9BQU87QUFEN0YsT0FBOUI7QUFHQSxzQkFBZ0IsSUFBaEIsQ0FBcUIsY0FBckI7O0FBRUE7QUFDQSx1QkFBaUIsS0FBSyxTQUFMLENBQWUsV0FBVyxFQUExQixDQUFqQjs7QUFFQTtBQUNBLHFCQUFlLGNBQWYsR0FBZ0M7QUFDOUIsV0FBRyxHQUFHLENBRHdCLEVBQ3JCLEdBQUcsR0FBRyxDQURlO0FBRTlCLG1CQUFXLFNBRm1CLEVBRVIsWUFBWSxXQUFXLFFBRmYsRUFFeUIsZ0JBQWdCLGNBRnpDLEVBRXlELGlCQUFpQixXQUFXLEtBRnJGO0FBRzlCLGVBQU8sS0FBSyxLQUFMLENBQVc7QUFIWSxPQUFoQzs7QUFNQSxxQkFBZSxZQUFmLEdBQThCO0FBQzVCLGlCQUFTLFVBRG1CLEVBQ1AsYUFBYSxXQUFXLFFBRGpCLEVBQzJCLFdBQVcsV0FEdEMsRUFDbUQsV0FBVyxXQUQ5RCxFQUMyRSxVQUFVLFVBRHJGLEVBQ2lHLE9BQU87QUFEeEcsT0FBOUI7QUFHQSxzQkFBZ0IsSUFBaEIsQ0FBcUIsS0FBSyxTQUFMLENBQWUsV0FBVyxFQUExQixDQUFyQjtBQUNEO0FBQ0M7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUF0Q0YsU0F1Q0ssSUFBSSxlQUFlLFVBQWYsS0FBOEIsWUFBbEMsRUFBZ0Q7O0FBRW5ELFlBQUksYUFBYSxLQUFLLEtBQUwsQ0FBVyxJQUFYLENBQWdCLGVBQWUsZUFBL0IsQ0FBakI7QUFDQSxZQUFJLFlBQVksZUFBZSxjQUFmLEtBQWtDLElBQWxDLEdBQXlDLFdBQVcsVUFBWCxDQUFzQixlQUFlLGNBQXJDLENBQXpDLEdBQWdHLElBQWhIOztBQUVBO0FBQ0EsdUJBQWUsY0FBZixHQUFnQztBQUM5QixhQUFHLEdBQUcsQ0FEd0IsRUFDckIsR0FBRyxHQUFHLENBRGU7QUFFOUIsc0JBQVksV0FBVyxRQUZPLEVBRUcsV0FBVyxTQUZkLEVBRXlCLGdCQUFnQixlQUFlLGNBRnhELEVBRXdFLGlCQUFpQixlQUFlLGVBRnhHO0FBRzlCLGlCQUFPLEtBQUssS0FBTCxDQUFXO0FBSFksU0FBaEM7QUFLQSx1QkFBZSxZQUFmLEdBQThCO0FBQzVCLG1CQUFTLEtBQUssS0FBTCxDQUFXLE1BRFEsRUFDQSxhQUFhLEtBQUssS0FBTCxDQUFXLE1BQVgsQ0FBa0IsUUFEL0IsRUFDeUMsV0FBVyxlQURwRCxFQUNxRSxXQUFXLGVBRGhGLEVBQ2lHLFVBQVUsY0FEM0csRUFDMkgsT0FBTztBQURsSSxTQUE5QjtBQUdBLHdCQUFnQixJQUFoQixDQUFxQixjQUFyQjtBQUNEO0FBQ0Y7O0FBRUQ7QUFDQSxNQUFJLDZCQUE2QixFQUFqQztBQUNBLE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxLQUFLLHFCQUFMLENBQTJCLE1BQS9DLEVBQXVELEdBQXZELEVBQTREO0FBQzFELFFBQUksV0FBVyxJQUFmOztBQUVBLFNBQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxnQkFBZ0IsTUFBcEMsRUFBNEMsR0FBNUMsRUFBaUQ7QUFDL0MsVUFBSSxnQkFBZ0IsQ0FBaEIsRUFBbUIsRUFBbkIsS0FBMEIsS0FBSyxxQkFBTCxDQUEyQixDQUEzQixFQUE4QixFQUE1RCxFQUFnRTtBQUM5RCxtQkFBVyxLQUFYO0FBQ0E7QUFDRDtBQUNGOztBQUVELFFBQUksUUFBSixFQUFjO0FBQ1osV0FBSyxTQUFMLENBQWUsS0FBSyxxQkFBTCxDQUEyQixDQUEzQixDQUFmLEVBQThDLFVBQTlDLEVBQTBELEVBQTFEO0FBQ0QsS0FGRCxNQUVPO0FBQ0wsaUNBQTJCLElBQTNCLENBQWdDLEtBQUsscUJBQUwsQ0FBMkIsQ0FBM0IsQ0FBaEM7QUFDRDtBQUNGOztBQUVELE9BQUsscUJBQUwsR0FBNkIsMEJBQTdCOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLGdCQUFnQixNQUFwQyxFQUE0QyxHQUE1QyxFQUFpRDs7QUFFL0MsUUFBSSxXQUFXLEtBQWY7O0FBRUEsU0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEtBQUsscUJBQUwsQ0FBMkIsTUFBL0MsRUFBdUQsR0FBdkQsRUFBNEQ7QUFDMUQsVUFBSSxnQkFBZ0IsQ0FBaEIsRUFBbUIsRUFBbkIsS0FBMEIsS0FBSyxxQkFBTCxDQUEyQixDQUEzQixFQUE4QixFQUE1RCxFQUFnRTtBQUM5RCxtQkFBVyxJQUFYO0FBQ0E7QUFDRDtBQUNGOztBQUVELFFBQUksQ0FBQyxRQUFMLEVBQWU7QUFDYixXQUFLLFNBQUwsQ0FBZSxnQkFBZ0IsQ0FBaEIsQ0FBZixFQUFtQyxXQUFuQyxFQUFnRCxFQUFoRDtBQUNBLFdBQUsscUJBQUwsQ0FBMkIsSUFBM0IsQ0FBZ0MsZ0JBQWdCLENBQWhCLENBQWhDO0FBQ0Q7O0FBRUQsUUFBSSxHQUFHLElBQUgsS0FBWSxPQUFoQixFQUF5QjtBQUN2QixXQUFLLFNBQUwsQ0FBZSxnQkFBZ0IsQ0FBaEIsQ0FBZixFQUFtQyxPQUFuQyxFQUE0QyxFQUE1QztBQUNELEtBRkQsTUFFTyxJQUFJLEdBQUcsSUFBSCxLQUFZLFdBQWhCLEVBQTZCO0FBQ2xDLFdBQUssU0FBTCxDQUFlLGdCQUFnQixDQUFoQixDQUFmLEVBQW1DLFdBQW5DLEVBQWdELEVBQWhEO0FBQ0Q7QUFDRjtBQUNGLENBOUhEOztBQWdJQSxhQUFhLFNBQWIsQ0FBdUIsU0FBdkIsR0FBbUMsVUFBVSxjQUFWLEVBQTBCLFNBQTFCLEVBQXFDLEVBQXJDLEVBQXlDOztBQUUxRSxNQUFJLENBQUMsY0FBRCxJQUFtQixDQUFDLFNBQXhCLEVBQ0U7O0FBRUYsTUFBSSxpQkFBaUIsZUFBZSxjQUFwQztBQUNBLE1BQUksZUFBZSxlQUFlLFlBQWxDO0FBQ0E7QUFDQSxNQUFJLGNBQWMsZUFBZSxZQUFmLENBQTRCLFdBQTlDOztBQUVBLE1BQUksZUFBZSxZQUFmLElBQStCLFlBQVksYUFBYSxTQUFiLENBQVosQ0FBbkMsRUFDRSxZQUFZLGFBQWEsU0FBYixDQUFaLEVBQXFDLElBQXJDLENBQTBDLFdBQTFDLEVBQXVELGNBQXZEOztBQUVGLE1BQUksY0FBYyxVQUFsQixFQUE4QjtBQUM1QixRQUFJLFlBQVksTUFBWixJQUFzQixZQUFZLE1BQVosS0FBdUIsR0FBRyxNQUFILENBQVUsS0FBVixDQUFnQixNQUFqRSxFQUF5RTtBQUN2RSxTQUFHLE1BQUgsQ0FBVSxLQUFWLENBQWdCLE1BQWhCLEdBQXlCLFlBQVksTUFBckM7QUFDRDtBQUNGLEdBSkQsTUFJTztBQUNMLE9BQUcsTUFBSCxDQUFVLEtBQVYsQ0FBZ0IsTUFBaEIsR0FBeUIsS0FBSyxLQUFMLENBQVcsY0FBcEM7QUFDQSxXQUFPLGVBQWUsY0FBdEIsQ0FGSyxDQUVpQztBQUN0QyxXQUFPLGVBQWUsWUFBdEIsQ0FISyxDQUcrQjtBQUNyQzs7QUFFRDtBQUNBLE1BQUksY0FBYyxPQUFkLElBQXlCLGVBQWUsVUFBZixLQUE4QixXQUF2RCxJQUFzRSxLQUFLLEtBQUwsQ0FBVyx1QkFBckYsRUFBOEc7QUFDNUcsU0FBSyxLQUFMLENBQVcsdUJBQVgsQ0FBbUMsSUFBbkMsQ0FBd0MsS0FBSyxLQUFMLENBQVcsSUFBWCxDQUFnQixlQUFlLGVBQS9CLENBQXhDLEVBQXlGLGNBQXpGO0FBQ0Q7QUFDRixDQTNCRDs7a0JBNkJlLFk7Ozs7Ozs7O0FDOU1mLFNBQVMsYUFBVCxDQUF1QixFQUF2QixFQUEyQixFQUEzQixFQUErQixFQUEvQixFQUFtQyxFQUFuQyxFQUF1QyxPQUF2QyxFQUFnRDs7QUFFOUMsTUFBSSxPQUFRLE9BQVIsS0FBcUIsV0FBekIsRUFDRSxVQUFVLENBQVY7O0FBRUYsT0FBSyxRQUFMLEdBQWdCLE9BQWhCOztBQUVBLE9BQUssR0FBTCxHQUFXLEVBQVg7QUFDQSxPQUFLLEdBQUwsR0FBVyxFQUFYO0FBQ0EsT0FBSyxHQUFMLEdBQVcsRUFBWDtBQUNBLE9BQUssR0FBTCxHQUFXLEVBQVg7O0FBRUEsT0FBSyxZQUFMLEdBQW9CLEtBQUssUUFBekI7QUFDQSxPQUFLLGVBQUwsR0FBdUIsS0FBSyxRQUE1QjtBQUNBLE9BQUssYUFBTCxHQUFxQixLQUFLLFFBQTFCO0FBQ0EsT0FBSyxjQUFMLEdBQXNCLEtBQUssUUFBM0I7QUFDRDs7QUFFRCxjQUFjLFNBQWQsQ0FBd0IsYUFBeEIsR0FBd0MsVUFBVSxRQUFWLEVBQW9CLElBQXBCLEVBQTBCO0FBQ2hFLE1BQUksYUFBYSxLQUFqQixFQUF3QjtBQUN0QixTQUFLLFlBQUwsSUFBcUIsS0FBSyxNQUExQjtBQUNELEdBRkQsTUFHSyxJQUFJLGFBQWEsUUFBakIsRUFBMkI7QUFDOUIsU0FBSyxlQUFMLElBQXdCLEtBQUssTUFBN0I7QUFDRCxHQUZJLE1BRUUsSUFBSSxhQUFhLE1BQWpCLEVBQXlCO0FBQzlCLFNBQUssYUFBTCxJQUFzQixLQUFLLEtBQTNCLENBRDhCLENBQ0k7QUFDbkMsR0FGTSxNQUVBLElBQUksYUFBYSxPQUFqQixFQUEwQjtBQUMvQixTQUFLLGNBQUwsSUFBdUIsS0FBSyxLQUE1QixDQUQrQixDQUNHO0FBQ25DO0FBQ0YsQ0FYRDs7QUFhQSxjQUFjLFNBQWQsQ0FBd0IsZUFBeEIsR0FBMEMsVUFBVSxRQUFWLEVBQW9CLElBQXBCLEVBQTBCO0FBQ2xFLE1BQUksYUFBYSxLQUFqQixFQUF3QjtBQUN0QixTQUFLLFlBQUwsSUFBcUIsS0FBSyxNQUExQjtBQUNELEdBRkQsTUFHSyxJQUFJLGFBQWEsUUFBakIsRUFBMkI7QUFDOUIsU0FBSyxlQUFMLElBQXdCLEtBQUssTUFBN0I7QUFDRCxHQUZJLE1BRUUsSUFBSSxhQUFhLE1BQWpCLEVBQXlCO0FBQzlCLFNBQUssYUFBTCxJQUFzQixLQUFLLEtBQTNCLENBRDhCLENBQ0c7QUFDbEMsR0FGTSxNQUVBLElBQUksYUFBYSxPQUFqQixFQUEwQjtBQUMvQixTQUFLLGNBQUwsSUFBdUIsS0FBSyxLQUE1QixDQUQrQixDQUNHO0FBQ25DO0FBQ0YsQ0FYRDs7QUFhQSxjQUFjLFNBQWQsQ0FBd0IsWUFBeEIsR0FBdUMsWUFBWTtBQUNqRDtBQUNBO0FBQ0E7O0FBRUEsU0FBTztBQUNMLFFBQUksS0FBSyxHQUFMLEdBQVcsS0FBSyxhQURmO0FBRUwsUUFBSSxLQUFLLEdBQUwsR0FBVyxLQUFLLFlBRmY7QUFHTCxRQUFJLEtBQUssR0FBTCxHQUFXLEtBQUssY0FIZjtBQUlMLFFBQUksS0FBSyxHQUFMLEdBQVcsS0FBSyxlQUpmO0FBS0wsV0FBUSxLQUFLLEdBQUwsR0FBVyxLQUFLLEdBQWpCLEdBQXdCLEtBQUssY0FBN0IsR0FBOEMsS0FBSyxhQUxyRDtBQU1MLFlBQVMsS0FBSyxHQUFMLEdBQVcsS0FBSyxHQUFqQixHQUF3QixLQUFLLGVBQTdCLEdBQStDLEtBQUs7QUFOdkQsR0FBUDtBQVFELENBYkQ7O0FBZUEsY0FBYyxTQUFkLENBQXdCLEtBQXhCLEdBQWdDLFlBQVk7QUFDMUM7QUFDQSxPQUFLLFlBQUwsR0FBb0IsS0FBSyxRQUF6QjtBQUNBLE9BQUssZUFBTCxHQUF1QixLQUFLLFFBQTVCO0FBQ0EsT0FBSyxhQUFMLEdBQXFCLEtBQUssUUFBMUI7QUFDQSxPQUFLLGNBQUwsR0FBc0IsS0FBSyxRQUEzQjtBQUNELENBTkQ7O2tCQVFlLGE7Ozs7Ozs7OztBQ2xFZjs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBRUEsU0FBUyxNQUFULENBQWdCLEtBQWhCLEVBQXVCLE9BQXZCLEVBQWdDLEtBQWhDLEVBQXVDO0FBQ3JDLFNBQU8sSUFBUCxDQUFZLFdBQVosQ0FBd0IsSUFBeEIsQ0FBNkIsSUFBN0IsRUFBbUMsUUFBbkMsRUFBNkMsT0FBN0MsRUFBc0QsS0FBdEQ7O0FBRUEsT0FBSyxLQUFMLEdBQWEsS0FBYjtBQUNBLE9BQUssTUFBTCxHQUFjLE1BQU0sTUFBcEI7QUFDQSxPQUFLLEdBQUwsR0FBVyxLQUFLLEtBQUwsQ0FBVyxHQUF0QjtBQUNBLE9BQUssUUFBTCxHQUFnQixLQUFLLEtBQUwsQ0FBVyxhQUFYLENBQXlCLFFBQXpDO0FBQ0EsT0FBSyxLQUFMLEdBQWEsRUFBYjs7QUFFQSxPQUFLLEtBQUwsR0FBYSxDQUFiO0FBQ0E7QUFDQSxPQUFLLE1BQUwsR0FBYyxDQUZkLEVBR0EsS0FBSyxXQUFMLEdBQW1CLElBSG5CLEVBSUEsS0FBSyxVQUFMLEdBQWtCLEVBSmxCO0FBS0EsT0FBSyxNQUFMLEdBQWM7QUFDWixRQUFJLElBRFEsRUFDRixJQUFJLElBREYsRUFDUSxJQUFJLElBRFosRUFDa0IsSUFBSTtBQUR0QixHQUFkOztBQUlBLE1BQUksT0FBUSxLQUFLLFFBQUwsQ0FBYyxRQUF0QixLQUFvQyxXQUF4QyxFQUFxRDtBQUNuRCxTQUFLLFFBQUwsR0FBZ0IsS0FBSyxLQUFMLENBQVcsZUFBWCxDQUEyQixLQUFLLFFBQWhDLENBQWhCO0FBQ0E7QUFDRDs7QUFFRCxPQUFLLFVBQUwsR0FBa0Isa0NBQXNCLEtBQUssVUFBM0IsRUFBdUMsS0FBSyxRQUE1QyxFQUFzRCxLQUFLLFVBQTNELENBQWxCOztBQUVBLE9BQUssaUJBQUwsR0FBeUIsS0FBSyxRQUE5QjtBQUNEOztBQUVELG1CQUFPLE1BQVAsRUFBZSxrQkFBZjs7QUFFQSxPQUFPLFNBQVAsQ0FBaUIsTUFBakIsR0FBMEIsWUFBWTs7QUFFcEMsTUFBSSxZQUFhLENBQUMsS0FBSyxrQkFBTixHQUEyQixLQUFLLEtBQWhDLEdBQXdDLEtBQUssS0FBTCxDQUFXLFFBQXBFO0FBQ0EsTUFBSSxZQUFZLFVBQVUsYUFBVixDQUF3QixZQUF4QixFQUFoQjtBQUNBLE1BQUksV0FBVyxJQUFmO0FBQ0EsTUFBSSxNQUFNLENBQVY7QUFDQSxNQUFJLE9BQU8sQ0FBWDtBQUNBLE1BQUksV0FBVyxDQUFmO0FBQ0EsTUFBSSxZQUFZLENBQWhCO0FBQ0EsTUFBSSxhQUFhLENBQWpCOztBQUVBLE1BQUksUUFBUSxFQUFaO0FBQ0EsTUFBSSxPQUFPLEVBQVg7O0FBRUE7QUFDQTs7QUFFQSxNQUFJLEtBQUssYUFBTCxLQUF1QixLQUF2QixJQUFnQyxLQUFLLGFBQUwsS0FBdUIsUUFBM0QsRUFBcUU7QUFDbkUsU0FBSyxXQUFMLEdBQW1CLFlBQW5CO0FBQ0EsZUFBVyxLQUFLLGFBQWhCOztBQUVBLGVBQVcsS0FBSyxRQUFMLEtBQWtCLElBQWxCLEdBQXlCLEtBQUssUUFBOUIsR0FBeUMsVUFBVSxLQUFWLEdBQWtCLEVBQXRFO0FBQ0EsZ0JBQVksS0FBSyxTQUFMLEtBQW1CLElBQW5CLEdBQTBCLEtBQUssU0FBL0IsR0FBMkMsVUFBVSxNQUFWLEdBQW1CLEVBQTFFO0FBQ0QsR0FORCxNQU9LLElBQUksS0FBSyxhQUFMLEtBQXVCLFFBQTNCLEVBQXFDO0FBQ3hDLFNBQUssV0FBTCxHQUFtQixVQUFuQjtBQUNBLGVBQVcsS0FBSyxlQUFoQjs7QUFFQSxlQUFXLEtBQUssUUFBTCxLQUFrQixJQUFsQixHQUF5QixLQUFLLFFBQTlCLEdBQXlDLFVBQVUsS0FBVixHQUFrQixFQUF0RTtBQUNBLGdCQUFZLEtBQUssU0FBTCxLQUFtQixJQUFuQixHQUEwQixLQUFLLFNBQS9CLEdBQTJDLFVBQVUsTUFBVixHQUFtQixFQUExRTtBQUNEOztBQUVELE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxLQUFLLFVBQUwsQ0FBZ0IsTUFBcEMsRUFBNEMsR0FBNUMsRUFBaUQ7QUFDL0MsUUFBSSxhQUFhLEtBQUssVUFBTCxDQUFnQixDQUFoQixDQUFqQjs7QUFHQSxRQUFJLFdBQVcsSUFBWCxLQUFvQixLQUFwQixJQUE2QixXQUFXLElBQVgsS0FBb0IsVUFBakQsSUFBK0QsV0FBVyxJQUFYLEtBQW9CLFFBQXZGLEVBQWlHOztBQUUvRixVQUFJLGFBQWEsV0FBVyxnQkFBWCxHQUE4QixXQUFXLGdCQUF6QyxHQUE0RCxDQUFDLFdBQVcsSUFBWCxLQUFvQixNQUFwQixJQUE4QixXQUFXLElBQVgsS0FBb0IsVUFBbEQsSUFBZ0UsV0FBVyxJQUFYLEtBQW9CLFFBQXBGLElBQWdHLFdBQVcsSUFBWCxLQUFvQixTQUFwSCxJQUFpSSxXQUFXLElBQVgsS0FBb0IsUUFBdEosS0FBbUssV0FBVyxVQUE5SyxHQUEyTCxXQUFXLFVBQXRNLEdBQW1OLHNCQUFXLHNCQUFYLENBQWtDLFdBQVcsSUFBN0MsQ0FBaFM7QUFDQSxVQUFJLGFBQWEsV0FBVyxVQUFYLEdBQXdCLFdBQVcsVUFBbkMsR0FBZ0QsS0FBSyxpQkFBTCxHQUF5QixLQUFLLGlCQUFMLENBQXVCLEVBQUUsT0FBTyxLQUFLLEtBQWQsRUFBcUIsUUFBUSxLQUFLLFFBQWxDLEVBQTRDLFlBQVksVUFBeEQsRUFBb0UsV0FBVyxJQUEvRSxFQUF2QixDQUF6QixHQUM3RCxXQUFXLElBRGY7QUFFQSxVQUFJLGNBQWMsV0FBVyxpQkFBWCxHQUErQixXQUFXLGlCQUExQyxHQUE4RCxXQUFXLFdBQVgsR0FBeUIsV0FBVyxXQUFwQyxHQUFrRCxXQUFXLFNBQVgsQ0FBcUIsQ0FBckIsQ0FBbEk7QUFDQSxVQUFJLGFBQWMsQ0FBQyxXQUFXLFVBQVosS0FBMkIsV0FBVyxJQUFYLEtBQW9CLE1BQXBCLElBQThCLFdBQVcsSUFBWCxLQUFvQixVQUFsRCxJQUFnRSxXQUFXLElBQVgsS0FBb0IsUUFBL0csQ0FBRCxHQUE2SCxDQUE3SCxHQUFpSSxLQUFLLFVBQUwsR0FBa0IsRUFBcEs7QUFDQSxVQUFJLG9CQUFvQixXQUFXLHVCQUFYLEdBQXFDLFdBQVcsdUJBQWhELEdBQTBFLFdBQVcsaUJBQTdHO0FBQ0EsVUFBSSx3QkFBd0IsV0FBVywyQkFBWCxHQUF5QyxXQUFXLDJCQUFwRCxHQUFrRixXQUFXLHFCQUFYLEdBQW1DLEtBQUssR0FBTCxDQUFTLENBQVQsRUFBWSxLQUFLLEtBQUwsQ0FBVyxhQUFhLEVBQXhCLENBQVosQ0FBbkMsR0FBOEUsQ0FBNUw7QUFDQSxVQUFJLFlBQVksV0FBVyxTQUFYLENBQXFCLENBQXJCLENBQWhCOztBQUVBLG1CQUFhLEtBQUssS0FBTCxDQUFXLHdCQUFYLENBQW9DLFVBQXBDLEVBQWdELFdBQVcsVUFBWCxDQUFzQixDQUF0QixDQUFoRCxFQUEwRSxVQUExRSxFQUFzRixDQUF0RixDQUFiO0FBQ0EsVUFBSSxPQUFPO0FBQ1Qsb0JBQVksVUFESCxFQUNlLGFBQWEsV0FENUIsRUFDeUMsTUFBTSxVQUQvQyxFQUMyRCxXQUFXLElBRHRFLEVBQzRFLFdBQVcsV0FBVyxJQURsRyxFQUN3RyxZQUFZLFVBRHBILEVBQ2dJLFdBQVcsV0FBVyxTQUFYLENBQXFCLENBQXJCLENBRDNJO0FBRVQseUJBQWlCLFdBQVcsS0FGbkIsRUFFMEIsZ0JBQWdCLElBRjFDLEVBRWdELG1CQUFtQixpQkFGbkUsRUFFc0YsdUJBQXVCO0FBRjdHLE9BQVg7O0FBS0EsWUFBTSxJQUFOLENBQVcsSUFBWDtBQUNELEtBbEJELE1Ba0JPO0FBQ0wsV0FBSyxJQUFJLGlCQUFpQixDQUExQixFQUE2QixpQkFBaUIsV0FBVyxVQUFYLENBQXNCLE1BQXBFLEVBQTRFLGdCQUE1RSxFQUE4Rjs7QUFFNUYsWUFBSSxZQUFZLFdBQVcsVUFBWCxDQUFzQixjQUF0QixDQUFoQjs7QUFFQSxZQUFJLGFBQWEsVUFBVSxnQkFBVixHQUE2QixVQUFVLGdCQUF2QyxHQUEwRCxXQUFXLGdCQUFYLEdBQThCLFdBQVcsZ0JBQXpDLEdBQTRELHNCQUFXLHNCQUFYLENBQWtDLFdBQVcsSUFBN0MsQ0FBdkk7QUFDQSxZQUFJLGFBQWEsVUFBVSxVQUFWLEdBQXVCLFVBQVUsVUFBakMsR0FBOEMsV0FBVyxVQUFYLEdBQXdCLFdBQVcsVUFBbkMsR0FBZ0QsS0FBSyxpQkFBTCxHQUF5QixLQUFLLGlCQUFMLENBQXVCLEVBQUUsT0FBTyxLQUFLLEtBQWQsRUFBcUIsUUFBUSxLQUFLLFFBQWxDLEVBQTRDLFlBQVksVUFBeEQsRUFBb0UsV0FBVyxTQUEvRSxFQUF2QixDQUF6QixHQUMzRyxVQUFVLElBQVYsR0FBaUIsVUFBVSxJQUEzQixHQUFrQyxpQkFBaUIsaUJBQWlCLENBQWxDLENBRHRDO0FBRUEsWUFBSSxjQUFjLFVBQVUsaUJBQVYsR0FBOEIsVUFBVSxpQkFBeEMsR0FBNEQsV0FBVyxpQkFBWCxHQUErQixXQUFXLGlCQUExQyxHQUE4RCxVQUFVLEtBQVYsR0FBa0IsVUFBVSxLQUE1QixHQUFvQyxXQUFXLEtBQVgsR0FBbUIsV0FBVyxLQUE5QixHQUFzQyxXQUFXLFNBQVgsQ0FBcUIsaUJBQWlCLFdBQVcsU0FBWCxDQUFxQixNQUEzRCxDQUF0TjtBQUNBLFlBQUksYUFBYSxLQUFLLFVBQUwsR0FBa0IsRUFBbkM7QUFDQSxZQUFJLG9CQUFvQixVQUFVLHVCQUFWLEdBQW9DLFVBQVUsdUJBQTlDLEdBQXdFLFdBQVcsdUJBQVgsR0FBcUMsV0FBVyx1QkFBaEQsR0FBMEUsVUFBVSxpQkFBVixHQUE4QixVQUFVLGlCQUF4QyxHQUE0RCxXQUFXLGlCQUFqUDtBQUNBLFlBQUksd0JBQXdCLFVBQVUsMkJBQVYsR0FBd0MsVUFBVSwyQkFBbEQsR0FBZ0YsV0FBVywyQkFBWCxHQUF5QyxXQUFXLDJCQUFwRCxHQUFrRixVQUFVLHFCQUFWLElBQW1DLFdBQVcscUJBQTlDLEdBQXNFLEtBQUssR0FBTCxDQUFTLENBQVQsRUFBWSxLQUFLLEtBQUwsQ0FBVyxhQUFhLEVBQXhCLENBQVosQ0FBdEUsR0FBaUgsQ0FBL1M7O0FBRUEscUJBQWEsS0FBSyxLQUFMLENBQVcsd0JBQVgsQ0FBb0MsVUFBcEMsRUFBZ0QsU0FBaEQsRUFBMkQsVUFBM0QsRUFBdUUsY0FBdkUsQ0FBYjs7QUFFQSxZQUFJLE9BQU87QUFDVCxzQkFBWSxVQURILEVBQ2UsYUFBYSxXQUQ1QixFQUN5QyxNQUFNLFVBRC9DLEVBQzJELFdBQVcsSUFEdEUsRUFDNEUsV0FBVyxXQUFXLElBRGxHLEVBQ3dHLFlBQVksVUFEcEg7QUFFVCwyQkFBaUIsQ0FGUixFQUVXLGdCQUFnQixjQUYzQixFQUUyQyxtQkFBbUIsaUJBRjlELEVBRWlGLHVCQUF1QjtBQUZ4RyxTQUFYOztBQUtBLFlBQUksVUFBVSxZQUFWLElBQTJCLFdBQVcsWUFBWCxJQUEyQixVQUFVLFlBQVYsS0FBMkIsS0FBckYsRUFBNkY7QUFDM0YsZ0JBQU0sSUFBTixDQUFXLElBQVg7QUFDRDtBQUNGO0FBQ0Y7QUFDRCxXQUFPLElBQVA7QUFDRDtBQUNELE1BQUksS0FBSyxRQUFMLEtBQWtCLElBQXRCLEVBQTRCO0FBQzFCLFVBQU0sT0FBTjtBQUNEOztBQUVEO0FBQ0EsTUFBSSxNQUFNLE1BQU4sR0FBZSxDQUFuQixFQUFzQjtBQUNwQixRQUFJLE1BQU0sSUFBVjtBQUNBLFFBQUksV0FBVyxDQUFmLENBRm9CLENBRUY7QUFDbEIsUUFBSSxlQUFlLENBQW5CO0FBQ0EsUUFBSSxlQUFlLENBQW5COztBQUVBLFFBQUksS0FBSyxTQUFMLEtBQW1CLElBQXZCLEVBQTZCO0FBQzNCLFVBQUksS0FBSyxZQUFMLEtBQXNCLElBQTFCLEVBQWdDO0FBQzlCLHVCQUFlLEtBQUssR0FBTCxDQUFTLEtBQUssU0FBZCxFQUF5QixLQUFLLFlBQTlCLEVBQTRDLFFBQTVDLENBQWY7QUFDRCxPQUZELE1BRU87QUFDTCx1QkFBZSxLQUFLLEdBQUwsQ0FBUyxLQUFLLFNBQWQsRUFBeUIsUUFBekIsQ0FBZjtBQUNEO0FBQ0YsS0FORCxNQU1PO0FBQ0wsVUFBSSxLQUFLLFlBQUwsS0FBc0IsSUFBMUIsRUFBZ0M7QUFDOUIsdUJBQWUsS0FBSyxHQUFMLENBQVMsS0FBSyxZQUFkLEVBQTRCLFFBQTVCLENBQWY7QUFDRCxPQUZELE1BRU87QUFDTCx1QkFBZSxRQUFmO0FBQ0Q7QUFDRjs7QUFFRCxpQkFBYyxlQUFlLENBQWYsR0FBbUIsS0FBSyxVQUFMLEdBQWtCLEVBQXJDLEdBQTBDLFVBQXhEO0FBQ0EsbUJBQWUsZ0JBQWdCLGFBQWEsS0FBSyxpQkFBTCxHQUF5QixFQUF0RCxDQUFmOztBQUVBLFNBQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxNQUFNLE1BQTFCLEVBQWtDLEdBQWxDLEVBQXVDO0FBQ3JDLFVBQUksT0FBTyxNQUFNLENBQU4sQ0FBWDs7QUFFQSxVQUFJLEtBQUssU0FBTCxLQUFtQixNQUFuQixJQUE2QixLQUFLLFNBQUwsS0FBbUIsUUFBaEQsSUFBNEQsS0FBSyxTQUFMLEtBQW1CLFVBQW5GLEVBQStGO0FBQzdGLHVCQUFlLGVBQWUsS0FBSyxLQUFLLFVBQUwsR0FBa0IsRUFBdkIsQ0FBOUI7QUFDRDs7QUFFRCxVQUFJLGFBQWEsQ0FBYixJQUFrQixPQUFRLFNBQVIsS0FBdUIsV0FBekMsSUFBd0QsZ0JBQWdCLENBQXhFLElBQTZFLE9BQVEsWUFBUixLQUEwQixXQUEzRyxFQUF3SDtBQUN0SDtBQUNEOztBQUVELFVBQUksS0FBSyxXQUFMLEtBQXFCLFlBQXpCLEVBQXVDOztBQUVyQyxhQUFLLFNBQUwsR0FBaUIsSUFBSSxvQkFBSixDQUFjLEtBQUssR0FBbkIsRUFBd0I7QUFDdkMsYUFBRyxDQURvQztBQUV2QyxhQUFHLENBRm9DLEVBRWxDO0FBQ0wsb0JBQVUsWUFINkI7QUFJdkMscUJBQVcsS0FBSyxRQUFMLEdBQWdCLFNBQWhCLEdBQTRCLEtBQUssVUFKTCxFQUlpQjtBQUN4RCxpQkFBTyxDQUxnQztBQU12QyxnQkFBTSxLQUFLLElBTjRCO0FBT3ZDLDJCQUFpQixNQVBzQixFQU9mO0FBQ3hCLG9CQUFVLEtBQUssUUFSd0IsRUFRZjtBQUN4QixzQkFBWSxLQUFLLFVBVHNCO0FBVXZDLHNCQUFZLEtBQUssVUFWc0IsRUFVVjtBQUM3QixxQkFBVyxLQUFLLFNBWHVCO0FBWXZDLHFCQUFXLEtBQUssU0FadUIsRUFZWjtBQUMzQix3QkFBYztBQWJ5QixTQUF4QixDQUFqQjtBQWVBLGFBQUssU0FBTCxDQUFlLFdBQWY7O0FBRUEsWUFBSSxLQUFLLFNBQUwsS0FBbUIsSUFBdkIsRUFBNkI7QUFDM0IsZUFBSyxTQUFMLENBQWUsS0FBZixHQUF1QixLQUFLLFNBQUwsSUFBa0IsYUFBYSxLQUFLLGlCQUFMLEdBQXlCLEVBQXRDLElBQTZDLEtBQUssU0FBTCxLQUFtQixNQUFuQixJQUE2QixLQUFLLFNBQUwsS0FBbUIsUUFBaEQsSUFBNEQsS0FBSyxTQUFMLEtBQW1CLFVBQWhGLEdBQThGLEtBQUssS0FBSyxVQUFMLEdBQWtCLEVBQXZCLENBQTlGLEdBQTJILENBQXZLLENBQWxCLENBQXZCO0FBQ0Q7O0FBRUQsWUFBSSxDQUFDLEdBQUQsSUFBUSxJQUFJLEtBQUosR0FBWSxLQUFLLEtBQUwsQ0FBVyxLQUFLLFNBQUwsQ0FBZSxLQUFmLEdBQXVCLEtBQUssaUJBQUwsR0FBeUIsRUFBaEQsR0FBcUQsVUFBckQsSUFBbUUsSUFBSSxLQUFKLEtBQWMsQ0FBZCxHQUFrQixDQUFsQixHQUF1QixLQUFLLGlCQUEvRixLQUF1SCxLQUFLLFNBQUwsS0FBbUIsTUFBbkIsSUFBNkIsS0FBSyxTQUFMLEtBQW1CLFFBQWhELElBQTRELEtBQUssU0FBTCxLQUFtQixVQUFoRixHQUE4RixLQUFLLEtBQUssVUFBTCxHQUFrQixFQUF2QixDQUE5RixHQUEySCxDQUFqUCxDQUFYLENBQVosR0FBOFEsUUFBMVIsRUFBb1M7QUFDbFMsZ0JBQU07QUFDSixtQkFBTyxFQURILEVBQ08sT0FBTztBQURkLFdBQU47QUFHQSxlQUFLLElBQUwsQ0FBVSxHQUFWO0FBQ0EsZUFBSyxNQUFMLElBQWUsWUFBZjtBQUNBLHlCQUFlLENBQWY7QUFDRDs7QUFFRCx1QkFBZSxLQUFLLEdBQUwsQ0FBUyxZQUFULEVBQXVCLEtBQUssU0FBTCxDQUFlLE1BQXRDLENBQWY7O0FBRUEsYUFBSyxTQUFMLENBQWUsQ0FBZixHQUFtQixJQUFJLEtBQXZCO0FBQ0EsYUFBSyxTQUFMLENBQWUsQ0FBZixHQUFtQixDQUFuQjs7QUFFQSxZQUFJLEtBQUosSUFBYSxLQUFLLEtBQUwsQ0FBVyxLQUFLLFNBQUwsQ0FBZSxLQUFmLEdBQXVCLEtBQUssaUJBQUwsR0FBeUIsRUFBaEQsR0FBcUQsVUFBckQsSUFBbUUsSUFBSSxLQUFKLEtBQWMsQ0FBZCxHQUFrQixDQUFsQixHQUFzQixLQUFLLGlCQUE5RixLQUFxSCxLQUFLLFNBQUwsS0FBbUIsTUFBbkIsSUFBNkIsS0FBSyxTQUFMLEtBQW1CLFFBQWhELElBQTRELEtBQUssU0FBTCxLQUFtQixVQUFoRixHQUE4RixLQUFLLEtBQUssVUFBTCxHQUFrQixFQUF2QixDQUE5RixHQUEySCxDQUEvTyxDQUFYLENBQWI7QUFDQSxZQUFJLEtBQUosQ0FBVSxJQUFWLENBQWUsSUFBZjs7QUFFQSxhQUFLLEtBQUwsR0FBYSxLQUFLLEdBQUwsQ0FBUyxJQUFJLEtBQWIsRUFBb0IsS0FBSyxLQUF6QixDQUFiO0FBQ0QsT0F6Q0QsTUF5Q087O0FBRUwsYUFBSyxTQUFMLEdBQWlCLElBQUksb0JBQUosQ0FBYyxLQUFLLEdBQW5CLEVBQXdCO0FBQ3ZDLGFBQUcsQ0FEb0M7QUFFdkMsYUFBRyxDQUZvQyxFQUVsQztBQUNMLG9CQUFVLFlBSDZCO0FBSXZDLHFCQUFXLEtBQUssUUFBTCxLQUFrQixJQUFsQixHQUF5QixTQUF6QixHQUFxQyxLQUFLLFFBQUwsR0FBZ0IsR0FKekIsRUFJOEI7QUFDckUsaUJBQU8sQ0FMZ0M7QUFNdkMsZ0JBQU0sS0FBSyxJQU40QjtBQU92QywyQkFBaUIsTUFQc0IsRUFPZjtBQUN4QixvQkFBVSxLQUFLLFFBUndCLEVBUWY7QUFDeEIsc0JBQVksS0FBSyxVQVRzQjtBQVV2QyxzQkFBWSxLQUFLLFVBVnNCLEVBVVY7QUFDN0IscUJBQVcsS0FBSyxTQVh1QjtBQVl2QyxxQkFBVyxLQUFLLFNBWnVCLEVBWVo7QUFDM0Isd0JBQWM7QUFieUIsU0FBeEIsQ0FBakI7O0FBZ0JBLGFBQUssU0FBTCxDQUFlLFdBQWY7O0FBRUEsWUFBSSxLQUFLLFNBQUwsS0FBbUIsSUFBdkIsRUFBNkI7QUFDM0IsZUFBSyxTQUFMLENBQWUsS0FBZixHQUF1QixLQUFLLFNBQUwsSUFBa0IsYUFBYSxLQUFLLGlCQUFMLEdBQXlCLEVBQXRDLElBQTZDLEtBQUssU0FBTCxLQUFtQixNQUFuQixJQUE2QixLQUFLLFNBQUwsS0FBbUIsUUFBaEQsSUFBNEQsS0FBSyxTQUFMLEtBQW1CLFVBQWhGLEdBQThGLEtBQUssS0FBSyxVQUFMLEdBQWtCLEVBQXZCLENBQTlGLEdBQTJILENBQXZLLENBQWxCLENBQXZCO0FBQ0Q7O0FBRUQsWUFBSSxLQUFLLE1BQUwsSUFBZSxTQUFuQixFQUE4QjtBQUM1QixnQkFBTTtBQUNKLG1CQUFPLEVBREgsRUFDTyxPQUFPO0FBRGQsV0FBTjtBQUdBLGVBQUssSUFBTCxDQUFVLEdBQVY7QUFDRCxTQUxELE1BS087QUFDTCxnQkFBTSxLQUFLLFFBQUwsQ0FBTjtBQUNBLHFCQUFXLENBQUMsV0FBVyxDQUFaLElBQWlCLEtBQUssTUFBakM7QUFDRDs7QUFFRCxhQUFLLE1BQUwsSUFBZSxLQUFLLFNBQUwsQ0FBZSxNQUE5Qjs7QUFFQSxhQUFLLFNBQUwsQ0FBZSxDQUFmLEdBQW1CLElBQUksS0FBdkIsQ0FwQ0ssQ0FvQ3lCO0FBQzlCLGFBQUssU0FBTCxDQUFlLENBQWYsR0FBbUIsQ0FBbkIsQ0FyQ0ssQ0FxQ2lCOztBQUV0QixZQUFJLEtBQUosSUFBYSxLQUFLLEtBQUwsQ0FBVyxLQUFLLFNBQUwsQ0FBZSxLQUFmLEdBQXVCLEtBQUssaUJBQUwsR0FBeUIsRUFBaEQsR0FBcUQsVUFBckQsSUFBbUUsSUFBSSxLQUFKLEtBQWMsQ0FBZCxHQUFrQixDQUFsQixHQUFzQixLQUFLLGlCQUE5RixLQUFxSCxLQUFLLFNBQUwsS0FBbUIsTUFBbkIsSUFBNkIsS0FBSyxTQUFMLEtBQW1CLFFBQWhELElBQTRELEtBQUssU0FBTCxLQUFtQixVQUFoRixHQUE4RixLQUFLLEtBQUssVUFBTCxHQUFrQixFQUF2QixDQUE5RixHQUEySCxDQUEvTyxDQUFYLENBQWI7QUFDQSxZQUFJLEtBQUosQ0FBVSxJQUFWLENBQWUsSUFBZjs7QUFFQSxhQUFLLEtBQUwsR0FBYSxLQUFLLEdBQUwsQ0FBUyxJQUFJLEtBQWIsRUFBb0IsS0FBSyxLQUF6QixDQUFiO0FBQ0Q7QUFDRjs7QUFFRCxRQUFJLEtBQUssUUFBTCxLQUFrQixLQUF0QixFQUE2QjtBQUMzQixXQUFLLE1BQUwsR0FBYyxLQUFLLE1BQUwsR0FBZSxLQUFLLFVBQWxDO0FBQ0QsS0FGRCxNQUVPO0FBQ0wsV0FBSyxNQUFMLElBQWUsWUFBZjtBQUNEOztBQUVELFNBQUssTUFBTCxHQUFjLEtBQUssR0FBTCxDQUFTLFNBQVQsRUFBb0IsS0FBSyxNQUF6QixDQUFkO0FBQ0EsU0FBSyxLQUFMLEdBQWEsS0FBSyxHQUFMLENBQVMsUUFBVCxFQUFtQixLQUFLLEtBQXhCLENBQWI7QUFDRDs7QUFFRCxNQUFJLEtBQUssYUFBTCxLQUF1QixLQUEzQixFQUFrQztBQUNoQyxRQUFJLEtBQUssZUFBTCxLQUF5QixNQUE3QixFQUNFLE9BQU8sVUFBVSxFQUFqQixDQURGLEtBRUssSUFBSSxLQUFLLGVBQUwsS0FBeUIsT0FBN0IsRUFDSCxPQUFPLFVBQVUsRUFBVixHQUFlLEtBQUssS0FBM0IsQ0FERyxLQUdILE9BQU8sVUFBVSxFQUFWLEdBQWUsVUFBVSxLQUFWLEdBQWtCLENBQWpDLEdBQXFDLEtBQUssS0FBTCxHQUFhLENBQXpEOztBQUVGLFVBQU0sVUFBVSxFQUFoQjtBQUNELEdBVEQsTUFTTyxJQUFJLEtBQUssYUFBTCxLQUF1QixRQUEzQixFQUFxQztBQUMxQyxRQUFJLEtBQUssZUFBTCxLQUF5QixNQUE3QixFQUNFLE9BQU8sVUFBVSxFQUFqQixDQURGLEtBRUssSUFBSSxLQUFLLGVBQUwsS0FBeUIsT0FBN0IsRUFDSCxPQUFPLFVBQVUsRUFBVixHQUFlLEtBQUssS0FBM0IsQ0FERyxLQUdILE9BQU8sVUFBVSxFQUFWLEdBQWUsVUFBVSxLQUFWLEdBQWtCLENBQWpDLEdBQXFDLEtBQUssS0FBTCxHQUFhLENBQXpEOztBQUVGLFVBQU0sVUFBVSxFQUFWLEdBQWUsVUFBVSxNQUFWLEdBQW1CLENBQWxDLEdBQXNDLEtBQUssTUFBTCxHQUFjLENBQTFEO0FBQ0QsR0FUTSxNQVNBLElBQUksS0FBSyxhQUFMLEtBQXVCLFFBQTNCLEVBQXFDO0FBQzFDLFFBQUksS0FBSyxlQUFMLEtBQXlCLE1BQTdCLEVBQ0UsT0FBTyxVQUFVLEVBQWpCLENBREYsS0FFSyxJQUFJLEtBQUssZUFBTCxLQUF5QixPQUE3QixFQUNILE9BQU8sVUFBVSxFQUFWLEdBQWUsS0FBSyxLQUEzQixDQURHLEtBR0gsT0FBTyxVQUFVLEVBQVYsR0FBZSxVQUFVLEtBQVYsR0FBa0IsQ0FBakMsR0FBcUMsS0FBSyxLQUFMLEdBQWEsQ0FBekQ7O0FBRUYsVUFBTSxVQUFVLEVBQVYsR0FBZSxLQUFLLE1BQTFCO0FBQ0Q7O0FBRUQsT0FBSyxLQUFMLEdBQWEsS0FBYjs7QUFFQTtBQUNBLE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxLQUFLLEtBQUwsQ0FBVyxNQUEvQixFQUF1QyxHQUF2QyxFQUE0Qzs7QUFFMUMsUUFBSSxPQUFPLE1BQU0sQ0FBTixDQUFYOztBQUVBLFNBQUssRUFBTCxHQUFVLEVBQUUsS0FBSyxLQUFMLENBQVcsYUFBWCxDQUF5QixZQUFyQztBQUNBLFNBQUssS0FBTCxDQUFXLGFBQVgsQ0FBeUIsU0FBekIsQ0FBbUMsS0FBSyxFQUF4QyxJQUE4QztBQUM1QyxVQUFJLEtBQUssRUFEbUMsRUFDL0IsWUFBWSxZQURtQixFQUNMLGlCQUFpQixDQURaLEVBQ2UsaUJBQWlCLEtBQUssZUFEckMsRUFDc0QsZ0JBQWdCLEtBQUs7QUFEM0UsS0FBOUM7QUFHQTtBQUNEOztBQUVELE1BQUksWUFBWSxDQUFoQjtBQUNBLE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxLQUFLLE1BQXpCLEVBQWlDLEdBQWpDLEVBQXNDO0FBQ3BDLFFBQUksTUFBTSxLQUFLLENBQUwsQ0FBVjtBQUNBLFFBQUksZUFBZSxDQUFuQjtBQUNBLFNBQUssSUFBSSxZQUFZLENBQXJCLEVBQXdCLFlBQVksSUFBSSxLQUFKLENBQVUsTUFBOUMsRUFBc0QsV0FBdEQsRUFBbUU7QUFDakUsVUFBSSxPQUFPLElBQUksS0FBSixDQUFVLFNBQVYsQ0FBWDs7QUFFQSxVQUFJLFFBQVEsS0FBSyxTQUFMLENBQWUsQ0FBZixHQUFtQixJQUFuQixJQUEyQixjQUFjLENBQWQsR0FBa0IsYUFBYSxFQUEvQixHQUFvQyxLQUFLLGlCQUFwRSxDQUFaO0FBQ0EsVUFBSSxRQUFRLE1BQU0sU0FBbEI7O0FBRUEsVUFBSSxTQUFTLEtBQWI7O0FBRUEsVUFBSSxDQUFDLEtBQUssS0FBTCxDQUFXLElBQVgsQ0FBZ0IsS0FBSyxlQUFyQixFQUFzQyxPQUEzQyxFQUNFLEtBQUssR0FBTCxDQUFTLFdBQVQsR0FBdUIsRUFBdkI7O0FBRUYsV0FBSyxHQUFMLENBQVMsSUFBVDtBQUNBLFdBQUssR0FBTCxDQUFTLElBQVQsQ0FBYyxJQUFkLEVBQW9CLEdBQXBCLEVBQXlCLFFBQXpCLEVBQW1DLFNBQW5DO0FBQ0EsV0FBSyxHQUFMLENBQVMsSUFBVDs7QUFFQSxVQUFJLEtBQUssU0FBTCxLQUFtQixNQUFuQixJQUE2QixLQUFLLFNBQUwsS0FBbUIsVUFBaEQsSUFBOEQsS0FBSyxTQUFMLEtBQW1CLFFBQXJGLEVBQStGO0FBQzdGLGFBQUssR0FBTCxDQUFTLFdBQVQsR0FBdUIsS0FBSyxTQUE1QjtBQUNBLGFBQUssR0FBTCxDQUFTLFNBQVQsR0FBcUIsS0FBSyxJQUFMLENBQVUsS0FBSyxVQUFMLEdBQWtCLENBQTVCLENBQXJCO0FBQ0EsYUFBSyxHQUFMLENBQVMsU0FBVDtBQUNBLGFBQUssR0FBTCxDQUFTLE1BQVQsQ0FBZ0IsUUFBUSxLQUFLLFVBQUwsR0FBa0IsRUFBMUMsRUFBOEMsUUFBUSxLQUFLLFVBQUwsR0FBa0IsQ0FBeEU7QUFDQSxhQUFLLEdBQUwsQ0FBUyxNQUFULENBQWdCLFFBQVEsS0FBSyxVQUFMLEdBQWtCLEVBQTFDLEVBQThDLFFBQVEsS0FBSyxVQUFMLEdBQWtCLENBQXhFO0FBQ0EsYUFBSyxHQUFMLENBQVMsTUFBVDs7QUFFQSxrQkFBVSxLQUFLLFVBQUwsR0FBa0IsRUFBNUI7QUFDRDs7QUFFRCx1QkFBYSxVQUFiLENBQXdCLFFBQVEsYUFBYSxDQUE3QyxFQUFnRCxRQUFTLEtBQUssVUFBTCxHQUFrQixDQUEzRSxFQUErRSxLQUFLLEdBQXBGLEVBQXlGLEtBQUssVUFBOUYsRUFBMEcsS0FBSyxVQUEvRyxFQUEySCxLQUFLLFdBQWhJLEVBQTZJLEtBQUssaUJBQWxKLEVBQXFLLEtBQUsscUJBQTFLOztBQUVBLFdBQUssU0FBTCxDQUFlLENBQWYsR0FBbUIsUUFBUSxLQUFLLGlCQUFMLEdBQXlCLEVBQWpDLEdBQXNDLFVBQXpEOztBQUVBLFVBQUksS0FBSyxTQUFMLEtBQW1CLE1BQW5CLElBQTZCLEtBQUssU0FBTCxLQUFtQixVQUFoRCxJQUE4RCxLQUFLLFNBQUwsS0FBbUIsUUFBckYsRUFBK0Y7QUFDN0YsYUFBSyxTQUFMLENBQWUsQ0FBZixHQUFtQixLQUFLLFNBQUwsQ0FBZSxDQUFmLEdBQW1CLEtBQUssVUFBTCxHQUFrQixFQUF4RDtBQUNEOztBQUVELFdBQUssU0FBTCxDQUFlLENBQWYsR0FBbUIsS0FBbkI7O0FBRUEsV0FBSyxTQUFMLENBQWUsTUFBZixDQUFzQixJQUF0Qjs7QUFFQSxXQUFLLEdBQUwsQ0FBUyxPQUFUOztBQUVBLFVBQUksWUFBWSxDQUFoQixFQUFtQjtBQUNqQix1QkFBZSxLQUFLLEdBQUwsQ0FBUyxZQUFULEVBQXVCLEtBQUssU0FBTCxDQUFlLE1BQXRDLENBQWY7QUFDRCxPQUZELE1BRU87QUFDTCx1QkFBZSxLQUFLLFNBQUwsQ0FBZSxNQUE5QjtBQUNEOztBQUVELFVBQUksQ0FBQyxLQUFLLEtBQUwsQ0FBVyxJQUFYLENBQWdCLEtBQUssZUFBckIsRUFBc0MsT0FBM0MsRUFDRSxLQUFLLEdBQUwsQ0FBUyxXQUFULEdBQXVCLENBQXZCOztBQUVGLFVBQUksV0FBVyxvQkFBb0IsS0FBSyxFQUF6QixDQUFmO0FBQ0EsV0FBSyxRQUFMLENBQWMsU0FBZCxHQUEwQixRQUExQjtBQUNBLFdBQUssUUFBTCxDQUFjLFNBQWQ7QUFDQSxXQUFLLFFBQUwsQ0FBYyxRQUFkLENBQXVCLE1BQXZCLEVBQStCLEtBQUssU0FBTCxDQUFlLENBQTlDLEVBQWlELEtBQUssU0FBTCxDQUFlLENBQWYsR0FBbUIsS0FBSyxTQUFMLENBQWUsS0FBbEMsR0FBMEMsTUFBM0YsRUFBbUcsS0FBSyxTQUFMLENBQWUsTUFBbEg7O0FBRUEsV0FBSyxFQUFMLEdBQVUsS0FBSyxLQUFMLENBQVcsYUFBWCxDQUF5QixTQUF6QixDQUFtQyxLQUFLLEVBQXhDLEVBQTRDLEVBQTVDLEdBQWlELE1BQTNEO0FBQ0EsV0FBSyxFQUFMLEdBQVUsS0FBSyxLQUFMLENBQVcsYUFBWCxDQUF5QixTQUF6QixDQUFtQyxLQUFLLEVBQXhDLEVBQTRDLEVBQTVDLEdBQWlELEtBQUssU0FBTCxDQUFlLENBQTFFO0FBQ0EsV0FBSyxFQUFMLEdBQVUsS0FBSyxLQUFMLENBQVcsYUFBWCxDQUF5QixTQUF6QixDQUFtQyxLQUFLLEVBQXhDLEVBQTRDLEVBQTVDLEdBQWlELEtBQUssU0FBTCxDQUFlLENBQWYsR0FBbUIsS0FBSyxTQUFMLENBQWUsS0FBN0Y7QUFDQSxXQUFLLEVBQUwsR0FBVSxLQUFLLEtBQUwsQ0FBVyxhQUFYLENBQXlCLFNBQXpCLENBQW1DLEtBQUssRUFBeEMsRUFBNEMsRUFBNUMsR0FBaUQsS0FBSyxTQUFMLENBQWUsQ0FBZixHQUFtQixLQUFLLFNBQUwsQ0FBZSxNQUE3RjtBQUNEO0FBQ0QsZ0JBQVksWUFBWSxZQUF4QjtBQUNEOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsWUFBVSxhQUFWLENBQXdCLGFBQXhCLENBQXNDLFFBQXRDLEVBQWdELEVBQUUsT0FBTyxLQUFLLEtBQUwsR0FBYSxDQUFiLEdBQWlCLENBQTFCLEVBQTZCLFFBQVEsS0FBSyxNQUFMLEdBQWMsQ0FBZCxHQUFrQixDQUF2RCxFQUFoRDs7QUFFQSxPQUFLLE1BQUwsR0FBYztBQUNaLFFBQUksSUFEUSxFQUNGLElBQUksR0FERixFQUNPLElBQUksT0FBTyxLQUFLLEtBRHZCLEVBQzhCLElBQUksTUFBTSxLQUFLO0FBRDdDLEdBQWQ7QUFHRCxDQWpWRDs7a0JBbVZlLE07Ozs7Ozs7OztBQ3ZYZjs7OztBQUNBOzs7O0FBRUEsU0FBUyxTQUFULENBQW1CLEdBQW5CLEVBQXdCLE9BQXhCLEVBQWlDOztBQUUvQixZQUFVLElBQVYsQ0FBZSxXQUFmLENBQTJCLElBQTNCLENBQWdDLElBQWhDLEVBQXNDLFdBQXRDLEVBQW1ELE9BQW5EOztBQUVBLE9BQUssR0FBTCxHQUFXLEdBQVg7QUFDQSxPQUFLLFFBQUwsR0FBZ0IsSUFBaEI7QUFDQSxPQUFLLFlBQUwsR0FBb0IsSUFBcEI7QUFDQSxPQUFLLFdBQUwsR0FBbUIsa0NBQXNCLEtBQUssVUFBM0IsRUFBdUMsS0FBSyxRQUE1QyxFQUFzRCxLQUFLLFVBQTNELENBQW5CO0FBQ0Q7O0FBRUQsbUJBQU8sU0FBUCxFQUFrQixrQkFBbEI7O0FBRUEsVUFBVSxTQUFWLENBQW9CLE1BQXBCLEdBQTZCLFVBQVUsZUFBVixFQUEyQjtBQUN0RCxNQUFJLGVBQUosRUFDRSxLQUFLLEdBQUwsQ0FBUyxJQUFUOztBQUVGLE1BQUksT0FBTyxLQUFLLEdBQUwsQ0FBUyxJQUFwQjtBQUNBLE9BQUssR0FBTCxDQUFTLFlBQVQsR0FBd0IsS0FBSyxZQUE3Qjs7QUFFQSxNQUFJLFVBQVUsQ0FBZDs7QUFFQSxNQUFJLEtBQUssUUFBVCxFQUNFLEtBQUssV0FBTCxDQUFpQixLQUFLLEdBQXRCOztBQUVGLE9BQUssR0FBTCxDQUFTLFNBQVQsQ0FBbUIsS0FBSyxDQUF4QixFQUEyQixLQUFLLENBQUwsR0FBUyxPQUFwQzs7QUFFQSxNQUFJLEtBQUssWUFBTCxLQUFzQixRQUExQixFQUFvQztBQUNsQyxjQUFVLENBQUMsS0FBSyxXQUFOLEdBQW9CLENBQTlCO0FBQ0Q7O0FBRUQsT0FBSyxHQUFMLENBQVMsSUFBVCxHQUFnQixLQUFLLGNBQUwsRUFBaEI7O0FBRUEsT0FBSyxHQUFMLENBQVMsTUFBVCxDQUFnQixLQUFLLEVBQUwsR0FBVSxHQUFWLEdBQWdCLEtBQUssS0FBckM7O0FBRUEsTUFBSSxXQUFXLENBQWY7QUFDQSxNQUFJLFVBQVUsS0FBSyxPQUFuQjtBQUNBO0FBQ0EsTUFBSSxPQUFPLElBQVg7O0FBRUEsTUFBSyxLQUFLLGVBQUwsR0FBdUIsQ0FBdkIsSUFBNEIsS0FBSyxXQUFsQyxJQUFrRCxLQUFLLGVBQTNELEVBQTRFO0FBQzFFLFNBQUssR0FBTCxDQUFTLFNBQVQsQ0FBbUIsQ0FBbkIsRUFBc0IsT0FBdEIsRUFBK0IsS0FBSyxLQUFwQyxFQUEyQyxLQUFLLE1BQWhELEVBQXdELEtBQUssWUFBN0QsRUFBMkUsS0FBSyxlQUFoRixFQUFpRyxLQUFLLGVBQXRHLEVBQXVILEtBQUssV0FBNUg7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDRDs7QUFFRCxPQUFLLEdBQUwsQ0FBUyxTQUFULEdBQXFCLEtBQUssU0FBMUI7O0FBRUEsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLEtBQUssWUFBTCxDQUFrQixLQUFsQixDQUF3QixNQUE1QyxFQUFvRCxHQUFwRCxFQUF5RDs7QUFFdkQsV0FBTyxLQUFLLFlBQUwsQ0FBa0IsS0FBbEIsQ0FBd0IsQ0FBeEIsQ0FBUDtBQUNBLFFBQUksS0FBSyxlQUFMLEtBQXlCLE9BQTdCLEVBQ0UsV0FBVyxLQUFLLEtBQUwsR0FBYSxLQUFLLEtBQWxCLEdBQTBCLEtBQUssT0FBMUMsQ0FERixLQUVLLElBQUksS0FBSyxlQUFMLEtBQXlCLE1BQTdCLEVBQ0gsV0FBVyxLQUFLLE9BQWhCLENBREcsS0FFQSxJQUFJLEtBQUssZUFBTCxLQUF5QixRQUE3QixFQUNILFdBQVcsQ0FBQyxLQUFLLEtBQUwsR0FBYSxLQUFLLE9BQUwsR0FBZSxDQUE3QixJQUFrQyxDQUFsQyxHQUFzQyxLQUFLLEtBQUwsR0FBYSxDQUFuRCxHQUF1RCxLQUFLLE9BQXZFOztBQUVGLFNBQUssR0FBTCxDQUFTLFFBQVQsQ0FBa0IsS0FBSyxJQUF2QixFQUE2QixRQUE3QixFQUF1QyxPQUF2Qzs7QUFFQSxlQUFXLEtBQUssTUFBaEI7QUFDRDs7QUFFRCxPQUFLLEdBQUwsQ0FBUyxJQUFULEdBQWdCLElBQWhCOztBQUVBLE1BQUksZUFBSixFQUNFLEtBQUssR0FBTCxDQUFTLE9BQVQ7QUFDSCxDQXpERDs7QUEyREEsVUFBVSxTQUFWLENBQW9CLE9BQXBCLEdBQThCLFVBQVUsSUFBVixFQUFnQjtBQUM1QyxPQUFLLElBQUwsR0FBWSxJQUFaO0FBQ0EsT0FBSyxRQUFMLEdBQWdCLElBQWhCO0FBQ0EsT0FBSyxZQUFMLEdBQW9CLElBQXBCO0FBQ0QsQ0FKRDs7QUFNQSxVQUFVLFNBQVYsQ0FBb0IsV0FBcEIsR0FBa0MsWUFBWTtBQUM1QyxNQUFJLEtBQUssUUFBTCxLQUFrQixJQUF0QixFQUE0QjtBQUMxQixVQUFPLDhDQUFQO0FBQ0Q7O0FBRUQsT0FBSyxTQUFMLENBQWUsS0FBSyxHQUFwQjtBQUNBLE9BQUssUUFBTCxHQUFnQixLQUFoQjs7QUFFQSxTQUFPO0FBQ0wsV0FBTyxLQUFLLEtBRFAsRUFDYyxRQUFRLEtBQUs7QUFEM0IsR0FBUDtBQUdELENBWEQ7O0FBYUEsVUFBVSxTQUFWLENBQW9CLGlCQUFwQixHQUF3QyxVQUFVLElBQVYsRUFBZ0IsS0FBaEIsRUFBdUIsUUFBdkIsRUFBaUM7QUFDdkUsU0FBTyxPQUFPLElBQVAsQ0FBUDtBQUNBLGFBQVcsWUFBWSxLQUF2Qjs7QUFFQSxNQUFJLENBQUMsSUFBTCxFQUNFLE9BQU87QUFDTCxVQUFNLEVBREQsRUFDSyxPQUFPO0FBRFosR0FBUDs7QUFJRixNQUFJLFlBQVksQ0FBaEI7QUFBQSxNQUNFLE1BQU0sQ0FEUjtBQUFBLE1BRUUsTUFBTSxLQUFLLE1BQUwsR0FBYyxDQUZ0QjtBQUFBLE1BR0UsTUFBTSxRQUhSOztBQUtBLE9BQUssR0FBTCxDQUFTLElBQVQsR0FBZ0IsS0FBSyxjQUFMLEVBQWhCOztBQUVBLFNBQU8sT0FBTyxHQUFkLEVBQW1CO0FBQ2pCLFVBQU0sS0FBSyxLQUFMLENBQVcsQ0FBQyxNQUFNLEdBQVAsSUFBYyxDQUF6QixDQUFOO0FBQ0EsUUFBSSxXQUFXLEtBQUssTUFBTCxDQUFZLENBQVosRUFBZSxNQUFNLENBQXJCLENBQWY7O0FBRUEsZ0JBQVksS0FBSyxHQUFMLENBQVMsV0FBVCxDQUFxQixRQUFyQixFQUErQixLQUEzQzs7QUFFQSxRQUFJLFlBQVksS0FBaEIsRUFBdUI7QUFDckIsWUFBTSxNQUFNLENBQVo7QUFDRCxLQUZELE1BRU8sSUFBSSxZQUFZLEtBQWhCLEVBQXVCO0FBQzVCLFlBQU0sTUFBTSxDQUFaO0FBQ0QsS0FGTSxNQUVBO0FBQ0w7QUFDRDtBQUNGOztBQUVEO0FBQ0EsTUFBSSxZQUFZLEtBQVosSUFBcUIsU0FBUyxNQUFULEdBQWtCLENBQTNDLEVBQThDO0FBQzVDLGVBQVcsU0FBUyxNQUFULENBQWdCLENBQWhCLEVBQW1CLFNBQVMsTUFBVCxHQUFrQixDQUFyQyxDQUFYO0FBQ0EsZ0JBQVksS0FBSyxHQUFMLENBQVMsV0FBVCxDQUFxQixRQUFyQixFQUErQixLQUEzQztBQUNEOztBQUVELE1BQUksWUFBWSxJQUFoQjs7QUFFQSxNQUFJLFNBQVMsTUFBVCxLQUFvQixLQUFLLE1BQXpCLElBQW1DLEtBQUssU0FBUyxNQUFkLE1BQTBCLEdBQWpFLEVBQ0UsWUFBWSxLQUFaOztBQUVGLE1BQUksU0FBSixFQUFlO0FBQ2IsUUFBSSxjQUFjLFNBQVMsS0FBVCxDQUFlLEdBQWYsQ0FBbEI7QUFDQSxRQUFJLFlBQVksTUFBWixHQUFxQixDQUF6QixFQUNFLFlBQVksR0FBWjs7QUFFRixlQUFXLFlBQVksSUFBWixDQUFpQixHQUFqQixDQUFYO0FBQ0EsZ0JBQVksS0FBSyxHQUFMLENBQVMsV0FBVCxDQUFxQixRQUFyQixFQUErQixLQUEzQztBQUNEOztBQUVELFNBQU87QUFDTCxVQUFNLFFBREQsRUFDVyxPQUFPO0FBRGxCLEdBQVA7QUFHRCxDQXRERDs7QUF3REEsVUFBVSxTQUFWLENBQW9CLFNBQXBCLEdBQWdDLFNBQVMsUUFBVCxHQUFvQjtBQUNsRDtBQUNBLE1BQUksT0FBTyxJQUFJLE1BQUosQ0FBVyx1QkFBVyxPQUFPLEtBQUssSUFBWixDQUFYLENBQVgsQ0FBWDtBQUNBLE1BQUksUUFBUSxFQUFaO0FBQ0EsTUFBSSxPQUFPLEtBQUssR0FBTCxDQUFTLElBQXBCLENBSmtELENBSXhCO0FBQzFCLE1BQUksU0FBUyxDQUFiO0FBQ0EsTUFBSSxRQUFRLENBQVo7O0FBRUEsT0FBSyxHQUFMLENBQVMsSUFBVCxHQUFnQixLQUFLLGNBQUwsRUFBaEI7O0FBRUEsU0FBTyxLQUFLLE1BQUwsR0FBYyxDQUFyQixFQUF3Qjs7QUFFdEIsUUFBSSxXQUFXLEtBQUssUUFBTCxHQUFnQixLQUFLLE9BQUwsR0FBZSxDQUE5QztBQUNBLFFBQUksWUFBWSxLQUFLLFNBQUwsR0FBaUIsS0FBSyxPQUFMLEdBQWUsQ0FBaEQ7O0FBRUEsUUFBSSxPQUFPLEtBQUssaUJBQUwsQ0FBdUIsSUFBdkIsRUFBNkIsUUFBN0IsRUFBdUMsS0FBdkMsQ0FBWDtBQUNBLFNBQUssTUFBTCxHQUFjLEtBQUssV0FBbkI7O0FBRUEsVUFBTSxJQUFOLENBQVcsSUFBWDs7QUFFQSxZQUFRLEtBQUssR0FBTCxDQUFTLEtBQVQsRUFBZ0IsS0FBSyxLQUFyQixDQUFSO0FBQ0EsY0FBVSxLQUFLLE1BQWY7QUFDQSxXQUFPLHVCQUFXLEtBQUssS0FBTCxDQUFXLEtBQUssSUFBTCxDQUFVLE1BQXJCLEVBQTZCLEtBQUssTUFBbEMsQ0FBWCxDQUFQOztBQUVBLFFBQUksYUFBYSxTQUFTLFNBQTFCLEVBQXFDO0FBQ25DLFVBQUksT0FBTyxNQUFNLEdBQU4sRUFBWDtBQUNBLGdCQUFVLEtBQUssTUFBZjtBQUNEO0FBQ0Y7O0FBRUQsT0FBSyxZQUFMLEdBQW9CO0FBQ2xCLFdBQU8sS0FEVyxFQUNKLE9BQU8sS0FESCxFQUNVLFFBQVE7QUFEbEIsR0FBcEI7QUFHQSxPQUFLLEtBQUwsR0FBYSxRQUFRLEtBQUssT0FBTCxHQUFlLENBQXBDO0FBQ0EsT0FBSyxNQUFMLEdBQWMsU0FBUyxLQUFLLE9BQUwsR0FBZSxDQUF0Qzs7QUFFQSxPQUFLLEdBQUwsQ0FBUyxJQUFULEdBQWdCLElBQWhCLENBcENrRCxDQW9DNUI7QUFDdkIsQ0FyQ0Q7O0FBdUNBLFVBQVUsU0FBVixDQUFvQixjQUFwQixHQUFxQyxZQUFZO0FBQy9DO0FBQ0EsU0FBTywwQkFBYyxFQUFkLEVBQWtCLElBQWxCLEVBQXdCLElBQXhCLENBQVA7QUFDRCxDQUhEOztrQkFLZSxTOzs7Ozs7Ozs7QUNqTWY7Ozs7QUFDQTs7OztBQUNBOzs7O0FBRUEsU0FBUyxLQUFULENBQWUsS0FBZixFQUFzQixPQUF0QixFQUErQjtBQUM5QixPQUFNLElBQU4sQ0FBVyxXQUFYLENBQXVCLElBQXZCLENBQTRCLElBQTVCLEVBQWtDLE9BQWxDLEVBQTJDLE9BQTNDLEVBQW9ELE1BQU0sS0FBMUQ7O0FBRUEsTUFBSyxLQUFMLEdBQWEsS0FBYjtBQUNBLE1BQUssTUFBTCxHQUFjLE1BQU0sTUFBcEI7QUFDQSxNQUFLLEdBQUwsR0FBVyxLQUFLLEtBQUwsQ0FBVyxHQUF0Qjs7QUFHQSxLQUFJLE9BQVEsS0FBSyxRQUFMLENBQWMsUUFBdEIsS0FBb0MsV0FBeEMsRUFBcUQ7O0FBRXBELE9BQUssUUFBTCxHQUFnQixLQUFLLEtBQUwsQ0FBVyxlQUFYLENBQTJCLEtBQUssUUFBaEMsQ0FBaEI7O0FBRUE7QUFDQTs7QUFFRCxNQUFLLEtBQUwsR0FBYSxJQUFiLEVBQWtCO0FBQ2xCLE1BQUssTUFBTCxHQUFjLElBRGQsQ0FmOEIsQ0FnQlo7QUFDbEIsTUFBSyxNQUFMLEdBQWM7QUFDYixNQUFJLElBRFMsRUFDSCxJQUFJLElBREQsRUFDTyxJQUFJLElBRFgsRUFDaUIsSUFBSTtBQURyQixFQUFkO0FBR0E7O0FBRUQsbUJBQU8sS0FBUCxFQUFjLGtCQUFkOztBQUVBLE1BQU0sU0FBTixDQUFnQixNQUFoQixHQUF5QixZQUFZOztBQUVwQyxLQUFJLENBQUMsS0FBSyxJQUFWLEVBQWdCOztBQUVoQixLQUFJLFlBQWEsQ0FBQyxLQUFLLGtCQUFOLEdBQTJCLEtBQUssS0FBaEMsR0FBd0MsS0FBSyxLQUFMLENBQVcsUUFBcEU7QUFDQSxLQUFJLFlBQVksVUFBVSxhQUFWLENBQXdCLFlBQXhCLEVBQWhCO0FBQ0EsS0FBSSxPQUFPLFVBQVUsRUFBckI7QUFDQSxLQUFJLE1BQU0sVUFBVSxFQUFwQjtBQUNBLEtBQUksUUFBUSxDQUFaO0FBQ0EsS0FBSSxZQUFZLENBQWhCO0FBQ0EsS0FBSSxrQkFBa0IsQ0FBdEIsQ0FWb0MsQ0FVWDtBQUN6QixLQUFJLGNBQWMsS0FBSyxLQUFMLENBQVcsV0FBWCxJQUEwQixLQUFLLEtBQUwsQ0FBVyxhQUFyQyxJQUFzRCxLQUFLLGFBQUwsS0FBdUIsS0FBN0UsR0FBcUYsRUFBckYsR0FBMEYsQ0FBNUcsQ0FYb0MsQ0FXMkU7O0FBRS9HLEtBQUksd0JBQUo7QUFDQSxLQUFJLFFBQUo7O0FBRUEsS0FBSSxLQUFLLGFBQUwsS0FBdUIsS0FBdkIsSUFBZ0MsS0FBSyxhQUFMLEtBQXVCLFFBQTNELEVBQXFFO0FBQ3BFLE1BQUksS0FBSyxRQUFMLEtBQWtCLElBQXRCLEVBQ0MsS0FBSyxRQUFMLEdBQWdCLFVBQVUsS0FBVixHQUFrQixrQkFBa0IsQ0FBcEMsR0FBd0MsZUFBZSxLQUFLLGVBQUwsS0FBeUIsUUFBekIsR0FBb0MsQ0FBcEMsR0FBd0MsQ0FBdkQsQ0FBeEQ7O0FBRUQsY0FBWSxVQUFVLE1BQVYsR0FBbUIsRUFBbkIsR0FBd0IsS0FBSyxNQUE3QixHQUFzQyxlQUFsRDtBQUNBLFVBQVEsQ0FBUjtBQUNBLEVBTkQsTUFPSyxJQUFJLEtBQUssYUFBTCxLQUF1QixRQUEzQixFQUFxQzs7QUFFekMsTUFBSSxLQUFLLGVBQUwsS0FBeUIsTUFBekIsSUFBbUMsS0FBSyxlQUFMLEtBQXlCLE9BQWhFLEVBQXlFO0FBQ3hFLE9BQUksS0FBSyxRQUFMLEtBQWtCLElBQXRCLEVBQ0MsS0FBSyxRQUFMLEdBQWdCLFVBQVUsTUFBVixHQUFtQixrQkFBa0IsQ0FBckQ7O0FBRUQsZUFBWSxVQUFVLEtBQVYsR0FBa0IsRUFBbEIsR0FBdUIsS0FBSyxNQUE1QixHQUFxQyxlQUFqRDtBQUNBLEdBTEQsTUFLTyxJQUFJLEtBQUssZUFBTCxLQUF5QixRQUE3QixFQUF1QztBQUM3QyxPQUFJLEtBQUssUUFBTCxLQUFrQixJQUF0QixFQUNDLEtBQUssUUFBTCxHQUFnQixVQUFVLEtBQVYsR0FBa0Isa0JBQWtCLENBQXBEOztBQUVELGVBQVksVUFBVSxNQUFWLEdBQW1CLEVBQW5CLEdBQXdCLGtCQUFrQixDQUF0RDtBQUNBO0FBQ0Q7O0FBRUQsS0FBSSxDQUFDLEtBQUssSUFBVixFQUNDLFlBQVksS0FBSyxHQUFMLENBQVMsU0FBVCxFQUFvQixLQUFLLEdBQUwsQ0FBUyxLQUFLLFFBQUwsR0FBZ0IsR0FBekIsRUFBOEIsS0FBSyxRQUFMLEdBQWdCLEtBQUssT0FBTCxHQUFlLEdBQTdELENBQXBCLENBQVo7QUFDRDs7QUFFQSxLQUFJLFlBQVksSUFBSSxvQkFBSixDQUFjLEtBQUssR0FBbkIsRUFBd0I7QUFDdkMsWUFBVSxLQUFLLFFBRHdCLEVBQ2QsWUFBWSxLQUFLLFVBREgsRUFDZSxXQUFXLEtBQUssU0FEL0I7QUFFdkMsYUFBVyxLQUFLLFNBRnVCLEVBRVosWUFBWSxLQUFLLFVBRkw7QUFHdkMsbUJBQWlCLEtBQUssZUFIaUIsRUFHQSxlQUFlLEtBQUssYUFIcEI7QUFJdkMsZUFBYSxLQUFLLFdBSnFCLEVBSVIsaUJBQWlCLEtBQUssZUFKZDtBQUt2QyxtQkFBaUIsS0FBSyxlQUxpQjtBQU12QyxZQUFVLEtBQUssUUFOd0IsRUFNZCxXQUFXLFNBTkc7QUFPdkMsZ0JBQWMsS0FBSyxZQVBvQjtBQVF2QyxRQUFNLEtBQUssSUFSNEI7QUFTdkMsV0FBUyxLQUFLLE9BVHlCO0FBVXZDLGdCQUFjO0FBVnlCLEVBQXhCLENBQWhCOztBQWFBLEtBQUksZ0JBQWdCLFVBQVUsV0FBVixFQUFwQjs7QUFFQSxLQUFJLEtBQUssYUFBTCxLQUF1QixLQUF2QixJQUFnQyxLQUFLLGFBQUwsS0FBdUIsUUFBM0QsRUFBcUU7O0FBRXBFLE1BQUksS0FBSyxhQUFMLEtBQXVCLEtBQTNCLEVBQWtDO0FBQ2pDLFNBQU0sVUFBVSxFQUFWLEdBQWUsZUFBckI7QUFDQSxjQUFXLEtBQVg7QUFDQSxHQUhELE1BSUssSUFBSSxLQUFLLGFBQUwsS0FBdUIsUUFBM0IsRUFBcUM7QUFDekMsU0FBTSxVQUFVLEVBQVYsR0FBZSxlQUFmLEdBQWlDLGNBQWMsTUFBckQ7QUFDQSxjQUFXLFFBQVg7QUFDQTs7QUFFRCxNQUFJLEtBQUssZUFBTCxLQUF5QixNQUE3QixFQUFxQztBQUNwQyxVQUFPLFVBQVUsRUFBVixHQUFlLGVBQXRCO0FBQ0EsR0FGRCxNQUdLLElBQUksS0FBSyxlQUFMLEtBQXlCLFFBQTdCLEVBQXVDO0FBQzNDLFVBQU8sVUFBVSxFQUFWLEdBQWUsVUFBVSxLQUFWLEdBQWtCLENBQWpDLEdBQXFDLGNBQWMsS0FBZCxHQUFzQixDQUFsRTtBQUNBLEdBRkksTUFHQSxJQUFJLEtBQUssZUFBTCxLQUF5QixPQUE3QixFQUFzQztBQUMxQyxVQUFPLFVBQVUsRUFBVixHQUFlLGVBQWYsR0FBaUMsY0FBYyxLQUEvQyxHQUF1RCxXQUE5RDtBQUNBOztBQUVELDZCQUEyQixLQUFLLGVBQWhDOztBQUVBLE9BQUssS0FBTCxHQUFhLGNBQWMsS0FBM0I7QUFDQSxPQUFLLE1BQUwsR0FBYyxjQUFjLE1BQTVCO0FBQ0EsRUF6QkQsTUEwQkssSUFBSSxLQUFLLGFBQUwsS0FBdUIsUUFBM0IsRUFBcUM7O0FBRXpDLE1BQUksS0FBSyxlQUFMLEtBQXlCLE1BQTdCLEVBQXFDOztBQUVwQyxVQUFPLFVBQVUsRUFBVixHQUFlLGVBQXRCO0FBQ0EsU0FBTSxVQUFVLEVBQVYsR0FBZSxlQUFmLElBQWtDLEtBQUssUUFBTCxHQUFnQixDQUFoQixHQUFvQixjQUFjLEtBQWQsR0FBc0IsQ0FBNUUsQ0FBTjtBQUNBLFdBQVEsQ0FBQyxFQUFUOztBQUVBLGNBQVcsTUFBWDtBQUNBLFFBQUssS0FBTCxHQUFhLGNBQWMsTUFBM0I7QUFDQSxRQUFLLE1BQUwsR0FBYyxjQUFjLEtBQTVCO0FBQ0EsR0FURCxNQVVLLElBQUksS0FBSyxlQUFMLEtBQXlCLE9BQTdCLEVBQXNDO0FBQzFDLFVBQU8sVUFBVSxFQUFWLEdBQWUsZUFBdEI7QUFDQSxTQUFNLFVBQVUsRUFBVixHQUFlLGVBQWYsSUFBa0MsS0FBSyxRQUFMLEdBQWdCLENBQWhCLEdBQW9CLGNBQWMsS0FBZCxHQUFzQixDQUE1RSxDQUFOO0FBQ0EsV0FBUSxFQUFSOztBQUVBLGNBQVcsT0FBWDtBQUNBLFFBQUssS0FBTCxHQUFhLGNBQWMsTUFBM0I7QUFDQSxRQUFLLE1BQUwsR0FBYyxjQUFjLEtBQTVCO0FBQ0EsR0FSSSxNQVNBLElBQUksS0FBSyxlQUFMLEtBQXlCLFFBQTdCLEVBQXVDO0FBQzNDLFNBQU0sVUFBVSxFQUFWLElBQWdCLFVBQVUsTUFBVixHQUFtQixDQUFuQixHQUF1QixjQUFjLE1BQWQsR0FBdUIsQ0FBOUQsQ0FBTjtBQUNBLFVBQU8sVUFBVSxFQUFWLElBQWdCLFVBQVUsS0FBVixHQUFrQixDQUFsQixHQUFzQixjQUFjLEtBQWQsR0FBc0IsQ0FBNUQsQ0FBUDs7QUFFQSxjQUFXLFFBQVg7QUFDQSxRQUFLLEtBQUwsR0FBYSxjQUFjLEtBQTNCO0FBQ0EsUUFBSyxNQUFMLEdBQWMsY0FBYyxNQUE1QjtBQUNBOztBQUVELDZCQUEyQixRQUEzQjtBQUNBOztBQUVELFdBQVUsQ0FBVixHQUFjLElBQWQ7QUFDQSxXQUFVLENBQVYsR0FBYyxHQUFkO0FBQ0EsV0FBVSxLQUFWLEdBQWtCLEtBQWxCO0FBQ0EsV0FBVSxlQUFWLEdBQTRCLHdCQUE1QjtBQUNBLFdBQVUsTUFBVixDQUFpQixJQUFqQjs7QUFFQSxXQUFVLGFBQVYsQ0FBd0IsYUFBeEIsQ0FBc0MsUUFBdEMsRUFBZ0Q7QUFDL0MsU0FBTyxLQUFLLEtBQUwsSUFBYyxhQUFhLE1BQWIsSUFBdUIsYUFBYSxPQUFwQyxHQUE4QyxLQUFLLE1BQUwsR0FBYyxlQUE1RCxHQUE4RSxDQUE1RixDQUR3QztBQUUvQyxVQUFRLEtBQUssTUFBTCxJQUFlLGFBQWEsS0FBYixJQUFzQixhQUFhLFFBQW5DLEdBQThDLEtBQUssTUFBTCxHQUFjLGVBQTVELEdBQThFLENBQTdGO0FBRnVDLEVBQWhEOztBQUtBLE1BQUssTUFBTCxHQUFjO0FBQ2IsTUFBSSxJQURTLEVBQ0gsSUFBSSxHQURELEVBQ00sSUFBSSxPQUFPLEtBQUssS0FEdEIsRUFDNkIsSUFBSSxNQUFNLEtBQUs7QUFENUMsRUFBZDs7QUFJQSxNQUFLLEdBQUwsQ0FBUyxZQUFULEdBQXdCLEtBQXhCO0FBQ0EsQ0FwSUQ7O2tCQXNJZSxLOzs7Ozs7Ozs7QUNsS2Y7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFFQSxTQUFTLE9BQVQsQ0FBaUIsS0FBakIsRUFBd0IsT0FBeEIsRUFBaUMsS0FBakMsRUFBd0M7O0FBRXRDLFVBQVEsSUFBUixDQUFhLFdBQWIsQ0FBeUIsSUFBekIsQ0FBOEIsSUFBOUIsRUFBb0MsU0FBcEMsRUFBK0MsT0FBL0MsRUFBd0QsS0FBeEQ7O0FBRUEsT0FBSyxLQUFMLEdBQWEsS0FBYjtBQUNBLE9BQUssTUFBTCxHQUFjLE1BQU0sTUFBcEI7QUFDQSxPQUFLLEdBQUwsR0FBVyxLQUFLLEtBQUwsQ0FBVyxHQUF0QjtBQUNBLE9BQUssa0JBQUwsR0FBMEIsQ0FBQyxDQUEzQjtBQUNBLE9BQUsscUJBQUwsR0FBNkIsQ0FBQyxDQUE5QjtBQUNBLE9BQUssUUFBTCxHQUFnQixDQUFoQjtBQUNBLE9BQUssTUFBTCxHQUFjLEdBQWQ7QUFDQSxPQUFLLE1BQUwsR0FBYyxHQUFkOztBQUVBLE9BQUssV0FBTDtBQUNEOztBQUVELG1CQUFPLE9BQVAsRUFBZ0Isa0JBQWhCOztBQUVBLFFBQVEsU0FBUixDQUFrQixXQUFsQixHQUFnQyxZQUFZOztBQUUxQyxNQUFJLEtBQUssT0FBVCxFQUFrQjtBQUNoQixTQUFLLFNBQUwsR0FBaUIsU0FBUyxhQUFULENBQXVCLEtBQXZCLENBQWpCO0FBQ0EsU0FBSyxTQUFMLENBQWUsWUFBZixDQUE0QixPQUE1QixFQUFxQyx3QkFBckM7QUFDQSxTQUFLLFNBQUwsQ0FBZSxLQUFmLENBQXFCLFFBQXJCLEdBQWdDLFVBQWhDO0FBQ0EsU0FBSyxTQUFMLENBQWUsS0FBZixDQUFxQixNQUFyQixHQUE4QixNQUE5QjtBQUNBLFNBQUssU0FBTCxDQUFlLEtBQWYsQ0FBcUIsU0FBckIsR0FBaUMsaUNBQWpDO0FBQ0EsU0FBSyxTQUFMLENBQWUsS0FBZixDQUFxQixNQUFyQixHQUE4QixNQUE5QjtBQUNBO0FBQ0EsU0FBSyxTQUFMLENBQWUsS0FBZixDQUFxQixPQUFyQixHQUErQixNQUEvQjtBQUNBOztBQUVBLFFBQUksY0FBYyw0QkFBbEI7QUFDQSxtQkFBZSxlQUFmO0FBQ0EsbUJBQWUsa0JBQWY7QUFDQSxtQkFBZSxvQkFBZjtBQUNBLG1CQUFlLDBCQUFmO0FBQ0EsbUJBQWUsZUFBZjtBQUNBLG1CQUFlLDhDQUFmO0FBQ0EsbUJBQWUsc0JBQWY7QUFDQSxtQkFBZSxrQkFBa0IsMkJBQW9CLFNBQXBCLEdBQWdDLFNBQWxELENBQWY7QUFDQSxtQkFBZSxrQkFBZjtBQUNBLG1CQUFlLGlCQUFmO0FBQ0EsbUJBQWUsOENBQWY7QUFDQSxtQkFBZSxtQkFBZjtBQUNBLG1CQUFlLHlCQUFmOztBQUVBO0FBQ0EsbUJBQWUsMkJBQW9CLG1DQUFwQixHQUEwRCwrQkFBekU7O0FBRUEsbUJBQWUsbUJBQWY7QUFDQSxtQkFBZSxzQkFBZjtBQUNBO0FBQ0EsbUJBQWUscUJBQWY7O0FBRUE7QUFDQSxtQkFBZSx3QkFBZjtBQUNBLG1CQUFlLDJCQUFmO0FBQ0EsbUJBQWUsNEJBQWY7QUFDQSxtQkFBZSx3QkFBZjtBQUNBLG1CQUFlLG9CQUFmOztBQUVBO0FBQ0E7O0FBRUEsUUFBSSxDQUFDLHdCQUFMLEVBQXdCO0FBQ3RCO0FBQ0E7QUFDQTtBQUNBLHFCQUFlLDhCQUFmO0FBQ0EscUJBQWUsK0ZBQWY7QUFDRDs7QUFFRCxtQkFBZSw0QkFBZjs7QUFFQSxTQUFLLFNBQUwsQ0FBZSxTQUFmLEdBQTJCLFdBQTNCO0FBQ0EsU0FBSyxVQUFMLEdBQWtCLEtBQUssU0FBTCxDQUFlLFVBQWpDOztBQUdBLFNBQUssU0FBTCxDQUFlLEtBQWYsQ0FBcUIsWUFBckIsR0FBb0MsS0FBSyxVQUFMLENBQWdCLEtBQWhCLENBQXNCLFlBQTFEO0FBQ0EsU0FBSyxLQUFMLENBQVcsa0JBQVgsQ0FBOEIsV0FBOUIsQ0FBMEMsS0FBSyxTQUEvQztBQUNEO0FBQ0YsQ0EvREQ7O0FBaUVBLFFBQVEsU0FBUixDQUFrQixnQkFBbEIsR0FBcUMsVUFBVSxDQUFWLEVBQWEsQ0FBYixFQUFnQjs7QUFFbkQsTUFBSSxFQUFFLEtBQUssWUFBTCxJQUFzQixJQUFJLElBQUosR0FBVyxPQUFYLEtBQXVCLEtBQUssWUFBN0IsR0FBNkMsRUFBcEUsQ0FBSixFQUE2RTtBQUMzRSxTQUFLLFlBQUwsR0FBb0IsSUFBSSxJQUFKLEdBQVcsT0FBWCxFQUFwQjtBQUNBLFNBQUssY0FBTCxDQUFvQixDQUFwQixFQUF1QixDQUF2QjtBQUNEO0FBQ0YsQ0FORDs7QUFRQSxRQUFRLFNBQVIsQ0FBa0IsY0FBbEIsR0FBbUMsVUFBVSxNQUFWLEVBQWtCLE1BQWxCLEVBQTBCO0FBQzNEOztBQUVBLE1BQUksS0FBSyxLQUFMLENBQVcsY0FBZixFQUErQjtBQUM3Qjs7QUFFRixNQUFJLE9BQVEsTUFBUixLQUFvQixXQUFwQixJQUFtQyxPQUFRLE1BQVIsS0FBb0IsV0FBM0QsRUFBd0U7QUFDdEUsUUFBSSxNQUFNLEtBQUssTUFBWCxLQUFzQixNQUFNLEtBQUssTUFBWCxDQUExQixFQUNFLE9BREYsS0FFSztBQUNILGVBQVMsS0FBSyxNQUFkO0FBQ0EsZUFBUyxLQUFLLE1BQWQ7QUFDRDtBQUNGLEdBUEQsTUFPTztBQUNMLFNBQUssTUFBTCxHQUFjLE1BQWQ7QUFDQSxTQUFLLE1BQUwsR0FBYyxNQUFkO0FBQ0Q7O0FBR0QsTUFBSSxZQUFZLElBQWhCO0FBQ0EsTUFBSSxhQUFhLElBQWpCO0FBQ0EsTUFBSSxpQkFBaUIsRUFBckI7QUFDQSxNQUFJLFVBQVUsRUFBZDtBQUNBLE1BQUksWUFBSjtBQUNBLE1BQUksYUFBSjtBQUNBLE1BQUksSUFBSSxDQUFSOztBQUVBLE1BQUksS0FBSyxNQUFMLElBQWUsS0FBSyxPQUFwQixJQUErQixLQUFLLEtBQUwsQ0FBVyxRQUFYLENBQW9CLGFBQXBCLEtBQXNDLE1BQXpFLEVBQWlGO0FBQy9FO0FBQ0EsUUFBSSxLQUFLLEtBQUwsQ0FBVyxRQUFYLENBQW9CLGFBQXBCLEtBQXNDLFdBQTFDLEVBQXVEO0FBQ3JELFVBQUksQ0FBQyxLQUFLLEtBQUwsQ0FBVyxLQUFYLENBQWlCLGVBQWpCLEdBQW1DLEtBQUssS0FBTCxDQUFXLEtBQVgsQ0FBaUIsZUFBckQsSUFBd0UsS0FBSyxLQUFMLENBQVcsS0FBWCxDQUFpQixlQUFqQixDQUFpQyxNQUF6RyxJQUFvSCxLQUFLLEtBQUwsQ0FBVyxLQUFYLENBQWlCLGVBQWpCLENBQWlDLEVBQWpDLEdBQXNDLE1BQTFKLElBQXFLLEtBQUssS0FBTCxDQUFXLEtBQVgsQ0FBaUIsZUFBMUw7QUFDRCxLQUZELE1BR0s7QUFDSCxVQUFJLENBQUMsS0FBSyxLQUFMLENBQVcsS0FBWCxDQUFpQixlQUFqQixHQUFtQyxLQUFLLEtBQUwsQ0FBVyxLQUFYLENBQWlCLGVBQXJELElBQXdFLEtBQUssS0FBTCxDQUFXLEtBQVgsQ0FBaUIsZUFBakIsQ0FBaUMsS0FBekcsSUFBa0gsU0FBUyxLQUFLLEtBQUwsQ0FBVyxLQUFYLENBQWlCLGVBQWpCLENBQWlDLEVBQTVKLElBQWtLLEtBQUssS0FBTCxDQUFXLEtBQVgsQ0FBaUIsZUFBdkw7QUFDRDs7QUFFRCxRQUFJLGdCQUFnQixFQUFwQjs7QUFFQSxTQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksS0FBSyxLQUFMLENBQVcsSUFBWCxDQUFnQixNQUFwQyxFQUE0QyxHQUE1QyxFQUFpRDtBQUMvQyxVQUFJLFFBQVEsS0FBSyxLQUFMLENBQVcsSUFBWCxDQUFnQixDQUFoQixFQUFtQixlQUFuQixDQUFtQyxDQUFuQyxFQUFzQyxJQUF0QyxDQUFaOztBQUVBLFVBQUksU0FBUyxNQUFNLEtBQU4sSUFBZSxDQUE1QixFQUErQjtBQUM3QixjQUFNLFVBQU4sR0FBbUIsS0FBSyxLQUFMLENBQVcsSUFBWCxDQUFnQixDQUFoQixDQUFuQjs7QUFFQSxZQUFJLE1BQU0sU0FBTixDQUFnQixDQUFoQixLQUFzQixJQUExQixFQUNFLGNBQWMsSUFBZCxDQUFtQixLQUFuQjtBQUNIO0FBQ0Y7O0FBRUQsUUFBSSxjQUFjLE1BQWQsS0FBeUIsQ0FBN0IsRUFDRTs7QUFFRixrQkFBYyxJQUFkLENBQW1CLFVBQVUsTUFBVixFQUFrQixNQUFsQixFQUEwQjtBQUMzQyxhQUFPLE9BQU8sUUFBUCxHQUFrQixPQUFPLFFBQWhDO0FBQ0QsS0FGRDs7QUFJQSxRQUFJLFVBQVUsY0FBYyxDQUFkLENBQWQ7O0FBRUEsU0FBSyxJQUFJLENBQVQsRUFBWSxJQUFJLGNBQWMsTUFBOUIsRUFBc0MsR0FBdEMsRUFBMkM7O0FBRXpDLFVBQUksY0FBYyxDQUFkLEVBQWlCLFNBQWpCLENBQTJCLENBQTNCLENBQTZCLE9BQTdCLE9BQTJDLFFBQVEsU0FBUixDQUFrQixDQUFsQixDQUFvQixPQUFwQixFQUEvQyxFQUNFLFFBQVEsSUFBUixDQUFhLGNBQWMsQ0FBZCxDQUFiO0FBQ0g7O0FBRUQsb0JBQWdCLElBQWhCO0FBRUQsR0F2Q0QsTUF1Q087O0FBRUwsUUFBSSxnQkFBZ0IsS0FBSyxLQUFMLENBQVcsZ0JBQVgsQ0FBNEIsTUFBNUIsRUFBb0MsTUFBcEMsRUFBNEMsSUFBNUMsQ0FBcEI7QUFDQTs7QUFFQSxRQUFJLGFBQUosRUFBbUI7QUFDakIsV0FBSyxxQkFBTCxHQUE2QixjQUFjLGNBQTNDO0FBQ0EsV0FBSyxrQkFBTCxHQUEwQixjQUFjLFVBQWQsQ0FBeUIsS0FBbkQ7QUFDRCxLQUhELE1BR08sSUFBSSx3QkFBSixFQUF1Qjs7QUFFNUIsVUFBSSxLQUFLLHdCQUFZLE1BQVosRUFBb0IsTUFBcEIsRUFBNEIsS0FBSyxLQUFMLENBQVcsYUFBWCxDQUF5QixRQUFyRCxDQUFUO0FBQ0EsVUFBSSxLQUFLLENBQUwsSUFBVSxPQUFPLEtBQUssS0FBTCxDQUFXLGFBQVgsQ0FBeUIsU0FBekIsQ0FBbUMsRUFBbkMsQ0FBUCxLQUFrRCxXQUFoRSxFQUE2RTtBQUFDO0FBQzVFLFlBQUksY0FBYyxLQUFLLEtBQUwsQ0FBVyxhQUFYLENBQXlCLFNBQXpCLENBQW1DLEVBQW5DLENBQWxCOztBQUVBLFlBQUksWUFBWSxVQUFaLEtBQTJCLFlBQS9CLEVBQ0U7O0FBRUY7QUFDQTtBQUNBO0FBQ0EsYUFBSyxrQkFBTCxHQUEwQixZQUFZLGVBQXRDO0FBQ0EsYUFBSyxxQkFBTCxHQUE2QixZQUFZLGNBQVosSUFBOEIsQ0FBOUIsR0FBa0MsWUFBWSxjQUE5QyxHQUErRCxDQUFDLENBQTdGO0FBQ0E7O0FBRUE7QUFDRCxPQWRELE1BZUUsS0FBSyxxQkFBTCxHQUE2QixDQUFDLENBQTlCO0FBRUgsS0FwQk0sTUFxQkwsS0FBSyxxQkFBTCxHQUE2QixDQUFDLENBQTlCOztBQUdGLFFBQUksS0FBSyxrQkFBTCxJQUEyQixDQUEvQixFQUFrQzs7QUFFaEMsbUJBQWEsS0FBSyxLQUFMLENBQVcsSUFBWCxDQUFnQixLQUFLLGtCQUFyQixDQUFiOztBQUVBLFVBQUksUUFBUSxFQUFaOztBQUdBLFVBQUksS0FBSyxxQkFBTCxJQUE4QixDQUFsQyxFQUFxQztBQUNuQyxvQkFBWSxXQUFXLFVBQVgsQ0FBc0IsS0FBSyxxQkFBM0IsQ0FBWjs7QUFFQSxjQUFNLFVBQU4sR0FBbUIsVUFBbkI7QUFDQSxjQUFNLFNBQU4sR0FBa0IsU0FBbEI7QUFDQSxjQUFNLEtBQU4sR0FBYyxLQUFLLHFCQUFuQjtBQUNBLGNBQU0sUUFBTixHQUFpQixLQUFLLEdBQUwsQ0FBUyxVQUFVLENBQVYsR0FBYyxDQUF2QixDQUFqQjtBQUNELE9BUEQsTUFPTyxJQUFJLEtBQUssT0FBTCxLQUFpQixXQUFXLElBQVgsS0FBb0IsTUFBcEIsSUFBOEIsV0FBVyxJQUFYLEtBQW9CLFVBQWxELElBQWdFLFdBQVcsSUFBWCxLQUFvQixRQUFwRixJQUFnRyxXQUFXLElBQVgsS0FBb0IsTUFBcEgsSUFBOEgsV0FBVyxJQUFYLEtBQW9CLFVBQWxKLElBQ3JCLFdBQVcsSUFBWCxLQUFvQixZQURDLElBQ2UsV0FBVyxJQUFYLEtBQW9CLGFBRG5DLElBQ29ELFdBQVcsSUFBWCxLQUFvQixnQkFEeEUsSUFFckIsV0FBVyxJQUFYLEtBQW9CLFdBRkMsSUFFYyxXQUFXLElBQVgsS0FBb0IsaUJBRmxDLElBR3JCLFdBQVcsSUFBWCxLQUFvQixhQUhDLElBR2dCLFdBQVcsSUFBWCxLQUFvQixNQUhyRCxDQUFKLEVBR2tFOztBQUV2RTtBQUNBLFlBQUksSUFBSSxXQUFXLEtBQVgsQ0FBaUIsb0JBQWpCLENBQXNDLE9BQXRDLEdBQWdELENBQUMsU0FBUyxXQUFXLEtBQVgsQ0FBaUIsb0JBQWpCLENBQXNDLFNBQWhELElBQTZELFdBQVcsS0FBWCxDQUFpQixvQkFBakIsQ0FBc0MsWUFBM0o7O0FBR0EsZ0JBQVEsV0FBVyxlQUFYLENBQTJCLENBQTNCLEVBQThCLElBQTlCLENBQVI7QUFDQSxjQUFNLFVBQU4sR0FBbUIsVUFBbkI7QUFDQSxhQUFLLHFCQUFMLEdBQTZCLE1BQU0sS0FBbkM7QUFDQSxvQkFBWSxNQUFNLFNBQWxCO0FBQ0QsT0FiTSxNQWFBO0FBQ0w7QUFDQTtBQUNEOztBQUVELFVBQUksTUFBTSxTQUFOLENBQWdCLENBQWhCLEtBQXNCLElBQTFCLEVBQWdDO0FBQzlCLFlBQUksTUFBTSxVQUFOLENBQWlCLEtBQXJCLEVBQTRCO0FBQzFCLGNBQUksTUFBTSxTQUFOLENBQWdCLENBQWhCLENBQWtCLE1BQWxCLEdBQTJCLENBQS9CLEVBQWtDO0FBQ2hDLGdCQUFJLG9CQUFvQixDQUF4QjtBQUNBLGlCQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksTUFBTSxTQUFOLENBQWdCLENBQWhCLENBQWtCLE1BQXRDLEVBQThDLEdBQTlDO0FBQ0Usa0JBQUksTUFBTSxTQUFOLENBQWdCLENBQWhCLENBQWtCLENBQWxCLElBQXVCLE1BQU0sVUFBTixDQUFpQixLQUFqQixDQUF1QixlQUFsRCxFQUNFLG9CQURGLEtBRUssSUFBSSxNQUFNLFNBQU4sQ0FBZ0IsQ0FBaEIsQ0FBa0IsQ0FBbEIsSUFBdUIsTUFBTSxVQUFOLENBQWlCLEtBQWpCLENBQXVCLGVBQWxELEVBQ0g7QUFKSixhQUtBLElBQUksb0JBQW9CLE1BQU0sU0FBTixDQUFnQixDQUFoQixDQUFrQixNQUF0QyxJQUFnRCxvQkFBb0IsQ0FBQyxNQUFNLFNBQU4sQ0FBZ0IsQ0FBaEIsQ0FBa0IsTUFBM0YsRUFDRSxRQUFRLElBQVIsQ0FBYSxLQUFiO0FBQ0gsV0FURCxNQVNPO0FBQ0wsZ0JBQUksTUFBTSxTQUFOLENBQWdCLENBQWhCLElBQXFCLE1BQU0sVUFBTixDQUFpQixLQUFqQixDQUF1QixlQUE1QyxJQUErRCxNQUFNLFNBQU4sQ0FBZ0IsQ0FBaEIsSUFBcUIsTUFBTSxVQUFOLENBQWlCLEtBQWpCLENBQXVCLGVBQS9HLEVBQ0UsUUFBUSxJQUFSLENBQWEsS0FBYjtBQUNIO0FBQ0YsU0FkRCxNQWVBLFFBQVEsSUFBUixDQUFhLEtBQWI7QUFDSDtBQUVBO0FBQ0Y7O0FBR0QsTUFBSSxRQUFRLE1BQVIsR0FBaUIsQ0FBckIsRUFBd0I7O0FBRXRCLFNBQUssZ0JBQUwsQ0FBc0IsT0FBdEI7O0FBRUEsUUFBSSxLQUFLLE9BQVQsRUFBa0I7O0FBRWhCLFVBQUksbUJBQW1CLEVBQXZCOztBQUVBLHlCQUFtQixLQUFLLG1CQUFMLENBQXlCLEVBQUUsU0FBUyxPQUFYLEVBQXpCLENBQW5COztBQUVBLFVBQUkscUJBQXFCLElBQXpCLEVBQStCO0FBQzdCLGFBQUssVUFBTCxDQUFnQixTQUFoQixHQUE0QixnQkFBNUI7O0FBRUEsYUFBSyxVQUFMLENBQWdCLFNBQWhCLEdBQTRCLGdCQUE1Qjs7QUFFQSxZQUFJLG1CQUFtQixLQUF2QjtBQUNBLFlBQUksS0FBSyxTQUFMLENBQWUsS0FBZixDQUFxQixPQUFyQixLQUFpQyxNQUFyQyxFQUE2QztBQUMzQyw2QkFBbUIsSUFBbkI7QUFDQSxlQUFLLFNBQUwsQ0FBZSxLQUFmLENBQXFCLE9BQXJCLEdBQStCLE9BQS9CO0FBQ0Q7O0FBRUQsWUFBSTtBQUNGLGVBQUssVUFBTCxDQUFnQixLQUFoQixDQUFzQixVQUF0QixHQUFtQyxLQUFLLGVBQUwsR0FBdUIsS0FBSyxlQUE1QixHQUE4QywyQkFBb0Isc0JBQXBCLEdBQTZDLGtCQUE5SDs7QUFFQSxlQUFLLFVBQUwsQ0FBZ0IsS0FBaEIsQ0FBc0IsZ0JBQXRCLEdBQXlDLEtBQUssVUFBTCxDQUFnQixLQUFoQixDQUFzQixlQUF0QixHQUF3QyxLQUFLLFVBQUwsQ0FBZ0IsS0FBaEIsQ0FBc0IsV0FBdEIsR0FBb0MsS0FBSyxXQUFMLEdBQW1CLEtBQUssV0FBeEIsR0FBc0MsUUFBUSxDQUFSLEVBQVcsU0FBWCxDQUFxQixLQUFyQixHQUE2QixRQUFRLENBQVIsRUFBVyxTQUFYLENBQXFCLEtBQWxELEdBQTBELFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsS0FBdEIsR0FBOEIsUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixLQUFwRCxHQUE0RCxRQUFRLENBQVIsRUFBVyxVQUFYLENBQXNCLFNBQXRCLENBQWdDLFFBQVEsQ0FBUixFQUFXLEtBQVgsR0FBbUIsUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixTQUF0QixDQUFnQyxNQUFuRixDQUFqUjs7QUFFQSxlQUFLLFVBQUwsQ0FBZ0IsS0FBaEIsQ0FBc0IsV0FBdEIsR0FBcUMsS0FBSyxlQUFMLElBQXdCLEtBQUssZUFBTCxLQUF5QixDQUFsRCxHQUF1RCxLQUFLLGVBQUwsR0FBdUIsSUFBOUUsR0FBcUYsSUFBSSxJQUE3SDs7QUFFQSxlQUFLLFVBQUwsQ0FBZ0IsS0FBaEIsQ0FBc0IsWUFBdEIsR0FBc0MsS0FBSyxZQUFMLElBQXFCLEtBQUssWUFBTCxLQUFzQixDQUE1QyxHQUFpRCxLQUFLLFlBQUwsR0FBb0IsSUFBckUsR0FBNEUsSUFBSSxJQUFySDtBQUNBLGVBQUssU0FBTCxDQUFlLEtBQWYsQ0FBcUIsWUFBckIsR0FBb0MsS0FBSyxVQUFMLENBQWdCLEtBQWhCLENBQXNCLFlBQTFEOztBQUdBLGVBQUssVUFBTCxDQUFnQixLQUFoQixDQUFzQixRQUF0QixHQUFrQyxLQUFLLFFBQUwsSUFBaUIsS0FBSyxRQUFMLEtBQWtCLENBQXBDLEdBQXlDLEtBQUssUUFBTCxHQUFnQixJQUF6RCxHQUFnRSxLQUFLLElBQXRHO0FBQ0EsZUFBSyxVQUFMLENBQWdCLEtBQWhCLENBQXNCLEtBQXRCLEdBQThCLEtBQUssU0FBTCxHQUFpQixLQUFLLFNBQXRCLEdBQWtDLFNBQWhFO0FBQ0EsZUFBSyxVQUFMLENBQWdCLEtBQWhCLENBQXNCLFVBQXRCLEdBQW1DLEtBQUssVUFBTCxHQUFrQixLQUFLLFVBQXZCLEdBQW9DLGlDQUF2RTtBQUNBLGVBQUssVUFBTCxDQUFnQixLQUFoQixDQUFzQixVQUF0QixHQUFtQyxLQUFLLFVBQUwsR0FBa0IsS0FBSyxVQUF2QixHQUFvQyxRQUF2RTtBQUNBLGVBQUssVUFBTCxDQUFnQixLQUFoQixDQUFzQixTQUF0QixHQUFrQyxLQUFLLFNBQUwsR0FBaUIsS0FBSyxTQUF0QixHQUFrQywyQkFBb0IsUUFBcEIsR0FBK0IsUUFBbkc7QUFFRCxTQWpCRCxDQWlCRSxPQUFPLENBQVAsRUFBVSxDQUNYOztBQUVELFlBQUksV0FBSjs7QUFFQSxZQUFJLFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsSUFBdEIsS0FBK0IsS0FBL0IsSUFBd0MsUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixJQUF0QixLQUErQixVQUF2RSxJQUFxRixRQUFRLENBQVIsRUFBVyxVQUFYLENBQXNCLElBQXRCLEtBQStCLFFBQXBILElBQWdJLFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsSUFBdEIsS0FBK0IsS0FBL0osSUFBd0ssUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixJQUF0QixLQUErQixVQUF2TSxJQUFxTixRQUFRLENBQVIsRUFBVyxVQUFYLENBQXNCLElBQXRCLEtBQStCLFlBQXBQLElBQW9RLFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsSUFBdEIsS0FBK0IsZUFBdlMsRUFBd1Q7QUFDdFQsd0JBQWMsU0FBUyxFQUFULEdBQWMsS0FBSyxTQUFMLENBQWUsV0FBM0M7QUFDRCxTQUZELE1BRU87QUFDTDtBQUNBLHdCQUFjLFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsS0FBdEIsQ0FBNEIsb0JBQTVCLENBQWlELFNBQWpELEdBQTZELFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsS0FBdEIsQ0FBNEIsb0JBQTVCLENBQWlELFlBQWpELElBQWlFLFFBQVEsQ0FBUixFQUFXLFNBQVgsQ0FBcUIsQ0FBckIsR0FBeUIsUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixLQUF0QixDQUE0QixvQkFBNUIsQ0FBaUQsT0FBM0ksQ0FBN0QsR0FBbU4sS0FBSyxTQUFMLENBQWUsV0FBbE8sSUFBaVAsQ0FBL1A7QUFDQSx5QkFBZSxFQUFmO0FBQ0Q7O0FBR0QsWUFBSSxjQUFjLENBQWxCLEVBQXFCO0FBQ25CLHlCQUFlLEtBQUssU0FBTCxDQUFlLFdBQWYsR0FBNkIsRUFBNUM7QUFDRDs7QUFFRCxZQUFJLGNBQWMsS0FBSyxTQUFMLENBQWUsV0FBN0IsR0FBMkMsS0FBSyxLQUFMLENBQVcsVUFBWCxDQUFzQixXQUFyRSxFQUNFLGNBQWMsS0FBSyxHQUFMLENBQVMsQ0FBVCxFQUFZLEtBQUssS0FBTCxDQUFXLFVBQVgsQ0FBc0IsV0FBdEIsR0FBb0MsS0FBSyxTQUFMLENBQWUsV0FBL0QsQ0FBZDs7QUFFRix1QkFBZSxJQUFmOztBQUVBLFlBQUksUUFBUSxNQUFSLEtBQW1CLENBQW5CLElBQXdCLENBQUMsS0FBSyxNQUE5QixLQUF5QyxRQUFRLENBQVIsRUFBVyxVQUFYLENBQXNCLElBQXRCLEtBQStCLE1BQS9CLElBQXlDLFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsSUFBdEIsS0FBK0IsVUFBeEUsSUFBc0YsUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixJQUF0QixLQUErQixRQUFySCxJQUFpSSxRQUFRLENBQVIsRUFBVyxVQUFYLENBQXNCLElBQXRCLEtBQStCLE1BQWhLLElBQTBLLFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsSUFBdEIsS0FBK0IsVUFBek0sSUFBdU4sUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixJQUF0QixLQUErQixZQUF0UCxJQUFzUSxRQUFRLENBQVIsRUFBVyxVQUFYLENBQXNCLElBQXRCLEtBQStCLGFBQXJTLElBQXNULFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsSUFBdEIsS0FBK0IsZ0JBQTlYLENBQUosRUFBcVo7QUFDblo7QUFDQSwwQkFBZ0IsUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixLQUF0QixDQUE0QixvQkFBNUIsQ0FBaUQsU0FBakQsR0FBNkQsUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixLQUF0QixDQUE0QixvQkFBNUIsQ0FBaUQsWUFBakQsSUFBaUUsUUFBUSxDQUFSLEVBQVcsU0FBWCxDQUFxQixDQUFyQixHQUF5QixRQUFRLENBQVIsRUFBVyxVQUFYLENBQXNCLEtBQXRCLENBQTRCLGVBQXRILENBQTdELEdBQXNNLEVBQXRNLElBQTRNLENBQTVOO0FBQ0QsU0FIRCxNQUdPLElBQUksUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixJQUF0QixLQUErQixLQUEvQixJQUF3QyxRQUFRLENBQVIsRUFBVyxVQUFYLENBQXNCLElBQXRCLEtBQStCLFVBQXZFLElBQXFGLFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsSUFBdEIsS0FBK0IsWUFBcEgsSUFBb0ksUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixJQUF0QixLQUErQixlQUF2SyxFQUF3TDtBQUM3TDtBQUNBLDBCQUFnQixRQUFRLENBQVIsRUFBVyxVQUFYLENBQXNCLEtBQXRCLENBQTRCLG9CQUE1QixDQUFpRCxTQUFqRCxHQUE2RCxRQUFRLENBQVIsRUFBVyxVQUFYLENBQXNCLEtBQXRCLENBQTRCLG9CQUE1QixDQUFpRCxZQUFqRCxJQUFpRSxRQUFRLENBQVIsRUFBVyxTQUFYLENBQXFCLENBQXJCLEdBQXlCLFFBQVEsQ0FBUixFQUFXLFVBQVgsQ0FBc0IsS0FBdEIsQ0FBNEIsZUFBdEgsQ0FBN0QsR0FBc00sRUFBdE0sSUFBNE0sQ0FBNU47QUFDRCxTQUhNLE1BSUY7QUFDSCwwQkFBZ0IsTUFBaEI7QUFDRDs7QUFFRCx3QkFBaUIsQ0FBQyxhQUFELEdBQWlCLEVBQWxDOztBQUVBLFlBQUksZ0JBQWdCLEtBQUssU0FBTCxDQUFlLFlBQS9CLEdBQThDLENBQTlDLEdBQWtELENBQXRELEVBQXlEO0FBQ3ZELDJCQUFpQixnQkFBZ0IsS0FBSyxTQUFMLENBQWUsWUFBL0IsR0FBOEMsQ0FBOUMsR0FBa0QsQ0FBbkU7QUFDRDs7QUFFRCx5QkFBaUIsSUFBakI7O0FBRUE7QUFDQSxhQUFLLFNBQUwsQ0FBZSxLQUFmLENBQXFCLElBQXJCLEdBQTRCLFdBQTVCO0FBQ0EsYUFBSyxTQUFMLENBQWUsS0FBZixDQUFxQixNQUFyQixHQUE4QixhQUE5Qjs7QUFFQSxZQUFJLENBQUMsS0FBSyxnQkFBTixJQUEwQixnQkFBOUIsRUFBZ0Q7QUFDOUMsZUFBSyxnQkFBTDtBQUNELFNBRkQsTUFJRSxLQUFLLGVBQUw7QUFDSCxPQS9FRCxNQStFTztBQUNMLGFBQUssSUFBTCxDQUFVLEtBQVY7QUFDRDtBQUVGOztBQUVEO0FBQ0E7QUFDRDtBQUNGLENBM1BEOztBQThQQSxRQUFRLFNBQVIsQ0FBa0IsZ0JBQWxCLEdBQXFDLFVBQVUsT0FBVixFQUFtQjtBQUN0RDtBQUNBOztBQUVBO0FBQ0EsTUFBSSxvQkFBb0IsS0FBSyxLQUFMLENBQVcsaUJBQW5DO0FBQ0EsT0FBSyxLQUFMLENBQVcsb0JBQVg7O0FBRUEsb0JBQWtCLFNBQWxCLENBQTRCLENBQTVCLEVBQThCLENBQTlCLEVBQWdDLEtBQUssS0FBTCxDQUFXLEtBQTNDLEVBQWtELEtBQUssS0FBTCxDQUFXLE1BQTdEO0FBQ0Esb0JBQWtCLElBQWxCOztBQUdBLE1BQUksV0FBVyxLQUFLLEtBQUwsQ0FBVyxRQUExQjtBQUNBLE1BQUksU0FBUyxDQUFiOztBQUVBLG9CQUFrQixJQUFsQixDQUF1QixTQUFTLEVBQWhDLEVBQW9DLFNBQVMsRUFBN0MsRUFBaUQsU0FBUyxFQUFULEdBQWMsU0FBUyxFQUF4RSxFQUE0RSxTQUFTLEVBQVQsR0FBYyxTQUFTLEVBQW5HO0FBQ0Esb0JBQWtCLElBQWxCOztBQUdBLE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxRQUFRLE1BQTVCLEVBQW9DLEdBQXBDLEVBQXlDOztBQUV2QyxRQUFJLFFBQVEsUUFBUSxDQUFSLENBQVo7O0FBRUEsUUFBSSxjQUFjLEtBQUssS0FBTCxDQUFXLGFBQVgsQ0FBeUIsU0FBekIsQ0FBbUMsTUFBTSxVQUFOLENBQWlCLFlBQWpCLENBQThCLE1BQU0sS0FBcEMsQ0FBbkMsQ0FBbEI7O0FBRUEsUUFBSSxDQUFDLFdBQUQsSUFBZ0IsQ0FBQyxZQUFZLFVBQTdCLElBQTJDLFlBQVksVUFBWixLQUEyQixXQUExRSxFQUNFOztBQUVGLFFBQUksYUFBYSxLQUFLLEtBQUwsQ0FBVyxJQUFYLENBQWdCLFlBQVksZUFBNUIsQ0FBakI7QUFDQSxRQUFJLFlBQVksV0FBVyxVQUFYLENBQXNCLFlBQVksY0FBbEMsQ0FBaEI7QUFDQSxRQUFJLFFBQVEsWUFBWSxjQUF4Qjs7QUFFQSxRQUFJLFVBQVUsZ0JBQVYsS0FBK0IsS0FBL0IsS0FBeUMsV0FBVyxnQkFBWCxLQUFnQyxJQUFoQyxJQUF3QyxVQUFVLGdCQUFWLEtBQStCLElBQWhILENBQUosRUFBMkg7O0FBRXpILFVBQUksV0FBVyxJQUFYLEtBQW9CLE1BQXBCLElBQThCLFdBQVcsSUFBWCxLQUFvQixVQUFsRCxJQUFnRSxXQUFXLElBQVgsS0FBb0IsUUFBcEYsSUFBZ0csV0FBVyxJQUFYLEtBQW9CLFNBQXBILElBQ0MsV0FBVyxJQUFYLEtBQW9CLE1BRHJCLElBQytCLFdBQVcsSUFBWCxLQUFvQixVQURuRCxJQUNpRSxXQUFXLElBQVgsS0FBb0IsWUFEckYsSUFFQyxXQUFXLElBQVgsS0FBb0IsYUFGckIsSUFFc0MsV0FBVyxJQUFYLEtBQW9CLGdCQUYxRCxJQUdDLFdBQVcsSUFBWCxLQUFvQixXQUhyQixJQUdvQyxXQUFXLElBQVgsS0FBb0IsaUJBSDVELEVBRytFO0FBQzdFLFlBQUksY0FBYyxXQUFXLG1CQUFYLENBQStCLEtBQS9CLEVBQXNDLFlBQVksRUFBbEQsRUFBc0QsWUFBWSxFQUFsRSxFQUFzRSxLQUFLLEtBQUwsQ0FBVyxpQkFBakYsQ0FBbEI7QUFDQSxvQkFBWSxJQUFaLEdBQW1CLEtBQUssR0FBTCxDQUFTLFlBQVksSUFBWixHQUFtQixHQUFuQixJQUEwQixDQUFuQyxFQUFzQyxFQUF0QyxDQUFuQjs7QUFFQSxvQkFBWSxXQUFaLEdBQTBCLFlBQVksV0FBWixJQUEyQixTQUFyRDtBQUNBLG9CQUFZLGVBQVosR0FBOEIsWUFBWSxlQUFaLElBQStCLEtBQUssSUFBTCxDQUFVLFlBQVksSUFBWixHQUFtQixFQUE3QixDQUE3RDs7QUFFQTtBQUNBLHlCQUFhLFdBQWIsQ0FBeUIsQ0FBQyxXQUFELENBQXpCO0FBQ0E7O0FBRUEsWUFBSSxPQUFRLFlBQVksRUFBcEIsS0FBNEIsV0FBaEMsRUFBNkM7O0FBRTNDLGNBQUksY0FBYyxXQUFXLG1CQUFYLENBQStCLEtBQS9CLEVBQXNDLFlBQVksRUFBbEQsRUFBc0QsWUFBWSxFQUFsRSxFQUFzRSxLQUFLLEtBQUwsQ0FBVyxpQkFBakYsQ0FBbEI7QUFDQSxzQkFBWSxJQUFaLEdBQW1CLEtBQUssR0FBTCxDQUFTLFlBQVksSUFBWixHQUFtQixHQUFuQixJQUEwQixDQUFuQyxFQUFzQyxFQUF0QyxDQUFuQjs7QUFFQSxzQkFBWSxXQUFaLEdBQTBCLFlBQVksV0FBWixJQUEyQixTQUFyRDtBQUNBLHNCQUFZLGVBQVosR0FBOEIsWUFBWSxlQUFaLElBQStCLEtBQUssSUFBTCxDQUFVLFlBQVksSUFBWixHQUFtQixFQUE3QixDQUE3RDs7QUFFQTtBQUNBLDJCQUFhLFdBQWIsQ0FBeUIsQ0FBQyxXQUFELENBQXpCO0FBQ0E7QUFDRDtBQUNGLE9BMUJELE1BMEJPLElBQUksV0FBVyxJQUFYLEtBQW9CLFFBQXhCLEVBQWtDO0FBQ3ZDLFlBQUksY0FBYyxXQUFXLG1CQUFYLENBQStCLEtBQS9CLEVBQXNDLFlBQVksRUFBbEQsRUFBc0QsWUFBWSxFQUFsRSxFQUFzRSxLQUFLLEtBQUwsQ0FBVyxpQkFBakYsQ0FBbEI7QUFDQSxvQkFBWSxJQUFaLEdBQW1CLFlBQVksSUFBL0I7QUFDQSxvQkFBWSxLQUFaLEdBQW9CLE9BQXBCO0FBQ0Esb0JBQVksV0FBWixHQUEwQixPQUExQjtBQUNBO0FBQ0EsMEJBQWtCLFdBQWxCLEdBQWdDLEVBQWhDO0FBQ0EseUJBQWEsV0FBYixDQUF5QixDQUFDLFdBQUQsQ0FBekI7QUFDQSwwQkFBa0IsV0FBbEIsR0FBZ0MsQ0FBaEM7QUFDRCxPQVRNLE1BU0EsSUFBSSxXQUFXLElBQVgsS0FBb0IsUUFBcEIsSUFBZ0MsV0FBVyxJQUFYLEtBQW9CLGVBQXBELElBQXVFLFdBQVcsSUFBWCxLQUFvQixrQkFBM0YsSUFDTixXQUFXLElBQVgsS0FBb0IsS0FEZCxJQUN1QixXQUFXLElBQVgsS0FBb0IsVUFEM0MsSUFDeUQsV0FBVyxJQUFYLEtBQW9CLFlBRDdFLElBQzZGLFdBQVcsSUFBWCxLQUFvQixlQURqSCxJQUVOLFdBQVcsSUFBWCxLQUFvQixhQUZsQixFQUVpQztBQUN0Qyw2QkFBUyxpQkFBVCxFQUE0QixZQUFZLEVBQXhDLEVBQTRDLFlBQVksRUFBeEQsRUFBNEQsWUFBWSxFQUF4RSxFQUE0RSxZQUFZLEVBQXhGLEVBQTRGLE9BQTVGLEVBQXFHLENBQXJHLEVBQXdHLElBQXhHLEVBQThHLEtBQTlHLEVBQXFILEtBQXJILEVBQTRILEtBQTVILEVBQW1JLEtBQW5JLEVBQTBJLEVBQTFJO0FBQ0QsT0FKTSxNQUtGLElBQUksV0FBVyxJQUFYLEtBQW9CLEtBQXBCLElBQTZCLFdBQVcsSUFBWCxLQUFvQixVQUFyRCxFQUFpRTtBQUNwRSxnQ0FBWSxpQkFBWixFQUErQixZQUFZLE1BQTNDLEVBQW1ELFlBQVksTUFBL0QsRUFBdUUsT0FBdkUsRUFBZ0YsV0FBVyxJQUEzRixFQUFpRyxZQUFZLFVBQTdHLEVBQXlILFlBQVksUUFBckksRUFBK0ksRUFBL0ksRUFBbUosWUFBWSxrQkFBL0o7QUFDRCxPQUZJLE1BRUUsSUFBSSxXQUFXLElBQVgsS0FBb0IsYUFBeEIsRUFBdUM7O0FBRTVDLDBCQUFrQixXQUFsQixHQUFnQyxDQUFoQztBQUNBLDBCQUFrQixXQUFsQixHQUFnQyxZQUFZLEtBQTVDO0FBQ0EsMEJBQWtCLFNBQWxCLEdBQThCLFlBQVksZUFBWixHQUE4QixDQUE1RDtBQUNBLGlCQUFVLGtCQUFrQixTQUFuQixHQUFnQyxDQUFoQyxLQUFzQyxDQUF0QyxHQUEwQyxDQUExQyxHQUE4QyxFQUF2RDs7QUFFQSwwQkFBa0IsU0FBbEI7QUFDQSwwQkFBa0IsTUFBbEIsQ0FBeUIsWUFBWSxFQUFaLEdBQWlCLE1BQTFDLEVBQWtELFlBQVksRUFBOUQ7QUFDQSwwQkFBa0IsTUFBbEIsQ0FBeUIsWUFBWSxFQUFaLEdBQWlCLE1BQTFDLEVBQWtELEtBQUssR0FBTCxDQUFTLFlBQVksRUFBckIsRUFBeUIsWUFBWSxFQUFyQyxDQUFsRDtBQUNBLDBCQUFrQixNQUFsQjs7QUFFQSwwQkFBa0IsU0FBbEI7QUFDQSwwQkFBa0IsTUFBbEIsQ0FBeUIsWUFBWSxFQUFaLEdBQWlCLE1BQTFDLEVBQWtELEtBQUssR0FBTCxDQUFTLFlBQVksRUFBckIsRUFBeUIsWUFBWSxFQUFyQyxDQUFsRDtBQUNBLDBCQUFrQixNQUFsQixDQUF5QixZQUFZLEVBQVosR0FBaUIsTUFBMUMsRUFBa0QsWUFBWSxFQUE5RDtBQUNBLDBCQUFrQixNQUFsQjs7QUFFQSw2QkFBUyxpQkFBVCxFQUE0QixZQUFZLEVBQXhDLEVBQTRDLEtBQUssR0FBTCxDQUFTLFlBQVksRUFBckIsRUFBeUIsWUFBWSxFQUFyQyxDQUE1QyxFQUFzRixZQUFZLEVBQWxHLEVBQXNHLEtBQUssR0FBTCxDQUFTLFlBQVksRUFBckIsRUFBeUIsWUFBWSxFQUFyQyxDQUF0RyxFQUFnSixhQUFoSixFQUErSixZQUFZLGVBQVosR0FBOEIsQ0FBN0wsRUFBZ00sWUFBWSxLQUE1TSxFQUFtTixLQUFuTixFQUEwTixLQUExTixFQUFpTyxLQUFqTyxFQUF3TyxLQUF4TztBQUNBLDBCQUFrQixXQUFsQixHQUFnQyxDQUFoQztBQUVELE9BcEJNLE1Bb0JBLElBQUksV0FBVyxJQUFYLEtBQW9CLE1BQXhCLEVBQWdDO0FBQ3JDLDBCQUFrQixXQUFsQixHQUFnQyxDQUFoQzs7QUFFQSwwQkFBa0IsV0FBbEIsR0FBZ0MsWUFBWSxLQUE1QztBQUNBLDBCQUFrQixTQUFsQixHQUE4QixZQUFZLGVBQVosR0FBOEIsQ0FBNUQ7O0FBRUEsaUJBQVUsa0JBQWtCLFNBQW5CLEdBQWdDLENBQWhDLEtBQXNDLENBQXRDLEdBQTBDLENBQTFDLEdBQThDLEVBQXZEOztBQUVBLDBCQUFrQixTQUFsQjtBQUNBLDBCQUFrQixNQUFsQixDQUF5QixZQUFZLEVBQVosR0FBaUIsTUFBMUMsRUFBa0QsWUFBWSxFQUE5RDtBQUNBLDBCQUFrQixNQUFsQixDQUF5QixZQUFZLEVBQVosR0FBaUIsTUFBMUMsRUFBa0QsWUFBWSxFQUE5RDtBQUNBLDBCQUFrQixNQUFsQjs7QUFFQSwwQkFBa0IsU0FBbEI7QUFDQSwwQkFBa0IsTUFBbEIsQ0FBeUIsWUFBWSxFQUFyQyxFQUF5QyxZQUFZLEVBQXJEO0FBQ0EsMEJBQWtCLE1BQWxCLENBQXlCLFlBQVksRUFBckMsRUFBeUMsWUFBWSxFQUFyRDtBQUNBLDBCQUFrQixNQUFsQjs7QUFFQSwwQkFBa0IsU0FBbEI7QUFDQSwwQkFBa0IsTUFBbEIsQ0FBeUIsWUFBWSxFQUFyQyxFQUF5QyxZQUFZLEVBQXJEO0FBQ0EsMEJBQWtCLE1BQWxCLENBQXlCLFlBQVksRUFBckMsRUFBeUMsWUFBWSxFQUFyRDtBQUNBLDBCQUFrQixNQUFsQjs7QUFFQSwwQkFBa0IsV0FBbEIsR0FBZ0MsQ0FBaEM7QUFFRDtBQUNGO0FBQ0Y7O0FBRUQsb0JBQWtCLE9BQWxCO0FBQ0Esb0JBQWtCLFdBQWxCLEdBQWdDLENBQWhDO0FBQ0Esb0JBQWtCLFNBQWxCOztBQUVBO0FBQ0QsQ0FsSUQ7O0FBb0lBLFFBQVEsU0FBUixDQUFrQixtQkFBbEIsR0FBd0MsVUFBVSxDQUFWLEVBQWE7QUFDbkQsTUFBSSxVQUFVLEVBQUUsT0FBaEI7QUFDQSxNQUFJLG1CQUFtQixJQUF2QjtBQUNBLE1BQUksYUFBYSxJQUFqQjtBQUNBLE1BQUksWUFBWSxJQUFoQjtBQUNBLE1BQUksUUFBUSxDQUFaO0FBQ0EsTUFBSSxRQUFRLElBQVo7QUFDQSxNQUFJLGlCQUFpQixFQUFyQjs7QUFFQSxNQUFJLHlCQUF5QixJQUE3QjtBQUNBLE9BQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxRQUFRLE1BQTVCLEVBQW9DLEdBQXBDLEVBQXlDO0FBQ3ZDLFFBQUksUUFBUSxDQUFSLEVBQVcsVUFBWCxDQUFzQixjQUF0QixJQUF3QyxRQUFRLENBQVIsRUFBVyxTQUFYLENBQXFCLGNBQWpFLEVBQWlGO0FBQy9FLCtCQUF5QixLQUF6QjtBQUNBO0FBQ0Q7QUFDRjs7QUFFRCxNQUFJLDJCQUE0QixLQUFLLE9BQUwsSUFBZ0IsT0FBUSxLQUFLLE9BQWIsS0FBMEIsVUFBM0MsSUFBMEQsS0FBSyxnQkFBMUYsQ0FBSixFQUFpSDs7QUFFL0csUUFBSSxRQUFRO0FBQ1YsYUFBTyxLQUFLLEtBREYsRUFDUyxTQUFTLEtBQUssUUFEdkIsRUFDaUMsU0FBUztBQUQxQyxLQUFaO0FBR0EsdUJBQW1CLEtBQUssZ0JBQUwsR0FBd0IsS0FBSyxnQkFBTCxDQUFzQixLQUF0QixDQUF4QixHQUF1RCxLQUFLLE9BQUwsQ0FBYSxLQUFiLENBQTFFO0FBRUQsR0FQRCxNQU9POztBQUVMLFFBQUksS0FBSyxNQUFMLElBQWUsS0FBSyxLQUFMLENBQVcsUUFBWCxDQUFvQixhQUFwQixLQUFzQyxNQUF6RCxFQUFpRTs7QUFFL0QsVUFBSSx5QkFBeUIsRUFBN0I7O0FBRUEsV0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFFBQVEsTUFBNUIsRUFBb0MsR0FBcEMsRUFBeUM7QUFDdkMscUJBQWEsUUFBUSxDQUFSLEVBQVcsVUFBeEI7QUFDQSxvQkFBWSxRQUFRLENBQVIsRUFBVyxTQUF2QjtBQUNBLGdCQUFRLFFBQVEsQ0FBUixFQUFXLEtBQW5COztBQUVBLHlCQUFpQixFQUFqQjs7QUFFQSxZQUFJLE1BQU0sQ0FBTixJQUFXLHNCQUFYLElBQXFDLENBQUMsS0FBSyxPQUEvQyxFQUF3RDtBQUN0RCxvQ0FBMEIsT0FBUSxLQUFLLEtBQUwsQ0FBVyxLQUFYLENBQWlCLE1BQWpCLENBQXdCLFVBQVUsQ0FBbEMsQ0FBUixLQUFrRCxXQUFsRCxHQUFnRSxLQUFLLEtBQUwsQ0FBVyxLQUFYLENBQWlCLE1BQWpCLENBQXdCLFVBQVUsQ0FBbEMsQ0FBaEUsR0FBdUcsS0FBakk7QUFDQSxvQ0FBMEIsT0FBMUI7QUFDQSxtQ0FBeUIsS0FBSyxLQUFMLENBQVcsd0JBQVgsQ0FBb0Msc0JBQXBDLEVBQTRELFNBQTVELEVBQXVFLFVBQXZFLEVBQW1GLEtBQW5GLENBQXpCO0FBQ0Q7O0FBRUQ7QUFDQSxZQUFJLFVBQVUsY0FBVixLQUE2QixJQUE3QixJQUFzQyxPQUFRLFVBQVUsY0FBbEIsS0FBc0MsV0FBdEMsSUFBcUQsV0FBVyxRQUFYLENBQW9CLGNBQXBCLEtBQXVDLElBQXRJLEVBQ0U7O0FBR0YsWUFBSSxXQUFXLElBQVgsS0FBb0IsTUFBcEIsSUFBOEIsV0FBVyxJQUFYLEtBQW9CLFVBQWxELElBQWdFLFdBQVcsSUFBWCxLQUFvQixRQUFwRixJQUFnRyxXQUFXLElBQVgsS0FBb0IsTUFBcEgsSUFBOEgsV0FBVyxJQUFYLEtBQW9CLFVBQWxKLElBQWdLLFdBQVcsSUFBWCxLQUFvQixZQUFwTCxJQUFvTSxXQUFXLElBQVgsS0FBb0IsUUFBeE4sSUFBb08sV0FBVyxJQUFYLEtBQW9CLEtBQXhQLElBQWlRLFdBQVcsSUFBWCxLQUFvQixTQUFyUixJQUNELFdBQVcsSUFBWCxLQUFvQixlQURuQixJQUNzQyxXQUFXLElBQVgsS0FBb0Isa0JBRDFELElBQ2dGLFdBQVcsSUFBWCxLQUFvQixZQURwRyxJQUNvSCxXQUFXLElBQVgsS0FBb0IsZUFEeEksSUFFRCxXQUFXLElBQVgsS0FBb0IsYUFGbkIsSUFFb0MsV0FBVyxJQUFYLEtBQW9CLGdCQUY1RCxFQUU4RTtBQUM1RSw0QkFBa0IsVUFBVSxjQUFWLEdBQTJCLFVBQVUsY0FBckMsR0FBc0QsV0FBVyxjQUFYLEdBQTRCLFdBQVcsY0FBdkMsR0FBd0QsS0FBSyxPQUFMLElBQWdCLE9BQVEsS0FBSyxPQUFiLEtBQTBCLFVBQTFDLEdBQXVELEtBQUssT0FBNUQsR0FBc0Usa0VBQXRNO0FBQ0QsU0FKRCxNQUtLLElBQUksV0FBVyxJQUFYLEtBQW9CLFFBQXhCLEVBQWtDO0FBQ3JDLDRCQUFrQixVQUFVLGNBQVYsR0FBMkIsVUFBVSxjQUFyQyxHQUFzRCxXQUFXLGNBQVgsR0FBNEIsV0FBVyxjQUF2QyxHQUF3RCxLQUFLLE9BQUwsSUFBZ0IsT0FBUSxLQUFLLE9BQWIsS0FBMEIsVUFBMUMsR0FBdUQsS0FBSyxPQUE1RCxHQUFzRSxtRkFBdE07QUFDRCxTQUZJLE1BRUUsSUFBSSxXQUFXLElBQVgsS0FBb0IsS0FBcEIsSUFBNkIsV0FBVyxJQUFYLEtBQW9CLFVBQWpELElBQStELFdBQVcsSUFBWCxLQUFvQixRQUF2RixFQUFpRztBQUN0Ryw0QkFBa0IsVUFBVSxjQUFWLEdBQTJCLFVBQVUsY0FBckMsR0FBc0QsV0FBVyxjQUFYLEdBQTRCLFdBQVcsY0FBdkMsR0FBd0QsS0FBSyxPQUFMLElBQWdCLE9BQVEsS0FBSyxPQUFiLEtBQTBCLFVBQTFDLEdBQXVELEtBQUssT0FBNUQsR0FBc0UsaUJBQXRNO0FBQ0QsU0FGTSxNQUVBLElBQUksV0FBVyxJQUFYLEtBQW9CLGFBQXBCLElBQXFDLFdBQVcsSUFBWCxLQUFvQixVQUF6RCxJQUF1RSxXQUFXLElBQVgsS0FBb0IsV0FBM0YsSUFBMEcsV0FBVyxJQUFYLEtBQW9CLGlCQUFsSSxFQUFxSjtBQUMxSiw0QkFBa0IsVUFBVSxjQUFWLEdBQTJCLFVBQVUsY0FBckMsR0FBc0QsV0FBVyxjQUFYLEdBQTRCLFdBQVcsY0FBdkMsR0FBd0QsS0FBSyxPQUFMLElBQWdCLE9BQVEsS0FBSyxPQUFiLEtBQTBCLFVBQTFDLEdBQXVELEtBQUssT0FBNUQsR0FBc0Usa0ZBQXRNO0FBQ0QsU0FGTSxNQUVBLElBQUksV0FBVyxJQUFYLEtBQW9CLGFBQXBCLElBQXFDLFdBQVcsSUFBWCxLQUFvQixNQUE3RCxFQUFxRTtBQUMxRSw0QkFBa0IsVUFBVSxjQUFWLEdBQTJCLFVBQVUsY0FBckMsR0FBc0QsV0FBVyxjQUFYLEdBQTRCLFdBQVcsY0FBdkMsR0FBd0QsS0FBSyxPQUFMLElBQWdCLE9BQVEsS0FBSyxPQUFiLEtBQTBCLFVBQTFDLEdBQXVELEtBQUssT0FBNUQsR0FBc0Usc0RBQzVMLCtCQUQ0TCxHQUU1TCxxQ0FGNEwsR0FHNUwsbUNBSDRMLEdBSTVMLGdDQUpWO0FBS0Q7O0FBRUQsWUFBSSxxQkFBcUIsSUFBekIsRUFDRSxtQkFBbUIsRUFBbkI7O0FBR0YsWUFBSSxLQUFLLFFBQUwsS0FBa0IsSUFBdEIsRUFBNEI7O0FBRTFCLDZCQUFtQixLQUFLLEtBQUwsQ0FBVyx3QkFBWCxDQUFvQyxjQUFwQyxFQUFvRCxTQUFwRCxFQUErRCxVQUEvRCxFQUEyRSxLQUEzRSxJQUFvRixnQkFBdkc7O0FBRUEsY0FBSSxJQUFJLFFBQVEsTUFBUixHQUFpQixDQUF6QixFQUNFLG1CQUFtQixVQUFVLGdCQUE3QjtBQUVILFNBUEQsTUFPTzs7QUFFTCw4QkFBb0IsS0FBSyxLQUFMLENBQVcsd0JBQVgsQ0FBb0MsY0FBcEMsRUFBb0QsU0FBcEQsRUFBK0QsVUFBL0QsRUFBMkUsS0FBM0UsQ0FBcEI7O0FBRUEsY0FBSSxJQUFJLFFBQVEsTUFBUixHQUFpQixDQUF6QixFQUNFLG9CQUFvQixPQUFwQjtBQUVIO0FBRUY7O0FBRUQsVUFBSSxxQkFBcUIsSUFBekIsRUFDRSxtQkFBbUIseUJBQXlCLGdCQUE1QztBQUVILEtBbEVELE1Ba0VPOztBQUVMLG1CQUFhLFFBQVEsQ0FBUixFQUFXLFVBQXhCO0FBQ0Esa0JBQVksUUFBUSxDQUFSLEVBQVcsU0FBdkI7QUFDQSxjQUFRLFFBQVEsQ0FBUixFQUFXLEtBQW5COztBQUVBO0FBQ0EsVUFBSSxVQUFVLGNBQVYsS0FBNkIsSUFBN0IsSUFBc0MsT0FBUSxVQUFVLGNBQWxCLEtBQXNDLFdBQXRDLElBQXFELFdBQVcsUUFBWCxDQUFvQixjQUFwQixLQUF1QyxJQUF0SSxFQUNFLE9BQU8sSUFBUDs7QUFHRixVQUFJLFdBQVcsSUFBWCxLQUFvQixNQUFwQixJQUE4QixXQUFXLElBQVgsS0FBb0IsVUFBbEQsSUFBZ0UsV0FBVyxJQUFYLEtBQW9CLFFBQXBGLElBQWdHLFdBQVcsSUFBWCxLQUFvQixNQUFwSCxJQUE4SCxXQUFXLElBQVgsS0FBb0IsVUFBbEosSUFBZ0ssV0FBVyxJQUFYLEtBQW9CLFlBQXBMLElBQW9NLFdBQVcsSUFBWCxLQUFvQixRQUF4TixJQUFvTyxXQUFXLElBQVgsS0FBb0IsS0FBeFAsSUFBaVEsV0FBVyxJQUFYLEtBQW9CLFNBQXJSLElBQ0MsV0FBVyxJQUFYLEtBQW9CLGVBRHJCLElBQ3dDLFdBQVcsSUFBWCxLQUFvQixrQkFENUQsSUFDa0YsV0FBVyxJQUFYLEtBQW9CLFlBRHRHLElBQ3NILFdBQVcsSUFBWCxLQUFvQixlQUQxSSxJQUVDLFdBQVcsSUFBWCxLQUFvQixhQUZyQixJQUVzQyxXQUFXLElBQVgsS0FBb0IsZ0JBRjlELEVBRWdGO0FBQzlFLHlCQUFpQixVQUFVLGNBQVYsR0FBMkIsVUFBVSxjQUFyQyxHQUFzRCxXQUFXLGNBQVgsR0FBNEIsV0FBVyxjQUF2QyxHQUF3RCxLQUFLLE9BQUwsSUFBZ0IsT0FBUSxLQUFLLE9BQWIsS0FBMEIsVUFBMUMsR0FBdUQsS0FBSyxPQUE1RCxHQUFzRSx5Q0FBeUMsVUFBVSxLQUFWLEdBQWtCLFNBQWxCLEdBQThCLEtBQXZFLElBQWdGLDBCQUFyUjtBQUNELE9BSkQsTUFJTyxJQUFJLFdBQVcsSUFBWCxLQUFvQixRQUF4QixFQUFrQztBQUN2Qyx5QkFBaUIsVUFBVSxjQUFWLEdBQTJCLFVBQVUsY0FBckMsR0FBc0QsV0FBVyxjQUFYLEdBQTRCLFdBQVcsY0FBdkMsR0FBd0QsS0FBSyxPQUFMLElBQWdCLE9BQVEsS0FBSyxPQUFiLEtBQTBCLFVBQTFDLEdBQXVELEtBQUssT0FBNUQsR0FBc0UseUNBQXlDLFVBQVUsS0FBVixHQUFrQixTQUFsQixHQUE4QixLQUF2RSxJQUFnRiwwQ0FBclI7QUFDRCxPQUZNLE1BRUEsSUFBSSxXQUFXLElBQVgsS0FBb0IsS0FBcEIsSUFBNkIsV0FBVyxJQUFYLEtBQW9CLFVBQWpELElBQStELFdBQVcsSUFBWCxLQUFvQixRQUF2RixFQUFpRztBQUN0Ryx5QkFBaUIsVUFBVSxjQUFWLEdBQTJCLFVBQVUsY0FBckMsR0FBc0QsV0FBVyxjQUFYLEdBQTRCLFdBQVcsY0FBdkMsR0FBd0QsS0FBSyxPQUFMLElBQWdCLE9BQVEsS0FBSyxPQUFiLEtBQTBCLFVBQTFDLEdBQXVELEtBQUssT0FBNUQsR0FBc0UsQ0FBQyxVQUFVLElBQVYsR0FBaUIscUJBQWpCLEdBQXlDLFVBQVUsS0FBVixHQUFrQixzQkFBbEIsR0FBMkMsRUFBckYsSUFBMkYsS0FBaFM7QUFDRCxPQUZNLE1BRUEsSUFBSSxXQUFXLElBQVgsS0FBb0IsYUFBcEIsSUFBcUMsV0FBVyxJQUFYLEtBQW9CLFVBQXpELElBQXVFLFdBQVcsSUFBWCxLQUFvQixXQUEzRixJQUEwRyxXQUFXLElBQVgsS0FBb0IsaUJBQWxJLEVBQXFKO0FBQzFKLHlCQUFpQixVQUFVLGNBQVYsR0FBMkIsVUFBVSxjQUFyQyxHQUFzRCxXQUFXLGNBQVgsR0FBNEIsV0FBVyxjQUF2QyxHQUF3RCxLQUFLLE9BQUwsSUFBZ0IsT0FBUSxLQUFLLE9BQWIsS0FBMEIsVUFBMUMsR0FBdUQsS0FBSyxPQUE1RCxHQUFzRSx5Q0FBeUMsVUFBVSxLQUFWLEdBQWtCLFNBQWxCLEdBQThCLEtBQXZFLElBQWdGLDJDQUFyUjtBQUNELE9BRk0sTUFFQSxJQUFJLFdBQVcsSUFBWCxLQUFvQixhQUFwQixJQUFxQyxXQUFXLElBQVgsS0FBb0IsTUFBN0QsRUFBcUU7QUFDMUUseUJBQWlCLFVBQVUsY0FBVixHQUEyQixVQUFVLGNBQXJDLEdBQXNELFdBQVcsY0FBWCxHQUE0QixXQUFXLGNBQXZDLEdBQXdELEtBQUssT0FBTCxJQUFnQixPQUFRLEtBQUssT0FBYixLQUEwQixVQUExQyxHQUF1RCxLQUFLLE9BQTVELEdBQXNFLHlDQUF5QyxVQUFVLEtBQVYsR0FBa0IsU0FBbEIsR0FBOEIsS0FBdkUsSUFBZ0YsU0FBaEYsR0FDak0sK0JBRGlNLEdBRWpNLHFDQUZpTSxHQUdqTSwwQ0FIaU0sR0FJak0sZ0NBSko7QUFLRDs7QUFFRCxVQUFJLHFCQUFxQixJQUF6QixFQUNFLG1CQUFtQixFQUFuQjs7QUFFRiwwQkFBb0IsS0FBSyxLQUFMLENBQVcsd0JBQVgsQ0FBb0MsY0FBcEMsRUFBb0QsU0FBcEQsRUFBK0QsVUFBL0QsRUFBMkUsS0FBM0UsQ0FBcEI7QUFDRDtBQUNGOztBQUVELFNBQU8sZ0JBQVA7QUFDRCxDQWpJRDs7QUFtSUEsUUFBUSxTQUFSLENBQWtCLGVBQWxCLEdBQW9DLFlBQVk7QUFDOUMsTUFBSSxLQUFLLFNBQUwsQ0FBZSxLQUFmLENBQXFCLGdCQUF6QixFQUNFOztBQUVGLE9BQUssU0FBTCxDQUFlLEtBQWYsQ0FBcUIsZ0JBQXJCLEdBQXdDLHdDQUF4QztBQUNBLE9BQUssU0FBTCxDQUFlLEtBQWYsQ0FBcUIsYUFBckIsR0FBcUMsd0NBQXJDO0FBQ0EsT0FBSyxTQUFMLENBQWUsS0FBZixDQUFxQixZQUFyQixHQUFvQyx3Q0FBcEM7QUFDQSxPQUFLLFNBQUwsQ0FBZSxLQUFmLENBQXFCLFVBQXJCLEdBQWtDLHdDQUFsQztBQUNELENBUkQ7O0FBVUEsUUFBUSxTQUFSLENBQWtCLGdCQUFsQixHQUFxQyxZQUFZO0FBQy9DLE1BQUksQ0FBQyxLQUFLLFNBQUwsQ0FBZSxLQUFmLENBQXFCLGdCQUExQixFQUNFOztBQUVGLE9BQUssU0FBTCxDQUFlLEtBQWYsQ0FBcUIsZ0JBQXJCLEdBQXdDLEVBQXhDO0FBQ0EsT0FBSyxTQUFMLENBQWUsS0FBZixDQUFxQixhQUFyQixHQUFxQyxFQUFyQztBQUNBLE9BQUssU0FBTCxDQUFlLEtBQWYsQ0FBcUIsWUFBckIsR0FBb0MsRUFBcEM7QUFDQSxPQUFLLFNBQUwsQ0FBZSxLQUFmLENBQXFCLFVBQXJCLEdBQWtDLEVBQWxDO0FBQ0QsQ0FSRDs7QUFVQSxRQUFRLFNBQVIsQ0FBa0IsSUFBbEIsR0FBeUIsVUFBVSxvQkFBVixFQUFnQztBQUN2RCxNQUFJLENBQUMsS0FBSyxPQUFWLEVBQ0U7O0FBRUYseUJBQXVCLE9BQVEsb0JBQVIsS0FBa0MsV0FBbEMsR0FBZ0QsSUFBaEQsR0FBdUQsb0JBQTlFOztBQUVBLE9BQUssU0FBTCxDQUFlLEtBQWYsQ0FBcUIsT0FBckIsR0FBK0IsTUFBL0I7QUFDQSxPQUFLLGtCQUFMLEdBQTBCLENBQUMsQ0FBM0I7QUFDQSxPQUFLLE1BQUwsR0FBYyxHQUFkO0FBQ0EsT0FBSyxNQUFMLEdBQWMsR0FBZDtBQUNBO0FBQ0EsTUFBSSxvQkFBSixFQUNFLEtBQUssS0FBTCxDQUFXLG9CQUFYO0FBQ0gsQ0FiRDs7a0JBZWUsTzs7Ozs7Ozs7O0FDeG9CZixTQUFTLGVBQVQsQ0FBeUIsZ0JBQXpCLEVBQTJDLGFBQTNDLEVBQTBEOztBQUV4RCxNQUFJLHFCQUFxQixDQUF6QixFQUE0Qjs7QUFFNUIsTUFBTSxNQUFNLGNBQWMsSUFBMUI7QUFDQSxNQUFNLGVBQWUsY0FBYyxNQUFkLENBQXFCLE1BQTFDO0FBQ0EsTUFBTSxPQUFPLGNBQWMsYUFBM0I7O0FBRUEsTUFBTSxVQUFXLE9BQU8sT0FBTyxnQkFBL0I7O0FBRUEsTUFBSSxTQUFKLENBQWMsWUFBZCxFQUE0QixDQUE1QixFQUErQixDQUEvQixFQUFrQyxhQUFhLEtBQS9DLEVBQXNELGFBQWEsTUFBbkUsRUFBMkUsQ0FBM0UsRUFBOEUsT0FBOUUsRUFDRyxJQUFJLE1BQUosQ0FBVyxLQUFYLEdBQW1CLDRCQUR0QixFQUNvRCxtQkFBbUIsSUFBSSxNQUFKLENBQVcsTUFBOUIsR0FBdUMsNEJBRDNGO0FBRUQ7O0FBRUQsU0FBUyxlQUFULENBQXlCLGdCQUF6QixFQUEyQyxhQUEzQyxFQUEwRDs7QUFFeEQsTUFBSSxxQkFBcUIsQ0FBekIsRUFBNEI7O0FBRTVCLE1BQU0sTUFBTSxjQUFjLElBQTFCO0FBQ0EsTUFBTSxlQUFlLGNBQWMsTUFBZCxDQUFxQixNQUExQztBQUNBLE1BQU0sT0FBTyxjQUFjLGFBQTNCOztBQUVBLE1BQU0sVUFBVyxPQUFPLE9BQU8sZ0JBQS9COztBQUVBLE1BQUksU0FBSixDQUFjLFlBQWQsRUFBNEIsQ0FBNUIsRUFBK0IsQ0FBL0IsRUFBa0MsYUFBYSxLQUEvQyxFQUFzRCxhQUFhLE1BQW5FLEVBQTJFLE9BQTNFLEVBQW9GLENBQXBGLEVBQ0UsbUJBQW1CLElBQUksTUFBSixDQUFXLEtBQTlCLEdBQXNDLDRCQUR4QyxFQUNzRSxJQUFJLE1BQUosQ0FBVyxNQUFYLEdBQW9CLDRCQUQxRjtBQUVEOztBQUVELFNBQVMsY0FBVCxDQUF3QixnQkFBeEIsRUFBMEMsYUFBMUMsRUFBeUQ7O0FBRXZELE1BQUkscUJBQXFCLENBQXpCLEVBQTRCOztBQUU1QixNQUFNLE1BQU0sY0FBYyxJQUExQjtBQUNBLE1BQU0sZUFBZSxjQUFjLE1BQWQsQ0FBcUIsTUFBMUM7O0FBRUEsTUFBSSxJQUFKOztBQUVBLE1BQUksbUJBQW1CLENBQXZCLEVBQ0UsSUFBSSxTQUFKLENBQWMsWUFBZCxFQUE0QixDQUE1QixFQUErQixDQUEvQixFQUFrQyxhQUFhLEtBQWIsR0FBcUIsZ0JBQXZELEVBQXlFLGFBQWEsTUFBdEYsRUFBOEYsQ0FBOUYsRUFBaUcsQ0FBakcsRUFDRSxhQUFhLEtBQWIsR0FBcUIsZ0JBQXJCLEdBQXdDLDRCQUQxQyxFQUN3RSxhQUFhLE1BQWIsR0FBc0IsNEJBRDlGOztBQUdGLE1BQUksT0FBSjtBQUNEOztBQUVELFNBQVMsZUFBVCxDQUF5QixnQkFBekIsRUFBMkMsYUFBM0MsRUFBMEQ7O0FBRXhELE1BQUkscUJBQXFCLENBQXpCLEVBQTRCOztBQUU1QixNQUFNLE1BQU0sY0FBYyxJQUExQjtBQUNBLE1BQU0sZUFBZSxjQUFjLE1BQWQsQ0FBcUIsTUFBMUM7O0FBRUEsTUFBSSxJQUFKOztBQUVBLE1BQUksV0FBSixHQUFrQixnQkFBbEI7O0FBRUEsTUFBSSxTQUFKLENBQWMsWUFBZCxFQUE0QixDQUE1QixFQUErQixDQUEvQixFQUFrQyxhQUFhLEtBQS9DLEVBQXNELGFBQWEsTUFBbkUsRUFBMkUsQ0FBM0UsRUFBOEUsQ0FBOUUsRUFDRSxJQUFJLE1BQUosQ0FBVyxLQUFYLEdBQW1CLDRCQURyQixFQUNtRCxJQUFJLE1BQUosQ0FBVyxNQUFYLEdBQW9CLDRCQUR2RTs7QUFHQSxNQUFJLE9BQUo7QUFFRDs7QUFFRCxJQUFNLFNBQVM7QUFFYixRQUZhLGtCQUVOLENBRk0sRUFFSCxDQUZHLEVBRUEsQ0FGQSxFQUVHLENBRkgsRUFFTTtBQUNqQixXQUFPLElBQUksQ0FBSixHQUFRLENBQVIsR0FBWSxDQUFuQjtBQUNELEdBSlk7QUFNYixhQU5hLHVCQU1ELENBTkMsRUFNRSxDQU5GLEVBTUssQ0FOTCxFQU1RLENBTlIsRUFNVztBQUN0QixXQUFPLENBQUMsQ0FBRCxJQUFNLEtBQUssQ0FBWCxLQUFpQixJQUFJLENBQXJCLElBQTBCLENBQWpDO0FBQ0QsR0FSWTtBQVViLGNBVmEsd0JBVUMsQ0FWRCxFQVVJLENBVkosRUFVTyxDQVZQLEVBVVUsQ0FWVixFQVVhO0FBQ3hCLFdBQU8sQ0FBQyxDQUFELElBQU0sQ0FBQyxJQUFJLElBQUksQ0FBSixHQUFRLENBQWIsSUFBa0IsQ0FBbEIsR0FBc0IsQ0FBdEIsR0FBMEIsQ0FBMUIsR0FBOEIsQ0FBcEMsSUFBeUMsQ0FBaEQ7QUFDRCxHQVpZO0FBY2IsWUFkYSxzQkFjRixDQWRFLEVBY0MsQ0FkRCxFQWNJLENBZEosRUFjTyxDQWRQLEVBY1U7QUFDckIsV0FBTyxLQUFLLEtBQUssQ0FBVixJQUFlLENBQWYsR0FBbUIsQ0FBMUI7QUFDRCxHQWhCWTtBQWtCYixhQWxCYSx1QkFrQkQsQ0FsQkMsRUFrQkUsQ0FsQkYsRUFrQkssQ0FsQkwsRUFrQlEsQ0FsQlIsRUFrQlc7QUFDdEIsV0FBTyxLQUFLLEtBQUssQ0FBVixJQUFlLENBQWYsR0FBbUIsQ0FBbkIsR0FBdUIsQ0FBdkIsR0FBMkIsQ0FBbEM7QUFDRDtBQXBCWSxDQUFmOztrQkF1QmU7O0FBRWIsa0NBRmE7QUFHYixrQ0FIYTtBQUliLGdDQUphO0FBS2Isa0NBTGE7QUFNYjs7QUFOYSxDOzs7Ozs7OztBQ3RGZixJQUFNLGVBQWU7O0FBRW5CLGtCQUFZLG9CQUFVLENBQVYsRUFBYSxDQUFiLEVBQWdCLEdBQWhCLEVBQXFCLFVBQXJCLEVBQWlDLFVBQWpDLEVBQTZDLFdBQTdDLEVBQTBELGlCQUExRCxFQUE2RSxxQkFBN0UsRUFBb0c7O0FBRTlHLGdCQUFJLENBQUMsR0FBTCxFQUNFOztBQUVGLGdCQUFJLFFBQVEsQ0FBWjs7QUFFQSxnQkFBSSxTQUFKLEdBQWdCLGNBQWMsV0FBZCxHQUE0QixTQUE1QztBQUNBLGdCQUFJLFdBQUosR0FBa0Isb0JBQW9CLGlCQUFwQixHQUF3QyxTQUExRDtBQUNBLGdCQUFJLFNBQUosR0FBZ0Isd0JBQXdCLHFCQUF4QixHQUFnRCxDQUFoRTs7QUFHQSxnQkFBSSxlQUFlLFFBQW5CLEVBQTZCOztBQUUzQixzQkFBSSxNQUFKLENBQVcsQ0FBWCxFQUFjLENBQWQ7QUFDQSxzQkFBSSxTQUFKO0FBQ0E7O0FBRUEsc0JBQUksR0FBSixDQUFRLENBQVIsRUFBVyxDQUFYLEVBQWMsYUFBYSxDQUEzQixFQUE4QixDQUE5QixFQUFpQyxLQUFLLEVBQUwsR0FBVSxDQUEzQyxFQUE4QyxLQUE5Qzs7QUFFQSxzQkFBSSxXQUFKLEVBQ0UsSUFBSSxJQUFKOztBQUVGLHNCQUFJLHFCQUFKLEVBQTJCOztBQUV6Qiw0QkFBSSxDQUFDLGlCQUFMLEVBQXdCO0FBQ3RCLHNDQUFRLElBQUksV0FBWjtBQUNBLGtDQUFJLFdBQUosR0FBa0IsR0FBbEI7QUFDQSxrQ0FBSSxXQUFKLEdBQWtCLE9BQWxCO0FBQ0Esa0NBQUksTUFBSjtBQUNBLGtDQUFJLFdBQUosR0FBa0IsS0FBbEI7QUFDRCx5QkFORCxNQU9FLElBQUksTUFBSjtBQUVIO0FBQ0YsYUF2QkQsTUF3QkssSUFBSSxlQUFlLFFBQW5CLEVBQTZCOztBQUVoQztBQUNBLHNCQUFJLFNBQUo7QUFDQSxzQkFBSSxJQUFKLENBQVMsSUFBSSxhQUFhLENBQTFCLEVBQTZCLElBQUksYUFBYSxDQUE5QyxFQUFpRCxVQUFqRCxFQUE2RCxVQUE3RDs7QUFFQSxzQkFBSSxXQUFKLEVBQ0UsSUFBSSxJQUFKOztBQUVGLHNCQUFJLHFCQUFKLEVBQTJCOztBQUV6Qiw0QkFBSSxDQUFDLGlCQUFMLEVBQXdCO0FBQ3RCLHNDQUFRLElBQUksV0FBWjtBQUNBLGtDQUFJLFdBQUosR0FBa0IsR0FBbEI7QUFDQSxrQ0FBSSxXQUFKLEdBQWtCLE9BQWxCO0FBQ0Esa0NBQUksTUFBSjtBQUNBLGtDQUFJLFdBQUosR0FBa0IsS0FBbEI7QUFDRCx5QkFORCxNQU9FLElBQUksTUFBSjtBQUVIO0FBQ0YsYUFyQkksTUFxQkUsSUFBSSxlQUFlLFVBQW5CLEVBQStCOztBQUVwQyxzQkFBSSxTQUFKO0FBQ0Esc0JBQUksTUFBSixDQUFXLElBQUksYUFBYSxDQUE1QixFQUErQixJQUFJLGFBQWEsQ0FBaEQ7QUFDQSxzQkFBSSxNQUFKLENBQVcsSUFBSSxhQUFhLENBQTVCLEVBQStCLElBQUksYUFBYSxDQUFoRDtBQUNBLHNCQUFJLE1BQUosQ0FBVyxDQUFYLEVBQWMsSUFBSSxhQUFhLENBQS9CO0FBQ0Esc0JBQUksU0FBSjs7QUFFQSxzQkFBSSxXQUFKLEVBQ0UsSUFBSSxJQUFKOztBQUVGLHNCQUFJLHFCQUFKLEVBQTJCOztBQUV6Qiw0QkFBSSxDQUFDLGlCQUFMLEVBQXdCO0FBQ3RCLHNDQUFRLElBQUksV0FBWjtBQUNBLGtDQUFJLFdBQUosR0FBa0IsR0FBbEI7QUFDQSxrQ0FBSSxXQUFKLEdBQWtCLE9BQWxCO0FBQ0Esa0NBQUksTUFBSjtBQUNBLGtDQUFJLFdBQUosR0FBa0IsS0FBbEI7QUFDRCx5QkFORCxNQU9FLElBQUksTUFBSjtBQUVIO0FBQ0Qsc0JBQUksU0FBSjtBQUNELGFBeEJNLE1Bd0JBLElBQUksZUFBZSxPQUFuQixFQUE0Qjs7QUFFakMsc0JBQUksV0FBSixHQUFrQixXQUFsQjtBQUNBLDBDQUF3QixhQUFhLENBQXJDO0FBQ0Esc0JBQUksU0FBSixHQUFnQixxQkFBaEI7O0FBRUEsc0JBQUksU0FBSjtBQUNBLHNCQUFJLE1BQUosQ0FBVyxJQUFJLGFBQWEsQ0FBNUIsRUFBK0IsSUFBSSxhQUFhLENBQWhEO0FBQ0Esc0JBQUksTUFBSixDQUFXLElBQUksYUFBYSxDQUE1QixFQUErQixJQUFJLGFBQWEsQ0FBaEQ7QUFDQSxzQkFBSSxNQUFKOztBQUVBLHNCQUFJLE1BQUosQ0FBVyxJQUFJLGFBQWEsQ0FBNUIsRUFBK0IsSUFBSSxhQUFhLENBQWhEO0FBQ0Esc0JBQUksTUFBSixDQUFXLElBQUksYUFBYSxDQUE1QixFQUErQixJQUFJLGFBQWEsQ0FBaEQ7QUFDQSxzQkFBSSxNQUFKO0FBRUQ7QUFHRixPQXJHa0I7QUFzR25CLG1CQUFhLHFCQUFVLE9BQVYsRUFBbUI7QUFDOUIsaUJBQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxRQUFRLE1BQTVCLEVBQW9DLEdBQXBDLEVBQXlDO0FBQ3ZDLHNCQUFJLFNBQVMsUUFBUSxDQUFSLENBQWI7O0FBRUEsK0JBQWEsVUFBYixDQUF3QixPQUFPLENBQS9CLEVBQWtDLE9BQU8sQ0FBekMsRUFBNEMsT0FBTyxHQUFuRCxFQUF3RCxPQUFPLElBQS9ELEVBQXFFLE9BQU8sSUFBNUUsRUFBa0YsT0FBTyxLQUF6RixFQUFnRyxPQUFPLFdBQXZHLEVBQW9ILE9BQU8sZUFBM0g7QUFDRDtBQUNGO0FBQ0Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBbEhtQixDQUFyQjs7a0JBcUhlLFk7Ozs7Ozs7O1FDckhDLE0sR0FBQSxNO1FBTUEsTyxHQUFBLE87UUFNQSxhLEdBQUEsYTtRQWlCQSxlLEdBQUEsZTtRQUlBLEcsR0FBQSxHO1FBZUEsVSxHQUFBLFU7UUFVQSxTLEdBQUEsUztRQW9FQSxjLEdBQUEsYztRQUlBLGlCLEdBQUEsaUI7UUFJQSxtQixHQUFBLG1CO1FBWUEsUSxHQUFBLFE7UUFNQSxRLEdBQUEsUTtRQWlCQSxZLEdBQUEsWTtRQWNBLGUsR0FBQSxlO1FBV0EscUIsR0FBQSxxQjtRQW1EQSxnQixHQUFBLGdCO1FBK0JBLFEsR0FBQSxRO1FBc0JBLFUsR0FBQSxVO1FBd0tBLFksR0FBQSxZO1FBMk5BLFcsR0FBQSxXO1FBMkJBLG1CLEdBQUEsbUI7UUFxQkEsYSxHQUFBLGE7UUEwQ0EsVyxHQUFBLFc7UUFjQSwrQixHQUFBLCtCO1FBTUEsYSxHQUFBLGE7UUErQkEsWSxHQUFBLFk7UUFhQSxZLEdBQUEsWTtRQXVHQSxjLEdBQUEsYztRQWtCQSxJLEdBQUEsSTtRQVNBLEksR0FBQSxJO1FBV0EsZSxHQUFBLGU7UUE2Q0EscUIsR0FBQSxxQjtRQWNBLFEsR0FBQSxRO1FBMkpBLFcsR0FBQSxXO0FBMXFDVCxTQUFTLE1BQVQsQ0FBZ0IsT0FBaEIsRUFBeUIsSUFBekIsRUFBK0I7QUFDcEMsVUFBUSxTQUFSLEdBQW9CLFFBQVEsS0FBSyxTQUFiLENBQXBCO0FBQ0EsVUFBUSxTQUFSLENBQWtCLFdBQWxCLEdBQWdDLE9BQWhDO0FBQ0EsVUFBUSxJQUFSLEdBQWUsS0FBSyxTQUFwQjtBQUNEOztBQUVNLFNBQVMsT0FBVCxDQUFpQixLQUFqQixFQUF3QjtBQUM3QixXQUFTLENBQVQsR0FBYSxDQUFFO0FBQ2YsSUFBRSxTQUFGLEdBQWMsS0FBZDtBQUNBLFNBQU8sSUFBSSxDQUFKLEVBQVA7QUFDRDs7QUFFTSxTQUFTLGFBQVQsQ0FBdUIsUUFBdkIsRUFBaUMsR0FBakMsRUFBc0MsSUFBdEMsRUFBNEM7QUFDakQsTUFBSSxTQUFTLGFBQWIsRUFDRSxTQUFTLGVBQVQsQ0FBeUIsU0FBUyxlQUFULEtBQTZCLElBQUksR0FBMUQsRUFERixLQUVLLElBQUksU0FBUyxRQUFiLEVBQ0gsU0FBUyxVQUFULENBQW9CLFNBQVMsVUFBVCxLQUF3QixJQUFJLEdBQWhELEVBREcsS0FFQSxJQUFJLFNBQVMsUUFBYixFQUNILFNBQVMsVUFBVCxDQUFvQixTQUFTLFVBQVQsS0FBd0IsSUFBSSxHQUFoRCxFQURHLEtBRUEsSUFBSSxTQUFTLE1BQWIsRUFBcUIsU0FBUyxRQUFULENBQWtCLFNBQVMsUUFBVCxLQUFzQixJQUFJLEdBQTVDLEVBQXJCLEtBQ0EsSUFBSSxTQUFTLEtBQWIsRUFBb0IsU0FBUyxPQUFULENBQWlCLFNBQVMsT0FBVCxLQUFxQixJQUFJLEdBQTFDLEVBQXBCLEtBQ0EsSUFBSSxTQUFTLE1BQWIsRUFBcUIsU0FBUyxPQUFULENBQWlCLFNBQVMsT0FBVCxLQUFxQixJQUFJLEdBQTFDLEVBQXJCLEtBQ0EsSUFBSSxTQUFTLE9BQWIsRUFBc0IsU0FBUyxRQUFULENBQWtCLFNBQVMsUUFBVCxLQUFzQixJQUFJLEdBQTVDLEVBQXRCLEtBQ0EsSUFBSSxTQUFTLE1BQWIsRUFDSCxTQUFTLFdBQVQsQ0FBcUIsU0FBUyxXQUFULEtBQXlCLElBQUksR0FBbEQ7O0FBRUYsU0FBTyxRQUFQO0FBQ0Q7O0FBRU0sU0FBUyxlQUFULENBQXlCLEdBQXpCLEVBQThCLElBQTlCLEVBQW9DO0FBQ3pDLFNBQU8sVUFBVSxPQUFPLFVBQWpCLElBQStCLEdBQXRDO0FBQ0Q7O0FBRU0sU0FBUyxHQUFULENBQWEsS0FBYixFQUFvQixNQUFwQixFQUE0QjtBQUNqQyxNQUFJLGFBQWEsS0FBakI7QUFDQSxNQUFJLFFBQVEsQ0FBWixFQUFlO0FBQ2IsaUJBQWEsSUFBYjtBQUNBLGFBQVMsQ0FBQyxDQUFWO0FBQ0Q7O0FBRUQsVUFBUSxLQUFLLEtBQWI7QUFDQSxXQUFTLENBQUMsTUFBRCxHQUFVLENBQVYsR0FBYyxNQUF2Qjs7QUFFQSxTQUFPLE1BQU0sTUFBTixHQUFlLE1BQXRCO0FBQThCLFlBQVEsTUFBTSxLQUFkO0FBQTlCLEdBRUEsT0FBTyxhQUFhLE1BQU0sS0FBbkIsR0FBMkIsS0FBbEM7QUFDRDs7QUFFTSxTQUFTLFVBQVQsQ0FBb0IsR0FBcEIsRUFBeUI7QUFDOUIsTUFBSSxDQUFDLEdBQUwsRUFBVSxPQUFPLEdBQVA7O0FBRVYsUUFBTSxJQUFJLE9BQUosQ0FBWSxRQUFaLEVBQXNCLEVBQXRCLENBQU47QUFDQSxNQUFJLEtBQUssSUFBVDtBQUNBLE1BQUksSUFBSSxJQUFJLE1BQVo7QUFDQSxTQUFPLEdBQUcsSUFBSCxDQUFRLElBQUksTUFBSixDQUFXLEVBQUUsQ0FBYixDQUFSLENBQVAsRUFBaUMsQ0FBRTtBQUNuQyxTQUFPLElBQUksS0FBSixDQUFVLENBQVYsRUFBYSxJQUFJLENBQWpCLENBQVA7QUFDRDs7QUFFTSxTQUFTLFNBQVQsQ0FBbUIsT0FBbkIsRUFBNEI7QUFDakMsVUFBUSxTQUFSLEdBQW9CLFVBQ2xCLENBRGtCLEVBRWxCLENBRmtCLEVBR2xCLEtBSGtCLEVBSWxCLE1BSmtCLEVBS2xCLE1BTGtCLEVBTWxCLGVBTmtCLEVBT2xCLGVBUGtCLEVBUWxCLFdBUmtCLEVBU2xCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSxRQUFJLGVBQUosRUFBcUI7QUFDbkIsV0FBSyxTQUFMLEdBQWlCLGVBQWpCO0FBQ0Q7O0FBRUQsUUFBSSxXQUFKLEVBQWlCO0FBQ2YsV0FBSyxXQUFMLEdBQW1CLFdBQW5CO0FBQ0Q7O0FBRUQ7QUFDQTtBQUNBOztBQUVBLFFBQUksT0FBTyxNQUFQLEtBQWtCLFdBQXRCLEVBQW1DO0FBQ2pDLGVBQVMsQ0FBVDtBQUNEOztBQUVELFNBQUssU0FBTCxHQUFpQixlQUFqQjs7QUFFQSxTQUFLLFNBQUw7QUFDQSxTQUFLLE1BQUwsQ0FBWSxJQUFJLE1BQWhCLEVBQXdCLENBQXhCO0FBQ0EsU0FBSyxNQUFMLENBQVksSUFBSSxLQUFKLEdBQVksTUFBeEIsRUFBZ0MsQ0FBaEM7QUFDQSxTQUFLLGdCQUFMLENBQXNCLElBQUksS0FBMUIsRUFBaUMsQ0FBakMsRUFBb0MsSUFBSSxLQUF4QyxFQUErQyxJQUFJLE1BQW5EO0FBQ0EsU0FBSyxNQUFMLENBQVksSUFBSSxLQUFoQixFQUF1QixJQUFJLE1BQUosR0FBYSxNQUFwQztBQUNBLFNBQUssZ0JBQUwsQ0FDRSxJQUFJLEtBRE4sRUFFRSxJQUFJLE1BRk4sRUFHRSxJQUFJLEtBQUosR0FBWSxNQUhkLEVBSUUsSUFBSSxNQUpOO0FBTUEsU0FBSyxNQUFMLENBQVksSUFBSSxNQUFoQixFQUF3QixJQUFJLE1BQTVCO0FBQ0EsU0FBSyxnQkFBTCxDQUFzQixDQUF0QixFQUF5QixJQUFJLE1BQTdCLEVBQXFDLENBQXJDLEVBQXdDLElBQUksTUFBSixHQUFhLE1BQXJEO0FBQ0EsU0FBSyxNQUFMLENBQVksQ0FBWixFQUFlLElBQUksTUFBbkI7QUFDQSxTQUFLLGdCQUFMLENBQXNCLENBQXRCLEVBQXlCLENBQXpCLEVBQTRCLElBQUksTUFBaEMsRUFBd0MsQ0FBeEM7QUFDQSxTQUFLLFNBQUw7O0FBRUEsUUFBSSxlQUFKLEVBQXFCO0FBQ25CLFdBQUssSUFBTDtBQUNEOztBQUVELFFBQUksZUFBZSxrQkFBa0IsQ0FBckMsRUFBd0M7QUFDdEMsV0FBSyxNQUFMO0FBQ0Q7QUFDRixHQWhFRDtBQWlFRDs7QUFFTSxTQUFTLGNBQVQsQ0FBd0IsQ0FBeEIsRUFBMkIsQ0FBM0IsRUFBOEI7QUFDbkMsU0FBTyxJQUFJLENBQVg7QUFDRDs7QUFFTSxTQUFTLGlCQUFULENBQTJCLFVBQTNCLEVBQXVDLFVBQXZDLEVBQW1EO0FBQ3hELFNBQU8sV0FBVyxDQUFYLEdBQWUsV0FBVyxDQUFqQztBQUNEOztBQUVNLFNBQVMsbUJBQVQsQ0FBNkIsR0FBN0IsRUFBa0M7QUFDdkMsTUFBSSxJQUFJLENBQUMsQ0FBQyxNQUFNLFFBQVAsS0FBb0IsRUFBckIsRUFBeUIsUUFBekIsQ0FBa0MsRUFBbEMsQ0FBUjtBQUNBLE1BQUksSUFBSSxDQUFDLENBQUMsTUFBTSxRQUFQLEtBQW9CLENBQXJCLEVBQXdCLFFBQXhCLENBQWlDLEVBQWpDLENBQVI7QUFDQSxNQUFJLElBQUksQ0FBQyxDQUFDLE1BQU0sUUFBUCxLQUFvQixDQUFyQixFQUF3QixRQUF4QixDQUFpQyxFQUFqQyxDQUFSOztBQUVBLE1BQUksRUFBRSxNQUFGLEdBQVcsQ0FBWCxHQUFlLE1BQU0sQ0FBckIsR0FBeUIsQ0FBN0I7QUFDQSxNQUFJLEVBQUUsTUFBRixHQUFXLENBQVgsR0FBZSxNQUFNLENBQXJCLEdBQXlCLENBQTdCO0FBQ0EsTUFBSSxFQUFFLE1BQUYsR0FBVyxDQUFYLEdBQWUsTUFBTSxDQUFyQixHQUF5QixDQUE3Qjs7QUFFQSxTQUFPLE1BQU0sQ0FBTixHQUFVLENBQVYsR0FBYyxDQUFyQjtBQUNEOztBQUVNLFNBQVMsUUFBVCxDQUFrQixDQUFsQixFQUFxQixDQUFyQixFQUF3QixDQUF4QixFQUEyQjtBQUNoQyxNQUFJLE1BQU8sS0FBSyxFQUFOLEdBQWEsS0FBSyxDQUFsQixHQUF1QixDQUFqQzs7QUFFQSxTQUFPLEdBQVA7QUFDRDs7QUFFTSxTQUFTLFFBQVQsQ0FBa0IsR0FBbEIsRUFBdUI7QUFDNUIsTUFBSSxNQUFNLEVBQVY7QUFDQSxNQUFJLElBQUksQ0FBQyxNQUFNLFFBQVAsS0FBb0IsRUFBNUI7QUFDQSxNQUFJLElBQUksQ0FBQyxNQUFNLFFBQVAsS0FBb0IsQ0FBNUI7QUFDQSxNQUFJLElBQUksQ0FBQyxNQUFNLFFBQVAsS0FBb0IsQ0FBNUI7O0FBRUE7QUFDQTtBQUNBOztBQUVBLE1BQUksQ0FBSixJQUFTLENBQVQ7QUFDQSxNQUFJLENBQUosSUFBUyxDQUFUO0FBQ0EsTUFBSSxDQUFKLElBQVMsQ0FBVDs7QUFFQSxTQUFPLEdBQVA7QUFDRDs7QUFFTSxTQUFTLFlBQVQsQ0FBc0IsR0FBdEIsQ0FBMEIsVUFBMUIsRUFBc0M7QUFDM0MsTUFBSSxNQUFNLEtBQUssTUFBTCxLQUFnQixDQUExQjs7QUFFQSxNQUFJLE9BQU8sT0FBTyxVQUFVLENBQVYsQ0FBUCxLQUF3QixDQUFuQztBQUNBLFNBQU8sT0FBTyxDQUFQLEdBQVcsS0FBSyxJQUFMLENBQVUsSUFBVixDQUFYLEdBQTZCLEtBQUssS0FBTCxDQUFXLElBQVgsQ0FBcEM7QUFDQSxNQUFJLE9BQU8sQ0FBWCxFQUFjLFFBQVEsR0FBUjs7QUFFZCxTQUFPLE9BQU8sR0FBZCxFQUFtQixNQUFuQixFQUEyQjtBQUN6QixRQUFJLFFBQVEsSUFBUixJQUFnQixLQUFLLElBQUwsTUFBZSxHQUFuQyxFQUF3QyxPQUFPLElBQVA7QUFDekM7QUFDRCxTQUFPLENBQUMsQ0FBUjtBQUNEOztBQUVEO0FBQ08sU0FBUyxlQUFULENBQXlCLEdBQXpCLEVBQThCO0FBQ25DLE1BQUksQ0FBQyxJQUFJLE9BQVQsRUFBa0I7QUFDaEIsUUFBSSxPQUFKLEdBQWMsWUFBZDtBQUNEOztBQUVELFNBQU8sR0FBUDtBQUNEOztBQUVELElBQUkscUJBQXFCLEVBQXpCO0FBQ0EsSUFBSSxnQkFBZ0IsSUFBcEI7O0FBRU8sU0FBUyxxQkFBVCxDQUErQixVQUEvQixFQUEyQyxRQUEzQyxFQUFxRCxVQUFyRCxFQUFpRTtBQUN0RTs7QUFFQSxlQUFhLGNBQWMsUUFBM0I7O0FBRUEsTUFBSSxRQUFRLGFBQWEsR0FBYixHQUFtQixRQUFuQixHQUE4QixHQUE5QixHQUFvQyxVQUFoRDtBQUNBLE1BQUksU0FBUyxtQkFBbUIsS0FBbkIsQ0FBYjs7QUFFQSxNQUFJLE1BQU0sTUFBTixDQUFKLEVBQW1CO0FBQ2pCLFFBQUk7QUFDRixVQUFJLFFBQ0Ysc0hBQ0EsY0FEQSxHQUVBLFVBRkEsR0FHQSxJQUhBLEdBSUEsWUFKQSxHQUtBLFFBTEEsR0FNQSxrQkFOQSxHQU9BLFVBUEEsR0FRQSxHQVRGO0FBVUE7QUFDQSxVQUFJLENBQUMsYUFBTCxFQUFvQjtBQUNsQixZQUFJLE9BQU8sU0FBUyxJQUFwQjtBQUNBLHdCQUFnQixTQUFTLGFBQVQsQ0FBdUIsTUFBdkIsQ0FBaEI7QUFDQSxzQkFBYyxTQUFkLEdBQTBCLEVBQTFCO0FBQ0EsWUFBSSxXQUFXLFNBQVMsY0FBVCxDQUF3QixPQUF4QixDQUFmO0FBQ0Esc0JBQWMsV0FBZCxDQUEwQixRQUExQjtBQUNBLGFBQUssV0FBTCxDQUFpQixhQUFqQjtBQUNEOztBQUVELG9CQUFjLEtBQWQsQ0FBb0IsT0FBcEIsR0FBOEIsRUFBOUI7QUFDQSxvQkFBYyxZQUFkLENBQTJCLE9BQTNCLEVBQW9DLEtBQXBDOztBQUVBLGVBQVMsS0FBSyxLQUFMLENBQVcsY0FBYyxZQUF6QixDQUFUO0FBQ0Esb0JBQWMsS0FBZCxDQUFvQixPQUFwQixHQUE4QixNQUE5QjtBQUNBOztBQUVBO0FBQ0E7QUFDRCxLQTlCRCxDQThCRSxPQUFPLENBQVAsRUFBVTtBQUNWLGVBQVMsS0FBSyxJQUFMLENBQVUsV0FBVyxHQUFyQixDQUFUO0FBQ0Q7O0FBRUQsYUFBUyxLQUFLLEdBQUwsQ0FBUyxNQUFULEVBQWlCLFFBQWpCLENBQVQ7O0FBRUEsdUJBQW1CLEtBQW5CLElBQTRCLE1BQTVCO0FBQ0Q7O0FBRUQsU0FBTyxNQUFQO0FBQ0Q7O0FBRU0sU0FBUyxnQkFBVCxDQUEwQixZQUExQixFQUF3QyxhQUF4QyxFQUF1RDtBQUM1RCxpQkFBZSxnQkFBZ0IsT0FBL0I7O0FBRUEsTUFBSSxnQkFBZ0IsRUFBcEI7O0FBRUEsTUFBSSxrQkFBa0I7QUFDcEIsV0FBTyxFQURhO0FBRXBCLGVBQVcsQ0FBQyxDQUFELEVBQUksQ0FBSixDQUZTO0FBR3BCLGNBQVUsQ0FBQyxDQUFELEVBQUksQ0FBSixDQUhVO0FBSXBCLGtCQUFjLENBQUMsQ0FBRCxFQUFJLENBQUosRUFBTyxDQUFQLEVBQVUsQ0FBVixDQUpNO0FBS3BCLHFCQUFpQixDQUFDLENBQUQsRUFBSSxDQUFKLEVBQU8sQ0FBUCxFQUFVLENBQVYsRUFBYSxDQUFiLEVBQWdCLENBQWhCLENBTEc7QUFNcEIsU0FBSyxDQUFDLENBQUQsRUFBSSxDQUFKLENBTmU7QUFPcEIsVUFBTSxDQUFDLENBQUQsRUFBSSxDQUFKLENBUGM7QUFRcEIsYUFBUyxDQUFDLENBQUQsRUFBSSxDQUFKLEVBQU8sQ0FBUCxFQUFVLENBQVYsQ0FSVztBQVNwQixjQUFVLENBQUMsQ0FBRCxFQUFJLENBQUosQ0FUVTtBQVVwQixpQkFBYSxDQUFDLENBQUQsRUFBSSxDQUFKLEVBQU8sQ0FBUCxFQUFVLENBQVYsQ0FWTztBQVdwQixvQkFBZ0IsQ0FBQyxDQUFELEVBQUksQ0FBSixFQUFPLENBQVAsRUFBVSxDQUFWLEVBQWEsQ0FBYixFQUFnQixDQUFoQjtBQVhJLEdBQXRCOztBQWNBLGtCQUFnQixnQkFBZ0IsWUFBaEIsQ0FBaEI7O0FBRUEsTUFBSSxhQUFKLEVBQW1CO0FBQ2pCLFNBQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxjQUFjLE1BQWxDLEVBQTBDLEdBQTFDLEVBQStDO0FBQzdDLG9CQUFjLENBQWQsS0FBb0IsYUFBcEI7QUFDRDtBQUNGLEdBSkQsTUFJTyxnQkFBZ0IsRUFBaEI7O0FBRVAsU0FBTyxhQUFQO0FBQ0Q7O0FBRUQ7QUFDTyxTQUFTLFFBQVQsQ0FBa0IsR0FBbEIsRUFBdUIsU0FBdkIsRUFBa0MsRUFBbEMsRUFBc0MsVUFBdEMsRUFBa0Q7QUFDdkQsTUFBSSxJQUFJLGdCQUFSLEVBQTBCO0FBQ3hCLFFBQUksZ0JBQUosQ0FBcUIsU0FBckIsRUFBZ0MsRUFBaEMsRUFBb0MsY0FBYyxLQUFsRDtBQUNELEdBRkQsTUFFTyxJQUFJLElBQUksV0FBUixFQUFxQjtBQUMxQixRQUFJLFdBQUosQ0FBZ0IsT0FBTyxTQUF2QixFQUFrQyxVQUFTLENBQVQsRUFBWTtBQUM1QyxVQUFJLEtBQUssT0FBTyxLQUFoQjtBQUNBLFFBQUUsY0FBRixHQUNFLEVBQUUsY0FBRixJQUNBLFlBQVc7QUFDVCxVQUFFLFdBQUYsR0FBZ0IsS0FBaEI7QUFDRCxPQUpIO0FBS0EsUUFBRSxlQUFGLEdBQ0UsRUFBRSxlQUFGLElBQ0EsWUFBVztBQUNULFVBQUUsWUFBRixHQUFpQixJQUFqQjtBQUNELE9BSkg7QUFLQSxTQUFHLElBQUgsQ0FBUSxHQUFSLEVBQWEsQ0FBYjtBQUNELEtBYkQ7QUFjRCxHQWZNLE1BZUEsT0FBTyxLQUFQO0FBQ1I7O0FBRUQ7QUFDTyxTQUFTLFVBQVQsR0FBc0I7QUFDM0IsTUFBSSxNQUFNLGlHQUFWOztBQUVBLE1BQUksVUFBVSxDQUNaLFFBRFksRUFFWixRQUZZLEVBR1osU0FIWSxFQUlaLFdBSlksRUFLWixVQUxZLEVBTVosUUFOWSxFQU9aLFVBUFksQ0FBZDtBQVNBLE1BQUksZUFBZSxDQUFDLEtBQUQsRUFBUSxLQUFSLEVBQWUsS0FBZixFQUFzQixLQUF0QixFQUE2QixLQUE3QixFQUFvQyxLQUFwQyxFQUEyQyxLQUEzQyxDQUFuQjs7QUFFQSxNQUFJLFlBQVksQ0FDZCxTQURjLEVBRWQsVUFGYyxFQUdkLE9BSGMsRUFJZCxPQUpjLEVBS2QsS0FMYyxFQU1kLE1BTmMsRUFPZCxNQVBjLEVBUWQsUUFSYyxFQVNkLFdBVGMsRUFVZCxTQVZjLEVBV2QsVUFYYyxFQVlkLFVBWmMsQ0FBaEI7QUFjQSxNQUFJLGlCQUFpQixDQUNuQixLQURtQixFQUVuQixLQUZtQixFQUduQixLQUhtQixFQUluQixLQUptQixFQUtuQixLQUxtQixFQU1uQixLQU5tQixFQU9uQixLQVBtQixFQVFuQixLQVJtQixFQVNuQixLQVRtQixFQVVuQixLQVZtQixFQVduQixLQVhtQixFQVluQixLQVptQixDQUFyQjs7QUFlQSxNQUFJLFdBQVcsc0lBQWY7QUFDQSxNQUFJLGVBQWUsYUFBbkI7O0FBRUEsU0FBTyxVQUFTLEVBQVQsRUFBYSxZQUFiLEVBQTJCLFdBQTNCLEVBQXdDO0FBQzdDLFFBQUksT0FBTyxjQUFjLFlBQVksSUFBMUIsR0FBaUMsT0FBNUM7QUFDQSxRQUFJLFNBQVMsY0FBYyxZQUFZLE1BQTFCLEdBQW1DLFNBQWhEOztBQUVBLFFBQUksWUFBWSxjQUFjLFlBQVksU0FBMUIsR0FBc0MsWUFBdEQ7QUFDQSxRQUFJLGNBQWMsY0FBYyxZQUFZLFdBQTFCLEdBQXdDLGNBQTFEOztBQUVBLFFBQUksU0FBUyxFQUFiO0FBQ0EsUUFBSSxNQUFNLEtBQVY7O0FBRUEsU0FBSyxNQUFNLEdBQUcsT0FBVCxHQUFtQixFQUFuQixHQUF3QixLQUFLLElBQUksSUFBSixDQUFTLEVBQVQsQ0FBTCxHQUFvQixJQUFJLElBQUosRUFBakQ7QUFDQSxRQUFJLE1BQU0sRUFBTixDQUFKLEVBQWUsTUFBTSxZQUFZLGNBQVosQ0FBTjs7QUFFZixRQUFJLGFBQWEsS0FBYixDQUFtQixDQUFuQixFQUFzQixDQUF0QixNQUE2QixNQUFqQyxFQUF5QztBQUN2QyxxQkFBZSxhQUFhLEtBQWIsQ0FBbUIsQ0FBbkIsQ0FBZjtBQUNBLFlBQU0sSUFBTjtBQUNEOztBQUVELFFBQUksTUFBTSxNQUFNLFFBQU4sR0FBaUIsS0FBM0I7QUFDQSxRQUFJLE9BQU8sR0FBRyxNQUFNLE1BQVQsR0FBWDtBQUNBLFFBQUksTUFBTSxHQUFHLE1BQU0sS0FBVCxHQUFWO0FBQ0EsUUFBSSxRQUFRLEdBQUcsTUFBTSxPQUFULEdBQVo7QUFDQSxRQUFJLE9BQU8sR0FBRyxNQUFNLFVBQVQsR0FBWDtBQUNBLFFBQUksUUFBUSxHQUFHLE1BQU0sT0FBVCxHQUFaO0FBQ0EsUUFBSSxVQUFVLEdBQUcsTUFBTSxTQUFULEdBQWQ7QUFDQSxRQUFJLFVBQVUsR0FBRyxNQUFNLFNBQVQsR0FBZDtBQUNBLFFBQUksZUFBZSxHQUFHLE1BQU0sY0FBVCxHQUFuQjtBQUNBLFFBQUksU0FBUyxNQUFNLENBQU4sR0FBVSxHQUFHLGlCQUFILEVBQXZCOztBQUVBLGFBQVMsYUFBYSxPQUFiLENBQXFCLEdBQXJCLEVBQTBCLFVBQVMsR0FBVCxFQUFjO0FBQy9DLGNBQVEsR0FBUjtBQUNFLGFBQUssR0FBTDtBQUNFLGlCQUFPLElBQVA7QUFDRixhQUFLLElBQUw7QUFDRSxpQkFBTyxJQUFJLElBQUosRUFBVSxDQUFWLENBQVA7QUFDRixhQUFLLEtBQUw7QUFDRSxpQkFBTyxVQUFVLEdBQVYsQ0FBUDtBQUNGLGFBQUssTUFBTDtBQUNFLGlCQUFPLEtBQUssR0FBTCxDQUFQOztBQUVGLGFBQUssR0FBTDtBQUNFLGlCQUFPLFFBQVEsQ0FBZjtBQUNGLGFBQUssSUFBTDtBQUNFLGlCQUFPLElBQUksUUFBUSxDQUFaLEVBQWUsQ0FBZixDQUFQO0FBQ0YsYUFBSyxLQUFMO0FBQ0UsaUJBQU8sWUFBWSxLQUFaLENBQVA7QUFDRixhQUFLLE1BQUw7QUFDRSxpQkFBTyxPQUFPLEtBQVAsQ0FBUDs7QUFFRixhQUFLLEdBQUw7QUFDRSxpQkFBTyxTQUFTLE9BQU8sSUFBUCxFQUFhLEtBQWIsQ0FBbUIsQ0FBQyxDQUFwQixDQUFULENBQVA7QUFDRixhQUFLLElBQUw7QUFDRSxpQkFBTyxJQUFJLE9BQU8sSUFBUCxFQUFhLEtBQWIsQ0FBbUIsQ0FBQyxDQUFwQixDQUFKLEVBQTRCLENBQTVCLENBQVA7QUFDRixhQUFLLEtBQUw7QUFDRSxpQkFBTyxJQUFJLE9BQU8sSUFBUCxFQUFhLEtBQWIsQ0FBbUIsQ0FBQyxDQUFwQixDQUFKLEVBQTRCLENBQTVCLENBQVA7QUFDRixhQUFLLE1BQUw7QUFDRSxpQkFBTyxJQUFJLElBQUosRUFBVSxDQUFWLENBQVA7O0FBRUYsYUFBSyxHQUFMO0FBQ0UsaUJBQU8sUUFBUSxFQUFSLElBQWMsRUFBckI7QUFDRixhQUFLLElBQUw7QUFDRSxpQkFBTyxJQUFJLFFBQVEsRUFBUixJQUFjLEVBQWxCLEVBQXNCLENBQXRCLENBQVA7O0FBRUYsYUFBSyxHQUFMO0FBQ0UsaUJBQU8sS0FBUDtBQUNGLGFBQUssSUFBTDtBQUNFLGlCQUFPLElBQUksS0FBSixFQUFXLENBQVgsQ0FBUDs7QUFFRixhQUFLLEdBQUw7QUFDRSxpQkFBTyxPQUFQO0FBQ0YsYUFBSyxJQUFMO0FBQ0UsaUJBQU8sSUFBSSxPQUFKLEVBQWEsQ0FBYixDQUFQOztBQUVGLGFBQUssR0FBTDtBQUNFLGlCQUFPLE9BQVA7QUFDRixhQUFLLElBQUw7QUFDRSxpQkFBTyxJQUFJLE9BQUosRUFBYSxDQUFiLENBQVA7O0FBRUYsYUFBSyxHQUFMO0FBQ0UsaUJBQU8sT0FBTyxZQUFQLEVBQXFCLEtBQXJCLENBQTJCLENBQTNCLEVBQThCLENBQTlCLENBQVA7QUFDRixhQUFLLElBQUw7QUFDRSxpQkFBTyxJQUFJLE9BQU8sWUFBUCxFQUFxQixLQUFyQixDQUEyQixDQUEzQixFQUE4QixDQUE5QixDQUFKLEVBQXNDLENBQXRDLENBQVA7QUFDRixhQUFLLEtBQUw7QUFDRSxpQkFBTyxJQUFJLE9BQU8sWUFBUCxFQUFxQixLQUFyQixDQUEyQixDQUEzQixFQUE4QixDQUE5QixDQUFKLEVBQXNDLENBQXRDLENBQVA7O0FBRUYsYUFBSyxHQUFMO0FBQ0UsaUJBQU8sUUFBUSxFQUFSLEdBQWEsR0FBYixHQUFtQixHQUExQjtBQUNGLGFBQUssSUFBTDtBQUNFLGlCQUFPLFFBQVEsRUFBUixHQUFhLElBQWIsR0FBb0IsSUFBM0I7QUFDRixhQUFLLEdBQUw7QUFDRSxpQkFBTyxRQUFRLEVBQVIsR0FBYSxHQUFiLEdBQW1CLEdBQTFCO0FBQ0YsYUFBSyxJQUFMO0FBQ0UsaUJBQU8sUUFBUSxFQUFSLEdBQWEsSUFBYixHQUFvQixJQUEzQjs7QUFFRixhQUFLLEdBQUw7QUFDRSxpQkFBTyxNQUNILEtBREcsR0FFSCxDQUFDLE9BQU8sRUFBUCxFQUFXLEtBQVgsQ0FBaUIsUUFBakIsS0FBOEIsQ0FBQyxFQUFELENBQS9CLEVBQ0csR0FESCxHQUVHLE9BRkgsQ0FFVyxZQUZYLEVBRXlCLEVBRnpCLENBRkosQ0FqRUosQ0FxRXNDO0FBQ3BDLGFBQUssR0FBTDtBQUNFLGlCQUFPLENBQUMsU0FBUyxDQUFULEdBQWEsR0FBYixHQUFtQixHQUFwQixJQUEyQixLQUFLLEtBQUwsQ0FBVyxLQUFLLEdBQUwsQ0FBUyxNQUFULElBQW1CLEVBQTlCLENBQWxDLENBdkVKLENBdUV5RTtBQUN2RSxhQUFLLElBQUw7QUFDRSxpQkFDRSxDQUFDLFNBQVMsQ0FBVCxHQUFhLEdBQWIsR0FBbUIsR0FBcEIsSUFBMkIsSUFBSSxLQUFLLEtBQUwsQ0FBVyxLQUFLLEdBQUwsQ0FBUyxNQUFULElBQW1CLEVBQTlCLENBQUosRUFBdUMsQ0FBdkMsQ0FEN0IsQ0F6RUosQ0EyRU87QUFDTCxhQUFLLEtBQUw7QUFDRSxpQkFDRSxDQUFDLFNBQVMsQ0FBVCxHQUFhLEdBQWIsR0FBbUIsR0FBcEIsSUFDQSxJQUFJLEtBQUssS0FBTCxDQUFXLEtBQUssR0FBTCxDQUFTLE1BQVQsSUFBbUIsRUFBOUIsQ0FBSixFQUF1QyxDQUF2QyxDQURBLEdBRUEsSUFBSSxLQUFLLEdBQUwsQ0FBUyxNQUFULElBQW1CLEVBQXZCLEVBQTJCLENBQTNCLENBSEYsQ0E3RUosQ0FpRk87O0FBRUw7QUFDRSxpQkFBTyxJQUFJLEtBQUosQ0FBVSxDQUFWLEVBQWEsSUFBSSxNQUFKLEdBQWEsQ0FBMUIsQ0FBUDtBQXBGSjtBQXNGRCxLQXZGUSxDQUFUOztBQXlGQSxXQUFPLE1BQVA7QUFDRCxHQXZIRDtBQXdIRDs7QUFFTSxTQUFTLFlBQVQsQ0FBc0IsQ0FBdEIsRUFBeUIsRUFBekIsRUFBNkIsV0FBN0IsRUFBMEM7QUFDL0MsTUFBSSxNQUFNLElBQVYsRUFBZ0IsT0FBTyxFQUFQOztBQUVoQixNQUFJLE9BQU8sQ0FBUCxDQUFKO0FBQ0EsTUFBSSxhQUFhLElBQUksQ0FBSixHQUFRLElBQVIsR0FBZSxLQUFoQztBQUNBLE1BQUksVUFBSixFQUFnQixLQUFLLENBQUMsQ0FBTjs7QUFFaEIsTUFBSSxtQkFBbUIsY0FBYyxZQUFZLGdCQUExQixHQUE2QyxHQUFwRTtBQUNBLE1BQUksc0JBQXNCLGNBQWMsWUFBWSxtQkFBMUIsR0FBZ0QsR0FBMUU7O0FBRUEsTUFBSSxVQUFVLEVBQWQ7QUFDQSxPQUFLLE9BQU8sRUFBUCxDQUFMO0FBQ0EsTUFBSSxhQUFhLENBQWpCO0FBQ0EsTUFBSSxJQUFKO0FBQ0EsTUFBSSxTQUFTLEVBQWI7O0FBRUEsTUFBSSxVQUFVLEVBQWQ7QUFDQSxNQUFJLGtCQUFrQixDQUFDLENBQXZCO0FBQ0EsTUFBSSxrQkFBa0IsRUFBdEI7QUFDQSxNQUFJLGlCQUFpQixFQUFyQjtBQUNBLE1BQUksb0JBQW9CLENBQXhCLENBcEIrQyxDQW9CcEI7QUFDM0IsTUFBSSxtQkFBbUIsQ0FBdkIsQ0FyQitDLENBcUJyQjtBQUMxQixNQUFJLFVBQVUsQ0FBZDtBQUNBLE1BQUksdUJBQXVCLEtBQTNCO0FBQ0EsTUFBSSxXQUFXLENBQWY7O0FBRUEsWUFBVSxHQUFHLEtBQUgsQ0FBUyw0Q0FBVCxDQUFWO0FBQ0E7QUFDQSxNQUFJLFFBQVEsSUFBWjs7QUFFQSxPQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLFdBQVcsSUFBSSxRQUFRLE1BQXZDLEVBQStDLEdBQS9DLEVBQW9EO0FBQ2xELFlBQVEsUUFBUSxDQUFSLENBQVI7O0FBRUEsUUFBSSxVQUFVLEdBQVYsSUFBaUIsa0JBQWtCLENBQXZDLEVBQTBDO0FBQ3hDLHdCQUFrQixDQUFsQjtBQUNBO0FBQ0QsS0FIRCxNQUdPLElBQUksVUFBVSxHQUFkLEVBQW1CO0FBQ3hCLG9CQUFjLEdBQWQ7QUFDRCxLQUZNLE1BRUEsSUFBSSxVQUFVLEdBQWQsRUFBbUI7QUFDeEIsb0JBQWMsSUFBZDtBQUNBO0FBQ0QsS0FITSxNQUdBLElBQUksTUFBTSxDQUFOLE1BQWEsR0FBYixJQUFvQixNQUFNLE1BQU0sTUFBTixHQUFlLENBQXJCLE1BQTRCLEdBQXBELEVBQXlEO0FBQzlELG9CQUFjLEtBQUssR0FBTCxDQUFTLElBQVQsRUFBZSxNQUFNLE1BQU4sR0FBZSxDQUE5QixDQUFkO0FBQ0Esd0JBQWtCLElBQUksTUFBTSxNQUFWLEdBQW1CLENBQXJDO0FBQ0E7QUFDRCxLQUpNLE1BSUEsSUFDTCxDQUFDLE1BQU0sQ0FBTixNQUFhLEdBQWIsSUFBb0IsTUFBTSxDQUFOLE1BQWEsR0FBbEMsS0FDQSxNQUFNLE1BQU0sTUFBTixHQUFlLENBQXJCLE1BQTRCLEdBRnZCLEVBR0w7QUFDQSw2QkFBdUIsSUFBdkI7QUFDRDs7QUFFRCxRQUFJLGtCQUFrQixDQUF0QixFQUF5QjtBQUN2QixzQkFBZ0IsSUFBaEIsQ0FBcUIsS0FBckI7QUFDQSxVQUFJLFVBQVUsR0FBVixJQUFpQixVQUFVLEdBQS9CLEVBQW9DLG9CQUFwQyxLQUNLLElBQUksVUFBVSxHQUFkLEVBQW1CO0FBQ3pCLEtBSkQsTUFJTztBQUNMLHFCQUFlLElBQWYsQ0FBb0IsS0FBcEI7QUFDQSxVQUFJLFVBQVUsR0FBVixJQUFpQixVQUFVLEdBQS9CLEVBQW9DO0FBQ3JDO0FBQ0Y7O0FBRUQsTUFBSSxvQkFBSixFQUEwQjtBQUN4QixRQUFJLFVBQVUsS0FBSyxLQUFMLENBQVcsQ0FBWCxDQUFkO0FBQ0EsZUFDRSxDQUFDLFlBQVksQ0FBWixHQUFnQixFQUFoQixHQUFxQixPQUFPLE9BQVAsQ0FBdEIsRUFBdUMsTUFBdkMsR0FBZ0QsaUJBRGxEO0FBRUEsa0JBQWMsS0FBSyxHQUFMLENBQVMsRUFBVCxFQUFhLFFBQWIsQ0FBZDtBQUNEOztBQUVELE9BQUssVUFBTDs7QUFFQSxNQUFJLGtCQUFrQixDQUF0QixFQUF5QixrQkFBa0IsQ0FBbEI7O0FBRXpCLFlBQVUsRUFBRSxPQUFGLENBQVUsZ0JBQVYsQ0FBVjtBQUNBLE1BQUksUUFBUSxRQUFRLEtBQVIsQ0FBYyxHQUFkLENBQVo7QUFDQTtBQUNBLE1BQUksdUJBQXVCLENBQUMsTUFBTSxDQUFOLElBQVcsRUFBWixFQUFnQixLQUFoQixDQUFzQixFQUF0QixDQUEzQjtBQUNBLE1BQUksc0JBQXNCLENBQUMsTUFBTSxDQUFOLElBQVcsRUFBWixFQUFnQixLQUFoQixDQUFzQixFQUF0QixDQUExQjs7QUFFQSxNQUFJLHdCQUF3QixxQkFBcUIsQ0FBckIsTUFBNEIsR0FBeEQsRUFDRSxxQkFBcUIsS0FBckI7O0FBRUY7O0FBRUEsTUFBSSxnQkFBZ0IsQ0FBcEI7QUFDQSxNQUFJLGdCQUFnQixDQUFwQjtBQUNBLE1BQUksZUFBZSxDQUFuQjtBQUNBLE1BQUksZ0JBQWdCLENBQXBCO0FBQ0EsTUFBSSx3QkFBd0IsQ0FBNUI7O0FBRUEsU0FBTyxnQkFBZ0IsTUFBaEIsR0FBeUIsQ0FBaEMsRUFBbUM7QUFDakMsWUFBUSxnQkFBZ0IsR0FBaEIsRUFBUjs7QUFFQSxRQUFJLFVBQVUsR0FBVixJQUFpQixVQUFVLEdBQS9CLEVBQW9DO0FBQ2xDOztBQUVBLFVBQUksa0JBQWtCLGlCQUF0QixFQUF5QztBQUN2QyxZQUFJLFNBQVMsb0JBQWI7QUFDQSwrQkFBdUIsRUFBdkI7O0FBRUEsWUFBSSxVQUFVLEdBQWQsRUFBbUI7QUFDakI7QUFDQSxjQUFJLFFBQ0Ysb0JBQW9CLGFBQXBCLElBQXFDLFNBQVMsT0FBTyxNQUFoQixHQUF5QixDQUE5RCxDQURGOztBQUdBLGlCQUFPLFFBQVEsQ0FBZixFQUFrQjtBQUNoQixtQkFBTyxPQUFQLENBQWUsR0FBZjtBQUNBO0FBQ0Q7QUFDRjs7QUFFRCxlQUFPLE9BQU8sTUFBUCxHQUFnQixDQUF2QixFQUEwQjtBQUN4QixtQkFBUyxPQUFPLEdBQVAsS0FBZSxNQUF4QjtBQUNBOztBQUVBLGNBQ0Usd0JBQXdCLGFBQXhCLEtBQTBDLENBQTFDLElBQ0EsaUJBQWlCLE9BRGpCLElBRUEsT0FBTyxNQUFQLEdBQWdCLENBSGxCLEVBS0UsU0FBUyxzQkFBc0IsTUFBL0I7QUFDSDs7QUFFRCxZQUFJLFVBQUosRUFBZ0IsU0FBUyxNQUFNLE1BQWY7QUFDakIsT0E1QkQsTUE0Qk87QUFDTCxZQUFJLHFCQUFxQixNQUFyQixHQUE4QixDQUFsQyxFQUFxQztBQUNuQyxtQkFBUyxxQkFBcUIsR0FBckIsS0FBNkIsTUFBdEM7QUFDQTtBQUNBO0FBQ0QsU0FKRCxNQUlPLElBQUksVUFBVSxHQUFkLEVBQW1CO0FBQ3hCLG1CQUFTLE1BQU0sTUFBZjtBQUNBO0FBQ0E7QUFDRDs7QUFFRCxZQUNFLHdCQUF3QixhQUF4QixLQUEwQyxDQUExQyxJQUNBLGlCQUFpQixPQURqQixJQUVBLHFCQUFxQixNQUFyQixHQUE4QixDQUhoQyxFQUtFLFNBQVMsc0JBQXNCLE1BQS9CO0FBQ0g7QUFDRixLQWpERCxNQWlETyxJQUNMLENBQUMsTUFBTSxDQUFOLE1BQWEsR0FBYixJQUFvQixNQUFNLENBQU4sTUFBYSxHQUFsQyxLQUNBLE1BQU0sTUFBTSxNQUFOLEdBQWUsQ0FBckIsTUFBNEIsR0FENUIsSUFFQSxnQkFBZ0IsSUFBaEIsQ0FBcUIsS0FBckIsQ0FISyxFQUlMO0FBQ0EsVUFBSSxXQUFXLENBQWYsRUFBa0IsUUFBUSxNQUFNLE9BQU4sQ0FBYyxHQUFkLEVBQW1CLEVBQW5CLEVBQXVCLE9BQXZCLENBQStCLEdBQS9CLEVBQW9DLEVBQXBDLENBQVIsQ0FBbEIsS0FDSyxRQUFRLE1BQU0sT0FBTixDQUFjLEdBQWQsRUFBbUIsRUFBbkIsQ0FBUjs7QUFFTCxnQkFBVSxNQUFNLE9BQU4sQ0FBYyxNQUFkLEVBQXNCLFVBQVMsRUFBVCxFQUFhO0FBQzNDLGVBQU8sSUFBSSxRQUFKLEVBQWMsR0FBRyxNQUFqQixDQUFQO0FBQ0QsT0FGUyxDQUFWO0FBR0QsS0FYTSxNQVdBO0FBQ0wsVUFBSSxVQUFVLEdBQWQsRUFBbUI7QUFDakI7QUFDQSx3QkFBZ0IscUJBQWhCO0FBQ0EsZ0NBQXdCLENBQXhCOztBQUVBLFlBQUkscUJBQXFCLE1BQXJCLEdBQThCLENBQWxDLEVBQ0UsU0FBUyxzQkFBc0IsTUFBL0I7QUFDSCxPQVBELE1BT08sSUFDTCxNQUFNLE1BQU4sR0FBZSxDQUFmLEtBQ0UsTUFBTSxDQUFOLE1BQWEsR0FBYixJQUFvQixNQUFNLE1BQU0sTUFBTixHQUFlLENBQXJCLE1BQTRCLEdBQWpELElBQ0UsTUFBTSxDQUFOLE1BQWEsR0FBYixJQUFvQixNQUFNLE1BQU0sTUFBTixHQUFlLENBQXJCLE1BQTRCLEdBRm5ELENBREssRUFJTDtBQUNBLGlCQUFTLE1BQU0sS0FBTixDQUFZLENBQVosRUFBZSxNQUFNLE1BQU4sR0FBZSxDQUE5QixJQUFtQyxNQUE1QztBQUNELE9BTk0sTUFNQSxTQUFTLFFBQVEsTUFBakI7QUFDUjtBQUNGOztBQUVELE1BQUksWUFBWSxDQUFoQjtBQUNBLE1BQUkscUJBQXFCLEVBQXpCO0FBQ0EsTUFBSSxzQkFBc0IsS0FBMUI7O0FBRUEsU0FBTyxlQUFlLE1BQWYsR0FBd0IsQ0FBL0IsRUFBa0M7QUFDaEMsWUFBUSxlQUFlLEtBQWYsRUFBUjs7QUFFQSxRQUFJLFVBQVUsR0FBVixJQUFpQixVQUFVLEdBQS9CLEVBQW9DO0FBQ2xDLFVBQ0Usb0JBQW9CLE1BQXBCLEdBQTZCLENBQTdCLElBQ0EsT0FBTyxvQkFBb0IsSUFBcEIsQ0FBeUIsRUFBekIsQ0FBUCxNQUF5QyxDQUYzQyxFQUdFO0FBQ0EsOEJBQXNCLG9CQUFvQixLQUFwQixFQUF0QjtBQUNBLDhCQUFzQixJQUF0QjtBQUNELE9BTkQsTUFNTyxJQUFJLFVBQVUsR0FBZCxFQUFtQjtBQUN4Qiw4QkFBc0IsR0FBdEI7QUFDQSw4QkFBc0IsSUFBdEI7QUFDRDtBQUNGLEtBWEQsTUFXTyxJQUNMLE1BQU0sTUFBTixHQUFlLENBQWYsS0FDRSxNQUFNLENBQU4sTUFBYSxHQUFiLElBQW9CLE1BQU0sTUFBTSxNQUFOLEdBQWUsQ0FBckIsTUFBNEIsR0FBakQsSUFDRSxNQUFNLENBQU4sTUFBYSxHQUFiLElBQW9CLE1BQU0sTUFBTSxNQUFOLEdBQWUsQ0FBckIsTUFBNEIsR0FGbkQsQ0FESyxFQUlMO0FBQ0EsNEJBQXNCLE1BQU0sS0FBTixDQUFZLENBQVosRUFBZSxNQUFNLE1BQU4sR0FBZSxDQUE5QixDQUF0QjtBQUNBO0FBQ0QsS0FQTSxNQU9BLElBQ0wsQ0FBQyxNQUFNLENBQU4sTUFBYSxHQUFiLElBQW9CLE1BQU0sQ0FBTixNQUFhLEdBQWxDLEtBQ0EsTUFBTSxNQUFNLE1BQU4sR0FBZSxDQUFyQixNQUE0QixHQUQ1QixJQUVBLGdCQUFnQixJQUFoQixDQUFxQixLQUFyQixDQUhLLEVBSUw7QUFDQSxVQUFJLFdBQVcsQ0FBZixFQUFrQixRQUFRLE1BQU0sT0FBTixDQUFjLEdBQWQsRUFBbUIsRUFBbkIsRUFBdUIsT0FBdkIsQ0FBK0IsR0FBL0IsRUFBb0MsRUFBcEMsQ0FBUixDQUFsQixLQUNLLFFBQVEsTUFBTSxPQUFOLENBQWMsR0FBZCxFQUFtQixFQUFuQixDQUFSO0FBQ0wsNEJBQXNCLE1BQU0sT0FBTixDQUFjLE1BQWQsRUFBc0IsVUFBUyxFQUFULEVBQWE7QUFDdkQsZUFBTyxJQUFJLFFBQUosRUFBYyxHQUFHLE1BQWpCLENBQVA7QUFDRCxPQUZxQixDQUF0QjtBQUdELEtBVk0sTUFVQTtBQUNMLDRCQUFzQixLQUF0QjtBQUNBO0FBQ0Q7QUFDRjs7QUFFRCxZQUFVLENBQUMsc0JBQXNCLGdCQUF0QixHQUF5QyxFQUExQyxJQUFnRCxrQkFBMUQ7QUFDQTtBQUNBLFNBQU8sTUFBUDtBQUNEOztBQUVEOztBQUVPLFNBQVMsV0FBVCxDQUFxQixDQUFyQixFQUF3QixDQUF4QixFQUEyQixHQUEzQixFQUFnQztBQUNyQyxPQUFLLDRCQUFMO0FBQ0EsT0FBSyw0QkFBTDtBQUNBLE1BQUksU0FBUyxJQUFJLFlBQUosQ0FBaUIsQ0FBakIsRUFBb0IsQ0FBcEIsRUFBdUIsQ0FBdkIsRUFBMEIsQ0FBMUIsRUFBNkIsSUFBMUM7QUFDQSxNQUFJLFdBQVcsSUFBZjs7QUFFQSxPQUFLLElBQUksSUFBSSxDQUFiLEVBQWdCLElBQUksQ0FBcEIsRUFBdUIsR0FBdkIsRUFBNEI7QUFDMUIsUUFDRyxPQUFPLENBQVAsTUFBYyxPQUFPLElBQUksQ0FBWCxDQUFmLEdBQ0MsT0FBTyxDQUFQLE1BQWMsT0FBTyxJQUFJLENBQVgsQ0FEZixHQUVDLE9BQU8sQ0FBUCxNQUFjLE9BQU8sSUFBSSxFQUFYLENBSGpCLEVBSUU7QUFDQSxpQkFBVyxLQUFYO0FBQ0E7QUFDRDtBQUNGOztBQUVELE1BQUksUUFBSixFQUFjO0FBQ1osV0FBTyxTQUFTLE9BQU8sQ0FBUCxDQUFULEVBQW9CLE9BQU8sQ0FBUCxDQUFwQixFQUErQixPQUFPLENBQVAsQ0FBL0IsQ0FBUDtBQUNELEdBRkQsTUFFTztBQUNMLFdBQU8sQ0FBUDtBQUNEOztBQUVEO0FBQ0Q7O0FBRUQ7QUFDTyxTQUFTLG1CQUFULENBQTZCLEVBQTdCLEVBQWlDO0FBQ3RDLE1BQUksSUFBSSxDQUFSO0FBQ0EsTUFBSSxJQUFJLENBQVI7O0FBRUEsT0FBSyxNQUFNLE9BQU8sS0FBbEI7O0FBRUEsTUFBSSxHQUFHLE9BQUgsSUFBYyxHQUFHLE9BQUgsS0FBZSxDQUFqQyxFQUFvQztBQUNsQyxRQUFJLEdBQUcsT0FBUDtBQUNBLFFBQUksR0FBRyxPQUFQO0FBQ0QsR0FIRCxNQUdPLElBQUksR0FBRyxNQUFILElBQWEsR0FBRyxNQUFILElBQWEsQ0FBOUIsRUFBaUM7QUFDdEM7QUFDQSxRQUFJLEdBQUcsTUFBUDtBQUNBLFFBQUksR0FBRyxNQUFQO0FBQ0QsR0FKTSxNQUlBO0FBQ0wsUUFBSSxHQUFHLEtBQUgsR0FBVyxHQUFHLE1BQUgsQ0FBVSxVQUF6QjtBQUNBLFFBQUksR0FBRyxLQUFILEdBQVcsR0FBRyxNQUFILENBQVUsU0FBekI7QUFDRDs7QUFFRCxTQUFPLEVBQUUsR0FBRyxDQUFMLEVBQVEsR0FBRyxDQUFYLEVBQVA7QUFDRDs7QUFFTSxTQUFTLGFBQVQsQ0FBdUIsTUFBdkIsRUFBK0IsTUFBL0IsRUFBdUMsY0FBdkMsRUFBdUQ7QUFDNUQsTUFBSSxhQUFhLEVBQWpCOztBQUVBLE1BQUksa0JBQWtCLFNBQVMsU0FBUyxXQUFsQixHQUFnQyxXQUF0RDtBQUNBLE1BQUksbUJBQW1CLFNBQVMsU0FBUyxZQUFsQixHQUFpQyxZQUF4RDtBQUNBLE1BQUksaUJBQWlCLFNBQVMsU0FBUyxVQUFsQixHQUErQixVQUFwRDtBQUNBLE1BQUksbUJBQW1CLFNBQVMsU0FBUyxZQUFsQixHQUFpQyxZQUF4RDs7QUFFQSxnQkFBYyxPQUFPLGVBQVAsSUFDVixPQUFPLGVBQVAsSUFBMEIsR0FEaEIsR0FFVixrQkFBa0IsZUFBZSxlQUFmLENBQWxCLEdBQ0EsZUFBZSxlQUFmLElBQWtDLEdBRGxDLEdBRUEsRUFKSjtBQUtBLGdCQUFjLE9BQU8sZ0JBQVAsSUFDVixPQUFPLGdCQUFQLElBQTJCLEdBRGpCLEdBRVYsa0JBQWtCLGVBQWUsZ0JBQWYsQ0FBbEIsR0FDQSxlQUFlLGdCQUFmLElBQW1DLEdBRG5DLEdBRUEsRUFKSjtBQUtBLGdCQUFjLE9BQU8sY0FBUCxJQUNWLE9BQU8sY0FBUCxJQUF5QixLQURmLEdBRVYsa0JBQWtCLGVBQWUsY0FBZixDQUFsQixHQUNBLGVBQWUsY0FBZixJQUFpQyxLQURqQyxHQUVBLEVBSko7O0FBTUEsTUFBSSxhQUFhLE9BQU8sZ0JBQVAsSUFDYixPQUFPLGdCQUFQLElBQTJCLEVBRGQsR0FFYixrQkFBa0IsZUFBZSxnQkFBZixDQUFsQixHQUNBLGVBQWUsZ0JBQWYsSUFBbUMsRUFEbkMsR0FFQSxFQUpKOztBQU1BLE1BQUksQ0FBQyxpQkFBRCxJQUFzQixVQUExQixFQUFzQztBQUNwQyxRQUFJLGtCQUFrQixXQUFXLEtBQVgsQ0FBaUIsR0FBakIsRUFBc0IsQ0FBdEIsQ0FBdEI7O0FBRUEsUUFBSSxnQkFBZ0IsQ0FBaEIsTUFBdUIsR0FBdkIsSUFBOEIsZ0JBQWdCLENBQWhCLE1BQXVCLEdBQXpELEVBQ0Usa0JBQWtCLE1BQU0sZUFBTixHQUF3QixHQUExQzs7QUFFRixrQkFBYyxlQUFkO0FBQ0QsR0FQRCxNQU9PLGNBQWMsVUFBZDs7QUFFUCxTQUFPLFVBQVA7QUFDRDs7QUFFTSxTQUFTLFdBQVQsQ0FBcUIsWUFBckIsRUFBbUMsTUFBbkMsRUFBMkMsY0FBM0MsRUFBMkQ7QUFDaEUsTUFBSSxRQUNGLGdCQUFnQixNQUFoQixHQUNJLE9BQU8sWUFBUCxDQURKLEdBRUksZUFBZSxZQUFmLENBSE47O0FBS0EsU0FBTyxLQUFQO0FBQ0Q7O0FBRUQsSUFBSSxtQkFBbUIsSUFBdkI7QUFDQTtBQUNBLElBQUksbUJBQW1CLE9BQU8sZ0JBQVAsSUFBMkIsQ0FBbEQ7QUFDQSxJQUFJLG9CQUFvQixDQUF4Qjs7QUFFTyxTQUFTLCtCQUFULEdBQTJDO0FBQ2hELFNBQU8sbUJBQW1CLG1CQUFtQixpQkFBdEMsR0FBMEQsQ0FBakU7QUFDRDs7QUFFRCxJQUFJLCtCQUErQixpQ0FBbkM7O0FBRU8sU0FBUyxhQUFULENBQXVCLE1BQXZCLEVBQStCLEtBQS9CLEVBQXNDLE1BQXRDLEVBQThDO0FBQ25ELE1BQUkscUJBQXFCLENBQUMsQ0FBQyxnQkFBM0IsRUFBNkM7QUFDM0MsUUFBSSxNQUFNLE9BQU8sVUFBUCxDQUFrQixJQUFsQixDQUFWO0FBQ0Esd0JBQ0UsSUFBSSw0QkFBSixJQUNBLElBQUkseUJBREosSUFFQSxJQUFJLHdCQUZKLElBR0EsSUFBSSx1QkFISixJQUlBLElBQUksc0JBSkosSUFLQSxDQU5GOztBQVFBLG1DQUErQixpQ0FBL0I7O0FBRUEsV0FBTyxLQUFQLEdBQWUsUUFBUSw0QkFBdkI7QUFDQSxXQUFPLE1BQVAsR0FBZ0IsU0FBUyw0QkFBekI7O0FBRUEsUUFBSSxxQkFBcUIsaUJBQXpCLEVBQTRDO0FBQzFDLGFBQU8sS0FBUCxDQUFhLEtBQWIsR0FBcUIsUUFBUSxJQUE3QjtBQUNBLGFBQU8sS0FBUCxDQUFhLE1BQWIsR0FBc0IsU0FBUyxJQUEvQjs7QUFFQSxVQUFJLEtBQUosQ0FBVSw0QkFBVixFQUF3Qyw0QkFBeEM7QUFDRDs7QUFFRDtBQUNBO0FBQ0QsR0F4QkQsTUF3Qk87QUFDTCxXQUFPLEtBQVAsR0FBZSxLQUFmO0FBQ0EsV0FBTyxNQUFQLEdBQWdCLE1BQWhCO0FBQ0Q7QUFDRjs7QUFFTSxTQUFTLFlBQVQsQ0FBc0IsS0FBdEIsRUFBNkIsTUFBN0IsRUFBcUM7QUFDMUMsTUFBSSxTQUFTLFNBQVMsYUFBVCxDQUF1QixRQUF2QixDQUFiO0FBQ0EsU0FBTyxZQUFQLENBQW9CLE9BQXBCLEVBQTZCLHVCQUE3Qjs7QUFFQSxnQkFBYyxNQUFkLEVBQXNCLEtBQXRCLEVBQTZCLE1BQTdCOztBQUVBLE1BQUksQ0FBQyxpQkFBRCxJQUFzQixPQUFPLGtCQUFQLEtBQThCLFdBQXhELEVBQXFFO0FBQ25FLHVCQUFtQixXQUFuQixDQUErQixNQUEvQjtBQUNEOztBQUVELFNBQU8sTUFBUDtBQUNEOztBQUVNLFNBQVMsWUFBVCxDQUFzQixNQUF0QixFQUE4QixNQUE5QixFQUFzQyxRQUF0QyxFQUFnRDtBQUNyRCxNQUFJLENBQUMsTUFBRCxJQUFXLENBQUMsTUFBWixJQUFzQixDQUFDLFFBQTNCLEVBQXFDOztBQUVyQyxNQUFJLGVBQWUsV0FBVyxHQUFYLElBQWtCLFdBQVcsTUFBWCxHQUFvQixLQUFwQixHQUE0QixNQUE5QyxDQUFuQjtBQUNBLE1BQUksV0FBVyxXQUFXLE1BQTFCO0FBQ0EsTUFBSSxNQUFNLE9BQU8sU0FBUCxDQUFpQixRQUFqQixDQUFWO0FBQ0EsTUFBSSxRQUFRLEtBQVo7O0FBRUEsTUFBSSxlQUFlLFNBQVMsYUFBVCxDQUF1QixHQUF2QixDQUFuQjtBQUNBLGVBQWEsUUFBYixHQUF3QixZQUF4QjtBQUNBLGVBQWEsSUFBYixHQUFvQixHQUFwQjtBQUNBLGVBQWEsTUFBYixHQUFzQixRQUF0QjtBQUNBLE1BQUksQ0FBSjs7QUFFQSxNQUFJLE9BQU8sSUFBUCxLQUFnQixXQUFoQixJQUErQixDQUFDLENBQUMsSUFBSSxJQUFKLEVBQXJDLEVBQWlEO0FBQy9DO0FBQ0EsUUFBSSxVQUFVLElBQUksT0FBSixDQUFZLHVCQUFaLEVBQXFDLEVBQXJDLENBQWQ7O0FBRUEsUUFBSSxhQUFhLEtBQUssT0FBTCxDQUFqQjtBQUNBLFFBQUksU0FBUyxJQUFJLFdBQUosQ0FBZ0IsV0FBVyxNQUEzQixDQUFiO0FBQ0EsUUFBSSxXQUFXLElBQUksVUFBSixDQUFlLE1BQWYsQ0FBZjtBQUNBLFNBQUssSUFBSSxJQUFJLENBQWIsRUFBZ0IsSUFBSSxXQUFXLE1BQS9CLEVBQXVDLEdBQXZDLEVBQTRDO0FBQzFDLGVBQVMsQ0FBVCxJQUFjLFdBQVcsVUFBWCxDQUFzQixDQUF0QixDQUFkO0FBQ0Q7O0FBRUQsUUFBSSxPQUFPLElBQUksSUFBSixDQUFTLENBQUMsTUFBRCxDQUFULEVBQW1CLEVBQUUsTUFBTSxXQUFXLE1BQW5CLEVBQW5CLENBQVg7O0FBRUE7QUFDQSxRQUFJO0FBQ0YsYUFBTyxTQUFQLENBQWlCLFVBQWpCLENBQTRCLElBQTVCLEVBQWtDLFlBQWxDO0FBQ0EsY0FBUSxJQUFSO0FBQ0QsS0FIRCxDQUdFLE9BQU8sQ0FBUCxFQUFVO0FBQ1YsbUJBQWEsT0FBYixDQUFxQixXQUFyQixHQUFtQyxDQUNqQyxRQURpQyxFQUVqQyxhQUFhLFFBRm9CLEVBR2pDLGFBQWEsSUFIb0IsRUFJakMsSUFKaUMsQ0FJNUIsR0FKNEIsQ0FBbkM7QUFLQSxtQkFBYSxJQUFiLEdBQW9CLE9BQU8sR0FBUCxDQUFXLGVBQVgsQ0FBMkIsSUFBM0IsQ0FBcEI7QUFDRDtBQUNGOztBQUVELE1BQUksQ0FBQyxLQUFMLEVBQVk7QUFDVixRQUFJO0FBQ0YsY0FBUSxTQUFTLFdBQVQsQ0FBcUIsYUFBckIsQ0FBUjs7QUFFQSxZQUFNLGNBQU4sQ0FDRSxPQURGLEVBRUUsSUFGRixFQUdFLEtBSEYsRUFJRSxNQUpGLEVBS0UsQ0FMRixFQU1FLENBTkYsRUFPRSxDQVBGLEVBUUUsQ0FSRixFQVNFLENBVEYsRUFVRSxLQVZGLEVBV0UsS0FYRixFQVlFLEtBWkYsRUFhRSxLQWJGLEVBY0UsQ0FkRixFQWVFLElBZkY7O0FBa0JBLFVBQUksYUFBYSxhQUFqQixFQUFnQztBQUM5QjtBQUNBLHFCQUFhLGFBQWIsQ0FBMkIsS0FBM0I7QUFDRCxPQUhELE1BR08sSUFBSSxhQUFhLFNBQWpCLEVBQTRCO0FBQ2pDO0FBQ0EscUJBQWEsU0FBYixDQUF1QixTQUF2QjtBQUNEO0FBQ0YsS0E1QkQsQ0E0QkUsT0FBTyxDQUFQLEVBQVU7QUFDVixVQUFJLE1BQU0sT0FBTyxJQUFQLEVBQVY7QUFDQTtBQUNBO0FBQ0EsVUFBSSxRQUFKLENBQWEsS0FBYixDQUNFLGVBQ0UsR0FERixHQUVFLCtFQUhKO0FBS0EsVUFBSSxRQUFKLENBQWEsS0FBYjtBQUNEO0FBQ0Y7QUFDRjs7QUFFRCxJQUFJLGVBQWU7QUFDakIsU0FBTztBQUNMLFdBQ0U7QUFGRyxHQURVO0FBS2pCLE9BQUs7QUFDSCxXQUNFO0FBRkMsR0FMWTtBQVNqQixRQUFNO0FBQ0osV0FDRTtBQUZFLEdBVFc7QUFhakIsUUFBTTtBQUNKLFdBQ0U7QUFGRTtBQWJXLENBQW5COztBQW1CTyxTQUFTLGNBQVQsQ0FBd0IsS0FBeEIsRUFBK0IsTUFBL0IsRUFBdUMsS0FBdkMsRUFBOEM7QUFDbkQsTUFBSSxPQUFPLFlBQVAsQ0FBb0IsT0FBcEIsTUFBaUMsS0FBckMsRUFBNEM7QUFDMUMsV0FBTyxZQUFQLENBQW9CLE9BQXBCLEVBQTZCLEtBQTdCO0FBQ0EsV0FBTyxZQUFQLENBQW9CLE1BQXBCLEVBQTRCLFFBQTVCO0FBQ0EsV0FBTyxLQUFQLENBQWEsUUFBYixHQUF3QixVQUF4QjtBQUNBLFdBQU8sS0FBUCxDQUFhLE1BQWIsR0FBc0IsaUJBQXRCO0FBQ0EsV0FBTyxLQUFQLENBQWEsT0FBYixHQUF1QixpQkFBdkI7QUFDQSxXQUFPLEtBQVAsQ0FBYSxRQUFiLEdBQXdCLE1BQXhCO0FBQ0EsV0FBTyxZQUFQLENBQW9CLE9BQXBCLEVBQTZCLE1BQU0sWUFBTixDQUFtQixRQUFRLE1BQTNCLENBQTdCO0FBQ0EsV0FBTyxTQUFQLEdBQ0Usb0NBQ0EsYUFBYSxLQUFiLEVBQW9CLEtBRHBCLEdBRUEsU0FGQSxHQUdBLE1BQU0sWUFBTixDQUFtQixRQUFRLE1BQTNCLENBSEEsR0FJQSxNQUxGO0FBTUQ7QUFDRjs7QUFFTSxTQUFTLElBQVQsR0FBZ0I7QUFDckIsTUFBSSxVQUFVLElBQWQ7O0FBRUEsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFVBQVUsTUFBOUIsRUFBc0MsR0FBdEMsRUFBMkM7QUFDekMsY0FBVSxVQUFVLENBQVYsQ0FBVjtBQUNBLFFBQUksUUFBUSxLQUFaLEVBQW1CLFFBQVEsS0FBUixDQUFjLE9BQWQsR0FBd0IsUUFBeEI7QUFDcEI7QUFDRjs7QUFFTSxTQUFTLElBQVQsR0FBZ0I7QUFDckIsTUFBSSxVQUFVLElBQWQ7O0FBRUEsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLFVBQVUsTUFBOUIsRUFBc0MsR0FBdEMsRUFBMkM7QUFDekMsY0FBVSxVQUFVLENBQVYsQ0FBVjtBQUNBLFFBQUksV0FBVyxRQUFRLEtBQXZCLEVBQThCLFFBQVEsS0FBUixDQUFjLE9BQWQsR0FBd0IsTUFBeEI7QUFDL0I7QUFDRjs7QUFFTSxJQUFNLGdEQUFvQixDQUFDLENBQUMsU0FBUyxhQUFULENBQXVCLFFBQXZCLEVBQWlDLFVBQTdEOztBQUVBLFNBQVMsZUFBVCxDQUF5QixNQUF6QixFQUFpQyxPQUFqQyxFQUEwQztBQUMvQyxNQUFJLGVBQWUsRUFBbkI7O0FBRUEsT0FBSyxJQUFJLElBQUksQ0FBYixFQUFnQixJQUFJLE9BQU8sTUFBM0IsRUFBbUMsR0FBbkMsRUFBd0M7QUFDdEMsUUFBSSxLQUFLLENBQVQsRUFBWTtBQUNWLG1CQUFhLElBQWIsQ0FBa0IsT0FBTyxDQUFQLENBQWxCO0FBQ0E7QUFDRDs7QUFFRCxRQUFJLEVBQUosRUFBUSxFQUFSLEVBQVksVUFBWjs7QUFFQSxpQkFBYSxJQUFJLENBQWpCO0FBQ0EsU0FBSyxlQUFlLENBQWYsR0FBbUIsQ0FBbkIsR0FBdUIsYUFBYSxDQUF6QztBQUNBLFNBQUssZUFBZSxPQUFPLE1BQVAsR0FBZ0IsQ0FBL0IsR0FBbUMsVUFBbkMsR0FBZ0QsYUFBYSxDQUFsRTs7QUFFQSxRQUFJLE9BQU87QUFDVCxTQUFHLENBQUMsT0FBTyxFQUFQLEVBQVcsQ0FBWCxHQUFlLE9BQU8sRUFBUCxFQUFXLENBQTNCLElBQWdDLE9BRDFCO0FBRVQsU0FBRyxDQUFDLE9BQU8sRUFBUCxFQUFXLENBQVgsR0FBZSxPQUFPLEVBQVAsRUFBVyxDQUEzQixJQUFnQztBQUYxQixLQUFYO0FBSUEsUUFBSSxNQUFNO0FBQ1IsU0FBRyxPQUFPLFVBQVAsRUFBbUIsQ0FBbkIsR0FBdUIsS0FBSyxDQUFMLEdBQVMsQ0FEM0I7QUFFUixTQUFHLE9BQU8sVUFBUCxFQUFtQixDQUFuQixHQUF1QixLQUFLLENBQUwsR0FBUztBQUYzQixLQUFWO0FBSUEsaUJBQWEsYUFBYSxNQUExQixJQUFvQyxHQUFwQzs7QUFFQSxpQkFBYSxDQUFiO0FBQ0EsU0FBSyxlQUFlLENBQWYsR0FBbUIsQ0FBbkIsR0FBdUIsYUFBYSxDQUF6QztBQUNBLFNBQUssZUFBZSxPQUFPLE1BQVAsR0FBZ0IsQ0FBL0IsR0FBbUMsVUFBbkMsR0FBZ0QsYUFBYSxDQUFsRTs7QUFFQSxRQUFJLE9BQU87QUFDVCxTQUFHLENBQUMsT0FBTyxFQUFQLEVBQVcsQ0FBWCxHQUFlLE9BQU8sRUFBUCxFQUFXLENBQTNCLElBQWdDLE9BRDFCO0FBRVQsU0FBRyxDQUFDLE9BQU8sRUFBUCxFQUFXLENBQVgsR0FBZSxPQUFPLEVBQVAsRUFBVyxDQUEzQixJQUFnQztBQUYxQixLQUFYO0FBSUEsUUFBSSxNQUFNO0FBQ1IsU0FBRyxPQUFPLFVBQVAsRUFBbUIsQ0FBbkIsR0FBdUIsS0FBSyxDQUFMLEdBQVMsQ0FEM0I7QUFFUixTQUFHLE9BQU8sVUFBUCxFQUFtQixDQUFuQixHQUF1QixLQUFLLENBQUwsR0FBUztBQUYzQixLQUFWO0FBSUEsaUJBQWEsYUFBYSxNQUExQixJQUFvQyxHQUFwQzs7QUFFQSxpQkFBYSxhQUFhLE1BQTFCLElBQW9DLE9BQU8sQ0FBUCxDQUFwQztBQUNEOztBQUVELFNBQU8sWUFBUDtBQUNEOztBQUVNLFNBQVMscUJBQVQsQ0FBK0IsS0FBL0IsRUFBc0MsY0FBdEMsRUFBc0Q7QUFDM0Q7QUFDQSxNQUFJLFVBQVUsSUFBVixJQUFrQixPQUFPLEtBQVAsS0FBaUIsV0FBdkMsRUFBb0QsT0FBTyxjQUFQOztBQUVwRCxNQUFJLFNBQ0YsV0FBVyxNQUFNLFFBQU4sRUFBWCxLQUNDLE1BQU0sUUFBTixHQUFpQixPQUFqQixDQUF5QixHQUF6QixLQUFpQyxDQUFqQyxHQUFxQyxpQkFBaUIsR0FBdEQsR0FBNEQsQ0FEN0QsQ0FERjs7QUFJQTtBQUNBLE1BQUksQ0FBQyxNQUFNLE1BQU4sQ0FBRCxJQUFrQixVQUFVLGNBQTVCLElBQThDLFVBQVUsQ0FBNUQsRUFBK0QsT0FBTyxNQUFQOztBQUUvRCxTQUFPLGNBQVA7QUFDRDs7QUFFTSxTQUFTLFFBQVQsQ0FDTCxHQURLLEVBRUwsRUFGSyxFQUdMLEVBSEssRUFJTCxFQUpLLEVBS0wsRUFMSyxFQU1MLEtBTkssRUFPTCxlQVBLLEVBUUwsV0FSSyxFQVNMLEdBVEssRUFVTCxNQVZLLEVBV0wsSUFYSyxFQVlMLEtBWkssRUFhTCxXQWJLLEVBY0w7QUFDQSxNQUFJLE9BQU8sV0FBUCxLQUF1QixXQUEzQixFQUF3QyxjQUFjLENBQWQ7O0FBRXhDLG9CQUFrQixtQkFBbUIsQ0FBckM7QUFDQSxnQkFBYyxlQUFlLE9BQTdCO0FBQ0E7QUFDQSxNQUFJLEtBQUssRUFBVDtBQUFBLE1BQ0UsS0FBSyxFQURQO0FBQUEsTUFFRSxLQUFLLEVBRlA7QUFBQSxNQUdFLEtBQUssRUFIUDtBQUFBLE1BSUUsS0FKRjtBQUFBLE1BS0UsS0FMRjtBQU1BLE1BQUksS0FBSyxFQUFMLEdBQVUsRUFBVixJQUFnQixLQUFLLEVBQUwsR0FBVSxFQUE5QixFQUFrQyxJQUFJLGFBQWEsQ0FBakIsQ0FBbEMsS0FDSyxJQUFJLGFBQWEsT0FBTyxLQUFLLEdBQUwsQ0FBUyxLQUFLLEVBQWQsRUFBa0IsS0FBSyxFQUF2QixDQUF4QjtBQUNMO0FBQ0EsTUFBSSxTQUFTLHlCQUFiO0FBQ0EsTUFBSSxTQUFTLDBCQUFiO0FBQ0E7QUFDQSxNQUFJLFNBQVMsS0FBYjs7QUFFQSxNQUFJLFNBQUo7QUFDQSxNQUFJLE1BQUosQ0FBVyxFQUFYLEVBQWUsRUFBZjtBQUNBLE1BQUksSUFBSjtBQUNBLE1BQUksU0FBSixHQUFnQixNQUFoQjs7QUFFQSxNQUFJLFdBQUosR0FBa0IsV0FBbEI7QUFDQSxNQUFJLFFBQUosQ0FBYSxFQUFiLEVBQWlCLEVBQWpCLEVBQXFCLEtBQUssRUFBMUIsRUFBOEIsS0FBSyxFQUFuQztBQUNBLE1BQUksV0FBSixHQUFrQixDQUFsQjs7QUFFQSxNQUFJLGtCQUFrQixDQUF0QixFQUF5QjtBQUN2QixRQUFJLFNBQVMsa0JBQWtCLENBQWxCLEtBQXdCLENBQXhCLEdBQTRCLENBQTVCLEdBQWdDLEdBQTdDO0FBQ0EsUUFBSSxTQUFKO0FBQ0EsUUFBSSxTQUFKLEdBQWdCLGVBQWhCO0FBQ0EsUUFBSSxXQUFKLEdBQWtCLFdBQWxCO0FBQ0EsUUFBSSxNQUFKLENBQVcsRUFBWCxFQUFlLEVBQWY7QUFDQSxRQUFJLElBQUosQ0FDRSxLQUFLLE1BRFAsRUFFRSxLQUFLLE1BRlAsRUFHRSxLQUFLLEVBQUwsR0FBVSxJQUFJLE1BSGhCLEVBSUUsS0FBSyxFQUFMLEdBQVUsSUFBSSxNQUpoQjtBQU1BLFFBQUksTUFBSjtBQUNEOztBQUVELE1BQUksT0FBSjtBQUNBO0FBQ0EsTUFBSSxRQUFRLElBQVosRUFBa0I7QUFDaEI7QUFDQSxRQUFJLElBQUo7QUFDQSxRQUFJLFNBQUo7QUFDQSxRQUFJLE1BQUosQ0FBVyxFQUFYLEVBQWUsRUFBZjtBQUNBLFFBQUksTUFBSixDQUFXLEtBQUssVUFBaEIsRUFBNEIsS0FBSyxVQUFqQztBQUNBLFFBQUksTUFBSixDQUFXLEtBQUssVUFBaEIsRUFBNEIsS0FBSyxVQUFqQztBQUNBLFFBQUksTUFBSixDQUFXLEVBQVgsRUFBZSxFQUFmO0FBQ0EsUUFBSSxTQUFKO0FBQ0EsUUFBSSxNQUFNLElBQUksb0JBQUosQ0FDUixDQUFDLEtBQUssRUFBTixJQUFZLENBREosRUFFUixLQUFLLFVBRkcsRUFHUixDQUFDLEtBQUssRUFBTixJQUFZLENBSEosRUFJUixFQUpRLENBQVY7QUFNQSxRQUFJLFlBQUosQ0FBaUIsQ0FBakIsRUFBb0IsTUFBcEI7QUFDQSxRQUFJLFlBQUosQ0FBaUIsQ0FBakIsRUFBb0IsTUFBcEI7QUFDQSxRQUFJLFNBQUosR0FBZ0IsR0FBaEI7QUFDQSxRQUFJLElBQUo7QUFDQTtBQUNBLFFBQUksT0FBSjtBQUNEOztBQUVELE1BQUksV0FBVyxJQUFmLEVBQXFCO0FBQ25CLFFBQUksSUFBSjtBQUNBLFFBQUksU0FBSjtBQUNBLFFBQUksTUFBSixDQUFXLEVBQVgsRUFBZSxFQUFmO0FBQ0EsUUFBSSxNQUFKLENBQVcsS0FBSyxVQUFoQixFQUE0QixLQUFLLFVBQWpDO0FBQ0EsUUFBSSxNQUFKLENBQVcsS0FBSyxVQUFoQixFQUE0QixLQUFLLFVBQWpDO0FBQ0EsUUFBSSxNQUFKLENBQVcsRUFBWCxFQUFlLEVBQWY7QUFDQSxRQUFJLFNBQUo7QUFDQSxRQUFJLE1BQU0sSUFBSSxvQkFBSixDQUNSLENBQUMsS0FBSyxFQUFOLElBQVksQ0FESixFQUVSLEtBQUssVUFGRyxFQUdSLENBQUMsS0FBSyxFQUFOLElBQVksQ0FISixFQUlSLEVBSlEsQ0FBVjtB