import _getIterator from "../../core-js/get-iterator";
import _Array$isArray from "../../core-js/array/is-array";
import _Symbol$iterator from "../../core-js/symbol/iterator";
import _Symbol from "../../core-js/symbol";
import unsupportedIterableToArray from "./unsupportedIterableToArray";
export default function _createForOfIteratorHelperLoose(o) {
  var i = 0;

  if (typeof _Symbol === "undefined" || o[_Symbol$iterator] == null) {
    if (_Array$isArray(o) || (o = unsupportedIterableToArray(o))) return function () {
      if (i >= o.length) return {
        done: true
      };
      return {
        done: false,
        value: o[i++]
      };
    };
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  i = _getIterator(o);
  return i.next.bind(i);
}