# Bootstrap Academy contributing guide
Thank you for investing your time in contributing to this project! Any contribution you make will be reflected on https://bootstrap.academy/.

In this guide you will get an overview of the contribution workflow from opening a ticket, creating a pull request, reviewing, and merging the pull request.

## Tickets
All tickets are stored as GitHub issues in the [Bootstrap-Academy](https://github.com/Bootstrap-Academy/Bootstrap-Academy/issues) repository. Additionally, there is a [GitHub project](https://github.com/orgs/Bootstrap-Academy/projects/4) to provide a better overview over the currently active tickets.

For each ticket there is also a bounty in Bootstrap Academy Morphcoins which is given to the person who solves the ticket.

### Creating tickets
Before creating a new ticket, please make sure to search if an issue already exists to avoid duplicates.

On the ["New issue" page](https://github.com/Bootstrap-Academy/Bootstrap-Academy/issues/new/choose) please choose an appropriate template and fill it out as accurately as possible. If there is no template which matches the kind of ticket you would like to create, you can just [open a blank issue](https://github.com/Bootstrap-Academy/Bootstrap-Academy/issues/new).

Depending on the severity of the issue you report, you can also receive Morphcoins in the Bootstrap Academy as a reward, so make sure to include your Bootstrap Academy username in your ticket.

After creating your ticket, it is automatically added to the GitHub project and its status is set to "Triage/Draft". We will now review your ticket and maybe ask for some more details. After that, you will receive some Morphcoins as a reward (if you included your Bootstrap Academy username in the ticket) and the ticket status is set to "Todo".

### Solving tickets
To find a ticket to solve, you can have a look at the [GitHub project](https://github.com/orgs/Bootstrap-Academy/projects/4). Once you find an interesting ticket with the "Todo" status, you can just start working on it.

If you chose a more complicated ticket, you can also ask us to assign you to this ticket, so that others can see that this ticket is currently being worked on. But please only do this if you really have the time to solve the ticket (or parts of it) in the near future.

If you have any questions regarding the ticket or need help, don't hesitate to ask!

## Pull Requests
All code contributions are submitted through pull requests (aka PRs).

### Creating Pull Requests
When starting to work on a ticket, you can already create an (at first empty) draft pull request and regularly push your local changes. This allows others to test intermediate versions of your contribution and provide feedback.

In the pull request description don't forget to enter the id of the ticket you are working on as well as your Bootstrap Academy username (if you would like to receive the bounty).

Also make sure to [allow maintainer edits](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/working-with-forks/allowing-changes-to-a-pull-request-branch-created-from-a-fork) in your pull request so the branch can be updated for a merge.

Once you are done solving the ticket and are sure that everything works as described in the ticket, you can mark the pull request as ready for review.

### Reviewing Pull Requests
Everyone can also contribute by reviewing and testing other people's pull requests and by providing feedback or suggesting changes. Note that the focus here should be on pull requests that are marked as ready for review and are not in the draft state anymore. Draft pull requests are still being worked on and are not expected to be complete yet, but for larger tickets intermediate reviews can also be helpful.

After your pull request has been approved, it is merged, the corresponding ticket is closed and you will receive the ticket bounty (if you included your Bootstrap Academy username in the pull request description).
